# Generated by Django 3.1.6 on 2021-02-17 00:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Branch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150)),
            ],
            options={
                'verbose_name': 'Branch',
                'verbose_name_plural': 'Branches',
            },
        ),
        migrations.CreateModel(
            name='Human',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='Name')),
                ('email', models.EmailField(max_length=150, verbose_name='E-Mail')),
                ('master', models.BooleanField(default=False)),
                ('beta', models.BooleanField(default=False)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Mensch',
                'verbose_name_plural': 'Menschen',
            },
        ),
        migrations.CreateModel(
            name='Commit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hash', models.CharField(max_length=40, verbose_name='Id')),
                ('head', models.CharField(max_length=150, verbose_name='Titel')),
                ('body', models.TextField(blank=True, null=True, verbose_name='Beschreibung')),
                ('created_at', models.DateTimeField(blank=True, null=True, verbose_name='Übermittlungsdatum')),
                ('tag_name', models.CharField(blank=True, max_length=150, null=True, verbose_name='Tag-Name')),
                ('executed', models.BooleanField(default=False, help_text='Wurde dieser Comit bereits in einer E-Mail versendet?', verbose_name='Übermittelt')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='changelog.branch')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='changelog.human')),
            ],
            options={
                'ordering': ['-created_at'],
                'unique_together': {('hash', 'branch')},
            },
        ),
    ]
