# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, BinaryIO, Any


class AbolishDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class AbolishDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AbolishDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AbolishDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AbolishDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddProjectMemberToRoleRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        role_code: str = None,
        user_id: str = None,
    ):
        self.client_token = client_token
        self.project_id = project_id
        self.role_code = role_code
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddProjectMemberToRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddProjectMemberToRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddProjectMemberToRoleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddProjectMemberToRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddToMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        table_guid: str = None,
    ):
        self.category_id = category_id
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class AddToMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddToMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddToMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddToMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApprovePermissionApplyOrderRequest(TeaModel):
    def __init__(
        self,
        approve_action: int = None,
        approve_comment: str = None,
        flow_id: str = None,
    ):
        self.approve_action = approve_action
        self.approve_comment = approve_comment
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approve_action is not None:
            result['ApproveAction'] = self.approve_action
        if self.approve_comment is not None:
            result['ApproveComment'] = self.approve_comment
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApproveAction') is not None:
            self.approve_action = m.get('ApproveAction')
        if m.get('ApproveComment') is not None:
            self.approve_comment = m.get('ApproveComment')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class ApprovePermissionApplyOrderResponseBody(TeaModel):
    def __init__(
        self,
        approve_success: bool = None,
        request_id: str = None,
    ):
        self.approve_success = approve_success
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approve_success is not None:
            result['ApproveSuccess'] = self.approve_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApproveSuccess') is not None:
            self.approve_success = m.get('ApproveSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApprovePermissionApplyOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ApprovePermissionApplyOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ApprovePermissionApplyOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckFileDeploymentRequest(TeaModel):
    def __init__(
        self,
        check_detail_url: str = None,
        checker_instance_id: str = None,
        status: str = None,
    ):
        self.check_detail_url = check_detail_url
        self.checker_instance_id = checker_instance_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_detail_url is not None:
            result['CheckDetailUrl'] = self.check_detail_url
        if self.checker_instance_id is not None:
            result['CheckerInstanceId'] = self.checker_instance_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckDetailUrl') is not None:
            self.check_detail_url = m.get('CheckDetailUrl')
        if m.get('CheckerInstanceId') is not None:
            self.checker_instance_id = m.get('CheckerInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CheckFileDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckFileDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckFileDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckFileDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaPartitionRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        partition: str = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.partition = partition
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.partition is not None:
            result['Partition'] = self.partition
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Partition') is not None:
            self.partition = m.get('Partition')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CheckMetaPartitionResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckMetaPartitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckMetaPartitionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckMetaPartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaTableRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CheckMetaTableResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckMetaTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckMetaTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckMetaTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBusinessRequest(TeaModel):
    def __init__(
        self,
        business_name: str = None,
        description: str = None,
        owner: str = None,
        project_id: int = None,
        project_identifier: str = None,
        use_type: str = None,
    ):
        self.business_name = business_name
        self.description = description
        self.owner = owner
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class CreateBusinessResponseBody(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.business_id = business_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConnectionRequest(TeaModel):
    def __init__(
        self,
        connection_type: str = None,
        content: str = None,
        description: str = None,
        env_type: int = None,
        name: str = None,
        project_id: int = None,
        sub_type: str = None,
    ):
        self.connection_type = connection_type
        self.content = content
        self.description = description
        self.env_type = env_type
        self.name = name
        self.project_id = project_id
        self.sub_type = sub_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.name is not None:
            result['Name'] = self.name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        return self


class CreateConnectionResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        http_status_code: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        task_content: str = None,
        task_name: str = None,
        task_param: str = None,
        task_type: str = None,
    ):
        self.client_token = client_token
        self.project_id = project_id
        self.task_content = task_content
        self.task_name = task_name
        self.task_param = task_param
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_content is not None:
            result['TaskContent'] = self.task_content
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskContent') is not None:
            self.task_content = m.get('TaskContent')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        message: str = None,
        status: str = None,
    ):
        self.file_id = file_id
        self.message = message
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateDISyncTaskResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDagComplementRequest(TeaModel):
    def __init__(
        self,
        biz_begin_time: str = None,
        biz_end_time: str = None,
        end_biz_date: str = None,
        exclude_node_ids: str = None,
        include_node_ids: str = None,
        name: str = None,
        node_params: str = None,
        parallelism: bool = None,
        project_env: str = None,
        root_node_id: int = None,
        start_biz_date: str = None,
    ):
        self.biz_begin_time = biz_begin_time
        self.biz_end_time = biz_end_time
        self.end_biz_date = end_biz_date
        self.exclude_node_ids = exclude_node_ids
        self.include_node_ids = include_node_ids
        self.name = name
        self.node_params = node_params
        self.parallelism = parallelism
        self.project_env = project_env
        self.root_node_id = root_node_id
        self.start_biz_date = start_biz_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_begin_time is not None:
            result['BizBeginTime'] = self.biz_begin_time
        if self.biz_end_time is not None:
            result['BizEndTime'] = self.biz_end_time
        if self.end_biz_date is not None:
            result['EndBizDate'] = self.end_biz_date
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.name is not None:
            result['Name'] = self.name
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        if self.parallelism is not None:
            result['Parallelism'] = self.parallelism
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.start_biz_date is not None:
            result['StartBizDate'] = self.start_biz_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizBeginTime') is not None:
            self.biz_begin_time = m.get('BizBeginTime')
        if m.get('BizEndTime') is not None:
            self.biz_end_time = m.get('BizEndTime')
        if m.get('EndBizDate') is not None:
            self.end_biz_date = m.get('EndBizDate')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        if m.get('Parallelism') is not None:
            self.parallelism = m.get('Parallelism')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('StartBizDate') is not None:
            self.start_biz_date = m.get('StartBizDate')
        return self


class CreateDagComplementResponseBody(TeaModel):
    def __init__(
        self,
        data: List[int] = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDagComplementResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDagComplementResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDagComplementResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDagTestRequest(TeaModel):
    def __init__(
        self,
        bizdate: str = None,
        name: str = None,
        node_id: int = None,
        node_params: str = None,
        project_env: str = None,
    ):
        self.bizdate = bizdate
        self.name = name
        self.node_id = node_id
        self.node_params = node_params
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class CreateDagTestResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDagTestResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDagTestResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDagTestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        api_description: str = None,
        api_mode: int = None,
        api_name: str = None,
        api_path: str = None,
        folder_id: int = None,
        group_id: str = None,
        project_id: int = None,
        protocols: str = None,
        registration_details: str = None,
        request_method: int = None,
        response_content_type: int = None,
        script_details: str = None,
        tenant_id: int = None,
        timeout: int = None,
        visible_range: int = None,
        wizard_details: str = None,
    ):
        self.api_description = api_description
        self.api_mode = api_mode
        self.api_name = api_name
        self.api_path = api_path
        self.folder_id = folder_id
        self.group_id = group_id
        self.project_id = project_id
        self.protocols = protocols
        self.registration_details = registration_details
        self.request_method = request_method
        self.response_content_type = response_content_type
        self.script_details = script_details
        self.tenant_id = tenant_id
        self.timeout = timeout
        self.visible_range = visible_range
        self.wizard_details = wizard_details

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_description is not None:
            result['ApiDescription'] = self.api_description
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiDescription') is not None:
            self.api_description = m.get('ApiDescription')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            self.registration_details = m.get('RegistrationDetails')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('ScriptDetails') is not None:
            self.script_details = m.get('ScriptDetails')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('WizardDetails') is not None:
            self.wizard_details = m.get('WizardDetails')
        return self


class CreateDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceApiAuthorityRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        authorized_project_id: int = None,
        end_time: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.authorized_project_id = authorized_project_id
        self.end_time = end_time
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateDataServiceApiAuthorityResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataServiceApiAuthorityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataServiceApiAuthorityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceApiAuthorityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceFolderRequest(TeaModel):
    def __init__(
        self,
        folder_name: str = None,
        group_id: str = None,
        parent_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.folder_name = folder_name
        self.group_id = group_id
        self.parent_id = parent_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateDataServiceFolderResponseBody(TeaModel):
    def __init__(
        self,
        folder_id: int = None,
        request_id: str = None,
    ):
        self.folder_id = folder_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataServiceFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceGroupRequest(TeaModel):
    def __init__(
        self,
        api_gateway_group_id: str = None,
        description: str = None,
        group_name: str = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_gateway_group_id = api_gateway_group_id
        self.description = description
        self.group_name = group_name
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateDataServiceGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        request_id: str = None,
    ):
        self.group_id = group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataServiceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataSourceRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        data_source_type: str = None,
        description: str = None,
        env_type: int = None,
        name: str = None,
        project_id: int = None,
        sub_type: str = None,
    ):
        self.content = content
        self.data_source_type = data_source_type
        self.description = description
        self.env_type = env_type
        self.name = name
        self.project_id = project_id
        self.sub_type = sub_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.description is not None:
            result['Description'] = self.description
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.name is not None:
            result['Name'] = self.name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        return self


class CreateDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        http_status_code: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateExportMigrationRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        export_mode: str = None,
        export_object_status: str = None,
        incremental_since: int = None,
        name: str = None,
        project_id: int = None,
    ):
        self.description = description
        self.export_mode = export_mode
        self.export_object_status = export_object_status
        self.incremental_since = incremental_since
        self.name = name
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.export_mode is not None:
            result['ExportMode'] = self.export_mode
        if self.export_object_status is not None:
            result['ExportObjectStatus'] = self.export_object_status
        if self.incremental_since is not None:
            result['IncrementalSince'] = self.incremental_since
        if self.name is not None:
            result['Name'] = self.name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExportMode') is not None:
            self.export_mode = m.get('ExportMode')
        if m.get('ExportObjectStatus') is not None:
            self.export_object_status = m.get('ExportObjectStatus')
        if m.get('IncrementalSince') is not None:
            self.incremental_since = m.get('IncrementalSince')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class CreateExportMigrationResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateExportMigrationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateExportMigrationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateExportMigrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileRequest(TeaModel):
    def __init__(
        self,
        advanced_settings: str = None,
        auto_parsing: bool = None,
        auto_rerun_interval_millis: int = None,
        auto_rerun_times: int = None,
        connection_name: str = None,
        content: str = None,
        cron_express: str = None,
        cycle_type: str = None,
        dependent_node_id_list: str = None,
        dependent_type: str = None,
        end_effect_date: int = None,
        file_description: str = None,
        file_folder_path: str = None,
        file_name: str = None,
        file_type: int = None,
        input_list: str = None,
        owner: str = None,
        para_value: str = None,
        project_id: int = None,
        project_identifier: str = None,
        rerun_mode: str = None,
        resource_group_id: int = None,
        resource_group_identifier: str = None,
        scheduler_type: str = None,
        start_effect_date: int = None,
        start_immediately: bool = None,
        stop: bool = None,
    ):
        self.advanced_settings = advanced_settings
        self.auto_parsing = auto_parsing
        self.auto_rerun_interval_millis = auto_rerun_interval_millis
        self.auto_rerun_times = auto_rerun_times
        self.connection_name = connection_name
        self.content = content
        self.cron_express = cron_express
        self.cycle_type = cycle_type
        self.dependent_node_id_list = dependent_node_id_list
        self.dependent_type = dependent_type
        self.end_effect_date = end_effect_date
        self.file_description = file_description
        self.file_folder_path = file_folder_path
        self.file_name = file_name
        self.file_type = file_type
        self.input_list = input_list
        self.owner = owner
        self.para_value = para_value
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.rerun_mode = rerun_mode
        self.resource_group_id = resource_group_id
        self.resource_group_identifier = resource_group_identifier
        self.scheduler_type = scheduler_type
        self.start_effect_date = start_effect_date
        self.start_immediately = start_immediately
        self.stop = stop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advanced_settings is not None:
            result['AdvancedSettings'] = self.advanced_settings
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.content is not None:
            result['Content'] = self.content
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        if self.end_effect_date is not None:
            result['EndEffectDate'] = self.end_effect_date
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.input_list is not None:
            result['InputList'] = self.input_list
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_group_identifier is not None:
            result['ResourceGroupIdentifier'] = self.resource_group_identifier
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.start_effect_date is not None:
            result['StartEffectDate'] = self.start_effect_date
        if self.start_immediately is not None:
            result['StartImmediately'] = self.start_immediately
        if self.stop is not None:
            result['Stop'] = self.stop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdvancedSettings') is not None:
            self.advanced_settings = m.get('AdvancedSettings')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        if m.get('EndEffectDate') is not None:
            self.end_effect_date = m.get('EndEffectDate')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('InputList') is not None:
            self.input_list = m.get('InputList')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceGroupIdentifier') is not None:
            self.resource_group_identifier = m.get('ResourceGroupIdentifier')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('StartEffectDate') is not None:
            self.start_effect_date = m.get('StartEffectDate')
        if m.get('StartImmediately') is not None:
            self.start_immediately = m.get('StartImmediately')
        if m.get('Stop') is not None:
            self.stop = m.get('Stop')
        return self


class CreateFileResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFolderRequest(TeaModel):
    def __init__(
        self,
        folder_path: str = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.folder_path = folder_path
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class CreateFolderResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImportMigrationRequest(TeaModel):
    def __init__(
        self,
        calculate_engine_map: str = None,
        commit_rule: str = None,
        description: str = None,
        name: str = None,
        package_file: str = None,
        package_type: str = None,
        project_id: int = None,
        resource_group_map: str = None,
        workspace_map: str = None,
    ):
        self.calculate_engine_map = calculate_engine_map
        self.commit_rule = commit_rule
        self.description = description
        self.name = name
        self.package_file = package_file
        self.package_type = package_type
        self.project_id = project_id
        self.resource_group_map = resource_group_map
        self.workspace_map = workspace_map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.package_file is not None:
            result['PackageFile'] = self.package_file
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageFile') is not None:
            self.package_file = m.get('PackageFile')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        return self


class CreateImportMigrationAdvanceRequest(TeaModel):
    def __init__(
        self,
        package_file_object: BinaryIO = None,
        calculate_engine_map: str = None,
        commit_rule: str = None,
        description: str = None,
        name: str = None,
        package_type: str = None,
        project_id: int = None,
        resource_group_map: str = None,
        workspace_map: str = None,
    ):
        self.package_file_object = package_file_object
        self.calculate_engine_map = calculate_engine_map
        self.commit_rule = commit_rule
        self.description = description
        self.name = name
        self.package_type = package_type
        self.project_id = project_id
        self.resource_group_map = resource_group_map
        self.workspace_map = workspace_map

    def validate(self):
        self.validate_required(self.package_file_object, 'package_file_object')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_file_object is not None:
            result['PackageFileObject'] = self.package_file_object
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackageFileObject') is not None:
            self.package_file_object = m.get('PackageFileObject')
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        return self


class CreateImportMigrationResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateImportMigrationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateImportMigrationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateImportMigrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateManualDagRequest(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        dag_parameters: str = None,
        exclude_node_ids: str = None,
        flow_name: str = None,
        include_node_ids: str = None,
        node_parameters: str = None,
        project_env: str = None,
        project_name: str = None,
    ):
        self.biz_date = biz_date
        self.dag_parameters = dag_parameters
        self.exclude_node_ids = exclude_node_ids
        self.flow_name = flow_name
        self.include_node_ids = include_node_ids
        self.node_parameters = node_parameters
        self.project_env = project_env
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.dag_parameters is not None:
            result['DagParameters'] = self.dag_parameters
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.node_parameters is not None:
            result['NodeParameters'] = self.node_parameters
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DagParameters') is not None:
            self.dag_parameters = m.get('DagParameters')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('NodeParameters') is not None:
            self.node_parameters = m.get('NodeParameters')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class CreateManualDagResponseBody(TeaModel):
    def __init__(
        self,
        dag_id: int = None,
        request_id: str = None,
    ):
        self.dag_id = dag_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateManualDagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateManualDagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateManualDagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        comment: str = None,
        name: str = None,
        parent_id: int = None,
    ):
        self.comment = comment
        self.name = name
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateMetaCategoryResponseBodyData(TeaModel):
    def __init__(
        self,
        category_id: int = None,
    ):
        self.category_id = category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class CreateMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateMetaCategoryResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateMetaCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePermissionApplyOrderRequestApplyObjectColumnMetaList(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePermissionApplyOrderRequestApplyObject(TeaModel):
    def __init__(
        self,
        actions: str = None,
        column_meta_list: List[CreatePermissionApplyOrderRequestApplyObjectColumnMetaList] = None,
        name: str = None,
    ):
        self.actions = actions
        self.column_meta_list = column_meta_list
        self.name = name

    def validate(self):
        if self.column_meta_list:
            for k in self.column_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actions is not None:
            result['Actions'] = self.actions
        result['ColumnMetaList'] = []
        if self.column_meta_list is not None:
            for k in self.column_meta_list:
                result['ColumnMetaList'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Actions') is not None:
            self.actions = m.get('Actions')
        self.column_meta_list = []
        if m.get('ColumnMetaList') is not None:
            for k in m.get('ColumnMetaList'):
                temp_model = CreatePermissionApplyOrderRequestApplyObjectColumnMetaList()
                self.column_meta_list.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePermissionApplyOrderRequest(TeaModel):
    def __init__(
        self,
        apply_object: List[CreatePermissionApplyOrderRequestApplyObject] = None,
        apply_reason: str = None,
        apply_user_ids: str = None,
        deadline: int = None,
        engine_type: str = None,
        max_compute_project_name: str = None,
        order_type: int = None,
        workspace_id: int = None,
    ):
        self.apply_object = apply_object
        self.apply_reason = apply_reason
        self.apply_user_ids = apply_user_ids
        self.deadline = deadline
        self.engine_type = engine_type
        self.max_compute_project_name = max_compute_project_name
        self.order_type = order_type
        self.workspace_id = workspace_id

    def validate(self):
        if self.apply_object:
            for k in self.apply_object:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ApplyObject'] = []
        if self.apply_object is not None:
            for k in self.apply_object:
                result['ApplyObject'].append(k.to_map() if k else None)
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.apply_user_ids is not None:
            result['ApplyUserIds'] = self.apply_user_ids
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.engine_type is not None:
            result['EngineType'] = self.engine_type
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apply_object = []
        if m.get('ApplyObject') is not None:
            for k in m.get('ApplyObject'):
                temp_model = CreatePermissionApplyOrderRequestApplyObject()
                self.apply_object.append(temp_model.from_map(k))
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('ApplyUserIds') is not None:
            self.apply_user_ids = m.get('ApplyUserIds')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('EngineType') is not None:
            self.engine_type = m.get('EngineType')
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreatePermissionApplyOrderResponseBody(TeaModel):
    def __init__(
        self,
        flow_id: List[str] = None,
        request_id: str = None,
    ):
        self.flow_id = flow_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePermissionApplyOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreatePermissionApplyOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreatePermissionApplyOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProjectMemberRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        role_code: str = None,
        user_id: str = None,
    ):
        self.client_token = client_token
        self.project_id = project_id
        self.role_code = role_code
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateProjectMemberResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateProjectMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateProjectMemberResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProjectMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityEntityRequest(TeaModel):
    def __init__(
        self,
        entity_level: int = None,
        env_type: str = None,
        match_expression: str = None,
        project_name: str = None,
        table_name: str = None,
    ):
        self.entity_level = entity_level
        self.env_type = env_type
        self.match_expression = match_expression
        self.project_name = project_name
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_level is not None:
            result['EntityLevel'] = self.entity_level
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityLevel') is not None:
            self.entity_level = m.get('EntityLevel')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CreateQualityEntityResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQualityEntityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityFollowerRequest(TeaModel):
    def __init__(
        self,
        alarm_mode: int = None,
        entity_id: int = None,
        follower: str = None,
        project_name: str = None,
    ):
        self.alarm_mode = alarm_mode
        self.entity_id = entity_id
        self.follower = follower
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_mode is not None:
            result['AlarmMode'] = self.alarm_mode
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.follower is not None:
            result['Follower'] = self.follower
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmMode') is not None:
            self.alarm_mode = m.get('AlarmMode')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Follower') is not None:
            self.follower = m.get('Follower')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class CreateQualityFollowerResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityFollowerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQualityFollowerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRelativeNodeRequest(TeaModel):
    def __init__(
        self,
        env_type: str = None,
        match_expression: str = None,
        node_id: int = None,
        project_id: int = None,
        project_name: str = None,
        table_name: str = None,
        target_node_project_id: int = None,
        target_node_project_name: str = None,
    ):
        self.env_type = env_type
        self.match_expression = match_expression
        self.node_id = node_id
        self.project_id = project_id
        self.project_name = project_name
        self.table_name = table_name
        self.target_node_project_id = target_node_project_id
        self.target_node_project_name = target_node_project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.target_node_project_id is not None:
            result['TargetNodeProjectId'] = self.target_node_project_id
        if self.target_node_project_name is not None:
            result['TargetNodeProjectName'] = self.target_node_project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TargetNodeProjectId') is not None:
            self.target_node_project_id = m.get('TargetNodeProjectId')
        if m.get('TargetNodeProjectName') is not None:
            self.target_node_project_name = m.get('TargetNodeProjectName')
        return self


class CreateQualityRelativeNodeResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityRelativeNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQualityRelativeNodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityRelativeNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRuleRequest(TeaModel):
    def __init__(
        self,
        block_type: int = None,
        checker: int = None,
        comment: str = None,
        critical_threshold: str = None,
        entity_id: int = None,
        expect_value: str = None,
        method_name: str = None,
        operator: str = None,
        predict_type: int = None,
        project_name: str = None,
        property: str = None,
        property_type: str = None,
        rule_name: str = None,
        rule_type: int = None,
        template_id: int = None,
        trend: str = None,
        warning_threshold: str = None,
        where_condition: str = None,
    ):
        self.block_type = block_type
        self.checker = checker
        self.comment = comment
        self.critical_threshold = critical_threshold
        self.entity_id = entity_id
        self.expect_value = expect_value
        self.method_name = method_name
        self.operator = operator
        self.predict_type = predict_type
        self.project_name = project_name
        self.property = property
        self.property_type = property_type
        self.rule_name = rule_name
        self.rule_type = rule_type
        self.template_id = template_id
        self.trend = trend
        self.warning_threshold = warning_threshold
        self.where_condition = where_condition

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_type is not None:
            result['BlockType'] = self.block_type
        if self.checker is not None:
            result['Checker'] = self.checker
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.critical_threshold is not None:
            result['CriticalThreshold'] = self.critical_threshold
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.expect_value is not None:
            result['ExpectValue'] = self.expect_value
        if self.method_name is not None:
            result['MethodName'] = self.method_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.predict_type is not None:
            result['PredictType'] = self.predict_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.property is not None:
            result['Property'] = self.property
        if self.property_type is not None:
            result['PropertyType'] = self.property_type
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trend is not None:
            result['Trend'] = self.trend
        if self.warning_threshold is not None:
            result['WarningThreshold'] = self.warning_threshold
        if self.where_condition is not None:
            result['WhereCondition'] = self.where_condition
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockType') is not None:
            self.block_type = m.get('BlockType')
        if m.get('Checker') is not None:
            self.checker = m.get('Checker')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CriticalThreshold') is not None:
            self.critical_threshold = m.get('CriticalThreshold')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('ExpectValue') is not None:
            self.expect_value = m.get('ExpectValue')
        if m.get('MethodName') is not None:
            self.method_name = m.get('MethodName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('PredictType') is not None:
            self.predict_type = m.get('PredictType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('PropertyType') is not None:
            self.property_type = m.get('PropertyType')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Trend') is not None:
            self.trend = m.get('Trend')
        if m.get('WarningThreshold') is not None:
            self.warning_threshold = m.get('WarningThreshold')
        if m.get('WhereCondition') is not None:
            self.where_condition = m.get('WhereCondition')
        return self


class CreateQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRemindRequest(TeaModel):
    def __init__(
        self,
        alert_interval: int = None,
        alert_methods: str = None,
        alert_targets: str = None,
        alert_unit: str = None,
        baseline_ids: str = None,
        biz_process_ids: str = None,
        detail: str = None,
        dnd_end: str = None,
        max_alert_times: int = None,
        node_ids: str = None,
        project_id: int = None,
        remind_name: str = None,
        remind_type: str = None,
        remind_unit: str = None,
        robot_urls: str = None,
    ):
        self.alert_interval = alert_interval
        self.alert_methods = alert_methods
        self.alert_targets = alert_targets
        self.alert_unit = alert_unit
        self.baseline_ids = baseline_ids
        self.biz_process_ids = biz_process_ids
        self.detail = detail
        self.dnd_end = dnd_end
        self.max_alert_times = max_alert_times
        self.node_ids = node_ids
        self.project_id = project_id
        self.remind_name = remind_name
        self.remind_type = remind_type
        self.remind_unit = remind_unit
        self.robot_urls = robot_urls

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_interval is not None:
            result['AlertInterval'] = self.alert_interval
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_targets is not None:
            result['AlertTargets'] = self.alert_targets
        if self.alert_unit is not None:
            result['AlertUnit'] = self.alert_unit
        if self.baseline_ids is not None:
            result['BaselineIds'] = self.baseline_ids
        if self.biz_process_ids is not None:
            result['BizProcessIds'] = self.biz_process_ids
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.dnd_end is not None:
            result['DndEnd'] = self.dnd_end
        if self.max_alert_times is not None:
            result['MaxAlertTimes'] = self.max_alert_times
        if self.node_ids is not None:
            result['NodeIds'] = self.node_ids
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.remind_type is not None:
            result['RemindType'] = self.remind_type
        if self.remind_unit is not None:
            result['RemindUnit'] = self.remind_unit
        if self.robot_urls is not None:
            result['RobotUrls'] = self.robot_urls
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertInterval') is not None:
            self.alert_interval = m.get('AlertInterval')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertTargets') is not None:
            self.alert_targets = m.get('AlertTargets')
        if m.get('AlertUnit') is not None:
            self.alert_unit = m.get('AlertUnit')
        if m.get('BaselineIds') is not None:
            self.baseline_ids = m.get('BaselineIds')
        if m.get('BizProcessIds') is not None:
            self.biz_process_ids = m.get('BizProcessIds')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('DndEnd') is not None:
            self.dnd_end = m.get('DndEnd')
        if m.get('MaxAlertTimes') is not None:
            self.max_alert_times = m.get('MaxAlertTimes')
        if m.get('NodeIds') is not None:
            self.node_ids = m.get('NodeIds')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('RemindType') is not None:
            self.remind_type = m.get('RemindType')
        if m.get('RemindUnit') is not None:
            self.remind_unit = m.get('RemindUnit')
        if m.get('RobotUrls') is not None:
            self.robot_urls = m.get('RobotUrls')
        return self


class CreateRemindResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRemindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRemindResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableRequestColumns(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_name_cn: str = None,
        column_type: str = None,
        comment: str = None,
        is_partition_col: bool = None,
        length: int = None,
        seq_number: int = None,
    ):
        self.column_name = column_name
        self.column_name_cn = column_name_cn
        self.column_type = column_type
        self.comment = comment
        self.is_partition_col = is_partition_col
        self.length = length
        self.seq_number = seq_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_name_cn is not None:
            result['ColumnNameCn'] = self.column_name_cn
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_partition_col is not None:
            result['IsPartitionCol'] = self.is_partition_col
        if self.length is not None:
            result['Length'] = self.length
        if self.seq_number is not None:
            result['SeqNumber'] = self.seq_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnNameCn') is not None:
            self.column_name_cn = m.get('ColumnNameCn')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsPartitionCol') is not None:
            self.is_partition_col = m.get('IsPartitionCol')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('SeqNumber') is not None:
            self.seq_number = m.get('SeqNumber')
        return self


class CreateTableRequestThemes(TeaModel):
    def __init__(
        self,
        theme_id: int = None,
        theme_level: int = None,
    ):
        self.theme_id = theme_id
        self.theme_level = theme_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.theme_level is not None:
            result['ThemeLevel'] = self.theme_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('ThemeLevel') is not None:
            self.theme_level = m.get('ThemeLevel')
        return self


class CreateTableRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        category_id: int = None,
        client_token: str = None,
        columns: List[CreateTableRequestColumns] = None,
        comment: str = None,
        endpoint: str = None,
        env_type: int = None,
        external_table_type: str = None,
        has_part: int = None,
        is_view: int = None,
        life_cycle: int = None,
        location: str = None,
        logical_level_id: int = None,
        owner_id: str = None,
        physics_level_id: int = None,
        project_id: int = None,
        table_name: str = None,
        themes: List[CreateTableRequestThemes] = None,
        visibility: int = None,
    ):
        self.app_guid = app_guid
        self.category_id = category_id
        self.client_token = client_token
        self.columns = columns
        self.comment = comment
        self.endpoint = endpoint
        self.env_type = env_type
        self.external_table_type = external_table_type
        self.has_part = has_part
        self.is_view = is_view
        self.life_cycle = life_cycle
        self.location = location
        self.logical_level_id = logical_level_id
        self.owner_id = owner_id
        self.physics_level_id = physics_level_id
        self.project_id = project_id
        self.table_name = table_name
        self.themes = themes
        self.visibility = visibility

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()
        if self.themes:
            for k in self.themes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.external_table_type is not None:
            result['ExternalTableType'] = self.external_table_type
        if self.has_part is not None:
            result['HasPart'] = self.has_part
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.location is not None:
            result['Location'] = self.location
        if self.logical_level_id is not None:
            result['LogicalLevelId'] = self.logical_level_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.physics_level_id is not None:
            result['PhysicsLevelId'] = self.physics_level_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        result['Themes'] = []
        if self.themes is not None:
            for k in self.themes:
                result['Themes'].append(k.to_map() if k else None)
        if self.visibility is not None:
            result['Visibility'] = self.visibility
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = CreateTableRequestColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ExternalTableType') is not None:
            self.external_table_type = m.get('ExternalTableType')
        if m.get('HasPart') is not None:
            self.has_part = m.get('HasPart')
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('LogicalLevelId') is not None:
            self.logical_level_id = m.get('LogicalLevelId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PhysicsLevelId') is not None:
            self.physics_level_id = m.get('PhysicsLevelId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        self.themes = []
        if m.get('Themes') is not None:
            for k in m.get('Themes'):
                temp_model = CreateTableRequestThemes()
                self.themes.append(temp_model.from_map(k))
        if m.get('Visibility') is not None:
            self.visibility = m.get('Visibility')
        return self


class CreateTableResponseBodyTaskInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        next_task_id: str = None,
        status: str = None,
        task_id: str = None,
    ):
        self.content = content
        self.next_task_id = next_task_id
        self.status = status
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: CreateTableResponseBodyTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = CreateTableResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class CreateTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableLevelRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        level_type: int = None,
        name: str = None,
        project_id: int = None,
    ):
        self.description = description
        self.level_type = level_type
        self.name = name
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.level_type is not None:
            result['LevelType'] = self.level_type
        if self.name is not None:
            result['Name'] = self.name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LevelType') is not None:
            self.level_type = m.get('LevelType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class CreateTableLevelResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        level_id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.level_id = level_id
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateTableLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTableLevelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTableLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableThemeRequest(TeaModel):
    def __init__(
        self,
        level: int = None,
        name: str = None,
        parent_id: int = None,
        project_id: int = None,
    ):
        self.level = level
        self.name = name
        self.parent_id = parent_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class CreateTableThemeResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        theme_id: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.theme_id = theme_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        return self


class CreateTableThemeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTableThemeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTableThemeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUdfFileRequest(TeaModel):
    def __init__(
        self,
        class_name: str = None,
        cmd_description: str = None,
        example: str = None,
        file_folder_path: str = None,
        file_name: str = None,
        function_type: str = None,
        parameter_description: str = None,
        project_id: int = None,
        project_identifier: str = None,
        resources: str = None,
        return_value: str = None,
        udf_description: str = None,
    ):
        self.class_name = class_name
        self.cmd_description = cmd_description
        self.example = example
        self.file_folder_path = file_folder_path
        self.file_name = file_name
        self.function_type = function_type
        self.parameter_description = parameter_description
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.resources = resources
        self.return_value = return_value
        self.udf_description = udf_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_name is not None:
            result['ClassName'] = self.class_name
        if self.cmd_description is not None:
            result['CmdDescription'] = self.cmd_description
        if self.example is not None:
            result['Example'] = self.example
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.function_type is not None:
            result['FunctionType'] = self.function_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.return_value is not None:
            result['ReturnValue'] = self.return_value
        if self.udf_description is not None:
            result['UdfDescription'] = self.udf_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClassName') is not None:
            self.class_name = m.get('ClassName')
        if m.get('CmdDescription') is not None:
            self.cmd_description = m.get('CmdDescription')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FunctionType') is not None:
            self.function_type = m.get('FunctionType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('ReturnValue') is not None:
            self.return_value = m.get('ReturnValue')
        if m.get('UdfDescription') is not None:
            self.udf_description = m.get('UdfDescription')
        return self


class CreateUdfFileResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateUdfFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateUdfFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateUdfFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBusinessRequest(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.business_id = business_id
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class DeleteBusinessResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConnectionRequest(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
    ):
        self.connection_id = connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class DeleteConnectionResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        http_status_code: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        task_type: str = None,
    ):
        self.file_id = file_id
        self.project_id = project_id
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DeleteDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        status: str = None,
    ):
        self.message = message
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: DeleteDISyncTaskResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeleteDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DeleteDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataServiceApiAuthorityRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        authorized_project_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.authorized_project_id = authorized_project_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DeleteDataServiceApiAuthorityResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataServiceApiAuthorityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDataServiceApiAuthorityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDataServiceApiAuthorityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataSourceRequest(TeaModel):
    def __init__(
        self,
        data_source_id: int = None,
    ):
        self.data_source_id = data_source_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        return self


class DeleteDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        http_status_code: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFileRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.file_id = file_id
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class DeleteFileResponseBody(TeaModel):
    def __init__(
        self,
        deployment_id: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.deployment_id = deployment_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFolderRequest(TeaModel):
    def __init__(
        self,
        folder_id: str = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.folder_id = folder_id
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class DeleteFolderResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFromMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        table_guid: str = None,
    ):
        self.category_id = category_id
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class DeleteFromMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFromMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFromMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFromMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
    ):
        self.category_id = category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class DeleteMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProjectMemberRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        user_id: str = None,
    ):
        self.project_id = project_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DeleteProjectMemberResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteProjectMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteProjectMemberResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProjectMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityEntityRequest(TeaModel):
    def __init__(
        self,
        entity_id: int = None,
        env_type: str = None,
        project_name: str = None,
    ):
        self.entity_id = entity_id
        self.env_type = env_type
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class DeleteQualityEntityResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQualityEntityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityFollowerRequest(TeaModel):
    def __init__(
        self,
        follower_id: int = None,
        project_name: str = None,
    ):
        self.follower_id = follower_id
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.follower_id is not None:
            result['FollowerId'] = self.follower_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FollowerId') is not None:
            self.follower_id = m.get('FollowerId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class DeleteQualityFollowerResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityFollowerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQualityFollowerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRelativeNodeRequest(TeaModel):
    def __init__(
        self,
        env_type: str = None,
        match_expression: str = None,
        node_id: int = None,
        project_id: int = None,
        project_name: str = None,
        table_name: str = None,
        target_node_project_id: int = None,
        target_node_project_name: str = None,
    ):
        self.env_type = env_type
        self.match_expression = match_expression
        self.node_id = node_id
        self.project_id = project_id
        self.project_name = project_name
        self.table_name = table_name
        self.target_node_project_id = target_node_project_id
        self.target_node_project_name = target_node_project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.target_node_project_id is not None:
            result['TargetNodeProjectId'] = self.target_node_project_id
        if self.target_node_project_name is not None:
            result['TargetNodeProjectName'] = self.target_node_project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TargetNodeProjectId') is not None:
            self.target_node_project_id = m.get('TargetNodeProjectId')
        if m.get('TargetNodeProjectName') is not None:
            self.target_node_project_name = m.get('TargetNodeProjectName')
        return self


class DeleteQualityRelativeNodeResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityRelativeNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQualityRelativeNodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityRelativeNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRuleRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        rule_id: int = None,
    ):
        self.project_name = project_name
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRemindRequest(TeaModel):
    def __init__(
        self,
        remind_id: int = None,
    ):
        self.remind_id = remind_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        return self


class DeleteRemindResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRemindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRemindResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        env_type: int = None,
        project_id: int = None,
        table_name: str = None,
    ):
        self.app_guid = app_guid
        self.env_type = env_type
        self.project_id = project_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class DeleteTableResponseBodyTaskInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        next_task_id: str = None,
        status: str = None,
        task_id: str = None,
    ):
        self.content = content
        self.next_task_id = next_task_id
        self.status = status
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: DeleteTableResponseBodyTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = DeleteTableResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class DeleteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableLevelRequest(TeaModel):
    def __init__(
        self,
        level_id: int = None,
        project_id: int = None,
    ):
        self.level_id = level_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteTableLevelResponseBody(TeaModel):
    def __init__(
        self,
        delete_result: bool = None,
        request_id: str = None,
    ):
        self.delete_result = delete_result
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTableLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTableLevelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTableLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableThemeRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        theme_id: int = None,
    ):
        self.project_id = project_id
        self.theme_id = theme_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        return self


class DeleteTableThemeResponseBody(TeaModel):
    def __init__(
        self,
        delete_result: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.delete_result = delete_result
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteTableThemeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTableThemeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTableThemeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        task_type: str = None,
    ):
        self.file_id = file_id
        self.project_id = project_id
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DeployDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        status: str = None,
    ):
        self.message = message
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeployDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: DeployDISyncTaskResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeployDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeployDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeployDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeployDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployFileRequest(TeaModel):
    def __init__(
        self,
        comment: str = None,
        file_id: int = None,
        node_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.comment = comment
        self.file_id = file_id
        self.node_id = node_id
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class DeployFileResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeployFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeployFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeployFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DesensitizeDataRequest(TeaModel):
    def __init__(
        self,
        data: str = None,
        scene_code: str = None,
    ):
        self.data = data
        self.scene_code = scene_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.scene_code is not None:
            result['SceneCode'] = self.scene_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('SceneCode') is not None:
            self.scene_code = m.get('SceneCode')
        return self


class DesensitizeDataResponseBody(TeaModel):
    def __init__(
        self,
        desensitize_data: str = None,
        request_id: str = None,
    ):
        self.desensitize_data = desensitize_data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desensitize_data is not None:
            result['DesensitizeData'] = self.desensitize_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesensitizeData') is not None:
            self.desensitize_data = m.get('DesensitizeData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DesensitizeDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DesensitizeDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DesensitizeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EstablishRelationTableToBusinessRequest(TeaModel):
    def __init__(
        self,
        business_id: str = None,
        folder_id: str = None,
        project_id: int = None,
        project_identifier: str = None,
        table_guid: str = None,
    ):
        self.business_id = business_id
        self.folder_id = folder_id
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class EstablishRelationTableToBusinessResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EstablishRelationTableToBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EstablishRelationTableToBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EstablishRelationTableToBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportDataSourcesRequest(TeaModel):
    def __init__(
        self,
        data_source_type: str = None,
        env_type: int = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        sub_type: str = None,
    ):
        self.data_source_type = data_source_type
        self.env_type = env_type
        self.name = name
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.sub_type = sub_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        return self


class ExportDataSourcesResponseBodyDataDataSources(TeaModel):
    def __init__(
        self,
        binding_calc_engine_id: int = None,
        connect_status: int = None,
        content: str = None,
        data_source_type: str = None,
        default_engine: bool = None,
        description: str = None,
        env_type: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        name: str = None,
        operator: str = None,
        project_id: int = None,
        sequence: int = None,
        shared: bool = None,
        status: int = None,
        sub_type: str = None,
        tenant_id: int = None,
    ):
        self.binding_calc_engine_id = binding_calc_engine_id
        self.connect_status = connect_status
        self.content = content
        self.data_source_type = data_source_type
        self.default_engine = default_engine
        self.description = description
        self.env_type = env_type
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.name = name
        self.operator = operator
        self.project_id = project_id
        self.sequence = sequence
        self.shared = shared
        self.status = status
        self.sub_type = sub_type
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.content is not None:
            result['Content'] = self.content
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.description is not None:
            result['Description'] = self.description
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ExportDataSourcesResponseBodyData(TeaModel):
    def __init__(
        self,
        data_sources: List[ExportDataSourcesResponseBodyDataDataSources] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.data_sources = data_sources
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.data_sources:
            for k in self.data_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataSources'] = []
        if self.data_sources is not None:
            for k in self.data_sources:
                result['DataSources'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_sources = []
        if m.get('DataSources') is not None:
            for k in m.get('DataSources'):
                temp_model = ExportDataSourcesResponseBodyDataDataSources()
                self.data_sources.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ExportDataSourcesResponseBody(TeaModel):
    def __init__(
        self,
        data: ExportDataSourcesResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ExportDataSourcesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ExportDataSourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ExportDataSourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportDataSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDISyncTaskConfigForCreatingRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        task_param: str = None,
        task_type: str = None,
    ):
        self.client_token = client_token
        self.project_id = project_id
        self.task_param = task_param
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GenerateDISyncTaskConfigForCreatingResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        process_id: int = None,
        status: str = None,
    ):
        self.message = message
        self.process_id = process_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GenerateDISyncTaskConfigForCreatingResponseBody(TeaModel):
    def __init__(
        self,
        data: GenerateDISyncTaskConfigForCreatingResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GenerateDISyncTaskConfigForCreatingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateDISyncTaskConfigForCreatingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateDISyncTaskConfigForCreatingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateDISyncTaskConfigForCreatingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDISyncTaskConfigForUpdatingRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        task_id: int = None,
        task_param: str = None,
        task_type: str = None,
    ):
        self.client_token = client_token
        self.project_id = project_id
        self.task_id = task_id
        self.task_param = task_param
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GenerateDISyncTaskConfigForUpdatingResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        process_id: int = None,
        status: str = None,
    ):
        self.message = message
        self.process_id = process_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GenerateDISyncTaskConfigForUpdatingResponseBody(TeaModel):
    def __init__(
        self,
        data: GenerateDISyncTaskConfigForUpdatingResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GenerateDISyncTaskConfigForUpdatingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateDISyncTaskConfigForUpdatingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateDISyncTaskConfigForUpdatingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateDISyncTaskConfigForUpdatingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineConfigRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
    ):
        self.baseline_id = baseline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetBaselineConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
        baseline_type: str = None,
        exp_hour: int = None,
        exp_minu: int = None,
        hour_exp_detail: str = None,
        hour_sla_detail: str = None,
        is_default: bool = None,
        owner: str = None,
        priority: int = None,
        project_id: int = None,
        sla_hour: int = None,
        sla_minu: int = None,
        use_flag: bool = None,
    ):
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.baseline_type = baseline_type
        self.exp_hour = exp_hour
        self.exp_minu = exp_minu
        self.hour_exp_detail = hour_exp_detail
        self.hour_sla_detail = hour_sla_detail
        self.is_default = is_default
        self.owner = owner
        self.priority = priority
        self.project_id = project_id
        self.sla_hour = sla_hour
        self.sla_minu = sla_minu
        self.use_flag = use_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.exp_hour is not None:
            result['ExpHour'] = self.exp_hour
        if self.exp_minu is not None:
            result['ExpMinu'] = self.exp_minu
        if self.hour_exp_detail is not None:
            result['HourExpDetail'] = self.hour_exp_detail
        if self.hour_sla_detail is not None:
            result['HourSlaDetail'] = self.hour_sla_detail
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sla_hour is not None:
            result['SlaHour'] = self.sla_hour
        if self.sla_minu is not None:
            result['SlaMinu'] = self.sla_minu
        if self.use_flag is not None:
            result['UseFlag'] = self.use_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('ExpHour') is not None:
            self.exp_hour = m.get('ExpHour')
        if m.get('ExpMinu') is not None:
            self.exp_minu = m.get('ExpMinu')
        if m.get('HourExpDetail') is not None:
            self.hour_exp_detail = m.get('HourExpDetail')
        if m.get('HourSlaDetail') is not None:
            self.hour_sla_detail = m.get('HourSlaDetail')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SlaHour') is not None:
            self.sla_hour = m.get('SlaHour')
        if m.get('SlaMinu') is not None:
            self.sla_minu = m.get('SlaMinu')
        if m.get('UseFlag') is not None:
            self.use_flag = m.get('UseFlag')
        return self


class GetBaselineConfigResponseBody(TeaModel):
    def __init__(
        self,
        data: GetBaselineConfigResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetBaselineConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBaselineConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBaselineConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBaselineConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineKeyPathRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        bizdate: str = None,
        in_group_id: int = None,
    ):
        self.baseline_id = baseline_id
        self.bizdate = bizdate
        self.in_group_id = in_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetBaselineKeyPathResponseBodyDataRuns(TeaModel):
    def __init__(
        self,
        abs_time: int = None,
        begin_cast: int = None,
        begin_running_time: int = None,
        begin_wait_res_time: int = None,
        begin_wait_time_time: int = None,
        bizdate: int = None,
        cyc_time: int = None,
        end_cast: int = None,
        finish_time: int = None,
        in_group_id: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
        status: str = None,
    ):
        self.abs_time = abs_time
        self.begin_cast = begin_cast
        self.begin_running_time = begin_running_time
        self.begin_wait_res_time = begin_wait_res_time
        self.begin_wait_time_time = begin_wait_time_time
        self.bizdate = bizdate
        self.cyc_time = cyc_time
        self.end_cast = end_cast
        self.finish_time = finish_time
        self.in_group_id = in_group_id
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abs_time is not None:
            result['AbsTime'] = self.abs_time
        if self.begin_cast is not None:
            result['BeginCast'] = self.begin_cast
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbsTime') is not None:
            self.abs_time = m.get('AbsTime')
        if m.get('BeginCast') is not None:
            self.begin_cast = m.get('BeginCast')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetBaselineKeyPathResponseBodyDataTopics(TeaModel):
    def __init__(
        self,
        add_time: int = None,
        instance_id: int = None,
        topic_id: int = None,
        topic_name: int = None,
    ):
        self.add_time = add_time
        self.instance_id = instance_id
        self.topic_id = topic_id
        self.topic_name = topic_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_time is not None:
            result['AddTime'] = self.add_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddTime') is not None:
            self.add_time = m.get('AddTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        return self


class GetBaselineKeyPathResponseBodyData(TeaModel):
    def __init__(
        self,
        bizdate: int = None,
        in_group_id: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        prg_type: int = None,
        project_id: int = None,
        runs: List[GetBaselineKeyPathResponseBodyDataRuns] = None,
        topics: List[GetBaselineKeyPathResponseBodyDataTopics] = None,
    ):
        self.bizdate = bizdate
        self.in_group_id = in_group_id
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.prg_type = prg_type
        self.project_id = project_id
        self.runs = runs
        self.topics = topics

    def validate(self):
        if self.runs:
            for k in self.runs:
                if k:
                    k.validate()
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        result['Runs'] = []
        if self.runs is not None:
            for k in self.runs:
                result['Runs'].append(k.to_map() if k else None)
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        self.runs = []
        if m.get('Runs') is not None:
            for k in m.get('Runs'):
                temp_model = GetBaselineKeyPathResponseBodyDataRuns()
                self.runs.append(temp_model.from_map(k))
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = GetBaselineKeyPathResponseBodyDataTopics()
                self.topics.append(temp_model.from_map(k))
        return self


class GetBaselineKeyPathResponseBody(TeaModel):
    def __init__(
        self,
        data: List[GetBaselineKeyPathResponseBodyData] = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetBaselineKeyPathResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBaselineKeyPathResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBaselineKeyPathResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBaselineKeyPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineStatusRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        bizdate: str = None,
        in_group_id: int = None,
    ):
        self.baseline_id = baseline_id
        self.bizdate = bizdate
        self.in_group_id = in_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetBaselineStatusResponseBodyDataBlockInstance(TeaModel):
    def __init__(
        self,
        end_cast: int = None,
        finish_time: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
        status: str = None,
    ):
        self.end_cast = end_cast
        self.finish_time = finish_time
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetBaselineStatusResponseBodyDataLastInstance(TeaModel):
    def __init__(
        self,
        end_cast: int = None,
        finish_time: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
        status: str = None,
    ):
        self.end_cast = end_cast
        self.finish_time = finish_time
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetBaselineStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
        bizdate: int = None,
        block_instance: GetBaselineStatusResponseBodyDataBlockInstance = None,
        buffer: float = None,
        end_cast: int = None,
        exp_time: int = None,
        finish_status: str = None,
        finish_time: int = None,
        in_group_id: int = None,
        last_instance: GetBaselineStatusResponseBodyDataLastInstance = None,
        owner: str = None,
        priority: int = None,
        project_id: int = None,
        sla_time: int = None,
        status: str = None,
    ):
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.bizdate = bizdate
        self.block_instance = block_instance
        self.buffer = buffer
        self.end_cast = end_cast
        self.exp_time = exp_time
        self.finish_status = finish_status
        self.finish_time = finish_time
        self.in_group_id = in_group_id
        self.last_instance = last_instance
        self.owner = owner
        self.priority = priority
        self.project_id = project_id
        self.sla_time = sla_time
        self.status = status

    def validate(self):
        if self.block_instance:
            self.block_instance.validate()
        if self.last_instance:
            self.last_instance.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.block_instance is not None:
            result['BlockInstance'] = self.block_instance.to_map()
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.exp_time is not None:
            result['ExpTime'] = self.exp_time
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.last_instance is not None:
            result['LastInstance'] = self.last_instance.to_map()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sla_time is not None:
            result['SlaTime'] = self.sla_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('BlockInstance') is not None:
            temp_model = GetBaselineStatusResponseBodyDataBlockInstance()
            self.block_instance = temp_model.from_map(m['BlockInstance'])
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('ExpTime') is not None:
            self.exp_time = m.get('ExpTime')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('LastInstance') is not None:
            temp_model = GetBaselineStatusResponseBodyDataLastInstance()
            self.last_instance = temp_model.from_map(m['LastInstance'])
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SlaTime') is not None:
            self.sla_time = m.get('SlaTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetBaselineStatusResponseBody(TeaModel):
    def __init__(
        self,
        data: GetBaselineStatusResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetBaselineStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBaselineStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBaselineStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBaselineStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBusinessRequest(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.business_id = business_id
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetBusinessResponseBodyData(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        business_name: str = None,
        description: str = None,
        owner: str = None,
        project_id: str = None,
        use_type: str = None,
    ):
        self.business_id = business_id
        self.business_name = business_name
        self.description = description
        self.owner = owner
        self.project_id = project_id
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetBusinessResponseBody(TeaModel):
    def __init__(
        self,
        data: GetBusinessResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetBusinessResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDDLJobStatusRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDDLJobStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        next_task_id: str = None,
        status: str = None,
        task_id: str = None,
    ):
        self.content = content
        self.next_task_id = next_task_id
        self.status = status
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDDLJobStatusResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDDLJobStatusResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDDLJobStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDDLJobStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDDLJobStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDDLJobStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncInstanceInfoRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        task_type: str = None,
    ):
        self.file_id = file_id
        self.project_id = project_id
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetDISyncInstanceInfoResponseBodyDataSolutionInfoStepDetail(TeaModel):
    def __init__(
        self,
        status: str = None,
        step_id: int = None,
        step_name: str = None,
    ):
        self.status = status
        self.step_id = step_id
        self.step_name = step_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.step_id is not None:
            result['StepId'] = self.step_id
        if self.step_name is not None:
            result['StepName'] = self.step_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StepId') is not None:
            self.step_id = m.get('StepId')
        if m.get('StepName') is not None:
            self.step_name = m.get('StepName')
        return self


class GetDISyncInstanceInfoResponseBodyDataSolutionInfo(TeaModel):
    def __init__(
        self,
        creator_name: str = None,
        id: int = None,
        status: str = None,
        step_detail: List[GetDISyncInstanceInfoResponseBodyDataSolutionInfoStepDetail] = None,
    ):
        self.creator_name = creator_name
        self.id = id
        self.status = status
        self.step_detail = step_detail

    def validate(self):
        if self.step_detail:
            for k in self.step_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        result['StepDetail'] = []
        if self.step_detail is not None:
            for k in self.step_detail:
                result['StepDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.step_detail = []
        if m.get('StepDetail') is not None:
            for k in m.get('StepDetail'):
                temp_model = GetDISyncInstanceInfoResponseBodyDataSolutionInfoStepDetail()
                self.step_detail.append(temp_model.from_map(k))
        return self


class GetDISyncInstanceInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        name: str = None,
        solution_info: GetDISyncInstanceInfoResponseBodyDataSolutionInfo = None,
        status: str = None,
    ):
        self.message = message
        self.name = name
        self.solution_info = solution_info
        self.status = status

    def validate(self):
        if self.solution_info:
            self.solution_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        if self.solution_info is not None:
            result['SolutionInfo'] = self.solution_info.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SolutionInfo') is not None:
            temp_model = GetDISyncInstanceInfoResponseBodyDataSolutionInfo()
            self.solution_info = temp_model.from_map(m['SolutionInfo'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDISyncInstanceInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDISyncInstanceInfoResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDISyncInstanceInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDISyncInstanceInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDISyncInstanceInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDISyncInstanceInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        task_type: str = None,
    ):
        self.file_id = file_id
        self.project_id = project_id
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetDISyncTaskResponseBodyDataSolutionDetail(TeaModel):
    def __init__(
        self,
        creator_name: str = None,
        id: int = None,
        name: str = None,
        process_content: str = None,
        process_extra: str = None,
        project_id: int = None,
        source_type: str = None,
        start_time: str = None,
        status: str = None,
        submit_time: str = None,
        type: str = None,
    ):
        self.creator_name = creator_name
        self.id = id
        self.name = name
        self.process_content = process_content
        self.process_extra = process_extra
        self.project_id = project_id
        self.source_type = source_type
        self.start_time = start_time
        self.status = status
        self.submit_time = submit_time
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.process_content is not None:
            result['ProcessContent'] = self.process_content
        if self.process_extra is not None:
            result['ProcessExtra'] = self.process_extra
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProcessContent') is not None:
            self.process_content = m.get('ProcessContent')
        if m.get('ProcessExtra') is not None:
            self.process_extra = m.get('ProcessExtra')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        solution_detail: GetDISyncTaskResponseBodyDataSolutionDetail = None,
        status: str = None,
    ):
        self.code = code
        self.message = message
        self.solution_detail = solution_detail
        self.status = status

    def validate(self):
        if self.solution_detail:
            self.solution_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.solution_detail is not None:
            result['SolutionDetail'] = self.solution_detail.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('SolutionDetail') is not None:
            temp_model = GetDISyncTaskResponseBodyDataSolutionDetail()
            self.solution_detail = temp_model.from_map(m['SolutionDetail'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDISyncTaskResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncTaskMetricInfoRequest(TeaModel):
    def __init__(
        self,
        end_date: int = None,
        file_id: int = None,
        project_id: int = None,
        start_date: int = None,
    ):
        self.end_date = end_date
        self.file_id = file_id
        self.project_id = project_id
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetDISyncTaskMetricInfoResponseBodyMetricInfo(TeaModel):
    def __init__(
        self,
        delete_reader_records: int = None,
        delete_writer_records: int = None,
        insert_reader_records: int = None,
        insert_writer_records: int = None,
        last_task_delay: int = None,
        message: str = None,
        sum_reader_records: int = None,
        sum_writer_records: int = None,
        update_reader_records: int = None,
        update_writer_records: int = None,
    ):
        self.delete_reader_records = delete_reader_records
        self.delete_writer_records = delete_writer_records
        self.insert_reader_records = insert_reader_records
        self.insert_writer_records = insert_writer_records
        self.last_task_delay = last_task_delay
        self.message = message
        self.sum_reader_records = sum_reader_records
        self.sum_writer_records = sum_writer_records
        self.update_reader_records = update_reader_records
        self.update_writer_records = update_writer_records

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_reader_records is not None:
            result['DeleteReaderRecords'] = self.delete_reader_records
        if self.delete_writer_records is not None:
            result['DeleteWriterRecords'] = self.delete_writer_records
        if self.insert_reader_records is not None:
            result['InsertReaderRecords'] = self.insert_reader_records
        if self.insert_writer_records is not None:
            result['InsertWriterRecords'] = self.insert_writer_records
        if self.last_task_delay is not None:
            result['LastTaskDelay'] = self.last_task_delay
        if self.message is not None:
            result['Message'] = self.message
        if self.sum_reader_records is not None:
            result['SumReaderRecords'] = self.sum_reader_records
        if self.sum_writer_records is not None:
            result['SumWriterRecords'] = self.sum_writer_records
        if self.update_reader_records is not None:
            result['UpdateReaderRecords'] = self.update_reader_records
        if self.update_writer_records is not None:
            result['UpdateWriterRecords'] = self.update_writer_records
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteReaderRecords') is not None:
            self.delete_reader_records = m.get('DeleteReaderRecords')
        if m.get('DeleteWriterRecords') is not None:
            self.delete_writer_records = m.get('DeleteWriterRecords')
        if m.get('InsertReaderRecords') is not None:
            self.insert_reader_records = m.get('InsertReaderRecords')
        if m.get('InsertWriterRecords') is not None:
            self.insert_writer_records = m.get('InsertWriterRecords')
        if m.get('LastTaskDelay') is not None:
            self.last_task_delay = m.get('LastTaskDelay')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('SumReaderRecords') is not None:
            self.sum_reader_records = m.get('SumReaderRecords')
        if m.get('SumWriterRecords') is not None:
            self.sum_writer_records = m.get('SumWriterRecords')
        if m.get('UpdateReaderRecords') is not None:
            self.update_reader_records = m.get('UpdateReaderRecords')
        if m.get('UpdateWriterRecords') is not None:
            self.update_writer_records = m.get('UpdateWriterRecords')
        return self


class GetDISyncTaskMetricInfoResponseBody(TeaModel):
    def __init__(
        self,
        metric_info: GetDISyncTaskMetricInfoResponseBodyMetricInfo = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.metric_info = metric_info
        # Id of the request
        self.request_id = request_id
        # isSuccess
        self.success = success

    def validate(self):
        if self.metric_info:
            self.metric_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_info is not None:
            result['MetricInfo'] = self.metric_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricInfo') is not None:
            temp_model = GetDISyncTaskMetricInfoResponseBodyMetricInfo()
            self.metric_info = temp_model.from_map(m['MetricInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDISyncTaskMetricInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDISyncTaskMetricInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDISyncTaskMetricInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDagRequest(TeaModel):
    def __init__(
        self,
        dag_id: int = None,
        project_env: str = None,
    ):
        self.dag_id = dag_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetDagResponseBodyData(TeaModel):
    def __init__(
        self,
        bizdate: int = None,
        create_time: int = None,
        create_user: str = None,
        dag_id: int = None,
        finish_time: int = None,
        gmtdate: int = None,
        modify_time: int = None,
        name: str = None,
        op_seq: int = None,
        project_id: int = None,
        start_time: int = None,
        status: str = None,
        type: str = None,
    ):
        self.bizdate = bizdate
        self.create_time = create_time
        self.create_user = create_user
        self.dag_id = dag_id
        self.finish_time = finish_time
        self.gmtdate = gmtdate
        self.modify_time = modify_time
        self.name = name
        self.op_seq = op_seq
        self.project_id = project_id
        self.start_time = start_time
        self.status = status
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.gmtdate is not None:
            result['Gmtdate'] = self.gmtdate
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.op_seq is not None:
            result['OpSeq'] = self.op_seq
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Gmtdate') is not None:
            self.gmtdate = m.get('Gmtdate')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpSeq') is not None:
            self.op_seq = m.get('OpSeq')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDagResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDagResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDagResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        error_solution: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.column_name = column_name
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetails(TeaModel):
    def __init__(
        self,
        failed_result_sample: str = None,
        registration_error_codes: List[GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes] = None,
        registration_request_parameters: List[GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters] = None,
        service_content_type: int = None,
        service_host: str = None,
        service_path: str = None,
        service_request_body_description: str = None,
        successful_result_sample: str = None,
    ):
        self.failed_result_sample = failed_result_sample
        self.registration_error_codes = registration_error_codes
        self.registration_request_parameters = registration_request_parameters
        self.service_content_type = service_content_type
        self.service_host = service_host
        self.service_path = service_path
        self.service_request_body_description = service_request_body_description
        self.successful_result_sample = successful_result_sample

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.column_name = column_name
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        example_value: str = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
    ):
        self.column_name = column_name
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class GetDataServiceApiResponseBodyDataScriptDetails(TeaModel):
    def __init__(
        self,
        is_paged_response: bool = None,
        script: str = None,
        script_connection: GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection = None,
        script_request_parameters: List[GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters] = None,
        script_response_parameters: List[GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters] = None,
    ):
        self.is_paged_response = is_paged_response
        self.script = script
        self.script_connection = script_connection
        self.script_request_parameters = script_request_parameters
        self.script_response_parameters = script_response_parameters

    def validate(self):
        if self.script_connection:
            self.script_connection.validate()
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.script is not None:
            result['Script'] = self.script
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('ScriptConnection') is not None:
            temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.column_name = column_name
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        example_value: str = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
    ):
        self.column_name = column_name
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class GetDataServiceApiResponseBodyDataWizardDetails(TeaModel):
    def __init__(
        self,
        is_paged_response: bool = None,
        wizard_connection: GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection = None,
        wizard_request_parameters: List[GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters] = None,
        wizard_response_parameters: List[GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters] = None,
    ):
        self.is_paged_response = is_paged_response
        self.wizard_connection = wizard_connection
        self.wizard_request_parameters = wizard_request_parameters
        self.wizard_response_parameters = wizard_response_parameters

    def validate(self):
        if self.wizard_connection:
            self.wizard_connection.validate()
        if self.wizard_request_parameters:
            for k in self.wizard_request_parameters:
                if k:
                    k.validate()
        if self.wizard_response_parameters:
            for k in self.wizard_response_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.wizard_connection is not None:
            result['WizardConnection'] = self.wizard_connection.to_map()
        result['WizardRequestParameters'] = []
        if self.wizard_request_parameters is not None:
            for k in self.wizard_request_parameters:
                result['WizardRequestParameters'].append(k.to_map() if k else None)
        result['WizardResponseParameters'] = []
        if self.wizard_response_parameters is not None:
            for k in self.wizard_response_parameters:
                result['WizardResponseParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('WizardConnection') is not None:
            temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection()
            self.wizard_connection = temp_model.from_map(m['WizardConnection'])
        self.wizard_request_parameters = []
        if m.get('WizardRequestParameters') is not None:
            for k in m.get('WizardRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters()
                self.wizard_request_parameters.append(temp_model.from_map(k))
        self.wizard_response_parameters = []
        if m.get('WizardResponseParameters') is not None:
            for k in m.get('WizardResponseParameters'):
                temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters()
                self.wizard_response_parameters.append(temp_model.from_map(k))
        return self


class GetDataServiceApiResponseBodyData(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        api_mode: int = None,
        api_name: str = None,
        api_path: str = None,
        created_time: str = None,
        creator_id: str = None,
        description: str = None,
        folder_id: int = None,
        group_id: str = None,
        modified_time: str = None,
        operator_id: str = None,
        project_id: int = None,
        protocols: List[int] = None,
        registration_details: GetDataServiceApiResponseBodyDataRegistrationDetails = None,
        request_method: int = None,
        response_content_type: int = None,
        script_details: GetDataServiceApiResponseBodyDataScriptDetails = None,
        status: int = None,
        tenant_id: int = None,
        timeout: int = None,
        visible_range: int = None,
        wizard_details: GetDataServiceApiResponseBodyDataWizardDetails = None,
    ):
        self.api_id = api_id
        self.api_mode = api_mode
        self.api_name = api_name
        self.api_path = api_path
        self.created_time = created_time
        self.creator_id = creator_id
        self.description = description
        self.folder_id = folder_id
        self.group_id = group_id
        self.modified_time = modified_time
        self.operator_id = operator_id
        self.project_id = project_id
        self.protocols = protocols
        self.registration_details = registration_details
        self.request_method = request_method
        self.response_content_type = response_content_type
        self.script_details = script_details
        self.status = status
        self.tenant_id = tenant_id
        self.timeout = timeout
        self.visible_range = visible_range
        self.wizard_details = wizard_details

    def validate(self):
        if self.registration_details:
            self.registration_details.validate()
        if self.script_details:
            self.script_details.validate()
        if self.wizard_details:
            self.wizard_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details.to_map()
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataRegistrationDetails()
            self.registration_details = temp_model.from_map(m['RegistrationDetails'])
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('ScriptDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataScriptDetails()
            self.script_details = temp_model.from_map(m['ScriptDetails'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('WizardDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataWizardDetails()
            self.wizard_details = temp_model.from_map(m['WizardDetails'])
        return self


class GetDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDataServiceApiResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDataServiceApiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.application_id = application_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        application_code: str = None,
        application_id: int = None,
        application_key: str = None,
        application_name: str = None,
        application_secret: str = None,
        project_id: int = None,
    ):
        self.application_code = application_code
        self.application_id = application_id
        self.application_key = application_key
        self.application_name = application_name
        self.application_secret = application_secret
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_code is not None:
            result['ApplicationCode'] = self.application_code
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_key is not None:
            result['ApplicationKey'] = self.application_key
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_secret is not None:
            result['ApplicationSecret'] = self.application_secret
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationCode') is not None:
            self.application_code = m.get('ApplicationCode')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationKey') is not None:
            self.application_key = m.get('ApplicationKey')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationSecret') is not None:
            self.application_secret = m.get('ApplicationSecret')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetDataServiceApplicationResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDataServiceApplicationResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDataServiceApplicationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataServiceApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServiceApplicationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceFolderRequest(TeaModel):
    def __init__(
        self,
        folder_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.folder_id = folder_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceFolderResponseBodyFolder(TeaModel):
    def __init__(
        self,
        created_time: str = None,
        folder_id: int = None,
        folder_name: str = None,
        group_id: str = None,
        modified_time: str = None,
        parent_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.created_time = created_time
        self.folder_id = folder_id
        self.folder_name = folder_name
        self.group_id = group_id
        self.modified_time = modified_time
        self.parent_id = parent_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceFolderResponseBody(TeaModel):
    def __init__(
        self,
        folder: GetDataServiceFolderResponseBodyFolder = None,
        request_id: str = None,
    ):
        self.folder = folder
        self.request_id = request_id

    def validate(self):
        if self.folder:
            self.folder.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder is not None:
            result['Folder'] = self.folder.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Folder') is not None:
            temp_model = GetDataServiceFolderResponseBodyFolder()
            self.folder = temp_model.from_map(m['Folder'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDataServiceFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServiceFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.group_id = group_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceGroupResponseBodyGroup(TeaModel):
    def __init__(
        self,
        api_gateway_group_id: str = None,
        created_time: str = None,
        creator_id: str = None,
        description: str = None,
        group_id: str = None,
        group_name: str = None,
        modified_time: str = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_gateway_group_id = api_gateway_group_id
        self.created_time = created_time
        self.creator_id = creator_id
        self.description = description
        self.group_id = group_id
        self.group_name = group_name
        self.modified_time = modified_time
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceGroupResponseBody(TeaModel):
    def __init__(
        self,
        group: GetDataServiceGroupResponseBodyGroup = None,
        request_id: str = None,
    ):
        self.group = group
        self.request_id = request_id

    def validate(self):
        if self.group:
            self.group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group is not None:
            result['Group'] = self.group.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Group') is not None:
            temp_model = GetDataServiceGroupResponseBodyGroup()
            self.group = temp_model.from_map(m['Group'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDataServiceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServiceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServicePublishedApiRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        error_solution: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(
        self,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetails(TeaModel):
    def __init__(
        self,
        failed_result_sample: str = None,
        registration_error_codes: List[GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes] = None,
        registration_request_parameters: List[GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters] = None,
        service_content_type: int = None,
        service_host: str = None,
        service_path: str = None,
        service_request_body_description: str = None,
        successful_result_sample: str = None,
    ):
        self.failed_result_sample = failed_result_sample
        self.registration_error_codes = registration_error_codes
        self.registration_request_parameters = registration_request_parameters
        self.service_content_type = service_content_type
        self.service_host = service_host
        self.service_path = service_path
        self.service_request_body_description = service_request_body_description
        self.successful_result_sample = successful_result_sample

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        error_solution: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(
        self,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(
        self,
        example_value: str = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
    ):
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetails(TeaModel):
    def __init__(
        self,
        failed_result_sample: str = None,
        is_paged_response: bool = None,
        script: str = None,
        script_connection: GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection = None,
        script_error_codes: List[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes] = None,
        script_request_parameters: List[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters] = None,
        script_response_parameters: List[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters] = None,
        successful_result_sample: str = None,
    ):
        self.failed_result_sample = failed_result_sample
        self.is_paged_response = is_paged_response
        self.script = script
        self.script_connection = script_connection
        self.script_error_codes = script_error_codes
        self.script_request_parameters = script_request_parameters
        self.script_response_parameters = script_response_parameters
        self.successful_result_sample = successful_result_sample

    def validate(self):
        if self.script_connection:
            self.script_connection.validate()
        if self.script_error_codes:
            for k in self.script_error_codes:
                if k:
                    k.validate()
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.script is not None:
            result['Script'] = self.script
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        result['ScriptErrorCodes'] = []
        if self.script_error_codes is not None:
            for k in self.script_error_codes:
                result['ScriptErrorCodes'].append(k.to_map() if k else None)
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('ScriptConnection') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        self.script_error_codes = []
        if m.get('ScriptErrorCodes') is not None:
            for k in m.get('ScriptErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes()
                self.script_error_codes.append(temp_model.from_map(k))
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        error_solution: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(
        self,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(
        self,
        example_value: str = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
    ):
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetails(TeaModel):
    def __init__(
        self,
        failed_result_sample: str = None,
        is_paged_response: bool = None,
        successful_result_sample: str = None,
        wizard_connection: GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection = None,
        wizard_error_codes: List[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes] = None,
        wizard_request_parameters: List[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters] = None,
        wizard_response_parameters: List[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters] = None,
    ):
        self.failed_result_sample = failed_result_sample
        self.is_paged_response = is_paged_response
        self.successful_result_sample = successful_result_sample
        self.wizard_connection = wizard_connection
        self.wizard_error_codes = wizard_error_codes
        self.wizard_request_parameters = wizard_request_parameters
        self.wizard_response_parameters = wizard_response_parameters

    def validate(self):
        if self.wizard_connection:
            self.wizard_connection.validate()
        if self.wizard_error_codes:
            for k in self.wizard_error_codes:
                if k:
                    k.validate()
        if self.wizard_request_parameters:
            for k in self.wizard_request_parameters:
                if k:
                    k.validate()
        if self.wizard_response_parameters:
            for k in self.wizard_response_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.wizard_connection is not None:
            result['WizardConnection'] = self.wizard_connection.to_map()
        result['WizardErrorCodes'] = []
        if self.wizard_error_codes is not None:
            for k in self.wizard_error_codes:
                result['WizardErrorCodes'].append(k.to_map() if k else None)
        result['WizardRequestParameters'] = []
        if self.wizard_request_parameters is not None:
            for k in self.wizard_request_parameters:
                result['WizardRequestParameters'].append(k.to_map() if k else None)
        result['WizardResponseParameters'] = []
        if self.wizard_response_parameters is not None:
            for k in self.wizard_response_parameters:
                result['WizardResponseParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('WizardConnection') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection()
            self.wizard_connection = temp_model.from_map(m['WizardConnection'])
        self.wizard_error_codes = []
        if m.get('WizardErrorCodes') is not None:
            for k in m.get('WizardErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes()
                self.wizard_error_codes.append(temp_model.from_map(k))
        self.wizard_request_parameters = []
        if m.get('WizardRequestParameters') is not None:
            for k in m.get('WizardRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters()
                self.wizard_request_parameters.append(temp_model.from_map(k))
        self.wizard_response_parameters = []
        if m.get('WizardResponseParameters') is not None:
            for k in m.get('WizardResponseParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters()
                self.wizard_response_parameters.append(temp_model.from_map(k))
        return self


class GetDataServicePublishedApiResponseBodyData(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        api_mode: int = None,
        api_name: str = None,
        api_path: str = None,
        created_time: str = None,
        creator_id: str = None,
        description: str = None,
        group_id: str = None,
        modified_time: str = None,
        operator_id: str = None,
        project_id: int = None,
        protocols: List[int] = None,
        registration_details: GetDataServicePublishedApiResponseBodyDataRegistrationDetails = None,
        request_method: int = None,
        response_content_type: int = None,
        script_details: GetDataServicePublishedApiResponseBodyDataScriptDetails = None,
        status: int = None,
        tenant_id: int = None,
        timeout: int = None,
        visible_range: int = None,
        wizard_details: GetDataServicePublishedApiResponseBodyDataWizardDetails = None,
    ):
        self.api_id = api_id
        self.api_mode = api_mode
        self.api_name = api_name
        self.api_path = api_path
        self.created_time = created_time
        self.creator_id = creator_id
        self.description = description
        self.group_id = group_id
        self.modified_time = modified_time
        self.operator_id = operator_id
        self.project_id = project_id
        self.protocols = protocols
        self.registration_details = registration_details
        self.request_method = request_method
        self.response_content_type = response_content_type
        self.script_details = script_details
        self.status = status
        self.tenant_id = tenant_id
        self.timeout = timeout
        self.visible_range = visible_range
        self.wizard_details = wizard_details

    def validate(self):
        if self.registration_details:
            self.registration_details.validate()
        if self.script_details:
            self.script_details.validate()
        if self.wizard_details:
            self.wizard_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details.to_map()
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetails()
            self.registration_details = temp_model.from_map(m['RegistrationDetails'])
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('ScriptDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetails()
            self.script_details = temp_model.from_map(m['ScriptDetails'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('WizardDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetails()
            self.wizard_details = temp_model.from_map(m['WizardDetails'])
        return self


class GetDataServicePublishedApiResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDataServicePublishedApiResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataServicePublishedApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServicePublishedApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServicePublishedApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataSourceMetaRequest(TeaModel):
    def __init__(
        self,
        datasource_name: str = None,
        env_type: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
    ):
        self.datasource_name = datasource_name
        self.env_type = env_type
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetDataSourceMetaResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        meta: str = None,
        status: str = None,
    ):
        self.message = message
        self.meta = meta
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.meta is not None:
            result['Meta'] = self.meta
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDataSourceMetaResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDataSourceMetaResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDataSourceMetaResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataSourceMetaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataSourceMetaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataSourceMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeploymentRequest(TeaModel):
    def __init__(
        self,
        deployment_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.deployment_id = deployment_id
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetDeploymentResponseBodyDataDeployment(TeaModel):
    def __init__(
        self,
        checking_status: int = None,
        create_time: int = None,
        creator_id: str = None,
        error_message: str = None,
        execute_time: int = None,
        from_environment: int = None,
        handler_id: str = None,
        name: str = None,
        status: int = None,
        to_environment: int = None,
    ):
        self.checking_status = checking_status
        self.create_time = create_time
        self.creator_id = creator_id
        self.error_message = error_message
        self.execute_time = execute_time
        self.from_environment = from_environment
        self.handler_id = handler_id
        self.name = name
        self.status = status
        self.to_environment = to_environment

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checking_status is not None:
            result['CheckingStatus'] = self.checking_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.from_environment is not None:
            result['FromEnvironment'] = self.from_environment
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.to_environment is not None:
            result['ToEnvironment'] = self.to_environment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckingStatus') is not None:
            self.checking_status = m.get('CheckingStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('FromEnvironment') is not None:
            self.from_environment = m.get('FromEnvironment')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ToEnvironment') is not None:
            self.to_environment = m.get('ToEnvironment')
        return self


class GetDeploymentResponseBodyData(TeaModel):
    def __init__(
        self,
        deployment: GetDeploymentResponseBodyDataDeployment = None,
    ):
        self.deployment = deployment

    def validate(self):
        if self.deployment:
            self.deployment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment is not None:
            result['Deployment'] = self.deployment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Deployment') is not None:
            temp_model = GetDeploymentResponseBodyDataDeployment()
            self.deployment = temp_model.from_map(m['Deployment'])
        return self


class GetDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDeploymentResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDeploymentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        node_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.file_id = file_id
        self.node_id = node_id
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetFileResponseBodyDataFile(TeaModel):
    def __init__(
        self,
        advanced_settings: str = None,
        auto_parsing: bool = None,
        biz_id: int = None,
        business_id: int = None,
        commit_status: int = None,
        connection_name: str = None,
        content: str = None,
        create_time: int = None,
        create_user: str = None,
        current_version: int = None,
        deleted_status: str = None,
        file_description: str = None,
        file_folder_id: str = None,
        file_name: str = None,
        file_type: int = None,
        is_max_compute: bool = None,
        last_edit_time: int = None,
        last_edit_user: str = None,
        node_id: int = None,
        owner: str = None,
        parent_id: int = None,
        use_type: str = None,
    ):
        self.advanced_settings = advanced_settings
        self.auto_parsing = auto_parsing
        self.biz_id = biz_id
        self.business_id = business_id
        self.commit_status = commit_status
        self.connection_name = connection_name
        self.content = content
        self.create_time = create_time
        self.create_user = create_user
        self.current_version = current_version
        self.deleted_status = deleted_status
        self.file_description = file_description
        self.file_folder_id = file_folder_id
        self.file_name = file_name
        self.file_type = file_type
        self.is_max_compute = is_max_compute
        self.last_edit_time = last_edit_time
        self.last_edit_user = last_edit_user
        self.node_id = node_id
        self.owner = owner
        self.parent_id = parent_id
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advanced_settings is not None:
            result['AdvancedSettings'] = self.advanced_settings
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.commit_status is not None:
            result['CommitStatus'] = self.commit_status
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.deleted_status is not None:
            result['DeletedStatus'] = self.deleted_status
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.file_folder_id is not None:
            result['FileFolderId'] = self.file_folder_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.is_max_compute is not None:
            result['IsMaxCompute'] = self.is_max_compute
        if self.last_edit_time is not None:
            result['LastEditTime'] = self.last_edit_time
        if self.last_edit_user is not None:
            result['LastEditUser'] = self.last_edit_user
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdvancedSettings') is not None:
            self.advanced_settings = m.get('AdvancedSettings')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('CommitStatus') is not None:
            self.commit_status = m.get('CommitStatus')
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('DeletedStatus') is not None:
            self.deleted_status = m.get('DeletedStatus')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('FileFolderId') is not None:
            self.file_folder_id = m.get('FileFolderId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('IsMaxCompute') is not None:
            self.is_max_compute = m.get('IsMaxCompute')
        if m.get('LastEditTime') is not None:
            self.last_edit_time = m.get('LastEditTime')
        if m.get('LastEditUser') is not None:
            self.last_edit_user = m.get('LastEditUser')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetFileResponseBodyDataNodeConfigurationInputList(TeaModel):
    def __init__(
        self,
        input: str = None,
        parse_type: str = None,
    ):
        self.input = input
        self.parse_type = parse_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input is not None:
            result['Input'] = self.input
        if self.parse_type is not None:
            result['ParseType'] = self.parse_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('ParseType') is not None:
            self.parse_type = m.get('ParseType')
        return self


class GetFileResponseBodyDataNodeConfigurationOutputList(TeaModel):
    def __init__(
        self,
        output: str = None,
        ref_table_name: str = None,
    ):
        self.output = output
        self.ref_table_name = ref_table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output
        if self.ref_table_name is not None:
            result['RefTableName'] = self.ref_table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('RefTableName') is not None:
            self.ref_table_name = m.get('RefTableName')
        return self


class GetFileResponseBodyDataNodeConfiguration(TeaModel):
    def __init__(
        self,
        auto_rerun_interval_millis: int = None,
        auto_rerun_times: int = None,
        cron_express: str = None,
        cycle_type: str = None,
        dependent_node_id_list: str = None,
        dependent_type: str = None,
        end_effect_date: int = None,
        input_list: List[GetFileResponseBodyDataNodeConfigurationInputList] = None,
        output_list: List[GetFileResponseBodyDataNodeConfigurationOutputList] = None,
        para_value: str = None,
        rerun_mode: str = None,
        resource_group_id: int = None,
        scheduler_type: str = None,
        start_effect_date: int = None,
        start_immediately: bool = None,
        stop: bool = None,
    ):
        self.auto_rerun_interval_millis = auto_rerun_interval_millis
        self.auto_rerun_times = auto_rerun_times
        self.cron_express = cron_express
        self.cycle_type = cycle_type
        self.dependent_node_id_list = dependent_node_id_list
        self.dependent_type = dependent_type
        self.end_effect_date = end_effect_date
        self.input_list = input_list
        self.output_list = output_list
        self.para_value = para_value
        self.rerun_mode = rerun_mode
        self.resource_group_id = resource_group_id
        self.scheduler_type = scheduler_type
        self.start_effect_date = start_effect_date
        self.start_immediately = start_immediately
        self.stop = stop

    def validate(self):
        if self.input_list:
            for k in self.input_list:
                if k:
                    k.validate()
        if self.output_list:
            for k in self.output_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        if self.end_effect_date is not None:
            result['EndEffectDate'] = self.end_effect_date
        result['InputList'] = []
        if self.input_list is not None:
            for k in self.input_list:
                result['InputList'].append(k.to_map() if k else None)
        result['OutputList'] = []
        if self.output_list is not None:
            for k in self.output_list:
                result['OutputList'].append(k.to_map() if k else None)
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.start_effect_date is not None:
            result['StartEffectDate'] = self.start_effect_date
        if self.start_immediately is not None:
            result['StartImmediately'] = self.start_immediately
        if self.stop is not None:
            result['Stop'] = self.stop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        if m.get('EndEffectDate') is not None:
            self.end_effect_date = m.get('EndEffectDate')
        self.input_list = []
        if m.get('InputList') is not None:
            for k in m.get('InputList'):
                temp_model = GetFileResponseBodyDataNodeConfigurationInputList()
                self.input_list.append(temp_model.from_map(k))
        self.output_list = []
        if m.get('OutputList') is not None:
            for k in m.get('OutputList'):
                temp_model = GetFileResponseBodyDataNodeConfigurationOutputList()
                self.output_list.append(temp_model.from_map(k))
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('StartEffectDate') is not None:
            self.start_effect_date = m.get('StartEffectDate')
        if m.get('StartImmediately') is not None:
            self.start_immediately = m.get('StartImmediately')
        if m.get('Stop') is not None:
            self.stop = m.get('Stop')
        return self


class GetFileResponseBodyData(TeaModel):
    def __init__(
        self,
        file: GetFileResponseBodyDataFile = None,
        node_configuration: GetFileResponseBodyDataNodeConfiguration = None,
    ):
        self.file = file
        self.node_configuration = node_configuration

    def validate(self):
        if self.file:
            self.file.validate()
        if self.node_configuration:
            self.node_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.node_configuration is not None:
            result['NodeConfiguration'] = self.node_configuration.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('File') is not None:
            temp_model = GetFileResponseBodyDataFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('NodeConfiguration') is not None:
            temp_model = GetFileResponseBodyDataNodeConfiguration()
            self.node_configuration = temp_model.from_map(m['NodeConfiguration'])
        return self


class GetFileResponseBody(TeaModel):
    def __init__(
        self,
        data: GetFileResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetFileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileTypeStatisticRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        project_id: int = None,
    ):
        self.project_env = project_env
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetFileTypeStatisticResponseBodyProgramTypeAndCounts(TeaModel):
    def __init__(
        self,
        count: int = None,
        program_type: str = None,
    ):
        self.count = count
        self.program_type = program_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        return self


class GetFileTypeStatisticResponseBody(TeaModel):
    def __init__(
        self,
        program_type_and_counts: List[GetFileTypeStatisticResponseBodyProgramTypeAndCounts] = None,
        request_id: str = None,
    ):
        self.program_type_and_counts = program_type_and_counts
        self.request_id = request_id

    def validate(self):
        if self.program_type_and_counts:
            for k in self.program_type_and_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProgramTypeAndCounts'] = []
        if self.program_type_and_counts is not None:
            for k in self.program_type_and_counts:
                result['ProgramTypeAndCounts'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.program_type_and_counts = []
        if m.get('ProgramTypeAndCounts') is not None:
            for k in m.get('ProgramTypeAndCounts'):
                temp_model = GetFileTypeStatisticResponseBodyProgramTypeAndCounts()
                self.program_type_and_counts.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetFileTypeStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetFileTypeStatisticResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFileTypeStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileVersionRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        file_version: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.file_id = file_id
        self.file_version = file_version
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetFileVersionResponseBodyData(TeaModel):
    def __init__(
        self,
        change_type: str = None,
        comment: str = None,
        commit_time: int = None,
        commit_user: str = None,
        file_content: str = None,
        file_name: str = None,
        file_property_content: str = None,
        file_version: int = None,
        is_current_prod: bool = None,
        node_content: str = None,
        node_id: int = None,
        status: str = None,
        use_type: str = None,
    ):
        self.change_type = change_type
        self.comment = comment
        self.commit_time = commit_time
        self.commit_user = commit_user
        self.file_content = file_content
        self.file_name = file_name
        self.file_property_content = file_property_content
        self.file_version = file_version
        self.is_current_prod = is_current_prod
        self.node_content = node_content
        self.node_id = node_id
        self.status = status
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.commit_time is not None:
            result['CommitTime'] = self.commit_time
        if self.commit_user is not None:
            result['CommitUser'] = self.commit_user
        if self.file_content is not None:
            result['FileContent'] = self.file_content
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_property_content is not None:
            result['FilePropertyContent'] = self.file_property_content
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.is_current_prod is not None:
            result['IsCurrentProd'] = self.is_current_prod
        if self.node_content is not None:
            result['NodeContent'] = self.node_content
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.status is not None:
            result['Status'] = self.status
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CommitTime') is not None:
            self.commit_time = m.get('CommitTime')
        if m.get('CommitUser') is not None:
            self.commit_user = m.get('CommitUser')
        if m.get('FileContent') is not None:
            self.file_content = m.get('FileContent')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePropertyContent') is not None:
            self.file_property_content = m.get('FilePropertyContent')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('IsCurrentProd') is not None:
            self.is_current_prod = m.get('IsCurrentProd')
        if m.get('NodeContent') is not None:
            self.node_content = m.get('NodeContent')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetFileVersionResponseBody(TeaModel):
    def __init__(
        self,
        data: GetFileVersionResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetFileVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFileVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetFileVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFileVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFolderRequest(TeaModel):
    def __init__(
        self,
        folder_id: str = None,
        folder_path: str = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.folder_id = folder_id
        self.folder_path = folder_path
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetFolderResponseBodyData(TeaModel):
    def __init__(
        self,
        folder_id: str = None,
        folder_path: str = None,
    ):
        self.folder_id = folder_id
        self.folder_path = folder_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        return self


class GetFolderResponseBody(TeaModel):
    def __init__(
        self,
        data: GetFolderResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetFolderResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIDEEventDetailRequest(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        project_id: int = None,
    ):
        self.message_id = message_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFileFilePropertyContent(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        current_version: int = None,
        data_source_name: str = None,
        folder_id: str = None,
        owner: str = None,
        parent_file_id: int = None,
    ):
        self.business_id = business_id
        self.current_version = current_version
        self.data_source_name = data_source_name
        self.folder_id = folder_id
        self.owner = owner
        self.parent_file_id = parent_file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.parent_file_id is not None:
            result['ParentFileId'] = self.parent_file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ParentFileId') is not None:
            self.parent_file_id = m.get('ParentFileId')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationInputList(TeaModel):
    def __init__(
        self,
        input: str = None,
        parse_type: str = None,
    ):
        self.input = input
        self.parse_type = parse_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input is not None:
            result['Input'] = self.input
        if self.parse_type is not None:
            result['ParseType'] = self.parse_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('ParseType') is not None:
            self.parse_type = m.get('ParseType')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationOutputList(TeaModel):
    def __init__(
        self,
        output: str = None,
        ref_table_name: str = None,
    ):
        self.output = output
        self.ref_table_name = ref_table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output
        if self.ref_table_name is not None:
            result['RefTableName'] = self.ref_table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('RefTableName') is not None:
            self.ref_table_name = m.get('RefTableName')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfiguration(TeaModel):
    def __init__(
        self,
        auto_rerun_interval_millis: int = None,
        auto_rerun_times: int = None,
        cron_express: str = None,
        cycle_type: str = None,
        dependent_node_id_list: str = None,
        dependent_type: str = None,
        input_list: List[GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationInputList] = None,
        output_list: List[GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationOutputList] = None,
        para_value: str = None,
        rerun_mode: str = None,
        resource_group_id: int = None,
        scheduler_type: str = None,
    ):
        self.auto_rerun_interval_millis = auto_rerun_interval_millis
        self.auto_rerun_times = auto_rerun_times
        self.cron_express = cron_express
        self.cycle_type = cycle_type
        self.dependent_node_id_list = dependent_node_id_list
        self.dependent_type = dependent_type
        self.input_list = input_list
        self.output_list = output_list
        self.para_value = para_value
        self.rerun_mode = rerun_mode
        self.resource_group_id = resource_group_id
        self.scheduler_type = scheduler_type

    def validate(self):
        if self.input_list:
            for k in self.input_list:
                if k:
                    k.validate()
        if self.output_list:
            for k in self.output_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        result['InputList'] = []
        if self.input_list is not None:
            for k in self.input_list:
                result['InputList'].append(k.to_map() if k else None)
        result['OutputList'] = []
        if self.output_list is not None:
            for k in self.output_list:
                result['OutputList'].append(k.to_map() if k else None)
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        self.input_list = []
        if m.get('InputList') is not None:
            for k in m.get('InputList'):
                temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationInputList()
                self.input_list.append(temp_model.from_map(k))
        self.output_list = []
        if m.get('OutputList') is not None:
            for k in m.get('OutputList'):
                temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationOutputList()
                self.output_list.append(temp_model.from_map(k))
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFile(TeaModel):
    def __init__(
        self,
        change_type: str = None,
        comment: str = None,
        committor: str = None,
        content: str = None,
        file_id: int = None,
        file_name: str = None,
        file_property_content: GetIDEEventDetailResponseBodyEventDetailCommittedFileFilePropertyContent = None,
        file_type: int = None,
        node_configuration: GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfiguration = None,
        node_id: int = None,
        use_type: str = None,
    ):
        self.change_type = change_type
        self.comment = comment
        self.committor = committor
        self.content = content
        self.file_id = file_id
        self.file_name = file_name
        self.file_property_content = file_property_content
        self.file_type = file_type
        self.node_configuration = node_configuration
        self.node_id = node_id
        self.use_type = use_type

    def validate(self):
        if self.file_property_content:
            self.file_property_content.validate()
        if self.node_configuration:
            self.node_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.committor is not None:
            result['Committor'] = self.committor
        if self.content is not None:
            result['Content'] = self.content
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_property_content is not None:
            result['FilePropertyContent'] = self.file_property_content.to_map()
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.node_configuration is not None:
            result['NodeConfiguration'] = self.node_configuration.to_map()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Committor') is not None:
            self.committor = m.get('Committor')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePropertyContent') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFileFilePropertyContent()
            self.file_property_content = temp_model.from_map(m['FilePropertyContent'])
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('NodeConfiguration') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfiguration()
            self.node_configuration = temp_model.from_map(m['NodeConfiguration'])
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetIDEEventDetailResponseBodyEventDetailDeletedFile(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        content: str = None,
        current_version: int = None,
        data_source_name: str = None,
        file_id: int = None,
        file_name: str = None,
        file_type: int = None,
        folder_id: str = None,
        node_id: int = None,
        owner: str = None,
        parent_file_id: int = None,
        use_type: str = None,
    ):
        self.business_id = business_id
        self.content = content
        self.current_version = current_version
        self.data_source_name = data_source_name
        self.file_id = file_id
        self.file_name = file_name
        self.file_type = file_type
        self.folder_id = folder_id
        self.node_id = node_id
        self.owner = owner
        self.parent_file_id = parent_file_id
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.content is not None:
            result['Content'] = self.content
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.parent_file_id is not None:
            result['ParentFileId'] = self.parent_file_id
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ParentFileId') is not None:
            self.parent_file_id = m.get('ParentFileId')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetIDEEventDetailResponseBodyEventDetailFileExecutionCommand(TeaModel):
    def __init__(
        self,
        content: str = None,
        data_source_name: str = None,
        file_id: int = None,
        file_type: int = None,
    ):
        self.content = content
        self.data_source_name = data_source_name
        self.file_id = file_id
        self.file_type = file_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_type is not None:
            result['FileType'] = self.file_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        return self


class GetIDEEventDetailResponseBodyEventDetailTableModelColumns(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_type: str = None,
        comment: str = None,
        is_partition_column: bool = None,
    ):
        self.column_name = column_name
        self.column_type = column_type
        self.comment = comment
        self.is_partition_column = is_partition_column

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        return self


class GetIDEEventDetailResponseBodyEventDetailTableModel(TeaModel):
    def __init__(
        self,
        columns: List[GetIDEEventDetailResponseBodyEventDetailTableModelColumns] = None,
        comment: str = None,
        data_source_name: str = None,
        env: str = None,
        life_cycle: int = None,
        location: str = None,
        table_name: str = None,
    ):
        self.columns = columns
        self.comment = comment
        self.data_source_name = data_source_name
        self.env = env
        self.life_cycle = life_cycle
        self.location = location
        self.table_name = table_name

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.env is not None:
            result['Env'] = self.env
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.location is not None:
            result['Location'] = self.location
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = GetIDEEventDetailResponseBodyEventDetailTableModelColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('Env') is not None:
            self.env = m.get('Env')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetIDEEventDetailResponseBodyEventDetail(TeaModel):
    def __init__(
        self,
        committed_file: GetIDEEventDetailResponseBodyEventDetailCommittedFile = None,
        deleted_file: GetIDEEventDetailResponseBodyEventDetailDeletedFile = None,
        file_execution_command: GetIDEEventDetailResponseBodyEventDetailFileExecutionCommand = None,
        table_model: GetIDEEventDetailResponseBodyEventDetailTableModel = None,
    ):
        self.committed_file = committed_file
        self.deleted_file = deleted_file
        self.file_execution_command = file_execution_command
        self.table_model = table_model

    def validate(self):
        if self.committed_file:
            self.committed_file.validate()
        if self.deleted_file:
            self.deleted_file.validate()
        if self.file_execution_command:
            self.file_execution_command.validate()
        if self.table_model:
            self.table_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.committed_file is not None:
            result['CommittedFile'] = self.committed_file.to_map()
        if self.deleted_file is not None:
            result['DeletedFile'] = self.deleted_file.to_map()
        if self.file_execution_command is not None:
            result['FileExecutionCommand'] = self.file_execution_command.to_map()
        if self.table_model is not None:
            result['TableModel'] = self.table_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommittedFile') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFile()
            self.committed_file = temp_model.from_map(m['CommittedFile'])
        if m.get('DeletedFile') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailDeletedFile()
            self.deleted_file = temp_model.from_map(m['DeletedFile'])
        if m.get('FileExecutionCommand') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailFileExecutionCommand()
            self.file_execution_command = temp_model.from_map(m['FileExecutionCommand'])
        if m.get('TableModel') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailTableModel()
            self.table_model = temp_model.from_map(m['TableModel'])
        return self


class GetIDEEventDetailResponseBody(TeaModel):
    def __init__(
        self,
        event_detail: GetIDEEventDetailResponseBodyEventDetail = None,
        request_id: str = None,
    ):
        self.event_detail = event_detail
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.event_detail:
            self.event_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_detail is not None:
            result['EventDetail'] = self.event_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventDetail') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetail()
            self.event_detail = temp_model.from_map(m['EventDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetIDEEventDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetIDEEventDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetIDEEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: int = None,
        project_env: str = None,
    ):
        self.instance_id = instance_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        begin_running_time: int = None,
        begin_wait_res_time: int = None,
        begin_wait_time_time: int = None,
        bizdate: int = None,
        business_id: int = None,
        connection: str = None,
        create_time: int = None,
        create_user: str = None,
        cyc_time: int = None,
        dag_id: int = None,
        dag_type: str = None,
        dqc_description: str = None,
        dqc_type: int = None,
        finish_time: int = None,
        instance_id: int = None,
        modify_time: int = None,
        node_id: int = None,
        node_name: str = None,
        param_values: str = None,
        priority: int = None,
        related_flow_id: int = None,
        repeat_interval: int = None,
        repeatability: bool = None,
        status: str = None,
        task_rerun_time: int = None,
        task_type: str = None,
    ):
        self.baseline_id = baseline_id
        self.begin_running_time = begin_running_time
        self.begin_wait_res_time = begin_wait_res_time
        self.begin_wait_time_time = begin_wait_time_time
        self.bizdate = bizdate
        self.business_id = business_id
        self.connection = connection
        self.create_time = create_time
        self.create_user = create_user
        self.cyc_time = cyc_time
        self.dag_id = dag_id
        self.dag_type = dag_type
        self.dqc_description = dqc_description
        self.dqc_type = dqc_type
        self.finish_time = finish_time
        self.instance_id = instance_id
        self.modify_time = modify_time
        self.node_id = node_id
        self.node_name = node_name
        self.param_values = param_values
        self.priority = priority
        self.related_flow_id = related_flow_id
        self.repeat_interval = repeat_interval
        self.repeatability = repeatability
        self.status = status
        self.task_rerun_time = task_rerun_time
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.status is not None:
            result['Status'] = self.status
        if self.task_rerun_time is not None:
            result['TaskRerunTime'] = self.task_rerun_time
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskRerunTime') is not None:
            self.task_rerun_time = m.get('TaskRerunTime')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetInstanceResponseBody(TeaModel):
    def __init__(
        self,
        data: GetInstanceResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceConsumeTimeRankRequest(TeaModel):
    def __init__(
        self,
        bizdate: str = None,
        project_id: int = None,
    ):
        self.bizdate = bizdate
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank(TeaModel):
    def __init__(
        self,
        bizdate: int = None,
        consumed: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        prg_type: int = None,
    ):
        self.bizdate = bizdate
        self.consumed = consumed
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.prg_type = prg_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.consumed is not None:
            result['Consumed'] = self.consumed
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Consumed') is not None:
            self.consumed = m.get('Consumed')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        return self


class GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank(TeaModel):
    def __init__(
        self,
        consume_time_rank: List[GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank] = None,
        update_time: int = None,
    ):
        self.consume_time_rank = consume_time_rank
        self.update_time = update_time

    def validate(self):
        if self.consume_time_rank:
            for k in self.consume_time_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConsumeTimeRank'] = []
        if self.consume_time_rank is not None:
            for k in self.consume_time_rank:
                result['ConsumeTimeRank'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.consume_time_rank = []
        if m.get('ConsumeTimeRank') is not None:
            for k in m.get('ConsumeTimeRank'):
                temp_model = GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank()
                self.consume_time_rank.append(temp_model.from_map(k))
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetInstanceConsumeTimeRankResponseBody(TeaModel):
    def __init__(
        self,
        instance_consume_time_rank: GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank = None,
        request_id: str = None,
    ):
        self.instance_consume_time_rank = instance_consume_time_rank
        self.request_id = request_id

    def validate(self):
        if self.instance_consume_time_rank:
            self.instance_consume_time_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_consume_time_rank is not None:
            result['InstanceConsumeTimeRank'] = self.instance_consume_time_rank.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceConsumeTimeRank') is not None:
            temp_model = GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank()
            self.instance_consume_time_rank = temp_model.from_map(m['InstanceConsumeTimeRank'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceConsumeTimeRankResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceConsumeTimeRankResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceConsumeTimeRankResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceCountTrendRequest(TeaModel):
    def __init__(
        self,
        begin_date: str = None,
        end_date: str = None,
        project_id: int = None,
    ):
        self.begin_date = begin_date
        self.end_date = end_date
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_date is not None:
            result['BeginDate'] = self.begin_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginDate') is not None:
            self.begin_date = m.get('BeginDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceCountTrendResponseBodyInstanceCounts(TeaModel):
    def __init__(
        self,
        count: int = None,
        date: int = None,
    ):
        self.count = count
        self.date = date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.date is not None:
            result['Date'] = self.date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        return self


class GetInstanceCountTrendResponseBody(TeaModel):
    def __init__(
        self,
        instance_counts: List[GetInstanceCountTrendResponseBodyInstanceCounts] = None,
        request_id: str = None,
    ):
        self.instance_counts = instance_counts
        self.request_id = request_id

    def validate(self):
        if self.instance_counts:
            for k in self.instance_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceCounts'] = []
        if self.instance_counts is not None:
            for k in self.instance_counts:
                result['InstanceCounts'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_counts = []
        if m.get('InstanceCounts') is not None:
            for k in m.get('InstanceCounts'):
                temp_model = GetInstanceCountTrendResponseBodyInstanceCounts()
                self.instance_counts.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceCountTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceCountTrendResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceCountTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceErrorRankRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank(TeaModel):
    def __init__(
        self,
        count: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        prg_type: int = None,
        project_id: int = None,
    ):
        self.count = count
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.prg_type = prg_type
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceErrorRankResponseBodyInstanceErrorRank(TeaModel):
    def __init__(
        self,
        error_rank: List[GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank] = None,
        update_time: int = None,
    ):
        self.error_rank = error_rank
        self.update_time = update_time

    def validate(self):
        if self.error_rank:
            for k in self.error_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ErrorRank'] = []
        if self.error_rank is not None:
            for k in self.error_rank:
                result['ErrorRank'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.error_rank = []
        if m.get('ErrorRank') is not None:
            for k in m.get('ErrorRank'):
                temp_model = GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank()
                self.error_rank.append(temp_model.from_map(k))
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetInstanceErrorRankResponseBody(TeaModel):
    def __init__(
        self,
        instance_error_rank: GetInstanceErrorRankResponseBodyInstanceErrorRank = None,
        request_id: str = None,
    ):
        self.instance_error_rank = instance_error_rank
        self.request_id = request_id

    def validate(self):
        if self.instance_error_rank:
            self.instance_error_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_error_rank is not None:
            result['InstanceErrorRank'] = self.instance_error_rank.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceErrorRank') is not None:
            temp_model = GetInstanceErrorRankResponseBodyInstanceErrorRank()
            self.instance_error_rank = temp_model.from_map(m['InstanceErrorRank'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceErrorRankResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceErrorRankResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceErrorRankResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceLogRequest(TeaModel):
    def __init__(
        self,
        instance_id: int = None,
        project_env: str = None,
    ):
        self.instance_id = instance_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetInstanceLogResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceStatusCountRequest(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        project_env: str = None,
        project_id: int = None,
    ):
        self.biz_date = biz_date
        self.project_env = project_env
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceStatusCountResponseBodyStatusCount(TeaModel):
    def __init__(
        self,
        failure_count: int = None,
        not_run_count: int = None,
        running_count: int = None,
        success_count: int = None,
        total_count: int = None,
        wait_res_count: int = None,
        wait_time_count: int = None,
    ):
        self.failure_count = failure_count
        self.not_run_count = not_run_count
        self.running_count = running_count
        self.success_count = success_count
        self.total_count = total_count
        self.wait_res_count = wait_res_count
        self.wait_time_count = wait_time_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        return self


class GetInstanceStatusCountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status_count: GetInstanceStatusCountResponseBodyStatusCount = None,
    ):
        self.request_id = request_id
        self.status_count = status_count

    def validate(self):
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusCountResponseBodyStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class GetInstanceStatusCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceStatusCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceStatusCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceStatusStatisticRequest(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        dag_type: str = None,
        project_env: str = None,
        project_id: int = None,
        scheduler_type: str = None,
    ):
        self.biz_date = biz_date
        self.dag_type = dag_type
        self.project_env = project_env
        self.project_id = project_id
        self.scheduler_type = scheduler_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class GetInstanceStatusStatisticResponseBodyStatusCount(TeaModel):
    def __init__(
        self,
        failure_count: int = None,
        not_run_count: int = None,
        running_count: int = None,
        success_count: int = None,
        total_count: int = None,
        wait_res_count: int = None,
        wait_time_count: int = None,
    ):
        self.failure_count = failure_count
        self.not_run_count = not_run_count
        self.running_count = running_count
        self.success_count = success_count
        self.total_count = total_count
        self.wait_res_count = wait_res_count
        self.wait_time_count = wait_time_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        return self


class GetInstanceStatusStatisticResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status_count: GetInstanceStatusStatisticResponseBodyStatusCount = None,
    ):
        self.request_id = request_id
        self.status_count = status_count

    def validate(self):
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusStatisticResponseBodyStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class GetInstanceStatusStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceStatusStatisticResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceStatusStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetManualDagInstancesRequest(TeaModel):
    def __init__(
        self,
        dag_id: str = None,
        project_env: str = None,
        project_name: str = None,
    ):
        self.dag_id = dag_id
        self.project_env = project_env
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class GetManualDagInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        begin_running_time: int = None,
        begin_wait_res_time: int = None,
        begin_wait_time_time: int = None,
        biz_date: int = None,
        create_time: int = None,
        create_user: str = None,
        cyc_time: int = None,
        dag_id: int = None,
        dag_type: str = None,
        finish_time: int = None,
        instance_id: int = None,
        modify_time: int = None,
        node_id: int = None,
        node_name: str = None,
        param_values: str = None,
        status: str = None,
        task_type: str = None,
    ):
        self.begin_running_time = begin_running_time
        self.begin_wait_res_time = begin_wait_res_time
        self.begin_wait_time_time = begin_wait_time_time
        self.biz_date = biz_date
        self.create_time = create_time
        self.create_user = create_user
        self.cyc_time = cyc_time
        self.dag_id = dag_id
        self.dag_type = dag_type
        self.finish_time = finish_time
        self.instance_id = instance_id
        self.modify_time = modify_time
        self.node_id = node_id
        self.node_name = node_name
        self.param_values = param_values
        self.status = status
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.status is not None:
            result['Status'] = self.status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetManualDagInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[GetManualDagInstancesResponseBodyInstances] = None,
        request_id: str = None,
    ):
        self.instances = instances
        self.request_id = request_id

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = GetManualDagInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetManualDagInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetManualDagInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetManualDagInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        parent_category_id: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.parent_category_id = parent_category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        return self


class GetMetaCategoryResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        comment: str = None,
        create_time: int = None,
        depth: int = None,
        last_operator_id: str = None,
        modified_time: int = None,
        name: str = None,
        owner_id: str = None,
        parent_category_id: int = None,
    ):
        self.category_id = category_id
        self.comment = comment
        self.create_time = create_time
        self.depth = depth
        self.last_operator_id = last_operator_id
        self.modified_time = modified_time
        self.name = name
        self.owner_id = owner_id
        self.parent_category_id = parent_category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.depth is not None:
            result['Depth'] = self.depth
        if self.last_operator_id is not None:
            result['LastOperatorId'] = self.last_operator_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Depth') is not None:
            self.depth = m.get('Depth')
        if m.get('LastOperatorId') is not None:
            self.last_operator_id = m.get('LastOperatorId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        return self


class GetMetaCategoryResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaCategoryResponseBodyDataDataEntityList] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.data_entity_list = data_entity_list
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaCategoryResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaCategoryResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaColumnLineageRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        column_guid: str = None,
        column_name: str = None,
        data_source_type: str = None,
        database_name: str = None,
        direction: str = None,
        page_num: int = None,
        page_size: int = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.column_guid = column_guid
        self.column_name = column_name
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.direction = direction
        self.page_num = page_num
        self.page_size = page_size
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaColumnLineageResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        column_guid: str = None,
        column_name: str = None,
        database_name: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.column_guid = column_guid
        self.column_name = column_name
        self.database_name = database_name
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaColumnLineageResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaColumnLineageResponseBodyDataDataEntityList] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.data_entity_list = data_entity_list
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaColumnLineageResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaColumnLineageResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaColumnLineageResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaColumnLineageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaColumnLineageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaColumnLineageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaColumnLineageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaDBInfoRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
    ):
        self.app_guid = app_guid
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        return self


class GetMetaDBInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        cluster_biz_id: str = None,
        comment: str = None,
        create_time: int = None,
        endpoint: str = None,
        env_type: int = None,
        location: str = None,
        modify_time: int = None,
        name: str = None,
        owner_id: str = None,
        owner_name: str = None,
        project_id: int = None,
        project_name: str = None,
        project_name_cn: str = None,
        tenant_id: int = None,
        type: str = None,
    ):
        self.app_guid = app_guid
        self.cluster_biz_id = cluster_biz_id
        self.comment = comment
        self.create_time = create_time
        self.endpoint = endpoint
        self.env_type = env_type
        self.location = location
        self.modify_time = modify_time
        self.name = name
        self.owner_id = owner_id
        self.owner_name = owner_name
        self.project_id = project_id
        self.project_name = project_name
        self.project_name_cn = project_name_cn
        self.tenant_id = tenant_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.location is not None:
            result['Location'] = self.location
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_name is not None:
            result['OwnerName'] = self.owner_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_name_cn is not None:
            result['ProjectNameCn'] = self.project_name_cn
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerName') is not None:
            self.owner_name = m.get('OwnerName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectNameCn') is not None:
            self.project_name_cn = m.get('ProjectNameCn')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetMetaDBInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaDBInfoResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaDBInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMetaDBInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaDBInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaDBInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaDBTableListRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.app_guid = app_guid
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetMetaDBTableListResponseBodyDataTableEntityList(TeaModel):
    def __init__(
        self,
        database_name: str = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.database_name = database_name
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaDBTableListResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_entity_list: List[GetMetaDBTableListResponseBodyDataTableEntityList] = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.table_entity_list = table_entity_list
        self.total_count = total_count

    def validate(self):
        if self.table_entity_list:
            for k in self.table_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['TableEntityList'] = []
        if self.table_entity_list is not None:
            for k in self.table_entity_list:
                result['TableEntityList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.table_entity_list = []
        if m.get('TableEntityList') is not None:
            for k in m.get('TableEntityList'):
                temp_model = GetMetaDBTableListResponseBodyDataTableEntityList()
                self.table_entity_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaDBTableListResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaDBTableListResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaDBTableListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMetaDBTableListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaDBTableListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaDBTableListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableBasicInfoRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        extension: bool = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.extension = extension
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableBasicInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        caption: str = None,
        cluster_id: str = None,
        column_count: int = None,
        comment: str = None,
        create_time: int = None,
        data_size: int = None,
        database_name: str = None,
        env_type: int = None,
        favorite_count: int = None,
        is_partition_table: bool = None,
        is_view: bool = None,
        is_visible: int = None,
        last_access_time: int = None,
        last_ddl_time: int = None,
        last_modify_time: int = None,
        life_cycle: int = None,
        location: str = None,
        owner_id: str = None,
        partition_keys: str = None,
        project_id: int = None,
        project_name: str = None,
        read_count: int = None,
        table_guid: str = None,
        table_name: str = None,
        tenant_id: int = None,
        view_count: int = None,
    ):
        self.caption = caption
        self.cluster_id = cluster_id
        self.column_count = column_count
        self.comment = comment
        self.create_time = create_time
        self.data_size = data_size
        self.database_name = database_name
        self.env_type = env_type
        self.favorite_count = favorite_count
        self.is_partition_table = is_partition_table
        self.is_view = is_view
        self.is_visible = is_visible
        self.last_access_time = last_access_time
        self.last_ddl_time = last_ddl_time
        self.last_modify_time = last_modify_time
        self.life_cycle = life_cycle
        self.location = location
        self.owner_id = owner_id
        self.partition_keys = partition_keys
        self.project_id = project_id
        self.project_name = project_name
        self.read_count = read_count
        self.table_guid = table_guid
        self.table_name = table_name
        self.tenant_id = tenant_id
        self.view_count = view_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.column_count is not None:
            result['ColumnCount'] = self.column_count
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.favorite_count is not None:
            result['FavoriteCount'] = self.favorite_count
        if self.is_partition_table is not None:
            result['IsPartitionTable'] = self.is_partition_table
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.location is not None:
            result['Location'] = self.location
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.read_count is not None:
            result['ReadCount'] = self.read_count
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.view_count is not None:
            result['ViewCount'] = self.view_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ColumnCount') is not None:
            self.column_count = m.get('ColumnCount')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('FavoriteCount') is not None:
            self.favorite_count = m.get('FavoriteCount')
        if m.get('IsPartitionTable') is not None:
            self.is_partition_table = m.get('IsPartitionTable')
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ReadCount') is not None:
            self.read_count = m.get('ReadCount')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ViewCount') is not None:
            self.view_count = m.get('ViewCount')
        return self


class GetMetaTableBasicInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableBasicInfoResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableBasicInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableBasicInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableBasicInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableBasicInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableChangeLogRequest(TeaModel):
    def __init__(
        self,
        change_type: str = None,
        end_date: str = None,
        object_type: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        table_guid: str = None,
    ):
        self.change_type = change_type
        self.end_date = end_date
        self.object_type = object_type
        self.page_number = page_number
        self.page_size = page_size
        self.start_date = start_date
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTableChangeLogResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        change_content: str = None,
        change_type: str = None,
        create_time: int = None,
        modified_time: int = None,
        object_type: str = None,
        operator: str = None,
    ):
        self.change_content = change_content
        self.change_type = change_type
        self.create_time = create_time
        self.modified_time = modified_time
        self.object_type = object_type
        self.operator = operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_content is not None:
            result['ChangeContent'] = self.change_content
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.operator is not None:
            result['Operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeContent') is not None:
            self.change_content = m.get('ChangeContent')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        return self


class GetMetaTableChangeLogResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaTableChangeLogResponseBodyDataDataEntityList] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.data_entity_list = data_entity_list
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableChangeLogResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTableChangeLogResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableChangeLogResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableChangeLogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableChangeLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableChangeLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableChangeLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableColumnRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        page_num: int = None,
        page_size: int = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.page_num = page_num
        self.page_size = page_size
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableColumnResponseBodyDataColumnList(TeaModel):
    def __init__(
        self,
        caption: str = None,
        column_guid: str = None,
        column_name: str = None,
        column_type: str = None,
        comment: str = None,
        is_foreign_key: bool = None,
        is_partition_column: bool = None,
        is_primary_key: bool = None,
        position: int = None,
        relation_count: int = None,
    ):
        self.caption = caption
        self.column_guid = column_guid
        self.column_name = column_name
        self.column_type = column_type
        self.comment = comment
        self.is_foreign_key = is_foreign_key
        self.is_partition_column = is_partition_column
        self.is_primary_key = is_primary_key
        self.position = position
        self.relation_count = relation_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.position is not None:
            result['Position'] = self.position
        if self.relation_count is not None:
            result['RelationCount'] = self.relation_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        if m.get('RelationCount') is not None:
            self.relation_count = m.get('RelationCount')
        return self


class GetMetaTableColumnResponseBodyData(TeaModel):
    def __init__(
        self,
        column_list: List[GetMetaTableColumnResponseBodyDataColumnList] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.column_list = column_list
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableColumnResponseBodyDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTableColumnResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableColumnResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableColumnResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableColumnResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableColumnResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableColumnResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableFullInfoRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        page_num: int = None,
        page_size: int = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.page_num = page_num
        self.page_size = page_size
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableFullInfoResponseBodyDataColumnList(TeaModel):
    def __init__(
        self,
        caption: str = None,
        column_guid: str = None,
        column_name: str = None,
        column_type: str = None,
        comment: str = None,
        is_foreign_key: bool = None,
        is_partition_column: bool = None,
        is_primary_key: bool = None,
        position: int = None,
    ):
        self.caption = caption
        self.column_guid = column_guid
        self.column_name = column_name
        self.column_type = column_type
        self.comment = comment
        self.is_foreign_key = is_foreign_key
        self.is_partition_column = is_partition_column
        self.is_primary_key = is_primary_key
        self.position = position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class GetMetaTableFullInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        column_list: List[GetMetaTableFullInfoResponseBodyDataColumnList] = None,
        comment: str = None,
        create_time: int = None,
        data_size: int = None,
        database_name: str = None,
        env_type: int = None,
        is_visible: int = None,
        last_access_time: int = None,
        last_ddl_time: int = None,
        last_modify_time: int = None,
        life_cycle: int = None,
        location: str = None,
        owner_id: str = None,
        partition_keys: str = None,
        project_id: int = None,
        project_name: str = None,
        table_guid: str = None,
        table_name: str = None,
        tenant_id: int = None,
        total_column_count: int = None,
    ):
        self.cluster_id = cluster_id
        self.column_list = column_list
        self.comment = comment
        self.create_time = create_time
        self.data_size = data_size
        self.database_name = database_name
        self.env_type = env_type
        self.is_visible = is_visible
        self.last_access_time = last_access_time
        self.last_ddl_time = last_ddl_time
        self.last_modify_time = last_modify_time
        self.life_cycle = life_cycle
        self.location = location
        self.owner_id = owner_id
        self.partition_keys = partition_keys
        self.project_id = project_id
        self.project_name = project_name
        self.table_guid = table_guid
        self.table_name = table_name
        self.tenant_id = tenant_id
        self.total_column_count = total_column_count

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.location is not None:
            result['Location'] = self.location
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.total_column_count is not None:
            result['TotalColumnCount'] = self.total_column_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableFullInfoResponseBodyDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('TotalColumnCount') is not None:
            self.total_column_count = m.get('TotalColumnCount')
        return self


class GetMetaTableFullInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableFullInfoResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableFullInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableFullInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableFullInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableFullInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableIntroWikiRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        wiki_version: int = None,
    ):
        self.table_guid = table_guid
        self.wiki_version = wiki_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.wiki_version is not None:
            result['WikiVersion'] = self.wiki_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('WikiVersion') is not None:
            self.wiki_version = m.get('WikiVersion')
        return self


class GetMetaTableIntroWikiResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: int = None,
        creator: str = None,
        creator_name: str = None,
        modified_time: int = None,
        version: int = None,
    ):
        self.content = content
        self.create_time = create_time
        self.creator = creator
        self.creator_name = creator_name
        self.modified_time = modified_time
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetMetaTableIntroWikiResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableIntroWikiResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableIntroWikiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableIntroWikiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableIntroWikiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableIntroWikiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableLineageRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        direction: str = None,
        next_primary_key: str = None,
        page_size: int = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.direction = direction
        self.next_primary_key = next_primary_key
        self.page_size = page_size
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.next_primary_key is not None:
            result['NextPrimaryKey'] = self.next_primary_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('NextPrimaryKey') is not None:
            self.next_primary_key = m.get('NextPrimaryKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableLineageResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        create_timestamp: int = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.create_timestamp = create_timestamp
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableLineageResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaTableLineageResponseBodyDataDataEntityList] = None,
        has_next: bool = None,
        next_primary_key: str = None,
    ):
        self.data_entity_list = data_entity_list
        self.has_next = has_next
        self.next_primary_key = next_primary_key

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        if self.next_primary_key is not None:
            result['NextPrimaryKey'] = self.next_primary_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableLineageResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        if m.get('NextPrimaryKey') is not None:
            self.next_primary_key = m.get('NextPrimaryKey')
        return self


class GetMetaTableLineageResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableLineageResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableLineageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableLineageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableLineageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableLineageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableListByCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.category_id = category_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetMetaTableListByCategoryResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_guid_list: List[str] = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.table_guid_list = table_guid_list
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid_list is not None:
            result['TableGuidList'] = self.table_guid_list
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuidList') is not None:
            self.table_guid_list = m.get('TableGuidList')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTableListByCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableListByCategoryResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableListByCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableListByCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableListByCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableListByCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableOutputRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        table_guid: str = None,
    ):
        self.end_date = end_date
        self.page_number = page_number
        self.page_size = page_size
        self.start_date = start_date
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTableOutputResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        project_id: int = None,
        start_time: str = None,
        table_guid: str = None,
        task_id: str = None,
        task_instance_id: int = None,
        wait_time: str = None,
    ):
        self.end_time = end_time
        self.project_id = project_id
        self.start_time = start_time
        self.table_guid = table_guid
        self.task_id = task_id
        self.task_instance_id = task_instance_id
        self.wait_time = wait_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_instance_id is not None:
            result['TaskInstanceId'] = self.task_instance_id
        if self.wait_time is not None:
            result['WaitTime'] = self.wait_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskInstanceId') is not None:
            self.task_instance_id = m.get('TaskInstanceId')
        if m.get('WaitTime') is not None:
            self.wait_time = m.get('WaitTime')
        return self


class GetMetaTableOutputResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaTableOutputResponseBodyDataDataEntityList] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.data_entity_list = data_entity_list
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableOutputResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTableOutputResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableOutputResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableOutputResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableOutputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableOutputResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTablePartitionRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        page_number: int = None,
        page_size: int = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.page_number = page_number
        self.page_size = page_size
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTablePartitionResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        comment: str = None,
        create_time: int = None,
        data_size: int = None,
        modified_time: int = None,
        partition_guid: str = None,
        partition_location: str = None,
        partition_name: str = None,
        partition_path: str = None,
        partition_type: str = None,
        record_count: int = None,
        table_guid: str = None,
    ):
        self.comment = comment
        self.create_time = create_time
        self.data_size = data_size
        self.modified_time = modified_time
        self.partition_guid = partition_guid
        self.partition_location = partition_location
        self.partition_name = partition_name
        self.partition_path = partition_path
        self.partition_type = partition_type
        self.record_count = record_count
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.partition_guid is not None:
            result['PartitionGuid'] = self.partition_guid
        if self.partition_location is not None:
            result['PartitionLocation'] = self.partition_location
        if self.partition_name is not None:
            result['PartitionName'] = self.partition_name
        if self.partition_path is not None:
            result['PartitionPath'] = self.partition_path
        if self.partition_type is not None:
            result['PartitionType'] = self.partition_type
        if self.record_count is not None:
            result['RecordCount'] = self.record_count
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('PartitionGuid') is not None:
            self.partition_guid = m.get('PartitionGuid')
        if m.get('PartitionLocation') is not None:
            self.partition_location = m.get('PartitionLocation')
        if m.get('PartitionName') is not None:
            self.partition_name = m.get('PartitionName')
        if m.get('PartitionPath') is not None:
            self.partition_path = m.get('PartitionPath')
        if m.get('PartitionType') is not None:
            self.partition_type = m.get('PartitionType')
        if m.get('RecordCount') is not None:
            self.record_count = m.get('RecordCount')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTablePartitionResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaTablePartitionResponseBodyDataDataEntityList] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.data_entity_list = data_entity_list
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTablePartitionResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTablePartitionResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTablePartitionResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTablePartitionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTablePartitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTablePartitionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTablePartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableThemeLevelRequest(TeaModel):
    def __init__(
        self,
        data_source_type: str = None,
        table_guid: str = None,
    ):
        self.data_source_type = data_source_type
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTableThemeLevelResponseBodyEntityLevel(TeaModel):
    def __init__(
        self,
        description: str = None,
        level_id: int = None,
        name: str = None,
        type: int = None,
    ):
        self.description = description
        self.level_id = level_id
        self.name = name
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetMetaTableThemeLevelResponseBodyEntityTheme(TeaModel):
    def __init__(
        self,
        level: int = None,
        name: str = None,
        parent_id: int = None,
        theme_id: int = None,
    ):
        self.level = level
        self.name = name
        self.parent_id = parent_id
        self.theme_id = theme_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        return self


class GetMetaTableThemeLevelResponseBodyEntity(TeaModel):
    def __init__(
        self,
        level: List[GetMetaTableThemeLevelResponseBodyEntityLevel] = None,
        theme: List[GetMetaTableThemeLevelResponseBodyEntityTheme] = None,
    ):
        self.level = level
        self.theme = theme

    def validate(self):
        if self.level:
            for k in self.level:
                if k:
                    k.validate()
        if self.theme:
            for k in self.theme:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Level'] = []
        if self.level is not None:
            for k in self.level:
                result['Level'].append(k.to_map() if k else None)
        result['Theme'] = []
        if self.theme is not None:
            for k in self.theme:
                result['Theme'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.level = []
        if m.get('Level') is not None:
            for k in m.get('Level'):
                temp_model = GetMetaTableThemeLevelResponseBodyEntityLevel()
                self.level.append(temp_model.from_map(k))
        self.theme = []
        if m.get('Theme') is not None:
            for k in m.get('Theme'):
                temp_model = GetMetaTableThemeLevelResponseBodyEntityTheme()
                self.theme.append(temp_model.from_map(k))
        return self


class GetMetaTableThemeLevelResponseBody(TeaModel):
    def __init__(
        self,
        entity: GetMetaTableThemeLevelResponseBodyEntity = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.entity = entity
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.entity:
            self.entity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity is not None:
            result['Entity'] = self.entity.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Entity') is not None:
            temp_model = GetMetaTableThemeLevelResponseBodyEntity()
            self.entity = temp_model.from_map(m['Entity'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableThemeLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableThemeLevelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableThemeLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMigrationProcessRequest(TeaModel):
    def __init__(
        self,
        migration_id: int = None,
        project_id: int = None,
    ):
        self.migration_id = migration_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migration_id is not None:
            result['MigrationId'] = self.migration_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MigrationId') is not None:
            self.migration_id = m.get('MigrationId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetMigrationProcessResponseBodyData(TeaModel):
    def __init__(
        self,
        task_name: str = None,
        task_status: str = None,
    ):
        self.task_name = task_name
        self.task_status = task_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class GetMigrationProcessResponseBody(TeaModel):
    def __init__(
        self,
        data: List[GetMigrationProcessResponseBodyData] = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetMigrationProcessResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMigrationProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMigrationProcessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMigrationProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMigrationSummaryRequest(TeaModel):
    def __init__(
        self,
        migration_id: int = None,
        project_id: int = None,
    ):
        self.migration_id = migration_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migration_id is not None:
            result['MigrationId'] = self.migration_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MigrationId') is not None:
            self.migration_id = m.get('MigrationId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetMigrationSummaryResponseBodyData(TeaModel):
    def __init__(
        self,
        create_user: str = None,
        download_url: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        migration_id: int = None,
        name: str = None,
        op_user: str = None,
        project_id: int = None,
        status: str = None,
    ):
        self.create_user = create_user
        self.download_url = download_url
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.migration_id = migration_id
        self.name = name
        self.op_user = op_user
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.migration_id is not None:
            result['MigrationId'] = self.migration_id
        if self.name is not None:
            result['Name'] = self.name
        if self.op_user is not None:
            result['OpUser'] = self.op_user
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MigrationId') is not None:
            self.migration_id = m.get('MigrationId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpUser') is not None:
            self.op_user = m.get('OpUser')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetMigrationSummaryResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMigrationSummaryResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMigrationSummaryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMigrationSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMigrationSummaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMigrationSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeResponseBodyData(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        business_id: int = None,
        connection: str = None,
        cron_express: str = None,
        description: str = None,
        dqc_description: str = None,
        dqc_type: int = None,
        node_id: int = None,
        node_name: str = None,
        owner_id: str = None,
        param_values: str = None,
        priority: int = None,
        program_type: str = None,
        project_id: int = None,
        related_flow_id: int = None,
        repeat_interval: int = None,
        repeatability: str = None,
        res_group_name: str = None,
        scheduler_type: str = None,
    ):
        self.baseline_id = baseline_id
        self.business_id = business_id
        self.connection = connection
        self.cron_express = cron_express
        self.description = description
        self.dqc_description = dqc_description
        self.dqc_type = dqc_type
        self.node_id = node_id
        self.node_name = node_name
        self.owner_id = owner_id
        self.param_values = param_values
        self.priority = priority
        self.program_type = program_type
        self.project_id = project_id
        self.related_flow_id = related_flow_id
        self.repeat_interval = repeat_interval
        self.repeatability = repeatability
        self.res_group_name = res_group_name
        self.scheduler_type = scheduler_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.description is not None:
            result['Description'] = self.description
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.res_group_name is not None:
            result['ResGroupName'] = self.res_group_name
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('ResGroupName') is not None:
            self.res_group_name = m.get('ResGroupName')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class GetNodeResponseBody(TeaModel):
    def __init__(
        self,
        data: GetNodeResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetNodeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeChildrenRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeChildrenResponseBodyDataNodes(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        cron_express: str = None,
        node_id: int = None,
        node_name: str = None,
        owner_id: str = None,
        priority: int = None,
        program_type: str = None,
        project_id: int = None,
        repeatability: bool = None,
        scheduler_type: str = None,
    ):
        self.baseline_id = baseline_id
        self.cron_express = cron_express
        self.node_id = node_id
        self.node_name = node_name
        self.owner_id = owner_id
        self.priority = priority
        self.program_type = program_type
        self.project_id = project_id
        self.repeatability = repeatability
        self.scheduler_type = scheduler_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class GetNodeChildrenResponseBodyData(TeaModel):
    def __init__(
        self,
        nodes: List[GetNodeChildrenResponseBodyDataNodes] = None,
    ):
        self.nodes = nodes

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetNodeChildrenResponseBodyDataNodes()
                self.nodes.append(temp_model.from_map(k))
        return self


class GetNodeChildrenResponseBody(TeaModel):
    def __init__(
        self,
        data: GetNodeChildrenResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetNodeChildrenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNodeChildrenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeChildrenResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeChildrenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeCodeRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeCodeResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNodeCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeCodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeOnBaselineRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
    ):
        self.baseline_id = baseline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetNodeOnBaselineResponseBodyData(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetNodeOnBaselineResponseBody(TeaModel):
    def __init__(
        self,
        data: List[GetNodeOnBaselineResponseBodyData] = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: str = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetNodeOnBaselineResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNodeOnBaselineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeOnBaselineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeOnBaselineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeParentsRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeParentsResponseBodyDataNodes(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        cron_express: str = None,
        node_id: int = None,
        node_name: str = None,
        owner_id: str = None,
        priority: int = None,
        program_type: str = None,
        project_id: int = None,
        repeatability: bool = None,
        scheduler_type: str = None,
    ):
        self.baseline_id = baseline_id
        self.cron_express = cron_express
        self.node_id = node_id
        self.node_name = node_name
        self.owner_id = owner_id
        self.priority = priority
        self.program_type = program_type
        self.project_id = project_id
        self.repeatability = repeatability
        self.scheduler_type = scheduler_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class GetNodeParentsResponseBodyData(TeaModel):
    def __init__(
        self,
        nodes: List[GetNodeParentsResponseBodyDataNodes] = None,
    ):
        self.nodes = nodes

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetNodeParentsResponseBodyDataNodes()
                self.nodes.append(temp_model.from_map(k))
        return self


class GetNodeParentsResponseBody(TeaModel):
    def __init__(
        self,
        data: GetNodeParentsResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetNodeParentsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNodeParentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeParentsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeParentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeTypeListInfoRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        locale: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.keyword = keyword
        self.locale = locale
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.locale is not None:
            result['Locale'] = self.locale
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Locale') is not None:
            self.locale = m.get('Locale')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo(TeaModel):
    def __init__(
        self,
        node_type: int = None,
        node_type_name: str = None,
    ):
        self.node_type = node_type
        self.node_type_name = node_type_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.node_type_name is not None:
            result['NodeTypeName'] = self.node_type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('NodeTypeName') is not None:
            self.node_type_name = m.get('NodeTypeName')
        return self


class GetNodeTypeListInfoResponseBodyNodeTypeInfoList(TeaModel):
    def __init__(
        self,
        node_type_info: List[GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.node_type_info = node_type_info
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.node_type_info:
            for k in self.node_type_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeTypeInfo'] = []
        if self.node_type_info is not None:
            for k in self.node_type_info:
                result['NodeTypeInfo'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_type_info = []
        if m.get('NodeTypeInfo') is not None:
            for k in m.get('NodeTypeInfo'):
                temp_model = GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo()
                self.node_type_info.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetNodeTypeListInfoResponseBody(TeaModel):
    def __init__(
        self,
        node_type_info_list: GetNodeTypeListInfoResponseBodyNodeTypeInfoList = None,
        request_id: str = None,
    ):
        self.node_type_info_list = node_type_info_list
        self.request_id = request_id

    def validate(self):
        if self.node_type_info_list:
            self.node_type_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_type_info_list is not None:
            result['NodeTypeInfoList'] = self.node_type_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeTypeInfoList') is not None:
            temp_model = GetNodeTypeListInfoResponseBodyNodeTypeInfoList()
            self.node_type_info_list = temp_model.from_map(m['NodeTypeInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetNodeTypeListInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeTypeListInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeTypeListInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOpRiskDataRequest(TeaModel):
    def __init__(
        self,
        date: str = None,
        name: str = None,
        page_no: int = None,
        page_size: int = None,
        risk_type: str = None,
    ):
        self.date = date
        self.name = name
        self.page_no = page_no
        self.page_size = page_size
        self.risk_type = risk_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.name is not None:
            result['Name'] = self.name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_type is not None:
            result['RiskType'] = self.risk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskType') is not None:
            self.risk_type = m.get('RiskType')
        return self


class GetOpRiskDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        risk_data: str = None,
    ):
        self.request_id = request_id
        self.risk_data = risk_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_data is not None:
            result['RiskData'] = self.risk_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskData') is not None:
            self.risk_data = m.get('RiskData')
        return self


class GetOpRiskDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOpRiskDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOpRiskDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOpSensitiveDataRequest(TeaModel):
    def __init__(
        self,
        date: str = None,
        name: str = None,
        op_type: str = None,
        page_no: int = None,
        page_size: int = None,
    ):
        self.date = date
        self.name = name
        self.op_type = op_type
        self.page_no = page_no
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.name is not None:
            result['Name'] = self.name
        if self.op_type is not None:
            result['OpType'] = self.op_type
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpType') is not None:
            self.op_type = m.get('OpType')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetOpSensitiveDataResponseBody(TeaModel):
    def __init__(
        self,
        op_sensitive_data: str = None,
        request_id: str = None,
    ):
        self.op_sensitive_data = op_sensitive_data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.op_sensitive_data is not None:
            result['OpSensitiveData'] = self.op_sensitive_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpSensitiveData') is not None:
            self.op_sensitive_data = m.get('OpSensitiveData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOpSensitiveDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOpSensitiveDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOpSensitiveDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPermissionApplyOrderDetailRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
    ):
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList(TeaModel):
    def __init__(
        self,
        base_id: str = None,
    ):
        self.base_id = base_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_id is not None:
            result['BaseId'] = self.base_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaseId') is not None:
            self.base_id = m.get('BaseId')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList(TeaModel):
    def __init__(
        self,
        column_comment: str = None,
        column_name: str = None,
    ):
        self.column_comment = column_comment
        self.column_name = column_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_comment is not None:
            result['ColumnComment'] = self.column_comment
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnComment') is not None:
            self.column_comment = m.get('ColumnComment')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList(TeaModel):
    def __init__(
        self,
        column_meta_list: List[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList] = None,
        object_name: str = None,
    ):
        self.column_meta_list = column_meta_list
        self.object_name = object_name

    def validate(self):
        if self.column_meta_list:
            for k in self.column_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ColumnMetaList'] = []
        if self.column_meta_list is not None:
            for k in self.column_meta_list:
                result['ColumnMetaList'].append(k.to_map() if k else None)
        if self.object_name is not None:
            result['ObjectName'] = self.object_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.column_meta_list = []
        if m.get('ColumnMetaList') is not None:
            for k in m.get('ColumnMetaList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList()
                self.column_meta_list.append(temp_model.from_map(k))
        if m.get('ObjectName') is not None:
            self.object_name = m.get('ObjectName')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta(TeaModel):
    def __init__(
        self,
        max_compute_project_name: str = None,
        object_meta_list: List[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList] = None,
        workspace_id: int = None,
    ):
        self.max_compute_project_name = max_compute_project_name
        self.object_meta_list = object_meta_list
        self.workspace_id = workspace_id

    def validate(self):
        if self.object_meta_list:
            for k in self.object_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        result['ObjectMetaList'] = []
        if self.object_meta_list is not None:
            for k in self.object_meta_list:
                result['ObjectMetaList'].append(k.to_map() if k else None)
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        self.object_meta_list = []
        if m.get('ObjectMetaList') is not None:
            for k in m.get('ObjectMetaList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList()
                self.object_meta_list.append(temp_model.from_map(k))
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent(TeaModel):
    def __init__(
        self,
        apply_reason: str = None,
        deadline: int = None,
        order_type: int = None,
        project_meta: GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta = None,
    ):
        self.apply_reason = apply_reason
        self.deadline = deadline
        self.order_type = order_type
        self.project_meta = project_meta

    def validate(self):
        if self.project_meta:
            self.project_meta.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.project_meta is not None:
            result['ProjectMeta'] = self.project_meta.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('ProjectMeta') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta()
            self.project_meta = temp_model.from_map(m['ProjectMeta'])
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList(TeaModel):
    def __init__(
        self,
        grantee_id: str = None,
        grantee_name: str = None,
        grantee_type: int = None,
        grantee_type_sub: int = None,
    ):
        self.grantee_id = grantee_id
        self.grantee_name = grantee_name
        self.grantee_type = grantee_type
        self.grantee_type_sub = grantee_type_sub

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grantee_id is not None:
            result['GranteeId'] = self.grantee_id
        if self.grantee_name is not None:
            result['GranteeName'] = self.grantee_name
        if self.grantee_type is not None:
            result['GranteeType'] = self.grantee_type
        if self.grantee_type_sub is not None:
            result['GranteeTypeSub'] = self.grantee_type_sub
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GranteeId') is not None:
            self.grantee_id = m.get('GranteeId')
        if m.get('GranteeName') is not None:
            self.grantee_name = m.get('GranteeName')
        if m.get('GranteeType') is not None:
            self.grantee_type = m.get('GranteeType')
        if m.get('GranteeTypeSub') is not None:
            self.grantee_type_sub = m.get('GranteeTypeSub')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail(TeaModel):
    def __init__(
        self,
        apply_base_id: str = None,
        apply_timestamp: int = None,
        approve_account_list: List[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList] = None,
        approve_content: GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent = None,
        flow_id: str = None,
        flow_status: int = None,
        grantee_object_list: List[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList] = None,
    ):
        self.apply_base_id = apply_base_id
        self.apply_timestamp = apply_timestamp
        self.approve_account_list = approve_account_list
        self.approve_content = approve_content
        self.flow_id = flow_id
        self.flow_status = flow_status
        self.grantee_object_list = grantee_object_list

    def validate(self):
        if self.approve_account_list:
            for k in self.approve_account_list:
                if k:
                    k.validate()
        if self.approve_content:
            self.approve_content.validate()
        if self.grantee_object_list:
            for k in self.grantee_object_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_base_id is not None:
            result['ApplyBaseId'] = self.apply_base_id
        if self.apply_timestamp is not None:
            result['ApplyTimestamp'] = self.apply_timestamp
        result['ApproveAccountList'] = []
        if self.approve_account_list is not None:
            for k in self.approve_account_list:
                result['ApproveAccountList'].append(k.to_map() if k else None)
        if self.approve_content is not None:
            result['ApproveContent'] = self.approve_content.to_map()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_status is not None:
            result['FlowStatus'] = self.flow_status
        result['GranteeObjectList'] = []
        if self.grantee_object_list is not None:
            for k in self.grantee_object_list:
                result['GranteeObjectList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyBaseId') is not None:
            self.apply_base_id = m.get('ApplyBaseId')
        if m.get('ApplyTimestamp') is not None:
            self.apply_timestamp = m.get('ApplyTimestamp')
        self.approve_account_list = []
        if m.get('ApproveAccountList') is not None:
            for k in m.get('ApproveAccountList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList()
                self.approve_account_list.append(temp_model.from_map(k))
        if m.get('ApproveContent') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent()
            self.approve_content = temp_model.from_map(m['ApproveContent'])
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowStatus') is not None:
            self.flow_status = m.get('FlowStatus')
        self.grantee_object_list = []
        if m.get('GranteeObjectList') is not None:
            for k in m.get('GranteeObjectList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList()
                self.grantee_object_list.append(temp_model.from_map(k))
        return self


class GetPermissionApplyOrderDetailResponseBody(TeaModel):
    def __init__(
        self,
        apply_order_detail: GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail = None,
        request_id: str = None,
    ):
        self.apply_order_detail = apply_order_detail
        self.request_id = request_id

    def validate(self):
        if self.apply_order_detail:
            self.apply_order_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_order_detail is not None:
            result['ApplyOrderDetail'] = self.apply_order_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyOrderDetail') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail()
            self.apply_order_detail = temp_model.from_map(m['ApplyOrderDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPermissionApplyOrderDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetPermissionApplyOrderDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProjectRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetProjectResponseBodyData(TeaModel):
    def __init__(
        self,
        appkey: str = None,
        base_project: bool = None,
        default_di_resource_group_identifier: str = None,
        destination: int = None,
        dev_storage_quota: str = None,
        development_type: int = None,
        disable_development: bool = None,
        env_types: List[str] = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        is_allow_download: int = None,
        is_default: int = None,
        max_flow_node: int = None,
        prod_storage_quota: str = None,
        project_description: str = None,
        project_id: int = None,
        project_identifier: str = None,
        project_mode: int = None,
        project_name: str = None,
        project_owner_base_id: str = None,
        protected_mode: int = None,
        resident_area: str = None,
        scheduler_max_retry_times: int = None,
        scheduler_retry_interval: int = None,
        status: int = None,
        table_privacy_mode: int = None,
        tenant_id: int = None,
        use_proxy_odps_account: bool = None,
    ):
        self.appkey = appkey
        self.base_project = base_project
        self.default_di_resource_group_identifier = default_di_resource_group_identifier
        self.destination = destination
        self.dev_storage_quota = dev_storage_quota
        self.development_type = development_type
        self.disable_development = disable_development
        self.env_types = env_types
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.is_allow_download = is_allow_download
        self.is_default = is_default
        self.max_flow_node = max_flow_node
        self.prod_storage_quota = prod_storage_quota
        self.project_description = project_description
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.project_mode = project_mode
        self.project_name = project_name
        self.project_owner_base_id = project_owner_base_id
        self.protected_mode = protected_mode
        self.resident_area = resident_area
        self.scheduler_max_retry_times = scheduler_max_retry_times
        self.scheduler_retry_interval = scheduler_retry_interval
        self.status = status
        self.table_privacy_mode = table_privacy_mode
        self.tenant_id = tenant_id
        self.use_proxy_odps_account = use_proxy_odps_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.appkey is not None:
            result['Appkey'] = self.appkey
        if self.base_project is not None:
            result['BaseProject'] = self.base_project
        if self.default_di_resource_group_identifier is not None:
            result['DefaultDiResourceGroupIdentifier'] = self.default_di_resource_group_identifier
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.dev_storage_quota is not None:
            result['DevStorageQuota'] = self.dev_storage_quota
        if self.development_type is not None:
            result['DevelopmentType'] = self.development_type
        if self.disable_development is not None:
            result['DisableDevelopment'] = self.disable_development
        if self.env_types is not None:
            result['EnvTypes'] = self.env_types
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.is_allow_download is not None:
            result['IsAllowDownload'] = self.is_allow_download
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.max_flow_node is not None:
            result['MaxFlowNode'] = self.max_flow_node
        if self.prod_storage_quota is not None:
            result['ProdStorageQuota'] = self.prod_storage_quota
        if self.project_description is not None:
            result['ProjectDescription'] = self.project_description
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.project_mode is not None:
            result['ProjectMode'] = self.project_mode
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_owner_base_id is not None:
            result['ProjectOwnerBaseId'] = self.project_owner_base_id
        if self.protected_mode is not None:
            result['ProtectedMode'] = self.protected_mode
        if self.resident_area is not None:
            result['ResidentArea'] = self.resident_area
        if self.scheduler_max_retry_times is not None:
            result['SchedulerMaxRetryTimes'] = self.scheduler_max_retry_times
        if self.scheduler_retry_interval is not None:
            result['SchedulerRetryInterval'] = self.scheduler_retry_interval
        if self.status is not None:
            result['Status'] = self.status
        if self.table_privacy_mode is not None:
            result['TablePrivacyMode'] = self.table_privacy_mode
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.use_proxy_odps_account is not None:
            result['UseProxyOdpsAccount'] = self.use_proxy_odps_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Appkey') is not None:
            self.appkey = m.get('Appkey')
        if m.get('BaseProject') is not None:
            self.base_project = m.get('BaseProject')
        if m.get('DefaultDiResourceGroupIdentifier') is not None:
            self.default_di_resource_group_identifier = m.get('DefaultDiResourceGroupIdentifier')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DevStorageQuota') is not None:
            self.dev_storage_quota = m.get('DevStorageQuota')
        if m.get('DevelopmentType') is not None:
            self.development_type = m.get('DevelopmentType')
        if m.get('DisableDevelopment') is not None:
            self.disable_development = m.get('DisableDevelopment')
        if m.get('EnvTypes') is not None:
            self.env_types = m.get('EnvTypes')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('IsAllowDownload') is not None:
            self.is_allow_download = m.get('IsAllowDownload')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('MaxFlowNode') is not None:
            self.max_flow_node = m.get('MaxFlowNode')
        if m.get('ProdStorageQuota') is not None:
            self.prod_storage_quota = m.get('ProdStorageQuota')
        if m.get('ProjectDescription') is not None:
            self.project_description = m.get('ProjectDescription')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ProjectMode') is not None:
            self.project_mode = m.get('ProjectMode')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectOwnerBaseId') is not None:
            self.project_owner_base_id = m.get('ProjectOwnerBaseId')
        if m.get('ProtectedMode') is not None:
            self.protected_mode = m.get('ProtectedMode')
        if m.get('ResidentArea') is not None:
            self.resident_area = m.get('ResidentArea')
        if m.get('SchedulerMaxRetryTimes') is not None:
            self.scheduler_max_retry_times = m.get('SchedulerMaxRetryTimes')
        if m.get('SchedulerRetryInterval') is not None:
            self.scheduler_retry_interval = m.get('SchedulerRetryInterval')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TablePrivacyMode') is not None:
            self.table_privacy_mode = m.get('TablePrivacyMode')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('UseProxyOdpsAccount') is not None:
            self.use_proxy_odps_account = m.get('UseProxyOdpsAccount')
        return self


class GetProjectResponseBody(TeaModel):
    def __init__(
        self,
        data: GetProjectResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetProjectResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProjectDetailRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetProjectDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        default_di_resource_group_identifier: str = None,
        development_type: int = None,
        env_types: List[str] = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        is_allow_download: int = None,
        project_description: str = None,
        project_id: int = None,
        project_identifier: str = None,
        project_mode: int = None,
        project_name: str = None,
        project_owner_base_id: str = None,
        protected_mode: int = None,
        resident_area: str = None,
        scheduler_max_retry_times: int = None,
        scheduler_retry_interval: int = None,
        status: int = None,
        tenant_id: int = None,
    ):
        self.default_di_resource_group_identifier = default_di_resource_group_identifier
        self.development_type = development_type
        self.env_types = env_types
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.is_allow_download = is_allow_download
        self.project_description = project_description
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.project_mode = project_mode
        self.project_name = project_name
        self.project_owner_base_id = project_owner_base_id
        self.protected_mode = protected_mode
        self.resident_area = resident_area
        self.scheduler_max_retry_times = scheduler_max_retry_times
        self.scheduler_retry_interval = scheduler_retry_interval
        self.status = status
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_di_resource_group_identifier is not None:
            result['DefaultDiResourceGroupIdentifier'] = self.default_di_resource_group_identifier
        if self.development_type is not None:
            result['DevelopmentType'] = self.development_type
        if self.env_types is not None:
            result['EnvTypes'] = self.env_types
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.is_allow_download is not None:
            result['IsAllowDownload'] = self.is_allow_download
        if self.project_description is not None:
            result['ProjectDescription'] = self.project_description
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.project_mode is not None:
            result['ProjectMode'] = self.project_mode
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_owner_base_id is not None:
            result['ProjectOwnerBaseId'] = self.project_owner_base_id
        if self.protected_mode is not None:
            result['ProtectedMode'] = self.protected_mode
        if self.resident_area is not None:
            result['ResidentArea'] = self.resident_area
        if self.scheduler_max_retry_times is not None:
            result['SchedulerMaxRetryTimes'] = self.scheduler_max_retry_times
        if self.scheduler_retry_interval is not None:
            result['SchedulerRetryInterval'] = self.scheduler_retry_interval
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultDiResourceGroupIdentifier') is not None:
            self.default_di_resource_group_identifier = m.get('DefaultDiResourceGroupIdentifier')
        if m.get('DevelopmentType') is not None:
            self.development_type = m.get('DevelopmentType')
        if m.get('EnvTypes') is not None:
            self.env_types = m.get('EnvTypes')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('IsAllowDownload') is not None:
            self.is_allow_download = m.get('IsAllowDownload')
        if m.get('ProjectDescription') is not None:
            self.project_description = m.get('ProjectDescription')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ProjectMode') is not None:
            self.project_mode = m.get('ProjectMode')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectOwnerBaseId') is not None:
            self.project_owner_base_id = m.get('ProjectOwnerBaseId')
        if m.get('ProtectedMode') is not None:
            self.protected_mode = m.get('ProtectedMode')
        if m.get('ResidentArea') is not None:
            self.resident_area = m.get('ResidentArea')
        if m.get('SchedulerMaxRetryTimes') is not None:
            self.scheduler_max_retry_times = m.get('SchedulerMaxRetryTimes')
        if m.get('SchedulerRetryInterval') is not None:
            self.scheduler_retry_interval = m.get('SchedulerRetryInterval')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetProjectDetailResponseBody(TeaModel):
    def __init__(
        self,
        data: GetProjectDetailResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetProjectDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetProjectDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetProjectDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetProjectDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityEntityRequest(TeaModel):
    def __init__(
        self,
        env_type: str = None,
        match_expression: str = None,
        project_name: str = None,
        table_name: str = None,
    ):
        self.env_type = env_type
        self.match_expression = match_expression
        self.project_name = project_name
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetQualityEntityResponseBodyData(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        entity_level: int = None,
        env_type: str = None,
        followers: str = None,
        has_relative_node: bool = None,
        id: int = None,
        match_expression: str = None,
        modify_time: int = None,
        modify_user: str = None,
        on_duty: str = None,
        on_duty_account_name: str = None,
        project_name: str = None,
        relative_node: str = None,
        sql: int = None,
        table_name: str = None,
        task: int = None,
    ):
        self.create_time = create_time
        self.entity_level = entity_level
        self.env_type = env_type
        self.followers = followers
        self.has_relative_node = has_relative_node
        self.id = id
        self.match_expression = match_expression
        self.modify_time = modify_time
        self.modify_user = modify_user
        self.on_duty = on_duty
        self.on_duty_account_name = on_duty_account_name
        self.project_name = project_name
        self.relative_node = relative_node
        self.sql = sql
        self.table_name = table_name
        self.task = task

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.entity_level is not None:
            result['EntityLevel'] = self.entity_level
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.followers is not None:
            result['Followers'] = self.followers
        if self.has_relative_node is not None:
            result['HasRelativeNode'] = self.has_relative_node
        if self.id is not None:
            result['Id'] = self.id
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.modify_user is not None:
            result['ModifyUser'] = self.modify_user
        if self.on_duty is not None:
            result['OnDuty'] = self.on_duty
        if self.on_duty_account_name is not None:
            result['OnDutyAccountName'] = self.on_duty_account_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.relative_node is not None:
            result['RelativeNode'] = self.relative_node
        if self.sql is not None:
            result['Sql'] = self.sql
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.task is not None:
            result['Task'] = self.task
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EntityLevel') is not None:
            self.entity_level = m.get('EntityLevel')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Followers') is not None:
            self.followers = m.get('Followers')
        if m.get('HasRelativeNode') is not None:
            self.has_relative_node = m.get('HasRelativeNode')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('ModifyUser') is not None:
            self.modify_user = m.get('ModifyUser')
        if m.get('OnDuty') is not None:
            self.on_duty = m.get('OnDuty')
        if m.get('OnDutyAccountName') is not None:
            self.on_duty_account_name = m.get('OnDutyAccountName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RelativeNode') is not None:
            self.relative_node = m.get('RelativeNode')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Task') is not None:
            self.task = m.get('Task')
        return self


class GetQualityEntityResponseBody(TeaModel):
    def __init__(
        self,
        data: List[GetQualityEntityResponseBodyData] = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityEntityResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQualityEntityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityFollowerRequest(TeaModel):
    def __init__(
        self,
        entity_id: int = None,
        project_name: str = None,
    ):
        self.entity_id = entity_id
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class GetQualityFollowerResponseBodyData(TeaModel):
    def __init__(
        self,
        alarm_mode: int = None,
        entity_id: str = None,
        follower: str = None,
        follower_account_name: str = None,
        id: int = None,
        project_name: str = None,
        table_name: str = None,
    ):
        self.alarm_mode = alarm_mode
        self.entity_id = entity_id
        self.follower = follower
        self.follower_account_name = follower_account_name
        self.id = id
        self.project_name = project_name
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_mode is not None:
            result['AlarmMode'] = self.alarm_mode
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.follower is not None:
            result['Follower'] = self.follower
        if self.follower_account_name is not None:
            result['FollowerAccountName'] = self.follower_account_name
        if self.id is not None:
            result['Id'] = self.id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmMode') is not None:
            self.alarm_mode = m.get('AlarmMode')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Follower') is not None:
            self.follower = m.get('Follower')
        if m.get('FollowerAccountName') is not None:
            self.follower_account_name = m.get('FollowerAccountName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetQualityFollowerResponseBody(TeaModel):
    def __init__(
        self,
        data: List[GetQualityFollowerResponseBodyData] = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityFollowerResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityFollowerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQualityFollowerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityRuleRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        rule_id: int = None,
    ):
        self.project_name = project_name
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetQualityRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        block_type: int = None,
        checker: int = None,
        checker_name: str = None,
        comment: str = None,
        critical_threshold: str = None,
        entity_id: int = None,
        expect_value: str = None,
        fix_check: bool = None,
        id: int = None,
        method_id: int = None,
        method_name: str = None,
        on_duty: str = None,
        on_duty_account_name: str = None,
        operator: str = None,
        predict_type: int = None,
        property: str = None,
        rule_name: str = None,
        rule_type: int = None,
        template_id: int = None,
        template_name: str = None,
        trend: str = None,
        warning_threshold: str = None,
        where_condition: str = None,
    ):
        self.block_type = block_type
        self.checker = checker
        self.checker_name = checker_name
        self.comment = comment
        self.critical_threshold = critical_threshold
        self.entity_id = entity_id
        self.expect_value = expect_value
        self.fix_check = fix_check
        self.id = id
        self.method_id = method_id
        self.method_name = method_name
        self.on_duty = on_duty
        self.on_duty_account_name = on_duty_account_name
        self.operator = operator
        self.predict_type = predict_type
        self.property = property
        self.rule_name = rule_name
        self.rule_type = rule_type
        self.template_id = template_id
        self.template_name = template_name
        self.trend = trend
        self.warning_threshold = warning_threshold
        self.where_condition = where_condition

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_type is not None:
            result['BlockType'] = self.block_type
        if self.checker is not None:
            result['Checker'] = self.checker
        if self.checker_name is not None:
            result['CheckerName'] = self.checker_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.critical_threshold is not None:
            result['CriticalThreshold'] = self.critical_threshold
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.expect_value is not None:
            result['ExpectValue'] = self.expect_value
        if self.fix_check is not None:
            result['FixCheck'] = self.fix_check
        if self.id is not None:
            result['Id'] = self.id
        if self.method_id is not None:
            result['MethodId'] = self.method_id
        if self.method_name is not None:
            result['MethodName'] = self.method_name
        if self.on_duty is not None:
            result['OnDuty'] = self.on_duty
        if self.on_duty_account_name is not None:
            result['OnDutyAccountName'] = self.on_duty_account_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.predict_type is not None:
            result['PredictType'] = self.predict_type
        if self.property is not None:
            result['Property'] = self.property
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.trend is not None:
            result['Trend'] = self.trend
        if self.warning_threshold is not None:
            result['WarningThreshold'] = self.warning_threshold
        if self.where_condition is not None:
            result['WhereCondition'] = self.where_condition
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockType') is not None:
            self.block_type = m.get('BlockType')
        if m.get('Checker') is not None:
            self.checker = m.get('Checker')
        if m.get('CheckerName') is not None:
            self.checker_name = m.get('CheckerName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CriticalThreshold') is not None:
            self.critical_threshold = m.get('CriticalThreshold')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('ExpectValue') is not None:
            self.expect_value = m.get('ExpectValue')
        if m.get('FixCheck') is not None:
            self.fix_check = m.get('FixCheck')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MethodId') is not None:
            self.method_id = m.get('MethodId')
        if m.get('MethodName') is not None:
            self.method_name = m.get('MethodName')
        if m.get('OnDuty') is not None:
            self.on_duty = m.get('OnDuty')
        if m.get('OnDutyAccountName') is not None:
            self.on_duty_account_name = m.get('OnDutyAccountName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('PredictType') is not None:
            self.predict_type = m.get('PredictType')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Trend') is not None:
            self.trend = m.get('Trend')
        if m.get('WarningThreshold') is not None:
            self.warning_threshold = m.get('WarningThreshold')
        if m.get('WhereCondition') is not None:
            self.where_condition = m.get('WhereCondition')
        return self


class GetQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        data: GetQualityRuleResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetQualityRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRemindRequest(TeaModel):
    def __init__(
        self,
        remind_id: int = None,
    ):
        self.remind_id = remind_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        return self


class GetRemindResponseBodyDataBaselines(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
    ):
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        return self


class GetRemindResponseBodyDataBizProcesses(TeaModel):
    def __init__(
        self,
        biz_id: int = None,
        biz_process_name: str = None,
    ):
        self.biz_id = biz_id
        self.biz_process_name = biz_process_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.biz_process_name is not None:
            result['BizProcessName'] = self.biz_process_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('BizProcessName') is not None:
            self.biz_process_name = m.get('BizProcessName')
        return self


class GetRemindResponseBodyDataNodes(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetRemindResponseBodyDataProjects(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetRemindResponseBodyDataRobots(TeaModel):
    def __init__(
        self,
        at_all: bool = None,
        web_url: str = None,
    ):
        self.at_all = at_all
        self.web_url = web_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.at_all is not None:
            result['AtAll'] = self.at_all
        if self.web_url is not None:
            result['WebUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AtAll') is not None:
            self.at_all = m.get('AtAll')
        if m.get('WebUrl') is not None:
            self.web_url = m.get('WebUrl')
        return self


class GetRemindResponseBodyData(TeaModel):
    def __init__(
        self,
        alert_interval: int = None,
        alert_methods: List[str] = None,
        alert_targets: List[str] = None,
        alert_unit: str = None,
        baselines: List[GetRemindResponseBodyDataBaselines] = None,
        biz_processes: List[GetRemindResponseBodyDataBizProcesses] = None,
        detail: str = None,
        dnd_end: str = None,
        dnd_start: str = None,
        founder: str = None,
        max_alert_times: int = None,
        nodes: List[GetRemindResponseBodyDataNodes] = None,
        projects: List[GetRemindResponseBodyDataProjects] = None,
        remind_id: int = None,
        remind_name: str = None,
        remind_type: str = None,
        remind_unit: str = None,
        robots: List[GetRemindResponseBodyDataRobots] = None,
        useflag: bool = None,
    ):
        self.alert_interval = alert_interval
        self.alert_methods = alert_methods
        self.alert_targets = alert_targets
        self.alert_unit = alert_unit
        self.baselines = baselines
        self.biz_processes = biz_processes
        self.detail = detail
        self.dnd_end = dnd_end
        self.dnd_start = dnd_start
        self.founder = founder
        self.max_alert_times = max_alert_times
        self.nodes = nodes
        self.projects = projects
        self.remind_id = remind_id
        self.remind_name = remind_name
        self.remind_type = remind_type
        self.remind_unit = remind_unit
        self.robots = robots
        self.useflag = useflag

    def validate(self):
        if self.baselines:
            for k in self.baselines:
                if k:
                    k.validate()
        if self.biz_processes:
            for k in self.biz_processes:
                if k:
                    k.validate()
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()
        if self.projects:
            for k in self.projects:
                if k:
                    k.validate()
        if self.robots:
            for k in self.robots:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_interval is not None:
            result['AlertInterval'] = self.alert_interval
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_targets is not None:
            result['AlertTargets'] = self.alert_targets
        if self.alert_unit is not None:
            result['AlertUnit'] = self.alert_unit
        result['Baselines'] = []
        if self.baselines is not None:
            for k in self.baselines:
                result['Baselines'].append(k.to_map() if k else None)
        result['BizProcesses'] = []
        if self.biz_processes is not None:
            for k in self.biz_processes:
                result['BizProcesses'].append(k.to_map() if k else None)
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.dnd_end is not None:
            result['DndEnd'] = self.dnd_end
        if self.dnd_start is not None:
            result['DndStart'] = self.dnd_start
        if self.founder is not None:
            result['Founder'] = self.founder
        if self.max_alert_times is not None:
            result['MaxAlertTimes'] = self.max_alert_times
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        result['Projects'] = []
        if self.projects is not None:
            for k in self.projects:
                result['Projects'].append(k.to_map() if k else None)
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.remind_type is not None:
            result['RemindType'] = self.remind_type
        if self.remind_unit is not None:
            result['RemindUnit'] = self.remind_unit
        result['Robots'] = []
        if self.robots is not None:
            for k in self.robots:
                result['Robots'].append(k.to_map() if k else None)
        if self.useflag is not None:
            result['Useflag'] = self.useflag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertInterval') is not None:
            self.alert_interval = m.get('AlertInterval')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertTargets') is not None:
            self.alert_targets = m.get('AlertTargets')
        if m.get('AlertUnit') is not None:
            self.alert_unit = m.get('AlertUnit')
        self.baselines = []
        if m.get('Baselines') is not None:
            for k in m.get('Baselines'):
                temp_model = GetRemindResponseBodyDataBaselines()
                self.baselines.append(temp_model.from_map(k))
        self.biz_processes = []
        if m.get('BizProcesses') is not None:
            for k in m.get('BizProcesses'):
                temp_model = GetRemindResponseBodyDataBizProcesses()
                self.biz_processes.append(temp_model.from_map(k))
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('DndEnd') is not None:
            self.dnd_end = m.get('DndEnd')
        if m.get('DndStart') is not None:
            self.dnd_start = m.get('DndStart')
        if m.get('Founder') is not None:
            self.founder = m.get('Founder')
        if m.get('MaxAlertTimes') is not None:
            self.max_alert_times = m.get('MaxAlertTimes')
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetRemindResponseBodyDataNodes()
                self.nodes.append(temp_model.from_map(k))
        self.projects = []
        if m.get('Projects') is not None:
            for k in m.get('Projects'):
                temp_model = GetRemindResponseBodyDataProjects()
                self.projects.append(temp_model.from_map(k))
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('RemindType') is not None:
            self.remind_type = m.get('RemindType')
        if m.get('RemindUnit') is not None:
            self.remind_unit = m.get('RemindUnit')
        self.robots = []
        if m.get('Robots') is not None:
            for k in m.get('Robots'):
                temp_model = GetRemindResponseBodyDataRobots()
                self.robots.append(temp_model.from_map(k))
        if m.get('Useflag') is not None:
            self.useflag = m.get('Useflag')
        return self


class GetRemindResponseBody(TeaModel):
    def __init__(
        self,
        data: GetRemindResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetRemindResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRemindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetRemindResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSensitiveDataRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        page_no: int = None,
        page_size: int = None,
    ):
        self.name = name
        self.page_no = page_no
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetSensitiveDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sensitive_data: Dict[str, Any] = None,
    ):
        self.request_id = request_id
        self.sensitive_data = sensitive_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sensitive_data is not None:
            result['SensitiveData'] = self.sensitive_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SensitiveData') is not None:
            self.sensitive_data = m.get('SensitiveData')
        return self


class GetSensitiveDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSensitiveDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSensitiveDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSuccessInstanceTrendRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: str = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: str = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: str = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrend(TeaModel):
    def __init__(
        self,
        avg_trend: List[GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend] = None,
        today_trend: List[GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend] = None,
        yesterday_trend: List[GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend] = None,
    ):
        self.avg_trend = avg_trend
        self.today_trend = today_trend
        self.yesterday_trend = yesterday_trend

    def validate(self):
        if self.avg_trend:
            for k in self.avg_trend:
                if k:
                    k.validate()
        if self.today_trend:
            for k in self.today_trend:
                if k:
                    k.validate()
        if self.yesterday_trend:
            for k in self.yesterday_trend:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvgTrend'] = []
        if self.avg_trend is not None:
            for k in self.avg_trend:
                result['AvgTrend'].append(k.to_map() if k else None)
        result['TodayTrend'] = []
        if self.today_trend is not None:
            for k in self.today_trend:
                result['TodayTrend'].append(k.to_map() if k else None)
        result['YesterdayTrend'] = []
        if self.yesterday_trend is not None:
            for k in self.yesterday_trend:
                result['YesterdayTrend'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.avg_trend = []
        if m.get('AvgTrend') is not None:
            for k in m.get('AvgTrend'):
                temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend()
                self.avg_trend.append(temp_model.from_map(k))
        self.today_trend = []
        if m.get('TodayTrend') is not None:
            for k in m.get('TodayTrend'):
                temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend()
                self.today_trend.append(temp_model.from_map(k))
        self.yesterday_trend = []
        if m.get('YesterdayTrend') is not None:
            for k in m.get('YesterdayTrend'):
                temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend()
                self.yesterday_trend.append(temp_model.from_map(k))
        return self


class GetSuccessInstanceTrendResponseBody(TeaModel):
    def __init__(
        self,
        instance_status_trend: GetSuccessInstanceTrendResponseBodyInstanceStatusTrend = None,
        request_id: str = None,
    ):
        self.instance_status_trend = instance_status_trend
        self.request_id = request_id

    def validate(self):
        if self.instance_status_trend:
            self.instance_status_trend.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_status_trend is not None:
            result['InstanceStatusTrend'] = self.instance_status_trend.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceStatusTrend') is not None:
            temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrend()
            self.instance_status_trend = temp_model.from_map(m['InstanceStatusTrend'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetSuccessInstanceTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSuccessInstanceTrendResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSuccessInstanceTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTopicRequest(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
    ):
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class GetTopicResponseBodyData(TeaModel):
    def __init__(
        self,
        add_time: int = None,
        alert_time: int = None,
        assigner: str = None,
        baseline_buffer: int = None,
        baseline_id: int = None,
        baseline_in_group_id: int = None,
        baseline_name: str = None,
        baseline_status: str = None,
        buffer: int = None,
        deal_time: int = None,
        deal_user: str = None,
        fix_time: int = None,
        happen_time: int = None,
        instance_id: int = None,
        next_alert_time: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
        topic_id: int = None,
        topic_name: str = None,
        topic_status: str = None,
        topic_type: str = None,
    ):
        self.add_time = add_time
        self.alert_time = alert_time
        self.assigner = assigner
        self.baseline_buffer = baseline_buffer
        self.baseline_id = baseline_id
        self.baseline_in_group_id = baseline_in_group_id
        self.baseline_name = baseline_name
        self.baseline_status = baseline_status
        self.buffer = buffer
        self.deal_time = deal_time
        self.deal_user = deal_user
        self.fix_time = fix_time
        self.happen_time = happen_time
        self.instance_id = instance_id
        self.next_alert_time = next_alert_time
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id
        self.topic_id = topic_id
        self.topic_name = topic_name
        self.topic_status = topic_status
        self.topic_type = topic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_time is not None:
            result['AddTime'] = self.add_time
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.assigner is not None:
            result['Assigner'] = self.assigner
        if self.baseline_buffer is not None:
            result['BaselineBuffer'] = self.baseline_buffer
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_in_group_id is not None:
            result['BaselineInGroupId'] = self.baseline_in_group_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_status is not None:
            result['BaselineStatus'] = self.baseline_status
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_user is not None:
            result['DealUser'] = self.deal_user
        if self.fix_time is not None:
            result['FixTime'] = self.fix_time
        if self.happen_time is not None:
            result['HappenTime'] = self.happen_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.next_alert_time is not None:
            result['NextAlertTime'] = self.next_alert_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.topic_status is not None:
            result['TopicStatus'] = self.topic_status
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddTime') is not None:
            self.add_time = m.get('AddTime')
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('Assigner') is not None:
            self.assigner = m.get('Assigner')
        if m.get('BaselineBuffer') is not None:
            self.baseline_buffer = m.get('BaselineBuffer')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineInGroupId') is not None:
            self.baseline_in_group_id = m.get('BaselineInGroupId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineStatus') is not None:
            self.baseline_status = m.get('BaselineStatus')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealUser') is not None:
            self.deal_user = m.get('DealUser')
        if m.get('FixTime') is not None:
            self.fix_time = m.get('FixTime')
        if m.get('HappenTime') is not None:
            self.happen_time = m.get('HappenTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NextAlertTime') is not None:
            self.next_alert_time = m.get('NextAlertTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('TopicStatus') is not None:
            self.topic_status = m.get('TopicStatus')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        return self


class GetTopicResponseBody(TeaModel):
    def __init__(
        self,
        data: GetTopicResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetTopicResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetTopicResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetTopicResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTopicInfluenceRequest(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
    ):
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class GetTopicInfluenceResponseBodyDataInfluences(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
        bizdate: int = None,
        buffer: int = None,
        in_group_id: int = None,
        owner: str = None,
        priority: int = None,
        project_id: int = None,
        status: str = None,
    ):
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.bizdate = bizdate
        self.buffer = buffer
        self.in_group_id = in_group_id
        self.owner = owner
        self.priority = priority
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetTopicInfluenceResponseBodyData(TeaModel):
    def __init__(
        self,
        influences: List[GetTopicInfluenceResponseBodyDataInfluences] = None,
        topic_id: int = None,
    ):
        self.influences = influences
        self.topic_id = topic_id

    def validate(self):
        if self.influences:
            for k in self.influences:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Influences'] = []
        if self.influences is not None:
            for k in self.influences:
                result['Influences'].append(k.to_map() if k else None)
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.influences = []
        if m.get('Influences') is not None:
            for k in m.get('Influences'):
                temp_model = GetTopicInfluenceResponseBodyDataInfluences()
                self.influences.append(temp_model.from_map(k))
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class GetTopicInfluenceResponseBody(TeaModel):
    def __init__(
        self,
        data: GetTopicInfluenceResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetTopicInfluenceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetTopicInfluenceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetTopicInfluenceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTopicInfluenceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportDataSourcesRequest(TeaModel):
    def __init__(
        self,
        data_sources: str = None,
        project_id: int = None,
    ):
        self.data_sources = data_sources
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_sources is not None:
            result['DataSources'] = self.data_sources
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSources') is not None:
            self.data_sources = m.get('DataSources')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ImportDataSourcesResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        status: bool = None,
    ):
        self.message = message
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ImportDataSourcesResponseBody(TeaModel):
    def __init__(
        self,
        data: ImportDataSourcesResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ImportDataSourcesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ImportDataSourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ImportDataSourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportDataSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlertMessagesRequest(TeaModel):
    def __init__(
        self,
        alert_methods: str = None,
        alert_rule_types: str = None,
        alert_user: str = None,
        begin_time: str = None,
        end_time: str = None,
        page_number: int = None,
        page_size: int = None,
        remind_id: int = None,
    ):
        self.alert_methods = alert_methods
        self.alert_rule_types = alert_rule_types
        self.alert_user = alert_user
        self.begin_time = begin_time
        self.end_time = end_time
        self.page_number = page_number
        self.page_size = page_size
        self.remind_id = remind_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_rule_types is not None:
            result['AlertRuleTypes'] = self.alert_rule_types
        if self.alert_user is not None:
            result['AlertUser'] = self.alert_user
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertRuleTypes') is not None:
            self.alert_rule_types = m.get('AlertRuleTypes')
        if m.get('AlertUser') is not None:
            self.alert_user = m.get('AlertUser')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesInstances(TeaModel):
    def __init__(
        self,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        project_id: int = None,
        status: str = None,
    ):
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesNodes(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
        baseline_owner: str = None,
        bizdate: int = None,
        in_group_id: int = None,
        project_id: int = None,
        status: str = None,
    ):
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.baseline_owner = baseline_owner
        self.bizdate = bizdate
        self.in_group_id = in_group_id
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_owner is not None:
            result['BaselineOwner'] = self.baseline_owner
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineOwner') is not None:
            self.baseline_owner = m.get('BaselineOwner')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesTopics(TeaModel):
    def __init__(
        self,
        instance_id: int = None,
        node_id: int = None,
        topic_id: int = None,
        topic_name: str = None,
        topic_owner: str = None,
        topic_status: str = None,
    ):
        self.instance_id = instance_id
        self.node_id = node_id
        self.topic_id = topic_id
        self.topic_name = topic_name
        self.topic_owner = topic_owner
        self.topic_status = topic_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.topic_owner is not None:
            result['TopicOwner'] = self.topic_owner
        if self.topic_status is not None:
            result['TopicStatus'] = self.topic_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('TopicOwner') is not None:
            self.topic_owner = m.get('TopicOwner')
        if m.get('TopicStatus') is not None:
            self.topic_status = m.get('TopicStatus')
        return self


class ListAlertMessagesResponseBodyDataAlertMessages(TeaModel):
    def __init__(
        self,
        alert_id: int = None,
        alert_message_status: str = None,
        alert_method: str = None,
        alert_time: int = None,
        alert_user: str = None,
        content: str = None,
        instances: List[ListAlertMessagesResponseBodyDataAlertMessagesInstances] = None,
        nodes: List[ListAlertMessagesResponseBodyDataAlertMessagesNodes] = None,
        remind_id: int = None,
        remind_name: str = None,
        sla_alert: ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert = None,
        source: str = None,
        topics: List[ListAlertMessagesResponseBodyDataAlertMessagesTopics] = None,
    ):
        self.alert_id = alert_id
        self.alert_message_status = alert_message_status
        self.alert_method = alert_method
        self.alert_time = alert_time
        self.alert_user = alert_user
        self.content = content
        self.instances = instances
        self.nodes = nodes
        self.remind_id = remind_id
        self.remind_name = remind_name
        self.sla_alert = sla_alert
        self.source = source
        self.topics = topics

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()
        if self.sla_alert:
            self.sla_alert.validate()
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_message_status is not None:
            result['AlertMessageStatus'] = self.alert_message_status
        if self.alert_method is not None:
            result['AlertMethod'] = self.alert_method
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.alert_user is not None:
            result['AlertUser'] = self.alert_user
        if self.content is not None:
            result['Content'] = self.content
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.sla_alert is not None:
            result['SlaAlert'] = self.sla_alert.to_map()
        if self.source is not None:
            result['Source'] = self.source
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertMessageStatus') is not None:
            self.alert_message_status = m.get('AlertMessageStatus')
        if m.get('AlertMethod') is not None:
            self.alert_method = m.get('AlertMethod')
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('AlertUser') is not None:
            self.alert_user = m.get('AlertUser')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessagesInstances()
                self.instances.append(temp_model.from_map(k))
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessagesNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('SlaAlert') is not None:
            temp_model = ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert()
            self.sla_alert = temp_model.from_map(m['SlaAlert'])
        if m.get('Source') is not None:
            self.source = m.get('Source')
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessagesTopics()
                self.topics.append(temp_model.from_map(k))
        return self


class ListAlertMessagesResponseBodyData(TeaModel):
    def __init__(
        self,
        alert_messages: List[ListAlertMessagesResponseBodyDataAlertMessages] = None,
        page_number: str = None,
        page_size: str = None,
        total_count: str = None,
    ):
        self.alert_messages = alert_messages
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.alert_messages:
            for k in self.alert_messages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertMessages'] = []
        if self.alert_messages is not None:
            for k in self.alert_messages:
                result['AlertMessages'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_messages = []
        if m.get('AlertMessages') is not None:
            for k in m.get('AlertMessages'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessages()
                self.alert_messages.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAlertMessagesResponseBody(TeaModel):
    def __init__(
        self,
        data: ListAlertMessagesResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListAlertMessagesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAlertMessagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAlertMessagesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAlertMessagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBaselineConfigsRequest(TeaModel):
    def __init__(
        self,
        baseline_types: str = None,
        owner: str = None,
        page_number: int = None,
        page_size: int = None,
        priority: str = None,
        project_id: int = None,
        search_text: str = None,
        useflag: bool = None,
    ):
        self.baseline_types = baseline_types
        self.owner = owner
        self.page_number = page_number
        self.page_size = page_size
        self.priority = priority
        self.project_id = project_id
        self.search_text = search_text
        self.useflag = useflag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_types is not None:
            result['BaselineTypes'] = self.baseline_types
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.search_text is not None:
            result['SearchText'] = self.search_text
        if self.useflag is not None:
            result['Useflag'] = self.useflag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineTypes') is not None:
            self.baseline_types = m.get('BaselineTypes')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SearchText') is not None:
            self.search_text = m.get('SearchText')
        if m.get('Useflag') is not None:
            self.useflag = m.get('Useflag')
        return self


class ListBaselineConfigsResponseBodyDataBaselines(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
        baseline_type: str = None,
        exp_hour: int = None,
        exp_minu: int = None,
        hour_exp_detail: str = None,
        hour_sla_detail: str = None,
        is_default: bool = None,
        owner: str = None,
        priority: int = None,
        project_id: int = None,
        sla_hour: int = None,
        sla_minu: int = None,
        use_flag: bool = None,
    ):
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.baseline_type = baseline_type
        self.exp_hour = exp_hour
        self.exp_minu = exp_minu
        self.hour_exp_detail = hour_exp_detail
        self.hour_sla_detail = hour_sla_detail
        self.is_default = is_default
        self.owner = owner
        self.priority = priority
        self.project_id = project_id
        self.sla_hour = sla_hour
        self.sla_minu = sla_minu
        self.use_flag = use_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.exp_hour is not None:
            result['ExpHour'] = self.exp_hour
        if self.exp_minu is not None:
            result['ExpMinu'] = self.exp_minu
        if self.hour_exp_detail is not None:
            result['HourExpDetail'] = self.hour_exp_detail
        if self.hour_sla_detail is not None:
            result['HourSlaDetail'] = self.hour_sla_detail
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sla_hour is not None:
            result['SlaHour'] = self.sla_hour
        if self.sla_minu is not None:
            result['SlaMinu'] = self.sla_minu
        if self.use_flag is not None:
            result['UseFlag'] = self.use_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('ExpHour') is not None:
            self.exp_hour = m.get('ExpHour')
        if m.get('ExpMinu') is not None:
            self.exp_minu = m.get('ExpMinu')
        if m.get('HourExpDetail') is not None:
            self.hour_exp_detail = m.get('HourExpDetail')
        if m.get('HourSlaDetail') is not None:
            self.hour_sla_detail = m.get('HourSlaDetail')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SlaHour') is not None:
            self.sla_hour = m.get('SlaHour')
        if m.get('SlaMinu') is not None:
            self.sla_minu = m.get('SlaMinu')
        if m.get('UseFlag') is not None:
            self.use_flag = m.get('UseFlag')
        return self


class ListBaselineConfigsResponseBodyData(TeaModel):
    def __init__(
        self,
        baselines: List[ListBaselineConfigsResponseBodyDataBaselines] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.baselines = baselines
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.baselines:
            for k in self.baselines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Baselines'] = []
        if self.baselines is not None:
            for k in self.baselines:
                result['Baselines'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baselines = []
        if m.get('Baselines') is not None:
            for k in m.get('Baselines'):
                temp_model = ListBaselineConfigsResponseBodyDataBaselines()
                self.baselines.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListBaselineConfigsResponseBody(TeaModel):
    def __init__(
        self,
        data: ListBaselineConfigsResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListBaselineConfigsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListBaselineConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListBaselineConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBaselineConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBaselineStatusesRequest(TeaModel):
    def __init__(
        self,
        baseline_types: str = None,
        bizdate: str = None,
        finish_status: str = None,
        owner: str = None,
        page_number: int = None,
        page_size: int = None,
        priority: str = None,
        search_text: str = None,
        status: str = None,
        topic_id: int = None,
    ):
        self.baseline_types = baseline_types
        self.bizdate = bizdate
        self.finish_status = finish_status
        self.owner = owner
        self.page_number = page_number
        self.page_size = page_size
        self.priority = priority
        self.search_text = search_text
        self.status = status
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_types is not None:
            result['BaselineTypes'] = self.baseline_types
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.search_text is not None:
            result['SearchText'] = self.search_text
        if self.status is not None:
            result['Status'] = self.status
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineTypes') is not None:
            self.baseline_types = m.get('BaselineTypes')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SearchText') is not None:
            self.search_text = m.get('SearchText')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class ListBaselineStatusesResponseBodyDataBaselineStatuses(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
        bizdate: int = None,
        buffer: int = None,
        end_cast: int = None,
        exp_time: int = None,
        finish_status: str = None,
        finish_time: int = None,
        in_group_id: int = None,
        owner: str = None,
        priority: int = None,
        project_id: int = None,
        sla_time: int = None,
        status: str = None,
    ):
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.bizdate = bizdate
        self.buffer = buffer
        self.end_cast = end_cast
        self.exp_time = exp_time
        self.finish_status = finish_status
        self.finish_time = finish_time
        self.in_group_id = in_group_id
        self.owner = owner
        self.priority = priority
        self.project_id = project_id
        self.sla_time = sla_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.exp_time is not None:
            result['ExpTime'] = self.exp_time
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sla_time is not None:
            result['SlaTime'] = self.sla_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('ExpTime') is not None:
            self.exp_time = m.get('ExpTime')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SlaTime') is not None:
            self.sla_time = m.get('SlaTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListBaselineStatusesResponseBodyData(TeaModel):
    def __init__(
        self,
        baseline_statuses: List[ListBaselineStatusesResponseBodyDataBaselineStatuses] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.baseline_statuses = baseline_statuses
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.baseline_statuses:
            for k in self.baseline_statuses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineStatuses'] = []
        if self.baseline_statuses is not None:
            for k in self.baseline_statuses:
                result['BaselineStatuses'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baseline_statuses = []
        if m.get('BaselineStatuses') is not None:
            for k in m.get('BaselineStatuses'):
                temp_model = ListBaselineStatusesResponseBodyDataBaselineStatuses()
                self.baseline_statuses.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListBaselineStatusesResponseBody(TeaModel):
    def __init__(
        self,
        data: ListBaselineStatusesResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListBaselineStatusesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListBaselineStatusesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListBaselineStatusesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBaselineStatusesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBusinessRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        self.keyword = keyword
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class ListBusinessResponseBodyDataBusiness(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        business_name: str = None,
        description: str = None,
        owner: str = None,
        project_id: int = None,
        use_type: str = None,
    ):
        self.business_id = business_id
        self.business_name = business_name
        self.description = description
        self.owner = owner
        self.project_id = project_id
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class ListBusinessResponseBodyData(TeaModel):
    def __init__(
        self,
        business: List[ListBusinessResponseBodyDataBusiness] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.business = business
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.business:
            for k in self.business:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Business'] = []
        if self.business is not None:
            for k in self.business:
                result['Business'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.business = []
        if m.get('Business') is not None:
            for k in m.get('Business'):
                temp_model = ListBusinessResponseBodyDataBusiness()
                self.business.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListBusinessResponseBody(TeaModel):
    def __init__(
        self,
        data: ListBusinessResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListBusinessResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCalcEnginesRequest(TeaModel):
    def __init__(
        self,
        calc_engine_type: str = None,
        env_type: str = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
    ):
        self.calc_engine_type = calc_engine_type
        self.env_type = env_type
        self.name = name
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calc_engine_type is not None:
            result['CalcEngineType'] = self.calc_engine_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalcEngineType') is not None:
            self.calc_engine_type = m.get('CalcEngineType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListCalcEnginesResponseBodyDataCalcEngines(TeaModel):
    def __init__(
        self,
        binding_project_id: int = None,
        binding_project_name: str = None,
        calc_engine_type: str = None,
        dw_region: str = None,
        engine_id: int = None,
        engine_info: Dict[str, Any] = None,
        env_type: str = None,
        gmt_create: str = None,
        is_default: bool = None,
        name: str = None,
        region: str = None,
        task_auth_type: str = None,
        tenant_id: int = None,
    ):
        self.binding_project_id = binding_project_id
        self.binding_project_name = binding_project_name
        self.calc_engine_type = calc_engine_type
        self.dw_region = dw_region
        self.engine_id = engine_id
        self.engine_info = engine_info
        self.env_type = env_type
        self.gmt_create = gmt_create
        self.is_default = is_default
        self.name = name
        self.region = region
        self.task_auth_type = task_auth_type
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binding_project_id is not None:
            result['BindingProjectId'] = self.binding_project_id
        if self.binding_project_name is not None:
            result['BindingProjectName'] = self.binding_project_name
        if self.calc_engine_type is not None:
            result['CalcEngineType'] = self.calc_engine_type
        if self.dw_region is not None:
            result['DwRegion'] = self.dw_region
        if self.engine_id is not None:
            result['EngineId'] = self.engine_id
        if self.engine_info is not None:
            result['EngineInfo'] = self.engine_info
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.name is not None:
            result['Name'] = self.name
        if self.region is not None:
            result['Region'] = self.region
        if self.task_auth_type is not None:
            result['TaskAuthType'] = self.task_auth_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindingProjectId') is not None:
            self.binding_project_id = m.get('BindingProjectId')
        if m.get('BindingProjectName') is not None:
            self.binding_project_name = m.get('BindingProjectName')
        if m.get('CalcEngineType') is not None:
            self.calc_engine_type = m.get('CalcEngineType')
        if m.get('DwRegion') is not None:
            self.dw_region = m.get('DwRegion')
        if m.get('EngineId') is not None:
            self.engine_id = m.get('EngineId')
        if m.get('EngineInfo') is not None:
            self.engine_info = m.get('EngineInfo')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('TaskAuthType') is not None:
            self.task_auth_type = m.get('TaskAuthType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListCalcEnginesResponseBodyData(TeaModel):
    def __init__(
        self,
        calc_engines: List[ListCalcEnginesResponseBodyDataCalcEngines] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.calc_engines = calc_engines
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.calc_engines:
            for k in self.calc_engines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CalcEngines'] = []
        if self.calc_engines is not None:
            for k in self.calc_engines:
                result['CalcEngines'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.calc_engines = []
        if m.get('CalcEngines') is not None:
            for k in m.get('CalcEngines'):
                temp_model = ListCalcEnginesResponseBodyDataCalcEngines()
                self.calc_engines.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCalcEnginesResponseBody(TeaModel):
    def __init__(
        self,
        data: ListCalcEnginesResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListCalcEnginesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListCalcEnginesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListCalcEnginesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCalcEnginesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConnectionsRequest(TeaModel):
    def __init__(
        self,
        connection_type: str = None,
        env_type: int = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        status: str = None,
        sub_type: str = None,
    ):
        self.connection_type = connection_type
        self.env_type = env_type
        self.name = name
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.status = status
        self.sub_type = sub_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        return self


class ListConnectionsResponseBodyDataConnections(TeaModel):
    def __init__(
        self,
        binding_calc_engine_id: int = None,
        connect_status: int = None,
        connection_type: str = None,
        content: str = None,
        default_engine: bool = None,
        description: str = None,
        env_type: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        name: str = None,
        operator: str = None,
        project_id: int = None,
        sequence: int = None,
        shared: bool = None,
        status: int = None,
        sub_type: str = None,
        tenant_id: int = None,
    ):
        self.binding_calc_engine_id = binding_calc_engine_id
        self.connect_status = connect_status
        self.connection_type = connection_type
        self.content = content
        self.default_engine = default_engine
        self.description = description
        self.env_type = env_type
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.name = name
        self.operator = operator
        self.project_id = project_id
        self.sequence = sequence
        self.shared = shared
        self.status = status
        self.sub_type = sub_type
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.content is not None:
            result['Content'] = self.content
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.description is not None:
            result['Description'] = self.description
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListConnectionsResponseBodyData(TeaModel):
    def __init__(
        self,
        connections: List[ListConnectionsResponseBodyDataConnections] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.connections = connections
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.connections:
            for k in self.connections:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Connections'] = []
        if self.connections is not None:
            for k in self.connections:
                result['Connections'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.connections = []
        if m.get('Connections') is not None:
            for k in m.get('Connections'):
                temp_model = ListConnectionsResponseBodyDataConnections()
                self.connections.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListConnectionsResponseBody(TeaModel):
    def __init__(
        self,
        data: ListConnectionsResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListConnectionsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListConnectionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConnectionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConnectionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDIProjectConfigRequest(TeaModel):
    def __init__(
        self,
        destination_type: str = None,
        project_id: int = None,
        source_type: str = None,
    ):
        self.destination_type = destination_type
        self.project_id = project_id
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class ListDIProjectConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        config: str = None,
    ):
        self.config = config

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        return self


class ListDIProjectConfigResponseBody(TeaModel):
    def __init__(
        self,
        data: ListDIProjectConfigResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListDIProjectConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListDIProjectConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDIProjectConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDIProjectConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDagsRequest(TeaModel):
    def __init__(
        self,
        op_seq: int = None,
        project_env: str = None,
    ):
        self.op_seq = op_seq
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.op_seq is not None:
            result['OpSeq'] = self.op_seq
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpSeq') is not None:
            self.op_seq = m.get('OpSeq')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class ListDagsResponseBodyDataDags(TeaModel):
    def __init__(
        self,
        bizdate: int = None,
        create_time: int = None,
        create_user: str = None,
        dag_id: int = None,
        finish_time: int = None,
        gmtdate: int = None,
        modify_time: int = None,
        name: str = None,
        op_seq: int = None,
        project_id: int = None,
        start_time: int = None,
        status: str = None,
        type: str = None,
    ):
        self.bizdate = bizdate
        self.create_time = create_time
        self.create_user = create_user
        self.dag_id = dag_id
        self.finish_time = finish_time
        self.gmtdate = gmtdate
        self.modify_time = modify_time
        self.name = name
        self.op_seq = op_seq
        self.project_id = project_id
        self.start_time = start_time
        self.status = status
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.gmtdate is not None:
            result['Gmtdate'] = self.gmtdate
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.op_seq is not None:
            result['OpSeq'] = self.op_seq
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Gmtdate') is not None:
            self.gmtdate = m.get('Gmtdate')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpSeq') is not None:
            self.op_seq = m.get('OpSeq')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListDagsResponseBodyData(TeaModel):
    def __init__(
        self,
        dags: List[ListDagsResponseBodyDataDags] = None,
    ):
        self.dags = dags

    def validate(self):
        if self.dags:
            for k in self.dags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Dags'] = []
        if self.dags is not None:
            for k in self.dags:
                result['Dags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dags = []
        if m.get('Dags') is not None:
            for k in m.get('Dags'):
                temp_model = ListDagsResponseBodyDataDags()
                self.dags.append(temp_model.from_map(k))
        return self


class ListDagsResponseBody(TeaModel):
    def __init__(
        self,
        data: ListDagsResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListDagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListDagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDataServiceApiAuthoritiesRequest(TeaModel):
    def __init__(
        self,
        api_name_keyword: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_name_keyword = api_name_keyword
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_name_keyword is not None:
            result['ApiNameKeyword'] = self.api_name_keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiNameKeyword') is not None:
            self.api_name_keyword = m.get('ApiNameKeyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords(TeaModel):
    def __init__(
        self,
        created_time: str = None,
        creator_id: str = None,
        end_time: str = None,
        project_id: int = None,
    ):
        self.created_time = created_time
        self.creator_id = creator_id
        self.end_time = end_time
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        api_name: str = None,
        api_path: str = None,
        api_status: int = None,
        authorization_records: List[ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords] = None,
        created_time: str = None,
        creator_id: str = None,
        group_id: str = None,
        modified_time: str = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.api_name = api_name
        self.api_path = api_path
        self.api_status = api_status
        self.authorization_records = authorization_records
        self.created_time = created_time
        self.creator_id = creator_id
        self.group_id = group_id
        self.modified_time = modified_time
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        if self.authorization_records:
            for k in self.authorization_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.api_status is not None:
            result['ApiStatus'] = self.api_status
        result['AuthorizationRecords'] = []
        if self.authorization_records is not None:
            for k in self.authorization_records:
                result['AuthorizationRecords'].append(k.to_map() if k else None)
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('ApiStatus') is not None:
            self.api_status = m.get('ApiStatus')
        self.authorization_records = []
        if m.get('AuthorizationRecords') is not None:
            for k in m.get('AuthorizationRecords'):
                temp_model = ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords()
                self.authorization_records.append(temp_model.from_map(k))
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListDataServiceApiAuthoritiesResponseBodyData(TeaModel):
    def __init__(
        self,
        api_authorization_list: List[ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.api_authorization_list = api_authorization_list
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.api_authorization_list:
            for k in self.api_authorization_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ApiAuthorizationList'] = []
        if self.api_authorization_list is not None:
            for k in self.api_authorization_list:
                result['ApiAuthorizationList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.api_authorization_list = []
        if m.get('ApiAuthorizationList') is not None:
            for k in m.get('ApiAuthorizationList'):
                temp_model = ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList()
                self.api_authorization_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDataServiceApiAuthoritiesResponseBody(TeaModel):
    def __init__(
        self,
        data: ListDataServiceApiAuthoritiesResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListDataServiceApiAuthoritiesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListDataServiceApiAuthoritiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDataServiceApiAuthoritiesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDataServiceApiAuthoritiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDataServiceApisRequest(TeaModel):
    def __init__(
        self,
        api_name_keyword: str = None,
        api_path_keyword: str = None,
        creator_id: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_name_keyword = api_name_keyword
        self.api_path_keyword = api_path_keyword
        self.creator_id = creator_id
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_name_keyword is not None:
            result['ApiNameKeyword'] = self.api_name_keyword
        if self.api_path_keyword is not None:
            result['ApiPathKeyword'] = self.api_path_keyword
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiNameKeyword') is not None:
            self.api_name_keyword = m.get('ApiNameKeyword')
        if m.get('ApiPathKeyword') is not None:
            self.api_path_keyword = m.get('ApiPathKeyword')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        error_solution: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.column_name = column_name
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class ListDataServiceApisResponseBodyDataApisRegistrationDetails(TeaModel):
    def __init__(
        self,
        failed_result_sample: str = None,
        registration_error_codes: List[ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes] = None,
        registration_request_parameters: List[ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters] = None,
        service_content_type: int = None,
        service_host: str = None,
        service_path: str = None,
        service_request_body_description: str = None,
        successful_result_sample: str = None,
    ):
        self.failed_result_sample = failed_result_sample
        self.registration_error_codes = registration_error_codes
        self.registration_request_parameters = registration_request_parameters
        self.service_content_type = service_content_type
        self.service_host = service_host
        self.service_path = service_path
        self.service_request_body_description = service_request_body_description
        self.successful_result_sample = successful_result_sample

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.column_name = column_name
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        example_value: str = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
    ):
        self.column_name = column_name
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetails(TeaModel):
    def __init__(
        self,
        is_paged_response: bool = None,
        script: str = None,
        script_connection: ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection = None,
        script_request_parameters: List[ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters] = None,
        script_response_parameters: List[ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters] = None,
    ):
        self.is_paged_response = is_paged_response
        self.script = script
        self.script_connection = script_connection
        self.script_request_parameters = script_request_parameters
        self.script_response_parameters = script_response_parameters

    def validate(self):
        if self.script_connection:
            self.script_connection.validate()
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.script is not None:
            result['Script'] = self.script
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('ScriptConnection') is not None:
            temp_model = ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        return self


class ListDataServiceApisResponseBodyDataApisWizardDetailsWizardConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class ListDataServiceApisResponseBodyDataApisWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.column_name = column_name
        self.default_value = default_value
        self.