import typing

from enum import Enum

class Dice:
    id: int
    name: str

    def __init__(self, _id: int, name: str, shop_level: int):
        self.id = _id
        self.name = name
        self.shop_level = shop_level

    def __str__(self) -> str:
        return (
            f"{self.name} "
        )
    
    # location in memory?

all_dice: typing.Tuple[Dice, ...] = (
    Dice(0, "B.eye White Dragon", 14),
    Dice(1, "Mystical Elf", 5),
    Dice(2, "Hitotsu-me Giant", 3),
    Dice(3, "Baby Dragon", 2),
    Dice(4, "Ryu-kishin", 0),
    Dice(5, "Feral Imp", 7),
    Dice(6, "Winged Dragon #1", 4),
    Dice(7, "Mushroom Man", 0),
    Dice(8, "Shadow Specter", 0),
    Dice(11, "Swamp Battleguard", 5),
    Dice(12, "Battle Steer", 4),
    Dice(13, "Flame Swordsman", 4),
    Dice(14, "Time Wizard", 6),
    Dice(15, "R Leg of Forbidden", 0),
    Dice(16, "L Leg of Forbidden", 0),
    Dice(17, "R Arm of Forbidden", 0),
    Dice(18, "L Arm of Forbidden", 0),
    Dice(19, "Exod. of Forbidden", 3),
    Dice(20, "Summoned Skull", 12),
    Dice(22, "Battle Ox", 4), #jumps to 23 here
    Dice(23, "Beaver Warrior", 0),
    Dice(24, "Rock Ogre Grotto #1", 6),
    Dice(26, "Zombie Warrior", 6),
    Dice(27, "Koumori Dragon", 2),
    Dice(30, "Saggi the Dark Clown", 4),
    Dice(31, "Dark Magician", 11),
    Dice(32, "The Snake Hair", 6),
    Dice(33, "Gaia the Dragon Champion", 13),
    Dice(34, "Gaia the Fierce Knight", 13),
    Dice(35, "Curse of Dragon", 5),
    Dice(36, "Dragon Piper", 7),
    Dice(37, "Celtic Guardian", 1),
    Dice(38, "Faceless Mage", 6),
    Dice(39, "Karbonala Warrior", 0),
    Dice(40, "Rogue Doll", 8),
    Dice(41, "Sangan", 0),
    Dice(45, "Killer Needle", 1),
    Dice(47, "Giant Flea", 2),
    Dice(48, "Larvae Moth", 4),
    Dice(49, "Great Moth", 10),
    Dice(50, "Kuriboh", 0),
    Dice(51, "Mammoth Graveyard", 6),
    Dice(53, "Harpie Lady", 6),
    Dice(54, "Harpie Lady Sisters", 8),
    Dice(58, "Perfectly Ultimate", 16),
    Dice(60, "Thousand Dragon", 7),
    Dice(62, "Jellyfish", 6),
    Dice(63, "Cocoon of Evolution", 7),
    Dice(65, "Giant Rock Soldier", 9),
    Dice(71, "Red-eyes B. Dragon", 12),
    Dice(72, "Castle of D. Magic", 5),
    Dice(76, "Metal Guardian", 5),
    Dice(79, "Mystic Horseman", 6),
    Dice(80, "Rabid Horseman", 9),
    Dice(86, "Clown Zombie", 0),
    Dice(87, "Pumpking the King of Ghosts", 8),
    Dice(88, "Battle Warrior", 3),
    Dice(92, "The 13th Grave", 2),
    Dice(95, "Petit Dragon", 6),
    Dice(97, "Aqua Madoor", 1),
    Dice(98, "B. Skull Dragon", 15),
    Dice(99, "Beautiful Headhuntress", 0),
    Dice(107, "Yaranzo", 1),
    Dice(108, "Kanan the Swordmistress", 1),
    Dice(110, "Stuffed Animal", 0),
    Dice(113, "Three-legged Zombies", 1),
    Dice(114, "Flying Penguin", 0),
    Dice(115, "Millennium Shield", 1),
    Dice(117, "Black Luster Soldier", 13),
    Dice(118, "Fiend's Mirror", 0),
    Dice(120, "Jirai Gumo", 1),
    Dice(123, "Sanga of the Thunder", 11),
    Dice(124, "Kazejin", 11),
    Dice(125, "Suijin", 11),
    Dice(126, "Gate Guardian", 16),
    Dice(129, "Ryu-kishin Powered", 7),
    Dice(132, "B.eye Ultimate Dragon", 17),
    Dice(135, "Parrot Dragon", 7),
    Dice(138, "Mystic Lamp", 6),
    Dice(139, "Pendulum Machine", 7),
    Dice(142, "Zoa", 7),
    Dice(143, "Metalzoa", 9),
    Dice(144, "Dancing Elf", 3),
    Dice(152, "Man-eater Bug", 0),
    Dice(155, "Gemini Elf", 9),
    Dice(156, "Skelengel", 6),
    Dice(157, "Hane-Hane", 0),
    Dice(161, "Penguin Soldier", 0),
    Dice(162, "Twin-headed Thunder Dragon", 10),
    Dice(163, "Witch's Apprentice", 0),
    Dice(166, "Meteor Dragon", 10),
    Dice(167, "Meteor B. Dragon", 11),
    Dice(169, "Dokurorider", 6),
    Dice(170, "Magician of Black Chaos", 13),
    Dice(171, "Slot Machine", 6),
    Dice(172, "Red Archery Girl", 0),
    Dice(173, "Dark-eyes Illusionist", 10),
    Dice(174, "Relinquished", 11),
    Dice(175, "Thousand-eyes Restrict", 13),
    Dice(176, "Lord of D.", 7),
    Dice(177, "R.eye B. M. Dragon", 13),
    Dice(178, "Barrel Dragon", 10),
    Dice(179, "Jinzo", 0),
    Dice(180, "D. Magician Girl", 19),
    Dice(181, "Twin-Headed Dragon", 1),
    Dice(182, "Gator Dragon", 4),
    Dice(183, "Blast Lizard", 14),
    Dice(184, "Knight of Twin Swords", 10),
    Dice(185, "Thunder Ball", 14),
    Dice(186, "Magician Dragon", 18),
    Dice(187, "Strike Ninja", 16),
    Dice(188, "Mighty Mage", 11),
    Dice(189, "Crocozaurus", 12),
    Dice(190, "Orgoth the Relentless", 13),
    Dice(191, "Medical Aid Kit", 5),
    Dice(192, "Exploding Disc", 4),
    Dice(193, "Time Machine", 2),
    Dice(194, "Energy Disc", 9),
    Dice(195, "Trap Bandit", 0),
    Dice(196, "Decleration of Despair", 0),
    Dice(197, "Gluminizer", 6),
    Dice(198, "Resurrection Scroll", 9),
    Dice(199, "Warp Vortex", 7),
    Dice(200, "Crater Creator", 12)
)

id_to_dice = {dice.id: dice for dice in all_dice}
name_to_dice = {dice.name: dice for dice in all_dice}