from typing import List, Optional, NamedTuple, TYPE_CHECKING

if TYPE_CHECKING:
    from . import Z2World


class LocationData(NamedTuple):
    region: str
    name: str
    code: Optional[int]


def get_locations(world: "Z2World") -> List[LocationData]:

    location_table: List[LocationData] = [
        LocationData("Northwestern Hyrule", "Northern Desert Cave", 0x01),
        LocationData("Northwestern Hyrule", "Northwestern Forest Item", 0x02),
        LocationData("Northwestern Hyrule", "North Castle Cave", 0x03),
        LocationData("Northwestern Hyrule", "Sage of Rauru", 0x04),
        LocationData("Northwestern Hyrule", "Sage of Ruto", 0x05),
        LocationData("Northwestern Hyrule", "Tantari Coast Item", 0x06),
        
        LocationData("Parapa Palace", "Parapa Palace: 1F West Hall", 0x07),
        LocationData("Parapa Palace", "Parapa Palace: Pedestal Item", 0x08),
        LocationData("Parapa Palace", "Parapa Palace: Crumbling Bridge", 0x09),
        LocationData("Parapa Palace", "Parapa Palace: Stairwell", 0x0A),
        LocationData("Parapa Palace", "Parapa Palace: Guarded Item", 0x0B),
        LocationData("Parapa Palace", "Parapa Palace: Horsehead Drop", 0x0C),

        LocationData("Western Hyrule", "Western Swamp Cave", 0x0D),
        LocationData("Western Hyrule", "Western Swamp Hidden Item", 0x0E),
        LocationData("Western Hyrule", "Gift from Bagu", 0x0F),
        LocationData("Western Hyrule", "Midoro Swamp Pathway Item", 0x10),
        LocationData("Western Hyrule", "Midoro Swamp Hidden Item", 0x11),
        LocationData("Western Hyrule", "Clear Cave South of Rauru", 0x12),
        LocationData("Western Hyrule", "Blocked Cave South of Rauru", 0x013),
        LocationData("Western Hyrule", "Sage of Saria", 0x14),
        LocationData("Western Hyrule", "Forest Near Saria", 0x15),

        LocationData("Midoro Palace", "Midoro Palace: B2F Hall", 0x16),
        LocationData("Midoro Palace", "Midoro Palace: Lava Blocks Item", 0x17),
        LocationData("Midoro Palace", "Midoro Palace: Floating Block Hall", 0x18),
        LocationData("Midoro Palace", "Midoro Palace: Falling Blocks Item", 0x19),
        LocationData("Midoro Palace", "Midoro Palace: Pedestal Item", 0x1A),
        LocationData("Midoro Palace", "Midoro Palace: Guarded Item", 0x1B),
        LocationData("Midoro Palace", "Midoro Palace: Crumbling Blocks", 0x1C),
        LocationData("Midoro Palace", "Midoro Palace: Helmethead Drop", 0x1D),

        LocationData("Death Mountain", "Death Mountain Platforms", 0x1E),
        LocationData("Death Mountain", "Death Mountain Staircase", 0x1F),
        LocationData("Death Mountain", "Death Mountain Boulder Pit", 0x20),
        LocationData("Death Mountain", "Death Mountain Ending Item", 0x21),
        LocationData("Death Mountain", "Death Mountain East-Facing Dead End", 0x22),

        LocationData("Western Coast", "Graveyard Item", 0x23),
        LocationData("Western Coast", "Graveyard Beach Secret", 0x24),
        LocationData("Western Coast", "Sage of Mido", 0x25),
        LocationData("Western Coast", "Mido Swordsman", 0x26),

        LocationData("Island Palace", "Island Palace: Buried Item Left", 0x27),
        LocationData("Island Palace", "Island Palace: Buried Item Right", 0x28),
        LocationData("Island Palace", "Island Palace: Outside", 0x29),
        LocationData("Island Palace", "Island Palace: Block Mountain", 0x2A),
        LocationData("Island Palace", "Island Palace: Precarious Item", 0x2B),
        LocationData("Island Palace", "Island Palace: Pedestal Item", 0x2C),
        LocationData("Island Palace", "Island Palace: Pillar Item", 0x2E),
        LocationData("Island Palace", "Island Palace: Guarded by Iron Knuckles", 0x2F),
        LocationData("Island Palace", "Island Palace: Rebonack Drop", 0x30),

        LocationData("Eastern Hyrule", "Eastern Forest", 0x31),
        LocationData("Eastern Hyrule", "Sage of Nabooru", 0x32),
        LocationData("Eastern Hyrule", "Eastern Cave", 0x33),
        LocationData("Eastern Hyrule", "Eastern Peninsula Secret", 0x34),
        LocationData("Eastern Hyrule", "Eastern Beach Secret", 0x35),
        LocationData("Eastern Hyrule", "Ocean Item", 0x36),

        LocationData("Northeastern Hyrule", "Sage of Darunia", 0x37),
        LocationData("Northeastern Hyrule", "Darunia Swordsman", 0x38),
        LocationData("Northeastern Hyrule", "Northeastern Beach", 0x39),
        LocationData("Northeastern Hyrule", "Maze Island Left Hole", 0x3A),
        LocationData("Northeastern Hyrule", "Maze Island Path", 0x3B),
        LocationData("Northeastern Hyrule", "Maze Island Right Hole", 0x3C),

        LocationData("Maze Palace", "Maze Palace: Nook Item", 0x3D),
        LocationData("Maze Palace", "Maze Palace: Sealed Item", 0x3E),
        LocationData("Maze Palace", "Maze Palace: Block Mountain Left", 0x3F),
        LocationData("Maze Palace", "Maze Palace: Block Mountain Right", 0x40),
        LocationData("Maze Palace", "Maze Palace: West Hall of Fire", 0x41),
        LocationData("Maze Palace", "Maze Palace: East Hall of Fire", 0x42),
        LocationData("Maze Palace", "Maze Palace: Basement Hall of Fire", 0x43),
        LocationData("Maze Palace", "Maze Palace: Block Mountain Basement", 0x44),
        LocationData("Maze Palace", "Maze Palace: Pillar Item", 0x45),
        LocationData("Maze Palace", "Maze Palace: Pedestal Item", 0x46),
        LocationData("Maze Palace", "Maze Palace: Carock Drop", 0x47),

        LocationData("Palace on the Sea", "Palace on the Sea: Ledge Item", 0x48),
        LocationData("Palace on the Sea", "Palace on the Sea: Crumbling Bridge", 0x49),
        LocationData("Palace on the Sea", "Palace on the Sea: Falling Blocks", 0x4A),
        LocationData("Palace on the Sea", "Palace on the Sea: Above Elevator", 0x4B),
        LocationData("Palace on the Sea", "Palace on the Sea: Block Alcove", 0x4C),
        LocationData("Palace on the Sea", "Palace on the Sea: Knuckle Alcove", 0x4D),
        LocationData("Palace on the Sea", "Palace on the Sea: Pedestal Item", 0x4E),
        LocationData("Palace on the Sea", "Palace on the Sea: Skeleton Key", 0x4F),
        LocationData("Palace on the Sea", "Palace on the Sea: West Wing", 0x50),
        LocationData("Palace on the Sea", "Palace on the Sea: Block Line", 0x51),
        LocationData("Palace on the Sea", "Palace on the Sea: West Knuckle Alcove", 0x52),
        LocationData("Palace on the Sea", "Palace on the Sea: Gooma Drop", 0x53),

        LocationData("Southeastern Hyrule", "Southeastern Swamp", 0x54),
        LocationData("Southeastern Hyrule", "Southeastern Swamp Cave", 0x55),
        LocationData("Southeastern Hyrule", "Southeastern Coast Item", 0x56),
        LocationData("Southeastern Hyrule", "Southeastern Forest Item", 0x57),
        LocationData("Southeastern Hyrule", "Death Valley Entrance", 0x58),
        LocationData("Southeastern Hyrule", "Death Valley Midway Item", 0x59),
        LocationData("Southeastern Hyrule", "Sage of Kasuto", 0x5A),
        LocationData("Southeastern Hyrule", "Sage of New Kasuto", 0x5B),
        LocationData("Southeastern Hyrule", "New Kasuto Shrine", 0x5C),
        LocationData("Southeastern Hyrule", "New Kasuto House", 0x5D),

        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: 1F Block Mountain", 0x5E),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: 1F Enclosed Item", 0x5F),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Middle Pit", 0x60),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Bottom Pit", 0x61),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Block Stairs", 0x62),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Pit of Sadness", 0x63),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Return of Helmethead", 0x64),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Pedestal Item", 0x65),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Helmethead III: The Revengening", 0x66),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Basement Block Mountain", 0x67),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Pit Hall", 0x68),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Barba Drop", 0x69),

        LocationData("Great Palace", "Great Palace - East Wing Item", 0x6A),
        LocationData("Great Palace", "Great Palace - Thunderbird Drop", 0x6B),

        LocationData("Parapa Palace", "Parapa Palace: Statue", None),
        LocationData("Midoro Palace", "Midoro Palace: Statue", None),
        LocationData("Island Palace", "Island Palace: Statue", None),
        LocationData("Maze Palace", "Maze Palace: Statue", None),
        LocationData("Palace on the Sea", "Palace on the Sea: Statue", None),
        LocationData("Three-Eye Rock Palace", "Three-Eye Rock Palace: Statue", None),
        LocationData("Great Palace", "Dark Link", None)
    ]

    return location_table

static_locations = {
    "Northern Desert Cave": 0x01,
    "Northwestern Forest Item": 0x02,
    "North Castle Cave": 0x03,
    "Sage of Rauru": 0x04,
    "Sage of Ruto": 0x05,
    "Tantari Coast Item": 0x06,
    "Parapa Palace: 1F West Hall": 0x07,
    "Parapa Palace: Pedestal Item": 0x08,
    "Parapa Palace: Crumbling Bridge": 0x09,
    "Parapa Palace: Stairwell": 0x0A,
    "Parapa Palace: Guarded Item": 0x0B,
    "Parapa Palace: Horsehead Drop": 0x0C,
    "Western Swamp Cave": 0x0D,
    "Western Swamp Hidden Item": 0x0E,
    "Gift from Bagu": 0x0F,
    "Midoro Swamp Pathway Item": 0x10,
    "Midoro Swamp Hidden Item": 0x11,
    "Clear Cave South of Rauru": 0x12,
    "Blocked Cave South of Rauru": 0x013,
    "Sage of Saria": 0x14,
    "Forest Near Saria": 0x15,
    "Midoro Palace: B2F Hall": 0x16,
    "Midoro Palace: Lava Blocks Item": 0x17,
    "Midoro Palace: Floating Block Hall": 0x18,
    "Midoro Palace: Falling Blocks Item": 0x19,
    "Midoro Palace: Pedestal Item": 0x1A,
    "Midoro Palace: Guarded Item": 0x1B,
    "Midoro Palace: Crumbling Blocks": 0x1C,
    "Midoro Palace: Helmethead Drop": 0x1D,
    "Death Mountain Platforms": 0x1E,
    "Death Mountain Staircase": 0x1F,
    "Death Mountain Boulder Pit": 0x20,
    "Death Mountain Ending Item": 0x21,
    "Death Mountain East-Facing Dead End": 0x22,
    "Graveyard Item": 0x23,
    "Graveyard Beach Secret": 0x24,
    "Sage of Mido": 0x25,
    "Mido Swordsman": 0x26,
    "Island Palace: Buried Item Left": 0x27,
    "Island Palace: Buried Item Right": 0x28,
    "Island Palace: Outside": 0x29,
    "Island Palace: Block Mountain": 0x2A,
    "Island Palace: Precarious Item": 0x2B,
    "Island Palace: Pedestal Item": 0x2C,
    "Island Palace: Pillar Item": 0x2E,
    "Island Palace: Guarded by Iron Knuckles": 0x2F,
    "Island Palace: Rebonack Drop": 0x30,
    "Eastern Forest": 0x31,
    "Sage of Nabooru": 0x32,
    "Eastern Cave": 0x33,
    "Eastern Peninsula Secret": 0x34,
    "Eastern Beach Secret": 0x35,
    "Ocean Item": 0x36,
    "Sage of Darunia": 0x37,
    "Darunia Swordsman": 0x38,
    "Northeastern Beach": 0x39,
    "Maze Island Left Hole": 0x3A,
    "Maze Island Path": 0x3B,
    "Maze Island Right Hole": 0x3C,
    "Maze Palace: Nook Item": 0x3D,
    "Maze Palace: Sealed Item": 0x3E,
    "Maze Palace: Block Mountain Left": 0x3F,
    "Maze Palace: Block Mountain Right": 0x40,
    "Maze Palace: West Hall of Fire": 0x41,
    "Maze Palace: East Hall of Fire": 0x42,
    "Maze Palace: Basement Hall of Fire": 0x43,
    "Maze Palace: Block Mountain Basement": 0x44,
    "Maze Palace: Pillar Item": 0x45,
    "Maze Palace: Pedestal Item": 0x46,
    "Maze Palace: Carock Drop": 0x47,
    "Palace on the Sea: Ledge Item": 0x48,
    "Palace on the Sea: Crumbling Bridge": 0x49,
    "Palace on the Sea: Falling Blocks": 0x4A,
    "Palace on the Sea: Above Elevator": 0x4B,
    "Palace on the Sea: Block Alcove": 0x4C,
    "Palace on the Sea: Knuckle Alcove": 0x4D,
    "Palace on the Sea: Pedestal Item": 0x4E,
    "Palace on the Sea: Skeleton Key": 0x4F,
    "Palace on the Sea: West Wing": 0x50,
    "Palace on the Sea: Block Line": 0x51,
    "Palace on the Sea: West Knuckle Alcove": 0x52,
    "Palace on the Sea: Gooma Drop": 0x53,
    "Southeastern Swamp": 0x54,
    "Southeastern Swamp Cave": 0x55,
    "Southeastern Coast Item": 0x56,
    "Southeastern Forest Item": 0x57,
    "Death Valley Entrance": 0x58,
    "Death Valley Midway Item": 0x59,
    "Sage of Kasuto": 0x5A,
    "Sage of New Kasuto": 0x5B,
    "New Kasuto Shrine": 0x5C,
    "New Kasuto House": 0x5D,
    "Three-Eye Rock Palace: 1F Block Mountain": 0x5E,
    "Three-Eye Rock Palace: 1F Enclosed Item": 0x5F,
    "Three-Eye Rock Palace: Middle Pit": 0x60,
    "Three-Eye Rock Palace: Bottom Pit": 0x61,
    "Three-Eye Rock Palace: Block Stairs": 0x62,
    "Three-Eye Rock Palace: Pit of Sadness": 0x63,
    "Three-Eye Rock Palace: Return of Helmethead": 0x64,
    "Three-Eye Rock Palace: Pedestal Item": 0x65,
    "Three-Eye Rock Palace: Helmethead III: The Revengening": 0x66,
    "Three-Eye Rock Palace: Basement Block Mountain": 0x67,
    "Three-Eye Rock Palace: Pit Hall": 0x68,
    "Three-Eye Rock Palace: Barba Drop": 0x69,
    "Great Palace - East Wing Item": 0x6A,
    "Great Palace - Thunderbird Drop": 0x6B
}