import struct

from typing import Dict, List

player_palettes = {
    "blue": [
        "$35D0","$7BDE","$239D","$091E","$7B6F","$7A8A","$5963","$7E00",
        "$7900","$40C4","$42DF","$2597","$1110","$739C","$4E73","$0C63",
    ],
    "gold_armor": [
        "$35D0","$7BDE","$239D","$091E","$7BFF","$1F9F","$09DF","$73DF",
        "$0ADE","$055D","$42DF","$2597","$1110","$4FBF","$121D","$0C63",
    ],
    "charge_blue": [
        "$35AF","$7FFF","$239D","$61BE","$7BD4","$7B6A","$7203","$7EE0",
        "$7A40","$79A4","$42DF","$2597","$1110","$7FFF","$5AD6","$7143",
    ],
    "charge_green": [
        "$35AF","$739C","$239D","$091E","$7BFA","$5389","$4324","$43F1",
        "$4324","$22A4","$42DF","$2597","$1110","$7BFA","$5389","$0180",
    ],
    "charge_pink": [
        "$35AF","$7FFF","$239D","$61BE","$7F9C","$7ED9","$7A33","$7EB6",
        "$7E36","$75D1","$42DF","$2597","$1110","$7FFF","$5AD6","$6C12",
    ],
    "charge_red": [
        "$35AF","$739C","$239D","$091E","$4F5F","$3E9E","$163C","$16BF",
        "$163C","$113C","$42DF","$2597","$1110","$4F5F","$3E9E","$0011",
    ],
    "acid_burst": [
        "$35D0","$7BDE","$239D","$091E","$1F1E","$11F8","$0132","$43F7",
        "$1BAC","$1689","$42DF","$2597","$1110","$739C","$4E73","$0C63",
    ],
    "parasitic_bomb": [
        "$35D0","$7BDE","$239D","$091E","$6776","$424E","$2547","$03FF",
        "$02D7","$018D","$42DF","$2597","$1110","$739C","$4E73","$0C63",
    ],
    "triad_thunder": [
        "$35D0","$7BDE","$239D","$091E","$4F9A","$274F","$222C","$7E14",
        "$5D0E","$3C8C","$42DF","$2597","$1110","$739C","$4E73","$0C63",
    ],
    "spinning_blade": [
        "$35D0","$7BDE","$239D","$091E","$6318","$4210","$2108","$195F",
        "$0098","$0010","$42DF","$2597","$1110","$739C","$4E73","$0C63",
    ],
    "ray_splasher": [
        "$35D0","$7BDE","$239D","$091E","$03FF","$02D7","$018D","$1EDE",
        "$11B8","$00F2","$42DF","$2597","$1110","$739C","$4E73","$0C63",
    ],
    "gravity_well": [
        "$35D0","$7BDE","$239D","$091E","$531C","$3214","$110C","$7DFE",
        "$6518","$5093","$42DF","$2597","$1110","$739C","$4E73","$0C63",
    ],
    "frost_shield": [
        "$35D0","$7BDE","$239D","$091E","$7E3A","$7174","$58EF","$7BAF",
        "$6B29","$5264","$42DF","$2597","$1110","$739C","$4E73","$0C63",
    ],
    "tornado_fang": [
        "$35D0","$7BDE","$239D","$091E","$1EDE","$0976","$0050","$73D0",
        "$5B08","$3A00","$42DF","$2597","$1110","$739C","$4E73","$0C63",
    ],
    "crystal_hunter": [
        "$35D0","$7BDE","$239D","$091E","$7F3E","$7256","$5DB1","$7B6F",
        "$7A8A","$59A5","$42DF","$2597","$1110","$7BDE","$4E73","$0C63",
    ],
    "bubble_splash": [
        "$35D0","$7BDE","$239D","$091E","$773F","$5639","$3D16","$131F",
        "$0657","$01B1","$42DF","$2597","$1110","$7BDE","$4E73","$0C63",
    ],
    "silk_shot": [
        "$35D0","$7BDE","$239D","$091E","$5FF4","$3F2C","$1E65","$1E1F",
        "$011F","$00F6","$42DF","$2597","$1110","$7BDE","$4E73","$0C63",
    ],
    "spin_wheel": [
        "$35D0","$7BDE","$239D","$091E","$7F7F","$7E59","$75B5","$2B00",
        "$2240","$1DC4","$42DF","$2597","$1110","$7BDE","$4E73","$0C63",
    ],
    "sonic_slicer": [
        "$35D0","$7BDE","$239D","$091E","$031F","$021F","$017B","$75AB",
        "$590A","$28E8","$42DF","$2597","$1110","$7BDE","$4E73","$0C63",
    ],
    "strike_chain": [
        "$35D0","$7BDE","$239D","$091E","$779C","$62D6","$4E10","$7A7A",
        "$75D2","$5CEF","$42DF","$2597","$1110","$7BDE","$4E73","$0C63",
    ],
    "magnet_mine": [
        "$35D0","$7BDE","$239D","$091E","$2FFF","$0F18","$0A52","$4E31",
        "$398C","$2908","$42DF","$2597","$1110","$7BDE","$4E73","$0C63",
    ],
    "speed_burner": [
        "$35D0","$7BDE","$239D","$091E","$7F98","$7ACF","$6645","$10DF",
        "$0CB7","$0452","$42DF","$2597","$1110","$7BDE","$4E73","$0C63",
    ],
    "homing_torpedo": [
        "$35D0","$7BDE","$22FF","$0059","$5B7F","$46DB","$3657","$4250",
        "$35ED","$2168","$42DF","$2597","$1110","$7BDE","$4E73","$14A5",
    ],
    "chameleon_sting": [
        "$35D0","$7BDE","$22FF","$0059","$73D8","$574C","$3EE4","$2AC3",
        "$2A44","$1541","$42DF","$2597","$1110","$7BDE","$4E73","$14A5",
    ],
    "rolling_shield": [
        "$35D0","$7BDE","$22FF","$0059","$6BB9","$5714","$46B0","$4E1E",
        "$311C","$209A","$42DF","$2597","$1110","$7BDE","$4E73","$14A5",
    ],
    "fire_wave": [
        "$35D0","$7BDE","$22FF","$0059","$3F9F","$229F","$0D9E","$055E",
        "$0CFA","$0074","$42DF","$2597","$1110","$7BDE","$4E73","$14A5",
    ],
    "storm_tornado": [
        "$35D0","$7BDE","$22FF","$0059","$731F","$625C","$5A1A","$4973",
        "$4953","$3CCE","$42DF","$2597","$1110","$7BDE","$4E73","$14A5",
    ],
    "electric_spark": [
        "$35D0","$7BDE","$22FF","$0059","$6F7B","$5AD6","$5294","$06DF",
        "$05F8","$014F","$42DF","$2597","$1110","$7BDE","$4E73","$14A5",
    ],
    "boomerang_cutter": [
        "$35D0","$7BDE","$22FF","$0059","$6BB9","$5714","$46B0","$49CE",
        "$418C","$2908","$42DF","$2597","$1110","$7BDE","$4E73","$14A5",
    ],
    "shotgun_ice": [
        "$35D0","$7BDE","$239D","$091E","$2B9F","$1ABD","$11B5","$7F87",
        "$766A","$79C7","$42DF","$2597","$1110","$7BDE","$4210","$0C63",
    ],
    "x4_default_armor": [
        "$0000","$77BD","$4BBF","$14DD","$5306","$3623","$3124","$6DE7",
        "$6124","$44A3","$46FF","$223D","$0CAC","$77BD","$4631","$0C63",
    ],
    "x4_ultimate_armor": [
        "$0000","$7F9B","$4BBF","$223D","$7271","$5D71","$506C","$6DC8",
        "$4145","$2CE3","$46FF","$2195","$14EB","$3504","$1CC4","$0C63",
    ],
    "x5_ultimate_armor": [
        "$0000","$7F9B","$4BBF","$223D","$5306","$3623","$3124","$6DEA",
        "$4566","$3103","$4EFD","$2195","$14EB","$3D24","$24E5","$0C63",
    ],
    "x6_shadow_armor": [
        "$0000","$77BD","$23BE","$15BD","$339E","$121C","$1174","$2D27",
        "$1CC5","$0C63","$46FF","$2598","$1111","$398A","$2D27","$0C63",
    ],
    "x6_blade_armor": [
        "$0000","$77BD","$23BE","$223D","$03E0","$0269","$2D03","$7E20",
        "$7D00","$44C4","$46FF","$2598","$1111","$77BD","$4631","$0C63",
    ],
    "classic_blue": [
        "$0000","$77BD","$23BE","$77BD","$6FA0","$6FA0","$6FA0","$79C0",
        "$79C0","$79C0","$577F","$577F","$577F","$77BD","$77BD","$0C63",
    ],
    "smw_mario": [
        "$0000","$77BD","$03FF","$091F","$6770","$4E08","$44C4","$391F",
        "$30B6","$000A","$46FF","$2598","$1111","$77BD","$4631","$0C63",
    ],
    "smw_luigi": [
        "$0000","$77BD","$03FF","$091F","$3FE0","$2F00","$1140","$7DB3",
        "$7CAE","$3C07","$46FF","$2598","$1111","$77BD","$4631","$0C63",
    ],
    "salvager_rex": [
        "$0000","$77BD","$23BE","$091F","$36FE","$2A17","$190D","$7187",
        "$6126","$34A4","$46FF","$2598","$1111","$77BD","$4631","$0C63",
    ],
    "master_driver_rex_2": [
        "$0000","$77BD","$23BE","$091F","$24C5","$0C63","$0C63","$46E8",
        "$31E5","$2144","$46FF","$2598","$1111","$77BD","$4631","$0C63",
    ],
    "master_driver_rex_3": [
        "$0000","$77BD","$26DE","$5126","$24C5","$0C63","$0C63","$5D68",
        "$4D05","$34A3","$46FF","$2598","$18C6","$3548","$24C5","$0C63",
    ],
    "grand_marshall_shulk": [
        "$0000","$77BD","$4F1B","$6F4C","$5273","$3DEE","$316A","$3159",
        "$20F3","$20CD","$46FF","$2598","$18C6","$77BD","$4631","$0C63",
    ],
    "lifesage_nia": [
        "$0000","$77BD","$3F3D","$570F","$35F5","$214D","$18E9","$579F",
        "$3697","$2590","$46FF","$2598","$18C6","$77BD","$4631","$0C63",
    ],
    "royal_summoner_melia": [
        "$0000","$77BD","$3F3D","$6EAF","$396A","$2D07","$1CA4","$4DCC",
        "$4128","$28A5","$46FF","$2598","$18C6","$77BD","$5231","$0C63",
    ],
    "youmu": [
        "$0000","$77BD","$23BE","$2529","$77BD","$4631","$2529","$3267",
        "$25C3","$1D43","$46FF","$2598","$18C6","$77BD","$4631","$0C63",
    ],
    "yohane": [
        "$0000","$77BD","$2AFF","$381C","$6315","$5A4F","$3969","$396D",
        "$2D29","$24C6","$46FF","$2598","$1111","$77BD","$5252","$0C63",
    ],
    "okayu": [
        "$0000","$77BD","$26DE","$512D","$77BD","$4631","$2529","$5D71",
        "$4D0C","$34A8","$46FF","$2598","$18C6","$3548","$24C5","$0C63",
    ],
}

def get_palette_bytes(palette: Dict[str, List]) -> bytearray:
    output_data = bytearray()
    for hexcol in palette:
        if hexcol.startswith("$"):
            hexcol = hexcol.replace("$", "")
            colint = int(hexcol, 16)
            output_data.extend(bytearray(struct.pack("H", colint)))
        else:
            if hexcol.startswith("#"):
                hexcol = hexcol.replace("#", "")
            colint = int(hexcol, 16)
            col = ((colint & 0xFF0000) >> 16, (colint & 0xFF00) >> 8, colint & 0xFF)
            col = tuple(x for x in col)
            byte_data = rgb888_to_bgr555(col[0], col[1], col[2])
            output_data.extend(bytearray(byte_data))
    return output_data

def rgb888_to_bgr555(red, green, blue) -> bytes:
    red = red >> 3
    green = green >> 3
    blue = blue >> 3
    outcol = (blue << 10) + (green << 5) + red
    return struct.pack("H", outcol)
