# This file is auto generated. More info: https://github.com/Daivuk/apdoom

from BaseClasses import ItemClassification
from typing import TypedDict, Dict, Set 


class ItemDict(TypedDict, total=False): 
    classification: ItemClassification 
    count: int 
    name: str 
    doom_type: int # Unique numerical id used to spawn the item. -1 is level item, -2 is level complete item. 
    episode: int # Relevant if that item targets a specific level, like keycard or map reveal pickup. 
    map: int 


item_table: Dict[int, ItemDict] = {
    370000: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Gauntlets of the Necromancer',
             'doom_type': 2005,
             'episode': -1,
             'map': -1},
    370001: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ethereal Crossbow',
             'doom_type': 2001,
             'episode': -1,
             'map': -1},
    370002: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Dragon Claw',
             'doom_type': 53,
             'episode': -1,
             'map': -1},
    370003: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Phoenix Rod',
             'doom_type': 2003,
             'episode': -1,
             'map': -1},
    370004: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Firemace',
             'doom_type': 2002,
             'episode': -1,
             'map': -1},
    370005: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Hellstaff',
             'doom_type': 2004,
             'episode': -1,
             'map': -1},
    370006: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Bag of Holding',
             'doom_type': 8,
             'episode': -1,
             'map': -1},
    370007: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Chaos Device',
             'doom_type': 36,
             'episode': -1,
             'map': -1},
    370008: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Morph Ovum',
             'doom_type': 30,
             'episode': -1,
             'map': -1},
    370009: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Mystic Urn',
             'doom_type': 32,
             'episode': -1,
             'map': -1},
    370010: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Quartz Flask',
             'doom_type': 82,
             'episode': -1,
             'map': -1},
    370011: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Ring of Invincibility',
             'doom_type': 84,
             'episode': -1,
             'map': -1},
    370012: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Shadowsphere',
             'doom_type': 75,
             'episode': -1,
             'map': -1},
    370013: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Timebomb of the Ancients',
             'doom_type': 34,
             'episode': -1,
             'map': -1},
    370014: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Tome of Power',
             'doom_type': 86,
             'episode': -1,
             'map': -1},
    370015: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Torch',
             'doom_type': 33,
             'episode': -1,
             'map': -1},
    370016: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Silver Shield',
             'doom_type': 85,
             'episode': -1,
             'map': -1},
    370017: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Enchanted Shield',
             'doom_type': 31,
             'episode': -1,
             'map': -1},
    370018: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Crystal Geode',
             'doom_type': 12,
             'episode': -1,
             'map': -1},
    370019: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Energy Orb',
             'doom_type': 55,
             'episode': -1,
             'map': -1},
    370020: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Greater Runes',
             'doom_type': 21,
             'episode': -1,
             'map': -1},
    370021: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Inferno Orb',
             'doom_type': 23,
             'episode': -1,
             'map': -1},
    370022: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Pile of Mace Spheres',
             'doom_type': 16,
             'episode': -1,
             'map': -1},
    370023: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Quiver of Ethereal Arrows',
             'doom_type': 19,
             'episode': -1,
             'map': -1},
    370200: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Docks (E1M1) - Yellow key',
             'doom_type': 80,
             'episode': 1,
             'map': 1},
    370201: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Dungeons (E1M2) - Yellow key',
             'doom_type': 80,
             'episode': 1,
             'map': 2},
    370202: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Dungeons (E1M2) - Green key',
             'doom_type': 73,
             'episode': 1,
             'map': 2},
    370203: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Dungeons (E1M2) - Blue key',
             'doom_type': 79,
             'episode': 1,
             'map': 2},
    370204: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Gatehouse (E1M3) - Yellow key',
             'doom_type': 80,
             'episode': 1,
             'map': 3},
    370205: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Gatehouse (E1M3) - Green key',
             'doom_type': 73,
             'episode': 1,
             'map': 3},
    370206: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Guard Tower (E1M4) - Yellow key',
             'doom_type': 80,
             'episode': 1,
             'map': 4},
    370207: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Guard Tower (E1M4) - Green key',
             'doom_type': 73,
             'episode': 1,
             'map': 4},
    370208: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (E1M5) - Green key',
             'doom_type': 73,
             'episode': 1,
             'map': 5},
    370209: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (E1M5) - Yellow key',
             'doom_type': 80,
             'episode': 1,
             'map': 5},
    370210: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (E1M5) - Blue key',
             'doom_type': 79,
             'episode': 1,
             'map': 5},
    370211: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Cathedral (E1M6) - Yellow key',
             'doom_type': 80,
             'episode': 1,
             'map': 6},
    370212: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Cathedral (E1M6) - Green key',
             'doom_type': 73,
             'episode': 1,
             'map': 6},
    370213: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crypts (E1M7) - Yellow key',
             'doom_type': 80,
             'episode': 1,
             'map': 7},
    370214: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crypts (E1M7) - Green key',
             'doom_type': 73,
             'episode': 1,
             'map': 7},
    370215: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crypts (E1M7) - Blue key',
             'doom_type': 79,
             'episode': 1,
             'map': 7},
    370216: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Graveyard (E1M9) - Yellow key',
             'doom_type': 80,
             'episode': 1,
             'map': 9},
    370217: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Graveyard (E1M9) - Green key',
             'doom_type': 73,
             'episode': 1,
             'map': 9},
    370218: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Graveyard (E1M9) - Blue key',
             'doom_type': 79,
             'episode': 1,
             'map': 9},
    370219: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crater (E2M1) - Yellow key',
             'doom_type': 80,
             'episode': 2,
             'map': 1},
    370220: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crater (E2M1) - Green key',
             'doom_type': 73,
             'episode': 2,
             'map': 1},
    370221: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Lava Pits (E2M2) - Green key',
             'doom_type': 73,
             'episode': 2,
             'map': 2},
    370222: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Lava Pits (E2M2) - Yellow key',
             'doom_type': 80,
             'episode': 2,
             'map': 2},
    370223: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The River of Fire (E2M3) - Yellow key',
             'doom_type': 80,
             'episode': 2,
             'map': 3},
    370224: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The River of Fire (E2M3) - Blue key',
             'doom_type': 79,
             'episode': 2,
             'map': 3},
    370225: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The River of Fire (E2M3) - Green key',
             'doom_type': 73,
             'episode': 2,
             'map': 3},
    370226: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Ice Grotto (E2M4) - Yellow key',
             'doom_type': 80,
             'episode': 2,
             'map': 4},
    370227: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Ice Grotto (E2M4) - Blue key',
             'doom_type': 79,
             'episode': 2,
             'map': 4},
    370228: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Ice Grotto (E2M4) - Green key',
             'doom_type': 73,
             'episode': 2,
             'map': 4},
    370229: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Catacombs (E2M5) - Yellow key',
             'doom_type': 80,
             'episode': 2,
             'map': 5},
    370230: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Catacombs (E2M5) - Blue key',
             'doom_type': 79,
             'episode': 2,
             'map': 5},
    370231: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Catacombs (E2M5) - Green key',
             'doom_type': 73,
             'episode': 2,
             'map': 5},
    370232: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Labyrinth (E2M6) - Yellow key',
             'doom_type': 80,
             'episode': 2,
             'map': 6},
    370233: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Labyrinth (E2M6) - Blue key',
             'doom_type': 79,
             'episode': 2,
             'map': 6},
    370234: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Labyrinth (E2M6) - Green key',
             'doom_type': 73,
             'episode': 2,
             'map': 6},
    370235: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Great Hall (E2M7) - Green key',
             'doom_type': 73,
             'episode': 2,
             'map': 7},
    370236: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Great Hall (E2M7) - Yellow key',
             'doom_type': 80,
             'episode': 2,
             'map': 7},
    370237: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Great Hall (E2M7) - Blue key',
             'doom_type': 79,
             'episode': 2,
             'map': 7},
    370238: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Glacier (E2M9) - Yellow key',
             'doom_type': 80,
             'episode': 2,
             'map': 9},
    370239: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Glacier (E2M9) - Blue key',
             'doom_type': 79,
             'episode': 2,
             'map': 9},
    370240: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Glacier (E2M9) - Green key',
             'doom_type': 73,
             'episode': 2,
             'map': 9},
    370241: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Storehouse (E3M1) - Yellow key',
             'doom_type': 80,
             'episode': 3,
             'map': 1},
    370242: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Storehouse (E3M1) - Green key',
             'doom_type': 73,
             'episode': 3,
             'map': 1},
    370243: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Cesspool (E3M2) - Yellow key',
             'doom_type': 80,
             'episode': 3,
             'map': 2},
    370244: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Cesspool (E3M2) - Green key',
             'doom_type': 73,
             'episode': 3,
             'map': 2},
    370245: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Cesspool (E3M2) - Blue key',
             'doom_type': 79,
             'episode': 3,
             'map': 2},
    370246: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Confluence (E3M3) - Yellow key',
             'doom_type': 80,
             'episode': 3,
             'map': 3},
    370247: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Confluence (E3M3) - Green key',
             'doom_type': 73,
             'episode': 3,
             'map': 3},
    370248: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Confluence (E3M3) - Blue key',
             'doom_type': 79,
             'episode': 3,
             'map': 3},
    370249: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Azure Fortress (E3M4) - Yellow key',
             'doom_type': 80,
             'episode': 3,
             'map': 4},
    370250: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Azure Fortress (E3M4) - Green key',
             'doom_type': 73,
             'episode': 3,
             'map': 4},
    370251: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Ophidian Lair (E3M5) - Yellow key',
             'doom_type': 80,
             'episode': 3,
             'map': 5},
    370252: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Ophidian Lair (E3M5) - Green key',
             'doom_type': 73,
             'episode': 3,
             'map': 5},
    370253: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Halls of Fear (E3M6) - Yellow key',
             'doom_type': 80,
             'episode': 3,
             'map': 6},
    370254: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Halls of Fear (E3M6) - Green key',
             'doom_type': 73,
             'episode': 3,
             'map': 6},
    370255: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Halls of Fear (E3M6) - Blue key',
             'doom_type': 79,
             'episode': 3,
             'map': 6},
    370256: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Chasm (E3M7) - Blue key',
             'doom_type': 79,
             'episode': 3,
             'map': 7},
    370257: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Chasm (E3M7) - Green key',
             'doom_type': 73,
             'episode': 3,
             'map': 7},
    370258: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Chasm (E3M7) - Yellow key',
             'doom_type': 80,
             'episode': 3,
             'map': 7},
    370259: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Aquifer (E3M9) - Blue key',
             'doom_type': 79,
             'episode': 3,
             'map': 9},
    370260: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Aquifer (E3M9) - Green key',
             'doom_type': 73,
             'episode': 3,
             'map': 9},
    370261: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Aquifer (E3M9) - Yellow key',
             'doom_type': 80,
             'episode': 3,
             'map': 9},
    370262: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Catafalque (E4M1) - Yellow key',
             'doom_type': 80,
             'episode': 4,
             'map': 1},
    370263: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Catafalque (E4M1) - Green key',
             'doom_type': 73,
             'episode': 4,
             'map': 1},
    370264: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Blockhouse (E4M2) - Green key',
             'doom_type': 73,
             'episode': 4,
             'map': 2},
    370265: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Blockhouse (E4M2) - Yellow key',
             'doom_type': 80,
             'episode': 4,
             'map': 2},
    370266: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Blockhouse (E4M2) - Blue key',
             'doom_type': 79,
             'episode': 4,
             'map': 2},
    370267: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ambulatory (E4M3) - Yellow key',
             'doom_type': 80,
             'episode': 4,
             'map': 3},
    370268: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ambulatory (E4M3) - Green key',
             'doom_type': 73,
             'episode': 4,
             'map': 3},
    370269: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ambulatory (E4M3) - Blue key',
             'doom_type': 79,
             'episode': 4,
             'map': 3},
    370270: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Great Stair (E4M5) - Yellow key',
             'doom_type': 80,
             'episode': 4,
             'map': 5},
    370271: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Great Stair (E4M5) - Green key',
             'doom_type': 73,
             'episode': 4,
             'map': 5},
    370272: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Great Stair (E4M5) - Blue key',
             'doom_type': 79,
             'episode': 4,
             'map': 5},
    370273: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Halls of the Apostate (E4M6) - Green key',
             'doom_type': 73,
             'episode': 4,
             'map': 6},
    370274: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Halls of the Apostate (E4M6) - Blue key',
             'doom_type': 79,
             'episode': 4,
             'map': 6},
    370275: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Halls of the Apostate (E4M6) - Yellow key',
             'doom_type': 80,
             'episode': 4,
             'map': 6},
    370276: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ramparts of Perdition (E4M7) - Yellow key',
             'doom_type': 80,
             'episode': 4,
             'map': 7},
    370277: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ramparts of Perdition (E4M7) - Green key',
             'doom_type': 73,
             'episode': 4,
             'map': 7},
    370278: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ramparts of Perdition (E4M7) - Blue key',
             'doom_type': 79,
             'episode': 4,
             'map': 7},
    370279: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Shattered Bridge (E4M8) - Yellow key',
             'doom_type': 80,
             'episode': 4,
             'map': 8},
    370280: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Mausoleum (E4M9) - Yellow key',
             'doom_type': 80,
             'episode': 4,
             'map': 9},
    370281: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ochre Cliffs (E5M1) - Yellow key',
             'doom_type': 80,
             'episode': 5,
             'map': 1},
    370282: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ochre Cliffs (E5M1) - Blue key',
             'doom_type': 79,
             'episode': 5,
             'map': 1},
    370283: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ochre Cliffs (E5M1) - Green key',
             'doom_type': 73,
             'episode': 5,
             'map': 1},
    370284: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Rapids (E5M2) - Green key',
             'doom_type': 73,
             'episode': 5,
             'map': 2},
    370285: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Rapids (E5M2) - Yellow key',
             'doom_type': 80,
             'episode': 5,
             'map': 2},
    370286: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Quay (E5M3) - Green key',
             'doom_type': 73,
             'episode': 5,
             'map': 3},
    370287: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Quay (E5M3) - Blue key',
             'doom_type': 79,
             'episode': 5,
             'map': 3},
    370288: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Quay (E5M3) - Yellow key',
             'doom_type': 80,
             'episode': 5,
             'map': 3},
    370289: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Courtyard (E5M4) - Blue key',
             'doom_type': 79,
             'episode': 5,
             'map': 4},
    370290: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Courtyard (E5M4) - Yellow key',
             'doom_type': 80,
             'episode': 5,
             'map': 4},
    370291: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Courtyard (E5M4) - Green key',
             'doom_type': 73,
             'episode': 5,
             'map': 4},
    370292: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Hydratyr (E5M5) - Yellow key',
             'doom_type': 80,
             'episode': 5,
             'map': 5},
    370293: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Hydratyr (E5M5) - Green key',
             'doom_type': 73,
             'episode': 5,
             'map': 5},
    370294: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Hydratyr (E5M5) - Blue key',
             'doom_type': 79,
             'episode': 5,
             'map': 5},
    370295: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Colonnade (E5M6) - Yellow key',
             'doom_type': 80,
             'episode': 5,
             'map': 6},
    370296: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Colonnade (E5M6) - Green key',
             'doom_type': 73,
             'episode': 5,
             'map': 6},
    370297: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Colonnade (E5M6) - Blue key',
             'doom_type': 79,
             'episode': 5,
             'map': 6},
    370298: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Foetid Manse (E5M7) - Blue key',
             'doom_type': 79,
             'episode': 5,
             'map': 7},
    370299: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Foetid Manse (E5M7) - Green key',
             'doom_type': 73,
             'episode': 5,
             'map': 7},
    370300: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Foetid Manse (E5M7) - Yellow key',
             'doom_type': 80,
             'episode': 5,
             'map': 7},
    370301: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Skein of D'Sparil (E5M9) - Blue key",
             'doom_type': 79,
             'episode': 5,
             'map': 9},
    370302: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Skein of D'Sparil (E5M9) - Green key",
             'doom_type': 73,
             'episode': 5,
             'map': 9},
    370303: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Skein of D'Sparil (E5M9) - Yellow key",
             'doom_type': 80,
             'episode': 5,
             'map': 9},
    370400: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Docks (E1M1)',
             'doom_type': -1,
             'episode': 1,
             'map': 1},
    370401: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Docks (E1M1) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 1},
    370402: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Docks (E1M1) - Map Scroll',
             'doom_type': 35,
             'episode': 1,
             'map': 1},
    370403: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Dungeons (E1M2)',
             'doom_type': -1,
             'episode': 1,
             'map': 2},
    370404: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Dungeons (E1M2) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 2},
    370405: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Dungeons (E1M2) - Map Scroll',
             'doom_type': 35,
             'episode': 1,
             'map': 2},
    370406: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Gatehouse (E1M3)',
             'doom_type': -1,
             'episode': 1,
             'map': 3},
    370407: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Gatehouse (E1M3) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 3},
    370408: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Gatehouse (E1M3) - Map Scroll',
             'doom_type': 35,
             'episode': 1,
             'map': 3},
    370409: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Guard Tower (E1M4)',
             'doom_type': -1,
             'episode': 1,
             'map': 4},
    370410: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Guard Tower (E1M4) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 4},
    370411: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Guard Tower (E1M4) - Map Scroll',
             'doom_type': 35,
             'episode': 1,
             'map': 4},
    370412: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (E1M5)',
             'doom_type': -1,
             'episode': 1,
             'map': 5},
    370413: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (E1M5) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 5},
    370414: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Citadel (E1M5) - Map Scroll',
             'doom_type': 35,
             'episode': 1,
             'map': 5},
    370415: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Cathedral (E1M6)',
             'doom_type': -1,
             'episode': 1,
             'map': 6},
    370416: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Cathedral (E1M6) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 6},
    370417: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Cathedral (E1M6) - Map Scroll',
             'doom_type': 35,
             'episode': 1,
             'map': 6},
    370418: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crypts (E1M7)',
             'doom_type': -1,
             'episode': 1,
             'map': 7},
    370419: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crypts (E1M7) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 7},
    370420: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Crypts (E1M7) - Map Scroll',
             'doom_type': 35,
             'episode': 1,
             'map': 7},
    370421: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Hell's Maw (E1M8)",
             'doom_type': -1,
             'episode': 1,
             'map': 8},
    370422: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Hell's Maw (E1M8) - Complete",
             'doom_type': -2,
             'episode': 1,
             'map': 8},
    370423: {'classification': ItemClassification.filler,
             'count': 1,
             'name': "Hell's Maw (E1M8) - Map Scroll",
             'doom_type': 35,
             'episode': 1,
             'map': 8},
    370424: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Graveyard (E1M9)',
             'doom_type': -1,
             'episode': 1,
             'map': 9},
    370425: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Graveyard (E1M9) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 9},
    370426: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Graveyard (E1M9) - Map Scroll',
             'doom_type': 35,
             'episode': 1,
             'map': 9},
    370427: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crater (E2M1)',
             'doom_type': -1,
             'episode': 2,
             'map': 1},
    370428: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crater (E2M1) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 1},
    370429: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Crater (E2M1) - Map Scroll',
             'doom_type': 35,
             'episode': 2,
             'map': 1},
    370430: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Lava Pits (E2M2)',
             'doom_type': -1,
             'episode': 2,
             'map': 2},
    370431: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Lava Pits (E2M2) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 2},
    370432: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Lava Pits (E2M2) - Map Scroll',
             'doom_type': 35,
             'episode': 2,
             'map': 2},
    370433: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The River of Fire (E2M3)',
             'doom_type': -1,
             'episode': 2,
             'map': 3},
    370434: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The River of Fire (E2M3) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 3},
    370435: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The River of Fire (E2M3) - Map Scroll',
             'doom_type': 35,
             'episode': 2,
             'map': 3},
    370436: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Ice Grotto (E2M4)',
             'doom_type': -1,
             'episode': 2,
             'map': 4},
    370437: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Ice Grotto (E2M4) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 4},
    370438: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Ice Grotto (E2M4) - Map Scroll',
             'doom_type': 35,
             'episode': 2,
             'map': 4},
    370439: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Catacombs (E2M5)',
             'doom_type': -1,
             'episode': 2,
             'map': 5},
    370440: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Catacombs (E2M5) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 5},
    370441: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Catacombs (E2M5) - Map Scroll',
             'doom_type': 35,
             'episode': 2,
             'map': 5},
    370442: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Labyrinth (E2M6)',
             'doom_type': -1,
             'episode': 2,
             'map': 6},
    370443: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Labyrinth (E2M6) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 6},
    370444: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Labyrinth (E2M6) - Map Scroll',
             'doom_type': 35,
             'episode': 2,
             'map': 6},
    370445: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Great Hall (E2M7)',
             'doom_type': -1,
             'episode': 2,
             'map': 7},
    370446: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Great Hall (E2M7) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 7},
    370447: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Great Hall (E2M7) - Map Scroll',
             'doom_type': 35,
             'episode': 2,
             'map': 7},
    370448: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Portals of Chaos (E2M8)',
             'doom_type': -1,
             'episode': 2,
             'map': 8},
    370449: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Portals of Chaos (E2M8) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 8},
    370450: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Portals of Chaos (E2M8) - Map Scroll',
             'doom_type': 35,
             'episode': 2,
             'map': 8},
    370451: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Glacier (E2M9)',
             'doom_type': -1,
             'episode': 2,
             'map': 9},
    370452: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Glacier (E2M9) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 9},
    370453: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Glacier (E2M9) - Map Scroll',
             'doom_type': 35,
             'episode': 2,
             'map': 9},
    370454: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Storehouse (E3M1)',
             'doom_type': -1,
             'episode': 3,
             'map': 1},
    370455: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Storehouse (E3M1) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 1},
    370456: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Storehouse (E3M1) - Map Scroll',
             'doom_type': 35,
             'episode': 3,
             'map': 1},
    370457: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Cesspool (E3M2)',
             'doom_type': -1,
             'episode': 3,
             'map': 2},
    370458: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Cesspool (E3M2) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 2},
    370459: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Cesspool (E3M2) - Map Scroll',
             'doom_type': 35,
             'episode': 3,
             'map': 2},
    370460: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Confluence (E3M3)',
             'doom_type': -1,
             'episode': 3,
             'map': 3},
    370461: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Confluence (E3M3) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 3},
    370462: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Confluence (E3M3) - Map Scroll',
             'doom_type': 35,
             'episode': 3,
             'map': 3},
    370463: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Azure Fortress (E3M4)',
             'doom_type': -1,
             'episode': 3,
             'map': 4},
    370464: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Azure Fortress (E3M4) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 4},
    370465: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Azure Fortress (E3M4) - Map Scroll',
             'doom_type': 35,
             'episode': 3,
             'map': 4},
    370466: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Ophidian Lair (E3M5)',
             'doom_type': -1,
             'episode': 3,
             'map': 5},
    370467: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Ophidian Lair (E3M5) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 5},
    370468: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Ophidian Lair (E3M5) - Map Scroll',
             'doom_type': 35,
             'episode': 3,
             'map': 5},
    370469: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Halls of Fear (E3M6)',
             'doom_type': -1,
             'episode': 3,
             'map': 6},
    370470: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Halls of Fear (E3M6) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 6},
    370471: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Halls of Fear (E3M6) - Map Scroll',
             'doom_type': 35,
             'episode': 3,
             'map': 6},
    370472: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Chasm (E3M7)',
             'doom_type': -1,
             'episode': 3,
             'map': 7},
    370473: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Chasm (E3M7) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 7},
    370474: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Chasm (E3M7) - Map Scroll',
             'doom_type': 35,
             'episode': 3,
             'map': 7},
    370475: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "D'Sparil's Keep (E3M8)",
             'doom_type': -1,
             'episode': 3,
             'map': 8},
    370476: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "D'Sparil's Keep (E3M8) - Complete",
             'doom_type': -2,
             'episode': 3,
             'map': 8},
    370477: {'classification': ItemClassification.filler,
             'count': 1,
             'name': "D'Sparil's Keep (E3M8) - Map Scroll",
             'doom_type': 35,
             'episode': 3,
             'map': 8},
    370478: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Aquifer (E3M9)',
             'doom_type': -1,
             'episode': 3,
             'map': 9},
    370479: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Aquifer (E3M9) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 9},
    370480: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Aquifer (E3M9) - Map Scroll',
             'doom_type': 35,
             'episode': 3,
             'map': 9},
    370481: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Catafalque (E4M1)',
             'doom_type': -1,
             'episode': 4,
             'map': 1},
    370482: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Catafalque (E4M1) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 1},
    370483: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Catafalque (E4M1) - Map Scroll',
             'doom_type': 35,
             'episode': 4,
             'map': 1},
    370484: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Blockhouse (E4M2)',
             'doom_type': -1,
             'episode': 4,
             'map': 2},
    370485: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Blockhouse (E4M2) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 2},
    370486: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Blockhouse (E4M2) - Map Scroll',
             'doom_type': 35,
             'episode': 4,
             'map': 2},
    370487: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ambulatory (E4M3)',
             'doom_type': -1,
             'episode': 4,
             'map': 3},
    370488: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ambulatory (E4M3) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 3},
    370489: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Ambulatory (E4M3) - Map Scroll',
             'doom_type': 35,
             'episode': 4,
             'map': 3},
    370490: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Sepulcher (E4M4)',
             'doom_type': -1,
             'episode': 4,
             'map': 4},
    370491: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Sepulcher (E4M4) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 4},
    370492: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Sepulcher (E4M4) - Map Scroll',
             'doom_type': 35,
             'episode': 4,
             'map': 4},
    370493: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Great Stair (E4M5)',
             'doom_type': -1,
             'episode': 4,
             'map': 5},
    370494: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Great Stair (E4M5) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 5},
    370495: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Great Stair (E4M5) - Map Scroll',
             'doom_type': 35,
             'episode': 4,
             'map': 5},
    370496: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Halls of the Apostate (E4M6)',
             'doom_type': -1,
             'episode': 4,
             'map': 6},
    370497: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Halls of the Apostate (E4M6) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 6},
    370498: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Halls of the Apostate (E4M6) - Map Scroll',
             'doom_type': 35,
             'episode': 4,
             'map': 6},
    370499: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ramparts of Perdition (E4M7)',
             'doom_type': -1,
             'episode': 4,
             'map': 7},
    370500: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ramparts of Perdition (E4M7) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 7},
    370501: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Ramparts of Perdition (E4M7) - Map Scroll',
             'doom_type': 35,
             'episode': 4,
             'map': 7},
    370502: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Shattered Bridge (E4M8)',
             'doom_type': -1,
             'episode': 4,
             'map': 8},
    370503: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Shattered Bridge (E4M8) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 8},
    370504: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Shattered Bridge (E4M8) - Map Scroll',
             'doom_type': 35,
             'episode': 4,
             'map': 8},
    370505: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Mausoleum (E4M9)',
             'doom_type': -1,
             'episode': 4,
             'map': 9},
    370506: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Mausoleum (E4M9) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 9},
    370507: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Mausoleum (E4M9) - Map Scroll',
             'doom_type': 35,
             'episode': 4,
             'map': 9},
    370508: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ochre Cliffs (E5M1)',
             'doom_type': -1,
             'episode': 5,
             'map': 1},
    370509: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Ochre Cliffs (E5M1) - Complete',
             'doom_type': -2,
             'episode': 5,
             'map': 1},
    370510: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Ochre Cliffs (E5M1) - Map Scroll',
             'doom_type': 35,
             'episode': 5,
             'map': 1},
    370511: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Rapids (E5M2)',
             'doom_type': -1,
             'episode': 5,
             'map': 2},
    370512: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Rapids (E5M2) - Complete',
             'doom_type': -2,
             'episode': 5,
             'map': 2},
    370513: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Rapids (E5M2) - Map Scroll',
             'doom_type': 35,
             'episode': 5,
             'map': 2},
    370514: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Quay (E5M3)',
             'doom_type': -1,
             'episode': 5,
             'map': 3},
    370515: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Quay (E5M3) - Complete',
             'doom_type': -2,
             'episode': 5,
             'map': 3},
    370516: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Quay (E5M3) - Map Scroll',
             'doom_type': 35,
             'episode': 5,
             'map': 3},
    370517: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Courtyard (E5M4)',
             'doom_type': -1,
             'episode': 5,
             'map': 4},
    370518: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Courtyard (E5M4) - Complete',
             'doom_type': -2,
             'episode': 5,
             'map': 4},
    370519: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Courtyard (E5M4) - Map Scroll',
             'doom_type': 35,
             'episode': 5,
             'map': 4},
    370520: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Hydratyr (E5M5)',
             'doom_type': -1,
             'episode': 5,
             'map': 5},
    370521: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Hydratyr (E5M5) - Complete',
             'doom_type': -2,
             'episode': 5,
             'map': 5},
    370522: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Hydratyr (E5M5) - Map Scroll',
             'doom_type': 35,
             'episode': 5,
             'map': 5},
    370523: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Colonnade (E5M6)',
             'doom_type': -1,
             'episode': 5,
             'map': 6},
    370524: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Colonnade (E5M6) - Complete',
             'doom_type': -2,
             'episode': 5,
             'map': 6},
    370525: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Colonnade (E5M6) - Map Scroll',
             'doom_type': 35,
             'episode': 5,
             'map': 6},
    370526: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Foetid Manse (E5M7)',
             'doom_type': -1,
             'episode': 5,
             'map': 7},
    370527: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Foetid Manse (E5M7) - Complete',
             'doom_type': -2,
             'episode': 5,
             'map': 7},
    370528: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Foetid Manse (E5M7) - Map Scroll',
             'doom_type': 35,
             'episode': 5,
             'map': 7},
    370529: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Field of Judgement (E5M8)',
             'doom_type': -1,
             'episode': 5,
             'map': 8},
    370530: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Field of Judgement (E5M8) - Complete',
             'doom_type': -2,
             'episode': 5,
             'map': 8},
    370531: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Field of Judgement (E5M8) - Map Scroll',
             'doom_type': 35,
             'episode': 5,
             'map': 8},
    370532: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Skein of D'Sparil (E5M9)",
             'doom_type': -1,
             'episode': 5,
             'map': 9},
    370533: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Skein of D'Sparil (E5M9) - Complete",
             'doom_type': -2,
             'episode': 5,
             'map': 9},
    370534: {'classification': ItemClassification.filler,
             'count': 1,
             'name': "Skein of D'Sparil (E5M9) - Map Scroll",
             'doom_type': 35,
             'episode': 5,
             'map': 9},
    370600: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Crystal Capacity',
             'doom_type': 65001,
             'episode': -1,
             'map': -1},
    370601: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Ethereal Arrow Capacity',
             'doom_type': 65002,
             'episode': -1,
             'map': -1},
    370602: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Claw Orb Capacity',
             'doom_type': 65003,
             'episode': -1,
             'map': -1},
    370603: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Rune Capacity',
             'doom_type': 65004,
             'episode': -1,
             'map': -1},
    370604: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Flame Orb Capacity',
             'doom_type': 65005,
             'episode': -1,
             'map': -1},
    370605: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Mace Sphere Capacity',
             'doom_type': 65006,
             'episode': -1,
             'map': -1},
}


item_name_groups: Dict[str, Set[str]] = {
    'Ammos': {'Crystal Geode', 'Energy Orb', 'Greater Runes', 'Inferno Orb', 'Pile of Mace Spheres', 'Quiver of Ethereal Arrows', },
    'Armors': {'Enchanted Shield', 'Silver Shield', },
    'Artifacts': {'Chaos Device', 'Morph Ovum', 'Mystic Urn', 'Quartz Flask', 'Ring of Invincibility', 'Shadowsphere', 'Timebomb of the Ancients', 'Tome of Power', 'Torch', },
    'Keys': {'Ambulatory (E4M3) - Blue key', 'Ambulatory (E4M3) - Green key', 'Ambulatory (E4M3) - Yellow key', 'Blockhouse (E4M2) - Blue key', 'Blockhouse (E4M2) - Green key', 'Blockhouse (E4M2) - Yellow key', 'Catafalque (E4M1) - Green key', 'Catafalque (E4M1) - Yellow key', 'Colonnade (E5M6) - Blue key', 'Colonnade (E5M6) - Green key', 'Colonnade (E5M6) - Yellow key', 'Courtyard (E5M4) - Blue key', 'Courtyard (E5M4) - Green key', 'Courtyard (E5M4) - Yellow key', 'Foetid Manse (E5M7) - Blue key', 'Foetid Manse (E5M7) - Green key', 'Foetid Manse (E5M7) - Yellow key', 'Great Stair (E4M5) - Blue key', 'Great Stair (E4M5) - Green key', 'Great Stair (E4M5) - Yellow key', 'Halls of the Apostate (E4M6) - Blue key', 'Halls of the Apostate (E4M6) - Green key', 'Halls of the Apostate (E4M6) - Yellow key', 'Hydratyr (E5M5) - Blue key', 'Hydratyr (E5M5) - Green key', 'Hydratyr (E5M5) - Yellow key', 'Mausoleum (E4M9) - Yellow key', 'Ochre Cliffs (E5M1) - Blue key', 'Ochre Cliffs (E5M1) - Green key', 'Ochre Cliffs (E5M1) - Yellow key', 'Quay (E5M3) - Blue key', 'Quay (E5M3) - Green key', 'Quay (E5M3) - Yellow key', 'Ramparts of Perdition (E4M7) - Blue key', 'Ramparts of Perdition (E4M7) - Green key', 'Ramparts of Perdition (E4M7) - Yellow key', 'Rapids (E5M2) - Green key', 'Rapids (E5M2) - Yellow key', 'Shattered Bridge (E4M8) - Yellow key', "Skein of D'Sparil (E5M9) - Blue key", "Skein of D'Sparil (E5M9) - Green key", "Skein of D'Sparil (E5M9) - Yellow key", 'The Aquifer (E3M9) - Blue key', 'The Aquifer (E3M9) - Green key', 'The Aquifer (E3M9) - Yellow key', 'The Azure Fortress (E3M4) - Green key', 'The Azure Fortress (E3M4) - Yellow key', 'The Catacombs (E2M5) - Blue key', 'The Catacombs (E2M5) - Green key', 'The Catacombs (E2M5) - Yellow key', 'The Cathedral (E1M6) - Green key', 'The Cathedral (E1M6) - Yellow key', 'The Cesspool (E3M2) - Blue key', 'The Cesspool (E3M2) - Green key', 'The Cesspool (E3M2) - Yellow key', 'The Chasm (E3M7) - Blue key', 'The Chasm (E3M7) - Green key', 'The Chasm (E3M7) - Yellow key', 'The Citadel (E1M5) - Blue key', 'The Citadel (E1M5) - Green key', 'The Citadel (E1M5) - Yellow key', 'The Confluence (E3M3) - Blue key', 'The Confluence (E3M3) - Green key', 'The Confluence (E3M3) - Yellow key', 'The Crater (E2M1) - Green key', 'The Crater (E2M1) - Yellow key', 'The Crypts (E1M7) - Blue key', 'The Crypts (E1M7) - Green key', 'The Crypts (E1M7) - Yellow key', 'The Docks (E1M1) - Yellow key', 'The Dungeons (E1M2) - Blue key', 'The Dungeons (E1M2) - Green key', 'The Dungeons (E1M2) - Yellow key', 'The Gatehouse (E1M3) - Green key', 'The Gatehouse (E1M3) - Yellow key', 'The Glacier (E2M9) - Blue key', 'The Glacier (E2M9) - Green key', 'The Glacier (E2M9) - Yellow key', 'The Graveyard (E1M9) - Blue key', 'The Graveyard (E1M9) - Green key', 'The Graveyard (E1M9) - Yellow key', 'The Great Hall (E2M7) - Blue key', 'The Great Hall (E2M7) - Green key', 'The Great Hall (E2M7) - Yellow key', 'The Guard Tower (E1M4) - Green key', 'The Guard Tower (E1M4) - Yellow key', 'The Halls of Fear (E3M6) - Blue key', 'The Halls of Fear (E3M6) - Green key', 'The Halls of Fear (E3M6) - Yellow key', 'The Ice Grotto (E2M4) - Blue key', 'The Ice Grotto (E2M4) - Green key', 'The Ice Grotto (E2M4) - Yellow key', 'The Labyrinth (E2M6) - Blue key', 'The Labyrinth (E2M6) - Green key', 'The Labyrinth (E2M6) - Yellow key', 'The Lava Pits (E2M2) - Green key', 'The Lava Pits (E2M2) - Yellow key', 'The Ophidian Lair (E3M5) - Green key', 'The Ophidian Lair (E3M5) - Yellow key', 'The River of Fire (E2M3) - Blue key', 'The River of Fire (E2M3) - Green key', 'The River of Fire (E2M3) - Yellow key', 'The Storehouse (E3M1) - Green key', 'The Storehouse (E3M1) - Yellow key', },
    'Levels': {'Ambulatory (E4M3)', 'Blockhouse (E4M2)', 'Catafalque (E4M1)', 'Colonnade (E5M6)', 'Courtyard (E5M4)', "D'Sparil's Keep (E3M8)", 'Field of Judgement (E5M8)', 'Foetid Manse (E5M7)', 'Great Stair (E4M5)', 'Halls of the Apostate (E4M6)', "Hell's Maw (E1M8)", 'Hydratyr (E5M5)', 'Mausoleum (E4M9)', 'Ochre Cliffs (E5M1)', 'Quay (E5M3)', 'Ramparts of Perdition (E4M7)', 'Rapids (E5M2)', 'Sepulcher (E4M4)', 'Shattered Bridge (E4M8)', "Skein of D'Sparil (E5M9)", 'The Aquifer (E3M9)', 'The Azure Fortress (E3M4)', 'The Catacombs (E2M5)', 'The Cathedral (E1M6)', 'The Cesspool (E3M2)', 'The Chasm (E3M7)', 'The Citadel (E1M5)', 'The Confluence (E3M3)', 'The Crater (E2M1)', 'The Crypts (E1M7)', 'The Docks (E1M1)', 'The Dungeons (E1M2)', 'The Gatehouse (E1M3)', 'The Glacier (E2M9)', 'The Graveyard (E1M9)', 'The Great Hall (E2M7)', 'The Guard Tower (E1M4)', 'The Halls of Fear (E3M6)', 'The Ice Grotto (E2M4)', 'The Labyrinth (E2M6)', 'The Lava Pits (E2M2)', 'The Ophidian Lair (E3M5)', 'The Portals of Chaos (E2M8)', 'The River of Fire (E2M3)', 'The Storehouse (E3M1)', },
    'Map Scrolls': {'Ambulatory (E4M3) - Map Scroll', 'Blockhouse (E4M2) - Map Scroll', 'Catafalque (E4M1) - Map Scroll', 'Colonnade (E5M6) - Map Scroll', 'Courtyard (E5M4) - Map Scroll', "D'Sparil's Keep (E3M8) - Map Scroll", 'Field of Judgement (E5M8) - Map Scroll', 'Foetid Manse (E5M7) - Map Scroll', 'Great Stair (E4M5) - Map Scroll', 'Halls of the Apostate (E4M6) - Map Scroll', "Hell's Maw (E1M8) - Map Scroll", 'Hydratyr (E5M5) - Map Scroll', 'Mausoleum (E4M9) - Map Scroll', 'Ochre Cliffs (E5M1) - Map Scroll', 'Quay (E5M3) - Map Scroll', 'Ramparts of Perdition (E4M7) - Map Scroll', 'Rapids (E5M2) - Map Scroll', 'Sepulcher (E4M4) - Map Scroll', 'Shattered Bridge (E4M8) - Map Scroll', "Skein of D'Sparil (E5M9) - Map Scroll", 'The Aquifer (E3M9) - Map Scroll', 'The Azure Fortress (E3M4) - Map Scroll', 'The Catacombs (E2M5) - Map Scroll', 'The Cathedral (E1M6) - Map Scroll', 'The Cesspool (E3M2) - Map Scroll', 'The Chasm (E3M7) - Map Scroll', 'The Citadel (E1M5) - Map Scroll', 'The Confluence (E3M3) - Map Scroll', 'The Crater (E2M1) - Map Scroll', 'The Crypts (E1M7) - Map Scroll', 'The Docks (E1M1) - Map Scroll', 'The Dungeons (E1M2) - Map Scroll', 'The Gatehouse (E1M3) - Map Scroll', 'The Glacier (E2M9) - Map Scroll', 'The Graveyard (E1M9) - Map Scroll', 'The Great Hall (E2M7) - Map Scroll', 'The Guard Tower (E1M4) - Map Scroll', 'The Halls of Fear (E3M6) - Map Scroll', 'The Ice Grotto (E2M4) - Map Scroll', 'The Labyrinth (E2M6) - Map Scroll', 'The Lava Pits (E2M2) - Map Scroll', 'The Ophidian Lair (E3M5) - Map Scroll', 'The Portals of Chaos (E2M8) - Map Scroll', 'The River of Fire (E2M3) - Map Scroll', 'The Storehouse (E3M1) - Map Scroll', },
    'Weapons': {'Dragon Claw', 'Ethereal Crossbow', 'Firemace', 'Gauntlets of the Necromancer', 'Hellstaff', 'Phoenix Rod', },
}
