# Custom mapping dictionary for transliteration across multiple languages
transliteration_map = {
    # Cyrillic (Russian, Ukrainian, Bulgarian, etc.)
    'А': 'A', 'а': 'a', 'Б': 'B', 'б': 'b', 'В': 'V', 'в': 'v', 'Г': 'G', 'г': 'g',
    'Д': 'D', 'д': 'd', 'Е': 'E', 'е': 'e', 'Ё': 'Yo', 'ё': 'yo', 'Ж': 'Zh', 'ж': 'zh',
    'З': 'Z', 'з': 'z', 'И': 'I', 'и': 'i', 'Й': 'Y', 'й': 'y', 'К': 'K', 'к': 'k',
    'Л': 'L', 'л': 'l', 'М': 'M', 'м': 'm', 'Н': 'N', 'н': 'n', 'О': 'O', 'о': 'o',
    'П': 'P', 'п': 'p', 'Р': 'R', 'р': 'r', 'С': 'S', 'с': 's', 'Т': 'T', 'т': 't',
    'У': 'U', 'у': 'u', 'Ф': 'F', 'ф': 'f', 'Х': 'Kh', 'х': 'kh', 'Ц': 'Ts', 'ц': 'ts',
    'Ч': 'Ch', 'ч': 'ch', 'Ш': 'Sh', 'ш': 'sh', 'Щ': 'Shch', 'щ': 'shch', 'Ъ': '', 'ъ': '',
    'Ы': 'Y', 'ы': 'y', 'Ь': '', 'ь': '', 'Э': 'E', 'э': 'e', 'Ю': 'Yu', 'ю': 'yu', 'Я': 'Ya', 'я': 'ya',

    # Greek
    'Α': 'A', 'α': 'a', 'Β': 'B', 'β': 'b', 'Γ': 'G', 'γ': 'g', 'Δ': 'D', 'δ': 'd',
    'Ε': 'E', 'ε': 'e', 'Ζ': 'Z', 'ζ': 'z', 'Η': 'E', 'η': 'e', 'Θ': 'Th', 'θ': 'th',
    'Ι': 'I', 'ι': 'i', 'Κ': 'K', 'κ': 'k', 'Λ': 'L', 'λ': 'l', 'Μ': 'M', 'μ': 'm',
    'Ν': 'N', 'ν': 'n', 'Ξ': 'X', 'ξ': 'x', 'Ο': 'O', 'ο': 'o', 'Π': 'P', 'π': 'p',
    'Ρ': 'R', 'ρ': 'r', 'Σ': 'S', 'σ': 's', 'ς': 's', 'Τ': 'T', 'τ': 't', 'Υ': 'Y', 'υ': 'y',
    'Φ': 'Ph', 'φ': 'ph', 'Χ': 'Ch', 'χ': 'ch', 'Ψ': 'Ps', 'ψ': 'ps', 'Ω': 'O', 'ω': 'o',

    # Hebrew
    'א': '', 'ב': 'b', 'ג': 'g', 'ד': 'd', 'ה': 'h', 'ו': 'v', 'ז': 'z', 'ח': 'kh', 'ט': 't',
    'י': 'y', 'כ': 'k', 'ך': 'k', 'ל': 'l', 'מ': 'm', 'ם': 'm', 'נ': 'n', 'ן': 'n', 'ס': 's',
    'ע': "'", 'פ': 'p', 'ף': 'p', 'צ': 'ts', 'ץ': 'ts', 'ק': 'q', 'ר': 'r', 'ש': 'sh', 'ת': 't',

    # Chinese symbols and characters
    '彡': 'shan', '人': 'ren', '日': 'ri', '月': 'yue', '火': 'huo', '水': 'shui', '木': 'mu', '金': 'jin', '土': 'tu',
    '天': 'tian', '地': 'di', '王': 'wang', '子': 'zi', '女': 'nv', '男': 'nan', '山': 'shan', '川': 'chuan',
    '海': 'hai', '湖': 'hu', '河': 'he', '林': 'lin', '江': 'jiang', '城': 'cheng', '寺': 'si', '门': 'men',
    '桥': 'qiao', '楼': 'lou', '宫': 'gong', '台': 'tai', '阁': 'ge', '云': 'yun', '雨': 'yu', '风': 'feng',
    '雪': 'xue', '星': 'xing', '太阳': 'taiyang', '月亮': 'yueliang'
}


def transliterate(text):
    return ''.join(transliteration_map.get(char, char) for char in text)
