from .Items import SongData
from typing import Dict


SONG_DATA: Dict[str, SongData] = {
    "Love is War [1]": SongData(10, 1, {'Hatsune Miku'}, False, False, [2.0, 4.0, 6.0, 8.0, 8.5]),
    "The World is Mine [2]": SongData(20, 2, {'Hatsune Miku'}, False, False, [4.0, 5.5, 6.0, 7.5, 8.0]),
    "That One Second in Slow Motion [3]": SongData(30, 3, {'Hatsune Miku'}, True, False, [4.0, 5.0, 6.5, 7.0, 7.5]),
    "Jaded [4]": SongData(40, 4, {'Hatsune Miku'}, True, False, [1.0, 0.0, 4.0, 7.5, 0.0]),
    "Melt [5]": SongData(50, 5, {'Hatsune Miku'}, False, False, [3.0, 5.0, 6.0, 7.0, 8.0]),
    "Far Away [6]": SongData(60, 6, {'Hatsune Miku'}, True, False, [2.0, 0.0, 4.5, 6.0, 6.0]),
    "Strobo Nights [7]": SongData(70, 7, {'Hatsune Miku'}, False, False, [2.0, 0.0, 5.0, 7.5, 8.0]),
    "Star Story [8]": SongData(80, 8, {'Hatsune Miku'}, False, False, [1.5, 3.0, 4.0, 7.0, 7.0]),
    "Last Night, Good Night [9]": SongData(90, 9, {'Hatsune Miku'}, False, False, [2.0, 0.0, 5.5, 6.5, 0.0]),
    "Packaged [10]": SongData(100, 10, {'Hatsune Miku'}, False, False, [2.0, 0.0, 4.5, 7.0, 7.5]),
    "Rain With A Chance of Sweet*Drops [11]": SongData(110, 11, {'Hatsune Miku'}, True, False, [3.0, 5.0, 6.0, 7.0, 8.0]),
    "Marginal [12]": SongData(120, 12, {'Hatsune Miku'}, False, False, [0.0, 5.5, 6.0, 8.0, 9.0]),
    "Grumpy Waltz [13]": SongData(130, 13, {'Hatsune Miku'}, False, False, [0.0, 5.0, 7.0, 9.5, 9.5]),
    "Miracle Paint [14]": SongData(140, 14, {'Hatsune Miku'}, False, False, [0.0, 4.5, 6.5, 8.5, 8.5]),
    "Dreaming Leaf [15]": SongData(150, 15, {'Hatsune Miku'}, True, False, [0.0, 5.5, 6.5, 8.0, 8.0]),
    "VOC@LOID in Love [16]": SongData(160, 16, {'Hatsune Miku'}, False, False, [2.5, 0.0, 5.0, 7.0, 8.5]),
    "A Song of Wastelands, Forests, and Magic [17]": SongData(170, 17, {'Hatsune Miku', 'Kagamine Rin', 'Kagamine Len'}, True, False, [0.0, 4.0, 5.0, 6.5, 7.5]),
    "Song of Life [18]": SongData(180, 18, {'Hatsune Miku', 'Kagamine Rin', 'Kagamine Len'}, True, False, [1.5, 0.0, 5.0, 6.0, 0.0]),
    "moon [20]": SongData(200, 20, {'Hatsune Miku'}, True, False, [2.0, 4.0, 5.5, 7.0, 8.5]),
    "Beware of the Miku Miku Germs [21]": SongData(210, 21, {'Hatsune Miku'}, True, False, [0.0, 5.5, 6.5, 8.0, 0.0]),
    "The secret garden [22]": SongData(220, 22, {'Hatsune Miku'}, False, False, [2.0, 4.0, 5.0, 6.0, 0.0]),
    "Dear cocoa girls [23]": SongData(230, 23, {'Hatsune Miku'}, True, False, [3.5, 4.0, 5.0, 6.5, 7.5]),
    "Velvet Arabesque [24]": SongData(240, 24, {'Hatsune Miku'}, True, False, [1.5, 3.0, 4.5, 6.5, 6.5]),
    "Updating My Love List? [25]": SongData(250, 25, {'Hatsune Miku'}, True, False, [3.0, 4.5, 6.0, 7.0, 0.0]),
    "I'll Miku-Miku You (For Reals) [28]": SongData(280, 28, {'Hatsune Miku'}, False, False, [3.0, 5.0, 6.0, 7.0, 8.0]),
    "Requiem for the Phantasma [29]": SongData(290, 29, {'Hatsune Miku'}, True, False, [0.0, 5.5, 7.5, 8.5, 9.5]),
    "Electric Angel [30]": SongData(300, 30, {'Hatsune Miku'}, False, False, [1.5, 3.5, 5.5, 7.0, 8.5]),
    "I'm Your Diva [31]": SongData(310, 31, {'Hatsune Miku'}, False, False, [0.0, 4.0, 5.5, 7.0, 7.5]),
    "The Disappearance of Hatsune Miku [32]": SongData(320, 32, {'Hatsune Miku'}, False, False, [0.0, 6.5, 7.0, 9.0, 10.0]),
    "When First Love Ends [37]": SongData(370, 37, {'Hatsune Miku'}, False, False, [4.0, 5.0, 6.0, 7.0, 7.5]),
    "Look This Way, Baby [38]": SongData(380, 38, {'Hatsune Miku'}, False, False, [4.0, 5.5, 6.0, 8.5, 8.5]),
    "Finder (DSLR remix - re:edit) [39]": SongData(390, 39, {'Hatsune Miku'}, False, False, [2.0, 4.0, 5.0, 7.0, 7.5]),
    "Yellow [40]": SongData(400, 40, {'Hatsune Miku'}, False, False, [2.0, 4.0, 5.0, 6.0, 7.5]),
    "Colorful x Melody [41]": SongData(410, 41, {'Hatsune Miku', 'Kagamine Rin'}, False, False, [3.5, 5.0, 6.0, 8.0, 8.0]),
    "The Intense Voice of Hatsune Miku [42]": SongData(420, 42, {'Hatsune Miku'}, False, False, [3.0, 6.0, 8.0, 10.0, 10.0]),
    "Romeo and Cinderella [43]": SongData(430, 43, {'Hatsune Miku'}, False, False, [4.0, 5.0, 6.0, 9.0, 8.5]),
    "Magnet [44]": SongData(440, 44, {'Hatsune Miku', 'Megurine Luka'}, False, False, [4.5, 5.5, 6.5, 8.0, 8.5]),
    "Dear [45]": SongData(450, 45, {'Hatsune Miku'}, False, False, [3.5, 4.5, 5.5, 7.5, 7.5]),
    "from Y to Y [46]": SongData(460, 46, {'Hatsune Miku'}, False, False, [3.0, 4.0, 5.5, 7.0, 7.5]),
    "Gemini [47]": SongData(470, 47, {'Kagamine Rin', 'Kagamine Len'}, False, False, [3.0, 4.5, 5.5, 7.5, 0.0]),
    "Aikotoba [48]": SongData(480, 48, {'Hatsune Miku'}, False, False, [1.0, 3.0, 5.0, 7.0, 8.5]),
    "Po Pi Po [49]": SongData(490, 49, {'Hatsune Miku'}, False, False, [2.0, 5.5, 7.5, 9.5, 10.0]),
    "Saihate [50]": SongData(500, 50, {'Hatsune Miku'}, False, False, [2.0, 4.0, 6.0, 9.5, 9.0]),
    "VOiCE -DIVA MIX- [51]": SongData(510, 51, {'Hatsune Miku'}, False, False, [2.0, 4.0, 5.0, 8.0, 8.5]),
    "Love-Colored Ward [52]": SongData(520, 52, {'Hatsune Miku'}, False, False, [4.0, 5.0, 6.0, 9.0, 9.0]),
    "Gigantic Girl [53]": SongData(530, 53, {'Hatsune Miku'}, False, False, [3.0, 4.0, 5.0, 7.0, 7.5]),
    "Roshin Yukai [54]": SongData(540, 54, {'Kagamine Rin'}, False, False, [3.0, 4.0, 5.0, 8.0, 7.5]),
    "Kokoro [55]": SongData(550, 55, {'Kagamine Rin'}, False, False, [2.0, 3.0, 4.0, 7.0, 8.0]),
    "Butterfly on Your Right Shoulder [56]": SongData(560, 56, {'Kagamine Len'}, False, False, [2.5, 4.5, 6.5, 8.0, 0.0]),
    "Double Lariat [57]": SongData(570, 57, {'Megurine Luka'}, False, False, [3.0, 4.5, 6.0, 7.0, 8.0]),
    "Cantarella [58]": SongData(580, 58, {'Hatsune Miku', 'KAITO'}, False, False, [3.0, 4.0, 5.5, 7.0, 8.5]),
    "Change Me [59]": SongData(590, 59, {'MEIKO'}, False, False, [3.0, 4.0, 5.0, 7.0, 7.5]),
    "Sound [60]": SongData(600, 60, {'Hatsune Miku'}, False, False, [3.5, 5.0, 6.0, 8.0, 8.5]),
    "Clover Club [61]": SongData(610, 61, {'Hatsune Miku'}, False, False, [2.0, 4.0, 5.0, 7.0, 7.5]),
    "Promise [62]": SongData(620, 62, {'Hatsune Miku', 'Kagamine Rin'}, False, False, [3.5, 4.5, 6.0, 8.0, 8.0]),
    "I Really Do Understand [63]": SongData(630, 63, {'Hatsune Miku'}, True, False, [3.5, 4.0, 5.5, 7.0, 8.0]),
    "Innocence [64]": SongData(640, 64, {'Hatsune Miku'}, True, False, [2.0, 4.0, 5.0, 6.0, 7.5]),
    "The First Sound [65]": SongData(650, 65, {'Hatsune Miku'}, False, False, [3.0, 4.0, 5.0, 7.0, 7.5]),
    "Just Be Friends [66]": SongData(660, 66, {'Megurine Luka'}, False, False, [2.0, 5.0, 6.0, 8.0, 8.0]),
    "SPiCa -39's Giving Day Edition- [79]": SongData(790, 79, {'Hatsune Miku'}, False, False, [3.5, 5.0, 6.5, 8.0, 0.0]),
    "Though My Song Has No Form [81]": SongData(810, 81, {'Hatsune Miku'}, False, False, [3.0, 4.0, 5.0, 7.0, 7.5]),
    "Two-Sided Lovers [82]": SongData(820, 82, {'Hatsune Miku'}, False, False, [0.0, 4.0, 7.0, 10.0, 10.0]),
    "*Hello, Planet. [83]": SongData(830, 83, {'Hatsune Miku'}, False, False, [3.0, 4.0, 6.5, 8.0, 0.0]),
    "To the End of Infinity [84]": SongData(840, 84, {'Kagamine Rin', 'Kagamine Len'}, True, False, [0.0, 4.5, 6.0, 7.0, 8.0]),
    "Solitude's End -extend edition- [85]": SongData(850, 85, {'Kagamine Rin', 'Kagamine Len'}, False, False, [0.0, 5.0, 6.0, 9.0, 9.5]),
    "Puzzle [86]": SongData(860, 86, {'Hatsune Miku'}, False, False, [1.5, 4.0, 5.0, 6.5, 8.5]),
    "Palette [87]": SongData(870, 87, {'Megurine Luka'}, False, False, [0.0, 5.0, 6.0, 7.0, 8.0]),
    "Thousand Year Solo (DIVA Edit) [88]": SongData(880, 88, {'KAITO'}, False, False, [2.0, 4.0, 5.0, 7.0, 8.0]),
    "Lover's Suicide Oblivion [89]": SongData(890, 89, {'MEIKO'}, False, False, [0.0, 4.0, 6.0, 8.0, 8.0]),
    "Close and Open, Demons and The Dead [90]": SongData(900, 90, {'Hatsune Miku'}, False, False, [0.0, 4.0, 6.5, 8.0, 9.0]),
    "Rolling Girl [91]": SongData(910, 91, {'Hatsune Miku'}, False, False, [0.0, 5.0, 6.0, 9.0, 9.5]),
    "Starduster [92]": SongData(920, 92, {'Hatsune Miku'}, False, False, [3.5, 4.0, 5.0, 6.5, 0.0]),
    "Paradichlorobenzene [93]": SongData(930, 93, {'Kagamine Len'}, False, False, [3.0, 5.0, 6.5, 9.0, 0.0]),
    "Wintry Winds [94]": SongData(940, 94, {'KAITO', 'MEIKO'}, False, False, [2.0, 4.0, 5.0, 8.0, 9.0]),
    "NekoMimi Switch [95]": SongData(950, 95, {'Hatsune Miku'}, False, False, [2.5, 3.5, 5.0, 7.5, 0.0]),
    "Sekiranun Graffiti [96]": SongData(960, 96, {'Hatsune Miku'}, False, False, [3.0, 4.0, 5.0, 7.0, 8.0]),
    "RinRin Signal -Append Mix- [97]": SongData(970, 97, {'Kagamine Rin', 'Kagamine Len'}, False, False, [2.5, 4.0, 5.0, 7.0, 0.0]),
    "Magical Sound Shower [101]": SongData(1010, 101, {'Hatsune Miku'}, True, False, [0.0, 6.5, 8.0, 8.5, 9.0]),
    "Quartet of Multiple Futures -Quartet Theme- [102]": SongData(1020, 102, {'Hatsune Miku'}, False, False, [2.5, 4.0, 6.0, 8.5, 0.0]),
    "AFTER BURNER [103]": SongData(1030, 103, {'MEIKO'}, False, False, [0.0, 4.5, 5.5, 8.5, 0.0]),
    "LIKE THE WIND [104]": SongData(1040, 104, {'Kagamine Rin', 'Megurine Luka'}, False, False, [0.0, 4.0, 6.0, 8.0, 0.0]),
    "Stardust Utopia [201]": SongData(2010, 201, {'Megurine Luka'}, False, False, [0.0, 5.0, 6.5, 8.0, 8.5]),
    "StargazeR [202]": SongData(2020, 202, {'Hatsune Miku'}, False, False, [0.0, 4.5, 6.0, 8.0, 8.0]),
    "Solitude's End [203]": SongData(2030, 203, {'Kagamine Rin'}, True, False, [0.0, 4.5, 6.0, 8.0, 0.0]),
    "Time Limit [204]": SongData(2040, 204, {'Hatsune Miku'}, True, False, [2.0, 4.0, 5.0, 8.0, 8.5]),
    "Holy Star -2010 DIVA mix- [205]": SongData(2050, 205, {'Hatsune Miku'}, True, False, [0.0, 4.0, 5.0, 7.0, 0.0]),
    "melody... [206]": SongData(2060, 206, {'Hatsune Miku'}, True, False, [2.5, 3.5, 5.5, 8.0, 0.0]),
    "Meiteki Cybernetics [208]": SongData(2080, 208, {'Megurine Luka'}, True, False, [2.5, 5.0, 6.0, 8.0, 9.0]),
    "Pink Moon [209]": SongData(2090, 209, {'Hatsune Miku'}, True, False, [0.0, 5.0, 6.5, 7.5, 8.0]),
    "Transparent Watercolors [210]": SongData(2100, 210, {'Hatsune Miku'}, True, False, [0.0, 5.5, 6.5, 8.5, 9.0]),
    "Iroha Uta [211]": SongData(2110, 211, {'Kagamine Rin'}, True, False, [0.0, 5.5, 7.0, 9.0, 9.5]),
    "Colorful x Sexy [212]": SongData(2120, 212, {'Megurine Luka', 'MEIKO'}, False, False, [0.0, 5.5, 7.5, 8.5, 9.0]),
    "Luka Luka * Night Fever [213]": SongData(2130, 213, {'Megurine Luka'}, False, False, [3.5, 4.5, 6.5, 8.0, 9.0]),
    "Butterfly on Your Right Shoulder -39's Giving Day Edition- [214]": SongData(2140, 214, {'Kagamine Rin', 'Kagamine Len'}, True, False, [0.0, 5.5, 6.5, 8.5, 0.0]),
    "Leia [215]": SongData(2150, 215, {'Megurine Luka'}, False, False, [0.0, 5.5, 6.5, 8.0, 9.5]),
    "Senbonzakura [216]": SongData(2160, 216, {'Hatsune Miku'}, True, False, [2.0, 4.0, 6.5, 8.0, 0.0]),
    "The Snow White Princess is... [218]": SongData(2180, 218, {'Hatsune Miku'}, False, False, [0.0, 5.5, 6.5, 7.5, 8.0]),
    "Deep Sea Girl [219]": SongData(2190, 219, {'Hatsune Miku'}, False, False, [2.0, 4.0, 5.0, 7.0, 8.0]),
    "World's End Dance Hall -Live Dance Edition- [220]": SongData(2200, 220, {'Hatsune Miku', 'Megurine Luka'}, False, False, [3.0, 5.0, 7.0, 10.0, 10.0]),
    "NekoMimi Archive [221]": SongData(2210, 221, {'Hatsune Miku'}, False, False, [3.5, 5.0, 7.0, 8.5, 9.5]),
    "Black Gold [222]": SongData(2220, 222, {'Megurine Luka'}, False, False, [0.0, 5.5, 7.5, 8.5, 9.5]),
    "Out of Eden [223]": SongData(2230, 223, {'Kagamine Rin', 'Kagamine Len'}, True, False, [0.0, 5.0, 6.0, 8.0, 0.0]),
    "Rosary Pale [224]": SongData(2240, 224, {'KAITO'}, False, False, [0.0, 4.5, 6.5, 8.0, 8.5]),
    "Yumeyume [225]": SongData(2250, 225, {'Hatsune Miku'}, False, False, [3.0, 5.0, 6.0, 7.0, 8.5]),
    "On The Rocks [226]": SongData(2260, 226, {'KAITO', 'MEIKO'}, False, False, [0.0, 5.0, 6.0, 8.0, 8.0]),
    "Mousou Sketch [227]": SongData(2270, 227, {'Hatsune Miku', 'Kagamine Rin'}, False, False, [0.0, 4.0, 6.0, 9.0, 9.5]),
    "No Logic [228]": SongData(2280, 228, {'Megurine Luka'}, False, False, [0.0, 4.5, 6.5, 8.0, 0.0]),
    "Kipple Industry Inc. [231]": SongData(2310, 231, {'Hatsune Miku'}, False, False, [0.0, 6.0, 7.0, 8.0, 9.0]),
    "39 [232]": SongData(2320, 232, {'Hatsune Miku'}, False, False, [4.0, 5.0, 6.0, 7.0, 8.0]),
    "The Two of Us - Futaride [233]": SongData(2330, 233, {'Hatsune Miku'}, True, False, [0.0, 4.0, 5.0, 7.5, 0.0]),
    "Deep Sea City Underground [234]": SongData(2340, 234, {'Kagamine Rin', 'Kagamine Len'}, False, False, [3.0, 4.0, 5.0, 7.0, 8.5]),
    "Lucid Dreaming [235]": SongData(2350, 235, {'Hatsune Miku'}, True, False, [3.5, 4.5, 6.0, 8.0, 0.0]),
    "Absolunote [236]": SongData(2360, 236, {'Hatsune Miku'}, True, False, [0.0, 4.0, 6.0, 8.5, 0.0]),
    "SING&SMILE [238]": SongData(2380, 238, {'Hatsune Miku', 'Kagamine Rin', 'Kagamine Len', 'Megurine Luka', 'KAITO', 'MEIKO'}, False, False, [0.0, 4.0, 6.5, 8.5, 0.0]),
    "Tricolore Airline [239]": SongData(2390, 239, {'Hatsune Miku', 'Kagamine Rin', 'Megurine Luka', 'MEIKO'}, False, False, [0.0, 4.5, 6.0, 7.5, 0.0]),
    "Systematic Love [240]": SongData(2400, 240, {'Hatsune Miku'}, False, False, [0.0, 4.5, 6.5, 8.5, 0.0]),
    "Electrosaturator [241]": SongData(2410, 241, {'Hatsune Miku'}, False, False, [3.0, 4.0, 6.5, 8.0, 0.0]),
    "1/6 -out of the gravity- [242]": SongData(2420, 242, {'Hatsune Miku'}, False, False, [3.0, 4.0, 5.0, 7.0, 0.0]),
    "Interviewer [243]": SongData(2430, 243, {'Hatsune Miku', 'Megurine Luka'}, False, False, [2.0, 4.5, 6.0, 7.5, 0.0]),
    "Snowman [244]": SongData(2440, 244, {'Kagamine Len', 'KAITO'}, False, False, [1.5, 4.0, 6.5, 8.5, 0.0]),
    "Terekakushi Shishunki [246]": SongData(2460, 246, {'Kagamine Len', 'KAITO'}, False, False, [0.0, 4.5, 6.0, 8.0, 0.0]),
    "Sweet Magic [247]": SongData(2470, 247, {'Kagamine Rin'}, False, False, [1.0, 3.5, 6.0, 8.0, 0.0]),
    "Arifureta Sekai Seifuku [248]": SongData(2480, 248, {'Hatsune Miku'}, False, False, [1.5, 3.5, 6.5, 9.0, 0.0]),
    "Ageage Again [249]": SongData(2490, 249, {'Hatsune Miku'}, False, False, [2.0, 4.5, 6.5, 8.5, 0.0]),
    "Nice To Meet You, Mr. Earthling [250]": SongData(2500, 250, {'Hatsune Miku'}, False, False, [3.0, 4.5, 6.5, 8.0, 0.0]),
    "PIANO*GIRL [251]": SongData(2510, 251, {'Hatsune Miku'}, False, False, [3.0, 4.5, 6.5, 8.5, 0.0]),
    "LOL -lots of laugh- [253]": SongData(2530, 253, {'Hatsune Miku'}, False, False, [2.0, 4.0, 5.0, 7.5, 0.0]),
    "Amatsu Kitsune [254]": SongData(2540, 254, {'Kagamine Rin'}, False, False, [2.5, 3.5, 5.5, 8.0, 0.0]),
    "Gaikotsu Gakudan to Riria [255]": SongData(2550, 255, {'Hatsune Miku'}, False, False, [3.5, 6.0, 8.0, 9.5, 0.0]),
    "shake it! [257]": SongData(2570, 257, {'Hatsune Miku', 'Kagamine Rin', 'Kagamine Len'}, False, False, [2.5, 4.5, 6.0, 8.0, 0.0]),
    "Cendrillon [259]": SongData(2590, 259, {'Hatsune Miku', 'KAITO'}, False, False, [1.5, 4.0, 5.5, 8.5, 0.0]),
    "Adolescence [260]": SongData(2600, 260, {'Kagamine Rin', 'Kagamine Len'}, False, False, [1.5, 4.0, 5.5, 8.0, 0.0]),
    "Kimi no Taion [261]": SongData(2610, 261, {'Hatsune Miku'}, False, False, [3.0, 4.5, 6.5, 8.5, 0.0]),
    "Piano x Forte x Scandal [262]": SongData(2620, 262, {'Hatsune Miku', 'Kagamine Rin', 'KAITO', 'MEIKO'}, False, False, [4.0, 5.5, 6.5, 9.5, 0.0]),
    "1925 [263]": SongData(2630, 263, {'Hatsune Miku', 'Kagamine Rin', 'Kagamine Len', 'Megurine Luka', 'KAITO', 'MEIKO'}, False, False, [2.0, 4.5, 6.5, 8.5, 0.0]),
    "Hibikase [265]": SongData(2650, 265, {'Hatsune Miku'}, False, False, [2.0, 4.0, 6.0, 8.5, 0.0]),
    "Ghost Rule [266]": SongData(2660, 266, {'Hatsune Miku'}, False, False, [3.5, 5.5, 7.5, 9.0, 0.0]),
    "Suna no Wakusei feat. Hatsune Miku [267]": SongData(2670, 267, {'Hatsune Miku'}, False, False, [3.0, 5.5, 7.0, 9.0, 0.0]),
    "Catch the Wave [268]": SongData(2680, 268, {'Hatsune Miku'}, False, False, [1.5, 3.0, 5.5, 8.0, 0.0]),
    "39 Music! [269]": SongData(2690, 269, {'Hatsune Miku'}, False, False, [1.5, 4.0, 6.0, 8.5, 0.0]),
    "Alien Alien [270]": SongData(2700, 270, {'Hatsune Miku'}, False, False, [1.5, 4.0, 7.0, 8.5, 0.0]),
    "Teo [271]": SongData(2710, 271, {'Hatsune Miku'}, False, False, [2.0, 5.0, 7.5, 9.0, 0.0]),
    "HIBANA [272]": SongData(2720, 272, {'Hatsune Miku'}, False, False, [2.0, 5.0, 7.5, 8.5, 0.0]),
    "ROKI [273]": SongData(2730, 273, {'Kagamine Rin', 'Kagamine Len'}, False, False, [2.0, 4.5, 7.0, 9.0, 0.0]),
    "Jigsaw puzzle [274]": SongData(2740, 274, {'Kagamine Len'}, False, False, [2.0, 4.5, 7.5, 9.5, 0.0]),
    "Dreamin Chuchu [275]": SongData(2750, 275, {'Megurine Luka'}, False, False, [3.5, 5.0, 6.5, 8.0, 0.0]),
    "Ooedo Julianight [276]": SongData(2760, 276, {'Hatsune Miku', 'KAITO'}, False, False, [1.5, 4.0, 7.5, 9.0, 0.0]),
    "JITTERBUG [277]": SongData(2770, 277, {'Hatsune Miku', 'MEIKO'}, False, False, [1.5, 4.0, 8.0, 9.0, 0.0]),
    "Bless Your Breath [278]": SongData(2780, 278, {'Hatsune Miku'}, False, False, [2.0, 4.0, 6.5, 8.5, 0.0]),
    "BRING IT ON [279]": SongData(2790, 279, {'Kagamine Rin', 'Kagamine Len'}, False, False, [2.0, 5.0, 7.0, 9.0, 0.0]),
    "Dramaturgy [280]": SongData(2800, 280, {'Hatsune Miku'}, False, False, [2.0, 4.5, 7.5, 9.5, 0.0]),
    "Greenlights Serenade [281]": SongData(2810, 281, {'Hatsune Miku'}, False, False, [2.0, 5.0, 7.0, 8.5, 0.0]),
    "One-Sided Love Samba [401]": SongData(4010, 401, {'Hatsune Miku'}, True, False, [0.0, 5.0, 7.0, 7.5, 9.5]),
    "Sayonara, Goodbye [402]": SongData(4020, 402, {'Hatsune Miku'}, True, False, [2.5, 4.5, 6.0, 7.0, 8.0]),
    "Disruptive Diva [403]": SongData(4030, 403, {'Hatsune Miku'}, True, False, [0.0, 5.0, 7.0, 8.0, 8.5]),
    "ZIGG-ZAGG [404]": SongData(4040, 404, {'Hatsune Miku'}, True, False, [0.0, 4.5, 6.0, 8.0, 8.5]),
    "Nightmare * Party Night [405]": SongData(4050, 405, {'Hatsune Miku'}, True, False, [3.0, 4.0, 6.0, 6.5, 8.0]),
    "Love's note [407]": SongData(4070, 407, {'Hatsune Miku'}, True, False, [0.0, 4.0, 6.5, 7.5, 8.0]),
    "SYMPHONIC DIVE - DIVA FT edit - [408]": SongData(4080, 408, {'Hatsune Miku'}, True, False, [0.0, 4.0, 6.0, 8.5, 0.0]),
    "How'd It Get To Be Like This? [409]": SongData(4090, 409, {'Hatsune Miku'}, True, False, [2.5, 4.0, 6.0, 9.0, 0.0]),
    "Wolf Girl [410]": SongData(4100, 410, {'Hatsune Miku'}, True, False, [2.5, 4.0, 5.0, 7.5, 8.5]),
    "Starlite*Lydian [411]": SongData(4110, 411, {'Hatsune Miku'}, True, False, [0.0, 5.0, 6.0, 8.0, 0.0]),
    "Perico Space Shipper [412]": SongData(4120, 412, {'Hatsune Miku'}, True, False, [0.0, 4.0, 5.0, 7.5, 8.5]),
    "Master of Puppets [413]": SongData(4130, 413, {'Hatsune Miku', 'Megurine Luka'}, True, False, [0.0, 5.5, 6.5, 8.5, 9.5]),
    "Pane dhiria [414]": SongData(4140, 414, {'KAITO'}, True, False, [0.0, 4.5, 6.0, 8.5, 9.0]),
    "The Star Maker [415]": SongData(4150, 415, {'Kagamine Len'}, True, False, [2.0, 4.5, 6.0, 8.0, 8.5]),
    "So Much Loving You* -DIVA Edit- [416]": SongData(4160, 416, {'Hatsune Miku'}, True, False, [3.0, 4.5, 5.5, 8.0, 0.0]),
    "Jugemu Sequencer [417]": SongData(4170, 417, {'Hatsune Miku'}, True, False, [0.0, 4.5, 6.5, 8.5, 10.0]),
    "Now Choose [418]": SongData(4180, 418, {'Kagamine Rin', 'Kagamine Len'}, True, False, [2.0, 4.0, 5.0, 8.0, 0.0]),
    "Iya Iya Seijin [419]": SongData(4190, 419, {'Megurine Luka'}, True, False, [3.5, 5.0, 7.0, 9.5, 0.0]),
    "Equation+** [420]": SongData(4200, 420, {'Kagamine Rin'}, True, False, [0.0, 5.0, 6.5, 8.5, 0.0]),
    "Betty The Liar [421]": SongData(4210, 421, {'Kagamine Rin'}, True, False, [0.0, 4.5, 5.5, 8.0, 9.5]),
    "Dance of Many [422]": SongData(4220, 422, {'Hatsune Miku'}, True, False, [0.0, 4.0, 6.0, 7.0, 8.5]),
    "maigo life [423]": SongData(4230, 423, {'Kagamine Rin'}, True, False, [0.0, 4.0, 6.0, 7.0, 8.5]),
    "High School Days - DIVA EDIT [424]": SongData(4240, 424, {'Hatsune Miku'}, True, False, [3.0, 4.0, 6.0, 8.0, 8.0]),
    "Soiyassa!! [425]": SongData(4250, 425, {'Kagamine Rin', 'Kagamine Len'}, True, False, [0.0, 5.0, 7.0, 8.5, 9.5]),
    "break;down [426]": SongData(4260, 426, {'Hatsune Miku'}, True, False, [0.0, 5.5, 6.5, 8.0, 0.0]),
    "Hanamai Tsukuyomi Tan [427]": SongData(4270, 427, {'Megurine Luka'}, True, False, [2.5, 4.0, 5.5, 7.5, 8.5]),
    "Francisca [428]": SongData(4280, 428, {'Kagamine Rin'}, True, False, [0.0, 5.5, 7.0, 9.0, 9.0]),
    "Song of Eternity -DIVAMIX- [429]": SongData(4290, 429, {'Hatsune Miku'}, True, False, [1.0, 3.0, 4.5, 6.5, 7.5]),
    "slump [430]": SongData(4300, 430, {'Hatsune Miku', 'Megurine Luka'}, True, False, [2.5, 4.0, 6.0, 8.5, 0.0]),
    "Gothic and Loneliness ~I'm the very DIVA~ [431]": SongData(4310, 431, {'Kagamine Rin'}, True, False, [0.0, 5.0, 7.5, 9.0, 10.0]),
    "Here Comes Karakasa-san [432]": SongData(4320, 432, {'Kagamine Len'}, True, False, [2.0, 3.5, 5.0, 7.0, 0.0]),
    "Paris Cinema Girl [433]": SongData(4330, 433, {'Hatsune Miku', 'KAITO'}, False, False, [3.5, 4.5, 6.5, 8.0, 0.0]),
    "Oha-Yo-del!! [434]": SongData(4340, 434, {'Hatsune Miku'}, True, False, [2.0, 3.0, 5.5, 9.0, 0.0]),
    "Denparadigm [435]": SongData(4350, 435, {'Hatsune Miku'}, False, False, [0.0, 5.5, 8.0, 10.0, 10.0]),
    "Travel to The Other Side of The Moon [436]": SongData(4360, 436, {'Kagamine Rin', 'Kagamine Len'}, True, False, [3.0, 5.5, 6.5, 8.0, 0.0]),
    "Let Me Lose Myself in The Black Note [437]": SongData(4370, 437, {'Hatsune Miku'}, True, False, [0.0, 5.0, 6.0, 8.0, 0.0]),
    "Step Forward [438]": SongData(4380, 438, {'Hatsune Miku'}, True, False, [0.0, 6.0, 7.5, 9.0, 0.0]),
    "Kimi Ni [439]": SongData(4390, 439, {'Hatsune Miku'}, True, False, [2.0, 4.5, 6.0, 8.5, 0.0]),
    "Knight of Light [440]": SongData(4400, 440, {'Hatsune Miku', 'KAITO'}, True, False, [2.5, 4.5, 6.0, 7.5, 0.0]),
    "Mellow Yellow [441]": SongData(4410, 441, {'MEIKO'}, True, False, [0.0, 5.0, 6.5, 8.0, 8.5]),
    "Gizmo [442]": SongData(4420, 442, {'Hatsune Miku'}, True, False, [2.0, 4.0, 6.0, 8.0, 0.0]),
    "Idol Radio (Game Edit) [443]": SongData(4430, 443, {'KAITO'}, True, False, [2.5, 3.5, 5.0, 7.5, 0.0]),
    "Cat Food [600]": SongData(6000, 600, {'Hatsune Miku'}, False, False, [2.5, 4.5, 6.0, 8.0, 8.5]),
    "Monochrome Blue Sky [601]": SongData(6010, 601, {'Hatsune Miku'}, False, False, [3.0, 4.0, 5.0, 7.0, 0.0]),
    "Fire Flower [602]": SongData(6020, 602, {'Kagamine Rin', 'Kagamine Len'}, False, False, [3.0, 4.5, 6.0, 7.5, 8.5]),
    "DYE [603]": SongData(6030, 603, {'Megurine Luka'}, False, False, [0.0, 4.0, 6.0, 8.5, 0.0]),
    "Torinokocity [604]": SongData(6040, 604, {'Hatsune Miku'}, False, False, [2.0, 4.5, 6.0, 8.0, 0.0]),
    "Hm? Ah, Yes. [605]": SongData(6050, 605, {'Hatsune Miku'}, False, False, [3.5, 5.0, 7.0, 8.5, 8.5]),
    "Secret Police [607]": SongData(6070, 607, {'Hatsune Miku'}, False, False, [0.0, 5.5, 6.5, 9.0, 0.0]),
    "What Do You Mean!? [608]": SongData(6080, 608, {'Hatsune Miku'}, False, False, [3.0, 4.0, 6.5, 8.0, 0.0]),
    "God-Tier Tune [609]": SongData(6090, 609, {'Hatsune Miku'}, False, False, [2.5, 4.0, 5.0, 7.0, 0.0]),
    "Nyanyanyanyanyanyanya! [610]": SongData(6100, 610, {'Hatsune Miku'}, False, False, [3.0, 5.5, 7.5, 9.0, 0.0]),
    "ACUTE [611]": SongData(6110, 611, {'Hatsune Miku', 'Megurine Luka', 'KAITO'}, False, False, [3.5, 4.5, 6.0, 7.5, 0.0]),
    "Time Machine [612]": SongData(6120, 612, {'Hatsune Miku'}, False, False, [1.0, 3.0, 5.0, 7.5, 0.0]),
    "Ashes to Ashes [613]": SongData(6130, 613, {'KAITO'}, False, False, [1.0, 3.0, 5.0, 8.0, 9.0]),
    "Glasses [614]": SongData(6140, 614, {'Megurine Luka'}, False, False, [0.0, 5.0, 6.5, 8.0, 0.0]),
    "Melancholic [615]": SongData(6150, 615, {'Kagamine Rin'}, False, False, [3.0, 4.0, 5.5, 8.0, 8.5]),
    "Unhappy Refrain [616]": SongData(6160, 616, {'Hatsune Miku', 'Kagamine Len', 'KAITO'}, False, False, [3.0, 5.5, 7.0, 9.0, 9.5]),
    "The MMORPG Addict's Anthem [617]": SongData(6170, 617, {'Hatsune Miku'}, False, False, [0.0, 5.0, 6.0, 8.0, 8.5]),
    "Kagamine HachiHachi Flower Fight [618]": SongData(6180, 618, {'Kagamine Rin', 'Kagamine Len'}, True, False, [2.5, 4.0, 6.0, 8.5, 0.0]),
    "Tengaku [619]": SongData(6190, 619, {'Kagamine Rin'}, False, False, [0.0, 4.0, 6.0, 8.0, 0.0]),
    "Remote Controller [620]": SongData(6200, 620, {'Kagamine Rin', 'Kagamine Len'}, False, False, [3.5, 5.0, 6.0, 8.0, 0.0]),
    "Nostalogic [621]": SongData(6210, 621, {'MEIKO'}, False, False, [0.0, 4.5, 6.0, 7.5, 0.0]),
    "Stay with me [622]": SongData(6220, 622, {'MEIKO'}, False, False, [2.5, 4.0, 5.0, 7.5, 0.0]),
    "Sadistic.Music Factory [623]": SongData(6230, 623, {'Hatsune Miku'}, False, False, [3.0, 4.5, 7.5, 10.0, 0.0]),
    "Summer Idol [624]": SongData(6240, 624, {'Hatsune Miku', 'Kagamine Rin'}, False, False, [2.5, 3.5, 6.0, 8.0, 0.0]),
    "Odds & Ends [625]": SongData(6250, 625, {'Hatsune Miku'}, False, False, [0.0, 5.5, 6.5, 8.5, 9.0]),
    "Weekender Girl [626]": SongData(6260, 626, {'Hatsune Miku'}, False, False, [2.0, 3.5, 5.0, 7.0, 0.0]),
    "World's End Umbrella [627]": SongData(6270, 627, {'Hatsune Miku'}, False, False, [2.0, 4.0, 6.0, 8.0, 0.0]),
    "Freely Tomorrow [628]": SongData(6280, 628, {'Hatsune Miku'}, False, False, [3.0, 5.0, 6.0, 7.0, 0.0]),
    "Negaposi*Continues [629]": SongData(6290, 629, {'Hatsune Miku'}, False, False, [0.0, 6.0, 8.0, 10.0, 0.0]),
    "Black*Rock Shooter [630]": SongData(6300, 630, {'Hatsune Miku'}, False, False, [2.0, 4.0, 6.0, 7.5, 0.0]),
    "Continuing Dream [631]": SongData(6310, 631, {'Hatsune Miku', 'Kagamine Rin', 'Kagamine Len', 'Megurine Luka'}, False, False, [2.0, 4.0, 5.5, 6.5, 0.0]),
    "Senbonzakura -F edition- [637]": SongData(6370, 637, {'Hatsune Miku', 'Kagamine Rin', 'Kagamine Len', 'Megurine Luka', 'KAITO', 'MEIKO'}, False, False, [2.5, 4.5, 7.5, 9.5, 0.0]),
    "Tell Your World [638]": SongData(6380, 638, {'Hatsune Miku'}, False, False, [1.0, 3.0, 5.0, 6.5, 8.0]),
    "Tokyo Teddy Bear [639]": SongData(6390, 639, {'Kagamine Rin'}, False, False, [0.0, 5.0, 6.5, 8.0, 8.5]),
    "Dream-Eating Monochrome Baku [640]": SongData(6400, 640, {'Kagamine Len'}, False, False, [2.0, 4.0, 6.5, 8.0, 0.0]),
    "Rin-chan Now! [641]": SongData(6410, 641, {'Hatsune Miku', 'Megurine Luka'}, False, False, [2.0, 4.5, 6.5, 9.0, 0.0]),
    "Sweet Devil [642]": SongData(6420, 642, {'Hatsune Miku'}, False, False, [3.0, 4.0, 6.0, 9.0, 0.0]),
    "Sakura no Ame [710]": SongData(7100, 710, {'Hatsune Miku'}, False, False, [2.0, 3.5, 5.0, 7.0, 0.0]),
    "Meteor [722]": SongData(7220, 722, {'Hatsune Miku'}, False, False, [1.0, 3.0, 5.5, 7.5, 0.0]),
    "2D Dream Fever [723]": SongData(7230, 723, {'Hatsune Miku'}, False, False, [4.0, 6.0, 7.5, 10.0, 0.0]),
    "Envy Cat Walk [724]": SongData(7240, 724, {'Hatsune Miku'}, False, False, [4.0, 6.0, 7.5, 9.5, 0.0]),
    "Pinky Swear [725]": SongData(7250, 725, {'Hatsune Miku'}, False, False, [1.5, 4.0, 6.0, 8.5, 0.0]),
    "Karakuri Pierrot [726]": SongData(7260, 726, {'Hatsune Miku'}, False, False, [2.5, 4.5, 6.5, 8.0, 0.0]),
    "Love-Hate [727]": SongData(7270, 727, {'Kagamine Rin', 'Kagamine Len'}, False, False, [2.0, 4.0, 5.5, 7.5, 0.0]),
    "Erase or Zero [728]": SongData(7280, 728, {'Kagamine Len', 'KAITO'}, False, False, [2.0, 4.0, 6.0, 8.0, 0.0]),
    "This is the Happiness and Peace of Mind Committee [729]": SongData(7290, 729, {'Hatsune Miku'}, False, False, [3.5, 5.0, 7.0, 9.0, 0.0]),
    "Hello, Worker [730]": SongData(7300, 730, {'Megurine Luka'}, False, False, [3.5, 4.0, 6.0, 8.0, 8.5]),
    "Knife [731]": SongData(7310, 731, {'Hatsune Miku', 'Kagamine Rin', 'Kagamine Len'}, False, False, [1.5, 4.5, 7.0, 8.5, 0.0]),
    "Akatsuki Arrival [732]": SongData(7320, 732, {'Hatsune Miku', 'Megurine Luka'}, False, False, [3.0, 5.5, 6.5, 8.5, 0.0]),
    "Doubleganger [733]": SongData(7330, 733, {'Hatsune Miku', 'Kagamine Rin'}, False, False, [4.0, 5.5, 7.0, 8.5, 0.0]),
    "Break It, Break It! [734]": SongData(7340, 734, {'MEIKO'}, False, False, [2.5, 4.0, 6.5, 8.5, 0.0]),
    "Two Breaths Walking [736]": SongData(7360, 736, {'Hatsune Miku'}, False, False, [3.0, 4.5, 6.5, 8.0, 0.0]),
    "Soundless Voice [737]": SongData(7370, 737, {'Kagamine Rin', 'Kagamine Len'}, False, False, [2.5, 5.0, 6.0, 7.5, 0.0]),
    "Blackjack [738]": SongData(7380, 738, {'Megurine Luka'}, False, False, [0.0, 4.5, 7.5, 9.5, 0.0]),
    "Decorator [739]": SongData(7390, 739, {'Hatsune Miku', 'Kagamine Rin', 'Kagamine Len', 'Megurine Luka', 'KAITO', 'MEIKO'}, False, False, [3.5, 4.0, 5.5, 7.5, 0.0]),
    "Glory 3usi9 [740]": SongData(7400, 740, {'Hatsune Miku'}, False, False, [2.5, 4.0, 6.0, 7.5, 0.0]),
    "Hand in Hand [832]": SongData(8320, 832, {'Hatsune Miku'}, False, False, [1.0, 3.0, 5.0, 7.5, 0.0]),
}

base_game_ids = { # Excluded: 700, 701
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 37, 38,
    39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 79,
    81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 101, 102, 103, 104, 201, 202, 203, 204, 205,
    206, 208, 209, 210, 211, 212, 213, 214, 215, 216, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 231, 232,
    233, 234, 235, 236, 238, 239, 240, 241, 242, 243, 244, 246, 247, 248, 249, 250, 251, 253, 254, 255, 257, 259, 260,
    261, 262, 263, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 401, 402, 403,
    404, 405, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427,
    428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 600, 601, 602, 603, 604, 605, 607,
    608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630,
    631, 637, 638, 639, 640, 641, 642, 710, 722, 723, 724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 736, 737,
    738, 739, 740, 832
}

dlc_ids = {
    3, 4, 6, 11, 15, 17, 18, 20, 21, 23, 24, 25, 29, 63, 64, 84, 101, 203, 204, 205, 206, 208, 209, 210, 211, 214, 216,
    223, 233, 235, 236, 401, 402, 403, 404, 405, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420,
    421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 434, 436, 437, 438, 439, 440, 441, 442, 443, 618
}