import time
import json
from worlds.tloz_ph.data.Constants import *

# TODO: Add sram data for saveslot 2
# TODO: Add the rest of sram data in bulk

LOCATIONS_DATA = {

    # ========== Mercay Island ============

    "Mercay Sword Chest": {
        "region_id": "mercay sword cave",
        "item_override": "Sword (Progressive)",
        "vanilla_item": "Oshus' Sword",
        "stage_id": 0xb,
        "floor_id": 0x13,
        "sram_addr": 0x43c,
        "sram_value": 0x1,
        "id": 1,
    },
    "Mercay Clear Rocks": {
        "region_id": "mercay sw",
        "vanilla_item": "Green Rupee (1)",
        "stage_id": 0xb,
        "floor_id": 0x0,
        "y": 0x0,
        "x_max": -150000,
        "sram_addr": 0x20ca,
        "sram_value": 0x40,
        "id": 2,
    },
    "Mercay Oshus Dig": {
        "region_id": "mercay dig spot",
        "stage_id": 0xb,
        "floor_id": 0x0,
        "y": 0x1333,
        "vanilla_item": "Treasure Map #10 (Gusts SE)",
        "id": 3,
    },
    "Mercay Cuccoo Chest": {
        "region_id": "mercay se",
        "stage_id": 0xb,
        "floor_id": 0x3,
        "y": 0x1333,
        "vanilla_item": "Treasure",
        "sram_addr": 0x3c4,
        "sram_value": 0x8,
        "id": 4,
    },
    "Mercay North Bonk Tree": {
        "region_id": "mercay ne",
        "stage_id": 0xb,
        "floor_id": 0x2,
        "y": 0x2666,
        "sram_addr": 0x17ac,
        "sram_value": 0x1,
        "vanilla_item": "Big Green Rupee (100)",
        "id": 5,
    },
    "Mercay Geozard Cave Chest": {
        "region_id": "mercay geozard cave north",
        "stage_id": 0xb,
        "floor_id": 0x10,
        "vanilla_item": "Power Gem",
        "sram_addr": 0x418,
        "sram_value": 0x1,
        "id": 6,
    },
    "Mercay Geozard Cave South Chest West": {
        "region_id": "mercay se ledge",
        "stage_id": 0xb,
        "floor_id": 0x3,
        "y": 0x2666,
        "x_max": 0x16200,
        "vanilla_item": "Ship Part",
        "sram_addr": 0x3c4,
        "sram_value": 0x2,
        "id": 7,
    },
    "Mercay Geozard Cave South Chest East": {
        "region_id": "mercay se ledge",
        "stage_id": 0xb,
        "floor_id": 0x3,
        "y": 0x2666,
        "x_min": 0x16200,
        "vanilla_item": "Big Green Rupee (100)",
        "sram_addr": 0x3c4,
        "sram_value": 0x4,
        "id": 8,
    },
    "TotOK Phantom Hourglass": {
        "region_id": "totok",
        "stage_id": 0x26,
        "floor_id": 0x0,
        "address": 0x1b55a0,
        "value": 0x4,
        "y": 0x399a,
        "vanilla_item": "Nothing!",
        "id": 9,
    },
    "Mercay Freedle Tunnel Chest": {
        "region_id": "mercay freedle tunnel chest",
        "stage_id": 0xb,
        "floor_id": 0x12,
        "vanilla_item": "Courage Gem",
        "sram_addr": 0x430,
        "sram_value": 0x1,
        "id": 10,
    },
    "Mercay Freedle Island Chest": {
        "region_id": "mercay freedle island",
        "stage_id": 0xb,
        "floor_id": 0x2,
        "y": 0x4ccd,
        "x_min": 0x25000,
        "vanilla_item": "Wisdom Gem",
        "sram_addr": 0x3ac,
        "sram_value": 0x40,
        "id": 11,
    },
    "Mercay Freedle Gift Item": {
        "region_id": "mercay freedle gift",
        "stage_id": 0xb,
        "floor_id": 0x2,
        "y": 0x4ccd,
        "x_max": 0x25000,
        "vanilla_item": "Treasure Map #12 (Dee Ess N)",
        "id": 12,
    },
    "Mercay Ojibe (Docks Guy) Item": {
        "region_id": "mercay yellow guy",
        "stage_id": 0xb,
        "floor_id": 0x3,
        "address": 0x1ba650,
        "value": 0x2,
        "vanilla_item": "Treasure Map #9 (Cannon W)",
        "id": 13,
    },
    "Mercay Shipyard Chest": {
        "region_id": "mercay shipyard",
        "stage_id": 0xb,
        "floor_id": 0xd,
        "vanilla_item": "Ship Part",
        "post_dungeon": "Temple of Fire",
        "id": 14,
    },
    "Mercay Oshus Spirit Gem": {
        "region_id": "mercay oshus gem",
        "stage_id": 0xb,
        "floor_id": 0xa,
        "vanilla_item": "Power Gem",
        "address": 0x1b55a5,
        "value": 0x2,
        "delay_reset": True,
        "id": 15,
    },
    "Mercay Oshus Phantom Sword": {
        "region_id": "mercay oshus phantom blade",
        "stage_id": 0xb,
        "floor_id": 0xa,
        "item_override": "Sword (Progressive)",
        "vanilla_item": "Phantom Sword",
        "address": 0x1ba648,
        "value": 0x20,
        "id": 16,
    },

    # ========== Mountain Passage ============

    "Mountain Passage Chest 1": {
        "region_id": "mercay passage 1",
        "vanilla_item": "Small Key (Mountain Passage)",
        "stage_id": 0x27,
        "floor_id": 0x0,
        "x_min": 0x61a8,
        "z_min": 0x61a8,
        "sram_addr": 0xae4,
        "sram_value": 0x8,
        "dungeon": "Mountain Passage",
        "id": 17,
        "do_special": "keylock"
    },
    "Mountain Passage Chest 2": {
        "region_id": "mercay passage 2",
        "stage_id": 0x27,
        "floor_id": 0x0,
        "x_min": 0x10900,
        "z_max": -0x7530,
        "vanilla_item": "Red Rupee (20)",
        "sram_addr": 0xae4,
        "sram_value": 0x2,
        "dungeon": "Mountain Passage",
        "id": 18,
        "do_special": "keylock"
    },
    "Mountain Passage Key Drop": {
        "region_id": "mercay passage 2",
        "vanilla_item": "Small Key (Mountain Passage)",
        "stage_id": 0x27,
        "floor_id": 0x0,
        "z_max": 0x11170,
        "sram_addr": 0x230,
        "sram_value": 0x2,
        "dungeon": "Mountain Passage",
        "id": 19,
        "do_special": "keylock"
    },
    "Mountain Passage Rat Key": {
        "region_id": "mercay passage rat",
        "vanilla_item": "Small Key (Mountain Passage)",
        "stage_id": 0x27,
        "floor_id": 0x1,
        "sram_addr": 0x230,
        "sram_value": 0x20,
        "dungeon": "Mountain Passage",
        "id": 20,
        "do_special": "keylock"
    },

    # ========== Island Shops ============

    "Island Shop Power Gem": {
        "region_id": "shop power gem",
        "vanilla_item": "Power Gem",
        "stage_id": 0xb,
        "floor_id": 0x11,
        "additional_rooms": [0xc0e, 0x1014],
        "address": 0x1b5589,
        "value": 0x2,
        "island_shop": True,
        "delay_reset": True,
        "id": 21,
    },
    "Island Shop Quiver": {
        "region_id": "shop quiver",
        "vanilla_item": "Bow (Progressive)",
        "stage_id": 0xb,
        "floor_id": 0x11,
        "additional_rooms": [0xc0e, 0x1014],
        "address": 0x1b5589,
        "value": 0x8,
        "island_shop": True,
        "delay_reset": True,
        "id": 22,
    },
    "Island Shop Bombchu Bag": {
        "region_id": "shop bombchu bag",
        "vanilla_item": "Bombchus (Progressive)",
        "stage_id": 0xb,
        "floor_id": 0x11,
        "additional_rooms": [0xc0e, 0x1014],
        "address": 0x1b5589,
        "value": 0x10,
        "island_shop": True,
        "delay_reset": True,
        "id": 23,
    },
    "Island Shop Heart Container": {
        "region_id": "shop heart container",
        "vanilla_item": "Heart Container",
        "stage_id": 0xb,
        "floor_id": 0x11,
        "additional_rooms": [0xc0e, 0x1014],
        "address": 0x1b5588,
        "value": 0x80,
        "island_shop": True,
        "id": 24,
    },

    # ========== Beedle ============

    "Beedle Shop Bomb Bag": {
        "region_id": "beedle bomb bag",
        "vanilla_item": "Bombs (Progressive)",
        "stage_id": 0x5,
        "floor_id": 0x0,
        "address": 0x1b5589,
        "value": 0x4,
        "delay_reset": True,
        "id": 25,
    },
    "Beedle Shop Wisdom Gem": {
        "region_id": "beedle gem",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0x5,
        "floor_id": 0x0,
        "address": 0x1b5589,
        "value": 0x20,
        "delay_reset": True,
        "id": 26,
    },
    "Masked Beedle Heart Container": {
        "region_id": "masked ship hc",
        "vanilla_item": "Heart Container",
        "stage_id": 0x5,
        "floor_id": 0x0,
        "address": 0x1b5589,
        "value": 0x1,
        "conditional": True,
        "delay_reset": True,
        "id": 27,
    },
    "Masked Beedle Courage Gem": {
        "region_id": "masked ship gem",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x5,
        "floor_id": 0x0,
        "address": 0x1b558a,
        "value": 0x2,
        "conditional": True,
        "delay_reset": True,
        "id": 28,
    },
    "Beedle Membership Bronze": {
        "region_id": "beedle bronze",
        "stage_id": 0x5,
        "floor_id": 0x0,
        "vanilla_item": "Nothing!",
        "address": 0x1b5588,
        "value": 0x40,
        "conditional": True,
        "id": 322,
    },
    "Beedle Membership Silver": {
        "region_id": "beedle silver",
        "stage_id": 0x5,
        "floor_id": 0x0,
        "vanilla_item": "Nothing!",
        "address": 0x1b558e,
        "value": 0x20,
        "conditional": True,
        "id": 323,
    },
    "Beedle Membership Gold": {
        "region_id": "beedle gold",
        "stage_id": 0x5,
        "floor_id": 0x0,
        "vanilla_item": "Nothing!",
        "address": 0x1b558e,
        "value": 0x40,
        "conditional": True,
        "id": 324,
    },
    "Beedle Membership Platinum": {
        "region_id": "beedle plat",
        "stage_id": 0x5,
        "floor_id": 0x0,
        "vanilla_item": "Nothing!",
        "address": 0x1b558e,
        "value": 0x80,
        "conditional": True,
        "id": 325,
    },
    "Beedle Membership VIP": {
        "region_id": "beedle vip",
        "stage_id": 0x5,
        "floor_id": 0x0,
        "vanilla_item": "Nothing!",
        "address": 0x1b558f,
        "value": 0x1,
        "conditional": True,
        "id": 326,
    },

    # ========== TotOK ============

    "TotOK 1F SW Sea Chart Chest": {
        "region_id": "totok 1f chart",
        "vanilla_item": "SW Sea Chart",
        "stage_id": 0x25,
        "floor_id": 0x0,
        "y": 0x1333,
        "dungeon": "Temple of the Ocean King",
        "set_bit": [(0x1b557d, 0x2)],
        "id": 29,
        "do_special": "ut_event",
    },
    "TotOK 1F Linebeck Key": {
        "region_id": "totok 1f",
        "vanilla_item": "Small Key (Temple of the Ocean King)",
        "stage_id": 0x25,
        "floor_id": 0x0,
        "z_min": 0xb000,
        "z_max": 0x11000,
        "x_min": -0x64,
        "set_bit": [(0x1b557d, 0x2)],
        "dungeon": "Temple of the Ocean King",
        "id": 30,
    },
    "TotOK 1F Empty Chest": {
        "region_id": "totok 1f chest",
        "vanilla_item": "Nothing!",
        "stage_id": 0x25,
        "floor_id": 0x0,
        "x_min": 0x4000,
        "dungeon": "Temple of the Ocean King",
        "id": 31,
    },
    "TotOK B1 Small Key": {
        "region_id": "totok b1 key",
        "vanilla_item": "Small Key (Temple of the Ocean King)",
        "stage_id": 0x25,
        "floor_id": 0x1,
        "y": 0x1333,
        "dungeon": "Temple of the Ocean King",
        "id": 32,
    },
    "TotOK B1 Shoot Eye Chest": {
        "region_id": "totok b1 bow",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x25,
        "floor_id": 0x1,
        "x_min": 0xb000,
        "x_max": 0x10000,
        "dungeon": "Temple of the Ocean King",
        "id": 33,
    },
    "TotOK B1 Phantom Chest": {
        "region_id": "totok b1 phantom",
        "vanilla_item": "Treasure",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0x1,
        "x_max": -0xc350,
        "x_min": -0x11170,
        "y": 0x0,
        "dungeon": "Temple of the Ocean King",
        "id": 34,
    },
    "TotOK B2 Bombchu Chest": {
        "region_id": "totok b2 chu",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0x25,
        "floor_id": 0x2,
        "x_min": 0xd800,
        "x_max": 0x10000,
        "require_item": ["Bombchus (Progressive)", "Hammer"],
        "delay_pickup": "TotOK B2 Small Key",
        "dungeon": "Temple of the Ocean King",
        "id": 35,
    },
    "TotOK B2 Phantom Chest": {
        "region_id": "totok b2 phantom",
        "vanilla_item": "Treasure",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0x2,
        "z_min": 0x7000,
        "z_max": 0xf000,
        "delay_pickup": "TotOK B2 Small Key",
        "dungeon": "Temple of the Ocean King",
        "id": 36,
    },
    "TotOK B2 Small Key": {
        "region_id": "totok b2 key",
        "vanilla_item": "Small Key (Temple of the Ocean King)",
        "stage_id": 0x25,
        "floor_id": 0x2,
        "dungeon": "Temple of the Ocean King",
        "id": 37,
    },
    "TotOK B3 Bow Chest": {
        "region_id": "totok b3 bow",
        "vanilla_item": "Power Gem",
        "stage_id": 0x25,
        "floor_id": 0x3,
        "y": 0x1333,
        "z_max": -0x55f0,
        "z_min": -0x9c40,
        "dungeon": "Temple of the Ocean King",
        "id": 38,
    },
    "TotOK B3 Phantom Chest": {
        "region_id": "totok b3 phantom",
        "vanilla_item": "Treasure",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0x3,
        "y": 0x1333,
        "z_min": 0x5000,
        "z_max": 0xd000,
        "dungeon": "Temple of the Ocean King",
        "id": 39,
    },
    "TotOK B3 NW Chest": {
        "region_id": "totok b3 nw",
        "vanilla_item": "Force Gem (B3)",
        "stage_id": 0x25,
        "floor_id": 0x3,
        "x_max": -0xc350,
        "z_max": -0x88b8,
        "y": 0x0,
        "delay_pickup": "TotOK B3 Small Key",
        "dungeon": "Temple of the Ocean King",
        "id": 40,
    },
    "TotOK B3 SW Chest": {
        "region_id": "totok b3 sw",
        "vanilla_item": "Force Gem (B3)",
        "stage_id": 0x25,
        "floor_id": 0x3,
        "x_max": -0x2af8,
        "x_min": -0x9664,
        "z_min": 0x8000,
        "y": 0x0,
        "delay_pickup": "TotOK B3 Small Key",
        "dungeon": "Temple of the Ocean King",
        "id": 41,
    },
    "TotOK B3 SE Chest": {
        "region_id": "totok b3 se",
        "vanilla_item": "Force Gem (B3)",
        "stage_id": 0x25,
        "floor_id": 0x3,
        "x_min": 0xe000,
        "z_min": 0xb000,
        "y": 0x0,
        "delay_pickup": "TotOK B3 Small Key",
        "dungeon": "Temple of the Ocean King",
        "id": 42,
    },
    "TotOK B3 Small Key": {
        "region_id": "totok b3 key",
        "vanilla_item": "Small Key (Temple of the Ocean King)",
        "stage_id": 0x25,
        "floor_id": 0x3,
        "dungeon": "Temple of the Ocean King",
        "id": 43,
    },
    "TotOK B3 NW Sea Chart Chest": {
        "region_id": "totok b35",
        "vanilla_item": "NW Sea Chart",
        "stage_id": 0x25,
        "floor_id": 0x4,
        "dungeon": "Temple of the Ocean King",
        "id": 44,
    },
    "TotOK B4 Phantom Eye Chest": {
        "region_id": "totok b4 eyes",
        "vanilla_item": "Power Gem",
        "stage_id": 0x25,
        "floor_id": 0x5,
        "x_min": 0xf000,
        "x_max": 0x16000,
        "delay_pickup": "TotOK B4 Small Key",
        "dungeon": "Temple of the Ocean King",
        "id": 45,
    },
    "TotOK B4 Phantom Chest": {
        "region_id": "totok b4 phantom",
        "vanilla_item": "Treasure",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0x5,
        "x_max": -0xea60,
        "dungeon": "Temple of the Ocean King",
        "delay_pickup": "TotOK B4 Small Key",
        "id": 46,
    },
    "TotOK B4 Small Key": {
        "region_id": "totok b4 key",
        "vanilla_item": "Small Key (Temple of the Ocean King)",
        "stage_id": 0x25,
        "floor_id": 0x5,
        "dungeon": "Temple of the Ocean King",
        "delay_pickup": "TotOK B4 Small Key",
        "id": 47,
    },
    "TotOK B5 Alt Path Chest": {
        "region_id": "totok b5 alt chest",
        "vanilla_item": "Treasure Map #23 (Frost NW)",
        "stage_id": 0x25,
        "floor_id": 0x6,
        "x_max": -0x3a98,
        "dungeon": "Temple of the Ocean King",
        "id": 48,
    },
    "TotOK B5 Chest": {
        "region_id": "totok b5 chest",
        "vanilla_item": "Red Potion",
        "stage_id": 0x25,
        "floor_id": 0x6,
        "x_min": 0x6000,
        "x_max": 0xc000,
        "dungeon": "Temple of the Ocean King",
        "id": 49,
    },
    "TotOK B6 Phantom Chest": {
        "region_id": "totok b6 phantom",
        "vanilla_item": "Treasure",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0x7,
        "z_min": 0xa000,
        "z_max": 0xf000,
        "dungeon": "Temple of the Ocean King",
        "id": 50,
    },
    "TotOK B6 Bow Chest": {
        "region_id": "totok b6 bow",
        "vanilla_item": "Treasure Map #11 (Gusts N)",
        "stage_id": 0x25,
        "floor_id": 0x7,
        "z_max": -0x9c40,
        "dungeon": "Temple of the Ocean King",
        "id": 51,
    },
    "TotOK B6 Courage Crest": {
        "region_id": "totok b6 crest",
        "vanilla_item": "Nothing!",
        "item_override": "Courage Crest",
        "stage_id": 0x25,
        "floor_id": 0x8,
        "address": 0x1b558c,
        "value": 0x4,
        "dungeon": "Temple of the Ocean King",
        "id": 52,
    },
    "TotOK B7 North Chest": {
        "region_id": "totok b7 crystal",
        "vanilla_item": "Round Crystal (Temple of the Ocean King)",
        "stage_id": 0x25,
        "floor_id": 0xa,
        "x_min": -0x1388,
        "x_max": 0x3a98,
        "z_max": -0xc350,
        "dungeon": "Temple of the Ocean King",
        "id": 53,
    },
    "TotOK B7 Peg Chest": {
        "region_id": "totok b7 switch",
        "vanilla_item": "Power Gem",
        "stage_id": 0x25,
        "floor_id": 0xa,
        "x_min": 0xc350,
        "x_max": 0x124f8,
        "z_max": 0x2af8,
        "dungeon": "Temple of the Ocean King",
        "id": 54,
    },
    "TotOK B7 Phantom Chest": {
        "region_id": "totok b7 phantom",
        "vanilla_item": "Ship Part",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0xa,
        "x_max": -0xea60,
        "z_max": -0xc350,
        "dungeon": "Temple of the Ocean King",
        "id": 55,
    },
    "TotOK B8 2 Crystals Chest": {
        "region_id": "totok b8 2c chest",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x25,
        "floor_id": 0xb,
        "x_max": -0x2710,
        "z_max": -0x7530,
        "dungeon": "Temple of the Ocean King",
        "id": 56,
    },
    "TotOK B8 Phantom Chest": {
        "region_id": "totok b8 phantom",
        "vanilla_item": "Ship Part",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0xb,
        "x_max": 0xc350,
        "z_max": 0x2710,
        "x_min": 0x61a8,
        "z_min": -0x2710,
        "dungeon": "Temple of the Ocean King",
        "id": 57,
    },
    "TotOK B9 NW Chest": {
        "region_id": "totok b9 corner chest",
        "vanilla_item": "Triangle Crystal (Temple of the Ocean King)",
        "stage_id": 0x25,
        "floor_id": 0xc,
        "x_min": -0xafc8,
        "z_max": -0x7530,
        "dungeon": "Temple of the Ocean King",
        "id": 58,
    },
    "TotOK B9 Wizzrobe Chest": {
        "region_id": "totok b9 ghosts",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0x25,
        "floor_id": 0xc,
        "x_min": -0x7530,
        "z_min": -0x2328,
        "x_max": -0xbb8,
        "z_max": 0x4e20,
        "dungeon": "Temple of the Ocean King",
        "id": 59,
    },
    "TotOK B9 Phantom Chest": {
        "region_id": "totok b9 phantom",
        "vanilla_item": "Ship Part",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0xc,
        "x_max": -0xea60,
        "z_min": 0xafc8,
        "dungeon": "Temple of the Ocean King",
        "id": 60,
    },
    "TotOK B9.5 SE Sea Chart Chest": {
        "region_id": "totok b10",
        "vanilla_item": "SE Sea Chart",
        "stage_id": 0x25,
        "floor_id": 0xd,
        "dungeon": "Temple of the Ocean King",
        "id": 61,
    },
    "TotOK B10 Hammer Switch Chest": {
        "region_id": "totok b10 hammer",
        "vanilla_item": "Treasure Map #30 (Ruins S)",
        "stage_id": 0x25,
        "floor_id": 0xe,
        "x_min": 0x3a98,
        "z_min": -0x3a98,
        "x_max": 0x9c40,
        "z_max": 0x2710,
        "y": 0x0,
        "delay_pickup": "TotOK B10 Small Key",
        "dungeon": "Temple of the Ocean King",
        "id": 62,
    },
    "TotOK B10 Phantom Chest": {
        "region_id": "totok b10 phantom",
        "vanilla_item": "Big Green Rupee (100)",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0xe,
        "x_min": -0x9c40,
        "z_min": -0x2710,
        "x_max": -0x4e20,
        "z_max": 0x2710,
        "y": 0x0,
        "delay_pickup": "TotOK B10 Small Key",
        "dungeon": "Temple of the Ocean King",
        "id": 63,
    },
    "TotOK B10 Phantom Eye Chest": {
        "region_id": "totok b10 eye",
        "vanilla_item": "Red Potion",
        "stage_id": 0x25,
        "floor_id": 0xe,
        "y": 0x1333,
        "dungeon": "Temple of the Ocean King",
        "id": 64,
    },
    "TotOK B10 Small Key": {
        "region_id": "totok b10 key",
        "vanilla_item": "Small Key (Temple of the Ocean King)",
        "stage_id": 0x25,
        "floor_id": 0xe,
        "dungeon": "Temple of the Ocean King",
        "id": 65,
    },
    "TotOK B11 Phantom Eye Chest": {
        "region_id": "totok b11 eyes",
        "vanilla_item": "Treasure",
        "stage_id": 0x25,
        "floor_id": 0xf,
        "x_min": 0xc350,
        "z_max": -0xafc8,
        "dungeon": "Temple of the Ocean King",
        "id": 66,
    },
    "TotOK B11 Phantom Chest": {
        "region_id": "totok b11 phantom",
        "vanilla_item": "Big Red Rupee (200)",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0xf,
        "x_max": -0xc350,
        "z_min": 0x9c40,
        "dungeon": "Temple of the Ocean King",
        "id": 67,
    },
    "TotOK B12 NW Chest": {
        "region_id": "totok b12 nw",
        "vanilla_item": "Force Gem (B12)",
        "stage_id": 0x25,
        "floor_id": 0x10,
        "x_min": 0x88b8,
        "z_max": -0xc350,
        "dungeon": "Temple of the Ocean King",
        "id": 68,
    },
    "TotOK B12 NE Chest": {
        "region_id": "totok b12 ne",
        "vanilla_item": "Force Gem (B12)",
        "stage_id": 0x25,
        "floor_id": 0x10,
        "x_max": -0x88b8,
        "z_max": -0xc350,
        "dungeon": "Temple of the Ocean King",
        "id": 69,
    },
    "TotOK B12 Hammer Chest": {
        "region_id": "totok b12 hammer",
        "vanilla_item": "Treasure Map #31 (Dead S)",
        "stage_id": 0x25,
        "floor_id": 0x10,
        "x_min": 0xfde8,
        "dungeon": "Temple of the Ocean King",
        "id": 70,
    },
    "TotOK B12 Kill Everything Chest": {
        "region_id": "totok b12 ghost",
        "vanilla_item": "Ship Part",
        "item_override": "NE Sea Chart",
        "stage_id": 0x25,
        "floor_id": 0x10,
        "x_max": -0xfde8,
        "dungeon": "Temple of the Ocean King",
        "id": 71,
    },
    "TotOK B12 Phantom Chest": {
        "region_id": "totok b12 phantom",
        "vanilla_item": "Gold Rupee (300)",
        "farmable": True,
        "stage_id": 0x25,
        "floor_id": 0x10,
        "x_min": -0x2710,
        "z_min": 0x0,
        "x_max": 0x2710,
        "z_max": 0x61a8,
        "dungeon": "Temple of the Ocean King",
        "id": 72,
    },
    "TotOK B13 NE Sea Chart Chest": {
        "region_id": "totok b13 chest",
        "vanilla_item": "NE Sea Chart",
        "item_override": "Rare Metal",
        "stage_id": 0x25,
        "floor_id": 0x11,
        "y": 0x0,
        "dungeon": "Temple of the Ocean King",
        "id": 73,
    },

    # ========== Ocean SW ============

    "Ocean SW Salvage Courage Crest": {
        "region_id": "sw ocean crest salvage",
        "vanilla_item": "Sun Key",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "address": 0x1b557e,
        "value": 0x40,
        "id": 74,
    },
    "Ocean SW Golden Frog X": {
        "region_id": "sw ocean frog x",
        "vanilla_item": "Golden Frog Glyph X",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "x_min": 0x1e848,
        "conditional": True,
        "id": 75,
    },
    "Ocean SW Golden Frog Phi": {
        "region_id": "sw ocean frog phi",
        "vanilla_item": "Golden Frog Glyph Phi",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "x_max": -0x1d4c0,
        "conditional": True,
        "id": 76,
    },
    "Ocean SW Nyave Treasure": {
        "region_id": "sw ocean nyave",
        "vanilla_item": "Treasure",
        "stage_id": 0xa,
        "floor_id": 0x0,
        "address": 0x1b5592,
        "value": 0x1,
        "delay_reset": True,
        "id": 77,
    },

    # ========== Cannon Island ============

    "Cannon Island Bee Chest": {
        "region_id": "cannon island",
        "vanilla_item": "Treasure Map #1 (Molida SW)",
        "stage_id": 0x13,
        "floor_id": 0x0,
        "x_max": -0x7530,
        "z_max": -0x3a98,
        "x_min": -0xc350,
        "y": 0x1333,
        "id": 78,
    },
    "Cannon Island Bee Dig": {
        "region_id": "cannon island dig",
        "vanilla_item": "Big Red Rupee (200)",
        "stage_id": 0x13,
        "floor_id": 0x0,
        "x_max": -0xc350,
        "y": 0x1333,
        "conditional": True,
        "id": 79,
    },
    "Cannon Island Cave Chest": {
        "region_id": "cannon cave south",
        "vanilla_item": "Power Gem",
        "stage_id": 0x28,
        "floor_id": 0x0,
        "id": 80,
    },
    "Cannon Island Cliff Chest": {
        "region_id": "cannon bomb garden",
        "vanilla_item": "Red Rupee (20)",
        "stage_id": 0x13,
        "floor_id": 0x0,
        "y": 0x2666,
        "id": 81,
    },
    "Cannon Island SE Dig": {
        "region_id": "cannon bomb garden dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x13,
        "floor_id": 0x0,
        "y": 0x1333,
        "x_max": 0x6978,
        "z_min": 0x9088,
        "conditional": True,
        "id": 82,
    },
    "Cannon Island Bonk Tree": {
        "region_id": "cannon bomb garden",
        "vanilla_item": "Big Red Rupee (200)",
        "stage_id": 0x13,
        "floor_id": 0x0,
        "y": 0x1333,
        "x_min": 0x6978,
        "z_min": 0x300c,
        "z_max": 0x9088,
        "sram_addr": 0x6dc,
        "sram_value": 0x1,
        "id": 83,
    },
    "Cannon Island East Dig": {
        "region_id": "cannon bomb garden dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x13,
        "floor_id": 0x0,
        "y": 0x1333,
        "x_min": 0x0,
        "z_max": 0x300c,
        "sram_addr": 0x190,
        "sram_value": 0x2,
        "conditional": True,
        "id": 84,
    },
    "Cannon Island Cannon": {
        "region_id": "cannon eddo",
        "vanilla_item": "Nothing!",
        "item_override": "Cannon",
        "stage_id": 0x13,
        "floor_id": 0xb,
        "address": 0x1ba649,
        "value": 0x2,
        "id": 85,
    },
    "Cannon Island Salvage Arm": {
        "region_id": "cannon island salvage arm",
        "vanilla_item": "Salvage Arm",
        "stage_id": 0x13,
        "floor_id": 0xb,
        "address": 0x1b558d,
        "value": 0x10,
        "id": 86,
    },

    # ========== Ember Island ============

    "Isle of Ember Astrid's Basement Dig": {
        "region_id": "ember astrid basement dig",
        "vanilla_item": "Treasure Map #3 (Gusts SW)",
        "stage_id": 0xd,
        "floor_id": 0x14,
        "id": 87,
    },
    "Isle of Ember Grapple Chest": {
        "region_id": "ember grapple",
        "vanilla_item": "Courage Gem",
        "stage_id": 0xd,
        "floor_id": 0x0,
        "z_max": -0x11170,
        "y": 0x0,
        "id": 88,
    },
    "Isle of Ember Summit Dig": {
        "region_id": "ember outside tof dig",
        "vanilla_item": "Treasure Map #4 (Bannan SE)",
        "stage_id": 0xd,
        "floor_id": 0x1,
        "y": 0x2666,
        "id": 89,
    },
    "Isle of Ember Summit Chest": {
        "region_id": "ember summit west",
        "vanilla_item": "Red Rupee (20)",
        "stage_id": 0xd,
        "floor_id": 0x0,
        "y": 0x399a,
        "id": 90,
    },
    "Isle of Ember Astrid after Fire Temple": {
        "region_id": "ember astrid post tof",
        "item_override": "Power Gem",
        "vanilla_item": "Nothing!",
        "stage_id": 0xd,
        "floor_id": 0xa,
        "address": 0x1b557f,
        "value": 0x20,
        "post_dungeon": "Temple of Fire",
        "id": 91,
    },

    # ========== Temple of Fire ============

    "Temple of Fire 1F Keese Chest": {
        "region_id": "tof 1f keese",
        "vanilla_item": "Small Key (Temple of Fire)",
        "stage_id": 0x1c,
        "floor_id": 0x0,
        "z_min": 0x9000,
        "z_max": 0xf000,
        "dungeon": "Temple of Fire",
        "id": 92,
    },
    "Temple of Fire 1F Maze Chest": {
        "region_id": "tof 1f maze",
        "vanilla_item": "Red Rupee (20)",
        "stage_id": 0x1c,
        "floor_id": 0x0,
        "x_min": 0x9c40,
        "z_max": -0x9c40,
        "dungeon": "Temple of Fire",
        "id": 93,
    },
    "Temple of Fire 2F Boomerang Chest": {
        "region_id": "tof 2f",
        "vanilla_item": "Boomerang",
        "stage_id": 0x1c,
        "floor_id": 0x1,
        "z_max": 0x2710,
        "x_min": 0x2710,
        "dungeon": "Temple of Fire",
        "id": 94,
    },
    "Temple of Fire 2F Fire Keese Chest": {
        "region_id": "tof 2f south",
        "vanilla_item": "Red Rupee (20)",
        "item_override": "Spirit of Power (Progressive)",
        "stage_id": 0x1c,
        "floor_id": 0x1,
        "z_min": 0x4000,
        "z_max": 0x7000,
        "x_min": -0x1b58,
        "x_max": 0x1000,
        "delay_pickup": "Temple of Fire 2F Rat Key",
        "dungeon": "Temple of Fire",
        "id": 95,
    },
    "Temple of Fire 2F Rat Key": {
        "region_id": "tof 2f south",
        "vanilla_item": "Small Key (Temple of Fire)",
        "stage_id": 0x1c,
        "floor_id": 0x1,
        "dungeon": "Temple of Fire",
        "id": 96,
    },
    "Temple of Fire 3F Key Drop": {
        "region_id": "tof 3f key drop",
        "vanilla_item": "Small Key (Temple of Fire)",
        "stage_id": 0x1c,
        "floor_id": 0x2,
        "y": 0x0,
        "dungeon": "Temple of Fire",
        "id": 97,
    },
    "Temple of Fire 3F Boss Key Chest": {
        "region_id": "tof 3f boss key",
        "vanilla_item": "Boss Key (Temple of Fire)",
        "stage_id": 0x1c,
        "floor_id": 0x2,
        "y": 0x1333,
        "dungeon": "Temple of Fire",
        "id": 98,
    },
    "Blaaz Heart Container": {
        "region_id": "post tof",
        "vanilla_item": "Heart Container",
        "stage_id": 0x2b,
        "floor_id": 0x0,
        "dungeon": "Temple of Fire",
        "id": 99,
    },
    "Blaaz Boss Reward": {
        "region_id": "post tof",
        "vanilla_item": "Spirit of Power (Progressive)",
        "item_override": "Rare Metal",
        "stage_id": 0x2b,
        "floor_id": 0x0,
        "address": 0x1b557f,
        "value": 0x20,
        "dungeon": "Temple of Fire",
        "boss_reward_location": True,
        "delay_reset": True,
        "id": 100,
    },

    # ========== Molida Island ============

    "Molida Island 2nd House Chest": {
        "region_id": "molida potato house",
        "vanilla_item": "Treasure",
        "stage_id": 0xc,
        "floor_id": 0xd,
        "id": 101,
    },
    "Molida Island Romanos Tree Dig": {
        "region_id": "molida dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0xc,
        "floor_id": 0x0,
        "z_max": 0xe290,
        "z_min": 0x61a8,
        "x_min": 0x9c40,
        "y": 0x0,
        "conditional": True,
        "id": 102,
    },
    "Molida Cave Wayfarer Hideaway Chest": {
        "region_id": "molida cave upper",
        "vanilla_item": "Treasure Map #2 (Mercay NE)",
        "stage_id": 0xc,
        "floor_id": 0xa,
        "y": 0x0,
        "x_max": -0x61a8,
        "id": 103,
    },
    "Molida Cave Grapple Chest": {
        "region_id": "molida cave grapple",
        "vanilla_item": "Power Gem",
        "stage_id": 0xc,
        "floor_id": 0xa,
        "y": 0x1333,
        "x_min": 0x9c40,
        "id": 104,
    },
    "Molida Cave Geozard Dig": {
        "region_id": "molida cave geozard dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0xc,
        "floor_id": 0xa,
        "y": 0x0,
        "x_min": 0x3a98,
        "conditional": True,
        "id": 105,
    },
    "Molida Cave Shovel Chest": {
        "region_id": "molida shovel cave",
        "vanilla_item": "Shovel",
        "stage_id": 0xc,
        "floor_id": 0xf,
        "z_max": 0xa028,
        "sram_addr": 0x49c,
        "sram_value": 0x1,
        "id": 106,
    },
    "Molida Cave Shovel Room Dig": {
        "region_id": "molida shovel cave dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0xc,
        "floor_id": 0xf,
        "sram_addr": 0x158,
        "sram_value": 0x100,
        "conditional": True,
        "id": 107,
    },
    "Molida Island Cliff Chest": {
        "region_id": "molida cliff north",
        "vanilla_item": "Treasure",
        "stage_id": 0xc,
        "floor_id": 0x1,
        "y": 0x1333,
        "x_max": -0x4650,
        "z_min": -0x7530,
        "id": 108,
    },
    "Molida Island Cuccoo Grapple Tree Dig": {
        "region_id": "molida cuccoo dig",
        "vanilla_item": "Treasure Map #20 (Bannan E)",
        "stage_id": 0xc,
        "floor_id": 0x0,
        "y": 0x1333,
        "x_min": 0x15f90,
        "id": 109,
    },
    "Molida Island Cuccoo Grapple Small Island Dig": {
        "region_id": "molida cuccoo dig",
        "vanilla_item": "Big Red Rupee (200)",
        "stage_id": 0xc,
        "floor_id": 0x0,
        "z_min": 0xe290,
        "y": 0x0,
        "x_min": 0x9c40,
        "conditional": True,
        "id": 110,
    },
    "Molida Island North Dig Chest": {
        "region_id": "molida cave drop",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0xc,
        "floor_id": 0xa,
        "y": 0x2666,
        "z_max": -0xfde8,
        "id": 111,
    },
    "Molida Island North Grapple Chest": {
        "region_id": "molida north grapple",
        "vanilla_item": "Courage Gem",
        "stage_id": 0xc,
        "floor_id": 0x1,
        "y": 0x2666,
        "x_max": 0x0,
        "id": 112,
    },
    "Molida Archery 1700": {
        "region_id": "molida archery",
        "vanilla_item": "Bow (Progressive)",
        "stage_id": 0xc,
        "floor_id": 0xb,
        "address": 0x1b55a2,
        "value": 0x8,
        "post_dungeon": "Temple of Courage",
        "delay_reset": True,
        "conditional": True,
        "id": 113,
    },
    "Molida Archery 2000": {
        "region_id": "molida archery",
        "vanilla_item": "Heart Container",
        "stage_id": 0xc,
        "floor_id": 0x1,
        "address": 0x1b55a6,
        "value": 0x10,
        "post_dungeon": "Temple of Courage",
        "delay_reset": True,
        "conditional": True,
        "id": 114,
    },

    # ========== Temple of Courage ============

    "Temple of Courage 1F Bomb Alcove Chest": {
        "region_id": "toc bomb alcove",
        "vanilla_item": "Treasure",
        "stage_id": 0x1e,
        "floor_id": 0x0,
        "z_max": -0xd6d8,
        "x_max": 0x88b8,
        "x_min": 0x4e20,
        "dungeon": "Temple of Courage",
        "id": 115,
    },
    "Temple of Courage 1F Raised Platform Chest": {
        "region_id": "toc",
        "vanilla_item": "Small Key (Temple of Courage)",
        "stage_id": 0x1e,
        "floor_id": 0x0,
        "y": 0x1333,
        "x_min": 0x3a98,
        "dungeon": "Temple of Courage",
        "id": 116,
    },
    "Temple of Courage 1F Map Room Chest East": {
        "region_id": "toc map room",
        "vanilla_item": "Power Gem",
        "stage_id": 0x1e,
        "floor_id": 0x0,
        "z_max": -0xc350,
        "x_min": -0x11d28,
        "x_max": -0xd6d8,
        "dungeon": "Temple of Courage",
        "id": 117,
    },
    "Temple of Courage 1F Map Room Chest West": {
        "region_id": "toc map room",
        "vanilla_item": "Ship Part",
        "stage_id": 0x1e,
        "floor_id": 0x0,
        "z_max": -0xc350,
        "x_max": -0x11d28,
        "dungeon": "Temple of Courage",
        "id": 118,
    },
    "Temple of Courage 1F Pols Voice Key": {
        "region_id": "toc 1f west",
        "vanilla_item": "Small Key (Temple of Courage)",
        "stage_id": 0x1e,
        "floor_id": 0x0,
        "y": 0x1333,
        "x_max": 0x0,
        "dungeon": "Temple of Courage",
        "id": 119,
    },
    "Temple of Courage 2F Beamos Maze Chest": {
        "region_id": "toc 2f beamos",
        "vanilla_item": "Square Crystal (Temple of Courage)",
        "stage_id": 0x1e,
        "floor_id": 0x2,
        "z_max": -0x7530,
        "x_max": -0xc350,
        "dungeon": "Temple of Courage",
        "id": 120,
    },
    "Temple of Courage B1 Maze Chest": {
        "region_id": "toc b1 maze",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x1e,
        "floor_id": 0x1,
        "x_min": -0x7530,
        "x_max": 0x0,
        "dungeon": "Temple of Courage",
        "id": 121,
    },
    "Temple of Courage B1 Bow Chest": {
        "region_id": "toc b1 maze",
        "vanilla_item": "Bow (Progressive)",
        "stage_id": 0x1e,
        "floor_id": 0x1,
        "x_max": -0x13880,
        "dungeon": "Temple of Courage",
        "id": 122,
    },
    "Temple of Courage 2F Moving Platform Chest": {
        "region_id": "toc 2f platforms",
        "vanilla_item": "Power Gem",
        "stage_id": 0x1e,
        "floor_id": 0x2,
        "x_max": -0x1388,
        "x_min": -0x4e20,
        "z_max": 0xc350,
        "z_min": 0x7530,
        "dungeon": "Temple of Courage",
        "id": 123,
    },
    "Temple of Courage 2F Spike Corridor Chest": {
        "region_id": "toc 2f spike corridor",
        "vanilla_item": "Treasure",
        "item_override": "Spirit of Courage (Progressive)",
        "stage_id": 0x1e,
        "floor_id": 0x2,
        "x_min": 0x14c08,
        "z_min": 0x7530,
        "dungeon": "Temple of Courage",
        "id": 124,
    },
    "Temple of Courage B1 Torch Room Secret Chest": {
        "region_id": "toc torches chest",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0x1e,
        "floor_id": 0x1,
        "x_min": 0x11170,
        "dungeon": "Temple of Courage",
        "id": 125,
    },
    "Temple of Courage 1F Pols Voice Key 2": {
        "region_id": "toc pols 2",
        "vanilla_item": "Small Key (Temple of Courage)",
        "stage_id": 0x1e,
        "floor_id": 0x0,
        "x_min": 0x11170,
        "z_max": -0x7530,
        "dungeon": "Temple of Courage",
        "id": 126,
    },
    "Temple of Courage 2F Boss Key Chest": {
        "region_id": "toc bk chest",
        "vanilla_item": "Boss Key (Temple of Courage)",
        "stage_id": 0x1e,
        "floor_id": 0x2,
        "x_min": 0x11170,
        "z_max": -0x7530,
        "dungeon": "Temple of Courage",
        "id": 127,
    },
    "Temple of Courage 3F Before Boss Chest": {
        "region_id": "toc before boss chest",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x1e,
        "floor_id": 0x3,
        "dungeon": "Temple of Courage",
        "id": 128,
    },
    "Crayk Boss Reward": {
        "region_id": "post toc",
        "vanilla_item": "Spirit of Courage (White)",
        "item_override": "Rare Metal",
        "stage_id": 0x2c,
        "floor_id": 0x0,
        "address": 0x1b557f,
        "value": 0x80,
        "dungeon": "Temple of Courage",
        "boss_reward_location": True,
        "delay_reset": True,
        "id": 129,
    },
    "Crayk Sand of Hours": {
        "region_id": "post toc",
        "vanilla_item": "Sand of Hours (Boss)",
        "stage_id": 0x2c,
        "floor_id": 0x0,
        "address": 0x1b557f,
        "value": 0x80,
        "dungeon": "Temple of Courage",
        "delay_reset": True,
        "id": 130,
    },
    "Crayk Heart Container": {
        "region_id": "post toc",
        "vanilla_item": "Heart Container",
        "stage_id": 0x2c,
        "floor_id": 0x0,
        "dungeon": "Temple of Courage",
        "id": 131,
    },

    # ========== Spirit Island ============

    "Spirit Island Outside Chest": {
        "region_id": "spirit island",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x17,
        "floor_id": 0x0,
        "y": 0x0,
        "x_min": -0x1f40,
        "id": 132,
    },
    "Spirit Island Gauntlet Chest": {
        "region_id": "spirit island gauntlet",
        "vanilla_item": "Power Gem",
        "stage_id": 0x17,
        "floor_id": 0x0,
        "y": 0x2666,
        "id": 133,
    },
    "Spirit Island Power Upgrade Level 1": {
        "region_id": "spirit power 1",
        "vanilla_item": "Spirit of Power (Progressive)",
        "stage_id": 0x17,
        "floor_id": 0x1,
        "address": 0x1ba647,
        "value": 0x1,
        "id": 134,
    },
    "Spirit Island Power Upgrade Level 2": {
        "region_id": "spirit power 2",
        "vanilla_item": "Spirit of Power (Progressive)",
        "stage_id": 0x17,
        "floor_id": 0x1,
        "address": 0x1ba647,
        "value": 0x8,
        "id": 135,
    },
    "Spirit Island Wisdom Upgrade Level 1": {
        "region_id": "spirit wisdom 1",
        "vanilla_item": "Spirit of Wisdom (Progressive)",
        "stage_id": 0x17,
        "floor_id": 0x1,
        "address": 0x1ba647,
        "value": 0x2,
        "id": 136,
    },
    "Spirit Island Wisdom Upgrade Level 2": {
        "region_id": "spirit wisdom 2",
        "vanilla_item": "Spirit of Wisdom (Progressive)",
        "stage_id": 0x17,
        "floor_id": 0x1,
        "address": 0x1ba647,
        "value": 0x10,
        "id": 137,
    },
    "Spirit Island Courage Upgrade Level 1": {
        "region_id": "spirit courage 1",
        "vanilla_item": "Spirit of Courage (Progressive)",
        "stage_id": 0x17,
        "floor_id": 0x1,
        "address": 0x1ba646,
        "value": 0x80,
        "id": 138,
    },
    "Spirit Island Courage Upgrade Level 2": {
        "region_id": "spirit courage 2",
        "vanilla_item": "Spirit of Courage (Progressive)",
        "stage_id": 0x17,
        "floor_id": 0x1,
        "address": 0x1ba647,
        "value": 0x4,
        "id": 139,
    },

    # ========== Ocean NW ============

    "Ocean NW Golden Frog N": {
        "region_id": "nw ocean frog n",
        "vanilla_item": "Golden Frog Glyph N",
        "stage_id": 0x0,
        "floor_id": 0x1,
        "conditional": True,
        "id": 140,
    },
    "Ocean NW Prince of Red Lion Combat Reward": {
        "region_id": "porl item",
        "vanilla_item": "Heart Container",
        "stage_id": 0x7,
        "floor_id": 0x0,
        "address": 0x1b55a4,
        "value": 0x40,
        "delay_reset": True,
        "conditional": True,
        "id": 141,
    },

    # ========== Gust Island ============

    "Isle of Gust Hideout Chest": {
        "region_id": "gust hideout",
        "vanilla_item": "Courage Gem",
        "stage_id": 0xe,
        "floor_id": 0xa,
        "id": 142,
    },
    "Isle of Gust Miblin Cave North Chest": {
        "region_id": "gust cave damage",
        "vanilla_item": "Treasure Map #7 (Gusts E)",
        "stage_id": 0xe,
        "floor_id": 0xb,
        "z_max": -0x55f0,
        "id": 143,
    },
    "Isle of Gust Miblin Cave South Chest": {
        "region_id": "gust cave",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0xe,
        "floor_id": 0xb,
        "z_min": -0x55f0,
        "id": 144,
    },
    "Isle of Gust East Cliff Dig": {
        "region_id": "gust cliffs dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0xe,
        "floor_id": 0x0,
        "y": 0x4ccd,
        "conditional": True,
        "id": 145,
    },
    "Isle of Gust West Cliff Chest": {
        "region_id": "gust west chest",
        "vanilla_item": "Power Gem",
        "stage_id": 0xe,
        "floor_id": 0x0,
        "y": 0x2666,
        "id": 146,
    },
    "Isle of Gust NW Dig": {
        "region_id": "gust nw dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0xe,
        "floor_id": 0x1,
        "y": 0x2666,
        "x_max": -0x14c08,
        "conditional": True,
        "id": 147,
    },
    "Isle of Gust Sandworm Chest": {
        "region_id": "gust sandworms",
        "vanilla_item": "Treasure Map #8 (Mercay SE)",
        "stage_id": 0xe,
        "floor_id": 0x1,
        "y": 0x2666,
        "z_min": -0x7530,
        "id": 148,
    },

    # ========== Temple of Wind ============

    "Temple of Wind B1 SE Corner Chest": {
        "region_id": "tow b1",
        "vanilla_item": "Treasure",
        "item_override": "Spirit of Wisdom (Progressive)",
        "stage_id": 0x1d,
        "floor_id": 0x1,
        "x_min": 0x13880,
        "dungeon": "Temple of Wind",
        "id": 149,
    },
    "Temple of Wind B1 Ledge Chest": {
        "region_id": "tow b1",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x1d,
        "floor_id": 0x1,
        "y": 0x1333,
        "dungeon": "Temple of Wind",
        "id": 150,
    },
    "Temple of Wind B2 Chest": {
        "region_id": "tow b2",
        "vanilla_item": "Power Gem",
        "stage_id": 0x1d,
        "floor_id": 0x2,
        "x_max": -0xfde8,
        "dungeon": "Temple of Wind",
        "id": 151,
    },
    "Temple of Wind B2 Bombable Wall Item": {
        "region_id": "tow b2 bombs",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x1d,
        "floor_id": 0x3,
        "dungeon": "Temple of Wind",
        "id": 152,
    },
    "Temple of Wind B1 Key Drop": {
        "region_id": "tow b2 dig",
        "vanilla_item": "Small Key (Temple of Wind)",
        "stage_id": 0x1d,
        "floor_id": 0x1,
        "y": 0x0,
        "dungeon": "Temple of Wind",
        "id": 153,
    },
    "Temple of Wind B2 Bomb Bag Chest": {
        "region_id": "tow b2 key",
        "vanilla_item": "Bombs (Progressive)",
        "stage_id": 0x1d,
        "floor_id": 0x2,
        "y": 0x1333,
        "dungeon": "Temple of Wind",
        "id": 154,
    },
    "Temple of Wind 1F Boss Key Chest": {
        "region_id": "tow bk chest",
        "vanilla_item": "Boss Key (Temple of Wind)",
        "stage_id": 0x1d,
        "floor_id": 0x0,
        "y": 0x1333,
        "dungeon": "Temple of Wind",
        "id": 155,
    },
    "Cyclok Sand of Hours": {
        "region_id": "post tow",
        "vanilla_item": "Sand of Hours (Boss)",
        "stage_id": 0x2a,
        "floor_id": 0x0,
        "address": 0x1b557f,
        "value": 0x40,
        "dungeon": "Temple of Wind",
        "delay_reset": True,
        "id": 156,
    },
    "Cyclok Boss Reward": {
        "region_id": "post tow",
        "vanilla_item": "Spirit of Wisdom (Progressive)",
        "item_override": "Rare Metal",
        "stage_id": 0x2a,
        "floor_id": 0x0,
        "address": 0x1b557f,
        "value": 0x40,
        "boss_reward_location": True,
        "dungeon": "Temple of Wind",
        "delay_reset": True,
        "id": 157,
    },
    "Cyclok Heart Container": {
        "region_id": "post tow",
        "vanilla_item": "Heart Container",
        "stage_id": 0x2a,
        "floor_id": 0x0,
        "dungeon": "Temple of Wind",
        "id": 158,
    },

    # ========== Bannan Island ============

    "Bannan Island Entrance Grapple Chest": {
        "region_id": "bannan grapple",
        "vanilla_item": "Power Gem",
        "stage_id": 0x14,
        "floor_id": 0x0,
        "z_min": 0x4e20,
        "id": 159,
    },
    "Bannan Island Wayfarer Dig": {
        "region_id": "bannan dig",
        "vanilla_item": "Treasure Map #21 (Molida NW)",
        "stage_id": 0x14,
        "floor_id": 0x0,
        "z_max": -0x7530,
        "x_max": 0x2710,
        "id": 160,
    },
    "Bannan Island Wayfarer Gift": {
        "region_id": "bannan wayfarer",
        "vanilla_item": "Fishing Rod",
        "item_override": "Nothing!",
        "stage_id": 0x14,
        "floor_id": 0x1,
        "address": 0x1b5581,
        "value": 0x8,
        "delay_reset": True,
        "id": 161,
    },
    "Bannan Island Wayfarer Give Loovar": {
        "region_id": "bannan loovar",
        "vanilla_item": "Big Catch Lure",
        "stage_id": 0x14,
        "floor_id": 0x1,
        "address": 0x1b55a4,
        "value": 0x1,
        "delay_reset": True,
        "conditional": True,
        "id": 162,
    },
    "Bannan Island Wayfarer Give Rusty Swordfish": {
        "region_id": "bannan rsf",
        "vanilla_item": "Ship Part",
        "item_override": "Swordfish Shadows",
        "stage_id": 0x14,
        "floor_id": 0x1,
        "address": 0x1b55a3,
        "value": 0x80,
        "delay_reset": True,
        "conditional": True,
        "id": 163,
    },
    "Bannan Island Wayfarer Give Legendary Neptoona": {
        "region_id": "bannan neptoona",
        "vanilla_item": "Heart Container",
        "stage_id": 0x14,
        "floor_id": 0x1,
        "address": 0x1b55a3,
        "value": 0x40,
        "delay_reset": True,
        "conditional": True,
        "id": 164,
    },
    "Bannan Island Wayfarer Give Stowfish": {
        "region_id": "bannan stowfish",
        "vanilla_item": "Ship Part",
        "item_override": "Fishing Rod",
        "stage_id": 0x14,
        "floor_id": 0x1,
        "address": 0x1b55a9,
        "value": 0x4,
        "delay_reset": True,
        "conditional": True,
        "id": 165,
    },
    "Bannan Island Give Letter to Joanne": {
        "region_id": "bannan letter",
        "stage_id": 0x14,
        "floor_id": 0x1,
        "vanilla_item": "Wisdom Gem",
        "item_override": "Jolene's Letter",
        "address": 0x1b558f,
        "value": 0x2,
        "id": 321,
    },
    "Bannan Island East Grapple Chest East": {
        "region_id": "bannan east grapple",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x14,
        "floor_id": 0x0,
        "x_min": 0xea60,
        "z_max": -0x61a8,
        "sram_addr": 0x198,
        "sram_value": 0x4,
        "delay_pickup": ["Bannan Island East Grapple Dig", "Bannan Island East Grapple Chest West"],
        "id": 166,
    },
    "Bannan Island East Grapple Chest West": {
        "region_id": "bannan east grapple",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x14,
        "floor_id": 0x0,
        "x_min": 0xea60,
        "x_max": 0x186a0,
        "z_max": -0x61a8,
        "sram_addr": 0x198,
        "sram_value": 0x2,
        "delay_pickup": ["Bannan Island East Grapple Dig", "Bannan Island East Grapple Chest East"],
        "id": 167,
    },
    "Bannan Island East Grapple Dig": {
        "region_id": "bannan east grapple dig",
        "vanilla_item": "Treasure Map #22 (Harrow S)",
        "stage_id": 0x14,
        "floor_id": 0x0,
        "x_min": 0xea60,
        "x_max": 0x186a0,
        "z_max": -0x61a8,
        "id": 168,
    },
    "Bannan Island Cannon Game": {
        "region_id": "bannan cannon game",
        "vanilla_item": "Bombs (Progressive)",
        "stage_id": 0x14,
        "floor_id": 0x0,
        "address": 0x1b55aa,
        "value": 0x40,
        "delay_reset": True,
        "conditional": True,
        "id": 169,
    },
    "Bannan Island Wayfarer Trade Quest Chest": {
        "region_id": "bannan scroll",
        "vanilla_item": "Swordsman's Scroll",
        "stage_id": 0x14,
        "floor_id": 0x1,
        "address": 0x1b5592,
        "value": 0x10,
        "id": 170,
    },

    # ========== Uncharted Island ============

    "Uncharted Island Eye Dig": {
        "region_id": "uncharted dig",
        "vanilla_item": "Treasure Map #6 (Bannan W)",
        "stage_id": 0x1a,
        "floor_id": 0x0,
        "x_min": -0x124f8,
        "id": 171,
    },
    "Uncharted Island Grapple Chest": {
        "region_id": "uncharted grapple",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x1a,
        "floor_id": 0xa,
        "id": 172,
    },
    "Uncharted Island Cyclone Slate": {
        "region_id": "uncharted inner cave",
        "vanilla_item": "Cyclone Slate",
        "stage_id": 0x1a,
        "floor_id": 0xb,
        "address": 0x1b55a2,
        "value": 0x40,
        "id": 173,
    },

    # ========== Zauz's Island ============

    "Zauz's Island Cuccoo Chest": {
        "region_id": "zauz",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0x16,
        "floor_id": 0x0,
        "y": 0x1333,
        "id": 174,
    },
    "Zauz's Island Secret Dig": {
        "region_id": "zauz dig",
        "vanilla_item": "Treasure Map #5 (Molida N)",
        "stage_id": 0x16,
        "floor_id": 0x0,
        "y": 0x0,
        "id": 175,
    },
    "Zauz's Island Triforce Crest": {
        "region_id": "zauz crest",
        "vanilla_item": "Nothing!",
        "item_override": "Triforce Crest",
        "stage_id": 0x16,
        "floor_id": 0xa,
        "address": 0x1b55ab,
        "conditional": True,
        "value": 0x10,
        "post_dungeon": "Ghost Ship",
        "id": 176,
    },
    "Zauz's Island Phantom Blade": {
        "region_id": "zauz blade",
        "vanilla_item": "Phantom Blade",
        "stage_id": 0x16,
        "floor_id": 0xa,
        "address": 0x1b5592,
        "value": 0x20,
        "id": 177,
    },

    # ========== Ghost Ship ============

    "Ghost Ship B1 Entrance Chest": {
        "region_id": "ghost ship",
        "stage_id": 0x29,
        "floor_id": 0x0,
        "vanilla_item": "Treasure",
        "x_min": 0x1388,
        "z_min": 0x1388,
        "dungeon": "Ghost Ship",
        "id": 178,
    },
    "Ghost Ship B1 Second Sister Chest": {
        "region_id": "ghost ship barrel",
        "stage_id": 0x29,
        "floor_id": 0x0,
        "vanilla_item": "Triangle Crystal (Ghost Ship)",
        "x_min": 0xea60,
        "z_max": -0x1388,
        "dungeon": "Ghost Ship",
        "id": 179,
    },
    "Ghost Ship B2 Third Sister Right Chest": {
        "region_id": "ghost ship b2 chests",
        "stage_id": 0x29,
        "floor_id": 0x1,
        "vanilla_item": "Red Potion",
        "x_min": -0xc350,
        "x_max": -0x7530,
        "dungeon": "Ghost Ship",
        "sram_addr": 0xb14,
        "sram_value": 0x4,
        "delay_pickup": "Ghost Ship B2 Third Sister Left Chest",
        "id": 180,
    },
    "Ghost Ship B2 Third Sister Left Chest": {
        "region_id": "ghost ship b2 chests",
        "stage_id": 0x29,
        "floor_id": 0x1,
        "vanilla_item": "Rupoor (-10)",
        "x_max": -0x7530,
        "dungeon": "Ghost Ship",
        "sram_addr": 0xb14,
        "sram_value": 0x1,
        "id": 181,
    },
    "Ghost Ship B2 Spike Chest": {
        "region_id": "ghost ship b2 chests",
        "stage_id": 0x29,
        "floor_id": 0x1,
        "vanilla_item": "Round Crystal (Ghost Ship)",
        "z_min": -0x1f40,
        "dungeon": "Ghost Ship",
        "id": 182,
    },
    "Ghost Ship B3 Chest": {
        "region_id": "ghost ship b3",
        "stage_id": 0x29,
        "floor_id": 0x2,
        "vanilla_item": "Red Potion",
        "dungeon": "Ghost Ship",
        "id": 183,
    },
    "Cubus Sisters Ghost Key": {
        "region_id": "ghost ship post cubus",
        "stage_id": 0x30,
        "floor_id": 0x0,
        "vanilla_item": "Ghost Key",
        "dungeon": "Ghost Ship",
        "id": 184,
    },
    "Cubus Sisters Heart Container": {
        "region_id": "ghost ship post cubus",
        "stage_id": 0x30,
        "floor_id": 0x0,
        "address": 0x1b55ab,
        "value": 0x8,
        "vanilla_item": "Heart Container",
        "dungeon": "Ghost Ship",
        "id": 185,
    },
    "Ghost Ship Rescue Tetra": {
        "region_id": "ghost ship tetra",
        "stage_id": 0x4,
        "floor_id": 0x0,
        "address": 0x1b559b,
        "value": 0x2,
        "vanilla_item": "Nothing!",
        "item_override": "Rare Metal",
        "dungeon": "Ghost Ship",
        "id": 186,
    },

    # ========== Ocean SE ============

    "Ocean SE Golden Frog Omega": {
        "region_id": "se ocean frogs",
        "vanilla_item": "Golden Frog Glyph Omega",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "z_min": 0x3d090,
        "id": 187,
    },
    "Ocean SE Golden Frog W": {
        "region_id": "se ocean frogs",
        "vanilla_item": "Golden Frog Glyph W",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "z_max": 0x3d090,
        "id": 188,
    },
    "Ocean Miniblin Pirate Ambush Item": {
        "region_id": "pirate ambush",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x4,
        "floor_id": 0x0,
        "address": 0x1b5595,
        "value": 0x80,
        "post_dungeon": "Ghost Ship",
        "id": 189,
    },

    # ========== Goron Island ============

    "Goron Island Yellow Chu Item": {
        "region_id": "goron chus",
        "stage_id": 0x10,
        "floor_id": 0x2,
        "vanilla_item": "Treasure Map #16 (Goron NE)",
        "address": 0x1ba652,
        "value": 0x10,
        "id": 190,
    },
    "Goron Island Grapple Chest": {
        "region_id": "goron grapple",
        "stage_id": 0x10,
        "floor_id": 0x2,
        "vanilla_item": "Courage Gem",
        "z_min": 0x124f8,
        "x_max": -0x15f90,
        "id": 191,
    },
    "Goron Island Goron Quiz": {
        "region_id": "goron quiz",
        "stage_id": 0x10,
        "floor_id": 0xa,
        "vanilla_item": "Wisdom Gem",
        "address": 0x1b558b,
        "value": 0x10,
        "id": 192,
    },
    "Goron Island North Bombchu Switch Chest": {
        "region_id": "goron maze chu chest",
        "stage_id": 0x10,
        "floor_id": 0x1,
        "vanilla_item": "Treasure Map #18 (Cannon S)",
        "x_min": 0x1adb0,
        "z_max": -0x1adb0,
        "id": 193,
    },
    "Goron Island North Dead End Chest": {
        "region_id": "goron maze north dead end",
        "stage_id": 0x10,
        "floor_id": 0x0,
        "vanilla_item": "Big Green Rupee (100)",
        "x_max": 0xc350,
        "id": 194,
    },
    "Goron Island North Spike Chest": {
        "region_id": "goron maze spike chest",
        "stage_id": 0x10,
        "floor_id": 0x1,
        "vanilla_item": "Power Gem",
        "x_max": 0x35000,
        "id": 195,
    },
    "Goron Island Chief Post Dungeon Item": {
        "region_id": "goron chief 2",
        "stage_id": 0x10,
        "floor_id": 0xa,
        "vanilla_item": "Big Red Rupee (200)",
        "address": 0x1b5593,
        "value": 0x2,
        "post_dungeon": "Goron Temple",
        "id": 196,
    },

    # ========== Goron Temple ============

    "Goron Temple 1F Switch Chest": {
        "region_id": "gt 2",
        "stage_id": 0x20,
        "floor_id": 0x0,
        "vanilla_item": "Treasure Map #17 (Frost S)",
        "y": 0x2666,
        "dungeon": "Goron Temple",
        "id": 197,
    },
    "Goron Temple 1F Bow Chest": {
        "region_id": "gt bow",
        "stage_id": 0x20,
        "floor_id": 0x0,
        "vanilla_item": "Red Rupee (20)",
        "y": 0x1333,
        "dungeon": "Goron Temple",
        "id": 198,
    },
    "Goron Temple B1 Bombchu Bag Chest": {
        "region_id": "gt b1",
        "stage_id": 0x20,
        "floor_id": 0x1,
        "vanilla_item": "Bombchus (Progressive)",
        "y": 0x1333,
        "dungeon": "Goron Temple",
        "id": 199,
    },
    "Goron Temple B1 Kill Eyeslugs Chest": {
        "region_id": "gt b1",
        "stage_id": 0x20,
        "floor_id": 0x1,
        "vanilla_item": "Treasure",
        "y": 0x0,
        "z_min": 0x7530,
        "dungeon": "Goron Temple",
        "id": 200,
    },
    "Goron Temple B3 Kill Miblins Chest": {
        "region_id": "gt b3",
        "stage_id": 0x20,
        "floor_id": 0x3,
        "vanilla_item": "Red Rupee (20)",
        "x_max": -0x4e20,
        "dungeon": "Goron Temple",
        "id": 201,
    },
    "Goron Temple B2 Kill Eyeslugs Chest": {
        "region_id": "gt bk chest",
        "stage_id": 0x20,
        "floor_id": 0x2,
        "vanilla_item": "Treasure",
        "y": 0x0,
        "dungeon": "Goron Temple",
        "id": 202,
    },
    "Goron Temple B2 Boss Key Chest": {
        "region_id": "gt bk chest",
        "stage_id": 0x20,
        "floor_id": 0x2,
        "vanilla_item": "Boss Key (Goron Temple)",
        "y": 0x1333,
        "dungeon": "Goron Temple",
        "id": 203,
    },
    "Dongorongo Sand of Hours": {
        "region_id": "post gt",
        "stage_id": 0x2e,
        "floor_id": 0x0,
        "vanilla_item": "Sand of Hours (Boss)",
        "address": 0x1b559b,
        "value": 0x4,
        "dungeon": "Goron Temple",
        "delay_reset": True,
        "id": 204,
    },
    "Dongorongo Heart Container": {
        "region_id": "post gt",
        "stage_id": 0x2e,
        "floor_id": 0x0,
        "vanilla_item": "Heart Container",
        "dungeon": "Goron Temple",
        "id": 205,
    },
    "Dongorongo Boss Reward": {
        "region_id": "post gt",
        "stage_id": 0x20,
        "floor_id": 0xa,
        "vanilla_item": "Crimzonine",
        "item_override": "Rare Metal",
        "boss_reward_location": True,
        "dungeon": "Goron Temple",
        "id": 206,
    },

    # ========== Harrow Island ============

    "Harrow Island Dig 1": {
        "region_id": "harrow dig",
        "stage_id": 0x18,
        "floor_id": 0x0,
        "item_override": "Treasure Map #14 (Goron NW)",
        "vanilla_item": "Nothing!",
        "address": 0x1ba652,
        "value": 0x1,
        "conditional": True,
        "id": 207,
    },
    "Harrow Island Dig 2": {
        "region_id": "harrow dig",
        "stage_id": 0x18,
        "floor_id": 0x0,
        "item_override": "Treasure Map #15 (Goron W)",
        "vanilla_item": "Nothing!",
        "address": 0x1ba652,
        "value": 0x2,
        "conditional": True,
        "id": 208,
    },
    "Harrow Island Dig 3": {
        "region_id": "harrow dig 2",
        "stage_id": 0x18,
        "floor_id": 0x0,
        "item_override": "Treasure Map #26 (Ruins SW)",
        "vanilla_item": "Nothing!",
        "address": 0x1ba653,
        "value": 0x2,
        "conditional": True,
        "id": 209,
    },
    "Harrow Island Dig 4": {
        "region_id": "harrow dig 2",
        "stage_id": 0x18,
        "floor_id": 0x0,
        "item_override": "Treasure Map #25 (Dead E)",
        "vanilla_item": "Nothing!",
        "address": 0x1ba653,
        "value": 0x4,
        "conditional": True,
        "id": 210,
    },

    # ========== Dee Ess Island ============

    "Dee Ess Menu Button Dig": {
        "region_id": "ds dig",
        "stage_id": 0x1b,
        "floor_id": 0x0,
        "vanilla_item": "Courage Gem",
        "y": 0x0,
        "x_max": -0x61a8,
        "z_min": 0xafc8,
        "id": 211,
    },
    "Dee Ess Blow in Microphone Chest": {
        "region_id": "ds",
        "stage_id": 0x1b,
        "floor_id": 0x0,
        "vanilla_item": "Gold Rupee (300)",
        "y": 0x0,
        "x_max": -0x3a98,
        "z_min": 0x2710,
        "z_max": 0x7530,
        "id": 212,
    },
    "Dee Ess Left Speakers Dig SSW": {
        "region_id": "ds dig",
        "stage_id": 0x1b,
        "floor_id": 0x0,
        "vanilla_item": "Big Green Rupee (100)",
        "y": 0x2666,
        "x_min": -0x107ac,
        "x_max": -0xc350,
        "conditional": True,
        "id": 213,
    },
    "Dee Ess Right Speakers Dig SE": {
        "region_id": "ds dig",
        "stage_id": 0x1b,
        "floor_id": 0x0,
        "vanilla_item": "Big Green Rupee (100)",
        "y": 0x2666,
        "x_min": 0xafc8,
        "conditional": True,
        "id": 214,
    },
    "Dee Ess Left Speakers Dig West": {
        "region_id": "ds dig",
        "stage_id": 0x1b,
        "floor_id": 0x0,
        "vanilla_item": "Big Green Rupee (100)",
        "y": 0x2666,
        "x_max": -0x107ac,
        "conditional": True,
        "id": 215,
    },
    "Dee Ess Win Goron Game": {
        "region_id": "ds race",
        "stage_id": 0x1b,
        "floor_id": 0x0,
        "vanilla_item": "Bombchus (Progressive)",
        "address": 0x1b559f,
        "value": 0x20,
        "post_dungeon": "Goron Temple",
        "delay_reset": True,
        "conditional": True,
        "id": 216,
    },
    "Dee Ess Eye Brute Chest": {
        "region_id": "ds combat",
        "stage_id": 0x1b,
        "floor_id": 0x0,
        "vanilla_item": "Courage Gem",
        "y": 0x0,
        "z_max": -0x4e20,
        "id": 217,
    },

    # ========== Frost Island ============

    "Isle of Frost Nobodo Grapple Chest": {
        "region_id": "frost grapple",
        "stage_id": 0xf,
        "floor_id": 0x0,
        "vanilla_item": "Wisdom Gem",
        "y": 0x1333,
        "x_max": -150000,
        "id": 218,
    },
    "Isle of Frost Chief House Dig": {
        "region_id": "frost dig",
        "stage_id": 0xf,
        "floor_id": 0x0,
        "vanilla_item": "Big Green Rupee (100)",
        "y": 0x2666,
        "conditional": True,
        "id": 219,
    },
    "Isle of Frost Estate Sign Dig": {
        "region_id": "frost estate dig",
        "stage_id": 0xf,
        "floor_id": 0x2,
        "vanilla_item": "Big Red Rupee (200)",
        "z_min": -0x4e20,
        "conditional": True,
        "id": 220,
    },
    "Isle of Frost Estate Fofo Dig (SE)": {
        "region_id": "frost estate dig",
        "stage_id": 0xf,
        "floor_id": 0x2,
        "vanilla_item": "Big Green Rupee (100)",
        "z_min": -0xea60,
        "z_max": -0x7530,
        "x_min": -0x1c138,
        "x_max": -0x14c08,
        "conditional": True,
        "id": 221,
    },
    "Isle of Frost Estate Dobo Dig (SW)": {
        "region_id": "frost estate dig",
        "stage_id": 0xf,
        "floor_id": 0x2,
        "vanilla_item": "Big Green Rupee (100)",
        "z_min": -0xea60,
        "z_max": -0x7530,
        "x_min": -0x2ab98,
        "x_max": -0x23668,
        "conditional": True,
        "id": 222,
    },
    "Isle of Frost Estate SW Island Dig": {
        "region_id": "frost estate dig",
        "stage_id": 0xf,
        "floor_id": 0x2,
        "vanilla_item": "Treasure Map #19 (Gusts NE)",
        "x_max": -0x2d2a8,
        "id": 223,
    },
    "Isle of Frost Estate SE Island Dig": {
        "region_id": "frost estate grapple dig",
        "stage_id": 0xf,
        "floor_id": 0x2,
        "vanilla_item": "Gold Rupee (300)",
        "x_min": -0xea60,
        "conditional": True,
        "id": 224,
    },
    "Isle of Frost Stand on Peg Gift": {
        "region_id": "frost",
        "stage_id": 0xf,
        "floor_id": 0x0,
        "vanilla_item": "Red Rupee (20)",
        "x_min": -67000,
        "y": 4915,
        "id": 329,
    },
    "Isle of Frost Ice Field South Ledge West Chest": {
        "region_id": "frost field upper chests",
        "stage_id": 0xf,
        "floor_id": 0x3,
        "vanilla_item": "Red Rupee (20)",
        "y": 0x399a,
        "sram_addr": 0x544,
        "sram_value": 0x2,
        "id": 225,
    },
    "Isle of Frost Ice Field South Ledge East Chest": {
        "region_id": "frost field upper chests",
        "stage_id": 0xf,
        "floor_id": 0x3,
        "vanilla_item": "Red Rupee (20)",
        "y": 0x399a,
        "sram_addr": 0x544,
        "sram_value": 0x4,
        "id": 226,
    },
    "Isle of Frost Ice Field SE Ledge Chest": {
        "region_id": "frost field upper chests",
        "stage_id": 0xf,
        "floor_id": 0x3,
        "vanilla_item": "Big Green Rupee (100)",
        "y": 0x4ccd,
        "id": 227,
    },
    "Isle of Frost Ice Field East Ledge Chest": {
        "region_id": "frost field east ledge",
        "stage_id": 0xf,
        "floor_id": 0x3,
        "vanilla_item": "Power Gem",
        "y": 0x2666,
        "id": 228,
    },

    # ========== Temple of Ice ============

    "Temple of Ice 3F Corner Chest": {
        "region_id": "toi 3f",
        "stage_id": 0x1f,
        "floor_id": 0x1,
        "vanilla_item": "Red Potion",
        "z_max": -0x7530,
        "dungeon": "Temple of Ice",
        "id": 229,
    },
    "Temple of Ice 3F Switch State Chest": {
        "region_id": "toi 3f switch state",
        "stage_id": 0x1f,
        "floor_id": 0x1,
        "vanilla_item": "Wisdom Gem",
        "y": 0x1333,
        "dungeon": "Temple of Ice",
        "id": 230,
    },
    "Temple of Ice 3F Key Drop": {
        "region_id": "toi 3f boomerang key",
        "stage_id": 0x1f,
        "floor_id": 0x1,
        "vanilla_item": "Small Key (Temple of Ice)",
        "y": 0x2666,
        "dungeon": "Temple of Ice",
        "id": 231,
    },
    "Temple of Ice 2F Grappling Hook Chest": {
        "region_id": "toi 2f post arena",
        "stage_id": 0x1f,
        "floor_id": 0x3,
        "vanilla_item": "Grappling Hook",
        "dungeon": "Temple of Ice",
        "id": 232,
    },
    "Temple of Ice B1 Entrance Chest": {
        "region_id": "toi b1 south",
        "stage_id": 0x1f,
        "floor_id": 0x2,
        "x_max": -0x7530,
        "vanilla_item": "Yellow Potion",
        "dungeon": "Temple of Ice",
        "id": 233,
    },
    "Temple of Ice B1 SE Chest": {
        "region_id": "toi b1 right",
        "stage_id": 0x1f,
        "floor_id": 0x2,
        "vanilla_item": "Small Key (Temple of Ice)",
        "x_min": 0x11170,
        "z_min": 0xafc8,
        "dungeon": "Temple of Ice",
        "id": 234,
    },
    "Temple of Ice B1 Locked Room Chest": {
        "region_id": "toi b1 switch room",
        "stage_id": 0x1f,
        "floor_id": 0x2,
        "vanilla_item": "Wisdom Gem",
        "z_max": -0x4e20,
        "dungeon": "Temple of Ice",
        "id": 235,
    },
    "Temple of Ice B2 Bow Bounce Chest": {
        "region_id": "toi b2 bow",
        "stage_id": 0x1f,
        "floor_id": 0x5,
        "vanilla_item": "Small Key (Temple of Ice)",
        "z_max": -0xc350,
        "dungeon": "Temple of Ice",
        "id": 236,
    },
    "Temple of Ice B2 Fight Chest": {
        "region_id": "toi b2 east arena",
        "stage_id": 0x1f,
        "floor_id": 0x5,
        "vanilla_item": "Purple Potion",
        "x_min": 0x7530,
        "dungeon": "Temple of Ice",
        "id": 237,
    },
    "Temple of Ice B2 Boss Key Chest": {
        "region_id": "toi b2 bk chest",
        "stage_id": 0x1f,
        "floor_id": 0x5,
        "vanilla_item": "Boss Key (Temple of Ice)",
        "y": 0x1333,
        "dungeon": "Temple of Ice",
        "id": 238,
    },
    "Gleeok Sand of Hours": {
        "region_id": "beat gleeok",
        "stage_id": 0x2d,
        "floor_id": 0x0,
        "vanilla_item": "Sand of Hours (Boss)",
        "address": 0x1b559b,
        "value": 0x8,
        "dungeon": "Temple of Ice",
        "delay_reset": True,
        "id": 239,
    },
    "Gleeok Heart Container": {
        "region_id": "beat gleeok",
        "stage_id": 0x2d,
        "floor_id": 0x0,
        "vanilla_item": "Heart Container",
        "dungeon": "Temple of Ice",
        "id": 240,
    },
    "Gleeok Boss Reward": {
        "region_id": "beat gleeok",
        "stage_id": 0x1f,
        "floor_id": 0x6,
        "vanilla_item": "Azurine",
        "item_override": "Rare Metal",
        "boss_reward_location": True,
        "dungeon": "Temple of Ice",
        "id": 241,
    },

    # ========== Ocean NE ============

    "Ocean NE Golden Frog Square": {
        "region_id": "ne ocean frog",
        "vanilla_item": "Golden Frog Glyph Square",
        "stage_id": 0x0,
        "floor_id": 0x3,
        "conditional": True,
        "id": 242,
    },

    # ========== Dead Island ============

    "Isle of the Dead Rupoor Cave 1": {
        "region_id": "iotd rupoor",
        "vanilla_item": "Ship Part",
        "stage_id": 0x15,
        "floor_id": 0x2,
        "z_max": -0xd6d8,
        "x_max": 0x7d0,
        "sram_addr": 0x73c,
        "sram_value": 0x4,
        "delay_pickup": ["Isle of the Dead Rupoor Cave 3", "Isle of the Dead Rupoor Cave 2"],
        "id": 243,
    },
    "Isle of the Dead Rupoor Cave 4": {
        "region_id": "iotd rupoor",
        "vanilla_item": "Ship Part",
        "stage_id": 0x15,
        "floor_id": 0x2,
        "z_max": -0xd6d8,
        "x_min": -0xfa0,
        "sram_addr": 0x73c,
        "sram_value": 0x1,
        "delay_pickup": ["Isle of the Dead Rupoor Cave 3", "Isle of the Dead Rupoor Cave 2"],
        "id": 244,
    },
    "Isle of the Dead Rupoor Cave 2": {
        "region_id": "iotd rupoor",
        "vanilla_item": "Treasure Map #28 (Ruins NW)",
        "stage_id": 0x15,
        "floor_id": 0x2,
        "z_max": -0xd6d8,
        "x_max": 0x1f40,
        "sram_addr": 0x73c,
        "sram_value": 0x2,
        "delay_pickup": "Isle of the Dead Rupoor Cave 3",
        "id": 245,
    },
    "Isle of the Dead Rupoor Cave 3": {
        "region_id": "iotd rupoor",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x15,
        "floor_id": 0x2,
        "z_max": -0xd6d8,
        "x_min": 0x7d0,
        "sram_addr": 0x73c,
        "sram_value": 0x1,
        "delay_pickup": "Isle of the Dead Rupoor Cave 2",
        "id": 246,
    },
    "Isle of the Dead Face Cave Chest": {
        "region_id": "iotd tunnel cave",
        "vanilla_item": "Power Gem",
        "stage_id": 0x15,
        "floor_id": 0x4,
        "id": 247,
    },
    "Isle of the Dead Face Chest": {
        "region_id": "iotd face",
        "vanilla_item": "Treasure Map #29 (Maze W)",
        "stage_id": 0x15,
        "floor_id": 0x0,
        "y": 0x4ccd,
        "id": 248,
    },
    "Isle of the Dead Regal Necklace Chest": {
        "region_id": "iotd crown",
        "vanilla_item": "Regal Necklace",
        "stage_id": 0x15,
        "floor_id": 0x0,
        "y": 0x2666,
        "id": 249,
        "delay_reset": True
    },

    # ========== Ruins Island ============

    "Isle of Ruins Like-Like Dig": {
        "region_id": "ruins nw dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x11,
        "floor_id": 0x1,
        "additional_rooms": [0x1201],
        "y": 0x1333,
        "x_max": -0x30d40,
        "z_max": -0x9c40,
        "conditional": True,
        "id": 250,
    },
    "Isle of Ruins Upper Bonk Tree": {
        "region_id": "ruins nw across bridge",
        "vanilla_item": "Big Red Rupee (200)",
        "stage_id": 0x11,
        "floor_id": 0x1,
        "additional_rooms": [0x1201],
        "y": 0x4ccd,
        "sram_addr": 0x001A4C,
        "sram_value": 1,
        "id": 251,
    },
    "Isle of Ruins Doylan's Item": {
        "region_id": "doylan chamber",
        "vanilla_item": "King's Key",
        "stage_id": 0x22,
        "floor_id": 0x1,
        "address": 0x1b5585,
        "value": 0x4,
        "id": 252,
    },
    "Isle of Ruins Lower Water Cave Chest": {
        "region_id": "ruins nw cave",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0x12,
        "floor_id": 0xb,
        "id": 253,
    },
    "Isle of Ruins Maze Chest": {
        "region_id": "ruins nw maze lower chest",
        "vanilla_item": "Power Gem",
        "stage_id": 0x12,
        "floor_id": 0x1,
        "y": 0x0,
        "id": 254,
    },
    "Isle of Ruins Dodge Boulders Chest": {
        "region_id": "ruins ne lower",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x12,
        "floor_id": 0x2,
        "y": 0x0,
        "additional_rooms": [0x1102],
        "x_min": 0xd6d8,
        "x_max": 0x124f8,
        "z_max": -0x124f8,
        "id": 255,
    },
    "Isle of Ruins Push Boulder Chest": {
        "region_id": "ruins ne secret chest",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0x12,
        "floor_id": 0x2,
        "additional_rooms": [0x1102],
        "y": 0x0,
        "z_min": -0x7530,
        "id": 256,
    },
    "Isle of Ruins Outside Doylan's Temple Chest": {
        "region_id": "ruins ne behind temple",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x12,
        "floor_id": 0x2,
        "additional_rooms": [0x1102],
        "y": 0x0,
        "x_min": 0x29810,
        "z_max": -0x124f8,
        "id": 257,
    },
    "Isle of Ruins Outside Mutoh's Temple Chest": {
        "region_id": "ruins ne behind temple",
        "vanilla_item": "Big Red Rupee (200)",
        "stage_id": 0x11,
        "floor_id": 0x2,
        "additional_rooms": [0x1202],
        "y": 0x0,
        "x_min": 0x13880,
        "x_max": 0x19a28,
        "z_max": -0x249f0,
        "id": 258,
    },
    "Isle of Ruins NW Lower Water Bonk Tree": {
        "region_id": "ruins nw port cliff tree",
        "vanilla_item": "Big Red Rupee (200)",
        "stage_id": 0x12,
        "floor_id": 0x1,
        "y": 4915,
        "x_min": -44500,
        "z_min": -35000,
        "id": 328,
    },

    # ========== Mutoh's Temple ============

    "Mutoh's Temple 2F Like-Like Maze Chest": {
        "region_id": "mutoh landing",
        "vanilla_item": "Treasure",
        "stage_id": 0x21,
        "floor_id": 0x1,
        "dungeon": "Mutoh's Temple",
        "id": 259,
    },
    "Mutoh's Temple 3F Hammer Chest": {
        "region_id": "mutoh landing",
        "vanilla_item": "Hammer",
        "stage_id": 0x21,
        "floor_id": 0x2,
        "dungeon": "Mutoh's Temple",
        "id": 260,
    },
    "Mutoh's Temple B2 Spike Roller Chest": {
        "region_id": "mutoh hammer",
        "vanilla_item": "Courage Gem",
        "stage_id": 0x21,
        "floor_id": 0x4,
        "y": 0x0,
        "dungeon": "Mutoh's Temple",
        "id": 261,
    },
    "Mutoh's Temple B2 Ledge Chest": {
        "region_id": "mutoh hammer",
        "vanilla_item": "Small Key (Mutoh's Temple)",
        "stage_id": 0x21,
        "floor_id": 0x4,
        "y": 0x1333,
        "dungeon": "Mutoh's Temple",
        "id": 262,
    },
    "Mutoh's Temple B1 Lower Water Chest": {
        "region_id": "mutoh water",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x21,
        "floor_id": 0x3,
        "y": 0x1333,
        "z_min": -0x61a8,
        "dungeon": "Mutoh's Temple",
        "id": 263,
    },
    "Mutoh's Temple B1 Push Boulder Chest": {
        "region_id": "mutoh water",
        "vanilla_item": "Small Key (Mutoh's Temple)",
        "stage_id": 0x21,
        "floor_id": 0x3,
        "y": 0x1333,
        "z_max": -0x61a8,
        "dungeon": "Mutoh's Temple",
        "id": 264,
    },
    "Mutoh's Temple B1 Boss Key Chest": {
        "region_id": "mutoh bk chest",
        "vanilla_item": "Boss Key (Mutoh's Temple)",
        "stage_id": 0x21,
        "floor_id": 0x3,
        "y": 0x4ccd,
        "dungeon": "Mutoh's Temple",
        "id": 265,
    },
    "Eox Sand of Hours": {
        "region_id": "mutoh post eox",
        "vanilla_item": "Sand of Hours (Boss)",
        "stage_id": 0x2f,
        "floor_id": 0x0,
        "address": 0x1b559b,
        "value": 0x10,
        "dungeon": "Mutoh's Temple",
        "delay_reset": True,
        "id": 266,
    },
    "Eox Heart Container": {
        "region_id": "mutoh post eox",
        "vanilla_item": "Heart Container",
        "stage_id": 0x2f,
        "floor_id": 0x0,
        "dungeon": "Mutoh's Temple",
        "id": 267,
    },
    "Eox Boss Reward": {
        "region_id": "mutoh post eox",
        "vanilla_item": "Aquanine",
        "item_override": "Rare Metal",
        "stage_id": 0x21,
        "floor_id": 0x6,
        "boss_reward_location": True,
        "dungeon": "Mutoh's Temple",
        "id": 268,
    },

    # ========== Maze Island ============

    "Maze Island Maze Chest": {
        "region_id": "maze east",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0x19,
        "floor_id": 0x0,
        "y": 0x0,
        "x_min": 0x9c40,
        "z_max": 0x5dc0,
        "z_min": -0x6590,
        "id": 269,
    },
    "Maze Island SE Dig": {
        "region_id": "maze dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x19,
        "floor_id": 0x0,
        "y": 0x0,
        "x_min": 0x13880,
        "z_min": 0x11170,
        "conditional": True,
        "sram_addr": 0x1c1,
        "sram_value": 0x8,
        "id": 270,
    },
    "Maze Island NE Dig": {
        "region_id": "maze dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x19,
        "floor_id": 0x0,
        "y": 0x0,
        "x_min": 0x9c40,
        "z_max": -0xea60,
        "conditional": True,
        "sram_addr": 0x1c1,
        "sram_value": 0x10,
        "id": 271,
    },
    "Maze Island NW Dig": {
        "region_id": "maze dig",
        "vanilla_item": "Big Green Rupee (100)",
        "stage_id": 0x19,
        "floor_id": 0x0,
        "y": 0x0,
        "x_max": -0x3a98,
        "z_max": -0xea60,
        "conditional": True,
        "sram_addr": 0x1c1,
        "sram_value": 0x80,
        "id": 272,
    },
    "Maze Island Beginner": {
        "region_id": "maze",
        "vanilla_item": "Wisdom Gem",
        "stage_id": 0x19,
        "floor_id": 0x0,
        "address": 0x1b558e,
        "value": 0x1,
        "conditional": True,
        "id": 273,
    },
    "Maze Island Normal": {
        "region_id": "maze normal",
        "vanilla_item": "Treasure Map #27 (Maze E)",
        "stage_id": 0x19,
        "floor_id": 0x0,
        "address": 0x1b5598,
        "value": 0x40,
        "conditional": True,
        "id": 274,
    },
    "Maze Island Expert": {
        "region_id": "maze expert",
        "vanilla_item": "Heart Container",
        "stage_id": 0x19,
        "floor_id": 0x0,
        "address": 0x1b5598,
        "value": 0x80,
        "conditional": True,
        "id": 275,
    },
    "Maze Island Bonus Reward": {
        "region_id": "maze expert",
        "vanilla_item": "Gold Rupee (300)",
        "stage_id": 0x19,
        "floor_id": 0x0,
        "x_max": -0xc350,
        "z_min": 0xc350,
        "conditional": True,
        "id": 276,
    },

    # ========== Goal Locations ============

    "GOAL: Beat Bellumbeck": {
        "region_id": "goal",
        "vanilla_item": "Nothing!",
        "stage_id": 0x36,
        "floor_id": 0x0,
        "conditional": True,
        "id": 277,
    },
    "GOAL: Triforce Door": {
        "region_id": "goal",
        "vanilla_item": "Nothing!",
        "stage_id": 0x25,
        "floor_id": 0x9,
        "conditional": True,
        "id": 278,
    },

    # 	# ========== Traveller's Ships ============

    "Ocean NE Man Of Smiles Item 1": {
        "region_id": "ne ocean combat",
        "vanilla_item": "Hero's New Clothes",
        "stage_id": 0x6,
        "floor_id": 0x0,
        "address": 0x1b558f,
        "value": 0x20,
        "id": 279,
    },
    "Ocean NE Man Of Smiles Item 2": {
        "region_id": "ne ocean combat",
        "vanilla_item": "Treasure Map #24 (Ruins W)",
        "stage_id": 0x6,
        "floor_id": 0x0,
        "address": 0x1b558f,
        "value": 0x20,
        "id": 280,
    },
    "Ocean NE Man of Smiles Prize Postcard": {
        "region_id": "ne ocean combat",
        "vanilla_item": "Prize Postcard",
        "stage_id": 0x6,
        "floor_id": 0x0,
        "address": 0x1b558f,
        "value": 0x8,
        "id": 327,
        "conditional": True
    },
    "Ocean NW Prince of Red Lions Trade Quest Item": {
        "region_id": "porl trade",
        "vanilla_item": "Kaleidoscope",
        "stage_id": 0x7,
        "floor_id": 0x0,
        "address": 0x1b5590,
        "value": 0x8,
        "id": 281,
    },
    "Ocean SW Nyave Trade Quest Item": {
        "region_id": "sw ocean nyave trade",
        "vanilla_item": "Wood Heart",
        "stage_id": 0xa,
        "floor_id": 0x0,
        "address": 0x1b5590,
        "value": 0x80,
        "id": 282,
    },
    "Ocean SE Hoiger Howgendoogen Trade Quest Item": {
        "region_id": "se ocean trade",
        "vanilla_item": "Guard Notebook",
        "stage_id": 0x9,
        "floor_id": 0x0,
        "address": 0x1b5590,
        "value": 0x10,
        "id": 283,
    },

    # ========== Fishing ============

    "Fishing Catch Skippyjack": {
        "region_id": "fishing",
        "vanilla_item": "Fish: Skippyjack",
        "stage_id": 0x2,
        "floor_id": 0x0,
        "address": 0x1ba5b4,
        "value": 0x1,
        "conditional": True,
        "id": 284,
    },
    "Fishing Catch Toona": {
        "region_id": "fishing",
        "vanilla_item": "Fish: Toona",
        "stage_id": 0x2,
        "floor_id": 0x0,
        "address": 0x1ba5b5,
        "value": 0x1,
        "conditional": True,
        "id": 285,
    },
    "Fishing Catch Loovar": {
        "region_id": "fishing",
        "vanilla_item": "Fish: Loovar",
        "stage_id": 0x2,
        "floor_id": 0x0,
        "address": 0x1ba5b6,
        "value": 0x1,
        "conditional": True,
        "id": 286,
    },
    "Fishing Catch Rusty Swordfish": {
        "region_id": "fishing rsf",
        "vanilla_item": "Fish: Rusty Swordfish",
        "stage_id": 0x2,
        "floor_id": 0x0,
        "address": 0x1ba5b7,
        "value": 0x1,
        "conditional": True,
        "id": 287,
    },
    "Fishing Catch Legendary Neptoona": {
        "region_id": "fishing shadows",
        "vanilla_item": "Fish: Legendary Neptoona",
        "stage_id": 0x2,
        "floor_id": 0x0,
        "address": 0x1ba5b8,
        "value": 0x1,
        "conditional": True,
        "id": 288,
    },
    "Fishing Catch Stowfish": {
        "region_id": "fishing stowfish",
        "vanilla_item": "Fish: Stowfish",
        "stage_id": 0x2,
        "floor_id": 0x0,
        "address": 0x1ba5b9,
        "value": 0x1,
        "conditional": True,
        "id": 289,
    },

    # Salvage

    "Ocean SW Salvage #1 Molida SW": {
        "region_id": "salvage 1",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "conditional": True,
        "address": 0x1ba654,
        "value": 0x80,
        "id": 290,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #1 (Molida SW)",
    },
    "Ocean SW Salvage #2 Mercay NE": {
        "region_id": "salvage 2",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "conditional": True,
        "address": 0x1ba654,
        "value": 0x10,
        "id": 291,
        "vanilla_item": "Sand of Hours (Small)",
        "item_override": "Treasure Map #2 (Mercay NE)",
    },
    "Ocean NW Salvage #3 Gusts SW": {
        "region_id": "salvage 3",
        "stage_id": 0x0,
        "floor_id": 0x1,
        "conditional": True,
        "address": 0x1ba655,
        "value": 0x20,
        "id": 292,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #3 (Gusts SW)",
    },
    "Ocean NW Salvage #4 Bannan SE": {
        "region_id": "salvage 4",
        "stage_id": 0x0,
        "floor_id": 0x1,
        "conditional": True,
        "address": 0x1ba655,
        "value": 0x80,
        "id": 293,
        "vanilla_item": "Sand of Hours (Small)",
        "item_override": "Treasure Map #4 (Bannan SE)",
    },
    "Ocean SW Salvage #5 Molida N": {
        "region_id": "salvage 5",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "conditional": True,
        "address": 0x1ba654,
        "value": 0x40,
        "id": 294,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #5 (Molida N)",
    },
    "Ocean NW Salvage #6 Bannan W": {
        "region_id": "salvage 6",
        "stage_id": 0x0,
        "floor_id": 0x1,
        "conditional": True,
        "address": 0x1ba655,
        "value": 0x1,
        "id": 295,
        "vanilla_item": "Treasure",
        "item_override": "Treasure Map #6 (Bannan W)",
    },
    "Ocean NW Salvage #7 Gusts E": {
        "region_id": "salvage 7",
        "stage_id": 0x0,
        "floor_id": 0x1,
        "conditional": True,
        "address": 0x1ba655,
        "value": 0x8,
        "id": 296,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #7 (Gusts E)",
    },
    "Ocean SW Salvage #8 Mercay SE": {
        "region_id": "salvage 8",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "conditional": True,
        "address": 0x1ba654,
        "value": 0x8,
        "id": 297,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #8 (Mercay SE)",
    },
    "Ocean SW Salvage #9 Cannon W": {
        "region_id": "salvage 9",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "conditional": True,
        "address": 0x1ba654,
        "value": 0x2,
        "id": 298,
        "vanilla_item": "Sand of Hours (Small)",
        "item_override": "Treasure Map #9 (Cannon W)",
    },
    "Ocean NW Salvage #10 Gusts SE": {
        "region_id": "salvage 10",
        "stage_id": 0x0,
        "floor_id": 0x1,
        "conditional": True,
        "address": 0x1ba655,
        "value": 0x10,
        "id": 299,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #10 (Gusts SE)",
    },
    "Ocean NW Salvage #11 Gusts N": {
        "region_id": "salvage 11",
        "stage_id": 0x0,
        "floor_id": 0x1,
        "conditional": True,
        "address": 0x1ba655,
        "value": 0x2,
        "id": 300,
        "vanilla_item": "Sand of Hours (Small)",
        "item_override": "Treasure Map #11 (Gusts N)",
    },
    "Ocean SE Salvage #12 Dee Ess N": {
        "region_id": "salvage 12",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "address": 0x1ba656,
        "value": 0x20,
        "id": 301,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #12 (Dee Ess N)",
    },
    "Ocean SE Salvage #13 Harrow E": {
        "region_id": "salvage 13",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "address": 0x1ba656,
        "value": 0x4,
        "id": 302,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #13 (Harrow E)",
    },
    "Ocean SE Salvage #14 Goron NW": {
        "region_id": "salvage 14",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "address": 0x1ba656,
        "value": 0x1,
        "id": 303,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #14 (Goron NW)",
    },
    "Ocean SE Salvage #15 Goron W": {
        "region_id": "salvage 15",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "address": 0x1ba656,
        "value": 0x2,
        "id": 304,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #15 (Goron W)",
    },
    "Ocean SE Salvage #16 Goron NE": {
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #16 (Goron NE)",
        "region_id": "salvage 16",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "address": 0x1ba656,
        "value": 0x10,
        "id": 305,
    },
    "Ocean SE Salvage #17 Frost S": {
        "region_id": "salvage 17",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "address": 0x1ba656,
        "value": 0x40,
        "id": 306,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #17 (Frost S)",
    },
    "Ocean SW Salvage #18 Cannon S": {
        "region_id": "salvage 18",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "conditional": True,
        "address": 0x1ba654,
        "value": 0x4,
        "id": 307,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #18 (Cannon S)",
    },
    "Ocean NW Salvage #19 Gusts NE": {
        "region_id": "salvage 19",
        "stage_id": 0x0,
        "floor_id": 0x1,
        "conditional": True,
        "address": 0x1ba655,
        "value": 0x4,
        "id": 308,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #19 (Gusts NE)",
    },
    "Ocean NW Salvage #20 Bannan E": {
        "region_id": "salvage 20",
        "stage_id": 0x0,
        "floor_id": 0x1,
        "conditional": True,
        "address": 0x1ba655,
        "value": 0x40,
        "id": 309,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #20 (Bannan E)",
    },
    "Ocean SW Salvage #21 Molida NW": {
        "region_id": "salvage 21",
        "stage_id": 0x0,
        "floor_id": 0x0,
        "conditional": True,
        "address": 0x1ba654,
        "value": 0x20,
        "id": 310,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #21 (Molida NW)",
    },
    "Ocean SE Salvage #22 Harrow S": {
        "region_id": "salvage 22",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "address": 0x1ba656,
        "value": 0x8,
        "id": 311,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #22 (Harrow S)",
    },
    "Ocean SE Salvage #23 Frost NW": {
        "region_id": "salvage 23",
        "stage_id": 0x0,
        "floor_id": 0x2,
        "conditional": True,
        "address": 0x1ba656,
        "value": 0x80,
        "id": 312,
        "vanilla_item": "Sand of Hours (Small)",
        "item_override": "Treasure Map #23 (Frost NW)",
    },
    "Ocean NE Salvage #24 Ruins W": {
        "region_id": "salvage 24",
        "stage_id": 0x0,
        "floor_id": 0x3,
        "conditional": True,
        "address": 0x1ba657,
        "value": 0x20,
        "id": 313,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #24 (Ruins W)",
    },
    "Ocean NE Salvage #25 Dead E": {
        "region_id": "salvage 25",
        "stage_id": 0x0,
        "floor_id": 0x3,
        "conditional": True,
        "address": 0x1ba657,
        "value": 0x4,
        "id": 314,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #25 (Dead E)",
    },
    "Ocean NE Salvage #26 Ruins SW": {
        "region_id": "salvage 26",
        "stage_id": 0x0,
        "floor_id": 0x3,
        "conditional": True,
        "address": 0x1ba657,
        "value": 0x2,
        "id": 315,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #26 (Ruins SW)",
    },
    "Ocean NE Salvage #27 Maze E": {
        "region_id": "salvage 27",
        "stage_id": 0x0,
        "floor_id": 0x3,
        "conditional": True,
        "address": 0x1ba657,
        "value": 0x8,
        "id": 316,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #27 (Maze E)",
    },
    "Ocean NE Salvage #28 Ruins NW": {
        "region_id": "salvage 28",
        "stage_id": 0x0,
        "floor_id": 0x3,
        "conditional": True,
        "address": 0x1ba657,
        "value": 0x1,
        "id": 317,
        "vanilla_item": "Treasure",
        "item_override": "Treasure Map #28 (Ruins NW)",
    },
    "Ocean NE Salvage #29 Maze W": {
        "region_id": "salvage 29",
        "stage_id": 0x0,
        "floor_id": 0x3,
        "conditional": True,
        "address": 0x1ba657,
        "value": 0x10,
        "id": 318,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #29 (Maze W)",
    },
    "Ocean NE Salvage #30 Ruins S": {
        "region_id": "salvage 30",
        "stage_id": 0x0,
        "floor_id": 0x3,
        "conditional": True,
        "address": 0x1ba657,
        "value": 0x40,
        "id": 319,
        "vanilla_item": "Ship Part",
        "item_override": "Treasure Map #30 (Ruins S)",
    },
    "Ocean NE Salvage #31 Dead S": {
        "region_id": "salvage 31",
        "stage_id": 0x0,
        "floor_id": 0x3,
        "conditional": True,
        "address": 0x1ba657,
        "value": 0x80,
        "id": 320,
        "vanilla_item": "Gold Rupee (300)",
        "item_override": "Treasure Map #31 (Dead S)",
    },
}

for i in LOCATIONS_DATA:
    LOCATIONS_DATA[i]["name"] = i

if __name__ == "__main__":
    for loc in LOCATIONS_DATA:
        print("-", loc)

    # Check for missing locs in tracker
    with(open("locations.json","r")) as j:
        tracker_data = json.load(j)
        # print(tracker_data)
    tracker_locs = []
    for node in tracker_data:
        for loc_dict in node["sections"]:
            tracker_locs.append(loc_dict["name"])
    missing_locs = [i for i in LOCATIONS_DATA if i not in tracker_locs]
    for i in missing_locs:
        print(i)

    """    islands = {}
        island_groups = {}
        for location, data in LOCATIONS_DATA.items():
            islands.setdefault(data["stage_id"], [])
            islands[data["stage_id"]].append(location)
    
        for i, data in islands.items():
            island_groups[STAGES[i]] = data
            print(f"\t\"{STAGES[i]}\": [")
            for loc in data:
                print(f"\t\t\"{loc}\",")
            print(f"\t],")
    
    for name, data in LOCATIONS_DATA.items():
        if "Salvage" in name and "#" in name:

            print(f"\t\t\"{name}\",")

            ident = name[name.find("#")+1:name.find(" ", name.find("#"))]
            data["vanilla_item"] = ""
            data["item_override"] = f"Treasure Map #{ident}"

            print(f"\t\"{name}\": " + "{")
            for key, value in data.items():
                if type(value) is str:
                    print(f"\t\t\"{key}\": \"{value}\",")
                else:
                    print(f"\t\t\"{key}\": {value},")
            print("\t},")


    for loc_name, data in LOCATIONS_DATA.items():
        print(f"\t\"{loc_name}\": " + "{")
        for key, value in data.items():
            if type(value) is str:
                print(f"\t\t\"{key}\": \"{value}\",")
            elif key == "classification":
                print(f"\t\t\"{key}\": ItemClassification.{CLASSIFICATION[value]},")
            elif type(value) is int:
                if key in ["id", "size"]:
                    print(f"\t\t\"{key}\": {value},")
                else:
                    print(f"\t\t\"{key}\": {hex(value)},")
            elif type(value) is list:
                l_print = "["
                for i in value:
                    if type(i) is tuple or type(i) is list:
                        l_print += "("
                        for j in i:
                            if type(j) is int:
                                l_print += f"{hex(j)}, "
                            elif type(j) is str:
                                l_print += f"\"{j}\", "
                            else:
                                l_print += f"{j}, "
                        l_print = l_print[:-2]
                        l_print += "), "
                    else:
                        if type(i) is int:
                            l_print += f"{hex(i)}, "
                        elif type(i) is str:
                            l_print += f"\"{i}\", "
                        else:
                            l_print += f"{i}, "
                l_print = l_print[:-2]
                l_print += "]"
                print(f"\t\t\"{key}\": {l_print},")
            else:
                print(f"\t\t\"{key}\": {value},")
        print("\t},")
    """
