# from https://xenoblade.github.io/xbx/bdat/common_local_us/DRP_ItemTable.html
# removed the 4 duplicate e-rifle entries to allow for a dict
from typing import NamedTuple


class DropItem(NamedTuple):
    affixLot: int
    affixLotGood: int
    affixNumLot: int
    slotNumLot: int
    affixNumLotGood: int
    slotNumLotGood: int


DI = DropItem

# flake8: noqa
dropItemData: dict[str, DropItem] = {
"Worn Survival Headset": DI(585, 586, 1, 23, 2, 24),
"Worn Survival Shirt": DI(589, 590, 1, 23, 2, 24),
"Worn Survival Sleeve R": DI(593, 594, 1, 23, 2, 24),
"Worn Survival Sleeve L": DI(597, 598, 1, 23, 2, 24),
"Worn Survival Pants": DI(601, 602, 1, 23, 2, 24),
"Advanced Survival Headset": DI(587, 588, 1, 23, 2, 24),
"Advanced Survival Shirt": DI(591, 592, 1, 23, 2, 24),
"Advanced Survival Sleeve R": DI(595, 596, 1, 23, 2, 24),
"Advanced Survival Sleeve L": DI(599, 600, 1, 23, 2, 24),
"Advanced Survival Pants": DI(603, 604, 1, 23, 2, 24),
"Worn Combat Headset": DI(605, 606, 1, 23, 2, 24),
"Worn Combat Shirt": DI(613, 614, 1, 23, 2, 24),
"Worn Combat Sleeve R": DI(621, 622, 1, 23, 2, 24),
"Worn Combat Sleeve L": DI(629, 630, 1, 23, 2, 24),
"Worn Combat Pants": DI(637, 638, 1, 23, 2, 24),
"Advanced Combat Headset": DI(607, 608, 1, 23, 2, 24),
"Advanced Combat Shirt": DI(615, 616, 1, 23, 2, 24),
"Advanced Combat Sleeve R": DI(623, 624, 1, 23, 2, 24),
"Advanced Combat Sleeve L": DI(631, 632, 1, 23, 2, 24),
"Advanced Combat Pants": DI(639, 640, 1, 23, 2, 24),
"Worn Vivid Headset": DI(609, 610, 1, 23, 2, 24),
"Worn Vivid Shirt": DI(617, 618, 1, 23, 2, 24),
"Worn Vivid Sleeve R": DI(625, 626, 1, 23, 2, 24),
"Worn Vivid Sleeve L": DI(633, 634, 1, 23, 2, 24),
"Worn Vivid Pants": DI(641, 642, 1, 23, 2, 24),
"Advanced Vivid Headset": DI(611, 612, 1, 23, 2, 24),
"Advanced Vivid Shirt": DI(619, 620, 1, 23, 2, 24),
"Advanced Vivid Sleeve R": DI(627, 628, 1, 23, 2, 24),
"Advanced Vivid Sleeve L": DI(635, 636, 1, 23, 2, 24),
"Advanced Vivid Pants": DI(643, 644, 1, 23, 2, 24),
"Worn Valor Headset": DI(645, 646, 1, 23, 2, 24),
"Worn Valor Shirt": DI(653, 654, 1, 23, 2, 24),
"Worn Valor Sleeve R": DI(661, 662, 1, 23, 2, 24),
"Worn Valor Sleeve L": DI(669, 670, 1, 23, 2, 24),
"Worn Valor Pants": DI(677, 678, 1, 23, 2, 24),
"Advanced Valor Headset": DI(647, 648, 1, 23, 2, 24),
"Advanced Valor Shirt": DI(655, 656, 1, 23, 2, 24),
"Advanced Valor Sleeve R": DI(663, 664, 1, 23, 2, 24),
"Advanced Valor Sleeve L": DI(671, 672, 1, 23, 2, 24),
"Advanced Valor Pants": DI(679, 680, 1, 23, 2, 24),
"Worn Forza Headset": DI(649, 650, 1, 23, 2, 24),
"Worn Forza Shirt": DI(657, 658, 1, 23, 2, 24),
"Worn Forza Sleeve R": DI(665, 666, 1, 23, 2, 24),
"Worn Forza Sleeve L": DI(673, 674, 1, 23, 2, 24),
"Worn Forza Pants": DI(681, 682, 1, 23, 2, 24),
"Advanced Forza Headset": DI(651, 652, 1, 23, 2, 24),
"Advanced Forza Shirt": DI(659, 660, 1, 23, 2, 24),
"Advanced Forza Sleeve R": DI(667, 668, 1, 23, 2, 24),
"Advanced Forza Sleeve L": DI(675, 676, 1, 23, 2, 24),
"Advanced Forza Pants": DI(683, 684, 1, 23, 2, 24),
"Worn Reginal Headset": DI(685, 686, 1, 23, 2, 24),
"Worn Reginal Shirt": DI(693, 694, 1, 23, 2, 24),
"Worn Reginal Sleeve R": DI(701, 702, 1, 23, 2, 24),
"Worn Reginal Sleeve L": DI(709, 710, 1, 23, 2, 24),
"Worn Reginal Pants": DI(717, 718, 1, 23, 2, 24),
"Advanced Reginal Headset": DI(687, 688, 1, 23, 2, 24),
"Advanced Reginal Shirt": DI(695, 696, 1, 23, 2, 24),
"Advanced Reginal Sleeve R": DI(703, 704, 1, 23, 2, 24),
"Advanced Reginal Sleeve L": DI(711, 712, 1, 23, 2, 24),
"Advanced Reginal Pants": DI(719, 720, 1, 23, 2, 24),
"Advanced Survival Visor": DI(587, 588, 1, 23, 2, 24),
"Advanced Survival Vest": DI(591, 592, 1, 23, 2, 24),
"Advanced Survival Guard R": DI(595, 596, 1, 23, 2, 24),
"Advanced Survival Guard L": DI(599, 600, 1, 23, 2, 24),
"Advanced Survival Boots": DI(603, 604, 1, 23, 2, 24),
"Worn Combat Visor": DI(605, 606, 1, 23, 2, 24),
"Worn Combat Vest": DI(613, 614, 1, 23, 2, 24),
"Worn Combat Guard R": DI(621, 622, 1, 23, 2, 24),
"Worn Combat Guard L": DI(629, 630, 1, 23, 2, 24),
"Worn Combat Boots": DI(637, 638, 1, 23, 2, 24),
"Advanced Combat Visor": DI(607, 608, 1, 23, 2, 24),
"Advanced Combat Vest": DI(615, 616, 1, 23, 2, 24),
"Advanced Combat Guard R": DI(623, 624, 1, 23, 2, 24),
"Advanced Combat Guard L": DI(631, 632, 1, 23, 2, 24),
"Advanced Combat Boots": DI(639, 640, 1, 23, 2, 24),
"Worn Vivid Visor": DI(609, 610, 1, 23, 2, 24),
"Worn Vivid Vest": DI(617, 618, 1, 23, 2, 24),
"Worn Vivid Guard R": DI(625, 626, 1, 23, 2, 24),
"Worn Vivid Guard L": DI(633, 634, 1, 23, 2, 24),
"Worn Vivid Boots": DI(641, 642, 1, 23, 2, 24),
"Advanced Vivid Visor": DI(611, 612, 1, 23, 2, 24),
"Advanced Vivid Vest": DI(619, 620, 1, 23, 2, 24),
"Advanced Vivid Guard R": DI(627, 628, 1, 23, 2, 24),
"Advanced Vivid Guard L": DI(635, 636, 1, 23, 2, 24),
"Advanced Vivid Boots": DI(643, 644, 1, 23, 2, 24),
"Worn Valor Visor": DI(645, 646, 1, 23, 2, 24),
"Worn Valor Vest": DI(653, 654, 1, 23, 2, 24),
"Worn Valor Guard R": DI(661, 662, 1, 23, 2, 24),
"Worn Valor Guard L": DI(669, 670, 1, 23, 2, 24),
"Worn Valor Boots": DI(677, 678, 1, 23, 2, 24),
"Advanced Valor Visor": DI(647, 648, 1, 23, 2, 24),
"Advanced Valor Vest": DI(655, 656, 1, 23, 2, 24),
"Advanced Valor Guard R": DI(663, 664, 1, 23, 2, 24),
"Advanced Valor Guard L": DI(671, 672, 1, 23, 2, 24),
"Advanced Valor Boots": DI(679, 680, 1, 23, 2, 24),
"Worn Forza Visor": DI(649, 650, 1, 23, 2, 24),
"Worn Forza Vest": DI(657, 658, 1, 23, 2, 24),
"Worn Forza Guard R": DI(665, 666, 1, 23, 2, 24),
"Worn Forza Guard L": DI(673, 674, 1, 23, 2, 24),
"Worn Forza Boots": DI(681, 682, 1, 23, 2, 24),
"Advanced Forza Visor": DI(651, 652, 1, 23, 2, 24),
"Advanced Forza Vest": DI(659, 660, 1, 23, 2, 24),
"Advanced Forza Guard R": DI(667, 668, 1, 23, 2, 24),
"Advanced Forza Guard L": DI(675, 676, 1, 23, 2, 24),
"Advanced Forza Boots": DI(683, 684, 1, 23, 2, 24),
"Worn Reginal Visor": DI(685, 686, 1, 23, 2, 24),
"Worn Reginal Vest": DI(693, 694, 1, 23, 2, 24),
"Worn Reginal Guard R": DI(701, 702, 1, 23, 2, 24),
"Worn Reginal Guard L": DI(709, 710, 1, 23, 2, 24),
"Worn Reginal Boots": DI(717, 718, 1, 23, 2, 24),
"Advanced Reginal Visor": DI(687, 688, 1, 23, 2, 24),
"Advanced Reginal Vest": DI(695, 696, 1, 23, 2, 24),
"Advanced Reginal Guard R": DI(703, 704, 1, 23, 2, 24),
"Advanced Reginal Guard L": DI(711, 712, 1, 23, 2, 24),
"Advanced Reginal Boots": DI(719, 720, 1, 23, 2, 24),
"Worn Survival Goggles": DI(585, 586, 1, 23, 2, 24),
"Worn Survival Bodywear": DI(589, 590, 1, 23, 2, 24),
"Worn Survival Glove R": DI(593, 594, 1, 23, 2, 24),
"Worn Survival Glove L": DI(597, 598, 1, 23, 2, 24),
"Worn Survival Footwear": DI(601, 602, 1, 23, 2, 24),
"Advanced Survival Goggles": DI(587, 588, 1, 23, 2, 24),
"Advanced Survival Bodywear": DI(591, 592, 1, 23, 2, 24),
"Advanced Survival Glove R": DI(595, 596, 1, 23, 2, 24),
"Advanced Survival Glove L": DI(599, 600, 1, 23, 2, 24),
"Advanced Survival Footwear": DI(603, 604, 1, 23, 2, 24),
"Worn Combat Goggles": DI(605, 606, 1, 23, 2, 24),
"Worn Combat Bodywear": DI(613, 614, 1, 23, 2, 24),
"Worn Combat Glove R": DI(621, 622, 1, 23, 2, 24),
"Worn Combat Glove L": DI(629, 630, 1, 23, 2, 24),
"Worn Combat Footwear": DI(637, 638, 1, 23, 2, 24),
"Advanced Combat Goggles": DI(607, 608, 1, 23, 2, 24),
"Advanced Combat Bodywear": DI(615, 616, 1, 23, 2, 24),
"Advanced Combat Glove R": DI(623, 624, 1, 23, 2, 24),
"Advanced Combat Glove L": DI(631, 632, 1, 23, 2, 24),
"Advanced Combat Footwear": DI(639, 640, 1, 23, 2, 24),
"Worn Vivid Goggles": DI(609, 610, 1, 23, 2, 24),
"Worn Vivid Bodywear": DI(617, 618, 1, 23, 2, 24),
"Worn Vivid Glove R": DI(625, 626, 1, 23, 2, 24),
"Worn Vivid Glove L": DI(633, 634, 1, 23, 2, 24),
"Worn Vivid Footwear": DI(641, 642, 1, 23, 2, 24),
"Advanced Vivid Goggles": DI(611, 612, 1, 23, 2, 24),
"Advanced Vivid Bodywear": DI(619, 620, 1, 23, 2, 24),
"Advanced Vivid Glove R": DI(627, 628, 1, 23, 2, 24),
"Advanced Vivid Glove L": DI(635, 636, 1, 23, 2, 24),
"Advanced Vivid Footwear": DI(643, 644, 1, 23, 2, 24),
"Worn Valor Goggles": DI(645, 646, 1, 23, 2, 24),
"Worn Valor Bodywear": DI(653, 654, 1, 23, 2, 24),
"Worn Valor Glove R": DI(661, 662, 1, 23, 2, 24),
"Worn Valor Glove L": DI(669, 670, 1, 23, 2, 24),
"Worn Valor Footwear": DI(677, 678, 1, 23, 2, 24),
"Advanced Valor Goggles": DI(647, 648, 1, 23, 2, 24),
"Advanced Valor Bodywear": DI(655, 656, 1, 23, 2, 24),
"Advanced Valor Glove R": DI(663, 664, 1, 23, 2, 24),
"Advanced Valor Glove L": DI(671, 672, 1, 23, 2, 24),
"Advanced Valor Footwear": DI(679, 680, 1, 23, 2, 24),
"Worn Forza Goggles": DI(649, 650, 1, 23, 2, 24),
"Worn Forza Bodywear": DI(657, 658, 1, 23, 2, 24),
"Worn Forza Glove R": DI(665, 666, 1, 23, 2, 24),
"Worn Forza Glove L": DI(673, 674, 1, 23, 2, 24),
"Worn Forza Footwear": DI(681, 682, 1, 23, 2, 24),
"Advanced Forza Goggles": DI(651, 652, 1, 23, 2, 24),
"Advanced Forza Bodywear": DI(659, 660, 1, 23, 2, 24),
"Advanced Forza Glove R": DI(667, 668, 1, 23, 2, 24),
"Advanced Forza Glove L": DI(675, 676, 1, 23, 2, 24),
"Advanced Forza Footwear": DI(683, 684, 1, 23, 2, 24),
"Worn Reginal Goggles": DI(685, 686, 1, 23, 2, 24),
"Worn Reginal Bodywear": DI(693, 694, 1, 23, 2, 24),
"Worn Reginal Glove R": DI(701, 702, 1, 23, 2, 24),
"Worn Reginal Glove L": DI(709, 710, 1, 23, 2, 24),
"Worn Reginal Footwear": DI(717, 718, 1, 23, 2, 24),
"Advanced Reginal Goggles": DI(687, 688, 1, 23, 2, 24),
"Advanced Reginal Bodywear": DI(695, 696, 1, 23, 2, 24),
"Advanced Reginal Glove R": DI(703, 704, 1, 23, 2, 24),
"Advanced Reginal Glove L": DI(711, 712, 1, 23, 2, 24),
"Advanced Reginal Footwear": DI(719, 720, 1, 23, 2, 24),
"Advanced Combat Headwear": DI(607, 608, 1, 23, 2, 24),
"Advanced Combat Armor": DI(615, 616, 1, 23, 2, 24),
"Advanced Combat Armwear R": DI(623, 624, 1, 23, 2, 24),
"Advanced Combat Armwear L": DI(631, 632, 1, 23, 2, 24),
"Advanced Combat Legwear": DI(639, 640, 1, 23, 2, 24),
"Worn Vivid Headwear": DI(609, 610, 1, 23, 2, 24),
"Worn Vivid Armor": DI(617, 618, 1, 23, 2, 24),
"Worn Vivid Armwear R": DI(625, 626, 1, 23, 2, 24),
"Worn Vivid Armwear L": DI(633, 634, 1, 23, 2, 24),
"Worn Vivid Legwear": DI(641, 642, 1, 23, 2, 24),
"Advanced Vivid Headwear": DI(611, 612, 1, 23, 2, 24),
"Advanced Vivid Armor": DI(619, 620, 1, 23, 2, 24),
"Advanced Vivid Armwear R": DI(627, 628, 1, 23, 2, 24),
"Advanced Vivid Armwear L": DI(635, 636, 1, 23, 2, 24),
"Advanced Vivid Legwear": DI(643, 644, 1, 23, 2, 24),
"Worn Valor Headwear": DI(645, 646, 1, 23, 2, 24),
"Worn Valor Armor": DI(653, 654, 1, 23, 2, 24),
"Worn Valor Armwear R": DI(661, 662, 1, 23, 2, 24),
"Worn Valor Armwear L": DI(669, 670, 1, 23, 2, 24),
"Worn Valor Legwear": DI(677, 678, 1, 23, 2, 24),
"Advanced Valor Headwear": DI(647, 648, 1, 23, 2, 24),
"Advanced Valor Armor": DI(655, 656, 1, 23, 2, 24),
"Advanced Valor Armwear R": DI(663, 664, 1, 23, 2, 24),
"Advanced Valor Armwear L": DI(671, 672, 1, 23, 2, 24),
"Advanced Valor Legwear": DI(679, 680, 1, 23, 2, 24),
"Worn Forza Headwear": DI(649, 650, 1, 23, 2, 24),
"Worn Forza Armor": DI(657, 658, 1, 23, 2, 24),
"Worn Forza Armwear R": DI(665, 666, 1, 23, 2, 24),
"Worn Forza Armwear L": DI(673, 674, 1, 23, 2, 24),
"Worn Forza Legwear": DI(681, 682, 1, 23, 2, 24),
"Advanced Forza Headwear": DI(651, 652, 1, 23, 2, 24),
"Advanced Forza Armor": DI(659, 660, 1, 23, 2, 24),
"Advanced Forza Armwear R": DI(667, 668, 1, 23, 2, 24),
"Advanced Forza Armwear L": DI(675, 676, 1, 23, 2, 24),
"Advanced Forza Legwear": DI(683, 684, 1, 23, 2, 24),
"Worn Reginal Headwear": DI(685, 686, 1, 23, 2, 24),
"Worn Reginal Armor": DI(693, 694, 1, 23, 2, 24),
"Worn Reginal Armwear R": DI(701, 702, 1, 23, 2, 24),
"Worn Reginal Armwear L": DI(709, 710, 1, 23, 2, 24),
"Worn Reginal Legwear": DI(717, 718, 1, 23, 2, 24),
"Advanced Reginal Headwear": DI(687, 688, 1, 23, 2, 24),
"Advanced Reginal Armor": DI(695, 696, 1, 23, 2, 24),
"Advanced Reginal Armwear R": DI(703, 704, 1, 23, 2, 24),
"Advanced Reginal Armwear L": DI(711, 712, 1, 23, 2, 24),
"Advanced Reginal Legwear": DI(719, 720, 1, 23, 2, 24),
"Advanced Combat Helmet": DI(1347, 1348, 1, 23, 2, 24),
"Advanced Combat Suit": DI(1355, 1356, 1, 23, 2, 24),
"Advanced Combat Mitt R": DI(1363, 1364, 1, 23, 2, 24),
"Advanced Combat Mitt L": DI(1371, 1372, 1, 23, 2, 24),
"Advanced Combat Leggings": DI(1379, 1380, 1, 23, 2, 24),
"Worn Vivid Helmet": DI(1349, 1350, 1, 23, 2, 24),
"Worn Vivid Suit": DI(1357, 1358, 1, 23, 2, 24),
"Worn Vivid Mitt R": DI(1365, 1366, 1, 23, 2, 24),
"Worn Vivid Mitt L": DI(1373, 1374, 1, 23, 2, 24),
"Worn Vivid Leggings": DI(1381, 1382, 1, 23, 2, 24),
"Advanced Vivid Helmet": DI(1351, 1352, 1, 23, 2, 24),
"Advanced Vivid Suit": DI(1359, 1360, 1, 23, 2, 24),
"Advanced Vivid Mitt R": DI(1367, 1368, 1, 23, 2, 24),
"Advanced Vivid Mitt L": DI(1375, 1376, 1, 23, 2, 24),
"Advanced Vivid Leggings": DI(1383, 1384, 1, 23, 2, 24),
"Worn Valor Helmet": DI(1385, 1386, 1, 23, 2, 24),
"Worn Valor Suit": DI(1393, 1394, 1, 23, 2, 24),
"Worn Valor Mitt R": DI(1401, 1402, 1, 23, 2, 24),
"Worn Valor Mitt L": DI(1409, 1410, 1, 23, 2, 24),
"Worn Valor Leggings": DI(1417, 1418, 1, 23, 2, 24),
"Advanced Valor Helmet": DI(1387, 1388, 1, 23, 2, 24),
"Advanced Valor Suit": DI(1395, 1396, 1, 23, 2, 24),
"Advanced Valor Mitt R": DI(1403, 1404, 1, 23, 2, 24),
"Advanced Valor Mitt L": DI(1411, 1412, 1, 23, 2, 24),
"Advanced Valor Leggings": DI(1419, 1420, 1, 23, 2, 24),
"Worn Forza Helmet": DI(1389, 1390, 1, 23, 2, 24),
"Worn Forza Suit": DI(1397, 1398, 1, 23, 2, 24),
"Worn Forza Mitt R": DI(1405, 1406, 1, 23, 2, 24),
"Worn Forza Mitt L": DI(1413, 1414, 1, 23, 2, 24),
"Worn Forza Leggings": DI(1421, 1422, 1, 23, 2, 24),
"Advanced Forza Helmet": DI(1391, 1392, 1, 23, 2, 24),
"Advanced Forza Suit": DI(1399, 1400, 1, 23, 2, 24),
"Advanced Forza Mitt R": DI(1407, 1408, 1, 23, 2, 24),
"Advanced Forza Mitt L": DI(1415, 1416, 1, 23, 2, 24),
"Advanced Forza Leggings": DI(1423, 1424, 1, 23, 2, 24),
"Worn Reginal Helmet": DI(1425, 1426, 1, 23, 2, 24),
"Worn Reginal Suit": DI(1433, 1434, 1, 23, 2, 24),
"Worn Reginal Mitt R": DI(1441, 1442, 1, 23, 2, 24),
"Worn Reginal Mitt L": DI(1449, 1450, 1, 23, 2, 24),
"Worn Reginal Leggings": DI(1457, 1458, 1, 23, 2, 24),
"Advanced Reginal Helmet": DI(1427, 1428, 1, 23, 2, 24),
"Advanced Reginal Suit": DI(1435, 1436, 1, 23, 2, 24),
"Advanced Reginal Mitt R": DI(1443, 1444, 1, 23, 2, 24),
"Advanced Reginal Mitt L": DI(1451, 1452, 1, 23, 2, 24),
"Advanced Reginal Leggings": DI(1459, 1460, 1, 23, 2, 24),
"Advanced Survival Veyes": DI(727, 728, 1, 23, 2, 24),
"Advanced Survival Norak": DI(731, 732, 1, 23, 2, 24),
"Advanced Survival Tecta R": DI(735, 736, 1, 23, 2, 24),
"Advanced Survival Tecta L": DI(739, 740, 1, 23, 2, 24),
"Advanced Survival Brogs": DI(743, 744, 1, 23, 2, 24),
"Worn Combat Veyes": DI(745, 746, 1, 23, 2, 24),
"Worn Combat Norak": DI(753, 754, 1, 23, 2, 24),
"Worn Combat Tecta R": DI(761, 762, 1, 23, 2, 24),
"Worn Combat Tecta L": DI(769, 770, 1, 23, 2, 24),
"Worn Combat Brogs": DI(777, 778, 1, 23, 2, 24),
"Advanced Combat Veyes": DI(747, 748, 1, 23, 2, 24),
"Advanced Combat Norak": DI(755, 756, 1, 23, 2, 24),
"Advanced Combat Tecta R": DI(763, 764, 1, 23, 2, 24),
"Advanced Combat Tecta L": DI(771, 772, 1, 23, 2, 24),
"Advanced Combat Brogs": DI(779, 780, 1, 23, 2, 24),
"Worn Vivid Veyes": DI(749, 750, 1, 23, 2, 24),
"Worn Vivid Norak": DI(757, 758, 1, 23, 2, 24),
"Worn Vivid Tecta R": DI(765, 766, 1, 23, 2, 24),
"Worn Vivid Tecta L": DI(773, 774, 1, 23, 2, 24),
"Worn Vivid Brogs": DI(781, 782, 1, 23, 2, 24),
"Advanced Vivid Veyes": DI(751, 752, 1, 23, 2, 24),
"Advanced Vivid Norak": DI(759, 760, 1, 23, 2, 24),
"Advanced Vivid Tecta R": DI(767, 768, 1, 23, 2, 24),
"Advanced Vivid Tecta L": DI(775, 776, 1, 23, 2, 24),
"Advanced Vivid Brogs": DI(783, 784, 1, 23, 2, 24),
"Worn Valor Veyes": DI(785, 786, 1, 23, 2, 24),
"Worn Valor Norak": DI(793, 794, 1, 23, 2, 24),
"Worn Valor Tecta R": DI(801, 802, 1, 23, 2, 24),
"Worn Valor Tecta L": DI(809, 810, 1, 23, 2, 24),
"Worn Valor Brogs": DI(817, 818, 1, 23, 2, 24),
"Advanced Valor Veyes": DI(787, 788, 1, 23, 2, 24),
"Advanced Valor Norak": DI(795, 796, 1, 23, 2, 24),
"Advanced Valor Tecta R": DI(803, 804, 1, 23, 2, 24),
"Advanced Valor Tecta L": DI(811, 812, 1, 23, 2, 24),
"Advanced Valor Brogs": DI(819, 820, 1, 23, 2, 24),
"Worn Forza Veyes": DI(789, 790, 1, 23, 2, 24),
"Worn Forza Norak": DI(797, 798, 1, 23, 2, 24),
"Worn Forza Tecta R": DI(805, 806, 1, 23, 2, 24),
"Worn Forza Tecta L": DI(813, 814, 1, 23, 2, 24),
"Worn Forza Brogs": DI(821, 822, 1, 23, 2, 24),
"Advanced Forza Veyes": DI(791, 792, 1, 23, 2, 24),
"Advanced Forza Norak": DI(799, 800, 1, 23, 2, 24),
"Advanced Forza Tecta R": DI(807, 808, 1, 23, 2, 24),
"Advanced Forza Tecta L": DI(815, 816, 1, 23, 2, 24),
"Advanced Forza Brogs": DI(823, 824, 1, 23, 2, 24),
"Worn Reginal Veyes": DI(825, 826, 1, 23, 2, 24),
"Worn Reginal Norak": DI(833, 834, 1, 23, 2, 24),
"Worn Reginal Tecta R": DI(841, 842, 1, 23, 2, 24),
"Worn Reginal Tecta L": DI(849, 850, 1, 23, 2, 24),
"Worn Reginal Brogs": DI(857, 858, 1, 23, 2, 24),
"Advanced Reginal Veyes": DI(827, 828, 1, 23, 2, 24),
"Advanced Reginal Norak": DI(835, 836, 1, 23, 2, 24),
"Advanced Reginal Tecta R": DI(843, 844, 1, 23, 2, 24),
"Advanced Reginal Tecta L": DI(851, 852, 1, 23, 2, 24),
"Advanced Reginal Brogs": DI(859, 860, 1, 23, 2, 24),
"Worn Survival Spex": DI(725, 726, 1, 23, 2, 24),
"Worn Survival Torse": DI(729, 730, 1, 23, 2, 24),
"Worn Survival Quantlet R": DI(733, 734, 1, 23, 2, 24),
"Worn Survival Quantlet L": DI(737, 738, 1, 23, 2, 24),
"Worn Survival Soales": DI(741, 742, 1, 23, 2, 24),
"Advanced Survival Spex": DI(727, 728, 1, 23, 2, 24),
"Advanced Survival Torse": DI(731, 732, 1, 23, 2, 24),
"Advanced Survival Quantlet R": DI(735, 736, 1, 23, 2, 24),
"Advanced Survival Quantlet L": DI(739, 740, 1, 23, 2, 24),
"Advanced Survival Soales": DI(743, 744, 1, 23, 2, 24),
"Worn Combat Spex": DI(745, 746, 1, 23, 2, 24),
"Worn Combat Torse": DI(753, 754, 1, 23, 2, 24),
"Worn Combat Quantlet R": DI(761, 762, 1, 23, 2, 24),
"Worn Combat Quantlet L": DI(769, 770, 1, 23, 2, 24),
"Worn Combat Soales": DI(777, 778, 1, 23, 2, 24),
"Advanced Combat Spex": DI(747, 748, 1, 23, 2, 24),
"Advanced Combat Torse": DI(755, 756, 1, 23, 2, 24),
"Advanced Combat Quantlet R": DI(763, 764, 1, 23, 2, 24),
"Advanced Combat Quantlet L": DI(771, 772, 1, 23, 2, 24),
"Advanced Combat Soales": DI(779, 780, 1, 23, 2, 24),
"Worn Vivid Spex": DI(749, 750, 1, 23, 2, 24),
"Worn Vivid Torse": DI(757, 758, 1, 23, 2, 24),
"Worn Vivid Quantlet R": DI(765, 766, 1, 23, 2, 24),
"Worn Vivid Quantlet L": DI(773, 774, 1, 23, 2, 24),
"Worn Vivid Soales": DI(781, 782, 1, 23, 2, 24),
"Advanced Vivid Spex": DI(751, 752, 1, 23, 2, 24),
"Advanced Vivid Torse": DI(759, 760, 1, 23, 2, 24),
"Advanced Vivid Quantlet R": DI(767, 768, 1, 23, 2, 24),
"Advanced Vivid Quantlet L": DI(775, 776, 1, 23, 2, 24),
"Advanced Vivid Soales": DI(783, 784, 1, 23, 2, 24),
"Worn Valor Spex": DI(785, 786, 1, 23, 2, 24),
"Worn Valor Torse": DI(793, 794, 1, 23, 2, 24),
"Worn Valor Quantlet R": DI(801, 802, 1, 23, 2, 24),
"Worn Valor Quantlet L": DI(809, 810, 1, 23, 2, 24),
"Worn Valor Soales": DI(817, 818, 1, 23, 2, 24),
"Advanced Valor Spex": DI(787, 788, 1, 23, 2, 24),
"Advanced Valor Torse": DI(795, 796, 1, 23, 2, 24),
"Advanced Valor Quantlet R": DI(803, 804, 1, 23, 2, 24),
"Advanced Valor Quantlet L": DI(811, 812, 1, 23, 2, 24),
"Advanced Valor Soales": DI(819, 820, 1, 23, 2, 24),
"Worn Forza Spex": DI(789, 790, 1, 23, 2, 24),
"Worn Forza Torse": DI(797, 798, 1, 23, 2, 24),
"Worn Forza Quantlet R": DI(805, 806, 1, 23, 2, 24),
"Worn Forza Quantlet L": DI(813, 814, 1, 23, 2, 24),
"Worn Forza Soales": DI(821, 822, 1, 23, 2, 24),
"Advanced Forza Spex": DI(791, 792, 1, 23, 2, 24),
"Advanced Forza Torse": DI(799, 800, 1, 23, 2, 24),
"Advanced Forza Quantlet R": DI(807, 808, 1, 23, 2, 24),
"Advanced Forza Quantlet L": DI(815, 816, 1, 23, 2, 24),
"Advanced Forza Soales": DI(823, 824, 1, 23, 2, 24),
"Worn Reginal Spex": DI(825, 826, 1, 23, 2, 24),
"Worn Reginal Torse": DI(833, 834, 1, 23, 2, 24),
"Worn Reginal Quantlet R": DI(841, 842, 1, 23, 2, 24),
"Worn Reginal Quantlet L": DI(849, 850, 1, 23, 2, 24),
"Worn Reginal Soales": DI(857, 858, 1, 23, 2, 24),
"Advanced Reginal Spex": DI(827, 828, 1, 23, 2, 24),
"Advanced Reginal Torse": DI(835, 836, 1, 23, 2, 24),
"Advanced Reginal Quantlet R": DI(843, 844, 1, 23, 2, 24),
"Advanced Reginal Quantlet L": DI(851, 852, 1, 23, 2, 24),
"Advanced Reginal Soales": DI(859, 860, 1, 23, 2, 24),
"Advanced Combat Tuesta": DI(747, 748, 1, 23, 2, 24),
"Advanced Combat Ryg": DI(755, 756, 1, 23, 2, 24),
"Advanced Combat Brax R": DI(763, 764, 1, 23, 2, 24),
"Advanced Combat Brax L": DI(771, 772, 1, 23, 2, 24),
"Advanced Combat Traves": DI(779, 780, 1, 23, 2, 24),
"Worn Vivid Tuesta": DI(749, 750, 1, 23, 2, 24),
"Worn Vivid Ryg": DI(757, 758, 1, 23, 2, 24),
"Worn Vivid Brax R": DI(765, 766, 1, 23, 2, 24),
"Worn Vivid Brax L": DI(773, 774, 1, 23, 2, 24),
"Worn Vivid Traves": DI(781, 782, 1, 23, 2, 24),
"Advanced Vivid Tuesta": DI(751, 752, 1, 23, 2, 24),
"Advanced Vivid Ryg": DI(759, 760, 1, 23, 2, 24),
"Advanced Vivid Brax R": DI(767, 768, 1, 23, 2, 24),
"Advanced Vivid Brax L": DI(775, 776, 1, 23, 2, 24),
"Advanced Vivid Traves": DI(783, 784, 1, 23, 2, 24),
"Worn Valor Tuesta": DI(785, 786, 1, 23, 2, 24),
"Worn Valor Ryg": DI(793, 794, 1, 23, 2, 24),
"Worn Valor Brax R": DI(801, 802, 1, 23, 2, 24),
"Worn Valor Brax L": DI(809, 810, 1, 23, 2, 24),
"Worn Valor Traves": DI(817, 818, 1, 23, 2, 24),
"Advanced Valor Tuesta": DI(787, 788, 1, 23, 2, 24),
"Advanced Valor Ryg": DI(795, 796, 1, 23, 2, 24),
"Advanced Valor Brax R": DI(803, 804, 1, 23, 2, 24),
"Advanced Valor Brax L": DI(811, 812, 1, 23, 2, 24),
"Advanced Valor Traves": DI(819, 820, 1, 23, 2, 24),
"Worn Forza Tuesta": DI(789, 790, 1, 23, 2, 24),
"Worn Forza Ryg": DI(797, 798, 1, 23, 2, 24),
"Worn Forza Brax R": DI(805, 806, 1, 23, 2, 24),
"Worn Forza Brax L": DI(813, 814, 1, 23, 2, 24),
"Worn Forza Traves": DI(821, 822, 1, 23, 2, 24),
"Advanced Forza Tuesta": DI(791, 792, 1, 23, 2, 24),
"Advanced Forza Ryg": DI(799, 800, 1, 23, 2, 24),
"Advanced Forza Brax R": DI(807, 808, 1, 23, 2, 24),
"Advanced Forza Brax L": DI(815, 816, 1, 23, 2, 24),
"Advanced Forza Traves": DI(823, 824, 1, 23, 2, 24),
"Worn Reginal Tuesta": DI(825, 826, 1, 23, 2, 24),
"Worn Reginal Ryg": DI(833, 834, 1, 23, 2, 24),
"Worn Reginal Brax R": DI(841, 842, 1, 23, 2, 24),
"Worn Reginal Brax L": DI(849, 850, 1, 23, 2, 24),
"Worn Reginal Traves": DI(857, 858, 1, 23, 2, 24),
"Advanced Reginal Tuesta": DI(827, 828, 1, 23, 2, 24),
"Advanced Reginal Ryg": DI(835, 836, 1, 23, 2, 24),
"Advanced Reginal Brax R": DI(843, 844, 1, 23, 2, 24),
"Advanced Reginal Brax L": DI(851, 852, 1, 23, 2, 24),
"Advanced Reginal Traves": DI(859, 860, 1, 23, 2, 24),
"Advanced Combat Casca": DI(1467, 1468, 1, 23, 2, 24),
"Advanced Combat Raim": DI(1475, 1476, 1, 23, 2, 24),
"Advanced Combat Guante R": DI(1483, 1484, 1, 23, 2, 24),
"Advanced Combat Guante L": DI(1491, 1492, 1, 23, 2, 24),
"Advanced Combat Tythes": DI(1499, 1500, 1, 23, 2, 24),
"Worn Vivid Casca": DI(1469, 1470, 1, 23, 2, 24),
"Worn Vivid Raim": DI(1477, 1478, 1, 23, 2, 24),
"Worn Vivid Guante R": DI(1485, 1486, 1, 23, 2, 24),
"Worn Vivid Guante L": DI(1493, 1494, 1, 23, 2, 24),
"Worn Vivid Tythes": DI(1501, 1502, 1, 23, 2, 24),
"Advanced Vivid Casca": DI(1471, 1472, 1, 23, 2, 24),
"Advanced Vivid Raim": DI(1479, 1480, 1, 23, 2, 24),
"Advanced Vivid Guante R": DI(1487, 1488, 1, 23, 2, 24),
"Advanced Vivid Guante L": DI(1495, 1496, 1, 23, 2, 24),
"Advanced Vivid Tythes": DI(1503, 1504, 1, 23, 2, 24),
"Worn Valor Casca": DI(1505, 1506, 1, 23, 2, 24),
"Worn Valor Raim": DI(1513, 1514, 1, 23, 2, 24),
"Worn Valor Guante R": DI(1521, 1522, 1, 23, 2, 24),
"Worn Valor Guante L": DI(1529, 1530, 1, 23, 2, 24),
"Worn Valor Tythes": DI(1537, 1538, 1, 23, 2, 24),
"Advanced Valor Casca": DI(1507, 1508, 1, 23, 2, 24),
"Advanced Valor Raim": DI(1515, 1516, 1, 23, 2, 24),
"Advanced Valor Guante R": DI(1523, 1524, 1, 23, 2, 24),
"Advanced Valor Guante L": DI(1531, 1532, 1, 23, 2, 24),
"Advanced Valor Tythes": DI(1539, 1540, 1, 23, 2, 24),
"Worn Forza Casca": DI(1509, 1510, 1, 23, 2, 24),
"Worn Forza Raim": DI(1517, 1518, 1, 23, 2, 24),
"Worn Forza Guante R": DI(1525, 1526, 1, 23, 2, 24),
"Worn Forza Guante L": DI(1533, 1534, 1, 23, 2, 24),
"Worn Forza Tythes": DI(1541, 1542, 1, 23, 2, 24),
"Advanced Forza Casca": DI(1511, 1512, 1, 23, 2, 24),
"Advanced Forza Raim": DI(1519, 1520, 1, 23, 2, 24),
"Advanced Forza Guante R": DI(1527, 1528, 1, 23, 2, 24),
"Advanced Forza Guante L": DI(1535, 1536, 1, 23, 2, 24),
"Advanced Forza Tythes": DI(1543, 1544, 1, 23, 2, 24),
"Worn Reginal Casca": DI(1545, 1546, 1, 23, 2, 24),
"Worn Reginal Raim": DI(1553, 1554, 1, 23, 2, 24),
"Worn Reginal Guante R": DI(1561, 1562, 1, 23, 2, 24),
"Worn Reginal Guante L": DI(1569, 1570, 1, 23, 2, 24),
"Worn Reginal Tythes": DI(1577, 1578, 1, 23, 2, 24),
"Advanced Reginal Casca": DI(1547, 1548, 1, 23, 2, 24),
"Advanced Reginal Raim": DI(1555, 1556, 1, 23, 2, 24),
"Advanced Reginal Guante R": DI(1563, 1564, 1, 23, 2, 24),
"Advanced Reginal Guante L": DI(1571, 1572, 1, 23, 2, 24),
"Advanced Reginal Tythes": DI(1579, 1580, 1, 23, 2, 24),
"Advanced Combat Vizard": DI(867, 868, 1, 23, 2, 24),
"Advanced Combat Vestis": DI(875, 876, 1, 23, 2, 24),
"Advanced Combat Armilla R": DI(883, 884, 1, 23, 2, 24),
"Advanced Combat Armilla L": DI(891, 892, 1, 23, 2, 24),
"Advanced Combat Ocreis": DI(899, 900, 1, 23, 2, 24),
"Worn Vivid Vizard": DI(869, 870, 1, 23, 2, 24),
"Worn Vivid Vestis": DI(877, 878, 1, 23, 2, 24),
"Worn Vivid Armilla R": DI(885, 886, 1, 23, 2, 24),
"Worn Vivid Armilla L": DI(893, 894, 1, 23, 2, 24),
"Worn Vivid Ocreis": DI(901, 902, 1, 23, 2, 24),
"Advanced Vivid Vizard": DI(871, 872, 1, 23, 2, 24),
"Advanced Vivid Vestis": DI(879, 880, 1, 23, 2, 24),
"Advanced Vivid Armilla R": DI(887, 888, 1, 23, 2, 24),
"Advanced Vivid Armilla L": DI(895, 896, 1, 23, 2, 24),
"Advanced Vivid Ocreis": DI(903, 904, 1, 23, 2, 24),
"Worn Valor Vizard": DI(905, 906, 1, 23, 2, 24),
"Worn Valor Vestis": DI(913, 914, 1, 23, 2, 24),
"Worn Valor Armilla R": DI(921, 922, 1, 23, 2, 24),
"Worn Valor Armilla L": DI(929, 930, 1, 23, 2, 24),
"Worn Valor Ocreis": DI(937, 938, 1, 23, 2, 24),
"Advanced Valor Vizard": DI(907, 908, 1, 23, 2, 24),
"Advanced Valor Vestis": DI(915, 916, 1, 23, 2, 24),
"Advanced Valor Armilla R": DI(923, 924, 1, 23, 2, 24),
"Advanced Valor Armilla L": DI(931, 932, 1, 23, 2, 24),
"Advanced Valor Ocreis": DI(939, 940, 1, 23, 2, 24),
"Worn Forza Vizard": DI(909, 910, 1, 23, 2, 24),
"Worn Forza Vestis": DI(917, 918, 1, 23, 2, 24),
"Worn Forza Armilla R": DI(925, 926, 1, 23, 2, 24),
"Worn Forza Armilla L": DI(933, 934, 1, 23, 2, 24),
"Worn Forza Ocreis": DI(941, 942, 1, 23, 2, 24),
"Advanced Forza Vizard": DI(911, 912, 1, 23, 2, 24),
"Advanced Forza Vestis": DI(919, 920, 1, 23, 2, 24),
"Advanced Forza Armilla R": DI(927, 928, 1, 23, 2, 24),
"Advanced Forza Armilla L": DI(935, 936, 1, 23, 2, 24),
"Advanced Forza Ocreis": DI(943, 944, 1, 23, 2, 24),
"Worn Reginal Vizard": DI(945, 946, 1, 23, 2, 24),
"Worn Reginal Vestis": DI(953, 954, 1, 23, 2, 24),
"Worn Reginal Armilla R": DI(961, 962, 1, 23, 2, 24),
"Worn Reginal Armilla L": DI(969, 970, 1, 23, 2, 24),
"Worn Reginal Ocreis": DI(977, 978, 1, 23, 2, 24),
"Advanced Reginal Vizard": DI(947, 948, 1, 23, 2, 24),
"Advanced Reginal Vestis": DI(955, 956, 1, 23, 2, 24),
"Advanced Reginal Armilla R": DI(963, 964, 1, 23, 2, 24),
"Advanced Reginal Armilla L": DI(971, 972, 1, 23, 2, 24),
"Advanced Reginal Ocreis": DI(979, 980, 1, 23, 2, 24),
"Advanced Combat Vitra": DI(867, 868, 1, 23, 2, 24),
"Advanced Combat Corpus": DI(875, 876, 1, 23, 2, 24),
"Advanced Combat Chiro R": DI(883, 884, 1, 23, 2, 24),
"Advanced Combat Chiro L": DI(891, 892, 1, 23, 2, 24),
"Advanced Combat Plantars": DI(899, 900, 1, 23, 2, 24),
"Worn Vivid Vitra": DI(869, 870, 1, 23, 2, 24),
"Worn Vivid Corpus": DI(877, 878, 1, 23, 2, 24),
"Worn Vivid Chiro R": DI(885, 886, 1, 23, 2, 24),
"Worn Vivid Chiro L": DI(893, 894, 1, 23, 2, 24),
"Worn Vivid Plantars": DI(901, 902, 1, 23, 2, 24),
"Advanced Vivid Vitra": DI(871, 872, 1, 23, 2, 24),
"Advanced Vivid Corpus": DI(879, 880, 1, 23, 2, 24),
"Advanced Vivid Chiro R": DI(887, 888, 1, 23, 2, 24),
"Advanced Vivid Chiro L": DI(895, 896, 1, 23, 2, 24),
"Advanced Vivid Plantars": DI(903, 904, 1, 23, 2, 24),
"Worn Valor Vitra": DI(905, 906, 1, 23, 2, 24),
"Worn Valor Corpus": DI(913, 914, 1, 23, 2, 24),
"Worn Valor Chiro R": DI(921, 922, 1, 23, 2, 24),
"Worn Valor Chiro L": DI(929, 930, 1, 23, 2, 24),
"Worn Valor Plantars": DI(937, 938, 1, 23, 2, 24),
"Advanced Valor Vitra": DI(907, 908, 1, 23, 2, 24),
"Advanced Valor Corpus": DI(915, 916, 1, 23, 2, 24),
"Advanced Valor Chiro R": DI(923, 924, 1, 23, 2, 24),
"Advanced Valor Chiro L": DI(931, 932, 1, 23, 2, 24),
"Advanced Valor Plantars": DI(939, 940, 1, 23, 2, 24),
"Worn Forza Vitra": DI(909, 910, 1, 23, 2, 24),
"Worn Forza Corpus": DI(917, 918, 1, 23, 2, 24),
"Worn Forza Chiro R": DI(925, 926, 1, 23, 2, 24),
"Worn Forza Chiro L": DI(933, 934, 1, 23, 2, 24),
"Worn Forza Plantars": DI(941, 942, 1, 23, 2, 24),
"Advanced Forza Vitra": DI(911, 912, 1, 23, 2, 24),
"Advanced Forza Corpus": DI(919, 920, 1, 23, 2, 24),
"Advanced Forza Chiro R": DI(927, 928, 1, 23, 2, 24),
"Advanced Forza Chiro L": DI(935, 936, 1, 23, 2, 24),
"Advanced Forza Plantars": DI(943, 944, 1, 23, 2, 24),
"Worn Reginal Vitra": DI(945, 946, 1, 23, 2, 24),
"Worn Reginal Corpus": DI(953, 954, 1, 23, 2, 24),
"Worn Reginal Chiro R": DI(961, 962, 1, 23, 2, 24),
"Worn Reginal Chiro L": DI(969, 970, 1, 23, 2, 24),
"Worn Reginal Plantars": DI(977, 978, 1, 23, 2, 24),
"Advanced Reginal Vitra": DI(947, 948, 1, 23, 2, 24),
"Advanced Reginal Corpus": DI(955, 956, 1, 23, 2, 24),
"Advanced Reginal Chiro R": DI(963, 964, 1, 23, 2, 24),
"Advanced Reginal Chiro L": DI(971, 972, 1, 23, 2, 24),
"Advanced Reginal Plantars": DI(979, 980, 1, 23, 2, 24),
"Advanced Combat Cassida": DI(867, 868, 1, 23, 2, 24),
"Advanced Combat Arma": DI(875, 876, 1, 23, 2, 24),
"Advanced Combat Manus R": DI(883, 884, 1, 23, 2, 24),
"Advanced Combat Manus L": DI(891, 892, 1, 23, 2, 24),
"Advanced Combat Crura": DI(899, 900, 1, 23, 2, 24),
"Worn Vivid Cassida": DI(869, 870, 1, 23, 2, 24),
"Worn Vivid Arma": DI(877, 878, 1, 23, 2, 24),
"Worn Vivid Manus R": DI(885, 886, 1, 23, 2, 24),
"Worn Vivid Manus L": DI(893, 894, 1, 23, 2, 24),
"Worn Vivid Crura": DI(901, 902, 1, 23, 2, 24),
"Advanced Vivid Cassida": DI(871, 872, 1, 23, 2, 24),
"Advanced Vivid Arma": DI(879, 880, 1, 23, 2, 24),
"Advanced Vivid Manus R": DI(887, 888, 1, 23, 2, 24),
"Advanced Vivid Manus L": DI(895, 896, 1, 23, 2, 24),
"Advanced Vivid Crura": DI(903, 904, 1, 23, 2, 24),
"Worn Valor Cassida": DI(905, 906, 1, 23, 2, 24),
"Worn Valor Arma": DI(913, 914, 1, 23, 2, 24),
"Worn Valor Manus R": DI(921, 922, 1, 23, 2, 24),
"Worn Valor Manus L": DI(929, 930, 1, 23, 2, 24),
"Worn Valor Crura": DI(937, 938, 1, 23, 2, 24),
"Advanced Valor Cassida": DI(907, 908, 1, 23, 2, 24),
"Advanced Valor Arma": DI(915, 916, 1, 23, 2, 24),
"Advanced Valor Manus R": DI(923, 924, 1, 23, 2, 24),
"Advanced Valor Manus L": DI(931, 932, 1, 23, 2, 24),
"Advanced Valor Crura": DI(939, 940, 1, 23, 2, 24),
"Worn Forza Cassida": DI(909, 910, 1, 23, 2, 24),
"Worn Forza Arma": DI(917, 918, 1, 23, 2, 24),
"Worn Forza Manus R": DI(925, 926, 1, 23, 2, 24),
"Worn Forza Manus L": DI(933, 934, 1, 23, 2, 24),
"Worn Forza Crura": DI(941, 942, 1, 23, 2, 24),
"Advanced Forza Cassida": DI(911, 912, 1, 23, 2, 24),
"Advanced Forza Arma": DI(919, 920, 1, 23, 2, 24),
"Advanced Forza Manus R": DI(927, 928, 1, 23, 2, 24),
"Advanced Forza Manus L": DI(935, 936, 1, 23, 2, 24),
"Advanced Forza Crura": DI(943, 944, 1, 23, 2, 24),
"Worn Reginal Cassida": DI(945, 946, 1, 23, 2, 24),
"Worn Reginal Arma": DI(953, 954, 1, 23, 2, 24),
"Worn Reginal Manus R": DI(961, 962, 1, 23, 2, 24),
"Worn Reginal Manus L": DI(969, 970, 1, 23, 2, 24),
"Worn Reginal Crura": DI(977, 978, 1, 23, 2, 24),
"Advanced Reginal Cassida": DI(947, 948, 1, 23, 2, 24),
"Advanced Reginal Arma": DI(955, 956, 1, 23, 2, 24),
"Advanced Reginal Manus R": DI(963, 964, 1, 23, 2, 24),
"Advanced Reginal Manus L": DI(971, 972, 1, 23, 2, 24),
"Advanced Reginal Crura": DI(979, 980, 1, 23, 2, 24),
"Advanced Combat Screen": DI(987, 988, 1, 23, 2, 24),
"Advanced Combat Breaker": DI(995, 996, 1, 23, 2, 24),
"Advanced Combat Ward R": DI(1003, 1004, 1, 23, 2, 24),
"Advanced Combat Ward L": DI(1011, 1012, 1, 23, 2, 24),
"Advanced Combat Trudgers": DI(1019, 1020, 1, 23, 2, 24),
"Worn Vivid Screen": DI(989, 990, 1, 23, 2, 24),
"Worn Vivid Breaker": DI(997, 998, 1, 23, 2, 24),
"Worn Vivid Ward R": DI(1005, 1006, 1, 23, 2, 24),
"Worn Vivid Ward L": DI(1013, 1014, 1, 23, 2, 24),
"Worn Vivid Trudgers": DI(1021, 1022, 1, 23, 2, 24),
"Advanced Vivid Screen": DI(991, 992, 1, 23, 2, 24),
"Advanced Vivid Breaker": DI(999, 1000, 1, 23, 2, 24),
"Advanced Vivid Ward R": DI(1007, 1008, 1, 23, 2, 24),
"Advanced Vivid Ward L": DI(1015, 1016, 1, 23, 2, 24),
"Advanced Vivid Trudgers": DI(1023, 1024, 1, 23, 2, 24),
"Worn Valor Screen": DI(1025, 1026, 1, 23, 2, 24),
"Worn Valor Breaker": DI(1033, 1034, 1, 23, 2, 24),
"Worn Valor Ward R": DI(1041, 1042, 1, 23, 2, 24),
"Worn Valor Ward L": DI(1049, 1050, 1, 23, 2, 24),
"Worn Valor Trudgers": DI(1057, 1058, 1, 23, 2, 24),
"Advanced Valor Screen": DI(1027, 1028, 1, 23, 2, 24),
"Advanced Valor Breaker": DI(1035, 1036, 1, 23, 2, 24),
"Advanced Valor Ward R": DI(1043, 1044, 1, 23, 2, 24),
"Advanced Valor Ward L": DI(1051, 1052, 1, 23, 2, 24),
"Advanced Valor Trudgers": DI(1059, 1060, 1, 23, 2, 24),
"Worn Forza Screen": DI(1029, 1030, 1, 23, 2, 24),
"Worn Forza Breaker": DI(1037, 1038, 1, 23, 2, 24),
"Worn Forza Ward R": DI(1045, 1046, 1, 23, 2, 24),
"Worn Forza Ward L": DI(1053, 1054, 1, 23, 2, 24),
"Worn Forza Trudgers": DI(1061, 1062, 1, 23, 2, 24),
"Advanced Forza Screen": DI(1031, 1032, 1, 23, 2, 24),
"Advanced Forza Breaker": DI(1039, 1040, 1, 23, 2, 24),
"Advanced Forza Ward R": DI(1047, 1048, 1, 23, 2, 24),
"Advanced Forza Ward L": DI(1055, 1056, 1, 23, 2, 24),
"Advanced Forza Trudgers": DI(1063, 1064, 1, 23, 2, 24),
"Worn Reginal Screen": DI(1065, 1066, 1, 23, 2, 24),
"Worn Reginal Breaker": DI(1073, 1074, 1, 23, 2, 24),
"Worn Reginal Ward R": DI(1081, 1082, 1, 23, 2, 24),
"Worn Reginal Ward L": DI(1089, 1090, 1, 23, 2, 24),
"Worn Reginal Trudgers": DI(1097, 1098, 1, 23, 2, 24),
"Advanced Reginal Screen": DI(1067, 1068, 1, 23, 2, 24),
"Advanced Reginal Breaker": DI(1075, 1076, 1, 23, 2, 24),
"Advanced Reginal Ward R": DI(1083, 1084, 1, 23, 2, 24),
"Advanced Reginal Ward L": DI(1091, 1092, 1, 23, 2, 24),
"Advanced Reginal Trudgers": DI(1099, 1100, 1, 23, 2, 24),
"Advanced Combat Sights": DI(987, 988, 1, 23, 2, 24),
"Advanced Combat Encaser": DI(995, 996, 1, 23, 2, 24),
"Advanced Combat Grip R": DI(1003, 1004, 1, 23, 2, 24),
"Advanced Combat Grip L": DI(1011, 1012, 1, 23, 2, 24),
"Advanced Combat Distancers": DI(1019, 1020, 1, 23, 2, 24),
"Worn Vivid Sights": DI(989, 990, 1, 23, 2, 24),
"Worn Vivid Encaser": DI(997, 998, 1, 23, 2, 24),
"Worn Vivid Grip R": DI(1005, 1006, 1, 23, 2, 24),
"Worn Vivid Grip L": DI(1013, 1014, 1, 23, 2, 24),
"Worn Vivid Distancers": DI(1021, 1022, 1, 23, 2, 24),
"Advanced Vivid Sights": DI(991, 992, 1, 23, 2, 24),
"Advanced Vivid Encaser": DI(999, 1000, 1, 23, 2, 24),
"Advanced Vivid Grip R": DI(1007, 1008, 1, 23, 2, 24),
"Advanced Vivid Grip L": DI(1015, 1016, 1, 23, 2, 24),
"Advanced Vivid Distancers": DI(1023, 1024, 1, 23, 2, 24),
"Worn Valor Sights": DI(1025, 1026, 1, 23, 2, 24),
"Worn Valor Encaser": DI(1033, 1034, 1, 23, 2, 24),
"Worn Valor Grip R": DI(1041, 1042, 1, 23, 2, 24),
"Worn Valor Grip L": DI(1049, 1050, 1, 23, 2, 24),
"Worn Valor Distancers": DI(1057, 1058, 1, 23, 2, 24),
"Advanced Valor Sights": DI(1027, 1028, 1, 23, 2, 24),
"Advanced Valor Encaser": DI(1035, 1036, 1, 23, 2, 24),
"Advanced Valor Grip R": DI(1043, 1044, 1, 23, 2, 24),
"Advanced Valor Grip L": DI(1051, 1052, 1, 23, 2, 24),
"Advanced Valor Distancers": DI(1059, 1060, 1, 23, 2, 24),
"Worn Forza Sights": DI(1029, 1030, 1, 23, 2, 24),
"Worn Forza Encaser": DI(1037, 1038, 1, 23, 2, 24),
"Worn Forza Grip R": DI(1045, 1046, 1, 23, 2, 24),
"Worn Forza Grip L": DI(1053, 1054, 1, 23, 2, 24),
"Worn Forza Distancers": DI(1061, 1062, 1, 23, 2, 24),
"Advanced Forza Sights": DI(1031, 1032, 1, 23, 2, 24),
"Advanced Forza Encaser": DI(1039, 1040, 1, 23, 2, 24),
"Advanced Forza Grip R": DI(1047, 1048, 1, 23, 2, 24),
"Advanced Forza Grip L": DI(1055, 1056, 1, 23, 2, 24),
"Advanced Forza Distancers": DI(1063, 1064, 1, 23, 2, 24),
"Worn Reginal Sights": DI(1065, 1066, 1, 23, 2, 24),
"Worn Reginal Encaser": DI(1073, 1074, 1, 23, 2, 24),
"Worn Reginal Grip R": DI(1081, 1082, 1, 23, 2, 24),
"Worn Reginal Grip L": DI(1089, 1090, 1, 23, 2, 24),
"Worn Reginal Distancers": DI(1097, 1098, 1, 23, 2, 24),
"Advanced Reginal Sights": DI(1067, 1068, 1, 23, 2, 24),
"Advanced Reginal Encaser": DI(1075, 1076, 1, 23, 2, 24),
"Advanced Reginal Grip R": DI(1083, 1084, 1, 23, 2, 24),
"Advanced Reginal Grip L": DI(1091, 1092, 1, 23, 2, 24),
"Advanced Reginal Distancers": DI(1099, 1100, 1, 23, 2, 24),
"Advanced Combat Armet": DI(987, 988, 1, 23, 2, 24),
"Advanced Combat Bulwark": DI(995, 996, 1, 23, 2, 24),
"Advanced Combat Wrest R": DI(1003, 1004, 1, 23, 2, 24),
"Advanced Combat Wrest L": DI(1011, 1012, 1, 23, 2, 24),
"Advanced Combat Stabilizers": DI(1019, 1020, 1, 23, 2, 24),
"Worn Vivid Armet": DI(989, 990, 1, 23, 2, 24),
"Worn Vivid Bulwark": DI(997, 998, 1, 23, 2, 24),
"Worn Vivid Wrest R": DI(1005, 1006, 1, 23, 2, 24),
"Worn Vivid Wrest L": DI(1013, 1014, 1, 23, 2, 24),
"Worn Vivid Stabilizers": DI(1021, 1022, 1, 23, 2, 24),
"Advanced Vivid Armet": DI(991, 992, 1, 23, 2, 24),
"Advanced Vivid Bulwark": DI(999, 1000, 1, 23, 2, 24),
"Advanced Vivid Wrest R": DI(1007, 1008, 1, 23, 2, 24),
"Advanced Vivid Wrest L": DI(1015, 1016, 1, 23, 2, 24),
"Advanced Vivid Stabilizers": DI(1023, 1024, 1, 23, 2, 24),
"Worn Valor Armet": DI(1025, 1026, 1, 23, 2, 24),
"Worn Valor Bulwark": DI(1033, 1034, 1, 23, 2, 24),
"Worn Valor Wrest R": DI(1041, 1042, 1, 23, 2, 24),
"Worn Valor Wrest L": DI(1049, 1050, 1, 23, 2, 24),
"Worn Valor Stabilizers": DI(1057, 1058, 1, 23, 2, 24),
"Advanced Valor Armet": DI(1027, 1028, 1, 23, 2, 24),
"Advanced Valor Bulwark": DI(1035, 1036, 1, 23, 2, 24),
"Advanced Valor Wrest R": DI(1043, 1044, 1, 23, 2, 24),
"Advanced Valor Wrest L": DI(1051, 1052, 1, 23, 2, 24),
"Advanced Valor Stabilizers": DI(1059, 1060, 1, 23, 2, 24),
"Worn Forza Armet": DI(1029, 1030, 1, 23, 2, 24),
"Worn Forza Bulwark": DI(1037, 1038, 1, 23, 2, 24),
"Worn Forza Wrest R": DI(1045, 1046, 1, 23, 2, 24),
"Worn Forza Wrest L": DI(1053, 1054, 1, 23, 2, 24),
"Worn Forza Stabilizers": DI(1061, 1062, 1, 23, 2, 24),
"Advanced Forza Armet": DI(1031, 1032, 1, 23, 2, 24),
"Advanced Forza Bulwark": DI(1039, 1040, 1, 23, 2, 24),
"Advanced Forza Wrest R": DI(1047, 1048, 1, 23, 2, 24),
"Advanced Forza Wrest L": DI(1055, 1056, 1, 23, 2, 24),
"Advanced Forza Stabilizers": DI(1063, 1064, 1, 23, 2, 24),
"Worn Reginal Armet": DI(1065, 1066, 1, 23, 2, 24),
"Worn Reginal Bulwark": DI(1073, 1074, 1, 23, 2, 24),
"Worn Reginal Wrest R": DI(1081, 1082, 1, 23, 2, 24),
"Worn Reginal Wrest L": DI(1089, 1090, 1, 23, 2, 24),
"Worn Reginal Stabilizers": DI(1097, 1098, 1, 23, 2, 24),
"Advanced Reginal Armet": DI(1067, 1068, 1, 23, 2, 24),
"Advanced Reginal Bulwark": DI(1075, 1076, 1, 23, 2, 24),
"Advanced Reginal Wrest R": DI(1083, 1084, 1, 23, 2, 24),
"Advanced Reginal Wrest L": DI(1091, 1092, 1, 23, 2, 24),
"Advanced Reginal Stabilizers": DI(1099, 1100, 1, 23, 2, 24),
"Advanced Vivid Yii": DI(1111, 1112, 1, 23, 2, 24),
"Advanced Vivid Yimsel": DI(1119, 1120, 1, 23, 2, 24),
"Advanced Vivid Yiys R": DI(1127, 1128, 1, 23, 2, 24),
"Advanced Vivid Yiys L": DI(1135, 1136, 1, 23, 2, 24),
"Advanced Vivid Yiym": DI(1143, 1144, 1, 23, 2, 24),
"Worn Valor Yii": DI(1145, 1146, 1, 23, 2, 24),
"Worn Valor Yimsel": DI(1153, 1154, 1, 23, 2, 24),
"Worn Valor Yiys R": DI(1161, 1162, 1, 23, 2, 24),
"Worn Valor Yiys L": DI(1169, 1170, 1, 23, 2, 24),
"Worn Valor Yiym": DI(1177, 1178, 1, 23, 2, 24),
"Advanced Valor Yii": DI(1147, 1148, 1, 23, 2, 24),
"Advanced Valor Yimsel": DI(1155, 1156, 1, 23, 2, 24),
"Advanced Valor Yiys R": DI(1163, 1164, 1, 23, 2, 24),
"Advanced Valor Yiys L": DI(1171, 1172, 1, 23, 2, 24),
"Advanced Valor Yiym": DI(1179, 1180, 1, 23, 2, 24),
"Worn Forza Yii": DI(1149, 1150, 1, 23, 2, 24),
"Worn Forza Yimsel": DI(1157, 1158, 1, 23, 2, 24),
"Worn Forza Yiys R": DI(1165, 1166, 1, 23, 2, 24),
"Worn Forza Yiys L": DI(1173, 1174, 1, 23, 2, 24),
"Worn Forza Yiym": DI(1181, 1182, 1, 23, 2, 24),
"Advanced Forza Yii": DI(1151, 1152, 1, 23, 2, 24),
"Advanced Forza Yimsel": DI(1159, 1160, 1, 23, 2, 24),
"Advanced Forza Yiys R": DI(1167, 1168, 1, 23, 2, 24),
"Advanced Forza Yiys L": DI(1175, 1176, 1, 23, 2, 24),
"Advanced Forza Yiym": DI(1183, 1184, 1, 23, 2, 24),
"Worn Reginal Yii": DI(1185, 1186, 1, 23, 2, 24),
"Worn Reginal Yimsel": DI(1193, 1194, 1, 23, 2, 24),
"Worn Reginal Yiys R": DI(1201, 1202, 1, 23, 2, 24),
"Worn Reginal Yiys L": DI(1209, 1210, 1, 23, 2, 24),
"Worn Reginal Yiym": DI(1217, 1218, 1, 23, 2, 24),
"Advanced Reginal Yii": DI(1187, 1188, 1, 23, 2, 24),
"Advanced Reginal Yimsel": DI(1195, 1196, 1, 23, 2, 24),
"Advanced Reginal Yiys R": DI(1203, 1204, 1, 23, 2, 24),
"Advanced Reginal Yiys L": DI(1211, 1212, 1, 23, 2, 24),
"Advanced Reginal Yiym": DI(1219, 1220, 1, 23, 2, 24),
"Advanced Vivid Ayx": DI(1111, 1112, 1, 23, 2, 24),
"Advanced Vivid Mayx": DI(1119, 1120, 1, 23, 2, 24),
"Advanced Vivid Mayx R": DI(1127, 1128, 1, 23, 2, 24),
"Advanced Vivid Mayx L": DI(1135, 1136, 1, 23, 2, 24),
"Advanced Vivid Nyx": DI(1143, 1144, 1, 23, 2, 24),
"Worn Valor Ayx": DI(1145, 1146, 1, 23, 2, 24),
"Worn Valor Mayx": DI(1153, 1154, 1, 23, 2, 24),
"Worn Valor Mayx R": DI(1161, 1162, 1, 23, 2, 24),
"Worn Valor Mayx L": DI(1169, 1170, 1, 23, 2, 24),
"Worn Valor Nyx": DI(1177, 1178, 1, 23, 2, 24),
"Advanced Valor Ayx": DI(1147, 1148, 1, 23, 2, 24),
"Advanced Valor Mayx": DI(1155, 1156, 1, 23, 2, 24),
"Advanced Valor Mayx R": DI(1163, 1164, 1, 23, 2, 24),
"Advanced Valor Mayx L": DI(1171, 1172, 1, 23, 2, 24),
"Advanced Valor Nyx": DI(1179, 1180, 1, 23, 2, 24),
"Worn Forza Ayx": DI(1149, 1150, 1, 23, 2, 24),
"Worn Forza Mayx": DI(1157, 1158, 1, 23, 2, 24),
"Worn Forza Mayx R": DI(1165, 1166, 1, 23, 2, 24),
"Worn Forza Mayx L": DI(1173, 1174, 1, 23, 2, 24),
"Worn Forza Nyx": DI(1181, 1182, 1, 23, 2, 24),
"Advanced Forza Ayx": DI(1151, 1152, 1, 23, 2, 24),
"Advanced Forza Mayx": DI(1159, 1160, 1, 23, 2, 24),
"Advanced Forza Mayx R": DI(1167, 1168, 1, 23, 2, 24),
"Advanced Forza Mayx L": DI(1175, 1176, 1, 23, 2, 24),
"Advanced Forza Nyx": DI(1183, 1184, 1, 23, 2, 24),
"Worn Reginal Ayx": DI(1185, 1186, 1, 23, 2, 24),
"Worn Reginal Mayx": DI(1193, 1194, 1, 23, 2, 24),
"Worn Reginal Mayx R": DI(1201, 1202, 1, 23, 2, 24),
"Worn Reginal Mayx L": DI(1209, 1210, 1, 23, 2, 24),
"Worn Reginal Nyx": DI(1217, 1218, 1, 23, 2, 24),
"Advanced Reginal Ayx": DI(1187, 1188, 1, 23, 2, 24),
"Advanced Reginal Mayx": DI(1195, 1196, 1, 23, 2, 24),
"Advanced Reginal Mayx R": DI(1203, 1204, 1, 23, 2, 24),
"Advanced Reginal Mayx L": DI(1211, 1212, 1, 23, 2, 24),
"Advanced Reginal Nyx": DI(1219, 1220, 1, 23, 2, 24),
"Advanced Vivid Zyi": DI(1111, 1112, 1, 23, 2, 24),
"Advanced Vivid Zyua": DI(1119, 1120, 1, 23, 2, 24),
"Advanced Vivid Zyua R": DI(1127, 1128, 1, 23, 2, 24),
"Advanced Vivid Zyua L": DI(1135, 1136, 1, 23, 2, 24),
"Advanced Vivid Zyum": DI(1143, 1144, 1, 23, 2, 24),
"Worn Valor Zyi": DI(1145, 1146, 1, 23, 2, 24),
"Worn Valor Zyua": DI(1153, 1154, 1, 23, 2, 24),
"Worn Valor Zyua R": DI(1161, 1162, 1, 23, 2, 24),
"Worn Valor Zyua L": DI(1169, 1170, 1, 23, 2, 24),
"Worn Valor Zyum": DI(1177, 1178, 1, 23, 2, 24),
"Advanced Valor Zyi": DI(1147, 1148, 1, 23, 2, 24),
"Advanced Valor Zyua": DI(1155, 1156, 1, 23, 2, 24),
"Advanced Valor Zyua R": DI(1163, 1164, 1, 23, 2, 24),
"Advanced Valor Zyua L": DI(1171, 1172, 1, 23, 2, 24),
"Advanced Valor Zyum": DI(1179, 1180, 1, 23, 2, 24),
"Worn Forza Zyi": DI(1149, 1150, 1, 23, 2, 24),
"Worn Forza Zyua": DI(1157, 1158, 1, 23, 2, 24),
"Worn Forza Zyua R": DI(1165, 1166, 1, 23, 2, 24),
"Worn Forza Zyua L": DI(1173, 1174, 1, 23, 2, 24),
"Worn Forza Zyum": DI(1181, 1182, 1, 23, 2, 24),
"Advanced Forza Zyi": DI(1151, 1152, 1, 23, 2, 24),
"Advanced Forza Zyua": DI(1159, 1160, 1, 23, 2, 24),
"Advanced Forza Zyua R": DI(1167, 1168, 1, 23, 2, 24),
"Advanced Forza Zyua L": DI(1175, 1176, 1, 23, 2, 24),
"Advanced Forza Zyum": DI(1183, 1184, 1, 23, 2, 24),
"Worn Reginal Zyi": DI(1185, 1186, 1, 23, 2, 24),
"Worn Reginal Zyua": DI(1193, 1194, 1, 23, 2, 24),
"Worn Reginal Zyua R": DI(1201, 1202, 1, 23, 2, 24),
"Worn Reginal Zyua L": DI(1209, 1210, 1, 23, 2, 24),
"Worn Reginal Zyum": DI(1217, 1218, 1, 23, 2, 24),
"Advanced Reginal Zyi": DI(1187, 1188, 1, 23, 2, 24),
"Advanced Reginal Zyua": DI(1195, 1196, 1, 23, 2, 24),
"Advanced Reginal Zyua R": DI(1203, 1204, 1, 23, 2, 24),
"Advanced Reginal Zyua L": DI(1211, 1212, 1, 23, 2, 24),
"Advanced Reginal Zyum": DI(1219, 1220, 1, 23, 2, 24),
"Advanced Warrior's Mask": DI(1231, 1232, 1, 23, 2, 24),
"Advanced Light Warrior's Plate": DI(1239, 1240, 1, 23, 2, 24),
"Advanced Warrior's Bracer R": DI(1247, 1248, 1, 23, 2, 24),
"Advanced Warrior's Bracer L": DI(1255, 1256, 1, 23, 2, 24),
"Advanced Warrior's Sabatons": DI(1263, 1264, 1, 23, 2, 24),
"Worn Vanquisher's Mask": DI(1265, 1266, 1, 23, 2, 24),
"Worn Light Vanquisher's Plate": DI(1273, 1274, 1, 23, 2, 24),
"Worn Vanquisher's Bracer R": DI(1281, 1282, 1, 23, 2, 24),
"Worn Vanquisher's Bracer L": DI(1289, 1290, 1, 23, 2, 24),
"Worn Vanquisher's Sabatons": DI(1297, 1298, 1, 23, 2, 24),
"Advanced Vanquisher's Mask": DI(1267, 1268, 1, 23, 2, 24),
"Advanced Light Vanquisher's Plate": DI(1275, 1276, 1, 23, 2, 24),
"Advanced Vanquisher's Bracer R": DI(1283, 1284, 1, 23, 2, 24),
"Advanced Vanquisher's Bracer L": DI(1291, 1292, 1, 23, 2, 24),
"Advanced Vanquisher's Sabatons": DI(1299, 1300, 1, 23, 2, 24),
"Worn Overlord's Mask": DI(1269, 1270, 1, 23, 2, 24),
"Worn Light Overlord's Plate": DI(1277, 1278, 1, 23, 2, 24),
"Worn Overlord's Bracer R": DI(1285, 1286, 1, 23, 2, 24),
"Worn Overlord's Bracer L": DI(1293, 1294, 1, 23, 2, 24),
"Worn Overlord's Sabatons": DI(1301, 1302, 1, 23, 2, 24),
"Advanced Overlord's Mask": DI(1271, 1272, 1, 23, 2, 24),
"Advanced Light Overlord's Plate": DI(1279, 1280, 1, 23, 2, 24),
"Advanced Overlord's Bracer R": DI(1287, 1288, 1, 23, 2, 24),
"Advanced Overlord's Bracer L": DI(1295, 1296, 1, 23, 2, 24),
"Advanced Overlord's Sabatons": DI(1303, 1304, 1, 23, 2, 24),
"Worn Mother God's Mask": DI(1305, 1306, 1, 23, 2, 24),
"Worn Light Mother God's Plate": DI(1313, 1314, 1, 23, 2, 24),
"Worn Mother God's Bracer R": DI(1321, 1322, 1, 23, 2, 24),
"Worn Mother God's Bracer L": DI(1329, 1330, 1, 23, 2, 24),
"Worn Mother God's Sabatons": DI(1337, 1338, 1, 23, 2, 24),
"Advanced Mother God's Mask": DI(1307, 1308, 1, 23, 2, 24),
"Advanced Light Mother God's Plate": DI(1315, 1316, 1, 23, 2, 24),
"Advanced Mother God's Bracer R": DI(1323, 1324, 1, 23, 2, 24),
"Advanced Mother God's Bracer L": DI(1331, 1332, 1, 23, 2, 24),
"Advanced Mother God's Sabatons": DI(1339, 1340, 1, 23, 2, 24),
"Advanced Warrior's Crest": DI(1231, 1232, 1, 23, 2, 24),
"Advanced Warrior's Plate": DI(1239, 1240, 1, 23, 2, 24),
"Advanced Warrior's Gauntlet R": DI(1247, 1248, 1, 23, 2, 24),
"Advanced Warrior's Gauntlet L": DI(1255, 1256, 1, 23, 2, 24),
"Advanced Warrior's Greaves": DI(1263, 1264, 1, 23, 2, 24),
"Worn Vanquisher's Crest": DI(1265, 1266, 1, 23, 2, 24),
"Worn Vanquisher's Plate": DI(1273, 1274, 1, 23, 2, 24),
"Worn Vanquisher's Gauntlet R": DI(1281, 1282, 1, 23, 2, 24),
"Worn Vanquisher's Gauntlet L": DI(1289, 1290, 1, 23, 2, 24),
"Worn Vanquisher's Greaves": DI(1297, 1298, 1, 23, 2, 24),
"Advanced Vanquisher's Crest": DI(1267, 1268, 1, 23, 2, 24),
"Advanced Vanquisher's Plate": DI(1275, 1276, 1, 23, 2, 24),
"Advanced Vanquisher's Gauntlet R": DI(1283, 1284, 1, 23, 2, 24),
"Advanced Vanquisher's Gauntlet L": DI(1291, 1292, 1, 23, 2, 24),
"Advanced Vanquisher's Greaves": DI(1299, 1300, 1, 23, 2, 24),
"Worn Overlord's Crest": DI(1269, 1270, 1, 23, 2, 24),
"Worn Overlord's Plate": DI(1277, 1278, 1, 23, 2, 24),
"Worn Overlord's Gauntlet R": DI(1285, 1286, 1, 23, 2, 24),
"Worn Overlord's Gauntlet L": DI(1293, 1294, 1, 23, 2, 24),
"Worn Overlord's Greaves": DI(1301, 1302, 1, 23, 2, 24),
"Advanced Overlord's Crest": DI(1271, 1272, 1, 23, 2, 24),
"Advanced Overlord's Plate": DI(1279, 1280, 1, 23, 2, 24),
"Advanced Overlord's Gauntlet R": DI(1287, 1288, 1, 23, 2, 24),
"Advanced Overlord's Gauntlet L": DI(1295, 1296, 1, 23, 2, 24),
"Advanced Overlord's Greaves": DI(1303, 1304, 1, 23, 2, 24),
"Worn Mother God's Crest": DI(1305, 1306, 1, 23, 2, 24),
"Worn Mother God's Plate": DI(1313, 1314, 1, 23, 2, 24),
"Worn Mother God's Gauntlet R": DI(1321, 1322, 1, 23, 2, 24),
"Worn Mother God's Gauntlet L": DI(1329, 1330, 1, 23, 2, 24),
"Worn Mother God's Greaves": DI(1337, 1338, 1, 23, 2, 24),
"Advanced Mother God's Crest": DI(1307, 1308, 1, 23, 2, 24),
"Advanced Mother God's Plate": DI(1315, 1316, 1, 23, 2, 24),
"Advanced Mother God's Gauntlet R": DI(1323, 1324, 1, 23, 2, 24),
"Advanced Mother God's Gauntlet L": DI(1331, 1332, 1, 23, 2, 24),
"Advanced Mother God's Greaves": DI(1339, 1340, 1, 23, 2, 24),
"Advanced Warrior's Helm": DI(1231, 1232, 1, 23, 2, 24),
"Advanced Heavy Warrior's Plate": DI(1239, 1240, 1, 23, 2, 24),
"Advanced Warrior's Vambrace R": DI(1247, 1248, 1, 23, 2, 24),
"Advanced Warrior's Vambrace L": DI(1255, 1256, 1, 23, 2, 24),
"Advanced Heavy Warrior's Greaves": DI(1263, 1264, 1, 23, 2, 24),
"Worn Vanquisher's Helm": DI(1265, 1266, 1, 23, 2, 24),
"Worn Heavy Vanquisher's Plate": DI(1273, 1274, 1, 23, 2, 24),
"Worn Vanquisher's Vambrace R": DI(1281, 1282, 1, 23, 2, 24),
"Worn Vanquisher's Vambrace L": DI(1289, 1290, 1, 23, 2, 24),
"Worn Heavy Vanquisher's Greaves": DI(1297, 1298, 1, 23, 2, 24),
"Advanced Vanquisher's Helm": DI(1267, 1268, 1, 23, 2, 24),
"Advanced Heavy Vanquisher's Plate": DI(1275, 1276, 1, 23, 2, 24),
"Advanced Vanquisher's Vambrace R": DI(1283, 1284, 1, 23, 2, 24),
"Advanced Vanquisher's Vambrace L": DI(1291, 1292, 1, 23, 2, 24),
"Advanced Heavy Vanquisher's Greaves": DI(1299, 1300, 1, 23, 2, 24),
"Worn Overlord's Helm": DI(1269, 1270, 1, 23, 2, 24),
"Worn Heavy Overlord's Plate": DI(1277, 1278, 1, 23, 2, 24),
"Worn Overlord's Vambrace R": DI(1285, 1286, 1, 23, 2, 24),
"Worn Overlord's Vambrace L": DI(1293, 1294, 1, 23, 2, 24),
"Worn Heavy Overlord's Greaves": DI(1301, 1302, 1, 23, 2, 24),
"Advanced Overlord's Helm": DI(1271, 1272, 1, 23, 2, 24),
"Advanced Heavy Overlord's Plate": DI(1279, 1280, 1, 23, 2, 24),
"Advanced Overlord's Vambrace R": DI(1287, 1288, 1, 23, 2, 24),
"Advanced Overlord's Vambrace L": DI(1295, 1296, 1, 23, 2, 24),
"Advanced Heavy Overlord's Greaves": DI(1303, 1304, 1, 23, 2, 24),
"Worn Mother God's Helm": DI(1305, 1306, 1, 23, 2, 24),
"Worn Heavy Mother God's Plate": DI(1313, 1314, 1, 23, 2, 24),
"Worn Mother God's Vambrace R": DI(1321, 1322, 1, 23, 2, 24),
"Worn Mother God's Vambrace L": DI(1329, 1330, 1, 23, 2, 24),
"Worn Heavy Mother God's Greaves": DI(1337, 1338, 1, 23, 2, 24),
"Advanced Mother God's Helm": DI(1307, 1308, 1, 23, 2, 24),
"Advanced Heavy Mother God's Plate": DI(1315, 1316, 1, 23, 2, 24),
"Advanced Mother God's Vambrace R": DI(1323, 1324, 1, 23, 2, 24),
"Advanced Mother God's Vambrace L": DI(1331, 1332, 1, 23, 2, 24),
"Advanced Heavy Mother God's Greaves": DI(1339, 1340, 1, 23, 2, 24),
"Ultra Regal Headset": DI(689, 690, 1, 23, 2, 24),
"Ultra Regal Shirt": DI(697, 698, 1, 23, 2, 24),
"Ultra Regal Sleeve R": DI(705, 706, 1, 23, 2, 24),
"Ultra Regal Sleeve L": DI(713, 714, 1, 23, 2, 24),
"Ultra Regal Pants": DI(721, 722, 1, 23, 2, 24),
"Ultra Infinite Headset": DI(691, 692, 1, 23, 2, 24),
"Ultra Infinite Shirt": DI(699, 700, 1, 23, 2, 24),
"Ultra Infinite Sleeve R": DI(707, 708, 1, 23, 2, 24),
"Ultra Infinite Sleeve L": DI(715, 716, 1, 23, 2, 24),
"Ultra Infinite Pants": DI(723, 724, 1, 23, 2, 24),
"Ultra Regal Visor": DI(689, 690, 1, 23, 2, 24),
"Ultra Regal Vest": DI(697, 698, 1, 23, 2, 24),
"Ultra Regal Guard R": DI(705, 706, 1, 23, 2, 24),
"Ultra Regal Guard L": DI(713, 714, 1, 23, 2, 24),
"Ultra Regal Boots": DI(721, 722, 1, 23, 2, 24),
"Ultra Infinite Visor": DI(691, 692, 1, 23, 2, 24),
"Ultra Infinite Vest": DI(699, 700, 1, 23, 2, 24),
"Ultra Infinite Guard R": DI(707, 708, 1, 23, 2, 24),
"Ultra Infinite Guard L": DI(715, 716, 1, 23, 2, 24),
"Ultra Infinite Boots": DI(723, 724, 1, 23, 2, 24),
"Ultra Regal Goggles": DI(689, 690, 1, 23, 2, 24),
"Ultra Regal Bodywear": DI(697, 698, 1, 23, 2, 24),
"Ultra Regal Glove R": DI(705, 706, 1, 23, 2, 24),
"Ultra Regal Glove L": DI(713, 714, 1, 23, 2, 24),
"Ultra Regal Footwear": DI(721, 722, 1, 23, 2, 24),
"Ultra Infinite Goggles": DI(691, 692, 1, 23, 2, 24),
"Ultra Infinite Bodywear": DI(699, 700, 1, 23, 2, 24),
"Ultra Infinite Glove R": DI(707, 708, 1, 23, 2, 24),
"Ultra Infinite Glove L": DI(715, 716, 1, 23, 2, 24),
"Ultra Infinite Footwear": DI(723, 724, 1, 23, 2, 24),
"Ultra Regal Headwear": DI(689, 690, 1, 23, 2, 24),
"Ultra Regal Armor": DI(697, 698, 1, 23, 2, 24),
"Ultra Regal Armwear R": DI(705, 706, 1, 23, 2, 24),
"Ultra Regal Armwear L": DI(713, 714, 1, 23, 2, 24),
"Ultra Regal Legwear": DI(721, 722, 1, 23, 2, 24),
"Ultra Infinite Headwear": DI(691, 692, 1, 23, 2, 24),
"Ultra Infinite Armor": DI(699, 700, 1, 23, 2, 24),
"Ultra Infinite Armwear R": DI(707, 708, 1, 23, 2, 24),
"Ultra Infinite Armwear L": DI(715, 716, 1, 23, 2, 24),
"Ultra Infinite Legwear": DI(723, 724, 1, 23, 2, 24),
"Ultra Regal Helmet": DI(1429, 1430, 1, 23, 2, 24),
"Ultra Regal Suit": DI(1437, 1438, 1, 23, 2, 24),
"Ultra Regal Mitt R": DI(1445, 1446, 1, 23, 2, 24),
"Ultra Regal Mitt L": DI(1453, 1454, 1, 23, 2, 24),
"Ultra Regal Leggings": DI(1461, 1462, 1, 23, 2, 24),
"Ultra Infinite Helmet": DI(1431, 1432, 1, 23, 2, 24),
"Ultra Infinite Suit": DI(1439, 1440, 1, 23, 2, 24),
"Ultra Infinite Mitt R": DI(1447, 1448, 1, 23, 2, 24),
"Ultra Infinite Mitt L": DI(1455, 1456, 1, 23, 2, 24),
"Ultra Infinite Leggings": DI(1463, 1464, 1, 23, 2, 24),
"Ultra Regal Veyes": DI(829, 830, 1, 23, 2, 24),
"Ultra Regal Norak": DI(837, 838, 1, 23, 2, 24),
"Ultra Regal Tecta R": DI(845, 846, 1, 23, 2, 24),
"Ultra Regal Tecta L": DI(853, 854, 1, 23, 2, 24),
"Ultra Regal Brogs": DI(861, 862, 1, 23, 2, 24),
"Ultra Infinite Veyes": DI(831, 832, 1, 23, 2, 24),
"Ultra Infinite Norak": DI(839, 840, 1, 23, 2, 24),
"Ultra Infinite Tecta R": DI(847, 848, 1, 23, 2, 24),
"Ultra Infinite Tecta L": DI(855, 856, 1, 23, 2, 24),
"Ultra Infinite Brogs": DI(863, 864, 1, 23, 2, 24),
"Ultra Regal Spex": DI(829, 830, 1, 23, 2, 24),
"Ultra Regal Torse": DI(837, 838, 1, 23, 2, 24),
"Ultra Regal Quantlet R": DI(845, 846, 1, 23, 2, 24),
"Ultra Regal Quantlet L": DI(853, 854, 1, 23, 2, 24),
"Ultra Regal Soales": DI(861, 862, 1, 23, 2, 24),
"Ultra Infinite Spex": DI(831, 832, 1, 23, 2, 24),
"Ultra Infinite Torse": DI(839, 840, 1, 23, 2, 24),
"Ultra Infinite Quantlet R": DI(847, 848, 1, 23, 2, 24),
"Ultra Infinite Quantlet L": DI(855, 856, 1, 23, 2, 24),
"Ultra Infinite Soales": DI(863, 864, 1, 23, 2, 24),
"Ultra Regal Tuesta": DI(829, 830, 1, 23, 2, 24),
"Ultra Regal Ryg": DI(837, 838, 1, 23, 2, 24),
"Ultra Regal Brax R": DI(845, 846, 1, 23, 2, 24),
"Ultra Regal Brax L": DI(853, 854, 1, 23, 2, 24),
"Ultra Regal Traves": DI(861, 862, 1, 23, 2, 24),
"Ultra Infinite Tuesta": DI(831, 832, 1, 23, 2, 24),
"Ultra Infinite Ryg": DI(839, 840, 1, 23, 2, 24),
"Ultra Infinite Brax R": DI(847, 848, 1, 23, 2, 24),
"Ultra Infinite Brax L": DI(855, 856, 1, 23, 2, 24),
"Ultra Infinite Traves": DI(863, 864, 1, 23, 2, 24),
"Ultra Regal Casca": DI(1549, 1550, 1, 23, 2, 24),
"Ultra Regal Raim": DI(1557, 1558, 1, 23, 2, 24),
"Ultra Regal Guante R": DI(1565, 1566, 1, 23, 2, 24),
"Ultra Regal Guante L": DI(1573, 1574, 1, 23, 2, 24),
"Ultra Regal Tythes": DI(1581, 1582, 1, 23, 2, 24),
"Ultra Infinite Casca": DI(1551, 1552, 1, 23, 2, 24),
"Ultra Infinite Raim": DI(1559, 1560, 1, 23, 2, 24),
"Ultra Infinite Guante R": DI(1567, 1568, 1, 23, 2, 24),
"Ultra Infinite Guante L": DI(1575, 1576, 1, 23, 2, 24),
"Ultra Infinite Tythes": DI(1583, 1584, 1, 23, 2, 24),
"Ultra Regal Vizard": DI(949, 950, 1, 23, 2, 24),
"Ultra Regal Vestis": DI(957, 958, 1, 23, 2, 24),
"Ultra Regal Armilla R": DI(965, 966, 1, 23, 2, 24),
"Ultra Regal Armilla L": DI(973, 974, 1, 23, 2, 24),
"Ultra Regal Ocreis": DI(981, 982, 1, 23, 2, 24),
"Ultra Infinite Vizard": DI(951, 952, 1, 23, 2, 24),
"Ultra Infinite Vestis": DI(959, 960, 1, 23, 2, 24),
"Ultra Infinite Armilla R": DI(967, 968, 1, 23, 2, 24),
"Ultra Infinite Armilla L": DI(975, 976, 1, 23, 2, 24),
"Ultra Infinite Ocreis": DI(983, 984, 1, 23, 2, 24),
"Ultra Regal Vitra": DI(949, 950, 1, 23, 2, 24),
"Ultra Regal Corpus": DI(957, 958, 1, 23, 2, 24),
"Ultra Regal Chiro R": DI(965, 966, 1, 23, 2, 24),
"Ultra Regal Chiro L": DI(973, 974, 1, 23, 2, 24),
"Ultra Regal Plantars": DI(981, 982, 1, 23, 2, 24),
"Ultra Infinite Vitra": DI(951, 952, 1, 23, 2, 24),
"Ultra Infinite Corpus": DI(959, 960, 1, 23, 2, 24),
"Ultra Infinite Chiro R": DI(967, 968, 1, 23, 2, 24),
"Ultra Infinite Chiro L": DI(975, 976, 1, 23, 2, 24),
"Ultra Infinite Plantars": DI(983, 984, 1, 23, 2, 24),
"Ultra Regal Cassida": DI(949, 950, 1, 23, 2, 24),
"Ultra Regal Arma": DI(957, 958, 1, 23, 2, 24),
"Ultra Regal Manus R": DI(965, 966, 1, 23, 2, 24),
"Ultra Regal Manus L": DI(973, 974, 1, 23, 2, 24),
"Ultra Regal Crura": DI(981, 982, 1, 23, 2, 24),
"Ultra Infinite Cassida": DI(951, 952, 1, 23, 2, 24),
"Ultra Infinite Arma": DI(959, 960, 1, 23, 2, 24),
"Ultra Infinite Manus R": DI(967, 968, 1, 23, 2, 24),
"Ultra Infinite Manus L": DI(975, 976, 1, 23, 2, 24),
"Ultra Infinite Crura": DI(983, 984, 1, 23, 2, 24),
"Ultra Regal Screen": DI(1069, 1070, 1, 23, 2, 24),
"Ultra Regal Breaker": DI(1077, 1078, 1, 23, 2, 24),
"Ultra Regal Ward R": DI(1085, 1086, 1, 23, 2, 24),
"Ultra Regal Ward L": DI(1093, 1094, 1, 23, 2, 24),
"Ultra Regal Trudgers": DI(1101, 1102, 1, 23, 2, 24),
"Ultra Infinite Screen": DI(1071, 1072, 1, 23, 2, 24),
"Ultra Infinite Breaker": DI(1079, 1080, 1, 23, 2, 24),
"Ultra Infinite Ward R": DI(1087, 1088, 1, 23, 2, 24),
"Ultra Infinite Ward L": DI(1095, 1096, 1, 23, 2, 24),
"Ultra Infinite Trudgers": DI(1103, 1104, 1, 23, 2, 24),
"Ultra Regal Sights": DI(1069, 1070, 1, 23, 2, 24),
"Ultra Regal Encaser": DI(1077, 1078, 1, 23, 2, 24),
"Ultra Regal Grip R": DI(1085, 1086, 1, 23, 2, 24),
"Ultra Regal Grip L": DI(1093, 1094, 1, 23, 2, 24),
"Ultra Regal Distancers": DI(1101, 1102, 1, 23, 2, 24),
"Ultra Infinite Sights": DI(1071, 1072, 1, 23, 2, 24),
"Ultra Infinite Encaser": DI(1079, 1080, 1, 23, 2, 24),
"Ultra Infinite Grip R": DI(1087, 1088, 1, 23, 2, 24),
"Ultra Infinite Grip L": DI(1095, 1096, 1, 23, 2, 24),
"Ultra Infinite Distancers": DI(1103, 1104, 1, 23, 2, 24),
"Ultra Regal Armet": DI(1069, 1070, 1, 23, 2, 24),
"Ultra Regal Bulwark": DI(1077, 1078, 1, 23, 2, 24),
"Ultra Regal Wrest R": DI(1085, 1086, 1, 23, 2, 24),
"Ultra Regal Wrest L": DI(1093, 1094, 1, 23, 2, 24),
"Ultra Regal Stabilizers": DI(1101, 1102, 1, 23, 2, 24),
"Ultra Infinite Armet": DI(1071, 1072, 1, 23, 2, 24),
"Ultra Infinite Bulwark": DI(1079, 1080, 1, 23, 2, 24),
"Ultra Infinite Wrest R": DI(1087, 1088, 1, 23, 2, 24),
"Ultra Infinite Wrest L": DI(1095, 1096, 1, 23, 2, 24),
"Ultra Infinite Stabilizers": DI(1103, 1104, 1, 23, 2, 24),
"Ultra Regal Yii": DI(1189, 1190, 1, 23, 2, 24),
"Ultra Regal Yimsel": DI(1197, 1198, 1, 23, 2, 24),
"Ultra Regal Yiys R": DI(1205, 1206, 1, 23, 2, 24),
"Ultra Regal Yiys L": DI(1213, 1214, 1, 23, 2, 24),
"Ultra Regal Yiym": DI(1221, 1222, 1, 23, 2, 24),
"Ultra Infinite Yii": DI(1191, 1192, 1, 23, 2, 24),
"Ultra Infinite Yimsel": DI(1199, 1200, 1, 23, 2, 24),
"Ultra Infinite Yiys R": DI(1207, 1208, 1, 23, 2, 24),
"Ultra Infinite Yiys L": DI(1215, 1216, 1, 23, 2, 24),
"Ultra Infinite Yiym": DI(1223, 1224, 1, 23, 2, 24),
"Ultra Regal Ayx": DI(1189, 1190, 1, 23, 2, 24),
"Ultra Regal Mayx": DI(1197, 1198, 1, 23, 2, 24),
"Ultra Regal Mayx R": DI(1205, 1206, 1, 23, 2, 24),
"Ultra Regal Mayx L": DI(1213, 1214, 1, 23, 2, 24),
"Ultra Regal Nyx": DI(1221, 1222, 1, 23, 2, 24),
"Ultra Infinite Ayx": DI(1191, 1192, 1, 23, 2, 24),
"Ultra Infinite Mayx": DI(1199, 1200, 1, 23, 2, 24),
"Ultra Infinite Mayx R": DI(1207, 1208, 1, 23, 2, 24),
"Ultra Infinite Mayx L": DI(1215, 1216, 1, 23, 2, 24),
"Ultra Infinite Nyx": DI(1223, 1224, 1, 23, 2, 24),
"Ultra Regal Zyi": DI(1189, 1190, 1, 23, 2, 24),
"Ultra Regal Zyua": DI(1197, 1198, 1, 23, 2, 24),
"Ultra Regal Zyua R": DI(1205, 1206, 1, 23, 2, 24),
"Ultra Regal Zyua L": DI(1213, 1214, 1, 23, 2, 24),
"Ultra Regal Zyum": DI(1221, 1222, 1, 23, 2, 24),
"Ultra Infinite Zyi": DI(1191, 1192, 1, 23, 2, 24),
"Ultra Infinite Zyua": DI(1199, 1200, 1, 23, 2, 24),
"Ultra Infinite Zyua R": DI(1207, 1208, 1, 23, 2, 24),
"Ultra Infinite Zyua L": DI(1215, 1216, 1, 23, 2, 24),
"Ultra Infinite Zyum": DI(1223, 1224, 1, 23, 2, 24),
"Ultra Deific Mask": DI(1309, 1310, 1, 23, 2, 24),
"Ultra Deific Light Plate": DI(1317, 1318, 1, 23, 2, 24),
"Ultra Deific Bracer R": DI(1325, 1326, 1, 23, 2, 24),
"Ultra Deific Bracer L": DI(1333, 1334, 1, 23, 2, 24),
"Ultra Deific Sabatons": DI(1341, 1342, 1, 23, 2, 24),
"Ultra Boundless Mask": DI(1311, 1312, 1, 23, 2, 24),
"Ultra Boundless Light Plate": DI(1319, 1320, 1, 23, 2, 24),
"Ultra Boundless Bracer R": DI(1327, 1328, 1, 23, 2, 24),
"Ultra Boundless Bracer L": DI(1335, 1336, 1, 23, 2, 24),
"Ultra Boundless Sabatons": DI(1343, 1344, 1, 23, 2, 24),
"Ultra Deific Crest": DI(1309, 1310, 1, 23, 2, 24),
"Ultra Deific Plate": DI(1317, 1318, 1, 23, 2, 24),
"Ultra Deific Gauntlet R": DI(1325, 1326, 1, 23, 2, 24),
"Ultra Deific Gauntlet L": DI(1333, 1334, 1, 23, 2, 24),
"Ultra Deific Greaves": DI(1341, 1342, 1, 23, 2, 24),
"Ultra Boundless Crest": DI(1311, 1312, 1, 23, 2, 24),
"Ultra Boundless Plate": DI(1319, 1320, 1, 23, 2, 24),
"Ultra Boundless Gauntlet R": DI(1327, 1328, 1, 23, 2, 24),
"Ultra Boundless Gauntlet L": DI(1335, 1336, 1, 23, 2, 24),
"Ultra Boundless Greaves": DI(1343, 1344, 1, 23, 2, 24),
"Ultra Deific Helm": DI(1309, 1310, 1, 23, 2, 24),
"Ultra Heavy Deific Plate": DI(1317, 1318, 1, 23, 2, 24),
"Ultra Deific Vambrace R": DI(1325, 1326, 1, 23, 2, 24),
"Ultra Deific Vambrace L": DI(1333, 1334, 1, 23, 2, 24),
"Ultra Deific Heavy Greaves": DI(1341, 1342, 1, 23, 2, 24),
"Ultra Boundless Helm": DI(1311, 1312, 1, 23, 2, 24),
"Ultra Boundless Heavy Plate": DI(1319, 1320, 1, 23, 2, 24),
"Ultra Boundless Vambrace R": DI(1327, 1328, 1, 23, 2, 24),
"Ultra Boundless Vambrace L": DI(1335, 1336, 1, 23, 2, 24),
"Ultra Boundless Heavy Greaves": DI(1343, 1344, 1, 23, 2, 24),
"Advanced Iron Sword": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Sword": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Sword": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Sword": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Sword": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Sword": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Sword": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Sword": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Sword": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Sword": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Sword": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Sword": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Sword II": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Sword II": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Sword II": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Sword II": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Sword II": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Sword II": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Sword II": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Sword II": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Sword II": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Sword II": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Sword II": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Sword II": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Slair": DI(109, 110, 1, 25, 2, 26),
"Worn Titanium Slair": DI(111, 112, 1, 25, 2, 26),
"Advanced Titanium Slair": DI(117, 118, 1, 25, 2, 26),
"Worn Chrome Slair": DI(119, 120, 1, 25, 2, 26),
"Advanced Chrome Slair": DI(121, 122, 1, 25, 2, 26),
"Worn Cobalt Slair": DI(123, 124, 1, 25, 2, 26),
"Advanced Cobalt Slair": DI(145, 146, 1, 25, 2, 26),
"Worn Chromoly Slair": DI(147, 148, 1, 25, 2, 26),
"Advanced Chromoly Slair": DI(149, 150, 1, 25, 2, 26),
"Worn Cermet Slair": DI(151, 152, 1, 25, 2, 26),
"Advanced Cermet Slair": DI(169, 170, 1, 25, 2, 26),
"Worn Carbide Slair": DI(171, 172, 1, 25, 2, 26),
"Advanced Iron Slair II": DI(109, 110, 1, 25, 2, 26),
"Worn Titanium Slair II": DI(111, 112, 1, 25, 2, 26),
"Advanced Titanium Slair II": DI(117, 118, 1, 25, 2, 26),
"Worn Chrome Slair II": DI(119, 120, 1, 25, 2, 26),
"Advanced Chrome Slair II": DI(121, 122, 1, 25, 2, 26),
"Worn Cobalt Slair II": DI(123, 124, 1, 25, 2, 26),
"Advanced Cobalt Slair II": DI(145, 146, 1, 25, 2, 26),
"Worn Chromoly Slair II": DI(147, 148, 1, 25, 2, 26),
"Advanced Chromoly Slair II": DI(149, 150, 1, 25, 2, 26),
"Worn Cermet Slair II": DI(151, 152, 1, 25, 2, 26),
"Advanced Cermet Slair II": DI(169, 170, 1, 25, 2, 26),
"Worn Carbide Slair II": DI(171, 172, 1, 25, 2, 26),
"Worn Chrome Spatha": DI(195, 196, 1, 25, 2, 26),
"Advanced Chrome Spatha": DI(197, 198, 1, 25, 2, 26),
"Worn Cobalt Spatha": DI(199, 200, 1, 25, 2, 26),
"Advanced Cobalt Spatha": DI(217, 218, 1, 25, 2, 26),
"Worn Chromoly Spatha": DI(219, 220, 1, 25, 2, 26),
"Advanced Chromoly Spatha": DI(221, 222, 1, 25, 2, 26),
"Worn Cermet Spatha": DI(223, 224, 1, 25, 2, 26),
"Advanced Cermet Spatha": DI(241, 242, 1, 25, 2, 26),
"Worn Carbide Spatha": DI(243, 244, 1, 25, 2, 26),
"Advanced Chrome Pride": DI(413, 414, 1, 25, 2, 26),
"Worn Cobalt Pride": DI(415, 416, 1, 25, 2, 26),
"Advanced Cobalt Pride": DI(433, 434, 1, 25, 2, 26),
"Worn Chromoly Pride": DI(435, 436, 1, 25, 2, 26),
"Advanced Chromoly Pride": DI(437, 438, 1, 25, 2, 26),
"Worn Cermet Pride": DI(439, 440, 1, 25, 2, 26),
"Advanced Cermet Pride": DI(457, 458, 1, 25, 2, 26),
"Worn Carbide Pride": DI(459, 460, 1, 25, 2, 26),
"Advanced Steelbreaker Glaive": DI(553, 554, 1, 25, 2, 26),
"Worn Pulverizing Glaive": DI(555, 556, 1, 25, 2, 26),
"Advanced Pulverizing Glaive": DI(557, 558, 1, 25, 2, 26),
"Worn Intrepid Glaive": DI(559, 560, 1, 25, 2, 26),
"Advanced Intrepid Glaive": DI(569, 570, 1, 25, 2, 26),
"Worn Audacious Glaive": DI(571, 572, 1, 25, 2, 26),
"Advanced Steelbreaker Glaive II": DI(553, 554, 1, 25, 2, 26),
"Worn Pulverizing Glaive II": DI(555, 556, 1, 25, 2, 26),
"Advanced Pulverizing Glaive II": DI(557, 558, 1, 25, 2, 26),
"Worn Intrepid Glaive II": DI(559, 560, 1, 25, 2, 26),
"Advanced Intrepid Glaive II": DI(569, 570, 1, 25, 2, 26),
"Worn Audacious Glaive II": DI(571, 572, 1, 25, 2, 26),
"Ultra Ceramic Sword": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Sword": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Sword II": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Sword II": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Slair": DI(173, 174, 1, 25, 2, 26),
"Ultra Diamond Slair": DI(175, 176, 1, 25, 2, 26),
"Ultra Ceramic Slair II": DI(173, 174, 1, 25, 2, 26),
"Ultra Diamond Slair II": DI(175, 176, 1, 25, 2, 26),
"Ultra Ceramic Spatha": DI(245, 246, 1, 25, 2, 26),
"Ultra Diamond Spatha": DI(247, 248, 1, 25, 2, 26),
"Ultra Ceramic Pride": DI(461, 462, 1, 25, 2, 26),
"Ultra Diamond Pride": DI(463, 464, 1, 25, 2, 26),
"Ultra Godbreaker Glaive": DI(573, 574, 1, 25, 2, 26),
"Ultra Phenomenon Glaive": DI(575, 576, 1, 25, 2, 26),
"Ultra Godbreaker Glaive II": DI(573, 574, 1, 25, 2, 26),
"Ultra Phenomenon Glaive II": DI(575, 576, 1, 25, 2, 26),
"Advanced Iron Blades": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Blades": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Blades": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Blades": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Blades": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Blades": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Blades": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Blades": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Blades": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Blades": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Blades": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Blades": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Blades II": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Blades II": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Blades II": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Blades II": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Blades II": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Blades II": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Blades II": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Blades II": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Blades II": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Blades II": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Blades II": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Blades II": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Ralzes": DI(109, 110, 1, 25, 2, 26),
"Worn Titanium Ralzes": DI(111, 112, 1, 25, 2, 26),
"Advanced Titanium Ralzes": DI(117, 118, 1, 25, 2, 26),
"Worn Chrome Ralzes": DI(119, 120, 1, 25, 2, 26),
"Advanced Chrome Ralzes": DI(121, 122, 1, 25, 2, 26),
"Worn Cobalt Ralzes": DI(123, 124, 1, 25, 2, 26),
"Advanced Cobalt Ralzes": DI(145, 146, 1, 25, 2, 26),
"Worn Chromoly Ralzes": DI(147, 148, 1, 25, 2, 26),
"Advanced Chromoly Ralzes": DI(149, 150, 1, 25, 2, 26),
"Worn Cermet Ralzes": DI(151, 152, 1, 25, 2, 26),
"Advanced Cermet Ralzes": DI(169, 170, 1, 25, 2, 26),
"Worn Carbide Ralzes": DI(171, 172, 1, 25, 2, 26),
"Worn Chrome Gladiis": DI(195, 196, 1, 25, 2, 26),
"Advanced Chrome Gladiis": DI(197, 198, 1, 25, 2, 26),
"Worn Cobalt Gladiis": DI(199, 200, 1, 25, 2, 26),
"Advanced Cobalt Gladiis": DI(217, 218, 1, 25, 2, 26),
"Worn Chromoly Gladiis": DI(219, 220, 1, 25, 2, 26),
"Advanced Chromoly Gladiis": DI(221, 222, 1, 25, 2, 26),
"Worn Cermet Gladiis": DI(223, 224, 1, 25, 2, 26),
"Advanced Cermet Gladiis": DI(241, 242, 1, 25, 2, 26),
"Worn Carbide Gladiis": DI(243, 244, 1, 25, 2, 26),
"Advanced Chrome Twins": DI(269, 270, 1, 25, 2, 26),
"Worn Cobalt Twins": DI(271, 272, 1, 25, 2, 26),
"Advanced Cobalt Twins": DI(289, 290, 1, 25, 2, 26),
"Worn Chromoly Twins": DI(291, 292, 1, 25, 2, 26),
"Advanced Chromoly Twins": DI(293, 294, 1, 25, 2, 26),
"Worn Cermet Twins": DI(295, 296, 1, 25, 2, 26),
"Advanced Cermet Twins": DI(313, 314, 1, 25, 2, 26),
"Worn Carbide Twins": DI(315, 316, 1, 25, 2, 26),
"Worn Cobalt Watxes": DI(487, 488, 1, 25, 2, 26),
"Advanced Cobalt Watxes": DI(505, 506, 1, 25, 2, 26),
"Worn Chromoly Watxes": DI(507, 508, 1, 25, 2, 26),
"Advanced Chromoly Watxes": DI(509, 510, 1, 25, 2, 26),
"Worn Cermet Watxes": DI(511, 512, 1, 25, 2, 26),
"Advanced Cermet Watxes": DI(529, 530, 1, 25, 2, 26),
"Worn Carbide Watxes": DI(531, 532, 1, 25, 2, 26),
"Advanced Steelbreaker Edges II": DI(553, 554, 1, 25, 2, 26),
"Worn Pulverizing Edges II": DI(555, 556, 1, 25, 2, 26),
"Advanced Pulverizing Edges II": DI(557, 558, 1, 25, 2, 26),
"Worn Intrepid Edges II": DI(559, 560, 1, 25, 2, 26),
"Advanced Intrepid Edges II": DI(569, 570, 1, 25, 2, 26),
"Worn Audacious Edges II": DI(571, 572, 1, 25, 2, 26),
"Advanced Steelbreaker Edges": DI(553, 554, 1, 25, 2, 26),
"Worn Pulverizing Edges": DI(555, 556, 1, 25, 2, 26),
"Advanced Pulverizing Edges": DI(557, 558, 1, 25, 2, 26),
"Worn Intrepid Edges": DI(559, 560, 1, 25, 2, 26),
"Advanced Intrepid Edges": DI(569, 570, 1, 25, 2, 26),
"Worn Audacious Edges": DI(571, 572, 1, 25, 2, 26),
"Ultra Ceramic Blades": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Blades": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Blades II": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Blades II": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Ralzes": DI(173, 174, 1, 25, 2, 26),
"Ultra Diamond Ralzes": DI(175, 176, 1, 25, 2, 26),
"Ultra Ceramic Gladiis": DI(245, 246, 1, 25, 2, 26),
"Ultra Diamond Gladiis": DI(247, 248, 1, 25, 2, 26),
"Ultra Ceramic Twins": DI(317, 318, 1, 25, 2, 26),
"Ultra Diamond Twins": DI(319, 320, 1, 25, 2, 26),
"Ultra Ceramic Watxes": DI(533, 534, 1, 25, 2, 26),
"Ultra Diamond Watxes": DI(535, 536, 1, 25, 2, 26),
"Ultra Godbreaker Edges II": DI(573, 574, 1, 25, 2, 26),
"Ultra Phenomenon Edges II": DI(575, 576, 1, 25, 2, 26),
"Ultra Godbreaker Edges": DI(573, 574, 1, 25, 2, 26),
"Ultra Phenomenon Edges": DI(575, 576, 1, 25, 2, 26),
"Advanced Iron Knife": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Knife": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Knife": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Knife": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Knife": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Knife": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Knife": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Knife": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Knife": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Knife": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Knife": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Knife": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Knife III": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Knife III": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Knife III": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Knife III": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Knife III": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Knife III": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Knife III": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Knife III": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Knife III": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Knife III": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Knife III": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Knife III": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Knife II": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Knife II": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Knife II": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Knife II": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Knife II": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Knife II": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Knife II": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Knife II": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Knife II": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Knife II": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Knife II": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Knife II": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Riv": DI(109, 110, 1, 25, 2, 26),
"Worn Titanium Riv": DI(111, 112, 1, 25, 2, 26),
"Advanced Titanium Riv": DI(117, 118, 1, 25, 2, 26),
"Worn Chrome Riv": DI(119, 120, 1, 25, 2, 26),
"Advanced Chrome Riv": DI(121, 122, 1, 25, 2, 26),
"Worn Cobalt Riv": DI(123, 124, 1, 25, 2, 26),
"Advanced Cobalt Riv": DI(145, 146, 1, 25, 2, 26),
"Worn Chromoly Riv": DI(147, 148, 1, 25, 2, 26),
"Advanced Chromoly Riv": DI(149, 150, 1, 25, 2, 26),
"Worn Cermet Riv": DI(151, 152, 1, 25, 2, 26),
"Advanced Cermet Riv": DI(169, 170, 1, 25, 2, 26),
"Worn Carbide Riv": DI(171, 172, 1, 25, 2, 26),
"Worn Chrome Pugio": DI(195, 196, 1, 25, 2, 26),
"Advanced Chrome Pugio": DI(197, 198, 1, 25, 2, 26),
"Worn Cobalt Pugio": DI(199, 200, 1, 25, 2, 26),
"Advanced Cobalt Pugio": DI(217, 218, 1, 25, 2, 26),
"Worn Chromoly Pugio": DI(219, 220, 1, 25, 2, 26),
"Advanced Chromoly Pugio": DI(221, 222, 1, 25, 2, 26),
"Worn Cermet Pugio": DI(223, 224, 1, 25, 2, 26),
"Advanced Cermet Pugio": DI(241, 242, 1, 25, 2, 26),
"Worn Carbide Pugio": DI(243, 244, 1, 25, 2, 26),
"Advanced Chrome Pokepoke": DI(341, 342, 1, 25, 2, 26),
"Worn Cobalt Pokepoke": DI(343, 344, 1, 25, 2, 26),
"Advanced Cobalt Pokepoke": DI(361, 362, 1, 25, 2, 26),
"Worn Chromoly Pokepoke": DI(363, 364, 1, 25, 2, 26),
"Advanced Chromoly Pokepoke": DI(365, 366, 1, 25, 2, 26),
"Worn Cermet Pokepoke": DI(367, 368, 1, 25, 2, 26),
"Advanced Cermet Pokepoke": DI(385, 386, 1, 25, 2, 26),
"Worn Carbide Pokepoke": DI(387, 388, 1, 25, 2, 26),
"Worn Cobalt Iyst": DI(487, 488, 1, 25, 2, 26),
"Advanced Cobalt Iyst": DI(505, 506, 1, 25, 2, 26),
"Worn Chromoly Iyst": DI(507, 508, 1, 25, 2, 26),
"Advanced Chromoly Iyst": DI(509, 510, 1, 25, 2, 26),
"Worn Cermet Iyst": DI(511, 512, 1, 25, 2, 26),
"Advanced Cermet Iyst": DI(529, 530, 1, 25, 2, 26),
"Worn Carbide Iyst": DI(531, 532, 1, 25, 2, 26),
"Worn Cobalt Iyst II": DI(487, 488, 1, 25, 2, 26),
"Advanced Cobalt Iyst II": DI(505, 506, 1, 25, 2, 26),
"Worn Chromoly Iyst II": DI(507, 508, 1, 25, 2, 26),
"Advanced Chromoly Iyst II": DI(509, 510, 1, 25, 2, 26),
"Worn Cermet Iyst II": DI(511, 512, 1, 25, 2, 26),
"Advanced Cermet Iyst II": DI(529, 530, 1, 25, 2, 26),
"Worn Carbide Iyst II": DI(531, 532, 1, 25, 2, 26),
"Ultra Ceramic Knife": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Knife": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Knife III": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Knife III": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Knife II": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Knife II": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Riv": DI(173, 174, 1, 25, 2, 26),
"Ultra Diamond Riv": DI(175, 176, 1, 25, 2, 26),
"Ultra Ceramic Pugio": DI(245, 246, 1, 25, 2, 26),
"Ultra Diamond Pugio": DI(247, 248, 1, 25, 2, 26),
"Ultra Ceramic Pokepoke": DI(389, 390, 1, 25, 2, 26),
"Ultra Diamond Pokepoke": DI(391, 392, 1, 25, 2, 26),
"Ultra Ceramic Iyst": DI(533, 534, 1, 25, 2, 26),
"Ultra Diamond Iyst": DI(535, 536, 1, 25, 2, 26),
"Ultra Ceramic Iyst II": DI(533, 534, 1, 25, 2, 26),
"Ultra Diamond Iyst II": DI(535, 536, 1, 25, 2, 26),
"Advanced Iron Shield": DI(41, 42, 1, 25, 2, 26),
"Worn Titanium Shield": DI(43, 44, 1, 25, 2, 26),
"Advanced Titanium Shield": DI(45, 46, 1, 25, 2, 26),
"Worn Chrome Shield": DI(47, 48, 1, 25, 2, 26),
"Advanced Chrome Shield": DI(49, 50, 1, 25, 2, 26),
"Worn Cobalt Shield": DI(51, 52, 1, 25, 2, 26),
"Advanced Cobalt Shield": DI(69, 70, 1, 25, 2, 26),
"Worn Chromoly Shield": DI(71, 72, 1, 25, 2, 26),
"Advanced Chromoly Shield": DI(73, 74, 1, 25, 2, 26),
"Worn Cermet Shield": DI(75, 76, 1, 25, 2, 26),
"Advanced Cermet Shield": DI(93, 94, 1, 25, 2, 26),
"Worn Carbide Shield": DI(95, 96, 1, 25, 2, 26),
"Advanced Iron Paive": DI(125, 126, 1, 25, 2, 26),
"Worn Titanium Paive": DI(127, 128, 1, 25, 2, 26),
"Advanced Titanium Paive": DI(129, 130, 1, 25, 2, 26),
"Worn Chrome Paive": DI(131, 132, 1, 25, 2, 26),
"Advanced Chrome Paive": DI(133, 134, 1, 25, 2, 26),
"Worn Cobalt Paive": DI(135, 136, 1, 25, 2, 26),
"Advanced Cobalt Paive": DI(153, 154, 1, 25, 2, 26),
"Worn Chromoly Paive": DI(155, 156, 1, 25, 2, 26),
"Advanced Chromoly Paive": DI(157, 158, 1, 25, 2, 26),
"Worn Cermet Paive": DI(159, 160, 1, 25, 2, 26),
"Advanced Cermet Paive": DI(177, 178, 1, 25, 2, 26),
"Worn Carbide Paive": DI(179, 180, 1, 25, 2, 26),
"Worn Chrome Parma": DI(203, 204, 1, 25, 2, 26),
"Advanced Chrome Parma": DI(205, 206, 1, 25, 2, 26),
"Worn Cobalt Parma": DI(207, 208, 1, 25, 2, 26),
"Advanced Cobalt Parma": DI(225, 226, 1, 25, 2, 26),
"Worn Chromoly Parma": DI(227, 228, 1, 25, 2, 26),
"Advanced Chromoly Parma": DI(229, 230, 1, 25, 2, 26),
"Worn Cermet Parma": DI(231, 232, 1, 25, 2, 26),
"Advanced Cermet Parma": DI(249, 250, 1, 25, 2, 26),
"Worn Carbide Parma": DI(251, 252, 1, 25, 2, 26),
"Worn Chrome Parma II": DI(203, 204, 1, 25, 2, 26),
"Advanced Chrome Parma II": DI(205, 206, 1, 25, 2, 26),
"Worn Cobalt Parma II": DI(207, 208, 1, 25, 2, 26),
"Advanced Cobalt Parma II": DI(225, 226, 1, 25, 2, 26),
"Worn Chromoly Parma II": DI(227, 228, 1, 25, 2, 26),
"Advanced Chromoly Parma II": DI(229, 230, 1, 25, 2, 26),
"Worn Cermet Parma II": DI(231, 232, 1, 25, 2, 26),
"Advanced Cermet Parma II": DI(249, 250, 1, 25, 2, 26),
"Worn Carbide Parma II": DI(251, 252, 1, 25, 2, 26),
"Advanced Chrome Haven": DI(277, 278, 1, 25, 2, 26),
"Worn Cobalt Haven": DI(279, 280, 1, 25, 2, 26),
"Advanced Cobalt Haven": DI(297, 298, 1, 25, 2, 26),
"Worn Chromoly Haven": DI(299, 300, 1, 25, 2, 26),
"Advanced Chromoly Haven": DI(301, 302, 1, 25, 2, 26),
"Worn Cermet Haven": DI(303, 304, 1, 25, 2, 26),
"Advanced Cermet Haven": DI(321, 322, 1, 25, 2, 26),
"Worn Carbide Haven": DI(323, 324, 1, 25, 2, 26),
"Advanced Chrome Haven II": DI(277, 278, 1, 25, 2, 26),
"Worn Cobalt Haven II": DI(279, 280, 1, 25, 2, 26),
"Advanced Cobalt Haven II": DI(297, 298, 1, 25, 2, 26),
"Worn Chromoly Haven II": DI(299, 300, 1, 25, 2, 26),
"Advanced Chromoly Haven II": DI(301, 302, 1, 25, 2, 26),
"Worn Cermet Haven II": DI(303, 304, 1, 25, 2, 26),
"Advanced Cermet Haven II": DI(321, 322, 1, 25, 2, 26),
"Worn Carbide Haven II": DI(323, 324, 1, 25, 2, 26),
"Advanced Chrome Thudclang": DI(349, 350, 1, 25, 2, 26),
"Worn Cobalt Thudclang": DI(351, 352, 1, 25, 2, 26),
"Advanced Cobalt Thudclang": DI(369, 370, 1, 25, 2, 26),
"Worn Chromoly Thudclang": DI(371, 372, 1, 25, 2, 26),
"Advanced Chromoly Thudclang": DI(373, 374, 1, 25, 2, 26),
"Worn Cermet Thudclang": DI(375, 376, 1, 25, 2, 26),
"Advanced Cermet Thudclang": DI(393, 394, 1, 25, 2, 26),
"Worn Carbide Thudclang": DI(395, 396, 1, 25, 2, 26),
"Advanced Chrome Honor": DI(421, 422, 1, 25, 2, 26),
"Worn Cobalt Honor": DI(423, 424, 1, 25, 2, 26),
"Advanced Cobalt Honor": DI(441, 442, 1, 25, 2, 26),
"Worn Chromoly Honor": DI(443, 444, 1, 25, 2, 26),
"Advanced Chromoly Honor": DI(445, 446, 1, 25, 2, 26),
"Worn Cermet Honor": DI(447, 448, 1, 25, 2, 26),
"Advanced Cermet Honor": DI(465, 466, 1, 25, 2, 26),
"Worn Carbide Honor": DI(467, 468, 1, 25, 2, 26),
"Ultra Ceramic Shield": DI(97, 98, 1, 25, 2, 26),
"Ultra Diamond Shield": DI(99, 100, 1, 25, 2, 26),
"Ultra Ceramic Paive": DI(181, 182, 1, 25, 2, 26),
"Ultra Diamond Paive": DI(183, 184, 1, 25, 2, 26),
"Ultra Ceramic Parma": DI(253, 254, 1, 25, 2, 26),
"Ultra Diamond Parma": DI(255, 256, 1, 25, 2, 26),
"Ultra Ceramic Parma II": DI(253, 254, 1, 25, 2, 26),
"Ultra Diamond Parma II": DI(255, 256, 1, 25, 2, 26),
"Ultra Ceramic Haven": DI(325, 326, 1, 25, 2, 26),
"Ultra Diamond Haven": DI(327, 328, 1, 25, 2, 26),
"Ultra Ceramic Haven II": DI(325, 326, 1, 25, 2, 26),
"Ultra Diamond Haven II": DI(327, 328, 1, 25, 2, 26),
"Ultra Ceramic Thudclang": DI(397, 398, 1, 25, 2, 26),
"Ultra Diamond Thudclang": DI(399, 400, 1, 25, 2, 26),
"Ultra Ceramic Honor": DI(469, 470, 1, 25, 2, 26),
"Ultra Diamond Honor": DI(471, 472, 1, 25, 2, 26),
"Advanced Iron Spear": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Spear": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Spear": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Spear": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Spear": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Spear": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Spear": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Spear": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Spear": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Spear": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Spear": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Spear": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Spear II": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Spear II": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Spear II": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Spear II": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Spear II": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Spear II": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Spear II": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Spear II": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Spear II": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Spear II": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Spear II": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Spear II": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Parce": DI(109, 110, 1, 25, 2, 26),
"Worn Titanium Parce": DI(111, 112, 1, 25, 2, 26),
"Advanced Titanium Parce": DI(117, 118, 1, 25, 2, 26),
"Worn Chrome Parce": DI(119, 120, 1, 25, 2, 26),
"Advanced Chrome Parce": DI(121, 122, 1, 25, 2, 26),
"Worn Cobalt Parce": DI(123, 124, 1, 25, 2, 26),
"Advanced Cobalt Parce": DI(145, 146, 1, 25, 2, 26),
"Worn Chromoly Parce": DI(147, 148, 1, 25, 2, 26),
"Advanced Chromoly Parce": DI(149, 150, 1, 25, 2, 26),
"Worn Cermet Parce": DI(151, 152, 1, 25, 2, 26),
"Advanced Cermet Parce": DI(169, 170, 1, 25, 2, 26),
"Worn Carbide Parce": DI(171, 172, 1, 25, 2, 26),
"Worn Chrome Pilum": DI(195, 196, 1, 25, 2, 26),
"Advanced Chrome Pilum": DI(197, 198, 1, 25, 2, 26),
"Worn Cobalt Pilum": DI(199, 200, 1, 25, 2, 26),
"Advanced Cobalt Pilum": DI(217, 218, 1, 25, 2, 26),
"Worn Chromoly Pilum": DI(219, 220, 1, 25, 2, 26),
"Advanced Chromoly Pilum": DI(221, 222, 1, 25, 2, 26),
"Worn Cermet Pilum": DI(223, 224, 1, 25, 2, 26),
"Advanced Cermet Pilum": DI(241, 242, 1, 25, 2, 26),
"Worn Carbide Pilum": DI(243, 244, 1, 25, 2, 26),
"Worn Chrome Pilum II": DI(195, 196, 1, 25, 2, 26),
"Advanced Chrome Pilum II": DI(197, 198, 1, 25, 2, 26),
"Worn Cobalt Pilum II": DI(199, 200, 1, 25, 2, 26),
"Advanced Cobalt Pilum II": DI(217, 218, 1, 25, 2, 26),
"Worn Chromoly Pilum II": DI(219, 220, 1, 25, 2, 26),
"Advanced Chromoly Pilum II": DI(221, 222, 1, 25, 2, 26),
"Worn Cermet Pilum II": DI(223, 224, 1, 25, 2, 26),
"Advanced Cermet Pilum II": DI(241, 242, 1, 25, 2, 26),
"Worn Carbide Pilum II": DI(243, 244, 1, 25, 2, 26),
"Advanced Chrome Bolide": DI(269, 270, 1, 25, 2, 26),
"Worn Cobalt Bolide": DI(271, 272, 1, 25, 2, 26),
"Advanced Cobalt Bolide": DI(289, 290, 1, 25, 2, 26),
"Worn Chromoly Bolide": DI(291, 292, 1, 25, 2, 26),
"Advanced Chromoly Bolide": DI(293, 294, 1, 25, 2, 26),
"Worn Cermet Bolide": DI(295, 296, 1, 25, 2, 26),
"Advanced Cermet Bolide": DI(313, 314, 1, 25, 2, 26),
"Worn Carbide Bolide": DI(315, 316, 1, 25, 2, 26),
"Worn Cobalt Jyth": DI(487, 488, 1, 25, 2, 26),
"Advanced Cobalt Jyth": DI(505, 506, 1, 25, 2, 26),
"Worn Chromoly Jyth": DI(507, 508, 1, 25, 2, 26),
"Advanced Chromoly Jyth": DI(509, 510, 1, 25, 2, 26),
"Worn Cermet Jyth": DI(511, 512, 1, 25, 2, 26),
"Advanced Cermet Jyth": DI(529, 530, 1, 25, 2, 26),
"Worn Carbide Jyth": DI(531, 532, 1, 25, 2, 26),
"Advanced Steelbreaker Lance": DI(553, 554, 1, 25, 2, 26),
"Worn Pulverizing Lance": DI(555, 556, 1, 25, 2, 26),
"Advanced Pulverizing Lance": DI(557, 558, 1, 25, 2, 26),
"Worn Intrepid Lance": DI(559, 560, 1, 25, 2, 26),
"Advanced Intrepid Lance": DI(569, 570, 1, 25, 2, 26),
"Worn Audacious Lance": DI(571, 572, 1, 25, 2, 26),
"Ultra Ceramic Spear": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Spear": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Spear II": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Spear II": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Parce": DI(173, 174, 1, 25, 2, 26),
"Ultra Diamond Parce": DI(175, 176, 1, 25, 2, 26),
"Ultra Ceramic Pilum": DI(245, 246, 1, 25, 2, 26),
"Ultra Diamond Pilum": DI(247, 248, 1, 25, 2, 26),
"Ultra Ceramic Pilum II": DI(245, 246, 1, 25, 2, 26),
"Ultra Diamond Pilum II": DI(247, 248, 1, 25, 2, 26),
"Ultra Ceramic Bolide": DI(317, 318, 1, 25, 2, 26),
"Ultra Diamond Bolide": DI(319, 320, 1, 25, 2, 26),
"Ultra Ceramic Jyth": DI(533, 534, 1, 25, 2, 26),
"Ultra Diamond Jyth": DI(535, 536, 1, 25, 2, 26),
"Ultra Godbreaker Lance": DI(573, 574, 1, 25, 2, 26),
"Ultra Phenomenon Lance": DI(575, 576, 1, 25, 2, 26),
"Advanced Iron Saber": DI(25, 26, 1, 25, 2, 26),
"Worn Titanium Saber": DI(27, 28, 1, 25, 2, 26),
"Advanced Titanium Saber": DI(33, 34, 1, 25, 2, 26),
"Worn Chrome Saber": DI(35, 36, 1, 25, 2, 26),
"Advanced Chrome Saber": DI(37, 38, 1, 25, 2, 26),
"Worn Cobalt Saber": DI(39, 40, 1, 25, 2, 26),
"Advanced Cobalt Saber": DI(61, 62, 1, 25, 2, 26),
"Worn Chromoly Saber": DI(63, 64, 1, 25, 2, 26),
"Advanced Chromoly Saber": DI(65, 66, 1, 25, 2, 26),
"Worn Cermet Saber": DI(67, 68, 1, 25, 2, 26),
"Advanced Cermet Saber": DI(85, 86, 1, 25, 2, 26),
"Worn Carbide Saber": DI(87, 88, 1, 25, 2, 26),
"Advanced Iron Fulge": DI(109, 110, 1, 25, 2, 26),
"Worn Titanium Fulge": DI(111, 112, 1, 25, 2, 26),
"Advanced Titanium Fulge": DI(117, 118, 1, 25, 2, 26),
"Worn Chrome Fulge": DI(119, 120, 1, 25, 2, 26),
"Advanced Chrome Fulge": DI(121, 122, 1, 25, 2, 26),
"Worn Cobalt Fulge": DI(123, 124, 1, 25, 2, 26),
"Advanced Cobalt Fulge": DI(145, 146, 1, 25, 2, 26),
"Worn Chromoly Fulge": DI(147, 148, 1, 25, 2, 26),
"Advanced Chromoly Fulge": DI(149, 150, 1, 25, 2, 26),
"Worn Cermet Fulge": DI(151, 152, 1, 25, 2, 26),
"Advanced Cermet Fulge": DI(169, 170, 1, 25, 2, 26),
"Worn Carbide Fulge": DI(171, 172, 1, 25, 2, 26),
"Advanced Iron Fulge II": DI(109, 110, 1, 25, 2, 26),
"Worn Titanium Fulge II": DI(111, 112, 1, 25, 2, 26),
"Advanced Titanium Fulge II": DI(117, 118, 1, 25, 2, 26),
"Worn Chrome Fulge II": DI(119, 120, 1, 25, 2, 26),
"Advanced Chrome Fulge II": DI(121, 122, 1, 25, 2, 26),
"Worn Cobalt Fulge II": DI(123, 124, 1, 25, 2, 26),
"Advanced Cobalt Fulge II": DI(145, 146, 1, 25, 2, 26),
"Worn Chromoly Fulge II": DI(147, 148, 1, 25, 2, 26),
"Advanced Chromoly Fulge II": DI(149, 150, 1, 25, 2, 26),
"Worn Cermet Fulge II": DI(151, 152, 1, 25, 2, 26),
"Advanced Cermet Fulge II": DI(169, 170, 1, 25, 2, 26),
"Worn Carbide Fulge II": DI(171, 172, 1, 25, 2, 26),
"Worn Chrome Candela": DI(195, 196, 1, 25, 2, 26),
"Advanced Chrome Candela": DI(197, 198, 1, 25, 2, 26),
"Worn Cobalt Candela": DI(199, 200, 1, 25, 2, 26),
"Advanced Cobalt Candela": DI(217, 218, 1, 25, 2, 26),
"Worn Chromoly Candela": DI(219, 220, 1, 25, 2, 26),
"Advanced Chromoly Candela": DI(221, 222, 1, 25, 2, 26),
"Worn Cermet Candela": DI(223, 224, 1, 25, 2, 26),
"Advanced Cermet Candela": DI(241, 242, 1, 25, 2, 26),
"Worn Carbide Candela": DI(243, 244, 1, 25, 2, 26),
"Worn Chrome Candela II": DI(195, 196, 1, 25, 2, 26),
"Advanced Chrome Candela II": DI(197, 198, 1, 25, 2, 26),
"Worn Cobalt Candela II": DI(199, 200, 1, 25, 2, 26),
"Advanced Cobalt Candela II": DI(217, 218, 1, 25, 2, 26),
"Worn Chromoly Candela II": DI(219, 220, 1, 25, 2, 26),
"Advanced Chromoly Candela II": DI(221, 222, 1, 25, 2, 26),
"Worn Cermet Candela II": DI(223, 224, 1, 25, 2, 26),
"Advanced Cermet Candela II": DI(241, 242, 1, 25, 2, 26),
"Worn Carbide Candela II": DI(243, 244, 1, 25, 2, 26),
"Worn Chrome Candela III": DI(195, 196, 1, 25, 2, 26),
"Advanced Chrome Candela III": DI(197, 198, 1, 25, 2, 26),
"Worn Cobalt Candela III": DI(199, 200, 1, 25, 2, 26),
"Advanced Cobalt Candela III": DI(217, 218, 1, 25, 2, 26),
"Worn Chromoly Candela III": DI(219, 220, 1, 25, 2, 26),
"Advanced Chromoly Candela III": DI(221, 222, 1, 25, 2, 26),
"Worn Cermet Candela III": DI(223, 224, 1, 25, 2, 26),
"Advanced Cermet Candela III": DI(241, 242, 1, 25, 2, 26),
"Worn Carbide Candela III": DI(243, 244, 1, 25, 2, 26),
"Advanced Steelbreaker Lightblade": DI(553, 554, 1, 25, 2, 26),
"Worn Pulverizing Lightblade": DI(555, 556, 1, 25, 2, 26),
"Advanced Pulverizing Lightblade": DI(557, 558, 1, 25, 2, 26),
"Worn Intrepid Lightblade": DI(559, 560, 1, 25, 2, 26),
"Advanced Intrepid Lightblade": DI(569, 570, 1, 25, 2, 26),
"Worn Audacious Lightblade": DI(571, 572, 1, 25, 2, 26),
"Advanced Steelbreaker Lightblade II": DI(553, 554, 1, 25, 2, 26),
"Worn Pulverizing Lightblade II": DI(555, 556, 1, 25, 2, 26),
"Advanced Pulverizing Lightblade II": DI(557, 558, 1, 25, 2, 26),
"Worn Intrepid Lightblade II": DI(559, 560, 1, 25, 2, 26),
"Advanced Intrepid Lightblade II": DI(569, 570, 1, 25, 2, 26),
"Worn Audacious Lightblade II": DI(571, 572, 1, 25, 2, 26),
"Ultra Ceramic Saber": DI(89, 90, 1, 25, 2, 26),
"Ultra Diamond Saber": DI(91, 92, 1, 25, 2, 26),
"Ultra Ceramic Fulge": DI(173, 174, 1, 25, 2, 26),
"Ultra Diamond Fulge": DI(175, 176, 1, 25, 2, 26),
"Ultra Ceramic Fulge II": DI(173, 174, 1, 25, 2, 26),
"Ultra Diamond Fulge II": DI(175, 176, 1, 25, 2, 26),
"Ultra Ceramic Candela": DI(245, 246, 1, 25, 2, 26),
"Ultra Diamond Candela": DI(247, 248, 1, 25, 2, 26),
"Ultra Ceramic Candela II": DI(245, 246, 1, 25, 2, 26),
"Ultra Diamond Candela II": DI(247, 248, 1, 25, 2, 26),
"Ultra Ceramic Candela III": DI(245, 246, 1, 25, 2, 26),
"Ultra Diamond Candela III": DI(247, 248, 1, 25, 2, 26),
"Ultra Godbreaker Lightblade": DI(573, 574, 1, 25, 2, 26),
"Ultra Phenomenon Lightblade": DI(575, 576, 1, 25, 2, 26),
"Ultra Godbreaker Lightblade II": DI(573, 574, 1, 25, 2, 26),
"Ultra Phenomenon Lightblade II": DI(575, 576, 1, 25, 2, 26),
"Advanced Storm Assault Rifle": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Assault Rifle": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Assault Rifle": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Assault Rifle": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Assault Rifle": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Assault Rifle": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Assault Rifle": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Assault Rifle": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Assault Rifle": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Assault Rifle": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Assault Rifle": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Assault Rifle": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Assault Rifle III": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Assault Rifle III": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Assault Rifle III": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Assault Rifle III": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Assault Rifle III": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Assault Rifle III": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Assault Rifle III": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Assault Rifle III": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Assault Rifle III": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Assault Rifle III": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Assault Rifle III": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Assault Rifle III": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Assault Rifle II": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Assault Rifle II": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Assault Rifle II": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Assault Rifle II": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Assault Rifle II": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Assault Rifle II": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Assault Rifle II": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Assault Rifle II": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Assault Rifle II": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Assault Rifle II": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Assault Rifle II": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Assault Rifle II": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Avagar": DI(113, 114, 1, 25, 2, 26),
"Worn Soldier Avagar": DI(115, 116, 1, 25, 2, 26),
"Advanced Soldier Avagar": DI(137, 138, 1, 25, 2, 26),
"Worn Warrior Avagar": DI(139, 140, 1, 25, 2, 26),
"Advanced Warrior Avagar": DI(141, 142, 1, 25, 2, 26),
"Worn Ophidian Avagar": DI(143, 144, 1, 25, 2, 26),
"Advanced Ophidian Avagar": DI(161, 162, 1, 25, 2, 26),
"Worn Destroyer Avagar": DI(163, 164, 1, 25, 2, 26),
"Advanced Destroyer Avagar": DI(165, 166, 1, 25, 2, 26),
"Worn Striker Avagar": DI(167, 168, 1, 25, 2, 26),
"Advanced Striker Avagar": DI(185, 186, 1, 25, 2, 26),
"Worn Delta Avagar": DI(187, 188, 1, 25, 2, 26),
"Worn Warrior Sclopetum": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Sclopetum": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Sclopetum": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Sclopetum": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Sclopetum": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Sclopetum": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Sclopetum": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Sclopetum": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Sclopetum": DI(259, 260, 1, 25, 2, 26),
"Advanced Warrior Assailer": DI(285, 286, 1, 25, 2, 26),
"Worn Ophidian Assailer": DI(287, 288, 1, 25, 2, 26),
"Advanced Ophidian Assailer": DI(305, 306, 1, 25, 2, 26),
"Worn Destroyer Assailer": DI(307, 308, 1, 25, 2, 26),
"Advanced Destroyer Assailer": DI(309, 310, 1, 25, 2, 26),
"Worn Striker Assailer": DI(311, 312, 1, 25, 2, 26),
"Advanced Striker Assailer": DI(329, 330, 1, 25, 2, 26),
"Worn Delta Assailer": DI(331, 332, 1, 25, 2, 26),
"Advanced Warrior Rapture": DI(429, 430, 1, 25, 2, 26),
"Worn Ophidian Rapture": DI(431, 432, 1, 25, 2, 26),
"Advanced Ophidian Rapture": DI(449, 450, 1, 25, 2, 26),
"Worn Destroyer Rapture": DI(451, 452, 1, 25, 2, 26),
"Advanced Destroyer Rapture": DI(453, 454, 1, 25, 2, 26),
"Worn Striker Rapture": DI(455, 456, 1, 25, 2, 26),
"Advanced Striker Rapture": DI(473, 474, 1, 25, 2, 26),
"Worn Delta Rapture": DI(475, 476, 1, 25, 2, 26),
"Advanced Devastator Raidrifle": DI(561, 562, 1, 25, 2, 26),
"Worn Sparrow Raidrifle": DI(563, 564, 1, 25, 2, 26),
"Advanced Sparrow Raidrifle": DI(565, 566, 1, 25, 2, 26),
"Worn Foxfire Raidrifle": DI(567, 568, 1, 25, 2, 26),
"Advanced Foxfire Raidrifle": DI(577, 578, 1, 25, 2, 26),
"Worn Rectifier Raidrifle": DI(579, 580, 1, 25, 2, 26),
"Ultra Cosmic Assault Rifle": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Assault Rifle": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Assault Rifle III": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Assault Rifle III": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Assault Rifle II": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Assault Rifle II": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Avagar": DI(189, 190, 1, 25, 2, 26),
"Ultra Nebulan Avagar": DI(191, 192, 1, 25, 2, 26),
"Ultra Cosmic Sclopetum": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Sclopetum": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Assailer": DI(333, 334, 1, 25, 2, 26),
"Ultra Nebulan Assailer": DI(335, 336, 1, 25, 2, 26),
"Ultra Cosmic Rapture": DI(477, 478, 1, 25, 2, 26),
"Ultra Nebulan Rapture": DI(479, 480, 1, 25, 2, 26),
"Ultra Virtue Raidrifle": DI(581, 582, 1, 25, 2, 26),
"Ultra Transience Raidrifle": DI(583, 584, 1, 25, 2, 26),
"Advanced Storm Dual Guns": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Dual Guns": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Dual Guns": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Dual Guns": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Dual Guns": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Dual Guns": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Dual Guns": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Dual Guns": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Dual Guns": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Dual Guns": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Dual Guns": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Dual Guns": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Dual Guns II": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Dual Guns II": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Dual Guns II": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Dual Guns II": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Dual Guns II": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Dual Guns II": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Dual Guns II": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Dual Guns II": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Dual Guns II": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Dual Guns II": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Dual Guns II": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Dual Guns II": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Gemels": DI(113, 114, 1, 25, 2, 26),
"Worn Soldier Gemels": DI(115, 116, 1, 25, 2, 26),
"Advanced Soldier Gemels": DI(137, 138, 1, 25, 2, 26),
"Worn Warrior Gemels": DI(139, 140, 1, 25, 2, 26),
"Advanced Warrior Gemels": DI(141, 142, 1, 25, 2, 26),
"Worn Ophidian Gemels": DI(143, 144, 1, 25, 2, 26),
"Advanced Ophidian Gemels": DI(161, 162, 1, 25, 2, 26),
"Worn Destroyer Gemels": DI(163, 164, 1, 25, 2, 26),
"Advanced Destroyer Gemels": DI(165, 166, 1, 25, 2, 26),
"Worn Striker Gemels": DI(167, 168, 1, 25, 2, 26),
"Advanced Striker Gemels": DI(185, 186, 1, 25, 2, 26),
"Worn Delta Gemels": DI(187, 188, 1, 25, 2, 26),
"Worn Warrior Pistolia": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Pistolia": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Pistolia": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Pistolia": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Pistolia": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Pistolia": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Pistolia": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Pistolia": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Pistolia": DI(259, 260, 1, 25, 2, 26),
"Advanced Warrior Dyads": DI(285, 286, 1, 25, 2, 26),
"Worn Ophidian Dyads": DI(287, 288, 1, 25, 2, 26),
"Advanced Ophidian Dyads": DI(305, 306, 1, 25, 2, 26),
"Worn Destroyer Dyads": DI(307, 308, 1, 25, 2, 26),
"Advanced Destroyer Dyads": DI(309, 310, 1, 25, 2, 26),
"Worn Striker Dyads": DI(311, 312, 1, 25, 2, 26),
"Advanced Striker Dyads": DI(329, 330, 1, 25, 2, 26),
"Worn Delta Dyads": DI(331, 332, 1, 25, 2, 26),
"Advanced Warrior Dyads III": DI(285, 286, 1, 25, 2, 26),
"Worn Ophidian Dyads III": DI(287, 288, 1, 25, 2, 26),
"Advanced Ophidian Dyads III": DI(305, 306, 1, 25, 2, 26),
"Worn Destroyer Dyads III": DI(307, 308, 1, 25, 2, 26),
"Advanced Destroyer Dyads III": DI(309, 310, 1, 25, 2, 26),
"Worn Striker Dyads III": DI(311, 312, 1, 25, 2, 26),
"Advanced Striker Dyads III": DI(329, 330, 1, 25, 2, 26),
"Worn Delta Dyads III": DI(331, 332, 1, 25, 2, 26),
"Advanced Warrior Dyads II": DI(285, 286, 1, 25, 2, 26),
"Worn Ophidian Dyads II": DI(287, 288, 1, 25, 2, 26),
"Advanced Ophidian Dyads II": DI(305, 306, 1, 25, 2, 26),
"Worn Destroyer Dyads II": DI(307, 308, 1, 25, 2, 26),
"Advanced Destroyer Dyads II": DI(309, 310, 1, 25, 2, 26),
"Worn Striker Dyads II": DI(311, 312, 1, 25, 2, 26),
"Advanced Striker Dyads II": DI(329, 330, 1, 25, 2, 26),
"Worn Delta Dyads II": DI(331, 332, 1, 25, 2, 26),
"Advanced Warrior Bangbangs": DI(357, 358, 1, 25, 2, 26),
"Worn Ophidian Bangbangs": DI(359, 360, 1, 25, 2, 26),
"Advanced Ophidian Bangbangs": DI(377, 378, 1, 25, 2, 26),
"Worn Destroyer Bangbangs": DI(379, 380, 1, 25, 2, 26),
"Advanced Destroyer Bangbangs": DI(381, 382, 1, 25, 2, 26),
"Worn Striker Bangbangs": DI(383, 384, 1, 25, 2, 26),
"Advanced Striker Bangbangs": DI(401, 402, 1, 25, 2, 26),
"Worn Delta Bangbangs": DI(403, 404, 1, 25, 2, 26),
"Advanced Devastator Sidearm": DI(561, 562, 1, 25, 2, 26),
"Worn Sparrow Sidearm": DI(563, 564, 1, 25, 2, 26),
"Advanced Sparrow Sidearm": DI(565, 566, 1, 25, 2, 26),
"Worn Foxfire Sidearm": DI(567, 568, 1, 25, 2, 26),
"Advanced Foxfire Sidearm": DI(577, 578, 1, 25, 2, 26),
"Worn Rectifier Sidearm": DI(579, 580, 1, 25, 2, 26),
"Ultra Cosmic Dual Guns": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Dual Guns": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Dual Guns II": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Dual Guns II": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Gemels": DI(189, 190, 1, 25, 2, 26),
"Ultra Nebulan Gemels": DI(191, 192, 1, 25, 2, 26),
"Ultra Cosmic Pistolia": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Pistolia": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Dyads": DI(333, 334, 1, 25, 2, 26),
"Ultra Nebulan Dyads": DI(335, 336, 1, 25, 2, 26),
"Ultra Cosmic Dyads III": DI(333, 334, 1, 25, 2, 26),
"Ultra Nebulan Dyads III": DI(335, 336, 1, 25, 2, 26),
"Ultra Cosmic Dyads II": DI(333, 334, 1, 25, 2, 26),
"Ultra Nebulan Dyads II": DI(335, 336, 1, 25, 2, 26),
"Ultra Cosmic Bangbangs": DI(405, 406, 1, 25, 2, 26),
"Ultra Nebulan Bangbangs": DI(407, 408, 1, 25, 2, 26),
"Ultra Virtue Sidearm": DI(581, 582, 1, 25, 2, 26),
"Ultra Transience Sidearm": DI(583, 584, 1, 25, 2, 26),
"Advanced Storm Raygun": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Raygun": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Raygun": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Raygun": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Raygun": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Raygun": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Raygun": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Raygun": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Raygun": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Raygun": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Raygun": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Raygun": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Lastyr": DI(113, 114, 1, 25, 2, 26),
"Worn Soldier Lastyr": DI(115, 116, 1, 25, 2, 26),
"Advanced Soldier Lastyr": DI(137, 138, 1, 25, 2, 26),
"Worn Warrior Lastyr": DI(139, 140, 1, 25, 2, 26),
"Advanced Warrior Lastyr": DI(141, 142, 1, 25, 2, 26),
"Worn Ophidian Lastyr": DI(143, 144, 1, 25, 2, 26),
"Advanced Ophidian Lastyr": DI(161, 162, 1, 25, 2, 26),
"Worn Destroyer Lastyr": DI(163, 164, 1, 25, 2, 26),
"Advanced Destroyer Lastyr": DI(165, 166, 1, 25, 2, 26),
"Worn Striker Lastyr": DI(167, 168, 1, 25, 2, 26),
"Advanced Striker Lastyr": DI(185, 186, 1, 25, 2, 26),
"Worn Delta Lastyr": DI(187, 188, 1, 25, 2, 26),
"Advanced Storm Lastyr II": DI(113, 114, 1, 25, 2, 26),
"Worn Soldier Lastyr II": DI(115, 116, 1, 25, 2, 26),
"Advanced Soldier Lastyr II": DI(137, 138, 1, 25, 2, 26),
"Worn Warrior Lastyr II": DI(139, 140, 1, 25, 2, 26),
"Advanced Warrior Lastyr II": DI(141, 142, 1, 25, 2, 26),
"Worn Ophidian Lastyr II": DI(143, 144, 1, 25, 2, 26),
"Advanced Ophidian Lastyr II": DI(161, 162, 1, 25, 2, 26),
"Worn Destroyer Lastyr II": DI(163, 164, 1, 25, 2, 26),
"Advanced Destroyer Lastyr II": DI(165, 166, 1, 25, 2, 26),
"Worn Striker Lastyr II": DI(167, 168, 1, 25, 2, 26),
"Advanced Striker Lastyr II": DI(185, 186, 1, 25, 2, 26),
"Worn Delta Lastyr II": DI(187, 188, 1, 25, 2, 26),
"Advanced Storm Lastyr III": DI(113, 114, 1, 25, 2, 26),
"Worn Soldier Lastyr III": DI(115, 116, 1, 25, 2, 26),
"Advanced Soldier Lastyr III": DI(137, 138, 1, 25, 2, 26),
"Worn Warrior Lastyr III": DI(139, 140, 1, 25, 2, 26),
"Advanced Warrior Lastyr III": DI(141, 142, 1, 25, 2, 26),
"Worn Ophidian Lastyr III": DI(143, 144, 1, 25, 2, 26),
"Advanced Ophidian Lastyr III": DI(161, 162, 1, 25, 2, 26),
"Worn Destroyer Lastyr III": DI(163, 164, 1, 25, 2, 26),
"Advanced Destroyer Lastyr III": DI(165, 166, 1, 25, 2, 26),
"Worn Striker Lastyr III": DI(167, 168, 1, 25, 2, 26),
"Advanced Striker Lastyr III": DI(185, 186, 1, 25, 2, 26),
"Worn Delta Lastyr III": DI(187, 188, 1, 25, 2, 26),
"Worn Warrior Radius": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Radius": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Radius": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Radius": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Radius": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Radius": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Radius": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Radius": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Radius": DI(259, 260, 1, 25, 2, 26),
"Worn Warrior Radius II": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Radius II": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Radius II": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Radius II": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Radius II": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Radius II": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Radius II": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Radius II": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Radius II": DI(259, 260, 1, 25, 2, 26),
"Advanced Warrior Strobe": DI(285, 286, 1, 25, 2, 26),
"Worn Ophidian Strobe": DI(287, 288, 1, 25, 2, 26),
"Advanced Ophidian Strobe": DI(305, 306, 1, 25, 2, 26),
"Worn Destroyer Strobe": DI(307, 308, 1, 25, 2, 26),
"Advanced Destroyer Strobe": DI(309, 310, 1, 25, 2, 26),
"Worn Striker Strobe": DI(311, 312, 1, 25, 2, 26),
"Advanced Striker Strobe": DI(329, 330, 1, 25, 2, 26),
"Worn Delta Strobe": DI(331, 332, 1, 25, 2, 26),
"Advanced Warrior Faith": DI(429, 430, 1, 25, 2, 26),
"Worn Ophidian Faith": DI(431, 432, 1, 25, 2, 26),
"Advanced Ophidian Faith": DI(449, 450, 1, 25, 2, 26),
"Worn Destroyer Faith": DI(451, 452, 1, 25, 2, 26),
"Advanced Destroyer Faith": DI(453, 454, 1, 25, 2, 26),
"Worn Striker Faith": DI(455, 456, 1, 25, 2, 26),
"Advanced Striker Faith": DI(473, 474, 1, 25, 2, 26),
"Worn Delta Faith": DI(475, 476, 1, 25, 2, 26),
"Ultra Cosmic Raygun": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Raygun": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Lastyr": DI(189, 190, 1, 25, 2, 26),
"Ultra Nebulan Lastyr": DI(191, 192, 1, 25, 2, 26),
"Ultra Cosmic Lastyr II": DI(189, 190, 1, 25, 2, 26),
"Ultra Nebulan Lastyr II": DI(191, 192, 1, 25, 2, 26),
"Ultra Cosmic Lastyr III": DI(189, 190, 1, 25, 2, 26),
"Ultra Nebulan Lastyr III": DI(191, 192, 1, 25, 2, 26),
"Ultra Cosmic Radius": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Radius": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Radius II": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Radius II": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Strobe": DI(333, 334, 1, 25, 2, 26),
"Ultra Nebulan Strobe": DI(335, 336, 1, 25, 2, 26),
"Ultra Cosmic Faith": DI(477, 478, 1, 25, 2, 26),
"Ultra Nebulan Faith": DI(479, 480, 1, 25, 2, 26),
"Advanced Storm Machine": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Machine": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Machine": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Machine": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Machine": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Machine": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Machine": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Machine": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Machine": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Machine": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Machine": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Machine": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Machine II": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Machine II": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Machine II": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Machine II": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Machine II": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Machine II": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Machine II": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Machine II": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Machine II": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Machine II": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Machine II": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Machine II": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Repethe": DI(113, 114, 1, 25, 2, 26),
"Worn Soldier Repethe": DI(115, 116, 1, 25, 2, 26),
"Advanced Soldier Repethe": DI(137, 138, 1, 25, 2, 26),
"Worn Warrior Repethe": DI(139, 140, 1, 25, 2, 26),
"Advanced Warrior Repethe": DI(141, 142, 1, 25, 2, 26),
"Worn Ophidian Repethe": DI(143, 144, 1, 25, 2, 26),
"Advanced Ophidian Repethe": DI(161, 162, 1, 25, 2, 26),
"Worn Destroyer Repethe": DI(163, 164, 1, 25, 2, 26),
"Advanced Destroyer Repethe": DI(165, 166, 1, 25, 2, 26),
"Worn Striker Repethe": DI(167, 168, 1, 25, 2, 26),
"Advanced Striker Repethe": DI(185, 186, 1, 25, 2, 26),
"Worn Delta Repethe": DI(187, 188, 1, 25, 2, 26),
"Worn Warrior Grando II": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Grando II": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Grando II": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Grando II": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Grando II": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Grando II": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Grando II": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Grando II": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Grando II": DI(259, 260, 1, 25, 2, 26),
"Worn Warrior Grando": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Grando": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Grando": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Grando": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Grando": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Grando": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Grando": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Grando": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Grando": DI(259, 260, 1, 25, 2, 26),
"Advanced Warrior Crank": DI(285, 286, 1, 25, 2, 26),
"Worn Ophidian Crank": DI(287, 288, 1, 25, 2, 26),
"Advanced Ophidian Crank": DI(305, 306, 1, 25, 2, 26),
"Worn Destroyer Crank": DI(307, 308, 1, 25, 2, 26),
"Advanced Destroyer Crank": DI(309, 310, 1, 25, 2, 26),
"Worn Striker Crank": DI(311, 312, 1, 25, 2, 26),
"Advanced Striker Crank": DI(329, 330, 1, 25, 2, 26),
"Worn Delta Crank": DI(331, 332, 1, 25, 2, 26),
"Advanced Warrior Ratatatta": DI(357, 358, 1, 25, 2, 26),
"Worn Ophidian Ratatatta": DI(359, 360, 1, 25, 2, 26),
"Advanced Ophidian Ratatatta": DI(377, 378, 1, 25, 2, 26),
"Worn Destroyer Ratatatta": DI(379, 380, 1, 25, 2, 26),
"Advanced Destroyer Ratatatta": DI(381, 382, 1, 25, 2, 26),
"Worn Striker Ratatatta": DI(383, 384, 1, 25, 2, 26),
"Advanced Striker Ratatatta": DI(401, 402, 1, 25, 2, 26),
"Worn Delta Ratatatta": DI(403, 404, 1, 25, 2, 26),
"Worn Ophidian Ziyse": DI(503, 504, 1, 25, 2, 26),
"Advanced Ophidian Ziyse": DI(521, 522, 1, 25, 2, 26),
"Worn Destroyer Ziyse": DI(523, 524, 1, 25, 2, 26),
"Advanced Destroyer Ziyse": DI(525, 526, 1, 25, 2, 26),
"Worn Striker Ziyse": DI(527, 528, 1, 25, 2, 26),
"Advanced Striker Ziyse": DI(545, 546, 1, 25, 2, 26),
"Worn Delta Ziyse": DI(547, 548, 1, 25, 2, 26),
"Ultra Cosmic Machine": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Machine": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Machine II": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Machine II": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Repethe": DI(189, 190, 1, 25, 2, 26),
"Ultra Nebulan Repethe": DI(191, 192, 1, 25, 2, 26),
"Ultra Cosmic Grando II": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Grando II": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Grando": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Grando": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Crank": DI(333, 334, 1, 25, 2, 26),
"Ultra Nebulan Crank": DI(335, 336, 1, 25, 2, 26),
"Ultra Cosmic Ratatatta": DI(405, 406, 1, 25, 2, 26),
"Ultra Nebulan Ratatatta": DI(407, 408, 1, 25, 2, 26),
"Ultra Cosmic Ziyse": DI(549, 550, 1, 25, 2, 26),
"Ultra Nebulan Ziyse": DI(551, 552, 1, 25, 2, 26),
"Advanced Storm Sniper Rifle": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Sniper Rifle": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Sniper Rifle": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Sniper Rifle": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Sniper Rifle": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Sniper Rifle": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Sniper Rifle": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Sniper Rifle": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Sniper Rifle": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Sniper Rifle": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Sniper Rifle": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Sniper Rifle": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Sniper Rifle II": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Sniper Rifle II": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Sniper Rifle II": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Sniper Rifle II": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Sniper Rifle II": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Sniper Rifle II": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Sniper Rifle II": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Sniper Rifle II": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Sniper Rifle II": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Sniper Rifle II": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Sniper Rifle II": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Sniper Rifle II": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Retic": DI(113, 114, 1, 25, 2, 26),
"Worn Soldier Retic": DI(115, 116, 1, 25, 2, 26),
"Advanced Soldier Retic": DI(137, 138, 1, 25, 2, 26),
"Worn Warrior Retic": DI(139, 140, 1, 25, 2, 26),
"Advanced Warrior Retic": DI(141, 142, 1, 25, 2, 26),
"Worn Ophidian Retic": DI(143, 144, 1, 25, 2, 26),
"Advanced Ophidian Retic": DI(161, 162, 1, 25, 2, 26),
"Worn Destroyer Retic": DI(163, 164, 1, 25, 2, 26),
"Advanced Destroyer Retic": DI(165, 166, 1, 25, 2, 26),
"Worn Striker Retic": DI(167, 168, 1, 25, 2, 26),
"Advanced Striker Retic": DI(185, 186, 1, 25, 2, 26),
"Worn Delta Retic": DI(187, 188, 1, 25, 2, 26),
"Worn Warrior Sicarius": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Sicarius": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Sicarius": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Sicarius": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Sicarius": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Sicarius": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Sicarius": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Sicarius": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Sicarius": DI(259, 260, 1, 25, 2, 26),
"Advanced Warrior Trigger": DI(285, 286, 1, 25, 2, 26),
"Worn Ophidian Trigger": DI(287, 288, 1, 25, 2, 26),
"Advanced Ophidian Trigger": DI(305, 306, 1, 25, 2, 26),
"Worn Destroyer Trigger": DI(307, 308, 1, 25, 2, 26),
"Advanced Destroyer Trigger": DI(309, 310, 1, 25, 2, 26),
"Worn Striker Trigger": DI(311, 312, 1, 25, 2, 26),
"Advanced Striker Trigger": DI(329, 330, 1, 25, 2, 26),
"Worn Delta Trigger": DI(331, 332, 1, 25, 2, 26),
"Advanced Warrior Thwipper": DI(357, 358, 1, 25, 2, 26),
"Worn Ophidian Thwipper": DI(359, 360, 1, 25, 2, 26),
"Advanced Ophidian Thwipper": DI(377, 378, 1, 25, 2, 26),
"Worn Destroyer Thwipper": DI(379, 380, 1, 25, 2, 26),
"Advanced Destroyer Thwipper": DI(381, 382, 1, 25, 2, 26),
"Worn Striker Thwipper": DI(383, 384, 1, 25, 2, 26),
"Advanced Striker Thwipper": DI(401, 402, 1, 25, 2, 26),
"Worn Delta Thwipper": DI(403, 404, 1, 25, 2, 26),
"Advanced Devastator Deadsight": DI(561, 562, 1, 25, 2, 26),
"Worn Sparrow Deadsight": DI(563, 564, 1, 25, 2, 26),
"Advanced Sparrow Deadsight": DI(565, 566, 1, 25, 2, 26),
"Worn Foxfire Deadsight": DI(567, 568, 1, 25, 2, 26),
"Advanced Foxfire Deadsight": DI(577, 578, 1, 25, 2, 26),
"Worn Rectifier Deadsight": DI(579, 580, 1, 25, 2, 26),
"Advanced Devastator Deadsight II": DI(561, 562, 1, 25, 2, 26),
"Worn Sparrow Deadsight II": DI(563, 564, 1, 25, 2, 26),
"Advanced Sparrow Deadsight II": DI(565, 566, 1, 25, 2, 26),
"Worn Foxfire Deadsight II": DI(567, 568, 1, 25, 2, 26),
"Advanced Foxfire Deadsight II": DI(577, 578, 1, 25, 2, 26),
"Worn Rectifier Deadsight II": DI(579, 580, 1, 25, 2, 26),
"Ultra Cosmic Sniper Rifle": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Sniper Rifle": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Sniper Rifle II": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Sniper Rifle II": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Retic": DI(189, 190, 1, 25, 2, 26),
"Ultra Nebulan Retic": DI(191, 192, 1, 25, 2, 26),
"Ultra Cosmic Sicarius": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Sicarius": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Trigger": DI(333, 334, 1, 25, 2, 26),
"Ultra Nebulan Trigger": DI(335, 336, 1, 25, 2, 26),
"Ultra Cosmic Thwipper": DI(405, 406, 1, 25, 2, 26),
"Ultra Nebulan Thwipper": DI(407, 408, 1, 25, 2, 26),
"Ultra Virtue Deadsight": DI(581, 582, 1, 25, 2, 26),
"Ultra Transience Deadsight": DI(583, 584, 1, 25, 2, 26),
"Ultra Virtue Deadsight II": DI(581, 582, 1, 25, 2, 26),
"Ultra Transience Deadsight II": DI(583, 584, 1, 25, 2, 26),
"Advanced Storm Launchers": DI(29, 30, 1, 25, 2, 26),
"Worn Soldier Launchers": DI(31, 32, 1, 25, 2, 26),
"Advanced Soldier Launchers": DI(53, 54, 1, 25, 2, 26),
"Worn Warrior Launchers": DI(55, 56, 1, 25, 2, 26),
"Advanced Warrior Launchers": DI(57, 58, 1, 25, 2, 26),
"Worn Ophidian Launchers": DI(59, 60, 1, 25, 2, 26),
"Advanced Ophidian Launchers": DI(77, 78, 1, 25, 2, 26),
"Worn Destroyer Launchers": DI(79, 80, 1, 25, 2, 26),
"Advanced Destroyer Launchers": DI(81, 82, 1, 25, 2, 26),
"Worn Striker Launchers": DI(83, 84, 1, 25, 2, 26),
"Advanced Striker Launchers": DI(101, 102, 1, 25, 2, 26),
"Worn Delta Launchers": DI(103, 104, 1, 25, 2, 26),
"Advanced Storm Psylans": DI(113, 114, 1, 25, 2, 26),
"Worn Soldier Psylans": DI(115, 116, 1, 25, 2, 26),
"Advanced Soldier Psylans": DI(137, 138, 1, 25, 2, 26),
"Worn Warrior Psylans": DI(139, 140, 1, 25, 2, 26),
"Advanced Warrior Psylans": DI(141, 142, 1, 25, 2, 26),
"Worn Ophidian Psylans": DI(143, 144, 1, 25, 2, 26),
"Advanced Ophidian Psylans": DI(161, 162, 1, 25, 2, 26),
"Worn Destroyer Psylans": DI(163, 164, 1, 25, 2, 26),
"Advanced Destroyer Psylans": DI(165, 166, 1, 25, 2, 26),
"Worn Striker Psylans": DI(167, 168, 1, 25, 2, 26),
"Advanced Striker Psylans": DI(185, 186, 1, 25, 2, 26),
"Worn Delta Psylans": DI(187, 188, 1, 25, 2, 26),
"Worn Warrior Ruina": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Ruina": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Ruina": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Ruina": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Ruina": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Ruina": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Ruina": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Ruina": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Ruina": DI(259, 260, 1, 25, 2, 26),
"Worn Warrior Ruina II": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Ruina II": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Ruina II": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Ruina II": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Ruina II": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Ruina II": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Ruina II": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Ruina II": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Ruina II": DI(259, 260, 1, 25, 2, 26),
"Worn Warrior Ruina III": DI(211, 212, 1, 25, 2, 26),
"Advanced Warrior Ruina III": DI(213, 214, 1, 25, 2, 26),
"Worn Ophidian Ruina III": DI(215, 216, 1, 25, 2, 26),
"Advanced Ophidian Ruina III": DI(233, 234, 1, 25, 2, 26),
"Worn Destroyer Ruina III": DI(235, 236, 1, 25, 2, 26),
"Advanced Destroyer Ruina III": DI(237, 238, 1, 25, 2, 26),
"Worn Striker Ruina III": DI(239, 240, 1, 25, 2, 26),
"Advanced Striker Ruina III": DI(257, 258, 1, 25, 2, 26),
"Worn Delta Ruina III": DI(259, 260, 1, 25, 2, 26),
"Advanced Warrior Saboteurs": DI(285, 286, 1, 25, 2, 26),
"Worn Ophidian Saboteurs": DI(287, 288, 1, 25, 2, 26),
"Advanced Ophidian Saboteurs": DI(305, 306, 1, 25, 2, 26),
"Worn Destroyer Saboteurs": DI(307, 308, 1, 25, 2, 26),
"Advanced Destroyer Saboteurs": DI(309, 310, 1, 25, 2, 26),
"Worn Striker Saboteurs": DI(311, 312, 1, 25, 2, 26),
"Advanced Striker Saboteurs": DI(329, 330, 1, 25, 2, 26),
"Worn Delta Saboteurs": DI(331, 332, 1, 25, 2, 26),
"Advanced Warrior Fwooshers": DI(357, 358, 1, 25, 2, 26),
"Worn Ophidian Fwooshers": DI(359, 360, 1, 25, 2, 26),
"Advanced Ophidian Fwooshers": DI(377, 378, 1, 25, 2, 26),
"Worn Destroyer Fwooshers": DI(379, 380, 1, 25, 2, 26),
"Advanced Destroyer Fwooshers": DI(381, 382, 1, 25, 2, 26),
"Worn Striker Fwooshers": DI(383, 384, 1, 25, 2, 26),
"Advanced Striker Fwooshers": DI(401, 402, 1, 25, 2, 26),
"Worn Delta Fwooshers": DI(403, 404, 1, 25, 2, 26),
"Worn Ophidian Zorcyses": DI(503, 504, 1, 25, 2, 26),
"Advanced Ophidian Zorcyses": DI(521, 522, 1, 25, 2, 26),
"Worn Destroyer Zorcyses": DI(523, 524, 1, 25, 2, 26),
"Advanced Destroyer Zorcyses": DI(525, 526, 1, 25, 2, 26),
"Worn Striker Zorcyses": DI(527, 528, 1, 25, 2, 26),
"Advanced Striker Zorcyses": DI(545, 546, 1, 25, 2, 26),
"Worn Delta Zorcyses": DI(547, 548, 1, 25, 2, 26),
"Ultra Cosmic Launchers": DI(105, 106, 1, 25, 2, 26),
"Ultra Nebulan Launchers": DI(107, 108, 1, 25, 2, 26),
"Ultra Cosmic Psylans": DI(189, 190, 1, 25, 2, 26),
"Ultra Nebulan Psylans": DI(191, 192, 1, 25, 2, 26),
"Ultra Cosmic Ruina": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Ruina": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Ruina II": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Ruina II": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Ruina III": DI(261, 262, 1, 25, 2, 26),
"Ultra Nebulan Ruina III": DI(263, 264, 1, 25, 2, 26),
"Ultra Cosmic Saboteurs": DI(333, 334, 1, 25, 2, 26),
"Ultra Nebulan Saboteurs": DI(335, 336, 1, 25, 2, 26),
"Ultra Cosmic Fwooshers": DI(405, 406, 1, 25, 2, 26),
"Ultra Nebulan Fwooshers": DI(407, 408, 1, 25, 2, 26),
"Ultra Cosmic Zorcyses": DI(549, 550, 1, 25, 2, 26),
"Ultra Nebulan Zorcyses": DI(551, 552, 1, 25, 2, 26),
"SHM-XM120SA Rod": DI(1585, 1615, 3, 27, 3, 27),
"SHM-XM130SA Rod": DI(1591, 1626, 4, 28, 4, 28),
"SHM-XM140SA Rod": DI(1597, 1637, 5, 29, 5, 29),
"SHM-XM150SA Rod": DI(1603, 1648, 6, 30, 6, 30),
"SHM-XM160SA Rod": DI(1609, 1659, 7, 31, 7, 31),
"SHM-XXM120SA Rod": DI(1585, 1615, 8, 32, 8, 32),
"SHM-XXM130SA Rod": DI(1591, 1626, 9, 33, 9, 33),
"SHM-XXM140SA Rod": DI(1597, 1637, 10, 34, 10, 34),
"SHM-XXM150SA Rod": DI(1603, 1648, 11, 35, 11, 35),
"SHM-XXM160SA Rod": DI(1609, 1659, 12, 36, 12, 36),
"SHM-XM220SA Sword": DI(1585, 1615, 3, 27, 3, 27),
"SHM-XM230SA Sword": DI(1591, 1626, 4, 28, 4, 28),
"SHM-XM240SA Sword": DI(1597, 1637, 5, 29, 5, 29),
"SHM-XM250SA Sword": DI(1603, 1648, 6, 30, 6, 30),
"SHM-XM260SA Sword": DI(1609, 1659, 7, 31, 7, 31),
"SHM-XXM220SA Sword": DI(1585, 1615, 8, 32, 8, 32),
"SHM-XXM230SA Sword": DI(1591, 1626, 9, 33, 9, 33),
"SHM-XXM240SA Sword": DI(1597, 1637, 10, 34, 10, 34),
"SHM-XXM250SA Sword": DI(1603, 1648, 11, 35, 11, 35),
"SHM-XXM260SA Sword": DI(1609, 1659, 12, 36, 12, 36),
"SHM-XM330SA E-Sword": DI(1593, 1628, 4, 28, 4, 28),
"SHM-XM340SA E-Sword": DI(1599, 1639, 5, 29, 5, 29),
"SHM-XM350SA E-Sword": DI(1605, 1650, 6, 30, 6, 30),
"SHM-XM360SA E-Sword": DI(1611, 1661, 7, 31, 7, 31),
"SHM-XXM330SA E-Sword": DI(1593, 1628, 9, 33, 9, 33),
"SHM-XXM340SA E-Sword": DI(1599, 1639, 10, 34, 10, 34),
"SHM-XXM350SA E-Sword": DI(1605, 1650, 11, 35, 11, 35),
"SHM-XXM360SA E-Sword": DI(1611, 1661, 12, 36, 12, 36),
"SHM-XM430SA Pile-Bunker": DI(1591, 1626, 4, 28, 4, 28),
"SHM-XM440SA Pile-Bunker": DI(1597, 1637, 5, 29, 5, 29),
"SHM-XM450SA Pile-Bunker": DI(1603, 1648, 6, 30, 6, 30),
"SHM-XM460SA Pile-Bunker": DI(1609, 1659, 7, 31, 7, 31),
"SHM-XXM430SA Pile-Bunker": DI(1591, 1626, 9, 33, 9, 33),
"SHM-XXM440SA Pile-Bunker": DI(1597, 1637, 10, 34, 10, 34),
"SHM-XXM450SA Pile-Bunker": DI(1603, 1648, 11, 35, 11, 35),
"SHM-XXM460SA Pile-Bunker": DI(1609, 1659, 12, 36, 12, 36),
"SHM-XR120SA Machine Gun": DI(1670, 1700, 3, 27, 3, 27),
"SHM-XR130SA Machine Gun": DI(1676, 1706, 4, 28, 4, 28),
"SHM-XR140SA Machine Gun": DI(1682, 1712, 5, 29, 5, 29),
"SHM-XR150SA Machine Gun": DI(1688, 1718, 6, 30, 6, 30),
"SHM-XR160SA Machine Gun": DI(1694, 1724, 7, 31, 7, 31),
"SHM-XXR120SA Machine Gun": DI(1670, 1700, 8, 32, 8, 32),
"SHM-XXR130SA Machine Gun": DI(1676, 1706, 9, 33, 9, 33),
"SHM-XXR140SA Machine Gun": DI(1682, 1712, 10, 34, 10, 34),
"SHM-XXR150SA Machine Gun": DI(1688, 1718, 11, 35, 11, 35),
"SHM-XXR160SA Machine Gun": DI(1694, 1724, 12, 36, 12, 36),
"SHM-XR230SA E-Machine Gun": DI(1678, 1708, 4, 28, 4, 28),
"SHM-XR240SA E-Machine Gun": DI(1684, 1714, 5, 29, 5, 29),
"SHM-XR250SA E-Machine Gun": DI(1690, 1720, 6, 30, 6, 30),
"SHM-XR260SA E-Machine Gun": DI(1696, 1726, 7, 31, 7, 31),
"SHM-XXR230SA E-Machine Gun": DI(1678, 1708, 9, 33, 9, 33),
"SHM-XXR240SA E-Machine Gun": DI(1684, 1714, 10, 34, 10, 34),
"SHM-XXR250SA E-Machine Gun": DI(1690, 1720, 11, 35, 11, 35),
"SHM-XXR260SA E-Machine Gun": DI(1696, 1726, 12, 36, 12, 36),
"SHM-XR320SA Assault": DI(1670, 1700, 3, 27, 3, 27),
"SHM-XR330SA Assault": DI(1676, 1706, 4, 28, 4, 28),
"SHM-XR340SA Assault": DI(1682, 1712, 5, 29, 5, 29),
"SHM-XR350SA Assault": DI(1688, 1718, 6, 30, 6, 30),
"SHM-XR360SA Assault": DI(1694, 1724, 7, 31, 7, 31),
"SHM-XXR320SA Assault": DI(1670, 1700, 8, 32, 8, 32),
"SHM-XXR330SA Assault": DI(1676, 1706, 9, 33, 9, 33),
"SHM-XXR340SA Assault": DI(1682, 1712, 10, 34, 10, 34),
"SHM-XXR350SA Assault": DI(1688, 1718, 11, 35, 11, 35),
"SHM-XXR360SA Assault": DI(1694, 1724, 12, 36, 12, 36),
"SHM-XR420SA B-Rifle": DI(1671, 1701, 3, 27, 3, 27),
"SHM-XR430SA B-Rifle": DI(1677, 1707, 4, 28, 4, 28),
"SHM-XR440SA B-Rifle": DI(1683, 1713, 5, 29, 5, 29),
"SHM-XR450SA B-Rifle": DI(1689, 1719, 6, 30, 6, 30),
"SHM-XR460SA B-Rifle": DI(1695, 1725, 7, 31, 7, 31),
"SHM-XXR420SA B-Rifle": DI(1671, 1701, 8, 32, 8, 32),
"SHM-XXR430SA B-Rifle": DI(1677, 1707, 9, 33, 9, 33),
"SHM-XXR440SA B-Rifle": DI(1683, 1713, 10, 34, 10, 34),
"SHM-XXR450SA B-Rifle": DI(1689, 1719, 11, 35, 11, 35),
"SHM-XXR460SA B-Rifle": DI(1695, 1725, 12, 36, 12, 36),
"SHM-XXR530SA E-Rifle": DI(1678, 1708, 4, 28, 4, 28),
"SHM-XXR540SA E-Rifle": DI(1684, 1714, 5, 29, 5, 29),
"SHM-XXR550SA E-Rifle": DI(1690, 1720, 6, 30, 6, 30),
"SHM-XXR560SA E-Rifle": DI(1696, 1726, 7, 31, 7, 31),
"SHM-XR421SA Short-Rifle": DI(1671, 1701, 3, 27, 3, 27),
"SHM-XR431SA Short-Rifle": DI(1677, 1707, 4, 28, 4, 28),
"SHM-XR441SA Short-Rifle": DI(1683, 1713, 5, 29, 5, 29),
"SHM-XR451SA Short-Rifle": DI(1689, 1719, 6, 30, 6, 30),
"SHM-XR461SA Short-Rifle": DI(1695, 1725, 7, 31, 7, 31),
"SHM-XXR421SA Short-Rifle": DI(1671, 1701, 8, 32, 8, 32),
"SHM-XXR431SA Short-Rifle": DI(1677, 1707, 9, 33, 9, 33),
"SHM-XXR441SA Short-Rifle": DI(1683, 1713, 10, 34, 10, 34),
"SHM-XXR451SA Short-Rifle": DI(1689, 1719, 11, 35, 11, 35),
"SHM-XXR461SA Short-Rifle": DI(1695, 1725, 12, 36, 12, 36),
"SHM-XR620SA Shotgun": DI(1670, 1700, 3, 27, 3, 27),
"SHM-XR630SA Shotgun": DI(1676, 1706, 4, 28, 4, 28),
"SHM-XR640SA Shotgun": DI(1682, 1712, 5, 29, 5, 29),
"SHM-XR650SA Shotgun": DI(1688, 1718, 6, 30, 6, 30),
"SHM-XR660SA Shotgun": DI(1694, 1724, 7, 31, 7, 31),
"SHM-XXR620SA Shotgun": DI(1670, 1700, 8, 32, 8, 32),
"SHM-XXR630SA Shotgun": DI(1676, 1706, 9, 33, 9, 33),
"SHM-XXR640SA Shotgun": DI(1682, 1712, 10, 34, 10, 34),
"SHM-XXR650SA Shotgun": DI(1688, 1718, 11, 35, 11, 35),
"SHM-XXR660SA Shotgun": DI(1694, 1724, 12, 36, 12, 36),
"SHM-XR720SA Sniper": DI(1670, 1700, 3, 27, 3, 27),
"SHM-XR730SA Sniper": DI(1676, 1706, 4, 28, 4, 28),
"SHM-XR740SA Sniper": DI(1682, 1712, 5, 29, 5, 29),
"SHM-XR750SA Sniper": DI(1688, 1718, 6, 30, 6, 30),
"SHM-XR760SA Sniper": DI(1694, 1724, 7, 31, 7, 31),
"SHM-XXR720SA Sniper": DI(1670, 1700, 8, 32, 8, 32),
"SHM-XXR730SA Sniper": DI(1676, 1706, 9, 33, 9, 33),
"SHM-XXR740SA Sniper": DI(1682, 1712, 10, 34, 10, 34),
"SHM-XXR750SA Sniper": DI(1688, 1718, 11, 35, 11, 35),
"SHM-XXR760SA Sniper": DI(1694, 1724, 12, 36, 12, 36),
"SHM-XR722SA E-Sniper": DI(1670, 1700, 3, 27, 3, 27),
"SHM-XR732SA E-Sniper": DI(1676, 1706, 4, 28, 4, 28),
"SHM-XR742SA E-Sniper": DI(1682, 1712, 5, 29, 5, 29),
"SHM-XR752SA E-Sniper": DI(1688, 1718, 6, 30, 6, 30),
"SHM-XR762SA E-Sniper": DI(1694, 1724, 7, 31, 7, 31),
"SHM-XXR722SA E-Sniper": DI(1670, 1700, 8, 32, 8, 32),
"SHM-XXR732SA E-Sniper": DI(1676, 1706, 9, 33, 9, 33),
"SHM-XXR742SA E-Sniper": DI(1682, 1712, 10, 34, 10, 34),
"SHM-XXR752SA E-Sniper": DI(1688, 1718, 11, 35, 11, 35),
"SHM-XXR762SA E-Sniper": DI(1694, 1724, 12, 36, 12, 36),
"SHM-XR830SA Firegun": DI(1679, 1709, 4, 28, 4, 28),
"SHM-XR840SA Firegun": DI(1685, 1715, 5, 29, 5, 29),
"SHM-XR850SA Firegun": DI(1691, 1721, 6, 30, 6, 30),
"SHM-XR860SA Firegun": DI(1697, 1727, 7, 31, 7, 31),
"SHM-XXR830SA Firegun": DI(1679, 1709, 9, 33, 9, 33),
"SHM-XXR840SA Firegun": DI(1685, 1715, 10, 34, 10, 34),
"SHM-XXR850SA Firegun": DI(1691, 1721, 11, 35, 11, 35),
"SHM-XXR860SA Firegun": DI(1697, 1727, 12, 36, 12, 36),
"SHM-XR920SA L-Cannon": DI(1673, 1703, 3, 27, 3, 27),
"SHM-XR930SA L-Cannon": DI(1679, 1709, 4, 28, 4, 28),
"SHM-XR940SA L-Cannon": DI(1685, 1715, 5, 29, 5, 29),
"SHM-XR950SA L-Cannon": DI(1691, 1721, 6, 30, 6, 30),
"SHM-XR960SA L-Cannon": DI(1697, 1727, 7, 31, 7, 31),
"SHM-XXR920SA L-Cannon": DI(1673, 1703, 8, 32, 8, 32),
"SHM-XXR930SA L-Cannon": DI(1679, 1709, 9, 33, 9, 33),
"SHM-XXR940SA L-Cannon": DI(1685, 1715, 10, 34, 10, 34),
"SHM-XXR950SA L-Cannon": DI(1691, 1721, 11, 35, 11, 35),
"SHM-XXR960SA L-Cannon": DI(1697, 1727, 12, 36, 12, 36),
"SHM-XR1030SA E-Cannon": DI(1678, 1708, 4, 28, 4, 28),
"SHM-XR1040SA E-Cannon": DI(1684, 1714, 5, 29, 5, 29),
"SHM-XR1050SA E-Cannon": DI(1690, 1720, 6, 30, 6, 30),
"SHM-XR1060SA E-Cannon": DI(1696, 1726, 7, 31, 7, 31),
"SHM-XXR1030SA E-Cannon": DI(1678, 1708, 9, 33, 9, 33),
"SHM-XXR1040SA E-Cannon": DI(1684, 1714, 10, 34, 10, 34),
"SHM-XXR1050SA E-Cannon": DI(1690, 1720, 11, 35, 11, 35),
"SHM-XXR1060SA E-Cannon": DI(1696, 1726, 12, 36, 12, 36),
"SHM-XR1120SA Wiregun": DI(1674, 1704, 3, 27, 3, 27),
"SHM-XR1130SA Wiregun": DI(1680, 1710, 4, 28, 4, 28),
"SHM-XR1140SA Wiregun": DI(1686, 1716, 5, 29, 5, 29),
"SHM-XR1150SA Wiregun": DI(1692, 1722, 6, 30, 6, 30),
"SHM-XR1160SA Wiregun": DI(1698, 1728, 7, 31, 7, 31),
"SHM-XXR1120SA Wiregun": DI(1674, 1704, 8, 32, 8, 32),
"SHM-XXR1130SA Wiregun": DI(1680, 1710, 9, 33, 9, 33),
"SHM-XXR1140SA Wiregun": DI(1686, 1716, 10, 34, 10, 34),
"SHM-XXR1150SA Wiregun": DI(1692, 1722, 11, 35, 11, 35),
"SHM-XXR1160SA Wiregun": DI(1698, 1728, 12, 36, 12, 36),
"SHM-XM120GG P-Knife": DI(1589, 1619, 3, 27, 3, 27),
"SHM-XM130GG P-Knife": DI(1595, 1630, 4, 28, 4, 28),
"SHM-XM140GG P-Knife": DI(1601, 1641, 5, 29, 5, 29),
"SHM-XM150GG P-Knife": DI(1607, 1652, 6, 30, 6, 30),
"SHM-XM160GG P-Knife": DI(1613, 1663, 7, 31, 7, 31),
"SHM-XXM120GG P-Knife": DI(1589, 1619, 8, 32, 8, 32),
"SHM-XXM130GG P-Knife": DI(1595, 1630, 9, 33, 9, 33),
"SHM-XXM140GG P-Knife": DI(1601, 1641, 10, 34, 10, 34),
"SHM-XXM150GG P-Knife": DI(1607, 1652, 11, 35, 11, 35),
"SHM-XXM160GG P-Knife": DI(1613, 1663, 12, 36, 12, 36),
"SHM-XM220GG B-Claw": DI(1586, 1616, 3, 27, 3, 27),
"SHM-XM230GG B-Claw": DI(1592, 1627, 4, 28, 4, 28),
"SHM-XM240GG B-Claw": DI(1598, 1638, 5, 29, 5, 29),
"SHM-XM250GG B-Claw": DI(1604, 1649, 6, 30, 6, 30),
"SHM-XM260GG B-Claw": DI(1610, 1660, 7, 31, 7, 31),
"SHM-XXM220GG B-Claw": DI(1586, 1616, 8, 32, 8, 32),
"SHM-XXM230GG B-Claw": DI(1592, 1627, 9, 33, 9, 33),
"SHM-XXM240GG B-Claw": DI(1598, 1638, 10, 34, 10, 34),
"SHM-XXM250GG B-Claw": DI(1604, 1649, 11, 35, 11, 35),
"SHM-XXM260GG B-Claw": DI(1610, 1660, 12, 36, 12, 36),
"SHM-XR120GG HB-Rifle": DI(1671, 1701, 3, 27, 3, 27),
"SHM-XR130GG HB-Rifle": DI(1677, 1707, 4, 28, 4, 28),
"SHM-XR140GG HB-Rifle": DI(1683, 1713, 5, 29, 5, 29),
"SHM-XR150GG HB-Rifle": DI(1689, 1719, 6, 30, 6, 30),
"SHM-XR160GG HB-Rifle": DI(1695, 1725, 7, 31, 7, 31),
"SHM-XXR120GG HB-Rifle": DI(1671, 1701, 8, 32, 8, 32),
"SHM-XXR130GG HB-Rifle": DI(1677, 1707, 9, 33, 9, 33),
"SHM-XXR140GG HB-Rifle": DI(1683, 1713, 10, 34, 10, 34),
"SHM-XXR150GG HB-Rifle": DI(1689, 1719, 11, 35, 11, 35),
"SHM-XXR160GG HB-Rifle": DI(1695, 1725, 12, 36, 12, 36),
"SHM-XR230GG Diskbomb": DI(1679, 1709, 4, 28, 4, 28),
"SHM-XR240GG Diskbomb": DI(1685, 1715, 5, 29, 5, 29),
"SHM-XR250GG Diskbomb": DI(1691, 1721, 6, 30, 6, 30),
"SHM-XR260GG Diskbomb": DI(1697, 1727, 7, 31, 7, 31),
"SHM-XXR230GG Diskbomb": DI(1679, 1709, 9, 33, 9, 33),
"SHM-XXR240GG Diskbomb": DI(1685, 1715, 10, 34, 10, 34),
"SHM-XXR250GG Diskbomb": DI(1691, 1721, 11, 35, 11, 35),
"SHM-XXR260GG Diskbomb": DI(1697, 1727, 12, 36, 12, 36),
"SHM-XM120ME Heat-Edge": DI(1588, 1618, 3, 27, 3, 27),
"SHM-XM130ME Heat-Edge": DI(1594, 1629, 4, 28, 4, 28),
"SHM-XM140ME Heat-Edge": DI(1600, 1640, 5, 29, 5, 29),
"SHM-XM150ME Heat-Edge": DI(1606, 1651, 6, 30, 6, 30),
"SHM-XM160ME Heat-Edge": DI(1612, 1662, 7, 31, 7, 31),
"SHM-XXM120ME Heat-Edge": DI(1588, 1618, 8, 32, 8, 32),
"SHM-XXM130ME Heat-Edge": DI(1594, 1629, 9, 33, 9, 33),
"SHM-XXM140ME Heat-Edge": DI(1600, 1640, 10, 34, 10, 34),
"SHM-XXM150ME Heat-Edge": DI(1606, 1651, 11, 35, 11, 35),
"SHM-XXM160ME Heat-Edge": DI(1612, 1662, 12, 36, 12, 36),
"SHM-XM220ME B-Centipede": DI(1586, 1616, 3, 27, 3, 27),
"SHM-XM230ME B-Centipede": DI(1592, 1627, 4, 28, 4, 28),
"SHM-XM240ME B-Centipede": DI(1598, 1638, 5, 29, 5, 29),
"SHM-XM250ME B-Centipede": DI(1604, 1649, 6, 30, 6, 30),
"SHM-XM260ME B-Centipede": DI(1610, 1660, 7, 31, 7, 31),
"SHM-XXM220ME B-Centipede": DI(1586, 1616, 8, 32, 8, 32),
"SHM-XXM230ME B-Centipede": DI(1592, 1627, 9, 33, 9, 33),
"SHM-XXM240ME B-Centipede": DI(1598, 1638, 10, 34, 10, 34),
"SHM-XXM250ME B-Centipede": DI(1604, 1649, 11, 35, 11, 35),
"SHM-XXM260ME B-Centipede": DI(1610, 1660, 12, 36, 12, 36),
"SHM-XR120ME Bladegun": DI(1670, 1700, 3, 27, 3, 27),
"SHM-XR130ME Bladegun": DI(1676, 1706, 4, 28, 4, 28),
"SHM-XR140ME Bladegun": DI(1682, 1712, 5, 29, 5, 29),
"SHM-XR150ME Bladegun": DI(1688, 1718, 6, 30, 6, 30),
"SHM-XR160ME Bladegun": DI(1694, 1724, 7, 31, 7, 31),
"SHM-XXR120ME Bladegun": DI(1670, 1700, 8, 32, 8, 32),
"SHM-XXR130ME Bladegun": DI(1676, 1706, 9, 33, 9, 33),
"SHM-XXR140ME Bladegun": DI(1682, 1712, 10, 34, 10, 34),
"SHM-XXR150ME Bladegun": DI(1688, 1718, 11, 35, 11, 35),
"SHM-XXR160ME Bladegun": DI(1694, 1724, 12, 36, 12, 36),
"SHM-XR220ME B-Rifle": DI(1671, 1701, 3, 27, 3, 27),
"SHM-XR230ME B-Rifle": DI(1677, 1707, 4, 28, 4, 28),
"SHM-XR240ME B-Rifle": DI(1683, 1713, 5, 29, 5, 29),
"SHM-XR250ME B-Rifle": DI(1689, 1719, 6, 30, 6, 30),
"SHM-XR260ME B-Rifle": DI(1695, 1725, 7, 31, 7, 31),
"SHM-XXR220ME B-Rifle": DI(1671, 1701, 8, 32, 8, 32),
"SHM-XXR230ME B-Rifle": DI(1677, 1707, 9, 33, 9, 33),
"SHM-XXR240ME B-Rifle": DI(1683, 1713, 10, 34, 10, 34),
"SHM-XXR250ME B-Rifle": DI(1689, 1719, 11, 35, 11, 35),
"SHM-XXR260ME B-Rifle": DI(1695, 1725, 12, 36, 12, 36),
"SHM-XR320ME B-XSniper": DI(1671, 1701, 3, 27, 3, 27),
"SHM-XR330ME B-XSniper": DI(1677, 1707, 4, 28, 4, 28),
"SHM-XR340ME B-XSniper": DI(1683, 1713, 5, 29, 5, 29),
"SHM-XR350ME B-XSniper": DI(1689, 1719, 6, 30, 6, 30),
"SHM-XR360ME B-XSniper": DI(1695, 1725, 7, 31, 7, 31),
"SHM-XXR320ME B-XXSniper": DI(1671, 1701, 8, 32, 8, 32),
"SHM-XXR330ME B-XXSniper": DI(1677, 1707, 9, 33, 9, 33),
"SHM-XXR340ME B-XXSniper": DI(1683, 1713, 10, 34, 10, 34),
"SHM-XXR350ME B-XXSniper": DI(1689, 1719, 11, 35, 11, 35),
"SHM-XXR360ME B-XXSniper": DI(1695, 1725, 12, 36, 12, 36),
"SHM-XR420ME Firegun": DI(1673, 1703, 3, 27, 3, 27),
"SHM-XR430ME Firegun": DI(1679, 1709, 4, 28, 4, 28),
"SHM-XR440ME Firegun": DI(1685, 1715, 5, 29, 5, 29),
"SHM-XR450ME Firegun": DI(1691, 1721, 6, 30, 6, 30),
"SHM-XR460ME Firegun": DI(1697, 1727, 7, 31, 7, 31),
"SHM-XXR420ME Firegun": DI(1673, 1703, 8, 32, 8, 32),
"SHM-XXR430ME Firegun": DI(1679, 1709, 9, 33, 9, 33),
"SHM-XXR440ME Firegun": DI(1685, 1715, 10, 34, 10, 34),
"SHM-XXR450ME Firegun": DI(1691, 1721, 11, 35, 11, 35),
"SHM-XXR460ME Firegun": DI(1697, 1727, 12, 36, 12, 36),
"SSM-XR120SA M-Missile": DI(1890, 1895, 3, 27, 3, 27),
"SSM-XR130SA M-Missile": DI(1891, 1896, 4, 28, 4, 28),
"SSM-XR140SA M-Missile": DI(1892, 1897, 5, 29, 5, 29),
"SSM-XR150SA M-Missile": DI(1893, 1898, 6, 30, 6, 30),
"SSM-XR160SA M-Missile": DI(1894, 1899, 7, 31, 7, 31),
"SSM-XXR120SA M-Missile": DI(1890, 1895, 8, 32, 8, 32),
"SSM-XXR130SA M-Missile": DI(1891, 1896, 9, 33, 9, 33),
"SSM-XXR140SA M-Missile": DI(1892, 1897, 10, 34, 10, 34),
"SSM-XXR150SA M-Missile": DI(1893, 1898, 11, 35, 11, 35),
"SSM-XXR160SA M-Missile": DI(1894, 1899, 12, 36, 12, 36),
"SSM-XR220SA HB-Missile": DI(1920, 1925, 3, 27, 3, 27),
"SSM-XR230SA HB-Missile": DI(1921, 1926, 4, 28, 4, 28),
"SSM-XR240SA HB-Missile": DI(1922, 1927, 5, 29, 5, 29),
"SSM-XR250SA HB-Missile": DI(1923, 1928, 6, 30, 6, 30),
"SSM-XR260SA HB-Missile": DI(1924, 1929, 7, 31, 7, 31),
"SSM-XXR220SA HB-Missile": DI(1920, 1925, 8, 32, 8, 32),
"SSM-XXR230SA HB-Missile": DI(1921, 1926, 9, 33, 9, 33),
"SSM-XXR240SA HB-Missile": DI(1922, 1927, 10, 34, 10, 34),
"SSM-XXR250SA HB-Missile": DI(1923, 1928, 11, 35, 11, 35),
"SSM-XXR260SA HB-Missile": DI(1924, 1929, 12, 36, 12, 36),
"SSM-XR220SA F-Grenade": DI(1930, 1935, 3, 27, 3, 27),
"SSM-XR230SA F-Grenade": DI(1931, 1936, 4, 28, 4, 28),
"SSM-XR240SA F-Grenade": DI(1932, 1937, 5, 29, 5, 29),
"SSM-XR250SA F-Grenade": DI(1933, 1938, 6, 30, 6, 30),
"SSM-XR260SA F-Grenade": DI(1934, 1939, 7, 31, 7, 31),
"SSM-XXR220SA F-Grenade": DI(1930, 1935, 8, 32, 8, 32),
"SSM-XXR230SA F-Grenade": DI(1931, 1936, 9, 33, 9, 33),
"SSM-XXR240SA F-Grenade": DI(1932, 1937, 10, 34, 10, 34),
"SSM-XXR250SA F-Grenade": DI(1933, 1938, 11, 35, 11, 35),
"SSM-XXR260SA F-Grenade": DI(1934, 1939, 12, 36, 12, 36),
"SSM-XR320SA SHD-Gatling": DI(1960, 1965, 3, 27, 3, 27),
"SSM-XR330SA SHD-Gatling": DI(1961, 1966, 4, 28, 4, 28),
"SSM-XR340SA SHD-Gatling": DI(1962, 1967, 5, 29, 5, 29),
"SSM-XR350SA SHD-Gatling": DI(1963, 1968, 6, 30, 6, 30),
"SSM-XR360SA SHD-Gatling": DI(1964, 1969, 7, 31, 7, 31),
"SSM-XXR320SA SHD-Gatling": DI(1960, 1965, 8, 32, 8, 32),
"SSM-XXR330SA SHD-Gatling": DI(1961, 1966, 9, 33, 9, 33),
"SSM-XXR340SA SHD-Gatling": DI(1962, 1967, 10, 34, 10, 34),
"SSM-XXR350SA SHD-Gatling": DI(1963, 1968, 11, 35, 11, 35),
"SSM-XXR360SA SHD-Gatling": DI(1964, 1969, 12, 36, 12, 36),
"SSM-XR420SA SHD-Ray": DI(1970, 1975, 3, 27, 3, 27),
"SSM-XR430SA SHD-Ray": DI(1971, 1976, 4, 28, 4, 28),
"SSM-XR440SA SHD-Ray": DI(1972, 1977, 5, 29, 5, 29),
"SSM-XR450SA SHD-Ray": DI(1973, 1978, 6, 30, 6, 30),
"SSM-XR460SA SHD-Ray": DI(1974, 1979, 7, 31, 7, 31),
"SSM-XXR420SA SHD-Ray": DI(1970, 1975, 8, 32, 8, 32),
"SSM-XXR430SA SHD-Ray": DI(1971, 1976, 9, 33, 9, 33),
"SSM-XXR440SA SHD-Ray": DI(1972, 1977, 10, 34, 10, 34),
"SSM-XXR450SA SHD-Ray": DI(1973, 1978, 11, 35, 11, 35),
"SSM-XXR460SA SHD-Ray": DI(1974, 1979, 12, 36, 12, 36),
"SSM-XR520SA Chaingun": DI(2040, 2045, 3, 27, 3, 27),
"SSM-XR530SA Chaingun": DI(2041, 2046, 4, 28, 4, 28),
"SSM-XR540SA Chaingun": DI(2042, 2047, 5, 29, 5, 29),
"SSM-XR550SA Chaingun": DI(2043, 2048, 6, 30, 6, 30),
"SSM-XR560SA Chaingun": DI(2044, 2049, 7, 31, 7, 31),
"SSM-XXR520SA Chaingun": DI(2040, 2045, 8, 32, 8, 32),
"SSM-XXR530SA Chaingun": DI(2041, 2046, 9, 33, 9, 33),
"SSM-XXR540SA Chaingun": DI(2042, 2047, 10, 34, 10, 34),
"SSM-XXR550SA Chaingun": DI(2043, 2048, 11, 35, 11, 35),
"SSM-XXR560SA Chaingun": DI(2044, 2049, 12, 36, 12, 36),
"SSM-XMX120SA G-Buster": DI(1770, 1775, 3, 27, 3, 27),
"SSM-XMX130SA G-Buster": DI(1771, 1776, 4, 28, 4, 28),
"SSM-XMX140SA G-Buster": DI(1772, 1777, 5, 29, 5, 29),
"SSM-XMX150SA G-Buster": DI(1773, 1778, 6, 30, 6, 30),
"SSM-XMX160SA G-Buster": DI(1774, 1779, 7, 31, 7, 31),
"SSM-XXMX120SA G-Buster": DI(1770, 1775, 8, 32, 8, 32),
"SSM-XXMX130SA G-Buster": DI(1771, 1776, 9, 33, 9, 33),
"SSM-XXMX140SA G-Buster": DI(1772, 1777, 10, 34, 10, 34),
"SSM-XXMX150SA G-Buster": DI(1773, 1778, 11, 35, 11, 35),
"SSM-XXMX160SA G-Buster": DI(1774, 1779, 12, 36, 12, 36),
"SSM-XMX130SA G2-Buster": DI(1781, 1786, 4, 28, 4, 28),
"SSM-XMX140SA G2-Buster": DI(1782, 1787, 5, 29, 5, 29),
"SSM-XMX150SA G2-Buster": DI(1783, 1788, 6, 30, 6, 30),
"SSM-XMX160SA G2-Buster": DI(1784, 1789, 7, 31, 7, 31),
"SSM-XXMX130SA G2-Buster": DI(1781, 1786, 9, 33, 9, 33),
"SSM-XXMX140SA G2-Buster": DI(1782, 1787, 10, 34, 10, 34),
"SSM-XXMX150SA G2-Buster": DI(1783, 1788, 11, 35, 11, 35),
"SSM-XXMX160SA G2-Buster": DI(1784, 1789, 12, 36, 12, 36),
"SSM-XMX220SA E-Scythe": DI(1790, 1795, 3, 27, 3, 27),
"SSM-XMX230SA E-Scythe": DI(1791, 1796, 4, 28, 4, 28),
"SSM-XMX240SA E-Scythe": DI(1792, 1797, 5, 29, 5, 29),
"SSM-XMX250SA E-Scythe": DI(1793, 1798, 6, 30, 6, 30),
"SSM-XMX260SA E-Scythe": DI(1794, 1799, 7, 31, 7, 31),
"SSM-XXMX220SA E-Scythe": DI(1790, 1795, 8, 32, 8, 32),
"SSM-XXMX230SA E-Scythe": DI(1791, 1796, 9, 33, 9, 33),
"SSM-XXMX240SA E-Scythe": DI(1792, 1797, 10, 34, 10, 34),
"SSM-XXMX250SA E-Scythe": DI(1793, 1798, 11, 35, 11, 35),
"SSM-XXMX260SA E-Scythe": DI(1794, 1799, 12, 36, 12, 36),
"SSM-XRX320SA F-Rifle": DI(1850, 1855, 3, 27, 3, 27),
"SSM-XRX330SA F-Rifle": DI(1851, 1856, 4, 28, 4, 28),
"SSM-XRX340SA F-Rifle": DI(1852, 1857, 5, 29, 5, 29),
"SSM-XRX350SA F-Rifle": DI(1853, 1858, 6, 30, 6, 30),
"SSM-XRX360SA F-Rifle": DI(1854, 1859, 7, 31, 7, 31),
"SSM-XXRX320SA F-Rifle": DI(1850, 1855, 8, 32, 8, 32),
"SSM-XXRX330SA F-Rifle": DI(1851, 1856, 9, 33, 9, 33),
"SSM-XXRX340SA F-Rifle": DI(1852, 1857, 10, 34, 10, 34),
"SSM-XXRX350SA F-Rifle": DI(1853, 1858, 11, 35, 11, 35),
"SSM-XXRX360SA F-Rifle": DI(1854, 1859, 12, 36, 12, 36),
"SSM-XRX320SA F2-Rifle": DI(1840, 1845, 3, 27, 3, 27),
"SSM-XRX330SA F2-Rifle": DI(1841, 1846, 4, 28, 4, 28),
"SSM-XRX340SA F2-Rifle": DI(1842, 1847, 5, 29, 5, 29),
"SSM-XRX350SA F2-Rifle": DI(1843, 1848, 6, 30, 6, 30),
"SSM-XRX360SA F2-Rifle": DI(1844, 1849, 7, 31, 7, 31),
"SSM-XXRX320SA F2-Rifle": DI(1840, 1845, 8, 32, 8, 32),
"SSM-XXRX330SA F2-Rifle": DI(1841, 1846, 9, 33, 9, 33),
"SSM-XXRX340SA F2-Rifle": DI(1842, 1847, 10, 34, 10, 34),
"SSM-XXRX350SA F2-Rifle": DI(1843, 1848, 11, 35, 11, 35),
"SSM-XXRX360SA F2-Rifle": DI(1844, 1849, 12, 36, 12, 36),
"SSM-XRX420SA B-Gatling": DI(1860, 1865, 3, 27, 3, 27),
"SSM-XRX430SA B-Gatling": DI(1861, 1866, 4, 28, 4, 28),
"SSM-XRX440SA B-Gatling": DI(1862, 1867, 5, 29, 5, 29),
"SSM-XRX450SA B-Gatling": DI(1863, 1868, 6, 30, 6, 30),
"SSM-XRX460SA B-Gatling": DI(1864, 1869, 7, 31, 7, 31),
"SSM-XXRX420SA B-Gatling": DI(1860, 1865, 8, 32, 8, 32),
"SSM-XXRX430SA B-Gatling": DI(1861, 1866, 9, 33, 9, 33),
"SSM-XXRX440SA B-Gatling": DI(1862, 1867, 10, 34, 10, 34),
"SSM-XXRX450SA B-Gatling": DI(1863, 1868, 11, 35, 11, 35),
"SSM-XXRX460SA B-Gatling": DI(1864, 1869, 12, 36, 12, 36),
"SSM-XRX430SA B2-Gatling": DI(1871, 1876, 4, 28, 4, 28),
"SSM-XRX440SA B2-Gatling": DI(1872, 1877, 5, 29, 5, 29),
"SSM-XRX450SA B2-Gatling": DI(1873, 1878, 6, 30, 6, 30),
"SSM-XRX460SA B2-Gatling": DI(1874, 1879, 7, 31, 7, 31),
"SSM-XXRX430SA B2-Gatling": DI(1871, 1876, 9, 33, 9, 33),
"SSM-XXRX440SA B2-Gatling": DI(1872, 1877, 10, 34, 10, 34),
"SSM-XXRX450SA B2-Gatling": DI(1873, 1878, 11, 35, 11, 35),
"SSM-XXRX460SA B2-Gatling": DI(1874, 1879, 12, 36, 12, 36),
"SSM-XRX520SA M-XSniper": DI(1880, 1885, 3, 27, 3, 27),
"SSM-XRX530SA M-XSniper": DI(1881, 1886, 4, 28, 4, 28),
"SSM-XRX540SA M-XSniper": DI(1882, 1887, 5, 29, 5, 29),
"SSM-XRX550SA M-XSniper": DI(1883, 1888, 6, 30, 6, 30),
"SSM-XRX560SA M-XSniper": DI(1884, 1889, 7, 31, 7, 31),
"SSM-XXRX520SA M-XXSniper": DI(1880, 1885, 8, 32, 8, 32),
"SSM-XXRX530SA M-XXSniper": DI(1881, 1886, 9, 33, 9, 33),
"SSM-XXRX540SA M-XXSniper": DI(1882, 1887, 10, 34, 10, 34),
"SSM-XXRX550SA M-XXSniper": DI(1883, 1888, 11, 35, 11, 35),
"SSM-XXRX560SA M-XXSniper": DI(1884, 1889, 12, 36, 12, 36),
"SSM-XR120GG M-Missile": DI(1910, 1915, 3, 27, 3, 27),
"SSM-XR130GG M-Missile": DI(1911, 1916, 4, 28, 4, 28),
"SSM-XR140GG M-Missile": DI(1912, 1917, 5, 29, 5, 29),
"SSM-XR150GG M-Missile": DI(1913, 1918, 6, 30, 6, 30),
"SSM-XR160GG M-Missile": DI(1914, 1919, 7, 31, 7, 31),
"SSM-XXR120GG M-Missile": DI(1910, 1915, 8, 32, 8, 32),
"SSM-XXR130GG M-Missile": DI(1911, 1916, 9, 33, 9, 33),
"SSM-XXR140GG M-Missile": DI(1912, 1917, 10, 34, 10, 34),
"SSM-XXR150GG M-Missile": DI(1913, 1918, 11, 35, 11, 35),
"SSM-XXR160GG M-Missile": DI(1914, 1919, 12, 36, 12, 36),
"SSM-XR220GG Voltstorm": DI(1940, 1945, 3, 27, 3, 27),
"SSM-XR230GG Voltstorm": DI(1941, 1946, 4, 28, 4, 28),
"SSM-XR240GG Voltstorm": DI(1942, 1947, 5, 29, 5, 29),
"SSM-XR250GG Voltstorm": DI(1943, 1948, 6, 30, 6, 30),
"SSM-XR260GG Voltstorm": DI(1944, 1949, 7, 31, 7, 31),
"SSM-XXR220GG Voltstorm": DI(1940, 1945, 8, 32, 8, 32),
"SSM-XXR230GG Voltstorm": DI(1941, 1946, 9, 33, 9, 33),
"SSM-XXR240GG Voltstorm": DI(1942, 1947, 10, 34, 10, 34),
"SSM-XXR250GG Voltstorm": DI(1943, 1948, 11, 35, 11, 35),
"SSM-XXR260GG Voltstorm": DI(1944, 1949, 12, 36, 12, 36),
"SSM-XR320GG SHD-Gravity": DI(1990, 1995, 3, 27, 3, 27),
"SSM-XR330GG SHD-Gravity": DI(1991, 1996, 4, 28, 4, 28),
"SSM-XR340GG SHD-Gravity": DI(1992, 1997, 5, 29, 5, 29),
"SSM-XR350GG SHD-Gravity": DI(1993, 1998, 6, 30, 6, 30),
"SSM-XR360GG SHD-Gravity": DI(1994, 1999, 7, 31, 7, 31),
"SSM-XXR320GG SHD-Gravity": DI(1990, 1995, 8, 32, 8, 32),
"SSM-XXR330GG SHD-Gravity": DI(1991, 1996, 9, 33, 9, 33),
"SSM-XXR340GG SHD-Gravity": DI(1992, 1997, 10, 34, 10, 34),
"SSM-XXR350GG SHD-Gravity": DI(1993, 1998, 11, 35, 11, 35),
"SSM-XXR360GG SHD-Gravity": DI(1994, 1999, 12, 36, 12, 36),
"SSM-XR420GG Antipulser": DI(2010, 2015, 3, 27, 3, 27),
"SSM-XR430GG Antipulser": DI(2011, 2016, 4, 28, 4, 28),
"SSM-XR440GG Antipulser": DI(2012, 2017, 5, 29, 5, 29),
"SSM-XR450GG Antipulser": DI(2013, 2018, 6, 30, 6, 30),
"SSM-XR460GG Antipulser": DI(2014, 2019, 7, 31, 7, 31),
"SSM-XXR420GG Antipulser": DI(2010, 2015, 8, 32, 8, 32),
"SSM-XXR430GG Antipulser": DI(2011, 2016, 9, 33, 9, 33),
"SSM-XXR440GG Antipulser": DI(2012, 2017, 10, 34, 10, 34),
"SSM-XXR450GG Antipulser": DI(2013, 2018, 11, 35, 11, 35),
"SSM-XXR460GG Antipulser": DI(2014, 2019, 12, 36, 12, 36),
"SSM-XR421GG Antipulser": DI(2020, 2025, 3, 27, 3, 27),
"SSM-XR431GG Antipulser": DI(2021, 2026, 4, 28, 4, 28),
"SSM-XR441GG Antipulser": DI(2022, 2027, 5, 29, 5, 29),
"SSM-XR451GG Antipulser": DI(2023, 2028, 6, 30, 6, 30),
"SSM-XR461GG Antipulser": DI(2024, 2029, 7, 31, 7, 31),
"SSM-XXR421GG Antipulser": DI(2020, 2025, 8, 32, 8, 32),
"SSM-XXR431GG Antipulser": DI(2021, 2026, 9, 33, 9, 33),
"SSM-XXR441GG Antipulser": DI(2022, 2027, 10, 34, 10, 34),
"SSM-XXR451GG Antipulser": DI(2023, 2028, 11, 35, 11, 35),
"SSM-XXR461GG Antipulser": DI(2024, 2029, 12, 36, 12, 36),
"SSM-XR530GG Drone": DI(2031, 2036, 4, 28, 4, 28),
"SSM-XR540GG Drone": DI(2032, 2037, 5, 29, 5, 29),
"SSM-XR550GG Drone": DI(2033, 2038, 6, 30, 6, 30),
"SSM-XR560GG Drone": DI(2034, 2039, 7, 31, 7, 31),
"SSM-XXR530GG Drone": DI(2031, 2036, 9, 33, 9, 33),
"SSM-XXR540GG Drone": DI(2032, 2037, 10, 34, 10, 34),
"SSM-XXR550GG Drone": DI(2033, 2038, 11, 35, 11, 35),
"SSM-XXR560GG Drone": DI(2034, 2039, 12, 36, 12, 36),
"SSM-XR130ME M-Missile": DI(1901, 1906, 4, 28, 4, 28),
"SSM-XR140ME M-Missile": DI(1902, 1907, 5, 29, 5, 29),
"SSM-XR150ME M-Missile": DI(1903, 1908, 6, 30, 6, 30),
"SSM-XR160ME M-Missile": DI(1904, 1909, 7, 31, 7, 31),
"SSM-XXR130ME M-Missile": DI(1901, 1906, 9, 33, 9, 33),
"SSM-XXR140ME M-Missile": DI(1902, 1907, 10, 34, 10, 34),
"SSM-XXR150ME M-Missile": DI(1903, 1908, 11, 35, 11, 35),
"SSM-XXR160ME M-Missile": DI(1904, 1909, 12, 36, 12, 36),
"SSM-XR220ME Widebeam": DI(1950, 1955, 3, 27, 3, 27),
"SSM-XR230ME Widebeam": DI(1951, 1956, 4, 28, 4, 28),
"SSM-XR240ME Widebeam": DI(1952, 1957, 5, 29, 5, 29),
"SSM-XR250ME Widebeam": DI(1953, 1958, 6, 30, 6, 30),
"SSM-XR260ME Widebeam": DI(1954, 1959, 7, 31, 7, 31),
"SSM-XXR220ME Widebeam": DI(1950, 1955, 8, 32, 8, 32),
"SSM-XXR230ME Widebeam": DI(1951, 1956, 9, 33, 9, 33),
"SSM-XXR240ME Widebeam": DI(1952, 1957, 10, 34, 10, 34),
"SSM-XXR250ME Widebeam": DI(1953, 1958, 11, 35, 11, 35),
"SSM-XXR260ME Widebeam": DI(1954, 1959, 12, 36, 12, 36),
"SSM-XR320ME SHD-Missile": DI(1980, 1985, 3, 27, 3, 27),
"SSM-XR330ME SHD-Missile": DI(1981, 1986, 4, 28, 4, 28),
"SSM-XR340ME SHD-Missile": DI(1982, 1987, 5, 29, 5, 29),
"SSM-XR350ME SHD-Missile": DI(1983, 1988, 6, 30, 6, 30),
"SSM-XR360ME SHD-Missile": DI(1984, 1989, 7, 31, 7, 31),
"SSM-XXR320ME SHD-Missile": DI(1980, 1985, 8, 32, 8, 32),
"SSM-XXR330ME SHD-Missile": DI(1981, 1986, 9, 33, 9, 33),
"SSM-XXR340ME SHD-Missile": DI(1982, 1987, 10, 34, 10, 34),
"SSM-XXR350ME SHD-Missile": DI(1983, 1988, 11, 35, 11, 35),
"SSM-XXR360ME SHD-Missile": DI(1984, 1989, 12, 36, 12, 36),
"SSM-XM120ME Heathorn": DI(2000, 2005, 3, 27, 3, 27),
"SSM-XM130ME Heathorn": DI(2001, 2006, 4, 28, 4, 28),
"SSM-XM140ME Heathorn": DI(2002, 2007, 5, 29, 5, 29),
"SSM-XM150ME Heathorn": DI(2003, 2008, 6, 30, 6, 30),
"SSM-XM160ME Heathorn": DI(2004, 2009, 7, 31, 7, 31),
"SSM-XXM120ME Heathorn": DI(2000, 2005, 8, 32, 8, 32),
"SSM-XXM130ME Heathorn": DI(2001, 2006, 9, 33, 9, 33),
"SSM-XXM140ME Heathorn": DI(2002, 2007, 10, 34, 10, 34),
"SSM-XXM150ME Heathorn": DI(2003, 2008, 11, 35, 11, 35),
"SSM-XXM160ME Heathorn": DI(2004, 2009, 12, 36, 12, 36),
"SRM-XR120SA Railgun": DI(2060, 2065, 3, 27, 3, 27),
"SRM-XR130SA Railgun": DI(2061, 2066, 4, 28, 4, 28),
"SRM-XR140SA Railgun": DI(2062, 2067, 5, 29, 5, 29),
"SRM-XR150SA Railgun": DI(2063, 2068, 6, 30, 6, 30),
"SRM-XR160SA Railgun": DI(2064, 2069, 7, 31, 7, 31),
"SRM-XXR120SA Railgun": DI(2060, 2065, 8, 32, 8, 32),
"SRM-XXR130SA Railgun": DI(2061, 2066, 9, 33, 9, 33),
"SRM-XXR140SA Railgun": DI(2062, 2067, 10, 34, 10, 34),
"SRM-XXR150SA Railgun": DI(2063, 2068, 11, 35, 11, 35),
"SRM-XXR160SA Railgun": DI(2064, 2069, 12, 36, 12, 36),
"SRM-XR220SA S-Missile": DI(2110, 2115, 3, 27, 3, 27),
"SRM-XR230SA S-Missile": DI(2111, 2116, 4, 28, 4, 28),
"SRM-XR240SA S-Missile": DI(2112, 2117, 5, 29, 5, 29),
"SRM-XR250SA S-Missile": DI(2113, 2118, 6, 30, 6, 30),
"SRM-XR260SA S-Missile": DI(2114, 2119, 7, 31, 7, 31),
"SRM-XXR220SA S-Missile": DI(2110, 2115, 8, 32, 8, 32),
"SRM-XXR230SA S-Missile": DI(2111, 2116, 9, 33, 9, 33),
"SRM-XXR240SA S-Missile": DI(2112, 2117, 10, 34, 10, 34),
"SRM-XXR250SA S-Missile": DI(2113, 2118, 11, 35, 11, 35),
"SRM-XXR260SA S-Missile": DI(2114, 2119, 12, 36, 12, 36),
"SRM-XR320SA Voltnet": DI(2150, 2155, 3, 27, 3, 27),
"SRM-XR330SA Voltnet": DI(2151, 2156, 4, 28, 4, 28),
"SRM-XR340SA Voltnet": DI(2152, 2157, 5, 29, 5, 29),
"SRM-XR350SA Voltnet": DI(2153, 2158, 6, 30, 6, 30),
"SRM-XR360SA Voltnet": DI(2154, 2159, 7, 31, 7, 31),
"SRM-XXR320SA Voltnet": DI(2150, 2155, 8, 32, 8, 32),
"SRM-XXR330SA Voltnet": DI(2151, 2156, 9, 33, 9, 33),
"SRM-XXR340SA Voltnet": DI(2152, 2157, 10, 34, 10, 34),
"SRM-XXR350SA Voltnet": DI(2153, 2158, 11, 35, 11, 35),
"SRM-XXR360SA Voltnet": DI(2154, 2159, 12, 36, 12, 36),
"SRM-XR420SA Grenade": DI(2160, 2165, 3, 27, 3, 27),
"SRM-XR430SA Grenade": DI(2161, 2166, 4, 28, 4, 28),
"SRM-XR440SA Grenade": DI(2162, 2167, 5, 29, 5, 29),
"SRM-XR450SA Grenade": DI(2163, 2168, 6, 30, 6, 30),
"SRM-XR460SA Grenade": DI(2164, 2169, 7, 31, 7, 31),
"SRM-XXR420SA Grenade": DI(2160, 2165, 8, 32, 8, 32),
"SRM-XXR430SA Grenade": DI(2161, 2166, 9, 33, 9, 33),
"SRM-XXR440SA Grenade": DI(2162, 2167, 10, 34, 10, 34),
"SRM-XXR450SA Grenade": DI(2163, 2168, 11, 35, 11, 35),
"SRM-XXR460SA Grenade": DI(2164, 2169, 12, 36, 12, 36),
"SRM-XM120SA Buster": DI(1730, 1735, 3, 27, 3, 27),
"SRM-XM130SA Buster": DI(1731, 1736, 4, 28, 4, 28),
"SRM-XM140SA Buster": DI(1732, 1737, 5, 29, 5, 29),
"SRM-XM150SA Buster": DI(1733, 1738, 6, 30, 6, 30),
"SRM-XM160SA Buster": DI(1734, 1739, 7, 31, 7, 31),
"SRM-XXM120SA Buster": DI(1730, 1735, 8, 32, 8, 32),
"SRM-XXM130SA Buster": DI(1731, 1736, 9, 33, 9, 33),
"SRM-XXM140SA Buster": DI(1732, 1737, 10, 34, 10, 34),
"SRM-XXM150SA Buster": DI(1733, 1738, 11, 35, 11, 35),
"SRM-XXM160SA Buster": DI(1734, 1739, 12, 36, 12, 36),
"SRM-XR520SA Hyper-Rail": DI(1810, 1815, 3, 27, 3, 27),
"SRM-XR530SA Hyper-Rail": DI(1811, 1816, 4, 28, 4, 28),
"SRM-XR540SA Hyper-Rail": DI(1812, 1817, 5, 29, 5, 29),
"SRM-XR550SA Hyper-Rail": DI(1813, 1818, 6, 30, 6, 30),
"SRM-XR560SA Hyper-Rail": DI(1814, 1819, 7, 31, 7, 31),
"SRM-XXR520SA Hyper-Rail": DI(1810, 1815, 8, 32, 8, 32),
"SRM-XXR530SA Hyper-Rail": DI(1811, 1816, 9, 33, 9, 33),
"SRM-XXR540SA Hyper-Rail": DI(1812, 1817, 10, 34, 10, 34),
"SRM-XXR550SA Hyper-Rail": DI(1813, 1818, 11, 35, 11, 35),
"SRM-XXR560SA Hyper-Rail": DI(1814, 1819, 12, 36, 12, 36),
"SRM-XR620SA Buster-Launcher": DI(1800, 1805, 3, 27, 3, 27),
"SRM-XR630SA Buster-Launcher": DI(1801, 1806, 4, 28, 4, 28),
"SRM-XR640SA Buster-Launcher": DI(1802, 1807, 5, 29, 5, 29),
"SRM-XR650SA Buster-Launcher": DI(1803, 1808, 6, 30, 6, 30),
"SRM-XR660SA Buster-Launcher": DI(1804, 1809, 7, 31, 7, 31),
"SRM-XXR620SA Buster-Launcher": DI(1800, 1805, 8, 32, 8, 32),
"SRM-XXR630SA Buster-Launcher": DI(1801, 1806, 9, 33, 9, 33),
"SRM-XXR640SA Buster-Launcher": DI(1802, 1807, 10, 34, 10, 34),
"SRM-XXR650SA Buster-Launcher": DI(1803, 1808, 11, 35, 11, 35),
"SRM-XXR660SA Buster-Launcher": DI(1804, 1809, 12, 36, 12, 36),
"SRM-XR720SA L-Missile": DI(2170, 2175, 3, 27, 3, 27),
"SRM-XR730SA L-Missile": DI(2171, 2176, 4, 28, 4, 28),
"SRM-XR740SA L-Missile": DI(2172, 2177, 5, 29, 5, 29),
"SRM-XR750SA L-Missile": DI(2173, 2178, 6, 30, 6, 30),
"SRM-XR760SA L-Missile": DI(2174, 2179, 7, 31, 7, 31),
"SRM-XXR720SA L-Missile": DI(2170, 2175, 8, 32, 8, 32),
"SRM-XXR730SA L-Missile": DI(2171, 2176, 9, 33, 9, 33),
"SRM-XXR740SA L-Missile": DI(2172, 2177, 10, 34, 10, 34),
"SRM-XXR750SA L-Missile": DI(2173, 2178, 11, 35, 11, 35),
"SRM-XXR760SA L-Missile": DI(2174, 2179, 12, 36, 12, 36),
"SRM-XR720SA F-Wave": DI(2200, 2205, 3, 27, 3, 27),
"SRM-XR730SA F-Wave": DI(2201, 2206, 4, 28, 4, 28),
"SRM-XR740SA F-Wave": DI(2202, 2207, 5, 29, 5, 29),
"SRM-XR750SA F-Wave": DI(2203, 2208, 6, 30, 6, 30),
"SRM-XR760SA F-Wave": DI(2204, 2209, 7, 31, 7, 31),
"SRM-XXR720SA F-Wave": DI(2200, 2205, 8, 32, 8, 32),
"SRM-XXR730SA F-Wave": DI(2201, 2206, 9, 33, 9, 33),
"SRM-XXR740SA F-Wave": DI(2202, 2207, 10, 34, 10, 34),
"SRM-XXR750SA F-Wave": DI(2203, 2208, 11, 35, 11, 35),
"SRM-XXR760SA F-Wave": DI(2204, 2209, 12, 36, 12, 36),
"SRM-XR120GG P-Cannon": DI(2070, 2075, 3, 27, 3, 27),
"SRM-XR130GG P-Cannon": DI(2071, 2076, 4, 28, 4, 28),
"SRM-XR140GG P-Cannon": DI(2072, 2077, 5, 29, 5, 29),
"SRM-XR150GG P-Cannon": DI(2073, 2078, 6, 30, 6, 30),
"SRM-XR160GG P-Cannon": DI(2074, 2079, 7, 31, 7, 31),
"SRM-XXR120GG P-Cannon": DI(2070, 2075, 8, 32, 8, 32),
"SRM-XXR130GG P-Cannon": DI(2071, 2076, 9, 33, 9, 33),
"SRM-XXR140GG P-Cannon": DI(2072, 2077, 10, 34, 10, 34),
"SRM-XXR150GG P-Cannon": DI(2073, 2078, 11, 35, 11, 35),
"SRM-XXR160GG P-Cannon": DI(2074, 2079, 12, 36, 12, 36),
"SRM-XR220GG Lasergun": DI(2080, 2085, 3, 27, 3, 27),
"SRM-XR230GG Lasergun": DI(2081, 2086, 4, 28, 4, 28),
"SRM-XR240GG Lasergun": DI(2082, 2087, 5, 29, 5, 29),
"SRM-XR250GG Lasergun": DI(2083, 2088, 6, 30, 6, 30),
"SRM-XR260GG Lasergun": DI(2084, 2089, 7, 31, 7, 31),
"SRM-XXR220GG Lasergun": DI(2080, 2085, 8, 32, 8, 32),
"SRM-XXR230GG Lasergun": DI(2081, 2086, 9, 33, 9, 33),
"SRM-XXR240GG Lasergun": DI(2082, 2087, 10, 34, 10, 34),
"SRM-XXR250GG Lasergun": DI(2083, 2088, 11, 35, 11, 35),
"SRM-XXR260GG Lasergun": DI(2084, 2089, 12, 36, 12, 36),
"SRM-XR320GG H-Arrow": DI(2130, 2135, 3, 27, 3, 27),
"SRM-XR330GG H-Arrow": DI(2131, 2136, 4, 28, 4, 28),
"SRM-XR340GG H-Arrow": DI(2132, 2137, 5, 29, 5, 29),
"SRM-XR350GG H-Arrow": DI(2133, 2138, 6, 30, 6, 30),
"SRM-XR360GG H-Arrow": DI(2134, 2139, 7, 31, 7, 31),
"SRM-XXR320GG H-Arrow": DI(2130, 2135, 8, 32, 8, 32),
"SRM-XXR330GG H-Arrow": DI(2131, 2136, 9, 33, 9, 33),
"SRM-XXR340GG H-Arrow": DI(2132, 2137, 10, 34, 10, 34),
"SRM-XXR350GG H-Arrow": DI(2133, 2138, 11, 35, 11, 35),
"SRM-XXR360GG H-Arrow": DI(2134, 2139, 12, 36, 12, 36),
"SRM-XM120GG Javelin": DI(1740, 1745, 3, 27, 3, 27),
"SRM-XM130GG Javelin": DI(1741, 1746, 4, 28, 4, 28),
"SRM-XM140GG Javelin": DI(1742, 1747, 5, 29, 5, 29),
"SRM-XM150GG Javelin": DI(1743, 1748, 6, 30, 6, 30),
"SRM-XM160GG Javelin": DI(1744, 1749, 7, 31, 7, 31),
"SRM-XXM120GG Javelin": DI(1740, 1745, 8, 32, 8, 32),
"SRM-XXM130GG Javelin": DI(1741, 1746, 9, 33, 9, 33),
"SRM-XXM140GG Javelin": DI(1742, 1747, 10, 34, 10, 34),
"SRM-XXM150GG Javelin": DI(1743, 1748, 11, 35, 11, 35),
"SRM-XXM160GG Javelin": DI(1744, 1749, 12, 36, 12, 36),
"SRM-XR420GG Phoenix": DI(2190, 2195, 3, 27, 3, 27),
"SRM-XR430GG Phoenix": DI(2191, 2196, 4, 28, 4, 28),
"SRM-XR440GG Phoenix": DI(2192, 2197, 5, 29, 5, 29),
"SRM-XR450GG Phoenix": DI(2193, 2198, 6, 30, 6, 30),
"SRM-XR460GG Phoenix": DI(2194, 2199, 7, 31, 7, 31),
"SRM-XXR420GG Phoenix": DI(2190, 2195, 8, 32, 8, 32),
"SRM-XXR430GG Phoenix": DI(2191, 2196, 9, 33, 9, 33),
"SRM-XXR440GG Phoenix": DI(2192, 2197, 10, 34, 10, 34),
"SRM-XXR450GG Phoenix": DI(2193, 2198, 11, 35, 11, 35),
"SRM-XXR460GG Phoenix": DI(2194, 2199, 12, 36, 12, 36),
"SRM-XR530GG F-Wave": DI(2211, 2216, 4, 28, 4, 28),
"SRM-XR540GG F-Wave": DI(2212, 2217, 5, 29, 5, 29),
"SRM-XR550GG F-Wave": DI(2213, 2218, 6, 30, 6, 30),
"SRM-XR560GG F-Wave": DI(2214, 2219, 7, 31, 7, 31),
"SRM-XXR530GG F-Wave": DI(2211, 2216, 9, 33, 9, 33),
"SRM-XXR540GG F-Wave": DI(2212, 2217, 10, 34, 10, 34),
"SRM-XXR550GG F-Wave": DI(2213, 2218, 11, 35, 11, 35),
"SRM-XXR560GG F-Wave": DI(2214, 2219, 12, 36, 12, 36),
"SRM-XR531GG F-Wave": DI(2221, 2226, 4, 28, 4, 28),
"SRM-XR541GG F-Wave": DI(2222, 2227, 5, 29, 5, 29),
"SRM-XR551GG F-Wave": DI(2223, 2228, 6, 30, 6, 30),
"SRM-XR561GG F-Wave": DI(2224, 2229, 7, 31, 7, 31),
"SRM-XXR531GG F-Wave": DI(2221, 2226, 9, 33, 9, 33),
"SRM-XXR541GG F-Wave": DI(2222, 2227, 10, 34, 10, 34),
"SRM-XXR551GG F-Wave": DI(2223, 2228, 11, 35, 11, 35),
"SRM-XXR561GG F-Wave": DI(2224, 2229, 12, 36, 12, 36),
"SRM-XR120ME B-Gatling": DI(2050, 2055, 3, 27, 3, 27),
"SRM-XR130ME B-Gatling": DI(2051, 2056, 4, 28, 4, 28),
"SRM-XR140ME B-Gatling": DI(2052, 2057, 5, 29, 5, 29),
"SRM-XR150ME B-Gatling": DI(2053, 2058, 6, 30, 6, 30),
"SRM-XR160ME B-Gatling": DI(2054, 2059, 7, 31, 7, 31),
"SRM-XXR120ME B-Gatling": DI(2050, 2055, 8, 32, 8, 32),
"SRM-XXR130ME B-Gatling": DI(2051, 2056, 9, 33, 9, 33),
"SRM-XXR140ME B-Gatling": DI(2052, 2057, 10, 34, 10, 34),
"SRM-XXR150ME B-Gatling": DI(2053, 2058, 11, 35, 11, 35),
"SRM-XXR160ME B-Gatling": DI(2054, 2059, 12, 36, 12, 36),
"SSM-XR120ME N-Cannon": DI(2090, 2095, 3, 27, 3, 27),
"SSM-XR130ME N-Cannon": DI(2091, 2096, 4, 28, 4, 28),
"SSM-XR140ME N-Cannon": DI(2092, 2097, 5, 29, 5, 29),
"SSM-XR150ME N-Cannon": DI(2093, 2098, 6, 30, 6, 30),
"SSM-XR160ME N-Cannon": DI(2094, 2099, 7, 31, 7, 31),
"SSM-XXR120ME N-Cannon": DI(2090, 2095, 8, 32, 8, 32),
"SSM-XXR130ME N-Cannon": DI(2091, 2096, 9, 33, 9, 33),
"SSM-XXR140ME N-Cannon": DI(2092, 2097, 10, 34, 10, 34),
"SSM-XXR150ME N-Cannon": DI(2093, 2098, 11, 35, 11, 35),
"SSM-XXR160ME N-Cannon": DI(2094, 2099, 12, 36, 12, 36),
"SRM-XR220ME S-Missile": DI(2120, 2125, 3, 27, 3, 27),
"SRM-XR230ME S-Missile": DI(2121, 2126, 4, 28, 4, 28),
"SRM-XR240ME S-Missile": DI(2122, 2127, 5, 29, 5, 29),
"SRM-XR250ME S-Missile": DI(2123, 2128, 6, 30, 6, 30),
"SRM-XR260ME S-Missile": DI(2124, 2129, 7, 31, 7, 31),
"SRM-XXR220ME S-Missile": DI(2120, 2125, 8, 32, 8, 32),
"SRM-XXR230ME S-Missile": DI(2121, 2126, 9, 33, 9, 33),
"SRM-XXR240ME S-Missile": DI(2122, 2127, 10, 34, 10, 34),
"SRM-XXR250ME S-Missile": DI(2123, 2128, 11, 35, 11, 35),
"SRM-XXR260ME S-Missile": DI(2124, 2129, 12, 36, 12, 36),
"SRM-XR420ME Backbomb": DI(2140, 2145, 3, 27, 3, 27),
"SRM-XR430ME Backbomb": DI(2141, 2146, 4, 28, 4, 28),
"SRM-XR440ME Backbomb": DI(2142, 2147, 5, 29, 5, 29),
"SRM-XR450ME Backbomb": DI(2143, 2148, 6, 30, 6, 30),
"SRM-XR460ME Backbomb": DI(2144, 2149, 7, 31, 7, 31),
"SRM-XXR420ME Backbomb": DI(2140, 2145, 8, 32, 8, 32),
"SRM-XXR430ME Backbomb": DI(2141, 2146, 9, 33, 9, 33),
"SRM-XXR440ME Backbomb": DI(2142, 2147, 10, 34, 10, 34),
"SRM-XXR450ME Backbomb": DI(2143, 2148, 11, 35, 11, 35),
"SRM-XXR460ME Backbomb": DI(2144, 2149, 12, 36, 12, 36),
"SRM-XM120ME Dragon": DI(1820, 1825, 3, 27, 3, 27),
"SRM-XM130ME Dragon": DI(1821, 1826, 4, 28, 4, 28),
"SRM-XM140ME Dragon": DI(1822, 1827, 5, 29, 5, 29),
"SRM-XM150ME Dragon": DI(1823, 1828, 6, 30, 6, 30),
"SRM-XM160ME Dragon": DI(1824, 1829, 7, 31, 7, 31),
"SRM-XXM120ME Dragon": DI(1820, 1825, 8, 32, 8, 32),
"SRM-XXM130ME Dragon": DI(1821, 1826, 9, 33, 9, 33),
"SRM-XXM140ME Dragon": DI(1822, 1827, 10, 34, 10, 34),
"SRM-XXM150ME Dragon": DI(1823, 1828, 11, 35, 11, 35),
"SRM-XXM160ME Dragon": DI(1824, 1829, 12, 36, 12, 36),
"SRM-XM220ME W-Crusher": DI(1750, 1755, 3, 27, 3, 27),
"SRM-XM230ME W-Crusher": DI(1751, 1756, 4, 28, 4, 28),
"SRM-XM240ME W-Crusher": DI(1752, 1757, 5, 29, 5, 29),
"SRM-XM250ME W-Crusher": DI(1753, 1758, 6, 30, 6, 30),
"SRM-XM260ME W-Crusher": DI(1754, 1759, 7, 31, 7, 31),
"SRM-XXM220ME W-Crusher": DI(1750, 1755, 8, 32, 8, 32),
"SRM-XXM230ME W-Crusher": DI(1751, 1756, 9, 33, 9, 33),
"SRM-XXM240ME W-Crusher": DI(1752, 1757, 10, 34, 10, 34),
"SRM-XXM250ME W-Crusher": DI(1753, 1758, 11, 35, 11, 35),
"SRM-XXM260ME W-Crusher": DI(1754, 1759, 12, 36, 12, 36),
"SRM-XM320ME BB-Sword": DI(1760, 1765, 3, 27, 3, 27),
"SRM-XM330ME BB-Sword": DI(1761, 1766, 4, 28, 4, 28),
"SRM-XM340ME BB-Sword": DI(1762, 1767, 5, 29, 5, 29),
"SRM-XM350ME BB-Sword": DI(1763, 1768, 6, 30, 6, 30),
"SRM-XM360ME BB-Sword": DI(1764, 1769, 7, 31, 7, 31),
"SRM-XXM320ME BB-Sword": DI(1760, 1765, 8, 32, 8, 32),
"SRM-XXM330ME BB-Sword": DI(1761, 1766, 9, 33, 9, 33),
"SRM-XXM340ME BB-Sword": DI(1762, 1767, 10, 34, 10, 34),
"SRM-XXM350ME BB-Sword": DI(1763, 1768, 11, 35, 11, 35),
"SRM-XXM360ME BB-Sword": DI(1764, 1769, 12, 36, 12, 36),
"SRM-XR520ME Meteor": DI(1830, 1835, 3, 27, 3, 27),
"SRM-XR530ME Meteor": DI(1831, 1836, 4, 28, 4, 28),
"SRM-XR540ME Meteor": DI(1832, 1837, 5, 29, 5, 29),
"SRM-XR550ME Meteor": DI(1833, 1838, 6, 30, 6, 30),
"SRM-XR560ME Meteor": DI(1834, 1839, 7, 31, 7, 31),
"SRM-XXR520ME Meteor": DI(1830, 1835, 8, 32, 8, 32),
"SRM-XXR530ME Meteor": DI(1831, 1836, 9, 33, 9, 33),
"SRM-XXR540ME Meteor": DI(1832, 1837, 10, 34, 10, 34),
"SRM-XXR550ME Meteor": DI(1833, 1838, 11, 35, 11, 35),
"SRM-XXR560ME Meteor": DI(1834, 1839, 12, 36, 12, 36),
"SRM-XR620ME L-Missile": DI(2180, 2185, 3, 27, 3, 27),
"SRM-XR630ME L-Missile": DI(2181, 2186, 4, 28, 4, 28),
"SRM-XR640ME L-Missile": DI(2182, 2187, 5, 29, 5, 29),
"SRM-XR650ME L-Missile": DI(2183, 2188, 6, 30, 6, 30),
"SRM-XR660ME L-Missile": DI(2184, 2189, 7, 31, 7, 31),
"SRM-XXR620ME L-Missile": DI(2180, 2185, 8, 32, 8, 32),
"SRM-XXR630ME L-Missile": DI(2181, 2186, 9, 33, 9, 33),
"SRM-XXR640ME L-Missile": DI(2182, 2187, 10, 34, 10, 34),
"SRM-XXR650ME L-Missile": DI(2183, 2188, 11, 35, 11, 35),
"SRM-XXR660ME L-Missile": DI(2184, 2189, 12, 36, 12, 36),
"SRM-XR720ME F-Wave": DI(2230, 2235, 3, 27, 3, 27),
"SRM-XR730ME F-Wave": DI(2231, 2236, 4, 28, 4, 28),
"SRM-XR740ME F-Wave": DI(2232, 2237, 5, 29, 5, 29),
"SRM-XR750ME F-Wave": DI(2233, 2238, 6, 30, 6, 30),
"SRM-XR760ME F-Wave": DI(2234, 2239, 7, 31, 7, 31),
"SRM-XXR720ME F-Wave": DI(2230, 2235, 8, 32, 8, 32),
"SRM-XXR730ME F-Wave": DI(2231, 2236, 9, 33, 9, 33),
"SRM-XXR740ME F-Wave": DI(2232, 2237, 10, 34, 10, 34),
"SRM-XXR750ME F-Wave": DI(2233, 2238, 11, 35, 11, 35),
"SRM-XXR760ME F-Wave": DI(2234, 2239, 12, 36, 12, 36),
"SRM-XR721ME F-Wave": DI(2240, 2245, 3, 27, 3, 27),
"SRM-XR731ME F-Wave": DI(2241, 2246, 4, 28, 4, 28),
"SRM-XR741ME F-Wave": DI(2242, 2247, 5, 29, 5, 29),
"SRM-XR751ME F-Wave": DI(2243, 2248, 6, 30, 6, 30),
"SRM-XR761ME F-Wave": DI(2244, 2249, 7, 31, 7, 31),
"SRM-XXR721ME F-Wave": DI(2240, 2245, 8, 32, 8, 32),
"SRM-XXR731ME F-Wave": DI(2241, 2246, 9, 33, 9, 33),
"SRM-XXR741ME F-Wave": DI(2242, 2247, 10, 34, 10, 34),
"SRM-XXR751ME F-Wave": DI(2243, 2248, 11, 35, 11, 35),
"SRM-XXR761ME F-Wave": DI(2244, 2249, 12, 36, 12, 36),
"SRM-XR722ME F-Wave": DI(2250, 2255, 3, 27, 3, 27),
"SRM-XR732ME F-Wave": DI(2251, 2256, 4, 28, 4, 28),
"SRM-XR742ME F-Wave": DI(2252, 2257, 5, 29, 5, 29),
"SRM-XR752ME F-Wave": DI(2253, 2258, 6, 30, 6, 30),
"SRM-XR762ME F-Wave": DI(2254, 2259, 7, 31, 7, 31),
"SRM-XXR722ME F-Wave": DI(2250, 2255, 8, 32, 8, 32),
"SRM-XXR732ME F-Wave": DI(2251, 2256, 9, 33, 9, 33),
"SRM-XXR742ME F-Wave": DI(2252, 2257, 10, 34, 10, 34),
"SRM-XXR752ME F-Wave": DI(2253, 2258, 11, 35, 11, 35),
"SRM-XXR762ME F-Wave": DI(2254, 2259, 12, 36, 12, 36),
"SRM-XR723ME F-Wave": DI(2260, 2265, 3, 27, 3, 27),
"SRM-XR733ME F-Wave": DI(2261, 2266, 4, 28, 4, 28),
"SRM-XR743ME F-Wave": DI(2262, 2267, 5, 29, 5, 29),
"SRM-XR753ME F-Wave": DI(2263, 2268, 6, 30, 6, 30),
"SRM-XR763ME F-Wave": DI(2264, 2269, 7, 31, 7, 31),
"SRM-XXR723ME F-Wave": DI(2260, 2265, 8, 32, 8, 32),
"SRM-XXR733ME F-Wave": DI(2261, 2266, 9, 33, 9, 33),
"SRM-XXR743ME F-Wave": DI(2262, 2267, 10, 34, 10, 34),
"SRM-XXR753ME F-Wave": DI(2263, 2268, 11, 35, 11, 35),
"SRM-XXR763ME F-Wave": DI(2264, 2269, 12, 36, 12, 36),
"SRM-XR724ME F-Wave": DI(2270, 2275, 3, 27, 3, 27),
"SRM-XR734ME F-Wave": DI(2271, 2276, 4, 28, 4, 28),
"SRM-XR744ME F-Wave": DI(2272, 2277, 5, 29, 5, 29),
"SRM-XR754ME F-Wave": DI(2273, 2278, 6, 30, 6, 30),
"SRM-XR764ME F-Wave": DI(2274, 2279, 7, 31, 7, 31),
"SRM-XXR724ME F-Wave": DI(2270, 2275, 8, 32, 8, 32),
"SRM-XXR734ME F-Wave": DI(2271, 2276, 9, 33, 9, 33),
"SRM-XXR744ME F-Wave": DI(2272, 2277, 10, 34, 10, 34),
"SRM-XXR754ME F-Wave": DI(2273, 2278, 11, 35, 11, 35),
"SRM-XXR764ME F-Wave": DI(2274, 2279, 12, 36, 12, 36),
"SRM-XR725ME F-Wave": DI(2280, 2285, 3, 27, 3, 27),
"SRM-XR735ME F-Wave": DI(2281, 2286, 4, 28, 4, 28),
"SRM-XR745ME F-Wave": DI(2282, 2287, 5, 29, 5, 29),
"SRM-XR755ME F-Wave": DI(2283, 2288, 6, 30, 6, 30),
"SRM-XR765ME F-Wave": DI(2284, 2289, 7, 31, 7, 31),
"SRM-XXR725ME F-Wave": DI(2280, 2285, 8, 32, 8, 32),
"SRM-XXR735ME F-Wave": DI(2281, 2286, 9, 33, 9, 33),
"SRM-XXR745ME F-Wave": DI(2282, 2287, 10, 34, 10, 34),
"SRM-XXR755ME F-Wave": DI(2283, 2288, 11, 35, 11, 35),
"SRM-XXR765ME F-Wave": DI(2284, 2289, 12, 36, 12, 36),
"SAM-XM120SA Shield": DI(2290, 2295, 3, 27, 3, 27),
"SAM-XM130SA Shield": DI(2291, 2296, 4, 28, 4, 28),
"SAM-XM140SA Shield": DI(2292, 2297, 5, 29, 5, 29),
"SAM-XM150SA Shield": DI(2293, 2298, 6, 30, 6, 30),
"SAM-XM160SA Shield": DI(2294, 2299, 7, 31, 7, 31),
"SAM-XXM120SA Shield": DI(2290, 2295, 8, 32, 8, 32),
"SAM-XXM130SA Shield": DI(2291, 2296, 9, 33, 9, 33),
"SAM-XXM140SA Shield": DI(2292, 2297, 10, 34, 10, 34),
"SAM-XXM150SA Shield": DI(2293, 2298, 11, 35, 11, 35),
"SAM-XXM160SA Shield": DI(2294, 2299, 12, 36, 12, 36),
"SAM-XM121SA Shield": DI(2300, 2305, 3, 27, 3, 27),
"SAM-XM131SA Shield": DI(2301, 2306, 4, 28, 4, 28),
"SAM-XM141SA Shield": DI(2302, 2307, 5, 29, 5, 29),
"SAM-XM151SA Shield": DI(2303, 2308, 6, 30, 6, 30),
"SAM-XM161SA Shield": DI(2304, 2309, 7, 31, 7, 31),
"SAM-XXM121SA Shield": DI(2300, 2305, 8, 32, 8, 32),
"SAM-XXM131SA Shield": DI(2301, 2306, 9, 33, 9, 33),
"SAM-XXM141SA Shield": DI(2302, 2307, 10, 34, 10, 34),
"SAM-XXM151SA Shield": DI(2303, 2308, 11, 35, 11, 35),
"SAM-XXM161SA Shield": DI(2304, 2309, 12, 36, 12, 36),
"SAM-XM122SA Shield": DI(2310, 2315, 3, 27, 3, 27),
"SAM-XM132SA Shield": DI(2311, 2316, 4, 28, 4, 28),
"SAM-XM142SA Shield": DI(2312, 2317, 5, 29, 5, 29),
"SAM-XM152SA Shield": DI(2313, 2318, 6, 30, 6, 30),
"SAM-XM162SA Shield": DI(2314, 2319, 7, 31, 7, 31),
"SAM-XXM122SA Shield": DI(2310, 2315, 8, 32, 8, 32),
"SAM-XXM132SA Shield": DI(2311, 2316, 9, 33, 9, 33),
"SAM-XXM142SA Shield": DI(2312, 2317, 10, 34, 10, 34),
"SAM-XXM152SA Shield": DI(2313, 2318, 11, 35, 11, 35),
"SAM-XXM162SA Shield": DI(2314, 2319, 12, 36, 12, 36),
"SAM-XM123SA Shield": DI(2320, 2325, 3, 27, 3, 27),
"SAM-XM133SA Shield": DI(2321, 2326, 4, 28, 4, 28),
"SAM-XM143SA Shield": DI(2322, 2327, 5, 29, 5, 29),
"SAM-XM153SA Shield": DI(2323, 2328, 6, 30, 6, 30),
"SAM-XM163SA Shield": DI(2324, 2329, 7, 31, 7, 31),
"SAM-XXM123SA Shield": DI(2320, 2325, 8, 32, 8, 32),
"SAM-XXM133SA Shield": DI(2321, 2326, 9, 33, 9, 33),
"SAM-XXM143SA Shield": DI(2322, 2327, 10, 34, 10, 34),
"SAM-XXM153SA Shield": DI(2323, 2328, 11, 35, 11, 35),
"SAM-XXM163SA Shield": DI(2324, 2329, 12, 36, 12, 36),
"SAM-XM124SA Shield": DI(2330, 2335, 3, 27, 3, 27),
"SAM-XM134SA Shield": DI(2331, 2336, 4, 28, 4, 28),
"SAM-XM144SA Shield": DI(2332, 2337, 5, 29, 5, 29),
"SAM-XM154SA Shield": DI(2333, 2338, 6, 30, 6, 30),
"SAM-XM164SA Shield": DI(2334, 2339, 7, 31, 7, 31),
"SAM-XXM124SA Shield": DI(2330, 2335, 8, 32, 8, 32),
"SAM-XXM134SA Shield": DI(2331, 2336, 9, 33, 9, 33),
"SAM-XXM144SA Shield": DI(2332, 2337, 10, 34, 10, 34),
"SAM-XXM154SA Shield": DI(2333, 2338, 11, 35, 11, 35),
"SAM-XXM164SA Shield": DI(2334, 2339, 12, 36, 12, 36),
"SAM-XM125SA Shield": DI(2340, 2345, 3, 27, 3, 27),
"SAM-XM135SA Shield": DI(2341, 2346, 4, 28, 4, 28),
"SAM-XM145SA Shield": DI(2342, 2347, 5, 29, 5, 29),
"SAM-XM155SA Shield": DI(2343, 2348, 6, 30, 6, 30),
"SAM-XM165SA Shield": DI(2344, 2349, 7, 31, 7, 31),
"SAM-XXM125SA Shield": DI(2340, 2345, 8, 32, 8, 32),
"SAM-XXM135SA Shield": DI(2341, 2346, 9, 33, 9, 33),
"SAM-XXM145SA Shield": DI(2342, 2347, 10, 34, 10, 34),
"SAM-XXM155SA Shield": DI(2343, 2348, 11, 35, 11, 35),
"SAM-XXM165SA Shield": DI(2344, 2349, 12, 36, 12, 36),
"SAM-XR120SA Minigun": DI(2410, 2415, 3, 27, 3, 27),
"SAM-XR130SA Minigun": DI(2411, 2416, 4, 28, 4, 28),
"SAM-XR140SA Minigun": DI(2412, 2417, 5, 29, 5, 29),
"SAM-XR150SA Minigun": DI(2413, 2418, 6, 30, 6, 30),
"SAM-XR160SA Minigun": DI(2414, 2419, 7, 31, 7, 31),
"SAM-XXR120SA Minigun": DI(2410, 2415, 8, 32, 8, 32),
"SAM-XXR130SA Minigun": DI(2411, 2416, 9, 33, 9, 33),
"SAM-XXR140SA Minigun": DI(2412, 2417, 10, 34, 10, 34),
"SAM-XXR150SA Minigun": DI(2413, 2418, 11, 35, 11, 35),
"SAM-XXR160SA Minigun": DI(2414, 2419, 12, 36, 12, 36),
"SAM-XM110ME Beam-Shield": DI(2350, 2355, 3, 27, 3, 27),
"SAM-XM120ME Beam-Shield": DI(2351, 2356, 4, 28, 4, 28),
"SAM-XM130ME Beam-Shield": DI(2352, 2357, 5, 29, 5, 29),
"SAM-XM140ME Beam-Shield": DI(2353, 2358, 6, 30, 6, 30),
"SAM-XM150ME Beam-Shield": DI(2354, 2359, 7, 31, 7, 31),
"SAM-XXM110ME Beam-Shield": DI(2350, 2355, 8, 32, 8, 32),
"SAM-XXM120ME Beam-Shield": DI(2351, 2356, 9, 33, 9, 33),
"SAM-XXM130ME Beam-Shield": DI(2352, 2357, 10, 34, 10, 34),
"SAM-XXM140ME Beam-Shield": DI(2353, 2358, 11, 35, 11, 35),
"SAM-XXM150ME Beam-Shield": DI(2354, 2359, 12, 36, 12, 36),
"SAM-XM111ME Beam-Shield": DI(2360, 2365, 3, 27, 3, 27),
"SAM-XM121ME Beam-Shield": DI(2361, 2366, 4, 28, 4, 28),
"SAM-XM131ME Beam-Shield": DI(2362, 2367, 5, 29, 5, 29),
"SAM-XM141ME Beam-Shield": DI(2363, 2368, 6, 30, 6, 30),
"SAM-XM151ME Beam-Shield": DI(2364, 2369, 7, 31, 7, 31),
"SAM-XXM111ME Beam-Shield": DI(2360, 2365, 8, 32, 8, 32),
"SAM-XXM121ME Beam-Shield": DI(2361, 2366, 9, 33, 9, 33),
"SAM-XXM131ME Beam-Shield": DI(2362, 2367, 10, 34, 10, 34),
"SAM-XXM141ME Beam-Shield": DI(2363, 2368, 11, 35, 11, 35),
"SAM-XXM151ME Beam-Shield": DI(2364, 2369, 12, 36, 12, 36),
"SAM-XM112ME Beam-Shield": DI(2370, 2375, 3, 27, 3, 27),
"SAM-XM122ME Beam-Shield": DI(2371, 2376, 4, 28, 4, 28),
"SAM-XM132ME Beam-Shield": DI(2372, 2377, 5, 29, 5, 29),
"SAM-XM142ME Beam-Shield": DI(2373, 2378, 6, 30, 6, 30),
"SAM-XM152ME Beam-Shield": DI(2374, 2379, 7, 31, 7, 31),
"SAM-XXM112ME Beam-Shield": DI(2370, 2375, 8, 32, 8, 32),
"SAM-XXM122ME Beam-Shield": DI(2371, 2376, 9, 33, 9, 33),
"SAM-XXM132ME Beam-Shield": DI(2372, 2377, 10, 34, 10, 34),
"SAM-XXM142ME Beam-Shield": DI(2373, 2378, 11, 35, 11, 35),
"SAM-XXM152ME Beam-Shield": DI(2374, 2379, 12, 36, 12, 36),
"SAM-XM113ME Beam-Shield": DI(2380, 2385, 3, 27, 3, 27),
"SAM-XM123ME Beam-Shield": DI(2381, 2386, 4, 28, 4, 28),
"SAM-XM133ME Beam-Shield": DI(2382, 2387, 5, 29, 5, 29),
"SAM-XM143ME Beam-Shield": DI(2383, 2388, 6, 30, 6, 30),
"SAM-XM153ME Beam-Shield": DI(2384, 2389, 7, 31, 7, 31),
"SAM-XXM113ME Beam-Shield": DI(2380, 2385, 8, 32, 8, 32),
"SAM-XXM123ME Beam-Shield": DI(2381, 2386, 9, 33, 9, 33),
"SAM-XXM133ME Beam-Shield": DI(2382, 2387, 10, 34, 10, 34),
"SAM-XXM143ME Beam-Shield": DI(2383, 2388, 11, 35, 11, 35),
"SAM-XXM153ME Beam-Shield": DI(2384, 2389, 12, 36, 12, 36),
"SAM-XM114ME Beam-Shield": DI(2390, 2395, 3, 27, 3, 27),
"SAM-XM124ME Beam-Shield": DI(2391, 2396, 4, 28, 4, 28),
"SAM-XM134ME Beam-Shield": DI(2392, 2397, 5, 29, 5, 29),
"SAM-XM144ME Beam-Shield": DI(2393, 2398, 6, 30, 6, 30),
"SAM-XM154ME Beam-Shield": DI(2394, 2399, 7, 31, 7, 31),
"SAM-XXM114ME Beam-Shield": DI(2390, 2395, 8, 32, 8, 32),
"SAM-XXM124ME Beam-Shield": DI(2391, 2396, 9, 33, 9, 33),
"SAM-XXM134ME Beam-Shield": DI(2392, 2397, 10, 34, 10, 34),
"SAM-XXM144ME Beam-Shield": DI(2393, 2398, 11, 35, 11, 35),
"SAM-XXM154ME Beam-Shield": DI(2394, 2399, 12, 36, 12, 36),
"SAM-XM115ME Beam-Shield": DI(2400, 2405, 3, 27, 3, 27),
"SAM-XM125ME Beam-Shield": DI(2401, 2406, 4, 28, 4, 28),
"SAM-XM135ME Beam-Shield": DI(2402, 2407, 5, 29, 5, 29),
"SAM-XM145ME Beam-Shield": DI(2403, 2408, 6, 30, 6, 30),
"SAM-XM155ME Beam-Shield": DI(2404, 2409, 7, 31, 7, 31),
"SAM-XXM115ME Beam-Shield": DI(2400, 2405, 8, 32, 8, 32),
"SAM-XXM125ME Beam-Shield": DI(2401, 2406, 9, 33, 9, 33),
"SAM-XXM135ME Beam-Shield": DI(2402, 2407, 10, 34, 10, 34),
"SAM-XXM145ME Beam-Shield": DI(2403, 2408, 11, 35, 11, 35),
"SAM-XXM155ME Beam-Shield": DI(2404, 2409, 12, 36, 12, 36),
"SAM-XR120ME Needlegun": DI(2420, 2425, 3, 27, 3, 27),
"SAM-XR130ME Needlegun": DI(2421, 2426, 4, 28, 4, 28),
"SAM-XR140ME Needlegun": DI(2422, 2427, 5, 29, 5, 29),
"SAM-XR150ME Needlegun": DI(2423, 2428, 6, 30, 6, 30),
"SAM-XR160ME Needlegun": DI(2424, 2429, 7, 31, 7, 31),
"SAM-XXR120ME Needlegun": DI(2420, 2425, 8, 32, 8, 32),
"SAM-XXR130ME Needlegun": DI(2421, 2426, 9, 33, 9, 33),
"SAM-XXR140ME Needlegun": DI(2422, 2427, 10, 34, 10, 34),
"SAM-XXR150ME Needlegun": DI(2423, 2428, 11, 35, 11, 35),
"SAM-XXR160ME Needlegun": DI(2424, 2429, 12, 36, 12, 36),
"SKM-XM120SA Beamsaber": DI(2430, 2435, 3, 27, 3, 27),
"SKM-XM130SA Beamsaber": DI(2431, 2436, 4, 28, 4, 28),
"SKM-XM140SA Beamsaber": DI(2432, 2437, 5, 29, 5, 29),
"SKM-XM150SA Beamsaber": DI(2433, 2438, 6, 30, 6, 30),
"SKM-XM160SA Beamsaber": DI(2434, 2439, 7, 31, 7, 31),
"SKM-XXM120SA Beamsaber": DI(2430, 2435, 8, 32, 8, 32),
"SKM-XXM130SA Beamsaber": DI(2431, 2436, 9, 33, 9, 33),
"SKM-XXM140SA Beamsaber": DI(2432, 2437, 10, 34, 10, 34),
"SKM-XXM150SA Beamsaber": DI(2433, 2438, 11, 35, 11, 35),
"SKM-XXM160SA Beamsaber": DI(2434, 2439, 12, 36, 12, 36),
"SKM-XM220SA V-knuckle": DI(2440, 2445, 3, 27, 3, 27),
"SKM-XM230SA V-knuckle": DI(2441, 2446, 4, 28, 4, 28),
"SKM-XM240SA V-knuckle": DI(2442, 2447, 5, 29, 5, 29),
"SKM-XM250SA V-knuckle": DI(2443, 2448, 6, 30, 6, 30),
"SKM-XM260SA V-knuckle": DI(2444, 2449, 7, 31, 7, 31),
"SKM-XXM220SA V-knuckle": DI(2440, 2445, 8, 32, 8, 32),
"SKM-XXM230SA V-knuckle": DI(2441, 2446, 9, 33, 9, 33),
"SKM-XXM240SA V-knuckle": DI(2442, 2447, 10, 34, 10, 34),
"SKM-XXM250SA V-knuckle": DI(2443, 2448, 11, 35, 11, 35),
"SKM-XXM260SA V-knuckle": DI(2444, 2449, 12, 36, 12, 36),
"SKM-XM120GG Ringedge": DI(2450, 2455, 3, 27, 3, 27),
"SKM-XM130GG Ringedge": DI(2451, 2456, 4, 28, 4, 28),
"SKM-XM140GG Ringedge": DI(2452, 2457, 5, 29, 5, 29),
"SKM-XM150GG Ringedge": DI(2453, 2458, 6, 30, 6, 30),
"SKM-XM160GG Ringedge": DI(2454, 2459, 7, 31, 7, 31),
"SKM-XXM120GG Ringedge": DI(2450, 2455, 8, 32, 8, 32),
"SKM-XXM130GG Ringedge": DI(2451, 2456, 9, 33, 9, 33),
"SKM-XXM140GG Ringedge": DI(2452, 2457, 10, 34, 10, 34),
"SKM-XXM150GG Ringedge": DI(2453, 2458, 11, 35, 11, 35),
"SKM-XXM160GG Ringedge": DI(2454, 2459, 12, 36, 12, 36),
"SKM-XM210ME Falchion": DI(2460, 2465, 3, 27, 3, 27),
"SKM-XM310ME Falchion": DI(2461, 2466, 4, 28, 4, 28),
"SKM-XM410ME Falchion": DI(2462, 2467, 5, 29, 5, 29),
"SKM-XM510ME Falchion": DI(2463, 2468, 6, 30, 6, 30),
"SKM-XM610ME Falchion": DI(2464, 2469, 7, 31, 7, 31),
"SKM-XXM210ME Falchion": DI(2460, 2465, 8, 32, 8, 32),
"SKM-XXM310ME Falchion": DI(2461, 2466, 9, 33, 9, 33),
"SKM-XXM410ME Falchion": DI(2462, 2467, 10, 34, 10, 34),
"SKM-XXM510ME Falchion": DI(2463, 2468, 11, 35, 11, 35),
"SKM-XXM610ME Falchion": DI(2464, 2469, 12, 36, 12, 36),
"SKM-XM220ME Claymore": DI(2470, 2475, 3, 27, 3, 27),
"SKM-XM230ME Claymore": DI(2471, 2476, 4, 28, 4, 28),
"SKM-XM240ME Claymore": DI(2472, 2477, 5, 29, 5, 29),
"SKM-XM250ME Claymore": DI(2473, 2478, 6, 30, 6, 30),
"SKM-XM260ME Claymore": DI(2474, 2479, 7, 31, 7, 31),
"SKM-XXM220ME Claymore": DI(2470, 2475, 8, 32, 8, 32),
"SKM-XXM230ME Claymore": DI(2471, 2476, 9, 33, 9, 33),
"SKM-XXM240ME Claymore": DI(2472, 2477, 10, 34, 10, 34),
"SKM-XXM250ME Claymore": DI(2473, 2478, 11, 35, 11, 35),
"SKM-XXM260ME Claymore": DI(2474, 2479, 12, 36, 12, 36),
"SKM-XM320ME Katar": DI(2480, 2485, 3, 27, 3, 27),
"SKM-XM330ME Katar": DI(2481, 2486, 4, 28, 4, 28),
"SKM-XM340ME Katar": DI(2482, 2487, 5, 29, 5, 29),
"SKM-XM350ME Katar": DI(2483, 2488, 6, 30, 6, 30),
"SKM-XM360ME Katar": DI(2484, 2489, 7, 31, 7, 31),
"SKM-XXM320ME Katar": DI(2480, 2485, 8, 32, 8, 32),
"SKM-XXM330ME Katar": DI(2481, 2486, 9, 33, 9, 33),
"SKM-XXM340ME Katar": DI(2482, 2487, 10, 34, 10, 34),
"SKM-XXM350ME Katar": DI(2483, 2488, 11, 35, 11, 35),
"SKM-XXM360ME Katar": DI(2484, 2489, 12, 36, 12, 36),
"SKM-XR320SA Cracker-BM": DI(2490, 2495, 3, 27, 3, 27),
"SKM-XR330SA Cracker-BM": DI(2491, 2496, 4, 28, 4, 28),
"SKM-XR340SA Cracker-BM": DI(2492, 2497, 5, 29, 5, 29),
"SKM-XR350SA Cracker-BM": DI(2493, 2498, 6, 30, 6, 30),
"SKM-XR360SA Cracker-BM": DI(2494, 2499, 7, 31, 7, 31),
"SKM-XXR320SA Cracker-BM": DI(2490, 2495, 8, 32, 8, 32),
"SKM-XXR330SA Cracker-BM": DI(2491, 2496, 9, 33, 9, 33),
"SKM-XXR340SA Cracker-BM": DI(2492, 2497, 10, 34, 10, 34),
"SKM-XXR350SA Cracker-BM": DI(2493, 2498, 11, 35, 11, 35),
"SKM-XXR360SA Cracker-BM": DI(2494, 2499, 12, 36, 12, 36),
"SKM-XR320GG Cracker-FL": DI(2500, 2505, 3, 27, 3, 27),
"SKM-XR330GG Cracker-FL": DI(2501, 2506, 4, 28, 4, 28),
"SKM-XR340GG Cracker-FL": DI(2502, 2507, 5, 29, 5, 29),
"SKM-XR350GG Cracker-FL": DI(2503, 2508, 6, 30, 6, 30),
"SKM-XR360GG Cracker-FL": DI(2504, 2509, 7, 31, 7, 31),
"SKM-XXR320GG Cracker-FL": DI(2500, 2505, 8, 32, 8, 32),
"SKM-XXR330GG Cracker-FL": DI(2501, 2506, 9, 33, 9, 33),
"SKM-XXR340GG Cracker-FL": DI(2502, 2507, 10, 34, 10, 34),
"SKM-XXR350GG Cracker-FL": DI(2503, 2508, 11, 35, 11, 35),
"SKM-XXR360GG Cracker-FL": DI(2504, 2509, 12, 36, 12, 36),
"SKM-XR320ME Cracker-PD": DI(2510, 2515, 3, 27, 3, 27),
"SKM-XR330ME Cracker-PD": DI(2511, 2516, 4, 28, 4, 28),
"SKM-XR340ME Cracker-PD": DI(2512, 2517, 5, 29, 5, 29),
"SKM-XR350ME Cracker-PD": DI(2513, 2518, 6, 30, 6, 30),
"SKM-XR360ME Cracker-PD": DI(2514, 2519, 7, 31, 7, 31),
"SKM-XXR320ME Cracker-PD": DI(2510, 2515, 8, 32, 8, 32),
"SKM-XXR330ME Cracker-PD": DI(2511, 2516, 9, 33, 9, 33),
"SKM-XXR340ME Cracker-PD": DI(2512, 2517, 10, 34, 10, 34),
"SKM-XXR350ME Cracker-PD": DI(2513, 2518, 11, 35, 11, 35),
"SKM-XXR360ME Cracker-PD": DI(2514, 2519, 12, 36, 12, 36),
"SRM-XR130GA V-Beam": DI(2760, 2764, 4, 28, 9, 33),
"SRM-XR140GA V-Beam": DI(2761, 2765, 5, 29, 10, 34),
"SRM-XR150GA V-Beam": DI(2762, 2766, 6, 30, 11, 35),
"SRM-XR160GA V-Beam": DI(2763, 2767, 7, 31, 12, 36),
"SRM-XR230GA T-Claw": DI(2768, 2772, 4, 28, 9, 33),
"SRM-XR240GA T-Claw": DI(2769, 2773, 5, 29, 10, 34),
"SRM-XR250GA T-Claw": DI(2770, 2774, 6, 30, 11, 35),
"SRM-XR260GA T-Claw": DI(2771, 2775, 7, 31, 12, 36),
"SSM-XR330GA H-Missile": DI(2776, 2780, 4, 28, 9, 33),
"SSM-XR340GA H-Missile": DI(2777, 2781, 5, 29, 10, 34),
"SSM-XR350GA H-Missile": DI(2778, 2782, 6, 30, 11, 35),
"SSM-XR360GA H-Missile": DI(2779, 2783, 7, 31, 12, 36),
"SSM-XR430GA G-Revolver": DI(2784, 2788, 4, 28, 9, 33),
"SSM-XR440GA G-Revolver": DI(2785, 2789, 5, 29, 10, 34),
"SSM-XR450GA G-Revolver": DI(2786, 2790, 6, 30, 11, 35),
"SSM-XR460GA G-Revolver": DI(2787, 2791, 7, 31, 12, 36),
"SRM-XR530GA R-Cannon": DI(2792, 2796, 4, 28, 9, 33),
"SRM-XR540GA R-Cannon": DI(2793, 2797, 5, 29, 10, 34),
"SRM-XR550GA R-Cannon": DI(2794, 2798, 6, 30, 11, 35),
"SRM-XR560GA R-Cannon": DI(2795, 2799, 7, 31, 12, 36),
"SSM-XR630GA Night-Cage": DI(2800, 2804, 4, 28, 9, 33),
"SSM-XR640GA Night-Cage": DI(2801, 2805, 5, 29, 10, 34),
"SSM-XR650GA Night-Cage": DI(2802, 2806, 6, 30, 11, 35),
"SSM-XR660GA Night-Cage": DI(2803, 2807, 7, 31, 12, 36),
"SSM-XR730GA M-Missile": DI(2808, 2812, 4, 28, 9, 33),
"SSM-XR740GA M-Missile": DI(2809, 2813, 5, 29, 10, 34),
"SSM-XR750GA M-Missile": DI(2810, 2814, 6, 30, 11, 35),
"SSM-XR760GA M-Missile": DI(2811, 2815, 7, 31, 12, 36),
"SRM-XR2130GA Rail-Gun": DI(2816, 2820, 4, 28, 9, 33),
"SRM-XR2140GA Rail-Gun": DI(2817, 2821, 5, 29, 10, 34),
"SRM-XR2150GA Rail-Gun": DI(2818, 2822, 6, 30, 11, 35),
"SRM-XR2160GA Rail-Gun": DI(2819, 2823, 7, 31, 12, 36),
"SRM-XR2230GA M-Laser": DI(2824, 2828, 4, 28, 9, 33),
"SRM-XR2240GA M-Laser": DI(2825, 2829, 5, 29, 10, 34),
"SRM-XR2250GA M-Laser": DI(2826, 2830, 6, 30, 11, 35),
"SRM-XR2260GA M-Laser": DI(2827, 2831, 7, 31, 12, 36),
"SSM-XR2330GA Spine-Cannon": DI(2832, 2836, 4, 28, 9, 33),
"SSM-XR2340GA Spine-Cannon": DI(2833, 2837, 5, 29, 10, 34),
"SSM-XR2350GA Spine-Cannon": DI(2834, 2838, 6, 30, 11, 35),
"SSM-XR2360GA Spine-Cannon": DI(2835, 2839, 7, 31, 12, 36),
"SSM-XR2430GA E-Bubble": DI(2840, 2844, 4, 28, 9, 33),
"SSM-XR2440GA E-Bubble": DI(2841, 2845, 5, 29, 10, 34),
"SSM-XR2450GA E-Bubble": DI(2842, 2846, 6, 30, 11, 35),
"SSM-XR2460GA E-Bubble": DI(2843, 2847, 7, 31, 12, 36),
"SSM-XR2530GA B-Bomb": DI(2848, 2852, 4, 28, 9, 33),
"SSM-XR2540GA B-Bomb": DI(2849, 2853, 5, 29, 10, 34),
"SSM-XR2550GA B-Bomb": DI(2850, 2854, 6, 30, 11, 35),
"SSM-XR2560GA B-Bomb": DI(2851, 2855, 7, 31, 12, 36),
"SSM-XR130LA L-Cannon": DI(2856, 2860, 4, 28, 9, 33),
"SSM-XR140LA L-Cannon": DI(2857, 2861, 5, 29, 10, 34),
"SSM-XR150LA L-Cannon": DI(2858, 2862, 6, 30, 11, 35),
"SSM-XR160LA L-Cannon": DI(2859, 2863, 7, 31, 12, 36),
"SSM-XR230LA F-Arrow": DI(2864, 2868, 4, 28, 9, 33),
"SSM-XR240LA F-Arrow": DI(2865, 2869, 5, 29, 10, 34),
"SSM-XR250LA F-Arrow": DI(2866, 2870, 6, 30, 11, 35),
"SSM-XR260LA F-Arrow": DI(2867, 2871, 7, 31, 12, 36),
"SRM-XR330LA A-Spear": DI(2872, 2876, 4, 28, 9, 33),
"SRM-XR340LA A-Spear": DI(2873, 2877, 5, 29, 10, 34),
"SRM-XR350LA A-Spear": DI(2874, 2878, 6, 30, 11, 35),
"SRM-XR360LA A-Spear": DI(2875, 2879, 7, 31, 12, 36),
"SRM-XR5140LA HOMURA": DI(2880, 2884, 4, 28, 9, 33),
"SRM-XR5250LA KUROGANE": DI(2888, 2892, 4, 28, 9, 33),
"SSM-XR5340LA OROCHI": DI(2896, 2900, 4, 28, 9, 33),
"SRM-XR3130LA SENJU": DI(2904, 2908, 4, 28, 9, 33),
"SRM-XR3150 DARKGOD": DI(2914, 2918, 6, 30, 11, 35),
"SRM-XR161GA V-Beam": DI(2763, 2767, 7, 31, 12, 36),
"SRM-XR251GA T-Claw": DI(2770, 2774, 6, 30, 11, 35),
"SSM-XR341GA H-Missile": DI(2777, 2781, 5, 29, 10, 34),
"SSM-XR451GA G-Revolver": DI(2786, 2790, 6, 30, 11, 35),
"SRM-XR562GA R-Cannon": DI(2795, 2799, 7, 31, 12, 36),
"SSM-XR662GA Night-Cage": DI(2803, 2807, 7, 31, 12, 36),
"SSM-XR762GA M-Missile": DI(2811, 2815, 7, 31, 12, 36),
"SRM-XR2141GA Rail-Gun": DI(2817, 2821, 5, 29, 10, 34),
"SRM-XR2241GA M-Laser": DI(2825, 2829, 5, 29, 10, 34),
"SSM-XR2541GA B-Bomb": DI(2849, 2853, 5, 29, 10, 34),
"SSM-XR2352GA Spine-Cannon": DI(2834, 2838, 6, 30, 11, 35),
"SRM-XR2252GA M-Laser": DI(2826, 2830, 6, 30, 11, 35),
"SSM-XR2552GA B-Bomb": DI(2850, 2854, 6, 30, 11, 35),
"SRM-XR2163GA Rail-Gun": DI(2819, 2823, 7, 31, 12, 36),
"SRM-XR2263GA M-Laser": DI(2827, 2831, 7, 31, 12, 36),
"SSM-XR2563GA B-Bomb": DI(2851, 2855, 7, 31, 12, 36),
"SSM-XR2334GA Spine-Cannon": DI(2832, 2836, 4, 28, 9, 33),
"SSM-XR2534GA B-Bomb": DI(2848, 2852, 4, 28, 9, 33),
"XSK20SA L-HEAD-SPD2": DI(2520, 2525, 13, 37, 18, 42),
"XSK20SA L-BODY-SPD2": DI(2530, 2535, 13, 37, 18, 42),
"XSK20SA L-RARM-SPD2": DI(2540, 2545, 13, 37, 18, 42),
"XSK20SA L-LARM-SPD2": DI(2540, 2545, 13, 37, 18, 42),
"XSK20SA L-LEGS-SPD2": DI(2550, 2555, 13, 37, 18, 42),
"XSK30SA L-HEAD-SPD2": DI(2521, 2526, 14, 38, 19, 43),
"XSK30SA L-BODY-SPD2": DI(2531, 2536, 14, 38, 19, 43),
"XSK30SA L-RARM-SPD2": DI(2541, 2546, 14, 38, 19, 43),
"XSK30SA L-LARM-SPD2": DI(2541, 2546, 14, 38, 19, 43),
"XSK30SA L-LEGS-SPD2": DI(2551, 2556, 14, 38, 19, 43),
"XSK40SA L-HEAD-SPD2": DI(2522, 2527, 15, 39, 20, 44),
"XSK40SA L-BODY-SPD2": DI(2532, 2537, 15, 39, 20, 44),
"XSK40SA L-RARM-SPD2": DI(2542, 2547, 15, 39, 20, 44),
"XSK40SA L-LARM-SPD2": DI(2542, 2547, 15, 39, 20, 44),
"XSK40SA L-LEGS-SPD2": DI(2552, 2557, 15, 39, 20, 44),
"XSK50SA L-HEAD-SPD2": DI(2523, 2528, 16, 40, 21, 45),
"XSK50SA L-BODY-SPD2": DI(2533, 2538, 16, 40, 21, 45),
"XSK50SA L-RARM-SPD2": DI(2543, 2548, 16, 40, 21, 45),
"XSK50SA L-LARM-SPD2": DI(2543, 2548, 16, 40, 21, 45),
"XSK50SA L-LEGS-SPD2": DI(2553, 2558, 16, 40, 21, 45),
"XSK60SA L-HEAD-SPD2": DI(2524, 2529, 17, 41, 22, 46),
"XSK60SA L-BODY-SPD2": DI(2534, 2539, 17, 41, 22, 46),
"XSK60SA L-RARM-SPD2": DI(2544, 2549, 17, 41, 22, 46),
"XSK60SA L-LARM-SPD2": DI(2544, 2549, 17, 41, 22, 46),
"XSK60SA L-LEGS-SPD2": DI(2554, 2559, 17, 41, 22, 46),
"XSK20GG L-HEAD-SPD3": DI(2560, 2565, 13, 37, 18, 42),
"XSK20GG L-BODY-SPD3": DI(2570, 2575, 13, 37, 18, 42),
"XSK20GG L-RARM-SPD3": DI(2580, 2585, 13, 37, 18, 42),
"XSK20GG L-LARM-SPD3": DI(2580, 2585, 13, 37, 18, 42),
"XSK20GG L-LEGS-SPD3": DI(2590, 2595, 13, 37, 18, 42),
"XSK30GG L-HEAD-SPD3": DI(2561, 2566, 14, 38, 19, 43),
"XSK30GG L-BODY-SPD3": DI(2571, 2576, 14, 38, 19, 43),
"XSK30GG L-RARM-SPD3": DI(2581, 2586, 14, 38, 19, 43),
"XSK30GG L-LARM-SPD3": DI(2581, 2586, 14, 38, 19, 43),
"XSK30GG L-LEGS-SPD3": DI(2591, 2596, 14, 38, 19, 43),
"XSK40GG L-HEAD-SPD3": DI(2562, 2567, 15, 39, 20, 44),
"XSK40GG L-BODY-SPD3": DI(2572, 2577, 15, 39, 20, 44),
"XSK40GG L-RARM-SPD3": DI(2582, 2587, 15, 39, 20, 44),
"XSK40GG L-LARM-SPD3": DI(2582, 2587, 15, 39, 20, 44),
"XSK40GG L-LEGS-SPD3": DI(2592, 2597, 15, 39, 20, 44),
"XSK50GG L-HEAD-SPD3": DI(2563, 2568, 16, 40, 21, 45),
"XSK50GG L-BODY-SPD3": DI(2573, 2578, 16, 40, 21, 45),
"XSK50GG L-RARM-SPD3": DI(2583, 2588, 16, 40, 21, 45),
"XSK50GG L-LARM-SPD3": DI(2583, 2588, 16, 40, 21, 45),
"XSK50GG L-LEGS-SPD3": DI(2593, 2598, 16, 40, 21, 45),
"XSK60GG L-HEAD-SPD3": DI(2564, 2569, 17, 41, 22, 46),
"XSK60GG L-BODY-SPD3": DI(2574, 2579, 17, 41, 22, 46),
"XSK60GG L-RARM-SPD3": DI(2584, 2589, 17, 41, 22, 46),
"XSK60GG L-LARM-SPD3": DI(2584, 2589, 17, 41, 22, 46),
"XSK60GG L-LEGS-SPD3": DI(2594, 2599, 17, 41, 22, 46),
"XSK20SA M-HEAD-MEL2": DI(2600, 2605, 13, 37, 18, 42),
"XSK20SA M-BODY-MEL2": DI(2610, 2615, 13, 37, 18, 42),
"XSK20SA M-RARM-MEL2": DI(2620, 2625, 13, 37, 18, 42),
"XSK20SA M-LARM-MEL2": DI(2620, 2625, 13, 37, 18, 42),
"XSK20SA M-LEGS-MEL2": DI(2630, 2635, 13, 37, 18, 42),
"XSK30SA M-HEAD-MEL2": DI(2601, 2606, 14, 38, 19, 43),
"XSK30SA M-BODY-MEL2": DI(2611, 2616, 14, 38, 19, 43),
"XSK30SA M-RARM-MEL2": DI(2621, 2626, 14, 38, 19, 43),
"XSK30SA M-LARM-MEL2": DI(2621, 2626, 14, 38, 19, 43),
"XSK30SA M-LEGS-MEL2": DI(2631, 2636, 14, 38, 19, 43),
"XSK40SA M-HEAD-MEL2": DI(2602, 2607, 15, 39, 20, 44),
"XSK40SA M-BODY-MEL2": DI(2612, 2617, 15, 39, 20, 44),
"XSK40SA M-RARM-MEL2": DI(2622, 2627, 15, 39, 20, 44),
"XSK40SA M-LARM-MEL2": DI(2622, 2627, 15, 39, 20, 44),
"XSK40SA M-LEGS-MEL2": DI(2632, 2637, 15, 39, 20, 44),
"XSK50SA M-HEAD-MEL2": DI(2603, 2608, 16, 40, 21, 45),
"XSK50SA M-BODY-MEL2": DI(2613, 2618, 16, 40, 21, 45),
"XSK50SA M-RARM-MEL2": DI(2623, 2628, 16, 40, 21, 45),
"XSK50SA M-LARM-MEL2": DI(2623, 2628, 16, 40, 21, 45),
"XSK50SA M-LEGS-MEL2": DI(2633, 2638, 16, 40, 21, 45),
"XSK60SA M-HEAD-MEL2": DI(2604, 2609, 17, 41, 22, 46),
"XSK60SA M-BODY-MEL2": DI(2614, 2619, 17, 41, 22, 46),
"XSK60SA M-RARM-MEL2": DI(2624, 2629, 17, 41, 22, 46),
"XSK60SA M-LARM-MEL2": DI(2624, 2629, 17, 41, 22, 46),
"XSK60SA M-LEGS-MEL2": DI(2634, 2639, 17, 41, 22, 46),
"XSK20SA M-HEAD-DEF2": DI(2640, 2645, 13, 37, 18, 42),
"XSK20SA M-BODY-DEF2": DI(2650, 2655, 13, 37, 18, 42),
"XSK20SA M-RARM-DEF2": DI(2660, 2665, 13, 37, 18, 42),
"XSK20SA M-LARM-DEF2": DI(2660, 2665, 13, 37, 18, 42),
"XSK20SA M-LEGS-DEF2": DI(2670, 2675, 13, 37, 18, 42),
"XSK30SA M-HEAD-DEF2": DI(2641, 2646, 14, 38, 19, 43),
"XSK30SA M-BODY-DEF2": DI(2651, 2656, 14, 38, 19, 43),
"XSK30SA M-RARM-DEF2": DI(2661, 2666, 14, 38, 19, 43),
"XSK30SA M-LARM-DEF2": DI(2661, 2666, 14, 38, 19, 43),
"XSK30SA M-LEGS-DEF2": DI(2671, 2676, 14, 38, 19, 43),
"XSK40SA M-HEAD-DEF2": DI(2642, 2647, 15, 39, 20, 44),
"XSK40SA M-BODY-DEF2": DI(2652, 2657, 15, 39, 20, 44),
"XSK40SA M-RARM-DEF2": DI(2662, 2667, 15, 39, 20, 44),
"XSK40SA M-LARM-DEF2": DI(2662, 2667, 15, 39, 20, 44),
"XSK40SA M-LEGS-DEF2": DI(2672, 2677, 15, 39, 20, 44),
"XSK50SA M-HEAD-DEF2": DI(2643, 2648, 16, 40, 21, 45),
"XSK50SA M-BODY-DEF2": DI(2653, 2658, 16, 40, 21, 45),
"XSK50SA M-RARM-DEF2": DI(2663, 2668, 16, 40, 21, 45),
"XSK50SA M-LARM-DEF2": DI(2663, 2668, 16, 40, 21, 45),
"XSK50SA M-LEGS-DEF2": DI(2673, 2678, 16, 40, 21, 45),
"XSK60SA M-HEAD-DEF2": DI(2644, 2649, 17, 41, 22, 46),
"XSK60SA M-BODY-DEF2": DI(2654, 2659, 17, 41, 22, 46),
"XSK60SA M-RARM-DEF2": DI(2664, 2669, 17, 41, 22, 46),
"XSK60SA M-LARM-DEF2": DI(2664, 2669, 17, 41, 22, 46),
"XSK60SA M-LEGS-DEF2": DI(2674, 2679, 17, 41, 22, 46),
"XSK20SA H-HEAD-ATK4": DI(2680, 2685, 13, 37, 18, 42),
"XSK20SA H-BODY-ATK4": DI(2690, 2695, 13, 37, 18, 42),
"XSK20SA H-RARM-ATK4": DI(2700, 2705, 13, 37, 18, 42),
"XSK20SA H-LARM-ATK4": DI(2700, 2705, 13, 37, 18, 42),
"XSK20SA H-LEGS-ATK4": DI(2710, 2715, 13, 37, 18, 42),
"XSK30SA H-HEAD-ATK4": DI(2681, 2686, 14, 38, 19, 43),
"XSK30SA H-BODY-ATK4": DI(2691, 2696, 14, 38, 19, 43),
"XSK30SA H-RARM-ATK4": DI(2701, 2706, 14, 38, 19, 43),
"XSK30SA H-LARM-ATK4": DI(2701, 2706, 14, 38, 19, 43),
"XSK30SA H-LEGS-ATK4": DI(2711, 2716, 14, 38, 19, 43),
"XSK40SA H-HEAD-ATK4": DI(2682, 2687, 15, 39, 20, 44),
"XSK40SA H-BODY-ATK4": DI(2692, 2697, 15, 39, 20, 44),
"XSK40SA H-RARM-ATK4": DI(2702, 2707, 15, 39, 20, 44),
"XSK40SA H-LARM-ATK4": DI(2702, 2707, 15, 39, 20, 44),
"XSK40SA H-LEGS-ATK4": DI(2712, 2717, 15, 39, 20, 44),
"XSK50SA H-HEAD-ATK4": DI(2683, 2688, 16, 40, 21, 45),
"XSK50SA H-BODY-ATK4": DI(2693, 2698, 16, 40, 21, 45),
"XSK50SA H-RARM-ATK4": DI(2703, 2708, 16, 40, 21, 45),
"XSK50SA H-LARM-ATK4": DI(2703, 2708, 16, 40, 21, 45),
"XSK50SA H-LEGS-ATK4": DI(2713, 2718, 16, 40, 21, 45),
"XSK60SA H-HEAD-ATK4": DI(2684, 2689, 17, 41, 22, 46),
"XSK60SA H-BODY-ATK4": DI(2694, 2699, 17, 41, 22, 46),
"XSK60SA H-RARM-ATK4": DI(2704, 2709, 17, 41, 22, 46),
"XSK60SA H-LARM-ATK4": DI(2704, 2709, 17, 41, 22, 46),
"XSK60SA H-LEGS-ATK4": DI(2714, 2719, 17, 41, 22, 46),
"XSK20ME H-HEAD-ATK5": DI(2720, 2725, 13, 37, 18, 42),
"XSK20ME H-BODY-ATK5": DI(2730, 2735, 13, 37, 18, 42),
"XSK20ME H-RARM-ATK5": DI(2740, 2745, 13, 37, 18, 42),
"XSK20ME H-LARM-ATK5": DI(2740, 2745, 13, 37, 18, 42),
"XSK20ME H-LEGS-ATK5": DI(2750, 2755, 13, 37, 18, 42),
"XSK30ME H-HEAD-ATK5": DI(2721, 2726, 14, 38, 19, 43),
"XSK30ME H-BODY-ATK5": DI(2731, 2736, 14, 38, 19, 43),
"XSK30ME H-RARM-ATK5": DI(2741, 2746, 14, 38, 19, 43),
"XSK30ME H-LARM-ATK5": DI(2741, 2746, 14, 38, 19, 43),
"XSK30ME H-LEGS-ATK5": DI(2751, 2756, 14, 38, 19, 43),
"XSK40ME H-HEAD-ATK5": DI(2722, 2727, 15, 39, 20, 44),
"XSK40ME H-BODY-ATK5": DI(2732, 2737, 15, 39, 20, 44),
"XSK40ME H-RARM-ATK5": DI(2742, 2747, 15, 39, 20, 44),
"XSK40ME H-LARM-ATK5": DI(2742, 2747, 15, 39, 20, 44),
"XSK40ME H-LEGS-ATK5": DI(2752, 2757, 15, 39, 20, 44),
"XSK50ME H-HEAD-ATK5": DI(2723, 2728, 16, 40, 21, 45),
"XSK50ME H-BODY-ATK5": DI(2733, 2738, 16, 40, 21, 45),
"XSK50ME H-RARM-ATK5": DI(2743, 2748, 16, 40, 21, 45),
"XSK50ME H-LARM-ATK5": DI(2743, 2748, 16, 40, 21, 45),
"XSK50ME H-LEGS-ATK5": DI(2753, 2758, 16, 40, 21, 45),
"XSK60ME H-HEAD-ATK5": DI(2724, 2729, 17, 41, 22, 46),
"XSK60ME H-BODY-ATK5": DI(2734, 2739, 17, 41, 22, 46),
"XSK60ME H-RARM-ATK5": DI(2744, 2749, 17, 41, 22, 46),
"XSK60ME H-LARM-ATK5": DI(2744, 2749, 17, 41, 22, 46),
"XSK60ME H-LEGS-ATK5": DI(2754, 2759, 17, 41, 22, 46),
"Advanced Warrior Bliss": DI(501, 502, 1, 25, 2, 26),
"Worn Ophidian Bliss": DI(503, 504, 1, 25, 2, 26),
"Advanced Ophidian Bliss": DI(521, 522, 1, 25, 2, 26),
"Worn Destroyer Bliss": DI(523, 524, 1, 25, 2, 26),
"Advanced Destroyer Bliss": DI(525, 526, 1, 25, 2, 26),
"Worn Striker Bliss": DI(527, 528, 1, 25, 2, 26),
"Advanced Striker Bliss": DI(545, 546, 1, 25, 2, 26),
"Worn Delta Bliss": DI(547, 548, 1, 25, 2, 26),
"Cosmic Bliss": DI(549, 550, 1, 25, 2, 26),
"Nebulan Bliss": DI(551, 552, 1, 25, 2, 26),
"Signature Glaive: Four Virtues": DI(555, 556, 1, 25, 2, 26),
"Ethereal Glaive: Helldragon": DI(559, 560, 1, 25, 2, 26),
"Bewitched Glaive: Blood Dance": DI(571, 572, 1, 25, 2, 26),
"Signature Glaive: Allegiance": DI(573, 574, 1, 25, 2, 26),
"Mighty Glaive: Galaxy Chief": DI(575, 576, 1, 25, 2, 26),
"Bewitched Glaive: Receding Rust": DI(575, 576, 1, 25, 2, 26),
}