from typing import Any, TYPE_CHECKING

if TYPE_CHECKING:
    from . import DKC2World

def map_page_index(data: Any) -> int:
    mapping: dict[str, int] = {
        0x100: 0, # World Map
        0x101: 0, # Gangplank Galleon
        0x102: 0, # Crocodile Cauldron
        0x103: 0, # Krem Quay
        0x104: 0, # Krazy Kremland
        0x105: 0, # Gloomy Gulch
        0x106: 0, # K. Rool's Keep
        0x107: 0, # The Flying Krock
        0x108: 0, # Lost World
        0x109: 0, # Lost World
        0x10A: 0, # Lost World
        0x10B: 0, # Lost World
        0x10C: 0, # Lost World
        0x10D: 0, # Lost World
        0x10E: 0, # Lost World
        0x10F: 0, # Lost World
        0x001: 22, # Glimmer's Galleon
        0x002: 33, # Rambi Rumble
        0x003: 9,  # Pirate Panic
        0x004: 11, # Gangplank Galley
        0x005: 24, # Rattle Battle
        0x007: 15, # Hot-Head Hop
        0x008: 18, # Red-Hot Ride
        0x009: 14, # Krow's Nest
        0x00A: 25, # Slime Climb
        0x00B: 13, # Topsail Trouble
        0x00C: 10, # Mainbrace Mayhem
        0x00D: 40, # Kreepy Krow
        0x00E: 29, # Target Terror
        0x00F: 31, # Rickety Race
        0x010: 36, # Haunted Hall
        0x011: 28, # Hornet Hole
        0x013: 38, # Parrot Chute Panic
        0x014: 17, # Lava Lagoon
        0x015: 12, # Lockjaw's Locker
        0x016: 52, # Fiery Furnace
        0x017: 39, # Web Woods
        0x018: 37, # Gusty Glade
        0x019: 35, # Ghostly Grove
        0x021: 20, # Kleever's Kiln
        0x023: 42, # Windy Well
        0x024: 19, # Squawk's Shaft
        0x025: 16, # Kannon's Klaim
        0x028: 21, # Barrel Bayou
        0x029: 23, # Krockhead Klamber
        0x02C: 32, # Mudhole Marsh
        0x02D: 26, # Bramble Blast
        0x02E: 30, # Bramble Scramble
        0x02F: 48, # Screech's Sprint
        0x060: 34, # King Zing Sting
        0x062: 43, # Castle Crush
        0x063: 27, # Kudgel's Kontest
        0x06C: 41, # Arctic Abyss
        0x06D: 45, # Chain Link Chamber
        0x06E: 46, # Toxic Tower
        0x080: 51, # Klobber Karnage
        0x08F: 44, # Clapper's Cavern
        0x090: 54, # Animal Antics/Enguarde Section
        0x096: 50, # Black Ice Battle
        0x099: 49, # Jungle Jinx
        0x09A: 53, # Animal Antics/Rambi Section
        0x09B: 55, # Animal Antics/Squitter Section
        0x09C: 57, # Animal Antics/Rattly Section
        0x09F: 56, # Animal Antics/Squawks Section
        0x0B9: 47, # Stronghold Showdown
    }
    return mapping.get(data, 0)

map_locations = [
    "locations/world_map/World_Map.json",
    "locations/gangplank_galleon/Pirate_Panic.json",
    "locations/gangplank_galleon/Gangplank_Galley.json",
    "locations/gangplank_galleon/Mainbrace_Mayhem.json",
    "locations/gangplank_galleon/Topsail_Trouble.json",
    "locations/gangplank_galleon/Krows_Nest.json",
    "locations/crocodile_cauldron/Hot-Head_Hop.json",
    "locations/crocodile_cauldron/Kannons_Klaim.json",
    "locations/crocodile_cauldron/Kleevers_Kiln.json",
    "locations/crocodile_cauldron/Lava_Lagoon.json",
    "locations/crocodile_cauldron/Red-Hot_Ride.json",
    "locations/crocodile_cauldron/Squawkss_Shaft.json",
    "locations/krem_quay/Slime_Climb.json",
    "locations/krem_quay/Rattle_Battle.json",
    "locations/krem_quay/Kudgels_Kontest.json",
    "locations/krem_quay/Krockhead_Klamber.json",
    "locations/krem_quay/Glimmers_Galleon.json",
    "locations/krem_quay/Bramble_Blast.json",
    "locations/krem_quay/Barrel_Bayou.json",
    "locations/krazy_kremland/Target_Terror.json",
    "locations/krazy_kremland/Rickety_Race.json",
    "locations/krazy_kremland/Rambi_Rumble.json",
    "locations/krazy_kremland/Mudhole_Marsh.json",
    "locations/krazy_kremland/King_Zing_Sting.json",
    "locations/krazy_kremland/Hornet_Hole.json",
    "locations/krazy_kremland/Bramble_Scramble.json",
    "locations/gloomy_gulch/Web_Woods.json",
    "locations/gloomy_gulch/Parrot_Chute_Panic.json",
    "locations/gloomy_gulch/Kreepy_Krow.json",
    "locations/gloomy_gulch/Haunted_Hall.json",
    "locations/gloomy_gulch/Gusty_Glade.json",
    "locations/gloomy_gulch/Ghostly_Grove.json",
    "locations/krools_keep/Windy_Well.json",
    "locations/krools_keep/Toxic_Tower.json",
    "locations/krools_keep/Stronghold_Showdown.json",
    "locations/krools_keep/Clappers_Cavern.json",
    "locations/krools_keep/Chain_Link_Chamber.json",
    "locations/krools_keep/Castle_Crush.json",
    "locations/krools_keep/Arctic_Abyss.json",
    "locations/the_flying_krock/Screechs_Sprint.json",
    "locations/lost_world/Klobber_Karnage.json",
    "locations/lost_world/Jungle_Jinx.json",
    "locations/lost_world/Fiery_Furnace.json",
    "locations/lost_world/Black_Ice_Battle.json",
    "locations/lost_world/Animal_Antics.json",
    "locations/swanky/swankykroolkeep.json",
    "locations/swanky/swankykremquay.json",
    "locations/swanky/swankykrazykremland.json",
    "locations/swanky/swankygloomygulch.json",
    "locations/swanky/swankygangplank.json",
    "locations/swanky/swankycauldron.json",
]

poptracker_data = {
    "Pirate Panic/Clear": 12517376,
    "Pirate Panic - Clear/Clear": 12517376,
    "Mainbrace Mayhem/Clear": 12517377,
    "Mainbrace Mayhem - Clear/Clear": 12517377,
    "Gangplank Galley/Clear": 12517378,
    "Gangplank Galley - Clear/Clear": 12517378,
    "Lockjaw's Locker/Clear": 12517379,
    "Lockjaw's Locker - Clear/Clear": 12517379,
    "Topsail Trouble/Clear": 12517380,
    "Topsail Trouble - Clear/Clear": 12517380,
    "Krow's Nest/Clear": 12517381,
    "Krow's Nest - Boss/Clear": 12517381,
    "Hot-Head Hop/Clear": 12517382,
    "Hot-Head Hop - Clear/Clear": 12517382,
    "Kannon's Klaim/Clear": 12517383,
    "Kannon's Klaim - Clear/Clear": 12517383,
    "Lava Lagoon/Clear": 12517384,
    "Lava Lagoon - Clear/Clear": 12517384,
    "Red-Hot Ride/Clear": 12517385,
    "Red-Hot Ride - Clear/Clear": 12517385,
    "Squawks's Shaft/Clear": 12517386,
    "Squawks's Shaft - Clear/Clear": 12517386,
    "Kleever's Kiln/Clear": 12517387,
    "Kleever's Kiln - Boss/Clear": 12517387,
    "Barrel Bayou/Clear": 12517388,
    "Barrel Bayou - Clear/Clear": 12517388,
    "Glimmer's Galleon/Clear": 12517389,
    "Glimmer's Galleon - Clear/Clear": 12517389,
    "Krockhead Klamber/Clear": 12517390,
    "Krockhead Klamber - Clear/Clear": 12517390,
    "Rattle Battle/Clear": 12517391,
    "Rattle Battle - Clear/Clear": 12517391,
    "Slime Climb/Clear": 12517392,
    "Slime Climb - Clear/Clear": 12517392,
    "Bramble Blast/Clear": 12517393,
    "Bramble Blast - Clear/Clear": 12517393,
    "Kudgel's Kontest/Clear": 12517394,
    "Kudgel's Kontest/Clear": 12517394,
    "Hornet Hole/Clear": 12517395,
    "Hornet Hole - Clear/Clear": 12517395,
    "Target Terror/Clear": 12517396,
    "Target Terror - Clear/Clear": 12517396,
    "Bramble Scramble/Clear": 12517397,
    "Bramble Scramble - Clear/Clear": 12517397,
    "Rickety Race/Clear": 12517398,
    "Rickety Race - Clear/Clear": 12517398,
    "Mudhole Marsh/Clear": 12517399,
    "Mudhole Marsh - Clear/Clear": 12517399,
    "Rambi Rumble/Clear": 12517400,
    "Rambi Rumble - Clear/Clear": 12517400,
    "King Zing Sting/Clear": 12517401,
    "King Zing Sting - Boss/Clear": 12517401,
    "Ghostly Grove/Clear": 12517402,
    "Ghostly Grove - Clear/Clear": 12517402,
    "Haunted Hall/Clear": 12517403,
    "Haunted Hall - Clear/Clear": 12517403,
    "Gusty Glade/Clear": 12517404,
    "Gusty Glade - Clear/Clear": 12517404,
    "Parrot Chute Panic/Clear": 12517405,
    "Parrot Chute Panic - Clear/Clear": 12517405,
    "Web Woods/Clear": 12517407,
    "Web Woods - Clear/Clear": 12517407,
    "Kreepy Krow/Clear": 12517408,
    "Kreepy Krow - Boss/Clear": 12517408,
    "Arctic Abyss/Clear": 12517409,
    "Arctic Abyss - Clear/Clear": 12517409,
    "Windy Well/Clear": 12517410,
    "Windy Well - Clear/Clear": 12517410,
    "Castle Crush/Clear": 12517411,
    "Castle Crush - Clear/Clear": 12517411,
    "Clapper's Cavern/Clear": 12517412,
    "Clapper's Cavern - Clear/Clear": 12517412,
    "Chain Link Chamber/Clear": 12517413,
    "Chain Link Chamber - Clear/Clear": 12517413,
    "Toxic Tower/Clear": 12517414,
    "Toxic Tower - Clear/Clear": 12517414,
    "Stronghold Showdown/Clear": 12517415,
    "Stronghold Showdown - Clear/Clear": 12517415,
    "Screech's Sprint/Clear": 12517416,
    "Screech's Sprint - Clear/Clear": 12517416,
    "Jungle Jinx/Clear": 12517418,
    "Jungle Jinx - Clear/Clear": 12517418,
    "Black Ice Battle/Clear": 12517419,
    "Black Ice Battle - Clear/Clear": 12517419,
    "Klobber Karnage/Clear": 12517420,
    "Klobber Karnage - Clear/Clear": 12517420,
    "Fiery Furnace/Clear": 12517421,
    "Fiery Furnace - Clear/Clear": 12517421,
    "Animal Antics/Clear": 12517422,
    "Animal Antics - Clear/Clear": 12517422,
    "Krow's Nest/Defeat": 12517424,
    "Krow's Nest - Boss/Defeat": 12517424,
    "Kleever's Kiln/Defeat": 12517425,
    "Kleever's Kiln - Boss/Defeat": 12517425,
    "Kudgel's Kontest/Defeat": 12517426,
    "Kudgel's Kontest/Defeat": 12517426,
    "King Zing Sting/Defeat": 12517427,
    "King Zing Sting - Boss/Defeat": 12517427,
    "Kreepy Krow/Defeat": 12517428,
    "Kreepy Krow - Boss/Defeat": 12517428,
    "Pirate Panic/DK Coin": 12517504,
    "Pirate Panic - DK Coin/DK Coin": 12517504,
    "Mainbrace Mayhem/DK Coin": 12517505,
    "Mainbrace Mayhem - DK Coin/DK Coin": 12517505,
    "Gangplank Galley/DK Coin": 12517506,
    "Gangplank Galley - DK Coin/DK Coin": 12517506,
    "Lockjaw's Locker/DK Coin": 12517507,
    "Lockjaw's Locker - DK Coin/DK Coin": 12517507,
    "Topsail Trouble/DK Coin": 12517508,
    "Topsail Trouble - DK Coin/DK Coin": 12517508,
    "Hot-Head Hop/DK Coin": 12517509,
    "Hot-Head Hop - DK Coin/DK Coin": 12517509,
    "Kannon's Klaim/DK Coin": 12517510,
    "Kannon's Klaim - Bonus #1/DK Coin": 12517510,
    "Lava Lagoon/DK Coin": 12517511,
    "Lava Lagoon - DK Coin/DK Coin": 12517511,
    "Red-Hot Ride/DK Coin": 12517512,
    "Red-Hot Ride - DK Coin/DK Coin": 12517512,
    "Squawks's Shaft/DK Coin": 12517513,
    "Squawks's Shaft - DK Coin/DK Coin": 12517513,
    "Barrel Bayou/DK Coin": 12517514,
    "Barrel Bayou - DK Coin/DK Coin": 12517514,
    "Glimmer's Galleon/DK Coin": 12517515,
    "Glimmer's Galleon - DK Coin/DK Coin": 12517515,
    "Krockhead Klamber/DK Coin": 12517516,
    "Krockhead Klamber - DK Coin/DK Coin": 12517516,
    "Rattle Battle/DK Coin": 12517517,
    "Rattle Battle - DK Coin/DK Coin": 12517517,
    "Slime Climb/DK Coin": 12517518,
    "Slime Climb - DK Coin/DK Coin": 12517518,
    "Bramble Blast/DK Coin": 12517519,
    "Bramble Blast - DK Coin/DK Coin": 12517519,
    "Hornet Hole/DK Coin": 12517520,
    "Hornet Hole - DK Coin/DK Coin": 12517520,
    "Target Terror/DK Coin": 12517521,
    "Target Terror - DK Coin/DK Coin": 12517521,
    "Bramble Scramble/DK Coin": 12517522,
    "Bramble Scramble - DK Coin/DK Coin": 12517522,
    "Rickety Race/DK Coin": 12517523,
    "Rickety Race - DK Coin/DK Coin": 12517523,
    "Mudhole Marsh/DK Coin": 12517524,
    "Mudhole Marsh - DK Coin/DK Coin": 12517524,
    "Rambi Rumble/DK Coin": 12517525,
    "Rambi Rumble - DK Coin/DK Coin": 12517525,
    "Ghostly Grove/DK Coin": 12517526,
    "Ghostly Grove - DK Coin/DK Coin": 12517526,
    "Haunted Hall/DK Coin": 12517527,
    "Haunted Hall - DK Coin/DK Coin": 12517527,
    "Gusty Glade/DK Coin": 12517528,
    "Gusty Glade - DK Coin/DK Coin": 12517528,
    "Parrot Chute Panic/DK Coin": 12517529,
    "Parrot Chute Panic - DK Coin/DK Coin": 12517529,
    "Web Woods/DK Coin": 12517530,
    "Web Woods - DK Coin/DK Coin": 12517530,
    "Arctic Abyss/DK Coin": 12517531,
    "Arctic Abyss - DK Coin/DK Coin": 12517531,
    "Windy Well/DK Coin": 12517532,
    "Windy Well - DK Coin/DK Coin": 12517532,
    "Castle Crush/DK Coin": 12517533,
    "Castle Crush - DK Coin/DK Coin": 12517533,
    "Clapper's Cavern/DK Coin": 12517534,
    "Clapper's Cavern - DK Coin/DK Coin": 12517534,
    "Chain Link Chamber/DK Coin": 12517535,
    "Chain Link Chamber - DK Coin/DK Coin": 12517535,
    "Toxic Tower/DK Coin": 12517536,
    "Toxic Tower - DK Coin/DK Coin": 12517536,
    "Screech's Sprint/DK Coin": 12517537,
    "Screech's Sprint - DK Coin/DK Coin": 12517537,
    "Jungle Jinx/DK Coin": 12517538,
    "Jungle Jinx - DK Coin/DK Coin": 12517538,
    "Black Ice Battle/DK Coin": 12517539,
    "Black Ice Battle - DK Coin/DK Coin": 12517539,
    "Klobber Karnage/DK Coin": 12517540,
    "Klobber Karnage - DK Coin/DK Coin": 12517540,
    "Fiery Furnace/DK Coin": 12517541,
    "Fiery Furnace - DK Coin/DK Coin": 12517541,
    "Animal Antics/DK Coin": 12517542,
    "Animal Antics - DK Coin/DK Coin": 12517542,
    "Pirate Panic/KONG": 12517440,
    "Pirate Panic - KONG/KONG": 12517440,
    "Mainbrace Mayhem/KONG": 12517441,
    "Mainbrace Mayhem - KONG/KONG": 12517441,
    "Gangplank Galley/KONG": 12517442,
    "Gangplank Galley - KONG/KONG": 12517442,
    "Lockjaw's Locker/KONG": 12517443,
    "Lockjaw's Locker - KONG/KONG": 12517443,
    "Topsail Trouble/KONG": 12517444,
    "Topsail Trouble - KONG/KONG": 12517444,
    "Hot-Head Hop/KONG": 12517445,
    "Hot-Head Hop - KONG/KONG": 12517445,
    "Kannon's Klaim/KONG": 12517446,
    "Kannon's Klaim - KONG/KONG": 12517446,
    "Lava Lagoon/KONG": 12517447,
    "Lava Lagoon - KONG/KONG": 12517447,
    "Red-Hot Ride/KONG": 12517448,
    "Red-Hot Ride - KONG/KONG": 12517448,
    "Squawks's Shaft/KONG": 12517449,
    "Squawks's Shaft - KONG/KONG": 12517449,
    "Barrel Bayou/KONG": 12517450,
    "Barrel Bayou - KONG/KONG": 12517450,
    "Glimmer's Galleon/KONG": 12517451,
    "Glimmer's Galleon - KONG/KONG": 12517451,
    "Krockhead Klamber/KONG": 12517452,
    "Krockhead Klamber - KONG/KONG": 12517452,
    "Rattle Battle/KONG": 12517453,
    "Rattle Battle - KONG/KONG": 12517453,
    "Slime Climb/KONG": 12517454,
    "Slime Climb - KONG/KONG": 12517454,
    "Bramble Blast/KONG": 12517455,
    "Bramble Blast - KONG/KONG": 12517455,
    "Hornet Hole/KONG": 12517456,
    "Hornet Hole - KONG/KONG": 12517456,
    "Target Terror/KONG": 12517457,
    "Target Terror - KONG/KONG": 12517457,
    "Bramble Scramble/KONG": 12517458,
    "Bramble Scramble - KONG/KONG": 12517458,
    "Rickety Race/KONG": 12517459,
    "Rickety Race - KONG/KONG": 12517459,
    "Mudhole Marsh/KONG": 12517460,
    "Mudhole Marsh - KONG/KONG": 12517460,
    "Rambi Rumble/KONG": 12517461,
    "Rambi Rumble - KONG/KONG": 12517461,
    "Ghostly Grove/KONG": 12517462,
    "Ghostly Grove - KONG/KONG": 12517462,
    "Haunted Hall/KONG": 12517463,
    "Haunted Hall - KONG/KONG": 12517463,
    "Gusty Glade/KONG": 12517464,
    "Gusty Glade - KONG/KONG": 12517464,
    "Parrot Chute Panic/KONG": 12517465,
    "Parrot Chute Panic - KONG/KONG": 12517465,
    "Web Woods/KONG": 12517466,
    "Web Woods - KONG/KONG": 12517466,
    "Arctic Abyss/KONG": 12517467,
    "Arctic Abyss - KONG/KONG": 12517467,
    "Windy Well/KONG": 12517468,
    "Windy Well - KONG/KONG": 12517468,
    "Castle Crush/KONG": 12517469,
    "Castle Crush - KONG/KONG": 12517469,
    "Clapper's Cavern/KONG": 12517470,
    "Clapper's Cavern - KONG/KONG": 12517470,
    "Chain Link Chamber/KONG": 12517471,
    "Chain Link Chamber - KONG/KONG": 12517471,
    "Toxic Tower/KONG": 12517472,
    "Toxic Tower - KONG/KONG": 12517472,
    "Screech's Sprint/KONG": 12517473,
    "Screech's Sprint - KONG/KONG": 12517473,
    "Jungle Jinx/KONG": 12517474,
    "Jungle Jinx - KONG/KONG": 12517474,
    "Black Ice Battle/KONG": 12517475,
    "Black Ice Battle - KONG/KONG": 12517475,
    "Klobber Karnage/KONG": 12517476,
    "Klobber Karnage - KONG/KONG": 12517476,
    "Fiery Furnace/KONG": 12517477,
    "Fiery Furnace - KONG/KONG": 12517477,
    "Animal Antics/KONG": 12517478,
    "Animal Antics - KONG/KONG": 12517478,
    "Pirate Panic/Bonus #1": 12517568,
    "Pirate Panic - Bonus #1/Bonus #1": 12517568,
    "Pirate Panic/Bonus #2": 12517569,
    "Pirate Panic - Bonus #2/Bonus #2": 12517569,
    "Mainbrace Mayhem/Bonus #1": 12517570,
    "Mainbrace Mayhem - Bonus #1/Bonus #1": 12517570,
    "Mainbrace Mayhem/Bonus #2": 12517571,
    "Mainbrace Mayhem - Bonus #2/Bonus #2": 12517571,
    "Mainbrace Mayhem/Bonus #3": 12517572,
    "Mainbrace Mayhem - Bonus #3/Bonus #3": 12517572,
    "Gangplank Galley/Bonus #1": 12517573,
    "Gangplank Galley - Bonus #1/Bonus #1": 12517573,
    "Gangplank Galley/Bonus #2": 12517574,
    "Gangplank Galley - Bonus #2/Bonus #2": 12517574,
    "Lockjaw's Locker/Bonus #1": 12517575,
    "Lockjaw's Locker - Bonus #1/Bonus #1": 12517575,
    "Topsail Trouble/Bonus #1": 12517576,
    "Topsail Trouble - Bonus #1/Bonus #1": 12517576,
    "Topsail Trouble/Bonus #2": 12517577,
    "Topsail Trouble - Bonus #2/Bonus #2": 12517577,
    "Hot-Head Hop/Bonus #1": 12517578,
    "Hot-Head Hop - Bonus #1/Bonus #1": 12517578,
    "Hot-Head Hop/Bonus #2": 12517579,
    "Hot-Head Hop - Bonus #2/Bonus #2": 12517579,
    "Hot-Head Hop/Bonus #3": 12517580,
    "Hot-Head Hop - Bonus #3/Bonus #3": 12517580,
    "Kannon's Klaim/Bonus #1": 12517581,
    "Kannon's Klaim - Bonus #1/Bonus #1": 12517581,
    "Kannon's Klaim/Bonus #2": 12517582,
    "Kannon's Klaim - Bonus #2/Bonus #2": 12517582,
    "Kannon's Klaim/Bonus #3": 12517583,
    "Kannon's Klaim - Bonus #3/Bonus #3": 12517583,
    "Lava Lagoon/Bonus #1": 12517584,
    "Lava Lagoon - Bonus #1/Bonus #1": 12517584,
    "Red-Hot Ride/Bonus #1": 12517585,
    "Red-Hot Ride - Bonus #1/Bonus #1": 12517585,
    "Red-Hot Ride/Bonus #2": 12517586,
    "Red-Hot Ride - Bonus #2/Bonus #2": 12517586,
    "Squawks's Shaft/Bonus #1": 12517587,
    "Squawks's Shaft - Bonus #1/Bonus #1": 12517587,
    "Squawks's Shaft/Bonus #2": 12517588,
    "Squawks's Shaft - Bonus #2/Bonus #2": 12517588,
    "Squawks's Shaft/Bonus #3": 12517589,
    "Squawks's Shaft - Bonus #3/Bonus #3": 12517589,
    "Barrel Bayou/Bonus #1": 12517590,
    "Barrel Bayou - Bonus #1/Bonus #1": 12517590,
    "Barrel Bayou/Bonus #2": 12517591,
    "Barrel Bayou - Bonus #2/Bonus #2": 12517591,
    "Glimmer's Galleon/Bonus #1": 12517592,
    "Glimmer's Galleon - Bonus #1/Bonus #1": 12517592,
    "Glimmer's Galleon/Bonus #2": 12517593,
    "Glimmer's Galleon - Bonus #2/Bonus #2": 12517593,
    "Krockhead Klamber/Bonus #1": 12517594,
    "Krockhead Klamber - Bonus #1/Bonus #1": 12517594,
    "Rattle Battle/Bonus #1": 12517595,
    "Rattle Battle - Bonus #1/Bonus #1": 12517595,
    "Rattle Battle/Bonus #2": 12517596,
    "Rattle Battle - Bonus #2/Bonus #2": 12517596,
    "Rattle Battle/Bonus #3": 12517597,
    "Rattle Battle - Bonus #3/Bonus #3": 12517597,
    "Slime Climb/Bonus #1": 12517598,
    "Slime Climb - Bonus #1/Bonus #1": 12517598,
    "Slime Climb/Bonus #2": 12517599,
    "Slime Climb - Bonus #2/Bonus #2": 12517599,
    "Bramble Blast/Bonus #1": 12517600,
    "Bramble Blast - Bonus #1/Bonus #1": 12517600,
    "Bramble Blast/Bonus #2": 12517601,
    "Bramble Blast - Bonus #2/Bonus #2": 12517601,
    "Hornet Hole/Bonus #1": 12517602,
    "Hornet Hole - Bonus #1/Bonus #1": 12517602,
    "Hornet Hole/Bonus #2": 12517603,
    "Hornet Hole - Bonus #2/Bonus #2": 12517603,
    "Hornet Hole/Bonus #3": 12517604,
    "Hornet Hole - Bonus #3/Bonus #3": 12517604,
    "Target Terror/Bonus #1": 12517605,
    "Target Terror - Bonus #1/Bonus #1": 12517605,
    "Target Terror/Bonus #2": 12517606,
    "Target Terror - Bonus #2/Bonus #2": 12517606,
    "Bramble Scramble/Bonus #1": 12517607,
    "Bramble Scramble - Bonus #1/Bonus #1": 12517607,
    "Rickety Race/Bonus #1": 12517608,
    "Rickety Race - Bonus #1/Bonus #1": 12517608,
    "Mudhole Marsh/Bonus #1": 12517609,
    "Mudhole Marsh - Bonus #1/Bonus #1": 12517609,
    "Mudhole Marsh/Bonus #2": 12517610,
    "Mudhole Marsh - Bonus #2/Bonus #2": 12517610,
    "Rambi Rumble/Bonus #1": 12517611,
    "Rambi Rumble - Bonus #1/Bonus #1": 12517611,
    "Rambi Rumble/Bonus #2": 12517612,
    "Rambi Rumble - Bonus #2/Bonus #2": 12517612,
    "Ghostly Grove/Bonus #1": 12517613,
    "Ghostly Grove - Bonus #1/Bonus #1": 12517613,
    "Ghostly Grove/Bonus #2": 12517614,
    "Ghostly Grove - Bonus #2/Bonus #2": 12517614,
    "Haunted Hall/Bonus #1": 12517615,
    "Haunted Hall - Bonus #1/Bonus #1": 12517615,
    "Haunted Hall/Bonus #2": 12517616,
    "Haunted Hall - Bonus #2/Bonus #2": 12517616,
    "Haunted Hall/Bonus #3": 12517617,
    "Haunted Hall - Bonus #3/Bonus #3": 12517617,
    "Gusty Glade/Bonus #1": 12517618,
    "Gusty Glade - Bonus #1/Bonus #1": 12517618,
    "Gusty Glade/Bonus #2": 12517619,
    "Gusty Glade - Bonus #2/Bonus #2": 12517619,
    "Parrot Chute Panic/Bonus #1": 12517620,
    "Parrot Chute Panic - Bonus #1/Bonus #1": 12517620,
    "Parrot Chute Panic/Bonus #2": 12517621,
    "Parrot Chute Panic - Bonus #2/Bonus #2": 12517621,
    "Web Woods/Bonus #1": 12517622,
    "Web Woods - Bonus #1/Bonus #1": 12517622,
    "Web Woods/Bonus #2": 12517623,
    "Web Woods - Bonus #2/Bonus #2": 12517623,
    "Arctic Abyss/Bonus #1": 12517624,
    "Arctic Abyss - Bonus #1/Bonus #1": 12517624,
    "Arctic Abyss/Bonus #2": 12517625,
    "Arctic Abyss - Bonus #2/Bonus #2": 12517625,
    "Windy Well/Bonus #1": 12517626,
    "Windy Well - Bonus #1/Bonus #1": 12517626,
    "Windy Well/Bonus #2": 12517627,
    "Windy Well - Bonus #2/Bonus #2": 12517627,
    "Castle Crush/Bonus #1": 12517628,
    "Castle Crush - Bonus #1/Bonus #1": 12517628,
    "Castle Crush/Bonus #2": 12517629,
    "Castle Crush - Bonus #2/Bonus #2": 12517629,
    "Clapper's Cavern/Bonus #1": 12517630,
    "Clapper's Cavern - Bonus #1/Bonus #1": 12517630,
    "Clapper's Cavern/Bonus #2": 12517631,
    "Clapper's Cavern - Bonus #2/Bonus #2": 12517631,
    "Chain Link Chamber/Bonus #1": 12517632,
    "Chain Link Chamber - Bonus #1/Bonus #1": 12517632,
    "Chain Link Chamber/Bonus #2": 12517633,
    "Chain Link Chamber - Bonus #2/Bonus #2": 12517633,
    "Toxic Tower/Bonus #1": 12517634,
    "Toxic Tower - Bonus #1/Bonus #1": 12517634,
    "Screech's Sprint/Bonus #1": 12517635,
    "Screech's Sprint - Bonus #1/Bonus #1": 12517635,
    "Swanky at Gangplank Galleon/Easy": 12517696,
    "Swanky at Gangplank Galleon/Medium": 12517697,
    "Swanky at Gangplank Galleon/Hard": 12517698,
    "Swanky at Crocodile Cauldron/Easy": 12517699,
    "Swanky at Crocodile Cauldron/Medium": 12517700,
    "Swanky at Crocodile Cauldron/Hard": 12517701,
    "Swanky at Krem Quay/Easy": 12517702,
    "Swanky at Krem Quay/Medium": 12517703,
    "Swanky at Krem Quay/Hard": 12517704,
    "Swanky at Krazy Kremland/Easy": 12517705,
    "Swanky at Krazy Kremland/Medium": 12517706,
    "Swanky at Krazy Kremland/Hard": 12517707,
    "Swanky at Gloomy Gulch/Easy": 12517708,
    "Swanky at Gloomy Gulch/Medium": 12517709,
    "Swanky at Gloomy Gulch/Hard": 12517710,
    "Swanky at K. Rool's Keep/Easy": 12517711,
    "Swanky at K. Rool's Keep/Medium": 12517712,
    "Swanky at K. Rool's Keep/Hard": 12517713,
    "Pirate Panic/Red Balloon (Kabin)": 12518400,
    "Pirate Panic - Red Balloon/Red Balloon (Kabin)": 12518400,
    "Pirate Panic/Green Balloon (Rambi sign)": 12518401,
    "Pirate Panic - Green Balloon/Green Balloon (Rambi sign)": 12518401,
    "Mainbrace Mayhem/Green Balloon (Above banana trail on rope)": 12518402,
    "Mainbrace Mayhem - Green Balloon/Green Balloon (Above banana trail on rope)": 12518402,
    "Gangplank Galley/Red Balloon #1 (Chest before Neek)": 12518403,
    "Gangplank Galley - Red Balloon #1/Red Balloon #1 (Chest before Neek)": 12518403,
    "Gangplank Galley/Red Balloon #2 (Chest on barrel between Krunchas)": 12518404,
    "Gangplank Galley - Red Balloon #2/Red Balloon #2 (Chest on barrel between Krunchas)": 12518404,
    "Lockjaw's Locker/Red Balloon (Enguarde sign #1)": 12518405,
    "Lockjaw's Locker - Red Balloon/Red Balloon (Enguarde sign #1)": 12518405,
    "Topsail Trouble/Red Balloon #1 (Near first DK Barrel)": 12518406,
    "Topsail Trouble - Red Balloon #1/Red Balloon #1 (Near first DK Barrel)": 12518406,
    "Topsail Trouble/Red Balloon #2 (Chest after O)": 12518407,
    "Topsail Trouble - Red Balloon #2/Red Balloon #2 (Chest after O)": 12518407,
    "Topsail Trouble/Blue Balloon (After goal)": 12518408,
    "Topsail Trouble - Blue Balloon/Blue Balloon (After goal)": 12518408,
    "Hot-Head Hop/Green Balloon (Chest above start)": 12518409,
    "Hot-Head Hop - Green Balloon/Green Balloon (Chest above start)": 12518409,
    "Hot-Head Hop/Red Balloon (Squitter sign)": 12518410,
    "Hot-Head Hop - Red Balloon/Red Balloon (Squitter sign)": 12518410,
    "Lava Lagoon/Red Balloon #1 (Enguarde sign)": 12518411,
    "Lava Lagoon - Red Balloon #1/Red Balloon #1 (Enguarde sign)": 12518411,
    "Squawks's Shaft/Red Balloon #1 (Chest behind Krook)": 12518412,
    "Squawks's Shaft - Red Balloon #1/Red Balloon #1 (Chest behind Krook)": 12518412,
    "Barrel Bayou/Green Balloon (Chest from Kloak behind N)": 12518413,
    "Barrel Bayou - Green Balloon/Green Balloon (Chest from Kloak behind N)": 12518413,
    "Glimmer's Galleon/Red Balloon (Alone banana above Glimmer spawn)": 12518414,
    "Glimmer's Galleon - Red Balloon/Red Balloon (Alone banana above Glimmer spawn)": 12518414,
    "Krockhead Klamber/Red Balloon #1 (Chest behind start)": 12518415,
    "Krockhead Klamber - Red Balloon #1/Red Balloon #1 (Chest behind start)": 12518415,
    "Krockhead Klamber/Red Balloon #2 (Squitter sign)": 12518416,
    "Krockhead Klamber - Red Balloon #2/Red Balloon #2 (Squitter sign)": 12518416,
    "Bramble Blast/Red Balloon (After N)": 12518417,
    "Bramble Blast - Red Balloon/Red Balloon (After N)": 12518417,
    "Hornet Hole/Green Balloon (Chest after K)": 12518418,
    "Hornet Hole - Green Balloon/Green Balloon (Chest after K)": 12518418,
    "Hornet Hole/Red Balloon (Squitter sign)": 12518419,
    "Hornet Hole - Red Balloon/Red Balloon (Squitter sign)": 12518419,
    "Target Terror/Red Balloon (Above last X barrel)": 12518420,
    "Target Terror - Red Balloon/Red Balloon (Above last X barrel)": 12518420,
    "Bramble Scramble/Blue Balloon (Near DK Coin)": 12518421,
    "Bramble Scramble - Blue Balloon/Blue Balloon (Near DK Coin)": 12518421,
    "Bramble Scramble/Red Balloon (Squitter sign)": 12518422,
    "Bramble Scramble - Red Balloon/Red Balloon (Squitter sign)": 12518422,
    "Ghostly Grove/Red Balloon (Kloak at start)": 12518423,
    "Ghostly Grove - First Kloak/Red Balloon (Kloak at start)": 12518423,
    "Gusty Glade/Blue Balloon (Rattly sign)": 12518424,
    "Gusty Glade - Blue Balloon/Blue Balloon (Rattly sign)": 12518424,
    "Web Woods/Green Balloon #1 (Chest below Zinger)": 12518425,
    "Web Woods - Green Balloon #1/Green Balloon #1 (Chest below Zinger)": 12518425,
    "Web Woods/Green Balloon #2 (After goal)": 12518426,
    "Web Woods - Green Balloon #2/Green Balloon #2 (After goal)": 12518426,
    "Arctic Abyss/Red Balloon #2 (Enguarde sign)": 12518427,
    "Arctic Abyss - Red Balloon #2/Red Balloon #2 (Enguarde sign)": 12518427,
    "Arctic Abyss/Red Balloon #1 (After exploding Puftup trio)": 12518428,
    "Arctic Abyss - Red Balloon #1/Red Balloon #1 (After exploding Puftup trio)": 12518428,
    "Windy Well/Red Balloon (Before N)": 12518429,
    "Windy Well - Red Balloon/Red Balloon (Before N)": 12518429,
    "Toxic Tower/Green Balloon (Below goal)": 12518430,
    "Toxic Tower - Green Balloon/Green Balloon (Below goal)": 12518430,
    "Stronghold Showdown/Red Balloon (Above start)": 12518431,
    "Stronghold Showdown - Red Balloon/Red Balloon (Above start)": 12518431,
    "Screech's Sprint/Red Balloon (Before midpoint)": 12518432,
    "Screech's Sprint - Red Balloon/Red Balloon (Before midpoint)": 12518432,
    "Black Ice Battle/Red Balloon #1 (Above Klobber)": 12518433,
    "Black Ice Battle - Red Balloon #1/Red Balloon #1 (Above Klobber)": 12518433,
    "Black Ice Battle/Red Balloon #2 (Above Klobber)": 12518434,
    "Black Ice Battle - Red Balloon #2/Red Balloon #2 (Above Klobber)": 12518434,
    "Black Ice Battle/Red Balloon #3 (Chest behind Klobber)": 12518435,
    "Black Ice Battle - Red Balloon #3/Red Balloon #3 (Chest behind Klobber)": 12518435,
    "Klobber Karnage/Red Balloon (After long barrel section)": 12518436,
    "Klobber Karnage - Red Balloon/Red Balloon (After long barrel section)": 12518436,
    "Animal Antics/Red Balloon (Corner before Rattly barrel)": 12518437,
    "Animal Antics - Red Balloon/Red Balloon (Corner before Rattly barrel)": 12518437,
    "Pirate Panic/Banana Coin #1 (Above start banana trail)": 12517888,
    "Pirate Panic - Banana Coin #1/Banana Coin #1 (Above start banana trail)": 12517888,
    "Pirate Panic/Banana Coin #2 (Team Attack bananas)": 12517889,
    "Pirate Panic - Banana Coin #2/Banana Coin #2 (Team Attack bananas)": 12517889,
    "Pirate Panic/Banana Coin #3 (Inside Bonus #1)": 12517890,
    "Pirate Panic - Bonus #1/Banana Coin #3 (Inside Bonus #1)": 12517890,
    "Mainbrace Mayhem/Banana Coin #1 (Next to Klinger)": 12517891,
    "Mainbrace Mayhem - Banana Coin #1/Banana Coin #1 (Next to Klinger)": 12517891,
    "Mainbrace Mayhem/Banana Coin #2 (Below Click-Clack)": 12517892,
    "Mainbrace Mayhem - Banana Coin #2/Banana Coin #2 (Below Click-Clack)": 12517892,
    "Mainbrace Mayhem/Banana Coin #3 (After Bonus #3)": 12517893,
    "Mainbrace Mayhem - Banana Coin #3/Banana Coin #3 (After Bonus #3)": 12517893,
    "Gangplank Galley/Banana Coin #1 (Chest before midpoint)": 12517894,
    "Gangplank Galley - Banana Coin #1/Banana Coin #1 (Chest before midpoint)": 12517894,
    "Gangplank Galley/Banana Coin #2 (Below Kruncha trio)": 12517895,
    "Gangplank Galley - Banana Coin #2/Banana Coin #2 (Below Kruncha trio)": 12517895,
    "Lockjaw's Locker/Banana Coin #1 (Right on start)": 12517896,
    "Lockjaw's Locker - Banana Coin #1/Banana Coin #1 (Right on start)": 12517896,
    "Lockjaw's Locker/Banana Coin #2 (Right on start)": 12517897,
    "Lockjaw's Locker - Banana Coin #2/Banana Coin #2 (Right on start)": 12517897,
    "Lockjaw's Locker/Banana Coin #3 (Above Banana Bunch)": 12517898,
    "Lockjaw's Locker - Banana Coin #3/Banana Coin #3 (Above Banana Bunch)": 12517898,
    "Lockjaw's Locker/Banana Coin #4 (Passage below Flotsam)": 12517899,
    "Lockjaw's Locker - Banana Coin #4/Banana Coin #4 (Passage below Flotsam)": 12517899,
    "Lockjaw's Locker/Banana Coin #5 (Passage below Flotsam)": 12517900,
    "Lockjaw's Locker - Banana Coin #5/Banana Coin #5 (Passage below Flotsam)": 12517900,
    "Lockjaw's Locker/Banana Coin #6 (Behind Lockjaw near Enguarde)": 12517901,
    "Lockjaw's Locker - Banana Coin #6/Banana Coin #6 (Behind Lockjaw near Enguarde)": 12517901,
    "Lockjaw's Locker/Banana Coin #7 (Behind Lockjaw near Enguarde)": 12517902,
    "Lockjaw's Locker - Banana Coin #7/Banana Coin #7 (Behind Lockjaw near Enguarde)": 12517902,
    "Lockjaw's Locker/Banana Coin #8 (Behind Lockjaw near DK Barrel)": 12517903,
    "Lockjaw's Locker - Banana Coin #8/Banana Coin #8 (Behind Lockjaw near DK Barrel)": 12517903,
    "Topsail Trouble/Banana Coin #1 (Before Rattly sign)": 12517904,
    "Topsail Trouble - Banana Coin #1/Banana Coin #1 (Before Rattly sign)": 12517904,
    "Topsail Trouble/Banana Coin #2 (Rattly sign)": 12517905,
    "Topsail Trouble - Banana Coin #2/Banana Coin #2 (Rattly sign)": 12517905,
    "Topsail Trouble/Banana Coin #3 (Near banana trail on rope)": 12517906,
    "Topsail Trouble - Banana Coin #3/Banana Coin #3 (Near banana trail on rope)": 12517906,
    "Topsail Trouble/Banana Coin #4 (Behind Zinger)": 12517907,
    "Topsail Trouble - Banana Coin #4/Banana Coin #4 (Behind Zinger)": 12517907,
    "Krow's Nest/Banana Coin #1 (Above nest)": 12517908,
    "Krow's Nest - Banana Coin #1/Banana Coin #1 (Above nest)": 12517908,
    "Krow's Nest/Banana Coin #2 (Above nest)": 12517909,
    "Krow's Nest - Banana Coin #2/Banana Coin #2 (Above nest)": 12517909,
    "Hot-Head Hop/Banana Coin #1 (Chest after first brown Krockhead)": 12517910,
    "Hot-Head Hop - Banana Coin #1/Banana Coin #1 (Chest after first brown Krockhead)": 12517910,
    "Hot-Head Hop/Banana Coin #2 (Above A bananas)": 12517911,
    "Hot-Head Hop - Banana Coin #2/Banana Coin #2 (Above A bananas)": 12517911,
    "Hot-Head Hop/Banana Coin #3 (Between Zingers)": 12517912,
    "Hot-Head Hop - Banana Coin #3/Banana Coin #3 (Between Zingers)": 12517912,
    "Hot-Head Hop/Banana Coin #4 (Between Zingers)": 12517913,
    "Hot-Head Hop - Banana Coin #4/Banana Coin #4 (Between Zingers)": 12517913,
    "Kannon's Klaim/Banana Coin #1 (After Flitter)": 12517914,
    "Kannon's Klaim - Banana Coin #1/Banana Coin #1 (After Flitter)": 12517914,
    "Kannon's Klaim/Banana Coin #2 (Above arrow barrels)": 12517915,
    "Kannon's Klaim - Banana Coin #2/Banana Coin #2 (Above arrow barrels)": 12517915,
    "Kannon's Klaim/Banana Coin #3 (Diddy barrel)": 12517916,
    "Kannon's Klaim - Banana Coin #3/Banana Coin #3 (Diddy barrel)": 12517916,
    "Lava Lagoon/Banana Coin #1 (Below first Clapper)": 12517917,
    "Lava Lagoon - Banana Coin #1/Banana Coin #1 (Below first Clapper)": 12517917,
    "Lava Lagoon/Banana Coin #2 (Below first Clapper)": 12517918,
    "Lava Lagoon - Banana Coin #2/Banana Coin #2 (Below first Clapper)": 12517918,
    "Lava Lagoon/Banana Coin #3 (After Flotsam trio)": 12517919,
    "Lava Lagoon - Banana Coin #3/Banana Coin #3 (After Flotsam trio)": 12517919,
    "Lava Lagoon/Banana Coin #4 (Arrow barrel secret)": 12517920,
    "Lava Lagoon - Banana Coin #4/Banana Coin #4 (Arrow barrel secret)": 12517920,
    "Lava Lagoon/Banana Coin #5 (After O)": 12517921,
    "Lava Lagoon - Banana Coin #5/Banana Coin #5 (After O)": 12517921,
    "Lava Lagoon/Banana Coin #6 (Hidden passage near Lockjaw)": 12517922,
    "Lava Lagoon - Banana Coin #6/Banana Coin #6 (Hidden passage near Lockjaw)": 12517922,
    "Lava Lagoon/Banana Coin #7 (Hidden passage near Lockjaw)": 12517923,
    "Lava Lagoon - Banana Coin #7/Banana Coin #7 (Hidden passage near Lockjaw)": 12517923,
    "Lava Lagoon/Banana Coin #8 (Hidden between Puftups)": 12517924,
    "Lava Lagoon - Banana Coin #8/Banana Coin #8 (Hidden between Puftups)": 12517924,
    "Lava Lagoon/Banana Coin #9 (Hidden between Puftups)": 12517925,
    "Lava Lagoon - Banana Coin #9/Banana Coin #9 (Hidden between Puftups)": 12517925,
    "Lava Lagoon/Banana Coin #10 (Near Klobber on top left corner)": 12517926,
    "Lava Lagoon - Banana Coin #10/Banana Coin #10 (Near Klobber on top left corner)": 12517926,
    "Red-Hot Ride/Banana Coin #1 (Above start)": 12517927,
    "Red-Hot Ride - Banana Coin #1/Banana Coin #1 (Above start)": 12517927,
    "Red-Hot Ride/Banana Coin #2 (Above start)": 12517928,
    "Red-Hot Ride - Banana Coin #2/Banana Coin #2 (Above start)": 12517928,
    "Red-Hot Ride/Banana Coin #3 (Behind Zinger after Rambi)": 12517929,
    "Red-Hot Ride - Banana Coin #3/Banana Coin #3 (Behind Zinger after Rambi)": 12517929,
    "Red-Hot Ride/Banana Coin #4 (Above Kruncha)": 12517930,
    "Red-Hot Ride - Banana Coin #4/Banana Coin #4 (Above Kruncha)": 12517930,
    "Red-Hot Ride/Banana Coin #5 (Rambi sign)": 12517931,
    "Red-Hot Ride - Banana Coin #5/Banana Coin #5 (Rambi sign)": 12517931,
    "Red-Hot Ride/Banana Coin #6 (Behind Zinger after TNT barrel)": 12517932,
    "Red-Hot Ride - Banana Coin #6/Banana Coin #6 (Behind Zinger after TNT barrel)": 12517932,
    "Squawks's Shaft/Banana Coin #1 (Below Klomp)": 12517933,
    "Squawks's Shaft - Banana Coin #1/Banana Coin #1 (Below Klomp)": 12517933,
    "Squawks's Shaft/Banana Coin #2 (Inside Bonus #1)": 12517934,
    "Squawks's Shaft - Bonus #1/Banana Coin #2 (Inside Bonus #1)": 12517934,
    "Squawks's Shaft/Banana Coin #3 (Dixie barrel)": 12517935,
    "Squawks's Shaft - Banana Coin #3/Banana Coin #3 (Dixie barrel)": 12517935,
    "Squawks's Shaft/Banana Coin #4 (Dixie barrel)": 12517936,
    "Squawks's Shaft - Banana Coin #4/Banana Coin #4 (Dixie barrel)": 12517936,
    "Squawks's Shaft/Banana Coin #5 (Hidden pasage behind Krook duo)": 12517937,
    "Squawks's Shaft - Banana Coin #5/Banana Coin #5 (Hidden pasage behind Krook duo)": 12517937,
    "Squawks's Shaft/Banana Coin #6 (Hidden next to Bonus #3 barrel)": 12517938,
    "Squawks's Shaft - Banana Coin #6/Banana Coin #6 (Hidden next to Bonus #3 barrel)": 12517938,
    "Squawks's Shaft/Banana Coin #7 (Hidden next to Bonus #3 barrel)": 12517939,
    "Squawks's Shaft - Banana Coin #7/Banana Coin #7 (Hidden next to Bonus #3 barrel)": 12517939,
    "Kleever's Kiln/Banana Coin #1 (Top left corner)": 12517940,
    "Kleever's Kiln - Banana Coin #1/Banana Coin #1 (Top left corner)": 12517940,
    "Kleever's Kiln/Banana Coin #2 (Top left corner)": 12517941,
    "Kleever's Kiln - Banana Coin #2/Banana Coin #2 (Top left corner)": 12517941,
    "Barrel Bayou/Banana Coin #1 (Next to Zinger)": 12517942,
    "Barrel Bayou - Banana Coin #1/Banana Coin #1 (Next to Zinger)": 12517942,
    "Barrel Bayou/Banana Coin #2 (Behind Zinger after Klobber duo)": 12517943,
    "Barrel Bayou - Banana Coin #2/Banana Coin #2 (Behind Zinger after Klobber duo)": 12517943,
    "Glimmer's Galleon/Banana Coin #1 (Hidden passage on top left corner)": 12517944,
    "Glimmer's Galleon - Banana Coin #1/Banana Coin #1 (Hidden passage on top left corner)": 12517944,
    "Glimmer's Galleon/Banana Coin #2 (Hidden passage on top left corner)": 12517945,
    "Glimmer's Galleon - Banana Coin #2/Banana Coin #2 (Hidden passage on top left corner)": 12517945,
    "Glimmer's Galleon/Banana Coin #3 (Middle crates after left banana arrow)": 12517946,
    "Glimmer's Galleon - Banana Coin #3/Banana Coin #3 (Middle crates after left banana arrow)": 12517946,
    "Glimmer's Galleon/Banana Coin #4 (Hidden passage near Lockjaw duo)": 12517947,
    "Glimmer's Galleon - Banana Coin #4/Banana Coin #4 (Hidden passage near Lockjaw duo)": 12517947,
    "Glimmer's Galleon/Banana Coin #5 (Hidden passage near Lockjaw duo)": 12517948,
    "Glimmer's Galleon - Banana Coin #5/Banana Coin #5 (Hidden passage near Lockjaw duo)": 12517948,
    "Glimmer's Galleon/Banana Coin #6 (Near Lockjaw and blue Flotsam duo)": 12517949,
    "Glimmer's Galleon - Banana Coin #6/Banana Coin #6 (Near Lockjaw and blue Flotsam duo)": 12517949,
    "Glimmer's Galleon/Banana Coin #7 (Hidden passage near Shuri and blue Flotsam)": 12517950,
    "Glimmer's Galleon - Banana Coin #7/Banana Coin #7 (Hidden passage near Shuri and blue Flotsam)": 12517950,
    "Glimmer's Galleon/Banana Coin #8 (Hidden passage near Shuri and blue Flotsam)": 12517951,
    "Glimmer's Galleon - Banana Coin #8/Banana Coin #8 (Hidden passage near Shuri and blue Flotsam)": 12517951,
    "Glimmer's Galleon/Banana Coin #9 (Next to G)": 12517952,
    "Glimmer's Galleon - Banana Coin #9/Banana Coin #9 (Next to G)": 12517952,
    "Glimmer's Galleon/Banana Coin #10 (Before exit barrel)": 12517953,
    "Glimmer's Galleon - Banana Coin #10/Banana Coin #10 (Before exit barrel)": 12517953,
    "Krockhead Klamber/Banana Coin #1 (Behind start between Zingers)": 12517954,
    "Krockhead Klamber - Banana Coin #1/Banana Coin #1 (Behind start between Zingers)": 12517954,
    "Krockhead Klamber/Banana Coin #2 (Flitter)": 12517955,
    "Krockhead Klamber - Banana Coin #2/Banana Coin #2 (Flitter)": 12517955,
    "Krockhead Klamber/Banana Coin #3 (Zinger)": 12517956,
    "Krockhead Klamber - Banana Coin #3/Banana Coin #3 (Zinger)": 12517956,
    "Rattle Battle/Banana Coin #1 (Below Bonus #1 barrel)": 12517957,
    "Rattle Battle - Banana Coin #1/Banana Coin #1 (Below Bonus #1 barrel)": 12517957,
    "Rattle Battle/Banana Coin #2 (Behind Zinger)": 12517958,
    "Rattle Battle - Banana Coin #2/Banana Coin #2 (Behind Zinger)": 12517958,
    "Rattle Battle/Banana Coin #3 (Behind Kannon)": 12517959,
    "Rattle Battle - Banana Coin #3/Banana Coin #3 (Behind Kannon)": 12517959,
    "Slime Climb/Banana Coin #1 (After first Click-Clack)": 12517960,
    "Slime Climb - Banana Coin #1/Banana Coin #1 (After first Click-Clack)": 12517960,
    "Slime Climb/Banana Coin #2 (After first Klomp)": 12517961,
    "Slime Climb - Banana Coin #2/Banana Coin #2 (After first Klomp)": 12517961,
    "Slime Climb/Banana Coin #3 (After Flitter)": 12517962,
    "Slime Climb - Banana Coin #3/Banana Coin #3 (After Flitter)": 12517962,
    "Bramble Blast/Banana Coin #1 (After rotating Zinger)": 12517963,
    "Bramble Blast - Banana Coin #1/Banana Coin #1 (After rotating Zinger)": 12517963,
    "Bramble Blast/Banana Coin #2 (After first big barrel maze)": 12517964,
    "Bramble Blast - Banana Coin #2/Banana Coin #2 (After first big barrel maze)": 12517964,
    "Hornet Hole/Banana Coin #1 (Hooks above start)": 12517965,
    "Hornet Hole - Banana Coin #1/Banana Coin #1 (Hooks above start)": 12517965,
    "Hornet Hole/Banana Coin #2 (Pillar)": 12517966,
    "Hornet Hole - Banana Coin #2/Banana Coin #2 (Pillar)": 12517966,
    "Hornet Hole/Banana Coin #3 (Zinger after midpoint)": 12517967,
    "Hornet Hole - Banana Coin #3/Banana Coin #3 (Zinger after midpoint)": 12517967,
    "Hornet Hole/Banana Coin #4 (Following banana guides)": 12517968,
    "Hornet Hole - Banana Coin #4/Banana Coin #4 (Following banana guides)": 12517968,
    "Bramble Scramble/Banana Coin #1 (Above Bonus #1 barrel)": 12517969,
    "Bramble Scramble - Banana Coin #1/Banana Coin #1 (Above Bonus #1 barrel)": 12517969,
    "Bramble Scramble/Banana Coin #2 (Squawks sign on Bonus #1)": 12517970,
    "Bramble Scramble - Bonus #1/Banana Coin #2 (Squawks sign on Bonus #1)": 12517970,
    "Bramble Scramble/Banana Coin #3 (Below Flitters)": 12517971,
    "Bramble Scramble - Banana Coin #3/Banana Coin #3 (Below Flitters)": 12517971,
    "Bramble Scramble/Banana Coin #4 (Behind Krook)": 12517972,
    "Bramble Scramble - Banana Coin #4/Banana Coin #4 (Behind Krook)": 12517972,
    "Bramble Scramble/Banana Coin #5 (Behind Krook)": 12517973,
    "Bramble Scramble - Banana Coin #5/Banana Coin #5 (Behind Krook)": 12517973,
    "Bramble Scramble/Banana Coin #6 (Wall of bananas)": 12517974,
    "Bramble Scramble - Banana Coin #6/Banana Coin #6 (Wall of bananas)": 12517974,
    "Bramble Scramble/Banana Coin #7 (Wall of bananas)": 12517975,
    "Bramble Scramble - Banana Coin #7/Banana Coin #7 (Wall of bananas)": 12517975,
    "Bramble Scramble/Banana Coin #8 (Near DK Coin)": 12517976,
    "Bramble Scramble - Banana Coin #8/Banana Coin #8 (Near DK Coin)": 12517976,
    "Rickety Race/Banana Coin (Klank on second place)": 12517977,
    "Rickety Race - Banana Coin/Banana Coin (Klank on second place)": 12517977,
    "Mudhole Marsh/Banana Coin #1 (Start)": 12517978,
    "Mudhole Marsh - Banana Coin #1/Banana Coin #1 (Start)": 12517978,
    "Mudhole Marsh/Banana Coin #2 (Chest after O)": 12517979,
    "Mudhole Marsh - Banana Coin #2/Banana Coin #2 (Chest after O)": 12517979,
    "Mudhole Marsh/Banana Coin #3 (Above Zinger)": 12517980,
    "Mudhole Marsh - Banana Coin #3/Banana Coin #3 (Above Zinger)": 12517980,
    "Mudhole Marsh/Banana Coin #4 (Below Flitter)": 12517981,
    "Mudhole Marsh - Banana Coin #4/Banana Coin #4 (Below Flitter)": 12517981,
    "Mudhole Marsh/Banana Coin #5 (Next to G)": 12517982,
    "Mudhole Marsh - Banana Coin #5/Banana Coin #5 (Next to G)": 12517982,
    "Rambi Rumble/Banana Coin #1 (Above Zinger)": 12517983,
    "Rambi Rumble - Banana Coin #1/Banana Coin #1 (Above Zinger)": 12517983,
    "Rambi Rumble/Banana Coin #2 (Hook before Bonus #1)": 12517984,
    "Rambi Rumble - Banana Coin #2/Banana Coin #2 (Hook before Bonus #1)": 12517984,
    "King Zing Sting/Banana Coin #1 (Above start)": 12517985,
    "King Zing Sting - Banana Coin #1/Banana Coin #1 (Above start)": 12517985,
    "King Zing Sting/Banana Coin #2 (Above start)": 12517986,
    "King Zing Sting - Banana Coin #2/Banana Coin #2 (Above start)": 12517986,
    "Ghostly Grove/Banana Coin #1 (Pit)": 12517987,
    "Ghostly Grove - Banana Coin #1/Banana Coin #1 (Pit)": 12517987,
    "Ghostly Grove/Banana Coin #2 (On Ghost Rope)": 12517988,
    "Ghostly Grove - Banana Coin #2/Banana Coin #2 (On Ghost Rope)": 12517988,
    "Haunted Hall/Banana Coin #1 (Below second hook)": 12517989,
    "Haunted Hall - Banana Coin #1/Banana Coin #1 (Below second hook)": 12517989,
    "Haunted Hall/Banana Coin #2 (Green kackle)": 12517990,
    "Haunted Hall - Banana Coin #2/Banana Coin #2 (Green kackle)": 12517990,
    "Haunted Hall/Banana Coin #3 (Yellow kackle)": 12517991,
    "Haunted Hall - Banana Coin #3/Banana Coin #3 (Yellow kackle)": 12517991,
    "Gusty Glade/Banana Coin #1 (Above Rattly)": 12517992,
    "Gusty Glade - Banana Coin #1/Banana Coin #1 (Above Rattly)": 12517992,
    "Gusty Glade/Banana Coin #2 (Pit)": 12517993,
    "Gusty Glade - Banana Coin #2/Banana Coin #2 (Pit)": 12517993,
    "Gusty Glade/Banana Coin #3 (Below Kannon)": 12517994,
    "Gusty Glade - Banana Coin #3/Banana Coin #3 (Below Kannon)": 12517994,
    "Parrot Chute Panic/Banana Coin #1 (After K)": 12517995,
    "Parrot Chute Panic - Banana Coin #1/Banana Coin #1 (After K)": 12517995,
    "Parrot Chute Panic/Banana Coin #2 (Between Zingers)": 12517996,
    "Parrot Chute Panic - Banana Coin #2/Banana Coin #2 (Between Zingers)": 12517996,
    "Parrot Chute Panic/Banana Coin #3 (2-path after N)": 12517997,
    "Parrot Chute Panic - Banana Coin #3/Banana Coin #3 (2-path after N)": 12517997,
    "Parrot Chute Panic/Banana Coin #4 (2-path after N)": 12517998,
    "Parrot Chute Panic - Banana Coin #4/Banana Coin #4 (2-path after N)": 12517998,
    "Parrot Chute Panic/Banana Coin #5 (Barrel)": 12517999,
    "Parrot Chute Panic - Banana Coin #5/Banana Coin #5 (Barrel)": 12517999,
    "Web Woods/Banana Coin #1 (Above K)": 12518000,
    "Web Woods - Banana Coin #1/Banana Coin #1 (Above K)": 12518000,
    "Web Woods/Banana Coin #2 (Chest after K)": 12518001,
    "Web Woods - Banana Coin #2/Banana Coin #2 (Chest after K)": 12518001,
    "Web Woods/Banana Coin #3 (Wall after Kaboings)": 12518002,
    "Web Woods - Banana Coin #3/Banana Coin #3 (Wall after Kaboings)": 12518002,
    "Web Woods/Banana Coin #4 (Above midpoint)": 12518003,
    "Web Woods - Banana Coin #4/Banana Coin #4 (Above midpoint)": 12518003,
    "Web Woods/Banana Coin #5 (Next to Red Zinger)": 12518004,
    "Web Woods - Banana Coin #5/Banana Coin #5 (Next to Red Zinger)": 12518004,
    "Kreepy Krow/Banana Coin #1 (After second phase)": 12518005,
    "Kreepy Krow - Banana Coin #1/Banana Coin #1 (After second phase)": 12518005,
    "Kreepy Krow/Banana Coin #2 (After second phase)": 12518006,
    "Kreepy Krow - Banana Coin #2/Banana Coin #2 (After second phase)": 12518006,
    "Arctic Abyss/Banana Coin #1 (Next to K)": 12518007,
    "Arctic Abyss - Banana Coin #1/Banana Coin #1 (Next to K)": 12518007,
    "Arctic Abyss/Banana Coin #2 (Below Enguarde)": 12518008,
    "Arctic Abyss - Banana Coin #2/Banana Coin #2 (Below Enguarde)": 12518008,
    "Arctic Abyss/Banana Coin #3 (Below Enguarde)": 12518009,
    "Arctic Abyss - Banana Coin #3/Banana Coin #3 (Below Enguarde)": 12518009,
    "Arctic Abyss/Banana Coin #4 (Below Enguarde)": 12518010,
    "Arctic Abyss - Banana Coin #4/Banana Coin #4 (Below Enguarde)": 12518010,
    "Arctic Abyss/Banana Coin #5 (Behind Shuri duo)": 12518011,
    "Arctic Abyss - Banana Coin #5/Banana Coin #5 (Behind Shuri duo)": 12518011,
    "Windy Well/Banana Coin #1 (After Kutlass)": 12518012,
    "Windy Well - Banana Coin #1/Banana Coin #1 (After Kutlass)": 12518012,
    "Windy Well/Banana Coin #2 (Between Zingers)": 12518013,
    "Windy Well - Banana Coin #2/Banana Coin #2 (Between Zingers)": 12518013,
    "Windy Well/Banana Coin #3 (Above Bonus #1 barrel)": 12518014,
    "Windy Well - Banana Coin #3/Banana Coin #3 (Above Bonus #1 barrel)": 12518014,
    "Windy Well/Banana Coin #4 (Rotating Zinger)": 12518015,
    "Windy Well - Banana Coin #4/Banana Coin #4 (Rotating Zinger)": 12518015,
    "Castle Crush/Banana Coin #1 (4-path)": 12518016,
    "Castle Crush - Banana Coin #1/Banana Coin #1 (4-path)": 12518016,
    "Castle Crush/Banana Coin #2 (After Zinger duo)": 12518017,
    "Castle Crush - Banana Coin #2/Banana Coin #2 (After Zinger duo)": 12518017,
    "Castle Crush/Banana Coin #3 (Above Zinger before goal)": 12518018,
    "Castle Crush - Banana Coin #3/Banana Coin #3 (Above Zinger before goal)": 12518018,
    "Clapper's Cavern/Banana Coin #1 (Below Zinger duo)": 12518019,
    "Clapper's Cavern - Banana Coin #1/Banana Coin #1 (Below Zinger duo)": 12518019,
    "Clapper's Cavern/Banana Coin #2 (Next to Bonus #2 entrance)": 12518020,
    "Clapper's Cavern - Banana Coin #2/Banana Coin #2 (Next to Bonus #2 entrance)": 12518020,
    "Clapper's Cavern/Banana Coin #3 (Below ! Barrel)": 12518021,
    "Clapper's Cavern - Banana Coin #3/Banana Coin #3 (Below ! Barrel)": 12518021,
    "Clapper's Cavern/Banana Coin #4 (Below ! Barrel)": 12518022,
    "Clapper's Cavern - Banana Coin #4/Banana Coin #4 (Below ! Barrel)": 12518022,
    "Clapper's Cavern/Banana Coin #5 (Below ! Barrel)": 12518023,
    "Clapper's Cavern - Banana Coin #5/Banana Coin #5 (Below ! Barrel)": 12518023,
    "Chain Link Chamber/Banana Coin #1 (Above Klobber)": 12518024,
    "Chain Link Chamber - Banana Coin #1/Banana Coin #1 (Above Klobber)": 12518024,
    "Chain Link Chamber/Banana Coin #2 (Near midpoint)": 12518025,
    "Chain Link Chamber - Banana Coin #2/Banana Coin #2 (Near midpoint)": 12518025,
    "Chain Link Chamber/Banana Coin #3 (Left bottom Mini-Necky spot)": 12518026,
    "Chain Link Chamber - Banana Coin #3/Banana Coin #3 (Left bottom Mini-Necky spot)": 12518026,
    "Chain Link Chamber/Banana Coin #4 (Top right Mini-Necky spot)": 12518027,
    "Chain Link Chamber - Banana Coin #4/Banana Coin #4 (Top right Mini-Necky spot)": 12518027,
    "Toxic Tower/Banana Coin #1 (Passage after Zinger trio)": 12518028,
    "Toxic Tower - Banana Coin #1/Banana Coin #1 (Passage after Zinger trio)": 12518028,
    "Toxic Tower/Banana Coin #2 (Passage after Zinger trio)": 12518029,
    "Toxic Tower - Banana Coin #2/Banana Coin #2 (Passage after Zinger trio)": 12518029,
    "Toxic Tower/Banana Coin #3 (Corner before Zinger 2-path)": 12518030,
    "Toxic Tower - Banana Coin #3/Banana Coin #3 (Corner before Zinger 2-path)": 12518030,
    "Toxic Tower/Banana Coin #4 (Passage below Zinger)": 12518031,
    "Toxic Tower - Banana Coin #4/Banana Coin #4 (Passage below Zinger)": 12518031,
    "Toxic Tower/Banana Coin #5 (Passage below Zinger)": 12518032,
    "Toxic Tower - Banana Coin #5/Banana Coin #5 (Passage below Zinger)": 12518032,
    "Stronghold Showdown/Banana Coin #1 (Above start)": 12518033,
    "Stronghold Showdown - Banana Coin #1/Banana Coin #1 (Above start)": 12518033,
    "Stronghold Showdown/Banana Coin #2 (Above start)": 12518034,
    "Stronghold Showdown - Banana Coin #2/Banana Coin #2 (Above start)": 12518034,
    "Screech's Sprint/Banana Coin #1 (Start)": 12518035,
    "Screech's Sprint - Banana Coin #1/Banana Coin #1 (Start)": 12518035,
    "Screech's Sprint/Banana Coin #2 (Above Flitter)": 12518036,
    "Screech's Sprint - Banana Coin #2/Banana Coin #2 (Above Flitter)": 12518036,
    "Screech's Sprint/Banana Coin #3 (Before midpoint)": 12518037,
    "Screech's Sprint - Banana Coin #3/Banana Coin #3 (Before midpoint)": 12518037,
    "Screech's Sprint/Banana Coin #4 (Detour left from second arrow)": 12518038,
    "Screech's Sprint - Banana Coin #4/Banana Coin #4 (Detour left from second arrow)": 12518038,
    "Screech's Sprint/Banana Coin #5 (Detour left from second arrow)": 12518039,
    "Screech's Sprint - Banana Coin #5/Banana Coin #5 (Detour left from second arrow)": 12518039,
    "Screech's Sprint/Banana Coin #6 (Detour left from second arrow)": 12518040,
    "Screech's Sprint - Banana Coin #6/Banana Coin #6 (Detour left from second arrow)": 12518040,
    "Screech's Sprint/Banana Coin #7 (Detour left from second arrow)": 12518041,
    "Screech's Sprint - Banana Coin #7/Banana Coin #7 (Detour left from second arrow)": 12518041,
    "Screech's Sprint/Banana Coin #8 (Detour left from second arrow)": 12518042,
    "Screech's Sprint - Banana Coin #8/Banana Coin #8 (Detour left from second arrow)": 12518042,
    "Jungle Jinx/Banana Coin #1 (Between Zingers)": 12518043,
    "Jungle Jinx - Banana Coin #1/Banana Coin #1 (Between Zingers)": 12518043,
    "Jungle Jinx/Banana Coin #2 (Above Zinger)": 12518044,
    "Jungle Jinx - Banana Coin #2/Banana Coin #2 (Above Zinger)": 12518044,
    "Jungle Jinx/Banana Coin #3 (Arrow barrel)": 12518045,
    "Jungle Jinx - Banana Coin #3/Banana Coin #3 (Arrow barrel)": 12518045,
    "Jungle Jinx/Banana Coin #4 (On top of banana trail)": 12518046,
    "Jungle Jinx - Banana Coin #4/Banana Coin #4 (On top of banana trail)": 12518046,
    "Jungle Jinx/Banana Coin #5 (Banana trail before Klobber)": 12518047,
    "Jungle Jinx - Banana Coin #5/Banana Coin #5 (Banana trail before Klobber)": 12518047,
    "Black Ice Battle/Banana Coin #1 (4-path right)": 12518048,
    "Black Ice Battle - Banana Coin #1/Banana Coin #1 (4-path right)": 12518048,
    "Klobber Karnage/Banana Coin #1 (Start)": 12518049,
    "Klobber Karnage - Banana Coin #1/Banana Coin #1 (Start)": 12518049,
    "Klobber Karnage/Banana Coin #2 (Above spikes)": 12518050,
    "Klobber Karnage - Banana Coin #2/Banana Coin #2 (Above spikes)": 12518050,
    "Klobber Karnage/Banana Coin #3 (First Diddy barrel)": 12518051,
    "Klobber Karnage - Banana Coin #3/Banana Coin #3 (First Diddy barrel)": 12518051,
    "Klobber Karnage/Banana Coin #4 (Diddy barrel after Klobber trio)": 12518052,
    "Klobber Karnage - Banana Coin #4/Banana Coin #4 (Diddy barrel after Klobber trio)": 12518052,
    "Fiery Furnace/Banana Coin #1 (Near Controllable Barrel)": 12518053,
    "Fiery Furnace - Banana Coin #1/Banana Coin #1 (Near Controllable Barrel)": 12518053,
    "Fiery Furnace/Banana Coin #2 (Ledge before Kutlass)": 12518054,
    "Fiery Furnace - Banana Coin #2/Banana Coin #2 (Ledge before Kutlass)": 12518054,
    "Animal Antics/Banana Coin #1 (Between spikes)": 12518055,
    "Animal Antics - Banana Coin #1/Banana Coin #1 (Between spikes)": 12518055,
    "Animal Antics/Banana Coin #2 (Behind Zingers)": 12518056,
    "Animal Antics - Banana Coin #2/Banana Coin #2 (Behind Zingers)": 12518056,
    "Animal Antics/Banana Coin #3 (Behind Zingers)": 12518057,
    "Animal Antics - Banana Coin #3/Banana Coin #3 (Behind Zingers)": 12518057,
    "Animal Antics/Banana Coin #4 (Corner near Red Zingers)": 12518058,
    "Animal Antics - Banana Coin #4/Banana Coin #4 (Corner near Red Zingers)": 12518058,
    "Animal Antics/Banana Coin #5 (Rattly sign)": 12518059,
    "Animal Antics - Banana Coin #5/Banana Coin #5 (Rattly sign)": 12518059,
    "Pirate Panic/Banana Bunch #1 (Above Klomp)": 12518144,
    "Pirate Panic - Banana Bunch #1/Banana Bunch #1 (Above Klomp)": 12518144,
    "Mainbrace Mayhem/Banana Bunch #1 (Before Bonus #1)": 12518145,
    "Mainbrace Mayhem - Banana Bunch #1/Banana Bunch #1 (Before Bonus #1)": 12518145,
    "Mainbrace Mayhem/Banana Bunch #2 (After Bonus #3)": 12518146,
    "Mainbrace Mayhem - Banana Bunch #2/Banana Bunch #2 (After Bonus #3)": 12518146,
    "Mainbrace Mayhem/Banana Bunch #3 (After Bonus #3)": 12518147,
    "Mainbrace Mayhem - Banana Bunch #3/Banana Bunch #3 (After Bonus #3)": 12518147,
    "Gangplank Galley/Banana Bunch #1 (Hook before DK Coin)": 12518148,
    "Gangplank Galley - Banana Bunch #1/Banana Bunch #1 (Hook before DK Coin)": 12518148,
    "Gangplank Galley/Banana Bunch #2 (First chest)": 12518149,
    "Gangplank Galley - Banana Bunch #2/Banana Bunch #2 (First chest)": 12518149,
    "Gangplank Galley/Banana Bunch #3 (Hook before O)": 12518150,
    "Gangplank Galley - Banana Bunch #3/Banana Bunch #3 (Hook before O)": 12518150,
    "Gangplank Galley/Banana Bunch #4 (Chest before Kruncha trio)": 12518151,
    "Gangplank Galley - Banana Bunch #4/Banana Bunch #4 (Chest before Kruncha trio)": 12518151,
    "Gangplank Galley/Banana Bunch #5 (Below Kruncha trio)": 12518152,
    "Gangplank Galley - Banana Bunch #5/Banana Bunch #5 (Below Kruncha trio)": 12518152,
    "Gangplank Galley/Banana Bunch #6 (Below Kruncha trio)": 12518153,
    "Gangplank Galley - Banana Bunch #6/Banana Bunch #6 (Below Kruncha trio)": 12518153,
    "Gangplank Galley/Banana Bunch #7 (After G chest)": 12518154,
    "Gangplank Galley - Banana Bunch #7/Banana Bunch #7 (After G chest)": 12518154,
    "Lockjaw's Locker/Banana Bunch #1 (Right on start)": 12518155,
    "Lockjaw's Locker - Banana Bunch #1/Banana Bunch #1 (Right on start)": 12518155,
    "Lockjaw's Locker/Banana Bunch #2 (Above K)": 12518156,
    "Lockjaw's Locker - Banana Bunch #2/Banana Bunch #2 (Above K)": 12518156,
    "Lockjaw's Locker/Banana Bunch #3 (After Enguarde)": 12518157,
    "Lockjaw's Locker - Banana Bunch #3/Banana Bunch #3 (After Enguarde)": 12518157,
    "Lockjaw's Locker/Banana Bunch #4 (Enguarde sign #2)": 12518158,
    "Lockjaw's Locker - Banana Bunch #4/Banana Bunch #4 (Enguarde sign #2)": 12518158,
    "Topsail Trouble/Banana Bunch #1 (Below Zinger)": 12518159,
    "Topsail Trouble - Banana Bunch #1/Banana Bunch #1 (Below Zinger)": 12518159,
    "Topsail Trouble/Banana Bunch #2 (Before Rattly sign)": 12518160,
    "Topsail Trouble - Banana Bunch #2/Banana Bunch #2 (Before Rattly sign)": 12518160,
    "Topsail Trouble/Banana Bunch #3 (Near banana trail on rope)": 12518161,
    "Topsail Trouble - Banana Bunch #3/Banana Bunch #3 (Near banana trail on rope)": 12518161,
    "Hot-Head Hop/Banana Bunch #1 (Chest next to cannon)": 12518162,
    "Hot-Head Hop - Banana Bunch #1/Banana Bunch #1 (Chest next to cannon)": 12518162,
    "Hot-Head Hop/Banana Bunch #2 (Above G)": 12518163,
    "Hot-Head Hop - Banana Bunch #2/Banana Bunch #2 (Above G)": 12518163,
    "Hot-Head Hop/Banana Bunch #3 (Above G)": 12518164,
    "Hot-Head Hop - Banana Bunch #3/Banana Bunch #3 (Above G)": 12518164,
    "Kannon's Klaim/Banana Bunch #1 (Near hook)": 12518165,
    "Kannon's Klaim - Banana Bunch #1/Banana Bunch #1 (Near hook)": 12518165,
    "Lava Lagoon/Banana Bunch #1 (Next to first Flotsam)": 12518166,
    "Lava Lagoon - Banana Bunch #1/Banana Bunch #1 (Next to first Flotsam)": 12518166,
    "Lava Lagoon/Banana Bunch #2 (After K)": 12518167,
    "Lava Lagoon - Banana Bunch #2/Banana Bunch #2 (After K)": 12518167,
    "Lava Lagoon/Banana Bunch #3 (After blue Flotsam shoal)": 12518168,
    "Lava Lagoon - Banana Bunch #3/Banana Bunch #3 (After blue Flotsam shoal)": 12518168,
    "Lava Lagoon/Banana Bunch #4 (Inside Bonus)": 12518169,
    "Lava Lagoon - Bonus #1/Banana Bunch #4 (Inside Bonus)": 12518169,
    "Lava Lagoon/Banana Bunch #5 (After Click-Clack duo)": 12518170,
    "Lava Lagoon - Banana Bunch #5/Banana Bunch #5 (After Click-Clack duo)": 12518170,
    "Red-Hot Ride/Banana Bunch #1 (Start)": 12518171,
    "Red-Hot Ride - Banana Bunch #1/Banana Bunch #1 (Start)": 12518171,
    "Red-Hot Ride/Banana Bunch #2 (After K)": 12518172,
    "Red-Hot Ride - Banana Bunch #2/Banana Bunch #2 (After K)": 12518172,
    "Red-Hot Ride/Banana Bunch #3 (Above Zinger)": 12518173,
    "Red-Hot Ride - Banana Bunch #3/Banana Bunch #3 (Above Zinger)": 12518173,
    "Red-Hot Ride/Banana Bunch #4 (Above Flitter)": 12518174,
    "Red-Hot Ride - Banana Bunch #4/Banana Bunch #4 (Above Flitter)": 12518174,
    "Squawks's Shaft/Banana Bunch #1 (After Krook duo)": 12518175,
    "Squawks's Shaft - Banana Bunch #1/Banana Bunch #1 (After Krook duo)": 12518175,
    "Squawks's Shaft/Banana Bunch #2 (Next to Krook)": 12518176,
    "Squawks's Shaft - Banana Bunch #2/Banana Bunch #2 (Next to Krook)": 12518176,
    "Squawks's Shaft/Banana Bunch #3 (Between Zingers)": 12518177,
    "Squawks's Shaft - Banana Bunch #3/Banana Bunch #3 (Between Zingers)": 12518177,
    "Squawks's Shaft/Banana Bunch #4 (Squawks sign)": 12518178,
    "Squawks's Shaft - Banana Bunch #4/Banana Bunch #4 (Squawks sign)": 12518178,
    "Barrel Bayou/Banana Bunch #1 (First Kloak)": 12518179,
    "Barrel Bayou - Banana Bunch #1/Banana Bunch #1 (First Kloak)": 12518179,
    "Barrel Bayou/Banana Bunch #2 (Kloak after yellow Klobber)": 12518180,
    "Barrel Bayou - Banana Bunch #2/Banana Bunch #2 (Kloak after yellow Klobber)": 12518180,
    "Barrel Bayou/Banana Bunch #3 (Above Kloak)": 12518181,
    "Barrel Bayou - Banana Bunch #3/Banana Bunch #3 (Above Kloak)": 12518181,
    "Glimmer's Galleon/Banana Bunch #1 (Hidden passage above Bonus #1 entrance)": 12518182,
    "Glimmer's Galleon - Banana Bunch #1/Banana Bunch #1 (Hidden passage above Bonus #1 entrance)": 12518182,
    "Glimmer's Galleon/Banana Bunch #2 (Hidden passage above Bonus #1 entrance)": 12518183,
    "Glimmer's Galleon - Banana Bunch #2/Banana Bunch #2 (Hidden passage above Bonus #1 entrance)": 12518183,
    "Glimmer's Galleon/Banana Bunch #3 (Hidden passage above Bonus #1 entrance)": 12518184,
    "Glimmer's Galleon - Banana Bunch #3/Banana Bunch #3 (Hidden passage above Bonus #1 entrance)": 12518184,
    "Glimmer's Galleon/Banana Bunch #4 (Above green Flotsam duo)": 12518185,
    "Glimmer's Galleon - Banana Bunch #4/Banana Bunch #4 (Above green Flotsam duo)": 12518185,
    "Glimmer's Galleon/Banana Bunch #5 (Next to Lockjaw near up banana arrow)": 12518186,
    "Glimmer's Galleon - Banana Bunch #5/Banana Bunch #5 (Next to Lockjaw near up banana arrow)": 12518186,
    "Glimmer's Galleon/Banana Bunch #6 (Hidden passage near Lockjaw duo)": 12518187,
    "Glimmer's Galleon - Banana Bunch #6/Banana Bunch #6 (Hidden passage near Lockjaw duo)": 12518187,
    "Glimmer's Galleon/Banana Bunch #7 (Hidden passage near Lockjaw duo)": 12518188,
    "Glimmer's Galleon - Banana Bunch #7/Banana Bunch #7 (Hidden passage near Lockjaw duo)": 12518188,
    "Glimmer's Galleon/Banana Bunch #8 (Near Lockjaw and blue Flotsam duo)": 12518189,
    "Glimmer's Galleon - Banana Bunch #8/Banana Bunch #8 (Near Lockjaw and blue Flotsam duo)": 12518189,
    "Glimmer's Galleon/Banana Bunch #9 (Near exploding Puftup after midpoint)": 12518190,
    "Glimmer's Galleon - Banana Bunch #9/Banana Bunch #9 (Near exploding Puftup after midpoint)": 12518190,
    "Glimmer's Galleon/Banana Bunch #10 (Near exploding Puftup before N)": 12518191,
    "Glimmer's Galleon - Banana Bunch #10/Banana Bunch #10 (Near exploding Puftup before N)": 12518191,
    "Glimmer's Galleon/Banana Bunch #11 (Near exploding Puftup before N)": 12518192,
    "Glimmer's Galleon - Banana Bunch #11/Banana Bunch #11 (Near exploding Puftup before N)": 12518192,
    "Glimmer's Galleon/Banana Bunch #12 (Next to N)": 12518193,
    "Glimmer's Galleon - Banana Bunch #12/Banana Bunch #12 (Next to N)": 12518193,
    "Glimmer's Galleon/Banana Bunch #13 (All way up after multiple Shuri section)": 12518194,
    "Glimmer's Galleon - Banana Bunch #13/Banana Bunch #13 (All way up after multiple Shuri section)": 12518194,
    "Glimmer's Galleon/Banana Bunch #14 (Next to G)": 12518195,
    "Glimmer's Galleon - Banana Bunch #14/Banana Bunch #14 (Next to G)": 12518195,
    "Rattle Battle/Banana Bunch #1 (Below Bonus #1 barrel)": 12518196,
    "Rattle Battle - Banana Bunch #1/Banana Bunch #1 (Below Bonus #1 barrel)": 12518196,
    "Rattle Battle/Banana Bunch #2 (After Kaboing duo)": 12518197,
    "Rattle Battle - Banana Bunch #2/Banana Bunch #2 (After Kaboing duo)": 12518197,
    "Rattle Battle/Banana Bunch #3 (Next to Kannon)": 12518198,
    "Rattle Battle - Banana Bunch #3/Banana Bunch #3 (Next to Kannon)": 12518198,
    "Rattle Battle/Banana Bunch #4 (Rattly sign)": 12518199,
    "Rattle Battle - Banana Bunch #4/Banana Bunch #4 (Rattly sign)": 12518199,
    "Slime Climb/Banana Bunch #1 (Before midpoint)": 12518200,
    "Slime Climb - Banana Bunch #1/Banana Bunch #1 (Before midpoint)": 12518200,
    "Slime Climb/Banana Bunch #2 (Flitter)": 12518201,
    "Slime Climb - Banana Bunch #2/Banana Bunch #2 (Flitter)": 12518201,
    "Slime Climb/Banana Bunch #3 (Next to G)": 12518202,
    "Slime Climb - Banana Bunch #3/Banana Bunch #3 (Next to G)": 12518202,
    "Slime Climb/Banana Bunch #4 (Next to G)": 12518203,
    "Slime Climb - Banana Bunch #4/Banana Bunch #4 (Next to G)": 12518203,
    "Bramble Blast/Banana Bunch #1 (Start)": 12518204,
    "Bramble Blast - Banana Bunch #1/Banana Bunch #1 (Start)": 12518204,
    "Bramble Blast/Banana Bunch #2 (Initial barrel group)": 12518205,
    "Bramble Blast - Banana Bunch #2/Banana Bunch #2 (Initial barrel group)": 12518205,
    "Bramble Blast/Banana Bunch #3 (After rotating Zinger)": 12518206,
    "Bramble Blast - Banana Bunch #3/Banana Bunch #3 (After rotating Zinger)": 12518206,
    "Bramble Blast/Banana Bunch #4 (After rotating Zinger)": 12518207,
    "Bramble Blast - Banana Bunch #4/Banana Bunch #4 (After rotating Zinger)": 12518207,
    "Bramble Blast/Banana Bunch #5 (After rotating Zinger)": 12518208,
    "Bramble Blast - Banana Bunch #5/Banana Bunch #5 (After rotating Zinger)": 12518208,
    "Bramble Blast/Banana Bunch #6 (After Click-Clack duo)": 12518209,
    "Bramble Blast - Banana Bunch #6/Banana Bunch #6 (After Click-Clack duo)": 12518209,
    "Bramble Blast/Banana Bunch #7 (Squawks area)": 12518210,
    "Bramble Blast - Banana Bunch #7/Banana Bunch #7 (Squawks area)": 12518210,
    "Bramble Blast/Banana Bunch #8 (Squawks area)": 12518211,
    "Bramble Blast - Banana Bunch #8/Banana Bunch #8 (Squawks area)": 12518211,
    "Bramble Blast/Banana Bunch #9 (Squawks sign on Bonus #2)": 12518212,
    "Bramble Blast - Banana Bunch #9/Banana Bunch #9 (Squawks sign on Bonus #2)": 12518212,
    "Hornet Hole/Banana Bunch #1(Hooks above start)": 12518213,
    "Hornet Hole - Banana Bunch #1/Banana Bunch #1(Hooks above start)": 12518213,
    "Hornet Hole/Banana Bunch #2(Hooks above start)": 12518214,
    "Hornet Hole - Banana Bunch #2/Banana Bunch #2(Hooks above start)": 12518214,
    "Hornet Hole/Banana Bunch #3 (Following banana guides)": 12518215,
    "Hornet Hole - Banana Bunch #3/Banana Bunch #3 (Following banana guides)": 12518215,
    "Hornet Hole/Banana Bunch #4 (Following banana guides)": 12518216,
    "Hornet Hole - Banana Bunch #4/Banana Bunch #4 (Following banana guides)": 12518216,
    "Hornet Hole/Banana Bunch #5 (Above DK Barrel)": 12518217,
    "Hornet Hole - Banana Bunch #5/Banana Bunch #5 (Above DK Barrel)": 12518217,
    "Target Terror/Banana Bunch #1 (Start)": 12518218,
    "Target Terror - Banana Bunch #1/Banana Bunch #1 (Start)": 12518218,
    "Target Terror/Banana Bunch #2 (Squawks sign on Bonus #1)": 12518219,
    "Target Terror - Bonus #1/Banana Bunch #2 (Squawks sign on Bonus #1)": 12518219,
    "Bramble Scramble/Banana Bunch #1 (Next to K)": 12518220,
    "Bramble Scramble - Banana Bunch #1/Banana Bunch #1 (Next to K)": 12518220,
    "Bramble Scramble/Banana Bunch #2 (Behind Zinger)": 12518221,
    "Bramble Scramble - Banana Bunch #2/Banana Bunch #2 (Behind Zinger)": 12518221,
    "Bramble Scramble/Banana Bunch #3 (After red Zinger duo)": 12518222,
    "Bramble Scramble - Banana Bunch #3/Banana Bunch #3 (After red Zinger duo)": 12518222,
    "Bramble Scramble/Banana Bunch #4 (Above Kannon)": 12518223,
    "Bramble Scramble - Banana Bunch #4/Banana Bunch #4 (Above Kannon)": 12518223,
    "Bramble Scramble/Banana Bunch #5 (Squawks sign)": 12518224,
    "Bramble Scramble - Banana Bunch #5/Banana Bunch #5 (Squawks sign)": 12518224,
    "Mudhole Marsh/Banana Bunch #1 (Triple Chest)": 12518225,
    "Mudhole Marsh - Banana Bunch #1/Banana Bunch #1 (Triple Chest)": 12518225,
    "Rambi Rumble/Banana Bunch #1 (Below second Klampon)": 12518226,
    "Rambi Rumble - Banana Bunch #1/Banana Bunch #1 (Below second Klampon)": 12518226,
    "Rambi Rumble/Banana Bunch #2 (Below Klampon after downwards section)": 12518227,
    "Rambi Rumble - Banana Bunch #2/Banana Bunch #2 (Below Klampon after downwards section)": 12518227,
    "Rambi Rumble/Banana Bunch #3 (Rambi sign)": 12518228,
    "Rambi Rumble - Banana Bunch #3/Banana Bunch #3 (Rambi sign)": 12518228,
    "Ghostly Grove/Banana Bunch #1 (Kloak at start)": 12518229,
    "Ghostly Grove - First Kloak/Banana Bunch #1 (Kloak at start)": 12518229,
    "Ghostly Grove/Banana Bunch #2 (Kloak after Klomps)": 12518230,
    "Ghostly Grove - Banana Bunch #2/Banana Bunch #2 (Kloak after Klomps)": 12518230,
    "Ghostly Grove/Banana Bunch #3 (Between Ghost Ropes)": 12518231,
    "Ghostly Grove - Banana Bunch #3/Banana Bunch #3 (Between Ghost Ropes)": 12518231,
    "Ghostly Grove/Banana Bunch #4 (On Ghost Rope)": 12518232,
    "Ghostly Grove - Banana Bunch #4/Banana Bunch #4 (On Ghost Rope)": 12518232,
    "Haunted Hall/Banana Bunch #1 (Start)": 12518233,
    "Haunted Hall - Banana Bunches/Banana Bunch #1 (Start)": 12518233,
    "Haunted Hall/Banana Bunch #2 (Start)": 12518234,
    "Haunted Hall - Banana Bunches/Banana Bunch #2 (Start)": 12518234,
    "Parrot Chute Panic/Banana Bunch #1 (After O)": 12518235,
    "Parrot Chute Panic - Banana Bunch #1/Banana Bunch #1 (After O)": 12518235,
    "Parrot Chute Panic/Banana Bunch #2 (2-path after N)": 12518236,
    "Parrot Chute Panic - Banana Bunch #2/Banana Bunch #2 (2-path after N)": 12518236,
    "Web Woods/Banana Bunch #1 (Pit)": 12518237,
    "Web Woods - Banana Bunch #1/Banana Bunch #1 (Pit)": 12518237,
    "Web Woods/Banana Bunch #2 (Behind Zinger)": 12518238,
    "Web Woods - Banana Bunch #2/Banana Bunch #2 (Behind Zinger)": 12518238,
    "Web Woods/Banana Bunch #3 (Below Zinger)": 12518239,
    "Web Woods - Banana Bunch #3/Banana Bunch #3 (Below Zinger)": 12518239,
    "Arctic Abyss/Banana Bunch #1 (Next to K)": 12518240,
    "Arctic Abyss - Banana Bunch #1/Banana Bunch #1 (Next to K)": 12518240,
    "Arctic Abyss/Banana Bunch #2 (Next to K)": 12518241,
    "Arctic Abyss - Banana Bunch #2/Banana Bunch #2 (Next to K)": 12518241,
    "Arctic Abyss/Banana Bunch #3 (Next to K)": 12518242,
    "Arctic Abyss - Banana Bunch #3/Banana Bunch #3 (Next to K)": 12518242,
    "Arctic Abyss/Banana Bunch #4 (Above Puftup)": 12518243,
    "Arctic Abyss - Banana Bunch #4/Banana Bunch #4 (Above Puftup)": 12518243,
    "Arctic Abyss/Banana Bunch #5 (Behind Shuri duo)": 12518244,
    "Arctic Abyss - Banana Bunch #5/Banana Bunch #5 (Behind Shuri duo)": 12518244,
    "Arctic Abyss/Banana Bunch #6 (Behind Shuri duo)": 12518245,
    "Arctic Abyss - Banana Bunch #6/Banana Bunch #6 (Behind Shuri duo)": 12518245,
    "Arctic Abyss/Banana Bunch #7 (Near G)": 12518246,
    "Arctic Abyss - Banana Bunch #7/Banana Bunch #7 (Near G)": 12518246,
    "Windy Well/Banana Bunch #1 (Next to Klampon)": 12518247,
    "Windy Well - Banana Bunch #1/Banana Bunch #1 (Next to Klampon)": 12518247,
    "Windy Well/Banana Bunch #2 (Next to Klampon)": 12518248,
    "Windy Well - Banana Bunch #2/Banana Bunch #2 (Next to Klampon)": 12518248,
    "Windy Well/Banana Bunch #3 (Rotating Zinger)": 12518249,
    "Windy Well - Banana Bunch #3/Banana Bunch #3 (Rotating Zinger)": 12518249,
    "Windy Well/Banana Bunch #4 (Squawks sign)": 12518250,
    "Windy Well - Banana Bunch #4/Banana Bunch #4 (Squawks sign)": 12518250,
    "Castle Crush/Banana Bunch #1 (4-path)": 12518251,
    "Castle Crush - Banana Bunch #1/Banana Bunch #1 (4-path)": 12518251,
    "Castle Crush/Banana Bunch #2 (After falling Klampon)": 12518252,
    "Castle Crush - Banana Bunch #2/Banana Bunch #2 (After falling Klampon)": 12518252,
    "Castle Crush/Banana Bunch #3 (Rambi sign)": 12518253,
    "Castle Crush - Banana Bunch #3/Banana Bunch #3 (Rambi sign)": 12518253,
    "Castle Crush/Banana Bunch #4 (Next to O)": 12518254,
    "Castle Crush - Banana Bunch #4/Banana Bunch #4 (Next to O)": 12518254,
    "Castle Crush/Banana Bunch #5 (Above DK Coin)": 12518255,
    "Castle Crush - Banana Bunch #5/Banana Bunch #5 (Above DK Coin)": 12518255,
    "Castle Crush/Banana Bunch #6 (Above Zinger before goal)": 12518256,
    "Castle Crush - Banana Bunch #6/Banana Bunch #6 (Above Zinger before goal)": 12518256,
    "Clapper's Cavern/Banana Bunch #1 (Behind Shuri)": 12518257,
    "Clapper's Cavern - Banana Bunch #1/Banana Bunch #1 (Behind Shuri)": 12518257,
    "Clapper's Cavern/Banana Bunch #2 (Behind Shuri)": 12518258,
    "Clapper's Cavern - Banana Bunch #2/Banana Bunch #2 (Behind Shuri)": 12518258,
    "Clapper's Cavern/Banana Bunch #3 (Behind Shuri)": 12518259,
    "Clapper's Cavern - Banana Bunch #3/Banana Bunch #3 (Behind Shuri)": 12518259,
    "Clapper's Cavern/Banana Bunch #4 (Enguarde sign)": 12518260,
    "Clapper's Cavern - Banana Bunch #4/Banana Bunch #4 (Enguarde sign)": 12518260,
    "Chain Link Chamber/Banana Bunch #1 (Above Klinger)": 12518261,
    "Chain Link Chamber - Banana Bunch #1/Banana Bunch #1 (Above Klinger)": 12518261,
    "Chain Link Chamber/Banana Bunch #2 (Behind Krook)": 12518262,
    "Chain Link Chamber - Banana Bunch #2/Banana Bunch #2 (Behind Krook)": 12518262,
    "Chain Link Chamber/Banana Bunch #3 (Inside Bonus #1)": 12518263,
    "Chain Link Chamber - Bonus #1/Banana Bunch #3 (Inside Bonus #1)": 12518263,
    "Chain Link Chamber/Banana Bunch #4 (After Mini-Neckys path)": 12518264,
    "Chain Link Chamber - Banana Bunch #4/Banana Bunch #4 (After Mini-Neckys path)": 12518264,
    "Toxic Tower/Banana Bunch #1 (Left wall before first Zingers)": 12518265,
    "Toxic Tower - Banana Bunch #1/Banana Bunch #1 (Left wall before first Zingers)": 12518265,
    "Toxic Tower/Banana Bunch #2 (Left wall before first Zingers)": 12518266,
    "Toxic Tower - Banana Bunch #2/Banana Bunch #2 (Left wall before first Zingers)": 12518266,
    "Toxic Tower/Banana Bunch #3 (Left wall before first Zingers)": 12518267,
    "Toxic Tower - Banana Bunch #3/Banana Bunch #3 (Left wall before first Zingers)": 12518267,
    "Toxic Tower/Banana Bunch #4 (Left of banana guides)": 12518268,
    "Toxic Tower - Banana Bunch #4/Banana Bunch #4 (Left of banana guides)": 12518268,
    "Toxic Tower/Banana Bunch #5 (Left of banana guides)": 12518269,
    "Toxic Tower - Banana Bunch #5/Banana Bunch #5 (Left of banana guides)": 12518269,
    "Toxic Tower/Banana Bunch #6 (Left of banana guides)": 12518270,
    "Toxic Tower - Banana Bunch #6/Banana Bunch #6 (Left of banana guides)": 12518270,
    "Toxic Tower/Banana Bunch #7 (Passage after Zinger trio)": 12518271,
    "Toxic Tower - Banana Bunch #7/Banana Bunch #7 (Passage after Zinger trio)": 12518271,
    "Toxic Tower/Banana Bunch #8 (Passage below Zinger)": 12518272,
    "Toxic Tower - Banana Bunch #8/Banana Bunch #8 (Passage below Zinger)": 12518272,
    "Toxic Tower/Banana Bunch #9 (Passage below Zinger)": 12518273,
    "Toxic Tower - Banana Bunch #9/Banana Bunch #9 (Passage below Zinger)": 12518273,
    "Screech's Sprint/Banana Bunch #1 (Chest)": 12518274,
    "Screech's Sprint - Banana Bunch #1/Banana Bunch #1 (Chest)": 12518274,
    "Screech's Sprint/Banana Bunch #2 (First race shortcut)": 12518275,
    "Screech's Sprint - Banana Bunch #2/Banana Bunch #2 (First race shortcut)": 12518275,
    "Screech's Sprint/Banana Bunch #3 (Behind Zinger)": 12518276,
    "Screech's Sprint - Banana Bunch #3/Banana Bunch #3 (Behind Zinger)": 12518276,
    "Screech's Sprint/Banana Bunch #4 (Next to banana trail)": 12518277,
    "Screech's Sprint - Banana Bunch #4/Banana Bunch #4 (Next to banana trail)": 12518277,
    "Screech's Sprint/Banana Bunch #5 (Next to banana trail)": 12518278,
    "Screech's Sprint - Banana Bunch #5/Banana Bunch #5 (Next to banana trail)": 12518278,
    "Screech's Sprint/Banana Bunch #6 (Corner)": 12518279,
    "Screech's Sprint - Banana Bunch #6/Banana Bunch #6 (Corner)": 12518279,
    "Jungle Jinx/Banana Bunch #1 (Start)": 12518280,
    "Jungle Jinx - Banana Bunch #1/Banana Bunch #1 (Start)": 12518280,
    "Jungle Jinx/Banana Bunch #2 (Above Zinger)": 12518281,
    "Jungle Jinx - Banana Bunch #2/Banana Bunch #2 (Above Zinger)": 12518281,
    "Black Ice Battle/Banana Bunch #1 (Behind Krook)": 12518282,
    "Black Ice Battle - Banana Bunch #1/Banana Bunch #1 (Behind Krook)": 12518282,
    "Black Ice Battle/Banana Bunch #2 (4-path left)": 12518283,
    "Black Ice Battle - Banana Bunch #2/Banana Bunch #2 (4-path left)": 12518283,
    "Black Ice Battle/Banana Bunch #3 (Next to G)": 12518284,
    "Black Ice Battle - Banana Bunch #3/Banana Bunch #3 (Next to G)": 12518284,
    "Klobber Karnage/Banana Bunch #1 (Above spikes)": 12518285,
    "Klobber Karnage - Banana Bunch #1/Banana Bunch #1 (Above spikes)": 12518285,
    "Klobber Karnage/Banana Bunch #2 (Ledge between spikes)": 12518286,
    "Klobber Karnage - Banana Bunch #2/Banana Bunch #2 (Ledge between spikes)": 12518286,
    "Klobber Karnage/Banana Bunch #3 (Above spikes after Kong barrels)": 12518287,
    "Klobber Karnage - Banana Bunch #3/Banana Bunch #3 (Above spikes after Kong barrels)": 12518287,
    "Klobber Karnage/Banana Bunch #4 (After O)": 12518288,
    "Klobber Karnage - Banana Bunch #4/Banana Bunch #4 (After O)": 12518288,
    "Klobber Karnage/Banana Bunch #5 (Dixie barrel on split path)": 12518289,
    "Klobber Karnage - Banana Bunch #5/Banana Bunch #5 (Dixie barrel on split path)": 12518289,
    "Klobber Karnage/Banana Bunch #6 (Diddy barrel on split path)": 12518290,
    "Klobber Karnage - Banana Bunch #6/Banana Bunch #6 (Diddy barrel on split path)": 12518290,
    "Klobber Karnage/Banana Bunch #7 (After N)": 12518291,
    "Klobber Karnage - Banana Bunch #7/Banana Bunch #7 (After N)": 12518291,
    "Fiery Furnace/Banana Bunch #1 (Above start)": 12518292,
    "Fiery Furnace - Banana Bunch #1/Banana Bunch #1 (Above start)": 12518292,
    "Fiery Furnace/Banana Bunch #2 (Above start)": 12518293,
    "Fiery Furnace - Banana Bunch #2/Banana Bunch #2 (Above start)": 12518293,
    "Fiery Furnace/Banana Bunch #3 (Above start)": 12518294,
    "Fiery Furnace - Banana Bunch #3/Banana Bunch #3 (Above start)": 12518294,
    "Fiery Furnace/Banana Bunch #4 (Below Zinger duo)": 12518295,
    "Fiery Furnace - Banana Bunch #4/Banana Bunch #4 (Below Zinger duo)": 12518295,
    "Fiery Furnace/Banana Bunch #5 (Between moving Zingers)": 12518296,
    "Fiery Furnace - Banana Bunch #5/Banana Bunch #5 (Between moving Zingers)": 12518296,
    "Animal Antics/Banana Bunch #1 (Near Lockjaw trio)": 12518297,
    "Animal Antics - Banana Bunch #1/Banana Bunch #1 (Near Lockjaw trio)": 12518297,
    "Animal Antics/Banana Bunch #2 (Behind pillar)": 12518298,
    "Animal Antics - Banana Bunch #2/Banana Bunch #2 (Behind pillar)": 12518298,
    "Animal Antics/Banana Bunch #3 (Behind Zingers)": 12518299,
    "Animal Antics - Banana Bunch #3/Banana Bunch #3 (Behind Zingers)": 12518299,
    "Animal Antics/Banana Bunch #4 (Behind Zingers)": 12518300,
    "Animal Antics - Banana Bunch #4/Banana Bunch #4 (Behind Zingers)": 12518300,
}