import typing

from BaseClasses import Location
from .Names import LocationName

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from . import DKC2World

class DKC2Location(Location):
    game = "Donkey Kong Country 2"

    def __init__(self, player: int, name: str = '', address: int = None, parent=None):
        super().__init__(player, name, address, parent)

STARTING_ID = 0xBF0000

stage_clears = {
    LocationName.pirate_panic_clear:        STARTING_ID + 0x0000,
    LocationName.mainbrace_mayhem_clear:    STARTING_ID + 0x0001,
    LocationName.gangplank_galley_clear:    STARTING_ID + 0x0002,
    LocationName.lockjaws_locker_clear:     STARTING_ID + 0x0003,
    LocationName.topsail_trouble_clear:     STARTING_ID + 0x0004,
    LocationName.krows_nest_clear:          STARTING_ID + 0x0005,
    LocationName.hot_head_hop_clear:        STARTING_ID + 0x0006,
    LocationName.kannons_klaim_clear:       STARTING_ID + 0x0007,
    LocationName.lava_lagoon_clear:         STARTING_ID + 0x0008,
    LocationName.red_hot_ride_clear:        STARTING_ID + 0x0009,
    LocationName.squawks_shaft_clear:       STARTING_ID + 0x000A,
    LocationName.kleevers_kiln_clear:       STARTING_ID + 0x000B,
    LocationName.barrel_bayou_clear:        STARTING_ID + 0x000C,
    LocationName.glimmers_galleon_clear:    STARTING_ID + 0x000D,
    LocationName.krockhead_klamber_clear:   STARTING_ID + 0x000E,
    LocationName.rattle_battle_clear:       STARTING_ID + 0x000F,
    LocationName.slime_climb_clear:         STARTING_ID + 0x0010,
    LocationName.bramble_blast_clear:       STARTING_ID + 0x0011,
    LocationName.kudgels_kontest_clear:     STARTING_ID + 0x0012,
    LocationName.hornet_hole_clear:         STARTING_ID + 0x0013,
    LocationName.target_terror_clear:       STARTING_ID + 0x0014,
    LocationName.bramble_scramble_clear:    STARTING_ID + 0x0015,
    LocationName.rickety_race_clear:        STARTING_ID + 0x0016,
    LocationName.mudhole_marsh_clear:       STARTING_ID + 0x0017,
    LocationName.rambi_rumble_clear:        STARTING_ID + 0x0018,
    LocationName.king_zing_sting_clear:     STARTING_ID + 0x0019,
    LocationName.ghostly_grove_clear:       STARTING_ID + 0x001A,
    LocationName.haunted_hall_clear:        STARTING_ID + 0x001B,
    LocationName.gusty_glade_clear:         STARTING_ID + 0x001C,
    LocationName.parrot_chute_panic_clear:  STARTING_ID + 0x001D,
    LocationName.web_woods_clear:           STARTING_ID + 0x001F,
    LocationName.kreepy_krow_clear:         STARTING_ID + 0x0020,
    LocationName.arctic_abyss_clear:        STARTING_ID + 0x0021,
    LocationName.windy_well_clear:          STARTING_ID + 0x0022,
    LocationName.castle_crush_clear:        STARTING_ID + 0x0023,
    LocationName.clappers_cavern_clear:     STARTING_ID + 0x0024,
    LocationName.chain_link_chamber_clear:  STARTING_ID + 0x0025,
    LocationName.toxic_tower_clear:         STARTING_ID + 0x0026,
    LocationName.stronghold_showdown_clear: STARTING_ID + 0x0027,
    LocationName.screechs_sprint_clear:     STARTING_ID + 0x0028,
    #LocationName.k_rool_duel_clear:         STARTING_ID + 0x0029,
    LocationName.jungle_jinx_clear:         STARTING_ID + 0x002A,
    LocationName.black_ice_battle_clear:    STARTING_ID + 0x002B,
    LocationName.klobber_karnage_clear:     STARTING_ID + 0x002C,
    LocationName.fiery_furnace_clear:       STARTING_ID + 0x002D,
    LocationName.animal_antics_clear:       STARTING_ID + 0x002E,
    #LocationName.krocodile_core_clear:      STARTING_ID + 0x002F,
    LocationName.krow_defeated:             STARTING_ID + 0x0030,
    LocationName.kleever_defeated:          STARTING_ID + 0x0031,
    LocationName.kudgel_defeated:           STARTING_ID + 0x0032,
    LocationName.king_zing_defeated:        STARTING_ID + 0x0033,
    LocationName.kreepy_krow_defeated:      STARTING_ID + 0x0034,
}

stage_kong = {
    LocationName.pirate_panic_kong:        STARTING_ID + 0x0040,
    LocationName.mainbrace_mayhem_kong:    STARTING_ID + 0x0041,
    LocationName.gangplank_galley_kong:    STARTING_ID + 0x0042,
    LocationName.lockjaws_locker_kong:     STARTING_ID + 0x0043,
    LocationName.topsail_trouble_kong:     STARTING_ID + 0x0044,
    LocationName.hot_head_hop_kong:        STARTING_ID + 0x0045,
    LocationName.kannons_klaim_kong:       STARTING_ID + 0x0046,
    LocationName.lava_lagoon_kong:         STARTING_ID + 0x0047,
    LocationName.red_hot_ride_kong:        STARTING_ID + 0x0048,
    LocationName.squawks_shaft_kong:       STARTING_ID + 0x0049,
    LocationName.barrel_bayou_kong:        STARTING_ID + 0x004A,
    LocationName.glimmers_galleon_kong:    STARTING_ID + 0x004B,
    LocationName.krockhead_klamber_kong:   STARTING_ID + 0x004C,
    LocationName.rattle_battle_kong:       STARTING_ID + 0x004D,
    LocationName.slime_climb_kong:         STARTING_ID + 0x004E,
    LocationName.bramble_blast_kong:       STARTING_ID + 0x004F,
    LocationName.hornet_hole_kong:         STARTING_ID + 0x0050,
    LocationName.target_terror_kong:       STARTING_ID + 0x0051,
    LocationName.bramble_scramble_kong:    STARTING_ID + 0x0052,
    LocationName.rickety_race_kong:        STARTING_ID + 0x0053,
    LocationName.mudhole_marsh_kong:       STARTING_ID + 0x0054,
    LocationName.rambi_rumble_kong:        STARTING_ID + 0x0055,
    LocationName.ghostly_grove_kong:       STARTING_ID + 0x0056,
    LocationName.haunted_hall_kong:        STARTING_ID + 0x0057,
    LocationName.gusty_glade_kong:         STARTING_ID + 0x0058,
    LocationName.parrot_chute_panic_kong:  STARTING_ID + 0x0059,
    LocationName.web_woods_kong:           STARTING_ID + 0x005A,
    LocationName.arctic_abyss_kong:        STARTING_ID + 0x005B,
    LocationName.windy_well_kong:          STARTING_ID + 0x005C,
    LocationName.castle_crush_kong:        STARTING_ID + 0x005D,
    LocationName.clappers_cavern_kong:     STARTING_ID + 0x005E,
    LocationName.chain_link_chamber_kong:  STARTING_ID + 0x005F,
    LocationName.toxic_tower_kong:         STARTING_ID + 0x0060,
    LocationName.screechs_sprint_kong:     STARTING_ID + 0x0061,
    LocationName.jungle_jinx_kong:         STARTING_ID + 0x0062,
    LocationName.black_ice_battle_kong:    STARTING_ID + 0x0063,
    LocationName.klobber_karnage_kong:     STARTING_ID + 0x0064,
    LocationName.fiery_furnace_kong:       STARTING_ID + 0x0065,
    LocationName.animal_antics_kong:       STARTING_ID + 0x0066,
}

stage_dk_coin = {
    LocationName.pirate_panic_dk_coin:        STARTING_ID + 0x0080,
    LocationName.mainbrace_mayhem_dk_coin:    STARTING_ID + 0x0081,
    LocationName.gangplank_galley_dk_coin:    STARTING_ID + 0x0082,
    LocationName.lockjaws_locker_dk_coin:     STARTING_ID + 0x0083,
    LocationName.topsail_trouble_dk_coin:     STARTING_ID + 0x0084,
    LocationName.hot_head_hop_dk_coin:        STARTING_ID + 0x0085,
    LocationName.kannons_klaim_dk_coin:       STARTING_ID + 0x0086,
    LocationName.lava_lagoon_dk_coin:         STARTING_ID + 0x0087,
    LocationName.red_hot_ride_dk_coin:        STARTING_ID + 0x0088,
    LocationName.squawks_shaft_dk_coin:       STARTING_ID + 0x0089,
    LocationName.barrel_bayou_dk_coin:        STARTING_ID + 0x008A,
    LocationName.glimmers_galleon_dk_coin:    STARTING_ID + 0x008B,
    LocationName.krockhead_klamber_dk_coin:   STARTING_ID + 0x008C,
    LocationName.rattle_battle_dk_coin:       STARTING_ID + 0x008D,
    LocationName.slime_climb_dk_coin:         STARTING_ID + 0x008E,
    LocationName.bramble_blast_dk_coin:       STARTING_ID + 0x008F,
    LocationName.hornet_hole_dk_coin:         STARTING_ID + 0x0090,
    LocationName.target_terror_dk_coin:       STARTING_ID + 0x0091,
    LocationName.bramble_scramble_dk_coin:    STARTING_ID + 0x0092,
    LocationName.rickety_race_dk_coin:        STARTING_ID + 0x0093,
    LocationName.mudhole_marsh_dk_coin:       STARTING_ID + 0x0094,
    LocationName.rambi_rumble_dk_coin:        STARTING_ID + 0x0095,
    LocationName.ghostly_grove_dk_coin:       STARTING_ID + 0x0096,
    LocationName.haunted_hall_dk_coin:        STARTING_ID + 0x0097,
    LocationName.gusty_glade_dk_coin:         STARTING_ID + 0x0098,
    LocationName.parrot_chute_panic_dk_coin:  STARTING_ID + 0x0099,
    LocationName.web_woods_dk_coin:           STARTING_ID + 0x009A,
    LocationName.arctic_abyss_dk_coin:        STARTING_ID + 0x009B,
    LocationName.windy_well_dk_coin:          STARTING_ID + 0x009C,
    LocationName.castle_crush_dk_coin:        STARTING_ID + 0x009D,
    LocationName.clappers_cavern_dk_coin:     STARTING_ID + 0x009E,
    LocationName.chain_link_chamber_dk_coin:  STARTING_ID + 0x009F,
    LocationName.toxic_tower_dk_coin:         STARTING_ID + 0x00A0,
    LocationName.screechs_sprint_dk_coin:     STARTING_ID + 0x00A1,
    LocationName.jungle_jinx_dk_coin:         STARTING_ID + 0x00A2,
    LocationName.black_ice_battle_dk_coin:    STARTING_ID + 0x00A3,
    LocationName.klobber_karnage_dk_coin:     STARTING_ID + 0x00A4,
    LocationName.fiery_furnace_dk_coin:       STARTING_ID + 0x00A5,
    LocationName.animal_antics_dk_coin:       STARTING_ID + 0x00A6,
}

stage_bonus = {
    LocationName.pirate_panic_bonus_1:        STARTING_ID + 0x00C0,
    LocationName.pirate_panic_bonus_2:        STARTING_ID + 0x00C1,
    LocationName.mainbrace_mayhem_bonus_1:    STARTING_ID + 0x00C2,
    LocationName.mainbrace_mayhem_bonus_2:    STARTING_ID + 0x00C3,
    LocationName.mainbrace_mayhem_bonus_3:    STARTING_ID + 0x00C4,
    LocationName.gangplank_galley_bonus_1:    STARTING_ID + 0x00C5,
    LocationName.gangplank_galley_bonus_2:    STARTING_ID + 0x00C6,
    LocationName.lockjaws_locker_bonus_1:     STARTING_ID + 0x00C7,
    LocationName.topsail_trouble_bonus_1:     STARTING_ID + 0x00C8,
    LocationName.topsail_trouble_bonus_2:     STARTING_ID + 0x00C9,
    LocationName.hot_head_hop_bonus_1:        STARTING_ID + 0x00CA,
    LocationName.hot_head_hop_bonus_2:        STARTING_ID + 0x00CB,
    LocationName.hot_head_hop_bonus_3:        STARTING_ID + 0x00CC,
    LocationName.kannons_klaim_bonus_1:       STARTING_ID + 0x00CD,
    LocationName.kannons_klaim_bonus_2:       STARTING_ID + 0x00CE,
    LocationName.kannons_klaim_bonus_3:       STARTING_ID + 0x00CF,
    LocationName.lava_lagoon_bonus_1:         STARTING_ID + 0x00D0,
    LocationName.red_hot_ride_bonus_1:        STARTING_ID + 0x00D1,
    LocationName.red_hot_ride_bonus_2:        STARTING_ID + 0x00D2,
    LocationName.squawks_shaft_bonus_1:       STARTING_ID + 0x00D3,
    LocationName.squawks_shaft_bonus_2:       STARTING_ID + 0x00D4,
    LocationName.squawks_shaft_bonus_3:       STARTING_ID + 0x00D5,
    LocationName.barrel_bayou_bonus_1:        STARTING_ID + 0x00D6,
    LocationName.barrel_bayou_bonus_2:        STARTING_ID + 0x00D7,
    LocationName.glimmers_galleon_bonus_1:    STARTING_ID + 0x00D8,
    LocationName.glimmers_galleon_bonus_2:    STARTING_ID + 0x00D9,
    LocationName.krockhead_klamber_bonus_1:   STARTING_ID + 0x00DA,
    LocationName.rattle_battle_bonus_1:       STARTING_ID + 0x00DB,
    LocationName.rattle_battle_bonus_2:       STARTING_ID + 0x00DC,
    LocationName.rattle_battle_bonus_3:       STARTING_ID + 0x00DD,
    LocationName.slime_climb_bonus_1:         STARTING_ID + 0x00DE,
    LocationName.slime_climb_bonus_2:         STARTING_ID + 0x00DF,
    LocationName.bramble_blast_bonus_1:       STARTING_ID + 0x00E0,
    LocationName.bramble_blast_bonus_2:       STARTING_ID + 0x00E1,
    LocationName.hornet_hole_bonus_1:         STARTING_ID + 0x00E2,
    LocationName.hornet_hole_bonus_2:         STARTING_ID + 0x00E3,
    LocationName.hornet_hole_bonus_3:         STARTING_ID + 0x00E4,
    LocationName.target_terror_bonus_1:       STARTING_ID + 0x00E5,
    LocationName.target_terror_bonus_2:       STARTING_ID + 0x00E6,
    LocationName.bramble_scramble_bonus_1:    STARTING_ID + 0x00E7,
    LocationName.rickety_race_bonus_1:        STARTING_ID + 0x00E8,
    LocationName.mudhole_marsh_bonus_1:       STARTING_ID + 0x00E9,
    LocationName.mudhole_marsh_bonus_2:       STARTING_ID + 0x00EA,
    LocationName.rambi_rumble_bonus_1:        STARTING_ID + 0x00EB,
    LocationName.rambi_rumble_bonus_2:        STARTING_ID + 0x00EC,
    LocationName.ghostly_grove_bonus_1:       STARTING_ID + 0x00ED,
    LocationName.ghostly_grove_bonus_2:       STARTING_ID + 0x00EE,
    LocationName.haunted_hall_bonus_1:        STARTING_ID + 0x00EF,
    LocationName.haunted_hall_bonus_2:        STARTING_ID + 0x00F0,
    LocationName.haunted_hall_bonus_3:        STARTING_ID + 0x00F1,
    LocationName.gusty_glade_bonus_1:         STARTING_ID + 0x00F2,
    LocationName.gusty_glade_bonus_2:         STARTING_ID + 0x00F3,
    LocationName.parrot_chute_panic_bonus_1:  STARTING_ID + 0x00F4,
    LocationName.parrot_chute_panic_bonus_2:  STARTING_ID + 0x00F5,
    LocationName.web_woods_bonus_1:           STARTING_ID + 0x00F6,
    LocationName.web_woods_bonus_2:           STARTING_ID + 0x00F7,
    LocationName.arctic_abyss_bonus_1:        STARTING_ID + 0x00F8,
    LocationName.arctic_abyss_bonus_2:        STARTING_ID + 0x00F9,
    LocationName.windy_well_bonus_1:          STARTING_ID + 0x00FA,
    LocationName.windy_well_bonus_2:          STARTING_ID + 0x00FB,
    LocationName.castle_crush_bonus_1:        STARTING_ID + 0x00FC,
    LocationName.castle_crush_bonus_2:        STARTING_ID + 0x00FD,
    LocationName.clappers_cavern_bonus_1:     STARTING_ID + 0x00FE,
    LocationName.clappers_cavern_bonus_2:     STARTING_ID + 0x00FF,
    LocationName.chain_link_chamber_bonus_1:  STARTING_ID + 0x0100,
    LocationName.chain_link_chamber_bonus_2:  STARTING_ID + 0x0101,
    LocationName.toxic_tower_bonus_1:         STARTING_ID + 0x0102,
    LocationName.screechs_sprint_bonus_1:     STARTING_ID + 0x0103,
}

swanky_quiz = {
    LocationName.swanky_galleon_game_1:       STARTING_ID + 0x0140,
    LocationName.swanky_galleon_game_2:       STARTING_ID + 0x0141,
    LocationName.swanky_galleon_game_3:       STARTING_ID + 0x0142,
    LocationName.swanky_cauldron_game_1:      STARTING_ID + 0x0143,
    LocationName.swanky_cauldron_game_2:      STARTING_ID + 0x0144,
    LocationName.swanky_cauldron_game_3:      STARTING_ID + 0x0145,
    LocationName.swanky_quay_game_1:          STARTING_ID + 0x0146,
    LocationName.swanky_quay_game_2:          STARTING_ID + 0x0147,
    LocationName.swanky_quay_game_3:          STARTING_ID + 0x0148,
    LocationName.swanky_kremland_game_1:      STARTING_ID + 0x0149,
    LocationName.swanky_kremland_game_2:      STARTING_ID + 0x014A,
    LocationName.swanky_kremland_game_3:      STARTING_ID + 0x014B,
    LocationName.swanky_gulch_game_1:         STARTING_ID + 0x014C,
    LocationName.swanky_gulch_game_2:         STARTING_ID + 0x014D,
    LocationName.swanky_gulch_game_3:         STARTING_ID + 0x014E,
    LocationName.swanky_keep_game_1:          STARTING_ID + 0x014F,
    LocationName.swanky_keep_game_2:          STARTING_ID + 0x0150,
    LocationName.swanky_keep_game_3:          STARTING_ID + 0x0151,
}


balloonsanity = {
    LocationName.pirate_panic_red_balloon: STARTING_ID + 0x0400,
    LocationName.pirate_panic_green_balloon: STARTING_ID + 0x0401,
    LocationName.mainbrace_mayhem_green_balloon: STARTING_ID + 0x0402,
    LocationName.gangplank_galley_red_balloon_1: STARTING_ID + 0x0403,
    LocationName.gangplank_galley_red_balloon_2: STARTING_ID + 0x0404,
    LocationName.lockjaws_locker_red_balloon: STARTING_ID + 0x0405,
    LocationName.topsail_trouble_red_balloon_1: STARTING_ID + 0x0406,
    LocationName.topsail_trouble_red_balloon_2: STARTING_ID + 0x0407,
    LocationName.topsail_trouble_blue_balloon: STARTING_ID + 0x0408,
    LocationName.hot_head_hop_green_balloon: STARTING_ID + 0x0409,
    LocationName.hot_head_hop_red_balloon: STARTING_ID + 0x040A,
    LocationName.lava_lagoon_red_balloon_1: STARTING_ID + 0x040B,
    LocationName.squawks_shaft_red_balloon_1: STARTING_ID + 0x040C,
    LocationName.barrel_bayou_green_balloon: STARTING_ID + 0x040D,
    LocationName.glimmers_galleon_red_balloon: STARTING_ID + 0x040E,
    LocationName.krockhead_klamber_red_balloon_1: STARTING_ID + 0x040F,
    LocationName.krockhead_klamber_red_balloon_2: STARTING_ID + 0x0410,
    LocationName.bramble_blast_red_balloon: STARTING_ID + 0x0411,
    LocationName.hornet_hole_green_balloon_1: STARTING_ID + 0x0412,
    LocationName.hornet_hole_red_balloon_1: STARTING_ID + 0x0413,
    LocationName.target_terror_red_balloon: STARTING_ID + 0x0414,
    LocationName.bramble_scramble_blue_balloon: STARTING_ID + 0x0415,
    LocationName.bramble_scramble_red_balloon: STARTING_ID + 0x0416,
    LocationName.ghostly_grove_red_balloon: STARTING_ID + 0x0417,
    LocationName.gusty_glade_blue_balloon: STARTING_ID + 0x0418,
    LocationName.web_woods_green_balloon_1: STARTING_ID + 0x0419,
    LocationName.web_woods_green_balloon_2: STARTING_ID + 0x041A,
    LocationName.arctic_abyss_red_balloon_1: STARTING_ID + 0x041B,
    LocationName.arctic_abyss_red_balloon_2: STARTING_ID + 0x041C,
    LocationName.windy_well_red_balloon: STARTING_ID + 0x041D,
    LocationName.toxic_tower_green_balloon: STARTING_ID + 0x041E,
    LocationName.stronghold_showdown_red_balloon: STARTING_ID + 0x041F,
    LocationName.screechs_sprint_red_balloon: STARTING_ID + 0x0420,
    LocationName.black_ice_battle_red_balloon_1: STARTING_ID + 0x0421,
    LocationName.black_ice_battle_red_balloon_2: STARTING_ID + 0x0422,
    LocationName.black_ice_battle_red_balloon_3: STARTING_ID + 0x0423,
    LocationName.klobber_karnage_red_balloon: STARTING_ID + 0x0424,
    LocationName.animal_antics_red_balloon: STARTING_ID + 0x0425,
}
coinsanity = {
    LocationName.pirate_panic_banana_coin_1: STARTING_ID + 0x0200,
    LocationName.pirate_panic_banana_coin_2: STARTING_ID + 0x0201,
    LocationName.pirate_panic_banana_coin_3: STARTING_ID + 0x0202,
    LocationName.mainbrace_mayhem_banana_coin_1: STARTING_ID + 0x0203,
    LocationName.mainbrace_mayhem_banana_coin_2: STARTING_ID + 0x0204,
    LocationName.mainbrace_mayhem_banana_coin_3: STARTING_ID + 0x0205,
    LocationName.gangplank_galley_banana_coin_1: STARTING_ID + 0x0206,
    LocationName.gangplank_galley_banana_coin_2: STARTING_ID + 0x0207,
    LocationName.lockjaws_locker_banana_coin_1: STARTING_ID + 0x0208,
    LocationName.lockjaws_locker_banana_coin_2: STARTING_ID + 0x0209,
    LocationName.lockjaws_locker_banana_coin_3: STARTING_ID + 0x020A,
    LocationName.lockjaws_locker_banana_coin_4: STARTING_ID + 0x020B,
    LocationName.lockjaws_locker_banana_coin_5: STARTING_ID + 0x020C,
    LocationName.lockjaws_locker_banana_coin_6: STARTING_ID + 0x020D,
    LocationName.lockjaws_locker_banana_coin_7: STARTING_ID + 0x020E,
    LocationName.lockjaws_locker_banana_coin_8: STARTING_ID + 0x020F,
    LocationName.topsail_trouble_banana_coin_1: STARTING_ID + 0x0210,
    LocationName.topsail_trouble_banana_coin_2: STARTING_ID + 0x0211,
    LocationName.topsail_trouble_banana_coin_3: STARTING_ID + 0x0212,
    LocationName.topsail_trouble_banana_coin_4: STARTING_ID + 0x0213,
    LocationName.krows_nest_banana_coin_1: STARTING_ID + 0x0214,
    LocationName.krows_nest_banana_coin_2: STARTING_ID + 0x0215,
    LocationName.hot_head_hop_banana_coin_1: STARTING_ID + 0x0216,
    LocationName.hot_head_hop_banana_coin_2: STARTING_ID + 0x0217,
    LocationName.hot_head_hop_banana_coin_3: STARTING_ID + 0x0218,
    LocationName.hot_head_hop_banana_coin_4: STARTING_ID + 0x0219,
    LocationName.kannons_klaim_banana_coin_1: STARTING_ID + 0x021A,
    LocationName.kannons_klaim_banana_coin_2: STARTING_ID + 0x021B,
    LocationName.kannons_klaim_banana_coin_3: STARTING_ID + 0x021C,
    LocationName.lava_lagoon_banana_coin_1: STARTING_ID + 0x021D,
    LocationName.lava_lagoon_banana_coin_2: STARTING_ID + 0x021E,
    LocationName.lava_lagoon_banana_coin_3: STARTING_ID + 0x021F,
    LocationName.lava_lagoon_banana_coin_4: STARTING_ID + 0x0220,
    LocationName.lava_lagoon_banana_coin_5: STARTING_ID + 0x0221,
    LocationName.lava_lagoon_banana_coin_6: STARTING_ID + 0x0222,
    LocationName.lava_lagoon_banana_coin_7: STARTING_ID + 0x0223,
    LocationName.lava_lagoon_banana_coin_8: STARTING_ID + 0x0224,
    LocationName.lava_lagoon_banana_coin_9: STARTING_ID + 0x0225,
    LocationName.lava_lagoon_banana_coin_10: STARTING_ID + 0x0226,
    LocationName.red_hot_ride_banana_coin_1: STARTING_ID + 0x0227,
    LocationName.red_hot_ride_banana_coin_2: STARTING_ID + 0x0228,
    LocationName.red_hot_ride_banana_coin_3: STARTING_ID + 0x0229,
    LocationName.red_hot_ride_banana_coin_4: STARTING_ID + 0x022A,
    LocationName.red_hot_ride_banana_coin_5: STARTING_ID + 0x022B,
    LocationName.red_hot_ride_banana_coin_6: STARTING_ID + 0x022C,
    LocationName.squawks_shaft_banana_coin_1: STARTING_ID + 0x022D,
    LocationName.squawks_shaft_banana_coin_2: STARTING_ID + 0x022E,
    LocationName.squawks_shaft_banana_coin_3: STARTING_ID + 0x022F,
    LocationName.squawks_shaft_banana_coin_4: STARTING_ID + 0x0230,
    LocationName.squawks_shaft_banana_coin_5: STARTING_ID + 0x0231,
    LocationName.squawks_shaft_banana_coin_6: STARTING_ID + 0x0232,
    LocationName.squawks_shaft_banana_coin_7: STARTING_ID + 0x0233,
    LocationName.kleevers_kiln_banana_coin_1: STARTING_ID + 0x0234,
    LocationName.kleevers_kiln_banana_coin_2: STARTING_ID + 0x0235,
    LocationName.barrel_bayou_banana_coin_1: STARTING_ID + 0x0236,
    LocationName.barrel_bayou_banana_coin_2: STARTING_ID + 0x0237,
    LocationName.glimmers_galleon_banana_coin_1: STARTING_ID + 0x0238,
    LocationName.glimmers_galleon_banana_coin_2: STARTING_ID + 0x0239,
    LocationName.glimmers_galleon_banana_coin_3: STARTING_ID + 0x023A,
    LocationName.glimmers_galleon_banana_coin_4: STARTING_ID + 0x023B,
    LocationName.glimmers_galleon_banana_coin_5: STARTING_ID + 0x023C,
    LocationName.glimmers_galleon_banana_coin_6: STARTING_ID + 0x023D,
    LocationName.glimmers_galleon_banana_coin_7: STARTING_ID + 0x023E,
    LocationName.glimmers_galleon_banana_coin_8: STARTING_ID + 0x023F,
    LocationName.glimmers_galleon_banana_coin_9: STARTING_ID + 0x0240,
    LocationName.glimmers_galleon_banana_coin_10: STARTING_ID + 0x0241,
    LocationName.krockhead_klamber_banana_coin_1: STARTING_ID + 0x0242,
    LocationName.krockhead_klamber_banana_coin_2: STARTING_ID + 0x0243,
    LocationName.krockhead_klamber_banana_coin_3: STARTING_ID + 0x0244,
    LocationName.rattle_battle_banana_coin_1: STARTING_ID + 0x0245,
    LocationName.rattle_battle_banana_coin_2: STARTING_ID + 0x0246,
    LocationName.rattle_battle_banana_coin_3: STARTING_ID + 0x0247,
    LocationName.slime_climb_banana_coin_1: STARTING_ID + 0x0248,
    LocationName.slime_climb_banana_coin_2: STARTING_ID + 0x0249,
    LocationName.slime_climb_banana_coin_3: STARTING_ID + 0x024A,
    LocationName.bramble_blast_banana_coin_1: STARTING_ID + 0x024B,
    LocationName.bramble_blast_banana_coin_2: STARTING_ID + 0x024C,
    LocationName.hornet_hole_banana_coin_1: STARTING_ID + 0x024D,
    LocationName.hornet_hole_banana_coin_2: STARTING_ID + 0x024E,
    LocationName.hornet_hole_banana_coin_3: STARTING_ID + 0x024F,
    LocationName.hornet_hole_banana_coin_4: STARTING_ID + 0x0250,
    LocationName.bramble_scramble_banana_coin_1: STARTING_ID + 0x0251,
    LocationName.bramble_scramble_banana_coin_2: STARTING_ID + 0x0252,
    LocationName.bramble_scramble_banana_coin_3: STARTING_ID + 0x0253,
    LocationName.bramble_scramble_banana_coin_4: STARTING_ID + 0x0254,
    LocationName.bramble_scramble_banana_coin_5: STARTING_ID + 0x0255,
    LocationName.bramble_scramble_banana_coin_6: STARTING_ID + 0x0256,
    LocationName.bramble_scramble_banana_coin_7: STARTING_ID + 0x0257,
    LocationName.bramble_scramble_banana_coin_8: STARTING_ID + 0x0258,
    LocationName.rickety_race_banana_coin: STARTING_ID + 0x0259,
    LocationName.mudhole_marsh_banana_coin_1: STARTING_ID + 0x025A,
    LocationName.mudhole_marsh_banana_coin_2: STARTING_ID + 0x025B,
    LocationName.mudhole_marsh_banana_coin_3: STARTING_ID + 0x025C,
    LocationName.mudhole_marsh_banana_coin_4: STARTING_ID + 0x025D,
    LocationName.mudhole_marsh_banana_coin_5: STARTING_ID + 0x025E,
    LocationName.rambi_rumble_banana_coin_1: STARTING_ID + 0x025F,
    LocationName.rambi_rumble_banana_coin_2: STARTING_ID + 0x0260,
    LocationName.king_zing_sting_banana_coin_1: STARTING_ID + 0x0261,
    LocationName.king_zing_sting_banana_coin_2: STARTING_ID + 0x0262,
    LocationName.ghostly_grove_banana_coin_1: STARTING_ID + 0x0263,
    LocationName.ghostly_grove_banana_coin_2: STARTING_ID + 0x0264,
    LocationName.haunted_hall_banana_coin_1: STARTING_ID + 0x0265,
    LocationName.haunted_hall_banana_coin_2: STARTING_ID + 0x0266,
    LocationName.haunted_hall_banana_coin_3: STARTING_ID + 0x0267,
    LocationName.gusty_glade_banana_coin_1: STARTING_ID + 0x0268,
    LocationName.gusty_glade_banana_coin_2: STARTING_ID + 0x0269,
    LocationName.gusty_glade_banana_coin_3: STARTING_ID + 0x026A,
    LocationName.parrot_chute_panic_banana_coin_1: STARTING_ID + 0x026B,
    LocationName.parrot_chute_panic_banana_coin_2: STARTING_ID + 0x026C,
    LocationName.parrot_chute_panic_banana_coin_3: STARTING_ID + 0x026D,
    LocationName.parrot_chute_panic_banana_coin_4: STARTING_ID + 0x026E,
    LocationName.parrot_chute_panic_banana_coin_5: STARTING_ID + 0x026F,
    LocationName.web_woods_banana_coin_1: STARTING_ID + 0x0270,
    LocationName.web_woods_banana_coin_2: STARTING_ID + 0x0271,
    LocationName.web_woods_banana_coin_3: STARTING_ID + 0x0272,
    LocationName.web_woods_banana_coin_4: STARTING_ID + 0x0273,
    LocationName.web_woods_banana_coin_5: STARTING_ID + 0x0274,
    LocationName.kreepy_krow_banana_coin_1: STARTING_ID + 0x0275,
    LocationName.kreepy_krow_banana_coin_2: STARTING_ID + 0x0276,
    LocationName.arctic_abyss_banana_coin_1: STARTING_ID + 0x0277,
    LocationName.arctic_abyss_banana_coin_2: STARTING_ID + 0x0278,
    LocationName.arctic_abyss_banana_coin_3: STARTING_ID + 0x0279,
    LocationName.arctic_abyss_banana_coin_4: STARTING_ID + 0x027A,
    LocationName.arctic_abyss_banana_coin_5: STARTING_ID + 0x027B,
    LocationName.windy_well_banana_coin_1: STARTING_ID + 0x027C,
    LocationName.windy_well_banana_coin_2: STARTING_ID + 0x027D,
    LocationName.windy_well_banana_coin_3: STARTING_ID + 0x027E,
    LocationName.windy_well_banana_coin_4: STARTING_ID + 0x027F,
    LocationName.castle_crush_banana_coin_1: STARTING_ID + 0x0280,
    LocationName.castle_crush_banana_coin_2: STARTING_ID + 0x0281,
    LocationName.castle_crush_banana_coin_3: STARTING_ID + 0x0282,
    LocationName.clappers_cavern_banana_coin_1: STARTING_ID + 0x0283,
    LocationName.clappers_cavern_banana_coin_2: STARTING_ID + 0x0284,
    LocationName.clappers_cavern_banana_coin_3: STARTING_ID + 0x0285,
    LocationName.clappers_cavern_banana_coin_4: STARTING_ID + 0x0286,
    LocationName.clappers_cavern_banana_coin_5: STARTING_ID + 0x0287,
    LocationName.chain_link_chamber_banana_coin_1: STARTING_ID + 0x0288,
    LocationName.chain_link_chamber_banana_coin_2: STARTING_ID + 0x0289,
    LocationName.chain_link_chamber_banana_coin_3: STARTING_ID + 0x028A,
    LocationName.chain_link_chamber_banana_coin_4: STARTING_ID + 0x028B,
    LocationName.toxic_tower_banana_coin_1: STARTING_ID + 0x028C,
    LocationName.toxic_tower_banana_coin_2: STARTING_ID + 0x028D,
    LocationName.toxic_tower_banana_coin_3: STARTING_ID + 0x028E,
    LocationName.toxic_tower_banana_coin_4: STARTING_ID + 0x028F,
    LocationName.toxic_tower_banana_coin_5: STARTING_ID + 0x0290,
    LocationName.stronghold_showdown_banana_coin_1: STARTING_ID + 0x0291,
    LocationName.stronghold_showdown_banana_coin_2: STARTING_ID + 0x0292,
    LocationName.screechs_sprint_banana_coin_1: STARTING_ID + 0x0293,
    LocationName.screechs_sprint_banana_coin_2: STARTING_ID + 0x0294,
    LocationName.screechs_sprint_banana_coin_3: STARTING_ID + 0x0295,
    LocationName.screechs_sprint_banana_coin_4: STARTING_ID + 0x0296,
    LocationName.screechs_sprint_banana_coin_5: STARTING_ID + 0x0297,
    LocationName.screechs_sprint_banana_coin_6: STARTING_ID + 0x0298,
    LocationName.screechs_sprint_banana_coin_7: STARTING_ID + 0x0299,
    LocationName.screechs_sprint_banana_coin_8: STARTING_ID + 0x029A,
    LocationName.jungle_jinx_banana_coin_1: STARTING_ID + 0x029B,
    LocationName.jungle_jinx_banana_coin_2: STARTING_ID + 0x029C,
    LocationName.jungle_jinx_banana_coin_3: STARTING_ID + 0x029D,
    LocationName.jungle_jinx_banana_coin_4: STARTING_ID + 0x029E,
    LocationName.jungle_jinx_banana_coin_5: STARTING_ID + 0x029F,
    LocationName.black_ice_battle_banana_coin_1: STARTING_ID + 0x02A0,
    LocationName.klobber_karnage_banana_coin_1: STARTING_ID + 0x02A1,
    LocationName.klobber_karnage_banana_coin_2: STARTING_ID + 0x02A2,
    LocationName.klobber_karnage_banana_coin_3: STARTING_ID + 0x02A3,
    LocationName.klobber_karnage_banana_coin_4: STARTING_ID + 0x02A4,
    LocationName.fiery_furnace_banana_coin_1: STARTING_ID + 0x02A5,
    LocationName.fiery_furnace_banana_coin_2: STARTING_ID + 0x02A6,
    LocationName.animal_antics_banana_coin_1: STARTING_ID + 0x02A7,
    LocationName.animal_antics_banana_coin_2: STARTING_ID + 0x02A8,
    LocationName.animal_antics_banana_coin_3: STARTING_ID + 0x02A9,
    LocationName.animal_antics_banana_coin_4: STARTING_ID + 0x02AA,
    LocationName.animal_antics_banana_coin_5: STARTING_ID + 0x02AB,
}
bananasanity = {
    LocationName.pirate_panic_banana_bunch_1: STARTING_ID + 0x0300,
    LocationName.mainbrace_mayhem_banana_bunch_1: STARTING_ID + 0x0301,
    LocationName.mainbrace_mayhem_banana_bunch_2: STARTING_ID + 0x0302,
    LocationName.mainbrace_mayhem_banana_bunch_3: STARTING_ID + 0x0303,
    LocationName.gangplank_galley_banana_bunch_1: STARTING_ID + 0x0304,
    LocationName.gangplank_galley_banana_bunch_2: STARTING_ID + 0x0305,
    LocationName.gangplank_galley_banana_bunch_3: STARTING_ID + 0x0306,
    LocationName.gangplank_galley_banana_bunch_4: STARTING_ID + 0x0307,
    LocationName.gangplank_galley_banana_bunch_5: STARTING_ID + 0x0308,
    LocationName.gangplank_galley_banana_bunch_6: STARTING_ID + 0x0309,
    LocationName.gangplank_galley_banana_bunch_7: STARTING_ID + 0x030A,
    LocationName.lockjaws_locker_banana_bunch_1: STARTING_ID + 0x030B,
    LocationName.lockjaws_locker_banana_bunch_2: STARTING_ID + 0x030C,
    LocationName.lockjaws_locker_banana_bunch_3: STARTING_ID + 0x030D,
    LocationName.lockjaws_locker_banana_bunch_4: STARTING_ID + 0x030E,
    LocationName.topsail_trouble_banana_bunch_1: STARTING_ID + 0x030F,
    LocationName.topsail_trouble_banana_bunch_2: STARTING_ID + 0x0310,
    LocationName.topsail_trouble_banana_bunch_3: STARTING_ID + 0x0311,
    LocationName.hot_head_hop_banana_bunch_1: STARTING_ID + 0x0312,
    LocationName.hot_head_hop_banana_bunch_2: STARTING_ID + 0x0313,
    LocationName.hot_head_hop_banana_bunch_3: STARTING_ID + 0x0314,
    LocationName.kannons_klaim_banana_bunch_1: STARTING_ID + 0x0315,
    LocationName.lava_lagoon_banana_bunch_1: STARTING_ID + 0x0316,
    LocationName.lava_lagoon_banana_bunch_2: STARTING_ID + 0x0317,
    LocationName.lava_lagoon_banana_bunch_3: STARTING_ID + 0x0318,
    LocationName.lava_lagoon_banana_bunch_4: STARTING_ID + 0x0319,
    LocationName.lava_lagoon_banana_bunch_5: STARTING_ID + 0x031A,
    LocationName.red_hot_ride_banana_bunch_1: STARTING_ID + 0x031B,
    LocationName.red_hot_ride_banana_bunch_2: STARTING_ID + 0x031C,
    LocationName.red_hot_ride_banana_bunch_3: STARTING_ID + 0x031D,
    LocationName.red_hot_ride_banana_bunch_4: STARTING_ID + 0x031E,
    LocationName.squawks_shaft_banana_bunch_1: STARTING_ID + 0x031F,
    LocationName.squawks_shaft_banana_bunch_2: STARTING_ID + 0x0320,
    LocationName.squawks_shaft_banana_bunch_3: STARTING_ID + 0x0321,
    LocationName.squawks_shaft_banana_bunch_4: STARTING_ID + 0x0322,
    LocationName.barrel_bayou_banana_bunch_1: STARTING_ID + 0x0323,
    LocationName.barrel_bayou_banana_bunch_2: STARTING_ID + 0x0324,
    LocationName.barrel_bayou_banana_bunch_3: STARTING_ID + 0x0325,
    LocationName.glimmers_galleon_banana_bunch_1: STARTING_ID + 0x0326,
    LocationName.glimmers_galleon_banana_bunch_2: STARTING_ID + 0x0327,
    LocationName.glimmers_galleon_banana_bunch_3: STARTING_ID + 0x0328,
    LocationName.glimmers_galleon_banana_bunch_4: STARTING_ID + 0x0329,
    LocationName.glimmers_galleon_banana_bunch_5: STARTING_ID + 0x032A,
    LocationName.glimmers_galleon_banana_bunch_6: STARTING_ID + 0x032B,
    LocationName.glimmers_galleon_banana_bunch_7: STARTING_ID + 0x032C,
    LocationName.glimmers_galleon_banana_bunch_8: STARTING_ID + 0x032D,
    LocationName.glimmers_galleon_banana_bunch_9: STARTING_ID + 0x032E,
    LocationName.glimmers_galleon_banana_bunch_10: STARTING_ID + 0x032F,
    LocationName.glimmers_galleon_banana_bunch_11: STARTING_ID + 0x0330,
    LocationName.glimmers_galleon_banana_bunch_12: STARTING_ID + 0x0331,
    LocationName.glimmers_galleon_banana_bunch_13: STARTING_ID + 0x0332,
    LocationName.glimmers_galleon_banana_bunch_14: STARTING_ID + 0x0333,
    LocationName.rattle_battle_banana_bunch_1: STARTING_ID + 0x0334,
    LocationName.rattle_battle_banana_bunch_2: STARTING_ID + 0x0335,
    LocationName.rattle_battle_banana_bunch_3: STARTING_ID + 0x0336,
    LocationName.rattle_battle_banana_bunch_4: STARTING_ID + 0x0337,
    LocationName.slime_climb_banana_bunch_1: STARTING_ID + 0x0338,
    LocationName.slime_climb_banana_bunch_2: STARTING_ID + 0x0339,
    LocationName.slime_climb_banana_bunch_3: STARTING_ID + 0x033A,
    LocationName.slime_climb_banana_bunch_4: STARTING_ID + 0x033B,
    LocationName.bramble_blast_banana_bunch_1: STARTING_ID + 0x033C,
    LocationName.bramble_blast_banana_bunch_2: STARTING_ID + 0x033D,
    LocationName.bramble_blast_banana_bunch_3: STARTING_ID + 0x033E,
    LocationName.bramble_blast_banana_bunch_4: STARTING_ID + 0x033F,
    LocationName.bramble_blast_banana_bunch_5: STARTING_ID + 0x0340,
    LocationName.bramble_blast_banana_bunch_6: STARTING_ID + 0x0341,
    LocationName.bramble_blast_banana_bunch_7: STARTING_ID + 0x0342,
    LocationName.bramble_blast_banana_bunch_8: STARTING_ID + 0x0343,
    LocationName.bramble_blast_banana_bunch_9: STARTING_ID + 0x0344,
    LocationName.hornet_hole_banana_bunch_1: STARTING_ID + 0x0345,
    LocationName.hornet_hole_banana_bunch_2: STARTING_ID + 0x0346,
    LocationName.hornet_hole_banana_bunch_3: STARTING_ID + 0x0347,
    LocationName.hornet_hole_banana_bunch_4: STARTING_ID + 0x0348,
    LocationName.hornet_hole_banana_bunch_5: STARTING_ID + 0x0349,
    LocationName.target_terror_banana_bunch_1: STARTING_ID + 0x034A,
    LocationName.target_terror_banana_bunch_2: STARTING_ID + 0x034B,
    LocationName.bramble_scramble_banana_bunch_1: STARTING_ID + 0x034C,
    LocationName.bramble_scramble_banana_bunch_2: STARTING_ID + 0x034D,
    LocationName.bramble_scramble_banana_bunch_3: STARTING_ID + 0x034E,
    LocationName.bramble_scramble_banana_bunch_4: STARTING_ID + 0x034F,
    LocationName.bramble_scramble_banana_bunch_5: STARTING_ID + 0x0350,
    LocationName.mudhole_marsh_banana_bunch_1: STARTING_ID + 0x0351,
    LocationName.rambi_rumble_banana_bunch_1: STARTING_ID + 0x0352,
    LocationName.rambi_rumble_banana_bunch_2: STARTING_ID + 0x0353,
    LocationName.rambi_rumble_banana_bunch_3: STARTING_ID + 0x0354,
    LocationName.ghostly_grove_banana_bunch_1: STARTING_ID + 0x0355,
    LocationName.ghostly_grove_banana_bunch_2: STARTING_ID + 0x0356,
    LocationName.ghostly_grove_banana_bunch_3: STARTING_ID + 0x0357,
    LocationName.ghostly_grove_banana_bunch_4: STARTING_ID + 0x0358,
    LocationName.haunted_hall_banana_bunch_1: STARTING_ID + 0x0359,
    LocationName.haunted_hall_banana_bunch_2: STARTING_ID + 0x035A,
    LocationName.parrot_chute_panic_banana_bunch_1: STARTING_ID + 0x035B,
    LocationName.parrot_chute_panic_banana_bunch_2: STARTING_ID + 0x035C,
    LocationName.web_woods_banana_bunch_1: STARTING_ID + 0x035D,
    LocationName.web_woods_banana_bunch_2: STARTING_ID + 0x035E,
    LocationName.web_woods_banana_bunch_3: STARTING_ID + 0x035F,
    LocationName.arctic_abyss_banana_bunch_1: STARTING_ID + 0x0360,
    LocationName.arctic_abyss_banana_bunch_2: STARTING_ID + 0x0361,
    LocationName.arctic_abyss_banana_bunch_3: STARTING_ID + 0x0362,
    LocationName.arctic_abyss_banana_bunch_4: STARTING_ID + 0x0363,
    LocationName.arctic_abyss_banana_bunch_5: STARTING_ID + 0x0364,
    LocationName.arctic_abyss_banana_bunch_6: STARTING_ID + 0x0365,
    LocationName.arctic_abyss_banana_bunch_7: STARTING_ID + 0x0366,
    LocationName.windy_well_banana_bunch_1: STARTING_ID + 0x0367,
    LocationName.windy_well_banana_bunch_2: STARTING_ID + 0x0368,
    LocationName.windy_well_banana_bunch_3: STARTING_ID + 0x0369,
    LocationName.windy_well_banana_bunch_4: STARTING_ID + 0x036A,
    LocationName.castle_crush_banana_bunch_1: STARTING_ID + 0x036B,
    LocationName.castle_crush_banana_bunch_2: STARTING_ID + 0x036C,
    LocationName.castle_crush_banana_bunch_3: STARTING_ID + 0x036D,
    LocationName.castle_crush_banana_bunch_4: STARTING_ID + 0x036E,
    LocationName.castle_crush_banana_bunch_5: STARTING_ID + 0x036F,
    LocationName.castle_crush_banana_bunch_6: STARTING_ID + 0x0370,
    LocationName.clappers_cavern_banana_bunch_1: STARTING_ID + 0x0371,
    LocationName.clappers_cavern_banana_bunch_2: STARTING_ID + 0x0372,
    LocationName.clappers_cavern_banana_bunch_3: STARTING_ID + 0x0373,
    LocationName.clappers_cavern_banana_bunch_4: STARTING_ID + 0x0374,
    LocationName.chain_link_chamber_banana_bunch_1: STARTING_ID + 0x0375,
    LocationName.chain_link_chamber_banana_bunch_2: STARTING_ID + 0x0376,
    LocationName.chain_link_chamber_banana_bunch_3: STARTING_ID + 0x0377,
    LocationName.chain_link_chamber_banana_bunch_4: STARTING_ID + 0x0378,
    LocationName.toxic_tower_banana_bunch_1: STARTING_ID + 0x0379,
    LocationName.toxic_tower_banana_bunch_2: STARTING_ID + 0x037A,
    LocationName.toxic_tower_banana_bunch_3: STARTING_ID + 0x037B,
    LocationName.toxic_tower_banana_bunch_4: STARTING_ID + 0x037C,
    LocationName.toxic_tower_banana_bunch_5: STARTING_ID + 0x037D,
    LocationName.toxic_tower_banana_bunch_6: STARTING_ID + 0x037E,
    LocationName.toxic_tower_banana_bunch_7: STARTING_ID + 0x037F,
    LocationName.toxic_tower_banana_bunch_8: STARTING_ID + 0x0380,
    LocationName.toxic_tower_banana_bunch_9: STARTING_ID + 0x0381,
    LocationName.screechs_sprint_banana_bunch_1: STARTING_ID + 0x0382,
    LocationName.screechs_sprint_banana_bunch_2: STARTING_ID + 0x0383,
    LocationName.screechs_sprint_banana_bunch_3: STARTING_ID + 0x0384,
    LocationName.screechs_sprint_banana_bunch_4: STARTING_ID + 0x0385,
    LocationName.screechs_sprint_banana_bunch_5: STARTING_ID + 0x0386,
    LocationName.screechs_sprint_banana_bunch_6: STARTING_ID + 0x0387,
    LocationName.jungle_jinx_banana_bunch_1: STARTING_ID + 0x0388,
    LocationName.jungle_jinx_banana_bunch_2: STARTING_ID + 0x0389,
    LocationName.black_ice_battle_banana_bunch_1: STARTING_ID + 0x038A,
    LocationName.black_ice_battle_banana_bunch_2: STARTING_ID + 0x038B,
    LocationName.black_ice_battle_banana_bunch_3: STARTING_ID + 0x038C,
    LocationName.klobber_karnage_banana_bunch_1: STARTING_ID + 0x038D,
    LocationName.klobber_karnage_banana_bunch_2: STARTING_ID + 0x038E,
    LocationName.klobber_karnage_banana_bunch_3: STARTING_ID + 0x038F,
    LocationName.klobber_karnage_banana_bunch_4: STARTING_ID + 0x0390,
    LocationName.klobber_karnage_banana_bunch_5: STARTING_ID + 0x0391,
    LocationName.klobber_karnage_banana_bunch_6: STARTING_ID + 0x0392,
    LocationName.klobber_karnage_banana_bunch_7: STARTING_ID + 0x0393,
    LocationName.fiery_furnace_banana_bunch_1: STARTING_ID + 0x0394,
    LocationName.fiery_furnace_banana_bunch_2: STARTING_ID + 0x0395,
    LocationName.fiery_furnace_banana_bunch_3: STARTING_ID + 0x0396,
    LocationName.fiery_furnace_banana_bunch_4: STARTING_ID + 0x0397,
    LocationName.fiery_furnace_banana_bunch_5: STARTING_ID + 0x0398,
    LocationName.animal_antics_banana_bunch_1: STARTING_ID + 0x0399,
    LocationName.animal_antics_banana_bunch_2: STARTING_ID + 0x039A,
    LocationName.animal_antics_banana_bunch_3: STARTING_ID + 0x039B,
    LocationName.animal_antics_banana_bunch_4: STARTING_ID + 0x039C,
}

all_locations = {
    **stage_clears,
    **stage_dk_coin,
    **stage_kong,
    **stage_bonus,
    **balloonsanity,
    **coinsanity,
    **bananasanity,
    **swanky_quiz,
}

#location_table = {}


location_groups = {
    "Pirate Panic": {location for location in all_locations.keys() if "Pirate Panic" in location},
    "Mainbrace Mayhem": {location for location in all_locations.keys() if "Mainbrace Mayhem" in location},
    "Gangplank Galley": {location for location in all_locations.keys() if "Gangplank Galley" in location},
    "Lockjaw's Locker": {location for location in all_locations.keys() if "Lockjaw's Locker" in location},
    "Topsail Trouble": {location for location in all_locations.keys() if "Topsail Trouble" in location},
    "Krow's Nest": {location for location in all_locations.keys() if "Krow's Nest" in location},
    "Hot-Head Hop": {location for location in all_locations.keys() if "Hot-Head Hop" in location},
    "Kannon's Klaim": {location for location in all_locations.keys() if "Kannon's Klaim" in location},
    "Lava Lagoon": {location for location in all_locations.keys() if "Lava Lagoon" in location},
    "Red-Hot Ride": {location for location in all_locations.keys() if "Red-Hot Ride" in location},
    "Squawks's Shaft": {location for location in all_locations.keys() if "Squawks's Shaft" in location},
    "Kleever's Kiln": {location for location in all_locations.keys() if "Kleever's Kiln" in location},
    "Barrel Bayou": {location for location in all_locations.keys() if "Barrel Bayou" in location},
    "Glimmer's Galleon": {location for location in all_locations.keys() if "Glimmer's Galleon" in location},
    "Krockhead Klamber": {location for location in all_locations.keys() if "Krockhead Klamber" in location},
    "Rattle Battle": {location for location in all_locations.keys() if "Rattle Battle" in location},
    "Slime Climb": {location for location in all_locations.keys() if "Slime Climb" in location},
    "Bramble Blast": {location for location in all_locations.keys() if "Bramble Blast" in location},
    "Kudgel's Kontest": {location for location in all_locations.keys() if "Kudgel's Kontest" in location},
    "Hornet Hole": {location for location in all_locations.keys() if "Hornet Hole" in location},
    "Target Terror": {location for location in all_locations.keys() if "Target Terror" in location},
    "Bramble Scramble": {location for location in all_locations.keys() if "Bramble Scramble" in location},
    "Rickety Race": {location for location in all_locations.keys() if "Rickety Race" in location},
    "Mudhole Marsh": {location for location in all_locations.keys() if "Mudhole Marsh" in location},
    "Rambi Rumble": {location for location in all_locations.keys() if "Rambi Rumble" in location},
    "King Zing Sting": {location for location in all_locations.keys() if "King Zing Sting" in location},
    "Haunted Hall": {location for location in all_locations.keys() if "Haunted Hall" in location},
    "Gusty Glade": {location for location in all_locations.keys() if "Gusty Glade" in location},
    "Parrot Chute Panic": {location for location in all_locations.keys() if "Parrot Chute Panic" in location},
    "Web Woods": {location for location in all_locations.keys() if "Web Woods" in location},
    "Kreepy Krow": {location for location in all_locations.keys() if "Kreepy Krow" in location},
    "Arctic Abyss": {location for location in all_locations.keys() if "Arctic Abyss" in location},
    "Windy Well": {location for location in all_locations.keys() if "Windy Well" in location},
    "Castle Crush": {location for location in all_locations.keys() if "Castle Crush" in location},
    "Clapper's Cavern": {location for location in all_locations.keys() if "Clapper's Cavern" in location},
    "Chain Link Chamber": {location for location in all_locations.keys() if "Chain Link Chamber" in location},
    "Toxic Tower": {location for location in all_locations.keys() if "Toxic Tower" in location},
    "Stronghold Showdown": {location for location in all_locations.keys() if "Stronghold Showdown" in location},
    "Screech's Sprint": {location for location in all_locations.keys() if "Screech's Sprint" in location},
    "Jungle Jinx": {location for location in all_locations.keys() if "Jungle Jinx" in location},
    "Black Ice Battle": {location for location in all_locations.keys() if "Black Ice Battle" in location},
    "Klobber Karnage": {location for location in all_locations.keys() if "Klobber Karnage" in location},
    "Fiery Furnace": {location for location in all_locations.keys() if "Fiery Furnace" in location},
    "Animal Antics": {location for location in all_locations.keys() if "Animal Antics" in location},
    "Swanky": {location for location in all_locations.keys() if "Swanky" in location},
}

def setup_locations(world: "DKC2World"):
    location_table = {
        **stage_clears,
        **stage_bonus,
    }

    if world.options.dk_coin_checks:
        location_table.update(stage_dk_coin)
    if world.options.kong_checks:
        location_table.update(stage_kong)
    if world.options.swanky_checks:
        location_table.update(swanky_quiz)
    if world.options.balloonsanity:
        location_table.update(balloonsanity)
    if world.options.coinsanity:
        location_table.update(coinsanity)
    if world.options.bananasanity:
        location_table.update(bananasanity)

    return location_table

lookup_id_to_name: typing.Dict[int, str] = {id: name for name, _ in all_locations.items()}
