from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from . import DKC2World

from .Names import RegionName, LocationName, EventName


# Data format: location_type, data
location_id_to_level_id = {
    LocationName.pirate_panic_clear:        [0x00, 0x03],
    LocationName.mainbrace_mayhem_clear:    [0x00, 0x0C],
    LocationName.gangplank_galley_clear:    [0x00, 0x04],
    LocationName.lockjaws_locker_clear:     [0x00, 0x15],
    LocationName.topsail_trouble_clear:     [0x00, 0x0B],
    LocationName.krows_nest_clear:          [0x00, 0x09],
    LocationName.hot_head_hop_clear:        [0x00, 0x07],
    LocationName.kannons_klaim_clear:       [0x00, 0x25],
    LocationName.lava_lagoon_clear:         [0x00, 0x14],
    LocationName.red_hot_ride_clear:        [0x00, 0x08],
    LocationName.squawks_shaft_clear:       [0x00, 0x24],
    LocationName.kleevers_kiln_clear:       [0x00, 0x21],
    LocationName.barrel_bayou_clear:        [0x00, 0x28],
    LocationName.glimmers_galleon_clear:    [0x00, 0x01],
    LocationName.krockhead_klamber_clear:   [0x00, 0x29],
    LocationName.rattle_battle_clear:       [0x00, 0x05],
    LocationName.slime_climb_clear:         [0x00, 0x0A],
    LocationName.bramble_blast_clear:       [0x00, 0x2D],
    LocationName.kudgels_kontest_clear:     [0x00, 0x63],
    LocationName.hornet_hole_clear:         [0x00, 0x11],
    LocationName.target_terror_clear:       [0x00, 0x0E],
    LocationName.bramble_scramble_clear:    [0x00, 0x2E],
    LocationName.rickety_race_clear:        [0x00, 0x0F],
    LocationName.mudhole_marsh_clear:       [0x00, 0x2C],
    LocationName.rambi_rumble_clear:        [0x00, 0x02],
    LocationName.king_zing_sting_clear:     [0x00, 0x60],
    LocationName.ghostly_grove_clear:       [0x00, 0x19],
    LocationName.haunted_hall_clear:        [0x00, 0x10],
    LocationName.gusty_glade_clear:         [0x00, 0x18],
    LocationName.parrot_chute_panic_clear:  [0x00, 0x13],
    LocationName.web_woods_clear:           [0x00, 0x17],
    LocationName.kreepy_krow_clear:         [0x00, 0x0D],
    LocationName.arctic_abyss_clear:        [0x00, 0x6C],
    LocationName.windy_well_clear:          [0x00, 0x23],
    LocationName.castle_crush_clear:        [0x00, 0x62],
    LocationName.clappers_cavern_clear:     [0x00, 0x8F],
    LocationName.chain_link_chamber_clear:  [0x00, 0x6D],
    LocationName.toxic_tower_clear:         [0x00, 0x6E],
    LocationName.stronghold_showdown_clear: [0x03, 0xB9],
    LocationName.screechs_sprint_clear:     [0x00, 0x2F],
    LocationName.jungle_jinx_clear:         [0x00, 0x99],
    LocationName.black_ice_battle_clear:    [0x00, 0x96],
    LocationName.klobber_karnage_clear:     [0x00, 0x80],
    LocationName.fiery_furnace_clear:       [0x00, 0x16],
    LocationName.animal_antics_clear:       [0x00, 0x9A],

    LocationName.krow_defeated:             [0x00, 0x09],
    LocationName.kleever_defeated:          [0x00, 0x21],
    LocationName.kudgel_defeated:           [0x00, 0x63],
    LocationName.king_zing_defeated:        [0x00, 0x60],
    LocationName.kreepy_krow_defeated:      [0x00, 0x0D],
    
    LocationName.pirate_panic_kong:        [0x01, 0x03],
    LocationName.mainbrace_mayhem_kong:    [0x01, 0x0C],
    LocationName.gangplank_galley_kong:    [0x01, 0x04],
    LocationName.lockjaws_locker_kong:     [0x01, 0x15],
    LocationName.topsail_trouble_kong:     [0x01, 0x0B],
    LocationName.hot_head_hop_kong:        [0x01, 0x07],
    LocationName.kannons_klaim_kong:       [0x01, 0x25],
    LocationName.lava_lagoon_kong:         [0x01, 0x14],
    LocationName.red_hot_ride_kong:        [0x01, 0x08],
    LocationName.squawks_shaft_kong:       [0x01, 0x24],
    LocationName.barrel_bayou_kong:        [0x01, 0x28],
    LocationName.glimmers_galleon_kong:    [0x01, 0x01],
    LocationName.krockhead_klamber_kong:   [0x01, 0x29],
    LocationName.rattle_battle_kong:       [0x01, 0x05],
    LocationName.slime_climb_kong:         [0x01, 0x0A],
    LocationName.bramble_blast_kong:       [0x01, 0x2D],
    LocationName.hornet_hole_kong:         [0x01, 0x11],
    LocationName.target_terror_kong:       [0x01, 0x0E],
    LocationName.bramble_scramble_kong:    [0x01, 0x2E],
    LocationName.rickety_race_kong:        [0x01, 0x0F],
    LocationName.mudhole_marsh_kong:       [0x01, 0x2C],
    LocationName.rambi_rumble_kong:        [0x01, 0x02],
    LocationName.ghostly_grove_kong:       [0x01, 0x19],
    LocationName.haunted_hall_kong:        [0x01, 0x10],
    LocationName.gusty_glade_kong:         [0x01, 0x18],
    LocationName.parrot_chute_panic_kong:  [0x01, 0x13],
    LocationName.web_woods_kong:           [0x01, 0x17],
    LocationName.arctic_abyss_kong:        [0x01, 0x6C],
    LocationName.windy_well_kong:          [0x01, 0x23],
    LocationName.castle_crush_kong:        [0x01, 0x62],
    LocationName.clappers_cavern_kong:     [0x01, 0x8F],
    LocationName.chain_link_chamber_kong:  [0x01, 0x6D],
    LocationName.toxic_tower_kong:         [0x01, 0x6E],
    LocationName.screechs_sprint_kong:     [0x01, 0x2F],
    LocationName.jungle_jinx_kong:         [0x01, 0x99],
    LocationName.black_ice_battle_kong:    [0x01, 0x96],
    LocationName.klobber_karnage_kong:     [0x01, 0x80],
    LocationName.fiery_furnace_kong:       [0x01, 0x16],
    LocationName.animal_antics_kong:       [0x01, 0x9A],
    
    LocationName.pirate_panic_dk_coin:        [0x02, 0x03],
    LocationName.mainbrace_mayhem_dk_coin:    [0x02, 0x0C],
    LocationName.gangplank_galley_dk_coin:    [0x02, 0x04],
    LocationName.lockjaws_locker_dk_coin:     [0x02, 0x15],
    LocationName.topsail_trouble_dk_coin:     [0x02, 0x0B],
    LocationName.hot_head_hop_dk_coin:        [0x02, 0x07],
    LocationName.kannons_klaim_dk_coin:       [0x02, 0x25],
    LocationName.lava_lagoon_dk_coin:         [0x02, 0x14],
    LocationName.red_hot_ride_dk_coin:        [0x02, 0x08],
    LocationName.squawks_shaft_dk_coin:       [0x02, 0x24],
    LocationName.barrel_bayou_dk_coin:        [0x02, 0x28],
    LocationName.glimmers_galleon_dk_coin:    [0x02, 0x01],
    LocationName.krockhead_klamber_dk_coin:   [0x02, 0x29],
    LocationName.rattle_battle_dk_coin:       [0x02, 0x05],
    LocationName.slime_climb_dk_coin:         [0x02, 0x0A],
    LocationName.bramble_blast_dk_coin:       [0x02, 0x2D],
    LocationName.hornet_hole_dk_coin:         [0x02, 0x11],
    LocationName.target_terror_dk_coin:       [0x02, 0x0E],
    LocationName.bramble_scramble_dk_coin:    [0x02, 0x2E],
    LocationName.rickety_race_dk_coin:        [0x02, 0x0F],
    LocationName.mudhole_marsh_dk_coin:       [0x02, 0x2C],
    LocationName.rambi_rumble_dk_coin:        [0x02, 0x02],
    LocationName.ghostly_grove_dk_coin:       [0x02, 0x19],
    LocationName.haunted_hall_dk_coin:        [0x02, 0x10],
    LocationName.gusty_glade_dk_coin:         [0x02, 0x18],
    LocationName.parrot_chute_panic_dk_coin:  [0x02, 0x13],
    LocationName.web_woods_dk_coin:           [0x02, 0x17],
    LocationName.arctic_abyss_dk_coin:        [0x02, 0x6C],
    LocationName.windy_well_dk_coin:          [0x02, 0x23],
    LocationName.castle_crush_dk_coin:        [0x02, 0x62],
    LocationName.clappers_cavern_dk_coin:     [0x02, 0x8F],
    LocationName.chain_link_chamber_dk_coin:  [0x02, 0x6D],
    LocationName.toxic_tower_dk_coin:         [0x02, 0x6E],
    LocationName.screechs_sprint_dk_coin:     [0x02, 0x2F],
    LocationName.jungle_jinx_dk_coin:         [0x02, 0x99],
    LocationName.black_ice_battle_dk_coin:    [0x02, 0x96],
    LocationName.klobber_karnage_dk_coin:     [0x02, 0x80],
    LocationName.fiery_furnace_dk_coin:       [0x02, 0x16],
    LocationName.animal_antics_dk_coin:       [0x02, 0x9A],
    
    LocationName.pirate_panic_bonus_1:        [0x03, 0x6F],
    LocationName.pirate_panic_bonus_2:        [0x03, 0x70],
    LocationName.mainbrace_mayhem_bonus_1:    [0x03, 0x78],
    LocationName.mainbrace_mayhem_bonus_2:    [0x03, 0x79],
    LocationName.mainbrace_mayhem_bonus_3:    [0x03, 0x7D],
    LocationName.gangplank_galley_bonus_1:    [0x03, 0xA8],
    LocationName.gangplank_galley_bonus_2:    [0x03, 0x71],
    LocationName.lockjaws_locker_bonus_1:     [0x03, 0x81],
    LocationName.topsail_trouble_bonus_1:     [0x03, 0x7B],
    LocationName.topsail_trouble_bonus_2:     [0x03, 0x7C],
    LocationName.hot_head_hop_bonus_1:        [0x03, 0x75],
    LocationName.hot_head_hop_bonus_2:        [0x03, 0x1C],
    LocationName.hot_head_hop_bonus_3:        [0x03, 0x74],
    LocationName.kannons_klaim_bonus_1:       [0x03, 0xAB],
    LocationName.kannons_klaim_bonus_2:       [0x03, 0xAD],
    LocationName.kannons_klaim_bonus_3:       [0x03, 0xAA],
    LocationName.lava_lagoon_bonus_1:         [0x03, 0x83],
    LocationName.red_hot_ride_bonus_1:        [0x03, 0x76],
    LocationName.red_hot_ride_bonus_2:        [0x03, 0x77],
    LocationName.squawks_shaft_bonus_1:       [0x03, 0xAC],
    LocationName.squawks_shaft_bonus_2:       [0x03, 0xBA],
    LocationName.squawks_shaft_bonus_3:       [0x03, 0xA9],
    LocationName.barrel_bayou_bonus_1:        [0x03, 0x89],
    LocationName.barrel_bayou_bonus_2:        [0x03, 0x8A],
    LocationName.glimmers_galleon_bonus_1:    [0x03, 0x84],
    LocationName.glimmers_galleon_bonus_2:    [0x03, 0x82],
    LocationName.krockhead_klamber_bonus_1:   [0x03, 0x8B],
    LocationName.rattle_battle_bonus_1:       [0x03, 0x72],
    LocationName.rattle_battle_bonus_2:       [0x03, 0x7F],
    LocationName.rattle_battle_bonus_3:       [0x03, 0x73],
    LocationName.slime_climb_bonus_1:         [0x03, 0x7A],
    LocationName.slime_climb_bonus_2:         [0x03, 0x7E],
    LocationName.bramble_blast_bonus_1:       [0x03, 0xA6],
    LocationName.bramble_blast_bonus_2:       [0x03, 0xA0],
    LocationName.hornet_hole_bonus_1:         [0x03, 0xAE],
    LocationName.hornet_hole_bonus_2:         [0x03, 0xB3],
    LocationName.hornet_hole_bonus_3:         [0x03, 0xB0],
    LocationName.target_terror_bonus_1:       [0x03, 0xA1],
    LocationName.target_terror_bonus_2:       [0x03, 0xC1],
    LocationName.bramble_scramble_bonus_1:    [0x03, 0xA2],
    LocationName.rickety_race_bonus_1:        [0x03, 0xC3],
    LocationName.mudhole_marsh_bonus_1:       [0x03, 0x8C],
    LocationName.mudhole_marsh_bonus_2:       [0x03, 0x8D],
    LocationName.rambi_rumble_bonus_1:        [0x03, 0xB4],
    LocationName.rambi_rumble_bonus_2:        [0x03, 0xB2],
    LocationName.ghostly_grove_bonus_1:       [0x03, 0x85],
    LocationName.ghostly_grove_bonus_2:       [0x03, 0x88],
    LocationName.haunted_hall_bonus_1:        [0x03, 0xBD],
    LocationName.haunted_hall_bonus_2:        [0x03, 0xC2],
    LocationName.haunted_hall_bonus_3:        [0x03, 0xC0],
    LocationName.gusty_glade_bonus_1:         [0x03, 0x86],
    LocationName.gusty_glade_bonus_2:         [0x03, 0x87],
    LocationName.parrot_chute_panic_bonus_1:  [0x03, 0xB1],
    LocationName.parrot_chute_panic_bonus_2:  [0x03, 0xAF],
    LocationName.web_woods_bonus_1:           [0x03, 0xA4],
    LocationName.web_woods_bonus_2:           [0x03, 0xBC],
    LocationName.arctic_abyss_bonus_1:        [0x03, 0x93],
    LocationName.arctic_abyss_bonus_2:        [0x03, 0x95],
    LocationName.windy_well_bonus_1:          [0x03, 0xBB],
    LocationName.windy_well_bonus_2:          [0x03, 0xA3],
    LocationName.castle_crush_bonus_1:        [0x03, 0xB7],
    LocationName.castle_crush_bonus_2:        [0x03, 0xB8],
    LocationName.clappers_cavern_bonus_1:     [0x03, 0x91],
    LocationName.clappers_cavern_bonus_2:     [0x03, 0x92],
    LocationName.chain_link_chamber_bonus_1:  [0x03, 0xB5],
    LocationName.chain_link_chamber_bonus_2:  [0x03, 0xB6],
    LocationName.toxic_tower_bonus_1:         [0x03, 0xA5],
    LocationName.screechs_sprint_bonus_1:     [0x03, 0xA7],

    LocationName.swanky_galleon_game_1:       [0x04, 0x01],
    LocationName.swanky_galleon_game_2:       [0x04, 0x02],
    LocationName.swanky_galleon_game_3:       [0x04, 0x04],
    LocationName.swanky_cauldron_game_1:      [0x04, 0x11],
    LocationName.swanky_cauldron_game_2:      [0x04, 0x12],
    LocationName.swanky_cauldron_game_3:      [0x04, 0x14],
    LocationName.swanky_quay_game_1:          [0x04, 0x21],
    LocationName.swanky_quay_game_2:          [0x04, 0x22],
    LocationName.swanky_quay_game_3:          [0x04, 0x24],
    LocationName.swanky_kremland_game_1:      [0x04, 0x81],
    LocationName.swanky_kremland_game_2:      [0x04, 0x82],
    LocationName.swanky_kremland_game_3:      [0x04, 0x84],
    LocationName.swanky_gulch_game_1:         [0x04, 0x41],
    LocationName.swanky_gulch_game_2:         [0x04, 0x42],
    LocationName.swanky_gulch_game_3:         [0x04, 0x44],
    LocationName.swanky_keep_game_1:          [0x04, 0x51],
    LocationName.swanky_keep_game_2:          [0x04, 0x52],
    LocationName.swanky_keep_game_3:          [0x04, 0x54],

    LocationName.pirate_panic_red_balloon: [0x07, 0x1B, 0x01],
    LocationName.pirate_panic_green_balloon: [0x07, 0x03, 0x00],
    LocationName.mainbrace_mayhem_green_balloon: [0x07, 0x0C, 0x04],
    LocationName.gangplank_galley_red_balloon_1: [0x07, 0x04, 0x1A],
    LocationName.gangplank_galley_red_balloon_2: [0x07, 0x04, 0x49],
    LocationName.lockjaws_locker_red_balloon: [0x07, 0x15, 0x00],
    LocationName.topsail_trouble_red_balloon_1: [0x07, 0x0B, 0x05],
    LocationName.topsail_trouble_red_balloon_2: [0x07, 0x0B, 0x28],
    LocationName.topsail_trouble_blue_balloon: [0x07, 0x0B, 0x35],
    LocationName.hot_head_hop_green_balloon: [0x07, 0x07, 0x02],
    LocationName.hot_head_hop_red_balloon: [0x07, 0x07, 0x00],
    LocationName.lava_lagoon_red_balloon_1: [0x07, 0x14, 0x00],
    LocationName.squawks_shaft_red_balloon_1: [0x07, 0x24, 0x43],
    LocationName.barrel_bayou_green_balloon: [0x07, 0x28, 0x00],
    LocationName.glimmers_galleon_red_balloon: [0x07, 0x01, 0x23],
    LocationName.krockhead_klamber_red_balloon_1: [0x07, 0x29, 0x0B],
    LocationName.krockhead_klamber_red_balloon_2: [0x07, 0x29, 0x00],
    LocationName.bramble_blast_red_balloon: [0x07, 0x2D, 0xB3],
    LocationName.hornet_hole_green_balloon_1: [0x07, 0x11, 0x62],
    LocationName.hornet_hole_red_balloon_1: [0x07, 0x11, 0x00],
    LocationName.target_terror_red_balloon: [0x07, 0x0E, 0x4A],
    LocationName.bramble_scramble_blue_balloon: [0x07, 0x2E, 0x14],
    LocationName.bramble_scramble_red_balloon: [0x07, 0x2E, 0x00],
    LocationName.ghostly_grove_red_balloon: [0x07, 0x19, 0x00],
    LocationName.gusty_glade_blue_balloon: [0x07, 0x18, 0x00],
    LocationName.web_woods_green_balloon_1: [0x07, 0x17, 0x16],
    LocationName.web_woods_green_balloon_2: [0x07, 0x17, 0x6D],
    LocationName.arctic_abyss_red_balloon_1: [0x07, 0x6C, 0x00],
    LocationName.arctic_abyss_red_balloon_2: [0x07, 0x6C, 0x05],
    LocationName.windy_well_red_balloon: [0x07, 0x23, 0x74],
    LocationName.toxic_tower_green_balloon: [0x07, 0x6E, 0x6E],
    LocationName.stronghold_showdown_red_balloon: [0x07, 0xB9, 0x02],
    LocationName.screechs_sprint_red_balloon: [0x07, 0x2F, 0x45],
    LocationName.black_ice_battle_red_balloon_1: [0x07, 0x96, 0x09],
    LocationName.black_ice_battle_red_balloon_2: [0x07, 0x96, 0x02],
    LocationName.black_ice_battle_red_balloon_3: [0x07, 0x96, 0x67],
    LocationName.klobber_karnage_red_balloon: [0x07, 0x80, 0x7B],
    LocationName.animal_antics_red_balloon: [0x07, 0x9F, 0x07],

    LocationName.pirate_panic_banana_coin_1: [0x05, 0x03, 0x06],
    LocationName.pirate_panic_banana_coin_2: [0x05, 0x03, 0x14],
    LocationName.pirate_panic_banana_coin_3: [0x05, 0x6F, 0x02],
    LocationName.mainbrace_mayhem_banana_coin_1: [0x05, 0x0C, 0x01],
    LocationName.mainbrace_mayhem_banana_coin_2: [0x05, 0x0C, 0x30],
    LocationName.mainbrace_mayhem_banana_coin_3: [0x05, 0x0C, 0x26],
    LocationName.gangplank_galley_banana_coin_1: [0x05, 0x04, 0x78],
    LocationName.gangplank_galley_banana_coin_2: [0x05, 0x04, 0x36],
    LocationName.lockjaws_locker_banana_coin_1: [0x05, 0x15, 0x01],
    LocationName.lockjaws_locker_banana_coin_2: [0x05, 0x15, 0x03],
    LocationName.lockjaws_locker_banana_coin_3: [0x05, 0x15, 0x19],
    LocationName.lockjaws_locker_banana_coin_4: [0x05, 0x15, 0x20],
    LocationName.lockjaws_locker_banana_coin_5: [0x05, 0x15, 0x23],
    LocationName.lockjaws_locker_banana_coin_6: [0x05, 0x15, 0x10],
    LocationName.lockjaws_locker_banana_coin_7: [0x05, 0x15, 0x0F],
    LocationName.lockjaws_locker_banana_coin_8: [0x05, 0x15, 0x1F],
    LocationName.topsail_trouble_banana_coin_1: [0x05, 0x0B, 0x04],
    LocationName.topsail_trouble_banana_coin_2: [0x05, 0x0B, 0x78],
    LocationName.topsail_trouble_banana_coin_3: [0x05, 0x0B, 0x43],
    LocationName.topsail_trouble_banana_coin_4: [0x05, 0x0B, 0x0A],
    LocationName.krows_nest_banana_coin_1: [0x05, 0x09, 0x03],
    LocationName.krows_nest_banana_coin_2: [0x05, 0x09, 0x04],
    LocationName.hot_head_hop_banana_coin_1: [0x05, 0x07, 0x78],
    LocationName.hot_head_hop_banana_coin_2: [0x05, 0x07, 0x30],
    LocationName.hot_head_hop_banana_coin_3: [0x05, 0x07, 0x46],
    LocationName.hot_head_hop_banana_coin_4: [0x05, 0x07, 0x47],
    LocationName.kannons_klaim_banana_coin_1: [0x05, 0x25, 0x63],
    LocationName.kannons_klaim_banana_coin_2: [0x05, 0x25, 0x3E],
    LocationName.kannons_klaim_banana_coin_3: [0x05, 0x25, 0x59],
    LocationName.lava_lagoon_banana_coin_1: [0x05, 0x14, 0x12],
    LocationName.lava_lagoon_banana_coin_2: [0x05, 0x14, 0x10],
    LocationName.lava_lagoon_banana_coin_3: [0x05, 0x14, 0x47],
    LocationName.lava_lagoon_banana_coin_4: [0x05, 0x14, 0x60],
    LocationName.lava_lagoon_banana_coin_5: [0x05, 0x14, 0x3A],
    LocationName.lava_lagoon_banana_coin_6: [0x05, 0x14, 0x07],
    LocationName.lava_lagoon_banana_coin_7: [0x05, 0x14, 0x0E],
    LocationName.lava_lagoon_banana_coin_8: [0x05, 0x14, 0x46],
    LocationName.lava_lagoon_banana_coin_9: [0x05, 0x14, 0x4A],
    LocationName.lava_lagoon_banana_coin_10: [0x05, 0x14, 0x4E],
    LocationName.red_hot_ride_banana_coin_1: [0x05, 0x08, 0x02],
    LocationName.red_hot_ride_banana_coin_2: [0x05, 0x08, 0x01],
    LocationName.red_hot_ride_banana_coin_3: [0x05, 0x08, 0x14],
    LocationName.red_hot_ride_banana_coin_4: [0x05, 0x08, 0x1E],
    LocationName.red_hot_ride_banana_coin_5: [0x05, 0x08, 0x78],
    LocationName.red_hot_ride_banana_coin_6: [0x05, 0x08, 0x38],
    LocationName.squawks_shaft_banana_coin_1: [0x05, 0x24, 0x38],
    LocationName.squawks_shaft_banana_coin_2: [0x05, 0xAC, 0x78],
    LocationName.squawks_shaft_banana_coin_3: [0x05, 0x24, 0x0C],
    LocationName.squawks_shaft_banana_coin_4: [0x05, 0x24, 0x06],
    LocationName.squawks_shaft_banana_coin_5: [0x05, 0x24, 0x3D],
    LocationName.squawks_shaft_banana_coin_6: [0x05, 0x24, 0x3E],
    LocationName.squawks_shaft_banana_coin_7: [0x05, 0x24, 0x3F],
    LocationName.kleevers_kiln_banana_coin_1: [0x05, 0x21, 0x12],
    LocationName.kleevers_kiln_banana_coin_2: [0x05, 0x21, 0x13],
    LocationName.barrel_bayou_banana_coin_1: [0x05, 0x28, 0x23],
    LocationName.barrel_bayou_banana_coin_2: [0x05, 0x28, 0x49],
    LocationName.glimmers_galleon_banana_coin_1: [0x05, 0x01, 0x04],
    LocationName.glimmers_galleon_banana_coin_2: [0x05, 0x01, 0x0C],
    LocationName.glimmers_galleon_banana_coin_3: [0x05, 0x01, 0x41],
    LocationName.glimmers_galleon_banana_coin_4: [0x05, 0x01, 0x51],
    LocationName.glimmers_galleon_banana_coin_5: [0x05, 0x01, 0x56],
    LocationName.glimmers_galleon_banana_coin_6: [0x05, 0x01, 0x34],
    LocationName.glimmers_galleon_banana_coin_7: [0x05, 0x01, 0x26],
    LocationName.glimmers_galleon_banana_coin_8: [0x05, 0x01, 0x28],
    LocationName.glimmers_galleon_banana_coin_9: [0x05, 0x01, 0x44],
    LocationName.glimmers_galleon_banana_coin_10: [0x05, 0x01, 0x5D],
    LocationName.krockhead_klamber_banana_coin_1: [0x05, 0x29, 0x04],
    LocationName.krockhead_klamber_banana_coin_2: [0x05, 0x29, 0x1E],
    LocationName.krockhead_klamber_banana_coin_3: [0x05, 0x29, 0x42],
    LocationName.rattle_battle_banana_coin_1: [0x05, 0x05, 0x04],
    LocationName.rattle_battle_banana_coin_2: [0x05, 0x05, 0x13],
    LocationName.rattle_battle_banana_coin_3: [0x05, 0x05, 0x2F],
    LocationName.slime_climb_banana_coin_1: [0x05, 0x0A, 0x40],
    LocationName.slime_climb_banana_coin_2: [0x05, 0x0A, 0x3F],
    LocationName.slime_climb_banana_coin_3: [0x05, 0x0A, 0x27],
    LocationName.bramble_blast_banana_coin_1: [0x05, 0x2D, 0xBE],
    LocationName.bramble_blast_banana_coin_2: [0x05, 0x2D, 0x63],
    LocationName.hornet_hole_banana_coin_1: [0x05, 0x11, 0x09],
    LocationName.hornet_hole_banana_coin_2: [0x05, 0x11, 0x36],
    LocationName.hornet_hole_banana_coin_3: [0x05, 0x11, 0x1B],
    LocationName.hornet_hole_banana_coin_4: [0x05, 0x11, 0x03],
    LocationName.bramble_scramble_banana_coin_1: [0x05, 0x2E, 0x7D],
    LocationName.bramble_scramble_banana_coin_2: [0x05, 0xA2, 0x78],
    LocationName.bramble_scramble_banana_coin_3: [0x05, 0x2E, 0x68],
    LocationName.bramble_scramble_banana_coin_4: [0x05, 0x2E, 0x03],
    LocationName.bramble_scramble_banana_coin_5: [0x05, 0x2E, 0x02],
    LocationName.bramble_scramble_banana_coin_6: [0x05, 0x2E, 0x24],
    LocationName.bramble_scramble_banana_coin_7: [0x05, 0x2E, 0x27],
    LocationName.bramble_scramble_banana_coin_8: [0x05, 0x2E, 0x1D],
    LocationName.rickety_race_banana_coin: [0x05, 0x0F, 0x78],
    LocationName.mudhole_marsh_banana_coin_1: [0x05, 0x2C, 0x03],
    LocationName.mudhole_marsh_banana_coin_2: [0x05, 0x2C, 0x78],
    LocationName.mudhole_marsh_banana_coin_3: [0x05, 0x2C, 0x52],
    LocationName.mudhole_marsh_banana_coin_4: [0x05, 0x2C, 0x63],
    LocationName.mudhole_marsh_banana_coin_5: [0x05, 0x2C, 0x73],
    LocationName.rambi_rumble_banana_coin_1: [0x05, 0x02, 0x02],
    LocationName.rambi_rumble_banana_coin_2: [0x05, 0x02, 0x0F],
    LocationName.king_zing_sting_banana_coin_1: [0x05, 0x60, 0x04],
    LocationName.king_zing_sting_banana_coin_2: [0x05, 0x60, 0x05],
    LocationName.ghostly_grove_banana_coin_1: [0x05, 0x19, 0x0F],
    LocationName.ghostly_grove_banana_coin_2: [0x05, 0x19, 0x58],
    LocationName.haunted_hall_banana_coin_1: [0x05, 0x10, 0x05],
    LocationName.haunted_hall_banana_coin_2: [0x05, 0x10, 0x1F],
    LocationName.haunted_hall_banana_coin_3: [0x05, 0x10, 0x2F],
    LocationName.gusty_glade_banana_coin_1: [0x05, 0x18, 0x01],
    LocationName.gusty_glade_banana_coin_2: [0x05, 0x18, 0x09],
    LocationName.gusty_glade_banana_coin_3: [0x05, 0x18, 0x38],
    LocationName.parrot_chute_panic_banana_coin_1: [0x05, 0x13, 0x67],
    LocationName.parrot_chute_panic_banana_coin_2: [0x05, 0x13, 0x3E],
    LocationName.parrot_chute_panic_banana_coin_3: [0x05, 0x13, 0x60],
    LocationName.parrot_chute_panic_banana_coin_4: [0x05, 0x13, 0x61],
    LocationName.parrot_chute_panic_banana_coin_5: [0x05, 0x13, 0x7F],
    LocationName.web_woods_banana_coin_1: [0x05, 0x17, 0x0A],
    LocationName.web_woods_banana_coin_2: [0x05, 0x17, 0x78],
    LocationName.web_woods_banana_coin_3: [0x05, 0x17, 0x27],
    LocationName.web_woods_banana_coin_4: [0x05, 0x17, 0x32],
    LocationName.web_woods_banana_coin_5: [0x05, 0x17, 0x60],
    LocationName.kreepy_krow_banana_coin_1: [0x05, 0x0D, 0x06],
    LocationName.kreepy_krow_banana_coin_2: [0x05, 0x0D, 0x07],
    LocationName.arctic_abyss_banana_coin_1: [0x05, 0x6C, 0x14],
    LocationName.arctic_abyss_banana_coin_2: [0x05, 0x6C, 0x24],
    LocationName.arctic_abyss_banana_coin_3: [0x05, 0x6C, 0x22],
    LocationName.arctic_abyss_banana_coin_4: [0x05, 0x6C, 0x20],
    LocationName.arctic_abyss_banana_coin_5: [0x05, 0x6C, 0x4C],
    LocationName.windy_well_banana_coin_1: [0x05, 0x23, 0x3F],
    LocationName.windy_well_banana_coin_2: [0x05, 0x23, 0x69],
    LocationName.windy_well_banana_coin_3: [0x05, 0x23, 0x05],
    LocationName.windy_well_banana_coin_4: [0x05, 0x23, 0x21],
    LocationName.castle_crush_banana_coin_1: [0x05, 0x62, 0x14],
    LocationName.castle_crush_banana_coin_2: [0x05, 0x62, 0x34],
    LocationName.castle_crush_banana_coin_3: [0x05, 0x62, 0x0F],
    LocationName.clappers_cavern_banana_coin_1: [0x05, 0x8F, 0x5E],
    LocationName.clappers_cavern_banana_coin_2: [0x05, 0x8F, 0x39],
    LocationName.clappers_cavern_banana_coin_3: [0x05, 0x8F, 0x17],
    LocationName.clappers_cavern_banana_coin_4: [0x05, 0x8F, 0x16],
    LocationName.clappers_cavern_banana_coin_5: [0x05, 0x8F, 0x12],
    LocationName.chain_link_chamber_banana_coin_1: [0x05, 0x6D, 0x70],
    LocationName.chain_link_chamber_banana_coin_2: [0x05, 0x6D, 0x68],
    LocationName.chain_link_chamber_banana_coin_3: [0x05, 0x6D, 0x2A],
    LocationName.chain_link_chamber_banana_coin_4: [0x05, 0x6D, 0x58],
    LocationName.toxic_tower_banana_coin_1: [0x05, 0x6E, 0x05],
    LocationName.toxic_tower_banana_coin_2: [0x05, 0x6E, 0x03],
    LocationName.toxic_tower_banana_coin_3: [0x05, 0x6E, 0x07],
    LocationName.toxic_tower_banana_coin_4: [0x05, 0x6E, 0x6A],
    LocationName.toxic_tower_banana_coin_5: [0x05, 0x6E, 0x6C],
    LocationName.stronghold_showdown_banana_coin_1: [0x05, 0xB9, 0x01],
    LocationName.stronghold_showdown_banana_coin_2: [0x05, 0xB9, 0x03],
    LocationName.screechs_sprint_banana_coin_1: [0x05, 0x2F, 0x0B],
    LocationName.screechs_sprint_banana_coin_2: [0x05, 0x2F, 0x4C],
    LocationName.screechs_sprint_banana_coin_3: [0x05, 0x2F, 0x49],
    LocationName.screechs_sprint_banana_coin_4: [0x05, 0x2F, 0x0F],
    LocationName.screechs_sprint_banana_coin_5: [0x05, 0x2F, 0x0D],
    LocationName.screechs_sprint_banana_coin_6: [0x05, 0x2F, 0x0E],
    LocationName.screechs_sprint_banana_coin_7: [0x05, 0x2F, 0x10],
    LocationName.screechs_sprint_banana_coin_8: [0x05, 0x2F, 0x11],
    LocationName.jungle_jinx_banana_coin_1: [0x05, 0x99, 0x34],
    LocationName.jungle_jinx_banana_coin_2: [0x05, 0x99, 0x3B],
    LocationName.jungle_jinx_banana_coin_3: [0x05, 0x99, 0x52],
    LocationName.jungle_jinx_banana_coin_4: [0x05, 0x99, 0x54],
    LocationName.jungle_jinx_banana_coin_5: [0x05, 0x99, 0x58],
    LocationName.black_ice_battle_banana_coin_1: [0x05, 0x96, 0x63],
    LocationName.klobber_karnage_banana_coin_1: [0x05, 0x80, 0x01],
    LocationName.klobber_karnage_banana_coin_2: [0x05, 0x80, 0x09],
    LocationName.klobber_karnage_banana_coin_3: [0x05, 0x80, 0x16],
    LocationName.klobber_karnage_banana_coin_4: [0x05, 0x80, 0x5E],
    LocationName.fiery_furnace_banana_coin_1: [0x05, 0x16, 0x21],
    LocationName.fiery_furnace_banana_coin_2: [0x05, 0x16, 0x45],
    LocationName.animal_antics_banana_coin_1: [0x05, 0x9B, 0x16],
    LocationName.animal_antics_banana_coin_2: [0x05, 0x9F, 0x13],
    LocationName.animal_antics_banana_coin_3: [0x05, 0x9F, 0x11],
    LocationName.animal_antics_banana_coin_4: [0x05, 0x9F, 0x17],
    LocationName.animal_antics_banana_coin_5: [0x05, 0x9C, 0x78],

    LocationName.pirate_panic_banana_bunch_1: [0x06, 0x03, 0x0B],
    LocationName.mainbrace_mayhem_banana_bunch_1: [0x06, 0x0C, 0x2A],
    LocationName.mainbrace_mayhem_banana_bunch_2: [0x06, 0x0C, 0x22],
    LocationName.mainbrace_mayhem_banana_bunch_3: [0x06, 0x0C, 0x27],
    LocationName.gangplank_galley_banana_bunch_1: [0x06, 0x04, 0x06],
    LocationName.gangplank_galley_banana_bunch_2: [0x06, 0x04, 0x0D],
    LocationName.gangplank_galley_banana_bunch_3: [0x06, 0x04, 0x1E],
    LocationName.gangplank_galley_banana_bunch_4: [0x06, 0x04, 0x33],
    LocationName.gangplank_galley_banana_bunch_5: [0x06, 0x04, 0x39],
    LocationName.gangplank_galley_banana_bunch_6: [0x06, 0x04, 0x31],
    LocationName.gangplank_galley_banana_bunch_7: [0x06, 0x04, 0x44],
    LocationName.lockjaws_locker_banana_bunch_1: [0x06, 0x15, 0x02],
    LocationName.lockjaws_locker_banana_bunch_2: [0x06, 0x15, 0x18],
    LocationName.lockjaws_locker_banana_bunch_3: [0x06, 0x15, 0x34],
    LocationName.lockjaws_locker_banana_bunch_4: [0x06, 0x15, 0x00],
    LocationName.topsail_trouble_banana_bunch_1: [0x06, 0x0B, 0x2F],
    LocationName.topsail_trouble_banana_bunch_2: [0x06, 0x0B, 0x03],
    LocationName.topsail_trouble_banana_bunch_3: [0x06, 0x0B, 0x44],
    LocationName.hot_head_hop_banana_bunch_1: [0x06, 0x07, 0x23],
    LocationName.hot_head_hop_banana_bunch_2: [0x06, 0x07, 0x3F],
    LocationName.hot_head_hop_banana_bunch_3: [0x06, 0x07, 0x41],
    LocationName.kannons_klaim_banana_bunch_1: [0x06, 0x25, 0x2D],
    LocationName.lava_lagoon_banana_bunch_1: [0x06, 0x14, 0x21],
    LocationName.lava_lagoon_banana_bunch_2: [0x06, 0x14, 0x65],
    LocationName.lava_lagoon_banana_bunch_3: [0x06, 0x14, 0x2C],
    LocationName.lava_lagoon_banana_bunch_4: [0x06, 0x83, 0x00],
    LocationName.lava_lagoon_banana_bunch_5: [0x06, 0x14, 0x22],
    LocationName.red_hot_ride_banana_bunch_1: [0x06, 0x08, 0x03],
    LocationName.red_hot_ride_banana_bunch_2: [0x06, 0x08, 0x0B],
    LocationName.red_hot_ride_banana_bunch_3: [0x06, 0x08, 0x1A],
    LocationName.red_hot_ride_banana_bunch_4: [0x06, 0x08, 0x42],
    LocationName.squawks_shaft_banana_bunch_1: [0x06, 0x24, 0x02],
    LocationName.squawks_shaft_banana_bunch_2: [0x06, 0x24, 0x32],
    LocationName.squawks_shaft_banana_bunch_3: [0x06, 0x24, 0x22],
    LocationName.squawks_shaft_banana_bunch_4: [0x06, 0x24, 0x00],
    LocationName.barrel_bayou_banana_bunch_1: [0x06, 0x28, 0x0A],
    LocationName.barrel_bayou_banana_bunch_2: [0x06, 0x28, 0x25],
    LocationName.barrel_bayou_banana_bunch_3: [0x06, 0x28, 0x4B],
    LocationName.glimmers_galleon_banana_bunch_1: [0x06, 0x01, 0x0F],
    LocationName.glimmers_galleon_banana_bunch_2: [0x06, 0x01, 0x10],
    LocationName.glimmers_galleon_banana_bunch_3: [0x06, 0x01, 0x15],
    LocationName.glimmers_galleon_banana_bunch_4: [0x06, 0x01, 0x2A],
    LocationName.glimmers_galleon_banana_bunch_5: [0x06, 0x01, 0x5F],
    LocationName.glimmers_galleon_banana_bunch_6: [0x06, 0x01, 0x54],
    LocationName.glimmers_galleon_banana_bunch_7: [0x06, 0x01, 0x55],
    LocationName.glimmers_galleon_banana_bunch_8: [0x06, 0x01, 0x42],
    LocationName.glimmers_galleon_banana_bunch_9: [0x06, 0x01, 0x18],
    LocationName.glimmers_galleon_banana_bunch_10: [0x06, 0x01, 0x01],
    LocationName.glimmers_galleon_banana_bunch_11: [0x06, 0x01, 0x02],
    LocationName.glimmers_galleon_banana_bunch_12: [0x06, 0x01, 0x09],
    LocationName.glimmers_galleon_banana_bunch_13: [0x06, 0x01, 0x2E],
    LocationName.glimmers_galleon_banana_bunch_14: [0x06, 0x01, 0x4D],
    LocationName.rattle_battle_banana_bunch_1: [0x06, 0x05, 0x06],
    LocationName.rattle_battle_banana_bunch_2: [0x06, 0x05, 0x0C],
    LocationName.rattle_battle_banana_bunch_3: [0x06, 0x05, 0x49],
    LocationName.rattle_battle_banana_bunch_4: [0x06, 0x05, 0x00],
    LocationName.slime_climb_banana_bunch_1: [0x06, 0x0A, 0x34],
    LocationName.slime_climb_banana_bunch_2: [0x06, 0x0A, 0x43],
    LocationName.slime_climb_banana_bunch_3: [0x06, 0x0A, 0x0D],
    LocationName.slime_climb_banana_bunch_4: [0x06, 0x0A, 0x09],
    LocationName.bramble_blast_banana_bunch_1: [0x06, 0x2D, 0x03],
    LocationName.bramble_blast_banana_bunch_2: [0x06, 0x2D, 0x3E],
    LocationName.bramble_blast_banana_bunch_3: [0x06, 0x2D, 0xB8],
    LocationName.bramble_blast_banana_bunch_4: [0x06, 0x2D, 0xC1],
    LocationName.bramble_blast_banana_bunch_5: [0x06, 0x2D, 0xAC],
    LocationName.bramble_blast_banana_bunch_6: [0x06, 0x2D, 0x09],
    LocationName.bramble_blast_banana_bunch_7: [0x06, 0x2D, 0x83],
    LocationName.bramble_blast_banana_bunch_8: [0x06, 0x2D, 0x8C],
    LocationName.bramble_blast_banana_bunch_9: [0x06, 0xA0, 0x00],
    LocationName.hornet_hole_banana_bunch_1: [0x06, 0x11, 0x05],
    LocationName.hornet_hole_banana_bunch_2: [0x06, 0x11, 0x0D],
    LocationName.hornet_hole_banana_bunch_3: [0x06, 0x11, 0x02],
    LocationName.hornet_hole_banana_bunch_4: [0x06, 0x11, 0x01],
    LocationName.hornet_hole_banana_bunch_5: [0x06, 0x11, 0x28],
    LocationName.target_terror_banana_bunch_1: [0x06, 0x0E, 0x05],
    LocationName.target_terror_banana_bunch_2: [0x06, 0xA1, 0x00],
    LocationName.bramble_scramble_banana_bunch_1: [0x06, 0x2E, 0x7E],
    LocationName.bramble_scramble_banana_bunch_2: [0x06, 0x2E, 0x56],
    LocationName.bramble_scramble_banana_bunch_3: [0x06, 0x2E, 0x3A],
    LocationName.bramble_scramble_banana_bunch_4: [0x06, 0x2E, 0x0F],
    LocationName.bramble_scramble_banana_bunch_5: [0x06, 0x2E, 0x00],
    LocationName.mudhole_marsh_banana_bunch_1: [0x06, 0x2C, 0x00],
    LocationName.rambi_rumble_banana_bunch_1: [0x06, 0x02, 0x28],
    LocationName.rambi_rumble_banana_bunch_2: [0x06, 0x02, 0x0C],
    LocationName.rambi_rumble_banana_bunch_3: [0x06, 0x02, 0x00],
    LocationName.ghostly_grove_banana_bunch_1: [0x06, 0x19, 0x01],
    LocationName.ghostly_grove_banana_bunch_2: [0x06, 0x19, 0x05],
    LocationName.ghostly_grove_banana_bunch_3: [0x06, 0x19, 0x15],
    LocationName.ghostly_grove_banana_bunch_4: [0x06, 0x19, 0x35],
    LocationName.haunted_hall_banana_bunch_1: [0x06, 0x10, 0x01],
    LocationName.haunted_hall_banana_bunch_2: [0x06, 0x10, 0x02],
    LocationName.parrot_chute_panic_banana_bunch_1: [0x06, 0x13, 0x43],
    LocationName.parrot_chute_panic_banana_bunch_2: [0x06, 0x13, 0x5A],
    LocationName.web_woods_banana_bunch_1: [0x06, 0x17, 0x0F],
    LocationName.web_woods_banana_bunch_2: [0x06, 0x17, 0x1A],
    LocationName.web_woods_banana_bunch_3: [0x06, 0x17, 0x1E],
    LocationName.arctic_abyss_banana_bunch_1: [0x06, 0x6C, 0x13],
    LocationName.arctic_abyss_banana_bunch_2: [0x06, 0x6C, 0x15],
    LocationName.arctic_abyss_banana_bunch_3: [0x06, 0x6C, 0x1A],
    LocationName.arctic_abyss_banana_bunch_4: [0x06, 0x6C, 0x10],
    LocationName.arctic_abyss_banana_bunch_5: [0x06, 0x6C, 0x4D],
    LocationName.arctic_abyss_banana_bunch_6: [0x06, 0x6C, 0x4B],
    LocationName.arctic_abyss_banana_bunch_7: [0x06, 0x6C, 0x52],
    LocationName.windy_well_banana_bunch_1: [0x06, 0x23, 0x53],
    LocationName.windy_well_banana_bunch_2: [0x06, 0x23, 0x4F],
    LocationName.windy_well_banana_bunch_3: [0x06, 0x23, 0x0D],
    LocationName.windy_well_banana_bunch_4: [0x06, 0x23, 0x00],
    LocationName.castle_crush_banana_bunch_1: [0x06, 0x62, 0x4B],
    LocationName.castle_crush_banana_bunch_2: [0x06, 0x62, 0x29],
    LocationName.castle_crush_banana_bunch_3: [0x06, 0x62, 0x00],
    LocationName.castle_crush_banana_bunch_4: [0x06, 0x62, 0x2F],
    LocationName.castle_crush_banana_bunch_5: [0x06, 0x62, 0x50],
    LocationName.castle_crush_banana_bunch_6: [0x06, 0x62, 0x0E],
    LocationName.clappers_cavern_banana_bunch_1: [0x06, 0x8F, 0x6F],
    LocationName.clappers_cavern_banana_bunch_2: [0x06, 0x8F, 0x6E],
    LocationName.clappers_cavern_banana_bunch_3: [0x06, 0x8F, 0x6D],
    LocationName.clappers_cavern_banana_bunch_4: [0x06, 0x8F, 0x00],
    LocationName.chain_link_chamber_banana_bunch_1: [0x06, 0x6D, 0x18],
    LocationName.chain_link_chamber_banana_bunch_2: [0x06, 0x6D, 0x03],
    LocationName.chain_link_chamber_banana_bunch_3: [0x06, 0xB5, 0x07],
    LocationName.chain_link_chamber_banana_bunch_4: [0x06, 0x6D, 0x0B],
    LocationName.toxic_tower_banana_bunch_1: [0x06, 0x6E, 0x19],
    LocationName.toxic_tower_banana_bunch_2: [0x06, 0x6E, 0x16],
    LocationName.toxic_tower_banana_bunch_3: [0x06, 0x6E, 0x0D],
    LocationName.toxic_tower_banana_bunch_4: [0x06, 0x6E, 0x10],
    LocationName.toxic_tower_banana_bunch_5: [0x06, 0x6E, 0x11],
    LocationName.toxic_tower_banana_bunch_6: [0x06, 0x6E, 0x12],
    LocationName.toxic_tower_banana_bunch_7: [0x06, 0x6E, 0x04],
    LocationName.toxic_tower_banana_bunch_8: [0x06, 0x6E, 0x6B],
    LocationName.toxic_tower_banana_bunch_9: [0x06, 0x6E, 0x6D],
    LocationName.screechs_sprint_banana_bunch_1: [0x06, 0x2F, 0x30],
    LocationName.screechs_sprint_banana_bunch_2: [0x06, 0x2F, 0x0A],
    LocationName.screechs_sprint_banana_bunch_3: [0x06, 0x2F, 0x05],
    LocationName.screechs_sprint_banana_bunch_4: [0x06, 0x2F, 0x16],
    LocationName.screechs_sprint_banana_bunch_5: [0x06, 0x2F, 0x17],
    LocationName.screechs_sprint_banana_bunch_6: [0x06, 0x2F, 0x58],
    LocationName.jungle_jinx_banana_bunch_1: [0x06, 0x99, 0x2C],
    LocationName.jungle_jinx_banana_bunch_2: [0x06, 0x99, 0x30],
    LocationName.black_ice_battle_banana_bunch_1: [0x06, 0x96, 0x18],
    LocationName.black_ice_battle_banana_bunch_2: [0x06, 0x96, 0x01],
    LocationName.black_ice_battle_banana_bunch_3: [0x06, 0x96, 0x48],
    LocationName.klobber_karnage_banana_bunch_1: [0x06, 0x80, 0x07],
    LocationName.klobber_karnage_banana_bunch_2: [0x06, 0x80, 0x08],
    LocationName.klobber_karnage_banana_bunch_3: [0x06, 0x80, 0x17],
    LocationName.klobber_karnage_banana_bunch_4: [0x06, 0x80, 0x27],
    LocationName.klobber_karnage_banana_bunch_5: [0x06, 0x80, 0x31],
    LocationName.klobber_karnage_banana_bunch_6: [0x06, 0x80, 0x3F],
    LocationName.klobber_karnage_banana_bunch_7: [0x06, 0x80, 0x53],
    LocationName.fiery_furnace_banana_bunch_1: [0x06, 0x16, 0x01],
    LocationName.fiery_furnace_banana_bunch_2: [0x06, 0x16, 0x02],
    LocationName.fiery_furnace_banana_bunch_3: [0x06, 0x16, 0x03],
    LocationName.fiery_furnace_banana_bunch_4: [0x06, 0x16, 0x14],
    LocationName.fiery_furnace_banana_bunch_5: [0x06, 0x16, 0x73],
    LocationName.animal_antics_banana_bunch_1: [0x06, 0x90, 0x18],
    LocationName.animal_antics_banana_bunch_2: [0x06, 0x9B, 0x01],
    LocationName.animal_antics_banana_bunch_3: [0x06, 0x9F, 0x14],
    LocationName.animal_antics_banana_bunch_4: [0x06, 0x9F, 0x12],
}

level_list = [
    #[RegionName.pirate_panic_level, 0x03],
    [RegionName.mainbrace_mayhem_level, 0x0C],
    [RegionName.gangplank_galley_level, 0x04],
    [RegionName.lockjaws_locker_level, 0x15],
    [RegionName.topsail_trouble_level, 0x0B],
    [RegionName.hot_head_hop_level, 0x07],
    [RegionName.kannons_klaim_level, 0x25],
    [RegionName.lava_lagoon_level, 0x14],
    [RegionName.red_hot_ride_level, 0x08],
    [RegionName.squawks_shaft_level, 0x24],
    [RegionName.barrel_bayou_level, 0x28],
    [RegionName.glimmers_galleon_level, 0x01],
    [RegionName.krockhead_klamber_level, 0x29],
    [RegionName.rattle_battle_level, 0x05],
    [RegionName.slime_climb_level, 0x0A],
    [RegionName.bramble_blast_level, 0x2D],
    [RegionName.hornet_hole_level, 0x11],
    [RegionName.target_terror_level, 0x0E],
    [RegionName.bramble_scramble_level, 0x2E],
    [RegionName.rickety_race_level, 0x0F],
    [RegionName.mudhole_marsh_level, 0x2C],
    [RegionName.rambi_rumble_level, 0x02],
    [RegionName.ghostly_grove_level, 0x19],
    [RegionName.haunted_hall_level, 0x10],
    [RegionName.gusty_glade_level, 0x18],
    [RegionName.parrot_chute_panic_level, 0x13],
    [RegionName.web_woods_level, 0x17],
    [RegionName.arctic_abyss_level, 0x6C],
    [RegionName.windy_well_level, 0x23],
    [RegionName.castle_crush_level, 0x62],
    [RegionName.clappers_cavern_level, 0x8F],
    [RegionName.chain_link_chamber_level, 0x6D],
    [RegionName.toxic_tower_level, 0x6E],
    [RegionName.screechs_sprint_level, 0x2F],
    [RegionName.jungle_jinx_level, 0x99],
    [RegionName.black_ice_battle_level, 0x96],
    [RegionName.klobber_karnage_level, 0x80],
    [RegionName.fiery_furnace_level, 0x16],
    [RegionName.animal_antics_level, 0x9A],
]

boss_list = [
    [RegionName.krows_nest_level, 0x09],
    [RegionName.kleevers_kiln_level, 0x21],
    [RegionName.kudgels_kontest_level, 0x63],
    [RegionName.king_zing_sting_level, 0x60],
    [RegionName.kreepy_krow_level, 0x0D],
    [RegionName.stronghold_showdown_level, 0xB9],
]

regional_events = {
    RegionName.gangplank_galleon: EventName.galleon_level,
    RegionName.crocodile_cauldron: EventName.cauldron_level,
    RegionName.krem_quay: EventName.quay_level,
    RegionName.krazy_kremland: EventName.kremland_level,
    RegionName.gloomy_gulch: EventName.gulch_level,
    RegionName.krools_keep: EventName.keep_level,
    RegionName.the_flying_krock: EventName.krock_level,
}

level_map = {
    RegionName.pirate_panic_map: RegionName.gangplank_galleon,
    RegionName.mainbrace_mayhem_map: RegionName.gangplank_galleon,
    RegionName.gangplank_galley_map: RegionName.gangplank_galleon,
    RegionName.lockjaws_locker_map: RegionName.gangplank_galleon,
    RegionName.topsail_trouble_map: RegionName.gangplank_galleon,
    RegionName.hot_head_hop_map: RegionName.crocodile_cauldron,
    RegionName.kannons_klaim_map: RegionName.crocodile_cauldron,
    RegionName.lava_lagoon_map: RegionName.crocodile_cauldron,
    RegionName.red_hot_ride_map: RegionName.crocodile_cauldron,
    RegionName.squawks_shaft_map: RegionName.crocodile_cauldron,
    RegionName.barrel_bayou_map: RegionName.krem_quay,
    RegionName.glimmers_galleon_map: RegionName.krem_quay,
    RegionName.krockhead_klamber_map: RegionName.krem_quay,
    RegionName.rattle_battle_map: RegionName.krem_quay,
    RegionName.slime_climb_map: RegionName.krem_quay,
    RegionName.bramble_blast_map: RegionName.krem_quay,
    RegionName.hornet_hole_map: RegionName.krazy_kremland,
    RegionName.target_terror_map: RegionName.krazy_kremland,
    RegionName.bramble_scramble_map: RegionName.krazy_kremland,
    RegionName.rickety_race_map: RegionName.krazy_kremland,
    RegionName.mudhole_marsh_map: RegionName.krazy_kremland,
    RegionName.rambi_rumble_map: RegionName.krazy_kremland,
    RegionName.ghostly_grove_map: RegionName.gloomy_gulch,
    RegionName.haunted_hall_map: RegionName.gloomy_gulch,
    RegionName.gusty_glade_map: RegionName.gloomy_gulch,
    RegionName.parrot_chute_panic_map: RegionName.gloomy_gulch,
    RegionName.web_woods_map: RegionName.gloomy_gulch,
    RegionName.arctic_abyss_map: RegionName.krools_keep,
    RegionName.windy_well_map: RegionName.krools_keep,
    RegionName.castle_crush_map: RegionName.krools_keep,
    RegionName.clappers_cavern_map: RegionName.krools_keep,
    RegionName.chain_link_chamber_map: RegionName.krools_keep,
    RegionName.toxic_tower_map: RegionName.krools_keep,
    RegionName.screechs_sprint_map: RegionName.the_flying_krock,
    RegionName.jungle_jinx_map: RegionName.lost_world_cauldron,
    RegionName.black_ice_battle_map: RegionName.lost_world_quay,
    RegionName.klobber_karnage_map: RegionName.lost_world_kremland,
    RegionName.fiery_furnace_map: RegionName.lost_world_gulch,
    RegionName.animal_antics_map: RegionName.lost_world_keep,
    RegionName.krows_nest_map: RegionName.gangplank_galleon,
    RegionName.kleevers_kiln_map: RegionName.crocodile_cauldron,
    RegionName.kudgels_kontest_map: RegionName.krem_quay,
    RegionName.king_zing_sting_map: RegionName.krazy_kremland,
    RegionName.kreepy_krow_map: RegionName.gloomy_gulch,
    RegionName.stronghold_showdown_map: RegionName.krools_keep,
}

level_connections = {
    #RegionName.pirate_panic_map: RegionName.pirate_panic_level,
    RegionName.mainbrace_mayhem_map: RegionName.mainbrace_mayhem_level,
    RegionName.gangplank_galley_map: RegionName.gangplank_galley_level,
    RegionName.lockjaws_locker_map: RegionName.lockjaws_locker_level,
    RegionName.topsail_trouble_map: RegionName.topsail_trouble_level,
    RegionName.hot_head_hop_map: RegionName.hot_head_hop_level,
    RegionName.kannons_klaim_map: RegionName.kannons_klaim_level,
    RegionName.lava_lagoon_map: RegionName.lava_lagoon_level,
    RegionName.red_hot_ride_map: RegionName.red_hot_ride_level,
    RegionName.squawks_shaft_map: RegionName.squawks_shaft_level,
    RegionName.barrel_bayou_map: RegionName.barrel_bayou_level,
    RegionName.glimmers_galleon_map: RegionName.glimmers_galleon_level,
    RegionName.krockhead_klamber_map: RegionName.krockhead_klamber_level,
    RegionName.rattle_battle_map: RegionName.rattle_battle_level,
    RegionName.slime_climb_map: RegionName.slime_climb_level,
    RegionName.bramble_blast_map: RegionName.bramble_blast_level,
    RegionName.hornet_hole_map: RegionName.hornet_hole_level,
    RegionName.target_terror_map: RegionName.target_terror_level,
    RegionName.bramble_scramble_map: RegionName.bramble_scramble_level,
    RegionName.rickety_race_map: RegionName.rickety_race_level,
    RegionName.mudhole_marsh_map: RegionName.mudhole_marsh_level,
    RegionName.rambi_rumble_map: RegionName.rambi_rumble_level,
    RegionName.ghostly_grove_map: RegionName.ghostly_grove_level,
    RegionName.haunted_hall_map: RegionName.haunted_hall_level,
    RegionName.gusty_glade_map: RegionName.gusty_glade_level,
    RegionName.parrot_chute_panic_map: RegionName.parrot_chute_panic_level,
    RegionName.web_woods_map: RegionName.web_woods_level,
    RegionName.arctic_abyss_map: RegionName.arctic_abyss_level,
    RegionName.windy_well_map: RegionName.windy_well_level,
    RegionName.castle_crush_map: RegionName.castle_crush_level,
    RegionName.clappers_cavern_map: RegionName.clappers_cavern_level,
    RegionName.chain_link_chamber_map: RegionName.chain_link_chamber_level,
    RegionName.toxic_tower_map: RegionName.toxic_tower_level,
    RegionName.screechs_sprint_map: RegionName.screechs_sprint_level,
    RegionName.jungle_jinx_map: RegionName.jungle_jinx_level,
    RegionName.black_ice_battle_map: RegionName.black_ice_battle_level,
    RegionName.klobber_karnage_map: RegionName.klobber_karnage_level,
    RegionName.fiery_furnace_map: RegionName.fiery_furnace_level,
    RegionName.animal_antics_map: RegionName.animal_antics_level,
}

boss_connections = {
    RegionName.krows_nest_map: RegionName.krows_nest_level,
    RegionName.kleevers_kiln_map: RegionName.kleevers_kiln_level,
    RegionName.kudgels_kontest_map: RegionName.kudgels_kontest_level,
    RegionName.king_zing_sting_map: RegionName.king_zing_sting_level,
    RegionName.kreepy_krow_map: RegionName.kreepy_krow_level,
    RegionName.stronghold_showdown_map: RegionName.stronghold_showdown_level,
}

lost_world_levels = (
    RegionName.jungle_jinx_map,
    RegionName.black_ice_battle_map,
    RegionName.klobber_karnage_map,
    RegionName.fiery_furnace_map,
    RegionName.animal_antics_map,
)

level_rom_data = {
    RegionName.pirate_panic_level:          [0x34DD6F+9, 0x34DD7E],
    RegionName.mainbrace_mayhem_level:      [0x34DD9C+9, 0x34DDB3],
    RegionName.gangplank_galley_level:      [0x34D24D+9, 0x34D260],
    RegionName.lockjaws_locker_level:       [0x34D2BA+9, 0x34D2CD],
    RegionName.topsail_trouble_level:       [0x34D2F2+9, 0x34D305],
    RegionName.hot_head_hop_level:          [0x34D3CF+9, 0x34D3E2],
    RegionName.kannons_klaim_level:         [0x34D481+9, 0x34D498],
    RegionName.lava_lagoon_level:           [0x34D4F0+9, 0x34D507],
    RegionName.red_hot_ride_level:          [0x34D54E+9, 0x34D565],
    RegionName.squawks_shaft_level:         [0x34D5B5+9, 0x34D5C8],
    RegionName.barrel_bayou_level:          [0x34D620+9, 0x34D62F],
    RegionName.glimmers_galleon_level:      [0x34D64D+9, 0x34D664],
    RegionName.krockhead_klamber_level:     [0x34D68A+9, 0x34D6A1],
    RegionName.rattle_battle_level:         [0x34D6CD+9, 0x34D6E4],
    RegionName.slime_climb_level:           [0x34D738+9, 0x34D74F],
    RegionName.bramble_blast_level:         [0x34D771+9, 0x34D784],
    RegionName.hornet_hole_level:           [0x34E032+9, 0x34E045],
    RegionName.target_terror_level:         [0x34DEEB+9, 0x34DEFE],
    RegionName.bramble_scramble_level:      [0x34DF21+9, 0x34DF38],
    RegionName.rickety_race_level:          [0x34DF5F+9, 0x34DF72],
    RegionName.mudhole_marsh_level:         [0x34DE21+9, 0x34DE38],
    RegionName.rambi_rumble_level:          [0x34DE57+9, 0x34DE6A],
    RegionName.ghostly_grove_level:         [0x34D8C1+9, 0x34D8D0],
    RegionName.haunted_hall_level:          [0x34D921+9, 0x34D934],
    RegionName.gusty_glade_level:           [0x34D97A+9, 0x34D991],
    RegionName.parrot_chute_panic_level:    [0x34D9EC+9, 0x34DA07],
    RegionName.web_woods_level:             [0x34DA96+9, 0x34DAA9],
    RegionName.arctic_abyss_level:          [0x34DAF2+9, 0x34DB09],
    RegionName.windy_well_level:            [0x34DB58+9, 0x34DB6B],
    RegionName.castle_crush_level:          [0x34DBE9+9, 0x34DBFC],
    RegionName.clappers_cavern_level:       [0x34DC1B+9, 0x34DC2E],
    RegionName.chain_link_chamber_level:    [0x34DC54+9, 0x34DC6B],
    RegionName.toxic_tower_level:           [0x34DD06+9, 0x34DD19],
    RegionName.screechs_sprint_level:       [0x34E15B+9, 0x34E172],
    RegionName.jungle_jinx_level:           [0x34E26C+9, 0x34E27F],
    RegionName.black_ice_battle_level:      [0x34E33A+9, 0x34E34D],
    RegionName.klobber_karnage_level:       [0x34E41F+9, 0x34E432],
    RegionName.fiery_furnace_level:         [0x34E4F9+9, 0x34E50C],
    RegionName.animal_antics_level:         [0x34E5D5+9, 0x34E5E8],
}

boss_rom_data = {
    RegionName.krows_nest_level:            [0x34D363+9, 0x34D372],
    RegionName.kleevers_kiln_level:         [0x34D5ED+9, 0x34D5FC],
    RegionName.kudgels_kontest_level:       [0x34D7A3+9, 0x34D7B2],
    RegionName.king_zing_sting_level:       [0x34DEBB+9, 0x34DECA],
    RegionName.kreepy_krow_level:           [0x34DAC4+9, 0x34DAD3],
    RegionName.stronghold_showdown_level:   [0x34DD34+9, 0x34DD43],
}

def generate_level_list(world: "DKC2World"):
    shuffled_level_list = level_list.copy()
    shuffled_boss_list = boss_list.copy()
    if world.options.shuffle_levels:
        world.random.shuffle(shuffled_level_list)
        world.random.shuffle(shuffled_boss_list)
    #shuffled_level_list.insert(0, [RegionName.pirate_panic_level, 0x03])

    for map_level, level in level_connections.items():
        selected_level = shuffled_level_list.pop(0)
        world.level_connections[map_level] = selected_level[0]
        world.rom_connections[level] = selected_level

    for map_boss, boss in boss_connections.items():
        selected_boss = shuffled_boss_list.pop(0)
        world.level_connections[map_boss] = selected_boss[0]
        world.rom_connections[boss] = selected_boss

    # Place locked levels
    world.level_connections[RegionName.pirate_panic_map] = RegionName.pirate_panic_level
