## Required Software

Download the game from the [Bumper Stickers GitHub releases page](https://github.com/FelicitusNeko/FlixelBumpStik/releases), or from the [Bumper Stickers AP Itch page](https://kewliomzx.itch.io/bumpstik-ap), where you can also play it in your browser.

## Installation Procedures

Simply download the latest version of Bumper Stickers from the link above, and extract it wherever you like.

- ⚠️ It is not recommended to copy this game, or any files, directly into your Program Files folder under Windows.

## Joining a Multiworld Game

1. Run `BumpStikAP.exe`.
2. Select "Archipelago Mode".
3. Enter your server details in the fields provided, and click "Start".
  - The game will attempt to automatically detect whether to connect via normal (WS) or secure (WSS) server, but you can specify `ws://` or `wss://` to prioritise one or the other.

## How to play Bumper Stickers (Classic)

Here's a rundown of how to play a classic round of Bumper Stickers.
- You are presented with a 5×5 field, surrounded by Launchers. Your next Bumper to be played is seen at the bottom-right.
- Launch the Bumper onto the field by clicking on a Launcher. It will first move in the direction launched, then in the direction printed on the Bumper once it hits something.
- Line up three Bumpers of the same color, regardless of direction, to form a Bumper Sticker and clear them from the field.
  - Sticking more than three in one move is a Combo, worth bonus points.
  - After sticking Bumpers, any that are then able to move forward will do so. This can result in another Bumper Sticker being formed. This is a Chain, and is worth even more bonus points.
- You start with three colors. Sticking enough Bumpers will result in more colors being added to play, up to six. Each additional color adds a score multiplier.
- Clearing out the entire board results in an All Clear, which is worth big points!
- Getting 1000 points will award a Paint Can, which can be used to change the color of any Bumper in play, including the next Bumper.
  - Each subsequent Paint Can will require 500 more points than the last one (1000, +1500 (2500), +2000 (4500), etc.)
- The game is over when all Launchers are jammed and no further move can be made.

## Archipelago Mode

Archipelago Mode differs from Classic mode in the following ways:
- The board starts as a 3×3 field, with only two colors in play.
- You'll be presented with a set of tasks to complete on the HUD.
- Tasks may have multiple steps. If they do, you will see **[+#]** next to it, indicating how many more steps are left in this task.
- Completing each step of a task will send a check. Clearing Bonus Boosters and Treasure Bumpers will send one check, whether or not they complete a task.
- Completing all tasks will end the board in play, and start a larger board with more colors and a new set of tasks.
- If the board becomes jammed, it is wiped out and the board is reset. Note that this will reset your progress for Score and Bumpers tasks, but not Level or Total Score/Bumpers tasks.
- Your goal is to complete all five levels.

There are some additional types of Bumpers in this game mode:
- Treasure Bumpers, which have the Archipelago logo on them, award a score bonus and send a check when sticked.
- Bonus Boosters, which have yellow and blue dots on them, award a permanent multiplier and send a check when sticked.
- Hazard Bumpers are an obstacle that start showing up in level 2. First, a red space will show up to warn that a Hazard is about to appear. After making a move, it will show up as a grey Bumper with a red octagon (like a Stop sign) on it. It is not stickable for five moves, after which time it will stay immobile, but take on a random color, and can be sticked like a normal Bumper, and even recolored with a Paint Can.
  - Playing a Bumper which stops on the red warning space will cause that space to move to another random location.

In addition to Paint Cans from Classic mode, two new tools are also available:
- Turners allow you to change the direction of any bumper. You won't get them from scoring, but you can get them as MultiworldGG items, and they'll refresh every time you start a new board.
- Task Advances allow you to skip one step in any task. They can only be obtained as MultiworldGG items. Make sure you keep them for when you need them most; if you use one, it won't come back!
- You can also get Starting Paint Cans from the AP server. These refresh when you start a new board.

## Commands

While playing the multiworld, you can interact with the server using various commands listed in the [commands guide](/tutorial/MultiworldGG/commands/en). As this game does not have an in-game text client at the moment, you can optionally connect to the multiworld using the text client, which can be found in the [MultiworldGG installation](https://github.com/MultiworldGG/MultiworldGG/releases) as MultiworldGG Text Client to enter these commands.

