from typing import Dict, List

booster_contents: Dict[str, List[str]] = {
    "LEGEND OF B.E.W.D.": [
        "Exodia",
        "Dark Magician",
        "Polymerization",
        "Skull Servant"
    ],
    "METAL RAIDERS": [
        "Petit Moth",
        "Cocoon of Evolution",
        "Time Wizard",
        "Gate Guardian",
        "Kazejin",
        "Suijin",
        "Sanga of the Thunder",
        "Sangan",
        "Castle of Dark Illusions",
        "Soul Release",
        "Magician of Faith",
        "Dark Elf",
        "Summoned Skull",
        "Sangan",
        "7 Colored Fish",
        "Tribute to the Doomed",
        "Horn of Heaven",
        "Magic Jammer",
        "Seven Tools of the Bandit",
        "Solemn Judgment",
        "Dream Clown",
        "Heavy Storm"
    ],
    "PHARAOH'S SERVANT": [
        "Beast of Talwar",
        "Jinzo",
        "Gearfried the Iron Knight",
        "Harpie's Brother",
        "Gravity Bind",
        "Solemn Wishes",
        "Kiseitai",
        "Morphing Jar #2",
        "The Shallow Grave",
        "Nobleman of Crossout",
        "Magic Drain"
    ],
    "PHARAONIC GUARDIAN": [
        "Don Zaloog",
        "Reasoning",
        "Dark Snake Syndrome",
        "Helpoemer",
        "Newdoria",
        "Spirit Reaper",
        "Yomi Ship",
        "Pyramid Turtle",
        "Master Kyonshee",
        "Book of Life",
        "Call of the Mummy",
        "Gravekeeper's Spy",
        "Gravekeeper's Guard",
        "A Cat of Ill Omen",
        "Jowls of Dark Demise",
        "Non Aggression Area",
        "Terraforming",
        "Des Lacooda",
        "Swarm of Locusts",
        "Swarm of Scarabs",
        "Wandering Mummy",
        "Royal Keeper",
        "Book of Moon",
        "Book of Taiyou",
        "Dust Tornado",
        "Raigeki Break"
    ],
    "SPELL RULER": [
        "Ritual",
        "Messenger of Peace",
        "Megamorph",
        "Shining Angel",
        "Mystic Tomato",
        "Giant Rat",
        "Mother Grizzly",
        "UFO Turtle",
        "Flying Kamakiri 1",
        "Giant Germ",
        "Nimble Momonga",
        "Cyber Jar",
        "Spear Cretin",
        "Toon Mermaid",
        "Toon Summoned Skull",
        "Toon World",
        "Rush Recklessly",
        "The Reliable Guardian",
        "Senju of the Thousand Hands",
        "Sonic Bird",
        "Mystical Space Typhoon"
    ],
    "LABYRINTH OF NIGHTMARE": [
        "Destiny Board",
        "Spirit Message 'I'",
        "Spirit Message 'N'",
        "Spirit Message 'A'",
        "Spirit Message 'L'",
        "Fusion Gate",
        "Jowgen the Spiritualist",
        "Fairy Box",
        "Aqua Spirit",
        "Rock Spirit",
        "Spirit of Flames",
        "Garuda the Wind Spirit",
        "Hysteric Fairy",
        "Kycoo the Ghost Destroyer",
        "Gemini Elf",
        "Amphibian Beast",
        "Revival Jam",
        "Dancing Fairy",
        "Cure Mermaid",
        "The Last Warrior from Another Planet",
        "United We Stand",
        "Earthbound Spirit",
        "The Masked Beast"
    ],
    "LEGACY OF DARKNESS": [
        "Last Turn",
        "Yata-Garasu",
        "Opticlops",
        "Dark Ruler Ha Des",
        "Exiled Force",
        "Injection Fairy Lily",
        "Spear Dragon",
        "Luster Dragon #2",
        "Twin-Headed Behemoth",
        "Airknight Parshath",
        "Freed the Matchless General",
        "Marauding Captain",
        "Reinforcement of the Army",
        "Cave Dragon",
        "Troop Dragon",
        "Stamping Destruction",
        "Creature Swap",
        "Asura Priest",
        "Fushi No Tori",
        "Maharaghi",
        "Susa Soldier",
        "Emergency Provisions",
    ],
    "MAGICIAN'S FORCE": [
        "Huge Revolution",
        "Oppressed People",
        "United Resistance",
        "People Running About",
        "X-Head Cannon",
        "Y-Dragon Head",
        "Z-Metal Tank",
        "XY-Dragon Cannon",
        "XZ-Tank Cannon",
        "YZ-Tank Dragon",
        "XYZ-Dragon Cannon",
        "Cliff the Trap Remover",
        "Wave-Motion Cannon",
        "Ritual",
        "Magical Merchant",
        "Poison of the Old Man",
        "Chaos Command Magician",
        "Skilled Dark Magician",
        "Dark Blade",
        "Great Angus",
        "Luster Dragon",
        "Breaker the magical Warrior",
        "Old Vindictive Magician",
        "Apprentice Magician",
        "Burning Beast",
        "Freezing Beast",
        "Pitch-Dark Dragon",
        "Giant Orc",
        "Second Goblin",
        "Decayed Commander",
        "Zombie Tiger",
        "Vampire Orchis",
        "Des Dendle",
        "Frontline Base",
        "Formation Union",
        "Pitch-Black Power Stone",
        "Magical Marionette",
        "Royal Magical Library",
        "Spell Shield Type-8",
        "Tribute Doll",
    ],
    "DARK CRISIS": [
        "Final Countdown",
        "Ojama Green",
        "Dark Scorpion Combination",
        "Dark Scorpion - Chick the Yellow",
        "Dark Scorpion - Meanae the Thorn",
        "Dark Scorpion - Gorg the Strong",
        "Ritual",
        "Tsukuyomi",
        "Ojama Trio",
        "Kaiser Glider",
        "D.D. Warrior Lady",
        "Archfiend Soldier",
        "Skull Archfiend of Lightning",
        "Blindly Loyal Goblin",
        "Gagagigo",
        "Nin-Ken Dog",
        "Zolga",
        "Kelbek",
        "Mudora",
        "Cestus of Dagla",
        "Vampire Lord",
        "Metallizing Parasite - Lunatite",
        "D. D. Trainer",
        "Spell Reproduction",
        "Contract with the Abyss",
        "Dark Master - Zorc"
    ],
    "INVASION OF CHAOS": [
        "Ojama Delta Hurricane",
        "Ojama Yellow",
        "Ojama Black",
        "Heart of the Underdog",
        "Chaos Emperor Dragon - Envoy of the End",
        "Self-Destruct Button",
        "Manticore of Darkness",
        "Dimension Fusion",
        "Gigantes",
        "Inferno",
        "Silpheed",
        "Mad Dog of Darkness",
        "Ryu Kokki",
        "Berserk Gorilla",
        "Neo Bug",
        "Dark Driceratops",
        "Hyper Hammerhead",
        "Sea Serpent Warrior of Darkness",
        "Giga Gagagigo",
        "Terrorking Salmon",
        "Blazing Inpachi",
        "Stealth Bird",
        "Reload",
        "Cursed Seal of the Forbidden Spell",
        "Stray Lambs",
        "Manju of the Ten Thousand Hands"
    ],
    "ANCIENT SANCTUARY": [
        "Monster Gate",
        "Wall of Revealing Light",
        "Mystik Wok",
        "The Agent of Judgment - Saturn",
        "Zaborg the Thunder Monarch",
        "Regenerating Mummy",
        "The End of Anubis",
        "Solar Flare Dragon",
        "Level Limit - Area B",
        "King of the Swamp",
        "Enemy Controller",
        "Enchanting Fitting Room"
    ],
    "SOUL OF THE DUELIST": [
        "Ninja Grandmaster Sasuke",
        "Mystic Swordsman LV2",
        "Mystic Swordsman LV4",
        "Enraged Muka Muka",
        "Mobius the Frost Monarch",
        "Horus the Black Flame Dragon LV6",
        "Ultimate Baseball Kid",
        "Armed Dragon LV3",
        "Armed Dragon LV5",
        "Masked Dragon",
        "Element Dragon",
        "Horus the Black Flame Dragon LV4",
        "Level Up!",
        "Howling Insect",
        "Mobius the Frost Monarch"
    ],
    "RISE OF DESTINY": [
        "Homunculus the Alchemic Being",
        "Thestalos the Firestorm Monarch",
        "Roc from the Valley of Haze",
        "Harpie Lady 1",
        "Silent Swordsman Lv3",
        "Mystic Swordsman LV6",
        "Ultimate Insect Lv3",
        "Divine Wrath",
        "Serial Spell"
    ],
    "FLAMING ETERNITY": [
        "Insect Knight",
        "Chiron the Mage",
        "Granmarg the Rock Monarch",
        "Silent Swordsman Lv5",
        "The Dark - Hex-Sealed Fusion",
        "The Earth - Hex-Sealed Fusion",
        "The Light - Hex-Sealed Fusion",
        "Ultimate Insect Lv5",
        "Blast Magician",
        "Golem Sentry",
        "Rescue Cat",
        "Blade Rabbit"
    ],
    "THE LOST MILLENIUM": [
        "Ritual",
        "Megarock Dragon",
        "D.D. Survivor",
        "Hieracosphinx",
        "Elemental Hero Flame Wingman",
        "Elemental Hero Avian",
        "Elemental Hero Burstinatrix",
        "Elemental Hero Clayman",
        "Elemental Hero Sparkman",
        "Elemental Hero Thunder Giant",
        "Aussa the Earth Charmer",
        "Brain Control"
    ],
    "CYBERNETIC REVOLUTION": [
        "Power Bond",
        "Cyber Dragon",
        "Cyber Twin Dragon",
        "Cybernetic Magician",
        "Indomitable Fighter Lei Lei",
        "Protective Soul Ailin",
        "Miracle Fusion",
        "Elemental Hero Bubbleman",
        "Jerry Beans Man"
    ],
    "ELEMENTAL ENERGY": [
        "V-Tiger Jet",
        "W-Wing Catapult",
        "VW-Tiger Catapult",
        "VWXYZ-Dragon Catapult Cannon",
        "Zure, Knight of Dark World",
        "Brron, Mad King of Dark World",
        "Familiar-Possessed - Aussa",
        "Familiar-Possessed - Eria",
        "Familiar-Possessed - Hiita",
        "Familiar-Possessed - Wynn",
        "Oxygeddon",
        "Roll Out!",
        "Dark World Lightning",
        "Elemental Hero Rampart Blaster",
        "Elemental Hero Shining Flare Wingman",
        "Elemental Hero Wildedge",
        "Elemental Hero Wildheart",
        "Elemental Hero Bladedge",
        "Pot of Avarice",
        "B.E.S. Tetran"
    ],
    "SHADOW OF INFINITY": [
        "Hamon, Lord of Striking Thunder",
        "Raviel, Lord of Phantasms",
        "Uria, Lord of Searing Flames",
        "Ritual",
        "Treeborn Frog",
        "Saber Beetle",
        "Tenkabito Shien",
        "Princess Pikeru",
        "Gokipon",
        "Demise, King of Armageddon",
        "Anteatereatingant"
    ],
    "GAME GIFT COLLECTION": [
        "Ritual",
        "Valkyrion the Magna Warrior",
        "Alpha the Magnet Warrior",
        "Beta the Magnet Warrior",
        "Gamma the Magnet Warrior",
        "Magical Blast",
        "Dunames Dark Witch",
        "Vorse Raider",
        "Exarion Universe",
        "Abyss Soldier",
        "Slate Warrior",
        "Cyber-Tech Alligator",
        "D.D. Assailant",
        "Goblin Zombie",
        "Elemental Hero Madballman",
        "Mind Control",
        "Toon Dark Magician Girl",
        "Great Spirit",
        "Graceful Dice",
        "Negate Attack",
        "Foolish Burial",
        "Card Destruction",
        "Dark Magic Ritual",
        "Calamity of the Wicked"
    ],
    "Special Gift Collection": [
        "Gate Guardian",
        "Scapegoat",
        "Gil Garth",
        "La Jinn the Mystical Genie of the Lamp",
        "Summoned Skull",
        "Inferno Hammer",
        "Gemini Elf",
        "Cyber Harpie Lady",
        "Dandylion",
        "Blade Knight",
        "Curse of Vampire",
        "Elemental Hero Flame Wingman",
        "Magician of Black Chaos"
    ],
    "Fairy Collection": [
        "Silpheed",
        "Dunames Dark Witch",
        "Hysteric Fairy",
        "The Agent of Judgment - Saturn",
        "Shining Angel",
        "Airknight Parshath",
        "Dancing Fairy",
        "Zolga",
        "Kelbek",
        "Mudora",
        "Protective Soul Ailin",
        "Marshmallon",
        "Goddess with the Third Eye",
        "Asura Priest",
        "Manju of the Ten Thousand Hands",
        "Senju of the Thousand Hands"
    ],
    "Dragon Collection": [
        "Victory D.",
        "Chaos Emperor Dragon - Envoy of the End",
        "Kaiser Glider",
        "Horus the Black Flame Dragon LV6",
        "Luster Dragon",
        "Luster Dragon #2",
        "Spear Dragon",
        "Armed Dragon LV3",
        "Armed Dragon LV5",
        "Twin-Headed Behemoth",
        "Cave Dragon",
        "Masked Dragon",
        "Element Dragon",
        "Troop Dragon",
        "Horus the Black Flame Dragon LV4",
        "Pitch-Dark Dragon"
    ],
    "Warrior Collection A": [
        "Gate Guardian",
        "Gearfried the Iron Knight",
        "Dimensional Warrior",
        "Command Knight",
        "The Last Warrior from Another Planet",
        "Dream Clown"
    ],
    "Warrior Collection B": [
        "Don Zaloog",
        "Dark Scorpion - Chick the Yellow",
        "Dark Scorpion - Meanae the Thorn",
        "Dark Scorpion - Gorg the Strong",
        "Cliff the Trap Remover",
        "Ninja Grandmaster Sasuke",
        "D.D. Warrior Lady",
        "Mystic Swordsman LV2",
        "Mystic Swordsman LV4",
        "Mystic Swordsman LV6",
        "Dark Blade",
        "Blindly Loyal Goblin",
        "Exiled Force",
        "Ultimate Baseball Kid",
        "Freed the Matchless General",
        "Holy Knight Ishzark",
        "Silent Swordsman Lv3",
        "Silent Swordsman Lv5",
        "Warrior Lady of the Wasteland",
        "D.D. Assailant",
        "Blade Knight",
        "Marauding Captain",
        "Toon Goblin Attack Force"
    ],
    "Fiend Collection A": [
        "Sangan",
        "Castle of Dark Illusions",
        "Barox",
        "La Jinn the Mystical Genie of the Lamp",
        "Summoned Skull",
        "Beast of Talwar",
        "Sangan",
        "Giant Germ",
        "Spear Cretin",
        "Versago the Destroyer",
        "Toon Summoned Skull"
    ],
    "Fiend Collection B": [
        "Raviel, Lord of Phantasms",
        "Yata-Garasu",
        "Helpoemer",
        "Archfiend Soldier",
        "Skull Descovery Knight",
        "Gil Garth",
        "Opticlops",
        "Zure, Knight of Dark World",
        "Brron, Mad King of Dark World",
        "D.D. Survivor",
        "Skull Archfiend of Lightning",
        "The End of Anubis",
        "Dark Ruler Ha Des",
        "Inferno Hammer",
        "Legendary Fiend",
        "Newdoria",
        "Slate Warrior",
        "Giant Orc",
        "Second Goblin",
        "Kiseitai",
        "Jowls of Dark Demise",
        "D. D. Trainer",
        "Earthbound Spirit"
    ],
    "Machine Collection A": [
        "Cyber-Stein",
        "Mechanicalchaser",
        "Jinzo",
        "UFO Turtle",
        "Cyber-Tech Alligator"
    ],
    "Machine Collection B": [
        "X-Head Cannon",
        "Y-Dragon Head",
        "Z-Metal Tank",
        "XY-Dragon Cannon",
        "XZ-Tank Cannon",
        "YZ-Tank Dragon",
        "XYZ-Dragon Cannon",
        "V-Tiger Jet",
        "W-Wing Catapult",
        "VW-Tiger Catapult",
        "VWXYZ-Dragon Catapult Cannon",
        "Cyber Dragon",
        "Cyber Twin Dragon",
        "Green Gadget",
        "Red Gadget",
        "Yellow Gadget",
        "B.E.S. Tetran"
    ],
    "Spellcaster Collection A": [
        "Exodia",
        "Dark Sage",
        "Dark Magician",
        "Time Wizard",
        "Kazejin",
        "Magician of Faith",
        "Dark Elf",
        "Gemini Elf",
        "Injection Fairy Lily",
        "Cosmo Queen",
        "Magician of Black Chaos"
    ],
    "Spellcaster Collection B": [
        "Jowgen the Spiritualist",
        "Tsukuyomi",
        "Manticore of Darkness",
        "Chaos Command Magician",
        "Cybernetic Magician",
        "Skilled Dark Magician",
        "Kycoo the Ghost Destroyer",
        "Toon Gemini Elf",
        "Toon Masked Sorcerer",
        "Toon Dark Magician Girl",
        "Familiar-Possessed - Aussa",
        "Familiar-Possessed - Eria",
        "Familiar-Possessed - Hiita",
        "Familiar-Possessed - Wynn",
        "Breaker the magical Warrior",
        "The Tricky",
        "Gravekeeper's Spy",
        "Gravekeeper's Guard",
        "Summon Priest",
        "Old Vindictive Magician",
        "Apprentice Magician",
        "Princess Pikeru",
        "Blast Magician",
        "Magical Marionette",
        "Mythical Beast Cerberus",
        "Royal Magical Library",
        "Aussa the Earth Charmer",

    ],
    "Zombie Collection": [
        "Skull Servant",
        "Regenerating Mummy",
        "Ryu Kokki",
        "Spirit Reaper",
        "Pyramid Turtle",
        "Master Kyonshee",
        "Curse of Vampire",
        "Vampire Lord",
        "Goblin Zombie",
        "Decayed Commander",
        "Zombie Tiger",
        "Des Lacooda",
        "Wandering Mummy",
        "Royal Keeper"
    ],
    "Special Monsters A": [
        "X-Head Cannon",
        "Y-Dragon Head",
        "Z-Metal Tank",
        "V-Tiger Jet",
        "W-Wing Catapult",
        "Yata-Garasu",
        "Tsukuyomi",
        "Dark Blade",
        "Toon Gemini Elf",
        "Toon Goblin Attack Force",
        "Toon Masked Sorcerer",
        "Toon Mermaid",
        "Toon Dark Magician Girl",
        "Toon Summoned Skull",
        "Toon World",
        "Burning Beast",
        "Freezing Beast",
        "Metallizing Parasite - Lunatite",
        "Pitch-Dark Dragon",
        "Giant Orc",
        "Second Goblin",
        "Decayed Commander",
        "Zombie Tiger",
        "Vampire Orchis",
        "Des Dendle",
        "Indomitable Fighter Lei Lei",
        "Protective Soul Ailin",
        "Frontline Base",
        "Formation Union",
        "Roll Out!",
        "Asura Priest",
        "Fushi No Tori",
        "Maharaghi",
        "Susa Soldier"
    ],
    "Special Monsters B": [
        "Polymerization",
        "Mystic Swordsman LV2",
        "Mystic Swordsman LV4",
        "Mystic Swordsman LV6",
        "Horus the Black Flame Dragon LV6",
        "Horus the Black Flame Dragon LV4",
        "Armed Dragon LV3",
        "Armed Dragon LV5",
        "Silent Swordsman Lv3",
        "Silent Swordsman Lv5",
        "Elemental Hero Flame Wingman",
        "Elemental Hero Avian",
        "Elemental Hero Burstinatrix",
        "Miracle Fusion",
        "Elemental Hero Madballman",
        "Elemental Hero Bubbleman",
        "Elemental Hero Clayman",
        "Elemental Hero Rampart Blaster",
        "Elemental Hero Shining Flare Wingman",
        "Elemental Hero Sparkman",
        "Elemental Hero Steam Healer",
        "Elemental Hero Thunder Giant",
        "Elemental Hero Wildedge",
        "Elemental Hero Wildheart",
        "Elemental Hero Bladedge",
        "Level Up!",
        "Ultimate Insect Lv3",
        "Ultimate Insect Lv5"
    ],
    "Reverse Collection": [
        "Magical Merchant",
        "Castle of Dark Illusions",
        "Magician of Faith",
        "Penguin Soldier",
        "Blade Knight",
        "Gravekeeper's Spy",
        "Gravekeeper's Guard",
        "Old Vindictive Magician",
        "A Cat of Ill Omen",
        "Jowls of Dark Demise",
        "Cyber Jar",
        "Morphing Jar",
        "Morphing Jar #2",
        "Needle Worm",
        "Spear Cretin",
        "Nobleman of Crossout",
        "Aussa the Earth Charmer"
    ],
    "LP Recovery Collection": [
        "Mystik Wok",
        "Poison of the Old Man",
        "Hysteric Fairy",
        "Dancing Fairy",
        "Zolga",
        "Cestus of Dagla",
        "Nimble Momonga",
        "Solemn Wishes",
        "Cure Mermaid",
        "Princess Pikeru",
        "Kiseitai",
        "Elemental Hero Steam Healer",
        "Fushi No Tori",
        "Emergency Provisions"
    ],
    "Special Summon Collection A": [
        "Perfectly Ultimate Great Moth",
        "Dark Sage",
        "Polymerization",
        "Ritual",
        "Cyber-Stein",
        "Scapegoat",
        "Aqua Spirit",
        "Rock Spirit",
        "Spirit of Flames",
        "Garuda the Wind Spirit",
        "Shining Angel",
        "Mystic Tomato",
        "Giant Rat",
        "Mother Grizzly",
        "UFO Turtle",
        "Flying Kamakiri 1",
        "Giant Germ",
        "Revival Jam",
        "Pyramid Turtle",
        "Troop Dragon",
        "Gravekeeper's Spy",
        "Pitch-Dark Dragon",
        "Decayed Commander",
        "Zombie Tiger",
        "Vampire Orchis",
        "Des Dendle",
        "Nimble Momonga",
        "The Last Warrior from Another Planet",
        "Embodiment of Apophis",
        "Cyber Jar",
        "Morphing Jar #2",
        "Spear Cretin",
        "Dark Magic Curtain"
    ],
    "Special Summon Collection B": [
        "Monster Gate",
        "Chaos Emperor Dragon - Envoy of the End",
        "Ojama Trio",
        "Dimension Fusion",
        "Return from the Different Dimension",
        "Gigantes",
        "Inferno",
        "Silpheed",
        "Mystic Swordsman LV2",
        "Mystic Swordsman LV4",
        "Skilled Dark Magician",
        "Horus the Black Flame Dragon LV6",
        "Armed Dragon LV3",
        "Armed Dragon LV5",
        "Marauding Captain",
        "Masked Dragon",
        "The Tricky",
        "Magical Dimension",
        "Frontline Base",
        "Formation Union",
        "Princess Pikeru",
        "Skull Zoma",
        "Metal Reflect Slime",
        "Level Up!",
        "Howling Insect",
        "Tribute Doll",
        "Enchanting Fitting Room",
        "Stray Lambs"
    ],
    "Special Summon Collection C": [
        "Hamon, Lord of Striking Thunder",
        "Raviel, Lord of Phantasms",
        "Uria, Lord of Searing Flames",
        "Treeborn Frog",
        "Cyber Dragon",
        "Familiar-Possessed - Aussa",
        "Familiar-Possessed - Eria",
        "Familiar-Possessed - Hiita",
        "Familiar-Possessed - Wynn",
        "Silent Swordsman Lv3",
        "Silent Swordsman Lv5",
        "Warrior Lady of the Wasteland",
        "Dandylion",
        "Curse of Vampire",
        "Summon Priest",
        "Miracle Fusion",
        "Elemental Hero Bubbleman",
        "The Dark - Hex-Sealed Fusion",
        "The Earth - Hex-Sealed Fusion",
        "The Light - Hex-Sealed Fusion",
        "Ultimate Insect Lv3",
        "Ultimate Insect Lv5",
        "Rescue Cat",
        "Anteatereatingant"
    ],
    "Equipment Collection": [
        "Megamorph",
        "Cestus of Dagla",
        "United We Stand"
    ],
    "Continuous Spell/Trap A": [
        "Destiny Board",
        "Spirit Message 'I'",
        "Spirit Message 'N'",
        "Spirit Message 'A'",
        "Spirit Message 'L'",
        "Messenger of Peace",
        "Fairy Box",
        "Ultimate Offering",
        "Gravity Bind",
        "Solemn Wishes",
        "Embodiment of Apophis",
        "Toon World"
    ],
    "Continuous Spell/Trap B": [
        "Hamon, Lord of Striking Thunder",
        "Uria, Lord of Searing Flames",
        "Wave-Motion Cannon",
        "Heart of the Underdog",
        "Wall of Revealing Light",
        "Dark Snake Syndrome",
        "Call of the Mummy",
        "Frontline Base",
        "Level Limit - Area B",
        "Skull Zoma",
        "Pitch-Black Power Stone",
        "Metal Reflect Slime"
    ],
    "Quick/Counter Collection": [
        "Mystik Wok",
        "Poison of the Old Man",
        "Scapegoat",
        "Magical Dimension",
        "Enemy Controller",
        "Collapse",
        "Emergency Provisions",
        "Graceful Dice",
        "Offerings to the Doomed",
        "Reload",
        "Rush Recklessly",
        "The Reliable Guardian",
        "Cursed Seal of the Forbidden Spell",
        "Divine Wrath",
        "Horn of Heaven",
        "Magic Drain",
        "Magic Jammer",
        "Negate Attack",
        "Seven Tools of the Bandit",
        "Solemn Judgment",
        "Spell Shield Type-8",
        "Book of Moon",
        "Serial Spell",
        "Mystical Space Typhoon"
    ],
    "Direct Damage Collection": [
        "Hamon, Lord of Striking Thunder",
        "Chaos Emperor Dragon - Envoy of the End",
        "Dark Snake Syndrome",
        "Inferno",
        "Exarion Universe",
        "Kycoo the Ghost Destroyer",
        "Giant Germ",
        "Familiar-Possessed - Aussa",
        "Familiar-Possessed - Eria",
        "Familiar-Possessed - Hiita",
        "Familiar-Possessed - Wynn",
        "Dark Driceratops",
        "Saber Beetle",
        "Thestalos the Firestorm Monarch",
        "Solar Flare Dragon",
        "Ultimate Baseball Kid",
        "Spear Dragon",
        "Oxygeddon",
        "Airknight Parshath",
        "Vampire Lord",
        "Stamping Destruction",
        "Decayed Commander",
        "Jowls of Dark Demise",
        "Stealth Bird",
        "Elemental Hero Bladedge",
    ],
    "Direct Attack Collection": [
        "Victory D.",
        "Dark Scorpion Combination",
        "Spirit Reaper",
        "Elemental Hero Rampart Blaster",
        "Toon Gemini Elf",
        "Toon Goblin Attack Force",
        "Toon Masked Sorcerer",
        "Toon Mermaid",
        "Toon Summoned Skull",
        "Toon Dark Magician Girl"
    ],
    "Monster Destroy Collection": [
        "Hamon, Lord of Striking Thunder",
        "Inferno",
        "Ninja Grandmaster Sasuke",
        "Zaborg the Thunder Monarch",
        "Mystic Swordsman LV2",
        "Mystic Swordsman LV4",
        "Mystic Swordsman LV6",
        "Skull Descovery Knight",
        "Inferno Hammer",
        "Ryu Kokki",
        "Newdoria",
        "Exiled Force",
        "Yomi Ship",
        "Armed Dragon LV5",
        "Element Dragon",
        "Old Vindictive Magician",
        "Magical Dimension",
        "Des Dendle",
        "Nobleman of Crossout",
        "Shield Crash",
        "Tribute to the Doomed",
        "Elemental Hero Flame Wingman",
        "Elemental Hero Shining Flare Wingman",
        "Elemental Hero Steam Healer",
        "Blast Magician",
        "Magical Marionette",
        "Swarm of Scarabs",
        "Offerings to the Doomed",
        "Divine Wrath",
        "Dream Clown"
    ],
}


def get_booster_locations(booster: str) -> Dict[str, str]:
    return {
        f"{booster} {i}": content
        for i, content in enumerate(booster_contents[booster], 1)
    }
