# This file is auto generated. More info: https://github.com/Daivuk/apdoom

from typing import Dict, TypedDict, List, Set 


class LocationDict(TypedDict, total=False): 
    name: str 
    episode: int 
    map: int 
    index: int # Thing index as it is stored in the wad file. 
    doom_type: int # In case index end up unreliable, we can use doom type. Maps have often only one of each important things. 
    region: str 


location_table: Dict[int, LocationDict] = {
    361000: {'name': 'Entryway (MAP01) - Armor',
             'episode': 1,
             'map': 1,
             'index': 17,
             'doom_type': 2018,
             'region': "Entryway (MAP01) Main"},
    361001: {'name': 'Entryway (MAP01) - Shotgun',
             'episode': 1,
             'map': 1,
             'index': 37,
             'doom_type': 2001,
             'region': "Entryway (MAP01) Main"},
    361002: {'name': 'Entryway (MAP01) - Rocket launcher',
             'episode': 1,
             'map': 1,
             'index': 52,
             'doom_type': 2003,
             'region': "Entryway (MAP01) Main"},
    361003: {'name': 'Entryway (MAP01) - Chainsaw',
             'episode': 1,
             'map': 1,
             'index': 68,
             'doom_type': 2005,
             'region': "Entryway (MAP01) Main"},
    361004: {'name': 'Entryway (MAP01) - Exit',
             'episode': 1,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "Entryway (MAP01) Main"},
    361005: {'name': 'Underhalls (MAP02) - Red keycard',
             'episode': 1,
             'map': 2,
             'index': 31,
             'doom_type': 13,
             'region': "Underhalls (MAP02) Main"},
    361006: {'name': 'Underhalls (MAP02) - Blue keycard',
             'episode': 1,
             'map': 2,
             'index': 44,
             'doom_type': 5,
             'region': "Underhalls (MAP02) Red"},
    361007: {'name': 'Underhalls (MAP02) - Mega Armor',
             'episode': 1,
             'map': 2,
             'index': 116,
             'doom_type': 2019,
             'region': "Underhalls (MAP02) Main"},
    361008: {'name': 'Underhalls (MAP02) - Super Shotgun',
             'episode': 1,
             'map': 2,
             'index': 127,
             'doom_type': 82,
             'region': "Underhalls (MAP02) Main"},
    361009: {'name': 'Underhalls (MAP02) - Exit',
             'episode': 1,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "Underhalls (MAP02) Blue"},
    361010: {'name': 'The Gantlet (MAP03) - Mega Armor',
             'episode': 1,
             'map': 3,
             'index': 5,
             'doom_type': 2019,
             'region': "The Gantlet (MAP03) Main"},
    361011: {'name': 'The Gantlet (MAP03) - Shotgun',
             'episode': 1,
             'map': 3,
             'index': 6,
             'doom_type': 2001,
             'region': "The Gantlet (MAP03) Main"},
    361012: {'name': 'The Gantlet (MAP03) - Blue keycard',
             'episode': 1,
             'map': 3,
             'index': 85,
             'doom_type': 5,
             'region': "The Gantlet (MAP03) Main"},
    361013: {'name': 'The Gantlet (MAP03) - Rocket launcher',
             'episode': 1,
             'map': 3,
             'index': 86,
             'doom_type': 2003,
             'region': "The Gantlet (MAP03) Main"},
    361014: {'name': 'The Gantlet (MAP03) - Partial invisibility',
             'episode': 1,
             'map': 3,
             'index': 96,
             'doom_type': 2024,
             'region': "The Gantlet (MAP03) Main"},
    361015: {'name': 'The Gantlet (MAP03) - Supercharge',
             'episode': 1,
             'map': 3,
             'index': 97,
             'doom_type': 2013,
             'region': "The Gantlet (MAP03) Main"},
    361016: {'name': 'The Gantlet (MAP03) - Mega Armor 2',
             'episode': 1,
             'map': 3,
             'index': 98,
             'doom_type': 2019,
             'region': "The Gantlet (MAP03) Main"},
    361017: {'name': 'The Gantlet (MAP03) - Red keycard',
             'episode': 1,
             'map': 3,
             'index': 104,
             'doom_type': 13,
             'region': "The Gantlet (MAP03) Blue"},
    361018: {'name': 'The Gantlet (MAP03) - Chaingun',
             'episode': 1,
             'map': 3,
             'index': 122,
             'doom_type': 2002,
             'region': "The Gantlet (MAP03) Main"},
    361019: {'name': 'The Gantlet (MAP03) - Backpack',
             'episode': 1,
             'map': 3,
             'index': 146,
             'doom_type': 8,
             'region': "The Gantlet (MAP03) Blue"},
    361020: {'name': 'The Gantlet (MAP03) - Exit',
             'episode': 1,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "The Gantlet (MAP03) Red"},
    361021: {'name': 'The Focus (MAP04) - Super Shotgun',
             'episode': 1,
             'map': 4,
             'index': 4,
             'doom_type': 82,
             'region': "The Focus (MAP04) Main"},
    361022: {'name': 'The Focus (MAP04) - Blue keycard',
             'episode': 1,
             'map': 4,
             'index': 21,
             'doom_type': 5,
             'region': "The Focus (MAP04) Main"},
    361023: {'name': 'The Focus (MAP04) - Red keycard',
             'episode': 1,
             'map': 4,
             'index': 32,
             'doom_type': 13,
             'region': "The Focus (MAP04) Blue"},
    361024: {'name': 'The Focus (MAP04) - Yellow keycard',
             'episode': 1,
             'map': 4,
             'index': 59,
             'doom_type': 6,
             'region': "The Focus (MAP04) Red"},
    361025: {'name': 'The Focus (MAP04) - Exit',
             'episode': 1,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "The Focus (MAP04) Yellow"},
    361026: {'name': 'The Waste Tunnels (MAP05) - Rocket launcher',
             'episode': 1,
             'map': 5,
             'index': 45,
             'doom_type': 2003,
             'region': "The Waste Tunnels (MAP05) Main"},
    361027: {'name': 'The Waste Tunnels (MAP05) - Super Shotgun',
             'episode': 1,
             'map': 5,
             'index': 46,
             'doom_type': 82,
             'region': "The Waste Tunnels (MAP05) Start"},
    361028: {'name': 'The Waste Tunnels (MAP05) - Blue keycard',
             'episode': 1,
             'map': 5,
             'index': 50,
             'doom_type': 5,
             'region': "The Waste Tunnels (MAP05) Red"},
    361029: {'name': 'The Waste Tunnels (MAP05) - Plasma gun',
             'episode': 1,
             'map': 5,
             'index': 53,
             'doom_type': 2004,
             'region': "The Waste Tunnels (MAP05) Main"},
    361030: {'name': 'The Waste Tunnels (MAP05) - Red keycard',
             'episode': 1,
             'map': 5,
             'index': 55,
             'doom_type': 13,
             'region': "The Waste Tunnels (MAP05) Main"},
    361031: {'name': 'The Waste Tunnels (MAP05) - Supercharge',
             'episode': 1,
             'map': 5,
             'index': 56,
             'doom_type': 2013,
             'region': "The Waste Tunnels (MAP05) Main"},
    361032: {'name': 'The Waste Tunnels (MAP05) - Mega Armor',
             'episode': 1,
             'map': 5,
             'index': 57,
             'doom_type': 2019,
             'region': "The Waste Tunnels (MAP05) Main"},
    361033: {'name': 'The Waste Tunnels (MAP05) - Yellow keycard',
             'episode': 1,
             'map': 5,
             'index': 78,
             'doom_type': 6,
             'region': "The Waste Tunnels (MAP05) Blue"},
    361034: {'name': 'The Waste Tunnels (MAP05) - Armor',
             'episode': 1,
             'map': 5,
             'index': 151,
             'doom_type': 2018,
             'region': "The Waste Tunnels (MAP05) Main"},
    361035: {'name': 'The Waste Tunnels (MAP05) - Supercharge 2',
             'episode': 1,
             'map': 5,
             'index': 170,
             'doom_type': 2013,
             'region': "The Waste Tunnels (MAP05) Main"},
    361036: {'name': 'The Waste Tunnels (MAP05) - Shotgun',
             'episode': 1,
             'map': 5,
             'index': 202,
             'doom_type': 2001,
             'region': "The Waste Tunnels (MAP05) Start"},
    361037: {'name': 'The Waste Tunnels (MAP05) - Berserk',
             'episode': 1,
             'map': 5,
             'index': 215,
             'doom_type': 2023,
             'region': "The Waste Tunnels (MAP05) Main"},
    361038: {'name': 'The Waste Tunnels (MAP05) - Exit',
             'episode': 1,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "The Waste Tunnels (MAP05) Yellow"},
    361039: {'name': 'The Crusher (MAP06) - Red keycard',
             'episode': 1,
             'map': 6,
             'index': 0,
             'doom_type': 13,
             'region': "The Crusher (MAP06) Blue"},
    361040: {'name': 'The Crusher (MAP06) - Yellow keycard',
             'episode': 1,
             'map': 6,
             'index': 1,
             'doom_type': 6,
             'region': "The Crusher (MAP06) Red"},
    361041: {'name': 'The Crusher (MAP06) - Blue keycard',
             'episode': 1,
             'map': 6,
             'index': 36,
             'doom_type': 5,
             'region': "The Crusher (MAP06) Main"},
    361042: {'name': 'The Crusher (MAP06) - Supercharge',
             'episode': 1,
             'map': 6,
             'index': 55,
             'doom_type': 2013,
             'region': "The Crusher (MAP06) Main"},
    361043: {'name': 'The Crusher (MAP06) - Plasma gun',
             'episode': 1,
             'map': 6,
             'index': 59,
             'doom_type': 2004,
             'region': "The Crusher (MAP06) Main"},
    361044: {'name': 'The Crusher (MAP06) - Blue keycard 2',
             'episode': 1,
             'map': 6,
             'index': 74,
             'doom_type': 5,
             'region': "The Crusher (MAP06) Main"},
    361045: {'name': 'The Crusher (MAP06) - Blue keycard 3',
             'episode': 1,
             'map': 6,
             'index': 75,
             'doom_type': 5,
             'region': "The Crusher (MAP06) Main"},
    361046: {'name': 'The Crusher (MAP06) - Megasphere',
             'episode': 1,
             'map': 6,
             'index': 94,
             'doom_type': 83,
             'region': "The Crusher (MAP06) Main"},
    361047: {'name': 'The Crusher (MAP06) - Armor',
             'episode': 1,
             'map': 6,
             'index': 130,
             'doom_type': 2018,
             'region': "The Crusher (MAP06) Main"},
    361048: {'name': 'The Crusher (MAP06) - Super Shotgun',
             'episode': 1,
             'map': 6,
             'index': 134,
             'doom_type': 82,
             'region': "The Crusher (MAP06) Blue"},
    361049: {'name': 'The Crusher (MAP06) - Mega Armor',
             'episode': 1,
             'map': 6,
             'index': 222,
             'doom_type': 2019,
             'region': "The Crusher (MAP06) Blue"},
    361050: {'name': 'The Crusher (MAP06) - Rocket launcher',
             'episode': 1,
             'map': 6,
             'index': 223,
             'doom_type': 2003,
             'region': "The Crusher (MAP06) Blue"},
    361051: {'name': 'The Crusher (MAP06) - Backpack',
             'episode': 1,
             'map': 6,
             'index': 225,
             'doom_type': 8,
             'region': "The Crusher (MAP06) Blue"},
    361052: {'name': 'The Crusher (MAP06) - Megasphere 2',
             'episode': 1,
             'map': 6,
             'index': 246,
             'doom_type': 83,
             'region': "The Crusher (MAP06) Blue"},
    361053: {'name': 'The Crusher (MAP06) - Exit',
             'episode': 1,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "The Crusher (MAP06) Yellow"},
    361054: {'name': 'Dead Simple (MAP07) - Megasphere',
             'episode': 1,
             'map': 7,
             'index': 4,
             'doom_type': 83,
             'region': "Dead Simple (MAP07) Main"},
    361055: {'name': 'Dead Simple (MAP07) - Rocket launcher',
             'episode': 1,
             'map': 7,
             'index': 5,
             'doom_type': 2003,
             'region': "Dead Simple (MAP07) Main"},
    361056: {'name': 'Dead Simple (MAP07) - Partial invisibility',
             'episode': 1,
             'map': 7,
             'index': 7,
             'doom_type': 2024,
             'region': "Dead Simple (MAP07) Main"},
    361057: {'name': 'Dead Simple (MAP07) - Super Shotgun',
             'episode': 1,
             'map': 7,
             'index': 8,
             'doom_type': 82,
             'region': "Dead Simple (MAP07) Start"},
    361058: {'name': 'Dead Simple (MAP07) - Chaingun',
             'episode': 1,
             'map': 7,
             'index': 9,
             'doom_type': 2002,
             'region': "Dead Simple (MAP07) Main"},
    361059: {'name': 'Dead Simple (MAP07) - Plasma gun',
             'episode': 1,
             'map': 7,
             'index': 10,
             'doom_type': 2004,
             'region': "Dead Simple (MAP07) Main"},
    361060: {'name': 'Dead Simple (MAP07) - Backpack',
             'episode': 1,
             'map': 7,
             'index': 43,
             'doom_type': 8,
             'region': "Dead Simple (MAP07) Start"},
    361061: {'name': 'Dead Simple (MAP07) - Berserk',
             'episode': 1,
             'map': 7,
             'index': 44,
             'doom_type': 2023,
             'region': "Dead Simple (MAP07) Main"},
    361062: {'name': 'Dead Simple (MAP07) - Partial invisibility 2',
             'episode': 1,
             'map': 7,
             'index': 60,
             'doom_type': 2024,
             'region': "Dead Simple (MAP07) Main"},
    361063: {'name': 'Dead Simple (MAP07) - Partial invisibility 3',
             'episode': 1,
             'map': 7,
             'index': 73,
             'doom_type': 2024,
             'region': "Dead Simple (MAP07) Main"},
    361064: {'name': 'Dead Simple (MAP07) - Partial invisibility 4',
             'episode': 1,
             'map': 7,
             'index': 74,
             'doom_type': 2024,
             'region': "Dead Simple (MAP07) Main"},
    361065: {'name': 'Dead Simple (MAP07) - Exit',
             'episode': 1,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "Dead Simple (MAP07) Main"},
    361066: {'name': 'Tricks and Traps (MAP08) - Plasma gun',
             'episode': 1,
             'map': 8,
             'index': 14,
             'doom_type': 2004,
             'region': "Tricks and Traps (MAP08) Main"},
    361067: {'name': 'Tricks and Traps (MAP08) - Rocket launcher',
             'episode': 1,
             'map': 8,
             'index': 17,
             'doom_type': 2003,
             'region': "Tricks and Traps (MAP08) Main"},
    361068: {'name': 'Tricks and Traps (MAP08) - Armor',
             'episode': 1,
             'map': 8,
             'index': 36,
             'doom_type': 2018,
             'region': "Tricks and Traps (MAP08) Main"},
    361069: {'name': 'Tricks and Traps (MAP08) - Chaingun',
             'episode': 1,
             'map': 8,
             'index': 48,
             'doom_type': 2002,
             'region': "Tricks and Traps (MAP08) Main"},
    361070: {'name': 'Tricks and Traps (MAP08) - Shotgun',
             'episode': 1,
             'map': 8,
             'index': 87,
             'doom_type': 2001,
             'region': "Tricks and Traps (MAP08) Main"},
    361071: {'name': 'Tricks and Traps (MAP08) - Supercharge',
             'episode': 1,
             'map': 8,
             'index': 119,
             'doom_type': 2013,
             'region': "Tricks and Traps (MAP08) Main"},
    361072: {'name': 'Tricks and Traps (MAP08) - Invulnerability',
             'episode': 1,
             'map': 8,
             'index': 120,
             'doom_type': 2022,
             'region': "Tricks and Traps (MAP08) Main"},
    361073: {'name': 'Tricks and Traps (MAP08) - Invulnerability 2',
             'episode': 1,
             'map': 8,
             'index': 122,
             'doom_type': 2022,
             'region': "Tricks and Traps (MAP08) Main"},
    361074: {'name': 'Tricks and Traps (MAP08) - Yellow skull key',
             'episode': 1,
             'map': 8,
             'index': 123,
             'doom_type': 39,
             'region': "Tricks and Traps (MAP08) Main"},
    361075: {'name': 'Tricks and Traps (MAP08) - Backpack',
             'episode': 1,
             'map': 8,
             'index': 133,
             'doom_type': 8,
             'region': "Tricks and Traps (MAP08) Main"},
    361076: {'name': 'Tricks and Traps (MAP08) - Backpack 2',
             'episode': 1,
             'map': 8,
             'index': 134,
             'doom_type': 8,
             'region': "Tricks and Traps (MAP08) Main"},
    361077: {'name': 'Tricks and Traps (MAP08) - Invulnerability 3',
             'episode': 1,
             'map': 8,
             'index': 135,
             'doom_type': 2022,
             'region': "Tricks and Traps (MAP08) Main"},
    361078: {'name': 'Tricks and Traps (MAP08) - Invulnerability 4',
             'episode': 1,
             'map': 8,
             'index': 136,
             'doom_type': 2022,
             'region': "Tricks and Traps (MAP08) Main"},
    361079: {'name': 'Tricks and Traps (MAP08) - BFG9000',
             'episode': 1,
             'map': 8,
             'index': 161,
             'doom_type': 2006,
             'region': "Tricks and Traps (MAP08) Main"},
    361080: {'name': 'Tricks and Traps (MAP08) - Supercharge 2',
             'episode': 1,
             'map': 8,
             'index': 162,
             'doom_type': 2013,
             'region': "Tricks and Traps (MAP08) Main"},
    361081: {'name': 'Tricks and Traps (MAP08) - Backpack 3',
             'episode': 1,
             'map': 8,
             'index': 163,
             'doom_type': 8,
             'region': "Tricks and Traps (MAP08) Main"},
    361082: {'name': 'Tricks and Traps (MAP08) - Backpack 4',
             'episode': 1,
             'map': 8,
             'index': 164,
             'doom_type': 8,
             'region': "Tricks and Traps (MAP08) Main"},
    361083: {'name': 'Tricks and Traps (MAP08) - Chainsaw',
             'episode': 1,
             'map': 8,
             'index': 168,
             'doom_type': 2005,
             'region': "Tricks and Traps (MAP08) Main"},
    361084: {'name': 'Tricks and Traps (MAP08) - Red skull key',
             'episode': 1,
             'map': 8,
             'index': 176,
             'doom_type': 38,
             'region': "Tricks and Traps (MAP08) Yellow"},
    361085: {'name': 'Tricks and Traps (MAP08) - Invulnerability 5',
             'episode': 1,
             'map': 8,
             'index': 202,
             'doom_type': 2022,
             'region': "Tricks and Traps (MAP08) Yellow"},
    361086: {'name': 'Tricks and Traps (MAP08) - Armor 2',
             'episode': 1,
             'map': 8,
             'index': 220,
             'doom_type': 2018,
             'region': "Tricks and Traps (MAP08) Main"},
    361087: {'name': 'Tricks and Traps (MAP08) - Backpack 5',
             'episode': 1,
             'map': 8,
             'index': 226,
             'doom_type': 8,
             'region': "Tricks and Traps (MAP08) Main"},
    361088: {'name': 'Tricks and Traps (MAP08) - Partial invisibility',
             'episode': 1,
             'map': 8,
             'index': 235,
             'doom_type': 2024,
             'region': "Tricks and Traps (MAP08) Main"},
    361089: {'name': 'Tricks and Traps (MAP08) - Exit',
             'episode': 1,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "Tricks and Traps (MAP08) Red"},
    361090: {'name': 'The Pit (MAP09) - Berserk',
             'episode': 1,
             'map': 9,
             'index': 5,
             'doom_type': 2023,
             'region': "The Pit (MAP09) Main"},
    361091: {'name': 'The Pit (MAP09) - Shotgun',
             'episode': 1,
             'map': 9,
             'index': 21,
             'doom_type': 2001,
             'region': "The Pit (MAP09) Main"},
    361092: {'name': 'The Pit (MAP09) - Mega Armor',
             'episode': 1,
             'map': 9,
             'index': 26,
             'doom_type': 2019,
             'region': "The Pit (MAP09) Start"},
    361093: {'name': 'The Pit (MAP09) - Supercharge',
             'episode': 1,
             'map': 9,
             'index': 78,
             'doom_type': 2013,
             'region': "The Pit (MAP09) Main"},
    361094: {'name': 'The Pit (MAP09) - Berserk 2',
             'episode': 1,
             'map': 9,
             'index': 90,
             'doom_type': 2023,
             'region': "The Pit (MAP09) Main"},
    361095: {'name': 'The Pit (MAP09) - Rocket launcher',
             'episode': 1,
             'map': 9,
             'index': 92,
             'doom_type': 2003,
             'region': "The Pit (MAP09) Main"},
    361096: {'name': 'The Pit (MAP09) - BFG9000',
             'episode': 1,
             'map': 9,
             'index': 184,
             'doom_type': 2006,
             'region': "The Pit (MAP09) Main"},
    361097: {'name': 'The Pit (MAP09) - Blue keycard',
             'episode': 1,
             'map': 9,
             'index': 185,
             'doom_type': 5,
             'region': "The Pit (MAP09) Main"},
    361098: {'name': 'The Pit (MAP09) - Yellow keycard',
             'episode': 1,
             'map': 9,
             'index': 226,
             'doom_type': 6,
             'region': "The Pit (MAP09) Blue"},
    361099: {'name': 'The Pit (MAP09) - Backpack',
             'episode': 1,
             'map': 9,
             'index': 244,
             'doom_type': 8,
             'region': "The Pit (MAP09) Blue"},
    361100: {'name': 'The Pit (MAP09) - Computer area map',
             'episode': 1,
             'map': 9,
             'index': 245,
             'doom_type': 2026,
             'region': "The Pit (MAP09) Blue"},
    361101: {'name': 'The Pit (MAP09) - Supercharge 2',
             'episode': 1,
             'map': 9,
             'index': 250,
             'doom_type': 2013,
             'region': "The Pit (MAP09) Blue"},
    361102: {'name': 'The Pit (MAP09) - Mega Armor 2',
             'episode': 1,
             'map': 9,
             'index': 251,
             'doom_type': 2019,
             'region': "The Pit (MAP09) Blue"},
    361103: {'name': 'The Pit (MAP09) - Berserk 3',
             'episode': 1,
             'map': 9,
             'index': 309,
             'doom_type': 2023,
             'region': "The Pit (MAP09) Blue"},
    361104: {'name': 'The Pit (MAP09) - Armor',
             'episode': 1,
             'map': 9,
             'index': 348,
             'doom_type': 2018,
             'region': "The Pit (MAP09) Main"},
    361105: {'name': 'The Pit (MAP09) - Exit',
             'episode': 1,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "The Pit (MAP09) Yellow"},
    361106: {'name': 'Refueling Base (MAP10) - BFG9000',
             'episode': 1,
             'map': 10,
             'index': 17,
             'doom_type': 2006,
             'region': "Refueling Base (MAP10) Main"},
    361107: {'name': 'Refueling Base (MAP10) - Supercharge',
             'episode': 1,
             'map': 10,
             'index': 28,
             'doom_type': 2013,
             'region': "Refueling Base (MAP10) Main"},
    361108: {'name': 'Refueling Base (MAP10) - Plasma gun',
             'episode': 1,
             'map': 10,
             'index': 29,
             'doom_type': 2004,
             'region': "Refueling Base (MAP10) Main"},
    361109: {'name': 'Refueling Base (MAP10) - Blue keycard',
             'episode': 1,
             'map': 10,
             'index': 50,
             'doom_type': 5,
             'region': "Refueling Base (MAP10) Main"},
    361110: {'name': 'Refueling Base (MAP10) - Shotgun',
             'episode': 1,
             'map': 10,
             'index': 99,
             'doom_type': 2001,
             'region': "Refueling Base (MAP10) Start"},
    361111: {'name': 'Refueling Base (MAP10) - Chaingun',
             'episode': 1,
             'map': 10,
             'index': 158,
             'doom_type': 2002,
             'region': "Refueling Base (MAP10) Main"},
    361112: {'name': 'Refueling Base (MAP10) - Armor',
             'episode': 1,
             'map': 10,
             'index': 172,
             'doom_type': 2018,
             'region': "Refueling Base (MAP10) Main"},
    361113: {'name': 'Refueling Base (MAP10) - Rocket launcher',
             'episode': 1,
             'map': 10,
             'index': 291,
             'doom_type': 2003,
             'region': "Refueling Base (MAP10) Main"},
    361114: {'name': 'Refueling Base (MAP10) - Supercharge 2',
             'episode': 1,
             'map': 10,
             'index': 359,
             'doom_type': 2013,
             'region': "Refueling Base (MAP10) Main"},
    361115: {'name': 'Refueling Base (MAP10) - Backpack',
             'episode': 1,
             'map': 10,
             'index': 368,
             'doom_type': 8,
             'region': "Refueling Base (MAP10) Main"},
    361116: {'name': 'Refueling Base (MAP10) - Berserk',
             'episode': 1,
             'map': 10,
             'index': 392,
             'doom_type': 2023,
             'region': "Refueling Base (MAP10) Main"},
    361117: {'name': 'Refueling Base (MAP10) - Mega Armor',
             'episode': 1,
             'map': 10,
             'index': 395,
             'doom_type': 2019,
             'region': "Refueling Base (MAP10) Main"},
    361118: {'name': 'Refueling Base (MAP10) - Invulnerability',
             'episode': 1,
             'map': 10,
             'index': 396,
             'doom_type': 2022,
             'region': "Refueling Base (MAP10) Main"},
    361119: {'name': 'Refueling Base (MAP10) - Invulnerability 2',
             'episode': 1,
             'map': 10,
             'index': 398,
             'doom_type': 2022,
             'region': "Refueling Base (MAP10) Main"},
    361120: {'name': 'Refueling Base (MAP10) - Armor 2',
             'episode': 1,
             'map': 10,
             'index': 400,
             'doom_type': 2018,
             'region': "Refueling Base (MAP10) Main"},
    361121: {'name': 'Refueling Base (MAP10) - Berserk 2',
             'episode': 1,
             'map': 10,
             'index': 441,
             'doom_type': 2023,
             'region': "Refueling Base (MAP10) Main"},
    361122: {'name': 'Refueling Base (MAP10) - Partial invisibility',
             'episode': 1,
             'map': 10,
             'index': 470,
             'doom_type': 2024,
             'region': "Refueling Base (MAP10) Main"},
    361123: {'name': 'Refueling Base (MAP10) - Chainsaw',
             'episode': 1,
             'map': 10,
             'index': 472,
             'doom_type': 2005,
             'region': "Refueling Base (MAP10) Main"},
    361124: {'name': 'Refueling Base (MAP10) - Yellow keycard',
             'episode': 1,
             'map': 10,
             'index': 473,
             'doom_type': 6,
             'region': "Refueling Base (MAP10) Main"},
    361125: {'name': 'Refueling Base (MAP10) - Megasphere',
             'episode': 1,
             'map': 10,
             'index': 507,
             'doom_type': 83,
             'region': "Refueling Base (MAP10) Main"},
    361126: {'name': 'Refueling Base (MAP10) - Exit',
             'episode': 1,
             'map': 10,
             'index': -1,
             'doom_type': -1,
             'region': "Refueling Base (MAP10) Yellow Blue"},
    361127: {'name': 'Circle of Death (MAP11) - Red keycard',
             'episode': 1,
             'map': 11,
             'index': 1,
             'doom_type': 13,
             'region': "Circle of Death (MAP11) Main"},
    361128: {'name': 'Circle of Death (MAP11) - Chaingun',
             'episode': 1,
             'map': 11,
             'index': 14,
             'doom_type': 2002,
             'region': "Circle of Death (MAP11) Main"},
    361129: {'name': 'Circle of Death (MAP11) - Supercharge',
             'episode': 1,
             'map': 11,
             'index': 23,
             'doom_type': 2013,
             'region': "Circle of Death (MAP11) Main"},
    361130: {'name': 'Circle of Death (MAP11) - Plasma gun',
             'episode': 1,
             'map': 11,
             'index': 30,
             'doom_type': 2004,
             'region': "Circle of Death (MAP11) Main"},
    361131: {'name': 'Circle of Death (MAP11) - Blue keycard',
             'episode': 1,
             'map': 11,
             'index': 40,
             'doom_type': 5,
             'region': "Circle of Death (MAP11) Main"},
    361132: {'name': 'Circle of Death (MAP11) - Armor',
             'episode': 1,
             'map': 11,
             'index': 42,
             'doom_type': 2018,
             'region': "Circle of Death (MAP11) Main"},
    361133: {'name': 'Circle of Death (MAP11) - Shotgun',
             'episode': 1,
             'map': 11,
             'index': 50,
             'doom_type': 2001,
             'region': "Circle of Death (MAP11) Main"},
    361134: {'name': 'Circle of Death (MAP11) - Mega Armor',
             'episode': 1,
             'map': 11,
             'index': 58,
             'doom_type': 2019,
             'region': "Circle of Death (MAP11) Blue"},
    361135: {'name': 'Circle of Death (MAP11) - Partial invisibility',
             'episode': 1,
             'map': 11,
             'index': 70,
             'doom_type': 2024,
             'region': "Circle of Death (MAP11) Main"},
    361136: {'name': 'Circle of Death (MAP11) - Invulnerability',
             'episode': 1,
             'map': 11,
             'index': 83,
             'doom_type': 2022,
             'region': "Circle of Death (MAP11) Red"},
    361137: {'name': 'Circle of Death (MAP11) - Rocket launcher',
             'episode': 1,
             'map': 11,
             'index': 86,
             'doom_type': 2003,
             'region': "Circle of Death (MAP11) Red"},
    361138: {'name': 'Circle of Death (MAP11) - Backpack',
             'episode': 1,
             'map': 11,
             'index': 88,
             'doom_type': 8,
             'region': "Circle of Death (MAP11) Ending"},
    361139: {'name': 'Circle of Death (MAP11) - Supercharge 2',
             'episode': 1,
             'map': 11,
             'index': 108,
             'doom_type': 2013,
             'region': "Circle of Death (MAP11) Ending"},
    361140: {'name': 'Circle of Death (MAP11) - BFG9000',
             'episode': 1,
             'map': 11,
             'index': 110,
             'doom_type': 2006,
             'region': "Circle of Death (MAP11) Ending"},
    361141: {'name': 'Circle of Death (MAP11) - Exit',
             'episode': 1,
             'map': 11,
             'index': -1,
             'doom_type': -1,
             'region': "Circle of Death (MAP11) Ending"},
    361142: {'name': 'The Factory (MAP12) - Shotgun',
             'episode': 2,
             'map': 1,
             'index': 14,
             'doom_type': 2001,
             'region': "The Factory (MAP12) Outdoors"},
    361143: {'name': 'The Factory (MAP12) - Berserk',
             'episode': 2,
             'map': 1,
             'index': 35,
             'doom_type': 2023,
             'region': "The Factory (MAP12) Main"},
    361144: {'name': 'The Factory (MAP12) - Chaingun',
             'episode': 2,
             'map': 1,
             'index': 38,
             'doom_type': 2002,
             'region': "The Factory (MAP12) Main"},
    361145: {'name': 'The Factory (MAP12) - Supercharge',
             'episode': 2,
             'map': 1,
             'index': 52,
             'doom_type': 2013,
             'region': "The Factory (MAP12) Indoors"},
    361146: {'name': 'The Factory (MAP12) - Blue keycard',
             'episode': 2,
             'map': 1,
             'index': 54,
             'doom_type': 5,
             'region': "The Factory (MAP12) Indoors"},
    361147: {'name': 'The Factory (MAP12) - Armor',
             'episode': 2,
             'map': 1,
             'index': 63,
             'doom_type': 2018,
             'region': "The Factory (MAP12) Blue"},
    361148: {'name': 'The Factory (MAP12) - Backpack',
             'episode': 2,
             'map': 1,
             'index': 70,
             'doom_type': 8,
             'region': "The Factory (MAP12) Blue"},
    361149: {'name': 'The Factory (MAP12) - Supercharge 2',
             'episode': 2,
             'map': 1,
             'index': 83,
             'doom_type': 2013,
             'region': "The Factory (MAP12) Indoors"},
    361150: {'name': 'The Factory (MAP12) - Armor 2',
             'episode': 2,
             'map': 1,
             'index': 92,
             'doom_type': 2018,
             'region': "The Factory (MAP12) Outdoors"},
    361151: {'name': 'The Factory (MAP12) - Partial invisibility',
             'episode': 2,
             'map': 1,
             'index': 93,
             'doom_type': 2024,
             'region': "The Factory (MAP12) Outdoors"},
    361152: {'name': 'The Factory (MAP12) - Berserk 2',
             'episode': 2,
             'map': 1,
             'index': 107,
             'doom_type': 2023,
             'region': "The Factory (MAP12) Indoors"},
    361153: {'name': 'The Factory (MAP12) - Yellow keycard',
             'episode': 2,
             'map': 1,
             'index': 123,
             'doom_type': 6,
             'region': "The Factory (MAP12) Indoors"},
    361154: {'name': 'The Factory (MAP12) - BFG9000',
             'episode': 2,
             'map': 1,
             'index': 135,
             'doom_type': 2006,
             'region': "The Factory (MAP12) Blue"},
    361155: {'name': 'The Factory (MAP12) - Berserk 3',
             'episode': 2,
             'map': 1,
             'index': 189,
             'doom_type': 2023,
             'region': "The Factory (MAP12) Main"},
    361156: {'name': 'The Factory (MAP12) - Super Shotgun',
             'episode': 2,
             'map': 1,
             'index': 192,
             'doom_type': 82,
             'region': "The Factory (MAP12) Indoors"},
    361157: {'name': 'The Factory (MAP12) - Exit',
             'episode': 2,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "The Factory (MAP12) Yellow"},
    361158: {'name': 'Downtown (MAP13) - Rocket launcher',
             'episode': 2,
             'map': 2,
             'index': 4,
             'doom_type': 2003,
             'region': "Downtown (MAP13) Main"},
    361159: {'name': 'Downtown (MAP13) - Shotgun',
             'episode': 2,
             'map': 2,
             'index': 42,
             'doom_type': 2001,
             'region': "Downtown (MAP13) Main"},
    361160: {'name': 'Downtown (MAP13) - Supercharge',
             'episode': 2,
             'map': 2,
             'index': 73,
             'doom_type': 2013,
             'region': "Downtown (MAP13) Main"},
    361161: {'name': 'Downtown (MAP13) - Berserk',
             'episode': 2,
             'map': 2,
             'index': 131,
             'doom_type': 2023,
             'region': "Downtown (MAP13) Main"},
    361162: {'name': 'Downtown (MAP13) - Mega Armor',
             'episode': 2,
             'map': 2,
             'index': 158,
             'doom_type': 2019,
             'region': "Downtown (MAP13) Main"},
    361163: {'name': 'Downtown (MAP13) - Chaingun',
             'episode': 2,
             'map': 2,
             'index': 183,
             'doom_type': 2002,
             'region': "Downtown (MAP13) Main"},
    361164: {'name': 'Downtown (MAP13) - Blue keycard',
             'episode': 2,
             'map': 2,
             'index': 195,
             'doom_type': 5,
             'region': "Downtown (MAP13) Main"},
    361165: {'name': 'Downtown (MAP13) - Yellow keycard',
             'episode': 2,
             'map': 2,
             'index': 201,
             'doom_type': 6,
             'region': "Downtown (MAP13) Red"},
    361166: {'name': 'Downtown (MAP13) - Berserk 2',
             'episode': 2,
             'map': 2,
             'index': 207,
             'doom_type': 2023,
             'region': "Downtown (MAP13) Red"},
    361167: {'name': 'Downtown (MAP13) - Plasma gun',
             'episode': 2,
             'map': 2,
             'index': 231,
             'doom_type': 2004,
             'region': "Downtown (MAP13) Main"},
    361168: {'name': 'Downtown (MAP13) - Partial invisibility',
             'episode': 2,
             'map': 2,
             'index': 249,
             'doom_type': 2024,
             'region': "Downtown (MAP13) Main"},
    361169: {'name': 'Downtown (MAP13) - Backpack',
             'episode': 2,
             'map': 2,
             'index': 250,
             'doom_type': 8,
             'region': "Downtown (MAP13) Main"},
    361170: {'name': 'Downtown (MAP13) - Chainsaw',
             'episode': 2,
             'map': 2,
             'index': 257,
             'doom_type': 2005,
             'region': "Downtown (MAP13) Blue"},
    361171: {'name': 'Downtown (MAP13) - BFG9000',
             'episode': 2,
             'map': 2,
             'index': 258,
             'doom_type': 2006,
             'region': "Downtown (MAP13) Main"},
    361172: {'name': 'Downtown (MAP13) - Invulnerability',
             'episode': 2,
             'map': 2,
             'index': 269,
             'doom_type': 2022,
             'region': "Downtown (MAP13) Blue"},
    361173: {'name': 'Downtown (MAP13) - Invulnerability 2',
             'episode': 2,
             'map': 2,
             'index': 280,
             'doom_type': 2022,
             'region': "Downtown (MAP13) Main"},
    361174: {'name': 'Downtown (MAP13) - Partial invisibility 2',
             'episode': 2,
             'map': 2,
             'index': 281,
             'doom_type': 2024,
             'region': "Downtown (MAP13) Main"},
    361175: {'name': 'Downtown (MAP13) - Partial invisibility 3',
             'episode': 2,
             'map': 2,
             'index': 282,
             'doom_type': 2024,
             'region': "Downtown (MAP13) Main"},
    361176: {'name': 'Downtown (MAP13) - Red keycard',
             'episode': 2,
             'map': 2,
             'index': 283,
             'doom_type': 13,
             'region': "Downtown (MAP13) Blue"},
    361177: {'name': 'Downtown (MAP13) - Berserk 3',
             'episode': 2,
             'map': 2,
             'index': 296,
             'doom_type': 2023,
             'region': "Downtown (MAP13) Yellow"},
    361178: {'name': 'Downtown (MAP13) - Computer area map',
             'episode': 2,
             'map': 2,
             'index': 298,
             'doom_type': 2026,
             'region': "Downtown (MAP13) Main"},
    361179: {'name': 'Downtown (MAP13) - Exit',
             'episode': 2,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "Downtown (MAP13) Yellow"},
    361180: {'name': 'The Inmost Dens (MAP14) - Shotgun',
             'episode': 2,
             'map': 3,
             'index': 13,
             'doom_type': 2001,
             'region': "The Inmost Dens (MAP14) Main"},
    361181: {'name': 'The Inmost Dens (MAP14) - Supercharge',
             'episode': 2,
             'map': 3,
             'index': 16,
             'doom_type': 2013,
             'region': "The Inmost Dens (MAP14) Main"},
    361182: {'name': 'The Inmost Dens (MAP14) - Mega Armor',
             'episode': 2,
             'map': 3,
             'index': 22,
             'doom_type': 2019,
             'region': "The Inmost Dens (MAP14) Main"},
    361183: {'name': 'The Inmost Dens (MAP14) - Berserk',
             'episode': 2,
             'map': 3,
             'index': 78,
             'doom_type': 2023,
             'region': "The Inmost Dens (MAP14) Main"},
    361184: {'name': 'The Inmost Dens (MAP14) - Chaingun',
             'episode': 2,
             'map': 3,
             'index': 80,
             'doom_type': 2002,
             'region': "The Inmost Dens (MAP14) Main"},
    361185: {'name': 'The Inmost Dens (MAP14) - Plasma gun',
             'episode': 2,
             'map': 3,
             'index': 81,
             'doom_type': 2004,
             'region': "The Inmost Dens (MAP14) Main"},
    361186: {'name': 'The Inmost Dens (MAP14) - Red skull key',
             'episode': 2,
             'map': 3,
             'index': 119,
             'doom_type': 38,
             'region': "The Inmost Dens (MAP14) Main"},
    361187: {'name': 'The Inmost Dens (MAP14) - Rocket launcher',
             'episode': 2,
             'map': 3,
             'index': 123,
             'doom_type': 2003,
             'region': "The Inmost Dens (MAP14) Main"},
    361188: {'name': 'The Inmost Dens (MAP14) - Blue skull key',
             'episode': 2,
             'map': 3,
             'index': 130,
             'doom_type': 40,
             'region': "The Inmost Dens (MAP14) Red South"},
    361189: {'name': 'The Inmost Dens (MAP14) - Partial invisibility',
             'episode': 2,
             'map': 3,
             'index': 138,
             'doom_type': 2024,
             'region': "The Inmost Dens (MAP14) Red South"},
    361190: {'name': 'The Inmost Dens (MAP14) - Exit',
             'episode': 2,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "The Inmost Dens (MAP14) Blue"},
    361191: {'name': 'Industrial Zone (MAP15) - Berserk',
             'episode': 2,
             'map': 4,
             'index': 4,
             'doom_type': 2023,
             'region': "Industrial Zone (MAP15) Main"},
    361192: {'name': 'Industrial Zone (MAP15) - Rocket launcher',
             'episode': 2,
             'map': 4,
             'index': 11,
             'doom_type': 2003,
             'region': "Industrial Zone (MAP15) Main"},
    361193: {'name': 'Industrial Zone (MAP15) - Shotgun',
             'episode': 2,
             'map': 4,
             'index': 13,
             'doom_type': 2001,
             'region': "Industrial Zone (MAP15) Main"},
    361194: {'name': 'Industrial Zone (MAP15) - Partial invisibility',
             'episode': 2,
             'map': 4,
             'index': 14,
             'doom_type': 2024,
             'region': "Industrial Zone (MAP15) Main"},
    361195: {'name': 'Industrial Zone (MAP15) - Backpack',
             'episode': 2,
             'map': 4,
             'index': 24,
             'doom_type': 8,
             'region': "Industrial Zone (MAP15) Main"},
    361196: {'name': 'Industrial Zone (MAP15) - BFG9000',
             'episode': 2,
             'map': 4,
             'index': 48,
             'doom_type': 2006,
             'region': "Industrial Zone (MAP15) Main"},
    361197: {'name': 'Industrial Zone (MAP15) - Supercharge',
             'episode': 2,
             'map': 4,
             'index': 56,
             'doom_type': 2013,
             'region': "Industrial Zone (MAP15) Main"},
    361198: {'name': 'Industrial Zone (MAP15) - Mega Armor',
             'episode': 2,
             'map': 4,
             'index': 57,
             'doom_type': 2019,
             'region': "Industrial Zone (MAP15) Main"},
    361199: {'name': 'Industrial Zone (MAP15) - Armor',
             'episode': 2,
             'map': 4,
             'index': 59,
             'doom_type': 2018,
             'region': "Industrial Zone (MAP15) Main"},
    361200: {'name': 'Industrial Zone (MAP15) - Yellow keycard',
             'episode': 2,
             'map': 4,
             'index': 71,
             'doom_type': 6,
             'region': "Industrial Zone (MAP15) Main"},
    361201: {'name': 'Industrial Zone (MAP15) - Chaingun',
             'episode': 2,
             'map': 4,
             'index': 74,
             'doom_type': 2002,
             'region': "Industrial Zone (MAP15) Main"},
    361202: {'name': 'Industrial Zone (MAP15) - Plasma gun',
             'episode': 2,
             'map': 4,
             'index': 86,
             'doom_type': 2004,
             'region': "Industrial Zone (MAP15) Yellow West"},
    361203: {'name': 'Industrial Zone (MAP15) - Partial invisibility 2',
             'episode': 2,
             'map': 4,
             'index': 91,
             'doom_type': 2024,
             'region': "Industrial Zone (MAP15) Yellow West"},
    361204: {'name': 'Industrial Zone (MAP15) - Computer area map',
             'episode': 2,
             'map': 4,
             'index': 93,
             'doom_type': 2026,
             'region': "Industrial Zone (MAP15) Yellow West"},
    361205: {'name': 'Industrial Zone (MAP15) - Invulnerability',
             'episode': 2,
             'map': 4,
             'index': 94,
             'doom_type': 2022,
             'region': "Industrial Zone (MAP15) Main"},
    361206: {'name': 'Industrial Zone (MAP15) - Red keycard',
             'episode': 2,
             'map': 4,
             'index': 100,
             'doom_type': 13,
             'region': "Industrial Zone (MAP15) Main"},
    361207: {'name': 'Industrial Zone (MAP15) - Backpack 2',
             'episode': 2,
             'map': 4,
             'index': 103,
             'doom_type': 8,
             'region': "Industrial Zone (MAP15) Yellow West"},
    361208: {'name': 'Industrial Zone (MAP15) - Chainsaw',
             'episode': 2,
             'map': 4,
             'index': 113,
             'doom_type': 2005,
             'region': "Industrial Zone (MAP15) Yellow East"},
    361209: {'name': 'Industrial Zone (MAP15) - Megasphere',
             'episode': 2,
             'map': 4,
             'index': 125,
             'doom_type': 83,
             'region': "Industrial Zone (MAP15) Yellow East"},
    361210: {'name': 'Industrial Zone (MAP15) - Berserk 2',
             'episode': 2,
             'map': 4,
             'index': 178,
             'doom_type': 2023,
             'region': "Industrial Zone (MAP15) Yellow East"},
    361211: {'name': 'Industrial Zone (MAP15) - Blue keycard',
             'episode': 2,
             'map': 4,
             'index': 337,
             'doom_type': 5,
             'region': "Industrial Zone (MAP15) Yellow West"},
    361212: {'name': 'Industrial Zone (MAP15) - Mega Armor 2',
             'episode': 2,
             'map': 4,
             'index': 361,
             'doom_type': 2019,
             'region': "Industrial Zone (MAP15) Main"},
    361213: {'name': 'Industrial Zone (MAP15) - Exit',
             'episode': 2,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "Industrial Zone (MAP15) Blue"},
    361214: {'name': 'Suburbs (MAP16) - Megasphere',
             'episode': 2,
             'map': 5,
             'index': 7,
             'doom_type': 83,
             'region': "Suburbs (MAP16) Main"},
    361215: {'name': 'Suburbs (MAP16) - Super Shotgun',
             'episode': 2,
             'map': 5,
             'index': 11,
             'doom_type': 82,
             'region': "Suburbs (MAP16) Main"},
    361216: {'name': 'Suburbs (MAP16) - Chaingun',
             'episode': 2,
             'map': 5,
             'index': 15,
             'doom_type': 2002,
             'region': "Suburbs (MAP16) Main"},
    361217: {'name': 'Suburbs (MAP16) - Backpack',
             'episode': 2,
             'map': 5,
             'index': 53,
             'doom_type': 8,
             'region': "Suburbs (MAP16) Main"},
    361218: {'name': 'Suburbs (MAP16) - Rocket launcher',
             'episode': 2,
             'map': 5,
             'index': 59,
             'doom_type': 2003,
             'region': "Suburbs (MAP16) Main"},
    361219: {'name': 'Suburbs (MAP16) - Berserk',
             'episode': 2,
             'map': 5,
             'index': 60,
             'doom_type': 2023,
             'region': "Suburbs (MAP16) Main"},
    361220: {'name': 'Suburbs (MAP16) - Plasma gun',
             'episode': 2,
             'map': 5,
             'index': 62,
             'doom_type': 2004,
             'region': "Suburbs (MAP16) Blue"},
    361221: {'name': 'Suburbs (MAP16) - Plasma gun 2',
             'episode': 2,
             'map': 5,
             'index': 63,
             'doom_type': 2004,
             'region': "Suburbs (MAP16) Blue"},
    361222: {'name': 'Suburbs (MAP16) - Plasma gun 3',
             'episode': 2,
             'map': 5,
             'index': 64,
             'doom_type': 2004,
             'region': "Suburbs (MAP16) Blue"},
    361223: {'name': 'Suburbs (MAP16) - Plasma gun 4',
             'episode': 2,
             'map': 5,
             'index': 65,
             'doom_type': 2004,
             'region': "Suburbs (MAP16) Blue"},
    361224: {'name': 'Suburbs (MAP16) - BFG9000',
             'episode': 2,
             'map': 5,
             'index': 169,
             'doom_type': 2006,
             'region': "Suburbs (MAP16) Main"},
    361225: {'name': 'Suburbs (MAP16) - Shotgun',
             'episode': 2,
             'map': 5,
             'index': 182,
             'doom_type': 2001,
             'region': "Suburbs (MAP16) Main"},
    361226: {'name': 'Suburbs (MAP16) - Supercharge',
             'episode': 2,
             'map': 5,
             'index': 185,
             'doom_type': 2013,
             'region': "Suburbs (MAP16) Main"},
    361227: {'name': 'Suburbs (MAP16) - Blue skull key',
             'episode': 2,
             'map': 5,
             'index': 186,
             'doom_type': 40,
             'region': "Suburbs (MAP16) Main"},
    361228: {'name': 'Suburbs (MAP16) - Invulnerability',
             'episode': 2,
             'map': 5,
             'index': 221,
             'doom_type': 2022,
             'region': "Suburbs (MAP16) Main"},
    361229: {'name': 'Suburbs (MAP16) - Partial invisibility',
             'episode': 2,
             'map': 5,
             'index': 231,
             'doom_type': 2024,
             'region': "Suburbs (MAP16) Main"},
    361230: {'name': 'Suburbs (MAP16) - Red skull key',
             'episode': 2,
             'map': 5,
             'index': 236,
             'doom_type': 38,
             'region': "Suburbs (MAP16) Blue"},
    361231: {'name': 'Suburbs (MAP16) - Exit',
             'episode': 2,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "Suburbs (MAP16) Red"},
    361232: {'name': 'Tenements (MAP17) - Armor',
             'episode': 2,
             'map': 6,
             'index': 1,
             'doom_type': 2018,
             'region': "Tenements (MAP17) Red"},
    361233: {'name': 'Tenements (MAP17) - Supercharge',
             'episode': 2,
             'map': 6,
             'index': 7,
             'doom_type': 2013,
             'region': "Tenements (MAP17) Yellow"},
    361234: {'name': 'Tenements (MAP17) - Shotgun',
             'episode': 2,
             'map': 6,
             'index': 18,
             'doom_type': 2001,
             'region': "Tenements (MAP17) Main"},
    361235: {'name': 'Tenements (MAP17) - Red keycard',
             'episode': 2,
             'map': 6,
             'index': 34,
             'doom_type': 13,
             'region': "Tenements (MAP17) Main"},
    361236: {'name': 'Tenements (MAP17) - Blue keycard',
             'episode': 2,
             'map': 6,
             'index': 69,
             'doom_type': 5,
             'region': "Tenements (MAP17) Red"},
    361237: {'name': 'Tenements (MAP17) - Supercharge 2',
             'episode': 2,
             'map': 6,
             'index': 75,
             'doom_type': 2013,
             'region': "Tenements (MAP17) Blue"},
    361238: {'name': 'Tenements (MAP17) - Yellow skull key',
             'episode': 2,
             'map': 6,
             'index': 76,
             'doom_type': 39,
             'region': "Tenements (MAP17) Blue"},
    361239: {'name': 'Tenements (MAP17) - Rocket launcher',
             'episode': 2,
             'map': 6,
             'index': 77,
             'doom_type': 2003,
             'region': "Tenements (MAP17) Blue"},
    361240: {'name': 'Tenements (MAP17) - Partial invisibility',
             'episode': 2,
             'map': 6,
             'index': 81,
             'doom_type': 2024,
             'region': "Tenements (MAP17) Blue"},
    361241: {'name': 'Tenements (MAP17) - Chaingun',
             'episode': 2,
             'map': 6,
             'index': 92,
             'doom_type': 2002,
             'region': "Tenements (MAP17) Red"},
    361242: {'name': 'Tenements (MAP17) - BFG9000',
             'episode': 2,
             'map': 6,
             'index': 102,
             'doom_type': 2006,
             'region': "Tenements (MAP17) Yellow"},
    361243: {'name': 'Tenements (MAP17) - Plasma gun',
             'episode': 2,
             'map': 6,
             'index': 114,
             'doom_type': 2004,
             'region': "Tenements (MAP17) Yellow"},
    361244: {'name': 'Tenements (MAP17) - Mega Armor',
             'episode': 2,
             'map': 6,
             'index': 168,
             'doom_type': 2019,
             'region': "Tenements (MAP17) Red"},
    361245: {'name': 'Tenements (MAP17) - Armor 2',
             'episode': 2,
             'map': 6,
             'index': 179,
             'doom_type': 2018,
             'region': "Tenements (MAP17) Red"},
    361246: {'name': 'Tenements (MAP17) - Berserk',
             'episode': 2,
             'map': 6,
             'index': 218,
             'doom_type': 2023,
             'region': "Tenements (MAP17) Red"},
    361247: {'name': 'Tenements (MAP17) - Backpack',
             'episode': 2,
             'map': 6,
             'index': 261,
             'doom_type': 8,
             'region': "Tenements (MAP17) Blue"},
    361248: {'name': 'Tenements (MAP17) - Megasphere',
             'episode': 2,
             'map': 6,
             'index': 419,
             'doom_type': 83,
             'region': "Tenements (MAP17) Yellow"},
    361249: {'name': 'Tenements (MAP17) - Exit',
             'episode': 2,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "Tenements (MAP17) Yellow"},
    361250: {'name': 'The Courtyard (MAP18) - Shotgun',
             'episode': 2,
             'map': 7,
             'index': 12,
             'doom_type': 2001,
             'region': "The Courtyard (MAP18) Main"},
    361251: {'name': 'The Courtyard (MAP18) - Plasma gun',
             'episode': 2,
             'map': 7,
             'index': 36,
             'doom_type': 2004,
             'region': "The Courtyard (MAP18) Main"},
    361252: {'name': 'The Courtyard (MAP18) - Armor',
             'episode': 2,
             'map': 7,
             'index': 48,
             'doom_type': 2018,
             'region': "The Courtyard (MAP18) Main"},
    361253: {'name': 'The Courtyard (MAP18) - Berserk',
             'episode': 2,
             'map': 7,
             'index': 52,
             'doom_type': 2023,
             'region': "The Courtyard (MAP18) Main"},
    361254: {'name': 'The Courtyard (MAP18) - Chaingun',
             'episode': 2,
             'map': 7,
             'index': 95,
             'doom_type': 2002,
             'region': "The Courtyard (MAP18) Main"},
    361255: {'name': 'The Courtyard (MAP18) - Rocket launcher',
             'episode': 2,
             'map': 7,
             'index': 130,
             'doom_type': 2003,
             'region': "The Courtyard (MAP18) Main"},
    361256: {'name': 'The Courtyard (MAP18) - Partial invisibility',
             'episode': 2,
             'map': 7,
             'index': 170,
             'doom_type': 2024,
             'region': "The Courtyard (MAP18) Main"},
    361257: {'name': 'The Courtyard (MAP18) - Partial invisibility 2',
             'episode': 2,
             'map': 7,
             'index': 171,
             'doom_type': 2024,
             'region': "The Courtyard (MAP18) Main"},
    361258: {'name': 'The Courtyard (MAP18) - Backpack',
             'episode': 2,
             'map': 7,
             'index': 198,
             'doom_type': 8,
             'region': "The Courtyard (MAP18) Main"},
    361259: {'name': 'The Courtyard (MAP18) - Supercharge',
             'episode': 2,
             'map': 7,
             'index': 218,
             'doom_type': 2013,
             'region': "The Courtyard (MAP18) Main"},
    361260: {'name': 'The Courtyard (MAP18) - Invulnerability',
             'episode': 2,
             'map': 7,
             'index': 228,
             'doom_type': 2022,
             'region': "The Courtyard (MAP18) Main"},
    361261: {'name': 'The Courtyard (MAP18) - Invulnerability 2',
             'episode': 2,
             'map': 7,
             'index': 229,
             'doom_type': 2022,
             'region': "The Courtyard (MAP18) Main"},
    361262: {'name': 'The Courtyard (MAP18) - Yellow skull key',
             'episode': 2,
             'map': 7,
             'index': 254,
             'doom_type': 39,
             'region': "The Courtyard (MAP18) Main"},
    361263: {'name': 'The Courtyard (MAP18) - Blue skull key',
             'episode': 2,
             'map': 7,
             'index': 268,
             'doom_type': 40,
             'region': "The Courtyard (MAP18) Yellow"},
    361264: {'name': 'The Courtyard (MAP18) - BFG9000',
             'episode': 2,
             'map': 7,
             'index': 400,
             'doom_type': 2006,
             'region': "The Courtyard (MAP18) Main"},
    361265: {'name': 'The Courtyard (MAP18) - Computer area map',
             'episode': 2,
             'map': 7,
             'index': 458,
             'doom_type': 2026,
             'region': "The Courtyard (MAP18) Main"},
    361266: {'name': 'The Courtyard (MAP18) - Super Shotgun',
             'episode': 2,
             'map': 7,
             'index': 461,
             'doom_type': 82,
             'region': "The Courtyard (MAP18) Main"},
    361267: {'name': 'The Courtyard (MAP18) - Exit',
             'episode': 2,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "The Courtyard (MAP18) Blue"},
    361268: {'name': 'The Citadel (MAP19) - Armor',
             'episode': 2,
             'map': 8,
             'index': 64,
             'doom_type': 2018,
             'region': "The Citadel (MAP19) Main"},
    361269: {'name': 'The Citadel (MAP19) - Chaingun',
             'episode': 2,
             'map': 8,
             'index': 99,
             'doom_type': 2002,
             'region': "The Citadel (MAP19) Main"},
    361270: {'name': 'The Citadel (MAP19) - Berserk',
             'episode': 2,
             'map': 8,
             'index': 116,
             'doom_type': 2023,
             'region': "The Citadel (MAP19) Main"},
    361271: {'name': 'The Citadel (MAP19) - Mega Armor',
             'episode': 2,
             'map': 8,
             'index': 127,
             'doom_type': 2019,
             'region': "The Citadel (MAP19) Main"},
    361272: {'name': 'The Citadel (MAP19) - Supercharge',
             'episode': 2,
             'map': 8,
             'index': 174,
             'doom_type': 2013,
             'region': "The Citadel (MAP19) Main"},
    361273: {'name': 'The Citadel (MAP19) - Armor 2',
             'episode': 2,
             'map': 8,
             'index': 223,
             'doom_type': 2018,
             'region': "The Citadel (MAP19) Main"},
    361274: {'name': 'The Citadel (MAP19) - Backpack',
             'episode': 2,
             'map': 8,
             'index': 232,
             'doom_type': 8,
             'region': "The Citadel (MAP19) Main"},
    361275: {'name': 'The Citadel (MAP19) - Invulnerability',
             'episode': 2,
             'map': 8,
             'index': 315,
             'doom_type': 2022,
             'region': "The Citadel (MAP19) Main"},
    361276: {'name': 'The Citadel (MAP19) - Blue skull key',
             'episode': 2,
             'map': 8,
             'index': 370,
             'doom_type': 40,
             'region': "The Citadel (MAP19) Main"},
    361277: {'name': 'The Citadel (MAP19) - Partial invisibility',
             'episode': 2,
             'map': 8,
             'index': 403,
             'doom_type': 2024,
             'region': "The Citadel (MAP19) Main"},
    361278: {'name': 'The Citadel (MAP19) - Red skull key',
             'episode': 2,
             'map': 8,
             'index': 404,
             'doom_type': 38,
             'region': "The Citadel (MAP19) Main"},
    361279: {'name': 'The Citadel (MAP19) - Yellow skull key',
             'episode': 2,
             'map': 8,
             'index': 405,
             'doom_type': 39,
             'region': "The Citadel (MAP19) Main"},
    361280: {'name': 'The Citadel (MAP19) - Computer area map',
             'episode': 2,
             'map': 8,
             'index': 415,
             'doom_type': 2026,
             'region': "The Citadel (MAP19) Main"},
    361281: {'name': 'The Citadel (MAP19) - Rocket launcher',
             'episode': 2,
             'map': 8,
             'index': 416,
             'doom_type': 2003,
             'region': "The Citadel (MAP19) Main"},
    361282: {'name': 'The Citadel (MAP19) - Super Shotgun',
             'episode': 2,
             'map': 8,
             'index': 431,
             'doom_type': 82,
             'region': "The Citadel (MAP19) Main"},
    361283: {'name': 'The Citadel (MAP19) - Exit',
             'episode': 2,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "The Citadel (MAP19) Red"},
    361284: {'name': 'Gotcha! (MAP20) - Mega Armor',
             'episode': 2,
             'map': 9,
             'index': 9,
             'doom_type': 2019,
             'region': "Gotcha! (MAP20) Main"},
    361285: {'name': 'Gotcha! (MAP20) - Rocket launcher',
             'episode': 2,
             'map': 9,
             'index': 10,
             'doom_type': 2003,
             'region': "Gotcha! (MAP20) Main"},
    361286: {'name': 'Gotcha! (MAP20) - Supercharge',
             'episode': 2,
             'map': 9,
             'index': 12,
             'doom_type': 2013,
             'region': "Gotcha! (MAP20) Main"},
    361287: {'name': 'Gotcha! (MAP20) - Armor',
             'episode': 2,
             'map': 9,
             'index': 33,
             'doom_type': 2018,
             'region': "Gotcha! (MAP20) Main"},
    361288: {'name': 'Gotcha! (MAP20) - Megasphere',
             'episode': 2,
             'map': 9,
             'index': 43,
             'doom_type': 83,
             'region': "Gotcha! (MAP20) Main"},
    361289: {'name': 'Gotcha! (MAP20) - Armor 2',
             'episode': 2,
             'map': 9,
             'index': 47,
             'doom_type': 2018,
             'region': "Gotcha! (MAP20) Main"},
    361290: {'name': 'Gotcha! (MAP20) - Super Shotgun',
             'episode': 2,
             'map': 9,
             'index': 54,
             'doom_type': 82,
             'region': "Gotcha! (MAP20) Main"},
    361291: {'name': 'Gotcha! (MAP20) - Plasma gun',
             'episode': 2,
             'map': 9,
             'index': 70,
             'doom_type': 2004,
             'region': "Gotcha! (MAP20) Main"},
    361292: {'name': 'Gotcha! (MAP20) - Mega Armor 2',
             'episode': 2,
             'map': 9,
             'index': 96,
             'doom_type': 2019,
             'region': "Gotcha! (MAP20) Main"},
    361293: {'name': 'Gotcha! (MAP20) - Berserk',
             'episode': 2,
             'map': 9,
             'index': 109,
             'doom_type': 2023,
             'region': "Gotcha! (MAP20) Main"},
    361294: {'name': 'Gotcha! (MAP20) - Supercharge 2',
             'episode': 2,
             'map': 9,
             'index': 119,
             'doom_type': 2013,
             'region': "Gotcha! (MAP20) Main"},
    361295: {'name': 'Gotcha! (MAP20) - Supercharge 3',
             'episode': 2,
             'map': 9,
             'index': 122,
             'doom_type': 2013,
             'region': "Gotcha! (MAP20) Main"},
    361296: {'name': 'Gotcha! (MAP20) - BFG9000',
             'episode': 2,
             'map': 9,
             'index': 142,
             'doom_type': 2006,
             'region': "Gotcha! (MAP20) Main"},
    361297: {'name': 'Gotcha! (MAP20) - Supercharge 4',
             'episode': 2,
             'map': 9,
             'index': 145,
             'doom_type': 2013,
             'region': "Gotcha! (MAP20) Main"},
    361298: {'name': 'Gotcha! (MAP20) - Exit',
             'episode': 2,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "Gotcha! (MAP20) Main"},
    361299: {'name': 'Nirvana (MAP21) - Super Shotgun',
             'episode': 3,
             'map': 1,
             'index': 70,
             'doom_type': 82,
             'region': "Nirvana (MAP21) Start"},
    361300: {'name': 'Nirvana (MAP21) - Rocket launcher',
             'episode': 3,
             'map': 1,
             'index': 76,
             'doom_type': 2003,
             'region': "Nirvana (MAP21) Main"},
    361301: {'name': 'Nirvana (MAP21) - Yellow skull key',
             'episode': 3,
             'map': 1,
             'index': 108,
             'doom_type': 39,
             'region': "Nirvana (MAP21) Main"},
    361302: {'name': 'Nirvana (MAP21) - Backpack',
             'episode': 3,
             'map': 1,
             'index': 109,
             'doom_type': 8,
             'region': "Nirvana (MAP21) Main"},
    361303: {'name': 'Nirvana (MAP21) - Megasphere',
             'episode': 3,
             'map': 1,
             'index': 112,
             'doom_type': 83,
             'region': "Nirvana (MAP21) Main"},
    361304: {'name': 'Nirvana (MAP21) - Invulnerability',
             'episode': 3,
             'map': 1,
             'index': 194,
             'doom_type': 2022,
             'region': "Nirvana (MAP21) Yellow"},
    361305: {'name': 'Nirvana (MAP21) - Blue skull key',
             'episode': 3,
             'map': 1,
             'index': 199,
             'doom_type': 40,
             'region': "Nirvana (MAP21) Yellow"},
    361306: {'name': 'Nirvana (MAP21) - Red skull key',
             'episode': 3,
             'map': 1,
             'index': 215,
             'doom_type': 38,
             'region': "Nirvana (MAP21) Yellow"},
    361307: {'name': 'Nirvana (MAP21) - Exit',
             'episode': 3,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "Nirvana (MAP21) Magenta"},
    361308: {'name': 'The Catacombs (MAP22) - Rocket launcher',
             'episode': 3,
             'map': 2,
             'index': 4,
             'doom_type': 2003,
             'region': "The Catacombs (MAP22) Main"},
    361309: {'name': 'The Catacombs (MAP22) - Blue skull key',
             'episode': 3,
             'map': 2,
             'index': 5,
             'doom_type': 40,
             'region': "The Catacombs (MAP22) Main"},
    361310: {'name': 'The Catacombs (MAP22) - Red skull key',
             'episode': 3,
             'map': 2,
             'index': 12,
             'doom_type': 38,
             'region': "The Catacombs (MAP22) Blue"},
    361311: {'name': 'The Catacombs (MAP22) - Shotgun',
             'episode': 3,
             'map': 2,
             'index': 28,
             'doom_type': 2001,
             'region': "The Catacombs (MAP22) Early"},
    361312: {'name': 'The Catacombs (MAP22) - Berserk',
             'episode': 3,
             'map': 2,
             'index': 45,
             'doom_type': 2023,
             'region': "The Catacombs (MAP22) Main"},
    361313: {'name': 'The Catacombs (MAP22) - Plasma gun',
             'episode': 3,
             'map': 2,
             'index': 83,
             'doom_type': 2004,
             'region': "The Catacombs (MAP22) Early"},
    361314: {'name': 'The Catacombs (MAP22) - Supercharge',
             'episode': 3,
             'map': 2,
             'index': 118,
             'doom_type': 2013,
             'region': "The Catacombs (MAP22) Early"},
    361315: {'name': 'The Catacombs (MAP22) - Armor',
             'episode': 3,
             'map': 2,
             'index': 119,
             'doom_type': 2018,
             'region': "The Catacombs (MAP22) Early"},
    361316: {'name': 'The Catacombs (MAP22) - Exit',
             'episode': 3,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "The Catacombs (MAP22) Red"},
    361317: {'name': "Barrels o' Fun (MAP23) - Shotgun",
             'episode': 3,
             'map': 3,
             'index': 136,
             'doom_type': 2001,
             'region': "Barrels o' Fun (MAP23) Main"},
    361318: {'name': "Barrels o' Fun (MAP23) - Berserk",
             'episode': 3,
             'map': 3,
             'index': 222,
             'doom_type': 2023,
             'region': "Barrels o' Fun (MAP23) Main"},
    361319: {'name': "Barrels o' Fun (MAP23) - Backpack",
             'episode': 3,
             'map': 3,
             'index': 223,
             'doom_type': 8,
             'region': "Barrels o' Fun (MAP23) Main"},
    361320: {'name': "Barrels o' Fun (MAP23) - Computer area map",
             'episode': 3,
             'map': 3,
             'index': 224,
             'doom_type': 2026,
             'region': "Barrels o' Fun (MAP23) Main"},
    361321: {'name': "Barrels o' Fun (MAP23) - Armor",
             'episode': 3,
             'map': 3,
             'index': 249,
             'doom_type': 2018,
             'region': "Barrels o' Fun (MAP23) Main"},
    361322: {'name': "Barrels o' Fun (MAP23) - Rocket launcher",
             'episode': 3,
             'map': 3,
             'index': 264,
             'doom_type': 2003,
             'region': "Barrels o' Fun (MAP23) Main"},
    361323: {'name': "Barrels o' Fun (MAP23) - Megasphere",
             'episode': 3,
             'map': 3,
             'index': 266,
             'doom_type': 83,
             'region': "Barrels o' Fun (MAP23) Main"},
    361324: {'name': "Barrels o' Fun (MAP23) - Supercharge",
             'episode': 3,
             'map': 3,
             'index': 277,
             'doom_type': 2013,
             'region': "Barrels o' Fun (MAP23) Main"},
    361325: {'name': "Barrels o' Fun (MAP23) - Backpack 2",
             'episode': 3,
             'map': 3,
             'index': 301,
             'doom_type': 8,
             'region': "Barrels o' Fun (MAP23) Main"},
    361326: {'name': "Barrels o' Fun (MAP23) - Yellow skull key",
             'episode': 3,
             'map': 3,
             'index': 307,
             'doom_type': 39,
             'region': "Barrels o' Fun (MAP23) Main"},
    361327: {'name': "Barrels o' Fun (MAP23) - BFG9000",
             'episode': 3,
             'map': 3,
             'index': 342,
             'doom_type': 2006,
             'region': "Barrels o' Fun (MAP23) Main"},
    361328: {'name': "Barrels o' Fun (MAP23) - Exit",
             'episode': 3,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "Barrels o' Fun (MAP23) Yellow"},
    361329: {'name': 'The Chasm (MAP24) - Plasma gun',
             'episode': 3,
             'map': 4,
             'index': 5,
             'doom_type': 2004,
             'region': "The Chasm (MAP24) Blue"},
    361330: {'name': 'The Chasm (MAP24) - Shotgun',
             'episode': 3,
             'map': 4,
             'index': 6,
             'doom_type': 2001,
             'region': "The Chasm (MAP24) Main"},
    361331: {'name': 'The Chasm (MAP24) - Invulnerability',
             'episode': 3,
             'map': 4,
             'index': 12,
             'doom_type': 2022,
             'region': "The Chasm (MAP24) Blue"},
    361332: {'name': 'The Chasm (MAP24) - Rocket launcher',
             'episode': 3,
             'map': 4,
             'index': 22,
             'doom_type': 2003,
             'region': "The Chasm (MAP24) Main"},
    361333: {'name': 'The Chasm (MAP24) - Blue keycard',
             'episode': 3,
             'map': 4,
             'index': 23,
             'doom_type': 5,
             'region': "The Chasm (MAP24) Main"},
    361334: {'name': 'The Chasm (MAP24) - Backpack',
             'episode': 3,
             'map': 4,
             'index': 31,
             'doom_type': 8,
             'region': "The Chasm (MAP24) Blue"},
    361335: {'name': 'The Chasm (MAP24) - Berserk',
             'episode': 3,
             'map': 4,
             'index': 79,
             'doom_type': 2023,
             'region': "The Chasm (MAP24) Main"},
    361336: {'name': 'The Chasm (MAP24) - Berserk 2',
             'episode': 3,
             'map': 4,
             'index': 155,
             'doom_type': 2023,
             'region': "The Chasm (MAP24) Blue"},
    361337: {'name': 'The Chasm (MAP24) - Armor',
             'episode': 3,
             'map': 4,
             'index': 169,
             'doom_type': 2018,
             'region': "The Chasm (MAP24) Blue"},
    361338: {'name': 'The Chasm (MAP24) - Red keycard',
             'episode': 3,
             'map': 4,
             'index': 261,
             'doom_type': 13,
             'region': "The Chasm (MAP24) Blue"},
    361339: {'name': 'The Chasm (MAP24) - BFG9000',
             'episode': 3,
             'map': 4,
             'index': 295,
             'doom_type': 2006,
             'region': "The Chasm (MAP24) Main"},
    361340: {'name': 'The Chasm (MAP24) - Super Shotgun',
             'episode': 3,
             'map': 4,
             'index': 353,
             'doom_type': 82,
             'region': "The Chasm (MAP24) Main"},
    361341: {'name': 'The Chasm (MAP24) - Megasphere',
             'episode': 3,
             'map': 4,
             'index': 355,
             'doom_type': 83,
             'region': "The Chasm (MAP24) Blue"},
    361342: {'name': 'The Chasm (MAP24) - Megasphere 2',
             'episode': 3,
             'map': 4,
             'index': 362,
             'doom_type': 83,
             'region': "The Chasm (MAP24) Main"},
    361343: {'name': 'The Chasm (MAP24) - Exit',
             'episode': 3,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "The Chasm (MAP24) Red"},
    361344: {'name': 'Bloodfalls (MAP25) - Super Shotgun',
             'episode': 3,
             'map': 5,
             'index': 6,
             'doom_type': 82,
             'region': "Bloodfalls (MAP25) Start"},
    361345: {'name': 'Bloodfalls (MAP25) - Partial invisibility',
             'episode': 3,
             'map': 5,
             'index': 7,
             'doom_type': 2024,
             'region': "Bloodfalls (MAP25) Blue"},
    361346: {'name': 'Bloodfalls (MAP25) - Megasphere',
             'episode': 3,
             'map': 5,
             'index': 23,
             'doom_type': 83,
             'region': "Bloodfalls (MAP25) Main"},
    361347: {'name': 'Bloodfalls (MAP25) - BFG9000',
             'episode': 3,
             'map': 5,
             'index': 34,
             'doom_type': 2006,
             'region': "Bloodfalls (MAP25) Blue"},
    361348: {'name': 'Bloodfalls (MAP25) - Mega Armor',
             'episode': 3,
             'map': 5,
             'index': 103,
             'doom_type': 2019,
             'region': "Bloodfalls (MAP25) Main"},
    361349: {'name': 'Bloodfalls (MAP25) - Armor',
             'episode': 3,
             'map': 5,
             'index': 104,
             'doom_type': 2018,
             'region': "Bloodfalls (MAP25) Main"},
    361350: {'name': 'Bloodfalls (MAP25) - Blue skull key',
             'episode': 3,
             'map': 5,
             'index': 106,
             'doom_type': 40,
             'region': "Bloodfalls (MAP25) Main"},
    361351: {'name': 'Bloodfalls (MAP25) - Chaingun',
             'episode': 3,
             'map': 5,
             'index': 150,
             'doom_type': 2002,
             'region': "Bloodfalls (MAP25) Main"},
    361352: {'name': 'Bloodfalls (MAP25) - Plasma gun',
             'episode': 3,
             'map': 5,
             'index': 169,
             'doom_type': 2004,
             'region': "Bloodfalls (MAP25) Main"},
    361353: {'name': 'Bloodfalls (MAP25) - BFG9000 2',
             'episode': 3,
             'map': 5,
             'index': 186,
             'doom_type': 2006,
             'region': "Bloodfalls (MAP25) Main"},
    361354: {'name': 'Bloodfalls (MAP25) - Rocket launcher',
             'episode': 3,
             'map': 5,
             'index': 236,
             'doom_type': 2003,
             'region': "Bloodfalls (MAP25) Main"},
    361355: {'name': 'Bloodfalls (MAP25) - Exit',
             'episode': 3,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "Bloodfalls (MAP25) Blue"},
    361356: {'name': 'The Abandoned Mines (MAP26) - Blue keycard',
             'episode': 3,
             'map': 6,
             'index': 20,
             'doom_type': 5,
             'region': "The Abandoned Mines (MAP26) Red"},
    361357: {'name': 'The Abandoned Mines (MAP26) - Super Shotgun',
             'episode': 3,
             'map': 6,
             'index': 21,
             'doom_type': 82,
             'region': "The Abandoned Mines (MAP26) Main"},
    361358: {'name': 'The Abandoned Mines (MAP26) - Rocket launcher',
             'episode': 3,
             'map': 6,
             'index': 49,
             'doom_type': 2003,
             'region': "The Abandoned Mines (MAP26) Main"},
    361359: {'name': 'The Abandoned Mines (MAP26) - Mega Armor',
             'episode': 3,
             'map': 6,
             'index': 95,
             'doom_type': 2019,
             'region': "The Abandoned Mines (MAP26) Red"},
    361360: {'name': 'The Abandoned Mines (MAP26) - Plasma gun',
             'episode': 3,
             'map': 6,
             'index': 107,
             'doom_type': 2004,
             'region': "The Abandoned Mines (MAP26) Main"},
    361361: {'name': 'The Abandoned Mines (MAP26) - Supercharge',
             'episode': 3,
             'map': 6,
             'index': 154,
             'doom_type': 2013,
             'region': "The Abandoned Mines (MAP26) Red"},
    361362: {'name': 'The Abandoned Mines (MAP26) - Chaingun',
             'episode': 3,
             'map': 6,
             'index': 155,
             'doom_type': 2002,
             'region': "The Abandoned Mines (MAP26) Main"},
    361363: {'name': 'The Abandoned Mines (MAP26) - Partial invisibility',
             'episode': 3,
             'map': 6,
             'index': 159,
             'doom_type': 2024,
             'region': "The Abandoned Mines (MAP26) Main"},
    361364: {'name': 'The Abandoned Mines (MAP26) - Armor',
             'episode': 3,
             'map': 6,
             'index': 170,
             'doom_type': 2018,
             'region': "The Abandoned Mines (MAP26) Main"},
    361365: {'name': 'The Abandoned Mines (MAP26) - Red keycard',
             'episode': 3,
             'map': 6,
             'index': 182,
             'doom_type': 13,
             'region': "The Abandoned Mines (MAP26) Main"},
    361366: {'name': 'The Abandoned Mines (MAP26) - Yellow keycard',
             'episode': 3,
             'map': 6,
             'index': 229,
             'doom_type': 6,
             'region': "The Abandoned Mines (MAP26) Blue"},
    361367: {'name': 'The Abandoned Mines (MAP26) - Backpack',
             'episode': 3,
             'map': 6,
             'index': 254,
             'doom_type': 8,
             'region': "The Abandoned Mines (MAP26) Main"},
    361368: {'name': 'The Abandoned Mines (MAP26) - Exit',
             'episode': 3,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "The Abandoned Mines (MAP26) Yellow"},
    361369: {'name': 'Monster Condo (MAP27) - Rocket launcher',
             'episode': 3,
             'map': 7,
             'index': 4,
             'doom_type': 2003,
             'region': "Monster Condo (MAP27) Main"},
    361370: {'name': 'Monster Condo (MAP27) - Partial invisibility',
             'episode': 3,
             'map': 7,
             'index': 51,
             'doom_type': 2024,
             'region': "Monster Condo (MAP27) Main"},
    361371: {'name': 'Monster Condo (MAP27) - Plasma gun',
             'episode': 3,
             'map': 7,
             'index': 58,
             'doom_type': 2004,
             'region': "Monster Condo (MAP27) Main"},
    361372: {'name': 'Monster Condo (MAP27) - Invulnerability',
             'episode': 3,
             'map': 7,
             'index': 60,
             'doom_type': 2022,
             'region': "Monster Condo (MAP27) Main"},
    361373: {'name': 'Monster Condo (MAP27) - Armor',
             'episode': 3,
             'map': 7,
             'index': 86,
             'doom_type': 2018,
             'region': "Monster Condo (MAP27) Main"},
    361374: {'name': 'Monster Condo (MAP27) - Backpack',
             'episode': 3,
             'map': 7,
             'index': 105,
             'doom_type': 8,
             'region': "Monster Condo (MAP27) Main"},
    361375: {'name': 'Monster Condo (MAP27) - Invulnerability 2',
             'episode': 3,
             'map': 7,
             'index': 107,
             'doom_type': 2022,
             'region': "Monster Condo (MAP27) Main"},
    361376: {'name': 'Monster Condo (MAP27) - Partial invisibility 2',
             'episode': 3,
             'map': 7,
             'index': 122,
             'doom_type': 2024,
             'region': "Monster Condo (MAP27) Main"},
    361377: {'name': 'Monster Condo (MAP27) - Supercharge',
             'episode': 3,
             'map': 7,
             'index': 236,
             'doom_type': 2013,
             'region': "Monster Condo (MAP27) Main"},
    361378: {'name': 'Monster Condo (MAP27) - Armor 2',
             'episode': 3,
             'map': 7,
             'index': 239,
             'doom_type': 2018,
             'region': "Monster Condo (MAP27) Main"},
    361379: {'name': 'Monster Condo (MAP27) - Chaingun',
             'episode': 3,
             'map': 7,
             'index': 251,
             'doom_type': 2002,
             'region': "Monster Condo (MAP27) Main"},
    361380: {'name': 'Monster Condo (MAP27) - BFG9000',
             'episode': 3,
             'map': 7,
             'index': 279,
             'doom_type': 2006,
             'region': "Monster Condo (MAP27) Main"},
    361381: {'name': 'Monster Condo (MAP27) - Backpack 2',
             'episode': 3,
             'map': 7,
             'index': 285,
             'doom_type': 8,
             'region': "Monster Condo (MAP27) Main"},
    361382: {'name': 'Monster Condo (MAP27) - Backpack 3',
             'episode': 3,
             'map': 7,
             'index': 286,
             'doom_type': 8,
             'region': "Monster Condo (MAP27) Main"},
    361383: {'name': 'Monster Condo (MAP27) - Backpack 4',
             'episode': 3,
             'map': 7,
             'index': 287,
             'doom_type': 8,
             'region': "Monster Condo (MAP27) Main"},
    361384: {'name': 'Monster Condo (MAP27) - Yellow skull key',
             'episode': 3,
             'map': 7,
             'index': 310,
             'doom_type': 39,
             'region': "Monster Condo (MAP27) Main"},
    361385: {'name': 'Monster Condo (MAP27) - Red skull key',
             'episode': 3,
             'map': 7,
             'index': 364,
             'doom_type': 38,
             'region': "Monster Condo (MAP27) Blue"},
    361386: {'name': 'Monster Condo (MAP27) - Supercharge 2',
             'episode': 3,
             'map': 7,
             'index': 365,
             'doom_type': 2013,
             'region': "Monster Condo (MAP27) Blue"},
    361387: {'name': 'Monster Condo (MAP27) - Blue skull key',
             'episode': 3,
             'map': 7,
             'index': 382,
             'doom_type': 40,
             'region': "Monster Condo (MAP27) Yellow"},
    361388: {'name': 'Monster Condo (MAP27) - Supercharge 3',
             'episode': 3,
             'map': 7,
             'index': 392,
             'doom_type': 2013,
             'region': "Monster Condo (MAP27) Yellow"},
    361389: {'name': 'Monster Condo (MAP27) - Computer area map',
             'episode': 3,
             'map': 7,
             'index': 393,
             'doom_type': 2026,
             'region': "Monster Condo (MAP27) Yellow"},
    361390: {'name': 'Monster Condo (MAP27) - Berserk',
             'episode': 3,
             'map': 7,
             'index': 394,
             'doom_type': 2023,
             'region': "Monster Condo (MAP27) Yellow"},
    361391: {'name': 'Monster Condo (MAP27) - Supercharge 4',
             'episode': 3,
             'map': 7,
             'index': 414,
             'doom_type': 2013,
             'region': "Monster Condo (MAP27) Yellow"},
    361392: {'name': 'Monster Condo (MAP27) - Supercharge 5',
             'episode': 3,
             'map': 7,
             'index': 424,
             'doom_type': 2013,
             'region': "Monster Condo (MAP27) Yellow"},
    361393: {'name': 'Monster Condo (MAP27) - Computer area map 2',
             'episode': 3,
             'map': 7,
             'index': 425,
             'doom_type': 2026,
             'region': "Monster Condo (MAP27) Yellow"},
    361394: {'name': 'Monster Condo (MAP27) - Berserk 2',
             'episode': 3,
             'map': 7,
             'index': 426,
             'doom_type': 2023,
             'region': "Monster Condo (MAP27) Yellow"},
    361395: {'name': 'Monster Condo (MAP27) - Partial invisibility 3',
             'episode': 3,
             'map': 7,
             'index': 454,
             'doom_type': 2024,
             'region': "Monster Condo (MAP27) Yellow"},
    361396: {'name': 'Monster Condo (MAP27) - Invulnerability 3',
             'episode': 3,
             'map': 7,
             'index': 455,
             'doom_type': 2022,
             'region': "Monster Condo (MAP27) Yellow"},
    361397: {'name': 'Monster Condo (MAP27) - Chainsaw',
             'episode': 3,
             'map': 7,
             'index': 460,
             'doom_type': 2005,
             'region': "Monster Condo (MAP27) Main"},
    361398: {'name': 'Monster Condo (MAP27) - Super Shotgun',
             'episode': 3,
             'map': 7,
             'index': 470,
             'doom_type': 82,
             'region': "Monster Condo (MAP27) Main"},
    361399: {'name': 'Monster Condo (MAP27) - Exit',
             'episode': 3,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "Monster Condo (MAP27) Red"},
    361400: {'name': 'The Spirit World (MAP28) - Armor',
             'episode': 3,
             'map': 8,
             'index': 19,
             'doom_type': 2018,
             'region': "The Spirit World (MAP28) Main"},
    361401: {'name': 'The Spirit World (MAP28) - Chainsaw',
             'episode': 3,
             'map': 8,
             'index': 66,
             'doom_type': 2005,
             'region': "The Spirit World (MAP28) Main"},
    361402: {'name': 'The Spirit World (MAP28) - Invulnerability',
             'episode': 3,
             'map': 8,
             'index': 76,
             'doom_type': 2022,
             'region': "The Spirit World (MAP28) Main"},
    361403: {'name': 'The Spirit World (MAP28) - Yellow skull key',
             'episode': 3,
             'map': 8,
             'index': 87,
             'doom_type': 39,
             'region': "The Spirit World (MAP28) Main"},
    361404: {'name': 'The Spirit World (MAP28) - Supercharge',
             'episode': 3,
             'map': 8,
             'index': 95,
             'doom_type': 2013,
             'region': "The Spirit World (MAP28) Main"},
    361405: {'name': 'The Spirit World (MAP28) - Chaingun',
             'episode': 3,
             'map': 8,
             'index': 96,
             'doom_type': 2002,
             'region': "The Spirit World (MAP28) Main"},
    361406: {'name': 'The Spirit World (MAP28) - Rocket launcher',
             'episode': 3,
             'map': 8,
             'index': 124,
             'doom_type': 2003,
             'region': "The Spirit World (MAP28) Main"},
    361407: {'name': 'The Spirit World (MAP28) - Backpack',
             'episode': 3,
             'map': 8,
             'index': 155,
             'doom_type': 8,
             'region': "The Spirit World (MAP28) Main"},
    361408: {'name': 'The Spirit World (MAP28) - Backpack 2',
             'episode': 3,
             'map': 8,
             'index': 156,
             'doom_type': 8,
             'region': "The Spirit World (MAP28) Main"},
    361409: {'name': 'The Spirit World (MAP28) - Backpack 3',
             'episode': 3,
             'map': 8,
             'index': 157,
             'doom_type': 8,
             'region': "The Spirit World (MAP28) Main"},
    361410: {'name': 'The Spirit World (MAP28) - Backpack 4',
             'episode': 3,
             'map': 8,
             'index': 158,
             'doom_type': 8,
             'region': "The Spirit World (MAP28) Main"},
    361411: {'name': 'The Spirit World (MAP28) - Berserk',
             'episode': 3,
             'map': 8,
             'index': 159,
             'doom_type': 2023,
             'region': "The Spirit World (MAP28) Main"},
    361412: {'name': 'The Spirit World (MAP28) - Plasma gun',
             'episode': 3,
             'map': 8,
             'index': 163,
             'doom_type': 2004,
             'region': "The Spirit World (MAP28) Main"},
    361413: {'name': 'The Spirit World (MAP28) - Invulnerability 2',
             'episode': 3,
             'map': 8,
             'index': 179,
             'doom_type': 2022,
             'region': "The Spirit World (MAP28) Main"},
    361414: {'name': 'The Spirit World (MAP28) - Invulnerability 3',
             'episode': 3,
             'map': 8,
             'index': 180,
             'doom_type': 2022,
             'region': "The Spirit World (MAP28) Main"},
    361415: {'name': 'The Spirit World (MAP28) - BFG9000',
             'episode': 3,
             'map': 8,
             'index': 181,
             'doom_type': 2006,
             'region': "The Spirit World (MAP28) Main"},
    361416: {'name': 'The Spirit World (MAP28) - Megasphere',
             'episode': 3,
             'map': 8,
             'index': 183,
             'doom_type': 83,
             'region': "The Spirit World (MAP28) Main"},
    361417: {'name': 'The Spirit World (MAP28) - Megasphere 2',
             'episode': 3,
             'map': 8,
             'index': 185,
             'doom_type': 83,
             'region': "The Spirit World (MAP28) Main"},
    361418: {'name': 'The Spirit World (MAP28) - Invulnerability 4',
             'episode': 3,
             'map': 8,
             'index': 186,
             'doom_type': 2022,
             'region': "The Spirit World (MAP28) Main"},
    361419: {'name': 'The Spirit World (MAP28) - Invulnerability 5',
             'episode': 3,
             'map': 8,
             'index': 195,
             'doom_type': 2022,
             'region': "The Spirit World (MAP28) Main"},
    361420: {'name': 'The Spirit World (MAP28) - Super Shotgun',
             'episode': 3,
             'map': 8,
             'index': 214,
             'doom_type': 82,
             'region': "The Spirit World (MAP28) Main"},
    361421: {'name': 'The Spirit World (MAP28) - Red skull key',
             'episode': 3,
             'map': 8,
             'index': 216,
             'doom_type': 38,
             'region': "The Spirit World (MAP28) Yellow"},
    361422: {'name': 'The Spirit World (MAP28) - Exit',
             'episode': 3,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "The Spirit World (MAP28) Red"},
    361423: {'name': 'The Living End (MAP29) - Chaingun',
             'episode': 3,
             'map': 9,
             'index': 85,
             'doom_type': 2002,
             'region': "The Living End (MAP29) Main"},
    361424: {'name': 'The Living End (MAP29) - Plasma gun',
             'episode': 3,
             'map': 9,
             'index': 124,
             'doom_type': 2004,
             'region': "The Living End (MAP29) Main"},
    361425: {'name': 'The Living End (MAP29) - Backpack',
             'episode': 3,
             'map': 9,
             'index': 179,
             'doom_type': 8,
             'region': "The Living End (MAP29) Main"},
    361426: {'name': 'The Living End (MAP29) - Super Shotgun',
             'episode': 3,
             'map': 9,
             'index': 195,
             'doom_type': 82,
             'region': "The Living End (MAP29) Main"},
    361427: {'name': 'The Living End (MAP29) - Mega Armor',
             'episode': 3,
             'map': 9,
             'index': 216,
             'doom_type': 2019,
             'region': "The Living End (MAP29) Main"},
    361428: {'name': 'The Living End (MAP29) - Armor',
             'episode': 3,
             'map': 9,
             'index': 224,
             'doom_type': 2018,
             'region': "The Living End (MAP29) Main"},
    361429: {'name': 'The Living End (MAP29) - Backpack 2',
             'episode': 3,
             'map': 9,
             'index': 235,
             'doom_type': 8,
             'region': "The Living End (MAP29) Main"},
    361430: {'name': 'The Living End (MAP29) - Supercharge',
             'episode': 3,
             'map': 9,
             'index': 237,
             'doom_type': 2013,
             'region': "The Living End (MAP29) Main"},
    361431: {'name': 'The Living End (MAP29) - Berserk',
             'episode': 3,
             'map': 9,
             'index': 241,
             'doom_type': 2023,
             'region': "The Living End (MAP29) Main"},
    361432: {'name': 'The Living End (MAP29) - Berserk 2',
             'episode': 3,
             'map': 9,
             'index': 263,
             'doom_type': 2023,
             'region': "The Living End (MAP29) Main"},
    361433: {'name': 'The Living End (MAP29) - Exit',
             'episode': 3,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "The Living End (MAP29) Main"},
    361434: {'name': 'Icon of Sin (MAP30) - Supercharge',
             'episode': 3,
             'map': 10,
             'index': 25,
             'doom_type': 2013,
             'region': "Icon of Sin (MAP30) Main"},
    361435: {'name': 'Icon of Sin (MAP30) - Supercharge 2',
             'episode': 3,
             'map': 10,
             'index': 26,
             'doom_type': 2013,
             'region': "Icon of Sin (MAP30) Main"},
    361436: {'name': 'Icon of Sin (MAP30) - Supercharge 3',
             'episode': 3,
             'map': 10,
             'index': 28,
             'doom_type': 2013,
             'region': "Icon of Sin (MAP30) Main"},
    361437: {'name': 'Icon of Sin (MAP30) - Invulnerability',
             'episode': 3,
             'map': 10,
             'index': 29,
             'doom_type': 2022,
             'region': "Icon of Sin (MAP30) Main"},
    361438: {'name': 'Icon of Sin (MAP30) - Invulnerability 2',
             'episode': 3,
             'map': 10,
             'index': 30,
             'doom_type': 2022,
             'region': "Icon of Sin (MAP30) Main"},
    361439: {'name': 'Icon of Sin (MAP30) - Invulnerability 3',
             'episode': 3,
             'map': 10,
             'index': 31,
             'doom_type': 2022,
             'region': "Icon of Sin (MAP30) Main"},
    361440: {'name': 'Icon of Sin (MAP30) - Invulnerability 4',
             'episode': 3,
             'map': 10,
             'index': 32,
             'doom_type': 2022,
             'region': "Icon of Sin (MAP30) Main"},
    361441: {'name': 'Icon of Sin (MAP30) - BFG9000',
             'episode': 3,
             'map': 10,
             'index': 40,
             'doom_type': 2006,
             'region': "Icon of Sin (MAP30) Start"},
    361442: {'name': 'Icon of Sin (MAP30) - Chaingun',
             'episode': 3,
             'map': 10,
             'index': 41,
             'doom_type': 2002,
             'region': "Icon of Sin (MAP30) Start"},
    361443: {'name': 'Icon of Sin (MAP30) - Chainsaw',
             'episode': 3,
             'map': 10,
             'index': 42,
             'doom_type': 2005,
             'region': "Icon of Sin (MAP30) Start"},
    361444: {'name': 'Icon of Sin (MAP30) - Plasma gun',
             'episode': 3,
             'map': 10,
             'index': 43,
             'doom_type': 2004,
             'region': "Icon of Sin (MAP30) Start"},
    361445: {'name': 'Icon of Sin (MAP30) - Rocket launcher',
             'episode': 3,
             'map': 10,
             'index': 44,
             'doom_type': 2003,
             'region': "Icon of Sin (MAP30) Start"},
    361446: {'name': 'Icon of Sin (MAP30) - Shotgun',
             'episode': 3,
             'map': 10,
             'index': 45,
             'doom_type': 2001,
             'region': "Icon of Sin (MAP30) Start"},
    361447: {'name': 'Icon of Sin (MAP30) - Super Shotgun',
             'episode': 3,
             'map': 10,
             'index': 46,
             'doom_type': 82,
             'region': "Icon of Sin (MAP30) Start"},
    361448: {'name': 'Icon of Sin (MAP30) - Backpack',
             'episode': 3,
             'map': 10,
             'index': 47,
             'doom_type': 8,
             'region': "Icon of Sin (MAP30) Start"},
    361449: {'name': 'Icon of Sin (MAP30) - Megasphere',
             'episode': 3,
             'map': 10,
             'index': 64,
             'doom_type': 83,
             'region': "Icon of Sin (MAP30) Start"},
    361450: {'name': 'Icon of Sin (MAP30) - Megasphere 2',
             'episode': 3,
             'map': 10,
             'index': 85,
             'doom_type': 83,
             'region': "Icon of Sin (MAP30) Main"},
    361451: {'name': 'Icon of Sin (MAP30) - Berserk',
             'episode': 3,
             'map': 10,
             'index': 94,
             'doom_type': 2023,
             'region': "Icon of Sin (MAP30) Main"},
    361452: {'name': 'Icon of Sin (MAP30) - Exit',
             'episode': 3,
             'map': 10,
             'index': -1,
             'doom_type': -1,
             'region': "Icon of Sin (MAP30) Main"},
    361453: {'name': 'Wolfenstein (MAP31) - Rocket launcher',
             'episode': 4,
             'map': 1,
             'index': 110,
             'doom_type': 2003,
             'region': "Wolfenstein (MAP31) Main"},
    361454: {'name': 'Wolfenstein (MAP31) - Shotgun',
             'episode': 4,
             'map': 1,
             'index': 139,
             'doom_type': 2001,
             'region': "Wolfenstein (MAP31) Main"},
    361455: {'name': 'Wolfenstein (MAP31) - Berserk',
             'episode': 4,
             'map': 1,
             'index': 263,
             'doom_type': 2023,
             'region': "Wolfenstein (MAP31) Main"},
    361456: {'name': 'Wolfenstein (MAP31) - Supercharge',
             'episode': 4,
             'map': 1,
             'index': 278,
             'doom_type': 2013,
             'region': "Wolfenstein (MAP31) Main"},
    361457: {'name': 'Wolfenstein (MAP31) - Chaingun',
             'episode': 4,
             'map': 1,
             'index': 305,
             'doom_type': 2002,
             'region': "Wolfenstein (MAP31) Main"},
    361458: {'name': 'Wolfenstein (MAP31) - Super Shotgun',
             'episode': 4,
             'map': 1,
             'index': 308,
             'doom_type': 82,
             'region': "Wolfenstein (MAP31) Main"},
    361459: {'name': 'Wolfenstein (MAP31) - Partial invisibility',
             'episode': 4,
             'map': 1,
             'index': 309,
             'doom_type': 2024,
             'region': "Wolfenstein (MAP31) Main"},
    361460: {'name': 'Wolfenstein (MAP31) - Megasphere',
             'episode': 4,
             'map': 1,
             'index': 310,
             'doom_type': 83,
             'region': "Wolfenstein (MAP31) Main"},
    361461: {'name': 'Wolfenstein (MAP31) - Backpack',
             'episode': 4,
             'map': 1,
             'index': 311,
             'doom_type': 8,
             'region': "Wolfenstein (MAP31) Main"},
    361462: {'name': 'Wolfenstein (MAP31) - Backpack 2',
             'episode': 4,
             'map': 1,
             'index': 312,
             'doom_type': 8,
             'region': "Wolfenstein (MAP31) Main"},
    361463: {'name': 'Wolfenstein (MAP31) - Backpack 3',
             'episode': 4,
             'map': 1,
             'index': 313,
             'doom_type': 8,
             'region': "Wolfenstein (MAP31) Main"},
    361464: {'name': 'Wolfenstein (MAP31) - Backpack 4',
             'episode': 4,
             'map': 1,
             'index': 314,
             'doom_type': 8,
             'region': "Wolfenstein (MAP31) Main"},
    361465: {'name': 'Wolfenstein (MAP31) - BFG9000',
             'episode': 4,
             'map': 1,
             'index': 315,
             'doom_type': 2006,
             'region': "Wolfenstein (MAP31) Main"},
    361466: {'name': 'Wolfenstein (MAP31) - Plasma gun',
             'episode': 4,
             'map': 1,
             'index': 316,
             'doom_type': 2004,
             'region': "Wolfenstein (MAP31) Main"},
    361467: {'name': 'Wolfenstein (MAP31) - Exit',
             'episode': 4,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "Wolfenstein (MAP31) Main"},
    361468: {'name': 'Grosse (MAP32) - Plasma gun',
             'episode': 4,
             'map': 2,
             'index': 33,
             'doom_type': 2004,
             'region': "Grosse (MAP32) Main"},
    361469: {'name': 'Grosse (MAP32) - Rocket launcher',
             'episode': 4,
             'map': 2,
             'index': 57,
             'doom_type': 2003,
             'region': "Grosse (MAP32) Start"},
    361470: {'name': 'Grosse (MAP32) - Invulnerability',
             'episode': 4,
             'map': 2,
             'index': 70,
             'doom_type': 2022,
             'region': "Grosse (MAP32) Main"},
    361471: {'name': 'Grosse (MAP32) - Super Shotgun',
             'episode': 4,
             'map': 2,
             'index': 74,
             'doom_type': 82,
             'region': "Grosse (MAP32) Main"},
    361472: {'name': 'Grosse (MAP32) - BFG9000',
             'episode': 4,
             'map': 2,
             'index': 75,
             'doom_type': 2006,
             'region': "Grosse (MAP32) Main"},
    361473: {'name': 'Grosse (MAP32) - Megasphere',
             'episode': 4,
             'map': 2,
             'index': 78,
             'doom_type': 83,
             'region': "Grosse (MAP32) Main"},
    361474: {'name': 'Grosse (MAP32) - Chaingun',
             'episode': 4,
             'map': 2,
             'index': 79,
             'doom_type': 2002,
             'region': "Grosse (MAP32) Main"},
    361475: {'name': 'Grosse (MAP32) - Chaingun 2',
             'episode': 4,
             'map': 2,
             'index': 80,
             'doom_type': 2002,
             'region': "Grosse (MAP32) Main"},
    361476: {'name': 'Grosse (MAP32) - Chaingun 3',
             'episode': 4,
             'map': 2,
             'index': 81,
             'doom_type': 2002,
             'region': "Grosse (MAP32) Main"},
    361477: {'name': 'Grosse (MAP32) - Berserk',
             'episode': 4,
             'map': 2,
             'index': 82,
             'doom_type': 2023,
             'region': "Grosse (MAP32) Start"},
    361478: {'name': 'Grosse (MAP32) - Exit',
             'episode': 4,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "Grosse (MAP32) Main"},
}


location_name_groups: Dict[str, Set[str]] = {
    "Barrels o' Fun (MAP23)": {
        "Barrels o' Fun (MAP23) - Armor",
        "Barrels o' Fun (MAP23) - BFG9000",
        "Barrels o' Fun (MAP23) - Backpack",
        "Barrels o' Fun (MAP23) - Backpack 2",
        "Barrels o' Fun (MAP23) - Berserk",
        "Barrels o' Fun (MAP23) - Computer area map",
        "Barrels o' Fun (MAP23) - Exit",
        "Barrels o' Fun (MAP23) - Megasphere",
        "Barrels o' Fun (MAP23) - Rocket launcher",
        "Barrels o' Fun (MAP23) - Shotgun",
        "Barrels o' Fun (MAP23) - Supercharge",
        "Barrels o' Fun (MAP23) - Yellow skull key",
    },
    'Bloodfalls (MAP25)': {
        'Bloodfalls (MAP25) - Armor',
        'Bloodfalls (MAP25) - BFG9000',
        'Bloodfalls (MAP25) - BFG9000 2',
        'Bloodfalls (MAP25) - Blue skull key',
        'Bloodfalls (MAP25) - Chaingun',
        'Bloodfalls (MAP25) - Exit',
        'Bloodfalls (MAP25) - Mega Armor',
        'Bloodfalls (MAP25) - Megasphere',
        'Bloodfalls (MAP25) - Partial invisibility',
        'Bloodfalls (MAP25) - Plasma gun',
        'Bloodfalls (MAP25) - Rocket launcher',
        'Bloodfalls (MAP25) - Super Shotgun',
    },
    'Circle of Death (MAP11)': {
        'Circle of Death (MAP11) - Armor',
        'Circle of Death (MAP11) - BFG9000',
        'Circle of Death (MAP11) - Backpack',
        'Circle of Death (MAP11) - Blue keycard',
        'Circle of Death (MAP11) - Chaingun',
        'Circle of Death (MAP11) - Exit',
        'Circle of Death (MAP11) - Invulnerability',
        'Circle of Death (MAP11) - Mega Armor',
        'Circle of Death (MAP11) - Partial invisibility',
        'Circle of Death (MAP11) - Plasma gun',
        'Circle of Death (MAP11) - Red keycard',
        'Circle of Death (MAP11) - Rocket launcher',
        'Circle of Death (MAP11) - Shotgun',
        'Circle of Death (MAP11) - Supercharge',
        'Circle of Death (MAP11) - Supercharge 2',
    },
    'Dead Simple (MAP07)': {
        'Dead Simple (MAP07) - Backpack',
        'Dead Simple (MAP07) - Berserk',
        'Dead Simple (MAP07) - Chaingun',
        'Dead Simple (MAP07) - Exit',
        'Dead Simple (MAP07) - Megasphere',
        'Dead Simple (MAP07) - Partial invisibility',
        'Dead Simple (MAP07) - Partial invisibility 2',
        'Dead Simple (MAP07) - Partial invisibility 3',
        'Dead Simple (MAP07) - Partial invisibility 4',
        'Dead Simple (MAP07) - Plasma gun',
        'Dead Simple (MAP07) - Rocket launcher',
        'Dead Simple (MAP07) - Super Shotgun',
    },
    'Downtown (MAP13)': {
        'Downtown (MAP13) - BFG9000',
        'Downtown (MAP13) - Backpack',
        'Downtown (MAP13) - Berserk',
        'Downtown (MAP13) - Berserk 2',
        'Downtown (MAP13) - Berserk 3',
        'Downtown (MAP13) - Blue keycard',
        'Downtown (MAP13) - Chaingun',
        'Downtown (MAP13) - Chainsaw',
        'Downtown (MAP13) - Computer area map',
        'Downtown (MAP13) - Exit',
        'Downtown (MAP13) - Invulnerability',
        'Downtown (MAP13) - Invulnerability 2',
        'Downtown (MAP13) - Mega Armor',
        'Downtown (MAP13) - Partial invisibility',
        'Downtown (MAP13) - Partial invisibility 2',
        'Downtown (MAP13) - Partial invisibility 3',
        'Downtown (MAP13) - Plasma gun',
        'Downtown (MAP13) - Red keycard',
        'Downtown (MAP13) - Rocket launcher',
        'Downtown (MAP13) - Shotgun',
        'Downtown (MAP13) - Supercharge',
        'Downtown (MAP13) - Yellow keycard',
    },
    'Entryway (MAP01)': {
        'Entryway (MAP01) - Armor',
        'Entryway (MAP01) - Chainsaw',
        'Entryway (MAP01) - Exit',
        'Entryway (MAP01) - Rocket launcher',
        'Entryway (MAP01) - Shotgun',
    },
    'Gotcha! (MAP20)': {
        'Gotcha! (MAP20) - Armor',
        'Gotcha! (MAP20) - Armor 2',
        'Gotcha! (MAP20) - BFG9000',
        'Gotcha! (MAP20) - Berserk',
        'Gotcha! (MAP20) - Exit',
        'Gotcha! (MAP20) - Mega Armor',
        'Gotcha! (MAP20) - Mega Armor 2',
        'Gotcha! (MAP20) - Megasphere',
        'Gotcha! (MAP20) - Plasma gun',
        'Gotcha! (MAP20) - Rocket launcher',
        'Gotcha! (MAP20) - Super Shotgun',
        'Gotcha! (MAP20) - Supercharge',
        'Gotcha! (MAP20) - Supercharge 2',
        'Gotcha! (MAP20) - Supercharge 3',
        'Gotcha! (MAP20) - Supercharge 4',
    },
    'Grosse (MAP32)': {
        'Grosse (MAP32) - BFG9000',
        'Grosse (MAP32) - Berserk',
        'Grosse (MAP32) - Chaingun',
        'Grosse (MAP32) - Chaingun 2',
        'Grosse (MAP32) - Chaingun 3',
        'Grosse (MAP32) - Exit',
        'Grosse (MAP32) - Invulnerability',
        'Grosse (MAP32) - Megasphere',
        'Grosse (MAP32) - Plasma gun',
        'Grosse (MAP32) - Rocket launcher',
        'Grosse (MAP32) - Super Shotgun',
    },
    'Icon of Sin (MAP30)': {
        'Icon of Sin (MAP30) - BFG9000',
        'Icon of Sin (MAP30) - Backpack',
        'Icon of Sin (MAP30) - Berserk',
        'Icon of Sin (MAP30) - Chaingun',
        'Icon of Sin (MAP30) - Chainsaw',
        'Icon of Sin (MAP30) - Exit',
        'Icon of Sin (MAP30) - Invulnerability',
        'Icon of Sin (MAP30) - Invulnerability 2',
        'Icon of Sin (MAP30) - Invulnerability 3',
        'Icon of Sin (MAP30) - Invulnerability 4',
        'Icon of Sin (MAP30) - Megasphere',
        'Icon of Sin (MAP30) - Megasphere 2',
        'Icon of Sin (MAP30) - Plasma gun',
        'Icon of Sin (MAP30) - Rocket launcher',
        'Icon of Sin (MAP30) - Shotgun',
        'Icon of Sin (MAP30) - Super Shotgun',
        'Icon of Sin (MAP30) - Supercharge',
        'Icon of Sin (MAP30) - Supercharge 2',
        'Icon of Sin (MAP30) - Supercharge 3',
    },
    'Industrial Zone (MAP15)': {
        'Industrial Zone (MAP15) - Armor',
        'Industrial Zone (MAP15) - BFG9000',
        'Industrial Zone (MAP15) - Backpack',
        'Industrial Zone (MAP15) - Backpack 2',
        'Industrial Zone (MAP15) - Berserk',
        'Industrial Zone (MAP15) - Berserk 2',
        'Industrial Zone (MAP15) - Blue keycard',
        'Industrial Zone (MAP15) - Chaingun',
        'Industrial Zone (MAP15) - Chainsaw',
        'Industrial Zone (MAP15) - Computer area map',
        'Industrial Zone (MAP15) - Exit',
        'Industrial Zone (MAP15) - Invulnerability',
        'Industrial Zone (MAP15) - Mega Armor',
        'Industrial Zone (MAP15) - Mega Armor 2',
        'Industrial Zone (MAP15) - Megasphere',
        'Industrial Zone (MAP15) - Partial invisibility',
        'Industrial Zone (MAP15) - Partial invisibility 2',
        'Industrial Zone (MAP15) - Plasma gun',
        'Industrial Zone (MAP15) - Red keycard',
        'Industrial Zone (MAP15) - Rocket launcher',
        'Industrial Zone (MAP15) - Shotgun',
        'Industrial Zone (MAP15) - Supercharge',
        'Industrial Zone (MAP15) - Yellow keycard',
    },
    'Monster Condo (MAP27)': {
        'Monster Condo (MAP27) - Armor',
        'Monster Condo (MAP27) - Armor 2',
        'Monster Condo (MAP27) - BFG9000',
        'Monster Condo (MAP27) - Backpack',
        'Monster Condo (MAP27) - Backpack 2',
        'Monster Condo (MAP27) - Backpack 3',
        'Monster Condo (MAP27) - Backpack 4',
        'Monster Condo (MAP27) - Berserk',
        'Monster Condo (MAP27) - Berserk 2',
        'Monster Condo (MAP27) - Blue skull key',
        'Monster Condo (MAP27) - Chaingun',
        'Monster Condo (MAP27) - Chainsaw',
        'Monster Condo (MAP27) - Computer area map',
        'Monster Condo (MAP27) - Computer area map 2',
        'Monster Condo (MAP27) - Exit',
        'Monster Condo (MAP27) - Invulnerability',
        'Monster Condo (MAP27) - Invulnerability 2',
        'Monster Condo (MAP27) - Invulnerability 3',
        'Monster Condo (MAP27) - Partial invisibility',
        'Monster Condo (MAP27) - Partial invisibility 2',
        'Monster Condo (MAP27) - Partial invisibility 3',
        'Monster Condo (MAP27) - Plasma gun',
        'Monster Condo (MAP27) - Red skull key',
        'Monster Condo (MAP27) - Rocket launcher',
        'Monster Condo (MAP27) - Super Shotgun',
        'Monster Condo (MAP27) - Supercharge',
        'Monster Condo (MAP27) - Supercharge 2',
        'Monster Condo (MAP27) - Supercharge 3',
        'Monster Condo (MAP27) - Supercharge 4',
        'Monster Condo (MAP27) - Supercharge 5',
        'Monster Condo (MAP27) - Yellow skull key',
    },
    'Nirvana (MAP21)': {
        'Nirvana (MAP21) - Backpack',
        'Nirvana (MAP21) - Blue skull key',
        'Nirvana (MAP21) - Exit',
        'Nirvana (MAP21) - Invulnerability',
        'Nirvana (MAP21) - Megasphere',
        'Nirvana (MAP21) - Red skull key',
        'Nirvana (MAP21) - Rocket launcher',
        'Nirvana (MAP21) - Super Shotgun',
        'Nirvana (MAP21) - Yellow skull key',
    },
    'Refueling Base (MAP10)': {
        'Refueling Base (MAP10) - Armor',
        'Refueling Base (MAP10) - Armor 2',
        'Refueling Base (MAP10) - BFG9000',
        'Refueling Base (MAP10) - Backpack',
        'Refueling Base (MAP10) - Berserk',
        'Refueling Base (MAP10) - Berserk 2',
        'Refueling Base (MAP10) - Blue keycard',
        'Refueling Base (MAP10) - Chaingun',
        'Refueling Base (MAP10) - Chainsaw',
        'Refueling Base (MAP10) - Exit',
        'Refueling Base (MAP10) - Invulnerability',
        'Refueling Base (MAP10) - Invulnerability 2',
        'Refueling Base (MAP10) - Mega Armor',
        'Refueling Base (MAP10) - Megasphere',
        'Refueling Base (MAP10) - Partial invisibility',
        'Refueling Base (MAP10) - Plasma gun',
        'Refueling Base (MAP10) - Rocket launcher',
        'Refueling Base (MAP10) - Shotgun',
        'Refueling Base (MAP10) - Supercharge',
        'Refueling Base (MAP10) - Supercharge 2',
        'Refueling Base (MAP10) - Yellow keycard',
    },
    'Suburbs (MAP16)': {
        'Suburbs (MAP16) - BFG9000',
        'Suburbs (MAP16) - Backpack',
        'Suburbs (MAP16) - Berserk',
        'Suburbs (MAP16) - Blue skull key',
        'Suburbs (MAP16) - Chaingun',
        'Suburbs (MAP16) - Exit',
        'Suburbs (MAP16) - Invulnerability',
        'Suburbs (MAP16) - Megasphere',
        'Suburbs (MAP16) - Partial invisibility',
        'Suburbs (MAP16) - Plasma gun',
        'Suburbs (MAP16) - Plasma gun 2',
        'Suburbs (MAP16) - Plasma gun 3',
        'Suburbs (MAP16) - Plasma gun 4',
        'Suburbs (MAP16) - Red skull key',
        'Suburbs (MAP16) - Rocket launcher',
        'Suburbs (MAP16) - Shotgun',
        'Suburbs (MAP16) - Super Shotgun',
        'Suburbs (MAP16) - Supercharge',
    },
    'Tenements (MAP17)': {
        'Tenements (MAP17) - Armor',
        'Tenements (MAP17) - Armor 2',
        'Tenements (MAP17) - BFG9000',
        'Tenements (MAP17) - Backpack',
        'Tenements (MAP17) - Berserk',
        'Tenements (MAP17) - Blue keycard',
        'Tenements (MAP17) - Chaingun',
        'Tenements (MAP17) - Exit',
        'Tenements (MAP17) - Mega Armor',
        'Tenements (MAP17) - Megasphere',
        'Tenements (MAP17) - Partial invisibility',
        'Tenements (MAP17) - Plasma gun',
        'Tenements (MAP17) - Red keycard',
        'Tenements (MAP17) - Rocket launcher',
        'Tenements (MAP17) - Shotgun',
        'Tenements (MAP17) - Supercharge',
        'Tenements (MAP17) - Supercharge 2',
        'Tenements (MAP17) - Yellow skull key',
    },
    'The Abandoned Mines (MAP26)': {
        'The Abandoned Mines (MAP26) - Armor',
        'The Abandoned Mines (MAP26) - Backpack',
        'The Abandoned Mines (MAP26) - Blue keycard',
        'The Abandoned Mines (MAP26) - Chaingun',
        'The Abandoned Mines (MAP26) - Exit',
        'The Abandoned Mines (MAP26) - Mega Armor',
        'The Abandoned Mines (MAP26) - Partial invisibility',
        'The Abandoned Mines (MAP26) - Plasma gun',
        'The Abandoned Mines (MAP26) - Red keycard',
        'The Abandoned Mines (MAP26) - Rocket launcher',
        'The Abandoned Mines (MAP26) - Super Shotgun',
        'The Abandoned Mines (MAP26) - Supercharge',
        'The Abandoned Mines (MAP26) - Yellow keycard',
    },
    'The Catacombs (MAP22)': {
        'The Catacombs (MAP22) - Armor',
        'The Catacombs (MAP22) - Berserk',
        'The Catacombs (MAP22) - Blue skull key',
        'The Catacombs (MAP22) - Exit',
        'The Catacombs (MAP22) - Plasma gun',
        'The Catacombs (MAP22) - Red skull key',
        'The Catacombs (MAP22) - Rocket launcher',
        'The Catacombs (MAP22) - Shotgun',
        'The Catacombs (MAP22) - Supercharge',
    },
    'The Chasm (MAP24)': {
        'The Chasm (MAP24) - Armor',
        'The Chasm (MAP24) - BFG9000',
        'The Chasm (MAP24) - Backpack',
        'The Chasm (MAP24) - Berserk',
        'The Chasm (MAP24) - Berserk 2',
        'The Chasm (MAP24) - Blue keycard',
        'The Chasm (MAP24) - Exit',
        'The Chasm (MAP24) - Invulnerability',
        'The Chasm (MAP24) - Megasphere',
        'The Chasm (MAP24) - Megasphere 2',
        'The Chasm (MAP24) - Plasma gun',
        'The Chasm (MAP24) - Red keycard',
        'The Chasm (MAP24) - Rocket launcher',
        'The Chasm (MAP24) - Shotgun',
        'The Chasm (MAP24) - Super Shotgun',
    },
    'The Citadel (MAP19)': {
        'The Citadel (MAP19) - Armor',
        'The Citadel (MAP19) - Armor 2',
        'The Citadel (MAP19) - Backpack',
        'The Citadel (MAP19) - Berserk',
        'The Citadel (MAP19) - Blue skull key',
        'The Citadel (MAP19) - Chaingun',
        'The Citadel (MAP19) - Computer area map',
        'The Citadel (MAP19) - Exit',
        'The Citadel (MAP19) - Invulnerability',
        'The Citadel (MAP19) - Mega Armor',
        'The Citadel (MAP19) - Partial invisibility',
        'The Citadel (MAP19) - Red skull key',
        'The Citadel (MAP19) - Rocket launcher',
        'The Citadel (MAP19) - Super Shotgun',
        'The Citadel (MAP19) - Supercharge',
        'The Citadel (MAP19) - Yellow skull key',
    },
    'The Courtyard (MAP18)': {
        'The Courtyard (MAP18) - Armor',
        'The Courtyard (MAP18) - BFG9000',
        'The Courtyard (MAP18) - Backpack',
        'The Courtyard (MAP18) - Berserk',
        'The Courtyard (MAP18) - Blue skull key',
        'The Courtyard (MAP18) - Chaingun',
        'The Courtyard (MAP18) - Computer area map',
        'The Courtyard (MAP18) - Exit',
        'The Courtyard (MAP18) - Invulnerability',
        'The Courtyard (MAP18) - Invulnerability 2',
        'The Courtyard (MAP18) - Partial invisibility',
        'The Courtyard (MAP18) - Partial invisibility 2',
        'The Courtyard (MAP18) - Plasma gun',
        'The Courtyard (MAP18) - Rocket launcher',
        'The Courtyard (MAP18) - Shotgun',
        'The Courtyard (MAP18) - Super Shotgun',
        'The Courtyard (MAP18) - Supercharge',
        'The Courtyard (MAP18) - Yellow skull key',
    },
    'The Crusher (MAP06)': {
        'The Crusher (MAP06) - Armor',
        'The Crusher (MAP06) - Backpack',
        'The Crusher (MAP06) - Blue keycard',
        'The Crusher (MAP06) - Blue keycard 2',
        'The Crusher (MAP06) - Blue keycard 3',
        'The Crusher (MAP06) - Exit',
        'The Crusher (MAP06) - Mega Armor',
        'The Crusher (MAP06) - Megasphere',
        'The Crusher (MAP06) - Megasphere 2',
        'The Crusher (MAP06) - Plasma gun',
        'The Crusher (MAP06) - Red keycard',
        'The Crusher (MAP06) - Rocket launcher',
        'The Crusher (MAP06) - Super Shotgun',
        'The Crusher (MAP06) - Supercharge',
        'The Crusher (MAP06) - Yellow keycard',
    },
    'The Factory (MAP12)': {
        'The Factory (MAP12) - Armor',
        'The Factory (MAP12) - Armor 2',
        'The Factory (MAP12) - BFG9000',
        'The Factory (MAP12) - Backpack',
        'The Factory (MAP12) - Berserk',
        'The Factory (MAP12) - Berserk 2',
        'The Factory (MAP12) - Berserk 3',
        'The Factory (MAP12) - Blue keycard',
        'The Factory (MAP12) - Chaingun',
        'The Factory (MAP12) - Exit',
        'The Factory (MAP12) - Partial invisibility',
        'The Factory (MAP12) - Shotgun',
        'The Factory (MAP12) - Super Shotgun',
        'The Factory (MAP12) - Supercharge',
        'The Factory (MAP12) - Supercharge 2',
        'The Factory (MAP12) - Yellow keycard',
    },
    'The Focus (MAP04)': {
        'The Focus (MAP04) - Blue keycard',
        'The Focus (MAP04) - Exit',
        'The Focus (MAP04) - Red keycard',
        'The Focus (MAP04) - Super Shotgun',
        'The Focus (MAP04) - Yellow keycard',
    },
    'The Gantlet (MAP03)': {
        'The Gantlet (MAP03) - Backpack',
        'The Gantlet (MAP03) - Blue keycard',
        'The Gantlet (MAP03) - Chaingun',
        'The Gantlet (MAP03) - Exit',
        'The Gantlet (MAP03) - Mega Armor',
        'The Gantlet (MAP03) - Mega Armor 2',
        'The Gantlet (MAP03) - Partial invisibility',
        'The Gantlet (MAP03) - Red keycard',
        'The Gantlet (MAP03) - Rocket launcher',
        'The Gantlet (MAP03) - Shotgun',
        'The Gantlet (MAP03) - Supercharge',
    },
    'The Inmost Dens (MAP14)': {
        'The Inmost Dens (MAP14) - Berserk',
        'The Inmost Dens (MAP14) - Blue skull key',
        'The Inmost Dens (MAP14) - Chaingun',
        'The Inmost Dens (MAP14) - Exit',
        'The Inmost Dens (MAP14) - Mega Armor',
        'The Inmost Dens (MAP14) - Partial invisibility',
        'The Inmost Dens (MAP14) - Plasma gun',
        'The Inmost Dens (MAP14) - Red skull key',
        'The Inmost Dens (MAP14) - Rocket launcher',
        'The Inmost Dens (MAP14) - Shotgun',
        'The Inmost Dens (MAP14) - Supercharge',
    },
    'The Living End (MAP29)': {
        'The Living End (MAP29) - Armor',
        'The Living End (MAP29) - Backpack',
        'The Living End (MAP29) - Backpack 2',
        'The Living End (MAP29) - Berserk',
        'The Living End (MAP29) - Berserk 2',
        'The Living End (MAP29) - Chaingun',
        'The Living End (MAP29) - Exit',
        'The Living End (MAP29) - Mega Armor',
        'The Living End (MAP29) - Plasma gun',
        'The Living End (MAP29) - Super Shotgun',
        'The Living End (MAP29) - Supercharge',
    },
    'The Pit (MAP09)': {
        'The Pit (MAP09) - Armor',
        'The Pit (MAP09) - BFG9000',
        'The Pit (MAP09) - Backpack',
        'The Pit (MAP09) - Berserk',
        'The Pit (MAP09) - Berserk 2',
        'The Pit (MAP09) - Berserk 3',
        'The Pit (MAP09) - Blue keycard',
        'The Pit (MAP09) - Computer area map',
        'The Pit (MAP09) - Exit',
        'The Pit (MAP09) - Mega Armor',
        'The Pit (MAP09) - Mega Armor 2',
        'The Pit (MAP09) - Rocket launcher',
        'The Pit (MAP09) - Shotgun',
        'The Pit (MAP09) - Supercharge',
        'The Pit (MAP09) - Supercharge 2',
        'The Pit (MAP09) - Yellow keycard',
    },
    'The Spirit World (MAP28)': {
        'The Spirit World (MAP28) - Armor',
        'The Spirit World (MAP28) - BFG9000',
        'The Spirit World (MAP28) - Backpack',
        'The Spirit World (MAP28) - Backpack 2',
        'The Spirit World (MAP28) - Backpack 3',
        'The Spirit World (MAP28) - Backpack 4',
        'The Spirit World (MAP28) - Berserk',
        'The Spirit World (MAP28) - Chaingun',
        'The Spirit World (MAP28) - Chainsaw',
        'The Spirit World (MAP28) - Exit',
        'The Spirit World (MAP28) - Invulnerability',
        'The Spirit World (MAP28) - Invulnerability 2',
        'The Spirit World (MAP28) - Invulnerability 3',
        'The Spirit World (MAP28) - Invulnerability 4',
        'The Spirit World (MAP28) - Invulnerability 5',
        'The Spirit World (MAP28) - Megasphere',
        'The Spirit World (MAP28) - Megasphere 2',
        'The Spirit World (MAP28) - Plasma gun',
        'The Spirit World (MAP28) - Red skull key',
        'The Spirit World (MAP28) - Rocket launcher',
        'The Spirit World (MAP28) - Super Shotgun',
        'The Spirit World (MAP28) - Supercharge',
        'The Spirit World (MAP28) - Yellow skull key',
    },
    'The Waste Tunnels (MAP05)': {
        'The Waste Tunnels (MAP05) - Armor',
        'The Waste Tunnels (MAP05) - Berserk',
        'The Waste Tunnels (MAP05) - Blue keycard',
        'The Waste Tunnels (MAP05) - Exit',
        'The Waste Tunnels (MAP05) - Mega Armor',
        'The Waste Tunnels (MAP05) - Plasma gun',
        'The Waste Tunnels (MAP05) - Red keycard',
        'The Waste Tunnels (MAP05) - Rocket launcher',
        'The Waste Tunnels (MAP05) - Shotgun',
        'The Waste Tunnels (MAP05) - Super Shotgun',
        'The Waste Tunnels (MAP05) - Supercharge',
        'The Waste Tunnels (MAP05) - Supercharge 2',
        'The Waste Tunnels (MAP05) - Yellow keycard',
    },
    'Tricks and Traps (MAP08)': {
        'Tricks and Traps (MAP08) - Armor',
        'Tricks and Traps (MAP08) - Armor 2',
        'Tricks and Traps (MAP08) - BFG9000',
        'Tricks and Traps (MAP08) - Backpack',
        'Tricks and Traps (MAP08) - Backpack 2',
        'Tricks and Traps (MAP08) - Backpack 3',
        'Tricks and Traps (MAP08) - Backpack 4',
        'Tricks and Traps (MAP08) - Backpack 5',
        'Tricks and Traps (MAP08) - Chaingun',
        'Tricks and Traps (MAP08) - Chainsaw',
        'Tricks and Traps (MAP08) - Exit',
        'Tricks and Traps (MAP08) - Invulnerability',
        'Tricks and Traps (MAP08) - Invulnerability 2',
        'Tricks and Traps (MAP08) - Invulnerability 3',
        'Tricks and Traps (MAP08) - Invulnerability 4',
        'Tricks and Traps (MAP08) - Invulnerability 5',
        'Tricks and Traps (MAP08) - Partial invisibility',
        'Tricks and Traps (MAP08) - Plasma gun',
        'Tricks and Traps (MAP08) - Red skull key',
        'Tricks and Traps (MAP08) - Rocket launcher',
        'Tricks and Traps (MAP08) - Shotgun',
        'Tricks and Traps (MAP08) - Supercharge',
        'Tricks and Traps (MAP08) - Supercharge 2',
        'Tricks and Traps (MAP08) - Yellow skull key',
    },
    'Underhalls (MAP02)': {
        'Underhalls (MAP02) - Blue keycard',
        'Underhalls (MAP02) - Exit',
        'Underhalls (MAP02) - Mega Armor',
        'Underhalls (MAP02) - Red keycard',
        'Underhalls (MAP02) - Super Shotgun',
    },
    'Wolfenstein (MAP31)': {
        'Wolfenstein (MAP31) - BFG9000',
        'Wolfenstein (MAP31) - Backpack',
        'Wolfenstein (MAP31) - Backpack 2',
        'Wolfenstein (MAP31) - Backpack 3',
        'Wolfenstein (MAP31) - Backpack 4',
        'Wolfenstein (MAP31) - Berserk',
        'Wolfenstein (MAP31) - Chaingun',
        'Wolfenstein (MAP31) - Exit',
        'Wolfenstein (MAP31) - Megasphere',
        'Wolfenstein (MAP31) - Partial invisibility',
        'Wolfenstein (MAP31) - Plasma gun',
        'Wolfenstein (MAP31) - Rocket launcher',
        'Wolfenstein (MAP31) - Shotgun',
        'Wolfenstein (MAP31) - Super Shotgun',
        'Wolfenstein (MAP31) - Supercharge',
    },
}


death_logic_locations = [
    "Entryway (MAP01) - Armor",
]
