# This file is auto generated. More info: https://github.com/Daivuk/apdoom

from BaseClasses import ItemClassification
from typing import TypedDict, Dict, Set 


class ItemDict(TypedDict, total=False): 
    classification: ItemClassification 
    count: int 
    name: str 
    doom_type: int # Unique numerical id used to spawn the item. -1 is level item, -2 is level complete item. 
    episode: int # Relevant if that item targets a specific level, like keycard or map reveal pickup. 
    map: int 


item_table: Dict[int, ItemDict] = {
    360000: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Shotgun',
             'doom_type': 2001,
             'episode': -1,
             'map': -1},
    360001: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Rocket launcher',
             'doom_type': 2003,
             'episode': -1,
             'map': -1},
    360002: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Plasma gun',
             'doom_type': 2004,
             'episode': -1,
             'map': -1},
    360003: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Chainsaw',
             'doom_type': 2005,
             'episode': -1,
             'map': -1},
    360004: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Chaingun',
             'doom_type': 2002,
             'episode': -1,
             'map': -1},
    360005: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'BFG9000',
             'doom_type': 2006,
             'episode': -1,
             'map': -1},
    360006: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Super Shotgun',
             'doom_type': 82,
             'episode': -1,
             'map': -1},
    360007: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Backpack',
             'doom_type': 8,
             'episode': -1,
             'map': -1},
    360008: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Armor',
             'doom_type': 2018,
             'episode': -1,
             'map': -1},
    360009: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Mega Armor',
             'doom_type': 2019,
             'episode': -1,
             'map': -1},
    360010: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Berserk',
             'doom_type': 2023,
             'episode': -1,
             'map': -1},
    360011: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Invulnerability',
             'doom_type': 2022,
             'episode': -1,
             'map': -1},
    360012: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Partial invisibility',
             'doom_type': 2024,
             'episode': -1,
             'map': -1},
    360013: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Supercharge',
             'doom_type': 2013,
             'episode': -1,
             'map': -1},
    360014: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Megasphere',
             'doom_type': 83,
             'episode': -1,
             'map': -1},
    360015: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Medikit',
             'doom_type': 2012,
             'episode': -1,
             'map': -1},
    360016: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Box of bullets',
             'doom_type': 2048,
             'episode': -1,
             'map': -1},
    360017: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Box of rockets',
             'doom_type': 2046,
             'episode': -1,
             'map': -1},
    360018: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Box of shotgun shells',
             'doom_type': 2049,
             'episode': -1,
             'map': -1},
    360019: {'classification': ItemClassification.filler,
             'count': 0,
             'name': 'Energy cell pack',
             'doom_type': 17,
             'episode': -1,
             'map': -1},
    360200: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Underhalls (MAP02) - Red keycard',
             'doom_type': 13,
             'episode': 1,
             'map': 2},
    360201: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Underhalls (MAP02) - Blue keycard',
             'doom_type': 5,
             'episode': 1,
             'map': 2},
    360202: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Gantlet (MAP03) - Blue keycard',
             'doom_type': 5,
             'episode': 1,
             'map': 3},
    360203: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Gantlet (MAP03) - Red keycard',
             'doom_type': 13,
             'episode': 1,
             'map': 3},
    360204: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Focus (MAP04) - Blue keycard',
             'doom_type': 5,
             'episode': 1,
             'map': 4},
    360205: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Focus (MAP04) - Red keycard',
             'doom_type': 13,
             'episode': 1,
             'map': 4},
    360206: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Focus (MAP04) - Yellow keycard',
             'doom_type': 6,
             'episode': 1,
             'map': 4},
    360207: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Waste Tunnels (MAP05) - Blue keycard',
             'doom_type': 5,
             'episode': 1,
             'map': 5},
    360208: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Waste Tunnels (MAP05) - Red keycard',
             'doom_type': 13,
             'episode': 1,
             'map': 5},
    360209: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Waste Tunnels (MAP05) - Yellow keycard',
             'doom_type': 6,
             'episode': 1,
             'map': 5},
    360210: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crusher (MAP06) - Red keycard',
             'doom_type': 13,
             'episode': 1,
             'map': 6},
    360211: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crusher (MAP06) - Yellow keycard',
             'doom_type': 6,
             'episode': 1,
             'map': 6},
    360212: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crusher (MAP06) - Blue keycard',
             'doom_type': 5,
             'episode': 1,
             'map': 6},
    360213: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Tricks and Traps (MAP08) - Yellow skull key',
             'doom_type': 39,
             'episode': 1,
             'map': 8},
    360214: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Tricks and Traps (MAP08) - Red skull key',
             'doom_type': 38,
             'episode': 1,
             'map': 8},
    360215: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Pit (MAP09) - Blue keycard',
             'doom_type': 5,
             'episode': 1,
             'map': 9},
    360216: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Pit (MAP09) - Yellow keycard',
             'doom_type': 6,
             'episode': 1,
             'map': 9},
    360217: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Refueling Base (MAP10) - Blue keycard',
             'doom_type': 5,
             'episode': 1,
             'map': 10},
    360218: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Refueling Base (MAP10) - Yellow keycard',
             'doom_type': 6,
             'episode': 1,
             'map': 10},
    360219: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Circle of Death (MAP11) - Red keycard',
             'doom_type': 13,
             'episode': 1,
             'map': 11},
    360220: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Circle of Death (MAP11) - Blue keycard',
             'doom_type': 5,
             'episode': 1,
             'map': 11},
    360221: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Factory (MAP12) - Blue keycard',
             'doom_type': 5,
             'episode': 2,
             'map': 1},
    360222: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Factory (MAP12) - Yellow keycard',
             'doom_type': 6,
             'episode': 2,
             'map': 1},
    360223: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Downtown (MAP13) - Blue keycard',
             'doom_type': 5,
             'episode': 2,
             'map': 2},
    360224: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Downtown (MAP13) - Yellow keycard',
             'doom_type': 6,
             'episode': 2,
             'map': 2},
    360225: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Downtown (MAP13) - Red keycard',
             'doom_type': 13,
             'episode': 2,
             'map': 2},
    360226: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Inmost Dens (MAP14) - Red skull key',
             'doom_type': 38,
             'episode': 2,
             'map': 3},
    360227: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Inmost Dens (MAP14) - Blue skull key',
             'doom_type': 40,
             'episode': 2,
             'map': 3},
    360228: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Industrial Zone (MAP15) - Yellow keycard',
             'doom_type': 6,
             'episode': 2,
             'map': 4},
    360229: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Industrial Zone (MAP15) - Red keycard',
             'doom_type': 13,
             'episode': 2,
             'map': 4},
    360230: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Industrial Zone (MAP15) - Blue keycard',
             'doom_type': 5,
             'episode': 2,
             'map': 4},
    360231: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Suburbs (MAP16) - Blue skull key',
             'doom_type': 40,
             'episode': 2,
             'map': 5},
    360232: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Suburbs (MAP16) - Red skull key',
             'doom_type': 38,
             'episode': 2,
             'map': 5},
    360233: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Tenements (MAP17) - Red keycard',
             'doom_type': 13,
             'episode': 2,
             'map': 6},
    360234: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Tenements (MAP17) - Blue keycard',
             'doom_type': 5,
             'episode': 2,
             'map': 6},
    360235: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Tenements (MAP17) - Yellow skull key',
             'doom_type': 39,
             'episode': 2,
             'map': 6},
    360236: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Courtyard (MAP18) - Yellow skull key',
             'doom_type': 39,
             'episode': 2,
             'map': 7},
    360237: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Courtyard (MAP18) - Blue skull key',
             'doom_type': 40,
             'episode': 2,
             'map': 7},
    360238: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (MAP19) - Blue skull key',
             'doom_type': 40,
             'episode': 2,
             'map': 8},
    360239: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (MAP19) - Red skull key',
             'doom_type': 38,
             'episode': 2,
             'map': 8},
    360240: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (MAP19) - Yellow skull key',
             'doom_type': 39,
             'episode': 2,
             'map': 8},
    360241: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Nirvana (MAP21) - Yellow skull key',
             'doom_type': 39,
             'episode': 3,
             'map': 1},
    360242: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Nirvana (MAP21) - Blue skull key',
             'doom_type': 40,
             'episode': 3,
             'map': 1},
    360243: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Nirvana (MAP21) - Red skull key',
             'doom_type': 38,
             'episode': 3,
             'map': 1},
    360244: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Catacombs (MAP22) - Blue skull key',
             'doom_type': 40,
             'episode': 3,
             'map': 2},
    360245: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Catacombs (MAP22) - Red skull key',
             'doom_type': 38,
             'episode': 3,
             'map': 2},
    360246: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Barrels o' Fun (MAP23) - Yellow skull key",
             'doom_type': 39,
             'episode': 3,
             'map': 3},
    360247: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Chasm (MAP24) - Blue keycard',
             'doom_type': 5,
             'episode': 3,
             'map': 4},
    360248: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Chasm (MAP24) - Red keycard',
             'doom_type': 13,
             'episode': 3,
             'map': 4},
    360249: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Bloodfalls (MAP25) - Blue skull key',
             'doom_type': 40,
             'episode': 3,
             'map': 5},
    360250: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Abandoned Mines (MAP26) - Blue keycard',
             'doom_type': 5,
             'episode': 3,
             'map': 6},
    360251: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Abandoned Mines (MAP26) - Red keycard',
             'doom_type': 13,
             'episode': 3,
             'map': 6},
    360252: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Abandoned Mines (MAP26) - Yellow keycard',
             'doom_type': 6,
             'episode': 3,
             'map': 6},
    360253: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Monster Condo (MAP27) - Yellow skull key',
             'doom_type': 39,
             'episode': 3,
             'map': 7},
    360254: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Monster Condo (MAP27) - Red skull key',
             'doom_type': 38,
             'episode': 3,
             'map': 7},
    360255: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Monster Condo (MAP27) - Blue skull key',
             'doom_type': 40,
             'episode': 3,
             'map': 7},
    360256: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Spirit World (MAP28) - Yellow skull key',
             'doom_type': 39,
             'episode': 3,
             'map': 8},
    360257: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Spirit World (MAP28) - Red skull key',
             'doom_type': 38,
             'episode': 3,
             'map': 8},
    360400: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Entryway (MAP01)',
             'doom_type': -1,
             'episode': 1,
             'map': 1},
    360401: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Entryway (MAP01) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 1},
    360402: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Entryway (MAP01) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 1},
    360403: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Underhalls (MAP02)',
             'doom_type': -1,
             'episode': 1,
             'map': 2},
    360404: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Underhalls (MAP02) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 2},
    360405: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Underhalls (MAP02) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 2},
    360406: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Gantlet (MAP03)',
             'doom_type': -1,
             'episode': 1,
             'map': 3},
    360407: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Gantlet (MAP03) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 3},
    360408: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Gantlet (MAP03) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 3},
    360409: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Focus (MAP04)',
             'doom_type': -1,
             'episode': 1,
             'map': 4},
    360410: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Focus (MAP04) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 4},
    360411: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Focus (MAP04) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 4},
    360412: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Waste Tunnels (MAP05)',
             'doom_type': -1,
             'episode': 1,
             'map': 5},
    360413: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Waste Tunnels (MAP05) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 5},
    360414: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Waste Tunnels (MAP05) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 5},
    360415: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crusher (MAP06)',
             'doom_type': -1,
             'episode': 1,
             'map': 6},
    360416: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Crusher (MAP06) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 6},
    360417: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Crusher (MAP06) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 6},
    360418: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Dead Simple (MAP07)',
             'doom_type': -1,
             'episode': 1,
             'map': 7},
    360419: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Dead Simple (MAP07) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 7},
    360420: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Dead Simple (MAP07) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 7},
    360421: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Tricks and Traps (MAP08)',
             'doom_type': -1,
             'episode': 1,
             'map': 8},
    360422: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Tricks and Traps (MAP08) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 8},
    360423: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Tricks and Traps (MAP08) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 8},
    360424: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Pit (MAP09)',
             'doom_type': -1,
             'episode': 1,
             'map': 9},
    360425: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Pit (MAP09) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 9},
    360426: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Pit (MAP09) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 9},
    360427: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Refueling Base (MAP10)',
             'doom_type': -1,
             'episode': 1,
             'map': 10},
    360428: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Refueling Base (MAP10) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 10},
    360429: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Refueling Base (MAP10) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 10},
    360430: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Circle of Death (MAP11)',
             'doom_type': -1,
             'episode': 1,
             'map': 11},
    360431: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Circle of Death (MAP11) - Complete',
             'doom_type': -2,
             'episode': 1,
             'map': 11},
    360432: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Circle of Death (MAP11) - Computer area map',
             'doom_type': 2026,
             'episode': 1,
             'map': 11},
    360433: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Factory (MAP12)',
             'doom_type': -1,
             'episode': 2,
             'map': 1},
    360434: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Factory (MAP12) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 1},
    360435: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Factory (MAP12) - Computer area map',
             'doom_type': 2026,
             'episode': 2,
             'map': 1},
    360436: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Downtown (MAP13)',
             'doom_type': -1,
             'episode': 2,
             'map': 2},
    360437: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Downtown (MAP13) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 2},
    360438: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Downtown (MAP13) - Computer area map',
             'doom_type': 2026,
             'episode': 2,
             'map': 2},
    360439: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Inmost Dens (MAP14)',
             'doom_type': -1,
             'episode': 2,
             'map': 3},
    360440: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Inmost Dens (MAP14) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 3},
    360441: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Inmost Dens (MAP14) - Computer area map',
             'doom_type': 2026,
             'episode': 2,
             'map': 3},
    360442: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Industrial Zone (MAP15)',
             'doom_type': -1,
             'episode': 2,
             'map': 4},
    360443: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Industrial Zone (MAP15) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 4},
    360444: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Industrial Zone (MAP15) - Computer area map',
             'doom_type': 2026,
             'episode': 2,
             'map': 4},
    360445: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Suburbs (MAP16)',
             'doom_type': -1,
             'episode': 2,
             'map': 5},
    360446: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Suburbs (MAP16) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 5},
    360447: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Suburbs (MAP16) - Computer area map',
             'doom_type': 2026,
             'episode': 2,
             'map': 5},
    360448: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Tenements (MAP17)',
             'doom_type': -1,
             'episode': 2,
             'map': 6},
    360449: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Tenements (MAP17) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 6},
    360450: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Tenements (MAP17) - Computer area map',
             'doom_type': 2026,
             'episode': 2,
             'map': 6},
    360451: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Courtyard (MAP18)',
             'doom_type': -1,
             'episode': 2,
             'map': 7},
    360452: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Courtyard (MAP18) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 7},
    360453: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Courtyard (MAP18) - Computer area map',
             'doom_type': 2026,
             'episode': 2,
             'map': 7},
    360454: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (MAP19)',
             'doom_type': -1,
             'episode': 2,
             'map': 8},
    360455: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Citadel (MAP19) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 8},
    360456: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Citadel (MAP19) - Computer area map',
             'doom_type': 2026,
             'episode': 2,
             'map': 8},
    360457: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Gotcha! (MAP20)',
             'doom_type': -1,
             'episode': 2,
             'map': 9},
    360458: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Gotcha! (MAP20) - Complete',
             'doom_type': -2,
             'episode': 2,
             'map': 9},
    360459: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Gotcha! (MAP20) - Computer area map',
             'doom_type': 2026,
             'episode': 2,
             'map': 9},
    360460: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Nirvana (MAP21)',
             'doom_type': -1,
             'episode': 3,
             'map': 1},
    360461: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Nirvana (MAP21) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 1},
    360462: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Nirvana (MAP21) - Computer area map',
             'doom_type': 2026,
             'episode': 3,
             'map': 1},
    360463: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Catacombs (MAP22)',
             'doom_type': -1,
             'episode': 3,
             'map': 2},
    360464: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Catacombs (MAP22) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 2},
    360465: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Catacombs (MAP22) - Computer area map',
             'doom_type': 2026,
             'episode': 3,
             'map': 2},
    360466: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Barrels o' Fun (MAP23)",
             'doom_type': -1,
             'episode': 3,
             'map': 3},
    360467: {'classification': ItemClassification.progression,
             'count': 1,
             'name': "Barrels o' Fun (MAP23) - Complete",
             'doom_type': -2,
             'episode': 3,
             'map': 3},
    360468: {'classification': ItemClassification.filler,
             'count': 1,
             'name': "Barrels o' Fun (MAP23) - Computer area map",
             'doom_type': 2026,
             'episode': 3,
             'map': 3},
    360469: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Chasm (MAP24)',
             'doom_type': -1,
             'episode': 3,
             'map': 4},
    360470: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Chasm (MAP24) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 4},
    360471: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Chasm (MAP24) - Computer area map',
             'doom_type': 2026,
             'episode': 3,
             'map': 4},
    360472: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Bloodfalls (MAP25)',
             'doom_type': -1,
             'episode': 3,
             'map': 5},
    360473: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Bloodfalls (MAP25) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 5},
    360474: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Bloodfalls (MAP25) - Computer area map',
             'doom_type': 2026,
             'episode': 3,
             'map': 5},
    360475: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Abandoned Mines (MAP26)',
             'doom_type': -1,
             'episode': 3,
             'map': 6},
    360476: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Abandoned Mines (MAP26) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 6},
    360477: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Abandoned Mines (MAP26) - Computer area map',
             'doom_type': 2026,
             'episode': 3,
             'map': 6},
    360478: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Monster Condo (MAP27)',
             'doom_type': -1,
             'episode': 3,
             'map': 7},
    360479: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Monster Condo (MAP27) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 7},
    360480: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Monster Condo (MAP27) - Computer area map',
             'doom_type': 2026,
             'episode': 3,
             'map': 7},
    360481: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Spirit World (MAP28)',
             'doom_type': -1,
             'episode': 3,
             'map': 8},
    360482: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Spirit World (MAP28) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 8},
    360483: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Spirit World (MAP28) - Computer area map',
             'doom_type': 2026,
             'episode': 3,
             'map': 8},
    360484: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Living End (MAP29)',
             'doom_type': -1,
             'episode': 3,
             'map': 9},
    360485: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'The Living End (MAP29) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 9},
    360486: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'The Living End (MAP29) - Computer area map',
             'doom_type': 2026,
             'episode': 3,
             'map': 9},
    360487: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Icon of Sin (MAP30)',
             'doom_type': -1,
             'episode': 3,
             'map': 10},
    360488: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Icon of Sin (MAP30) - Complete',
             'doom_type': -2,
             'episode': 3,
             'map': 10},
    360489: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Icon of Sin (MAP30) - Computer area map',
             'doom_type': 2026,
             'episode': 3,
             'map': 10},
    360490: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Wolfenstein (MAP31)',
             'doom_type': -1,
             'episode': 4,
             'map': 1},
    360491: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Wolfenstein (MAP31) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 1},
    360492: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Wolfenstein (MAP31) - Computer area map',
             'doom_type': 2026,
             'episode': 4,
             'map': 1},
    360493: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Grosse (MAP32)',
             'doom_type': -1,
             'episode': 4,
             'map': 2},
    360494: {'classification': ItemClassification.progression,
             'count': 1,
             'name': 'Grosse (MAP32) - Complete',
             'doom_type': -2,
             'episode': 4,
             'map': 2},
    360495: {'classification': ItemClassification.filler,
             'count': 1,
             'name': 'Grosse (MAP32) - Computer area map',
             'doom_type': 2026,
             'episode': 4,
             'map': 2},
    360600: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Bullet capacity',
             'doom_type': 65001,
             'episode': -1,
             'map': -1},
    360601: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Shell capacity',
             'doom_type': 65002,
             'episode': -1,
             'map': -1},
    360602: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Energy cell capacity',
             'doom_type': 65003,
             'episode': -1,
             'map': -1},
    360603: {'classification': ItemClassification.useful,
             'count': 0,
             'name': 'Rocket capacity',
             'doom_type': 65004,
             'episode': -1,
             'map': -1},
}


item_name_groups: Dict[str, Set[str]] = {
    'Ammos': {'Box of bullets', 'Box of rockets', 'Box of shotgun shells', 'Energy cell pack', },
    'Computer area maps': {"Barrels o' Fun (MAP23) - Computer area map", 'Bloodfalls (MAP25) - Computer area map', 'Circle of Death (MAP11) - Computer area map', 'Dead Simple (MAP07) - Computer area map', 'Downtown (MAP13) - Computer area map', 'Entryway (MAP01) - Computer area map', 'Gotcha! (MAP20) - Computer area map', 'Grosse (MAP32) - Computer area map', 'Icon of Sin (MAP30) - Computer area map', 'Industrial Zone (MAP15) - Computer area map', 'Monster Condo (MAP27) - Computer area map', 'Nirvana (MAP21) - Computer area map', 'Refueling Base (MAP10) - Computer area map', 'Suburbs (MAP16) - Computer area map', 'Tenements (MAP17) - Computer area map', 'The Abandoned Mines (MAP26) - Computer area map', 'The Catacombs (MAP22) - Computer area map', 'The Chasm (MAP24) - Computer area map', 'The Citadel (MAP19) - Computer area map', 'The Courtyard (MAP18) - Computer area map', 'The Crusher (MAP06) - Computer area map', 'The Factory (MAP12) - Computer area map', 'The Focus (MAP04) - Computer area map', 'The Gantlet (MAP03) - Computer area map', 'The Inmost Dens (MAP14) - Computer area map', 'The Living End (MAP29) - Computer area map', 'The Pit (MAP09) - Computer area map', 'The Spirit World (MAP28) - Computer area map', 'The Waste Tunnels (MAP05) - Computer area map', 'Tricks and Traps (MAP08) - Computer area map', 'Underhalls (MAP02) - Computer area map', 'Wolfenstein (MAP31) - Computer area map', },
    'Keys': {"Barrels o' Fun (MAP23) - Yellow skull key", 'Bloodfalls (MAP25) - Blue skull key', 'Circle of Death (MAP11) - Blue keycard', 'Circle of Death (MAP11) - Red keycard', 'Downtown (MAP13) - Blue keycard', 'Downtown (MAP13) - Red keycard', 'Downtown (MAP13) - Yellow keycard', 'Industrial Zone (MAP15) - Blue keycard', 'Industrial Zone (MAP15) - Red keycard', 'Industrial Zone (MAP15) - Yellow keycard', 'Monster Condo (MAP27) - Blue skull key', 'Monster Condo (MAP27) - Red skull key', 'Monster Condo (MAP27) - Yellow skull key', 'Nirvana (MAP21) - Blue skull key', 'Nirvana (MAP21) - Red skull key', 'Nirvana (MAP21) - Yellow skull key', 'Refueling Base (MAP10) - Blue keycard', 'Refueling Base (MAP10) - Yellow keycard', 'Suburbs (MAP16) - Blue skull key', 'Suburbs (MAP16) - Red skull key', 'Tenements (MAP17) - Blue keycard', 'Tenements (MAP17) - Red keycard', 'Tenements (MAP17) - Yellow skull key', 'The Abandoned Mines (MAP26) - Blue keycard', 'The Abandoned Mines (MAP26) - Red keycard', 'The Abandoned Mines (MAP26) - Yellow keycard', 'The Catacombs (MAP22) - Blue skull key', 'The Catacombs (MAP22) - Red skull key', 'The Chasm (MAP24) - Blue keycard', 'The Chasm (MAP24) - Red keycard', 'The Citadel (MAP19) - Blue skull key', 'The Citadel (MAP19) - Red skull key', 'The Citadel (MAP19) - Yellow skull key', 'The Courtyard (MAP18) - Blue skull key', 'The Courtyard (MAP18) - Yellow skull key', 'The Crusher (MAP06) - Blue keycard', 'The Crusher (MAP06) - Red keycard', 'The Crusher (MAP06) - Yellow keycard', 'The Factory (MAP12) - Blue keycard', 'The Factory (MAP12) - Yellow keycard', 'The Focus (MAP04) - Blue keycard', 'The Focus (MAP04) - Red keycard', 'The Focus (MAP04) - Yellow keycard', 'The Gantlet (MAP03) - Blue keycard', 'The Gantlet (MAP03) - Red keycard', 'The Inmost Dens (MAP14) - Blue skull key', 'The Inmost Dens (MAP14) - Red skull key', 'The Pit (MAP09) - Blue keycard', 'The Pit (MAP09) - Yellow keycard', 'The Spirit World (MAP28) - Red skull key', 'The Spirit World (MAP28) - Yellow skull key', 'The Waste Tunnels (MAP05) - Blue keycard', 'The Waste Tunnels (MAP05) - Red keycard', 'The Waste Tunnels (MAP05) - Yellow keycard', 'Tricks and Traps (MAP08) - Red skull key', 'Tricks and Traps (MAP08) - Yellow skull key', 'Underhalls (MAP02) - Blue keycard', 'Underhalls (MAP02) - Red keycard', },
    'Levels': {"Barrels o' Fun (MAP23)", 'Bloodfalls (MAP25)', 'Circle of Death (MAP11)', 'Dead Simple (MAP07)', 'Downtown (MAP13)', 'Entryway (MAP01)', 'Gotcha! (MAP20)', 'Grosse (MAP32)', 'Icon of Sin (MAP30)', 'Industrial Zone (MAP15)', 'Monster Condo (MAP27)', 'Nirvana (MAP21)', 'Refueling Base (MAP10)', 'Suburbs (MAP16)', 'Tenements (MAP17)', 'The Abandoned Mines (MAP26)', 'The Catacombs (MAP22)', 'The Chasm (MAP24)', 'The Citadel (MAP19)', 'The Courtyard (MAP18)', 'The Crusher (MAP06)', 'The Factory (MAP12)', 'The Focus (MAP04)', 'The Gantlet (MAP03)', 'The Inmost Dens (MAP14)', 'The Living End (MAP29)', 'The Pit (MAP09)', 'The Spirit World (MAP28)', 'The Waste Tunnels (MAP05)', 'Tricks and Traps (MAP08)', 'Underhalls (MAP02)', 'Wolfenstein (MAP31)', },
    'Powerups': {'Armor', 'Berserk', 'Invulnerability', 'Mega Armor', 'Megasphere', 'Partial invisibility', 'Supercharge', },
    'Weapons': {'BFG9000', 'Chaingun', 'Chainsaw', 'Plasma gun', 'Rocket launcher', 'Shotgun', 'Super Shotgun', },
}
