from BaseClasses import Item, ItemClassification
import typing


class ItemData(typing.NamedTuple):
    code: typing.Optional[int]
    classification: any


class UndertaleItem(Item):
    game: str = "Undertale"


item_table = {
    "Progressive Plot": ItemData(77700, ItemClassification.progression),
    "Progressive Weapons": ItemData(77701, ItemClassification.useful),
    "Progressive Armor": ItemData(77702, ItemClassification.useful),
    "Monster Candy": ItemData(77001, ItemClassification.filler),
    "Croquet Roll": ItemData(77002, ItemClassification.filler),
    "Stick": ItemData(77003, ItemClassification.useful),
    "Bandage": ItemData(77004, ItemClassification.useful),
    "Rock Candy": ItemData(77005, ItemClassification.filler),
    "Pumpkin Rings": ItemData(77006, ItemClassification.filler),
    "Spider Donut": ItemData(77007, ItemClassification.filler),
    "Stoic Onion": ItemData(77008, ItemClassification.filler),
    "Ghost Fruit": ItemData(77009, ItemClassification.filler),
    "Spider Cider": ItemData(77010, ItemClassification.filler),
    "Butterscotch Pie": ItemData(77011, ItemClassification.useful),
    "Faded Ribbon": ItemData(77012, ItemClassification.useful),
    "Toy Knife": ItemData(77013, ItemClassification.useful),
    "Tough Glove": ItemData(77014, ItemClassification.useful),
    "Manly Bandanna": ItemData(77015, ItemClassification.useful),
    "Snowman Piece": ItemData(77016, ItemClassification.useful),
    "Nice Cream": ItemData(77017, ItemClassification.filler),
    "Puppydough Icecream": ItemData(77018, ItemClassification.filler),
    "Bisicle": ItemData(77019, ItemClassification.filler),
    "Unisicle": ItemData(77020, ItemClassification.filler),
    "Cinnamon Bun": ItemData(77021, ItemClassification.filler),
    "Temmie Flakes": ItemData(77022, ItemClassification.filler),
    "Abandoned Quiche": ItemData(77023, ItemClassification.filler),
    "Old Tutu": ItemData(77024, ItemClassification.useful),
    "Ballet Shoes": ItemData(77025, ItemClassification.useful),
    "Punch Card": ItemData(77026, ItemClassification.progression),
    "Annoying Dog": ItemData(77027, ItemClassification.filler),
    "Dog Salad": ItemData(77028, ItemClassification.filler),
    "Dog Residue": ItemData(77029, ItemClassification.filler),
    "Astronaut Food": ItemData(77035, ItemClassification.filler),
    "Instant Noodles": ItemData(77036, ItemClassification.useful),
    "Crab Apple": ItemData(77037, ItemClassification.filler),
    "Hot Dog...?": ItemData(77038, ItemClassification.progression),
    "Hot Cat": ItemData(77039, ItemClassification.filler),
    "Glamburger": ItemData(77040, ItemClassification.filler),
    "Sea Tea": ItemData(77041, ItemClassification.filler),
    "Starfait": ItemData(77042, ItemClassification.filler),
    "Legendary Hero": ItemData(77043, ItemClassification.filler),
    "Cloudy Glasses": ItemData(77044, ItemClassification.useful),
    "Torn Notebook": ItemData(77045, ItemClassification.useful),
    "Stained Apron": ItemData(77046, ItemClassification.useful),
    "Burnt Pan": ItemData(77047, ItemClassification.useful),
    "Cowboy Hat": ItemData(77048, ItemClassification.useful),
    "Empty Gun": ItemData(77049, ItemClassification.useful),
    "Heart Locket": ItemData(77050, ItemClassification.useful),
    "Worn Dagger": ItemData(77051, ItemClassification.useful),
    "Real Knife": ItemData(77052, ItemClassification.useful),
    "The Locket": ItemData(77053, ItemClassification.useful),
    "Bad Memory": ItemData(77054, ItemClassification.filler),
    "Dream": ItemData(77055, ItemClassification.filler),
    "Undyne's Letter": ItemData(77056, ItemClassification.filler),
    "Undyne Letter EX": ItemData(77057, ItemClassification.progression),
    "Popato Chisps": ItemData(77058, ItemClassification.filler),
    "Junk Food": ItemData(77059, ItemClassification.filler),
    "Mystery Key": ItemData(77060, ItemClassification.filler),
    "Face Steak": ItemData(77061, ItemClassification.filler),
    "Hush Puppy": ItemData(77062, ItemClassification.filler),
    "Snail Pie": ItemData(77063, ItemClassification.filler),
    "temy armor": ItemData(77064, ItemClassification.useful),
    "Complete Skeleton": ItemData(77779, ItemClassification.progression),
    "Fish": ItemData(77780, ItemClassification.progression),
    "DT Extractor": ItemData(77782, ItemClassification.progression),
    "Mettaton Plush": ItemData(77786, ItemClassification.progression),
    "Left Home Key": ItemData(77787, ItemClassification.progression),
    "LOVE": ItemData(77788, ItemClassification.useful),
    "Right Home Key": ItemData(77789, ItemClassification.progression),
    "Key Piece": ItemData(77000, ItemClassification.progression),
    "100G": ItemData(77999, ItemClassification.useful),
    "500G": ItemData(77998, ItemClassification.useful),
    "1000G": ItemData(77997, ItemClassification.progression),
    "ATK Up": ItemData(77065, ItemClassification.useful),
    "DEF Up": ItemData(77066, ItemClassification.useful),
    "HP Up": ItemData(77067, ItemClassification.useful),
    "FIGHT": ItemData(77077, ItemClassification.useful),
    "ACT": ItemData(77078, ItemClassification.useful),
    "ITEM": ItemData(77079, ItemClassification.useful),
    "MERCY": ItemData(77080, ItemClassification.useful),
    "Ruins Key": ItemData(77081, ItemClassification.progression),
    "Snowdin Key": ItemData(77082, ItemClassification.progression),
    "Waterfall Key": ItemData(77083, ItemClassification.progression),
    "Hotland Key": ItemData(77084, ItemClassification.progression),
    "Core Key": ItemData(77085, ItemClassification.progression),
    "Undyne Date": ItemData(None, ItemClassification.progression),
    "Alphys Date": ItemData(None, ItemClassification.progression),
    "Papyrus Date": ItemData(None, ItemClassification.progression),
}

non_key_items = {
    "Butterscotch Pie": 1,
    "500G": 2,
    "Face Steak": 1,
    "Snowman Piece": 1,
    "Instant Noodles": 1,
    "Astronaut Food": 2,
    "Hot Cat": 1,
    "Abandoned Quiche": 1,
    "Spider Donut": 1,
    "Spider Cider": 1,
    "Hush Puppy": 1,
}

required_armor = {
    "Cloudy Glasses": 1,
    "Manly Bandanna": 1,
    "Old Tutu": 1,
    "Stained Apron": 1,
    "Heart Locket": 1,
    "Faded Ribbon": 1,
    "Cowboy Hat": 1,
}

required_weapons = {
    "Torn Notebook": 1,
    "Tough Glove": 1,
    "Ballet Shoes": 1,
    "Burnt Pan": 1,
    "Worn Dagger": 1,
    "Toy Knife": 1,
    "Empty Gun": 1,
}

plot_items = {
    "Complete Skeleton": 1,
    "Fish": 1,
    "Mettaton Plush": 1,
    "DT Extractor": 1,
}

key_items = {
    "Complete Skeleton": 1,
    "Fish": 1,
    "1000G": 2,
    "DT Extractor": 1,
    "Mettaton Plush": 1,
    "Punch Card": 3,
    "Hot Dog...?": 1,
    "ATK Up": 19,
    "DEF Up": 4,
    "HP Up": 19,
    "LOVE": 19,
    "Ruins Key": 1,
    "Snowdin Key": 1,
    "Waterfall Key": 1,
    "Hotland Key": 1,
    "Core Key": 1,
}

junk_weights_all = {
    "Bisicle": 12,
    "Legendary Hero": 8,
    "Glamburger": 10,
    "Crab Apple": 12,
    "Sea Tea": 12,
    "Nice Cream": 10,
    "Spider Donut": 10,
    "Popato Chisps": 12,
    "Junk Food": 12,
    "Temmie Flakes": 10,
    "Spider Cider": 8,
    "Hot Dog...?": 10,
    "Cinnamon Bun": 10,
    "Starfait": 12,
    "Punch Card": 8,
    "Monster Candy": 6,
    "100G": 6,
    "500G": 3,
}

junk_weights_neutral = {
    "Bisicle": 12,
    "Legendary Hero": 8,
    "Glamburger": 10,
    "Crab Apple": 12,
    "Sea Tea": 12,
    "Nice Cream": 10,
    "Spider Donut": 10,
    "Junk Food": 12,
    "Temmie Flakes": 10,
    "Spider Cider": 8,
    "Cinnamon Bun": 10,
    "Starfait": 12,
    "Punch Card": 8,
    "Monster Candy": 6,
    "100G": 6,
    "500G": 3,
}

junk_weights_pacifist = {
    "Bisicle": 12,
    "Legendary Hero": 8,
    "Glamburger": 10,
    "Crab Apple": 12,
    "Sea Tea": 12,
    "Nice Cream": 10,
    "Spider Donut": 10,
    "Popato Chisps": 12,
    "Junk Food": 12,
    "Temmie Flakes": 10,
    "Spider Cider": 8,
    "Hot Dog...?": 10,
    "Cinnamon Bun": 10,
    "Starfait": 12,
    "Punch Card": 8,
    "Monster Candy": 6,
    "100G": 6,
    "500G": 3,
}

junk_weights_genocide = {
    "Bisicle": 12,
    "Legendary Hero": 8,
    "Glamburger": 10,
    "Crab Apple": 12,
    "Sea Tea": 12,
    "Spider Donut": 10,
    "Junk Food": 12,
    "Temmie Flakes": 10,
    "Spider Cider": 8,
    "Cinnamon Bun": 10,
    "Starfait": 12,
    "Monster Candy": 6,
    "100G": 6,
    "500G": 3,
}
