import typing
from ..Names import LocationName


class WorldLocationData(typing.NamedTuple):
    # save+
    addrObtained: int
    # bitmask
    bitIndex: int


LoD_Checks = {
    LocationName.BambooGroveDarkShard:        WorldLocationData(0x23AC, 1),
    LocationName.BambooGroveEther:            WorldLocationData(0x23D9, 7),
    LocationName.BambooGroveMythrilShard:     WorldLocationData(0x23DA, 0),
    LocationName.EncampmentAreaMap:           WorldLocationData(0x1D94, 6),
    LocationName.Mission3:                    WorldLocationData(0x1D96, 0),
    LocationName.CheckpointHiPotion:          WorldLocationData(0x23AD, 1),
    LocationName.CheckpointMythrilShard:      WorldLocationData(0x23AD, 2),
    LocationName.MountainTrailLightningShard: WorldLocationData(0x23AD, 3),
    LocationName.MountainTrailRecoveryRecipe: WorldLocationData(0x23AD, 4),
    LocationName.MountainTrailEther:          WorldLocationData(0x23AD, 5),
    LocationName.MountainTrailMythrilShard:   WorldLocationData(0x23AD, 6),
    LocationName.VillageCaveAreaMap:          WorldLocationData(0x1D96, 6),
    LocationName.VillageCaveDarkShard:        WorldLocationData(0x23AE, 0),
    LocationName.VillageCaveAPBoost:          WorldLocationData(0x23AD, 7),
    LocationName.VillageCaveBonus:            WorldLocationData(0x3709, 3),
    LocationName.RidgeFrostShard:             WorldLocationData(0x23AE, 1),
    LocationName.RidgeAPBoost:                WorldLocationData(0x23AE, 2),
    LocationName.ShanYu:                      WorldLocationData(0x3705, 1),
    LocationName.ShanYuGetBonus:              WorldLocationData(0x3705, 1),
    LocationName.GoofyShanYu:                 WorldLocationData(0x3705, 1),
    LocationName.HiddenDragon:                WorldLocationData(0x1D92, 2),
    LocationName.ThroneRoomTornPages:         WorldLocationData(0x23AE, 3),
    LocationName.ThroneRoomPalaceMap:         WorldLocationData(0x23AE, 4),
    LocationName.ThroneRoomAPBoost:           WorldLocationData(0x23AE, 5),
    LocationName.ThroneRoomQueenRecipe:       WorldLocationData(0x23AE, 6),
    LocationName.ThroneRoomAPBoost2:          WorldLocationData(0x23AE, 7),
    LocationName.ThroneRoomOgreShield:        WorldLocationData(0x23AF, 0),
    LocationName.ThroneRoomMythrilCrystal:    WorldLocationData(0x23AF, 1),
    LocationName.ThroneRoomOrichalcum:        WorldLocationData(0x23AF, 2),
    LocationName.StormRider:                  WorldLocationData(0x3705, 2),
    LocationName.GoofyStormRider:             WorldLocationData(0x3705, 2),

}
AG_Checks = {
    LocationName.AgrabahMap:                        WorldLocationData(0x1D74, 4),
    LocationName.AgrabahDarkShard:                  WorldLocationData(0x23AF, 3),
    LocationName.AgrabahMythrilShard:               WorldLocationData(0x23AF, 4),
    LocationName.AgrabahHiPotion:                   WorldLocationData(0x23AF, 5),
    LocationName.AgrabahAPBoost:                    WorldLocationData(0x23AF, 6),
    LocationName.AgrabahMythrilStone:               WorldLocationData(0x23AF, 7),
    LocationName.AgrabahMythrilShard2:              WorldLocationData(0x23B0, 0),
    LocationName.AgrabahSerenityShard:              WorldLocationData(0x23DA, 3),
    LocationName.BazaarMythrilGem:                  WorldLocationData(0x23B0, 1),
    LocationName.BazaarPowerShard:                  WorldLocationData(0x23B0, 2),
    LocationName.BazaarHiPotion:                    WorldLocationData(0x23B0, 3),
    LocationName.BazaarAPBoost:                     WorldLocationData(0x23B0, 4),
    LocationName.BazaarMythrilShard:                WorldLocationData(0x23B0, 5),
    LocationName.PalaceWallsSkillRing:              WorldLocationData(0x23B0, 6),
    LocationName.PalaceWallsMythrilStone:           WorldLocationData(0x23DB, 5),
    LocationName.CaveEntrancePowerStone:            WorldLocationData(0x23B0, 7),
    LocationName.CaveEntranceMythrilShard:          WorldLocationData(0x23B1, 0),
    LocationName.ValleyofStoneMythrilStone:         WorldLocationData(0x23B1, 2),
    LocationName.ValleyofStoneAPBoost:              WorldLocationData(0x23B1, 3),
    LocationName.ValleyofStoneMythrilShard:         WorldLocationData(0x23B1, 4),
    LocationName.ValleyofStoneHiPotion:             WorldLocationData(0x23B1, 5),
    LocationName.AbuEscort:                         WorldLocationData(0x3709, 2),
    LocationName.DonaldAbuEscort:                   WorldLocationData(0x3709, 2),
    LocationName.ChasmofChallengesCaveofWondersMap: WorldLocationData(0x23D8, 7),
    LocationName.ChasmofChallengesAPBoost:          WorldLocationData(0x23B1, 6),
    LocationName.TreasureRoom:                      WorldLocationData(0x3709, 6),
    LocationName.GoofyTreasureRoom:                 WorldLocationData(0x3709, 6),
    LocationName.TreasureRoomAPBoost:               WorldLocationData(0x23DA, 4),
    LocationName.TreasureRoomSerenityGem:           WorldLocationData(0x23DA, 5),
    LocationName.ElementalLords:                    WorldLocationData(0x3708, 5),
    LocationName.LampCharm:                         WorldLocationData(0x1D72, 4),
    LocationName.RuinedChamberTornPages:            WorldLocationData(0x23B1, 1),
    LocationName.RuinedChamberRuinsMap:             WorldLocationData(0x23D8, 6),
    LocationName.GenieJafar:                        WorldLocationData(0x3705, 7),
    LocationName.WishingLamp:                       WorldLocationData(0x1D77, 3),

}
DC_Checks = {
    LocationName.DCCourtyardMythrilShard:        WorldLocationData(0x23B4, 1),
    LocationName.DCCourtyardStarRecipe:          WorldLocationData(0x23B4, 2),
    LocationName.DCCourtyardAPBoost:             WorldLocationData(0x23B4, 3),
    LocationName.DCCourtyardMythrilStone:        WorldLocationData(0x23B4, 4),
    LocationName.DCCourtyardBlazingStone:        WorldLocationData(0x23B4, 5),
    LocationName.DCCourtyardBlazingShard:        WorldLocationData(0x23B4, 6),
    LocationName.DCCourtyardMythrilShard2:       WorldLocationData(0x23B4, 7),
    LocationName.LibraryTornPages:               WorldLocationData(0x23B4, 0),
    LocationName.DisneyCastleMap:                WorldLocationData(0x1E10, 4),
    LocationName.MinnieEscort:                   WorldLocationData(0x3708, 6),
    LocationName.MinnieEscortGetBonus:           WorldLocationData(0x3708, 6),
    LocationName.LingeringWillBonus:             WorldLocationData(0x370C, 6),
    LocationName.LingeringWillProofofConnection: WorldLocationData(0x370C, 6),
    LocationName.LingeringWillManifestIllusion:  WorldLocationData(0x370C, 6),

    'Lingering Will Bonus: Sora Slot 1':         WorldLocationData(14092, 6),
    'Lingering Will Proof of Connection':        WorldLocationData(14092, 6),
    'Lingering Will Manifest Illusion':          WorldLocationData(14092, 6),
}
TR_Checks = {
    LocationName.CornerstoneHillMap:        WorldLocationData(0x23B2, 0),
    LocationName.CornerstoneHillFrostShard: WorldLocationData(0x23B2, 1),
    LocationName.PierMythrilShard:          WorldLocationData(0x23B2, 3),
    LocationName.PierHiPotion:              WorldLocationData(0x23B2, 4),
    LocationName.WaterwayMythrilStone:      WorldLocationData(0x23B2, 5),
    LocationName.WaterwayAPBoost:           WorldLocationData(0x23B2, 6),
    LocationName.WaterwayFrostStone:        WorldLocationData(0x23B2, 7),
    LocationName.WindowofTimeMap:           WorldLocationData(0x1E32, 4),
    LocationName.BoatPete:                  WorldLocationData(0x3706, 0),
    LocationName.DonaldBoatPete:            WorldLocationData(0x3706, 0),
    LocationName.DonaldBoatPeteGetBonus:    WorldLocationData(0x3706, 0),
    LocationName.FuturePete:                WorldLocationData(0x3706, 1),
    LocationName.FuturePeteGetBonus:        WorldLocationData(0x3706, 1),
    LocationName.GoofyFuturePete:           WorldLocationData(0x3706, 1),
    LocationName.Monochrome:                WorldLocationData(0x1E33, 2),
    LocationName.WisdomForm:                WorldLocationData(0x1E33, 2),
}

HundredAcreChecks = {
    LocationName.PoohsHouse100AcreWoodMap:   WorldLocationData(0x23C9, 7),
    LocationName.PoohsHouseAPBoost:          WorldLocationData(0x23B5, 4),
    LocationName.PoohsHouseMythrilStone:     WorldLocationData(0x23B5, 5),
    LocationName.PigletsHouseDefenseBoost:   WorldLocationData(0x23B6, 4),
    LocationName.PigletsHouseAPBoost:        WorldLocationData(0x23B6, 2),
    LocationName.PigletsHouseMythrilGem:     WorldLocationData(0x23B6, 3),
    LocationName.RabbitsHouseDrawRing:       WorldLocationData(0x23CA, 0),
    LocationName.RabbitsHouseMythrilCrystal: WorldLocationData(0x23B5, 7),
    LocationName.RabbitsHouseAPBoost:        WorldLocationData(0x23B6, 0),
    LocationName.KangasHouseMagicBoost:      WorldLocationData(0x23B6, 7),
    LocationName.KangasHouseAPBoost:         WorldLocationData(0x23B6, 5),
    LocationName.KangasHouseOrichalcum:      WorldLocationData(0x23B6, 6),
    LocationName.SpookyCaveMythrilGem:       WorldLocationData(0x23B7, 1),
    LocationName.SpookyCaveAPBoost:          WorldLocationData(0x23B7, 2),
    LocationName.SpookyCaveOrichalcum:       WorldLocationData(0x23B7, 3),
    LocationName.SpookyCaveGuardRecipe:      WorldLocationData(0x23B7, 4),
    LocationName.SpookyCaveMythrilCrystal:   WorldLocationData(0x23B7, 6),
    LocationName.SpookyCaveAPBoost2:         WorldLocationData(0x23B7, 7),
    LocationName.SweetMemories:              WorldLocationData(0x1DB4, 6),
    LocationName.SpookyCaveMap:              WorldLocationData(0x1DB4, 6),
    LocationName.StarryHillCosmicRing:       WorldLocationData(0x23C9, 6),
    LocationName.StarryHillStyleRecipe:      WorldLocationData(0x23B5, 1),
    LocationName.StarryHillCureElement:      WorldLocationData(0x1DB5, 5),
    LocationName.StarryHillOrichalcumPlus:   WorldLocationData(0x1DB5, 5),
}
Oc_Checks = {
    LocationName.PassageMythrilShard:            WorldLocationData(0x23B9, 6),
    LocationName.PassageMythrilStone:            WorldLocationData(0x23B9, 7),
    LocationName.PassageEther:                   WorldLocationData(0x23BA, 0),
    LocationName.PassageAPBoost:                 WorldLocationData(0x23BA, 1),
    LocationName.PassageHiPotion:                WorldLocationData(0x23BA, 2),
    LocationName.InnerChamberUnderworldMap:      WorldLocationData(0x23B8, 4),
    LocationName.InnerChamberMythrilShard:       WorldLocationData(0x23B8, 3),
    LocationName.Cerberus:                       WorldLocationData(0x3704, 5),
    LocationName.ColiseumMap:                    WorldLocationData(0x1D5A, 4),
    LocationName.Urns:                           WorldLocationData(0x370B, 1),
    LocationName.UnderworldEntrancePowerBoost:   WorldLocationData(0x23B8, 0),
    LocationName.CavernsEntranceLucidShard:      WorldLocationData(0x23B8, 5),
    LocationName.CavernsEntranceAPBoost:         WorldLocationData(0x23B8, 6),
    LocationName.CavernsEntranceMythrilShard:    WorldLocationData(0x23DA, 6),
    LocationName.TheLostRoadBrightShard:         WorldLocationData(0x23BA, 3),
    LocationName.TheLostRoadEther:               WorldLocationData(0x23BA, 4),
    LocationName.TheLostRoadMythrilShard:        WorldLocationData(0x23BA, 5),
    LocationName.TheLostRoadMythrilStone:        WorldLocationData(0x23BA, 6),
    LocationName.AtriumLucidStone:               WorldLocationData(0x23BA, 7),
    LocationName.AtriumAPBoost:                  WorldLocationData(0x23BB, 0),
    LocationName.DemyxOC:                        WorldLocationData(0x370B, 2),
    LocationName.DonaldDemyxOC:                  WorldLocationData(0x370B, 2),
    LocationName.SecretAnsemReport5:             WorldLocationData(0x1D5B, 3),
    LocationName.OlympusStone:                   WorldLocationData(0x1D5B, 3),
    LocationName.TheLockCavernsMap:              WorldLocationData(0x23B9, 4),
    LocationName.TheLockMythrilShard:            WorldLocationData(0x23B9, 0),
    LocationName.TheLockAPBoost:                 WorldLocationData(0x23B9, 2),
    LocationName.PeteOC:                         WorldLocationData(0x3704, 6),
    LocationName.GoofyPeteOC:                    WorldLocationData(0x3704, 6),
    LocationName.Hydra:                          WorldLocationData(0x3704, 7),
    LocationName.HydraGetBonus:                  WorldLocationData(0x3704, 7),
    LocationName.HerosCrest:                     WorldLocationData(0x1D55, 7),
    LocationName.AuronsStatue:                   WorldLocationData(0x1D5F, 2),
    LocationName.Hades:                          WorldLocationData(0x3705, 0),
    LocationName.HadesGetBonus:                  WorldLocationData(0x3705, 0),
    LocationName.GuardianSoul:                   WorldLocationData(0x1D56, 5),
    LocationName.ProtectBeltPainandPanicCup:     WorldLocationData(0x1D57, 6),
    LocationName.SerenityGemPainandPanicCup:     WorldLocationData(0x1D57, 6),
    LocationName.RisingDragonCerberusCup:        WorldLocationData(0x1D58, 0),
    LocationName.SerenityCrystalCerberusCup:     WorldLocationData(0x1D58, 0),
    LocationName.GenjiShieldTitanCup:            WorldLocationData(0x1D58, 1),
    LocationName.SkillfulRingTitanCup:           WorldLocationData(0x1D58, 1),
    LocationName.FatalCrestGoddessofFateCup:     WorldLocationData(0x1D58, 4),
    LocationName.OrichalcumPlusGoddessofFateCup: WorldLocationData(0x1D58, 4),
    LocationName.HadesCupTrophyParadoxCups:      WorldLocationData(0x1D5A, 1),
}

BC_Checks = {
    LocationName.BCCourtyardAPBoost:            WorldLocationData(0x23BB, 5),
    LocationName.BCCourtyardHiPotion:           WorldLocationData(0x23BB, 6),
    LocationName.BCCourtyardMythrilShard:       WorldLocationData(0x23DA, 7),
    LocationName.BellesRoomCastleMap:           WorldLocationData(0x23BB, 2),
    LocationName.BellesRoomMegaRecipe:          WorldLocationData(0x23BB, 3),
    LocationName.TheEastWingMythrilShard:       WorldLocationData(0x23BB, 7),
    LocationName.TheEastWingTent:               WorldLocationData(0x23BC, 0),
    LocationName.TheWestHallHiPotion:           WorldLocationData(0x23BC, 1),
    LocationName.TheWestHallPowerShard:         WorldLocationData(0x23BC, 3),
    LocationName.TheWestHallAPBoostPostDungeon: WorldLocationData(0x23BC, 5),
    LocationName.TheWestHallBrightStone:        WorldLocationData(0x23DB, 0),
    LocationName.TheWestHallMythrilShard:       WorldLocationData(0x23BC, 2),
    LocationName.TheWestHallMythrilShard2:      WorldLocationData(0x23BC, 4),
    LocationName.Thresholder:                   WorldLocationData(0x3704, 2),
    LocationName.DonaldThresholder:             WorldLocationData(0x3704, 2),
    LocationName.DungeonBasementMap:            WorldLocationData(0x23BD, 0),
    LocationName.DungeonAPBoost:                WorldLocationData(0x23BD, 1),
    LocationName.SecretPassageMythrilShard:     WorldLocationData(0x23BD, 2),
    LocationName.SecretPassageHiPotion:         WorldLocationData(0x23BD, 5),
    LocationName.SecretPassageLucidShard:       WorldLocationData(0x23BD, 3),
    LocationName.TheWestWingMythrilShard:       WorldLocationData(0x23BC, 6),
    LocationName.TheWestWingTent:               WorldLocationData(0x23BC, 7),
    LocationName.Beast:                         WorldLocationData(0x3705, 4),
    LocationName.GoofyBeast:                    WorldLocationData(0x3705, 4),
    LocationName.TheBeastsRoomBlazingShard:     WorldLocationData(0x23BB, 4),
    LocationName.DarkThorn:                     WorldLocationData(0x3704, 3),
    LocationName.DarkThornGetBonus:             WorldLocationData(0x3704, 3),
    LocationName.DarkThornCureElement:          WorldLocationData(0x1D32, 5),
    LocationName.RumblingRose:                  WorldLocationData(0x1D39, 0),
    LocationName.CastleWallsMap:                WorldLocationData(0x1D39, 0),
    LocationName.Xaldin:                        WorldLocationData(0x3704, 4),
    LocationName.XaldinGetBonus:                WorldLocationData(0x3704, 4),
    LocationName.DonaldXaldinGetBonus:          WorldLocationData(0x3704, 4),
    LocationName.SecretAnsemReport4:            WorldLocationData(0x1D31, 2),
    LocationName.XaldinDataDefenseBoost:        WorldLocationData(0x1D34, 7),

    'Data Xaldin':                              WorldLocationData(7476, 7),
}
SP_Checks = {
    LocationName.PitCellAreaMap:                    WorldLocationData(0x23CA, 2),
    LocationName.PitCellMythrilCrystal:             WorldLocationData(0x23BD, 6),
    LocationName.CanyonDarkCrystal:                 WorldLocationData(0x23BE, 1),
    LocationName.CanyonMythrilStone:                WorldLocationData(0x23BE, 2),
    LocationName.CanyonMythrilGem:                  WorldLocationData(0x23BE, 3),
    LocationName.CanyonFrostCrystal:                WorldLocationData(0x23DB, 6),
    LocationName.Screens:                           WorldLocationData(0x3709, 5),
    LocationName.DonaldScreens:                     WorldLocationData(0x3709, 5),
    LocationName.HallwayPowerCrystal:               WorldLocationData(0x23BE, 4),
    LocationName.HallwayAPBoost:                    WorldLocationData(0x23BE, 5),
    LocationName.CommunicationsRoomIOTowerMap:      WorldLocationData(0x23BF, 1),
    LocationName.CommunicationsRoomGaiaBelt:        WorldLocationData(0x23DA, 1),
    LocationName.HostileProgram:                    WorldLocationData(0x3707, 7),
    LocationName.HostileProgramGetBonus:            WorldLocationData(0x3707, 7),
    LocationName.GoofyHostileProgram:               WorldLocationData(0x3707, 7),
    LocationName.PhotonDebugger:                    WorldLocationData(0x1EB2, 3),
    LocationName.SolarSailer:                       WorldLocationData(0x370B, 5),
    LocationName.DonaldSolarSailer:                 WorldLocationData(0x370B, 5),
    LocationName.CentralComputerCoreAPBoost:        WorldLocationData(0x23BF, 4),
    LocationName.CentralComputerCoreOrichalcumPlus: WorldLocationData(0x23BF, 5),
    LocationName.CentralComputerCoreCosmicArts:     WorldLocationData(0x23BF, 6),
    LocationName.CentralComputerCoreMap:            WorldLocationData(0x23D9, 0),
    LocationName.MCP:                               WorldLocationData(0x3708, 0),
    LocationName.MCPGetBonus:                       WorldLocationData(0x3708, 0),
}
HT_Checks = {
    LocationName.GraveyardMythrilShard:           WorldLocationData(0x23C0, 2),
    LocationName.GraveyardSerenityGem:            WorldLocationData(0x23C0, 3),
    LocationName.FinklesteinsLabHalloweenTownMap: WorldLocationData(0x23C0, 1),
    LocationName.TownSquareMythrilStone:          WorldLocationData(0x23BF, 7),
    LocationName.TownSquareEnergyShard:           WorldLocationData(0x23C0, 0),
    LocationName.HinterlandsLightningShard:       WorldLocationData(0x23C0, 4),
    LocationName.HinterlandsMythrilStone:         WorldLocationData(0x23C0, 5),
    LocationName.HinterlandsAPBoost:              WorldLocationData(0x23C0, 6),
    LocationName.CandyCaneLaneMegaPotion:         WorldLocationData(0x23C1, 0),
    LocationName.CandyCaneLaneMythrilGem:         WorldLocationData(0x23C1, 1),
    LocationName.CandyCaneLaneLightningStone:     WorldLocationData(0x23C1, 2),
    LocationName.CandyCaneLaneMythrilStone:       WorldLocationData(0x23C1, 3),
    LocationName.SantasHouseChristmasTownMap:     WorldLocationData(0x23C1, 6),
    LocationName.SantasHouseAPBoost:              WorldLocationData(0x23C1, 4),
    LocationName.PrisonKeeper:                    WorldLocationData(0x3706, 2),
    LocationName.DonaldPrisonKeeper:              WorldLocationData(0x3706, 2),
    LocationName.OogieBoogie:                     WorldLocationData(0x3706, 3),
    LocationName.GoofyOogieBoogie:                WorldLocationData(0x3706, 3),
    LocationName.OogieBoogieMagnetElement:        WorldLocationData(0x1E53, 2),
    LocationName.Lock:                            WorldLocationData(0x3709, 0),
    LocationName.GoofyLock:                       WorldLocationData(0x3709, 0),
    LocationName.Present:                         WorldLocationData(0x1E55, 1),
    LocationName.DecoyPresents:                   WorldLocationData(0x1E55, 4),
    LocationName.Experiment:                      WorldLocationData(0x3706, 4),
    LocationName.DonaldExperiment:                WorldLocationData(0x3706, 4),
    LocationName.DecisivePumpkin:                 WorldLocationData(0x1E56, 0),

}
PR_Checks = {
    LocationName.RampartNavalMap:              WorldLocationData(0x23C2, 1),
    LocationName.RampartMythrilStone:          WorldLocationData(0x23C2, 2),
    LocationName.RampartDarkShard:             WorldLocationData(0x23C2, 3),
    LocationName.TownDarkStone:                WorldLocationData(0x23C2, 4),
    LocationName.TownAPBoost:                  WorldLocationData(0x23C2, 5),
    LocationName.TownMythrilShard:             WorldLocationData(0x23C2, 6),
    LocationName.TownMythrilGem:               WorldLocationData(0x23C2, 7),
    LocationName.CaveMouthBrightShard:         WorldLocationData(0x23C3, 1),
    LocationName.CaveMouthMythrilShard:        WorldLocationData(0x23C3, 2),
    LocationName.IsladeMuertaMap:              WorldLocationData(0x1E92, 4),
    LocationName.BoatFight:                    WorldLocationData(0x370B, 6),
    LocationName.DonaldBoatFight:              WorldLocationData(0x370B, 6),
    LocationName.InterceptorBarrels:           WorldLocationData(0x3708, 7),
    LocationName.GoofyInterceptorBarrels:      WorldLocationData(0x3708, 7),
    LocationName.PowderStoreAPBoost1:          WorldLocationData(0x23CA, 7),
    LocationName.PowderStoreAPBoost2:          WorldLocationData(0x23CB, 0),
    LocationName.MoonlightNookMythrilShard:    WorldLocationData(0x23C3, 4),
    LocationName.MoonlightNookSerenityGem:     WorldLocationData(0x23C3, 5),
    LocationName.MoonlightNookPowerStone:      WorldLocationData(0x23CB, 1),
    LocationName.Barbossa:                     WorldLocationData(0x3706, 5),
    LocationName.BarbossaGetBonus:             WorldLocationData(0x3706, 5),
    LocationName.GoofyBarbossa:                WorldLocationData(0x3706, 5),
    LocationName.GoofyBarbossaGetBonus:        WorldLocationData(0x3706, 5),
    LocationName.FollowtheWind:                WorldLocationData(0x1E93, 6),
    LocationName.GrimReaper1:                  WorldLocationData(0x370B, 3),
    LocationName.GoofyGrimReaper1:             WorldLocationData(0x370B, 3),
    LocationName.InterceptorsHoldFeatherCharm: WorldLocationData(0x23C3, 3),
    LocationName.SeadriftKeepAPBoost:          WorldLocationData(0x23C3, 6),
    LocationName.SeadriftKeepOrichalcum:       WorldLocationData(0x23C3, 7),
    LocationName.SeadriftKeepMeteorStaff:      WorldLocationData(0x23CB, 2),
    LocationName.SeadriftRowSerenityGem:       WorldLocationData(0x23C4, 0),
    LocationName.SeadriftRowKingRecipe:        WorldLocationData(0x23C4, 1),
    LocationName.SeadriftRowMythrilCrystal:    WorldLocationData(0x23CB, 3),
    LocationName.SeadriftRowCursedMedallion:   WorldLocationData(0x1E95, 2),
    LocationName.SeadriftRowShipGraveyardMap:  WorldLocationData(0x1E95, 2),
    LocationName.GrimReaper2:                  WorldLocationData(0x3706, 6),
    LocationName.DonaladGrimReaper2:           WorldLocationData(0x3706, 6),
    LocationName.SecretAnsemReport6:           WorldLocationData(0x1E95, 7),

}
HB_Checks = {
    LocationName.MarketplaceMap:                               WorldLocationData(0x1D17, 4),
    LocationName.BoroughDriveRecovery:                         WorldLocationData(0x23C6, 1),
    LocationName.BoroughAPBoost:                               WorldLocationData(0x23C6, 2),
    LocationName.BoroughHiPotion:                              WorldLocationData(0x23C6, 3),
    LocationName.BoroughMythrilShard:                          WorldLocationData(0x23C8, 7),
    LocationName.BoroughDarkShard:                             WorldLocationData(0x23DB, 1),
    LocationName.MerlinsHouseMembershipCard:                   WorldLocationData(0x1D10, 6),
    LocationName.MerlinsHouseBlizzardElement:                  WorldLocationData(0x1D10, 6),
    # you cannot get these checks without baily so they are all on the same memory value.
    LocationName.Bailey:                                       WorldLocationData(0x3709, 7),
    LocationName.BaileySecretAnsemReport7:                     WorldLocationData(0x3709, 7),
    LocationName.BaseballCharm:                                WorldLocationData(0x3709, 7),
    LocationName.PosternCastlePerimeterMap:                    WorldLocationData(0x23C9, 4),
    LocationName.PosternMythrilGem:                            WorldLocationData(0x23C5, 4),
    LocationName.PosternAPBoost:                               WorldLocationData(0x23C5, 5),
    LocationName.CorridorsMythrilStone:                        WorldLocationData(0x23C6, 7),
    LocationName.CorridorsMythrilCrystal:                      WorldLocationData(0x23C7, 0),
    LocationName.CorridorsDarkCrystal:                         WorldLocationData(0x23C7, 1),
    LocationName.CorridorsAPBoost:                             WorldLocationData(0x23C9, 1),
    # this is probably gonna be wrong
    LocationName.AnsemsStudyMasterForm:                        WorldLocationData(0x1D12, 6),
    LocationName.AnsemsStudySleepingLion:                      WorldLocationData(0x1D12, 6),
    LocationName.AnsemsStudySkillRecipe:                       WorldLocationData(0x23C4, 7),
    LocationName.AnsemsStudyUkuleleCharm:                      WorldLocationData(0x23C4, 6),
    LocationName.RestorationSiteMoonRecipe:                    WorldLocationData(0x23C9, 3),
    LocationName.RestorationSiteAPBoost:                       WorldLocationData(0x23DB, 2),
    LocationName.DemyxHB:                                      WorldLocationData(0x3707, 4),
    '(HB) Demyx Bonus: Donald Slot 1':                         WorldLocationData(14087, 4),
    LocationName.DemyxHBGetBonus:                              WorldLocationData(0x3707, 4),
    LocationName.DonaldDemyxHBGetBonus:                        WorldLocationData(0x3707, 4),
    LocationName.FFFightsCureElement:                          WorldLocationData(0x1D14, 6),
    LocationName.CrystalFissureTornPages:                      WorldLocationData(0x23C4, 2),
    LocationName.CrystalFissureTheGreatMawMap:                 WorldLocationData(0x23D9, 1),
    LocationName.CrystalFissureEnergyCrystal:                  WorldLocationData(0x23C4, 3),
    LocationName.CrystalFissureAPBoost:                        WorldLocationData(0x23C4, 4),
    LocationName.ThousandHeartless:                            WorldLocationData(0x370B, 4),
    LocationName.ThousandHeartlessSecretAnsemReport1:          WorldLocationData(0x1D19, 3),
    LocationName.ThousandHeartlessIceCream:                    WorldLocationData(0x1D23, 0),
    LocationName.ThousandHeartlessPicture:                     WorldLocationData(0x1D23, 0),
    LocationName.PosternGullWing:                              WorldLocationData(0x23D9, 3),
    LocationName.HeartlessManufactoryCosmicChain:              WorldLocationData(0x23C9, 5),
    LocationName.SephirothBonus:                               WorldLocationData(0x3708, 3),
    LocationName.SephirothFenrir:                              WorldLocationData(0x1D1F, 7),
    LocationName.WinnersProof:                                 WorldLocationData(0x1D27, 5),
    LocationName.ProofofPeace:                                 WorldLocationData(0x1D27, 5),

    LocationName.CoRDepthsAPBoost:                             WorldLocationData(0x23DC, 2),
    LocationName.CoRDepthsPowerCrystal:                        WorldLocationData(0x23DC, 3),
    LocationName.CoRDepthsFrostCrystal:                        WorldLocationData(0x23DC, 4),
    LocationName.CoRDepthsManifestIllusion:                    WorldLocationData(0x23DC, 5),
    LocationName.CoRDepthsAPBoost2:                            WorldLocationData(0x23DC, 6),
    LocationName.CoRMineshaftLowerLevelDepthsofRemembranceMap: WorldLocationData(0x23DE, 4),
    LocationName.CoRMineshaftLowerLevelAPBoost:                WorldLocationData(0x23DE, 2),
    LocationName.CoRDepthsUpperLevelRemembranceGem:            WorldLocationData(0x23DC, 7),
    LocationName.CoRMiningAreaSerenityGem:                     WorldLocationData(0x23DD, 0),
    LocationName.CoRMiningAreaAPBoost:                         WorldLocationData(0x23DD, 1),
    LocationName.CoRMiningAreaSerenityCrystal:                 WorldLocationData(0x23DD, 2),
    LocationName.CoRMiningAreaManifestIllusion:                WorldLocationData(0x23DD, 3),
    LocationName.CoRMiningAreaSerenityGem2:                    WorldLocationData(0x23DD, 4),
    LocationName.CoRMiningAreaDarkRemembranceMap:              WorldLocationData(0x23DD, 5),
    LocationName.CoRMineshaftMidLevelPowerBoost:               WorldLocationData(0x23DE, 5),
    LocationName.CoREngineChamberSerenityCrystal:              WorldLocationData(0x23DD, 6),
    LocationName.CoREngineChamberRemembranceCrystal:           WorldLocationData(0x23DD, 7),
    LocationName.CoREngineChamberAPBoost:                      WorldLocationData(0x23DE, 0),
    LocationName.CoREngineChamberManifestIllusion:             WorldLocationData(0x23DE, 1),
    LocationName.CoRMineshaftUpperLevelMagicBoost:             WorldLocationData(0x23DE, 6),
    LocationName.CoRMineshaftUpperLevelAPBoost:                WorldLocationData(0x23DE, 3),
    LocationName.TransporttoRemembrance:                       WorldLocationData(0x370D, 0),

    LocationName.LexaeusBonus:                                 WorldLocationData(0x370C, 1),
    LocationName.LexaeusASStrengthBeyondStrength:              WorldLocationData(0x370C, 1),
    LocationName.LexaeusDataLostIllusion:                      WorldLocationData(0x370C, 1),  #
    LocationName.MarluxiaGetBonus:                             WorldLocationData(0x370C, 3),
    LocationName.MarluxiaASEternalBlossom:                     WorldLocationData(0x370C, 3),
    LocationName.MarluxiaDataLostIllusion:                     WorldLocationData(0x370C, 3),  #
    LocationName.ZexionBonus:                                  WorldLocationData(0x370C, 2),
    LocationName.GoofyZexion:                                  WorldLocationData(0x370C, 2),
    LocationName.ZexionASBookofShadows:                        WorldLocationData(0x370C, 2),
    LocationName.ZexionDataLostIllusion:                       WorldLocationData(0x370C, 2),  #
    LocationName.LarxeneBonus:                                 WorldLocationData(0x370C, 4),
    LocationName.LarxeneASCloakedThunder:                      WorldLocationData(0x370C, 4),
    LocationName.LarxeneDataLostIllusion:                      WorldLocationData(0x370C, 4),  #
    LocationName.VexenBonus:                                   WorldLocationData(0x370C, 0),
    LocationName.VexenASRoadtoDiscovery:                       WorldLocationData(0x370C, 0),
    LocationName.VexenDataLostIllusion:                        WorldLocationData(0x370C, 0),  #
    LocationName.DemyxDataAPBoost:                             WorldLocationData(0x1D26, 5),

    'Lexaeus Bonus: Sora Slot 1':                              WorldLocationData(14092, 1),
    'AS Lexaeus':                                              WorldLocationData(14092, 1),
    'Data Lexaeus':                                            WorldLocationData(14092, 1),
    'Marluxia Bonus: Sora Slot 1':                             WorldLocationData(14092, 3),
    'AS Marluxia':                                             WorldLocationData(14092, 3),
    'Data Marluxia':                                           WorldLocationData(14092, 3),
    'Zexion Bonus: Sora Slot 1':                               WorldLocationData(14092, 2),
    'Zexion Bonus: Goofy Slot 1':                              WorldLocationData(14092, 2),
    'AS Zexion':                                               WorldLocationData(14092, 2),
    'Data Zexion':                                             WorldLocationData(14092, 2),
    'Larxene Bonus: Sora Slot 1':                              WorldLocationData(14092, 4),
    'AS Larxene':                                              WorldLocationData(14092, 4),
    'Data Larxene':                                            WorldLocationData(14092, 4),
    'Vexen Bonus: Sora Slot 1':                                WorldLocationData(14092, 0),
    'AS Vexen':                                                WorldLocationData(14092, 0),
    'Data Vexen':                                              WorldLocationData(14092, 0),
    'Data Demyx':                                              WorldLocationData(7462, 5),

    LocationName.GardenofAssemblageMap:                        WorldLocationData(0x23DF, 1),
    LocationName.GoALostIllusion:                              WorldLocationData(0x23DF, 2),
    LocationName.ProofofNonexistence:                          WorldLocationData(0x23DF, 3),
    # given when you talk to the computer
    LocationName.KingdomKeySlot:                               WorldLocationData(0x1D27, 3),
    LocationName.MagesStaff:                                   WorldLocationData(0x1D27, 3),
    LocationName.KnightsShield:                                WorldLocationData(0x1D27, 3),
    LocationName.DonaldStarting1:                              WorldLocationData(0x1D27, 3),
    LocationName.DonaldStarting2:                              WorldLocationData(0x1D27, 3),
    LocationName.GoofyStarting1:                               WorldLocationData(0x1D27, 3),
    LocationName.GoofyStarting2:                               WorldLocationData(0x1D27, 3),
    LocationName.Crit_1:                                       WorldLocationData(0x1D27, 3),
    LocationName.Crit_2:                                       WorldLocationData(0x1D27, 3),
    LocationName.Crit_3:                                       WorldLocationData(0x1D27, 3),
    LocationName.Crit_4:                                       WorldLocationData(0x1D27, 3),
    LocationName.Crit_5:                                       WorldLocationData(0x1D27, 3),
    LocationName.Crit_6:                                       WorldLocationData(0x1D27, 3),
    LocationName.Crit_7:                                       WorldLocationData(0x1D27, 3),

}
PL_Checks = {
    LocationName.GorgeSavannahMap:              WorldLocationData(0x23D9, 4),
    LocationName.GorgeDarkGem:                  WorldLocationData(0x23CF, 0),
    LocationName.GorgeMythrilStone:             WorldLocationData(0x23CF, 1),
    LocationName.ElephantGraveyardFrostGem:     WorldLocationData(0x23CE, 5),
    LocationName.ElephantGraveyardMythrilStone: WorldLocationData(0x23CE, 6),
    LocationName.ElephantGraveyardBrightStone:  WorldLocationData(0x23CE, 7),
    LocationName.ElephantGraveyardAPBoost:      WorldLocationData(0x23DB, 3),
    LocationName.ElephantGraveyardMythrilShard: WorldLocationData(0x23DB, 4),
    LocationName.PrideRockMap:                  WorldLocationData(0x23D0, 3),
    LocationName.PrideRockMythrilStone:         WorldLocationData(0x23CD, 4),
    LocationName.PrideRockSerenityCrystal:      WorldLocationData(0x23CD, 5),
    LocationName.WildebeestValleyEnergyStone:   WorldLocationData(0x23CE, 0),
    LocationName.WildebeestValleyAPBoost:       WorldLocationData(0x23CE, 1),
    LocationName.WildebeestValleyMythrilGem:    WorldLocationData(0x23CE, 2),
    LocationName.WildebeestValleyMythrilStone:  WorldLocationData(0x23CE, 3),
    LocationName.WildebeestValleyLucidGem:      WorldLocationData(0x23CE, 4),
    LocationName.WastelandsMythrilShard:        WorldLocationData(0x23CF, 2),
    LocationName.WastelandsSerenityGem:         WorldLocationData(0x23CF, 3),
    LocationName.WastelandsMythrilStone:        WorldLocationData(0x23CF, 4),
    LocationName.JungleSerenityGem:             WorldLocationData(0x23CF, 5),
    LocationName.JungleMythrilStone:            WorldLocationData(0x23CF, 6),
    LocationName.JungleSerenityCrystal:         WorldLocationData(0x23CF, 7),
    LocationName.OasisMap:                      WorldLocationData(0x23D0, 0),
    LocationName.OasisTornPages:                WorldLocationData(0x23D9, 5),
    LocationName.OasisAPBoost:                  WorldLocationData(0x23D0, 1),
    LocationName.CircleofLife:                  WorldLocationData(0x1DD2, 1),
    LocationName.Hyenas1:                       WorldLocationData(0x370A, 1),
    LocationName.GoofyHyenas1:                  WorldLocationData(0x370A, 1),
    LocationName.Scar:                          WorldLocationData(0x3707, 5),
    LocationName.DonaldScar:                    WorldLocationData(0x3707, 5),
    LocationName.ScarFireElement:               WorldLocationData(0x1DD4, 7),
    LocationName.Hyenas2:                       WorldLocationData(0x370A, 2),
    LocationName.GoofyHyenas2:                  WorldLocationData(0x370A, 2),
    LocationName.Groundshaker:                  WorldLocationData(0x3707, 6),
    LocationName.GroundshakerGetBonus:          WorldLocationData(0x3707, 6),

}
TT_Checks = {
    LocationName.TwilightTownMap:                       WorldLocationData(0x1CD6, 3),
    LocationName.MunnyPouchOlette:                      WorldLocationData(0x1CD6, 5),
    LocationName.StationDusks:                          WorldLocationData(0x370A, 6),
    LocationName.StationofSerenityPotion:               WorldLocationData(0x23CA, 1),
    LocationName.StationofCallingPotion:                WorldLocationData(0x23D7, 1),
    LocationName.TwilightThorn:                         WorldLocationData(0x3708, 1),
    LocationName.Axel1:                                 WorldLocationData(0x370D, 1),
    LocationName.JunkChampionBelt:                      WorldLocationData(0x1CDC, 2),
    LocationName.JunkMedal:                             WorldLocationData(0x1CDC, 2),
    LocationName.TheStruggleTrophy:                     WorldLocationData(0x1CDC, 2),
    LocationName.CentralStationPotion1:                 WorldLocationData(0x23D1, 5),
    LocationName.STTCentralStationHiPotion:             WorldLocationData(0x23D1, 6),
    LocationName.CentralStationPotion2:                 WorldLocationData(0x23D1, 7),
    LocationName.SunsetTerraceAbilityRing:              WorldLocationData(0x23D2, 3),
    LocationName.SunsetTerraceHiPotion:                 WorldLocationData(0x23D2, 4),
    LocationName.SunsetTerracePotion1:                  WorldLocationData(0x23D2, 5),
    LocationName.SunsetTerracePotion2:                  WorldLocationData(0x23D2, 6),
    LocationName.MansionFoyerHiPotion:                  WorldLocationData(0x23D4, 2),
    LocationName.MansionFoyerPotion1:                   WorldLocationData(0x23D4, 3),
    LocationName.MansionFoyerPotion2:                   WorldLocationData(0x23D4, 4),
    LocationName.MansionDiningRoomElvenBandanna:        WorldLocationData(0x23D5, 0),
    LocationName.MansionDiningRoomPotion:               WorldLocationData(0x23D5, 1),
    LocationName.NaminesSketches:                       WorldLocationData(0x1CE0, 6),
    LocationName.MansionMap:                            WorldLocationData(0x1CE0, 6),
    LocationName.MansionLibraryHiPotion:                WorldLocationData(0x23D5, 4),
    LocationName.Axel2:                                 WorldLocationData(0x3708, 2),
    LocationName.MansionBasementCorridorHiPotion:       WorldLocationData(0x23D6, 0),
    # stt and tt share the same world id
    LocationName.OldMansionPotion:                      WorldLocationData(0x23D4, 0),
    LocationName.OldMansionMythrilShard:                WorldLocationData(0x23D4, 1),
    LocationName.TheWoodsPotion:                        WorldLocationData(0x23D3, 3),
    LocationName.TheWoodsMythrilShard:                  WorldLocationData(0x23D3, 4),
    LocationName.TheWoodsHiPotion:                      WorldLocationData(0x23D3, 5),
    LocationName.TramCommonHiPotion:                    WorldLocationData(0x23D0, 5),
    LocationName.TramCommonAPBoost:                     WorldLocationData(0x23D0, 6),
    LocationName.TramCommonTent:                        WorldLocationData(0x23D0, 7),
    LocationName.TramCommonMythrilShard1:               WorldLocationData(0x23D1, 0),
    LocationName.TramCommonPotion1:                     WorldLocationData(0x23D1, 1),
    LocationName.TramCommonMythrilShard2:               WorldLocationData(0x23D1, 2),
    LocationName.TramCommonPotion2:                     WorldLocationData(0x23D8, 5),
    LocationName.StationPlazaSecretAnsemReport2:        WorldLocationData(0x1CE3, 3),
    LocationName.MunnyPouchMickey:                      WorldLocationData(0x1CE3, 3),
    LocationName.CrystalOrb:                            WorldLocationData(0x1CE3, 3),
    LocationName.CentralStationTent:                    WorldLocationData(0x23D2, 0),
    LocationName.TTCentralStationHiPotion:              WorldLocationData(0x23D2, 1),
    LocationName.CentralStationMythrilShard:            WorldLocationData(0x23D2, 2),
    LocationName.TheTowerPotion:                        WorldLocationData(0x23D6, 2),
    LocationName.TheTowerHiPotion:                      WorldLocationData(0x23D6, 3),
    LocationName.TheTowerEther:                         WorldLocationData(0x23DB, 7),
    LocationName.TowerEntrywayEther:                    WorldLocationData(0x23D6, 4),
    LocationName.TowerEntrywayMythrilShard:             WorldLocationData(0x23D6, 5),
    LocationName.SorcerersLoftTowerMap:                 WorldLocationData(0x23D6, 6),
    LocationName.TowerWardrobeMythrilStone:             WorldLocationData(0x23D6, 7),
    LocationName.StarSeeker:                            WorldLocationData(0x1CE5, 2),
    LocationName.ValorForm:                             WorldLocationData(0x1CE5, 2),
    LocationName.SeifersTrophy:                         WorldLocationData(0x1CE6, 4),
    LocationName.Oathkeeper:                            WorldLocationData(0x1CE6, 7),
    LocationName.LimitForm:                             WorldLocationData(0x1CE6, 7),
    LocationName.UndergroundConcourseMythrilGem:        WorldLocationData(0x23D8, 0),
    LocationName.UndergroundConcourseAPBoost:           WorldLocationData(0x23D8, 2),
    LocationName.UndergroundConcourseOrichalcum:        WorldLocationData(0x23D8, 1),
    LocationName.UndergroundConcourseMythrilCrystal:    WorldLocationData(0x23D8, 3),
    LocationName.TunnelwayOrichalcum:                   WorldLocationData(0x23D7, 6),
    LocationName.TunnelwayMythrilCrystal:               WorldLocationData(0x23D7, 7),
    LocationName.SunsetTerraceOrichalcumPlus:           WorldLocationData(0x23D2, 7),
    LocationName.SunsetTerraceMythrilShard:             WorldLocationData(0x23D3, 0),
    LocationName.SunsetTerraceMythrilCrystal:           WorldLocationData(0x23D3, 1),
    LocationName.SunsetTerraceAPBoost:                  WorldLocationData(0x23D3, 2),
    LocationName.MansionNobodies:                       WorldLocationData(0x370B, 0),
    LocationName.DonaldMansionNobodies:                 WorldLocationData(0x370B, 0),
    LocationName.MansionFoyerMythrilCrystal:            WorldLocationData(0x23D4, 5),
    LocationName.MansionFoyerMythrilStone:              WorldLocationData(0x23D4, 6),
    LocationName.MansionFoyerSerenityCrystal:           WorldLocationData(0x23D4, 7),
    LocationName.MansionDiningRoomMythrilCrystal:       WorldLocationData(0x23D5, 2),
    LocationName.MansionDiningRoomMythrilStone:         WorldLocationData(0x23D5, 3),
    LocationName.MansionLibraryOrichalcum:              WorldLocationData(0x23D5, 5),
    LocationName.BeamSecretAnsemReport10:               WorldLocationData(0x1CE8, 3),
    LocationName.MansionBasementCorridorUltimateRecipe: WorldLocationData(0x23D6, 1),
    LocationName.BetwixtandBetween:                     WorldLocationData(0x370B, 7),
    LocationName.BetwixtandBetweenBondofFlame:          WorldLocationData(0x1CE9, 1),
    LocationName.AxelDataMagicBoost:                    WorldLocationData(0x1CEB, 4),

    'Data Axel':                                        WorldLocationData(7403, 4),
}
TWTNW_Checks = {
    LocationName.FragmentCrossingMythrilStone:             WorldLocationData(0x23CB, 4),
    LocationName.FragmentCrossingMythrilCrystal:           WorldLocationData(0x23CB, 5),
    LocationName.FragmentCrossingAPBoost:                  WorldLocationData(0x23CB, 6),
    LocationName.FragmentCrossingOrichalcum:               WorldLocationData(0x23CB, 7),
    LocationName.Roxas:                                    WorldLocationData(0x370C, 5),
    LocationName.RoxasGetBonus:                            WorldLocationData(0x370C, 5),
    LocationName.RoxasSecretAnsemReport8:                  WorldLocationData(0x1ED1, 1),
    LocationName.TwoBecomeOne:                             WorldLocationData(0x1ED1, 1),
    LocationName.MemorysSkyscaperMythrilCrystal:           WorldLocationData(0x23CD, 3),
    LocationName.MemorysSkyscaperAPBoost:                  WorldLocationData(0x23DC, 0),
    LocationName.MemorysSkyscaperMythrilStone:             WorldLocationData(0x23DC, 1),
    LocationName.TheBrinkofDespairDarkCityMap:             WorldLocationData(0x23CA, 5),
    LocationName.TheBrinkofDespairOrichalcumPlus:          WorldLocationData(0x23DA, 2),
    LocationName.NothingsCallMythrilGem:                   WorldLocationData(0x23CC, 0),
    LocationName.NothingsCallOrichalcum:                   WorldLocationData(0x23CC, 1),
    LocationName.TwilightsViewCosmicBelt:                  WorldLocationData(0x23CA, 6),
    LocationName.XigbarBonus:                              WorldLocationData(0x3706, 7),
    LocationName.XigbarSecretAnsemReport3:                 WorldLocationData(0x1ED2, 2),
    LocationName.NaughtsSkywayMythrilGem:                  WorldLocationData(0x23CC, 2),
    LocationName.NaughtsSkywayOrichalcum:                  WorldLocationData(0x23CC, 3),
    LocationName.NaughtsSkywayMythrilCrystal:              WorldLocationData(0x23CC, 4),
    LocationName.Oblivion:                                 WorldLocationData(0x1ED2, 4),
    LocationName.CastleThatNeverWasMap:                    WorldLocationData(0x1ED2, 4),
    LocationName.Luxord:                                   WorldLocationData(0x3707, 0),
    LocationName.LuxordGetBonus:                           WorldLocationData(0x3707, 0),
    LocationName.LuxordSecretAnsemReport9:                 WorldLocationData(0x1ED2, 7),
    LocationName.SaixBonus:                                WorldLocationData(0x3707, 1),
    LocationName.SaixSecretAnsemReport12:                  WorldLocationData(0x1ED3, 2),
    LocationName.PreXemnas1SecretAnsemReport11:            WorldLocationData(0x1ED3, 6),
    LocationName.RuinandCreationsPassageMythrilStone:      WorldLocationData(0x23CC, 7),
    LocationName.RuinandCreationsPassageAPBoost:           WorldLocationData(0x23CD, 0),
    LocationName.RuinandCreationsPassageMythrilCrystal:    WorldLocationData(0x23CD, 1),
    LocationName.RuinandCreationsPassageOrichalcum:        WorldLocationData(0x23CD, 2),
    LocationName.Xemnas1:                                  WorldLocationData(0x3707, 2),
    LocationName.Xemnas1GetBonus:                          WorldLocationData(0x3707, 2),
    LocationName.Xemnas1SecretAnsemReport13:               WorldLocationData(0x1ED4, 5),
    LocationName.FinalXemnas:                              WorldLocationData(0x1ED8, 1),
    LocationName.XemnasDataPowerBoost:                     WorldLocationData(0x1EDA, 2),
    LocationName.XigbarDataDefenseBoost:                   WorldLocationData(0x1ED9, 7),
    LocationName.SaixDataDefenseBoost:                     WorldLocationData(0x1EDA, 0),
    LocationName.LuxordDataAPBoost:                        WorldLocationData(0x1EDA, 1),
    LocationName.RoxasDataMagicBoost:                      WorldLocationData(0x1ED9, 6),

    "(TWTNW) Roxas Bonus: Sora Slot 1":                    WorldLocationData(14092, 5),
    "(TWTNW) Roxas Bonus: Sora Slot 2":                    WorldLocationData(14092, 5),
    "(TWTNW) Roxas Secret Ansem Report 8":                 WorldLocationData(7889, 1),
    "(TWTNW) Two Become One":                              WorldLocationData(7889, 1),
    "(TWTNW) Memory's Skyscaper Mythril Crystal":          WorldLocationData(9165, 3),
    "(TWTNW) Memory's Skyscaper AP Boost":                 WorldLocationData(9180, 0),
    "(TWTNW) Memory's Skyscaper Mythril Stone":            WorldLocationData(9180, 1),
    "(TWTNW) The Brink of Despair Dark City Map":          WorldLocationData(9162, 5),
    "(TWTNW) The Brink of Despair Orichalcum+":            WorldLocationData(9178, 2),
    "(TWTNW) Nothing's Call Mythril Gem":                  WorldLocationData(9164, 0),
    "(TWTNW) Nothing's Call Orichalcum":                   WorldLocationData(9164, 1),
    "(TWTNW) Twilight's View Cosmic Belt":                 WorldLocationData(9162, 6),
    "(TWTNW) Xigbar Bonus: Sora Slot 1":                   WorldLocationData(14086, 7),
    "(TWTNW) Xigbar Secret Ansem Report 3":                WorldLocationData(7890, 2),
    "(TWTNW) Naught's Skyway Mythril Gem":                 WorldLocationData(9164, 2),
    "(TWTNW) Naught's Skyway Orichalcum":                  WorldLocationData(9164, 3),
    "(TWTNW) Naught's Skyway Mythril Crystal":             WorldLocationData(9164, 4),
    "(TWTNW) Oblivion":                                    WorldLocationData(7890, 4),
    "(TWTNW) Castle That Never Was Map":                   WorldLocationData(7890, 4),
    "(TWTNW) Luxord":                                      WorldLocationData(14087, 0),
    "(TWTNW) Luxord Bonus: Sora Slot 1":                   WorldLocationData(14087, 0),
    "(TWTNW) Luxord Secret Ansem Report 9":                WorldLocationData(7890, 7),
    "(TWTNW) Saix Bonus: Sora Slot 1":                     WorldLocationData(14087, 1),
    "(TWTNW) Saix Secret Ansem Report 12":                 WorldLocationData(7891, 2),
    "(TWTNW) Secret Ansem Report 11 (Pre-Xemnas 1)":       WorldLocationData(7891, 6),
    "(TWTNW) Ruin and Creation's Passage Mythril Stone":   WorldLocationData(9164, 7),
    "(TWTNW) Ruin and Creation's Passage AP Boost":        WorldLocationData(9165, 0),
    "(TWTNW) Ruin and Creation's Passage Mythril Crystal": WorldLocationData(9165, 1),
    "(TWTNW) Ruin and Creation's Passage Orichalcum":      WorldLocationData(9165, 2),
    "(TWTNW) Xemnas 1 Bonus: Sora Slot 1":                 WorldLocationData(14087, 2),
    "(TWTNW) Xemnas 1 Bonus: Sora Slot 2":                 WorldLocationData(14087, 2),
    "(TWTNW) Xemnas 1 Secret Ansem Report 13":             WorldLocationData(7892, 5),
    "Data Xemnas":                                         WorldLocationData(7898, 2),
    "Data Xigbar":                                         WorldLocationData(7897, 7),
    "Data Saix":                                           WorldLocationData(7898, 0),
    "Data Luxord":                                         WorldLocationData(7898, 1),
    "Data Roxas":                                          WorldLocationData(7897, 6),

}
Atlantica_Checks = {
    LocationName.UnderseaKingdomMap:     WorldLocationData(0x1DF4, 2),
    LocationName.MysteriousAbyss:        WorldLocationData(0x1DF5, 3),
    LocationName.MusicalOrichalcumPlus:  WorldLocationData(0x1DF4, 1),
    LocationName.MusicalBlizzardElement: WorldLocationData(0x1DF4, 1)
}
SoraLevels = {
    # LocationName.Lvl1:  WorldLocationData(0xFFFF,1),
    LocationName.Lvl2:  WorldLocationData(0xFFFF, 2),
    LocationName.Lvl3:  WorldLocationData(0xFFFF, 3),
    LocationName.Lvl4:  WorldLocationData(0xFFFF, 4),
    LocationName.Lvl5:  WorldLocationData(0xFFFF, 5),
    LocationName.Lvl6:  WorldLocationData(0xFFFF, 6),
    LocationName.Lvl7:  WorldLocationData(0xFFFF, 7),
    LocationName.Lvl8:  WorldLocationData(0xFFFF, 8),
    LocationName.Lvl9:  WorldLocationData(0xFFFF, 9),
    LocationName.Lvl10: WorldLocationData(0xFFFF, 10),
    LocationName.Lvl11: WorldLocationData(0xFFFF, 11),
    LocationName.Lvl12: WorldLocationData(0xFFFF, 12),
    LocationName.Lvl13: WorldLocationData(0xFFFF, 13),
    LocationName.Lvl14: WorldLocationData(0xFFFF, 14),
    LocationName.Lvl15: WorldLocationData(0xFFFF, 15),
    LocationName.Lvl16: WorldLocationData(0xFFFF, 16),
    LocationName.Lvl17: WorldLocationData(0xFFFF, 17),
    LocationName.Lvl18: WorldLocationData(0xFFFF, 18),
    LocationName.Lvl19: WorldLocationData(0xFFFF, 19),
    LocationName.Lvl20: WorldLocationData(0xFFFF, 20),
    LocationName.Lvl21: WorldLocationData(0xFFFF, 21),
    LocationName.Lvl22: WorldLocationData(0xFFFF, 22),
    LocationName.Lvl23: WorldLocationData(0xFFFF, 23),
    LocationName.Lvl24: WorldLocationData(0xFFFF, 24),
    LocationName.Lvl25: WorldLocationData(0xFFFF, 25),
    LocationName.Lvl26: WorldLocationData(0xFFFF, 26),
    LocationName.Lvl27: WorldLocationData(0xFFFF, 27),
    LocationName.Lvl28: WorldLocationData(0xFFFF, 28),
    LocationName.Lvl29: WorldLocationData(0xFFFF, 29),
    LocationName.Lvl30: WorldLocationData(0xFFFF, 30),
    LocationName.Lvl31: WorldLocationData(0xFFFF, 31),
    LocationName.Lvl32: WorldLocationData(0xFFFF, 32),
    LocationName.Lvl33: WorldLocationData(0xFFFF, 33),
    LocationName.Lvl34: WorldLocationData(0xFFFF, 34),
    LocationName.Lvl35: WorldLocationData(0xFFFF, 35),
    LocationName.Lvl36: WorldLocationData(0xFFFF, 36),
    LocationName.Lvl37: WorldLocationData(0xFFFF, 37),
    LocationName.Lvl38: WorldLocationData(0xFFFF, 38),
    LocationName.Lvl39: WorldLocationData(0xFFFF, 39),
    LocationName.Lvl40: WorldLocationData(0xFFFF, 40),
    LocationName.Lvl41: WorldLocationData(0xFFFF, 41),
    LocationName.Lvl42: WorldLocationData(0xFFFF, 42),
    LocationName.Lvl43: WorldLocationData(0xFFFF, 43),
    LocationName.Lvl44: WorldLocationData(0xFFFF, 44),
    LocationName.Lvl45: WorldLocationData(0xFFFF, 45),
    LocationName.Lvl46: WorldLocationData(0xFFFF, 46),
    LocationName.Lvl47: WorldLocationData(0xFFFF, 47),
    LocationName.Lvl48: WorldLocationData(0xFFFF, 48),
    LocationName.Lvl49: WorldLocationData(0xFFFF, 49),
    LocationName.Lvl50: WorldLocationData(0xFFFF, 50),
    LocationName.Lvl51: WorldLocationData(0xFFFF, 51),
    LocationName.Lvl52: WorldLocationData(0xFFFF, 52),
    LocationName.Lvl53: WorldLocationData(0xFFFF, 53),
    LocationName.Lvl54: WorldLocationData(0xFFFF, 54),
    LocationName.Lvl55: WorldLocationData(0xFFFF, 55),
    LocationName.Lvl56: WorldLocationData(0xFFFF, 56),
    LocationName.Lvl57: WorldLocationData(0xFFFF, 57),
    LocationName.Lvl58: WorldLocationData(0xFFFF, 58),
    LocationName.Lvl59: WorldLocationData(0xFFFF, 59),
    LocationName.Lvl60: WorldLocationData(0xFFFF, 60),
    LocationName.Lvl61: WorldLocationData(0xFFFF, 61),
    LocationName.Lvl62: WorldLocationData(0xFFFF, 62),
    LocationName.Lvl63: WorldLocationData(0xFFFF, 63),
    LocationName.Lvl64: WorldLocationData(0xFFFF, 64),
    LocationName.Lvl65: WorldLocationData(0xFFFF, 65),
    LocationName.Lvl66: WorldLocationData(0xFFFF, 66),
    LocationName.Lvl67: WorldLocationData(0xFFFF, 67),
    LocationName.Lvl68: WorldLocationData(0xFFFF, 68),
    LocationName.Lvl69: WorldLocationData(0xFFFF, 69),
    LocationName.Lvl70: WorldLocationData(0xFFFF, 70),
    LocationName.Lvl71: WorldLocationData(0xFFFF, 71),
    LocationName.Lvl72: WorldLocationData(0xFFFF, 72),
    LocationName.Lvl73: WorldLocationData(0xFFFF, 73),
    LocationName.Lvl74: WorldLocationData(0xFFFF, 74),
    LocationName.Lvl75: WorldLocationData(0xFFFF, 75),
    LocationName.Lvl76: WorldLocationData(0xFFFF, 76),
    LocationName.Lvl77: WorldLocationData(0xFFFF, 77),
    LocationName.Lvl78: WorldLocationData(0xFFFF, 78),
    LocationName.Lvl79: WorldLocationData(0xFFFF, 79),
    LocationName.Lvl80: WorldLocationData(0xFFFF, 80),
    LocationName.Lvl81: WorldLocationData(0xFFFF, 81),
    LocationName.Lvl82: WorldLocationData(0xFFFF, 82),
    LocationName.Lvl83: WorldLocationData(0xFFFF, 83),
    LocationName.Lvl84: WorldLocationData(0xFFFF, 84),
    LocationName.Lvl85: WorldLocationData(0xFFFF, 85),
    LocationName.Lvl86: WorldLocationData(0xFFFF, 86),
    LocationName.Lvl87: WorldLocationData(0xFFFF, 87),
    LocationName.Lvl88: WorldLocationData(0xFFFF, 88),
    LocationName.Lvl89: WorldLocationData(0xFFFF, 89),
    LocationName.Lvl90: WorldLocationData(0xFFFF, 90),
    LocationName.Lvl91: WorldLocationData(0xFFFF, 91),
    LocationName.Lvl92: WorldLocationData(0xFFFF, 92),
    LocationName.Lvl93: WorldLocationData(0xFFFF, 93),
    LocationName.Lvl94: WorldLocationData(0xFFFF, 94),
    LocationName.Lvl95: WorldLocationData(0xFFFF, 95),
    LocationName.Lvl96: WorldLocationData(0xFFFF, 96),
    LocationName.Lvl97: WorldLocationData(0xFFFF, 97),
    LocationName.Lvl98: WorldLocationData(0xFFFF, 98),
    LocationName.Lvl99: WorldLocationData(0xFFFF, 99),
}

ValorLevels = {
    # LocationName.Valorlvl1:  WorldLocationData(0x32F6, 1),
    LocationName.Valorlvl2: WorldLocationData(0x32F6, 2),
    LocationName.Valorlvl3: WorldLocationData(0x32F6, 3),
    LocationName.Valorlvl4: WorldLocationData(0x32F6, 4),
    LocationName.Valorlvl5: WorldLocationData(0x32F6, 5),
    LocationName.Valorlvl6: WorldLocationData(0x32F6, 6),
    LocationName.Valorlvl7: WorldLocationData(0x32F6, 7),
}

WisdomLevels = {
    # LocationName.Wisdomlvl1: WorldLocationData(0x332E, 1),
    LocationName.Wisdomlvl2: WorldLocationData(0x332E, 2),
    LocationName.Wisdomlvl3: WorldLocationData(0x332E, 3),
    LocationName.Wisdomlvl4: WorldLocationData(0x332E, 4),
    LocationName.Wisdomlvl5: WorldLocationData(0x332E, 5),
    LocationName.Wisdomlvl6: WorldLocationData(0x332E, 6),
    LocationName.Wisdomlvl7: WorldLocationData(0x332E, 7),
}

LimitLevels = {
    # LocationName.Limitlvl1:  WorldLocationData(0x3366, 1),
    LocationName.Limitlvl2: WorldLocationData(0x3366, 2),
    LocationName.Limitlvl3: WorldLocationData(0x3366, 3),
    LocationName.Limitlvl4: WorldLocationData(0x3366, 4),
    LocationName.Limitlvl5: WorldLocationData(0x3366, 5),
    LocationName.Limitlvl6: WorldLocationData(0x3366, 6),
    LocationName.Limitlvl7: WorldLocationData(0x3366, 7),
}
MasterLevels = {
    # LocationName.Masterlvl1: WorldLocationData(0x339E, 1),
    LocationName.Masterlvl2: WorldLocationData(0x339E, 2),
    LocationName.Masterlvl3: WorldLocationData(0x339E, 3),
    LocationName.Masterlvl4: WorldLocationData(0x339E, 4),
    LocationName.Masterlvl5: WorldLocationData(0x339E, 5),
    LocationName.Masterlvl6: WorldLocationData(0x339E, 6),
    LocationName.Masterlvl7: WorldLocationData(0x339E, 7),
}
FinalLevels = {
    # LocationName.Finallvl1:  WorldLocationData(0x33D6,1),
    LocationName.Finallvl2: WorldLocationData(0x33D6, 2),
    LocationName.Finallvl3: WorldLocationData(0x33D6, 3),
    LocationName.Finallvl4: WorldLocationData(0x33D6, 4),
    LocationName.Finallvl5: WorldLocationData(0x33D6, 5),
    LocationName.Finallvl6: WorldLocationData(0x33D6, 6),
    LocationName.Finallvl7: WorldLocationData(0x33D6, 7),

}
SummonLevels = {
    LocationName.Summonlvl2: WorldLocationData(0x3526, 2),
    LocationName.Summonlvl3: WorldLocationData(0x3526, 3),
    LocationName.Summonlvl4: WorldLocationData(0x3526, 4),
    LocationName.Summonlvl5: WorldLocationData(0x3526, 5),
    LocationName.Summonlvl6: WorldLocationData(0x3526, 6),
    LocationName.Summonlvl7: WorldLocationData(0x3526, 7),

}
weaponSlots = {
    LocationName.AdamantShield:       WorldLocationData(0x35E6, 1),
    LocationName.AkashicRecord:       WorldLocationData(0x35ED, 1),
    LocationName.ChainGear:           WorldLocationData(0x35E7, 1),
    LocationName.DreamCloud:          WorldLocationData(0x35EA, 1),
    LocationName.FallingStar:         WorldLocationData(0x35E9, 1),
    LocationName.FrozenPride2:        WorldLocationData(0x36A2, 1),
    LocationName.GenjiShield:         WorldLocationData(0x35EC, 1),
    LocationName.KnightDefender:      WorldLocationData(0x35EB, 1),
    LocationName.MajesticMushroom:    WorldLocationData(0x36A5, 1),
    LocationName.MajesticMushroom2:   WorldLocationData(0x36A6, 1),
    LocationName.NobodyGuard:         WorldLocationData(0x35EE, 1),
    LocationName.OgreShield:          WorldLocationData(0x35E8, 1),
    LocationName.SaveTheKing2:        WorldLocationData(0x3693, 1),
    LocationName.UltimateMushroom:    WorldLocationData(0x36A7, 1),

    LocationName.CometStaff:          WorldLocationData(0x35F2, 1),
    LocationName.HammerStaff:         WorldLocationData(0x35EF, 1),
    LocationName.LordsBroom:          WorldLocationData(0x35F3, 1),
    LocationName.MeteorStaff:         WorldLocationData(0x35F1, 1),
    LocationName.NobodyLance:         WorldLocationData(0x35F6, 1),
    LocationName.PreciousMushroom:    WorldLocationData(0x369E, 1),
    LocationName.PreciousMushroom2:   WorldLocationData(0x369F, 1),
    LocationName.PremiumMushroom:     WorldLocationData(0x36A0, 1),
    LocationName.RisingDragon:        WorldLocationData(0x35F5, 1),
    LocationName.SaveTheQueen2:       WorldLocationData(0x3692, 1),
    LocationName.ShamansRelic:        WorldLocationData(0x35F7, 1),
    LocationName.VictoryBell:         WorldLocationData(0x35F0, 1),
    LocationName.WisdomWand:          WorldLocationData(0x35F4, 1),
    LocationName.Centurion2:          WorldLocationData(0x369B, 1),

    LocationName.OathkeeperSlot:      WorldLocationData(0x35A2, 1),
    LocationName.OblivionSlot:        WorldLocationData(0x35A3, 1),
    LocationName.StarSeekerSlot:      WorldLocationData(0x367B, 1),
    LocationName.HiddenDragonSlot:    WorldLocationData(0x367C, 1),
    LocationName.HerosCrestSlot:      WorldLocationData(0x367F, 1),
    LocationName.MonochromeSlot:      WorldLocationData(0x3680, 1),
    LocationName.FollowtheWindSlot:   WorldLocationData(0x3681, 1),
    LocationName.CircleofLifeSlot:    WorldLocationData(0x3682, 1),
    LocationName.PhotonDebuggerSlot:  WorldLocationData(0x3683, 1),
    LocationName.GullWingSlot:        WorldLocationData(0x3684, 1),
    LocationName.RumblingRoseSlot:    WorldLocationData(0x3685, 1),
    LocationName.GuardianSoulSlot:    WorldLocationData(0x3686, 1),
    LocationName.WishingLampSlot:     WorldLocationData(0x3687, 1),
    LocationName.DecisivePumpkinSlot: WorldLocationData(0x3688, 1),
    LocationName.SleepingLionSlot:    WorldLocationData(0x3689, 1),
    LocationName.SweetMemoriesSlot:   WorldLocationData(0x368A, 1),
    LocationName.MysteriousAbyssSlot: WorldLocationData(0x368B, 1),
    LocationName.TwoBecomeOneSlot:    WorldLocationData(0x3698, 1),
    LocationName.FatalCrestSlot:      WorldLocationData(0x368C, 1),
    LocationName.BondofFlameSlot:     WorldLocationData(0x368D, 1),
    LocationName.FenrirSlot:          WorldLocationData(0x368E, 1),
    LocationName.UltimaWeaponSlot:    WorldLocationData(0x368F, 1),
    LocationName.WinnersProofSlot:    WorldLocationData(0x3699, 1),
    LocationName.PurebloodSlot:       WorldLocationData(0x35BF, 1),
}

formSlots = {
    LocationName.FAKESlot:           WorldLocationData(0x36C0, 1),
    LocationName.DetectionSaberSlot: WorldLocationData(0x36C0, 6),
    LocationName.EdgeofUltimaSlot:   WorldLocationData(0x36C0, 4),
}

tornPageLocks = {
    "TornPage1": WorldLocationData(0x1DB7, 4),  # --Scenario_1_start
    "TornPage2": WorldLocationData(0x1DB7, 7),  # --Scenario_2_start
    "TornPage3": WorldLocationData(0x1DB8, 2),  # --Scenario_3_start
    "TornPage4": WorldLocationData(0x1DB8, 4),  # --Scenario_4_start
    "TornPage5": WorldLocationData(0x1DB8, 7),  # --Scenario_5_start
}
# (Room,Event) : Boss event
# Used for deathlink to say Sora died at : (Room,Event) which returns like Old pete
DeathLinkPair = {
    (2, 34, 157): "Twilight Thorn",
    (2, 5, 88):   "Setzer",
    (2, 20, 137): "Axel",
    (2, 4, 80):   "Sandlot",
    (2, 41, 186): "Mansion fight",
    (2, 40, 161): "Betwixt and Between",
    (2, 20, 213): "Data Axel",
    (4, 8, 52):   "Bailey",
    (4, 20, 86):  "Corridor",
    (4, 18, 73):  "Dancers",
    (4, 4, 55):   "HB Demyx",
    (4, 16, 65):  "FF Cloud",
    (4, 17, 66):  "1k Heartless",
    (4, 1, 75):   "Sephiroth",
    (4, 4, 114):  "Data Demyx",
    (5, 11, 72):  "Thresholder",
    (5, 3, 69):   "Beast",
    (5, 5, 79):   "Dark Thorn",
    (5, 4, 74):   "Dragoons",
    (5, 15, 82):  "Xaldin",
    (5, 15, 97):  "Data Xaldin",
    (6, 7, 114):  "Cerberus",
    (6, 17, 123): "OC Demyx",
    (6, 8, 116):  "OC Pete",
    (6, 18, 171): "Hydra",
    (6, 6, 126):  "Auron Statue fight",
    (6, 19, 202): "Hades",
    (4, 34, 151): "Zexion", # all as fights are in hb "world"
    (7, 9, 2):    "Abu",
    (7, 13, 79):  "Chasm fight",
    (7, 10, 58):  "Treasure Room",
    (7, 3, 59):   "Lords",
    (7, 14, 100): "Carpet",
    (7, 5, 62):   "Genie Jafar",
    (4, 33, 142): "Lexaeus",
    (8, 5, 72):   "Cave",
    (8, 7, 73):   "Summit",
    (8, 9, 75):   "Shan Yu",
    (8, 10, 78):  "Antechamber fight",
    (8, 8, 79):   "Storm Rider",
    (10,14, 55):  "Scar",
    (10,15, 59):  "Groundshaker",
    (11,2, 63):   "Tutorial",
    (11,9, 65):   "Ursula's Revenge",
    (11,4, 55):   "A New Day is Dawning",
    (12,1, 53):   "Library (DC)",
    (12,0, 51):   "Minnie Escort",
    (13,1, 58):   "Old Pete",
    (13,2, 52):   "Boat Pete",
    (13,3, 53):   "DC Pete",
    (4, 38, 145): "Marluxia",
    (12,7, 67):   "Lingering Will",
    (14,6, 53):   "Candy Cane Lane fight",
    (14,3, 52):   "Prison Keeper",
    (14,9, 55):   "Oogie Boogie",
    (14,10, 63):  "Presents minigame",
    (14,7, 64):   "Experiment",
    (4, 32, 115): "Vexen",
    (16,2, 55):   "Town",
    (16,10, 60):  "Barbossa",
    (16,14, 62):  "Gambler",
    (16,1, 54):   "Grim Reaper",
    (17,3, 54):   "Screens",
    (17,4, 55):   "Hostile Program",
    (17,7, 57):   "Solar Sailer",
    (17,9, 59):   "MCP",
    (4, 33, 143): "Larxene",
    (18,21, 65):  "Roxas",
    (18,10, 57):  "Xigbar",
    (18,14, 58):  "Luxord",
    (18,15, 56):  "Saix",
    (18,19, 59):  "Xemnas 1",
    (18,20, 98):  "Data Xemnas",
    (18,21, 99):  "Data Roxas",
    (18,10, 100): "Data Xigbar",
    (18,15, 102): "Data Saix",
    (18,14, 101): "Data Luxord",
}
all_world_locations = {
    **TWTNW_Checks,
    **TT_Checks,
    **HB_Checks,
    **BC_Checks,
    **Oc_Checks,
    **AG_Checks,
    **LoD_Checks,
    **HundredAcreChecks,
    **PL_Checks,
    **DC_Checks,
    **TR_Checks,
    **HT_Checks,
    **PR_Checks,
    **SP_Checks,
    **Atlantica_Checks,
}

levels_locations = {
    **SoraLevels,
    **ValorLevels,
    **WisdomLevels,
    **LimitLevels,
    **MasterLevels,
    **FinalLevels,
}
