SKYLOFT_REQUIREMENTS = {
    "Upper Skyloft": {
        "hint_region": "Upper Skyloft",
        "exits": {
            "Knight Academy": "Nothing",
            "Zelda's Room": "Clawshots",
            "Stairs to Central Skyloft": "Nothing",
            "Loftwing Platforms": "Nothing",
        },
        "locations": {
            "Owlan's Gift": "Nothing",
            "Sparring Hall Chest": "Nothing",
            "Ring Knight Academy Bell": "Distance Activator | Gust Bellows",
            "Chest near Goddess Statue": "Nothing",
            "First Goddess Sword Item in Goddess Statue": "Nothing",
            "Second Goddess Sword Item in Goddess Statue": "Nothing",
            "Pumpkin Archery -- 600 Points": "Has Bow",

            # Single crystals
            "Crystal in Sparring Hall": "Has Beetle",
        },
    },
    "Upper Skyloft - Knight Academy": {
        "hint_region": "Upper Skyloft",
        "exits": {
            "Upper Skyloft": "Nothing",
        },
        "locations": {
            "Fledge's Gift": "Nothing",
            "Owlan's Crystals": "Can Retrieve Oolo",
            "Fledge's Crystals": "Has Bottle & Unlocked Endurance Potion",
            "Item from Cawlin": "Goddess's Harp",
            "Ghost/Pipit's Crystals": "Cawlin's Letter",

            # Single crystals
            "Crystal in Link's Room": "Nothing",
            "Crystal in Knight Academy Plant": "Nothing",
        },
    },
    "Upper Skyloft - Zelda's Room": {
        "hint_region": "Upper Skyloft",
        "exits": {
            "Knight Academy": "Nothing",
        },
        "locations": {
            "In Zelda's Closet": "Nothing",

            # Single crystals
            "Crystal in Zelda's Room": "Nothing",
        },
    },
    "Central Skyloft": {
        "hint_region": "Central Skyloft",
        "macros": {
            "Can Ring Beedle's Bell": "Distance Activator",
        },
        "exits": {
            "Stairs to Upper Skyloft": "Nothing",
            "Bridge to Skyloft Village": "Nothing",
            "Ring Beedle's Bell": "Can Ring Beedle's Bell",
            "Loftwing Platforms": "Nothing",
            "Dungeon Entrance on Skyloft": "Stone of Trials & Clawshots",
            "Trial Gate on Skyloft": "Goddess's Harp & Has Song of the Hero",
        },
        "locations": {
            "Potion Lady's Gift": "Nothing",
            "Repair Gondo's Junk": "Can Farm Ancient Flowers",
            "Wryna's Crystals": "Nothing",
            "Waterfall Cave First Chest": "Can Cut Trees",
            "Waterfall Cave Second Chest": "Can Cut Trees",
            "Rupee Waterfall Cave Crawlspace": "Can Cut Trees",
            "Parrow's Gift": "Can Visit Orielle",
            "Parrow's Crystals": "Can Save Orielle",
            "Peater/Peatrice's Crystals": "Nothing",
            "Item in Bird Nest": "Clawshots & Gust Bellows",
            "Shed Chest": "Water Dragon's Scale",
            "West Cliff Goddess Chest": "Goddess Cube on West Great Tree near Exit",
            "Bazaar Goddess Chest": "Goddess Cube in Ancient Harbor",
            "Shed Goddess Chest": "Goddess Cube on Sand Slide & Water Dragon's Scale",
            "Floating Island Goddess Chest": "Goddess Cube in Lake Floria & Clawshots",
            "Waterfall Goddess Chest": "Goddess Cube in Pirate Stronghold & Clawshots",

            # Single crystals
            "Crystal in Orielle and Parrow's House": "Nothing",
            "Crystal on West Cliff": "Nothing",
            "Crystal between Wooden Planks": "Nothing",
            "Crystal after Waterfall Cave": "Can Cut Trees | Has Beetle",
            "Crystal in Loftwing Prison": "Can Cut Trees | Has Beetle",
            "Crystal on Waterfall Island": "Clawshots | Has Quick Beetle",
            "Crystal on Light Tower": "Nothing",
        },
    },
    "Skyloft Village": {
        "hint_region": "Skyloft Village",
        "macros": {
            "Can Sell Treasures": "Nothing",
        },
        "exits": {
            "Bridge to Central Skyloft": "Nothing",
            "Shed Door to Batreaux's House": "Nothing",
            "Loftwing Platforms": "Nothing",
        },
        "locations": {
            "Mallara's Crystals": "Gust Bellows",
            "Bertie's Crystals": "Baby Rattle",
            "Sparrot's Crystals": "Can Retrieve Crystal Ball",

            # Single crystals
            "Crystal near Pumpkin Patch": "Nothing",
        },
    },
    "Batreaux's House": {
        "hint_region": "Batreaux's House",
        "exits": {
            "Exit Shed Door": "Nothing",
        },
        "locations": {
            # These are internal names for these checks, they will be changed during generation
            # Logic will also be changed during generation
            "First Reward": "Impossible",
            "Second Reward": "Impossible",
            "Third Reward": "Impossible",
            "Chest": "Impossible",
            "Fourth Reward": "Impossible",
            "Fifth Reward": "Impossible",
            "Sixth Reward": "Impossible",
            "Seventh Reward": "Impossible",
            "Final Reward": "Impossible",
        },
    },
    "Beedle's Shop": {
        "hint_region": "Beedle's Shop",
        "exits": {
            "Leave Shop": "Nothing",
        },
        "locations": {
            "300 Rupee Item": (
                "Can Afford 300 Rupees "
                "& (Has Pouch | option_shopsanity)"
            ),
            "600 Rupee Item": (
                "Can Afford 600 Rupees "
                "& (Has Pouch | option_shopsanity)"
            ),
            "1200 Rupee Item": (
                "Can Afford 1200 Rupees "
                "& (Has Pouch | option_shopsanity)"
            ),
            "800 Rupee Item": "Can Afford 800 Rupees",
            "1600 Rupee Item": "Can Afford 1600 Rupees",
            "First 100 Rupee Item": "Nothing",
            "Second 100 Rupee Item": "Nothing",
            "Third 100 Rupee Item": "Can Medium Rupee Farm",
            "50 Rupee Item": "Nothing",
            "1000 Rupee Item": "Can Afford 1000 Rupees",
        },
    },
    "Skyloft Silent Realm": {
        "hint_region": "Skyloft Silent Realm",
        "exits": {
            "Trial Gate": "Nothing",
        },
        "locations": {
            "Trial Reward": "Nothing",
            "Relic 1": "Nothing",
            "Relic 2": "Nothing",
            "Relic 3": "Nothing",
            "Relic 4": "Nothing",
            "Relic 5": "Nothing",
            "Relic 6": "Nothing",
            "Relic 7": "Nothing",
            "Relic 8": "Nothing",
            "Relic 9": "Nothing",
            "Relic 10": "Nothing",
        },
    },
}
