region_text = {
    "Northern Onett": "Onett",
    "Onett": "Onett",
    "Giant Step": "Giant Step",
    "Twoson": "Twoson",
    "Peaceful Rest Valley": "Peaceful Rest Valley",
    "Happy-Happy Village": "Happy-Happy Village",
    "Lilliput Steps": "Lilliput Steps",
    "Threed": "Threed",
    "Belch's Factory": "Belch's factory",
    "Saturn Valley": "Saturn Valley",
    "Upper Saturn Valley": "Saturn Valley",
    "Milky Well": "Milky Well",
    "Dusty Dunes Desert": "the Dusty Dunes Desert",
    "Gold Mine": "the gold mine",
    "Monkey Caves": "the monkey caves",
    "Fourside": "Fourside",
    "Magnet Hill": "Fourside's sewers",
    "Monotoli Building": "the Monotoli Building",
    "Winters": "Winters",
    "Snow Wood Boarding School": "the Snow Wood Boarding School",
    "Southern Winters": "Winters",
    "Rainy Circle": "Rainy Circle",
    "Stonehenge Base": "Stonehenge",
    "Summers": "Summers",
    "Dalaam": "Dalaam",
    "Pink Cloud": "Pink Cloud",
    "Scaraba": "Scaraba",
    "Pyramid": "the Pyramid",
    "Southern Scaraba": "Scaraba",
    "Dungeon Man": "Dungeon Man",
    "Deep Darkness": "the Deep Darkness",
    "Tenda Village": "Tenda Village",
    "Lumine Hall": "Lumine Hall",
    "Lost Underworld": "the Lost Underworld",
    "Fire Spring": "Fire Spring",
    "Magicant": "Magicant",
    "Cave of the Present": "Cave of the Past",
    "Cave of the Past": "Cave of the Past"
}

barf_text = {
    "Paula": [0xE0, 0xC2, 0xEE, 0xBD, 0xC3, 0xEE],
    "Jeff": [0xFA, 0xC2, 0xEE, 0x10, 0xC4, 0xEE],
    "Poo": [0x1A, 0x74, 0xEF, 0x3E, 0xC4, 0xEE],
    "Flying Man": [0x17, 0xC3, 0xEE, 0x95, 0xC4, 0xEE],
    "Ness": [0x16, 0x07, 0xF3, 0x2B, 0x07, 0xF3],
    "Photograph": [0x2F, 0x99, 0xC9, 0x2F, 0x99, 0xC9]
}

eb_text_table = {" ": ([0x50]), "!": ([0x51]), '"': ([0x52]), "■": ([0x53]), "$": ([0x54]), "%": ([0x55]),
                 "°": ([0x56]), "'": ([0x57]), "(": ([0x58]), ")": ([0x59]), "*": ([0x5A]), "+": ([0x5B]),
                 ",": ([0x5C]), "-": ([0x5D]), ".": ([0x5E]), "/": ([0x5F]), "0": ([0x60]), "1": ([0x61]),
                 "2": ([0x62]), "3": ([0x63]), "4": ([0x64]), "5": ([0x65]), "6": ([0x66]), "7": ([0x67]),
                 "8": ([0x68]), "9": ([0x69]), ":": ([0x6A]), ";": ([0x6B]), "“": ([0x6C]), "=": ([0x6D]),
                 "”": ([0x6E]), "?": ([0x6F]), "@": ([0x70]), "A": ([0x71]), "B": ([0x72]), "C": ([0x73]),
                 "D": ([0x74]), "E": ([0x75]), "F": ([0x76]), "G": ([0x77]), "H": ([0x78]), "I": ([0x79]),
                 "J": ([0x7A]), "K": ([0x7B]), "L": ([0x7C]), "M": ([0x7D]), "N": ([0x7E]), "O": ([0x7F]),
                 "P": ([0x80]), "Q": ([0x81]), "R": ([0x82]), "S": ([0x83]), "T": ([0x84]), "U": ([0x85]),
                 "V": ([0x86]), "W": ([0x87]), "X": ([0x88]), "Y": ([0x89]), "Z": ([0x8A]), "α": ([0x8B]),
                 "β": ([0x8C]), "γ": ([0x8D]), "Σ": ([0x8E]), "Ω": ([0x8F]), "a": ([0x91]), "b": ([0x92]),
                 "c": ([0x93]), "d": ([0x94]), "e": ([0x95]), "f": ([0x96]), "g": ([0x97]), "h": ([0x98]),
                 "i": ([0x99]), "j": ([0x9A]), "k": ([0x9B]), "l": ([0x9C]), "m": ([0x9D]), "n": ([0x9E]),
                 "o": ([0x9F]), "p": ([0xA0]), "q": ([0xA1]), "r": ([0xA2]), "s": ([0xA3]), "t": ([0xA4]),
                 "u": ([0xA5]), "v": ([0xA6]), "w": ([0xA7]), "x": ([0xA8]), "y": ([0xA9]), "z": ([0xAA]),
                 "[": ([0xAB]), "♪": ([0xAC]), "]": ([0xAD]), "~": ([0xAE]), "◯": ([0xAF]), "_": ([0xB0]),
                 "<": ([0xB1]), " ": ([0x90]), "&": ([0xB6]), "#": ([0xB7]), "\n": ([0x03, 0x00]), "ñ": ([0xB9]),
                 "ä": ([0xBA]), "é": ([0xBB])}
# 0x90 is a half-width space

pixel_width_table = {" ": 2, "!": 2, '"': 3, "■": 2, "$": 5, "%": 9,
                     "°": 7, "'": 2, "(": 3, ")": 3, "*": 3, "+": 5,
                     ",": 2, "-": 2, ".": 2, "/": 4, "0": 5, "1": 5,
                     "2": 5, "3": 5, "4": 5, "5": 5, "6": 5, "7": 5,
                     "8": 5, "9": 5, ":": 2, ";": 3, "“": 3, "=": 5,
                     "”": 3, "?": 4, "@": 5, "A": 6, "B": 5, "C": 5,
                     "D": 5, "E": 4, "F": 4, "G": 5, "H": 5, "I": 1,
                     "J": 4, "K": 5, "L": 4, "M": 7, "N": 5, "O": 5,
                     "P": 5, "Q": 5, "R": 5, "S": 5, "T": 5, "U": 5,
                     "V": 6, "W": 7, "X": 5, "Y": 5, "Z": 4, "α": 5,
                     "β": 4, "γ": 6, "Σ": 4, "Ω": 5, "a": 4, "b": 4,
                     "c": 4, "d": 4, "e": 4, "f": 3, "g": 4, "h": 4,
                     "i": 1, "j": 2, "k": 4, "l": 1, "m": 7, "n": 4,
                     "o": 4, "p": 4, "q": 4, "r": 3, "s": 4, "t": 3,
                     "u": 4, "v": 5, "w": 7, "x": 4, "y": 4, "z": 4,
                     "[": 2, "♪": 5, "]": 2, "~": 6, "◯": 7, "_": 5,
                     "<": 4, " ": 1, "&": 6, "#": 6, "ñ": 6, "ä": 5,
                     "é": 5}


lumine_hall_text = [
    "You paid 350 bucks for this seed",
    "You could be playing Mario is Missing!",
    "youtu.be/dQw4w9WgXcQ",
    "Please help I am in BK mode",
    "But anyways, its not about the glitch, its not about that its a video game, its because you don't care about how this is affecting other people, your heartless, you can apparently live with yourself with this.",
    "Do you still remember your pin? It's the price of a cheese pizza and and a large soda back where I used to work; Panucci's Pizza.",
    "Did you remember to clear your sphere 1?",
    "You should use a tracker, personally I recommend Poptracker",
    "You should try Mario Is Missing AP, its fun and funny.",
    "Despite everything, you're still you.",
    "Bababooey",
    "Reticulating Splines",
    "You only have one shot.",
    "human.. i remember you're genocides.",
    '"May your woes be many, and your days few."',
    "For you, the day Pokey graced your village was the most important day of your life. But for me, it was Tuesday.",
    "To shreds you say?",
    "Hey player, I'm in BK, can you get my item at Starman Super Drop Sword of Kings?  It's my go mode.",
    "Why did you make me do this? You're fighting so you can watch everyone around you die! Think, Player Name! You'll outlast every fragile, insignificant being on this planet.",
    "Is this thing on?  Testing.  Oh hey, its me, Tony!  Is Jeff doing okay?  I worry about him a lot, and he's like, on my mind a lot.  Maybe stop by Winters sometime!  Pretty please?",
    "If you have your club card, please scan it now.",
    "Come on Reggie, give us MOTHER 3!",
    "Growing up, Man I spent hours of my life stomping................................................................................................................................................ Koopas.",
    "We've been trying to reach you about your car's extended warranty...",
    "YOU MUST CONSTRUCT ADDITIONAL PYLONS!!!",
    "It all start on the day the Happy Happyists attacked...",
    "You just lost the game.",
    "ERROR 404: HALL TEXT NOT FOUND.",
    "Long ago, two races ruled over Earth: HUMANS and MONSTERS. One day, war broke out between the two races. After a long battle, the humans were victorious. They sealed the monsters underground with a magic spell.",
    "Once upon a time, a LEGEND was whispered among shadows. It was a LEGEND of HOPE. It was a LEGEND of DREAMS. It was a LEGEND of LIGHT. It was a LEGEND of DARK.",
    "OwO? What's This?",
    "What about now it's time to rock with the Bickedy Buck Buzz Buzz! What about now it's time to rock with the Bickedy Buck Buzz Buzz! Bum to the bum to the bum to the bass to the bum to the boom to the Buzz Buzz!",
    "HOW ARE YOU GENTLEMEN !! ALL YOUR BASE ARE BELONG TO US.",
    "You're just the delivery boy. Sorry, your parts over now. Here, go play hero with this.",
    "My friends are my power, and I'm theirs!",
    "Did somebody mention the Door to Darkness?",
    "We hope you'll be a great asset to the company. Great asset to the company. Asset-Great-Great-Asset to the Company.",
    "So thanks, goat-bunny-cat lady.",
    "It's dangerous to go alone, take this!",
    "The rabbit virus got so happy that it exploded!!",
    "Steve tried to swim in lava.",
    "The flow of time is always cruel... its speed seems different for each person, but no one can change it... A thing that does not change with time is a memory of younger days...",
    "Hah! You better have BURN HEAL!",
    "..and so she left, heart still racing.",
    "I've found you faker! Faker? I think you're the fake hedgehog around here. In fact, you're not even good enough be my fake. I'll make you eat those words!",
    "Don't ask about Mother 3 AP.",
    "Hello. This is Punk-Sure. I've been trying to reach you about your bicycle's extended warranty.",
    "Who's that kid with blue hair whose name sounds like evil? Who suspiciously showed up to say we'd die like wretches? Surely HE'S not the bad guy, right? Nah, not when he has such a cool violin. Perish the thought!",
    "I wonder if xfisjmg1 is going to release another Ninten Speaks video anytime soon?",
    "weedle",
    "hi",
    "Look Ma, I'm in Lumine Hall!",
    "Did you check Aginah?",
    "Eat at Joe's",
    "FOR A GOOD TIME, CALL 555-...",
    "!hint Moon Pearl",
    "'); DROP TABLE Lumine Hall Text;--",
    "No, no! We can't! This baby is a demon child!",
    "Rhydon Earthquake vs. Mr. Mime: 169-199 (59.7 - 70.3%) -- guaranteed 2HKO",
    "Dakota",
    "Ness, I am your father.",
    "Hello, it's your dad. You've been out there for a long time now... It may be none of my business, but don't you think it would be a good idea if you took a break?",
    "RIP AND TEAR",
    "Sorry Ness, Pokey died of ligma",
    "A horrible chill goes down your spine...",
    "You feel an evil presence watching you...",
    "Going to BK, BRB.",
    "My favorite Mr. Saturn... It... cute... lovely... smart... plus... amazing... you think so? Hug it... when... sleeping... warm and cuddly... spectacular... ravishing... Oops! Look at the time! I kept you too long!",
    "THE CLUMSY ROBOT IN NAME ONLY, FOR IT IS NEITHER.",
    "The Arcana is the means by which all is revealed.",
    "Say the password!                                                                                                                                                                                  ",
    "Hello?  Is there anybody in there?  Just nod if you can hear me.  Is there anyone home?",
    "I bought my sneakers from a drug dealer in Fourside.  I don't know what they were laced with but I've been tripping all day.",
    "Sans Is Ness",
    "Your Goal This Game: Join Happy Happyism",
    "There's only junk items that way.",
    "GET OUT WHILE YOU STILL CAN",
    "Why isn't my SNI connecting?",
    "It's 10 p.m.  Do you know where your kids are?",
    "If they censored what the adults were drinking to coffee, then what did Mr. Saturn give Ness originally?",
    "Fourside Frappuccino.  Work can wait.",
    "Let's do an Archibald seed !",
    "WARNING! Scheduled Maintenance in 4 Minutes...",
    "I'm still stuck in BK",
    "John Madden! John Madden! John Madden! John Madden! John Madden! John Madden! John Madden! ",
    "Did you know that by reading this message you are wasting time not getting checks?",
    "Your text here! Check the game's design thread on the Archipelago Server for how to submit!",
    "WITNESS JOKE HERE",
    "Also try The Witness!",
    "Also try Adventure!",
    "Also try DOOM 1993!",
    "Also try Super Mario World!",
    "Also try Yoshi's Island!",
    "Also try Castlevania 64!",
    "Hi Mom! I'm on AP!",
    "Looking for hot multiworlds in your area?",
    "Paleontologists do it in the dirt.",
    "Wait... something seems off...   Things seem more random than usual...",
    "Shoutouts to SimpleFlips.",
    "How long have you been BK?",
    "Also try PK Scramble!",
    "Also try Ancient Cave!",
    "I am playing this on AP version 1.0 and it is amazing.",
    "WHAT A HORRIBLE NIGHT TO HAVE A CURSE.",
    "It's so jover",
    "The National Weather Service has issued a severe thunderstorm warning for the following areas, starting at 7:49 PM Eastern Daylight Time and ending at 7:49 PM Eastern Daylight Time.",
    "Where is everyone? I've done most of my checks and I still can't find my friends, it's so lonely here.",
    "Can you hurry up and go to Ness's Nightmare it has my Morph Ball for my Super Metroid seed Thanks in advance Berserker",
    "gottem",
    "Dear Ness,      please come to the house. I've baked a steak for you.       Yours truly,       mom.",
    "Phar why",
    "Tell Figment to check POD!",
    "Congratulations, you're the Lumine Hall's 100th visitor! Click here for $2 off your next order at the Onett Burger Shop!",
    "Well, that's never happened before...",
    "99 bottles of DXWater on the wall, 99 bottles of DXWater. Take one down, pass it around, 98 bottles of DXWater on the wall!",
    "After all these years. Finally, I have them all.",
    "If there were two guys on the moon and one killed the other with a rock would that be screwed up or what",
    "Help, I'm trapped in a Lumine Hall factory!",
    "They say that Ice Palace can be found at Ice Palace...",
    "Hey Mom, I'm in AP!",
    "It says “gullible” on the wall",
    "64 bits! 32 bits! 16 bits! 8 bits! 4 bits! 2 bits! 1 bit! Half bit! Quarter bit! THE WRIST GAME!!!",
    "Where did YOU learn to teleport?",
    "My statistics show about 70% of kids these days don't stop to read bulletin boards anymore. Well, I had to shell out a lot of money for this, but let's see you ignore THIS one, suckers!          ...Brick Road",
    "I'm Ness... I could go for a burger right about now... That girl from Twoson sure is cute... I wonder if I should ask her out on a date... W...wha...? What's...? H-HEY! These thoughts are PRIVATE!",
    "Chris, when is Parasite Eve in AP?",
    "Praise the Fool!"
]

spoiler_psi = {
    "Special": "PSI Rockin",
    "Fire": "PSI Fire",
    "Freeze": "PSI Freeze",
    "Thunder": "PSI Thunder",
    "Flash": "PSI Flash",
    "Starstorm": "PSI Starstorm",
    "Shield": "Shield",
    "PSI Shield": "PSI Shield",
    "Offense Up": "Offense up",
    "Defense Down": "Defense down",
    "Hypnosis": "Hypnosis",
    "Paralysis": "Paralysis",
    "Brainshock": "Brainshock",
    "Blast": "PSI Blast",
    "Missile": "PSI Missile",
    "Stop": "Stop",
    "Drain": "Drain",
    "Defense up": "Defense up",
    "Neutralize": "Neutralize",
    "Disable": "Disable"
}

spoiler_starts = [
    "Ness's House",
    "Onett Downtown",
    "Twoson",
    "Happy-Happy Village",
    "Threed",
    "Saturn Valley",
    "Fourside",
    "Winters",
    "Summers",
    "Dalaam",
    "Scaraba",
    "Deep Darkness",
    "Tenda Village",
    "Lost Underworld",
    "Magicant"
]

spoiler_badges = {
    "special": "Rockin",
    "fire": "Fire",
    "freeze": "Freeze",
    "flash": "Flash",
    "starstorm": "Starstorm",
    "explosive": "Bomb",
    "thunder": "Thunder",
}


def text_encoder(text, textcap) -> bytearray:
    """Return an encoded bytearray of in-game text from a string. Unknown characters will be replaced with a ?.
       textcap is the maximum allowed length of the text."""
    encoded_text = bytearray()
    for char in text[:textcap]:
        if char in eb_text_table:
            encoded_text.extend(eb_text_table[char])
        else:
            encoded_text.extend([0x6F])
    return encoded_text


def calc_pixel_width(text) -> int:
    """Return the in-game width of a string. EarthBound uses a VWF, and some text strings
       need to be shortened to fit within in-game menus."""
    width = 0
    for char in text:
        if char in pixel_width_table:
            width += pixel_width_table[char]
        else:
            width += 4
        width += 1
    width -= 1
    return width
