location_ids = {
    "Onett - Tracy Gift": 0xEB0000,
    "Onett - Tracy's Room Present": 0xEB0001,
    "Onett - Hilltop Present": 0xEB0002,
    "Onett - Meteor Item": 0xEB0003,
    "Onett - Buzz Buzz": 0xEB0004,
    "Onett - Mani Mani Statue": 0xEB0005,
    "Onett - Library Counter": 0xEB0006,
    "Onett - Library Bookshelf": 0xEB0007,
    "Onett - Burger Shop Trashcan": 0xEB0008,
    "Onett - Treehouse Guy": 0xEB0009,
    "Onett - South Road Present": 0xEB000A,
    "Onett - Hotel Trashcan": 0xEB000B,
    "Onett - Arcade Trashcan": 0xEB000C,
    "Onett - Mayor Pirkle": 0xEB000D,
    "Onett - Traveling Entertainer": 0xEB000E,
    "Giant Step - First Cave Present": 0xEB000F,
    "Giant Step - Floor 2 Cave Present": 0xEB0010,
    "Giant Step - Floor 3 Present": 0xEB0011,
    "Twoson - Bike Shop Rental": 0xEB0012,
    "Twoson - Antique Shop": 0xEB0013,
    "Twoson - Paula's Room Present": 0xEB0014,
    "Twoson - Apple Kid Trashcan": 0xEB0015,
    "Twoson - South of Town Present": 0xEB0016,
    "Twoson - Orange Kid Donation": 0xEB0017,
    "Twoson - Apple Kid Invention": 0xEB0018,
    "Twoson - Apple Kid's Mouse": 0xEB0019,
    "Twoson - Paula's Mother": 0xEB001A,
    "Twoson - Everdred Meeting": 0xEB001B,
    "Twoson - Insignificant Location": 0xEB001C,
    "Peaceful Rest Valley - Split Hill Present": 0xEB001D,
    "Peaceful Rest Valley - Hill Nook Present": 0xEB001E,
    "Peaceful Rest Valley - South of Bridge Present": 0xEB001F,
    "Peaceful Rest Valley - Dead End Present": 0xEB0020,
    "Peaceful Rest Valley - River Overlook Present": 0xEB0021,
    "Peaceful Rest Valley - North Side Present": 0xEB0022,
    "Happy-Happy Village - Donation Lady": 0xEB0023,
    "Happy-Happy Village - Right HQ Present": 0xEB0024,
    "Happy-Happy Village - Left HQ Present": 0xEB0025,
    "Happy-Happy Village - Prisoner Item": 0xEB0026,
    "Happy-Happy Village - Prisoner": 0xEB0027,
    "Happy-Happy Village - Defeat Carpainter": 0xEB0028,
    "Lilliput Steps - Southwest Pool Present": 0xEB0029,
    "Lilliput Steps - East Cliff Present": 0xEB002A,
    "Lilliput Steps - North Stream Present": 0xEB002B,
    "Threed - Boogey Tent Trashcan": 0xEB002C,
    "Threed - Cemetery Trashcan": 0xEB002D,
    "Threed - Downtown Trashcan": 0xEB002E,
    "Threed - East Side Trashcan": 0xEB002F,
    "Threed - Northeast Shack Trashcan": 0xEB0030,
    "Threed - Hospital Drawer": 0xEB0031,
    "Threed - Zombie Prisoner": 0xEB0032,
    "Threed Underground - Left Coffin": 0xEB0033,
    "Threed Underground - Right Coffin": 0xEB0034,
    "Grapefruit Falls - South Present": 0xEB0035,
    "Grapefruit Falls - North Present": 0xEB0036,
    "Grapefruit Falls - Saturn Cave Present": 0xEB0037,
    "Saturn Valley - Ladder Present": 0xEB0038,
    "Saturn Valley - Trashcan #1": 0xEB0039,
    "Saturn Valley - Trashcan #2": 0xEB003A,
    "Saturn Valley - Trashcan #3": 0xEB003B,
    "Saturn Valley - Saturn Coffee": 0xEB003C,
    "Saturn Valley - Post Belch Gift #1": 0xEB003D,
    "Saturn Valley - Post Belch Gift #2": 0xEB003E,
    "Saturn Valley - Post Belch Gift #3": 0xEB003F,
    "Milky Well - Cavern Present": 0xEB0040,
    "Belch's Factory - Top Right Room Trashcan": 0xEB0041,
    "Belch's Factory - Pit Room Trashcan #1": 0xEB0042,
    "Belch's Factory - Pit Room Trashcan #2": 0xEB0043,
    "Belch's Factory - Balcony Room Trashcan #1": 0xEB0044,
    "Belch's Factory - Balcony Room Trashcan #2": 0xEB0045,
    "Belch's Factory - Balcony Room Trashcan #3": 0xEB0046,
    "Dusty Dunes - Northwest Corner Present": 0xEB0047,
    "Dusty Dunes - South Side Present": 0xEB0048,
    "Dusty Dunes - Surrounding Rocks Present": 0xEB0049,
    "Dusty Dunes - Black Sesame Present": 0xEB004A,
    "Dusty Dunes - Oasis Present": 0xEB004B,
    "Dusty Dunes - Northeast Corner Present": 0xEB004C,
    "Dusty Dunes - North Central Present": 0xEB004D,
    "Dusty Dunes - Shining Spot": 0xEB004E,
    "Dusty Dunes - East Peninsula Present": 0xEB004F,
    "Dusty Dunes - Mine Reward": 0xEB0050,
    "Snow Wood - Many Present Room Present #1": 0xEB0051,
    "Snow Wood - Many Present Room Present #2": 0xEB0052,
    "Snow Wood - Many Present Room Present #3": 0xEB0053,
    "Snow Wood - Many Present Room Present #4": 0xEB0054,
    "Snow Wood - Many Present Room Present #5": 0xEB0055,
    "Snow Wood - Many Present Room Present #6": 0xEB0056,
    "Snow Wood - Many Present Room Present #7": 0xEB0057,
    "Scaraba - Snake Bag Salesman": 0xEB0058,
    "Snow Wood - Upper Right Locker": 0xEB0059,
    "Snow Wood - Upper Left Locker": 0xEB005A,
    "Snow Wood - Bottom Right Locker": 0xEB005B,
    "Snow Wood - Bottom Left Locker": 0xEB005C,
    "Snow Wood - Maxwell Item": 0xEB005D,
    "Snow Wood - Bedroom": 0xEB005E,
    "Winters - Drugstore Saleswoman": 0xEB005F,
    "Brick Road Maze - Top Path Present": 0xEB0060,
    "Brick Road Maze - Guarded Present": 0xEB0061,
    "Brick Road Maze - Out of the Way Present": 0xEB0062,
    "Brick Road Maze - Alcove Present": 0xEB0063,
    "Brick Road Maze - Near Exit Present": 0xEB0064,
    "Rainy Circle - Isolated Present": 0xEB0065,
    "Rainy Circle - East Cliff Present": 0xEB0066,
    "Rainy Circle - Near Ropes Present": 0xEB0067,
    "Andonuts Lab - Present": 0xEB0068,
    "Andonuts Lab - Mouse": 0xEB0069,
    "Stonehenge - Purple Maze Present": 0xEB006A,
    "Stonehenge - Dead End Present": 0xEB006B,
    "Stonehenge - Near End of the Maze Present": 0xEB006C,
    "Stonehenge - Bridge Room East Balcony Present": 0xEB006D,
    "Stonehenge - Bridge Room Lower Present": 0xEB006E,
    "Stonehenge - Flashing Room Right Path Present": 0xEB006F,
    "Stonehenge - Flashing Room Center Present": 0xEB0070,
    "Stonehenge - Flashing Room Upper Present": 0xEB0071,
    "Stonehenge - Kidnapped Mr. Saturn": 0xEB0072,
    "Stonehenge - Tony Item": 0xEB0073,
    "Gold Mine - Mouse Crossroad Present #1": 0xEB0074,
    "Gold Mine - Mouse Crossroad Present #2": 0xEB0075,
    "Gold Mine - B1F Lonely Mole Present": 0xEB0076,
    "Gold Mine - South Hall Present": 0xEB0077,
    "Gold Mine - South Corner Present": 0xEB0078,
    "Gold Mine - South Mole Present #1": 0xEB0079,
    "Gold Mine - South Mole Present #2": 0xEB007A,
    "Gold Mine - North Crossroad Detour Present": 0xEB007B,
    "Gold Mine - North Mole Present": 0xEB007C,
    "Gold Mine - West Mole Present": 0xEB007D,
    "Gold Mine - B1F Isolated Present": 0xEB007E,
    "Gold Mine - West Crossroad Detour Present": 0xEB007F,
    "Gold Mine - B1F Junction Present": 0xEB0080,
    "Gold Mine - B1F Junction Mole Present": 0xEB0081,
    "Monkey Caves - 1F Right Chest": 0xEB00F1,
    "Monkey Caves - 1F Left Chest": 0xEB00F2,
    "Monkey Caves - West 2F Left Chest": 0xEB00F3,
    "Monkey Caves - West 2F Right Chest #1": 0xEB00F4,
    "Monkey Caves - West 2F Right Chest #2": 0xEB00F5,
    "Monkey Caves - East 2F Left Chest": 0xEB00F6,
    "Monkey Caves - East 2F Right Chest": 0xEB00F7,
    "Monkey Caves - East West 3F Right Chest #1": 0xEB00F8,
    "Monkey Caves - East West 3F Right Chest #2": 0xEB00F9,
    "Monkey Caves - West End Chest": 0xEB0082,
    "Monkey Caves - West End Trashcan": 0xEB0083,
    "Monkey Caves - East End Chest": 0xEB0084,
    "Monkey Caves - East End Trashcan": 0xEB0085,
    "Monkey Caves - Bow Monkey Gift": 0xEB0086,
    "Monkey Caves - Talah Rama Chest #1": 0xEB0087,
    "Monkey Caves - Talah Rama Chest #2": 0xEB0088,
    "Monkey Caves - Talah Rama Gift": 0xEB0089,
    "Monkey Caves - Monkey Power": 0xEB008A,
    "Fourside - Venus Gift": 0xEB008B,
    "Fourside - Post-Moonside Delivery": 0xEB008C,
    "Fourside - Bakery 2F Gift": 0xEB008D,
    "Moonside - Two Trees Present": 0xEB008E,
    "Moonside - East Island Present": 0xEB008F,
    "Moonside - Businessman Present": 0xEB0090,
    "Moonside - West Island Present": 0xEB0091,
    "Moonside - Hospital Present": 0xEB0092,
    "Fourside - Department Store Blackout": 0xEB0093,
    "Magnet Hill - West Entrance Trashcan": 0xEB0094,
    "Magnet Hill - First Room Free Door Trashcan": 0xEB0095,
    "Magnet Hill - First Room Barrel Door Trashcan": 0xEB0096,
    "Magnet Hill - Second Room Dead End Trashcan": 0xEB0097,
    "Magnet Hill - Final Room Door Trashcan": 0xEB0098,
    "Fourside - Magnet Hill Chest": 0xEB0099,
    "Monotoli Building - One Table Present": 0xEB009A,
    "Monotoli Building - Two Table Present": 0xEB009B,
    "Monotoli Building - Electra Gift": 0xEB009C,
    "Monotoli Building - Monotoli Gift": 0xEB009D,
    "Monotoli Building - Monotoli Character": 0xEB009E,
    "Summers - Museum Item": 0xEB009F,
    "Summers - Magic Cake": 0xEB00A0,
    "Dalaam - Throne Room Chest #1": 0xEB00A1,
    "Dalaam - Throne Room Chest #2": 0xEB00A2,
    "Dalaam - Throne Room Chest #3": 0xEB00A3,
    "Dalaam - Trial of Mu": 0xEB00A4,
    "Dalaam - Restaurant Chest #1": 0xEB00A5,
    "Dalaam - Restaurant Chest #2": 0xEB00A6,
    "Dalaam - Do Do Guy's House Chest": 0xEB00A7,
    "Dalaam - Upper House Chest": 0xEB00A8,
    "Dalaam - Throne Character": 0xEB00A9,
    "Poo - Starting Item": 0xEB00AA,
    "Pink Cloud - Three Holes Present": 0xEB00AB,
    "Pink Cloud - Left Hole Present": 0xEB00AC,
    "Pink Cloud - Ground Floor Present": 0xEB00AD,
    "Pyramid - Anteroom Sarcophagus": 0xEB00AE,
    "Pyramid - Northwest Door Sarcophagus": 0xEB00AF,
    "Pyramid - Hallway Sarcophagus #1": 0xEB00B0,
    "Pyramid - Hallway Sarcophagus #2": 0xEB00B1,
    "Pyramid - Switch Room Sarcophagus": 0xEB00B2,
    "Pyramid - Pedestal Item": 0xEB00B3,
    "Pyramid - Way Out Sarcophagus": 0xEB00B4,
    "Scaraba - Star Master": 0xEB00B5,
    "Scaraba - Key Holder": 0xEB00B6,
    "Dungeon Man - 1F Dead End Present": 0xEB00B7,
    "Dungeon Man - 1F Long Walk Present": 0xEB00B8,
    "Dungeon Man - 1F Disappointing Present": 0xEB00B9,
    "Dungeon Man - 1F Opinion Present": 0xEB00BA,
    "Dungeon Man - 1F No Sign Present": 0xEB00BB,
    "Dungeon Man - 2F Unnecessary Billboard Present": 0xEB00BC,
    "Dungeon Man - 2F Dungeon Exploration Present": 0xEB00BD,
    "Dungeon Man - 2F South Ledge Present": 0xEB00BE,
    "Dungeon Man - 2F North Alcove Present": 0xEB00BF,
    "Dungeon Man - 3F Present": 0xEB00C0,
    "Dungeon Man - 2F Hole Present": 0xEB00C1,
    "Dungeon Man - 1F Exit Ledge Present": 0xEB00C2,
    "Deep Darkness - Teleporting Monkey": 0xEB00C3,
    "Deep Darkness - Crest of Darkness Present": 0xEB00C4,
    "Deep Darkness - Helicopter Present": 0xEB00C5,
    "Deep Darkness - Yellow Bird Present": 0xEB00C6,
    "Deep Darkness - Swamp Present": 0xEB00C7,
    "Deep Darkness - Corner Present": 0xEB00C8,
    "Deep Darkness - Alcove Present": 0xEB00C9,
    "Deep Darkness - North Alcove Truffle": 0xEB00CA,
    "Deep Darkness - Near Land Truffle": 0xEB00CB,
    "Deep Darkness - Present Truffle": 0xEB00CC,
    "Deep Darkness - Village Truffle": 0xEB00CD,
    "Deep Darkness - Entrance Truffle": 0xEB00CE,
    "Deep Darkness - Barf Character": 0xEB00CF,
    "Tenda Village - Trashcan": 0xEB00D0,
    "Tenda Village - Tenda Tea": 0xEB00D1,
    "Tenda Village - Tenda Gift": 0xEB00D2,
    "Tenda Village - Tenda Gift #2": 0xEB00D3,
    "Lumine Hall - B1F Non-Talkative Rock Present": 0xEB00D4,
    "Lumine Hall - 1F North Path Present": 0xEB00D5,
    "Lumine Hall - B1F Thankful Rock Corner Present": 0xEB00D6,
    "Lumine Hall - B1F Thankful Rock Junction Present": 0xEB00D7,
    "Lumine Hall - 1F Above Belly Button Present": 0xEB00D8,
    "Lumine Hall - B1F Belly Button Present": 0xEB00D9,
    "Lumine Hall - 1F Near Exit Present": 0xEB00DA,
    "Lumine Hall - 1F Dead End Present": 0xEB00DB,
    "Lumine Hall - B1F West Alcove Present": 0xEB00DC,
    "Lost Underworld - Talking Rock": 0xEB00DD,
    "Lost Underworld - East Present": 0xEB00DE,
    "Lost Underworld - Northeast Present": 0xEB00DF,
    "Lost Underworld - Northeast of Tenda Tribe Present": 0xEB00E0,
    "Lost Underworld - Southwest of Tenda Tribe Present": 0xEB00E1,
    "Lost Underworld - Evacuation Present": 0xEB00E2,
    "Fire Spring - 1st Cave Present": 0xEB00E3,
    "Fire Spring - East Corner Present": 0xEB00E4,
    "Fire Spring - Volcano Present": 0xEB00E5,
    "Fire Spring - Lone Cave Present": 0xEB00E6,
    "Fire Spring - Upper Volcano Present": 0xEB00E7,
    "Magicant - Ness's Gift": 0xEB00E8,
    "Magicant - Present Near Ness": 0xEB00E9,
    "Magicant - Lonely Present": 0xEB00EA,
    "Magicant - North Present": 0xEB00EB,
    "Magicant - Hills Present": 0xEB00EC,
    "Magicant - Town Present": 0xEB00FA,
    "Magicant - Ness's Nightmare": 0xEB00ED,
    "Cave of the Present - Star Master": 0xEB00EE,
    "Cave of the Present - Broken Phase Distorter": 0xEB00EF,
    "Cave of the Past - Present": 0xEB00F0,
    ##########################################
    # Shop checks are denoted by an ID of
    # 0x1000 | Each shop has 7 allocated ID spaces in memory
    "Onett Drugstore - Right Counter Slot 1": 0xEB1000,
    "Onett Drugstore - Right Counter Slot 2": 0xEB1001,
    "Onett Drugstore - Right Counter Slot 3": 0xEB1002,
    "Onett Drugstore - Right Counter Slot 4": 0xEB1003,
    "Onett Drugstore - Right Counter Slot 5": 0xEB1004,

    "Onett Drugstore - Left Counter": 0xEB1007,

    "Summers - Beach Cart": 0xEB100E,

    "Onett Burger Shop - Slot 1": 0xEB1015,
    "Onett Burger Shop - Slot 2": 0xEB1016,
    "Onett Burger Shop - Slot 3": 0xEB1017,
    "Onett Burger Shop - Slot 4": 0xEB1018,

    "Onett Bakery - Slot 1": 0xEB101C,
    "Onett Bakery - Slot 2": 0xEB101D,
    "Onett Bakery - Slot 3": 0xEB101E,
    "Onett Bakery - Slot 4": 0xEB101F,

    "Twoson Department Store Burger Shop - Slot 1": 0xEB1023,
    "Twoson Department Store Burger Shop - Slot 2": 0xEB1024,
    "Twoson Department Store Burger Shop - Slot 3": 0xEB1025,
    "Twoson Department Store Burger Shop - Slot 4": 0xEB1026,

    "Twoson Department Store Bakery - Slot 1": 0xEB102A,  # Force This slot needs to always be a local food item
    "Twoson Department Store Bakery - Slot 2": 0xEB102B,
    "Twoson Department Store Bakery - Slot 3": 0xEB102C,
    "Twoson Department Store Bakery - Slot 4": 0xEB102D,

    "Twoson Department Store Top Floor - Right Counter Slot 1": 0xEB1031,
    "Twoson Department Store Top Floor - Right Counter Slot 2": 0xEB1032,
    "Twoson Department Store Top Floor - Right Counter Slot 3": 0xEB1033,
    "Twoson Department Store Top Floor - Right Counter Slot 4": 0xEB1034,
    "Twoson Department Store Top Floor - Right Counter Slot 5": 0xEB1035,
    "Twoson Department Store Top Floor - Right Counter Slot 6": 0xEB1036,

    "Twoson Department Store Top Floor - Left Counter Slot 1": 0xEB1038,
    "Twoson Department Store Top Floor - Left Counter Slot 2": 0xEB1039,

    "Summers - Magic Cake Cart Shop Slot": 0xEB103F,

    "Burglin Park Junk Shop - Slot 1": 0xEB1046,
    "Burglin Park Junk Shop - Slot 2": 0xEB1047,
    "Burglin Park Junk Shop - Slot 3": 0xEB1048,
    "Burglin Park Junk Shop - Slot 4": 0xEB1049,
    "Burglin Park Junk Shop - Slot 5": 0xEB104A,
    "Burglin Park Junk Shop - Slot 6": 0xEB104B,

    "Burglin Park Bread Stand - Slot 1": 0xEB105B,
    "Burglin Park Bread Stand - Slot 2": 0xEB105C,
    "Burglin Park Bread Stand - Slot 3": 0xEB105D,
    "Burglin Park Bread Stand - Slot 4": 0xEB105E,
    "Burglin Park Bread Stand - Slot 5": 0xEB105F,
    "Burglin Park Bread Stand - Slot 6": 0xEB1060,

    "Burglin Park - Banana Stand": 0xEB1062,

    "Happy-Happy Village Drugstore - Right Counter Slot 1": 0xEB1069,
    "Happy-Happy Village Drugstore - Right Counter Slot 2": 0xEB106A,
    "Happy-Happy Village Drugstore - Right Counter Slot 3": 0xEB106B,
    "Happy-Happy Village Drugstore - Right Counter Slot 4": 0xEB106C,
    "Happy-Happy Village Drugstore - Right Counter Slot 5": 0xEB106D,

    "Threed Drugstore - Right Counter Slot 1": 0xEB1070,
    "Threed Drugstore - Right Counter Slot 2": 0xEB1071,
    "Threed Drugstore - Right Counter Slot 3": 0xEB1072,
    "Threed Drugstore - Right Counter Slot 4": 0xEB1073,
    "Threed Drugstore - Right Counter Slot 5": 0xEB1074,

    "Threed Drugstore - Left Counter Slot 1": 0xEB1077,
    "Threed Drugstore - Left Counter Slot 2": 0xEB1078,
    "Threed Drugstore - Left Counter Slot 3": 0xEB1079,
    "Threed Drugstore - Left Counter Slot 4": 0xEB107A,
    "Threed Drugstore - Left Counter Slot 5": 0xEB107B,

    "Threed - Arms Dealer Slot 1": 0xEB107E,
    "Threed - Arms Dealer Slot 2": 0xEB107F,
    "Threed - Arms Dealer Slot 3": 0xEB1080,
    "Threed - Arms Dealer Slot 4": 0xEB1081,

    "Threed Bakery - Slot 1": 0xEB1085,
    "Threed Bakery - Slot 2": 0xEB1086,
    "Threed Bakery - Slot 3": 0xEB1087,
    "Threed Bakery - Slot 4": 0xEB1088,
    "Threed Bakery - Slot 5": 0xEB1089,
    "Threed Bakery - Slot 6": 0xEB108A,
    "Threed Bakery - Slot 7": 0xEB108B,

    "Scaraba - Expensive Water Guy": 0xEB108C,

    "Winters Drugstore - Slot 1": 0xEB1093,
    "Winters Drugstore - Slot 2": 0xEB1094,
    "Winters Drugstore - Slot 3": 0xEB1095,
    "Winters Drugstore - Slot 4": 0xEB1096,
    "Winters Drugstore - Slot 5": 0xEB1097,
    "Winters Drugstore - Slot 6": 0xEB1098,
    "Winters Drugstore - Slot 7": 0xEB1099,

    "Saturn Valley Shop - Center Saturn Slot 1": 0xEB109A,
    "Saturn Valley Shop - Center Saturn Slot 2": 0xEB109B,
    "Saturn Valley Shop - Center Saturn Slot 3": 0xEB109C,
    "Saturn Valley Shop - Center Saturn Slot 4": 0xEB109D,
    "Saturn Valley Shop - Center Saturn Slot 5": 0xEB109E,

    "Dusty Dunes Drugstore - Counter Slot 1": 0xEB10A1,
    "Dusty Dunes Drugstore - Counter Slot 2": 0xEB10A2,
    "Dusty Dunes Drugstore - Counter Slot 3": 0xEB10A3,
    "Dusty Dunes Drugstore - Counter Slot 4": 0xEB10A4,
    "Dusty Dunes Drugstore - Counter Slot 5": 0xEB10A5,

    "Dusty Dunes - Arms Dealer Slot 1": 0xEB10A8,
    "Dusty Dunes - Arms Dealer Slot 2": 0xEB10A9,
    "Dusty Dunes - Arms Dealer Slot 3": 0xEB10AA,
    "Dusty Dunes - Arms Dealer Slot 4": 0xEB10AB,

    "Fourside Bakery - Slot 1": 0xEB10AF,
    "Fourside Bakery - Slot 2": 0xEB10B0,
    "Fourside Bakery - Slot 3": 0xEB10B1,
    "Fourside Bakery - Slot 4": 0xEB10B2,  # Force this slot to be repel sandwich in monkey caves mode
    "Fourside Bakery - Slot 5": 0xEB10B3,
    "Fourside Bakery - Slot 6": 0xEB10B4,

    "Fourside Department Store - Tool Shop Slot 1": 0xEB10B6,
    "Fourside Department Store - Tool Shop Slot 2": 0xEB10B7,
    "Fourside Department Store - Tool Shop Slot 3": 0xEB10B8,
    "Fourside Department Store - Tool Shop Slot 4": 0xEB10B9,
    "Fourside Department Store - Tool Shop Slot 5": 0xEB10BA,
    "Fourside Department Store - Tool Shop Slot 6": 0xEB10BB,
    "Fourside Department Store - Tool Shop Slot 7": 0xEB10BC,  # Force this slot to be ruler in monkey caves mode

    "Fourside Department Store - Shop Shop Slot 1": 0xEB10BD,
    "Fourside Department Store - Shop Shop Slot 2": 0xEB10BE,
    "Fourside Department Store - Shop Shop Slot 3": 0xEB10BF,  # Force this slot to be Protein drink in monkey caves mod
    "Fourside Department Store - Shop Shop Slot 4": 0xEB10C0,

    "Fourside Department Store - Food Shop Slot 1": 0xEB10C4,
    "Fourside Department Store - Food Shop Slot 2": 0xEB10C5,
    "Fourside Department Store - Food Shop Slot 3": 0xEB10C6,
    "Fourside Department Store - Food Shop Slot 4": 0xEB10C7,
    "Fourside Department Store - Food Shop Slot 5": 0xEB10C8,  # Force this slot to be Picnic lunch in monkey caves mode

    "Fourside Department Store - 2F Cart Slot 1": 0xEB10CB,
    "Fourside Department Store - 2F Cart Slot 2": 0xEB10CC,
    "Fourside Department Store - 2F Cart Slot 3": 0xEB10CD,
    "Fourside Department Store - 2F Cart Slot 4": 0xEB10CE,
    "Fourside Department Store - 2F Cart Slot 5": 0xEB10CF,
    "Fourside Department Store - 2F Cart Slot 6": 0xEB10D0,
    "Fourside Department Store - 2F Cart Slot 7": 0xEB10D1,

    "Fourside Department Store - Toys Shop Slot 1": 0xEB10D2,
    "Fourside Department Store - Toys Shop Slot 2": 0xEB10D3,
    "Fourside Department Store - Toys Shop Slot 3": 0xEB10D4,
    "Fourside Department Store - Toys Shop Slot 4": 0xEB10D5,
    "Fourside Department Store - Toys Shop Slot 5": 0xEB10D6,
    "Fourside Department Store - Toys Shop Slot 6": 0xEB10D7,

    "Fourside Department Store - Sports Shop Slot 1": 0xEB10D9,
    "Fourside Department Store - Sports Shop Slot 2": 0xEB10DA,
    "Fourside Department Store - Sports Shop Slot 3": 0xEB10DB,
    "Fourside Department Store - Sports Shop Slot 4": 0xEB10DC,

    "Fourside Department Store - Burger Shop Slot 1": 0xEB10E0,
    "Fourside Department Store - Burger Shop Slot 2": 0xEB10E1,
    "Fourside Department Store - Burger Shop Slot 3": 0xEB10E2,
    "Fourside Department Store - Burger Shop Slot 4": 0xEB10E3,  # Force this slot to be Hamburger
    "Fourside Department Store - Burger Shop Slot 5": 0xEB10E4,

    "Fourside Department Store - Arms Dealer Slot 1": 0xEB10E7,
    "Fourside Department Store - Arms Dealer Slot 2": 0xEB10E8,
    "Fourside Department Store - Arms Dealer Slot 3": 0xEB10E9,
    "Fourside Department Store - Arms Dealer Slot 4": 0xEB10EA,
    "Fourside Department Store - Arms Dealer Slot 5": 0xEB10EB,

    "Fourside - Northeast Alley Junk Shop Slot 1": 0xEB10EE,
    "Fourside - Northeast Alley Junk Shop Slot 2": 0xEB10EF,
    "Fourside - Northeast Alley Junk Shop Slot 3": 0xEB10F0,
    "Fourside - Northeast Alley Junk Shop Slot 4": 0xEB10F1,

    "Magicant - Shop Slot 1": 0xEB10F5,
    "Magicant - Shop Slot 2": 0xEB10F6,

    "Summers - Scam Shop Slot 1": 0xEB1103,
    "Summers - Scam Shop Slot 2": 0xEB1104,
    "Summers - Scam Shop Slot 3": 0xEB1105,
    "Summers - Scam Shop Slot 4": 0xEB1106,
    "Summers - Scam Shop Slot 5": 0xEB1107,
    "Summers - Scam Shop Slot 6": 0xEB1108,
    "Summers - Scam Shop Slot 7": 0xEB1109,

    "Summers Harbor - Shop Slot 1": 0xEB110A,
    "Summers Harbor - Shop Slot 2": 0xEB110B,
    "Summers Harbor - Shop Slot 3": 0xEB110C,
    "Summers Harbor - Shop Slot 4": 0xEB110D,
    "Summers Harbor - Shop Slot 5": 0xEB110E,
    "Summers Harbor - Shop Slot 6": 0xEB110F,
    "Summers Harbor - Shop Slot 7": 0xEB1110,

    "Summers Restaurant - Slot 1": 0xEB1111,
    "Summers Restaurant - Slot 2": 0xEB1112,
    "Summers Restaurant - Slot 3": 0xEB1113,
    "Summers Restaurant - Slot 4": 0xEB1114,
    "Summers Restaurant - Slot 5": 0xEB1115,
    "Summers Restaurant - Slot 6": 0xEB1116,

    "Scaraba - Indoors Shop Slot 1": 0xEB1118,
    "Scaraba - Indoors Shop Slot 2": 0xEB1119,
    "Scaraba - Indoors Shop Slot 3": 0xEB111A,
    "Scaraba - Indoors Shop Slot 4": 0xEB111B,
    "Scaraba - Indoors Shop Slot 5": 0xEB111C,
    "Scaraba - Indoors Shop Slot 6": 0xEB111D,

    "Scaraba Bazaar - Red Snake Carpet Slot 1": 0xEB1126,
    "Scaraba Bazaar - Red Snake Carpet Slot 2": 0xEB1127,
    "Scaraba Bazaar - Red Snake Carpet Slot 3": 0xEB1128,

    "Scaraba Bazaar - Bottom Left Carpet Slot 1": 0xEB112D,
    "Scaraba Bazaar - Bottom Left Carpet Slot 2": 0xEB112E,
    "Scaraba Bazaar - Bottom Left Carpet Slot 3": 0xEB112F,
    "Scaraba Bazaar - Bottom Left Carpet Slot 4": 0xEB1130,
    "Scaraba Bazaar - Bottom Left Carpet Slot 5": 0xEB1131,
    "Scaraba Bazaar - Bottom Left Carpet Slot 6": 0xEB1132,

    "Scaraba Hotel - Arms Dealer Slot 1": 0xEB1134,
    "Scaraba Hotel - Arms Dealer Slot 2": 0xEB1135,
    "Scaraba Hotel - Arms Dealer Slot 3": 0xEB1136,
    "Scaraba Hotel - Arms Dealer Slot 4": 0xEB1137,

    "Deep Darkness - Businessman Slot 1": 0xEB113B,
    "Deep Darkness - Businessman Slot 2": 0xEB113C,
    "Deep Darkness - Businessman Slot 3": 0xEB113D,
    "Deep Darkness - Businessman Slot 4": 0xEB113E,
    "Deep Darkness - Businessman Slot 5": 0xEB113F,
    "Deep Darkness - Businessman Slot 6": 0xEB1140,
    "Deep Darkness - Businessman Slot 7": 0xEB1141,
    
    "Saturn Valley Shop - Post-Belch Saturn Slot 1": 0xEB1157,
    "Saturn Valley Shop - Post-Belch Saturn Slot 2": 0xEB1158,
    "Saturn Valley Shop - Post-Belch Saturn Slot 3": 0xEB1159,
    "Saturn Valley Shop - Post-Belch Saturn Slot 4": 0xEB115A,

    "Scaraba - Southern Camel Shop Slot 1": 0xEB115E,
    "Scaraba - Southern Camel Shop Slot 2": 0xEB115F,
    "Scaraba - Southern Camel Shop Slot 3": 0xEB1160,
    "Scaraba - Southern Camel Shop Slot 4": 0xEB1161,
    "Scaraba - Southern Camel Shop Slot 5": 0xEB1162,
    "Scaraba - Southern Camel Shop Slot 6": 0xEB1163,
    "Scaraba - Southern Camel Shop Slot 7": 0xEB1164,

    "Deep Darkness - Arms Dealer Slot 1": 0xEB1165,
    "Deep Darkness - Arms Dealer Slot 2": 0xEB1166,
    "Deep Darkness - Arms Dealer Slot 3": 0xEB1167,
    "Deep Darkness - Arms Dealer Slot 4": 0xEB1168,

    "Lost Underworld - Tenda Camp Shop Slot 1": 0xEB116C,
    "Lost Underworld - Tenda Camp Shop Slot 2": 0xEB116D,
    "Lost Underworld - Tenda Camp Shop Slot 3": 0xEB116E,
    "Lost Underworld - Tenda Camp Shop Slot 4": 0xEB116F,
    "Lost Underworld - Tenda Camp Shop Slot 5": 0xEB1170,
    "Lost Underworld - Tenda Camp Shop Slot 6": 0xEB1171,
    "Lost Underworld - Tenda Camp Shop Slot 7": 0xEB1172,

    "Happy-Happy Village Drugstore - Left Counter Slot 1": 0xEB117A,
    "Happy-Happy Village Drugstore - Left Counter Slot 2": 0xEB117B,
    "Happy-Happy Village Drugstore - Left Counter Slot 3": 0xEB117C,
    "Happy-Happy Village Drugstore - Left Counter Slot 4": 0xEB117D,
    "Happy-Happy Village Drugstore - Left Counter Slot 5": 0xEB117E,
    "Happy-Happy Village Drugstore - Left Counter Slot 6": 0xEB117F,
    "Happy-Happy Village Drugstore - Left Counter Slot 7": 0xEB1180,

    "Grapefruit Falls - Hiker Shop Slot 1": 0xEB1181,
    "Grapefruit Falls - Hiker Shop Slot 2": 0xEB1182,
    "Grapefruit Falls - Hiker Shop Slot 3": 0xEB1183,

    "Saturn Valley Shop - Top Saturn Slot 1": 0xEB1188,
    "Saturn Valley Shop - Top Saturn Slot 2": 0xEB1189,
    "Saturn Valley Shop - Top Saturn Slot 3": 0xEB118A,
    "Saturn Valley Shop - Top Saturn Slot 4": 0xEB118B,
    "Saturn Valley Shop - Top Saturn Slot 5": 0xEB118C,
    "Saturn Valley Shop - Top Saturn Slot 6": 0xEB118D,
    "Saturn Valley Shop - Top Saturn Slot 7": 0xEB118E,

    "Dusty Dunes Drugstore - Left Shop Slot 1": 0xEB118F,  # Force this slot to be a wet towel in monkey caves
    "Dusty Dunes Drugstore - Left Shop Slot 2": 0xEB1190,
    "Dusty Dunes Drugstore - Left Shop Slot 3": 0xEB1191,
    "Dusty Dunes Drugstore - Left Shop Slot 4": 0xEB1192,
    "Dusty Dunes Drugstore - Left Shop Slot 5": 0xEB1193,
    "Dusty Dunes Drugstore - Left Shop Slot 6": 0xEB1194,
    "Dusty Dunes Drugstore - Left Shop Slot 7": 0xEB1195,

    "Dusty Dunes - Mine Food Cart Slot 1": 0xEB1196,
    "Dusty Dunes - Mine Food Cart Slot 2": 0xEB1197,
    "Dusty Dunes - Mine Food Cart Slot 3": 0xEB1198,
    "Dusty Dunes - Mine Food Cart Slot 4": 0xEB1199,
    "Dusty Dunes - Mine Food Cart Slot 5": 0xEB119A,
    "Dusty Dunes - Mine Food Cart Slot 6": 0xEB119B,
    "Dusty Dunes - Mine Food Cart Slot 7": 0xEB119C,

    "Moonside Hotel - Shop Slot 1": 0xEB119D,
    "Moonside Hotel - Shop Slot 2": 0xEB119E,
    "Moonside Hotel - Shop Slot 3": 0xEB119F,
    "Moonside Hotel - Shop Slot 4": 0xEB11A0,
    "Moonside Hotel - Shop Slot 5": 0xEB11A1,

    "Dalaam Restaurant - Slot 1": 0xEB11A4,
    "Dalaam Restaurant - Slot 2": 0xEB11A5,
    "Dalaam Restaurant - Slot 3": 0xEB11A6,
    "Dalaam Restaurant - Slot 4": 0xEB11A7,

    "Scaraba Bazaar - Delicacy Shop Slot 1": 0xEB11AB,
    "Scaraba Bazaar - Delicacy Shop Slot 2": 0xEB11AC,
    "Scaraba Bazaar - Delicacy Shop Slot 3": 0xEB11AD,
    "Scaraba Bazaar - Delicacy Shop Slot 4": 0xEB11AE,
    "Scaraba Bazaar - Delicacy Shop Slot 5": 0xEB11AF,
    "Scaraba Bazaar - Delicacy Shop Slot 6": 0xEB11B0,
    "Scaraba Bazaar - Delicacy Shop Slot 7": 0xEB11B1,

    "Twoson/Scaraba - Shared Condiment Shop Slot 1": 0xEB11B2,
    "Twoson/Scaraba - Shared Condiment Shop Slot 2": 0xEB11B3,
    "Twoson/Scaraba - Shared Condiment Shop Slot 3": 0xEB11B4,
    "Twoson/Scaraba - Shared Condiment Shop Slot 4": 0xEB11B5,
    "Twoson/Scaraba - Shared Condiment Shop Slot 5": 0xEB11B6,
    "Twoson/Scaraba - Shared Condiment Shop Slot 6": 0xEB11B7,
    "Twoson/Scaraba - Shared Condiment Shop Slot 7": 0xEB11B8,

    # Make sure this shop uses the earlier one
    "Andonuts Lab - Caveman Shop Slot 1": 0xEB11C0,
    "Andonuts Lab - Caveman Shop Slot 2": 0xEB11C1,
    "Andonuts Lab - Caveman Shop Slot 3": 0xEB11C2,
    "Andonuts Lab - Caveman Shop Slot 4": 0xEB11C3,
    "Andonuts Lab - Caveman Shop Slot 5": 0xEB11C4
}


location_groups = {
    "Poo's Inventory": {
        "Poo - Starting Item"
    },

    "Northern Onett": {
        "Onett - Tracy Gift",
        "Onett - Tracy's Room Present",
        "Onett - Meteor Item",
        "Onett - Buzz Buzz",
        "Onett - Mani Mani Statue",
        "Onett - Hilltop Present"
    },

    "Onett": {
        "Onett - Library Counter",
        "Onett - Library Bookshelf",
        "Onett - Burger Shop Trashcan",
        "Onett - Treehouse Guy",
        "Onett - South Road Present",
        "Onett - Hotel Trashcan",
        "Onett - Mayor Pirkle",
        "Onett - Traveling Entertainer",
        "Onett - Arcade Trashcan",
        "Onett Drugstore - Right Counter Slot 1",
        "Onett Drugstore - Right Counter Slot 2",
        "Onett Drugstore - Right Counter Slot 3",
        "Onett Drugstore - Right Counter Slot 4",
        "Onett Drugstore - Right Counter Slot 5",
        "Onett Drugstore - Left Counter",
        "Onett Burger Shop - Slot 1",
        "Onett Burger Shop - Slot 2",
        "Onett Burger Shop - Slot 3",
        "Onett Burger Shop - Slot 4",
        "Onett Bakery - Slot 1",
        "Onett Bakery - Slot 2",
        "Onett Bakery - Slot 3",
        "Onett Bakery - Slot 4"
    },

    "Giant Step": {
        "Giant Step - First Cave Present",
        "Giant Step - Floor 2 Cave Present",
        "Giant Step - Floor 3 Present"
    },

    "Twoson": {
        "Twoson - Bike Shop Rental",
        "Twoson - Antique Shop",
        "Twoson - Paula's Room Present",
        "Twoson - Apple Kid Trashcan",
        "Twoson - South of Town Present",
        "Twoson - Orange Kid Donation",
        "Twoson - Apple Kid Invention",
        "Twoson - Apple Kid's Mouse",
        "Twoson - Paula's Mother",
        "Twoson - Everdred Meeting",
        "Twoson - Insignificant Location",
        "Twoson Department Store Burger Shop - Slot 1",
        "Twoson Department Store Burger Shop - Slot 2",
        "Twoson Department Store Burger Shop - Slot 3",
        "Twoson Department Store Burger Shop - Slot 4",
        "Twoson Department Store Bakery - Slot 1",
        "Twoson Department Store Bakery - Slot 2",
        "Twoson Department Store Bakery - Slot 3",
        "Twoson Department Store Bakery - Slot 4",
        "Twoson Department Store Top Floor - Right Counter Slot 1",
        "Twoson Department Store Top Floor - Right Counter Slot 2",
        "Twoson Department Store Top Floor - Right Counter Slot 3",
        "Twoson Department Store Top Floor - Right Counter Slot 4",
        "Twoson Department Store Top Floor - Right Counter Slot 5",
        "Twoson Department Store Top Floor - Right Counter Slot 6",
        "Twoson Department Store Top Floor - Left Counter Slot 1",
        "Twoson Department Store Top Floor - Left Counter Slot 2",
        "Twoson/Scaraba - Shared Condiment Shop Slot 1",
        "Twoson/Scaraba - Shared Condiment Shop Slot 2",
        "Twoson/Scaraba - Shared Condiment Shop Slot 3",
        "Twoson/Scaraba - Shared Condiment Shop Slot 4",
        "Twoson/Scaraba - Shared Condiment Shop Slot 5",
        "Twoson/Scaraba - Shared Condiment Shop Slot 6",
        "Twoson/Scaraba - Shared Condiment Shop Slot 7"
    },

    "Peaceful Rest Valley": {
        "Peaceful Rest Valley - Split Hill Present",
        "Peaceful Rest Valley - Hill Nook Present",
        "Peaceful Rest Valley - South of Bridge Present",
        "Peaceful Rest Valley - Dead End Present",
        "Peaceful Rest Valley - River Overlook Present",
        "Peaceful Rest Valley - North Side Present"
    },

    "Happy-Happy Village": {
        "Happy-Happy Village - Donation Lady",
        "Happy-Happy Village - Prisoner Item",
        "Happy-Happy Village - Prisoner",
        "Happy-Happy Village Drugstore - Right Counter Slot 1",
        "Happy-Happy Village Drugstore - Right Counter Slot 2",
        "Happy-Happy Village Drugstore - Right Counter Slot 3",
        "Happy-Happy Village Drugstore - Right Counter Slot 4",
        "Happy-Happy Village Drugstore - Right Counter Slot 5",
        "Happy-Happy Village Drugstore - Left Counter Slot 1",
        "Happy-Happy Village Drugstore - Left Counter Slot 2",
        "Happy-Happy Village Drugstore - Left Counter Slot 3",
        "Happy-Happy Village Drugstore - Left Counter Slot 4",
        "Happy-Happy Village Drugstore - Left Counter Slot 5",
        "Happy-Happy Village Drugstore - Left Counter Slot 6",
        "Happy-Happy Village Drugstore - Left Counter Slot 7"
    },

    "the Happy-Happy HQ": {
        "Happy-Happy Village - Right HQ Present",
        "Happy-Happy Village - Left HQ Present",
        "Happy-Happy Village - Defeat Carpainter"
    },

    "Lilliput Steps": {
        "Lilliput Steps - Southwest Pool Present",
        "Lilliput Steps - East Cliff Present",
        "Lilliput Steps - North Stream Present"
    },

    "Threed": {
        "Threed - Boogey Tent Trashcan",
        "Threed - Cemetery Trashcan",
        "Threed - Downtown Trashcan",
        "Threed - East Side Trashcan",
        "Threed - Northeast Shack Trashcan",
        "Threed - Hospital Drawer",
        "Threed - Zombie Prisoner",
        "Threed Drugstore - Right Counter Slot 1",
        "Threed Drugstore - Right Counter Slot 2",
        "Threed Drugstore - Right Counter Slot 3",
        "Threed Drugstore - Right Counter Slot 4",
        "Threed Drugstore - Right Counter Slot 5",
        "Threed Drugstore - Left Counter Slot 1",
        "Threed Drugstore - Left Counter Slot 2",
        "Threed Drugstore - Left Counter Slot 3",
        "Threed Drugstore - Left Counter Slot 4",
        "Threed Drugstore - Left Counter Slot 5",
        "Threed - Arms Dealer Slot 1",
        "Threed - Arms Dealer Slot 2",
        "Threed - Arms Dealer Slot 3",
        "Threed - Arms Dealer Slot 4",
        "Threed Bakery - Slot 1",
        "Threed Bakery - Slot 2",
        "Threed Bakery - Slot 3",
        "Threed Bakery - Slot 4",
        "Threed Bakery - Slot 5",
        "Threed Bakery - Slot 6",
        "Threed Bakery - Slot 7"
    },

    "the Threed Underground Passage": {
        "Threed Underground - Left Coffin",
        "Threed Underground - Right Coffin"
    },

    "Grapefruit Falls": {
        "Grapefruit Falls - South Present",
        "Grapefruit Falls - North Present",
        "Grapefruit Falls - Saturn Cave Present",
        "Grapefruit Falls - Hiker Shop Slot 1",
        "Grapefruit Falls - Hiker Shop Slot 2",
        "Grapefruit Falls - Hiker Shop Slot 3"
    },

    "Saturn Valley": {
        "Saturn Valley - Ladder Present",
        "Saturn Valley - Trashcan #1",
        "Saturn Valley - Trashcan #2",
        "Saturn Valley - Trashcan #3",
        "Saturn Valley - Saturn Coffee",
        "Saturn Valley - Post Belch Gift #1",
        "Saturn Valley - Post Belch Gift #2",
        "Saturn Valley - Post Belch Gift #3",
        "Saturn Valley Shop - Center Saturn Slot 1",
        "Saturn Valley Shop - Center Saturn Slot 2",
        "Saturn Valley Shop - Center Saturn Slot 3",
        "Saturn Valley Shop - Center Saturn Slot 4",
        "Saturn Valley Shop - Center Saturn Slot 5",
        "Saturn Valley Shop - Top Saturn Slot 1",
        "Saturn Valley Shop - Top Saturn Slot 2",
        "Saturn Valley Shop - Top Saturn Slot 3",
        "Saturn Valley Shop - Top Saturn Slot 4",
        "Saturn Valley Shop - Top Saturn Slot 5",
        "Saturn Valley Shop - Top Saturn Slot 6",
        "Saturn Valley Shop - Top Saturn Slot 7",
        "Saturn Valley Shop - Post-Belch Saturn Slot 1",
        "Saturn Valley Shop - Post-Belch Saturn Slot 2",
        "Saturn Valley Shop - Post-Belch Saturn Slot 3",
        "Saturn Valley Shop - Post-Belch Saturn Slot 4"
    },

    "Milky Well": {
        "Milky Well - Cavern Present"  # this is a very good location group :^)
    },

    "Belch's Factory": {
        "Belch's Factory - Top Right Room Trashcan",
        "Belch's Factory - Pit Room Trashcan #1",
        "Belch's Factory - Pit Room Trashcan #2",
        "Belch's Factory - Balcony Room Trashcan #1",
        "Belch's Factory - Balcony Room Trashcan #2",
        "Belch's Factory - Balcony Room Trashcan #3"
    },

    "Dusty Dunes Desert": {
        "Dusty Dunes - Northwest Corner Present",
        "Dusty Dunes - South Side Present",
        "Dusty Dunes - Surrounding Rocks Present",
        "Dusty Dunes - Black Sesame Present",
        "Dusty Dunes - Oasis Present",
        "Dusty Dunes - Northeast Corner Present",
        "Dusty Dunes - North Central Present",
        "Dusty Dunes - Shining Spot",
        "Dusty Dunes - East Peninsula Present",
        "Dusty Dunes - Mine Reward",
        "Dusty Dunes Drugstore - Left Shop Slot 1",
        "Dusty Dunes Drugstore - Left Shop Slot 2",
        "Dusty Dunes Drugstore - Left Shop Slot 3",
        "Dusty Dunes Drugstore - Left Shop Slot 4",
        "Dusty Dunes Drugstore - Left Shop Slot 5",
        "Dusty Dunes Drugstore - Left Shop Slot 6",
        "Dusty Dunes Drugstore - Left Shop Slot 7",
        "Dusty Dunes - Mine Food Cart Slot 1",
        "Dusty Dunes - Mine Food Cart Slot 2",
        "Dusty Dunes - Mine Food Cart Slot 3",
        "Dusty Dunes - Mine Food Cart Slot 4",
        "Dusty Dunes - Mine Food Cart Slot 5",
        "Dusty Dunes - Mine Food Cart Slot 6",
        "Dusty Dunes - Mine Food Cart Slot 7",
        "Dusty Dunes Drugstore - Counter Slot 1",
        "Dusty Dunes Drugstore - Counter Slot 2",
        "Dusty Dunes Drugstore - Counter Slot 3",
        "Dusty Dunes Drugstore - Counter Slot 4",
        "Dusty Dunes Drugstore - Counter Slot 5",
        "Dusty Dunes - Arms Dealer Slot 1",
        "Dusty Dunes - Arms Dealer Slot 2",
        "Dusty Dunes - Arms Dealer Slot 3",
        "Dusty Dunes - Arms Dealer Slot 4"
    },

    "the Snow Wood locker room": {
        "Snow Wood - Upper Right Locker",
        "Snow Wood - Upper Left Locker",
        "Snow Wood - Bottom Right Locker",
        "Snow Wood - Bottom Left Locker"
    },

    "Snow Wood Boarding School (not lockers)": {
        "Snow Wood - Many Present Room Present #1",
        "Snow Wood - Many Present Room Present #2",
        "Snow Wood - Many Present Room Present #3",
        "Snow Wood - Many Present Room Present #4",
        "Snow Wood - Many Present Room Present #5",
        "Snow Wood - Many Present Room Present #6",
        "Snow Wood - Many Present Room Present #7",
        "Snow Wood - Maxwell Item",
        "Snow Wood - Bedroom"
    },

    "Winters": {
        "Winters - Drugstore Saleswoman",
        "Winters Drugstore - Slot 1",
        "Winters Drugstore - Slot 2",
        "Winters Drugstore - Slot 3",
        "Winters Drugstore - Slot 4",
        "Winters Drugstore - Slot 5",
        "Winters Drugstore - Slot 6",
        "Winters Drugstore - Slot 7"
    },

    "the Brick Road Maze": {
        "Brick Road Maze - Top Path Present",
        "Brick Road Maze - Guarded Present",
        "Brick Road Maze - Out of the Way Present",
        "Brick Road Maze - Alcove Present",
        "Brick Road Maze - Near Exit Present"
    },

    "Rainy Circle": {
        "Rainy Circle - Isolated Present",
        "Rainy Circle - East Cliff Present",
        "Rainy Circle - Near Ropes Present"
    },

    "Dr. Andonuts's Lab": {
        "Andonuts Lab - Present",
        "Andonuts Lab - Mouse",
        "Andonuts Lab - Caveman Shop Slot 1",
        "Andonuts Lab - Caveman Shop Slot 2",
        "Andonuts Lab - Caveman Shop Slot 3",
        "Andonuts Lab - Caveman Shop Slot 4",
        "Andonuts Lab - Caveman Shop Slot 5"
    },

    "Stonehenge Maze Area": {
        "Stonehenge - Purple Maze Present",
        "Stonehenge - Dead End Present",
        "Stonehenge - Near End of the Maze Present"
    },

    "Stonehenge Bridge Area": {
        "Stonehenge - Bridge Room East Balcony Present",
        "Stonehenge - Bridge Room Lower Present"
    },

    "Stonehenge Flashing Area": {
        "Stonehenge - Flashing Room Right Path Present",
        "Stonehenge - Flashing Room Center Present",
        "Stonehenge - Flashing Room Upper Present"
    },

    "Stonehenge Tube Room": {
        "Stonehenge - Kidnapped Mr. Saturn",
        "Stonehenge - Tony Item"
    },

    "Gold Mine 1F": {
        "Gold Mine - Mouse Crossroad Present #1",
        "Gold Mine - Mouse Crossroad Present #2",
        "Gold Mine - South Hall Present",
        "Gold Mine - South Corner Present",
        "Gold Mine - South Mole Present #1",
        "Gold Mine - South Mole Present #2",
        "Gold Mine - North Crossroad Detour Present",
        "Gold Mine - North Mole Present",
        "Gold Mine - West Mole Present",
        "Gold Mine - West Crossroad Detour Present"

    },

    "Gold Mine B1F": {
        "Gold Mine - B1F Lonely Mole Present",
        "Gold Mine - B1F Isolated Present",
        "Gold Mine - B1F Junction Present",
        "Gold Mine - B1F Junction Mole Present"
        
    },

    "Monkey Caves West Wing": {
        "Monkey Caves - 1F Left Chest",
        "Monkey Caves - West 2F Left Chest",
        "Monkey Caves - West 2F Right Chest #1",
        "Monkey Caves - West 2F Right Chest #2",
        "Monkey Caves - West End Chest",
        "Monkey Caves - West End Trashcan",

        
    },

    "Monkey Caves East Wing": {
        "Monkey Caves - 1F Right Chest",
        "Monkey Caves - East 2F Left Chest",
        "Monkey Caves - East 2F Right Chest",
        "Monkey Caves - East West 3F Right Chest #1",
        "Monkey Caves - East West 3F Right Chest #2",
        "Monkey Caves - East End Chest",
        "Monkey Caves - East End Trashcan",
        "Monkey Caves - Bow Monkey Gift"
        
    },

    "Monkey Caves Talah Rama Room": {
        "Monkey Caves - Talah Rama Chest #1",
        "Monkey Caves - Talah Rama Chest #2",
        "Monkey Caves - Talah Rama Gift",
        "Monkey Caves - Monkey Power"
        
    },

    "Fourside": {
        "Fourside - Venus Gift",
        "Fourside - Bakery 2F Gift",
        "Fourside - Department Store Blackout",
        "Fourside Department Store - Tool Shop Slot 1",
        "Fourside Department Store - Tool Shop Slot 2",
        "Fourside Department Store - Tool Shop Slot 3",
        "Fourside Department Store - Tool Shop Slot 4",
        "Fourside Department Store - Tool Shop Slot 5",
        "Fourside Department Store - Tool Shop Slot 6",
        "Fourside Department Store - Tool Shop Slot 7",
        "Fourside Department Store - Shop Shop Slot 1",
        "Fourside Department Store - Shop Shop Slot 2",
        "Fourside Department Store - Shop Shop Slot 3",
        "Fourside Department Store - Shop Shop Slot 4",
        "Fourside Department Store - Food Shop Slot 1",
        "Fourside Department Store - Food Shop Slot 2",
        "Fourside Department Store - Food Shop Slot 3",
        "Fourside Department Store - Food Shop Slot 4",
        "Fourside Department Store - Food Shop Slot 5",
        "Fourside Department Store - 2F Cart Slot 1",
        "Fourside Department Store - 2F Cart Slot 2",
        "Fourside Department Store - 2F Cart Slot 3",
        "Fourside Department Store - 2F Cart Slot 4",
        "Fourside Department Store - 2F Cart Slot 5",
        "Fourside Department Store - 2F Cart Slot 6",
        "Fourside Department Store - 2F Cart Slot 7",
        "Fourside Department Store - Toys Shop Slot 1",
        "Fourside Department Store - Toys Shop Slot 2",
        "Fourside Department Store - Toys Shop Slot 3",
        "Fourside Department Store - Toys Shop Slot 4",
        "Fourside Department Store - Toys Shop Slot 5",
        "Fourside Department Store - Toys Shop Slot 6",
        "Fourside Department Store - Sports Shop Slot 1",
        "Fourside Department Store - Sports Shop Slot 2",
        "Fourside Department Store - Sports Shop Slot 3",
        "Fourside Department Store - Sports Shop Slot 4",
        "Fourside Department Store - Burger Shop Slot 1",
        "Fourside Department Store - Burger Shop Slot 2",
        "Fourside Department Store - Burger Shop Slot 3",
        "Fourside Department Store - Burger Shop Slot 4",
        "Fourside Department Store - Burger Shop Slot 5",
        "Fourside Department Store - Arms Dealer Slot 1",
        "Fourside Department Store - Arms Dealer Slot 2",
        "Fourside Department Store - Arms Dealer Slot 3",
        "Fourside Department Store - Arms Dealer Slot 4",
        "Fourside Department Store - Arms Dealer Slot 5",
        "Fourside - Northeast Alley Junk Shop Slot 1",
        "Fourside - Northeast Alley Junk Shop Slot 2",
        "Fourside - Northeast Alley Junk Shop Slot 3",
        "Fourside - Northeast Alley Junk Shop Slot 4",
        "Fourside Bakery - Slot 1",
        "Fourside Bakery - Slot 2",
        "Fourside Bakery - Slot 3",
        "Fourside Bakery - Slot 4",
        "Fourside Bakery - Slot 5",
        "Fourside Bakery - Slot 6"
    },

    "Moonside": {
        "Moonside - Two Trees Present",
        "Moonside - East Island Present",
        "Moonside - Businessman Present",
        "Moonside - West Island Present",
        "Moonside - Hospital Present",
        "Fourside - Post-Moonside Delivery",
        "Moonside Hotel - Shop Slot 1",
        "Moonside Hotel - Shop Slot 2",
        "Moonside Hotel - Shop Slot 3",
        "Moonside Hotel - Shop Slot 4",
        "Moonside Hotel - Shop Slot 5"
        
    },

    "Magnet Hill": {
        "Magnet Hill - West Entrance Trashcan",
        "Magnet Hill - First Room Free Door Trashcan",
        "Magnet Hill - First Room Barrel Door Trashcan",
        "Magnet Hill - Second Room Dead End Trashcan",
        "Magnet Hill - Final Room Door Trashcan",
        "Fourside - Magnet Hill Chest"
        
    },

    "Monotoli Building": {
        "Monotoli Building - One Table Present",
        "Monotoli Building - Two Table Present",
        "Monotoli Building - Electra Gift",
        "Monotoli Building - Monotoli Gift",
        "Monotoli Building - Monotoli Character"
        
    },

    "Summers": {
        "Summers - Museum Item",
        "Summers - Magic Cake",
        "Summers - Beach Cart",
        "Summers - Magic Cake Cart Shop Slot",
        "Summers - Scam Shop Slot 1",
        "Summers - Scam Shop Slot 2",
        "Summers - Scam Shop Slot 3",
        "Summers - Scam Shop Slot 4",
        "Summers - Scam Shop Slot 5",
        "Summers - Scam Shop Slot 6",
        "Summers - Scam Shop Slot 7",
        "Summers Harbor - Shop Slot 1",
        "Summers Harbor - Shop Slot 2",
        "Summers Harbor - Shop Slot 3",
        "Summers Harbor - Shop Slot 4",
        "Summers Harbor - Shop Slot 5",
        "Summers Harbor - Shop Slot 6",
        "Summers Harbor - Shop Slot 7",
        "Summers Restaurant - Slot 1",
        "Summers Restaurant - Slot 2",
        "Summers Restaurant - Slot 3",
        "Summers Restaurant - Slot 4",
        "Summers Restaurant - Slot 5",
        "Summers Restaurant - Slot 6"
    },

    "Dalaam": {
        "Dalaam - Throne Room Chest #1",
        "Dalaam - Throne Room Chest #2",
        "Dalaam - Throne Room Chest #3",
        "Dalaam - Trial of Mu",
        "Dalaam - Restaurant Chest #1",
        "Dalaam - Restaurant Chest #2",
        "Dalaam - Do Do Guy's House Chest",
        "Dalaam - Upper House Chest",
        "Dalaam - Throne Character",
        "Dalaam Restaurant - Slot 1",
        "Dalaam Restaurant - Slot 2",
        "Dalaam Restaurant - Slot 3",
        "Dalaam Restaurant - Slot 4"
        
    },

    "Pink Cloud": {
        "Pink Cloud - Three Holes Present",
        "Pink Cloud - Left Hole Present",
        "Pink Cloud - Ground Floor Present"
    },

    "Scaraba": {
        "Scaraba - Snake Bag Salesman",
        "Scaraba - Star Master",
        "Scaraba - Key Holder",
        "Twoson/Scaraba - Shared Condiment Shop Slot 1",
        "Twoson/Scaraba - Shared Condiment Shop Slot 2",
        "Twoson/Scaraba - Shared Condiment Shop Slot 3",
        "Twoson/Scaraba - Shared Condiment Shop Slot 4",
        "Twoson/Scaraba - Shared Condiment Shop Slot 5",
        "Twoson/Scaraba - Shared Condiment Shop Slot 6",
        "Twoson/Scaraba - Shared Condiment Shop Slot 7",
        "Scaraba - Expensive Water Guy",
        "Scaraba - Indoors Shop Slot 1",
        "Scaraba - Indoors Shop Slot 2",
        "Scaraba - Indoors Shop Slot 3",
        "Scaraba - Indoors Shop Slot 4",
        "Scaraba - Indoors Shop Slot 5",
        "Scaraba - Indoors Shop Slot 6",
        "Scaraba Hotel - Arms Dealer Slot 1",
        "Scaraba Hotel - Arms Dealer Slot 2",
        "Scaraba Hotel - Arms Dealer Slot 3",
        "Scaraba Hotel - Arms Dealer Slot 4",
        "Scaraba - Southern Camel Shop Slot 1",
        "Scaraba - Southern Camel Shop Slot 2",
        "Scaraba - Southern Camel Shop Slot 3",
        "Scaraba - Southern Camel Shop Slot 4",
        "Scaraba - Southern Camel Shop Slot 5",
        "Scaraba - Southern Camel Shop Slot 6",
        "Scaraba - Southern Camel Shop Slot 7"
    },

    "the Pyramid": {
        "Pyramid - Anteroom Sarcophagus",
        "Pyramid - Northwest Door Sarcophagus",
        "Pyramid - Hallway Sarcophagus #1",
        "Pyramid - Hallway Sarcophagus #2",
        "Pyramid - Switch Room Sarcophagus",
        "Pyramid - Pedestal Item",
        "Pyramid - Way Out Sarcophagus"
    },

    "Dungeon Man 1F": {
        "Dungeon Man - 1F Dead End Present",
        "Dungeon Man - 1F Long Walk Present",
        "Dungeon Man - 1F Disappointing Present",
        "Dungeon Man - 1F Opinion Present",
        "Dungeon Man - 1F No Sign Present",
        "Dungeon Man - 1F Exit Ledge Present"
    },

    "Dungeon Man 2F": {
        "Dungeon Man - 2F Unnecessary Billboard Present",
        "Dungeon Man - 2F Dungeon Exploration Present",
        "Dungeon Man - 2F South Ledge Present",
        "Dungeon Man - 2F North Alcove Present",
        "Dungeon Man - 2F Hole Present"
    },

    "Dungeon Man 3F": {
        "Dungeon Man - 3F Present"
    },

    "Deep Darkness": {
        "Deep Darkness - Teleporting Monkey",
        "Deep Darkness - Crest of Darkness Present",
        "Deep Darkness - Helicopter Present",
        "Deep Darkness - Yellow Bird Present",
        "Deep Darkness - Swamp Present",
        "Deep Darkness - Corner Present",
        "Deep Darkness - Alcove Present",
        "Deep Darkness - Barf Character",
        "Deep Darkness - Businessman Slot 1",
        "Deep Darkness - Businessman Slot 2",
        "Deep Darkness - Businessman Slot 3",
        "Deep Darkness - Businessman Slot 4",
        "Deep Darkness - Businessman Slot 5",
        "Deep Darkness - Businessman Slot 6",
        "Deep Darkness - Businessman Slot 7",
        "Deep Darkness - Arms Dealer Slot 1",
        "Deep Darkness - Arms Dealer Slot 2",
        "Deep Darkness - Arms Dealer Slot 3",
        "Deep Darkness - Arms Dealer Slot 4"
    },

    "Deep Darkness Truffles": {
        "Deep Darkness - North Alcove Truffle",
        "Deep Darkness - Near Land Truffle",
        "Deep Darkness - Present Truffle",
        "Deep Darkness - Village Truffle",
        "Deep Darkness - Entrance Truffle"
    },

    "Tenda Village": {
        "Tenda Village - Trashcan",
        "Tenda Village - Tenda Tea",
        "Tenda Village - Tenda Gift",
        "Tenda Village - Tenda Gift #2"
    },

    "Lumine Hall 1F": {
        "Lumine Hall - 1F North Path Present",
        "Lumine Hall - 1F Above Belly Button Present",
        "Lumine Hall - 1F Near Exit Present",
        "Lumine Hall - 1F Dead End Present"
    },

    "Lumine Hall B1F": {
        "Lumine Hall - B1F Non-Talkative Rock Present",
        "Lumine Hall - B1F Thankful Rock Corner Present",
        "Lumine Hall - B1F Thankful Rock Junction Present",
        "Lumine Hall - B1F Belly Button Present",
        "Lumine Hall - B1F West Alcove Present"
    },
    
    "Lost Underworld": {
        "Lost Underworld - Talking Rock",
        "Lost Underworld - East Present",
        "Lost Underworld - Northeast Present",
        "Lost Underworld - Northeast of Tenda Tribe Present",
        "Lost Underworld - Southwest of Tenda Tribe Present",
        "Lost Underworld - Evacuation Present",
        "Lost Underworld - Tenda Camp Shop Slot 1",
        "Lost Underworld - Tenda Camp Shop Slot 2",
        "Lost Underworld - Tenda Camp Shop Slot 3",
        "Lost Underworld - Tenda Camp Shop Slot 4",
        "Lost Underworld - Tenda Camp Shop Slot 5",
        "Lost Underworld - Tenda Camp Shop Slot 6",
        "Lost Underworld - Tenda Camp Shop Slot 7"
    },

    "Fire Spring": {
        "Fire Spring - 1st Cave Present",
        "Fire Spring - East Corner Present",
        "Fire Spring - Volcano Present",
        "Fire Spring - Lone Cave Present",
        "Fire Spring - Upper Volcano Present"
    },

    "Magicant": {
        "Magicant - Ness's Gift",
        "Magicant - Present Near Ness",
        "Magicant - Lonely Present",
        "Magicant - North Present",
        "Magicant - Hills Present",
        "Magicant - Town Present",
        "Magicant - Shop Slot 1",
        "Magicant - Shop Slot 2"
    },
    

    "Sea of Eden": {
        "Magicant - Ness's Nightmare"
    },

    "Cave of the Present": {
        "Cave of the Present - Star Master",
        "Cave of the Present - Broken Phase Distorter"
    },

    "Cave of the Past": {
        "Cave of the Past - Present"
    },
    
    "Burglin Park": {
        "Burglin Park Junk Shop - Slot 1",
        "Burglin Park Junk Shop - Slot 2",
        "Burglin Park Junk Shop - Slot 3",
        "Burglin Park Junk Shop - Slot 4",
        "Burglin Park Junk Shop - Slot 5",
        "Burglin Park Junk Shop - Slot 6",
        "Burglin Park Bread Stand - Slot 1",
        "Burglin Park Bread Stand - Slot 2",
        "Burglin Park Bread Stand - Slot 3",
        "Burglin Park Bread Stand - Slot 4",
        "Burglin Park Bread Stand - Slot 5",
        "Burglin Park Bread Stand - Slot 6",
        "Burglin Park - Banana Stand",
        "Twoson - Everdred Meeting",
        "Twoson - Apple Kid Invention",
        "Twoson/Scaraba - Shared Condiment Shop Slot 1",
        "Twoson/Scaraba - Shared Condiment Shop Slot 2",
        "Twoson/Scaraba - Shared Condiment Shop Slot 3",
        "Twoson/Scaraba - Shared Condiment Shop Slot 4",
        "Twoson/Scaraba - Shared Condiment Shop Slot 5",
        "Twoson/Scaraba - Shared Condiment Shop Slot 6",
        "Twoson/Scaraba - Shared Condiment Shop Slot 7"
    },

    "the Scaraba Bazaar": {
        "Scaraba Bazaar - Delicacy Shop Slot 1",
        "Scaraba Bazaar - Delicacy Shop Slot 2",
        "Scaraba Bazaar - Delicacy Shop Slot 3",
        "Scaraba Bazaar - Delicacy Shop Slot 4",
        "Scaraba Bazaar - Delicacy Shop Slot 5",
        "Scaraba Bazaar - Delicacy Shop Slot 6",
        "Scaraba Bazaar - Delicacy Shop Slot 7",
        "Twoson/Scaraba - Shared Condiment Shop Slot 1",
        "Twoson/Scaraba - Shared Condiment Shop Slot 2",
        "Twoson/Scaraba - Shared Condiment Shop Slot 3",
        "Twoson/Scaraba - Shared Condiment Shop Slot 4",
        "Twoson/Scaraba - Shared Condiment Shop Slot 5",
        "Twoson/Scaraba - Shared Condiment Shop Slot 6",
        "Twoson/Scaraba - Shared Condiment Shop Slot 7",
        "Scaraba Bazaar - Red Snake Carpet Slot 1",
        "Scaraba Bazaar - Red Snake Carpet Slot 2",
        "Scaraba Bazaar - Red Snake Carpet Slot 3",
        "Scaraba Bazaar - Bottom Left Carpet Slot 1",
        "Scaraba Bazaar - Bottom Left Carpet Slot 2",
        "Scaraba Bazaar - Bottom Left Carpet Slot 3",
        "Scaraba Bazaar - Bottom Left Carpet Slot 4",
        "Scaraba Bazaar - Bottom Left Carpet Slot 5",
        "Scaraba Bazaar - Bottom Left Carpet Slot 6"
    },

    "the Twoson Department Store": {
        "Twoson Department Store Burger Shop - Slot 1",
        "Twoson Department Store Burger Shop - Slot 2",
        "Twoson Department Store Burger Shop - Slot 3",
        "Twoson Department Store Burger Shop - Slot 4",
        "Twoson Department Store Bakery - Slot 1",
        "Twoson Department Store Bakery - Slot 2",
        "Twoson Department Store Bakery - Slot 3",
        "Twoson Department Store Bakery - Slot 4",
        "Twoson Department Store Top Floor - Right Counter Slot 1",
        "Twoson Department Store Top Floor - Right Counter Slot 2",
        "Twoson Department Store Top Floor - Right Counter Slot 3",
        "Twoson Department Store Top Floor - Right Counter Slot 4",
        "Twoson Department Store Top Floor - Right Counter Slot 5",
        "Twoson Department Store Top Floor - Right Counter Slot 6",
        "Twoson Department Store Top Floor - Left Counter Slot 1",
        "Twoson Department Store Top Floor - Left Counter Slot 2"
    },
    
    "the Fourside Department Store": {
        "Fourside Department Store - Tool Shop Slot 1",
        "Fourside Department Store - Tool Shop Slot 2",
        "Fourside Department Store - Tool Shop Slot 3",
        "Fourside Department Store - Tool Shop Slot 4",
        "Fourside Department Store - Tool Shop Slot 5",
        "Fourside Department Store - Tool Shop Slot 6",
        "Fourside Department Store - Tool Shop Slot 7",
        "Fourside Department Store - Shop Shop Slot 1",
        "Fourside Department Store - Shop Shop Slot 2",
        "Fourside Department Store - Shop Shop Slot 3",
        "Fourside Department Store - Shop Shop Slot 4",
        "Fourside Department Store - Food Shop Slot 1",
        "Fourside Department Store - Food Shop Slot 2",
        "Fourside Department Store - Food Shop Slot 3",
        "Fourside Department Store - Food Shop Slot 4",
        "Fourside Department Store - Food Shop Slot 5",
        "Fourside Department Store - 2F Cart Slot 1",
        "Fourside Department Store - 2F Cart Slot 2",
        "Fourside Department Store - 2F Cart Slot 3",
        "Fourside Department Store - 2F Cart Slot 4",
        "Fourside Department Store - 2F Cart Slot 5",
        "Fourside Department Store - 2F Cart Slot 6",
        "Fourside Department Store - 2F Cart Slot 7",
        "Fourside Department Store - Toys Shop Slot 1",
        "Fourside Department Store - Toys Shop Slot 2",
        "Fourside Department Store - Toys Shop Slot 3",
        "Fourside Department Store - Toys Shop Slot 4",
        "Fourside Department Store - Toys Shop Slot 5",
        "Fourside Department Store - Toys Shop Slot 6",
        "Fourside Department Store - Sports Shop Slot 1",
        "Fourside Department Store - Sports Shop Slot 2",
        "Fourside Department Store - Sports Shop Slot 3",
        "Fourside Department Store - Sports Shop Slot 4",
        "Fourside Department Store - Burger Shop Slot 1",
        "Fourside Department Store - Burger Shop Slot 2",
        "Fourside Department Store - Burger Shop Slot 3",
        "Fourside Department Store - Burger Shop Slot 4",
        "Fourside Department Store - Burger Shop Slot 5",
        "Fourside Department Store - Arms Dealer Slot 1",
        "Fourside Department Store - Arms Dealer Slot 2",
        "Fourside Department Store - Arms Dealer Slot 3",
        "Fourside Department Store - Arms Dealer Slot 4",
        "Fourside Department Store - Arms Dealer Slot 5"
    },

    "the Saturn Valley Shop": {
        "Saturn Valley Shop - Center Saturn Slot 1",
        "Saturn Valley Shop - Center Saturn Slot 2",
        "Saturn Valley Shop - Center Saturn Slot 3",
        "Saturn Valley Shop - Center Saturn Slot 4",
        "Saturn Valley Shop - Center Saturn Slot 5",
        "Saturn Valley Shop - Post-Belch Saturn Slot 1",
        "Saturn Valley Shop - Post-Belch Saturn Slot 2",
        "Saturn Valley Shop - Post-Belch Saturn Slot 3",
        "Saturn Valley Shop - Post-Belch Saturn Slot 4",
        "Saturn Valley Shop - Top Saturn Slot 1",
        "Saturn Valley Shop - Top Saturn Slot 2",
        "Saturn Valley Shop - Top Saturn Slot 3",
        "Saturn Valley Shop - Top Saturn Slot 4",
        "Saturn Valley Shop - Top Saturn Slot 5",
        "Saturn Valley Shop - Top Saturn Slot 6",
        "Saturn Valley Shop - Top Saturn Slot 7"
    }
}
