from typing import Dict, Set, NamedTuple, Optional
from BaseClasses import ItemClassification


class ItemData(NamedTuple):
    category: str
    code: Optional[int]
    classification: ItemClassification
    amount: int = 1


item_table: Dict[str, ItemData] = {
    "Franklin Badge": ItemData("Key Items", 0xEB0001, ItemClassification.progression),
    "Teddy Bear": ItemData("Characters", 0xEB0002, ItemClassification.filler, 0),
    "Super Plush Bear": ItemData("Characters", 0xEB0003, ItemClassification.useful, 0),

    "Broken Machine": ItemData("Broken Items", 0xEB0004, ItemClassification.useful, 0),
    "Broken Gadget": ItemData("Jeff Weapons", 0xEB0005, ItemClassification.useful, 0),
    "Broken Air Gun": ItemData("Jeff Weapons", 0xEB0006, ItemClassification.filler, 0),
    "Broken Spray Can": ItemData("Broken Items", 0xEB0007, ItemClassification.filler, 0),
    "Broken Laser": ItemData("Jeff Weapons", 0xEB0008, ItemClassification.useful, 0),
    "Broken Iron": ItemData("Broken Items", 0xEB0009, ItemClassification.filler, 0),
    "Broken Pipe": ItemData("Broken Items", 0xEB000A, ItemClassification.useful, 0),
    "Broken Cannon": ItemData("Jeff Weapons", 0xEB000B, ItemClassification.useful, 0),
    "Broken Tube": ItemData("Broken Items", 0xEB000C, ItemClassification.useful, 0),
    "Broken Bazooka": ItemData("Broken Items", 0xEB000D, ItemClassification.useful, 0),
    "Broken Trumpet": ItemData("Broken Items", 0xEB000E, ItemClassification.filler, 0),
    "Broken Harmonica": ItemData("Jeff Weapons", 0xEB000F, ItemClassification.useful, 0),
    "Broken Antenna": ItemData("Jeff Weapons", 0xEB0010, ItemClassification.useful, 0),

    "Cracked Bat": ItemData("Ness Weapons", 0xEB0011, ItemClassification.filler, 0),
    "Tee Ball Bat": ItemData("Ness Weapons", 0xEB0012, ItemClassification.filler, 0),
    "Sand Lot Bat": ItemData("Ness Weapons", 0xEB0013, ItemClassification.filler, 0),
    "Minor League Bat": ItemData("Ness Weapons", 0xEB0014, ItemClassification.filler, 0),
    "Mr. Baseball Bat": ItemData("Ness Weapons", 0xEB0015, ItemClassification.useful, 0),
    "Big League Bat": ItemData("Ness Weapons", 0xEB00D5, ItemClassification.useful, 0),
    "Hall of Fame Bat": ItemData("Ness Weapons", 0xEB0017, ItemClassification.useful, 0),
    "Magicant Bat": ItemData("Ness Weapons", 0xEB0018, ItemClassification.useful),
    "Legendary Bat": ItemData("Ness Weapons", 0xEB0019, ItemClassification.useful),
    "Gutsy Bat": ItemData("Ness Weapons", 0xEB001A, ItemClassification.useful, 0),
    "Casey Bat": ItemData("Ness Weapons", 0xEB001B, ItemClassification.filler, 0),

    "Fry Pan": ItemData("Paula Weapons", 0xEB001C, ItemClassification.filler, 0),
    "Thick Fry Pan": ItemData("Paula Weapons", 0xEB001D, ItemClassification.filler, 0),
    "Deluxe Fry Pan": ItemData("Paula Weapons", 0xEB001E, ItemClassification.filler, 0),
    "Chef's Fry Pan": ItemData("Paula Weapons", 0xEB001F, ItemClassification.useful, 0),
    "French Fry Pan": ItemData("Paula Weapons", 0xEB0020, ItemClassification.useful, 0),
    "Magic Fry Pan": ItemData("Paula Weapons", 0xEB0021, ItemClassification.useful, 0),
    "Holy Fry Pan": ItemData("Paula Weapons", 0xEB0022, ItemClassification.useful, 0),

    "Sword of Kings": ItemData("Poo Weapons", 0xEB0023, ItemClassification.useful, 0),

    "Pop Gun": ItemData("Jeff Weapons", 0xEB0024, ItemClassification.filler),
    "Stun Gun": ItemData("Jeff Weapons", 0xEB0025, ItemClassification.filler),
    "Toy Air Gun": ItemData("Jeff Weapons", 0xEB0026, ItemClassification.filler, 0),
    "Magnum Air Gun": ItemData("Jeff Weapons", 0xEB0027, ItemClassification.filler, 0),
    "Zip Gun": ItemData("Jeff Weapons", 0xEB0028, ItemClassification.filler, 0),
    "Laser Gun": ItemData("Jeff Weapons", 0xEB0029, ItemClassification.filler, 0),
    "Hyper Beam": ItemData("Jeff Weapons", 0xEB002A, ItemClassification.useful, 0),
    "Crusher Beam": ItemData("Jeff Weapons", 0xEB002B, ItemClassification.useful, 0),
    "Spectrum Beam": ItemData("Jeff Weapons", 0xEB002C, ItemClassification.useful, 0),
    "Death Ray": ItemData("Jeff Weapons", 0xEB002D, ItemClassification.useful),
    "Baddest Beam": ItemData("Jeff Weapons", 0xEB002E, ItemClassification.useful, 0),
    "Moon Beam Gun": ItemData("Jeff Weapons", 0xEB002F, ItemClassification.useful),
    "Gaia Beam": ItemData("Jeff Weapons", 0xEB0030, ItemClassification.useful, 0),

    "Yo-yo": ItemData("Alt Weapons", 0xEB0031, ItemClassification.filler, 0),
    "Slingshot": ItemData("Alt Weapons", 0xEB0032, ItemClassification.filler, 0),
    "Bionic Slingshot": ItemData("Alt Weapons", 0xEB0033, ItemClassification.filler, 0),
    "Trick Yo-yo": ItemData("Alt Weapons", 0xEB0034, ItemClassification.filler, 0),
    "Combat Yo-yo": ItemData("Alt Weapons", 0xEB0035, ItemClassification.filler, 0),

    "Travel Charm": ItemData("Body Equipment", 0xEB0036, ItemClassification.filler),
    "Great Charm": ItemData("Body Equipment", 0xEB0037, ItemClassification.filler),
    "Crystal Charm": ItemData("Body Equipment", 0xEB0038, ItemClassification.filler, 0),
    "Rabbit's Foot": ItemData("Body Equipment", 0xEB0039, ItemClassification.useful),
    "Flame Pendant": ItemData("Body Equipment", 0xEB003A, ItemClassification.useful),
    "Rain Pendant": ItemData("Body Equipment", 0xEB003B, ItemClassification.useful),
    "Night Pendant": ItemData("Body Equipment", 0xEB003C, ItemClassification.useful),
    "Sea Pendant": ItemData("Body Equipment", 0xEB003D, ItemClassification.useful),
    "Star Pendant": ItemData("Body Equipment", 0xEB003E, ItemClassification.useful, 0),
    "Cloak of Kings": ItemData("Poo Equipment", 0xEB003F, ItemClassification.useful),

    "Cheap Bracelet": ItemData("Arm Equipment", 0xEB0040, ItemClassification.filler, 0),
    "Copper Bracelet": ItemData("Arm Equipment", 0xEB0041, ItemClassification.filler, 0),
    "Silver Bracelet": ItemData("Arm Equipment", 0xEB0042, ItemClassification.filler, 0),
    "Gold Bracelet": ItemData("Arm Equipment", 0xEB0043, ItemClassification.filler, 0),
    "Platinum Band": ItemData("Arm Equipment", 0xEB00D8, ItemClassification.useful),
    "Diamond Band": ItemData("Arm Equipment", 0xEB00D9, ItemClassification.useful),
    "Pixie's Bracelet": ItemData("Arm Equipment", 0xEB0046, ItemClassification.useful),
    "Cherub's Band": ItemData("Arm Equipment", 0xEB0047, ItemClassification.useful),
    "Goddess Band": ItemData("Arm Equipment", 0xEB0048, ItemClassification.useful),
    "Bracer of Kings": ItemData("Poo Equipment", 0xEB0049, ItemClassification.useful),

    "Baseball Cap": ItemData("Other Equipment", 0xEB004A, ItemClassification.filler, 0),
    "Holmes Hat": ItemData("Other Equipment", 0xEB004B, ItemClassification.filler, 0),
    "Mr. Baseball Cap": ItemData("Other Equipment", 0xEB004C, ItemClassification.filler, 0),
    "Hard Hat": ItemData("Other Equipment", 0xEB004D, ItemClassification.filler, 0),
    "Ribbon": ItemData("Ribbons", 0xEB004E, ItemClassification.filler, 0),
    "Red Ribbon": ItemData("Ribbons", 0xEB004F, ItemClassification.filler, 0),
    "Goddess Ribbon": ItemData("Ribbons", 0xEB0050, ItemClassification.useful, 0),
    "Coin of Slumber": ItemData("Other Equipment", 0xEB0051, ItemClassification.useful),
    "Coin of Defense": ItemData("Other Equipment", 0xEB0052, ItemClassification.useful, 0),
    "Lucky Coin": ItemData("Other Equipment", 0xEB0053, ItemClassification.useful, 0),
    "Talisman Coin": ItemData("Other Equipment", 0xEB0054, ItemClassification.useful, 0),
    "Shiny Coin": ItemData("Other Equipment", 0xEB0055, ItemClassification.useful, 0),
    "Souvenir Coin": ItemData("Other Equipment", 0xEB0056, ItemClassification.useful),
    "Diadem of Kings": ItemData("Poo Equipment", 0xEB0057, ItemClassification.useful),

    "Cookie": ItemData("Food", 0xEB0058, ItemClassification.filler, 0),
    "Bag of Fries": ItemData("Food", 0xEB0059, ItemClassification.filler, 0),
    "Hamburger": ItemData("Food", 0xEB005A, ItemClassification.filler, 0),
    "Boiled Egg": ItemData("Food", 0xEB005B, ItemClassification.filler, 0),
    "Fresh Egg": ItemData("Food", 0xEB005C, ItemClassification.filler, 0),
    "Picnic Lunch": ItemData("Food", 0xEB005D, ItemClassification.filler, 0),
    "Pasta di Summers": ItemData("Food", 0xEB005E, ItemClassification.filler, 0),
    "Pizza": ItemData("Food", 0xEB005F, ItemClassification.filler, 0),
    "Chef's Special": ItemData("Food", 0xEB0060, ItemClassification.filler, 0),
    "Large Pizza": ItemData("Food", 0xEB0061, ItemClassification.filler, 0),
    "PSI Caramel": ItemData("Food", 0xEB0062, ItemClassification.useful, 0),
    "Magic Truffle": ItemData("Food", 0xEB0063, ItemClassification.useful, 0),
    "Brain Food Lunch": ItemData("Food", 0xEB0064, ItemClassification.useful, 0),
    "Rock Candy": ItemData("Food", 0xEB0065, ItemClassification.useful, 0),
    "Croissant": ItemData("Food", 0xEB0066, ItemClassification.filler, 0),
    "Bread Roll": ItemData("Food", 0xEB0067, ItemClassification.filler, 0),
    
    "Pak of Bubble Gum": ItemData("Key Items", 0xEB0068, ItemClassification.progression),
    "Jar of Fly Honey": ItemData("Key Items", 0xEB0069, ItemClassification.progression),

    "Can of Fruit Juice": ItemData("Food", 0xEB006A, ItemClassification.filler, 0),
    "Royal Iced Tea": ItemData("Food", 0xEB006B, ItemClassification.filler, 0),
    "Protein Drink": ItemData("Food", 0xEB006C, ItemClassification.filler, 0),
    "Kraken Soup": ItemData("Food", 0xEB006D, ItemClassification.filler, 0),
    "Bottle of Water": ItemData("Food", 0xEB006E, ItemClassification.filler, 0),
    "Cold Remedy": ItemData("Status Heal", 0xEB006F, ItemClassification.filler, 0),
    "Vial of Serum": ItemData("Status Heal", 0xEB0070, ItemClassification.filler, 0),
    "IQ Capsule": ItemData("Food", 0xEB0071, ItemClassification.useful, 0),
    "Guts Capsule": ItemData("Food", 0xEB0072, ItemClassification.useful, 0),
    "Speed Capsule": ItemData("Food", 0xEB0073, ItemClassification.useful, 0),
    "Vital Capsule": ItemData("Food", 0xEB0074, ItemClassification.useful, 0),
    "Luck Capsule": ItemData("Food", 0xEB0075, ItemClassification.useful, 0),
    "Ketchup Packet": ItemData("Condiments", 0xEB0076, ItemClassification.filler, 0),
    "Sugar Packet": ItemData("Condiments", 0xEB0077, ItemClassification.filler, 0),
    "Tin of Cocoa": ItemData("Condiments", 0xEB0078, ItemClassification.filler, 0),
    "Carton of Cream": ItemData("Condiments", 0xEB0079, ItemClassification.filler, 0),
    "Sprig of Parsley": ItemData("Condiments", 0xEB007A, ItemClassification.filler, 0),
    "Jar of Hot Sauce": ItemData("Condiments", 0xEB007B, ItemClassification.filler, 0),
    "Salt Packet": ItemData("Condiments", 0xEB007C, ItemClassification.filler, 0),
    "Tiny Key": ItemData("Key Items", 0xEB007D, ItemClassification.progression),  # Progressive Gun
    "Jar of Delisauce": ItemData("Condiments", 0xEB007E, ItemClassification.useful, 0),
    "Wet Towel": ItemData("Status Heal", 0xEB007F, ItemClassification.filler, 0),
    "Refreshing Herb": ItemData("Status Heal", 0xEB0080, ItemClassification.useful, 0),
    "Secret Herb": ItemData("Status Heal", 0xEB0081, ItemClassification.useful, 0),
    "Horn of Life": ItemData("Status Heal", 0xEB0082, ItemClassification.useful, 0),

    "Counter-PSI Unit": ItemData("Jeff Items", 0xEB0083, ItemClassification.useful, 0),
    "Shield Killer": ItemData("Jeff Items", 0xEB0084, ItemClassification.useful, 0),
    "Bazooka": ItemData("Jeff Items", 0xEB0085, ItemClassification.useful, 0),
    "Heavy Bazooka": ItemData("Jeff Items", 0xEB0086, ItemClassification.useful, 0),
    "HP-Sucker": ItemData("Jeff Items", 0xEB0087, ItemClassification.useful),
    "Hungry HP-Sucker": ItemData("Jeff Items", 0xEB0088, ItemClassification.useful, 0),
    "Xterminator Spray": ItemData("Battle Items", 0xEB0089, ItemClassification.useful, 0),
    "Slime Generator": ItemData("Jeff Items", 0xEB008A, ItemClassification.useful, 0),
    "Yogurt Dispenser": ItemData("Key Items", 0xEB008B, ItemClassification.progression),

    "Ruler": ItemData("Battle Items", 0xEB008C, ItemClassification.filler, 0),
    "Snake Bag": ItemData("Battle Items", 0xEB008D, ItemClassification.filler, 0),
    "Mummy Wrap": ItemData("Battle Items", 0xEB008E, ItemClassification.filler, 0),
    "Protractor": ItemData("Battle Items", 0xEB008F, ItemClassification.filler, 0),
    "Bottle Rocket": ItemData("Jeff Items", 0xEB0090, ItemClassification.filler, 0),
    "Big Bottle Rocket": ItemData("Jeff Items", 0xEB0091, ItemClassification.useful, 0),
    "Multi Bottle Rocket": ItemData("Jeff Items", 0xEB0092, ItemClassification.useful, 0),
    "Bomb": ItemData("Battle Items", 0xEB0093, ItemClassification.filler, 0),
    "Super Bomb": ItemData("Battle Items", 0xEB0094, ItemClassification.useful, 0),
    "Insecticide Spray": ItemData("Battle Items", 0xEB0095, ItemClassification.filler, 0),
    "Rust Promoter": ItemData("Battle Items", 0xEB0096, ItemClassification.filler, 0),
    "Rust Promoter DX": ItemData("Battle Items", 0xEB0097, ItemClassification.useful, 0),
    "Pair of Dirty Socks": ItemData("Battle Items", 0xEB0098, ItemClassification.filler, 0),
    "Stag Beetle": ItemData("Battle Items", 0xEB0099, ItemClassification.filler, 0),
    "Toothbrush": ItemData("Battle Items", 0xEB009A, ItemClassification.filler, 0),
    "Handbag Strap": ItemData("Battle Items", 0xEB009B, ItemClassification.filler, 0),
    "Pharaoh's Curse": ItemData("Battle Items", 0xEB009C, ItemClassification.filler, 0),
    "Defense Shower": ItemData("Battle Items", 0xEB009D, ItemClassification.useful, 0),

    "UFO Engine": ItemData("Key Items", 0xEB009E, ItemClassification.progression),
    "Sudden Guts Pill": ItemData("Battle Items", 0xEB009F, ItemClassification.useful, 0),
    "Bag of Dragonite": ItemData("Battle Items", 0xEB00A0, ItemClassification.useful, 0),
    "Defense Spray": ItemData("Battle Items", 0xEB00A1, ItemClassification.filler, 0),

    "Piggy Nose": ItemData("Key Items", 0xEB00A2, ItemClassification.progression),
    "For Sale Sign": ItemData("Field Items", 0xEB00A3, ItemClassification.filler),
    "Shyness Book": ItemData("Key Items", 0xEB00A4, ItemClassification.progression),
    "Picture Postcard": ItemData("Field Items", 0xEB00A5, ItemClassification.filler, 0),
    "King Banana": ItemData("Key Items", 0xEB00A6, ItemClassification.progression),
    "Letter For Tony": ItemData("Key Items", 0xEB00A7, ItemClassification.progression),
    "Chick": ItemData("Field Items", 0xEB00A8, ItemClassification.filler, 0),
    "Chicken": ItemData("Field Items", 0xEB00A9, ItemClassification.filler, 0),
    "Key to the Shack": ItemData("Key Items", 0xEB00AA, ItemClassification.progression),
    "Key to the Cabin": ItemData("Key Items", 0xEB00AB, ItemClassification.progression),
    "Bad Key Machine": ItemData("Key Items", 0xEB00AC, ItemClassification.progression),
    # "Archipelago Item": ItemData("Key Items", 0xEB00AD, ItemClassification.progression, 0),
    "Zombie Paper": ItemData("Key Items", 0xEB00AE, ItemClassification.progression),
    "Hawk Eye": ItemData("Key Items", 0xEB00AF, ItemClassification.progression),
    "Bicycle": ItemData("Key Items", 0xEB00B0, ItemClassification.useful),
    "ATM Card": ItemData("Key Items", 0xEB00B1, ItemClassification.progression, 0),
    "Show Ticket": ItemData("Key Items", 0xEB00B2, ItemClassification.filler, 0),
    "Tenda Lavapants": ItemData("Key Items", 0xEB00B3, ItemClassification.progression),  # Progressive Bat
    "Wad of Bills": ItemData("Key Items", 0xEB00B4, ItemClassification.progression),
    "Warp Pad": ItemData("Key Items", 0xEB00B5, ItemClassification.progression, 0),
    "Diamond": ItemData("Key Items", 0xEB00B6, ItemClassification.progression),
    "Signed Banana": ItemData("Key Items", 0xEB00B7, ItemClassification.progression),
    "Pencil Eraser": ItemData("Key Items", 0xEB00B8, ItemClassification.progression),
    "Hieroglyph Copy": ItemData("Key Items", 0xEB00B9, ItemClassification.progression),
    "Meteotite": ItemData("Field Items", 0xEB00BA, ItemClassification.useful, 0),
    "Contact Lens": ItemData("Key Items", 0xEB00BB, ItemClassification.progression),

    "Hand-Aid": ItemData("Food", 0xEB00BC, ItemClassification.useful),
    "Trout Yogurt": ItemData("Food", 0xEB00BD, ItemClassification.filler, 0),
    "Banana": ItemData("Food", 0xEB00BE, ItemClassification.filler, 0),
    "Calorie Stick": ItemData("Food", 0xEB00BF, ItemClassification.filler, 0),
    "Key to the Tower": ItemData("Key Items", 0xEB00C0, ItemClassification.progression),
    "Meteorite Piece": ItemData("Key Items", 0xEB00C1, ItemClassification.progression),

    "Earth Pendant": ItemData("Body Equipment", 0xEB00C2, ItemClassification.useful, 0),
    "Neutralizer": ItemData("Jeff Items", 0xEB00C3, ItemClassification.useful),
    "Sound Stone": ItemData("Key Items", 0xEB00C4, ItemClassification.progression, 0),
    "Exit Mouse": ItemData("Key Items", 0xEB00C5, ItemClassification.useful, 0),

    "Gelato de Resort": ItemData("Food", 0xEB00C6, ItemClassification.filler, 0),
    "Snake": ItemData("Battle Items", 0xEB00C7, ItemClassification.filler, 0),
    "Viper": ItemData("Battle Items", 0xEB00C8, ItemClassification.filler, 0),
    "Brain Stone": ItemData("Battle Items", 0xEB00C9, ItemClassification.filler),
    "Police Badge": ItemData("Key Items", 0xEB00CA, ItemClassification.progression),
    "Mining Permit": ItemData("Key Items", 0xEB00CB, ItemClassification.progression),
    "Suporma": ItemData("Field Items", 0xEB00CC, ItemClassification.trap),
    "Key to the Locker": ItemData("Key Items", 0xEB00CD, ItemClassification.progression),
    "Insignificant Item": ItemData("Key Items", 0xEB00CE, ItemClassification.progression),
    "Magic Tart": ItemData("Food", 0xEB00CF, ItemClassification.useful, 0),
    "Tiny Ruby": ItemData("Key Items", 0xEB00D0, ItemClassification.progression),
    "Monkey's Love": ItemData("Battle Items", 0xEB00D1, ItemClassification.useful),
    "Eraser Eraser": ItemData("Key Items", 0xEB00D2, ItemClassification.progression),
    "Tendakraut": ItemData("Key Items", 0xEB00D3, ItemClassification.progression),

    "T-Rex's Bat": ItemData("Ness Weapons", 0xEB00D4, ItemClassification.useful, 0),
    # "Big League Bat": ItemData("Ness Weapons", 0xEB0016, ItemClassification.useful, 0), Summers copy
    "Ultimate Bat": ItemData("Ness Weapons", 0xEB00D6, ItemClassification.useful, 0),
    "Double Beam": ItemData("Jeff Weapons", 0xEB00D7, ItemClassification.useful, 0),
    # "Platinum Band": ItemData("Arm Equipment", 0xEB00D8, ItemClassification.useful, 0), Summers copy
    # "Diamond Band": ItemData("Arm Equipment", 0xEB00D9, ItemClassification.useful, 0), Summers Copy
    "Defense Ribbon": ItemData("Ribbons", 0xEB00DA, ItemClassification.useful, 0),
    "Talisman Ribbon": ItemData("Ribbons", 0xEB00DB, ItemClassification.useful),
    "Saturn Ribbon": ItemData("Ribbons", 0xEB00DC, ItemClassification.useful),
    "Coin of Silence": ItemData("Other Equipment", 0xEB00DD, ItemClassification.useful, 0),
    "Charm Coin": ItemData("Other Equipment", 0xEB00DE, ItemClassification.useful, 0),

    "Cup of Noodles": ItemData("Food", 0xEB00DF, ItemClassification.filler, 0),
    "Repel Sandwich": ItemData("Food", 0xEB00E0, ItemClassification.useful, 0),
    "Repel Superwich": ItemData("Food", 0xEB00E1, ItemClassification.useful, 0),
    "Lucky Sandwich": ItemData("Food", 0xEB00E2, ItemClassification.useful, 0),
    "Progressive Bat": ItemData("Progressive Equipment", 0xEB00E3, ItemClassification.useful, 0), 
    "Progressive Fry Pan": ItemData("Progressive Equipment", 0xEB00E4, ItemClassification.useful, 0),
    "Progressive Gun": ItemData("Progressive Equipment", 0xEB00E5, ItemClassification.useful, 0),
    "Progressive Bracelet": ItemData("Progressive Equipment", 0xEB00E6, ItemClassification.useful, 0),
    "Progressive Other": ItemData("Progressive Equipment", 0xEB00E7, ItemClassification.useful, 0),

    "Cup of Coffee": ItemData("Food", 0xEB00E8, ItemClassification.filler, 0),
    "Double Burger": ItemData("Food", 0xEB00E9, ItemClassification.filler, 0),
    "Peanut Cheese Bar": ItemData("Food", 0xEB00EA, ItemClassification.filler, 0),
    "Piggy Jelly": ItemData("Food", 0xEB00EB, ItemClassification.filler, 0),
    "Bowl of Rice Gruel": ItemData("Food", 0xEB00EC, ItemClassification.filler, 0),
    "Bean Croquette": ItemData("Food", 0xEB00ED, ItemClassification.filler, 0),
    "Molokheiya Soup": ItemData("Food", 0xEB00EE, ItemClassification.filler, 0),
    "Plain Roll": ItemData("Food", 0xEB00EF, ItemClassification.filler, 0),
    "Kabob": ItemData("Food", 0xEB00F0, ItemClassification.filler, 0),
    "Plain Yogurt": ItemData("Food", 0xEB00F1, ItemClassification.filler, 0),
    "Beef Jerky": ItemData("Food", 0xEB00F2, ItemClassification.filler, 0),
    "Mammoth Burger": ItemData("Food", 0xEB00F3, ItemClassification.filler, 0),
    "Spicy Jerky": ItemData("Food", 0xEB00F4, ItemClassification.filler, 0),
    "Luxury Jerky": ItemData("Food", 0xEB00F5, ItemClassification.filler, 0),
    "Bottle of DXwater": ItemData("Food", 0xEB00F6, ItemClassification.useful, 0),
    "Magic Pudding": ItemData("Food", 0xEB00F7, ItemClassification.useful, 0),

    "Non-Stick Frypan": ItemData("Paula Weapons", 0xEB00F8, ItemClassification.useful, 0),
    "Mr. Saturn Coin": ItemData("Other Equipment", 0xEB00F9, ItemClassification.useful),
    "Meteornium": ItemData("Field Items", 0xEB00FA, ItemClassification.useful, 0),
    "Popsicle": ItemData("Food", 0xEB00FB, ItemClassification.filler, 0),
    "Cup of Lifenoodles": ItemData("Status Heal", 0xEB00FC, ItemClassification.useful, 0),
    "Carrot Key": ItemData("Key Items", 0xEB00FD, ItemClassification.progression),

    "Onett Teleport": ItemData("PSI", 0xEB00FE, ItemClassification.progression),
    "Twoson Teleport": ItemData("PSI", 0xEB00FF, ItemClassification.progression),
    "Happy-Happy Village Teleport": ItemData("PSI", 0xEB0100, ItemClassification.progression),
    "Threed Teleport": ItemData("PSI", 0xEB0101, ItemClassification.progression),
    "Saturn Valley Teleport": ItemData("PSI", 0xEB0102, ItemClassification.progression),
    "Dusty Dunes Teleport": ItemData("PSI", 0xEB0103, ItemClassification.progression),
    "Fourside Teleport": ItemData("PSI", 0xEB0104, ItemClassification.progression),
    "Winters Teleport": ItemData("PSI", 0xEB0105, ItemClassification.progression),
    "Summers Teleport": ItemData("PSI", 0xEB0106, ItemClassification.progression),
    "Scaraba Teleport": ItemData("PSI", 0xEB0107, ItemClassification.progression),
    "Dalaam Teleport": ItemData("PSI", 0xEB0108, ItemClassification.progression),
    "Deep Darkness Teleport": ItemData("PSI", 0xEB0109, ItemClassification.progression),
    "Tenda Village Teleport": ItemData("PSI", 0xEB010A, ItemClassification.progression),
    "Lost Underworld Teleport": ItemData("PSI", 0xEB010B, ItemClassification.progression),
    "Progressive Poo PSI": ItemData("PSI", 0xEB010C, ItemClassification.useful, 2),
    "Magicant Teleport": ItemData("PSI", 0xEB010D, ItemClassification.progression),

    "Paula": ItemData("Characters", 0xEB010E, ItemClassification.progression),
    "Jeff": ItemData("Characters", 0xEB010F, ItemClassification.progression),
    "Poo": ItemData("Characters", 0xEB0110, ItemClassification.progression),
    "Flying Man": ItemData("Characters", 0xEB0111, ItemClassification.useful),
    "Ness": ItemData("Characters", 0xEB0112, ItemClassification.progression),
    "Photograph": ItemData("Photos", 0xEB0113, ItemClassification.trap, 0),

    "$10": ItemData("Money", 0xEB0114, ItemClassification.filler, 0),
    "$100": ItemData("Money", 0xEB0115, ItemClassification.filler, 0),
    "$1000": ItemData("Money", 0xEB0116, ItemClassification.useful, 0),

    'Threed Tunnels Clear': ItemData('Events', None, ItemClassification.progression, 0),
    'Submarine to Deep Darkness': ItemData('Events', None, ItemClassification.progression, 0),
    'Melody': ItemData('Events', None, ItemClassification.progression, 0),
    'Saved Earth': ItemData('Events', None, ItemClassification.progression, 0),
    "Power of the Earth": ItemData("Events", None, ItemClassification.progression, 0),
    "Alternate Goal": ItemData("Events", None, ItemClassification.useful, 0),
    "Valley Bridge Repair": ItemData("Events", None, ItemClassification.progression, 0),
    "Magicant Unlock": ItemData("Events", None, ItemClassification.progression, 0),
    "ATM Access": ItemData("Events", None, ItemClassification.progression, 0)
}


def get_item_names_per_category() -> Dict[str, Set[str]]:
    categories: Dict[str, Set[str]] = {}

    for name, data in item_table.items():
        if data.category != "Events":
            categories.setdefault(data.category, set()).add(name)

    return categories
