from enum import Enum
from typing import Dict, List, Tuple
from BaseClasses import Location

class AgainstTheStormLocation(Location):
    game: str = "Against the Storm"

class ATSLocationClassification(Enum):
    basic = 1
    biome_rep = 2
    extra_trade = 3
    dlc = 4
    dlc_biome_rep = 5
    dlc_grove_expedition = 6
    
# How to interpret these logic definitions:
# To reach a location, you need at least one item from each string. For example:
# ["A,B,C", "D,E"] means (A or B or C) and (D or E)
location_dict: Dict[str, Tuple[ATSLocationClassification, List[str]]] = {
    "First Reputation through Resolve - Humans": (ATSLocationClassification.basic, ["Porridge,Biscuits,Pie,Coats", "Planks", "Bricks"]),
    "First Reputation through Resolve - Beavers": (ATSLocationClassification.basic, ["Ale,Scrolls,Wine", "Planks", "Bricks", "Fabric"]),
    "First Reputation through Resolve - Lizards": (ATSLocationClassification.basic, []),
    "First Reputation through Resolve - Harpies": (ATSLocationClassification.basic, []),
    "First Reputation through Resolve - Foxes": (ATSLocationClassification.basic, []),
    "First Reputation through Resolve - Frogs": (ATSLocationClassification.dlc, ["Bricks"]),
    "50 Resolve - Humans": (ATSLocationClassification.basic, ["Porridge,Biscuits,Pie", "Coats", "Ale", "Incense", "Planks", "Fabric", "Bricks", "Purging Fire"]),
    "50 Resolve - Beavers": (ATSLocationClassification.basic, ["Biscuits,Pickled Goods", "Coats", "Ale", "Scrolls", "Wine", "Planks", "Fabric", "Bricks", "Purging Fire"]),
    "50 Resolve - Lizards": (ATSLocationClassification.basic, ["Jerky,Skewers,Pie", "Pickled Goods", "Boots", "Training Gear", "Planks", "Fabric", "Bricks", "Purging Fire"]),
    "50 Resolve - Harpies": (ATSLocationClassification.basic, ["Jerky", "Paste", "Coats", "Boots", "Scrolls", "Tea", "Planks", "Fabric", "Bricks", "Purging Fire"]),
    "50 Resolve - Foxes": (ATSLocationClassification.basic, ["Porridge,Skewers,Pickled Goods", "Boots", "Incense", "Tea", "Crystallized Dew", "Planks", "Fabric", "Bricks", "Purging Fire"]),
    "50 Resolve - Frogs": (ATSLocationClassification.dlc, ["Paste,Biscuits,Pie", "Boots", "Incense", "Wine", "Training Gear", "Planks", "Fabric", "Bricks", "Purging Fire"]),
    
    "1st Reputation - Royal Woodlands": (ATSLocationClassification.basic, []),
    "2nd Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "3rd Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "4th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "5th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish", "Purging Fire"]),
    "6th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "7th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "8th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "9th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "10th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "11th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "12th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "13th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "14th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "15th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "16th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "17th Reputation - Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "Victory - Royal Woodlands": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "1st Reputation - Coral Forest": (ATSLocationClassification.basic, []),
    "2nd Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "3rd Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "4th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "5th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish", "Purging Fire"]),
    "6th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "7th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "8th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "9th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "10th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "11th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "12th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "13th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "14th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "15th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "16th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "17th Reputation - Coral Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "Victory - Coral Forest": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "1st Reputation - The Marshlands": (ATSLocationClassification.basic, []),
    "2nd Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "3rd Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "4th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "5th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish", "Purging Fire"]),
    "6th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "7th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "8th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "9th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "10th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "11th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "12th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "13th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "14th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "15th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "16th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "17th Reputation - The Marshlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "Victory - The Marshlands": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "1st Reputation - Scarlet Orchard": (ATSLocationClassification.basic, []),
    "2nd Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "3rd Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "4th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "5th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish", "Purging Fire"]),
    "6th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "7th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "8th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "9th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "10th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "11th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "12th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "13th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "14th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "15th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "16th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "17th Reputation - Scarlet Orchard": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "Victory - Scarlet Orchard": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "1st Reputation - Cursed Royal Woodlands": (ATSLocationClassification.basic, []),
    "2nd Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "3rd Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "4th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "5th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish", "Purging Fire"]),
    "6th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "7th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "8th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "9th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "10th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "11th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "12th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "13th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "14th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "15th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "16th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "17th Reputation - Cursed Royal Woodlands": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "Victory - Cursed Royal Woodlands": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "1st Reputation - Coastal Grove": (ATSLocationClassification.dlc, []),
    "2nd Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "3rd Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "4th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "5th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish", "Purging Fire"]),
    "6th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "7th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "8th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "9th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "10th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "11th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "12th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "13th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "14th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "15th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "16th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "17th Reputation - Coastal Grove": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "Victory - Coastal Grove": (ATSLocationClassification.dlc, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "1st Reputation - Ashen Thicket": (ATSLocationClassification.dlc, []),
    "2nd Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "3rd Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "4th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "5th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish", "Purging Fire"]),
    "6th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "7th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "8th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "9th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "10th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "11th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "12th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "13th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "14th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "15th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "16th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "17th Reputation - Ashen Thicket": (ATSLocationClassification.dlc_biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "Victory - Ashen Thicket": (ATSLocationClassification.dlc, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "1st Reputation - Sealed Forest": (ATSLocationClassification.basic, []),
    "2nd Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "3rd Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "4th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "5th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish", "Purging Fire"]),
    "6th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "7th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks,Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "8th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "9th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "10th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "11th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks,Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "12th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "13th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools,Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "14th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "15th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "16th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),
    "17th Reputation - Sealed Forest": (ATSLocationClassification.biome_rep, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire"]),

    "Trade - 75 Berries": (ATSLocationClassification.extra_trade, ["Berries"]),
    "Trade - 75 Eggs": (ATSLocationClassification.extra_trade, ["Eggs"]),
    "Trade - 75 Insects": (ATSLocationClassification.extra_trade, ["Insects"]),
    "Trade - 75 Meat": (ATSLocationClassification.extra_trade, ["Meat"]),
    "Trade - 75 Mushrooms": (ATSLocationClassification.extra_trade, ["Mushrooms"]),
    "Trade - 75 Roots": (ATSLocationClassification.extra_trade, ["Roots"]),
    "Trade - 75 Vegetables": (ATSLocationClassification.extra_trade, ["Vegetables"]),
    "Trade - 75 Fish": (ATSLocationClassification.extra_trade, ["Fish"]),
    "Trade - 100 Biscuits": (ATSLocationClassification.extra_trade, ["Biscuits", "Planks", "Fabric", "Bricks"]),
    "Trade - 100 Jerky": (ATSLocationClassification.extra_trade, ["Jerky", "Planks", "Fabric", "Bricks"]),
    "Trade - 100 Pickled Goods": (ATSLocationClassification.extra_trade, ["Pickled Goods", "Planks", "Fabric", "Bricks"]),
    "Trade - 100 Pie": (ATSLocationClassification.extra_trade, ["Pie", "Planks", "Fabric", "Bricks"]),
    "Trade - 100 Porridge": (ATSLocationClassification.extra_trade, ["Porridge", "Planks", "Fabric", "Bricks"]),
    "Trade - 100 Skewers": (ATSLocationClassification.extra_trade, ["Skewers", "Planks", "Fabric", "Bricks"]),
    "Trade - 100 Paste": (ATSLocationClassification.extra_trade, ["Paste", "Planks", "Fabric", "Bricks"]),
    "Trade - 100 Coats": (ATSLocationClassification.extra_trade, ["Coats", "Planks", "Fabric", "Bricks"]),
    "Trade - 100 Boots": (ATSLocationClassification.extra_trade, ["Boots", "Planks", "Fabric", "Bricks"]),
    "Trade - 40 Bricks": (ATSLocationClassification.extra_trade, ["Bricks"]),
    "Trade - 40 Fabric": (ATSLocationClassification.extra_trade, ["Fabric"]),
    "Trade - 40 Planks": (ATSLocationClassification.extra_trade, ["Planks"]),
    "Trade - 30 Pipes": (ATSLocationClassification.extra_trade, ["Pipes", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Ale": (ATSLocationClassification.extra_trade, ["Ale", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Incense": (ATSLocationClassification.extra_trade, ["Incense", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Scrolls": (ATSLocationClassification.extra_trade, ["Scrolls", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Tea": (ATSLocationClassification.extra_trade, ["Tea", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Training Gear": (ATSLocationClassification.extra_trade, ["Training Gear", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Wine": (ATSLocationClassification.extra_trade, ["Wine", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Clay": (ATSLocationClassification.extra_trade, ["Clay"]),
    "Trade - 75 Copper Ore": (ATSLocationClassification.extra_trade, ["Copper Ore"]),
    "Trade - 75 Scales": (ATSLocationClassification.extra_trade, ["Scales"]),
    "Trade - 40 Crystallized Dew": (ATSLocationClassification.extra_trade, ["Crystallized Dew", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Grain": (ATSLocationClassification.extra_trade, ["Grain"]),
    "Trade - 75 Herbs": (ATSLocationClassification.extra_trade, ["Herbs"]),
    "Trade - 50 Leather": (ATSLocationClassification.extra_trade, ["Leather"]),
    "Trade - 75 Plant Fiber": (ATSLocationClassification.extra_trade, ["Plant Fiber"]),
    "Trade - 75 Algae": (ATSLocationClassification.extra_trade, ["Algae"]),
    "Trade - 75 Reeds": (ATSLocationClassification.extra_trade, ["Reeds"]),
    "Trade - 50 Resin": (ATSLocationClassification.extra_trade, ["Resin"]),
    "Trade - 75 Stone": (ATSLocationClassification.extra_trade, ["Stone"]),
    "Trade - 75 Salt": (ATSLocationClassification.extra_trade, ["Salt"]),
    "Trade - 75 Barrels": (ATSLocationClassification.extra_trade, ["Barrels", "Planks", "Fabric", "Bricks"]),
    "Trade - 40 Copper Bars": (ATSLocationClassification.extra_trade, ["Copper Bars", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Flour": (ATSLocationClassification.extra_trade, ["Flour", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Dye": (ATSLocationClassification.extra_trade, ["Dye", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Pottery": (ATSLocationClassification.extra_trade, ["Pottery", "Planks", "Fabric", "Bricks"]),
    "Trade - 50 Waterskins": (ATSLocationClassification.extra_trade, ["Waterskins", "Planks", "Fabric", "Bricks"]),
    "Trade - 3 Ancient Tablet": (ATSLocationClassification.extra_trade, ["Ancient Tablet", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Coal": (ATSLocationClassification.extra_trade, ["Coal"]),
    "Trade - 75 Oil": (ATSLocationClassification.extra_trade, ["Oil", "Planks", "Fabric", "Bricks"]),
    "Trade - 20 Purging Fire": (ATSLocationClassification.extra_trade, ["Purging Fire", "Planks", "Fabric", "Bricks"]),
    "Trade - 75 Sea Marrow": (ATSLocationClassification.extra_trade, ["Sea Marrow"]),
    "Trade - 30 Tools": (ATSLocationClassification.extra_trade, ["Tools", "Planks", "Fabric", "Bricks"]),

    "Trade - 5 Amber": (ATSLocationClassification.basic, ["Amber"]),
    "Trade - 50 Amber": (ATSLocationClassification.basic, ["Amber", "Pack of Provisions", "Planks"]),
    "Trade - 500 Amber": (ATSLocationClassification.basic, ["Amber", "Pack of Provisions", "Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Pack of Building Materials,Pack of Crops,Pack of Luxury Goods,Pack of Trade Goods", "Purging Fire"]),
    "Trade - 20 Pack of Building Materials": (ATSLocationClassification.basic, ["Pack of Building Materials"]),
    "Trade - 20 Pack of Crops": (ATSLocationClassification.basic, ["Pack of Crops"]),
    "Trade - 20 Pack of Provisions": (ATSLocationClassification.basic, ["Pack of Provisions"]),
    "Trade - 20 Pack of Luxury Goods": (ATSLocationClassification.basic, ["Pack of Luxury Goods", "Planks", "Bricks", "Fabric"]),
    "Trade - 20 Pack of Trade Goods": (ATSLocationClassification.basic, ["Pack of Trade Goods", "Planks", "Bricks", "Fabric"]),
    "Trade - 200 Drizzle Water": (ATSLocationClassification.basic, ["Planks", "Pipes"]),
    "Trade - 200 Clearance Water": (ATSLocationClassification.basic, ["Planks", "Pipes"]),
    "Trade - 200 Storm Water": (ATSLocationClassification.basic, ["Planks", "Pipes"]),

    "Reach level 1 standing with a neighbor": (ATSLocationClassification.basic, ["Amber", "Pack of Provisions"]),
    "Reach level 2 standing with a neighbor": (ATSLocationClassification.basic, ["Amber", "Pack of Provisions", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste"]),
    "Reach level 3 standing with a neighbor": (ATSLocationClassification.basic, ["Amber", "Planks,Fabric,Bricks", "Pack of Provisions", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "Reach level 4 standing with a neighbor": (ATSLocationClassification.basic, ["Amber", "Planks", "Fabric,Bricks", "Pack of Provisions", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire", "Pack of Building Materials,Pack of Crops,Pack of Luxury Goods,Pack of Trade Goods"]),
    "Reach level 5 standing with a neighbor": (ATSLocationClassification.basic, ["Amber", "Planks", "Fabric", "Bricks", "Pack of Provisions", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire", "Pack of Building Materials,Pack of Crops,Pack of Luxury Goods,Pack of Trade Goods"]),
    "Reach level 1 standing with ALL 4 neighbors": (ATSLocationClassification.basic, ["Amber", "Pack of Provisions", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste"]),
    "Reach level 2 standing with ALL 4 neighbors": (ATSLocationClassification.basic, ["Amber", "Planks,Fabric,Bricks", "Pack of Provisions", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire"]),
    "Reach level 3 standing with ALL 4 neighbors": (ATSLocationClassification.basic, ["Amber", "Planks", "Fabric,Bricks", "Pack of Provisions", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire", "Pack of Building Materials,Pack of Crops,Pack of Luxury Goods,Pack of Trade Goods"]),
    "Reach level 4 standing with ALL 4 neighbors": (ATSLocationClassification.basic, ["Amber", "Planks", "Fabric", "Bricks", "Pack of Provisions", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire", "Pack of Building Materials,Pack of Crops,Pack of Luxury Goods,Pack of Trade Goods"]),
    "Reach level 5 standing with ALL 4 neighbors": (ATSLocationClassification.basic, ["Amber", "Planks", "Fabric", "Bricks", "Pack of Provisions", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Purging Fire", "Pack of Building Materials", "Pack of Crops", "Pack of Luxury Goods", "Pack of Trade Goods"]),
    
    "Completed Order - 1st Pack": (ATSLocationClassification.basic, []),
    "Completed Order - 2nd Pack": (ATSLocationClassification.basic, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "Completed Order - 3rd Pack": (ATSLocationClassification.basic, ["Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish", "Planks,Bricks,Fabric"]),
    "Completed Order - 4th Pack": (ATSLocationClassification.basic, ["Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Planks", "Bricks,Fabric"]),
    "Completed Order - 5th Pack": (ATSLocationClassification.basic, ["Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Planks", "Bricks,Fabric"]),
    "Completed Order - 6th Pack": (ATSLocationClassification.basic, ["Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Planks", "Bricks,Fabric", "Purging Fire"]),
    "Completed Order - 7th Pack": (ATSLocationClassification.basic, ["Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Planks", "Bricks,Fabric", "Purging Fire"]),
    "Completed Order - 8th Pack": (ATSLocationClassification.basic, ["Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Planks", "Bricks", "Fabric", "Purging Fire"]),
    "Completed Order - 9th Pack": (ATSLocationClassification.basic, ["Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Planks", "Bricks", "Fabric", "Amber,Tools", "Purging Fire"]),
    
    "Upgraded Hearth - 1st Tier": (ATSLocationClassification.basic, []),
    "Upgraded Hearth - 2nd Tier": (ATSLocationClassification.basic, ["Planks"]),
    "Upgraded Hearth - 3rd Tier": (ATSLocationClassification.basic, ["Planks", "Fabric", "Bricks"]),
    "Complete a Dangerous Glade Event": (ATSLocationClassification.basic, ["Tools", "Oil,Coal,Sea Marrow", "Incense,Scrolls,Tea", "Planks"]),
    "Complete a Forbidden Glade Event": (ATSLocationClassification.basic, ["Tools", "Oil,Coal,Sea Marrow", "Incense,Scrolls,Tea", "Planks", "Bricks,Fabric", "Purging Fire"]),
    "Complete a Glade Event with a Corruption tag": (ATSLocationClassification.basic, ["Tools", "Oil,Coal,Sea Marrow", "Incense,Scrolls,Tea", "Planks"]),
    "Complete a Glade Event with an Empathy tag": (ATSLocationClassification.basic, ["Tools", "Oil,Coal,Sea Marrow", "Incense,Scrolls,Tea", "Planks"]),
    "Complete a Glade Event with a Loyalty tag": (ATSLocationClassification.basic, ["Tools", "Berries,Eggs,Insects,Meat,Mushrooms,Roots,Vegetables,Fish"]),
    "Have 20 Villagers in fully upgraded Housing - Humans": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire", "Pack of Building Materials", "Pack of Crops"]),
    "Have 20 Villagers in fully upgraded Housing - Beavers": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire", "Pack of Building Materials", "Amber,Pack of Trade Goods"]),
    "Have 20 Villagers in fully upgraded Housing - Lizards": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire", "Pack of Building Materials", "Jerky,Skewers"]),
    "Have 20 Villagers in fully upgraded Housing - Harpies": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire", "Pack of Building Materials", "Dye"]),
    "Have 20 Villagers in fully upgraded Housing - Foxes": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire", "Pack of Building Materials", "Resin", "Crystallized Dew"]),
    "Have 20 Villagers in fully upgraded Housing - Frogs": (ATSLocationClassification.dlc, ["Planks", "Bricks", "Fabric", "Jerky,Porridge,Skewers,Biscuits,Pie,Pickled Goods,Paste", "Amber,Tools", "Ale,Training Gear,Incense,Scrolls,Wine,Tea", "Purging Fire", "Pack of Building Materials"]),
    
    "Cursed Royal Woodlands - Appease a Calm Ghost": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Incense,Oil,Sea Marrow,Tools,Ancient Tablet"]),
    "Cursed Royal Woodlands - Appease an Angry Ghost": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric", "Incense,Oil,Sea Marrow,Tools,Ancient Tablet"]),
    "The Marshlands - Harvest from an Ancient Proto Wheat": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric"]),
    "The Marshlands - Harvest from a Dead Leviathan": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric"]),
    "The Marshlands - Harvest from a Giant Proto Fungus": (ATSLocationClassification.basic, ["Planks", "Bricks", "Fabric"]),
    "Scarlet Orchard - Reconstruct the Sealed Spider": (ATSLocationClassification.basic, ["Planks", "Fabric", "Bricks", "Eggs,Meat,Roots,Berries,Mushrooms,Insects", "Incense,Scrolls,Tea,Resin", "Coal,Oil,Sea Marrow,Planks", "Stone,Copper Bars,Dye,Barrels,Incense", "Tools,Parts,Pipes"]),
    "Scarlet Orchard - Reconstruct the Sea Snake": (ATSLocationClassification.basic, ["Planks", "Fabric", "Bricks", "Eggs,Meat,Roots,Berries,Mushrooms,Insects", "Incense,Scrolls,Tea,Resin", "Coal,Oil,Sea Marrow,Planks", "Stone,Copper Bars,Dye,Barrels,Incense", "Tools,Parts,Pipes"]),
    "Scarlet Orchard - Reconstruct the Smoldering Scorpion": (ATSLocationClassification.basic, ["Planks", "Fabric", "Bricks", "Eggs,Meat,Roots,Berries,Mushrooms,Insects", "Incense,Scrolls,Tea,Resin", "Coal,Oil,Sea Marrow,Planks", "Stone,Copper Bars,Dye,Barrels,Incense", "Tools,Parts,Pipes"]),
    "Ashen Thicket - Forge 1st Cornerstone": (ATSLocationClassification.dlc, []),
    "Ashen Thicket - Forge 2nd Cornerstone": (ATSLocationClassification.dlc, ["Planks", "Bricks"]),
    "Ashen Thicket - Forge 3rd Cornerstone": (ATSLocationClassification.dlc, ["Planks", "Bricks", "Coal,Copper Ore,Salt"]),
    "Coastal Grove - 1st Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables"]),
    "Coastal Grove - 2nd Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables"]),
    "Coastal Grove - 3rd Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Paste,Skewers,Porridge"]),
    "Coastal Grove - 4th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge"]),
    "Coastal Grove - 5th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge"]),
    "Coastal Grove - 6th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge"]),
    "Coastal Grove - 7th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 8th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 9th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 10th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 11th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 12th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 13th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 14th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 15th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 16th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 17th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 18th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 19th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
    "Coastal Grove - 20th Expedition": (ATSLocationClassification.dlc_grove_expedition, ["Planks", "Bricks", "Fabric", "Purging Fire", "Algae,Fish", "Roots,Berries,Insects,Mushrooms,Vegetables", "Biscuits,Pie,Jerky,Pickled Goods", "Paste,Skewers,Porridge", "Ale,Tea,Wine"]),
}
