import typing

from enum import Enum

class Dice:
    id: int
    name: str

    def __init__(self, _id: int, name: str):
        self.id = _id
        self.name = name

    def __str__(self) -> str:
        return (
            f"{self.name} "
        )
    
    # location in memory?

all_dice: typing.Tuple[Dice, ...] = (
    Dice(0, "B.eye White Dragon"),
    Dice(1, "Mystical Elf"),
    Dice(2, "Hitotsu-me Giant"),
    Dice(3, "Baby Dragon"),
    Dice(4, "Ryu-kishin"),
    Dice(5, "Feral Imp"),
    Dice(6, "Winged Dragon #1"),
    Dice(7, "Mushroom Man"),
    Dice(8, "Shadow Specter"),
    Dice(11, "Swamp Battleguard"),
    Dice(12, "Battle Steer"),
    Dice(13, "Flame Swordsman"),
    Dice(14, "Time Wizard"),
    Dice(15, "R Leg of Forbidden"),
    Dice(16, "L Leg of Forbidden"),
    Dice(17, "R Arm of Forbidden"),
    Dice(18, "L Arm of Forbidden"),
    Dice(19, "Exod. of Forbidden"),
    Dice(20, "Summoned Skull"),
    Dice(22, "Battle Ox"), #jumps to 23 here
    Dice(23, "Beaver Warrior"),
    Dice(24, "Rock Ogre Grotto #1"),
    Dice(26, "Zombie Warrior"),
    Dice(27, "Koumori Dragon"),
    Dice(30, "Saggi the Dark Clown"),
    Dice(31, "Dark Magician"),
    Dice(32, "The Snake Hair"),
    Dice(33, "Gaia the Dragon Champion"),
    Dice(34, "Gaia the Fierce Knight"),
    Dice(35, "Curse of Dragon"),
    Dice(36, "Dragon Piper"),
    Dice(37, "Celtic Guardian"),
    Dice(38, "Faceless Mage"),
    Dice(39, "Karbonala Warrior"),
    Dice(40, "Rogue Doll"),
    Dice(41, "Sangan"),
    Dice(45, "Killer Needle"),
    Dice(47, "Giant Flea"),
    Dice(48, "Larvae Moth"),
    Dice(49, "Great Moth"),
    Dice(50, "Kuriboh"),
    Dice(51, "Mammoth Graveyard"),
    Dice(53, "Harpie Lady"),
    Dice(54, "Harpie Lady Sisters"),
    Dice(58, "Perfectly Ultimate"),
    Dice(60, "Thousand Dragon"),
    Dice(62, "Jellyfish"),
    Dice(63, "Cocoon of Evolution"),
    Dice(65, "Giant Rock Soldier"),
    Dice(71, "Red-eyes B. Dragon"),
    Dice(72, "Castle of D. Magic"),
    Dice(76, "Metal Guardian"),
    Dice(79, "Mystic Horseman"),
    Dice(80, "Rabid Horseman"),
    Dice(86, "Clown Zombie"),
    Dice(87, "Pumpking the King of Ghosts"),
    Dice(88, "Battle Warrior"),
    Dice(92, "The 13th Grave"),
    Dice(95, "Petit Dragon"),
    Dice(97, "Aqua Madoor"),
    Dice(98, "B. Skull Dragon"),
    Dice(99, "Beautiful Headhuntress"),
    Dice(107, "Yaranzo"),
    Dice(108, "Kanan the Swordmistress"),
    Dice(110, "Stuffed Animal"),
    Dice(113, "Three-legged Zombies"),
    Dice(114, "Flying Penguin"),
    Dice(115, "Millennium Shield"),
    Dice(117, "Black Luster Soldier"),
    Dice(118, "Fiend's Mirror"),
    Dice(120, "Jirai Gumo"),
    Dice(123, "Sanga of the Thunder"),
    Dice(124, "Kazejin"),
    Dice(125, "Suijin"),
    Dice(126, "Gate Guardian"),
    Dice(129, "Ryu-kishin Powered"),
    Dice(132, "B.eye Ultimate Dragon"),
    Dice(135, "Parrot Dragon"),
    Dice(138, "Mystic Lamp"),
    Dice(139, "Pendulum Machine"),
    Dice(142, "Zoa"),
    Dice(143, "Metalzoa"),
    Dice(144, "Dancing Elf"),
    Dice(152, "Man-eater Bug"),
    Dice(155, "Gemini Elf"),
    Dice(156, "Skelengel"),
    Dice(157, "Hane-Hane"),
    Dice(161, "Penguin Soldier"),
    Dice(162, "Twin-headed Thunder Dragon"),
    Dice(163, "Witch's Apprentice"),
    Dice(166, "Meteor Dragon"),
    Dice(167, "Meteor B. Dragon"),
    Dice(169, "Dokurorider"),
    Dice(170, "Magician of Black Chaos"),
    Dice(171, "Slot Machine"),
    Dice(172, "Red Archery Girl"),
    Dice(173, "Dark-eyes Illusionist"),
    Dice(174, "Relinquished"),
    Dice(175, "Thousand-eyes Restrict"),
    Dice(176, "Lord of D."),
    Dice(177, "R.eye B. M. Dragon"),
    Dice(178, "Barrel Dragon"),
    Dice(179, "Jinzo"),
    Dice(180, "D. Magician Girl"),
    Dice(181, "Twin-Headed Dragon"),
    Dice(182, "Gator Dragon"),
    Dice(183, "Blast Lizard"),
    Dice(184, "Knight of Twin Swords"),
    Dice(185, "Thunder Ball"),
    Dice(186, "Magician Dragon"),
    Dice(187, "Strike Ninja"),
    Dice(188, "Mighty Mage"),
    Dice(189, "Crocozaurus"),
    Dice(190, "Orgoth the Relentless"),
    Dice(191, "Medical Aid Kit"),
    Dice(192, "Exploding Disc"),
    Dice(193, "Time Machine"),
    Dice(194, "Energy Disc"),
    Dice(195, "Trap Bandit"),
    Dice(196, "Decleration of Despair"),
    Dice(197, "Gluminizer"),
    Dice(198, "Resurrection Scroll"),
    Dice(199, "Warp Vortex"),
    Dice(200, "Crater Creator")
)

id_to_dice = {dice.id: dice for dice in all_dice}
name_to_dice = {dice.name: dice for dice in all_dice}