import hashlib
import os
import Utils
from worlds.Files import APDeltaPatch
from settings import get_settings
from typing import TYPE_CHECKING, Collection, SupportsIndex

from .Options import YoshiColors, BowserDoor, PlayerGoal, MinigameChecks

if TYPE_CHECKING:
    from . import YoshisIslandWorld
USHASH = "cb472164c5a71ccd3739963390ec6a50"

item_values = {
    0x302050: [0x1467, 0x01],  # ! Switch
    0x302051: [0x1467, 0x02],  # Dashed Platform
    0x302052: [0x1467, 0x03],  # Dashed Stairs
    0x302053: [0x1467, 0x04],  # Beanstalk
    0x302054: [0x1467, 0x05],  # Helicopter
    0x302059: [0x1467, 0x06],  # Mole Tank
    0x302068: [0x1467, 0x07],  # Train
    0x30205E: [0x1467, 0x08],  # Car
    0x302063: [0x1467, 0x09],  # Submarine
    0x302055: [0x1467, 0x0A],  # Spring Ball
    0x302056: [0x1467, 0x0B],  # Large Spring Ball
    0x302057: [0x1467, 0x0C],  # Arrow Wheel
    0x302058: [0x1467, 0x0D],  # Vanishing Arrow Wheel
    0x30205A: [0x1467, 0x0E],  # Watermelon
    0x30205B: [0x1467, 0x0F],  # Ice Melon
    0x30205C: [0x1467, 0x10],  # Fire Melon
    0x30205D: [0x1467, 0x11],  # Super Star
    0x30205F: [0x1467, 0x12],  # Flashing Eggs
    0x302060: [0x1467, 0x13],  # Giant Eggs
    0x302061: [0x1467, 0x14],  # Egg Launcher
    0x302062: [0x1467, 0x15],  # Egg Plant
    0x302064: [0x1467, 0x16],  # Chomp Rock
    0x302065: [0x1467, 0x17],  # Poochy
    0x302066: [0x1467, 0x18],  # Platform Ghost
    0x302067: [0x1467, 0x19],  # Skis
    0x302069: [0x1467, 0x1A],  # Key
    0x30206A: [0x1467, 0x1B],  # Middle Ring
    0x30206B: [0x1467, 0x1C],  # Bucket
    0x30206C: [0x1467, 0x1D],  # Tulip
    0x302081: [0x1467, 0x1E],  # Secret Lens

    0x30206D: [0x1467, 0x1F],  # Egg Capacity Upgrade

    0x30206E: [0x1467, 0x20],  # World 1 Gate
    0x30206F: [0x1467, 0x21],  # World 2 Gate
    0x302070: [0x1467, 0x22],  # World 3 Gate
    0x302071: [0x1467, 0x23],  # World 4 Gate
    0x302072: [0x1467, 0x24],  # World 5 Gate
    0x302073: [0x1467, 0x25],  # World 6 Gate

    0x302074: [0x1467, 0x26],  # Extra 1
    0x302075: [0x1467, 0x27],  # Extra 2
    0x302076: [0x1467, 0x28],  # Extra 3
    0x302077: [0x1467, 0x29],  # Extra 4
    0x302078: [0x1467, 0x2A],  # Extra 5
    0x302079: [0x1467, 0x2B],  # Extra 6
    0x30207A: [0x1467, 0x2C],  # Extra Panels

    0x30207B: [0x1467, 0x2D],  # Bonus 1
    0x30207C: [0x1467, 0x2E],  # Bonus 2
    0x30207D: [0x1467, 0x2F],  # Bonus 3
    0x30207E: [0x1467, 0x30],  # Bonus 4
    0x30207F: [0x1467, 0x31],  # Bonus 5
    0x302080: [0x1467, 0x32],  # Bonus 6
    0x302082: [0x1467, 0x33],  # Bonus Panels

    0x302083: [0x1467, 0x34],  # Anytime Egg
    0x302084: [0x1467, 0x35],  # Anywhere Pow
    0x302085: [0x1467, 0x36],  # Cloud
    0x302086: [0x1467, 0x37],  # Pocket Melon
    0x302088: [0x1467, 0x38],  # Ice Melon
    0x302087: [0x1467, 0x39],  # Fire Melon
    0x302089: [0x1467, 0x3A],  # Magnifying Glass
    0x30208A: [0x1467, 0x3B],  # 10 Stars
    0x30208B: [0x1467, 0x3C],  # 20 Stars

    0x30208C: [0x1467, 0x3D],  # 1up
    0x30208D: [0x1467, 0x3E],  # 2up
    0x30208E: [0x1467, 0x3F],  # 3up
    0x30208F: [0x1467, 0x40],  # 10up

    0x302090: [0x1467, 0x41],  # Fuzzy Trap
    0x302093: [0x1467, 0x42],  # Freeze Trap
    0x302091: [0x1467, 0x43],  # Reverse Trap
    0x302092: [0x1467, 0x44],  # Dark Trap
    0x302094: [0x1467, 0x00],  # Boss clear, local handling

    0x302095: [0x1467, 0x45]  # Luigi Piece

}

location_table = {
    # 1-1
    0x305020: [0x146D, 0],  # Red Coins
    0x305021: [0x146D, 1],  # Flowers
    0x305022: [0x146D, 2],  # Stars
    0x305023: [0x146D, 3],  # Level Clear
    # 1-2
    0x305024: [0x146E, 0],
    0x305025: [0x146E, 1],
    0x305026: [0x146E, 2],
    0x305027: [0x146E, 3],
    # 1-3
    0x305028: [0x146F, 0],
    0x305029: [0x146F, 1],
    0x30502A: [0x146F, 2],
    0x30502B: [0x146F, 3],
    0x3050F8: [0x146F, 4],
    # 1-4
    0x30502C: [0x1470, 0],
    0x30502D: [0x1470, 1],
    0x30502E: [0x1470, 2],
    0x30502F: [0x1470, 3],
    # 1-5
    0x305031: [0x1471, 0],
    0x305032: [0x1471, 1],
    0x305033: [0x1471, 2],
    0x305034: [0x1471, 3],
    # 1-6
    0x305035: [0x1472, 0],
    0x305036: [0x1472, 1],
    0x305037: [0x1472, 2],
    0x305038: [0x1472, 3],
    # 1-7
    0x305039: [0x1473, 0],
    0x30503A: [0x1473, 1],
    0x30503B: [0x1473, 2],
    0x30503C: [0x1473, 3],
    0x3050F9: [0x1473, 4],
    # 1-8
    0x30503D: [0x1474, 0],
    0x30503E: [0x1474, 1],
    0x30503F: [0x1474, 2],
    0x305040: [0x1474, 3],
    # 1-E
    0x3050E0: [0x1475, 0],
    0x3050E1: [0x1475, 1],
    0x3050E2: [0x1475, 2],
    0x3050E3: [0x1475, 3],
    # 1-B
    0x305106: [0x1476, 4],
    ######################
    # 2-1
    0x305041: [0x1479, 0],
    0x305042: [0x1479, 1],
    0x305043: [0x1479, 2],
    0x305044: [0x1479, 3],
    0x3050FA: [0x1479, 4],
    # 2-2
    0x305045: [0x147A, 0],
    0x305046: [0x147A, 1],
    0x305047: [0x147A, 2],
    0x305048: [0x147A, 3],
    # 2-3
    0x305049: [0x147B, 0],
    0x30504A: [0x147B, 1],
    0x30504B: [0x147B, 2],
    0x30504C: [0x147B, 3],
    0x3050FB: [0x147B, 4],
    # 2-4
    0x30504D: [0x147C, 0],
    0x30504E: [0x147C, 1],
    0x30504F: [0x147C, 2],
    0x305050: [0x147C, 3],
    # 2-5
    0x305051: [0x147D, 0],
    0x305052: [0x147D, 1],
    0x305053: [0x147D, 2],
    0x305054: [0x147D, 3],
    # 2-6
    0x305055: [0x147E, 0],
    0x305056: [0x147E, 1],
    0x305057: [0x147E, 2],
    0x305058: [0x147E, 3],
    0x3050FC: [0x147E, 4],
    # 2-7
    0x305059: [0x147F, 0],
    0x30505A: [0x147F, 1],
    0x30505B: [0x147F, 2],
    0x30505C: [0x147F, 3],
    0x3050FD: [0x147F, 4],
    # 2-8
    0x30505D: [0x1480, 0],
    0x30505E: [0x1480, 1],
    0x30505F: [0x1480, 2],
    0x305060: [0x1480, 3],
    # 2-E
    0x3050E4: [0x1481, 0],
    0x3050E5: [0x1481, 1],
    0x3050E6: [0x1481, 2],
    0x3050E7: [0x1481, 3],
    # 2-B
    0x305107: [0x1482, 4],
    ######################
    # 3-1
    0x305061: [0x1485, 0],
    0x305062: [0x1485, 1],
    0x305063: [0x1485, 2],
    0x305064: [0x1485, 3],
    # 3-2
    0x305065: [0x1486, 0],
    0x305066: [0x1486, 1],
    0x305067: [0x1486, 2],
    0x305068: [0x1486, 3],
    0x3050FE: [0x1486, 4],
    # 3-3
    0x305069: [0x1487, 0],
    0x30506A: [0x1487, 1],
    0x30506B: [0x1487, 2],
    0x30506C: [0x1487, 3],
    # 3-4
    0x30506D: [0x1488, 0],
    0x30506E: [0x1488, 1],
    0x30506F: [0x1488, 2],
    0x305070: [0x1488, 3],
    # 3-5
    0x305071: [0x1489, 0],
    0x305072: [0x1489, 1],
    0x305073: [0x1489, 2],
    0x305074: [0x1489, 3],
    # 3-6
    0x305075: [0x148A, 0],
    0x305076: [0x148A, 1],
    0x305077: [0x148A, 2],
    0x305078: [0x148A, 3],
    # 3-7
    0x305079: [0x148B, 0],
    0x30507A: [0x148B, 1],
    0x30507B: [0x148B, 2],
    0x30507C: [0x148B, 3],
    0x3050FF: [0x148B, 4],
    # 3-8
    0x30507D: [0x148C, 0],
    0x30507E: [0x148C, 1],
    0x30507F: [0x148C, 2],
    0x305080: [0x148C, 3],
    # 3-E
    0x3050E8: [0x148D, 0],
    0x3050E9: [0x148D, 1],
    0x3050EA: [0x148D, 2],
    0x3050EB: [0x148D, 3],
    # 3-B
    0x305108: [0x148E, 4],
    ######################
    # 4-1
    0x305081: [0x1491, 0],
    0x305082: [0x1491, 1],
    0x305083: [0x1491, 2],
    0x305084: [0x1491, 3],
    # 4-2
    0x305085: [0x1492, 0],
    0x305086: [0x1492, 1],
    0x305087: [0x1492, 2],
    0x305088: [0x1492, 3],
    0x305100: [0x1492, 4],
    # 4-3
    0x305089: [0x1493, 0],
    0x30508A: [0x1493, 1],
    0x30508B: [0x1493, 2],
    0x30508C: [0x1493, 3],
    # 4-4
    0x30508D: [0x1494, 0],
    0x30508E: [0x1494, 1],
    0x30508F: [0x1494, 2],
    0x305090: [0x1494, 3],
    # 4-5
    0x305091: [0x1495, 0],
    0x305092: [0x1495, 1],
    0x305093: [0x1495, 2],
    0x305094: [0x1495, 3],
    # 4-6
    0x305095: [0x1496, 0],
    0x305096: [0x1496, 1],
    0x305097: [0x1496, 2],
    0x305098: [0x1496, 3],
    0x305101: [0x1496, 4],
    # 4-7
    0x305099: [0x1497, 0],
    0x30509A: [0x1497, 1],
    0x30509B: [0x1497, 2],
    0x30509C: [0x1497, 3],
    0x305102: [0x1497, 4],
    # 4-8
    0x30509D: [0x1498, 0],
    0x30509E: [0x1498, 1],
    0x30509F: [0x1498, 2],
    0x3050A0: [0x1498, 3],
    # 4-E
    0x3050EC: [0x1499, 0],
    0x3050ED: [0x1499, 1],
    0x3050EE: [0x1499, 2],
    0x3050EF: [0x1499, 3],
    # 4-B
    0x305109: [0x149A, 4],
    ######################
    # 5-1
    0x3050A1: [0x149D, 0],
    0x3050A2: [0x149D, 1],
    0x3050A3: [0x149D, 2],
    0x3050A4: [0x149D, 3],
    0x305103: [0x149D, 4],
    # 5-2
    0x3050A5: [0x149E, 0],
    0x3050A6: [0x149E, 1],
    0x3050A7: [0x149E, 2],
    0x3050A8: [0x149E, 3],
    # 5-3
    0x3050A9: [0x149F, 0],
    0x3050AA: [0x149F, 1],
    0x3050AB: [0x149F, 2],
    0x3050AC: [0x149F, 3],
    # 5-4
    0x3050AD: [0x14A0, 0],
    0x3050AE: [0x14A0, 1],
    0x3050AF: [0x14A0, 2],
    0x3050B0: [0x14A0, 3],
    # 5-5
    0x3050B1: [0x14A1, 0],
    0x3050B2: [0x14A1, 1],
    0x3050B3: [0x14A1, 2],
    0x3050B4: [0x14A1, 3],
    # 5-6
    0x3050B5: [0x14A2, 0],
    0x3050B6: [0x14A2, 1],
    0x3050B7: [0x14A2, 2],
    0x3050B8: [0x14A2, 3],
    # 5-7
    0x3050B9: [0x14A3, 0],
    0x3050BA: [0x14A3, 1],
    0x3050BB: [0x14A3, 2],
    0x3050BC: [0x14A3, 3],
    # 5-8
    0x3050BD: [0x14A4, 0],
    0x3050BE: [0x14A4, 1],
    0x3050BF: [0x14A4, 2],
    0x3050C0: [0x14A4, 3],
    # 5-E
    0x3050F0: [0x14A5, 0],
    0x3050F1: [0x14A5, 1],
    0x3050F2: [0x14A5, 2],
    0x3050F3: [0x14A5, 3],
    # 5-B
    0x30510A: [0x14A6, 4],
    #######################
    # 6-1
    0x3050C1: [0x14A9, 0],
    0x3050C2: [0x14A9, 1],
    0x3050C3: [0x14A9, 2],
    0x3050C4: [0x14A9, 3],
    0x305104: [0x14A9, 4],
    # 6-2
    0x3050C5: [0x14AA, 0],
    0x3050C6: [0x14AA, 1],
    0x3050C7: [0x14AA, 2],
    0x3050C8: [0x14AA, 3],
    # 6-3
    0x3050C9: [0x14AB, 0],
    0x3050CA: [0x14AB, 1],
    0x3050CB: [0x14AB, 2],
    0x3050CC: [0x14AB, 3],
    # 6-4
    0x3050CD: [0x14AC, 0],
    0x3050CE: [0x14AC, 1],
    0x3050CF: [0x14AC, 2],
    0x3050D0: [0x14AC, 3],
    # 6-5
    0x3050D1: [0x14AD, 0],
    0x3050D2: [0x14AD, 1],
    0x3050D3: [0x14AD, 2],
    0x3050D4: [0x14AD, 3],
    # 6-6
    0x3050D5: [0x14AE, 0],
    0x3050D6: [0x14AE, 1],
    0x3050D7: [0x14AE, 2],
    0x3050D8: [0x14AE, 3],
    # 6-7
    0x3050D9: [0x14AF, 0],
    0x3050DA: [0x14AF, 1],
    0x3050DB: [0x14AF, 2],
    0x3050DC: [0x14AF, 3],
    0x305105: [0x14AF, 4],
    # 6-8
    0x3050DD: [0x14B0, 0],
    0x3050DE: [0x14B0, 1],
    0x3050DF: [0x14B0, 2],
    # 6-E
    0x3050F4: [0x14B1, 0],
    0x3050F5: [0x14B1, 1],
    0x3050F6: [0x14B1, 2],
    0x3050F7: [0x14B1, 3],
    # 6-B
    0x30510B: [0x14B2, 4]
}

class LocalRom:

    def __init__(self, file: str) -> None:
        self.name = None
        self.hash = hash
        self.orig_buffer = None

        with open(file, "rb") as stream:
            self.buffer = Utils.read_snes_rom(stream)

    def read_bit(self, address: int, bit_number: int) -> bool:
        bitflag = 1 << bit_number
        return (self.buffer[address] & bitflag) != 0

    def read_byte(self, address: int) -> int:
        return self.buffer[address]

    def read_bytes(self, startaddress: int, length: int) -> bytearray:
        return self.buffer[startaddress:startaddress + length]

    def write_byte(self, address: int, value: int) -> None:
        self.buffer[address] = value

    def write_bytes(self, startaddress: int, values: Collection[SupportsIndex]) -> None:
        self.buffer[startaddress:startaddress + len(values)] = values

    def write_to_file(self, file: str) -> None:
        with open(file, "wb") as outfile:
            outfile.write(self.buffer)

    def read_from_file(self, file: str) -> None:
        with open(file, "rb") as stream:
            self.buffer = bytearray(stream.read())

def handle_items(rom: LocalRom) -> None:
    rom.write_bytes(0x0077B0, bytearray([0xE2, 0x20, 0xAD, 0x40, 0x14, 0xC2, 0x20, 0xF0, 0x08, 0xBD, 0x82, 0x71, 0x18, 0x5C, 0x3B, 0xB6]))
    rom.write_bytes(0x0077C0, bytearray([0x0E, 0x5C, 0x97, 0xB6, 0x0E, 0xA0, 0xFF, 0xAD, 0x74, 0x79, 0x29, 0x01, 0x00, 0xD0, 0x02, 0xA0]))
    rom.write_bytes(0x0077D0, bytearray([0x05, 0x98, 0x9D, 0xA2, 0x74, 0x6B, 0xE2, 0x20, 0xBD, 0x60, 0x73, 0xDA, 0xC2, 0x20, 0xA2, 0x00]))
    rom.write_bytes(0x0077E0, bytearray([0xDF, 0x70, 0xAF, 0x09, 0xF0, 0x08, 0xE8, 0xE8, 0xE0, 0x08, 0xF0, 0x23, 0x80, 0xF2, 0xE2, 0x20]))
    rom.write_bytes(0x0077F0, bytearray([0x8A, 0x4A, 0xAA, 0xBF, 0x78, 0xAF, 0x09, 0xAA, 0xBD, 0x40, 0x14, 0xC2, 0x20, 0xF0, 0x08, 0xFA]))
    rom.write_bytes(0x007800, bytearray([0xA0, 0x05, 0x98, 0x9D, 0xA2, 0x74, 0x60, 0xFA, 0x22, 0xC5, 0xF7, 0x00, 0xEA, 0xEA, 0x60, 0xFA]))
    rom.write_bytes(0x007810, bytearray([0x60, 0x22, 0x23, 0xAF, 0x03, 0x20, 0xD6, 0xF7, 0x6B, 0x20, 0x2F, 0xF8, 0xE2, 0x20, 0xC9, 0x00]))
    rom.write_bytes(0x007820, bytearray([0xD0, 0x03, 0xC2, 0x20, 0x6B, 0xC2, 0x20, 0xBD, 0x60, 0x73, 0x38, 0x5C, 0xB1, 0xC9, 0x03, 0xDA]))
    rom.write_bytes(0x007830, bytearray([0xBD, 0x60, 0x73, 0xA2, 0x00, 0xDF, 0x7C, 0xAF, 0x09, 0xF0, 0x08, 0xE8, 0xE8, 0xE0, 0x0A, 0xF0]))
    rom.write_bytes(0x007840, bytearray([0x13, 0x80, 0xF2, 0xE2, 0x20, 0x8A, 0x4A, 0xAA, 0xBF, 0x86, 0xAF, 0x09, 0xAA, 0xBD, 0x40, 0x14]))
    rom.write_bytes(0x007850, bytearray([0xFA, 0xC2, 0x20, 0x60, 0xA9, 0x01, 0x00, 0xFA, 0x60, 0x20, 0x2F, 0xF8, 0xE2, 0x20, 0xC9, 0x00]))
    rom.write_bytes(0x007860, bytearray([0xC2, 0x20, 0xD0, 0x06, 0x22, 0xC5, 0xF7, 0x00, 0x80, 0x04, 0x22, 0xCF, 0xF7, 0x00, 0xA5, 0x14]))
    rom.write_bytes(0x007870, bytearray([0x29, 0x0F, 0x00, 0x5C, 0x9A, 0xC9, 0x03, 0x5A, 0xE2, 0x10, 0x20, 0x2F, 0xF8, 0xC2, 0x10, 0x7A]))
    rom.write_bytes(0x007880, bytearray([0xE2, 0x20, 0xC9, 0x00, 0xC2, 0x20, 0xD0, 0x08, 0xAD, 0x74, 0x79, 0x29, 0x01, 0x00, 0xF0, 0x04]))
    rom.write_bytes(0x007890, bytearray([0x22, 0x3C, 0xAA, 0x03, 0xE2, 0x10, 0x5C, 0x47, 0xC9, 0x03, 0x22, 0x23, 0xAF, 0x03, 0xBD, 0x60]))
    rom.write_bytes(0x0078A0, bytearray([0x73, 0xC9, 0x6F, 0x00, 0xF0, 0x07, 0xE2, 0x20, 0xAD, 0x4A, 0x14, 0x80, 0x05, 0xE2, 0x20, 0xAD]))
    rom.write_bytes(0x0078B0, bytearray([0x49, 0x14, 0xC2, 0x20, 0xD0, 0x06, 0x22, 0xC5, 0xF7, 0x00, 0x80, 0x04, 0x22, 0xCF, 0xF7, 0x00]))
    rom.write_bytes(0x0078C0, bytearray([0x5C, 0x2D, 0x83, 0x05, 0xBD, 0x60, 0x73, 0xC9, 0x6F, 0x00, 0xF0, 0x07, 0xE2, 0x20, 0xAD, 0x4A]))
    rom.write_bytes(0x0078D0, bytearray([0x14, 0x80, 0x05, 0xE2, 0x20, 0xAD, 0x49, 0x14, 0xC2, 0x20, 0xD0, 0x04, 0x5C, 0xA0, 0x83, 0x05]))
    rom.write_bytes(0x0078E0, bytearray([0xAD, 0xAC, 0x60, 0x0D, 0xAE, 0x60, 0x5C, 0x84, 0x83, 0x05, 0x22, 0x52, 0xAA, 0x03, 0xBD, 0x60]))
    rom.write_bytes(0x0078F0, bytearray([0x73, 0xC9, 0x1E, 0x01, 0xE2, 0x20, 0xF0, 0x05, 0xAD, 0x4C, 0x14, 0x80, 0x03, 0xAD, 0x4B, 0x14]))
    rom.write_bytes(0x007900, bytearray([0xEA, 0xC2, 0x20, 0xF0, 0x08, 0x22, 0xCF, 0xF7, 0x00, 0x5C, 0xA6, 0xF0, 0x05, 0x22, 0xC5, 0xF7]))
    rom.write_bytes(0x007910, bytearray([0x00, 0x5C, 0xA6, 0xF0, 0x05, 0xE2, 0x20, 0xAD, 0x1C, 0x01, 0xC9, 0x0E, 0xC2, 0x20, 0xF0, 0x18]))
    rom.write_bytes(0x007920, bytearray([0x20, 0x59, 0xF9, 0xE2, 0x20, 0xC9, 0x00, 0xF0, 0x04, 0xA9, 0x10, 0x80, 0x2A, 0xA9, 0x02, 0x9D]))
    rom.write_bytes(0x007930, bytearray([0x00, 0x6F, 0xC2, 0x20, 0x22, 0xC5, 0xF7, 0x00, 0xA2, 0x0A, 0xA9, 0x2F, 0xCE, 0x5C, 0x22, 0x80]))
    rom.write_bytes(0x007940, bytearray([0x04, 0x20, 0x59, 0xF9, 0xE2, 0x20, 0xC9, 0x00, 0xC2, 0x20, 0xF0, 0x0A, 0xAD, 0x0E, 0x30, 0x29]))
    rom.write_bytes(0x007950, bytearray([0x03, 0x00, 0x5C, 0x2E, 0x80, 0x04, 0x6B, 0x80, 0xD6, 0xDA, 0xBD, 0x60, 0x73, 0xA2, 0x00, 0xDF]))
    rom.write_bytes(0x007960, bytearray([0x8B, 0xAF, 0x09, 0xF0, 0x04, 0xE8, 0xE8, 0x80, 0xF6, 0xE2, 0x20, 0x8A, 0x4A, 0xAA, 0xBF, 0x91]))
    rom.write_bytes(0x007970, bytearray([0xAF, 0x09, 0xAA, 0xBD, 0x40, 0x14, 0xFA, 0xC2, 0x20, 0x60, 0x22, 0x2E, 0xAA, 0x03, 0xE2, 0x20]))
    rom.write_bytes(0x007980, bytearray([0xAD, 0x50, 0x14, 0xC2, 0x20, 0xD0, 0x06, 0x22, 0xC5, 0xF7, 0x00, 0x80, 0x04, 0x22, 0xCF, 0xF7]))
    rom.write_bytes(0x007990, bytearray([0x00, 0x5C, 0x05, 0x99, 0x02, 0x69, 0x20, 0x00, 0xC9, 0x20, 0x01, 0xB0, 0x0D, 0xE2, 0x20, 0xAD]))
    rom.write_bytes(0x0079A0, bytearray([0x50, 0x14, 0xC2, 0x20, 0xF0, 0x04, 0x5C, 0x3E, 0x99, 0x02, 0x5C, 0x8C, 0x99, 0x02, 0x22, 0x23]))
    rom.write_bytes(0x0079B0, bytearray([0xAF, 0x03, 0xE2, 0x20, 0xAD, 0x1C, 0x01, 0xC9, 0x02, 0xC2, 0x20, 0xD0, 0x18, 0x20, 0x59, 0xF9]))
    rom.write_bytes(0x0079C0, bytearray([0xE2, 0x20, 0xC9, 0x00, 0xD0, 0x13, 0xC2, 0x20, 0x22, 0xC5, 0xF7, 0x00, 0xE2, 0x20, 0xA9, 0x02]))
    rom.write_bytes(0x0079D0, bytearray([0x9D, 0x00, 0x6F, 0xC2, 0x20, 0x5C, 0x35, 0x80, 0x04, 0xC2, 0x20, 0x22, 0xCF, 0xF7, 0x00, 0x80]))
    rom.write_bytes(0x0079E0, bytearray([0xF2, 0xE2, 0x20, 0xAD, 0x4E, 0x14, 0xC2, 0x20, 0xF0, 0x07, 0xA9, 0x14, 0x00, 0x5C, 0x9E, 0xF1]))
    rom.write_bytes(0x0079F0, bytearray([0x07, 0xA9, 0x0E, 0x00, 0x80, 0xF7, 0xBD, 0x60, 0x73, 0xDA, 0xA2, 0x00, 0xDF, 0x94, 0xAF, 0x09]))
    rom.write_bytes(0x007A00, bytearray([0xF0, 0x11, 0xE0, 0x08, 0xF0, 0x04, 0xE8, 0xE8, 0x80, 0xF2, 0xFA, 0x22, 0x57, 0xF9, 0x0C, 0x5C]))
    rom.write_bytes(0x007A10, bytearray([0xBD, 0xBE, 0x03, 0x8A, 0x4A, 0xE2, 0x20, 0xAA, 0xBF, 0x9E, 0xAF, 0x09, 0xAA, 0xBD, 0x40, 0x14]))
    rom.write_bytes(0x007A20, bytearray([0xC9, 0x00, 0xC2, 0x20, 0xF0, 0x02, 0x80, 0xE2, 0x4C, 0x61, 0xFF, 0x00, 0x9D, 0x00, 0x6F, 0x74]))
    rom.write_bytes(0x007A30, bytearray([0x78, 0x74, 0x18, 0x74, 0x76, 0x9E, 0x36, 0x7A, 0x9E, 0x38, 0x7A, 0x9E, 0x38, 0x7D, 0xBC, 0xC2]))
    rom.write_bytes(0x007A40, bytearray([0x77, 0xB9, 0xB5, 0xBE, 0x9D, 0x20, 0x72, 0xA9, 0x00, 0xFC, 0x9D, 0x22, 0x72, 0xA9, 0x40, 0x00]))
    rom.write_bytes(0x007A50, bytearray([0x9D, 0x42, 0x75, 0xA9, 0x90, 0x00, 0x22, 0xD2, 0x85, 0x00, 0x6B, 0x5A, 0xE2, 0x20, 0xAD, 0x51]))
    rom.write_bytes(0x007A60, bytearray([0x14, 0xC9, 0x00, 0xC2, 0x20, 0xF0, 0x0D, 0x22, 0xCF, 0xF7, 0x00, 0x7A, 0x9B, 0xAD, 0x30, 0x00]))
    rom.write_bytes(0x007A70, bytearray([0x5C, 0x62, 0xB7, 0x03, 0x22, 0xC5, 0xF7, 0x00, 0x7A, 0x9B, 0xA9, 0x03, 0x00, 0x5C, 0x62, 0xB7]))
    rom.write_bytes(0x007A80, bytearray([0x03, 0x22, 0x23, 0xAF, 0x03, 0xE2, 0x20, 0xAD, 0x53, 0x14, 0xF0, 0x07, 0xC2, 0x20, 0x22, 0xCF]))
    rom.write_bytes(0x007A90, bytearray([0xF7, 0x00, 0x6B, 0xC2, 0x20, 0x22, 0xC5, 0xF7, 0x00, 0x6B, 0xE2, 0x20, 0xAD, 0x53, 0x14, 0xF0]))
    rom.write_bytes(0x007AA0, bytearray([0x07, 0xC2, 0x20, 0x22, 0x78, 0xBA, 0x07, 0x6B, 0xC2, 0x20, 0x6B, 0xC9, 0x06, 0x00, 0xB0, 0x0F]))
    rom.write_bytes(0x007AB0, bytearray([0xE2, 0x20, 0xAD, 0x54, 0x14, 0xC9, 0x00, 0xC2, 0x20, 0xF0, 0x04, 0x5C, 0x94, 0x81, 0x07, 0x5C]))
    rom.write_bytes(0x007AC0, bytearray([0xFB, 0x81, 0x07, 0x22, 0x23, 0xAF, 0x03, 0xE2, 0x20, 0xAD, 0x54, 0x14, 0xC2, 0x20, 0xF0, 0x08]))
    rom.write_bytes(0x007AD0, bytearray([0x22, 0xCF, 0xF7, 0x00, 0x5C, 0xF7, 0x80, 0x07, 0x22, 0xC5, 0xF7, 0x00, 0x5C, 0xF7, 0x80, 0x07]))
    rom.write_bytes(0x007AE0, bytearray([0x5A, 0xE2, 0x20, 0xAD, 0x55, 0x14, 0xC2, 0x20, 0xF0, 0x06, 0x22, 0xCF, 0xF7, 0x00, 0x80, 0x06]))
    rom.write_bytes(0x007AF0, bytearray([0x22, 0xC5, 0xF7, 0x00, 0x80, 0x04, 0x22, 0x65, 0xC3, 0x0E, 0x7A, 0x5C, 0xFA, 0xBE, 0x0E, 0xE2]))
    rom.write_bytes(0x007B00, bytearray([0x20, 0xAD, 0x56, 0x14, 0xC2, 0x20, 0xF0, 0x0A, 0x22, 0xCF, 0xF7, 0x00, 0x22, 0xB7, 0xA5, 0x03]))
    rom.write_bytes(0x007B10, bytearray([0x80, 0x04, 0x22, 0xC5, 0xF7, 0x00, 0x5C, 0x3D, 0x96, 0x07, 0xBD, 0x02, 0x79, 0x85, 0x0E, 0xE2]))
    rom.write_bytes(0x007B20, bytearray([0x20, 0xAD, 0x57, 0x14, 0xC2, 0x20, 0xF0, 0x05, 0x22, 0xCF, 0xF7, 0x00, 0x6B, 0x22, 0xC5, 0xF7]))
    rom.write_bytes(0x007B30, bytearray([0x00, 0x6B, 0xE2, 0x20, 0xAD, 0x57, 0x14, 0xC2, 0x20, 0xD0, 0x0C, 0xAD, 0x74, 0x79, 0x29, 0x01]))
    rom.write_bytes(0x007B40, bytearray([0x00, 0xD0, 0x04, 0x5C, 0x4A, 0xF3, 0x06, 0xBD, 0xD6, 0x79, 0x38, 0xFD, 0xE2, 0x70, 0x5C, 0x45]))
    rom.write_bytes(0x007B50, bytearray([0xF2, 0x06, 0xAD, 0xAA, 0x60, 0x48, 0x30, 0x0E, 0xE2, 0x20, 0xAD, 0x57, 0x14, 0xC2, 0x20, 0xF0]))
    rom.write_bytes(0x007B60, bytearray([0x05, 0x68, 0x5C, 0xA0, 0xF3, 0x06, 0x68, 0x5C, 0xE6, 0xF3, 0x06, 0xBD, 0x02, 0x79, 0x85, 0x0E]))
    rom.write_bytes(0x007B70, bytearray([0xE2, 0x20, 0xAD, 0x57, 0x14, 0xC2, 0x20, 0xD0, 0x08, 0x22, 0xC5, 0xF7, 0x00, 0x5C, 0x35, 0xE5]))
    rom.write_bytes(0x007B80, bytearray([0x06, 0x22, 0xCF, 0xF7, 0x00, 0x5C, 0x35, 0xE5, 0x06, 0xE2, 0x20, 0xAD, 0x57, 0x14, 0xC2, 0x20]))
    rom.write_bytes(0x007B90, bytearray([0xD0, 0x0C, 0xAD, 0x74, 0x79, 0x29, 0x01, 0x00, 0xD0, 0x04, 0x5C, 0x48, 0xF3, 0x06, 0xBD, 0x36]))
    rom.write_bytes(0x007BA0, bytearray([0x7A, 0x38, 0xE9, 0x08, 0x00, 0x5C, 0x63, 0xE8, 0x06, 0xAD, 0xAA, 0x60, 0x30, 0x0D, 0xE2, 0x20]))
    rom.write_bytes(0x007BB0, bytearray([0xAD, 0x57, 0x14, 0xC2, 0x20, 0xF0, 0x04, 0x5C, 0x99, 0xE8, 0x06, 0x5C, 0xF1, 0xE8, 0x06, 0x9C]))
    rom.write_bytes(0x007BC0, bytearray([0xB0, 0x61, 0x9C, 0x8C, 0x0C, 0xE2, 0x20, 0xAD, 0x58, 0x14, 0xC2, 0x20, 0xF0, 0x07, 0x9C, 0x8E]))
    rom.write_bytes(0x007BD0, bytearray([0x0C, 0x5C, 0x9D, 0xA4, 0x02, 0xA9, 0x00, 0x00, 0x8F, 0xAE, 0x00, 0x70, 0x8F, 0xAC, 0x00, 0x70]))
    rom.write_bytes(0x007BE0, bytearray([0xE2, 0x20, 0xA9, 0xFE, 0x9D, 0x78, 0x79, 0x8F, 0x49, 0x00, 0x7E, 0xC2, 0x20, 0x5C, 0x9D, 0xA4]))
    rom.write_bytes(0x007BF0, bytearray([0x02, 0xE2, 0x20, 0xAF, 0x49, 0x00, 0x7E, 0xC2, 0x20, 0xF0, 0x0D, 0xA9, 0x00, 0x00, 0x9D, 0xD8]))
    rom.write_bytes(0x007C00, bytearray([0x79, 0x9D, 0x78, 0x79, 0x8F, 0x49, 0x00, 0x7E, 0xBD, 0x16, 0x7C, 0x18, 0x5C, 0x51, 0xA3, 0x02]))
    rom.write_bytes(0x007C10, bytearray([0xE2, 0x20, 0xAD, 0x59, 0x14, 0xC2, 0x20, 0xD0, 0x0D, 0x22, 0xC5, 0xF7, 0x00, 0xBD, 0x38, 0x7D]))
    rom.write_bytes(0x007C20, bytearray([0xF0, 0x0A, 0x5C, 0x4F, 0xA0, 0x02, 0x22, 0xCF, 0xF7, 0x00, 0x80, 0xF1, 0x5C, 0x59, 0xA0, 0x02]))
    rom.write_bytes(0x007C30, bytearray([0xE2, 0x20, 0xAD, 0x59, 0x14, 0xC2, 0x20, 0xF0, 0x09, 0xBB, 0x22, 0x87, 0xBF, 0x03, 0x5C, 0x8D]))
    rom.write_bytes(0x007C40, bytearray([0xA3, 0x02, 0x5C, 0x81, 0xA3, 0x02, 0xE2, 0x20, 0xAD, 0x5A, 0x14, 0xC2, 0x20, 0xF0, 0x09, 0xB5]))
    rom.write_bytes(0x007C50, bytearray([0x76, 0x29, 0xFF, 0x00, 0x5C, 0x9D, 0x93, 0x02, 0x8D, 0x04, 0x30, 0xA9, 0x00, 0x00, 0x8D, 0x08]))
    rom.write_bytes(0x007C60, bytearray([0x30, 0x5C, 0xA5, 0x93, 0x02, 0xE2, 0x20, 0xAD, 0x5A, 0x14, 0xC2, 0x20, 0xD0, 0x01, 0x6B, 0x22]))
    rom.write_bytes(0x007C70, bytearray([0x23, 0xAF, 0x03, 0x5C, 0xDA, 0x93, 0x02, 0xE2, 0x20, 0xAD, 0x5B, 0x14, 0xC2, 0x20, 0xF0, 0x09]))
    rom.write_bytes(0x007C80, bytearray([0x9B, 0xBD, 0xD6, 0x79, 0x0A, 0x5C, 0xCA, 0xC4, 0x05, 0x6B, 0xE2, 0x20, 0xAD, 0x5B, 0x14, 0xC2]))
    rom.write_bytes(0x007C90, bytearray([0x20, 0xF0, 0x09, 0x9B, 0xBD, 0xD6, 0x79, 0x0A, 0x5C, 0xC1, 0xC8, 0x05, 0x6B, 0x22, 0x52, 0xAA]))
    rom.write_bytes(0x007CA0, bytearray([0x03, 0xE2, 0x20, 0xAD, 0x5B, 0x14, 0xC2, 0x20, 0xF0, 0x0A, 0xA0, 0x00, 0x22, 0xD1, 0xF7, 0x00]))
    rom.write_bytes(0x007CB0, bytearray([0x5C, 0xD9, 0xC4, 0x05, 0x22, 0xC5, 0xF7, 0x00, 0x5C, 0x70, 0xC5, 0x05, 0x22, 0x23, 0xAF, 0x03]))
    rom.write_bytes(0x007CC0, bytearray([0xE2, 0x20, 0xAD, 0x5C, 0x14, 0xC2, 0x20, 0xF0, 0x0A, 0xA0, 0x00, 0x22, 0xD1, 0xF7, 0x00, 0x5C]))
    rom.write_bytes(0x007CD0, bytearray([0x24, 0xC9, 0x0C, 0x22, 0xC5, 0xF7, 0x00, 0x80, 0xF6, 0xE2, 0x20, 0xAD, 0x5C, 0x14, 0xC2, 0x20]))
    rom.write_bytes(0x007CE0, bytearray([0xF0, 0x08, 0x8A, 0x8D, 0x02, 0x30, 0x5C, 0x4D, 0xCD, 0x0C, 0xFA, 0x5C, 0x3A, 0xCD, 0x0C, 0x48]))
    rom.write_bytes(0x007CF0, bytearray([0xDA, 0xE2, 0x20, 0xAD, 0x5D, 0x14, 0xF0, 0x33, 0xAA, 0x4C, 0x53, 0xFF, 0xFF, 0x18, 0x4C, 0x71]))
    rom.write_bytes(0x007D00, bytearray([0xFF, 0x8D, 0x5E, 0x14, 0xC2, 0x20, 0xFA, 0x68, 0x1A, 0x1A, 0xC9, 0x0E, 0x00, 0x90, 0x06, 0x80]))
    rom.write_bytes(0x007D10, bytearray([0x16, 0x5C, 0x15, 0xBF, 0x03, 0xE2, 0x20, 0x48, 0xBD, 0x60, 0x73, 0xC9, 0x27, 0xF0, 0x12, 0x68]))
    rom.write_bytes(0x007D20, bytearray([0xCD, 0x5E, 0x14, 0xC2, 0x20, 0x90, 0xEA, 0x5C, 0xE5, 0xFA, 0x0B, 0x1A, 0x8D, 0x5D, 0x14, 0x80]))
    rom.write_bytes(0x007D30, bytearray([0xC0, 0x68, 0xC2, 0x20, 0xEE, 0xCC, 0x00, 0xEE, 0xCC, 0x00, 0x80, 0xD5, 0xA8, 0x5C, 0x20, 0xBF]))
    rom.write_bytes(0x007D40, bytearray([0x03, 0x8B, 0xA9, 0x03, 0x8D, 0x4B, 0x09, 0x8D, 0x01, 0x21, 0x22, 0x39, 0xB4, 0x00, 0x22, 0x79]))
    rom.write_bytes(0x007D50, bytearray([0x82, 0x10, 0xDA, 0xAD, 0x0E, 0x03, 0x4A, 0xAA, 0xBF, 0xF3, 0xFE, 0x06, 0xAA, 0xAD, 0x1A, 0x02]))
    rom.write_bytes(0x007D60, bytearray([0x9F, 0x00, 0x7C, 0x70, 0x9C, 0x22, 0x02, 0xAF, 0x83, 0xFC, 0x0D, 0xAA, 0xBF, 0xB2, 0xAF, 0x09]))
    rom.write_bytes(0x007D70, bytearray([0x0C, 0xCE, 0x00, 0xAD, 0x60, 0x14, 0x0C, 0xCE, 0x00, 0x5A, 0xC2, 0x10, 0xA2, 0xAA, 0xAF, 0xAD]))
    rom.write_bytes(0x007D80, bytearray([0xCE, 0x00, 0x89, 0x01, 0xF0, 0x06, 0xA0, 0x22, 0x02, 0x20, 0xCA, 0xFD, 0x89, 0x02, 0xF0, 0x06]))
    rom.write_bytes(0x007D90, bytearray([0xA0, 0x2E, 0x02, 0x20, 0xCA, 0xFD, 0x89, 0x04, 0xF0, 0x06, 0xA0, 0x3A, 0x02, 0x20, 0xCA, 0xFD]))
    rom.write_bytes(0x007DA0, bytearray([0x89, 0x08, 0xF0, 0x06, 0xA0, 0x46, 0x02, 0x20, 0xCA, 0xFD, 0x89, 0x10, 0xF0, 0x06, 0xA0, 0x52]))
    rom.write_bytes(0x007DB0, bytearray([0x02, 0x20, 0xCA, 0xFD, 0x89, 0x20, 0xF0, 0x06, 0xA0, 0x5E, 0x02, 0x20, 0xCA, 0xFD, 0x9C, 0x65]))
    rom.write_bytes(0x007DC0, bytearray([0x02, 0xE2, 0x10, 0x7A, 0xFA, 0xAB, 0x5C, 0xB6, 0xA5, 0x17, 0xC2, 0x20, 0x48, 0xA9, 0x07, 0x00]))
    rom.write_bytes(0x007DD0, bytearray([0xDA, 0x54, 0x00, 0x09, 0xFA, 0x68, 0xE2, 0x20, 0x60, 0xDA, 0x5A, 0x8B, 0xAD, 0x0E, 0x03, 0xC2]))
    rom.write_bytes(0x007DE0, bytearray([0x20, 0xC2, 0x10, 0xAA, 0xBF, 0x07, 0xFF, 0x06, 0xA8, 0xE2, 0x20, 0xA9, 0x00, 0xEB, 0xA9, 0x7F]))
    rom.write_bytes(0x007DF0, bytearray([0xA2, 0xC0, 0x14, 0x54, 0x70, 0x7E, 0xA2, 0xC0, 0x14, 0xA0, 0x40, 0x14, 0xA9, 0x00, 0xEB, 0xA9]))
    rom.write_bytes(0x007E00, bytearray([0x7F, 0x54, 0x7E, 0x7E, 0xE2, 0x10, 0xAB, 0x7A, 0xFA, 0xA9, 0x1E, 0x8D, 0x18, 0x01, 0xAF, 0x83]))
    rom.write_bytes(0x007E10, bytearray([0xFC, 0x0D, 0xDA, 0xAA, 0xBF, 0xB8, 0xAF, 0x09, 0x8D, 0x18, 0x02, 0xAF, 0x88, 0xFC, 0x0D, 0x49]))
    rom.write_bytes(0x007E20, bytearray([0x01, 0x8D, 0x5A, 0x14, 0xFA, 0x5C, 0x58, 0x99, 0x17, 0xAE, 0x15, 0x11, 0xAD, 0x60, 0x14, 0x89]))
    rom.write_bytes(0x007E30, bytearray([0x01, 0xD0, 0x0D, 0xAF, 0x83, 0xFC, 0x0D, 0xF0, 0x07, 0x9E, 0x10, 0x00, 0x5C, 0xB1, 0xD8, 0x17]))
    rom.write_bytes(0x007E40, bytearray([0xFE, 0x10, 0x00, 0x80, 0xF7, 0xA9, 0xF0, 0x85, 0x4D, 0x8D, 0x63, 0x14, 0xA9, 0x80, 0x8D, 0x20]))
    rom.write_bytes(0x007E50, bytearray([0x02, 0x8D, 0x4A, 0x00, 0x5C, 0x59, 0xC1, 0x01, 0xE2, 0x20, 0xAD, 0x61, 0x14, 0x89, 0x01, 0xF0]))
    rom.write_bytes(0x007E60, bytearray([0x08, 0x48, 0xA9, 0x09, 0x8F, 0x17, 0x03, 0x17, 0x68, 0x89, 0x02, 0xF0, 0x08, 0x48, 0xA9, 0x09]))
    rom.write_bytes(0x007E70, bytearray([0x8F, 0x23, 0x03, 0x17, 0x68, 0x89, 0x04, 0xF0, 0x08, 0x48, 0xA9, 0x09, 0x8F, 0x2F, 0x03, 0x17]))
    rom.write_bytes(0x007E80, bytearray([0x68, 0x89, 0x08, 0xF0, 0x08, 0x48, 0xA9, 0x09, 0x8F, 0x3B, 0x03, 0x17, 0x68, 0x89, 0x10, 0xF0]))
    rom.write_bytes(0x007E90, bytearray([0x08, 0x48, 0xA9, 0x09, 0x8F, 0x47, 0x03, 0x17, 0x68, 0x89, 0x20, 0xF0, 0x08, 0x48, 0xA9, 0x09]))
    rom.write_bytes(0x007EA0, bytearray([0x8F, 0x53, 0x03, 0x17, 0x68, 0xAD, 0x62, 0x14, 0x89, 0x01, 0xF0, 0x08, 0x48, 0xA9, 0x0A, 0x8F]))
    rom.write_bytes(0x007EB0, bytearray([0x18, 0x03, 0x17, 0x68, 0x89, 0x02, 0xF0, 0x08, 0x48, 0xA9, 0x0A, 0x8F, 0x24, 0x03, 0x17, 0x68]))
    rom.write_bytes(0x007EC0, bytearray([0x89, 0x04, 0xF0, 0x08, 0x48, 0xA9, 0x0A, 0x8F, 0x30, 0x03, 0x17, 0x68, 0x89, 0x08, 0xF0, 0x08]))
    rom.write_bytes(0x007ED0, bytearray([0x48, 0xA9, 0x0A, 0x8F, 0x3C, 0x03, 0x17, 0x68, 0x89, 0x10, 0xF0, 0x08, 0x48, 0xA9, 0x0A, 0x8F]))
    rom.write_bytes(0x007EE0, bytearray([0x48, 0x03, 0x17, 0x68, 0x89, 0x20, 0xF0, 0x08, 0x48, 0xA9, 0x0A, 0x8F, 0x54, 0x03, 0x17, 0x68]))
    rom.write_bytes(0x007EF0, bytearray([0xC2, 0x20, 0x5C, 0x26, 0xDB, 0x17, 0xAD, 0x63, 0x14, 0xF0, 0x0E, 0xA9, 0x00, 0x8D, 0x63, 0x14]))
    rom.write_bytes(0x007F00, bytearray([0xA9, 0x20, 0x8D, 0x18, 0x01, 0x5C, 0x04, 0xA9, 0x17, 0xA9, 0x25, 0x80, 0xF5, 0xAD, 0x06, 0x7E]))
    rom.write_bytes(0x007F10, bytearray([0xD0, 0x15, 0xE2, 0x20, 0xAD, 0x64, 0x14, 0xD0, 0x0E, 0xAF, 0x84, 0xFC, 0x0D, 0x89, 0x01, 0xD0]))
    rom.write_bytes(0x007F20, bytearray([0x06, 0xC2, 0x20, 0x5C, 0x49, 0xEA, 0x0C, 0xC2, 0x20, 0x5C, 0x47, 0xEA, 0x0C, 0xAD, 0x06, 0x7E]))
    rom.write_bytes(0x007F30, bytearray([0xD0, 0x15, 0xE2, 0x20, 0xAD, 0x64, 0x14, 0xD0, 0x0E, 0xAF, 0x84, 0xFC, 0x0D, 0x89, 0x02, 0xD0]))
    rom.write_bytes(0x007F40, bytearray([0x06, 0xC2, 0x20, 0x5C, 0x91, 0xC0, 0x03, 0xC2, 0x20, 0x5C, 0xCC, 0xC0, 0x03]))
    rom.write_bytes(0x007F53, bytearray([0xBF, 0xA3, 0xAF, 0x09, 0xE0, 0x06, 0xF0, 0x03, 0x4C, 0xFD, 0xFC, 0x4C, 0x01, 0xFD]))
    rom.write_bytes(0x007F61, bytearray([0xAF, 0xAE, 0x00, 0x70, 0xD0, 0x07, 0xFA, 0xA9, 0x0E, 0x00, 0x4C, 0x2C, 0xFA, 0x4C, 0x26, 0xFA]))
    rom.write_bytes(0x007F71, bytearray([0x6D, 0xCC, 0x00, 0xC9, 0x0E, 0x90, 0x02, 0xA9, 0x0E, 0x4C, 0x01, 0xFD]))

    rom.write_bytes(0x077F82, bytearray([0xE2, 0x20, 0xAD, 0x40, 0x14, 0xD0, 0x08, 0xC2, 0x20, 0x22, 0xC5, 0xF7, 0x00, 0x80]))
    rom.write_bytes(0x077F90, bytearray([0x06, 0xA0, 0x00, 0x22, 0xD1, 0xF7, 0x00, 0xC2, 0x20, 0x20, 0x1A, 0xB6, 0x60, 0xE2, 0x20, 0xAD]))
    rom.write_bytes(0x077FA0, bytearray([0x55, 0x14, 0xC2, 0x20, 0xD0, 0x03, 0x4C, 0xFD, 0xBE, 0x20, 0xBB, 0xBF, 0x4C, 0xFD, 0xBE]))

    rom.write_bytes(0x01FEEE, bytearray([0xB9, 0x00]))
    rom.write_bytes(0x01FEF0, bytearray([0x6F, 0x48, 0xDA, 0xBD, 0x60, 0x73, 0xA2, 0x00, 0xDF, 0x70, 0xAF, 0x09, 0xF0, 0x08, 0xE8, 0xE8]))
    rom.write_bytes(0x01FF00, bytearray([0xE0, 0x08, 0xF0, 0x1A, 0x80, 0xF2, 0x8A, 0x4A, 0xE2, 0x20, 0xAA, 0xBF, 0x78, 0xAF, 0x09, 0xAA]))
    rom.write_bytes(0x01FF10, bytearray([0xBD, 0x40, 0x14, 0xC2, 0x20, 0xD0, 0x07, 0xFA, 0x68, 0xC9, 0x00, 0x00, 0x80, 0x05, 0xFA, 0x68]))
    rom.write_bytes(0x01FF20, bytearray([0xC9, 0x10, 0x00, 0x5C, 0x34, 0xC3, 0x03, 0xAE, 0x12, 0x98, 0xE2, 0x20, 0xAD, 0x5E, 0x14, 0xC9]))
    rom.write_bytes(0x01FF30, bytearray([0x0E, 0xF0, 0x08, 0x3A, 0x3A, 0xA8, 0xC2, 0x20, 0x4C, 0x15, 0xBF, 0x98, 0x80, 0xF8]))

    rom.write_bytes(0x02FFC0, bytearray([0x0C, 0xA6, 0x12, 0x6B, 0xBD, 0x60, 0x73, 0xC9, 0x1E, 0x01, 0xE2, 0x20, 0xF0, 0x05, 0xAD, 0x4C]))
    rom.write_bytes(0x02FFD0, bytearray([0x14, 0x80, 0x03, 0xAD, 0x4B, 0x14, 0xC9, 0x00, 0xC2, 0x20, 0xF0, 0x03, 0x20, 0xF6, 0xF1, 0x4C]))
    rom.write_bytes(0x02FFE0, bytearray([0xB0, 0xF0]))

    rom.write_bytes(0x017FD7, bytearray([0xE2, 0x20, 0xAD, 0x4D, 0x14, 0xC2, 0x20, 0xF0, 0x10]))
    rom.write_bytes(0x017FE0, bytearray([0xBD, 0x60, 0x73, 0xC9, 0xA9, 0x01, 0xF0, 0x04, 0xA9, 0x04, 0x00, 0x60, 0xA9, 0x0A, 0x00, 0x60]))
    rom.write_bytes(0x017FF0, bytearray([0x68, 0x4C, 0x90, 0xAD]))

    rom.write_bytes(0x03FF48, bytearray([0xE2, 0x20, 0xAD, 0x56, 0x14, 0xC2, 0x20, 0xD0]))
    rom.write_bytes(0x03FF50, bytearray([0x03, 0x4C, 0x5B, 0x96, 0x20, 0x3D, 0x9D, 0x4C, 0x4F, 0x96]))


def Item_Data(rom: LocalRom) -> None:
    rom.write_bytes(0x04AF70, bytearray([0xBB, 0x00, 0xBA, 0x00, 0xC7, 0x00, 0xC8, 0x00, 0x01, 0x02, 0x03, 0x03, 0xB1, 0x00, 0xB0, 0x00]))
    rom.write_bytes(0x04AF80, bytearray([0xB2, 0x00, 0xAF, 0x00, 0xB4, 0x00, 0x04, 0x05, 0x06, 0x07, 0x08, 0x07, 0x00, 0x05, 0x00, 0x09]))
    rom.write_bytes(0x04AF90, bytearray([0x00, 0x0D, 0x0E, 0x0F, 0x22, 0x00, 0x26, 0x00, 0x29, 0x00, 0x2A, 0x00, 0x2B, 0x00, 0x11, 0x12]))
    rom.write_bytes(0x04AFA0, bytearray([0x12, 0x12, 0x12, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01]))
    rom.write_bytes(0x04AFB0, bytearray([0x01, 0x01, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x02, 0x04, 0x06, 0x08, 0x0A]))


def Server_Data(rom: LocalRom) -> None:
    rom.write_bytes(0x037EAA, bytearray([0x00, 0x00, 0x01, 0x02, 0x03, 0x04]))
    rom.write_bytes(0x037EB0, bytearray([0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14]))
    rom.write_bytes(0x037EC0, bytearray([0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x24, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x01]))
    rom.write_bytes(0x037ED0, bytearray([0x02, 0x04, 0x08, 0x10, 0x20, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30]))
    rom.write_bytes(0x037EE0, bytearray([0x31, 0x32, 0x33, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0xFF, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39]))
    rom.write_bytes(0x037EF0, bytearray([0x3A, 0x3B, 0x3C, 0x02, 0x6A, 0xD2, 0x04, 0x03, 0x06, 0x07, 0x08, 0x09, 0x05, 0x01, 0x02, 0x3D]))
    rom.write_bytes(0x037F00, bytearray([0x3E, 0x3F, 0x40, 0x01, 0x02, 0x03, 0x0A, 0x80, 0x7E, 0x00, 0x7F, 0x80, 0x7F]))


def Menu_Data(rom: LocalRom) -> None:
    rom.write_bytes(0x115348, bytearray([0x80, 0x80, 0x4E, 0x80, 0x80, 0x4E, 0x80, 0x80]))
    rom.write_bytes(0x115350, bytearray([0x4E, 0x80, 0x80, 0x4E, 0x80, 0x80, 0x4E, 0x80, 0x80, 0x4E, 0x80, 0x80, 0x4E, 0x80, 0x80, 0x4E]))
    rom.write_bytes(0x115360, bytearray([0x80, 0x80, 0x4E, 0x80, 0x80, 0x4E, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03]))
    rom.write_bytes(0x115370, bytearray([0x03, 0x03, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x08, 0x08]))
    rom.write_bytes(0x115380, bytearray([0x08, 0x09, 0x09, 0x09, 0x0A, 0x0A, 0x0A, 0x24, 0x2C, 0x00, 0x06, 0x1E, 0x00, 0x06, 0x24, 0x00]))
    rom.write_bytes(0x115390, bytearray([0x02, 0x24, 0x00, 0x0E, 0x04, 0x00, 0x18, 0x26, 0x00, 0x26, 0x1A, 0x00, 0x04, 0x22, 0x00, 0x24]))
    rom.write_bytes(0x1153A0, bytearray([0x18, 0x00, 0x24, 0x02, 0x00, 0x16, 0x24, 0x00, 0x00, 0x2C, 0x00, 0x2A, 0x2C, 0x00, 0x2C, 0x18]))
    rom.write_bytes(0x1153B0, bytearray([0x00, 0x10, 0x18, 0x00, 0x0A, 0x18, 0x00, 0x24, 0x24, 0x00, 0x0A, 0x08, 0x00, 0x0C, 0x08, 0x00]))
    rom.write_bytes(0x1153C0, bytearray([0x08, 0x16, 0x00, 0x08, 0x1E, 0x00, 0x04, 0x14, 0x00, 0x1E, 0x0E, 0x00, 0x1E, 0x0C, 0x00, 0x24]))
    rom.write_bytes(0x1153D0, bytearray([0x14, 0x00, 0x14, 0x30, 0x00, 0x18, 0x22, 0x00, 0x02, 0x04, 0x00, 0x26, 0x16, 0x00, 0x24, 0x16]))
    rom.write_bytes(0x1153E0, bytearray([0x00, 0x5C, 0x38, 0x60, 0x4E, 0x28, 0x1A, 0x16, 0x1C, 0x04, 0x14, 0x36, 0x36, 0x36, 0x80, 0x80]))
    rom.write_bytes(0x1153F0, bytearray([0x34, 0x81, 0x81, 0x4E, 0x4E, 0x4E, 0x5C, 0x38, 0x60, 0x4E, 0x04, 0x16, 0x08, 0x00, 0x22, 0x36]))
    rom.write_bytes(0x115400, bytearray([0x36, 0x36, 0x36, 0x80, 0x80, 0x34, 0x81, 0x81, 0x4E, 0x4E, 0x4E, 0x50, 0x52, 0x54, 0x56, 0x58]))
    rom.write_bytes(0x115410, bytearray([0x5A, 0x5C, 0x5E, 0x60, 0x62, 0x50, 0x52, 0x54, 0x09, 0x15, 0x21, 0x2D, 0x39, 0x45, 0x0C, 0x03]))
    rom.write_bytes(0x115420, bytearray([0x07, 0x0F, 0x13, 0x1B, 0x1F, 0x27, 0x2B, 0x33, 0x37, 0x3F, 0x00, 0x00, 0x02, 0x02, 0x04, 0x04]))
    rom.write_bytes(0x115430, bytearray([0x06, 0x06, 0x08, 0x08, 0x0A, 0x41, 0x00, 0x3C, 0x00, 0x33, 0x00, 0x25, 0x00, 0x1B, 0x00, 0x14]))
    rom.write_bytes(0x115440, bytearray([0x00, 0x0B, 0x00, 0x02, 0x00, 0xF6, 0x3F, 0xEC, 0x3F, 0xDC, 0x3F]))

    rom.write_bytes(0x082660, bytearray([0x07]))
    rom.write_bytes(0x082667, bytearray([0x05]))
    rom.write_bytes(0x082677, bytearray([0x0A, 0x03, 0x05]))
    rom.write_bytes(0x082688, bytearray([0x00]))

    rom.write_bytes(0x11548E, bytearray([0x60, 0x3d, 0x66, 0x3b, 0x60, 0x3f, 0x60, 0x39, 0x66, 0x39, 0x66, 0x3d, 0x66, 0x3f, 0x60, 0x3b]))
    rom.write_bytes(0x11549E, bytearray([0x02, 0x06, 0x04, 0x00, 0x01, 0x03, 0x05, 0x07]))


def CodeHandler(rom: LocalRom) -> None:
    rom.write_bytes(0x073637, bytearray([0x5C, 0xB0, 0xF7, 0x00]))  # Check ! Switch
    rom.write_bytes(0x07360B, bytearray([0x20, 0x82, 0xFF]))  # Flash ! Switch

    rom.write_bytes(0x01C2F3, bytearray([0x22, 0x11, 0xF8, 0x00]))  # Check visibility of winged clouds
    rom.write_bytes(0x01C32E, bytearray([0x5C, 0xEE, 0xFE, 0x03]))  # Check items in winged clouds

    rom.write_bytes(0x01C9AD, bytearray([0x5C, 0x19, 0xF8, 0x00]))  # Check transformations
    rom.write_bytes(0x01C995, bytearray([0x5C, 0x59, 0xF8, 0x00]))  # Flash transformations
    rom.write_bytes(0x01C943, bytearray([0x5C, 0x77, 0xF8, 0x00]))  # Fixes a bug where transformation bubbles flashing would displace the sprite

    rom.write_bytes(0x028329, bytearray([0x5C, 0x9A, 0xF8, 0x00]))  # Flash Spring Ball
    rom.write_bytes(0x02837E, bytearray([0x5C, 0xC4, 0xF8, 0x00]))  # Check Spring Ball

    rom.write_bytes(0x02F0A2, bytearray([0x5C, 0xEA, 0xF8, 0x00]))  # Flash Arrow Wheel
    rom.write_bytes(0x02F0AD, bytearray([0x4C, 0xC4, 0xFF]))  # Check Arrow Wheel

    rom.write_bytes(0x02001D, bytearray([0x5C, 0x15, 0xF9, 0x00]))  # Check Melon
    rom.write_bytes(0x020028, bytearray([0x5C, 0x41, 0xF9, 0x00]))  # Secondary check for melon used to overwrite visibility on the ground
    rom.write_bytes(0x020031, bytearray([0x5C, 0xAE, 0xF9, 0x00]))  # Check for melons that are spawned by objects which skips the initial check
    rom.write_bytes(0x012DF7, bytearray([0x20, 0xD7, 0xFF]))  # Check for monkeys holding melons
    rom.write_bytes(0x012E07, bytearray([0x20, 0xD7, 0xFF]))  # Check for monkeys holding melons
    rom.write_bytes(0x03F17D, bytearray([0x5C, 0xE1, 0xF9, 0x00]))  # Fixes a bug where balloons with ice melons will write to yoshi's mouth before deactivating the melon.

    rom.write_bytes(0x011901, bytearray([0x5C, 0x7A, 0xF9, 0x00]))  # Flash Super Star
    rom.write_bytes(0x01192A, bytearray([0x5C, 0x95, 0xF9, 0x00]))  # Check Super Star

    rom.write_bytes(0x01BEB9, bytearray([0x5C, 0xF6, 0xF9, 0x00]))  # Check egg-type items
    rom.write_bytes(0x01B75E, bytearray([0x5C, 0x5B, 0xFA, 0x00]))  # Flash flashing eggs and force them to purple

    rom.write_bytes(0x03BA31, bytearray([0x22, 0x81, 0xFA, 0x00]))  # Flash Arrow Cloud
    rom.write_bytes(0x03BA35, bytearray([0x22, 0x9A, 0xFA, 0x00]))  # Check Arrow Cloud
    rom.write_bytes(0x03BA3D, bytearray([0x22, 0x81, 0xFA, 0x00]))  # Flash Arrow Cloud, rotating
    rom.write_bytes(0x03BA5A, bytearray([0x22, 0x9A, 0xFA, 0x00]))  # Check Arrow Cloud, rotating

    rom.write_bytes(0x03818F, bytearray([0x5C, 0xAB, 0xFA, 0x00]))  # Check Egg Plant
    rom.write_bytes(0x0380F3, bytearray([0x5C, 0xC3, 0xFA, 0x00]))  # Flash Egg Plant

    rom.write_bytes(0x073EF6, bytearray([0x5C, 0xE0, 0xFA, 0x00]))  # Flash Chomp Rock
    rom.write_bytes(0x073EFA, bytearray([0x4C, 0x9D, 0xFF]))  # Check Chomp Rock

    rom.write_bytes(0x039639, bytearray([0x5C, 0xFF, 0xFA, 0x00]))  # Flash Poochy
    rom.write_bytes(0x03964C, bytearray([0x4C, 0x48, 0xFF]))  # Check Poochy

    rom.write_bytes(0x0370C2, bytearray([0x22, 0x1A, 0xFB, 0x00, 0xEA]))  # Flash Platform Ghosts
    rom.write_bytes(0x03723F, bytearray([0x5C, 0x32, 0xFB, 0x00]))  # Fixes a bug where the eyes would assign to a random sprite while flashing
    rom.write_bytes(0x03739B, bytearray([0x5C, 0x52, 0xFB, 0x00]))  # Check Vertical Platform Ghost
    rom.write_bytes(0x036530, bytearray([0x5C, 0x6B, 0xFB, 0x00]))  # Flash horizontal ghost
    rom.write_bytes(0x03685C, bytearray([0x5C, 0x89, 0xFB, 0x00]))  # Fix flashing horizontal ghost
    rom.write_bytes(0x036894, bytearray([0x5C, 0xA9, 0xFB, 0x00]))  # Check horizontal ghost

    rom.write_bytes(0x012497, bytearray([0x5C, 0xBF, 0xFB, 0x00]))  # Check Skis
    rom.write_bytes(0x01234D, bytearray([0x5C, 0xF1, 0xFB, 0x00]))  # Allow ski doors to be re-entered

    rom.write_bytes(0x01204A, bytearray([0x5C, 0x10, 0xFC, 0x00]))  # Flash Key
    rom.write_bytes(0x012388, bytearray([0x5C, 0x30, 0xFC, 0x00]))  # Check Key

    rom.write_bytes(0x011398, bytearray([0x5C, 0x46, 0xFC, 0x00]))  # Flash MidRing
    rom.write_bytes(0x0113D6, bytearray([0x5C, 0x65, 0xFC, 0x00]))  # Check MidRing

    rom.write_bytes(0x02C4C6, bytearray([0x5C, 0x77, 0xFC, 0x00]))  # Check Bucket w/ Item
    rom.write_bytes(0x02C8BD, bytearray([0x5C, 0x8A, 0xFC, 0x00]))  # Check Bucket, ridable
    rom.write_bytes(0x02C4D5, bytearray([0x5C, 0x9D, 0xFC, 0x00]))  # Flash Bucket

    rom.write_bytes(0x064920, bytearray([0x5C, 0xBC, 0xFC, 0x00]))  # Flash Tulip
    rom.write_bytes(0x064D49, bytearray([0x5C, 0xD9, 0xFC, 0x00]))  # Check Tulip

    rom.write_bytes(0x01BEC7, bytearray([0x5C, 0xEF, 0xFC, 0x00]))  # Check Egg Capacity
    rom.write_bytes(0x01BF12, bytearray([0x4C, 0x27, 0xFF]))  # Set current egg max
    rom.write_bytes(0x01BF1A, bytearray([0x5C, 0x3C, 0xFD, 0x00]))  # Cap eggs

    rom.write_bytes(0x0BA5AE, bytearray([0x5C, 0x41, 0xFD, 0x00]))  # Unlock Levels

    rom.write_bytes(0x0B9953, bytearray([0x5C, 0xD9, 0xFD, 0x00]))  # File initialization

    rom.write_bytes(0x0BD8AB, bytearray([0x5C, 0x29, 0xFE, 0x00]))  # Prevent the world 1 tab from being drawn without it being unlocked

    rom.write_bytes(0x00C155, bytearray([0x5C, 0x45, 0xFE, 0x00]))  # Save between levels

    rom.write_bytes(0x0BDB20, bytearray([0x5C, 0x58, 0xFE, 0x00]))  # Unlock extra and bonus stages

    rom.write_bytes(0x0BA8FF, bytearray([0x5C, 0xF6, 0xFE, 0x00]))  # Skip the score animation if coming from start-select, but still save

    rom.write_bytes(0x0BA8A9, bytearray([0x80, 0x46]))  # Prevent unlocking new levels

    rom.write_bytes(0x066A42, bytearray([0x5C, 0x0D, 0xFF, 0x00]))  # Coin visibility
    rom.write_bytes(0x01C08C, bytearray([0x5C, 0x2D, 0xFF, 0x00]))  # Cloud visibility

    rom.write_bytes(0x00C0D9, bytearray([0x5C, 0xB8, 0xF3, 0x0B]))  # Receive item from server

    rom.write_bytes(0x00C153, bytearray([0xEA, 0xEA]))  # Always enable Start/Select

    rom.write_bytes(0x00C18B, bytearray([0x5C, 0x1B, 0xF5, 0x0B]))  # Enable traps

    rom.write_bytes(0x01B365, bytearray([0x5C, 0x86, 0xF5, 0x0B]))  # Red Coin checks
    rom.write_bytes(0x0734C6, bytearray([0x5C, 0xCE, 0xF5, 0x0B]))  # Flower checks
    rom.write_bytes(0x00C0DE, bytearray([0x5C, 0xF5, 0xF5, 0x0B]))  # Star checks
    rom.write_bytes(0x00B580, bytearray([0x5C, 0xB1, 0xF5, 0x0B]))  # Level Clear checks

    rom.write_bytes(0x0B9937, bytearray([0x5C, 0x23, 0xF6, 0x0B]))  # Load AP data
    rom.write_bytes(0x0BE14A, bytearray([0x5C, 0x58, 0xF6, 0x0B]))  # Save AP data

    rom.write_bytes(0x00D09F, bytearray([0x5C, 0x8C, 0xF6, 0x0B]))  # Clear Menu
    rom.write_bytes(0x00BCB5, bytearray([0x5C, 0xAD, 0xF6, 0x0B]))  # Clear Score for menu
    rom.write_bytes(0x00D072, bytearray([0x5C, 0xC3, 0xF6, 0x0B]))  # Loads the data for the AP menu
    rom.write_bytes(0x00D07A, bytearray([0x5C, 0x5A, 0xF7, 0x0B]))  # Draw the AP menu over the pause menu
    rom.write_bytes(0x00D17A, bytearray([0x5C, 0xDA, 0xF7, 0x0B]))  # Skip the flower counter in the AP menu
    rom.write_bytes(0x00D0DE, bytearray([0x5C, 0xF1, 0xF7, 0x0B]))  # Skip the coin counter in the AP menu
    rom.write_bytes(0x00CFB4, bytearray([0x5C, 0x06, 0xF8, 0x0B]))  # Get the number of bosses required to unlock 6-8
    rom.write_bytes(0x00CFD0, bytearray([0x5C, 0x2B, 0xF8, 0x0B]))  # Get bosses for 6-8 clear
    rom.write_bytes(0x00D203, bytearray([0x5C, 0xF0, 0xF8, 0x0B]))  # Wipe total score line
    rom.write_bytes(0x00D277, bytearray([0x5C, 0x04, 0xF9, 0x0B]))  # Wipe high score line
    rom.write_bytes(0x00C104, bytearray([0x5C, 0x18, 0xF9, 0x0B]))  # Replace the pause menu with AP menu when SELECT is pressed
    rom.write_bytes(0x00C137, bytearray([0x5C, 0x31, 0xF9, 0x0B]))  # Prevent accidentally quitting out of a stage while opening the AP menu
    rom.write_bytes(0x00CE48, bytearray([0x5C, 0x42, 0xF9, 0x0B]))  # When closing the AP menu, reset the AP menu flag so the normal menu can be opened.

    rom.write_bytes(0x0BA5B6, bytearray([0x5C, 0x4E, 0xF9, 0x0B]))  # Unlock 6-8 if the current number of defeated bosses is higher than the number of bosses required. If 6-8 is marked 'cleared', skip boss checks
    rom.write_bytes(0x01209E, bytearray([0x5C, 0x92, 0xF9, 0x0B]))  # Write a flag to check bosses if setting up the final boss door
    rom.write_bytes(0x0123AA, bytearray([0x5C, 0xA3, 0xF9, 0x0B]))  # If the boss check flag is set, read the number of bosses before opening door

    rom.write_bytes(0x015F7A, bytearray([0x5C, 0xCA, 0xF9, 0x0B]))  # Write Boss Clears

    rom.write_bytes(0x0BE16E, bytearray([0x80, 0x12]))  # Disable overworld bandit code

    rom.write_bytes(0x083015, bytearray([0x5C, 0x26, 0xFA, 0x0B]))  # Flip Cards
    rom.write_bytes(0x0839B6, bytearray([0x5C, 0x18, 0xFA, 0x0B]))  # Scratch Cards
    rom.write_bytes(0x085094, bytearray([0x5C, 0x31, 0xFA, 0x0B]))  # Draw Lots
    rom.write_bytes(0x0852C5, bytearray([0x5C, 0x3D, 0xFA, 0x0B]))  # Match Cards
    rom.write_bytes(0x0845EA, bytearray([0x5C, 0x48, 0xFA, 0x0B]))  # Roulette
    rom.write_bytes(0x083E0A, bytearray([0x5C, 0x53, 0xFA, 0x0B]))  # Slots

    rom.write_bytes(0x01D845, bytearray([0x5C, 0x76, 0xF9, 0x0B]))  # Check setting for disabled autoscrolls

    rom.write_bytes(0x0BDAC2, bytearray([0x80, 0x0E]))  # Prevent extra and bonus stages from auto-unlocking at 100 points
    rom.write_bytes(0x0BA720, bytearray([0xA9, 0x00, 0x00]))  # Always read level scores as 0. This stops extras and bonus from trying to unlock

    rom.write_bytes(0x0BA720, bytearray([0xA9, 0x00, 0x00]))  # Always read level scores as 0. This stops extras and bonus from trying to unlock

    rom.write_bytes(0x03FE85, bytearray([0x5C, 0x09, 0xFB, 0x0B]))  # Decrement the key counter when unlocking the 6-4 cork

    rom.write_bytes(0x06F1B4, bytearray([0x5C, 0x22, 0xFB, 0x0B]))  # Mark the goal and bowser clear after defeating bowser

    rom.write_bytes(0x005FE2, bytearray([0x5C, 0x9C, 0xFB, 0x0B]))  # Flag red coins as checked if the last one came from a pole

    rom.write_bytes(0x01C2E1, bytearray([0x80]))  # Makes hidden clouds not flash
    rom.write_bytes(0x0120C0, bytearray([0x80]))  # Prevents bandit game doors from sealing

    rom.write_bytes(0x0382A7, bytearray([0x5C, 0xC2, 0xFB, 0x0B]))  # Make cactus eggplants check the eggplant item correctly

    rom.write_bytes(0x025E71, bytearray([0x5C, 0xFA, 0xFB, 0x0B]))  # Write the stored reverse value

    rom.write_bytes(0x00B587, bytearray([0x5C, 0x24, 0xFC, 0x0B]))  # Store the reverse value and zero it

    rom.write_bytes(0x0B9932, bytearray([0x5C, 0x96, 0xFA, 0x0B]))  # Get 16 bit life count

    rom.write_bytes(0x00C288, bytearray([0x00]))
    rom.write_bytes(0x00C28B, bytearray([0x80]))  # Disable baby mario tutorial text

    rom.write_bytes(0x01141F, bytearray([0x80]))  # Disable Middle Ring tutorial

    rom.write_bytes(0x073534, bytearray([0x80]))  # Disable Flower tutorial

    rom.write_bytes(0x065B24, bytearray([0x5C, 0x45, 0xFC, 0x0B]))  # Fix boss cutscenes

    rom.write_bytes(0x011507, bytearray([0x5C, 0x70, 0xFC, 0x0B]))  # Fix Hookbill middle ring during boss shuffle

    rom.write_bytes(0x019E98, bytearray([0x5C, 0xB4, 0xFC, 0x0B]))  # Flag red coins as checked if the last one was eaten

    rom.write_bytes(0x011AB6, bytearray([0x5C, 0xD7, 0xFC, 0x0B]))  # Check egg refills for how many eggs to spawn

    rom.write_bytes(0x00DCA6, bytearray([0x5C, 0x00, 0xFD, 0x0B]))  # Check egg refill pause use

    rom.write_bytes(0x0BE06B, bytearray([0x5C, 0x56, 0xFD, 0x0B]))  # Get level from shuffled order

    rom.write_bytes(0x00C14B, bytearray([0xAE, 0x7C, 0x02, 0x8E, 0x1A, 0x02]))  # Return to the original list when exiting a level

    rom.write_bytes(0x00BEA8, bytearray([0x5C, 0x3F, 0xFE, 0x0B]))  # Save the original level when beating a shuffled one.

    rom.write_bytes(0x00E702, bytearray([0xAD, 0x7C, 0x02, 0x8D, 0x1A, 0x02, 0x80, 0x05]))  # Save the original level when leaving through death

    rom.write_bytes(0x0BE72A, bytearray([0x7C]))  # Load yoshi colors by slot number not level number

    rom.write_bytes(0x003346, bytearray([0x22, 0x54, 0xFE, 0x0B, 0xEA, 0xEA]))  # Fix World 6 levels using weird tilesets

    rom.write_bytes(0x003A37, bytearray([0x22, 0x54, 0xFE, 0x0B, 0xEA, 0xEA]))  # Fix World 6 levels using weird tilesets

    rom.write_bytes(0x0B87D5, bytearray([0x5C, 0x67, 0xFE, 0x0B]))

    rom.write_bytes(0x07081F, bytearray([0x80]))  # Fix for weird falling chomps. Why does this even read the world number?????

    rom.write_bytes(0x0BC0B2, bytearray([0x5C, 0xD0, 0xED, 0x01]))  # Load randomized yoshi colors on the world map

    rom.write_bytes(0x0BC6F7, bytearray([0x5C, 0x04, 0xEE, 0x01]))  # Load selected yoshi color on the world map

    rom.write_bytes(0x0BC0AB, bytearray([0x80]))  # Skip special color check for world 6; Levels handle this anyway


def write_lives(rom: LocalRom) -> None:
    rom.write_bytes(0x05FA96, bytearray([0xC2, 0x20, 0xAF, 0x89, 0xFC, 0x0D, 0x8D, 0x79, 0x03, 0xE2, 0x20, 0x5C, 0x37, 0x99, 0x17]))
    rom.write_bytes(0x05FABF, bytearray([0x48, 0xE2, 0x20, 0xAD, 0xCC, 0x00, 0xF0, 0x06, 0xCE, 0xCC, 0x00, 0xCE, 0xCC, 0x00, 0xC2, 0x20, 0x68, 0x22, 0x87, 0xBF, 0x03, 0x5C, 0x89, 0xFE, 0x07]))


def bonus_checks(rom: LocalRom) -> None:
    rom.write_bytes(0x082156, bytearray([0x5C, 0x5F, 0xFA, 0x0B]))  # Write bonus check


def bandit_checks(rom: LocalRom) -> None:
    rom.write_bytes(0x08C9E4, bytearray([0x5C, 0xF3, 0xF9, 0x0B]))  # Write Bandit Checks


def Handle_Locations(rom: LocalRom) -> None:
    rom.write_bytes(0x05F3B8, bytearray([0xAD, 0x67, 0x14, 0xF0, 0x59, 0xDA, 0xC9, 0x1F]))
    rom.write_bytes(0x05F3C0, bytearray([0xF0, 0x16, 0xC9, 0x20, 0xB0, 0x27, 0xAA, 0xBF, 0xAA, 0xFE, 0x06, 0xAA, 0xA9, 0x01, 0x9D, 0x40]))
    rom.write_bytes(0x05F3D0, bytearray([0x14, 0xA9, 0x43, 0x8D, 0x53, 0x00, 0x80, 0x67, 0xAD, 0x5D, 0x14, 0xD0, 0x01, 0x1A, 0xC9, 0x06]))
    rom.write_bytes(0x05F3E0, bytearray([0xF0, 0x04, 0x1A, 0x8D, 0x5D, 0x14, 0xA9, 0x03, 0x8D, 0x53, 0x00, 0x80, 0x52, 0xC9, 0x26, 0xB0]))
    rom.write_bytes(0x05F3F0, bytearray([0x27, 0xA2, 0x00, 0xDF, 0xC9, 0xFE, 0x06, 0xF0, 0x03, 0xE8, 0x80, 0xF7, 0xBF, 0xCF, 0xFE, 0x06]))
    rom.write_bytes(0x05F400, bytearray([0x8D, 0x4C, 0x00, 0xAD, 0x60, 0x14, 0x0C, 0x4C, 0x00, 0xAD, 0x4C, 0x00, 0x8D, 0x60, 0x14, 0xA9]))
    rom.write_bytes(0x05F410, bytearray([0x97, 0x8D, 0x53, 0x00, 0x80, 0x29, 0x80, 0x70, 0xC9, 0x2D, 0xB0, 0x25, 0xA2, 0x00, 0xDF, 0xD5]))
    rom.write_bytes(0x05F420, bytearray([0xFE, 0x06, 0xF0, 0x03, 0xE8, 0x80, 0xF7, 0xBF, 0xE3, 0xFE, 0x06, 0x8D, 0xCF, 0x00, 0xAD, 0x61]))
    rom.write_bytes(0x05F430, bytearray([0x14, 0x0C, 0xCF, 0x00, 0xAD, 0xCF, 0x00, 0x8D, 0x61, 0x14, 0xA9, 0x95, 0x8D, 0x53, 0x00, 0x80]))
    rom.write_bytes(0x05F440, bytearray([0x78, 0xC9, 0x34, 0xB0, 0x25, 0xA2, 0x00, 0xDF, 0xDC, 0xFE, 0x06, 0xF0, 0x03, 0xE8, 0x80, 0xF7]))
    rom.write_bytes(0x05F450, bytearray([0xBF, 0xE3, 0xFE, 0x06, 0x8D, 0xCF, 0x00, 0xAD, 0x62, 0x14, 0x0C, 0xCF, 0x00, 0xAD, 0xCF, 0x00]))
    rom.write_bytes(0x05F460, bytearray([0x8D, 0x62, 0x14, 0xA9, 0x95, 0x8D, 0x53, 0x00, 0x80, 0x4F, 0xC9, 0x3D, 0xB0, 0x1C, 0xA2, 0x00]))
    rom.write_bytes(0x05F470, bytearray([0xDF, 0xEA, 0xFE, 0x06, 0xF0, 0x03, 0xE8, 0x80, 0xF7, 0xBF, 0xF6, 0xFE, 0x06, 0x22, 0xA6, 0x9C]))
    rom.write_bytes(0x05F480, bytearray([0x10, 0xA9, 0x36, 0x8D, 0x53, 0x00, 0x80, 0x31, 0x80, 0x64, 0xC9, 0x41, 0xB0, 0x2D, 0xA2, 0x00]))
    rom.write_bytes(0x05F490, bytearray([0xDF, 0xFF, 0xFE, 0x06, 0xF0, 0x03, 0xE8, 0x80, 0xF7, 0xA9, 0x00, 0xEB, 0xBF, 0x03, 0xFF, 0x06]))
    rom.write_bytes(0x05F4A0, bytearray([0xAA, 0x18, 0xC2, 0x20, 0x6D, 0x79, 0x03, 0x8D, 0x79, 0x03, 0xE2, 0x20, 0xA9, 0x08, 0x22, 0xD2]))
    rom.write_bytes(0x05F4B0, bytearray([0x85, 0x00, 0xCA, 0xE0, 0x00, 0xF0, 0x02, 0x80, 0xF5, 0x80, 0x51, 0xC9, 0x41, 0xF0, 0x1E, 0xC9]))
    rom.write_bytes(0x05F4C0, bytearray([0x42, 0xF0, 0x2D, 0xC9, 0x43, 0xF0, 0x3A, 0xC2, 0x20, 0x5C, 0xFB, 0xB3, 0x21, 0x77, 0x14, 0xE2]))
    rom.write_bytes(0x05F4D0, bytearray([0x20, 0xA9, 0x01, 0x8D, 0x7D, 0x02, 0xA9, 0x2E, 0x8D, 0x53, 0x00, 0x80, 0x2F, 0xA9, 0x01, 0x8D]))
    rom.write_bytes(0x05F4E0, bytearray([0x68, 0x14, 0xC2, 0x20, 0xA9, 0x00, 0x04, 0x8D, 0x69, 0x14, 0xE2, 0x20, 0x80, 0x1E, 0x80, 0x22]))
    rom.write_bytes(0x05F4F0, bytearray([0xC2, 0x20, 0xA9, 0x2C, 0x01, 0x8D, 0xCC, 0x0C, 0xE2, 0x20, 0xA9, 0xA0, 0x8D, 0x53, 0x00, 0x80]))
    rom.write_bytes(0x05F500, bytearray([0x0B, 0xA9, 0x15, 0x8D, 0x53, 0x00, 0xA9, 0x05, 0x8F, 0xED, 0x61, 0x04, 0xFA, 0xA9, 0x00, 0x8D]))
    rom.write_bytes(0x05F510, bytearray([0x67, 0x14, 0xA9, 0x10, 0x8D, 0x83, 0x0B, 0x5C, 0xDE, 0xC0, 0x01, 0xE2, 0x20, 0xAD, 0x7D, 0x02]))
    rom.write_bytes(0x05F520, bytearray([0xF0, 0x25, 0xC2, 0x20, 0xAD, 0x7E, 0x02, 0xE2, 0x20, 0xF0, 0x12, 0xA9, 0x02, 0x8D, 0x00, 0x02]))
    rom.write_bytes(0x05F530, bytearray([0xC2, 0x20, 0xAD, 0x7E, 0x02, 0x3A, 0x8D, 0x7E, 0x02, 0xE2, 0x20, 0x80, 0x0A, 0xA9, 0x0F, 0x8D]))
    rom.write_bytes(0x05F540, bytearray([0x00, 0x02, 0xA9, 0x00, 0x8D, 0x7D, 0x02, 0xAD, 0x68, 0x14, 0xF0, 0x32, 0xC2, 0x20, 0xAD, 0x69]))
    rom.write_bytes(0x05F550, bytearray([0x14, 0xF0, 0x1B, 0x3A, 0x8D, 0x69, 0x14, 0xE2, 0x20, 0x4C, 0x40, 0xFD, 0xE8, 0x1F, 0x70, 0xAD]))
    rom.write_bytes(0x05F560, bytearray([0xD0, 0x00, 0xD0, 0x08, 0xEE, 0xD0, 0x00, 0xA9, 0x21, 0x8D, 0x53, 0x00, 0x80, 0x10, 0xE2, 0x20]))
    rom.write_bytes(0x05F570, bytearray([0xA9, 0x22, 0x8D, 0x53, 0x00, 0xA9, 0x00, 0x8D, 0x68, 0x14, 0x8F, 0xE8, 0x1F, 0x70, 0x22, 0x59]))
    rom.write_bytes(0x05F580, bytearray([0x82, 0x00, 0x5C, 0x8F, 0xC1, 0x01, 0xAC, 0xB4, 0x03, 0xC0, 0x14, 0x30, 0x20, 0x48, 0xDA, 0xE2]))
    rom.write_bytes(0x05F590, bytearray([0x20, 0xAE, 0x1A, 0x02, 0xBD, 0x6D, 0x14, 0x8D, 0xD1, 0x00, 0xA9, 0x01, 0x0C, 0xD1, 0x00, 0xAD]))
    rom.write_bytes(0x05F5A0, bytearray([0xD1, 0x00, 0x9D, 0x6D, 0x14, 0xC2, 0x20, 0xFA, 0x68, 0x5C, 0x6C, 0xB3, 0x03, 0x5C, 0x6D, 0xB3]))
    rom.write_bytes(0x05F5B0, bytearray([0x03, 0xAE, 0x1A, 0x02, 0xBD, 0x6D, 0x14, 0x8D, 0xD1, 0x00, 0xA9, 0x08, 0x0C, 0xD1, 0x00, 0xAD]))
    rom.write_bytes(0x05F5C0, bytearray([0xD1, 0x00, 0x9D, 0x6D, 0x14, 0xAE, 0x57, 0x0B, 0xE0, 0x0D, 0x5C, 0x85, 0xB5, 0x01, 0xA0, 0x05]))
    rom.write_bytes(0x05F5D0, bytearray([0x8C, 0xB8, 0x03, 0x08, 0xE2, 0x20, 0xDA, 0x48, 0xAE, 0x1A, 0x02, 0xBD, 0x6D, 0x14, 0x8D, 0xD1]))
    rom.write_bytes(0x05F5E0, bytearray([0x00, 0xA9, 0x02, 0x0C, 0xD1, 0x00, 0xAD, 0xD1, 0x00, 0x9D, 0x6D, 0x14, 0x68, 0xFA, 0xC2, 0x20]))
    rom.write_bytes(0x05F5F0, bytearray([0x28, 0x5C, 0xCB, 0xB4, 0x0E, 0xC2, 0x20, 0xAD, 0xB6, 0x03, 0xC9, 0x2C, 0x01, 0x90, 0x18, 0xE2]))
    rom.write_bytes(0x05F600, bytearray([0x20, 0xDA, 0xAE, 0x1A, 0x02, 0xBD, 0x6D, 0x14, 0x8D, 0xD1, 0x00, 0xA9, 0x04, 0x0C, 0xD1, 0x00]))
    rom.write_bytes(0x05F610, bytearray([0xAD, 0xD1, 0x00, 0x9D, 0x6D, 0x14, 0xFA, 0x9C, 0x84, 0x0B, 0xE2, 0x20, 0xAD, 0x0F, 0x0D, 0x5C]))
    rom.write_bytes(0x05F620, bytearray([0xE4, 0xC0, 0x01, 0xC2, 0x20, 0x48, 0xE2, 0x20, 0xA9, 0x1F, 0x8D, 0x18, 0x01, 0xDA, 0x5A, 0x8B]))
    rom.write_bytes(0x05F630, bytearray([0x4C, 0xB2, 0xFA, 0xC2, 0x20, 0xC2, 0x10, 0xAA, 0xBF, 0x07, 0xFF, 0x06, 0xAA, 0xE2, 0x20, 0xA9]))
    rom.write_bytes(0x05F640, bytearray([0x00, 0xEB, 0xA9, 0x7F, 0xA0, 0x40, 0x14, 0x54, 0x7E, 0x70, 0xE2, 0x10, 0xAB, 0x7A, 0xFA, 0xC2]))
    rom.write_bytes(0x05F650, bytearray([0x20, 0x68, 0xE2, 0x20, 0x5C, 0x3C, 0x99, 0x17, 0xC2, 0x20, 0x48, 0xC2, 0x10, 0xDA, 0x5A, 0x8B]))
    rom.write_bytes(0x05F660, bytearray([0xAD, 0x0E, 0x03, 0x29, 0x0F, 0x00, 0xAA, 0xBF, 0x07, 0xFF, 0x06, 0xA8, 0xE2, 0x20, 0xA9, 0x00]))
    rom.write_bytes(0x05F670, bytearray([0xEB, 0xA9, 0x7F, 0xA2, 0x40, 0x14, 0x54, 0x70, 0x7E, 0xAB, 0x7A, 0xFA, 0xE2, 0x10, 0xC2, 0x20]))
    rom.write_bytes(0x05F680, bytearray([0x68, 0xE2, 0x20, 0xAD, 0x3D, 0x09, 0x29, 0x20, 0x5C, 0x4F, 0xE1, 0x17, 0xE2, 0x20, 0xAD, 0xD2]))
    rom.write_bytes(0x05F690, bytearray([0x00, 0xC2, 0x20, 0xD0, 0x09, 0xA9, 0xC1, 0xB1, 0x85, 0x10, 0x5C, 0xA4, 0xD0, 0x01, 0xA9, 0x00]))
    rom.write_bytes(0x05F6A0, bytearray([0x00, 0x85, 0x10, 0x85, 0x12, 0x85, 0x14, 0x85, 0x16, 0x5C, 0xB3, 0xD0, 0x01, 0xE2, 0x20, 0xAD]))
    rom.write_bytes(0x05F6B0, bytearray([0xD2, 0x00, 0xC2, 0x20, 0xD0, 0x09, 0xA9, 0x6F, 0x01, 0x05, 0x02, 0x5C, 0xBA, 0xBC, 0x01, 0x5C]))
    rom.write_bytes(0x05F6C0, bytearray([0xBC, 0xBC, 0x01, 0xE2, 0x20, 0xAD, 0xD2, 0x00, 0xC2, 0x20, 0xD0, 0x0B, 0xBF, 0xED, 0xB7, 0x01]))
    rom.write_bytes(0x05F6D0, bytearray([0x29, 0xFF, 0x00, 0x5C, 0x79, 0xD0, 0x01, 0xBF, 0x48, 0xD3, 0x22, 0x29, 0xFF, 0x00, 0xC9, 0x80]))
    rom.write_bytes(0x05F6E0, bytearray([0x00, 0xF0, 0x04, 0x5C, 0x79, 0xD0, 0x01, 0xBF, 0x66, 0xD3, 0x22, 0xDA, 0xAA, 0xAD, 0xD3, 0x00]))
    rom.write_bytes(0x05F6F0, bytearray([0x29, 0xFF, 0x00, 0xC9, 0x01, 0x00, 0xF0, 0x21, 0xC9, 0x02, 0x00, 0xF0, 0x38, 0xBD, 0x40, 0x14]))
    rom.write_bytes(0x05F700, bytearray([0x29, 0xFF, 0x00, 0xF0, 0x0C, 0xFA, 0xBF, 0x87, 0xD3, 0x22, 0x29, 0xFF, 0x00, 0x5C, 0x79, 0xD0]))
    rom.write_bytes(0x05F710, bytearray([0x01, 0xFA, 0xA9, 0x4E, 0x00, 0x5C, 0x79, 0xD0, 0x01, 0xBD, 0x4A, 0x14, 0x29, 0xFF, 0x00, 0xF0]))
    rom.write_bytes(0x05F720, bytearray([0x0C, 0xFA, 0xBF, 0xA5, 0xD3, 0x22, 0x29, 0xFF, 0x00, 0x5C, 0x79, 0xD0, 0x01, 0xFA, 0xA9, 0x4E]))
    rom.write_bytes(0x05F730, bytearray([0x00, 0x5C, 0x79, 0xD0, 0x01, 0xE0, 0x09, 0xD0, 0x05, 0xAD, 0x64, 0x14, 0x80, 0x03, 0xBD, 0x54]))
    rom.write_bytes(0x05F740, bytearray([0x14, 0x29, 0xFF, 0x00, 0xF0, 0x0C, 0xFA, 0xBF, 0xC3, 0xD3, 0x22, 0x29, 0xFF, 0x00, 0x5C, 0x79]))
    rom.write_bytes(0x05F750, bytearray([0xD0, 0x01, 0xFA, 0xA9, 0x4E, 0x00, 0x5C, 0x79, 0xD0, 0x01, 0xE2, 0x20, 0xAD, 0xD2, 0x00, 0xC2]))
    rom.write_bytes(0x05F760, bytearray([0x20, 0xD0, 0x08, 0xBF, 0x5F, 0xB8, 0x01, 0x5C, 0x7E, 0xD0, 0x01, 0xAD, 0xD3, 0x00, 0x29, 0xFF]))
    rom.write_bytes(0x05F770, bytearray([0x00, 0xC9, 0x01, 0x00, 0xF0, 0x3C, 0xC9, 0x02, 0x00, 0xF0, 0x4B, 0xBF, 0x5F, 0xB8, 0x01, 0x05]))
    rom.write_bytes(0x05F780, bytearray([0x18, 0x99, 0xA1, 0xB1, 0xBF, 0xDD, 0xB8, 0x01, 0x05, 0x18, 0x99, 0xE1, 0xB1, 0xFA, 0xC8, 0xC8]))
    rom.write_bytes(0x05F790, bytearray([0xE8, 0xE0, 0x1D, 0x90, 0x19, 0xEE, 0xD3, 0x00, 0xA0, 0x00, 0xA2, 0x00, 0xAD, 0xD3, 0x00, 0x29]))
    rom.write_bytes(0x05F7A0, bytearray([0xFF, 0x00, 0xC9, 0x03, 0x00, 0xD0, 0x07, 0x9C, 0xD3, 0x00, 0x5C, 0x94, 0xD0, 0x01, 0x5C, 0x71]))
    rom.write_bytes(0x05F7B0, bytearray([0xD0, 0x01, 0xBF, 0x5F, 0xB8, 0x01, 0x05, 0x18, 0x99, 0x21, 0xB2, 0xBF, 0xDD, 0xB8, 0x01, 0x05]))
    rom.write_bytes(0x05F7C0, bytearray([0x18, 0x99, 0x61, 0xB2, 0x80, 0xC7, 0xBF, 0x5F, 0xB8, 0x01, 0x05, 0x18, 0x99, 0xA1, 0xB2, 0xBF]))
    rom.write_bytes(0x05F7D0, bytearray([0xDD, 0xB8, 0x01, 0x05, 0x18, 0x99, 0xE1, 0xB2, 0x80, 0xB3, 0xE2, 0x20, 0xAD, 0xD2, 0x00, 0xC2]))
    rom.write_bytes(0x05F7E0, bytearray([0x20, 0xD0, 0x0A, 0x64, 0x18, 0xAF, 0xB8, 0x03, 0x00, 0x5C, 0x80, 0xD1, 0x01, 0x5C, 0x02, 0xD2]))
    rom.write_bytes(0x05F7F0, bytearray([0x01, 0xE2, 0x20, 0xAD, 0xD2, 0x00, 0xC2, 0x20, 0xD0, 0x08, 0x64, 0x18, 0xA0, 0x00, 0x5C, 0xE2]))
    rom.write_bytes(0x05F800, bytearray([0xD0, 0x01, 0x5C, 0x02, 0xD2, 0x01, 0xAD, 0xD2, 0x00, 0x29, 0xFF, 0x00, 0xD0, 0x08, 0xBF, 0x35]))
    rom.write_bytes(0x05F810, bytearray([0xB8, 0x01, 0x5C, 0xB8, 0xCF, 0x01, 0xBF, 0xE1, 0xD3, 0x22, 0x29, 0xFF, 0x00, 0xC9, 0x80, 0x00]))
    rom.write_bytes(0x05F820, bytearray([0xF0, 0x2E, 0xC9, 0x81, 0x00, 0xF0, 0x47, 0x5C, 0xB8, 0xCF, 0x01, 0xAD, 0xD2, 0x00, 0x29, 0xFF]))
    rom.write_bytes(0x05F830, bytearray([0x00, 0xD0, 0x08, 0xBF, 0x4A, 0xB8, 0x01, 0x5C, 0xD4, 0xCF, 0x01, 0xBF, 0xF6, 0xD3, 0x22, 0x29]))
    rom.write_bytes(0x05F840, bytearray([0xFF, 0x00, 0x4C, 0xB6, 0xFD, 0xF0, 0x18, 0xC9, 0x81, 0x00, 0xF0, 0x30, 0x5C, 0xD4, 0xCF, 0x01]))
    rom.write_bytes(0x05F850, bytearray([0xDA, 0xE2, 0x20, 0xAD, 0xB3, 0x14, 0xAA, 0xC2, 0x20, 0x20, 0x8A, 0xF8, 0xFA, 0x80, 0xC8, 0xDA]))
    rom.write_bytes(0x05F860, bytearray([0xE2, 0x20, 0xAD, 0xB3, 0x14, 0xAA, 0xC2, 0x20, 0x20, 0xBD, 0xF8, 0xFA, 0x80, 0xDE, 0xDA, 0xE2]))
    rom.write_bytes(0x05F870, bytearray([0x20, 0xAF, 0x85, 0xFC, 0x0D, 0xAA, 0x20, 0x8A, 0xF8, 0xFA, 0x80, 0xAB, 0xDA, 0xE2, 0x20, 0xAF]))
    rom.write_bytes(0x05F880, bytearray([0x86, 0xFC, 0x0D, 0xAA, 0x20, 0xBD, 0xF8, 0xFA, 0x80, 0xC2, 0xE2, 0x20, 0xC9, 0x0A, 0xB0, 0x1F]))
    rom.write_bytes(0x05F890, bytearray([0xAD, 0xD5, 0x00, 0xD0, 0x0D, 0xBF, 0x0B, 0xD4, 0x22, 0xC2, 0x20, 0xA9, 0x50, 0x00, 0xEE, 0xD5]))
    rom.write_bytes(0x05F8A0, bytearray([0x00, 0x60, 0xBF, 0x0B, 0xD4, 0x22, 0x9C, 0xD4, 0x00, 0x9C, 0xD5, 0x00, 0xC2, 0x20, 0x60, 0xAD]))
    rom.write_bytes(0x05F8B0, bytearray([0xD4, 0x00, 0xD0, 0xEE, 0xEE, 0xD4, 0x00, 0xC2, 0x20, 0xA9, 0x52, 0x00, 0x60, 0xE2, 0x20, 0xC9]))
    rom.write_bytes(0x05F8C0, bytearray([0x0A, 0xB0, 0x1F, 0xAD, 0xD6, 0x00, 0xD0, 0x0D, 0xBF, 0x0B, 0xD4, 0x22, 0xC2, 0x20, 0xA9, 0x50]))
    rom.write_bytes(0x05F8D0, bytearray([0x00, 0xEE, 0xD6, 0x00, 0x60, 0xBF, 0x0B, 0xD4, 0x22, 0x9C, 0xD7, 0x00, 0x9C, 0xD6, 0x00, 0xC2]))
    rom.write_bytes(0x05F8E0, bytearray([0x20, 0x60, 0xAD, 0xD7, 0x00, 0xD0, 0xEE, 0xEE, 0xD7, 0x00, 0xC2, 0x20, 0xA9, 0x52, 0x00, 0x60]))
    rom.write_bytes(0x05F8F0, bytearray([0xAD, 0xD2, 0x00, 0x29, 0xFF, 0x00, 0xF0, 0x04, 0x5C, 0x74, 0xD2, 0x01, 0x64, 0x18, 0xA0, 0x00]))
    rom.write_bytes(0x05F900, bytearray([0x5C, 0x07, 0xD2, 0x01, 0xAD, 0xD2, 0x00, 0x29, 0xFF, 0x00, 0xF0, 0x04, 0x5C, 0x74, 0xD2, 0x01]))
    rom.write_bytes(0x05F910, bytearray([0xAF, 0x7C, 0x02, 0x00, 0x5C, 0x7B, 0xD2, 0x01, 0xA5, 0x38, 0x89, 0x20, 0xD0, 0x0A, 0x29, 0x10]))
    rom.write_bytes(0x05F920, bytearray([0xF0, 0x02, 0xA9, 0x01, 0x5C, 0x08, 0xC1, 0x01, 0xEE, 0xD2, 0x00, 0x64, 0x38, 0x5C, 0x08, 0xC1]))
    rom.write_bytes(0x05F930, bytearray([0x01, 0xAD, 0xD2, 0x00, 0xD0, 0x08, 0xA5, 0x38, 0x29, 0x20, 0x5C, 0x3B, 0xC1, 0x01, 0xA9, 0x00]))
    rom.write_bytes(0x05F940, bytearray([0x80, 0xF8, 0xAD, 0x10, 0x0B, 0x49, 0x01, 0x9C, 0xD2, 0x00, 0x5C, 0x4D, 0xCE, 0x01, 0x9C, 0x01]))
    rom.write_bytes(0x05F950, bytearray([0x02, 0xAD, 0x5E, 0x02, 0xF0, 0x16, 0xAD, 0xB0, 0x14, 0x89, 0x08, 0xD0, 0x15, 0xAD, 0xB3, 0x14]))
    rom.write_bytes(0x05F960, bytearray([0xCF, 0x85, 0xFC, 0x0D, 0x90, 0x06, 0xA9, 0x80, 0x8F, 0x65, 0x02, 0x7E, 0xC2, 0x20, 0x5C, 0xBB]))
    rom.write_bytes(0x05F970, bytearray([0xA5, 0x17, 0xA9, 0x01, 0x80, 0xF2, 0xE2, 0x20, 0xAF, 0x87, 0xFC, 0x0D, 0xC2, 0x20, 0xF0, 0x0D]))
    rom.write_bytes(0x05F980, bytearray([0x4C, 0xBF, 0xFA, 0x8D, 0x1C, 0x0C, 0x8D, 0x1E, 0x0C, 0x5C, 0x4E, 0xD8, 0x03, 0xB9, 0x04, 0x0C]))
    rom.write_bytes(0x05F990, bytearray([0x80, 0xF1, 0xE2, 0x20, 0xA9, 0x01, 0x8D, 0xD8, 0x00, 0xC2, 0x20, 0x22, 0xBE, 0xAE, 0x03, 0x5C]))
    rom.write_bytes(0x05F9A0, bytearray([0xA2, 0xA0, 0x02, 0xE2, 0x20, 0xAD, 0xD8, 0x00, 0xD0, 0x0F, 0xC2, 0x20, 0xA9, 0x02, 0x00, 0x9D]))
    rom.write_bytes(0x05F9B0, bytearray([0x96, 0x7A, 0xFE, 0x78, 0x79, 0x5C, 0xAF, 0xA3, 0x02, 0xAD, 0xB3, 0x14, 0xCF, 0x86, 0xFC, 0x0D]))
    rom.write_bytes(0x05F9C0, bytearray([0xC2, 0x20, 0xB0, 0xE8, 0xC2, 0x20, 0x5C, 0x81, 0xA3, 0x02, 0xE2, 0x20, 0xDA, 0xAE, 0x1A, 0x02]))
    rom.write_bytes(0x05F9D0, bytearray([0xBD, 0x6D, 0x14, 0x89, 0x20, 0xF0, 0x0D, 0xFA, 0xC2, 0x20, 0xAD, 0x02, 0x74, 0xC9, 0x32, 0x00]))
    rom.write_bytes(0x05F9E0, bytearray([0x5C, 0x80, 0xDF, 0x02, 0x18, 0x69, 0x20, 0x9D, 0x6D, 0x14, 0xAD, 0xB3, 0x14, 0x1A, 0x8D, 0xB3]))
    rom.write_bytes(0x05F9F0, bytearray([0x14, 0x80, 0xE4, 0xE2, 0x20, 0xDA, 0xAE, 0x1A, 0x02, 0xBD, 0x6D, 0x14, 0x8D, 0xD1, 0x00, 0xA9]))
    rom.write_bytes(0x05FA00, bytearray([0x10, 0x0C, 0xD1, 0x00, 0xAD, 0xD1, 0x00, 0x9D, 0x6D, 0x14, 0xFA, 0xC2, 0x20, 0xA9, 0x36, 0x00]))
    rom.write_bytes(0x05FA10, bytearray([0x22, 0xD2, 0x85, 0x00, 0x5C, 0xEB, 0xC9, 0x11, 0xB9, 0xE4, 0xB9, 0xC0, 0x00, 0xF0, 0x03, 0xEE]))
    rom.write_bytes(0x05FA20, bytearray([0xD9, 0x00, 0x5C, 0xBB, 0xB9, 0x10, 0xA9, 0x06, 0x85, 0x4D, 0xEE, 0xD9, 0x00, 0x5C, 0x19, 0xB0]))
    rom.write_bytes(0x05FA30, bytearray([0x10, 0xA9, 0x05, 0x00, 0x85, 0x4D, 0xEE, 0xD9, 0x00, 0x5C, 0x9A, 0xD0, 0x10, 0xA9, 0x06, 0x85]))
    rom.write_bytes(0x05FA40, bytearray([0x4D, 0xEE, 0xD9, 0x00, 0x5C, 0xC9, 0xD2, 0x10, 0xA9, 0x05, 0x85, 0x4D, 0xEE, 0xD9, 0x00, 0x5C]))
    rom.write_bytes(0x05FA50, bytearray([0xEE, 0xC5, 0x10, 0xA9, 0x05, 0x00, 0x85, 0x4D, 0xEE, 0xD9, 0x00, 0x5C, 0x0F, 0xBE, 0x10, 0xDA]))
    rom.write_bytes(0x05FA60, bytearray([0xE2, 0x20, 0xAD, 0xD9, 0x00, 0xF0, 0x26, 0xA2, 0x00, 0xAD, 0x1A, 0x02, 0xDF, 0x18, 0xD4, 0x22]))
    rom.write_bytes(0x05FA70, bytearray([0xF0, 0x07, 0xE8, 0xE0, 0x06, 0xF0, 0x16, 0x80, 0xF3, 0xAE, 0x1A, 0x02, 0xBD, 0x6D, 0x14, 0x8D]))
    rom.write_bytes(0x05FA80, bytearray([0xD1, 0x00, 0xA9, 0x10, 0x0C, 0xD1, 0x00, 0xAD, 0xD1, 0x00, 0x9D, 0x6D, 0x14, 0xFA, 0x22, 0x67]))
    rom.write_bytes(0x05FA90, bytearray([0xFA, 0x04, 0x5C, 0x5A, 0xA1, 0x10]))

    rom.write_bytes(0x05FAB2, bytearray([0xA9, 0x00, 0xEB, 0xAD, 0x0E, 0x03, 0xC2, 0x20, 0xC2, 0x10, 0x4C, 0x37, 0xF6]))
    rom.write_bytes(0x05FABF, bytearray([0xE2]))
    rom.write_bytes(0x05FAC0, bytearray([0x20, 0xAD, 0x1A, 0x02, 0xDA, 0xA2, 0x00, 0x00, 0xDF, 0x1E, 0xD4, 0x22, 0xF0, 0x11, 0xE8, 0xE0]))
    rom.write_bytes(0x05FAD0, bytearray([0x01, 0x00, 0xF0, 0x02, 0x80, 0xF2, 0xFA, 0xC2, 0x20, 0xA9, 0x00, 0x00, 0x4C, 0x83, 0xF9, 0xFA]))
    rom.write_bytes(0x05FAE0, bytearray([0xC2, 0x20, 0x4C, 0x8D, 0xF9]))
    rom.write_bytes(0x05FAE5, bytearray([0x48, 0xE2, 0x20, 0xAD, 0x5D, 0x14, 0xC9, 0x01, 0xF0, 0x07]))
    rom.write_bytes(0x05FAEF, bytearray([0xC2, 0x20, 0x68, 0x5C, 0xCE, 0xBE, 0x03, 0xAD, 0xCC, 0x00, 0xD0, 0xF4, 0xAF, 0xFA, 0x1D, 0x70]))
    rom.write_bytes(0x05FAFF, bytearray([0xF0, 0xEE, 0xA9, 0x00, 0x8F, 0xFA, 0x1D, 0x70, 0x80, 0xE6]))
    rom.write_bytes(0x05FB09, bytearray([0x48, 0xE2, 0x20, 0xAD, 0xCC, 0x00, 0xF0, 0x06, 0xCE, 0xCC, 0x00, 0xCE, 0xCC, 0x00, 0xC2, 0x20, 0x68, 0x22, 0x87, 0xBF, 0x03, 0x5C, 0x89, 0xFE, 0x07]))
    rom.write_bytes(0x05FB22, bytearray([0xA0, 0x0A, 0x8C, 0x4D, 0x00, 0xE2, 0x20, 0xA9, 0x08, 0x0C, 0xB0, 0x14, 0x8D, 0xB6, 0x14, 0xC2, 0x20, 0x5C, 0xB9, 0xF1, 0x0D, 0x0D, 0xA8, 0xE2]))
    rom.write_bytes(0x05FB3A, bytearray([0x20, 0xA9, 0x08, 0x0C, 0xB0, 0x14, 0xA9, 0x00, 0xEB, 0xA9, 0x7F, 0xA2, 0x40, 0x14, 0x54, 0x70, 0x7E, 0xAB, 0x7A, 0xFA, 0x1A, 0xEE, 0x14, 0xC2, 0x20, 0x68, 0x5C, 0xB9, 0xF1, 0x0D]))
    rom.write_bytes(0x05FB58, bytearray([0x4C, 0xDD, 0xFB, 0x04, 0xAF, 0xAC, 0x00, 0x70]))
    rom.write_bytes(0x05FB60, bytearray([0xD0, 0x2C, 0xAD, 0x35, 0x00, 0xC9, 0x50, 0xD0, 0x25, 0xAD, 0xDA, 0x00, 0xC9, 0x80, 0xF0, 0x11]))
    rom.write_bytes(0x05FB70, bytearray([0xC9, 0x00, 0xF0, 0x21, 0xC9, 0x2A, 0xF0, 0x1D, 0xC9, 0x54, 0xF0, 0x19, 0xEE, 0xDA, 0x00, 0x80]))
    rom.write_bytes(0x05FB80, bytearray([0x10, 0xA9, 0x2F, 0x8D, 0x53, 0x00, 0xA9, 0x11, 0x8D, 0x18, 0x01, 0xEE, 0xDB, 0x00, 0x9C, 0xDA]))
    rom.write_bytes(0x05FB90, bytearray([0x00, 0x5C, 0x93, 0xC1, 0x01, 0xA9, 0x28, 0x8D, 0x53, 0x00, 0x80, 0xE0]))
    rom.write_bytes(0x05FB9C, bytearray([0xA9, 0x93, 0x00, 0xEE]))
    rom.write_bytes(0x05FBA0, bytearray([0xB4, 0x03, 0xAC, 0xB4, 0x03, 0xC0, 0x14, 0x00, 0x90, 0x14, 0xE2, 0x20, 0xDA, 0xAE, 0x1A, 0x02]))
    rom.write_bytes(0x05FBB0, bytearray([0xBD, 0x6D, 0x14, 0x09, 0x01, 0x9D, 0x6D, 0x14, 0xFA, 0xC2, 0x20, 0xA9, 0x94, 0x00, 0x5C, 0xF1, 0xDF, 0x00]))
    rom.write_bytes(0x05FBC2, bytearray([0x48, 0xC9, 0x06, 0x00, 0xB0, 0x10, 0xE2, 0x20, 0xAD, 0x54, 0x14, 0xC9, 0x00, 0xC2, 0x20, 0xF0]))
    rom.write_bytes(0x05FBD2, bytearray([0x05, 0x68, 0x5C, 0xAC, 0x82, 0x07, 0x68, 0x5C, 0xFB, 0x81, 0x07, 0xAD, 0x6A, 0x02, 0xF0, 0x11]))
    rom.write_bytes(0x05FBE2, bytearray([0xC2, 0x20, 0xA9, 0x0E, 0x00, 0x22, 0xE2, 0xF6, 0x04, 0xA9, 0x00, 0x00, 0x8D, 0x6A, 0x02, 0xE2]))
    rom.write_bytes(0x05FBF2, bytearray([0x20, 0x22, 0x28, 0xFD, 0x04, 0x4C, 0x5C, 0xFB, 0xAF, 0xB0, 0x23, 0x7E, 0xF0, 0x18, 0xAF, 0xAC]))
    rom.write_bytes(0x05FC02, bytearray([0x00, 0x70, 0x29, 0xFF, 0x00, 0xD0, 0x0F, 0xAF, 0xB0, 0x23, 0x7E, 0x8F, 0xEC, 0x61, 0x04, 0xA9]))
    rom.write_bytes(0x05FC12, bytearray([0x00, 0x00, 0x8F, 0xB0, 0x23, 0x7E, 0xBD, 0xD0, 0x61, 0xF0, 0x03, 0xDE, 0xD0, 0x61, 0x5C, 0x79]))
    rom.write_bytes(0x05FC22, bytearray([0xDE, 0x04, 0x48, 0xC2, 0x20, 0xAF, 0xEC, 0x61, 0x04, 0xD0, 0x0B, 0xE2, 0x20, 0x68, 0x22, 0xCE]))
    rom.write_bytes(0x05FC32, bytearray([0xC0, 0x01, 0x5C, 0x8B, 0xB5, 0x01, 0x8F, 0xB0, 0x23, 0x7E, 0xA9, 0x00, 0x00, 0x8F, 0xEC, 0x61]))
    rom.write_bytes(0x05FC42, bytearray([0x04, 0x80, 0xE8, 0x48, 0xDA, 0xE2, 0x20, 0x4C, 0xA5, 0xFC, 0xA2, 0x00, 0xDF, 0x1F, 0xD4, 0x22]))
    rom.write_bytes(0x05FC52, bytearray([0xF0, 0x03, 0xE8, 0x80, 0xF7, 0xBF, 0x8D, 0xFC, 0x0D, 0xAA, 0xBF, 0x2A, 0xD4, 0x22, 0x8D, 0xDC]))
    rom.write_bytes(0x05FC62, bytearray([0x00, 0xC2, 0x20, 0xFA, 0x68, 0x0D, 0xDC, 0x00, 0x95, 0x76, 0x5C, 0x29, 0xDB, 0x0C, 0xE2, 0x20]))
    rom.write_bytes(0x05FC72, bytearray([0xAD, 0x48, 0x0B, 0xF0, 0x23, 0xAF, 0xBE, 0x03, 0x02, 0xC9, 0x02, 0xD0, 0x1B, 0xAD, 0x1A, 0x02]))
    rom.write_bytes(0x05FC82, bytearray([0xA2, 0x00, 0xDF, 0x1F, 0xD4, 0x22, 0xF0, 0x03, 0xE8, 0x80, 0xF7, 0x8A, 0x0A, 0xAA, 0xC2, 0x20]))
    rom.write_bytes(0x05FC92, bytearray([0xBF, 0x35, 0xD4, 0x22, 0x8F, 0xBE, 0x03, 0x02, 0xC2, 0x20, 0xEE, 0xAC, 0x03, 0xC2, 0x10, 0x5C]))
    rom.write_bytes(0x05FCA2, bytearray([0x0C, 0x95, 0x02, 0xAD, 0x1A, 0x02, 0xC9, 0x43, 0xF0, 0x03, 0x4C, 0x4C, 0xFC, 0xA9, 0x0A, 0x4C]))
    rom.write_bytes(0x05FCB2, bytearray([0x60, 0xFC, 0xAC, 0xB4, 0x03, 0xC0, 0x14, 0x30, 0x14, 0x1A, 0xE2, 0x20, 0xDA, 0x48, 0xAE, 0x1A]))
    rom.write_bytes(0x05FCC2, bytearray([0x02, 0xBD, 0x6D, 0x14, 0x09, 0x01, 0x9D, 0x6D, 0x14, 0x68, 0xFA, 0xC2, 0x20, 0x22, 0xD2, 0x85]))
    rom.write_bytes(0x05FCD2, bytearray([0x00, 0x5C, 0xA4, 0x9E, 0x03, 0xE2, 0x20, 0xAD, 0xF6, 0x7D, 0xC9, 0x0C, 0xB0, 0x1A, 0xAD, 0xCC]))
    rom.write_bytes(0x05FCE2, bytearray([0x00, 0xAD, 0x5E, 0x14, 0x38, 0xED, 0xCC, 0x00, 0x3A, 0x3A, 0x8D, 0xDE, 0x00, 0xAD, 0xF6, 0x7D]))
    rom.write_bytes(0x05FCF2, bytearray([0x38, 0xED, 0xCC, 0x00, 0x18, 0xCD, 0xDE, 0x00, 0xC2, 0x20, 0x5C, 0xBC, 0x9A, 0x02, 0xE2, 0x20]))
    rom.write_bytes(0x05FD02, bytearray([0xAD, 0x5D, 0x14, 0xF0, 0x33, 0xAA, 0xBF, 0xA3, 0xAF, 0x09, 0x18, 0x6D, 0xCC, 0x00, 0x8D, 0x5E]))
    rom.write_bytes(0x05FD12, bytearray([0x14, 0xAD, 0xF6, 0x7D, 0xC9, 0x0C, 0xB0, 0x1A, 0xAD, 0xCC, 0x00, 0xAD, 0x5E, 0x14, 0x38, 0xED]))
    rom.write_bytes(0x05FD22, bytearray([0xCC, 0x00, 0x3A, 0x3A, 0x8D, 0xDE, 0x00, 0xAD, 0xF6, 0x7D, 0x38, 0xED, 0xCC, 0x00, 0x18, 0xCD]))
    rom.write_bytes(0x05FD32, bytearray([0xDE, 0x00, 0xC2, 0x20, 0x5C, 0xAC, 0xDC, 0x01, 0x1A, 0x8D, 0x5D, 0x14, 0x80, 0xC0, 0xA9, 0x00]))
    rom.write_bytes(0x05FD42, bytearray([0x8F, 0xE8, 0x1F, 0x70, 0xAD, 0xAC, 0x60, 0xC9, 0x00, 0xD0, 0x06, 0xA9, 0x01, 0x8F, 0xE8, 0x1F]))
    rom.write_bytes(0x05FD52, bytearray([0x70, 0x4C, 0x5F, 0xF5, 0xDA, 0xAD, 0x1A, 0x02, 0x8D, 0x7C, 0x02, 0xAD, 0x12, 0x11, 0xC9, 0x08]))
    rom.write_bytes(0x05FD62, bytearray([0xB0, 0x1D, 0xAD, 0x18, 0x02, 0x4A, 0xAA, 0xA9, 0x00, 0xE0, 0x00, 0xF0, 0x06, 0x18, 0x69, 0x08]))
    rom.write_bytes(0x05FD72, bytearray([0xCA, 0x80, 0xF6, 0x18, 0x6D, 0x12, 0x11, 0xAA, 0xBF, 0x4B, 0xD4, 0x22, 0x8D, 0x1A, 0x02, 0xFA]))
    rom.write_bytes(0x05FD82, bytearray([0xA9, 0x02, 0x8D, 0x13, 0x11, 0x5C, 0x70, 0xE0, 0x17, 0xAC, 0x7C, 0x02, 0x8C, 0x1A, 0x02, 0xB9]))
    rom.write_bytes(0x05FD92, bytearray([0x22, 0x02, 0x5C, 0xA7, 0x82, 0x10, 0xAD, 0x7C, 0x02, 0x8D, 0x1A, 0x02, 0xC2, 0x20, 0xE2, 0x10]))
    rom.write_bytes(0x05FDA2, bytearray([0x5C, 0xBC, 0xB2, 0x01, 0xC9, 0x45, 0xB0, 0x03, 0x8D, 0x7C, 0x02, 0x8D, 0x1A, 0x02, 0x29, 0x07]))
    rom.write_bytes(0x05FDB2, bytearray([0x5C, 0x3A, 0x81, 0x10, 0xC9, 0x82, 0x00, 0xF0, 0x2E, 0xC9, 0x83, 0x00, 0xF0, 0x40, 0xC9, 0x84]))
    rom.write_bytes(0x05FDC2, bytearray([0x00, 0xF0, 0x0B, 0xC9, 0x85, 0x00, 0xF0, 0x0E, 0xC9, 0x80, 0x00, 0x4C, 0x45, 0xF8, 0xE2, 0x20]))
    rom.write_bytes(0x05FDD2, bytearray([0xAF, 0x99, 0xFC, 0x0D, 0x80, 0x16, 0xDA, 0xE2, 0x20, 0xAD, 0xE3, 0x00, 0xD0, 0x4E, 0x9C, 0xE1]))
    rom.write_bytes(0x05FDE2, bytearray([0x00, 0xAF, 0x99, 0xFC, 0x0D, 0x80, 0x25, 0xE2, 0x20, 0xAD, 0xB5, 0x14, 0xC9, 0x64, 0xC2, 0x20]))
    rom.write_bytes(0x05FDF2, bytearray([0xB0, 0x06, 0xA9, 0x4E, 0x00, 0x4C, 0x4C, 0xF8, 0xA9, 0x52, 0x00, 0x4C, 0x4C, 0xF8, 0xDA, 0xE2]))
    rom.write_bytes(0x05FE02, bytearray([0x20, 0xAD, 0xE3, 0x00, 0xD0, 0x26, 0x9C, 0xE1, 0x00, 0xAD, 0xB5, 0x14, 0xC9, 0x0A, 0x90, 0x08]))
    rom.write_bytes(0x05FE12, bytearray([0x38, 0xE9, 0x0A, 0xEE, 0xE1, 0x00, 0x80, 0xF4, 0x8D, 0xE2, 0x00, 0xEE, 0xE3, 0x00, 0xAD, 0xE1]))
    rom.write_bytes(0x05FE22, bytearray([0x00, 0xAA, 0xBF, 0x0B, 0xD4, 0x22, 0xC2, 0x20, 0xFA, 0x4C, 0x46, 0xF8, 0x9C, 0xE3, 0x00, 0xAD]))
    rom.write_bytes(0x05FE32, bytearray([0xE2, 0x00, 0xAA, 0xBF, 0x0B, 0xD4, 0x22, 0xC2, 0x20, 0xFA, 0x4C, 0x4C, 0xF8, 0x22, 0xB7, 0xB2]))
    rom.write_bytes(0x05FE42, bytearray([0x01, 0xEA, 0xEA, 0xEA, 0xAE, 0x7C, 0x02, 0x8E, 0x1A, 0x02, 0xEA, 0xEA, 0xEA, 0xEA, 0x5C, 0xAC]))
    rom.write_bytes(0x05FE52, bytearray([0xBE, 0x01, 0xE2, 0x20, 0xAD, 0x1A, 0x02, 0xc9, 0x3C, 0xC2, 0x20, 0xB0, 0x04, 0xA9, 0x02, 0x00]))
    rom.write_bytes(0x05FE62, bytearray([0x6B, 0xA9, 0x00, 0x00, 0x6B, 0xAD, 0x18, 0x01, 0xC9, 0x19, 0xD0, 0x3A, 0xC2, 0x20, 0x48, 0xA9]))
    rom.write_bytes(0x05FE72, bytearray([0x00, 0x00, 0xE2, 0x20, 0xAF, 0x9A, 0xFC, 0x0D, 0xD0, 0x05, 0xA9, 0x08, 0x0C, 0xB0, 0x14, 0xC2]))
    rom.write_bytes(0x05FE82, bytearray([0x10, 0xDA, 0x5A, 0x8B, 0xAD, 0x0E, 0x03, 0xC2, 0x20, 0xAA, 0xBF, 0x07, 0xFF, 0x06, 0xA8, 0xE2]))
    rom.write_bytes(0x05FE92, bytearray([0x20, 0xA9, 0x00, 0xEB, 0xA9, 0x7F, 0xA2, 0x40, 0x14, 0x54, 0x70, 0x7E, 0xAB, 0x7A, 0xFA, 0xC2]))
    rom.write_bytes(0x05FEA2, bytearray([0x20, 0x68, 0xE2, 0x20, 0xE2, 0x10, 0x22, 0x4B, 0x82, 0x00, 0x5C, 0xD9, 0x87, 0x17]))

    rom.write_bytes(0x00EDD0, bytearray([0xda, 0xa2, 0x00, 0x00, 0xe2, 0x20, 0xc9, 0x00, 0xf0, 0x0b, 0x48, 0x8a, 0x18, 0x69, 0x0c, 0xaa]))
    rom.write_bytes(0x00EDE0, bytearray([0x68, 0x3a, 0x3a, 0x80, 0xf1, 0x98, 0x4a, 0x8f, 0x80, 0x24, 0x7e, 0x18, 0x8a, 0x6f, 0x80, 0x24]))
    rom.write_bytes(0x00EDF0, bytearray([0x7e, 0xaa, 0xbf, 0x00, 0x80, 0x02, 0x0a, 0xaa, 0xc2, 0x20, 0xbf, 0x8e, 0xd4, 0x22, 0xfa, 0x18]))
    rom.write_bytes(0x00EE00, bytearray([0x5c, 0xb6, 0xc0, 0x17, 0xda, 0xe2, 0x20, 0xa2, 0x00, 0x00, 0xdf, 0x4b, 0xd4, 0x22, 0xf0, 0x0e]))
    rom.write_bytes(0x00EE10, bytearray([0xe8, 0xe0, 0x30, 0x00, 0xb0, 0x02, 0x80, 0xf2, 0xa9, 0x00, 0xeb, 0xad, 0x1a, 0x02, 0xaa, 0xbf]))
    rom.write_bytes(0x00EE20, bytearray([0x00, 0x80, 0x02, 0xaa, 0xbf, 0x9e, 0xd4, 0x22, 0xc2, 0x20, 0x29, 0xff, 0x00, 0xfa, 0x5c, 0xfd]))
    rom.write_bytes(0x00EE30, bytearray([0xc6, 0x17]))


def ExtendedItemHandler(rom: LocalRom) -> None:
    rom.write_bytes(0x10B3FB, bytearray([0xE2, 0x20, 0xC9, 0x45, 0xB0]))
    rom.write_bytes(0x10B400, bytearray([0x0C, 0xC2, 0x20, 0xA9, 0x10, 0x03, 0x8D, 0x7E, 0x02, 0x5C, 0xCF, 0xF4, 0x0B, 0xAD, 0x0F, 0x0B]))
    rom.write_bytes(0x10B410, bytearray([0xD0, 0x38, 0xEE, 0xB5, 0x14, 0xA9, 0x18, 0x8D, 0x53, 0x00, 0xAF, 0x9A, 0xFC, 0x0D, 0xF0, 0x09]))
    rom.write_bytes(0x10B420, bytearray([0xAD, 0xB5, 0x14, 0xCF, 0x99, 0xFC, 0x0D, 0xB0, 0x04, 0x5C, 0x0A, 0xF5, 0x0B, 0xAD, 0xB6, 0x14]))
    rom.write_bytes(0x10B430, bytearray([0xD0, 0xF7, 0xA9, 0x01, 0x8D, 0xB6, 0x14, 0xA9, 0x0A, 0x8D, 0x18, 0x02, 0xA9, 0x16, 0x8D, 0x18]))
    rom.write_bytes(0x10B440, bytearray([0x01, 0xA9, 0x97, 0x8D, 0x53, 0x00, 0x5C, 0x0A, 0xF5, 0x0B, 0xFA, 0x5C, 0x10, 0xF5, 0x0B]))


def patch_rom(world: "YoshisIslandWorld", rom: LocalRom, player: int) -> None:
    handle_items(rom)  # Implement main item functionality
    Item_Data(rom)  # Pointers necessary for item functionality
    write_lives(rom)  # Writes the number of lives as set in AP
    CodeHandler(rom)  # Jumps to my code
    Server_Data(rom)  # Pointers mostly related to receiving items
    Menu_Data(rom)  # Data related to the AP menu
    Handle_Locations(rom)
    ExtendedItemHandler(rom)
    rom.write_bytes(0x11544B, bytearray(world.global_level_list))
    rom.write_bytes(0x11547A, bytearray([0x43]))

    rom.write_bytes(0x06FC89, world.starting_lives)
    rom.write_bytes(0x03464F, ([world.baby_mario_sfx]))
    rom.write_bytes(0x06FC83, ([world.options.starting_world.value]))
    rom.write_bytes(0x06FC84, ([world.options.hidden_object_visibility.value]))
    rom.write_bytes(0x06FC88, ([world.options.shuffle_midrings.value]))
    rom.write_bytes(0x06FC85, ([world.options.castle_open_condition.value]))
    rom.write_bytes(0x06FC86, ([world.options.castle_clear_condition.value]))
    rom.write_bytes(0x06FC87, ([world.options.disable_autoscroll.value]))
    rom.write_bytes(0x06FC8B, ([world.options.minigame_checks.value]))
    rom.write_byte(0x06FC8C, world.options.death_link.value)
    rom.write_bytes(0x06FC8D, bytearray(world.boss_room_id))
    rom.write_bytes(0x06FC99, bytearray([world.options.luigi_pieces_required.value]))
    rom.write_bytes(0x06FC9A, bytearray([world.options.goal.value]))

    if world.options.yoshi_colors != YoshiColors.option_normal:
        rom.write_bytes(0x113A33, bytearray(world.bowser_text))

    rom.write_bytes(0x0A060C, bytearray(world.boss_burt_data))
    rom.write_bytes(0x0A8666, bytearray(world.boss_slime_data))
    rom.write_bytes(0x0A9D90, bytearray(world.boss_boo_data))
    rom.write_bytes(0x0074EA, bytearray(world.boss_pot_data))
    rom.write_bytes(0x08DC0A, bytearray(world.boss_frog_data))
    rom.write_bytes(0x0A4440, bytearray(world.boss_plant_data))
    rom.write_bytes(0x0968A2, bytearray(world.boss_milde_data))
    rom.write_bytes(0x0B3E10, bytearray(world.boss_koop_data))
    rom.write_bytes(0x0B4BD0, bytearray(world.boss_slug_data))
    rom.write_bytes(0x0B6BBA, bytearray(world.boss_raph_data))
    rom.write_bytes(0x087BED, bytearray(world.boss_tap_data))

    rom.write_bytes(0x07A00D, ([world.tap_tap_room]))
    rom.write_bytes(0x079DF2, ([world.tap_tap_room]))
    rom.write_bytes(0x079CCF, ([world.tap_tap_room]))
    rom.write_bytes(0x079C4D, ([world.tap_tap_room]))

    rom.write_bytes(0x045A2E, bytearray(world.Stage11StageGFX))
    rom.write_bytes(0x045A31, bytearray(world.Stage12StageGFX))
    rom.write_bytes(0x045A34, bytearray(world.Stage13StageGFX))
    rom.write_bytes(0x045A37, bytearray(world.Stage14StageGFX))
    rom.write_bytes(0x045A3A, bytearray(world.Stage15StageGFX))
    rom.write_bytes(0x045A3D, bytearray(world.Stage16StageGFX))
    rom.write_bytes(0x045A40, bytearray(world.Stage17StageGFX))
    rom.write_bytes(0x045A43, bytearray(world.Stage18StageGFX))

    rom.write_bytes(0x045A52, bytearray(world.Stage21StageGFX))
    rom.write_bytes(0x045A55, bytearray(world.Stage22StageGFX))
    rom.write_bytes(0x045A58, bytearray(world.Stage23StageGFX))
    rom.write_bytes(0x045A5B, bytearray(world.Stage24StageGFX))
    rom.write_bytes(0x045A5E, bytearray(world.Stage25StageGFX))
    rom.write_bytes(0x045A61, bytearray(world.Stage26StageGFX))
    rom.write_bytes(0x045A64, bytearray(world.Stage27StageGFX))
    rom.write_bytes(0x045A67, bytearray(world.Stage28StageGFX))

    rom.write_bytes(0x045A76, bytearray(world.Stage31StageGFX))
    rom.write_bytes(0x045A79, bytearray(world.Stage32StageGFX))
    rom.write_bytes(0x045A7C, bytearray(world.Stage33StageGFX))
    rom.write_bytes(0x045A7F, bytearray(world.Stage34StageGFX))
    rom.write_bytes(0x045A82, bytearray(world.Stage35StageGFX))
    rom.write_bytes(0x045A85, bytearray(world.Stage36StageGFX))
    rom.write_bytes(0x045A88, bytearray(world.Stage37StageGFX))
    rom.write_bytes(0x045A8B, bytearray(world.Stage38StageGFX))

    rom.write_bytes(0x045A9A, bytearray(world.Stage41StageGFX))
    rom.write_bytes(0x045A9D, bytearray(world.Stage42StageGFX))
    rom.write_bytes(0x045AA0, bytearray(world.Stage43StageGFX))
    rom.write_bytes(0x045AA3, bytearray(world.Stage44StageGFX))
    rom.write_bytes(0x045AA6, bytearray(world.Stage45StageGFX))
    rom.write_bytes(0x045AA9, bytearray(world.Stage46StageGFX))
    rom.write_bytes(0x045AAC, bytearray(world.Stage47StageGFX))
    rom.write_bytes(0x045AAF, bytearray(world.Stage48StageGFX))

    rom.write_bytes(0x045ABE, bytearray(world.Stage51StageGFX))
    rom.write_bytes(0x045AC1, bytearray(world.Stage52StageGFX))
    rom.write_bytes(0x045AC4, bytearray(world.Stage53StageGFX))
    rom.write_bytes(0x045AC7, bytearray(world.Stage54StageGFX))
    rom.write_bytes(0x045ACA, bytearray(world.Stage55StageGFX))
    rom.write_bytes(0x045ACD, bytearray(world.Stage56StageGFX))
    rom.write_bytes(0x045AD0, bytearray(world.Stage57StageGFX))
    rom.write_bytes(0x045AD3, bytearray(world.Stage58StageGFX))

    rom.write_bytes(0x045AE2, bytearray(world.Stage61StageGFX))
    rom.write_bytes(0x045AE5, bytearray(world.Stage62StageGFX))
    rom.write_bytes(0x045AE8, bytearray(world.Stage63StageGFX))
    rom.write_bytes(0x045AEB, bytearray(world.Stage64StageGFX))
    rom.write_bytes(0x045AEE, bytearray(world.Stage65StageGFX))
    rom.write_bytes(0x045AF1, bytearray(world.Stage66StageGFX))
    rom.write_bytes(0x045AF4, bytearray(world.Stage67StageGFX))

    rom.write_bytes(0x0BDBAF, bytearray(world.level_gfx_table))
    rom.write_bytes(0x0BDC4F, bytearray(world.palette_panel_list))

    if world.options.yoshi_colors == YoshiColors.option_random_order:
        rom.write_bytes(0x010000, ([world.leader_color]))
        rom.write_bytes(0x010008, ([world.leader_color]))
        rom.write_bytes(0x010009, ([world.leader_color]))
        rom.write_bytes(0x010001, bytearray(world.color_order))
        rom.write_bytes(0x01000C, ([world.leader_color]))
        rom.write_bytes(0x010014, ([world.leader_color]))
        rom.write_bytes(0x010015, ([world.leader_color]))
        rom.write_bytes(0x01000D, bytearray(world.color_order))
        rom.write_bytes(0x010018, ([world.leader_color]))
        rom.write_bytes(0x010020, ([world.leader_color]))
        rom.write_bytes(0x010021, ([world.leader_color]))
        rom.write_bytes(0x01001A, bytearray(world.color_order))
        rom.write_bytes(0x010024, ([world.leader_color]))
        rom.write_bytes(0x01002C, ([world.leader_color]))
        rom.write_bytes(0x01002D, ([world.leader_color]))
        rom.write_bytes(0x010025, bytearray(world.color_order))
        rom.write_bytes(0x010030, ([world.leader_color]))
        rom.write_bytes(0x010038, ([world.leader_color]))
        rom.write_bytes(0x010039, ([world.leader_color]))
        rom.write_bytes(0x010031, bytearray(world.color_order))
        rom.write_bytes(0x01003C, ([world.leader_color]))
        rom.write_bytes(0x010044, ([world.leader_color]))
        rom.write_bytes(0x010045, ([world.leader_color]))
        rom.write_bytes(0x01003D, bytearray(world.color_order))
        rom.write_bytes(0x010043, ([world.leader_color]))
    elif world.options.yoshi_colors in {YoshiColors.option_random_color, YoshiColors.option_singularity}:
        rom.write_bytes(0x010000, bytearray(world.level_colors))

    if world.options.minigame_checks in {MinigameChecks.option_bonus_games, MinigameChecks.option_both}:
        bonus_checks(rom)

    if world.options.minigame_checks in {MinigameChecks.option_bandit_games, MinigameChecks.option_both}:
        bandit_checks(rom)

    rom.write_bytes(0x00BF2C, bytearray(world.world_bonus))

    if world.options.softlock_prevention:
        rom.write_bytes(0x00C18F, bytearray([0x5C, 0x58, 0xFB, 0x0B]))  # R + X Code

    if world.options.bowser_door_mode != BowserDoor.option_manual:
        rom.write_bytes(0x07891F, bytearray(world.castle_door))  # 1 Entry
        rom.write_bytes(0x078923, bytearray(world.castle_door))  # 2 Entry
        rom.write_bytes(0x078927, bytearray(world.castle_door))  # 3 Entry
        rom.write_bytes(0x07892B, bytearray(world.castle_door))  # 4 Entry

    if world.options.bowser_door_mode == BowserDoor.option_gauntlet:
        rom.write_bytes(0x0AF517, bytearray([0xC6, 0x07, 0x7A, 0x00]))  # Door 2
        rom.write_bytes(0x0AF6B7, bytearray([0xCD, 0x05, 0x5B, 0x00]))  # Door 3
        rom.write_bytes(0x0AF8F2, bytearray([0xD3, 0x00, 0x77, 0x06]))  # Door 4

    if world.options.goal == PlayerGoal.option_luigi_hunt:
        rom.write_bytes(0x1153F6, bytearray([0x16, 0x28, 0x10, 0x0C, 0x10, 0x4E, 0x1E, 0x10, 0x08, 0x04, 0x08, 0x24, 0x36, 0x82, 0x83, 0x83, 0x34, 0x84, 0x85, 0x85]))  # Luigi piece clear text
        rom.write_bytes(0x06FC86, bytearray([0xFF]))  # Boss clear goal = 255, renders bowser inaccessible

    from Main import __version__
    rom.name = bytearray(f'YOSHIAP{__version__.replace(".", "")[0:3]}_{player}_{world.multiworld.seed:11}\0', "utf8")[:21]
    rom.name.extend([0] * (21 - len(rom.name)))
    rom.write_bytes(0x007FC0, rom.name)


class YoshisIslandDeltaPatch(APDeltaPatch):
    hash = USHASH
    game: str = "Yoshi's Island"
    patch_file_ending = ".apyi"

    @classmethod
    def get_source_data(cls) -> bytes:
        return get_base_rom_bytes()


def get_base_rom_bytes(file_name: str = "") -> bytes:
    base_rom_bytes = getattr(get_base_rom_bytes, "base_rom_bytes", None)
    if not base_rom_bytes:
        file_name = get_base_rom_path(file_name)
        base_rom_bytes = bytes(Utils.read_snes_rom(open(file_name, "rb")))

        basemd5 = hashlib.md5()
        basemd5.update(base_rom_bytes)
        if USHASH != basemd5.hexdigest():
            raise Exception("Supplied Base Rom does not match known MD5 for US(1.0) release. "
                            "Get the correct game and version, then dump it")
        get_base_rom_bytes.base_rom_bytes = base_rom_bytes
    return base_rom_bytes


def get_base_rom_path(file_name: str = "") -> str:
    if not file_name:
        file_name = get_settings()["yoshisisland_options"]["rom_file"]
    if not os.path.exists(file_name):
        file_name = Utils.user_path(file_name)
    return file_name
