LOCATIONS: dict[str, list[str]] = {
    "Ninja Village - Nest": [
        "Ninja Village - Candle",
        "Ninja Village - Astral Seed",
        "Ninja Village Seal - Tree House",
    ],
    "Autumn Hills - Climbing Claws Shop": [
        "Autumn Hills - Climbing Claws",
        "Autumn Hills Seal - Trip Saws",
    ],
    "Autumn Hills - Key of Hope Checkpoint": [
        "Autumn Hills - Key of Hope",
    ],
    "Autumn Hills - Double Swing Checkpoint": [
        "Autumn Hills Seal - Double Swing Saws",
    ],
    "Autumn Hills - Spike Ball Swing Checkpoint": [
        "Autumn Hills Seal - Spike Ball Swing",
        "Autumn Hills Seal - Spike Ball Darts",
    ],
    "Autumn Hills - Leaf Golem Shop": [
        "Autumn Hills - Leaf Golem",
    ],
    "Forlorn Temple - Rocket Maze Checkpoint": [
        "Forlorn Temple Seal - Rocket Maze",
    ],
    "Forlorn Temple - Rocket Sunset Shop": [
        "Forlorn Temple Seal - Rocket Sunset",
    ],
    "Forlorn Temple - Demon King Shop": [
        "Forlorn Temple - Demon King",
    ],
    "Catacombs - Top Left": [
        "Catacombs - Necro",
    ],
    "Catacombs - Triple Spike Crushers Shop": [
        "Catacombs Seal - Triple Spike Crushers",
    ],
    "Catacombs - Dirty Pond Checkpoint": [
        "Catacombs Seal - Crusher Gauntlet",
        "Catacombs Seal - Dirty Pond",
    ],
    "Catacombs - Ruxxtin Shop": [
        "Catacombs - Ruxxtin's Amulet",
        "Catacombs - Ruxxtin",
    ],
    "Bamboo Creek - Spike Crushers Shop": [
        "Bamboo Creek Seal - Spike Crushers and Doors",
    ],
    "Bamboo Creek - Spike Ball Pits Checkpoint": [
        "Bamboo Creek Seal - Spike Ball Pits",
    ],
    "Bamboo Creek - Time Loop Shop": [
        "Bamboo Creek Seal - Spike Crushers and Doors v2",
        "Bamboo Creek - Claustro",
    ],
    "Howling Grotto - Wingsuit Shop": [
        "Howling Grotto - Wingsuit",
        "Howling Grotto Seal - Windy Saws and Balls",
    ],
    "Howling Grotto - Crushing Pits Shop": [
        "Howling Grotto Seal - Crushing Pits",
    ],
    "Howling Grotto - Breezy Crushers Checkpoint": [
        "Howling Grotto Seal - Breezy Crushers",
    ],
    "Howling Grotto - Emerald Golem Shop": [
        "Howling Grotto - Emerald Golem",
    ],
    "Quillshroom Marsh - Seashell Checkpoint": [
        "Quillshroom Marsh - Seashell",
    ],
    "Quillshroom Marsh - Spikey Window Shop": [
        "Quillshroom Marsh Seal - Spikey Window",
    ],
    "Quillshroom Marsh - Sand Trap Shop": [
        "Quillshroom Marsh Seal - Sand Trap",
    ],
    "Quillshroom Marsh - Spike Wave Checkpoint": [
        "Quillshroom Marsh Seal - Do the Spike Wave",
    ],
    "Quillshroom Marsh - Queen of Quills Shop": [
        "Quillshroom Marsh - Queen of Quills",
    ],
    "Searing Crags - Rope Dart Shop": [
        "Searing Crags - Rope Dart",
    ],
    "Searing Crags - Triple Ball Spinner Checkpoint": [
        "Searing Crags Seal - Triple Ball Spinner",
    ],
    "Searing Crags - Raining Rocks Checkpoint": [
        "Searing Crags Seal - Raining Rocks",
    ],
    "Searing Crags - Colossuses Shop": [
        "Searing Crags Seal - Rhythm Rocks",
        "Searing Crags - Power Thistle",
        "Searing Crags - Astral Tea Leaves",
    ],
    "Searing Crags - Key of Strength Shop": [
        "Searing Crags - Key of Strength",
    ],
    "Searing Crags - Portal": [
        "Searing Crags - Pyro",
    ],
    "Glacial Peak - Ice Climbers' Shop": [
        "Glacial Peak Seal - Ice Climbers",
    ],
    "Glacial Peak - Projectile Spike Pit Checkpoint": [
        "Glacial Peak Seal - Projectile Spike Pit",
    ],
    "Glacial Peak - Air Swag Checkpoint": [
        "Glacial Peak Seal - Glacial Air Swag",
    ],
    "Tower of Time - First Checkpoint": [
        "Tower of Time Seal - Time Waster",
    ],
    "Tower of Time - Fourth Checkpoint": [
        "Tower of Time Seal - Lantern Climb",
    ],
    "Tower of Time - Fifth Checkpoint": [
        "Tower of Time Seal - Arcane Orbs",
    ],
    "Cloud Ruins - Ghost Pit Checkpoint": [
        "Cloud Ruins Seal - Ghost Pit",
    ],
    "Cloud Ruins - Toothbrush Alley Checkpoint": [
        "Cloud Ruins Seal - Toothbrush Alley",
    ],
    "Cloud Ruins - Saw Pit Checkpoint": [
        "Cloud Ruins Seal - Saw Pit",
    ],
    "Cloud Ruins - Final Flight Shop": [
        "Cloud Ruins - Acro",
    ],
    "Cloud Ruins - Manfred's Shop": [
        "Cloud Ruins Seal - Money Farm Room",
    ],
    "Underworld - Left Shop": [
        "Underworld Seal - Sharp and Windy Climb",
    ],
    "Underworld - Fireball Wave Shop": [
        "Underworld Seal - Spike Wall",
        "Underworld Seal - Fireball Wave",
    ],
    "Underworld - Hot Tub Checkpoint": [
        "Underworld Seal - Rising Fanta",
    ],
    "Underworld - Key of Chaos Shop": [
        "Underworld - Key of Chaos",
    ],
    "Riviere Turquoise - Waterfall Shop": [
        "Riviere Turquoise Seal - Bounces and Balls",
    ],
    "Riviere Turquoise - Launch of Faith Shop": [
        "Riviere Turquoise Seal - Launch of Faith",
    ],
    "Riviere Turquoise - Restock Shop": [
        "Riviere Turquoise Seal - Flower Power",
    ],
    "Riviere Turquoise - Butterfly Matriarch Shop": [
        "Riviere Turquoise - Butterfly Matriarch",
    ],
    "Sunken Shrine - Lifeguard Shop": [
        "Sunken Shrine Seal - Ultra Lifeguard",
    ],
    "Sunken Shrine - Lightfoot Tabi Checkpoint": [
        "Sunken Shrine - Lightfoot Tabi",
    ],
    "Sunken Shrine - Portal": [
        "Sunken Shrine - Key of Love",
    ],
    "Sunken Shrine - Tabi Gauntlet Shop": [
        "Sunken Shrine Seal - Tabi Gauntlet",
    ],
    "Sunken Shrine - Sun Crest Checkpoint": [
        "Sunken Shrine - Sun Crest",
    ],
    "Sunken Shrine - Waterfall Paradise Checkpoint": [
        "Sunken Shrine Seal - Waterfall Paradise",
    ],
    "Sunken Shrine - Moon Crest Checkpoint": [
        "Sunken Shrine - Moon Crest",
    ],
    "Elemental Skylands - Air Seal Checkpoint": [
        "Elemental Skylands Seal - Air",
    ],
    "Elemental Skylands - Water Intro Shop": [
        "Elemental Skylands Seal - Water",
    ],
    "Elemental Skylands - Fire Intro Shop": [
        "Elemental Skylands Seal - Fire",
    ],
    "Elemental Skylands - Right": [
        "Elemental Skylands - Key of Symbiosis",
    ],
    "Corrupted Future": ["Corrupted Future - Key of Courage"],
    "Music Box": ["Rescue Phantom"],
}


SUB_REGIONS: dict[str, list[str]] = {
    "Ninja Village": [
        "Right",
    ],
    "Autumn Hills": [
        "Left",
        "Right",
        "Bottom",
        "Portal",
        "Climbing Claws Shop",
        "Hope Path Shop",
        "Dimension Climb Shop",
        "Leaf Golem Shop",
        "Hope Path Checkpoint",
        "Key of Hope Checkpoint",
        "Lakeside Checkpoint",
        "Double Swing Checkpoint",
        "Spike Ball Swing Checkpoint",
    ],
    "Forlorn Temple": [
        "Left",
        "Right",
        "Bottom",
        "Outside Shop",
        "Entrance Shop",
        "Climb Shop",
        "Rocket Sunset Shop",
        "Descent Shop",
        "Final Fall Shop",
        "Demon King Shop",
        "Sunny Day Checkpoint",
        "Rocket Maze Checkpoint",
    ],
    "Catacombs": [
        "Top Left",
        "Bottom Left",
        "Bottom",
        "Right",
        "Triple Spike Crushers Shop",
        "Ruxxtin Shop",
        "Death Trap Checkpoint",
        "Crusher Gauntlet Checkpoint",
        "Dirty Pond Checkpoint",
    ],
    "Bamboo Creek": [
        "Bottom Left",
        "Top Left",
        "Right",
        "Spike Crushers Shop",
        "Abandoned Shop",
        "Time Loop Shop",
        "Spike Ball Pits Checkpoint",
        "Spike Doors Checkpoint",
    ],
    "Howling Grotto": [
        "Left",
        "Top",
        "Right",
        "Bottom",
        "Portal",
        "Wingsuit Shop",
        "Crushing Pits Shop",
        "Emerald Golem Shop",
        "Lost Woods Checkpoint",
        "Breezy Crushers Checkpoint",
    ],
    "Quillshroom Marsh": [
        "Top Left",
        "Bottom Left",
        "Top Right",
        "Bottom Right",
        "Spikey Window Shop",
        "Sand Trap Shop",
        "Queen of Quills Shop",
        "Seashell Checkpoint",
        "Quicksand Checkpoint",
        "Spike Wave Checkpoint",
    ],
    "Searing Crags": [
        "Left",
        "Top",
        "Bottom",
        "Right",
        "Portal",
        "Rope Dart Shop",
        "Falling Rocks Shop",
        "Searing Mega Shard Shop",
        "Before Final Climb Shop",
        "Colossuses Shop",
        "Key of Strength Shop",
        "Triple Ball Spinner Checkpoint",
        "Raining Rocks Checkpoint",
    ],
    "Glacial Peak": [
        "Bottom",
        "Top",
        "Portal",
        "Ice Climbers' Shop",
        "Glacial Mega Shard Shop",
        "Tower Entrance Shop",
        "Projectile Spike Pit Checkpoint",
        "Air Swag Checkpoint",
        "Free Climbing Checkpoint",
    ],
    "Tower of Time": [
        "Left",
        "Entrance Shop",
        "Arcane Golem Shop",
        "First Checkpoint",
        "Second Checkpoint",
        "Third Checkpoint",
        "Fourth Checkpoint",
        "Fifth Checkpoint",
        "Sixth Checkpoint",
    ],
    "Cloud Ruins": [
        "Left",
        "Entrance Shop",
        "Pillar Glide Shop",
        "Crushers' Descent Shop",
        "Seeing Spikes Shop",
        "Sliding Spikes Shop",
        "Final Flight Shop",
        "Manfred's Shop",
        "Spike Float Checkpoint",
        "Ghost Pit Checkpoint",
        "Toothbrush Alley Checkpoint",
        "Saw Pit Checkpoint",
    ],
    "Underworld": [
        "Left",
        "Entrance Shop",
        "Fireball Wave Shop",
        "Long Climb Shop",
        "Barm'athaziel Shop",
        "Key of Chaos Shop",
        "Hot Dip Checkpoint",
        "Hot Tub Checkpoint",
        "Lava Run Checkpoint",
    ],
    "Riviere Turquoise": [
        "Right",
        "Portal",
        "Waterfall Shop",
        "Launch of Faith Shop",
        "Log Flume Shop",
        "Log Climb Shop",
        "Restock Shop",
        "Butterfly Matriarch Shop",
        "Flower Flight Checkpoint",
    ],
    "Elemental Skylands": [
        "Air Shmup",
        "Air Intro Shop",
        "Air Seal Checkpoint",
        "Air Generator Shop",
        "Earth Shmup",
        "Earth Intro Shop",
        "Earth Generator Shop",
        "Fire Shmup",
        "Fire Intro Shop",
        "Fire Generator Shop",
        "Water Shmup",
        "Water Intro Shop",
        "Water Generator Shop",
        "Right",
    ],
    "Sunken Shrine": [
        "Left",
        "Portal",
        "Entrance Shop",
        "Lifeguard Shop",
        "Sun Path Shop",
        "Tabi Gauntlet Shop",
        "Moon Path Shop",
        "Ninja Tabi Checkpoint",
        "Sun Crest Checkpoint",
        "Waterfall Paradise Checkpoint",
        "Moon Crest Checkpoint",
    ],
}


# order is slightly funky here for back compat
MEGA_SHARDS: dict[str, list[str]] = {
    "Autumn Hills - Lakeside Checkpoint": ["Autumn Hills Mega Shard"],
    "Forlorn Temple - Outside Shop": ["Hidden Entrance Mega Shard"],
    "Catacombs - Top Left": ["Catacombs Mega Shard"],
    "Bamboo Creek - Spike Crushers Shop": ["Above Entrance Mega Shard"],
    "Bamboo Creek - Abandoned Shop": ["Abandoned Mega Shard"],
    "Bamboo Creek - Time Loop Shop": ["Time Loop Mega Shard"],
    "Howling Grotto - Lost Woods Checkpoint": ["Bottom Left Mega Shard"],
    "Howling Grotto - Breezy Crushers Checkpoint": ["Near Portal Mega Shard", "Pie in the Sky Mega Shard"],
    "Quillshroom Marsh - Spikey Window Shop": ["Quillshroom Marsh Mega Shard"],
    "Searing Crags - Searing Mega Shard Shop": ["Searing Crags Mega Shard"],
    "Glacial Peak - Glacial Mega Shard Shop": ["Glacial Peak Mega Shard"],
    "Cloud Ruins - Cloud Entrance Shop": ["Cloud Entrance Mega Shard", "Time Warp Mega Shard"],
    "Cloud Ruins - Manfred's Shop": ["Money Farm Room Mega Shard 1", "Money Farm Room Mega Shard 2"],
    "Underworld - Left Shop": ["Under Entrance Mega Shard"],
    "Underworld - Hot Tub Checkpoint": ["Hot Tub Mega Shard", "Projectile Pit Mega Shard"],
    "Forlorn Temple - Sunny Day Checkpoint": ["Sunny Day Mega Shard"],
    "Forlorn Temple - Demon King Shop": ["Down Under Mega Shard"],
    "Sunken Shrine - Waterfall Paradise Checkpoint": ["Mega Shard of the Moon"],
    "Sunken Shrine - Portal": ["Beginner's Mega Shard"],
    "Sunken Shrine - Above Portal Shop": ["Mega Shard of the Stars"],
    "Sunken Shrine - Sun Crest Checkpoint": ["Mega Shard of the Sun"],
    "Riviere Turquoise - Waterfall Shop": ["Waterfall Mega Shard"],
    "Riviere Turquoise - Restock Shop": ["Quick Restock Mega Shard 1", "Quick Restock Mega Shard 2"],
    "Elemental Skylands - Earth Intro Shop": ["Earth Mega Shard"],
    "Elemental Skylands - Water Generator Shop": ["Water Mega Shard"],
}


REGION_CONNECTIONS: dict[str, dict[str, str]] = {
    "Menu": {"Tower HQ": "Start Game"},
    "Tower HQ": {
        "Autumn Hills - Portal": "ToTHQ Autumn Hills Portal",
        "Howling Grotto - Portal": "ToTHQ Howling Grotto Portal",
        "Searing Crags - Portal": "ToTHQ Searing Crags Portal",
        "Glacial Peak - Portal": "ToTHQ Glacial Peak Portal",
        "Tower of Time - Left": "Artificer's Challenge",
        "Riviere Turquoise - Portal": "ToTHQ Riviere Turquoise Portal",
        "Sunken Shrine - Portal": "ToTHQ Sunken Shrine Portal",
        "Corrupted Future": "Artificer's Portal",
        "The Shop": "Home",
        "Music Box": "Shrink Down",
    },
    "The Shop": {
        "The Craftsman's Corner": "Money Sink",
    },
}
"""Vanilla layout mapping with all Tower HQ portals open. format is source[exit_region][entrance_name]"""


# regions that don't have sub-regions
LEVELS: list[str] = [
    "Menu",
    "Tower HQ",
    "The Shop",
    "The Craftsman's Corner",
    "Corrupted Future",
    "Music Box",
]
