from dataclasses import dataclass
from typing import NamedTuple

from BaseClasses import ItemClassification

class ItemData(NamedTuple):
    code: int
    itemName: str
    classification: ItemClassification


sonic_heroes_story_names: dict[int, str] = {
    0: "Sonic",
    1: "Dark",
    2: "Rose",
    3: "Chaotix"
}

sonic_heroes_level_names: dict[int, str] = {
    1: "Seaside Hill",
    2: "Ocean Palace",
    3: "Grand Metropolis",
    4: "Power Plant",
    5: "Casino Park",
    6: "Bingo Highway",
    7: "Rail Canyon",
    8: "Bullet Station",
    9: "Frog Forest",
    10: "Lost Jungle",
    11: "Hang Castle",
    12: "Mystic Mansion",
    13: "Egg Fleet",
    14: "Final Fortress"
}

sonic_heroes_extra_names: dict[int, str] = {
    0: "Egg Hawk",
    1: "Team Fight 1",
    2: "Robot Carnival",
    3: "Egg Albatross",
    4: "Team Fight 2",
    5: "Robot Storm",
    6: "Egg Emperor"
}

location_id_name_dict: dict[int, str] = {
    0x939300a0: "Seaside Hill Sonic Act 1",
    0x939300a1: "Seaside Hill Sonic Act 2",
    0x939300a2: "Ocean Palace Sonic Act 1",
    0x939300a3: "Ocean Palace Sonic Act 2",
    0x939300a4: "Grand Metropolis Sonic Act 1",
    0x939300a5: "Grand Metropolis Sonic Act 2",
    0x939300a6: "Power Plant Sonic Act 1",
    0x939300a7: "Power Plant Sonic Act 2",
    0x939300a8: "Casino Park Sonic Act 1",
    0x939300a9: "Casino Park Sonic Act 2",
    0x939300aa: "Bingo Highway Sonic Act 1",
    0x939300ab: "Bingo Highway Sonic Act 2",
    0x939300ac: "Rail Canyon Sonic Act 1",
    0x939300ad: "Rail Canyon Sonic Act 2",
    0x939300ae: "Bullet Station Sonic Act 1",
    0x939300af: "Bullet Station Sonic Act 2",
    0x939300b0: "Frog Forest Sonic Act 1",
    0x939300b1: "Frog Forest Sonic Act 2",
    0x939300b2: "Lost Jungle Sonic Act 1",
    0x939300b3: "Lost Jungle Sonic Act 2",
    0x939300b4: "Hang Castle Sonic Act 1",
    0x939300b5: "Hang Castle Sonic Act 2",
    0x939300b6: "Mystic Mansion Sonic Act 1",
    0x939300b7: "Mystic Mansion Sonic Act 2",
    0x939300b8: "Egg Fleet Sonic Act 1",
    0x939300b9: "Egg Fleet Sonic Act 2",
    0x939300ba: "Final Fortress Sonic Act 1",
    0x939300bb: "Final Fortress Sonic Act 2",
    0x939300bc: "Egg Hawk Sonic",
    0x939300be: "Team Fight 1 Sonic",
    0x939300c0: "Robot Carnival Sonic",
    0x939300c2: "Egg Albatross Sonic",
    0x939300c4: "Team Fight 2 Sonic",
    0x939300c6: "Robot Storm Sonic",
    0x939300c8: "Egg Emperor Sonic",
    0x939300ca: "Seaside Hill Dark Act 1",
    0x939300cb: "Seaside Hill Dark Act 2",
    0x939300cc: "Ocean Palace Dark Act 1",
    0x939300cd: "Ocean Palace Dark Act 2",
    0x939300ce: "Grand Metropolis Dark Act 1",
    0x939300cf: "Grand Metropolis Dark Act 2",
    0x939300d0: "Power Plant Dark Act 1",
    0x939300d1: "Power Plant Dark Act 2",
    0x939300d2: "Casino Park Dark Act 1",
    0x939300d3: "Casino Park Dark Act 2",
    0x939300d4: "Bingo Highway Dark Act 1",
    0x939300d5: "Bingo Highway Dark Act 2",
    0x939300d6: "Rail Canyon Dark Act 1",
    0x939300d7: "Rail Canyon Dark Act 2",
    0x939300d8: "Bullet Station Dark Act 1",
    0x939300d9: "Bullet Station Dark Act 2",
    0x939300da: "Frog Forest Dark Act 1",
    0x939300db: "Frog Forest Dark Act 2",
    0x939300dc: "Lost Jungle Dark Act 1",
    0x939300dd: "Lost Jungle Dark Act 2",
    0x939300de: "Hang Castle Dark Act 1",
    0x939300df: "Hang Castle Dark Act 2",
    0x939300e0: "Mystic Mansion Dark Act 1",
    0x939300e1: "Mystic Mansion Dark Act 2",
    0x939300e2: "Egg Fleet Dark Act 1",
    0x939300e3: "Egg Fleet Dark Act 2",
    0x939300e4: "Final Fortress Dark Act 1",
    0x939300e5: "Final Fortress Dark Act 2",
    0x939300e6: "Egg Hawk Dark",
    0x939300e8: "Team Fight 1 Dark",
    0x939300ea: "Robot Carnival Dark",
    0x939300ec: "Egg Albatross Dark",
    0x939300ee: "Team Fight 2 Dark",
    0x939300f0: "Robot Storm Dark",
    0x939300f2: "Egg Emperor Dark",
    0x939300f4: "Seaside Hill Rose Act 1",
    0x939300f5: "Seaside Hill Rose Act 2",
    0x939300f6: "Ocean Palace Rose Act 1",
    0x939300f7: "Ocean Palace Rose Act 2",
    0x939300f8: "Grand Metropolis Rose Act 1",
    0x939300f9: "Grand Metropolis Rose Act 2",
    0x939300fa: "Power Plant Rose Act 1",
    0x939300fb: "Power Plant Rose Act 2",
    0x939300fc: "Casino Park Rose Act 1",
    0x939300fd: "Casino Park Rose Act 2",
    0x939300fe: "Bingo Highway Rose Act 1",
    0x939300ff: "Bingo Highway Rose Act 2",
    0x93930100: "Rail Canyon Rose Act 1",
    0x93930101: "Rail Canyon Rose Act 2",
    0x93930102: "Bullet Station Rose Act 1",
    0x93930103: "Bullet Station Rose Act 2",
    0x93930104: "Frog Forest Rose Act 1",
    0x93930105: "Frog Forest Rose Act 2",
    0x93930106: "Lost Jungle Rose Act 1",
    0x93930107: "Lost Jungle Rose Act 2",
    0x93930108: "Hang Castle Rose Act 1",
    0x93930109: "Hang Castle Rose Act 2",
    0x9393010a: "Mystic Mansion Rose Act 1",
    0x9393010b: "Mystic Mansion Rose Act 2",
    0x9393010c: "Egg Fleet Rose Act 1",
    0x9393010d: "Egg Fleet Rose Act 2",
    0x9393010e: "Final Fortress Rose Act 1",
    0x9393010f: "Final Fortress Rose Act 2",
    0x93930110: "Egg Hawk Rose",
    0x93930112: "Team Fight 1 Rose",
    0x93930114: "Robot Carnival Rose",
    0x93930116: "Egg Albatross Rose",
    0x93930118: "Team Fight 2 Rose",
    0x9393011a: "Robot Storm Rose",
    0x9393011c: "Egg Emperor Rose",
    0x9393011e: "Seaside Hill Chaotix Act 1",
    0x9393011f: "Seaside Hill Chaotix Act 2",
    0x93930120: "Ocean Palace Chaotix Act 1",
    0x93930121: "Ocean Palace Chaotix Act 2",
    0x93930122: "Grand Metropolis Chaotix Act 1",
    0x93930123: "Grand Metropolis Chaotix Act 2",
    0x93930124: "Power Plant Chaotix Act 1",
    0x93930125: "Power Plant Chaotix Act 2",
    0x93930126: "Casino Park Chaotix Act 1",
    0x93930127: "Casino Park Chaotix Act 2",
    0x93930128: "Bingo Highway Chaotix Act 1",
    0x93930129: "Bingo Highway Chaotix Act 2",
    0x9393012a: "Rail Canyon Chaotix Act 1",
    0x9393012b: "Rail Canyon Chaotix Act 2",
    0x9393012c: "Bullet Station Chaotix Act 1",
    0x9393012d: "Bullet Station Chaotix Act 2",
    0x9393012e: "Frog Forest Chaotix Act 1",
    0x9393012f: "Frog Forest Chaotix Act 2",
    0x93930130: "Lost Jungle Chaotix Act 1",
    0x93930131: "Lost Jungle Chaotix Act 2",
    0x93930132: "Hang Castle Chaotix Act 1",
    0x93930133: "Hang Castle Chaotix Act 2",
    0x93930134: "Mystic Mansion Chaotix Act 1",
    0x93930135: "Mystic Mansion Chaotix Act 2",
    0x93930136: "Egg Fleet Chaotix Act 1",
    0x93930137: "Egg Fleet Chaotix Act 2",
    0x93930138: "Final Fortress Chaotix Act 1",
    0x93930139: "Final Fortress Chaotix Act 2",
    0x9393013a: "Egg Hawk Chaotix",
    0x9393013c: "Team Fight 1 Chaotix",
    0x9393013e: "Robot Carnival Chaotix",
    0x93930140: "Egg Albatross Chaotix",
    0x93930142: "Team Fight 2 Chaotix",
    0x93930144: "Robot Storm Chaotix",
    0x93930146: "Egg Emperor Chaotix",
    0x93930148: "Ocean Palace Emerald Stage",
    0x93930149: "Power Plant Emerald Stage",
    0x9393014a: "Bingo Highway Emerald Stage",
    0x9393014b: "Bullet Station Emerald Stage",
    0x9393014c: "Lost Jungle Emerald Stage",
    0x9393014d: "Mystic Mansion Emerald Stage",
    0x9393014e: "Final Fortress Emerald Stage",
    0x93930150: "Seaside Hill Dark Act 2 Enemies Killed: 1",
    0x93930151: "Seaside Hill Dark Act 2 Enemies Killed: 2",
    0x93930152: "Seaside Hill Dark Act 2 Enemies Killed: 3",
    0x93930153: "Seaside Hill Dark Act 2 Enemies Killed: 4",
    0x93930154: "Seaside Hill Dark Act 2 Enemies Killed: 5",
    0x93930155: "Seaside Hill Dark Act 2 Enemies Killed: 6",
    0x93930156: "Seaside Hill Dark Act 2 Enemies Killed: 7",
    0x93930157: "Seaside Hill Dark Act 2 Enemies Killed: 8",
    0x93930158: "Seaside Hill Dark Act 2 Enemies Killed: 9",
    0x93930159: "Seaside Hill Dark Act 2 Enemies Killed: 10",
    0x9393015a: "Seaside Hill Dark Act 2 Enemies Killed: 11",
    0x9393015b: "Seaside Hill Dark Act 2 Enemies Killed: 12",
    0x9393015c: "Seaside Hill Dark Act 2 Enemies Killed: 13",
    0x9393015d: "Seaside Hill Dark Act 2 Enemies Killed: 14",
    0x9393015e: "Seaside Hill Dark Act 2 Enemies Killed: 15",
    0x9393015f: "Seaside Hill Dark Act 2 Enemies Killed: 16",
    0x93930160: "Seaside Hill Dark Act 2 Enemies Killed: 17",
    0x93930161: "Seaside Hill Dark Act 2 Enemies Killed: 18",
    0x93930162: "Seaside Hill Dark Act 2 Enemies Killed: 19",
    0x93930163: "Seaside Hill Dark Act 2 Enemies Killed: 20",
    0x93930164: "Seaside Hill Dark Act 2 Enemies Killed: 21",
    0x93930165: "Seaside Hill Dark Act 2 Enemies Killed: 22",
    0x93930166: "Seaside Hill Dark Act 2 Enemies Killed: 23",
    0x93930167: "Seaside Hill Dark Act 2 Enemies Killed: 24",
    0x93930168: "Seaside Hill Dark Act 2 Enemies Killed: 25",
    0x93930169: "Seaside Hill Dark Act 2 Enemies Killed: 26",
    0x9393016a: "Seaside Hill Dark Act 2 Enemies Killed: 27",
    0x9393016b: "Seaside Hill Dark Act 2 Enemies Killed: 28",
    0x9393016c: "Seaside Hill Dark Act 2 Enemies Killed: 29",
    0x9393016d: "Seaside Hill Dark Act 2 Enemies Killed: 30",
    0x9393016e: "Seaside Hill Dark Act 2 Enemies Killed: 31",
    0x9393016f: "Seaside Hill Dark Act 2 Enemies Killed: 32",
    0x93930170: "Seaside Hill Dark Act 2 Enemies Killed: 33",
    0x93930171: "Seaside Hill Dark Act 2 Enemies Killed: 34",
    0x93930172: "Seaside Hill Dark Act 2 Enemies Killed: 35",
    0x93930173: "Seaside Hill Dark Act 2 Enemies Killed: 36",
    0x93930174: "Seaside Hill Dark Act 2 Enemies Killed: 37",
    0x93930175: "Seaside Hill Dark Act 2 Enemies Killed: 38",
    0x93930176: "Seaside Hill Dark Act 2 Enemies Killed: 39",
    0x93930177: "Seaside Hill Dark Act 2 Enemies Killed: 40",
    0x93930178: "Seaside Hill Dark Act 2 Enemies Killed: 41",
    0x93930179: "Seaside Hill Dark Act 2 Enemies Killed: 42",
    0x9393017a: "Seaside Hill Dark Act 2 Enemies Killed: 43",
    0x9393017b: "Seaside Hill Dark Act 2 Enemies Killed: 44",
    0x9393017c: "Seaside Hill Dark Act 2 Enemies Killed: 45",
    0x9393017d: "Seaside Hill Dark Act 2 Enemies Killed: 46",
    0x9393017e: "Seaside Hill Dark Act 2 Enemies Killed: 47",
    0x9393017f: "Seaside Hill Dark Act 2 Enemies Killed: 48",
    0x93930180: "Seaside Hill Dark Act 2 Enemies Killed: 49",
    0x93930181: "Seaside Hill Dark Act 2 Enemies Killed: 50",
    0x93930182: "Seaside Hill Dark Act 2 Enemies Killed: 51",
    0x93930183: "Seaside Hill Dark Act 2 Enemies Killed: 52",
    0x93930184: "Seaside Hill Dark Act 2 Enemies Killed: 53",
    0x93930185: "Seaside Hill Dark Act 2 Enemies Killed: 54",
    0x93930186: "Seaside Hill Dark Act 2 Enemies Killed: 55",
    0x93930187: "Seaside Hill Dark Act 2 Enemies Killed: 56",
    0x93930188: "Seaside Hill Dark Act 2 Enemies Killed: 57",
    0x93930189: "Seaside Hill Dark Act 2 Enemies Killed: 58",
    0x9393018a: "Seaside Hill Dark Act 2 Enemies Killed: 59",
    0x9393018b: "Seaside Hill Dark Act 2 Enemies Killed: 60",
    0x9393018c: "Seaside Hill Dark Act 2 Enemies Killed: 61",
    0x9393018d: "Seaside Hill Dark Act 2 Enemies Killed: 62",
    0x9393018e: "Seaside Hill Dark Act 2 Enemies Killed: 63",
    0x9393018f: "Seaside Hill Dark Act 2 Enemies Killed: 64",
    0x93930190: "Seaside Hill Dark Act 2 Enemies Killed: 65",
    0x93930191: "Seaside Hill Dark Act 2 Enemies Killed: 66",
    0x93930192: "Seaside Hill Dark Act 2 Enemies Killed: 67",
    0x93930193: "Seaside Hill Dark Act 2 Enemies Killed: 68",
    0x93930194: "Seaside Hill Dark Act 2 Enemies Killed: 69",
    0x93930195: "Seaside Hill Dark Act 2 Enemies Killed: 70",
    0x93930196: "Seaside Hill Dark Act 2 Enemies Killed: 71",
    0x93930197: "Seaside Hill Dark Act 2 Enemies Killed: 72",
    0x93930198: "Seaside Hill Dark Act 2 Enemies Killed: 73",
    0x93930199: "Seaside Hill Dark Act 2 Enemies Killed: 74",
    0x9393019a: "Seaside Hill Dark Act 2 Enemies Killed: 75",
    0x9393019b: "Seaside Hill Dark Act 2 Enemies Killed: 76",
    0x9393019c: "Seaside Hill Dark Act 2 Enemies Killed: 77",
    0x9393019d: "Seaside Hill Dark Act 2 Enemies Killed: 78",
    0x9393019e: "Seaside Hill Dark Act 2 Enemies Killed: 79",
    0x9393019f: "Seaside Hill Dark Act 2 Enemies Killed: 80",
    0x939301a0: "Seaside Hill Dark Act 2 Enemies Killed: 81",
    0x939301a1: "Seaside Hill Dark Act 2 Enemies Killed: 82",
    0x939301a2: "Seaside Hill Dark Act 2 Enemies Killed: 83",
    0x939301a3: "Seaside Hill Dark Act 2 Enemies Killed: 84",
    0x939301a4: "Seaside Hill Dark Act 2 Enemies Killed: 85",
    0x939301a5: "Seaside Hill Dark Act 2 Enemies Killed: 86",
    0x939301a6: "Seaside Hill Dark Act 2 Enemies Killed: 87",
    0x939301a7: "Seaside Hill Dark Act 2 Enemies Killed: 88",
    0x939301a8: "Seaside Hill Dark Act 2 Enemies Killed: 89",
    0x939301a9: "Seaside Hill Dark Act 2 Enemies Killed: 90",
    0x939301aa: "Seaside Hill Dark Act 2 Enemies Killed: 91",
    0x939301ab: "Seaside Hill Dark Act 2 Enemies Killed: 92",
    0x939301ac: "Seaside Hill Dark Act 2 Enemies Killed: 93",
    0x939301ad: "Seaside Hill Dark Act 2 Enemies Killed: 94",
    0x939301ae: "Seaside Hill Dark Act 2 Enemies Killed: 95",
    0x939301af: "Seaside Hill Dark Act 2 Enemies Killed: 96",
    0x939301b0: "Seaside Hill Dark Act 2 Enemies Killed: 97",
    0x939301b1: "Seaside Hill Dark Act 2 Enemies Killed: 98",
    0x939301b2: "Seaside Hill Dark Act 2 Enemies Killed: 99",
    0x939301b3: "Seaside Hill Dark Act 2 Enemies Killed: 100",
    0x939301b4: "Ocean Palace Dark Act 2 Enemies Killed: 1",
    0x939301b5: "Ocean Palace Dark Act 2 Enemies Killed: 2",
    0x939301b6: "Ocean Palace Dark Act 2 Enemies Killed: 3",
    0x939301b7: "Ocean Palace Dark Act 2 Enemies Killed: 4",
    0x939301b8: "Ocean Palace Dark Act 2 Enemies Killed: 5",
    0x939301b9: "Ocean Palace Dark Act 2 Enemies Killed: 6",
    0x939301ba: "Ocean Palace Dark Act 2 Enemies Killed: 7",
    0x939301bb: "Ocean Palace Dark Act 2 Enemies Killed: 8",
    0x939301bc: "Ocean Palace Dark Act 2 Enemies Killed: 9",
    0x939301bd: "Ocean Palace Dark Act 2 Enemies Killed: 10",
    0x939301be: "Ocean Palace Dark Act 2 Enemies Killed: 11",
    0x939301bf: "Ocean Palace Dark Act 2 Enemies Killed: 12",
    0x939301c0: "Ocean Palace Dark Act 2 Enemies Killed: 13",
    0x939301c1: "Ocean Palace Dark Act 2 Enemies Killed: 14",
    0x939301c2: "Ocean Palace Dark Act 2 Enemies Killed: 15",
    0x939301c3: "Ocean Palace Dark Act 2 Enemies Killed: 16",
    0x939301c4: "Ocean Palace Dark Act 2 Enemies Killed: 17",
    0x939301c5: "Ocean Palace Dark Act 2 Enemies Killed: 18",
    0x939301c6: "Ocean Palace Dark Act 2 Enemies Killed: 19",
    0x939301c7: "Ocean Palace Dark Act 2 Enemies Killed: 20",
    0x939301c8: "Ocean Palace Dark Act 2 Enemies Killed: 21",
    0x939301c9: "Ocean Palace Dark Act 2 Enemies Killed: 22",
    0x939301ca: "Ocean Palace Dark Act 2 Enemies Killed: 23",
    0x939301cb: "Ocean Palace Dark Act 2 Enemies Killed: 24",
    0x939301cc: "Ocean Palace Dark Act 2 Enemies Killed: 25",
    0x939301cd: "Ocean Palace Dark Act 2 Enemies Killed: 26",
    0x939301ce: "Ocean Palace Dark Act 2 Enemies Killed: 27",
    0x939301cf: "Ocean Palace Dark Act 2 Enemies Killed: 28",
    0x939301d0: "Ocean Palace Dark Act 2 Enemies Killed: 29",
    0x939301d1: "Ocean Palace Dark Act 2 Enemies Killed: 30",
    0x939301d2: "Ocean Palace Dark Act 2 Enemies Killed: 31",
    0x939301d3: "Ocean Palace Dark Act 2 Enemies Killed: 32",
    0x939301d4: "Ocean Palace Dark Act 2 Enemies Killed: 33",
    0x939301d5: "Ocean Palace Dark Act 2 Enemies Killed: 34",
    0x939301d6: "Ocean Palace Dark Act 2 Enemies Killed: 35",
    0x939301d7: "Ocean Palace Dark Act 2 Enemies Killed: 36",
    0x939301d8: "Ocean Palace Dark Act 2 Enemies Killed: 37",
    0x939301d9: "Ocean Palace Dark Act 2 Enemies Killed: 38",
    0x939301da: "Ocean Palace Dark Act 2 Enemies Killed: 39",
    0x939301db: "Ocean Palace Dark Act 2 Enemies Killed: 40",
    0x939301dc: "Ocean Palace Dark Act 2 Enemies Killed: 41",
    0x939301dd: "Ocean Palace Dark Act 2 Enemies Killed: 42",
    0x939301de: "Ocean Palace Dark Act 2 Enemies Killed: 43",
    0x939301df: "Ocean Palace Dark Act 2 Enemies Killed: 44",
    0x939301e0: "Ocean Palace Dark Act 2 Enemies Killed: 45",
    0x939301e1: "Ocean Palace Dark Act 2 Enemies Killed: 46",
    0x939301e2: "Ocean Palace Dark Act 2 Enemies Killed: 47",
    0x939301e3: "Ocean Palace Dark Act 2 Enemies Killed: 48",
    0x939301e4: "Ocean Palace Dark Act 2 Enemies Killed: 49",
    0x939301e5: "Ocean Palace Dark Act 2 Enemies Killed: 50",
    0x939301e6: "Ocean Palace Dark Act 2 Enemies Killed: 51",
    0x939301e7: "Ocean Palace Dark Act 2 Enemies Killed: 52",
    0x939301e8: "Ocean Palace Dark Act 2 Enemies Killed: 53",
    0x939301e9: "Ocean Palace Dark Act 2 Enemies Killed: 54",
    0x939301ea: "Ocean Palace Dark Act 2 Enemies Killed: 55",
    0x939301eb: "Ocean Palace Dark Act 2 Enemies Killed: 56",
    0x939301ec: "Ocean Palace Dark Act 2 Enemies Killed: 57",
    0x939301ed: "Ocean Palace Dark Act 2 Enemies Killed: 58",
    0x939301ee: "Ocean Palace Dark Act 2 Enemies Killed: 59",
    0x939301ef: "Ocean Palace Dark Act 2 Enemies Killed: 60",
    0x939301f0: "Ocean Palace Dark Act 2 Enemies Killed: 61",
    0x939301f1: "Ocean Palace Dark Act 2 Enemies Killed: 62",
    0x939301f2: "Ocean Palace Dark Act 2 Enemies Killed: 63",
    0x939301f3: "Ocean Palace Dark Act 2 Enemies Killed: 64",
    0x939301f4: "Ocean Palace Dark Act 2 Enemies Killed: 65",
    0x939301f5: "Ocean Palace Dark Act 2 Enemies Killed: 66",
    0x939301f6: "Ocean Palace Dark Act 2 Enemies Killed: 67",
    0x939301f7: "Ocean Palace Dark Act 2 Enemies Killed: 68",
    0x939301f8: "Ocean Palace Dark Act 2 Enemies Killed: 69",
    0x939301f9: "Ocean Palace Dark Act 2 Enemies Killed: 70",
    0x939301fa: "Ocean Palace Dark Act 2 Enemies Killed: 71",
    0x939301fb: "Ocean Palace Dark Act 2 Enemies Killed: 72",
    0x939301fc: "Ocean Palace Dark Act 2 Enemies Killed: 73",
    0x939301fd: "Ocean Palace Dark Act 2 Enemies Killed: 74",
    0x939301fe: "Ocean Palace Dark Act 2 Enemies Killed: 75",
    0x939301ff: "Ocean Palace Dark Act 2 Enemies Killed: 76",
    0x93930200: "Ocean Palace Dark Act 2 Enemies Killed: 77",
    0x93930201: "Ocean Palace Dark Act 2 Enemies Killed: 78",
    0x93930202: "Ocean Palace Dark Act 2 Enemies Killed: 79",
    0x93930203: "Ocean Palace Dark Act 2 Enemies Killed: 80",
    0x93930204: "Ocean Palace Dark Act 2 Enemies Killed: 81",
    0x93930205: "Ocean Palace Dark Act 2 Enemies Killed: 82",
    0x93930206: "Ocean Palace Dark Act 2 Enemies Killed: 83",
    0x93930207: "Ocean Palace Dark Act 2 Enemies Killed: 84",
    0x93930208: "Ocean Palace Dark Act 2 Enemies Killed: 85",
    0x93930209: "Ocean Palace Dark Act 2 Enemies Killed: 86",
    0x9393020a: "Ocean Palace Dark Act 2 Enemies Killed: 87",
    0x9393020b: "Ocean Palace Dark Act 2 Enemies Killed: 88",
    0x9393020c: "Ocean Palace Dark Act 2 Enemies Killed: 89",
    0x9393020d: "Ocean Palace Dark Act 2 Enemies Killed: 90",
    0x9393020e: "Ocean Palace Dark Act 2 Enemies Killed: 91",
    0x9393020f: "Ocean Palace Dark Act 2 Enemies Killed: 92",
    0x93930210: "Ocean Palace Dark Act 2 Enemies Killed: 93",
    0x93930211: "Ocean Palace Dark Act 2 Enemies Killed: 94",
    0x93930212: "Ocean Palace Dark Act 2 Enemies Killed: 95",
    0x93930213: "Ocean Palace Dark Act 2 Enemies Killed: 96",
    0x93930214: "Ocean Palace Dark Act 2 Enemies Killed: 97",
    0x93930215: "Ocean Palace Dark Act 2 Enemies Killed: 98",
    0x93930216: "Ocean Palace Dark Act 2 Enemies Killed: 99",
    0x93930217: "Ocean Palace Dark Act 2 Enemies Killed: 100",
    0x93930218: "Grand Metropolis Dark Act 2 Enemies Killed: 1",
    0x93930219: "Grand Metropolis Dark Act 2 Enemies Killed: 2",
    0x9393021a: "Grand Metropolis Dark Act 2 Enemies Killed: 3",
    0x9393021b: "Grand Metropolis Dark Act 2 Enemies Killed: 4",
    0x9393021c: "Grand Metropolis Dark Act 2 Enemies Killed: 5",
    0x9393021d: "Grand Metropolis Dark Act 2 Enemies Killed: 6",
    0x9393021e: "Grand Metropolis Dark Act 2 Enemies Killed: 7",
    0x9393021f: "Grand Metropolis Dark Act 2 Enemies Killed: 8",
    0x93930220: "Grand Metropolis Dark Act 2 Enemies Killed: 9",
    0x93930221: "Grand Metropolis Dark Act 2 Enemies Killed: 10",
    0x93930222: "Grand Metropolis Dark Act 2 Enemies Killed: 11",
    0x93930223: "Grand Metropolis Dark Act 2 Enemies Killed: 12",
    0x93930224: "Grand Metropolis Dark Act 2 Enemies Killed: 13",
    0x93930225: "Grand Metropolis Dark Act 2 Enemies Killed: 14",
    0x93930226: "Grand Metropolis Dark Act 2 Enemies Killed: 15",
    0x93930227: "Grand Metropolis Dark Act 2 Enemies Killed: 16",
    0x93930228: "Grand Metropolis Dark Act 2 Enemies Killed: 17",
    0x93930229: "Grand Metropolis Dark Act 2 Enemies Killed: 18",
    0x9393022a: "Grand Metropolis Dark Act 2 Enemies Killed: 19",
    0x9393022b: "Grand Metropolis Dark Act 2 Enemies Killed: 20",
    0x9393022c: "Grand Metropolis Dark Act 2 Enemies Killed: 21",
    0x9393022d: "Grand Metropolis Dark Act 2 Enemies Killed: 22",
    0x9393022e: "Grand Metropolis Dark Act 2 Enemies Killed: 23",
    0x9393022f: "Grand Metropolis Dark Act 2 Enemies Killed: 24",
    0x93930230: "Grand Metropolis Dark Act 2 Enemies Killed: 25",
    0x93930231: "Grand Metropolis Dark Act 2 Enemies Killed: 26",
    0x93930232: "Grand Metropolis Dark Act 2 Enemies Killed: 27",
    0x93930233: "Grand Metropolis Dark Act 2 Enemies Killed: 28",
    0x93930234: "Grand Metropolis Dark Act 2 Enemies Killed: 29",
    0x93930235: "Grand Metropolis Dark Act 2 Enemies Killed: 30",
    0x93930236: "Grand Metropolis Dark Act 2 Enemies Killed: 31",
    0x93930237: "Grand Metropolis Dark Act 2 Enemies Killed: 32",
    0x93930238: "Grand Metropolis Dark Act 2 Enemies Killed: 33",
    0x93930239: "Grand Metropolis Dark Act 2 Enemies Killed: 34",
    0x9393023a: "Grand Metropolis Dark Act 2 Enemies Killed: 35",
    0x9393023b: "Grand Metropolis Dark Act 2 Enemies Killed: 36",
    0x9393023c: "Grand Metropolis Dark Act 2 Enemies Killed: 37",
    0x9393023d: "Grand Metropolis Dark Act 2 Enemies Killed: 38",
    0x9393023e: "Grand Metropolis Dark Act 2 Enemies Killed: 39",
    0x9393023f: "Grand Metropolis Dark Act 2 Enemies Killed: 40",
    0x93930240: "Grand Metropolis Dark Act 2 Enemies Killed: 41",
    0x93930241: "Grand Metropolis Dark Act 2 Enemies Killed: 42",
    0x93930242: "Grand Metropolis Dark Act 2 Enemies Killed: 43",
    0x93930243: "Grand Metropolis Dark Act 2 Enemies Killed: 44",
    0x93930244: "Grand Metropolis Dark Act 2 Enemies Killed: 45",
    0x93930245: "Grand Metropolis Dark Act 2 Enemies Killed: 46",
    0x93930246: "Grand Metropolis Dark Act 2 Enemies Killed: 47",
    0x93930247: "Grand Metropolis Dark Act 2 Enemies Killed: 48",
    0x93930248: "Grand Metropolis Dark Act 2 Enemies Killed: 49",
    0x93930249: "Grand Metropolis Dark Act 2 Enemies Killed: 50",
    0x9393024a: "Grand Metropolis Dark Act 2 Enemies Killed: 51",
    0x9393024b: "Grand Metropolis Dark Act 2 Enemies Killed: 52",
    0x9393024c: "Grand Metropolis Dark Act 2 Enemies Killed: 53",
    0x9393024d: "Grand Metropolis Dark Act 2 Enemies Killed: 54",
    0x9393024e: "Grand Metropolis Dark Act 2 Enemies Killed: 55",
    0x9393024f: "Grand Metropolis Dark Act 2 Enemies Killed: 56",
    0x93930250: "Grand Metropolis Dark Act 2 Enemies Killed: 57",
    0x93930251: "Grand Metropolis Dark Act 2 Enemies Killed: 58",
    0x93930252: "Grand Metropolis Dark Act 2 Enemies Killed: 59",
    0x93930253: "Grand Metropolis Dark Act 2 Enemies Killed: 60",
    0x93930254: "Grand Metropolis Dark Act 2 Enemies Killed: 61",
    0x93930255: "Grand Metropolis Dark Act 2 Enemies Killed: 62",
    0x93930256: "Grand Metropolis Dark Act 2 Enemies Killed: 63",
    0x93930257: "Grand Metropolis Dark Act 2 Enemies Killed: 64",
    0x93930258: "Grand Metropolis Dark Act 2 Enemies Killed: 65",
    0x93930259: "Grand Metropolis Dark Act 2 Enemies Killed: 66",
    0x9393025a: "Grand Metropolis Dark Act 2 Enemies Killed: 67",
    0x9393025b: "Grand Metropolis Dark Act 2 Enemies Killed: 68",
    0x9393025c: "Grand Metropolis Dark Act 2 Enemies Killed: 69",
    0x9393025d: "Grand Metropolis Dark Act 2 Enemies Killed: 70",
    0x9393025e: "Grand Metropolis Dark Act 2 Enemies Killed: 71",
    0x9393025f: "Grand Metropolis Dark Act 2 Enemies Killed: 72",
    0x93930260: "Grand Metropolis Dark Act 2 Enemies Killed: 73",
    0x93930261: "Grand Metropolis Dark Act 2 Enemies Killed: 74",
    0x93930262: "Grand Metropolis Dark Act 2 Enemies Killed: 75",
    0x93930263: "Grand Metropolis Dark Act 2 Enemies Killed: 76",
    0x93930264: "Grand Metropolis Dark Act 2 Enemies Killed: 77",
    0x93930265: "Grand Metropolis Dark Act 2 Enemies Killed: 78",
    0x93930266: "Grand Metropolis Dark Act 2 Enemies Killed: 79",
    0x93930267: "Grand Metropolis Dark Act 2 Enemies Killed: 80",
    0x93930268: "Grand Metropolis Dark Act 2 Enemies Killed: 81",
    0x93930269: "Grand Metropolis Dark Act 2 Enemies Killed: 82",
    0x9393026a: "Grand Metropolis Dark Act 2 Enemies Killed: 83",
    0x9393026b: "Grand Metropolis Dark Act 2 Enemies Killed: 84",
    0x9393026c: "Grand Metropolis Dark Act 2 Enemies Killed: 85",
    0x9393026d: "Grand Metropolis Dark Act 2 Enemies Killed: 86",
    0x9393026e: "Grand Metropolis Dark Act 2 Enemies Killed: 87",
    0x9393026f: "Grand Metropolis Dark Act 2 Enemies Killed: 88",
    0x93930270: "Grand Metropolis Dark Act 2 Enemies Killed: 89",
    0x93930271: "Grand Metropolis Dark Act 2 Enemies Killed: 90",
    0x93930272: "Grand Metropolis Dark Act 2 Enemies Killed: 91",
    0x93930273: "Grand Metropolis Dark Act 2 Enemies Killed: 92",
    0x93930274: "Grand Metropolis Dark Act 2 Enemies Killed: 93",
    0x93930275: "Grand Metropolis Dark Act 2 Enemies Killed: 94",
    0x93930276: "Grand Metropolis Dark Act 2 Enemies Killed: 95",
    0x93930277: "Grand Metropolis Dark Act 2 Enemies Killed: 96",
    0x93930278: "Grand Metropolis Dark Act 2 Enemies Killed: 97",
    0x93930279: "Grand Metropolis Dark Act 2 Enemies Killed: 98",
    0x9393027a: "Grand Metropolis Dark Act 2 Enemies Killed: 99",
    0x9393027b: "Grand Metropolis Dark Act 2 Enemies Killed: 100",
    0x9393027c: "Power Plant Dark Act 2 Enemies Killed: 1",
    0x9393027d: "Power Plant Dark Act 2 Enemies Killed: 2",
    0x9393027e: "Power Plant Dark Act 2 Enemies Killed: 3",
    0x9393027f: "Power Plant Dark Act 2 Enemies Killed: 4",
    0x93930280: "Power Plant Dark Act 2 Enemies Killed: 5",
    0x93930281: "Power Plant Dark Act 2 Enemies Killed: 6",
    0x93930282: "Power Plant Dark Act 2 Enemies Killed: 7",
    0x93930283: "Power Plant Dark Act 2 Enemies Killed: 8",
    0x93930284: "Power Plant Dark Act 2 Enemies Killed: 9",
    0x93930285: "Power Plant Dark Act 2 Enemies Killed: 10",
    0x93930286: "Power Plant Dark Act 2 Enemies Killed: 11",
    0x93930287: "Power Plant Dark Act 2 Enemies Killed: 12",
    0x93930288: "Power Plant Dark Act 2 Enemies Killed: 13",
    0x93930289: "Power Plant Dark Act 2 Enemies Killed: 14",
    0x9393028a: "Power Plant Dark Act 2 Enemies Killed: 15",
    0x9393028b: "Power Plant Dark Act 2 Enemies Killed: 16",
    0x9393028c: "Power Plant Dark Act 2 Enemies Killed: 17",
    0x9393028d: "Power Plant Dark Act 2 Enemies Killed: 18",
    0x9393028e: "Power Plant Dark Act 2 Enemies Killed: 19",
    0x9393028f: "Power Plant Dark Act 2 Enemies Killed: 20",
    0x93930290: "Power Plant Dark Act 2 Enemies Killed: 21",
    0x93930291: "Power Plant Dark Act 2 Enemies Killed: 22",
    0x93930292: "Power Plant Dark Act 2 Enemies Killed: 23",
    0x93930293: "Power Plant Dark Act 2 Enemies Killed: 24",
    0x93930294: "Power Plant Dark Act 2 Enemies Killed: 25",
    0x93930295: "Power Plant Dark Act 2 Enemies Killed: 26",
    0x93930296: "Power Plant Dark Act 2 Enemies Killed: 27",
    0x93930297: "Power Plant Dark Act 2 Enemies Killed: 28",
    0x93930298: "Power Plant Dark Act 2 Enemies Killed: 29",
    0x93930299: "Power Plant Dark Act 2 Enemies Killed: 30",
    0x9393029a: "Power Plant Dark Act 2 Enemies Killed: 31",
    0x9393029b: "Power Plant Dark Act 2 Enemies Killed: 32",
    0x9393029c: "Power Plant Dark Act 2 Enemies Killed: 33",
    0x9393029d: "Power Plant Dark Act 2 Enemies Killed: 34",
    0x9393029e: "Power Plant Dark Act 2 Enemies Killed: 35",
    0x9393029f: "Power Plant Dark Act 2 Enemies Killed: 36",
    0x939302a0: "Power Plant Dark Act 2 Enemies Killed: 37",
    0x939302a1: "Power Plant Dark Act 2 Enemies Killed: 38",
    0x939302a2: "Power Plant Dark Act 2 Enemies Killed: 39",
    0x939302a3: "Power Plant Dark Act 2 Enemies Killed: 40",
    0x939302a4: "Power Plant Dark Act 2 Enemies Killed: 41",
    0x939302a5: "Power Plant Dark Act 2 Enemies Killed: 42",
    0x939302a6: "Power Plant Dark Act 2 Enemies Killed: 43",
    0x939302a7: "Power Plant Dark Act 2 Enemies Killed: 44",
    0x939302a8: "Power Plant Dark Act 2 Enemies Killed: 45",
    0x939302a9: "Power Plant Dark Act 2 Enemies Killed: 46",
    0x939302aa: "Power Plant Dark Act 2 Enemies Killed: 47",
    0x939302ab: "Power Plant Dark Act 2 Enemies Killed: 48",
    0x939302ac: "Power Plant Dark Act 2 Enemies Killed: 49",
    0x939302ad: "Power Plant Dark Act 2 Enemies Killed: 50",
    0x939302ae: "Power Plant Dark Act 2 Enemies Killed: 51",
    0x939302af: "Power Plant Dark Act 2 Enemies Killed: 52",
    0x939302b0: "Power Plant Dark Act 2 Enemies Killed: 53",
    0x939302b1: "Power Plant Dark Act 2 Enemies Killed: 54",
    0x939302b2: "Power Plant Dark Act 2 Enemies Killed: 55",
    0x939302b3: "Power Plant Dark Act 2 Enemies Killed: 56",
    0x939302b4: "Power Plant Dark Act 2 Enemies Killed: 57",
    0x939302b5: "Power Plant Dark Act 2 Enemies Killed: 58",
    0x939302b6: "Power Plant Dark Act 2 Enemies Killed: 59",
    0x939302b7: "Power Plant Dark Act 2 Enemies Killed: 60",
    0x939302b8: "Power Plant Dark Act 2 Enemies Killed: 61",
    0x939302b9: "Power Plant Dark Act 2 Enemies Killed: 62",
    0x939302ba: "Power Plant Dark Act 2 Enemies Killed: 63",
    0x939302bb: "Power Plant Dark Act 2 Enemies Killed: 64",
    0x939302bc: "Power Plant Dark Act 2 Enemies Killed: 65",
    0x939302bd: "Power Plant Dark Act 2 Enemies Killed: 66",
    0x939302be: "Power Plant Dark Act 2 Enemies Killed: 67",
    0x939302bf: "Power Plant Dark Act 2 Enemies Killed: 68",
    0x939302c0: "Power Plant Dark Act 2 Enemies Killed: 69",
    0x939302c1: "Power Plant Dark Act 2 Enemies Killed: 70",
    0x939302c2: "Power Plant Dark Act 2 Enemies Killed: 71",
    0x939302c3: "Power Plant Dark Act 2 Enemies Killed: 72",
    0x939302c4: "Power Plant Dark Act 2 Enemies Killed: 73",
    0x939302c5: "Power Plant Dark Act 2 Enemies Killed: 74",
    0x939302c6: "Power Plant Dark Act 2 Enemies Killed: 75",
    0x939302c7: "Power Plant Dark Act 2 Enemies Killed: 76",
    0x939302c8: "Power Plant Dark Act 2 Enemies Killed: 77",
    0x939302c9: "Power Plant Dark Act 2 Enemies Killed: 78",
    0x939302ca: "Power Plant Dark Act 2 Enemies Killed: 79",
    0x939302cb: "Power Plant Dark Act 2 Enemies Killed: 80",
    0x939302cc: "Power Plant Dark Act 2 Enemies Killed: 81",
    0x939302cd: "Power Plant Dark Act 2 Enemies Killed: 82",
    0x939302ce: "Power Plant Dark Act 2 Enemies Killed: 83",
    0x939302cf: "Power Plant Dark Act 2 Enemies Killed: 84",
    0x939302d0: "Power Plant Dark Act 2 Enemies Killed: 85",
    0x939302d1: "Power Plant Dark Act 2 Enemies Killed: 86",
    0x939302d2: "Power Plant Dark Act 2 Enemies Killed: 87",
    0x939302d3: "Power Plant Dark Act 2 Enemies Killed: 88",
    0x939302d4: "Power Plant Dark Act 2 Enemies Killed: 89",
    0x939302d5: "Power Plant Dark Act 2 Enemies Killed: 90",
    0x939302d6: "Power Plant Dark Act 2 Enemies Killed: 91",
    0x939302d7: "Power Plant Dark Act 2 Enemies Killed: 92",
    0x939302d8: "Power Plant Dark Act 2 Enemies Killed: 93",
    0x939302d9: "Power Plant Dark Act 2 Enemies Killed: 94",
    0x939302da: "Power Plant Dark Act 2 Enemies Killed: 95",
    0x939302db: "Power Plant Dark Act 2 Enemies Killed: 96",
    0x939302dc: "Power Plant Dark Act 2 Enemies Killed: 97",
    0x939302dd: "Power Plant Dark Act 2 Enemies Killed: 98",
    0x939302de: "Power Plant Dark Act 2 Enemies Killed: 99",
    0x939302df: "Power Plant Dark Act 2 Enemies Killed: 100",
    0x939302e0: "Casino Park Dark Act 2 Enemies Killed: 1",
    0x939302e1: "Casino Park Dark Act 2 Enemies Killed: 2",
    0x939302e2: "Casino Park Dark Act 2 Enemies Killed: 3",
    0x939302e3: "Casino Park Dark Act 2 Enemies Killed: 4",
    0x939302e4: "Casino Park Dark Act 2 Enemies Killed: 5",
    0x939302e5: "Casino Park Dark Act 2 Enemies Killed: 6",
    0x939302e6: "Casino Park Dark Act 2 Enemies Killed: 7",
    0x939302e7: "Casino Park Dark Act 2 Enemies Killed: 8",
    0x939302e8: "Casino Park Dark Act 2 Enemies Killed: 9",
    0x939302e9: "Casino Park Dark Act 2 Enemies Killed: 10",
    0x939302ea: "Casino Park Dark Act 2 Enemies Killed: 11",
    0x939302eb: "Casino Park Dark Act 2 Enemies Killed: 12",
    0x939302ec: "Casino Park Dark Act 2 Enemies Killed: 13",
    0x939302ed: "Casino Park Dark Act 2 Enemies Killed: 14",
    0x939302ee: "Casino Park Dark Act 2 Enemies Killed: 15",
    0x939302ef: "Casino Park Dark Act 2 Enemies Killed: 16",
    0x939302f0: "Casino Park Dark Act 2 Enemies Killed: 17",
    0x939302f1: "Casino Park Dark Act 2 Enemies Killed: 18",
    0x939302f2: "Casino Park Dark Act 2 Enemies Killed: 19",
    0x939302f3: "Casino Park Dark Act 2 Enemies Killed: 20",
    0x939302f4: "Casino Park Dark Act 2 Enemies Killed: 21",
    0x939302f5: "Casino Park Dark Act 2 Enemies Killed: 22",
    0x939302f6: "Casino Park Dark Act 2 Enemies Killed: 23",
    0x939302f7: "Casino Park Dark Act 2 Enemies Killed: 24",
    0x939302f8: "Casino Park Dark Act 2 Enemies Killed: 25",
    0x939302f9: "Casino Park Dark Act 2 Enemies Killed: 26",
    0x939302fa: "Casino Park Dark Act 2 Enemies Killed: 27",
    0x939302fb: "Casino Park Dark Act 2 Enemies Killed: 28",
    0x939302fc: "Casino Park Dark Act 2 Enemies Killed: 29",
    0x939302fd: "Casino Park Dark Act 2 Enemies Killed: 30",
    0x939302fe: "Casino Park Dark Act 2 Enemies Killed: 31",
    0x939302ff: "Casino Park Dark Act 2 Enemies Killed: 32",
    0x93930300: "Casino Park Dark Act 2 Enemies Killed: 33",
    0x93930301: "Casino Park Dark Act 2 Enemies Killed: 34",
    0x93930302: "Casino Park Dark Act 2 Enemies Killed: 35",
    0x93930303: "Casino Park Dark Act 2 Enemies Killed: 36",
    0x93930304: "Casino Park Dark Act 2 Enemies Killed: 37",
    0x93930305: "Casino Park Dark Act 2 Enemies Killed: 38",
    0x93930306: "Casino Park Dark Act 2 Enemies Killed: 39",
    0x93930307: "Casino Park Dark Act 2 Enemies Killed: 40",
    0x93930308: "Casino Park Dark Act 2 Enemies Killed: 41",
    0x93930309: "Casino Park Dark Act 2 Enemies Killed: 42",
    0x9393030a: "Casino Park Dark Act 2 Enemies Killed: 43",
    0x9393030b: "Casino Park Dark Act 2 Enemies Killed: 44",
    0x9393030c: "Casino Park Dark Act 2 Enemies Killed: 45",
    0x9393030d: "Casino Park Dark Act 2 Enemies Killed: 46",
    0x9393030e: "Casino Park Dark Act 2 Enemies Killed: 47",
    0x9393030f: "Casino Park Dark Act 2 Enemies Killed: 48",
    0x93930310: "Casino Park Dark Act 2 Enemies Killed: 49",
    0x93930311: "Casino Park Dark Act 2 Enemies Killed: 50",
    0x93930312: "Casino Park Dark Act 2 Enemies Killed: 51",
    0x93930313: "Casino Park Dark Act 2 Enemies Killed: 52",
    0x93930314: "Casino Park Dark Act 2 Enemies Killed: 53",
    0x93930315: "Casino Park Dark Act 2 Enemies Killed: 54",
    0x93930316: "Casino Park Dark Act 2 Enemies Killed: 55",
    0x93930317: "Casino Park Dark Act 2 Enemies Killed: 56",
    0x93930318: "Casino Park Dark Act 2 Enemies Killed: 57",
    0x93930319: "Casino Park Dark Act 2 Enemies Killed: 58",
    0x9393031a: "Casino Park Dark Act 2 Enemies Killed: 59",
    0x9393031b: "Casino Park Dark Act 2 Enemies Killed: 60",
    0x9393031c: "Casino Park Dark Act 2 Enemies Killed: 61",
    0x9393031d: "Casino Park Dark Act 2 Enemies Killed: 62",
    0x9393031e: "Casino Park Dark Act 2 Enemies Killed: 63",
    0x9393031f: "Casino Park Dark Act 2 Enemies Killed: 64",
    0x93930320: "Casino Park Dark Act 2 Enemies Killed: 65",
    0x93930321: "Casino Park Dark Act 2 Enemies Killed: 66",
    0x93930322: "Casino Park Dark Act 2 Enemies Killed: 67",
    0x93930323: "Casino Park Dark Act 2 Enemies Killed: 68",
    0x93930324: "Casino Park Dark Act 2 Enemies Killed: 69",
    0x93930325: "Casino Park Dark Act 2 Enemies Killed: 70",
    0x93930326: "Casino Park Dark Act 2 Enemies Killed: 71",
    0x93930327: "Casino Park Dark Act 2 Enemies Killed: 72",
    0x93930328: "Casino Park Dark Act 2 Enemies Killed: 73",
    0x93930329: "Casino Park Dark Act 2 Enemies Killed: 74",
    0x9393032a: "Casino Park Dark Act 2 Enemies Killed: 75",
    0x9393032b: "Casino Park Dark Act 2 Enemies Killed: 76",
    0x9393032c: "Casino Park Dark Act 2 Enemies Killed: 77",
    0x9393032d: "Casino Park Dark Act 2 Enemies Killed: 78",
    0x9393032e: "Casino Park Dark Act 2 Enemies Killed: 79",
    0x9393032f: "Casino Park Dark Act 2 Enemies Killed: 80",
    0x93930330: "Casino Park Dark Act 2 Enemies Killed: 81",
    0x93930331: "Casino Park Dark Act 2 Enemies Killed: 82",
    0x93930332: "Casino Park Dark Act 2 Enemies Killed: 83",
    0x93930333: "Casino Park Dark Act 2 Enemies Killed: 84",
    0x93930334: "Casino Park Dark Act 2 Enemies Killed: 85",
    0x93930335: "Casino Park Dark Act 2 Enemies Killed: 86",
    0x93930336: "Casino Park Dark Act 2 Enemies Killed: 87",
    0x93930337: "Casino Park Dark Act 2 Enemies Killed: 88",
    0x93930338: "Casino Park Dark Act 2 Enemies Killed: 89",
    0x93930339: "Casino Park Dark Act 2 Enemies Killed: 90",
    0x9393033a: "Casino Park Dark Act 2 Enemies Killed: 91",
    0x9393033b: "Casino Park Dark Act 2 Enemies Killed: 92",
    0x9393033c: "Casino Park Dark Act 2 Enemies Killed: 93",
    0x9393033d: "Casino Park Dark Act 2 Enemies Killed: 94",
    0x9393033e: "Casino Park Dark Act 2 Enemies Killed: 95",
    0x9393033f: "Casino Park Dark Act 2 Enemies Killed: 96",
    0x93930340: "Casino Park Dark Act 2 Enemies Killed: 97",
    0x93930341: "Casino Park Dark Act 2 Enemies Killed: 98",
    0x93930342: "Casino Park Dark Act 2 Enemies Killed: 99",
    0x93930343: "Casino Park Dark Act 2 Enemies Killed: 100",
    0x93930344: "Bingo Highway Dark Act 2 Enemies Killed: 1",
    0x93930345: "Bingo Highway Dark Act 2 Enemies Killed: 2",
    0x93930346: "Bingo Highway Dark Act 2 Enemies Killed: 3",
    0x93930347: "Bingo Highway Dark Act 2 Enemies Killed: 4",
    0x93930348: "Bingo Highway Dark Act 2 Enemies Killed: 5",
    0x93930349: "Bingo Highway Dark Act 2 Enemies Killed: 6",
    0x9393034a: "Bingo Highway Dark Act 2 Enemies Killed: 7",
    0x9393034b: "Bingo Highway Dark Act 2 Enemies Killed: 8",
    0x9393034c: "Bingo Highway Dark Act 2 Enemies Killed: 9",
    0x9393034d: "Bingo Highway Dark Act 2 Enemies Killed: 10",
    0x9393034e: "Bingo Highway Dark Act 2 Enemies Killed: 11",
    0x9393034f: "Bingo Highway Dark Act 2 Enemies Killed: 12",
    0x93930350: "Bingo Highway Dark Act 2 Enemies Killed: 13",
    0x93930351: "Bingo Highway Dark Act 2 Enemies Killed: 14",
    0x93930352: "Bingo Highway Dark Act 2 Enemies Killed: 15",
    0x93930353: "Bingo Highway Dark Act 2 Enemies Killed: 16",
    0x93930354: "Bingo Highway Dark Act 2 Enemies Killed: 17",
    0x93930355: "Bingo Highway Dark Act 2 Enemies Killed: 18",
    0x93930356: "Bingo Highway Dark Act 2 Enemies Killed: 19",
    0x93930357: "Bingo Highway Dark Act 2 Enemies Killed: 20",
    0x93930358: "Bingo Highway Dark Act 2 Enemies Killed: 21",
    0x93930359: "Bingo Highway Dark Act 2 Enemies Killed: 22",
    0x9393035a: "Bingo Highway Dark Act 2 Enemies Killed: 23",
    0x9393035b: "Bingo Highway Dark Act 2 Enemies Killed: 24",
    0x9393035c: "Bingo Highway Dark Act 2 Enemies Killed: 25",
    0x9393035d: "Bingo Highway Dark Act 2 Enemies Killed: 26",
    0x9393035e: "Bingo Highway Dark Act 2 Enemies Killed: 27",
    0x9393035f: "Bingo Highway Dark Act 2 Enemies Killed: 28",
    0x93930360: "Bingo Highway Dark Act 2 Enemies Killed: 29",
    0x93930361: "Bingo Highway Dark Act 2 Enemies Killed: 30",
    0x93930362: "Bingo Highway Dark Act 2 Enemies Killed: 31",
    0x93930363: "Bingo Highway Dark Act 2 Enemies Killed: 32",
    0x93930364: "Bingo Highway Dark Act 2 Enemies Killed: 33",
    0x93930365: "Bingo Highway Dark Act 2 Enemies Killed: 34",
    0x93930366: "Bingo Highway Dark Act 2 Enemies Killed: 35",
    0x93930367: "Bingo Highway Dark Act 2 Enemies Killed: 36",
    0x93930368: "Bingo Highway Dark Act 2 Enemies Killed: 37",
    0x93930369: "Bingo Highway Dark Act 2 Enemies Killed: 38",
    0x9393036a: "Bingo Highway Dark Act 2 Enemies Killed: 39",
    0x9393036b: "Bingo Highway Dark Act 2 Enemies Killed: 40",
    0x9393036c: "Bingo Highway Dark Act 2 Enemies Killed: 41",
    0x9393036d: "Bingo Highway Dark Act 2 Enemies Killed: 42",
    0x9393036e: "Bingo Highway Dark Act 2 Enemies Killed: 43",
    0x9393036f: "Bingo Highway Dark Act 2 Enemies Killed: 44",
    0x93930370: "Bingo Highway Dark Act 2 Enemies Killed: 45",
    0x93930371: "Bingo Highway Dark Act 2 Enemies Killed: 46",
    0x93930372: "Bingo Highway Dark Act 2 Enemies Killed: 47",
    0x93930373: "Bingo Highway Dark Act 2 Enemies Killed: 48",
    0x93930374: "Bingo Highway Dark Act 2 Enemies Killed: 49",
    0x93930375: "Bingo Highway Dark Act 2 Enemies Killed: 50",
    0x93930376: "Bingo Highway Dark Act 2 Enemies Killed: 51",
    0x93930377: "Bingo Highway Dark Act 2 Enemies Killed: 52",
    0x93930378: "Bingo Highway Dark Act 2 Enemies Killed: 53",
    0x93930379: "Bingo Highway Dark Act 2 Enemies Killed: 54",
    0x9393037a: "Bingo Highway Dark Act 2 Enemies Killed: 55",
    0x9393037b: "Bingo Highway Dark Act 2 Enemies Killed: 56",
    0x9393037c: "Bingo Highway Dark Act 2 Enemies Killed: 57",
    0x9393037d: "Bingo Highway Dark Act 2 Enemies Killed: 58",
    0x9393037e: "Bingo Highway Dark Act 2 Enemies Killed: 59",
    0x9393037f: "Bingo Highway Dark Act 2 Enemies Killed: 60",
    0x93930380: "Bingo Highway Dark Act 2 Enemies Killed: 61",
    0x93930381: "Bingo Highway Dark Act 2 Enemies Killed: 62",
    0x93930382: "Bingo Highway Dark Act 2 Enemies Killed: 63",
    0x93930383: "Bingo Highway Dark Act 2 Enemies Killed: 64",
    0x93930384: "Bingo Highway Dark Act 2 Enemies Killed: 65",
    0x93930385: "Bingo Highway Dark Act 2 Enemies Killed: 66",
    0x93930386: "Bingo Highway Dark Act 2 Enemies Killed: 67",
    0x93930387: "Bingo Highway Dark Act 2 Enemies Killed: 68",
    0x93930388: "Bingo Highway Dark Act 2 Enemies Killed: 69",
    0x93930389: "Bingo Highway Dark Act 2 Enemies Killed: 70",
    0x9393038a: "Bingo Highway Dark Act 2 Enemies Killed: 71",
    0x9393038b: "Bingo Highway Dark Act 2 Enemies Killed: 72",
    0x9393038c: "Bingo Highway Dark Act 2 Enemies Killed: 73",
    0x9393038d: "Bingo Highway Dark Act 2 Enemies Killed: 74",
    0x9393038e: "Bingo Highway Dark Act 2 Enemies Killed: 75",
    0x9393038f: "Bingo Highway Dark Act 2 Enemies Killed: 76",
    0x93930390: "Bingo Highway Dark Act 2 Enemies Killed: 77",
    0x93930391: "Bingo Highway Dark Act 2 Enemies Killed: 78",
    0x93930392: "Bingo Highway Dark Act 2 Enemies Killed: 79",
    0x93930393: "Bingo Highway Dark Act 2 Enemies Killed: 80",
    0x93930394: "Bingo Highway Dark Act 2 Enemies Killed: 81",
    0x93930395: "Bingo Highway Dark Act 2 Enemies Killed: 82",
    0x93930396: "Bingo Highway Dark Act 2 Enemies Killed: 83",
    0x93930397: "Bingo Highway Dark Act 2 Enemies Killed: 84",
    0x93930398: "Bingo Highway Dark Act 2 Enemies Killed: 85",
    0x93930399: "Bingo Highway Dark Act 2 Enemies Killed: 86",
    0x9393039a: "Bingo Highway Dark Act 2 Enemies Killed: 87",
    0x9393039b: "Bingo Highway Dark Act 2 Enemies Killed: 88",
    0x9393039c: "Bingo Highway Dark Act 2 Enemies Killed: 89",
    0x9393039d: "Bingo Highway Dark Act 2 Enemies Killed: 90",
    0x9393039e: "Bingo Highway Dark Act 2 Enemies Killed: 91",
    0x9393039f: "Bingo Highway Dark Act 2 Enemies Killed: 92",
    0x939303a0: "Bingo Highway Dark Act 2 Enemies Killed: 93",
    0x939303a1: "Bingo Highway Dark Act 2 Enemies Killed: 94",
    0x939303a2: "Bingo Highway Dark Act 2 Enemies Killed: 95",
    0x939303a3: "Bingo Highway Dark Act 2 Enemies Killed: 96",
    0x939303a4: "Bingo Highway Dark Act 2 Enemies Killed: 97",
    0x939303a5: "Bingo Highway Dark Act 2 Enemies Killed: 98",
    0x939303a6: "Bingo Highway Dark Act 2 Enemies Killed: 99",
    0x939303a7: "Bingo Highway Dark Act 2 Enemies Killed: 100",
    0x939303a8: "Rail Canyon Dark Act 2 Enemies Killed: 1",
    0x939303a9: "Rail Canyon Dark Act 2 Enemies Killed: 2",
    0x939303aa: "Rail Canyon Dark Act 2 Enemies Killed: 3",
    0x939303ab: "Rail Canyon Dark Act 2 Enemies Killed: 4",
    0x939303ac: "Rail Canyon Dark Act 2 Enemies Killed: 5",
    0x939303ad: "Rail Canyon Dark Act 2 Enemies Killed: 6",
    0x939303ae: "Rail Canyon Dark Act 2 Enemies Killed: 7",
    0x939303af: "Rail Canyon Dark Act 2 Enemies Killed: 8",
    0x939303b0: "Rail Canyon Dark Act 2 Enemies Killed: 9",
    0x939303b1: "Rail Canyon Dark Act 2 Enemies Killed: 10",
    0x939303b2: "Rail Canyon Dark Act 2 Enemies Killed: 11",
    0x939303b3: "Rail Canyon Dark Act 2 Enemies Killed: 12",
    0x939303b4: "Rail Canyon Dark Act 2 Enemies Killed: 13",
    0x939303b5: "Rail Canyon Dark Act 2 Enemies Killed: 14",
    0x939303b6: "Rail Canyon Dark Act 2 Enemies Killed: 15",
    0x939303b7: "Rail Canyon Dark Act 2 Enemies Killed: 16",
    0x939303b8: "Rail Canyon Dark Act 2 Enemies Killed: 17",
    0x939303b9: "Rail Canyon Dark Act 2 Enemies Killed: 18",
    0x939303ba: "Rail Canyon Dark Act 2 Enemies Killed: 19",
    0x939303bb: "Rail Canyon Dark Act 2 Enemies Killed: 20",
    0x939303bc: "Rail Canyon Dark Act 2 Enemies Killed: 21",
    0x939303bd: "Rail Canyon Dark Act 2 Enemies Killed: 22",
    0x939303be: "Rail Canyon Dark Act 2 Enemies Killed: 23",
    0x939303bf: "Rail Canyon Dark Act 2 Enemies Killed: 24",
    0x939303c0: "Rail Canyon Dark Act 2 Enemies Killed: 25",
    0x939303c1: "Rail Canyon Dark Act 2 Enemies Killed: 26",
    0x939303c2: "Rail Canyon Dark Act 2 Enemies Killed: 27",
    0x939303c3: "Rail Canyon Dark Act 2 Enemies Killed: 28",
    0x939303c4: "Rail Canyon Dark Act 2 Enemies Killed: 29",
    0x939303c5: "Rail Canyon Dark Act 2 Enemies Killed: 30",
    0x939303c6: "Rail Canyon Dark Act 2 Enemies Killed: 31",
    0x939303c7: "Rail Canyon Dark Act 2 Enemies Killed: 32",
    0x939303c8: "Rail Canyon Dark Act 2 Enemies Killed: 33",
    0x939303c9: "Rail Canyon Dark Act 2 Enemies Killed: 34",
    0x939303ca: "Rail Canyon Dark Act 2 Enemies Killed: 35",
    0x939303cb: "Rail Canyon Dark Act 2 Enemies Killed: 36",
    0x939303cc: "Rail Canyon Dark Act 2 Enemies Killed: 37",
    0x939303cd: "Rail Canyon Dark Act 2 Enemies Killed: 38",
    0x939303ce: "Rail Canyon Dark Act 2 Enemies Killed: 39",
    0x939303cf: "Rail Canyon Dark Act 2 Enemies Killed: 40",
    0x939303d0: "Rail Canyon Dark Act 2 Enemies Killed: 41",
    0x939303d1: "Rail Canyon Dark Act 2 Enemies Killed: 42",
    0x939303d2: "Rail Canyon Dark Act 2 Enemies Killed: 43",
    0x939303d3: "Rail Canyon Dark Act 2 Enemies Killed: 44",
    0x939303d4: "Rail Canyon Dark Act 2 Enemies Killed: 45",
    0x939303d5: "Rail Canyon Dark Act 2 Enemies Killed: 46",
    0x939303d6: "Rail Canyon Dark Act 2 Enemies Killed: 47",
    0x939303d7: "Rail Canyon Dark Act 2 Enemies Killed: 48",
    0x939303d8: "Rail Canyon Dark Act 2 Enemies Killed: 49",
    0x939303d9: "Rail Canyon Dark Act 2 Enemies Killed: 50",
    0x939303da: "Rail Canyon Dark Act 2 Enemies Killed: 51",
    0x939303db: "Rail Canyon Dark Act 2 Enemies Killed: 52",
    0x939303dc: "Rail Canyon Dark Act 2 Enemies Killed: 53",
    0x939303dd: "Rail Canyon Dark Act 2 Enemies Killed: 54",
    0x939303de: "Rail Canyon Dark Act 2 Enemies Killed: 55",
    0x939303df: "Rail Canyon Dark Act 2 Enemies Killed: 56",
    0x939303e0: "Rail Canyon Dark Act 2 Enemies Killed: 57",
    0x939303e1: "Rail Canyon Dark Act 2 Enemies Killed: 58",
    0x939303e2: "Rail Canyon Dark Act 2 Enemies Killed: 59",
    0x939303e3: "Rail Canyon Dark Act 2 Enemies Killed: 60",
    0x939303e4: "Rail Canyon Dark Act 2 Enemies Killed: 61",
    0x939303e5: "Rail Canyon Dark Act 2 Enemies Killed: 62",
    0x939303e6: "Rail Canyon Dark Act 2 Enemies Killed: 63",
    0x939303e7: "Rail Canyon Dark Act 2 Enemies Killed: 64",
    0x939303e8: "Rail Canyon Dark Act 2 Enemies Killed: 65",
    0x939303e9: "Rail Canyon Dark Act 2 Enemies Killed: 66",
    0x939303ea: "Rail Canyon Dark Act 2 Enemies Killed: 67",
    0x939303eb: "Rail Canyon Dark Act 2 Enemies Killed: 68",
    0x939303ec: "Rail Canyon Dark Act 2 Enemies Killed: 69",
    0x939303ed: "Rail Canyon Dark Act 2 Enemies Killed: 70",
    0x939303ee: "Rail Canyon Dark Act 2 Enemies Killed: 71",
    0x939303ef: "Rail Canyon Dark Act 2 Enemies Killed: 72",
    0x939303f0: "Rail Canyon Dark Act 2 Enemies Killed: 73",
    0x939303f1: "Rail Canyon Dark Act 2 Enemies Killed: 74",
    0x939303f2: "Rail Canyon Dark Act 2 Enemies Killed: 75",
    0x939303f3: "Rail Canyon Dark Act 2 Enemies Killed: 76",
    0x939303f4: "Rail Canyon Dark Act 2 Enemies Killed: 77",
    0x939303f5: "Rail Canyon Dark Act 2 Enemies Killed: 78",
    0x939303f6: "Rail Canyon Dark Act 2 Enemies Killed: 79",
    0x939303f7: "Rail Canyon Dark Act 2 Enemies Killed: 80",
    0x939303f8: "Rail Canyon Dark Act 2 Enemies Killed: 81",
    0x939303f9: "Rail Canyon Dark Act 2 Enemies Killed: 82",
    0x939303fa: "Rail Canyon Dark Act 2 Enemies Killed: 83",
    0x939303fb: "Rail Canyon Dark Act 2 Enemies Killed: 84",
    0x939303fc: "Rail Canyon Dark Act 2 Enemies Killed: 85",
    0x939303fd: "Rail Canyon Dark Act 2 Enemies Killed: 86",
    0x939303fe: "Rail Canyon Dark Act 2 Enemies Killed: 87",
    0x939303ff: "Rail Canyon Dark Act 2 Enemies Killed: 88",
    0x93930400: "Rail Canyon Dark Act 2 Enemies Killed: 89",
    0x93930401: "Rail Canyon Dark Act 2 Enemies Killed: 90",
    0x93930402: "Rail Canyon Dark Act 2 Enemies Killed: 91",
    0x93930403: "Rail Canyon Dark Act 2 Enemies Killed: 92",
    0x93930404: "Rail Canyon Dark Act 2 Enemies Killed: 93",
    0x93930405: "Rail Canyon Dark Act 2 Enemies Killed: 94",
    0x93930406: "Rail Canyon Dark Act 2 Enemies Killed: 95",
    0x93930407: "Rail Canyon Dark Act 2 Enemies Killed: 96",
    0x93930408: "Rail Canyon Dark Act 2 Enemies Killed: 97",
    0x93930409: "Rail Canyon Dark Act 2 Enemies Killed: 98",
    0x9393040a: "Rail Canyon Dark Act 2 Enemies Killed: 99",
    0x9393040b: "Rail Canyon Dark Act 2 Enemies Killed: 100",
    0x9393040c: "Bullet Station Dark Act 2 Enemies Killed: 1",
    0x9393040d: "Bullet Station Dark Act 2 Enemies Killed: 2",
    0x9393040e: "Bullet Station Dark Act 2 Enemies Killed: 3",
    0x9393040f: "Bullet Station Dark Act 2 Enemies Killed: 4",
    0x93930410: "Bullet Station Dark Act 2 Enemies Killed: 5",
    0x93930411: "Bullet Station Dark Act 2 Enemies Killed: 6",
    0x93930412: "Bullet Station Dark Act 2 Enemies Killed: 7",
    0x93930413: "Bullet Station Dark Act 2 Enemies Killed: 8",
    0x93930414: "Bullet Station Dark Act 2 Enemies Killed: 9",
    0x93930415: "Bullet Station Dark Act 2 Enemies Killed: 10",
    0x93930416: "Bullet Station Dark Act 2 Enemies Killed: 11",
    0x93930417: "Bullet Station Dark Act 2 Enemies Killed: 12",
    0x93930418: "Bullet Station Dark Act 2 Enemies Killed: 13",
    0x93930419: "Bullet Station Dark Act 2 Enemies Killed: 14",
    0x9393041a: "Bullet Station Dark Act 2 Enemies Killed: 15",
    0x9393041b: "Bullet Station Dark Act 2 Enemies Killed: 16",
    0x9393041c: "Bullet Station Dark Act 2 Enemies Killed: 17",
    0x9393041d: "Bullet Station Dark Act 2 Enemies Killed: 18",
    0x9393041e: "Bullet Station Dark Act 2 Enemies Killed: 19",
    0x9393041f: "Bullet Station Dark Act 2 Enemies Killed: 20",
    0x93930420: "Bullet Station Dark Act 2 Enemies Killed: 21",
    0x93930421: "Bullet Station Dark Act 2 Enemies Killed: 22",
    0x93930422: "Bullet Station Dark Act 2 Enemies Killed: 23",
    0x93930423: "Bullet Station Dark Act 2 Enemies Killed: 24",
    0x93930424: "Bullet Station Dark Act 2 Enemies Killed: 25",
    0x93930425: "Bullet Station Dark Act 2 Enemies Killed: 26",
    0x93930426: "Bullet Station Dark Act 2 Enemies Killed: 27",
    0x93930427: "Bullet Station Dark Act 2 Enemies Killed: 28",
    0x93930428: "Bullet Station Dark Act 2 Enemies Killed: 29",
    0x93930429: "Bullet Station Dark Act 2 Enemies Killed: 30",
    0x9393042a: "Bullet Station Dark Act 2 Enemies Killed: 31",
    0x9393042b: "Bullet Station Dark Act 2 Enemies Killed: 32",
    0x9393042c: "Bullet Station Dark Act 2 Enemies Killed: 33",
    0x9393042d: "Bullet Station Dark Act 2 Enemies Killed: 34",
    0x9393042e: "Bullet Station Dark Act 2 Enemies Killed: 35",
    0x9393042f: "Bullet Station Dark Act 2 Enemies Killed: 36",
    0x93930430: "Bullet Station Dark Act 2 Enemies Killed: 37",
    0x93930431: "Bullet Station Dark Act 2 Enemies Killed: 38",
    0x93930432: "Bullet Station Dark Act 2 Enemies Killed: 39",
    0x93930433: "Bullet Station Dark Act 2 Enemies Killed: 40",
    0x93930434: "Bullet Station Dark Act 2 Enemies Killed: 41",
    0x93930435: "Bullet Station Dark Act 2 Enemies Killed: 42",
    0x93930436: "Bullet Station Dark Act 2 Enemies Killed: 43",
    0x93930437: "Bullet Station Dark Act 2 Enemies Killed: 44",
    0x93930438: "Bullet Station Dark Act 2 Enemies Killed: 45",
    0x93930439: "Bullet Station Dark Act 2 Enemies Killed: 46",
    0x9393043a: "Bullet Station Dark Act 2 Enemies Killed: 47",
    0x9393043b: "Bullet Station Dark Act 2 Enemies Killed: 48",
    0x9393043c: "Bullet Station Dark Act 2 Enemies Killed: 49",
    0x9393043d: "Bullet Station Dark Act 2 Enemies Killed: 50",
    0x9393043e: "Bullet Station Dark Act 2 Enemies Killed: 51",
    0x9393043f: "Bullet Station Dark Act 2 Enemies Killed: 52",
    0x93930440: "Bullet Station Dark Act 2 Enemies Killed: 53",
    0x93930441: "Bullet Station Dark Act 2 Enemies Killed: 54",
    0x93930442: "Bullet Station Dark Act 2 Enemies Killed: 55",
    0x93930443: "Bullet Station Dark Act 2 Enemies Killed: 56",
    0x93930444: "Bullet Station Dark Act 2 Enemies Killed: 57",
    0x93930445: "Bullet Station Dark Act 2 Enemies Killed: 58",
    0x93930446: "Bullet Station Dark Act 2 Enemies Killed: 59",
    0x93930447: "Bullet Station Dark Act 2 Enemies Killed: 60",
    0x93930448: "Bullet Station Dark Act 2 Enemies Killed: 61",
    0x93930449: "Bullet Station Dark Act 2 Enemies Killed: 62",
    0x9393044a: "Bullet Station Dark Act 2 Enemies Killed: 63",
    0x9393044b: "Bullet Station Dark Act 2 Enemies Killed: 64",
    0x9393044c: "Bullet Station Dark Act 2 Enemies Killed: 65",
    0x9393044d: "Bullet Station Dark Act 2 Enemies Killed: 66",
    0x9393044e: "Bullet Station Dark Act 2 Enemies Killed: 67",
    0x9393044f: "Bullet Station Dark Act 2 Enemies Killed: 68",
    0x93930450: "Bullet Station Dark Act 2 Enemies Killed: 69",
    0x93930451: "Bullet Station Dark Act 2 Enemies Killed: 70",
    0x93930452: "Bullet Station Dark Act 2 Enemies Killed: 71",
    0x93930453: "Bullet Station Dark Act 2 Enemies Killed: 72",
    0x93930454: "Bullet Station Dark Act 2 Enemies Killed: 73",
    0x93930455: "Bullet Station Dark Act 2 Enemies Killed: 74",
    0x93930456: "Bullet Station Dark Act 2 Enemies Killed: 75",
    0x93930457: "Bullet Station Dark Act 2 Enemies Killed: 76",
    0x93930458: "Bullet Station Dark Act 2 Enemies Killed: 77",
    0x93930459: "Bullet Station Dark Act 2 Enemies Killed: 78",
    0x9393045a: "Bullet Station Dark Act 2 Enemies Killed: 79",
    0x9393045b: "Bullet Station Dark Act 2 Enemies Killed: 80",
    0x9393045c: "Bullet Station Dark Act 2 Enemies Killed: 81",
    0x9393045d: "Bullet Station Dark Act 2 Enemies Killed: 82",
    0x9393045e: "Bullet Station Dark Act 2 Enemies Killed: 83",
    0x9393045f: "Bullet Station Dark Act 2 Enemies Killed: 84",
    0x93930460: "Bullet Station Dark Act 2 Enemies Killed: 85",
    0x93930461: "Bullet Station Dark Act 2 Enemies Killed: 86",
    0x93930462: "Bullet Station Dark Act 2 Enemies Killed: 87",
    0x93930463: "Bullet Station Dark Act 2 Enemies Killed: 88",
    0x93930464: "Bullet Station Dark Act 2 Enemies Killed: 89",
    0x93930465: "Bullet Station Dark Act 2 Enemies Killed: 90",
    0x93930466: "Bullet Station Dark Act 2 Enemies Killed: 91",
    0x93930467: "Bullet Station Dark Act 2 Enemies Killed: 92",
    0x93930468: "Bullet Station Dark Act 2 Enemies Killed: 93",
    0x93930469: "Bullet Station Dark Act 2 Enemies Killed: 94",
    0x9393046a: "Bullet Station Dark Act 2 Enemies Killed: 95",
    0x9393046b: "Bullet Station Dark Act 2 Enemies Killed: 96",
    0x9393046c: "Bullet Station Dark Act 2 Enemies Killed: 97",
    0x9393046d: "Bullet Station Dark Act 2 Enemies Killed: 98",
    0x9393046e: "Bullet Station Dark Act 2 Enemies Killed: 99",
    0x9393046f: "Bullet Station Dark Act 2 Enemies Killed: 100",
    0x93930470: "Frog Forest Dark Act 2 Enemies Killed: 1",
    0x93930471: "Frog Forest Dark Act 2 Enemies Killed: 2",
    0x93930472: "Frog Forest Dark Act 2 Enemies Killed: 3",
    0x93930473: "Frog Forest Dark Act 2 Enemies Killed: 4",
    0x93930474: "Frog Forest Dark Act 2 Enemies Killed: 5",
    0x93930475: "Frog Forest Dark Act 2 Enemies Killed: 6",
    0x93930476: "Frog Forest Dark Act 2 Enemies Killed: 7",
    0x93930477: "Frog Forest Dark Act 2 Enemies Killed: 8",
    0x93930478: "Frog Forest Dark Act 2 Enemies Killed: 9",
    0x93930479: "Frog Forest Dark Act 2 Enemies Killed: 10",
    0x9393047a: "Frog Forest Dark Act 2 Enemies Killed: 11",
    0x9393047b: "Frog Forest Dark Act 2 Enemies Killed: 12",
    0x9393047c: "Frog Forest Dark Act 2 Enemies Killed: 13",
    0x9393047d: "Frog Forest Dark Act 2 Enemies Killed: 14",
    0x9393047e: "Frog Forest Dark Act 2 Enemies Killed: 15",
    0x9393047f: "Frog Forest Dark Act 2 Enemies Killed: 16",
    0x93930480: "Frog Forest Dark Act 2 Enemies Killed: 17",
    0x93930481: "Frog Forest Dark Act 2 Enemies Killed: 18",
    0x93930482: "Frog Forest Dark Act 2 Enemies Killed: 19",
    0x93930483: "Frog Forest Dark Act 2 Enemies Killed: 20",
    0x93930484: "Frog Forest Dark Act 2 Enemies Killed: 21",
    0x93930485: "Frog Forest Dark Act 2 Enemies Killed: 22",
    0x93930486: "Frog Forest Dark Act 2 Enemies Killed: 23",
    0x93930487: "Frog Forest Dark Act 2 Enemies Killed: 24",
    0x93930488: "Frog Forest Dark Act 2 Enemies Killed: 25",
    0x93930489: "Frog Forest Dark Act 2 Enemies Killed: 26",
    0x9393048a: "Frog Forest Dark Act 2 Enemies Killed: 27",
    0x9393048b: "Frog Forest Dark Act 2 Enemies Killed: 28",
    0x9393048c: "Frog Forest Dark Act 2 Enemies Killed: 29",
    0x9393048d: "Frog Forest Dark Act 2 Enemies Killed: 30",
    0x9393048e: "Frog Forest Dark Act 2 Enemies Killed: 31",
    0x9393048f: "Frog Forest Dark Act 2 Enemies Killed: 32",
    0x93930490: "Frog Forest Dark Act 2 Enemies Killed: 33",
    0x93930491: "Frog Forest Dark Act 2 Enemies Killed: 34",
    0x93930492: "Frog Forest Dark Act 2 Enemies Killed: 35",
    0x93930493: "Frog Forest Dark Act 2 Enemies Killed: 36",
    0x93930494: "Frog Forest Dark Act 2 Enemies Killed: 37",
    0x93930495: "Frog Forest Dark Act 2 Enemies Killed: 38",
    0x93930496: "Frog Forest Dark Act 2 Enemies Killed: 39",
    0x93930497: "Frog Forest Dark Act 2 Enemies Killed: 40",
    0x93930498: "Frog Forest Dark Act 2 Enemies Killed: 41",
    0x93930499: "Frog Forest Dark Act 2 Enemies Killed: 42",
    0x9393049a: "Frog Forest Dark Act 2 Enemies Killed: 43",
    0x9393049b: "Frog Forest Dark Act 2 Enemies Killed: 44",
    0x9393049c: "Frog Forest Dark Act 2 Enemies Killed: 45",
    0x9393049d: "Frog Forest Dark Act 2 Enemies Killed: 46",
    0x9393049e: "Frog Forest Dark Act 2 Enemies Killed: 47",
    0x9393049f: "Frog Forest Dark Act 2 Enemies Killed: 48",
    0x939304a0: "Frog Forest Dark Act 2 Enemies Killed: 49",
    0x939304a1: "Frog Forest Dark Act 2 Enemies Killed: 50",
    0x939304a2: "Frog Forest Dark Act 2 Enemies Killed: 51",
    0x939304a3: "Frog Forest Dark Act 2 Enemies Killed: 52",
    0x939304a4: "Frog Forest Dark Act 2 Enemies Killed: 53",
    0x939304a5: "Frog Forest Dark Act 2 Enemies Killed: 54",
    0x939304a6: "Frog Forest Dark Act 2 Enemies Killed: 55",
    0x939304a7: "Frog Forest Dark Act 2 Enemies Killed: 56",
    0x939304a8: "Frog Forest Dark Act 2 Enemies Killed: 57",
    0x939304a9: "Frog Forest Dark Act 2 Enemies Killed: 58",
    0x939304aa: "Frog Forest Dark Act 2 Enemies Killed: 59",
    0x939304ab: "Frog Forest Dark Act 2 Enemies Killed: 60",
    0x939304ac: "Frog Forest Dark Act 2 Enemies Killed: 61",
    0x939304ad: "Frog Forest Dark Act 2 Enemies Killed: 62",
    0x939304ae: "Frog Forest Dark Act 2 Enemies Killed: 63",
    0x939304af: "Frog Forest Dark Act 2 Enemies Killed: 64",
    0x939304b0: "Frog Forest Dark Act 2 Enemies Killed: 65",
    0x939304b1: "Frog Forest Dark Act 2 Enemies Killed: 66",
    0x939304b2: "Frog Forest Dark Act 2 Enemies Killed: 67",
    0x939304b3: "Frog Forest Dark Act 2 Enemies Killed: 68",
    0x939304b4: "Frog Forest Dark Act 2 Enemies Killed: 69",
    0x939304b5: "Frog Forest Dark Act 2 Enemies Killed: 70",
    0x939304b6: "Frog Forest Dark Act 2 Enemies Killed: 71",
    0x939304b7: "Frog Forest Dark Act 2 Enemies Killed: 72",
    0x939304b8: "Frog Forest Dark Act 2 Enemies Killed: 73",
    0x939304b9: "Frog Forest Dark Act 2 Enemies Killed: 74",
    0x939304ba: "Frog Forest Dark Act 2 Enemies Killed: 75",
    0x939304bb: "Frog Forest Dark Act 2 Enemies Killed: 76",
    0x939304bc: "Frog Forest Dark Act 2 Enemies Killed: 77",
    0x939304bd: "Frog Forest Dark Act 2 Enemies Killed: 78",
    0x939304be: "Frog Forest Dark Act 2 Enemies Killed: 79",
    0x939304bf: "Frog Forest Dark Act 2 Enemies Killed: 80",
    0x939304c0: "Frog Forest Dark Act 2 Enemies Killed: 81",
    0x939304c1: "Frog Forest Dark Act 2 Enemies Killed: 82",
    0x939304c2: "Frog Forest Dark Act 2 Enemies Killed: 83",
    0x939304c3: "Frog Forest Dark Act 2 Enemies Killed: 84",
    0x939304c4: "Frog Forest Dark Act 2 Enemies Killed: 85",
    0x939304c5: "Frog Forest Dark Act 2 Enemies Killed: 86",
    0x939304c6: "Frog Forest Dark Act 2 Enemies Killed: 87",
    0x939304c7: "Frog Forest Dark Act 2 Enemies Killed: 88",
    0x939304c8: "Frog Forest Dark Act 2 Enemies Killed: 89",
    0x939304c9: "Frog Forest Dark Act 2 Enemies Killed: 90",
    0x939304ca: "Frog Forest Dark Act 2 Enemies Killed: 91",
    0x939304cb: "Frog Forest Dark Act 2 Enemies Killed: 92",
    0x939304cc: "Frog Forest Dark Act 2 Enemies Killed: 93",
    0x939304cd: "Frog Forest Dark Act 2 Enemies Killed: 94",
    0x939304ce: "Frog Forest Dark Act 2 Enemies Killed: 95",
    0x939304cf: "Frog Forest Dark Act 2 Enemies Killed: 96",
    0x939304d0: "Frog Forest Dark Act 2 Enemies Killed: 97",
    0x939304d1: "Frog Forest Dark Act 2 Enemies Killed: 98",
    0x939304d2: "Frog Forest Dark Act 2 Enemies Killed: 99",
    0x939304d3: "Frog Forest Dark Act 2 Enemies Killed: 100",
    0x939304d4: "Lost Jungle Dark Act 2 Enemies Killed: 1",
    0x939304d5: "Lost Jungle Dark Act 2 Enemies Killed: 2",
    0x939304d6: "Lost Jungle Dark Act 2 Enemies Killed: 3",
    0x939304d7: "Lost Jungle Dark Act 2 Enemies Killed: 4",
    0x939304d8: "Lost Jungle Dark Act 2 Enemies Killed: 5",
    0x939304d9: "Lost Jungle Dark Act 2 Enemies Killed: 6",
    0x939304da: "Lost Jungle Dark Act 2 Enemies Killed: 7",
    0x939304db: "Lost Jungle Dark Act 2 Enemies Killed: 8",
    0x939304dc: "Lost Jungle Dark Act 2 Enemies Killed: 9",
    0x939304dd: "Lost Jungle Dark Act 2 Enemies Killed: 10",
    0x939304de: "Lost Jungle Dark Act 2 Enemies Killed: 11",
    0x939304df: "Lost Jungle Dark Act 2 Enemies Killed: 12",
    0x939304e0: "Lost Jungle Dark Act 2 Enemies Killed: 13",
    0x939304e1: "Lost Jungle Dark Act 2 Enemies Killed: 14",
    0x939304e2: "Lost Jungle Dark Act 2 Enemies Killed: 15",
    0x939304e3: "Lost Jungle Dark Act 2 Enemies Killed: 16",
    0x939304e4: "Lost Jungle Dark Act 2 Enemies Killed: 17",
    0x939304e5: "Lost Jungle Dark Act 2 Enemies Killed: 18",
    0x939304e6: "Lost Jungle Dark Act 2 Enemies Killed: 19",
    0x939304e7: "Lost Jungle Dark Act 2 Enemies Killed: 20",
    0x939304e8: "Lost Jungle Dark Act 2 Enemies Killed: 21",
    0x939304e9: "Lost Jungle Dark Act 2 Enemies Killed: 22",
    0x939304ea: "Lost Jungle Dark Act 2 Enemies Killed: 23",
    0x939304eb: "Lost Jungle Dark Act 2 Enemies Killed: 24",
    0x939304ec: "Lost Jungle Dark Act 2 Enemies Killed: 25",
    0x939304ed: "Lost Jungle Dark Act 2 Enemies Killed: 26",
    0x939304ee: "Lost Jungle Dark Act 2 Enemies Killed: 27",
    0x939304ef: "Lost Jungle Dark Act 2 Enemies Killed: 28",
    0x939304f0: "Lost Jungle Dark Act 2 Enemies Killed: 29",
    0x939304f1: "Lost Jungle Dark Act 2 Enemies Killed: 30",
    0x939304f2: "Lost Jungle Dark Act 2 Enemies Killed: 31",
    0x939304f3: "Lost Jungle Dark Act 2 Enemies Killed: 32",
    0x939304f4: "Lost Jungle Dark Act 2 Enemies Killed: 33",
    0x939304f5: "Lost Jungle Dark Act 2 Enemies Killed: 34",
    0x939304f6: "Lost Jungle Dark Act 2 Enemies Killed: 35",
    0x939304f7: "Lost Jungle Dark Act 2 Enemies Killed: 36",
    0x939304f8: "Lost Jungle Dark Act 2 Enemies Killed: 37",
    0x939304f9: "Lost Jungle Dark Act 2 Enemies Killed: 38",
    0x939304fa: "Lost Jungle Dark Act 2 Enemies Killed: 39",
    0x939304fb: "Lost Jungle Dark Act 2 Enemies Killed: 40",
    0x939304fc: "Lost Jungle Dark Act 2 Enemies Killed: 41",
    0x939304fd: "Lost Jungle Dark Act 2 Enemies Killed: 42",
    0x939304fe: "Lost Jungle Dark Act 2 Enemies Killed: 43",
    0x939304ff: "Lost Jungle Dark Act 2 Enemies Killed: 44",
    0x93930500: "Lost Jungle Dark Act 2 Enemies Killed: 45",
    0x93930501: "Lost Jungle Dark Act 2 Enemies Killed: 46",
    0x93930502: "Lost Jungle Dark Act 2 Enemies Killed: 47",
    0x93930503: "Lost Jungle Dark Act 2 Enemies Killed: 48",
    0x93930504: "Lost Jungle Dark Act 2 Enemies Killed: 49",
    0x93930505: "Lost Jungle Dark Act 2 Enemies Killed: 50",
    0x93930506: "Lost Jungle Dark Act 2 Enemies Killed: 51",
    0x93930507: "Lost Jungle Dark Act 2 Enemies Killed: 52",
    0x93930508: "Lost Jungle Dark Act 2 Enemies Killed: 53",
    0x93930509: "Lost Jungle Dark Act 2 Enemies Killed: 54",
    0x9393050a: "Lost Jungle Dark Act 2 Enemies Killed: 55",
    0x9393050b: "Lost Jungle Dark Act 2 Enemies Killed: 56",
    0x9393050c: "Lost Jungle Dark Act 2 Enemies Killed: 57",
    0x9393050d: "Lost Jungle Dark Act 2 Enemies Killed: 58",
    0x9393050e: "Lost Jungle Dark Act 2 Enemies Killed: 59",
    0x9393050f: "Lost Jungle Dark Act 2 Enemies Killed: 60",
    0x93930510: "Lost Jungle Dark Act 2 Enemies Killed: 61",
    0x93930511: "Lost Jungle Dark Act 2 Enemies Killed: 62",
    0x93930512: "Lost Jungle Dark Act 2 Enemies Killed: 63",
    0x93930513: "Lost Jungle Dark Act 2 Enemies Killed: 64",
    0x93930514: "Lost Jungle Dark Act 2 Enemies Killed: 65",
    0x93930515: "Lost Jungle Dark Act 2 Enemies Killed: 66",
    0x93930516: "Lost Jungle Dark Act 2 Enemies Killed: 67",
    0x93930517: "Lost Jungle Dark Act 2 Enemies Killed: 68",
    0x93930518: "Lost Jungle Dark Act 2 Enemies Killed: 69",
    0x93930519: "Lost Jungle Dark Act 2 Enemies Killed: 70",
    0x9393051a: "Lost Jungle Dark Act 2 Enemies Killed: 71",
    0x9393051b: "Lost Jungle Dark Act 2 Enemies Killed: 72",
    0x9393051c: "Lost Jungle Dark Act 2 Enemies Killed: 73",
    0x9393051d: "Lost Jungle Dark Act 2 Enemies Killed: 74",
    0x9393051e: "Lost Jungle Dark Act 2 Enemies Killed: 75",
    0x9393051f: "Lost Jungle Dark Act 2 Enemies Killed: 76",
    0x93930520: "Lost Jungle Dark Act 2 Enemies Killed: 77",
    0x93930521: "Lost Jungle Dark Act 2 Enemies Killed: 78",
    0x93930522: "Lost Jungle Dark Act 2 Enemies Killed: 79",
    0x93930523: "Lost Jungle Dark Act 2 Enemies Killed: 80",
    0x93930524: "Lost Jungle Dark Act 2 Enemies Killed: 81",
    0x93930525: "Lost Jungle Dark Act 2 Enemies Killed: 82",
    0x93930526: "Lost Jungle Dark Act 2 Enemies Killed: 83",
    0x93930527: "Lost Jungle Dark Act 2 Enemies Killed: 84",
    0x93930528: "Lost Jungle Dark Act 2 Enemies Killed: 85",
    0x93930529: "Lost Jungle Dark Act 2 Enemies Killed: 86",
    0x9393052a: "Lost Jungle Dark Act 2 Enemies Killed: 87",
    0x9393052b: "Lost Jungle Dark Act 2 Enemies Killed: 88",
    0x9393052c: "Lost Jungle Dark Act 2 Enemies Killed: 89",
    0x9393052d: "Lost Jungle Dark Act 2 Enemies Killed: 90",
    0x9393052e: "Lost Jungle Dark Act 2 Enemies Killed: 91",
    0x9393052f: "Lost Jungle Dark Act 2 Enemies Killed: 92",
    0x93930530: "Lost Jungle Dark Act 2 Enemies Killed: 93",
    0x93930531: "Lost Jungle Dark Act 2 Enemies Killed: 94",
    0x93930532: "Lost Jungle Dark Act 2 Enemies Killed: 95",
    0x93930533: "Lost Jungle Dark Act 2 Enemies Killed: 96",
    0x93930534: "Lost Jungle Dark Act 2 Enemies Killed: 97",
    0x93930535: "Lost Jungle Dark Act 2 Enemies Killed: 98",
    0x93930536: "Lost Jungle Dark Act 2 Enemies Killed: 99",
    0x93930537: "Lost Jungle Dark Act 2 Enemies Killed: 100",
    0x93930538: "Hang Castle Dark Act 2 Enemies Killed: 1",
    0x93930539: "Hang Castle Dark Act 2 Enemies Killed: 2",
    0x9393053a: "Hang Castle Dark Act 2 Enemies Killed: 3",
    0x9393053b: "Hang Castle Dark Act 2 Enemies Killed: 4",
    0x9393053c: "Hang Castle Dark Act 2 Enemies Killed: 5",
    0x9393053d: "Hang Castle Dark Act 2 Enemies Killed: 6",
    0x9393053e: "Hang Castle Dark Act 2 Enemies Killed: 7",
    0x9393053f: "Hang Castle Dark Act 2 Enemies Killed: 8",
    0x93930540: "Hang Castle Dark Act 2 Enemies Killed: 9",
    0x93930541: "Hang Castle Dark Act 2 Enemies Killed: 10",
    0x93930542: "Hang Castle Dark Act 2 Enemies Killed: 11",
    0x93930543: "Hang Castle Dark Act 2 Enemies Killed: 12",
    0x93930544: "Hang Castle Dark Act 2 Enemies Killed: 13",
    0x93930545: "Hang Castle Dark Act 2 Enemies Killed: 14",
    0x93930546: "Hang Castle Dark Act 2 Enemies Killed: 15",
    0x93930547: "Hang Castle Dark Act 2 Enemies Killed: 16",
    0x93930548: "Hang Castle Dark Act 2 Enemies Killed: 17",
    0x93930549: "Hang Castle Dark Act 2 Enemies Killed: 18",
    0x9393054a: "Hang Castle Dark Act 2 Enemies Killed: 19",
    0x9393054b: "Hang Castle Dark Act 2 Enemies Killed: 20",
    0x9393054c: "Hang Castle Dark Act 2 Enemies Killed: 21",
    0x9393054d: "Hang Castle Dark Act 2 Enemies Killed: 22",
    0x9393054e: "Hang Castle Dark Act 2 Enemies Killed: 23",
    0x9393054f: "Hang Castle Dark Act 2 Enemies Killed: 24",
    0x93930550: "Hang Castle Dark Act 2 Enemies Killed: 25",
    0x93930551: "Hang Castle Dark Act 2 Enemies Killed: 26",
    0x93930552: "Hang Castle Dark Act 2 Enemies Killed: 27",
    0x93930553: "Hang Castle Dark Act 2 Enemies Killed: 28",
    0x93930554: "Hang Castle Dark Act 2 Enemies Killed: 29",
    0x93930555: "Hang Castle Dark Act 2 Enemies Killed: 30",
    0x93930556: "Hang Castle Dark Act 2 Enemies Killed: 31",
    0x93930557: "Hang Castle Dark Act 2 Enemies Killed: 32",
    0x93930558: "Hang Castle Dark Act 2 Enemies Killed: 33",
    0x93930559: "Hang Castle Dark Act 2 Enemies Killed: 34",
    0x9393055a: "Hang Castle Dark Act 2 Enemies Killed: 35",
    0x9393055b: "Hang Castle Dark Act 2 Enemies Killed: 36",
    0x9393055c: "Hang Castle Dark Act 2 Enemies Killed: 37",
    0x9393055d: "Hang Castle Dark Act 2 Enemies Killed: 38",
    0x9393055e: "Hang Castle Dark Act 2 Enemies Killed: 39",
    0x9393055f: "Hang Castle Dark Act 2 Enemies Killed: 40",
    0x93930560: "Hang Castle Dark Act 2 Enemies Killed: 41",
    0x93930561: "Hang Castle Dark Act 2 Enemies Killed: 42",
    0x93930562: "Hang Castle Dark Act 2 Enemies Killed: 43",
    0x93930563: "Hang Castle Dark Act 2 Enemies Killed: 44",
    0x93930564: "Hang Castle Dark Act 2 Enemies Killed: 45",
    0x93930565: "Hang Castle Dark Act 2 Enemies Killed: 46",
    0x93930566: "Hang Castle Dark Act 2 Enemies Killed: 47",
    0x93930567: "Hang Castle Dark Act 2 Enemies Killed: 48",
    0x93930568: "Hang Castle Dark Act 2 Enemies Killed: 49",
    0x93930569: "Hang Castle Dark Act 2 Enemies Killed: 50",
    0x9393056a: "Hang Castle Dark Act 2 Enemies Killed: 51",
    0x9393056b: "Hang Castle Dark Act 2 Enemies Killed: 52",
    0x9393056c: "Hang Castle Dark Act 2 Enemies Killed: 53",
    0x9393056d: "Hang Castle Dark Act 2 Enemies Killed: 54",
    0x9393056e: "Hang Castle Dark Act 2 Enemies Killed: 55",
    0x9393056f: "Hang Castle Dark Act 2 Enemies Killed: 56",
    0x93930570: "Hang Castle Dark Act 2 Enemies Killed: 57",
    0x93930571: "Hang Castle Dark Act 2 Enemies Killed: 58",
    0x93930572: "Hang Castle Dark Act 2 Enemies Killed: 59",
    0x93930573: "Hang Castle Dark Act 2 Enemies Killed: 60",
    0x93930574: "Hang Castle Dark Act 2 Enemies Killed: 61",
    0x93930575: "Hang Castle Dark Act 2 Enemies Killed: 62",
    0x93930576: "Hang Castle Dark Act 2 Enemies Killed: 63",
    0x93930577: "Hang Castle Dark Act 2 Enemies Killed: 64",
    0x93930578: "Hang Castle Dark Act 2 Enemies Killed: 65",
    0x93930579: "Hang Castle Dark Act 2 Enemies Killed: 66",
    0x9393057a: "Hang Castle Dark Act 2 Enemies Killed: 67",
    0x9393057b: "Hang Castle Dark Act 2 Enemies Killed: 68",
    0x9393057c: "Hang Castle Dark Act 2 Enemies Killed: 69",
    0x9393057d: "Hang Castle Dark Act 2 Enemies Killed: 70",
    0x9393057e: "Hang Castle Dark Act 2 Enemies Killed: 71",
    0x9393057f: "Hang Castle Dark Act 2 Enemies Killed: 72",
    0x93930580: "Hang Castle Dark Act 2 Enemies Killed: 73",
    0x93930581: "Hang Castle Dark Act 2 Enemies Killed: 74",
    0x93930582: "Hang Castle Dark Act 2 Enemies Killed: 75",
    0x93930583: "Hang Castle Dark Act 2 Enemies Killed: 76",
    0x93930584: "Hang Castle Dark Act 2 Enemies Killed: 77",
    0x93930585: "Hang Castle Dark Act 2 Enemies Killed: 78",
    0x93930586: "Hang Castle Dark Act 2 Enemies Killed: 79",
    0x93930587: "Hang Castle Dark Act 2 Enemies Killed: 80",
    0x93930588: "Hang Castle Dark Act 2 Enemies Killed: 81",
    0x93930589: "Hang Castle Dark Act 2 Enemies Killed: 82",
    0x9393058a: "Hang Castle Dark Act 2 Enemies Killed: 83",
    0x9393058b: "Hang Castle Dark Act 2 Enemies Killed: 84",
    0x9393058c: "Hang Castle Dark Act 2 Enemies Killed: 85",
    0x9393058d: "Hang Castle Dark Act 2 Enemies Killed: 86",
    0x9393058e: "Hang Castle Dark Act 2 Enemies Killed: 87",
    0x9393058f: "Hang Castle Dark Act 2 Enemies Killed: 88",
    0x93930590: "Hang Castle Dark Act 2 Enemies Killed: 89",
    0x93930591: "Hang Castle Dark Act 2 Enemies Killed: 90",
    0x93930592: "Hang Castle Dark Act 2 Enemies Killed: 91",
    0x93930593: "Hang Castle Dark Act 2 Enemies Killed: 92",
    0x93930594: "Hang Castle Dark Act 2 Enemies Killed: 93",
    0x93930595: "Hang Castle Dark Act 2 Enemies Killed: 94",
    0x93930596: "Hang Castle Dark Act 2 Enemies Killed: 95",
    0x93930597: "Hang Castle Dark Act 2 Enemies Killed: 96",
    0x93930598: "Hang Castle Dark Act 2 Enemies Killed: 97",
    0x93930599: "Hang Castle Dark Act 2 Enemies Killed: 98",
    0x9393059a: "Hang Castle Dark Act 2 Enemies Killed: 99",
    0x9393059b: "Hang Castle Dark Act 2 Enemies Killed: 100",
    0x9393059c: "Mystic Mansion Dark Act 2 Enemies Killed: 1",
    0x9393059d: "Mystic Mansion Dark Act 2 Enemies Killed: 2",
    0x9393059e: "Mystic Mansion Dark Act 2 Enemies Killed: 3",
    0x9393059f: "Mystic Mansion Dark Act 2 Enemies Killed: 4",
    0x939305a0: "Mystic Mansion Dark Act 2 Enemies Killed: 5",
    0x939305a1: "Mystic Mansion Dark Act 2 Enemies Killed: 6",
    0x939305a2: "Mystic Mansion Dark Act 2 Enemies Killed: 7",
    0x939305a3: "Mystic Mansion Dark Act 2 Enemies Killed: 8",
    0x939305a4: "Mystic Mansion Dark Act 2 Enemies Killed: 9",
    0x939305a5: "Mystic Mansion Dark Act 2 Enemies Killed: 10",
    0x939305a6: "Mystic Mansion Dark Act 2 Enemies Killed: 11",
    0x939305a7: "Mystic Mansion Dark Act 2 Enemies Killed: 12",
    0x939305a8: "Mystic Mansion Dark Act 2 Enemies Killed: 13",
    0x939305a9: "Mystic Mansion Dark Act 2 Enemies Killed: 14",
    0x939305aa: "Mystic Mansion Dark Act 2 Enemies Killed: 15",
    0x939305ab: "Mystic Mansion Dark Act 2 Enemies Killed: 16",
    0x939305ac: "Mystic Mansion Dark Act 2 Enemies Killed: 17",
    0x939305ad: "Mystic Mansion Dark Act 2 Enemies Killed: 18",
    0x939305ae: "Mystic Mansion Dark Act 2 Enemies Killed: 19",
    0x939305af: "Mystic Mansion Dark Act 2 Enemies Killed: 20",
    0x939305b0: "Mystic Mansion Dark Act 2 Enemies Killed: 21",
    0x939305b1: "Mystic Mansion Dark Act 2 Enemies Killed: 22",
    0x939305b2: "Mystic Mansion Dark Act 2 Enemies Killed: 23",
    0x939305b3: "Mystic Mansion Dark Act 2 Enemies Killed: 24",
    0x939305b4: "Mystic Mansion Dark Act 2 Enemies Killed: 25",
    0x939305b5: "Mystic Mansion Dark Act 2 Enemies Killed: 26",
    0x939305b6: "Mystic Mansion Dark Act 2 Enemies Killed: 27",
    0x939305b7: "Mystic Mansion Dark Act 2 Enemies Killed: 28",
    0x939305b8: "Mystic Mansion Dark Act 2 Enemies Killed: 29",
    0x939305b9: "Mystic Mansion Dark Act 2 Enemies Killed: 30",
    0x939305ba: "Mystic Mansion Dark Act 2 Enemies Killed: 31",
    0x939305bb: "Mystic Mansion Dark Act 2 Enemies Killed: 32",
    0x939305bc: "Mystic Mansion Dark Act 2 Enemies Killed: 33",
    0x939305bd: "Mystic Mansion Dark Act 2 Enemies Killed: 34",
    0x939305be: "Mystic Mansion Dark Act 2 Enemies Killed: 35",
    0x939305bf: "Mystic Mansion Dark Act 2 Enemies Killed: 36",
    0x939305c0: "Mystic Mansion Dark Act 2 Enemies Killed: 37",
    0x939305c1: "Mystic Mansion Dark Act 2 Enemies Killed: 38",
    0x939305c2: "Mystic Mansion Dark Act 2 Enemies Killed: 39",
    0x939305c3: "Mystic Mansion Dark Act 2 Enemies Killed: 40",
    0x939305c4: "Mystic Mansion Dark Act 2 Enemies Killed: 41",
    0x939305c5: "Mystic Mansion Dark Act 2 Enemies Killed: 42",
    0x939305c6: "Mystic Mansion Dark Act 2 Enemies Killed: 43",
    0x939305c7: "Mystic Mansion Dark Act 2 Enemies Killed: 44",
    0x939305c8: "Mystic Mansion Dark Act 2 Enemies Killed: 45",
    0x939305c9: "Mystic Mansion Dark Act 2 Enemies Killed: 46",
    0x939305ca: "Mystic Mansion Dark Act 2 Enemies Killed: 47",
    0x939305cb: "Mystic Mansion Dark Act 2 Enemies Killed: 48",
    0x939305cc: "Mystic Mansion Dark Act 2 Enemies Killed: 49",
    0x939305cd: "Mystic Mansion Dark Act 2 Enemies Killed: 50",
    0x939305ce: "Mystic Mansion Dark Act 2 Enemies Killed: 51",
    0x939305cf: "Mystic Mansion Dark Act 2 Enemies Killed: 52",
    0x939305d0: "Mystic Mansion Dark Act 2 Enemies Killed: 53",
    0x939305d1: "Mystic Mansion Dark Act 2 Enemies Killed: 54",
    0x939305d2: "Mystic Mansion Dark Act 2 Enemies Killed: 55",
    0x939305d3: "Mystic Mansion Dark Act 2 Enemies Killed: 56",
    0x939305d4: "Mystic Mansion Dark Act 2 Enemies Killed: 57",
    0x939305d5: "Mystic Mansion Dark Act 2 Enemies Killed: 58",
    0x939305d6: "Mystic Mansion Dark Act 2 Enemies Killed: 59",
    0x939305d7: "Mystic Mansion Dark Act 2 Enemies Killed: 60",
    0x939305d8: "Mystic Mansion Dark Act 2 Enemies Killed: 61",
    0x939305d9: "Mystic Mansion Dark Act 2 Enemies Killed: 62",
    0x939305da: "Mystic Mansion Dark Act 2 Enemies Killed: 63",
    0x939305db: "Mystic Mansion Dark Act 2 Enemies Killed: 64",
    0x939305dc: "Mystic Mansion Dark Act 2 Enemies Killed: 65",
    0x939305dd: "Mystic Mansion Dark Act 2 Enemies Killed: 66",
    0x939305de: "Mystic Mansion Dark Act 2 Enemies Killed: 67",
    0x939305df: "Mystic Mansion Dark Act 2 Enemies Killed: 68",
    0x939305e0: "Mystic Mansion Dark Act 2 Enemies Killed: 69",
    0x939305e1: "Mystic Mansion Dark Act 2 Enemies Killed: 70",
    0x939305e2: "Mystic Mansion Dark Act 2 Enemies Killed: 71",
    0x939305e3: "Mystic Mansion Dark Act 2 Enemies Killed: 72",
    0x939305e4: "Mystic Mansion Dark Act 2 Enemies Killed: 73",
    0x939305e5: "Mystic Mansion Dark Act 2 Enemies Killed: 74",
    0x939305e6: "Mystic Mansion Dark Act 2 Enemies Killed: 75",
    0x939305e7: "Mystic Mansion Dark Act 2 Enemies Killed: 76",
    0x939305e8: "Mystic Mansion Dark Act 2 Enemies Killed: 77",
    0x939305e9: "Mystic Mansion Dark Act 2 Enemies Killed: 78",
    0x939305ea: "Mystic Mansion Dark Act 2 Enemies Killed: 79",
    0x939305eb: "Mystic Mansion Dark Act 2 Enemies Killed: 80",
    0x939305ec: "Mystic Mansion Dark Act 2 Enemies Killed: 81",
    0x939305ed: "Mystic Mansion Dark Act 2 Enemies Killed: 82",
    0x939305ee: "Mystic Mansion Dark Act 2 Enemies Killed: 83",
    0x939305ef: "Mystic Mansion Dark Act 2 Enemies Killed: 84",
    0x939305f0: "Mystic Mansion Dark Act 2 Enemies Killed: 85",
    0x939305f1: "Mystic Mansion Dark Act 2 Enemies Killed: 86",
    0x939305f2: "Mystic Mansion Dark Act 2 Enemies Killed: 87",
    0x939305f3: "Mystic Mansion Dark Act 2 Enemies Killed: 88",
    0x939305f4: "Mystic Mansion Dark Act 2 Enemies Killed: 89",
    0x939305f5: "Mystic Mansion Dark Act 2 Enemies Killed: 90",
    0x939305f6: "Mystic Mansion Dark Act 2 Enemies Killed: 91",
    0x939305f7: "Mystic Mansion Dark Act 2 Enemies Killed: 92",
    0x939305f8: "Mystic Mansion Dark Act 2 Enemies Killed: 93",
    0x939305f9: "Mystic Mansion Dark Act 2 Enemies Killed: 94",
    0x939305fa: "Mystic Mansion Dark Act 2 Enemies Killed: 95",
    0x939305fb: "Mystic Mansion Dark Act 2 Enemies Killed: 96",
    0x939305fc: "Mystic Mansion Dark Act 2 Enemies Killed: 97",
    0x939305fd: "Mystic Mansion Dark Act 2 Enemies Killed: 98",
    0x939305fe: "Mystic Mansion Dark Act 2 Enemies Killed: 99",
    0x939305ff: "Mystic Mansion Dark Act 2 Enemies Killed: 100",
    0x93930600: "Egg Fleet Dark Act 2 Enemies Killed: 1",
    0x93930601: "Egg Fleet Dark Act 2 Enemies Killed: 2",
    0x93930602: "Egg Fleet Dark Act 2 Enemies Killed: 3",
    0x93930603: "Egg Fleet Dark Act 2 Enemies Killed: 4",
    0x93930604: "Egg Fleet Dark Act 2 Enemies Killed: 5",
    0x93930605: "Egg Fleet Dark Act 2 Enemies Killed: 6",
    0x93930606: "Egg Fleet Dark Act 2 Enemies Killed: 7",
    0x93930607: "Egg Fleet Dark Act 2 Enemies Killed: 8",
    0x93930608: "Egg Fleet Dark Act 2 Enemies Killed: 9",
    0x93930609: "Egg Fleet Dark Act 2 Enemies Killed: 10",
    0x9393060a: "Egg Fleet Dark Act 2 Enemies Killed: 11",
    0x9393060b: "Egg Fleet Dark Act 2 Enemies Killed: 12",
    0x9393060c: "Egg Fleet Dark Act 2 Enemies Killed: 13",
    0x9393060d: "Egg Fleet Dark Act 2 Enemies Killed: 14",
    0x9393060e: "Egg Fleet Dark Act 2 Enemies Killed: 15",
    0x9393060f: "Egg Fleet Dark Act 2 Enemies Killed: 16",
    0x93930610: "Egg Fleet Dark Act 2 Enemies Killed: 17",
    0x93930611: "Egg Fleet Dark Act 2 Enemies Killed: 18",
    0x93930612: "Egg Fleet Dark Act 2 Enemies Killed: 19",
    0x93930613: "Egg Fleet Dark Act 2 Enemies Killed: 20",
    0x93930614: "Egg Fleet Dark Act 2 Enemies Killed: 21",
    0x93930615: "Egg Fleet Dark Act 2 Enemies Killed: 22",
    0x93930616: "Egg Fleet Dark Act 2 Enemies Killed: 23",
    0x93930617: "Egg Fleet Dark Act 2 Enemies Killed: 24",
    0x93930618: "Egg Fleet Dark Act 2 Enemies Killed: 25",
    0x93930619: "Egg Fleet Dark Act 2 Enemies Killed: 26",
    0x9393061a: "Egg Fleet Dark Act 2 Enemies Killed: 27",
    0x9393061b: "Egg Fleet Dark Act 2 Enemies Killed: 28",
    0x9393061c: "Egg Fleet Dark Act 2 Enemies Killed: 29",
    0x9393061d: "Egg Fleet Dark Act 2 Enemies Killed: 30",
    0x9393061e: "Egg Fleet Dark Act 2 Enemies Killed: 31",
    0x9393061f: "Egg Fleet Dark Act 2 Enemies Killed: 32",
    0x93930620: "Egg Fleet Dark Act 2 Enemies Killed: 33",
    0x93930621: "Egg Fleet Dark Act 2 Enemies Killed: 34",
    0x93930622: "Egg Fleet Dark Act 2 Enemies Killed: 35",
    0x93930623: "Egg Fleet Dark Act 2 Enemies Killed: 36",
    0x93930624: "Egg Fleet Dark Act 2 Enemies Killed: 37",
    0x93930625: "Egg Fleet Dark Act 2 Enemies Killed: 38",
    0x93930626: "Egg Fleet Dark Act 2 Enemies Killed: 39",
    0x93930627: "Egg Fleet Dark Act 2 Enemies Killed: 40",
    0x93930628: "Egg Fleet Dark Act 2 Enemies Killed: 41",
    0x93930629: "Egg Fleet Dark Act 2 Enemies Killed: 42",
    0x9393062a: "Egg Fleet Dark Act 2 Enemies Killed: 43",
    0x9393062b: "Egg Fleet Dark Act 2 Enemies Killed: 44",
    0x9393062c: "Egg Fleet Dark Act 2 Enemies Killed: 45",
    0x9393062d: "Egg Fleet Dark Act 2 Enemies Killed: 46",
    0x9393062e: "Egg Fleet Dark Act 2 Enemies Killed: 47",
    0x9393062f: "Egg Fleet Dark Act 2 Enemies Killed: 48",
    0x93930630: "Egg Fleet Dark Act 2 Enemies Killed: 49",
    0x93930631: "Egg Fleet Dark Act 2 Enemies Killed: 50",
    0x93930632: "Egg Fleet Dark Act 2 Enemies Killed: 51",
    0x93930633: "Egg Fleet Dark Act 2 Enemies Killed: 52",
    0x93930634: "Egg Fleet Dark Act 2 Enemies Killed: 53",
    0x93930635: "Egg Fleet Dark Act 2 Enemies Killed: 54",
    0x93930636: "Egg Fleet Dark Act 2 Enemies Killed: 55",
    0x93930637: "Egg Fleet Dark Act 2 Enemies Killed: 56",
    0x93930638: "Egg Fleet Dark Act 2 Enemies Killed: 57",
    0x93930639: "Egg Fleet Dark Act 2 Enemies Killed: 58",
    0x9393063a: "Egg Fleet Dark Act 2 Enemies Killed: 59",
    0x9393063b: "Egg Fleet Dark Act 2 Enemies Killed: 60",
    0x9393063c: "Egg Fleet Dark Act 2 Enemies Killed: 61",
    0x9393063d: "Egg Fleet Dark Act 2 Enemies Killed: 62",
    0x9393063e: "Egg Fleet Dark Act 2 Enemies Killed: 63",
    0x9393063f: "Egg Fleet Dark Act 2 Enemies Killed: 64",
    0x93930640: "Egg Fleet Dark Act 2 Enemies Killed: 65",
    0x93930641: "Egg Fleet Dark Act 2 Enemies Killed: 66",
    0x93930642: "Egg Fleet Dark Act 2 Enemies Killed: 67",
    0x93930643: "Egg Fleet Dark Act 2 Enemies Killed: 68",
    0x93930644: "Egg Fleet Dark Act 2 Enemies Killed: 69",
    0x93930645: "Egg Fleet Dark Act 2 Enemies Killed: 70",
    0x93930646: "Egg Fleet Dark Act 2 Enemies Killed: 71",
    0x93930647: "Egg Fleet Dark Act 2 Enemies Killed: 72",
    0x93930648: "Egg Fleet Dark Act 2 Enemies Killed: 73",
    0x93930649: "Egg Fleet Dark Act 2 Enemies Killed: 74",
    0x9393064a: "Egg Fleet Dark Act 2 Enemies Killed: 75",
    0x9393064b: "Egg Fleet Dark Act 2 Enemies Killed: 76",
    0x9393064c: "Egg Fleet Dark Act 2 Enemies Killed: 77",
    0x9393064d: "Egg Fleet Dark Act 2 Enemies Killed: 78",
    0x9393064e: "Egg Fleet Dark Act 2 Enemies Killed: 79",
    0x9393064f: "Egg Fleet Dark Act 2 Enemies Killed: 80",
    0x93930650: "Egg Fleet Dark Act 2 Enemies Killed: 81",
    0x93930651: "Egg Fleet Dark Act 2 Enemies Killed: 82",
    0x93930652: "Egg Fleet Dark Act 2 Enemies Killed: 83",
    0x93930653: "Egg Fleet Dark Act 2 Enemies Killed: 84",
    0x93930654: "Egg Fleet Dark Act 2 Enemies Killed: 85",
    0x93930655: "Egg Fleet Dark Act 2 Enemies Killed: 86",
    0x93930656: "Egg Fleet Dark Act 2 Enemies Killed: 87",
    0x93930657: "Egg Fleet Dark Act 2 Enemies Killed: 88",
    0x93930658: "Egg Fleet Dark Act 2 Enemies Killed: 89",
    0x93930659: "Egg Fleet Dark Act 2 Enemies Killed: 90",
    0x9393065a: "Egg Fleet Dark Act 2 Enemies Killed: 91",
    0x9393065b: "Egg Fleet Dark Act 2 Enemies Killed: 92",
    0x9393065c: "Egg Fleet Dark Act 2 Enemies Killed: 93",
    0x9393065d: "Egg Fleet Dark Act 2 Enemies Killed: 94",
    0x9393065e: "Egg Fleet Dark Act 2 Enemies Killed: 95",
    0x9393065f: "Egg Fleet Dark Act 2 Enemies Killed: 96",
    0x93930660: "Egg Fleet Dark Act 2 Enemies Killed: 97",
    0x93930661: "Egg Fleet Dark Act 2 Enemies Killed: 98",
    0x93930662: "Egg Fleet Dark Act 2 Enemies Killed: 99",
    0x93930663: "Egg Fleet Dark Act 2 Enemies Killed: 100",
    0x93930664: "Final Fortress Dark Act 2 Enemies Killed: 1",
    0x93930665: "Final Fortress Dark Act 2 Enemies Killed: 2",
    0x93930666: "Final Fortress Dark Act 2 Enemies Killed: 3",
    0x93930667: "Final Fortress Dark Act 2 Enemies Killed: 4",
    0x93930668: "Final Fortress Dark Act 2 Enemies Killed: 5",
    0x93930669: "Final Fortress Dark Act 2 Enemies Killed: 6",
    0x9393066a: "Final Fortress Dark Act 2 Enemies Killed: 7",
    0x9393066b: "Final Fortress Dark Act 2 Enemies Killed: 8",
    0x9393066c: "Final Fortress Dark Act 2 Enemies Killed: 9",
    0x9393066d: "Final Fortress Dark Act 2 Enemies Killed: 10",
    0x9393066e: "Final Fortress Dark Act 2 Enemies Killed: 11",
    0x9393066f: "Final Fortress Dark Act 2 Enemies Killed: 12",
    0x93930670: "Final Fortress Dark Act 2 Enemies Killed: 13",
    0x93930671: "Final Fortress Dark Act 2 Enemies Killed: 14",
    0x93930672: "Final Fortress Dark Act 2 Enemies Killed: 15",
    0x93930673: "Final Fortress Dark Act 2 Enemies Killed: 16",
    0x93930674: "Final Fortress Dark Act 2 Enemies Killed: 17",
    0x93930675: "Final Fortress Dark Act 2 Enemies Killed: 18",
    0x93930676: "Final Fortress Dark Act 2 Enemies Killed: 19",
    0x93930677: "Final Fortress Dark Act 2 Enemies Killed: 20",
    0x93930678: "Final Fortress Dark Act 2 Enemies Killed: 21",
    0x93930679: "Final Fortress Dark Act 2 Enemies Killed: 22",
    0x9393067a: "Final Fortress Dark Act 2 Enemies Killed: 23",
    0x9393067b: "Final Fortress Dark Act 2 Enemies Killed: 24",
    0x9393067c: "Final Fortress Dark Act 2 Enemies Killed: 25",
    0x9393067d: "Final Fortress Dark Act 2 Enemies Killed: 26",
    0x9393067e: "Final Fortress Dark Act 2 Enemies Killed: 27",
    0x9393067f: "Final Fortress Dark Act 2 Enemies Killed: 28",
    0x93930680: "Final Fortress Dark Act 2 Enemies Killed: 29",
    0x93930681: "Final Fortress Dark Act 2 Enemies Killed: 30",
    0x93930682: "Final Fortress Dark Act 2 Enemies Killed: 31",
    0x93930683: "Final Fortress Dark Act 2 Enemies Killed: 32",
    0x93930684: "Final Fortress Dark Act 2 Enemies Killed: 33",
    0x93930685: "Final Fortress Dark Act 2 Enemies Killed: 34",
    0x93930686: "Final Fortress Dark Act 2 Enemies Killed: 35",
    0x93930687: "Final Fortress Dark Act 2 Enemies Killed: 36",
    0x93930688: "Final Fortress Dark Act 2 Enemies Killed: 37",
    0x93930689: "Final Fortress Dark Act 2 Enemies Killed: 38",
    0x9393068a: "Final Fortress Dark Act 2 Enemies Killed: 39",
    0x9393068b: "Final Fortress Dark Act 2 Enemies Killed: 40",
    0x9393068c: "Final Fortress Dark Act 2 Enemies Killed: 41",
    0x9393068d: "Final Fortress Dark Act 2 Enemies Killed: 42",
    0x9393068e: "Final Fortress Dark Act 2 Enemies Killed: 43",
    0x9393068f: "Final Fortress Dark Act 2 Enemies Killed: 44",
    0x93930690: "Final Fortress Dark Act 2 Enemies Killed: 45",
    0x93930691: "Final Fortress Dark Act 2 Enemies Killed: 46",
    0x93930692: "Final Fortress Dark Act 2 Enemies Killed: 47",
    0x93930693: "Final Fortress Dark Act 2 Enemies Killed: 48",
    0x93930694: "Final Fortress Dark Act 2 Enemies Killed: 49",
    0x93930695: "Final Fortress Dark Act 2 Enemies Killed: 50",
    0x93930696: "Final Fortress Dark Act 2 Enemies Killed: 51",
    0x93930697: "Final Fortress Dark Act 2 Enemies Killed: 52",
    0x93930698: "Final Fortress Dark Act 2 Enemies Killed: 53",
    0x93930699: "Final Fortress Dark Act 2 Enemies Killed: 54",
    0x9393069a: "Final Fortress Dark Act 2 Enemies Killed: 55",
    0x9393069b: "Final Fortress Dark Act 2 Enemies Killed: 56",
    0x9393069c: "Final Fortress Dark Act 2 Enemies Killed: 57",
    0x9393069d: "Final Fortress Dark Act 2 Enemies Killed: 58",
    0x9393069e: "Final Fortress Dark Act 2 Enemies Killed: 59",
    0x9393069f: "Final Fortress Dark Act 2 Enemies Killed: 60",
    0x939306a0: "Final Fortress Dark Act 2 Enemies Killed: 61",
    0x939306a1: "Final Fortress Dark Act 2 Enemies Killed: 62",
    0x939306a2: "Final Fortress Dark Act 2 Enemies Killed: 63",
    0x939306a3: "Final Fortress Dark Act 2 Enemies Killed: 64",
    0x939306a4: "Final Fortress Dark Act 2 Enemies Killed: 65",
    0x939306a5: "Final Fortress Dark Act 2 Enemies Killed: 66",
    0x939306a6: "Final Fortress Dark Act 2 Enemies Killed: 67",
    0x939306a7: "Final Fortress Dark Act 2 Enemies Killed: 68",
    0x939306a8: "Final Fortress Dark Act 2 Enemies Killed: 69",
    0x939306a9: "Final Fortress Dark Act 2 Enemies Killed: 70",
    0x939306aa: "Final Fortress Dark Act 2 Enemies Killed: 71",
    0x939306ab: "Final Fortress Dark Act 2 Enemies Killed: 72",
    0x939306ac: "Final Fortress Dark Act 2 Enemies Killed: 73",
    0x939306ad: "Final Fortress Dark Act 2 Enemies Killed: 74",
    0x939306ae: "Final Fortress Dark Act 2 Enemies Killed: 75",
    0x939306af: "Final Fortress Dark Act 2 Enemies Killed: 76",
    0x939306b0: "Final Fortress Dark Act 2 Enemies Killed: 77",
    0x939306b1: "Final Fortress Dark Act 2 Enemies Killed: 78",
    0x939306b2: "Final Fortress Dark Act 2 Enemies Killed: 79",
    0x939306b3: "Final Fortress Dark Act 2 Enemies Killed: 80",
    0x939306b4: "Final Fortress Dark Act 2 Enemies Killed: 81",
    0x939306b5: "Final Fortress Dark Act 2 Enemies Killed: 82",
    0x939306b6: "Final Fortress Dark Act 2 Enemies Killed: 83",
    0x939306b7: "Final Fortress Dark Act 2 Enemies Killed: 84",
    0x939306b8: "Final Fortress Dark Act 2 Enemies Killed: 85",
    0x939306b9: "Final Fortress Dark Act 2 Enemies Killed: 86",
    0x939306ba: "Final Fortress Dark Act 2 Enemies Killed: 87",
    0x939306bb: "Final Fortress Dark Act 2 Enemies Killed: 88",
    0x939306bc: "Final Fortress Dark Act 2 Enemies Killed: 89",
    0x939306bd: "Final Fortress Dark Act 2 Enemies Killed: 90",
    0x939306be: "Final Fortress Dark Act 2 Enemies Killed: 91",
    0x939306bf: "Final Fortress Dark Act 2 Enemies Killed: 92",
    0x939306c0: "Final Fortress Dark Act 2 Enemies Killed: 93",
    0x939306c1: "Final Fortress Dark Act 2 Enemies Killed: 94",
    0x939306c2: "Final Fortress Dark Act 2 Enemies Killed: 95",
    0x939306c3: "Final Fortress Dark Act 2 Enemies Killed: 96",
    0x939306c4: "Final Fortress Dark Act 2 Enemies Killed: 97",
    0x939306c5: "Final Fortress Dark Act 2 Enemies Killed: 98",
    0x939306c6: "Final Fortress Dark Act 2 Enemies Killed: 99",
    0x939306c7: "Final Fortress Dark Act 2 Enemies Killed: 100",
    0x939306c8: "Seaside Hill Rose Act 2 Rings Collected: 1",
    0x939306c9: "Seaside Hill Rose Act 2 Rings Collected: 2",
    0x939306ca: "Seaside Hill Rose Act 2 Rings Collected: 3",
    0x939306cb: "Seaside Hill Rose Act 2 Rings Collected: 4",
    0x939306cc: "Seaside Hill Rose Act 2 Rings Collected: 5",
    0x939306cd: "Seaside Hill Rose Act 2 Rings Collected: 6",
    0x939306ce: "Seaside Hill Rose Act 2 Rings Collected: 7",
    0x939306cf: "Seaside Hill Rose Act 2 Rings Collected: 8",
    0x939306d0: "Seaside Hill Rose Act 2 Rings Collected: 9",
    0x939306d1: "Seaside Hill Rose Act 2 Rings Collected: 10",
    0x939306d2: "Seaside Hill Rose Act 2 Rings Collected: 11",
    0x939306d3: "Seaside Hill Rose Act 2 Rings Collected: 12",
    0x939306d4: "Seaside Hill Rose Act 2 Rings Collected: 13",
    0x939306d5: "Seaside Hill Rose Act 2 Rings Collected: 14",
    0x939306d6: "Seaside Hill Rose Act 2 Rings Collected: 15",
    0x939306d7: "Seaside Hill Rose Act 2 Rings Collected: 16",
    0x939306d8: "Seaside Hill Rose Act 2 Rings Collected: 17",
    0x939306d9: "Seaside Hill Rose Act 2 Rings Collected: 18",
    0x939306da: "Seaside Hill Rose Act 2 Rings Collected: 19",
    0x939306db: "Seaside Hill Rose Act 2 Rings Collected: 20",
    0x939306dc: "Seaside Hill Rose Act 2 Rings Collected: 21",
    0x939306dd: "Seaside Hill Rose Act 2 Rings Collected: 22",
    0x939306de: "Seaside Hill Rose Act 2 Rings Collected: 23",
    0x939306df: "Seaside Hill Rose Act 2 Rings Collected: 24",
    0x939306e0: "Seaside Hill Rose Act 2 Rings Collected: 25",
    0x939306e1: "Seaside Hill Rose Act 2 Rings Collected: 26",
    0x939306e2: "Seaside Hill Rose Act 2 Rings Collected: 27",
    0x939306e3: "Seaside Hill Rose Act 2 Rings Collected: 28",
    0x939306e4: "Seaside Hill Rose Act 2 Rings Collected: 29",
    0x939306e5: "Seaside Hill Rose Act 2 Rings Collected: 30",
    0x939306e6: "Seaside Hill Rose Act 2 Rings Collected: 31",
    0x939306e7: "Seaside Hill Rose Act 2 Rings Collected: 32",
    0x939306e8: "Seaside Hill Rose Act 2 Rings Collected: 33",
    0x939306e9: "Seaside Hill Rose Act 2 Rings Collected: 34",
    0x939306ea: "Seaside Hill Rose Act 2 Rings Collected: 35",
    0x939306eb: "Seaside Hill Rose Act 2 Rings Collected: 36",
    0x939306ec: "Seaside Hill Rose Act 2 Rings Collected: 37",
    0x939306ed: "Seaside Hill Rose Act 2 Rings Collected: 38",
    0x939306ee: "Seaside Hill Rose Act 2 Rings Collected: 39",
    0x939306ef: "Seaside Hill Rose Act 2 Rings Collected: 40",
    0x939306f0: "Seaside Hill Rose Act 2 Rings Collected: 41",
    0x939306f1: "Seaside Hill Rose Act 2 Rings Collected: 42",
    0x939306f2: "Seaside Hill Rose Act 2 Rings Collected: 43",
    0x939306f3: "Seaside Hill Rose Act 2 Rings Collected: 44",
    0x939306f4: "Seaside Hill Rose Act 2 Rings Collected: 45",
    0x939306f5: "Seaside Hill Rose Act 2 Rings Collected: 46",
    0x939306f6: "Seaside Hill Rose Act 2 Rings Collected: 47",
    0x939306f7: "Seaside Hill Rose Act 2 Rings Collected: 48",
    0x939306f8: "Seaside Hill Rose Act 2 Rings Collected: 49",
    0x939306f9: "Seaside Hill Rose Act 2 Rings Collected: 50",
    0x939306fa: "Seaside Hill Rose Act 2 Rings Collected: 51",
    0x939306fb: "Seaside Hill Rose Act 2 Rings Collected: 52",
    0x939306fc: "Seaside Hill Rose Act 2 Rings Collected: 53",
    0x939306fd: "Seaside Hill Rose Act 2 Rings Collected: 54",
    0x939306fe: "Seaside Hill Rose Act 2 Rings Collected: 55",
    0x939306ff: "Seaside Hill Rose Act 2 Rings Collected: 56",
    0x93930700: "Seaside Hill Rose Act 2 Rings Collected: 57",
    0x93930701: "Seaside Hill Rose Act 2 Rings Collected: 58",
    0x93930702: "Seaside Hill Rose Act 2 Rings Collected: 59",
    0x93930703: "Seaside Hill Rose Act 2 Rings Collected: 60",
    0x93930704: "Seaside Hill Rose Act 2 Rings Collected: 61",
    0x93930705: "Seaside Hill Rose Act 2 Rings Collected: 62",
    0x93930706: "Seaside Hill Rose Act 2 Rings Collected: 63",
    0x93930707: "Seaside Hill Rose Act 2 Rings Collected: 64",
    0x93930708: "Seaside Hill Rose Act 2 Rings Collected: 65",
    0x93930709: "Seaside Hill Rose Act 2 Rings Collected: 66",
    0x9393070a: "Seaside Hill Rose Act 2 Rings Collected: 67",
    0x9393070b: "Seaside Hill Rose Act 2 Rings Collected: 68",
    0x9393070c: "Seaside Hill Rose Act 2 Rings Collected: 69",
    0x9393070d: "Seaside Hill Rose Act 2 Rings Collected: 70",
    0x9393070e: "Seaside Hill Rose Act 2 Rings Collected: 71",
    0x9393070f: "Seaside Hill Rose Act 2 Rings Collected: 72",
    0x93930710: "Seaside Hill Rose Act 2 Rings Collected: 73",
    0x93930711: "Seaside Hill Rose Act 2 Rings Collected: 74",
    0x93930712: "Seaside Hill Rose Act 2 Rings Collected: 75",
    0x93930713: "Seaside Hill Rose Act 2 Rings Collected: 76",
    0x93930714: "Seaside Hill Rose Act 2 Rings Collected: 77",
    0x93930715: "Seaside Hill Rose Act 2 Rings Collected: 78",
    0x93930716: "Seaside Hill Rose Act 2 Rings Collected: 79",
    0x93930717: "Seaside Hill Rose Act 2 Rings Collected: 80",
    0x93930718: "Seaside Hill Rose Act 2 Rings Collected: 81",
    0x93930719: "Seaside Hill Rose Act 2 Rings Collected: 82",
    0x9393071a: "Seaside Hill Rose Act 2 Rings Collected: 83",
    0x9393071b: "Seaside Hill Rose Act 2 Rings Collected: 84",
    0x9393071c: "Seaside Hill Rose Act 2 Rings Collected: 85",
    0x9393071d: "Seaside Hill Rose Act 2 Rings Collected: 86",
    0x9393071e: "Seaside Hill Rose Act 2 Rings Collected: 87",
    0x9393071f: "Seaside Hill Rose Act 2 Rings Collected: 88",
    0x93930720: "Seaside Hill Rose Act 2 Rings Collected: 89",
    0x93930721: "Seaside Hill Rose Act 2 Rings Collected: 90",
    0x93930722: "Seaside Hill Rose Act 2 Rings Collected: 91",
    0x93930723: "Seaside Hill Rose Act 2 Rings Collected: 92",
    0x93930724: "Seaside Hill Rose Act 2 Rings Collected: 93",
    0x93930725: "Seaside Hill Rose Act 2 Rings Collected: 94",
    0x93930726: "Seaside Hill Rose Act 2 Rings Collected: 95",
    0x93930727: "Seaside Hill Rose Act 2 Rings Collected: 96",
    0x93930728: "Seaside Hill Rose Act 2 Rings Collected: 97",
    0x93930729: "Seaside Hill Rose Act 2 Rings Collected: 98",
    0x9393072a: "Seaside Hill Rose Act 2 Rings Collected: 99",
    0x9393072b: "Seaside Hill Rose Act 2 Rings Collected: 100",
    0x9393072c: "Seaside Hill Rose Act 2 Rings Collected: 101",
    0x9393072d: "Seaside Hill Rose Act 2 Rings Collected: 102",
    0x9393072e: "Seaside Hill Rose Act 2 Rings Collected: 103",
    0x9393072f: "Seaside Hill Rose Act 2 Rings Collected: 104",
    0x93930730: "Seaside Hill Rose Act 2 Rings Collected: 105",
    0x93930731: "Seaside Hill Rose Act 2 Rings Collected: 106",
    0x93930732: "Seaside Hill Rose Act 2 Rings Collected: 107",
    0x93930733: "Seaside Hill Rose Act 2 Rings Collected: 108",
    0x93930734: "Seaside Hill Rose Act 2 Rings Collected: 109",
    0x93930735: "Seaside Hill Rose Act 2 Rings Collected: 110",
    0x93930736: "Seaside Hill Rose Act 2 Rings Collected: 111",
    0x93930737: "Seaside Hill Rose Act 2 Rings Collected: 112",
    0x93930738: "Seaside Hill Rose Act 2 Rings Collected: 113",
    0x93930739: "Seaside Hill Rose Act 2 Rings Collected: 114",
    0x9393073a: "Seaside Hill Rose Act 2 Rings Collected: 115",
    0x9393073b: "Seaside Hill Rose Act 2 Rings Collected: 116",
    0x9393073c: "Seaside Hill Rose Act 2 Rings Collected: 117",
    0x9393073d: "Seaside Hill Rose Act 2 Rings Collected: 118",
    0x9393073e: "Seaside Hill Rose Act 2 Rings Collected: 119",
    0x9393073f: "Seaside Hill Rose Act 2 Rings Collected: 120",
    0x93930740: "Seaside Hill Rose Act 2 Rings Collected: 121",
    0x93930741: "Seaside Hill Rose Act 2 Rings Collected: 122",
    0x93930742: "Seaside Hill Rose Act 2 Rings Collected: 123",
    0x93930743: "Seaside Hill Rose Act 2 Rings Collected: 124",
    0x93930744: "Seaside Hill Rose Act 2 Rings Collected: 125",
    0x93930745: "Seaside Hill Rose Act 2 Rings Collected: 126",
    0x93930746: "Seaside Hill Rose Act 2 Rings Collected: 127",
    0x93930747: "Seaside Hill Rose Act 2 Rings Collected: 128",
    0x93930748: "Seaside Hill Rose Act 2 Rings Collected: 129",
    0x93930749: "Seaside Hill Rose Act 2 Rings Collected: 130",
    0x9393074a: "Seaside Hill Rose Act 2 Rings Collected: 131",
    0x9393074b: "Seaside Hill Rose Act 2 Rings Collected: 132",
    0x9393074c: "Seaside Hill Rose Act 2 Rings Collected: 133",
    0x9393074d: "Seaside Hill Rose Act 2 Rings Collected: 134",
    0x9393074e: "Seaside Hill Rose Act 2 Rings Collected: 135",
    0x9393074f: "Seaside Hill Rose Act 2 Rings Collected: 136",
    0x93930750: "Seaside Hill Rose Act 2 Rings Collected: 137",
    0x93930751: "Seaside Hill Rose Act 2 Rings Collected: 138",
    0x93930752: "Seaside Hill Rose Act 2 Rings Collected: 139",
    0x93930753: "Seaside Hill Rose Act 2 Rings Collected: 140",
    0x93930754: "Seaside Hill Rose Act 2 Rings Collected: 141",
    0x93930755: "Seaside Hill Rose Act 2 Rings Collected: 142",
    0x93930756: "Seaside Hill Rose Act 2 Rings Collected: 143",
    0x93930757: "Seaside Hill Rose Act 2 Rings Collected: 144",
    0x93930758: "Seaside Hill Rose Act 2 Rings Collected: 145",
    0x93930759: "Seaside Hill Rose Act 2 Rings Collected: 146",
    0x9393075a: "Seaside Hill Rose Act 2 Rings Collected: 147",
    0x9393075b: "Seaside Hill Rose Act 2 Rings Collected: 148",
    0x9393075c: "Seaside Hill Rose Act 2 Rings Collected: 149",
    0x9393075d: "Seaside Hill Rose Act 2 Rings Collected: 150",
    0x9393075e: "Seaside Hill Rose Act 2 Rings Collected: 151",
    0x9393075f: "Seaside Hill Rose Act 2 Rings Collected: 152",
    0x93930760: "Seaside Hill Rose Act 2 Rings Collected: 153",
    0x93930761: "Seaside Hill Rose Act 2 Rings Collected: 154",
    0x93930762: "Seaside Hill Rose Act 2 Rings Collected: 155",
    0x93930763: "Seaside Hill Rose Act 2 Rings Collected: 156",
    0x93930764: "Seaside Hill Rose Act 2 Rings Collected: 157",
    0x93930765: "Seaside Hill Rose Act 2 Rings Collected: 158",
    0x93930766: "Seaside Hill Rose Act 2 Rings Collected: 159",
    0x93930767: "Seaside Hill Rose Act 2 Rings Collected: 160",
    0x93930768: "Seaside Hill Rose Act 2 Rings Collected: 161",
    0x93930769: "Seaside Hill Rose Act 2 Rings Collected: 162",
    0x9393076a: "Seaside Hill Rose Act 2 Rings Collected: 163",
    0x9393076b: "Seaside Hill Rose Act 2 Rings Collected: 164",
    0x9393076c: "Seaside Hill Rose Act 2 Rings Collected: 165",
    0x9393076d: "Seaside Hill Rose Act 2 Rings Collected: 166",
    0x9393076e: "Seaside Hill Rose Act 2 Rings Collected: 167",
    0x9393076f: "Seaside Hill Rose Act 2 Rings Collected: 168",
    0x93930770: "Seaside Hill Rose Act 2 Rings Collected: 169",
    0x93930771: "Seaside Hill Rose Act 2 Rings Collected: 170",
    0x93930772: "Seaside Hill Rose Act 2 Rings Collected: 171",
    0x93930773: "Seaside Hill Rose Act 2 Rings Collected: 172",
    0x93930774: "Seaside Hill Rose Act 2 Rings Collected: 173",
    0x93930775: "Seaside Hill Rose Act 2 Rings Collected: 174",
    0x93930776: "Seaside Hill Rose Act 2 Rings Collected: 175",
    0x93930777: "Seaside Hill Rose Act 2 Rings Collected: 176",
    0x93930778: "Seaside Hill Rose Act 2 Rings Collected: 177",
    0x93930779: "Seaside Hill Rose Act 2 Rings Collected: 178",
    0x9393077a: "Seaside Hill Rose Act 2 Rings Collected: 179",
    0x9393077b: "Seaside Hill Rose Act 2 Rings Collected: 180",
    0x9393077c: "Seaside Hill Rose Act 2 Rings Collected: 181",
    0x9393077d: "Seaside Hill Rose Act 2 Rings Collected: 182",
    0x9393077e: "Seaside Hill Rose Act 2 Rings Collected: 183",
    0x9393077f: "Seaside Hill Rose Act 2 Rings Collected: 184",
    0x93930780: "Seaside Hill Rose Act 2 Rings Collected: 185",
    0x93930781: "Seaside Hill Rose Act 2 Rings Collected: 186",
    0x93930782: "Seaside Hill Rose Act 2 Rings Collected: 187",
    0x93930783: "Seaside Hill Rose Act 2 Rings Collected: 188",
    0x93930784: "Seaside Hill Rose Act 2 Rings Collected: 189",
    0x93930785: "Seaside Hill Rose Act 2 Rings Collected: 190",
    0x93930786: "Seaside Hill Rose Act 2 Rings Collected: 191",
    0x93930787: "Seaside Hill Rose Act 2 Rings Collected: 192",
    0x93930788: "Seaside Hill Rose Act 2 Rings Collected: 193",
    0x93930789: "Seaside Hill Rose Act 2 Rings Collected: 194",
    0x9393078a: "Seaside Hill Rose Act 2 Rings Collected: 195",
    0x9393078b: "Seaside Hill Rose Act 2 Rings Collected: 196",
    0x9393078c: "Seaside Hill Rose Act 2 Rings Collected: 197",
    0x9393078d: "Seaside Hill Rose Act 2 Rings Collected: 198",
    0x9393078e: "Seaside Hill Rose Act 2 Rings Collected: 199",
    0x9393078f: "Seaside Hill Rose Act 2 Rings Collected: 200",
    0x93930790: "Ocean Palace Rose Act 2 Rings Collected: 1",
    0x93930791: "Ocean Palace Rose Act 2 Rings Collected: 2",
    0x93930792: "Ocean Palace Rose Act 2 Rings Collected: 3",
    0x93930793: "Ocean Palace Rose Act 2 Rings Collected: 4",
    0x93930794: "Ocean Palace Rose Act 2 Rings Collected: 5",
    0x93930795: "Ocean Palace Rose Act 2 Rings Collected: 6",
    0x93930796: "Ocean Palace Rose Act 2 Rings Collected: 7",
    0x93930797: "Ocean Palace Rose Act 2 Rings Collected: 8",
    0x93930798: "Ocean Palace Rose Act 2 Rings Collected: 9",
    0x93930799: "Ocean Palace Rose Act 2 Rings Collected: 10",
    0x9393079a: "Ocean Palace Rose Act 2 Rings Collected: 11",
    0x9393079b: "Ocean Palace Rose Act 2 Rings Collected: 12",
    0x9393079c: "Ocean Palace Rose Act 2 Rings Collected: 13",
    0x9393079d: "Ocean Palace Rose Act 2 Rings Collected: 14",
    0x9393079e: "Ocean Palace Rose Act 2 Rings Collected: 15",
    0x9393079f: "Ocean Palace Rose Act 2 Rings Collected: 16",
    0x939307a0: "Ocean Palace Rose Act 2 Rings Collected: 17",
    0x939307a1: "Ocean Palace Rose Act 2 Rings Collected: 18",
    0x939307a2: "Ocean Palace Rose Act 2 Rings Collected: 19",
    0x939307a3: "Ocean Palace Rose Act 2 Rings Collected: 20",
    0x939307a4: "Ocean Palace Rose Act 2 Rings Collected: 21",
    0x939307a5: "Ocean Palace Rose Act 2 Rings Collected: 22",
    0x939307a6: "Ocean Palace Rose Act 2 Rings Collected: 23",
    0x939307a7: "Ocean Palace Rose Act 2 Rings Collected: 24",
    0x939307a8: "Ocean Palace Rose Act 2 Rings Collected: 25",
    0x939307a9: "Ocean Palace Rose Act 2 Rings Collected: 26",
    0x939307aa: "Ocean Palace Rose Act 2 Rings Collected: 27",
    0x939307ab: "Ocean Palace Rose Act 2 Rings Collected: 28",
    0x939307ac: "Ocean Palace Rose Act 2 Rings Collected: 29",
    0x939307ad: "Ocean Palace Rose Act 2 Rings Collected: 30",
    0x939307ae: "Ocean Palace Rose Act 2 Rings Collected: 31",
    0x939307af: "Ocean Palace Rose Act 2 Rings Collected: 32",
    0x939307b0: "Ocean Palace Rose Act 2 Rings Collected: 33",
    0x939307b1: "Ocean Palace Rose Act 2 Rings Collected: 34",
    0x939307b2: "Ocean Palace Rose Act 2 Rings Collected: 35",
    0x939307b3: "Ocean Palace Rose Act 2 Rings Collected: 36",
    0x939307b4: "Ocean Palace Rose Act 2 Rings Collected: 37",
    0x939307b5: "Ocean Palace Rose Act 2 Rings Collected: 38",
    0x939307b6: "Ocean Palace Rose Act 2 Rings Collected: 39",
    0x939307b7: "Ocean Palace Rose Act 2 Rings Collected: 40",
    0x939307b8: "Ocean Palace Rose Act 2 Rings Collected: 41",
    0x939307b9: "Ocean Palace Rose Act 2 Rings Collected: 42",
    0x939307ba: "Ocean Palace Rose Act 2 Rings Collected: 43",
    0x939307bb: "Ocean Palace Rose Act 2 Rings Collected: 44",
    0x939307bc: "Ocean Palace Rose Act 2 Rings Collected: 45",
    0x939307bd: "Ocean Palace Rose Act 2 Rings Collected: 46",
    0x939307be: "Ocean Palace Rose Act 2 Rings Collected: 47",
    0x939307bf: "Ocean Palace Rose Act 2 Rings Collected: 48",
    0x939307c0: "Ocean Palace Rose Act 2 Rings Collected: 49",
    0x939307c1: "Ocean Palace Rose Act 2 Rings Collected: 50",
    0x939307c2: "Ocean Palace Rose Act 2 Rings Collected: 51",
    0x939307c3: "Ocean Palace Rose Act 2 Rings Collected: 52",
    0x939307c4: "Ocean Palace Rose Act 2 Rings Collected: 53",
    0x939307c5: "Ocean Palace Rose Act 2 Rings Collected: 54",
    0x939307c6: "Ocean Palace Rose Act 2 Rings Collected: 55",
    0x939307c7: "Ocean Palace Rose Act 2 Rings Collected: 56",
    0x939307c8: "Ocean Palace Rose Act 2 Rings Collected: 57",
    0x939307c9: "Ocean Palace Rose Act 2 Rings Collected: 58",
    0x939307ca: "Ocean Palace Rose Act 2 Rings Collected: 59",
    0x939307cb: "Ocean Palace Rose Act 2 Rings Collected: 60",
    0x939307cc: "Ocean Palace Rose Act 2 Rings Collected: 61",
    0x939307cd: "Ocean Palace Rose Act 2 Rings Collected: 62",
    0x939307ce: "Ocean Palace Rose Act 2 Rings Collected: 63",
    0x939307cf: "Ocean Palace Rose Act 2 Rings Collected: 64",
    0x939307d0: "Ocean Palace Rose Act 2 Rings Collected: 65",
    0x939307d1: "Ocean Palace Rose Act 2 Rings Collected: 66",
    0x939307d2: "Ocean Palace Rose Act 2 Rings Collected: 67",
    0x939307d3: "Ocean Palace Rose Act 2 Rings Collected: 68",
    0x939307d4: "Ocean Palace Rose Act 2 Rings Collected: 69",
    0x939307d5: "Ocean Palace Rose Act 2 Rings Collected: 70",
    0x939307d6: "Ocean Palace Rose Act 2 Rings Collected: 71",
    0x939307d7: "Ocean Palace Rose Act 2 Rings Collected: 72",
    0x939307d8: "Ocean Palace Rose Act 2 Rings Collected: 73",
    0x939307d9: "Ocean Palace Rose Act 2 Rings Collected: 74",
    0x939307da: "Ocean Palace Rose Act 2 Rings Collected: 75",
    0x939307db: "Ocean Palace Rose Act 2 Rings Collected: 76",
    0x939307dc: "Ocean Palace Rose Act 2 Rings Collected: 77",
    0x939307dd: "Ocean Palace Rose Act 2 Rings Collected: 78",
    0x939307de: "Ocean Palace Rose Act 2 Rings Collected: 79",
    0x939307df: "Ocean Palace Rose Act 2 Rings Collected: 80",
    0x939307e0: "Ocean Palace Rose Act 2 Rings Collected: 81",
    0x939307e1: "Ocean Palace Rose Act 2 Rings Collected: 82",
    0x939307e2: "Ocean Palace Rose Act 2 Rings Collected: 83",
    0x939307e3: "Ocean Palace Rose Act 2 Rings Collected: 84",
    0x939307e4: "Ocean Palace Rose Act 2 Rings Collected: 85",
    0x939307e5: "Ocean Palace Rose Act 2 Rings Collected: 86",
    0x939307e6: "Ocean Palace Rose Act 2 Rings Collected: 87",
    0x939307e7: "Ocean Palace Rose Act 2 Rings Collected: 88",
    0x939307e8: "Ocean Palace Rose Act 2 Rings Collected: 89",
    0x939307e9: "Ocean Palace Rose Act 2 Rings Collected: 90",
    0x939307ea: "Ocean Palace Rose Act 2 Rings Collected: 91",
    0x939307eb: "Ocean Palace Rose Act 2 Rings Collected: 92",
    0x939307ec: "Ocean Palace Rose Act 2 Rings Collected: 93",
    0x939307ed: "Ocean Palace Rose Act 2 Rings Collected: 94",
    0x939307ee: "Ocean Palace Rose Act 2 Rings Collected: 95",
    0x939307ef: "Ocean Palace Rose Act 2 Rings Collected: 96",
    0x939307f0: "Ocean Palace Rose Act 2 Rings Collected: 97",
    0x939307f1: "Ocean Palace Rose Act 2 Rings Collected: 98",
    0x939307f2: "Ocean Palace Rose Act 2 Rings Collected: 99",
    0x939307f3: "Ocean Palace Rose Act 2 Rings Collected: 100",
    0x939307f4: "Ocean Palace Rose Act 2 Rings Collected: 101",
    0x939307f5: "Ocean Palace Rose Act 2 Rings Collected: 102",
    0x939307f6: "Ocean Palace Rose Act 2 Rings Collected: 103",
    0x939307f7: "Ocean Palace Rose Act 2 Rings Collected: 104",
    0x939307f8: "Ocean Palace Rose Act 2 Rings Collected: 105",
    0x939307f9: "Ocean Palace Rose Act 2 Rings Collected: 106",
    0x939307fa: "Ocean Palace Rose Act 2 Rings Collected: 107",
    0x939307fb: "Ocean Palace Rose Act 2 Rings Collected: 108",
    0x939307fc: "Ocean Palace Rose Act 2 Rings Collected: 109",
    0x939307fd: "Ocean Palace Rose Act 2 Rings Collected: 110",
    0x939307fe: "Ocean Palace Rose Act 2 Rings Collected: 111",
    0x939307ff: "Ocean Palace Rose Act 2 Rings Collected: 112",
    0x93930800: "Ocean Palace Rose Act 2 Rings Collected: 113",
    0x93930801: "Ocean Palace Rose Act 2 Rings Collected: 114",
    0x93930802: "Ocean Palace Rose Act 2 Rings Collected: 115",
    0x93930803: "Ocean Palace Rose Act 2 Rings Collected: 116",
    0x93930804: "Ocean Palace Rose Act 2 Rings Collected: 117",
    0x93930805: "Ocean Palace Rose Act 2 Rings Collected: 118",
    0x93930806: "Ocean Palace Rose Act 2 Rings Collected: 119",
    0x93930807: "Ocean Palace Rose Act 2 Rings Collected: 120",
    0x93930808: "Ocean Palace Rose Act 2 Rings Collected: 121",
    0x93930809: "Ocean Palace Rose Act 2 Rings Collected: 122",
    0x9393080a: "Ocean Palace Rose Act 2 Rings Collected: 123",
    0x9393080b: "Ocean Palace Rose Act 2 Rings Collected: 124",
    0x9393080c: "Ocean Palace Rose Act 2 Rings Collected: 125",
    0x9393080d: "Ocean Palace Rose Act 2 Rings Collected: 126",
    0x9393080e: "Ocean Palace Rose Act 2 Rings Collected: 127",
    0x9393080f: "Ocean Palace Rose Act 2 Rings Collected: 128",
    0x93930810: "Ocean Palace Rose Act 2 Rings Collected: 129",
    0x93930811: "Ocean Palace Rose Act 2 Rings Collected: 130",
    0x93930812: "Ocean Palace Rose Act 2 Rings Collected: 131",
    0x93930813: "Ocean Palace Rose Act 2 Rings Collected: 132",
    0x93930814: "Ocean Palace Rose Act 2 Rings Collected: 133",
    0x93930815: "Ocean Palace Rose Act 2 Rings Collected: 134",
    0x93930816: "Ocean Palace Rose Act 2 Rings Collected: 135",
    0x93930817: "Ocean Palace Rose Act 2 Rings Collected: 136",
    0x93930818: "Ocean Palace Rose Act 2 Rings Collected: 137",
    0x93930819: "Ocean Palace Rose Act 2 Rings Collected: 138",
    0x9393081a: "Ocean Palace Rose Act 2 Rings Collected: 139",
    0x9393081b: "Ocean Palace Rose Act 2 Rings Collected: 140",
    0x9393081c: "Ocean Palace Rose Act 2 Rings Collected: 141",
    0x9393081d: "Ocean Palace Rose Act 2 Rings Collected: 142",
    0x9393081e: "Ocean Palace Rose Act 2 Rings Collected: 143",
    0x9393081f: "Ocean Palace Rose Act 2 Rings Collected: 144",
    0x93930820: "Ocean Palace Rose Act 2 Rings Collected: 145",
    0x93930821: "Ocean Palace Rose Act 2 Rings Collected: 146",
    0x93930822: "Ocean Palace Rose Act 2 Rings Collected: 147",
    0x93930823: "Ocean Palace Rose Act 2 Rings Collected: 148",
    0x93930824: "Ocean Palace Rose Act 2 Rings Collected: 149",
    0x93930825: "Ocean Palace Rose Act 2 Rings Collected: 150",
    0x93930826: "Ocean Palace Rose Act 2 Rings Collected: 151",
    0x93930827: "Ocean Palace Rose Act 2 Rings Collected: 152",
    0x93930828: "Ocean Palace Rose Act 2 Rings Collected: 153",
    0x93930829: "Ocean Palace Rose Act 2 Rings Collected: 154",
    0x9393082a: "Ocean Palace Rose Act 2 Rings Collected: 155",
    0x9393082b: "Ocean Palace Rose Act 2 Rings Collected: 156",
    0x9393082c: "Ocean Palace Rose Act 2 Rings Collected: 157",
    0x9393082d: "Ocean Palace Rose Act 2 Rings Collected: 158",
    0x9393082e: "Ocean Palace Rose Act 2 Rings Collected: 159",
    0x9393082f: "Ocean Palace Rose Act 2 Rings Collected: 160",
    0x93930830: "Ocean Palace Rose Act 2 Rings Collected: 161",
    0x93930831: "Ocean Palace Rose Act 2 Rings Collected: 162",
    0x93930832: "Ocean Palace Rose Act 2 Rings Collected: 163",
    0x93930833: "Ocean Palace Rose Act 2 Rings Collected: 164",
    0x93930834: "Ocean Palace Rose Act 2 Rings Collected: 165",
    0x93930835: "Ocean Palace Rose Act 2 Rings Collected: 166",
    0x93930836: "Ocean Palace Rose Act 2 Rings Collected: 167",
    0x93930837: "Ocean Palace Rose Act 2 Rings Collected: 168",
    0x93930838: "Ocean Palace Rose Act 2 Rings Collected: 169",
    0x93930839: "Ocean Palace Rose Act 2 Rings Collected: 170",
    0x9393083a: "Ocean Palace Rose Act 2 Rings Collected: 171",
    0x9393083b: "Ocean Palace Rose Act 2 Rings Collected: 172",
    0x9393083c: "Ocean Palace Rose Act 2 Rings Collected: 173",
    0x9393083d: "Ocean Palace Rose Act 2 Rings Collected: 174",
    0x9393083e: "Ocean Palace Rose Act 2 Rings Collected: 175",
    0x9393083f: "Ocean Palace Rose Act 2 Rings Collected: 176",
    0x93930840: "Ocean Palace Rose Act 2 Rings Collected: 177",
    0x93930841: "Ocean Palace Rose Act 2 Rings Collected: 178",
    0x93930842: "Ocean Palace Rose Act 2 Rings Collected: 179",
    0x93930843: "Ocean Palace Rose Act 2 Rings Collected: 180",
    0x93930844: "Ocean Palace Rose Act 2 Rings Collected: 181",
    0x93930845: "Ocean Palace Rose Act 2 Rings Collected: 182",
    0x93930846: "Ocean Palace Rose Act 2 Rings Collected: 183",
    0x93930847: "Ocean Palace Rose Act 2 Rings Collected: 184",
    0x93930848: "Ocean Palace Rose Act 2 Rings Collected: 185",
    0x93930849: "Ocean Palace Rose Act 2 Rings Collected: 186",
    0x9393084a: "Ocean Palace Rose Act 2 Rings Collected: 187",
    0x9393084b: "Ocean Palace Rose Act 2 Rings Collected: 188",
    0x9393084c: "Ocean Palace Rose Act 2 Rings Collected: 189",
    0x9393084d: "Ocean Palace Rose Act 2 Rings Collected: 190",
    0x9393084e: "Ocean Palace Rose Act 2 Rings Collected: 191",
    0x9393084f: "Ocean Palace Rose Act 2 Rings Collected: 192",
    0x93930850: "Ocean Palace Rose Act 2 Rings Collected: 193",
    0x93930851: "Ocean Palace Rose Act 2 Rings Collected: 194",
    0x93930852: "Ocean Palace Rose Act 2 Rings Collected: 195",
    0x93930853: "Ocean Palace Rose Act 2 Rings Collected: 196",
    0x93930854: "Ocean Palace Rose Act 2 Rings Collected: 197",
    0x93930855: "Ocean Palace Rose Act 2 Rings Collected: 198",
    0x93930856: "Ocean Palace Rose Act 2 Rings Collected: 199",
    0x93930857: "Ocean Palace Rose Act 2 Rings Collected: 200",
    0x93930858: "Grand Metropolis Rose Act 2 Rings Collected: 1",
    0x93930859: "Grand Metropolis Rose Act 2 Rings Collected: 2",
    0x9393085a: "Grand Metropolis Rose Act 2 Rings Collected: 3",
    0x9393085b: "Grand Metropolis Rose Act 2 Rings Collected: 4",
    0x9393085c: "Grand Metropolis Rose Act 2 Rings Collected: 5",
    0x9393085d: "Grand Metropolis Rose Act 2 Rings Collected: 6",
    0x9393085e: "Grand Metropolis Rose Act 2 Rings Collected: 7",
    0x9393085f: "Grand Metropolis Rose Act 2 Rings Collected: 8",
    0x93930860: "Grand Metropolis Rose Act 2 Rings Collected: 9",
    0x93930861: "Grand Metropolis Rose Act 2 Rings Collected: 10",
    0x93930862: "Grand Metropolis Rose Act 2 Rings Collected: 11",
    0x93930863: "Grand Metropolis Rose Act 2 Rings Collected: 12",
    0x93930864: "Grand Metropolis Rose Act 2 Rings Collected: 13",
    0x93930865: "Grand Metropolis Rose Act 2 Rings Collected: 14",
    0x93930866: "Grand Metropolis Rose Act 2 Rings Collected: 15",
    0x93930867: "Grand Metropolis Rose Act 2 Rings Collected: 16",
    0x93930868: "Grand Metropolis Rose Act 2 Rings Collected: 17",
    0x93930869: "Grand Metropolis Rose Act 2 Rings Collected: 18",
    0x9393086a: "Grand Metropolis Rose Act 2 Rings Collected: 19",
    0x9393086b: "Grand Metropolis Rose Act 2 Rings Collected: 20",
    0x9393086c: "Grand Metropolis Rose Act 2 Rings Collected: 21",
    0x9393086d: "Grand Metropolis Rose Act 2 Rings Collected: 22",
    0x9393086e: "Grand Metropolis Rose Act 2 Rings Collected: 23",
    0x9393086f: "Grand Metropolis Rose Act 2 Rings Collected: 24",
    0x93930870: "Grand Metropolis Rose Act 2 Rings Collected: 25",
    0x93930871: "Grand Metropolis Rose Act 2 Rings Collected: 26",
    0x93930872: "Grand Metropolis Rose Act 2 Rings Collected: 27",
    0x93930873: "Grand Metropolis Rose Act 2 Rings Collected: 28",
    0x93930874: "Grand Metropolis Rose Act 2 Rings Collected: 29",
    0x93930875: "Grand Metropolis Rose Act 2 Rings Collected: 30",
    0x93930876: "Grand Metropolis Rose Act 2 Rings Collected: 31",
    0x93930877: "Grand Metropolis Rose Act 2 Rings Collected: 32",
    0x93930878: "Grand Metropolis Rose Act 2 Rings Collected: 33",
    0x93930879: "Grand Metropolis Rose Act 2 Rings Collected: 34",
    0x9393087a: "Grand Metropolis Rose Act 2 Rings Collected: 35",
    0x9393087b: "Grand Metropolis Rose Act 2 Rings Collected: 36",
    0x9393087c: "Grand Metropolis Rose Act 2 Rings Collected: 37",
    0x9393087d: "Grand Metropolis Rose Act 2 Rings Collected: 38",
    0x9393087e: "Grand Metropolis Rose Act 2 Rings Collected: 39",
    0x9393087f: "Grand Metropolis Rose Act 2 Rings Collected: 40",
    0x93930880: "Grand Metropolis Rose Act 2 Rings Collected: 41",
    0x93930881: "Grand Metropolis Rose Act 2 Rings Collected: 42",
    0x93930882: "Grand Metropolis Rose Act 2 Rings Collected: 43",
    0x93930883: "Grand Metropolis Rose Act 2 Rings Collected: 44",
    0x93930884: "Grand Metropolis Rose Act 2 Rings Collected: 45",
    0x93930885: "Grand Metropolis Rose Act 2 Rings Collected: 46",
    0x93930886: "Grand Metropolis Rose Act 2 Rings Collected: 47",
    0x93930887: "Grand Metropolis Rose Act 2 Rings Collected: 48",
    0x93930888: "Grand Metropolis Rose Act 2 Rings Collected: 49",
    0x93930889: "Grand Metropolis Rose Act 2 Rings Collected: 50",
    0x9393088a: "Grand Metropolis Rose Act 2 Rings Collected: 51",
    0x9393088b: "Grand Metropolis Rose Act 2 Rings Collected: 52",
    0x9393088c: "Grand Metropolis Rose Act 2 Rings Collected: 53",
    0x9393088d: "Grand Metropolis Rose Act 2 Rings Collected: 54",
    0x9393088e: "Grand Metropolis Rose Act 2 Rings Collected: 55",
    0x9393088f: "Grand Metropolis Rose Act 2 Rings Collected: 56",
    0x93930890: "Grand Metropolis Rose Act 2 Rings Collected: 57",
    0x93930891: "Grand Metropolis Rose Act 2 Rings Collected: 58",
    0x93930892: "Grand Metropolis Rose Act 2 Rings Collected: 59",
    0x93930893: "Grand Metropolis Rose Act 2 Rings Collected: 60",
    0x93930894: "Grand Metropolis Rose Act 2 Rings Collected: 61",
    0x93930895: "Grand Metropolis Rose Act 2 Rings Collected: 62",
    0x93930896: "Grand Metropolis Rose Act 2 Rings Collected: 63",
    0x93930897: "Grand Metropolis Rose Act 2 Rings Collected: 64",
    0x93930898: "Grand Metropolis Rose Act 2 Rings Collected: 65",
    0x93930899: "Grand Metropolis Rose Act 2 Rings Collected: 66",
    0x9393089a: "Grand Metropolis Rose Act 2 Rings Collected: 67",
    0x9393089b: "Grand Metropolis Rose Act 2 Rings Collected: 68",
    0x9393089c: "Grand Metropolis Rose Act 2 Rings Collected: 69",
    0x9393089d: "Grand Metropolis Rose Act 2 Rings Collected: 70",
    0x9393089e: "Grand Metropolis Rose Act 2 Rings Collected: 71",
    0x9393089f: "Grand Metropolis Rose Act 2 Rings Collected: 72",
    0x939308a0: "Grand Metropolis Rose Act 2 Rings Collected: 73",
    0x939308a1: "Grand Metropolis Rose Act 2 Rings Collected: 74",
    0x939308a2: "Grand Metropolis Rose Act 2 Rings Collected: 75",
    0x939308a3: "Grand Metropolis Rose Act 2 Rings Collected: 76",
    0x939308a4: "Grand Metropolis Rose Act 2 Rings Collected: 77",
    0x939308a5: "Grand Metropolis Rose Act 2 Rings Collected: 78",
    0x939308a6: "Grand Metropolis Rose Act 2 Rings Collected: 79",
    0x939308a7: "Grand Metropolis Rose Act 2 Rings Collected: 80",
    0x939308a8: "Grand Metropolis Rose Act 2 Rings Collected: 81",
    0x939308a9: "Grand Metropolis Rose Act 2 Rings Collected: 82",
    0x939308aa: "Grand Metropolis Rose Act 2 Rings Collected: 83",
    0x939308ab: "Grand Metropolis Rose Act 2 Rings Collected: 84",
    0x939308ac: "Grand Metropolis Rose Act 2 Rings Collected: 85",
    0x939308ad: "Grand Metropolis Rose Act 2 Rings Collected: 86",
    0x939308ae: "Grand Metropolis Rose Act 2 Rings Collected: 87",
    0x939308af: "Grand Metropolis Rose Act 2 Rings Collected: 88",
    0x939308b0: "Grand Metropolis Rose Act 2 Rings Collected: 89",
    0x939308b1: "Grand Metropolis Rose Act 2 Rings Collected: 90",
    0x939308b2: "Grand Metropolis Rose Act 2 Rings Collected: 91",
    0x939308b3: "Grand Metropolis Rose Act 2 Rings Collected: 92",
    0x939308b4: "Grand Metropolis Rose Act 2 Rings Collected: 93",
    0x939308b5: "Grand Metropolis Rose Act 2 Rings Collected: 94",
    0x939308b6: "Grand Metropolis Rose Act 2 Rings Collected: 95",
    0x939308b7: "Grand Metropolis Rose Act 2 Rings Collected: 96",
    0x939308b8: "Grand Metropolis Rose Act 2 Rings Collected: 97",
    0x939308b9: "Grand Metropolis Rose Act 2 Rings Collected: 98",
    0x939308ba: "Grand Metropolis Rose Act 2 Rings Collected: 99",
    0x939308bb: "Grand Metropolis Rose Act 2 Rings Collected: 100",
    0x939308bc: "Grand Metropolis Rose Act 2 Rings Collected: 101",
    0x939308bd: "Grand Metropolis Rose Act 2 Rings Collected: 102",
    0x939308be: "Grand Metropolis Rose Act 2 Rings Collected: 103",
    0x939308bf: "Grand Metropolis Rose Act 2 Rings Collected: 104",
    0x939308c0: "Grand Metropolis Rose Act 2 Rings Collected: 105",
    0x939308c1: "Grand Metropolis Rose Act 2 Rings Collected: 106",
    0x939308c2: "Grand Metropolis Rose Act 2 Rings Collected: 107",
    0x939308c3: "Grand Metropolis Rose Act 2 Rings Collected: 108",
    0x939308c4: "Grand Metropolis Rose Act 2 Rings Collected: 109",
    0x939308c5: "Grand Metropolis Rose Act 2 Rings Collected: 110",
    0x939308c6: "Grand Metropolis Rose Act 2 Rings Collected: 111",
    0x939308c7: "Grand Metropolis Rose Act 2 Rings Collected: 112",
    0x939308c8: "Grand Metropolis Rose Act 2 Rings Collected: 113",
    0x939308c9: "Grand Metropolis Rose Act 2 Rings Collected: 114",
    0x939308ca: "Grand Metropolis Rose Act 2 Rings Collected: 115",
    0x939308cb: "Grand Metropolis Rose Act 2 Rings Collected: 116",
    0x939308cc: "Grand Metropolis Rose Act 2 Rings Collected: 117",
    0x939308cd: "Grand Metropolis Rose Act 2 Rings Collected: 118",
    0x939308ce: "Grand Metropolis Rose Act 2 Rings Collected: 119",
    0x939308cf: "Grand Metropolis Rose Act 2 Rings Collected: 120",
    0x939308d0: "Grand Metropolis Rose Act 2 Rings Collected: 121",
    0x939308d1: "Grand Metropolis Rose Act 2 Rings Collected: 122",
    0x939308d2: "Grand Metropolis Rose Act 2 Rings Collected: 123",
    0x939308d3: "Grand Metropolis Rose Act 2 Rings Collected: 124",
    0x939308d4: "Grand Metropolis Rose Act 2 Rings Collected: 125",
    0x939308d5: "Grand Metropolis Rose Act 2 Rings Collected: 126",
    0x939308d6: "Grand Metropolis Rose Act 2 Rings Collected: 127",
    0x939308d7: "Grand Metropolis Rose Act 2 Rings Collected: 128",
    0x939308d8: "Grand Metropolis Rose Act 2 Rings Collected: 129",
    0x939308d9: "Grand Metropolis Rose Act 2 Rings Collected: 130",
    0x939308da: "Grand Metropolis Rose Act 2 Rings Collected: 131",
    0x939308db: "Grand Metropolis Rose Act 2 Rings Collected: 132",
    0x939308dc: "Grand Metropolis Rose Act 2 Rings Collected: 133",
    0x939308dd: "Grand Metropolis Rose Act 2 Rings Collected: 134",
    0x939308de: "Grand Metropolis Rose Act 2 Rings Collected: 135",
    0x939308df: "Grand Metropolis Rose Act 2 Rings Collected: 136",
    0x939308e0: "Grand Metropolis Rose Act 2 Rings Collected: 137",
    0x939308e1: "Grand Metropolis Rose Act 2 Rings Collected: 138",
    0x939308e2: "Grand Metropolis Rose Act 2 Rings Collected: 139",
    0x939308e3: "Grand Metropolis Rose Act 2 Rings Collected: 140",
    0x939308e4: "Grand Metropolis Rose Act 2 Rings Collected: 141",
    0x939308e5: "Grand Metropolis Rose Act 2 Rings Collected: 142",
    0x939308e6: "Grand Metropolis Rose Act 2 Rings Collected: 143",
    0x939308e7: "Grand Metropolis Rose Act 2 Rings Collected: 144",
    0x939308e8: "Grand Metropolis Rose Act 2 Rings Collected: 145",
    0x939308e9: "Grand Metropolis Rose Act 2 Rings Collected: 146",
    0x939308ea: "Grand Metropolis Rose Act 2 Rings Collected: 147",
    0x939308eb: "Grand Metropolis Rose Act 2 Rings Collected: 148",
    0x939308ec: "Grand Metropolis Rose Act 2 Rings Collected: 149",
    0x939308ed: "Grand Metropolis Rose Act 2 Rings Collected: 150",
    0x939308ee: "Grand Metropolis Rose Act 2 Rings Collected: 151",
    0x939308ef: "Grand Metropolis Rose Act 2 Rings Collected: 152",
    0x939308f0: "Grand Metropolis Rose Act 2 Rings Collected: 153",
    0x939308f1: "Grand Metropolis Rose Act 2 Rings Collected: 154",
    0x939308f2: "Grand Metropolis Rose Act 2 Rings Collected: 155",
    0x939308f3: "Grand Metropolis Rose Act 2 Rings Collected: 156",
    0x939308f4: "Grand Metropolis Rose Act 2 Rings Collected: 157",
    0x939308f5: "Grand Metropolis Rose Act 2 Rings Collected: 158",
    0x939308f6: "Grand Metropolis Rose Act 2 Rings Collected: 159",
    0x939308f7: "Grand Metropolis Rose Act 2 Rings Collected: 160",
    0x939308f8: "Grand Metropolis Rose Act 2 Rings Collected: 161",
    0x939308f9: "Grand Metropolis Rose Act 2 Rings Collected: 162",
    0x939308fa: "Grand Metropolis Rose Act 2 Rings Collected: 163",
    0x939308fb: "Grand Metropolis Rose Act 2 Rings Collected: 164",
    0x939308fc: "Grand Metropolis Rose Act 2 Rings Collected: 165",
    0x939308fd: "Grand Metropolis Rose Act 2 Rings Collected: 166",
    0x939308fe: "Grand Metropolis Rose Act 2 Rings Collected: 167",
    0x939308ff: "Grand Metropolis Rose Act 2 Rings Collected: 168",
    0x93930900: "Grand Metropolis Rose Act 2 Rings Collected: 169",
    0x93930901: "Grand Metropolis Rose Act 2 Rings Collected: 170",
    0x93930902: "Grand Metropolis Rose Act 2 Rings Collected: 171",
    0x93930903: "Grand Metropolis Rose Act 2 Rings Collected: 172",
    0x93930904: "Grand Metropolis Rose Act 2 Rings Collected: 173",
    0x93930905: "Grand Metropolis Rose Act 2 Rings Collected: 174",
    0x93930906: "Grand Metropolis Rose Act 2 Rings Collected: 175",
    0x93930907: "Grand Metropolis Rose Act 2 Rings Collected: 176",
    0x93930908: "Grand Metropolis Rose Act 2 Rings Collected: 177",
    0x93930909: "Grand Metropolis Rose Act 2 Rings Collected: 178",
    0x9393090a: "Grand Metropolis Rose Act 2 Rings Collected: 179",
    0x9393090b: "Grand Metropolis Rose Act 2 Rings Collected: 180",
    0x9393090c: "Grand Metropolis Rose Act 2 Rings Collected: 181",
    0x9393090d: "Grand Metropolis Rose Act 2 Rings Collected: 182",
    0x9393090e: "Grand Metropolis Rose Act 2 Rings Collected: 183",
    0x9393090f: "Grand Metropolis Rose Act 2 Rings Collected: 184",
    0x93930910: "Grand Metropolis Rose Act 2 Rings Collected: 185",
    0x93930911: "Grand Metropolis Rose Act 2 Rings Collected: 186",
    0x93930912: "Grand Metropolis Rose Act 2 Rings Collected: 187",
    0x93930913: "Grand Metropolis Rose Act 2 Rings Collected: 188",
    0x93930914: "Grand Metropolis Rose Act 2 Rings Collected: 189",
    0x93930915: "Grand Metropolis Rose Act 2 Rings Collected: 190",
    0x93930916: "Grand Metropolis Rose Act 2 Rings Collected: 191",
    0x93930917: "Grand Metropolis Rose Act 2 Rings Collected: 192",
    0x93930918: "Grand Metropolis Rose Act 2 Rings Collected: 193",
    0x93930919: "Grand Metropolis Rose Act 2 Rings Collected: 194",
    0x9393091a: "Grand Metropolis Rose Act 2 Rings Collected: 195",
    0x9393091b: "Grand Metropolis Rose Act 2 Rings Collected: 196",
    0x9393091c: "Grand Metropolis Rose Act 2 Rings Collected: 197",
    0x9393091d: "Grand Metropolis Rose Act 2 Rings Collected: 198",
    0x9393091e: "Grand Metropolis Rose Act 2 Rings Collected: 199",
    0x9393091f: "Grand Metropolis Rose Act 2 Rings Collected: 200",
    0x93930920: "Power Plant Rose Act 2 Rings Collected: 1",
    0x93930921: "Power Plant Rose Act 2 Rings Collected: 2",
    0x93930922: "Power Plant Rose Act 2 Rings Collected: 3",
    0x93930923: "Power Plant Rose Act 2 Rings Collected: 4",
    0x93930924: "Power Plant Rose Act 2 Rings Collected: 5",
    0x93930925: "Power Plant Rose Act 2 Rings Collected: 6",
    0x93930926: "Power Plant Rose Act 2 Rings Collected: 7",
    0x93930927: "Power Plant Rose Act 2 Rings Collected: 8",
    0x93930928: "Power Plant Rose Act 2 Rings Collected: 9",
    0x93930929: "Power Plant Rose Act 2 Rings Collected: 10",
    0x9393092a: "Power Plant Rose Act 2 Rings Collected: 11",
    0x9393092b: "Power Plant Rose Act 2 Rings Collected: 12",
    0x9393092c: "Power Plant Rose Act 2 Rings Collected: 13",
    0x9393092d: "Power Plant Rose Act 2 Rings Collected: 14",
    0x9393092e: "Power Plant Rose Act 2 Rings Collected: 15",
    0x9393092f: "Power Plant Rose Act 2 Rings Collected: 16",
    0x93930930: "Power Plant Rose Act 2 Rings Collected: 17",
    0x93930931: "Power Plant Rose Act 2 Rings Collected: 18",
    0x93930932: "Power Plant Rose Act 2 Rings Collected: 19",
    0x93930933: "Power Plant Rose Act 2 Rings Collected: 20",
    0x93930934: "Power Plant Rose Act 2 Rings Collected: 21",
    0x93930935: "Power Plant Rose Act 2 Rings Collected: 22",
    0x93930936: "Power Plant Rose Act 2 Rings Collected: 23",
    0x93930937: "Power Plant Rose Act 2 Rings Collected: 24",
    0x93930938: "Power Plant Rose Act 2 Rings Collected: 25",
    0x93930939: "Power Plant Rose Act 2 Rings Collected: 26",
    0x9393093a: "Power Plant Rose Act 2 Rings Collected: 27",
    0x9393093b: "Power Plant Rose Act 2 Rings Collected: 28",
    0x9393093c: "Power Plant Rose Act 2 Rings Collected: 29",
    0x9393093d: "Power Plant Rose Act 2 Rings Collected: 30",
    0x9393093e: "Power Plant Rose Act 2 Rings Collected: 31",
    0x9393093f: "Power Plant Rose Act 2 Rings Collected: 32",
    0x93930940: "Power Plant Rose Act 2 Rings Collected: 33",
    0x93930941: "Power Plant Rose Act 2 Rings Collected: 34",
    0x93930942: "Power Plant Rose Act 2 Rings Collected: 35",
    0x93930943: "Power Plant Rose Act 2 Rings Collected: 36",
    0x93930944: "Power Plant Rose Act 2 Rings Collected: 37",
    0x93930945: "Power Plant Rose Act 2 Rings Collected: 38",
    0x93930946: "Power Plant Rose Act 2 Rings Collected: 39",
    0x93930947: "Power Plant Rose Act 2 Rings Collected: 40",
    0x93930948: "Power Plant Rose Act 2 Rings Collected: 41",
    0x93930949: "Power Plant Rose Act 2 Rings Collected: 42",
    0x9393094a: "Power Plant Rose Act 2 Rings Collected: 43",
    0x9393094b: "Power Plant Rose Act 2 Rings Collected: 44",
    0x9393094c: "Power Plant Rose Act 2 Rings Collected: 45",
    0x9393094d: "Power Plant Rose Act 2 Rings Collected: 46",
    0x9393094e: "Power Plant Rose Act 2 Rings Collected: 47",
    0x9393094f: "Power Plant Rose Act 2 Rings Collected: 48",
    0x93930950: "Power Plant Rose Act 2 Rings Collected: 49",
    0x93930951: "Power Plant Rose Act 2 Rings Collected: 50",
    0x93930952: "Power Plant Rose Act 2 Rings Collected: 51",
    0x93930953: "Power Plant Rose Act 2 Rings Collected: 52",
    0x93930954: "Power Plant Rose Act 2 Rings Collected: 53",
    0x93930955: "Power Plant Rose Act 2 Rings Collected: 54",
    0x93930956: "Power Plant Rose Act 2 Rings Collected: 55",
    0x93930957: "Power Plant Rose Act 2 Rings Collected: 56",
    0x93930958: "Power Plant Rose Act 2 Rings Collected: 57",
    0x93930959: "Power Plant Rose Act 2 Rings Collected: 58",
    0x9393095a: "Power Plant Rose Act 2 Rings Collected: 59",
    0x9393095b: "Power Plant Rose Act 2 Rings Collected: 60",
    0x9393095c: "Power Plant Rose Act 2 Rings Collected: 61",
    0x9393095d: "Power Plant Rose Act 2 Rings Collected: 62",
    0x9393095e: "Power Plant Rose Act 2 Rings Collected: 63",
    0x9393095f: "Power Plant Rose Act 2 Rings Collected: 64",
    0x93930960: "Power Plant Rose Act 2 Rings Collected: 65",
    0x93930961: "Power Plant Rose Act 2 Rings Collected: 66",
    0x93930962: "Power Plant Rose Act 2 Rings Collected: 67",
    0x93930963: "Power Plant Rose Act 2 Rings Collected: 68",
    0x93930964: "Power Plant Rose Act 2 Rings Collected: 69",
    0x93930965: "Power Plant Rose Act 2 Rings Collected: 70",
    0x93930966: "Power Plant Rose Act 2 Rings Collected: 71",
    0x93930967: "Power Plant Rose Act 2 Rings Collected: 72",
    0x93930968: "Power Plant Rose Act 2 Rings Collected: 73",
    0x93930969: "Power Plant Rose Act 2 Rings Collected: 74",
    0x9393096a: "Power Plant Rose Act 2 Rings Collected: 75",
    0x9393096b: "Power Plant Rose Act 2 Rings Collected: 76",
    0x9393096c: "Power Plant Rose Act 2 Rings Collected: 77",
    0x9393096d: "Power Plant Rose Act 2 Rings Collected: 78",
    0x9393096e: "Power Plant Rose Act 2 Rings Collected: 79",
    0x9393096f: "Power Plant Rose Act 2 Rings Collected: 80",
    0x93930970: "Power Plant Rose Act 2 Rings Collected: 81",
    0x93930971: "Power Plant Rose Act 2 Rings Collected: 82",
    0x93930972: "Power Plant Rose Act 2 Rings Collected: 83",
    0x93930973: "Power Plant Rose Act 2 Rings Collected: 84",
    0x93930974: "Power Plant Rose Act 2 Rings Collected: 85",
    0x93930975: "Power Plant Rose Act 2 Rings Collected: 86",
    0x93930976: "Power Plant Rose Act 2 Rings Collected: 87",
    0x93930977: "Power Plant Rose Act 2 Rings Collected: 88",
    0x93930978: "Power Plant Rose Act 2 Rings Collected: 89",
    0x93930979: "Power Plant Rose Act 2 Rings Collected: 90",
    0x9393097a: "Power Plant Rose Act 2 Rings Collected: 91",
    0x9393097b: "Power Plant Rose Act 2 Rings Collected: 92",
    0x9393097c: "Power Plant Rose Act 2 Rings Collected: 93",
    0x9393097d: "Power Plant Rose Act 2 Rings Collected: 94",
    0x9393097e: "Power Plant Rose Act 2 Rings Collected: 95",
    0x9393097f: "Power Plant Rose Act 2 Rings Collected: 96",
    0x93930980: "Power Plant Rose Act 2 Rings Collected: 97",
    0x93930981: "Power Plant Rose Act 2 Rings Collected: 98",
    0x93930982: "Power Plant Rose Act 2 Rings Collected: 99",
    0x93930983: "Power Plant Rose Act 2 Rings Collected: 100",
    0x93930984: "Power Plant Rose Act 2 Rings Collected: 101",
    0x93930985: "Power Plant Rose Act 2 Rings Collected: 102",
    0x93930986: "Power Plant Rose Act 2 Rings Collected: 103",
    0x93930987: "Power Plant Rose Act 2 Rings Collected: 104",
    0x93930988: "Power Plant Rose Act 2 Rings Collected: 105",
    0x93930989: "Power Plant Rose Act 2 Rings Collected: 106",
    0x9393098a: "Power Plant Rose Act 2 Rings Collected: 107",
    0x9393098b: "Power Plant Rose Act 2 Rings Collected: 108",
    0x9393098c: "Power Plant Rose Act 2 Rings Collected: 109",
    0x9393098d: "Power Plant Rose Act 2 Rings Collected: 110",
    0x9393098e: "Power Plant Rose Act 2 Rings Collected: 111",
    0x9393098f: "Power Plant Rose Act 2 Rings Collected: 112",
    0x93930990: "Power Plant Rose Act 2 Rings Collected: 113",
    0x93930991: "Power Plant Rose Act 2 Rings Collected: 114",
    0x93930992: "Power Plant Rose Act 2 Rings Collected: 115",
    0x93930993: "Power Plant Rose Act 2 Rings Collected: 116",
    0x93930994: "Power Plant Rose Act 2 Rings Collected: 117",
    0x93930995: "Power Plant Rose Act 2 Rings Collected: 118",
    0x93930996: "Power Plant Rose Act 2 Rings Collected: 119",
    0x93930997: "Power Plant Rose Act 2 Rings Collected: 120",
    0x93930998: "Power Plant Rose Act 2 Rings Collected: 121",
    0x93930999: "Power Plant Rose Act 2 Rings Collected: 122",
    0x9393099a: "Power Plant Rose Act 2 Rings Collected: 123",
    0x9393099b: "Power Plant Rose Act 2 Rings Collected: 124",
    0x9393099c: "Power Plant Rose Act 2 Rings Collected: 125",
    0x9393099d: "Power Plant Rose Act 2 Rings Collected: 126",
    0x9393099e: "Power Plant Rose Act 2 Rings Collected: 127",
    0x9393099f: "Power Plant Rose Act 2 Rings Collected: 128",
    0x939309a0: "Power Plant Rose Act 2 Rings Collected: 129",
    0x939309a1: "Power Plant Rose Act 2 Rings Collected: 130",
    0x939309a2: "Power Plant Rose Act 2 Rings Collected: 131",
    0x939309a3: "Power Plant Rose Act 2 Rings Collected: 132",
    0x939309a4: "Power Plant Rose Act 2 Rings Collected: 133",
    0x939309a5: "Power Plant Rose Act 2 Rings Collected: 134",
    0x939309a6: "Power Plant Rose Act 2 Rings Collected: 135",
    0x939309a7: "Power Plant Rose Act 2 Rings Collected: 136",
    0x939309a8: "Power Plant Rose Act 2 Rings Collected: 137",
    0x939309a9: "Power Plant Rose Act 2 Rings Collected: 138",
    0x939309aa: "Power Plant Rose Act 2 Rings Collected: 139",
    0x939309ab: "Power Plant Rose Act 2 Rings Collected: 140",
    0x939309ac: "Power Plant Rose Act 2 Rings Collected: 141",
    0x939309ad: "Power Plant Rose Act 2 Rings Collected: 142",
    0x939309ae: "Power Plant Rose Act 2 Rings Collected: 143",
    0x939309af: "Power Plant Rose Act 2 Rings Collected: 144",
    0x939309b0: "Power Plant Rose Act 2 Rings Collected: 145",
    0x939309b1: "Power Plant Rose Act 2 Rings Collected: 146",
    0x939309b2: "Power Plant Rose Act 2 Rings Collected: 147",
    0x939309b3: "Power Plant Rose Act 2 Rings Collected: 148",
    0x939309b4: "Power Plant Rose Act 2 Rings Collected: 149",
    0x939309b5: "Power Plant Rose Act 2 Rings Collected: 150",
    0x939309b6: "Power Plant Rose Act 2 Rings Collected: 151",
    0x939309b7: "Power Plant Rose Act 2 Rings Collected: 152",
    0x939309b8: "Power Plant Rose Act 2 Rings Collected: 153",
    0x939309b9: "Power Plant Rose Act 2 Rings Collected: 154",
    0x939309ba: "Power Plant Rose Act 2 Rings Collected: 155",
    0x939309bb: "Power Plant Rose Act 2 Rings Collected: 156",
    0x939309bc: "Power Plant Rose Act 2 Rings Collected: 157",
    0x939309bd: "Power Plant Rose Act 2 Rings Collected: 158",
    0x939309be: "Power Plant Rose Act 2 Rings Collected: 159",
    0x939309bf: "Power Plant Rose Act 2 Rings Collected: 160",
    0x939309c0: "Power Plant Rose Act 2 Rings Collected: 161",
    0x939309c1: "Power Plant Rose Act 2 Rings Collected: 162",
    0x939309c2: "Power Plant Rose Act 2 Rings Collected: 163",
    0x939309c3: "Power Plant Rose Act 2 Rings Collected: 164",
    0x939309c4: "Power Plant Rose Act 2 Rings Collected: 165",
    0x939309c5: "Power Plant Rose Act 2 Rings Collected: 166",
    0x939309c6: "Power Plant Rose Act 2 Rings Collected: 167",
    0x939309c7: "Power Plant Rose Act 2 Rings Collected: 168",
    0x939309c8: "Power Plant Rose Act 2 Rings Collected: 169",
    0x939309c9: "Power Plant Rose Act 2 Rings Collected: 170",
    0x939309ca: "Power Plant Rose Act 2 Rings Collected: 171",
    0x939309cb: "Power Plant Rose Act 2 Rings Collected: 172",
    0x939309cc: "Power Plant Rose Act 2 Rings Collected: 173",
    0x939309cd: "Power Plant Rose Act 2 Rings Collected: 174",
    0x939309ce: "Power Plant Rose Act 2 Rings Collected: 175",
    0x939309cf: "Power Plant Rose Act 2 Rings Collected: 176",
    0x939309d0: "Power Plant Rose Act 2 Rings Collected: 177",
    0x939309d1: "Power Plant Rose Act 2 Rings Collected: 178",
    0x939309d2: "Power Plant Rose Act 2 Rings Collected: 179",
    0x939309d3: "Power Plant Rose Act 2 Rings Collected: 180",
    0x939309d4: "Power Plant Rose Act 2 Rings Collected: 181",
    0x939309d5: "Power Plant Rose Act 2 Rings Collected: 182",
    0x939309d6: "Power Plant Rose Act 2 Rings Collected: 183",
    0x939309d7: "Power Plant Rose Act 2 Rings Collected: 184",
    0x939309d8: "Power Plant Rose Act 2 Rings Collected: 185",
    0x939309d9: "Power Plant Rose Act 2 Rings Collected: 186",
    0x939309da: "Power Plant Rose Act 2 Rings Collected: 187",
    0x939309db: "Power Plant Rose Act 2 Rings Collected: 188",
    0x939309dc: "Power Plant Rose Act 2 Rings Collected: 189",
    0x939309dd: "Power Plant Rose Act 2 Rings Collected: 190",
    0x939309de: "Power Plant Rose Act 2 Rings Collected: 191",
    0x939309df: "Power Plant Rose Act 2 Rings Collected: 192",
    0x939309e0: "Power Plant Rose Act 2 Rings Collected: 193",
    0x939309e1: "Power Plant Rose Act 2 Rings Collected: 194",
    0x939309e2: "Power Plant Rose Act 2 Rings Collected: 195",
    0x939309e3: "Power Plant Rose Act 2 Rings Collected: 196",
    0x939309e4: "Power Plant Rose Act 2 Rings Collected: 197",
    0x939309e5: "Power Plant Rose Act 2 Rings Collected: 198",
    0x939309e6: "Power Plant Rose Act 2 Rings Collected: 199",
    0x939309e7: "Power Plant Rose Act 2 Rings Collected: 200",
    0x939309e8: "Casino Park Rose Act 2 Rings Collected: 1",
    0x939309e9: "Casino Park Rose Act 2 Rings Collected: 2",
    0x939309ea: "Casino Park Rose Act 2 Rings Collected: 3",
    0x939309eb: "Casino Park Rose Act 2 Rings Collected: 4",
    0x939309ec: "Casino Park Rose Act 2 Rings Collected: 5",
    0x939309ed: "Casino Park Rose Act 2 Rings Collected: 6",
    0x939309ee: "Casino Park Rose Act 2 Rings Collected: 7",
    0x939309ef: "Casino Park Rose Act 2 Rings Collected: 8",
    0x939309f0: "Casino Park Rose Act 2 Rings Collected: 9",
    0x939309f1: "Casino Park Rose Act 2 Rings Collected: 10",
    0x939309f2: "Casino Park Rose Act 2 Rings Collected: 11",
    0x939309f3: "Casino Park Rose Act 2 Rings Collected: 12",
    0x939309f4: "Casino Park Rose Act 2 Rings Collected: 13",
    0x939309f5: "Casino Park Rose Act 2 Rings Collected: 14",
    0x939309f6: "Casino Park Rose Act 2 Rings Collected: 15",
    0x939309f7: "Casino Park Rose Act 2 Rings Collected: 16",
    0x939309f8: "Casino Park Rose Act 2 Rings Collected: 17",
    0x939309f9: "Casino Park Rose Act 2 Rings Collected: 18",
    0x939309fa: "Casino Park Rose Act 2 Rings Collected: 19",
    0x939309fb: "Casino Park Rose Act 2 Rings Collected: 20",
    0x939309fc: "Casino Park Rose Act 2 Rings Collected: 21",
    0x939309fd: "Casino Park Rose Act 2 Rings Collected: 22",
    0x939309fe: "Casino Park Rose Act 2 Rings Collected: 23",
    0x939309ff: "Casino Park Rose Act 2 Rings Collected: 24",
    0x93930a00: "Casino Park Rose Act 2 Rings Collected: 25",
    0x93930a01: "Casino Park Rose Act 2 Rings Collected: 26",
    0x93930a02: "Casino Park Rose Act 2 Rings Collected: 27",
    0x93930a03: "Casino Park Rose Act 2 Rings Collected: 28",
    0x93930a04: "Casino Park Rose Act 2 Rings Collected: 29",
    0x93930a05: "Casino Park Rose Act 2 Rings Collected: 30",
    0x93930a06: "Casino Park Rose Act 2 Rings Collected: 31",
    0x93930a07: "Casino Park Rose Act 2 Rings Collected: 32",
    0x93930a08: "Casino Park Rose Act 2 Rings Collected: 33",
    0x93930a09: "Casino Park Rose Act 2 Rings Collected: 34",
    0x93930a0a: "Casino Park Rose Act 2 Rings Collected: 35",
    0x93930a0b: "Casino Park Rose Act 2 Rings Collected: 36",
    0x93930a0c: "Casino Park Rose Act 2 Rings Collected: 37",
    0x93930a0d: "Casino Park Rose Act 2 Rings Collected: 38",
    0x93930a0e: "Casino Park Rose Act 2 Rings Collected: 39",
    0x93930a0f: "Casino Park Rose Act 2 Rings Collected: 40",
    0x93930a10: "Casino Park Rose Act 2 Rings Collected: 41",
    0x93930a11: "Casino Park Rose Act 2 Rings Collected: 42",
    0x93930a12: "Casino Park Rose Act 2 Rings Collected: 43",
    0x93930a13: "Casino Park Rose Act 2 Rings Collected: 44",
    0x93930a14: "Casino Park Rose Act 2 Rings Collected: 45",
    0x93930a15: "Casino Park Rose Act 2 Rings Collected: 46",
    0x93930a16: "Casino Park Rose Act 2 Rings Collected: 47",
    0x93930a17: "Casino Park Rose Act 2 Rings Collected: 48",
    0x93930a18: "Casino Park Rose Act 2 Rings Collected: 49",
    0x93930a19: "Casino Park Rose Act 2 Rings Collected: 50",
    0x93930a1a: "Casino Park Rose Act 2 Rings Collected: 51",
    0x93930a1b: "Casino Park Rose Act 2 Rings Collected: 52",
    0x93930a1c: "Casino Park Rose Act 2 Rings Collected: 53",
    0x93930a1d: "Casino Park Rose Act 2 Rings Collected: 54",
    0x93930a1e: "Casino Park Rose Act 2 Rings Collected: 55",
    0x93930a1f: "Casino Park Rose Act 2 Rings Collected: 56",
    0x93930a20: "Casino Park Rose Act 2 Rings Collected: 57",
    0x93930a21: "Casino Park Rose Act 2 Rings Collected: 58",
    0x93930a22: "Casino Park Rose Act 2 Rings Collected: 59",
    0x93930a23: "Casino Park Rose Act 2 Rings Collected: 60",
    0x93930a24: "Casino Park Rose Act 2 Rings Collected: 61",
    0x93930a25: "Casino Park Rose Act 2 Rings Collected: 62",
    0x93930a26: "Casino Park Rose Act 2 Rings Collected: 63",
    0x93930a27: "Casino Park Rose Act 2 Rings Collected: 64",
    0x93930a28: "Casino Park Rose Act 2 Rings Collected: 65",
    0x93930a29: "Casino Park Rose Act 2 Rings Collected: 66",
    0x93930a2a: "Casino Park Rose Act 2 Rings Collected: 67",
    0x93930a2b: "Casino Park Rose Act 2 Rings Collected: 68",
    0x93930a2c: "Casino Park Rose Act 2 Rings Collected: 69",
    0x93930a2d: "Casino Park Rose Act 2 Rings Collected: 70",
    0x93930a2e: "Casino Park Rose Act 2 Rings Collected: 71",
    0x93930a2f: "Casino Park Rose Act 2 Rings Collected: 72",
    0x93930a30: "Casino Park Rose Act 2 Rings Collected: 73",
    0x93930a31: "Casino Park Rose Act 2 Rings Collected: 74",
    0x93930a32: "Casino Park Rose Act 2 Rings Collected: 75",
    0x93930a33: "Casino Park Rose Act 2 Rings Collected: 76",
    0x93930a34: "Casino Park Rose Act 2 Rings Collected: 77",
    0x93930a35: "Casino Park Rose Act 2 Rings Collected: 78",
    0x93930a36: "Casino Park Rose Act 2 Rings Collected: 79",
    0x93930a37: "Casino Park Rose Act 2 Rings Collected: 80",
    0x93930a38: "Casino Park Rose Act 2 Rings Collected: 81",
    0x93930a39: "Casino Park Rose Act 2 Rings Collected: 82",
    0x93930a3a: "Casino Park Rose Act 2 Rings Collected: 83",
    0x93930a3b: "Casino Park Rose Act 2 Rings Collected: 84",
    0x93930a3c: "Casino Park Rose Act 2 Rings Collected: 85",
    0x93930a3d: "Casino Park Rose Act 2 Rings Collected: 86",
    0x93930a3e: "Casino Park Rose Act 2 Rings Collected: 87",
    0x93930a3f: "Casino Park Rose Act 2 Rings Collected: 88",
    0x93930a40: "Casino Park Rose Act 2 Rings Collected: 89",
    0x93930a41: "Casino Park Rose Act 2 Rings Collected: 90",
    0x93930a42: "Casino Park Rose Act 2 Rings Collected: 91",
    0x93930a43: "Casino Park Rose Act 2 Rings Collected: 92",
    0x93930a44: "Casino Park Rose Act 2 Rings Collected: 93",
    0x93930a45: "Casino Park Rose Act 2 Rings Collected: 94",
    0x93930a46: "Casino Park Rose Act 2 Rings Collected: 95",
    0x93930a47: "Casino Park Rose Act 2 Rings Collected: 96",
    0x93930a48: "Casino Park Rose Act 2 Rings Collected: 97",
    0x93930a49: "Casino Park Rose Act 2 Rings Collected: 98",
    0x93930a4a: "Casino Park Rose Act 2 Rings Collected: 99",
    0x93930a4b: "Casino Park Rose Act 2 Rings Collected: 100",
    0x93930a4c: "Casino Park Rose Act 2 Rings Collected: 101",
    0x93930a4d: "Casino Park Rose Act 2 Rings Collected: 102",
    0x93930a4e: "Casino Park Rose Act 2 Rings Collected: 103",
    0x93930a4f: "Casino Park Rose Act 2 Rings Collected: 104",
    0x93930a50: "Casino Park Rose Act 2 Rings Collected: 105",
    0x93930a51: "Casino Park Rose Act 2 Rings Collected: 106",
    0x93930a52: "Casino Park Rose Act 2 Rings Collected: 107",
    0x93930a53: "Casino Park Rose Act 2 Rings Collected: 108",
    0x93930a54: "Casino Park Rose Act 2 Rings Collected: 109",
    0x93930a55: "Casino Park Rose Act 2 Rings Collected: 110",
    0x93930a56: "Casino Park Rose Act 2 Rings Collected: 111",
    0x93930a57: "Casino Park Rose Act 2 Rings Collected: 112",
    0x93930a58: "Casino Park Rose Act 2 Rings Collected: 113",
    0x93930a59: "Casino Park Rose Act 2 Rings Collected: 114",
    0x93930a5a: "Casino Park Rose Act 2 Rings Collected: 115",
    0x93930a5b: "Casino Park Rose Act 2 Rings Collected: 116",
    0x93930a5c: "Casino Park Rose Act 2 Rings Collected: 117",
    0x93930a5d: "Casino Park Rose Act 2 Rings Collected: 118",
    0x93930a5e: "Casino Park Rose Act 2 Rings Collected: 119",
    0x93930a5f: "Casino Park Rose Act 2 Rings Collected: 120",
    0x93930a60: "Casino Park Rose Act 2 Rings Collected: 121",
    0x93930a61: "Casino Park Rose Act 2 Rings Collected: 122",
    0x93930a62: "Casino Park Rose Act 2 Rings Collected: 123",
    0x93930a63: "Casino Park Rose Act 2 Rings Collected: 124",
    0x93930a64: "Casino Park Rose Act 2 Rings Collected: 125",
    0x93930a65: "Casino Park Rose Act 2 Rings Collected: 126",
    0x93930a66: "Casino Park Rose Act 2 Rings Collected: 127",
    0x93930a67: "Casino Park Rose Act 2 Rings Collected: 128",
    0x93930a68: "Casino Park Rose Act 2 Rings Collected: 129",
    0x93930a69: "Casino Park Rose Act 2 Rings Collected: 130",
    0x93930a6a: "Casino Park Rose Act 2 Rings Collected: 131",
    0x93930a6b: "Casino Park Rose Act 2 Rings Collected: 132",
    0x93930a6c: "Casino Park Rose Act 2 Rings Collected: 133",
    0x93930a6d: "Casino Park Rose Act 2 Rings Collected: 134",
    0x93930a6e: "Casino Park Rose Act 2 Rings Collected: 135",
    0x93930a6f: "Casino Park Rose Act 2 Rings Collected: 136",
    0x93930a70: "Casino Park Rose Act 2 Rings Collected: 137",
    0x93930a71: "Casino Park Rose Act 2 Rings Collected: 138",
    0x93930a72: "Casino Park Rose Act 2 Rings Collected: 139",
    0x93930a73: "Casino Park Rose Act 2 Rings Collected: 140",
    0x93930a74: "Casino Park Rose Act 2 Rings Collected: 141",
    0x93930a75: "Casino Park Rose Act 2 Rings Collected: 142",
    0x93930a76: "Casino Park Rose Act 2 Rings Collected: 143",
    0x93930a77: "Casino Park Rose Act 2 Rings Collected: 144",
    0x93930a78: "Casino Park Rose Act 2 Rings Collected: 145",
    0x93930a79: "Casino Park Rose Act 2 Rings Collected: 146",
    0x93930a7a: "Casino Park Rose Act 2 Rings Collected: 147",
    0x93930a7b: "Casino Park Rose Act 2 Rings Collected: 148",
    0x93930a7c: "Casino Park Rose Act 2 Rings Collected: 149",
    0x93930a7d: "Casino Park Rose Act 2 Rings Collected: 150",
    0x93930a7e: "Casino Park Rose Act 2 Rings Collected: 151",
    0x93930a7f: "Casino Park Rose Act 2 Rings Collected: 152",
    0x93930a80: "Casino Park Rose Act 2 Rings Collected: 153",
    0x93930a81: "Casino Park Rose Act 2 Rings Collected: 154",
    0x93930a82: "Casino Park Rose Act 2 Rings Collected: 155",
    0x93930a83: "Casino Park Rose Act 2 Rings Collected: 156",
    0x93930a84: "Casino Park Rose Act 2 Rings Collected: 157",
    0x93930a85: "Casino Park Rose Act 2 Rings Collected: 158",
    0x93930a86: "Casino Park Rose Act 2 Rings Collected: 159",
    0x93930a87: "Casino Park Rose Act 2 Rings Collected: 160",
    0x93930a88: "Casino Park Rose Act 2 Rings Collected: 161",
    0x93930a89: "Casino Park Rose Act 2 Rings Collected: 162",
    0x93930a8a: "Casino Park Rose Act 2 Rings Collected: 163",
    0x93930a8b: "Casino Park Rose Act 2 Rings Collected: 164",
    0x93930a8c: "Casino Park Rose Act 2 Rings Collected: 165",
    0x93930a8d: "Casino Park Rose Act 2 Rings Collected: 166",
    0x93930a8e: "Casino Park Rose Act 2 Rings Collected: 167",
    0x93930a8f: "Casino Park Rose Act 2 Rings Collected: 168",
    0x93930a90: "Casino Park Rose Act 2 Rings Collected: 169",
    0x93930a91: "Casino Park Rose Act 2 Rings Collected: 170",
    0x93930a92: "Casino Park Rose Act 2 Rings Collected: 171",
    0x93930a93: "Casino Park Rose Act 2 Rings Collected: 172",
    0x93930a94: "Casino Park Rose Act 2 Rings Collected: 173",
    0x93930a95: "Casino Park Rose Act 2 Rings Collected: 174",
    0x93930a96: "Casino Park Rose Act 2 Rings Collected: 175",
    0x93930a97: "Casino Park Rose Act 2 Rings Collected: 176",
    0x93930a98: "Casino Park Rose Act 2 Rings Collected: 177",
    0x93930a99: "Casino Park Rose Act 2 Rings Collected: 178",
    0x93930a9a: "Casino Park Rose Act 2 Rings Collected: 179",
    0x93930a9b: "Casino Park Rose Act 2 Rings Collected: 180",
    0x93930a9c: "Casino Park Rose Act 2 Rings Collected: 181",
    0x93930a9d: "Casino Park Rose Act 2 Rings Collected: 182",
    0x93930a9e: "Casino Park Rose Act 2 Rings Collected: 183",
    0x93930a9f: "Casino Park Rose Act 2 Rings Collected: 184",
    0x93930aa0: "Casino Park Rose Act 2 Rings Collected: 185",
    0x93930aa1: "Casino Park Rose Act 2 Rings Collected: 186",
    0x93930aa2: "Casino Park Rose Act 2 Rings Collected: 187",
    0x93930aa3: "Casino Park Rose Act 2 Rings Collected: 188",
    0x93930aa4: "Casino Park Rose Act 2 Rings Collected: 189",
    0x93930aa5: "Casino Park Rose Act 2 Rings Collected: 190",
    0x93930aa6: "Casino Park Rose Act 2 Rings Collected: 191",
    0x93930aa7: "Casino Park Rose Act 2 Rings Collected: 192",
    0x93930aa8: "Casino Park Rose Act 2 Rings Collected: 193",
    0x93930aa9: "Casino Park Rose Act 2 Rings Collected: 194",
    0x93930aaa: "Casino Park Rose Act 2 Rings Collected: 195",
    0x93930aab: "Casino Park Rose Act 2 Rings Collected: 196",
    0x93930aac: "Casino Park Rose Act 2 Rings Collected: 197",
    0x93930aad: "Casino Park Rose Act 2 Rings Collected: 198",
    0x93930aae: "Casino Park Rose Act 2 Rings Collected: 199",
    0x93930aaf: "Casino Park Rose Act 2 Rings Collected: 200",
    0x93930ab0: "Bingo Highway Rose Act 2 Rings Collected: 1",
    0x93930ab1: "Bingo Highway Rose Act 2 Rings Collected: 2",
    0x93930ab2: "Bingo Highway Rose Act 2 Rings Collected: 3",
    0x93930ab3: "Bingo Highway Rose Act 2 Rings Collected: 4",
    0x93930ab4: "Bingo Highway Rose Act 2 Rings Collected: 5",
    0x93930ab5: "Bingo Highway Rose Act 2 Rings Collected: 6",
    0x93930ab6: "Bingo Highway Rose Act 2 Rings Collected: 7",
    0x93930ab7: "Bingo Highway Rose Act 2 Rings Collected: 8",
    0x93930ab8: "Bingo Highway Rose Act 2 Rings Collected: 9",
    0x93930ab9: "Bingo Highway Rose Act 2 Rings Collected: 10",
    0x93930aba: "Bingo Highway Rose Act 2 Rings Collected: 11",
    0x93930abb: "Bingo Highway Rose Act 2 Rings Collected: 12",
    0x93930abc: "Bingo Highway Rose Act 2 Rings Collected: 13",
    0x93930abd: "Bingo Highway Rose Act 2 Rings Collected: 14",
    0x93930abe: "Bingo Highway Rose Act 2 Rings Collected: 15",
    0x93930abf: "Bingo Highway Rose Act 2 Rings Collected: 16",
    0x93930ac0: "Bingo Highway Rose Act 2 Rings Collected: 17",
    0x93930ac1: "Bingo Highway Rose Act 2 Rings Collected: 18",
    0x93930ac2: "Bingo Highway Rose Act 2 Rings Collected: 19",
    0x93930ac3: "Bingo Highway Rose Act 2 Rings Collected: 20",
    0x93930ac4: "Bingo Highway Rose Act 2 Rings Collected: 21",
    0x93930ac5: "Bingo Highway Rose Act 2 Rings Collected: 22",
    0x93930ac6: "Bingo Highway Rose Act 2 Rings Collected: 23",
    0x93930ac7: "Bingo Highway Rose Act 2 Rings Collected: 24",
    0x93930ac8: "Bingo Highway Rose Act 2 Rings Collected: 25",
    0x93930ac9: "Bingo Highway Rose Act 2 Rings Collected: 26",
    0x93930aca: "Bingo Highway Rose Act 2 Rings Collected: 27",
    0x93930acb: "Bingo Highway Rose Act 2 Rings Collected: 28",
    0x93930acc: "Bingo Highway Rose Act 2 Rings Collected: 29",
    0x93930acd: "Bingo Highway Rose Act 2 Rings Collected: 30",
    0x93930ace: "Bingo Highway Rose Act 2 Rings Collected: 31",
    0x93930acf: "Bingo Highway Rose Act 2 Rings Collected: 32",
    0x93930ad0: "Bingo Highway Rose Act 2 Rings Collected: 33",
    0x93930ad1: "Bingo Highway Rose Act 2 Rings Collected: 34",
    0x93930ad2: "Bingo Highway Rose Act 2 Rings Collected: 35",
    0x93930ad3: "Bingo Highway Rose Act 2 Rings Collected: 36",
    0x93930ad4: "Bingo Highway Rose Act 2 Rings Collected: 37",
    0x93930ad5: "Bingo Highway Rose Act 2 Rings Collected: 38",
    0x93930ad6: "Bingo Highway Rose Act 2 Rings Collected: 39",
    0x93930ad7: "Bingo Highway Rose Act 2 Rings Collected: 40",
    0x93930ad8: "Bingo Highway Rose Act 2 Rings Collected: 41",
    0x93930ad9: "Bingo Highway Rose Act 2 Rings Collected: 42",
    0x93930ada: "Bingo Highway Rose Act 2 Rings Collected: 43",
    0x93930adb: "Bingo Highway Rose Act 2 Rings Collected: 44",
    0x93930adc: "Bingo Highway Rose Act 2 Rings Collected: 45",
    0x93930add: "Bingo Highway Rose Act 2 Rings Collected: 46",
    0x93930ade: "Bingo Highway Rose Act 2 Rings Collected: 47",
    0x93930adf: "Bingo Highway Rose Act 2 Rings Collected: 48",
    0x93930ae0: "Bingo Highway Rose Act 2 Rings Collected: 49",
    0x93930ae1: "Bingo Highway Rose Act 2 Rings Collected: 50",
    0x93930ae2: "Bingo Highway Rose Act 2 Rings Collected: 51",
    0x93930ae3: "Bingo Highway Rose Act 2 Rings Collected: 52",
    0x93930ae4: "Bingo Highway Rose Act 2 Rings Collected: 53",
    0x93930ae5: "Bingo Highway Rose Act 2 Rings Collected: 54",
    0x93930ae6: "Bingo Highway Rose Act 2 Rings Collected: 55",
    0x93930ae7: "Bingo Highway Rose Act 2 Rings Collected: 56",
    0x93930ae8: "Bingo Highway Rose Act 2 Rings Collected: 57",
    0x93930ae9: "Bingo Highway Rose Act 2 Rings Collected: 58",
    0x93930aea: "Bingo Highway Rose Act 2 Rings Collected: 59",
    0x93930aeb: "Bingo Highway Rose Act 2 Rings Collected: 60",
    0x93930aec: "Bingo Highway Rose Act 2 Rings Collected: 61",
    0x93930aed: "Bingo Highway Rose Act 2 Rings Collected: 62",
    0x93930aee: "Bingo Highway Rose Act 2 Rings Collected: 63",
    0x93930aef: "Bingo Highway Rose Act 2 Rings Collected: 64",
    0x93930af0: "Bingo Highway Rose Act 2 Rings Collected: 65",
    0x93930af1: "Bingo Highway Rose Act 2 Rings Collected: 66",
    0x93930af2: "Bingo Highway Rose Act 2 Rings Collected: 67",
    0x93930af3: "Bingo Highway Rose Act 2 Rings Collected: 68",
    0x93930af4: "Bingo Highway Rose Act 2 Rings Collected: 69",
    0x93930af5: "Bingo Highway Rose Act 2 Rings Collected: 70",
    0x93930af6: "Bingo Highway Rose Act 2 Rings Collected: 71",
    0x93930af7: "Bingo Highway Rose Act 2 Rings Collected: 72",
    0x93930af8: "Bingo Highway Rose Act 2 Rings Collected: 73",
    0x93930af9: "Bingo Highway Rose Act 2 Rings Collected: 74",
    0x93930afa: "Bingo Highway Rose Act 2 Rings Collected: 75",
    0x93930afb: "Bingo Highway Rose Act 2 Rings Collected: 76",
    0x93930afc: "Bingo Highway Rose Act 2 Rings Collected: 77",
    0x93930afd: "Bingo Highway Rose Act 2 Rings Collected: 78",
    0x93930afe: "Bingo Highway Rose Act 2 Rings Collected: 79",
    0x93930aff: "Bingo Highway Rose Act 2 Rings Collected: 80",
    0x93930b00: "Bingo Highway Rose Act 2 Rings Collected: 81",
    0x93930b01: "Bingo Highway Rose Act 2 Rings Collected: 82",
    0x93930b02: "Bingo Highway Rose Act 2 Rings Collected: 83",
    0x93930b03: "Bingo Highway Rose Act 2 Rings Collected: 84",
    0x93930b04: "Bingo Highway Rose Act 2 Rings Collected: 85",
    0x93930b05: "Bingo Highway Rose Act 2 Rings Collected: 86",
    0x93930b06: "Bingo Highway Rose Act 2 Rings Collected: 87",
    0x93930b07: "Bingo Highway Rose Act 2 Rings Collected: 88",
    0x93930b08: "Bingo Highway Rose Act 2 Rings Collected: 89",
    0x93930b09: "Bingo Highway Rose Act 2 Rings Collected: 90",
    0x93930b0a: "Bingo Highway Rose Act 2 Rings Collected: 91",
    0x93930b0b: "Bingo Highway Rose Act 2 Rings Collected: 92",
    0x93930b0c: "Bingo Highway Rose Act 2 Rings Collected: 93",
    0x93930b0d: "Bingo Highway Rose Act 2 Rings Collected: 94",
    0x93930b0e: "Bingo Highway Rose Act 2 Rings Collected: 95",
    0x93930b0f: "Bingo Highway Rose Act 2 Rings Collected: 96",
    0x93930b10: "Bingo Highway Rose Act 2 Rings Collected: 97",
    0x93930b11: "Bingo Highway Rose Act 2 Rings Collected: 98",
    0x93930b12: "Bingo Highway Rose Act 2 Rings Collected: 99",
    0x93930b13: "Bingo Highway Rose Act 2 Rings Collected: 100",
    0x93930b14: "Bingo Highway Rose Act 2 Rings Collected: 101",
    0x93930b15: "Bingo Highway Rose Act 2 Rings Collected: 102",
    0x93930b16: "Bingo Highway Rose Act 2 Rings Collected: 103",
    0x93930b17: "Bingo Highway Rose Act 2 Rings Collected: 104",
    0x93930b18: "Bingo Highway Rose Act 2 Rings Collected: 105",
    0x93930b19: "Bingo Highway Rose Act 2 Rings Collected: 106",
    0x93930b1a: "Bingo Highway Rose Act 2 Rings Collected: 107",
    0x93930b1b: "Bingo Highway Rose Act 2 Rings Collected: 108",
    0x93930b1c: "Bingo Highway Rose Act 2 Rings Collected: 109",
    0x93930b1d: "Bingo Highway Rose Act 2 Rings Collected: 110",
    0x93930b1e: "Bingo Highway Rose Act 2 Rings Collected: 111",
    0x93930b1f: "Bingo Highway Rose Act 2 Rings Collected: 112",
    0x93930b20: "Bingo Highway Rose Act 2 Rings Collected: 113",
    0x93930b21: "Bingo Highway Rose Act 2 Rings Collected: 114",
    0x93930b22: "Bingo Highway Rose Act 2 Rings Collected: 115",
    0x93930b23: "Bingo Highway Rose Act 2 Rings Collected: 116",
    0x93930b24: "Bingo Highway Rose Act 2 Rings Collected: 117",
    0x93930b25: "Bingo Highway Rose Act 2 Rings Collected: 118",
    0x93930b26: "Bingo Highway Rose Act 2 Rings Collected: 119",
    0x93930b27: "Bingo Highway Rose Act 2 Rings Collected: 120",
    0x93930b28: "Bingo Highway Rose Act 2 Rings Collected: 121",
    0x93930b29: "Bingo Highway Rose Act 2 Rings Collected: 122",
    0x93930b2a: "Bingo Highway Rose Act 2 Rings Collected: 123",
    0x93930b2b: "Bingo Highway Rose Act 2 Rings Collected: 124",
    0x93930b2c: "Bingo Highway Rose Act 2 Rings Collected: 125",
    0x93930b2d: "Bingo Highway Rose Act 2 Rings Collected: 126",
    0x93930b2e: "Bingo Highway Rose Act 2 Rings Collected: 127",
    0x93930b2f: "Bingo Highway Rose Act 2 Rings Collected: 128",
    0x93930b30: "Bingo Highway Rose Act 2 Rings Collected: 129",
    0x93930b31: "Bingo Highway Rose Act 2 Rings Collected: 130",
    0x93930b32: "Bingo Highway Rose Act 2 Rings Collected: 131",
    0x93930b33: "Bingo Highway Rose Act 2 Rings Collected: 132",
    0x93930b34: "Bingo Highway Rose Act 2 Rings Collected: 133",
    0x93930b35: "Bingo Highway Rose Act 2 Rings Collected: 134",
    0x93930b36: "Bingo Highway Rose Act 2 Rings Collected: 135",
    0x93930b37: "Bingo Highway Rose Act 2 Rings Collected: 136",
    0x93930b38: "Bingo Highway Rose Act 2 Rings Collected: 137",
    0x93930b39: "Bingo Highway Rose Act 2 Rings Collected: 138",
    0x93930b3a: "Bingo Highway Rose Act 2 Rings Collected: 139",
    0x93930b3b: "Bingo Highway Rose Act 2 Rings Collected: 140",
    0x93930b3c: "Bingo Highway Rose Act 2 Rings Collected: 141",
    0x93930b3d: "Bingo Highway Rose Act 2 Rings Collected: 142",
    0x93930b3e: "Bingo Highway Rose Act 2 Rings Collected: 143",
    0x93930b3f: "Bingo Highway Rose Act 2 Rings Collected: 144",
    0x93930b40: "Bingo Highway Rose Act 2 Rings Collected: 145",
    0x93930b41: "Bingo Highway Rose Act 2 Rings Collected: 146",
    0x93930b42: "Bingo Highway Rose Act 2 Rings Collected: 147",
    0x93930b43: "Bingo Highway Rose Act 2 Rings Collected: 148",
    0x93930b44: "Bingo Highway Rose Act 2 Rings Collected: 149",
    0x93930b45: "Bingo Highway Rose Act 2 Rings Collected: 150",
    0x93930b46: "Bingo Highway Rose Act 2 Rings Collected: 151",
    0x93930b47: "Bingo Highway Rose Act 2 Rings Collected: 152",
    0x93930b48: "Bingo Highway Rose Act 2 Rings Collected: 153",
    0x93930b49: "Bingo Highway Rose Act 2 Rings Collected: 154",
    0x93930b4a: "Bingo Highway Rose Act 2 Rings Collected: 155",
    0x93930b4b: "Bingo Highway Rose Act 2 Rings Collected: 156",
    0x93930b4c: "Bingo Highway Rose Act 2 Rings Collected: 157",
    0x93930b4d: "Bingo Highway Rose Act 2 Rings Collected: 158",
    0x93930b4e: "Bingo Highway Rose Act 2 Rings Collected: 159",
    0x93930b4f: "Bingo Highway Rose Act 2 Rings Collected: 160",
    0x93930b50: "Bingo Highway Rose Act 2 Rings Collected: 161",
    0x93930b51: "Bingo Highway Rose Act 2 Rings Collected: 162",
    0x93930b52: "Bingo Highway Rose Act 2 Rings Collected: 163",
    0x93930b53: "Bingo Highway Rose Act 2 Rings Collected: 164",
    0x93930b54: "Bingo Highway Rose Act 2 Rings Collected: 165",
    0x93930b55: "Bingo Highway Rose Act 2 Rings Collected: 166",
    0x93930b56: "Bingo Highway Rose Act 2 Rings Collected: 167",
    0x93930b57: "Bingo Highway Rose Act 2 Rings Collected: 168",
    0x93930b58: "Bingo Highway Rose Act 2 Rings Collected: 169",
    0x93930b59: "Bingo Highway Rose Act 2 Rings Collected: 170",
    0x93930b5a: "Bingo Highway Rose Act 2 Rings Collected: 171",
    0x93930b5b: "Bingo Highway Rose Act 2 Rings Collected: 172",
    0x93930b5c: "Bingo Highway Rose Act 2 Rings Collected: 173",
    0x93930b5d: "Bingo Highway Rose Act 2 Rings Collected: 174",
    0x93930b5e: "Bingo Highway Rose Act 2 Rings Collected: 175",
    0x93930b5f: "Bingo Highway Rose Act 2 Rings Collected: 176",
    0x93930b60: "Bingo Highway Rose Act 2 Rings Collected: 177",
    0x93930b61: "Bingo Highway Rose Act 2 Rings Collected: 178",
    0x93930b62: "Bingo Highway Rose Act 2 Rings Collected: 179",
    0x93930b63: "Bingo Highway Rose Act 2 Rings Collected: 180",
    0x93930b64: "Bingo Highway Rose Act 2 Rings Collected: 181",
    0x93930b65: "Bingo Highway Rose Act 2 Rings Collected: 182",
    0x93930b66: "Bingo Highway Rose Act 2 Rings Collected: 183",
    0x93930b67: "Bingo Highway Rose Act 2 Rings Collected: 184",
    0x93930b68: "Bingo Highway Rose Act 2 Rings Collected: 185",
    0x93930b69: "Bingo Highway Rose Act 2 Rings Collected: 186",
    0x93930b6a: "Bingo Highway Rose Act 2 Rings Collected: 187",
    0x93930b6b: "Bingo Highway Rose Act 2 Rings Collected: 188",
    0x93930b6c: "Bingo Highway Rose Act 2 Rings Collected: 189",
    0x93930b6d: "Bingo Highway Rose Act 2 Rings Collected: 190",
    0x93930b6e: "Bingo Highway Rose Act 2 Rings Collected: 191",
    0x93930b6f: "Bingo Highway Rose Act 2 Rings Collected: 192",
    0x93930b70: "Bingo Highway Rose Act 2 Rings Collected: 193",
    0x93930b71: "Bingo Highway Rose Act 2 Rings Collected: 194",
    0x93930b72: "Bingo Highway Rose Act 2 Rings Collected: 195",
    0x93930b73: "Bingo Highway Rose Act 2 Rings Collected: 196",
    0x93930b74: "Bingo Highway Rose Act 2 Rings Collected: 197",
    0x93930b75: "Bingo Highway Rose Act 2 Rings Collected: 198",
    0x93930b76: "Bingo Highway Rose Act 2 Rings Collected: 199",
    0x93930b77: "Bingo Highway Rose Act 2 Rings Collected: 200",
    0x93930b78: "Rail Canyon Rose Act 2 Rings Collected: 1",
    0x93930b79: "Rail Canyon Rose Act 2 Rings Collected: 2",
    0x93930b7a: "Rail Canyon Rose Act 2 Rings Collected: 3",
    0x93930b7b: "Rail Canyon Rose Act 2 Rings Collected: 4",
    0x93930b7c: "Rail Canyon Rose Act 2 Rings Collected: 5",
    0x93930b7d: "Rail Canyon Rose Act 2 Rings Collected: 6",
    0x93930b7e: "Rail Canyon Rose Act 2 Rings Collected: 7",
    0x93930b7f: "Rail Canyon Rose Act 2 Rings Collected: 8",
    0x93930b80: "Rail Canyon Rose Act 2 Rings Collected: 9",
    0x93930b81: "Rail Canyon Rose Act 2 Rings Collected: 10",
    0x93930b82: "Rail Canyon Rose Act 2 Rings Collected: 11",
    0x93930b83: "Rail Canyon Rose Act 2 Rings Collected: 12",
    0x93930b84: "Rail Canyon Rose Act 2 Rings Collected: 13",
    0x93930b85: "Rail Canyon Rose Act 2 Rings Collected: 14",
    0x93930b86: "Rail Canyon Rose Act 2 Rings Collected: 15",
    0x93930b87: "Rail Canyon Rose Act 2 Rings Collected: 16",
    0x93930b88: "Rail Canyon Rose Act 2 Rings Collected: 17",
    0x93930b89: "Rail Canyon Rose Act 2 Rings Collected: 18",
    0x93930b8a: "Rail Canyon Rose Act 2 Rings Collected: 19",
    0x93930b8b: "Rail Canyon Rose Act 2 Rings Collected: 20",
    0x93930b8c: "Rail Canyon Rose Act 2 Rings Collected: 21",
    0x93930b8d: "Rail Canyon Rose Act 2 Rings Collected: 22",
    0x93930b8e: "Rail Canyon Rose Act 2 Rings Collected: 23",
    0x93930b8f: "Rail Canyon Rose Act 2 Rings Collected: 24",
    0x93930b90: "Rail Canyon Rose Act 2 Rings Collected: 25",
    0x93930b91: "Rail Canyon Rose Act 2 Rings Collected: 26",
    0x93930b92: "Rail Canyon Rose Act 2 Rings Collected: 27",
    0x93930b93: "Rail Canyon Rose Act 2 Rings Collected: 28",
    0x93930b94: "Rail Canyon Rose Act 2 Rings Collected: 29",
    0x93930b95: "Rail Canyon Rose Act 2 Rings Collected: 30",
    0x93930b96: "Rail Canyon Rose Act 2 Rings Collected: 31",
    0x93930b97: "Rail Canyon Rose Act 2 Rings Collected: 32",
    0x93930b98: "Rail Canyon Rose Act 2 Rings Collected: 33",
    0x93930b99: "Rail Canyon Rose Act 2 Rings Collected: 34",
    0x93930b9a: "Rail Canyon Rose Act 2 Rings Collected: 35",
    0x93930b9b: "Rail Canyon Rose Act 2 Rings Collected: 36",
    0x93930b9c: "Rail Canyon Rose Act 2 Rings Collected: 37",
    0x93930b9d: "Rail Canyon Rose Act 2 Rings Collected: 38",
    0x93930b9e: "Rail Canyon Rose Act 2 Rings Collected: 39",
    0x93930b9f: "Rail Canyon Rose Act 2 Rings Collected: 40",
    0x93930ba0: "Rail Canyon Rose Act 2 Rings Collected: 41",
    0x93930ba1: "Rail Canyon Rose Act 2 Rings Collected: 42",
    0x93930ba2: "Rail Canyon Rose Act 2 Rings Collected: 43",
    0x93930ba3: "Rail Canyon Rose Act 2 Rings Collected: 44",
    0x93930ba4: "Rail Canyon Rose Act 2 Rings Collected: 45",
    0x93930ba5: "Rail Canyon Rose Act 2 Rings Collected: 46",
    0x93930ba6: "Rail Canyon Rose Act 2 Rings Collected: 47",
    0x93930ba7: "Rail Canyon Rose Act 2 Rings Collected: 48",
    0x93930ba8: "Rail Canyon Rose Act 2 Rings Collected: 49",
    0x93930ba9: "Rail Canyon Rose Act 2 Rings Collected: 50",
    0x93930baa: "Rail Canyon Rose Act 2 Rings Collected: 51",
    0x93930bab: "Rail Canyon Rose Act 2 Rings Collected: 52",
    0x93930bac: "Rail Canyon Rose Act 2 Rings Collected: 53",
    0x93930bad: "Rail Canyon Rose Act 2 Rings Collected: 54",
    0x93930bae: "Rail Canyon Rose Act 2 Rings Collected: 55",
    0x93930baf: "Rail Canyon Rose Act 2 Rings Collected: 56",
    0x93930bb0: "Rail Canyon Rose Act 2 Rings Collected: 57",
    0x93930bb1: "Rail Canyon Rose Act 2 Rings Collected: 58",
    0x93930bb2: "Rail Canyon Rose Act 2 Rings Collected: 59",
    0x93930bb3: "Rail Canyon Rose Act 2 Rings Collected: 60",
    0x93930bb4: "Rail Canyon Rose Act 2 Rings Collected: 61",
    0x93930bb5: "Rail Canyon Rose Act 2 Rings Collected: 62",
    0x93930bb6: "Rail Canyon Rose Act 2 Rings Collected: 63",
    0x93930bb7: "Rail Canyon Rose Act 2 Rings Collected: 64",
    0x93930bb8: "Rail Canyon Rose Act 2 Rings Collected: 65",
    0x93930bb9: "Rail Canyon Rose Act 2 Rings Collected: 66",
    0x93930bba: "Rail Canyon Rose Act 2 Rings Collected: 67",
    0x93930bbb: "Rail Canyon Rose Act 2 Rings Collected: 68",
    0x93930bbc: "Rail Canyon Rose Act 2 Rings Collected: 69",
    0x93930bbd: "Rail Canyon Rose Act 2 Rings Collected: 70",
    0x93930bbe: "Rail Canyon Rose Act 2 Rings Collected: 71",
    0x93930bbf: "Rail Canyon Rose Act 2 Rings Collected: 72",
    0x93930bc0: "Rail Canyon Rose Act 2 Rings Collected: 73",
    0x93930bc1: "Rail Canyon Rose Act 2 Rings Collected: 74",
    0x93930bc2: "Rail Canyon Rose Act 2 Rings Collected: 75",
    0x93930bc3: "Rail Canyon Rose Act 2 Rings Collected: 76",
    0x93930bc4: "Rail Canyon Rose Act 2 Rings Collected: 77",
    0x93930bc5: "Rail Canyon Rose Act 2 Rings Collected: 78",
    0x93930bc6: "Rail Canyon Rose Act 2 Rings Collected: 79",
    0x93930bc7: "Rail Canyon Rose Act 2 Rings Collected: 80",
    0x93930bc8: "Rail Canyon Rose Act 2 Rings Collected: 81",
    0x93930bc9: "Rail Canyon Rose Act 2 Rings Collected: 82",
    0x93930bca: "Rail Canyon Rose Act 2 Rings Collected: 83",
    0x93930bcb: "Rail Canyon Rose Act 2 Rings Collected: 84",
    0x93930bcc: "Rail Canyon Rose Act 2 Rings Collected: 85",
    0x93930bcd: "Rail Canyon Rose Act 2 Rings Collected: 86",
    0x93930bce: "Rail Canyon Rose Act 2 Rings Collected: 87",
    0x93930bcf: "Rail Canyon Rose Act 2 Rings Collected: 88",
    0x93930bd0: "Rail Canyon Rose Act 2 Rings Collected: 89",
    0x93930bd1: "Rail Canyon Rose Act 2 Rings Collected: 90",
    0x93930bd2: "Rail Canyon Rose Act 2 Rings Collected: 91",
    0x93930bd3: "Rail Canyon Rose Act 2 Rings Collected: 92",
    0x93930bd4: "Rail Canyon Rose Act 2 Rings Collected: 93",
    0x93930bd5: "Rail Canyon Rose Act 2 Rings Collected: 94",
    0x93930bd6: "Rail Canyon Rose Act 2 Rings Collected: 95",
    0x93930bd7: "Rail Canyon Rose Act 2 Rings Collected: 96",
    0x93930bd8: "Rail Canyon Rose Act 2 Rings Collected: 97",
    0x93930bd9: "Rail Canyon Rose Act 2 Rings Collected: 98",
    0x93930bda: "Rail Canyon Rose Act 2 Rings Collected: 99",
    0x93930bdb: "Rail Canyon Rose Act 2 Rings Collected: 100",
    0x93930bdc: "Rail Canyon Rose Act 2 Rings Collected: 101",
    0x93930bdd: "Rail Canyon Rose Act 2 Rings Collected: 102",
    0x93930bde: "Rail Canyon Rose Act 2 Rings Collected: 103",
    0x93930bdf: "Rail Canyon Rose Act 2 Rings Collected: 104",
    0x93930be0: "Rail Canyon Rose Act 2 Rings Collected: 105",
    0x93930be1: "Rail Canyon Rose Act 2 Rings Collected: 106",
    0x93930be2: "Rail Canyon Rose Act 2 Rings Collected: 107",
    0x93930be3: "Rail Canyon Rose Act 2 Rings Collected: 108",
    0x93930be4: "Rail Canyon Rose Act 2 Rings Collected: 109",
    0x93930be5: "Rail Canyon Rose Act 2 Rings Collected: 110",
    0x93930be6: "Rail Canyon Rose Act 2 Rings Collected: 111",
    0x93930be7: "Rail Canyon Rose Act 2 Rings Collected: 112",
    0x93930be8: "Rail Canyon Rose Act 2 Rings Collected: 113",
    0x93930be9: "Rail Canyon Rose Act 2 Rings Collected: 114",
    0x93930bea: "Rail Canyon Rose Act 2 Rings Collected: 115",
    0x93930beb: "Rail Canyon Rose Act 2 Rings Collected: 116",
    0x93930bec: "Rail Canyon Rose Act 2 Rings Collected: 117",
    0x93930bed: "Rail Canyon Rose Act 2 Rings Collected: 118",
    0x93930bee: "Rail Canyon Rose Act 2 Rings Collected: 119",
    0x93930bef: "Rail Canyon Rose Act 2 Rings Collected: 120",
    0x93930bf0: "Rail Canyon Rose Act 2 Rings Collected: 121",
    0x93930bf1: "Rail Canyon Rose Act 2 Rings Collected: 122",
    0x93930bf2: "Rail Canyon Rose Act 2 Rings Collected: 123",
    0x93930bf3: "Rail Canyon Rose Act 2 Rings Collected: 124",
    0x93930bf4: "Rail Canyon Rose Act 2 Rings Collected: 125",
    0x93930bf5: "Rail Canyon Rose Act 2 Rings Collected: 126",
    0x93930bf6: "Rail Canyon Rose Act 2 Rings Collected: 127",
    0x93930bf7: "Rail Canyon Rose Act 2 Rings Collected: 128",
    0x93930bf8: "Rail Canyon Rose Act 2 Rings Collected: 129",
    0x93930bf9: "Rail Canyon Rose Act 2 Rings Collected: 130",
    0x93930bfa: "Rail Canyon Rose Act 2 Rings Collected: 131",
    0x93930bfb: "Rail Canyon Rose Act 2 Rings Collected: 132",
    0x93930bfc: "Rail Canyon Rose Act 2 Rings Collected: 133",
    0x93930bfd: "Rail Canyon Rose Act 2 Rings Collected: 134",
    0x93930bfe: "Rail Canyon Rose Act 2 Rings Collected: 135",
    0x93930bff: "Rail Canyon Rose Act 2 Rings Collected: 136",
    0x93930c00: "Rail Canyon Rose Act 2 Rings Collected: 137",
    0x93930c01: "Rail Canyon Rose Act 2 Rings Collected: 138",
    0x93930c02: "Rail Canyon Rose Act 2 Rings Collected: 139",
    0x93930c03: "Rail Canyon Rose Act 2 Rings Collected: 140",
    0x93930c04: "Rail Canyon Rose Act 2 Rings Collected: 141",
    0x93930c05: "Rail Canyon Rose Act 2 Rings Collected: 142",
    0x93930c06: "Rail Canyon Rose Act 2 Rings Collected: 143",
    0x93930c07: "Rail Canyon Rose Act 2 Rings Collected: 144",
    0x93930c08: "Rail Canyon Rose Act 2 Rings Collected: 145",
    0x93930c09: "Rail Canyon Rose Act 2 Rings Collected: 146",
    0x93930c0a: "Rail Canyon Rose Act 2 Rings Collected: 147",
    0x93930c0b: "Rail Canyon Rose Act 2 Rings Collected: 148",
    0x93930c0c: "Rail Canyon Rose Act 2 Rings Collected: 149",
    0x93930c0d: "Rail Canyon Rose Act 2 Rings Collected: 150",
    0x93930c0e: "Rail Canyon Rose Act 2 Rings Collected: 151",
    0x93930c0f: "Rail Canyon Rose Act 2 Rings Collected: 152",
    0x93930c10: "Rail Canyon Rose Act 2 Rings Collected: 153",
    0x93930c11: "Rail Canyon Rose Act 2 Rings Collected: 154",
    0x93930c12: "Rail Canyon Rose Act 2 Rings Collected: 155",
    0x93930c13: "Rail Canyon Rose Act 2 Rings Collected: 156",
    0x93930c14: "Rail Canyon Rose Act 2 Rings Collected: 157",
    0x93930c15: "Rail Canyon Rose Act 2 Rings Collected: 158",
    0x93930c16: "Rail Canyon Rose Act 2 Rings Collected: 159",
    0x93930c17: "Rail Canyon Rose Act 2 Rings Collected: 160",
    0x93930c18: "Rail Canyon Rose Act 2 Rings Collected: 161",
    0x93930c19: "Rail Canyon Rose Act 2 Rings Collected: 162",
    0x93930c1a: "Rail Canyon Rose Act 2 Rings Collected: 163",
    0x93930c1b: "Rail Canyon Rose Act 2 Rings Collected: 164",
    0x93930c1c: "Rail Canyon Rose Act 2 Rings Collected: 165",
    0x93930c1d: "Rail Canyon Rose Act 2 Rings Collected: 166",
    0x93930c1e: "Rail Canyon Rose Act 2 Rings Collected: 167",
    0x93930c1f: "Rail Canyon Rose Act 2 Rings Collected: 168",
    0x93930c20: "Rail Canyon Rose Act 2 Rings Collected: 169",
    0x93930c21: "Rail Canyon Rose Act 2 Rings Collected: 170",
    0x93930c22: "Rail Canyon Rose Act 2 Rings Collected: 171",
    0x93930c23: "Rail Canyon Rose Act 2 Rings Collected: 172",
    0x93930c24: "Rail Canyon Rose Act 2 Rings Collected: 173",
    0x93930c25: "Rail Canyon Rose Act 2 Rings Collected: 174",
    0x93930c26: "Rail Canyon Rose Act 2 Rings Collected: 175",
    0x93930c27: "Rail Canyon Rose Act 2 Rings Collected: 176",
    0x93930c28: "Rail Canyon Rose Act 2 Rings Collected: 177",
    0x93930c29: "Rail Canyon Rose Act 2 Rings Collected: 178",
    0x93930c2a: "Rail Canyon Rose Act 2 Rings Collected: 179",
    0x93930c2b: "Rail Canyon Rose Act 2 Rings Collected: 180",
    0x93930c2c: "Rail Canyon Rose Act 2 Rings Collected: 181",
    0x93930c2d: "Rail Canyon Rose Act 2 Rings Collected: 182",
    0x93930c2e: "Rail Canyon Rose Act 2 Rings Collected: 183",
    0x93930c2f: "Rail Canyon Rose Act 2 Rings Collected: 184",
    0x93930c30: "Rail Canyon Rose Act 2 Rings Collected: 185",
    0x93930c31: "Rail Canyon Rose Act 2 Rings Collected: 186",
    0x93930c32: "Rail Canyon Rose Act 2 Rings Collected: 187",
    0x93930c33: "Rail Canyon Rose Act 2 Rings Collected: 188",
    0x93930c34: "Rail Canyon Rose Act 2 Rings Collected: 189",
    0x93930c35: "Rail Canyon Rose Act 2 Rings Collected: 190",
    0x93930c36: "Rail Canyon Rose Act 2 Rings Collected: 191",
    0x93930c37: "Rail Canyon Rose Act 2 Rings Collected: 192",
    0x93930c38: "Rail Canyon Rose Act 2 Rings Collected: 193",
    0x93930c39: "Rail Canyon Rose Act 2 Rings Collected: 194",
    0x93930c3a: "Rail Canyon Rose Act 2 Rings Collected: 195",
    0x93930c3b: "Rail Canyon Rose Act 2 Rings Collected: 196",
    0x93930c3c: "Rail Canyon Rose Act 2 Rings Collected: 197",
    0x93930c3d: "Rail Canyon Rose Act 2 Rings Collected: 198",
    0x93930c3e: "Rail Canyon Rose Act 2 Rings Collected: 199",
    0x93930c3f: "Rail Canyon Rose Act 2 Rings Collected: 200",
    0x93930c40: "Bullet Station Rose Act 2 Rings Collected: 1",
    0x93930c41: "Bullet Station Rose Act 2 Rings Collected: 2",
    0x93930c42: "Bullet Station Rose Act 2 Rings Collected: 3",
    0x93930c43: "Bullet Station Rose Act 2 Rings Collected: 4",
    0x93930c44: "Bullet Station Rose Act 2 Rings Collected: 5",
    0x93930c45: "Bullet Station Rose Act 2 Rings Collected: 6",
    0x93930c46: "Bullet Station Rose Act 2 Rings Collected: 7",
    0x93930c47: "Bullet Station Rose Act 2 Rings Collected: 8",
    0x93930c48: "Bullet Station Rose Act 2 Rings Collected: 9",
    0x93930c49: "Bullet Station Rose Act 2 Rings Collected: 10",
    0x93930c4a: "Bullet Station Rose Act 2 Rings Collected: 11",
    0x93930c4b: "Bullet Station Rose Act 2 Rings Collected: 12",
    0x93930c4c: "Bullet Station Rose Act 2 Rings Collected: 13",
    0x93930c4d: "Bullet Station Rose Act 2 Rings Collected: 14",
    0x93930c4e: "Bullet Station Rose Act 2 Rings Collected: 15",
    0x93930c4f: "Bullet Station Rose Act 2 Rings Collected: 16",
    0x93930c50: "Bullet Station Rose Act 2 Rings Collected: 17",
    0x93930c51: "Bullet Station Rose Act 2 Rings Collected: 18",
    0x93930c52: "Bullet Station Rose Act 2 Rings Collected: 19",
    0x93930c53: "Bullet Station Rose Act 2 Rings Collected: 20",
    0x93930c54: "Bullet Station Rose Act 2 Rings Collected: 21",
    0x93930c55: "Bullet Station Rose Act 2 Rings Collected: 22",
    0x93930c56: "Bullet Station Rose Act 2 Rings Collected: 23",
    0x93930c57: "Bullet Station Rose Act 2 Rings Collected: 24",
    0x93930c58: "Bullet Station Rose Act 2 Rings Collected: 25",
    0x93930c59: "Bullet Station Rose Act 2 Rings Collected: 26",
    0x93930c5a: "Bullet Station Rose Act 2 Rings Collected: 27",
    0x93930c5b: "Bullet Station Rose Act 2 Rings Collected: 28",
    0x93930c5c: "Bullet Station Rose Act 2 Rings Collected: 29",
    0x93930c5d: "Bullet Station Rose Act 2 Rings Collected: 30",
    0x93930c5e: "Bullet Station Rose Act 2 Rings Collected: 31",
    0x93930c5f: "Bullet Station Rose Act 2 Rings Collected: 32",
    0x93930c60: "Bullet Station Rose Act 2 Rings Collected: 33",
    0x93930c61: "Bullet Station Rose Act 2 Rings Collected: 34",
    0x93930c62: "Bullet Station Rose Act 2 Rings Collected: 35",
    0x93930c63: "Bullet Station Rose Act 2 Rings Collected: 36",
    0x93930c64: "Bullet Station Rose Act 2 Rings Collected: 37",
    0x93930c65: "Bullet Station Rose Act 2 Rings Collected: 38",
    0x93930c66: "Bullet Station Rose Act 2 Rings Collected: 39",
    0x93930c67: "Bullet Station Rose Act 2 Rings Collected: 40",
    0x93930c68: "Bullet Station Rose Act 2 Rings Collected: 41",
    0x93930c69: "Bullet Station Rose Act 2 Rings Collected: 42",
    0x93930c6a: "Bullet Station Rose Act 2 Rings Collected: 43",
    0x93930c6b: "Bullet Station Rose Act 2 Rings Collected: 44",
    0x93930c6c: "Bullet Station Rose Act 2 Rings Collected: 45",
    0x93930c6d: "Bullet Station Rose Act 2 Rings Collected: 46",
    0x93930c6e: "Bullet Station Rose Act 2 Rings Collected: 47",
    0x93930c6f: "Bullet Station Rose Act 2 Rings Collected: 48",
    0x93930c70: "Bullet Station Rose Act 2 Rings Collected: 49",
    0x93930c71: "Bullet Station Rose Act 2 Rings Collected: 50",
    0x93930c72: "Bullet Station Rose Act 2 Rings Collected: 51",
    0x93930c73: "Bullet Station Rose Act 2 Rings Collected: 52",
    0x93930c74: "Bullet Station Rose Act 2 Rings Collected: 53",
    0x93930c75: "Bullet Station Rose Act 2 Rings Collected: 54",
    0x93930c76: "Bullet Station Rose Act 2 Rings Collected: 55",
    0x93930c77: "Bullet Station Rose Act 2 Rings Collected: 56",
    0x93930c78: "Bullet Station Rose Act 2 Rings Collected: 57",
    0x93930c79: "Bullet Station Rose Act 2 Rings Collected: 58",
    0x93930c7a: "Bullet Station Rose Act 2 Rings Collected: 59",
    0x93930c7b: "Bullet Station Rose Act 2 Rings Collected: 60",
    0x93930c7c: "Bullet Station Rose Act 2 Rings Collected: 61",
    0x93930c7d: "Bullet Station Rose Act 2 Rings Collected: 62",
    0x93930c7e: "Bullet Station Rose Act 2 Rings Collected: 63",
    0x93930c7f: "Bullet Station Rose Act 2 Rings Collected: 64",
    0x93930c80: "Bullet Station Rose Act 2 Rings Collected: 65",
    0x93930c81: "Bullet Station Rose Act 2 Rings Collected: 66",
    0x93930c82: "Bullet Station Rose Act 2 Rings Collected: 67",
    0x93930c83: "Bullet Station Rose Act 2 Rings Collected: 68",
    0x93930c84: "Bullet Station Rose Act 2 Rings Collected: 69",
    0x93930c85: "Bullet Station Rose Act 2 Rings Collected: 70",
    0x93930c86: "Bullet Station Rose Act 2 Rings Collected: 71",
    0x93930c87: "Bullet Station Rose Act 2 Rings Collected: 72",
    0x93930c88: "Bullet Station Rose Act 2 Rings Collected: 73",
    0x93930c89: "Bullet Station Rose Act 2 Rings Collected: 74",
    0x93930c8a: "Bullet Station Rose Act 2 Rings Collected: 75",
    0x93930c8b: "Bullet Station Rose Act 2 Rings Collected: 76",
    0x93930c8c: "Bullet Station Rose Act 2 Rings Collected: 77",
    0x93930c8d: "Bullet Station Rose Act 2 Rings Collected: 78",
    0x93930c8e: "Bullet Station Rose Act 2 Rings Collected: 79",
    0x93930c8f: "Bullet Station Rose Act 2 Rings Collected: 80",
    0x93930c90: "Bullet Station Rose Act 2 Rings Collected: 81",
    0x93930c91: "Bullet Station Rose Act 2 Rings Collected: 82",
    0x93930c92: "Bullet Station Rose Act 2 Rings Collected: 83",
    0x93930c93: "Bullet Station Rose Act 2 Rings Collected: 84",
    0x93930c94: "Bullet Station Rose Act 2 Rings Collected: 85",
    0x93930c95: "Bullet Station Rose Act 2 Rings Collected: 86",
    0x93930c96: "Bullet Station Rose Act 2 Rings Collected: 87",
    0x93930c97: "Bullet Station Rose Act 2 Rings Collected: 88",
    0x93930c98: "Bullet Station Rose Act 2 Rings Collected: 89",
    0x93930c99: "Bullet Station Rose Act 2 Rings Collected: 90",
    0x93930c9a: "Bullet Station Rose Act 2 Rings Collected: 91",
    0x93930c9b: "Bullet Station Rose Act 2 Rings Collected: 92",
    0x93930c9c: "Bullet Station Rose Act 2 Rings Collected: 93",
    0x93930c9d: "Bullet Station Rose Act 2 Rings Collected: 94",
    0x93930c9e: "Bullet Station Rose Act 2 Rings Collected: 95",
    0x93930c9f: "Bullet Station Rose Act 2 Rings Collected: 96",
    0x93930ca0: "Bullet Station Rose Act 2 Rings Collected: 97",
    0x93930ca1: "Bullet Station Rose Act 2 Rings Collected: 98",
    0x93930ca2: "Bullet Station Rose Act 2 Rings Collected: 99",
    0x93930ca3: "Bullet Station Rose Act 2 Rings Collected: 100",
    0x93930ca4: "Bullet Station Rose Act 2 Rings Collected: 101",
    0x93930ca5: "Bullet Station Rose Act 2 Rings Collected: 102",
    0x93930ca6: "Bullet Station Rose Act 2 Rings Collected: 103",
    0x93930ca7: "Bullet Station Rose Act 2 Rings Collected: 104",
    0x93930ca8: "Bullet Station Rose Act 2 Rings Collected: 105",
    0x93930ca9: "Bullet Station Rose Act 2 Rings Collected: 106",
    0x93930caa: "Bullet Station Rose Act 2 Rings Collected: 107",
    0x93930cab: "Bullet Station Rose Act 2 Rings Collected: 108",
    0x93930cac: "Bullet Station Rose Act 2 Rings Collected: 109",
    0x93930cad: "Bullet Station Rose Act 2 Rings Collected: 110",
    0x93930cae: "Bullet Station Rose Act 2 Rings Collected: 111",
    0x93930caf: "Bullet Station Rose Act 2 Rings Collected: 112",
    0x93930cb0: "Bullet Station Rose Act 2 Rings Collected: 113",
    0x93930cb1: "Bullet Station Rose Act 2 Rings Collected: 114",
    0x93930cb2: "Bullet Station Rose Act 2 Rings Collected: 115",
    0x93930cb3: "Bullet Station Rose Act 2 Rings Collected: 116",
    0x93930cb4: "Bullet Station Rose Act 2 Rings Collected: 117",
    0x93930cb5: "Bullet Station Rose Act 2 Rings Collected: 118",
    0x93930cb6: "Bullet Station Rose Act 2 Rings Collected: 119",
    0x93930cb7: "Bullet Station Rose Act 2 Rings Collected: 120",
    0x93930cb8: "Bullet Station Rose Act 2 Rings Collected: 121",
    0x93930cb9: "Bullet Station Rose Act 2 Rings Collected: 122",
    0x93930cba: "Bullet Station Rose Act 2 Rings Collected: 123",
    0x93930cbb: "Bullet Station Rose Act 2 Rings Collected: 124",
    0x93930cbc: "Bullet Station Rose Act 2 Rings Collected: 125",
    0x93930cbd: "Bullet Station Rose Act 2 Rings Collected: 126",
    0x93930cbe: "Bullet Station Rose Act 2 Rings Collected: 127",
    0x93930cbf: "Bullet Station Rose Act 2 Rings Collected: 128",
    0x93930cc0: "Bullet Station Rose Act 2 Rings Collected: 129",
    0x93930cc1: "Bullet Station Rose Act 2 Rings Collected: 130",
    0x93930cc2: "Bullet Station Rose Act 2 Rings Collected: 131",
    0x93930cc3: "Bullet Station Rose Act 2 Rings Collected: 132",
    0x93930cc4: "Bullet Station Rose Act 2 Rings Collected: 133",
    0x93930cc5: "Bullet Station Rose Act 2 Rings Collected: 134",
    0x93930cc6: "Bullet Station Rose Act 2 Rings Collected: 135",
    0x93930cc7: "Bullet Station Rose Act 2 Rings Collected: 136",
    0x93930cc8: "Bullet Station Rose Act 2 Rings Collected: 137",
    0x93930cc9: "Bullet Station Rose Act 2 Rings Collected: 138",
    0x93930cca: "Bullet Station Rose Act 2 Rings Collected: 139",
    0x93930ccb: "Bullet Station Rose Act 2 Rings Collected: 140",
    0x93930ccc: "Bullet Station Rose Act 2 Rings Collected: 141",
    0x93930ccd: "Bullet Station Rose Act 2 Rings Collected: 142",
    0x93930cce: "Bullet Station Rose Act 2 Rings Collected: 143",
    0x93930ccf: "Bullet Station Rose Act 2 Rings Collected: 144",
    0x93930cd0: "Bullet Station Rose Act 2 Rings Collected: 145",
    0x93930cd1: "Bullet Station Rose Act 2 Rings Collected: 146",
    0x93930cd2: "Bullet Station Rose Act 2 Rings Collected: 147",
    0x93930cd3: "Bullet Station Rose Act 2 Rings Collected: 148",
    0x93930cd4: "Bullet Station Rose Act 2 Rings Collected: 149",
    0x93930cd5: "Bullet Station Rose Act 2 Rings Collected: 150",
    0x93930cd6: "Bullet Station Rose Act 2 Rings Collected: 151",
    0x93930cd7: "Bullet Station Rose Act 2 Rings Collected: 152",
    0x93930cd8: "Bullet Station Rose Act 2 Rings Collected: 153",
    0x93930cd9: "Bullet Station Rose Act 2 Rings Collected: 154",
    0x93930cda: "Bullet Station Rose Act 2 Rings Collected: 155",
    0x93930cdb: "Bullet Station Rose Act 2 Rings Collected: 156",
    0x93930cdc: "Bullet Station Rose Act 2 Rings Collected: 157",
    0x93930cdd: "Bullet Station Rose Act 2 Rings Collected: 158",
    0x93930cde: "Bullet Station Rose Act 2 Rings Collected: 159",
    0x93930cdf: "Bullet Station Rose Act 2 Rings Collected: 160",
    0x93930ce0: "Bullet Station Rose Act 2 Rings Collected: 161",
    0x93930ce1: "Bullet Station Rose Act 2 Rings Collected: 162",
    0x93930ce2: "Bullet Station Rose Act 2 Rings Collected: 163",
    0x93930ce3: "Bullet Station Rose Act 2 Rings Collected: 164",
    0x93930ce4: "Bullet Station Rose Act 2 Rings Collected: 165",
    0x93930ce5: "Bullet Station Rose Act 2 Rings Collected: 166",
    0x93930ce6: "Bullet Station Rose Act 2 Rings Collected: 167",
    0x93930ce7: "Bullet Station Rose Act 2 Rings Collected: 168",
    0x93930ce8: "Bullet Station Rose Act 2 Rings Collected: 169",
    0x93930ce9: "Bullet Station Rose Act 2 Rings Collected: 170",
    0x93930cea: "Bullet Station Rose Act 2 Rings Collected: 171",
    0x93930ceb: "Bullet Station Rose Act 2 Rings Collected: 172",
    0x93930cec: "Bullet Station Rose Act 2 Rings Collected: 173",
    0x93930ced: "Bullet Station Rose Act 2 Rings Collected: 174",
    0x93930cee: "Bullet Station Rose Act 2 Rings Collected: 175",
    0x93930cef: "Bullet Station Rose Act 2 Rings Collected: 176",
    0x93930cf0: "Bullet Station Rose Act 2 Rings Collected: 177",
    0x93930cf1: "Bullet Station Rose Act 2 Rings Collected: 178",
    0x93930cf2: "Bullet Station Rose Act 2 Rings Collected: 179",
    0x93930cf3: "Bullet Station Rose Act 2 Rings Collected: 180",
    0x93930cf4: "Bullet Station Rose Act 2 Rings Collected: 181",
    0x93930cf5: "Bullet Station Rose Act 2 Rings Collected: 182",
    0x93930cf6: "Bullet Station Rose Act 2 Rings Collected: 183",
    0x93930cf7: "Bullet Station Rose Act 2 Rings Collected: 184",
    0x93930cf8: "Bullet Station Rose Act 2 Rings Collected: 185",
    0x93930cf9: "Bullet Station Rose Act 2 Rings Collected: 186",
    0x93930cfa: "Bullet Station Rose Act 2 Rings Collected: 187",
    0x93930cfb: "Bullet Station Rose Act 2 Rings Collected: 188",
    0x93930cfc: "Bullet Station Rose Act 2 Rings Collected: 189",
    0x93930cfd: "Bullet Station Rose Act 2 Rings Collected: 190",
    0x93930cfe: "Bullet Station Rose Act 2 Rings Collected: 191",
    0x93930cff: "Bullet Station Rose Act 2 Rings Collected: 192",
    0x93930d00: "Bullet Station Rose Act 2 Rings Collected: 193",
    0x93930d01: "Bullet Station Rose Act 2 Rings Collected: 194",
    0x93930d02: "Bullet Station Rose Act 2 Rings Collected: 195",
    0x93930d03: "Bullet Station Rose Act 2 Rings Collected: 196",
    0x93930d04: "Bullet Station Rose Act 2 Rings Collected: 197",
    0x93930d05: "Bullet Station Rose Act 2 Rings Collected: 198",
    0x93930d06: "Bullet Station Rose Act 2 Rings Collected: 199",
    0x93930d07: "Bullet Station Rose Act 2 Rings Collected: 200",
    0x93930d08: "Frog Forest Rose Act 2 Rings Collected: 1",
    0x93930d09: "Frog Forest Rose Act 2 Rings Collected: 2",
    0x93930d0a: "Frog Forest Rose Act 2 Rings Collected: 3",
    0x93930d0b: "Frog Forest Rose Act 2 Rings Collected: 4",
    0x93930d0c: "Frog Forest Rose Act 2 Rings Collected: 5",
    0x93930d0d: "Frog Forest Rose Act 2 Rings Collected: 6",
    0x93930d0e: "Frog Forest Rose Act 2 Rings Collected: 7",
    0x93930d0f: "Frog Forest Rose Act 2 Rings Collected: 8",
    0x93930d10: "Frog Forest Rose Act 2 Rings Collected: 9",
    0x93930d11: "Frog Forest Rose Act 2 Rings Collected: 10",
    0x93930d12: "Frog Forest Rose Act 2 Rings Collected: 11",
    0x93930d13: "Frog Forest Rose Act 2 Rings Collected: 12",
    0x93930d14: "Frog Forest Rose Act 2 Rings Collected: 13",
    0x93930d15: "Frog Forest Rose Act 2 Rings Collected: 14",
    0x93930d16: "Frog Forest Rose Act 2 Rings Collected: 15",
    0x93930d17: "Frog Forest Rose Act 2 Rings Collected: 16",
    0x93930d18: "Frog Forest Rose Act 2 Rings Collected: 17",
    0x93930d19: "Frog Forest Rose Act 2 Rings Collected: 18",
    0x93930d1a: "Frog Forest Rose Act 2 Rings Collected: 19",
    0x93930d1b: "Frog Forest Rose Act 2 Rings Collected: 20",
    0x93930d1c: "Frog Forest Rose Act 2 Rings Collected: 21",
    0x93930d1d: "Frog Forest Rose Act 2 Rings Collected: 22",
    0x93930d1e: "Frog Forest Rose Act 2 Rings Collected: 23",
    0x93930d1f: "Frog Forest Rose Act 2 Rings Collected: 24",
    0x93930d20: "Frog Forest Rose Act 2 Rings Collected: 25",
    0x93930d21: "Frog Forest Rose Act 2 Rings Collected: 26",
    0x93930d22: "Frog Forest Rose Act 2 Rings Collected: 27",
    0x93930d23: "Frog Forest Rose Act 2 Rings Collected: 28",
    0x93930d24: "Frog Forest Rose Act 2 Rings Collected: 29",
    0x93930d25: "Frog Forest Rose Act 2 Rings Collected: 30",
    0x93930d26: "Frog Forest Rose Act 2 Rings Collected: 31",
    0x93930d27: "Frog Forest Rose Act 2 Rings Collected: 32",
    0x93930d28: "Frog Forest Rose Act 2 Rings Collected: 33",
    0x93930d29: "Frog Forest Rose Act 2 Rings Collected: 34",
    0x93930d2a: "Frog Forest Rose Act 2 Rings Collected: 35",
    0x93930d2b: "Frog Forest Rose Act 2 Rings Collected: 36",
    0x93930d2c: "Frog Forest Rose Act 2 Rings Collected: 37",
    0x93930d2d: "Frog Forest Rose Act 2 Rings Collected: 38",
    0x93930d2e: "Frog Forest Rose Act 2 Rings Collected: 39",
    0x93930d2f: "Frog Forest Rose Act 2 Rings Collected: 40",
    0x93930d30: "Frog Forest Rose Act 2 Rings Collected: 41",
    0x93930d31: "Frog Forest Rose Act 2 Rings Collected: 42",
    0x93930d32: "Frog Forest Rose Act 2 Rings Collected: 43",
    0x93930d33: "Frog Forest Rose Act 2 Rings Collected: 44",
    0x93930d34: "Frog Forest Rose Act 2 Rings Collected: 45",
    0x93930d35: "Frog Forest Rose Act 2 Rings Collected: 46",
    0x93930d36: "Frog Forest Rose Act 2 Rings Collected: 47",
    0x93930d37: "Frog Forest Rose Act 2 Rings Collected: 48",
    0x93930d38: "Frog Forest Rose Act 2 Rings Collected: 49",
    0x93930d39: "Frog Forest Rose Act 2 Rings Collected: 50",
    0x93930d3a: "Frog Forest Rose Act 2 Rings Collected: 51",
    0x93930d3b: "Frog Forest Rose Act 2 Rings Collected: 52",
    0x93930d3c: "Frog Forest Rose Act 2 Rings Collected: 53",
    0x93930d3d: "Frog Forest Rose Act 2 Rings Collected: 54",
    0x93930d3e: "Frog Forest Rose Act 2 Rings Collected: 55",
    0x93930d3f: "Frog Forest Rose Act 2 Rings Collected: 56",
    0x93930d40: "Frog Forest Rose Act 2 Rings Collected: 57",
    0x93930d41: "Frog Forest Rose Act 2 Rings Collected: 58",
    0x93930d42: "Frog Forest Rose Act 2 Rings Collected: 59",
    0x93930d43: "Frog Forest Rose Act 2 Rings Collected: 60",
    0x93930d44: "Frog Forest Rose Act 2 Rings Collected: 61",
    0x93930d45: "Frog Forest Rose Act 2 Rings Collected: 62",
    0x93930d46: "Frog Forest Rose Act 2 Rings Collected: 63",
    0x93930d47: "Frog Forest Rose Act 2 Rings Collected: 64",
    0x93930d48: "Frog Forest Rose Act 2 Rings Collected: 65",
    0x93930d49: "Frog Forest Rose Act 2 Rings Collected: 66",
    0x93930d4a: "Frog Forest Rose Act 2 Rings Collected: 67",
    0x93930d4b: "Frog Forest Rose Act 2 Rings Collected: 68",
    0x93930d4c: "Frog Forest Rose Act 2 Rings Collected: 69",
    0x93930d4d: "Frog Forest Rose Act 2 Rings Collected: 70",
    0x93930d4e: "Frog Forest Rose Act 2 Rings Collected: 71",
    0x93930d4f: "Frog Forest Rose Act 2 Rings Collected: 72",
    0x93930d50: "Frog Forest Rose Act 2 Rings Collected: 73",
    0x93930d51: "Frog Forest Rose Act 2 Rings Collected: 74",
    0x93930d52: "Frog Forest Rose Act 2 Rings Collected: 75",
    0x93930d53: "Frog Forest Rose Act 2 Rings Collected: 76",
    0x93930d54: "Frog Forest Rose Act 2 Rings Collected: 77",
    0x93930d55: "Frog Forest Rose Act 2 Rings Collected: 78",
    0x93930d56: "Frog Forest Rose Act 2 Rings Collected: 79",
    0x93930d57: "Frog Forest Rose Act 2 Rings Collected: 80",
    0x93930d58: "Frog Forest Rose Act 2 Rings Collected: 81",
    0x93930d59: "Frog Forest Rose Act 2 Rings Collected: 82",
    0x93930d5a: "Frog Forest Rose Act 2 Rings Collected: 83",
    0x93930d5b: "Frog Forest Rose Act 2 Rings Collected: 84",
    0x93930d5c: "Frog Forest Rose Act 2 Rings Collected: 85",
    0x93930d5d: "Frog Forest Rose Act 2 Rings Collected: 86",
    0x93930d5e: "Frog Forest Rose Act 2 Rings Collected: 87",
    0x93930d5f: "Frog Forest Rose Act 2 Rings Collected: 88",
    0x93930d60: "Frog Forest Rose Act 2 Rings Collected: 89",
    0x93930d61: "Frog Forest Rose Act 2 Rings Collected: 90",
    0x93930d62: "Frog Forest Rose Act 2 Rings Collected: 91",
    0x93930d63: "Frog Forest Rose Act 2 Rings Collected: 92",
    0x93930d64: "Frog Forest Rose Act 2 Rings Collected: 93",
    0x93930d65: "Frog Forest Rose Act 2 Rings Collected: 94",
    0x93930d66: "Frog Forest Rose Act 2 Rings Collected: 95",
    0x93930d67: "Frog Forest Rose Act 2 Rings Collected: 96",
    0x93930d68: "Frog Forest Rose Act 2 Rings Collected: 97",
    0x93930d69: "Frog Forest Rose Act 2 Rings Collected: 98",
    0x93930d6a: "Frog Forest Rose Act 2 Rings Collected: 99",
    0x93930d6b: "Frog Forest Rose Act 2 Rings Collected: 100",
    0x93930d6c: "Frog Forest Rose Act 2 Rings Collected: 101",
    0x93930d6d: "Frog Forest Rose Act 2 Rings Collected: 102",
    0x93930d6e: "Frog Forest Rose Act 2 Rings Collected: 103",
    0x93930d6f: "Frog Forest Rose Act 2 Rings Collected: 104",
    0x93930d70: "Frog Forest Rose Act 2 Rings Collected: 105",
    0x93930d71: "Frog Forest Rose Act 2 Rings Collected: 106",
    0x93930d72: "Frog Forest Rose Act 2 Rings Collected: 107",
    0x93930d73: "Frog Forest Rose Act 2 Rings Collected: 108",
    0x93930d74: "Frog Forest Rose Act 2 Rings Collected: 109",
    0x93930d75: "Frog Forest Rose Act 2 Rings Collected: 110",
    0x93930d76: "Frog Forest Rose Act 2 Rings Collected: 111",
    0x93930d77: "Frog Forest Rose Act 2 Rings Collected: 112",
    0x93930d78: "Frog Forest Rose Act 2 Rings Collected: 113",
    0x93930d79: "Frog Forest Rose Act 2 Rings Collected: 114",
    0x93930d7a: "Frog Forest Rose Act 2 Rings Collected: 115",
    0x93930d7b: "Frog Forest Rose Act 2 Rings Collected: 116",
    0x93930d7c: "Frog Forest Rose Act 2 Rings Collected: 117",
    0x93930d7d: "Frog Forest Rose Act 2 Rings Collected: 118",
    0x93930d7e: "Frog Forest Rose Act 2 Rings Collected: 119",
    0x93930d7f: "Frog Forest Rose Act 2 Rings Collected: 120",
    0x93930d80: "Frog Forest Rose Act 2 Rings Collected: 121",
    0x93930d81: "Frog Forest Rose Act 2 Rings Collected: 122",
    0x93930d82: "Frog Forest Rose Act 2 Rings Collected: 123",
    0x93930d83: "Frog Forest Rose Act 2 Rings Collected: 124",
    0x93930d84: "Frog Forest Rose Act 2 Rings Collected: 125",
    0x93930d85: "Frog Forest Rose Act 2 Rings Collected: 126",
    0x93930d86: "Frog Forest Rose Act 2 Rings Collected: 127",
    0x93930d87: "Frog Forest Rose Act 2 Rings Collected: 128",
    0x93930d88: "Frog Forest Rose Act 2 Rings Collected: 129",
    0x93930d89: "Frog Forest Rose Act 2 Rings Collected: 130",
    0x93930d8a: "Frog Forest Rose Act 2 Rings Collected: 131",
    0x93930d8b: "Frog Forest Rose Act 2 Rings Collected: 132",
    0x93930d8c: "Frog Forest Rose Act 2 Rings Collected: 133",
    0x93930d8d: "Frog Forest Rose Act 2 Rings Collected: 134",
    0x93930d8e: "Frog Forest Rose Act 2 Rings Collected: 135",
    0x93930d8f: "Frog Forest Rose Act 2 Rings Collected: 136",
    0x93930d90: "Frog Forest Rose Act 2 Rings Collected: 137",
    0x93930d91: "Frog Forest Rose Act 2 Rings Collected: 138",
    0x93930d92: "Frog Forest Rose Act 2 Rings Collected: 139",
    0x93930d93: "Frog Forest Rose Act 2 Rings Collected: 140",
    0x93930d94: "Frog Forest Rose Act 2 Rings Collected: 141",
    0x93930d95: "Frog Forest Rose Act 2 Rings Collected: 142",
    0x93930d96: "Frog Forest Rose Act 2 Rings Collected: 143",
    0x93930d97: "Frog Forest Rose Act 2 Rings Collected: 144",
    0x93930d98: "Frog Forest Rose Act 2 Rings Collected: 145",
    0x93930d99: "Frog Forest Rose Act 2 Rings Collected: 146",
    0x93930d9a: "Frog Forest Rose Act 2 Rings Collected: 147",
    0x93930d9b: "Frog Forest Rose Act 2 Rings Collected: 148",
    0x93930d9c: "Frog Forest Rose Act 2 Rings Collected: 149",
    0x93930d9d: "Frog Forest Rose Act 2 Rings Collected: 150",
    0x93930d9e: "Frog Forest Rose Act 2 Rings Collected: 151",
    0x93930d9f: "Frog Forest Rose Act 2 Rings Collected: 152",
    0x93930da0: "Frog Forest Rose Act 2 Rings Collected: 153",
    0x93930da1: "Frog Forest Rose Act 2 Rings Collected: 154",
    0x93930da2: "Frog Forest Rose Act 2 Rings Collected: 155",
    0x93930da3: "Frog Forest Rose Act 2 Rings Collected: 156",
    0x93930da4: "Frog Forest Rose Act 2 Rings Collected: 157",
    0x93930da5: "Frog Forest Rose Act 2 Rings Collected: 158",
    0x93930da6: "Frog Forest Rose Act 2 Rings Collected: 159",
    0x93930da7: "Frog Forest Rose Act 2 Rings Collected: 160",
    0x93930da8: "Frog Forest Rose Act 2 Rings Collected: 161",
    0x93930da9: "Frog Forest Rose Act 2 Rings Collected: 162",
    0x93930daa: "Frog Forest Rose Act 2 Rings Collected: 163",
    0x93930dab: "Frog Forest Rose Act 2 Rings Collected: 164",
    0x93930dac: "Frog Forest Rose Act 2 Rings Collected: 165",
    0x93930dad: "Frog Forest Rose Act 2 Rings Collected: 166",
    0x93930dae: "Frog Forest Rose Act 2 Rings Collected: 167",
    0x93930daf: "Frog Forest Rose Act 2 Rings Collected: 168",
    0x93930db0: "Frog Forest Rose Act 2 Rings Collected: 169",
    0x93930db1: "Frog Forest Rose Act 2 Rings Collected: 170",
    0x93930db2: "Frog Forest Rose Act 2 Rings Collected: 171",
    0x93930db3: "Frog Forest Rose Act 2 Rings Collected: 172",
    0x93930db4: "Frog Forest Rose Act 2 Rings Collected: 173",
    0x93930db5: "Frog Forest Rose Act 2 Rings Collected: 174",
    0x93930db6: "Frog Forest Rose Act 2 Rings Collected: 175",
    0x93930db7: "Frog Forest Rose Act 2 Rings Collected: 176",
    0x93930db8: "Frog Forest Rose Act 2 Rings Collected: 177",
    0x93930db9: "Frog Forest Rose Act 2 Rings Collected: 178",
    0x93930dba: "Frog Forest Rose Act 2 Rings Collected: 179",
    0x93930dbb: "Frog Forest Rose Act 2 Rings Collected: 180",
    0x93930dbc: "Frog Forest Rose Act 2 Rings Collected: 181",
    0x93930dbd: "Frog Forest Rose Act 2 Rings Collected: 182",
    0x93930dbe: "Frog Forest Rose Act 2 Rings Collected: 183",
    0x93930dbf: "Frog Forest Rose Act 2 Rings Collected: 184",
    0x93930dc0: "Frog Forest Rose Act 2 Rings Collected: 185",
    0x93930dc1: "Frog Forest Rose Act 2 Rings Collected: 186",
    0x93930dc2: "Frog Forest Rose Act 2 Rings Collected: 187",
    0x93930dc3: "Frog Forest Rose Act 2 Rings Collected: 188",
    0x93930dc4: "Frog Forest Rose Act 2 Rings Collected: 189",
    0x93930dc5: "Frog Forest Rose Act 2 Rings Collected: 190",
    0x93930dc6: "Frog Forest Rose Act 2 Rings Collected: 191",
    0x93930dc7: "Frog Forest Rose Act 2 Rings Collected: 192",
    0x93930dc8: "Frog Forest Rose Act 2 Rings Collected: 193",
    0x93930dc9: "Frog Forest Rose Act 2 Rings Collected: 194",
    0x93930dca: "Frog Forest Rose Act 2 Rings Collected: 195",
    0x93930dcb: "Frog Forest Rose Act 2 Rings Collected: 196",
    0x93930dcc: "Frog Forest Rose Act 2 Rings Collected: 197",
    0x93930dcd: "Frog Forest Rose Act 2 Rings Collected: 198",
    0x93930dce: "Frog Forest Rose Act 2 Rings Collected: 199",
    0x93930dcf: "Frog Forest Rose Act 2 Rings Collected: 200",
    0x93930dd0: "Lost Jungle Rose Act 2 Rings Collected: 1",
    0x93930dd1: "Lost Jungle Rose Act 2 Rings Collected: 2",
    0x93930dd2: "Lost Jungle Rose Act 2 Rings Collected: 3",
    0x93930dd3: "Lost Jungle Rose Act 2 Rings Collected: 4",
    0x93930dd4: "Lost Jungle Rose Act 2 Rings Collected: 5",
    0x93930dd5: "Lost Jungle Rose Act 2 Rings Collected: 6",
    0x93930dd6: "Lost Jungle Rose Act 2 Rings Collected: 7",
    0x93930dd7: "Lost Jungle Rose Act 2 Rings Collected: 8",
    0x93930dd8: "Lost Jungle Rose Act 2 Rings Collected: 9",
    0x93930dd9: "Lost Jungle Rose Act 2 Rings Collected: 10",
    0x93930dda: "Lost Jungle Rose Act 2 Rings Collected: 11",
    0x93930ddb: "Lost Jungle Rose Act 2 Rings Collected: 12",
    0x93930ddc: "Lost Jungle Rose Act 2 Rings Collected: 13",
    0x93930ddd: "Lost Jungle Rose Act 2 Rings Collected: 14",
    0x93930dde: "Lost Jungle Rose Act 2 Rings Collected: 15",
    0x93930ddf: "Lost Jungle Rose Act 2 Rings Collected: 16",
    0x93930de0: "Lost Jungle Rose Act 2 Rings Collected: 17",
    0x93930de1: "Lost Jungle Rose Act 2 Rings Collected: 18",
    0x93930de2: "Lost Jungle Rose Act 2 Rings Collected: 19",
    0x93930de3: "Lost Jungle Rose Act 2 Rings Collected: 20",
    0x93930de4: "Lost Jungle Rose Act 2 Rings Collected: 21",
    0x93930de5: "Lost Jungle Rose Act 2 Rings Collected: 22",
    0x93930de6: "Lost Jungle Rose Act 2 Rings Collected: 23",
    0x93930de7: "Lost Jungle Rose Act 2 Rings Collected: 24",
    0x93930de8: "Lost Jungle Rose Act 2 Rings Collected: 25",
    0x93930de9: "Lost Jungle Rose Act 2 Rings Collected: 26",
    0x93930dea: "Lost Jungle Rose Act 2 Rings Collected: 27",
    0x93930deb: "Lost Jungle Rose Act 2 Rings Collected: 28",
    0x93930dec: "Lost Jungle Rose Act 2 Rings Collected: 29",
    0x93930ded: "Lost Jungle Rose Act 2 Rings Collected: 30",
    0x93930dee: "Lost Jungle Rose Act 2 Rings Collected: 31",
    0x93930def: "Lost Jungle Rose Act 2 Rings Collected: 32",
    0x93930df0: "Lost Jungle Rose Act 2 Rings Collected: 33",
    0x93930df1: "Lost Jungle Rose Act 2 Rings Collected: 34",
    0x93930df2: "Lost Jungle Rose Act 2 Rings Collected: 35",
    0x93930df3: "Lost Jungle Rose Act 2 Rings Collected: 36",
    0x93930df4: "Lost Jungle Rose Act 2 Rings Collected: 37",
    0x93930df5: "Lost Jungle Rose Act 2 Rings Collected: 38",
    0x93930df6: "Lost Jungle Rose Act 2 Rings Collected: 39",
    0x93930df7: "Lost Jungle Rose Act 2 Rings Collected: 40",
    0x93930df8: "Lost Jungle Rose Act 2 Rings Collected: 41",
    0x93930df9: "Lost Jungle Rose Act 2 Rings Collected: 42",
    0x93930dfa: "Lost Jungle Rose Act 2 Rings Collected: 43",
    0x93930dfb: "Lost Jungle Rose Act 2 Rings Collected: 44",
    0x93930dfc: "Lost Jungle Rose Act 2 Rings Collected: 45",
    0x93930dfd: "Lost Jungle Rose Act 2 Rings Collected: 46",
    0x93930dfe: "Lost Jungle Rose Act 2 Rings Collected: 47",
    0x93930dff: "Lost Jungle Rose Act 2 Rings Collected: 48",
    0x93930e00: "Lost Jungle Rose Act 2 Rings Collected: 49",
    0x93930e01: "Lost Jungle Rose Act 2 Rings Collected: 50",
    0x93930e02: "Lost Jungle Rose Act 2 Rings Collected: 51",
    0x93930e03: "Lost Jungle Rose Act 2 Rings Collected: 52",
    0x93930e04: "Lost Jungle Rose Act 2 Rings Collected: 53",
    0x93930e05: "Lost Jungle Rose Act 2 Rings Collected: 54",
    0x93930e06: "Lost Jungle Rose Act 2 Rings Collected: 55",
    0x93930e07: "Lost Jungle Rose Act 2 Rings Collected: 56",
    0x93930e08: "Lost Jungle Rose Act 2 Rings Collected: 57",
    0x93930e09: "Lost Jungle Rose Act 2 Rings Collected: 58",
    0x93930e0a: "Lost Jungle Rose Act 2 Rings Collected: 59",
    0x93930e0b: "Lost Jungle Rose Act 2 Rings Collected: 60",
    0x93930e0c: "Lost Jungle Rose Act 2 Rings Collected: 61",
    0x93930e0d: "Lost Jungle Rose Act 2 Rings Collected: 62",
    0x93930e0e: "Lost Jungle Rose Act 2 Rings Collected: 63",
    0x93930e0f: "Lost Jungle Rose Act 2 Rings Collected: 64",
    0x93930e10: "Lost Jungle Rose Act 2 Rings Collected: 65",
    0x93930e11: "Lost Jungle Rose Act 2 Rings Collected: 66",
    0x93930e12: "Lost Jungle Rose Act 2 Rings Collected: 67",
    0x93930e13: "Lost Jungle Rose Act 2 Rings Collected: 68",
    0x93930e14: "Lost Jungle Rose Act 2 Rings Collected: 69",
    0x93930e15: "Lost Jungle Rose Act 2 Rings Collected: 70",
    0x93930e16: "Lost Jungle Rose Act 2 Rings Collected: 71",
    0x93930e17: "Lost Jungle Rose Act 2 Rings Collected: 72",
    0x93930e18: "Lost Jungle Rose Act 2 Rings Collected: 73",
    0x93930e19: "Lost Jungle Rose Act 2 Rings Collected: 74",
    0x93930e1a: "Lost Jungle Rose Act 2 Rings Collected: 75",
    0x93930e1b: "Lost Jungle Rose Act 2 Rings Collected: 76",
    0x93930e1c: "Lost Jungle Rose Act 2 Rings Collected: 77",
    0x93930e1d: "Lost Jungle Rose Act 2 Rings Collected: 78",
    0x93930e1e: "Lost Jungle Rose Act 2 Rings Collected: 79",
    0x93930e1f: "Lost Jungle Rose Act 2 Rings Collected: 80",
    0x93930e20: "Lost Jungle Rose Act 2 Rings Collected: 81",
    0x93930e21: "Lost Jungle Rose Act 2 Rings Collected: 82",
    0x93930e22: "Lost Jungle Rose Act 2 Rings Collected: 83",
    0x93930e23: "Lost Jungle Rose Act 2 Rings Collected: 84",
    0x93930e24: "Lost Jungle Rose Act 2 Rings Collected: 85",
    0x93930e25: "Lost Jungle Rose Act 2 Rings Collected: 86",
    0x93930e26: "Lost Jungle Rose Act 2 Rings Collected: 87",
    0x93930e27: "Lost Jungle Rose Act 2 Rings Collected: 88",
    0x93930e28: "Lost Jungle Rose Act 2 Rings Collected: 89",
    0x93930e29: "Lost Jungle Rose Act 2 Rings Collected: 90",
    0x93930e2a: "Lost Jungle Rose Act 2 Rings Collected: 91",
    0x93930e2b: "Lost Jungle Rose Act 2 Rings Collected: 92",
    0x93930e2c: "Lost Jungle Rose Act 2 Rings Collected: 93",
    0x93930e2d: "Lost Jungle Rose Act 2 Rings Collected: 94",
    0x93930e2e: "Lost Jungle Rose Act 2 Rings Collected: 95",
    0x93930e2f: "Lost Jungle Rose Act 2 Rings Collected: 96",
    0x93930e30: "Lost Jungle Rose Act 2 Rings Collected: 97",
    0x93930e31: "Lost Jungle Rose Act 2 Rings Collected: 98",
    0x93930e32: "Lost Jungle Rose Act 2 Rings Collected: 99",
    0x93930e33: "Lost Jungle Rose Act 2 Rings Collected: 100",
    0x93930e34: "Lost Jungle Rose Act 2 Rings Collected: 101",
    0x93930e35: "Lost Jungle Rose Act 2 Rings Collected: 102",
    0x93930e36: "Lost Jungle Rose Act 2 Rings Collected: 103",
    0x93930e37: "Lost Jungle Rose Act 2 Rings Collected: 104",
    0x93930e38: "Lost Jungle Rose Act 2 Rings Collected: 105",
    0x93930e39: "Lost Jungle Rose Act 2 Rings Collected: 106",
    0x93930e3a: "Lost Jungle Rose Act 2 Rings Collected: 107",
    0x93930e3b: "Lost Jungle Rose Act 2 Rings Collected: 108",
    0x93930e3c: "Lost Jungle Rose Act 2 Rings Collected: 109",
    0x93930e3d: "Lost Jungle Rose Act 2 Rings Collected: 110",
    0x93930e3e: "Lost Jungle Rose Act 2 Rings Collected: 111",
    0x93930e3f: "Lost Jungle Rose Act 2 Rings Collected: 112",
    0x93930e40: "Lost Jungle Rose Act 2 Rings Collected: 113",
    0x93930e41: "Lost Jungle Rose Act 2 Rings Collected: 114",
    0x93930e42: "Lost Jungle Rose Act 2 Rings Collected: 115",
    0x93930e43: "Lost Jungle Rose Act 2 Rings Collected: 116",
    0x93930e44: "Lost Jungle Rose Act 2 Rings Collected: 117",
    0x93930e45: "Lost Jungle Rose Act 2 Rings Collected: 118",
    0x93930e46: "Lost Jungle Rose Act 2 Rings Collected: 119",
    0x93930e47: "Lost Jungle Rose Act 2 Rings Collected: 120",
    0x93930e48: "Lost Jungle Rose Act 2 Rings Collected: 121",
    0x93930e49: "Lost Jungle Rose Act 2 Rings Collected: 122",
    0x93930e4a: "Lost Jungle Rose Act 2 Rings Collected: 123",
    0x93930e4b: "Lost Jungle Rose Act 2 Rings Collected: 124",
    0x93930e4c: "Lost Jungle Rose Act 2 Rings Collected: 125",
    0x93930e4d: "Lost Jungle Rose Act 2 Rings Collected: 126",
    0x93930e4e: "Lost Jungle Rose Act 2 Rings Collected: 127",
    0x93930e4f: "Lost Jungle Rose Act 2 Rings Collected: 128",
    0x93930e50: "Lost Jungle Rose Act 2 Rings Collected: 129",
    0x93930e51: "Lost Jungle Rose Act 2 Rings Collected: 130",
    0x93930e52: "Lost Jungle Rose Act 2 Rings Collected: 131",
    0x93930e53: "Lost Jungle Rose Act 2 Rings Collected: 132",
    0x93930e54: "Lost Jungle Rose Act 2 Rings Collected: 133",
    0x93930e55: "Lost Jungle Rose Act 2 Rings Collected: 134",
    0x93930e56: "Lost Jungle Rose Act 2 Rings Collected: 135",
    0x93930e57: "Lost Jungle Rose Act 2 Rings Collected: 136",
    0x93930e58: "Lost Jungle Rose Act 2 Rings Collected: 137",
    0x93930e59: "Lost Jungle Rose Act 2 Rings Collected: 138",
    0x93930e5a: "Lost Jungle Rose Act 2 Rings Collected: 139",
    0x93930e5b: "Lost Jungle Rose Act 2 Rings Collected: 140",
    0x93930e5c: "Lost Jungle Rose Act 2 Rings Collected: 141",
    0x93930e5d: "Lost Jungle Rose Act 2 Rings Collected: 142",
    0x93930e5e: "Lost Jungle Rose Act 2 Rings Collected: 143",
    0x93930e5f: "Lost Jungle Rose Act 2 Rings Collected: 144",
    0x93930e60: "Lost Jungle Rose Act 2 Rings Collected: 145",
    0x93930e61: "Lost Jungle Rose Act 2 Rings Collected: 146",
    0x93930e62: "Lost Jungle Rose Act 2 Rings Collected: 147",
    0x93930e63: "Lost Jungle Rose Act 2 Rings Collected: 148",
    0x93930e64: "Lost Jungle Rose Act 2 Rings Collected: 149",
    0x93930e65: "Lost Jungle Rose Act 2 Rings Collected: 150",
    0x93930e66: "Lost Jungle Rose Act 2 Rings Collected: 151",
    0x93930e67: "Lost Jungle Rose Act 2 Rings Collected: 152",
    0x93930e68: "Lost Jungle Rose Act 2 Rings Collected: 153",
    0x93930e69: "Lost Jungle Rose Act 2 Rings Collected: 154",
    0x93930e6a: "Lost Jungle Rose Act 2 Rings Collected: 155",
    0x93930e6b: "Lost Jungle Rose Act 2 Rings Collected: 156",
    0x93930e6c: "Lost Jungle Rose Act 2 Rings Collected: 157",
    0x93930e6d: "Lost Jungle Rose Act 2 Rings Collected: 158",
    0x93930e6e: "Lost Jungle Rose Act 2 Rings Collected: 159",
    0x93930e6f: "Lost Jungle Rose Act 2 Rings Collected: 160",
    0x93930e70: "Lost Jungle Rose Act 2 Rings Collected: 161",
    0x93930e71: "Lost Jungle Rose Act 2 Rings Collected: 162",
    0x93930e72: "Lost Jungle Rose Act 2 Rings Collected: 163",
    0x93930e73: "Lost Jungle Rose Act 2 Rings Collected: 164",
    0x93930e74: "Lost Jungle Rose Act 2 Rings Collected: 165",
    0x93930e75: "Lost Jungle Rose Act 2 Rings Collected: 166",
    0x93930e76: "Lost Jungle Rose Act 2 Rings Collected: 167",
    0x93930e77: "Lost Jungle Rose Act 2 Rings Collected: 168",
    0x93930e78: "Lost Jungle Rose Act 2 Rings Collected: 169",
    0x93930e79: "Lost Jungle Rose Act 2 Rings Collected: 170",
    0x93930e7a: "Lost Jungle Rose Act 2 Rings Collected: 171",
    0x93930e7b: "Lost Jungle Rose Act 2 Rings Collected: 172",
    0x93930e7c: "Lost Jungle Rose Act 2 Rings Collected: 173",
    0x93930e7d: "Lost Jungle Rose Act 2 Rings Collected: 174",
    0x93930e7e: "Lost Jungle Rose Act 2 Rings Collected: 175",
    0x93930e7f: "Lost Jungle Rose Act 2 Rings Collected: 176",
    0x93930e80: "Lost Jungle Rose Act 2 Rings Collected: 177",
    0x93930e81: "Lost Jungle Rose Act 2 Rings Collected: 178",
    0x93930e82: "Lost Jungle Rose Act 2 Rings Collected: 179",
    0x93930e83: "Lost Jungle Rose Act 2 Rings Collected: 180",
    0x93930e84: "Lost Jungle Rose Act 2 Rings Collected: 181",
    0x93930e85: "Lost Jungle Rose Act 2 Rings Collected: 182",
    0x93930e86: "Lost Jungle Rose Act 2 Rings Collected: 183",
    0x93930e87: "Lost Jungle Rose Act 2 Rings Collected: 184",
    0x93930e88: "Lost Jungle Rose Act 2 Rings Collected: 185",
    0x93930e89: "Lost Jungle Rose Act 2 Rings Collected: 186",
    0x93930e8a: "Lost Jungle Rose Act 2 Rings Collected: 187",
    0x93930e8b: "Lost Jungle Rose Act 2 Rings Collected: 188",
    0x93930e8c: "Lost Jungle Rose Act 2 Rings Collected: 189",
    0x93930e8d: "Lost Jungle Rose Act 2 Rings Collected: 190",
    0x93930e8e: "Lost Jungle Rose Act 2 Rings Collected: 191",
    0x93930e8f: "Lost Jungle Rose Act 2 Rings Collected: 192",
    0x93930e90: "Lost Jungle Rose Act 2 Rings Collected: 193",
    0x93930e91: "Lost Jungle Rose Act 2 Rings Collected: 194",
    0x93930e92: "Lost Jungle Rose Act 2 Rings Collected: 195",
    0x93930e93: "Lost Jungle Rose Act 2 Rings Collected: 196",
    0x93930e94: "Lost Jungle Rose Act 2 Rings Collected: 197",
    0x93930e95: "Lost Jungle Rose Act 2 Rings Collected: 198",
    0x93930e96: "Lost Jungle Rose Act 2 Rings Collected: 199",
    0x93930e97: "Lost Jungle Rose Act 2 Rings Collected: 200",
    0x93930e98: "Hang Castle Rose Act 2 Rings Collected: 1",
    0x93930e99: "Hang Castle Rose Act 2 Rings Collected: 2",
    0x93930e9a: "Hang Castle Rose Act 2 Rings Collected: 3",
    0x93930e9b: "Hang Castle Rose Act 2 Rings Collected: 4",
    0x93930e9c: "Hang Castle Rose Act 2 Rings Collected: 5",
    0x93930e9d: "Hang Castle Rose Act 2 Rings Collected: 6",
    0x93930e9e: "Hang Castle Rose Act 2 Rings Collected: 7",
    0x93930e9f: "Hang Castle Rose Act 2 Rings Collected: 8",
    0x93930ea0: "Hang Castle Rose Act 2 Rings Collected: 9",
    0x93930ea1: "Hang Castle Rose Act 2 Rings Collected: 10",
    0x93930ea2: "Hang Castle Rose Act 2 Rings Collected: 11",
    0x93930ea3: "Hang Castle Rose Act 2 Rings Collected: 12",
    0x93930ea4: "Hang Castle Rose Act 2 Rings Collected: 13",
    0x93930ea5: "Hang Castle Rose Act 2 Rings Collected: 14",
    0x93930ea6: "Hang Castle Rose Act 2 Rings Collected: 15",
    0x93930ea7: "Hang Castle Rose Act 2 Rings Collected: 16",
    0x93930ea8: "Hang Castle Rose Act 2 Rings Collected: 17",
    0x93930ea9: "Hang Castle Rose Act 2 Rings Collected: 18",
    0x93930eaa: "Hang Castle Rose Act 2 Rings Collected: 19",
    0x93930eab: "Hang Castle Rose Act 2 Rings Collected: 20",
    0x93930eac: "Hang Castle Rose Act 2 Rings Collected: 21",
    0x93930ead: "Hang Castle Rose Act 2 Rings Collected: 22",
    0x93930eae: "Hang Castle Rose Act 2 Rings Collected: 23",
    0x93930eaf: "Hang Castle Rose Act 2 Rings Collected: 24",
    0x93930eb0: "Hang Castle Rose Act 2 Rings Collected: 25",
    0x93930eb1: "Hang Castle Rose Act 2 Rings Collected: 26",
    0x93930eb2: "Hang Castle Rose Act 2 Rings Collected: 27",
    0x93930eb3: "Hang Castle Rose Act 2 Rings Collected: 28",
    0x93930eb4: "Hang Castle Rose Act 2 Rings Collected: 29",
    0x93930eb5: "Hang Castle Rose Act 2 Rings Collected: 30",
    0x93930eb6: "Hang Castle Rose Act 2 Rings Collected: 31",
    0x93930eb7: "Hang Castle Rose Act 2 Rings Collected: 32",
    0x93930eb8: "Hang Castle Rose Act 2 Rings Collected: 33",
    0x93930eb9: "Hang Castle Rose Act 2 Rings Collected: 34",
    0x93930eba: "Hang Castle Rose Act 2 Rings Collected: 35",
    0x93930ebb: "Hang Castle Rose Act 2 Rings Collected: 36",
    0x93930ebc: "Hang Castle Rose Act 2 Rings Collected: 37",
    0x93930ebd: "Hang Castle Rose Act 2 Rings Collected: 38",
    0x93930ebe: "Hang Castle Rose Act 2 Rings Collected: 39",
    0x93930ebf: "Hang Castle Rose Act 2 Rings Collected: 40",
    0x93930ec0: "Hang Castle Rose Act 2 Rings Collected: 41",
    0x93930ec1: "Hang Castle Rose Act 2 Rings Collected: 42",
    0x93930ec2: "Hang Castle Rose Act 2 Rings Collected: 43",
    0x93930ec3: "Hang Castle Rose Act 2 Rings Collected: 44",
    0x93930ec4: "Hang Castle Rose Act 2 Rings Collected: 45",
    0x93930ec5: "Hang Castle Rose Act 2 Rings Collected: 46",
    0x93930ec6: "Hang Castle Rose Act 2 Rings Collected: 47",
    0x93930ec7: "Hang Castle Rose Act 2 Rings Collected: 48",
    0x93930ec8: "Hang Castle Rose Act 2 Rings Collected: 49",
    0x93930ec9: "Hang Castle Rose Act 2 Rings Collected: 50",
    0x93930eca: "Hang Castle Rose Act 2 Rings Collected: 51",
    0x93930ecb: "Hang Castle Rose Act 2 Rings Collected: 52",
    0x93930ecc: "Hang Castle Rose Act 2 Rings Collected: 53",
    0x93930ecd: "Hang Castle Rose Act 2 Rings Collected: 54",
    0x93930ece: "Hang Castle Rose Act 2 Rings Collected: 55",
    0x93930ecf: "Hang Castle Rose Act 2 Rings Collected: 56",
    0x93930ed0: "Hang Castle Rose Act 2 Rings Collected: 57",
    0x93930ed1: "Hang Castle Rose Act 2 Rings Collected: 58",
    0x93930ed2: "Hang Castle Rose Act 2 Rings Collected: 59",
    0x93930ed3: "Hang Castle Rose Act 2 Rings Collected: 60",
    0x93930ed4: "Hang Castle Rose Act 2 Rings Collected: 61",
    0x93930ed5: "Hang Castle Rose Act 2 Rings Collected: 62",
    0x93930ed6: "Hang Castle Rose Act 2 Rings Collected: 63",
    0x93930ed7: "Hang Castle Rose Act 2 Rings Collected: 64",
    0x93930ed8: "Hang Castle Rose Act 2 Rings Collected: 65",
    0x93930ed9: "Hang Castle Rose Act 2 Rings Collected: 66",
    0x93930eda: "Hang Castle Rose Act 2 Rings Collected: 67",
    0x93930edb: "Hang Castle Rose Act 2 Rings Collected: 68",
    0x93930edc: "Hang Castle Rose Act 2 Rings Collected: 69",
    0x93930edd: "Hang Castle Rose Act 2 Rings Collected: 70",
    0x93930ede: "Hang Castle Rose Act 2 Rings Collected: 71",
    0x93930edf: "Hang Castle Rose Act 2 Rings Collected: 72",
    0x93930ee0: "Hang Castle Rose Act 2 Rings Collected: 73",
    0x93930ee1: "Hang Castle Rose Act 2 Rings Collected: 74",
    0x93930ee2: "Hang Castle Rose Act 2 Rings Collected: 75",
    0x93930ee3: "Hang Castle Rose Act 2 Rings Collected: 76",
    0x93930ee4: "Hang Castle Rose Act 2 Rings Collected: 77",
    0x93930ee5: "Hang Castle Rose Act 2 Rings Collected: 78",
    0x93930ee6: "Hang Castle Rose Act 2 Rings Collected: 79",
    0x93930ee7: "Hang Castle Rose Act 2 Rings Collected: 80",
    0x93930ee8: "Hang Castle Rose Act 2 Rings Collected: 81",
    0x93930ee9: "Hang Castle Rose Act 2 Rings Collected: 82",
    0x93930eea: "Hang Castle Rose Act 2 Rings Collected: 83",
    0x93930eeb: "Hang Castle Rose Act 2 Rings Collected: 84",
    0x93930eec: "Hang Castle Rose Act 2 Rings Collected: 85",
    0x93930eed: "Hang Castle Rose Act 2 Rings Collected: 86",
    0x93930eee: "Hang Castle Rose Act 2 Rings Collected: 87",
    0x93930eef: "Hang Castle Rose Act 2 Rings Collected: 88",
    0x93930ef0: "Hang Castle Rose Act 2 Rings Collected: 89",
    0x93930ef1: "Hang Castle Rose Act 2 Rings Collected: 90",
    0x93930ef2: "Hang Castle Rose Act 2 Rings Collected: 91",
    0x93930ef3: "Hang Castle Rose Act 2 Rings Collected: 92",
    0x93930ef4: "Hang Castle Rose Act 2 Rings Collected: 93",
    0x93930ef5: "Hang Castle Rose Act 2 Rings Collected: 94",
    0x93930ef6: "Hang Castle Rose Act 2 Rings Collected: 95",
    0x93930ef7: "Hang Castle Rose Act 2 Rings Collected: 96",
    0x93930ef8: "Hang Castle Rose Act 2 Rings Collected: 97",
    0x93930ef9: "Hang Castle Rose Act 2 Rings Collected: 98",
    0x93930efa: "Hang Castle Rose Act 2 Rings Collected: 99",
    0x93930efb: "Hang Castle Rose Act 2 Rings Collected: 100",
    0x93930efc: "Hang Castle Rose Act 2 Rings Collected: 101",
    0x93930efd: "Hang Castle Rose Act 2 Rings Collected: 102",
    0x93930efe: "Hang Castle Rose Act 2 Rings Collected: 103",
    0x93930eff: "Hang Castle Rose Act 2 Rings Collected: 104",
    0x93930f00: "Hang Castle Rose Act 2 Rings Collected: 105",
    0x93930f01: "Hang Castle Rose Act 2 Rings Collected: 106",
    0x93930f02: "Hang Castle Rose Act 2 Rings Collected: 107",
    0x93930f03: "Hang Castle Rose Act 2 Rings Collected: 108",
    0x93930f04: "Hang Castle Rose Act 2 Rings Collected: 109",
    0x93930f05: "Hang Castle Rose Act 2 Rings Collected: 110",
    0x93930f06: "Hang Castle Rose Act 2 Rings Collected: 111",
    0x93930f07: "Hang Castle Rose Act 2 Rings Collected: 112",
    0x93930f08: "Hang Castle Rose Act 2 Rings Collected: 113",
    0x93930f09: "Hang Castle Rose Act 2 Rings Collected: 114",
    0x93930f0a: "Hang Castle Rose Act 2 Rings Collected: 115",
    0x93930f0b: "Hang Castle Rose Act 2 Rings Collected: 116",
    0x93930f0c: "Hang Castle Rose Act 2 Rings Collected: 117",
    0x93930f0d: "Hang Castle Rose Act 2 Rings Collected: 118",
    0x93930f0e: "Hang Castle Rose Act 2 Rings Collected: 119",
    0x93930f0f: "Hang Castle Rose Act 2 Rings Collected: 120",
    0x93930f10: "Hang Castle Rose Act 2 Rings Collected: 121",
    0x93930f11: "Hang Castle Rose Act 2 Rings Collected: 122",
    0x93930f12: "Hang Castle Rose Act 2 Rings Collected: 123",
    0x93930f13: "Hang Castle Rose Act 2 Rings Collected: 124",
    0x93930f14: "Hang Castle Rose Act 2 Rings Collected: 125",
    0x93930f15: "Hang Castle Rose Act 2 Rings Collected: 126",
    0x93930f16: "Hang Castle Rose Act 2 Rings Collected: 127",
    0x93930f17: "Hang Castle Rose Act 2 Rings Collected: 128",
    0x93930f18: "Hang Castle Rose Act 2 Rings Collected: 129",
    0x93930f19: "Hang Castle Rose Act 2 Rings Collected: 130",
    0x93930f1a: "Hang Castle Rose Act 2 Rings Collected: 131",
    0x93930f1b: "Hang Castle Rose Act 2 Rings Collected: 132",
    0x93930f1c: "Hang Castle Rose Act 2 Rings Collected: 133",
    0x93930f1d: "Hang Castle Rose Act 2 Rings Collected: 134",
    0x93930f1e: "Hang Castle Rose Act 2 Rings Collected: 135",
    0x93930f1f: "Hang Castle Rose Act 2 Rings Collected: 136",
    0x93930f20: "Hang Castle Rose Act 2 Rings Collected: 137",
    0x93930f21: "Hang Castle Rose Act 2 Rings Collected: 138",
    0x93930f22: "Hang Castle Rose Act 2 Rings Collected: 139",
    0x93930f23: "Hang Castle Rose Act 2 Rings Collected: 140",
    0x93930f24: "Hang Castle Rose Act 2 Rings Collected: 141",
    0x93930f25: "Hang Castle Rose Act 2 Rings Collected: 142",
    0x93930f26: "Hang Castle Rose Act 2 Rings Collected: 143",
    0x93930f27: "Hang Castle Rose Act 2 Rings Collected: 144",
    0x93930f28: "Hang Castle Rose Act 2 Rings Collected: 145",
    0x93930f29: "Hang Castle Rose Act 2 Rings Collected: 146",
    0x93930f2a: "Hang Castle Rose Act 2 Rings Collected: 147",
    0x93930f2b: "Hang Castle Rose Act 2 Rings Collected: 148",
    0x93930f2c: "Hang Castle Rose Act 2 Rings Collected: 149",
    0x93930f2d: "Hang Castle Rose Act 2 Rings Collected: 150",
    0x93930f2e: "Hang Castle Rose Act 2 Rings Collected: 151",
    0x93930f2f: "Hang Castle Rose Act 2 Rings Collected: 152",
    0x93930f30: "Hang Castle Rose Act 2 Rings Collected: 153",
    0x93930f31: "Hang Castle Rose Act 2 Rings Collected: 154",
    0x93930f32: "Hang Castle Rose Act 2 Rings Collected: 155",
    0x93930f33: "Hang Castle Rose Act 2 Rings Collected: 156",
    0x93930f34: "Hang Castle Rose Act 2 Rings Collected: 157",
    0x93930f35: "Hang Castle Rose Act 2 Rings Collected: 158",
    0x93930f36: "Hang Castle Rose Act 2 Rings Collected: 159",
    0x93930f37: "Hang Castle Rose Act 2 Rings Collected: 160",
    0x93930f38: "Hang Castle Rose Act 2 Rings Collected: 161",
    0x93930f39: "Hang Castle Rose Act 2 Rings Collected: 162",
    0x93930f3a: "Hang Castle Rose Act 2 Rings Collected: 163",
    0x93930f3b: "Hang Castle Rose Act 2 Rings Collected: 164",
    0x93930f3c: "Hang Castle Rose Act 2 Rings Collected: 165",
    0x93930f3d: "Hang Castle Rose Act 2 Rings Collected: 166",
    0x93930f3e: "Hang Castle Rose Act 2 Rings Collected: 167",
    0x93930f3f: "Hang Castle Rose Act 2 Rings Collected: 168",
    0x93930f40: "Hang Castle Rose Act 2 Rings Collected: 169",
    0x93930f41: "Hang Castle Rose Act 2 Rings Collected: 170",
    0x93930f42: "Hang Castle Rose Act 2 Rings Collected: 171",
    0x93930f43: "Hang Castle Rose Act 2 Rings Collected: 172",
    0x93930f44: "Hang Castle Rose Act 2 Rings Collected: 173",
    0x93930f45: "Hang Castle Rose Act 2 Rings Collected: 174",
    0x93930f46: "Hang Castle Rose Act 2 Rings Collected: 175",
    0x93930f47: "Hang Castle Rose Act 2 Rings Collected: 176",
    0x93930f48: "Hang Castle Rose Act 2 Rings Collected: 177",
    0x93930f49: "Hang Castle Rose Act 2 Rings Collected: 178",
    0x93930f4a: "Hang Castle Rose Act 2 Rings Collected: 179",
    0x93930f4b: "Hang Castle Rose Act 2 Rings Collected: 180",
    0x93930f4c: "Hang Castle Rose Act 2 Rings Collected: 181",
    0x93930f4d: "Hang Castle Rose Act 2 Rings Collected: 182",
    0x93930f4e: "Hang Castle Rose Act 2 Rings Collected: 183",
    0x93930f4f: "Hang Castle Rose Act 2 Rings Collected: 184",
    0x93930f50: "Hang Castle Rose Act 2 Rings Collected: 185",
    0x93930f51: "Hang Castle Rose Act 2 Rings Collected: 186",
    0x93930f52: "Hang Castle Rose Act 2 Rings Collected: 187",
    0x93930f53: "Hang Castle Rose Act 2 Rings Collected: 188",
    0x93930f54: "Hang Castle Rose Act 2 Rings Collected: 189",
    0x93930f55: "Hang Castle Rose Act 2 Rings Collected: 190",
    0x93930f56: "Hang Castle Rose Act 2 Rings Collected: 191",
    0x93930f57: "Hang Castle Rose Act 2 Rings Collected: 192",
    0x93930f58: "Hang Castle Rose Act 2 Rings Collected: 193",
    0x93930f59: "Hang Castle Rose Act 2 Rings Collected: 194",
    0x93930f5a: "Hang Castle Rose Act 2 Rings Collected: 195",
    0x93930f5b: "Hang Castle Rose Act 2 Rings Collected: 196",
    0x93930f5c: "Hang Castle Rose Act 2 Rings Collected: 197",
    0x93930f5d: "Hang Castle Rose Act 2 Rings Collected: 198",
    0x93930f5e: "Hang Castle Rose Act 2 Rings Collected: 199",
    0x93930f5f: "Hang Castle Rose Act 2 Rings Collected: 200",
    0x93930f60: "Mystic Mansion Rose Act 2 Rings Collected: 1",
    0x93930f61: "Mystic Mansion Rose Act 2 Rings Collected: 2",
    0x93930f62: "Mystic Mansion Rose Act 2 Rings Collected: 3",
    0x93930f63: "Mystic Mansion Rose Act 2 Rings Collected: 4",
    0x93930f64: "Mystic Mansion Rose Act 2 Rings Collected: 5",
    0x93930f65: "Mystic Mansion Rose Act 2 Rings Collected: 6",
    0x93930f66: "Mystic Mansion Rose Act 2 Rings Collected: 7",
    0x93930f67: "Mystic Mansion Rose Act 2 Rings Collected: 8",
    0x93930f68: "Mystic Mansion Rose Act 2 Rings Collected: 9",
    0x93930f69: "Mystic Mansion Rose Act 2 Rings Collected: 10",
    0x93930f6a: "Mystic Mansion Rose Act 2 Rings Collected: 11",
    0x93930f6b: "Mystic Mansion Rose Act 2 Rings Collected: 12",
    0x93930f6c: "Mystic Mansion Rose Act 2 Rings Collected: 13",
    0x93930f6d: "Mystic Mansion Rose Act 2 Rings Collected: 14",
    0x93930f6e: "Mystic Mansion Rose Act 2 Rings Collected: 15",
    0x93930f6f: "Mystic Mansion Rose Act 2 Rings Collected: 16",
    0x93930f70: "Mystic Mansion Rose Act 2 Rings Collected: 17",
    0x93930f71: "Mystic Mansion Rose Act 2 Rings Collected: 18",
    0x93930f72: "Mystic Mansion Rose Act 2 Rings Collected: 19",
    0x93930f73: "Mystic Mansion Rose Act 2 Rings Collected: 20",
    0x93930f74: "Mystic Mansion Rose Act 2 Rings Collected: 21",
    0x93930f75: "Mystic Mansion Rose Act 2 Rings Collected: 22",
    0x93930f76: "Mystic Mansion Rose Act 2 Rings Collected: 23",
    0x93930f77: "Mystic Mansion Rose Act 2 Rings Collected: 24",
    0x93930f78: "Mystic Mansion Rose Act 2 Rings Collected: 25",
    0x93930f79: "Mystic Mansion Rose Act 2 Rings Collected: 26",
    0x93930f7a: "Mystic Mansion Rose Act 2 Rings Collected: 27",
    0x93930f7b: "Mystic Mansion Rose Act 2 Rings Collected: 28",
    0x93930f7c: "Mystic Mansion Rose Act 2 Rings Collected: 29",
    0x93930f7d: "Mystic Mansion Rose Act 2 Rings Collected: 30",
    0x93930f7e: "Mystic Mansion Rose Act 2 Rings Collected: 31",
    0x93930f7f: "Mystic Mansion Rose Act 2 Rings Collected: 32",
    0x93930f80: "Mystic Mansion Rose Act 2 Rings Collected: 33",
    0x93930f81: "Mystic Mansion Rose Act 2 Rings Collected: 34",
    0x93930f82: "Mystic Mansion Rose Act 2 Rings Collected: 35",
    0x93930f83: "Mystic Mansion Rose Act 2 Rings Collected: 36",
    0x93930f84: "Mystic Mansion Rose Act 2 Rings Collected: 37",
    0x93930f85: "Mystic Mansion Rose Act 2 Rings Collected: 38",
    0x93930f86: "Mystic Mansion Rose Act 2 Rings Collected: 39",
    0x93930f87: "Mystic Mansion Rose Act 2 Rings Collected: 40",
    0x93930f88: "Mystic Mansion Rose Act 2 Rings Collected: 41",
    0x93930f89: "Mystic Mansion Rose Act 2 Rings Collected: 42",
    0x93930f8a: "Mystic Mansion Rose Act 2 Rings Collected: 43",
    0x93930f8b: "Mystic Mansion Rose Act 2 Rings Collected: 44",
    0x93930f8c: "Mystic Mansion Rose Act 2 Rings Collected: 45",
    0x93930f8d: "Mystic Mansion Rose Act 2 Rings Collected: 46",
    0x93930f8e: "Mystic Mansion Rose Act 2 Rings Collected: 47",
    0x93930f8f: "Mystic Mansion Rose Act 2 Rings Collected: 48",
    0x93930f90: "Mystic Mansion Rose Act 2 Rings Collected: 49",
    0x93930f91: "Mystic Mansion Rose Act 2 Rings Collected: 50",
    0x93930f92: "Mystic Mansion Rose Act 2 Rings Collected: 51",
    0x93930f93: "Mystic Mansion Rose Act 2 Rings Collected: 52",
    0x93930f94: "Mystic Mansion Rose Act 2 Rings Collected: 53",
    0x93930f95: "Mystic Mansion Rose Act 2 Rings Collected: 54",
    0x93930f96: "Mystic Mansion Rose Act 2 Rings Collected: 55",
    0x93930f97: "Mystic Mansion Rose Act 2 Rings Collected: 56",
    0x93930f98: "Mystic Mansion Rose Act 2 Rings Collected: 57",
    0x93930f99: "Mystic Mansion Rose Act 2 Rings Collected: 58",
    0x93930f9a: "Mystic Mansion Rose Act 2 Rings Collected: 59",
    0x93930f9b: "Mystic Mansion Rose Act 2 Rings Collected: 60",
    0x93930f9c: "Mystic Mansion Rose Act 2 Rings Collected: 61",
    0x93930f9d: "Mystic Mansion Rose Act 2 Rings Collected: 62",
    0x93930f9e: "Mystic Mansion Rose Act 2 Rings Collected: 63",
    0x93930f9f: "Mystic Mansion Rose Act 2 Rings Collected: 64",
    0x93930fa0: "Mystic Mansion Rose Act 2 Rings Collected: 65",
    0x93930fa1: "Mystic Mansion Rose Act 2 Rings Collected: 66",
    0x93930fa2: "Mystic Mansion Rose Act 2 Rings Collected: 67",
    0x93930fa3: "Mystic Mansion Rose Act 2 Rings Collected: 68",
    0x93930fa4: "Mystic Mansion Rose Act 2 Rings Collected: 69",
    0x93930fa5: "Mystic Mansion Rose Act 2 Rings Collected: 70",
    0x93930fa6: "Mystic Mansion Rose Act 2 Rings Collected: 71",
    0x93930fa7: "Mystic Mansion Rose Act 2 Rings Collected: 72",
    0x93930fa8: "Mystic Mansion Rose Act 2 Rings Collected: 73",
    0x93930fa9: "Mystic Mansion Rose Act 2 Rings Collected: 74",
    0x93930faa: "Mystic Mansion Rose Act 2 Rings Collected: 75",
    0x93930fab: "Mystic Mansion Rose Act 2 Rings Collected: 76",
    0x93930fac: "Mystic Mansion Rose Act 2 Rings Collected: 77",
    0x93930fad: "Mystic Mansion Rose Act 2 Rings Collected: 78",
    0x93930fae: "Mystic Mansion Rose Act 2 Rings Collected: 79",
    0x93930faf: "Mystic Mansion Rose Act 2 Rings Collected: 80",
    0x93930fb0: "Mystic Mansion Rose Act 2 Rings Collected: 81",
    0x93930fb1: "Mystic Mansion Rose Act 2 Rings Collected: 82",
    0x93930fb2: "Mystic Mansion Rose Act 2 Rings Collected: 83",
    0x93930fb3: "Mystic Mansion Rose Act 2 Rings Collected: 84",
    0x93930fb4: "Mystic Mansion Rose Act 2 Rings Collected: 85",
    0x93930fb5: "Mystic Mansion Rose Act 2 Rings Collected: 86",
    0x93930fb6: "Mystic Mansion Rose Act 2 Rings Collected: 87",
    0x93930fb7: "Mystic Mansion Rose Act 2 Rings Collected: 88",
    0x93930fb8: "Mystic Mansion Rose Act 2 Rings Collected: 89",
    0x93930fb9: "Mystic Mansion Rose Act 2 Rings Collected: 90",
    0x93930fba: "Mystic Mansion Rose Act 2 Rings Collected: 91",
    0x93930fbb: "Mystic Mansion Rose Act 2 Rings Collected: 92",
    0x93930fbc: "Mystic Mansion Rose Act 2 Rings Collected: 93",
    0x93930fbd: "Mystic Mansion Rose Act 2 Rings Collected: 94",
    0x93930fbe: "Mystic Mansion Rose Act 2 Rings Collected: 95",
    0x93930fbf: "Mystic Mansion Rose Act 2 Rings Collected: 96",
    0x93930fc0: "Mystic Mansion Rose Act 2 Rings Collected: 97",
    0x93930fc1: "Mystic Mansion Rose Act 2 Rings Collected: 98",
    0x93930fc2: "Mystic Mansion Rose Act 2 Rings Collected: 99",
    0x93930fc3: "Mystic Mansion Rose Act 2 Rings Collected: 100",
    0x93930fc4: "Mystic Mansion Rose Act 2 Rings Collected: 101",
    0x93930fc5: "Mystic Mansion Rose Act 2 Rings Collected: 102",
    0x93930fc6: "Mystic Mansion Rose Act 2 Rings Collected: 103",
    0x93930fc7: "Mystic Mansion Rose Act 2 Rings Collected: 104",
    0x93930fc8: "Mystic Mansion Rose Act 2 Rings Collected: 105",
    0x93930fc9: "Mystic Mansion Rose Act 2 Rings Collected: 106",
    0x93930fca: "Mystic Mansion Rose Act 2 Rings Collected: 107",
    0x93930fcb: "Mystic Mansion Rose Act 2 Rings Collected: 108",
    0x93930fcc: "Mystic Mansion Rose Act 2 Rings Collected: 109",
    0x93930fcd: "Mystic Mansion Rose Act 2 Rings Collected: 110",
    0x93930fce: "Mystic Mansion Rose Act 2 Rings Collected: 111",
    0x93930fcf: "Mystic Mansion Rose Act 2 Rings Collected: 112",
    0x93930fd0: "Mystic Mansion Rose Act 2 Rings Collected: 113",
    0x93930fd1: "Mystic Mansion Rose Act 2 Rings Collected: 114",
    0x93930fd2: "Mystic Mansion Rose Act 2 Rings Collected: 115",
    0x93930fd3: "Mystic Mansion Rose Act 2 Rings Collected: 116",
    0x93930fd4: "Mystic Mansion Rose Act 2 Rings Collected: 117",
    0x93930fd5: "Mystic Mansion Rose Act 2 Rings Collected: 118",
    0x93930fd6: "Mystic Mansion Rose Act 2 Rings Collected: 119",
    0x93930fd7: "Mystic Mansion Rose Act 2 Rings Collected: 120",
    0x93930fd8: "Mystic Mansion Rose Act 2 Rings Collected: 121",
    0x93930fd9: "Mystic Mansion Rose Act 2 Rings Collected: 122",
    0x93930fda: "Mystic Mansion Rose Act 2 Rings Collected: 123",
    0x93930fdb: "Mystic Mansion Rose Act 2 Rings Collected: 124",
    0x93930fdc: "Mystic Mansion Rose Act 2 Rings Collected: 125",
    0x93930fdd: "Mystic Mansion Rose Act 2 Rings Collected: 126",
    0x93930fde: "Mystic Mansion Rose Act 2 Rings Collected: 127",
    0x93930fdf: "Mystic Mansion Rose Act 2 Rings Collected: 128",
    0x93930fe0: "Mystic Mansion Rose Act 2 Rings Collected: 129",
    0x93930fe1: "Mystic Mansion Rose Act 2 Rings Collected: 130",
    0x93930fe2: "Mystic Mansion Rose Act 2 Rings Collected: 131",
    0x93930fe3: "Mystic Mansion Rose Act 2 Rings Collected: 132",
    0x93930fe4: "Mystic Mansion Rose Act 2 Rings Collected: 133",
    0x93930fe5: "Mystic Mansion Rose Act 2 Rings Collected: 134",
    0x93930fe6: "Mystic Mansion Rose Act 2 Rings Collected: 135",
    0x93930fe7: "Mystic Mansion Rose Act 2 Rings Collected: 136",
    0x93930fe8: "Mystic Mansion Rose Act 2 Rings Collected: 137",
    0x93930fe9: "Mystic Mansion Rose Act 2 Rings Collected: 138",
    0x93930fea: "Mystic Mansion Rose Act 2 Rings Collected: 139",
    0x93930feb: "Mystic Mansion Rose Act 2 Rings Collected: 140",
    0x93930fec: "Mystic Mansion Rose Act 2 Rings Collected: 141",
    0x93930fed: "Mystic Mansion Rose Act 2 Rings Collected: 142",
    0x93930fee: "Mystic Mansion Rose Act 2 Rings Collected: 143",
    0x93930fef: "Mystic Mansion Rose Act 2 Rings Collected: 144",
    0x93930ff0: "Mystic Mansion Rose Act 2 Rings Collected: 145",
    0x93930ff1: "Mystic Mansion Rose Act 2 Rings Collected: 146",
    0x93930ff2: "Mystic Mansion Rose Act 2 Rings Collected: 147",
    0x93930ff3: "Mystic Mansion Rose Act 2 Rings Collected: 148",
    0x93930ff4: "Mystic Mansion Rose Act 2 Rings Collected: 149",
    0x93930ff5: "Mystic Mansion Rose Act 2 Rings Collected: 150",
    0x93930ff6: "Mystic Mansion Rose Act 2 Rings Collected: 151",
    0x93930ff7: "Mystic Mansion Rose Act 2 Rings Collected: 152",
    0x93930ff8: "Mystic Mansion Rose Act 2 Rings Collected: 153",
    0x93930ff9: "Mystic Mansion Rose Act 2 Rings Collected: 154",
    0x93930ffa: "Mystic Mansion Rose Act 2 Rings Collected: 155",
    0x93930ffb: "Mystic Mansion Rose Act 2 Rings Collected: 156",
    0x93930ffc: "Mystic Mansion Rose Act 2 Rings Collected: 157",
    0x93930ffd: "Mystic Mansion Rose Act 2 Rings Collected: 158",
    0x93930ffe: "Mystic Mansion Rose Act 2 Rings Collected: 159",
    0x93930fff: "Mystic Mansion Rose Act 2 Rings Collected: 160",
    0x93931000: "Mystic Mansion Rose Act 2 Rings Collected: 161",
    0x93931001: "Mystic Mansion Rose Act 2 Rings Collected: 162",
    0x93931002: "Mystic Mansion Rose Act 2 Rings Collected: 163",
    0x93931003: "Mystic Mansion Rose Act 2 Rings Collected: 164",
    0x93931004: "Mystic Mansion Rose Act 2 Rings Collected: 165",
    0x93931005: "Mystic Mansion Rose Act 2 Rings Collected: 166",
    0x93931006: "Mystic Mansion Rose Act 2 Rings Collected: 167",
    0x93931007: "Mystic Mansion Rose Act 2 Rings Collected: 168",
    0x93931008: "Mystic Mansion Rose Act 2 Rings Collected: 169",
    0x93931009: "Mystic Mansion Rose Act 2 Rings Collected: 170",
    0x9393100a: "Mystic Mansion Rose Act 2 Rings Collected: 171",
    0x9393100b: "Mystic Mansion Rose Act 2 Rings Collected: 172",
    0x9393100c: "Mystic Mansion Rose Act 2 Rings Collected: 173",
    0x9393100d: "Mystic Mansion Rose Act 2 Rings Collected: 174",
    0x9393100e: "Mystic Mansion Rose Act 2 Rings Collected: 175",
    0x9393100f: "Mystic Mansion Rose Act 2 Rings Collected: 176",
    0x93931010: "Mystic Mansion Rose Act 2 Rings Collected: 177",
    0x93931011: "Mystic Mansion Rose Act 2 Rings Collected: 178",
    0x93931012: "Mystic Mansion Rose Act 2 Rings Collected: 179",
    0x93931013: "Mystic Mansion Rose Act 2 Rings Collected: 180",
    0x93931014: "Mystic Mansion Rose Act 2 Rings Collected: 181",
    0x93931015: "Mystic Mansion Rose Act 2 Rings Collected: 182",
    0x93931016: "Mystic Mansion Rose Act 2 Rings Collected: 183",
    0x93931017: "Mystic Mansion Rose Act 2 Rings Collected: 184",
    0x93931018: "Mystic Mansion Rose Act 2 Rings Collected: 185",
    0x93931019: "Mystic Mansion Rose Act 2 Rings Collected: 186",
    0x9393101a: "Mystic Mansion Rose Act 2 Rings Collected: 187",
    0x9393101b: "Mystic Mansion Rose Act 2 Rings Collected: 188",
    0x9393101c: "Mystic Mansion Rose Act 2 Rings Collected: 189",
    0x9393101d: "Mystic Mansion Rose Act 2 Rings Collected: 190",
    0x9393101e: "Mystic Mansion Rose Act 2 Rings Collected: 191",
    0x9393101f: "Mystic Mansion Rose Act 2 Rings Collected: 192",
    0x93931020: "Mystic Mansion Rose Act 2 Rings Collected: 193",
    0x93931021: "Mystic Mansion Rose Act 2 Rings Collected: 194",
    0x93931022: "Mystic Mansion Rose Act 2 Rings Collected: 195",
    0x93931023: "Mystic Mansion Rose Act 2 Rings Collected: 196",
    0x93931024: "Mystic Mansion Rose Act 2 Rings Collected: 197",
    0x93931025: "Mystic Mansion Rose Act 2 Rings Collected: 198",
    0x93931026: "Mystic Mansion Rose Act 2 Rings Collected: 199",
    0x93931027: "Mystic Mansion Rose Act 2 Rings Collected: 200",
    0x93931028: "Egg Fleet Rose Act 2 Rings Collected: 1",
    0x93931029: "Egg Fleet Rose Act 2 Rings Collected: 2",
    0x9393102a: "Egg Fleet Rose Act 2 Rings Collected: 3",
    0x9393102b: "Egg Fleet Rose Act 2 Rings Collected: 4",
    0x9393102c: "Egg Fleet Rose Act 2 Rings Collected: 5",
    0x9393102d: "Egg Fleet Rose Act 2 Rings Collected: 6",
    0x9393102e: "Egg Fleet Rose Act 2 Rings Collected: 7",
    0x9393102f: "Egg Fleet Rose Act 2 Rings Collected: 8",
    0x93931030: "Egg Fleet Rose Act 2 Rings Collected: 9",
    0x93931031: "Egg Fleet Rose Act 2 Rings Collected: 10",
    0x93931032: "Egg Fleet Rose Act 2 Rings Collected: 11",
    0x93931033: "Egg Fleet Rose Act 2 Rings Collected: 12",
    0x93931034: "Egg Fleet Rose Act 2 Rings Collected: 13",
    0x93931035: "Egg Fleet Rose Act 2 Rings Collected: 14",
    0x93931036: "Egg Fleet Rose Act 2 Rings Collected: 15",
    0x93931037: "Egg Fleet Rose Act 2 Rings Collected: 16",
    0x93931038: "Egg Fleet Rose Act 2 Rings Collected: 17",
    0x93931039: "Egg Fleet Rose Act 2 Rings Collected: 18",
    0x9393103a: "Egg Fleet Rose Act 2 Rings Collected: 19",
    0x9393103b: "Egg Fleet Rose Act 2 Rings Collected: 20",
    0x9393103c: "Egg Fleet Rose Act 2 Rings Collected: 21",
    0x9393103d: "Egg Fleet Rose Act 2 Rings Collected: 22",
    0x9393103e: "Egg Fleet Rose Act 2 Rings Collected: 23",
    0x9393103f: "Egg Fleet Rose Act 2 Rings Collected: 24",
    0x93931040: "Egg Fleet Rose Act 2 Rings Collected: 25",
    0x93931041: "Egg Fleet Rose Act 2 Rings Collected: 26",
    0x93931042: "Egg Fleet Rose Act 2 Rings Collected: 27",
    0x93931043: "Egg Fleet Rose Act 2 Rings Collected: 28",
    0x93931044: "Egg Fleet Rose Act 2 Rings Collected: 29",
    0x93931045: "Egg Fleet Rose Act 2 Rings Collected: 30",
    0x93931046: "Egg Fleet Rose Act 2 Rings Collected: 31",
    0x93931047: "Egg Fleet Rose Act 2 Rings Collected: 32",
    0x93931048: "Egg Fleet Rose Act 2 Rings Collected: 33",
    0x93931049: "Egg Fleet Rose Act 2 Rings Collected: 34",
    0x9393104a: "Egg Fleet Rose Act 2 Rings Collected: 35",
    0x9393104b: "Egg Fleet Rose Act 2 Rings Collected: 36",
    0x9393104c: "Egg Fleet Rose Act 2 Rings Collected: 37",
    0x9393104d: "Egg Fleet Rose Act 2 Rings Collected: 38",
    0x9393104e: "Egg Fleet Rose Act 2 Rings Collected: 39",
    0x9393104f: "Egg Fleet Rose Act 2 Rings Collected: 40",
    0x93931050: "Egg Fleet Rose Act 2 Rings Collected: 41",
    0x93931051: "Egg Fleet Rose Act 2 Rings Collected: 42",
    0x93931052: "Egg Fleet Rose Act 2 Rings Collected: 43",
    0x93931053: "Egg Fleet Rose Act 2 Rings Collected: 44",
    0x93931054: "Egg Fleet Rose Act 2 Rings Collected: 45",
    0x93931055: "Egg Fleet Rose Act 2 Rings Collected: 46",
    0x93931056: "Egg Fleet Rose Act 2 Rings Collected: 47",
    0x93931057: "Egg Fleet Rose Act 2 Rings Collected: 48",
    0x93931058: "Egg Fleet Rose Act 2 Rings Collected: 49",
    0x93931059: "Egg Fleet Rose Act 2 Rings Collected: 50",
    0x9393105a: "Egg Fleet Rose Act 2 Rings Collected: 51",
    0x9393105b: "Egg Fleet Rose Act 2 Rings Collected: 52",
    0x9393105c: "Egg Fleet Rose Act 2 Rings Collected: 53",
    0x9393105d: "Egg Fleet Rose Act 2 Rings Collected: 54",
    0x9393105e: "Egg Fleet Rose Act 2 Rings Collected: 55",
    0x9393105f: "Egg Fleet Rose Act 2 Rings Collected: 56",
    0x93931060: "Egg Fleet Rose Act 2 Rings Collected: 57",
    0x93931061: "Egg Fleet Rose Act 2 Rings Collected: 58",
    0x93931062: "Egg Fleet Rose Act 2 Rings Collected: 59",
    0x93931063: "Egg Fleet Rose Act 2 Rings Collected: 60",
    0x93931064: "Egg Fleet Rose Act 2 Rings Collected: 61",
    0x93931065: "Egg Fleet Rose Act 2 Rings Collected: 62",
    0x93931066: "Egg Fleet Rose Act 2 Rings Collected: 63",
    0x93931067: "Egg Fleet Rose Act 2 Rings Collected: 64",
    0x93931068: "Egg Fleet Rose Act 2 Rings Collected: 65",
    0x93931069: "Egg Fleet Rose Act 2 Rings Collected: 66",
    0x9393106a: "Egg Fleet Rose Act 2 Rings Collected: 67",
    0x9393106b: "Egg Fleet Rose Act 2 Rings Collected: 68",
    0x9393106c: "Egg Fleet Rose Act 2 Rings Collected: 69",
    0x9393106d: "Egg Fleet Rose Act 2 Rings Collected: 70",
    0x9393106e: "Egg Fleet Rose Act 2 Rings Collected: 71",
    0x9393106f: "Egg Fleet Rose Act 2 Rings Collected: 72",
    0x93931070: "Egg Fleet Rose Act 2 Rings Collected: 73",
    0x93931071: "Egg Fleet Rose Act 2 Rings Collected: 74",
    0x93931072: "Egg Fleet Rose Act 2 Rings Collected: 75",
    0x93931073: "Egg Fleet Rose Act 2 Rings Collected: 76",
    0x93931074: "Egg Fleet Rose Act 2 Rings Collected: 77",
    0x93931075: "Egg Fleet Rose Act 2 Rings Collected: 78",
    0x93931076: "Egg Fleet Rose Act 2 Rings Collected: 79",
    0x93931077: "Egg Fleet Rose Act 2 Rings Collected: 80",
    0x93931078: "Egg Fleet Rose Act 2 Rings Collected: 81",
    0x93931079: "Egg Fleet Rose Act 2 Rings Collected: 82",
    0x9393107a: "Egg Fleet Rose Act 2 Rings Collected: 83",
    0x9393107b: "Egg Fleet Rose Act 2 Rings Collected: 84",
    0x9393107c: "Egg Fleet Rose Act 2 Rings Collected: 85",
    0x9393107d: "Egg Fleet Rose Act 2 Rings Collected: 86",
    0x9393107e: "Egg Fleet Rose Act 2 Rings Collected: 87",
    0x9393107f: "Egg Fleet Rose Act 2 Rings Collected: 88",
    0x93931080: "Egg Fleet Rose Act 2 Rings Collected: 89",
    0x93931081: "Egg Fleet Rose Act 2 Rings Collected: 90",
    0x93931082: "Egg Fleet Rose Act 2 Rings Collected: 91",
    0x93931083: "Egg Fleet Rose Act 2 Rings Collected: 92",
    0x93931084: "Egg Fleet Rose Act 2 Rings Collected: 93",
    0x93931085: "Egg Fleet Rose Act 2 Rings Collected: 94",
    0x93931086: "Egg Fleet Rose Act 2 Rings Collected: 95",
    0x93931087: "Egg Fleet Rose Act 2 Rings Collected: 96",
    0x93931088: "Egg Fleet Rose Act 2 Rings Collected: 97",
    0x93931089: "Egg Fleet Rose Act 2 Rings Collected: 98",
    0x9393108a: "Egg Fleet Rose Act 2 Rings Collected: 99",
    0x9393108b: "Egg Fleet Rose Act 2 Rings Collected: 100",
    0x9393108c: "Egg Fleet Rose Act 2 Rings Collected: 101",
    0x9393108d: "Egg Fleet Rose Act 2 Rings Collected: 102",
    0x9393108e: "Egg Fleet Rose Act 2 Rings Collected: 103",
    0x9393108f: "Egg Fleet Rose Act 2 Rings Collected: 104",
    0x93931090: "Egg Fleet Rose Act 2 Rings Collected: 105",
    0x93931091: "Egg Fleet Rose Act 2 Rings Collected: 106",
    0x93931092: "Egg Fleet Rose Act 2 Rings Collected: 107",
    0x93931093: "Egg Fleet Rose Act 2 Rings Collected: 108",
    0x93931094: "Egg Fleet Rose Act 2 Rings Collected: 109",
    0x93931095: "Egg Fleet Rose Act 2 Rings Collected: 110",
    0x93931096: "Egg Fleet Rose Act 2 Rings Collected: 111",
    0x93931097: "Egg Fleet Rose Act 2 Rings Collected: 112",
    0x93931098: "Egg Fleet Rose Act 2 Rings Collected: 113",
    0x93931099: "Egg Fleet Rose Act 2 Rings Collected: 114",
    0x9393109a: "Egg Fleet Rose Act 2 Rings Collected: 115",
    0x9393109b: "Egg Fleet Rose Act 2 Rings Collected: 116",
    0x9393109c: "Egg Fleet Rose Act 2 Rings Collected: 117",
    0x9393109d: "Egg Fleet Rose Act 2 Rings Collected: 118",
    0x9393109e: "Egg Fleet Rose Act 2 Rings Collected: 119",
    0x9393109f: "Egg Fleet Rose Act 2 Rings Collected: 120",
    0x939310a0: "Egg Fleet Rose Act 2 Rings Collected: 121",
    0x939310a1: "Egg Fleet Rose Act 2 Rings Collected: 122",
    0x939310a2: "Egg Fleet Rose Act 2 Rings Collected: 123",
    0x939310a3: "Egg Fleet Rose Act 2 Rings Collected: 124",
    0x939310a4: "Egg Fleet Rose Act 2 Rings Collected: 125",
    0x939310a5: "Egg Fleet Rose Act 2 Rings Collected: 126",
    0x939310a6: "Egg Fleet Rose Act 2 Rings Collected: 127",
    0x939310a7: "Egg Fleet Rose Act 2 Rings Collected: 128",
    0x939310a8: "Egg Fleet Rose Act 2 Rings Collected: 129",
    0x939310a9: "Egg Fleet Rose Act 2 Rings Collected: 130",
    0x939310aa: "Egg Fleet Rose Act 2 Rings Collected: 131",
    0x939310ab: "Egg Fleet Rose Act 2 Rings Collected: 132",
    0x939310ac: "Egg Fleet Rose Act 2 Rings Collected: 133",
    0x939310ad: "Egg Fleet Rose Act 2 Rings Collected: 134",
    0x939310ae: "Egg Fleet Rose Act 2 Rings Collected: 135",
    0x939310af: "Egg Fleet Rose Act 2 Rings Collected: 136",
    0x939310b0: "Egg Fleet Rose Act 2 Rings Collected: 137",
    0x939310b1: "Egg Fleet Rose Act 2 Rings Collected: 138",
    0x939310b2: "Egg Fleet Rose Act 2 Rings Collected: 139",
    0x939310b3: "Egg Fleet Rose Act 2 Rings Collected: 140",
    0x939310b4: "Egg Fleet Rose Act 2 Rings Collected: 141",
    0x939310b5: "Egg Fleet Rose Act 2 Rings Collected: 142",
    0x939310b6: "Egg Fleet Rose Act 2 Rings Collected: 143",
    0x939310b7: "Egg Fleet Rose Act 2 Rings Collected: 144",
    0x939310b8: "Egg Fleet Rose Act 2 Rings Collected: 145",
    0x939310b9: "Egg Fleet Rose Act 2 Rings Collected: 146",
    0x939310ba: "Egg Fleet Rose Act 2 Rings Collected: 147",
    0x939310bb: "Egg Fleet Rose Act 2 Rings Collected: 148",
    0x939310bc: "Egg Fleet Rose Act 2 Rings Collected: 149",
    0x939310bd: "Egg Fleet Rose Act 2 Rings Collected: 150",
    0x939310be: "Egg Fleet Rose Act 2 Rings Collected: 151",
    0x939310bf: "Egg Fleet Rose Act 2 Rings Collected: 152",
    0x939310c0: "Egg Fleet Rose Act 2 Rings Collected: 153",
    0x939310c1: "Egg Fleet Rose Act 2 Rings Collected: 154",
    0x939310c2: "Egg Fleet Rose Act 2 Rings Collected: 155",
    0x939310c3: "Egg Fleet Rose Act 2 Rings Collected: 156",
    0x939310c4: "Egg Fleet Rose Act 2 Rings Collected: 157",
    0x939310c5: "Egg Fleet Rose Act 2 Rings Collected: 158",
    0x939310c6: "Egg Fleet Rose Act 2 Rings Collected: 159",
    0x939310c7: "Egg Fleet Rose Act 2 Rings Collected: 160",
    0x939310c8: "Egg Fleet Rose Act 2 Rings Collected: 161",
    0x939310c9: "Egg Fleet Rose Act 2 Rings Collected: 162",
    0x939310ca: "Egg Fleet Rose Act 2 Rings Collected: 163",
    0x939310cb: "Egg Fleet Rose Act 2 Rings Collected: 164",
    0x939310cc: "Egg Fleet Rose Act 2 Rings Collected: 165",
    0x939310cd: "Egg Fleet Rose Act 2 Rings Collected: 166",
    0x939310ce: "Egg Fleet Rose Act 2 Rings Collected: 167",
    0x939310cf: "Egg Fleet Rose Act 2 Rings Collected: 168",
    0x939310d0: "Egg Fleet Rose Act 2 Rings Collected: 169",
    0x939310d1: "Egg Fleet Rose Act 2 Rings Collected: 170",
    0x939310d2: "Egg Fleet Rose Act 2 Rings Collected: 171",
    0x939310d3: "Egg Fleet Rose Act 2 Rings Collected: 172",
    0x939310d4: "Egg Fleet Rose Act 2 Rings Collected: 173",
    0x939310d5: "Egg Fleet Rose Act 2 Rings Collected: 174",
    0x939310d6: "Egg Fleet Rose Act 2 Rings Collected: 175",
    0x939310d7: "Egg Fleet Rose Act 2 Rings Collected: 176",
    0x939310d8: "Egg Fleet Rose Act 2 Rings Collected: 177",
    0x939310d9: "Egg Fleet Rose Act 2 Rings Collected: 178",
    0x939310da: "Egg Fleet Rose Act 2 Rings Collected: 179",
    0x939310db: "Egg Fleet Rose Act 2 Rings Collected: 180",
    0x939310dc: "Egg Fleet Rose Act 2 Rings Collected: 181",
    0x939310dd: "Egg Fleet Rose Act 2 Rings Collected: 182",
    0x939310de: "Egg Fleet Rose Act 2 Rings Collected: 183",
    0x939310df: "Egg Fleet Rose Act 2 Rings Collected: 184",
    0x939310e0: "Egg Fleet Rose Act 2 Rings Collected: 185",
    0x939310e1: "Egg Fleet Rose Act 2 Rings Collected: 186",
    0x939310e2: "Egg Fleet Rose Act 2 Rings Collected: 187",
    0x939310e3: "Egg Fleet Rose Act 2 Rings Collected: 188",
    0x939310e4: "Egg Fleet Rose Act 2 Rings Collected: 189",
    0x939310e5: "Egg Fleet Rose Act 2 Rings Collected: 190",
    0x939310e6: "Egg Fleet Rose Act 2 Rings Collected: 191",
    0x939310e7: "Egg Fleet Rose Act 2 Rings Collected: 192",
    0x939310e8: "Egg Fleet Rose Act 2 Rings Collected: 193",
    0x939310e9: "Egg Fleet Rose Act 2 Rings Collected: 194",
    0x939310ea: "Egg Fleet Rose Act 2 Rings Collected: 195",
    0x939310eb: "Egg Fleet Rose Act 2 Rings Collected: 196",
    0x939310ec: "Egg Fleet Rose Act 2 Rings Collected: 197",
    0x939310ed: "Egg Fleet Rose Act 2 Rings Collected: 198",
    0x939310ee: "Egg Fleet Rose Act 2 Rings Collected: 199",
    0x939310ef: "Egg Fleet Rose Act 2 Rings Collected: 200",
    0x939310f0: "Final Fortress Rose Act 2 Rings Collected: 1",
    0x939310f1: "Final Fortress Rose Act 2 Rings Collected: 2",
    0x939310f2: "Final Fortress Rose Act 2 Rings Collected: 3",
    0x939310f3: "Final Fortress Rose Act 2 Rings Collected: 4",
    0x939310f4: "Final Fortress Rose Act 2 Rings Collected: 5",
    0x939310f5: "Final Fortress Rose Act 2 Rings Collected: 6",
    0x939310f6: "Final Fortress Rose Act 2 Rings Collected: 7",
    0x939310f7: "Final Fortress Rose Act 2 Rings Collected: 8",
    0x939310f8: "Final Fortress Rose Act 2 Rings Collected: 9",
    0x939310f9: "Final Fortress Rose Act 2 Rings Collected: 10",
    0x939310fa: "Final Fortress Rose Act 2 Rings Collected: 11",
    0x939310fb: "Final Fortress Rose Act 2 Rings Collected: 12",
    0x939310fc: "Final Fortress Rose Act 2 Rings Collected: 13",
    0x939310fd: "Final Fortress Rose Act 2 Rings Collected: 14",
    0x939310fe: "Final Fortress Rose Act 2 Rings Collected: 15",
    0x939310ff: "Final Fortress Rose Act 2 Rings Collected: 16",
    0x93931100: "Final Fortress Rose Act 2 Rings Collected: 17",
    0x93931101: "Final Fortress Rose Act 2 Rings Collected: 18",
    0x93931102: "Final Fortress Rose Act 2 Rings Collected: 19",
    0x93931103: "Final Fortress Rose Act 2 Rings Collected: 20",
    0x93931104: "Final Fortress Rose Act 2 Rings Collected: 21",
    0x93931105: "Final Fortress Rose Act 2 Rings Collected: 22",
    0x93931106: "Final Fortress Rose Act 2 Rings Collected: 23",
    0x93931107: "Final Fortress Rose Act 2 Rings Collected: 24",
    0x93931108: "Final Fortress Rose Act 2 Rings Collected: 25",
    0x93931109: "Final Fortress Rose Act 2 Rings Collected: 26",
    0x9393110a: "Final Fortress Rose Act 2 Rings Collected: 27",
    0x9393110b: "Final Fortress Rose Act 2 Rings Collected: 28",
    0x9393110c: "Final Fortress Rose Act 2 Rings Collected: 29",
    0x9393110d: "Final Fortress Rose Act 2 Rings Collected: 30",
    0x9393110e: "Final Fortress Rose Act 2 Rings Collected: 31",
    0x9393110f: "Final Fortress Rose Act 2 Rings Collected: 32",
    0x93931110: "Final Fortress Rose Act 2 Rings Collected: 33",
    0x93931111: "Final Fortress Rose Act 2 Rings Collected: 34",
    0x93931112: "Final Fortress Rose Act 2 Rings Collected: 35",
    0x93931113: "Final Fortress Rose Act 2 Rings Collected: 36",
    0x93931114: "Final Fortress Rose Act 2 Rings Collected: 37",
    0x93931115: "Final Fortress Rose Act 2 Rings Collected: 38",
    0x93931116: "Final Fortress Rose Act 2 Rings Collected: 39",
    0x93931117: "Final Fortress Rose Act 2 Rings Collected: 40",
    0x93931118: "Final Fortress Rose Act 2 Rings Collected: 41",
    0x93931119: "Final Fortress Rose Act 2 Rings Collected: 42",
    0x9393111a: "Final Fortress Rose Act 2 Rings Collected: 43",
    0x9393111b: "Final Fortress Rose Act 2 Rings Collected: 44",
    0x9393111c: "Final Fortress Rose Act 2 Rings Collected: 45",
    0x9393111d: "Final Fortress Rose Act 2 Rings Collected: 46",
    0x9393111e: "Final Fortress Rose Act 2 Rings Collected: 47",
    0x9393111f: "Final Fortress Rose Act 2 Rings Collected: 48",
    0x93931120: "Final Fortress Rose Act 2 Rings Collected: 49",
    0x93931121: "Final Fortress Rose Act 2 Rings Collected: 50",
    0x93931122: "Final Fortress Rose Act 2 Rings Collected: 51",
    0x93931123: "Final Fortress Rose Act 2 Rings Collected: 52",
    0x93931124: "Final Fortress Rose Act 2 Rings Collected: 53",
    0x93931125: "Final Fortress Rose Act 2 Rings Collected: 54",
    0x93931126: "Final Fortress Rose Act 2 Rings Collected: 55",
    0x93931127: "Final Fortress Rose Act 2 Rings Collected: 56",
    0x93931128: "Final Fortress Rose Act 2 Rings Collected: 57",
    0x93931129: "Final Fortress Rose Act 2 Rings Collected: 58",
    0x9393112a: "Final Fortress Rose Act 2 Rings Collected: 59",
    0x9393112b: "Final Fortress Rose Act 2 Rings Collected: 60",
    0x9393112c: "Final Fortress Rose Act 2 Rings Collected: 61",
    0x9393112d: "Final Fortress Rose Act 2 Rings Collected: 62",
    0x9393112e: "Final Fortress Rose Act 2 Rings Collected: 63",
    0x9393112f: "Final Fortress Rose Act 2 Rings Collected: 64",
    0x93931130: "Final Fortress Rose Act 2 Rings Collected: 65",
    0x93931131: "Final Fortress Rose Act 2 Rings Collected: 66",
    0x93931132: "Final Fortress Rose Act 2 Rings Collected: 67",
    0x93931133: "Final Fortress Rose Act 2 Rings Collected: 68",
    0x93931134: "Final Fortress Rose Act 2 Rings Collected: 69",
    0x93931135: "Final Fortress Rose Act 2 Rings Collected: 70",
    0x93931136: "Final Fortress Rose Act 2 Rings Collected: 71",
    0x93931137: "Final Fortress Rose Act 2 Rings Collected: 72",
    0x93931138: "Final Fortress Rose Act 2 Rings Collected: 73",
    0x93931139: "Final Fortress Rose Act 2 Rings Collected: 74",
    0x9393113a: "Final Fortress Rose Act 2 Rings Collected: 75",
    0x9393113b: "Final Fortress Rose Act 2 Rings Collected: 76",
    0x9393113c: "Final Fortress Rose Act 2 Rings Collected: 77",
    0x9393113d: "Final Fortress Rose Act 2 Rings Collected: 78",
    0x9393113e: "Final Fortress Rose Act 2 Rings Collected: 79",
    0x9393113f: "Final Fortress Rose Act 2 Rings Collected: 80",
    0x93931140: "Final Fortress Rose Act 2 Rings Collected: 81",
    0x93931141: "Final Fortress Rose Act 2 Rings Collected: 82",
    0x93931142: "Final Fortress Rose Act 2 Rings Collected: 83",
    0x93931143: "Final Fortress Rose Act 2 Rings Collected: 84",
    0x93931144: "Final Fortress Rose Act 2 Rings Collected: 85",
    0x93931145: "Final Fortress Rose Act 2 Rings Collected: 86",
    0x93931146: "Final Fortress Rose Act 2 Rings Collected: 87",
    0x93931147: "Final Fortress Rose Act 2 Rings Collected: 88",
    0x93931148: "Final Fortress Rose Act 2 Rings Collected: 89",
    0x93931149: "Final Fortress Rose Act 2 Rings Collected: 90",
    0x9393114a: "Final Fortress Rose Act 2 Rings Collected: 91",
    0x9393114b: "Final Fortress Rose Act 2 Rings Collected: 92",
    0x9393114c: "Final Fortress Rose Act 2 Rings Collected: 93",
    0x9393114d: "Final Fortress Rose Act 2 Rings Collected: 94",
    0x9393114e: "Final Fortress Rose Act 2 Rings Collected: 95",
    0x9393114f: "Final Fortress Rose Act 2 Rings Collected: 96",
    0x93931150: "Final Fortress Rose Act 2 Rings Collected: 97",
    0x93931151: "Final Fortress Rose Act 2 Rings Collected: 98",
    0x93931152: "Final Fortress Rose Act 2 Rings Collected: 99",
    0x93931153: "Final Fortress Rose Act 2 Rings Collected: 100",
    0x93931154: "Final Fortress Rose Act 2 Rings Collected: 101",
    0x93931155: "Final Fortress Rose Act 2 Rings Collected: 102",
    0x93931156: "Final Fortress Rose Act 2 Rings Collected: 103",
    0x93931157: "Final Fortress Rose Act 2 Rings Collected: 104",
    0x93931158: "Final Fortress Rose Act 2 Rings Collected: 105",
    0x93931159: "Final Fortress Rose Act 2 Rings Collected: 106",
    0x9393115a: "Final Fortress Rose Act 2 Rings Collected: 107",
    0x9393115b: "Final Fortress Rose Act 2 Rings Collected: 108",
    0x9393115c: "Final Fortress Rose Act 2 Rings Collected: 109",
    0x9393115d: "Final Fortress Rose Act 2 Rings Collected: 110",
    0x9393115e: "Final Fortress Rose Act 2 Rings Collected: 111",
    0x9393115f: "Final Fortress Rose Act 2 Rings Collected: 112",
    0x93931160: "Final Fortress Rose Act 2 Rings Collected: 113",
    0x93931161: "Final Fortress Rose Act 2 Rings Collected: 114",
    0x93931162: "Final Fortress Rose Act 2 Rings Collected: 115",
    0x93931163: "Final Fortress Rose Act 2 Rings Collected: 116",
    0x93931164: "Final Fortress Rose Act 2 Rings Collected: 117",
    0x93931165: "Final Fortress Rose Act 2 Rings Collected: 118",
    0x93931166: "Final Fortress Rose Act 2 Rings Collected: 119",
    0x93931167: "Final Fortress Rose Act 2 Rings Collected: 120",
    0x93931168: "Final Fortress Rose Act 2 Rings Collected: 121",
    0x93931169: "Final Fortress Rose Act 2 Rings Collected: 122",
    0x9393116a: "Final Fortress Rose Act 2 Rings Collected: 123",
    0x9393116b: "Final Fortress Rose Act 2 Rings Collected: 124",
    0x9393116c: "Final Fortress Rose Act 2 Rings Collected: 125",
    0x9393116d: "Final Fortress Rose Act 2 Rings Collected: 126",
    0x9393116e: "Final Fortress Rose Act 2 Rings Collected: 127",
    0x9393116f: "Final Fortress Rose Act 2 Rings Collected: 128",
    0x93931170: "Final Fortress Rose Act 2 Rings Collected: 129",
    0x93931171: "Final Fortress Rose Act 2 Rings Collected: 130",
    0x93931172: "Final Fortress Rose Act 2 Rings Collected: 131",
    0x93931173: "Final Fortress Rose Act 2 Rings Collected: 132",
    0x93931174: "Final Fortress Rose Act 2 Rings Collected: 133",
    0x93931175: "Final Fortress Rose Act 2 Rings Collected: 134",
    0x93931176: "Final Fortress Rose Act 2 Rings Collected: 135",
    0x93931177: "Final Fortress Rose Act 2 Rings Collected: 136",
    0x93931178: "Final Fortress Rose Act 2 Rings Collected: 137",
    0x93931179: "Final Fortress Rose Act 2 Rings Collected: 138",
    0x9393117a: "Final Fortress Rose Act 2 Rings Collected: 139",
    0x9393117b: "Final Fortress Rose Act 2 Rings Collected: 140",
    0x9393117c: "Final Fortress Rose Act 2 Rings Collected: 141",
    0x9393117d: "Final Fortress Rose Act 2 Rings Collected: 142",
    0x9393117e: "Final Fortress Rose Act 2 Rings Collected: 143",
    0x9393117f: "Final Fortress Rose Act 2 Rings Collected: 144",
    0x93931180: "Final Fortress Rose Act 2 Rings Collected: 145",
    0x93931181: "Final Fortress Rose Act 2 Rings Collected: 146",
    0x93931182: "Final Fortress Rose Act 2 Rings Collected: 147",
    0x93931183: "Final Fortress Rose Act 2 Rings Collected: 148",
    0x93931184: "Final Fortress Rose Act 2 Rings Collected: 149",
    0x93931185: "Final Fortress Rose Act 2 Rings Collected: 150",
    0x93931186: "Final Fortress Rose Act 2 Rings Collected: 151",
    0x93931187: "Final Fortress Rose Act 2 Rings Collected: 152",
    0x93931188: "Final Fortress Rose Act 2 Rings Collected: 153",
    0x93931189: "Final Fortress Rose Act 2 Rings Collected: 154",
    0x9393118a: "Final Fortress Rose Act 2 Rings Collected: 155",
    0x9393118b: "Final Fortress Rose Act 2 Rings Collected: 156",
    0x9393118c: "Final Fortress Rose Act 2 Rings Collected: 157",
    0x9393118d: "Final Fortress Rose Act 2 Rings Collected: 158",
    0x9393118e: "Final Fortress Rose Act 2 Rings Collected: 159",
    0x9393118f: "Final Fortress Rose Act 2 Rings Collected: 160",
    0x93931190: "Final Fortress Rose Act 2 Rings Collected: 161",
    0x93931191: "Final Fortress Rose Act 2 Rings Collected: 162",
    0x93931192: "Final Fortress Rose Act 2 Rings Collected: 163",
    0x93931193: "Final Fortress Rose Act 2 Rings Collected: 164",
    0x93931194: "Final Fortress Rose Act 2 Rings Collected: 165",
    0x93931195: "Final Fortress Rose Act 2 Rings Collected: 166",
    0x93931196: "Final Fortress Rose Act 2 Rings Collected: 167",
    0x93931197: "Final Fortress Rose Act 2 Rings Collected: 168",
    0x93931198: "Final Fortress Rose Act 2 Rings Collected: 169",
    0x93931199: "Final Fortress Rose Act 2 Rings Collected: 170",
    0x9393119a: "Final Fortress Rose Act 2 Rings Collected: 171",
    0x9393119b: "Final Fortress Rose Act 2 Rings Collected: 172",
    0x9393119c: "Final Fortress Rose Act 2 Rings Collected: 173",
    0x9393119d: "Final Fortress Rose Act 2 Rings Collected: 174",
    0x9393119e: "Final Fortress Rose Act 2 Rings Collected: 175",
    0x9393119f: "Final Fortress Rose Act 2 Rings Collected: 176",
    0x939311a0: "Final Fortress Rose Act 2 Rings Collected: 177",
    0x939311a1: "Final Fortress Rose Act 2 Rings Collected: 178",
    0x939311a2: "Final Fortress Rose Act 2 Rings Collected: 179",
    0x939311a3: "Final Fortress Rose Act 2 Rings Collected: 180",
    0x939311a4: "Final Fortress Rose Act 2 Rings Collected: 181",
    0x939311a5: "Final Fortress Rose Act 2 Rings Collected: 182",
    0x939311a6: "Final Fortress Rose Act 2 Rings Collected: 183",
    0x939311a7: "Final Fortress Rose Act 2 Rings Collected: 184",
    0x939311a8: "Final Fortress Rose Act 2 Rings Collected: 185",
    0x939311a9: "Final Fortress Rose Act 2 Rings Collected: 186",
    0x939311aa: "Final Fortress Rose Act 2 Rings Collected: 187",
    0x939311ab: "Final Fortress Rose Act 2 Rings Collected: 188",
    0x939311ac: "Final Fortress Rose Act 2 Rings Collected: 189",
    0x939311ad: "Final Fortress Rose Act 2 Rings Collected: 190",
    0x939311ae: "Final Fortress Rose Act 2 Rings Collected: 191",
    0x939311af: "Final Fortress Rose Act 2 Rings Collected: 192",
    0x939311b0: "Final Fortress Rose Act 2 Rings Collected: 193",
    0x939311b1: "Final Fortress Rose Act 2 Rings Collected: 194",
    0x939311b2: "Final Fortress Rose Act 2 Rings Collected: 195",
    0x939311b3: "Final Fortress Rose Act 2 Rings Collected: 196",
    0x939311b4: "Final Fortress Rose Act 2 Rings Collected: 197",
    0x939311b5: "Final Fortress Rose Act 2 Rings Collected: 198",
    0x939311b6: "Final Fortress Rose Act 2 Rings Collected: 199",
    0x939311b7: "Final Fortress Rose Act 2 Rings Collected: 200",
    0x939311b8: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 1",
    0x939311b9: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 2",
    0x939311ba: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 3",
    0x939311bb: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 4",
    0x939311bc: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 5",
    0x939311bd: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 6",
    0x939311be: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 7",
    0x939311bf: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 8",
    0x939311c0: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 9",
    0x939311c1: "Seaside Hill Chaotix Act 1 Hermit Crabs Collected: 10",
    0x939311c2: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 1",
    0x939311c3: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 2",
    0x939311c4: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 3",
    0x939311c5: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 4",
    0x939311c6: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 5",
    0x939311c7: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 6",
    0x939311c8: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 7",
    0x939311c9: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 8",
    0x939311ca: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 9",
    0x939311cb: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 10",
    0x939311cc: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 11",
    0x939311cd: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 12",
    0x939311ce: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 13",
    0x939311cf: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 14",
    0x939311d0: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 15",
    0x939311d1: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 16",
    0x939311d2: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 17",
    0x939311d3: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 18",
    0x939311d4: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 19",
    0x939311d5: "Seaside Hill Chaotix Act 2 Hermit Crabs Collected: 20",
    0x939311d6: "Grand Metropolis Chaotix Act 1 Enemies Killed: 1",
    0x939311d7: "Grand Metropolis Chaotix Act 1 Enemies Killed: 2",
    0x939311d8: "Grand Metropolis Chaotix Act 1 Enemies Killed: 3",
    0x939311d9: "Grand Metropolis Chaotix Act 1 Enemies Killed: 4",
    0x939311da: "Grand Metropolis Chaotix Act 1 Enemies Killed: 5",
    0x939311db: "Grand Metropolis Chaotix Act 1 Enemies Killed: 6",
    0x939311dc: "Grand Metropolis Chaotix Act 1 Enemies Killed: 7",
    0x939311dd: "Grand Metropolis Chaotix Act 1 Enemies Killed: 8",
    0x939311de: "Grand Metropolis Chaotix Act 1 Enemies Killed: 9",
    0x939311df: "Grand Metropolis Chaotix Act 1 Enemies Killed: 10",
    0x939311e0: "Grand Metropolis Chaotix Act 1 Enemies Killed: 11",
    0x939311e1: "Grand Metropolis Chaotix Act 1 Enemies Killed: 12",
    0x939311e2: "Grand Metropolis Chaotix Act 1 Enemies Killed: 13",
    0x939311e3: "Grand Metropolis Chaotix Act 1 Enemies Killed: 14",
    0x939311e4: "Grand Metropolis Chaotix Act 1 Enemies Killed: 15",
    0x939311e5: "Grand Metropolis Chaotix Act 1 Enemies Killed: 16",
    0x939311e6: "Grand Metropolis Chaotix Act 1 Enemies Killed: 17",
    0x939311e7: "Grand Metropolis Chaotix Act 1 Enemies Killed: 18",
    0x939311e8: "Grand Metropolis Chaotix Act 1 Enemies Killed: 19",
    0x939311e9: "Grand Metropolis Chaotix Act 1 Enemies Killed: 20",
    0x939311ea: "Grand Metropolis Chaotix Act 1 Enemies Killed: 21",
    0x939311eb: "Grand Metropolis Chaotix Act 1 Enemies Killed: 22",
    0x939311ec: "Grand Metropolis Chaotix Act 1 Enemies Killed: 23",
    0x939311ed: "Grand Metropolis Chaotix Act 1 Enemies Killed: 24",
    0x939311ee: "Grand Metropolis Chaotix Act 1 Enemies Killed: 25",
    0x939311ef: "Grand Metropolis Chaotix Act 1 Enemies Killed: 26",
    0x939311f0: "Grand Metropolis Chaotix Act 1 Enemies Killed: 27",
    0x939311f1: "Grand Metropolis Chaotix Act 1 Enemies Killed: 28",
    0x939311f2: "Grand Metropolis Chaotix Act 1 Enemies Killed: 29",
    0x939311f3: "Grand Metropolis Chaotix Act 1 Enemies Killed: 30",
    0x939311f4: "Grand Metropolis Chaotix Act 1 Enemies Killed: 31",
    0x939311f5: "Grand Metropolis Chaotix Act 1 Enemies Killed: 32",
    0x939311f6: "Grand Metropolis Chaotix Act 1 Enemies Killed: 33",
    0x939311f7: "Grand Metropolis Chaotix Act 1 Enemies Killed: 34",
    0x939311f8: "Grand Metropolis Chaotix Act 1 Enemies Killed: 35",
    0x939311f9: "Grand Metropolis Chaotix Act 1 Enemies Killed: 36",
    0x939311fa: "Grand Metropolis Chaotix Act 1 Enemies Killed: 37",
    0x939311fb: "Grand Metropolis Chaotix Act 1 Enemies Killed: 38",
    0x939311fc: "Grand Metropolis Chaotix Act 1 Enemies Killed: 39",
    0x939311fd: "Grand Metropolis Chaotix Act 1 Enemies Killed: 40",
    0x939311fe: "Grand Metropolis Chaotix Act 1 Enemies Killed: 41",
    0x939311ff: "Grand Metropolis Chaotix Act 1 Enemies Killed: 42",
    0x93931200: "Grand Metropolis Chaotix Act 1 Enemies Killed: 43",
    0x93931201: "Grand Metropolis Chaotix Act 1 Enemies Killed: 44",
    0x93931202: "Grand Metropolis Chaotix Act 1 Enemies Killed: 45",
    0x93931203: "Grand Metropolis Chaotix Act 1 Enemies Killed: 46",
    0x93931204: "Grand Metropolis Chaotix Act 1 Enemies Killed: 47",
    0x93931205: "Grand Metropolis Chaotix Act 1 Enemies Killed: 48",
    0x93931206: "Grand Metropolis Chaotix Act 1 Enemies Killed: 49",
    0x93931207: "Grand Metropolis Chaotix Act 1 Enemies Killed: 50",
    0x93931208: "Grand Metropolis Chaotix Act 1 Enemies Killed: 51",
    0x93931209: "Grand Metropolis Chaotix Act 1 Enemies Killed: 52",
    0x9393120a: "Grand Metropolis Chaotix Act 1 Enemies Killed: 53",
    0x9393120b: "Grand Metropolis Chaotix Act 1 Enemies Killed: 54",
    0x9393120c: "Grand Metropolis Chaotix Act 1 Enemies Killed: 55",
    0x9393120d: "Grand Metropolis Chaotix Act 1 Enemies Killed: 56",
    0x9393120e: "Grand Metropolis Chaotix Act 1 Enemies Killed: 57",
    0x9393120f: "Grand Metropolis Chaotix Act 1 Enemies Killed: 58",
    0x93931210: "Grand Metropolis Chaotix Act 1 Enemies Killed: 59",
    0x93931211: "Grand Metropolis Chaotix Act 1 Enemies Killed: 60",
    0x93931212: "Grand Metropolis Chaotix Act 1 Enemies Killed: 61",
    0x93931213: "Grand Metropolis Chaotix Act 1 Enemies Killed: 62",
    0x93931214: "Grand Metropolis Chaotix Act 1 Enemies Killed: 63",
    0x93931215: "Grand Metropolis Chaotix Act 1 Enemies Killed: 64",
    0x93931216: "Grand Metropolis Chaotix Act 1 Enemies Killed: 65",
    0x93931217: "Grand Metropolis Chaotix Act 1 Enemies Killed: 66",
    0x93931218: "Grand Metropolis Chaotix Act 1 Enemies Killed: 67",
    0x93931219: "Grand Metropolis Chaotix Act 1 Enemies Killed: 68",
    0x9393121a: "Grand Metropolis Chaotix Act 1 Enemies Killed: 69",
    0x9393121b: "Grand Metropolis Chaotix Act 1 Enemies Killed: 70",
    0x9393121c: "Grand Metropolis Chaotix Act 1 Enemies Killed: 71",
    0x9393121d: "Grand Metropolis Chaotix Act 1 Enemies Killed: 72",
    0x9393121e: "Grand Metropolis Chaotix Act 1 Enemies Killed: 73",
    0x9393121f: "Grand Metropolis Chaotix Act 1 Enemies Killed: 74",
    0x93931220: "Grand Metropolis Chaotix Act 1 Enemies Killed: 75",
    0x93931221: "Grand Metropolis Chaotix Act 1 Enemies Killed: 76",
    0x93931222: "Grand Metropolis Chaotix Act 1 Enemies Killed: 77",
    0x93931223: "Grand Metropolis Chaotix Act 1 Enemies Killed: 78",
    0x93931224: "Grand Metropolis Chaotix Act 1 Enemies Killed: 79",
    0x93931225: "Grand Metropolis Chaotix Act 1 Enemies Killed: 80",
    0x93931226: "Grand Metropolis Chaotix Act 1 Enemies Killed: 81",
    0x93931227: "Grand Metropolis Chaotix Act 1 Enemies Killed: 82",
    0x93931228: "Grand Metropolis Chaotix Act 1 Enemies Killed: 83",
    0x93931229: "Grand Metropolis Chaotix Act 1 Enemies Killed: 84",
    0x9393122a: "Grand Metropolis Chaotix Act 1 Enemies Killed: 85",
    0x9393122b: "Grand Metropolis Chaotix Act 2 Enemies Killed: 1",
    0x9393122c: "Grand Metropolis Chaotix Act 2 Enemies Killed: 2",
    0x9393122d: "Grand Metropolis Chaotix Act 2 Enemies Killed: 3",
    0x9393122e: "Grand Metropolis Chaotix Act 2 Enemies Killed: 4",
    0x9393122f: "Grand Metropolis Chaotix Act 2 Enemies Killed: 5",
    0x93931230: "Grand Metropolis Chaotix Act 2 Enemies Killed: 6",
    0x93931231: "Grand Metropolis Chaotix Act 2 Enemies Killed: 7",
    0x93931232: "Grand Metropolis Chaotix Act 2 Enemies Killed: 8",
    0x93931233: "Grand Metropolis Chaotix Act 2 Enemies Killed: 9",
    0x93931234: "Grand Metropolis Chaotix Act 2 Enemies Killed: 10",
    0x93931235: "Grand Metropolis Chaotix Act 2 Enemies Killed: 11",
    0x93931236: "Grand Metropolis Chaotix Act 2 Enemies Killed: 12",
    0x93931237: "Grand Metropolis Chaotix Act 2 Enemies Killed: 13",
    0x93931238: "Grand Metropolis Chaotix Act 2 Enemies Killed: 14",
    0x93931239: "Grand Metropolis Chaotix Act 2 Enemies Killed: 15",
    0x9393123a: "Grand Metropolis Chaotix Act 2 Enemies Killed: 16",
    0x9393123b: "Grand Metropolis Chaotix Act 2 Enemies Killed: 17",
    0x9393123c: "Grand Metropolis Chaotix Act 2 Enemies Killed: 18",
    0x9393123d: "Grand Metropolis Chaotix Act 2 Enemies Killed: 19",
    0x9393123e: "Grand Metropolis Chaotix Act 2 Enemies Killed: 20",
    0x9393123f: "Grand Metropolis Chaotix Act 2 Enemies Killed: 21",
    0x93931240: "Grand Metropolis Chaotix Act 2 Enemies Killed: 22",
    0x93931241: "Grand Metropolis Chaotix Act 2 Enemies Killed: 23",
    0x93931242: "Grand Metropolis Chaotix Act 2 Enemies Killed: 24",
    0x93931243: "Grand Metropolis Chaotix Act 2 Enemies Killed: 25",
    0x93931244: "Grand Metropolis Chaotix Act 2 Enemies Killed: 26",
    0x93931245: "Grand Metropolis Chaotix Act 2 Enemies Killed: 27",
    0x93931246: "Grand Metropolis Chaotix Act 2 Enemies Killed: 28",
    0x93931247: "Grand Metropolis Chaotix Act 2 Enemies Killed: 29",
    0x93931248: "Grand Metropolis Chaotix Act 2 Enemies Killed: 30",
    0x93931249: "Grand Metropolis Chaotix Act 2 Enemies Killed: 31",
    0x9393124a: "Grand Metropolis Chaotix Act 2 Enemies Killed: 32",
    0x9393124b: "Grand Metropolis Chaotix Act 2 Enemies Killed: 33",
    0x9393124c: "Grand Metropolis Chaotix Act 2 Enemies Killed: 34",
    0x9393124d: "Grand Metropolis Chaotix Act 2 Enemies Killed: 35",
    0x9393124e: "Grand Metropolis Chaotix Act 2 Enemies Killed: 36",
    0x9393124f: "Grand Metropolis Chaotix Act 2 Enemies Killed: 37",
    0x93931250: "Grand Metropolis Chaotix Act 2 Enemies Killed: 38",
    0x93931251: "Grand Metropolis Chaotix Act 2 Enemies Killed: 39",
    0x93931252: "Grand Metropolis Chaotix Act 2 Enemies Killed: 40",
    0x93931253: "Grand Metropolis Chaotix Act 2 Enemies Killed: 41",
    0x93931254: "Grand Metropolis Chaotix Act 2 Enemies Killed: 42",
    0x93931255: "Grand Metropolis Chaotix Act 2 Enemies Killed: 43",
    0x93931256: "Grand Metropolis Chaotix Act 2 Enemies Killed: 44",
    0x93931257: "Grand Metropolis Chaotix Act 2 Enemies Killed: 45",
    0x93931258: "Grand Metropolis Chaotix Act 2 Enemies Killed: 46",
    0x93931259: "Grand Metropolis Chaotix Act 2 Enemies Killed: 47",
    0x9393125a: "Grand Metropolis Chaotix Act 2 Enemies Killed: 48",
    0x9393125b: "Grand Metropolis Chaotix Act 2 Enemies Killed: 49",
    0x9393125c: "Grand Metropolis Chaotix Act 2 Enemies Killed: 50",
    0x9393125d: "Grand Metropolis Chaotix Act 2 Enemies Killed: 51",
    0x9393125e: "Grand Metropolis Chaotix Act 2 Enemies Killed: 52",
    0x9393125f: "Grand Metropolis Chaotix Act 2 Enemies Killed: 53",
    0x93931260: "Grand Metropolis Chaotix Act 2 Enemies Killed: 54",
    0x93931261: "Grand Metropolis Chaotix Act 2 Enemies Killed: 55",
    0x93931262: "Grand Metropolis Chaotix Act 2 Enemies Killed: 56",
    0x93931263: "Grand Metropolis Chaotix Act 2 Enemies Killed: 57",
    0x93931264: "Grand Metropolis Chaotix Act 2 Enemies Killed: 58",
    0x93931265: "Grand Metropolis Chaotix Act 2 Enemies Killed: 59",
    0x93931266: "Grand Metropolis Chaotix Act 2 Enemies Killed: 60",
    0x93931267: "Grand Metropolis Chaotix Act 2 Enemies Killed: 61",
    0x93931268: "Grand Metropolis Chaotix Act 2 Enemies Killed: 62",
    0x93931269: "Grand Metropolis Chaotix Act 2 Enemies Killed: 63",
    0x9393126a: "Grand Metropolis Chaotix Act 2 Enemies Killed: 64",
    0x9393126b: "Grand Metropolis Chaotix Act 2 Enemies Killed: 65",
    0x9393126c: "Grand Metropolis Chaotix Act 2 Enemies Killed: 66",
    0x9393126d: "Grand Metropolis Chaotix Act 2 Enemies Killed: 67",
    0x9393126e: "Grand Metropolis Chaotix Act 2 Enemies Killed: 68",
    0x9393126f: "Grand Metropolis Chaotix Act 2 Enemies Killed: 69",
    0x93931270: "Grand Metropolis Chaotix Act 2 Enemies Killed: 70",
    0x93931271: "Grand Metropolis Chaotix Act 2 Enemies Killed: 71",
    0x93931272: "Grand Metropolis Chaotix Act 2 Enemies Killed: 72",
    0x93931273: "Grand Metropolis Chaotix Act 2 Enemies Killed: 73",
    0x93931274: "Grand Metropolis Chaotix Act 2 Enemies Killed: 74",
    0x93931275: "Grand Metropolis Chaotix Act 2 Enemies Killed: 75",
    0x93931276: "Grand Metropolis Chaotix Act 2 Enemies Killed: 76",
    0x93931277: "Grand Metropolis Chaotix Act 2 Enemies Killed: 77",
    0x93931278: "Grand Metropolis Chaotix Act 2 Enemies Killed: 78",
    0x93931279: "Grand Metropolis Chaotix Act 2 Enemies Killed: 79",
    0x9393127a: "Grand Metropolis Chaotix Act 2 Enemies Killed: 80",
    0x9393127b: "Grand Metropolis Chaotix Act 2 Enemies Killed: 81",
    0x9393127c: "Grand Metropolis Chaotix Act 2 Enemies Killed: 82",
    0x9393127d: "Grand Metropolis Chaotix Act 2 Enemies Killed: 83",
    0x9393127e: "Grand Metropolis Chaotix Act 2 Enemies Killed: 84",
    0x9393127f: "Grand Metropolis Chaotix Act 2 Enemies Killed: 85",
    0x93931280: "Power Plant Chaotix Act 1 Gold Turtles Killed: 1",
    0x93931281: "Power Plant Chaotix Act 1 Gold Turtles Killed: 2",
    0x93931282: "Power Plant Chaotix Act 1 Gold Turtles Killed: 3",
    0x93931283: "Power Plant Chaotix Act 2 Gold Turtles Killed: 1",
    0x93931284: "Power Plant Chaotix Act 2 Gold Turtles Killed: 2",
    0x93931285: "Power Plant Chaotix Act 2 Gold Turtles Killed: 3",
    0x93931286: "Power Plant Chaotix Act 2 Gold Turtles Killed: 4",
    0x93931287: "Power Plant Chaotix Act 2 Gold Turtles Killed: 5",
    0x93931288: "Casino Park Chaotix Act 1 Rings Collected: 1",
    0x93931289: "Casino Park Chaotix Act 1 Rings Collected: 2",
    0x9393128a: "Casino Park Chaotix Act 1 Rings Collected: 3",
    0x9393128b: "Casino Park Chaotix Act 1 Rings Collected: 4",
    0x9393128c: "Casino Park Chaotix Act 1 Rings Collected: 5",
    0x9393128d: "Casino Park Chaotix Act 1 Rings Collected: 6",
    0x9393128e: "Casino Park Chaotix Act 1 Rings Collected: 7",
    0x9393128f: "Casino Park Chaotix Act 1 Rings Collected: 8",
    0x93931290: "Casino Park Chaotix Act 1 Rings Collected: 9",
    0x93931291: "Casino Park Chaotix Act 1 Rings Collected: 10",
    0x93931292: "Casino Park Chaotix Act 1 Rings Collected: 11",
    0x93931293: "Casino Park Chaotix Act 1 Rings Collected: 12",
    0x93931294: "Casino Park Chaotix Act 1 Rings Collected: 13",
    0x93931295: "Casino Park Chaotix Act 1 Rings Collected: 14",
    0x93931296: "Casino Park Chaotix Act 1 Rings Collected: 15",
    0x93931297: "Casino Park Chaotix Act 1 Rings Collected: 16",
    0x93931298: "Casino Park Chaotix Act 1 Rings Collected: 17",
    0x93931299: "Casino Park Chaotix Act 1 Rings Collected: 18",
    0x9393129a: "Casino Park Chaotix Act 1 Rings Collected: 19",
    0x9393129b: "Casino Park Chaotix Act 1 Rings Collected: 20",
    0x9393129c: "Casino Park Chaotix Act 1 Rings Collected: 21",
    0x9393129d: "Casino Park Chaotix Act 1 Rings Collected: 22",
    0x9393129e: "Casino Park Chaotix Act 1 Rings Collected: 23",
    0x9393129f: "Casino Park Chaotix Act 1 Rings Collected: 24",
    0x939312a0: "Casino Park Chaotix Act 1 Rings Collected: 25",
    0x939312a1: "Casino Park Chaotix Act 1 Rings Collected: 26",
    0x939312a2: "Casino Park Chaotix Act 1 Rings Collected: 27",
    0x939312a3: "Casino Park Chaotix Act 1 Rings Collected: 28",
    0x939312a4: "Casino Park Chaotix Act 1 Rings Collected: 29",
    0x939312a5: "Casino Park Chaotix Act 1 Rings Collected: 30",
    0x939312a6: "Casino Park Chaotix Act 1 Rings Collected: 31",
    0x939312a7: "Casino Park Chaotix Act 1 Rings Collected: 32",
    0x939312a8: "Casino Park Chaotix Act 1 Rings Collected: 33",
    0x939312a9: "Casino Park Chaotix Act 1 Rings Collected: 34",
    0x939312aa: "Casino Park Chaotix Act 1 Rings Collected: 35",
    0x939312ab: "Casino Park Chaotix Act 1 Rings Collected: 36",
    0x939312ac: "Casino Park Chaotix Act 1 Rings Collected: 37",
    0x939312ad: "Casino Park Chaotix Act 1 Rings Collected: 38",
    0x939312ae: "Casino Park Chaotix Act 1 Rings Collected: 39",
    0x939312af: "Casino Park Chaotix Act 1 Rings Collected: 40",
    0x939312b0: "Casino Park Chaotix Act 1 Rings Collected: 41",
    0x939312b1: "Casino Park Chaotix Act 1 Rings Collected: 42",
    0x939312b2: "Casino Park Chaotix Act 1 Rings Collected: 43",
    0x939312b3: "Casino Park Chaotix Act 1 Rings Collected: 44",
    0x939312b4: "Casino Park Chaotix Act 1 Rings Collected: 45",
    0x939312b5: "Casino Park Chaotix Act 1 Rings Collected: 46",
    0x939312b6: "Casino Park Chaotix Act 1 Rings Collected: 47",
    0x939312b7: "Casino Park Chaotix Act 1 Rings Collected: 48",
    0x939312b8: "Casino Park Chaotix Act 1 Rings Collected: 49",
    0x939312b9: "Casino Park Chaotix Act 1 Rings Collected: 50",
    0x939312ba: "Casino Park Chaotix Act 1 Rings Collected: 51",
    0x939312bb: "Casino Park Chaotix Act 1 Rings Collected: 52",
    0x939312bc: "Casino Park Chaotix Act 1 Rings Collected: 53",
    0x939312bd: "Casino Park Chaotix Act 1 Rings Collected: 54",
    0x939312be: "Casino Park Chaotix Act 1 Rings Collected: 55",
    0x939312bf: "Casino Park Chaotix Act 1 Rings Collected: 56",
    0x939312c0: "Casino Park Chaotix Act 1 Rings Collected: 57",
    0x939312c1: "Casino Park Chaotix Act 1 Rings Collected: 58",
    0x939312c2: "Casino Park Chaotix Act 1 Rings Collected: 59",
    0x939312c3: "Casino Park Chaotix Act 1 Rings Collected: 60",
    0x939312c4: "Casino Park Chaotix Act 1 Rings Collected: 61",
    0x939312c5: "Casino Park Chaotix Act 1 Rings Collected: 62",
    0x939312c6: "Casino Park Chaotix Act 1 Rings Collected: 63",
    0x939312c7: "Casino Park Chaotix Act 1 Rings Collected: 64",
    0x939312c8: "Casino Park Chaotix Act 1 Rings Collected: 65",
    0x939312c9: "Casino Park Chaotix Act 1 Rings Collected: 66",
    0x939312ca: "Casino Park Chaotix Act 1 Rings Collected: 67",
    0x939312cb: "Casino Park Chaotix Act 1 Rings Collected: 68",
    0x939312cc: "Casino Park Chaotix Act 1 Rings Collected: 69",
    0x939312cd: "Casino Park Chaotix Act 1 Rings Collected: 70",
    0x939312ce: "Casino Park Chaotix Act 1 Rings Collected: 71",
    0x939312cf: "Casino Park Chaotix Act 1 Rings Collected: 72",
    0x939312d0: "Casino Park Chaotix Act 1 Rings Collected: 73",
    0x939312d1: "Casino Park Chaotix Act 1 Rings Collected: 74",
    0x939312d2: "Casino Park Chaotix Act 1 Rings Collected: 75",
    0x939312d3: "Casino Park Chaotix Act 1 Rings Collected: 76",
    0x939312d4: "Casino Park Chaotix Act 1 Rings Collected: 77",
    0x939312d5: "Casino Park Chaotix Act 1 Rings Collected: 78",
    0x939312d6: "Casino Park Chaotix Act 1 Rings Collected: 79",
    0x939312d7: "Casino Park Chaotix Act 1 Rings Collected: 80",
    0x939312d8: "Casino Park Chaotix Act 1 Rings Collected: 81",
    0x939312d9: "Casino Park Chaotix Act 1 Rings Collected: 82",
    0x939312da: "Casino Park Chaotix Act 1 Rings Collected: 83",
    0x939312db: "Casino Park Chaotix Act 1 Rings Collected: 84",
    0x939312dc: "Casino Park Chaotix Act 1 Rings Collected: 85",
    0x939312dd: "Casino Park Chaotix Act 1 Rings Collected: 86",
    0x939312de: "Casino Park Chaotix Act 1 Rings Collected: 87",
    0x939312df: "Casino Park Chaotix Act 1 Rings Collected: 88",
    0x939312e0: "Casino Park Chaotix Act 1 Rings Collected: 89",
    0x939312e1: "Casino Park Chaotix Act 1 Rings Collected: 90",
    0x939312e2: "Casino Park Chaotix Act 1 Rings Collected: 91",
    0x939312e3: "Casino Park Chaotix Act 1 Rings Collected: 92",
    0x939312e4: "Casino Park Chaotix Act 1 Rings Collected: 93",
    0x939312e5: "Casino Park Chaotix Act 1 Rings Collected: 94",
    0x939312e6: "Casino Park Chaotix Act 1 Rings Collected: 95",
    0x939312e7: "Casino Park Chaotix Act 1 Rings Collected: 96",
    0x939312e8: "Casino Park Chaotix Act 1 Rings Collected: 97",
    0x939312e9: "Casino Park Chaotix Act 1 Rings Collected: 98",
    0x939312ea: "Casino Park Chaotix Act 1 Rings Collected: 99",
    0x939312eb: "Casino Park Chaotix Act 1 Rings Collected: 100",
    0x939312ec: "Casino Park Chaotix Act 1 Rings Collected: 101",
    0x939312ed: "Casino Park Chaotix Act 1 Rings Collected: 102",
    0x939312ee: "Casino Park Chaotix Act 1 Rings Collected: 103",
    0x939312ef: "Casino Park Chaotix Act 1 Rings Collected: 104",
    0x939312f0: "Casino Park Chaotix Act 1 Rings Collected: 105",
    0x939312f1: "Casino Park Chaotix Act 1 Rings Collected: 106",
    0x939312f2: "Casino Park Chaotix Act 1 Rings Collected: 107",
    0x939312f3: "Casino Park Chaotix Act 1 Rings Collected: 108",
    0x939312f4: "Casino Park Chaotix Act 1 Rings Collected: 109",
    0x939312f5: "Casino Park Chaotix Act 1 Rings Collected: 110",
    0x939312f6: "Casino Park Chaotix Act 1 Rings Collected: 111",
    0x939312f7: "Casino Park Chaotix Act 1 Rings Collected: 112",
    0x939312f8: "Casino Park Chaotix Act 1 Rings Collected: 113",
    0x939312f9: "Casino Park Chaotix Act 1 Rings Collected: 114",
    0x939312fa: "Casino Park Chaotix Act 1 Rings Collected: 115",
    0x939312fb: "Casino Park Chaotix Act 1 Rings Collected: 116",
    0x939312fc: "Casino Park Chaotix Act 1 Rings Collected: 117",
    0x939312fd: "Casino Park Chaotix Act 1 Rings Collected: 118",
    0x939312fe: "Casino Park Chaotix Act 1 Rings Collected: 119",
    0x939312ff: "Casino Park Chaotix Act 1 Rings Collected: 120",
    0x93931300: "Casino Park Chaotix Act 1 Rings Collected: 121",
    0x93931301: "Casino Park Chaotix Act 1 Rings Collected: 122",
    0x93931302: "Casino Park Chaotix Act 1 Rings Collected: 123",
    0x93931303: "Casino Park Chaotix Act 1 Rings Collected: 124",
    0x93931304: "Casino Park Chaotix Act 1 Rings Collected: 125",
    0x93931305: "Casino Park Chaotix Act 1 Rings Collected: 126",
    0x93931306: "Casino Park Chaotix Act 1 Rings Collected: 127",
    0x93931307: "Casino Park Chaotix Act 1 Rings Collected: 128",
    0x93931308: "Casino Park Chaotix Act 1 Rings Collected: 129",
    0x93931309: "Casino Park Chaotix Act 1 Rings Collected: 130",
    0x9393130a: "Casino Park Chaotix Act 1 Rings Collected: 131",
    0x9393130b: "Casino Park Chaotix Act 1 Rings Collected: 132",
    0x9393130c: "Casino Park Chaotix Act 1 Rings Collected: 133",
    0x9393130d: "Casino Park Chaotix Act 1 Rings Collected: 134",
    0x9393130e: "Casino Park Chaotix Act 1 Rings Collected: 135",
    0x9393130f: "Casino Park Chaotix Act 1 Rings Collected: 136",
    0x93931310: "Casino Park Chaotix Act 1 Rings Collected: 137",
    0x93931311: "Casino Park Chaotix Act 1 Rings Collected: 138",
    0x93931312: "Casino Park Chaotix Act 1 Rings Collected: 139",
    0x93931313: "Casino Park Chaotix Act 1 Rings Collected: 140",
    0x93931314: "Casino Park Chaotix Act 1 Rings Collected: 141",
    0x93931315: "Casino Park Chaotix Act 1 Rings Collected: 142",
    0x93931316: "Casino Park Chaotix Act 1 Rings Collected: 143",
    0x93931317: "Casino Park Chaotix Act 1 Rings Collected: 144",
    0x93931318: "Casino Park Chaotix Act 1 Rings Collected: 145",
    0x93931319: "Casino Park Chaotix Act 1 Rings Collected: 146",
    0x9393131a: "Casino Park Chaotix Act 1 Rings Collected: 147",
    0x9393131b: "Casino Park Chaotix Act 1 Rings Collected: 148",
    0x9393131c: "Casino Park Chaotix Act 1 Rings Collected: 149",
    0x9393131d: "Casino Park Chaotix Act 1 Rings Collected: 150",
    0x9393131e: "Casino Park Chaotix Act 1 Rings Collected: 151",
    0x9393131f: "Casino Park Chaotix Act 1 Rings Collected: 152",
    0x93931320: "Casino Park Chaotix Act 1 Rings Collected: 153",
    0x93931321: "Casino Park Chaotix Act 1 Rings Collected: 154",
    0x93931322: "Casino Park Chaotix Act 1 Rings Collected: 155",
    0x93931323: "Casino Park Chaotix Act 1 Rings Collected: 156",
    0x93931324: "Casino Park Chaotix Act 1 Rings Collected: 157",
    0x93931325: "Casino Park Chaotix Act 1 Rings Collected: 158",
    0x93931326: "Casino Park Chaotix Act 1 Rings Collected: 159",
    0x93931327: "Casino Park Chaotix Act 1 Rings Collected: 160",
    0x93931328: "Casino Park Chaotix Act 1 Rings Collected: 161",
    0x93931329: "Casino Park Chaotix Act 1 Rings Collected: 162",
    0x9393132a: "Casino Park Chaotix Act 1 Rings Collected: 163",
    0x9393132b: "Casino Park Chaotix Act 1 Rings Collected: 164",
    0x9393132c: "Casino Park Chaotix Act 1 Rings Collected: 165",
    0x9393132d: "Casino Park Chaotix Act 1 Rings Collected: 166",
    0x9393132e: "Casino Park Chaotix Act 1 Rings Collected: 167",
    0x9393132f: "Casino Park Chaotix Act 1 Rings Collected: 168",
    0x93931330: "Casino Park Chaotix Act 1 Rings Collected: 169",
    0x93931331: "Casino Park Chaotix Act 1 Rings Collected: 170",
    0x93931332: "Casino Park Chaotix Act 1 Rings Collected: 171",
    0x93931333: "Casino Park Chaotix Act 1 Rings Collected: 172",
    0x93931334: "Casino Park Chaotix Act 1 Rings Collected: 173",
    0x93931335: "Casino Park Chaotix Act 1 Rings Collected: 174",
    0x93931336: "Casino Park Chaotix Act 1 Rings Collected: 175",
    0x93931337: "Casino Park Chaotix Act 1 Rings Collected: 176",
    0x93931338: "Casino Park Chaotix Act 1 Rings Collected: 177",
    0x93931339: "Casino Park Chaotix Act 1 Rings Collected: 178",
    0x9393133a: "Casino Park Chaotix Act 1 Rings Collected: 179",
    0x9393133b: "Casino Park Chaotix Act 1 Rings Collected: 180",
    0x9393133c: "Casino Park Chaotix Act 1 Rings Collected: 181",
    0x9393133d: "Casino Park Chaotix Act 1 Rings Collected: 182",
    0x9393133e: "Casino Park Chaotix Act 1 Rings Collected: 183",
    0x9393133f: "Casino Park Chaotix Act 1 Rings Collected: 184",
    0x93931340: "Casino Park Chaotix Act 1 Rings Collected: 185",
    0x93931341: "Casino Park Chaotix Act 1 Rings Collected: 186",
    0x93931342: "Casino Park Chaotix Act 1 Rings Collected: 187",
    0x93931343: "Casino Park Chaotix Act 1 Rings Collected: 188",
    0x93931344: "Casino Park Chaotix Act 1 Rings Collected: 189",
    0x93931345: "Casino Park Chaotix Act 1 Rings Collected: 190",
    0x93931346: "Casino Park Chaotix Act 1 Rings Collected: 191",
    0x93931347: "Casino Park Chaotix Act 1 Rings Collected: 192",
    0x93931348: "Casino Park Chaotix Act 1 Rings Collected: 193",
    0x93931349: "Casino Park Chaotix Act 1 Rings Collected: 194",
    0x9393134a: "Casino Park Chaotix Act 1 Rings Collected: 195",
    0x9393134b: "Casino Park Chaotix Act 1 Rings Collected: 196",
    0x9393134c: "Casino Park Chaotix Act 1 Rings Collected: 197",
    0x9393134d: "Casino Park Chaotix Act 1 Rings Collected: 198",
    0x9393134e: "Casino Park Chaotix Act 1 Rings Collected: 199",
    0x9393134f: "Casino Park Chaotix Act 1 Rings Collected: 200",
    0x93931350: "Casino Park Chaotix Act 2 Rings Collected: 1",
    0x93931351: "Casino Park Chaotix Act 2 Rings Collected: 2",
    0x93931352: "Casino Park Chaotix Act 2 Rings Collected: 3",
    0x93931353: "Casino Park Chaotix Act 2 Rings Collected: 4",
    0x93931354: "Casino Park Chaotix Act 2 Rings Collected: 5",
    0x93931355: "Casino Park Chaotix Act 2 Rings Collected: 6",
    0x93931356: "Casino Park Chaotix Act 2 Rings Collected: 7",
    0x93931357: "Casino Park Chaotix Act 2 Rings Collected: 8",
    0x93931358: "Casino Park Chaotix Act 2 Rings Collected: 9",
    0x93931359: "Casino Park Chaotix Act 2 Rings Collected: 10",
    0x9393135a: "Casino Park Chaotix Act 2 Rings Collected: 11",
    0x9393135b: "Casino Park Chaotix Act 2 Rings Collected: 12",
    0x9393135c: "Casino Park Chaotix Act 2 Rings Collected: 13",
    0x9393135d: "Casino Park Chaotix Act 2 Rings Collected: 14",
    0x9393135e: "Casino Park Chaotix Act 2 Rings Collected: 15",
    0x9393135f: "Casino Park Chaotix Act 2 Rings Collected: 16",
    0x93931360: "Casino Park Chaotix Act 2 Rings Collected: 17",
    0x93931361: "Casino Park Chaotix Act 2 Rings Collected: 18",
    0x93931362: "Casino Park Chaotix Act 2 Rings Collected: 19",
    0x93931363: "Casino Park Chaotix Act 2 Rings Collected: 20",
    0x93931364: "Casino Park Chaotix Act 2 Rings Collected: 21",
    0x93931365: "Casino Park Chaotix Act 2 Rings Collected: 22",
    0x93931366: "Casino Park Chaotix Act 2 Rings Collected: 23",
    0x93931367: "Casino Park Chaotix Act 2 Rings Collected: 24",
    0x93931368: "Casino Park Chaotix Act 2 Rings Collected: 25",
    0x93931369: "Casino Park Chaotix Act 2 Rings Collected: 26",
    0x9393136a: "Casino Park Chaotix Act 2 Rings Collected: 27",
    0x9393136b: "Casino Park Chaotix Act 2 Rings Collected: 28",
    0x9393136c: "Casino Park Chaotix Act 2 Rings Collected: 29",
    0x9393136d: "Casino Park Chaotix Act 2 Rings Collected: 30",
    0x9393136e: "Casino Park Chaotix Act 2 Rings Collected: 31",
    0x9393136f: "Casino Park Chaotix Act 2 Rings Collected: 32",
    0x93931370: "Casino Park Chaotix Act 2 Rings Collected: 33",
    0x93931371: "Casino Park Chaotix Act 2 Rings Collected: 34",
    0x93931372: "Casino Park Chaotix Act 2 Rings Collected: 35",
    0x93931373: "Casino Park Chaotix Act 2 Rings Collected: 36",
    0x93931374: "Casino Park Chaotix Act 2 Rings Collected: 37",
    0x93931375: "Casino Park Chaotix Act 2 Rings Collected: 38",
    0x93931376: "Casino Park Chaotix Act 2 Rings Collected: 39",
    0x93931377: "Casino Park Chaotix Act 2 Rings Collected: 40",
    0x93931378: "Casino Park Chaotix Act 2 Rings Collected: 41",
    0x93931379: "Casino Park Chaotix Act 2 Rings Collected: 42",
    0x9393137a: "Casino Park Chaotix Act 2 Rings Collected: 43",
    0x9393137b: "Casino Park Chaotix Act 2 Rings Collected: 44",
    0x9393137c: "Casino Park Chaotix Act 2 Rings Collected: 45",
    0x9393137d: "Casino Park Chaotix Act 2 Rings Collected: 46",
    0x9393137e: "Casino Park Chaotix Act 2 Rings Collected: 47",
    0x9393137f: "Casino Park Chaotix Act 2 Rings Collected: 48",
    0x93931380: "Casino Park Chaotix Act 2 Rings Collected: 49",
    0x93931381: "Casino Park Chaotix Act 2 Rings Collected: 50",
    0x93931382: "Casino Park Chaotix Act 2 Rings Collected: 51",
    0x93931383: "Casino Park Chaotix Act 2 Rings Collected: 52",
    0x93931384: "Casino Park Chaotix Act 2 Rings Collected: 53",
    0x93931385: "Casino Park Chaotix Act 2 Rings Collected: 54",
    0x93931386: "Casino Park Chaotix Act 2 Rings Collected: 55",
    0x93931387: "Casino Park Chaotix Act 2 Rings Collected: 56",
    0x93931388: "Casino Park Chaotix Act 2 Rings Collected: 57",
    0x93931389: "Casino Park Chaotix Act 2 Rings Collected: 58",
    0x9393138a: "Casino Park Chaotix Act 2 Rings Collected: 59",
    0x9393138b: "Casino Park Chaotix Act 2 Rings Collected: 60",
    0x9393138c: "Casino Park Chaotix Act 2 Rings Collected: 61",
    0x9393138d: "Casino Park Chaotix Act 2 Rings Collected: 62",
    0x9393138e: "Casino Park Chaotix Act 2 Rings Collected: 63",
    0x9393138f: "Casino Park Chaotix Act 2 Rings Collected: 64",
    0x93931390: "Casino Park Chaotix Act 2 Rings Collected: 65",
    0x93931391: "Casino Park Chaotix Act 2 Rings Collected: 66",
    0x93931392: "Casino Park Chaotix Act 2 Rings Collected: 67",
    0x93931393: "Casino Park Chaotix Act 2 Rings Collected: 68",
    0x93931394: "Casino Park Chaotix Act 2 Rings Collected: 69",
    0x93931395: "Casino Park Chaotix Act 2 Rings Collected: 70",
    0x93931396: "Casino Park Chaotix Act 2 Rings Collected: 71",
    0x93931397: "Casino Park Chaotix Act 2 Rings Collected: 72",
    0x93931398: "Casino Park Chaotix Act 2 Rings Collected: 73",
    0x93931399: "Casino Park Chaotix Act 2 Rings Collected: 74",
    0x9393139a: "Casino Park Chaotix Act 2 Rings Collected: 75",
    0x9393139b: "Casino Park Chaotix Act 2 Rings Collected: 76",
    0x9393139c: "Casino Park Chaotix Act 2 Rings Collected: 77",
    0x9393139d: "Casino Park Chaotix Act 2 Rings Collected: 78",
    0x9393139e: "Casino Park Chaotix Act 2 Rings Collected: 79",
    0x9393139f: "Casino Park Chaotix Act 2 Rings Collected: 80",
    0x939313a0: "Casino Park Chaotix Act 2 Rings Collected: 81",
    0x939313a1: "Casino Park Chaotix Act 2 Rings Collected: 82",
    0x939313a2: "Casino Park Chaotix Act 2 Rings Collected: 83",
    0x939313a3: "Casino Park Chaotix Act 2 Rings Collected: 84",
    0x939313a4: "Casino Park Chaotix Act 2 Rings Collected: 85",
    0x939313a5: "Casino Park Chaotix Act 2 Rings Collected: 86",
    0x939313a6: "Casino Park Chaotix Act 2 Rings Collected: 87",
    0x939313a7: "Casino Park Chaotix Act 2 Rings Collected: 88",
    0x939313a8: "Casino Park Chaotix Act 2 Rings Collected: 89",
    0x939313a9: "Casino Park Chaotix Act 2 Rings Collected: 90",
    0x939313aa: "Casino Park Chaotix Act 2 Rings Collected: 91",
    0x939313ab: "Casino Park Chaotix Act 2 Rings Collected: 92",
    0x939313ac: "Casino Park Chaotix Act 2 Rings Collected: 93",
    0x939313ad: "Casino Park Chaotix Act 2 Rings Collected: 94",
    0x939313ae: "Casino Park Chaotix Act 2 Rings Collected: 95",
    0x939313af: "Casino Park Chaotix Act 2 Rings Collected: 96",
    0x939313b0: "Casino Park Chaotix Act 2 Rings Collected: 97",
    0x939313b1: "Casino Park Chaotix Act 2 Rings Collected: 98",
    0x939313b2: "Casino Park Chaotix Act 2 Rings Collected: 99",
    0x939313b3: "Casino Park Chaotix Act 2 Rings Collected: 100",
    0x939313b4: "Casino Park Chaotix Act 2 Rings Collected: 101",
    0x939313b5: "Casino Park Chaotix Act 2 Rings Collected: 102",
    0x939313b6: "Casino Park Chaotix Act 2 Rings Collected: 103",
    0x939313b7: "Casino Park Chaotix Act 2 Rings Collected: 104",
    0x939313b8: "Casino Park Chaotix Act 2 Rings Collected: 105",
    0x939313b9: "Casino Park Chaotix Act 2 Rings Collected: 106",
    0x939313ba: "Casino Park Chaotix Act 2 Rings Collected: 107",
    0x939313bb: "Casino Park Chaotix Act 2 Rings Collected: 108",
    0x939313bc: "Casino Park Chaotix Act 2 Rings Collected: 109",
    0x939313bd: "Casino Park Chaotix Act 2 Rings Collected: 110",
    0x939313be: "Casino Park Chaotix Act 2 Rings Collected: 111",
    0x939313bf: "Casino Park Chaotix Act 2 Rings Collected: 112",
    0x939313c0: "Casino Park Chaotix Act 2 Rings Collected: 113",
    0x939313c1: "Casino Park Chaotix Act 2 Rings Collected: 114",
    0x939313c2: "Casino Park Chaotix Act 2 Rings Collected: 115",
    0x939313c3: "Casino Park Chaotix Act 2 Rings Collected: 116",
    0x939313c4: "Casino Park Chaotix Act 2 Rings Collected: 117",
    0x939313c5: "Casino Park Chaotix Act 2 Rings Collected: 118",
    0x939313c6: "Casino Park Chaotix Act 2 Rings Collected: 119",
    0x939313c7: "Casino Park Chaotix Act 2 Rings Collected: 120",
    0x939313c8: "Casino Park Chaotix Act 2 Rings Collected: 121",
    0x939313c9: "Casino Park Chaotix Act 2 Rings Collected: 122",
    0x939313ca: "Casino Park Chaotix Act 2 Rings Collected: 123",
    0x939313cb: "Casino Park Chaotix Act 2 Rings Collected: 124",
    0x939313cc: "Casino Park Chaotix Act 2 Rings Collected: 125",
    0x939313cd: "Casino Park Chaotix Act 2 Rings Collected: 126",
    0x939313ce: "Casino Park Chaotix Act 2 Rings Collected: 127",
    0x939313cf: "Casino Park Chaotix Act 2 Rings Collected: 128",
    0x939313d0: "Casino Park Chaotix Act 2 Rings Collected: 129",
    0x939313d1: "Casino Park Chaotix Act 2 Rings Collected: 130",
    0x939313d2: "Casino Park Chaotix Act 2 Rings Collected: 131",
    0x939313d3: "Casino Park Chaotix Act 2 Rings Collected: 132",
    0x939313d4: "Casino Park Chaotix Act 2 Rings Collected: 133",
    0x939313d5: "Casino Park Chaotix Act 2 Rings Collected: 134",
    0x939313d6: "Casino Park Chaotix Act 2 Rings Collected: 135",
    0x939313d7: "Casino Park Chaotix Act 2 Rings Collected: 136",
    0x939313d8: "Casino Park Chaotix Act 2 Rings Collected: 137",
    0x939313d9: "Casino Park Chaotix Act 2 Rings Collected: 138",
    0x939313da: "Casino Park Chaotix Act 2 Rings Collected: 139",
    0x939313db: "Casino Park Chaotix Act 2 Rings Collected: 140",
    0x939313dc: "Casino Park Chaotix Act 2 Rings Collected: 141",
    0x939313dd: "Casino Park Chaotix Act 2 Rings Collected: 142",
    0x939313de: "Casino Park Chaotix Act 2 Rings Collected: 143",
    0x939313df: "Casino Park Chaotix Act 2 Rings Collected: 144",
    0x939313e0: "Casino Park Chaotix Act 2 Rings Collected: 145",
    0x939313e1: "Casino Park Chaotix Act 2 Rings Collected: 146",
    0x939313e2: "Casino Park Chaotix Act 2 Rings Collected: 147",
    0x939313e3: "Casino Park Chaotix Act 2 Rings Collected: 148",
    0x939313e4: "Casino Park Chaotix Act 2 Rings Collected: 149",
    0x939313e5: "Casino Park Chaotix Act 2 Rings Collected: 150",
    0x939313e6: "Casino Park Chaotix Act 2 Rings Collected: 151",
    0x939313e7: "Casino Park Chaotix Act 2 Rings Collected: 152",
    0x939313e8: "Casino Park Chaotix Act 2 Rings Collected: 153",
    0x939313e9: "Casino Park Chaotix Act 2 Rings Collected: 154",
    0x939313ea: "Casino Park Chaotix Act 2 Rings Collected: 155",
    0x939313eb: "Casino Park Chaotix Act 2 Rings Collected: 156",
    0x939313ec: "Casino Park Chaotix Act 2 Rings Collected: 157",
    0x939313ed: "Casino Park Chaotix Act 2 Rings Collected: 158",
    0x939313ee: "Casino Park Chaotix Act 2 Rings Collected: 159",
    0x939313ef: "Casino Park Chaotix Act 2 Rings Collected: 160",
    0x939313f0: "Casino Park Chaotix Act 2 Rings Collected: 161",
    0x939313f1: "Casino Park Chaotix Act 2 Rings Collected: 162",
    0x939313f2: "Casino Park Chaotix Act 2 Rings Collected: 163",
    0x939313f3: "Casino Park Chaotix Act 2 Rings Collected: 164",
    0x939313f4: "Casino Park Chaotix Act 2 Rings Collected: 165",
    0x939313f5: "Casino Park Chaotix Act 2 Rings Collected: 166",
    0x939313f6: "Casino Park Chaotix Act 2 Rings Collected: 167",
    0x939313f7: "Casino Park Chaotix Act 2 Rings Collected: 168",
    0x939313f8: "Casino Park Chaotix Act 2 Rings Collected: 169",
    0x939313f9: "Casino Park Chaotix Act 2 Rings Collected: 170",
    0x939313fa: "Casino Park Chaotix Act 2 Rings Collected: 171",
    0x939313fb: "Casino Park Chaotix Act 2 Rings Collected: 172",
    0x939313fc: "Casino Park Chaotix Act 2 Rings Collected: 173",
    0x939313fd: "Casino Park Chaotix Act 2 Rings Collected: 174",
    0x939313fe: "Casino Park Chaotix Act 2 Rings Collected: 175",
    0x939313ff: "Casino Park Chaotix Act 2 Rings Collected: 176",
    0x93931400: "Casino Park Chaotix Act 2 Rings Collected: 177",
    0x93931401: "Casino Park Chaotix Act 2 Rings Collected: 178",
    0x93931402: "Casino Park Chaotix Act 2 Rings Collected: 179",
    0x93931403: "Casino Park Chaotix Act 2 Rings Collected: 180",
    0x93931404: "Casino Park Chaotix Act 2 Rings Collected: 181",
    0x93931405: "Casino Park Chaotix Act 2 Rings Collected: 182",
    0x93931406: "Casino Park Chaotix Act 2 Rings Collected: 183",
    0x93931407: "Casino Park Chaotix Act 2 Rings Collected: 184",
    0x93931408: "Casino Park Chaotix Act 2 Rings Collected: 185",
    0x93931409: "Casino Park Chaotix Act 2 Rings Collected: 186",
    0x9393140a: "Casino Park Chaotix Act 2 Rings Collected: 187",
    0x9393140b: "Casino Park Chaotix Act 2 Rings Collected: 188",
    0x9393140c: "Casino Park Chaotix Act 2 Rings Collected: 189",
    0x9393140d: "Casino Park Chaotix Act 2 Rings Collected: 190",
    0x9393140e: "Casino Park Chaotix Act 2 Rings Collected: 191",
    0x9393140f: "Casino Park Chaotix Act 2 Rings Collected: 192",
    0x93931410: "Casino Park Chaotix Act 2 Rings Collected: 193",
    0x93931411: "Casino Park Chaotix Act 2 Rings Collected: 194",
    0x93931412: "Casino Park Chaotix Act 2 Rings Collected: 195",
    0x93931413: "Casino Park Chaotix Act 2 Rings Collected: 196",
    0x93931414: "Casino Park Chaotix Act 2 Rings Collected: 197",
    0x93931415: "Casino Park Chaotix Act 2 Rings Collected: 198",
    0x93931416: "Casino Park Chaotix Act 2 Rings Collected: 199",
    0x93931417: "Casino Park Chaotix Act 2 Rings Collected: 200",
    0x93931418: "Casino Park Chaotix Act 2 Rings Collected: 201",
    0x93931419: "Casino Park Chaotix Act 2 Rings Collected: 202",
    0x9393141a: "Casino Park Chaotix Act 2 Rings Collected: 203",
    0x9393141b: "Casino Park Chaotix Act 2 Rings Collected: 204",
    0x9393141c: "Casino Park Chaotix Act 2 Rings Collected: 205",
    0x9393141d: "Casino Park Chaotix Act 2 Rings Collected: 206",
    0x9393141e: "Casino Park Chaotix Act 2 Rings Collected: 207",
    0x9393141f: "Casino Park Chaotix Act 2 Rings Collected: 208",
    0x93931420: "Casino Park Chaotix Act 2 Rings Collected: 209",
    0x93931421: "Casino Park Chaotix Act 2 Rings Collected: 210",
    0x93931422: "Casino Park Chaotix Act 2 Rings Collected: 211",
    0x93931423: "Casino Park Chaotix Act 2 Rings Collected: 212",
    0x93931424: "Casino Park Chaotix Act 2 Rings Collected: 213",
    0x93931425: "Casino Park Chaotix Act 2 Rings Collected: 214",
    0x93931426: "Casino Park Chaotix Act 2 Rings Collected: 215",
    0x93931427: "Casino Park Chaotix Act 2 Rings Collected: 216",
    0x93931428: "Casino Park Chaotix Act 2 Rings Collected: 217",
    0x93931429: "Casino Park Chaotix Act 2 Rings Collected: 218",
    0x9393142a: "Casino Park Chaotix Act 2 Rings Collected: 219",
    0x9393142b: "Casino Park Chaotix Act 2 Rings Collected: 220",
    0x9393142c: "Casino Park Chaotix Act 2 Rings Collected: 221",
    0x9393142d: "Casino Park Chaotix Act 2 Rings Collected: 222",
    0x9393142e: "Casino Park Chaotix Act 2 Rings Collected: 223",
    0x9393142f: "Casino Park Chaotix Act 2 Rings Collected: 224",
    0x93931430: "Casino Park Chaotix Act 2 Rings Collected: 225",
    0x93931431: "Casino Park Chaotix Act 2 Rings Collected: 226",
    0x93931432: "Casino Park Chaotix Act 2 Rings Collected: 227",
    0x93931433: "Casino Park Chaotix Act 2 Rings Collected: 228",
    0x93931434: "Casino Park Chaotix Act 2 Rings Collected: 229",
    0x93931435: "Casino Park Chaotix Act 2 Rings Collected: 230",
    0x93931436: "Casino Park Chaotix Act 2 Rings Collected: 231",
    0x93931437: "Casino Park Chaotix Act 2 Rings Collected: 232",
    0x93931438: "Casino Park Chaotix Act 2 Rings Collected: 233",
    0x93931439: "Casino Park Chaotix Act 2 Rings Collected: 234",
    0x9393143a: "Casino Park Chaotix Act 2 Rings Collected: 235",
    0x9393143b: "Casino Park Chaotix Act 2 Rings Collected: 236",
    0x9393143c: "Casino Park Chaotix Act 2 Rings Collected: 237",
    0x9393143d: "Casino Park Chaotix Act 2 Rings Collected: 238",
    0x9393143e: "Casino Park Chaotix Act 2 Rings Collected: 239",
    0x9393143f: "Casino Park Chaotix Act 2 Rings Collected: 240",
    0x93931440: "Casino Park Chaotix Act 2 Rings Collected: 241",
    0x93931441: "Casino Park Chaotix Act 2 Rings Collected: 242",
    0x93931442: "Casino Park Chaotix Act 2 Rings Collected: 243",
    0x93931443: "Casino Park Chaotix Act 2 Rings Collected: 244",
    0x93931444: "Casino Park Chaotix Act 2 Rings Collected: 245",
    0x93931445: "Casino Park Chaotix Act 2 Rings Collected: 246",
    0x93931446: "Casino Park Chaotix Act 2 Rings Collected: 247",
    0x93931447: "Casino Park Chaotix Act 2 Rings Collected: 248",
    0x93931448: "Casino Park Chaotix Act 2 Rings Collected: 249",
    0x93931449: "Casino Park Chaotix Act 2 Rings Collected: 250",
    0x9393144a: "Casino Park Chaotix Act 2 Rings Collected: 251",
    0x9393144b: "Casino Park Chaotix Act 2 Rings Collected: 252",
    0x9393144c: "Casino Park Chaotix Act 2 Rings Collected: 253",
    0x9393144d: "Casino Park Chaotix Act 2 Rings Collected: 254",
    0x9393144e: "Casino Park Chaotix Act 2 Rings Collected: 255",
    0x9393144f: "Casino Park Chaotix Act 2 Rings Collected: 256",
    0x93931450: "Casino Park Chaotix Act 2 Rings Collected: 257",
    0x93931451: "Casino Park Chaotix Act 2 Rings Collected: 258",
    0x93931452: "Casino Park Chaotix Act 2 Rings Collected: 259",
    0x93931453: "Casino Park Chaotix Act 2 Rings Collected: 260",
    0x93931454: "Casino Park Chaotix Act 2 Rings Collected: 261",
    0x93931455: "Casino Park Chaotix Act 2 Rings Collected: 262",
    0x93931456: "Casino Park Chaotix Act 2 Rings Collected: 263",
    0x93931457: "Casino Park Chaotix Act 2 Rings Collected: 264",
    0x93931458: "Casino Park Chaotix Act 2 Rings Collected: 265",
    0x93931459: "Casino Park Chaotix Act 2 Rings Collected: 266",
    0x9393145a: "Casino Park Chaotix Act 2 Rings Collected: 267",
    0x9393145b: "Casino Park Chaotix Act 2 Rings Collected: 268",
    0x9393145c: "Casino Park Chaotix Act 2 Rings Collected: 269",
    0x9393145d: "Casino Park Chaotix Act 2 Rings Collected: 270",
    0x9393145e: "Casino Park Chaotix Act 2 Rings Collected: 271",
    0x9393145f: "Casino Park Chaotix Act 2 Rings Collected: 272",
    0x93931460: "Casino Park Chaotix Act 2 Rings Collected: 273",
    0x93931461: "Casino Park Chaotix Act 2 Rings Collected: 274",
    0x93931462: "Casino Park Chaotix Act 2 Rings Collected: 275",
    0x93931463: "Casino Park Chaotix Act 2 Rings Collected: 276",
    0x93931464: "Casino Park Chaotix Act 2 Rings Collected: 277",
    0x93931465: "Casino Park Chaotix Act 2 Rings Collected: 278",
    0x93931466: "Casino Park Chaotix Act 2 Rings Collected: 279",
    0x93931467: "Casino Park Chaotix Act 2 Rings Collected: 280",
    0x93931468: "Casino Park Chaotix Act 2 Rings Collected: 281",
    0x93931469: "Casino Park Chaotix Act 2 Rings Collected: 282",
    0x9393146a: "Casino Park Chaotix Act 2 Rings Collected: 283",
    0x9393146b: "Casino Park Chaotix Act 2 Rings Collected: 284",
    0x9393146c: "Casino Park Chaotix Act 2 Rings Collected: 285",
    0x9393146d: "Casino Park Chaotix Act 2 Rings Collected: 286",
    0x9393146e: "Casino Park Chaotix Act 2 Rings Collected: 287",
    0x9393146f: "Casino Park Chaotix Act 2 Rings Collected: 288",
    0x93931470: "Casino Park Chaotix Act 2 Rings Collected: 289",
    0x93931471: "Casino Park Chaotix Act 2 Rings Collected: 290",
    0x93931472: "Casino Park Chaotix Act 2 Rings Collected: 291",
    0x93931473: "Casino Park Chaotix Act 2 Rings Collected: 292",
    0x93931474: "Casino Park Chaotix Act 2 Rings Collected: 293",
    0x93931475: "Casino Park Chaotix Act 2 Rings Collected: 294",
    0x93931476: "Casino Park Chaotix Act 2 Rings Collected: 295",
    0x93931477: "Casino Park Chaotix Act 2 Rings Collected: 296",
    0x93931478: "Casino Park Chaotix Act 2 Rings Collected: 297",
    0x93931479: "Casino Park Chaotix Act 2 Rings Collected: 298",
    0x9393147a: "Casino Park Chaotix Act 2 Rings Collected: 299",
    0x9393147b: "Casino Park Chaotix Act 2 Rings Collected: 300",
    0x9393147c: "Casino Park Chaotix Act 2 Rings Collected: 301",
    0x9393147d: "Casino Park Chaotix Act 2 Rings Collected: 302",
    0x9393147e: "Casino Park Chaotix Act 2 Rings Collected: 303",
    0x9393147f: "Casino Park Chaotix Act 2 Rings Collected: 304",
    0x93931480: "Casino Park Chaotix Act 2 Rings Collected: 305",
    0x93931481: "Casino Park Chaotix Act 2 Rings Collected: 306",
    0x93931482: "Casino Park Chaotix Act 2 Rings Collected: 307",
    0x93931483: "Casino Park Chaotix Act 2 Rings Collected: 308",
    0x93931484: "Casino Park Chaotix Act 2 Rings Collected: 309",
    0x93931485: "Casino Park Chaotix Act 2 Rings Collected: 310",
    0x93931486: "Casino Park Chaotix Act 2 Rings Collected: 311",
    0x93931487: "Casino Park Chaotix Act 2 Rings Collected: 312",
    0x93931488: "Casino Park Chaotix Act 2 Rings Collected: 313",
    0x93931489: "Casino Park Chaotix Act 2 Rings Collected: 314",
    0x9393148a: "Casino Park Chaotix Act 2 Rings Collected: 315",
    0x9393148b: "Casino Park Chaotix Act 2 Rings Collected: 316",
    0x9393148c: "Casino Park Chaotix Act 2 Rings Collected: 317",
    0x9393148d: "Casino Park Chaotix Act 2 Rings Collected: 318",
    0x9393148e: "Casino Park Chaotix Act 2 Rings Collected: 319",
    0x9393148f: "Casino Park Chaotix Act 2 Rings Collected: 320",
    0x93931490: "Casino Park Chaotix Act 2 Rings Collected: 321",
    0x93931491: "Casino Park Chaotix Act 2 Rings Collected: 322",
    0x93931492: "Casino Park Chaotix Act 2 Rings Collected: 323",
    0x93931493: "Casino Park Chaotix Act 2 Rings Collected: 324",
    0x93931494: "Casino Park Chaotix Act 2 Rings Collected: 325",
    0x93931495: "Casino Park Chaotix Act 2 Rings Collected: 326",
    0x93931496: "Casino Park Chaotix Act 2 Rings Collected: 327",
    0x93931497: "Casino Park Chaotix Act 2 Rings Collected: 328",
    0x93931498: "Casino Park Chaotix Act 2 Rings Collected: 329",
    0x93931499: "Casino Park Chaotix Act 2 Rings Collected: 330",
    0x9393149a: "Casino Park Chaotix Act 2 Rings Collected: 331",
    0x9393149b: "Casino Park Chaotix Act 2 Rings Collected: 332",
    0x9393149c: "Casino Park Chaotix Act 2 Rings Collected: 333",
    0x9393149d: "Casino Park Chaotix Act 2 Rings Collected: 334",
    0x9393149e: "Casino Park Chaotix Act 2 Rings Collected: 335",
    0x9393149f: "Casino Park Chaotix Act 2 Rings Collected: 336",
    0x939314a0: "Casino Park Chaotix Act 2 Rings Collected: 337",
    0x939314a1: "Casino Park Chaotix Act 2 Rings Collected: 338",
    0x939314a2: "Casino Park Chaotix Act 2 Rings Collected: 339",
    0x939314a3: "Casino Park Chaotix Act 2 Rings Collected: 340",
    0x939314a4: "Casino Park Chaotix Act 2 Rings Collected: 341",
    0x939314a5: "Casino Park Chaotix Act 2 Rings Collected: 342",
    0x939314a6: "Casino Park Chaotix Act 2 Rings Collected: 343",
    0x939314a7: "Casino Park Chaotix Act 2 Rings Collected: 344",
    0x939314a8: "Casino Park Chaotix Act 2 Rings Collected: 345",
    0x939314a9: "Casino Park Chaotix Act 2 Rings Collected: 346",
    0x939314aa: "Casino Park Chaotix Act 2 Rings Collected: 347",
    0x939314ab: "Casino Park Chaotix Act 2 Rings Collected: 348",
    0x939314ac: "Casino Park Chaotix Act 2 Rings Collected: 349",
    0x939314ad: "Casino Park Chaotix Act 2 Rings Collected: 350",
    0x939314ae: "Casino Park Chaotix Act 2 Rings Collected: 351",
    0x939314af: "Casino Park Chaotix Act 2 Rings Collected: 352",
    0x939314b0: "Casino Park Chaotix Act 2 Rings Collected: 353",
    0x939314b1: "Casino Park Chaotix Act 2 Rings Collected: 354",
    0x939314b2: "Casino Park Chaotix Act 2 Rings Collected: 355",
    0x939314b3: "Casino Park Chaotix Act 2 Rings Collected: 356",
    0x939314b4: "Casino Park Chaotix Act 2 Rings Collected: 357",
    0x939314b5: "Casino Park Chaotix Act 2 Rings Collected: 358",
    0x939314b6: "Casino Park Chaotix Act 2 Rings Collected: 359",
    0x939314b7: "Casino Park Chaotix Act 2 Rings Collected: 360",
    0x939314b8: "Casino Park Chaotix Act 2 Rings Collected: 361",
    0x939314b9: "Casino Park Chaotix Act 2 Rings Collected: 362",
    0x939314ba: "Casino Park Chaotix Act 2 Rings Collected: 363",
    0x939314bb: "Casino Park Chaotix Act 2 Rings Collected: 364",
    0x939314bc: "Casino Park Chaotix Act 2 Rings Collected: 365",
    0x939314bd: "Casino Park Chaotix Act 2 Rings Collected: 366",
    0x939314be: "Casino Park Chaotix Act 2 Rings Collected: 367",
    0x939314bf: "Casino Park Chaotix Act 2 Rings Collected: 368",
    0x939314c0: "Casino Park Chaotix Act 2 Rings Collected: 369",
    0x939314c1: "Casino Park Chaotix Act 2 Rings Collected: 370",
    0x939314c2: "Casino Park Chaotix Act 2 Rings Collected: 371",
    0x939314c3: "Casino Park Chaotix Act 2 Rings Collected: 372",
    0x939314c4: "Casino Park Chaotix Act 2 Rings Collected: 373",
    0x939314c5: "Casino Park Chaotix Act 2 Rings Collected: 374",
    0x939314c6: "Casino Park Chaotix Act 2 Rings Collected: 375",
    0x939314c7: "Casino Park Chaotix Act 2 Rings Collected: 376",
    0x939314c8: "Casino Park Chaotix Act 2 Rings Collected: 377",
    0x939314c9: "Casino Park Chaotix Act 2 Rings Collected: 378",
    0x939314ca: "Casino Park Chaotix Act 2 Rings Collected: 379",
    0x939314cb: "Casino Park Chaotix Act 2 Rings Collected: 380",
    0x939314cc: "Casino Park Chaotix Act 2 Rings Collected: 381",
    0x939314cd: "Casino Park Chaotix Act 2 Rings Collected: 382",
    0x939314ce: "Casino Park Chaotix Act 2 Rings Collected: 383",
    0x939314cf: "Casino Park Chaotix Act 2 Rings Collected: 384",
    0x939314d0: "Casino Park Chaotix Act 2 Rings Collected: 385",
    0x939314d1: "Casino Park Chaotix Act 2 Rings Collected: 386",
    0x939314d2: "Casino Park Chaotix Act 2 Rings Collected: 387",
    0x939314d3: "Casino Park Chaotix Act 2 Rings Collected: 388",
    0x939314d4: "Casino Park Chaotix Act 2 Rings Collected: 389",
    0x939314d5: "Casino Park Chaotix Act 2 Rings Collected: 390",
    0x939314d6: "Casino Park Chaotix Act 2 Rings Collected: 391",
    0x939314d7: "Casino Park Chaotix Act 2 Rings Collected: 392",
    0x939314d8: "Casino Park Chaotix Act 2 Rings Collected: 393",
    0x939314d9: "Casino Park Chaotix Act 2 Rings Collected: 394",
    0x939314da: "Casino Park Chaotix Act 2 Rings Collected: 395",
    0x939314db: "Casino Park Chaotix Act 2 Rings Collected: 396",
    0x939314dc: "Casino Park Chaotix Act 2 Rings Collected: 397",
    0x939314dd: "Casino Park Chaotix Act 2 Rings Collected: 398",
    0x939314de: "Casino Park Chaotix Act 2 Rings Collected: 399",
    0x939314df: "Casino Park Chaotix Act 2 Rings Collected: 400",
    0x939314e0: "Casino Park Chaotix Act 2 Rings Collected: 401",
    0x939314e1: "Casino Park Chaotix Act 2 Rings Collected: 402",
    0x939314e2: "Casino Park Chaotix Act 2 Rings Collected: 403",
    0x939314e3: "Casino Park Chaotix Act 2 Rings Collected: 404",
    0x939314e4: "Casino Park Chaotix Act 2 Rings Collected: 405",
    0x939314e5: "Casino Park Chaotix Act 2 Rings Collected: 406",
    0x939314e6: "Casino Park Chaotix Act 2 Rings Collected: 407",
    0x939314e7: "Casino Park Chaotix Act 2 Rings Collected: 408",
    0x939314e8: "Casino Park Chaotix Act 2 Rings Collected: 409",
    0x939314e9: "Casino Park Chaotix Act 2 Rings Collected: 410",
    0x939314ea: "Casino Park Chaotix Act 2 Rings Collected: 411",
    0x939314eb: "Casino Park Chaotix Act 2 Rings Collected: 412",
    0x939314ec: "Casino Park Chaotix Act 2 Rings Collected: 413",
    0x939314ed: "Casino Park Chaotix Act 2 Rings Collected: 414",
    0x939314ee: "Casino Park Chaotix Act 2 Rings Collected: 415",
    0x939314ef: "Casino Park Chaotix Act 2 Rings Collected: 416",
    0x939314f0: "Casino Park Chaotix Act 2 Rings Collected: 417",
    0x939314f1: "Casino Park Chaotix Act 2 Rings Collected: 418",
    0x939314f2: "Casino Park Chaotix Act 2 Rings Collected: 419",
    0x939314f3: "Casino Park Chaotix Act 2 Rings Collected: 420",
    0x939314f4: "Casino Park Chaotix Act 2 Rings Collected: 421",
    0x939314f5: "Casino Park Chaotix Act 2 Rings Collected: 422",
    0x939314f6: "Casino Park Chaotix Act 2 Rings Collected: 423",
    0x939314f7: "Casino Park Chaotix Act 2 Rings Collected: 424",
    0x939314f8: "Casino Park Chaotix Act 2 Rings Collected: 425",
    0x939314f9: "Casino Park Chaotix Act 2 Rings Collected: 426",
    0x939314fa: "Casino Park Chaotix Act 2 Rings Collected: 427",
    0x939314fb: "Casino Park Chaotix Act 2 Rings Collected: 428",
    0x939314fc: "Casino Park Chaotix Act 2 Rings Collected: 429",
    0x939314fd: "Casino Park Chaotix Act 2 Rings Collected: 430",
    0x939314fe: "Casino Park Chaotix Act 2 Rings Collected: 431",
    0x939314ff: "Casino Park Chaotix Act 2 Rings Collected: 432",
    0x93931500: "Casino Park Chaotix Act 2 Rings Collected: 433",
    0x93931501: "Casino Park Chaotix Act 2 Rings Collected: 434",
    0x93931502: "Casino Park Chaotix Act 2 Rings Collected: 435",
    0x93931503: "Casino Park Chaotix Act 2 Rings Collected: 436",
    0x93931504: "Casino Park Chaotix Act 2 Rings Collected: 437",
    0x93931505: "Casino Park Chaotix Act 2 Rings Collected: 438",
    0x93931506: "Casino Park Chaotix Act 2 Rings Collected: 439",
    0x93931507: "Casino Park Chaotix Act 2 Rings Collected: 440",
    0x93931508: "Casino Park Chaotix Act 2 Rings Collected: 441",
    0x93931509: "Casino Park Chaotix Act 2 Rings Collected: 442",
    0x9393150a: "Casino Park Chaotix Act 2 Rings Collected: 443",
    0x9393150b: "Casino Park Chaotix Act 2 Rings Collected: 444",
    0x9393150c: "Casino Park Chaotix Act 2 Rings Collected: 445",
    0x9393150d: "Casino Park Chaotix Act 2 Rings Collected: 446",
    0x9393150e: "Casino Park Chaotix Act 2 Rings Collected: 447",
    0x9393150f: "Casino Park Chaotix Act 2 Rings Collected: 448",
    0x93931510: "Casino Park Chaotix Act 2 Rings Collected: 449",
    0x93931511: "Casino Park Chaotix Act 2 Rings Collected: 450",
    0x93931512: "Casino Park Chaotix Act 2 Rings Collected: 451",
    0x93931513: "Casino Park Chaotix Act 2 Rings Collected: 452",
    0x93931514: "Casino Park Chaotix Act 2 Rings Collected: 453",
    0x93931515: "Casino Park Chaotix Act 2 Rings Collected: 454",
    0x93931516: "Casino Park Chaotix Act 2 Rings Collected: 455",
    0x93931517: "Casino Park Chaotix Act 2 Rings Collected: 456",
    0x93931518: "Casino Park Chaotix Act 2 Rings Collected: 457",
    0x93931519: "Casino Park Chaotix Act 2 Rings Collected: 458",
    0x9393151a: "Casino Park Chaotix Act 2 Rings Collected: 459",
    0x9393151b: "Casino Park Chaotix Act 2 Rings Collected: 460",
    0x9393151c: "Casino Park Chaotix Act 2 Rings Collected: 461",
    0x9393151d: "Casino Park Chaotix Act 2 Rings Collected: 462",
    0x9393151e: "Casino Park Chaotix Act 2 Rings Collected: 463",
    0x9393151f: "Casino Park Chaotix Act 2 Rings Collected: 464",
    0x93931520: "Casino Park Chaotix Act 2 Rings Collected: 465",
    0x93931521: "Casino Park Chaotix Act 2 Rings Collected: 466",
    0x93931522: "Casino Park Chaotix Act 2 Rings Collected: 467",
    0x93931523: "Casino Park Chaotix Act 2 Rings Collected: 468",
    0x93931524: "Casino Park Chaotix Act 2 Rings Collected: 469",
    0x93931525: "Casino Park Chaotix Act 2 Rings Collected: 470",
    0x93931526: "Casino Park Chaotix Act 2 Rings Collected: 471",
    0x93931527: "Casino Park Chaotix Act 2 Rings Collected: 472",
    0x93931528: "Casino Park Chaotix Act 2 Rings Collected: 473",
    0x93931529: "Casino Park Chaotix Act 2 Rings Collected: 474",
    0x9393152a: "Casino Park Chaotix Act 2 Rings Collected: 475",
    0x9393152b: "Casino Park Chaotix Act 2 Rings Collected: 476",
    0x9393152c: "Casino Park Chaotix Act 2 Rings Collected: 477",
    0x9393152d: "Casino Park Chaotix Act 2 Rings Collected: 478",
    0x9393152e: "Casino Park Chaotix Act 2 Rings Collected: 479",
    0x9393152f: "Casino Park Chaotix Act 2 Rings Collected: 480",
    0x93931530: "Casino Park Chaotix Act 2 Rings Collected: 481",
    0x93931531: "Casino Park Chaotix Act 2 Rings Collected: 482",
    0x93931532: "Casino Park Chaotix Act 2 Rings Collected: 483",
    0x93931533: "Casino Park Chaotix Act 2 Rings Collected: 484",
    0x93931534: "Casino Park Chaotix Act 2 Rings Collected: 485",
    0x93931535: "Casino Park Chaotix Act 2 Rings Collected: 486",
    0x93931536: "Casino Park Chaotix Act 2 Rings Collected: 487",
    0x93931537: "Casino Park Chaotix Act 2 Rings Collected: 488",
    0x93931538: "Casino Park Chaotix Act 2 Rings Collected: 489",
    0x93931539: "Casino Park Chaotix Act 2 Rings Collected: 490",
    0x9393153a: "Casino Park Chaotix Act 2 Rings Collected: 491",
    0x9393153b: "Casino Park Chaotix Act 2 Rings Collected: 492",
    0x9393153c: "Casino Park Chaotix Act 2 Rings Collected: 493",
    0x9393153d: "Casino Park Chaotix Act 2 Rings Collected: 494",
    0x9393153e: "Casino Park Chaotix Act 2 Rings Collected: 495",
    0x9393153f: "Casino Park Chaotix Act 2 Rings Collected: 496",
    0x93931540: "Casino Park Chaotix Act 2 Rings Collected: 497",
    0x93931541: "Casino Park Chaotix Act 2 Rings Collected: 498",
    0x93931542: "Casino Park Chaotix Act 2 Rings Collected: 499",
    0x93931543: "Casino Park Chaotix Act 2 Rings Collected: 500",
    0x93931544: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 1",
    0x93931545: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 2",
    0x93931546: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 3",
    0x93931547: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 4",
    0x93931548: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 5",
    0x93931549: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 6",
    0x9393154a: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 7",
    0x9393154b: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 8",
    0x9393154c: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 9",
    0x9393154d: "Bingo Highway Chaotix Act 1 Casino Chips Collected: 10",
    0x9393154e: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 1",
    0x9393154f: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 2",
    0x93931550: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 3",
    0x93931551: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 4",
    0x93931552: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 5",
    0x93931553: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 6",
    0x93931554: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 7",
    0x93931555: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 8",
    0x93931556: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 9",
    0x93931557: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 10",
    0x93931558: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 11",
    0x93931559: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 12",
    0x9393155a: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 13",
    0x9393155b: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 14",
    0x9393155c: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 15",
    0x9393155d: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 16",
    0x9393155e: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 17",
    0x9393155f: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 18",
    0x93931560: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 19",
    0x93931561: "Bingo Highway Chaotix Act 2 Casino Chips Collected: 20",
    0x93931562: "Bullet Station Chaotix Act 1 Capsules Destroyed: 1",
    0x93931563: "Bullet Station Chaotix Act 1 Capsules Destroyed: 2",
    0x93931564: "Bullet Station Chaotix Act 1 Capsules Destroyed: 3",
    0x93931565: "Bullet Station Chaotix Act 1 Capsules Destroyed: 4",
    0x93931566: "Bullet Station Chaotix Act 1 Capsules Destroyed: 5",
    0x93931567: "Bullet Station Chaotix Act 1 Capsules Destroyed: 6",
    0x93931568: "Bullet Station Chaotix Act 1 Capsules Destroyed: 7",
    0x93931569: "Bullet Station Chaotix Act 1 Capsules Destroyed: 8",
    0x9393156a: "Bullet Station Chaotix Act 1 Capsules Destroyed: 9",
    0x9393156b: "Bullet Station Chaotix Act 1 Capsules Destroyed: 10",
    0x9393156c: "Bullet Station Chaotix Act 1 Capsules Destroyed: 11",
    0x9393156d: "Bullet Station Chaotix Act 1 Capsules Destroyed: 12",
    0x9393156e: "Bullet Station Chaotix Act 1 Capsules Destroyed: 13",
    0x9393156f: "Bullet Station Chaotix Act 1 Capsules Destroyed: 14",
    0x93931570: "Bullet Station Chaotix Act 1 Capsules Destroyed: 15",
    0x93931571: "Bullet Station Chaotix Act 1 Capsules Destroyed: 16",
    0x93931572: "Bullet Station Chaotix Act 1 Capsules Destroyed: 17",
    0x93931573: "Bullet Station Chaotix Act 1 Capsules Destroyed: 18",
    0x93931574: "Bullet Station Chaotix Act 1 Capsules Destroyed: 19",
    0x93931575: "Bullet Station Chaotix Act 1 Capsules Destroyed: 20",
    0x93931576: "Bullet Station Chaotix Act 1 Capsules Destroyed: 21",
    0x93931577: "Bullet Station Chaotix Act 1 Capsules Destroyed: 22",
    0x93931578: "Bullet Station Chaotix Act 1 Capsules Destroyed: 23",
    0x93931579: "Bullet Station Chaotix Act 1 Capsules Destroyed: 24",
    0x9393157a: "Bullet Station Chaotix Act 1 Capsules Destroyed: 25",
    0x9393157b: "Bullet Station Chaotix Act 1 Capsules Destroyed: 26",
    0x9393157c: "Bullet Station Chaotix Act 1 Capsules Destroyed: 27",
    0x9393157d: "Bullet Station Chaotix Act 1 Capsules Destroyed: 28",
    0x9393157e: "Bullet Station Chaotix Act 1 Capsules Destroyed: 29",
    0x9393157f: "Bullet Station Chaotix Act 1 Capsules Destroyed: 30",
    0x93931580: "Bullet Station Chaotix Act 2 Capsules Destroyed: 1",
    0x93931581: "Bullet Station Chaotix Act 2 Capsules Destroyed: 2",
    0x93931582: "Bullet Station Chaotix Act 2 Capsules Destroyed: 3",
    0x93931583: "Bullet Station Chaotix Act 2 Capsules Destroyed: 4",
    0x93931584: "Bullet Station Chaotix Act 2 Capsules Destroyed: 5",
    0x93931585: "Bullet Station Chaotix Act 2 Capsules Destroyed: 6",
    0x93931586: "Bullet Station Chaotix Act 2 Capsules Destroyed: 7",
    0x93931587: "Bullet Station Chaotix Act 2 Capsules Destroyed: 8",
    0x93931588: "Bullet Station Chaotix Act 2 Capsules Destroyed: 9",
    0x93931589: "Bullet Station Chaotix Act 2 Capsules Destroyed: 10",
    0x9393158a: "Bullet Station Chaotix Act 2 Capsules Destroyed: 11",
    0x9393158b: "Bullet Station Chaotix Act 2 Capsules Destroyed: 12",
    0x9393158c: "Bullet Station Chaotix Act 2 Capsules Destroyed: 13",
    0x9393158d: "Bullet Station Chaotix Act 2 Capsules Destroyed: 14",
    0x9393158e: "Bullet Station Chaotix Act 2 Capsules Destroyed: 15",
    0x9393158f: "Bullet Station Chaotix Act 2 Capsules Destroyed: 16",
    0x93931590: "Bullet Station Chaotix Act 2 Capsules Destroyed: 17",
    0x93931591: "Bullet Station Chaotix Act 2 Capsules Destroyed: 18",
    0x93931592: "Bullet Station Chaotix Act 2 Capsules Destroyed: 19",
    0x93931593: "Bullet Station Chaotix Act 2 Capsules Destroyed: 20",
    0x93931594: "Bullet Station Chaotix Act 2 Capsules Destroyed: 21",
    0x93931595: "Bullet Station Chaotix Act 2 Capsules Destroyed: 22",
    0x93931596: "Bullet Station Chaotix Act 2 Capsules Destroyed: 23",
    0x93931597: "Bullet Station Chaotix Act 2 Capsules Destroyed: 24",
    0x93931598: "Bullet Station Chaotix Act 2 Capsules Destroyed: 25",
    0x93931599: "Bullet Station Chaotix Act 2 Capsules Destroyed: 26",
    0x9393159a: "Bullet Station Chaotix Act 2 Capsules Destroyed: 27",
    0x9393159b: "Bullet Station Chaotix Act 2 Capsules Destroyed: 28",
    0x9393159c: "Bullet Station Chaotix Act 2 Capsules Destroyed: 29",
    0x9393159d: "Bullet Station Chaotix Act 2 Capsules Destroyed: 30",
    0x9393159e: "Bullet Station Chaotix Act 2 Capsules Destroyed: 31",
    0x9393159f: "Bullet Station Chaotix Act 2 Capsules Destroyed: 32",
    0x939315a0: "Bullet Station Chaotix Act 2 Capsules Destroyed: 33",
    0x939315a1: "Bullet Station Chaotix Act 2 Capsules Destroyed: 34",
    0x939315a2: "Bullet Station Chaotix Act 2 Capsules Destroyed: 35",
    0x939315a3: "Bullet Station Chaotix Act 2 Capsules Destroyed: 36",
    0x939315a4: "Bullet Station Chaotix Act 2 Capsules Destroyed: 37",
    0x939315a5: "Bullet Station Chaotix Act 2 Capsules Destroyed: 38",
    0x939315a6: "Bullet Station Chaotix Act 2 Capsules Destroyed: 39",
    0x939315a7: "Bullet Station Chaotix Act 2 Capsules Destroyed: 40",
    0x939315a8: "Bullet Station Chaotix Act 2 Capsules Destroyed: 41",
    0x939315a9: "Bullet Station Chaotix Act 2 Capsules Destroyed: 42",
    0x939315aa: "Bullet Station Chaotix Act 2 Capsules Destroyed: 43",
    0x939315ab: "Bullet Station Chaotix Act 2 Capsules Destroyed: 44",
    0x939315ac: "Bullet Station Chaotix Act 2 Capsules Destroyed: 45",
    0x939315ad: "Bullet Station Chaotix Act 2 Capsules Destroyed: 46",
    0x939315ae: "Bullet Station Chaotix Act 2 Capsules Destroyed: 47",
    0x939315af: "Bullet Station Chaotix Act 2 Capsules Destroyed: 48",
    0x939315b0: "Bullet Station Chaotix Act 2 Capsules Destroyed: 49",
    0x939315b1: "Bullet Station Chaotix Act 2 Capsules Destroyed: 50",
    0x939315b2: "Lost Jungle Chaotix Act 1 Chao Saved: 1",
    0x939315b3: "Lost Jungle Chaotix Act 1 Chao Saved: 2",
    0x939315b4: "Lost Jungle Chaotix Act 1 Chao Saved: 3",
    0x939315b5: "Lost Jungle Chaotix Act 1 Chao Saved: 4",
    0x939315b6: "Lost Jungle Chaotix Act 1 Chao Saved: 5",
    0x939315b7: "Lost Jungle Chaotix Act 1 Chao Saved: 6",
    0x939315b8: "Lost Jungle Chaotix Act 1 Chao Saved: 7",
    0x939315b9: "Lost Jungle Chaotix Act 1 Chao Saved: 8",
    0x939315ba: "Lost Jungle Chaotix Act 1 Chao Saved: 9",
    0x939315bb: "Lost Jungle Chaotix Act 1 Chao Saved: 10",
    0x939315bc: "Lost Jungle Chaotix Act 2 Chao Saved: 1",
    0x939315bd: "Lost Jungle Chaotix Act 2 Chao Saved: 2",
    0x939315be: "Lost Jungle Chaotix Act 2 Chao Saved: 3",
    0x939315bf: "Lost Jungle Chaotix Act 2 Chao Saved: 4",
    0x939315c0: "Lost Jungle Chaotix Act 2 Chao Saved: 5",
    0x939315c1: "Lost Jungle Chaotix Act 2 Chao Saved: 6",
    0x939315c2: "Lost Jungle Chaotix Act 2 Chao Saved: 7",
    0x939315c3: "Lost Jungle Chaotix Act 2 Chao Saved: 8",
    0x939315c4: "Lost Jungle Chaotix Act 2 Chao Saved: 9",
    0x939315c5: "Lost Jungle Chaotix Act 2 Chao Saved: 10",
    0x939315c6: "Lost Jungle Chaotix Act 2 Chao Saved: 11",
    0x939315c7: "Lost Jungle Chaotix Act 2 Chao Saved: 12",
    0x939315c8: "Lost Jungle Chaotix Act 2 Chao Saved: 13",
    0x939315c9: "Lost Jungle Chaotix Act 2 Chao Saved: 14",
    0x939315ca: "Lost Jungle Chaotix Act 2 Chao Saved: 15",
    0x939315cb: "Lost Jungle Chaotix Act 2 Chao Saved: 16",
    0x939315cc: "Lost Jungle Chaotix Act 2 Chao Saved: 17",
    0x939315cd: "Lost Jungle Chaotix Act 2 Chao Saved: 18",
    0x939315ce: "Lost Jungle Chaotix Act 2 Chao Saved: 19",
    0x939315cf: "Lost Jungle Chaotix Act 2 Chao Saved: 20",
    0x939315d0: "Hang Castle Chaotix Act 1 Keys Collected: 1",
    0x939315d1: "Hang Castle Chaotix Act 1 Keys Collected: 2",
    0x939315d2: "Hang Castle Chaotix Act 1 Keys Collected: 3",
    0x939315d3: "Hang Castle Chaotix Act 1 Keys Collected: 4",
    0x939315d4: "Hang Castle Chaotix Act 1 Keys Collected: 5",
    0x939315d5: "Hang Castle Chaotix Act 1 Keys Collected: 6",
    0x939315d6: "Hang Castle Chaotix Act 1 Keys Collected: 7",
    0x939315d7: "Hang Castle Chaotix Act 1 Keys Collected: 8",
    0x939315d8: "Hang Castle Chaotix Act 1 Keys Collected: 9",
    0x939315d9: "Hang Castle Chaotix Act 1 Keys Collected: 10",
    0x939315da: "Hang Castle Chaotix Act 2 Keys Collected: 1",
    0x939315db: "Hang Castle Chaotix Act 2 Keys Collected: 2",
    0x939315dc: "Hang Castle Chaotix Act 2 Keys Collected: 3",
    0x939315dd: "Hang Castle Chaotix Act 2 Keys Collected: 4",
    0x939315de: "Hang Castle Chaotix Act 2 Keys Collected: 5",
    0x939315df: "Hang Castle Chaotix Act 2 Keys Collected: 6",
    0x939315e0: "Hang Castle Chaotix Act 2 Keys Collected: 7",
    0x939315e1: "Hang Castle Chaotix Act 2 Keys Collected: 8",
    0x939315e2: "Hang Castle Chaotix Act 2 Keys Collected: 9",
    0x939315e3: "Hang Castle Chaotix Act 2 Keys Collected: 10",
    0x939315e4: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 1",
    0x939315e5: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 2",
    0x939315e6: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 3",
    0x939315e7: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 4",
    0x939315e8: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 5",
    0x939315e9: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 6",
    0x939315ea: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 7",
    0x939315eb: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 8",
    0x939315ec: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 9",
    0x939315ed: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 10",
    0x939315ee: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 11",
    0x939315ef: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 12",
    0x939315f0: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 13",
    0x939315f1: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 14",
    0x939315f2: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 15",
    0x939315f3: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 16",
    0x939315f4: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 17",
    0x939315f5: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 18",
    0x939315f6: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 19",
    0x939315f7: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 20",
    0x939315f8: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 21",
    0x939315f9: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 22",
    0x939315fa: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 23",
    0x939315fb: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 24",
    0x939315fc: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 25",
    0x939315fd: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 26",
    0x939315fe: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 27",
    0x939315ff: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 28",
    0x93931600: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 29",
    0x93931601: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 30",
    0x93931602: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 31",
    0x93931603: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 32",
    0x93931604: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 33",
    0x93931605: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 34",
    0x93931606: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 35",
    0x93931607: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 36",
    0x93931608: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 37",
    0x93931609: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 38",
    0x9393160a: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 39",
    0x9393160b: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 40",
    0x9393160c: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 41",
    0x9393160d: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 42",
    0x9393160e: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 43",
    0x9393160f: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 44",
    0x93931610: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 45",
    0x93931611: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 46",
    0x93931612: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 47",
    0x93931613: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 48",
    0x93931614: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 49",
    0x93931615: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 50",
    0x93931616: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 51",
    0x93931617: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 52",
    0x93931618: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 53",
    0x93931619: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 54",
    0x9393161a: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 55",
    0x9393161b: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 56",
    0x9393161c: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 57",
    0x9393161d: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 58",
    0x9393161e: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 59",
    0x9393161f: "Mystic Mansion Chaotix Act 1 Red Torches Extinguished: 60",
    0x93931620: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 1",
    0x93931621: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 2",
    0x93931622: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 3",
    0x93931623: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 4",
    0x93931624: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 5",
    0x93931625: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 6",
    0x93931626: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 7",
    0x93931627: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 8",
    0x93931628: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 9",
    0x93931629: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 10",
    0x9393162a: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 11",
    0x9393162b: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 12",
    0x9393162c: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 13",
    0x9393162d: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 14",
    0x9393162e: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 15",
    0x9393162f: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 16",
    0x93931630: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 17",
    0x93931631: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 18",
    0x93931632: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 19",
    0x93931633: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 20",
    0x93931634: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 21",
    0x93931635: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 22",
    0x93931636: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 23",
    0x93931637: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 24",
    0x93931638: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 25",
    0x93931639: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 26",
    0x9393163a: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 27",
    0x9393163b: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 28",
    0x9393163c: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 29",
    0x9393163d: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 30",
    0x9393163e: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 31",
    0x9393163f: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 32",
    0x93931640: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 33",
    0x93931641: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 34",
    0x93931642: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 35",
    0x93931643: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 36",
    0x93931644: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 37",
    0x93931645: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 38",
    0x93931646: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 39",
    0x93931647: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 40",
    0x93931648: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 41",
    0x93931649: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 42",
    0x9393164a: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 43",
    0x9393164b: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 44",
    0x9393164c: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 45",
    0x9393164d: "Mystic Mansion Chaotix Act 2 Blue Torches Extinguished: 46",
    0x9393164e: "Final Fortress Chaotix Act 1 Keys Collected: 1",
    0x9393164f: "Final Fortress Chaotix Act 1 Keys Collected: 2",
    0x93931650: "Final Fortress Chaotix Act 1 Keys Collected: 3",
    0x93931651: "Final Fortress Chaotix Act 1 Keys Collected: 4",
    0x93931652: "Final Fortress Chaotix Act 1 Keys Collected: 5",
    0x93931653: "Final Fortress Chaotix Act 2 Keys Collected: 1",
    0x93931654: "Final Fortress Chaotix Act 2 Keys Collected: 2",
    0x93931655: "Final Fortress Chaotix Act 2 Keys Collected: 3",
    0x93931656: "Final Fortress Chaotix Act 2 Keys Collected: 4",
    0x93931657: "Final Fortress Chaotix Act 2 Keys Collected: 5",
    0x93931658: "Final Fortress Chaotix Act 2 Keys Collected: 6",
    0x93931659: "Final Fortress Chaotix Act 2 Keys Collected: 7",
    0x9393165a: "Final Fortress Chaotix Act 2 Keys Collected: 8",
    0x9393165b: "Final Fortress Chaotix Act 2 Keys Collected: 9",
    0x9393165c: "Final Fortress Chaotix Act 2 Keys Collected: 10",
    0x9393165d: "Seaside Hill Sonic Act 1 Bonus Key 1",
    0x9393165e: "Seaside Hill Sonic Act 1 Bonus Key 2",
    0x9393165f: "Seaside Hill Sonic Act 1 Bonus Key 3",
    0x93931660: "Ocean Palace Sonic Act 1 Bonus Key 1",
    0x93931661: "Ocean Palace Sonic Act 1 Bonus Key 2",
    0x93931662: "Ocean Palace Sonic Act 1 Bonus Key 3",
    0x93931663: "Grand Metropolis Sonic Act 1 Bonus Key 1",
    0x93931664: "Grand Metropolis Sonic Act 1 Bonus Key 2",
    0x93931665: "Power Plant Sonic Act 1 Bonus Key 1",
    0x93931666: "Power Plant Sonic Act 1 Bonus Key 2",
    0x93931667: "Power Plant Sonic Act 1 Bonus Key 3",
    0x93931668: "Casino Park Sonic Act 1 Bonus Key 1",
    0x93931669: "Casino Park Sonic Act 1 Bonus Key 2",
    0x9393166a: "Casino Park Sonic Act 1 Bonus Key 3",
    0x9393166b: "Bingo Highway Sonic Act 1 Bonus Key 1",
    0x9393166c: "Bingo Highway Sonic Act 1 Bonus Key 2",
    0x9393166d: "Bingo Highway Sonic Act 1 Bonus Key 3",
    0x9393166e: "Rail Canyon Sonic Act 1 Bonus Key 1",
    0x9393166f: "Rail Canyon Sonic Act 1 Bonus Key 2",
    0x93931670: "Rail Canyon Sonic Act 1 Bonus Key 3",
    0x93931671: "Bullet Station Sonic Act 1 Bonus Key 1",
    0x93931672: "Bullet Station Sonic Act 1 Bonus Key 2",
    0x93931673: "Bullet Station Sonic Act 1 Bonus Key 3",
    0x93931674: "Frog Forest Sonic Act 1 Bonus Key 1",
    0x93931675: "Frog Forest Sonic Act 1 Bonus Key 2",
    0x93931676: "Frog Forest Sonic Act 1 Bonus Key 3",
    0x93931677: "Lost Jungle Sonic Act 1 Bonus Key 1",
    0x93931678: "Lost Jungle Sonic Act 1 Bonus Key 2",
    0x93931679: "Lost Jungle Sonic Act 1 Bonus Key 3",
    0x9393167a: "Hang Castle Sonic Act 1 Bonus Key 1",
    0x9393167b: "Hang Castle Sonic Act 1 Bonus Key 2",
    0x9393167c: "Hang Castle Sonic Act 1 Bonus Key 3",
    0x9393167d: "Mystic Mansion Sonic Act 1 Bonus Key 1",
    0x9393167e: "Mystic Mansion Sonic Act 1 Bonus Key 2",
    0x9393167f: "Mystic Mansion Sonic Act 1 Bonus Key 3",
    0x93931680: "Egg Fleet Sonic Act 1 Bonus Key 1",
    0x93931681: "Egg Fleet Sonic Act 1 Bonus Key 2",
    0x93931682: "Egg Fleet Sonic Act 1 Bonus Key 3",
    0x93931683: "Final Fortress Sonic Act 1 Bonus Key 1",
    0x93931684: "Final Fortress Sonic Act 1 Bonus Key 2",
    0x93931685: "Final Fortress Sonic Act 1 Bonus Key 3",
    0x93931686: "Seaside Hill Dark Act 1 Bonus Key 1",
    0x93931687: "Seaside Hill Dark Act 1 Bonus Key 2",
    0x93931688: "Seaside Hill Dark Act 1 Bonus Key 3",
    0x93931689: "Ocean Palace Dark Act 1 Bonus Key 1",
    0x9393168a: "Ocean Palace Dark Act 1 Bonus Key 2",
    0x9393168b: "Ocean Palace Dark Act 1 Bonus Key 3",
    0x9393168c: "Grand Metropolis Dark Act 1 Bonus Key 1",
    0x9393168d: "Grand Metropolis Dark Act 1 Bonus Key 2",
    0x9393168e: "Grand Metropolis Dark Act 1 Bonus Key 3",
    0x9393168f: "Power Plant Dark Act 1 Bonus Key 1",
    0x93931690: "Power Plant Dark Act 1 Bonus Key 2",
    0x93931691: "Power Plant Dark Act 1 Bonus Key 3",
    0x93931692: "Casino Park Dark Act 1 Bonus Key 1",
    0x93931693: "Casino Park Dark Act 1 Bonus Key 2",
    0x93931694: "Casino Park Dark Act 1 Bonus Key 3",
    0x93931695: "Bingo Highway Dark Act 1 Bonus Key 1",
    0x93931696: "Bingo Highway Dark Act 1 Bonus Key 2",
    0x93931697: "Bingo Highway Dark Act 1 Bonus Key 3",
    0x93931698: "Rail Canyon Dark Act 1 Bonus Key 1",
    0x93931699: "Rail Canyon Dark Act 1 Bonus Key 2",
    0x9393169a: "Rail Canyon Dark Act 1 Bonus Key 3",
    0x9393169b: "Bullet Station Dark Act 1 Bonus Key 1",
    0x9393169c: "Bullet Station Dark Act 1 Bonus Key 2",
    0x9393169d: "Bullet Station Dark Act 1 Bonus Key 3",
    0x9393169e: "Frog Forest Dark Act 1 Bonus Key 1",
    0x9393169f: "Frog Forest Dark Act 1 Bonus Key 2",
    0x939316a0: "Frog Forest Dark Act 1 Bonus Key 3",
    0x939316a1: "Lost Jungle Dark Act 1 Bonus Key 1",
    0x939316a2: "Lost Jungle Dark Act 1 Bonus Key 2",
    0x939316a3: "Lost Jungle Dark Act 1 Bonus Key 3",
    0x939316a4: "Hang Castle Dark Act 1 Bonus Key 1",
    0x939316a5: "Hang Castle Dark Act 1 Bonus Key 2",
    0x939316a6: "Hang Castle Dark Act 1 Bonus Key 3",
    0x939316a7: "Mystic Mansion Dark Act 1 Bonus Key 1",
    0x939316a8: "Mystic Mansion Dark Act 1 Bonus Key 2",
    0x939316a9: "Mystic Mansion Dark Act 1 Bonus Key 3",
    0x939316aa: "Egg Fleet Dark Act 1 Bonus Key 1",
    0x939316ab: "Egg Fleet Dark Act 1 Bonus Key 2",
    0x939316ac: "Egg Fleet Dark Act 1 Bonus Key 3",
    0x939316ad: "Final Fortress Dark Act 1 Bonus Key 1",
    0x939316ae: "Final Fortress Dark Act 1 Bonus Key 2",
    0x939316af: "Final Fortress Dark Act 1 Bonus Key 3",
    0x939316b0: "Seaside Hill Rose Act 1 Bonus Key 1",
    0x939316b1: "Seaside Hill Rose Act 1 Bonus Key 2",
    0x939316b2: "Ocean Palace Rose Act 1 Bonus Key 1",
    0x939316b3: "Ocean Palace Rose Act 1 Bonus Key 2",
    0x939316b4: "Ocean Palace Rose Act 1 Bonus Key 3",
    0x939316b5: "Grand Metropolis Rose Act 1 Bonus Key 1",
    0x939316b6: "Grand Metropolis Rose Act 1 Bonus Key 2",
    0x939316b7: "Grand Metropolis Rose Act 1 Bonus Key 3",
    0x939316b8: "Power Plant Rose Act 1 Bonus Key 1",
    0x939316b9: "Power Plant Rose Act 1 Bonus Key 2",
    0x939316ba: "Power Plant Rose Act 1 Bonus Key 3",
    0x939316bb: "Casino Park Rose Act 1 Bonus Key 1",
    0x939316bc: "Casino Park Rose Act 1 Bonus Key 2",
    0x939316bd: "Casino Park Rose Act 1 Bonus Key 3",
    0x939316be: "SUPER SECRET HIDDEN Act 1 Bonus Key",
    0x939316bf: "Bingo Highway Rose Act 1 Bonus Key 1",
    0x939316c0: "Bingo Highway Rose Act 1 Bonus Key 2",
    0x939316c1: "Bingo Highway Rose Act 1 Bonus Key 3",
    0x939316c2: "Rail Canyon Rose Act 1 Bonus Key 1",
    0x939316c3: "Rail Canyon Rose Act 1 Bonus Key 2",
    0x939316c4: "Rail Canyon Rose Act 1 Bonus Key 3",
    0x939316c5: "Bullet Station Rose Act 1 Bonus Key 1",
    0x939316c6: "Bullet Station Rose Act 1 Bonus Key 2",
    0x939316c7: "Bullet Station Rose Act 1 Bonus Key 3",
    0x939316c8: "Frog Forest Rose Act 1 Bonus Key 1",
    0x939316c9: "Frog Forest Rose Act 1 Bonus Key 2",
    0x939316ca: "Frog Forest Rose Act 1 Bonus Key 3",
    0x939316cb: "Lost Jungle Rose Act 1 Bonus Key 1",
    0x939316cc: "Lost Jungle Rose Act 1 Bonus Key 2",
    0x939316cd: "Lost Jungle Rose Act 1 Bonus Key 3",
    0x939316ce: "Hang Castle Rose Act 1 Bonus Key 1",
    0x939316cf: "Hang Castle Rose Act 1 Bonus Key 2",
    0x939316d0: "Hang Castle Rose Act 1 Bonus Key 3",
    0x939316d1: "Mystic Mansion Rose Act 1 Bonus Key 1",
    0x939316d2: "Mystic Mansion Rose Act 1 Bonus Key 2",
    0x939316d3: "Mystic Mansion Rose Act 1 Bonus Key 3",
    0x939316d4: "Egg Fleet Rose Act 1 Bonus Key 1",
    0x939316d5: "Egg Fleet Rose Act 1 Bonus Key 2",
    0x939316d6: "Egg Fleet Rose Act 1 Bonus Key 3",
    0x939316d7: "Final Fortress Rose Act 1 Bonus Key 1",
    0x939316d8: "Final Fortress Rose Act 1 Bonus Key 2",
    0x939316d9: "Final Fortress Rose Act 1 Bonus Key 3",
    0x939316da: "Seaside Hill Chaotix Act 1 Bonus Key 1",
    0x939316db: "Seaside Hill Chaotix Act 1 Bonus Key 2",
    0x939316dc: "Seaside Hill Chaotix Act 1 Bonus Key 3",
    0x939316dd: "Ocean Palace Chaotix Act 1 Bonus Key 1",
    0x939316de: "Ocean Palace Chaotix Act 1 Bonus Key 2",
    0x939316df: "Ocean Palace Chaotix Act 1 Bonus Key 3",
    0x939316e0: "Grand Metropolis Chaotix Act 1 Bonus Key 1",
    0x939316e1: "Grand Metropolis Chaotix Act 1 Bonus Key 2",
    0x939316e2: "Grand Metropolis Chaotix Act 1 Bonus Key 3",
    0x939316e3: "Power Plant Chaotix Act 1 Bonus Key 1",
    0x939316e4: "Power Plant Chaotix Act 1 Bonus Key 2",
    0x939316e5: "Power Plant Chaotix Act 1 Bonus Key 3",
    0x939316e6: "Casino Park Chaotix Act 1 Bonus Key 1",
    0x939316e7: "Casino Park Chaotix Act 1 Bonus Key 2",
    0x939316e8: "Casino Park Chaotix Act 1 Bonus Key 3",
    0x939316e9: "Bingo Highway Chaotix Act 1 Bonus Key 1",
    0x939316ea: "Bingo Highway Chaotix Act 1 Bonus Key 2",
    0x939316eb: "Bingo Highway Chaotix Act 1 Bonus Key 3",
    0x939316ec: "Rail Canyon Chaotix Act 1 Bonus Key 1",
    0x939316ed: "Rail Canyon Chaotix Act 1 Bonus Key 2",
    0x939316ee: "Rail Canyon Chaotix Act 1 Bonus Key 3",
    0x939316ef: "Bullet Station Chaotix Act 1 Bonus Key 1",
    0x939316f0: "Bullet Station Chaotix Act 1 Bonus Key 2",
    0x939316f1: "Bullet Station Chaotix Act 1 Bonus Key 3",
    0x939316f2: "Frog Forest Chaotix Act 1 Bonus Key 1",
    0x939316f3: "Frog Forest Chaotix Act 1 Bonus Key 2",
    0x939316f4: "Frog Forest Chaotix Act 1 Bonus Key 3",
    0x939316f5: "Lost Jungle Chaotix Act 1 Bonus Key 1",
    0x939316f6: "Lost Jungle Chaotix Act 1 Bonus Key 2",
    0x939316f7: "Lost Jungle Chaotix Act 1 Bonus Key 3",
    0x939316f8: "Hang Castle Chaotix Act 1 Bonus Key 1",
    0x939316f9: "Hang Castle Chaotix Act 1 Bonus Key 2",
    0x939316fa: "Hang Castle Chaotix Act 1 Bonus Key 3",
    0x939316fb: "Mystic Mansion Chaotix Act 1 Bonus Key 1",
    0x939316fc: "Mystic Mansion Chaotix Act 1 Bonus Key 2",
    0x939316fd: "Mystic Mansion Chaotix Act 1 Bonus Key 3",
    0x939316fe: "Egg Fleet Chaotix Act 1 Bonus Key 1",
    0x939316ff: "Egg Fleet Chaotix Act 1 Bonus Key 2",
    0x93931700: "Egg Fleet Chaotix Act 1 Bonus Key 3",
    0x93931701: "Final Fortress Chaotix Act 1 Bonus Key 1",
    0x93931702: "Final Fortress Chaotix Act 1 Bonus Key 2",
    0x93931703: "Final Fortress Chaotix Act 1 Bonus Key 3",
    0x93931704: "Seaside Hill Sonic Act 2 Bonus Key 1",
    0x93931705: "Seaside Hill Sonic Act 2 Bonus Key 2",
    0x93931706: "Seaside Hill Sonic Act 2 Bonus Key 3",
    0x93931707: "Ocean Palace Sonic Act 2 Bonus Key 1",
    0x93931708: "Ocean Palace Sonic Act 2 Bonus Key 2",
    0x93931709: "Ocean Palace Sonic Act 2 Bonus Key 3",
    0x9393170a: "Grand Metropolis Sonic Act 2 Bonus Key 1",
    0x9393170b: "Grand Metropolis Sonic Act 2 Bonus Key 2",
    0x9393170c: "Power Plant Sonic Act 2 Bonus Key 1",
    0x9393170d: "Power Plant Sonic Act 2 Bonus Key 2",
    0x9393170e: "Power Plant Sonic Act 2 Bonus Key 3",
    0x9393170f: "Casino Park Sonic Act 2 Bonus Key 1",
    0x93931710: "Casino Park Sonic Act 2 Bonus Key 2",
    0x93931711: "Casino Park Sonic Act 2 Bonus Key 3",
    0x93931712: "Bingo Highway Sonic Act 2 Bonus Key 1",
    0x93931713: "Bingo Highway Sonic Act 2 Bonus Key 2",
    0x93931714: "Bingo Highway Sonic Act 2 Bonus Key 3",
    0x93931715: "Rail Canyon Sonic Act 2 Bonus Key 1",
    0x93931716: "Rail Canyon Sonic Act 2 Bonus Key 2",
    0x93931717: "Rail Canyon Sonic Act 2 Bonus Key 3",
    0x93931718: "Bullet Station Sonic Act 2 Bonus Key 1",
    0x93931719: "Bullet Station Sonic Act 2 Bonus Key 2",
    0x9393171a: "Bullet Station Sonic Act 2 Bonus Key 3",
    0x9393171b: "Frog Forest Sonic Act 2 Bonus Key 1",
    0x9393171c: "Frog Forest Sonic Act 2 Bonus Key 2",
    0x9393171d: "Frog Forest Sonic Act 2 Bonus Key 3",
    0x9393171e: "Lost Jungle Sonic Act 2 Bonus Key 1",
    0x9393171f: "Lost Jungle Sonic Act 2 Bonus Key 2",
    0x93931720: "Lost Jungle Sonic Act 2 Bonus Key 3",
    0x93931721: "Hang Castle Sonic Act 2 Bonus Key 1",
    0x93931722: "Hang Castle Sonic Act 2 Bonus Key 2",
    0x93931723: "Hang Castle Sonic Act 2 Bonus Key 3",
    0x93931724: "Mystic Mansion Sonic Act 2 Bonus Key 1",
    0x93931725: "Mystic Mansion Sonic Act 2 Bonus Key 2",
    0x93931726: "Mystic Mansion Sonic Act 2 Bonus Key 3",
    0x93931727: "Egg Fleet Sonic Act 2 Bonus Key 1",
    0x93931728: "Egg Fleet Sonic Act 2 Bonus Key 2",
    0x93931729: "Egg Fleet Sonic Act 2 Bonus Key 3",
    0x9393172a: "Final Fortress Sonic Act 2 Bonus Key 1",
    0x9393172b: "Final Fortress Sonic Act 2 Bonus Key 2",
    0x9393172c: "Final Fortress Sonic Act 2 Bonus Key 3",
    0x9393172d: "Seaside Hill Dark Act 2 Bonus Key 1",
    0x9393172e: "Seaside Hill Dark Act 2 Bonus Key 2",
    0x9393172f: "Seaside Hill Dark Act 2 Bonus Key 3",
    0x93931730: "Ocean Palace Dark Act 2 Bonus Key 1",
    0x93931731: "Ocean Palace Dark Act 2 Bonus Key 2",
    0x93931732: "Ocean Palace Dark Act 2 Bonus Key 3",
    0x93931733: "Grand Metropolis Dark Act 2 Bonus Key 1",
    0x93931734: "Grand Metropolis Dark Act 2 Bonus Key 2",
    0x93931735: "Grand Metropolis Dark Act 2 Bonus Key 3",
    0x93931736: "Power Plant Dark Act 2 Bonus Key 1",
    0x93931737: "Power Plant Dark Act 2 Bonus Key 2",
    0x93931738: "Power Plant Dark Act 2 Bonus Key 3",
    0x93931739: "Casino Park Dark Act 2 Bonus Key 1",
    0x9393173a: "Casino Park Dark Act 2 Bonus Key 2",
    0x9393173b: "Casino Park Dark Act 2 Bonus Key 3",
    0x9393173c: "Bingo Highway Dark Act 2 Bonus Key 1",
    0x9393173d: "Bingo Highway Dark Act 2 Bonus Key 2",
    0x9393173e: "Bingo Highway Dark Act 2 Bonus Key 3",
    0x9393173f: "Rail Canyon Dark Act 2 Bonus Key 1",
    0x93931740: "Rail Canyon Dark Act 2 Bonus Key 2",
    0x93931741: "Rail Canyon Dark Act 2 Bonus Key 3",
    0x93931742: "Bullet Station Dark Act 2 Bonus Key 1",
    0x93931743: "Bullet Station Dark Act 2 Bonus Key 2",
    0x93931744: "Bullet Station Dark Act 2 Bonus Key 3",
    0x93931745: "Frog Forest Dark Act 2 Bonus Key 1",
    0x93931746: "Frog Forest Dark Act 2 Bonus Key 2",
    0x93931747: "Frog Forest Dark Act 2 Bonus Key 3",
    0x93931748: "Lost Jungle Dark Act 2 Bonus Key 1",
    0x93931749: "Lost Jungle Dark Act 2 Bonus Key 2",
    0x9393174a: "Lost Jungle Dark Act 2 Bonus Key 3",
    0x9393174b: "Hang Castle Dark Act 2 Bonus Key 1",
    0x9393174c: "Hang Castle Dark Act 2 Bonus Key 2",
    0x9393174d: "Hang Castle Dark Act 2 Bonus Key 3",
    0x9393174e: "Mystic Mansion Dark Act 2 Bonus Key 1",
    0x9393174f: "Mystic Mansion Dark Act 2 Bonus Key 2",
    0x93931750: "Mystic Mansion Dark Act 2 Bonus Key 3",
    0x93931751: "Egg Fleet Dark Act 2 Bonus Key 1",
    0x93931752: "Egg Fleet Dark Act 2 Bonus Key 2",
    0x93931753: "Egg Fleet Dark Act 2 Bonus Key 3",
    0x93931754: "Final Fortress Dark Act 2 Bonus Key 1",
    0x93931755: "Final Fortress Dark Act 2 Bonus Key 2",
    0x93931756: "Final Fortress Dark Act 2 Bonus Key 3",
    0x93931757: "Seaside Hill Rose Act 2 Bonus Key 1",
    0x93931758: "Seaside Hill Rose Act 2 Bonus Key 2",
    0x93931759: "Ocean Palace Rose Act 2 Bonus Key 1",
    0x9393175a: "Ocean Palace Rose Act 2 Bonus Key 2",
    0x9393175b: "Ocean Palace Rose Act 2 Bonus Key 3",
    0x9393175c: "Grand Metropolis Rose Act 2 Bonus Key 1",
    0x9393175d: "Grand Metropolis Rose Act 2 Bonus Key 2",
    0x9393175e: "Grand Metropolis Rose Act 2 Bonus Key 3",
    0x9393175f: "Power Plant Rose Act 2 Bonus Key 1",
    0x93931760: "Power Plant Rose Act 2 Bonus Key 2",
    0x93931761: "Power Plant Rose Act 2 Bonus Key 3",
    0x93931762: "Casino Park Rose Act 2 Bonus Key 1",
    0x93931763: "Casino Park Rose Act 2 Bonus Key 2",
    0x93931764: "Casino Park Rose Act 2 Bonus Key 3",
    0x93931765: "SUPER SECRET HIDDEN Act 2 Bonus Key",
    0x93931766: "Bingo Highway Rose Act 2 Bonus Key 1",
    0x93931767: "Bingo Highway Rose Act 2 Bonus Key 2",
    0x93931768: "Bingo Highway Rose Act 2 Bonus Key 3",
    0x93931769: "Rail Canyon Rose Act 2 Bonus Key 1",
    0x9393176a: "Rail Canyon Rose Act 2 Bonus Key 2",
    0x9393176b: "Rail Canyon Rose Act 2 Bonus Key 3",
    0x9393176c: "Bullet Station Rose Act 2 Bonus Key 1",
    0x9393176d: "Bullet Station Rose Act 2 Bonus Key 2",
    0x9393176e: "Bullet Station Rose Act 2 Bonus Key 3",
    0x9393176f: "Frog Forest Rose Act 2 Bonus Key 1",
    0x93931770: "Frog Forest Rose Act 2 Bonus Key 2",
    0x93931771: "Frog Forest Rose Act 2 Bonus Key 3",
    0x93931772: "Lost Jungle Rose Act 2 Bonus Key 1",
    0x93931773: "Lost Jungle Rose Act 2 Bonus Key 2",
    0x93931774: "Lost Jungle Rose Act 2 Bonus Key 3",
    0x93931775: "Hang Castle Rose Act 2 Bonus Key 1",
    0x93931776: "Hang Castle Rose Act 2 Bonus Key 2",
    0x93931777: "Hang Castle Rose Act 2 Bonus Key 3",
    0x93931778: "Mystic Mansion Rose Act 2 Bonus Key 1",
    0x93931779: "Mystic Mansion Rose Act 2 Bonus Key 2",
    0x9393177a: "Mystic Mansion Rose Act 2 Bonus Key 3",
    0x9393177b: "Egg Fleet Rose Act 2 Bonus Key 1",
    0x9393177c: "Egg Fleet Rose Act 2 Bonus Key 2",
    0x9393177d: "Egg Fleet Rose Act 2 Bonus Key 3",
    0x9393177e: "Final Fortress Rose Act 2 Bonus Key 1",
    0x9393177f: "Final Fortress Rose Act 2 Bonus Key 2",
    0x93931780: "Final Fortress Rose Act 2 Bonus Key 3",
    0x93931781: "Seaside Hill Chaotix Act 2 Bonus Key 1",
    0x93931782: "Seaside Hill Chaotix Act 2 Bonus Key 2",
    0x93931783: "Seaside Hill Chaotix Act 2 Bonus Key 3",
    0x93931784: "Ocean Palace Chaotix Act 2 Bonus Key 1",
    0x93931785: "Ocean Palace Chaotix Act 2 Bonus Key 2",
    0x93931786: "Ocean Palace Chaotix Act 2 Bonus Key 3",
    0x93931787: "Grand Metropolis Chaotix Act 2 Bonus Key 1",
    0x93931788: "Grand Metropolis Chaotix Act 2 Bonus Key 2",
    0x93931789: "Grand Metropolis Chaotix Act 2 Bonus Key 3",
    0x9393178a: "Power Plant Chaotix Act 2 Bonus Key 1",
    0x9393178b: "Power Plant Chaotix Act 2 Bonus Key 2",
    0x9393178c: "Power Plant Chaotix Act 2 Bonus Key 3",
    0x9393178d: "Casino Park Chaotix Act 2 Bonus Key 1",
    0x9393178e: "Casino Park Chaotix Act 2 Bonus Key 2",
    0x9393178f: "Casino Park Chaotix Act 2 Bonus Key 3",
    0x93931790: "Bingo Highway Chaotix Act 2 Bonus Key 1",
    0x93931791: "Bingo Highway Chaotix Act 2 Bonus Key 2",
    0x93931792: "Bingo Highway Chaotix Act 2 Bonus Key 3",
    0x93931793: "Rail Canyon Chaotix Act 2 Bonus Key 1",
    0x93931794: "Rail Canyon Chaotix Act 2 Bonus Key 2",
    0x93931795: "Rail Canyon Chaotix Act 2 Bonus Key 3",
    0x93931796: "Bullet Station Chaotix Act 2 Bonus Key 1",
    0x93931797: "Bullet Station Chaotix Act 2 Bonus Key 2",
    0x93931798: "Bullet Station Chaotix Act 2 Bonus Key 3",
    0x93931799: "Frog Forest Chaotix Act 2 Bonus Key 1",
    0x9393179a: "Frog Forest Chaotix Act 2 Bonus Key 2",
    0x9393179b: "Frog Forest Chaotix Act 2 Bonus Key 3",
    0x9393179c: "Lost Jungle Chaotix Act 2 Bonus Key 1",
    0x9393179d: "Lost Jungle Chaotix Act 2 Bonus Key 2",
    0x9393179e: "Lost Jungle Chaotix Act 2 Bonus Key 3",
    0x9393179f: "Hang Castle Chaotix Act 2 Bonus Key 1",
    0x939317a0: "Hang Castle Chaotix Act 2 Bonus Key 2",
    0x939317a1: "Hang Castle Chaotix Act 2 Bonus Key 3",
    0x939317a2: "Mystic Mansion Chaotix Act 2 Bonus Key 1",
    0x939317a3: "Mystic Mansion Chaotix Act 2 Bonus Key 2",
    0x939317a4: "Mystic Mansion Chaotix Act 2 Bonus Key 3",
    0x939317a5: "Egg Fleet Chaotix Act 2 Bonus Key 1",
    0x939317a6: "Egg Fleet Chaotix Act 2 Bonus Key 2",
    0x939317a7: "Egg Fleet Chaotix Act 2 Bonus Key 3",
    0x939317a8: "Final Fortress Chaotix Act 2 Bonus Key 1",
    0x939317a9: "Final Fortress Chaotix Act 2 Bonus Key 2",
    0x939317aa: "Final Fortress Chaotix Act 2 Bonus Key 3",
    0x939317ab: "Seaside Hill Sonic Bonus Key 1",
    0x939317ac: "Seaside Hill Sonic Bonus Key 2",
    0x939317ad: "Seaside Hill Sonic Bonus Key 3",
    0x939317ae: "Ocean Palace Sonic Bonus Key 1",
    0x939317af: "Ocean Palace Sonic Bonus Key 2",
    0x939317b0: "Ocean Palace Sonic Bonus Key 3",
    0x939317b1: "Grand Metropolis Sonic Bonus Key 1",
    0x939317b2: "Grand Metropolis Sonic Bonus Key 2",
    0x939317b3: "Power Plant Sonic Bonus Key 1",
    0x939317b4: "Power Plant Sonic Bonus Key 2",
    0x939317b5: "Power Plant Sonic Bonus Key 3",
    0x939317b6: "Casino Park Sonic Bonus Key 1",
    0x939317b7: "Casino Park Sonic Bonus Key 2",
    0x939317b8: "Casino Park Sonic Bonus Key 3",
    0x939317b9: "Bingo Highway Sonic Bonus Key 1",
    0x939317ba: "Bingo Highway Sonic Bonus Key 2",
    0x939317bb: "Bingo Highway Sonic Bonus Key 3",
    0x939317bc: "Rail Canyon Sonic Bonus Key 1",
    0x939317bd: "Rail Canyon Sonic Bonus Key 2",
    0x939317be: "Rail Canyon Sonic Bonus Key 3",
    0x939317bf: "Bullet Station Sonic Bonus Key 1",
    0x939317c0: "Bullet Station Sonic Bonus Key 2",
    0x939317c1: "Bullet Station Sonic Bonus Key 3",
    0x939317c2: "Frog Forest Sonic Bonus Key 1",
    0x939317c3: "Frog Forest Sonic Bonus Key 2",
    0x939317c4: "Frog Forest Sonic Bonus Key 3",
    0x939317c5: "Lost Jungle Sonic Bonus Key 1",
    0x939317c6: "Lost Jungle Sonic Bonus Key 2",
    0x939317c7: "Lost Jungle Sonic Bonus Key 3",
    0x939317c8: "Hang Castle Sonic Bonus Key 1",
    0x939317c9: "Hang Castle Sonic Bonus Key 2",
    0x939317ca: "Hang Castle Sonic Bonus Key 3",
    0x939317cb: "Mystic Mansion Sonic Bonus Key 1",
    0x939317cc: "Mystic Mansion Sonic Bonus Key 2",
    0x939317cd: "Mystic Mansion Sonic Bonus Key 3",
    0x939317ce: "Egg Fleet Sonic Bonus Key 1",
    0x939317cf: "Egg Fleet Sonic Bonus Key 2",
    0x939317d0: "Egg Fleet Sonic Bonus Key 3",
    0x939317d1: "Final Fortress Sonic Bonus Key 1",
    0x939317d2: "Final Fortress Sonic Bonus Key 2",
    0x939317d3: "Final Fortress Sonic Bonus Key 3",
    0x939317d4: "Seaside Hill Dark Bonus Key 1",
    0x939317d5: "Seaside Hill Dark Bonus Key 2",
    0x939317d6: "Seaside Hill Dark Bonus Key 3",
    0x939317d7: "Ocean Palace Dark Bonus Key 1",
    0x939317d8: "Ocean Palace Dark Bonus Key 2",
    0x939317d9: "Ocean Palace Dark Bonus Key 3",
    0x939317da: "Grand Metropolis Dark Bonus Key 1",
    0x939317db: "Grand Metropolis Dark Bonus Key 2",
    0x939317dc: "Grand Metropolis Dark Bonus Key 3",
    0x939317dd: "Power Plant Dark Bonus Key 1",
    0x939317de: "Power Plant Dark Bonus Key 2",
    0x939317df: "Power Plant Dark Bonus Key 3",
    0x939317e0: "Casino Park Dark Bonus Key 1",
    0x939317e1: "Casino Park Dark Bonus Key 2",
    0x939317e2: "Casino Park Dark Bonus Key 3",
    0x939317e3: "Bingo Highway Dark Bonus Key 1",
    0x939317e4: "Bingo Highway Dark Bonus Key 2",
    0x939317e5: "Bingo Highway Dark Bonus Key 3",
    0x939317e6: "Rail Canyon Dark Bonus Key 1",
    0x939317e7: "Rail Canyon Dark Bonus Key 2",
    0x939317e8: "Rail Canyon Dark Bonus Key 3",
    0x939317e9: "Bullet Station Dark Bonus Key 1",
    0x939317ea: "Bullet Station Dark Bonus Key 2",
    0x939317eb: "Bullet Station Dark Bonus Key 3",
    0x939317ec: "Frog Forest Dark Bonus Key 1",
    0x939317ed: "Frog Forest Dark Bonus Key 2",
    0x939317ee: "Frog Forest Dark Bonus Key 3",
    0x939317ef: "Lost Jungle Dark Bonus Key 1",
    0x939317f0: "Lost Jungle Dark Bonus Key 2",
    0x939317f1: "Lost Jungle Dark Bonus Key 3",
    0x939317f2: "Hang Castle Dark Bonus Key 1",
    0x939317f3: "Hang Castle Dark Bonus Key 2",
    0x939317f4: "Hang Castle Dark Bonus Key 3",
    0x939317f5: "Mystic Mansion Dark Bonus Key 1",
    0x939317f6: "Mystic Mansion Dark Bonus Key 2",
    0x939317f7: "Mystic Mansion Dark Bonus Key 3",
    0x939317f8: "Egg Fleet Dark Bonus Key 1",
    0x939317f9: "Egg Fleet Dark Bonus Key 2",
    0x939317fa: "Egg Fleet Dark Bonus Key 3",
    0x939317fb: "Final Fortress Dark Bonus Key 1",
    0x939317fc: "Final Fortress Dark Bonus Key 2",
    0x939317fd: "Final Fortress Dark Bonus Key 3",
    0x939317fe: "Seaside Hill Rose Bonus Key 1",
    0x939317ff: "Seaside Hill Rose Bonus Key 2",
    0x93931800: "Ocean Palace Rose Bonus Key 1",
    0x93931801: "Ocean Palace Rose Bonus Key 2",
    0x93931802: "Ocean Palace Rose Bonus Key 3",
    0x93931803: "Grand Metropolis Rose Bonus Key 1",
    0x93931804: "Grand Metropolis Rose Bonus Key 2",
    0x93931805: "Grand Metropolis Rose Bonus Key 3",
    0x93931806: "Power Plant Rose Bonus Key 1",
    0x93931807: "Power Plant Rose Bonus Key 2",
    0x93931808: "Power Plant Rose Bonus Key 3",
    0x93931809: "Casino Park Rose Bonus Key 1",
    0x9393180a: "Casino Park Rose Bonus Key 2",
    0x9393180b: "Casino Park Rose Bonus Key 3",
    0x9393180c: "SUPER SECRET HIDDEN Bonus Key",
    0x9393180d: "Bingo Highway Rose Bonus Key 1",
    0x9393180e: "Bingo Highway Rose Bonus Key 2",
    0x9393180f: "Bingo Highway Rose Bonus Key 3",
    0x93931810: "Rail Canyon Rose Bonus Key 1",
    0x93931811: "Rail Canyon Rose Bonus Key 2",
    0x93931812: "Rail Canyon Rose Bonus Key 3",
    0x93931813: "Bullet Station Rose Bonus Key 1",
    0x93931814: "Bullet Station Rose Bonus Key 2",
    0x93931815: "Bullet Station Rose Bonus Key 3",
    0x93931816: "Frog Forest Rose Bonus Key 1",
    0x93931817: "Frog Forest Rose Bonus Key 2",
    0x93931818: "Frog Forest Rose Bonus Key 3",
    0x93931819: "Lost Jungle Rose Bonus Key 1",
    0x9393181a: "Lost Jungle Rose Bonus Key 2",
    0x9393181b: "Lost Jungle Rose Bonus Key 3",
    0x9393181c: "Hang Castle Rose Bonus Key 1",
    0x9393181d: "Hang Castle Rose Bonus Key 2",
    0x9393181e: "Hang Castle Rose Bonus Key 3",
    0x9393181f: "Mystic Mansion Rose Bonus Key 1",
    0x93931820: "Mystic Mansion Rose Bonus Key 2",
    0x93931821: "Mystic Mansion Rose Bonus Key 3",
    0x93931822: "Egg Fleet Rose Bonus Key 1",
    0x93931823: "Egg Fleet Rose Bonus Key 2",
    0x93931824: "Egg Fleet Rose Bonus Key 3",
    0x93931825: "Final Fortress Rose Bonus Key 1",
    0x93931826: "Final Fortress Rose Bonus Key 2",
    0x93931827: "Final Fortress Rose Bonus Key 3",
    0x93931828: "Seaside Hill Chaotix Bonus Key 1",
    0x93931829: "Seaside Hill Chaotix Bonus Key 2",
    0x9393182a: "Seaside Hill Chaotix Bonus Key 3",
    0x9393182b: "Ocean Palace Chaotix Bonus Key 1",
    0x9393182c: "Ocean Palace Chaotix Bonus Key 2",
    0x9393182d: "Ocean Palace Chaotix Bonus Key 3",
    0x9393182e: "Grand Metropolis Chaotix Bonus Key 1",
    0x9393182f: "Grand Metropolis Chaotix Bonus Key 2",
    0x93931830: "Grand Metropolis Chaotix Bonus Key 3",
    0x93931831: "Power Plant Chaotix Bonus Key 1",
    0x93931832: "Power Plant Chaotix Bonus Key 2",
    0x93931833: "Power Plant Chaotix Bonus Key 3",
    0x93931834: "Casino Park Chaotix Bonus Key 1",
    0x93931835: "Casino Park Chaotix Bonus Key 2",
    0x93931836: "Casino Park Chaotix Bonus Key 3",
    0x93931837: "Bingo Highway Chaotix Bonus Key 1",
    0x93931838: "Bingo Highway Chaotix Bonus Key 2",
    0x93931839: "Bingo Highway Chaotix Bonus Key 3",
    0x9393183a: "Rail Canyon Chaotix Bonus Key 1",
    0x9393183b: "Rail Canyon Chaotix Bonus Key 2",
    0x9393183c: "Rail Canyon Chaotix Bonus Key 3",
    0x9393183d: "Bullet Station Chaotix Bonus Key 1",
    0x9393183e: "Bullet Station Chaotix Bonus Key 2",
    0x9393183f: "Bullet Station Chaotix Bonus Key 3",
    0x93931840: "Frog Forest Chaotix Bonus Key 1",
    0x93931841: "Frog Forest Chaotix Bonus Key 2",
    0x93931842: "Frog Forest Chaotix Bonus Key 3",
    0x93931843: "Lost Jungle Chaotix Bonus Key 1",
    0x93931844: "Lost Jungle Chaotix Bonus Key 2",
    0x93931845: "Lost Jungle Chaotix Bonus Key 3",
    0x93931846: "Hang Castle Chaotix Bonus Key 1",
    0x93931847: "Hang Castle Chaotix Bonus Key 2",
    0x93931848: "Hang Castle Chaotix Bonus Key 3",
    0x93931849: "Mystic Mansion Chaotix Bonus Key 1",
    0x9393184a: "Mystic Mansion Chaotix Bonus Key 2",
    0x9393184b: "Mystic Mansion Chaotix Bonus Key 3",
    0x9393184c: "Egg Fleet Chaotix Bonus Key 1",
    0x9393184d: "Egg Fleet Chaotix Bonus Key 2",
    0x9393184e: "Egg Fleet Chaotix Bonus Key 3",
    0x9393184f: "Final Fortress Chaotix Bonus Key 1",
    0x93931850: "Final Fortress Chaotix Bonus Key 2",
    0x93931851: "Final Fortress Chaotix Bonus Key 3",

    0x93931900: "Seaside Hill Sonic Super Hard Mode",
    0x93931901: "Ocean Palace Sonic Super Hard Mode",
    0x93931902: "Grand Metropolis Sonic Super Hard Mode",
    0x93931903: "Power Plant Sonic Super Hard Mode",
    0x93931904: "Casino Park Sonic Super Hard Mode",
    0x93931905: "Bingo Highway Sonic Super Hard Mode",
    0x93931906: "Rail Canyon Sonic Super Hard Mode",
    0x93931907: "Bullet Station Sonic Super Hard Mode",
    0x93931908: "Frog Forest Sonic Super Hard Mode",
    0x93931909: "Lost Jungle Sonic Super Hard Mode",
    0x9393190a: "Hang Castle Sonic Super Hard Mode",
    0x9393190b: "Mystic Mansion Sonic Super Hard Mode",
    0x9393190c: "Egg Fleet Sonic Super Hard Mode",
    0x9393190d: "Final Fortress Sonic Super Hard Mode",
    0x9393190e: "Metal Overlord",

    0x93932000: "Seaside Hill Sonic Checkpoint 1",
    0x93932001: "Seaside Hill Sonic Checkpoint 2",
    0x93932002: "Seaside Hill Sonic Checkpoint 3",
    0x93932003: "Seaside Hill Sonic Checkpoint 4",
    0x93932004: "Seaside Hill Sonic Checkpoint 5",
    0x93932005: "Ocean Palace Sonic Checkpoint 1",
    0x93932006: "Ocean Palace Sonic Checkpoint 2",
    0x93932007: "Ocean Palace Sonic Checkpoint 3",
    0x93932008: "Ocean Palace Sonic Checkpoint 4",
    0x93932009: "Grand Metropolis Sonic Checkpoint 1",
    0x9393200a: "Grand Metropolis Sonic Checkpoint 2",
    0x9393200b: "Grand Metropolis Sonic Checkpoint 3",
    0x9393200c: "Grand Metropolis Sonic Checkpoint 4",
    0x9393200d: "Power Plant Sonic Checkpoint 1",
    0x9393200e: "Power Plant Sonic Checkpoint 2",
    0x9393200f: "Power Plant Sonic Checkpoint 3",
    0x93932010: "Power Plant Sonic Checkpoint 4",
    0x93932011: "Casino Park Sonic Checkpoint 1",
    0x93932012: "Casino Park Sonic Checkpoint 2",
    0x93932013: "Casino Park Sonic Checkpoint 3",
    0x93932014: "Bingo Highway Sonic Checkpoint 1",
    0x93932015: "Bingo Highway Sonic Checkpoint 2",
    0x93932016: "Bingo Highway Sonic Checkpoint 3",
    0x93932017: "Bingo Highway Sonic Checkpoint 4",
    0x93932018: "Rail Canyon Sonic Checkpoint 1",
    0x93932019: "Rail Canyon Sonic Checkpoint 2",
    0x9393201a: "Rail Canyon Sonic Checkpoint 3",
    0x9393201b: "Rail Canyon Sonic Checkpoint 4",
    0x9393201c: "Rail Canyon Sonic Checkpoint 5",
    0x9393201d: "Rail Canyon Sonic Checkpoint 6",
    0x9393201e: "Bullet Station Sonic Checkpoint 1",
    0x9393201f: "Bullet Station Sonic Checkpoint 2",
    0x93932020: "Bullet Station Sonic Checkpoint 3",
    0x93932021: "Bullet Station Sonic Checkpoint 4",
    0x93932022: "Frog Forest Sonic Checkpoint 1",
    0x93932023: "Frog Forest Sonic Checkpoint 2",
    0x93932024: "Frog Forest Sonic Checkpoint 3",
    0x93932025: "Lost Jungle Sonic Checkpoint 1",
    0x93932026: "Lost Jungle Sonic Checkpoint 2",
    0x93932027: "Lost Jungle Sonic Checkpoint 3",
    0x93932028: "Lost Jungle Sonic Checkpoint 4",
    0x93932029: "Lost Jungle Sonic Checkpoint 5",
    0x9393202a: "Hang Castle Sonic Checkpoint 1",
    0x9393202b: "Hang Castle Sonic Checkpoint 2",
    0x9393202c: "Hang Castle Sonic Checkpoint 3",
    0x9393202d: "Mystic Mansion Sonic Checkpoint 1",
    0x9393202e: "Mystic Mansion Sonic Checkpoint 2",
    0x9393202f: "Mystic Mansion Sonic Checkpoint 3",
    0x93932030: "Mystic Mansion Sonic Checkpoint 4",
    0x93932031: "Egg Fleet Sonic Checkpoint 1",
    0x93932032: "Egg Fleet Sonic Checkpoint 2",
    0x93932033: "Egg Fleet Sonic Checkpoint 3",
    0x93932034: "Egg Fleet Sonic Checkpoint 4",
    0x93932035: "Egg Fleet Sonic Checkpoint 5",
    0x93932036: "Final Fortress Sonic Checkpoint 1",
    0x93932037: "Final Fortress Sonic Checkpoint 2",
    0x93932038: "Final Fortress Sonic Checkpoint 3",
    0x93932039: "Seaside Hill Dark Checkpoint 1",
    0x9393203a: "Seaside Hill Dark Checkpoint 2",
    0x9393203b: "Seaside Hill Dark Checkpoint 3",
    0x9393203c: "Seaside Hill Dark Checkpoint 4",
    0x9393203d: "Ocean Palace Dark Checkpoint 1",
    0x9393203e: "Ocean Palace Dark Checkpoint 2",
    0x9393203f: "Ocean Palace Dark Checkpoint 3",
    0x93932040: "Ocean Palace Dark Checkpoint 4",
    0x93932041: "Ocean Palace Dark Checkpoint 5",
    0x93932042: "Grand Metropolis Dark Checkpoint 1",
    0x93932043: "Grand Metropolis Dark Checkpoint 2",
    0x93932044: "Grand Metropolis Dark Checkpoint 3",
    0x93932045: "Grand Metropolis Dark Checkpoint 4",
    0x93932046: "Power Plant Dark Checkpoint 1",
    0x93932047: "Power Plant Dark Checkpoint 2",
    0x93932048: "Power Plant Dark Checkpoint 3",
    0x93932049: "Power Plant Dark Checkpoint 4",
    0x9393204a: "Casino Park Dark Checkpoint 1",
    0x9393204b: "Casino Park Dark Checkpoint 2",
    0x9393204c: "Casino Park Dark Checkpoint 3",
    0x9393204d: "Bingo Highway Dark Checkpoint 1",
    0x9393204e: "Bingo Highway Dark Checkpoint 2",
    0x9393204f: "Bingo Highway Dark Checkpoint 3",
    0x93932050: "Bingo Highway Dark Checkpoint 4",
    0x93932051: "Rail Canyon Dark Checkpoint 1",
    0x93932052: "Rail Canyon Dark Checkpoint 2",
    0x93932053: "Rail Canyon Dark Checkpoint 3",
    0x93932054: "Rail Canyon Dark Checkpoint 4",
    0x93932055: "Rail Canyon Dark Checkpoint 5",
    0x93932056: "Rail Canyon Dark Checkpoint 6",
    0x93932057: "Bullet Station Dark Checkpoint 1",
    0x93932058: "Bullet Station Dark Checkpoint 2",
    0x93932059: "Bullet Station Dark Checkpoint 3",
    0x9393205a: "Bullet Station Dark Checkpoint 4",
    0x9393205b: "Bullet Station Dark Checkpoint 5",
    0x9393205c: "Frog Forest Dark Checkpoint 1",
    0x9393205d: "Frog Forest Dark Checkpoint 2",
    0x9393205e: "Frog Forest Dark Checkpoint 3",
    0x9393205f: "Lost Jungle Dark Checkpoint 1",
    0x93932060: "Lost Jungle Dark Checkpoint 2",
    0x93932061: "Lost Jungle Dark Checkpoint 3",
    0x93932062: "Lost Jungle Dark Checkpoint 4",
    0x93932063: "Lost Jungle Dark Checkpoint 5",
    0x93932064: "Hang Castle Dark Checkpoint 1",
    0x93932065: "Hang Castle Dark Checkpoint 2",
    0x93932066: "Hang Castle Dark Checkpoint 3",
    0x93932067: "Mystic Mansion Dark Checkpoint 1",
    0x93932068: "Mystic Mansion Dark Checkpoint 2",
    0x93932069: "Mystic Mansion Dark Checkpoint 3",
    0x9393206a: "Mystic Mansion Dark Checkpoint 4",
    0x9393206b: "Egg Fleet Dark Checkpoint 1",
    0x9393206c: "Egg Fleet Dark Checkpoint 2",
    0x9393206d: "Egg Fleet Dark Checkpoint 3",
    0x9393206e: "Egg Fleet Dark Checkpoint 4",
    0x9393206f: "Egg Fleet Dark Checkpoint 5",
    0x93932070: "Final Fortress Dark Checkpoint 1",
    0x93932071: "Final Fortress Dark Checkpoint 2",
    0x93932072: "Final Fortress Dark Checkpoint 3",
    0x93932073: "Seaside Hill Rose Checkpoint 1",
    0x93932074: "Seaside Hill Rose Checkpoint 2",
    0x93932075: "Ocean Palace Rose Checkpoint 1",
    0x93932076: "Ocean Palace Rose Checkpoint 2",
    0x93932077: "Grand Metropolis Rose Checkpoint 1",
    0x93932078: "Grand Metropolis Rose Checkpoint 2",
    0x93932079: "Grand Metropolis Rose Checkpoint 3",
    0x9393207a: "Power Plant Rose Checkpoint 1",
    0x9393207b: "Power Plant Rose Checkpoint 2",
    0x9393207c: "Casino Park Rose Checkpoint 1",
    0x9393207d: "Bingo Highway Rose Checkpoint 1",
    0x9393207e: "Bingo Highway Rose Checkpoint 2",
    0x9393207f: "Bingo Highway Rose Checkpoint 3",
    0x93932080: "Rail Canyon Rose Checkpoint 1",
    0x93932081: "Rail Canyon Rose Checkpoint 2",
    0x93932082: "Rail Canyon Rose Checkpoint 3",
    0x93932083: "Rail Canyon Rose Checkpoint 4",
    0x93932084: "Bullet Station Rose Checkpoint 1",
    0x93932085: "Bullet Station Rose Checkpoint 2",
    0x93932086: "Frog Forest Rose Checkpoint 1",
    0x93932087: "Frog Forest Rose Checkpoint 2",
    0x93932088: "Lost Jungle Rose Checkpoint 1",
    0x93932089: "Lost Jungle Rose Checkpoint 2",
    0x9393208a: "Lost Jungle Rose Checkpoint 3",
    0x9393208b: "Hang Castle Rose Checkpoint 1",
    0x9393208c: "Hang Castle Rose Checkpoint 2",
    0x9393208d: "Hang Castle Rose Checkpoint 3",
    0x9393208e: "Mystic Mansion Rose Checkpoint 1",
    0x9393208f: "Mystic Mansion Rose Checkpoint 2",
    0x93932090: "Egg Fleet Rose Checkpoint 1",
    0x93932091: "Egg Fleet Rose Checkpoint 2",
    0x93932092: "Final Fortress Rose Checkpoint 1",
    0x93932093: "Final Fortress Rose Checkpoint 2",
    0x93932094: "Seaside Hill Chaotix Checkpoint 1",
    0x93932095: "Seaside Hill Chaotix Checkpoint 2",
    0x93932096: "Seaside Hill Chaotix Checkpoint 3",
    0x93932097: "Seaside Hill Chaotix Checkpoint 4",
    0x93932098: "Ocean Palace Chaotix Checkpoint 1",
    0x93932099: "Ocean Palace Chaotix Checkpoint 2",
    0x9393209a: "Grand Metropolis Chaotix Checkpoint 1",
    0x9393209b: "Grand Metropolis Chaotix Checkpoint 2",
    0x9393209c: "Grand Metropolis Chaotix Checkpoint 3",
    0x9393209d: "Grand Metropolis Chaotix Checkpoint 4",
    0x9393209e: "Power Plant Chaotix Checkpoint 1",
    0x9393209f: "Power Plant Chaotix Checkpoint 2",
    0x939320a0: "Power Plant Chaotix Checkpoint 3",
    0x939320a1: "Casino Park Chaotix Checkpoint 1",
    0x939320a2: "Casino Park Chaotix Checkpoint 2",
    0x939320a3: "Casino Park Chaotix Checkpoint 3",
    0x939320a4: "Bingo Highway Chaotix Checkpoint 1",
    0x939320a5: "Bingo Highway Chaotix Checkpoint 2",
    0x939320a6: "Rail Canyon Chaotix Checkpoint 1",
    0x939320a7: "Rail Canyon Chaotix Checkpoint 2",
    0x939320a8: "Rail Canyon Chaotix Checkpoint 3",
    0x939320a9: "Rail Canyon Chaotix Checkpoint 4",
    0x939320aa: "Rail Canyon Chaotix Checkpoint 5",
    0x939320ab: "Bullet Station Chaotix Checkpoint 1",
    0x939320ac: "Bullet Station Chaotix Checkpoint 2",
    0x939320ad: "Bullet Station Chaotix Checkpoint 3",
    0x939320ae: "Bullet Station Chaotix Checkpoint 4",
    0x939320af: "Frog Forest Chaotix Checkpoint 1",
    0x939320b0: "Frog Forest Chaotix Checkpoint 2",
    0x939320b1: "Frog Forest Chaotix Checkpoint 3",
    0x939320b2: "Lost Jungle Chaotix Checkpoint 1",
    0x939320b3: "Lost Jungle Chaotix Checkpoint 2",
    0x939320b4: "Lost Jungle Chaotix Checkpoint 3",
    0x939320b5: "Lost Jungle Chaotix Checkpoint 4",
    0x939320b6: "Hang Castle Chaotix Checkpoint 1",
    0x939320b7: "Hang Castle Chaotix Checkpoint 2",
    0x939320b8: "Mystic Mansion Chaotix Checkpoint 1",
    0x939320b9: "Mystic Mansion Chaotix Checkpoint 2",
    0x939320ba: "Mystic Mansion Chaotix Checkpoint 3",
    0x939320bb: "Mystic Mansion Chaotix Checkpoint 4",
    0x939320bc: "Mystic Mansion Chaotix Checkpoint 5",
    0x939320bd: "Egg Fleet Chaotix Checkpoint 1",
    0x939320be: "Egg Fleet Chaotix Checkpoint 2",
    0x939320bf: "Egg Fleet Chaotix Checkpoint 3",
    0x939320c0: "Egg Fleet Chaotix Checkpoint 4",
    0x939320c1: "Final Fortress Chaotix Checkpoint 1",
    0x939320c2: "Final Fortress Chaotix Checkpoint 2",
    0x939320c3: "Final Fortress Chaotix Checkpoint 3",
    0x939320c4: "Seaside Hill Sonic Act 1 Checkpoint 1",
    0x939320c5: "Seaside Hill Sonic Act 1 Checkpoint 2",
    0x939320c6: "Seaside Hill Sonic Act 1 Checkpoint 3",
    0x939320c7: "Seaside Hill Sonic Act 1 Checkpoint 4",
    0x939320c8: "Seaside Hill Sonic Act 1 Checkpoint 5",
    0x939320c9: "Ocean Palace Sonic Act 1 Checkpoint 1",
    0x939320ca: "Ocean Palace Sonic Act 1 Checkpoint 2",
    0x939320cb: "Ocean Palace Sonic Act 1 Checkpoint 3",
    0x939320cc: "Ocean Palace Sonic Act 1 Checkpoint 4",
    0x939320cd: "Grand Metropolis Sonic Act 1 Checkpoint 1",
    0x939320ce: "Grand Metropolis Sonic Act 1 Checkpoint 2",
    0x939320cf: "Grand Metropolis Sonic Act 1 Checkpoint 3",
    0x939320d0: "Grand Metropolis Sonic Act 1 Checkpoint 4",
    0x939320d1: "Power Plant Sonic Act 1 Checkpoint 1",
    0x939320d2: "Power Plant Sonic Act 1 Checkpoint 2",
    0x939320d3: "Power Plant Sonic Act 1 Checkpoint 3",
    0x939320d4: "Power Plant Sonic Act 1 Checkpoint 4",
    0x939320d5: "Casino Park Sonic Act 1 Checkpoint 1",
    0x939320d6: "Casino Park Sonic Act 1 Checkpoint 2",
    0x939320d7: "Casino Park Sonic Act 1 Checkpoint 3",
    0x939320d8: "Bingo Highway Sonic Act 1 Checkpoint 1",
    0x939320d9: "Bingo Highway Sonic Act 1 Checkpoint 2",
    0x939320da: "Bingo Highway Sonic Act 1 Checkpoint 3",
    0x939320db: "Bingo Highway Sonic Act 1 Checkpoint 4",
    0x939320dc: "Rail Canyon Sonic Act 1 Checkpoint 1",
    0x939320dd: "Rail Canyon Sonic Act 1 Checkpoint 2",
    0x939320de: "Rail Canyon Sonic Act 1 Checkpoint 3",
    0x939320df: "Rail Canyon Sonic Act 1 Checkpoint 4",
    0x939320e0: "Rail Canyon Sonic Act 1 Checkpoint 5",
    0x939320e1: "Rail Canyon Sonic Act 1 Checkpoint 6",
    0x939320e2: "Bullet Station Sonic Act 1 Checkpoint 1",
    0x939320e3: "Bullet Station Sonic Act 1 Checkpoint 2",
    0x939320e4: "Bullet Station Sonic Act 1 Checkpoint 3",
    0x939320e5: "Bullet Station Sonic Act 1 Checkpoint 4",
    0x939320e6: "Frog Forest Sonic Act 1 Checkpoint 1",
    0x939320e7: "Frog Forest Sonic Act 1 Checkpoint 2",
    0x939320e8: "Frog Forest Sonic Act 1 Checkpoint 3",
    0x939320e9: "Lost Jungle Sonic Act 1 Checkpoint 1",
    0x939320ea: "Lost Jungle Sonic Act 1 Checkpoint 2",
    0x939320eb: "Lost Jungle Sonic Act 1 Checkpoint 3",
    0x939320ec: "Lost Jungle Sonic Act 1 Checkpoint 4",
    0x939320ed: "Lost Jungle Sonic Act 1 Checkpoint 5",
    0x939320ee: "Hang Castle Sonic Act 1 Checkpoint 1",
    0x939320ef: "Hang Castle Sonic Act 1 Checkpoint 2",
    0x939320f0: "Hang Castle Sonic Act 1 Checkpoint 3",
    0x939320f1: "Mystic Mansion Sonic Act 1 Checkpoint 1",
    0x939320f2: "Mystic Mansion Sonic Act 1 Checkpoint 2",
    0x939320f3: "Mystic Mansion Sonic Act 1 Checkpoint 3",
    0x939320f4: "Mystic Mansion Sonic Act 1 Checkpoint 4",
    0x939320f5: "Egg Fleet Sonic Act 1 Checkpoint 1",
    0x939320f6: "Egg Fleet Sonic Act 1 Checkpoint 2",
    0x939320f7: "Egg Fleet Sonic Act 1 Checkpoint 3",
    0x939320f8: "Egg Fleet Sonic Act 1 Checkpoint 4",
    0x939320f9: "Egg Fleet Sonic Act 1 Checkpoint 5",
    0x939320fa: "Final Fortress Sonic Act 1 Checkpoint 1",
    0x939320fb: "Final Fortress Sonic Act 1 Checkpoint 2",
    0x939320fc: "Final Fortress Sonic Act 1 Checkpoint 3",
    0x939320fd: "Seaside Hill Dark Act 1 Checkpoint 1",
    0x939320fe: "Seaside Hill Dark Act 1 Checkpoint 2",
    0x939320ff: "Seaside Hill Dark Act 1 Checkpoint 3",
    0x93932100: "Seaside Hill Dark Act 1 Checkpoint 4",
    0x93932101: "Ocean Palace Dark Act 1 Checkpoint 1",
    0x93932102: "Ocean Palace Dark Act 1 Checkpoint 2",
    0x93932103: "Ocean Palace Dark Act 1 Checkpoint 3",
    0x93932104: "Ocean Palace Dark Act 1 Checkpoint 4",
    0x93932105: "Ocean Palace Dark Act 1 Checkpoint 5",
    0x93932106: "Grand Metropolis Dark Act 1 Checkpoint 1",
    0x93932107: "Grand Metropolis Dark Act 1 Checkpoint 2",
    0x93932108: "Grand Metropolis Dark Act 1 Checkpoint 3",
    0x93932109: "Grand Metropolis Dark Act 1 Checkpoint 4",
    0x9393210a: "Power Plant Dark Act 1 Checkpoint 1",
    0x9393210b: "Power Plant Dark Act 1 Checkpoint 2",
    0x9393210c: "Power Plant Dark Act 1 Checkpoint 3",
    0x9393210d: "Power Plant Dark Act 1 Checkpoint 4",
    0x9393210e: "Casino Park Dark Act 1 Checkpoint 1",
    0x9393210f: "Casino Park Dark Act 1 Checkpoint 2",
    0x93932110: "Casino Park Dark Act 1 Checkpoint 3",
    0x93932111: "Bingo Highway Dark Act 1 Checkpoint 1",
    0x93932112: "Bingo Highway Dark Act 1 Checkpoint 2",
    0x93932113: "Bingo Highway Dark Act 1 Checkpoint 3",
    0x93932114: "Bingo Highway Dark Act 1 Checkpoint 4",
    0x93932115: "Rail Canyon Dark Act 1 Checkpoint 1",
    0x93932116: "Rail Canyon Dark Act 1 Checkpoint 2",
    0x93932117: "Rail Canyon Dark Act 1 Checkpoint 3",
    0x93932118: "Rail Canyon Dark Act 1 Checkpoint 4",
    0x93932119: "Rail Canyon Dark Act 1 Checkpoint 5",
    0x9393211a: "Rail Canyon Dark Act 1 Checkpoint 6",
    0x9393211b: "Bullet Station Dark Act 1 Checkpoint 1",
    0x9393211c: "Bullet Station Dark Act 1 Checkpoint 2",
    0x9393211d: "Bullet Station Dark Act 1 Checkpoint 3",
    0x9393211e: "Bullet Station Dark Act 1 Checkpoint 4",
    0x9393211f: "Bullet Station Dark Act 1 Checkpoint 5",
    0x93932120: "Frog Forest Dark Act 1 Checkpoint 1",
    0x93932121: "Frog Forest Dark Act 1 Checkpoint 2",
    0x93932122: "Frog Forest Dark Act 1 Checkpoint 3",
    0x93932123: "Lost Jungle Dark Act 1 Checkpoint 1",
    0x93932124: "Lost Jungle Dark Act 1 Checkpoint 2",
    0x93932125: "Lost Jungle Dark Act 1 Checkpoint 3",
    0x93932126: "Lost Jungle Dark Act 1 Checkpoint 4",
    0x93932127: "Lost Jungle Dark Act 1 Checkpoint 5",
    0x93932128: "Hang Castle Dark Act 1 Checkpoint 1",
    0x93932129: "Hang Castle Dark Act 1 Checkpoint 2",
    0x9393212a: "Hang Castle Dark Act 1 Checkpoint 3",
    0x9393212b: "Mystic Mansion Dark Act 1 Checkpoint 1",
    0x9393212c: "Mystic Mansion Dark Act 1 Checkpoint 2",
    0x9393212d: "Mystic Mansion Dark Act 1 Checkpoint 3",
    0x9393212e: "Mystic Mansion Dark Act 1 Checkpoint 4",
    0x9393212f: "Egg Fleet Dark Act 1 Checkpoint 1",
    0x93932130: "Egg Fleet Dark Act 1 Checkpoint 2",
    0x93932131: "Egg Fleet Dark Act 1 Checkpoint 3",
    0x93932132: "Egg Fleet Dark Act 1 Checkpoint 4",
    0x93932133: "Egg Fleet Dark Act 1 Checkpoint 5",
    0x93932134: "Final Fortress Dark Act 1 Checkpoint 1",
    0x93932135: "Final Fortress Dark Act 1 Checkpoint 2",
    0x93932136: "Final Fortress Dark Act 1 Checkpoint 3",
    0x93932137: "Seaside Hill Rose Act 1 Checkpoint 1",
    0x93932138: "Seaside Hill Rose Act 1 Checkpoint 2",
    0x93932139: "Ocean Palace Rose Act 1 Checkpoint 1",
    0x9393213a: "Ocean Palace Rose Act 1 Checkpoint 2",
    0x9393213b: "Grand Metropolis Rose Act 1 Checkpoint 1",
    0x9393213c: "Grand Metropolis Rose Act 1 Checkpoint 2",
    0x9393213d: "Grand Metropolis Rose Act 1 Checkpoint 3",
    0x9393213e: "Power Plant Rose Act 1 Checkpoint 1",
    0x9393213f: "Power Plant Rose Act 1 Checkpoint 2",
    0x93932140: "Casino Park Rose Act 1 Checkpoint 1",
    0x93932141: "Bingo Highway Rose Act 1 Checkpoint 1",
    0x93932142: "Bingo Highway Rose Act 1 Checkpoint 2",
    0x93932143: "Bingo Highway Rose Act 1 Checkpoint 3",
    0x93932144: "Rail Canyon Rose Act 1 Checkpoint 1",
    0x93932145: "Rail Canyon Rose Act 1 Checkpoint 2",
    0x93932146: "Rail Canyon Rose Act 1 Checkpoint 3",
    0x93932147: "Rail Canyon Rose Act 1 Checkpoint 4",
    0x93932148: "Bullet Station Rose Act 1 Checkpoint 1",
    0x93932149: "Bullet Station Rose Act 1 Checkpoint 2",
    0x9393214a: "Frog Forest Rose Act 1 Checkpoint 1",
    0x9393214b: "Frog Forest Rose Act 1 Checkpoint 2",
    0x9393214c: "Lost Jungle Rose Act 1 Checkpoint 1",
    0x9393214d: "Lost Jungle Rose Act 1 Checkpoint 2",
    0x9393214e: "Lost Jungle Rose Act 1 Checkpoint 3",
    0x9393214f: "Hang Castle Rose Act 1 Checkpoint 1",
    0x93932150: "Hang Castle Rose Act 1 Checkpoint 2",
    0x93932151: "Hang Castle Rose Act 1 Checkpoint 3",
    0x93932152: "Mystic Mansion Rose Act 1 Checkpoint 1",
    0x93932153: "Mystic Mansion Rose Act 1 Checkpoint 2",
    0x93932154: "Egg Fleet Rose Act 1 Checkpoint 1",
    0x93932155: "Egg Fleet Rose Act 1 Checkpoint 2",
    0x93932156: "Final Fortress Rose Act 1 Checkpoint 1",
    0x93932157: "Final Fortress Rose Act 1 Checkpoint 2",
    0x93932158: "Seaside Hill Chaotix Act 1 Checkpoint 1",
    0x93932159: "Seaside Hill Chaotix Act 1 Checkpoint 2",
    0x9393215a: "Seaside Hill Chaotix Act 1 Checkpoint 3",
    0x9393215b: "Seaside Hill Chaotix Act 1 Checkpoint 4",
    0x9393215c: "Ocean Palace Chaotix Act 1 Checkpoint 1",
    0x9393215d: "Ocean Palace Chaotix Act 1 Checkpoint 2",
    0x9393215e: "Grand Metropolis Chaotix Act 1 Checkpoint 1",
    0x9393215f: "Grand Metropolis Chaotix Act 1 Checkpoint 2",
    0x93932160: "Grand Metropolis Chaotix Act 1 Checkpoint 3",
    0x93932161: "Grand Metropolis Chaotix Act 1 Checkpoint 4",
    0x93932162: "Power Plant Chaotix Act 1 Checkpoint 1",
    0x93932163: "Power Plant Chaotix Act 1 Checkpoint 2",
    0x93932164: "Power Plant Chaotix Act 1 Checkpoint 3",
    0x93932165: "Casino Park Chaotix Act 1 Checkpoint 1",
    0x93932166: "Casino Park Chaotix Act 1 Checkpoint 2",
    0x93932167: "Casino Park Chaotix Act 1 Checkpoint 3",
    0x93932168: "Bingo Highway Chaotix Act 1 Checkpoint 1",
    0x93932169: "Bingo Highway Chaotix Act 1 Checkpoint 2",
    0x9393216a: "Rail Canyon Chaotix Act 1 Checkpoint 1",
    0x9393216b: "Rail Canyon Chaotix Act 1 Checkpoint 2",
    0x9393216c: "Rail Canyon Chaotix Act 1 Checkpoint 3",
    0x9393216d: "Rail Canyon Chaotix Act 1 Checkpoint 4",
    0x9393216e: "Rail Canyon Chaotix Act 1 Checkpoint 5",
    0x9393216f: "Bullet Station Chaotix Act 1 Checkpoint 1",
    0x93932170: "Bullet Station Chaotix Act 1 Checkpoint 2",
    0x93932171: "Bullet Station Chaotix Act 1 Checkpoint 3",
    0x93932172: "Bullet Station Chaotix Act 1 Checkpoint 4",
    0x93932173: "Frog Forest Chaotix Act 1 Checkpoint 1",
    0x93932174: "Frog Forest Chaotix Act 1 Checkpoint 2",
    0x93932175: "Frog Forest Chaotix Act 1 Checkpoint 3",
    0x93932176: "Lost Jungle Chaotix Act 1 Checkpoint 1",
    0x93932177: "Lost Jungle Chaotix Act 1 Checkpoint 2",
    0x93932178: "Lost Jungle Chaotix Act 1 Checkpoint 3",
    0x93932179: "Lost Jungle Chaotix Act 1 Checkpoint 4",
    0x9393217a: "Hang Castle Chaotix Act 1 Checkpoint 1",
    0x9393217b: "Hang Castle Chaotix Act 1 Checkpoint 2",
    0x9393217c: "Mystic Mansion Chaotix Act 1 Checkpoint 1",
    0x9393217d: "Mystic Mansion Chaotix Act 1 Checkpoint 2",
    0x9393217e: "Mystic Mansion Chaotix Act 1 Checkpoint 3",
    0x9393217f: "Mystic Mansion Chaotix Act 1 Checkpoint 4",
    0x93932180: "Mystic Mansion Chaotix Act 1 Checkpoint 5",
    0x93932181: "Egg Fleet Chaotix Act 1 Checkpoint 1",
    0x93932182: "Egg Fleet Chaotix Act 1 Checkpoint 2",
    0x93932183: "Egg Fleet Chaotix Act 1 Checkpoint 3",
    0x93932184: "Egg Fleet Chaotix Act 1 Checkpoint 4",
    0x93932185: "Final Fortress Chaotix Act 1 Checkpoint 1",
    0x93932186: "Final Fortress Chaotix Act 1 Checkpoint 2",
    0x93932187: "Final Fortress Chaotix Act 1 Checkpoint 3",
    0x93932188: "Seaside Hill Sonic Act 2 Checkpoint 1",
    0x93932189: "Seaside Hill Sonic Act 2 Checkpoint 2",
    0x9393218a: "Seaside Hill Sonic Act 2 Checkpoint 3",
    0x9393218b: "Seaside Hill Sonic Act 2 Checkpoint 4",
    0x9393218c: "Seaside Hill Sonic Act 2 Checkpoint 5",
    0x9393218d: "Ocean Palace Sonic Act 2 Checkpoint 1",
    0x9393218e: "Ocean Palace Sonic Act 2 Checkpoint 2",
    0x9393218f: "Ocean Palace Sonic Act 2 Checkpoint 3",
    0x93932190: "Ocean Palace Sonic Act 2 Checkpoint 4",
    0x93932191: "Grand Metropolis Sonic Act 2 Checkpoint 1",
    0x93932192: "Grand Metropolis Sonic Act 2 Checkpoint 2",
    0x93932193: "Grand Metropolis Sonic Act 2 Checkpoint 3",
    0x93932194: "Grand Metropolis Sonic Act 2 Checkpoint 4",
    0x93932195: "Power Plant Sonic Act 2 Checkpoint 1",
    0x93932196: "Power Plant Sonic Act 2 Checkpoint 2",
    0x93932197: "Power Plant Sonic Act 2 Checkpoint 3",
    0x93932198: "Power Plant Sonic Act 2 Checkpoint 4",
    0x93932199: "Casino Park Sonic Act 2 Checkpoint 1",
    0x9393219a: "Casino Park Sonic Act 2 Checkpoint 2",
    0x9393219b: "Casino Park Sonic Act 2 Checkpoint 3",
    0x9393219c: "Bingo Highway Sonic Act 2 Checkpoint 1",
    0x9393219d: "Bingo Highway Sonic Act 2 Checkpoint 2",
    0x9393219e: "Bingo Highway Sonic Act 2 Checkpoint 3",
    0x9393219f: "Bingo Highway Sonic Act 2 Checkpoint 4",
    0x939321a0: "Rail Canyon Sonic Act 2 Checkpoint 1",
    0x939321a1: "Rail Canyon Sonic Act 2 Checkpoint 2",
    0x939321a2: "Rail Canyon Sonic Act 2 Checkpoint 3",
    0x939321a3: "Rail Canyon Sonic Act 2 Checkpoint 4",
    0x939321a4: "Rail Canyon Sonic Act 2 Checkpoint 5",
    0x939321a5: "Rail Canyon Sonic Act 2 Checkpoint 6",
    0x939321a6: "Bullet Station Sonic Act 2 Checkpoint 1",
    0x939321a7: "Bullet Station Sonic Act 2 Checkpoint 2",
    0x939321a8: "Bullet Station Sonic Act 2 Checkpoint 3",
    0x939321a9: "Bullet Station Sonic Act 2 Checkpoint 4",
    0x939321aa: "Frog Forest Sonic Act 2 Checkpoint 1",
    0x939321ab: "Frog Forest Sonic Act 2 Checkpoint 2",
    0x939321ac: "Frog Forest Sonic Act 2 Checkpoint 3",
    0x939321ad: "Lost Jungle Sonic Act 2 Checkpoint 1",
    0x939321ae: "Lost Jungle Sonic Act 2 Checkpoint 2",
    0x939321af: "Lost Jungle Sonic Act 2 Checkpoint 3",
    0x939321b0: "Lost Jungle Sonic Act 2 Checkpoint 4",
    0x939321b1: "Lost Jungle Sonic Act 2 Checkpoint 5",
    0x939321b2: "Hang Castle Sonic Act 2 Checkpoint 1",
    0x939321b3: "Hang Castle Sonic Act 2 Checkpoint 2",
    0x939321b4: "Hang Castle Sonic Act 2 Checkpoint 3",
    0x939321b5: "Mystic Mansion Sonic Act 2 Checkpoint 1",
    0x939321b6: "Mystic Mansion Sonic Act 2 Checkpoint 2",
    0x939321b7: "Mystic Mansion Sonic Act 2 Checkpoint 3",
    0x939321b8: "Mystic Mansion Sonic Act 2 Checkpoint 4",
    0x939321b9: "Egg Fleet Sonic Act 2 Checkpoint 1",
    0x939321ba: "Egg Fleet Sonic Act 2 Checkpoint 2",
    0x939321bb: "Egg Fleet Sonic Act 2 Checkpoint 3",
    0x939321bc: "Egg Fleet Sonic Act 2 Checkpoint 4",
    0x939321bd: "Egg Fleet Sonic Act 2 Checkpoint 5",
    0x939321be: "Final Fortress Sonic Act 2 Checkpoint 1",
    0x939321bf: "Final Fortress Sonic Act 2 Checkpoint 2",
    0x939321c0: "Final Fortress Sonic Act 2 Checkpoint 3",
    0x939321c1: "Seaside Hill Dark Act 2 Checkpoint 1",
    0x939321c2: "Seaside Hill Dark Act 2 Checkpoint 2",
    0x939321c3: "Seaside Hill Dark Act 2 Checkpoint 3",
    0x939321c4: "Seaside Hill Dark Act 2 Checkpoint 4",
    0x939321c5: "Ocean Palace Dark Act 2 Checkpoint 1",
    0x939321c6: "Ocean Palace Dark Act 2 Checkpoint 2",
    0x939321c7: "Ocean Palace Dark Act 2 Checkpoint 3",
    0x939321c8: "Ocean Palace Dark Act 2 Checkpoint 4",
    0x939321c9: "Ocean Palace Dark Act 2 Checkpoint 5",
    0x939321ca: "Grand Metropolis Dark Act 2 Checkpoint 1",
    0x939321cb: "Grand Metropolis Dark Act 2 Checkpoint 2",
    0x939321cc: "Grand Metropolis Dark Act 2 Checkpoint 3",
    0x939321cd: "Grand Metropolis Dark Act 2 Checkpoint 4",
    0x939321ce: "Power Plant Dark Act 2 Checkpoint 1",
    0x939321cf: "Power Plant Dark Act 2 Checkpoint 2",
    0x939321d0: "Power Plant Dark Act 2 Checkpoint 3",
    0x939321d1: "Power Plant Dark Act 2 Checkpoint 4",
    0x939321d2: "Casino Park Dark Act 2 Checkpoint 1",
    0x939321d3: "Casino Park Dark Act 2 Checkpoint 2",
    0x939321d4: "Casino Park Dark Act 2 Checkpoint 3",
    0x939321d5: "Bingo Highway Dark Act 2 Checkpoint 1",
    0x939321d6: "Bingo Highway Dark Act 2 Checkpoint 2",
    0x939321d7: "Bingo Highway Dark Act 2 Checkpoint 3",
    0x939321d8: "Bingo Highway Dark Act 2 Checkpoint 4",
    0x939321d9: "Rail Canyon Dark Act 2 Checkpoint 1",
    0x939321da: "Rail Canyon Dark Act 2 Checkpoint 2",
    0x939321db: "Rail Canyon Dark Act 2 Checkpoint 3",
    0x939321dc: "Rail Canyon Dark Act 2 Checkpoint 4",
    0x939321dd: "Rail Canyon Dark Act 2 Checkpoint 5",
    0x939321de: "Rail Canyon Dark Act 2 Checkpoint 6",
    0x939321df: "Bullet Station Dark Act 2 Checkpoint 1",
    0x939321e0: "Bullet Station Dark Act 2 Checkpoint 2",
    0x939321e1: "Bullet Station Dark Act 2 Checkpoint 3",
    0x939321e2: "Bullet Station Dark Act 2 Checkpoint 4",
    0x939321e3: "Bullet Station Dark Act 2 Checkpoint 5",
    0x939321e4: "Frog Forest Dark Act 2 Checkpoint 1",
    0x939321e5: "Frog Forest Dark Act 2 Checkpoint 2",
    0x939321e6: "Frog Forest Dark Act 2 Checkpoint 3",
    0x939321e7: "Lost Jungle Dark Act 2 Checkpoint 1",
    0x939321e8: "Lost Jungle Dark Act 2 Checkpoint 2",
    0x939321e9: "Lost Jungle Dark Act 2 Checkpoint 3",
    0x939321ea: "Lost Jungle Dark Act 2 Checkpoint 4",
    0x939321eb: "Lost Jungle Dark Act 2 Checkpoint 5",
    0x939321ec: "Hang Castle Dark Act 2 Checkpoint 1",
    0x939321ed: "Hang Castle Dark Act 2 Checkpoint 2",
    0x939321ee: "Hang Castle Dark Act 2 Checkpoint 3",
    0x939321ef: "Mystic Mansion Dark Act 2 Checkpoint 1",
    0x939321f0: "Mystic Mansion Dark Act 2 Checkpoint 2",
    0x939321f1: "Mystic Mansion Dark Act 2 Checkpoint 3",
    0x939321f2: "Mystic Mansion Dark Act 2 Checkpoint 4",
    0x939321f3: "Egg Fleet Dark Act 2 Checkpoint 1",
    0x939321f4: "Egg Fleet Dark Act 2 Checkpoint 2",
    0x939321f5: "Egg Fleet Dark Act 2 Checkpoint 3",
    0x939321f6: "Egg Fleet Dark Act 2 Checkpoint 4",
    0x939321f7: "Egg Fleet Dark Act 2 Checkpoint 5",
    0x939321f8: "Final Fortress Dark Act 2 Checkpoint 1",
    0x939321f9: "Final Fortress Dark Act 2 Checkpoint 2",
    0x939321fa: "Final Fortress Dark Act 2 Checkpoint 3",
    0x939321fb: "Seaside Hill Rose Act 2 Checkpoint 1",
    0x939321fc: "Seaside Hill Rose Act 2 Checkpoint 2",
    0x939321fd: "Ocean Palace Rose Act 2 Checkpoint 1",
    0x939321fe: "Ocean Palace Rose Act 2 Checkpoint 2",
    0x939321ff: "Grand Metropolis Rose Act 2 Checkpoint 1",
    0x93932200: "Grand Metropolis Rose Act 2 Checkpoint 2",
    0x93932201: "Grand Metropolis Rose Act 2 Checkpoint 3",
    0x93932202: "Power Plant Rose Act 2 Checkpoint 1",
    0x93932203: "Power Plant Rose Act 2 Checkpoint 2",
    0x93932204: "Casino Park Rose Act 2 Checkpoint 1",
    0x93932205: "Bingo Highway Rose Act 2 Checkpoint 1",
    0x93932206: "Bingo Highway Rose Act 2 Checkpoint 2",
    0x93932207: "Bingo Highway Rose Act 2 Checkpoint 3",
    0x93932208: "Rail Canyon Rose Act 2 Checkpoint 1",
    0x93932209: "Rail Canyon Rose Act 2 Checkpoint 2",
    0x9393220a: "Rail Canyon Rose Act 2 Checkpoint 3",
    0x9393220b: "Rail Canyon Rose Act 2 Checkpoint 4",
    0x9393220c: "Bullet Station Rose Act 2 Checkpoint 1",
    0x9393220d: "Bullet Station Rose Act 2 Checkpoint 2",
    0x9393220e: "Frog Forest Rose Act 2 Checkpoint 1",
    0x9393220f: "Frog Forest Rose Act 2 Checkpoint 2",
    0x93932210: "Lost Jungle Rose Act 2 Checkpoint 1",
    0x93932211: "Lost Jungle Rose Act 2 Checkpoint 2",
    0x93932212: "Lost Jungle Rose Act 2 Checkpoint 3",
    0x93932213: "Hang Castle Rose Act 2 Checkpoint 1",
    0x93932214: "Hang Castle Rose Act 2 Checkpoint 2",
    0x93932215: "Hang Castle Rose Act 2 Checkpoint 3",
    0x93932216: "Mystic Mansion Rose Act 2 Checkpoint 1",
    0x93932217: "Mystic Mansion Rose Act 2 Checkpoint 2",
    0x93932218: "Egg Fleet Rose Act 2 Checkpoint 1",
    0x93932219: "Egg Fleet Rose Act 2 Checkpoint 2",
    0x9393221a: "Final Fortress Rose Act 2 Checkpoint 1",
    0x9393221b: "Final Fortress Rose Act 2 Checkpoint 2",
    0x9393221c: "Seaside Hill Chaotix Act 2 Checkpoint 1",
    0x9393221d: "Seaside Hill Chaotix Act 2 Checkpoint 2",
    0x9393221e: "Seaside Hill Chaotix Act 2 Checkpoint 3",
    0x9393221f: "Seaside Hill Chaotix Act 2 Checkpoint 4",
    0x93932220: "Ocean Palace Chaotix Act 2 Checkpoint 1",
    0x93932221: "Ocean Palace Chaotix Act 2 Checkpoint 2",
    0x93932222: "Grand Metropolis Chaotix Act 2 Checkpoint 1",
    0x93932223: "Grand Metropolis Chaotix Act 2 Checkpoint 2",
    0x93932224: "Grand Metropolis Chaotix Act 2 Checkpoint 3",
    0x93932225: "Grand Metropolis Chaotix Act 2 Checkpoint 4",
    0x93932226: "Power Plant Chaotix Act 2 Checkpoint 1",
    0x93932227: "Power Plant Chaotix Act 2 Checkpoint 2",
    0x93932228: "Power Plant Chaotix Act 2 Checkpoint 3",
    0x93932229: "Casino Park Chaotix Act 2 Checkpoint 1",
    0x9393222a: "Casino Park Chaotix Act 2 Checkpoint 2",
    0x9393222b: "Casino Park Chaotix Act 2 Checkpoint 3",
    0x9393222c: "Bingo Highway Chaotix Act 2 Checkpoint 1",
    0x9393222d: "Bingo Highway Chaotix Act 2 Checkpoint 2",
    0x9393222e: "Rail Canyon Chaotix Act 2 Checkpoint 1",
    0x9393222f: "Rail Canyon Chaotix Act 2 Checkpoint 2",
    0x93932230: "Rail Canyon Chaotix Act 2 Checkpoint 3",
    0x93932231: "Rail Canyon Chaotix Act 2 Checkpoint 4",
    0x93932232: "Rail Canyon Chaotix Act 2 Checkpoint 5",
    0x93932233: "Bullet Station Chaotix Act 2 Checkpoint 1",
    0x93932234: "Bullet Station Chaotix Act 2 Checkpoint 2",
    0x93932235: "Bullet Station Chaotix Act 2 Checkpoint 3",
    0x93932236: "Bullet Station Chaotix Act 2 Checkpoint 4",
    0x93932237: "Frog Forest Chaotix Act 2 Checkpoint 1",
    0x93932238: "Frog Forest Chaotix Act 2 Checkpoint 2",
    0x93932239: "Frog Forest Chaotix Act 2 Checkpoint 3",
    0x9393223a: "Lost Jungle Chaotix Act 2 Checkpoint 1",
    0x9393223b: "Lost Jungle Chaotix Act 2 Checkpoint 2",
    0x9393223c: "Lost Jungle Chaotix Act 2 Checkpoint 3",
    0x9393223d: "Lost Jungle Chaotix Act 2 Checkpoint 4",
    0x9393223e: "Hang Castle Chaotix Act 2 Checkpoint 1",
    0x9393223f: "Hang Castle Chaotix Act 2 Checkpoint 2",
    0x93932240: "Mystic Mansion Chaotix Act 2 Checkpoint 1",
    0x93932241: "Mystic Mansion Chaotix Act 2 Checkpoint 2",
    0x93932242: "Mystic Mansion Chaotix Act 2 Checkpoint 3",
    0x93932243: "Mystic Mansion Chaotix Act 2 Checkpoint 4",
    0x93932244: "Mystic Mansion Chaotix Act 2 Checkpoint 5",
    0x93932245: "Egg Fleet Chaotix Act 2 Checkpoint 1",
    0x93932246: "Egg Fleet Chaotix Act 2 Checkpoint 2",
    0x93932247: "Egg Fleet Chaotix Act 2 Checkpoint 3",
    0x93932248: "Egg Fleet Chaotix Act 2 Checkpoint 4",
    0x93932249: "Final Fortress Chaotix Act 2 Checkpoint 1",
    0x9393224a: "Final Fortress Chaotix Act 2 Checkpoint 2",
    0x9393224b: "Final Fortress Chaotix Act 2 Checkpoint 3",
    0x9393224c: "Seaside Hill Super Hard Mode Checkpoint 1",
    0x9393224d: "Seaside Hill Super Hard Mode Checkpoint 2",
    0x9393224e: "Seaside Hill Super Hard Mode Checkpoint 3",
    0x9393224f: "Seaside Hill Super Hard Mode Checkpoint 4",
    0x93932250: "Ocean Palace Super Hard Mode Checkpoint 1",
    0x93932251: "Ocean Palace Super Hard Mode Checkpoint 2",
    0x93932252: "Ocean Palace Super Hard Mode Checkpoint 3",
    0x93932253: "Ocean Palace Super Hard Mode Checkpoint 4",
    0x93932254: "Ocean Palace Super Hard Mode Checkpoint 5",
    0x93932255: "Grand Metropolis Super Hard Mode Checkpoint 1",
    0x93932256: "Grand Metropolis Super Hard Mode Checkpoint 2",
    0x93932257: "Grand Metropolis Super Hard Mode Checkpoint 3",
    0x93932258: "Grand Metropolis Super Hard Mode Checkpoint 4",
    0x93932259: "Power Plant Super Hard Mode Checkpoint 1",
    0x9393225a: "Power Plant Super Hard Mode Checkpoint 2",
    0x9393225b: "Power Plant Super Hard Mode Checkpoint 3",
    0x9393225c: "Power Plant Super Hard Mode Checkpoint 4",
    0x9393225d: "Casino Park Super Hard Mode Checkpoint 1",
    0x9393225e: "Casino Park Super Hard Mode Checkpoint 2",
    0x9393225f: "Casino Park Super Hard Mode Checkpoint 3",
    0x93932260: "Bingo Highway Super Hard Mode Checkpoint 1",
    0x93932261: "Bingo Highway Super Hard Mode Checkpoint 2",
    0x93932262: "Bingo Highway Super Hard Mode Checkpoint 3",
    0x93932263: "Bingo Highway Super Hard Mode Checkpoint 4",
    0x93932264: "Rail Canyon Super Hard Mode Checkpoint 1",
    0x93932265: "Rail Canyon Super Hard Mode Checkpoint 2",
    0x93932266: "Rail Canyon Super Hard Mode Checkpoint 3",
    0x93932267: "Rail Canyon Super Hard Mode Checkpoint 4",
    0x93932268: "Rail Canyon Super Hard Mode Checkpoint 5",
    0x93932269: "Rail Canyon Super Hard Mode Checkpoint 6",
    0x9393226a: "Bullet Station Super Hard Mode Checkpoint 1",
    0x9393226b: "Bullet Station Super Hard Mode Checkpoint 2",
    0x9393226c: "Bullet Station Super Hard Mode Checkpoint 3",
    0x9393226d: "Bullet Station Super Hard Mode Checkpoint 4",
    0x9393226e: "Frog Forest Super Hard Mode Checkpoint 1",
    0x9393226f: "Frog Forest Super Hard Mode Checkpoint 2",
    0x93932270: "Frog Forest Super Hard Mode Checkpoint 3",
    0x93932271: "Lost Jungle Super Hard Mode Checkpoint 1",
    0x93932272: "Lost Jungle Super Hard Mode Checkpoint 2",
    0x93932273: "Lost Jungle Super Hard Mode Checkpoint 3",
    0x93932274: "Lost Jungle Super Hard Mode Checkpoint 4",
    0x93932275: "Lost Jungle Super Hard Mode Checkpoint 5",
    0x93932276: "Hang Castle Super Hard Mode Checkpoint 1",
    0x93932277: "Hang Castle Super Hard Mode Checkpoint 2",
    0x93932278: "Hang Castle Super Hard Mode Checkpoint 3",
    0x93932279: "Mystic Mansion Super Hard Mode Checkpoint 1",
    0x9393227a: "Mystic Mansion Super Hard Mode Checkpoint 2",
    0x9393227b: "Mystic Mansion Super Hard Mode Checkpoint 3",
    0x9393227c: "Mystic Mansion Super Hard Mode Checkpoint 4",
    0x9393227d: "Mystic Mansion Super Hard Mode Checkpoint 5",
    0x9393227e: "Egg Fleet Super Hard Mode Checkpoint 1",
    0x9393227f: "Egg Fleet Super Hard Mode Checkpoint 2",
    0x93932280: "Egg Fleet Super Hard Mode Checkpoint 3",
    0x93932281: "Egg Fleet Super Hard Mode Checkpoint 4",
    0x93932282: "Egg Fleet Super Hard Mode Checkpoint 5",
    0x93932283: "Final Fortress Super Hard Mode Checkpoint 1",
    0x93932284: "Final Fortress Super Hard Mode Checkpoint 2",
    0x93932285: "Final Fortress Super Hard Mode Checkpoint 3",
}