from . import LingoTestBase


class TestProgressiveOrangeTower(LingoTestBase):
    options = {
        "shuffle_doors": "doors",
        "progressive_orange_tower": "true"
    }

    def test_from_welcome_back(self) -> None:
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect_by_name("Welcome Back Area - Shortcut to Starting Room")
        self.collect_by_name("Orange Tower Fifth Floor - Welcome Back")
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        progressive_tower = self.get_items_by_name("Progressive Orange Tower")

        self.collect(progressive_tower[0])
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[1])
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[2])
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[3])
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[4])
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[5])
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

    def test_from_hub_room(self) -> None:
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect_by_name("Second Room - Exit Door")
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect_by_name("Orange Tower First Floor - Shortcut to Hub Room")
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        progressive_tower = self.get_items_by_name("Progressive Orange Tower")

        self.collect(progressive_tower[0])
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.remove(self.get_item_by_name("Orange Tower First Floor - Shortcut to Hub Room"))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[1])
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[2])
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[3])
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[4])
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertFalse(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))

        self.collect(progressive_tower[5])
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower First Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Second Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Third Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fourth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Fifth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Sixth Floor", "Region", self.player))
        self.assertTrue(self.multiworld.state.can_reach("Orange Tower Seventh Floor", "Region", self.player))
