from ..assembler import ASM


def fixDroppedKey(rom):
    # Patch the rendering code to use the dropped key rendering code.
    rom.patch(0x03, 0x1C99, None, ASM("""
        ld   a, $04
        rst  8
        jp $5CA6
    """))

    # Patch the key pickup code to use the chest pickup code.
    rom.patch(0x03, 0x248F, None, ASM("""
        ldh  a, [$F6] ; load room nr
        cp   $7C  ; L4 Side-view room where the key drops
        jr   nz, notSpecialSideView

        ld   hl, $D969 ; status of the room above the side-view where the key drops in dungeon 4 
        set  4, [hl]
notSpecialSideView:
        call $512A ; mark room as done
        
        ; Handle item effect
        ld   a, $06 ; giveItemMultiworld
        rst  8
        
        ;Show message
        ld   a, $0A ; showMessageMultiworld
        rst  8

        ret
    """))
    rom.patch(0x03, 0x24B7, "3E", "3E")  # sanity check

    # Mark all dropped keys as keys by default.
    for n in range(0x316):
        rom.banks[0x3E][0x3800 + n] = 0x1A
    # Set the proper angler key by default
    rom.banks[0x3E][0x3800 + 0x0CE] = 0x12
    rom.banks[0x3E][0x3800 + 0x1F8] = 0x12
    # Set the proper bird key by default
    rom.banks[0x3E][0x3800 + 0x27A] = 0x14
    # Set the proper face key by default
    rom.banks[0x3E][0x3800 + 0x27F] = 0x13

    # Set the proper hookshot key by default
    rom.banks[0x3E][0x3800 + 0x180] = 0x03

    # Set the proper golden leaves
    rom.banks[0x3E][0x3800 + 0x058] = 0x15
    rom.banks[0x3E][0x3800 + 0x05a] = 0x15
    rom.banks[0x3E][0x3800 + 0x2d2] = 0x15
    rom.banks[0x3E][0x3800 + 0x2c5] = 0x15
    rom.banks[0x3E][0x3800 + 0x2c6] = 0x15

    # Set the slime key drop.
    rom.banks[0x3E][0x3800 + 0x0C6] = 0x0F

    # Set the heart pieces
    rom.banks[0x3E][0x3800 + 0x000] = 0x80
    rom.banks[0x3E][0x3800 + 0x2A4] = 0x80
    rom.banks[0x3E][0x3800 + 0x2B1] = 0x80  # fishing game, unused
    rom.banks[0x3E][0x3800 + 0x044] = 0x80
    rom.banks[0x3E][0x3800 + 0x2AB] = 0x80
    rom.banks[0x3E][0x3800 + 0x2DF] = 0x80
    rom.banks[0x3E][0x3800 + 0x2E5] = 0x80
    rom.banks[0x3E][0x3800 + 0x078] = 0x80
    rom.banks[0x3E][0x3800 + 0x2E6] = 0x80
    rom.banks[0x3E][0x3800 + 0x1E8] = 0x80
    rom.banks[0x3E][0x3800 + 0x1F2] = 0x80
    rom.banks[0x3E][0x3800 + 0x2BA] = 0x80

    # Set the seashells
    rom.banks[0x3E][0x3800 + 0x0A3] = 0x20
    rom.banks[0x3E][0x3800 + 0x2B2] = 0x20
    rom.banks[0x3E][0x3800 + 0x0A5] = 0x20
    rom.banks[0x3E][0x3800 + 0x0A6] = 0x20
    rom.banks[0x3E][0x3800 + 0x08B] = 0x20
    rom.banks[0x3E][0x3800 + 0x074] = 0x20
    rom.banks[0x3E][0x3800 + 0x0A4] = 0x20
    rom.banks[0x3E][0x3800 + 0x0D2] = 0x20
    rom.banks[0x3E][0x3800 + 0x0E9] = 0x20
    rom.banks[0x3E][0x3800 + 0x0B9] = 0x20
    rom.banks[0x3E][0x3800 + 0x0F8] = 0x20
    rom.banks[0x3E][0x3800 + 0x0A8] = 0x20
    rom.banks[0x3E][0x3800 + 0x0FF] = 0x20
    rom.banks[0x3E][0x3800 + 0x1E3] = 0x20
    rom.banks[0x3E][0x3800 + 0x0DA] = 0x20
    rom.banks[0x3E][0x3800 + 0x00C] = 0x20

    # Set heart containers
    rom.banks[0x3E][0x3800 + 0x106] = 0x89
    rom.banks[0x3E][0x3800 + 0x12B] = 0x89
    rom.banks[0x3E][0x3800 + 0x15A] = 0x89
    rom.banks[0x3E][0x3800 + 0x1FF] = 0x89
    rom.banks[0x3E][0x3800 + 0x185] = 0x89
    rom.banks[0x3E][0x3800 + 0x1BC] = 0x89
    rom.banks[0x3E][0x3800 + 0x2E8] = 0x89
    rom.banks[0x3E][0x3800 + 0x234] = 0x89

    # Toadstool
    rom.banks[0x3E][0x3800 + 0x050] = 0x50
    # Sword on beach
    rom.banks[0x3E][0x3800 + 0x0F2] = 0x0B
    # Sword upgrade
    rom.banks[0x3E][0x3800 + 0x2E9] = 0x0B

    # Songs
    rom.banks[0x3E][0x3800 + 0x092] = 0x8B # song 1
    rom.banks[0x3E][0x3800 + 0x0DC] = 0x8B # song 1
    rom.banks[0x3E][0x3800 + 0x2FD] = 0x8C # song 2
    rom.banks[0x3E][0x3800 + 0x2FB] = 0x8D # song 3

    # Instruments
    rom.banks[0x3E][0x3800 + 0x102] = 0x8E
    rom.banks[0x3E][0x3800 + 0x12a] = 0x8F
    rom.banks[0x3E][0x3800 + 0x159] = 0x90
    rom.banks[0x3E][0x3800 + 0x162] = 0x91
    rom.banks[0x3E][0x3800 + 0x182] = 0x92
    rom.banks[0x3E][0x3800 + 0x1b5] = 0x93
    rom.banks[0x3E][0x3800 + 0x22c] = 0x94
    rom.banks[0x3E][0x3800 + 0x230] = 0x95

    # Start item
    rom.banks[0x3E][0x3800 + 0x2a3] = 0x01

    # Master stalfos overkill drops
    rom.banks[0x3E][0x3800 + 0x195] = 0x1A
    rom.banks[0x3E][0x3800 + 0x192] = 0x1A
    rom.banks[0x3E][0x3800 + 0x184] = 0x1A
