from BaseClasses import Location
import typing

class AdvData(typing.NamedTuple):
    id: typing.Optional[int]
    region: str

class MomodoraAdvancement(Location):
    game: str = "MomodoraMoonlitFarewell"
    
advancement_table = {
    #Skills
    "Awakened Sacred Leaf": AdvData(20, "Springleaf Path"),
    "Sacred Anemone": AdvData(9, "Springleaf Path"),
    "Crescent Moonflower": AdvData(10, "Lun Tree Roots"),
    "Spiral Shell": AdvData(194, "Fairy Village"),
    "Lunar Attunement": AdvData(131, "Ashen Hinterlands Continued"),
    #Bosses
    "Gariser Demon": AdvData(15, "Springleaf Path"),
    "Harpy Archdemon": AdvData(17, "Springleaf Path"),
    "Raging Demon": AdvData(16, "Lun Tree Roots"),
    "Black Cat": AdvData(278, "Lun Tree Roots"),
    "Viper Archdemon Sorrellia": AdvData(150, "Fairy Springs"),
    "Remnant of an Unknown Phantasm": AdvData(171, "Moonlight Repose"),
    "Accursed Autarch": AdvData(105, "Demon Frontier"),
    "Tainted Serpent": AdvData(255, "Ashen Hinterlands Continued"),
    "Very Big Spider": AdvData(114, "Fairy Springs"),
    "Bloodthirsty Siblings": AdvData(188, "Demon Frontier Continued"),
    "Moon Goddess Lineth": AdvData(213, "Meikan Village Windmill"),
    "Selin's Fear": AdvData(259, "Fount of Rebirth"),
    "Selin's Envy": AdvData(261, "Fount of Rebirth"),
    "Selin's Mendacity": AdvData(260, "Fount of Rebirth"),
    "Selin's Sorrow": AdvData(262, "Fount of Rebirth"),
    # "Moon God Selin": AdvData(364, "Selin"),
    #Extra
    "Mitchi Fast Travel": AdvData(205, "Demon Frontier"),
    #Sigils
    "Ascended Slash": AdvData(442, "Fount of Rebirth"),
    "Cloudy Blood": AdvData(400, "Springleaf Path"),
    "Companionship Pact": AdvData(436, "Lun Tree Roots"),
    "Dark Healer": AdvData(402, "Demon Frontier Continued"),
    "Demilune Whisper": AdvData(403, "Fount of Rebirth"),
    "Glazed Aegis": AdvData(433, "Fairy Springs"),
    "Hare": AdvData(448, "Ashen Hinterlands Continued"),
    "Living Blood": AdvData(420, "Ashen Hinterlands Continued"),
    "Living Edge": AdvData(412, "Springleaf Path"),
    "Magic Blade": AdvData(404, "Demon Frontier Continued"),
    "Mending Resonance": AdvData(434, "Demon Frontier Continued"),
    "Mudwalker": AdvData(447, "Ashen Hinterlands Continued"),
    "Pawn": AdvData(440, "Lun Tree Roots"),
    "Perfect Chime": AdvData(405, "Meikan Village"),
    "Phantasm Blade": AdvData(439, "Moonlight Repose"),
    "Quintessence": AdvData(443, "Meikan Village"),
    "Resolve": AdvData(444, "Old Sanctuary Continued"),
    "Resonance of Ifriya": AdvData(425, "Fairy Springs"),
    "Serval": AdvData(445, "Ashen Hinterlands"),
    "The Arsonist": AdvData(430, "Lun Tree Roots"),
    "The Blessed": AdvData(435, "Fairy Springs"),
    "The Fortunate": AdvData(432, "Lun Tree Roots"),
    "The Hunter": AdvData(427, "Koho Village"),
    "The Sharpshooter": AdvData(438, "Old Sanctuary"),
    "Trinary": AdvData(449, "Meikan Village Windmill"),
    "Welkin Leaf": AdvData(446, "Koho Village"),
    "The Fool": AdvData(419, "Springleaf Path"),
   "Last Wish": AdvData(123, "Springleaf Path"),
   "Strongfist": AdvData(408, "Springleaf Path"),
   "Fallen Hero": AdvData(422, "Springleaf Path"),
   "The Profiteer": AdvData(401, "Springleaf Path"),
   "Chrysanth": AdvData(431, "Springleaf Path"),
    "The Collector": AdvData(426, "Springleaf Path"),
   "Queen of Dusk": AdvData(437, "Springleaf Path"),
   "Queen of Light": AdvData(406, "Springleaf Path"),
   "Oracle": AdvData(441, "Fairy Village"),
    #Grimoires
   "Grimoire": AdvData(338, "Fairy Springs"),
   "Tattered Grimoire": AdvData(339, "Meikan Village Windmill"),
   "Dusty Grimoire": AdvData(340, "Fount of Rebirth"),
   #Key Items
   "Gold Moonlit Dust": AdvData(332, "Old Sanctuary Continued"),
   "Silver Moonlit Dust": AdvData(333, "Moonlight Repose"),
   "Wooden Box": AdvData(347, "Meikan Village"),
   "Windmill Key": AdvData(356, "Meikan Village"),
    #Heavenly Lilies
   "Heavenly Lily - Koho Village": AdvData(26400, "Koho Village"),
   "Heavenly Lily 1 - Old Sanctuary": AdvData(8100, "Old Sanctuary"),
   "Heavenly Lily 2 - Old Sanctuary": AdvData(12900, "Old Sanctuary Continued"),
   "Heavenly Lily 1 - Springleaf Path": AdvData(2800, "Springleaf Path"),
   "Heavenly Lily 2 - Springleaf Path": AdvData(8400, "Springleaf Path"),
   "Heavenly Lily 1 - Lun Tree Roots": AdvData(11800, "Lun Tree Roots"),
   "Heavenly Lily 2 - Lun Tree Roots": AdvData(9400, "Lun Tree Roots"),
   "Heavenly Lily 1 - Moonlight Repose": AdvData(34400, "Moonlight Repose"),
   "Heavenly Lily 2 - Moonlight Repose": AdvData(17200, "Moonlight Repose"),
   "Heavenly Lily 1 - Fairy Springs": AdvData(3800, "Fairy Springs"),
   "Heavenly Lily 1 - Fairy Village": AdvData(34300, "Fairy Village"),
   "Heavenly Lily 2 - Fairy Village": AdvData(2300, "Fairy Village"),
   "Heavenly Lily 1 - Demon Frontier": AdvData(16900, "Demon Frontier"),
   "Heavenly Lily 2 - Demon Frontier": AdvData(15300, "Demon Frontier Continued"),
   "Heavenly Lily 3 - Demon Frontier": AdvData(16600, "Demon Frontier Continued"),
   "Heavenly Lily 1 - Ashen Hinterlands": AdvData(13000, "Ashen Hinterlands"),
   "Heavenly Lily 2 - Ashen Hinterlands": AdvData(30200, "Ashen Hinterlands Continued"),
   "Heavenly Lily 3 - Ashen Hinterlands": AdvData(24700, "Ashen Hinterlands Continued"),
   "Heavenly Lily 1 - Meikan Village": AdvData(33400, "Meikan Village"),
   "Heavenly Lily 2 - Meikan Village": AdvData(33600, "Meikan Village"),
   "Heavenly Lily 3 - Meikan Village": AdvData(33300, "Meikan Village Windmill"),
   "Heavenly Lily 1 - Fount of Rebirth": AdvData(28600, "Fount of Rebirth"),
   "Heavenly Lily 2 - Fount of Rebirth": AdvData(28500, "Fount of Rebirth"),
   "Heavenly Lily 3 - Fount of Rebirth": AdvData(32300, "Fount of Rebirth"),
   "Heavenly Lily 4 - Fount of Rebirth": AdvData(32200, "Fount of Rebirth"),
   #Dotted Berries
   "Dotted Berry 1 - Springleaf Path": AdvData(3000, "Springleaf Path"),
   "Dotted Berry 2 - Springleaf Path": AdvData(2900, "Springleaf Path"),
   "Dotted Berry 3 - Springleaf Path": AdvData(36100, "Springleaf Path"),
   "Dotted Berry 4 - Springleaf Path": AdvData(3100, "Lun Tree Roots"),
   "Dotted Berry 1 - Koho Village": AdvData(2700, "Koho Village"),
   "Dotted Berry 2 - Koho Village": AdvData(28200, "Koho Village"),
   "Dotted Berry 1 - Lun Tree Roots": AdvData(2600, "Lun Tree Roots"),
   "Dotted Berry 2 - Lun Tree Roots": AdvData(2400, "Lun Tree Roots"),
   "Dotted Berry 1 - Demon Frontier": AdvData(15200, "Demon Frontier Continued"),
   "Dotted Berry 2 - Demon Frontier": AdvData(16500, "Demon Frontier Continued"),
   "Dotted Berry - Moonlight Repose": AdvData(17400, "Moonlight Repose"),
   "Dotted Berry 1 - Fairy Springs": AdvData(11600, "Fairy Springs"),
   "Dotted Berry 2 - Fairy Springs": AdvData(3500, "Fairy Springs"),
   "Dotted Berry 3 - Fairy Springs": AdvData(8900, "Fairy Springs"),
   "Dotted Berry - Fairy Village": AdvData(14300, "Fairy Village"),
   "Dotted Berry 1 - Ashen Hinterlands": AdvData(21900, "Ashen Hinterlands"),
   "Dotted Berry 2 - Ashen Hinterlands": AdvData(24900, "Ashen Hinterlands Continued"),
   "Dotted Berry 3 - Ashen Hinterlands": AdvData(35600, "Ashen Hinterlands Continued"),
   "Dotted Berry 4 - Ashen Hinterlands": AdvData(24600, "Ashen Hinterlands Continued"),
   "Dotted Berry 1 - Meikan Village": AdvData(35900, "Meikan Village"),
   "Dotted Berry 2 - Meikan Village": AdvData(33200, "Meikan Village Windmill"),
   "Dotted Berry 3 - Meikan Village": AdvData(36000, "Meikan Village Windmill"),
   "Dotted Berry 1 - Fount of Rebirth": AdvData(34800, "Fount of Rebirth"),
   "Dotted Berry 2 - Fount of Rebirth": AdvData(34900, "Fount of Rebirth"),
   #Lun Berries
   "Lun Berry - Koho Village": AdvData(13500, "Koho Village"),
   "Lun Berry - Springleaf Path": AdvData(3300, "Springleaf Path"),
   "Lun Berry - Lun Tree Roots": AdvData(9500, "Lun Tree Roots"),
   "Lun Berry - Fairy Springs": AdvData(11500, "Fairy Springs"),
   "Lun Berry - Ashen Hinterlands": AdvData(22800, "Ashen Hinterlands Continued"),
   "Lun Berry - Demon Frontier": AdvData(29500, "Demon Frontier Continued"),
   "Lun Berry - Fount of Rebirth": AdvData(34100, "Fount of Rebirth"),
   #Stamina Berries
   "Peach - Springleaf Path": AdvData(20100, "Springleaf Path Continued"),
   "Peach - Fairy Springs": AdvData(20300, "Fairy Springs"),
   "Peach - Ashen Hinterlands": AdvData(30300, "Ashen Hinterlands Continued"),
   "Peach - Meikan Village": AdvData(33100, "Meikan Village"),
   "Peach - Moonlight Repose": AdvData(20200, "Moonlight Repose"),
   #Lumen Fairies
   "Lumen Fairy 1 - Springleaf Path": AdvData(4100, "Lun Tree Roots"),
   "Lumen Fairy 2 - Springleaf Path": AdvData(35400, "Springleaf Path"),
   "Lumen Fairy 3 - Springleaf Path": AdvData(4400, "Lun Tree Roots"),
   "Lumen Fairy 1 - Lun Tree Roots": AdvData(8700, "Lun Tree Roots"),
   "Lumen Fairy 2 - Lun Tree Roots": AdvData(5100, "Lun Tree Roots"),
   "Lumen Fairy 3 - Lun Tree Roots": AdvData(8800, "Lun Tree Roots"),
   "Lumen Fairy 1 - Demon Frontier": AdvData(35200, "Demon Frontier Continued"),
   "Lumen Fairy 2 - Demon Frontier": AdvData(35100, "Demon Frontier Continued"),
   "Lumen Fairy 3 - Demon Frontier": AdvData(16200, "Demon Frontier Continued"),
   "Lumen Fairy 4 - Lun Tree Roots": AdvData(5400, "Lun Tree Roots"),
   "Lumen Fairy - Moonlight Repose": AdvData(34600, "Moonlight Repose"),
   "Lumen Fairy 5 - Lun Tree Roots": AdvData(5700, "Lun Tree Roots"),
   "Lumen Fairy 1 - Fairy Springs": AdvData(4700, "Fairy Springs"),
   "Lumen Fairy 2 - Fairy Springs": AdvData(9300, "Fairy Springs"),
   "Lumen Fairy 3 - Fairy Springs": AdvData(13700, "Fairy Springs"),
   "Lumen Fairy 4 - Fairy Springs": AdvData(9100, "Fairy Springs"),
   "Lumen Fairy - Fairy Village": AdvData(34200, "Fairy Village"),
   "Lumen Fairy 4 - Demon Frontier": AdvData(16800, "Demon Frontier"),
   "Lumen Fairy 5 - Demon Frontier": AdvData(35500, "Demon Frontier"),
   "Lumen Fairy 1 - Ashen Hinterlands": AdvData(22100, "Ashen Hinterlands"),
   "Lumen Fairy 2 - Ashen Hinterlands": AdvData(22400, "Ashen Hinterlands Continued"),
   "Lumen Fairy 3 - Ashen Hinterlands": AdvData(22900, "Ashen Hinterlands Continued"),
   "Lumen Fairy 4 - Ashen Hinterlands": AdvData(23800, "Ashen Hinterlands Continued"),
   "Lumen Fairy 5 - Ashen Hinterlands": AdvData(35700, "Ashen Hinterlands Continued"),
   "Lumen Fairy - Meikan Village": AdvData(30000, "Meikan Village"),
   "Lumen Fairy 1 - Fount of Rebirth": AdvData(28800, "Fount of Rebirth"),
   "Lumen Fairy 2 - Fount of Rebirth": AdvData(28700, "Fount of Rebirth"),
   "Lumen Fairy 4 - Springleaf Path": AdvData(4600, "Springleaf Path"),
   "Lumen Fairy - Old Sanctuary": AdvData(35300, "Old Sanctuary Continued"),
   "Lumen Fairy - Meikan Village Windmill": AdvData(30100, "Meikan Village Windmill"),
}

exclusion_table = {
    "random_key_items": {
        "Gold Moonlit Dust",
        "Silver Moonlit Dust",
        "Windmill Key"
    },
    "oracle_sigil": {
        "Oracle"
    },
    "progressive_damage": {
        "Heavenly Lily - Koho Village",
        "Heavenly Lily 1 - Old Sanctuary",
        "Heavenly Lily 2 - Old Sanctuary",
        "Heavenly Lily 1 - Springleaf Path",
        "Heavenly Lily 2 - Springleaf Path",
        "Heavenly Lily 1 - Lun Tree Roots",
        "Heavenly Lily 2 - Lun Tree Roots",
        "Heavenly Lily 1 - Moonlight Repose",
        "Heavenly Lily 2 - Moonlight Repose",
        "Heavenly Lily 1 - Fairy Springs",
        "Heavenly Lily 2 - Fairy Springs",
        "Heavenly Lily - Fairy Village",
        "Heavenly Lily 1 - Demon Frontier",
        "Heavenly Lily 2 - Demon Frontier",
        "Heavenly Lily 3 - Demon Frontier",
        "Heavenly Lily 1 - Ashen Hinterlands",
        "Heavenly Lily 2 - Ashen Hinterlands",
        "Heavenly Lily 3 - Ashen Hinterlands",
        "Heavenly Lily 1 - Meikan Village",
        "Heavenly Lily 2 - Meikan Village",
        "Heavenly Lily 3 - Meikan Village",
        "Heavenly Lily 1 - Fount of Rebirth",
        "Heavenly Lily 2 - Fount of Rebirth",
        "Heavenly Lily 3 - Fount of Rebirth",
        "Heavenly Lily 4 - Fount of Rebirth"
    },
    "progressive_health": {
        "Dotted Berry 1 - Springleaf Path",
        "Dotted Berry 2 - Springleafh Path",
        "Dotted Berry 3 - Springleaf Path",
        "Dotted Berry 4 - Springleaf Path",
        "Dotted Berry 1 - Koho Village",
        "Dotted Berry 2 - Koho Village",
        "Dotted Berry 1 - Lun Tree Roots",
        "Dotted Berry 2 - Lun Tree Roots",
        "Dotted Berry 1 - Demon Frontier",
        "Dotted Berry 2- Demon Frontier",
        "Dotted Berry - Moonlight Repose",
        "Dotted Berry 1 - Fairy Springs",
        "Dotted Berry 2 - Fairy Springs",
        "Dotted Berry 3 - Fairy Springs",
        "Dotted Berry - Fairy Village",
        "Dotted Berry 1 - Ashen Hinterlands",
        "Dotted Berry 2 - Ashen Hinterlands",
        "Dotted Berry 3 - Ashen Hinterlands",
        "Dotted Berry 4 - Ashen Hinterlands",
        "Dotted Berry 1 - Meikan Village",
        "Dotted Berry 2 - Meikan Village",
        "Dotted Berry 1 - Fount of Rebirth",
        "Dotted Berry 2 - Fount of Rebirth",
        "Dotted Berry 3 - Fount of Rebirth"
    },
    "progressive_Lun": {
        "Lun Berry - Koho Village",
        "Lun Berry - Springleaf Path",
        "Lun Berry - Lun Tree Roots",
        "Lun Berry - Fairy Springs",
        "Lun Berry - Ashen Hinterlands",
        "Lun Berry - Demon Frontier",
        "Lun Berry - Fount of Rebirth"
    },
    "progressive_stamina": {
        "Peach - Springleaf Path",
        "Peach - Fairy Springs",
        "Peach - Ashen Hinterlands",
        "Peach - Meikan Village",
        "Peach - Moonlight Repose"
    },
    "progressive_fairy": {
        "Lumen Fairy 1 - Springleaf Path",
        "Lumen Fairy 2 - Springleaf Path",
        "Lumen Fairy 3 - Springleaf Path",
        "Lumen Fairy 1 - Lun Tree Roots",
        "Lumen Fairy 2 - Lun Tree Roots",
        "Lumen Fairy 3 - Lun Tree Roots",
        "Lumen Fairy 1 - Demon Frontier",
        "Lumen Fairy 2 - Demon Frontier",
        "Lumen Fairy 3 - Demon Frontier",
        "Lumen Fairy 4 - Lun Tree Roots",
        "Lumen Fairy - Moonlight Repose",
        "Lumen Fairy 1 - Fairy Springs",
        "Lumen Fairy 2 - Fairy Springs",
        "Lumen Fairy 3 - Fairy Springs",
        "Lumen Fairy 4 - Fairy Springs",
        "Lumen Fairy 5 - Fairy Springs",
        "Lumen Fairy - Fairy Village",
        "Lumen Fairy 4 - Demon Frontier",
        "Lumen Fairy 1 - Ashen Hinterlands",
        "Lumen Fairy 2 - Ashen Hinterlands",
        "Lumen Fairy 3 - Ashen Hinterlands",
        "Lumen Fairy 4 - Ashen Hinterlands",
        "Lumen Fairy 5 - Ashen Hinterlands",
        "Lumen Fairy 6 - Ashen Hinterlands",
        "Lumen Fairy - Meikan Village",
        "Lumen Fairy 1 - Fount of Rebirth",
        "Lumen Fairy 2 - Fount of Rebirth",
        "Lumen Fairy 4 - Springleaf Path",
        "Lumen Fairy - Old Sanctuary",
        "Lumen Fairy - Meikan Village Windmill"
    },
    "progressive_magic": {
        "Lun Berry - Koho Village",
   "Lun Berry - Springleaf Path",
   "Lun Berry - Lun Tree Roots",
   "Lun Berry - Fairy Springs",
   "Lun Berry - Ashen Hinterlands",
   "Lun Berry - Demon Frontier",
   "Lun Berry - Fount of Rebirth"
    }
}