"""Stores the data for the locations of colored bananas and balloons in Angry Aztec."""

from randomizer.Enums.Events import Events
from randomizer.Enums.Kongs import Kongs
from randomizer.Enums.Levels import Levels
from randomizer.Enums.Regions import Regions
from randomizer.Enums.Maps import Maps
from randomizer.Enums.Settings import DamageAmount
from randomizer.Enums.Switches import Switches
from randomizer.LogicClasses import Balloon, ColoredBananaGroup

ColoredBananaGroupList = [
    ColoredBananaGroup(
        group=1,
        map_id=Maps.AngryAztec,
        name="At DK Portal before W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecStart,
        logic=lambda l: l.can_use_vines,
        locations=[
            [1, 1.0, 792, 120, 223],
            [1, 1.0, 794, 120, 318],
            [1, 1.0, 796, 120, 409],
            [1, 1.0, 795, 160, 533],
            [1, 1.0, 795, 160, 640],
        ],
    ),
    ColoredBananaGroup(
        group=2,
        map_id=Maps.AngryAztec,
        name="First tunnel (5 custom, 5 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        locations=[
            [1, 1.0, 803, 120, 759],
            [1, 1.0, 812, 120, 948],
            [1, 1.0, 846, 120, 1118],
            [1, 1.0, 966, 120, 1199],
            [1, 1.0, 820.9889526367188, 120.0, 1033.1551513671875],
            [1, 1.0, 899.3162231445312, 120.0, 1168.6141357421875],
            [1, 1.0, 809.063720703125, 120.0, 849.666748046875],
            [1, 1.0, 1054.1512451171875, 120.0, 1204.6153564453125],
            [1, 1.0, 799.9443359375, 120.0, 688.669921875],
        ],
    ),
    ColoredBananaGroup(
        group=2,
        map_id=Maps.AngryAztec,
        name="First tunnel (5 custom, 5 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        logic=lambda l: l.can_use_vines,
        locations=[
            [1, 1.0, 1173, 155, 1204],
        ],
    ),
    ColoredBananaGroup(
        group=3,
        map_id=Maps.AngryAztec,
        name="On DK BP archway",
        konglist=[Kongs.donkey],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.AztecBlueprintDoor, False) and l.strongKong,
        locations=[
            [1, 1.0, 1527, 120, 738],
            [1, 1.0, 1487, 126, 740],
            [1, 1.0, 1458, 141, 737],
            [1, 1.0, 1421, 157, 735],
            [1, 1.0, 1384, 163, 738],
            [1, 1.0, 1341, 159, 739],
            [1, 1.0, 1310, 149, 740],
            [1, 1.0, 1291, 138, 741],
            [1, 1.0, 1262, 124, 741],
            [1, 1.0, 1211, 120, 743],
        ],
    ),
    ColoredBananaGroup(
        group=4,
        map_id=Maps.AngryAztec,
        name="First tunnel (5 custom, 5 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 1413, 120, 1183],
            [1, 1.0, 1613, 120, 1153],
            [1, 1.0, 1738, 120, 1006],
            [1, 1.0, 1894, 120, 888],
            [1, 1.0, 2088, 120, 882],
            [1, 1.0, 2004.1719970703125, 120.0, 883.0906372070312],
            [1, 1.0, 1788.1475830078125, 120.0, 919.0678100585938],
            [1, 1.0, 1705.0576171875, 120.0, 1074.099365234375],
            [1, 1.0, 1526.3450927734375, 120.0, 1170.8824462890625],
            [1, 1.0, 1309.9158935546875, 120.0, 1191.4840087890625],
        ],
    ),
    ColoredBananaGroup(
        group=5,
        map_id=Maps.AngryAztec,
        name="Singles all around oasis (17 custom, 3 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 2358, 139, 1373],
            [1, 1.0, 2400, 120, 1305],
            [1, 1.0, 2497, 120, 1308],
            [1, 1.0, 2600, 120, 1285],
            [1, 1.0, 2679, 120, 1225],
            [1, 1.0, 2739, 120, 1105],
            [1, 1.0, 2772, 124, 1012],
            [1, 1.0, 2765, 134, 918],
            [1, 1.0, 2704, 134, 835],
            [1, 1.0, 2628, 120, 788],
            [1, 1.0, 2553, 120, 756],
            [1, 1.0, 2470, 120, 738],
            [1, 1.0, 2396, 120, 740],
            [1, 1.0, 2300, 120, 755],
            [1, 1.0, 2213, 120, 796],
            [1, 1.0, 2177, 120, 869],
            [1, 1.0, 2189, 120, 951],
            [1, 1.0, 2217.103759765625, 216.9842987060547, 1492.6387939453125],
            [1, 1.0, 2258.889404296875, 184.58831787109375, 1454.10888671875],
            [1, 1.0, 2303.343017578125, 153.5, 1413.4552001953125],
        ],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.AngryAztec,
        name="Singles on vines and bunch on guitar pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.can_use_vines,
        locations=[
            [1, 1.2, 2450, 310, 1126],
            [1, 1.2, 2380, 325, 1226],
            [1, 1.2, 2309, 335, 1323],
            [1, 1.2, 2238, 345, 1421],
            [1, 1.2, 2171, 350, 1517],
            [5, 1.0, 2134, 326, 1556],
        ],
    ),
    ColoredBananaGroup(
        group=7,
        map_id=Maps.AngryAztec,
        name="Around llama cage (upper)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 2205, 217, 1535],
            [1, 1.0, 2175, 217, 1501],
            [1, 1.0, 2130, 217, 1455],
            [1, 1.0, 2083, 217, 1495],
            [1, 1.0, 2028, 217, 1546],
            [1, 1.0, 2058, 217, 1580],
            [1, 1.0, 2085, 217, 1613],
            [1, 1.0, 2138, 217, 1669],
            [1, 1.0, 2189, 217, 1621],
            [1, 1.0, 2242, 217, 1572],
        ],
    ),
    ColoredBananaGroup(
        group=8,
        map_id=Maps.AngryAztec,
        name="Around llama cage (lower)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 2151, 154, 1336],
            [1, 1.0, 2101, 154, 1382],
            [1, 1.0, 2051, 154, 1428],
            [1, 1.0, 2001, 154, 1474],
            [1, 1.0, 1951, 154, 1520],
            [1, 1.0, 1964, 154, 1571],
            [1, 1.0, 2004, 154, 1617],
            [1, 1.0, 2044, 154, 1663],
            [1, 1.0, 2084, 154, 1709],
            [1, 1.0, 2124, 154, 1755],
            [1, 1.0, 2163, 154, 1761],
            [1, 1.0, 2212, 154, 1713],
            [1, 1.0, 2261, 154, 1666],
            [1, 1.0, 2311, 154, 1618],
            [1, 1.0, 2360, 154, 1570],
        ],
    ),
    ColoredBananaGroup(
        group=9,
        map_id=Maps.AngryAztec,
        name="Bunches on each side of the Tiny Temple door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[[5, 1.0, 3110, 220, 783], [5, 1.0, 3027, 220, 672]],
    ),
    ColoredBananaGroup(
        group=10,
        map_id=Maps.AngryAztec,
        name="Around Tiny Temple (on temple)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 3139, 215, 873],
            [1, 1.0, 3188, 215, 837],
            [1, 1.0, 3238, 214, 799],
            [1, 1.0, 3288, 214, 761],
            [1, 1.0, 3338, 214, 723],
            [1, 1.0, 3388, 213, 685],
            [1, 1.0, 3349, 213, 633],
            [1, 1.0, 3311, 213, 583],
            [1, 1.0, 3273, 213, 533],
            [1, 1.0, 3235, 213, 483],
            [1, 1.0, 3197, 213, 433],
            [1, 1.0, 3146, 214, 470],
            [1, 1.0, 3096, 214, 507],
            [1, 1.0, 3046, 214, 544],
            [1, 1.0, 2996, 215, 581],
            [1, 1.0, 2946, 215, 618],
            [1, 1.0, 2985, 215, 669],
            [1, 1.0, 3023, 215, 720],
            [1, 1.0, 3062, 215, 771],
            [1, 1.0, 3100, 215, 822],
        ],
    ),
    ColoredBananaGroup(
        group=11,
        map_id=Maps.AngryAztec,
        name="Singles around Diddy BP",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 3168, 446, 661],
            [1, 1.0, 3146, 446, 637],
            [1, 1.0, 3134, 446, 615],
            [1, 1.0, 3115, 446, 646],
            [1, 1.0, 3125, 446, 686],
            [1, 1.0, 3159, 446, 703],
            [1, 1.0, 3198, 446, 692],
            [1, 1.0, 3218, 446, 657],
            [1, 1.0, 3207, 446, 617],
            [1, 1.0, 3174, 446, 597],
        ],
    ),
    ColoredBananaGroup(
        group=12,
        map_id=Maps.AngryAztec,
        name="4 corners of top of Tiny Temple",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.jetpack and l.isdiddy and l.climbing,
        locations=[
            [5, 1.0, 3186, 357, 487],
            [5, 1.0, 3007, 357, 625],
            [5, 1.0, 3140, 357, 814],
            [5, 1.0, 3330, 357, 679],
        ],
    ),
    ColoredBananaGroup(
        group=13,
        map_id=Maps.AngryAztec,
        name="In front of Candy's",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 2254, 120, 523],
            [1, 1.0, 2308, 120, 553],
            [1, 1.0, 2368, 120, 550],
            [1, 1.0, 2419, 120, 555],
            [1, 1.0, 2474, 120, 526],
        ],
    ),
    ColoredBananaGroup(
        group=14,
        map_id=Maps.AngryAztec,
        name="Bunches on W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        locations=[[5, 1.0, 805, 134, 786]],
    ),
    ColoredBananaGroup(
        group=14,
        map_id=Maps.AngryAztec,
        name="Bunches on W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[[5, 1.0, 2366, 134, 754]],
    ),
    ColoredBananaGroup(
        group=15,
        map_id=Maps.AngryAztec,
        name="Second tunnel (5 custom, 5 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3172, 120, 1855],
            [1, 1.0, 3025, 120, 1834],
            [1, 1.0, 2853, 120, 1811],
            [1, 1.0, 2754, 120, 1739],
            [1, 1.0, 2693, 120, 1600],
            [1, 1.0, 2713.503173828125, 120.5, 1681.6962890625],
            [1, 1.0, 2793.257568359375, 120.0, 1784.77734375],
            [1, 1.0, 2920.335693359375, 120.0, 1821.37646484375],
            [1, 1.0, 2681.131591796875, 120.5, 1507.88427734375],
            [1, 1.0, 3085.650390625, 120.0, 1837.69921875],
        ],
    ),
    ColoredBananaGroup(
        group=16,
        map_id=Maps.AngryAztec,
        name="Bunch on boulder switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 3273, 145, 1831]],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.AngryAztec,
        name="Snake path to Cranky (5 custom, 5 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3268, 124, 2150],
            [1, 1.0, 3290, 124, 2343],
            [1, 1.0, 3096, 120, 2303],
            [1, 1.0, 3000, 132, 2392],
            [1, 1.0, 2958, 120, 2516],
            [1, 1.0, 3263.973876953125, 126.5, 2225.697021484375],
            [1, 1.0, 3183.652587890625, 130.8333282470703, 2364.818359375],
            [1, 1.0, 2863.939697265625, 121.46724700927734, 2532.964111328125],
            [1, 1.0, 3034.802978515625, 138.66746520996094, 2342.236572265625],
            [1, 1.0, 2970.402099609375, 138.5740966796875, 2443.052978515625],
        ],
    ),
    ColoredBananaGroup(
        group=18,
        map_id=Maps.AngryAztec,
        name="Bunches next to Cranky (1 custom, 1 Lanky bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 2750, 120, 2448], [5, 1.0, 2766.474853515625, 120.0, 2627.5556640625]],
    ),
    ColoredBananaGroup(
        group=19,
        map_id=Maps.AngryAztec,
        name="W2 bunches (1 custom, 1 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 3502, 134, 3071]],
    ),
    ColoredBananaGroup(
        group=19,
        map_id=Maps.AngryAztec,
        name="W2 bunches (1 custom, 1 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[[5, 1.0, 2883.7001953125, 178.3626251220703, 862.9205932617188]],
    ),
    ColoredBananaGroup(
        group=20,
        map_id=Maps.AngryAztec,
        name="Bunches on W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 2802, 134, 2523], [5, 1.0, 3501, 135, 3397]],
    ),
    ColoredBananaGroup(
        group=21,
        map_id=Maps.AngryAztec,
        name="Second tunnel from boulder pad to Chunky BB (5 custom, 5 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3394, 120, 1833],
            [1, 1.0, 3599, 120, 1845],
            [1, 1.0, 3707, 120, 1931],
            [1, 1.0, 3761, 120, 2103],
            [1, 1.0, 3785, 120, 2280],
            [1, 1.0, 3772.267578125, 120.0, 2183.286376953125],
            [1, 1.0, 3796.0478515625, 120.0, 2392.750244140625],
            [1, 1.0, 3501.267333984375, 120.0, 1834.76220703125],
            [1, 1.0, 3662.4609375, 120.0, 1877.7689208984375],
            [1, 1.0, 3738.749755859375, 120.0, 2011.7176513671875],
        ],
    ),
    ColoredBananaGroup(
        group=22,
        map_id=Maps.AngryAztec,
        name="Second tunnel from Chunky BB to far W2 (5 custom, 5 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3796, 120, 2503],
            [1, 1.0, 3791, 120, 2692],
            [1, 1.0, 3719, 120, 2836],
            [1, 1.0, 3564, 120, 2908],
            [1, 1.0, 3497, 127, 3204],
            [1, 1.0, 3653.9384765625, 120.0, 2877.985107421875],
            [1, 1.0, 3796.436279296875, 120.0, 2604.010498046875],
            [1, 1.0, 3500.145751953125, 120.0, 3123.678955078125],
            [1, 1.0, 3526.870361328125, 120.0, 2973.667724609375],
            [1, 1.0, 3765.875, 120.0, 2778.8388671875],
        ],
    ),
    ColoredBananaGroup(
        group=23,
        map_id=Maps.AngryAztec,
        name="Near far W2 (2 custom, 3 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3519, 120, 3440],
            [1, 1.0, 3740, 190, 3563],
            [1, 1.0, 3674.507568359375, 184.8333282470703, 3528.693359375],
            [1, 1.0, 3623.139404296875, 157.0, 3496.70703125],
            [1, 1.0, 3571.0009765625, 125.66666412353516, 3465.210205078125],
        ],
    ),
    ColoredBananaGroup(
        group=24,
        map_id=Maps.AngryAztec,
        name="Flying bunches around totem (scale up a bit)",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.2, 3498, 310, 3920],
            [5, 1.2, 3390, 310, 3538],
            [5, 1.2, 3023, 310, 3742],
            [5, 1.2, 3207, 310, 4080],
        ],
    ),
    ColoredBananaGroup(
        group=25,
        map_id=Maps.AngryAztec,
        name="Around totem Llama temple/5DT side (8 custom, 7 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3354, 80, 3591],
            [1, 1.0, 3241, 80, 3581],
            [1, 1.0, 3110, 80, 3611],
            [1, 1.0, 3015, 92, 3716],
            [1, 1.0, 2992, 80, 3816],
            [1, 1.0, 2991, 80, 3875],
            [1, 1.0, 3019, 80, 3953],
            [1, 1.0, 3048, 80, 4000],
            [1, 1.0, 3413.599853515625, 80.0, 3598.340087890625],
            [1, 1.0, 3181.684326171875, 80.0, 3595.064453125],
            [1, 1.0, 3064.436767578125, 80.0, 3650.390380859375],
            [1, 1.0, 3003.218505859375, 80.0, 3776.413330078125],
            [1, 1.0, 3007.093994140625, 80.0, 3906.975341796875],
            [1, 1.0, 3080.368408203125, 80.0, 4015.803955078125],
            [1, 1.0, 3299.246337890625, 80.0, 3582.6044921875],
        ],
    ),
    ColoredBananaGroup(
        group=26,
        map_id=Maps.AngryAztec,
        name="Around totem Snide's side (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3474, 80, 4032],
            [1, 1.0, 3551, 80, 3912],
            [1, 1.0, 3557.454833984375, 80.0, 3856.137939453125],
            [1, 1.0, 3519.805419921875, 80.0, 3976.166015625],
            [1, 1.0, 3397.266845703125, 80.0, 4053.25390625],
        ],
    ),
    ColoredBananaGroup(
        group=27,
        map_id=Maps.AngryAztec,
        name="Top of ramps by tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 4321, 160, 3377], [5, 1.0, 4245, 160, 3333]],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.AngryAztec,
        name="Bunch on trees between Snide's and Beetle Race tower (1 custom, 2 Lanky bunches)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[
            [5, 1.0, 3829, 315, 4198],
            [5, 1.0, 3749.179443359375, 340.0, 3823.531982421875],
            [5, 1.0, 4066.069091796875, 340.0, 3560.012451171875],
        ],
    ),
    ColoredBananaGroup(
        group=29,
        map_id=Maps.AngryAztec,
        name="Around Snide's HQ platform edge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 4026, 120, 4282],
            [1, 1.0, 3972, 120, 4337],
            [1, 1.0, 3932, 120, 4388],
            [1, 1.0, 3931, 120, 4461],
            [1, 1.0, 3922, 120, 4536],
        ],
    ),
    ColoredBananaGroup(
        group=30,
        map_id=Maps.AngryAztec,
        name="To Diddy's Tower GB (4 custom, 6 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 4133, 120, 3829],
            [1, 1.0, 4127, 120, 3760],
            [1, 1.0, 4116, 120, 3706],
            [1, 1.0, 4084, 120, 3639],
            [1, 1.0, 4015.576171875, 180.0, 4111.86083984375],
            [1, 1.0, 4038.828125, 150.0, 4164.64404296875],
            [1, 1.0, 4061.7958984375, 125.0, 4210.109375],
            [1, 1.0, 4027.203857421875, 185.0, 3982.434814453125],
            [1, 1.0, 4061.217041015625, 155.0, 3934.0517578125],
            [1, 1.0, 4098.84033203125, 125.0, 3883.869140625],
        ],
    ),
    ColoredBananaGroup(
        group=31,
        map_id=Maps.AngryAztec,
        name="Near Beetle Race Tower (2 custom, 3 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 4200, 80, 3500],
            [1, 1.0, 4313, 140, 3307],
            [1, 1.0, 4257.48388671875, 105.66666412353516, 3402.546875],
            [1, 1.0, 4286.78173828125, 135.5, 3354.001953125],
            [1, 1.0, 4228.79833984375, 80.5, 3447.271240234375],
        ],
    ),
    ColoredBananaGroup(
        group=32,
        map_id=Maps.AngryAztec,
        name="15 singles around Beetle Race Tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 4096, 80, 3259],
            [1, 1.0, 4141, 80, 3180],
            [1, 1.0, 4187, 80, 3101],
            [1, 1.0, 4232, 80, 3021],
            [1, 1.0, 4277, 80, 2942],
            [1, 1.0, 4340, 80, 2924],
            [1, 1.0, 4412, 80, 2968],
            [1, 1.0, 4485, 80, 3012],
            [1, 1.0, 4557, 80, 3056],
            [1, 1.0, 4630, 80, 3100],
            [1, 1.0, 4648, 80, 3146],
            [1, 1.0, 4602, 80, 3225],
            [1, 1.0, 4557, 80, 3304],
            [1, 1.0, 4511, 80, 3383],
            [1, 1.0, 4465, 80, 3462],
        ],
    ),
    ColoredBananaGroup(
        group=33,
        map_id=Maps.AngryAztec,
        name="From Snide's Tag to W5 T&S (7 custom, 3 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3472, 120, 4402],
            [1, 1.0, 3506, 120, 4332],
            [1, 1.0, 3553, 120, 4273],
            [1, 1.0, 3605, 120, 4207],
            [1, 1.0, 3650, 120, 4138],
            [1, 1.0, 3683, 120, 4067],
            [1, 1.0, 3747, 120, 4005],
            [1, 1.0, 3903.120849609375, 181.0, 4028.453125],
            [1, 1.0, 3848.7021484375, 152.0, 4021.802734375],
            [1, 1.0, 3793.945068359375, 127.0, 4013.8681640625],
        ],
    ),
    ColoredBananaGroup(
        group=34,
        map_id=Maps.AngryAztec,
        name="Bunches around the feed me totem",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 3208, 102, 3839], [5, 1.0, 3343, 102, 3840]],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.AngryAztec,
        name="Bunches on W4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 3411, 136, 3381], [5, 1.0, 2918, 134, 4421]],
    ),
    ColoredBananaGroup(
        group=36,
        map_id=Maps.AngryAztec,
        name="W5 bunches (1 custom, 1 Tiny bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AztecDonkeyQuicksandCave,
        locations=[[5, 1.0, 2778, 135, 4752]],
    ),
    ColoredBananaGroup(
        group=36,
        map_id=Maps.AngryAztec,
        name="W5 bunches (1 custom, 1 Tiny bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 3480.918212890625, 140.0, 4486.7548828125]],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.AngryAztec,
        name="Around Llama temple",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3053, 220, 3073],
            [1, 1.0, 3100, 220, 3062],
            [1, 1.0, 3078, 220, 2978],
            [1, 1.0, 3053, 220, 2883],
            [1, 1.0, 3034, 220, 2817],
            [1, 1.0, 3016, 220, 2732],
            [1, 1.0, 2942, 220, 2746],
            [1, 1.0, 2866, 220, 2770],
            [1, 1.0, 2769, 220, 2792],
            [1, 1.0, 2684, 220, 2817],
            [1, 1.0, 2704, 220, 2895],
            [1, 1.0, 2726, 220, 2974],
            [1, 1.0, 2749, 220, 3061],
            [1, 1.0, 2770, 220, 3149],
            [1, 1.0, 2825, 220, 3135],
        ],
    ),
    ColoredBananaGroup(
        group=38,
        map_id=Maps.AngryAztec,
        name="Llama temple stairs (1 custom, 4 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 2920, 250, 3052],
            [1, 1.0, 2933.3466796875, 238.5, 3099.868896484375],
            [1, 1.0, 2945.967529296875, 218.0, 3143.0751953125],
            [1, 1.0, 2956.460205078125, 194.0, 3187.922607421875],
            [1, 1.0, 2970.1953125, 165.0, 3238.345703125],
        ],
    ),
    ColoredBananaGroup(
        group=39,
        map_id=Maps.AngryAztec,
        name="On each side of the Llama temple stairs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 2887, 265, 3096], [5, 1.0, 2974, 265, 3074]],
    ),
    ColoredBananaGroup(
        group=40,
        map_id=Maps.AngryAztec,
        name="On top of Diddy's Feed me totem switch on 5DT",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 2074, 435, 3610]],
    ),
    ColoredBananaGroup(
        group=41,
        map_id=Maps.AngryAztec,
        name="5DT side (1 custom, 4 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 1885, 180, 3984],
            [1, 1.0, 1985.4559326171875, 278.0, 3783.59375],
            [1, 1.0, 1956.5284423828125, 244.0, 3839.664794921875],
            [1, 1.0, 1930.3563232421875, 213.0, 3887.709228515625],
            [1, 1.0, 1904.8350830078125, 185.0, 3946.1298828125],
        ],
    ),
    ColoredBananaGroup(
        group=42,
        map_id=Maps.AngryAztec,
        name="Around 5DT bottom ledge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 2215, 180, 3729],
            [1, 1.0, 2173, 180, 3803],
            [1, 1.0, 2136, 180, 3878],
            [1, 1.0, 2052, 180, 3830],
            [1, 1.0, 2006, 180, 3926],
            [1, 1.0, 1955, 180, 4016],
            [1, 1.0, 1813, 180, 3944],
            [1, 1.0, 1856, 180, 3854],
            [1, 1.0, 1905, 180, 3758],
            [1, 1.0, 1814, 180, 3711],
            [1, 1.0, 1860, 180, 3623],
            [1, 1.0, 1906, 180, 3534],
            [1, 1.0, 1952, 180, 3445],
            [1, 1.0, 1998, 180, 3356],
            [1, 1.0, 2079, 180, 3396],
            [1, 1.0, 2159, 180, 3437],
            [1, 1.0, 2239, 180, 3477],
            [1, 1.0, 2320, 180, 3517],
            [1, 1.0, 2289, 180, 3588],
            [1, 1.0, 2255, 180, 3653],
        ],
    ),
    ColoredBananaGroup(
        group=43,
        map_id=Maps.AngryAztec,
        name="Around 5DT top ledge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 2123, 280, 3823],
            [1, 1.0, 2039, 280, 3780],
            [1, 1.0, 1954, 280, 3737],
            [1, 1.0, 1869, 280, 3693],
            [1, 1.0, 1898, 280, 3636],
            [1, 1.0, 1928, 280, 3579],
            [1, 1.0, 1957, 280, 3523],
            [1, 1.0, 1987, 280, 3466],
            [1, 1.0, 2016, 280, 3409],
            [1, 1.0, 2100, 280, 3452],
            [1, 1.0, 2184, 280, 3494],
            [1, 1.0, 2269, 280, 3536],
            [1, 1.0, 2233, 280, 3607],
            [1, 1.0, 2197, 280, 3679],
            [1, 1.0, 2160, 280, 3751],
        ],
    ),
    ColoredBananaGroup(
        group=44,
        map_id=Maps.AngryAztec,
        name="Bunches on patch of sand between Llama temple and W2-3-4 (accessible by jumping from nearby tree)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 3315, 268, 3168], [5, 1.0, 3369, 283, 3114]],
    ),
    ColoredBananaGroup(
        group=47,
        map_id=Maps.AngryAztec,
        name="Bunches on 4 corners of Chunky BB cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [5, 1.0, 4186, 156, 2463],
            [5, 1.0, 4296, 156, 2463],
            [5, 1.0, 4296, 156, 2353],
            [5, 1.0, 4185, 156, 2353],
        ],
    ),
    ColoredBananaGroup(
        group=48,
        map_id=Maps.AngryAztec,
        name="Bunches on top of Chunky BB cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 4236, 206, 2432], [5, 1.0, 4236, 206, 2384]],
    ),
    ColoredBananaGroup(
        group=49,
        map_id=Maps.AngryAztec,
        name="Along the walls around Chunky BB cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3990, 120, 2296],
            [1, 1.0, 4048, 120, 2244],
            [1, 1.0, 4116, 120, 2217],
            [1, 1.0, 4186, 120, 2217],
            [1, 1.0, 4264, 120, 2221],
            [1, 1.0, 4331, 120, 2237],
            [1, 1.0, 4393, 120, 2285],
            [1, 1.0, 4450, 120, 2356],
            [1, 1.0, 4454, 120, 2449],
            [1, 1.0, 4397, 120, 2524],
            [1, 1.0, 4332, 120, 2567],
            [1, 1.0, 4261, 120, 2589],
            [1, 1.0, 4161, 120, 2598],
            [1, 1.0, 4063, 120, 2574],
            [1, 1.0, 3993, 120, 2519],
        ],
    ),
    ColoredBananaGroup(
        group=50,
        map_id=Maps.AngryAztec,
        name="Inside giant boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.chunky and l.hunkyChunky and l.barrels,
        locations=[[5, 1.0, 3585, 118, 2406]],
    ),
    ColoredBananaGroup(
        group=51,
        map_id=Maps.AngryAztec,
        name="Bunches on each side of Funky's",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 1.0, 3000, 126, 4538], [5, 1.0, 2806, 126, 4495]],
    ),
    ColoredBananaGroup(
        group=52,
        map_id=Maps.AngryAztec,
        name="Singles up the stairs between Funky and Llama temple",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3060, 120, 4311],
            [1, 1.0, 2955, 120, 4289],
            [1, 1.0, 2882, 120, 4195],
            [1, 1.0, 2839, 120, 4140],
            [1, 1.0, 2809, 120, 4090],
            [1, 1.0, 2782, 120, 4034],
            [1, 1.0, 2779, 120, 3936],
            [1, 1.0, 2798, 120, 3857],
            [1, 1.0, 2820, 120, 3783],
            [1, 1.0, 2837, 120, 3725],
        ],
    ),
    ColoredBananaGroup(
        group=53,
        map_id=Maps.AngryAztec,
        name="Singles up the stairs between Llama Temple and W2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3488, 128, 3264],
            [1, 1.0, 3462, 126, 3370],
            [1, 1.0, 3375, 120, 3437],
            [1, 1.0, 3275, 120, 3417],
            [1, 1.0, 3190, 120, 3402],
            [1, 1.0, 3096, 120, 3414],
            [1, 1.0, 3020, 120, 3458],
            [1, 1.0, 2967, 120, 3500],
            [1, 1.0, 2890, 120, 3540],
            [1, 1.0, 2825, 120, 3619],
        ],
    ),
    ColoredBananaGroup(
        group=54,
        map_id=Maps.AngryAztec,
        name="Around W5 near bonus barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AztecDonkeyQuicksandCave,
        locations=[
            [1, 1.0, 2747, 120, 4748],
            [1, 1.0, 2775, 120, 4715],
            [1, 1.0, 2818, 120, 4735],
            [1, 1.0, 2808, 120, 4777],
            [1, 1.0, 2762, 120, 4784],
        ],
    ),
    ColoredBananaGroup(
        group=55,
        map_id=Maps.AztecDonkey5DTemple,
        name="First dead end",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTempleDeadEndRight,
        locations=[[5, 1.0, 140, 25, 500], [5, 1.0, 64, 25, 500]],
    ),
    ColoredBananaGroup(
        group=56,
        map_id=Maps.AztecDonkey5DTemple,
        name="Second dead end",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTemple,
        logic=lambda l: (l.coconut and l.isdonkey) or l.CanPhase(),
        locations=[[5, 1.0, 1046, 62, 1082]],
    ),
    ColoredBananaGroup(
        group=57,
        map_id=Maps.AztecDonkey5DTemple,
        name="Path to GB",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTemple,
        logic=lambda l: (l.coconut and l.isdonkey) or l.CanPhase(),
        locations=[
            [1, 1.0, 520, 20, 300],
            [1, 1.0, 620, 20, 300],
            [1, 1.0, 720, 20, 300],
            [1, 1.0, 720, 20, 400],
            [1, 1.0, 720, 29, 463],
            [1, 1.0, 720, 49, 504],
            [1, 1.0, 720, 58, 560],
            [1, 1.0, 720, 58, 846],
            [1, 1.0, 720, 58, 733],
            [1, 1.0, 720, 58, 820],
            [1, 1.0, 620, 58, 820],
            [1, 1.0, 520, 58, 820],
            [1, 1.0, 420, 58, 820],
            [1, 1.0, 420, 58, 908],
            [1, 1.0, 420, 67, 978],
            [1, 1.0, 420, 86, 1017],
        ],
    ),
    ColoredBananaGroup(
        group=57,
        map_id=Maps.AztecDonkey5DTemple,
        name="Path to GB",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTemple,
        locations=[[1, 1.0, 420, 20, 100], [1, 1.0, 420, 20, 166], [1, 1.0, 420, 20, 233], [1, 1.0, 420, 20, 300]],
    ),
    ColoredBananaGroup(
        group=58,
        map_id=Maps.AztecDiddy5DTemple,
        name="Path to GB",
        konglist=[Kongs.diddy],
        region=Regions.DiddyTemple,
        logic=lambda l: l.peanut,
        locations=[
            [1, 1.0, 640, 20, 300],
            [1, 1.0, 540, 20, 300],
            [1, 1.0, 440, 20, 300],
            [1, 1.0, 440, 20, 400],
            [1, 1.0, 440, 29, 463],
            [1, 1.0, 440, 49, 504],
            [1, 1.0, 440, 58, 560],
            [1, 1.0, 440, 58, 846],
            [1, 1.0, 440, 58, 733],
            [1, 1.0, 440, 58, 820],
            [1, 1.0, 540, 58, 820],
            [1, 1.0, 640, 58, 820],
            [1, 1.0, 740, 58, 820],
            [1, 1.0, 740, 58, 908],
            [1, 1.0, 740, 67, 978],
            [1, 1.0, 740, 86, 1017],
        ],
    ),
    ColoredBananaGroup(
        group=58,
        map_id=Maps.AztecDiddy5DTemple,
        name="Path to GB",
        konglist=[Kongs.diddy],
        region=Regions.DiddyTemple,
        locations=[[1, 1.0, 740, 20, 100], [1, 1.0, 740, 20, 166], [1, 1.0, 740, 20, 233], [1, 1.0, 740, 20, 300]],
    ),
    ColoredBananaGroup(
        group=59,
        map_id=Maps.AztecDiddy5DTemple,
        name="Second dead end",
        konglist=[Kongs.diddy],
        region=Regions.DiddyTempleDeadEndRight,
        locations=[[5, 1.0, 155, 62, 1013], [5, 1.0, 73, 62, 1013]],
    ),
    ColoredBananaGroup(
        group=60,
        map_id=Maps.AztecDiddy5DTemple,
        name="First dead end",
        konglist=[Kongs.diddy],
        region=Regions.DiddyTemple,
        logic=lambda l: l.peanut or l.CanPhase(),
        locations=[[5, 1.0, 1015, 25, 500], [5, 1.0, 1097, 25, 500]],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.AztecLanky5DTemple,
        name="Path to GB",
        konglist=[Kongs.lanky],
        region=Regions.LankyTemple,
        locations=[
            [1, 1.0, 370, 20, 320],
            [1, 1.0, 280, 20, 320],
            [1, 1.0, 190, 20, 320],
            [1, 1.0, 550, 20, 320],
            [1, 1.0, 640, 20, 320],
            [1, 1.0, 730, 20, 320],
            [1, 1.0, 730, 35, 485],
            [1, 1.0, 190, 35, 485],
            [1, 1.0, 730, 48, 670],
            [1, 1.0, 190, 48, 670],
            [1, 1.0, 640, 48, 670],
            [1, 1.0, 550, 48, 670],
            [1, 1.0, 460, 48, 670],
            [1, 1.0, 370, 48, 670],
            [1, 1.0, 280, 48, 670],
            [1, 1.0, 460, 67, 840],
            [1, 1.0, 460, 85, 950],
            [1, 1.0, 460, 85, 1050],
            [1, 1.0, 460, 85, 1150],
        ],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.AztecLanky5DTemple,
        name="Path to GB",
        konglist=[Kongs.lanky],
        region=Regions.LankyTemple,
        logic=lambda l: l.grape or l.CanPhase(),
        locations=[
            [1, 1.0, 300, 85, 1150],
            [1, 1.0, 150, 85, 1150],
        ],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.AztecLanky5DTemple,
        name="Path to GB",
        konglist=[Kongs.lanky],
        region=Regions.LankyTempleEntrance,
        locations=[[1, 1.0, 460, 20, 100], [1, 1.0, 460, 20, 173], [1, 1.0, 460, 20, 246], [1, 1.0, 460, 20, 320]],
    ),
    ColoredBananaGroup(
        group=62,
        map_id=Maps.AztecLanky5DTemple,
        name="Dead end",
        konglist=[Kongs.lanky],
        region=Regions.LankyTemple,
        logic=lambda l: l.grape,
        locations=[[5, 1.0, 768, 128, 925]],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.AztecTiny5DTemple,
        name="Path to GB",
        konglist=[Kongs.tiny],
        region=Regions.TinyTemple,
        locations=[
            [1, 1.0, 726, 20, 300],
            [1, 1.0, 813, 20, 300],
            [1, 1.0, 900, 20, 300],
            [1, 1.0, 553, 20, 300],
            [1, 1.0, 466, 20, 300],
            [1, 1.0, 380, 20, 300],
            [1, 1.0, 900, 20, 420],
            [1, 1.0, 900, 48, 540],
            [1, 1.0, 900, 48, 680],
            [1, 1.0, 380, 20, 420],
            [1, 1.0, 380, 48, 540],
            [1, 1.0, 380, 48, 680],
            [1, 1.0, 510, 48, 680],
            [1, 1.0, 640, 48, 680],
            [1, 1.0, 770, 48, 680],
            [1, 1.0, 900, 48, 680],
            [1, 1.0, 640, 85, 900],
            [1, 1.0, 640, 85, 1030],
            [1, 1.0, 640, 85, 1160],
        ],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.AztecTiny5DTemple,
        name="Path to GB",
        konglist=[Kongs.tiny],
        region=Regions.TinyTemple,
        logic=lambda l: l.feather or l.CanPhase(),
        locations=[
            [1, 1.0, 790, 85, 1160],
            [1, 1.0, 940, 85, 1160],
        ],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.AztecTiny5DTemple,
        name="Path to GB",
        konglist=[Kongs.tiny],
        region=Regions.TinyTempleEntrance,
        locations=[[1, 1.0, 640, 20, 100], [1, 1.0, 640, 20, 166], [1, 1.0, 640, 20, 233], [1, 1.0, 640, 20, 300]],
    ),
    ColoredBananaGroup(
        group=64,
        map_id=Maps.AztecTiny5DTemple,
        name="Dead end",
        konglist=[Kongs.tiny],
        region=Regions.TinyTemple,
        logic=lambda l: l.feather,
        locations=[[5, 1.0, 330, 128, 1400]],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.AztecChunky5DTemple,
        name="Path to GB",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTemple,
        locations=[
            [1, 1.0, 726, 20, 300],
            [1, 1.0, 813, 20, 300],
            [1, 1.0, 900, 20, 300],
            [1, 1.0, 553, 20, 300],
            [1, 1.0, 466, 20, 300],
            [1, 1.0, 380, 20, 300],
            [1, 1.0, 900, 20, 420],
            [1, 1.0, 900, 48, 540],
            [1, 1.0, 900, 48, 680],
            [1, 1.0, 380, 20, 420],
            [1, 1.0, 380, 48, 540],
            [1, 1.0, 380, 48, 680],
            [1, 1.0, 510, 48, 680],
            [1, 1.0, 640, 48, 680],
            [1, 1.0, 770, 48, 680],
            [1, 1.0, 900, 48, 680],
            [1, 1.0, 640, 85, 900],
            [1, 1.0, 640, 85, 1040],
            [1, 1.0, 640, 85, 1180],
            [1, 1.0, 640, 85, 1620],
            [1, 1.0, 640, 104, 1710],
            [1, 1.0, 640, 123, 1870],
        ],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.AztecChunky5DTemple,
        name="Path to GB",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTemple,
        logic=lambda l: l.pineapple or l.CanPhase(),
        locations=[
            [1, 1.0, 490, 123, 1870],
            [1, 1.0, 340, 123, 1870],
            [1, 1.0, 340, 123, 2100],
            [1, 1.0, 240, 123, 2100],
        ],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.AztecChunky5DTemple,
        name="Path to GB",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTempleEntrance,
        locations=[[1, 1.0, 640, 20, 100], [1, 1.0, 640, 20, 166], [1, 1.0, 640, 20, 233], [1, 1.0, 640, 20, 300]],
    ),
    ColoredBananaGroup(
        group=66,
        map_id=Maps.AztecLlamaTemple,
        name="Entrance stairs (9 custom, 6 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[
            [1, 1.0, 2745, 473, 2133],
            [1, 1.0, 2745, 473, 2208],
            [1, 1.0, 2745, 508, 2268],
            [1, 1.0, 2745, 540, 2334],
            [1, 1.0, 2745, 540, 2400],
            [1, 1.0, 2745, 540, 2466],
            [1, 1.0, 2745, 508, 2532],
            [1, 1.0, 2745, 473, 2592],
            [1, 1.0, 2745, 473, 2667],
            [1, 1.0, 2603.002685546875, 377.0220947265625, 2845.9052734375],
            [1, 1.0, 2680.486083984375, 422.1327819824219, 2773.993408203125],
            [1, 1.0, 2733.522216796875, 464.8854675292969, 2713.590576171875],
            [1, 1.0, 2735.095703125, 464.2814636230469, 2070.636474609375],
            [1, 1.0, 2669.124267578125, 417.5154724121094, 2011.67626953125],
            [1, 1.0, 2595.671142578125, 372.2605285644531, 1948.17724609375],
        ],
    ),
    ColoredBananaGroup(
        group=67,
        map_id=Maps.AztecLlamaTemple,
        name="Around water/lava",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[
            [1, 1.0, 2048, 372, 2076],
            [1, 1.0, 2148, 372, 2076],
            [1, 1.0, 2248, 372, 2076],
            [1, 1.0, 2348, 372, 2076],
            [1, 1.0, 2448, 372, 2076],
            [1, 1.0, 2448, 372, 2186],
            [1, 1.0, 2448, 372, 2295],
            [1, 1.0, 2448, 372, 2405],
            [1, 1.0, 2448, 372, 2515],
            [1, 1.0, 2448, 372, 2624],
            [1, 1.0, 2448, 372, 2734],
            [1, 1.0, 2348, 372, 2734],
            [1, 1.0, 2248, 372, 2734],
            [1, 1.0, 2148, 372, 2734],
            [1, 1.0, 2048, 372, 2734],
        ],
    ),
    ColoredBananaGroup(
        group=68,
        map_id=Maps.AztecLlamaTemple,
        name="Bottom of stairs to Llama",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[
            [5, 1.0, 1875, 377, 2632],
            [5, 1.0, 1875, 377, 2532],
            [5, 1.0, 1875, 377, 2176],
            [5, 1.0, 1875, 377, 2276],
        ],
    ),
    ColoredBananaGroup(
        group=69,
        map_id=Maps.AztecLlamaTemple,
        name="W2 in Llama temple",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTempleBack,
        locations=[[5, 1.0, 2638, 385, 2632]],
    ),
    ColoredBananaGroup(
        group=69,
        map_id=Maps.AztecLlamaTemple,
        name="W2 in Llama temple",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[[5, 1.0, 1409, 434, 3754]],
    ),
    ColoredBananaGroup(
        group=70,
        map_id=Maps.AztecLlamaTemple,
        name="Bottom of stairs to W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[
            [1, 1.0, 1588, 473, 2571],
            [1, 1.0, 1647, 473, 2535],
            [1, 1.0, 1682, 473, 2472],
            [1, 1.0, 1755, 473, 2472],
            [1, 1.0, 1829, 473, 2472],
            [1, 1.0, 1616, 473, 2220],
            [1, 1.0, 1647, 473, 2265],
            [1, 1.0, 1682, 473, 2328],
            [1, 1.0, 1755, 473, 2328],
            [1, 1.0, 1829, 473, 2328],
        ],
    ),
    ColoredBananaGroup(
        group=71,
        map_id=Maps.AztecLlamaTemple,
        name="Leading to Trombone Tremor pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[
            [5, 1.0, 2268, 472, 3229],
            [1, 1.0, 2256, 459, 3160],
            [1, 1.0, 2256, 442, 3090],
            [1, 1.0, 2256, 415, 3020],
            [1, 1.0, 2256, 388, 2950],
            [1, 1.0, 2256, 372, 2880],
        ],
    ),
    ColoredBananaGroup(
        group=72,
        map_id=Maps.AztecLlamaTemple,
        name="W1 (1 custom, 1 Lanky bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[[5, 1.0, 1531, 655, 2407], [5, 1.0, 2648.802001953125, 411.3333435058594, 2185.663818359375]],
    ),
    ColoredBananaGroup(
        group=73,
        map_id=Maps.AztecTinyTemple,
        name="In Vulture room (1 custom, 9 Lanky)",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleVultureRoom,
        locations=[
            [1, 1.0, 1580, 306, 2091],
            [1, 1.0, 1480.4053955078125, 166.42979431152344, 1756.44873046875],
            [1, 1.0, 1481.51416015625, 218.4252471923828, 1858.6656494140625],
            [1, 1.0, 1479.13134765625, 286.3498229980469, 1992.19775390625],
            [1, 1.0, 1604.9066162109375, 305.8333435058594, 2186.378662109375],
            [1, 1.0, 1555.66259765625, 305.8333435058594, 2304.850341796875],
            [1, 1.0, 1382.51953125, 305.8333435058594, 2355.455322265625],
            [1, 1.0, 1285.8497314453125, 305.8333435058594, 2231.363525390625],
            [1, 1.0, 1338.56982421875, 305.8333435058594, 2096.66455078125],
            [1, 1.0, 1469.31396484375, 305.3333435058594, 2086.966064453125],
        ],
    ),
    ColoredBananaGroup(
        group=74,
        map_id=Maps.AztecTinyTemple,
        name="Underwater square room corners",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleUnderwater,
        locations=[
            [5, 1.0, 1623, 135, 1648],
            [5, 1.0, 1324, 135, 1657],
            [5, 1.0, 1312, 135, 1264],
            [5, 1.0, 1613, 135, 1255],
        ],
    ),
    ColoredBananaGroup(
        group=75,
        map_id=Maps.AztecTinyTemple,
        name="Monkey tongues (2 custom, 3 Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.TempleStart,
        logic=lambda l: l.CanSlamSwitch(Levels.AngryAztec, 1),
        locations=[
            [1, 1.0, 1350, 490, 1110],
            [1, 1.0, 1390, 490, 1110],
            [1, 1.0, 1466.78466796875, 416.0, 1048.350830078125],
            [1, 1.0, 1533.0133056640625, 378.0, 1048.8314208984375],
            [1, 1.0, 1399.3209228515625, 449.0, 1051.9788818359375],
        ],
    ),
    ColoredBananaGroup(
        group=76,
        map_id=Maps.AztecTinyTemple,
        name="Path to Free Tiny (3 custom, 7 Diddy)",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleUnderwater,
        locations=[
            [1, 1.0, 844, 345, 1466],
            [1, 1.0, 764, 345, 1466],
            [1, 1.0, 684, 345, 1466],
            [1, 1.0, 1148.4908447265625, 206.74095153808594, 1468.2752685546875],
            [1, 1.0, 1050.7142333984375, 258.3659362792969, 1469.3092041015625],
            [1, 1.0, 936.4483032226562, 318.6971740722656, 1470.0662841796875],
            [1, 1.0, 1461.3603515625, 165.3333282470703, 1062.88623046875],
            [1, 1.0, 1463.5987548828125, 165.3333282470703, 1179.60498046875],
            [1, 1.0, 1460.8355712890625, 165.6004180908203, 967.5746459960938],
            [1, 1.0, 1226.6641845703125, 165.4662628173828, 1468.41357421875],
        ],
    ),
    ColoredBananaGroup(
        group=77,
        map_id=Maps.AztecTinyTemple,
        name="Path to Chunky's room (1 custom, 4 Chunky)",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        locations=[
            [1, 1.0, 1332, 289, 633],
            [1, 1.0, 1565.0308837890625, 215.3333282470703, 420.8960266113281],
            [1, 1.0, 1356.9837646484375, 286.21099853515625, 552.7547607421875],
            [1, 1.0, 1451.1392822265625, 256.7677307128906, 463.9304504394531],
            [1, 1.0, 1656.6798095703125, 227.3333282470703, 396.0415954589844],
        ],
    ),
    ColoredBananaGroup(
        group=78,
        map_id=Maps.AztecTiny5DTemple,
        name="Right side Mini Monkey room (scale 0.6)",
        konglist=[Kongs.tiny],
        region=Regions.TinyTemple,
        logic=lambda l: l.mini or l.CanPhase(),
        locations=[
            [1, 0.6, 195, 48, 600],
            [1, 0.6, 145, 48, 600],
            [1, 0.6, 95, 48, 600],
            [1, 0.6, 95, 48, 640],
            [1, 0.6, 95, 48, 680],
            [1, 0.6, 95, 48, 720],
            [1, 0.6, 145, 48, 720],
            [1, 0.6, 195, 48, 720],
            [1, 0.6, 195, 48, 680],
            [1, 0.6, 195, 48, 640],
        ],
    ),
    ColoredBananaGroup(
        group=79,
        map_id=Maps.AztecLlamaTemple,
        name="Behind and above llama",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[[5, 1.0, 1900, 478, 2400], [5, 1.0, 1976, 535, 2400]],
    ),
    ColoredBananaGroup(
        group=80,
        map_id=Maps.AztecTinyTemple,
        name="On vulture GB switch (Lanky)",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleVultureRoom,
        vanilla=True,
        locations=[[5, 1.0, 1466.9891357421875, 449.3333435058594, 2188.87158203125]],
    ),
    ColoredBananaGroup(
        group=81,
        map_id=Maps.AztecTinyTemple,
        name="Long monkey tongue (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.TempleStart,
        vanilla=True,
        logic=lambda l: l.CanSlamSwitch(Levels.AngryAztec, 1) and l.peanut,
        locations=[
            [5, 1.0, 1346.4971923828125, 482.0, 895.43505859375],
            [5, 1.0, 1351.4986572265625, 487.0, 705.5042114257812],
            [5, 1.0, 1349.2825927734375, 483.1666564941406, 807.2919921875],
        ],
    ),
    ColoredBananaGroup(
        group=82,
        map_id=Maps.AztecTinyTemple,
        name="Mini Monkey tunnel (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.TempleUnderwater,
        vanilla=True,
        logic=lambda l: l.mini or l.CanPhaseswim(),
        locations=[
            [1, 1.0, 1579.29052734375, 155.3333282470703, 845.8433227539062],
            [1, 1.0, 1598.7659912109375, 155.3333282470703, 844.5404663085938],
            [1, 1.0, 1685.5655517578125, 205.73602294921875, 844.5404663085938],
            [1, 1.0, 1628.83154296875, 160.35464477539062, 844.5404663085938],
            [1, 1.0, 1657.3309326171875, 173.33123779296875, 844.5404663085938],
        ],
    ),
    ColoredBananaGroup(
        group=83,
        map_id=Maps.AztecTinyTemple,
        name="In corner around torch (Chunky)",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        vanilla=True,
        locations=[
            [5, 1.0, 1893.00634765625, 287.6666564941406, 646.7476196289062],
            [5, 1.0, 1749.7740478515625, 287.6666564941406, 559.2758178710938],
            [5, 1.0, 1815.4932861328125, 287.6666564941406, 538.45458984375],
            [5, 1.0, 1869.67236328125, 287.6666564941406, 577.2301025390625],
            [5, 1.0, 1832.2626953125, 287.6666564941406, 689.0494995117188],
        ],
    ),
    ColoredBananaGroup(
        group=84,
        map_id=Maps.AztecLlamaTemple,
        name="All around Llama Temple (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        vanilla=True,
        locations=[
            [1, 1.0, 2251.771484375, 383.9692077636719, 1864.0164794921875],
            [1, 1.0, 2252.418212890625, 415.1138916015625, 1783.4697265625],
            [1, 1.0, 1646.8916015625, 501.0, 2736.399658203125],
            [1, 1.0, 1591.1871337890625, 549.37548828125, 2688.85498046875],
            [1, 1.0, 1556.27587890625, 596.6666870117188, 2639.483154296875],
            [1, 1.0, 1656.0509033203125, 501.0, 2073.727294921875],
            [1, 1.0, 1602.4581298828125, 549.3593139648438, 2126.334228515625],
            [1, 1.0, 1563.1802978515625, 596.6666870117188, 2174.660888671875],
            [1, 1.0, 1875.5458984375, 461.771240234375, 1978.9735107421875],
            [1, 1.0, 1995.4735107421875, 385.9208068847656, 1977.8331298828125],
            [1, 1.0, 1883.1895751953125, 457.038330078125, 2829.727783203125],
            [1, 1.0, 1988.5274658203125, 391.9779357910156, 2829.515625],
            [1, 1.0, 1936.4364013671875, 423.3492431640625, 1979.6671142578125],
            [1, 1.0, 1933.8759765625, 425.6437072753906, 2830.387939453125],
            [1, 1.0, 2252.23486328125, 450.342529296875, 1692.0113525390625],
        ],
    ),
    ColoredBananaGroup(
        group=85,
        map_id=Maps.AztecLlamaTemple,
        name="Llama Temple Water Corners",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        logic=lambda l: Events.AztecLlamaSpit in l.Events and l.swim,
        locations=[
            [5, 1.0, 2038, 211, 2689],
            [5, 1.0, 2410, 211, 2113],
            [5, 1.0, 2411, 211, 2690],
            [5, 1.0, 2040, 211, 2131],
        ],
    ),
    ColoredBananaGroup(
        group=86,
        map_id=Maps.AztecLlamaTemple,
        name="To lava room (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        vanilla=True,
        locations=[
            [1, 1.0, 1716.2806396484375, 454.1103515625, 2904.645263671875],
            [1, 1.0, 1656.4158935546875, 433.5, 3024.917724609375],
            [1, 1.0, 1606.3065185546875, 433.5, 3125.729736328125],
        ],
    ),
    ColoredBananaGroup(
        group=86,
        map_id=Maps.AztecLlamaTemple,
        name="To lava room (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTempleBack,
        vanilla=True,
        locations=[
            [1, 1.0, 1405.3702392578125, 420.6820068359375, 3478.0986328125],
            [1, 1.0, 1499.125, 427.9440002441406, 3322.441162109375],
        ],
    ),
    ColoredBananaGroup(
        group=87,
        map_id=Maps.AztecLlamaTemple,
        name="On Tiny switches in lava room (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.LlamaTempleBack,
        vanilla=True,
        logic=lambda l: (l.CanSlamSwitch(Levels.AngryAztec, 1) or (l.twirl and l.monkey_maneuvers)) and l.istiny,
        locations=[
            [5, 1.0, 870.1953125, 475.3333435058594, 3735.6279296875],
            [5, 1.0, 1458.1766357421875, 475.3333435058594, 4069.542236328125],
        ],
    ),
    ColoredBananaGroup(
        group=88,
        map_id=Maps.AztecLlamaTemple,
        name="On vines in Matching game room (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.LlamaTempleMatching,
        vanilla=True,
        logic=lambda l: l.can_use_vines,
        locations=[[5, 1.0, 792.3839721679688, 686.5, 2613.002685546875]],
    ),
    ColoredBananaGroup(
        group=89,
        map_id=Maps.AngryAztec,
        name="Under Mini Monkey Barrel by Beetle Race Tower (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        vanilla=True,
        locations=[[5, 1.0, 4341.3056640625, 82.0, 3450.823486328125]],
    ),
    ColoredBananaGroup(
        group=90,
        map_id=Maps.AngryAztec,
        name="On oasis treetops (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 2526.212890625, 295.5, 1032.5323486328125]],
    ),
    ColoredBananaGroup(
        group=91,
        map_id=Maps.AngryAztec,
        name="On oasis treetops (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 2328.66455078125, 321.1870422363281, 1047.9520263671875]],
    ),
    ColoredBananaGroup(
        group=92,
        map_id=Maps.AngryAztec,
        name="On oasis treetops (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.climbing,
        vanilla=True,
        locations=[[5, 1.0, 2482.407958984375, 295.5, 889.5724487304688]],
    ),
    ColoredBananaGroup(
        group=93,
        map_id=Maps.AngryAztec,
        name="DK Sealed Quicksand Tunnel (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.AztecDonkeyQuicksandCave,
        vanilla=True,
        logic=lambda l: l.strongKong,
        locations=[
            [5, 1.0, 3171.275390625, 121.44964599609375, 4672.31787109375],
            [5, 1.0, 3067.819091796875, 120.3871841430664, 4749.61474609375],
            [5, 1.0, 3199.771484375, 122.03072357177734, 4574.24853515625],
            [5, 1.0, 2965.021484375, 123.71839904785156, 4750.3740234375],
        ],
    ),
    ColoredBananaGroup(
        group=94,
        map_id=Maps.AngryAztec,
        name="DK Blueprint cave (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.AngryAztecOasis,
        vanilla=True,
        logic=lambda l: (l.hasMoveSwitchsanity(Switches.AztecBlueprintDoor, False) or l.CanPhase()) and l.strongKong,
        locations=[[5, 1.0, 1464.7799072265625, 132.91937255859375, 610.3526000976562], [5, 1.0, 1294.2562255859375, 132.93927001953125, 609.1015014648438]],
    ),
    ColoredBananaGroup(
        group=95,
        map_id=Maps.AngryAztec,
        name="On Melon crate on Llama Temple roof (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecMain,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 2893.345458984375, 477.5, 2948.93359375]],
    ),
    ColoredBananaGroup(
        group=96,
        map_id=Maps.AngryAztec,
        name="In sun (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecMain,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 3275.230224609375, 474.3407287597656, 3839.829833984375]],
    ),
    ColoredBananaGroup(
        group=97,
        map_id=Maps.AngryAztec,
        name="On trees around Beetle race tower (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        vanilla=True,
        locations=[
            [5, 1.0, 4201.38134765625, 305.0, 3067.024169921875],
            [5, 1.0, 4496.0810546875, 305.0, 3023.1318359375],
            [5, 1.0, 4585.70654296875, 304.0, 3295.3056640625],
        ],
    ),
    ColoredBananaGroup(
        group=98,
        map_id=Maps.AngryAztec,
        name="Path to 5DT (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        vanilla=True,
        locations=[
            [1, 1.0, 2379.411376953125, 120.0, 3774.989501953125],
            [1, 1.0, 2412.770263671875, 120.0, 3977.384521484375],
            [1, 1.0, 2544.5947265625, 120.0, 3995.685302734375],
            [1, 1.0, 2641.50537109375, 120.01071166992188, 4050.7939453125],
            [1, 1.0, 2390.778564453125, 120.0, 3880.102294921875],
        ],
    ),
    ColoredBananaGroup(
        group=99,
        map_id=Maps.AngryAztec,
        name="Trees around back of 5DT (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.climbing or (l.twirl and l.istiny) or (l.jetpack and l.isdiddy),
        vanilla=True,
        locations=[
            [5, 1.0, 2165.227294921875, 332.35711669921875, 3373.839599609375],
            [5, 1.0, 1824.9188232421875, 332.7916259765625, 3556.1611328125],
        ],
    ),
    ColoredBananaGroup(
        group=100,
        map_id=Maps.AngryAztec,
        name="Trees around front of 5DT (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.climbing or (l.twirl and l.istiny) or (l.jetpack and l.isdiddy),
        vanilla=True,
        locations=[
            [5, 1.0, 1909.673828125, 313.08673095703125, 4099.64208984375],
            [5, 1.0, 2465.809326171875, 333.667236328125, 3803.565185546875],
            [5, 1.0, 2198.811279296875, 332.0, 3914.860595703125],
        ],
    ),
    ColoredBananaGroup(
        group=101,
        map_id=Maps.AngryAztec,
        name="Trees between Llama Temple and 5DT (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        vanilla=True,
        locations=[
            [5, 1.0, 2851.993896484375, 310.0, 3940.567626953125],
            [5, 1.0, 2902.201904296875, 310.0, 3618.733154296875],
            [5, 1.0, 3151.441162109375, 340.0, 3379.648193359375],
        ],
    ),
    ColoredBananaGroup(
        group=102,
        map_id=Maps.AngryAztec,
        name="Around the outside of Llama Temple",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 2800, 250, 3093],
            [1, 1.0, 2792, 250, 3063],
            [1, 1.0, 2790, 250, 3032],
            [1, 1.0, 2766, 250, 2969],
            [1, 1.0, 2750, 250, 2907],
            [1, 1.0, 2735, 250, 2846],
            [1, 1.0, 2791, 250, 2834],
            [1, 1.0, 2847, 250, 2814],
            [1, 1.0, 2904, 250, 2803],
            [1, 1.0, 2978, 250, 2779],
            [1, 1.0, 2998, 250, 2841],
            [1, 1.0, 3015, 250, 2900],
            [1, 1.0, 3030, 250, 2964],
            [1, 1.0, 3038, 250, 2998],
            [1, 1.0, 3044, 250, 3026],
        ],
    ),
    ColoredBananaGroup(
        group=103,
        map_id=Maps.AngryAztec,
        name="Vase room (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        vanilla=True,
        logic=lambda l: l.pineapple or l.CanPhase(),
        locations=[
            [5, 1.0, 232.0945587158203, 128.694091796875, 852.361083984375],
            [5, 1.0, 188.08251953125, 126.59268188476562, 574.8196411132812],
            [5, 1.0, 481.36376953125, 127.9952392578125, 557.4595947265625],
            [5, 1.0, 497.8692932128906, 128.62557983398438, 833.964111328125],
        ],
    ),
    ColoredBananaGroup(
        group=104,
        map_id=Maps.AngryAztec,
        name="On Tiny Temple Staircase",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 2940, 153, 826],
            [1, 1.0, 2963, 157, 808],
            [1, 1.0, 2978, 175, 796],
            [1, 1.0, 2995, 195, 784],
            [1, 1.0, 3018, 215, 763],
        ],
    ),
    # Wave 2 by Snap
    ColoredBananaGroup(
        group=105,
        map_id=Maps.AngryAztec,
        name="Entrance portal",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecStart,
        locations=[
            [1, 1.0, 837, 120, 202],
            [1, 1.0, 834, 131, 202],
            [1, 1.0, 837, 143, 202],
            [1, 1.0, 840, 154, 202],
            [1, 1.0, 837, 165, 202],
            [1, 1.0, 730, 120, 202],
            [1, 1.0, 733, 131, 202],
            [1, 1.0, 730, 143, 202],
            [1, 1.0, 727, 154, 202],
            [1, 1.0, 730, 165, 202],
        ],
    ),
    ColoredBananaGroup(
        group=106,
        map_id=Maps.AngryAztec,
        name="In front of the vases room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        locations=[
            [1, 1.0, 717, 120, 855],
            [1, 1.0, 710, 120, 833],
            [1, 1.0, 686, 120, 833],
            [1, 1.0, 679, 120, 855],
            [1, 1.0, 698, 120, 869],
        ],
    ),
    ColoredBananaGroup(
        group=107,
        map_id=Maps.AngryAztec,
        name="Under the flames by vases room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        locations=[[5, 1.0, 919, 160, 1102], [5, 1.0, 828, 160, 1191]],
    ),
    ColoredBananaGroup(
        group=108,
        map_id=Maps.AngryAztec,
        name="In front of the DK Kasplat room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 1386, 120, 1088],
            [1, 1.0, 1379, 120, 1066],
            [1, 1.0, 1355, 120, 1066],
            [1, 1.0, 1348, 120, 1088],
            [1, 1.0, 1367, 120, 1102],
        ],
    ),
    ColoredBananaGroup(
        group=109,
        map_id=Maps.AngryAztec,
        name="Under the flames by DK Kasplat room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[[5, 1.0, 1627, 160, 1237], [5, 1.0, 1624, 160, 1082]],
    ),
    ColoredBananaGroup(
        group=110,
        map_id=Maps.AngryAztec,
        name="Around the oasis grass",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 2338, 111, 868],
            [1, 1.0, 2413, 111, 845],
            [1, 1.0, 2494, 111, 863],
            [1, 1.0, 2564, 111, 917],
            [1, 1.0, 2560, 111, 992],
            [1, 1.0, 2536, 111, 1076],
            [1, 1.0, 2460, 111, 1099],
            [1, 1.0, 2380, 111, 1095],
            [1, 1.0, 2315, 111, 1036],
            [1, 1.0, 2315, 111, 959],
        ],
    ),
    ColoredBananaGroup(
        group=111,
        map_id=Maps.AngryAztec,
        name="Around the rocketbarrel tree",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 2805, 120, 1209],
            [1, 1.0, 2824, 140, 1184],
            [1, 1.0, 2824, 120, 1154],
            [1, 1.0, 2805, 140, 1129],
            [1, 1.0, 2776, 120, 1119],
            [1, 1.0, 2747, 140, 1129],
            [1, 1.0, 2728, 120, 1154],
            [1, 1.0, 2728, 140, 1184],
            [1, 1.0, 2747, 120, 1209],
            [1, 1.0, 2776, 140, 1219],
        ],
    ),
    ColoredBananaGroup(
        group=112,
        map_id=Maps.AngryAztec,
        name="Right of Tiny temple stairs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[[1, 1.0, 2969, 155, 936], [1, 1.0, 2966, 164, 936], [1, 1.0, 2969, 173, 936], [1, 1.0, 2972, 181, 936], [1, 1.0, 2969, 190, 936]],
    ),
    ColoredBananaGroup(
        group=113,
        map_id=Maps.AngryAztec,
        name="Left of Tiny temple stairs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[[1, 1.0, 2827, 155, 735], [1, 1.0, 2827, 164, 732], [1, 1.0, 2827, 173, 735], [1, 1.0, 2827, 181, 738], [1, 1.0, 2827, 190, 735]],
    ),
    ColoredBananaGroup(
        group=114,
        map_id=Maps.AngryAztec,
        name="Between the Tiny temple switches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[[5, 1.0, 3068, 255, 524], [5, 1.0, 3262, 255, 777]],
    ),
    ColoredBananaGroup(
        group=115,
        map_id=Maps.AngryAztec,
        name="In front of the guitar door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        locations=[
            [1, 1.0, 2703, 120, 1425],
            [1, 1.0, 2722, 120, 1400],
            [1, 1.0, 2722, 120, 1370],
            [1, 1.0, 2703, 120, 1345],
            [1, 1.0, 2674, 120, 1335],
            [1, 1.0, 2645, 120, 1345],
            [1, 1.0, 2626, 120, 1370],
            [1, 1.0, 2626, 120, 1400],
            [1, 1.0, 2645, 120, 1425],
            [1, 1.0, 2674, 120, 1435],
        ],
    ),
    ColoredBananaGroup(
        group=116,
        map_id=Maps.AngryAztec,
        name="High between the three oasis trees",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.climbing,
        locations=[[5, 1.1, 2435, 343, 992]],
    ),
    ColoredBananaGroup(
        group=117,
        map_id=Maps.AngryAztec,
        name="Start tunnel arch",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.jetpack and l.climbing,
        locations=[[5, 1.0, 2082, 244, 882]],
    ),
    ColoredBananaGroup(
        group=118,
        map_id=Maps.AngryAztec,
        name="Top center of Tiny temple",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.jetpack and l.climbing,
        locations=[[1, 1.0, 3062, 351, 732], [1, 1.0, 3065, 360, 732], [1, 1.0, 3062, 369, 732], [1, 1.0, 3059, 377, 732], [1, 1.0, 3062, 386, 732]],
    ),
    ColoredBananaGroup(
        group=119,
        map_id=Maps.AngryAztec,
        name="Guitar door arch",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.jetpack and l.climbing,
        locations=[[1, 1.0, 2768, 225, 1450], [1, 1.0, 2719, 244, 1439], [1, 1.0, 2678, 261, 1457], [1, 1.0, 2636, 244, 1456], [1, 1.0, 2583, 225, 1455]],
    ),
    ColoredBananaGroup(
        group=120,
        map_id=Maps.AngryAztec,
        name="Around the giant boulder switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3331, 120, 1910],
            [1, 1.0, 3367, 130, 1860],
            [1, 1.0, 3367, 120, 1798],
            [1, 1.0, 3331, 130, 1748],
            [1, 1.0, 3272, 120, 1729],
            [1, 1.0, 3213, 130, 1748],
            [1, 1.0, 3177, 120, 1798],
            [1, 1.0, 3177, 130, 1860],
            [1, 1.0, 3213, 120, 1910],
            [1, 1.0, 3272, 130, 1929],
        ],
    ),
    ColoredBananaGroup(
        group=121,
        map_id=Maps.AngryAztec,
        name="Under flames near Hunky barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3207, 120, 1430],
            [1, 1.0, 3207, 130, 1433],
            [1, 1.0, 3207, 140, 1430],
            [1, 1.0, 3207, 150, 1427],
            [1, 1.0, 3207, 160, 1430],
            [1, 1.0, 3333, 120, 1437],
            [1, 1.0, 3333, 130, 1434],
            [1, 1.0, 3333, 140, 1437],
            [1, 1.0, 3333, 150, 1440],
            [1, 1.0, 3333, 160, 1437],
        ],
    ),
    ColoredBananaGroup(
        group=122,
        map_id=Maps.AngryAztec,
        name="Odd wall between Hunky and boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[1, 1.0, 3796, 120, 1958], [1, 1.0, 3793, 131, 1958], [1, 1.0, 3796, 143, 1958], [1, 1.0, 3799, 154, 1958], [1, 1.0, 3796, 165, 1958]],
    ),
    ColoredBananaGroup(
        group=123,
        map_id=Maps.AngryAztec,
        name="On the giant boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[5, 2.0, 3589, 172, 2408]],
    ),
    ColoredBananaGroup(
        group=124,
        map_id=Maps.AngryAztec,
        name="Around the giant boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3636, 120, 2474],
            [1, 1.0, 3665, 120, 2434],
            [1, 1.0, 3665, 120, 2384],
            [1, 1.0, 3636, 120, 2344],
            [1, 1.0, 3589, 120, 2329],
            [1, 1.0, 3542, 120, 2344],
            [1, 1.0, 3513, 120, 2384],
            [1, 1.0, 3513, 120, 2434],
            [1, 1.0, 3542, 120, 2474],
            [1, 1.0, 3589, 120, 2489],
        ],
    ),
    ColoredBananaGroup(
        group=125,
        map_id=Maps.AngryAztec,
        name="Totem area entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3553, 120, 3072],
            [1, 1.0, 3553, 130, 3075],
            [1, 1.0, 3553, 140, 3072],
            [1, 1.0, 3553, 150, 3069],
            [1, 1.0, 3553, 160, 3072],
            [1, 1.0, 3441, 120, 3072],
            [1, 1.0, 3441, 130, 3075],
            [1, 1.0, 3441, 140, 3072],
            [1, 1.0, 3441, 150, 3069],
            [1, 1.0, 3441, 160, 3072],
        ],
    ),
    ColoredBananaGroup(
        group=126,
        map_id=Maps.AngryAztec,
        name="Between warp 3 and warp 4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[1, 1.0, 3457, 121, 3387], [1, 1.0, 3454, 131, 3387], [1, 1.0, 3457, 141, 3387], [1, 1.0, 3460, 151, 3387], [1, 1.0, 3457, 161, 3387]],
    ),
    ColoredBananaGroup(
        group=127,
        map_id=Maps.AngryAztec,
        name="Around trees towards Funky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3070, 120, 4250],
            [1, 1.0, 3018, 120, 4250],
            [1, 1.0, 3044, 120, 4295],
            [1, 1.0, 2849, 120, 3945],
            [1, 1.0, 2819, 120, 3915],
            [1, 1.0, 2789, 120, 3945],
            [1, 1.0, 2819, 120, 3975],
            [1, 1.0, 2910, 120, 3593],
            [1, 1.0, 2858, 120, 3593],
            [1, 1.0, 2884, 120, 3638],
        ],
    ),
    ColoredBananaGroup(
        group=128,
        map_id=Maps.AngryAztec,
        name="Around tree in front of Llama temple",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3163, 120, 3440],
            [1, 1.0, 3152, 120, 3407],
            [1, 1.0, 3116, 120, 3407],
            [1, 1.0, 3105, 120, 3440],
            [1, 1.0, 3134, 120, 3461],
        ],
    ),
    ColoredBananaGroup(
        group=129,
        map_id=Maps.AngryAztec,
        name="Around tree near rocketbarrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 4081, 120, 3623],
            [1, 1.0, 4070, 120, 3590],
            [1, 1.0, 4034, 120, 3590],
            [1, 1.0, 4023, 120, 3623],
            [1, 1.0, 4052, 120, 3644],
        ],
    ),
    ColoredBananaGroup(
        group=130,
        map_id=Maps.AngryAztec,
        name="Around the gong tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 4416, 140, 3299],
            [1, 1.0, 4453, 140, 3273],
            [1, 1.0, 4476, 140, 3233],
            [1, 1.0, 4480, 140, 3188],
            [1, 1.0, 4466, 140, 3144],
            [1, 1.0, 4436, 140, 3110],
            [1, 1.0, 4394, 140, 3091],
            [1, 1.0, 4348, 140, 3091],
            [1, 1.0, 4306, 140, 3110],
            [1, 1.0, 4276, 140, 3144],
            [1, 1.0, 4262, 140, 3188],
            [1, 1.0, 4266, 140, 3233],
            [1, 1.0, 4289, 140, 3273],
            [1, 1.0, 4326, 140, 3299],
            [1, 1.0, 4371, 140, 3309],
        ],
    ),
    ColoredBananaGroup(
        group=131,
        map_id=Maps.AngryAztec,
        name="Behind the two far gongs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [5, 1.0, 4316, 145, 2983],
            [5, 1.0, 4587, 145, 3140],
        ],
    ),
    ColoredBananaGroup(
        group=132,
        map_id=Maps.AngryAztec,
        name="In the quicksand near rocketbarrel",
        konglist=[Kongs.donkey],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.strongKong,
        locations=[
            [1, 1.0, 4006, 112, 3847],
            [1, 1.0, 3977, 112, 3757],
            [1, 1.0, 3883, 112, 3757],
            [1, 1.0, 3854, 112, 3847],
            [1, 1.0, 3930, 112, 3902],
            [1, 1.0, 4025, 112, 3853],
            [1, 1.0, 3989, 112, 3741],
            [1, 1.0, 3871, 112, 3741],
            [1, 1.0, 3835, 112, 3853],
            [1, 1.0, 3930, 112, 3922],
        ],
    ),
    ColoredBananaGroup(
        group=133,
        map_id=Maps.AngryAztec,
        name="Flower near Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[1, 1.0, 4093, 120, 4619], [1, 1.0, 4093, 131, 4622], [1, 1.0, 4093, 143, 4619], [1, 1.0, 4093, 154, 4616], [1, 1.0, 4093, 165, 4619]],
    ),
    ColoredBananaGroup(
        group=134,
        map_id=Maps.AngryAztec,
        name="Around trees between rocketbarrel and warp 5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 3758, 120, 3860],
            [1, 1.0, 3706, 120, 3860],
            [1, 1.0, 3732, 120, 3905],
            [1, 1.0, 3490, 120, 4351],
            [1, 1.0, 3503, 120, 4291],
            [1, 1.0, 3465, 120, 4244],
            [1, 1.0, 3405, 120, 4244],
            [1, 1.0, 3367, 120, 4291],
            [1, 1.0, 3380, 120, 4351],
            [1, 1.0, 3435, 120, 4377],
        ],
    ),
    ColoredBananaGroup(
        group=135,
        map_id=Maps.AngryAztec,
        name="In front of the sealed quicksand tunnel",
        konglist=[Kongs.donkey],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.strongKong,
        locations=[[1, 1.0, 3210, 111, 4388], [1, 1.0, 3213, 121, 4388], [1, 1.0, 3210, 131, 4388], [1, 1.0, 3207, 141, 4388], [1, 1.0, 3210, 151, 4388]],
    ),
    ColoredBananaGroup(
        group=136,
        map_id=Maps.AngryAztec,
        name="Flower near Funky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[1, 1.0, 2822, 120, 4199], [1, 1.0, 2825, 130, 4199], [1, 1.0, 2822, 140, 4199], [1, 1.0, 2819, 150, 4199], [1, 1.0, 2822, 160, 4199]],
    ),
    ColoredBananaGroup(
        group=137,
        map_id=Maps.AngryAztec,
        name="5DT upper front corners",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 2130, 280, 3844],
            [1, 1.0, 2127, 290, 3844],
            [1, 1.0, 2130, 300, 3844],
            [1, 1.0, 2133, 310, 3844],
            [1, 1.0, 2130, 320, 3844],
            [1, 1.0, 2292, 280, 3526],
            [1, 1.0, 2295, 290, 3526],
            [1, 1.0, 2292, 300, 3526],
            [1, 1.0, 2289, 310, 3526],
            [1, 1.0, 2292, 320, 3526],
        ],
    ),
    ColoredBananaGroup(
        group=138,
        map_id=Maps.AngryAztec,
        name="5DT upper back corners",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[
            [1, 1.0, 2010, 280, 3383],
            [1, 1.0, 2013, 290, 3383],
            [1, 1.0, 2010, 300, 3383],
            [1, 1.0, 2007, 310, 3383],
            [1, 1.0, 2010, 320, 3383],
            [1, 1.0, 1847, 280, 3700],
            [1, 1.0, 1844, 290, 3700],
            [1, 1.0, 1847, 300, 3700],
            [1, 1.0, 1850, 310, 3700],
            [1, 1.0, 1847, 320, 3700],
        ],
    ),
    ColoredBananaGroup(
        group=139,
        map_id=Maps.AngryAztec,
        name="Stairs to the baboon blast pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[1, 1.0, 2997, 155, 3334], [1, 1.0, 2990, 146, 3361], [1, 1.0, 3022, 146, 3353], [1, 1.0, 3042, 138, 3373], [1, 1.0, 2981, 138, 3389]],
    ),
    ColoredBananaGroup(
        group=140,
        map_id=Maps.AngryAztec,
        name="Left of Llama temple stairs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[1, 1.0, 2846, 160, 3272], [1, 1.0, 2849, 170, 3272], [1, 1.0, 2846, 180, 3272], [1, 1.0, 2843, 190, 3272], [1, 1.0, 2846, 200, 3272]],
    ),
    ColoredBananaGroup(
        group=141,
        map_id=Maps.AngryAztec,
        name="Right of Llama temple stairs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        locations=[[1, 1.0, 3071, 160, 3191], [1, 1.0, 3068, 170, 3191], [1, 1.0, 3071, 180, 3191], [1, 1.0, 3074, 190, 3191], [1, 1.0, 3071, 200, 3191]],
    ),
    ColoredBananaGroup(
        group=142,
        map_id=Maps.AngryAztec,
        name="Vases room central platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        logic=lambda l: (l.pineapple and l.chunky) or l.CanPhase(),
        locations=[
            [1, 1.0, 407, 140, 786],
            [1, 1.0, 440, 140, 741],
            [1, 1.0, 440, 140, 685],
            [1, 1.0, 407, 140, 640],
            [1, 1.0, 354, 140, 623],
            [1, 1.0, 301, 140, 640],
            [1, 1.0, 268, 140, 685],
            [1, 1.0, 268, 140, 741],
            [1, 1.0, 301, 140, 786],
            [1, 1.0, 354, 140, 803],
        ],
    ),
    ColoredBananaGroup(
        group=143,
        map_id=Maps.AngryAztec,
        name="Totem rocketbarrel liftoff !!",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 3735, 300, 3564],
            [1, 1.0, 3735, 328, 3564],
            [1, 1.1, 3735, 356, 3564],
            [1, 1.1, 3735, 383, 3564],
            [1, 1.2, 3735, 411, 3564],
            [1, 1.2, 3735, 439, 3564],
            [1, 1.3, 3735, 467, 3564],
            [1, 1.3, 3735, 494, 3564],
            [1, 1.4, 3735, 522, 3564],
            [1, 1.5, 3735, 550, 3564],
        ],
    ),
    ColoredBananaGroup(
        group=144,
        map_id=Maps.AngryAztec,
        name="Orbit around the sun",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.1, 3314, 420, 3932],
            [1, 1.1, 3347, 434, 3908],
            [1, 1.1, 3368, 449, 3872],
            [1, 1.1, 3372, 463, 3831],
            [1, 1.1, 3360, 477, 3791],
            [1, 1.1, 3332, 491, 3760],
            [1, 1.1, 3294, 506, 3743],
            [1, 1.1, 3252, 520, 3743],
            [1, 1.1, 3214, 506, 3760],
            [1, 1.1, 3186, 491, 3791],
            [1, 1.1, 3174, 477, 3831],
            [1, 1.1, 3178, 463, 3872],
            [1, 1.1, 3199, 449, 3908],
            [1, 1.1, 3232, 434, 3932],
            [1, 1.1, 3273, 420, 3941],
        ],
    ),
    ColoredBananaGroup(
        group=145,
        map_id=Maps.AngryAztec,
        name="Sun symbol above the vulture cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        logic=lambda l: (l.climbing and l.can_use_vines) or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 4008, 282, 4590]],
    ),
    ColoredBananaGroup(
        group=146,
        map_id=Maps.AngryAztec,
        name="Llama temple roof ledges",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 3034, 380, 3022],
            [1, 1.0, 3019, 380, 2966],
            [1, 1.0, 3003, 380, 2910],
            [1, 1.0, 2988, 380, 2855],
            [1, 1.0, 2973, 380, 2799],
            [1, 1.0, 2749, 380, 2857],
            [1, 1.0, 2764, 380, 2913],
            [1, 1.0, 2780, 380, 2970],
            [1, 1.0, 2795, 380, 3026],
            [1, 1.0, 2810, 380, 3082],
        ],
    ),
    ColoredBananaGroup(
        group=147,
        map_id=Maps.AngryAztec,
        name="Ridge between Llama temple and 5DT",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 2717, 400, 3536]],
    ),
    ColoredBananaGroup(
        group=148,
        map_id=Maps.AngryAztec,
        name="On the roof of the 5DT",
        konglist=[Kongs.diddy],
        region=Regions.AngryAztecMain,
        logic=lambda l: l.jetpack,
        locations=[[1, 1.0, 2133, 386, 3726], [1, 1.0, 2148, 386, 3694], [1, 1.0, 2163, 386, 3662], [1, 1.0, 2177, 386, 3631], [1, 1.0, 2192, 386, 3599]],
    ),
    ColoredBananaGroup(
        group=149,
        map_id=Maps.AngryAztec,
        name="Around sealed quicksand tunnel warp 5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AztecDonkeyQuicksandCave,
        locations=[
            [1, 1.0, 2826, 120, 4766],
            [1, 1.0, 2807, 120, 4711],
            [1, 1.0, 2749, 120, 4711],
            [1, 1.0, 2730, 120, 4766],
            [1, 1.0, 2778, 120, 4801],
        ],
    ),
    ColoredBananaGroup(
        group=150,
        map_id=Maps.AztecDonkey5DTemple,
        name="Dead end corners",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTempleDeadEndRight,
        locations=[[1, 1.0, 66, 20, 263], [1, 1.0, 69, 29, 263], [1, 1.0, 66, 38, 263], [1, 1.0, 63, 46, 263], [1, 1.0, 66, 55, 263]],
    ),
    ColoredBananaGroup(
        group=150,
        map_id=Maps.AztecDonkey5DTemple,
        name="Dead end corners",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTemple,
        logic=lambda l: l.coconut,
        locations=[[1, 1.0, 1079, 57, 777], [1, 1.0, 1082, 66, 777], [1, 1.0, 1079, 75, 777], [1, 1.0, 1076, 83, 777], [1, 1.0, 1079, 92, 777]],
    ),  # These two are linked for region reasons
    ColoredBananaGroup(
        group=151,
        map_id=Maps.AztecDonkey5DTemple,
        name="Stairs",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTemple,
        logic=lambda l: l.coconut,
        locations=[[1, 1.0, 726, 20, 446], [1, 1.0, 761, 29, 464], [1, 1.0, 726, 38, 483], [1, 1.0, 691, 48, 504], [1, 1.0, 726, 57, 523]],
    ),
    ColoredBananaGroup(
        group=152,
        map_id=Maps.AztecDonkey5DTemple,
        name="Near the GB",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTemple,
        logic=lambda l: l.coconut,
        locations=[[1, 1.0, 726, 20, 446], [1, 1.0, 761, 29, 464], [1, 1.0, 726, 38, 483], [1, 1.0, 691, 48, 504], [1, 1.0, 726, 57, 523]],
    ),
    ColoredBananaGroup(
        group=153,
        map_id=Maps.AztecDiddy5DTemple,
        name="Dead end corners",
        konglist=[Kongs.diddy],
        region=Regions.DiddyTemple,
        logic=lambda l: l.peanut,
        locations=[[1, 1.0, 1091, 20, 262], [1, 1.0, 1091, 29, 265], [1, 1.0, 1091, 38, 262], [1, 1.0, 1091, 46, 259], [1, 1.0, 1091, 55, 262]],
    ),
    ColoredBananaGroup(
        group=153,
        map_id=Maps.AztecDiddy5DTemple,
        name="Dead end corners",
        konglist=[Kongs.diddy],
        region=Regions.DiddyTempleDeadEndRight,
        locations=[[1, 1.0, 79, 57, 777], [1, 1.0, 79, 66, 780], [1, 1.0, 79, 75, 777], [1, 1.0, 79, 83, 774], [1, 1.0, 79, 92, 777]],
    ),  # These two are linked for region reasons
    ColoredBananaGroup(
        group=154,
        map_id=Maps.AztecDiddy5DTemple,
        name="Stairs",
        konglist=[Kongs.diddy],
        region=Regions.DiddyTemple,
        logic=lambda l: l.peanut,
        locations=[[1, 1.0, 433, 29, 466], [1, 1.0, 468, 38, 484], [1, 1.0, 433, 38, 485], [1, 1.0, 399, 38, 484], [1, 1.0, 433, 48, 505]],
    ),
    ColoredBananaGroup(
        group=155,
        map_id=Maps.AztecDiddy5DTemple,
        name="Near the GB",
        konglist=[Kongs.diddy],
        region=Regions.DiddyTemple,
        logic=lambda l: l.peanut,
        locations=[
            [1, 1.0, 752, 57, 837],
            [1, 1.0, 727, 57, 812],
            [1, 1.0, 702, 57, 837],
            [1, 1.0, 727, 57, 862],
            [1, 1.0, 770, 57, 862],
            [1, 1.0, 770, 57, 812],
            [1, 1.0, 727, 57, 787],
            [1, 1.0, 684, 57, 812],
            [1, 1.0, 684, 57, 862],
            [1, 1.0, 727, 57, 887],
        ],
    ),
    ColoredBananaGroup(
        group=156,
        map_id=Maps.AztecLanky5DTemple,
        name="Inner walls of the loop",
        konglist=[Kongs.lanky],
        region=Regions.LankyTemple,
        locations=[
            [1, 1.0, 601, 20, 443],
            [1, 1.0, 601, 28, 464],
            [1, 1.0, 604, 34, 484],
            [1, 1.0, 605, 41, 504],
            [1, 1.0, 608, 47, 527],
            [1, 1.0, 319, 20, 444],
            [1, 1.0, 317, 28, 464],
            [1, 1.0, 315, 34, 486],
            [1, 1.0, 315, 41, 505],
            [1, 1.0, 312, 47, 527],
        ],
    ),
    ColoredBananaGroup(
        group=157,
        map_id=Maps.AztecLanky5DTemple,
        name="Center stairs",
        konglist=[Kongs.lanky],
        region=Regions.LankyTemple,
        locations=[
            [1, 1.0, 505, 66, 840],
            [1, 1.0, 415, 66, 840],
            [1, 1.0, 437, 56, 819],
            [1, 1.0, 482, 56, 819],
            [1, 1.0, 460, 76, 861],
        ],
    ),
    ColoredBananaGroup(
        group=158,
        map_id=Maps.AztecLanky5DTemple,
        name="Near the GB",
        konglist=[Kongs.lanky],
        region=Regions.LankyTemple,
        logic=lambda l: l.grape,
        locations=[
            [1, 1.0, 170, 85, 1149],
            [1, 1.0, 183, 85, 1142],
            [1, 1.0, 157, 85, 1142],
            [1, 1.0, 170, 85, 1164],
            [1, 1.0, 196, 85, 1134],
            [1, 1.0, 144, 85, 1134],
            [1, 1.0, 170, 85, 1179],
            [1, 1.0, 209, 85, 1127],
            [1, 1.0, 131, 85, 1127],
            [1, 1.0, 170, 85, 1194],
        ],
    ),
    ColoredBananaGroup(
        group=159, map_id=Maps.AztecTiny5DTemple, name="Useless Mini room", konglist=[Kongs.tiny], region=Regions.TinyTemple, logic=lambda l: l.mini, locations=[[5, 1.0, 230, 48, 608]]
    ),
    ColoredBananaGroup(group=160, map_id=Maps.AztecTiny5DTemple, name="Under the right Mini barrel", konglist=[Kongs.tiny], region=Regions.TinyTemple, locations=[[5, 1.0, 362, 52, 716]]),
    ColoredBananaGroup(group=161, map_id=Maps.AztecTiny5DTemple, name="Above the left Mini barrel", konglist=[Kongs.tiny], region=Regions.TinyTemple, locations=[[5, 1.0, 921, 95, 728]]),
    ColoredBananaGroup(
        group=162,
        map_id=Maps.AztecTiny5DTemple,
        name="Center stairs",
        konglist=[Kongs.tiny],
        region=Regions.TinyTemple,
        locations=[[1, 1.0, 670, 56, 820], [1, 1.0, 610, 56, 820], [1, 1.0, 640, 66, 840], [1, 1.0, 670, 76, 860], [1, 1.0, 610, 76, 860]],
    ),
    ColoredBananaGroup(
        group=163,
        map_id=Maps.AztecTiny5DTemple,
        name="Near the GB",
        konglist=[Kongs.tiny],
        region=Regions.TinyTemple,
        logic=lambda l: l.feather,
        locations=[
            [1, 1.0, 956, 85, 1163],
            [1, 1.0, 956, 94, 1160],
            [1, 1.0, 956, 103, 1163],
            [1, 1.0, 956, 111, 1166],
            [1, 1.0, 956, 120, 1163],
            [1, 1.0, 975, 85, 1169],
            [1, 1.0, 968, 85, 1147],
            [1, 1.0, 944, 85, 1147],
            [1, 1.0, 937, 85, 1169],
            [1, 1.0, 956, 85, 1183],
        ],
    ),
    ColoredBananaGroup(
        group=164,
        map_id=Maps.AztecChunky5DTemple,
        name="On both stairs",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTemple,
        locations=[[1, 1.0, 669, 56, 820], [1, 1.0, 610, 56, 820], [1, 1.0, 640, 76, 860], [1, 1.0, 684, 103, 1710], [1, 1.0, 596, 103, 1710]],
    ),
    ColoredBananaGroup(
        group=165,
        map_id=Maps.AztecChunky5DTemple,
        name="Near the dirt patch",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTemple,
        locations=[[1, 1.0, 639, 85, 1489], [1, 1.0, 639, 94, 1486], [1, 1.0, 639, 103, 1489], [1, 1.0, 639, 111, 1492], [1, 1.0, 639, 120, 1489]],
    ),
    ColoredBananaGroup(
        group=166,
        map_id=Maps.AztecChunky5DTemple,
        name="Final pineapple switch stairs",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTemple,
        logic=lambda l: l.pineapple,
        locations=[
            [1, 1.0, 1108, 141, 2073],
            [1, 1.0, 1105, 150, 2073],
            [1, 1.0, 1108, 159, 2073],
            [1, 1.0, 1111, 167, 2073],
            [1, 1.0, 1108, 176, 2073],
            [1, 1.0, 1108, 141, 2142],
            [1, 1.0, 1111, 150, 2142],
            [1, 1.0, 1108, 159, 2142],
            [1, 1.0, 1105, 167, 2142],
            [1, 1.0, 1108, 176, 2142],
        ],
    ),
    ColoredBananaGroup(
        group=167,
        map_id=Maps.AztecChunky5DTemple,
        name="Near the GB",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTemple,
        logic=lambda l: l.pineapple,
        locations=[
            [1, 1.0, 353, 122, 2098],
            [1, 1.0, 344, 122, 2070],
            [1, 1.0, 314, 122, 2070],
            [1, 1.0, 305, 122, 2098],
            [1, 1.0, 329, 122, 2115],
            [1, 1.0, 377, 137, 2105],
            [1, 1.0, 358, 137, 2050],
            [1, 1.0, 300, 137, 2050],
            [1, 1.0, 281, 137, 2105],
            [1, 1.0, 329, 137, 2140],
        ],
    ),
    ColoredBananaGroup(group=168, map_id=Maps.AztecChunky5DTemple, name="Straight after the first stairs", konglist=[Kongs.chunky], region=Regions.ChunkyTemple, locations=[[5, 1.0, 640, 100, 1253]]),
    ColoredBananaGroup(
        group=169,
        map_id=Maps.AztecLlamaTemple,
        name="Entrance sides",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[
            [1, 1.0, 2788, 540, 2332],
            [1, 1.0, 2788, 550, 2335],
            [1, 1.0, 2788, 560, 2332],
            [1, 1.0, 2788, 570, 2329],
            [1, 1.0, 2788, 580, 2332],
            [1, 1.0, 2788, 540, 2467],
            [1, 1.0, 2788, 550, 2470],
            [1, 1.0, 2788, 560, 2467],
            [1, 1.0, 2788, 570, 2464],
            [1, 1.0, 2788, 580, 2467],
        ],
    ),
    ColoredBananaGroup(
        group=170,
        map_id=Maps.AztecLlamaTemple,
        name="Pool corners",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[
            [1, 1.0, 2427, 371, 2705],
            [1, 1.0, 2427, 381, 2708],
            [1, 1.0, 2427, 391, 2705],
            [1, 1.0, 2427, 401, 2702],
            [1, 1.0, 2427, 411, 2705],
            [1, 1.0, 2427, 371, 2098],
            [1, 1.0, 2427, 381, 2095],
            [1, 1.0, 2427, 391, 2098],
            [1, 1.0, 2427, 401, 2103],
            [1, 1.0, 2427, 411, 2098],
        ],
    ),
    ColoredBananaGroup(
        group=171,
        map_id=Maps.AztecLlamaTemple,
        name="Around the melon crate",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[
            [1, 1.0, 2663, 371, 2459],
            [1, 1.0, 2682, 371, 2434],
            [1, 1.0, 2682, 371, 2404],
            [1, 1.0, 2663, 371, 2379],
            [1, 1.0, 2634, 371, 2369],
            [1, 1.0, 2605, 371, 2379],
            [1, 1.0, 2586, 371, 2404],
            [1, 1.0, 2586, 371, 2434],
            [1, 1.0, 2605, 371, 2459],
            [1, 1.0, 2634, 371, 2469],
        ],
    ),
    ColoredBananaGroup(
        group=172,
        map_id=Maps.AztecLlamaTemple,
        name="Around the trombone pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[[1, 1.0, 2349, 458, 3179], [1, 1.0, 2323, 458, 3250], [1, 1.0, 2267, 458, 3275], [1, 1.0, 2203, 458, 3252], [1, 1.0, 2176, 458, 3185]],
    ),
    ColoredBananaGroup(
        group=173,
        map_id=Maps.AztecLlamaTemple,
        name="On the extended dinosnakes",
        konglist=[Kongs.lanky],
        region=Regions.LlamaTemple,
        logic=lambda l: l.handstand and l.trombone,
        locations=[
            [1, 1.0, 2220, 535, 2514],
            [1, 1.0, 2220, 518, 2555],
            [1, 1.0, 2220, 499, 2573],
            [1, 1.0, 2220, 483, 2590],
            [1, 1.0, 2220, 464, 2610],
            [1, 1.0, 2222, 535, 2285],
            [1, 1.0, 2222, 516, 2245],
            [1, 1.0, 2222, 500, 2229],
            [1, 1.0, 2222, 482, 2211],
            [1, 1.0, 2222, 464, 2192],
        ],
    ),
    ColoredBananaGroup(
        group=174,
        map_id=Maps.AztecLlamaTemple,
        name="Behind the bongo pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[[1, 1.0, 2173, 458, 1471], [1, 1.0, 2215, 458, 1471], [1, 1.0, 2257, 458, 1471], [1, 1.0, 2298, 458, 1471], [1, 1.0, 2340, 458, 1471]],
    ),
    ColoredBananaGroup(
        group=175,
        map_id=Maps.AztecLlamaTemple,
        name="Surface of the pool",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        logic=lambda l: Events.AztecLlamaSpit in l.Events,
        locations=[
            [1, 1.0, 2264, 328, 2449],
            [1, 1.0, 2288, 328, 2416],
            [1, 1.0, 2288, 328, 2376],
            [1, 1.0, 2264, 328, 2343],
            [1, 1.0, 2226, 328, 2331],
            [1, 1.0, 2188, 328, 2343],
            [1, 1.0, 2164, 328, 2376],
            [1, 1.0, 2164, 328, 2416],
            [1, 1.0, 2188, 328, 2449],
            [1, 1.0, 2226, 328, 2461],
        ],
    ),
    ColoredBananaGroup(
        group=176,
        map_id=Maps.AztecLlamaTemple,
        name="Surface of the pool but bigger",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        logic=lambda l: Events.AztecLlamaSpit in l.Events,
        locations=[
            [1, 1.0, 2302, 328, 2501],
            [1, 1.0, 2350, 328, 2436],
            [1, 1.0, 2350, 328, 2356],
            [1, 1.0, 2302, 328, 2291],
            [1, 1.0, 2226, 328, 2266],
            [1, 1.0, 2150, 328, 2291],
            [1, 1.0, 2102, 328, 2356],
            [1, 1.0, 2102, 328, 2436],
            [1, 1.0, 2150, 328, 2501],
            [1, 1.0, 2226, 328, 2526],
        ],
    ),
    ColoredBananaGroup(
        group=177,
        map_id=Maps.AztecLlamaTemple,
        name="On the sealed quicksand tunnel switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[[5, 1.0, 1659, 442, 1766]],
    ),
    ColoredBananaGroup(
        group=178,
        map_id=Maps.AztecLlamaTemple,
        name="On the llama's head",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[[5, 1.0, 2003, 570, 2402]],
    ),
    ColoredBananaGroup(
        group=179,
        map_id=Maps.AztecLlamaTemple,
        name="Along the walls behind the llama",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[
            [1, 1.0, 1755, 472, 2343],
            [1, 1.0, 1752, 482, 2343],
            [1, 1.0, 1755, 492, 2343],
            [1, 1.0, 1758, 502, 2343],
            [1, 1.0, 1755, 512, 2343],
            [1, 1.0, 1755, 472, 2457],
            [1, 1.0, 1752, 482, 2457],
            [1, 1.0, 1755, 492, 2457],
            [1, 1.0, 1758, 502, 2457],
            [1, 1.0, 1755, 512, 2457],
        ],
    ),
    ColoredBananaGroup(
        group=180,
        map_id=Maps.AztecLlamaTemple,
        name="In front of the matching game door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[[1, 1.0, 1334, 641, 2467], [1, 1.0, 1334, 641, 2434], [1, 1.0, 1334, 641, 2401], [1, 1.0, 1334, 641, 2369], [1, 1.0, 1334, 641, 2336]],
    ),
    ColoredBananaGroup(
        group=181,
        map_id=Maps.AztecLlamaTemple,
        name="Twirl above the llama",
        konglist=[Kongs.tiny],
        region=Regions.LlamaTemple,
        logic=lambda l: l.twirl,
        locations=[[1, 1.1, 1914, 672, 2400], [1, 1.1, 1984, 665, 2400], [1, 1.1, 2051, 656, 2400], [1, 1.1, 2114, 625, 2400], [1, 1.1, 2180, 557, 2400]],
    ),
    ColoredBananaGroup(
        group=182,
        map_id=Maps.AztecLlamaTemple,
        name="Matching game switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTempleMatching,
        locations=[[1, 1.0, 959, 645, 2395], [1, 1.0, 959, 655, 2392], [1, 1.0, 959, 665, 2395], [1, 1.0, 959, 675, 2398], [1, 1.0, 959, 685, 2395]],
    ),
    ColoredBananaGroup(
        group=183,
        map_id=Maps.AztecLlamaTemple,
        name="Towards the matching game switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTempleMatching,
        locations=[[1, 1.0, 1267, 641, 2398], [1, 1.0, 1200, 641, 2397], [1, 1.0, 1132, 641, 2396], [1, 1.0, 1065, 641, 2396], [1, 1.0, 998, 641, 2395]],
    ),
    ColoredBananaGroup(
        group=184,
        map_id=Maps.AztecLlamaTemple,
        name="On the mini tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        locations=[[5, 1.0, 1578, 480, 3187]],
    ),
    ColoredBananaGroup(
        group=185,
        map_id=Maps.AztecLlamaTemple,
        name="On the lava pedestals first switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTempleBack,
        locations=[[1, 1.0, 1293, 424, 3682], [1, 1.0, 1293, 434, 3685], [1, 1.0, 1293, 444, 3682], [1, 1.0, 1293, 454, 3679], [1, 1.0, 1293, 464, 3682]],
    ),
    ColoredBananaGroup(
        group=186,
        map_id=Maps.AztecLlamaTemple,
        name="Lower ledge of the pedestal switch platforms",
        konglist=[Kongs.tiny],
        region=Regions.LlamaTempleBack,
        logic=lambda l: (l.CanSlamSwitch(Levels.AngryAztec, 1) or (l.twirl and l.monkey_maneuvers)),
        locations=[
            [1, 1.0, 1533, 420, 4046],
            [1, 1.0, 1485, 420, 4019],
            [1, 1.0, 1443, 420, 3994],
            [1, 1.0, 1413, 420, 4046],
            [1, 1.0, 1383, 420, 4099],
            [1, 1.0, 882, 420, 3810],
            [1, 1.0, 911, 420, 3757],
            [1, 1.0, 942, 420, 3705],
            [1, 1.0, 900, 420, 3680],
            [1, 1.0, 853, 420, 3656],
        ],
    ),
    ColoredBananaGroup(
        group=187,
        map_id=Maps.AztecLlamaTemple,
        name="Passage towards Lanky's cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        logic=lambda l: (((Events.AztecLlamaSpit in l.Events or (l.CanPhaseswim() and l.settings.damage_amount != DamageAmount.ohko) and l.swim)) or l.CanPhase()),
        locations=[[5, 1.0, 2221, 208, 2036]],
    ),
    ColoredBananaGroup(
        group=188,
        map_id=Maps.AztecLlamaTemple,
        name="In front of Lanky's cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        logic=lambda l: (Events.AztecLlamaSpit in l.Events and l.swim) or (l.CanPhaseswim() and l.settings.damage_amount != DamageAmount.ohko) or l.CanPhase(),
        locations=[
            [1, 1.0, 2238, 302, 1721],
            [1, 1.0, 2227, 302, 1688],
            [1, 1.0, 2191, 302, 1688],
            [1, 1.0, 2180, 302, 1721],
            [1, 1.0, 2209, 302, 1742],
        ],
    ),
    ColoredBananaGroup(
        group=189,
        map_id=Maps.AztecTinyTemple,
        name="Entrance",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        locations=[
            [1, 1.0, 1196, 310, 891],
            [1, 1.0, 1196, 320, 894],
            [1, 1.0, 1196, 330, 891],
            [1, 1.0, 1196, 340, 888],
            [1, 1.0, 1196, 350, 891],
            [1, 1.0, 1196, 310, 807],
            [1, 1.0, 1196, 320, 804],
            [1, 1.0, 1196, 330, 807],
            [1, 1.0, 1196, 340, 810],
            [1, 1.0, 1196, 350, 807],
        ],
    ),
    ColoredBananaGroup(
        group=190,
        map_id=Maps.AztecTinyTemple,
        name="Around the pool",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        locations=[
            [1, 1.0, 1339, 290, 740],
            [1, 1.0, 1419, 290, 740],
            [1, 1.0, 1499, 290, 740],
            [1, 1.0, 1579, 290, 740],
            [1, 1.0, 1579, 290, 959],
            [1, 1.0, 1499, 290, 959],
            [1, 1.0, 1419, 290, 959],
            [1, 1.0, 1339, 290, 959],
            [1, 1.0, 1339, 290, 850],
            [1, 1.0, 1579, 290, 850],
        ],
    ),
    ColoredBananaGroup(
        group=191,
        map_id=Maps.AztecTinyTemple,
        name="Stairs near Mini barrel",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        locations=[[1, 1.0, 1792, 308, 990], [1, 1.0, 1767, 308, 1015], [1, 1.0, 1742, 309, 1039], [1, 1.0, 1717, 309, 1064], [1, 1.0, 1692, 309, 1088]],
    ),
    ColoredBananaGroup(
        group=192,
        map_id=Maps.AztecTinyTemple,
        name="Diddy switch",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        locations=[[1, 1.0, 1416, 294, 1040], [1, 1.0, 1413, 304, 1040], [1, 1.0, 1416, 314, 1040], [1, 1.0, 1419, 324, 1040], [1, 1.0, 1416, 334, 1040]],
    ),
    ColoredBananaGroup(
        group=193,
        map_id=Maps.AztecTinyTemple,
        name="Klaptrap room peek spot",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        locations=[[5, 1.2, 1680, 220, 320]],
    ),
    ColoredBananaGroup(
        group=194,
        map_id=Maps.AztecTinyTemple,
        name="Middle of the underwater square room",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleUnderwater,
        locations=[
            [1, 1.0, 1504, 128, 1520],
            [1, 1.0, 1526, 128, 1490],
            [1, 1.0, 1526, 128, 1452],
            [1, 1.0, 1504, 128, 1422],
            [1, 1.0, 1469, 128, 1411],
            [1, 1.0, 1434, 128, 1422],
            [1, 1.0, 1412, 128, 1452],
            [1, 1.0, 1412, 128, 1490],
            [1, 1.0, 1434, 128, 1520],
            [1, 1.0, 1469, 128, 1531],
        ],
    ),
    ColoredBananaGroup(
        group=195,
        map_id=Maps.AztecTinyTemple,
        name="In the Tiny cage room",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleKONGRoom,
        locations=[
            [1, 1.0, 505, 344, 1578],
            [1, 1.0, 545, 344, 1523],
            [1, 1.0, 545, 344, 1455],
            [1, 1.0, 505, 344, 1400],
            [1, 1.0, 440, 344, 1379],
            [1, 1.0, 375, 344, 1400],
            [1, 1.0, 335, 344, 1455],
            [1, 1.0, 335, 344, 1523],
            [1, 1.0, 375, 344, 1578],
            [1, 1.0, 440, 344, 1599],
            [1, 1.0, 492, 344, 1506],
            [1, 1.0, 472, 344, 1445],
            [1, 1.0, 408, 344, 1445],
            [1, 1.0, 388, 344, 1506],
            [1, 1.0, 440, 344, 1544],
        ],
    ),
    ColoredBananaGroup(
        group=196,
        map_id=Maps.AztecTinyTemple,
        name="In the O of KONG",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleKONGRoom,
        locations=[[5, 1.0, 106, 406, 1342]],
    ),
]

BalloonList = [
    Balloon(
        id=1,
        map_id=Maps.AngryAztec,
        name="Chunky vase room back wall",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        logic=lambda l: l.pineapple,
        points=[[98, 195, 644], [38, 195, 592], [136, 195, 487], [38, 195, 592]],
    ),
    Balloon(
        id=2,
        map_id=Maps.AngryAztec,
        name="Chunky vase room right wall",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        logic=lambda l: l.pineapple,
        points=[[558, 195, 455], [527, 195, 587], [493, 195, 704]],
    ),
    Balloon(
        id=3,
        map_id=Maps.AngryAztec,
        name="DK BP room over/under bridge",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.AztecBlueprintDoor, False),
        points=[[1380, 190, 735], [1380, 160, 800], [1380, 130, 735], [1380, 160, 670]],
    ),
    Balloon(
        id=4,
        map_id=Maps.AngryAztec,
        name="Oasis",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        points=[[2382, 240, 908], [2413, 240, 1055], [2524, 240, 942]],
    ),
    Balloon(
        id=5,
        map_id=Maps.AngryAztec,
        name="In front of Candy",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        points=[[2313, 220, 514], [2430, 220, 509]],
    ),
    Balloon(
        id=6,
        map_id=Maps.AngryAztec,
        name="Behind Tiny Temple",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        points=[[3216, 300, 461], [3361, 300, 646]],
    ),
    Balloon(
        id=7,
        map_id=Maps.AngryAztec,
        name="Behind Llama cage high up",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        points=[[2103, 450, 1736], [1959, 450, 1565]],
    ),
    Balloon(
        id=8,
        map_id=Maps.AngryAztec,
        name="Rising from quicksand near oasis",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        points=[[2218, 50, 1087], [2225, 80, 1080], [2230, 110, 1085], [2223, 140, 1092]],
    ),
    Balloon(
        id=9,
        map_id=Maps.AngryAztec,
        name="Near Hunky Chunky barrel",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecConnectorTunnel,
        points=[
            [3168, 185, 1580],
            [3216, 185, 1460],
            [3323, 185, 1468],
            [3380, 185, 1579],
            [3323, 185, 1468],
            [3216, 185, 1460],
        ],
    ),
    Balloon(
        id=10,
        map_id=Maps.AngryAztec,
        name="Cranky snake path left side",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecConnectorTunnel,
        points=[[3353, 180, 2186], [3363, 180, 2342], [3275, 180, 2434]],
    ),
    Balloon(
        id=11,
        map_id=Maps.AngryAztec,
        name="Around giant boulder",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecConnectorTunnel,
        points=[[3577, 180, 2483], [3501, 180, 2414], [3602, 180, 2311], [3501, 180, 2414]],
    ),
    Balloon(
        id=12,
        map_id=Maps.AngryAztec,
        name="Behind Beetle Race Tower high up",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[4265, 400, 2854], [4558, 405, 2912], [4722, 410, 3172], [4558, 415, 2912]],
    ),
    Balloon(
        id=13,
        map_id=Maps.AngryAztec,
        name="In front of Snide's",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[4060, 230, 4400], [4110, 210, 4531], [4128, 220, 4426], [4152, 200, 4300]],
    ),
    Balloon(
        id=14,
        map_id=Maps.AngryAztec,
        name="Around feed me totem",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[
            [3386, 200, 3944],
            [3428, 204, 3808],
            [3290, 196, 3696],
            [3136, 200, 3772],
            [3156, 192, 3940],
            [3314, 204, 4002],
        ],
    ),
    Balloon(
        id=15,
        map_id=Maps.AngryAztec,
        name="Right side of 5DT",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[2331, 400, 3430], [2084, 410, 3276]],
    ),
    Balloon(
        id=16,
        map_id=Maps.AngryAztec,
        name="Spiral around tree left side of 5DT",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[
            [1913, 140, 4070],
            [1938, 160, 4105],
            [1878, 180, 4118],
            [1852, 200, 4068],
            [1913, 220, 4070],
            [1938, 200, 4105],
            [1878, 180, 4118],
            [1852, 160, 4068],
        ],
    ),
    Balloon(
        id=17,
        map_id=Maps.AztecDonkey5DTemple,
        name="First dead end",
        speed=5,
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTempleDeadEndRight,
        points=[[264, 60, 301], [130, 65, 322], [83, 60, 474], [130, 65, 322]],
    ),
    Balloon(
        id=18,
        map_id=Maps.AztecLanky5DTemple,
        name="Dead end",
        speed=6,
        konglist=[Kongs.lanky],
        region=Regions.LankyTemple,
        points=[[626, 125, 1166], [612, 95, 1187], [756, 120, 1134], [755, 125, 1028], [756, 120, 1134]],
    ),
    Balloon(
        id=19,
        map_id=Maps.AztecTiny5DTemple,
        name="Dead end",
        speed=5,
        konglist=[Kongs.tiny],
        region=Regions.TinyTemple,
        points=[[355, 120, 1282], [305, 120, 1282]],
    ),
    Balloon(
        id=20,
        map_id=Maps.AztecTinyTemple,
        name="Mini Monkey alcove",
        speed=5,
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        points=[[1822, 460, 1056], [1756, 465, 1119]],
    ),
    Balloon(
        id=21,
        map_id=Maps.AztecLlamaTemple,
        name="Matching game room right side",
        speed=4,
        konglist=[Kongs.lanky],
        region=Regions.LlamaTempleMatching,
        points=[[1144, 760, 2142], [795, 810, 2142]],
    ),
    Balloon(
        id=22,
        map_id=Maps.AztecLlamaTemple,
        name="Above Llama",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        points=[[2100, 760, 2180], [2100, 760, 2620]],
    ),
    Balloon(
        id=23,
        map_id=Maps.AztecLlamaTemple,
        name="Lava room",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTempleBack,
        points=[[948, 490, 3779], [1058, 480, 4098], [1326, 490, 3994], [1214, 510, 3826]],
    ),
    Balloon(
        id=24,
        map_id=Maps.AztecTinyTemple,
        name="Tiny's room (Tiny)",
        speed=3,
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleKONGRoom,
        vanilla=True,
        points=[[484, 500, 1582], [443, 422, 1418], [448, 504, 1231]],
    ),
    Balloon(
        id=25,
        map_id=Maps.AztecTinyTemple,
        name="Tiny's room (Tiny)",
        speed=3,
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleKONGRoom,
        vanilla=True,
        points=[[312, 454, 1413], [480, 416, 1369], [662, 462, 1393]],
    ),
    Balloon(
        id=26,
        map_id=Maps.AztecTinyTemple,
        name="Vulture room (Chunky)",
        speed=4,
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleVultureRoom,
        vanilla=True,
        points=[[1397, 535, 2043], [1571, 535, 2053]],
    ),
    Balloon(
        id=27,
        map_id=Maps.AztecLlamaTemple,
        name="Above lava/water (Tiny)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        vanilla=True,
        points=[[2295, 500, 2624], [2309, 496, 2452], [2326, 502, 2186]],
    ),
    Balloon(
        id=28,
        map_id=Maps.AztecLlamaTemple,
        name="In Lanky's room (Lanky)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        vanilla=True,
        logic=lambda l: (Events.AztecLlamaSpit in l.Events and l.swim) or (l.CanPhaseswim() and l.settings.damage_amount != DamageAmount.ohko) or l.CanPhase(),
        points=[[2308, 337, 1930], [2141, 330, 1906]],
    ),
    Balloon(
        id=29,
        map_id=Maps.AztecLlamaTemple,
        name="In Lanky's room (Lanky)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        vanilla=True,
        logic=lambda l: (Events.AztecLlamaSpit in l.Events and l.swim) or (l.CanPhaseswim() and l.settings.damage_amount != DamageAmount.ohko) or l.CanPhase(),
        points=[[2281, 347, 1826], [2298, 328, 1928], [2093, 322, 1926], [2065, 332, 1837]],
    ),
    Balloon(
        id=30,
        map_id=Maps.AztecDiddy5DTemple,
        name="Right side (Diddy)",
        speed=5,
        konglist=[Kongs.diddy],
        region=Regions.DiddyTemple,
        vanilla=True,
        points=[[104, 105, 948], [107, 109, 884], [125, 105, 790], [189, 105, 847], [210, 109, 791]],
    ),
    Balloon(
        id=31,
        map_id=Maps.AztecLanky5DTemple,
        name="Middle (Lanky)",
        speed=7,
        konglist=[Kongs.lanky],
        region=Regions.LankyTemple,
        vanilla=True,
        points=[[748, 95, 653], [557, 95, 629], [405, 99, 710], [248, 93, 625]],
    ),
    Balloon(
        id=32,
        map_id=Maps.AztecChunky5DTemple,
        name="Left side (Chunky)",
        speed=6,
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTemple,
        vanilla=True,
        points=[
            [887, 137, 1548],
            [986, 125, 1530],
            [806, 129, 1480],
            [982, 133, 1376],
            [828, 123, 1269],
            [952, 127, 1225],
            [893, 123, 1138],
            [840, 129, 1211],
            [935, 123, 1293],
        ],
    ),
    Balloon(
        id=33,
        map_id=Maps.AztecChunky5DTemple,
        name="Right side (Chunky)",
        speed=5,
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTemple,
        vanilla=True,
        points=[[376, 123, 1522], [302, 129, 1347], [459, 127, 1340], [312, 131, 1193]],
    ),
    Balloon(
        id=34,
        map_id=Maps.AngryAztec,
        name="Near Cranky's lab (right side) (Donkey)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        vanilla=True,
        points=[[2870, 169, 2606], [2984, 191, 2547], [3010, 187, 2463]],
    ),
    Balloon(
        id=35,
        map_id=Maps.AngryAztec,
        name="In front of Tiny Temple (Diddy)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        vanilla=True,
        points=[[2900, 279, 732], [3027, 281, 893]],
    ),
    Balloon(
        id=36,
        map_id=Maps.AngryAztec,
        name="Behind Llama Temple (Donkey)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        vanilla=True,
        points=[[2999, 297, 2676], [2862, 304, 2706], [2672, 286, 2751]],
    ),
    Balloon(
        id=37,
        map_id=Maps.AngryAztec,
        name="Near Cranky's Lab (left side) (Donkey)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        vanilla=True,
        points=[[2811, 196, 2402], [2873, 195, 2318], [2956, 189, 2247]],
    ),
    Balloon(
        id=38,
        map_id=Maps.AngryAztec,
        name="Sealed Quicksand Tunnel (Diddy)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AztecDonkeyQuicksandCave,
        vanilla=True,
        points=[[3083, 177, 4696], [3099, 174, 4790]],
    ),
    # Wave 2 by Snap
    Balloon(
        id=39,
        map_id=Maps.AngryAztec,
        name="Between the quicksand pits",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BetweenVinesByPortal,
        points=[[1154, 160, 1224], [934, 156, 1183], [823, 155, 1047], [791, 160, 563], [823, 155, 1047], [934, 156, 1183]],
    ),
    Balloon(
        id=40,
        map_id=Maps.AngryAztec,
        name="Oasis entrance",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        points=[[2061, 155, 825], [2074, 155, 933]],
    ),
    Balloon(
        id=41,
        map_id=Maps.AngryAztec,
        name="Quicksand near Candy",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        points=[[2248, 110, 612], [2362, 115, 656], [2458, 110, 599], [2362, 110, 656]],
    ),
    Balloon(
        id=42,
        map_id=Maps.AngryAztec,
        name="Around the llama's cage",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecOasis,
        points=[[2255, 290, 1573], [2137, 260, 1680], [2012, 236, 1547], [2127, 250, 1438]],
    ),
    Balloon(
        id=43,
        map_id=Maps.AngryAztec,
        name="Snake road",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[
            [3296, 20, 2106],
            [3265, 104, 2165],
            [3266, 126, 2261],
            [3288, 122, 2347],
            [3193, 130, 2371],
            [3100, 120, 2301],
            [3021, 138, 2331],
            [2964, 138, 2444],
            [2954, 120, 2528],
            [2872, 104, 2538],
            [2786, 20, 2527],
        ],
    ),
    Balloon(
        id=44,
        map_id=Maps.AngryAztec,
        name="Around the Hunky cage",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[4144, 196, 2315], [4341, 166, 2308], [4328, 180, 2518], [4121, 147, 2511]],
    ),
    Balloon(
        id=45,
        map_id=Maps.AngryAztec,
        name="Near the vulture cage",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[3829, 309, 4198], [3975, 345, 4309], [4056, 288, 4585]],
    ),
    Balloon(
        id=46,
        map_id=Maps.AngryAztec,
        name="Around warp 5",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[3537, 190, 4463], [3493, 200, 4557], [3401, 190, 4477], [3478, 150, 4420]],
    ),
    Balloon(
        id=47,
        map_id=Maps.AngryAztec,
        name="Poking in and out of the sealed quicksand tunnel",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[3212, 160, 4498], [3209, 150, 4277]],
    ),
    Balloon(
        id=48,
        map_id=Maps.AngryAztec,
        name="Trees in front of 5DT",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[2161, 200, 4037], [2147, 230, 3890], [2559, 165, 3798], [2446, 185, 3659]],
    ),
    Balloon(
        id=49,
        map_id=Maps.AngryAztec,
        name="In front of Llama temple",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[2852, 160, 3252], [2907, 400, 3163], [2993, 400, 3147], [3091, 160, 3189], [2993, 400, 3147], [2907, 400, 3163]],
    ),
    Balloon(
        id=50,
        map_id=Maps.AngryAztec,
        name="Quicksand near Rocketbarrel",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecMain,
        points=[[3865, 112, 3488], [3879, 250, 3607], [3886, 112, 3752], [3879, 0, 3488]],
    ),
    Balloon(
        id=51,
        map_id=Maps.AztecDonkey5DTemple,
        name="Path to the second coconut switch",
        speed=5,
        konglist=[Kongs.donkey],
        region=Regions.DonkeyTemple,
        points=[[759, 20, 310], [681, 50, 481], [766, 77, 619], [712, 90, 822]],
    ),
    Balloon(
        id=52,
        map_id=Maps.AztecDiddy5DTemple,
        name="Second peanut switch",
        speed=5,
        konglist=[Kongs.diddy],
        region=Regions.DiddyTemple,
        points=[[465, 57, 881], [433, 100, 880], [399, 57, 875], [433, 100, 880]],
    ),
    Balloon(
        id=53,
        map_id=Maps.AztecLanky5DTemple,
        name="Next to the GB",
        speed=5,
        konglist=[Kongs.lanky],
        region=Regions.LankyTemple,
        points=[[100, 85, 1028], [143, 122, 950], [210, 103, 991]],
    ),
    Balloon(
        id=54,
        map_id=Maps.AztecTiny5DTemple,
        name="Left side",
        speed=6,
        konglist=[Kongs.tiny],
        region=Regions.TinyTemple,
        points=[[808, 20, 330], [937, 80, 446], [800, 70, 629], [968, 90, 689]],
    ),
    Balloon(
        id=55,
        map_id=Maps.AztecChunky5DTemple,
        name="Kasplat room",
        speed=6,
        konglist=[Kongs.chunky],
        region=Regions.ChunkyTemple,
        points=[[1002, 156, 2062], [994, 156, 2140], [900, 156, 2141], [890, 156, 2035]],
    ),
    Balloon(
        id=56,
        map_id=Maps.AztecLlamaTemple,
        name="Entrance stairs",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        points=[[2593, 445, 1949], [2748, 540, 2154], [2703, 600, 2396], [2746, 555, 2635], [2598, 450, 2850], [2746, 555, 2635], [2703, 600, 2396], [2748, 540, 2154]],
    ),
    Balloon(
        id=57,
        map_id=Maps.AztecLlamaTemple,
        name="Left side behind the llama",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        points=[[1748, 530, 2629], [1849, 502, 2513], [1975, 380, 2654], [1849, 502, 2513]],
    ),
    Balloon(
        id=58,
        map_id=Maps.AztecLlamaTemple,
        name="Right side behind the llama",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        points=[[1841, 472, 2296], [1830, 509, 2141], [1654, 620, 2280]],
    ),
    Balloon(
        id=59,
        map_id=Maps.AztecLlamaTemple,
        name="Matching game",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTempleMatching,
        points=[[696, 666, 2510], [696, 860, 2510], [719, 640, 2292], [719, 888, 2292]],
    ),
    Balloon(
        id=60,
        map_id=Maps.AztecLlamaTemple,
        name="Mini tunnel room arch",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTemple,
        points=[[1835, 535, 2866], [1789, 603, 2860], [1693, 591, 2828], [1653, 540, 2779], [1693, 591, 2828], [1789, 603, 2860]],
    ),
    Balloon(
        id=61,
        map_id=Maps.AztecLlamaTemple,
        name="Splashing in the lava room",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LlamaTempleBack,
        points=[[1202, 400, 3985], [1128, 500, 3954], [1070, 402, 3886], [1168, 290, 3927]],
    ),
    Balloon(
        id=62,
        map_id=Maps.AztecTinyTemple,
        name="Near the Chunky klaptrap room",
        speed=5,
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        points=[[1604, 215, 321], [1655, 302, 394], [1639, 215, 491], [1655, 302, 394]],
    ),
    Balloon(
        id=63,
        map_id=Maps.AztecTinyTemple,
        name="Above the pool",
        speed=8,
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleStart,
        points=[[1489, 148, 806], [1490, 260, 810], [1451, 340, 899], [1421, 434, 830], [1428, 530, 807]],
    ),
    Balloon(
        id=64,
        map_id=Maps.AztecTinyTemple,
        name="Vulture path",
        speed=4,
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleVultureRoom,
        points=[[1472, 670, 2365], [1668, 670, 2234], [1282, 670, 2220], [1482, 670, 2078]],
    ),
    Balloon(
        id=65,
        map_id=Maps.AztecTinyTemple,
        name="KONG above the cage",
        speed=5,
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TempleKONGRoom,
        points=[[374, 470, 1115], [506, 470, 1115]],
    ),
]
