"""Model enum."""

from enum import IntEnum


class Model(IntEnum):
    """List of Model with in-game index."""

    Diddy = 0
    DiddyWithInstrument = 1
    DiddyLowPoly = 2
    DK = 3
    DKLowPoly = 4
    Lanky = 5
    LankyWithInstrument = 6
    LankyLowPoly = 7
    Tiny = 8
    TinyWithInstrument = 9
    TinyLowPoly = 10
    Chunky = 11
    ChunkyWithInstrument = 12
    ChunkyDisco = 13
    ChunkyLowPoly = 14
    ChunkyGone = 15
    Cranky = 16
    Funky = 17
    Candy = 18
    Rambi = 19
    Snake = 20
    Turtle = 21
    Seal = 22
    Enguarde = 23
    BeaverBlue_LowPoly = 24
    BeaverBlue = 25
    BeaverGold = 26
    Zinger = 27
    Squawks_28 = 28
    Klobber = 29
    Snide = 30
    Kaboom = 31
    KlaptrapGreen = 32
    KlaptrapPurple = 33
    KlaptrapRed = 34
    KlaptrapTeeth = 35
    MadJack = 36
    Krash = 37
    Troff = 38
    ToyMonster = 39
    SirDomino = 40
    MrDice_41 = 41
    Ruler = 42
    RoboKremling = 43
    Scoff = 44
    Beetle = 45
    KlaptrapUnk = 46
    NintendoLogo = 47
    Kremling = 48
    KoshKremlingRed = 49
    KoshKremling = 50
    MechanicalFish = 51
    ToyCar = 52
    GiantClam = 53
    Kasplat = 54
    ArmyDillo = 55
    MrDice_56 = 56
    Klump = 57
    Puftoss = 58
    Dogadon = 59
    BananaFairy = 60
    Llama = 61
    Guard = 62
    RoboZinger = 63
    Turntable = 64
    Krossbones = 65
    Shuri = 66
    Gimpfish = 67
    KLumsy = 68
    Spider = 69
    Rabbit = 70
    Beanstalk = 71
    KRoolCutscene = 72
    FireballWithGlasses = 73
    SkeletonHead = 74
    SkeletonHand = 75
    Vulture_76 = 76
    Vulture_77 = 77
    Bat = 78
    Skull = 79
    Tomato = 80
    Ghost = 81
    Fly = 82
    FlySwatter_83 = 83
    FlySwatter_84 = 84
    Owl = 85
    Book = 86
    ShipWheel = 87
    SpotlightFish = 88
    Puftup = 89
    Mermaid = 90
    Mushroom = 91
    ShockwaveMJ = 92
    Squawks_93 = 93
    Worm = 94
    CuckooBird = 95
    Kosha = 96
    IceTomato = 97
    ArmyDilloNoShell = 98
    Boombox = 99
    BLocker = 100
    EscapeShip = 101
    ArmyDilloCannon = 102
    KRoolFight = 103
    GoldenBanana_104 = 104
    Shockwave = 105
    KRoolGlove = 106
    KRoolFoot = 107
    KRoolToe_108 = 108
    KRoolToe_109 = 109
    KRoolToe_110 = 110
    Microphone = 111
    DeskKRool = 112
    Bell = 113
    ClapperBoard = 114
    Cannon_115 = 115
    Barrel_116 = 116
    BonusBarrel = 117
    HunkyChunkyBarrel = 118
    MiniMonkeyBarrel = 119
    Barrel_120 = 120
    PushableBox = 121
    TNTBarrelSpawner = 122
    Cannon_123 = 123
    TNTBarrel = 124
    RambiCrate = 125
    EnguardeCrate = 126
    Chain = 127
    SwingingLight_128 = 128
    Minecart = 129
    Barrel = 130
    BridgeCastle = 131
    LargeBrownBridge = 132
    Feather = 133
    Laser = 134
    GoldenBanana = 135
    Rocketbarrel = 136
    StrongKongBarrel = 137
    OrangstandSprintBarrel = 138
    DiddyJetpack = 139
    Photo = 140
    MinecartTNT = 141
    WindowScreen = 142
    BBBSlot_143 = 143
    BBBSlot_144 = 144
    BBBSlot_145 = 145
    BBBSlot_146 = 146
    BBBLever = 147
    PlayerCar = 148
    Missile = 149
    SwingingLight_150 = 150
    BananaporterZipper = 151
    Boulder = 152
    VaseCircle = 153
    VaseColon = 154
    VaseTriangle = 155
    VasePlus = 156
    ToyBox = 157
    Boat_158 = 158
    Padlock = 159
    CannonBall = 160
    Vine_161 = 161
    Vine_162 = 162
    Counter = 163
    Key = 164
    Bongos = 165
    DKStar = 166
    Spotlight = 167
    CannonSeasick = 168
    BoulderDebris = 169
    SpiderWeb = 170
    SteelKeg = 171
    Shockwave_172 = 172
    Shockwave_173 = 173
    BattleCrown = 174
    Buoy = 175
    BuoyGreen = 176
    Unknown = 177
    DKBananaCounter = 178
    DiddyBananaCounter = 179
    TinyBananaCounter = 180
    LankyBananaCounter = 181
    ChunkyBananaCounter = 182
    ShockwaveGreen_183 = 183
    Potion = 184
    ArmyDilloMissle = 185
    ShockwaveRed = 186
    IceWall = 187
    RarewareLogo = 188
    Stalactite = 189
    RockDebris = 190
    SpotlightBonus = 191
    TagBarrel = 192
    KrossbonesHead = 193
    Lever = 194
    KLumsyCage = 195
    IceTrapBubble = 196
    DiddyBarrelPad_1 = 197
    DiddyBarrelPad_2 = 198
    DiddyBarrelPad_3 = 199
    DiddyBarrelPad_4 = 200
    DiddyBarrelPad_5 = 201
    DiddyBarrelPad_6 = 202
    RaceCheckpoint = 203
    PadlockAndKey = 204
    FinishLine = 205
    ShockwaveGreen_206 = 206
    ShockwaveBlue = 207
    ShockwavePurple = 208
    QuestionMark = 209
    FlowerWithInstrument = 210
    DKLogoWithInstrument = 211
    GoldenBanana_212 = 212
    Apple = 213
    Barrel_214 = 214
    Flag_215 = 215
    Flag_216 = 216
    Boat_217 = 217
    Krusha = 218
    KingKutOutBody = 219
    KingKutOutHead = 220
    KingKutOutArm_221 = 221
    KingKutOutArm_222 = 222
    DirtPatch = 223
    Rope = 224
    DKSmokeTrail = 225
    Light = 226
    HelmBarrel = 227
    BananaPeel = 228
    BananaBarrel = 229
    TrainingBarrel = 230
    PiratePhoto = 231
    Butterfly = 232
    Barrel_233 = 233
    FunkyGun = 234
    Boot = 235


class Sprite(IntEnum):
    """Sprite Enum."""

    WaterfallTall = 0x8071FA80
    WaterfallShort = 0x8071FAAC
    Water = 0x8071FAD8
    Lava = 0x8071FAF0
    Sparkles = 0x8071FB08
    PopExplosion = 0x8071FB34
    LavaExplosion = 0x8071FB54
    Greenleaf = 0x8071FB88
    BrownSmokeExplosion = 0x8071FBA0
    SmallExplosion = 0x8071FBC8
    SolarFlare = 0x8071FBF4
    Splash = 0x8071FC0C
    Bubble = 0x8071FC40
    PurpleSparkle0 = 0x8071FC58
    YellowSparkle0 = 0x8071FC8C
    GreenSparkle0 = 0x8071FCC0
    PurpleSparkle1 = 0x8071FCF4
    YellowSparkle1 = 0x8071FD50
    GreenSparkle1 = 0x8071FDAC
    Largesmokeexplosion = 0x8071FE08
    Pinkimplosion = 0x8071FE3C
    BrownHorizontalSpinningPlank = 0x8071FE64
    BirchHorizontalSpinningPlank = 0x8071FE88
    BrownVerticalSpinningPlank = 0x8071FEAC
    StarWaterRipple = 0x8071FED0
    CircleWaterRipple = 0x8071FEF4
    SmallSmokeExplosion = 0x8071FF18
    StaticStar = 0x8071FF40
    StaticZ = 0x8071FF58
    Whiteflare = 0x8071FF70
    StaticRain0 = 0x8071FF88
    MediumSmokeExplosion = 0x8071FFA0
    BouncingMelon = 0x8071FFD4
    VerticalRollingMelon = 0x80720020
    RedFlare = 0x80720054
    Sparks = 0x8072006C
    Peanut = 0x807200A0
    Starflare = 0x807200D4
    Peanutshell = 0x807200EC
    Smallexplosion = 0x80720120
    Largesmokeimplosion = 0x8072014C
    Bluelazer = 0x80720180
    Pineapple = 0x807201A0
    Fireball = 0x807201D4
    Orange = 0x80720268
    Grape = 0x8072029C
    Grapesplatter = 0x807202D0
    TNTSparkle = 0x8072030C
    FireExplosion = 0x80720340
    SmallFireball = 0x8072038C
    DiddyCoin = 0x807203B0
    ChunkyCoin = 0x807203D4
    LankyCoin = 0x807203F8
    DKCoin = 0x8072041C
    TinyCoin = 0x80720440
    DKColouredBanana0 = 0x80720464
    Film = 0x80720488
    BouncingOrange = 0x807204BC
    CrystalCoconut0 = 0x80720508
    GB = 0x8072052C
    BananaMedal = 0x80720558
    DiddyColouredBanana = 0x8072057C
    ChunkyColouredBanana = 0x807205A0
    LankyColouredBanana = 0x807205C4
    DKColouredBanana1 = 0x807205E8
    TinyColouredBanana = 0x8072060C
    ExplodedKaboom = 0x80720630
    WhiteExplosion = 0x80720690
    Coconut = 0x807206A8
    CoconutShell = 0x807206DC
    SpinningWatermelonslice = 0x80720710
    Tooth = 0x8072073C
    AmmoCrate = 0x80720768
    RaceCoin = 0x807207BC
    LankyBP = 0x807207E0
    Cannonball = 0x80720804
    CrystalCoconut1 = 0x80720830
    Feather = 0x80720854
    GuitarGazump = 0x80720878
    Bongos = 0x80720890
    Saxophone = 0x807208A8
    Triangle = 0x807208C0
    Trombone = 0x807208D8
    WavingYellowDoubleEighthNote = 0x807208F0
    WavingYellowSingleEighthNote = 0x80720914
    WavingGreenSingleEighthNote = 0x80720938
    WavingPurpleDoubleEighthNote = 0x8072095C
    WavingRedDoubleEighthNote = 0x80720980
    WavingRedSingleEighthNote = 0x807209A4
    WavingWhiteDoubleEighthNote = 0x807209C8
    DiddyBP = 0x807209EC
    ChunkyBP = 0x80720A10
    DKBP = 0x80720A34
    TinyBP = 0x80720A58
    SpinningSparkle = 0x80720A7C
    StaticRain1 = 0x80720AA0
    TranslucentWater = 0x80720AB8
    Unk61 = 0x80720AD0
    BlackScreen = 0x80720AE8
    WhiteCloud = 0x80720B00
    ThinLazer = 0x80720B24
    BlueBubble = 0x80720B58
    Whitefadedcircle = 0x80720B70
    WhiteCircle = 0x80720B88
    GrapeParticle = 0x80720BA0
    SpinningBlueSparkle = 0x80720BC4
    WhiteSmokeExplosion = 0x80720BE8
    Joystick = 0x80720C34
    FireWall = 0x80720C64
    StaticRainBubble = 0x80720CD8
    AButton = 0x80720CF0
    BButton = 0x80720D14
    ZButton = 0x80720D38
    CDButton = 0x80720D5C
    CUutton = 0x80720D80
    CLButton = 0x80720DA4
    Acid = 0x80720DC8
    AcidExplosion = 0x80720DE0
    RaceHoop = 0x80720E14
    AcidGoop = 0x80720E2C
    Unk78 = 0x80720E44
    BrokenBridge = 0x80720E5C
    WhitePole = 0x80720E74
    BridgeChip = 0x80720E8C
    WoodenBeamwithrivets = 0x80720EA4
    ChunkyBunch = 0x80720EBC
    DiddyBunch = 0x80720EE8
    LankyBunch = 0x80720F14
    DKBunch = 0x80720F40
    TinyBunch = 0x80720F6C
    ChunkyBalloon = 0x80720F98
    DiddyBalloon = 0x80720FBC
    DKBalloon = 0x80720FE0
    LankyBalloon = 0x80721004
    TinyBalloon = 0x80721028
    RButton = 0x8072104C
    LButton = 0x80721070
    Fairy = 0x80721094
    BossKey = 0x807210B8
    Crown = 0x807210EC
    RarewareCoin = 0x80721110
    NintendoCoin = 0x80721134
    NoSymbol = 0x80721158
    Headphones = 0x80721170
    OpaqueBlueWater = 0x80721194
    StartButton = 0x807211AC
    Whitequestionmark = 0x807211D0
    Candyface = 0x80721200
    Crankyface = 0x8072121C
    SnideFace = 0x80721238
    FunkyFace = 0x80721250
    LeftArrow = 0x8072126C
    Whitespark = 0x80721298
    BlackBoulderChunk = 0x807212B0
    GreenBoulderChunk = 0x807212C8
    WoodChip = 0x807212E0
    Dandelion = 0x80721300
    StaticWater = 0x80721318
    Spinningleaf = 0x80721330
    FlashingWater = 0x80721358
    RainbowCoin = 0x80721378
    Shockwaveorangeparticle = 0x8072139C
    Implosion = 0x807213D0
    Rarewareemployeeface = 0x807213F4
    Smoke = 0x8072140C
    Staticsmoke = 0x8072142C
    Barrelbottomchunk = 0x80721444
    Scoffface = 0x8072145C
    MulticolouredBunch = 0x80721474
    DKFace = 0x807214A0
    DiddyFace = 0x807214B8
    LankyFace = 0x807214D0
    TinyFace = 0x807214E8
    ChunkyFace = 0x80721500
    FairyTick = 0x80721518
    Wrinkly = 0x80721530


ModelNames = [
    "Diddy",
    "Diddy (Instrument)",
    "Diddy (Low Poly)",
    "DK",
    "DK (Low Poly)",
    "Lanky",
    "Lanky (Instrument)",
    "Lanky (Low Poly)",
    "Tiny",
    "Tiny (Instrument)",
    "Tiny (Low Poly)",
    "Chunky",
    "Chunky (Instrument)",
    "Disco Chunky",
    "Chunky (Low Poly)",
    "Invisible Chunky",
    "Cranky",
    "Funky",
    "Candy",
    "Rambi",
    "Snake",
    "Turtle",
    "Seal",
    "Enguarde",
    "Beaver (Low Poly)",
    "Beaver",
    "Beaver (Gold)",
    "Zinger",
    "Squawks",
    "Klobber",
    "Snide",
    "Kaboom",
    "Klaptrap (Green)",
    "Klaptrap (Purple)",
    "Klaptrap (Red)",
    "Klaptrap (Teeth)",
    "Mad Jack",
    "Krash",
    "Troff",
    "Bad Hit Detection Man",
    "Sir Domino",
    "Mr. Dice",
    "Ruler",
    "Robo-Kremling",
    "Scoff",
    "Beetle",
    "Klaptrap (Teeth?)",
    "Nintendo Logo",
    "Kremling",
    "Kremling (Red - Kosh)",
    "Kremling (Green - Kosh)",
    "Mechanical Fish",
    "Toy Car",
    "Giant Clam",
    "Kasplat",
    "Army Dillo",
    "Mr. Dice",
    "Klump",
    "Puftoss",
    "Dogadon",
    "Banana Fairy",
    "Llama",
    "Guard",
    "Robo-Zinger",
    "Turntable",
    "Krossbones",
    "Shuri",
    "Gimpfish",
    "K. Lumsy",
    "Spider",
    "Rabbit",
    "Beanstalk",
    "K. Rool (Cutscene)",
    "Fireball (With Glasses)",
    "Skeleton Head",
    "Skeleton Hand",
    "Vulture (Race)",
    "Vulture (Shooting)",
    "Bat",
    "Skull",
    "Tomato",
    "Kritter-in-a-Sheet",
    "Fly",
    "Fly Swatter",
    "Fly Swatter",
    "Owl",
    "Book",
    "Ship's Wheel",
    "Spotlight Fish",
    "Puftup",
    "Mermaid",
    "Mushroom",
    "Shockwave (Mad Jack)",
    "Squawks",
    "Worm (apple)",
    "Cuckoo Bird",
    "Kosha",
    "Ice Tomato",
    "Army Dillo (No Shell)",
    "Boombox",
    "B. Locker",
    "Escape Ship",
    "Army Dillo's Cannon",
    "K. Rool (Fight)",
    "Golden Banana",
    "Shockwave",
    "K. Rool's Glove",
    "K. Rool's Foot",
    "K. Rool's Toe",
    "K. Rool's Toe",
    "K. Rool's Toe",
    "Microphone",
    "Desk (K. Rool)",
    "Bell",
    "Clapper Board",
    "Cannon",
    "Barrel?",
    "Bonus Barrel",
    "Hunky Chunky Barrel",
    "Mini Monkey Barrel",
    "Barrel",
    "Pushable Box",
    "TNT Barrel Spawner",
    "Cannon",
    "TNT Barrel",
    "Rambi Crate",
    "Enguarde Crate",
    "Chain",
    "Swinging Light",
    "Minecart",
    "Barrel",
    "Bridge (Castle)",
    "Large Brown Bridge",
    "Feather",
    "Laser",
    "Golden Banana (Item Drop)",
    "Rocketbarrel",
    "Strong Kong Barrel",
    "Orangstand Sprint Barrel",
    "Diddy's Jetpack",
    "Photo",
    "Minecart (TNT)",
    "Weird glitch texture (computer screen?)",
    "BBB Slot",
    "BBB Slot",
    "BBB Slot",
    "BBB Slot",
    "BBB Lever",
    "Tiny's Car",
    "Missile",
    "Swinging light",
    "Bananaporter Zipper",
    "Boulder",
    "Vase (O)",
    "Vase (:)",
    "Vase (Triangle)",
    "Vase (+)",
    "Toy Box",
    "Boat",
    "Padlock",
    "Cannon Ball",
    "Vine",
    "Vine",
    "Counter",
    "Key",
    "Bongos",
    "DK Star",
    "Spotlight",
    "Cannon (Seasick Chunky)",
    "Boulder Debris",
    "Spider Web",
    "Steel Keg",
    "Shockwave",
    "Shockwave",
    "Battle Crown",
    "Buoy",
    "Buoy (Green)",
    "Nothing?",
    "DK Banana Counter",
    "Diddy Banana Counter",
    "Tiny Banana Counter",
    "Lanky Banana Counter",
    "Chunky Banana Counter",
    "Shockwave (Green)",
    "Potion",
    "Missile (Army Dillo)",
    "Shockwave (Red)",
    "Ice wall? ",
    "Rareware Logo",
    "Stalactite",
    "Rock Debris",
    "Spotlight (BONUS)",
    "Tag Barrel",
    "Krossbones Head",
    "Lever",
    "K. Lumsy's Cage",
    "Freeze Attack",
    "1 Pad (Diddy 5DI)",
    "2 Pad (Diddy 5DI)",
    "3 Pad (Diddy 5DI)",
    "4 Pad (Diddy 5DI)",
    "5 Pad (Diddy 5DI)",
    "6 Pad (Diddy 5DI)",
    "Race Checkpoint",
    "Padlock & Key",
    "Finish Line",
    "Shockwave (Green)",
    "Shockwave (Blue)",
    "Shockwave (Purple)",
    "Question Mark",
    "Flower (Instrument)",
    "DK Logo (Instrument)",
    "Golden Banana",
    "Apple",
    "Barrel",
    "Flag",
    "Flag",
    "Boat",
    "Krusha (Gun)",
    "King Kut Out Body",
    "King Kut Out Head",
    "King Kut Out Arm",
    "King Kut Out Arm",
    "Rainbow Coin Patch",
    "Rope",
    "DK Smoke Trail",
    "Light (K. Rool fight)",
    "Bonus Barrel (Hideout Helm)",
    "Banana",
    "Banana Barrel",
    "Training Barrel",
    "Pirate Photo",
    "Butterfly",
    "Barrel",
    "Funky's Gun",
    "Boot",
]

HeadResizeImmune = [
    Model.KlaptrapTeeth,
    Model.MadJack,
    Model.ToyMonster,
    Model.MrDice_41,
    Model.Ruler,
    Model.KlaptrapUnk,
    Model.NintendoLogo,
    Model.ToyCar,
    Model.GiantClam,
    Model.ArmyDillo,
    Model.MrDice_56,
    Model.Puftoss,
    Model.Turntable,
    Model.Shuri,
    Model.Gimpfish,
    Model.Beanstalk,
    Model.FireballWithGlasses,
    Model.SkeletonHead,
    Model.SkeletonHand,
    Model.Skull,
    Model.Ghost,
    Model.FlySwatter_83,
    Model.FlySwatter_84,
    Model.ShipWheel,
    Model.ShockwaveMJ,
    Model.CuckooBird,
    Model.ArmyDilloNoShell,
    Model.Boombox,
    Model.EscapeShip,
    Model.ArmyDilloCannon,
    Model.GoldenBanana_104,
    Model.Shockwave,
    Model.KRoolGlove,
    Model.KRoolFoot,
    Model.KRoolToe_108,
    Model.KRoolToe_109,
    Model.KRoolToe_110,
    Model.Bell,
    Model.ClapperBoard,
    Model.Cannon_115,
    Model.Barrel_116,
    Model.BonusBarrel,
    Model.HunkyChunkyBarrel,
    Model.MiniMonkeyBarrel,
    Model.Barrel_120,
    Model.PushableBox,
    Model.TNTBarrelSpawner,
    Model.Cannon_123,
    Model.TNTBarrel,
    Model.RambiCrate,
    Model.EnguardeCrate,
    Model.Chain,
    Model.SwingingLight_128,
    Model.Minecart,
    Model.Barrel,
    Model.BridgeCastle,
    Model.LargeBrownBridge,
    Model.Feather,
    Model.Laser,
    Model.GoldenBanana,
    Model.Rocketbarrel,
    Model.StrongKongBarrel,
    Model.OrangstandSprintBarrel,
    Model.DiddyJetpack,
    Model.Photo,
    Model.MinecartTNT,
    Model.WindowScreen,
    Model.BBBSlot_143,
    Model.BBBSlot_144,
    Model.BBBSlot_145,
    Model.BBBSlot_146,
    Model.BBBLever,
    Model.PlayerCar,
    Model.Missile,
    Model.SwingingLight_150,
    Model.BananaporterZipper,
    Model.Boulder,
    Model.VaseCircle,
    Model.VaseColon,
    Model.VaseTriangle,
    Model.VasePlus,
    Model.ToyBox,
    Model.Boat_158,
    Model.Padlock,
    Model.CannonBall,
    Model.Vine_161,
    Model.Vine_162,
    Model.Counter,
    Model.Key,
    Model.Bongos,
    Model.DKStar,
    Model.Spotlight,
    Model.CannonSeasick,
    Model.BoulderDebris,
    Model.SpiderWeb,
    Model.SteelKeg,
    Model.Shockwave_172,
    Model.Shockwave_173,
    Model.BattleCrown,
    Model.Buoy,
    Model.BuoyGreen,
    Model.Unknown,
    Model.DKBananaCounter,
    Model.DiddyBananaCounter,
    Model.TinyBananaCounter,
    Model.LankyBananaCounter,
    Model.ChunkyBananaCounter,
    Model.ShockwaveGreen_183,
    Model.Potion,
    Model.ArmyDilloMissle,
    Model.ShockwaveRed,
    Model.IceWall,
    Model.RarewareLogo,
    Model.Stalactite,
    Model.RockDebris,
    Model.SpotlightBonus,
    Model.TagBarrel,
    Model.KrossbonesHead,
    Model.Lever,
    Model.KLumsyCage,
    Model.IceTrapBubble,
    Model.DiddyBarrelPad_1,
    Model.DiddyBarrelPad_2,
    Model.DiddyBarrelPad_3,
    Model.DiddyBarrelPad_4,
    Model.DiddyBarrelPad_5,
    Model.DiddyBarrelPad_6,
    Model.RaceCheckpoint,
    Model.PadlockAndKey,
    Model.FinishLine,
    Model.ShockwaveGreen_206,
    Model.ShockwaveBlue,
    Model.ShockwavePurple,
    Model.QuestionMark,
    Model.FlowerWithInstrument,
    Model.DKLogoWithInstrument,
    Model.GoldenBanana_212,
    Model.Apple,
    Model.Barrel_214,
    Model.Flag_215,
    Model.Flag_216,
    Model.Boat_217,
    Model.KingKutOutBody,
    Model.KingKutOutHead,
    Model.KingKutOutArm_221,
    Model.KingKutOutArm_222,
    Model.DirtPatch,
    Model.Rope,
    Model.DKSmokeTrail,
    Model.Light,
    Model.HelmBarrel,
    Model.BananaPeel,
    Model.BananaBarrel,
    Model.TrainingBarrel,
    Model.PiratePhoto,
    Model.Butterfly,
    Model.Barrel_233,
    Model.FunkyGun,
    Model.Boot,
]
