# CrossCode MultiworldGG

## How long does it take to complete CrossCode randomized?
CrossCode is a long game. Without quest randomization, there are about 250 locations, most of which require significant effort to reach. Gaia's Garden itself has over 60 chests, most of which are only accessible after long platforming puzzles spanning multiple screens. One area in CrossCode is the size of a shorter Archipelago game. Without quests, runs can take 6-10 hours, and with quests that number is closer to 12-15.

## What's up with these weird-colored chests?
Because CrossCode is such a long game, it has proven to be very helpful for the player to differentiate at a glance between chests that should be prioritized and chests that are not as relevant to logic. Therefore, chests are color-coded and given symbols according to what kinds of items they contain. Green chests with the !! symbol are progression items and should probably be opened if possible. Deep blue chests with the + symbol are useful items. They are not relevant to logic, but they might help another player to finish their game easier. Light blue chests (the ones that appear as if they were vanilla) contain filler items. Their contents are often less than helpful. Chests containing traps appear as if they contained useful items.

## Is there a way to figure out which chest is which?
Yes! Enter analyze mode (left on the quick menu) and hover any unopened chest in the game. A dialog will appear indicating the chest's name and what type of item it contains (filler, useful, or progression).

## Why aren't New Game+ options available?
Because you don't have a completed save file. New Game+ options are not enabled if you have not completed the game because I don't want you to play randomized before completing the game normally. Please read this section of the setup guide and then, if you're still sure you want to play, ask us for help acquiring a completed save file.

## Is glitched logic supported?
No, and it probably will never be. The reason is that even the simplest of glitches blow this game wide open. Barrier skips, which are easy in concept if not execution, destroy what little progression gating there is, which would make almost every overworld check an instant sphere 1. Flare jumps, another popular glitch, allow you to get almost anywhere in a dungeon as long as you have heat.
Glitched logic in CrossCode, as far as anyone has been able to think to implement it, basically just means no logic.