import typing

from BaseClasses import Location
from .Names import LocationName

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from . import DKCWorld

class DKCLocation(Location):
    game = "Donkey Kong Country"

    def __init__(self, player: int, name: str = '', address: int = None, parent=None):
        super().__init__(player, name, address, parent)

STARTING_ID = 0xBF1000

stage_clears = {
    LocationName.jungle_hijinxs_clear:          STARTING_ID + 0x0000,
    LocationName.ropey_rampage_clear:           STARTING_ID + 0x0001,
    LocationName.reptile_rumble_clear:          STARTING_ID + 0x0002,
    LocationName.coral_capers_clear:            STARTING_ID + 0x0003,
    LocationName.barrel_cannon_canyon_clear:    STARTING_ID + 0x0004,
    LocationName.very_gnawty_lair_clear:        STARTING_ID + 0x0005,
    LocationName.winky_walkway_clear:           STARTING_ID + 0x0006,
    LocationName.mine_cart_carnage_clear:       STARTING_ID + 0x0007,
    LocationName.bouncy_bonanza_clear:          STARTING_ID + 0x0008,
    LocationName.stop_go_station_clear:         STARTING_ID + 0x0009,
    LocationName.millstone_mayhem_clear:        STARTING_ID + 0x000A,
    LocationName.necky_nuts_clear:              STARTING_ID + 0x000B,
    LocationName.vulture_culture_clear:         STARTING_ID + 0x000C,
    LocationName.tree_top_town_clear:           STARTING_ID + 0x000D,
    LocationName.forest_frenzy_clear:           STARTING_ID + 0x000E,
    LocationName.temple_tempest_clear:          STARTING_ID + 0x000F,
    LocationName.orang_utan_gang_clear:         STARTING_ID + 0x0010,
    LocationName.clam_city_clear:               STARTING_ID + 0x0011,
    LocationName.bumble_b_rumble_clear:         STARTING_ID + 0x0012,
    LocationName.snow_barrel_blast_clear:       STARTING_ID + 0x0013,
    LocationName.slipslide_ride_clear:          STARTING_ID + 0x0014,
    LocationName.ice_age_alley_clear:           STARTING_ID + 0x0015,
    LocationName.croctopus_chase_clear:         STARTING_ID + 0x0016,
    LocationName.torchlight_trouble_clear:      STARTING_ID + 0x0017,
    LocationName.rope_bridge_rumble_clear:      STARTING_ID + 0x0018,
    LocationName.really_gnawty_rampage_clear:   STARTING_ID + 0x0019,
    LocationName.oil_drum_alley_clear:          STARTING_ID + 0x001A,
    LocationName.trick_track_trek_clear:        STARTING_ID + 0x001B,
    LocationName.elevator_antics_clear:         STARTING_ID + 0x001C,
    LocationName.poison_pond_clear:             STARTING_ID + 0x001D,
    LocationName.mine_cart_madness_clear:       STARTING_ID + 0x001F,
    LocationName.blackout_basement_clear:       STARTING_ID + 0x0020,
    LocationName.boss_dumb_drum_clear:          STARTING_ID + 0x0021,
    LocationName.tanked_up_trouble_clear:       STARTING_ID + 0x0022,
    LocationName.manic_mincers_clear:           STARTING_ID + 0x0023,
    LocationName.misty_mine_clear:              STARTING_ID + 0x0024,
    LocationName.loopy_lights_clear:            STARTING_ID + 0x0025,
    LocationName.platform_perils_clear:         STARTING_ID + 0x0026,
    LocationName.necky_revenge_clear:           STARTING_ID + 0x0027,
    LocationName.defeated_gnawty_1:             STARTING_ID + 0x0028,
    LocationName.defeated_necky_1:              STARTING_ID + 0x002A,
    LocationName.defeated_bumble_b:             STARTING_ID + 0x002B,
    LocationName.defeated_gnawty_2:             STARTING_ID + 0x002C,
    LocationName.defeated_boss_dumb_drum:       STARTING_ID + 0x002D,
    LocationName.defeated_necky_2:              STARTING_ID + 0x002E,
}

stage_kong = {
    LocationName.jungle_hijinxs_kong:          STARTING_ID + 0x0040,
    LocationName.ropey_rampage_kong:           STARTING_ID + 0x0041,
    LocationName.reptile_rumble_kong:          STARTING_ID + 0x0042,
    LocationName.coral_capers_kong:            STARTING_ID + 0x0043,
    LocationName.barrel_cannon_canyon_kong:    STARTING_ID + 0x0044,
    LocationName.winky_walkway_kong:           STARTING_ID + 0x0046,
    LocationName.mine_cart_carnage_kong:       STARTING_ID + 0x0047,
    LocationName.bouncy_bonanza_kong:          STARTING_ID + 0x0048,
    LocationName.stop_go_station_kong:         STARTING_ID + 0x0049,
    LocationName.millstone_mayhem_kong:        STARTING_ID + 0x004A,
    LocationName.vulture_culture_kong:         STARTING_ID + 0x004C,
    LocationName.tree_top_town_kong:           STARTING_ID + 0x004D,
    LocationName.forest_frenzy_kong:           STARTING_ID + 0x004E,
    LocationName.temple_tempest_kong:          STARTING_ID + 0x004F,
    LocationName.orang_utan_gang_kong:         STARTING_ID + 0x0050,
    LocationName.clam_city_kong:               STARTING_ID + 0x0051,
    LocationName.snow_barrel_blast_kong:       STARTING_ID + 0x0053,
    LocationName.slipslide_ride_kong:          STARTING_ID + 0x0054,
    LocationName.ice_age_alley_kong:           STARTING_ID + 0x0055,
    LocationName.croctopus_chase_kong:         STARTING_ID + 0x0056,
    LocationName.torchlight_trouble_kong:      STARTING_ID + 0x0057,
    LocationName.rope_bridge_rumble_kong:      STARTING_ID + 0x0058,
    LocationName.oil_drum_alley_kong:          STARTING_ID + 0x005A,
    LocationName.trick_track_trek_kong:        STARTING_ID + 0x005B,
    LocationName.elevator_antics_kong:         STARTING_ID + 0x005C,
    LocationName.poison_pond_kong:             STARTING_ID + 0x005D,
    LocationName.mine_cart_madness_kong:       STARTING_ID + 0x005F,
    LocationName.blackout_basement_kong:       STARTING_ID + 0x0060,
    LocationName.tanked_up_trouble_kong:       STARTING_ID + 0x0062,
    LocationName.manic_mincers_kong:           STARTING_ID + 0x0063,
    LocationName.misty_mine_kong:              STARTING_ID + 0x0064,
    LocationName.loopy_lights_kong:            STARTING_ID + 0x0065,
    LocationName.platform_perils_kong:         STARTING_ID + 0x0066,
}

stage_bonus = {
    LocationName.jungle_hijinxs_bonus_1:          STARTING_ID + 0x0080,
    LocationName.jungle_hijinxs_bonus_2:          STARTING_ID + 0x0081,
    LocationName.ropey_rampage_bonus_1:           STARTING_ID + 0x0082,
    LocationName.ropey_rampage_bonus_2:           STARTING_ID + 0x0083,
    LocationName.reptile_rumble_bonus_1:          STARTING_ID + 0x0084,
    LocationName.reptile_rumble_bonus_2:          STARTING_ID + 0x0085,
    LocationName.reptile_rumble_bonus_3:          STARTING_ID + 0x0086,
    LocationName.barrel_cannon_canyon_bonus_1:    STARTING_ID + 0x0087,
    LocationName.barrel_cannon_canyon_bonus_2:    STARTING_ID + 0x0088,
    LocationName.winky_walkway_bonus_1:           STARTING_ID + 0x0089,
    LocationName.bouncy_bonanza_bonus_1:          STARTING_ID + 0x008A,
    LocationName.bouncy_bonanza_bonus_2:          STARTING_ID + 0x008B,
    LocationName.stop_go_station_bonus_1:         STARTING_ID + 0x008C,
    LocationName.stop_go_station_bonus_2:         STARTING_ID + 0x008D,
    LocationName.millstone_mayhem_bonus_1:        STARTING_ID + 0x008E,
    LocationName.millstone_mayhem_bonus_2:        STARTING_ID + 0x008F,
    LocationName.millstone_mayhem_bonus_3:        STARTING_ID + 0x0090,
    LocationName.vulture_culture_bonus_1:         STARTING_ID + 0x0091,
    LocationName.vulture_culture_bonus_2:         STARTING_ID + 0x0092,
    LocationName.vulture_culture_bonus_3:         STARTING_ID + 0x0093,
    LocationName.tree_top_town_bonus_2:           STARTING_ID + 0x0094,
    LocationName.tree_top_town_bonus_1:           STARTING_ID + 0x0095,
    LocationName.forest_frenzy_bonus_1:           STARTING_ID + 0x0096,
    LocationName.forest_frenzy_bonus_2:           STARTING_ID + 0x0097,
    LocationName.temple_tempest_bonus_1:          STARTING_ID + 0x0098,
    LocationName.temple_tempest_bonus_2:          STARTING_ID + 0x0099,
    LocationName.orang_utan_gang_bonus_1:         STARTING_ID + 0x009A,
    LocationName.orang_utan_gang_bonus_2:         STARTING_ID + 0x009B,
    LocationName.orang_utan_gang_bonus_3:         STARTING_ID + 0x009C,
    LocationName.orang_utan_gang_bonus_4:         STARTING_ID + 0x009D,
    LocationName.orang_utan_gang_bonus_5:         STARTING_ID + 0x009E,
    LocationName.snow_barrel_blast_bonus_1:       STARTING_ID + 0x009F,
    LocationName.snow_barrel_blast_bonus_2:       STARTING_ID + 0x00A0,
    LocationName.snow_barrel_blast_bonus_3:       STARTING_ID + 0x00A1,
    LocationName.slipslide_ride_bonus_1:          STARTING_ID + 0x00A2,
    LocationName.slipslide_ride_bonus_2:          STARTING_ID + 0x00A3,
    LocationName.slipslide_ride_bonus_3:          STARTING_ID + 0x00A4,
    LocationName.ice_age_alley_bonus_1:           STARTING_ID + 0x00A5,
    LocationName.ice_age_alley_bonus_2:           STARTING_ID + 0x00A6,
    LocationName.torchlight_trouble_bonus_1:      STARTING_ID + 0x00A7,
    LocationName.torchlight_trouble_bonus_2:      STARTING_ID + 0x00A8,
    LocationName.rope_bridge_rumble_bonus_2:      STARTING_ID + 0x00A9,
    LocationName.rope_bridge_rumble_bonus_1:      STARTING_ID + 0x00AA,
    LocationName.oil_drum_alley_bonus_1:          STARTING_ID + 0x00AB,
    LocationName.oil_drum_alley_bonus_2:          STARTING_ID + 0x00AC,
    LocationName.oil_drum_alley_bonus_3:          STARTING_ID + 0x00AD,
    LocationName.oil_drum_alley_bonus_4:          STARTING_ID + 0x00AE,
    LocationName.trick_track_trek_bonus_1:        STARTING_ID + 0x00AF,
    LocationName.trick_track_trek_bonus_2:        STARTING_ID + 0x00B0,
    LocationName.trick_track_trek_bonus_3:        STARTING_ID + 0x00B1,
    LocationName.elevator_antics_bonus_1:         STARTING_ID + 0x00B2,
    LocationName.elevator_antics_bonus_2:         STARTING_ID + 0x00B3,
    LocationName.elevator_antics_bonus_3:         STARTING_ID + 0x00B4,
    LocationName.mine_cart_madness_bonus_1:       STARTING_ID + 0x00B5,
    LocationName.mine_cart_madness_bonus_2:       STARTING_ID + 0x00B6,
    LocationName.mine_cart_madness_bonus_3:       STARTING_ID + 0x00B7,
    LocationName.blackout_basement_bonus_1:       STARTING_ID + 0x00B8,
    LocationName.blackout_basement_bonus_2:       STARTING_ID + 0x00B9,
    LocationName.tanked_up_trouble_bonus_1:       STARTING_ID + 0x00BA,
    LocationName.manic_mincers_bonus_1:           STARTING_ID + 0x00BB,
    LocationName.manic_mincers_bonus_2:           STARTING_ID + 0x00BC,
    LocationName.misty_mine_bonus_1:              STARTING_ID + 0x00BD,
    LocationName.misty_mine_bonus_2:              STARTING_ID + 0x00BE,
    LocationName.loopy_lights_bonus_1:            STARTING_ID + 0x00BF,
    LocationName.loopy_lights_bonus_2:            STARTING_ID + 0x00C0,
    LocationName.platform_perils_bonus_1:         STARTING_ID + 0x00C1,
    LocationName.platform_perils_bonus_2:         STARTING_ID + 0x00C2,
}

stage_tokens = {
    LocationName.jungle_hijinxs_token_1:        STARTING_ID + 0x0100,
    LocationName.ropey_rampage_token_1:         STARTING_ID + 0x0101,
    LocationName.ropey_rampage_token_2:         STARTING_ID + 0x0102,
    LocationName.reptile_rumble_token_1:        STARTING_ID + 0x0103,
    LocationName.coral_capers_token_1:          STARTING_ID + 0x0104,
    LocationName.barrel_cannon_canyon_token_1:  STARTING_ID + 0x0105,
    LocationName.barrel_cannon_canyon_token_2:  STARTING_ID + 0x0106,
    LocationName.winky_walkway_token_1:         STARTING_ID + 0x0107,
    LocationName.mine_cart_carnage_token_1:     STARTING_ID + 0x0108,
    LocationName.bouncy_bonanza_token_1:        STARTING_ID + 0x0109,
    LocationName.stop_go_station_token_1:       STARTING_ID + 0x010A,
    LocationName.tree_top_town_token_1:         STARTING_ID + 0x010B,
    LocationName.temple_tempest_token_1:        STARTING_ID + 0x010C,
    LocationName.orang_utan_gang_token_1:       STARTING_ID + 0x010D,
    LocationName.clam_city_token_1:             STARTING_ID + 0x010E,
    LocationName.snow_barrel_blast_token_1:     STARTING_ID + 0x010F,
    LocationName.slipslide_ride_token_1:        STARTING_ID + 0x0110,
    LocationName.croctopus_chase_token_1:       STARTING_ID + 0x0111,
    LocationName.croctopus_chase_token_2:       STARTING_ID + 0x0112,
    LocationName.trick_track_trek_token_1:      STARTING_ID + 0x0113,
    LocationName.poison_pond_token_1:           STARTING_ID + 0x0114,
    LocationName.poison_pond_token_2:           STARTING_ID + 0x0115,
    LocationName.mine_cart_madness_token_1:     STARTING_ID + 0x0116,
    LocationName.blackout_basement_token_1:     STARTING_ID + 0x0117,
    LocationName.tanked_up_trouble_token_1:     STARTING_ID + 0x0118,
    LocationName.manic_mincers_token_1:         STARTING_ID + 0x0119,
    LocationName.misty_mine_token_1:            STARTING_ID + 0x011A,
    LocationName.misty_mine_token_2:            STARTING_ID + 0x011B,
    LocationName.platform_perils_token_1:       STARTING_ID + 0x011C,
}

stage_balloons = {
    LocationName.jungle_hijinxs_balloon_1:      STARTING_ID + 0x0200,
    LocationName.jungle_hijinxs_balloon_2:      STARTING_ID + 0x0201,
    LocationName.jungle_hijinxs_balloon_3:      STARTING_ID + 0x0202,
    LocationName.jungle_hijinxs_balloon_4:      STARTING_ID + 0x0203,
    LocationName.jungle_hijinxs_balloon_5:      STARTING_ID + 0x0204,
    LocationName.jungle_hijinxs_balloon_6:      STARTING_ID + 0x0205,
    LocationName.coral_capers_balloon_1:        STARTING_ID + 0x0206,
    LocationName.mine_cart_carnage_balloon_1:   STARTING_ID + 0x0207,
    LocationName.forest_frenzy_balloon_1:       STARTING_ID + 0x0208,
    LocationName.snow_barrel_blast_balloon_1:   STARTING_ID + 0x0209,
    LocationName.snow_barrel_blast_balloon_2:   STARTING_ID + 0x020A,
    LocationName.croctopus_chase_balloon_1:     STARTING_ID + 0x020B,
}

stage_bunches = {
    LocationName.jungle_hijinxs_bunch_1:        STARTING_ID + 0x0300,
    LocationName.jungle_hijinxs_bunch_2:        STARTING_ID + 0x0301,
    LocationName.jungle_hijinxs_bunch_3:        STARTING_ID + 0x0302,
    LocationName.jungle_hijinxs_bunch_4:        STARTING_ID + 0x0303,
    LocationName.jungle_hijinxs_bunch_5:        STARTING_ID + 0x0304,
    LocationName.jungle_hijinxs_bunch_6:        STARTING_ID + 0x0305,
    LocationName.jungle_hijinxs_bunch_7:        STARTING_ID + 0x0306,
    LocationName.jungle_hijinxs_bunch_8:        STARTING_ID + 0x0307,
    LocationName.jungle_hijinxs_bunch_9:        STARTING_ID + 0x0308,
    LocationName.jungle_hijinxs_bunch_10:       STARTING_ID + 0x0309,
    LocationName.jungle_hijinxs_bunch_11:       STARTING_ID + 0x030A,
    LocationName.jungle_hijinxs_bunch_12:       STARTING_ID + 0x030B,
    LocationName.jungle_hijinxs_bunch_13:       STARTING_ID + 0x030C,
    LocationName.jungle_hijinxs_bunch_14:       STARTING_ID + 0x030D,
    LocationName.jungle_hijinxs_bunch_15:       STARTING_ID + 0x030E,
    LocationName.jungle_hijinxs_bunch_16:       STARTING_ID + 0x030F,
    LocationName.jungle_hijinxs_bunch_17:       STARTING_ID + 0x0310,
    LocationName.jungle_hijinxs_bunch_18:       STARTING_ID + 0x0311,
    LocationName.jungle_hijinxs_bunch_19:       STARTING_ID + 0x0312,
    LocationName.ropey_rampage_bunch_1:         STARTING_ID + 0x0313,
    LocationName.ropey_rampage_bunch_2:         STARTING_ID + 0x0314,
    LocationName.ropey_rampage_bunch_3:         STARTING_ID + 0x0315,
    LocationName.ropey_rampage_bunch_4:         STARTING_ID + 0x0316,
    LocationName.ropey_rampage_bunch_5:         STARTING_ID + 0x0317,
    LocationName.ropey_rampage_bunch_6:         STARTING_ID + 0x0318,
    LocationName.ropey_rampage_bunch_7:         STARTING_ID + 0x0319,
    LocationName.ropey_rampage_bunch_8:         STARTING_ID + 0x031A,
    LocationName.ropey_rampage_bunch_9:         STARTING_ID + 0x031B,
    LocationName.ropey_rampage_bunch_10:        STARTING_ID + 0x031C,
    LocationName.ropey_rampage_bunch_11:        STARTING_ID + 0x031D,
    LocationName.ropey_rampage_bunch_12:        STARTING_ID + 0x031E,
    LocationName.ropey_rampage_bunch_13:        STARTING_ID + 0x031F,
    LocationName.ropey_rampage_bunch_14:        STARTING_ID + 0x0320,
    LocationName.ropey_rampage_bunch_15:        STARTING_ID + 0x0321,
    LocationName.ropey_rampage_bunch_16:        STARTING_ID + 0x0322,
    LocationName.ropey_rampage_bunch_17:        STARTING_ID + 0x0323,
    LocationName.ropey_rampage_bunch_18:        STARTING_ID + 0x0324,
    LocationName.ropey_rampage_bunch_19:        STARTING_ID + 0x0325,
    LocationName.reptile_rumble_bunch_1:        STARTING_ID + 0x0326,
    LocationName.reptile_rumble_bunch_2:        STARTING_ID + 0x0327,
    LocationName.reptile_rumble_bunch_3:        STARTING_ID + 0x0328,
    LocationName.reptile_rumble_bunch_4:        STARTING_ID + 0x0329,
    LocationName.reptile_rumble_bunch_5:        STARTING_ID + 0x032A,
    LocationName.reptile_rumble_bunch_6:        STARTING_ID + 0x032B,
    LocationName.reptile_rumble_bunch_7:        STARTING_ID + 0x032C,
    LocationName.reptile_rumble_bunch_8:        STARTING_ID + 0x032D,
    LocationName.reptile_rumble_bunch_9:        STARTING_ID + 0x032E,
    LocationName.reptile_rumble_bunch_10:       STARTING_ID + 0x032F,
    LocationName.reptile_rumble_bunch_11:       STARTING_ID + 0x0330,
    LocationName.reptile_rumble_bunch_12:       STARTING_ID + 0x0331,
    LocationName.reptile_rumble_bunch_13:       STARTING_ID + 0x0332,
    LocationName.reptile_rumble_bunch_14:       STARTING_ID + 0x0333,
    LocationName.coral_capers_bunch_1:          STARTING_ID + 0x0334,
    LocationName.coral_capers_bunch_2:          STARTING_ID + 0x0335,
    LocationName.barrel_cannon_canyon_bunch_1:  STARTING_ID + 0x0336,
    LocationName.barrel_cannon_canyon_bunch_2:  STARTING_ID + 0x0337,
    LocationName.barrel_cannon_canyon_bunch_3:  STARTING_ID + 0x0338,
    LocationName.barrel_cannon_canyon_bunch_4:  STARTING_ID + 0x0339,
    LocationName.barrel_cannon_canyon_bunch_5:  STARTING_ID + 0x033A,
    LocationName.barrel_cannon_canyon_bunch_6:  STARTING_ID + 0x033B,
    LocationName.barrel_cannon_canyon_bunch_7:  STARTING_ID + 0x033C,
    LocationName.barrel_cannon_canyon_bunch_8:  STARTING_ID + 0x033D,
    LocationName.barrel_cannon_canyon_bunch_9:  STARTING_ID + 0x033E,
    LocationName.barrel_cannon_canyon_bunch_10: STARTING_ID + 0x033F,
    LocationName.barrel_cannon_canyon_bunch_11: STARTING_ID + 0x0340,
    LocationName.barrel_cannon_canyon_bunch_12: STARTING_ID + 0x0341,
    LocationName.winky_walkway_bunch_1:         STARTING_ID + 0x0342,
    LocationName.winky_walkway_bunch_2:         STARTING_ID + 0x0343,
    LocationName.winky_walkway_bunch_3:         STARTING_ID + 0x0344,
    LocationName.winky_walkway_bunch_4:         STARTING_ID + 0x0345,
    LocationName.winky_walkway_bunch_5:         STARTING_ID + 0x0346,
    LocationName.mine_cart_carnage_bunch_1:     STARTING_ID + 0x0347,
    LocationName.mine_cart_carnage_bunch_2:     STARTING_ID + 0x0348,
    LocationName.mine_cart_carnage_bunch_3:     STARTING_ID + 0x0349,
    LocationName.bouncy_bonanza_bunch_1:        STARTING_ID + 0x034A,
    LocationName.bouncy_bonanza_bunch_2:        STARTING_ID + 0x034B,
    LocationName.bouncy_bonanza_bunch_3:        STARTING_ID + 0x034C,
    LocationName.bouncy_bonanza_bunch_4:        STARTING_ID + 0x034D,
    LocationName.bouncy_bonanza_bunch_5:        STARTING_ID + 0x034E,
    LocationName.bouncy_bonanza_bunch_6:        STARTING_ID + 0x034F,
    LocationName.bouncy_bonanza_bunch_7:        STARTING_ID + 0x0350,
    LocationName.bouncy_bonanza_bunch_8:        STARTING_ID + 0x0351,
    LocationName.bouncy_bonanza_bunch_9:        STARTING_ID + 0x0352,
    LocationName.bouncy_bonanza_bunch_10:       STARTING_ID + 0x0353,
    LocationName.stop_go_station_bunch_1:       STARTING_ID + 0x0354,
    LocationName.stop_go_station_bunch_2:       STARTING_ID + 0x0355,
    LocationName.stop_go_station_bunch_3:       STARTING_ID + 0x0356,
    LocationName.stop_go_station_bunch_4:       STARTING_ID + 0x0357,
    LocationName.stop_go_station_bunch_5:       STARTING_ID + 0x0358,
    LocationName.stop_go_station_bunch_6:       STARTING_ID + 0x0359,
    LocationName.stop_go_station_bunch_7:       STARTING_ID + 0x035A,
    LocationName.millstone_mayhem_bunch_1:      STARTING_ID + 0x035B,
    LocationName.millstone_mayhem_bunch_2:      STARTING_ID + 0x035C,
    LocationName.millstone_mayhem_bunch_3:      STARTING_ID + 0x035D,
    LocationName.millstone_mayhem_bunch_4:      STARTING_ID + 0x035E,
    LocationName.millstone_mayhem_bunch_5:      STARTING_ID + 0x035F,
    LocationName.millstone_mayhem_bunch_6:      STARTING_ID + 0x0360,
    LocationName.millstone_mayhem_bunch_7:      STARTING_ID + 0x0361,
    LocationName.millstone_mayhem_bunch_8:      STARTING_ID + 0x0362,
    LocationName.millstone_mayhem_bunch_9:      STARTING_ID + 0x0363,
    LocationName.vulture_culture_bunch_1:       STARTING_ID + 0x0364,
    LocationName.vulture_culture_bunch_2:       STARTING_ID + 0x0365,
    LocationName.vulture_culture_bunch_3:       STARTING_ID + 0x0366,
    LocationName.vulture_culture_bunch_4:       STARTING_ID + 0x0367,
    LocationName.vulture_culture_bunch_5:       STARTING_ID + 0x0368,
    LocationName.vulture_culture_bunch_6:       STARTING_ID + 0x0369,
    LocationName.tree_top_town_bunch_1:         STARTING_ID + 0x036A,
    LocationName.tree_top_town_bunch_2:         STARTING_ID + 0x036B,
    LocationName.tree_top_town_bunch_3:         STARTING_ID + 0x036C,
    LocationName.tree_top_town_bunch_4:         STARTING_ID + 0x036D,
    LocationName.forest_frenzy_bunch_1:         STARTING_ID + 0x036E,
    LocationName.forest_frenzy_bunch_2:         STARTING_ID + 0x036F,
    LocationName.forest_frenzy_bunch_3:         STARTING_ID + 0x0370,
    LocationName.forest_frenzy_bunch_4:         STARTING_ID + 0x0371,
    LocationName.forest_frenzy_bunch_5:         STARTING_ID + 0x0372,
    LocationName.temple_tempest_bunch_1:        STARTING_ID + 0x0373,
    LocationName.temple_tempest_bunch_2:        STARTING_ID + 0x0374,
    LocationName.temple_tempest_bunch_3:        STARTING_ID + 0x0375,
    LocationName.temple_tempest_bunch_4:        STARTING_ID + 0x0376,
    LocationName.temple_tempest_bunch_5:        STARTING_ID + 0x0377,
    LocationName.temple_tempest_bunch_6:        STARTING_ID + 0x0378,
    LocationName.temple_tempest_bunch_7:        STARTING_ID + 0x0379,
    LocationName.temple_tempest_bunch_8:        STARTING_ID + 0x037A,
    LocationName.orang_utan_gang_bunch_1:       STARTING_ID + 0x037B,
    LocationName.orang_utan_gang_bunch_2:       STARTING_ID + 0x037C,
    LocationName.orang_utan_gang_bunch_3:       STARTING_ID + 0x037D,
    LocationName.orang_utan_gang_bunch_4:       STARTING_ID + 0x037E,
    LocationName.orang_utan_gang_bunch_5:       STARTING_ID + 0x037F,
    LocationName.orang_utan_gang_bunch_6:       STARTING_ID + 0x0380,
    LocationName.orang_utan_gang_bunch_7:       STARTING_ID + 0x0381,
    LocationName.orang_utan_gang_bunch_8:       STARTING_ID + 0x0382,
    LocationName.orang_utan_gang_bunch_9:       STARTING_ID + 0x0383,
    LocationName.clam_city_bunch_1:             STARTING_ID + 0x0384,
    LocationName.clam_city_bunch_2:             STARTING_ID + 0x0385,
    LocationName.snow_barrel_blast_bunch_1:     STARTING_ID + 0x0386,
    LocationName.snow_barrel_blast_bunch_2:     STARTING_ID + 0x0387,
    LocationName.snow_barrel_blast_bunch_3:     STARTING_ID + 0x0388,
    LocationName.snow_barrel_blast_bunch_4:     STARTING_ID + 0x0389,
    LocationName.snow_barrel_blast_bunch_5:     STARTING_ID + 0x038A,
    LocationName.slipslide_ride_bunch_1:        STARTING_ID + 0x038B,
    LocationName.slipslide_ride_bunch_2:        STARTING_ID + 0x038C,
    LocationName.slipslide_ride_bunch_3:        STARTING_ID + 0x038D,
    LocationName.slipslide_ride_bunch_4:        STARTING_ID + 0x038E,
    LocationName.slipslide_ride_bunch_5:        STARTING_ID + 0x038F,
    LocationName.slipslide_ride_bunch_6:        STARTING_ID + 0x0390,
    LocationName.slipslide_ride_bunch_7:        STARTING_ID + 0x0391,
    LocationName.slipslide_ride_bunch_8:        STARTING_ID + 0x0392,
    LocationName.slipslide_ride_bunch_9:        STARTING_ID + 0x0393,
    LocationName.ice_age_alley_bunch_1:         STARTING_ID + 0x0394,
    LocationName.ice_age_alley_bunch_2:         STARTING_ID + 0x0395,
    LocationName.ice_age_alley_bunch_3:         STARTING_ID + 0x0396,
    LocationName.croctopus_chase_bunch_1:       STARTING_ID + 0x0397,
    LocationName.croctopus_chase_bunch_2:       STARTING_ID + 0x0398,
    LocationName.croctopus_chase_bunch_3:       STARTING_ID + 0x0399,
    LocationName.croctopus_chase_bunch_4:       STARTING_ID + 0x039A,
    LocationName.croctopus_chase_bunch_5:       STARTING_ID + 0x039B,
    LocationName.torchlight_trouble_bunch_1:    STARTING_ID + 0x039C,
    LocationName.rope_bridge_rumble_bunch_1:    STARTING_ID + 0x039D,
    LocationName.oil_drum_alley_bunch_1:        STARTING_ID + 0x039E,
    LocationName.oil_drum_alley_bunch_2:        STARTING_ID + 0x039F,
    LocationName.trick_track_trek_bunch_1:      STARTING_ID + 0x03A0,
    LocationName.elevator_antics_bunch_1:       STARTING_ID + 0x03A1,
    LocationName.elevator_antics_bunch_2:       STARTING_ID + 0x03A2,
    LocationName.elevator_antics_bunch_3:       STARTING_ID + 0x03A3,
    LocationName.poison_pond_bunch_1:           STARTING_ID + 0x03A4,
    LocationName.poison_pond_bunch_2:           STARTING_ID + 0x03A5,
    LocationName.poison_pond_bunch_3:           STARTING_ID + 0x03A6,
    LocationName.poison_pond_bunch_4:           STARTING_ID + 0x03A7,
    LocationName.poison_pond_bunch_5:           STARTING_ID + 0x03A8,
    LocationName.poison_pond_bunch_6:           STARTING_ID + 0x03A9,
    LocationName.mine_cart_madness_bunch_1:     STARTING_ID + 0x03AA,
    LocationName.blackout_basement_bunch_1:     STARTING_ID + 0x03AB,
    LocationName.tanked_up_trouble_bunch_1:     STARTING_ID + 0x03AC,
    LocationName.tanked_up_trouble_bunch_2:     STARTING_ID + 0x03AD,
    LocationName.tanked_up_trouble_bunch_3:     STARTING_ID + 0x03AE,
    LocationName.tanked_up_trouble_bunch_4:     STARTING_ID + 0x03AF,
    LocationName.manic_mincers_bunch_1:         STARTING_ID + 0x03B0,
    LocationName.manic_mincers_bunch_2:         STARTING_ID + 0x03B1,
    LocationName.misty_mine_bunch_1:            STARTING_ID + 0x03B2,
    LocationName.misty_mine_bunch_2:            STARTING_ID + 0x03B3,
    LocationName.loopy_lights_bunch_1:          STARTING_ID + 0x03B4,
    LocationName.loopy_lights_bunch_2:          STARTING_ID + 0x03B5,
    LocationName.platform_perils_bunch_1:       STARTING_ID + 0x03B6,
}

all_locations = {
    **stage_clears,
    **stage_kong,
    **stage_balloons,
    **stage_bonus,
    **stage_tokens,
    **stage_bunches,
}

#location_table = {}


location_groups = {
    "Jungle Hijinxs": {location for location in all_locations.keys() if "Jungle Hijinxs" in location},
    "Ropey Rampage": {location for location in all_locations.keys() if "Ropey Rampage" in location},
    "Reptile Rumble": {location for location in all_locations.keys() if "Reptile Rumble" in location},
    "Coral Capers": {location for location in all_locations.keys() if "Coral Capers" in location},
    "Barrel Cannon Canyon": {location for location in all_locations.keys() if "Barrel Cannon Canyon" in location},
    "Very Gnawty's Lair": {location for location in all_locations.keys() if "Very Gnawty's Lair" in location},
    "Winky's Walkway": {location for location in all_locations.keys() if "Winky's Walkway" in location},
    "Mine Cart Carnage": {location for location in all_locations.keys() if "Mine Cart Carnage" in location},
    "Bouncy Bonanza": {location for location in all_locations.keys() if "Bouncy Bonanza" in location},
    "Stop & Go Station": {location for location in all_locations.keys() if "Stop & Go Station" in location},
    "Millstone Mayhem": {location for location in all_locations.keys() if "Millstone Mayhem" in location},
    "Necky's Nuts": {location for location in all_locations.keys() if "Necky's Nuts" in location},
    "Vulture Culture": {location for location in all_locations.keys() if "Vulture Culture" in location},
    "Tree Top Town": {location for location in all_locations.keys() if "Tree Top Town" in location},
    "Forest Frenzy": {location for location in all_locations.keys() if "Forest Frenzy" in location},
    "Temple Tempest": {location for location in all_locations.keys() if "Temple Tempest" in location},
    "Orang-utan Gang": {location for location in all_locations.keys() if "Orang-utan Gang" in location},
    "Clam City": {location for location in all_locations.keys() if "Clam City" in location},
    "Bumble B Rumble": {location for location in all_locations.keys() if "Bumble B Rumble" in location},
    "Snow Barrel Blast": {location for location in all_locations.keys() if "Snow Barrel Blast" in location},
    "Slipslide Ride": {location for location in all_locations.keys() if "Slipslide Ride" in location},
    "Ice Age Alley": {location for location in all_locations.keys() if "Ice Age Alley" in location},
    "Croctopus Chase": {location for location in all_locations.keys() if "Croctopus Chase" in location},
    "Torchlight Trouble": {location for location in all_locations.keys() if "Torchlight Trouble" in location},
    "Rope Bridge Rumble": {location for location in all_locations.keys() if "Rope Bridge Rumble" in location},
    "Really Gnawty Rampage": {location for location in all_locations.keys() if "Really Gnawty Rampage" in location},
    "Trick Track Trek": {location for location in all_locations.keys() if "Trick Track Trek" in location},
    "Elevator Antics": {location for location in all_locations.keys() if "Elevator Antics" in location},
    "Poison Pond": {location for location in all_locations.keys() if "Poison Pond" in location},
    "Mine Cart Madness": {location for location in all_locations.keys() if "Mine Cart Madness" in location},
    "Blackout Basement": {location for location in all_locations.keys() if "Blackout Basement" in location},
    "Boss Dumb Drum": {location for location in all_locations.keys() if "Arctic Abyss" in location},
    "Windy Well": {location for location in all_locations.keys() if "Boss Dumb Drum" in location},
    "Tanked Up Trouble": {location for location in all_locations.keys() if "Tanked Up Trouble" in location},
    "Manic Mincers": {location for location in all_locations.keys() if "Manic Mincers" in location},
    "Misty Mine": {location for location in all_locations.keys() if "Misty Mine" in location},
    "Loopy Lights": {location for location in all_locations.keys() if "Loopy Lights" in location},
    "Platform Perils": {location for location in all_locations.keys() if "Platform Perils" in location},
    "Necky's Revenge": {location for location in all_locations.keys() if "Necky's Revenge" in location},
}

def setup_locations(world: "DKCWorld"):
    location_table = {
        **stage_clears,
        **stage_bonus,
    }

    if world.options.kong_checks:
        location_table.update(stage_kong)
    if world.options.balloon_checks:
        location_table.update(stage_balloons)
    if world.options.token_checks:
        location_table.update(stage_tokens)
    if world.options.banana_checks:
        location_table.update(stage_bunches)

    return location_table

lookup_id_to_name: typing.Dict[int, str] = {id: name for name, _ in all_locations.items()}
