from typing import NamedTuple, TypedDict, Optional

from BaseClasses import Location

from .Names import SkillNames, CareerNames, AspirationNames


class Sims4Location(Location):
    game: str = "The Sims 4"

    def __init__(self, player: int, name: str, address: Optional[int], parent):
        super().__init__(player, name, address, parent)
        self.event = not address


class Sims4LocationDict(TypedDict, total=False):
    name: str
    category: str
    expansion: str


class Sims4LocationData(NamedTuple):
    category: str
    code: Optional[int] = None


skill_locations_table: dict[int, Sims4LocationDict] = {
    0x73341002: {'name': f"{SkillNames.base_skill_comedy} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341003: {'name': f"{SkillNames.base_skill_comedy} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341004: {'name': f"{SkillNames.base_skill_comedy} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341005: {'name': f"{SkillNames.base_skill_comedy} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341006: {'name': f"{SkillNames.base_skill_comedy} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341007: {'name': f"{SkillNames.base_skill_comedy} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341008: {'name': f"{SkillNames.base_skill_comedy} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341009: {'name': f"{SkillNames.base_skill_comedy} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334100A: {'name': f"{SkillNames.base_skill_comedy} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x7334100C: {'name': f"{SkillNames.base_skill_guitar} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334100D: {'name': f"{SkillNames.base_skill_guitar} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334100E: {'name': f"{SkillNames.base_skill_guitar} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334100F: {'name': f"{SkillNames.base_skill_guitar} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341010: {'name': f"{SkillNames.base_skill_guitar} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341011: {'name': f"{SkillNames.base_skill_guitar} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341012: {'name': f"{SkillNames.base_skill_guitar} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341013: {'name': f"{SkillNames.base_skill_guitar} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341014: {'name': f"{SkillNames.base_skill_guitar} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341016: {'name': f"{SkillNames.base_skill_logic} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341017: {'name': f"{SkillNames.base_skill_logic} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341018: {'name': f"{SkillNames.base_skill_logic} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341019: {'name': f"{SkillNames.base_skill_logic} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334101A: {'name': f"{SkillNames.base_skill_logic} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334101B: {'name': f"{SkillNames.base_skill_logic} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334101C: {'name': f"{SkillNames.base_skill_logic} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334101D: {'name': f"{SkillNames.base_skill_logic} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334101E: {'name': f"{SkillNames.base_skill_logic} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341020: {'name': f"{SkillNames.base_skill_piano} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341021: {'name': f"{SkillNames.base_skill_piano} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341022: {'name': f"{SkillNames.base_skill_piano} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341023: {'name': f"{SkillNames.base_skill_piano} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341024: {'name': f"{SkillNames.base_skill_piano} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341025: {'name': f"{SkillNames.base_skill_piano} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341026: {'name': f"{SkillNames.base_skill_piano} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341027: {'name': f"{SkillNames.base_skill_piano} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341028: {'name': f"{SkillNames.base_skill_piano} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x7334102A: {'name': f"{SkillNames.base_skill_violin} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334102B: {'name': f"{SkillNames.base_skill_violin} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334102C: {'name': f"{SkillNames.base_skill_violin} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334102D: {'name': f"{SkillNames.base_skill_violin} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334102E: {'name': f"{SkillNames.base_skill_violin} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334102F: {'name': f"{SkillNames.base_skill_violin} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341030: {'name': f"{SkillNames.base_skill_violin} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341031: {'name': f"{SkillNames.base_skill_violin} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341032: {'name': f"{SkillNames.base_skill_violin} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341034: {'name': f"{SkillNames.base_skill_charisma} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341035: {'name': f"{SkillNames.base_skill_charisma} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341036: {'name': f"{SkillNames.base_skill_charisma} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341037: {'name': f"{SkillNames.base_skill_charisma} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341038: {'name': f"{SkillNames.base_skill_charisma} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341039: {'name': f"{SkillNames.base_skill_charisma} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334103A: {'name': f"{SkillNames.base_skill_charisma} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334103B: {'name': f"{SkillNames.base_skill_charisma} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334103C: {'name': f"{SkillNames.base_skill_charisma} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x7334103E: {'name': f"{SkillNames.base_skill_cooking} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334103F: {'name': f"{SkillNames.base_skill_cooking} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341040: {'name': f"{SkillNames.base_skill_cooking} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341041: {'name': f"{SkillNames.base_skill_cooking} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341042: {'name': f"{SkillNames.base_skill_cooking} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341043: {'name': f"{SkillNames.base_skill_cooking} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341044: {'name': f"{SkillNames.base_skill_cooking} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341045: {'name': f"{SkillNames.base_skill_cooking} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341046: {'name': f"{SkillNames.base_skill_cooking} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341048: {'name': f"{SkillNames.base_skill_fishing} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341049: {'name': f"{SkillNames.base_skill_fishing} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334104A: {'name': f"{SkillNames.base_skill_fishing} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334104B: {'name': f"{SkillNames.base_skill_fishing} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334104C: {'name': f"{SkillNames.base_skill_fishing} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334104D: {'name': f"{SkillNames.base_skill_fishing} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334104E: {'name': f"{SkillNames.base_skill_fishing} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334104F: {'name': f"{SkillNames.base_skill_fishing} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341050: {'name': f"{SkillNames.base_skill_fishing} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341052: {'name': f"{SkillNames.base_skill_fitness} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341053: {'name': f"{SkillNames.base_skill_fitness} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341054: {'name': f"{SkillNames.base_skill_fitness} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341055: {'name': f"{SkillNames.base_skill_fitness} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341056: {'name': f"{SkillNames.base_skill_fitness} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341057: {'name': f"{SkillNames.base_skill_fitness} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341058: {'name': f"{SkillNames.base_skill_fitness} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341059: {'name': f"{SkillNames.base_skill_fitness} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334105A: {'name': f"{SkillNames.base_skill_fitness} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x7334105C: {'name': f"{SkillNames.base_skill_gardening} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334105D: {'name': f"{SkillNames.base_skill_gardening} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334105E: {'name': f"{SkillNames.base_skill_gardening} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334105F: {'name': f"{SkillNames.base_skill_gardening} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341060: {'name': f"{SkillNames.base_skill_gardening} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341061: {'name': f"{SkillNames.base_skill_gardening} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341062: {'name': f"{SkillNames.base_skill_gardening} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341063: {'name': f"{SkillNames.base_skill_gardening} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341064: {'name': f"{SkillNames.base_skill_gardening} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341066: {'name': f"{SkillNames.base_skill_gourmet} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341067: {'name': f"{SkillNames.base_skill_gourmet} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341068: {'name': f"{SkillNames.base_skill_gourmet} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341069: {'name': f"{SkillNames.base_skill_gourmet} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334106A: {'name': f"{SkillNames.base_skill_gourmet} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334106B: {'name': f"{SkillNames.base_skill_gourmet} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334106C: {'name': f"{SkillNames.base_skill_gourmet} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334106D: {'name': f"{SkillNames.base_skill_gourmet} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334106E: {'name': f"{SkillNames.base_skill_gourmet} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341070: {'name': f"{SkillNames.base_skill_handiness} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341071: {'name': f"{SkillNames.base_skill_handiness} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341072: {'name': f"{SkillNames.base_skill_handiness} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341073: {'name': f"{SkillNames.base_skill_handiness} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341074: {'name': f"{SkillNames.base_skill_handiness} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341075: {'name': f"{SkillNames.base_skill_handiness} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341076: {'name': f"{SkillNames.base_skill_handiness} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341077: {'name': f"{SkillNames.base_skill_handiness} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341078: {'name': f"{SkillNames.base_skill_handiness} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x7334107A: {'name': f"{SkillNames.base_skill_mischief} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334107B: {'name': f"{SkillNames.base_skill_mischief} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334107C: {'name': f"{SkillNames.base_skill_mischief} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334107D: {'name': f"{SkillNames.base_skill_mischief} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334107E: {'name': f"{SkillNames.base_skill_mischief} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334107F: {'name': f"{SkillNames.base_skill_mischief} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341080: {'name': f"{SkillNames.base_skill_mischief} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341081: {'name': f"{SkillNames.base_skill_mischief} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341082: {'name': f"{SkillNames.base_skill_mischief} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341084: {'name': f"{SkillNames.base_skill_mixology} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341085: {'name': f"{SkillNames.base_skill_mixology} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341086: {'name': f"{SkillNames.base_skill_mixology} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341087: {'name': f"{SkillNames.base_skill_mixology} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341088: {'name': f"{SkillNames.base_skill_mixology} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341089: {'name': f"{SkillNames.base_skill_mixology} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334108A: {'name': f"{SkillNames.base_skill_mixology} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334108B: {'name': f"{SkillNames.base_skill_mixology} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334108C: {'name': f"{SkillNames.base_skill_mixology} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x7334108E: {'name': f"{SkillNames.base_skill_painting} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334108F: {'name': f"{SkillNames.base_skill_painting} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341090: {'name': f"{SkillNames.base_skill_painting} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341091: {'name': f"{SkillNames.base_skill_painting} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341092: {'name': f"{SkillNames.base_skill_painting} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341093: {'name': f"{SkillNames.base_skill_painting} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341094: {'name': f"{SkillNames.base_skill_painting} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341095: {'name': f"{SkillNames.base_skill_painting} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341096: {'name': f"{SkillNames.base_skill_painting} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341098: {'name': f"{SkillNames.base_skill_programming} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341099: {'name': f"{SkillNames.base_skill_programming} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334109A: {'name': f"{SkillNames.base_skill_programming} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334109B: {'name': f"{SkillNames.base_skill_programming} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334109C: {'name': f"{SkillNames.base_skill_programming} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334109D: {'name': f"{SkillNames.base_skill_programming} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334109E: {'name': f"{SkillNames.base_skill_programming} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334109F: {'name': f"{SkillNames.base_skill_programming} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341100: {'name': f"{SkillNames.base_skill_programming} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341102: {'name': f"{SkillNames.base_skill_rocket_science} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341103: {'name': f"{SkillNames.base_skill_rocket_science} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341104: {'name': f"{SkillNames.base_skill_rocket_science} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341105: {'name': f"{SkillNames.base_skill_rocket_science} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341106: {'name': f"{SkillNames.base_skill_rocket_science} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341107: {'name': f"{SkillNames.base_skill_rocket_science} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341108: {'name': f"{SkillNames.base_skill_rocket_science} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341109: {'name': f"{SkillNames.base_skill_rocket_science} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334110A: {'name': f"{SkillNames.base_skill_rocket_science} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x7334110C: {'name': f"{SkillNames.base_skill_video_gaming} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334110D: {'name': f"{SkillNames.base_skill_video_gaming} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334110E: {'name': f"{SkillNames.base_skill_video_gaming} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334110F: {'name': f"{SkillNames.base_skill_video_gaming} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341110: {'name': f"{SkillNames.base_skill_video_gaming} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341111: {'name': f"{SkillNames.base_skill_video_gaming} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341112: {'name': f"{SkillNames.base_skill_video_gaming} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341113: {'name': f"{SkillNames.base_skill_video_gaming} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341114: {'name': f"{SkillNames.base_skill_video_gaming} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341116: {'name': f"{SkillNames.base_skill_writing} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341117: {'name': f"{SkillNames.base_skill_writing} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341118: {'name': f"{SkillNames.base_skill_writing} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341119: {'name': f"{SkillNames.base_skill_writing} 5",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334111A: {'name': f"{SkillNames.base_skill_writing} 6",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334111B: {'name': f"{SkillNames.base_skill_writing} 7",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334111C: {'name': f"{SkillNames.base_skill_writing} 8",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334111D: {'name': f"{SkillNames.base_skill_writing} 9",
                 'category': "Skills",
                 'expansion': "base"},
    0x7334111E: {'name': f"{SkillNames.base_skill_writing} 10",
                 'category': "Skills",
                 'expansion': "base"},

    0x73341120: {'name': f"{SkillNames.base_skill_photography} 2",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341121: {'name': f"{SkillNames.base_skill_photography} 3",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341122: {'name': f"{SkillNames.base_skill_photography} 4",
                 'category': "Skills",
                 'expansion': "base"},
    0x73341123: {'name': f"{SkillNames.base_skill_photography} 5",
                 'category': "Skills",
                 'expansion': "base"},
}

careers_locations_table = {

    0x73342001: {"name": f"{CareerNames.base_career_athlete_2}",
                 "category": "Athlete",
                 "expansion": "base"},
    0x73342002: {"name": f"{CareerNames.base_career_athlete_3}",
                 "category": "Athlete",
                 "expansion": "base"},
    0x73342003: {"name": f"{CareerNames.base_career_athlete_4}",
                 "category": "Athlete",
                 "expansion": "base"},
    0x73342004: {"name": f"{CareerNames.base_career_athlete_5A}",
                 "category": "Professional Athlete",
                 "expansion": "base"},
    0x73342005: {"name": f"{CareerNames.base_career_athlete_5B}",
                 "category": "Bodybuilder",
                 "expansion": "base"},
    0x73342006: {"name": f"{CareerNames.base_career_athlete_6A}",
                 "category": "Professional Athlete",
                 "expansion": "base"},
    0x73342007: {"name": f"{CareerNames.base_career_athlete_6B}",
                 "category": "Bodybuilder",
                 "expansion": "base"},
    0x73342008: {"name": f"{CareerNames.base_career_athlete_7A}",
                 "category": "Professional Athlete",
                 "expansion": "base"},
    0x73342009: {"name": f"{CareerNames.base_career_athlete_7B}",
                 "category": "Bodybuilder",
                 "expansion": "base"},
    0x7334200A: {"name": f"{CareerNames.base_career_athlete_8A}",
                 "category": "Professional Athlete",
                 "expansion": "base"},
    0x7334200B: {"name": f"{CareerNames.base_career_athlete_8B}",
                 "category": "Bodybuilder",
                 "expansion": "base"},
    0x7334200C: {"name": f"{CareerNames.base_career_athlete_9A}",
                 "category": "Professional Athlete",
                 "expansion": "base"},
    0x7334200D: {"name": f"{CareerNames.base_career_athlete_9B}",
                 "category": "Bodybuilder",
                 "expansion": "base"},
    0x7334200E: {"name": f"{CareerNames.base_career_athlete_10A}",
                 "category": "Professional Athlete",
                 "expansion": "base"},
    0x7334200F: {"name": f"{CareerNames.base_career_athlete_10B}",
                 "category": "Bodybuilder",
                 "expansion": "base"},

    0x73342011: {"name": f"{CareerNames.base_career_business_2}",
                 "category": "Business",
                 "expansion": "base"},
    0x73342012: {"name": f"{CareerNames.base_career_business_3}",
                 "category": "Business",
                 "expansion": "base"},
    0x73342013: {"name": f"{CareerNames.base_career_business_4}",
                 "category": "Business",
                 "expansion": "base"},
    0x73342014: {"name": f"{CareerNames.base_career_business_5}",
                 "category": "Business",
                 "expansion": "base"},
    0x73342015: {"name": f"{CareerNames.base_career_business_6}",
                 "category": "Business",
                 "expansion": "base"},
    0x73342016: {"name": f"{CareerNames.base_career_business_7A}",
                 "category": "Management",
                 "expansion": "base"},
    0x73342017: {"name": f"{CareerNames.base_career_business_8A}",
                 "category": "Management",
                 "expansion": "base"},
    0x73342018: {"name": f"{CareerNames.base_career_business_9A}",
                 "category": "Management",
                 "expansion": "base"},
    0x73342019: {"name": f"{CareerNames.base_career_business_10A}",
                 "category": "Management",
                 "expansion": "base"},
    0x7334201A: {"name": f"{CareerNames.base_career_business_7B}",
                 "category": "Investor",
                 "expansion": "base"},
    0x7334201B: {"name": f"{CareerNames.base_career_business_8B}",
                 "category": "Investor",
                 "expansion": "base"},
    0x7334201C: {"name": f"{CareerNames.base_career_business_9B}",
                 "category": "Investor",
                 "expansion": "base"},
    0x7334201D: {"name": f"{CareerNames.base_career_business_10B}",
                 "category": "Investor",
                 "expansion": "base"},

    0x7334201F: {"name": f"{CareerNames.base_career_criminal_2}",
                 "category": "Criminal",
                 "expansion": "base"},
    0x73342020: {"name": f"{CareerNames.base_career_criminal_3}",
                 "category": "Criminal",
                 "expansion": "base"},
    0x73342021: {"name": f"{CareerNames.base_career_criminal_4}",
                 "category": "Criminal",
                 "expansion": "base"},
    0x73342022: {"name": f"{CareerNames.base_career_criminal_5}",
                 "category": "Criminal",
                 "expansion": "base"},
    0x73342023: {"name": f"{CareerNames.base_career_criminal_6A}",
                 "category": "Crime Boss",
                 "expansion": "base"},
    0x73342024: {"name": f"{CareerNames.base_career_criminal_7A}",
                 "category": "Crime Boss",
                 "expansion": "base"},
    0x73342025: {"name": f"{CareerNames.base_career_criminal_8A}",
                 "category": "Crime Boss",
                 "expansion": "base"},
    0x73342026: {"name": f"{CareerNames.base_career_criminal_9A}",
                 "category": "Crime Boss",
                 "expansion": "base"},
    0x73342027: {"name": f"{CareerNames.base_career_criminal_10A}",
                 "category": "Crime Boss",
                 "expansion": "base"},
    0x73342028: {"name": f"{CareerNames.base_career_criminal_6B}",
                 "category": "Oracle",
                 "expansion": "base"},
    0x73342029: {"name": f"{CareerNames.base_career_criminal_7B}",
                 "category": "Oracle",
                 "expansion": "base"},
    0x7334202A: {"name": f"{CareerNames.base_career_criminal_8B}",
                 "category": "Oracle",
                 "expansion": "base"},
    0x7334202B: {"name": f"{CareerNames.base_career_criminal_9B}",
                 "category": "Oracle",
                 "expansion": "base"},
    0x7334202C: {"name": f"{CareerNames.base_career_criminal_10B}",
                 "category": "Oracle",
                 "expansion": "base"},

    0x7334202E: {"name": f"{CareerNames.base_career_culinary_2}",
                 "category": "Culinary",
                 "expansion": "base"},
    0x7334202F: {"name": f"{CareerNames.base_career_culinary_3}",
                 "category": "Culinary",
                 "expansion": "base"},
    0x73342030: {"name": f"{CareerNames.base_career_culinary_4}",
                 "category": "Culinary",
                 "expansion": "base"},
    0x73342031: {"name": f"{CareerNames.base_career_culinary_5}",
                 "category": "Culinary",
                 "expansion": "base"},
    0x73342032: {"name": f"{CareerNames.base_career_culinary_6A}",
                 "category": "Chef",
                 "expansion": "base"},
    0x73342033: {"name": f"{CareerNames.base_career_culinary_7A}",
                 "category": "Chef",
                 "expansion": "base"},
    0x73342034: {"name": f"{CareerNames.base_career_culinary_8A}",
                 "category": "Chef",
                 "expansion": "base"},
    0x73342035: {"name": f"{CareerNames.base_career_culinary_9A}",
                 "category": "Chef",
                 "expansion": "base"},
    0x73342036: {"name": f"{CareerNames.base_career_culinary_10A}",
                 "category": "Chef",
                 "expansion": "base"},
    0x73342037: {"name": f"{CareerNames.base_career_culinary_6B}",
                 "category": "Mixologist",
                 "expansion": "base"},
    0x73342038: {"name": f"{CareerNames.base_career_culinary_7B}",
                 "category": "Mixologist",
                 "expansion": "base"},
    0x73342039: {"name": f"{CareerNames.base_career_culinary_8B}",
                 "category": "Mixologist",
                 "expansion": "base"},
    0x7334203A: {"name": f"{CareerNames.base_career_culinary_9B}",
                 "category": "Mixologist",
                 "expansion": "base"},
    0x7334203B: {"name": f"{CareerNames.base_career_culinary_10B}",
                 "category": "Mixologist",
                 "expansion": "base"},

    0x7334203D: {"name": f"{CareerNames.base_career_painter_2}",
                 "category": "Painter",
                 "expansion": "base"},
    0x7334203E: {"name": f"{CareerNames.base_career_painter_3}",
                 "category": "Painter",
                 "expansion": "base"},
    0x7334203F: {"name": f"{CareerNames.base_career_painter_4}",
                 "category": "Painter",
                 "expansion": "base"},
    0x73342040: {"name": f"{CareerNames.base_career_painter_5}",
                 "category": "Painter",
                 "expansion": "base"},
    0x73342041: {"name": f"{CareerNames.base_career_painter_6}",
                 "category": "Painter",
                 "expansion": "base"},
    0x73342042: {"name": f"{CareerNames.base_career_painter_7A}",
                 "category": "Master of the Real",
                 "expansion": "base"},
    0x73342043: {"name": f"{CareerNames.base_career_painter_8A}",
                 "category": "Master of the Real",
                 "expansion": "base"},
    0x73342044: {"name": f"{CareerNames.base_career_painter_9A}",
                 "category": "Master of the Real",
                 "expansion": "base"},
    0x73342045: {"name": f"{CareerNames.base_career_painter_10A}",
                 "category": "Master of the Real",
                 "expansion": "base"},
    0x73342046: {"name": f"{CareerNames.base_career_painter_7B}",
                 "category": "Patron of the Arts",
                 "expansion": "base"},
    0x73342047: {"name": f"{CareerNames.base_career_painter_8B}",
                 "category": "Patron of the Arts",
                 "expansion": "base"},
    0x73342048: {"name": f"{CareerNames.base_career_painter_9B}",
                 "category": "Patron of the Arts",
                 "expansion": "base"},
    0x73342049: {"name": f"{CareerNames.base_career_painter_10B}",
                 "category": "Patron of the Arts",
                 "expansion": "base"},

    0x7334204B: {"name": f"{CareerNames.base_career_astronaut_2}",
                 "category": "Astronaut",
                 "expansion": "base"},
    0x7334204C: {"name": f"{CareerNames.base_career_astronaut_3}",
                 "category": "Astronaut",
                 "expansion": "base"},
    0x7334204D: {"name": f"{CareerNames.base_career_astronaut_4}",
                 "category": "Astronaut",
                 "expansion": "base"},
    0x7334204E: {"name": f"{CareerNames.base_career_astronaut_5}",
                 "category": "Astronaut",
                 "expansion": "base"},
    0x7334204F: {"name": f"{CareerNames.base_career_astronaut_6}",
                 "category": "Astronaut",
                 "expansion": "base"},
    0x73342050: {"name": f"{CareerNames.base_career_astronaut_7}",
                 "category": "Astronaut",
                 "expansion": "base"},
    0x73342051: {"name": f"{CareerNames.base_career_astronaut_8A}",
                 "category": "Space Ranger",
                 "expansion": "base"},
    0x73342052: {"name": f"{CareerNames.base_career_astronaut_9A}",
                 "category": "Space Ranger",
                 "expansion": "base"},
    0x73342053: {"name": f"{CareerNames.base_career_astronaut_10A}",
                 "category": "Space Ranger",
                 "expansion": "base"},
    0x73342054: {"name": f"{CareerNames.base_career_astronaut_8B}",
                 "category": "Interstellar Smuggler",
                 "expansion": "base"},
    0x73342055: {"name": f"{CareerNames.base_career_astronaut_9B}",
                 "category": "Interstellar Smuggler",
                 "expansion": "base"},
    0x73342056: {"name": f"{CareerNames.base_career_astronaut_10B}",
                 "category": "Interstellar Smuggler",
                 "expansion": "base"},

    0x73342058: {"name": f"{CareerNames.base_career_entertainer_2}",
                 "category": "Entertainer",
                 "expansion": "base"},
    0x73342059: {"name": f"{CareerNames.base_career_entertainer_3}",
                 "category": "Entertainer",
                 "expansion": "base"},
    0x7334205A: {"name": f"{CareerNames.base_career_entertainer_4}",
                 "category": "Entertainer",
                 "expansion": "base"},
    0x7334205B: {"name": f"{CareerNames.base_career_entertainer_5A}",
                 "category": "Musician",
                 "expansion": "base"},
    0x7334205C: {"name": f"{CareerNames.base_career_entertainer_6A}",
                 "category": "Musician",
                 "expansion": "base"},
    0x7334205D: {"name": f"{CareerNames.base_career_entertainer_7A}",
                 "category": "Musician",
                 "expansion": "base"},
    0x7334205E: {"name": f"{CareerNames.base_career_entertainer_8A}",
                 "category": "Musician",
                 "expansion": "base"},
    0x7334205F: {"name": f"{CareerNames.base_career_entertainer_9A}",
                 "category": "Musician",
                 "expansion": "base"},
    0x73342060: {"name": f"{CareerNames.base_career_entertainer_10A}",
                 "category": "Musician",
                 "expansion": "base"},
    0x73342061: {"name": f"{CareerNames.base_career_entertainer_5B}",
                 "category": "Comedian",
                 "expansion": "base"},
    0x73342062: {"name": f"{CareerNames.base_career_entertainer_6B}",
                 "category": "Comedian",
                 "expansion": "base"},
    0x73342063: {"name": f"{CareerNames.base_career_entertainer_7B}",
                 "category": "Comedian",
                 "expansion": "base"},
    0x73342064: {"name": f"{CareerNames.base_career_entertainer_8B}",
                 "category": "Comedian",
                 "expansion": "base"},
    0x73342065: {"name": f"{CareerNames.base_career_entertainer_9B}",
                 "category": "Comedian",
                 "expansion": "base"},
    0x73342066: {"name": f"{CareerNames.base_career_entertainer_10B}",
                 "category": "Comedian",
                 "expansion": "base"},

    0x73342068: {"name": f"{CareerNames.base_career_secret_agent_2}",
                 "category": "Secret Agent",
                 "expansion": "base"},
    0x73342069: {"name": f"{CareerNames.base_career_secret_agent_3}",
                 "category": "Secret Agent",
                 "expansion": "base"},
    0x7334206A: {"name": f"{CareerNames.base_career_secret_agent_4}",
                 "category": "Secret Agent",
                 "expansion": "base"},
    0x7334206B: {"name": f"{CareerNames.base_career_secret_agent_5}",
                 "category": "Secret Agent",
                 "expansion": "base"},
    0x7334206C: {"name": f"{CareerNames.base_career_secret_agent_6}",
                 "category": "Secret Agent",
                 "expansion": "base"},
    0x7334206D: {"name": f"{CareerNames.base_career_secret_agent_7}",
                 "category": "Secret Agent",
                 "expansion": "base"},
    0x7334206E: {"name": f"{CareerNames.base_career_secret_agent_8A}",
                 "category": "Diamond Agent",
                 "expansion": "base"},
    0x7334206F: {"name": f"{CareerNames.base_career_secret_agent_9A}",
                 "category": "Diamond Agent",
                 "expansion": "base"},
    0x73342070: {"name": f"{CareerNames.base_career_secret_agent_10A}",
                 "category": "Diamond Agent",
                 "expansion": "base"},
    0x73342071: {"name": f"{CareerNames.base_career_secret_agent_8B}",
                 "category": "Villain",
                 "expansion": "base"},
    0x73342072: {"name": f"{CareerNames.base_career_secret_agent_9B}",
                 "category": "Villain",
                 "expansion": "base"},
    0x73342073: {"name": f"{CareerNames.base_career_secret_agent_10B}",
                 "category": "Villain",
                 "expansion": "base"},
    0x73342074: {"name": f"{CareerNames.base_career_secret_agent_11B}",
                 "category": "Villain",
                 "expansion": "base"},

    0x73342076: {"name": f"{CareerNames.base_career_style_influencer_2}",
                 "category": "Style Influencer",
                 "expansion": "base"},
    0x73342077: {"name": f"{CareerNames.base_career_style_influencer_3}",
                 "category": "Style Influencer",
                 "expansion": "base"},
    0x73342078: {"name": f"{CareerNames.base_career_style_influencer_4}",
                 "category": "Style Influencer",
                 "expansion": "base"},
    0x73342079: {"name": f"{CareerNames.base_career_style_influencer_5}",
                 "category": "Style Influencer",
                 "expansion": "base"},
    0x7334207A: {"name": f"{CareerNames.base_career_style_influencer_6A}",
                 "category": "Stylist",
                 "expansion": "base"},
    0x7334207B: {"name": f"{CareerNames.base_career_style_influencer_7A}",
                 "category": "Stylist",
                 "expansion": "base"},
    0x7334207C: {"name": f"{CareerNames.base_career_style_influencer_8A}",
                 "category": "Stylist",
                 "expansion": "base"},
    0x7334207D: {"name": f"{CareerNames.base_career_style_influencer_9A}",
                 "category": "Stylist",
                 "expansion": "base"},
    0x7334207E: {"name": f"{CareerNames.base_career_style_influencer_10A}",
                 "category": "Stylist",
                 "expansion": "base"},
    0x7334207F: {"name": f"{CareerNames.base_career_style_influencer_6B}",
                 "category": "Trend Setter",
                 "expansion": "base"},
    0x73342080: {"name": f"{CareerNames.base_career_style_influencer_7B}",
                 "category": "Trend Setter",
                 "expansion": "base"},
    0x73342081: {"name": f"{CareerNames.base_career_style_influencer_8B}",
                 "category": "Trend Setter",
                 "expansion": "base"},
    0x73342082: {"name": f"{CareerNames.base_career_style_influencer_9B}",
                 "category": "Trend Setter",
                 "expansion": "base"},
    0x73342083: {"name": f"{CareerNames.base_career_style_influencer_10B}",
                 "category": "Trend Setter",
                 "expansion": "base"},

    0x73342085: {"name": f"{CareerNames.base_career_tech_guru_2}",
                 "category": "Tech Guru",
                 "expansion": "base"},
    0x73342086: {"name": f"{CareerNames.base_career_tech_guru_3}",
                 "category": "Tech Guru",
                 "expansion": "base"},
    0x73342087: {"name": f"{CareerNames.base_career_tech_guru_4}",
                 "category": "Tech Guru",
                 "expansion": "base"},
    0x73342088: {"name": f"{CareerNames.base_career_tech_guru_5}",
                 "category": "Tech Guru",
                 "expansion": "base"},
    0x73342089: {"name": f"{CareerNames.base_career_tech_guru_6}",
                 "category": "Tech Guru",
                 "expansion": "base"},
    0x7334208A: {"name": f"{CareerNames.base_career_tech_guru_7A}",
                 "category": "eSport Gamer",
                 "expansion": "base"},
    0x7334208B: {"name": f"{CareerNames.base_career_tech_guru_8A}",
                 "category": "eSport Gamer",
                 "expansion": "base"},
    0x7334208C: {"name": f"{CareerNames.base_career_tech_guru_9A}",
                 "category": "eSport Gamer",
                 "expansion": "base"},
    0x7334208D: {"name": f"{CareerNames.base_career_tech_guru_10A}",
                 "category": "eSport Gamer",
                 "expansion": "base"},
    0x7334208E: {"name": f"{CareerNames.base_career_tech_guru_7B}",
                 "category": "Start-up Entrepreneur",
                 "expansion": "base"},
    0x7334208F: {"name": f"{CareerNames.base_career_tech_guru_8B}",
                 "category": "Start-up Entrepreneur",
                 "expansion": "base"},
    0x73342090: {"name": f"{CareerNames.base_career_tech_guru_9B}",
                 "category": "Start-up Entrepreneur",
                 "expansion": "base"},
    0x73342091: {"name": f"{CareerNames.base_career_tech_guru_10B}",
                 "category": "Start-up Entrepreneur",
                 "expansion": "base"},

    0x73342093: {"name": f"{CareerNames.base_career_writer_2}",
                 "category": "Writer",
                 "expansion": "base"},
    0x73342094: {"name": f"{CareerNames.base_career_writer_3}",
                 "category": "Writer",
                 "expansion": "base"},
    0x73342095: {"name": f"{CareerNames.base_career_writer_4}",
                 "category": "Writer",
                 "expansion": "base"},
    0x73342096: {"name": f"{CareerNames.base_career_writer_5}",
                 "category": "Writer",
                 "expansion": "base"},
    0x73342097: {"name": f"{CareerNames.base_career_writer_6A}",
                 "category": "Author",
                 "expansion": "base"},
    0x73342098: {"name": f"{CareerNames.base_career_writer_7A}",
                 "category": "Author",
                 "expansion": "base"},
    0x73342099: {"name": f"{CareerNames.base_career_writer_8A}",
                 "category": "Author",
                 "expansion": "base"},
    0x7334209A: {"name": f"{CareerNames.base_career_writer_9A}",
                 "category": "Author",
                 "expansion": "base"},
    0x7334209B: {"name": f"{CareerNames.base_career_writer_10A}",
                 "category": "Author",
                 "expansion": "base"},
    0x7334209C: {"name": f"{CareerNames.base_career_writer_6B}",
                 "category": "Journalist",
                 "expansion": "base"},
    0x7334209D: {"name": f"{CareerNames.base_career_writer_7B}",
                 "category": "Journalist",
                 "expansion": "base"},
    0x7334209E: {"name": f"{CareerNames.base_career_writer_8B}",
                 "category": "Journalist",
                 "expansion": "base"},
    0x7334209F: {"name": f"{CareerNames.base_career_writer_9B}",
                 "category": "Journalist",
                 "expansion": "base"},
    0x733420A0: {"name": f"{CareerNames.base_career_writer_10B}",
                 "category": "Journalist",
                 "expansion": "base"},

}

ptj_locations_table = {

    0x733420A2: {"name": f"{CareerNames.base_ptj_babysitter_2}",
                 "category": "Babysitter",
                 "expansion": "base"},
    0x733420A3: {"name": f"{CareerNames.base_ptj_babysitter_3}",
                 "category": "Babysitter",
                 "expansion": "base"},

    0x733420A5: {"name": f"{CareerNames.base_ptj_barista_2}",
                 "category": "Barista",
                 "expansion": "base"},
    0x733420A6: {"name": f"{CareerNames.base_ptj_barista_3}",
                 "category": "Barista",
                 "expansion": "base"},

    0x733420A8: {"name": f"{CareerNames.base_ptj_retail_employee_2}",
                 "category": "Retail Employee",
                 "expansion": "base"},
    0x733420A9: {"name": f"{CareerNames.base_ptj_retail_employee_3}",
                 "category": "Retail Employee",
                 "expansion": "base"},

    0x733420AB: {"name": f"{CareerNames.base_ptj_manual_laborer_2}",
                 "category": "Manual Laborer",
                 "expansion": "base"},
    0x733420AC: {"name": f"{CareerNames.base_ptj_manual_laborer_3}",
                 "category": "Manual Laborer",
                 "expansion": "base"},

    0x733420AE: {"name": f"{CareerNames.base_ptj_fastfood_employee_2}",
                 "category": "Fastfood Employee",
                 "expansion": "base"},
    0x733420AF: {"name": f"{CareerNames.base_ptj_fastfood_employee_3}",
                 "category": "Fastfood Employee",
                 "expansion": "base"},
}

aspiration_locations_table = {
    0x73343000: {"name": f"{AspirationNames.base_aspiration_basic_trainer}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343001: {"name": f"{AspirationNames.base_aspiration_exercise_demon}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343002: {"name": f"{AspirationNames.base_aspiration_fit_to_a_t}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343003: {"name": f"{AspirationNames.base_aspiration_bodybuilder}",
                 "category": "Aspirations",
                 "expansion": "base"},
    # Creativity Aspirations
    0x73343004: {"name": f"{AspirationNames.base_aspiration_ill_at_easel}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343005: {"name": f"{AspirationNames.base_aspiration_fine_artist}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343006: {"name": f"{AspirationNames.base_aspiration_brushing_with_greatness}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343007: {"name": f"{AspirationNames.base_aspiration_painter_extraordinaire}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343008: {"name": f"{AspirationNames.base_aspiration_fledgelinguist}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343009: {"name": f"{AspirationNames.base_aspiration_competent_wordsmith}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334300A: {"name": f"{AspirationNames.base_aspiration_novelest_novelist}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334300B: {"name": f"{AspirationNames.base_aspiration_bestselling_author}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334300C: {"name": f"{AspirationNames.base_aspiration_tone_deaf}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334300D: {"name": f"{AspirationNames.base_aspiration_fine_tuned}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334300E: {"name": f"{AspirationNames.base_aspiration_harmonious}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334300F: {"name": f"{AspirationNames.base_aspiration_musical_genius}",
                 "category": "Aspirations",
                 "expansion": "base"},
    # Deviance Aspirations
    0x73343010: {"name": f"{AspirationNames.base_aspiration_mostly_harmless}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343011: {"name": f"{AspirationNames.base_aspiration_neighborhood_nuisance}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343012: {"name": f"{AspirationNames.base_aspiration_criminal_mind}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343013: {"name": f"{AspirationNames.base_aspiration_public_enemy}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343014: {"name": f"{AspirationNames.base_aspiration_artful_trickster}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343015: {"name": f"{AspirationNames.base_aspiration_professional_prankster}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343016: {"name": f"{AspirationNames.base_aspiration_chief_of_mischief}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343017: {"name": f"{AspirationNames.base_aspiration_villainous_valentine}",
                 "category": "Aspirations",
                 "expansion": "base"},
    # Family Aspirations (Successful Lineage, Big Happy Family)
    0x73343018: {"name": f"{AspirationNames.base_aspiration_readily_a_parent}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343019: {"name": f"{AspirationNames.base_aspiration_caregiver}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334301A: {"name": f"{AspirationNames.base_aspiration_trusted_mentor}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334301B: {"name": f"{AspirationNames.base_aspiration_successful_lineage}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334301C: {"name": f"{AspirationNames.base_aspiration_loving_guardian}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334301D: {"name": f"{AspirationNames.base_aspiration_big_happy_family}",
                 "category": "Aspirations",
                 "expansion": "base"},
    # Food Aspirations (Master Chef, Master Mixologist)
    0x7334301E: {"name": f"{AspirationNames.base_aspiration_aluminum_chef}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334301F: {"name": f"{AspirationNames.base_aspiration_captain_cook}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343020: {"name": f"{AspirationNames.base_aspiration_culinary_artist}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343021: {"name": f"{AspirationNames.base_aspiration_master_chef}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343022: {"name": f"{AspirationNames.base_aspiration_bar_tenderfoot}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343023: {"name": f"{AspirationNames.base_aspiration_electric_mixer}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343024: {"name": f"{AspirationNames.base_aspiration_beverage_boss}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343025: {"name": f"{AspirationNames.base_aspiration_master_mixologist}",
                 "category": "Aspirations",
                 "expansion": "base"},
    # Fortune Aspirations (Fabulously Wealthy, Mansion Baron)
    0x73343026: {"name": f"{AspirationNames.base_aspiration_going_for_not_broke}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343027: {"name": f"{AspirationNames.base_aspiration_learning_earning}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343028: {"name": f"{AspirationNames.base_aspiration_welloff}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343029: {"name": f"{AspirationNames.base_aspiration_fabulously_wealthy}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334302A: {"name": f"{AspirationNames.base_aspiration_estate_of_the_art}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334302B: {"name": f"{AspirationNames.base_aspiration_the_great_landscaper}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334302C: {"name": f"{AspirationNames.base_aspiration_home_renovator}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334302D: {"name": f"{AspirationNames.base_aspiration_mansion_baron}",
                 "category": "Aspirations",
                 "expansion": "base"},
    # Knowledge Aspirations (Renaissance Sim, Nerd Brain, Computer Whiz)
    0x7334302E: {"name": f"{AspirationNames.base_aspiration_prudent_student}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334302F: {"name": f"{AspirationNames.base_aspiration_jack_of_some_trades}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343030: {"name": f"{AspirationNames.base_aspiration_pantologist}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343031: {"name": f"{AspirationNames.base_aspiration_renaissance_sim}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343032: {"name": f"{AspirationNames.base_aspiration_erudite}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343033: {"name": f"{AspirationNames.base_aspiration_rocket_scientist}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343034: {"name": f"{AspirationNames.base_aspiration_nerd_brain}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343035: {"name": f"{AspirationNames.base_aspiration_with_the_program}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343036: {"name": f"{AspirationNames.base_aspiration_technically_adept}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343037: {"name": f"{AspirationNames.base_aspiration_computer_geek}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343038: {"name": f"{AspirationNames.base_aspiration_computer_whiz}",
                 "category": "Aspirations",
                 "expansion": "base"},
    # Love Aspirations (Serial Romantic, Soulmate)
    0x73343039: {"name": f"{AspirationNames.base_aspiration_amore_amateur}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334303A: {"name": f"{AspirationNames.base_aspiration_up_to_date}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334303B: {"name": f"{AspirationNames.base_aspiration_romance_juggler}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334303C: {"name": f"{AspirationNames.base_aspiration_serial_romantic}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334303D: {"name": f"{AspirationNames.base_aspiration_marriage_material}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334303E: {"name": f"{AspirationNames.base_aspiration_love_handler}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334303F: {"name": f"{AspirationNames.base_aspiration_soulmate}",
                 "category": "Aspirations",
                 "expansion": "base"},
    # Nature Aspirations (Freelance Botanist, The Curator, Angling Ace)
    0x73343040: {"name": f"{AspirationNames.base_aspiration_naturewalker}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343041: {"name": f"{AspirationNames.base_aspiration_garden_variety}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343042: {"name": f"{AspirationNames.base_aspiration_nature_nurturer}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343043: {"name": f"{AspirationNames.base_aspiration_freelance_botanist}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343044: {"name": f"{AspirationNames.base_aspiration_out_and_about}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343045: {"name": f"{AspirationNames.base_aspiration_gatherer}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343046: {"name": f"{AspirationNames.base_aspiration_treasure_hunter}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343047: {"name": f"{AspirationNames.base_aspiration_the_curator}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343048: {"name": f"{AspirationNames.base_aspiration_fish_out_of_water}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343049: {"name": f"{AspirationNames.base_aspiration_hooked}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334304A: {"name": f"{AspirationNames.base_aspiration_reel_smart}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334304B: {"name": f"{AspirationNames.base_aspiration_angling_ace}",
                 "category": "Aspirations",
                 "expansion": "base"},
    # Popularity Aspirations (Joke Star, Party Animal, Friend of the World, Neighborhood Confidante)
    0x7334304C: {"name": f"{AspirationNames.base_aspiration_practical_joker}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334304D: {"name": f"{AspirationNames.base_aspiration_standup_startup}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334304E: {"name": f"{AspirationNames.base_aspiration_funny}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x7334304F: {"name": f"{AspirationNames.base_aspiration_joke_star}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343050: {"name": f"{AspirationNames.base_aspiration_new_in_town}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343051: {"name": f"{AspirationNames.base_aspiration_welcoming_host}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343052: {"name": f"{AspirationNames.base_aspiration_sir_gala_had}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343053: {"name": f"{AspirationNames.base_aspiration_party_animal}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343054: {"name": f"{AspirationNames.base_aspiration_well_liked}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343055: {"name": f"{AspirationNames.base_aspiration_super_friend}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343056: {"name": f"{AspirationNames.base_aspiration_friend_of_the_world}",
                 "category": "Aspirations",
                 "expansion": "base"},
    0x73343057: {"name": f"{AspirationNames.base_aspiration_neighborly_advisor}",
                 "category": "Aspirations",
                 "expansion": "base"},
}

location_table = {
    **skill_locations_table,
    **careers_locations_table,
    **aspiration_locations_table,
    **ptj_locations_table,
}
