from typing import NamedTuple, Optional
from enum import Enum, IntEnum, auto, Flag
from BaseClasses import Location, Region

# from .Randomizer.Dungeons import Dungeon


class NodeID(IntEnum):
    Ordon = 0x0
    Sewers = 0x01
    Faron = 0x02
    Eldin = 0x03
    Lanayru = 0x04
    Hyrule_Field = 0x06
    Sacred_Grove = 0x07
    Snowpeak = 0x08
    Castle_Town = 0x09
    Gerudo_Desert = 0x0A
    Fishing_Pond = 0x0B
    Forest_Temple = 0x10
    Goron_Mines = 0x11
    Lakebed_Temple = 0x12
    Arbiters_Grounds = 0x13
    Snowpeak_Ruins = 0x14
    Temple_of_Time = 0x15
    City_in_the_Sky = 0x16
    Palace_of_Twilight = 0x17
    Hyrule_Castle = 0x18
    Cave_of_Ordeals = 0x19
    Lake_Hylia_Cave = 0x1A
    Grotto = 0x1B
    Menu = 0xFF


class TPStages(Enum):
    Lakebed_Temple = "Lakebed Temple"
    Goron_Mines = "Goron Mines"
    Forest_Temple = "Forest Temple"
    Temple_of_Time = "Temple of Time"
    City_in_the_Sky = "City in The Sky"
    Palace_of_Twilight = "Palace of Twilight"
    Hyrule_Castle = "Hyrule Castle"
    Arbiters_Grounds = "Arbiters Grounds"
    Snowpeak_Ruins = "Snowpeak Ruins"
    Lanayru_Ice_Puzzle_Cave = "Lanayru Ice Puzzle Cave"
    Cave_of_Ordeals = "Cave of Ordeals"
    Eldin_Long_Cave = "Eldin Long Cave"
    Lake_Hylia_Long_Cave = "Lake Hylia Long Cave"
    Eldin_Goron_Stockcave = "Eldin Goron Stockcave"
    Grotto = "Grotto"
    Faron_Woods_Cave = "Faron Woods Cave"
    Ordon_Ranch = "Ordon Ranch"
    Ordon_Village = "Ordon Village"
    Ordon_Spring = "Ordon Spring"
    Faron_Woods = "Faron Woods"
    Kakariko_Village = "Kakariko Village"
    Death_Mountain = "Death Mountain"
    Kakariko_Graveyard = "Kakariko Graveyard"
    Zoras_River = "Zoras River"
    Zoras_Domain = "Zoras Domain"
    Snowpeak = "Snowpeak"
    Lake_Hylia = "Lake Hylia"
    Castle_Town = "Castle Town"
    Sacred_Grove = "Sacred Grove"
    Bulblin_Camp = "Bulblin Camp"
    Hyrule_Field = "Hyrule Field"
    Outside_Castle_Town = "Outside Castle Town"
    Gerudo_Desert = "Gerudo Desert"
    Mirror_Chamber = "Mirror Chamber"
    Upper_Zoras_River = "Upper Zoras River"
    Fishing_Pond = "Fishing Pond"
    Hidden_Village = "Hidden Village"
    Hidden_Skill = "Hidden Skill"
    Ordon_Village_Interiors = "Ordon Village Interiors"
    Hyrule_Castle_Sewers = "Hyrule Castle Sewers"
    Faron_Woods_Interiors = "Faron Woods Interiors"
    Kakariko_Village_Interiors = "Kakariko Village Interiors"
    Death_Mountain_Interiors = "Death Mountain Interiors"
    Castle_Town_Interiors = "Castle Town Interiors"
    Fishing_Pond_Interiors = "Fishing Pond Interiors"
    Hidden_Village_Interiors = "Hidden Village Interiors"
    Castle_Town_Shops = "Castle Town Shops"
    Star_Game = "Star Game"
    Eldin_Field = "Eldin Field"
    Faron_Field = "Faron Field"
    Bublin_Camp = "Bublin Camp"
    Lanayru_Field = "Lanayru Field"
    Unkown = "Unkown"


class TPLocationType:
    # Define location types
    Event = auto()
    Region = auto()
    Flag = auto()
    Unknown = auto()


class TPFlag(Flag):

    # Define flag types for different categories of checks
    Always = auto()
    Dungeon = auto()
    Overworld = auto()
    Shop = auto()
    Boss = auto()
    Poe = auto()
    Bug = auto()
    Skill = auto()
    Story = auto()
    Heart = auto()
    Sky_Book = auto()
    Npc = auto()
    MiniBoss = auto()
    Unknown = auto()


class TPLocationData(NamedTuple):
    code: Optional[int]
    flags: TPFlag
    stage_id: TPStages
    type: TPLocationType
    region: Optional[int] = None
    offset: Optional[int] = None
    bit: Optional[int] = None


class TPLocation(Location):
    game: str = "Twilight Princess"
    # dungeon: Optional["Dungeon"] = None

    def __init__(self, player: int, name: str, parent: Region, data: TPLocationData):

        address = None if data.code is None else TPLocation.get_apid(data.code)
        super(TPLocation, self).__init__(player, name, address=address, parent=parent)

        self.code = data.code
        self.flags = data.flags
        self.type = data.type
        self.stage_id = data.stage_id

    @staticmethod
    def get_apid(code: int) -> int:
        base_id: int = 2320000
        return base_id + code


DUNGEON_NAMES = [
    "Forest Temple",
    "Goron Mines",
    "Lakebed Temple",
    "Arbiters Grounds",
    "Snowpeak Ruins",
    "Temple of Time",
    "City in The Sky",
    "Palace of Twilight",
    "Hyrule Castle",
]

LOCATION_TABLE = {
    "Arbiters Grounds Big Key Chest": TPLocationData(
        code=0,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x1,
        bit=0x10,
    ),
    "Arbiters Grounds Death Sword Chest": TPLocationData(
        code=1,
        flags=TPFlag.Dungeon | TPFlag.MiniBoss,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x2,
        bit=0x8,
    ),
    "Arbiters Grounds Dungeon Reward": TPLocationData(
        code=2,
        flags=TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x1D,
        bit=0x8,
    ),
    "Arbiters Grounds East Lower Turnable Redead Chest": TPLocationData(
        code=3,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x3,
        bit=0x40,
    ),
    "Arbiters Grounds East Turning Room Poe": TPLocationData(
        code=4,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0xA,
        bit=0x10,
    ),
    "Arbiters Grounds East Upper Turnable Chest": TPLocationData(
        code=5,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x3,
        bit=0x10,
    ),
    "Arbiters Grounds East Upper Turnable Redead Chest": TPLocationData(
        code=6,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x3,
        bit=0x20,
    ),
    "Arbiters Grounds Entrance Chest": TPLocationData(
        code=7,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x1,
        bit=0x80,
    ),
    "Arbiters Grounds Ghoul Rat Room Chest": TPLocationData(
        code=8,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x1,
        bit=0x20,
    ),
    "Arbiters Grounds Hidden Wall Poe": TPLocationData(
        code=9,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x11,
        bit=0x4,
    ),
    "Arbiters Grounds North Turning Room Chest": TPLocationData(
        code=10,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x0,
        bit=0x1,
    ),
    "Arbiters Grounds Spinner Room First Small Chest": TPLocationData(
        code=11,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x0,
        bit=0x10,
    ),
    "Arbiters Grounds Spinner Room Lower Central Small Chest": TPLocationData(
        code=12,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x0,
        bit=0x20,
    ),
    "Arbiters Grounds Spinner Room Lower North Chest": TPLocationData(
        code=13,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x0,
        bit=0x40,
    ),
    "Arbiters Grounds Spinner Room Second Small Chest": TPLocationData(
        code=14,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x0,
        bit=0x8,
    ),
    "Arbiters Grounds Spinner Room Stalfos Alcove Chest": TPLocationData(
        code=15,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x0,
        bit=0x4,
    ),
    "Arbiters Grounds Stallord Heart Container": TPLocationData(
        code=16,
        flags=TPFlag.Heart | TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x18,
        bit=0x80,
    ),
    "Arbiters Grounds Torch Room East Chest": TPLocationData(
        code=17,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x1,
        bit=0x8,
    ),
    "Arbiters Grounds Torch Room Poe": TPLocationData(
        code=18,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x8,
        bit=0x40,
    ),
    "Arbiters Grounds Torch Room West Chest": TPLocationData(
        code=19,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x1,
        bit=0x4,
    ),
    "Arbiters Grounds West Chandelier Chest": TPLocationData(
        code=20,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x3,
        bit=0x8,
    ),
    "Arbiters Grounds West Poe": TPLocationData(
        code=21,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0xF,
        bit=0x2,
    ),
    "Arbiters Grounds West Small Chest Behind Block": TPLocationData(
        code=22,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x0,
        bit=0x2,
    ),
    "Arbiters Grounds West Stalfos Northeast Chest": TPLocationData(
        code=23,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x1,
        bit=0x1,
    ),
    "Arbiters Grounds West Stalfos West Chest": TPLocationData(
        code=24,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Arbiters_Grounds,
        type=TPLocationType.Region,
        region=NodeID.Arbiters_Grounds,
        offset=0x1,
        bit=0x2,
    ),
    "City in The Sky Aeralfos Chest": TPLocationData(
        code=25,
        flags=TPFlag.Dungeon | TPFlag.MiniBoss,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x3,
        bit=0x1,
    ),
    "City in The Sky Argorok Heart Container": TPLocationData(
        code=26,
        flags=TPFlag.Heart | TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x18,
        bit=0x80,
    ),
    "City in The Sky Baba Tower Alcove Chest": TPLocationData(
        code=27,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x3,
        bit=0x40,
    ),
    "City in The Sky Baba Tower Narrow Ledge Chest": TPLocationData(
        code=28,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x1,
        bit=0x80,
    ),
    "City in The Sky Baba Tower Top Small Chest": TPLocationData(
        code=29,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x3,
        bit=0x80,
    ),
    "City in The Sky Big Key Chest": TPLocationData(
        code=30,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x2,
        bit=0x20,
    ),
    "City in The Sky Central Outside Ledge Chest": TPLocationData(
        code=31,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x0,
        bit=0x1,
    ),
    "City in The Sky Central Outside Poe Island Chest": TPLocationData(
        code=32,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x2,
        bit=0x10,
    ),
    "City in The Sky Chest Behind North Fan": TPLocationData(
        code=33,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x1,
        bit=0x2,
    ),
    "City in The Sky Chest Below Big Key Chest": TPLocationData(
        code=34,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x2,
        bit=0x40,
    ),
    "City in The Sky Dungeon Reward": TPLocationData(
        code=35,
        flags=TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x1D,
        bit=0x8,
    ),
    "City in The Sky East First Wing Chest After Fans": TPLocationData(
        code=36,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x3,
        bit=0x4,
    ),
    "City in The Sky East Tile Worm Small Chest": TPLocationData(
        code=37,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x1,
        bit=0x8,
    ),
    "City in The Sky East Wing After Dinalfos Alcove Chest": TPLocationData(
        code=38,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x1,
        bit=0x4,
    ),
    "City in The Sky East Wing After Dinalfos Ledge Chest": TPLocationData(
        code=39,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x0,
        bit=0x4,
    ),
    "City in The Sky East Wing Lower Level Chest": TPLocationData(
        code=40,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x3,
        bit=0x10,
    ),
    "City in The Sky Garden Island Poe": TPLocationData(
        code=41,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x11,
        bit=0x10,
    ),
    "City in The Sky Poe Above Central Fan": TPLocationData(
        code=42,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x11,
        bit=0x20,
    ),
    "City in The Sky Underwater East Chest": TPLocationData(
        code=43,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x0,
        bit=0x8,
    ),
    "City in The Sky Underwater West Chest": TPLocationData(
        code=44,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x3,
        bit=0x8,
    ),
    "City in The Sky West Garden Corner Chest": TPLocationData(
        code=45,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x2,
        bit=0x80,
    ),
    "City in The Sky West Garden Ledge Chest": TPLocationData(
        code=46,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x2,
        bit=0x2,
    ),
    "City in The Sky West Garden Lone Island Chest": TPLocationData(
        code=47,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x0,
        bit=0x2,
    ),
    "City in The Sky West Garden Lower Chest": TPLocationData(
        code=48,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x2,
        bit=0x8,
    ),
    "City in The Sky West Wing Baba Balcony Chest": TPLocationData(
        code=49,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x1,
        bit=0x20,
    ),
    "City in The Sky West Wing First Chest": TPLocationData(
        code=50,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x3,
        bit=0x20,
    ),
    "City in The Sky West Wing Narrow Ledge Chest": TPLocationData(
        code=51,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x1,
        bit=0x40,
    ),
    "City in The Sky West Wing Tile Worm Chest": TPLocationData(
        code=52,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.City_in_the_Sky,
        type=TPLocationType.Region,
        region=NodeID.City_in_the_Sky,
        offset=0x1,
        bit=0x10,
    ),
    "Forest Temple Big Baba Key": TPLocationData(
        code=53,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x3,
        bit=0x40,
    ),
    "Forest Temple Big Key Chest": TPLocationData(
        code=54,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x7,
        bit=0x40,
    ),
    "Forest Temple Central Chest Behind Stairs": TPLocationData(
        code=55,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x7,
        bit=0x20,
    ),
    "Forest Temple Central Chest Hanging From Web": TPLocationData(
        code=56,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x1,
        bit=0x10,
    ),
    "Forest Temple Central North Chest": TPLocationData(
        code=57,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x7,
        bit=0x80,
    ),
    "Forest Temple Diababa Heart Container": TPLocationData(
        code=58,
        flags=TPFlag.Heart | TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x18,
        bit=0x80,
    ),
    "Forest Temple Dungeon Reward": TPLocationData(
        code=59,
        flags=TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x1D,
        bit=0x8,
    ),
    "Forest Temple East Tile Worm Chest": TPLocationData(
        code=60,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x3,
        bit=0x2,
    ),
    "Forest Temple East Water Cave Chest": TPLocationData(
        code=61,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x0,
        bit=0x4,
    ),
    "Forest Temple Entrance Vines Chest": TPLocationData(
        code=62,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x3,
        bit=0x80,
    ),
    "Forest Temple Gale Boomerang": TPLocationData(
        code=63,
        flags=TPFlag.Dungeon | TPFlag.MiniBoss,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x1D,
        bit=0x80,
    ),
    "Forest Temple North Deku Like Chest": TPLocationData(
        code=64,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x3,
        bit=0x4,
    ),
    "Forest Temple Second Monkey Under Bridge Chest": TPLocationData(
        code=65,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x2,
        bit=0x2,
    ),
    "Forest Temple Totem Pole Chest": TPLocationData(
        code=66,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x0,
        bit=0x2,
    ),
    "Forest Temple West Deku Like Chest": TPLocationData(
        code=67,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x0,
        bit=0x80,
    ),
    "Forest Temple West Tile Worm Chest Behind Stairs": TPLocationData(
        code=68,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x1,
        bit=0x8,
    ),
    "Forest Temple West Tile Worm Room Vines Chest": TPLocationData(
        code=69,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x0,
        bit=0x1,
    ),
    "Forest Temple Windless Bridge Chest": TPLocationData(
        code=70,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Forest_Temple,
        type=TPLocationType.Region,
        region=NodeID.Forest_Temple,
        offset=0x3,
        bit=0x10,
    ),
    "Goron Mines After Crystal Switch Room Magnet Wall Chest": TPLocationData(
        code=71,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x2,
        bit=0x2,
    ),
    "Goron Mines Beamos Room Chest": TPLocationData(
        code=72,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x2,
        bit=0x10,
    ),
    "Goron Mines Chest Before Dangoro": TPLocationData(
        code=73,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x2,
        bit=0x20,
    ),
    "Goron Mines Crystal Switch Room Small Chest": TPLocationData(
        code=74,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x0,
        bit=0x10,
    ),
    "Goron Mines Crystal Switch Room Underwater Chest": TPLocationData(
        code=75,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x1,
        bit=0x1,
    ),
    "Goron Mines Dangoro Chest": TPLocationData(
        code=76,
        flags=TPFlag.Dungeon | TPFlag.MiniBoss,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x3,
        bit=0x40,
    ),
    "Goron Mines Dungeon Reward": TPLocationData(
        code=77,
        flags=TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x1D,
        bit=0x8,
    ),
    "Goron Mines Entrance Chest": TPLocationData(
        code=78,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x0,
        bit=0x8,
    ),
    "Goron Mines Fyrus Heart Container": TPLocationData(
        code=79,
        flags=TPFlag.Heart | TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x18,
        bit=0x80,
    ),
    "Goron Mines Gor Amato Chest": TPLocationData(
        code=80,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x1,
        bit=0x2,
    ),
    "Goron Mines Gor Amato Key Shard": TPLocationData(
        code=81,
        flags=TPFlag.Npc | TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Flag,
        region=None,
        offset=0x820,
        bit=0x8,
    ),
    "Goron Mines Gor Amato Small Chest": TPLocationData(
        code=82,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x0,
        bit=0x1,
    ),
    "Goron Mines Gor Ebizo Chest": TPLocationData(
        code=83,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x0,
        bit=0x2,
    ),
    "Goron Mines Gor Ebizo Key Shard": TPLocationData(
        code=84,
        flags=TPFlag.Npc | TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Flag,
        region=None,
        offset=0x827,
        bit=0x2,
    ),
    "Goron Mines Gor Liggs Chest": TPLocationData(
        code=85,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x0,
        bit=0x4,
    ),
    "Goron Mines Gor Liggs Key Shard": TPLocationData(
        code=86,
        flags=TPFlag.Npc | TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Flag,
        region=None,
        offset=0x827,
        bit=0x1,
    ),
    "Goron Mines Magnet Maze Chest": TPLocationData(
        code=87,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x1,
        bit=0x10,
    ),
    "Goron Mines Main Magnet Room Bottom Chest": TPLocationData(
        code=88,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x2,
        bit=0x8,
    ),
    "Goron Mines Main Magnet Room Top Chest": TPLocationData(
        code=89,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x0,
        bit=0x40,
    ),
    "Goron Mines Outside Beamos Chest": TPLocationData(
        code=90,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x2,
        bit=0x80,
    ),
    "Goron Mines Outside Clawshot Chest": TPLocationData(
        code=91,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x2,
        bit=0x40,
    ),
    "Goron Mines Outside Underwater Chest": TPLocationData(
        code=92,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Goron_Mines,
        type=TPLocationType.Region,
        region=NodeID.Goron_Mines,
        offset=0x1,
        bit=0x20,
    ),
    "Hyrule Castle Big Key Chest": TPLocationData(
        code=93,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x3,
        bit=0x1,
    ),
    "Hyrule Castle East Wing Balcony Chest": TPLocationData(
        code=94,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x2,
        bit=0x8,
    ),
    "Hyrule Castle East Wing Boomerang Puzzle Chest": TPLocationData(
        code=95,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x3,
        bit=0x10,
    ),
    "Hyrule Castle Graveyard Grave Switch Room Back Left Chest": TPLocationData(
        code=96,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x7,
        bit=0x4,
    ),
    "Hyrule Castle Graveyard Grave Switch Room Front Left Chest": TPLocationData(
        code=97,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x7,
        bit=0x2,
    ),
    "Hyrule Castle Graveyard Grave Switch Room Right Chest": TPLocationData(
        code=98,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x0,
        bit=0x40,
    ),
    "Hyrule Castle Graveyard Owl Statue Chest": TPLocationData(
        code=99,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x3,
        bit=0x80,
    ),
    "Hyrule Castle King Bulblin Key": TPLocationData(
        code=100,
        flags=TPFlag.Npc | TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x3,
        bit=0x8,
    ),
    "Hyrule Castle Lantern Staircase Chest": TPLocationData(
        code=101,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x0,
        bit=0x2,
    ),
    "Hyrule Castle Main Hall Northeast Chest": TPLocationData(
        code=102,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x2,
        bit=0x1,
    ),
    "Hyrule Castle Main Hall Northwest Chest": TPLocationData(
        code=103,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x2,
        bit=0x20,
    ),
    "Hyrule Castle Main Hall Southwest Chest": TPLocationData(
        code=104,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x3,
        bit=0x4,
    ),
    "Hyrule Castle Southeast Balcony Tower Chest": TPLocationData(
        code=105,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x3,
        bit=0x2,
    ),
    "Hyrule Castle Treasure Room Eighth Small Chest": TPLocationData(
        code=106,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x0,
        bit=0x10,
    ),
    "Hyrule Castle Treasure Room Fifth Chest": TPLocationData(
        code=107,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x1,
        bit=0x8,
    ),
    "Hyrule Castle Treasure Room Fifth Small Chest": TPLocationData(
        code=108,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x1,
        bit=0x40,
    ),
    "Hyrule Castle Treasure Room First Chest": TPLocationData(
        code=109,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x2,
        bit=0x80,
    ),
    "Hyrule Castle Treasure Room First Small Chest": TPLocationData(
        code=110,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x7,
        bit=0x8,
    ),
    "Hyrule Castle Treasure Room Fourth Chest": TPLocationData(
        code=111,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x1,
        bit=0x4,
    ),
    "Hyrule Castle Treasure Room Fourth Small Chest": TPLocationData(
        code=112,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x1,
        bit=0x80,
    ),
    "Hyrule Castle Treasure Room Second Chest": TPLocationData(
        code=113,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x1,
        bit=0x1,
    ),
    "Hyrule Castle Treasure Room Second Small Chest": TPLocationData(
        code=114,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x0,
        bit=0x20,
    ),
    "Hyrule Castle Treasure Room Seventh Small Chest": TPLocationData(
        code=115,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x0,
        bit=0x8,
    ),
    "Hyrule Castle Treasure Room Sixth Small Chest": TPLocationData(
        code=116,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x0,
        bit=0x4,
    ),
    "Hyrule Castle Treasure Room Third Chest": TPLocationData(
        code=117,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x1,
        bit=0x2,
    ),
    "Hyrule Castle Treasure Room Third Small Chest": TPLocationData(
        code=118,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x1,
        bit=0x20,
    ),
    "Hyrule Castle West Courtyard Central Small Chest": TPLocationData(
        code=119,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x3,
        bit=0x20,
    ),
    "Hyrule Castle West Courtyard North Small Chest": TPLocationData(
        code=120,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Castle,
        offset=0x2,
        bit=0x2,
    ),
    "Lakebed Temple Before Deku Toad Alcove Chest": TPLocationData(
        code=121,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x3,
        bit=0x4,
    ),
    "Lakebed Temple Before Deku Toad Underwater Left Chest": TPLocationData(
        code=122,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x2,
        bit=0x80,
    ),
    "Lakebed Temple Before Deku Toad Underwater Right Chest": TPLocationData(
        code=123,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x2,
        bit=0x40,
    ),
    "Lakebed Temple Big Key Chest": TPLocationData(
        code=124,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x2,
        bit=0x10,
    ),
    "Lakebed Temple Central Room Chest": TPLocationData(
        code=125,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x1,
        bit=0x2,
    ),
    "Lakebed Temple Central Room Small Chest": TPLocationData(
        code=126,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x3,
        bit=0x2,
    ),
    "Lakebed Temple Central Room Spire Chest": TPLocationData(
        code=127,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x1,
        bit=0x1,
    ),
    "Lakebed Temple Chandelier Chest": TPLocationData(
        code=128,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x3,
        bit=0x20,
    ),
    "Lakebed Temple Deku Toad Chest": TPLocationData(
        code=129,
        flags=TPFlag.Dungeon | TPFlag.MiniBoss,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x3,
        bit=0x1,
    ),
    "Lakebed Temple Dungeon Reward": TPLocationData(
        code=130,
        flags=TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x1D,
        bit=0x8,
    ),
    "Lakebed Temple East Lower Waterwheel Bridge Chest": TPLocationData(
        code=131,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x2,
        bit=0x1,
    ),
    "Lakebed Temple East Lower Waterwheel Stalactite Chest": TPLocationData(
        code=132,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x3,
        bit=0x40,
    ),
    "Lakebed Temple East Second Floor Southeast Chest": TPLocationData(
        code=133,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x2,
        bit=0x4,
    ),
    "Lakebed Temple East Second Floor Southwest Chest": TPLocationData(
        code=134,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x0,
        bit=0x1,
    ),
    "Lakebed Temple East Water Supply Clawshot Chest": TPLocationData(
        code=135,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x2,
        bit=0x8,
    ),
    "Lakebed Temple East Water Supply Small Chest": TPLocationData(
        code=136,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x0,
        bit=0x8,
    ),
    "Lakebed Temple Lobby Left Chest": TPLocationData(
        code=137,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x0,
        bit=0x10,
    ),
    "Lakebed Temple Lobby Rear Chest": TPLocationData(
        code=138,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x0,
        bit=0x20,
    ),
    "Lakebed Temple Morpheel Heart Container": TPLocationData(
        code=139,
        flags=TPFlag.Heart | TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x18,
        bit=0x80,
    ),
    "Lakebed Temple Stalactite Room Chest": TPLocationData(
        code=140,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x3,
        bit=0x8,
    ),
    "Lakebed Temple Underwater Maze Small Chest": TPLocationData(
        code=141,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x1,
        bit=0x4,
    ),
    "Lakebed Temple West Lower Small Chest": TPLocationData(
        code=142,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x0,
        bit=0x40,
    ),
    "Lakebed Temple West Second Floor Central Small Chest": TPLocationData(
        code=143,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x1,
        bit=0x8,
    ),
    "Lakebed Temple West Second Floor Northeast Chest": TPLocationData(
        code=144,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x2,
        bit=0x20,
    ),
    "Lakebed Temple West Second Floor Southeast Chest": TPLocationData(
        code=145,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x3,
        bit=0x80,
    ),
    "Lakebed Temple West Second Floor Southwest Underwater Chest": TPLocationData(
        code=146,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x0,
        bit=0x2,
    ),
    "Lakebed Temple West Water Supply Chest": TPLocationData(
        code=147,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x1,
        bit=0x10,
    ),
    "Lakebed Temple West Water Supply Small Chest": TPLocationData(
        code=148,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Lakebed_Temple,
        type=TPLocationType.Region,
        region=NodeID.Lakebed_Temple,
        offset=0x1,
        bit=0x20,
    ),
    "Palace of Twilight Big Key Chest": TPLocationData(
        code=149,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x1,
        bit=0x80,
    ),
    "Palace of Twilight Central First Room Chest": TPLocationData(
        code=150,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x1,
        bit=0x40,
    ),
    "Palace of Twilight Central Outdoor Chest": TPLocationData(
        code=151,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x0,
        bit=0x1,
    ),
    "Palace of Twilight Central Tower Chest": TPLocationData(
        code=152,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x0,
        bit=0x4,
    ),
    "Palace of Twilight Collect Both Sols": TPLocationData(
        code=153,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0xC,
        bit=0x80,
    ),
    "Palace of Twilight East Wing First Room East Alcove Chest": TPLocationData(
        code=154,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x3,
        bit=0x1,
    ),
    "Palace of Twilight East Wing First Room North Small Chest": TPLocationData(
        code=155,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x7,
        bit=0x10,
    ),
    "Palace of Twilight East Wing First Room West Alcove Chest": TPLocationData(
        code=156,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x0,
        bit=0x8,
    ),
    "Palace of Twilight East Wing First Room Zant Head Chest": TPLocationData(
        code=157,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x3,
        bit=0x40,
    ),
    "Palace of Twilight East Wing Second Room Northeast Chest": TPLocationData(
        code=158,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x0,
        bit=0x10,
    ),
    "Palace of Twilight East Wing Second Room Northwest Chest": TPLocationData(
        code=159,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x0,
        bit=0x20,
    ),
    "Palace of Twilight East Wing Second Room Southeast Chest": TPLocationData(
        code=160,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x3,
        bit=0x80,
    ),
    "Palace of Twilight East Wing Second Room Southwest Chest": TPLocationData(
        code=161,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x7,
        bit=0x2,
    ),
    "Palace of Twilight West Wing Chest Behind Wall of Darkness": TPLocationData(
        code=162,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x0,
        bit=0x40,
    ),
    "Palace of Twilight West Wing First Room Central Chest": TPLocationData(
        code=163,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x3,
        bit=0x10,
    ),
    "Palace of Twilight West Wing Second Room Central Chest": TPLocationData(
        code=164,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x3,
        bit=0x20,
    ),
    "Palace of Twilight West Wing Second Room Lower South Chest": TPLocationData(
        code=165,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x3,
        bit=0x8,
    ),
    "Palace of Twilight West Wing Second Room Southeast Chest": TPLocationData(
        code=166,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x0,
        bit=0x2,
    ),
    "Palace of Twilight Zant Heart Container": TPLocationData(
        code=167,
        flags=TPFlag.Dungeon | TPFlag.Heart | TPFlag.Dungeon,
        stage_id=TPStages.Palace_of_Twilight,
        type=TPLocationType.Region,
        region=NodeID.Palace_of_Twilight,
        offset=0x1D,
        bit=0x10,
    ),
    "Snowpeak Ruins Ball and Chain": TPLocationData(
        code=168,
        flags=TPFlag.Dungeon | TPFlag.MiniBoss,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x10,
        bit=0x80,
    ),
    "Snowpeak Ruins Blizzeta Heart Container": TPLocationData(
        code=169,
        flags=TPFlag.Heart | TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x18,
        bit=0x80,
    ),
    "Snowpeak Ruins Broken Floor Chest": TPLocationData(
        code=170,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x0,
        bit=0x2,
    ),
    "Snowpeak Ruins Chapel Chest": TPLocationData(
        code=171,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x2,
        bit=0x8,
    ),
    "Snowpeak Ruins Chest After Darkhammer": TPLocationData(
        code=172,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x3,
        bit=0x40,
    ),
    "Snowpeak Ruins Courtyard Central Chest": TPLocationData(
        code=173,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x3,
        bit=0x8,
    ),
    "Snowpeak Ruins Dungeon Reward": TPLocationData(
        code=174,
        flags=TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x1D,
        bit=0x8,
    ),
    "Snowpeak Ruins East Courtyard Buried Chest": TPLocationData(
        code=175,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x2,
        bit=0x40,
    ),
    "Snowpeak Ruins East Courtyard Chest": TPLocationData(
        code=176,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x2,
        bit=0x80,
    ),
    "Snowpeak Ruins Ice Room Poe": TPLocationData(
        code=177,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x14,
        bit=0x80,
    ),
    "Snowpeak Ruins Lobby Armor Poe": TPLocationData(
        code=178,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x9,
        bit=0x20,
    ),
    "Snowpeak Ruins Lobby Chandelier Chest": TPLocationData(
        code=179,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x1,
        bit=0x20,
    ),
    "Snowpeak Ruins Lobby East Armor Chest": TPLocationData(
        code=180,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x1,
        bit=0x40,
    ),
    "Snowpeak Ruins Lobby Poe": TPLocationData(
        code=181,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x15,
        bit=0x4,
    ),
    "Snowpeak Ruins Lobby West Armor Chest": TPLocationData(
        code=182,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x1,
        bit=0x80,
    ),
    "Snowpeak Ruins Mansion Map": TPLocationData(
        code=183,
        flags=TPFlag.Npc | TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0xA,
        bit=0x10,
    ),
    "Snowpeak Ruins Northeast Chandelier Chest": TPLocationData(
        code=184,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x1,
        bit=0x4,
    ),
    "Snowpeak Ruins Ordon Pumpkin Chest": TPLocationData(
        code=185,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x2,
        bit=0x4,
    ),
    "Snowpeak Ruins West Cannon Room Central Chest": TPLocationData(
        code=186,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x1,
        bit=0x10,
    ),
    "Snowpeak Ruins West Cannon Room Corner Chest": TPLocationData(
        code=187,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x1,
        bit=0x8,
    ),
    "Snowpeak Ruins West Courtyard Buried Chest": TPLocationData(
        code=188,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x2,
        bit=0x20,
    ),
    "Snowpeak Ruins Wooden Beam Central Chest": TPLocationData(
        code=189,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x3,
        bit=0x2,
    ),
    "Snowpeak Ruins Wooden Beam Chandelier Chest": TPLocationData(
        code=190,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x3,
        bit=0x80,
    ),
    "Snowpeak Ruins Wooden Beam Northwest Chest": TPLocationData(
        code=191,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Snowpeak_Ruins,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak_Ruins,
        offset=0x3,
        bit=0x4,
    ),
    "Temple of Time Armogohma Heart Container": TPLocationData(
        code=192,
        flags=TPFlag.Heart | TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x18,
        bit=0x80,
    ),
    "Temple of Time Armos Antechamber East Chest": TPLocationData(
        code=193,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x3,
        bit=0x10,
    ),
    "Temple of Time Armos Antechamber North Chest": TPLocationData(
        code=194,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x6,
        bit=0x40,
    ),
    "Temple of Time Armos Antechamber Statue Chest": TPLocationData(
        code=195,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x3,
        bit=0x20,
    ),
    "Temple of Time Big Key Chest": TPLocationData(
        code=196,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x2,
        bit=0x1,
    ),
    "Temple of Time Chest Before Darknut": TPLocationData(
        code=197,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x6,
        bit=0x8,
    ),
    "Temple of Time Darknut Chest": TPLocationData(
        code=198,
        flags=TPFlag.Dungeon | TPFlag.MiniBoss,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x3,
        bit=0x1,
    ),
    "Temple of Time Dungeon Reward": TPLocationData(
        code=199,
        flags=TPFlag.Dungeon | TPFlag.Boss,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x1D,
        bit=0x8,
    ),
    "Temple of Time First Staircase Armos Chest": TPLocationData(
        code=200,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x3,
        bit=0x2,
    ),
    "Temple of Time First Staircase Gohma Gate Chest": TPLocationData(
        code=201,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x3,
        bit=0x4,
    ),
    "Temple of Time First Staircase Window Chest": TPLocationData(
        code=202,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x6,
        bit=0x20,
    ),
    "Temple of Time Floor Switch Puzzle Room Upper Chest": TPLocationData(
        code=203,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x5,
        bit=0x1,
    ),
    "Temple of Time Gilloutine Chest": TPLocationData(
        code=204,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x2,
        bit=0x2,
    ),
    "Temple of Time Lobby Lantern Chest": TPLocationData(
        code=205,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x6,
        bit=0x2,
    ),
    "Temple of Time Moving Wall Beamos Room Chest": TPLocationData(
        code=206,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x3,
        bit=0x40,
    ),
    "Temple of Time Moving Wall Dinalfos Room Chest": TPLocationData(
        code=207,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x2,
        bit=0x10,
    ),
    "Temple of Time Poe Above Scales": TPLocationData(
        code=208,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x8,
        bit=0x1,
    ),
    "Temple of Time Poe Behind Gate": TPLocationData(
        code=209,
        flags=TPFlag.Dungeon | TPFlag.Poe,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x8,
        bit=0x2,
    ),
    "Temple of Time Scales Gohma Chest": TPLocationData(
        code=210,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x6,
        bit=0x10,
    ),
    "Temple of Time Scales Upper Chest": TPLocationData(
        code=211,
        flags=TPFlag.Dungeon,
        stage_id=TPStages.Temple_of_Time,
        type=TPLocationType.Region,
        region=NodeID.Temple_of_Time,
        offset=0x6,
        bit=0x80,
    ),
    "Barnes Bomb Bag": TPLocationData(
        code=212,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x7F9,
        bit=0x8,
    ),
    "Bridge of Eldin Female Phasmid": TPLocationData(
        code=213,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x19,
        bit=0x40,
    ),
    "Bridge of Eldin Male Phasmid": TPLocationData(
        code=214,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x19,
        bit=0x80,
    ),
    "Bridge of Eldin Owl Statue Chest": TPLocationData(
        code=215,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x3,
        bit=0x8,
    ),
    "Bridge of Eldin Owl Statue Sky Character": TPLocationData(
        code=216,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x11,
        bit=0x8,
    ),
    "Cats Hide and Seek Minigame": TPLocationData(
        code=217,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Hidden_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x1A,
        bit=0x8,
    ),
    "Death Mountain Alcove Chest": TPLocationData(
        code=218,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Death_Mountain,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x1,
        bit=0x40,
    ),
    "Death Mountain Trail Poe": TPLocationData(
        code=219,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Death_Mountain,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x10,
        bit=0x2,
    ),
    "Eldin Field Bomb Rock Chest": TPLocationData(
        code=220,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x3,
        bit=0x4,
    ),
    "Eldin Field Bomskit Grotto Lantern Chest": TPLocationData(
        code=221,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x3,
        bit=0x40,
    ),
    "Eldin Field Bomskit Grotto Left Chest": TPLocationData(
        code=222,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x2,
        bit=0x4,
    ),
    "Eldin Field Female Grasshopper": TPLocationData(
        code=223,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x18,
        bit=0x1,
    ),
    "Eldin Field Male Grasshopper": TPLocationData(
        code=224,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x18,
        bit=0x2,
    ),
    "Eldin Field Stalfos Grotto Left Small Chest": TPLocationData(
        code=225,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x1,
        bit=0x4,
    ),
    "Eldin Field Stalfos Grotto Right Small Chest": TPLocationData(
        code=226,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x1,
        bit=0x2,
    ),
    "Eldin Field Stalfos Grotto Stalfos Chest": TPLocationData(
        code=227,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x3,
        bit=0x4,
    ),
    "Eldin Field Water Bomb Fish Grotto Chest": TPLocationData(
        code=228,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x1,
        bit=0x1,
    ),
    "Eldin Lantern Cave First Chest": TPLocationData(
        code=229,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Cave_of_Ordeals,
        offset=0x4,
        bit=0x20,
    ),
    "Eldin Lantern Cave Lantern Chest": TPLocationData(
        code=230,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Cave_of_Ordeals,
        offset=0x4,
        bit=0x40,
    ),
    "Eldin Lantern Cave Poe": TPLocationData(
        code=231,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Eldin_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Cave_of_Ordeals,
        offset=0x17,
        bit=0x1,
    ),
    "Eldin Lantern Cave Second Chest": TPLocationData(
        code=232,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Cave_of_Ordeals,
        offset=0x4,
        bit=0x80,
    ),
    "Eldin Spring Underwater Chest": TPLocationData(
        code=233,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x1,
        bit=0x20,
    ),
    "Eldin Stockcave Lantern Chest": TPLocationData(
        code=234,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Goron_Stockcave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x4,
        bit=0x20,
    ),
    "Eldin Stockcave Lowest Chest": TPLocationData(
        code=235,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Goron_Stockcave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x4,
        bit=0x40,
    ),
    "Eldin Stockcave Upper Chest": TPLocationData(
        code=236,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Goron_Stockcave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x4,
        bit=0x80,
    ),
    "Gift From Ralis": TPLocationData(
        code=237,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Kakariko_Graveyard,
        type=TPLocationType.Flag,
        region=None,
        offset=0x82B,
        bit=0x80,
    ),
    "Goron Springwater Rush": TPLocationData(
        code=238,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x1B,
        bit=0x1,
    ),
    "Hidden Village Poe": TPLocationData(
        code=239,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Hidden_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x13,
        bit=0x1,
    ),
    "Kakariko Gorge Double Clawshot Chest": TPLocationData(
        code=240,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x3,
        bit=0x20,
    ),
    "Kakariko Gorge Female Pill Bug": TPLocationData(
        code=241,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x19,
        bit=0x10,
    ),
    "Kakariko Gorge Male Pill Bug": TPLocationData(
        code=242,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x19,
        bit=0x20,
    ),
    "Kakariko Gorge Owl Statue Chest": TPLocationData(
        code=243,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x3,
        bit=0x10,
    ),
    "Kakariko Gorge Owl Statue Sky Character": TPLocationData(
        code=244,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x11,
        bit=0x2,
    ),
    "Kakariko Gorge Poe": TPLocationData(
        code=245,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0xC,
        bit=0x4,
    ),
    "Kakariko Gorge Spire Heart Piece": TPLocationData(
        code=246,
        flags=TPFlag.Overworld | TPFlag.Heart,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x1B,
        bit=0x4,
    ),
    "Kakariko Graveyard Golden Wolf": TPLocationData(
        code=247,
        flags=TPFlag.Overworld | TPFlag.Skill,
        stage_id=TPStages.Kakariko_Graveyard,
        type=TPLocationType.Flag,
        region=None,
        offset=0x82D,
        bit=0x80,
    ),
    "Kakariko Graveyard Grave Poe": TPLocationData(
        code=248,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Kakariko_Graveyard,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x11,
        bit=0x80,
    ),
    "Kakariko Graveyard Lantern Chest": TPLocationData(
        code=249,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Kakariko_Graveyard,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x0,
        bit=0x1,
    ),
    "Kakariko Graveyard Male Ant": TPLocationData(
        code=250,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Kakariko_Graveyard,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x19,
        bit=0x2,
    ),
    "Kakariko Graveyard Open Poe": TPLocationData(
        code=251,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Kakariko_Graveyard,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x10,
        bit=0x1,
    ),
    "Kakariko Inn Chest": TPLocationData(
        code=252,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x1,
        bit=0x80,
    ),
    "Kakariko Village Bomb Rock Spire Heart Piece": TPLocationData(
        code=253,
        flags=TPFlag.Overworld | TPFlag.Heart,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x1A,
        bit=0x10,
    ),
    "Kakariko Village Bomb Shop Poe": TPLocationData(
        code=254,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x10,
        bit=0x40,
    ),
    "Kakariko Village Female Ant": TPLocationData(
        code=255,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x19,
        bit=0x1,
    ),
    "Kakariko Village Malo Mart Hawkeye": TPLocationData(
        code=256,
        flags=TPFlag.Overworld | TPFlag.Shop,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0xC,
        bit=0x20,
    ),
    "Kakariko Village Malo Mart Hylian Shield": TPLocationData(
        code=257,
        flags=TPFlag.Overworld | TPFlag.Shop,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0xC,
        bit=0x2,
    ),
    "Kakariko Village Malo Mart Red Potion": TPLocationData(
        code=258,
        flags=TPFlag.Overworld | TPFlag.Shop,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0xB,
        bit=0x10,
    ),
    "Kakariko Village Malo Mart Wooden Shield": TPLocationData(
        code=259,
        flags=TPFlag.Overworld | TPFlag.Shop,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0xB,
        bit=0x20,
    ),
    "Kakariko Village Watchtower Poe": TPLocationData(
        code=260,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x10,
        bit=0x80,
    ),
    "Kakariko Watchtower Alcove Chest": TPLocationData(
        code=261,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x1,
        bit=0x10,
    ),
    "Kakariko Watchtower Chest": TPLocationData(
        code=262,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Region,
        region=NodeID.Eldin,
        offset=0x1,
        bit=0x2,
    ),
    "Rutelas Blessing": TPLocationData(
        code=263,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Kakariko_Graveyard,
        type=TPLocationType.Flag,
        region=None,
        offset=0x7F8,
        bit=0x4,
    ),
    "Skybook From Impaz": TPLocationData(
        code=264,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Hidden_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x84F,
        bit=0x80,
    ),
    "Talo Sharpshooting": TPLocationData(
        code=265,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x7F9,
        bit=0x20,
    ),
    "Coro Bottle": TPLocationData(
        code=266,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Flag,
        region=None,
        offset=0x80A,
        bit=0x8,
    ),
    "Faron Field Bridge Chest": TPLocationData(
        code=267,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x3,
        bit=0x40,
    ),
    "Faron Field Corner Grotto Left Chest": TPLocationData(
        code=268,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x2,
        bit=0x8,
    ),
    "Faron Field Corner Grotto Rear Chest": TPLocationData(
        code=269,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x2,
        bit=0x20,
    ),
    "Faron Field Corner Grotto Right Chest": TPLocationData(
        code=270,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x2,
        bit=0x10,
    ),
    "Faron Field Female Beetle": TPLocationData(
        code=271,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Faron_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x18,
        bit=0x40,
    ),
    "Faron Field Male Beetle": TPLocationData(
        code=272,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Faron_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x18,
        bit=0x80,
    ),
    "Faron Field Poe": TPLocationData(
        code=273,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Faron_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0xC,
        bit=0x2,
    ),
    "Faron Field Tree Heart Piece": TPLocationData(
        code=274,
        flags=TPFlag.Overworld | TPFlag.Heart,
        stage_id=TPStages.Faron_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x1B,
        bit=0x2,
    ),
    "Faron Mist Cave Lantern Chest": TPLocationData(
        code=275,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x0,
        bit=0x4,
    ),
    "Faron Mist Cave Open Chest": TPLocationData(
        code=276,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x0,
        bit=0x1,
    ),
    "Faron Mist North Chest": TPLocationData(
        code=277,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x0,
        bit=0x8,
    ),
    "Faron Mist Poe": TPLocationData(
        code=278,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x10,
        bit=0x20,
    ),
    "Faron Mist South Chest": TPLocationData(
        code=279,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x0,
        bit=0x20,
    ),
    "Faron Mist Stump Chest": TPLocationData(
        code=280,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x0,
        bit=0x10,
    ),
    "Faron Woods Golden Wolf": TPLocationData(
        code=281,
        flags=TPFlag.Overworld | TPFlag.Skill,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Flag,
        region=None,
        offset=0x82C,
        bit=0x10,
    ),
    "Faron Woods Owl Statue Chest": TPLocationData(
        code=282,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x0,
        bit=0x40,
    ),
    "Faron Woods Owl Statue Sky Character": TPLocationData(
        code=283,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x8,
        bit=0x4,
    ),
    "Lost Woods Boulder Poe": TPLocationData(
        code=284,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Sacred_Grove,
        offset=0x9,
        bit=0x1,
    ),
    "Lost Woods Lantern Chest": TPLocationData(
        code=285,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Sacred_Grove,
        offset=0x3,
        bit=0x8,
    ),
    "Lost Woods Waterfall Poe": TPLocationData(
        code=286,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Sacred_Grove,
        offset=0x9,
        bit=0x2,
    ),
    "North Faron Woods Deku Baba Chest": TPLocationData(
        code=287,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x4,
        bit=0x80,
    ),
    "Sacred Grove Baba Serpent Grotto Chest": TPLocationData(
        code=288,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x3,
        bit=0x8,
    ),
    "Sacred Grove Female Snail": TPLocationData(
        code=289,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Sacred_Grove,
        offset=0x18,
        bit=0x1,
    ),
    "Sacred Grove Male Snail": TPLocationData(
        code=290,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Sacred_Grove,
        offset=0x18,
        bit=0x2,
    ),
    "Sacred Grove Master Sword Poe": TPLocationData(
        code=291,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Sacred_Grove,
        offset=0xA,
        bit=0x80,
    ),
    "Sacred Grove Past Owl Statue Chest": TPLocationData(
        code=292,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Sacred_Grove,
        offset=0x3,
        bit=0x2,
    ),
    "Sacred Grove Pedestal Master Sword": TPLocationData(
        code=293,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Flag,
        region=None,
        offset=0x811,
        bit=0x20,
    ),
    "Sacred Grove Pedestal Shadow Crystal": TPLocationData(
        code=294,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Flag,
        region=None,
        offset=0x811,
        bit=0x20,
    ),
    "Sacred Grove Spinner Chest": TPLocationData(
        code=295,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Sacred_Grove,
        offset=0x3,
        bit=0x4,
    ),
    "Sacred Grove Temple of Time Owl Statue Poe": TPLocationData(
        code=296,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Sacred_Grove,
        type=TPLocationType.Region,
        region=NodeID.Sacred_Grove,
        offset=0x8,
        bit=0x40,
    ),
    "South Faron Cave Chest": TPLocationData(
        code=297,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Faron_Woods,
        type=TPLocationType.Region,
        region=NodeID.Faron,
        offset=0x0,
        bit=0x80,
    ),
    "Bulblin Camp First Chest Under Tower At Entrance": TPLocationData(
        code=298,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Bublin_Camp,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x0,
        bit=0x80,
    ),
    "Bulblin Camp Poe": TPLocationData(
        code=299,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Bublin_Camp,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x14,
        bit=0x1,
    ),
    "Bulblin Camp Roasted Boar": TPLocationData(
        code=300,
        flags=TPFlag.Overworld | TPFlag.Heart,
        stage_id=TPStages.Bublin_Camp,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x18,
        bit=0x80,
    ),
    "Bulblin Camp Small Chest in Back of Camp": TPLocationData(
        code=301,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Bublin_Camp,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x0,
        bit=0x40,
    ),
    "Bulblin Guard Key": TPLocationData(
        code=302,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Bublin_Camp,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x18,
        bit=0x4,
    ),
    "Cave of Ordeals Floor 17 Poe": TPLocationData(
        code=303,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Cave_of_Ordeals,
        type=TPLocationType.Region,
        region=NodeID.Cave_of_Ordeals,
        offset=0x13,
        bit=0x20,
    ),
    "Cave of Ordeals Floor 33 Poe": TPLocationData(
        code=304,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Cave_of_Ordeals,
        type=TPLocationType.Region,
        region=NodeID.Cave_of_Ordeals,
        offset=0x13,
        bit=0x40,
    ),
    "Cave of Ordeals Floor 44 Poe": TPLocationData(
        code=305,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Cave_of_Ordeals,
        type=TPLocationType.Region,
        region=NodeID.Cave_of_Ordeals,
        offset=0x13,
        bit=0x80,
    ),
    "Cave of Ordeals Great Fairy Reward": TPLocationData(
        code=306,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Cave_of_Ordeals,
        type=TPLocationType.Region,
        region=NodeID.Cave_of_Ordeals,
        offset=0x13,
        bit=0x4,
    ),
    "Gerudo Desert Campfire East Chest": TPLocationData(
        code=307,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x2,
        bit=0x2,
    ),
    "Gerudo Desert Campfire North Chest": TPLocationData(
        code=308,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x2,
        bit=0x1,
    ),
    "Gerudo Desert Campfire West Chest": TPLocationData(
        code=309,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x2,
        bit=0x4,
    ),
    "Gerudo Desert East Canyon Chest": TPLocationData(
        code=310,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x3,
        bit=0x40,
    ),
    "Gerudo Desert East Poe": TPLocationData(
        code=311,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x10,
        bit=0x10,
    ),
    "Gerudo Desert Female Dayfly": TPLocationData(
        code=312,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x18,
        bit=0x1,
    ),
    "Gerudo Desert Golden Wolf": TPLocationData(
        code=313,
        flags=TPFlag.Overworld | TPFlag.Skill,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Flag,
        region=None,
        offset=0x82C,
        bit=0x1,
    ),
    "Gerudo Desert Lone Small Chest": TPLocationData(
        code=314,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x3,
        bit=0x20,
    ),
    "Gerudo Desert Male Dayfly": TPLocationData(
        code=315,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x18,
        bit=0x2,
    ),
    "Gerudo Desert North Peahat Poe": TPLocationData(
        code=316,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x10,
        bit=0x8,
    ),
    "Gerudo Desert North Small Chest Before Bulblin Camp": TPLocationData(
        code=317,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x2,
        bit=0x20,
    ),
    "Gerudo Desert Northeast Chest Behind Gates": TPLocationData(
        code=318,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x3,
        bit=0x4,
    ),
    "Gerudo Desert Northwest Chest Behind Gates": TPLocationData(
        code=319,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x3,
        bit=0x8,
    ),
    "Gerudo Desert Owl Statue Chest": TPLocationData(
        code=320,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x3,
        bit=0x2,
    ),
    "Gerudo Desert Owl Statue Sky Character": TPLocationData(
        code=321,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0xF,
        bit=0x4,
    ),
    "Gerudo Desert Peahat Ledge Chest": TPLocationData(
        code=322,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x2,
        bit=0x8,
    ),
    "Gerudo Desert Poe Above Cave of Ordeals": TPLocationData(
        code=323,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x10,
        bit=0x20,
    ),
    "Gerudo Desert Rock Grotto First Poe": TPLocationData(
        code=324,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x9,
        bit=0x1,
    ),
    "Gerudo Desert Rock Grotto Lantern Chest": TPLocationData(
        code=325,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x2,
        bit=0x40,
    ),
    "Gerudo Desert Rock Grotto Second Poe": TPLocationData(
        code=326,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0xA,
        bit=0x80,
    ),
    "Gerudo Desert Skulltula Grotto Chest": TPLocationData(
        code=327,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x2,
        bit=0x1,
    ),
    "Gerudo Desert South Chest Behind Wooden Gates": TPLocationData(
        code=328,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x3,
        bit=0x1,
    ),
    "Gerudo Desert West Canyon Chest": TPLocationData(
        code=329,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x3,
        bit=0x80,
    ),
    "Outside Arbiters Grounds Lantern Chest": TPLocationData(
        code=330,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Bublin_Camp,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x2,
        bit=0x80,
    ),
    "Outside Arbiters Grounds Poe": TPLocationData(
        code=331,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Bublin_Camp,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0x10,
        bit=0x4,
    ),
    "Outside Bulblin Camp Poe": TPLocationData(
        code=332,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Gerudo_Desert,
        type=TPLocationType.Region,
        region=NodeID.Gerudo_Desert,
        offset=0xD,
        bit=0x8,
    ),
    "Agitha Female Ant Reward": TPLocationData(
        code=333,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x824,
        bit=0x80,
    ),
    "Agitha Female Beetle Reward": TPLocationData(
        code=334,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x821,
        bit=0x8,
    ),
    "Agitha Female Butterfly Reward": TPLocationData(
        code=335,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x821,
        bit=0x2,
    ),
    "Agitha Female Dayfly Reward": TPLocationData(
        code=336,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x824,
        bit=0x20,
    ),
    "Agitha Female Dragonfly Reward": TPLocationData(
        code=337,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x823,
        bit=0x2,
    ),
    "Agitha Female Grasshopper Reward": TPLocationData(
        code=338,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x822,
        bit=0x20,
    ),
    "Agitha Female Ladybug Reward": TPLocationData(
        code=339,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x823,
        bit=0x20,
    ),
    "Agitha Female Mantis Reward": TPLocationData(
        code=340,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x823,
        bit=0x80,
    ),
    "Agitha Female Phasmid Reward": TPLocationData(
        code=341,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x822,
        bit=0x8,
    ),
    "Agitha Female Pill Bug Reward": TPLocationData(
        code=342,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x822,
        bit=0x2,
    ),
    "Agitha Female Snail Reward": TPLocationData(
        code=343,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x823,
        bit=0x8,
    ),
    "Agitha Female Stag Beetle Reward": TPLocationData(
        code=344,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x822,
        bit=0x80,
    ),
    "Agitha Male Ant Reward": TPLocationData(
        code=345,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x823,
        bit=0x1,
    ),
    "Agitha Male Beetle Reward": TPLocationData(
        code=346,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x821,
        bit=0x10,
    ),
    "Agitha Male Butterfly Reward": TPLocationData(
        code=347,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x821,
        bit=0x4,
    ),
    "Agitha Male Dayfly Reward": TPLocationData(
        code=348,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x824,
        bit=0x40,
    ),
    "Agitha Male Dragonfly Reward": TPLocationData(
        code=349,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x823,
        bit=0x4,
    ),
    "Agitha Male Grasshopper Reward": TPLocationData(
        code=350,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x822,
        bit=0x40,
    ),
    "Agitha Male Ladybug Reward": TPLocationData(
        code=351,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x823,
        bit=0x40,
    ),
    "Agitha Male Mantis Reward": TPLocationData(
        code=352,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x822,
        bit=0x1,
    ),
    "Agitha Male Phasmid Reward": TPLocationData(
        code=353,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x822,
        bit=0x10,
    ),
    "Agitha Male Pill Bug Reward": TPLocationData(
        code=354,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x822,
        bit=0x4,
    ),
    "Agitha Male Snail Reward": TPLocationData(
        code=355,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x823,
        bit=0x10,
    ),
    "Agitha Male Stag Beetle Reward": TPLocationData(
        code=356,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Bug,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x821,
        bit=0x1,
    ),
    "Auru Gift To Fyer": TPLocationData(
        code=357,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Flag,
        region=None,
        offset=0x815,
        bit=0x10,
    ),
    "Castle Town Malo Mart Magic Armor": TPLocationData(
        code=358,
        flags=TPFlag.Overworld | TPFlag.Shop,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Region,
        region=NodeID.Castle_Town,
        offset=0xE,
        bit=0x8,
    ),
    "Charlo Donation Blessing": TPLocationData(
        code=359,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x814,
        bit=0x80,
    ),
    "Doctors Office Balcony Chest": TPLocationData(
        code=360,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Region,
        region=NodeID.Castle_Town,
        offset=0x3,
        bit=0x2,
    ),
    "East Castle Town Bridge Poe": TPLocationData(
        code=361,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Eldin_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x13,
        bit=0x80,
    ),
    "Fishing Hole Bottle": TPLocationData(
        code=362,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Fishing_Pond,
        type=TPLocationType.Flag,
        region=None,
        offset=0x829,
        bit=0x8,
    ),
    "Fishing Hole Heart Piece": TPLocationData(
        code=363,
        flags=TPFlag.Overworld | TPFlag.Heart,
        stage_id=TPStages.Fishing_Pond,
        type=TPLocationType.Region,
        region=NodeID.Fishing_Pond,
        offset=0x1B,
        bit=0x1,
    ),
    "Flight By Fowl Fifth Platform Chest": TPLocationData(
        code=364,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x3,
        bit=0x80,
    ),
    "Flight By Fowl Fourth Platform Chest": TPLocationData(
        code=365,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x2,
        bit=0x1,
    ),
    "Flight By Fowl Ledge Poe": TPLocationData(
        code=366,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x12,
        bit=0x20,
    ),
    "Flight By Fowl Second Platform Chest": TPLocationData(
        code=367,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x3,
        bit=0x1,
    ),
    "Flight By Fowl Third Platform Chest": TPLocationData(
        code=368,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x3,
        bit=0x4,
    ),
    "Flight By Fowl Top Platform Reward": TPLocationData(
        code=369,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x0,
        bit=0x2,
    ),
    "Hyrule Field Amphitheater Owl Statue Chest": TPLocationData(
        code=370,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x2,
        bit=0x8,
    ),
    "Hyrule Field Amphitheater Owl Statue Sky Character": TPLocationData(
        code=371,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x11,
        bit=0x80,
    ),
    "Hyrule Field Amphitheater Poe": TPLocationData(
        code=372,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x12,
        bit=0x2,
    ),
    "Isle of Riches Poe": TPLocationData(
        code=373,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x13,
        bit=0x80,
    ),
    "Iza Helping Hand": TPLocationData(
        code=374,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Upper_Zoras_River,
        type=TPLocationType.Flag,
        region=None,
        offset=0x7FB,
        bit=0x1,
    ),
    "Iza Raging Rapids Minigame": TPLocationData(
        code=375,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Upper_Zoras_River,
        type=TPLocationType.Flag,
        region=None,
        offset=0x849,
        bit=0x8,
    ),
    "Jovani 20 Poe Soul Reward": TPLocationData(
        code=376,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Poe,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x83D,
        bit=0x80,
    ),
    "Jovani 60 Poe Soul Reward": TPLocationData(
        code=377,
        flags=TPFlag.Overworld | TPFlag.Npc | TPFlag.Poe,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x828,
        bit=0x20,
    ),
    "Jovani House Poe": TPLocationData(
        code=378,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Region,
        region=NodeID.Castle_Town,
        offset=0x8,
        bit=0x40,
    ),
    "Lake Hylia Alcove Poe": TPLocationData(
        code=379,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x13,
        bit=0x40,
    ),
    "Lake Hylia Bridge Bubble Grotto Chest": TPLocationData(
        code=380,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x3,
        bit=0x10,
    ),
    "Lake Hylia Bridge Cliff Chest": TPLocationData(
        code=381,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x2,
        bit=0x2,
    ),
    "Lake Hylia Bridge Cliff Poe": TPLocationData(
        code=382,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0xC,
        bit=0x8,
    ),
    "Lake Hylia Bridge Female Mantis": TPLocationData(
        code=383,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x19,
        bit=0x4,
    ),
    "Lake Hylia Bridge Male Mantis": TPLocationData(
        code=384,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x19,
        bit=0x8,
    ),
    "Lake Hylia Bridge Owl Statue Chest": TPLocationData(
        code=385,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x2,
        bit=0x80,
    ),
    "Lake Hylia Bridge Owl Statue Sky Character": TPLocationData(
        code=386,
        flags=TPFlag.Overworld | TPFlag.Sky_Book,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x11,
        bit=0x20,
    ),
    "Lake Hylia Bridge Vines Chest": TPLocationData(
        code=387,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x2,
        bit=0x4,
    ),
    "Lake Hylia Dock Poe": TPLocationData(
        code=388,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x12,
        bit=0x8,
    ),
    "Lake Hylia Shell Blade Grotto Chest": TPLocationData(
        code=389,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x1,
        bit=0x20,
    ),
    "Lake Hylia Tower Poe": TPLocationData(
        code=390,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x12,
        bit=0x10,
    ),
    "Lake Hylia Underwater Chest": TPLocationData(
        code=391,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x3,
        bit=0x20,
    ),
    "Lake Hylia Water Toadpoli Grotto Chest": TPLocationData(
        code=392,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x3,
        bit=0x20,
    ),
    "Lake Lantern Cave Eighth Chest": TPLocationData(
        code=393,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x2,
        bit=0x4,
    ),
    "Lake Lantern Cave Eleventh Chest": TPLocationData(
        code=394,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x3,
        bit=0x10,
    ),
    "Lake Lantern Cave End Lantern Chest": TPLocationData(
        code=395,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x3,
        bit=0x8,
    ),
    "Lake Lantern Cave Fifth Chest": TPLocationData(
        code=396,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x3,
        bit=0x80,
    ),
    "Lake Lantern Cave Final Poe": TPLocationData(
        code=397,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x10,
        bit=0x80,
    ),
    "Lake Lantern Cave First Chest": TPLocationData(
        code=398,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x3,
        bit=0x2,
    ),
    "Lake Lantern Cave First Poe": TPLocationData(
        code=399,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x10,
        bit=0x40,
    ),
    "Lake Lantern Cave Fourteenth Chest": TPLocationData(
        code=400,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x2,
        bit=0x20,
    ),
    "Lake Lantern Cave Fourth Chest": TPLocationData(
        code=401,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x3,
        bit=0x1,
    ),
    "Lake Lantern Cave Ninth Chest": TPLocationData(
        code=402,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x2,
        bit=0x2,
    ),
    "Lake Lantern Cave Second Chest": TPLocationData(
        code=403,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x3,
        bit=0x4,
    ),
    "Lake Lantern Cave Second Poe": TPLocationData(
        code=404,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x10,
        bit=0x20,
    ),
    "Lake Lantern Cave Seventh Chest": TPLocationData(
        code=405,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x2,
        bit=0x1,
    ),
    "Lake Lantern Cave Sixth Chest": TPLocationData(
        code=406,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x2,
        bit=0x40,
    ),
    "Lake Lantern Cave Tenth Chest": TPLocationData(
        code=407,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x3,
        bit=0x20,
    ),
    "Lake Lantern Cave Third Chest": TPLocationData(
        code=408,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x3,
        bit=0x40,
    ),
    "Lake Lantern Cave Thirteenth Chest": TPLocationData(
        code=409,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x2,
        bit=0x10,
    ),
    "Lake Lantern Cave Twelfth Chest": TPLocationData(
        code=410,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia_Long_Cave,
        type=TPLocationType.Region,
        region=NodeID.Lake_Hylia_Cave,
        offset=0x2,
        bit=0x8,
    ),
    "Lanayru Field Behind Gate Underwater Chest": TPLocationData(
        code=411,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x3,
        bit=0x80,
    ),
    "Lanayru Field Bridge Poe": TPLocationData(
        code=412,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0xD,
        bit=0x8,
    ),
    "Lanayru Field Female Stag Beetle": TPLocationData(
        code=413,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x18,
        bit=0x4,
    ),
    "Lanayru Field Male Stag Beetle": TPLocationData(
        code=414,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x18,
        bit=0x8,
    ),
    "Lanayru Field Poe Grotto Left Poe": TPLocationData(
        code=415,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0xA,
        bit=0x8,
    ),
    "Lanayru Field Poe Grotto Right Poe": TPLocationData(
        code=416,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0xA,
        bit=0x4,
    ),
    "Lanayru Field Skulltula Grotto Chest": TPLocationData(
        code=417,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x1,
        bit=0x8,
    ),
    "Lanayru Field Spinner Track Chest": TPLocationData(
        code=418,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x2,
        bit=0x1,
    ),
    "Lanayru Ice Block Puzzle Cave Chest": TPLocationData(
        code=419,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Cave_of_Ordeals,
        offset=0x3,
        bit=0x1,
    ),
    "Lanayru Spring Back Room Lantern Chest": TPLocationData(
        code=420,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x0,
        bit=0x20,
    ),
    "Lanayru Spring Back Room Left Chest": TPLocationData(
        code=421,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x0,
        bit=0x10,
    ),
    "Lanayru Spring Back Room Right Chest": TPLocationData(
        code=422,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x0,
        bit=0x8,
    ),
    "Lanayru Spring East Double Clawshot Chest": TPLocationData(
        code=423,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x3,
        bit=0x10,
    ),
    "Lanayru Spring Underwater Left Chest": TPLocationData(
        code=424,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x2,
        bit=0x10,
    ),
    "Lanayru Spring Underwater Right Chest": TPLocationData(
        code=425,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x2,
        bit=0x4,
    ),
    "Lanayru Spring West Double Clawshot Chest": TPLocationData(
        code=426,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x3,
        bit=0x8,
    ),
    "North Castle Town Golden Wolf": TPLocationData(
        code=427,
        flags=TPFlag.Overworld | TPFlag.Skill,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x82D,
        bit=0x40,
    ),
    "Outside Lanayru Spring Left Statue Chest": TPLocationData(
        code=428,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x3,
        bit=0x2,
    ),
    "Outside Lanayru Spring Right Statue Chest": TPLocationData(
        code=429,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x3,
        bit=0x40,
    ),
    "Outside South Castle Town Double Clawshot Chasm Chest": TPLocationData(
        code=430,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x2,
        bit=0x20,
    ),
    "Outside South Castle Town Female Ladybug": TPLocationData(
        code=431,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x19,
        bit=0x1,
    ),
    "Outside South Castle Town Fountain Chest": TPLocationData(
        code=432,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x2,
        bit=0x40,
    ),
    "Outside South Castle Town Golden Wolf": TPLocationData(
        code=433,
        flags=TPFlag.Overworld | TPFlag.Skill,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Flag,
        region=None,
        offset=0x82C,
        bit=0x2,
    ),
    "Outside South Castle Town Male Ladybug": TPLocationData(
        code=434,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x19,
        bit=0x2,
    ),
    "Outside South Castle Town Poe": TPLocationData(
        code=435,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0xD,
        bit=0x1,
    ),
    "Outside South Castle Town Tektite Grotto Chest": TPLocationData(
        code=436,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x3,
        bit=0x2,
    ),
    "Outside South Castle Town Tightrope Chest": TPLocationData(
        code=437,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x2,
        bit=0x10,
    ),
    "Plumm Fruit Balloon Minigame": TPLocationData(
        code=438,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Lake_Hylia,
        type=TPLocationType.Flag,
        region=None,
        offset=0x813,
        bit=0x80,
    ),
    "STAR Prize 1": TPLocationData(
        code=439,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x813,
        bit=0x8,
    ),
    "STAR Prize 2": TPLocationData(
        code=440,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0x813,
        bit=0x1,
    ),
    "Upper Zoras River Female Dragonfly": TPLocationData(
        code=441,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Upper_Zoras_River,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x18,
        bit=0x40,
    ),
    "Upper Zoras River Poe": TPLocationData(
        code=442,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Upper_Zoras_River,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x12,
        bit=0x1,
    ),
    "West Hyrule Field Female Butterfly": TPLocationData(
        code=443,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x18,
        bit=0x10,
    ),
    "West Hyrule Field Golden Wolf": TPLocationData(
        code=444,
        flags=TPFlag.Overworld | TPFlag.Skill,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Flag,
        region=None,
        offset=0x82C,
        bit=0x4,
    ),
    "West Hyrule Field Helmasaur Grotto Chest": TPLocationData(
        code=445,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x3,
        bit=0x1,
    ),
    "West Hyrule Field Male Butterfly": TPLocationData(
        code=446,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Region,
        region=NodeID.Hyrule_Field,
        offset=0x18,
        bit=0x20,
    ),
    "Zoras Domain Chest Behind Waterfall": TPLocationData(
        code=447,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Zoras_Domain,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x0,
        bit=0x4,
    ),
    "Zoras Domain Chest By Mother and Child Isles": TPLocationData(
        code=448,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Zoras_Domain,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x0,
        bit=0x40,
    ),
    "Zoras Domain Extinguish All Torches Chest": TPLocationData(
        code=449,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Zoras_Domain,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x1,
        bit=0x10,
    ),
    "Zoras Domain Light All Torches Chest": TPLocationData(
        code=450,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Zoras_Domain,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x1,
        bit=0x8,
    ),
    "Zoras Domain Male Dragonfly": TPLocationData(
        code=451,
        flags=TPFlag.Overworld | TPFlag.Bug,
        stage_id=TPStages.Zoras_Domain,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x18,
        bit=0x80,
    ),
    "Zoras Domain Mother and Child Isle Poe": TPLocationData(
        code=452,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Zoras_Domain,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x12,
        bit=0x4,
    ),
    "Zoras Domain Underwater Goron": TPLocationData(
        code=453,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Zoras_Domain,
        type=TPLocationType.Flag,
        region=None,
        offset=0x819,
        bit=0x20,
    ),
    "Zoras Domain Waterfall Poe": TPLocationData(
        code=454,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Zoras_Domain,
        type=TPLocationType.Region,
        region=NodeID.Lanayru,
        offset=0x12,
        bit=0x2,
    ),
    "Herding Goats Reward": TPLocationData(
        code=455,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x832,
        bit=0x40,
    ),
    "Links Basement Chest": TPLocationData(
        code=456,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Region,
        region=NodeID.Ordon,
        offset=0x3,
        bit=0x2,
    ),
    "Ordon Cat Rescue": TPLocationData(
        code=457,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x804,
        bit=0x8,
    ),
    "Ordon Ranch Grotto Lantern Chest": TPLocationData(
        code=458,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x3,
        bit=0x80,
    ),
    "Ordon Shield": TPLocationData(
        code=459,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Region,
        region=NodeID.Ordon,
        offset=0x8,
        bit=0x4,
    ),
    "Ordon Spring Golden Wolf": TPLocationData(
        code=460,
        flags=TPFlag.Overworld | TPFlag.Skill,
        stage_id=TPStages.Ordon_Spring,
        type=TPLocationType.Flag,
        region=None,
        offset=0x82C,
        bit=0x8,
    ),
    "Ordon Sword": TPLocationData(
        code=461,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Region,
        region=NodeID.Ordon,
        offset=0x8,
        bit=0x1,
    ),
    "Sera Shop Slingshot": TPLocationData(
        code=462,
        flags=TPFlag.Overworld | TPFlag.Shop,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x839,
        bit=0x2,
    ),
    "Uli Cradle Delivery": TPLocationData(
        code=463,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x7F3,
        bit=0x1,
    ),
    "Wooden Sword Chest": TPLocationData(
        code=464,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Region,
        region=NodeID.Ordon,
        offset=0x3,
        bit=0x10,
    ),
    "Wrestling With Bo": TPLocationData(
        code=465,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Ordon_Village,
        type=TPLocationType.Region,
        region=NodeID.Ordon,
        offset=0x3,
        bit=0x4,
    ),
    "Ashei Sketch": TPLocationData(
        code=466,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Snowpeak,
        type=TPLocationType.Flag,
        region=None,
        offset=0x819,
        bit=0x40,
    ),
    "Snowboard Racing Prize": TPLocationData(
        code=467,
        flags=TPFlag.Overworld | TPFlag.Npc,
        stage_id=TPStages.Snowpeak,
        type=TPLocationType.Flag,
        region=None,
        offset=0x82B,
        bit=0x10,
    ),
    "Snowpeak Above Freezard Grotto Poe": TPLocationData(
        code=468,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Snowpeak,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak,
        offset=0x14,
        bit=0x10,
    ),
    "Snowpeak Blizzard Poe": TPLocationData(
        code=469,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Snowpeak,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak,
        offset=0x14,
        bit=0x20,
    ),
    "Snowpeak Cave Ice Lantern Chest": TPLocationData(
        code=470,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Snowpeak,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak,
        offset=0x3,
        bit=0x1,
    ),
    "Snowpeak Cave Ice Poe": TPLocationData(
        code=471,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Snowpeak,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak,
        offset=0x14,
        bit=0x80,
    ),
    "Snowpeak Freezard Grotto Chest": TPLocationData(
        code=472,
        flags=TPFlag.Overworld,
        stage_id=TPStages.Snowpeak,
        type=TPLocationType.Region,
        region=NodeID.Grotto,
        offset=0x2,
        bit=0x80,
    ),
    "Snowpeak Icy Summit Poe": TPLocationData(
        code=473,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Snowpeak,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak,
        offset=0x14,
        bit=0x40,
    ),
    "Snowpeak Poe Among Trees": TPLocationData(
        code=474,
        flags=TPFlag.Overworld | TPFlag.Poe,
        stage_id=TPStages.Snowpeak,
        type=TPLocationType.Region,
        region=NodeID.Snowpeak,
        offset=0x14,
        bit=0x8,
    ),
    # Deterministic locations
    "Hyrule Castle Ganondorf": TPLocationData(
        code=None,
        flags=TPFlag.Always,
        stage_id=TPStages.Hyrule_Castle,
        type=TPLocationType.Flag,
        region=None,
        offset=0x857,
        bit=0x80,
    ),
    "Lakebed Temple Morpheel": TPLocationData(
        None, TPFlag.Always, TPStages.Lakebed_Temple, TPLocationType.Region
    ),
    "Palace of Twilight Zant": TPLocationData(
        None, TPFlag.Always, TPStages.Palace_of_Twilight, TPLocationType.Region
    ),
    "Snowpeak Ruins Blizzeta": TPLocationData(
        None, TPFlag.Always, TPStages.Snowpeak_Ruins, TPLocationType.Region
    ),
    "Temple of Time Armogohma": TPLocationData(
        None, TPFlag.Always, TPStages.Temple_of_Time, TPLocationType.Region
    ),
    "Goron Mines Fyrus": TPLocationData(
        None, TPFlag.Always, TPStages.Goron_Mines, TPLocationType.Region
    ),
    "Forest Temple Diababa": TPLocationData(
        None, TPFlag.Always, TPStages.Forest_Temple, TPLocationType.Region
    ),
    "City in The Sky Argorok": TPLocationData(
        None, TPFlag.Always, TPStages.City_in_the_Sky, TPLocationType.Region
    ),
    "Arbiters Grounds Stallord": TPLocationData(
        None, TPFlag.Always, TPStages.Arbiters_Grounds, TPLocationType.Region
    ),
    # "South Faron Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Faron_Woods, TPLocationType.Region
    # ),
    # "Death Mountain Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Death_Mountain, TPLocationType.Region
    # ),
    # "Castle Town Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Castle_Town, TPLocationType.Region
    # ),
    # "Bridge of Eldin Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Hyrule_Field, TPLocationType.Region
    # ),
    # "Mirror Chamber Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Mirror_Chamber, TPLocationType.Region
    # ),
    # "Sacred Grove Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Sacred_Grove, TPLocationType.Region
    # ),
    # "Snowpeak Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Snowpeak, TPLocationType.Region
    # ),
    # "Upper Zoras River Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Zoras_Domain, TPLocationType.Region
    # ),
    # "Zoras Domain Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Zoras_Domain, TPLocationType.Region
    # ),
    # "Kakariko Village Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Kakariko_Village, TPLocationType.Region
    # ),
    # "Kakariko Gorge Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Hyrule_Field, TPLocationType.Region
    # ),
    # "Gerudo Desert Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Gerudo_Desert, TPLocationType.Region
    # ),
    # "Lake Hylia Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Lake_Hylia, TPLocationType.Region
    # ),
    # "North Faron Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Faron_Woods, TPLocationType.Region
    # ),
    # "Ordon Spring Portal": TPLocationData(
    #     None, TPFlag.Always, TPStages.Ordon_Spring, TPLocationType.Region
    # ),
    "Renados Letter": TPLocationData(
        code=None,
        flags=TPFlag.Always,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x7FF,
        bit=0x80,
    ),
    "Ilias Charm": TPLocationData(
        code=None,
        flags=TPFlag.Always,
        stage_id=TPStages.Hidden_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x812,
        bit=0x80,
    ),
    "Ilia Memory Reward": TPLocationData(
        code=None,
        flags=TPFlag.Always,
        stage_id=TPStages.Kakariko_Village,
        type=TPLocationType.Flag,
        region=None,
        offset=0x813,
        bit=0x40,
    ),
    "Wooden Statue": TPLocationData(
        code=None,
        flags=TPFlag.Always,
        stage_id=TPStages.Lanayru_Field,
        type=TPLocationType.Flag,
        region=None,
        offset=0xDF,
        bit=0x04,
    ),
    "Telma Invoice": TPLocationData(
        code=None,
        flags=TPFlag.Always,
        stage_id=TPStages.Castle_Town,
        type=TPLocationType.Flag,
        region=None,
        offset=0xDF,
        bit=0x2,
    ),
}

LOCATION_TO_REGION: dict[str, str] = {
    "Arbiters Grounds Entrance Chest": "Arbiters Grounds Entrance",
    "Arbiters Grounds Torch Room East Chest": "Arbiters Grounds Lobby",
    "Arbiters Grounds Torch Room West Chest": "Arbiters Grounds Lobby",
    "Arbiters Grounds Torch Room Poe": "Arbiters Grounds Lobby",
    "Arbiters Grounds East Lower Turnable Redead Chest": "Arbiters Grounds East Wing",
    "Arbiters Grounds East Upper Turnable Chest": "Arbiters Grounds East Wing",
    "Arbiters Grounds East Upper Turnable Redead Chest": "Arbiters Grounds East Wing",
    "Arbiters Grounds Ghoul Rat Room Chest": "Arbiters Grounds East Wing",
    "Arbiters Grounds East Turning Room Poe": "Arbiters Grounds East Wing",
    "Arbiters Grounds Hidden Wall Poe": "Arbiters Grounds East Wing",
    "Arbiters Grounds West Small Chest Behind Block": "Arbiters Grounds West Wing",
    "Arbiters Grounds West Chandelier Chest": "Arbiters Grounds West Wing",
    "Arbiters Grounds West Stalfos West Chest": "Arbiters Grounds West Wing",
    "Arbiters Grounds West Stalfos Northeast Chest": "Arbiters Grounds West Wing",
    "Arbiters Grounds West Poe": "Arbiters Grounds West Wing",
    "Arbiters Grounds Big Key Chest": "Arbiters Grounds After Poe Gate",
    "Arbiters Grounds North Turning Room Chest": "Arbiters Grounds After Poe Gate",
    "Arbiters Grounds Death Sword Chest": "Arbiters Grounds After Poe Gate",
    "Arbiters Grounds Spinner Room First Small Chest": "Arbiters Grounds After Poe Gate",
    "Arbiters Grounds Spinner Room Second Small Chest": "Arbiters Grounds After Poe Gate",
    "Arbiters Grounds Spinner Room Lower Central Small Chest": "Arbiters Grounds After Poe Gate",
    "Arbiters Grounds Spinner Room Stalfos Alcove Chest": "Arbiters Grounds After Poe Gate",
    "Arbiters Grounds Spinner Room Lower North Chest": "Arbiters Grounds After Poe Gate",
    "Arbiters Grounds Stallord Heart Container": "Arbiters Grounds Boss Room",
    "Arbiters Grounds Dungeon Reward": "Arbiters Grounds Boss Room",
    "City in The Sky Argorok Heart Container": "City in The Sky Boss Room",
    "City in The Sky Dungeon Reward": "City in The Sky Boss Room",
    "City in The Sky Central Outside Ledge Chest": "City in The Sky Central Tower Second Floor",
    "City in The Sky Central Outside Poe Island Chest": "City in The Sky Central Tower Second Floor",
    "City in The Sky Big Key Chest": "City in The Sky Central Tower Second Floor",
    "City in The Sky Chest Below Big Key Chest": "City in The Sky Central Tower Second Floor",
    "City in The Sky Poe Above Central Fan": "City in The Sky Central Tower Second Floor",
    "City in The Sky East First Wing Chest After Fans": "City in The Sky East Wing",
    "City in The Sky East Wing Lower Level Chest": "City in The Sky East Wing",
    "City in The Sky East Tile Worm Small Chest": "City in The Sky East Wing",
    "City in The Sky East Wing After Dinalfos Alcove Chest": "City in The Sky East Wing",
    "City in The Sky East Wing After Dinalfos Ledge Chest": "City in The Sky East Wing",
    "City in The Sky Aeralfos Chest": "City in The Sky East Wing",
    "City in The Sky Underwater West Chest": "City in The Sky Entrance",
    "City in The Sky Underwater East Chest": "City in The Sky Entrance",
    # "" : "City in The Sky Lobby",
    "City in The Sky Chest Behind North Fan": "City in The Sky North Wing",
    "City in The Sky West Wing First Chest": "City in The Sky West Wing",
    "City in The Sky West Wing Baba Balcony Chest": "City in The Sky West Wing",
    "City in The Sky West Wing Narrow Ledge Chest": "City in The Sky West Wing",
    "City in The Sky West Wing Tile Worm Chest": "City in The Sky West Wing",
    "City in The Sky Baba Tower Top Small Chest": "City in The Sky West Wing",
    "City in The Sky Baba Tower Narrow Ledge Chest": "City in The Sky West Wing",
    "City in The Sky Baba Tower Alcove Chest": "City in The Sky West Wing",
    "City in The Sky West Garden Corner Chest": "City in The Sky West Wing",
    "City in The Sky West Garden Lone Island Chest": "City in The Sky West Wing",
    "City in The Sky West Garden Lower Chest": "City in The Sky West Wing",
    "City in The Sky West Garden Ledge Chest": "City in The Sky West Wing",
    "City in The Sky Garden Island Poe": "City in The Sky West Wing",
    "Forest Temple Diababa Heart Container": "Forest Temple Boss Room",
    "Forest Temple Dungeon Reward": "Forest Temple Boss Room",
    "Forest Temple Second Monkey Under Bridge Chest": "Forest Temple East Wing",
    "Forest Temple Big Key Chest": "Forest Temple East Wing",
    "Forest Temple East Water Cave Chest": "Forest Temple East Wing",
    "Forest Temple Entrance Vines Chest": "Forest Temple Entrance",
    "Forest Temple Central Chest Behind Stairs": "Forest Temple Lobby",
    "Forest Temple Central North Chest": "Forest Temple Lobby",
    "Forest Temple Central Chest Hanging From Web": "Forest Temple Lobby",
    "Forest Temple Windless Bridge Chest": "Forest Temple North Wing",
    "Forest Temple North Deku Like Chest": "Forest Temple North Wing",
    "Forest Temple East Tile Worm Chest": "Forest Temple North Wing",
    "Forest Temple West Deku Like Chest": "Forest Temple West Wing",
    "Forest Temple Totem Pole Chest": "Forest Temple West Wing",
    "Forest Temple West Tile Worm Room Vines Chest": "Forest Temple West Wing",
    "Forest Temple West Tile Worm Chest Behind Stairs": "Forest Temple West Wing",
    "Forest Temple Big Baba Key": "Forest Temple West Wing",
    "Forest Temple Gale Boomerang": "Ook",
    "Goron Mines Fyrus Heart Container": "Goron Mines Boss Room",
    "Goron Mines Dungeon Reward": "Goron Mines Boss Room",
    "Goron Mines Crystal Switch Room Underwater Chest": "Goron Mines Crystal Switch Room",
    "Goron Mines Crystal Switch Room Small Chest": "Goron Mines Crystal Switch Room",
    "Goron Mines After Crystal Switch Room Magnet Wall Chest": "Goron Mines Crystal Switch Room",
    "Goron Mines Entrance Chest": "Goron Mines Entrance",
    "Goron Mines Magnet Maze Chest": "Goron Mines Lower West Wing",
    "Goron Mines Gor Amato Chest": "Goron Mines Lower West Wing",
    "Goron Mines Gor Amato Small Chest": "Goron Mines Lower West Wing",
    "Goron Mines Gor Amato Key Shard": "Goron Mines Lower West Wing",
    "Goron Mines Main Magnet Room Bottom Chest": "Goron Mines Magnet Room",
    "Goron Mines Main Magnet Room Top Chest": "Goron Mines Magnet Room",
    "Goron Mines Outside Beamos Chest": "Goron Mines North Wing",
    "Goron Mines Outside Underwater Chest": "Goron Mines North Wing",
    "Goron Mines Outside Clawshot Chest": "Goron Mines North Wing",
    "Goron Mines Gor Ebizo Chest": "Goron Mines Upper East Wing",
    "Goron Mines Chest Before Dangoro": "Goron Mines Upper East Wing",
    "Goron Mines Gor Ebizo Key Shard": "Goron Mines Upper East Wing",
    "Goron Mines Dangoro Chest": "Goron Mines Upper East Wing",
    "Goron Mines Beamos Room Chest": "Goron Mines Upper East Wing",
    "Goron Mines Gor Liggs Chest": "Goron Mines Upper East Wing",
    "Goron Mines Gor Liggs Key Shard": "Goron Mines Upper East Wing",
    # "" : "Ganondorf Castle",
    # "" : "Hyrule Castle Entrance",
    "Hyrule Castle Graveyard Grave Switch Room Right Chest": "Hyrule Castle Graveyard",
    "Hyrule Castle Graveyard Grave Switch Room Front Left Chest": "Hyrule Castle Graveyard",
    "Hyrule Castle Graveyard Grave Switch Room Back Left Chest": "Hyrule Castle Graveyard",
    "Hyrule Castle Graveyard Owl Statue Chest": "Hyrule Castle Graveyard",
    # "" : "Hyrule Castle Inside East Wing",
    # "" : "Hyrule Castle Inside West Wing",
    "Hyrule Castle Main Hall Northeast Chest": "Hyrule Castle Main Hall",
    "Hyrule Castle Main Hall Southwest Chest": "Hyrule Castle Main Hall",
    "Hyrule Castle Main Hall Northwest Chest": "Hyrule Castle Main Hall",
    "Hyrule Castle Lantern Staircase Chest": "Hyrule Castle Main Hall",
    "Hyrule Castle East Wing Boomerang Puzzle Chest": "Hyrule Castle Outside East Wing",
    "Hyrule Castle East Wing Balcony Chest": "Hyrule Castle Outside East Wing",
    "Hyrule Castle West Courtyard North Small Chest": "Hyrule Castle Outside West Wing",
    "Hyrule Castle West Courtyard Central Small Chest": "Hyrule Castle Outside West Wing",
    "Hyrule Castle King Bulblin Key": "Hyrule Castle Outside West Wing",
    "Hyrule Castle Southeast Balcony Tower Chest": "Hyrule Castle Third Floor Balcony",
    "Hyrule Castle Big Key Chest": "Hyrule Castle Third Floor Balcony",
    # "" : "Hyrule Castle Tower Climb",
    "Hyrule Castle Treasure Room Eighth Small Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Seventh Small Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Sixth Small Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Fifth Small Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Fourth Small Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Third Small Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Second Small Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room First Small Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Fifth Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Fourth Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Third Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room Second Chest": "Hyrule Castle Treasure Room",
    "Hyrule Castle Treasure Room First Chest": "Hyrule Castle Treasure Room",
    "Lakebed Temple Morpheel Heart Container": "Lakebed Temple Boss Room",
    "Lakebed Temple Dungeon Reward": "Lakebed Temple Boss Room",
    "Lakebed Temple Central Room Small Chest": "Lakebed Temple Central Room",
    "Lakebed Temple Central Room Chest": "Lakebed Temple Central Room",
    "Lakebed Temple Chandelier Chest": "Lakebed Temple Central Room",
    "Lakebed Temple Central Room Spire Chest": "Lakebed Temple Central Room",
    "Lakebed Temple East Lower Waterwheel Stalactite Chest": "Lakebed Temple East Wing First Floor",
    "Lakebed Temple East Lower Waterwheel Bridge Chest": "Lakebed Temple East Wing First Floor",
    "Lakebed Temple Before Deku Toad Alcove Chest": "Lakebed Temple East Wing First Floor",
    "Lakebed Temple Before Deku Toad Underwater Left Chest": "Lakebed Temple East Wing First Floor",
    "Lakebed Temple Before Deku Toad Underwater Right Chest": "Lakebed Temple East Wing First Floor",
    "Lakebed Temple Deku Toad Chest": "Lakebed Temple East Wing First Floor",
    "Lakebed Temple East Second Floor Southwest Chest": "Lakebed Temple East Wing Second Floor",
    "Lakebed Temple East Second Floor Southeast Chest": "Lakebed Temple East Wing Second Floor",
    "Lakebed Temple East Water Supply Small Chest": "Lakebed Temple East Wing Second Floor",
    "Lakebed Temple East Water Supply Clawshot Chest": "Lakebed Temple East Wing Second Floor",
    "Lakebed Temple Lobby Left Chest": "Lakebed Temple Entrance",
    "Lakebed Temple Lobby Rear Chest": "Lakebed Temple Entrance",
    "Lakebed Temple Stalactite Room Chest": "Lakebed Temple Entrance",
    "Lakebed Temple West Lower Small Chest": "Lakebed Temple West Wing",
    "Lakebed Temple West Second Floor Central Small Chest": "Lakebed Temple West Wing",
    "Lakebed Temple Underwater Maze Small Chest": "Lakebed Temple West Wing",
    "Lakebed Temple Big Key Chest": "Lakebed Temple West Wing",
    "Lakebed Temple West Second Floor Southwest Underwater Chest": "Lakebed Temple West Wing",
    "Lakebed Temple West Second Floor Northeast Chest": "Lakebed Temple West Wing",
    "Lakebed Temple West Second Floor Southeast Chest": "Lakebed Temple West Wing",
    "Lakebed Temple West Water Supply Small Chest": "Lakebed Temple West Wing",
    "Lakebed Temple West Water Supply Chest": "Lakebed Temple West Wing",
    "Palace of Twilight Collect Both Sols": "Palace of Twilight Entrance",
    "Palace of Twilight West Wing First Room Central Chest": "Palace of Twilight West Wing",
    "Palace of Twilight West Wing Chest Behind Wall of Darkness": "Palace of Twilight West Wing",
    "Palace of Twilight West Wing Second Room Central Chest": "Palace of Twilight West Wing",
    "Palace of Twilight West Wing Second Room Lower South Chest": "Palace of Twilight West Wing",
    "Palace of Twilight West Wing Second Room Southeast Chest": "Palace of Twilight West Wing",
    "Palace of Twilight East Wing First Room North Small Chest": "Palace of Twilight East Wing",
    "Palace of Twilight East Wing First Room Zant Head Chest": "Palace of Twilight East Wing",
    "Palace of Twilight East Wing First Room East Alcove Chest": "Palace of Twilight East Wing",
    "Palace of Twilight East Wing First Room West Alcove Chest": "Palace of Twilight East Wing",
    "Palace of Twilight East Wing Second Room Northeast Chest": "Palace of Twilight East Wing",
    "Palace of Twilight East Wing Second Room Northwest Chest": "Palace of Twilight East Wing",
    "Palace of Twilight East Wing Second Room Southwest Chest": "Palace of Twilight East Wing",
    "Palace of Twilight East Wing Second Room Southeast Chest": "Palace of Twilight East Wing",
    "Palace of Twilight Central First Room Chest": "Palace of Twilight Central First Room",
    "Palace of Twilight Big Key Chest": "Palace of Twilight Outside Room",
    "Palace of Twilight Central Outdoor Chest": "Palace of Twilight Outside Room",
    "Palace of Twilight Central Tower Chest": "Palace of Twilight North Tower",
    "Palace of Twilight Zant Heart Container": "Palace of Twilight Boss Room",
    # "" : "Snowpeak Ruins Left Door",
    # "" : "Snowpeak Ruins Right Door",
    "Snowpeak Ruins Blizzeta Heart Container": "Snowpeak Ruins Boss Room",
    "Snowpeak Ruins Dungeon Reward": "Snowpeak Ruins Boss Room",
    "Snowpeak Ruins Broken Floor Chest": "Snowpeak Ruins Caged Freezard Room",
    "Snowpeak Ruins Chapel Chest": "Snowpeak Ruins Chapel",
    "Snowpeak Ruins Ball and Chain": "Snowpeak Ruins Darkhammer Room",
    "Snowpeak Ruins Chest After Darkhammer": "Snowpeak Ruins Darkhammer Room",
    "Snowpeak Ruins East Courtyard Buried Chest": "Snowpeak Ruins East Courtyard",
    "Snowpeak Ruins East Courtyard Chest": "Snowpeak Ruins East Courtyard",
    "Snowpeak Ruins Lobby Chandelier Chest": "Snowpeak Ruins Entrance",
    "Snowpeak Ruins Lobby West Armor Chest": "Snowpeak Ruins Entrance",
    "Snowpeak Ruins Lobby East Armor Chest": "Snowpeak Ruins Entrance",
    "Snowpeak Ruins Lobby Armor Poe": "Snowpeak Ruins Entrance",
    "Snowpeak Ruins Lobby Poe": "Snowpeak Ruins Entrance",
    "Snowpeak Ruins Ordon Pumpkin Chest": "Snowpeak Ruins Northeast Chilfos Room First Floor",
    "Snowpeak Ruins Northeast Chandelier Chest": "Snowpeak Ruins Northeast Chilfos Room Second Floor",
    "Snowpeak Ruins Ice Room Poe": "Snowpeak Ruins Second Floor Mini Freezard Room",
    "Snowpeak Ruins West Cannon Room Central Chest": "Snowpeak Ruins West Cannon Room",
    "Snowpeak Ruins West Cannon Room Corner Chest": "Snowpeak Ruins West Cannon Room",
    "Snowpeak Ruins West Courtyard Buried Chest": "Snowpeak Ruins West Courtyard",
    "Snowpeak Ruins Courtyard Central Chest": "Snowpeak Ruins West Courtyard",
    "Snowpeak Ruins Wooden Beam Central Chest": "Snowpeak Ruins Wooden Beam Room",
    "Snowpeak Ruins Wooden Beam Northwest Chest": "Snowpeak Ruins Wooden Beam Room",
    "Snowpeak Ruins Wooden Beam Chandelier Chest": "Snowpeak Ruins Wooden Beam Room",
    "Snowpeak Ruins Mansion Map": "Snowpeak Ruins Yeto and Yeta",
    "Temple of Time Armos Antechamber East Chest": "Temple of Time Armos Antechamber",
    "Temple of Time Armos Antechamber North Chest": "Temple of Time Armos Antechamber",
    "Temple of Time Armos Antechamber Statue Chest": "Temple of Time Armos Antechamber",
    "Temple of Time Armogohma Heart Container": "Temple of Time Boss Room",
    "Temple of Time Dungeon Reward": "Temple of Time Boss Room",
    "Temple of Time Poe Behind Gate": "Temple of Time Central Mechanical Platform",
    "Temple of Time First Staircase Gohma Gate Chest": "Temple of Time Connecting Corridors",
    "Temple of Time First Staircase Window Chest": "Temple of Time Connecting Corridors",
    "Temple of Time First Staircase Armos Chest": "Temple of Time Connecting Corridors",
    # "" : "Temple of Time Crumbling Corridor",
    "Temple of Time Darknut Chest": "Temple of Time Darknut Arena",
    "Temple of Time Lobby Lantern Chest": "Temple of Time Entrance",
    "Temple of Time Big Key Chest": "Temple of Time Floor Switch Puzzle Room",
    "Temple of Time Floor Switch Puzzle Room Upper Chest": "Temple of Time Floor Switch Puzzle Room",
    "Temple of Time Moving Wall Beamos Room Chest": "Temple of Time Moving Wall Hallways",
    "Temple of Time Moving Wall Dinalfos Room Chest": "Temple of Time Moving Wall Hallways",
    "Temple of Time Scales Gohma Chest": "Temple of Time Scales of Time",
    "Temple of Time Scales Upper Chest": "Temple of Time Scales of Time",
    "Temple of Time Poe Above Scales": "Temple of Time Scales of Time",
    "Temple of Time Gilloutine Chest": "Temple of Time Upper Spike Trap Corridor",
    "Temple of Time Chest Before Darknut": "Temple of Time Upper Spike Trap Corridor",
    # "" : "Death Mountain Near Kakariko",
    "Death Mountain Alcove Chest": "Death Mountain Trail",
    "Death Mountain Trail Poe": "Death Mountain Trail",
    # "" : "Death Mountain Volcano",
    # "" : "Death Mountain Outside Sumo Hall",
    # "" : "Death Mountain Elevator Lower",
    # "" : "Death Mountain Sumo Hall",
    # "" : "Death Mountain Sumo Hall Elevator",
    # "" : "Death Mountain Sumo Hall Goron Mines Tunnel",
    "Cats Hide and Seek Minigame": "Hidden Village",
    "Ilias Charm": "Hidden Village",
    "Hidden Village Poe": "Hidden Village",
    "Skybook From Impaz": "Hidden Village Impaz House",
    "Kakariko Gorge Owl Statue Chest": "Kakariko Gorge",
    "Kakariko Gorge Double Clawshot Chest": "Kakariko Gorge",
    "Kakariko Gorge Spire Heart Piece": "Kakariko Gorge",
    "Kakariko Gorge Owl Statue Sky Character": "Kakariko Gorge",
    "Kakariko Gorge Male Pill Bug": "Kakariko Gorge",
    "Kakariko Gorge Female Pill Bug": "Kakariko Gorge",
    "Kakariko Gorge Poe": "Kakariko Gorge",
    # "" : "Kakariko Gorge Cave Entrance",
    # "" : "Kakariko Gorge Behind Gate",
    "Eldin Lantern Cave First Chest": "Eldin Lantern Cave",
    "Eldin Lantern Cave Lantern Chest": "Eldin Lantern Cave",
    "Eldin Lantern Cave Second Chest": "Eldin Lantern Cave",
    "Eldin Lantern Cave Poe": "Eldin Lantern Cave",
    # "" : "Kakariko Gorge Keese Grotto",
    "Eldin Field Bomb Rock Chest": "Eldin Field",
    "Bridge of Eldin Owl Statue Chest": "Eldin Field",
    "Goron Springwater Rush": "Eldin Field",
    "Bridge of Eldin Owl Statue Sky Character": "Eldin Field",
    "Eldin Field Male Grasshopper": "Eldin Field",
    "Eldin Field Female Grasshopper": "Eldin Field",
    "Bridge of Eldin Male Phasmid": "Eldin Field",
    "Bridge of Eldin Female Phasmid": "Eldin Field",
    # "" : "Eldin Field Near Castle Town",
    # "" : "Eldin Field Lava Cave Ledge",
    # "" : "Eldin Field From Lava Cave Lower",
    # "" : "North Eldin Field",
    # "" : "Eldin Field Outside Hidden Village",
    # "" : "Eldin Field Grotto Platform",
    "Eldin Stockcave Upper Chest": "Eldin Field Lava Cave Upper",
    "Eldin Stockcave Lantern Chest": "Eldin Field Lava Cave Lower",
    "Eldin Stockcave Lowest Chest": "Eldin Field Lava Cave Lower",
    "Eldin Field Bomskit Grotto Left Chest": "Eldin Field Bomskit Grotto",
    "Eldin Field Bomskit Grotto Lantern Chest": "Eldin Field Bomskit Grotto",
    "Eldin Field Water Bomb Fish Grotto Chest": "Eldin Field Water Bomb Fish Grotto",
    "Eldin Field Stalfos Grotto Right Small Chest": "Eldin Field Stalfos Grotto",
    "Eldin Field Stalfos Grotto Left Small Chest": "Eldin Field Stalfos Grotto",
    "Eldin Field Stalfos Grotto Stalfos Chest": "Eldin Field Stalfos Grotto",
    "Eldin Spring Underwater Chest": "Lower Kakariko Village",
    "Kakariko Village Bomb Rock Spire Heart Piece": "Lower Kakariko Village",
    "Kakariko Village Bomb Shop Poe": "Upper Kakariko Village",
    "Kakariko Village Watchtower Poe": "Upper Kakariko Village",
    "Kakariko Watchtower Alcove Chest": "Upper Kakariko Village",
    "Talo Sharpshooting": "Kakariko Top of Watchtower",
    # "" : "Kakariko Village Behind Gate",
    # "" : "Kakariko Renados Sanctuary Front Left Door",
    # "" : "Kakariko Renados Sanctuary Front Right Door",
    # "" : "Kakariko Renados Sanctuary Back Left Door",
    # "" : "Kakariko Renados Sanctuary Back Right Door",
    "Renados Letter": "Kakariko Renados Sanctuary",
    "Ilia Memory Reward": "Kakariko Renados Sanctuary",
    # "" : "Kakariko Renados Sanctuary Basement",
    "Kakariko Village Malo Mart Hylian Shield": "Kakariko Malo Mart",
    "Kakariko Village Malo Mart Hawkeye": "Kakariko Malo Mart",
    "Kakariko Village Malo Mart Red Potion": "Kakariko Malo Mart",
    "Kakariko Village Malo Mart Wooden Shield": "Kakariko Malo Mart",
    # "" : "Kakariko Elde Inn Left Door",
    # "" : "Kakariko Elde Inn Right Door",
    "Kakariko Inn Chest": "Kakariko Elde Inn",
    # "" : "Kakariko Bug House Door",
    # "" : "Kakariko Bug House Ceiling Hole",
    "Kakariko Village Female Ant": "Kakariko Bug House",
    "Barnes Bomb Bag": "Kakariko Barnes Bomb Shop Lower",
    # "" : "Kakariko Barnes Bomb Shop Upper",
    # "" : "Kakariko Watchtower Lower Door",
    # "" : "Kakariko Watchtower Dig Spot",
    # "" : "Kakariko Watchtower Upper Door",
    "Kakariko Watchtower Chest": "Kakariko Watchtower",
    "Kakariko Graveyard Lantern Chest": "Kakariko Graveyard",
    "Gift From Ralis": "Kakariko Graveyard",
    "Rutelas Blessing": "Kakariko Graveyard",
    "Kakariko Graveyard Male Ant": "Kakariko Graveyard",
    "Kakariko Graveyard Grave Poe": "Kakariko Graveyard",
    "Kakariko Graveyard Open Poe": "Kakariko Graveyard",
    "Kakariko Graveyard Golden Wolf": "Kakariko Graveyard",
    "Coro Bottle": "South Faron Woods",
    # "" : "South Faron Woods Behind Gate",
    # "" : "South Faron Woods Coros Ledge",
    "Faron Woods Owl Statue Sky Character": "South Faron Woods Owl Statue Area",
    # "" : "South Faron Woods Above Owl Statue",
    # "" : "Faron Woods Coros House Lower",
    # "" : "Faron Woods Coros House Upper",
    # "" : "Faron Woods Cave Southern Entrance",
    "South Faron Cave Chest": "Faron Woods Cave",
    # "" : "Mist Area Near Faron Woods Cave",
    "Faron Mist Stump Chest": "Mist Area Inside Mist",
    "Faron Mist North Chest": "Mist Area Inside Mist",
    "Faron Mist South Chest": "Mist Area Inside Mist",
    # "" : "Mist Area Under Owl Statue Chest",
    "Faron Woods Owl Statue Chest": "Mist Area Near Owl Statue Chest",
    "Faron Mist Poe": "Mist Area Center Stump",
    # "" : "Mist Area Outside Faron Mist Cave",
    # "" : "Mist Area Near North Faron Woods",
    # "" : "Faron Woods Cave Northern Entrance",
    "Faron Mist Cave Open Chest": "Mist Area Faron Mist Cave",
    "Faron Mist Cave Lantern Chest": "Mist Area Faron Mist Cave",
    "North Faron Woods Deku Baba Chest": "North Faron Woods",
    "Faron Woods Golden Wolf": "North Faron Woods",
    "Faron Field Bridge Chest": "Faron Field",
    "Faron Field Tree Heart Piece": "Faron Field",
    "Faron Field Male Beetle": "Faron Field",
    "Faron Field Female Beetle": "Faron Field",
    "Faron Field Poe": "Faron Field",
    # "" : "Faron Field Behind Boulder",
    "Faron Field Corner Grotto Right Chest": "Faron Field Corner Grotto",
    "Faron Field Corner Grotto Left Chest": "Faron Field Corner Grotto",
    "Faron Field Corner Grotto Rear Chest": "Faron Field Corner Grotto",
    # "" : "Faron Field Fishing Grotto",
    "Lost Woods Lantern Chest": "Lost Woods",
    "Lost Woods Waterfall Poe": "Lost Woods",
    "Sacred Grove Spinner Chest": "Lost Woods Lower Battle Arena",
    "Lost Woods Boulder Poe": "Lost Woods Lower Battle Arena",
    # "" : "Lost Woods Upper Battle Arena",
    "Sacred Grove Baba Serpent Grotto Chest": "Lost Woods Baba Serpent Grotto",
    # "" : "Sacred Grove Before Block",
    # "" : "Sacred Grove Upper",
    "Sacred Grove Male Snail": "Sacred Grove Lower",
    "Sacred Grove Master Sword Poe": "Sacred Grove Lower",
    "Sacred Grove Pedestal Master Sword": "Sacred Grove Lower",
    "Sacred Grove Pedestal Shadow Crystal": "Sacred Grove Lower",
    "Sacred Grove Past Owl Statue Chest": "Sacred Grove Past",
    "Sacred Grove Female Snail": "Sacred Grove Past",
    "Sacred Grove Temple of Time Owl Statue Poe": "Sacred Grove Past",
    # "" : "Sacred Grove Past Behind Window",
    # "" : "Gerudo Desert Cave of Ordeals Floors 01-11",
    "Cave of Ordeals Floor 17 Poe": "Gerudo Desert Cave of Ordeals Floors 12-21",
    # "" : "Gerudo Desert Cave of Ordeals Floors 22-31",
    "Cave of Ordeals Floor 33 Poe": "Gerudo Desert Cave of Ordeals Floors 32-41",
    "Cave of Ordeals Floor 44 Poe": "Gerudo Desert Cave of Ordeals Floors 42-50",
    "Cave of Ordeals Great Fairy Reward": "Gerudo Desert Cave of Ordeals Floors 42-50",
    "Gerudo Desert Peahat Ledge Chest": "Gerudo Desert",
    "Gerudo Desert East Canyon Chest": "Gerudo Desert",
    "Gerudo Desert Lone Small Chest": "Gerudo Desert",
    "Gerudo Desert West Canyon Chest": "Gerudo Desert",
    "Gerudo Desert South Chest Behind Wooden Gates": "Gerudo Desert",
    "Gerudo Desert Owl Statue Chest": "Gerudo Desert",
    "Gerudo Desert Owl Statue Sky Character": "Gerudo Desert",
    "Gerudo Desert Male Dayfly": "Gerudo Desert",
    "Gerudo Desert Female Dayfly": "Gerudo Desert",
    "Gerudo Desert East Poe": "Gerudo Desert",
    "Gerudo Desert Poe Above Cave of Ordeals": "Gerudo Desert Cave of Ordeals Plateau",
    "Gerudo Desert Northeast Chest Behind Gates": "Gerudo Desert Basin",
    "Gerudo Desert Campfire North Chest": "Gerudo Desert Basin",
    "Gerudo Desert Campfire East Chest": "Gerudo Desert Basin",
    "Gerudo Desert Campfire West Chest": "Gerudo Desert Basin",
    "Gerudo Desert Northwest Chest Behind Gates": "Gerudo Desert Basin",
    "Gerudo Desert North Peahat Poe": "Gerudo Desert North East Ledge",
    "Gerudo Desert North Small Chest Before Bulblin Camp": "Gerudo Desert Outside Bulblin Camp",
    "Outside Bulblin Camp Poe": "Gerudo Desert Outside Bulblin Camp",
    "Gerudo Desert Golden Wolf": "Gerudo Desert Outside Bulblin Camp",
    "Gerudo Desert Skulltula Grotto Chest": "Gerudo Desert Skulltula Grotto",
    # "" : "Gerudo Desert Chu Grotto",
    "Gerudo Desert Rock Grotto Lantern Chest": "Gerudo Desert Rock Grotto",
    "Gerudo Desert Rock Grotto First Poe": "Gerudo Desert Rock Grotto",
    "Gerudo Desert Rock Grotto Second Poe": "Gerudo Desert Rock Grotto",
    "Bulblin Camp First Chest Under Tower At Entrance": "Bulblin Camp",
    "Bulblin Camp Small Chest in Back of Camp": "Bulblin Camp",
    "Bulblin Camp Roasted Boar": "Bulblin Camp",
    "Bulblin Camp Poe": "Bulblin Camp",
    "Bulblin Guard Key": "Bulblin Camp",
    "Outside Arbiters Grounds Lantern Chest": "Outside Arbiters Grounds",
    "Outside Arbiters Grounds Poe": "Outside Arbiters Grounds",
    # "" : "Mirror Chamber Lower",
    # "" : "Mirror Chamber Upper",
    # "" : "Mirror Chamber Portal",
    "Charlo Donation Blessing": "Castle Town West",
    "STAR Prize 1": "Castle Town STAR Game",
    "STAR Prize 2": "Castle Town STAR Game",
    # "" : "Castle Town Center",
    # "" : "Castle Town Goron House Left Door",
    # "" : "Castle Town Goron House Right Door",
    # "" : "Castle Town Goron House",
    "Castle Town Malo Mart Magic Armor": "Castle Town Malo Mart",
    # "" : "Castle Town North",
    "North Castle Town Golden Wolf": "Castle Town North Behind First Door",
    # "" : "Castle Town North Inside Barrier",
    # "" : "Castle Town East",
    "Doctors Office Balcony Chest": "Castle Town Doctors Office Balcony",
    # "" : "Castle Town Doctors Office Left Door",
    # "" : "Castle Town Doctors Office Right Door",
    # "" : "Castle Town Doctors Office Entrance",
    # "" : "Castle Town Doctors Office Lower",
    # "" : "Castle Town Doctors Office Upper",
    # "" : "Castle Town South",
    "Agitha Female Ant Reward": "Castle Town Agithas House",
    "Agitha Female Beetle Reward": "Castle Town Agithas House",
    "Agitha Female Butterfly Reward": "Castle Town Agithas House",
    "Agitha Female Dayfly Reward": "Castle Town Agithas House",
    "Agitha Female Dragonfly Reward": "Castle Town Agithas House",
    "Agitha Female Grasshopper Reward": "Castle Town Agithas House",
    "Agitha Female Ladybug Reward": "Castle Town Agithas House",
    "Agitha Female Mantis Reward": "Castle Town Agithas House",
    "Agitha Female Phasmid Reward": "Castle Town Agithas House",
    "Agitha Female Pill Bug Reward": "Castle Town Agithas House",
    "Agitha Female Snail Reward": "Castle Town Agithas House",
    "Agitha Female Stag Beetle Reward": "Castle Town Agithas House",
    "Agitha Male Ant Reward": "Castle Town Agithas House",
    "Agitha Male Beetle Reward": "Castle Town Agithas House",
    "Agitha Male Butterfly Reward": "Castle Town Agithas House",
    "Agitha Male Dayfly Reward": "Castle Town Agithas House",
    "Agitha Male Dragonfly Reward": "Castle Town Agithas House",
    "Agitha Male Grasshopper Reward": "Castle Town Agithas House",
    "Agitha Male Ladybug Reward": "Castle Town Agithas House",
    "Agitha Male Mantis Reward": "Castle Town Agithas House",
    "Agitha Male Phasmid Reward": "Castle Town Agithas House",
    "Agitha Male Pill Bug Reward": "Castle Town Agithas House",
    "Agitha Male Snail Reward": "Castle Town Agithas House",
    "Agitha Male Stag Beetle Reward": "Castle Town Agithas House",
    # "" : "Castle Town Seer House",
    "Jovani House Poe": "Castle Town Jovanis House",
    "Jovani 20 Poe Soul Reward": "Castle Town Jovanis House",
    "Jovani 60 Poe Soul Reward": "Castle Town Jovanis House",
    "Telma Invoice": "Castle Town Telmas Bar",
    "Lanayru Field Behind Gate Underwater Chest": "Lanayru Field",
    "Lanayru Field Male Stag Beetle": "Lanayru Field",
    "Lanayru Field Female Stag Beetle": "Lanayru Field",
    "Lanayru Field Bridge Poe": "Lanayru Field",
    # "" : "Lanayru Field Cave Entrance",
    # "" : "Lanayru Field Behind Boulder",
    "Lanayru Field Spinner Track Chest": "Hyrule Field Near Spinner Rails",
    "Lanayru Ice Block Puzzle Cave Chest": "Lanayru Ice Puzzle Cave",
    # "" : "Lanayru Field Chu Grotto",
    "Lanayru Field Skulltula Grotto Chest": "Lanayru Field Skulltula Grotto",
    "Lanayru Field Poe Grotto Left Poe": "Lanayru Field Poe Grotto",
    "Lanayru Field Poe Grotto Right Poe": "Lanayru Field Poe Grotto",
    "Hyrule Field Amphitheater Owl Statue Chest": "Outside Castle Town West",
    "Hyrule Field Amphitheater Owl Statue Sky Character": "Outside Castle Town West",
    "West Hyrule Field Male Butterfly": "Outside Castle Town West",
    "West Hyrule Field Female Butterfly": "Outside Castle Town West",
    "Hyrule Field Amphitheater Poe": "Outside Castle Town West",
    "West Hyrule Field Golden Wolf": "Outside Castle Town West",
    # "" : "Outside Castle Town West Grotto Ledge",
    "West Hyrule Field Helmasaur Grotto Chest": "Outside Castle Town West Helmasaur Grotto",
    "East Castle Town Bridge Poe": "Outside Castle Town East",
    "Outside South Castle Town Tightrope Chest": "Outside Castle Town South",
    "Outside South Castle Town Fountain Chest": "Outside Castle Town South",
    "Outside South Castle Town Double Clawshot Chasm Chest": "Outside Castle Town South",
    "Wooden Statue": "Outside Castle Town South",
    "Outside South Castle Town Male Ladybug": "Outside Castle Town South",
    "Outside South Castle Town Female Ladybug": "Outside Castle Town South",
    "Outside South Castle Town Poe": "Outside Castle Town South",
    "Outside South Castle Town Golden Wolf": "Outside Castle Town South",
    # "" : "Outside Castle Town South Inside Boulder",
    "Outside South Castle Town Tektite Grotto Chest": "Outside Castle Town South Tektite Grotto",
    "Lake Hylia Bridge Vines Chest": "Lake Hylia Bridge",
    "Lake Hylia Bridge Owl Statue Chest": "Lake Hylia Bridge",
    "Lake Hylia Bridge Owl Statue Sky Character": "Lake Hylia Bridge",
    "Lake Hylia Bridge Male Mantis": "Lake Hylia Bridge",
    "Lake Hylia Bridge Female Mantis": "Lake Hylia Bridge",
    "Lake Hylia Bridge Cliff Chest": "Lake Hylia Bridge Grotto Ledge",
    "Lake Hylia Bridge Cliff Poe": "Lake Hylia Bridge Grotto Ledge",
    "Lake Hylia Bridge Bubble Grotto Chest": "Lake Hylia Bridge Bubble Grotto",
    "Lake Hylia Underwater Chest": "Lake Hylia",
    "Outside Lanayru Spring Left Statue Chest": "Lake Hylia",
    "Outside Lanayru Spring Right Statue Chest": "Lake Hylia",
    "Flight By Fowl Top Platform Reward": "Lake Hylia",
    "Flight By Fowl Second Platform Chest": "Lake Hylia",
    "Flight By Fowl Third Platform Chest": "Lake Hylia",
    "Flight By Fowl Fourth Platform Chest": "Lake Hylia",
    "Flight By Fowl Fifth Platform Chest": "Lake Hylia",
    "Auru Gift To Fyer": "Lake Hylia",
    "Flight By Fowl Ledge Poe": "Lake Hylia",
    "Isle of Riches Poe": "Lake Hylia",
    "Lake Hylia Alcove Poe": "Lake Hylia",
    "Lake Hylia Dock Poe": "Lake Hylia",
    "Lake Hylia Tower Poe": "Lake Hylia",
    "Plumm Fruit Balloon Minigame": "Lake Hylia",
    # "" : "Lake Hylia Cave Entrance",
    # "" : "Lake Hylia Lakebed Temple Entrance",
    "Lanayru Spring Underwater Left Chest": "Lake Hylia Lanayru Spring",
    "Lanayru Spring Underwater Right Chest": "Lake Hylia Lanayru Spring",
    "Lanayru Spring Back Room Left Chest": "Lake Hylia Lanayru Spring",
    "Lanayru Spring Back Room Right Chest": "Lake Hylia Lanayru Spring",
    "Lanayru Spring Back Room Lantern Chest": "Lake Hylia Lanayru Spring",
    "Lanayru Spring East Double Clawshot Chest": "Lake Hylia Lanayru Spring",
    "Lanayru Spring West Double Clawshot Chest": "Lake Hylia Lanayru Spring",
    "Lake Lantern Cave First Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Second Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Third Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Fourth Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Fifth Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Sixth Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Seventh Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Eighth Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Ninth Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Tenth Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Eleventh Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Twelfth Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Thirteenth Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave Fourteenth Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave End Lantern Chest": "Lake Hylia Long Cave",
    "Lake Lantern Cave First Poe": "Lake Hylia Long Cave",
    "Lake Lantern Cave Second Poe": "Lake Hylia Long Cave",
    "Lake Lantern Cave Final Poe": "Lake Hylia Long Cave",
    "Lake Hylia Shell Blade Grotto Chest": "Lake Hylia Shell Blade Grotto",
    "Lake Hylia Water Toadpoli Grotto Chest": "Lake Hylia Water Toadpoli Grotto",
    "Upper Zoras River Female Dragonfly": "Upper Zoras River",
    "Upper Zoras River Poe": "Upper Zoras River",
    "Iza Helping Hand": "Upper Zoras River Izas House",
    "Iza Raging Rapids Minigame": "Upper Zoras River Izas House",
    "Fishing Hole Heart Piece": "Fishing Hole",
    "Fishing Hole Bottle": "Fishing Hole",
    # "" : "Fishing Hole House",
    "Zoras Domain Chest By Mother and Child Isles": "Zoras Domain",
    "Zoras Domain Chest Behind Waterfall": "Zoras Domain",
    "Zoras Domain Male Dragonfly": "Zoras Domain",
    "Zoras Domain Mother and Child Isle Poe": "Zoras Domain",
    "Zoras Domain Waterfall Poe": "Zoras Domain",
    # "" : "Zoras Domain West Ledge",
    "Zoras Domain Light All Torches Chest": "Zoras Domain Throne Room",
    "Zoras Domain Extinguish All Torches Chest": "Zoras Domain Throne Room",
    "Zoras Domain Underwater Goron": "Zoras Domain Throne Room",
    # "" : "Outside Links House",
    "Wooden Sword Chest": "Ordon Links House",
    "Links Basement Chest": "Ordon Links House",
    "Uli Cradle Delivery": "Ordon Village",
    "Ordon Cat Rescue": "Ordon Seras Shop",
    "Sera Shop Slingshot": "Ordon Seras Shop",
    "Ordon Shield": "Ordon Shield House",
    "Ordon Sword": "Ordon Sword House",
    # "" : "Ordon Bos House Left Door",
    # "" : "Ordon Bos House Right Door",
    "Wrestling With Bo": "Ordon Bos House",
    # "" : "Ordon Ranch Entrance",
    "Herding Goats Reward": "Ordon Ranch",
    # "" : "Ordon Ranch Stable",
    "Ordon Ranch Grotto Lantern Chest": "Ordon Ranch Grotto",
    "Ordon Spring Golden Wolf": "Ordon Spring",
    "Ashei Sketch": "Snowpeak Climb Lower",
    "Snowpeak Above Freezard Grotto Poe": "Snowpeak Climb Upper",
    "Snowpeak Blizzard Poe": "Snowpeak Climb Upper",
    "Snowpeak Poe Among Trees": "Snowpeak Climb Upper",
    # "" : "Snowpeak Ice Keese Grotto",
    "Snowpeak Freezard Grotto Chest": "Snowpeak Freezard Grotto",
    "Snowpeak Cave Ice Lantern Chest": "Snowpeak Summit Upper",
    "Snowboard Racing Prize": "Snowpeak Summit Upper",
    "Snowpeak Cave Ice Poe": "Snowpeak Summit Upper",
    "Snowpeak Icy Summit Poe": "Snowpeak Summit Lower",
    # # Portal Location
    # "Snowpeak Portal": "Snowpeak Summit Upper",
    # "Zoras Domain Portal": "Zoras Domain Throne Room",
    # "Upper Zoras River Portal": "Upper Zoras River",
    # "Lake Hylia Portal": "Lake Hylia",
    # "Castle Town Portal": "Outside Castle Town West",
    # "Gerudo Desert Portal": "Gerudo Desert Cave of Ordeals Plateau",
    # "Sacred Grove Portal": "Sacred Grove Lower",
    # "North Faron Portal": "North Faron Woods",
    # "South Faron Portal": "South Faron Woods",
    # "Kakariko Village Portal": "Lower Kakariko Village",
    # "Bridge of Eldin Portal": "Eldin Field",
    # "Kakariko Gorge Portal": "Kakariko Gorge",
    # "Death Mountain Portal": "Death Mountain Volcano",
    # "Mirror Chamber Portal": "Mirror Chamber Upper",
    # "Ordon Spring Portal": "Ordon Spring",
    # Boss Defeat Locations:
    "Lakebed Temple Morpheel": "Lakebed Temple Boss Room",
    "Palace of Twilight Zant": "Palace of Twilight Boss Room",
    "Snowpeak Ruins Blizzeta": "Snowpeak Ruins Boss Room",
    "Temple of Time Armogohma": "Temple of Time Boss Room",
    "Hyrule Castle Ganondorf": "Ganondorf Castle",
    "Goron Mines Fyrus": "Goron Mines Boss Room",
    "Forest Temple Diababa": "Forest Temple Boss Room",
    "City in The Sky Argorok": "City in The Sky Boss Room",
    "Arbiters Grounds Stallord": "Arbiters Grounds Boss Room",
}
