class LunacidRegion:
    menu = "Menu"
    starting_area = "Starting Lobby"

    hollow_basin = "Hollow Basin"
    temple_path = "Path to Temple of Silence"
    temple_front = "Temple of Silence Front"
    temple_front_secret = "Blood Altar Secret Room"
    temple_sewers = "Temple of Silence Sewers"
    temple_locked = "Temple Locked Spot"
    temple_back = "Temple of Silence Back"
    temple_lower = "Temple of Silence Lower Area"
    temple_secret = "Temple of Silence Secret"
    temple_sewers_secret = "Temple of Silence Sewers Secret"

    wings_rest = "Wing's Rest"
    sheryl = "Sheryl the Crow"

    great_well_surface = "Great Well Surface"

    yosei_forest = "Yosei Forest"
    yosei_canopy_path = "Yosei Forest Canopy Path"
    yosei_lower = "Yosei Forest Lower Path"
    yosei_lower_secret = "Yosei Forest Lower Path Secret"
    yosei_tomb = "Yosei Forest Tomb Pit"
    patchouli = "Patchouli"

    forest_canopy = "Forest Canopy"

    fetid_mire = "The Fetid Mire"
    fetid_mire_lower_secrets = "The Fetid Mire Lower Secrets"
    fetid_mire_high_secrets = "The Fetid Mire Upper Secret"

    forbidden_archives_2f = "Forbidden Archives 2nd Floor"
    forbidden_archives_2f_secret = "Forbidden Archives 2nd Floor Secret"
    forbidden_archives_1f_back = "Forbidden Archives 1st Floor Back"
    forbidden_archives_1f_front = "Forbidden Archives 1st Floor Front"
    forbidden_archives_1f_front_secret = "Forbidden Archives 1st Floor Front Secret"
    forbidden_archives_3f = "Forbidden Archives 3rd Floor"
    forbidden_archives_3f_secret = "Forbidden Archives 3rd Floor Secret"
    forbidden_archives_vampire = "Forbidden Archives 3rd Floor Vampire Lobby"
    daedalus = "Daedalus"

    laetus_chasm = "Laetus Chasm Lower"
    laetus_chasm_upper = "Laetus Chasm Upper"
    laetus_chasm_secret = "Laetus Chasm Secret"

    sanguine_sea = "The Sanguine Sea"

    accursed_tomb = "Accursed Tomb"
    vampire_tomb = "Vampire Tomb"
    mausoleum = "Mausoleum"
    mausoleum_secret = "Mausoleum Secret"
    accursed_well = "Accursed Tomb Well Surface"
    accursed_tomb_platform = "Accursed Tomb Platform"
    vampire_tomb_tape_room = "Vampire Tomb's VCR Room"
    accursed_tomb_secrets = "Accursed Tomb Secrets"

    castle_le_fanu_entrance = "Castle Le Fanu Entrance"
    castle_le_fanu_cattle_prison = "Castle Le Fanu Cattle Prison"
    castle_le_fanu_cattle_prison_deep = "Castle Le Fanu Castle Prison Deeper In"
    castle_le_fanu_cattle_prison_secret = "Castle Le Fanu Cattle Prison Deeper In Secret"
    castle_le_fanu_main_halls = "Castle Le Fanu Main Halls"
    castle_le_fanu_upstairs_area = "Castle Le Fanu Upstairs Area"
    castle_le_fanu_upstairs_forbidden_entry = "Castle Le Fanu Upstairs Forbidden Entry"
    castle_le_fanu_upstairs_queens_rest = "Castle Le Fanu Upstairs Queens' Rest"
    castle_le_fanu_cattle_prison_back = "Castle Le Fanu Cattle Prison Back"
    castle_le_fanu_upstairs_tape_room = "Castle Le Fanu Upstairs Tape Room"
    castle_le_fanu_throne_path = "Castle Le Fanu Path to Throne Chamber"

    holy_battleground = "Holy Battleground"

    sealed_ballroom = "Sealed Ballroom"
    sealed_ballroom_rooms = "Sealed Ballroom Rooms"
    sealed_ballroom_cave_within_room = "Sealed Ballroom Cave Within Room"
    sealed_ballroom_secret_walls = "Sealed Ballroom Secrets"
    sealed_ballroom_room_within_secret = "Sealed Ballroom Room Within Secret"

    boiling_grotto = "Boiling Grotto"
    boiling_grotto_secret = "Boiling Grotto Secrets"
    boiling_grotto_coffin_chamber = "Boiling Grotto Coffin Chamber"
    sand_temple = "Sand Temple"
    deep_snake_pit = "Sand Temple Deep Snake Pit"
    secret_snake_pit = "Sand Temple Swinging Axe Snake Pit"

    tower_of_abyss = "Tower of Abyss"
    tower_of_abyss_5f = "Tower of Abyss 5th Floor"
    tower_of_abyss_10f = "Tower of Abyss 10th Floor"
    tower_of_abyss_15f = "Tower of Abyss 15th Floor"
    tower_of_abyss_20f = "Tower of Abyss 20th Floor"
    tower_of_abyss_25f = "Tower of Abyss 25th Floor"
    tower_of_abyss_30f = "Tower of Abyss 30th Floor"
    tower_of_abyss_35f = "Tower of Abyss 35th Floor"
    tower_of_abyss_40f = "Tower of Abyss 40th Floor"
    tower_of_abyss_45f = "Tower of Abyss 45th Floor"
    tower_of_abyss_50f = "Tower of Abyss 50th Floor"
    tower_of_abyss_finish = "Tower of Abyss Finish Room"

    throne_chamber_back_path = "Throne Chamber Back Path"
    throne_chamber = "Throne Chamber"
    throne_chamber_front_path = "Throne Chamber Front Path"

    terminus_prison_1f = "Terminus Prison 1st Floor"
    terminus_prison_1f_secrets = "Terminus Prison 1st Floor Secrets"
    terminus_prison_2f = "Terminus Prison 2nd Floor"
    terminus_prison_2f_rooms = "Terminus Prison 2nd Floor Rooms"
    terminus_prison_3f = "Terminus Prison 3rd Floor"
    terminus_prison_3f_rooms = "Terminus Prison 3rd Floor Rooms"
    terminus_prison_4f = "Terminus Prison 4th Floor"
    terminus_prison_4f_secrets = "Terminus Prison 4th Floor Secrets"
    terminus_prison_basement = "Terminus Prison Basement"

    forlorn_arena = "Forlorn Arena"
    temple_of_earth = "Temple of Earth"
    temple_of_earth_secret = "Temple of Earth Secret Areas"
    temple_of_water = "Temple of Water"
    temple_of_water_lower = "Temple of Water Lower Area"
    temple_of_water_lower_secrets = "Temple of water Lower Secret Areas"
    forlorn_path_to_sucsarius = "Forlorn Path to Sucsarius"

    labyrinth_of_ash = "Labyrinth of Ash"
    labyrinth_interior = "Labyrinth of Ash Interior"
    labyrinth_secret = "Labyrinth of Ash Interior Secret"
    holy_seat_of_gold = "Holy Seat of Gold"
    holy_seat_of_secret = "Holy Seat of Gold Secret"

    chamber_of_fate = "Chamber of Fate"

    grave_of_the_sleeper = "Grave of the Sleeper"


class LunacidEntrance:
    menu_to_start = "Finish Character Creation"

    start_lobby_to_rest = "Demi's Teleport"
    basin_to_surface = "Hollow Basin Ceiling"
    basin_to_archives_2f = "Broken Steps Door (Hollow Basin Side)"
    basin_to_temple_path = "Hollow Basin Enchanted Key Door Front"
    temple_path_to_basin = "Hollow Basin Enchanted Key Door Back"
    temple_front_to_temple_front_secret = "Blood Altar Secret Wall"
    temple_path_to_temple_front = "Temple of Silence Front Into Darkness"
    temple_front_to_temple_path = "Temple of Silence Front Into Light"
    temple_front_to_temple_back = "Temple of Silence Switch Front"
    temple_front_to_temple_sewers = "Temple of Silence Sewers Gate"
    temple_front_to_locked_spot = "Temple of Silence Locked Room"
    temple_back_to_temple_lower = "Temple of Silence Path To Rickety Bridge"
    temple_lower_to_temple_back = "Temple of Silence Lower Path To Darkness"
    temple_back_to_temple_secret = "Temple of Silence Secret Back Door"
    temple_secret_to_temple_front = "Temple of Silence Secret Front Door"
    temple_sewers_to_sewers_secret = "Temple of Silence Sewers Secret Wall"
    temple_lower_ladder = "Temple of Silence Lower Ladder"
    temple_lower_to_forest = "Rickety Bridge Door (Hollow Basin Side)"
    temple_sewers_to_mire = "Sewers Door (Hollow Basin Side)"

    rest_to_sheryl = "Sheryl's Shop Desk"
    rest_to_surface = "Wing's Rest Ceiling"
    rest_to_start = "Move to Starting Area"

    archives_2f_to_basin = "Broken Steps Door (Forbidden Archives Side)"
    archives_2f_to_2f_secret = "Archives 2F Quiet Wall"
    archives_2f_to_1f_back = "Archives 2F Elevator Down to 1F"
    archives_1f_back_to_2f = "Archives 1F Back Elevator Up to 2F"
    archives_2f_to_3f = "Archives 2F Elevator Up to 3F"
    archives_3f_to_2f = "Archives 3F Elevator Down to 2F"
    archives_3f_to_1f_front = "Archives 3F Elevator Down to 1F Front"
    archives_1f_front_to_3f = "Archives 1F Front Elevator Up to 3F"
    archives_1f_to_1f_secret = "Archives 1F Front to 1F Front Secret"
    archives_3f_to_secret = "Archives 3F Secret Wall"
    archives_3f_to_vampire = "Archives Vampiric Symbol (A) Door Front"
    archives_vampire_to_3f = "Archives Vampiric Symbol (A) Door Back"
    archives_vampire_to_chasm = "Library Exit Door (Forbidden Archives Side)"
    archives_1f_front_to_daedalus = "Daedalus' Blackened Carpet"

    chasm_to_archives_vampire = "Library Exit Door (Laetus Chasm Side)"
    chasm_to_chasm_upper = "Laetus Chasm Large Drop Down"
    chasm_upper_to_lower = "Laetus Chasm Jump"
    chasm_upper_to_surface = "Surface Door (Laetus Chasm Side)"
    chasm_upper_to_secret = "Laetus Chasm Secret Wall"

    surface_to_chasm_upper = "Surface Door (Great Well Surface Side)"
    surface_to_basin = "Surface Floor Holes"

    mire_to_temple_sewers = "Sewers Door (The Fetid Mire Side)"
    mire_to_mire_lower_secrets = "The Fetid Mire Secret Walls Lower"
    mire_to_mire_upper_secret = "The Fetid Mire Secret Wall Upper"
    mire_to_sea = "Sewers Sea Door (The Fetid Mire Side)"

    forest_to_temple_lower = "Rickety Bridge Door (Yosei Forest Side)"
    forest_to_canopy_path = "Canopy Enchanted Door Front"
    canopy_path_to_forest = "Canopy Enchanted Door Back"
    canopy_path_to_canopy = "Treetop Door (Yosei Forest Side)"
    forest_to_lower_forest = "Yosei Tree Entrance"
    lower_forest_to_forest = "Yosei Tree Exit"
    lower_forest_to_tomb = "Yosei Forest Tomb Pit Fall"
    tomb_to_lower_forest = "Yosei Forest Tomb Pit High Jump"
    lower_forest_secret = "Yosei Forest Secret Wall"
    lower_to_patchouli = "Forest Path to Best Girl"
    forest_tomb_to_accursed_tomb = "Tomb Secret Door (Yosei Forest Side)"

    canopy_to_canopy_path = "Treetop Door (Forest Canopy Path)"

    sea_to_mire = "Sewers Sea Door (Sanguine Sea Side)"
    sea_to_castle_entrance = "Castle Doors (Sanguine Sea Side)"
    sea_to_accursed_tomb = "Accursed Door (Sanguine Sea Side)"

    accursed_to_vampire = "Accursed Tomb Light Gate to Vampire"
    accursed_to_mausoleum = "Accursed Tomb Light Gate to Mausoleum"
    accursed_to_accursed_well = "Accursed Tomb High Jump Up Well"
    accursed_well_to_accursed = "Accursed Tomb Well Drop Down"
    accursed_tomb_to_sea = "Accursed Door (Accursed Tomb Side)"
    accursed_tomb_to_forest_tomb = "Tomb Secret Door (Accursed Tomb Side)"
    accursed_tomb_to_platform = "Jumping up to Tomb Platform"
    accursed_tomb_to_secrets = "Accursed Tomb Secret Walls"
    vampire_tomb_to_secret = "Vampire Tomb's Secret Wall"
    mausoleum_to_secret = "Mausoleum Secret Wall"

    castle_entrance_to_sea = "Castle Doors (Castle Le Fanu Side)"
    castle_to_cattle = "Cattle Blood Door (Front)"
    cattle_to_castle = "Castle Blood Door (Back)"
    cattle_to_deeper = "Going Deeper into Cattle Prison"
    cattle_to_secret = "Cattle Prison Deeper In Secret Wall"
    castle_entrance_to_battlefield = "Jump from Castle Le Fanu Walls"
    castle_entrance_to_main_halls = "Castle White Door (Front)"
    castle_main_halls_to_entrance = "Castle White Door (Back)"
    castle_main_halls_to_upstairs = "Castle Blue Door (Front)"
    castle_upstairs_to_main_halls = "Castle Blue Door (Back)"
    castle_upstairs_to_forbidden = "Castle Sealed Door (Front)"
    castle_forbidden_to_upstairs = "Castle Sealed Door (Back)"
    castle_forbidden_to_sealed_ballroom = "Light Accursed Door (Castle Le Fanu Side)"
    castle_upstairs_to_queen_rest = "Castle Upstairs Green Door (Front)"
    castle_upstairs_to_cattle_back = "Castle Upstairs Trek to Cattle Prison Back"
    castle_upstairs_to_tape_room = "Castle Upstairs Secret Elevator Wall"
    castle_cattle_back_to_upstairs = "Castle Prison Back Walk Upstairs"
    castle_cattle_back_to_boiling_grotto = "Burning Hot Door (Castle Le Fanu Side)"
    castle_cattle_back_to_cattle_prison = "Breach Mirage Wall in Cattle Prison"
    castle_cattle_back_to_main_halls = "Breach Mirage Wall to Main Halls"
    castle_main_halls_to_queen_path = "Castle Main Halls Green Door (Front)"
    castle_queen_path_to_main_halls = "Castle Main Halls Green Door (Back)"
    castle_queen_path_to_throne_room = "Queen's Throne Door (Castle Le Fanu Side)"

    holy_battle_to_castle_entrance = "Climb Rope Out Of Battlefield"

    sealed_ballroom_to_rooms = "Sealed Ballroom Leisure Area Doors"
    sealed_ballroom_to_forbidden_entry = "Light Accursed Door (Sealed Ballroom Side)"
    sealed_ballroom_to_secrets = "Sealed Ballroom Secret Walls"
    sealed_ballroom_rooms_to_cave = "Sealed Ballroom Leisure Area Secret Wall"
    sealed_ballroom_secret_room = "Sealed Ballroom Secret Leisure Area Door"

    boiling_grotto_to_castle_cattle_back = "Burning Hot Door (Boiling Grotto Side)"
    boiling_grotto_to_secret = "Boiling Grotto Secret Walls"
    boiling_grotto_to_coffin_room = "Boiling Grotto Sheryl Secret Wall (Front)"
    boiling_grotto_coffin_room_to_boiling_grotto = "Boiling Grotto Sheryl Secret Wall (Back)"
    boiling_grotto_to_sand_temple = "Boiling Grotto Past Dragon Face"
    boiling_grotto_coffin_room_to_tower = "Enter Coffin"

    sand_temple_to_deep_snake_pit = "Fall or Pass Over Deep Snake Pit"
    sand_temple_to_secret_snake_pit = "Fall Into Secret Snake Pit"
    sand_temple_secret_snake_pit_escape = "Escape From Secret Snake Pit"

    abyss_to_5f = "First Trial Pass"
    abyss_5f_to_10f = "Second Trial Pass"
    abyss_10f_to_15f = "Third Trial Pass"
    abyss_15f_to_20f = "Fourth Trial Pass"
    abyss_20f_to_25f = "Fifth Trial Pass"
    abyss_25f_to_30f = "Sixth Trial Pass"
    abyss_30f_to_35f = "Seventh Trial Pass"
    abyss_35f_to_40f = "Eighth Trial Pass"
    abyss_40f_to_45f = "Ninth Trial Pass"
    abyss_45f_to_50f = "Tenth Trial Pass"
    abyss_50f_to_final = "Door to Abyss Prize"

    throne_room_to_castle_queen_path = "Queen's Throne Door (Throne Chamber Side)"
    throne_from_front_to_main = "Walk Past Garrat in Throne Chamber"
    throne_from_main_to_front = "Leave Throne Chamber to Front After Victory"
    throne_from_back_to_main = "Walk Up Stairs in Throne Chamber"
    throne_from_main_to_back = "Leave Throne Chamber to Back After Victory"
    throne_room_to_prison = "Prison Main Door (Throne Chamber Side)"

    terminus_prison_1f_to_2f = "Terminus Prison Jump From 1F to 2F"
    terminus_prison_1f_to_basement = "Terminus Prison Basement Fall"
    terminus_prison_1f_to_arena = "Secondary Door (Terminus Prison Side)"
    terminus_prison_1f_to_3f = "Terminus Prison Stairs to Gate"
    terminus_prison_1f_to_secrets = "Terminus Prison 1F Secret Walls"

    terminus_prison_2f_to_1f = "Terminus Prison Drop From 2F to 1F"
    terminus_prison_2f_to_3f = "Terminus Prison Stairs From 2F to 3F"
    terminus_prison_2f_doors = "Terminus Prison 2F Doors"

    terminus_prison_3f_to_throne_room = "Prison Main Door (Terminus Prison Side)"
    terminus_prison_3f_to_2f = "Terminus Prison Drop From 3F to 2F"
    terminus_prison_3f_doors = "Terminus Prison 3F Doors"
    terminus_prison_3f_to_4f = "Terminus Prison 3F Ladder"

    terminus_prison_4f_secret_walls = "Terminus Prison 4F Secret Walls"

    terminus_prison_basement_to_ash = "Forbidden Door (Terminus Prison Side)"
    terminus_prison_basement_to_1f = "Terminus Prison Basement Elevator"

    labyrinth_of_ash_to_terminus_prison = "Forbidden Door (Labyrinth of Ash Side)"
    labyrinth_of_ash_to_interior = "Labyrinth Musical Doors"
    labyrinth_interior_to_secret = "Labyrinth Interior Secret Wall"
    labyrinth_of_ash_to_holy_seat = "Forbidden Doors Protected by Wind"
    holy_seat_to_secret = "Holy Seat of Gold Secret Wall"

    forlorn_arena_to_terminus_prison = "Secondary Door (Forlorn Arena Side)"
    forlorn_arena_to_water_temple = "Cross Bridge into Temple of Water"
    forlorn_arena_to_temple_of_earth = "Climb Stairs to Temple of Earth"
    forlorn_arena_to_path_to_sucsarius = "Break Arena Barrier"

    temple_of_earth_to_secrets = "Temple of Earth Secret Walls"

    temple_of_water_to_lower = "Drop Down to Lower Watery Areas"

    temple_of_water_lower_to_secrets = "Temple of Water Secret Walls"

    forlorn_path_to_chamber = "Sucsarian Door (Forlorn Arena Side)"

    chamber_to_forlorn_path = "Sucsarian Door (Chamber of Fate Side)"
    chamber_to_grave = "Dreamer Door (Chamber of Fate Side)"

    grave_to_chamber = "Dreamer Door (Grave of the Sleeper Side)"


starting_location_to_region = {
    "basin": LunacidRegion.hollow_basin,
    "mire": LunacidRegion.fetid_mire,
    "archives": LunacidRegion.forbidden_archives_2f,
    "forest": LunacidRegion.yosei_forest,
    "tomb": LunacidRegion.accursed_tomb,
    "castle": LunacidRegion.castle_le_fanu_entrance,
    "grotto": LunacidRegion.boiling_grotto,
    "prison": LunacidRegion.terminus_prison_3f,
    "arena": LunacidRegion.forlorn_arena,
    "ash": LunacidRegion.labyrinth_of_ash,
}

region_to_level_value = {LunacidRegion.hollow_basin: 1,
                         LunacidRegion.fetid_mire: 1,
                         LunacidRegion.forbidden_archives_2f: 2,
                         LunacidRegion.yosei_forest: 1,
                         LunacidRegion.accursed_tomb: 2,
                         LunacidRegion.castle_le_fanu_entrance: 2,
                         LunacidRegion.boiling_grotto: 2,
                         LunacidRegion.terminus_prison_3f: 2,
                         LunacidRegion.forlorn_arena: 3,
                         LunacidRegion.labyrinth_of_ash: 2
                         }

indirect_entrances = {
    LunacidEntrance.terminus_prison_1f_to_arena: LunacidRegion.terminus_prison_4f,
    LunacidEntrance.castle_forbidden_to_upstairs: LunacidRegion.castle_le_fanu_entrance,
    LunacidEntrance.castle_upstairs_to_forbidden: LunacidRegion.castle_le_fanu_entrance,
}
