from typing import Dict, List


class BaseLocation:
    wings_rest_crystal_shard = "WR: Starting Weapon Bench"
    wings_rest_ocean_elixir = "WR: Rafters"
    wings_rest_clives_gift = "WR: Clive's Gift"
    wings_rest_demi_gift = "WR: Demi's Introduction Gift"
    wings_rest_demi_orb = "WR: Demi's Victory Gift"

    hollow_basin_starting_sword = "HB: Encouraging Statue"
    hollow_basin_right_water_right = "HB: Rightmost Water Room (Right)"
    hollow_basin_right_water_left = "HB: Rightmost Water Room (Left)"
    hollow_basin_left_water = "HB: Leftmost Water Room"
    hollow_basin_demi_chest = "HB: Chest Near Demi"
    hollow_basin_enchanted_door = "HB: Near Enchanted Door"
    hollow_basin_dark_item = "HB: Dark Tunnel After Enchanted Door"

    temple_fountain = "HB: Temple Fountain"
    temple_ritual_table = "HB: Temple Ritual Table"
    temple_altar_chest = "HB: Temple Altar Chest"
    temple_pillar_left = "HB: Temple Hidden Room Behind Pillar (Left)"
    temple_pillar_right = "HB: Temple Hidden Room Behind Pillar (Right)"
    temple_ritual_ring = "HB: Temple Ritual Table After Bridge"
    temple_small_pillar = "HB: Temple Small Pillar Top"
    temple_pillar_room_left = "HB: Temple Pillar Room Left"
    temple_pillar_room_back_left = "HB: Temple Pillar Room Back Left"
    temple_pillar_room_back_right = "HB: Temple Pillar Room Back Right"
    temple_pillar_room_hidden_room = "HB: Temple Pillar Room Hidden Room"
    temple_hidden_room_in_sewer = "HB: Temple Hidden Room In Sewer"
    temple_table_in_sewer = "HB: Temple Table in Sewer"
    temple_sewer_puzzle = "HB: Temple Sewer Puzzle"
    temple_blood_altar = "HB: Temple Blood Altar"
    temple_path_to_forest = "HB: Alcove on Path to Yosei Forest"

    mire_room_left_foyer = "FM: Room Left of Foyer"
    mire_hidden_slime_chest = "FM: Hidden Slimey Chest Near Entrance"
    mire_upper_overlook_left = "FM: Hidden Upper Overlook (Left)"
    mire_upper_overlook_right = "FM: Hidden Upper Overlook (Right)"
    mire_bonenard_trash = "FM: Bonenard's Trash"
    mire_rubble_bridge = "FM: Rubble Near Overlook Bridge"
    mire_skeleton_chest = "FM: Slime Skeleton Chest"
    mire_jellisha_trash = "FM: Jellisha's Trash"
    mire_jellisha_reward = "FM: Jellisha's Quest Reward"
    mire_hidden_chest_near_underworks = "FM: Hidden Chest Near Underworks"
    mire_rubble_near_illusory_wall = "FM: Rubble Near Illusory Wall"
    mire_underwater_pipe = "FM: Underwater Pipe"
    mire_underworks_waterfall = "FM: Underworks Waterfall"
    mire_underworks_skeleton = "FM: Underworks Skeleton"
    mire_path_to_sea_left = "FM: Path to Sanguine Sea (Left)"
    mire_path_to_sea_right = "FM: Path to Sanguine Sea (Right)"

    sea_pillar = "SS: Pillar In Front of Castle Le Fanu"
    sea_underblood = "SS: Underblood Near Castle Le Fanu"
    sea_fairy_circle = "SS: Fairy Circle"
    sea_kill_jotunn = "SS: Killing the Jotunn"

    catacombs_coffin_stairs = "AT: Catacombs Coffins Near Stairs"
    catacombs_coffin_blue_light = "AT: Catacombs Coffins With Blue Light"
    corrupted_room = "AT: Corrupted Room"
    catacombs_coffin_gate = "AT: Gated Tomb Near Corrupted Room"
    catacombs_hidden_room = "AT: Catacombs Hidden Room"
    catacombs_deep_coffin_storage = "AT: Deep Coffin Storage"
    catacombs_restore_vampire = "AT: Red Skeleton"

    mausoleum_hidden_chest = "AT: Mausoleum Hidden Chest"
    mausoleum_upper_table = "AT: Mausoleum Upper Alcove Table"
    mausoleum_maze_intro = "AT: Mausoleum Maze (Early)"
    mausoleum_maze_mid = "AT: Mausoleum Maze (Middle)"
    mausoleum_center_right = "AT: Mausoleum Central Room (Right)"
    mausoleum_center_left = "AT: Mausoleum Central Room (Left)"
    mausoleum_center_back = "AT: Mausoleum Central Room (Back)"
    mausoleum_center_left_path = "AT: Mausoleum Central Room (Left Path)"
    mausoleum_center_right_path = "AT: Mausoleum Central Room (Right Path)"
    mausoleum_kill_death = "AT: Kill Death"

    tomb_tomb_with_switch = "AT: Tomb With Switch"
    tomb_tomb_with_corpse = "AT: Tomb With Sitting Corpse"
    tomb_demi_chest = "AT: Demi Chest"
    tomb_near_light_switch = "AT: Near Light Switch"
    tomb_hidden_room = "AT: Hidden Room in Tomb"
    tomb_hidden_chest = "AT: Hidden Chest in Tomb"

    yosei_barrels = "YF: Barrel Group"
    yosei_blood_pool = "YF: Blood Pool"
    yosei_branch_in_tree = "YF: Branches Within Tree"
    yosei_chest_near_tree = "YF: Chest Near Tree"
    yosei_blood_plant_insides = "YF: Blood Plant's Insides"
    yosei_hanging_in_trees = "YF: Hanging In The Trees"
    yosei_hidden_chest = "YF: Hidden Chest"
    yosei_room_defended_by_blood_plant = "YF: Room Defended by Blood Plant"
    yosei_patchouli_key = "YF: Patchouli's Canopy Offer"
    yosei_patchouli_quest = "YF: Patchouli's Reward"

    canopy_branch_edge = "FC: Branch Lower Edge"
    branch_cave = "FC: Branch Cave"
    canopy_chest = "FC: Chest"
    canopy_wooden_statue = "FC: Wooden Statue (Josiah)"
    canopy_wooden_sitting = "FC: Wooden Statue (Sitting)"

    archives_back_room_past_bridge = "FbA: Back Room Past Bridge"
    archives_strange_corpse = "FbA: Strange Corpse"
    archives_short_wall_near_trees = "FbA: Short Wall Near Trees"
    archives_against_wall_near_trees = "FbA: Against Wall Near Trees"
    archives_snail_lectern_near = "FbA: Snail Lectern (Near)"
    archives_snail_lectern_far = "FbA: Snail Lectern (Far)"
    archives_rug_on_balcony = "FbA: Rug on Balcony"
    archives_rooftop = "FbA: Rooftops"
    archives_hidden_room_upper = "FbA: Hidden Room Upper Floor"
    archives_hidden_room_lower = "FbA: Hidden Room Lower Floor"
    archives_near_twisty_tree = "FbA: Near Twisty Tree"
    archives_uwu = "FbA: uwu"
    archives_daedalus_one = "FbA: Daedalus Knowledge (First)"
    archives_daedalus_two = "FbA: Daedalus Knowledge (Second)"
    archives_daedalus_third = "FbA: Daedalus Knowledge (Third)"
    archives_corner_near_daedalus = "FbA: Corner Near Daedalus"

    castle_outside_corner = "CLF: Outside Corner"
    castle_cell_south = "CLF: Cattle Cell (South)"
    castle_cell_west = "CLF: Cattle Cell (West)"
    castle_cell_center = "CLF: Cattle Cell (Center)"
    castle_cell_north = "CLF: Cattle Cell (North)"
    castle_hidden_cell = "CLF: Hidden Cattle Cell"

    castle_hallway_rubble_room = "CLF: Hallway Rubble Room"
    castle_hallway_dining_room = "CLF: Hallway Dining Room"
    castle_garrat_resting_room_left = "CLF: Garrat Resting Room (Fountain)"
    castle_garrat_resting_room_back = "CLF: Garrat Resting Room (Wall)"
    castle_hallway_deadend_before_door = "CLF: Hallway Dead End Before Blue Doors"
    castle_upper_floor_coffin_small = "CLF: Upper Floor Coffin Room (Small Room)"
    castle_upper_floor_coffin_large = "CLF: Upper Floor Coffin Room (Large Room)"
    castle_upper_floor_coffin_double = "CLF: Upper Floor Coffin Room (Double)"
    castle_upper_floor_coffin_hallway = "CLF:  Upper Floor Coffin Room (Hallway)"

    ballroom_small_room_lounge = "SB: Entry Small Room Lounge"
    ballroom_entry_hidden_couch_top = "SB: Entry Hidden Couch Top"
    ballroom_entry_hidden_couch_bottom = "SB: Entry Hidden Couch Bottom"
    ballroom_entry_hidden_cave_in_lounge = "SB: Entry Hidden Cave in a Lounge"
    ballroom_entry_long_table = "SB: Entry Lounge Long Table"
    ballroom_side_hidden_cave = "SB: Side Hidden Cave"
    ballroom_side_chest_near_switch = "SB: Side Chest Near Switch"
    ballroom_side_painting = "SB: Side Painting Viewing Room"
    ballroom_side_hidden_casket_room = "SB: Side Hidden Casket Room"
    ballroom_side_xp_drain = "SB: Side XP Drain Party Room"

    chasm_hidden_chest = "LC: Hidden Room"
    chasm_invisible_cliffside = "LC: Invisible Path to Cliffside"

    surface_demi_gift = "GWS: Demi's Gift"

    throne_book = "TC: Crilall's Book Repository"

    battlefield_book = "AHB: Sngula Umbra's Remains"

    grotto_slab_of_bridge = "BG: Slab of a Broken Bridge"
    grotto_hidden_chest = "BG: Hidden Chest"
    grotto_corpse_beneath_entrance = "BG: Corpse Beneath Entrance"
    grotto_triple_secret_chest = "BG: Triple Hidden Chest"
    grotto_rocks_near_lava_switch = "BG: Lava Overseeing Dragon Switch"
    grotto_through_switch_tunnel = "BG: Through Dragon Switch Tunnel"

    sand_room_buried_in_sand = "ST: Room Buried in Sand"
    sand_top_right_sarcophagus = "ST: Top Right Sarcophagus"
    sand_second_floor_snake = "ST: Second Floor Snake Room"
    sand_basement_snake_pit = "ST: Basement Snake Pit"
    sand_hidden_sarcophagus = "ST: Hidden Sarcophagus"
    sand_second_floor_dead_end = "ST: Second Floor Dead End"
    sand_lunacid_sandwich = "ST: Lunacid Sandwich"
    sand_chest_near_switch = "ST: Chest Near Switch"
    sand_chest_overlooking_crypt = "ST: Chest Overlooking Crypt"
    sand_switch_maze = "ST: Floor Switch Maze"
    sand_basement_rubble = "ST: Basement Stone Rubble"
    sand_triple_sarcophagus = "ST: Triple Sarcophagus"

    abyss_floor_5 = "TA: Floor 5 Chest"
    abyss_heal_5 = "TA: Floor 5 Item 1"
    abyss_crystal_5 = "TA: Floor 5 Item 2"
    abyss_floor_10 = "TA: Floor 10 Chest"
    abyss_heal_10 = "TA: Floor 10 Item 1"
    abyss_crystal_10 = "TA: Floor 10 Item 2"
    abyss_floor_15 = "TA: Floor 15 Chest"
    abyss_heal_15 = "TA: Floor 15 Item 1"
    abyss_crystal_15 = "TA: Floor 15 Item 2"
    abyss_floor_20 = "TA: Floor 20 Chest"
    abyss_heal_20 = "TA: Floor 20 Item 1"
    abyss_crystal_20 = "TA: Floor 20 Item 2"
    abyss_floor_25 = "TA: Floor 25 Chest"
    abyss_heal_25 = "TA: Floor 25 Item 1"
    abyss_crystal_25 = "TA: Floor 25 Item 2"
    abyss_floor_30 = "TA: Floor 30 Chest"
    abyss_heal_30 = "TA: Floor 30 Item 1"
    abyss_crystal_30 = "TA: Floor 30 Item 2"
    abyss_floor_35 = "TA: Floor 35 Chest"
    abyss_heal_35 = "TA: Floor 35 Item 1"
    abyss_crystal_35 = "TA: Floor 35 Item 2"
    abyss_floor_40 = "TA: Floor 40 Chest"
    abyss_heal_40 = "TA: Floor 40 Item 1"
    abyss_crystal_40 = "TA: Floor 40 Item 2"
    abyss_floor_45 = "TA: Floor 45 Chest"
    abyss_heal_45 = "TA: Floor 45 Item 1"
    abyss_crystal_45 = "TA: Floor 45 Item 2"
    abyss_floor_50 = "TA: Floor 50 Chest"
    abyss_heal_50 = "TA: Floor 50 Item 1"
    abyss_crystal_50 = "TA: Floor 50 Item 2"
    abyss_prize = "TA: Prize Beneath Tree"

    prison_f3_locked_left = "TP: Third Floor Locked Cell Left"
    prison_f3_locked_right = "TP: Third Floor Locked Cell Right"
    prison_f3_locked_south = "TP: Third Floor Locked Cell South"
    prison_f3_bottomless_pit = "TP: Almost Bottomless Pit"
    prison_f2_broken_cell = "TP: Second Floor Broken Cell"
    prison_f2_jailer_table = "TP: Second Floor Jailer's Table"
    prison_f1_hidden_cell = "TP: First Floor Hidden Cell"
    prison_f1_hidden_debris_room = "TP: First Floor Hidden Debris Room"
    prison_f1_remains = "TP: First Floor Remains"
    prison_b2_guarded_corner_one = "TP: Green Asylum Guarded Alcove (Left)"
    prison_b2_guarded_corner_two = "TP: Green Asylum Guarded Alcove (Right)"
    prison_b2_deep_alcove = "TP: Green Asylum Long Alcove"
    prison_b2_bone_pit = "TP: Green Asylum Bone Pit"
    prison_b2_egg_resting_place = "TP: Egg's Resting Place"
    prison_f4_hanging = "TP: Fourth Floor Cell Hanging Remains"
    prison_f4_maledictus_secret = "TP: Fourth Floor Maledictus Secret"
    prison_f4_hidden_beds = "TP: Fourth Floor Hidden Jailer Sleeping Spot"
    prison_f4_jailer_break_room = "TP: Fourth Floor Jailer Break Room"
    prison_f4_monk_room_one = "TP: Etna's Resting Place Item 1"
    prison_f4_monk_room_two = "TP: Etna's Resting Place Item 2"
    prison_f4_monk_room_three = "TP: Etna's Resting Place Item 3"
    prison_f4_collapsed_tunnel = "TP: Fourth Floor Collapsed Tunnel"

    arena_broken_sword = "FlA: Corpse Waiting For A Full Moon"
    arena_rock_parkour = "FlA: Entry Rock Parkour"
    arena_earth_hidden_plant_haven = "FlA: Temple of Earth Hidden Plant Haven"
    arena_earth_hidden_room = "FlA: Temple of Earth Hidden Room"
    arena_earth_earthen_temple = "FlA: Temple of Earth Fractured Chest"
    arena_earth_chest_near_switch = "FlA: Temple of Earth Chest Near Switch"
    arena_water_room_near_water = "FlA: Temple of Water Room Near Water"
    arena_water_dead_end_near_water = "FlA: Temple of Water Corner Near Water"
    arena_water_collapsed_end_near_balcony = "FlA: Temple of Water Collapsed End Near Balcony"
    arena_water_hidden_basement_left = "FlA: Temple of Water Hidden Basement (Left)"
    arena_water_hidden_basement_right = "FlA: Temple of Water Hidden Basement (Right)"
    arena_water_hidden_laser_room = "FlA: Temple of Water Hidden Laser Room"
    arena_water_hidden_alcove_before = "FlA: Temple of Water Hidden Alcove Before Stairs"
    arena_water_hidden_alcove_left = "FlA: Temple of Water Hidden Alcove (Left)"
    arena_water_hidden_alcove_right = "FlA: Temple of Water Hidden Alcove (Right)"
    arena_water_hidden_alcove_before_switch = "FlA: Temple of Water Hidden Alcove Before Switch"
    arena_water_underwater_temple = "FlA: Temple of Water Fractured Chest"
    arena_water_chest_near_switch = "FlA: Temple of Water Chest Near Switch"

    ash_entry_coffin = "LA: Entry Coffin"
    ash_giant_remains = "LA: Giant Remains"
    ash_cetea_statue = "LA: Behind Statue"
    ash_rocks_near_switch = "LA: Rocks Near Switch"
    ash_forbidden_light_chest = "LA: Forbidden Light Chest"
    ash_hidden_chest = "LA: Hidden Light Stash"
    ash_path_maze = "LA: NNSNSSNSNN Lost Maze"

    fate_lucid_blade = "CF: Calamis' Weapon of Choice"

    abyss_locations = [abyss_prize, abyss_floor_50, abyss_floor_45, abyss_floor_40, abyss_floor_35, abyss_floor_30, abyss_floor_25, abyss_floor_20,
                       abyss_floor_15, abyss_floor_10, abyss_floor_5]
    coin_locations = [sea_kill_jotunn, mausoleum_kill_death, temple_blood_altar]
    daedalus_locations = [archives_daedalus_third, archives_daedalus_one, archives_daedalus_two]


class ShopLocation:
    buy_enchanted_key = "Buy Enchanted Key"
    buy_rapier = "Buy Rapier"
    buy_steel_needle = "Buy Steel Needle"
    buy_crossbow = "Buy Crossbow"
    buy_oil_lantern = "Buy Oil Lantern"
    buy_ocean_elixir_patchouli = "Buy Ocean Elixir (Patchouli)"
    buy_privateer_musket = "Buy Privateer Musket"
    buy_jotunn_slayer = "Buy Jotunn Slayer"

    shop_locations = [buy_rapier, buy_crossbow, buy_jotunn_slayer, buy_ocean_elixir_patchouli,
                      buy_oil_lantern, buy_enchanted_key, buy_steel_needle, buy_privateer_musket]


unique_drop_locations = []
other_drop_locations = []


def unique_drop(name: str) -> str:
    if name not in unique_drop_locations:
        unique_drop_locations.append(name)
    return name


def other_drop(name: str) -> str:
    if name not in other_drop_locations:
        other_drop_locations.append(name)
    return name


class DropLocation:
    #  Hollow Basin
    snail = unique_drop("Snail: Summon Snail Drop")
    snail_2c = other_drop("Snail: Small Silver Drop")
    snail_10c = other_drop("Snail: Large Silver Drop")
    snail_ocean = other_drop("Snail: Ocean Bone Shard Drop")
    milk_snail = unique_drop("Milk Snail: Ice Sickle Drop")
    milk_5c = other_drop("Milk Snail: Small Silver Drop")
    milk_10c = other_drop("Milk Snail: Large Silver Drop")
    milk_ocean = other_drop("Milk Snail: Ocean Bone Shard Drop")
    shulker_obsidian = other_drop("Shulker: Obsidian Drop")
    shulker_onyx = other_drop("Shulker: Onyx Drop")
    mummy_mana_vial = other_drop("Mummy: Mana Vial Drop")
    mummy_onyx = other_drop("Mummy: Onyx Drop")
    mummy_2c = other_drop("Mummy: Small Silver Drop")
    mummy_10c = other_drop("Mummy: Large Silver Drop")
    mummy_knight = unique_drop("Mummy Knight: Rusted Sword Drop")
    mummy_knight_onyx = other_drop("Mummy Knight: Onyx Drop")
    mummy_knight_10c = other_drop("Mummy Knight: Large Silver Drop")
    mummy_knight_5c = other_drop("Mummy Knight: Small Silver Drop")
    #  Forbidden Archives
    necronomicon_fire_opal = other_drop("Necronomicon: Fire Opal Drop")
    necronomicon_5c = other_drop("Necronomicon: Medium Silver Drop")
    necronomicon_10c = other_drop("Necronomicon: Large Silver Drop")
    necronomicon_mana_vial = other_drop("Necronomicon: Mana Vial Drop")
    chimera_drop = unique_drop("Chimera: Quick Stride Drop")
    chimera_light_urn = other_drop("Chimera: Light Urn Drop")
    chimera_holy_water = other_drop("Chimera: Holy Water Drop")
    enlightened_mana_vial = other_drop("Enlightened One: Mana Vial Drop")
    enlightened_ocean_bone_shell = other_drop("Enlightened One: Ocean Bone Shell Drop")
    #  Fetid Mire
    slime_skeleton = other_drop("Slime Skeleton: Ashes Drop")
    skeleton_weapon = unique_drop("Skeleton: Skeleton Axe Drop")
    skeleton_spell = unique_drop("Skeleton: Dark Skull Drop")
    skeleton_10c = other_drop("Skeleton: Large Silver Drop")
    skeleton_2c = other_drop("Skeleton: Small Silver Drop")
    skeleton_mana_vial = other_drop("Skeleton: Mana Vial")
    skeleton_onyx = other_drop("Skeleton: Onyx Drop")
    skeleton_bones = other_drop("Skeleton: Bones Drop")
    rat_king_10c = other_drop("Rat King: Large Silver Drop")
    rat_king_lotus_seed = other_drop("Rat King: Lotus Seed Pod Drop")
    rat = other_drop("Rat: Small Silver Drop")
    #  Yosei Forest + Forest Canopy
    kodama_drop = unique_drop("Kodama: Summon Kodama Drop")
    kodama_2c = other_drop("Kodama: Small Silver Drop")
    kodama_10c = other_drop("Kodama: Medium Silver Drop")
    kodama_opal = other_drop("Kodama: Opal Drop")
    yakul_10c = other_drop("Yakul: Medium Silver Drop")
    yakul_fire_opal = other_drop("Yakul: Fire Opal Drop")
    yakul_opal = other_drop("Yakul: Opal Drop")
    yakul_health_vial = other_drop("Yakul: Health Vial Drop")
    venus_10c = other_drop("Venus: Medium Silver Drop")
    venus_yellow_morel = other_drop("Venus: Yellow Morel Drop")
    venus_dest_angel = other_drop("Venus: Destroying Angel Mushroom Drop")
    neptune_10c = other_drop("Neptune: Medium Silver Drop")
    neptune_yellow_morel = other_drop("Neptune: Yellow Morel Drop")
    neptune_dest_angel = other_drop("Neptune: Destroying Angel Mushroom Drop")
    unilateralis_10c = other_drop("Unilateralis: Medium Silver Drop")
    unilateralis_yellow_morel = other_drop("Unilateralis: Yellow Morel Drop")
    unilateralis_dest_angel = other_drop("Unilateralis: Destroying Angel Mushroom Drop")
    #  Sanguine Sea
    hemalith_health_vial = other_drop("Hemalith: Health Vial Drop")
    hemalith_shrimp = other_drop("Hemalith: Pink Shrimp Drop")
    hemallith_bloodweed = other_drop("Hemalith: Bloodweed Drop")
    sea_demon = unique_drop("Abyssal Demon: Ocean Elixir Drop")
    #  Accursed Tomb
    mi_go_ocean_bone_shell = other_drop("Mi-Go: Ocean Bone Shell Drop")
    mi_go_10c = other_drop("Mi-Go: Medium Silver Drop")
    mi_go_snowflake_obsidian = other_drop("Mi-Go: Snowflake Obsidian Drop")
    mare_10c = other_drop("Mare: Medium Silver Drop")
    mare_obsidian = other_drop("Mare: Obsidian Drop")
    mare_onyx = other_drop("Mare: Onyx Drop")
    painting_fire_opal = other_drop("Cursed Painting: Fire Opal Drop")
    painting_10c = other_drop("Cursed Painting: Medium Silver Drop")
    painting_mana_vial = other_drop("Cursed Painting: Mana Vial Drop")
    painting_20c = other_drop("Cursed Painting: Large Silver Drop")
    #  Castle Le Fanu
    phantom = unique_drop("Phantom: Cursed Blade Drop")
    phantom_10c = other_drop("Phantom: Medium Silver Drop")
    phantom_holy_water = other_drop("Phantom: Holy Water Drop")
    phantom_moon_vial = other_drop("Phantom: Moonlight Vial Drop")
    phantom_ectoplasm = other_drop("Phantom: Ectoplasm Drop")
    vampire_drop = unique_drop("Vampire Page: Lyrian Longsword Drop")
    vampire_5c = other_drop("Vampire: Large Silver Drop")
    vampire_vampiric_ashes = other_drop("Vampire: Vampiric Ashes Drop")
    vampire_bandage = other_drop("Vampire: Cloth Bandage Drop")
    vampire_page_ashes = other_drop("Vampire Page: Vampiric Ashes Drop")
    vampire_page_20c = other_drop("Vampire Page: Large Silver Drop")
    malformed_vampiric_ashes = other_drop("Malformed: Vampiric Ashes Drop")
    great_bat_health_vial = other_drop("Great Bat: Health Vial Drop")
    great_bat_obsidian = other_drop("Great Bat: Obsidian Drop")
    great_bat_10c = other_drop("Great Bat: Large Silver Drop")
    poltergeist_10c = other_drop("Poltergeist: Large Silver Drop")
    poltergeist_ectoplasm = other_drop("Poltergeist: Ectoplasm Drop")
    #  Sealed Ballroom
    horse_drop = unique_drop("Malformed Horse: Brittle Arming Sword Drop")
    horse_10c = other_drop("Malformed Horse: Large Silver Drop")
    horse_mana_vial = other_drop("Malformed Horse: Mana Vial Drop")
    hallowed_husk_10c = other_drop("Hallowed Husk: Large Silver Drop")
    hallowed_husk_bones = other_drop("Hallowed Husk: Bones Drop")
    hallowed_husk_bandage = other_drop("Hallowed Husk: Cloth Bandage Drop")
    hallowed_husk_light_urn = other_drop("Hallowed Husk: Light Urn Drop")
    hallowed_husk_goldeness = other_drop("Hallowed Husk: Fool's Gold Drop")
    hallowed_husk_holy_water = other_drop("Hallowed Husk: Holy Water Drop")
    #  Boiling Grotto
    ikkurilb_root = other_drop("Ikurr'ilb: Ikurr'ilb Root Drop")
    ikkurilb_10c = other_drop("Ikurr'ilb: Medium Silver Drop")
    ikkurilb_snowflake_obsidian = other_drop("Ikurr'ilb: Snowflake Obsidian Drop")
    mimic_moon_vial = other_drop("Mimic: Moonlight Vial Drop")
    mimic_obsidian = other_drop("Mimic: Obsidian Drop")
    mimic_fools_gold = other_drop("Mimic: Fool's Gold Drop")
    obsidian_skeleton_drop_1 = unique_drop("Obsidian Skeleton: Obsidian Cursebrand Drop")
    obsidian_skeleton_drop_2 = unique_drop("Obsidian Skeleton: Obsidian Poisonguard Drop")
    obsidian_skeleton_10c = other_drop("Obsidian Skeleton: Large Silver Drop")
    obsidian_skeleton_bones = other_drop("Obsidian Skeleton: Bones Drop")
    obsidian_skeleton_mana_vial = other_drop("Obsidian Skeleton: Mana Vial Drop")
    obsidian_skeleton_obsidian = other_drop("Obsidian Skeleton: Obsidian Drop")
    anpu_drop_1 = unique_drop("Anpu: Golden Khopesh Drop")
    anpu_drop_2 = unique_drop("Anpu: Golden Sickle Drop")
    anpu_10c = other_drop("Anpu: Large Silver Drop")
    anpu_fire_opal = other_drop("Anpu: Fire Opal Drop")
    serpent_antidote = other_drop("Serpent: Antidote Drop")
    serpent_5c = other_drop("Serpent: Small Silver Drop")
    embalmed_bandage = other_drop("Embalmed: Cloth Bandage Drop")
    embalmed_ashes = other_drop("Embalmed: Ashes Drop")
    embalmed_bones = other_drop("Embalmed: Bones Drop")
    #  Terminus Prison
    jailor_drop = unique_drop("Jailor: Jailor's Candle Drop")
    jailor_10c = other_drop("Jailor: Large Silver Drop")
    jailor_candle = other_drop("Jailor: Spectral Candle Drop")
    jailor_bandage = other_drop("Jailor: Cloth Bandage Drop")
    jailor_health_vial = other_drop("Jailor: Health Vial Drop")
    jailor_angel = other_drop("Jailor: Angel's Feather Drop")
    lunam_ectoplasm = other_drop("Cerritulus Lunam: Ectoplasm Drop")
    lunam_10c = other_drop("Cerritulus Lunam: Medium Silver Drop")
    lunam_snowflake_obsidian = other_drop("Cerritulus Lunam: Snowflake Obsidian Drop")
    giant_dark_urn = other_drop("Giant Skeleton: Dark Urn Drop")
    giant_bones = other_drop("Giant Skeleton: Bones Drop")
    giant_mana_vial = other_drop("Giant Skeleton: Mana Vial Drop")
    giant_onyx = other_drop("Giant Skeleton: Onyx Drop")
    giant_spell = unique_drop("Giant Skeleton: Dark Skull Drop")
    lupine_spell = unique_drop("Lupine Skeleton: Dark Skull Drop")
    lupine_10c = other_drop("Lupine Skeleton: Medium Silver Drop")
    lupine_bones = other_drop("Lupine Skeleton: Bones Drop")
    lupine_onyx = other_drop("Lupine Skeleton: Onyx Drop")
    infested_antidote = other_drop("Infested Corpse: Antidote Drop")
    infested_bones = other_drop("Infested Corpse: Bones")
    #  Forlorn Arena
    sucsarian_drop_1 = unique_drop("Sucsarian: Sucsarian Dagger Drop")
    sucsarian_drop_2 = unique_drop("Sucsarian: Sucsarian Spear Drop")
    sucsarian_10c = other_drop("Sucsarian: Large Silver Drop")
    sucsarian_obsidian = other_drop("Sucsarian: Obsidian Drop")
    sucsarian_snowflake_obsidian = other_drop("Sucsarian: Snowflake Obsidian Drop")
    sucsarian_throwing_knife = other_drop("Sucsarian: Throwing Knife Drop")
    vesta_fairy_moss = other_drop("Vesta: Fairy Moss Drop")
    vesta_yellow_morel = other_drop("Vesta: Yellow Morel Drop")
    vesta_dest_angel = other_drop("Vesta: Destroying Angel Mushroom Drop")
    ceres_fairy_moss = other_drop("Ceres: Fairy Moss Drop")
    ceres_yellow_morel = other_drop("Ceres: Yellow Morel Drop")
    ceres_dest_angel = other_drop("Ceres: Destroying Angel Mushroom Drop")
    gloom_fairy_moss = other_drop("Gloom Wood: Fairy Moss Drop")
    gloom_health_vial = other_drop("Gloom Wood: Health Vial Drop")
    gloom_dest_angel = other_drop("Gloom Wood: Mana Vial Drop")
    #  Labyrinth of Ash
    cetea_drop = unique_drop("Cetea: Tornado Drop")
    cetea_10c = other_drop("Cetea: Medium Silver Drop")
    cetea_ocean_bone_shell = other_drop("Cetea: Ocean Bone Shell Drop")
    sanguis_book = unique_drop("Sanguis Umbra: Black Book Drop")

    starter_drops = [snail, snail_2c, snail_10c, snail_ocean, milk_snail, milk_5c, milk_10c,
    milk_ocean, shulker_obsidian, shulker_onyx, mummy_mana_vial, mummy_onyx, mummy_2c, mummy_10c, mummy_knight,
    mummy_knight_onyx, mummy_knight_10c, mummy_knight_5c]


all_drops = unique_drop_locations + other_drop_locations
all_drops_by_enemy: Dict[str, List[str]] = {}

for location in all_drops:
    location_split = location.split(": ")
    enemy = str(location_split[0])
    if enemy == "Sucsarian":
        if "Sucsarian Spear" in location:
            enemy += "(Sucsarian)"
        else:
            enemy += " (Dagger)"
    drop = str(location_split[1]).replace(" Drop", "")
    if enemy not in all_drops_by_enemy:
        all_drops_by_enemy[enemy] = [drop]
        continue
    all_drops_by_enemy[enemy].append(drop)


class Quench:
    brittle_arming_sword = "Quench Brittle Arming Sword"
    broken_hilt = "Quench Broken Hilt"
    broken_lance = "Quench Broken Lance"
    crossbow = "Quench Crossbow"
    elfen_sword = "Quench Elfen Sword"
    iron_claw = "Quench Iron Claw"
    iron_club = "Quench Iron Club"
    lyrian_longsword = "Quench Lyrian Longsword"
    obsidian_cursebrand = "Quench Obsidian Cursebrand"
    obsidian_poisonguard = "Quench Obsidian Poisonguard"
    obsidian_seal = "Quench Obsidian Seal"
    rapier = "Quench Rapier"
    replica_sword = "Quench Replica Sword"
    rusted_sword = "Quench Rusted Sword"
    shadow_blade = "Quench Shadow Blade"
    shining_blade = "Quench Shining Blade"
    steel_claw = "Quench Steel Claw"
    stone_club = "Quench Stone Club"
    torch = "Quench Torch"
    scythe = "Quench Death Scythe"

    all_quenches = [brittle_arming_sword, broken_hilt, broken_lance, crossbow, elfen_sword, iron_club, iron_claw, lyrian_longsword, obsidian_seal, obsidian_cursebrand,
                    obsidian_poisonguard, rapier, replica_sword, rusted_sword, shadow_blade, shining_blade, steel_claw, stone_club, torch, scythe]


class AlchemyLocation:
    explosives = "Alchemize Explosives"
    health = "Alchemize Healing Remedy"
    mana = "Alchemize Mana Remedy"
    warp = "Alchemize Unstable Stone"
    antidote = "Alchemize Antivenom"
    knife = "Alchemize Sharp Object"
    poison_knife = "Alchemize Venomous Object"
    moonlight = "Alchemize Concentrated Lunacy"
    fairy_moss = "Alchemize Nature"
    spectral = "Alchemize Hostility Barrier"
    wisp = "Alchemize Simple Life"
    limbo = "Alchemize Golden Sin of Abdul"
    banner = "Alchemize Cleromancy Tool"
    holy = "Alchemize Water of Life"
    poison_urn = "Alchemize Concentrated Poison"
    staff_of_osiris = "Alchemize Defense Construct"

    all_alchemy_locations = [explosives, health, mana, warp, antidote, knife, poison_knife, moonlight, fairy_moss, spectral, wisp,
                             limbo, banner, holy, poison_urn, staff_of_osiris]


class SpookyLocation:
    rest = "Demi's Spooky Treats"
    jellisha = "Jellisha's Jelly Treats"
    patchouli = "Patchouli's Poisoned Treats"
    le_fanu = "Crilall's Bloody Treats"
    daedalus = "Daedalus' Blackened Treats"
    lobos = "Lobos' Late Treats"
    lava = "Shery's Delectable Treats"
    spooky_spell = "Demi's Reward for All Soul Candies"
    headless_horseman = "Headless Horseman: Cavalry Saber Drop"

    candy_locations = [rest, jellisha, patchouli, le_fanu, daedalus, lobos, lava, spooky_spell]


class CrimpusLocation:
    wings_rest_present = "Christmas Present"
    yosei_patchouli_eggnog = "Patchouli's Yuletide Offering"

    christmas_locations = [yosei_patchouli_eggnog, wings_rest_present]


class LevelLocation:
    level_1 = "Reach Level 1"
    level_2 = "Reach Level 2"
    level_3 = "Reach Level 3"
    level_4 = "Reach Level 4"
    level_5 = "Reach Level 5"
    level_6 = "Reach Level 6"
    level_7 = "Reach Level 7"
    level_8 = "Reach Level 8"
    level_9 = "Reach Level 9"
    level_10 = "Reach Level 10"
    level_11 = "Reach Level 11"
    level_12 = "Reach Level 12"
    level_13 = "Reach Level 13"
    level_14 = "Reach Level 14"
    level_15 = "Reach Level 15"
    level_16 = "Reach Level 16"
    level_17 = "Reach Level 17"
    level_18 = "Reach Level 18"
    level_19 = "Reach Level 19"
    level_20 = "Reach Level 20"
    level_21 = "Reach Level 21"
    level_22 = "Reach Level 22"
    level_23 = "Reach Level 23"
    level_24 = "Reach Level 24"
    level_25 = "Reach Level 25"
    level_26 = "Reach Level 26"
    level_27 = "Reach Level 27"
    level_28 = "Reach Level 28"
    level_29 = "Reach Level 29"
    level_30 = "Reach Level 30"
    level_31 = "Reach Level 31"
    level_32 = "Reach Level 32"
    level_33 = "Reach Level 33"
    level_34 = "Reach Level 34"
    level_35 = "Reach Level 35"
    level_36 = "Reach Level 36"
    level_37 = "Reach Level 37"
    level_38 = "Reach Level 38"
    level_39 = "Reach Level 39"
    level_40 = "Reach Level 40"
    level_41 = "Reach Level 41"
    level_42 = "Reach Level 42"
    level_43 = "Reach Level 43"
    level_44 = "Reach Level 44"
    level_45 = "Reach Level 45"
    level_46 = "Reach Level 46"
    level_47 = "Reach Level 47"
    level_48 = "Reach Level 48"
    level_49 = "Reach Level 49"
    level_50 = "Reach Level 50"
    level_51 = "Reach Level 51"
    level_52 = "Reach Level 52"
    level_53 = "Reach Level 53"
    level_54 = "Reach Level 54"
    level_55 = "Reach Level 55"
    level_56 = "Reach Level 56"
    level_57 = "Reach Level 57"
    level_58 = "Reach Level 58"
    level_59 = "Reach Level 59"
    level_60 = "Reach Level 60"
    level_61 = "Reach Level 61"
    level_62 = "Reach Level 62"
    level_63 = "Reach Level 63"
    level_64 = "Reach Level 64"
    level_65 = "Reach Level 65"
    level_66 = "Reach Level 66"
    level_67 = "Reach Level 67"
    level_68 = "Reach Level 68"
    level_69 = "Reach Level 69"
    level_70 = "Reach Level 70"
    level_71 = "Reach Level 71"
    level_72 = "Reach Level 72"
    level_73 = "Reach Level 73"
    level_74 = "Reach Level 74"
    level_75 = "Reach Level 75"
    level_76 = "Reach Level 76"
    level_77 = "Reach Level 77"
    level_78 = "Reach Level 78"
    level_79 = "Reach Level 79"
    level_80 = "Reach Level 80"
    level_81 = "Reach Level 81"
    level_82 = "Reach Level 82"
    level_83 = "Reach Level 83"
    level_84 = "Reach Level 84"
    level_85 = "Reach Level 85"
    level_86 = "Reach Level 86"
    level_87 = "Reach Level 87"
    level_88 = "Reach Level 88"
    level_89 = "Reach Level 89"
    level_90 = "Reach Level 90"
    level_91 = "Reach Level 91"
    level_92 = "Reach Level 92"
    level_93 = "Reach Level 93"
    level_94 = "Reach Level 94"
    level_95 = "Reach Level 95"
    level_96 = "Reach Level 96"
    level_97 = "Reach Level 97"
    level_98 = "Reach Level 98"
    level_99 = "Reach Level 99"
    level_100 = "Reach Level 100"


class LoreLocation:
    jusztina_1 = "CLF: Jusztina's Diary 1"
    jusztina_2 = "CLF: Jusztina's Diary 2"
    jusztina_letter = "CLF: Jusztina's Letter to Ophelia"
    ophelia_1 = "CLF: Ophelia's Letter to Jusztina 1"
    clf_report = "CLF: Status Report on Castle Le Fanu"
    ophelia_2 = "CLF: Ophelia's Letter to Jusztina 2"
    golden_plea = "CLF: Golden Lance Member's Plea"
    holy_relic = "CLF: Writings of Holy Relic Protection"
    ophelia_statue = "CLF: Statue to the Great Knight of Lyria"
    bestial = "LC: Bestial Writings"
    invisible_walkway = "LC: Plea for a Leap of Faith"
    curse_seeker = "FlA: Seeker of the Great Curses"
    power_seeker = "FlA: Seeker of Power"
    on_sucsarians = "FlA: On the Topic of Sucsarians"
    too_human = "FlA: One Who Has Too Much Humanity"
    calamis_1 = "ST: Calamis Diary 1"
    calamis_2 = "ST: Calamis Diary 2"
    calamis_3 = "ST: Calamis Diary 3"
    jeff_david = "BG: Gravestones of Sir Jeff and Sir David"
    hicket_story = "BG: Story of Sir Hicket"
    calamis_4 = "ST: Calamis Diary 4"
    hicket = "BG: Gravestone of Sir Hicket"
    moon = "WR: Statue Honoring the Moon"
    cultist_body = "HB: On the Bodies of Abdul Cultists"
    you_know = "HB: You're in the know right?"
    acidic_fruit = "HB: Visions of Byagototh"
    seek_creature = "HB: Final Advice"
    to_hunger = "HB: To Hunger, To Die"
    autopsy = "HB: Autopsy Report"
    cultist = "HB: Cultist's Writings"
    sword_fight = "HB: Encouraging Statue's Words"
    invader = "SB: Trapped Invader's Writings"
    vampire_complain = "SB: Vampire's Complaint"
    holy = "SB: Realization of \"Holy\" Magic"
    tower = "TA: Tower Introduction"
    flames = "AT: To Light the Flames"
    history_203 = "FbA: History of the Ages, Volume 20, excerpt 3"
    history_179 = "FbA: History of the Ages, Volume 17, excerpt 9"
    history_202 = "FbA: History of the Ages, Volume 20, excerpt 2"
    history_176 = "FbA: History of the Ages, Volume 17, excerpt 6"
    history_177 = "FbA: History of the Ages, Volume 17, excerpt 7"
    history_175 = "FbA: History of the Ages, Volume 17, excerpt 5"
    history_178 = "FbA: History of the Ages, Volume 17, excerpt 8"
    lyria_monument = "FbA: Monument to Lyria"
    tranquil_end = "FC: Tranquil Dead End Writings"
    tomb_dark = "YF: Tomb Warning"
    carnivore = "YF: On Carnivorous Plants"
    drained = "YF: Drained Adventurer's Warning"
    low_musing = "YF: Musings of What Lies Below"
    frustration = "YF: On Frustrations with Plantlife"
    calamis_after = "TP: Calamis' Aftermath"
    jail_complain = "TP: Jail Complaint"
    prisoner_mad = "TP: Insane Ramblings of a Prisoner"
    skeleton_yay = "TP: On Becoming Friends with Skeletons"
    on_dreamer = "TP: On The Dreamer and Creatures"
    yipee = "TP: Joyous Escapee"
    fisher = "TP: Fisher's Last Words"
    feel_something = "TP: Etna's Final Moments"
    changing = "TP: Changing Creatures and Self"
    blaspheme = "LA: On How to Blaspheme"
    strange_coin = "LA: A Way to Escape With Byagototh"
    prayer = "LA: Prayer For the Golden"
    centaur = "LA: The Last Before Becoming Centaur-like"
    abdul = "LA: Abdul's Journal"
    windy_path = "LA: Warning Against Abdul's Domain"
    bonenard = "FM: Bonenard's Admission of Infidelity"
    no_fire = "FM: Sewer Traveler's Last Words"
    garrat = "FM: Garrat's Proclamation"


class GrassLocation:
    clf_bloodweed_1 = "CLF: Bloodweed 1 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_2 = "CLF: Bloodweed 2 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_3 = "CLF: Bloodweed 3 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_4 = "CLF: Bloodweed 4 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_5 = "CLF: Bloodweed 5 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_6 = "CLF: Bloodweed 6 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_7 = "CLF: Bloodweed 7 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_8 = "CLF: Bloodweed 8 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_9 = "CLF: Bloodweed 9 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_10 = "CLF: Bloodweed 10 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_11 = "CLF: Bloodweed 11 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_12 = "CLF: Bloodweed 12 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_13 = "CLF: Bloodweed 13 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_14 = "CLF: Bloodweed 14 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_15 = "CLF: Bloodweed 15 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_16 = "CLF: Bloodweed 16 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_17 = "CLF: Bloodweed 17 - (Castle Le Fanu Main Halls)"
    clf_flora_1 = "CLF: Flora 1 - (Castle Le Fanu Entrance)"
    clf_flora_2 = "CLF: Flora 2 - (Castle Le Fanu Entrance)"
    clf_flora_3 = "CLF: Flora 3 - (Castle Le Fanu Entrance)"
    clf_flora_4 = "CLF: Flora 4 - (Castle Le Fanu Entrance)"
    clf_flora_5 = "CLF: Flora 5 - (Castle Le Fanu Entrance)"
    clf_flora_6 = "CLF: Flora 6 - (Castle Le Fanu Entrance)"
    clf_flora_7 = "CLF: Flora 7 - (Castle Le Fanu Entrance)"
    clf_flora_8 = "CLF: Flora 8 - (Castle Le Fanu Entrance)"
    clf_flora_9 = "CLF: Flora 9 - (Castle Le Fanu Entrance)"
    clf_flora_10 = "CLF: Flora 10 - (Castle Le Fanu Entrance)"
    clf_bloodweed_18 = "CLF: Bloodweed 18 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_19 = "CLF: Bloodweed 19 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_20 = "CLF: Bloodweed 20 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_21 = "CLF: Bloodweed 21 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_22 = "CLF: Bloodweed 22 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_23 = "CLF: Bloodweed 23 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_24 = "CLF: Bloodweed 24 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_25 = "CLF: Bloodweed 25 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_26 = "CLF: Bloodweed 26 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_27 = "CLF: Bloodweed 27 - (Castle Le Fanu Main Halls)"
    clf_flora_11 = "CLF: Flora 11 - (Castle Le Fanu Entrance)"
    clf_flora_12 = "CLF: Flora 12 - (Castle Le Fanu Entrance)"
    clf_flora_13 = "CLF: Flora 13 - (Castle Le Fanu Entrance)"
    clf_flora_14 = "CLF: Flora 14 - (Castle Le Fanu Entrance)"
    clf_flora_15 = "CLF: Flora 15 - (Castle Le Fanu Entrance)"
    clf_flora_16 = "CLF: Flora 16 - (Castle Le Fanu Entrance)"
    clf_bloodweed_28 = "CLF: Bloodweed 28 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_29 = "CLF: Bloodweed 29 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_30 = "CLF: Bloodweed 30 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_31 = "CLF: Bloodweed 31 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_32 = "CLF: Bloodweed 32 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_33 = "CLF: Bloodweed 33 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_34 = "CLF: Bloodweed 34 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_35 = "CLF: Bloodweed 35 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_36 = "CLF: Bloodweed 36 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_37 = "CLF: Bloodweed 37 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_38 = "CLF: Bloodweed 38 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_39 = "CLF: Bloodweed 39 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_40 = "CLF: Bloodweed 40 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_41 = "CLF: Bloodweed 41 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_42 = "CLF: Bloodweed 42 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_43 = "CLF: Bloodweed 43 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_44 = "CLF: Bloodweed 44 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_45 = "CLF: Bloodweed 45 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_46 = "CLF: Bloodweed 46 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_47 = "CLF: Bloodweed 47 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_48 = "CLF: Bloodweed 48 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_49 = "CLF: Bloodweed 49 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_50 = "CLF: Bloodweed 50 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_51 = "CLF: Bloodweed 51 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_52 = "CLF: Bloodweed 52 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_53 = "CLF: Bloodweed 53 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_54 = "CLF: Bloodweed 54 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_55 = "CLF: Bloodweed 55 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_56 = "CLF: Bloodweed 56 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_57 = "CLF: Bloodweed 57 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_58 = "CLF: Bloodweed 58 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_59 = "CLF: Bloodweed 59 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_60 = "CLF: Bloodweed 60 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_61 = "CLF: Bloodweed 61 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_62 = "CLF: Bloodweed 62 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_63 = "CLF: Bloodweed 63 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_64 = "CLF: Bloodweed 64 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_65 = "CLF: Bloodweed 65 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_66 = "CLF: Bloodweed 66 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_67 = "CLF: Bloodweed 67 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_68 = "CLF: Bloodweed 68 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_69 = "CLF: Bloodweed 69 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_70 = "CLF: Bloodweed 70 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_71 = "CLF: Bloodweed 71 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_72 = "CLF: Bloodweed 72 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_73 = "CLF: Bloodweed 73 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_74 = "CLF: Bloodweed 74 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_75 = "CLF: Bloodweed 75 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_76 = "CLF: Bloodweed 76 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_77 = "CLF: Bloodweed 77 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_78 = "CLF: Bloodweed 78 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_79 = "CLF: Bloodweed 79 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_80 = "CLF: Bloodweed 80 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_81 = "CLF: Bloodweed 81 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_82 = "CLF: Bloodweed 82 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_83 = "CLF: Bloodweed 83 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_84 = "CLF: Bloodweed 84 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_85 = "CLF: Bloodweed 85 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_86 = "CLF: Bloodweed 86 - (Castle Le Fanu Main Halls)"
    clf_flora_17 = "CLF: Flora 17 - (Castle Le Fanu Entrance)"
    clf_flora_18 = "CLF: Flora 18 - (Castle Le Fanu Entrance)"
    clf_bloodweed_87 = "CLF: Bloodweed 87 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_88 = "CLF: Bloodweed 88 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_89 = "CLF: Bloodweed 89 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_90 = "CLF: Bloodweed 90 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_91 = "CLF: Bloodweed 91 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_92 = "CLF: Bloodweed 92 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_93 = "CLF: Bloodweed 93 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_94 = "CLF: Bloodweed 94 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_95 = "CLF: Bloodweed 95 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_96 = "CLF: Bloodweed 96 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_97 = "CLF: Bloodweed 97 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_98 = "CLF: Bloodweed 98 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_99 = "CLF: Bloodweed 99 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_100 = "CLF: Bloodweed 100 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_101 = "CLF: Bloodweed 101 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_102 = "CLF: Bloodweed 102 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_103 = "CLF: Bloodweed 103 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_104 = "CLF: Bloodweed 104 - (Castle Le Fanu Main Halls)"
    clf_bloodweed_105 = "CLF: Bloodweed 105 - (Castle Le Fanu Main Halls)"
    fm_lotus_1 = "FM: Lotus 1 - (The Fetid Mire)"
    fm_lotus_2 = "FM: Lotus 2 - (The Fetid Mire)"
    fm_lotus_3 = "FM: Lotus 3 - (The Fetid Mire)"
    fm_lotus_4 = "FM: Lotus 4 - (The Fetid Mire)"
    fm_lotus_5 = "FM: Lotus 5 - (The Fetid Mire)"
    fm_lotus_6 = "FM: Lotus 6 - (The Fetid Mire)"
    fm_lotus_7 = "FM: Lotus 7 - (The Fetid Mire)"
    fm_lotus_8 = "FM: Lotus 8 - (The Fetid Mire)"
    fm_lotus_9 = "FM: Lotus 9 - (The Fetid Mire)"
    fm_lotus_10 = "FM: Lotus 10 - (The Fetid Mire)"
    fm_lotus_11 = "FM: Lotus 11 - (The Fetid Mire)"
    fm_lotus_12 = "FM: Lotus 12 - (The Fetid Mire)"
    fm_lotus_13 = "FM: Lotus 13 - (The Fetid Mire)"
    fm_lotus_14 = "FM: Lotus 14 - (The Fetid Mire)"
    fm_lotus_15 = "FM: Lotus 15 - (The Fetid Mire)"
    fm_lotus_16 = "FM: Lotus 16 - (The Fetid Mire)"
    fm_lotus_17 = "FM: Lotus 17 - (The Fetid Mire)"
    fm_lotus_18 = "FM: Lotus 18 - (The Fetid Mire)"
    fm_lotus_19 = "FM: Lotus 19 - (The Fetid Mire)"
    fm_lotus_20 = "FM: Lotus 20 - (The Fetid Mire)"
    fm_lotus_21 = "FM: Lotus 21 - (The Fetid Mire)"
    fm_lotus_22 = "FM: Lotus 22 - (The Fetid Mire)"
    fm_lotus_23 = "FM: Lotus 23 - (The Fetid Mire)"
    fm_lotus_24 = "FM: Lotus 24 - (The Fetid Mire)"
    fm_lotus_25 = "FM: Lotus 25 - (The Fetid Mire)"
    fm_lotus_26 = "FM: Lotus 26 - (The Fetid Mire)"
    fm_lotus_27 = "FM: Lotus 27 - (The Fetid Mire)"
    fm_lotus_28 = "FM: Lotus 28 - (The Fetid Mire)"
    fla_fiddlehead_1 = "FlA: Fiddlehead 1 - (Forlorn Arena)"
    fla_lotus_1 = "FlA: Lotus 1 - (Temple of Water)"
    fla_lotus_2 = "FlA: Lotus 2 - (Temple of Water Lower Area)"
    fla_lotus_3 = "FlA: Lotus 3 - (Temple of Water)"
    fla_lotus_4 = "FlA: Lotus 4 - (Temple of Water)"
    fla_lotus_5 = "FlA: Lotus 5 - (Temple of Water)"
    fla_lotus_6 = "FlA: Lotus 6 - (Temple of Water Lower Area)"
    fla_lotus_7 = "FlA: Lotus 7 - (Temple of Water Lower Area)"
    fla_lotus_8 = "FlA: Lotus 8 - (Temple of Water)"
    fla_lotus_9 = "FlA: Lotus 9 - (Temple of Water)"
    fla_lotus_10 = "FlA: Lotus 10 - (Temple of Water)"
    fla_lotus_11 = "FlA: Lotus 11 - (Temple of Water)"
    fla_lotus_12 = "FlA: Lotus 12 - (Temple of Water Lower Area)"
    fla_lotus_13 = "FlA: Lotus 13 - (Temple of Water)"
    fla_lotus_14 = "FlA: Lotus 14 - (Temple of Water)"
    fla_lotus_15 = "FlA: Lotus 15 - (Temple of Water Lower Area Secrets)"
    fla_lotus_16 = "FlA: Lotus 16 - (Temple of Water Lower Area)"
    fla_fiddlehead_2 = "FlA: Fiddlehead 2 - (Temple of Earth)"
    fla_fiddlehead_3 = "FlA: Fiddlehead 3 - (Temple of Earth)"
    fla_fiddlehead_4 = "FlA: Fiddlehead 4 - (Temple of Earth)"
    fla_fiddlehead_5 = "FlA: Fiddlehead 5 - (Temple of Earth)"
    fla_fiddlehead_6 = "FlA: Fiddlehead 6 - (Temple of Earth Secret Areas)"
    fla_fiddlehead_7 = "FlA: Fiddlehead 7 - (Temple of Earth)"
    fla_fiddlehead_8 = "FlA: Fiddlehead 8 - (Temple of Earth)"
    fla_fiddlehead_9 = "FlA: Fiddlehead 9 - (Forlorn Arena)"
    fla_fiddlehead_10 = "FlA: Fiddlehead 10 - (Forlorn Arena)"
    fla_fiddlehead_11 = "FlA: Fiddlehead 11 - (Temple of Earth Secret Areas)"
    fla_lotus_17 = "FlA: Lotus 17 - (Temple of Water)"
    fla_lotus_18 = "FlA: Lotus 18 - (Temple of Water Lower Area Secrets)"
    fla_fiddlehead_12 = "FlA: Fiddlehead 12 - (Temple of Earth)"
    fla_fiddlehead_13 = "FlA: Fiddlehead 13 - (Temple of Earth)"
    fla_fiddlehead_14 = "FlA: Fiddlehead 14 - (Temple of Earth Secret Areas)"
    fla_fiddlehead_15 = "FlA: Fiddlehead 15 - (Temple of Earth)"
    fla_fiddlehead_16 = "FlA: Fiddlehead 16 - (Forlorn Arena)"
    fla_fiddlehead_17 = "FlA: Fiddlehead 17 - (Temple of Earth)"
    fla_fiddlehead_18 = "FlA: Fiddlehead 18 - (Temple of Earth)"
    fla_fiddlehead_19 = "FlA: Fiddlehead 19 - (Temple of Earth)"
    fla_fiddlehead_20 = "FlA: Fiddlehead 20 - (Forlorn Arena)"
    fla_fiddlehead_21 = "FlA: Fiddlehead 21 - (Forlorn Arena)"
    fla_fiddlehead_22 = "FlA: Fiddlehead 22 - (Temple of Earth Secret Areas)"
    fla_lotus_19 = "FlA: Lotus 19 - (Temple of Water Lower Area)"
    fla_fiddlehead_23 = "FlA: Fiddlehead 23 - (Forlorn Arena)"
    fla_fiddlehead_24 = "FlA: Fiddlehead 24 - (Forlorn Arena)"
    fla_fiddlehead_25 = "FlA: Fiddlehead 25 - (Temple of Earth)"
    fla_fiddlehead_26 = "FlA: Fiddlehead 26 - (Temple of Earth)"
    fla_fiddlehead_27 = "FlA: Fiddlehead 27 - (Temple of Earth Secret Areas)"
    fla_fiddlehead_28 = "FlA: Fiddlehead 28 - (Temple of Earth)"
    fla_fiddlehead_29 = "FlA: Fiddlehead 29 - (Temple of Earth)"
    fla_fiddlehead_30 = "FlA: Fiddlehead 30 - (Temple of Earth Secret Areas)"
    fla_fiddlehead_31 = "FlA: Fiddlehead 31 - (Temple of Earth)"
    fla_fiddlehead_32 = "FlA: Fiddlehead 32 - (Forlorn Arena)"
    fla_fiddlehead_33 = "FlA: Fiddlehead 33 - (Forlorn Arena)"
    bg_fire_coral_1 = "BG: Fire Coral 1 - (Boiling Grotto)"
    bg_fire_coral_2 = "BG: Fire Coral 2 - (Boiling Grotto)"
    bg_fire_coral_3 = "BG: Fire Coral 3 - (Boiling Grotto)"
    bg_fire_coral_4 = "BG: Fire Coral 4 - (Boiling Grotto)"
    bg_fire_coral_5 = "BG: Fire Coral 5 - (Boiling Grotto)"
    bg_fire_coral_6 = "BG: Fire Coral 6 - (Boiling Grotto)"
    bg_fire_coral_7 = "BG: Fire Coral 7 - (Boiling Grotto)"
    bg_fire_coral_8 = "BG: Fire Coral 8 - (Boiling Grotto)"
    bg_fire_coral_9 = "BG: Fire Coral 9 - (Boiling Grotto)"
    bg_fire_coral_10 = "BG: Fire Coral 10 - (Boiling Grotto)"
    bg_fire_coral_11 = "BG: Fire Coral 11 - (Boiling Grotto)"
    bg_fire_coral_12 = "BG: Fire Coral 12 - (Boiling Grotto)"
    bg_fire_coral_13 = "BG: Fire Coral 13 - (Boiling Grotto)"
    bg_fire_coral_14 = "BG: Fire Coral 14 - (Boiling Grotto)"
    bg_fire_coral_15 = "BG: Fire Coral 15 - (Boiling Grotto)"
    bg_fire_coral_16 = "BG: Fire Coral 16 - (Boiling Grotto)"
    bg_fire_coral_17 = "BG: Fire Coral 17 - (Boiling Grotto)"
    bg_fire_coral_18 = "BG: Fire Coral 18 - (Boiling Grotto)"
    bg_fire_coral_19 = "BG: Fire Coral 19 - (Boiling Grotto)"
    sb_bloodweed_1 = "SB: Bloodweed 1 - (Sealed Ballroom Secrets)"
    sb_bloodweed_2 = "SB: Bloodweed 2 - (Sealed Ballroom Secrets)"
    sb_bloodweed_3 = "SB: Bloodweed 3 - (Sealed Ballroom Secrets)"
    sb_bloodweed_4 = "SB: Bloodweed 4 - (Sealed Ballroom Secrets)"
    sb_bloodweed_5 = "SB: Bloodweed 5 - (Sealed Ballroom Secrets)"
    sb_bloodweed_6 = "SB: Bloodweed 6 - (Sealed Ballroom Secrets)"
    sb_bloodweed_7 = "SB: Bloodweed 7 - (Sealed Ballroom Secrets)"
    sb_bloodweed_8 = "SB: Bloodweed 8 - (Sealed Ballroom Secrets)"
    sb_bloodweed_9 = "SB: Bloodweed 9 - (Sealed Ballroom Secrets)"
    at_flora_1 = "AT: Flora 1 - (Mausoleum)"
    at_flora_2 = "AT: Flora 2 - (Mausoleum)"
    at_flora_3 = "AT: Flora 3 - (Mausoleum)"
    at_flora_4 = "AT: Flora 4 - (Mausoleum)"
    at_flora_5 = "AT: Flora 5 - (Mausoleum)"
    at_flora_6 = "AT: Flora 6 - (Mausoleum)"
    at_flora_7 = "AT: Flora 7 - (Mausoleum)"
    at_flora_8 = "AT: Flora 8 - (Mausoleum)"
    at_flora_9 = "AT: Flora 9 - (Mausoleum)"
    at_flora_10 = "AT: Flora 10 - (Mausoleum)"
    at_flora_11 = "AT: Flora 11 - (Mausoleum)"
    at_flora_12 = "AT: Flora 12 - (Mausoleum)"
    at_flora_13 = "AT: Flora 13 - (Mausoleum)"
    at_flora_14 = "AT: Flora 14 - (Mausoleum)"
    at_flora_15 = "AT: Flora 15 - (Mausoleum)"
    at_flora_16 = "AT: Flora 16 - (Mausoleum)"
    at_flora_17 = "AT: Flora 17 - (Mausoleum)"
    at_flora_18 = "AT: Flora 18 - (Mausoleum)"
    at_flora_19 = "AT: Flora 19 - (Mausoleum)"
    at_flora_20 = "AT: Flora 20 - (Mausoleum)"
    at_flora_21 = "AT: Flora 21 - (Mausoleum)"
    at_flora_22 = "AT: Flora 22 - (Mausoleum)"
    at_flora_23 = "AT: Flora 23 - (Mausoleum)"
    at_flora_24 = "AT: Flora 24 - (Mausoleum)"
    at_flora_25 = "AT: Flora 25 - (Mausoleum)"
    at_flora_26 = "AT: Flora 26 - (Mausoleum)"
    at_flora_27 = "AT: Flora 27 - (Mausoleum)"
    at_flora_28 = "AT: Flora 28 - (Mausoleum)"
    at_flora_29 = "AT: Flora 29 - (Mausoleum)"
    at_flora_30 = "AT: Flora 30 - (Mausoleum)"
    at_flora_31 = "AT: Flora 31 - (Mausoleum)"
    at_flora_32 = "AT: Flora 32 - (Mausoleum)"
    at_flora_33 = "AT: Flora 33 - (Mausoleum)"
    at_flora_34 = "AT: Flora 34 - (Mausoleum)"
    at_flora_35 = "AT: Flora 35 - (Mausoleum)"
    at_flora_36 = "AT: Flora 36 - (Mausoleum)"
    hb_bloodweed_1 = "HoB: Bloodweed 1 - (Holy Battleground)"
    hb_bloodweed_2 = "HoB: Bloodweed 2 - (Holy Battleground)"
    hb_bloodweed_3 = "HoB: Bloodweed 3 - (Holy Battleground)"
    hb_bloodweed_4 = "HoB: Bloodweed 4 - (Holy Battleground)"
    hb_bloodweed_5 = "HoB: Bloodweed 5 - (Holy Battleground)"
    hb_bloodweed_6 = "HoB: Bloodweed 6 - (Holy Battleground)"
    hb_bloodweed_7 = "HoB: Bloodweed 7 - (Holy Battleground)"
    hb_bloodweed_8 = "HoB: Bloodweed 8 - (Holy Battleground)"
    hb_bloodweed_9 = "HoB: Bloodweed 9 - (Holy Battleground)"
    hb_bloodweed_10 = "HoB: Bloodweed 10 - (Holy Battleground)"
    hb_bloodweed_11 = "HoB: Bloodweed 11 - (Holy Battleground)"
    hb_bloodweed_12 = "HoB: Bloodweed 12 - (Holy Battleground)"
    hb_bloodweed_13 = "HoB: Bloodweed 13 - (Holy Battleground)"
    hb_bloodweed_14 = "HoB: Bloodweed 14 - (Holy Battleground)"
    hb_bloodweed_15 = "HoB: Bloodweed 15 - (Holy Battleground)"
    hb_bloodweed_16 = "HoB: Bloodweed 16 - (Holy Battleground)"
    hb_bloodweed_17 = "HoB: Bloodweed 17 - (Holy Battleground)"
    hb_bloodweed_18 = "HoB: Bloodweed 18 - (Holy Battleground)"
    hb_bloodweed_19 = "HoB: Bloodweed 19 - (Holy Battleground)"
    hb_bloodweed_20 = "HoB: Bloodweed 20 - (Holy Battleground)"
    hb_bloodweed_21 = "HoB: Bloodweed 21 - (Holy Battleground)"
    hb_bloodweed_22 = "HoB: Bloodweed 22 - (Holy Battleground)"
    hb_bloodweed_23 = "HoB: Bloodweed 23 - (Holy Battleground)"
    hb_bloodweed_24 = "HoB: Bloodweed 24 - (Holy Battleground)"
    hb_bloodweed_25 = "HoB: Bloodweed 25 - (Holy Battleground)"
    hb_bloodweed_26 = "HoB: Bloodweed 26 - (Holy Battleground)"
    hb_bloodweed_27 = "HoB: Bloodweed 27 - (Holy Battleground)"
    hb_bloodweed_28 = "HoB: Bloodweed 28 - (Holy Battleground)"
    hb_bloodweed_29 = "HoB: Bloodweed 29 - (Holy Battleground)"
    hb_bloodweed_30 = "HoB: Bloodweed 30 - (Holy Battleground)"
    hb_bloodweed_31 = "HoB: Bloodweed 31 - (Holy Battleground)"
    hb_bloodweed_32 = "HoB: Bloodweed 32 - (Holy Battleground)"
    hb_bloodweed_33 = "HoB: Bloodweed 33 - (Holy Battleground)"
    hb_bloodweed_34 = "HoB: Bloodweed 34 - (Holy Battleground)"
    hb_bloodweed_35 = "HoB: Bloodweed 35 - (Holy Battleground)"
    hb_bloodweed_36 = "HoB: Bloodweed 36 - (Holy Battleground)"
    hb_bloodweed_37 = "HoB: Bloodweed 37 - (Holy Battleground)"
    hb_bloodweed_38 = "HoB: Bloodweed 38 - (Holy Battleground)"
    hb_bloodweed_39 = "HoB: Bloodweed 39 - (Holy Battleground)"
    hb_bloodweed_40 = "HoB: Bloodweed 40 - (Holy Battleground)"
    hb_bloodweed_41 = "HoB: Bloodweed 41 - (Holy Battleground)"
    hb_bloodweed_42 = "HoB: Bloodweed 42 - (Holy Battleground)"
    hb_bloodweed_43 = "HoB: Bloodweed 43 - (Holy Battleground)"
    hb_bloodweed_44 = "HoB: Bloodweed 44 - (Holy Battleground)"
    hb_bloodweed_45 = "HoB: Bloodweed 45 - (Holy Battleground)"
    hb_bloodweed_46 = "HoB: Bloodweed 46 - (Holy Battleground)"
    hb_bloodweed_47 = "HoB: Bloodweed 47 - (Holy Battleground)"
    hb_bloodweed_48 = "HoB: Bloodweed 48 - (Holy Battleground)"
    hb_bloodweed_49 = "HoB: Bloodweed 49 - (Holy Battleground)"
    hb_bloodweed_50 = "HoB: Bloodweed 50 - (Holy Battleground)"
    hb_bloodweed_51 = "HoB: Bloodweed 51 - (Holy Battleground)"
    hb_bloodweed_52 = "HoB: Bloodweed 52 - (Holy Battleground)"
    hb_bloodweed_53 = "HoB: Bloodweed 53 - (Holy Battleground)"
    hb_bloodweed_54 = "HoB: Bloodweed 54 - (Holy Battleground)"
    hb_bloodweed_55 = "HoB: Bloodweed 55 - (Holy Battleground)"
    hb_bloodweed_56 = "HoB: Bloodweed 56 - (Holy Battleground)"
    hb_bloodweed_57 = "HoB: Bloodweed 57 - (Holy Battleground)"
    hb_bloodweed_58 = "HoB: Bloodweed 58 - (Holy Battleground)"
    hb_bloodweed_59 = "HoB: Bloodweed 59 - (Holy Battleground)"
    hb_bloodweed_60 = "HoB: Bloodweed 60 - (Holy Battleground)"
    hb_bloodweed_61 = "HoB: Bloodweed 61 - (Holy Battleground)"
    hb_bloodweed_62 = "HoB: Bloodweed 62 - (Holy Battleground)"
    hb_bloodweed_63 = "HoB: Bloodweed 63 - (Holy Battleground)"
    hb_bloodweed_64 = "HoB: Bloodweed 64 - (Holy Battleground)"
    hb_bloodweed_65 = "HoB: Bloodweed 65 - (Holy Battleground)"
    hb_bloodweed_66 = "HoB: Bloodweed 66 - (Holy Battleground)"
    hb_bloodweed_67 = "HoB: Bloodweed 67 - (Holy Battleground)"
    hb_bloodweed_68 = "HoB: Bloodweed 68 - (Holy Battleground)"
    hb_bloodweed_69 = "HoB: Bloodweed 69 - (Holy Battleground)"
    hb_bloodweed_70 = "HoB: Bloodweed 70 - (Holy Battleground)"
    hb_bloodweed_71 = "HoB: Bloodweed 71 - (Holy Battleground)"
    hb_bloodweed_72 = "HoB: Bloodweed 72 - (Holy Battleground)"
    hb_bloodweed_73 = "HoB: Bloodweed 73 - (Holy Battleground)"
    hb_bloodweed_74 = "HoB: Bloodweed 74 - (Holy Battleground)"
    hb_bloodweed_75 = "HoB: Bloodweed 75 - (Holy Battleground)"
    hb_bloodweed_76 = "HoB: Bloodweed 76 - (Holy Battleground)"
    hb_bloodweed_77 = "HoB: Bloodweed 77 - (Holy Battleground)"
    hb_bloodweed_78 = "HoB: Bloodweed 78 - (Holy Battleground)"
    hb_bloodweed_79 = "HoB: Bloodweed 79 - (Holy Battleground)"
    hb_bloodweed_80 = "HoB: Bloodweed 80 - (Holy Battleground)"
    hb_bloodweed_81 = "HoB: Bloodweed 81 - (Holy Battleground)"
    hb_bloodweed_82 = "HoB: Bloodweed 82 - (Holy Battleground)"
    hb_bloodweed_83 = "HoB: Bloodweed 83 - (Holy Battleground)"
    hb_bloodweed_84 = "HoB: Bloodweed 84 - (Holy Battleground)"
    hb_bloodweed_85 = "HoB: Bloodweed 85 - (Holy Battleground)"
    hb_bloodweed_86 = "HoB: Bloodweed 86 - (Holy Battleground)"
    hb_bloodweed_87 = "HoB: Bloodweed 87 - (Holy Battleground)"
    hb_bloodweed_88 = "HoB: Bloodweed 88 - (Holy Battleground)"
    hb_bloodweed_89 = "HoB: Bloodweed 89 - (Holy Battleground)"
    hb_bloodweed_90 = "HoB: Bloodweed 90 - (Holy Battleground)"
    hb_bloodweed_91 = "HoB: Bloodweed 91 - (Holy Battleground)"
    hb_bloodweed_92 = "HoB: Bloodweed 92 - (Holy Battleground)"
    hb_bloodweed_93 = "HoB: Bloodweed 93 - (Holy Battleground)"
    hb_bloodweed_94 = "HoB: Bloodweed 94 - (Holy Battleground)"
    hb_bloodweed_95 = "HoB: Bloodweed 95 - (Holy Battleground)"
    hb_bloodweed_96 = "HoB: Bloodweed 96 - (Holy Battleground)"
    hb_bloodweed_97 = "HoB: Bloodweed 97 - (Holy Battleground)"
    hb_bloodweed_98 = "HoB: Bloodweed 98 - (Holy Battleground)"
    hb_bloodweed_99 = "HoB: Bloodweed 99 - (Holy Battleground)"
    hb_bloodweed_100 = "HoB: Bloodweed 100 - (Holy Battleground)"
    hb_bloodweed_101 = "HoB: Bloodweed 101 - (Holy Battleground)"
    hb_bloodweed_102 = "HoB: Bloodweed 102 - (Holy Battleground)"
    yf_mushroom_1 = "YF: Mushroom 1 - (Yosei Forest)"
    yf_mushroom_2 = "YF: Mushroom 2 - (Yosei Forest Lower Path)"
    yf_mushroom_3 = "YF: Mushroom 3 - (Yosei Forest Lower Path)"
    yf_mushroom_4 = "YF: Mushroom 4 - (Yosei Forest Lower Path)"
    yf_mushroom_5 = "YF: Mushroom 5 - (Yosei Forest Lower Path)"
    yf_mushroom_6 = "YF: Mushroom 6 - (Yosei Forest Lower Path)"
    yf_mushroom_7 = "YF: Mushroom 7 - (Yosei Forest)"
    yf_mushroom_8 = "YF: Mushroom 8 - (Yosei Forest)"
    yf_mushroom_9 = "YF: Mushroom 9 - (Yosei Forest)"
    yf_mushroom_10 = "YF: Mushroom 10 - (Yosei Forest Lower Path)"
    yf_mushroom_11 = "YF: Mushroom 11 - (Yosei Forest Lower Path)"
    yf_mushroom_12 = "YF: Mushroom 12 - (Yosei Forest)"
    yf_mushroom_13 = "YF: Mushroom 13 - (Yosei Forest)"
    yf_mushroom_14 = "YF: Mushroom 14 - (Yosei Forest Lower Path)"
    yf_mushroom_15 = "YF: Mushroom 15 - (Yosei Forest)"
    yf_mushroom_16 = "YF: Mushroom 16 - (Yosei Forest Lower Path)"
    yf_mushroom_17 = "YF: Mushroom 17 - (Yosei Forest Lower Path)"
    yf_mushroom_18 = "YF: Mushroom 18 - (Yosei Forest)"
    yf_mushroom_19 = "YF: Mushroom 19 - (Yosei Forest)"
    yf_mushroom_20 = "YF: Mushroom 20 - (Yosei Forest)"
    yf_mushroom_21 = "YF: Mushroom 21 - (Yosei Forest Lower Path)"
    yf_mushroom_22 = "YF: Mushroom 22 - (Yosei Forest)"
    yf_mushroom_23 = "YF: Mushroom 23 - (Yosei Forest)"
    yf_mushroom_24 = "YF: Mushroom 24 - (Yosei Forest Lower Path)"
    yf_mushroom_25 = "YF: Mushroom 25 - (Yosei Forest Lower Path)"
    yf_mushroom_26 = "YF: Mushroom 26 - (Yosei Forest)"
    yf_mushroom_27 = "YF: Mushroom 27 - (Yosei Forest)"
    yf_mushroom_28 = "YF: Mushroom 28 - (Yosei Forest)"
    yf_mushroom_29 = "YF: Mushroom 29 - (Yosei Forest)"
    yf_mushroom_30 = "YF: Mushroom 30 - (Yosei Forest Lower Path)"
    yf_mushroom_31 = "YF: Mushroom 31 - (Yosei Forest)"
    yf_mushroom_32 = "YF: Mushroom 32 - (Yosei Forest)"
    yf_mushroom_33 = "YF: Mushroom 33 - (Yosei Forest)"
    yf_mushroom_34 = "YF: Mushroom 34 - (Yosei Forest Lower Path)"
    yf_mushroom_35 = "YF: Mushroom 35 - (Yosei Forest Lower Path Secret)"
    yf_mushroom_36 = "YF: Mushroom 36 - (Yosei Forest)"
    yf_mushroom_37 = "YF: Mushroom 37 - (Yosei Forest Lower Path)"
    yf_mushroom_38 = "YF: Mushroom 38 - (Yosei Forest Lower Path)"
    yf_mushroom_39 = "YF: Mushroom 39 - (Yosei Forest Lower Path)"
    yf_mushroom_40 = "YF: Mushroom 40 - (Yosei Forest Lower Path)"
    yf_mushroom_41 = "YF: Mushroom 41 - (Yosei Forest)"
    yf_mushroom_42 = "YF: Mushroom 42 - (Yosei Forest)"
    yf_mushroom_43 = "YF: Mushroom 43 - (Yosei Forest)"
    yf_mushroom_44 = "YF: Mushroom 44 - (Yosei Forest)"
    yf_mushroom_45 = "YF: Mushroom 45 - (Yosei Forest)"
    yf_mushroom_46 = "YF: Mushroom 46 - (Yosei Forest Lower Path Secret)"
    yf_mushroom_47 = "YF: Mushroom 47 - (Yosei Forest)"
    yf_mushroom_48 = "YF: Mushroom 48 - (Yosei Forest Lower Path)"
    yf_mushroom_49 = "YF: Mushroom 49 - (Yosei Forest Lower Path)"
    yf_mushroom_50 = "YF: Mushroom 50 - (Yosei Forest)"
    yf_mushroom_51 = "YF: Mushroom 51 - (Yosei Forest)"
    tp_bloodweed_1 = "TP: Bloodweed 1 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_2 = "TP: Bloodweed 2 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_3 = "TP: Bloodweed 3 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_4 = "TP: Bloodweed 4 - (Terminus Prison 1st Floor)"
    tp_bloodweed_5 = "TP: Bloodweed 5 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_6 = "TP: Bloodweed 6 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_7 = "TP: Bloodweed 7 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_8 = "TP: Bloodweed 8 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_9 = "TP: Bloodweed 9 - (Terminus Prison 1st Floor)"
    tp_bloodweed_10 = "TP: Bloodweed 10 - (Terminus Prison 1st Floor)"
    tp_bloodweed_11 = "TP: Bloodweed 11 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_12 = "TP: Bloodweed 12 - (Terminus Prison 1st Floor)"
    tp_bloodweed_13 = "TP: Bloodweed 13 - (Terminus Prison 1st Floor)"
    tp_bloodweed_14 = "TP: Bloodweed 14 - (Terminus Prison 1st Floor)"
    tp_bloodweed_15 = "TP: Bloodweed 15 - (Terminus Prison 1st Floor)"
    tp_bloodweed_16 = "TP: Bloodweed 16 - (Terminus Prison 1st Floor)"
    tp_bloodweed_17 = "TP: Bloodweed 17 - (Terminus Prison 1st Floor)"
    tp_flora_1 = "TP: Flora 1 - (Terminus Prison 4th Floor)"
    tp_flora_2 = "TP: Flora 2 - (Terminus Prison 4th Floor)"
    tp_flora_3 = "TP: Flora 3 - (Terminus Prison 4th Floor)"
    tp_bloodweed_18 = "TP: Bloodweed 18 - (Terminus Prison 2nd Floor Rooms)"
    tp_flora_4 = "TP: Flora 4 - (Terminus Prison 4th Floor)"
    tp_bloodweed_19 = "TP: Bloodweed 19 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_20 = "TP: Bloodweed 20 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_21 = "TP: Bloodweed 21 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_22 = "TP: Bloodweed 22 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_23 = "TP: Bloodweed 23 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_24 = "TP: Bloodweed 24 - (Terminus Prison 1st Floor)"
    tp_bloodweed_25 = "TP: Bloodweed 25 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_26 = "TP: Bloodweed 26 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_27 = "TP: Bloodweed 27 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_28 = "TP: Bloodweed 28 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_29 = "TP: Bloodweed 29 - (Terminus Prison 1st Floor)"
    tp_bloodweed_30 = "TP: Bloodweed 30 - (Terminus Prison 1st Floor)"
    tp_bloodweed_31 = "TP: Bloodweed 31 - (Terminus Prison 1st Floor)"
    tp_bloodweed_32 = "TP: Bloodweed 32 - (Terminus Prison 1st Floor)"
    tp_bloodweed_33 = "TP: Bloodweed 33 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_34 = "TP: Bloodweed 34 - (Terminus Prison 1st Floor)"
    tp_bloodweed_35 = "TP: Bloodweed 35 - (Terminus Prison 1st Floor)"
    tp_bloodweed_36 = "TP: Bloodweed 36 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_37 = "TP: Bloodweed 37 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_38 = "TP: Bloodweed 38 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_39 = "TP: Bloodweed 39 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_40 = "TP: Bloodweed 40 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_41 = "TP: Bloodweed 41 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_42 = "TP: Bloodweed 42 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_43 = "TP: Bloodweed 43 - (Terminus Prison 1st Floor)"
    tp_bloodweed_44 = "TP: Bloodweed 44 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_45 = "TP: Bloodweed 45 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_46 = "TP: Bloodweed 46 - (Terminus Prison 1st Floor)"
    tp_bloodweed_47 = "TP: Bloodweed 47 - (Terminus Prison 1st Floor)"
    tp_bloodweed_48 = "TP: Bloodweed 48 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_49 = "TP: Bloodweed 49 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_50 = "TP: Bloodweed 50 - (Terminus Prison 1st Floor)"
    tp_bloodweed_51 = "TP: Bloodweed 51 - (Terminus Prison 1st Floor)"
    tp_bloodweed_52 = "TP: Bloodweed 52 - (Terminus Prison 1st Floor)"
    tp_bloodweed_53 = "TP: Bloodweed 53 - (Terminus Prison 1st Floor)"
    tp_bloodweed_54 = "TP: Bloodweed 54 - (Terminus Prison 1st Floor)"
    tp_bloodweed_55 = "TP: Bloodweed 55 - (Terminus Prison 1st Floor)"
    tp_bloodweed_56 = "TP: Bloodweed 56 - (Terminus Prison 1st Floor)"
    tp_flora_5 = "TP: Flora 5 - (Terminus Prison 4th Floor)"
    tp_bloodweed_57 = "TP: Bloodweed 57 - (Terminus Prison 1st Floor)"
    tp_bloodweed_58 = "TP: Bloodweed 58 - (Terminus Prison 1st Floor)"
    tp_bloodweed_59 = "TP: Bloodweed 59 - (Terminus Prison 1st Floor)"
    tp_bloodweed_60 = "TP: Bloodweed 60 - (Terminus Prison 1st Floor)"
    tp_bloodweed_61 = "TP: Bloodweed 61 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_62 = "TP: Bloodweed 62 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_63 = "TP: Bloodweed 63 - (Terminus Prison 1st Floor)"
    tp_bloodweed_64 = "TP: Bloodweed 64 - (Terminus Prison 1st Floor)"
    tp_bloodweed_65 = "TP: Bloodweed 65 - (Terminus Prison 1st Floor)"
    tp_bloodweed_66 = "TP: Bloodweed 66 - (Terminus Prison 1st Floor)"
    tp_bloodweed_67 = "TP: Bloodweed 67 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_68 = "TP: Bloodweed 68 - (Terminus Prison 1st Floor)"
    tp_bloodweed_69 = "TP: Bloodweed 69 - (Terminus Prison 1st Floor)"
    tp_bloodweed_70 = "TP: Bloodweed 70 - (Terminus Prison 1st Floor)"
    tp_bloodweed_71 = "TP: Bloodweed 71 - (Terminus Prison 1st Floor)"
    tp_bloodweed_72 = "TP: Bloodweed 72 - (Terminus Prison 1st Floor)"
    tp_bloodweed_73 = "TP: Bloodweed 73 - (Terminus Prison 1st Floor)"
    tp_bloodweed_74 = "TP: Bloodweed 74 - (Terminus Prison 1st Floor)"
    tp_bloodweed_75 = "TP: Bloodweed 75 - (Terminus Prison 1st Floor)"
    tp_bloodweed_76 = "TP: Bloodweed 76 - (Terminus Prison 2nd Floor Rooms)"
    tp_bloodweed_77 = "TP: Bloodweed 77 - (Terminus Prison 1st Floor)"


class BreakLocation:
    fm_coffin_1 = "FM: Coffin 1 - (The Fetid Mire)"
    fm_coffin_2 = "FM: Coffin 2 - (The Fetid Mire)"
    fm_coffin_3 = "FM: Coffin 3 - (The Fetid Mire)"
    fm_coffin_4 = "FM: Coffin 4 - (The Fetid Mire)"
    fm_vase_1 = "FM: Vase 1 - (The Fetid Mire Lower Secrets)"
    fm_vase_2 = "FM: Vase 2 - (The Fetid Mire)"
    fm_vase_3 = "FM: Vase 3 - (The Fetid Mire)"
    fm_vase_4 = "FM: Vase 4 - (The Fetid Mire)"
    fm_vase_5 = "FM: Vase 5 - (The Fetid Mire)"
    fm_vase_6 = "FM: Vase 6 - (The Fetid Mire)"
    fm_vase_7 = "FM: Vase 7 - (The Fetid Mire)"
    fm_vase_8 = "FM: Vase 8 - (The Fetid Mire)"
    fm_vase_9 = "FM: Vase 9 - (The Fetid Mire)"
    fm_vase_10 = "FM: Vase 10 - (The Fetid Mire)"
    fm_crate_1 = "FM: Crate 1 - (The Fetid Mire Lower Secrets)"
    fm_crate_2 = "FM: Crate 2 - (The Fetid Mire Lower Secrets)"
    fm_crate_3 = "FM: Crate 3 - (The Fetid Mire Lower Secrets)"
    fm_vase_11 = "FM: Vase 11 - (The Fetid Mire)"
    fm_vase_12 = "FM: Vase 12 - (The Fetid Mire)"
    fm_vase_13 = "FM: Vase 13 - (The Fetid Mire)"
    fm_vase_14 = "FM: Vase 14 - (The Fetid Mire)"
    fm_barrel_1 = "FM: Barrel 1 - (The Fetid Mire Lower Secrets)"
    fm_barrel_2 = "FM: Barrel 2 - (The Fetid Mire Lower Secrets)"
    fm_barrel_3 = "FM: Barrel 3 - (The Fetid Mire Lower Secrets)"
    fm_vase_15 = "FM: Vase 15 - (The Fetid Mire)"
    fm_vase_16 = "FM: Vase 16 - (The Fetid Mire)"
    fm_vase_17 = "FM: Vase 17 - (The Fetid Mire)"
    fm_vase_18 = "FM: Vase 18 - (The Fetid Mire Lower Secrets)"
    fm_vase_19 = "FM: Vase 19 - (The Fetid Mire)"
    fm_vase_20 = "FM: Vase 20 - (The Fetid Mire)"
    fm_vase_21 = "FM: Vase 21 - (The Fetid Mire)"
    hb_coffin_1 = "HB: Coffin 1 - (Hollow Basin)"
    hb_coffin_2 = "HB: Coffin 2 - (Hollow Basin)"
    hb_coffin_3 = "HB: Coffin 3 - (Hollow Basin)"
    hb_coffin_4 = "HB: Coffin 4 - (Temple of Silence Front)"
    hb_coffin_5 = "HB: Coffin 5 - (Temple of Silence Front)"
    hb_coffin_6 = "HB: Coffin 6 - (Hollow Basin)"
    hb_coffin_7 = "HB: Coffin 7 - (Hollow Basin)"
    hb_coffin_8 = "HB: Coffin 8 - (Temple of Silence Front)"
    hb_coffin_9 = "HB: Coffin 9 - (Hollow Basin)"
    hb_coffin_10 = "HB: Coffin 10 - (Temple of Silence Front)"
    hb_vase_1 = "HB: Vase 1 - (Temple of Silence Front)"
    hb_vase_2 = "HB: Vase 2 - (Temple of Silence Front)"
    hb_vase_3 = "HB: Vase 3 - (Temple of Silence Back)"
    hb_vase_4 = "HB: Vase 4 - (Temple of Silence Front)"
    hb_vase_5 = "HB: Vase 5 - (Temple of Silence Front)"
    hb_vase_6 = "HB: Vase 6 - (Temple of Silence Front)"
    hb_vase_7 = "HB: Vase 7 - (Temple of Silence Front)"
    hb_vase_8 = "HB: Vase 8 - (Temple of Silence Front)"
    hb_vase_9 = "HB: Vase 9 - (Temple of Silence Front)"
    hb_vase_10 = "HB: Vase 10 - (Temple of Silence Front)"
    hb_vase_11 = "HB: Vase 11 - (Temple of Silence Front)"
    hb_vase_12 = "HB: Vase 12 - (Temple of Silence Back)"
    hb_vase_13 = "HB: Vase 13 - (Temple of Silence Back)"
    hb_vase_14 = "HB: Vase 14 - (Temple of Silence Front)"
    hb_vase_15 = "HB: Vase 15 - (Temple Locked Spot)"
    hb_vase_16 = "HB: Vase 16 - (Temple of Silence Back)"
    hb_vase_17 = "HB: Vase 17 - (Temple of Silence Front)"
    hb_vase_18 = "HB: Vase 18 - (Temple of Silence Front)"
    hb_vase_19 = "HB: Vase 19 - (Temple of Silence Back)"
    hb_vase_20 = "HB: Vase 20 - (Temple of Silence Front)"
    hb_vase_21 = "HB: Vase 21 - (Temple of Silence Front)"
    hb_vase_22 = "HB: Vase 22 - (Temple of Silence Front)"
    hb_vase_23 = "HB: Vase 23 - (Temple of Silence Front)"
    hb_vase_24 = "HB: Vase 24 - (Temple of Silence Front)"
    hb_vase_25 = "HB: Vase 25 - (Temple of Silence Front)"
    hb_vase_26 = "HB: Vase 26 - (Temple of Silence Front)"
    hb_vase_27 = "HB: Vase 27 - (Temple of Silence Front)"
    hb_vase_28 = "HB: Vase 28 - (Hollow Basin)"
    hb_vase_29 = "HB: Vase 29 - (Temple of Silence Front)"
    hb_vase_30 = "HB: Vase 30 - (Hollow Basin)"
    hb_vase_31 = "HB: Vase 31 - (Temple of Silence Front)"
    hb_vase_32 = "HB: Vase 32 - (Temple of Silence Front)"
    hb_vase_33 = "HB: Vase 33 - (Temple of Silence Front)"
    hb_vase_34 = "HB: Vase 34 - (Hollow Basin)"
    hb_vase_35 = "HB: Vase 35 - (Temple of Silence Front)"
    hb_vase_36 = "HB: Vase 36 - (Temple of Silence Front)"
    hb_vase_37 = "HB: Vase 37 - (Temple of Silence Front)"
    hb_vase_38 = "HB: Vase 38 - (Temple of Silence Lower Area)"
    hb_crate_1 = "HB: Crate 1 - (Temple of Silence Sewers)"
    hb_vase_39 = "HB: Vase 39 - (Hollow Basin)"
    hb_vase_40 = "HB: Vase 40 - (Temple of Silence Front)"
    hb_vase_41 = "HB: Vase 41 - (Temple of Silence Front)"
    hb_vase_42 = "HB: Vase 42 - (Temple of Silence Front)"
    hb_vase_43 = "HB: Vase 43 - (Temple of Silence Back)"
    hb_vase_44 = "HB: Vase 44 - (Temple of Silence Front)"
    hb_vase_45 = "HB: Vase 45 - (Temple of Silence Front)"
    hb_vase_46 = "HB: Vase 46 - (Temple of Silence Front)"
    hb_vase_47 = "HB: Vase 47 - (Temple of Silence Front)"
    hb_vase_48 = "HB: Vase 48 - (Temple of Silence Front)"
    hb_vase_49 = "HB: Vase 49 - (Temple of Silence Front)"
    hb_vase_50 = "HB: Vase 50 - (Temple of Silence Front)"
    hb_vase_51 = "HB: Vase 51 - (Temple of Silence Front)"
    hb_vase_52 = "HB: Vase 52 - (Temple of Silence Front)"
    hb_vase_53 = "HB: Vase 53 - (Temple of Silence Front)"
    hb_vase_54 = "HB: Vase 54 - (Temple of Silence Front)"
    hb_vase_55 = "HB: Vase 55 - (Temple of Silence Back)"
    hb_vase_56 = "HB: Vase 56 - (Temple of Silence Front)"
    hb_vase_57 = "HB: Vase 57 - (Temple of Silence Front)"
    hb_vase_58 = "HB: Vase 58 - (Temple of Silence Front)"
    hb_vase_59 = "HB: Vase 59 - (Temple of Silence Front)"
    hb_vase_60 = "HB: Vase 60 - (Temple of Silence Front)"
    hb_vase_61 = "HB: Vase 61 - (Hollow Basin)"
    hb_vase_62 = "HB: Vase 62 - (Temple of Silence Front)"
    hb_vase_63 = "HB: Vase 63 - (Temple of Silence Front)"
    hb_vase_64 = "HB: Vase 64 - (Temple of Silence Front)"
    hb_vase_65 = "HB: Vase 65 - (Hollow Basin)"
    hb_vase_66 = "HB: Vase 66 - (Temple of Silence Back)"
    hb_vase_67 = "HB: Vase 67 - (Temple of Silence Front)"
    hb_vase_68 = "HB: Vase 68 - (Temple of Silence Front)"
    hb_vase_69 = "HB: Vase 69 - (Temple of Silence Front)"
    hb_vase_70 = "HB: Vase 70 - (Temple of Silence Front)"
    hb_vase_71 = "HB: Vase 71 - (Temple Locked Spot)"
    hb_vase_72 = "HB: Vase 72 - (Temple of Silence Front)"
    hb_vase_73 = "HB: Vase 73 - (Temple of Silence Front)"
    hb_vase_74 = "HB: Vase 74 - (Temple of Silence Front)"
    hb_vase_75 = "HB: Vase 75 - (Temple Locked Spot)"
    hb_vase_76 = "HB: Vase 76 - (Temple of Silence Front)"
    hb_crate_2 = "HB: Crate 2 - (Temple of Silence Sewers)"
    hb_vase_77 = "HB: Vase 77 - (Hollow Basin)"
    hb_vase_78 = "HB: Vase 78 - (Temple of Silence Front)"
    hb_vase_79 = "HB: Vase 79 - (Temple of Silence Front)"
    hb_vase_80 = "HB: Vase 80 - (Temple of Silence Front)"
    hb_vase_81 = "HB: Vase 81 - (Temple of Silence Front)"
    hb_vase_82 = "HB: Vase 82 - (Temple of Silence Front)"
    hb_vase_83 = "HB: Vase 83 - (Temple of Silence Front)"
    hb_vase_84 = "HB: Vase 84 - (Temple of Silence Back)"
    hb_vase_85 = "HB: Vase 85 - (Temple of Silence Front)"
    hb_vase_86 = "HB: Vase 86 - (Temple of Silence Front)"
    hb_vase_87 = "HB: Vase 87 - (Temple of Silence Back)"
    hb_vase_88 = "HB: Vase 88 - (Temple of Silence Front)"
    hb_vase_89 = "HB: Vase 89 - (Temple of Silence Front)"
    hb_vase_90 = "HB: Vase 90 - (Temple of Silence Front)"
    hb_vase_91 = "HB: Vase 91 - (Temple of Silence Front)"
    hb_vase_92 = "HB: Vase 92 - (Temple of Silence Front)"
    hb_vase_93 = "HB: Vase 93 - (Temple of Silence Front)"
    hb_vase_94 = "HB: Vase 94 - (Temple of Silence Front)"
    hb_vase_95 = "HB: Vase 95 - (Temple of Silence Back)"
    hb_vase_96 = "HB: Vase 96 - (Temple of Silence Back)"
    hb_vase_97 = "HB: Vase 97 - (Temple of Silence Back)"
    hb_vase_98 = "HB: Vase 98 - (Temple of Silence Front)"
    hb_vase_99 = "HB: Vase 99 - (Hollow Basin)"
    hb_vase_100 = "HB: Vase 100 - (Temple of Silence Back)"
    hb_vase_101 = "HB: Vase 101 - (Temple of Silence Front)"
    hb_vase_102 = "HB: Vase 102 - (Temple of Silence Front)"
    hb_vase_103 = "HB: Vase 103 - (Temple of Silence Back)"
    hb_vase_104 = "HB: Vase 104 - (Temple of Silence Front)"
    hb_vase_105 = "HB: Vase 105 - (Hollow Basin)"
    hb_vase_106 = "HB: Vase 106 - (Temple of Silence Front)"
    hb_vase_107 = "HB: Vase 107 - (Temple Locked Spot)"
    hb_vase_108 = "HB: Vase 108 - (Temple of Silence Back)"
    sb_crate_1 = "SB: Crate 1 - (Sealed Ballroom Room Within Secret)"
    sb_crate_2 = "SB: Crate 2 - (Sealed Ballroom Room Within Secret)"
    at_coffin_1 = "AT: Coffin 1 - (Accursed Tomb)"
    at_coffin_2 = "AT: Coffin 2 - (Accursed Tomb)"
    at_coffin_3 = "AT: Coffin 3 - (Vampire Tomb)"
    at_coffin_4 = "AT: Coffin 4 - (Vampire Tomb)"
    at_coffin_5 = "AT: Coffin 5 - (Accursed Tomb)"
    at_coffin_6 = "AT: Coffin 6 - (Accursed Tomb)"
    at_coffin_7 = "AT: Coffin 7 - (Accursed Tomb)"
    at_coffin_8 = "AT: Coffin 8 - (Accursed Tomb)"
    at_coffin_9 = "AT: Coffin 9 - (Accursed Tomb)"
    at_coffin_10 = "AT: Coffin 10 - (Accursed Tomb)"
    at_coffin_11 = "AT: Coffin 11 - (Accursed Tomb)"
    at_coffin_12 = "AT: Coffin 12 - (Accursed Tomb)"
    at_coffin_13 = "AT: Coffin 13 - (Accursed Tomb)"
    at_coffin_15 = "AT: Coffin 15 - (Vampire Tomb)"
    at_coffin_16 = "AT: Coffin 16 - (Vampire Tomb)"
    at_coffin_17 = "AT: Coffin 17 - (Accursed Tomb)"
    at_coffin_18 = "AT: Coffin 18 - (Vampire Tomb)"
    at_coffin_19 = "AT: Coffin 19 - (Vampire Tomb)"
    at_coffin_20 = "AT: Coffin 20 - (Accursed Tomb)"
    at_coffin_21 = "AT: Coffin 21 - (Accursed Tomb)"
    at_coffin_22 = "AT: Coffin 22 - (Accursed Tomb)"
    at_coffin_23 = "AT: Coffin 23 - (Accursed Tomb)"
    at_coffin_24 = "AT: Coffin 24 - (Vampire Tomb)"
    at_coffin_25 = "AT: Coffin 25 - (Vampire Tomb)"
    at_coffin_26 = "AT: Coffin 26 - (Vampire Tomb)"
    at_coffin_28 = "AT: Coffin 28 - (Accursed Tomb)"
    at_coffin_29 = "AT: Coffin 29 - (Vampire Tomb)"
    at_coffin_30 = "AT: Coffin 30 - (Accursed Tomb)"
    at_coffin_31 = "AT: Coffin 31 - (Accursed Tomb)"
    at_coffin_33 = "AT: Coffin 33 - (Accursed Tomb)"
    at_coffin_34 = "AT: Coffin 34 - (Vampire Tomb)"
    at_coffin_35 = "AT: Coffin 35 - (Vampire Tomb)"
    at_coffin_36 = "AT: Coffin 36 - (Accursed Tomb)"
    hb_wood_debris_1 = "HoB: Wood Debris 1 - (Holy Battleground)"
    hb_wood_debris_2 = "HoB: Wood Debris 2 - (Holy Battleground)"
    hb_wood_debris_3 = "HoB: Wood Debris 3 - (Holy Battleground)"
    hb_wood_debris_4 = "HoB: Wood Debris 4 - (Holy Battleground)"
    hb_wood_debris_5 = "HoB: Wood Debris 5 - (Holy Battleground)"
    hb_wood_debris_6 = "HoB: Wood Debris 6 - (Holy Battleground)"
    hb_wood_debris_7 = "HoB: Wood Debris 7 - (Holy Battleground)"
    hb_wood_debris_8 = "HoB: Wood Debris 8 - (Holy Battleground)"
    hb_wood_debris_9 = "HoB: Wood Debris 9 - (Holy Battleground)"
    hb_wood_debris_10 = "HoB: Wood Debris 10 - (Holy Battleground)"
    hb_wood_debris_11 = "HoB: Wood Debris 11 - (Holy Battleground)"
    hb_wood_debris_12 = "HoB: Wood Debris 12 - (Holy Battleground)"
    hb_wood_debris_13 = "HoB: Wood Debris 13 - (Holy Battleground)"
    hb_wood_debris_14 = "HoB: Wood Debris 14 - (Holy Battleground)"
    hb_wood_debris_15 = "HoB: Wood Debris 15 - (Holy Battleground)"
    hb_wood_debris_16 = "HoB: Wood Debris 16 - (Holy Battleground)"
    hb_wood_debris_17 = "HoB: Wood Debris 17 - (Holy Battleground)"
    hb_wood_debris_18 = "HoB: Wood Debris 18 - (Holy Battleground)"
    hb_wood_debris_19 = "HoB: Wood Debris 19 - (Holy Battleground)"
    hb_wood_debris_20 = "HoB: Wood Debris 20 - (Holy Battleground)"
    hb_wood_debris_21 = "HoB: Wood Debris 21 - (Holy Battleground)"
    hb_wood_debris_22 = "HoB: Wood Debris 22 - (Holy Battleground)"
    hb_wood_debris_23 = "HoB: Wood Debris 23 - (Holy Battleground)"
    hb_wood_debris_24 = "HoB: Wood Debris 24 - (Holy Battleground)"
    hb_wood_debris_25 = "HoB: Wood Debris 25 - (Holy Battleground)"
    hb_wood_debris_26 = "HoB: Wood Debris 26 - (Holy Battleground)"
    hb_wood_debris_27 = "HoB: Wood Debris 27 - (Holy Battleground)"
    hb_wood_debris_28 = "HoB: Wood Debris 28 - (Holy Battleground)"
    hb_wood_debris_29 = "HoB: Wood Debris 29 - (Holy Battleground)"
    hb_wood_debris_30 = "HoB: Wood Debris 30 - (Holy Battleground)"
    hb_wood_debris_31 = "HoB: Wood Debris 31 - (Holy Battleground)"
    hb_wood_debris_32 = "HoB: Wood Debris 32 - (Holy Battleground)"
    hb_wood_debris_33 = "HoB: Wood Debris 33 - (Holy Battleground)"
    hb_wood_debris_34 = "HoB: Wood Debris 34 - (Holy Battleground)"
    hb_wood_debris_35 = "HoB: Wood Debris 35 - (Holy Battleground)"
    hb_wood_debris_36 = "HoB: Wood Debris 36 - (Holy Battleground)"
    hb_wood_debris_37 = "HoB: Wood Debris 37 - (Holy Battleground)"
    hb_wood_debris_38 = "HoB: Wood Debris 38 - (Holy Battleground)"
    hb_wood_debris_39 = "HoB: Wood Debris 39 - (Holy Battleground)"
    hb_wood_debris_40 = "HoB: Wood Debris 40 - (Holy Battleground)"
    hb_wood_debris_41 = "HoB: Wood Debris 41 - (Holy Battleground)"
    hb_wood_debris_42 = "HoB: Wood Debris 42 - (Holy Battleground)"
    hb_wood_debris_43 = "HoB: Wood Debris 43 - (Holy Battleground)"
    hb_wood_debris_44 = "HoB: Wood Debris 44 - (Holy Battleground)"
    hb_wood_debris_45 = "HoB: Wood Debris 45 - (Holy Battleground)"
    hb_wood_debris_46 = "HoB: Wood Debris 46 - (Holy Battleground)"
    hb_wood_debris_47 = "HoB: Wood Debris 47 - (Holy Battleground)"
    hb_wood_debris_48 = "HoB: Wood Debris 48 - (Holy Battleground)"
    hb_wood_debris_49 = "HoB: Wood Debris 49 - (Holy Battleground)"
    hb_wood_debris_50 = "HoB: Wood Debris 50 - (Holy Battleground)"
    hb_wood_debris_51 = "HoB: Wood Debris 51 - (Holy Battleground)"
    hb_wood_debris_52 = "HoB: Wood Debris 52 - (Holy Battleground)"
    hb_wood_debris_53 = "HoB: Wood Debris 53 - (Holy Battleground)"
    hb_wood_debris_54 = "HoB: Wood Debris 54 - (Holy Battleground)"
    hb_wood_debris_55 = "HoB: Wood Debris 55 - (Holy Battleground)"
    hb_wood_debris_56 = "HoB: Wood Debris 56 - (Holy Battleground)"
    hb_wood_debris_57 = "HoB: Wood Debris 57 - (Holy Battleground)"
    hb_wood_debris_58 = "HoB: Wood Debris 58 - (Holy Battleground)"
    hb_wood_debris_59 = "HoB: Wood Debris 59 - (Holy Battleground)"
    hb_wood_debris_60 = "HoB: Wood Debris 60 - (Holy Battleground)"
    hb_wood_debris_61 = "HoB: Wood Debris 61 - (Holy Battleground)"
    hb_wood_debris_62 = "HoB: Wood Debris 62 - (Holy Battleground)"
    hb_wood_debris_63 = "HoB: Wood Debris 63 - (Holy Battleground)"
    hb_wood_debris_64 = "HoB: Wood Debris 64 - (Holy Battleground)"
    hb_wood_debris_65 = "HoB: Wood Debris 65 - (Holy Battleground)"
    yf_crate_1 = "YF: Crate 1 - (Yosei Forest)"
    yf_crate_2 = "YF: Crate 2 - (Yosei Forest)"
    yf_crate_3 = "YF: Crate 3 - (Yosei Forest Lower Path)"
    yf_crate_4 = "YF: Crate 4 - (Yosei Forest)"
    yf_crate_5 = "YF: Crate 5 - (Yosei Forest)"
    yf_crate_6 = "YF: Crate 6 - (Yosei Forest)"
    yf_crate_7 = "YF: Crate 7 - (Yosei Forest)"
    yf_crate_8 = "YF: Crate 8 - (Yosei Forest)"
    yf_crate_9 = "YF: Crate 9 - (Yosei Forest)"
    yf_crate_10 = "YF: Crate 10 - (Yosei Forest)"
    yf_barrel_1 = "YF: Barrel 1 - (Yosei Forest)"
    yf_barrel_2 = "YF: Barrel 2 - (Yosei Forest)"
    yf_barrel_3 = "YF: Barrel 3 - (Yosei Forest)"
    yf_barrel_4 = "YF: Barrel 4 - (Yosei Forest)"
    yf_barrel_5 = "YF: Barrel 5 - (Yosei Forest)"
    yf_barrel_6 = "YF: Barrel 6 - (Yosei Forest)"
    yf_barrel_7 = "YF: Barrel 7 - (Yosei Forest Lower Path)"
    yf_barrel_8 = "YF: Barrel 8 - (Yosei Forest)"
    yf_barrel_9 = "YF: Barrel 9 - (Yosei Forest)"
    yf_barrel_10 = "YF: Barrel 10 - (Yosei Forest)"
    yf_crate_11 = "YF: Crate 11 - (Yosei Forest)"
    yf_crate_12 = "YF: Crate 12 - (Yosei Forest)"
    yf_crate_13 = "YF: Crate 13 - (Yosei Forest)"
    tp_coffin_1 = "TP: Coffin 1 - (Terminus Prison 1st Floor)"
    tp_coffin_2 = "TP: Coffin 2 - (Terminus Prison 1st Floor)"
    tp_coffin_3 = "TP: Coffin 3 - (Terminus Prison 1st Floor)"
    tp_coffin_4 = "TP: Coffin 4 - (Terminus Prison 1st Floor)"
    tp_coffin_5 = "TP: Coffin 5 - (Terminus Prison 1st Floor)"
    tp_coffin_6 = "TP: Coffin 6 - (Terminus Prison 1st Floor)"
    tp_coffin_7 = "TP: Coffin 7 - (Terminus Prison 1st Floor)"
    tp_coffin_8 = "TP: Coffin 8 - (Terminus Prison 1st Floor)"
    tp_coffin_9 = "TP: Coffin 9 - (Terminus Prison 1st Floor)"
    tp_coffin_10 = "TP: Coffin 10 - (Terminus Prison 1st Floor)"
    tp_coffin_11 = "TP: Coffin 11 - (Terminus Prison 1st Floor)"
    tp_coffin_12 = "TP: Coffin 12 - (Terminus Prison 1st Floor)"
    tp_coffin_13 = "TP: Coffin 13 - (Terminus Prison 1st Floor)"
    tp_coffin_14 = "TP: Coffin 14 - (Terminus Prison 1st Floor)"
    tp_coffin_15 = "TP: Coffin 15 - (Terminus Prison 1st Floor)"
    tp_coffin_16 = "TP: Coffin 16 - (Terminus Prison 1st Floor)"
    tp_coffin_17 = "TP: Coffin 17 - (Terminus Prison 1st Floor)"
    tp_coffin_18 = "TP: Coffin 18 - (Terminus Prison 1st Floor)"
    tp_coffin_19 = "TP: Coffin 19 - (Terminus Prison 1st Floor)"
    tp_coffin_20 = "TP: Coffin 20 - (Terminus Prison 1st Floor)"
    tp_coffin_21 = "TP: Coffin 21 - (Terminus Prison 1st Floor)"
    tp_coffin_22 = "TP: Coffin 22 - (Terminus Prison 1st Floor)"
    tp_vase_1 = "TP: Vase 1 - (Terminus Prison 4th Floor)"
    tp_vase_2 = "TP: Vase 2 - (Terminus Prison 3rd Floor)"
    tp_vase_3 = "TP: Vase 3 - (Terminus Prison 3rd Floor)"
    tp_vase_4 = "TP: Vase 4 - (Terminus Prison 4th Floor)"
    tp_vase_5 = "TP: Vase 5 - (Terminus Prison 3rd Floor)"
    tp_vase_6 = "TP: Vase 6 - (Terminus Prison 4th Floor)"
    tp_crate_1 = "TP: Crate 1 - (Terminus Prison 3rd Floor)"
    tp_vase_7 = "TP: Vase 7 - (Terminus Prison 3rd Floor)"
    la_vase_1 = "LA: Vase 1 - (Holy Seat of Gold)"
    la_vase_2 = "LA: Vase 2 - (Holy Seat of Gold)"
    la_vase_3 = "LA: Vase 3 - (Holy Seat of Gold)"
    la_vase_4 = "LA: Vase 4 - (Holy Seat of Gold)"
