from dataclasses import dataclass
from typing import Optional, List

from ..strings.locations import BaseLocation, ShopLocation, DropLocation, Quench, AlchemyLocation, SpookyLocation, CrimpusLocation, LevelLocation, LoreLocation, \
    GrassLocation, BreakLocation
from ..strings.regions_entrances import LunacidRegion


@dataclass(frozen=True)
class LunacidLocation:
    location_id: Optional[int]
    name: str
    region: str


all_locations = []


# Some locations vary on multiple regions, so we default to Hollow Basin first.
def create_location(location_id: Optional[int], name: str, region: Optional[str] = LunacidRegion.wings_rest):
    location = LunacidLocation(location_id, name, region)
    if location_id is not None:
        all_locations.append(location)
    return location


# Uses a structure of BASE LOCATION + type offset + pseudo value.  The base location ID will eventually be deprecated in favor of starting at 1.
LOCATION_CODE_START = 0
base_location_start = 0
wings_rest = [
    create_location(LOCATION_CODE_START + base_location_start + 1, BaseLocation.wings_rest_ocean_elixir, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + base_location_start + 2, BaseLocation.wings_rest_crystal_shard, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + base_location_start + 3, BaseLocation.wings_rest_clives_gift, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + base_location_start + 4, BaseLocation.wings_rest_demi_orb, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + base_location_start + 5, BaseLocation.wings_rest_demi_gift, LunacidRegion.wings_rest),
]

hollow_basin = [
    create_location(LOCATION_CODE_START + base_location_start + 9, BaseLocation.hollow_basin_starting_sword, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + base_location_start + 10, BaseLocation.hollow_basin_right_water_right, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + base_location_start + 11, BaseLocation.hollow_basin_right_water_left, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + base_location_start + 12, BaseLocation.hollow_basin_left_water, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + base_location_start + 13, BaseLocation.hollow_basin_demi_chest, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + base_location_start + 14, BaseLocation.hollow_basin_enchanted_door, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + base_location_start + 15, BaseLocation.hollow_basin_dark_item, LunacidRegion.temple_path),

    create_location(LOCATION_CODE_START + base_location_start + 16, BaseLocation.temple_fountain, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + base_location_start + 17, BaseLocation.temple_ritual_table, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + base_location_start + 18, BaseLocation.temple_altar_chest, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + base_location_start + 19, BaseLocation.temple_pillar_left, LunacidRegion.temple_secret),
    create_location(LOCATION_CODE_START + base_location_start + 20, BaseLocation.temple_pillar_right, LunacidRegion.temple_secret),
    create_location(LOCATION_CODE_START + base_location_start + 21, BaseLocation.temple_ritual_ring, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + base_location_start + 22, BaseLocation.temple_small_pillar, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + base_location_start + 23, BaseLocation.temple_pillar_room_left, LunacidRegion.temple_secret),
    create_location(LOCATION_CODE_START + base_location_start + 24, BaseLocation.temple_pillar_room_back_left, LunacidRegion.temple_secret),
    create_location(LOCATION_CODE_START + base_location_start + 25, BaseLocation.temple_pillar_room_back_right, LunacidRegion.temple_secret),
    create_location(LOCATION_CODE_START + base_location_start + 26, BaseLocation.temple_pillar_room_hidden_room, LunacidRegion.temple_secret),
    create_location(LOCATION_CODE_START + base_location_start + 27, BaseLocation.temple_hidden_room_in_sewer, LunacidRegion.temple_sewers_secret),
    create_location(LOCATION_CODE_START + base_location_start + 28, BaseLocation.temple_table_in_sewer, LunacidRegion.temple_sewers),
    create_location(LOCATION_CODE_START + base_location_start + 29, BaseLocation.temple_sewer_puzzle, LunacidRegion.temple_sewers),
    create_location(LOCATION_CODE_START + base_location_start + 30, BaseLocation.temple_blood_altar, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + base_location_start + 31, BaseLocation.temple_path_to_forest, LunacidRegion.temple_lower),
]

the_fetid_mire = [
    create_location(LOCATION_CODE_START + base_location_start + 37, BaseLocation.mire_room_left_foyer, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + base_location_start + 38, BaseLocation.mire_hidden_slime_chest, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 39, BaseLocation.mire_upper_overlook_left, LunacidRegion.fetid_mire_high_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 40, BaseLocation.mire_upper_overlook_right, LunacidRegion.fetid_mire_high_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 41, BaseLocation.mire_bonenard_trash, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + base_location_start + 42, BaseLocation.mire_rubble_bridge, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + base_location_start + 43, BaseLocation.mire_skeleton_chest, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + base_location_start + 44, BaseLocation.mire_jellisha_trash, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 45, BaseLocation.mire_jellisha_reward, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 46, BaseLocation.mire_path_to_sea_left, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + base_location_start + 47, BaseLocation.mire_path_to_sea_right, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + base_location_start + 48, BaseLocation.mire_hidden_chest_near_underworks, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 49, BaseLocation.mire_rubble_near_illusory_wall, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + base_location_start + 50, BaseLocation.mire_underwater_pipe, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + base_location_start + 51, BaseLocation.mire_underworks_waterfall, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + base_location_start + 52, BaseLocation.mire_underworks_skeleton, LunacidRegion.fetid_mire),
]

the_sanguine_sea = [
    create_location(LOCATION_CODE_START + base_location_start + 58, BaseLocation.sea_pillar, LunacidRegion.sanguine_sea),
    create_location(LOCATION_CODE_START + base_location_start + 59, BaseLocation.sea_underblood, LunacidRegion.sanguine_sea),
    create_location(LOCATION_CODE_START + base_location_start + 60, BaseLocation.sea_fairy_circle, LunacidRegion.sanguine_sea),
    create_location(LOCATION_CODE_START + base_location_start + 61, BaseLocation.sea_kill_jotunn, LunacidRegion.sanguine_sea)]

accursed_tomb = [
    create_location(LOCATION_CODE_START + base_location_start + 67, BaseLocation.catacombs_coffin_stairs, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + base_location_start + 68, BaseLocation.catacombs_coffin_blue_light, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + base_location_start + 69, BaseLocation.corrupted_room, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + base_location_start + 70, BaseLocation.catacombs_coffin_gate, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + base_location_start + 71, BaseLocation.catacombs_hidden_room, LunacidRegion.vampire_tomb_tape_room),
    create_location(LOCATION_CODE_START + base_location_start + 72, BaseLocation.catacombs_deep_coffin_storage, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + base_location_start + 73, BaseLocation.catacombs_restore_vampire, LunacidRegion.vampire_tomb),

    create_location(LOCATION_CODE_START + base_location_start + 74, BaseLocation.mausoleum_hidden_chest, LunacidRegion.mausoleum_secret),
    create_location(LOCATION_CODE_START + base_location_start + 75, BaseLocation.mausoleum_upper_table, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + base_location_start + 76, BaseLocation.mausoleum_maze_intro, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + base_location_start + 77, BaseLocation.mausoleum_maze_mid, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + base_location_start + 78, BaseLocation.mausoleum_center_right, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + base_location_start + 79, BaseLocation.mausoleum_center_left, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + base_location_start + 80, BaseLocation.mausoleum_center_back, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + base_location_start + 81, BaseLocation.mausoleum_center_left_path, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + base_location_start + 82, BaseLocation.mausoleum_center_right_path, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + base_location_start + 83, BaseLocation.mausoleum_kill_death, LunacidRegion.mausoleum),

    create_location(LOCATION_CODE_START + base_location_start + 84, BaseLocation.tomb_tomb_with_switch, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + base_location_start + 85, BaseLocation.tomb_tomb_with_corpse, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + base_location_start + 86, BaseLocation.tomb_demi_chest, LunacidRegion.accursed_tomb_platform),
    create_location(LOCATION_CODE_START + base_location_start + 87, BaseLocation.tomb_near_light_switch, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + base_location_start + 88, BaseLocation.tomb_hidden_room, LunacidRegion.accursed_tomb_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 89, BaseLocation.tomb_hidden_chest, LunacidRegion.accursed_tomb_secrets)
]

yosei_forest = [
    create_location(LOCATION_CODE_START + base_location_start + 94, BaseLocation.yosei_barrels, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + base_location_start + 95, BaseLocation.yosei_blood_pool, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + base_location_start + 96, BaseLocation.yosei_branch_in_tree, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + base_location_start + 97, BaseLocation.yosei_chest_near_tree, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + base_location_start + 98, BaseLocation.yosei_blood_plant_insides, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + base_location_start + 99, BaseLocation.yosei_hanging_in_trees, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + base_location_start + 100, BaseLocation.yosei_hidden_chest, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + base_location_start + 101, BaseLocation.yosei_room_defended_by_blood_plant, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + base_location_start + 102, BaseLocation.yosei_patchouli_key, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + base_location_start + 103, BaseLocation.yosei_patchouli_quest, LunacidRegion.yosei_lower),
]

forest_canopy = [
    create_location(LOCATION_CODE_START + base_location_start + 109, BaseLocation.canopy_branch_edge, LunacidRegion.forest_canopy),
    create_location(LOCATION_CODE_START + base_location_start + 110, BaseLocation.branch_cave, LunacidRegion.forest_canopy),
    create_location(LOCATION_CODE_START + base_location_start + 111, BaseLocation.canopy_chest, LunacidRegion.forest_canopy),
    create_location(LOCATION_CODE_START + base_location_start + 112, BaseLocation.canopy_wooden_statue, LunacidRegion.forest_canopy),
    create_location(LOCATION_CODE_START + base_location_start + 113, BaseLocation.canopy_wooden_sitting, LunacidRegion.forest_canopy),
]

forbidden_archives = [
    create_location(LOCATION_CODE_START + base_location_start + 119, BaseLocation.archives_back_room_past_bridge, LunacidRegion.forbidden_archives_2f),
    create_location(LOCATION_CODE_START + base_location_start + 120, BaseLocation.archives_strange_corpse, LunacidRegion.forbidden_archives_2f_secret),
    create_location(LOCATION_CODE_START + base_location_start + 121, BaseLocation.archives_against_wall_near_trees, LunacidRegion.forbidden_archives_1f_back),
    create_location(LOCATION_CODE_START + base_location_start + 122, BaseLocation.archives_short_wall_near_trees, LunacidRegion.forbidden_archives_1f_back),
    create_location(LOCATION_CODE_START + base_location_start + 123, BaseLocation.archives_snail_lectern_near, LunacidRegion.forbidden_archives_3f),
    create_location(LOCATION_CODE_START + base_location_start + 124, BaseLocation.archives_snail_lectern_far, LunacidRegion.forbidden_archives_3f),
    create_location(LOCATION_CODE_START + base_location_start + 125, BaseLocation.archives_rug_on_balcony, LunacidRegion.forbidden_archives_3f),
    create_location(LOCATION_CODE_START + base_location_start + 126, BaseLocation.archives_rooftop, LunacidRegion.forbidden_archives_3f),
    create_location(LOCATION_CODE_START + base_location_start + 127, BaseLocation.archives_hidden_room_upper, LunacidRegion.forbidden_archives_3f_secret),
    create_location(LOCATION_CODE_START + base_location_start + 128, BaseLocation.archives_hidden_room_lower, LunacidRegion.forbidden_archives_1f_front_secret),
    create_location(LOCATION_CODE_START + base_location_start + 129, BaseLocation.archives_near_twisty_tree, LunacidRegion.forbidden_archives_1f_front),
    create_location(LOCATION_CODE_START + base_location_start + 130, BaseLocation.archives_uwu, LunacidRegion.forbidden_archives_1f_front),
    create_location(LOCATION_CODE_START + base_location_start + 131, BaseLocation.archives_daedalus_one, LunacidRegion.daedalus),
    create_location(LOCATION_CODE_START + base_location_start + 132, BaseLocation.archives_daedalus_two, LunacidRegion.daedalus),
    create_location(LOCATION_CODE_START + base_location_start + 133, BaseLocation.archives_daedalus_third, LunacidRegion.daedalus),
    create_location(LOCATION_CODE_START + base_location_start + 134, BaseLocation.archives_corner_near_daedalus, LunacidRegion.forbidden_archives_1f_front),
]

castle_le_fanu = [
    create_location(LOCATION_CODE_START + base_location_start + 140, BaseLocation.castle_outside_corner, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + base_location_start + 141, BaseLocation.castle_cell_south, LunacidRegion.castle_le_fanu_cattle_prison),
    create_location(LOCATION_CODE_START + base_location_start + 142, BaseLocation.castle_cell_west, LunacidRegion.castle_le_fanu_cattle_prison),
    create_location(LOCATION_CODE_START + base_location_start + 143, BaseLocation.castle_cell_center, LunacidRegion.castle_le_fanu_cattle_prison),
    create_location(LOCATION_CODE_START + base_location_start + 144, BaseLocation.castle_cell_north, LunacidRegion.castle_le_fanu_cattle_prison_deep),
    create_location(LOCATION_CODE_START + base_location_start + 145, BaseLocation.castle_hidden_cell, LunacidRegion.castle_le_fanu_cattle_prison_secret),

    create_location(LOCATION_CODE_START + base_location_start + 146, BaseLocation.castle_hallway_rubble_room, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + base_location_start + 147, BaseLocation.castle_hallway_dining_room, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + base_location_start + 148, BaseLocation.castle_garrat_resting_room_left, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + base_location_start + 149, BaseLocation.castle_garrat_resting_room_back, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + base_location_start + 150, BaseLocation.castle_hallway_deadend_before_door, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + base_location_start + 151, BaseLocation.castle_upper_floor_coffin_small, LunacidRegion.castle_le_fanu_upstairs_area),
    create_location(LOCATION_CODE_START + base_location_start + 152, BaseLocation.castle_upper_floor_coffin_large, LunacidRegion.castle_le_fanu_upstairs_area),
    create_location(LOCATION_CODE_START + base_location_start + 153, BaseLocation.castle_upper_floor_coffin_double, LunacidRegion.castle_le_fanu_upstairs_queens_rest),
    create_location(LOCATION_CODE_START + base_location_start + 154, BaseLocation.castle_upper_floor_coffin_hallway, LunacidRegion.castle_le_fanu_cattle_prison_back),
]

sealed_ballroom = [
    create_location(LOCATION_CODE_START + base_location_start + 166, BaseLocation.ballroom_small_room_lounge, LunacidRegion.sealed_ballroom_rooms),
    create_location(LOCATION_CODE_START + base_location_start + 167, BaseLocation.ballroom_entry_hidden_couch_top, LunacidRegion.sealed_ballroom_room_within_secret),
    create_location(LOCATION_CODE_START + base_location_start + 168, BaseLocation.ballroom_entry_hidden_couch_bottom, LunacidRegion.sealed_ballroom_room_within_secret),
    create_location(LOCATION_CODE_START + base_location_start + 169, BaseLocation.ballroom_entry_hidden_cave_in_lounge, LunacidRegion.sealed_ballroom_cave_within_room),
    create_location(LOCATION_CODE_START + base_location_start + 170, BaseLocation.ballroom_entry_long_table, LunacidRegion.sealed_ballroom_rooms),
    create_location(LOCATION_CODE_START + base_location_start + 171, BaseLocation.ballroom_side_hidden_cave, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + base_location_start + 172, BaseLocation.ballroom_side_chest_near_switch, LunacidRegion.sealed_ballroom_rooms),
    create_location(LOCATION_CODE_START + base_location_start + 173, BaseLocation.ballroom_side_painting, LunacidRegion.sealed_ballroom_rooms),
    create_location(LOCATION_CODE_START + base_location_start + 174, BaseLocation.ballroom_side_hidden_casket_room, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + base_location_start + 175, BaseLocation.ballroom_side_xp_drain, LunacidRegion.sealed_ballroom_rooms),
]

laetus_chasm = [
    create_location(LOCATION_CODE_START + base_location_start + 181, BaseLocation.chasm_hidden_chest, LunacidRegion.laetus_chasm_secret),
    create_location(LOCATION_CODE_START + base_location_start + 182, BaseLocation.chasm_invisible_cliffside, LunacidRegion.laetus_chasm)
]

great_well_surface = [
    create_location(LOCATION_CODE_START + base_location_start + 188, BaseLocation.surface_demi_gift, LunacidRegion.great_well_surface)
]

throne_room = [
    create_location(LOCATION_CODE_START + base_location_start + 194, BaseLocation.throne_book, LunacidRegion.throne_chamber)
]

boiling_grotto = [
    create_location(LOCATION_CODE_START + base_location_start + 200, BaseLocation.grotto_corpse_beneath_entrance, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + base_location_start + 201, BaseLocation.grotto_slab_of_bridge, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + base_location_start + 202, BaseLocation.grotto_hidden_chest, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + base_location_start + 203, BaseLocation.grotto_triple_secret_chest, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + base_location_start + 204, BaseLocation.grotto_rocks_near_lava_switch, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + base_location_start + 205, BaseLocation.grotto_through_switch_tunnel, LunacidRegion.boiling_grotto),

    create_location(LOCATION_CODE_START + base_location_start + 206, BaseLocation.sand_top_right_sarcophagus, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 207, BaseLocation.sand_second_floor_snake, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 208, BaseLocation.sand_basement_snake_pit, LunacidRegion.deep_snake_pit),
    create_location(LOCATION_CODE_START + base_location_start + 209, BaseLocation.sand_room_buried_in_sand, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 210, BaseLocation.sand_basement_rubble, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 211, BaseLocation.sand_hidden_sarcophagus, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 212, BaseLocation.sand_second_floor_dead_end, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 213, BaseLocation.sand_lunacid_sandwich, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 214, BaseLocation.sand_chest_near_switch, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 215, BaseLocation.sand_chest_overlooking_crypt, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 216, BaseLocation.sand_switch_maze, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + base_location_start + 217, BaseLocation.sand_triple_sarcophagus, LunacidRegion.sand_temple),
]

tower_of_abyss = [
    create_location(LOCATION_CODE_START + base_location_start + 222, BaseLocation.abyss_prize, LunacidRegion.tower_of_abyss_finish),
    create_location(LOCATION_CODE_START + base_location_start + 223, BaseLocation.abyss_floor_5, LunacidRegion.tower_of_abyss_5f),
    create_location(LOCATION_CODE_START + base_location_start + 224, BaseLocation.abyss_floor_10, LunacidRegion.tower_of_abyss_10f),
    create_location(LOCATION_CODE_START + base_location_start + 225, BaseLocation.abyss_floor_15, LunacidRegion.tower_of_abyss_15f),
    create_location(LOCATION_CODE_START + base_location_start + 226, BaseLocation.abyss_floor_20, LunacidRegion.tower_of_abyss_20f),
    create_location(LOCATION_CODE_START + base_location_start + 227, BaseLocation.abyss_floor_25, LunacidRegion.tower_of_abyss_25f),
    create_location(LOCATION_CODE_START + base_location_start + 228, BaseLocation.abyss_floor_30, LunacidRegion.tower_of_abyss_30f),
    create_location(LOCATION_CODE_START + base_location_start + 229, BaseLocation.abyss_floor_35, LunacidRegion.tower_of_abyss_35f),
    create_location(LOCATION_CODE_START + base_location_start + 230, BaseLocation.abyss_floor_40, LunacidRegion.tower_of_abyss_40f),
    create_location(LOCATION_CODE_START + base_location_start + 231, BaseLocation.abyss_floor_45, LunacidRegion.tower_of_abyss_45f),
    create_location(LOCATION_CODE_START + base_location_start + 232, BaseLocation.abyss_floor_50, LunacidRegion.tower_of_abyss_50f),
    create_location(LOCATION_CODE_START + base_location_start + 233, BaseLocation.abyss_heal_5, LunacidRegion.tower_of_abyss_5f),
    create_location(LOCATION_CODE_START + base_location_start + 234, BaseLocation.abyss_crystal_5, LunacidRegion.tower_of_abyss_5f),
    create_location(LOCATION_CODE_START + base_location_start + 235, BaseLocation.abyss_heal_10, LunacidRegion.tower_of_abyss_10f),
    create_location(LOCATION_CODE_START + base_location_start + 236, BaseLocation.abyss_crystal_10, LunacidRegion.tower_of_abyss_10f),
    create_location(LOCATION_CODE_START + base_location_start + 237, BaseLocation.abyss_heal_15, LunacidRegion.tower_of_abyss_15f),
    create_location(LOCATION_CODE_START + base_location_start + 238, BaseLocation.abyss_crystal_15, LunacidRegion.tower_of_abyss_15f),
    create_location(LOCATION_CODE_START + base_location_start + 239, BaseLocation.abyss_heal_20, LunacidRegion.tower_of_abyss_20f),
    create_location(LOCATION_CODE_START + base_location_start + 240, BaseLocation.abyss_crystal_20, LunacidRegion.tower_of_abyss_20f),
    create_location(LOCATION_CODE_START + base_location_start + 241, BaseLocation.abyss_heal_25, LunacidRegion.tower_of_abyss_25f),
    create_location(LOCATION_CODE_START + base_location_start + 242, BaseLocation.abyss_crystal_25, LunacidRegion.tower_of_abyss_25f),
    create_location(LOCATION_CODE_START + base_location_start + 243, BaseLocation.abyss_heal_30, LunacidRegion.tower_of_abyss_30f),
    create_location(LOCATION_CODE_START + base_location_start + 244, BaseLocation.abyss_crystal_30, LunacidRegion.tower_of_abyss_30f),
    create_location(LOCATION_CODE_START + base_location_start + 245, BaseLocation.abyss_heal_35, LunacidRegion.tower_of_abyss_35f),
    create_location(LOCATION_CODE_START + base_location_start + 246, BaseLocation.abyss_crystal_35, LunacidRegion.tower_of_abyss_35f),
    create_location(LOCATION_CODE_START + base_location_start + 247, BaseLocation.abyss_heal_40, LunacidRegion.tower_of_abyss_40f),
    create_location(LOCATION_CODE_START + base_location_start + 248, BaseLocation.abyss_crystal_40, LunacidRegion.tower_of_abyss_40f),
    create_location(LOCATION_CODE_START + base_location_start + 249, BaseLocation.abyss_heal_45, LunacidRegion.tower_of_abyss_45f),
    create_location(LOCATION_CODE_START + base_location_start + 250, BaseLocation.abyss_crystal_45, LunacidRegion.tower_of_abyss_45f),
    create_location(LOCATION_CODE_START + base_location_start + 251, BaseLocation.abyss_heal_50, LunacidRegion.tower_of_abyss_50f),
    create_location(LOCATION_CODE_START + base_location_start + 252, BaseLocation.abyss_crystal_50, LunacidRegion.tower_of_abyss_50f),

]

terminus_prison = [
    create_location(LOCATION_CODE_START + base_location_start + 258, BaseLocation.prison_f3_locked_left, LunacidRegion.terminus_prison_3f_rooms),
    create_location(LOCATION_CODE_START + base_location_start + 259, BaseLocation.prison_f3_locked_right, LunacidRegion.terminus_prison_3f_rooms),
    create_location(LOCATION_CODE_START + base_location_start + 260, BaseLocation.prison_f3_locked_south, LunacidRegion.terminus_prison_3f_rooms),
    create_location(LOCATION_CODE_START + base_location_start + 261, BaseLocation.prison_f3_bottomless_pit, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + base_location_start + 262, BaseLocation.prison_f2_broken_cell, LunacidRegion.terminus_prison_2f),
    create_location(LOCATION_CODE_START + base_location_start + 263, BaseLocation.prison_f2_jailer_table, LunacidRegion.terminus_prison_2f),
    create_location(LOCATION_CODE_START + base_location_start + 264, BaseLocation.prison_f1_hidden_cell, LunacidRegion.terminus_prison_1f_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 265, BaseLocation.prison_f1_hidden_debris_room, LunacidRegion.terminus_prison_1f_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 266, BaseLocation.prison_f1_remains, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + base_location_start + 267, BaseLocation.prison_b2_guarded_corner_one, LunacidRegion.terminus_prison_basement),
    create_location(LOCATION_CODE_START + base_location_start + 268, BaseLocation.prison_b2_guarded_corner_two, LunacidRegion.terminus_prison_basement),
    create_location(LOCATION_CODE_START + base_location_start + 269, BaseLocation.prison_b2_deep_alcove, LunacidRegion.terminus_prison_basement),
    create_location(LOCATION_CODE_START + base_location_start + 270, BaseLocation.prison_b2_bone_pit, LunacidRegion.terminus_prison_basement),
    create_location(LOCATION_CODE_START + base_location_start + 271, BaseLocation.prison_f4_hanging, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + base_location_start + 272, BaseLocation.prison_f4_maledictus_secret, LunacidRegion.terminus_prison_4f_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 273, BaseLocation.prison_f4_hidden_beds, LunacidRegion.terminus_prison_4f_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 274, BaseLocation.prison_f4_jailer_break_room, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + base_location_start + 275, BaseLocation.prison_f4_monk_room_one, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + base_location_start + 276, BaseLocation.prison_f4_monk_room_two, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + base_location_start + 277, BaseLocation.prison_f4_monk_room_three, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + base_location_start + 278, BaseLocation.prison_f4_collapsed_tunnel, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + base_location_start + 279, BaseLocation.prison_b2_egg_resting_place, LunacidRegion.terminus_prison_basement),
]

forlorn_arena = [
    create_location(LOCATION_CODE_START + base_location_start + 284, BaseLocation.arena_broken_sword, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + base_location_start + 285, BaseLocation.arena_rock_parkour, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + base_location_start + 286, BaseLocation.arena_earth_hidden_plant_haven, LunacidRegion.temple_of_earth_secret),
    create_location(LOCATION_CODE_START + base_location_start + 287, BaseLocation.arena_earth_hidden_room, LunacidRegion.temple_of_earth_secret),
    create_location(LOCATION_CODE_START + base_location_start + 288, BaseLocation.arena_earth_earthen_temple, LunacidRegion.temple_of_earth_secret),
    create_location(LOCATION_CODE_START + base_location_start + 289, BaseLocation.arena_earth_chest_near_switch, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + base_location_start + 290, BaseLocation.arena_water_room_near_water, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + base_location_start + 291, BaseLocation.arena_water_dead_end_near_water, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + base_location_start + 292, BaseLocation.arena_water_collapsed_end_near_balcony, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + base_location_start + 293, BaseLocation.arena_water_hidden_basement_left, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 294, BaseLocation.arena_water_hidden_basement_right, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 295, BaseLocation.arena_water_hidden_laser_room, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 296, BaseLocation.arena_water_hidden_alcove_before, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 297, BaseLocation.arena_water_hidden_alcove_left, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 298, BaseLocation.arena_water_hidden_alcove_right, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 299, BaseLocation.arena_water_hidden_alcove_before_switch, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 300, BaseLocation.arena_water_underwater_temple, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + base_location_start + 301, BaseLocation.arena_water_chest_near_switch, LunacidRegion.temple_of_water_lower),
]

labyrinth_of_ash = [
    create_location(LOCATION_CODE_START + base_location_start + 307, BaseLocation.ash_entry_coffin, LunacidRegion.labyrinth_of_ash),
    create_location(LOCATION_CODE_START + base_location_start + 308, BaseLocation.ash_giant_remains, LunacidRegion.labyrinth_interior),
    create_location(LOCATION_CODE_START + base_location_start + 309, BaseLocation.ash_cetea_statue, LunacidRegion.labyrinth_interior),
    create_location(LOCATION_CODE_START + base_location_start + 310, BaseLocation.ash_rocks_near_switch, LunacidRegion.labyrinth_interior),
    create_location(LOCATION_CODE_START + base_location_start + 311, BaseLocation.ash_forbidden_light_chest, LunacidRegion.holy_seat_of_gold),
    create_location(LOCATION_CODE_START + base_location_start + 312, BaseLocation.ash_hidden_chest, LunacidRegion.holy_seat_of_secret),
    create_location(LOCATION_CODE_START + base_location_start + 313, BaseLocation.ash_path_maze, LunacidRegion.labyrinth_secret),
]

chamber_of_fate = [
    create_location(LOCATION_CODE_START + base_location_start + 319, BaseLocation.fate_lucid_blade, LunacidRegion.chamber_of_fate)
]

base_locations = wings_rest + hollow_basin + great_well_surface + the_fetid_mire + the_sanguine_sea + accursed_tomb + yosei_forest + \
                 forest_canopy + forbidden_archives + castle_le_fanu + sealed_ballroom + laetus_chasm + throne_room + boiling_grotto + \
                 tower_of_abyss + terminus_prison + forlorn_arena + labyrinth_of_ash + chamber_of_fate
base_items: List[str] = []

shop_location_start = 350
shop_locations = [
    create_location(LOCATION_CODE_START + shop_location_start + 1, ShopLocation.buy_rapier, LunacidRegion.sheryl),
    create_location(LOCATION_CODE_START + shop_location_start + 2, ShopLocation.buy_crossbow, LunacidRegion.sheryl),
    create_location(LOCATION_CODE_START + shop_location_start + 3, ShopLocation.buy_oil_lantern, LunacidRegion.sheryl),
    create_location(LOCATION_CODE_START + shop_location_start + 4, ShopLocation.buy_enchanted_key, LunacidRegion.sheryl),
    create_location(LOCATION_CODE_START + shop_location_start + 5, ShopLocation.buy_jotunn_slayer, LunacidRegion.sheryl),
    create_location(LOCATION_CODE_START + shop_location_start + 6, ShopLocation.buy_privateer_musket, LunacidRegion.sheryl),
    create_location(LOCATION_CODE_START + shop_location_start + 7, ShopLocation.buy_steel_needle, LunacidRegion.sheryl),
    create_location(LOCATION_CODE_START + shop_location_start + 9, ShopLocation.buy_ocean_elixir_patchouli, LunacidRegion.patchouli),
]

unique_drop_location_start = 400
unique_drop_locations = [
    create_location(LOCATION_CODE_START + unique_drop_location_start + 1, DropLocation.snail),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 2, DropLocation.mummy_knight),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 3, DropLocation.kodama_drop),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 4, DropLocation.chimera_drop),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 5, DropLocation.milk_snail),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 6, DropLocation.skeleton_weapon),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 7, DropLocation.skeleton_spell),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 8, DropLocation.phantom),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 9, DropLocation.obsidian_skeleton_drop_1),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 10, DropLocation.obsidian_skeleton_drop_2),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 11, DropLocation.anpu_drop_1),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 12, DropLocation.anpu_drop_2),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 13, DropLocation.horse_drop),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 14, DropLocation.jailor_drop),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 15, DropLocation.vampire_drop),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 16, DropLocation.sucsarian_drop_1),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 17, DropLocation.sucsarian_drop_2),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 18, DropLocation.giant_spell),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 19, DropLocation.cetea_drop),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 20, DropLocation.sea_demon),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 21, DropLocation.lupine_spell),
    create_location(LOCATION_CODE_START + unique_drop_location_start + 22, DropLocation.sanguis_book),
]

other_drop_location_start = 450
other_drop_locations = [
    create_location(LOCATION_CODE_START + other_drop_location_start + 1, DropLocation.snail_2c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 2, DropLocation.snail_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 3, DropLocation.snail_ocean),
    create_location(LOCATION_CODE_START + other_drop_location_start + 4, DropLocation.milk_5c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 5, DropLocation.milk_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 6, DropLocation.milk_ocean),
    create_location(LOCATION_CODE_START + other_drop_location_start + 7, DropLocation.shulker_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 8, DropLocation.shulker_onyx),
    create_location(LOCATION_CODE_START + other_drop_location_start + 9, DropLocation.mummy_mana_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 10, DropLocation.mummy_onyx),
    create_location(LOCATION_CODE_START + other_drop_location_start + 11, DropLocation.mummy_2c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 12, DropLocation.mummy_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 13, DropLocation.necronomicon_fire_opal),
    create_location(LOCATION_CODE_START + other_drop_location_start + 14, DropLocation.necronomicon_5c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 15, DropLocation.necronomicon_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 16, DropLocation.necronomicon_mana_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 17, DropLocation.chimera_light_urn),
    create_location(LOCATION_CODE_START + other_drop_location_start + 18, DropLocation.chimera_holy_water),
    create_location(LOCATION_CODE_START + other_drop_location_start + 19, DropLocation.enlightened_mana_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 20, DropLocation.enlightened_ocean_bone_shell),
    create_location(LOCATION_CODE_START + other_drop_location_start + 21, DropLocation.slime_skeleton),
    create_location(LOCATION_CODE_START + other_drop_location_start + 22, DropLocation.skeleton_2c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 23, DropLocation.skeleton_mana_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 24, DropLocation.skeleton_onyx),
    create_location(LOCATION_CODE_START + other_drop_location_start + 25, DropLocation.skeleton_bones),
    create_location(LOCATION_CODE_START + other_drop_location_start + 26, DropLocation.rat_king_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 27, DropLocation.rat_king_lotus_seed),
    create_location(LOCATION_CODE_START + other_drop_location_start + 28, DropLocation.rat),
    create_location(LOCATION_CODE_START + other_drop_location_start + 29, DropLocation.kodama_2c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 30, DropLocation.kodama_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 31, DropLocation.kodama_opal),
    create_location(LOCATION_CODE_START + other_drop_location_start + 32, DropLocation.yakul_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 33, DropLocation.yakul_fire_opal),
    create_location(LOCATION_CODE_START + other_drop_location_start + 34, DropLocation.yakul_opal),
    create_location(LOCATION_CODE_START + other_drop_location_start + 35, DropLocation.yakul_health_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 36, DropLocation.venus_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 37, DropLocation.venus_yellow_morel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 38, DropLocation.venus_dest_angel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 39, DropLocation.neptune_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 40, DropLocation.neptune_yellow_morel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 41, DropLocation.neptune_dest_angel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 42, DropLocation.unilateralis_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 43, DropLocation.unilateralis_yellow_morel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 44, DropLocation.unilateralis_dest_angel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 45, DropLocation.hemalith_health_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 46, DropLocation.hemalith_shrimp),
    create_location(LOCATION_CODE_START + other_drop_location_start + 47, DropLocation.hemallith_bloodweed),
    create_location(LOCATION_CODE_START + other_drop_location_start + 48, DropLocation.mi_go_ocean_bone_shell),
    create_location(LOCATION_CODE_START + other_drop_location_start + 49, DropLocation.mi_go_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 50, DropLocation.mi_go_snowflake_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 51, DropLocation.mare_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 52, DropLocation.mare_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 53, DropLocation.mare_onyx),
    create_location(LOCATION_CODE_START + other_drop_location_start + 54, DropLocation.painting_fire_opal),
    create_location(LOCATION_CODE_START + other_drop_location_start + 55, DropLocation.painting_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 56, DropLocation.painting_mana_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 57, DropLocation.painting_20c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 58, DropLocation.phantom_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 59, DropLocation.phantom_holy_water),
    create_location(LOCATION_CODE_START + other_drop_location_start + 60, DropLocation.phantom_moon_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 61, DropLocation.phantom_ectoplasm),
    create_location(LOCATION_CODE_START + other_drop_location_start + 62, DropLocation.vampire_5c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 63, DropLocation.vampire_vampiric_ashes),
    create_location(LOCATION_CODE_START + other_drop_location_start + 64, DropLocation.vampire_bandage),
    create_location(LOCATION_CODE_START + other_drop_location_start + 65, DropLocation.vampire_page_ashes),
    create_location(LOCATION_CODE_START + other_drop_location_start + 66, DropLocation.vampire_page_20c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 67, DropLocation.malformed_vampiric_ashes),
    create_location(LOCATION_CODE_START + other_drop_location_start + 68, DropLocation.great_bat_health_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 69, DropLocation.great_bat_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 70, DropLocation.great_bat_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 71, DropLocation.poltergeist_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 72, DropLocation.poltergeist_ectoplasm),
    create_location(LOCATION_CODE_START + other_drop_location_start + 73, DropLocation.horse_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 74, DropLocation.horse_mana_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 75, DropLocation.hallowed_husk_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 76, DropLocation.hallowed_husk_bones),
    create_location(LOCATION_CODE_START + other_drop_location_start + 77, DropLocation.hallowed_husk_bandage),
    create_location(LOCATION_CODE_START + other_drop_location_start + 78, DropLocation.hallowed_husk_light_urn),
    create_location(LOCATION_CODE_START + other_drop_location_start + 79, DropLocation.hallowed_husk_goldeness),
    create_location(LOCATION_CODE_START + other_drop_location_start + 80, DropLocation.hallowed_husk_holy_water),
    create_location(LOCATION_CODE_START + other_drop_location_start + 81, DropLocation.ikkurilb_root),
    create_location(LOCATION_CODE_START + other_drop_location_start + 82, DropLocation.ikkurilb_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 83, DropLocation.ikkurilb_snowflake_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 84, DropLocation.mimic_moon_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 85, DropLocation.mimic_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 86, DropLocation.mimic_fools_gold),
    create_location(LOCATION_CODE_START + other_drop_location_start + 87, DropLocation.obsidian_skeleton_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 88, DropLocation.obsidian_skeleton_bones),
    create_location(LOCATION_CODE_START + other_drop_location_start + 89, DropLocation.obsidian_skeleton_mana_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 90, DropLocation.obsidian_skeleton_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 91, DropLocation.anpu_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 92, DropLocation.anpu_fire_opal),
    create_location(LOCATION_CODE_START + other_drop_location_start + 93, DropLocation.serpent_antidote),
    create_location(LOCATION_CODE_START + other_drop_location_start + 94, DropLocation.serpent_5c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 95, DropLocation.embalmed_bandage),
    create_location(LOCATION_CODE_START + other_drop_location_start + 96, DropLocation.embalmed_ashes),
    create_location(LOCATION_CODE_START + other_drop_location_start + 97, DropLocation.embalmed_bones),
    create_location(LOCATION_CODE_START + other_drop_location_start + 98, DropLocation.jailor_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 99, DropLocation.jailor_candle),
    create_location(LOCATION_CODE_START + other_drop_location_start + 100, DropLocation.jailor_bandage),
    create_location(LOCATION_CODE_START + other_drop_location_start + 101, DropLocation.jailor_health_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 102, DropLocation.jailor_angel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 103, DropLocation.lunam_ectoplasm),
    create_location(LOCATION_CODE_START + other_drop_location_start + 104, DropLocation.lunam_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 105, DropLocation.lunam_snowflake_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 106, DropLocation.giant_dark_urn),
    create_location(LOCATION_CODE_START + other_drop_location_start + 107, DropLocation.giant_bones),
    create_location(LOCATION_CODE_START + other_drop_location_start + 108, DropLocation.giant_mana_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 109, DropLocation.giant_onyx),
    create_location(LOCATION_CODE_START + other_drop_location_start + 110, DropLocation.sucsarian_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 111, DropLocation.sucsarian_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 112, DropLocation.sucsarian_snowflake_obsidian),
    create_location(LOCATION_CODE_START + other_drop_location_start + 113, DropLocation.sucsarian_throwing_knife),
    create_location(LOCATION_CODE_START + other_drop_location_start + 114, DropLocation.vesta_fairy_moss),
    create_location(LOCATION_CODE_START + other_drop_location_start + 115, DropLocation.vesta_yellow_morel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 116, DropLocation.vesta_dest_angel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 117, DropLocation.ceres_fairy_moss),
    create_location(LOCATION_CODE_START + other_drop_location_start + 118, DropLocation.ceres_yellow_morel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 119, DropLocation.ceres_dest_angel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 120, DropLocation.gloom_fairy_moss),
    create_location(LOCATION_CODE_START + other_drop_location_start + 121, DropLocation.gloom_health_vial),
    create_location(LOCATION_CODE_START + other_drop_location_start + 122, DropLocation.gloom_dest_angel),
    create_location(LOCATION_CODE_START + other_drop_location_start + 123, DropLocation.cetea_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 124, DropLocation.cetea_ocean_bone_shell),
    create_location(LOCATION_CODE_START + other_drop_location_start + 125, DropLocation.mummy_knight_onyx),
    create_location(LOCATION_CODE_START + other_drop_location_start + 126, DropLocation.mummy_knight_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 127, DropLocation.mummy_knight_5c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 129, DropLocation.lupine_10c),
    create_location(LOCATION_CODE_START + other_drop_location_start + 130, DropLocation.lupine_onyx),
    create_location(LOCATION_CODE_START + other_drop_location_start + 131, DropLocation.lupine_bones),
    create_location(LOCATION_CODE_START + other_drop_location_start + 132, DropLocation.infested_bones),
    create_location(LOCATION_CODE_START + other_drop_location_start + 133, DropLocation.infested_antidote),
    create_location(LOCATION_CODE_START + other_drop_location_start + 134, DropLocation.skeleton_10c)

]

quench_location_start = 600
quench_locations = [
    create_location(LOCATION_CODE_START + quench_location_start + 1, Quench.steel_claw, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 2, Quench.iron_claw, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 3, Quench.iron_club, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 4, Quench.stone_club, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 5, Quench.torch, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 6, Quench.brittle_arming_sword, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 7, Quench.broken_hilt, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 8, Quench.broken_lance, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 9, Quench.crossbow, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 10, Quench.elfen_sword, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 11, Quench.lyrian_longsword, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 12, Quench.obsidian_seal, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 13, Quench.obsidian_cursebrand, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 14, Quench.obsidian_poisonguard, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 15, Quench.rapier, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 16, Quench.replica_sword, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 17, Quench.rusted_sword, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 18, Quench.shadow_blade, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 19, Quench.shining_blade, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + quench_location_start + 20, Quench.scythe, LunacidRegion.wings_rest),
]

alchemy_location_start = 650
alchemy_locations = [
    create_location(LOCATION_CODE_START + alchemy_location_start + 1, AlchemyLocation.moonlight, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 2, AlchemyLocation.spectral, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 3, AlchemyLocation.explosives, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 4, AlchemyLocation.poison_knife, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 5, AlchemyLocation.staff_of_osiris, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 6, AlchemyLocation.poison_urn, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 7, AlchemyLocation.fairy_moss, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 8, AlchemyLocation.antidote, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 9, AlchemyLocation.banner, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 10, AlchemyLocation.health, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 11, AlchemyLocation.holy, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 12, AlchemyLocation.knife, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 13, AlchemyLocation.limbo, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 14, AlchemyLocation.mana, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 15, AlchemyLocation.warp, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + alchemy_location_start + 16, AlchemyLocation.wisp, LunacidRegion.wings_rest),
]

spooky_location_start = 700
spooky_locations = [
    create_location(LOCATION_CODE_START + spooky_location_start + 1, SpookyLocation.rest, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + spooky_location_start + 2, SpookyLocation.jellisha, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + spooky_location_start + 3, SpookyLocation.patchouli, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + spooky_location_start + 4, SpookyLocation.le_fanu, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + spooky_location_start + 5, SpookyLocation.daedalus, LunacidRegion.forbidden_archives_1f_front),
    create_location(LOCATION_CODE_START + spooky_location_start + 6, SpookyLocation.lava, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + spooky_location_start + 7, SpookyLocation.lobos, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + spooky_location_start + 8, SpookyLocation.spooky_spell, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + spooky_location_start + 9, SpookyLocation.headless_horseman, LunacidRegion.fetid_mire),
]

crimpus_location_start = 750
crimpus_locations = [
    create_location(LOCATION_CODE_START + crimpus_location_start + 1, CrimpusLocation.wings_rest_present, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + crimpus_location_start + 2, CrimpusLocation.yosei_patchouli_eggnog, LunacidRegion.yosei_lower)
]

level_location_start = 800
level_locations = [
    create_location(LOCATION_CODE_START + level_location_start + 1, LevelLocation.level_1, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 2, LevelLocation.level_2, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 3, LevelLocation.level_3, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 4, LevelLocation.level_4, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 5, LevelLocation.level_5, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 6, LevelLocation.level_6, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 7, LevelLocation.level_7, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 8, LevelLocation.level_8, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 9, LevelLocation.level_9, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 10, LevelLocation.level_10, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 11, LevelLocation.level_11, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 12, LevelLocation.level_12, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 13, LevelLocation.level_13, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 14, LevelLocation.level_14, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 15, LevelLocation.level_15, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 16, LevelLocation.level_16, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 17, LevelLocation.level_17, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 18, LevelLocation.level_18, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 19, LevelLocation.level_19, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 20, LevelLocation.level_20, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 21, LevelLocation.level_21, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 22, LevelLocation.level_22, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 23, LevelLocation.level_23, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 24, LevelLocation.level_24, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 25, LevelLocation.level_25, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 26, LevelLocation.level_26, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 27, LevelLocation.level_27, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 28, LevelLocation.level_28, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 29, LevelLocation.level_29, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 30, LevelLocation.level_30, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 31, LevelLocation.level_31, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 32, LevelLocation.level_32, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 33, LevelLocation.level_33, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 34, LevelLocation.level_34, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 35, LevelLocation.level_35, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 36, LevelLocation.level_36, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 37, LevelLocation.level_37, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 38, LevelLocation.level_38, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 39, LevelLocation.level_39, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 40, LevelLocation.level_40, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 41, LevelLocation.level_41, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 42, LevelLocation.level_42, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 43, LevelLocation.level_43, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 44, LevelLocation.level_44, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 45, LevelLocation.level_45, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 46, LevelLocation.level_46, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 47, LevelLocation.level_47, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 48, LevelLocation.level_48, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 49, LevelLocation.level_49, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 50, LevelLocation.level_50, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 51, LevelLocation.level_51, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 52, LevelLocation.level_52, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 53, LevelLocation.level_53, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 54, LevelLocation.level_54, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 55, LevelLocation.level_55, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 56, LevelLocation.level_56, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 57, LevelLocation.level_57, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 58, LevelLocation.level_58, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 59, LevelLocation.level_59, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 60, LevelLocation.level_60, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 61, LevelLocation.level_61, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 62, LevelLocation.level_62, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 63, LevelLocation.level_63, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 64, LevelLocation.level_64, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 65, LevelLocation.level_65, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 66, LevelLocation.level_66, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 67, LevelLocation.level_67, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 68, LevelLocation.level_68, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 69, LevelLocation.level_69, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 70, LevelLocation.level_70, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 71, LevelLocation.level_71, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 72, LevelLocation.level_72, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 73, LevelLocation.level_73, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 74, LevelLocation.level_74, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 75, LevelLocation.level_75, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 76, LevelLocation.level_76, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 77, LevelLocation.level_77, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 78, LevelLocation.level_78, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 79, LevelLocation.level_79, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 80, LevelLocation.level_80, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 81, LevelLocation.level_81, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 82, LevelLocation.level_82, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 83, LevelLocation.level_83, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 84, LevelLocation.level_84, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 85, LevelLocation.level_85, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 86, LevelLocation.level_86, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 87, LevelLocation.level_87, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 88, LevelLocation.level_88, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 89, LevelLocation.level_89, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 90, LevelLocation.level_90, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 91, LevelLocation.level_91, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 92, LevelLocation.level_92, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 93, LevelLocation.level_93, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 94, LevelLocation.level_94, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 95, LevelLocation.level_95, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 96, LevelLocation.level_96, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 97, LevelLocation.level_97, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 98, LevelLocation.level_98, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 99, LevelLocation.level_99, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + level_location_start + 100, LevelLocation.level_100, LunacidRegion.wings_rest),
]

# Areas are NOT accurate.
lore_location_start = 950
lore_locations = [
    create_location(LOCATION_CODE_START + lore_location_start + 1, LoreLocation.jusztina_1, LunacidRegion.castle_le_fanu_upstairs_area),
    create_location(LOCATION_CODE_START + lore_location_start + 2, LoreLocation.jusztina_2, LunacidRegion.castle_le_fanu_upstairs_area),
    create_location(LOCATION_CODE_START + lore_location_start + 3, LoreLocation.jusztina_letter, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + lore_location_start + 4, LoreLocation.ophelia_1, LunacidRegion.castle_le_fanu_upstairs_queens_rest),
    create_location(LOCATION_CODE_START + lore_location_start + 5, LoreLocation.clf_report, LunacidRegion.castle_le_fanu_upstairs_area),
    create_location(LOCATION_CODE_START + lore_location_start + 6, LoreLocation.ophelia_2, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + lore_location_start + 7, LoreLocation.golden_plea, LunacidRegion.castle_le_fanu_cattle_prison),
    create_location(LOCATION_CODE_START + lore_location_start + 8, LoreLocation.holy_relic, LunacidRegion.castle_le_fanu_cattle_prison_secret),
    create_location(LOCATION_CODE_START + lore_location_start + 9, LoreLocation.ophelia_statue, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + lore_location_start + 10, LoreLocation.bestial, LunacidRegion.laetus_chasm_upper),
    create_location(LOCATION_CODE_START + lore_location_start + 11, LoreLocation.invisible_walkway, LunacidRegion.laetus_chasm_upper),
    create_location(LOCATION_CODE_START + lore_location_start + 12, LoreLocation.curse_seeker, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + lore_location_start + 13, LoreLocation.power_seeker, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + lore_location_start + 14, LoreLocation.on_sucsarians, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + lore_location_start + 15, LoreLocation.too_human, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + lore_location_start + 16, LoreLocation.calamis_1, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + lore_location_start + 17, LoreLocation.calamis_2, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + lore_location_start + 18, LoreLocation.calamis_3, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + lore_location_start + 19, LoreLocation.jeff_david, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + lore_location_start + 20, LoreLocation.hicket_story, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + lore_location_start + 21, LoreLocation.calamis_4, LunacidRegion.sand_temple),
    create_location(LOCATION_CODE_START + lore_location_start + 22, LoreLocation.hicket, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + lore_location_start + 23, LoreLocation.moon, LunacidRegion.wings_rest),
    create_location(LOCATION_CODE_START + lore_location_start + 24, LoreLocation.cultist_body, LunacidRegion.temple_secret),
    create_location(LOCATION_CODE_START + lore_location_start + 25, LoreLocation.you_know, LunacidRegion.temple_sewers_secret),
    create_location(LOCATION_CODE_START + lore_location_start + 26, LoreLocation.acidic_fruit, LunacidRegion.temple_front_secret),
    create_location(LOCATION_CODE_START + lore_location_start + 27, LoreLocation.seek_creature, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + lore_location_start + 28, LoreLocation.to_hunger, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + lore_location_start + 29, LoreLocation.autopsy, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + lore_location_start + 30, LoreLocation.cultist, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + lore_location_start + 31, LoreLocation.sword_fight, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + lore_location_start + 32, LoreLocation.bonenard, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + lore_location_start + 33, LoreLocation.no_fire, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + lore_location_start + 34, LoreLocation.invader, LunacidRegion.sealed_ballroom_cave_within_room),
    create_location(LOCATION_CODE_START + lore_location_start + 35, LoreLocation.vampire_complain, LunacidRegion.sealed_ballroom),
    create_location(LOCATION_CODE_START + lore_location_start + 36, LoreLocation.holy, LunacidRegion.sealed_ballroom_rooms),
    create_location(LOCATION_CODE_START + lore_location_start + 37, LoreLocation.tower, LunacidRegion.tower_of_abyss),
    create_location(LOCATION_CODE_START + lore_location_start + 38, LoreLocation.flames, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + lore_location_start + 39, LoreLocation.history_203, LunacidRegion.forbidden_archives_3f),
    create_location(LOCATION_CODE_START + lore_location_start + 40, LoreLocation.history_179, LunacidRegion.forbidden_archives_1f_front),
    create_location(LOCATION_CODE_START + lore_location_start + 41, LoreLocation.history_202, LunacidRegion.forbidden_archives_3f),
    create_location(LOCATION_CODE_START + lore_location_start + 42, LoreLocation.history_176, LunacidRegion.forbidden_archives_2f),
    create_location(LOCATION_CODE_START + lore_location_start + 43, LoreLocation.history_177, LunacidRegion.forbidden_archives_2f),
    create_location(LOCATION_CODE_START + lore_location_start + 44, LoreLocation.history_175, LunacidRegion.forbidden_archives_2f),
    create_location(LOCATION_CODE_START + lore_location_start + 45, LoreLocation.history_178, LunacidRegion.forbidden_archives_1f_back),
    create_location(LOCATION_CODE_START + lore_location_start + 46, LoreLocation.lyria_monument, LunacidRegion.forbidden_archives_1f_back),
    create_location(LOCATION_CODE_START + lore_location_start + 47, LoreLocation.tranquil_end, LunacidRegion.forest_canopy),
    create_location(LOCATION_CODE_START + lore_location_start + 48, LoreLocation.tomb_dark, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + lore_location_start + 49, LoreLocation.carnivore, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + lore_location_start + 50, LoreLocation.drained, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + lore_location_start + 51, LoreLocation.low_musing, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + lore_location_start + 52, LoreLocation.frustration, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + lore_location_start + 53, LoreLocation.calamis_after, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + lore_location_start + 54, LoreLocation.jail_complain, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + lore_location_start + 55, LoreLocation.prisoner_mad, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + lore_location_start + 56, LoreLocation.skeleton_yay, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + lore_location_start + 57, LoreLocation.on_dreamer, LunacidRegion.terminus_prison_3f),
    create_location(LOCATION_CODE_START + lore_location_start + 58, LoreLocation.yipee, LunacidRegion.terminus_prison_basement),
    create_location(LOCATION_CODE_START + lore_location_start + 59, LoreLocation.fisher, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + lore_location_start + 60, LoreLocation.feel_something, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + lore_location_start + 61, LoreLocation.changing, LunacidRegion.terminus_prison_1f_secrets),
    create_location(LOCATION_CODE_START + lore_location_start + 62, LoreLocation.blaspheme, LunacidRegion.holy_seat_of_gold),
    create_location(LOCATION_CODE_START + lore_location_start + 63, LoreLocation.strange_coin, LunacidRegion.holy_seat_of_gold),
    create_location(LOCATION_CODE_START + lore_location_start + 64, LoreLocation.prayer, LunacidRegion.holy_seat_of_gold),
    create_location(LOCATION_CODE_START + lore_location_start + 65, LoreLocation.centaur, LunacidRegion.holy_seat_of_gold),
    create_location(LOCATION_CODE_START + lore_location_start + 66, LoreLocation.abdul, LunacidRegion.holy_seat_of_gold),
    create_location(LOCATION_CODE_START + lore_location_start + 67, LoreLocation.windy_path, LunacidRegion.labyrinth_of_ash),
    create_location(LOCATION_CODE_START + lore_location_start + 68, LoreLocation.garrat, LunacidRegion.fetid_mire),
]

grass_location_start = 1100
grass_locations = [
    create_location(LOCATION_CODE_START + grass_location_start + 1, GrassLocation.clf_bloodweed_1, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 2, GrassLocation.clf_bloodweed_2, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 3, GrassLocation.clf_bloodweed_3, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 4, GrassLocation.clf_bloodweed_4, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 5, GrassLocation.clf_bloodweed_5, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 6, GrassLocation.clf_bloodweed_6, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 7, GrassLocation.clf_bloodweed_7, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 8, GrassLocation.clf_bloodweed_8, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 9, GrassLocation.clf_bloodweed_9, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 10, GrassLocation.clf_bloodweed_10, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 11, GrassLocation.clf_bloodweed_11, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 12, GrassLocation.clf_bloodweed_12, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 13, GrassLocation.clf_bloodweed_13, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 14, GrassLocation.clf_bloodweed_14, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 15, GrassLocation.clf_bloodweed_15, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 16, GrassLocation.clf_bloodweed_16, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 17, GrassLocation.clf_bloodweed_17, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 18, GrassLocation.clf_flora_1, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 19, GrassLocation.clf_flora_2, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 20, GrassLocation.clf_flora_3, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 21, GrassLocation.clf_flora_4, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 22, GrassLocation.clf_flora_5, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 23, GrassLocation.clf_flora_6, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 24, GrassLocation.clf_flora_7, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 25, GrassLocation.clf_flora_8, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 26, GrassLocation.clf_flora_9, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 27, GrassLocation.clf_flora_10, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 28, GrassLocation.clf_bloodweed_18, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 29, GrassLocation.clf_bloodweed_19, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 30, GrassLocation.clf_bloodweed_20, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 31, GrassLocation.clf_bloodweed_21, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 32, GrassLocation.clf_bloodweed_22, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 33, GrassLocation.clf_bloodweed_23, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 34, GrassLocation.clf_bloodweed_24, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 35, GrassLocation.clf_bloodweed_25, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 36, GrassLocation.clf_bloodweed_26, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 37, GrassLocation.clf_bloodweed_27, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 38, GrassLocation.clf_flora_11, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 39, GrassLocation.clf_flora_12, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 40, GrassLocation.clf_flora_13, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 41, GrassLocation.clf_flora_14, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 42, GrassLocation.clf_flora_15, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 43, GrassLocation.clf_flora_16, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 44, GrassLocation.clf_bloodweed_28, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 45, GrassLocation.clf_bloodweed_29, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 46, GrassLocation.clf_bloodweed_30, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 47, GrassLocation.clf_bloodweed_31, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 48, GrassLocation.clf_bloodweed_32, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 49, GrassLocation.clf_bloodweed_33, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 50, GrassLocation.clf_bloodweed_34, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 51, GrassLocation.clf_bloodweed_35, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 52, GrassLocation.clf_bloodweed_36, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 53, GrassLocation.clf_bloodweed_37, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 54, GrassLocation.clf_bloodweed_38, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 55, GrassLocation.clf_bloodweed_39, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 56, GrassLocation.clf_bloodweed_40, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 57, GrassLocation.clf_bloodweed_41, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 58, GrassLocation.clf_bloodweed_42, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 59, GrassLocation.clf_bloodweed_43, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 60, GrassLocation.clf_bloodweed_44, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 61, GrassLocation.clf_bloodweed_45, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 62, GrassLocation.clf_bloodweed_46, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 63, GrassLocation.clf_bloodweed_47, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 64, GrassLocation.clf_bloodweed_48, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 65, GrassLocation.clf_bloodweed_49, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 66, GrassLocation.clf_bloodweed_50, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 67, GrassLocation.clf_bloodweed_51, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 68, GrassLocation.clf_bloodweed_52, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 69, GrassLocation.clf_bloodweed_53, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 70, GrassLocation.clf_bloodweed_54, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 71, GrassLocation.clf_bloodweed_55, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 72, GrassLocation.clf_bloodweed_56, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 73, GrassLocation.clf_bloodweed_57, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 74, GrassLocation.clf_bloodweed_58, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 75, GrassLocation.clf_bloodweed_59, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 76, GrassLocation.clf_bloodweed_60, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 77, GrassLocation.clf_bloodweed_61, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 78, GrassLocation.clf_bloodweed_62, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 79, GrassLocation.clf_bloodweed_63, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 80, GrassLocation.clf_bloodweed_64, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 81, GrassLocation.clf_bloodweed_65, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 82, GrassLocation.clf_bloodweed_66, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 83, GrassLocation.clf_bloodweed_67, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 84, GrassLocation.clf_bloodweed_68, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 85, GrassLocation.clf_bloodweed_69, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 86, GrassLocation.clf_bloodweed_70, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 87, GrassLocation.clf_bloodweed_71, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 88, GrassLocation.clf_bloodweed_72, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 89, GrassLocation.clf_bloodweed_73, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 90, GrassLocation.clf_bloodweed_74, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 91, GrassLocation.clf_bloodweed_75, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 92, GrassLocation.clf_bloodweed_76, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 93, GrassLocation.clf_bloodweed_77, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 94, GrassLocation.clf_bloodweed_78, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 95, GrassLocation.clf_bloodweed_79, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 96, GrassLocation.clf_bloodweed_80, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 97, GrassLocation.clf_bloodweed_81, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 98, GrassLocation.clf_bloodweed_82, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 99, GrassLocation.clf_bloodweed_83, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 100, GrassLocation.clf_bloodweed_84, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 101, GrassLocation.clf_bloodweed_85, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 102, GrassLocation.clf_bloodweed_86, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 103, GrassLocation.clf_flora_17, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 104, GrassLocation.clf_flora_18, LunacidRegion.castle_le_fanu_entrance),
    create_location(LOCATION_CODE_START + grass_location_start + 105, GrassLocation.clf_bloodweed_87, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 106, GrassLocation.clf_bloodweed_88, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 107, GrassLocation.clf_bloodweed_89, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 108, GrassLocation.clf_bloodweed_90, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 109, GrassLocation.clf_bloodweed_91, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 110, GrassLocation.clf_bloodweed_92, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 111, GrassLocation.clf_bloodweed_93, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 112, GrassLocation.clf_bloodweed_94, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 113, GrassLocation.clf_bloodweed_95, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 114, GrassLocation.clf_bloodweed_96, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 115, GrassLocation.clf_bloodweed_97, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 116, GrassLocation.clf_bloodweed_98, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 117, GrassLocation.clf_bloodweed_99, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 118, GrassLocation.clf_bloodweed_100, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 119, GrassLocation.clf_bloodweed_101, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 120, GrassLocation.clf_bloodweed_102, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 121, GrassLocation.clf_bloodweed_103, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 122, GrassLocation.clf_bloodweed_104, LunacidRegion.castle_le_fanu_main_halls),
    create_location(LOCATION_CODE_START + grass_location_start + 123, GrassLocation.clf_bloodweed_105, LunacidRegion.castle_le_fanu_main_halls),

    create_location(LOCATION_CODE_START + grass_location_start + 124, GrassLocation.fm_lotus_1, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 125, GrassLocation.fm_lotus_2, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 126, GrassLocation.fm_lotus_3, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 127, GrassLocation.fm_lotus_4, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 128, GrassLocation.fm_lotus_5, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 129, GrassLocation.fm_lotus_6, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 130, GrassLocation.fm_lotus_7, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 131, GrassLocation.fm_lotus_8, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 132, GrassLocation.fm_lotus_9, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 133, GrassLocation.fm_lotus_10, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 134, GrassLocation.fm_lotus_11, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 135, GrassLocation.fm_lotus_12, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 136, GrassLocation.fm_lotus_13, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 137, GrassLocation.fm_lotus_14, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 138, GrassLocation.fm_lotus_15, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 139, GrassLocation.fm_lotus_16, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 140, GrassLocation.fm_lotus_17, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 141, GrassLocation.fm_lotus_18, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 142, GrassLocation.fm_lotus_19, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 143, GrassLocation.fm_lotus_20, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 144, GrassLocation.fm_lotus_21, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 145, GrassLocation.fm_lotus_22, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 146, GrassLocation.fm_lotus_23, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 147, GrassLocation.fm_lotus_24, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 148, GrassLocation.fm_lotus_25, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 149, GrassLocation.fm_lotus_26, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 150, GrassLocation.fm_lotus_27, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + grass_location_start + 151, GrassLocation.fm_lotus_28, LunacidRegion.fetid_mire),

    create_location(LOCATION_CODE_START + grass_location_start + 152, GrassLocation.fla_fiddlehead_1, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + grass_location_start + 153, GrassLocation.fla_lotus_1, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 154, GrassLocation.fla_lotus_2, LunacidRegion.temple_of_water_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 155, GrassLocation.fla_lotus_3, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 156, GrassLocation.fla_lotus_4, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 157, GrassLocation.fla_lotus_5, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 158, GrassLocation.fla_lotus_6, LunacidRegion.temple_of_water_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 159, GrassLocation.fla_lotus_7, LunacidRegion.temple_of_water_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 160, GrassLocation.fla_lotus_8, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 161, GrassLocation.fla_lotus_9, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 162, GrassLocation.fla_lotus_10, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 163, GrassLocation.fla_lotus_11, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 164, GrassLocation.fla_lotus_12, LunacidRegion.temple_of_water_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 165, GrassLocation.fla_lotus_13, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 166, GrassLocation.fla_lotus_14, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 167, GrassLocation.fla_lotus_15, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + grass_location_start + 168, GrassLocation.fla_lotus_16, LunacidRegion.temple_of_water_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 169, GrassLocation.fla_fiddlehead_2, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 170, GrassLocation.fla_fiddlehead_3, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 171, GrassLocation.fla_fiddlehead_4, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 172, GrassLocation.fla_fiddlehead_5, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 173, GrassLocation.fla_fiddlehead_6, LunacidRegion.temple_of_earth_secret),
    create_location(LOCATION_CODE_START + grass_location_start + 174, GrassLocation.fla_fiddlehead_7, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 175, GrassLocation.fla_fiddlehead_8, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 176, GrassLocation.fla_fiddlehead_9, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + grass_location_start + 177, GrassLocation.fla_fiddlehead_10, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + grass_location_start + 178, GrassLocation.fla_fiddlehead_11, LunacidRegion.temple_of_earth_secret),
    create_location(LOCATION_CODE_START + grass_location_start + 179, GrassLocation.fla_lotus_17, LunacidRegion.temple_of_water),
    create_location(LOCATION_CODE_START + grass_location_start + 180, GrassLocation.fla_lotus_18, LunacidRegion.temple_of_water_lower_secrets),
    create_location(LOCATION_CODE_START + grass_location_start + 181, GrassLocation.fla_fiddlehead_12, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 182, GrassLocation.fla_fiddlehead_13, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 183, GrassLocation.fla_fiddlehead_14, LunacidRegion.temple_of_earth_secret),
    create_location(LOCATION_CODE_START + grass_location_start + 184, GrassLocation.fla_fiddlehead_15, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 185, GrassLocation.fla_fiddlehead_16, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + grass_location_start + 186, GrassLocation.fla_fiddlehead_17, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 187, GrassLocation.fla_fiddlehead_18, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 188, GrassLocation.fla_fiddlehead_19, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 189, GrassLocation.fla_fiddlehead_20, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + grass_location_start + 190, GrassLocation.fla_fiddlehead_21, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + grass_location_start + 191, GrassLocation.fla_fiddlehead_22, LunacidRegion.temple_of_earth_secret),
    create_location(LOCATION_CODE_START + grass_location_start + 192, GrassLocation.fla_lotus_19, LunacidRegion.temple_of_water_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 193, GrassLocation.fla_fiddlehead_23, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + grass_location_start + 194, GrassLocation.fla_fiddlehead_24, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + grass_location_start + 195, GrassLocation.fla_fiddlehead_25, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 196, GrassLocation.fla_fiddlehead_26, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 197, GrassLocation.fla_fiddlehead_27, LunacidRegion.temple_of_earth_secret),
    create_location(LOCATION_CODE_START + grass_location_start + 198, GrassLocation.fla_fiddlehead_28, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 199, GrassLocation.fla_fiddlehead_29, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 200, GrassLocation.fla_fiddlehead_30, LunacidRegion.temple_of_earth_secret),
    create_location(LOCATION_CODE_START + grass_location_start + 201, GrassLocation.fla_fiddlehead_31, LunacidRegion.temple_of_earth),
    create_location(LOCATION_CODE_START + grass_location_start + 202, GrassLocation.fla_fiddlehead_32, LunacidRegion.forlorn_arena),
    create_location(LOCATION_CODE_START + grass_location_start + 203, GrassLocation.fla_fiddlehead_33, LunacidRegion.forlorn_arena),

    create_location(LOCATION_CODE_START + grass_location_start + 204, GrassLocation.bg_fire_coral_1, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 205, GrassLocation.bg_fire_coral_2, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 206, GrassLocation.bg_fire_coral_3, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 207, GrassLocation.bg_fire_coral_4, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 208, GrassLocation.bg_fire_coral_5, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 209, GrassLocation.bg_fire_coral_6, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 210, GrassLocation.bg_fire_coral_7, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 211, GrassLocation.bg_fire_coral_8, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 212, GrassLocation.bg_fire_coral_9, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 213, GrassLocation.bg_fire_coral_10, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 214, GrassLocation.bg_fire_coral_11, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 215, GrassLocation.bg_fire_coral_12, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 216, GrassLocation.bg_fire_coral_13, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 217, GrassLocation.bg_fire_coral_14, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 218, GrassLocation.bg_fire_coral_15, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 219, GrassLocation.bg_fire_coral_16, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 220, GrassLocation.bg_fire_coral_17, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 221, GrassLocation.bg_fire_coral_18, LunacidRegion.boiling_grotto),
    create_location(LOCATION_CODE_START + grass_location_start + 222, GrassLocation.bg_fire_coral_19, LunacidRegion.boiling_grotto),

    create_location(LOCATION_CODE_START + grass_location_start + 223, GrassLocation.sb_bloodweed_1, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + grass_location_start + 224, GrassLocation.sb_bloodweed_2, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + grass_location_start + 225, GrassLocation.sb_bloodweed_3, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + grass_location_start + 226, GrassLocation.sb_bloodweed_4, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + grass_location_start + 227, GrassLocation.sb_bloodweed_5, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + grass_location_start + 228, GrassLocation.sb_bloodweed_6, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + grass_location_start + 229, GrassLocation.sb_bloodweed_7, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + grass_location_start + 230, GrassLocation.sb_bloodweed_8, LunacidRegion.sealed_ballroom_secret_walls),
    create_location(LOCATION_CODE_START + grass_location_start + 231, GrassLocation.sb_bloodweed_9, LunacidRegion.sealed_ballroom_secret_walls),

    create_location(LOCATION_CODE_START + grass_location_start + 232, GrassLocation.at_flora_1, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 233, GrassLocation.at_flora_2, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 234, GrassLocation.at_flora_3, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 235, GrassLocation.at_flora_4, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 236, GrassLocation.at_flora_5, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 237, GrassLocation.at_flora_6, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 238, GrassLocation.at_flora_7, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 239, GrassLocation.at_flora_8, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 240, GrassLocation.at_flora_9, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 241, GrassLocation.at_flora_10, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 242, GrassLocation.at_flora_11, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 243, GrassLocation.at_flora_12, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 244, GrassLocation.at_flora_13, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 245, GrassLocation.at_flora_14, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 246, GrassLocation.at_flora_15, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 247, GrassLocation.at_flora_16, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 248, GrassLocation.at_flora_17, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 249, GrassLocation.at_flora_18, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 250, GrassLocation.at_flora_19, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 251, GrassLocation.at_flora_20, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 252, GrassLocation.at_flora_21, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 253, GrassLocation.at_flora_22, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 254, GrassLocation.at_flora_23, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 255, GrassLocation.at_flora_24, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 256, GrassLocation.at_flora_25, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 257, GrassLocation.at_flora_26, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 258, GrassLocation.at_flora_27, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 259, GrassLocation.at_flora_28, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 260, GrassLocation.at_flora_29, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 261, GrassLocation.at_flora_30, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 262, GrassLocation.at_flora_31, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 263, GrassLocation.at_flora_32, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 264, GrassLocation.at_flora_33, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 265, GrassLocation.at_flora_34, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 266, GrassLocation.at_flora_35, LunacidRegion.mausoleum),
    create_location(LOCATION_CODE_START + grass_location_start + 267, GrassLocation.at_flora_36, LunacidRegion.mausoleum),

    create_location(LOCATION_CODE_START + grass_location_start + 268, GrassLocation.hb_bloodweed_1, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 269, GrassLocation.hb_bloodweed_2, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 270, GrassLocation.hb_bloodweed_3, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 271, GrassLocation.hb_bloodweed_4, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 272, GrassLocation.hb_bloodweed_5, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 273, GrassLocation.hb_bloodweed_6, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 274, GrassLocation.hb_bloodweed_7, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 275, GrassLocation.hb_bloodweed_8, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 276, GrassLocation.hb_bloodweed_9, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 277, GrassLocation.hb_bloodweed_10, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 278, GrassLocation.hb_bloodweed_11, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 279, GrassLocation.hb_bloodweed_12, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 280, GrassLocation.hb_bloodweed_13, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 281, GrassLocation.hb_bloodweed_14, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 282, GrassLocation.hb_bloodweed_15, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 283, GrassLocation.hb_bloodweed_16, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 284, GrassLocation.hb_bloodweed_17, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 285, GrassLocation.hb_bloodweed_18, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 286, GrassLocation.hb_bloodweed_19, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 287, GrassLocation.hb_bloodweed_20, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 288, GrassLocation.hb_bloodweed_21, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 289, GrassLocation.hb_bloodweed_22, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 290, GrassLocation.hb_bloodweed_23, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 291, GrassLocation.hb_bloodweed_24, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 292, GrassLocation.hb_bloodweed_25, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 293, GrassLocation.hb_bloodweed_26, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 294, GrassLocation.hb_bloodweed_27, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 295, GrassLocation.hb_bloodweed_28, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 296, GrassLocation.hb_bloodweed_29, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 297, GrassLocation.hb_bloodweed_30, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 298, GrassLocation.hb_bloodweed_31, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 299, GrassLocation.hb_bloodweed_32, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 300, GrassLocation.hb_bloodweed_33, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 301, GrassLocation.hb_bloodweed_34, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 302, GrassLocation.hb_bloodweed_35, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 303, GrassLocation.hb_bloodweed_36, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 304, GrassLocation.hb_bloodweed_37, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 305, GrassLocation.hb_bloodweed_38, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 306, GrassLocation.hb_bloodweed_39, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 307, GrassLocation.hb_bloodweed_40, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 308, GrassLocation.hb_bloodweed_41, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 309, GrassLocation.hb_bloodweed_42, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 310, GrassLocation.hb_bloodweed_43, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 311, GrassLocation.hb_bloodweed_44, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 312, GrassLocation.hb_bloodweed_45, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 313, GrassLocation.hb_bloodweed_46, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 314, GrassLocation.hb_bloodweed_47, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 315, GrassLocation.hb_bloodweed_48, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 316, GrassLocation.hb_bloodweed_49, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 317, GrassLocation.hb_bloodweed_50, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 318, GrassLocation.hb_bloodweed_51, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 319, GrassLocation.hb_bloodweed_52, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 320, GrassLocation.hb_bloodweed_53, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 321, GrassLocation.hb_bloodweed_54, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 322, GrassLocation.hb_bloodweed_55, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 323, GrassLocation.hb_bloodweed_56, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 324, GrassLocation.hb_bloodweed_57, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 325, GrassLocation.hb_bloodweed_58, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 326, GrassLocation.hb_bloodweed_59, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 327, GrassLocation.hb_bloodweed_60, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 328, GrassLocation.hb_bloodweed_61, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 329, GrassLocation.hb_bloodweed_62, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 330, GrassLocation.hb_bloodweed_63, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 331, GrassLocation.hb_bloodweed_64, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 332, GrassLocation.hb_bloodweed_65, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 333, GrassLocation.hb_bloodweed_66, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 334, GrassLocation.hb_bloodweed_67, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 335, GrassLocation.hb_bloodweed_68, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 336, GrassLocation.hb_bloodweed_69, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 337, GrassLocation.hb_bloodweed_70, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 338, GrassLocation.hb_bloodweed_71, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 339, GrassLocation.hb_bloodweed_72, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 340, GrassLocation.hb_bloodweed_73, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 341, GrassLocation.hb_bloodweed_74, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 342, GrassLocation.hb_bloodweed_75, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 343, GrassLocation.hb_bloodweed_76, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 344, GrassLocation.hb_bloodweed_77, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 345, GrassLocation.hb_bloodweed_78, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 346, GrassLocation.hb_bloodweed_79, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 347, GrassLocation.hb_bloodweed_80, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 348, GrassLocation.hb_bloodweed_81, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 349, GrassLocation.hb_bloodweed_82, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 350, GrassLocation.hb_bloodweed_83, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 351, GrassLocation.hb_bloodweed_84, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 352, GrassLocation.hb_bloodweed_85, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 353, GrassLocation.hb_bloodweed_86, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 354, GrassLocation.hb_bloodweed_87, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 355, GrassLocation.hb_bloodweed_88, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 356, GrassLocation.hb_bloodweed_89, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 357, GrassLocation.hb_bloodweed_90, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 358, GrassLocation.hb_bloodweed_91, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 359, GrassLocation.hb_bloodweed_92, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 360, GrassLocation.hb_bloodweed_93, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 361, GrassLocation.hb_bloodweed_94, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 362, GrassLocation.hb_bloodweed_95, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 363, GrassLocation.hb_bloodweed_96, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 364, GrassLocation.hb_bloodweed_97, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 365, GrassLocation.hb_bloodweed_98, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 366, GrassLocation.hb_bloodweed_99, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 367, GrassLocation.hb_bloodweed_100, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 368, GrassLocation.hb_bloodweed_101, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + grass_location_start + 369, GrassLocation.hb_bloodweed_102, LunacidRegion.holy_battleground),

    create_location(LOCATION_CODE_START + grass_location_start + 370, GrassLocation.yf_mushroom_1, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 371, GrassLocation.yf_mushroom_2, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 372, GrassLocation.yf_mushroom_3, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 373, GrassLocation.yf_mushroom_4, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 374, GrassLocation.yf_mushroom_5, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 375, GrassLocation.yf_mushroom_6, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 376, GrassLocation.yf_mushroom_7, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 377, GrassLocation.yf_mushroom_8, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 378, GrassLocation.yf_mushroom_9, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 379, GrassLocation.yf_mushroom_10, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 380, GrassLocation.yf_mushroom_11, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 381, GrassLocation.yf_mushroom_12, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 382, GrassLocation.yf_mushroom_13, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 383, GrassLocation.yf_mushroom_14, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 384, GrassLocation.yf_mushroom_15, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 385, GrassLocation.yf_mushroom_16, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 386, GrassLocation.yf_mushroom_17, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 387, GrassLocation.yf_mushroom_18, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 388, GrassLocation.yf_mushroom_19, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 389, GrassLocation.yf_mushroom_20, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 390, GrassLocation.yf_mushroom_21, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 391, GrassLocation.yf_mushroom_22, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 392, GrassLocation.yf_mushroom_23, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 393, GrassLocation.yf_mushroom_24, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 394, GrassLocation.yf_mushroom_25, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 395, GrassLocation.yf_mushroom_26, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 396, GrassLocation.yf_mushroom_27, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 397, GrassLocation.yf_mushroom_28, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 398, GrassLocation.yf_mushroom_29, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 399, GrassLocation.yf_mushroom_30, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 400, GrassLocation.yf_mushroom_31, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 401, GrassLocation.yf_mushroom_32, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 402, GrassLocation.yf_mushroom_33, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 403, GrassLocation.yf_mushroom_34, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 404, GrassLocation.yf_mushroom_35, LunacidRegion.yosei_lower_secret),
    create_location(LOCATION_CODE_START + grass_location_start + 405, GrassLocation.yf_mushroom_36, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 406, GrassLocation.yf_mushroom_37, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 407, GrassLocation.yf_mushroom_38, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 408, GrassLocation.yf_mushroom_39, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 409, GrassLocation.yf_mushroom_40, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 410, GrassLocation.yf_mushroom_41, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 411, GrassLocation.yf_mushroom_42, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 412, GrassLocation.yf_mushroom_43, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 413, GrassLocation.yf_mushroom_44, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 414, GrassLocation.yf_mushroom_45, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 415, GrassLocation.yf_mushroom_46, LunacidRegion.yosei_lower_secret),
    create_location(LOCATION_CODE_START + grass_location_start + 416, GrassLocation.yf_mushroom_47, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 417, GrassLocation.yf_mushroom_48, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 418, GrassLocation.yf_mushroom_49, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + grass_location_start + 419, GrassLocation.yf_mushroom_50, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + grass_location_start + 420, GrassLocation.yf_mushroom_51, LunacidRegion.yosei_forest),

    create_location(LOCATION_CODE_START + grass_location_start + 421, GrassLocation.tp_bloodweed_1, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 422, GrassLocation.tp_bloodweed_2, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 423, GrassLocation.tp_bloodweed_3, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 424, GrassLocation.tp_bloodweed_4, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 425, GrassLocation.tp_bloodweed_5, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 426, GrassLocation.tp_bloodweed_6, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 427, GrassLocation.tp_bloodweed_7, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 428, GrassLocation.tp_bloodweed_8, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 429, GrassLocation.tp_bloodweed_9, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 430, GrassLocation.tp_bloodweed_10, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 431, GrassLocation.tp_bloodweed_11, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 432, GrassLocation.tp_bloodweed_12, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 433, GrassLocation.tp_bloodweed_13, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 434, GrassLocation.tp_bloodweed_14, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 435, GrassLocation.tp_bloodweed_15, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 436, GrassLocation.tp_bloodweed_16, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 437, GrassLocation.tp_bloodweed_17, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 438, GrassLocation.tp_flora_1, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + grass_location_start + 439, GrassLocation.tp_flora_2, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + grass_location_start + 440, GrassLocation.tp_flora_3, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + grass_location_start + 441, GrassLocation.tp_bloodweed_18, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 442, GrassLocation.tp_flora_4, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + grass_location_start + 443, GrassLocation.tp_bloodweed_19, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 444, GrassLocation.tp_bloodweed_20, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 445, GrassLocation.tp_bloodweed_21, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 446, GrassLocation.tp_bloodweed_22, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 447, GrassLocation.tp_bloodweed_23, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 448, GrassLocation.tp_bloodweed_24, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 449, GrassLocation.tp_bloodweed_25, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 450, GrassLocation.tp_bloodweed_26, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 451, GrassLocation.tp_bloodweed_27, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 452, GrassLocation.tp_bloodweed_28, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 453, GrassLocation.tp_bloodweed_29, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 454, GrassLocation.tp_bloodweed_30, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 455, GrassLocation.tp_bloodweed_31, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 456, GrassLocation.tp_bloodweed_32, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 457, GrassLocation.tp_bloodweed_33, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 458, GrassLocation.tp_bloodweed_34, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 459, GrassLocation.tp_bloodweed_35, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 460, GrassLocation.tp_bloodweed_36, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 461, GrassLocation.tp_bloodweed_37, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 462, GrassLocation.tp_bloodweed_38, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 463, GrassLocation.tp_bloodweed_39, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 464, GrassLocation.tp_bloodweed_40, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 465, GrassLocation.tp_bloodweed_41, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 466, GrassLocation.tp_bloodweed_42, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 467, GrassLocation.tp_bloodweed_43, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 468, GrassLocation.tp_bloodweed_44, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 469, GrassLocation.tp_bloodweed_45, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 470, GrassLocation.tp_bloodweed_46, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 471, GrassLocation.tp_bloodweed_47, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 472, GrassLocation.tp_bloodweed_48, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 473, GrassLocation.tp_bloodweed_49, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 474, GrassLocation.tp_bloodweed_50, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 475, GrassLocation.tp_bloodweed_51, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 476, GrassLocation.tp_bloodweed_52, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 477, GrassLocation.tp_bloodweed_53, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 478, GrassLocation.tp_bloodweed_54, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 479, GrassLocation.tp_bloodweed_55, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 480, GrassLocation.tp_bloodweed_56, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 481, GrassLocation.tp_flora_5, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + grass_location_start + 482, GrassLocation.tp_bloodweed_57, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 483, GrassLocation.tp_bloodweed_58, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 484, GrassLocation.tp_bloodweed_59, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 485, GrassLocation.tp_bloodweed_60, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 486, GrassLocation.tp_bloodweed_61, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 487, GrassLocation.tp_bloodweed_62, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 488, GrassLocation.tp_bloodweed_63, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 489, GrassLocation.tp_bloodweed_64, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 490, GrassLocation.tp_bloodweed_65, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 491, GrassLocation.tp_bloodweed_66, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 492, GrassLocation.tp_bloodweed_67, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 493, GrassLocation.tp_bloodweed_68, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 494, GrassLocation.tp_bloodweed_69, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 495, GrassLocation.tp_bloodweed_70, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 496, GrassLocation.tp_bloodweed_71, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 497, GrassLocation.tp_bloodweed_72, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 498, GrassLocation.tp_bloodweed_73, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 499, GrassLocation.tp_bloodweed_74, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 500, GrassLocation.tp_bloodweed_75, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + grass_location_start + 501, GrassLocation.tp_bloodweed_76, LunacidRegion.terminus_prison_2f_rooms),
    create_location(LOCATION_CODE_START + grass_location_start + 502, GrassLocation.tp_bloodweed_77, LunacidRegion.terminus_prison_1f),
]

grass_location_names = [location.name for location in grass_locations]

break_location_start = 1700
break_locations = [
    create_location(LOCATION_CODE_START + break_location_start + 1, BreakLocation.fm_coffin_1, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 2, BreakLocation.fm_coffin_2, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 3, BreakLocation.fm_coffin_3, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 4, BreakLocation.fm_coffin_4, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 5, BreakLocation.fm_vase_1, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + break_location_start + 6, BreakLocation.fm_vase_2, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 7, BreakLocation.fm_vase_3, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 8, BreakLocation.fm_vase_4, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 9, BreakLocation.fm_vase_5, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 10, BreakLocation.fm_vase_6, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 11, BreakLocation.fm_vase_7, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 12, BreakLocation.fm_vase_8, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 13, BreakLocation.fm_vase_9, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 14, BreakLocation.fm_vase_10, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 15, BreakLocation.fm_crate_1, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + break_location_start + 16, BreakLocation.fm_crate_2, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + break_location_start + 17, BreakLocation.fm_crate_3, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + break_location_start + 18, BreakLocation.fm_vase_11, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 19, BreakLocation.fm_vase_12, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 20, BreakLocation.fm_vase_13, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 21, BreakLocation.fm_vase_14, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 22, BreakLocation.fm_barrel_1, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + break_location_start + 23, BreakLocation.fm_barrel_2, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + break_location_start + 24, BreakLocation.fm_barrel_3, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + break_location_start + 25, BreakLocation.fm_vase_15, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 26, BreakLocation.fm_vase_16, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 27, BreakLocation.fm_vase_17, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 28, BreakLocation.fm_vase_18, LunacidRegion.fetid_mire_lower_secrets),
    create_location(LOCATION_CODE_START + break_location_start + 29, BreakLocation.fm_vase_19, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 30, BreakLocation.fm_vase_20, LunacidRegion.fetid_mire),
    create_location(LOCATION_CODE_START + break_location_start + 31, BreakLocation.fm_vase_21, LunacidRegion.fetid_mire),

    create_location(LOCATION_CODE_START + break_location_start + 37, BreakLocation.hb_coffin_1, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 38, BreakLocation.hb_coffin_2, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 40, BreakLocation.hb_coffin_3, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 41, BreakLocation.hb_coffin_4, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 42, BreakLocation.hb_coffin_5, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 43, BreakLocation.hb_coffin_6, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 44, BreakLocation.hb_coffin_7, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 45, BreakLocation.hb_coffin_8, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 46, BreakLocation.hb_coffin_9, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 47, BreakLocation.hb_coffin_10, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 48, BreakLocation.hb_vase_1, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 49, BreakLocation.hb_vase_2, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 50, BreakLocation.hb_vase_3, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 51, BreakLocation.hb_vase_4, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 52, BreakLocation.hb_vase_5, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 53, BreakLocation.hb_vase_6, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 54, BreakLocation.hb_vase_7, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 55, BreakLocation.hb_vase_8, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 56, BreakLocation.hb_vase_9, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 57, BreakLocation.hb_vase_10, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 58, BreakLocation.hb_vase_11, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 59, BreakLocation.hb_vase_12, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 60, BreakLocation.hb_vase_13, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 61, BreakLocation.hb_vase_14, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 62, BreakLocation.hb_vase_15, LunacidRegion.temple_locked),
    create_location(LOCATION_CODE_START + break_location_start + 63, BreakLocation.hb_vase_16, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 64, BreakLocation.hb_vase_17, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 65, BreakLocation.hb_vase_18, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 66, BreakLocation.hb_vase_19, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 67, BreakLocation.hb_vase_20, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 68, BreakLocation.hb_vase_21, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 69, BreakLocation.hb_vase_22, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 70, BreakLocation.hb_vase_23, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 71, BreakLocation.hb_vase_24, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 72, BreakLocation.hb_vase_25, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 73, BreakLocation.hb_vase_26, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 74, BreakLocation.hb_vase_27, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 75, BreakLocation.hb_vase_28, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 76, BreakLocation.hb_vase_29, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 77, BreakLocation.hb_vase_30, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 78, BreakLocation.hb_vase_31, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 79, BreakLocation.hb_vase_32, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 80, BreakLocation.hb_vase_33, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 81, BreakLocation.hb_vase_34, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 82, BreakLocation.hb_vase_35, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 83, BreakLocation.hb_vase_36, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 84, BreakLocation.hb_vase_37, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 85, BreakLocation.hb_vase_38, LunacidRegion.temple_lower),
    create_location(LOCATION_CODE_START + break_location_start + 86, BreakLocation.hb_crate_1, LunacidRegion.temple_sewers),
    create_location(LOCATION_CODE_START + break_location_start + 87, BreakLocation.hb_vase_39, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 88, BreakLocation.hb_vase_40, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 89, BreakLocation.hb_vase_41, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 90, BreakLocation.hb_vase_42, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 91, BreakLocation.hb_vase_43, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 92, BreakLocation.hb_vase_44, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 93, BreakLocation.hb_vase_45, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 94, BreakLocation.hb_vase_46, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 95, BreakLocation.hb_vase_47, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 96, BreakLocation.hb_vase_48, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 97, BreakLocation.hb_vase_49, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 98, BreakLocation.hb_vase_50, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 99, BreakLocation.hb_vase_51, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 100, BreakLocation.hb_vase_52, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 101, BreakLocation.hb_vase_53, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 102, BreakLocation.hb_vase_54, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 103, BreakLocation.hb_vase_55, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 104, BreakLocation.hb_vase_56, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 105, BreakLocation.hb_vase_57, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 106, BreakLocation.hb_vase_58, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 107, BreakLocation.hb_vase_59, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 108, BreakLocation.hb_vase_60, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 109, BreakLocation.hb_vase_61, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 110, BreakLocation.hb_vase_62, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 111, BreakLocation.hb_vase_63, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 112, BreakLocation.hb_vase_64, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 113, BreakLocation.hb_vase_65, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 114, BreakLocation.hb_vase_66, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 115, BreakLocation.hb_vase_67, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 116, BreakLocation.hb_vase_68, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 117, BreakLocation.hb_vase_69, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 118, BreakLocation.hb_vase_70, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 119, BreakLocation.hb_vase_71, LunacidRegion.temple_locked),
    create_location(LOCATION_CODE_START + break_location_start + 120, BreakLocation.hb_vase_72, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 121, BreakLocation.hb_vase_73, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 122, BreakLocation.hb_vase_74, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 123, BreakLocation.hb_vase_75, LunacidRegion.temple_locked),
    create_location(LOCATION_CODE_START + break_location_start + 124, BreakLocation.hb_vase_76, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 125, BreakLocation.hb_crate_2, LunacidRegion.temple_sewers),
    create_location(LOCATION_CODE_START + break_location_start + 126, BreakLocation.hb_vase_77, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 127, BreakLocation.hb_vase_78, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 128, BreakLocation.hb_vase_79, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 129, BreakLocation.hb_vase_80, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 130, BreakLocation.hb_vase_81, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 131, BreakLocation.hb_vase_82, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 132, BreakLocation.hb_vase_83, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 133, BreakLocation.hb_vase_84, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 134, BreakLocation.hb_vase_85, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 135, BreakLocation.hb_vase_86, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 136, BreakLocation.hb_vase_87, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 137, BreakLocation.hb_vase_88, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 138, BreakLocation.hb_vase_89, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 139, BreakLocation.hb_vase_90, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 140, BreakLocation.hb_vase_91, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 141, BreakLocation.hb_vase_92, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 142, BreakLocation.hb_vase_93, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 143, BreakLocation.hb_vase_94, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 144, BreakLocation.hb_vase_95, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 145, BreakLocation.hb_vase_96, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 146, BreakLocation.hb_vase_97, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 147, BreakLocation.hb_vase_98, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 148, BreakLocation.hb_vase_99, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 149, BreakLocation.hb_vase_100, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 150, BreakLocation.hb_vase_101, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 151, BreakLocation.hb_vase_102, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 152, BreakLocation.hb_vase_103, LunacidRegion.temple_back),
    create_location(LOCATION_CODE_START + break_location_start + 153, BreakLocation.hb_vase_104, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 154, BreakLocation.hb_vase_105, LunacidRegion.hollow_basin),
    create_location(LOCATION_CODE_START + break_location_start + 155, BreakLocation.hb_vase_106, LunacidRegion.temple_front),
    create_location(LOCATION_CODE_START + break_location_start + 156, BreakLocation.hb_vase_107, LunacidRegion.temple_locked),
    create_location(LOCATION_CODE_START + break_location_start + 157, BreakLocation.hb_vase_108, LunacidRegion.temple_back),

    create_location(LOCATION_CODE_START + break_location_start + 158, BreakLocation.sb_crate_1, LunacidRegion.sealed_ballroom_room_within_secret),
    create_location(LOCATION_CODE_START + break_location_start + 159, BreakLocation.sb_crate_2, LunacidRegion.sealed_ballroom_room_within_secret),

    create_location(LOCATION_CODE_START + break_location_start + 160, BreakLocation.hb_wood_debris_1, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 161, BreakLocation.hb_wood_debris_2, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 162, BreakLocation.hb_wood_debris_3, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 163, BreakLocation.hb_wood_debris_4, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 164, BreakLocation.hb_wood_debris_5, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 165, BreakLocation.hb_wood_debris_6, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 166, BreakLocation.hb_wood_debris_7, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 167, BreakLocation.hb_wood_debris_8, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 168, BreakLocation.hb_wood_debris_9, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 169, BreakLocation.hb_wood_debris_10, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 170, BreakLocation.hb_wood_debris_11, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 171, BreakLocation.hb_wood_debris_12, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 172, BreakLocation.hb_wood_debris_13, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 173, BreakLocation.hb_wood_debris_14, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 174, BreakLocation.hb_wood_debris_15, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 175, BreakLocation.hb_wood_debris_16, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 176, BreakLocation.hb_wood_debris_17, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 177, BreakLocation.hb_wood_debris_18, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 178, BreakLocation.hb_wood_debris_19, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 179, BreakLocation.hb_wood_debris_20, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 180, BreakLocation.hb_wood_debris_21, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 181, BreakLocation.hb_wood_debris_22, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 182, BreakLocation.hb_wood_debris_23, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 183, BreakLocation.hb_wood_debris_24, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 184, BreakLocation.hb_wood_debris_25, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 185, BreakLocation.hb_wood_debris_26, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 186, BreakLocation.hb_wood_debris_27, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 187, BreakLocation.hb_wood_debris_28, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 188, BreakLocation.hb_wood_debris_29, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 189, BreakLocation.hb_wood_debris_30, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 190, BreakLocation.hb_wood_debris_31, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 191, BreakLocation.hb_wood_debris_32, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 192, BreakLocation.hb_wood_debris_33, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 193, BreakLocation.hb_wood_debris_34, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 194, BreakLocation.hb_wood_debris_35, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 195, BreakLocation.hb_wood_debris_36, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 196, BreakLocation.hb_wood_debris_37, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 197, BreakLocation.hb_wood_debris_38, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 198, BreakLocation.hb_wood_debris_39, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 199, BreakLocation.hb_wood_debris_40, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 200, BreakLocation.hb_wood_debris_41, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 201, BreakLocation.hb_wood_debris_42, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 202, BreakLocation.hb_wood_debris_43, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 203, BreakLocation.hb_wood_debris_44, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 204, BreakLocation.hb_wood_debris_45, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 205, BreakLocation.hb_wood_debris_46, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 206, BreakLocation.hb_wood_debris_47, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 207, BreakLocation.hb_wood_debris_48, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 208, BreakLocation.hb_wood_debris_49, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 209, BreakLocation.hb_wood_debris_50, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 210, BreakLocation.hb_wood_debris_51, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 211, BreakLocation.hb_wood_debris_52, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 212, BreakLocation.hb_wood_debris_53, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 213, BreakLocation.hb_wood_debris_54, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 214, BreakLocation.hb_wood_debris_55, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 215, BreakLocation.hb_wood_debris_56, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 216, BreakLocation.hb_wood_debris_57, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 217, BreakLocation.hb_wood_debris_58, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 218, BreakLocation.hb_wood_debris_59, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 219, BreakLocation.hb_wood_debris_60, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 220, BreakLocation.hb_wood_debris_61, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 221, BreakLocation.hb_wood_debris_62, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 222, BreakLocation.hb_wood_debris_63, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 223, BreakLocation.hb_wood_debris_64, LunacidRegion.holy_battleground),
    create_location(LOCATION_CODE_START + break_location_start + 224, BreakLocation.hb_wood_debris_65, LunacidRegion.holy_battleground),

    create_location(LOCATION_CODE_START + break_location_start + 225, BreakLocation.at_coffin_1, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 226, BreakLocation.at_coffin_2, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 227, BreakLocation.at_coffin_3, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 228, BreakLocation.at_coffin_4, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 229, BreakLocation.at_coffin_5, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 230, BreakLocation.at_coffin_6, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 231, BreakLocation.at_coffin_7, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 232, BreakLocation.at_coffin_8, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 233, BreakLocation.at_coffin_9, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 234, BreakLocation.at_coffin_10, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 235, BreakLocation.at_coffin_11, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 236, BreakLocation.at_coffin_12, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 237, BreakLocation.at_coffin_13, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 239, BreakLocation.at_coffin_15, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 240, BreakLocation.at_coffin_16, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 241, BreakLocation.at_coffin_17, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 242, BreakLocation.at_coffin_18, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 243, BreakLocation.at_coffin_19, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 244, BreakLocation.at_coffin_20, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 245, BreakLocation.at_coffin_21, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 246, BreakLocation.at_coffin_22, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 247, BreakLocation.at_coffin_23, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 248, BreakLocation.at_coffin_24, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 249, BreakLocation.at_coffin_25, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 250, BreakLocation.at_coffin_26, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 252, BreakLocation.at_coffin_28, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 253, BreakLocation.at_coffin_29, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 254, BreakLocation.at_coffin_30, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 255, BreakLocation.at_coffin_31, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 257, BreakLocation.at_coffin_33, LunacidRegion.accursed_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 258, BreakLocation.at_coffin_34, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 259, BreakLocation.at_coffin_35, LunacidRegion.vampire_tomb),
    create_location(LOCATION_CODE_START + break_location_start + 260, BreakLocation.at_coffin_36, LunacidRegion.accursed_tomb),

    create_location(LOCATION_CODE_START + break_location_start + 262, BreakLocation.yf_crate_1, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 263, BreakLocation.yf_crate_2, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 264, BreakLocation.yf_crate_3, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + break_location_start + 265, BreakLocation.yf_crate_4, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 266, BreakLocation.yf_crate_5, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 267, BreakLocation.yf_crate_6, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 268, BreakLocation.yf_crate_7, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 269, BreakLocation.yf_crate_8, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 270, BreakLocation.yf_crate_9, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 271, BreakLocation.yf_crate_10, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 272, BreakLocation.yf_barrel_1, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 273, BreakLocation.yf_barrel_2, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 274, BreakLocation.yf_barrel_3, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 275, BreakLocation.yf_barrel_4, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 276, BreakLocation.yf_barrel_5, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 277, BreakLocation.yf_barrel_6, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 278, BreakLocation.yf_barrel_7, LunacidRegion.yosei_lower),
    create_location(LOCATION_CODE_START + break_location_start + 279, BreakLocation.yf_barrel_8, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 280, BreakLocation.yf_barrel_9, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 281, BreakLocation.yf_barrel_10, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 282, BreakLocation.yf_crate_11, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 283, BreakLocation.yf_crate_12, LunacidRegion.yosei_forest),
    create_location(LOCATION_CODE_START + break_location_start + 284, BreakLocation.yf_crate_13, LunacidRegion.yosei_forest),

    create_location(LOCATION_CODE_START + break_location_start + 285, BreakLocation.tp_coffin_1, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 286, BreakLocation.tp_coffin_2, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 287, BreakLocation.tp_coffin_3, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 288, BreakLocation.tp_coffin_4, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 289, BreakLocation.tp_coffin_5, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 290, BreakLocation.tp_coffin_6, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 291, BreakLocation.tp_coffin_7, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 292, BreakLocation.tp_coffin_8, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 293, BreakLocation.tp_coffin_9, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 294, BreakLocation.tp_coffin_10, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 295, BreakLocation.tp_coffin_11, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 296, BreakLocation.tp_coffin_12, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 297, BreakLocation.tp_coffin_13, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 298, BreakLocation.tp_coffin_14, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 299, BreakLocation.tp_coffin_15, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 300, BreakLocation.tp_coffin_16, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 301, BreakLocation.tp_coffin_17, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 302, BreakLocation.tp_coffin_18, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 303, BreakLocation.tp_coffin_19, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 304, BreakLocation.tp_coffin_20, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 305, BreakLocation.tp_coffin_21, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 306, BreakLocation.tp_coffin_22, LunacidRegion.terminus_prison_1f),
    create_location(LOCATION_CODE_START + break_location_start + 307, BreakLocation.tp_vase_1, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + break_location_start + 308, BreakLocation.tp_vase_2, LunacidRegion.terminus_prison_3f),
    create_location(LOCATION_CODE_START + break_location_start + 309, BreakLocation.tp_vase_3, LunacidRegion.terminus_prison_3f),
    create_location(LOCATION_CODE_START + break_location_start + 310, BreakLocation.tp_vase_4, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + break_location_start + 311, BreakLocation.tp_vase_5, LunacidRegion.terminus_prison_3f),
    create_location(LOCATION_CODE_START + break_location_start + 312, BreakLocation.tp_vase_6, LunacidRegion.terminus_prison_4f),
    create_location(LOCATION_CODE_START + break_location_start + 313, BreakLocation.tp_crate_1, LunacidRegion.terminus_prison_3f),
    create_location(LOCATION_CODE_START + break_location_start + 314, BreakLocation.tp_vase_7, LunacidRegion.terminus_prison_3f),

    create_location(LOCATION_CODE_START + break_location_start + 315, BreakLocation.la_vase_1, LunacidRegion.holy_seat_of_gold),
    create_location(LOCATION_CODE_START + break_location_start + 316, BreakLocation.la_vase_2, LunacidRegion.holy_seat_of_gold),
    create_location(LOCATION_CODE_START + break_location_start + 317, BreakLocation.la_vase_3, LunacidRegion.holy_seat_of_gold),
    create_location(LOCATION_CODE_START + break_location_start + 318, BreakLocation.la_vase_4, LunacidRegion.holy_seat_of_gold),
]

breakable_location_names = [location.name for location in break_locations]
