from dataclasses import dataclass
from typing import Dict, List, Optional

from worlds.lunacid.strings.regions_entrances import LunacidRegion
from worlds.lunacid.strings.enemies import Enemy
from worlds.lunacid.strings.items import Switch


@dataclass(frozen=True)
class EnemyPlacement:
    scene: str  # Used for the mod to determine which scene this applies to
    group_name: str  # Used for the mod to determine which group is to be targeted
    child_id: int  # Used for the mod to determine which enemy in the group is to be replaced
    enemy: str
    region: str
    needed_item: Optional[str] = "None"


base_enemy_placement = [
    # Hollow Basin
    EnemyPlacement("PITT_A1", "SmallGroupPittA1", 0, Enemy.mummy, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "SmallGroupPittA1", 1, Enemy.mummy_knight, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "SmallGroupPittA1", 2, Enemy.mummy_knight, LunacidRegion.temple_secret),

    EnemyPlacement("PITT_A1", "StartSnailPittA1", 0, Enemy.snail, LunacidRegion.hollow_basin),
    EnemyPlacement("PITT_A1", "StartSnailPittA1", 1, Enemy.snail, LunacidRegion.hollow_basin),
    EnemyPlacement("PITT_A1", "StartSnailPittA1", 2, Enemy.snail, LunacidRegion.hollow_basin),
    EnemyPlacement("PITT_A1", "StartSnailPittA1", 3, Enemy.snail, LunacidRegion.hollow_basin),
    EnemyPlacement("PITT_A1", "StartSnailPittA1", 4, Enemy.snail, LunacidRegion.hollow_basin),

    EnemyPlacement("PITT_A1", "MainPittA1", 6, Enemy.milk_snail, LunacidRegion.hollow_basin),
    EnemyPlacement("PITT_A1", "MainPittA1", 7, Enemy.shulker, LunacidRegion.hollow_basin),
    EnemyPlacement("PITT_A1", "MainPittA1", 8, Enemy.shulker, LunacidRegion.hollow_basin),
    EnemyPlacement("PITT_A1", "MainPittA1", 9, Enemy.shulker, LunacidRegion.hollow_basin),
    EnemyPlacement("PITT_A1", "MainPittA1", 10, Enemy.shulker, LunacidRegion.hollow_basin),
    EnemyPlacement("PITT_A1", "MainPittA1", 11, Enemy.mummy_knight, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "MainPittA1", 12, Enemy.mummy_knight, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "MainPittA1", 13, Enemy.mummy_knight, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "MainPittA1", 14, Enemy.mummy, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "MainPittA1", 15, Enemy.mummy, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "MainPittA1", 16, Enemy.mummy, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "MainPittA1", 17, Enemy.mummy, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "MainPittA1", 18, Enemy.mummy, LunacidRegion.temple_secret),

    EnemyPlacement("PITT_A1", "HiddenPittA1", 0, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "HiddenPittA1", 1, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "HiddenPittA1", 2, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "HiddenPittA1", 3, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "HiddenPittA1", 4, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "HiddenPittA1", 5, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "HiddenPittA1", 6, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "HiddenPittA1", 7, Enemy.mummy_knight, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "HiddenPittA1", 8, Enemy.mummy_knight, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "HiddenPittA1", 9, Enemy.mummy_knight, LunacidRegion.temple_locked),

    EnemyPlacement("PITT_A1", "CrawlingPittA1", 0, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "CrawlingPittA1", 1, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "CrawlingPittA1", 2, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "CrawlingPittA1", 3, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "CrawlingPittA1", 4, Enemy.mummy, LunacidRegion.temple_secret),
    EnemyPlacement("PITT_A1", "CrawlingPittA1", 5, Enemy.mummy, LunacidRegion.temple_locked),
    EnemyPlacement("PITT_A1", "CrawlingPittA1", 6, Enemy.mummy, LunacidRegion.temple_locked),

    # Yosei Forest
    EnemyPlacement("FOREST_A1", "LowerFrontForestA1", 0, Enemy.kodama, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerFrontForestA1", 1, Enemy.kodama, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerFrontForestA1", 2, Enemy.kodama, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerFrontForestA1", 3, Enemy.kodama, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerFrontForestA1", 4, Enemy.yakul, LunacidRegion.yosei_forest),

    EnemyPlacement("FOREST_A1", "LowerBackYakulForestA1", 0, Enemy.yakul, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerBackYakulForestA1", 1, Enemy.yakul, LunacidRegion.yosei_forest),

    EnemyPlacement("FOREST_A1", "LowerBackBunForestA1", 0, Enemy.kodama, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerBackBunForestA1", 1, Enemy.kodama, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerBackBunForestA1", 2, Enemy.kodama, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerBackBunForestA1", 3, Enemy.kodama, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerBackBunForestA1", 4, Enemy.kodama, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "LowerBackBunForestA1", 5, Enemy.kodama, LunacidRegion.yosei_forest),

    EnemyPlacement("FOREST_A1", "MainForestA1", 10, Enemy.venus, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 11, Enemy.venus, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 12, Enemy.venus, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 13, Enemy.venus, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 14, Enemy.venus, LunacidRegion.yosei_forest),
    EnemyPlacement("FOREST_A1", "MainForestA1", 15, Enemy.venus, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 16, Enemy.neptune, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 17, Enemy.neptune, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 18, Enemy.neptune, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 19, Enemy.neptune, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 20, Enemy.neptune, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 21, Enemy.venus, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 22, Enemy.venus, LunacidRegion.yosei_lower),
    EnemyPlacement("FOREST_A1", "MainForestA1", 23, Enemy.venus, LunacidRegion.yosei_lower),

    # The Fetid Mire
    EnemyPlacement("SEWER_A1", "MainSewerA1", 8, Enemy.devil_slime, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 9, Enemy.devil_slime, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 10, Enemy.devil_slime, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 12, Enemy.rat_king, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 13, Enemy.rat_king, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 14, Enemy.slime_skeleton, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 15, Enemy.slime_skeleton, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 17, Enemy.slime_skeleton, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 18, Enemy.slime_skeleton, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 19, Enemy.slime_skeleton, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 22, Enemy.rat, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 23, Enemy.skeleton, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 24, Enemy.rat_queen, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 25, Enemy.rat_queen, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 26, Enemy.rat_queen, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 27, Enemy.rat, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 28, Enemy.rat, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 29, Enemy.rat, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 30, Enemy.rat, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 31, Enemy.rat, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 36, Enemy.slime_skeleton, LunacidRegion.fetid_mire),
    EnemyPlacement("SEWER_A1", "MainSewerA1", 37, Enemy.slime_skeleton, LunacidRegion.fetid_mire),

    # Forest Canopy
    EnemyPlacement("FOREST_B1", "NestForestB1", 0, Enemy.unilateralis, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "NestForestB1", 1, Enemy.tillandsia, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "NestForestB1", 2, Enemy.tillandsia, LunacidRegion.forest_canopy),

    EnemyPlacement("FOREST_B1", "MainForestB1", 2, Enemy.venus, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 3, Enemy.venus, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 4, Enemy.venus, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 5, Enemy.neptune, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 6, Enemy.venus, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 7, Enemy.venus, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 8, Enemy.tillandsia, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 9, Enemy.tillandsia, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 10, Enemy.tillandsia, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 11, Enemy.tillandsia, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 12, Enemy.tillandsia, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 13, Enemy.tillandsia, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 15, Enemy.unilateralis, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 16, Enemy.unilateralis, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 17, Enemy.unilateralis, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 18, Enemy.unilateralis, LunacidRegion.forest_canopy),
    EnemyPlacement("FOREST_B1", "MainForestB1", 19, Enemy.unilateralis, LunacidRegion.forest_canopy),

    # Sanguine Sea.  Only has "dry", should try to find a way to apply the "wet" ones too; they should be the same.
    EnemyPlacement("LAKE", "DryLake", 3, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryLake", 4, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryLake", 5, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryLake", 6, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryLake", 7, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryLake", 8, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryLake", 9, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryLake", 10, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryLake", 11, Enemy.hemalith, LunacidRegion.sanguine_sea),

    EnemyPlacement("LAKE", "DryNest1Lake", 0, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryNest1Lake", 1, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryNest1Lake", 2, Enemy.hemalith, LunacidRegion.sanguine_sea),

    EnemyPlacement("LAKE", "DryNest2Lake", 0, Enemy.hemalith, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "DryNest2Lake", 1, Enemy.hemalith, LunacidRegion.sanguine_sea),

    EnemyPlacement("LAKE", "MainLake", 1, Enemy.shulker, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 2, Enemy.shulker, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 3, Enemy.shulker, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 4, Enemy.shulker, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 7, Enemy.skeleton, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 8, Enemy.skeleton_weapon, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 9, Enemy.skeleton_weapon, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 10, Enemy.skeleton, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 11, Enemy.skeleton_weapon, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 12, Enemy.skeleton_weapon, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 13, Enemy.skeleton_weapon, LunacidRegion.sanguine_sea),
    EnemyPlacement("LAKE", "MainLake", 14, Enemy.skeleton, LunacidRegion.sanguine_sea),

    # Forbidden Archives
    EnemyPlacement("ARCHIVES", "MainArchives", 1, Enemy.necronomicon, LunacidRegion.forbidden_archives_2f),
    EnemyPlacement("ARCHIVES", "MainArchives", 2, Enemy.necronomicon, LunacidRegion.forbidden_archives_2f),
    EnemyPlacement("ARCHIVES", "MainArchives", 3, Enemy.necronomicon, LunacidRegion.forbidden_archives_2f),
    EnemyPlacement("ARCHIVES", "MainArchives", 4, Enemy.necronomicon, LunacidRegion.forbidden_archives_2f),
    EnemyPlacement("ARCHIVES", "MainArchives", 5, Enemy.necronomicon, LunacidRegion.forbidden_archives_2f),
    EnemyPlacement("ARCHIVES", "MainArchives", 6, Enemy.necronomicon, LunacidRegion.forbidden_archives_2f),
    EnemyPlacement("ARCHIVES", "MainArchives", 7, Enemy.necronomicon, LunacidRegion.forbidden_archives_2f),
    EnemyPlacement("ARCHIVES", "MainArchives", 8, Enemy.milk_snail, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "MainArchives", 9, Enemy.milk_snail, LunacidRegion.forbidden_archives_3f),
    EnemyPlacement("ARCHIVES", "MainArchives", 10, Enemy.milk_snail, LunacidRegion.forbidden_archives_3f),
    EnemyPlacement("ARCHIVES", "MainArchives", 11, Enemy.milk_snail, LunacidRegion.forbidden_archives_3f),
    EnemyPlacement("ARCHIVES", "MainArchives", 12, Enemy.milk_snail, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "MainArchives", 32, Enemy.necronomicon, LunacidRegion.forbidden_archives_1f_front),

    EnemyPlacement("ARCHIVES", "ChimeraTopArchives", 0, Enemy.chimera, LunacidRegion.forbidden_archives_3f),

    EnemyPlacement("ARCHIVES", "ChimeraLowerArchives", 0, Enemy.chimera, LunacidRegion.forbidden_archives_1f_front),

    EnemyPlacement("ARCHIVES", "SnailNest1Archives", 0, Enemy.milk_snail, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "SnailNest1Archives", 1, Enemy.milk_snail, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "SnailNest1Archives", 2, Enemy.milk_snail, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "SnailNest1Archives", 3, Enemy.milk_snail, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "SnailNest1Archives", 4, Enemy.milk_snail, LunacidRegion.forbidden_archives_1f_front),

    EnemyPlacement("ARCHIVES", "SnailNest2Archives", 0, Enemy.milk_snail, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "SnailNest2Archives", 1, Enemy.milk_snail, LunacidRegion.forbidden_archives_1f_front),

    EnemyPlacement("ARCHIVES", "SnailNest3Archives", 0, Enemy.milk_snail, LunacidRegion.forbidden_archives_3f),
    EnemyPlacement("ARCHIVES", "SnailNest3Archives", 1, Enemy.milk_snail, LunacidRegion.forbidden_archives_3f),

    EnemyPlacement("ARCHIVES", "NerveNest1Archives", 0, Enemy.enlightened_one, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "NerveNest1Archives", 1, Enemy.enlightened_one, LunacidRegion.forbidden_archives_1f_front),

    EnemyPlacement("ARCHIVES", "NerveNest2Archives", 0, Enemy.enlightened_one, LunacidRegion.forbidden_archives_1f_front),

    EnemyPlacement("ARCHIVES", "RandomNest1Archives", 0, Enemy.necronomicon, LunacidRegion.forbidden_archives_2f),
    EnemyPlacement("ARCHIVES", "RandomNest1Archives", 1, Enemy.necronomicon, LunacidRegion.forbidden_archives_2f),
    EnemyPlacement("ARCHIVES", "RandomNest1Archives", 2, Enemy.enlightened_one, LunacidRegion.forbidden_archives_2f),

    EnemyPlacement("ARCHIVES", "NerveNest3Archives", 0, Enemy.enlightened_one, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "NerveNest3Archives", 1, Enemy.enlightened_one, LunacidRegion.forbidden_archives_1f_front),

    EnemyPlacement("ARCHIVES", "RandomNest2Archives", 0, Enemy.enlightened_one, LunacidRegion.forbidden_archives_1f_front),
    EnemyPlacement("ARCHIVES", "RandomNest2Archives", 1, Enemy.necronomicon, LunacidRegion.forbidden_archives_1f_front),

    EnemyPlacement("HAUNT", "JumpscareHaunt", 0, Enemy.skeleton, LunacidRegion.accursed_tomb),

    EnemyPlacement("HAUNT", "NestHaunt", 0, Enemy.skeleton, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "NestHaunt", 1, Enemy.skeleton, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "NestHaunt", 2, Enemy.skeleton, LunacidRegion.accursed_tomb),

    EnemyPlacement("HAUNT", "MainHaunt", 2, Enemy.rat_king, LunacidRegion.vampire_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 3, Enemy.mi_go, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 4, Enemy.mi_go, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 5, Enemy.mi_go, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 6, Enemy.mi_go, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 7, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 8, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 9, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 10, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 11, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 12, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 13, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 14, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 15, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 16, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 17, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 18, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 19, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 20, Enemy.mare, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 21, Enemy.mi_go, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 22, Enemy.mi_go, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 23, Enemy.skeleton, LunacidRegion.accursed_tomb_platform),
    EnemyPlacement("HAUNT", "MainHaunt", 24, Enemy.skeleton_weapon, LunacidRegion.accursed_tomb_platform),
    EnemyPlacement("HAUNT", "MainHaunt", 25, Enemy.skeleton_weapon, LunacidRegion.accursed_tomb_platform),
    EnemyPlacement("HAUNT", "MainHaunt", 26, Enemy.cursed_painting, LunacidRegion.accursed_tomb_platform),
    EnemyPlacement("HAUNT", "MainHaunt", 28, Enemy.cursed_painting, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 29, Enemy.cursed_painting, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 30, Enemy.cursed_painting, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 31, Enemy.cursed_painting, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 32, Enemy.cursed_painting, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 33, Enemy.cursed_painting, LunacidRegion.accursed_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 34, Enemy.cursed_painting, LunacidRegion.vampire_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 35, Enemy.cursed_painting, LunacidRegion.vampire_tomb),
    EnemyPlacement("HAUNT", "MainHaunt", 36, Enemy.cursed_painting, LunacidRegion.accursed_tomb_platform),
    EnemyPlacement("HAUNT", "MainHaunt", 37, Enemy.cursed_painting, LunacidRegion.accursed_tomb_platform),
    EnemyPlacement("HAUNT", "MainHaunt", 39, Enemy.skeleton, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 40, Enemy.skeleton_weapon, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 41, Enemy.skeleton_weapon, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 42, Enemy.skeleton_weapon, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 43, Enemy.skeleton_weapon, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 44, Enemy.skeleton, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 45, Enemy.skeleton_weapon, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 46, Enemy.phantom, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 47, Enemy.phantom, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 48, Enemy.phantom, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 49, Enemy.phantom, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 50, Enemy.phantom, LunacidRegion.mausoleum),
    EnemyPlacement("HAUNT", "MainHaunt", 51, Enemy.phantom, LunacidRegion.mausoleum),

    # Castle Le Fanu
    EnemyPlacement("CAS_1", "RedAreaCas1", 0, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison),
    EnemyPlacement("CAS_1", "RedAreaCas1", 1, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison),
    EnemyPlacement("CAS_1", "RedAreaCas1", 2, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison),
    EnemyPlacement("CAS_1", "RedAreaCas1", 3, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison),
    EnemyPlacement("CAS_1", "RedAreaCas1", 4, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison),
    EnemyPlacement("CAS_1", "RedAreaCas1", 5, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison),
    EnemyPlacement("CAS_1", "RedAreaCas1", 6, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison_deep),
    EnemyPlacement("CAS_1", "RedAreaCas1", 8, Enemy.vampire_page, LunacidRegion.castle_le_fanu_cattle_prison_deep),
    EnemyPlacement("CAS_1", "RedAreaCas1", 9, Enemy.vampire_page, LunacidRegion.castle_le_fanu_cattle_prison_deep),
    EnemyPlacement("CAS_1", "RedAreaCas1", 10, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison_deep),
    EnemyPlacement("CAS_1", "RedAreaCas1", 11, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison_deep),
    EnemyPlacement("CAS_1", "RedAreaCas1", 12, Enemy.malformed, LunacidRegion.castle_le_fanu_cattle_prison_secret),
    EnemyPlacement("CAS_1", "RedAreaCas1", 13, Enemy.malformed, LunacidRegion.castle_le_fanu_cattle_prison_secret),
    EnemyPlacement("CAS_1", "RedAreaCas1", 14, Enemy.malformed, LunacidRegion.castle_le_fanu_cattle_prison_secret),
    EnemyPlacement("CAS_1", "RedAreaCas1", 15, Enemy.malformed, LunacidRegion.castle_le_fanu_cattle_prison_secret),
    EnemyPlacement("CAS_1", "RedAreaCas1", 16, Enemy.malformed, LunacidRegion.castle_le_fanu_cattle_prison_secret),

    EnemyPlacement("CAS_1", "RedAreaNestCas1", 0, Enemy.vampire, LunacidRegion.castle_le_fanu_cattle_prison_back),
    EnemyPlacement("CAS_1", "RedAreaNestCas1", 1, Enemy.vampire_page, LunacidRegion.castle_le_fanu_cattle_prison_back),

    EnemyPlacement("CAS_1", "EntryCas1", 0, Enemy.phantom, LunacidRegion.castle_le_fanu_entrance),
    EnemyPlacement("CAS_1", "EntryCas1", 1, Enemy.phantom, LunacidRegion.castle_le_fanu_entrance),
    EnemyPlacement("CAS_1", "EntryCas1", 2, Enemy.phantom, LunacidRegion.castle_le_fanu_entrance),
    EnemyPlacement("CAS_1", "EntryCas1", 3, Enemy.phantom, LunacidRegion.castle_le_fanu_entrance),

    EnemyPlacement("CAS_1", "InteriorPhantomCas1", 0, Enemy.phantom, LunacidRegion.castle_le_fanu_main_halls),
    EnemyPlacement("CAS_1", "InteriorPhantomCas1", 1, Enemy.phantom, LunacidRegion.castle_le_fanu_main_halls),
    EnemyPlacement("CAS_1", "InteriorPhantomCas1", 2, Enemy.phantom, LunacidRegion.castle_le_fanu_main_halls),
    EnemyPlacement("CAS_1", "InteriorPhantomCas1", 3, Enemy.phantom, LunacidRegion.castle_le_fanu_main_halls),

    EnemyPlacement("CAS_1", "UndergroundNest1Cas1", 0, Enemy.great_bat, LunacidRegion.castle_le_fanu_cattle_prison_back),
    EnemyPlacement("CAS_1", "UndergroundNest1Cas1", 1, Enemy.great_bat, LunacidRegion.castle_le_fanu_cattle_prison_back),
    EnemyPlacement("CAS_1", "UndergroundNest1Cas1", 2, Enemy.poltergeist, LunacidRegion.castle_le_fanu_cattle_prison_back),

    EnemyPlacement("CAS_1", "UndergroundNest2Cas1", 0, Enemy.malformed, LunacidRegion.castle_le_fanu_cattle_prison_back),
    EnemyPlacement("CAS_1", "UndergroundNest2Cas1", 1, Enemy.malformed, LunacidRegion.castle_le_fanu_cattle_prison_back),

    EnemyPlacement("CAS_1", "InteriorOtherCas1", 0, Enemy.vampire_page, LunacidRegion.castle_le_fanu_main_halls),
    EnemyPlacement("CAS_1", "InteriorOtherCas1", 1, Enemy.vampire_page, LunacidRegion.castle_le_fanu_main_halls),
    EnemyPlacement("CAS_1", "InteriorOtherCas1", 2, Enemy.vampire_page, LunacidRegion.castle_le_fanu_main_halls),
    EnemyPlacement("CAS_1", "InteriorOtherCas1", 3, Enemy.vampire_page, LunacidRegion.castle_le_fanu_main_halls),
    EnemyPlacement("CAS_1", "InteriorOtherCas1", 4, Enemy.vampire_page, LunacidRegion.castle_le_fanu_main_halls),
    EnemyPlacement("CAS_1", "InteriorOtherCas1", 5, Enemy.great_bat, LunacidRegion.castle_le_fanu_main_halls),

    EnemyPlacement("CAS_1", "UpstairsCas1", 0, Enemy.poltergeist, LunacidRegion.castle_le_fanu_upstairs_area),
    EnemyPlacement("CAS_1", "UpstairsCas1", 1, Enemy.phantom, LunacidRegion.castle_le_fanu_upstairs_area),
    EnemyPlacement("CAS_1", "UpstairsCas1", 2, Enemy.phantom, LunacidRegion.castle_le_fanu_upstairs_area),
    EnemyPlacement("CAS_1", "UpstairsCas1", 3, Enemy.poltergeist, LunacidRegion.castle_le_fanu_upstairs_area),
    EnemyPlacement("CAS_1", "UpstairsCas1", 4, Enemy.phantom, LunacidRegion.castle_le_fanu_upstairs_area),
    EnemyPlacement("CAS_1", "UpstairsCas1", 6, Enemy.cursed_painting, LunacidRegion.castle_le_fanu_upstairs_area),
    EnemyPlacement("CAS_1", "UpstairsCas1", 7, Enemy.cursed_painting, LunacidRegion.castle_le_fanu_upstairs_area),
    EnemyPlacement("CAS_1", "UpstairsCas1", 8, Enemy.cursed_painting, LunacidRegion.castle_le_fanu_upstairs_area),

    EnemyPlacement("CAS_1", "UpstairsNestCas1", 0, Enemy.poltergeist, LunacidRegion.castle_le_fanu_upstairs_area),
    EnemyPlacement("CAS_1", "UpstairsNestCas1", 1, Enemy.poltergeist, LunacidRegion.castle_le_fanu_upstairs_area),
    EnemyPlacement("CAS_1", "UpstairsNestCas1", 2, Enemy.poltergeist, LunacidRegion.castle_le_fanu_upstairs_area),

    # Boiling Grotto
    EnemyPlacement("CAVE", "SnakeDen1Cave", 0, Enemy.serpent, LunacidRegion.deep_snake_pit),
    EnemyPlacement("CAVE", "SnakeDen1Cave", 1, Enemy.serpent, LunacidRegion.deep_snake_pit),
    EnemyPlacement("CAVE", "SnakeDen1Cave", 2, Enemy.serpent, LunacidRegion.deep_snake_pit),
    EnemyPlacement("CAVE", "SnakeDen1Cave", 3, Enemy.serpent, LunacidRegion.deep_snake_pit),

    EnemyPlacement("CAVE", "SnakeDen2Cave", 0, Enemy.serpent, LunacidRegion.secret_snake_pit),
    EnemyPlacement("CAVE", "SnakeDen2Cave", 1, Enemy.serpent, LunacidRegion.secret_snake_pit),
    EnemyPlacement("CAVE", "SnakeDen2Cave", 2, Enemy.serpent, LunacidRegion.secret_snake_pit),
    EnemyPlacement("CAVE", "SnakeDen2Cave", 3, Enemy.serpent, LunacidRegion.secret_snake_pit),
    EnemyPlacement("CAVE", "SnakeDen2Cave", 4, Enemy.serpent, LunacidRegion.secret_snake_pit),
    EnemyPlacement("CAVE", "SnakeDen2Cave", 5, Enemy.serpent, LunacidRegion.secret_snake_pit),
    EnemyPlacement("CAVE", "SnakeDen2Cave", 6, Enemy.serpent, LunacidRegion.secret_snake_pit),

    EnemyPlacement("CAVE", "AnpuSpawnCave", 0, Enemy.anpu, LunacidRegion.sand_temple),

    EnemyPlacement("CAVE", "MimicSpawnCave", 0, Enemy.mimic, LunacidRegion.boiling_grotto_secret),

    EnemyPlacement("CAVE", "MummyUpCave", 1, Enemy.anpu, LunacidRegion.sand_temple),

    EnemyPlacement("CAVE", "MainCave", 0, Enemy.ikurrilb, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 1, Enemy.ikurrilb, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 2, Enemy.ikurrilb, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 3, Enemy.ikurrilb, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 4, Enemy.ikurrilb, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 5, Enemy.anpu, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 6, Enemy.anpu, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 7, Enemy.anpu, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 8, Enemy.anpu_sword, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 9, Enemy.anpu_sword, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 13, Enemy.serpent, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 14, Enemy.serpent, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 15, Enemy.serpent, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 16, Enemy.serpent, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 18, Enemy.mimic, LunacidRegion.secret_snake_pit),
    EnemyPlacement("CAVE", "MainCave", 20, Enemy.mimic, LunacidRegion.boiling_grotto_secret),
    EnemyPlacement("CAVE", "MainCave", 23, Enemy.obsidian_skeleton, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 24, Enemy.obsidian_skeleton, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 25, Enemy.skeleton, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 26, Enemy.skeleton_weapon, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 27, Enemy.skeleton_weapon, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 28, Enemy.skeleton, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 29, Enemy.skeleton_weapon, LunacidRegion.boiling_grotto),
    EnemyPlacement("CAVE", "MainCave", 33, Enemy.embalmed, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 34, Enemy.embalmed, LunacidRegion.sand_temple),
    EnemyPlacement("CAVE", "MainCave", 35, Enemy.anpu_sword, LunacidRegion.sand_temple),

    # Sealed Ballroom
    EnemyPlacement("CAS_3", "HallowNest1Cas3", 0, Enemy.hallowed_husk, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "HallowNest1Cas3", 1, Enemy.hallowed_husk, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "HallowNest1Cas3", 2, Enemy.hallowed_husk, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "HallowNest1Cas3", 3, Enemy.hallowed_husk, LunacidRegion.sealed_ballroom),

    EnemyPlacement("CAS_3", "HallowNest2Cas3", 0, Enemy.hallowed_husk, LunacidRegion.sealed_ballroom_secret_walls),  # Some are in walls, but are these the right ones?
    EnemyPlacement("CAS_3", "HallowNest2Cas3", 1, Enemy.hallowed_husk, LunacidRegion.sealed_ballroom_secret_walls),

    EnemyPlacement("CAS_3", "HallowNest3Cas3", 0, Enemy.hallowed_husk, LunacidRegion.sealed_ballroom_rooms),
    EnemyPlacement("CAS_3", "HallowNest3Cas3", 1, Enemy.hallowed_husk, LunacidRegion.sealed_ballroom_rooms),
    EnemyPlacement("CAS_3", "HallowNest3Cas3", 2, Enemy.hallowed_husk, LunacidRegion.sealed_ballroom_rooms),

    EnemyPlacement("CAS_3", "HorseJumpscareCas3", 0, Enemy.mare, LunacidRegion.sealed_ballroom_rooms),

    EnemyPlacement("CAS_3", "MainCas3", 3, Enemy.malformed_horse, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 4, Enemy.malformed_horse, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 5, Enemy.malformed_horse, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 6, Enemy.malformed_horse, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 7, Enemy.malformed_horse, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 8, Enemy.malformed, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 9, Enemy.malformed, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 10, Enemy.malformed, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 11, Enemy.phantom, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 12, Enemy.phantom, LunacidRegion.sealed_ballroom),
    EnemyPlacement("CAS_3", "MainCas3", 13, Enemy.phantom, LunacidRegion.sealed_ballroom),

    # Terminus Prison
    EnemyPlacement("PRISON", "MainPrison", 5, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 8, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 9, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 11, Enemy.lunam, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 12, Enemy.lunam, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 13, Enemy.lunam, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 15, Enemy.jailor, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 16, Enemy.jailor, LunacidRegion.terminus_prison_3f),
    EnemyPlacement("PRISON", "MainPrison", 17, Enemy.jailor, LunacidRegion.terminus_prison_2f),
    EnemyPlacement("PRISON", "MainPrison", 18, Enemy.jailor, LunacidRegion.terminus_prison_2f),
    EnemyPlacement("PRISON", "MainPrison", 19, Enemy.jailor, LunacidRegion.terminus_prison_2f),
    EnemyPlacement("PRISON", "MainPrison", 20, Enemy.jailor, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 21, Enemy.jailor, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 22, Enemy.jailor, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 23, Enemy.jailor, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 24, Enemy.jailor, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 27, Enemy.malformed, LunacidRegion.terminus_prison_3f_rooms),
    EnemyPlacement("PRISON", "MainPrison", 29, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 30, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 31, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 32, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "MainPrison", 33, Enemy.giant_skeleton, LunacidRegion.terminus_prison_basement),
    EnemyPlacement("PRISON", "MainPrison", 34, Enemy.giant_skeleton, LunacidRegion.terminus_prison_basement),
    EnemyPlacement("PRISON", "MainPrison", 35, Enemy.giant_skeleton, LunacidRegion.terminus_prison_basement),
    EnemyPlacement("PRISON", "MainPrison", 37, Enemy.obsidian_skeleton, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 38, Enemy.skeleton, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 39, Enemy.skeleton_weapon, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 40, Enemy.skeleton_weapon, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 41, Enemy.skeleton_weapon, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 42, Enemy.skeleton, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 43, Enemy.skeleton, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 44, Enemy.skeleton_weapon, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 45, Enemy.skeleton_weapon, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 46, Enemy.skeleton, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 47, Enemy.skeleton_weapon, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "MainPrison", 49, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_basement),
    EnemyPlacement("PRISON", "MainPrison", 50, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_basement),
    EnemyPlacement("PRISON", "MainPrison", 51, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_basement),

    EnemyPlacement("PRISON", "CellPrison", 0, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_3f_rooms),
    EnemyPlacement("PRISON", "CellPrison", 1, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_3f_rooms),

    EnemyPlacement("PRISON", "AliveCorpsesPrison", 0, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "AliveCorpsesPrison", 1, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "AliveCorpsesPrison", 2, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),

    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 0, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 1, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 2, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 3, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 4, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 5, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 6, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 7, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 8, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 9, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 10, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 11, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 12, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 13, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 14, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 15, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 16, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 17, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 18, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 19, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),
    EnemyPlacement("PRISON", "NoAggroCorpsesPrison", 20, Enemy.infested_corpse, LunacidRegion.terminus_prison_1f),

    EnemyPlacement("PRISON", "SkelNest1Prison", 0, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "SkelNest1Prison", 1, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),

    EnemyPlacement("PRISON", "SkelNest2Prison", 0, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "SkelNest2Prison", 1, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_4f),

    EnemyPlacement("PRISON", "DogPackPrison", 11, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_basement),
    EnemyPlacement("PRISON", "DogPackPrison", 12, Enemy.lupine_skeleton, LunacidRegion.terminus_prison_basement),

    EnemyPlacement("PRISON", "SkelSpawnPrison", 0, Enemy.obsidian_skeleton, LunacidRegion.terminus_prison_1f),

    EnemyPlacement("PRISON", "RatNestPrison", 0, Enemy.rat, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "RatNestPrison", 1, Enemy.rat, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "RatNestPrison", 2, Enemy.rat, LunacidRegion.terminus_prison_4f),
    EnemyPlacement("PRISON", "RatNestPrison", 3, Enemy.rat, LunacidRegion.terminus_prison_4f),

    # Forlorn Arena
    EnemyPlacement("ARENA", "MainArena", 0, Enemy.sucsarian_dagger, LunacidRegion.forlorn_arena),
    EnemyPlacement("ARENA", "MainArena", 1, Enemy.sucsarian_spear, LunacidRegion.forlorn_arena),
    EnemyPlacement("ARENA", "MainArena", 2, Enemy.sucsarian_dagger, LunacidRegion.forlorn_arena),
    EnemyPlacement("ARENA", "MainArena", 3, Enemy.sucsarian_spear, LunacidRegion.forlorn_arena),
    EnemyPlacement("ARENA", "MainArena", 4, Enemy.sucsarian_spear, LunacidRegion.forlorn_arena),
    EnemyPlacement("ARENA", "MainArena", 5, Enemy.sucsarian_dagger, LunacidRegion.forlorn_arena),
    EnemyPlacement("ARENA", "MainArena", 6, Enemy.sucsarian_dagger, LunacidRegion.forlorn_arena),
    EnemyPlacement("ARENA", "MainArena", 7, Enemy.sucsarian_spear, LunacidRegion.forlorn_arena),
    EnemyPlacement("ARENA", "MainArena", 8, Enemy.vesta, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 9, Enemy.vesta, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 10, Enemy.vesta, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 11, Enemy.vesta, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 12, Enemy.vesta, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 13, Enemy.vesta, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 14, Enemy.vesta, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 15, Enemy.vesta, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 16, Enemy.vesta, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 17, Enemy.vesta, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 18, Enemy.vesta, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 19, Enemy.vesta, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 20, Enemy.vesta, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 21, Enemy.vesta, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 22, Enemy.vesta, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 23, Enemy.ceres, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 24, Enemy.ceres, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 25, Enemy.ceres, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 26, Enemy.ceres, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 27, Enemy.ceres, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 28, Enemy.ceres, LunacidRegion.temple_of_water_lower_secrets),
    EnemyPlacement("ARENA", "MainArena", 29, Enemy.ceres, LunacidRegion.temple_of_water_lower_secrets),
    EnemyPlacement("ARENA", "MainArena", 30, Enemy.ceres, LunacidRegion.temple_of_water_lower_secrets),
    EnemyPlacement("ARENA", "MainArena", 31, Enemy.tillandsia, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 32, Enemy.tillandsia, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 33, Enemy.tillandsia, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 34, Enemy.tillandsia, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 35, Enemy.tillandsia, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 36, Enemy.tillandsia, LunacidRegion.temple_of_water),
    EnemyPlacement("ARENA", "MainArena", 37, Enemy.tillandsia, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 38, Enemy.tillandsia, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 39, Enemy.tillandsia, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 40, Enemy.tillandsia, LunacidRegion.temple_of_water_lower),
    EnemyPlacement("ARENA", "MainArena", 41, Enemy.ceres, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 42, Enemy.ceres, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 43, Enemy.ceres, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 44, Enemy.gloom_wood, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 45, Enemy.gloom_wood, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 46, Enemy.gloom_wood, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 47, Enemy.gloom_wood, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 48, Enemy.tillandsia, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 49, Enemy.sucsarian_dagger, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 50, Enemy.sucsarian_dagger, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 51, Enemy.sucsarian_spear, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 52, Enemy.tillandsia, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 53, Enemy.gloom_wood, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 54, Enemy.tillandsia, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 55, Enemy.tillandsia, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 56, Enemy.sucsarian_dagger, LunacidRegion.temple_of_earth),
    EnemyPlacement("ARENA", "MainArena", 57, Enemy.venus, LunacidRegion.temple_of_earth_secret),
    EnemyPlacement("ARENA", "MainArena", 58, Enemy.venus, LunacidRegion.temple_of_earth_secret),
    EnemyPlacement("ARENA", "MainArena", 59, Enemy.venus, LunacidRegion.temple_of_earth_secret),
    EnemyPlacement("ARENA", "MainArena", 60, Enemy.venus, LunacidRegion.temple_of_earth_secret),
    EnemyPlacement("ARENA", "MainArena", 61, Enemy.venus, LunacidRegion.temple_of_earth_secret),
    EnemyPlacement("ARENA", "MainArena", 62, Enemy.venus, LunacidRegion.temple_of_earth_secret),
    EnemyPlacement("ARENA", "MainArena", 63, Enemy.venus, LunacidRegion.temple_of_earth_secret),

    # Labyrinth of Ash
    EnemyPlacement("VOID", "RayNestVoid", 0, Enemy.cetea, LunacidRegion.labyrinth_interior),
    EnemyPlacement("VOID", "RayNestVoid", 1, Enemy.cetea, LunacidRegion.labyrinth_interior),

    EnemyPlacement("VOID", "MainVoid", 0, Enemy.centaur, LunacidRegion.labyrinth_of_ash),
    EnemyPlacement("VOID", "MainVoid", 1, Enemy.centaur, LunacidRegion.labyrinth_of_ash),
    EnemyPlacement("VOID", "MainVoid", 2, Enemy.centaur, LunacidRegion.labyrinth_of_ash),
    EnemyPlacement("VOID", "MainVoid", 3, Enemy.centaur, LunacidRegion.labyrinth_interior),
    EnemyPlacement("VOID", "MainVoid", 4, Enemy.centaur, LunacidRegion.labyrinth_of_ash),
    EnemyPlacement("VOID", "MainVoid", 6, Enemy.obsidian_skeleton, LunacidRegion.labyrinth_interior),
    EnemyPlacement("VOID", "MainVoid", 7, Enemy.obsidian_skeleton, LunacidRegion.labyrinth_interior),
    EnemyPlacement("VOID", "MainVoid", 8, Enemy.obsidian_skeleton, LunacidRegion.labyrinth_interior),
    EnemyPlacement("VOID", "MainVoid", 10, Enemy.cetea, LunacidRegion.labyrinth_interior),
    EnemyPlacement("VOID", "MainVoid", 11, Enemy.cetea, LunacidRegion.labyrinth_interior),
    EnemyPlacement("VOID", "MainVoid", 12, Enemy.cetea, LunacidRegion.labyrinth_interior),
    EnemyPlacement("VOID", "MainVoid", 13, Enemy.cetea, LunacidRegion.labyrinth_of_ash),
    EnemyPlacement("VOID", "MainVoid", 14, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 15, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 16, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 17, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 18, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 19, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 20, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 21, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 22, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 23, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 24, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
    EnemyPlacement("VOID", "MainVoid", 25, Enemy.hallowed_husk, LunacidRegion.holy_seat_of_gold),
]

immovable_enemies = {
    Enemy.demon: [LunacidRegion.sanguine_sea, LunacidRegion.mausoleum],
    Enemy.slime: [LunacidRegion.fetid_mire, LunacidRegion.fetid_mire_high_secrets],
    Enemy.umbra: [LunacidRegion.holy_battleground],

}


def construct_flag_data_for_mod(enemy_data: List[EnemyPlacement]) -> Dict[str, List[str]]:
    mod_package = {}
    for enemy in enemy_data:
        if enemy.scene not in mod_package:
            mod_package[enemy.scene] = [enemy.group_name + "|" + str(enemy.child_id) + "|" + enemy.enemy]
        else:
            mod_package[enemy.scene].append(enemy.group_name + "|" + str(enemy.child_id) + "|" + enemy.enemy)
    return mod_package


def construct_enemy_dictionary(enemy_data: List[EnemyPlacement]) -> Dict[str, List[str]]:
    enemy_to_regions: Dict[str, List[str]] = {}
    for data in enemy_data:
        if data.enemy in enemy_to_regions:
            if data.region not in enemy_to_regions[data.enemy]:
                enemy_to_regions[data.enemy].append(data.region)
        else:
            enemy_to_regions[data.enemy] = [data.region]
    return enemy_to_regions
