from typing import Any, TYPE_CHECKING

if TYPE_CHECKING:
    from . import LunacidWorld


def setup_options_from_slot_data(world: "LunacidWorld"):
    if hasattr(world.multiworld, "re_gen_passthrough"):
        if "Lunacid" in world.multiworld.re_gen_passthrough:
            world.passthrough = world.multiworld.re_gen_passthrough["Lunacid"]
            world.options.ending.value = world.passthrough["ending"]
            world.options.starting_class.value = world.passthrough["starting_class"]
            world.options.starting_area.value = world.passthrough["starting_area"]
            world.options.entrance_randomization.value = world.passthrough["entrance_randomization"]
            world.options.experience.value = world.passthrough["experience"]
            world.options.weapon_experience.value = world.passthrough["weapon_experience"]
            world.options.random_elements.value = world.passthrough["random_elements"]
            world.options.enemy_randomization.value = world.passthrough["enemy_randomization"]
            world.options.required_strange_coin.value = world.passthrough["required_strange_coin"]
            world.options.total_strange_coin.value = world.passthrough["total_strange_coin"]
            world.options.shopsanity.value = world.passthrough["shopsanity"]
            world.options.dropsanity.value = world.passthrough["dropsanity"]
            world.options.quenchsanity.value = world.passthrough["quenchsanity"]
            world.options.etnas_pupil.value = world.passthrough["etnas_pupil"]
            world.options.bookworm.value = world.passthrough["bookworm"]
            world.options.levelsanity.value = world.passthrough["levelsanity"]
            world.options.grasssanity.value = world.passthrough["grasssanity"]
            world.options.breakables.value = world.passthrough["breakables"]
            world.options.normalized_drops.value = world.passthrough["normalized_drops"]
            world.options.secret_door_lock.value = world.passthrough["secret_door_lock"]
            world.options.switch_locks.value = world.passthrough["switch_locks"]
            world.options.door_locks.value = world.passthrough["door_locks"]
            world.starting_weapon = world.passthrough["starting_weapon"]
            world.weapon_elements = world.passthrough["elements"]
            stats = world.passthrough["created_class_stats"]
            stats["Name"] = world.passthrough["created_class_name"]
            stats["Description"] = world.passthrough["created_class_description"]
            world.enemy_regions = world.passthrough["enemy_regions"]
            world.options.custom_class.value = stats
            world.seed = world.passthrough["ut_seed"]
        else:
            world.using_ut = False
    else:
        world.using_ut = False


poptracker_data: dict[str, int] = {
    "Rafters/Ocean Elixir": 1,
    "Bench/Crystal Shard": 2,
    "Clive's Gift/Health Vial": 3,
    "Demi's Gift/Dusty Crystal Orb": 4,
    "Demi's Gift/Class Based Gift": 5,
    "Christmas Present/Jingle Bells": 6,
    "Encouraging Statue/Replica Sword": 9,
    "Rightmost Water Room (Right)/Mana Vial": 10,
    "Rightmost Water Room (Left)/Spell Ring (Ghost Light)": 11,
    "Leftmost Water Room/Health Vial": 12,
    "Chest Near Demi/Spell Ring (Flame Spear)": 13,
    "Near Enchanted Door/Health Vial": 14,
    "Dark Tunnel After Enchanted Door/Torch": 15,
    "Temple Fountain/Health Vial": 16,
    "Temple Ritual Table/Ritual Dagger": 17,
    "Temple Altar Chest/Spell Ring (Lithomancy)": 18,
    "Temple Hidden Room Behind Pillar (Left)/Health Vial": 19,
    "Temple Hidden Room Behind Pillar (Right)/Health Vial": 20,
    "Temple Ritual Table After Bridge/Spell Ring (Flame Flare)": 21,
    "Temple Small Pillar Top/Health Vial": 22,
    "Temple Pillar Room Left/Crystal Shard": 23,
    "Temple Pillar Room Back Left/Wooden Shield": 24,
    "Temple Pillar Room Back Right/Blood Wine": 25,
    "Temple Pillar Room Hidden Room/Spell Ring (Blood Strike)": 26,
    "Temple Hidden Room In Sewer/VHS Tape": 27,
    "Temple Table in Sewer/Stone Club": 28,
    "Temple Sewer Puzzle/Corrupted Key": 29,
    "Temple Blood Altar/10 Strange Coins": 30,
    "Alcove on Path to Yosei Forest/Steel Spear": 31,
    "Room Left of Foyer/Antidote": 37,
    "Hidden Slimey Chest Near Entrance/Spell Ring (Ice Spear)": 38,
    "Hidden Upper Overlook (Left)/Crystal Shard": 39,
    "Hidden Upper Overlook (Right)/Ocean Elixir": 40,
    "Bonenard's Trash/Antidote": 41,
    "Rubble Near Overlook Bridge/Antidote": 42,
    "Slime Skeleton Chest/Spell Ring (Barrier)": 43,
    "Jellisha's Trash/Mana Vial": 44,
    "Jellisha's Quest Reward/Spell Ring (Slime Orb)": 45,
    "Path to Sanguine Sea (Left)/Battle Axe": 46,
    "Path to Sanguine Sea (Right)/Health Vial": 47,
    "Hidden Chest Near Underworks/Earth Elixir": 48,
    "Rubble Near Illusory Wall/Spell Ring (Wind Dash)": 49,
    "Underwater Pipe/Poison Throwing Knife": 50,
    "Underworks Waterfall/Antidote": 51,
    "Underworks Skeleton/Broken Hilt": 52,
    "Pillar In Front of Castle Le Fanu/Corrupted Dagger": 58,
    "Underblood Near Castle Le Fanu/Dark Rapier": 59,
    "Fairy Circle/Spell Ring (Summon Fairy)": 60,
    "Killing the Jotunn/10 Strange Coins": 61,
    "Catacombs Coffins Near Stairs/Health Vial": 67,
    "Catacombs Coffins With Blue Light/Spell Ring (Coffin)": 68,
    "Corrupted Room/White Tape": 69,
    "Gated Tomb Near Corrupted Room/Ocean Elixir": 70,
    "Catacombs Hidden Room/Ocean Elixir": 71,
    "Deep Coffin Storage/Halbard": 72,
    "Red Skeleton/Blade of Jusztina": 73,
    "Mausoleum Hidden Chest/Twisted Staff": 74,
    "Mausoleum Upper Alcove Table/Black Book": 75,
    "Mausoleum Maze (Early)/Holy Water": 76,
    "Mausoleum Maze (Middle)/Health Vial": 77,
    "Mausoleum Central Room (Right)/Health Vial": 78,
    "Mausoleum Central Room (Left)/Holy Water": 79,
    "Mausoleum Central Room (Back)/Earth Elixir": 80,
    "Mausoleum Central Room (Left Path)/Health Vial": 81,
    "Mausoleum Central Room (Right Path)/Ocean Elixir": 82,
    "Kill Death/10 Strange Coins": 83,
    "Tomb With Switch/Vampire Hunter Sword": 84,
    "Tomb With Sitting Corpse/Survey Banner": 85,
    "Demi Chest/Spell Ring (Lightning)": 86,
    "Near Light Switch/Crystal Shard": 87,
    "Hidden Room in Tomb/Earth Elixir": 88,
    "Hidden Chest in Tomb/100 Silver": 89,
    "Barrel Group/Health Vial": 94,
    "Blood Pool/Spell Ring (Blood Drain)": 95,
    "Branches Within Tree/Spell Ring (Holy Warmth)": 96,
    "Chest Near Tree/Elfen Bow": 97,
    "Blood Plant's Insides/Health Vial": 98,
    "Hanging In The Trees/Elfen Sword": 99,
    "Hidden Chest/Spell Ring (Light Reveal)": 100,
    "Room Defended by Blood Plant/Spell Ring (Earth Strike)": 101,
    "Patchouli/Enchanted Key": 102,
    "Patchouli/Ocean Elixir": 103,
    "Yosei Forest/Patchouli's Yuletide Offering": 104,
    "Branch Lower Edge/Crystal Shard": 109,
    "Branch Cave/Fairy Moss": 110,
    "Chest/Spell Ring (Poison Mist)": 111,
    "Wooden Statue (Josiah)/Skull of Josiah": 112,
    "Wooden Statue (Sitting)/Spell Ring (Wind Slicer)": 113,
    "Back Room Past Bridge/Ocean Elixir": 119,
    "Strange Corpse/Spell Ring (Corpse Transformation)": 120,
    "Against Wall Near Trees/Light Urn": 121,
    "Short Wall Near Trees/Health Vial": 122,
    "Snail Lectern (Near)/Spell Ring (Light Reveal)": 123,
    "Snail Lectern (Far)/Spell Ring (Blood Drain)": 124,
    "Rug on Balcony/Mana Vial": 125,
    "Rooftops/Earth Elixir": 126,
    "Hidden Room Upper Floor/Wolfram Greatsword": 127,
    "Hidden Room Lower Floor/Crystal Shard": 128,
    "Near Twisty Tree/Fairy Moss": 129,
    "uwu/Axe of Harming": 130,
    "Daedalus Knowledge/Daedalus Knowledge (First)": 131,
    "Daedalus Knowledge/Daedalus Knowledge (Second)": 132,
    "Daedalus Knowledge/Daedalus Knowledge (Third)": 133,
    "Corner Near Daedalus/Health Vial": 134,
    "Outside Corner/Mana Vial": 140,
    "Cattle Cell (South)/Spectral Candle": 141,
    "Cattle Cell (West)/Health Vial": 142,
    "Cattle Cell (Center)/Spell Ring (Summon Ice Sword)": 143,
    "Cattle Cell (North)/Vampiric Symbol (W)": 144,
    "Hidden Cattle Cell/Wand of Power": 145,
    "Hallway Rubble Room/Light Urn": 146,
    "Hallway Dining Room/Blood Wine": 147,
    "Garrat Resting Room (Fountain)/Holy Water": 148,
    "Garrat Resting Room (Wall)/Crossbow": 149,
    "Hallway Dead End Before Blue Doors/Vampiric Symbol (A)": 150,
    "Upper Floor Coffin Room (Small Room)/Earth Elixir": 151,
    "Upper Floor Coffin Room (Large Room)/Ocean Elixir": 152,
    "Upper Floor Coffin Room (Double)/Blade of Ophelia": 153,
    "Upper Floor Coffin Room (Hallway)/Vampiric Symbol (E)": 154,
    "Entry Small Room Lounge/Blood Wine": 166,
    "Entry Hidden Couch Top/Steel Needle (If Not Bought)": 167,
    "Entry Hidden Couch Bottom/Health Vial": 168,
    "Entry Hidden Cave in a Lounge/Spectral Candle": 169,
    "Entry Lounge Long Table/Health Vial": 170,
    "Side Hidden Cave/Crystal Shard": 171,
    "Side Chest Near Switch/Spell Ring (Earth Thorn)": 172,
    "Side Painting Viewing Room/Ocean Elixir": 173,
    "Side Hidden Casket Room/Health Vial": 174,
    "Side XP Drain Party Room/Marauder Black Flail": 175,
    "Hidden Room/Spell Ring (Ice Tear)": 181,
    "Invisible Path to Cliffside/Blessed Wind": 182,
    "Demi's Gift/Crystal Shard x 3": 188,
    "Crilall's Book Repository/Black Book": 194,
    "Corpse Beneath Entrance/5 Silver": 200,
    "Slab of a Broken Bridge/Crystal Shard": 201,
    "Hidden Chest/25 Silver": 202,
    "Triple Hidden Chest/Ashes": 203,
    "Lava Overseeing Dragon Switch/Spell Ring (Rock Bridge)": 204,
    "Through Dragon Switch Tunnel/Mana Vial": 205,
    "Top Right Sarcophagus/Cloth Bandage": 206,
    "Second Floor Snake Room/Health Vial": 207,
    "Basement Snake Pit/Staff of Osiris": 208,
    "Room Buried in Sand/Staff of Osiris": 209,
    "Basement Stone Rubble/Mana Vial": 210,
    "Hidden Sarcophagus/Cloth Bandage": 211,
    "Second Floor Dead End/Health Vial": 212,
    "Lunacid Sandwich/Iron Claw": 213,
    "Chest Near Switch/Spell Ring (Ignis Calor)": 214,
    "Chest Overlooking Crypt/Ocean Elixir": 215,
    "Floor Switch Maze/Moon Vial": 216,
    "Triple Sarcophagus/10 Silver": 217,
    "Prize Beneath Tree/Moonlight": 222,
    "Floor 5 Chest/Mana Vial": 223,
    "Floor 10 Chest/Antidote": 224,
    "Floor 15 Chest/Fairy Moss": 225,
    "Floor 20 Chest/Spectral Candle": 226,
    "Floor 25 Chest/Health Vial": 227,
    "Floor 30 Chest/Crystal Lantern": 228,
    "Floor 35 Chest/2 Silver": 229,
    "Floor 40 Chest/Spectral Candle": 230,
    "Floor 45 Chest/Earth Elixir": 231,
    "Floor 50 Chest/Ocean Elixir": 232,
    "Third Floor Locked Cell Left/Cloth Bandage": 258,
    "Third Floor Locked Cell Right/Ashes": 259,
    "Third Floor Locked Cell South/Broken Lance": 260,
    "Almost Bottomless Pit/Spell Ring (Icarian Flight)": 261,
    "Second Floor Broken Cell/Cloth Bandage": 262,
    "Second Floor Jailer's Table/Terminus Prison Key": 263,
    "First Floor Hidden Cell/Holy Water": 264,
    "First Floor Hidden Debris Room/Light Urn": 265,
    "First Floor Remains/Fishing Spear": 266,
    "Green Asylum Guarded Alcove (Left)/Moonlight Vial": 267,
    "Green Asylum Guarded Alcove (Right)/Moonlight Vial": 268,
    "Green Asylum Long Alcove/Earth Elixir": 269,
    "Green Asylum Bone Pit/Health Vial": 270,
    "Fourth Floor Cell Hanging Remains/Health Vial": 271,
    "Fourth Floor Maledictus Secret/Spell Ring (Blue Flame Arc)": 272,
    "Fourth Floor Hidden Jailer Sleeping Spot/Holy Water": 273,
    "Fourth Floor Jailer Break Room/Mana Vial": 274,
    "Etna's Resting Place Item 1/Moonpetal": 275,
    "Etna's Resting Place Item 2/Ectoplasm": 276,
    "Etna's Resting Place Item 3/Snowflake Obsidian": 277,
    "Fourth Floor Collapsed Tunnel/Hammer of Cruelty": 278,
    "Egg's Resting Place/Skeletal Rattle": 279,
    "Corpse Waiting For A Full Moon/Broken Sword": 284,
    "Entry Rock Parkour/Health Vial": 285,
    "Temple of Earth Hidden Plant Haven/Shadow Blade": 286,
    "Temple of Earth Hidden Room/Earth Elixir": 287,
    "Temple of Earth Fractured Chest/Fractured Life": 288,
    "Temple of Earth Chest Near Switch/Earth Talisman": 289,
    "Temple of Water Room Near Water/Fairy Moss": 290,
    "Temple of Water Corner Near Water/Antidote": 291,
    "Temple of Water Collapsed End Near Balcony/Health Vial": 292,
    "Temple of Water Hidden Basement/Antidote (Left)": 293,
    "Temple of Water Hidden Basement/Antidote (Right)": 294,
    "Temple of Water Hidden Laser Room/Obsidian Sword": 295,
    "Temple of Water Hidden Alcove Before Stairs/Health Vial": 296,
    "Temple of Water Hidden Alcove/Wisp Heart (Left)": 297,
    "Temple of Water Hidden Alcove/Wisp Heart (Right)": 298,
    "Temple of Water Hidden Alcove Before Switch/Ocean Elixir": 299,
    "Temple of Water Fractured Chest/Fractured Death": 300,
    "Temple of Water Chest Near Switch/Water Talisman": 301,
    "Entry Coffin/Mana Vial": 307,
    "Giant Remains/Health Vial": 308,
    "Behind Statue/Wisp Heart": 309,
    "Rocks Near Switch/Spell Ring (Lava Chasm)": 310,
    "Forbidden Light Chest/Spell Ring (Spirit Warp)": 311,
    "Hidden Light Stash/Dark Urn": 312,
    "NNSNSSNSNN Lost Maze/Serpent Fang": 313,
    "Calamis' Weapon of Choice/Lucid Blade": 319,
    "Sheryl's Shop/Rapier": 351,
    "Sheryl's Shop/Crossbow": 352,
    "Sheryl's Shop/Oil Lantern": 353,
    "Sheryl's Shop/Enchanted Key": 354,
    "Sheryl's Shop/Jotunn Slayer": 355,
    "Sheryl's Shop/Privateer Musket": 356,
    "Sheryl's Shop/Steel Needle": 357,
    "Patchouli's Shop/Ocean Elixir": 359,
    "Snail/Summon Snail Drop": 401,
    "Mummy Knight/Rusted Sword Drop": 402,
    "Kodama/Summon Kodama Drop": 403,
    "Chimera/Quick Stride Drop": 404,
    "Milk Snail/Ice Sickle Drop": 405,
    "Skeleton/Skeleton Axe Drop": 406,
    "Skeleton/Dark Skull Drop": 407,
    "Phantom/Cursed Blade Drop": 408,
    "Obsidian Skeleton/Obsidian Cursebrand Drop": 409,
    "Obsidian Skeleton/Obsidian Poisonguard Drop": 410,
    "Anpu/Golden Khopesh Drop": 411,
    "Anpu/Golden Sickle Drop": 412,
    "Malformed Horse/Brittle Arming Sword Drop": 413,
    "Jailor/Jailor's Candle Drop": 414,
    "Vampire Page/Lyrian Longsword Drop": 415,
    "Sucsarian/Sucsarian Dagger Drop": 416,
    "Sucsarian/Sucsarian Spear Drop": 417,
    "Giant Skeleton/Dark Skull Drop": 418,
    "Cetea/Tornado Drop": 419,
    "Abyssal Demon/Ocean Elixir Drop": 420,
    "Lupine Skeleton/Dark Skull Drop": 421,
    "Snail/Small Silver Drop": 451,
    "Snail/Large Silver Drop": 452,
    "Snail/Ocean Bone Shard Drop": 453,
    "Milk Snail/Small Silver Drop": 454,
    "Milk Snail/Large Silver Drop": 455,
    "Milk Snail/Ocean Bone Shard Drop": 456,
    "Shulker/Obsidian Drop": 457,
    "Shulker/Onyx Drop": 458,
    "Mummy/Mana Vial Drop": 459,
    "Mummy/Onyx Drop": 460,
    "Mummy/Small Silver Drop": 461,
    "Mummy/Large Silver Drop": 462,
    "Necronomicon/Fire Opal Drop": 463,
    "Necronomicon/Medium Silver Drop": 464,
    "Necronomicon/Large Silver Drop": 465,
    "Necronomicon/Mana Vial Drop": 466,
    "Chimera/Light Urn Drop": 467,
    "Chimera/Holy Water Drop": 468,
    "Enlightened One/Mana Vial Drop": 469,
    "Enlightened One/Ocean Bone Shell Drop": 470,
    "Slime Skeleton/Ashes Drop": 471,
    "Skeleton/Medium Silver Drop": 472,
    "Skeleton/Mana Vial": 473,
    "Skeleton/Onyx Drop": 474,
    "Skeleton/Bones Drop": 475,
    "Rat King/Large Silver Drop": 476,
    "Rat King/Lotus Seed Pod Drop": 477,
    "Rat/Small Silver Drop": 478,
    "Kodama/Small Silver Drop": 479,
    "Kodama/Medium Silver Drop": 480,
    "Kodama/Opal Drop": 481,
    "Yakul/Medium Silver Drop": 482,
    "Yakul/Fire Opal Drop": 483,
    "Yakul/Opal Drop": 484,
    "Yakul/Health Vial Drop": 485,
    "Venus/Medium Silver Drop": 486,
    "Venus/Yellow Morel Drop": 487,
    "Venus/Destroying Angel Mushroom Drop": 488,
    "Neptune/Medium Silver Drop": 489,
    "Neptune/Yellow Morel Drop": 490,
    "Neptune/Destroying Angel Mushroom Drop": 491,
    "Unilateralis/Medium Silver Drop": 492,
    "Unilateralis/Yellow Morel Drop": 493,
    "Unilateralis/Destroying Angel Mushroom Drop": 494,
    "Hemalith/Health Vial Drop": 495,
    "Hemalith/Pink Shrimp Drop": 496,
    "Hemalith/Bloodweed Drop": 497,
    "Mi-Go/Ocean Bone Shell Drop": 498,
    "Mi-Go/Medium Silver Drop": 499,
    "Mi-Go/Snowflake Obsidian": 500,
    "Mare/Medium Silver Drop": 501,
    "Mare/Obsidian Drop": 502,
    "Mare/Onyx Drop": 503,
    "Cursed Painting/Fire Opal Drop": 504,
    "Cursed Painting/Medium Silver Drop": 505,
    "Cursed Painting/Mana Vial Pickup": 506,
    "Cursed Painting/Large Silver Drop": 507,
    "Phantom/Medium Silver Drop": 508,
    "Phantom/Holy Water Drop": 509,
    "Phantom/Moonlight Vial Drop": 510,
    "Phantom/Ectoplasm Drop": 511,
    "Vampire/Large Silver Drop": 512,
    "Vampire/Vampiric Ashes Drop": 513,
    "Vampire/Cloth Bandage Drop": 514,
    "Vampire Page/Vampiric Ashes Drop": 515,
    "Vampire Page/Large Silver Drop": 516,
    "Malformed/Vampiric Ashes Drop": 517,
    "Great Bat/Health Vial Drop": 518,
    "Great Bat/Obsidian Drop": 519,
    "Great Bat/Large Silver Drop": 520,
    "Poltergeist/Large Silver Drop": 521,
    "Poltergeist/Ectoplasm Drop": 522,
    "Malformed Horse/Large Silver Drop": 523,
    "Malformed Horse/Mana Vial Drop": 524,
    "Hallowed Husk/Large Silver Drop": 525,
    "Hallowed Husk/Bones Drop": 526,
    "Hallowed Husk/Cloth Bandage Drop": 527,
    "Hallowed Husk/Light Urn Drop": 528,
    "Hallowed Husk/Fool's Gold Drop": 529,
    "Hallowed Husk/Holy Water Drop": 530,
    "Ikurr'ilb/Ikurr'ilb Root Drop": 531,
    "Ikurr'ilb/Medium Silver Drop": 532,
    "Ikurr'ilb/Snowflake Obsidian Drop": 533,
    "Mimic/Moonlight Vial Drop": 534,
    "Mimic/Obsidian Drop": 535,
    "Mimic/Fool's Gold Drop": 536,
    "Obsidian Skeleton/Large Silver Drop": 537,
    "Obsidian Skeleton/Bones Drop": 538,
    "Obsidian Skeleton/Mana Vial Drop": 539,
    "Obsidian Skeleton/Obsidian Drop": 540,
    "Anpu/Large Silver Drop": 541,
    "Anpu/Fire Opal Drop": 542,
    "Serpent/Antidote Drop": 543,
    "Serpent/Small Silver Drop": 544,
    "Embalmed/Cloth Bandage Drop": 545,
    "Embalmed/Ashes Drop": 546,
    "Embalmed/Bones Drop": 547,
    "Jailor/Large Silver Drop": 548,
    "Jailor/Spectral Candle Drop": 549,
    "Jailor/Cloth Bandage Drop": 550,
    "Jailor/Health Vial Drop": 551,
    "Jailor/Angel's Feather Drop": 552,
    "Cerritulus Lunam/Ectoplasm Drop": 553,
    "Cerritulus Lunam/Medium Silver Drop": 554,
    "Cerritulus Lunam/Snowflake Obsidian Drop": 555,
    "Giant Skeleton/Dark Urn Drop": 556,
    "Giant Skeleton/Bones Drop": 557,
    "Giant Skeleton/Mana Vial Drop": 558,
    "Giant Skeleton/Onyx Drop": 559,
    "Sucsarian/Large Silver Drop": 560,
    "Sucsarian/Obsidian Drop": 561,
    "Sucsarian/Snowflake Obsidian Drop": 562,
    "Sucsarian/Throwing Knife Drop": 563,
    "Vesta/Fairy Moss Drop": 564,
    "Vesta/Yellow Morel Drop": 565,
    "Vesta/Destroying Angel Mushroom Drop": 566,
    "Ceres/Fairy Moss Drop": 567,
    "Ceres/Yellow Morel Drop": 568,
    "Ceres/Destroying Angel Mushroom Drop": 569,
    "Gloom Wood/Fairy Moss Drop": 570,
    "Gloom Wood/Health Vial Drop": 571,
    "Gloom Wood/Mana Vial Drop": 572,
    "Cetea/Medium Silver Drop": 573,
    "Cetea/Ocean Bone Shell Drop": 574,
    "Mummy Knight/Onyx Drop": 575,
    "Mummy Knight/Large Silver Drop": 576,
    "Mummy Knight/Small Silver Drop": 577,
    "Sanguis Umbra/Black Book Drop": 578,
    "Lupine Skeleton/Medium Silver Drop": 579,
    "Lupine Skeleton/Onyx Drop": 580,
    "Lupine Skeleton/Bones Drop": 581,
    "Infested Corpse/Bones": 582,
    "Infested Corpse/Antidote Drop": 583,
    "Quenchsanity/Quench Steel Claw": 601,
    "Quenchsanity/Quench Iron Claw": 602,
    "Quenchsanity/Quench Iron Club": 603,
    "Quenchsanity/Quench Stone Club": 604,
    "Quenchsanity/Quench Torch": 605,
    "Quenchsanity/Quench Brittle Arming Sword": 606,
    "Quenchsanity/Quench Broken Hilt": 607,
    "Quenchsanity/Quench Broken Lance": 608,
    "Quenchsanity/Quench Crossbow": 609,
    "Quenchsanity/Quench Elfen Sword": 610,
    "Quenchsanity/Quench Lyrian Longsword": 611,
    "Quenchsanity/Quench Obsidian Seal": 612,
    "Quenchsanity/Quench Obsidian Cursebrand": 613,
    "Quenchsanity/Quench Obsidian Poisonguard": 614,
    "Quenchsanity/Quench Rapier": 615,
    "Quenchsanity/Quench Replica Sword": 616,
    "Quenchsanity/Quench Rusted Sword": 617,
    "Quenchsanity/Quench Shadow Blade": 618,
    "Quenchsanity/Quench Shining Blade": 619,
    "Quenchsanity/Quench Death Scythe": 620,
    "Etna's Pupil/Alchemize Concentrated Lunacy": 651,
    "Etna's Pupil/Alchemize Hostility Barrier": 652,
    "Etna's Pupil/Alchemize Explosives": 653,
    "Etna's Pupil/Alchemize Venomous Object": 654,
    "Etna's Pupil/Alchemize Defense Construct": 655,
    "Etna's Pupil/Alchemize Concentrated Poison": 656,
    "Etna's Pupil/Alchemize Nature": 657,
    "Etna's Pupil/Alchemize Antivenom": 658,
    "Etna's Pupil/Alchemize Cleromancy Tool": 659,
    "Etna's Pupil/Alchemize Healing Remedy": 660,
    "Etna's Pupil/Alchemize Water of Life": 661,
    "Etna's Pupil/Alchemize Sharp Object": 662,
    "Etna's Pupil/Alchemize Golden Sin of Abdul": 663,
    "Etna's Pupil/Alchemize Mana Remedy": 664,
    "Etna's Pupil/Alchemize Unstable Stone": 665,
    "Etna's Pupil/Alchemize Simple Life": 666,
}


def map_page_index(data: Any) -> int:
    if not isinstance(data, str):
        return 0
    mapping = {
        "Hollow Basin": 3,
        "The Fetid Mire": 4,
        "Wing's Rest": 2,
        "The Sanguine Sea": 5,
        "Accursed Tomb": 6,
        "Yosei Forest": 7,
        "Forest Canopy": 8,
        "Forbidden Archives": 9,
        "Castle Le Fanu": 10,
        "Sealed Ballroom": 11,
        "Laetus Chasm": 12,
        "Great Well Surface": 13,
        "Throne Chamber": 14,
        "A Holy Battlefield": 15,
        "Boiling Grotto": 16,
        "Tower of Abyss": 17,
        "Terminus Prison": 18,
        "Forlorn Arena": 19,
        "Labyrinth of Ash": 19,
        "Chamber of Fate": 20,
        "Grave of the Sleeper": 21,
    }
    return mapping.get(data, 0)


TRACKER_WORLD = {
    "map_page_folder": "tracker",
    "map_page_maps": "maps/maps.json",
    "map_page_locations": ["locations/locations.json", "locations/Accursed Tomb.json", "locations/A Holy Battlefield.json", "locations/Boiling Grotto.json",
                           "locations/Castle Le Fanu.json", "locations/Chamber of Fate.json", "locations/Forbidden Archives.json", "locations/Forest Canopy.json",
                           "locations/Forlorn Arena.json", "locations/Great Well Surface.json", "locations/Hollow Basin.json", "locations/Labyrinth of Ash.json",
                           "locations/Laetus Chasm.json", "locations/Sand Temple.json", "locations/Sealed Ballroom.json", "locations/Terminus Prison.json",
                           "locations/The Fetid Mire.json", "locations/The Sanguine Sea.json", "locations/Throne Chamber.json", "locations/Tower of Abyss.json",
                           "locations/Wing's Rest.json", "locations/Yosei Forest.json", "locations/misc/Shopsanity.json", "locations/misc/Dropsanity.json",
                           "locations/misc/Etna's Pupil.json", ],
    "map_page_setting_key": "Slot:{player}:currentScene",
    "map_page_index": map_page_index,
    "poptracker_name_mapping": poptracker_data
}
