import typing

from BaseClasses import Location
from .Names import LocationName, ItemName, RegionName
from .Subclasses import LocationData
from .Regions import KH2REGIONS

# data's addrcheck sys3 addr obtained roomid bit index is eventid
LoD_Checks = {
    LocationName.BambooGroveDarkShard:        LocationData(245, "Chest"),
    LocationName.BambooGroveEther:            LocationData(497, "Chest"),
    LocationName.BambooGroveMythrilShard:     LocationData(498, "Chest"),
    LocationName.EncampmentAreaMap:           LocationData(350, "Chest"),
    LocationName.Mission3:                    LocationData(417, "Chest"),
    LocationName.CheckpointHiPotion:          LocationData(21, "Chest"),
    LocationName.CheckpointMythrilShard:      LocationData(121, "Chest"),
    LocationName.MountainTrailLightningShard: LocationData(22, "Chest"),
    LocationName.MountainTrailRecoveryRecipe: LocationData(23, "Chest"),
    LocationName.MountainTrailEther:          LocationData(122, "Chest"),
    LocationName.MountainTrailMythrilShard:   LocationData(123, "Chest"),
    LocationName.VillageCaveAreaMap:          LocationData(495, "Chest"),
    LocationName.VillageCaveDarkShard:        LocationData(125, "Chest"),
    LocationName.VillageCaveAPBoost:          LocationData(124, "Chest"),
    LocationName.VillageCaveBonus:            LocationData(43, "Get Bonus"),
    LocationName.RidgeFrostShard:             LocationData(24, "Chest"),
    LocationName.RidgeAPBoost:                LocationData(126, "Chest"),
    LocationName.ShanYu:                      LocationData(9, "Double Get Bonus"),
    LocationName.ShanYuGetBonus:              LocationData(9, "Second Get Bonus"),
    LocationName.HiddenDragon:                LocationData(257, "Chest"),
    LocationName.ThroneRoomTornPages:         LocationData(25, "Chest"),
    LocationName.ThroneRoomPalaceMap:         LocationData(127, "Chest"),
    LocationName.ThroneRoomAPBoost:           LocationData(26, "Chest"),
    LocationName.ThroneRoomQueenRecipe:       LocationData(27, "Chest"),
    LocationName.ThroneRoomAPBoost2:          LocationData(128, "Chest"),
    LocationName.ThroneRoomOgreShield:        LocationData(129, "Chest"),
    LocationName.ThroneRoomMythrilCrystal:    LocationData(130, "Chest"),
    LocationName.ThroneRoomOrichalcum:        LocationData(131, "Chest"),
    LocationName.StormRider:                  LocationData(10, "Get Bonus"),
    LocationName.XigbarDataDefenseBoost:      LocationData(555, "Chest"),

}
AG_Checks = {
    LocationName.AgrabahMap:                        LocationData(353, "Chest"),
    LocationName.AgrabahDarkShard:                  LocationData(28, "Chest"),
    LocationName.AgrabahMythrilShard:               LocationData(29, "Chest"),
    LocationName.AgrabahHiPotion:                   LocationData(30, "Chest"),
    LocationName.AgrabahAPBoost:                    LocationData(132, "Chest"),
    LocationName.AgrabahMythrilStone:               LocationData(133, "Chest"),
    LocationName.AgrabahMythrilShard2:              LocationData(249, "Chest"),
    LocationName.AgrabahSerenityShard:              LocationData(501, "Chest"),
    LocationName.BazaarMythrilGem:                  LocationData(31, "Chest"),
    LocationName.BazaarPowerShard:                  LocationData(32, "Chest"),
    LocationName.BazaarHiPotion:                    LocationData(33, "Chest"),
    LocationName.BazaarAPBoost:                     LocationData(134, "Chest"),
    LocationName.BazaarMythrilShard:                LocationData(135, "Chest"),
    LocationName.PalaceWallsSkillRing:              LocationData(136, "Chest"),
    LocationName.PalaceWallsMythrilStone:           LocationData(520, "Chest"),
    LocationName.CaveEntrancePowerStone:            LocationData(250, "Chest"),
    LocationName.CaveEntranceMythrilShard:          LocationData(251, "Chest"),
    LocationName.ValleyofStoneMythrilStone:         LocationData(35, "Chest"),
    LocationName.ValleyofStoneAPBoost:              LocationData(36, "Chest"),
    LocationName.ValleyofStoneMythrilShard:         LocationData(137, "Chest"),
    LocationName.ValleyofStoneHiPotion:             LocationData(138, "Chest"),
    LocationName.AbuEscort:                         LocationData(42, "Get Bonus"),
    LocationName.ChasmofChallengesCaveofWondersMap: LocationData(487, "Chest"),
    LocationName.ChasmofChallengesAPBoost:          LocationData(37, "Chest"),
    LocationName.TreasureRoom:                      LocationData(46, "Get Bonus"),
    LocationName.TreasureRoomAPBoost:               LocationData(502, "Chest"),
    LocationName.TreasureRoomSerenityGem:           LocationData(503, "Chest"),
    LocationName.ElementalLords:                    LocationData(37, "Get Bonus"),
    LocationName.LampCharm:                         LocationData(300, "Chest"),
    LocationName.RuinedChamberTornPages:            LocationData(34, "Chest"),
    LocationName.RuinedChamberRuinsMap:             LocationData(486, "Chest"),
    LocationName.GenieJafar:                        LocationData(15, "Get Bonus"),
    LocationName.WishingLamp:                       LocationData(303, "Chest"),
    LocationName.LexaeusBonus:                      LocationData(65, "Get Bonus"),
    LocationName.LexaeusASStrengthBeyondStrength:   LocationData(545, "Chest"),
    LocationName.LexaeusDataLostIllusion:           LocationData(550, "Chest"),
}
DC_Checks = {
    LocationName.DCCourtyardMythrilShard:        LocationData(16, "Chest"),
    LocationName.DCCourtyardStarRecipe:          LocationData(17, "Chest"),
    LocationName.DCCourtyardAPBoost:             LocationData(18, "Chest"),
    LocationName.DCCourtyardMythrilStone:        LocationData(92, "Chest"),
    LocationName.DCCourtyardBlazingStone:        LocationData(93, "Chest"),
    LocationName.DCCourtyardBlazingShard:        LocationData(247, "Chest"),
    LocationName.DCCourtyardMythrilShard2:       LocationData(248, "Chest"),
    LocationName.LibraryTornPages:               LocationData(91, "Chest"),
    LocationName.DisneyCastleMap:                LocationData(332, "Chest"),
    LocationName.MinnieEscort:                   LocationData(38, "Double Get Bonus"),
    LocationName.MinnieEscortGetBonus:           LocationData(38, "Second Get Bonus"),
    LocationName.CornerstoneHillMap:             LocationData(79, "Chest"),
    LocationName.CornerstoneHillFrostShard:      LocationData(12, "Chest"),
    LocationName.PierMythrilShard:               LocationData(81, "Chest"),
    LocationName.PierHiPotion:                   LocationData(82, "Chest"),
    LocationName.WaterwayMythrilStone:           LocationData(83, "Chest"),
    LocationName.WaterwayAPBoost:                LocationData(84, "Chest"),
    LocationName.WaterwayFrostStone:             LocationData(85, "Chest"),
    LocationName.WindowofTimeMap:                LocationData(368, "Chest"),
    LocationName.BoatPete:                       LocationData(16, "Get Bonus"),
    LocationName.FuturePete:                     LocationData(17, "Double Get Bonus"),
    LocationName.FuturePeteGetBonus:             LocationData(17, "Second Get Bonus"),
    LocationName.Monochrome:                     LocationData(261, "Chest"),
    LocationName.WisdomForm:                     LocationData(262, "Chest"),
    LocationName.MarluxiaGetBonus:               LocationData(67, "Get Bonus"),
    LocationName.MarluxiaASEternalBlossom:       LocationData(548, "Chest"),
    LocationName.MarluxiaDataLostIllusion:       LocationData(553, "Chest"),
    LocationName.LingeringWillBonus:             LocationData(70, "Get Bonus"),
    LocationName.LingeringWillProofofConnection: LocationData(587, "Chest"),
    LocationName.LingeringWillManifestIllusion:  LocationData(591, "Chest"),

}

HundredAcre_Checks = {
    LocationName.PoohsHouse100AcreWoodMap:   LocationData(313, "Chest"),
    LocationName.PoohsHouseAPBoost:          LocationData(97, "Chest"),
    LocationName.PoohsHouseMythrilStone:     LocationData(98, "Chest"),
    LocationName.PigletsHouseDefenseBoost:   LocationData(105, "Chest"),
    LocationName.PigletsHouseAPBoost:        LocationData(103, "Chest"),
    LocationName.PigletsHouseMythrilGem:     LocationData(104, "Chest"),
    LocationName.RabbitsHouseDrawRing:       LocationData(314, "Chest"),
    LocationName.RabbitsHouseMythrilCrystal: LocationData(100, "Chest"),
    LocationName.RabbitsHouseAPBoost:        LocationData(101, "Chest"),
    LocationName.KangasHouseMagicBoost:      LocationData(108, "Chest"),
    LocationName.KangasHouseAPBoost:         LocationData(106, "Chest"),
    LocationName.KangasHouseOrichalcum:      LocationData(107, "Chest"),
    LocationName.SpookyCaveMythrilGem:       LocationData(110, "Chest"),
    LocationName.SpookyCaveAPBoost:          LocationData(111, "Chest"),
    LocationName.SpookyCaveOrichalcum:       LocationData(112, "Chest"),
    LocationName.SpookyCaveGuardRecipe:      LocationData(113, "Chest"),
    LocationName.SpookyCaveMythrilCrystal:   LocationData(115, "Chest"),
    LocationName.SpookyCaveAPBoost2:         LocationData(116, "Chest"),
    LocationName.SweetMemories:              LocationData(284, "Chest"),
    LocationName.SpookyCaveMap:              LocationData(485, "Chest"),
    LocationName.StarryHillCosmicRing:       LocationData(312, "Chest"),
    LocationName.StarryHillStyleRecipe:      LocationData(94, "Chest"),
    LocationName.StarryHillCureElement:      LocationData(285, "Chest"),
    LocationName.StarryHillOrichalcumPlus:   LocationData(539, "Chest"),
}
Oc_Checks = {
    LocationName.PassageMythrilShard:            LocationData(7, "Chest"),
    LocationName.PassageMythrilStone:            LocationData(8, "Chest"),
    LocationName.PassageEther:                   LocationData(144, "Chest"),
    LocationName.PassageAPBoost:                 LocationData(145, "Chest"),
    LocationName.PassageHiPotion:                LocationData(146, "Chest"),
    LocationName.InnerChamberUnderworldMap:      LocationData(2, "Chest"),
    LocationName.InnerChamberMythrilShard:       LocationData(243, "Chest"),
    LocationName.Cerberus:                       LocationData(5, "Get Bonus"),
    LocationName.ColiseumMap:                    LocationData(338, "Chest"),
    LocationName.Urns:                           LocationData(57, "Get Bonus"),
    LocationName.UnderworldEntrancePowerBoost:   LocationData(242, "Chest"),
    LocationName.CavernsEntranceLucidShard:      LocationData(3, "Chest"),
    LocationName.CavernsEntranceAPBoost:         LocationData(11, "Chest"),
    LocationName.CavernsEntranceMythrilShard:    LocationData(504, "Chest"),
    LocationName.TheLostRoadBrightShard:         LocationData(9, "Chest"),
    LocationName.TheLostRoadEther:               LocationData(10, "Chest"),
    LocationName.TheLostRoadMythrilShard:        LocationData(148, "Chest"),
    LocationName.TheLostRoadMythrilStone:        LocationData(149, "Chest"),
    LocationName.AtriumLucidStone:               LocationData(150, "Chest"),
    LocationName.AtriumAPBoost:                  LocationData(151, "Chest"),
    LocationName.DemyxOC:                        LocationData(58, "Get Bonus"),
    LocationName.SecretAnsemReport5:             LocationData(529, "Chest"),
    LocationName.OlympusStone:                   LocationData(293, "Chest"),
    LocationName.TheLockCavernsMap:              LocationData(244, "Chest"),
    LocationName.TheLockMythrilShard:            LocationData(5, "Chest"),
    LocationName.TheLockAPBoost:                 LocationData(142, "Chest"),
    LocationName.PeteOC:                         LocationData(6, "Get Bonus"),
    LocationName.Hydra:                          LocationData(7, "Double Get Bonus"),
    LocationName.HydraGetBonus:                  LocationData(7, "Second Get Bonus"),
    LocationName.HerosCrest:                     LocationData(260, "Chest"),
    LocationName.AuronsStatue:                   LocationData(295, "Chest"),
    LocationName.Hades:                          LocationData(8, "Double Get Bonus"),
    LocationName.HadesGetBonus:                  LocationData(8, "Second Get Bonus"),
    LocationName.GuardianSoul:                   LocationData(272, "Chest"),
    LocationName.ZexionBonus:                    LocationData(66, "Get Bonus"),
    LocationName.ZexionASBookofShadows:          LocationData(546, "Chest"),
    LocationName.ZexionDataLostIllusion:         LocationData(551, "Chest"),
    LocationName.ProtectBeltPainandPanicCup:     LocationData(513, "Chest"),
    LocationName.SerenityGemPainandPanicCup:     LocationData(540, "Chest"),
    LocationName.RisingDragonCerberusCup:        LocationData(515, "Chest"),
    LocationName.SerenityCrystalCerberusCup:     LocationData(542, "Chest"),
    LocationName.GenjiShieldTitanCup:            LocationData(514, "Chest"),
    LocationName.SkillfulRingTitanCup:           LocationData(541, "Chest"),
    LocationName.FatalCrestGoddessofFateCup:     LocationData(516, "Chest"),
    LocationName.OrichalcumPlusGoddessofFateCup: LocationData(517, "Chest"),
    LocationName.HadesCupTrophyParadoxCups:      LocationData(518, "Chest"),
}

BC_Checks = {
    LocationName.BCCourtyardAPBoost:            LocationData(39, "Chest"),
    LocationName.BCCourtyardHiPotion:           LocationData(40, "Chest"),
    LocationName.BCCourtyardMythrilShard:       LocationData(505, "Chest"),
    LocationName.BellesRoomCastleMap:           LocationData(46, "Chest"),
    LocationName.BellesRoomMegaRecipe:          LocationData(240, "Chest"),
    LocationName.TheEastWingMythrilShard:       LocationData(63, "Chest"),
    LocationName.TheEastWingTent:               LocationData(155, "Chest"),
    LocationName.TheWestHallHiPotion:           LocationData(41, "Chest"),
    LocationName.TheWestHallPowerShard:         LocationData(207, "Chest"),
    LocationName.TheWestHallAPBoostPostDungeon: LocationData(158, "Chest"),
    LocationName.TheWestHallBrightStone:        LocationData(159, "Chest"),
    LocationName.TheWestHallMythrilShard:       LocationData(206, "Chest"),
    LocationName.Thresholder:                   LocationData(2, "Get Bonus"),
    LocationName.DungeonBasementMap:            LocationData(239, "Chest"),
    LocationName.DungeonAPBoost:                LocationData(43, "Chest"),
    LocationName.SecretPassageMythrilShard:     LocationData(44, "Chest"),
    LocationName.SecretPassageHiPotion:         LocationData(168, "Chest"),
    LocationName.SecretPassageLucidShard:       LocationData(45, "Chest"),
    LocationName.TheWestHallMythrilShard2:      LocationData(208, "Chest"),
    LocationName.TheWestWingMythrilShard:       LocationData(42, "Chest"),
    LocationName.TheWestWingTent:               LocationData(164, "Chest"),
    LocationName.Beast:                         LocationData(12, "Get Bonus"),
    LocationName.TheBeastsRoomBlazingShard:     LocationData(241, "Chest"),
    LocationName.DarkThorn:                     LocationData(3, "Double Get Bonus"),
    LocationName.DarkThornGetBonus:             LocationData(3, "Second Get Bonus"),
    LocationName.DarkThornCureElement:          LocationData(299, "Chest"),
    LocationName.RumblingRose:                  LocationData(270, "Chest"),
    LocationName.CastleWallsMap:                LocationData(325, "Chest"),
    LocationName.Xaldin:                        LocationData(4, "Double Get Bonus"),
    LocationName.XaldinGetBonus:                LocationData(4, "Second Get Bonus"),
    LocationName.SecretAnsemReport4:            LocationData(528, "Chest"),
    LocationName.XaldinDataDefenseBoost:        LocationData(559, "Chest"),
}
SP_Checks = {
    LocationName.PitCellAreaMap:                    LocationData(316, "Chest"),
    LocationName.PitCellMythrilCrystal:             LocationData(64, "Chest"),
    LocationName.CanyonDarkCrystal:                 LocationData(65, "Chest"),
    LocationName.CanyonMythrilStone:                LocationData(171, "Chest"),
    LocationName.CanyonMythrilGem:                  LocationData(253, "Chest"),
    LocationName.CanyonFrostCrystal:                LocationData(521, "Chest"),
    LocationName.Screens:                           LocationData(45, "Get Bonus"),
    LocationName.HallwayPowerCrystal:               LocationData(49, "Chest"),
    LocationName.HallwayAPBoost:                    LocationData(50, "Chest"),
    LocationName.CommunicationsRoomIOTowerMap:      LocationData(255, "Chest"),
    LocationName.CommunicationsRoomGaiaBelt:        LocationData(499, "Chest"),
    LocationName.HostileProgram:                    LocationData(31, "Double Get Bonus"),
    LocationName.HostileProgramGetBonus:            LocationData(31, "Second Get Bonus"),
    LocationName.PhotonDebugger:                    LocationData(267, "Chest"),
    LocationName.SolarSailer:                       LocationData(61, "Get Bonus"),
    LocationName.CentralComputerCoreAPBoost:        LocationData(177, "Chest"),
    LocationName.CentralComputerCoreOrichalcumPlus: LocationData(178, "Chest"),
    LocationName.CentralComputerCoreCosmicArts:     LocationData(51, "Chest"),
    LocationName.CentralComputerCoreMap:            LocationData(488, "Chest"),
    LocationName.MCP:                               LocationData(32, "Double Get Bonus"),
    LocationName.MCPGetBonus:                       LocationData(32, "Second Get Bonus"),
    LocationName.LarxeneBonus:                      LocationData(68, "Get Bonus"),
    LocationName.LarxeneASCloakedThunder:           LocationData(547, "Chest"),
    LocationName.LarxeneDataLostIllusion:           LocationData(552, "Chest"),
}
HT_Checks = {
    LocationName.GraveyardMythrilShard:           LocationData(53, "Chest"),
    LocationName.GraveyardSerenityGem:            LocationData(212, "Chest"),
    LocationName.FinklesteinsLabHalloweenTownMap: LocationData(211, "Chest"),
    LocationName.TownSquareMythrilStone:          LocationData(209, "Chest"),
    LocationName.TownSquareEnergyShard:           LocationData(210, "Chest"),
    LocationName.HinterlandsLightningShard:       LocationData(54, "Chest"),
    LocationName.HinterlandsMythrilStone:         LocationData(213, "Chest"),
    LocationName.HinterlandsAPBoost:              LocationData(214, "Chest"),
    LocationName.CandyCaneLaneMegaPotion:         LocationData(55, "Chest"),
    LocationName.CandyCaneLaneMythrilGem:         LocationData(56, "Chest"),
    LocationName.CandyCaneLaneLightningStone:     LocationData(216, "Chest"),
    LocationName.CandyCaneLaneMythrilStone:       LocationData(217, "Chest"),
    LocationName.SantasHouseChristmasTownMap:     LocationData(57, "Chest"),
    LocationName.SantasHouseAPBoost:              LocationData(58, "Chest"),
    LocationName.PrisonKeeper:                    LocationData(18, "Get Bonus"),
    LocationName.OogieBoogie:                     LocationData(19, "Get Bonus"),
    LocationName.OogieBoogieMagnetElement:        LocationData(301, "Chest"),
    LocationName.Lock:                            LocationData(40, "Get Bonus"),
    LocationName.Present:                         LocationData(297, "Chest"),
    LocationName.DecoyPresents:                   LocationData(298, "Chest"),
    LocationName.Experiment:                      LocationData(20, "Get Bonus"),
    LocationName.DecisivePumpkin:                 LocationData(275, "Chest"),
    LocationName.VexenBonus:                      LocationData(64, "Get Bonus"),
    LocationName.VexenASRoadtoDiscovery:          LocationData(544, "Chest"),
    LocationName.VexenDataLostIllusion:           LocationData(549, "Chest"),
}
PR_Checks = {
    LocationName.RampartNavalMap:              LocationData(70, "Chest"),
    LocationName.RampartMythrilStone:          LocationData(219, "Chest"),
    LocationName.RampartDarkShard:             LocationData(220, "Chest"),
    LocationName.TownDarkStone:                LocationData(71, "Chest"),
    LocationName.TownAPBoost:                  LocationData(72, "Chest"),
    LocationName.TownMythrilShard:             LocationData(73, "Chest"),
    LocationName.TownMythrilGem:               LocationData(221, "Chest"),
    LocationName.CaveMouthBrightShard:         LocationData(74, "Chest"),
    LocationName.CaveMouthMythrilShard:        LocationData(223, "Chest"),
    LocationName.IsladeMuertaMap:              LocationData(329, "Chest"),
    LocationName.BoatFight:                    LocationData(62, "Get Bonus"),
    LocationName.InterceptorBarrels:           LocationData(39, "Get Bonus"),
    LocationName.PowderStoreAPBoost1:          LocationData(369, "Chest"),
    LocationName.PowderStoreAPBoost2:          LocationData(370, "Chest"),
    LocationName.MoonlightNookMythrilShard:    LocationData(75, "Chest"),
    LocationName.MoonlightNookSerenityGem:     LocationData(224, "Chest"),
    LocationName.MoonlightNookPowerStone:      LocationData(371, "Chest"),
    LocationName.Barbossa:                     LocationData(21, "Double Get Bonus"),
    LocationName.BarbossaGetBonus:             LocationData(21, "Second Get Bonus"),
    LocationName.FollowtheWind:                LocationData(263, "Chest"),
    LocationName.GrimReaper1:                  LocationData(59, "Get Bonus"),
    LocationName.InterceptorsHoldFeatherCharm: LocationData(252, "Chest"),
    LocationName.SeadriftKeepAPBoost:          LocationData(76, "Chest"),
    LocationName.SeadriftKeepOrichalcum:       LocationData(225, "Chest"),
    LocationName.SeadriftKeepMeteorStaff:      LocationData(372, "Chest"),
    LocationName.SeadriftRowSerenityGem:       LocationData(77, "Chest"),
    LocationName.SeadriftRowKingRecipe:        LocationData(78, "Chest"),
    LocationName.SeadriftRowMythrilCrystal:    LocationData(373, "Chest"),
    LocationName.SeadriftRowCursedMedallion:   LocationData(296, "Chest"),
    LocationName.SeadriftRowShipGraveyardMap:  LocationData(331, "Chest"),
    LocationName.GrimReaper2:                  LocationData(22, "Get Bonus"),
    LocationName.SecretAnsemReport6:           LocationData(530, "Chest"),
    LocationName.LuxordDataAPBoost:            LocationData(557, "Chest"),
}
HB_Checks = {
    LocationName.MarketplaceMap:                               LocationData(362, "Chest"),
    LocationName.BoroughDriveRecovery:                         LocationData(194, "Chest"),
    LocationName.BoroughAPBoost:                               LocationData(195, "Chest"),
    LocationName.BoroughHiPotion:                              LocationData(196, "Chest"),
    LocationName.BoroughMythrilShard:                          LocationData(305, "Chest"),
    LocationName.BoroughDarkShard:                             LocationData(506, "Chest"),
    LocationName.MerlinsHouseMembershipCard:                   LocationData(256, "Chest"),
    LocationName.MerlinsHouseBlizzardElement:                  LocationData(292, "Chest"),
    LocationName.Bailey:                                       LocationData(47, "Get Bonus"),
    LocationName.BaileySecretAnsemReport7:                     LocationData(531, "Chest"),
    LocationName.BaseballCharm:                                LocationData(258, "Chest"),
    LocationName.PosternCastlePerimeterMap:                    LocationData(310, "Chest"),
    LocationName.PosternMythrilGem:                            LocationData(189, "Chest"),
    LocationName.PosternAPBoost:                               LocationData(190, "Chest"),
    LocationName.CorridorsMythrilStone:                        LocationData(200, "Chest"),
    LocationName.CorridorsMythrilCrystal:                      LocationData(201, "Chest"),
    LocationName.CorridorsDarkCrystal:                         LocationData(202, "Chest"),
    LocationName.CorridorsAPBoost:                             LocationData(307, "Chest"),
    LocationName.AnsemsStudyMasterForm:                        LocationData(276, "Chest"),
    LocationName.AnsemsStudySleepingLion:                      LocationData(266, "Chest"),
    LocationName.AnsemsStudySkillRecipe:                       LocationData(184, "Chest"),
    LocationName.AnsemsStudyUkuleleCharm:                      LocationData(183, "Chest"),
    LocationName.RestorationSiteMoonRecipe:                    LocationData(309, "Chest"),
    LocationName.RestorationSiteAPBoost:                       LocationData(507, "Chest"),
    LocationName.DemyxHB:                                      LocationData(28, "Double Get Bonus"),
    LocationName.DemyxHBGetBonus:                              LocationData(28, "Second Get Bonus"),
    LocationName.FFFightsCureElement:                          LocationData(361, "Chest"),
    LocationName.CrystalFissureTornPages:                      LocationData(179, "Chest"),
    LocationName.CrystalFissureTheGreatMawMap:                 LocationData(489, "Chest"),
    LocationName.CrystalFissureEnergyCrystal:                  LocationData(180, "Chest"),
    LocationName.CrystalFissureAPBoost:                        LocationData(181, "Chest"),
    LocationName.ThousandHeartless:                            LocationData(60, "Get Bonus"),
    LocationName.ThousandHeartlessSecretAnsemReport1:          LocationData(525, "Chest"),
    LocationName.ThousandHeartlessIceCream:                    LocationData(269, "Chest"),
    LocationName.ThousandHeartlessPicture:                     LocationData(511, "Chest"),
    LocationName.PosternGullWing:                              LocationData(491, "Chest"),
    LocationName.HeartlessManufactoryCosmicChain:              LocationData(311, "Chest"),
    LocationName.SephirothBonus:                               LocationData(35, "Get Bonus"),
    LocationName.SephirothFenrir:                              LocationData(282, "Chest"),
    LocationName.WinnersProof:                                 LocationData(588, "Chest"),
    LocationName.ProofofPeace:                                 LocationData(589, "Chest"),
    LocationName.DemyxDataAPBoost:                             LocationData(560, "Chest"),
    LocationName.CoRDepthsAPBoost:                             LocationData(562, "Chest"),
    LocationName.CoRDepthsPowerCrystal:                        LocationData(563, "Chest"),
    LocationName.CoRDepthsFrostCrystal:                        LocationData(564, "Chest"),
    LocationName.CoRDepthsManifestIllusion:                    LocationData(565, "Chest"),
    LocationName.CoRDepthsAPBoost2:                            LocationData(566, "Chest"),
    LocationName.CoRMineshaftLowerLevelDepthsofRemembranceMap: LocationData(580, "Chest"),
    LocationName.CoRMineshaftLowerLevelAPBoost:                LocationData(578, "Chest"),
    LocationName.CoRDepthsUpperLevelRemembranceGem:            LocationData(567, "Chest"),
    LocationName.CoRMiningAreaSerenityGem:                     LocationData(568, "Chest"),
    LocationName.CoRMiningAreaAPBoost:                         LocationData(569, "Chest"),
    LocationName.CoRMiningAreaSerenityCrystal:                 LocationData(570, "Chest"),
    LocationName.CoRMiningAreaManifestIllusion:                LocationData(571, "Chest"),
    LocationName.CoRMiningAreaSerenityGem2:                    LocationData(572, "Chest"),
    LocationName.CoRMiningAreaDarkRemembranceMap:              LocationData(573, "Chest"),
    LocationName.CoRMineshaftMidLevelPowerBoost:               LocationData(581, "Chest"),
    LocationName.CoREngineChamberSerenityCrystal:              LocationData(574, "Chest"),
    LocationName.CoREngineChamberRemembranceCrystal:           LocationData(575, "Chest"),
    LocationName.CoREngineChamberAPBoost:                      LocationData(576, "Chest"),
    LocationName.CoREngineChamberManifestIllusion:             LocationData(577, "Chest"),
    LocationName.CoRMineshaftUpperLevelMagicBoost:             LocationData(582, "Chest"),
    LocationName.CoRMineshaftUpperLevelAPBoost:                LocationData(579, "Chest"),
    LocationName.TransporttoRemembrance:                       LocationData(72, "Get Bonus"),
}
PL_Checks = {
    LocationName.GorgeSavannahMap:              LocationData(492, "Chest"),
    LocationName.GorgeDarkGem:                  LocationData(404, "Chest"),
    LocationName.GorgeMythrilStone:             LocationData(405, "Chest"),
    LocationName.ElephantGraveyardFrostGem:     LocationData(401, "Chest"),
    LocationName.ElephantGraveyardMythrilStone: LocationData(402, "Chest"),
    LocationName.ElephantGraveyardBrightStone:  LocationData(403, "Chest"),
    LocationName.ElephantGraveyardAPBoost:      LocationData(508, "Chest"),
    LocationName.ElephantGraveyardMythrilShard: LocationData(509, "Chest"),
    LocationName.PrideRockMap:                  LocationData(418, "Chest"),
    LocationName.PrideRockMythrilStone:         LocationData(392, "Chest"),
    LocationName.PrideRockSerenityCrystal:      LocationData(393, "Chest"),
    LocationName.WildebeestValleyEnergyStone:   LocationData(396, "Chest"),
    LocationName.WildebeestValleyAPBoost:       LocationData(397, "Chest"),
    LocationName.WildebeestValleyMythrilGem:    LocationData(398, "Chest"),
    LocationName.WildebeestValleyMythrilStone:  LocationData(399, "Chest"),
    LocationName.WildebeestValleyLucidGem:      LocationData(400, "Chest"),
    LocationName.WastelandsMythrilShard:        LocationData(406, "Chest"),
    LocationName.WastelandsSerenityGem:         LocationData(407, "Chest"),
    LocationName.WastelandsMythrilStone:        LocationData(408, "Chest"),
    LocationName.JungleSerenityGem:             LocationData(409, "Chest"),
    LocationName.JungleMythrilStone:            LocationData(410, "Chest"),
    LocationName.JungleSerenityCrystal:         LocationData(411, "Chest"),
    LocationName.OasisMap:                      LocationData(412, "Chest"),
    LocationName.OasisTornPages:                LocationData(493, "Chest"),
    LocationName.OasisAPBoost:                  LocationData(413, "Chest"),
    LocationName.CircleofLife:                  LocationData(264, "Chest"),
    LocationName.Hyenas1:                       LocationData(49, "Get Bonus"),
    LocationName.Scar:                          LocationData(29, "Get Bonus"),
    LocationName.ScarFireElement:               LocationData(302, "Chest"),
    LocationName.Hyenas2:                       LocationData(50, "Get Bonus"),
    LocationName.Groundshaker:                  LocationData(30, "Double Get Bonus"),
    LocationName.GroundshakerGetBonus:          LocationData(30, "Second Get Bonus"),
    LocationName.SaixDataDefenseBoost:          LocationData(556, "Chest"),
}
STT_Checks = {
    LocationName.TwilightTownMap:                 LocationData(319, "Chest"),
    LocationName.MunnyPouchOlette:                LocationData(288, "Chest"),
    LocationName.StationDusks:                    LocationData(54, "Get Bonus", "Roxas", 14),
    LocationName.StationofSerenityPotion:         LocationData(315, "Chest"),
    LocationName.StationofCallingPotion:          LocationData(472, "Chest"),
    LocationName.TwilightThorn:                   LocationData(33, "Get Bonus", "Roxas", 14),
    LocationName.Axel1:                           LocationData(73, "Get Bonus", "Roxas", 14),
    LocationName.JunkChampionBelt:                LocationData(389, "Chest"),
    LocationName.JunkMedal:                       LocationData(390, "Chest"),
    LocationName.TheStruggleTrophy:               LocationData(519, "Chest"),
    LocationName.CentralStationPotion1:           LocationData(428, "Chest"),
    LocationName.STTCentralStationHiPotion:       LocationData(429, "Chest"),
    LocationName.CentralStationPotion2:           LocationData(430, "Chest"),
    LocationName.SunsetTerraceAbilityRing:        LocationData(434, "Chest"),
    LocationName.SunsetTerraceHiPotion:           LocationData(435, "Chest"),
    LocationName.SunsetTerracePotion1:            LocationData(436, "Chest"),
    LocationName.SunsetTerracePotion2:            LocationData(437, "Chest"),
    LocationName.MansionFoyerHiPotion:            LocationData(449, "Chest"),
    LocationName.MansionFoyerPotion1:             LocationData(450, "Chest"),
    LocationName.MansionFoyerPotion2:             LocationData(451, "Chest"),
    LocationName.MansionDiningRoomElvenBandanna:  LocationData(455, "Chest"),
    LocationName.MansionDiningRoomPotion:         LocationData(456, "Chest"),
    LocationName.NaminesSketches:                 LocationData(289, "Chest"),
    LocationName.MansionMap:                      LocationData(483, "Chest"),
    LocationName.MansionLibraryHiPotion:          LocationData(459, "Chest"),
    LocationName.Axel2:                           LocationData(34, "Get Bonus", "Roxas", 14),
    LocationName.MansionBasementCorridorHiPotion: LocationData(463, "Chest"),
    LocationName.RoxasDataMagicBoost:             LocationData(558, "Chest"),

}
TT_Checks = {
    LocationName.OldMansionPotion:                      LocationData(447, "Chest"),
    LocationName.OldMansionMythrilShard:                LocationData(448, "Chest"),
    LocationName.TheWoodsPotion:                        LocationData(442, "Chest"),
    LocationName.TheWoodsMythrilShard:                  LocationData(443, "Chest"),
    LocationName.TheWoodsHiPotion:                      LocationData(444, "Chest"),
    LocationName.TramCommonHiPotion:                    LocationData(420, "Chest"),
    LocationName.TramCommonAPBoost:                     LocationData(421, "Chest"),
    LocationName.TramCommonTent:                        LocationData(422, "Chest"),
    LocationName.TramCommonMythrilShard1:               LocationData(423, "Chest"),
    LocationName.TramCommonPotion1:                     LocationData(424, "Chest"),
    LocationName.TramCommonMythrilShard2:               LocationData(425, "Chest"),
    LocationName.TramCommonPotion2:                     LocationData(484, "Chest"),
    LocationName.StationPlazaSecretAnsemReport2:        LocationData(526, "Chest"),
    LocationName.MunnyPouchMickey:                      LocationData(290, "Chest"),
    LocationName.CrystalOrb:                            LocationData(291, "Chest"),
    LocationName.CentralStationTent:                    LocationData(431, "Chest"),
    LocationName.TTCentralStationHiPotion:              LocationData(432, "Chest"),
    LocationName.CentralStationMythrilShard:            LocationData(433, "Chest"),
    LocationName.TheTowerPotion:                        LocationData(465, "Chest"),
    LocationName.TheTowerHiPotion:                      LocationData(466, "Chest"),
    LocationName.TheTowerEther:                         LocationData(522, "Chest"),
    LocationName.TowerEntrywayEther:                    LocationData(467, "Chest"),
    LocationName.TowerEntrywayMythrilShard:             LocationData(468, "Chest"),
    LocationName.SorcerersLoftTowerMap:                 LocationData(469, "Chest"),
    LocationName.TowerWardrobeMythrilStone:             LocationData(470, "Chest"),
    LocationName.StarSeeker:                            LocationData(304, "Chest"),
    LocationName.ValorForm:                             LocationData(286, "Chest"),
    LocationName.SeifersTrophy:                         LocationData(294, "Chest"),
    LocationName.Oathkeeper:                            LocationData(265, "Chest"),
    LocationName.LimitForm:                             LocationData(543, "Chest"),
    LocationName.UndergroundConcourseMythrilGem:        LocationData(479, "Chest"),
    LocationName.UndergroundConcourseAPBoost:           LocationData(481, "Chest"),
    LocationName.UndergroundConcourseOrichalcum:        LocationData(480, "Chest"),
    LocationName.UndergroundConcourseMythrilCrystal:    LocationData(482, "Chest"),
    LocationName.TunnelwayOrichalcum:                   LocationData(477, "Chest"),
    LocationName.TunnelwayMythrilCrystal:               LocationData(478, "Chest"),
    LocationName.SunsetTerraceOrichalcumPlus:           LocationData(438, "Chest"),
    LocationName.SunsetTerraceMythrilShard:             LocationData(439, "Chest"),
    LocationName.SunsetTerraceMythrilCrystal:           LocationData(440, "Chest"),
    LocationName.SunsetTerraceAPBoost:                  LocationData(441, "Chest"),
    LocationName.MansionNobodies:                       LocationData(56, "Get Bonus"),
    LocationName.MansionFoyerMythrilCrystal:            LocationData(452, "Chest"),
    LocationName.MansionFoyerMythrilStone:              LocationData(453, "Chest"),
    LocationName.MansionFoyerSerenityCrystal:           LocationData(454, "Chest"),
    LocationName.MansionDiningRoomMythrilCrystal:       LocationData(457, "Chest"),
    LocationName.MansionDiningRoomMythrilStone:         LocationData(458, "Chest"),
    LocationName.MansionLibraryOrichalcum:              LocationData(460, "Chest"),
    LocationName.BeamSecretAnsemReport10:               LocationData(534, "Chest"),
    LocationName.MansionBasementCorridorUltimateRecipe: LocationData(464, "Chest"),
    LocationName.BetwixtandBetween:                     LocationData(63, "Get Bonus"),
    LocationName.BetwixtandBetweenBondofFlame:          LocationData(317, "Chest"),
    LocationName.AxelDataMagicBoost:                    LocationData(561, "Chest"),
}
TWTNW_Checks = {
    LocationName.FragmentCrossingMythrilStone:          LocationData(374, "Chest"),
    LocationName.FragmentCrossingMythrilCrystal:        LocationData(375, "Chest"),
    LocationName.FragmentCrossingAPBoost:               LocationData(376, "Chest"),
    LocationName.FragmentCrossingOrichalcum:            LocationData(377, "Chest"),
    LocationName.Roxas:                                 LocationData(69, "Double Get Bonus"),
    LocationName.RoxasGetBonus:                         LocationData(69, "Second Get Bonus"),
    LocationName.RoxasSecretAnsemReport8:               LocationData(532, "Chest"),
    LocationName.TwoBecomeOne:                          LocationData(277, "Chest"),
    LocationName.MemorysSkyscaperMythrilCrystal:        LocationData(391, "Chest"),
    LocationName.MemorysSkyscaperAPBoost:               LocationData(523, "Chest"),
    LocationName.MemorysSkyscaperMythrilStone:          LocationData(524, "Chest"),
    LocationName.TheBrinkofDespairDarkCityMap:          LocationData(335, "Chest"),
    LocationName.TheBrinkofDespairOrichalcumPlus:       LocationData(500, "Chest"),
    LocationName.NothingsCallMythrilGem:                LocationData(378, "Chest"),
    LocationName.NothingsCallOrichalcum:                LocationData(379, "Chest"),
    LocationName.TwilightsViewCosmicBelt:               LocationData(336, "Chest"),
    LocationName.XigbarBonus:                           LocationData(23, "Get Bonus"),
    LocationName.XigbarSecretAnsemReport3:              LocationData(527, "Chest"),
    LocationName.NaughtsSkywayMythrilGem:               LocationData(380, "Chest"),
    LocationName.NaughtsSkywayOrichalcum:               LocationData(381, "Chest"),
    LocationName.NaughtsSkywayMythrilCrystal:           LocationData(382, "Chest"),
    LocationName.Oblivion:                              LocationData(278, "Chest"),
    LocationName.CastleThatNeverWasMap:                 LocationData(496, "Chest"),
    LocationName.Luxord:                                LocationData(24, "Double Get Bonus"),
    LocationName.LuxordGetBonus:                        LocationData(24, "Second Get Bonus"),
    LocationName.LuxordSecretAnsemReport9:              LocationData(533, "Chest"),
    LocationName.SaixBonus:                             LocationData(25, "Get Bonus"),
    LocationName.SaixSecretAnsemReport12:               LocationData(536, "Chest"),
    LocationName.PreXemnas1SecretAnsemReport11:         LocationData(535, "Chest"),
    LocationName.RuinandCreationsPassageMythrilStone:   LocationData(385, "Chest"),
    LocationName.RuinandCreationsPassageAPBoost:        LocationData(386, "Chest"),
    LocationName.RuinandCreationsPassageMythrilCrystal: LocationData(387, "Chest"),
    LocationName.RuinandCreationsPassageOrichalcum:     LocationData(388, "Chest"),
    LocationName.Xemnas1:                               LocationData(26, "Double Get Bonus"),
    LocationName.Xemnas1GetBonus:                       LocationData(26, "Second Get Bonus"),
    LocationName.Xemnas1SecretAnsemReport13:            LocationData(537, "Chest"),
    # LocationName.FinalXemnas:                           LocationData(71, "Get Bonus"),
    LocationName.XemnasDataPowerBoost:                  LocationData(554, "Chest"),
}

SoraLevels = {
    LocationName.Lvl2:  LocationData(2, "Levels"),
    LocationName.Lvl3:  LocationData(3, "Levels"),
    LocationName.Lvl4:  LocationData(4, "Levels"),
    LocationName.Lvl5:  LocationData(5, "Levels"),
    LocationName.Lvl6:  LocationData(6, "Levels"),
    LocationName.Lvl7:  LocationData(7, "Levels"),
    LocationName.Lvl8:  LocationData(8, "Levels"),
    LocationName.Lvl9:  LocationData(9, "Levels"),
    LocationName.Lvl10: LocationData(10, "Levels"),
    LocationName.Lvl11: LocationData(11, "Levels"),
    LocationName.Lvl12: LocationData(12, "Levels"),
    LocationName.Lvl13: LocationData(13, "Levels"),
    LocationName.Lvl14: LocationData(14, "Levels"),
    LocationName.Lvl15: LocationData(15, "Levels"),
    LocationName.Lvl16: LocationData(16, "Levels"),
    LocationName.Lvl17: LocationData(17, "Levels"),
    LocationName.Lvl18: LocationData(18, "Levels"),
    LocationName.Lvl19: LocationData(19, "Levels"),
    LocationName.Lvl20: LocationData(20, "Levels"),
    LocationName.Lvl21: LocationData(21, "Levels"),
    LocationName.Lvl22: LocationData(22, "Levels"),
    LocationName.Lvl23: LocationData(23, "Levels"),
    LocationName.Lvl24: LocationData(24, "Levels"),
    LocationName.Lvl25: LocationData(25, "Levels"),
    LocationName.Lvl26: LocationData(26, "Levels"),
    LocationName.Lvl27: LocationData(27, "Levels"),
    LocationName.Lvl28: LocationData(28, "Levels"),
    LocationName.Lvl29: LocationData(29, "Levels"),
    LocationName.Lvl30: LocationData(30, "Levels"),
    LocationName.Lvl31: LocationData(31, "Levels"),
    LocationName.Lvl32: LocationData(32, "Levels"),
    LocationName.Lvl33: LocationData(33, "Levels"),
    LocationName.Lvl34: LocationData(34, "Levels"),
    LocationName.Lvl35: LocationData(35, "Levels"),
    LocationName.Lvl36: LocationData(36, "Levels"),
    LocationName.Lvl37: LocationData(37, "Levels"),
    LocationName.Lvl38: LocationData(38, "Levels"),
    LocationName.Lvl39: LocationData(39, "Levels"),
    LocationName.Lvl40: LocationData(40, "Levels"),
    LocationName.Lvl41: LocationData(41, "Levels"),
    LocationName.Lvl42: LocationData(42, "Levels"),
    LocationName.Lvl43: LocationData(43, "Levels"),
    LocationName.Lvl44: LocationData(44, "Levels"),
    LocationName.Lvl45: LocationData(45, "Levels"),
    LocationName.Lvl46: LocationData(46, "Levels"),
    LocationName.Lvl47: LocationData(47, "Levels"),
    LocationName.Lvl48: LocationData(48, "Levels"),
    LocationName.Lvl49: LocationData(49, "Levels"),
    LocationName.Lvl50: LocationData(50, "Levels"),
    LocationName.Lvl51: LocationData(51, "Levels"),
    LocationName.Lvl52: LocationData(52, "Levels"),
    LocationName.Lvl53: LocationData(53, "Levels"),
    LocationName.Lvl54: LocationData(54, "Levels"),
    LocationName.Lvl55: LocationData(55, "Levels"),
    LocationName.Lvl56: LocationData(56, "Levels"),
    LocationName.Lvl57: LocationData(57, "Levels"),
    LocationName.Lvl58: LocationData(58, "Levels"),
    LocationName.Lvl59: LocationData(59, "Levels"),
    LocationName.Lvl60: LocationData(60, "Levels"),
    LocationName.Lvl61: LocationData(61, "Levels"),
    LocationName.Lvl62: LocationData(62, "Levels"),
    LocationName.Lvl63: LocationData(63, "Levels"),
    LocationName.Lvl64: LocationData(64, "Levels"),
    LocationName.Lvl65: LocationData(65, "Levels"),
    LocationName.Lvl66: LocationData(66, "Levels"),
    LocationName.Lvl67: LocationData(67, "Levels"),
    LocationName.Lvl68: LocationData(68, "Levels"),
    LocationName.Lvl69: LocationData(69, "Levels"),
    LocationName.Lvl70: LocationData(70, "Levels"),
    LocationName.Lvl71: LocationData(71, "Levels"),
    LocationName.Lvl72: LocationData(72, "Levels"),
    LocationName.Lvl73: LocationData(73, "Levels"),
    LocationName.Lvl74: LocationData(74, "Levels"),
    LocationName.Lvl75: LocationData(75, "Levels"),
    LocationName.Lvl76: LocationData(76, "Levels"),
    LocationName.Lvl77: LocationData(77, "Levels"),
    LocationName.Lvl78: LocationData(78, "Levels"),
    LocationName.Lvl79: LocationData(79, "Levels"),
    LocationName.Lvl80: LocationData(80, "Levels"),
    LocationName.Lvl81: LocationData(81, "Levels"),
    LocationName.Lvl82: LocationData(82, "Levels"),
    LocationName.Lvl83: LocationData(83, "Levels"),
    LocationName.Lvl84: LocationData(84, "Levels"),
    LocationName.Lvl85: LocationData(85, "Levels"),
    LocationName.Lvl86: LocationData(86, "Levels"),
    LocationName.Lvl87: LocationData(87, "Levels"),
    LocationName.Lvl88: LocationData(88, "Levels"),
    LocationName.Lvl89: LocationData(89, "Levels"),
    LocationName.Lvl90: LocationData(90, "Levels"),
    LocationName.Lvl91: LocationData(91, "Levels"),
    LocationName.Lvl92: LocationData(92, "Levels"),
    LocationName.Lvl93: LocationData(93, "Levels"),
    LocationName.Lvl94: LocationData(94, "Levels"),
    LocationName.Lvl95: LocationData(95, "Levels"),
    LocationName.Lvl96: LocationData(96, "Levels"),
    LocationName.Lvl97: LocationData(97, "Levels"),
    LocationName.Lvl98: LocationData(98, "Levels"),
    LocationName.Lvl99: LocationData(99, "Levels"),
}
Form_Checks = {
    LocationName.Valorlvl2:  LocationData(2, "Forms", 1),
    LocationName.Valorlvl3:  LocationData(3, "Forms", 1),
    LocationName.Valorlvl4:  LocationData(4, "Forms", 1),
    LocationName.Valorlvl5:  LocationData(5, "Forms", 1),
    LocationName.Valorlvl6:  LocationData(6, "Forms", 1),
    LocationName.Valorlvl7:  LocationData(7, "Forms", 1),

    LocationName.Wisdomlvl2: LocationData(2, "Forms", 2),
    LocationName.Wisdomlvl3: LocationData(3, "Forms", 2),
    LocationName.Wisdomlvl4: LocationData(4, "Forms", 2),
    LocationName.Wisdomlvl5: LocationData(5, "Forms", 2),
    LocationName.Wisdomlvl6: LocationData(6, "Forms", 2),
    LocationName.Wisdomlvl7: LocationData(7, "Forms", 2),

    LocationName.Limitlvl2:  LocationData(2, "Forms", 3),
    LocationName.Limitlvl3:  LocationData(3, "Forms", 3),
    LocationName.Limitlvl4:  LocationData(4, "Forms", 3),
    LocationName.Limitlvl5:  LocationData(5, "Forms", 3),
    LocationName.Limitlvl6:  LocationData(6, "Forms", 3),
    LocationName.Limitlvl7:  LocationData(7, "Forms", 3),

    LocationName.Masterlvl2: LocationData(2, "Forms", 4),
    LocationName.Masterlvl3: LocationData(3, "Forms", 4),
    LocationName.Masterlvl4: LocationData(4, "Forms", 4),
    LocationName.Masterlvl5: LocationData(5, "Forms", 4),
    LocationName.Masterlvl6: LocationData(6, "Forms", 4),
    LocationName.Masterlvl7: LocationData(7, "Forms", 4),

    LocationName.Finallvl2:  LocationData(2, "Forms", 5),
    LocationName.Finallvl3:  LocationData(3, "Forms", 5),
    LocationName.Finallvl4:  LocationData(4, "Forms", 5),
    LocationName.Finallvl5:  LocationData(5, "Forms", 5),
    LocationName.Finallvl6:  LocationData(6, "Forms", 5),
    LocationName.Finallvl7:  LocationData(7, "Forms", 5),
}
Summon_Checks = {
    LocationName.Summonlvl2: LocationData(2, "Summons"),
    LocationName.Summonlvl3: LocationData(3, "Summons"),
    LocationName.Summonlvl4: LocationData(4, "Summons"),
    LocationName.Summonlvl5: LocationData(5, "Summons"),
    LocationName.Summonlvl6: LocationData(6, "Summons"),
    LocationName.Summonlvl7: LocationData(7, "Summons"),
}
GoA_Checks = {
    LocationName.GardenofAssemblageMap: LocationData(585, "Chest"),
    LocationName.GoALostIllusion:       LocationData(586, "Chest"),
    LocationName.ProofofNonexistence:   LocationData(590, "Chest"),
}
Keyblade_Slots = {
    LocationName.FAKESlot:            LocationData(116, "Keyblade"),
    LocationName.DetectionSaberSlot:  LocationData(83, "Keyblade"),
    LocationName.EdgeofUltimaSlot:    LocationData(84, "Keyblade"),
    LocationName.KingdomKeySlot:      LocationData(80, "Keyblade"),
    LocationName.OathkeeperSlot:      LocationData(81, "Keyblade"),
    LocationName.OblivionSlot:        LocationData(82, "Keyblade"),
    LocationName.StarSeekerSlot:      LocationData(123, "Keyblade"),
    LocationName.HiddenDragonSlot:    LocationData(124, "Keyblade"),
    LocationName.HerosCrestSlot:      LocationData(127, "Keyblade"),
    LocationName.MonochromeSlot:      LocationData(128, "Keyblade"),
    LocationName.FollowtheWindSlot:   LocationData(129, "Keyblade"),
    LocationName.CircleofLifeSlot:    LocationData(130, "Keyblade"),
    LocationName.PhotonDebuggerSlot:  LocationData(131, "Keyblade"),
    LocationName.GullWingSlot:        LocationData(132, "Keyblade"),
    LocationName.RumblingRoseSlot:    LocationData(133, "Keyblade"),
    LocationName.GuardianSoulSlot:    LocationData(134, "Keyblade"),
    LocationName.WishingLampSlot:     LocationData(135, "Keyblade"),
    LocationName.DecisivePumpkinSlot: LocationData(136, "Keyblade"),
    LocationName.SweetMemoriesSlot:   LocationData(138, "Keyblade"),
    LocationName.MysteriousAbyssSlot: LocationData(139, "Keyblade"),
    LocationName.SleepingLionSlot:    LocationData(137, "Keyblade"),
    LocationName.BondofFlameSlot:     LocationData(141, "Keyblade"),
    LocationName.TwoBecomeOneSlot:    LocationData(148, "Keyblade"),
    LocationName.FatalCrestSlot:      LocationData(140, "Keyblade"),
    LocationName.FenrirSlot:          LocationData(142, "Keyblade"),
    LocationName.UltimaWeaponSlot:    LocationData(143, "Keyblade"),
    LocationName.WinnersProofSlot:    LocationData(149, "Keyblade"),
    LocationName.PurebloodSlot:       LocationData(85, "Keyblade"),
}

Donald_Checks = {
    LocationName.DonaldScreens:          LocationData(45, "Get Bonus", "Donald", 2),
    LocationName.DonaldDemyxHBGetBonus:  LocationData(28, "Get Bonus", "Donald", 2),
    LocationName.DonaldDemyxOC:          LocationData(58, "Get Bonus", "Donald", 2),
    LocationName.DonaldBoatPete:         LocationData(16, "Double Get Bonus", "Donald", 2),
    LocationName.DonaldBoatPeteGetBonus: LocationData(16, "Second Get Bonus", "Donald", 2),
    LocationName.DonaldPrisonKeeper:     LocationData(18, "Get Bonus", "Donald", 2),
    LocationName.DonaldScar:             LocationData(29, "Get Bonus", "Donald", 2),
    LocationName.DonaldSolarSailer:      LocationData(61, "Get Bonus", "Donald", 2),
    LocationName.DonaldExperiment:       LocationData(20, "Get Bonus", "Donald", 2),
    LocationName.DonaldBoatFight:        LocationData(62, "Get Bonus", "Donald", 2),
    LocationName.DonaldMansionNobodies:  LocationData(56, "Get Bonus", "Donald", 2),
    LocationName.DonaldThresholder:      LocationData(2, "Get Bonus", "Donald", 2),
    LocationName.DonaldXaldinGetBonus:   LocationData(4, "Get Bonus", "Donald", 2),
    LocationName.DonaladGrimReaper2:     LocationData(22, "Get Bonus", "Donald", 2),

    LocationName.CometStaff:             LocationData(90, "Keyblade", "Donald"),
    LocationName.HammerStaff:            LocationData(87, "Keyblade", "Donald"),
    LocationName.LordsBroom:             LocationData(91, "Keyblade", "Donald"),
    LocationName.MagesStaff:             LocationData(86, "Keyblade", "Donald"),
    LocationName.MeteorStaff:            LocationData(89, "Keyblade", "Donald"),
    LocationName.NobodyLance:            LocationData(94, "Keyblade", "Donald"),
    LocationName.PreciousMushroom:       LocationData(154, "Keyblade", "Donald"),
    LocationName.PreciousMushroom2:      LocationData(155, "Keyblade", "Donald"),
    LocationName.PremiumMushroom:        LocationData(156, "Keyblade", "Donald"),
    LocationName.RisingDragon:           LocationData(93, "Keyblade", "Donald"),
    LocationName.SaveTheQueen2:          LocationData(146, "Keyblade", "Donald"),
    LocationName.ShamansRelic:           LocationData(95, "Keyblade", "Donald"),
    LocationName.VictoryBell:            LocationData(88, "Keyblade", "Donald"),
    LocationName.WisdomWand:             LocationData(92, "Keyblade", "Donald"),
    LocationName.Centurion2:             LocationData(151, "Keyblade", "Donald"),
    LocationName.DonaldAbuEscort:        LocationData(42, "Get Bonus", "Donald", 2),
    # LocationName.DonaldStarting1:        LocationData(2, "Critical", "Donald"),
    # LocationName.DonaldStarting2:        LocationData(2, "Critical", "Donald"),
}

Goofy_Checks = {
    LocationName.GoofyBarbossa:           LocationData(21, "Double Get Bonus", "Goofy", 3),
    LocationName.GoofyBarbossaGetBonus:   LocationData(21, "Second Get Bonus", "Goofy", 3),
    LocationName.GoofyGrimReaper1:        LocationData(59, "Get Bonus", "Goofy", 3),
    LocationName.GoofyHostileProgram:     LocationData(31, "Get Bonus", "Goofy", 3),
    LocationName.GoofyHyenas1:            LocationData(49, "Get Bonus", "Goofy", 3),
    LocationName.GoofyHyenas2:            LocationData(50, "Get Bonus", "Goofy", 3),
    LocationName.GoofyLock:               LocationData(40, "Get Bonus", "Goofy", 3),
    LocationName.GoofyOogieBoogie:        LocationData(19, "Get Bonus", "Goofy", 3),
    LocationName.GoofyPeteOC:             LocationData(6, "Get Bonus", "Goofy", 3),
    LocationName.GoofyFuturePete:         LocationData(17, "Get Bonus", "Goofy", 3),
    LocationName.GoofyShanYu:             LocationData(9, "Get Bonus", "Goofy", 3),
    LocationName.GoofyStormRider:         LocationData(10, "Get Bonus", "Goofy", 3),
    LocationName.GoofyBeast:              LocationData(12, "Get Bonus", "Goofy", 3),
    LocationName.GoofyInterceptorBarrels: LocationData(39, "Get Bonus", "Goofy", 3),
    LocationName.GoofyTreasureRoom:       LocationData(46, "Get Bonus", "Goofy", 3),
    LocationName.GoofyZexion:             LocationData(66, "Get Bonus", "Goofy", 3),

    LocationName.AdamantShield:           LocationData(100, "Keyblade", "Goofy"),
    LocationName.AkashicRecord:           LocationData(107, "Keyblade", "Goofy"),
    LocationName.ChainGear:               LocationData(101, "Keyblade", "Goofy"),
    LocationName.DreamCloud:              LocationData(104, "Keyblade", "Goofy"),
    LocationName.FallingStar:             LocationData(103, "Keyblade", "Goofy"),
    LocationName.FrozenPride2:            LocationData(158, "Keyblade", "Goofy"),
    LocationName.GenjiShield:             LocationData(106, "Keyblade", "Goofy"),
    LocationName.KnightDefender:          LocationData(105, "Keyblade", "Goofy"),
    LocationName.KnightsShield:           LocationData(99, "Keyblade", "Goofy"),
    LocationName.MajesticMushroom:        LocationData(161, "Keyblade", "Goofy"),
    LocationName.MajesticMushroom2:       LocationData(162, "Keyblade", "Goofy"),
    LocationName.NobodyGuard:             LocationData(108, "Keyblade", "Goofy"),
    LocationName.OgreShield:              LocationData(102, "Keyblade", "Goofy"),
    LocationName.SaveTheKing2:            LocationData(147, "Keyblade", "Goofy"),
    LocationName.UltimateMushroom:        LocationData(163, "Keyblade", "Goofy"),
    # LocationName.GoofyStarting1:          LocationData(3, "Critical", "Goofy"),
    # LocationName.GoofyStarting2:          LocationData(3, "Critical", "Goofy"),
}

Atlantica_Checks = {
    LocationName.UnderseaKingdomMap:     LocationData(367, "Chest"),
    LocationName.MysteriousAbyss:        LocationData(287, "Chest"),  # needs 2 magnets
    LocationName.MusicalBlizzardElement: LocationData(279, "Chest"),  # 2 magnets all thunders
    LocationName.MusicalOrichalcumPlus:  LocationData(538, "Chest"),  # 2 magnets all thunders
}

event_location_to_item = {
    LocationName.HostileProgramEventLocation:    ItemName.HostileProgramEvent,
    LocationName.McpEventLocation:               ItemName.McpEvent,
    # LocationName.ASLarxeneEventLocation:             ItemName.ASLarxeneEvent,
    LocationName.DataLarxeneEventLocation:       ItemName.DataLarxeneEvent,
    LocationName.BarbosaEventLocation:           ItemName.BarbosaEvent,
    LocationName.GrimReaper1EventLocation:       ItemName.GrimReaper1Event,
    LocationName.GrimReaper2EventLocation:       ItemName.GrimReaper2Event,
    LocationName.DataLuxordEventLocation:        ItemName.DataLuxordEvent,
    LocationName.DataAxelEventLocation:          ItemName.DataAxelEvent,
    LocationName.CerberusEventLocation:          ItemName.CerberusEvent,
    LocationName.OlympusPeteEventLocation:       ItemName.OlympusPeteEvent,
    LocationName.HydraEventLocation:             ItemName.HydraEvent,
    LocationName.OcPainAndPanicCupEventLocation: ItemName.OcPainAndPanicCupEvent,
    LocationName.OcCerberusCupEventLocation:     ItemName.OcCerberusCupEvent,
    LocationName.HadesEventLocation:             ItemName.HadesEvent,
    # LocationName.ASZexionEventLocation:              ItemName.ASZexionEvent,
    LocationName.DataZexionEventLocation:        ItemName.DataZexionEvent,
    LocationName.Oc2TitanCupEventLocation:       ItemName.Oc2TitanCupEvent,
    LocationName.Oc2GofCupEventLocation:         ItemName.Oc2GofCupEvent,
    # LocationName.Oc2CupsEventLocation:               ItemName.Oc2CupsEventLocation,
    LocationName.HadesCupEventLocations:         ItemName.HadesCupEvents,
    LocationName.PrisonKeeperEventLocation:      ItemName.PrisonKeeperEvent,
    LocationName.OogieBoogieEventLocation:       ItemName.OogieBoogieEvent,
    LocationName.ExperimentEventLocation:        ItemName.ExperimentEvent,
    # LocationName.ASVexenEventLocation:               ItemName.ASVexenEvent,
    LocationName.DataVexenEventLocation:         ItemName.DataVexenEvent,
    LocationName.ShanYuEventLocation:            ItemName.ShanYuEvent,
    LocationName.AnsemRikuEventLocation:         ItemName.AnsemRikuEvent,
    LocationName.StormRiderEventLocation:        ItemName.StormRiderEvent,
    LocationName.DataXigbarEventLocation:        ItemName.DataXigbarEvent,
    LocationName.RoxasEventLocation:             ItemName.RoxasEvent,
    LocationName.XigbarEventLocation:            ItemName.XigbarEvent,
    LocationName.LuxordEventLocation:            ItemName.LuxordEvent,
    LocationName.SaixEventLocation:              ItemName.SaixEvent,
    LocationName.XemnasEventLocation:            ItemName.XemnasEvent,
    LocationName.ArmoredXemnasEventLocation:     ItemName.ArmoredXemnasEvent,
    LocationName.ArmoredXemnas2EventLocation:    ItemName.ArmoredXemnas2Event,
    # LocationName.FinalXemnasEventLocation:           ItemName.FinalXemnasEvent,
    LocationName.DataXemnasEventLocation:        ItemName.DataXemnasEvent,
    LocationName.ThresholderEventLocation:       ItemName.ThresholderEvent,
    LocationName.BeastEventLocation:             ItemName.BeastEvent,
    LocationName.DarkThornEventLocation:         ItemName.DarkThornEvent,
    LocationName.XaldinEventLocation:            ItemName.XaldinEvent,
    LocationName.DataXaldinEventLocation:        ItemName.DataXaldinEvent,
    LocationName.TwinLordsEventLocation:         ItemName.TwinLordsEvent,
    LocationName.GenieJafarEventLocation:        ItemName.GenieJafarEvent,
    # LocationName.ASLexaeusEventLocation:             ItemName.ASLexaeusEvent,
    LocationName.DataLexaeusEventLocation:       ItemName.DataLexaeusEvent,
    LocationName.ScarEventLocation:              ItemName.ScarEvent,
    LocationName.GroundShakerEventLocation:      ItemName.GroundShakerEvent,
    LocationName.DataSaixEventLocation:          ItemName.DataSaixEvent,
    LocationName.HBDemyxEventLocation:           ItemName.HBDemyxEvent,
    LocationName.ThousandHeartlessEventLocation: ItemName.ThousandHeartlessEvent,
    LocationName.Mushroom13EventLocation:        ItemName.Mushroom13Event,
    LocationName.SephiEventLocation:             ItemName.SephiEvent,
    LocationName.DataDemyxEventLocation:         ItemName.DataDemyxEvent,
    LocationName.CorFirstFightEventLocation:     ItemName.CorFirstFightEvent,
    LocationName.CorSecondFightEventLocation:    ItemName.CorSecondFightEvent,
    LocationName.TransportEventLocation:         ItemName.TransportEvent,
    LocationName.OldPeteEventLocation:           ItemName.OldPeteEvent,
    LocationName.FuturePeteEventLocation:        ItemName.FuturePeteEvent,
    # LocationName.ASMarluxiaEventLocation:            ItemName.ASMarluxiaEvent,
    LocationName.DataMarluxiaEventLocation:      ItemName.DataMarluxiaEvent,
    LocationName.TerraEventLocation:             ItemName.TerraEvent,
    LocationName.TwilightThornEventLocation:     ItemName.TwilightThornEvent,
    LocationName.Axel1EventLocation:             ItemName.Axel1Event,
    LocationName.Axel2EventLocation:             ItemName.Axel2Event,
    LocationName.DataRoxasEventLocation:         ItemName.DataRoxasEvent,
    LocationName.FinalXemnasEventLocation:       ItemName.Victory,
}
all_weapon_slot = {
    LocationName.FAKESlot,
    LocationName.DetectionSaberSlot,
    LocationName.EdgeofUltimaSlot,
    LocationName.KingdomKeySlot,
    LocationName.OathkeeperSlot,
    LocationName.OblivionSlot,
    LocationName.StarSeekerSlot,
    LocationName.HiddenDragonSlot,
    LocationName.HerosCrestSlot,
    LocationName.MonochromeSlot,
    LocationName.FollowtheWindSlot,
    LocationName.CircleofLifeSlot,
    LocationName.PhotonDebuggerSlot,
    LocationName.GullWingSlot,
    LocationName.RumblingRoseSlot,
    LocationName.GuardianSoulSlot,
    LocationName.WishingLampSlot,
    LocationName.DecisivePumpkinSlot,
    LocationName.SweetMemoriesSlot,
    LocationName.MysteriousAbyssSlot,
    LocationName.SleepingLionSlot,
    LocationName.BondofFlameSlot,
    LocationName.TwoBecomeOneSlot,
    LocationName.FatalCrestSlot,
    LocationName.FenrirSlot,
    LocationName.UltimaWeaponSlot,
    LocationName.WinnersProofSlot,
    LocationName.PurebloodSlot,

    LocationName.Centurion2,
    LocationName.CometStaff,
    LocationName.HammerStaff,
    LocationName.LordsBroom,
    LocationName.MagesStaff,
    LocationName.MeteorStaff,
    LocationName.NobodyLance,
    LocationName.PreciousMushroom,
    LocationName.PreciousMushroom2,
    LocationName.PremiumMushroom,
    LocationName.RisingDragon,
    LocationName.SaveTheQueen2,
    LocationName.ShamansRelic,
    LocationName.VictoryBell,
    LocationName.WisdomWand,

    LocationName.AdamantShield,
    LocationName.AkashicRecord,
    LocationName.ChainGear,
    LocationName.DreamCloud,
    LocationName.FallingStar,
    LocationName.FrozenPride2,
    LocationName.GenjiShield,
    LocationName.KnightDefender,
    LocationName.KnightsShield,
    LocationName.MajesticMushroom,
    LocationName.MajesticMushroom2,
    LocationName.NobodyGuard,
    LocationName.OgreShield,
    LocationName.SaveTheKing2,
    LocationName.UltimateMushroom, }

starter_weapon_slot = {
    LocationName.KingdomKeySlot,
    
    LocationName.CometStaff,
    LocationName.HammerStaff,
    LocationName.LordsBroom,
    LocationName.MagesStaff,
    LocationName.VictoryBell,
    LocationName.WisdomWand,

    LocationName.AdamantShield,
    LocationName.ChainGear,
    LocationName.DreamCloud,
    LocationName.FallingStar,
    LocationName.KnightDefender,
    LocationName.KnightsShield,
}

all_locations = {
    **TWTNW_Checks,
    **TT_Checks,
    **STT_Checks,
    **PL_Checks,
    **HB_Checks,
    **HT_Checks,
    **PR_Checks,
    **PR_Checks,
    **SP_Checks,
    **BC_Checks,
    **Oc_Checks,
    **HundredAcre_Checks,
    **DC_Checks,
    **AG_Checks,
    **LoD_Checks,
    **SoraLevels,
    **Form_Checks,
    **GoA_Checks,
    **Keyblade_Slots,
    **Donald_Checks,
    **Goofy_Checks,
    **Atlantica_Checks,
    **Summon_Checks,
}

popups_set = {
    LocationName.SweetMemories,
    LocationName.SpookyCaveMap,
    LocationName.StarryHillCureElement,
    LocationName.StarryHillOrichalcumPlus,
    LocationName.AgrabahMap,
    LocationName.LampCharm,
    LocationName.WishingLamp,
    LocationName.DarkThornCureElement,
    LocationName.RumblingRose,
    LocationName.CastleWallsMap,
    LocationName.SecretAnsemReport4,
    LocationName.DisneyCastleMap,
    LocationName.WindowofTimeMap,
    LocationName.Monochrome,
    LocationName.WisdomForm,
    LocationName.LingeringWillProofofConnection,
    LocationName.LingeringWillManifestIllusion,
    LocationName.OogieBoogieMagnetElement,
    LocationName.Present,
    LocationName.DecoyPresents,
    LocationName.DecisivePumpkin,
    LocationName.MarketplaceMap,
    LocationName.MerlinsHouseMembershipCard,
    LocationName.MerlinsHouseBlizzardElement,
    LocationName.BaileySecretAnsemReport7,
    LocationName.BaseballCharm,
    LocationName.AnsemsStudyMasterForm,
    LocationName.AnsemsStudySkillRecipe,
    LocationName.AnsemsStudySleepingLion,
    LocationName.FFFightsCureElement,
    LocationName.ThousandHeartlessSecretAnsemReport1,
    LocationName.ThousandHeartlessIceCream,
    LocationName.ThousandHeartlessPicture,
    LocationName.WinnersProof,
    LocationName.ProofofPeace,
    LocationName.SephirothFenrir,
    LocationName.EncampmentAreaMap,
    LocationName.Mission3,
    LocationName.VillageCaveAreaMap,
    LocationName.HiddenDragon,
    LocationName.ColiseumMap,
    LocationName.SecretAnsemReport6,
    LocationName.OlympusStone,
    LocationName.HerosCrest,
    LocationName.AuronsStatue,
    LocationName.GuardianSoul,
    LocationName.ProtectBeltPainandPanicCup,
    LocationName.SerenityGemPainandPanicCup,
    LocationName.RisingDragonCerberusCup,
    LocationName.SerenityCrystalCerberusCup,
    LocationName.GenjiShieldTitanCup,
    LocationName.SkillfulRingTitanCup,
    LocationName.FatalCrestGoddessofFateCup,
    LocationName.OrichalcumPlusGoddessofFateCup,
    LocationName.HadesCupTrophyParadoxCups,
    LocationName.IsladeMuertaMap,
    LocationName.FollowtheWind,
    LocationName.SeadriftRowCursedMedallion,
    LocationName.SeadriftRowShipGraveyardMap,
    LocationName.SecretAnsemReport5,
    LocationName.CircleofLife,
    LocationName.ScarFireElement,
    LocationName.TwilightTownMap,
    LocationName.MunnyPouchOlette,
    LocationName.JunkChampionBelt,
    LocationName.JunkMedal,
    LocationName.TheStruggleTrophy,
    LocationName.NaminesSketches,
    LocationName.MansionMap,
    LocationName.PhotonDebugger,
    LocationName.StationPlazaSecretAnsemReport2,
    LocationName.MunnyPouchMickey,
    LocationName.CrystalOrb,
    LocationName.StarSeeker,
    LocationName.ValorForm,
    LocationName.SeifersTrophy,
    LocationName.Oathkeeper,
    LocationName.LimitForm,
    LocationName.BeamSecretAnsemReport10,
    LocationName.BetwixtandBetweenBondofFlame,
    LocationName.TwoBecomeOne,
    LocationName.RoxasSecretAnsemReport8,
    LocationName.XigbarSecretAnsemReport3,
    LocationName.Oblivion,
    LocationName.CastleThatNeverWasMap,
    LocationName.LuxordSecretAnsemReport9,
    LocationName.SaixSecretAnsemReport12,
    LocationName.PreXemnas1SecretAnsemReport11,
    LocationName.Xemnas1SecretAnsemReport13,
    LocationName.XemnasDataPowerBoost,
    LocationName.AxelDataMagicBoost,
    LocationName.RoxasDataMagicBoost,
    LocationName.SaixDataDefenseBoost,
    LocationName.DemyxDataAPBoost,
    LocationName.LuxordDataAPBoost,
    LocationName.VexenDataLostIllusion,
    LocationName.LarxeneDataLostIllusion,
    LocationName.XaldinDataDefenseBoost,
    LocationName.MarluxiaDataLostIllusion,
    LocationName.LexaeusDataLostIllusion,
    LocationName.XigbarDataDefenseBoost,
    LocationName.VexenASRoadtoDiscovery,
    LocationName.LarxeneASCloakedThunder,
    LocationName.ZexionASBookofShadows,
    LocationName.ZexionDataLostIllusion,
    LocationName.LexaeusASStrengthBeyondStrength,
    LocationName.MarluxiaASEternalBlossom,
    LocationName.UnderseaKingdomMap,
    LocationName.MysteriousAbyss,
    LocationName.MusicalBlizzardElement,
    LocationName.MusicalOrichalcumPlus,
}
exclusion_table = {
    "SuperBosses":   {
        LocationName.LingeringWillBonus,
        LocationName.LingeringWillProofofConnection,
        LocationName.LingeringWillManifestIllusion,
        LocationName.SephirothBonus,
        LocationName.SephirothFenrir,
        LocationName.XemnasDataPowerBoost,
        LocationName.AxelDataMagicBoost,
        LocationName.RoxasDataMagicBoost,
        LocationName.SaixDataDefenseBoost,
        LocationName.DemyxDataAPBoost,
        LocationName.LuxordDataAPBoost,
        LocationName.VexenDataLostIllusion,
        LocationName.VexenBonus,
        LocationName.VexenASRoadtoDiscovery,
        LocationName.LarxeneDataLostIllusion,
        LocationName.LarxeneBonus,
        LocationName.LarxeneASCloakedThunder,
        LocationName.XaldinDataDefenseBoost,
        LocationName.MarluxiaDataLostIllusion,
        LocationName.MarluxiaASEternalBlossom,
        LocationName.MarluxiaGetBonus,
        LocationName.LexaeusDataLostIllusion,
        LocationName.LexaeusBonus,
        LocationName.LexaeusASStrengthBeyondStrength,
        LocationName.XigbarDataDefenseBoost,
        LocationName.ZexionDataLostIllusion,
        LocationName.ZexionBonus,
        LocationName.ZexionASBookofShadows,
        LocationName.GoofyZexion,
    },

    # 23 checks spread through 50 levels
    "Level50":       {
        LocationName.Lvl2,
        LocationName.Lvl4,
        LocationName.Lvl7,
        LocationName.Lvl9,
        LocationName.Lvl10,
        LocationName.Lvl12,
        LocationName.Lvl14,
        LocationName.Lvl15,
        LocationName.Lvl17,
        LocationName.Lvl20,
        LocationName.Lvl23,
        LocationName.Lvl25,
        LocationName.Lvl28,
        LocationName.Lvl30,
        LocationName.Lvl32,
        LocationName.Lvl34,
        LocationName.Lvl36,
        LocationName.Lvl39,
        LocationName.Lvl41,
        LocationName.Lvl44,
        LocationName.Lvl46,
        LocationName.Lvl48,
        LocationName.Lvl50,
    },
    # 23 checks spread through 99 levels
    "Level99":       {
        LocationName.Lvl7,
        LocationName.Lvl9,
        LocationName.Lvl12,
        LocationName.Lvl15,
        LocationName.Lvl17,
        LocationName.Lvl20,
        LocationName.Lvl23,
        LocationName.Lvl25,
        LocationName.Lvl28,
        LocationName.Lvl31,
        LocationName.Lvl33,
        LocationName.Lvl36,
        LocationName.Lvl39,
        LocationName.Lvl41,
        LocationName.Lvl44,
        LocationName.Lvl47,
        LocationName.Lvl49,
        LocationName.Lvl53,
        LocationName.Lvl59,
        LocationName.Lvl65,
        LocationName.Lvl73,
        LocationName.Lvl85,
        LocationName.Lvl99,
    },
    "Level50Sanity": {
        LocationName.Lvl2,
        LocationName.Lvl3,
        LocationName.Lvl4,
        LocationName.Lvl5,
        LocationName.Lvl6,
        LocationName.Lvl7,
        LocationName.Lvl8,
        LocationName.Lvl9,
        LocationName.Lvl10,
        LocationName.Lvl11,
        LocationName.Lvl12,
        LocationName.Lvl13,
        LocationName.Lvl14,
        LocationName.Lvl15,
        LocationName.Lvl16,
        LocationName.Lvl17,
        LocationName.Lvl18,
        LocationName.Lvl19,
        LocationName.Lvl20,
        LocationName.Lvl21,
        LocationName.Lvl22,
        LocationName.Lvl23,
        LocationName.Lvl24,
        LocationName.Lvl25,
        LocationName.Lvl26,
        LocationName.Lvl27,
        LocationName.Lvl28,
        LocationName.Lvl29,
        LocationName.Lvl30,
        LocationName.Lvl31,
        LocationName.Lvl32,
        LocationName.Lvl33,
        LocationName.Lvl34,
        LocationName.Lvl35,
        LocationName.Lvl36,
        LocationName.Lvl37,
        LocationName.Lvl38,
        LocationName.Lvl39,
        LocationName.Lvl40,
        LocationName.Lvl41,
        LocationName.Lvl42,
        LocationName.Lvl43,
        LocationName.Lvl44,
        LocationName.Lvl45,
        LocationName.Lvl46,
        LocationName.Lvl47,
        LocationName.Lvl48,
        LocationName.Lvl49,
        LocationName.Lvl50,
    },
    "Level99Sanity": {
        LocationName.Lvl51,
        LocationName.Lvl52,
        LocationName.Lvl53,
        LocationName.Lvl54,
        LocationName.Lvl55,
        LocationName.Lvl56,
        LocationName.Lvl57,
        LocationName.Lvl58,
        LocationName.Lvl59,
        LocationName.Lvl60,
        LocationName.Lvl61,
        LocationName.Lvl62,
        LocationName.Lvl63,
        LocationName.Lvl64,
        LocationName.Lvl65,
        LocationName.Lvl66,
        LocationName.Lvl67,
        LocationName.Lvl68,
        LocationName.Lvl69,
        LocationName.Lvl70,
        LocationName.Lvl71,
        LocationName.Lvl72,
        LocationName.Lvl73,
        LocationName.Lvl74,
        LocationName.Lvl75,
        LocationName.Lvl76,
        LocationName.Lvl77,
        LocationName.Lvl78,
        LocationName.Lvl79,
        LocationName.Lvl80,
        LocationName.Lvl81,
        LocationName.Lvl82,
        LocationName.Lvl83,
        LocationName.Lvl84,
        LocationName.Lvl85,
        LocationName.Lvl86,
        LocationName.Lvl87,
        LocationName.Lvl88,
        LocationName.Lvl89,
        LocationName.Lvl90,
        LocationName.Lvl91,
        LocationName.Lvl92,
        LocationName.Lvl93,
        LocationName.Lvl94,
        LocationName.Lvl95,
        LocationName.Lvl96,
        LocationName.Lvl97,
        LocationName.Lvl98,
        LocationName.Lvl99,
    },
    "Hitlist":       {
        LocationName.LingeringWillProofofConnection:    10,
        LocationName.DemyxDataAPBoost:                  9,
        LocationName.XaldinDataDefenseBoost:            9,
        LocationName.XigbarDataDefenseBoost:            9,
        LocationName.XemnasDataPowerBoost:              9,
        LocationName.VexenDataLostIllusion:             8,
        LocationName.LexaeusDataLostIllusion:           8,
        LocationName.ZexionDataLostIllusion:            8,
        LocationName.LarxeneDataLostIllusion:           8,
        LocationName.MarluxiaDataLostIllusion:          8,
        LocationName.AxelDataMagicBoost:                8,
        LocationName.RoxasDataMagicBoost:               8,
        LocationName.SaixDataDefenseBoost:              8,
        LocationName.LuxordDataAPBoost:                 8,
        LocationName.SephirothFenrir:                   7,
        LocationName.TransporttoRemembrance:            7,
        LocationName.StarryHillOrichalcumPlus:          7,
        LocationName.Valorlvl7:                         7,
        LocationName.Wisdomlvl7:                        7,
        LocationName.Limitlvl7:                         7,
        LocationName.Masterlvl7:                        7,
        LocationName.Finallvl7:                         7,
        LocationName.Summonlvl7:                        7,
        LocationName.OrichalcumPlusGoddessofFateCup:    7,
        LocationName.HadesCupTrophyParadoxCups:         6,
        LocationName.Lvl50:                             6,
        LocationName.Xemnas1SecretAnsemReport13:        6,
        LocationName.PreXemnas1SecretAnsemReport11:     6,
        LocationName.BeamSecretAnsemReport10:           5,
        LocationName.SaixSecretAnsemReport12:           5,
        LocationName.LuxordSecretAnsemReport9:          5,
        LocationName.XigbarSecretAnsemReport3:          5,
        LocationName.RoxasSecretAnsemReport8:           5,
        LocationName.ThousandHeartlessSecretAnsemReport1:   5,
        LocationName.MCP:                               5,
        LocationName.GroundshakerGetBonus:              5,
        LocationName.DecisivePumpkin:                   5,
        LocationName.WishingLamp:                       5,
        LocationName.SecretAnsemReport6:                5,
        LocationName.MusicalOrichalcumPlus:             5,
        LocationName.SecretAnsemReport4:                5,
        LocationName.GuardianSoul:                      5,
        LocationName.StormRider:                        5,
        LocationName.PhotonDebugger:                    4,
        LocationName.ScarFireElement:                   4,
        LocationName.LampCharm:                         4,
        LocationName.OogieBoogieMagnetElement:          4,
        LocationName.FollowtheWind:                     4,
        LocationName.WisdomForm:                        4,
        LocationName.HerosCrest:                        3,
        LocationName.HiddenDragon:                      3,
        LocationName.DarkThornCureElement:              3,
        LocationName.Axel2:                             3,
        LocationName.SecretAnsemReport5:                2,
        LocationName.BaileySecretAnsemReport7:          1,
        LocationName.StationPlazaSecretAnsemReport2:    1
    },
    "Cups":          {
        LocationName.ProtectBeltPainandPanicCup,
        LocationName.SerenityGemPainandPanicCup,
        LocationName.RisingDragonCerberusCup,
        LocationName.SerenityCrystalCerberusCup,
        LocationName.GenjiShieldTitanCup,
        LocationName.SkillfulRingTitanCup,
        LocationName.FatalCrestGoddessofFateCup,
        LocationName.OrichalcumPlusGoddessofFateCup,
        LocationName.HadesCupTrophyParadoxCups,
    },
    "Atlantica":     {
        LocationName.MysteriousAbyss,
        LocationName.MusicalOrichalcumPlus,
        LocationName.MusicalBlizzardElement,
        LocationName.UnderseaKingdomMap,
    },
    "WeaponSlots":   {
        LocationName.FAKESlot:            ItemName.ValorForm,
        LocationName.DetectionSaberSlot:  ItemName.MasterForm,
        LocationName.EdgeofUltimaSlot:    ItemName.FinalForm,
        LocationName.OathkeeperSlot:      ItemName.Oathkeeper,
        LocationName.OblivionSlot:        ItemName.Oblivion,
        LocationName.StarSeekerSlot:      ItemName.StarSeeker,
        LocationName.HiddenDragonSlot:    ItemName.HiddenDragon,
        LocationName.HerosCrestSlot:      ItemName.HerosCrest,
        LocationName.MonochromeSlot:      ItemName.Monochrome,
        LocationName.FollowtheWindSlot:   ItemName.FollowtheWind,
        LocationName.CircleofLifeSlot:    ItemName.CircleofLife,
        LocationName.PhotonDebuggerSlot:  ItemName.PhotonDebugger,
        LocationName.GullWingSlot:        ItemName.GullWing,
        LocationName.RumblingRoseSlot:    ItemName.RumblingRose,
        LocationName.GuardianSoulSlot:    ItemName.GuardianSoul,
        LocationName.WishingLampSlot:     ItemName.WishingLamp,
        LocationName.DecisivePumpkinSlot: ItemName.DecisivePumpkin,
        LocationName.SweetMemoriesSlot:   ItemName.SweetMemories,
        LocationName.MysteriousAbyssSlot: ItemName.MysteriousAbyss,
        LocationName.SleepingLionSlot:    ItemName.SleepingLion,
        LocationName.BondofFlameSlot:     ItemName.BondofFlame,
        LocationName.TwoBecomeOneSlot:    ItemName.TwoBecomeOne,
        LocationName.FatalCrestSlot:      ItemName.FatalCrest,
        LocationName.FenrirSlot:          ItemName.Fenrir,
        LocationName.UltimaWeaponSlot:    ItemName.UltimaWeapon,
        LocationName.WinnersProofSlot:    ItemName.WinnersProof,
        LocationName.PurebloodSlot:       ItemName.Pureblood,
        # goofy
        LocationName.AkashicRecord:       ItemName.AkashicRecord,
        LocationName.FrozenPride2:        ItemName.FrozenPride2,
        LocationName.GenjiShield:         ItemName.GenjiShield,
        LocationName.MajesticMushroom:    ItemName.MajesticMushroom,
        LocationName.MajesticMushroom2:   ItemName.MajesticMushroom2,
        LocationName.NobodyGuard:         ItemName.NobodyGuard,
        LocationName.OgreShield:          ItemName.OgreShield,
        LocationName.SaveTheKing2:        ItemName.SaveTheKing2,
        LocationName.UltimateMushroom:    ItemName.UltimateMushroom,
        # donald
        LocationName.MeteorStaff:         ItemName.MeteorStaff,
        LocationName.NobodyLance:         ItemName.NobodyLance,
        LocationName.PreciousMushroom:    ItemName.PreciousMushroom,
        LocationName.PreciousMushroom2:   ItemName.PreciousMushroom2,
        LocationName.PremiumMushroom:     ItemName.PremiumMushroom,
        LocationName.RisingDragon:        ItemName.RisingDragon,
        LocationName.SaveTheQueen2:       ItemName.SaveTheQueen2,
        LocationName.ShamansRelic:        ItemName.ShamansRelic,
        LocationName.Centurion2:          ItemName.Centurion2,
    },
    "Chests":        {
        location for location, data in all_locations.items() if location not in event_location_to_item.keys() and location not in popups_set and location != LocationName.StationofSerenityPotion and data.yml == "Chest"
    }
}

location_groups: typing.Dict[str, list]
location_groups = {
    Region_Name: [loc for loc in Region_Locs if "Event" not in loc]
    for Region_Name, Region_Locs in KH2REGIONS.items() if Region_Locs and "Event" not in Region_Locs[0]
}
