import itertools
from typing import ClassVar, TypedDict

from BaseClasses import Location, Region

from .constants import GAME_NAME

EXTRA_SHOP_LOCATION_START = 1000

# See collection.txt for shop purchases (and how other characters unlock, and for the order characters are displayed in
# the grid)

LEVEL_SHORT_NAMES = [f"{episode}-{chapter}" for episode, chapter in itertools.product(range(1, 7), range(1, 7))]
LEVEL_SHORT_NAMES_SET = frozenset(LEVEL_SHORT_NAMES)


class LevelLocationData:
    MINIKIT_COUNT_OFFSET: ClassVar[int] = 5
    COMPLETION_OFFSET: ClassVar[int] = 8  # todo: Is this were we can get the unused 'best completion time'?

    minikits: tuple[str, ...]
    completion: str
    true_jedi: str
    purchases: tuple[str, ...]

    def __init__(self, short_name: str):
        self.minikits = tuple([f"{short_name} Minikit {i+1}" for i in range(10)])
        self.completion = f"{short_name} Completion"
        self.true_jedi = f"{short_name} True Jedi"
        # Set later
        self.purchases = ()

LEVEL_LOCATION_DATA: dict[str, LevelLocationData] = {

}

# todo: Replace this with a class.
LevelDict = TypedDict(
    "LevelDict",
    {
        "Minikits": list[str],
        "Completion": str,
        "True Jedi": str,
    }
)

LEVEL_COMMON_LOCATIONS: dict[str, LevelDict] = {
    name: {
        "Minikits": [f"{name} Minikit {i+1}" for i in range(10)],
        "Completion": f"{name} Completion",
        "True Jedi": f"{name} True Jedi",
    }
    for name in LEVEL_SHORT_NAMES
}
LEVEL_COMPLETION = {

}

# TODO: Copied from the manual world's datapackage, to be reworked.
LOCATION_NAME_TO_ID = {
    "Purchase Gonk Droid": 1,
    "Purchase PK Droid": 2,
    "Purchase Battle Droid": 3,
    "Purchase Battle Droid (Security)": 4,
    "Purchase Battle Droid (Commander)": 5,
    "Purchase Droideka": 6,
    "Purchase Captain Tarpals": 7,
    "Purchase Boss Nass": 8,
    "Purchase Royal Guard": 9,
    "Purchase Watto": 10,
    "Purchase Pit Droid": 11,
    "Purchase Darth Maul": 12,
    "Purchase Zam Wesell": 13,
    "Purchase Dexter Jettster": 14,
    "Purchase Clone": 15,
    "Purchase Lama Su": 16,
    "Purchase Taun We": 17,
    "Purchase Geonosian": 18,
    "Purchase Battle Droid (Geonosis)": 19,
    "Purchase Super Battle Droid": 20,
    "Purchase Jango Fett": 21,
    "Purchase Boba Fett (Boy)": 22,
    "Purchase Luminara": 23,
    "Purchase Ki-Adi Mundi": 24,
    "Purchase Kit Fisto": 25,
    "Purchase Shaak Ti": 26,
    "Purchase Aayla Secura": 27,
    "Purchase Plo Koon": 28,
    "Purchase Count Dooku": 29,
    "Purchase Grievous' Bodyguard": 30,
    "Purchase General Grievous": 31,
    "Purchase Wookiee": 32,
    "Purchase Clone (Episode 3)": 33,
    "Purchase Clone (Episode 3, Pilot)": 34,
    "Purchase Clone (Episode 3, Swamp)": 35,
    "Purchase Clone (Episode 3, Walker)": 36,
    "Purchase Mace Windu (Episode 3)": 37,
    "Purchase Disguised Clone": 38,
    "Purchase Rebel Trooper": 39,
    "Purchase Stormtrooper": 40,
    "Purchase Imperial Shuttle Pilot": 41,
    "Purchase Tusken Raider": 42,
    "Purchase Jawa": 43,
    "Purchase Sandtrooper": 44,
    "Purchase Greedo": 45,
    "Purchase Imperial Spy": 46,
    "Purchase Beach Trooper": 47,
    "Purchase Death Star Trooper": 48,
    "Purchase TIE Fighter Pilot": 49,
    "Purchase Imperial Officer": 50,
    "Purchase Grand Moff Tarkin": 51,
    "Purchase Han Solo (Hood)": 52,
    "Purchase Rebel Trooper (Hoth)": 53,
    "Purchase Rebel Pilot": 54,
    "Purchase Snowtrooper": 55,
    "Purchase Lobot": 56,
    "Purchase Ugnaught": 57,
    "Purchase Bespin Guard": 58,
    "Purchase Gamorrean Guard": 59,
    "Purchase Bib Fortuna": 60,
    "Purchase Palace Guard": 61,
    "Purchase Bossk": 62,
    "Purchase Skiff Guard": 63,
    "Purchase Boba Fett": 64,
    "Purchase Ewok": 65,
    "Purchase Imperial Guard": 66,
    "Purchase The Emperor": 67,
    "Purchase Admiral Ackbar": 68,
    "Purchase IG-88": 69,
    "Purchase Dengar": 70,
    "Purchase 4-LOM": 71,
    "Purchase Ben Kenobi (Ghost)": 72,
    "Purchase Anakin Skywalker (Ghost)": 73,
    "Purchase Yoda (Ghost)": 74,
    "Purchase R2-Q5": 75,
    "Purchase Padmé": 76,
    "Purchase Luke Skywalker (Hoth)": 77,
    "Purchase Super Gonk (1-1)": 78,
    "Purchase Poo Money (1-2)": 79,
    "Purchase Walkie Talkie Disable (1-3)": 80,
    "Purchase Power Brick Detector (1-4)": 81,
    "Purchase Super Slap (1-5)": 82,
    "Purchase Force Grapple Leap (1-6)": 83,
    "Purchase Stud Magnet (2-1)": 84,
    "Purchase Disarm Troopers (2-2)": 85,
    "Purchase Character Studs (2-3)": 86,
    "Purchase Perfect Deflect (2-4)": 87,
    "Purchase Exploding Blaster Bolts (2-5)": 88,
    "Purchase Force Pull (2-6)": 89,
    "Purchase Vehicle Smart Bomb (3-1)": 90,
    "Purchase Super Astromech (3-2)": 91,
    "Purchase Super Jedi Slam (3-3)": 92,
    "Purchase Super Thermal Detonator (3-4)": 93,
    "Purchase Deflect Bolts (3-5)": 94,
    "Purchase Dark Side (3-6)": 95,
    "Purchase Super Blasters (4-1)": 96,
    "Purchase Fast Force (4-2)": 97,
    "Purchase Super Lightsabers (4-3)": 98,
    "Purchase Tractor Beam (4-4)": 99,
    "Purchase Invincibility (4-5)": 100,
    "Purchase Score x2 (4-6)": 101,
    "Purchase Self Destruct (5-1)": 102,
    "Purchase Fast Build (5-2)": 103,
    "Purchase Regenerate Hearts (5-4)": 104,
    "Purchase Minikit Detector (5-6)": 105,
    "Purchase Super Zapper (6-1)": 106,
    "Purchase Bounty Hunter Rockets (6-2)": 107,
    "Purchase Super Ewok Catapult (6-4)": 108,
    "Purchase Infinite Torpedos (6-6)": 109,
    "1-1 True Jedi": 110,
    "1-2 True Jedi": 111,
    "1-3 True Jedi": 112,
    "1-4 True Jedi": 113,
    "1-5 True Jedi": 114,
    "1-6 True Jedi": 115,
    "2-1 True Jedi": 116,
    "2-2 True Jedi": 117,
    "2-3 True Jedi": 118,
    "2-4 True Jedi": 119,
    "2-5 True Jedi": 120,
    "2-6 True Jedi": 121,
    "3-1 True Jedi": 122,
    "3-2 True Jedi": 123,
    "3-3 True Jedi": 124,
    "3-4 True Jedi": 125,
    "3-5 True Jedi": 126,
    "3-6 True Jedi": 127,
    "4-1 True Jedi": 128,
    "4-2 True Jedi": 129,
    "4-3 True Jedi": 130,
    "4-4 True Jedi": 131,
    "4-5 True Jedi": 132,
    "4-6 True Jedi": 133,
    "5-1 True Jedi": 134,
    "5-2 True Jedi": 135,
    "5-3 True Jedi": 136,
    "5-4 True Jedi": 137,
    "5-5 True Jedi": 138,
    "5-6 True Jedi": 139,
    "6-1 True Jedi": 140,
    "6-2 True Jedi": 141,
    "6-3 True Jedi": 142,
    "6-4 True Jedi": 143,
    "6-5 True Jedi": 144,
    "6-6 True Jedi": 145,
    "1-1 Minikit 1": 146,
    "1-1 Minikit 2": 147,
    "1-1 Minikit 3": 148,
    "1-1 Minikit 4": 149,
    "1-1 Minikit 5": 150,
    "1-1 Minikit 6": 151,
    "1-1 Minikit 7": 152,
    "1-1 Minikit 8": 153,
    "1-1 Minikit 9": 154,
    "1-1 Minikit 10": 155,
    "1-2 Minikit 1": 156,
    "1-2 Minikit 2": 157,
    "1-2 Minikit 3": 158,
    "1-2 Minikit 4": 159,
    "1-2 Minikit 5": 160,
    "1-2 Minikit 6": 161,
    "1-2 Minikit 7": 162,
    "1-2 Minikit 8": 163,
    "1-2 Minikit 9": 164,
    "1-2 Minikit 10": 165,
    "1-3 Minikit 1": 166,
    "1-3 Minikit 2": 167,
    "1-3 Minikit 3": 168,
    "1-3 Minikit 4": 169,
    "1-3 Minikit 5": 170,
    "1-3 Minikit 6": 171,
    "1-3 Minikit 7": 172,
    "1-3 Minikit 8": 173,
    "1-3 Minikit 9": 174,
    "1-3 Minikit 10": 175,
    "1-4 Minikit 1": 176,
    "1-4 Minikit 2": 177,
    "1-4 Minikit 3": 178,
    "1-4 Minikit 4": 179,
    "1-4 Minikit 5": 180,
    "1-4 Minikit 6": 181,
    "1-4 Minikit 7": 182,
    "1-4 Minikit 8": 183,
    "1-4 Minikit 9": 184,
    "1-4 Minikit 10": 185,
    "1-5 Minikit 1": 186,
    "1-5 Minikit 2": 187,
    "1-5 Minikit 3": 188,
    "1-5 Minikit 4": 189,
    "1-5 Minikit 5": 190,
    "1-5 Minikit 6": 191,
    "1-5 Minikit 7": 192,
    "1-5 Minikit 8": 193,
    "1-5 Minikit 9": 194,
    "1-5 Minikit 10": 195,
    "1-6 Minikit 1": 196,
    "1-6 Minikit 2": 197,
    "1-6 Minikit 3": 198,
    "1-6 Minikit 4": 199,
    "1-6 Minikit 5": 200,
    "1-6 Minikit 6": 201,
    "1-6 Minikit 7": 202,
    "1-6 Minikit 8": 203,
    "1-6 Minikit 9": 204,
    "1-6 Minikit 10": 205,
    "2-1 Minikit 1": 206,
    "2-1 Minikit 2": 207,
    "2-1 Minikit 3": 208,
    "2-1 Minikit 4": 209,
    "2-1 Minikit 5": 210,
    "2-1 Minikit 6": 211,
    "2-1 Minikit 7": 212,
    "2-1 Minikit 8": 213,
    "2-1 Minikit 9": 214,
    "2-1 Minikit 10": 215,
    "2-2 Minikit 1": 216,
    "2-2 Minikit 2": 217,
    "2-2 Minikit 3": 218,
    "2-2 Minikit 4": 219,
    "2-2 Minikit 5": 220,
    "2-2 Minikit 6": 221,
    "2-2 Minikit 7": 222,
    "2-2 Minikit 8": 223,
    "2-2 Minikit 9": 224,
    "2-2 Minikit 10": 225,
    "2-3 Minikit 1": 226,
    "2-3 Minikit 2": 227,
    "2-3 Minikit 3": 228,
    "2-3 Minikit 4": 229,
    "2-3 Minikit 5": 230,
    "2-3 Minikit 6": 231,
    "2-3 Minikit 7": 232,
    "2-3 Minikit 8": 233,
    "2-3 Minikit 9": 234,
    "2-3 Minikit 10": 235,
    "2-4 Minikit 1": 236,
    "2-4 Minikit 2": 237,
    "2-4 Minikit 3": 238,
    "2-4 Minikit 4": 239,
    "2-4 Minikit 5": 240,
    "2-4 Minikit 6": 241,
    "2-4 Minikit 7": 242,
    "2-4 Minikit 8": 243,
    "2-4 Minikit 9": 244,
    "2-4 Minikit 10": 245,
    "2-5 Minikit 1": 246,
    "2-5 Minikit 2": 247,
    "2-5 Minikit 3": 248,
    "2-5 Minikit 4": 249,
    "2-5 Minikit 5": 250,
    "2-5 Minikit 6": 251,
    "2-5 Minikit 7": 252,
    "2-5 Minikit 8": 253,
    "2-5 Minikit 9": 254,
    "2-5 Minikit 10": 255,
    "2-6 Minikit 1": 256,
    "2-6 Minikit 2": 257,
    "2-6 Minikit 3": 258,
    "2-6 Minikit 4": 259,
    "2-6 Minikit 5": 260,
    "2-6 Minikit 6": 261,
    "2-6 Minikit 7": 262,
    "2-6 Minikit 8": 263,
    "2-6 Minikit 9": 264,
    "2-6 Minikit 10": 265,
    "3-1 Minikit 1": 266,
    "3-1 Minikit 2": 267,
    "3-1 Minikit 3": 268,
    "3-1 Minikit 4": 269,
    "3-1 Minikit 5": 270,
    "3-1 Minikit 6": 271,
    "3-1 Minikit 7": 272,
    "3-1 Minikit 8": 273,
    "3-1 Minikit 9": 274,
    "3-1 Minikit 10": 275,
    "3-2 Minikit 1": 276,
    "3-2 Minikit 2": 277,
    "3-2 Minikit 3": 278,
    "3-2 Minikit 4": 279,
    "3-2 Minikit 5": 280,
    "3-2 Minikit 6": 281,
    "3-2 Minikit 7": 282,
    "3-2 Minikit 8": 283,
    "3-2 Minikit 9": 284,
    "3-2 Minikit 10": 285,
    "3-3 Minikit 1": 286,
    "3-3 Minikit 2": 287,
    "3-3 Minikit 3": 288,
    "3-3 Minikit 4": 289,
    "3-3 Minikit 5": 290,
    "3-3 Minikit 6": 291,
    "3-3 Minikit 7": 292,
    "3-3 Minikit 8": 293,
    "3-3 Minikit 9": 294,
    "3-3 Minikit 10": 295,
    "3-4 Minikit 1": 296,
    "3-4 Minikit 2": 297,
    "3-4 Minikit 3": 298,
    "3-4 Minikit 4": 299,
    "3-4 Minikit 5": 300,
    "3-4 Minikit 6": 301,
    "3-4 Minikit 7": 302,
    "3-4 Minikit 8": 303,
    "3-4 Minikit 9": 304,
    "3-4 Minikit 10": 305,
    "3-5 Minikit 1": 306,
    "3-5 Minikit 2": 307,
    "3-5 Minikit 3": 308,
    "3-5 Minikit 4": 309,
    "3-5 Minikit 5": 310,
    "3-5 Minikit 6": 311,
    "3-5 Minikit 7": 312,
    "3-5 Minikit 8": 313,
    "3-5 Minikit 9": 314,
    "3-5 Minikit 10": 315,
    "3-6 Minikit 1": 316,
    "3-6 Minikit 2": 317,
    "3-6 Minikit 3": 318,
    "3-6 Minikit 4": 319,
    "3-6 Minikit 5": 320,
    "3-6 Minikit 6": 321,
    "3-6 Minikit 7": 322,
    "3-6 Minikit 8": 323,
    "3-6 Minikit 9": 324,
    "3-6 Minikit 10": 325,
    "4-1 Minikit 1": 326,
    "4-1 Minikit 2": 327,
    "4-1 Minikit 3": 328,
    "4-1 Minikit 4": 329,
    "4-1 Minikit 5": 330,
    "4-1 Minikit 6": 331,
    "4-1 Minikit 7": 332,
    "4-1 Minikit 8": 333,
    "4-1 Minikit 9": 334,
    "4-1 Minikit 10": 335,
    "4-2 Minikit 1": 336,
    "4-2 Minikit 2": 337,
    "4-2 Minikit 3": 338,
    "4-2 Minikit 4": 339,
    "4-2 Minikit 5": 340,
    "4-2 Minikit 6": 341,
    "4-2 Minikit 7": 342,
    "4-2 Minikit 8": 343,
    "4-2 Minikit 9": 344,
    "4-2 Minikit 10": 345,
    "4-3 Minikit 1": 346,
    "4-3 Minikit 2": 347,
    "4-3 Minikit 3": 348,
    "4-3 Minikit 4": 349,
    "4-3 Minikit 5": 350,
    "4-3 Minikit 6": 351,
    "4-3 Minikit 7": 352,
    "4-3 Minikit 8": 353,
    "4-3 Minikit 9": 354,
    "4-3 Minikit 10": 355,
    "4-4 Minikit 1": 356,
    "4-4 Minikit 2": 357,
    "4-4 Minikit 3": 358,
    "4-4 Minikit 4": 359,
    "4-4 Minikit 5": 360,
    "4-4 Minikit 6": 361,
    "4-4 Minikit 7": 362,
    "4-4 Minikit 8": 363,
    "4-4 Minikit 9": 364,
    "4-4 Minikit 10": 365,
    "4-5 Minikit 1": 366,
    "4-5 Minikit 2": 367,
    "4-5 Minikit 3": 368,
    "4-5 Minikit 4": 369,
    "4-5 Minikit 5": 370,
    "4-5 Minikit 6": 371,
    "4-5 Minikit 7": 372,
    "4-5 Minikit 8": 373,
    "4-5 Minikit 9": 374,
    "4-5 Minikit 10": 375,
    "4-6 Minikit 1": 376,
    "4-6 Minikit 2": 377,
    "4-6 Minikit 3": 378,
    "4-6 Minikit 4": 379,
    "4-6 Minikit 5": 380,
    "4-6 Minikit 6": 381,
    "4-6 Minikit 7": 382,
    "4-6 Minikit 8": 383,
    "4-6 Minikit 9": 384,
    "4-6 Minikit 10": 385,
    "5-1 Minikit 1": 386,
    "5-1 Minikit 2": 387,
    "5-1 Minikit 3": 388,
    "5-1 Minikit 4": 389,
    "5-1 Minikit 5": 390,
    "5-1 Minikit 6": 391,
    "5-1 Minikit 7": 392,
    "5-1 Minikit 8": 393,
    "5-1 Minikit 9": 394,
    "5-1 Minikit 10": 395,
    "5-2 Minikit 1": 396,
    "5-2 Minikit 2": 397,
    "5-2 Minikit 3": 398,
    "5-2 Minikit 4": 399,
    "5-2 Minikit 5": 400,
    "5-2 Minikit 6": 401,
    "5-2 Minikit 7": 402,
    "5-2 Minikit 8": 403,
    "5-2 Minikit 9": 404,
    "5-2 Minikit 10": 405,
    "5-3 Minikit 1": 406,
    "5-3 Minikit 2": 407,
    "5-3 Minikit 3": 408,
    "5-3 Minikit 4": 409,
    "5-3 Minikit 5": 410,
    "5-3 Minikit 6": 411,
    "5-3 Minikit 7": 412,
    "5-3 Minikit 8": 413,
    "5-3 Minikit 9": 414,
    "5-3 Minikit 10": 415,
    "5-4 Minikit 1": 416,
    "5-4 Minikit 2": 417,
    "5-4 Minikit 3": 418,
    "5-4 Minikit 4": 419,
    "5-4 Minikit 5": 420,
    "5-4 Minikit 6": 421,
    "5-4 Minikit 7": 422,
    "5-4 Minikit 8": 423,
    "5-4 Minikit 9": 424,
    "5-4 Minikit 10": 425,
    "5-5 Minikit 1": 426,
    "5-5 Minikit 2": 427,
    "5-5 Minikit 3": 428,
    "5-5 Minikit 4": 429,
    "5-5 Minikit 5": 430,
    "5-5 Minikit 6": 431,
    "5-5 Minikit 7": 432,
    "5-5 Minikit 8": 433,
    "5-5 Minikit 9": 434,
    "5-5 Minikit 10": 435,
    "5-6 Minikit 1": 436,
    "5-6 Minikit 2": 437,
    "5-6 Minikit 3": 438,
    "5-6 Minikit 4": 439,
    "5-6 Minikit 5": 440,
    "5-6 Minikit 6": 441,
    "5-6 Minikit 7": 442,
    "5-6 Minikit 8": 443,
    "5-6 Minikit 9": 444,
    "5-6 Minikit 10": 445,
    "6-1 Minikit 1": 446,
    "6-1 Minikit 2": 447,
    "6-1 Minikit 3": 448,
    "6-1 Minikit 4": 449,
    "6-1 Minikit 5": 450,
    "6-1 Minikit 6": 451,
    "6-1 Minikit 7": 452,
    "6-1 Minikit 8": 453,
    "6-1 Minikit 9": 454,
    "6-1 Minikit 10": 455,
    "6-2 Minikit 1": 456,
    "6-2 Minikit 2": 457,
    "6-2 Minikit 3": 458,
    "6-2 Minikit 4": 459,
    "6-2 Minikit 5": 460,
    "6-2 Minikit 6": 461,
    "6-2 Minikit 7": 462,
    "6-2 Minikit 8": 463,
    "6-2 Minikit 9": 464,
    "6-2 Minikit 10": 465,
    "6-3 Minikit 1": 466,
    "6-3 Minikit 2": 467,
    "6-3 Minikit 3": 468,
    "6-3 Minikit 4": 469,
    "6-3 Minikit 5": 470,
    "6-3 Minikit 6": 471,
    "6-3 Minikit 7": 472,
    "6-3 Minikit 8": 473,
    "6-3 Minikit 9": 474,
    "6-3 Minikit 10": 475,
    "6-4 Minikit 1": 476,
    "6-4 Minikit 2": 477,
    "6-4 Minikit 3": 478,
    "6-4 Minikit 4": 479,
    "6-4 Minikit 5": 480,
    "6-4 Minikit 6": 481,
    "6-4 Minikit 7": 482,
    "6-4 Minikit 8": 483,
    "6-4 Minikit 9": 484,
    "6-4 Minikit 10": 485,
    "6-5 Minikit 1": 486,
    "6-5 Minikit 2": 487,
    "6-5 Minikit 3": 488,
    "6-5 Minikit 4": 489,
    "6-5 Minikit 5": 490,
    "6-5 Minikit 6": 491,
    "6-5 Minikit 7": 492,
    "6-5 Minikit 8": 493,
    "6-5 Minikit 9": 494,
    "6-5 Minikit 10": 495,
    "6-6 Minikit 1": 496,
    "6-6 Minikit 2": 497,
    "6-6 Minikit 3": 498,
    "6-6 Minikit 4": 499,
    "6-6 Minikit 5": 500,
    "6-6 Minikit 6": 501,
    "6-6 Minikit 7": 502,
    "6-6 Minikit 8": 503,
    "6-6 Minikit 9": 504,
    "6-6 Minikit 10": 505,
    "1-1 Completion": 506,
    "1-2 Completion": 507,
    "1-3 Completion": 508,
    "1-4 Completion": 509,
    "1-5 Completion": 510,
    "1-6 Completion": 511,
    "2-1 Completion": 512,
    "2-2 Completion": 513,
    "2-3 Completion": 514,
    "2-4 Completion": 515,
    "2-5 Completion": 516,
    "2-6 Completion": 517,
    "3-1 Completion": 518,
    "3-2 Completion": 519,
    "3-3 Completion": 520,
    "3-4 Completion": 521,
    "3-5 Completion": 522,
    "3-6 Completion": 523,
    "4-1 Completion": 524,
    "4-2 Completion": 525,
    "4-3 Completion": 526,
    "4-4 Completion": 527,
    "4-5 Completion": 528,
    "4-6 Completion": 529,
    "5-1 Completion": 530,
    "5-2 Completion": 531,
    "5-3 Completion": 532,
    "5-4 Completion": 533,
    "5-5 Completion": 534,
    "5-6 Completion": 535,
    "6-1 Completion": 536,
    "6-2 Completion": 537,
    "6-3 Completion": 538,
    "6-4 Completion": 539,
    "6-5 Completion": 540,
    "6-6 Completion": 541,
    "Slave I": 542,
    "Purchase Score x4 (5-3)": 543,
    "Purchase Score x6 (5-5)": 544,
    "Purchase Score x8 (6-3)": 545,
    "Purchase Score x10 (6-5)": 546,
    "Mos Espa Pod Race (Original) Completion": 547,
    "Anakin's Flight Completion": 548,
    "Gunship Cavalry (Original) Completion": 549,
    "A New Hope (Bonus Level) Completion": 550,
    "LEGO City Completion": 551,
    "New Town Completion": 552,
    "Indiana Jones: Trailer": 553,
    "Purchase Indiana Jones": 554,
    "Purchase Princess Leia (Prisoner)": 555,
    "Purchase Sebulba's Pod": 556,
    "Purchase Zam's Airspeeder": 557,
    "Purchase Droid Trifighter": 558,
    "Purchase Vulture Droid": 559,
    "Purchase Clone Arcfighter": 560,
    "Purchase TIE Fighter": 561,
    "Purchase TIE Fighter (Darth Vader)": 562,
    "Purchase TIE Interceptor": 563,
    "Purchase TIE Bomber": 564,
    "Purchase Imperial Shuttle": 565,
    "Chapter Completion - Unlock Obi-Wan Kenobi": 566,
    "Chapter Completion - Unlock Qui-Gon Jinn": 567,
    "Chapter Completion - Unlock TC-14": 568,
    "Chapter Completion - Unlock Jar Jar Binks": 569,
    "Chapter Completion - Unlock Captain Panaka": 570,
    "Chapter Completion - Unlock Queen Amidala": 571,
    "Chapter Completion - Unlock Anakin's Pod": 572,
    "Chapter Completion - Unlock Anakin Skywalker (Boy)": 573,
    "Chapter Completion - Unlock Padmé (Battle)": 574,
    "Chapter Completion - Unlock R2-D2": 575,
    "Chapter Completion - Unlock Anakin's Speeder": 576,
    "Chapter Completion - Unlock Obi-Wan Kenobi (Jedi Master)": 577,
    "Chapter Completion - Unlock R4-P17": 578,
    "Chapter Completion - Unlock Anakin Skywalker (Padawan)": 579,
    "Chapter Completion - Unlock C-3PO": 580,
    "Chapter Completion - Unlock Padmé (Geonosis)": 581,
    "Chapter Completion - Unlock Mace Windu": 582,
    "Chapter Completion - Unlock Padmé (Clawed)": 583,
    "Chapter Completion - Unlock Republic Gunship": 584,
    "Chapter Completion - Unlock Yoda": 585,
    "Chapter Completion - Unlock Anakin's Starfighter": 586,
    "Chapter Completion - Unlock Obi-Wan's Starfighter": 587,
    "Chapter Completion - Unlock Anakin Skywalker (Jedi)": 588,
    "Chapter Completion - Unlock Chancellor Palpatine": 589,
    "Chapter Completion - Unlock Obi-Wan Kenobi (Episode 3)": 590,
    "Chapter Completion - Unlock Commander Cody": 591,
    "Chapter Completion - Unlock Chewbacca": 592,
    "Chapter Completion - Unlock Captain Antilles": 593,
    "Chapter Completion - Unlock Princess Leia": 594,
    "Chapter Completion - Unlock Rebel Friend": 595,
    "Chapter Completion - Unlock Ben Kenobi": 596,
    "Chapter Completion - Unlock Luke Skywalker (Tatooine)": 597,
    "Chapter Completion - Unlock Han Solo": 598,
    "Chapter Completion - Unlock Han Solo (Stormtrooper)": 599,
    "Chapter Completion - Unlock Luke Skywalker (Stormtrooper)": 600,
    "Chapter Completion - Unlock X-Wing": 601,
    "Chapter Completion - Unlock Y-Wing": 602,
    "Chapter Completion - Unlock Snowspeeder": 603,
    "Chapter Completion - Unlock Han Solo (Hoth)": 604,
    "Chapter Completion - Unlock Princess Leia (Hoth)": 605,
    "Chapter Completion - Unlock Millennium Falcon": 606,
    "Chapter Completion - Unlock Luke Skywalker (Dagobah)": 607,
    "Chapter Completion - Unlock Luke Skywalker (Pilot)": 608,
    "Chapter Completion - Unlock Luke Skywalker (Bespin)": 609,
    "Chapter Completion - Unlock Lando Calrissian": 610,
    "Chapter Completion - Unlock Princess Leia (Bespin)": 611,
    "Chapter Completion - Unlock Han Solo (Skiff)": 612,
    "Chapter Completion - Unlock Princess Leia (Boushh)": 613,
    "Chapter Completion - Unlock Luke Skywalker (Jedi)": 614,
    "Chapter Completion - Unlock Princess Leia (Slave)": 615,
    "Chapter Completion - Unlock Lando Calrissian (Palace Guard)": 616,
    "Chapter Completion - Unlock Luke Skywalker (Endor)": 617,
    "Chapter Completion - Unlock Princess Leia (Endor)": 618,
    "Chapter Completion - Unlock Han Solo (Endor)": 619,
    "Chapter Completion - Unlock Wicket": 620,
    "Chapter Completion - Unlock Darth Vader": 621,
    "Ride STAP": 622,
    "Ride Landspeeder": 623,
    "Ride Wookie Flyer": 624,
    "Ride Dewback": 625,
    "Ride Moon Car": 626,
    "Ride Lifeboat": 627,
    "Ride Firetruck": 628,
    "Ride Basketball Cannon": 629,
    "Ride Clone Walker": 630,
    "Ride Cloud Car": 631,
    "Ride Tauntaun": 632,
    "Ride Town Car": 633,
    "Ride Tractor": 634,
    "Ride Bantha": 635,
    "Ride AT-ST": 636,
    "Ride Service Car": 637,
    "Ride Flash Speeder": 638,
    "Ride Crane Control": 639,
    "Ride Mos Eisley Cannon": 640,
    "Ride Stormtrooper Cannon": 641,
    "Ride Snowmobile": 642,
    "Ride Ewok Catapult": 643,
    "Ride Skiff Cannon": 644,
    "Ride Big Skiff Cannon": 645,
    "Ride Cantina Car": 646,
    "Ride Speeder Bike": 647,
    "Ride AT-AT": 648,
    "Purchase Extra Toggle": 649,
    "Purchase Fertilizer": 650,
    "Purchase Disguise": 651,
    "Purchase Daisy Chains": 652,
    "Purchase Chewbacca Carrying C-3PO": 653,
    "Purchase Tow Death Star": 654,
    "Purchase Silhouettes": 655,
    "Purchase Beep Beep": 656,
}


class LegoStarWarsTCSLocation(Location):
    game = GAME_NAME


class LegoStarWarsTCSShopLocation(LegoStarWarsTCSLocation):
    studs_cost: int

    def __init__(self, player: int, name: str, address: int, parent: Region, studs_cost: int):
        super().__init__(player, name, address, parent)
        self.studs_cost = studs_cost
