from typing import Dict, NamedTuple, Optional, Set
import typing


from BaseClasses import Location


class KH1Location(Location):
    game: str = "Kingdom Hearts"


class KH1LocationData(NamedTuple):
    category: str
    code: Optional[int] = None
    type: Optional[str] = None
    behind_boss: Optional[bool] = False

def get_locations_by_type(type: str) -> Dict[str, KH1LocationData]:
    return {name: data for name, data in location_table.items() if data.type == type}


location_table: Dict[str, KH1LocationData] = {
    "Destiny Islands Chest":                                                            KH1LocationData("Destiny Islands",  265_0011, "Chest"),
    "Traverse Town 1st District Candle Puzzle Chest":                                   KH1LocationData("Traverse Town",    265_0211, "Chest"),
    "Traverse Town 1st District Accessory Shop Roof Chest":                             KH1LocationData("Traverse Town",    265_0212, "Chest"),
    "Traverse Town 2nd District Boots and Shoes Awning Chest":                          KH1LocationData("Traverse Town",    265_0213, "Chest"),
    "Traverse Town 2nd District Rooftop Chest":                                         KH1LocationData("Traverse Town",    265_0214, "Chest"),
    "Traverse Town 2nd District Gizmo Shop Facade Chest":                               KH1LocationData("Traverse Town",    265_0251, "Chest"),
    "Traverse Town Alleyway Balcony Chest":                                             KH1LocationData("Traverse Town",    265_0252, "Chest"),
    "Traverse Town Alleyway Blue Room Awning Chest":                                    KH1LocationData("Traverse Town",    265_0253, "Chest"),
    "Traverse Town Alleyway Corner Chest":                                              KH1LocationData("Traverse Town",    265_0254, "Chest"),
    "Traverse Town Green Room Clock Puzzle Chest":                                      KH1LocationData("Traverse Town",    265_0292, "Chest"),
    "Traverse Town Green Room Table Chest":                                             KH1LocationData("Traverse Town",    265_0293, "Chest"),
    "Traverse Town Red Room Chest":                                                     KH1LocationData("Traverse Town",    265_0294, "Chest"),
    "Traverse Town Mystical House Yellow Trinity Chest":                                KH1LocationData("Traverse Town",    265_0331, "Chest"),
    "Traverse Town Accessory Shop Chest":                                               KH1LocationData("Traverse Town",    265_0332, "Chest"),
    "Traverse Town Secret Waterway White Trinity Chest":                                KH1LocationData("Traverse Town",    265_0333, "Chest"),
    "Traverse Town Geppetto's House Chest":                                             KH1LocationData("Traverse Town",    265_0334, "Chest",  True),
    "Traverse Town Item Workshop Right Chest":                                          KH1LocationData("Traverse Town",    265_0371, "Chest"),
    "Traverse Town 1st District Blue Trinity Balcony Chest":                            KH1LocationData("Traverse Town",    265_0411, "Chest"),
    "Traverse Town Mystical House Glide Chest":                                         KH1LocationData("Traverse Town",    265_0891, "Chest"),
    "Traverse Town Alleyway Behind Crates Chest":                                       KH1LocationData("Traverse Town",    265_0892, "Chest"),
    "Traverse Town Item Workshop Left Chest":                                           KH1LocationData("Traverse Town",    265_0893, "Chest"),
    "Traverse Town Secret Waterway Near Stairs Chest":                                  KH1LocationData("Traverse Town",    265_0894, "Chest"),
    "Wonderland Rabbit Hole Green Trinity Chest":                                       KH1LocationData("Wonderland",       265_0931, "Chest"),
    "Wonderland Rabbit Hole Defeat Heartless 1 Chest":                                  KH1LocationData("Wonderland",       265_0932, "Chest"),
    "Wonderland Rabbit Hole Defeat Heartless 2 Chest":                                  KH1LocationData("Wonderland",       265_0933, "Chest"),
    "Wonderland Rabbit Hole Defeat Heartless 3 Chest":                                  KH1LocationData("Wonderland",       265_0934, "Chest"),
    "Wonderland Bizarre Room Green Trinity Chest":                                      KH1LocationData("Wonderland",       265_0971, "Chest"),
    "Wonderland Queen's Castle Hedge Left Red Chest":                                   KH1LocationData("Wonderland",       265_1011, "Chest"),
    "Wonderland Queen's Castle Hedge Right Blue Chest":                                 KH1LocationData("Wonderland",       265_1012, "Chest"),
    "Wonderland Queen's Castle Hedge Right Red Chest":                                  KH1LocationData("Wonderland",       265_1013, "Chest"),
    "Wonderland Lotus Forest Thunder Plant Chest":                                      KH1LocationData("Wonderland",       265_1014, "Chest"),
    "Wonderland Lotus Forest Through the Painting Thunder Plant Chest":                 KH1LocationData("Wonderland",       265_1051, "Chest"),
    "Wonderland Lotus Forest Glide Chest":                                              KH1LocationData("Wonderland",       265_1052, "Chest"),
    "Wonderland Lotus Forest Nut Chest":                                                KH1LocationData("Wonderland",       265_1053, "Chest"),
    "Wonderland Lotus Forest Corner Chest":                                             KH1LocationData("Wonderland",       265_1054, "Chest"),
    "Wonderland Bizarre Room Lamp Chest":                                               KH1LocationData("Wonderland",       265_1091, "Chest"),
    "Wonderland Tea Party Garden Above Lotus Forest Entrance 2nd Chest":                KH1LocationData("Wonderland",       265_1093, "Chest"),
    "Wonderland Tea Party Garden Above Lotus Forest Entrance 1st Chest":                KH1LocationData("Wonderland",       265_1094, "Chest"),
    "Wonderland Tea Party Garden Bear and Clock Puzzle Chest":                          KH1LocationData("Wonderland",       265_1131, "Chest"),
    "Wonderland Tea Party Garden Across From Bizarre Room Entrance Chest":              KH1LocationData("Wonderland",       265_1132, "Chest"),
    "Wonderland Lotus Forest Through the Painting White Trinity Chest":                 KH1LocationData("Wonderland",       265_1133, "Chest"),
    "Deep Jungle Tree House Beneath Tree House Chest":                                  KH1LocationData("Deep Jungle",      265_1213, "Chest"),
    "Deep Jungle Tree House Rooftop Chest":                                             KH1LocationData("Deep Jungle",      265_1214, "Chest"),
    "Deep Jungle Hippo's Lagoon Center Chest":                                          KH1LocationData("Deep Jungle",      265_1251, "Chest"),
    "Deep Jungle Hippo's Lagoon Left Chest":                                            KH1LocationData("Deep Jungle",      265_1252, "Chest"),
    "Deep Jungle Hippo's Lagoon Right Chest":                                           KH1LocationData("Deep Jungle",      265_1253, "Chest"),
    "Deep Jungle Vines Chest":                                                          KH1LocationData("Deep Jungle",      265_1291, "Chest"),
    "Deep Jungle Vines 2 Chest":                                                        KH1LocationData("Deep Jungle",      265_1292, "Chest"),
    "Deep Jungle Climbing Trees Blue Trinity Chest":                                    KH1LocationData("Deep Jungle",      265_1293, "Chest"),
    "Deep Jungle Tunnel Chest":                                                         KH1LocationData("Deep Jungle",      265_1331, "Chest"),
    "Deep Jungle Cavern of Hearts White Trinity Chest":                                 KH1LocationData("Deep Jungle",      265_1332, "Chest",  True),
    "Deep Jungle Camp Blue Trinity Chest":                                              KH1LocationData("Deep Jungle",      265_1333, "Chest"),
    "Deep Jungle Tent Chest":                                                           KH1LocationData("Deep Jungle",      265_1334, "Chest"),
    "Deep Jungle Waterfall Cavern Low Chest":                                           KH1LocationData("Deep Jungle",      265_1371, "Chest",  True),
    "Deep Jungle Waterfall Cavern Middle Chest":                                        KH1LocationData("Deep Jungle",      265_1372, "Chest",  True),
    "Deep Jungle Waterfall Cavern High Wall Chest":                                     KH1LocationData("Deep Jungle",      265_1373, "Chest",  True),
    "Deep Jungle Waterfall Cavern High Middle Chest":                                   KH1LocationData("Deep Jungle",      265_1374, "Chest",  True),
    "Deep Jungle Cliff Right Cliff Left Chest":                                         KH1LocationData("Deep Jungle",      265_1411, "Chest"),
    "Deep Jungle Cliff Right Cliff Right Chest":                                        KH1LocationData("Deep Jungle",      265_1412, "Chest"),
    "Deep Jungle Tree House Suspended Boat Chest":                                      KH1LocationData("Deep Jungle",      265_1413, "Chest"),
    "100 Acre Wood Meadow Inside Log Chest":                                            KH1LocationData("100 Acre Wood",    265_1654, "Chest"),
    "100 Acre Wood Bouncing Spot Left Cliff Chest":                                     KH1LocationData("100 Acre Wood",    265_1691, "Chest"),
    "100 Acre Wood Bouncing Spot Right Tree Alcove Chest":                              KH1LocationData("100 Acre Wood",    265_1692, "Chest"),
    "100 Acre Wood Bouncing Spot Under Giant Pot Chest":                                KH1LocationData("100 Acre Wood",    265_1693, "Chest"),
    "Agrabah Plaza By Storage Chest":                                                   KH1LocationData("Agrabah",          265_1972, "Chest"),
    "Agrabah Plaza Raised Terrace Chest":                                               KH1LocationData("Agrabah",          265_1973, "Chest"),
    "Agrabah Plaza Top Corner Chest":                                                   KH1LocationData("Agrabah",          265_1974, "Chest"),
    "Agrabah Alley Chest":                                                              KH1LocationData("Agrabah",          265_2011, "Chest"),
    "Agrabah Bazaar Across Windows Chest":                                              KH1LocationData("Agrabah",          265_2012, "Chest"),
    "Agrabah Bazaar High Corner Chest":                                                 KH1LocationData("Agrabah",          265_2013, "Chest"),
    "Agrabah Main Street Right Palace Entrance Chest":                                  KH1LocationData("Agrabah",          265_2014, "Chest"),
    "Agrabah Main Street High Above Alley Entrance Chest":                              KH1LocationData("Agrabah",          265_2051, "Chest"),
    "Agrabah Main Street High Above Palace Gates Entrance Chest":                       KH1LocationData("Agrabah",          265_2052, "Chest"),
    "Agrabah Palace Gates Low Chest":                                                   KH1LocationData("Agrabah",          265_2053, "Chest",  True),
    "Agrabah Palace Gates High Opposite Palace Chest":                                  KH1LocationData("Agrabah",          265_2054, "Chest",  True),
    "Agrabah Palace Gates High Close to Palace Chest":                                  KH1LocationData("Agrabah",          265_2091, "Chest",  True),
    "Agrabah Storage Green Trinity Chest":                                              KH1LocationData("Agrabah",          265_2092, "Chest"),
    "Agrabah Storage Behind Barrel Chest":                                              KH1LocationData("Agrabah",          265_2093, "Chest"),
    "Agrabah Cave of Wonders Entrance Left Chest":                                      KH1LocationData("Agrabah",          265_2094, "Chest",  True),
    "Agrabah Cave of Wonders Entrance Tall Tower Chest":                                KH1LocationData("Agrabah",          265_2131, "Chest",  True),
    "Agrabah Cave of Wonders Hall High Left Chest":                                     KH1LocationData("Agrabah",          265_2132, "Chest",  True),
    "Agrabah Cave of Wonders Hall Near Bottomless Hall Chest":                          KH1LocationData("Agrabah",          265_2133, "Chest",  True),
    "Agrabah Cave of Wonders Bottomless Hall Raised Platform Chest":                    KH1LocationData("Agrabah",          265_2134, "Chest",  True),
    "Agrabah Cave of Wonders Bottomless Hall Pillar Chest":                             KH1LocationData("Agrabah",          265_2171, "Chest",  True),
    "Agrabah Cave of Wonders Bottomless Hall Across Chasm Chest":                       KH1LocationData("Agrabah",          265_2172, "Chest",  True),
    "Agrabah Cave of Wonders Treasure Room Across Platforms Chest":                     KH1LocationData("Agrabah",          265_2173, "Chest",  True),
    "Agrabah Cave of Wonders Treasure Room Small Treasure Pile Chest":                  KH1LocationData("Agrabah",          265_2174, "Chest",  True),
    "Agrabah Cave of Wonders Treasure Room Large Treasure Pile Chest":                  KH1LocationData("Agrabah",          265_2211, "Chest",  True),
    "Agrabah Cave of Wonders Treasure Room Above Fire Chest":                           KH1LocationData("Agrabah",          265_2212, "Chest",  True),
    "Agrabah Cave of Wonders Relic Chamber Jump from Stairs Chest":                     KH1LocationData("Agrabah",          265_2213, "Chest",  True),
    "Agrabah Cave of Wonders Relic Chamber Stairs Chest":                               KH1LocationData("Agrabah",          265_2214, "Chest",  True),
    "Agrabah Cave of Wonders Dark Chamber Abu Gem Chest":                               KH1LocationData("Agrabah",          265_2251, "Chest",  True),
    "Agrabah Cave of Wonders Dark Chamber Across from Relic Chamber Entrance Chest":    KH1LocationData("Agrabah",          265_2252, "Chest",  True),
    "Agrabah Cave of Wonders Dark Chamber Bridge Chest":                                KH1LocationData("Agrabah",          265_2253, "Chest",  True),
    "Agrabah Cave of Wonders Dark Chamber Near Save Chest":                             KH1LocationData("Agrabah",          265_2254, "Chest",  True),
    "Agrabah Cave of Wonders Silent Chamber Blue Trinity Chest":                        KH1LocationData("Agrabah",          265_2291, "Chest",  True),
    "Agrabah Cave of Wonders Hidden Room Right Chest":                                  KH1LocationData("Agrabah",          265_2292, "Chest",  True),
    "Agrabah Cave of Wonders Hidden Room Left Chest":                                   KH1LocationData("Agrabah",          265_2293, "Chest",  True),
    "Agrabah Aladdin's House Main Street Entrance Chest":                               KH1LocationData("Agrabah",          265_2294, "Chest"),
    "Agrabah Aladdin's House Plaza Entrance Chest":                                     KH1LocationData("Agrabah",          265_2331, "Chest"),
    "Agrabah Cave of Wonders Entrance White Trinity Chest":                             KH1LocationData("Agrabah",          265_2332, "Chest",  True),
    "Monstro Chamber 6 Other Platform Chest":                                           KH1LocationData("Monstro",          265_2413, "Chest"),
    "Monstro Chamber 6 Platform Near Chamber 5 Entrance Chest":                         KH1LocationData("Monstro",          265_2414, "Chest"),
    "Monstro Chamber 6 Raised Area Near Chamber 1 Entrance Chest":                      KH1LocationData("Monstro",          265_2451, "Chest"),
    "Monstro Chamber 6 Low Chest":                                                      KH1LocationData("Monstro",          265_2452, "Chest"),
    "Atlantica Sunken Ship In Flipped Boat Chest":                                      KH1LocationData("Atlantica",        265_2531, "Static"),
    "Atlantica Sunken Ship Seabed Chest":                                               KH1LocationData("Atlantica",        265_2532, "Static"),
    "Atlantica Sunken Ship Inside Ship Chest":                                          KH1LocationData("Atlantica",        265_2533, "Static"),
    "Atlantica Ariel's Grotto High Chest":                                              KH1LocationData("Atlantica",        265_2534, "Static"),
    "Atlantica Ariel's Grotto Middle Chest":                                            KH1LocationData("Atlantica",        265_2571, "Static"),
    "Atlantica Ariel's Grotto Low Chest":                                               KH1LocationData("Atlantica",        265_2572, "Static"),
    "Atlantica Ursula's Lair Use Fire on Urchin Chest":                                 KH1LocationData("Atlantica",        265_2573, "Static", True),
    "Atlantica Undersea Gorge Jammed by Ariel's Grotto Chest":                          KH1LocationData("Atlantica",        265_2574, "Static"),
    "Atlantica Triton's Palace White Trinity Chest":                                    KH1LocationData("Atlantica",        265_2611, "Static"),
    "Halloween Town Moonlight Hill White Trinity Chest":                                KH1LocationData("Halloween Town",   265_3014, "Chest"),
    "Halloween Town Bridge Under Bridge":                                               KH1LocationData("Halloween Town",   265_3051, "Chest"),
    "Halloween Town Boneyard Tombstone Puzzle Chest":                                   KH1LocationData("Halloween Town",   265_3052, "Chest"),
    "Halloween Town Bridge Right of Gate Chest":                                        KH1LocationData("Halloween Town",   265_3053, "Chest"),
    "Halloween Town Cemetery Behind Grave Chest":                                       KH1LocationData("Halloween Town",   265_3054, "Chest",  True),
    "Halloween Town Cemetery By Cat Shape Chest":                                       KH1LocationData("Halloween Town",   265_3091, "Chest",  True),
    "Halloween Town Cemetery Between Graves Chest":                                     KH1LocationData("Halloween Town",   265_3092, "Chest",  True),
    "Halloween Town Oogie's Manor Lower Iron Cage Chest":                               KH1LocationData("Halloween Town",   265_3093, "Chest"),
    "Halloween Town Oogie's Manor Upper Iron Cage Chest":                               KH1LocationData("Halloween Town",   265_3094, "Chest"),
    "Halloween Town Oogie's Manor Hollow Chest":                                        KH1LocationData("Halloween Town",   265_3131, "Chest",  True),
    "Halloween Town Oogie's Manor Grounds Red Trinity Chest":                           KH1LocationData("Halloween Town",   265_3132, "Chest"),
    "Halloween Town Guillotine Square High Tower Chest":                                KH1LocationData("Halloween Town",   265_3133, "Chest"),
    "Halloween Town Guillotine Square Pumpkin Structure Left Chest":                    KH1LocationData("Halloween Town",   265_3134, "Chest"),
    "Halloween Town Oogie's Manor Entrance Steps Chest":                                KH1LocationData("Halloween Town",   265_3171, "Chest"),
    "Halloween Town Oogie's Manor Inside Entrance Chest":                               KH1LocationData("Halloween Town",   265_3172, "Chest"),
    "Halloween Town Bridge Left of Gate Chest":                                         KH1LocationData("Halloween Town",   265_3291, "Chest"),
    "Halloween Town Cemetery By Striped Grave Chest":                                   KH1LocationData("Halloween Town",   265_3292, "Chest",  True),
    "Halloween Town Guillotine Square Under Jack's House Stairs Chest":                 KH1LocationData("Halloween Town",   265_3293, "Chest"),
    "Halloween Town Guillotine Square Pumpkin Structure Right Chest":                   KH1LocationData("Halloween Town",   265_3294, "Chest"),
    "Olympus Coliseum Coliseum Gates Left Behind Columns Chest":                        KH1LocationData("Olympus Coliseum", 265_3332, "Chest"),
    "Olympus Coliseum Coliseum Gates Right Blue Trinity Chest":                         KH1LocationData("Olympus Coliseum", 265_3333, "Chest"),
    "Olympus Coliseum Coliseum Gates Left Blue Trinity Chest":                          KH1LocationData("Olympus Coliseum", 265_3334, "Chest"),
    "Olympus Coliseum Coliseum Gates White Trinity Chest":                              KH1LocationData("Olympus Coliseum", 265_3371, "Chest"),
    "Olympus Coliseum Coliseum Gates Blizzara Chest":                                   KH1LocationData("Olympus Coliseum", 265_3372, "Chest"),
    "Olympus Coliseum Coliseum Gates Blizzaga Chest":                                   KH1LocationData("Olympus Coliseum", 265_3373, "Chest"),
    "Monstro Mouth Boat Deck Chest":                                                    KH1LocationData("Monstro",          265_3454, "Chest",  True),
    "Monstro Mouth High Platform Boat Side Chest":                                      KH1LocationData("Monstro",          265_3491, "Chest"),
    "Monstro Mouth High Platform Across from Boat Chest":                               KH1LocationData("Monstro",          265_3492, "Chest"),
    "Monstro Mouth Near Ship Chest":                                                    KH1LocationData("Monstro",          265_3493, "Chest"),
    "Monstro Mouth Green Trinity Top of Boat Chest":                                    KH1LocationData("Monstro",          265_3494, "Chest",  True),
    "Monstro Chamber 2 Ground Chest":                                                   KH1LocationData("Monstro",          265_3534, "Chest"),
    "Monstro Chamber 2 Platform Chest":                                                 KH1LocationData("Monstro",          265_3571, "Chest"),
    "Monstro Chamber 5 Platform Chest":                                                 KH1LocationData("Monstro",          265_3613, "Chest"),
    "Monstro Chamber 3 Ground Chest":                                                   KH1LocationData("Monstro",          265_3614, "Chest"),
    "Monstro Chamber 3 Platform Above Chamber 2 Entrance Chest":                        KH1LocationData("Monstro",          265_3651, "Chest"),
    "Monstro Chamber 3 Near Chamber 6 Entrance Chest":                                  KH1LocationData("Monstro",          265_3652, "Chest"),
    "Monstro Chamber 3 Platform Near Chamber 6 Entrance Chest":                         KH1LocationData("Monstro",          265_3653, "Chest"),
    "Monstro Mouth High Platform Near Teeth Chest":                                     KH1LocationData("Monstro",          265_3732, "Chest",  True),
    "Monstro Chamber 5 Atop Barrel Chest":                                              KH1LocationData("Monstro",          265_3733, "Chest"),
    "Monstro Chamber 5 Low 2nd Chest":                                                  KH1LocationData("Monstro",          265_3734, "Chest"),
    "Monstro Chamber 5 Low 1st Chest":                                                  KH1LocationData("Monstro",          265_3771, "Chest"),
    "Neverland Pirate Ship Deck White Trinity Chest":                                   KH1LocationData("Neverland",        265_3772, "Chest",  True),
    "Neverland Pirate Ship Crows Nest Chest":                                           KH1LocationData("Neverland",        265_3773, "Chest",  True),
    "Neverland Hold Yellow Trinity Right Blue Chest":                                   KH1LocationData("Neverland",        265_3774, "Chest"),
    "Neverland Hold Yellow Trinity Left Blue Chest":                                    KH1LocationData("Neverland",        265_3811, "Chest"),
    "Neverland Galley Chest":                                                           KH1LocationData("Neverland",        265_3812, "Chest"),
    "Neverland Cabin Chest":                                                            KH1LocationData("Neverland",        265_3813, "Chest",  True),
    "Neverland Hold Flight 1st Chest":                                                  KH1LocationData("Neverland",        265_3814, "Chest",  True),
    "Neverland Clock Tower Chest":                                                      KH1LocationData("Neverland",        265_4014, "Chest",  True),
    "Neverland Hold Flight 2nd Chest":                                                  KH1LocationData("Neverland",        265_4051, "Chest",  True),
    "Neverland Hold Yellow Trinity Green Chest":                                        KH1LocationData("Neverland",        265_4052, "Chest"),
    "Neverland Captain's Cabin Chest":                                                  KH1LocationData("Neverland",        265_4053, "Chest",  True),
    "Hollow Bastion Rising Falls Water's Surface Chest":                                KH1LocationData("Hollow Bastion",   265_4054, "Chest"),
    "Hollow Bastion Rising Falls Under Water 1st Chest":                                KH1LocationData("Hollow Bastion",   265_4091, "Chest"),
    "Hollow Bastion Rising Falls Under Water 2nd Chest":                                KH1LocationData("Hollow Bastion",   265_4092, "Chest",  True),
    "Hollow Bastion Rising Falls Floating Platform Near Save Chest":                    KH1LocationData("Hollow Bastion",   265_4093, "Chest"),
    "Hollow Bastion Rising Falls Floating Platform Near Bubble Chest":                  KH1LocationData("Hollow Bastion",   265_4094, "Chest"),
    "Hollow Bastion Rising Falls High Platform Chest":                                  KH1LocationData("Hollow Bastion",   265_4131, "Chest"),
    "Hollow Bastion Castle Gates Gravity Chest":                                        KH1LocationData("Hollow Bastion",   265_4132, "Chest"),
    "Hollow Bastion Castle Gates Freestanding Pillar Chest":                            KH1LocationData("Hollow Bastion",   265_4133, "Chest"),
    "Hollow Bastion Castle Gates High Pillar Chest":                                    KH1LocationData("Hollow Bastion",   265_4134, "Chest"),
    "Hollow Bastion Great Crest Lower Chest":                                           KH1LocationData("Hollow Bastion",   265_4171, "Chest",  True),
    "Hollow Bastion Great Crest After Battle Platform Chest":                           KH1LocationData("Hollow Bastion",   265_4172, "Chest",  True),
    "Hollow Bastion High Tower 2nd Gravity Chest":                                      KH1LocationData("Hollow Bastion",   265_4173, "Chest",  True),
    "Hollow Bastion High Tower 1st Gravity Chest":                                      KH1LocationData("Hollow Bastion",   265_4174, "Chest",  True),
    "Hollow Bastion High Tower Above Sliding Blocks Chest":                             KH1LocationData("Hollow Bastion",   265_4211, "Chest",  True),
    "Hollow Bastion Library Top of Bookshelf Chest":                                    KH1LocationData("Hollow Bastion",   265_4213, "Chest",  True),
    "Hollow Bastion Library 1st Floor Turn the Carousel Chest":                         KH1LocationData("Hollow Bastion",   265_4214, "Static", True),
    "Hollow Bastion Library Top of Bookshelf Turn the Carousel Chest":                  KH1LocationData("Hollow Bastion",   265_4251, "Static", True),
    "Hollow Bastion Library 2nd Floor Turn the Carousel 1st Chest":                     KH1LocationData("Hollow Bastion",   265_4252, "Static", True),
    "Hollow Bastion Library 2nd Floor Turn the Carousel 2nd Chest":                     KH1LocationData("Hollow Bastion",   265_4253, "Static", True),
    "Hollow Bastion Lift Stop Library Node After High Tower Switch Gravity Chest":      KH1LocationData("Hollow Bastion",   265_4254, "Chest",  True),
    "Hollow Bastion Lift Stop Library Node Gravity Chest":                              KH1LocationData("Hollow Bastion",   265_4291, "Chest",  True),
    "Hollow Bastion Lift Stop Under High Tower Sliding Blocks Chest":                   KH1LocationData("Hollow Bastion",   265_4292, "Chest",  True),
    "Hollow Bastion Lift Stop Outside Library Gravity Chest":                           KH1LocationData("Hollow Bastion",   265_4293, "Chest",  True),
    "Hollow Bastion Lift Stop Heartless Sigil Door Gravity Chest":                      KH1LocationData("Hollow Bastion",   265_4294, "Chest",  True),
    "Hollow Bastion Base Level Bubble Under the Wall Platform Chest":                   KH1LocationData("Hollow Bastion",   265_4331, "Chest"),
    "Hollow Bastion Base Level Platform Near Entrance Chest":                           KH1LocationData("Hollow Bastion",   265_4332, "Chest"),
    "Hollow Bastion Base Level Near Crystal Switch Chest":                              KH1LocationData("Hollow Bastion",   265_4333, "Chest"),
    "Hollow Bastion Waterway Near Save Chest":                                          KH1LocationData("Hollow Bastion",   265_4334, "Chest"),
    "Hollow Bastion Waterway Blizzard on Bubble Chest":                                 KH1LocationData("Hollow Bastion",   265_4371, "Chest"),
    "Hollow Bastion Waterway Unlock Passage from Base Level Chest":                     KH1LocationData("Hollow Bastion",   265_4372, "Chest"),
    "Hollow Bastion Dungeon By Candles Chest":                                          KH1LocationData("Hollow Bastion",   265_4373, "Chest"),
    "Hollow Bastion Dungeon Corner Chest":                                              KH1LocationData("Hollow Bastion",   265_4374, "Chest"),
    "Hollow Bastion Grand Hall Steps Right Side Chest":                                 KH1LocationData("Hollow Bastion",   265_4454, "Chest",  True),
    "Hollow Bastion Grand Hall Oblivion Chest":                                         KH1LocationData("Hollow Bastion",   265_4491, "Chest",  True),
    "Hollow Bastion Grand Hall Left of Gate Chest":                                     KH1LocationData("Hollow Bastion",   265_4492, "Chest",  True),
    #"Hollow Bastion Entrance Hall Push the Statue Chest":                              KH1LocationData("Hollow Bastion",   265_4493, "Static"), --handled later
    "Hollow Bastion Entrance Hall Left of Emblem Door Chest":                           KH1LocationData("Hollow Bastion",   265_4212, "Chest",  True),
    "Hollow Bastion Rising Falls White Trinity Chest":                                  KH1LocationData("Hollow Bastion",   265_4494, "Chest",  True),
    "End of the World Final Dimension 1st Chest":                                       KH1LocationData("End of the World", 265_4531, "Chest",  True),
    "End of the World Final Dimension 2nd Chest":                                       KH1LocationData("End of the World", 265_4532, "Chest",  True),
    "End of the World Final Dimension 3rd Chest":                                       KH1LocationData("End of the World", 265_4533, "Chest",  True),
    "End of the World Final Dimension 4th Chest":                                       KH1LocationData("End of the World", 265_4534, "Chest",  True),
    "End of the World Final Dimension 5th Chest":                                       KH1LocationData("End of the World", 265_4571, "Chest",  True),
    "End of the World Final Dimension 6th Chest":                                       KH1LocationData("End of the World", 265_4572, "Chest",  True),
    "End of the World Final Dimension 10th Chest":                                      KH1LocationData("End of the World", 265_4573, "Chest",  True),
    "End of the World Final Dimension 9th Chest":                                       KH1LocationData("End of the World", 265_4574, "Chest",  True),
    "End of the World Final Dimension 8th Chest":                                       KH1LocationData("End of the World", 265_4611, "Chest",  True),
    "End of the World Final Dimension 7th Chest":                                       KH1LocationData("End of the World", 265_4612, "Chest",  True),
    "End of the World Giant Crevasse 3rd Chest":                                        KH1LocationData("End of the World", 265_4613, "Chest",  True),
    "End of the World Giant Crevasse 5th Chest":                                        KH1LocationData("End of the World", 265_4614, "Chest",  True),
    "End of the World Giant Crevasse 1st Chest":                                        KH1LocationData("End of the World", 265_4651, "Chest",  True),
    "End of the World Giant Crevasse 4th Chest":                                        KH1LocationData("End of the World", 265_4652, "Chest",  True),
    "End of the World Giant Crevasse 2nd Chest":                                        KH1LocationData("End of the World", 265_4653, "Chest",  True),
    "End of the World World Terminus Traverse Town Chest":                              KH1LocationData("End of the World", 265_4654, "Chest",  True),
    "End of the World World Terminus Wonderland Chest":                                 KH1LocationData("End of the World", 265_4691, "Chest",  True),
    "End of the World World Terminus Olympus Coliseum Chest":                           KH1LocationData("End of the World", 265_4692, "Chest",  True),
    "End of the World World Terminus Deep Jungle Chest":                                KH1LocationData("End of the World", 265_4693, "Chest",  True),
    "End of the World World Terminus Agrabah Chest":                                    KH1LocationData("End of the World", 265_4694, "Chest",  True),
    "End of the World World Terminus Atlantica Chest":                                  KH1LocationData("End of the World", 265_4731, "Static", True),
    "End of the World World Terminus Halloween Town Chest":                             KH1LocationData("End of the World", 265_4732, "Chest",  True),
    "End of the World World Terminus Neverland Chest":                                  KH1LocationData("End of the World", 265_4733, "Chest",  True),
    "End of the World World Terminus 100 Acre Wood Chest":                              KH1LocationData("End of the World", 265_4734, "Chest",  True),
    "End of the World World Terminus Hollow Bastion Chest":                             KH1LocationData("End of the World", 265_4771, "Chest",  True),
    "End of the World Final Rest Chest":                                                KH1LocationData("End of the World", 265_4772, "Chest",  True),
    "Monstro Chamber 6 White Trinity Chest":                                            KH1LocationData("Monstro",          265_5092, "Chest",  True),
    #"Awakening Chest":                                                                 KH1LocationData("Awakening",        265_5093, "Chest"), missable
   
    "Traverse Town Defeat Guard Armor Dodge Roll Event":                                KH1LocationData("Traverse Town",    265_6011, "Reward"),
    "Traverse Town Defeat Guard Armor Fire Event":                                      KH1LocationData("Traverse Town",    265_6012, "Static"),
    "Traverse Town Defeat Guard Armor Blue Trinity Event":                              KH1LocationData("Traverse Town",    265_6013, "Static"),
    "Traverse Town Leon Secret Waterway Earthshine Event":                              KH1LocationData("Traverse Town",    265_6014, "Reward"),
    "Traverse Town Kairi Secret Waterway Oathkeeper Event":                             KH1LocationData("Traverse Town",    265_6015, "Reward", True),
    "Traverse Town Defeat Guard Armor Brave Warrior Event":                             KH1LocationData("Traverse Town",    265_6016, "Reward"),
    "Deep Jungle Defeat Sabor White Fang Event":                                        KH1LocationData("Deep Jungle",      265_6021, "Reward", True),
    "Deep Jungle Defeat Clayton Cure Event":                                            KH1LocationData("Deep Jungle",      265_6022, "Static", True),
    "Deep Jungle Seal Keyhole Jungle King Event":                                       KH1LocationData("Deep Jungle",      265_6023, "Reward", True),
    "Deep Jungle Seal Keyhole Red Trinity Event":                                       KH1LocationData("Deep Jungle",      265_6024, "Static", True),
    "Olympus Coliseum Clear Phil's Training Thunder Event":                             KH1LocationData("Olympus Coliseum", 265_6031, "Static"),
    "Olympus Coliseum Defeat Cerberus Inferno Band Event":                              KH1LocationData("Olympus Coliseum", 265_6033, "Reward", True),
    "Wonderland Defeat Trickmaster Blizzard Event":                                     KH1LocationData("Wonderland",       265_6041, "Static", True),
    "Wonderland Defeat Trickmaster Ifrit's Horn Event":                                 KH1LocationData("Wonderland",       265_6042, "Reward", True),
    "Agrabah Defeat Pot Centipede Ray of Light Event":                                  KH1LocationData("Agrabah",          265_6051, "Reward", True),
    "Agrabah Defeat Jafar Blizzard Event":                                              KH1LocationData("Agrabah",          265_6052, "Static", True),
    "Agrabah Defeat Jafar Genie Fire Event":                                            KH1LocationData("Agrabah",          265_6053, "Static", True),
    "Agrabah Seal Keyhole Genie Event":                                                 KH1LocationData("Agrabah",          265_6054, "Static", True),
    "Agrabah Seal Keyhole Three Wishes Event":                                          KH1LocationData("Agrabah",          265_6055, "Reward", True),
    "Agrabah Seal Keyhole Green Trinity Event":                                         KH1LocationData("Agrabah",          265_6056, "Static", True),
    "Monstro Defeat Parasite Cage I Goofy Cheer Event":                                 KH1LocationData("Monstro",          265_6061, "Reward", True),
    "Monstro Defeat Parasite Cage II Stop Event":                                       KH1LocationData("Monstro",          265_6062, "Static", True),
    "Atlantica Defeat Ursula I Mermaid Kick Event":                                     KH1LocationData("Atlantica",        265_6071, "Reward", True),
    "Atlantica Defeat Ursula II Thunder Event":                                         KH1LocationData("Atlantica",        265_6072, "Static", True),
    "Atlantica Seal Keyhole Crabclaw Event":                                            KH1LocationData("Atlantica",        265_6073, "Reward", True),
    "Halloween Town Defeat Oogie Boogie Holy Circlet Event":                            KH1LocationData("Halloween Town",   265_6081, "Reward", True),
    "Halloween Town Defeat Oogie's Manor Gravity Event":                                KH1LocationData("Halloween Town",   265_6082, "Static", True),
    "Halloween Town Seal Keyhole Pumpkinhead Event":                                    KH1LocationData("Halloween Town",   265_6083, "Reward", True),
    "Neverland Defeat Anti Sora Raven's Claw Event":                                    KH1LocationData("Neverland",        265_6091, "Reward", True),
    "Neverland Encounter Hook Cure Event":                                              KH1LocationData("Neverland",        265_6092, "Static", True),
    "Neverland Seal Keyhole Fairy Harp Event":                                          KH1LocationData("Neverland",        265_6093, "Reward", True),
    "Neverland Seal Keyhole Tinker Bell Event":                                         KH1LocationData("Neverland",        265_6094, "Static", True),
    "Neverland Seal Keyhole Glide Event":                                               KH1LocationData("Neverland",        265_6095, "Reward", True),
    "Neverland Defeat Phantom Stop Event":                                              KH1LocationData("Neverland",        265_6096, "Static", True),
    "Neverland Defeat Captain Hook Ars Arcanum Event":                                  KH1LocationData("Neverland",        265_6097, "Reward", True),
    "Hollow Bastion Defeat Riku I White Trinity Event":                                 KH1LocationData("Hollow Bastion",   265_6101, "Static", True),
    "Hollow Bastion Defeat Maleficent Donald Cheer Event":                              KH1LocationData("Hollow Bastion",   265_6102, "Reward", True),
    "Hollow Bastion Defeat Dragon Maleficent Fireglow Event":                           KH1LocationData("Hollow Bastion",   265_6103, "Reward", True),
    "Hollow Bastion Defeat Riku II Ragnarok Event":                                     KH1LocationData("Hollow Bastion",   265_6104, "Reward", True),
    "Hollow Bastion Defeat Behemoth Omega Arts Event":                                  KH1LocationData("Hollow Bastion",   265_6105, "Reward", True),
    "Hollow Bastion Speak to Princesses Fire Event":                                    KH1LocationData("Hollow Bastion",   265_6106, "Static", True),
    "End of the World Defeat Chernabog Superglide Event":                               KH1LocationData("End of the World", 265_6111, "Reward", True),
    "Neverland Seal Keyhole Navi-G Piece Event":                                        KH1LocationData("Neverland",        265_6112, "Static", True),
    "Traverse Town Secret Waterway Navi Gummi Event":                                   KH1LocationData("Traverse Town",    265_6113, "Static", True),
    
    "Traverse Town Mail Postcard 01 Event":                                             KH1LocationData("Traverse Town",    265_6120, "Reward"),
    "Traverse Town Mail Postcard 02 Event":                                             KH1LocationData("Traverse Town",    265_6121, "Reward"),
    "Traverse Town Mail Postcard 03 Event":                                             KH1LocationData("Traverse Town",    265_6122, "Reward"),
    "Traverse Town Mail Postcard 04 Event":                                             KH1LocationData("Traverse Town",    265_6123, "Reward"),
    "Traverse Town Mail Postcard 05 Event":                                             KH1LocationData("Traverse Town",    265_6124, "Reward"),
    "Traverse Town Mail Postcard 06 Event":                                             KH1LocationData("Traverse Town",    265_6125, "Reward"),
    "Traverse Town Mail Postcard 07 Event":                                             KH1LocationData("Traverse Town",    265_6126, "Reward"),
    "Traverse Town Mail Postcard 08 Event":                                             KH1LocationData("Traverse Town",    265_6127, "Reward"),
    "Traverse Town Mail Postcard 09 Event":                                             KH1LocationData("Traverse Town",    265_6128, "Reward"),
    "Traverse Town Mail Postcard 10 Event":                                             KH1LocationData("Traverse Town",    265_6129, "Reward"),
    
    "Traverse Town Defeat Opposite Armor Aero Event":                                   KH1LocationData("Traverse Town",    265_6131, "Static", True),
    "Traverse Town Defeat Opposite Armor Navi-G Piece Event":                           KH1LocationData("Traverse Town",    265_6132, "Static", True),
    
    "Atlantica Undersea Gorge Blizzard Clam":                                           KH1LocationData("Atlantica",        265_6201, "Static"),
    "Atlantica Undersea Gorge Ocean Floor Clam":                                        KH1LocationData("Atlantica",        265_6202, "Static"),
    "Atlantica Undersea Valley Higher Cave Clam":                                       KH1LocationData("Atlantica",        265_6203, "Static"),
    "Atlantica Undersea Valley Lower Cave Clam":                                        KH1LocationData("Atlantica",        265_6204, "Static"),
    "Atlantica Undersea Valley Fire Clam":                                              KH1LocationData("Atlantica",        265_6205, "Static"),
    "Atlantica Undersea Valley Wall Clam":                                              KH1LocationData("Atlantica",        265_6206, "Static"),
    "Atlantica Undersea Valley Pillar Clam":                                            KH1LocationData("Atlantica",        265_6207, "Static"),
    "Atlantica Undersea Valley Ocean Floor Clam":                                       KH1LocationData("Atlantica",        265_6208, "Static"),
    "Atlantica Triton's Palace Thunder Clam":                                           KH1LocationData("Atlantica",        265_6209, "Static"),
    "Atlantica Triton's Palace Wall Right Clam":                                        KH1LocationData("Atlantica",        265_6210, "Static"),
    "Atlantica Triton's Palace Near Path Clam":                                         KH1LocationData("Atlantica",        265_6211, "Static"),
    "Atlantica Triton's Palace Wall Left Clam":                                         KH1LocationData("Atlantica",        265_6212, "Static"),
    "Atlantica Cavern Nook Clam":                                                       KH1LocationData("Atlantica",        265_6213, "Static"),
    "Atlantica Below Deck Clam":                                                        KH1LocationData("Atlantica",        265_6214, "Static"),
    "Atlantica Undersea Garden Clam":                                                   KH1LocationData("Atlantica",        265_6215, "Static"),
    "Atlantica Undersea Cave Clam":                                                     KH1LocationData("Atlantica",        265_6216, "Static"),
    
    #"Traverse Town Magician's Study Turn in Naturespark":                              KH1LocationData("Traverse Town",    265_6300, "Static"),
    #"Traverse Town Magician's Study Turn in Watergleam":                               KH1LocationData("Traverse Town",    265_6301, "Static"),
    #"Traverse Town Magician's Study Turn in Fireglow":                                 KH1LocationData("Traverse Town",    265_6302, "Static"),
    #"Traverse Town Magician's Study Turn in all Summon Gems":                          KH1LocationData("Traverse Town",    265_6303, "Reward"),
    "Traverse Town Geppetto's House Geppetto Reward 1":                                 KH1LocationData("Traverse Town",    265_6304, "Static", True),
    "Traverse Town Geppetto's House Geppetto Reward 4":                                 KH1LocationData("Traverse Town",    265_6305, "Static", True),
    "Traverse Town Geppetto's House Geppetto Reward 3":                                 KH1LocationData("Traverse Town",    265_6306, "Static", True),
    "Traverse Town Geppetto's House Geppetto Reward 5":                                 KH1LocationData("Traverse Town",    265_6307, "Static", True),
    "Traverse Town Geppetto's House Geppetto Reward 2":                                 KH1LocationData("Traverse Town",    265_6308, "Static", True),
    "Traverse Town Geppetto's House Geppetto All Summons Reward":                       KH1LocationData("Traverse Town",    265_6309, "Static", True),
    "Traverse Town Geppetto's House Talk to Pinocchio":                                 KH1LocationData("Traverse Town",    265_6310, "Static", True),
    "Traverse Town Magician's Study Obtained All Arts Items":                           KH1LocationData("Traverse Town",    265_6311, "Reward"),
    "Traverse Town Magician's Study Obtained All LV1 Magic":                            KH1LocationData("Traverse Town",    265_6312, "Reward"),
    "Traverse Town Magician's Study Obtained All LV3 Magic":                            KH1LocationData("Traverse Town",    265_6313, "Reward"),
    "Traverse Town Piano Room Return 10 Puppies":                                       KH1LocationData("Traverse Town",    265_6314, "Static"),
    "Traverse Town Piano Room Return 20 Puppies":                                       KH1LocationData("Traverse Town",    265_6315, "Static"),
    "Traverse Town Piano Room Return 30 Puppies":                                       KH1LocationData("Traverse Town",    265_6316, "Static"),
    "Traverse Town Piano Room Return 40 Puppies":                                       KH1LocationData("Traverse Town",    265_6317, "Reward"),
    "Traverse Town Piano Room Return 50 Puppies Reward 1":                              KH1LocationData("Traverse Town",    265_6318, "Static"),
    "Traverse Town Piano Room Return 50 Puppies Reward 2":                              KH1LocationData("Traverse Town",    265_6319, "Reward"),
    "Traverse Town Piano Room Return 60 Puppies":                                       KH1LocationData("Traverse Town",    265_6320, "Reward"),
    "Traverse Town Piano Room Return 70 Puppies":                                       KH1LocationData("Traverse Town",    265_6321, "Reward"),
    "Traverse Town Piano Room Return 80 Puppies":                                       KH1LocationData("Traverse Town",    265_6322, "Static"),
    "Traverse Town Piano Room Return 90 Puppies":                                       KH1LocationData("Traverse Town",    265_6324, "Reward"),
    "Traverse Town Piano Room Return 99 Puppies Reward 1":                              KH1LocationData("Traverse Town",    265_6326, "Static"),
    "Traverse Town Piano Room Return 99 Puppies Reward 2":                              KH1LocationData("Traverse Town",    265_6327, "Static"),
    "Olympus Coliseum Cloud Sonic Blade Event":                                         KH1LocationData("Olympus Coliseum", 265_6032, "Reward", True), #Had to change the way we send this check, not changing location_id
    "Olympus Coliseum Defeat Sephiroth One-Winged Angel Event":                         KH1LocationData("Olympus Coliseum", 265_6328, "Reward", True),
    "Olympus Coliseum Defeat Ice Titan Diamond Dust Event":                             KH1LocationData("Olympus Coliseum", 265_6329, "Reward", True),
    "Olympus Coliseum Gates Purple Jar After Defeating Hades":                          KH1LocationData("Olympus Coliseum", 265_6330, "Static", True),
    "Halloween Town Guillotine Square Ring Jack's Doorbell 3 Times":                    KH1LocationData("Halloween Town",   265_6331, "Static"),
    "Neverland Clock Tower 01:00 Door":                                                 KH1LocationData("Neverland",        265_6332, "Static", True),
    "Neverland Clock Tower 02:00 Door":                                                 KH1LocationData("Neverland",        265_6333, "Static", True),
    "Neverland Clock Tower 03:00 Door":                                                 KH1LocationData("Neverland",        265_6334, "Static", True),
    "Neverland Clock Tower 04:00 Door":                                                 KH1LocationData("Neverland",        265_6335, "Static", True),
    "Neverland Clock Tower 05:00 Door":                                                 KH1LocationData("Neverland",        265_6336, "Static", True),
    "Neverland Clock Tower 06:00 Door":                                                 KH1LocationData("Neverland",        265_6337, "Static", True),
    "Neverland Clock Tower 07:00 Door":                                                 KH1LocationData("Neverland",        265_6338, "Static", True),
    "Neverland Clock Tower 08:00 Door":                                                 KH1LocationData("Neverland",        265_6339, "Static", True),
    "Neverland Clock Tower 09:00 Door":                                                 KH1LocationData("Neverland",        265_6340, "Static", True),
    "Neverland Clock Tower 10:00 Door":                                                 KH1LocationData("Neverland",        265_6341, "Static", True),
    "Neverland Clock Tower 11:00 Door":                                                 KH1LocationData("Neverland",        265_6342, "Static", True),
    "Neverland Clock Tower 12:00 Door":                                                 KH1LocationData("Neverland",        265_6343, "Static", True),
    "Neverland Hold Aero Chest":                                                        KH1LocationData("Neverland",        265_6344, "Static"),
    "100 Acre Wood Bouncing Spot Turn in Rare Nut 1":                                   KH1LocationData("100 Acre Wood",    265_6345, "Static"),
    "100 Acre Wood Bouncing Spot Turn in Rare Nut 2":                                   KH1LocationData("100 Acre Wood",    265_6346, "Static"),
    "100 Acre Wood Bouncing Spot Turn in Rare Nut 3":                                   KH1LocationData("100 Acre Wood",    265_6347, "Static"),
    "100 Acre Wood Bouncing Spot Turn in Rare Nut 4":                                   KH1LocationData("100 Acre Wood",    265_6348, "Static"),
    "100 Acre Wood Bouncing Spot Turn in Rare Nut 5":                                   KH1LocationData("100 Acre Wood",    265_6349, "Static"),
    "100 Acre Wood Pooh's House Owl Cheer":                                             KH1LocationData("100 Acre Wood",    265_6350, "Reward"),
    "100 Acre Wood Convert Torn Page 1":                                                KH1LocationData("100 Acre Wood",    265_6351, "Reward"),
    "100 Acre Wood Convert Torn Page 2":                                                KH1LocationData("100 Acre Wood",    265_6352, "Reward"),
    "100 Acre Wood Convert Torn Page 3":                                                KH1LocationData("100 Acre Wood",    265_6353, "Static"),
    "100 Acre Wood Convert Torn Page 4":                                                KH1LocationData("100 Acre Wood",    265_6354, "Reward"),
    "100 Acre Wood Convert Torn Page 5":                                                KH1LocationData("100 Acre Wood",    265_6355, "Reward"),
    "100 Acre Wood Pooh's House Start Fire":                                            KH1LocationData("100 Acre Wood",    265_6356, "Static"),
    "100 Acre Wood Pooh's Room Cabinet":                                                KH1LocationData("100 Acre Wood",    265_6357, "Static"),
    "100 Acre Wood Pooh's Room Chimney":                                                KH1LocationData("100 Acre Wood",    265_6358, "Static"),
    "100 Acre Wood Bouncing Spot Break Log":                                            KH1LocationData("100 Acre Wood",    265_6359, "Static"),
    "100 Acre Wood Bouncing Spot Fall Through Top of Tree Next to Pooh":                KH1LocationData("100 Acre Wood",    265_6360, "Static"),
    "Deep Jungle Camp Hi-Potion Experiment":                                            KH1LocationData("Deep Jungle",      265_6361, "Static"),
    "Deep Jungle Camp Ether Experiment":                                                KH1LocationData("Deep Jungle",      265_6362, "Static"),
    "Deep Jungle Camp Replication Experiment":                                          KH1LocationData("Deep Jungle",      265_6363, "Static"),
    "Deep Jungle Cliff Save Gorillas":                                                  KH1LocationData("Deep Jungle",      265_6364, "Static"),
    "Deep Jungle Tree House Save Gorillas":                                             KH1LocationData("Deep Jungle",      265_6365, "Static"),
    "Deep Jungle Camp Save Gorillas":                                                   KH1LocationData("Deep Jungle",      265_6366, "Static"),
    "Deep Jungle Bamboo Thicket Save Gorillas":                                         KH1LocationData("Deep Jungle",      265_6367, "Static"),
    "Deep Jungle Climbing Trees Save Gorillas":                                         KH1LocationData("Deep Jungle",      265_6368, "Static"),
    "Olympus Coliseum Olympia Chest":                                                   KH1LocationData("Olympus Coliseum", 265_6369, "Reward", True),
    "Deep Jungle Jungle Slider 10 Fruits":                                              KH1LocationData("Deep Jungle",      265_6370, "Reward", True),
    "Deep Jungle Jungle Slider 20 Fruits":                                              KH1LocationData("Deep Jungle",      265_6371, "Reward", True),
    "Deep Jungle Jungle Slider 30 Fruits":                                              KH1LocationData("Deep Jungle",      265_6372, "Reward", True),
    "Deep Jungle Jungle Slider 40 Fruits":                                              KH1LocationData("Deep Jungle",      265_6373, "Reward", True),
    "Deep Jungle Jungle Slider 50 Fruits":                                              KH1LocationData("Deep Jungle",      265_6374, "Reward", True),
   #"Traverse Town 1st District Speak with Cid Event":                                  KH1LocationData("Traverse Town",    265_6375, "Static"),
    "Wonderland Bizarre Room Read Book":                                                KH1LocationData("Wonderland",       265_6376, "Static"),
    "Olympus Coliseum Coliseum Gates Green Trinity":                                    KH1LocationData("Olympus Coliseum", 265_6377, "Static"),
    "Agrabah Defeat Kurt Zisa Zantetsuken Event":                                       KH1LocationData("Agrabah",          265_6378, "Reward", True),
    "Hollow Bastion Defeat Unknown EXP Necklace Event":                                 KH1LocationData("Hollow Bastion",   265_6379, "Reward", True),
    "Olympus Coliseum Coliseum Gates Hero's License Event":                             KH1LocationData("Olympus Coliseum", 265_6380, "Static", True),
    "Atlantica Sunken Ship Crystal Trident Event":                                      KH1LocationData("Atlantica",        265_6381, "Static"),
    "Halloween Town Graveyard Forget-Me-Not Event":                                     KH1LocationData("Halloween Town",   265_6382, "Static"),
    "Deep Jungle Tent Protect-G Event":                                                 KH1LocationData("Deep Jungle",      265_6383, "Static"),
    "Deep Jungle Cavern of Hearts Navi-G Piece Event":                                  KH1LocationData("Deep Jungle",      265_6384, "Static", True),
    "Wonderland Bizarre Room Navi-G Piece Event":                                       KH1LocationData("Wonderland",       265_6385, "Static", True),
    "Olympus Coliseum Coliseum Gates Entry Pass Event":                                 KH1LocationData("Olympus Coliseum", 265_6386, "Static"),
    
    "Traverse Town Synth 15 Items":                                                      KH1LocationData("Traverse Town",   265_6400, "Reward"),
    "Traverse Town Synth Item 01":                                                       KH1LocationData("Traverse Town",   265_6401, "Synth"),
    "Traverse Town Synth Item 02":                                                       KH1LocationData("Traverse Town",   265_6402, "Synth"),
    "Traverse Town Synth Item 03":                                                       KH1LocationData("Traverse Town",   265_6403, "Synth"),
    "Traverse Town Synth Item 04":                                                       KH1LocationData("Traverse Town",   265_6404, "Synth"),
    "Traverse Town Synth Item 05":                                                       KH1LocationData("Traverse Town",   265_6405, "Synth"),
    "Traverse Town Synth Item 06":                                                       KH1LocationData("Traverse Town",   265_6406, "Synth"),
    "Traverse Town Synth Item 06":                                                       KH1LocationData("Traverse Town",   265_6406, "Synth"),
    "Traverse Town Synth Item 07":                                                       KH1LocationData("Traverse Town",   265_6407, "Synth"),
    "Traverse Town Synth Item 08":                                                       KH1LocationData("Traverse Town",   265_6408, "Synth"),
    "Traverse Town Synth Item 09":                                                       KH1LocationData("Traverse Town",   265_6409, "Synth"),
    "Traverse Town Synth Item 10":                                                       KH1LocationData("Traverse Town",   265_6410, "Synth"),
    "Traverse Town Synth Item 11":                                                       KH1LocationData("Traverse Town",   265_6411, "Synth"),
    "Traverse Town Synth Item 12":                                                       KH1LocationData("Traverse Town",   265_6412, "Synth"),
    "Traverse Town Synth Item 13":                                                       KH1LocationData("Traverse Town",   265_6413, "Synth"),
    "Traverse Town Synth Item 14":                                                       KH1LocationData("Traverse Town",   265_6414, "Synth"),
    "Traverse Town Synth Item 15":                                                       KH1LocationData("Traverse Town",   265_6415, "Synth"),
    "Traverse Town Synth Item 16":                                                       KH1LocationData("Traverse Town",   265_6416, "Synth"),
    "Traverse Town Synth Item 17":                                                       KH1LocationData("Traverse Town",   265_6417, "Synth"),
    "Traverse Town Synth Item 18":                                                       KH1LocationData("Traverse Town",   265_6418, "Synth"),
    "Traverse Town Synth Item 19":                                                       KH1LocationData("Traverse Town",   265_6419, "Synth"),
    "Traverse Town Synth Item 20":                                                       KH1LocationData("Traverse Town",   265_6420, "Synth"),
    "Traverse Town Synth Item 21":                                                       KH1LocationData("Traverse Town",   265_6421, "Synth"),
    "Traverse Town Synth Item 22":                                                       KH1LocationData("Traverse Town",   265_6422, "Synth"),
    "Traverse Town Synth Item 23":                                                       KH1LocationData("Traverse Town",   265_6423, "Synth"),
    "Traverse Town Synth Item 24":                                                       KH1LocationData("Traverse Town",   265_6424, "Synth"),
    "Traverse Town Synth Item 25":                                                       KH1LocationData("Traverse Town",   265_6425, "Synth"),
    "Traverse Town Synth Item 26":                                                       KH1LocationData("Traverse Town",   265_6426, "Synth"),
    "Traverse Town Synth Item 27":                                                       KH1LocationData("Traverse Town",   265_6427, "Synth"),
    "Traverse Town Synth Item 28":                                                       KH1LocationData("Traverse Town",   265_6428, "Synth"),
    "Traverse Town Synth Item 29":                                                       KH1LocationData("Traverse Town",   265_6429, "Synth"),
    "Traverse Town Synth Item 30":                                                       KH1LocationData("Traverse Town",   265_6430, "Synth"),
    "Traverse Town Synth Item 31":                                                       KH1LocationData("Traverse Town",   265_6431, "Synth"),
    "Traverse Town Synth Item 32":                                                       KH1LocationData("Traverse Town",   265_6432, "Synth"),
    "Traverse Town Synth Item 33":                                                       KH1LocationData("Traverse Town",   265_6433, "Synth"),
    
    "Traverse Town Item Shop Postcard":                                                 KH1LocationData("Traverse Town",    265_6500, "Static"),
    "Traverse Town 1st District Safe Postcard":                                         KH1LocationData("Traverse Town",    265_6501, "Static"),
    "Traverse Town Gizmo Shop Postcard 1":                                              KH1LocationData("Traverse Town",    265_6502, "Static"),
    "Traverse Town Gizmo Shop Postcard 2":                                              KH1LocationData("Traverse Town",    265_6503, "Static"),
    "Traverse Town Item Workshop Postcard":                                             KH1LocationData("Traverse Town",    265_6504, "Static"),
    "Traverse Town 3rd District Balcony Postcard":                                      KH1LocationData("Traverse Town",    265_6505, "Static"),
    "Traverse Town Geppetto's House Postcard":                                          KH1LocationData("Traverse Town",    265_6506, "Static", True),
    "Halloween Town Lab Torn Page":                                                     KH1LocationData("Halloween Town",   265_6508, "Static"),
    "Hollow Bastion Entrance Hall Emblem Piece (Flame)":                                KH1LocationData("Hollow Bastion",   265_6516, "Static", True),
    "Hollow Bastion Entrance Hall Emblem Piece (Chest)":                                KH1LocationData("Hollow Bastion",   265_6517, "Static", True),
    "Hollow Bastion Entrance Hall Emblem Piece (Statue)":                               KH1LocationData("Hollow Bastion",   265_6518, "Static", True),
    "Hollow Bastion Entrance Hall Emblem Piece (Fountain)":                             KH1LocationData("Hollow Bastion",   265_6519, "Static", True),
    "Traverse Town 1st District Leon Gift":                                             KH1LocationData("Traverse Town",    265_6520, "Reward"),
    #"Traverse Town 1st District Aerith Gift":                                          KH1LocationData("Traverse Town",    265_6521, "Reward"),
    "Hollow Bastion Library Speak to Belle Divine Rose":                                KH1LocationData("Hollow Bastion",   265_6522, "Reward", True),
    "Hollow Bastion Library Speak to Aerith Cure":                                      KH1LocationData("Hollow Bastion",   265_6523, "Static", True),
    
    "Traverse Town 1st District Blue Trinity by Exit Door":                             KH1LocationData("Traverse Town",    265_6600, "Prize"),
    "Traverse Town 3rd District Blue Trinity":                                          KH1LocationData("Traverse Town",    265_6601, "Prize"),
    "Traverse Town Magician's Study Blue Trinity":                                      KH1LocationData("Traverse Town",    265_6602, "Prize"),
    "Wonderland Lotus Forest Blue Trinity in Alcove":                                   KH1LocationData("Wonderland",       265_6603, "Prize"),
    "Wonderland Lotus Forest Blue Trinity by Moving Boulder":                           KH1LocationData("Wonderland",       265_6604, "Prize"),
    "Agrabah Bazaar Blue Trinity":                                                      KH1LocationData("Agrabah",          265_6605, "Prize"),
    "Monstro Mouth Blue Trinity":                                                       KH1LocationData("Monstro",          265_6606, "Prize",  True),
    "Monstro Chamber 5 Blue Trinity":                                                   KH1LocationData("Monstro",          265_6607, "Prize"),
    "Hollow Bastion Great Crest Blue Trinity":                                          KH1LocationData("Hollow Bastion",   265_6608, "Prize",  True),
    "Hollow Bastion Dungeon Blue Trinity":                                              KH1LocationData("Hollow Bastion",   265_6609, "Prize",  True),
    "Deep Jungle Treetop Green Trinity":                                                KH1LocationData("Deep Jungle",      265_6610, "Prize"),
    "Agrabah Cave of Wonders Treasure Room Red Trinity":                                KH1LocationData("Agrabah",          265_6611, "Prize",  True),
    "Monstro Throat Blue Trinity":                                                      KH1LocationData("Monstro",          265_6612, "Prize",  True),
    "Wonderland Bizarre Room Examine Flower Pot":                                       KH1LocationData("Wonderland",       265_6613, "Prize"),
    "Wonderland Lotus Forest Red Flowers on the Main Path":                             KH1LocationData("Wonderland",       265_6614, "Prize"),
    "Wonderland Lotus Forest Yellow Flowers in Middle Clearing and Through Painting":   KH1LocationData("Wonderland",       265_6615, "Prize"),
    "Wonderland Lotus Forest Yellow Elixir Flower Through Painting":                    KH1LocationData("Wonderland",       265_6616, "Prize"),
    "Wonderland Lotus Forest Red Flower Raise Lily Pads":                               KH1LocationData("Wonderland",       265_6617, "Prize"),
    "Wonderland Tea Party Garden Left Cushioned Chair":                                 KH1LocationData("Wonderland",       265_6618, "Prize"),
    "Wonderland Tea Party Garden Left Pink Chair":                                      KH1LocationData("Wonderland",       265_6619, "Prize"),
    "Wonderland Tea Party Garden Right Yellow Chair":                                   KH1LocationData("Wonderland",       265_6620, "Prize"),
    "Wonderland Tea Party Garden Left Gray Chair":                                      KH1LocationData("Wonderland",       265_6621, "Prize"),
    "Wonderland Tea Party Garden Right Brown Chair":                                    KH1LocationData("Wonderland",       265_6622, "Prize"),
    "Hollow Bastion Lift Stop from Waterway Examine Node":                              KH1LocationData("Hollow Bastion",   265_6623, "Prize",  True),
    
    "Destiny Islands Seashore Capture Fish 1 (Day 2)":                                  KH1LocationData("Destiny Islands",  265_6700, "Static"),
    "Destiny Islands Seashore Capture Fish 2 (Day 2)":                                  KH1LocationData("Destiny Islands",  265_6701, "Static"),
    "Destiny Islands Seashore Capture Fish 3 (Day 2)":                                  KH1LocationData("Destiny Islands",  265_6702, "Static"),
    "Destiny Islands Seashore Gather Seagull Egg (Day 2)":                              KH1LocationData("Destiny Islands",  265_6703, "Static"),
    "Destiny Islands Seashore Log on Riku's Island (Day 1)":                            KH1LocationData("Destiny Islands",  265_6704, "Static"),
    "Destiny Islands Seashore Log under Bridge (Day 1)":                                KH1LocationData("Destiny Islands",  265_6705, "Static"),
    "Destiny Islands Seashore Gather Cloth (Day 1)":                                    KH1LocationData("Destiny Islands",  265_6706, "Static"),
    "Destiny Islands Seashore Gather Rope (Day 1)":                                     KH1LocationData("Destiny Islands",  265_6707, "Static"),
   #"Destiny Islands Seashore Deliver Kairi Items (Day 1)":                             KH1LocationData("Destiny Islands",  265_6710, "Static"),
    "Destiny Islands Secret Place Gather Mushroom (Day 2)":                             KH1LocationData("Destiny Islands",  265_6711, "Static"),
    "Destiny Islands Cove Gather Mushroom Near Zip Line (Day 2)":                       KH1LocationData("Destiny Islands",  265_6712, "Static"),
    "Destiny Islands Cove Gather Mushroom in Small Cave (Day 2)":                       KH1LocationData("Destiny Islands",  265_6713, "Static"),
    "Destiny Islands Cove Talk to Kairi (Day 2)":                                       KH1LocationData("Destiny Islands",  265_6714, "Static"),
    "Destiny Islands Gather Drinking Water (Day 2)":                                    KH1LocationData("Destiny Islands",  265_6715, "Static"),
   #"Destiny Islands Cove Deliver Kairi Items (Day 2)":                                 KH1LocationData("Destiny Islands",  265_6716, "Static"),
    
    "Donald Starting Accessory 1":                                                      KH1LocationData("Traverse Town",    265_6800, "Starting Accessory"),
    "Donald Starting Accessory 2":                                                      KH1LocationData("Traverse Town",    265_6801, "Starting Accessory"),
    "Goofy Starting Accessory 1":                                                       KH1LocationData("Traverse Town",    265_6802, "Starting Accessory"),
    "Goofy Starting Accessory 2":                                                       KH1LocationData("Traverse Town",    265_6803, "Starting Accessory"),
    "Tarzan Starting Accessory 1":                                                      KH1LocationData("Deep Jungle",      265_6804, "Starting Accessory"),
    "Aladdin Starting Accessory 1":                                                     KH1LocationData("Agrabah",          265_6805, "Starting Accessory"),
    "Aladdin Starting Accessory 2":                                                     KH1LocationData("Agrabah",          265_6806, "Starting Accessory"),
    "Ariel Starting Accessory 1":                                                       KH1LocationData("Atlantica",        265_6807, "Starting Accessory"),
    "Ariel Starting Accessory 2":                                                       KH1LocationData("Atlantica",        265_6808, "Starting Accessory"),
    "Ariel Starting Accessory 3":                                                       KH1LocationData("Atlantica",        265_6809, "Starting Accessory"),
    "Jack Starting Accessory 1":                                                        KH1LocationData("Halloween Town",   265_6810, "Starting Accessory"),
    "Jack Starting Accessory 2":                                                        KH1LocationData("Halloween Town",   265_6811, "Starting Accessory"),
    "Peter Pan Starting Accessory 1":                                                   KH1LocationData("Neverland",        265_6812, "Starting Accessory"),
    "Peter Pan Starting Accessory 2":                                                   KH1LocationData("Neverland",        265_6813, "Starting Accessory"),
    "Beast Starting Accessory 1":                                                       KH1LocationData("Hollow Bastion",   265_6814, "Starting Accessory"),
    
    "Agrabah Defeat Jafar Genie Ansem's Report 1":                                      KH1LocationData("Agrabah",          265_7018, "Static", True),
    "Hollow Bastion Speak with Aerith Ansem's Report 2":                                KH1LocationData("Hollow Bastion",   265_7017, "Static", True),
    "Atlantica Defeat Ursula II Ansem's Report 3":                                      KH1LocationData("Atlantica",        265_7016, "Static", True),
    "Hollow Bastion Speak with Aerith Ansem's Report 4":                                KH1LocationData("Hollow Bastion",   265_7015, "Static", True),
    "Hollow Bastion Defeat Maleficent Ansem's Report 5":                                KH1LocationData("Hollow Bastion",   265_7014, "Static", True),
    "Hollow Bastion Speak with Aerith Ansem's Report 6":                                KH1LocationData("Hollow Bastion",   265_7013, "Static", True),
    "Halloween Town Defeat Oogie Boogie Ansem's Report 7":                              KH1LocationData("Halloween Town",   265_7012, "Static", True),
    "Olympus Coliseum Defeat Hades Ansem's Report 8":                                   KH1LocationData("Olympus Coliseum", 265_7011, "Static", True),
    "Neverland Defeat Hook Ansem's Report 9":                                           KH1LocationData("Neverland",        265_7028, "Static", True),
    "Hollow Bastion Speak with Aerith Ansem's Report 10":                               KH1LocationData("Hollow Bastion",   265_7027, "Static", True),
    "Agrabah Defeat Kurt Zisa Ansem's Report 11":                                       KH1LocationData("Agrabah",          265_7026, "Static", True),
    "Olympus Coliseum Defeat Sephiroth Ansem's Report 12":                              KH1LocationData("Olympus Coliseum", 265_7025, "Static", True),
    "Hollow Bastion Defeat Unknown Ansem's Report 13":                                  KH1LocationData("Hollow Bastion",   265_7024, "Static", True),
   #"Level 001 (Slot 1)":                                                               KH1LocationData("Levels",           265_8001, "Level Slot 1"),
    "Level 002 (Slot 1)":                                                               KH1LocationData("Levels",           265_8002, "Level Slot 1"),
    "Level 003 (Slot 1)":                                                               KH1LocationData("Levels",           265_8003, "Level Slot 1"),
    "Level 004 (Slot 1)":                                                               KH1LocationData("Levels",           265_8004, "Level Slot 1"),
    "Level 005 (Slot 1)":                                                               KH1LocationData("Levels",           265_8005, "Level Slot 1"),
    "Level 006 (Slot 1)":                                                               KH1LocationData("Levels",           265_8006, "Level Slot 1"),
    "Level 007 (Slot 1)":                                                               KH1LocationData("Levels",           265_8007, "Level Slot 1"),
    "Level 008 (Slot 1)":                                                               KH1LocationData("Levels",           265_8008, "Level Slot 1"),
    "Level 009 (Slot 1)":                                                               KH1LocationData("Levels",           265_8009, "Level Slot 1"),
    "Level 010 (Slot 1)":                                                               KH1LocationData("Levels",           265_8010, "Level Slot 1"),
    "Level 011 (Slot 1)":                                                               KH1LocationData("Levels",           265_8011, "Level Slot 1"),
    "Level 012 (Slot 1)":                                                               KH1LocationData("Levels",           265_8012, "Level Slot 1"),
    "Level 013 (Slot 1)":                                                               KH1LocationData("Levels",           265_8013, "Level Slot 1"),
    "Level 014 (Slot 1)":                                                               KH1LocationData("Levels",           265_8014, "Level Slot 1"),
    "Level 015 (Slot 1)":                                                               KH1LocationData("Levels",           265_8015, "Level Slot 1"),
    "Level 016 (Slot 1)":                                                               KH1LocationData("Levels",           265_8016, "Level Slot 1"),
    "Level 017 (Slot 1)":                                                               KH1LocationData("Levels",           265_8017, "Level Slot 1"),
    "Level 018 (Slot 1)":                                                               KH1LocationData("Levels",           265_8018, "Level Slot 1"),
    "Level 019 (Slot 1)":                                                               KH1LocationData("Levels",           265_8019, "Level Slot 1"),
    "Level 020 (Slot 1)":                                                               KH1LocationData("Levels",           265_8020, "Level Slot 1"),
    "Level 021 (Slot 1)":                                                               KH1LocationData("Levels",           265_8021, "Level Slot 1"),
    "Level 022 (Slot 1)":                                                               KH1LocationData("Levels",           265_8022, "Level Slot 1"),
    "Level 023 (Slot 1)":                                                               KH1LocationData("Levels",           265_8023, "Level Slot 1"),
    "Level 024 (Slot 1)":                                                               KH1LocationData("Levels",           265_8024, "Level Slot 1"),
    "Level 025 (Slot 1)":                                                               KH1LocationData("Levels",           265_8025, "Level Slot 1"),
    "Level 026 (Slot 1)":                                                               KH1LocationData("Levels",           265_8026, "Level Slot 1"),
    "Level 027 (Slot 1)":                                                               KH1LocationData("Levels",           265_8027, "Level Slot 1"),
    "Level 028 (Slot 1)":                                                               KH1LocationData("Levels",           265_8028, "Level Slot 1"),
    "Level 029 (Slot 1)":                                                               KH1LocationData("Levels",           265_8029, "Level Slot 1"),
    "Level 030 (Slot 1)":                                                               KH1LocationData("Levels",           265_8030, "Level Slot 1"),
    "Level 031 (Slot 1)":                                                               KH1LocationData("Levels",           265_8031, "Level Slot 1"),
    "Level 032 (Slot 1)":                                                               KH1LocationData("Levels",           265_8032, "Level Slot 1"),
    "Level 033 (Slot 1)":                                                               KH1LocationData("Levels",           265_8033, "Level Slot 1"),
    "Level 034 (Slot 1)":                                                               KH1LocationData("Levels",           265_8034, "Level Slot 1"),
    "Level 035 (Slot 1)":                                                               KH1LocationData("Levels",           265_8035, "Level Slot 1"),
    "Level 036 (Slot 1)":                                                               KH1LocationData("Levels",           265_8036, "Level Slot 1"),
    "Level 037 (Slot 1)":                                                               KH1LocationData("Levels",           265_8037, "Level Slot 1"),
    "Level 038 (Slot 1)":                                                               KH1LocationData("Levels",           265_8038, "Level Slot 1"),
    "Level 039 (Slot 1)":                                                               KH1LocationData("Levels",           265_8039, "Level Slot 1"),
    "Level 040 (Slot 1)":                                                               KH1LocationData("Levels",           265_8040, "Level Slot 1"),
    "Level 041 (Slot 1)":                                                               KH1LocationData("Levels",           265_8041, "Level Slot 1"),
    "Level 042 (Slot 1)":                                                               KH1LocationData("Levels",           265_8042, "Level Slot 1"),
    "Level 043 (Slot 1)":                                                               KH1LocationData("Levels",           265_8043, "Level Slot 1"),
    "Level 044 (Slot 1)":                                                               KH1LocationData("Levels",           265_8044, "Level Slot 1"),
    "Level 045 (Slot 1)":                                                               KH1LocationData("Levels",           265_8045, "Level Slot 1"),
    "Level 046 (Slot 1)":                                                               KH1LocationData("Levels",           265_8046, "Level Slot 1"),
    "Level 047 (Slot 1)":                                                               KH1LocationData("Levels",           265_8047, "Level Slot 1"),
    "Level 048 (Slot 1)":                                                               KH1LocationData("Levels",           265_8048, "Level Slot 1"),
    "Level 049 (Slot 1)":                                                               KH1LocationData("Levels",           265_8049, "Level Slot 1"),
    "Level 050 (Slot 1)":                                                               KH1LocationData("Levels",           265_8050, "Level Slot 1"),
    "Level 051 (Slot 1)":                                                               KH1LocationData("Levels",           265_8051, "Level Slot 1"),
    "Level 052 (Slot 1)":                                                               KH1LocationData("Levels",           265_8052, "Level Slot 1"),
    "Level 053 (Slot 1)":                                                               KH1LocationData("Levels",           265_8053, "Level Slot 1"),
    "Level 054 (Slot 1)":                                                               KH1LocationData("Levels",           265_8054, "Level Slot 1"),
    "Level 055 (Slot 1)":                                                               KH1LocationData("Levels",           265_8055, "Level Slot 1"),
    "Level 056 (Slot 1)":                                                               KH1LocationData("Levels",           265_8056, "Level Slot 1"),
    "Level 057 (Slot 1)":                                                               KH1LocationData("Levels",           265_8057, "Level Slot 1"),
    "Level 058 (Slot 1)":                                                               KH1LocationData("Levels",           265_8058, "Level Slot 1"),
    "Level 059 (Slot 1)":                                                               KH1LocationData("Levels",           265_8059, "Level Slot 1"),
    "Level 060 (Slot 1)":                                                               KH1LocationData("Levels",           265_8060, "Level Slot 1"),
    "Level 061 (Slot 1)":                                                               KH1LocationData("Levels",           265_8061, "Level Slot 1"),
    "Level 062 (Slot 1)":                                                               KH1LocationData("Levels",           265_8062, "Level Slot 1"),
    "Level 063 (Slot 1)":                                                               KH1LocationData("Levels",           265_8063, "Level Slot 1"),
    "Level 064 (Slot 1)":                                                               KH1LocationData("Levels",           265_8064, "Level Slot 1"),
    "Level 065 (Slot 1)":                                                               KH1LocationData("Levels",           265_8065, "Level Slot 1"),
    "Level 066 (Slot 1)":                                                               KH1LocationData("Levels",           265_8066, "Level Slot 1"),
    "Level 067 (Slot 1)":                                                               KH1LocationData("Levels",           265_8067, "Level Slot 1"),
    "Level 068 (Slot 1)":                                                               KH1LocationData("Levels",           265_8068, "Level Slot 1"),
    "Level 069 (Slot 1)":                                                               KH1LocationData("Levels",           265_8069, "Level Slot 1"),
    "Level 070 (Slot 1)":                                                               KH1LocationData("Levels",           265_8070, "Level Slot 1"),
    "Level 071 (Slot 1)":                                                               KH1LocationData("Levels",           265_8071, "Level Slot 1"),
    "Level 072 (Slot 1)":                                                               KH1LocationData("Levels",           265_8072, "Level Slot 1"),
    "Level 073 (Slot 1)":                                                               KH1LocationData("Levels",           265_8073, "Level Slot 1"),
    "Level 074 (Slot 1)":                                                               KH1LocationData("Levels",           265_8074, "Level Slot 1"),
    "Level 075 (Slot 1)":                                                               KH1LocationData("Levels",           265_8075, "Level Slot 1"),
    "Level 076 (Slot 1)":                                                               KH1LocationData("Levels",           265_8076, "Level Slot 1"),
    "Level 077 (Slot 1)":                                                               KH1LocationData("Levels",           265_8077, "Level Slot 1"),
    "Level 078 (Slot 1)":                                                               KH1LocationData("Levels",           265_8078, "Level Slot 1"),
    "Level 079 (Slot 1)":                                                               KH1LocationData("Levels",           265_8079, "Level Slot 1"),
    "Level 080 (Slot 1)":                                                               KH1LocationData("Levels",           265_8080, "Level Slot 1"),
    "Level 081 (Slot 1)":                                                               KH1LocationData("Levels",           265_8081, "Level Slot 1"),
    "Level 082 (Slot 1)":                                                               KH1LocationData("Levels",           265_8082, "Level Slot 1"),
    "Level 083 (Slot 1)":                                                               KH1LocationData("Levels",           265_8083, "Level Slot 1"),
    "Level 084 (Slot 1)":                                                               KH1LocationData("Levels",           265_8084, "Level Slot 1"),
    "Level 085 (Slot 1)":                                                               KH1LocationData("Levels",           265_8085, "Level Slot 1"),
    "Level 086 (Slot 1)":                                                               KH1LocationData("Levels",           265_8086, "Level Slot 1"),
    "Level 087 (Slot 1)":                                                               KH1LocationData("Levels",           265_8087, "Level Slot 1"),
    "Level 088 (Slot 1)":                                                               KH1LocationData("Levels",           265_8088, "Level Slot 1"),
    "Level 089 (Slot 1)":                                                               KH1LocationData("Levels",           265_8089, "Level Slot 1"),
    "Level 090 (Slot 1)":                                                               KH1LocationData("Levels",           265_8090, "Level Slot 1"),
    "Level 091 (Slot 1)":                                                               KH1LocationData("Levels",           265_8091, "Level Slot 1"),
    "Level 092 (Slot 1)":                                                               KH1LocationData("Levels",           265_8092, "Level Slot 1"),
    "Level 093 (Slot 1)":                                                               KH1LocationData("Levels",           265_8093, "Level Slot 1"),
    "Level 094 (Slot 1)":                                                               KH1LocationData("Levels",           265_8094, "Level Slot 1"),
    "Level 095 (Slot 1)":                                                               KH1LocationData("Levels",           265_8095, "Level Slot 1"),
    "Level 096 (Slot 1)":                                                               KH1LocationData("Levels",           265_8096, "Level Slot 1"),
    "Level 097 (Slot 1)":                                                               KH1LocationData("Levels",           265_8097, "Level Slot 1"),
    "Level 098 (Slot 1)":                                                               KH1LocationData("Levels",           265_8098, "Level Slot 1"),
    "Level 099 (Slot 1)":                                                               KH1LocationData("Levels",           265_8099, "Level Slot 1"),
    "Level 100 (Slot 1)":                                                               KH1LocationData("Levels",           265_8100, "Level Slot 1"),
   #"Level 001 (Slot 2)":                                                               KH1LocationData("Levels",           265_8101, "Level Slot 2"),
    "Level 002 (Slot 2)":                                                               KH1LocationData("Levels",           265_8102, "Level Slot 2"),
    "Level 003 (Slot 2)":                                                               KH1LocationData("Levels",           265_8103, "Level Slot 2"),
    "Level 004 (Slot 2)":                                                               KH1LocationData("Levels",           265_8104, "Level Slot 2"),
    "Level 005 (Slot 2)":                                                               KH1LocationData("Levels",           265_8105, "Level Slot 2"),
    "Level 006 (Slot 2)":                                                               KH1LocationData("Levels",           265_8106, "Level Slot 2"),
    "Level 007 (Slot 2)":                                                               KH1LocationData("Levels",           265_8107, "Level Slot 2"),
    "Level 008 (Slot 2)":                                                               KH1LocationData("Levels",           265_8108, "Level Slot 2"),
    "Level 009 (Slot 2)":                                                               KH1LocationData("Levels",           265_8109, "Level Slot 2"),
    "Level 010 (Slot 2)":                                                               KH1LocationData("Levels",           265_8110, "Level Slot 2"),
    "Level 011 (Slot 2)":                                                               KH1LocationData("Levels",           265_8111, "Level Slot 2"),
    "Level 012 (Slot 2)":                                                               KH1LocationData("Levels",           265_8112, "Level Slot 2"),
    "Level 013 (Slot 2)":                                                               KH1LocationData("Levels",           265_8113, "Level Slot 2"),
    "Level 014 (Slot 2)":                                                               KH1LocationData("Levels",           265_8114, "Level Slot 2"),
    "Level 015 (Slot 2)":                                                               KH1LocationData("Levels",           265_8115, "Level Slot 2"),
    "Level 016 (Slot 2)":                                                               KH1LocationData("Levels",           265_8116, "Level Slot 2"),
    "Level 017 (Slot 2)":                                                               KH1LocationData("Levels",           265_8117, "Level Slot 2"),
    "Level 018 (Slot 2)":                                                               KH1LocationData("Levels",           265_8118, "Level Slot 2"),
    "Level 019 (Slot 2)":                                                               KH1LocationData("Levels",           265_8119, "Level Slot 2"),
    "Level 020 (Slot 2)":                                                               KH1LocationData("Levels",           265_8120, "Level Slot 2"),
    "Level 021 (Slot 2)":                                                               KH1LocationData("Levels",           265_8121, "Level Slot 2"),
    "Level 022 (Slot 2)":                                                               KH1LocationData("Levels",           265_8122, "Level Slot 2"),
    "Level 023 (Slot 2)":                                                               KH1LocationData("Levels",           265_8123, "Level Slot 2"),
    "Level 024 (Slot 2)":                                                               KH1LocationData("Levels",           265_8124, "Level Slot 2"),
    "Level 025 (Slot 2)":                                                               KH1LocationData("Levels",           265_8125, "Level Slot 2"),
    "Level 026 (Slot 2)":                                                               KH1LocationData("Levels",           265_8126, "Level Slot 2"),
    "Level 027 (Slot 2)":                                                               KH1LocationData("Levels",           265_8127, "Level Slot 2"),
    "Level 028 (Slot 2)":                                                               KH1LocationData("Levels",           265_8128, "Level Slot 2"),
    "Level 029 (Slot 2)":                                                               KH1LocationData("Levels",           265_8129, "Level Slot 2"),
    "Level 030 (Slot 2)":                                                               KH1LocationData("Levels",           265_8130, "Level Slot 2"),
    "Level 031 (Slot 2)":                                                               KH1LocationData("Levels",           265_8131, "Level Slot 2"),
    "Level 032 (Slot 2)":                                                               KH1LocationData("Levels",           265_8132, "Level Slot 2"),
    "Level 033 (Slot 2)":                                                               KH1LocationData("Levels",           265_8133, "Level Slot 2"),
    "Level 034 (Slot 2)":                                                               KH1LocationData("Levels",           265_8134, "Level Slot 2"),
    "Level 035 (Slot 2)":                                                               KH1LocationData("Levels",           265_8135, "Level Slot 2"),
    "Level 036 (Slot 2)":                                                               KH1LocationData("Levels",           265_8136, "Level Slot 2"),
    "Level 037 (Slot 2)":                                                               KH1LocationData("Levels",           265_8137, "Level Slot 2"),
    "Level 038 (Slot 2)":                                                               KH1LocationData("Levels",           265_8138, "Level Slot 2"),
    "Level 039 (Slot 2)":                                                               KH1LocationData("Levels",           265_8139, "Level Slot 2"),
    "Level 040 (Slot 2)":                                                               KH1LocationData("Levels",           265_8140, "Level Slot 2"),
    "Level 041 (Slot 2)":                                                               KH1LocationData("Levels",           265_8141, "Level Slot 2"),
    "Level 042 (Slot 2)":                                                               KH1LocationData("Levels",           265_8142, "Level Slot 2"),
    "Level 043 (Slot 2)":                                                               KH1LocationData("Levels",           265_8143, "Level Slot 2"),
    "Level 044 (Slot 2)":                                                               KH1LocationData("Levels",           265_8144, "Level Slot 2"),
    "Level 045 (Slot 2)":                                                               KH1LocationData("Levels",           265_8145, "Level Slot 2"),
    "Level 046 (Slot 2)":                                                               KH1LocationData("Levels",           265_8146, "Level Slot 2"),
    "Level 047 (Slot 2)":                                                               KH1LocationData("Levels",           265_8147, "Level Slot 2"),
    "Level 048 (Slot 2)":                                                               KH1LocationData("Levels",           265_8148, "Level Slot 2"),
    "Level 049 (Slot 2)":                                                               KH1LocationData("Levels",           265_8149, "Level Slot 2"),
    "Level 050 (Slot 2)":                                                               KH1LocationData("Levels",           265_8150, "Level Slot 2"),
    "Level 051 (Slot 2)":                                                               KH1LocationData("Levels",           265_8151, "Level Slot 2"),
    "Level 052 (Slot 2)":                                                               KH1LocationData("Levels",           265_8152, "Level Slot 2"),
    "Level 053 (Slot 2)":                                                               KH1LocationData("Levels",           265_8153, "Level Slot 2"),
    "Level 054 (Slot 2)":                                                               KH1LocationData("Levels",           265_8154, "Level Slot 2"),
    "Level 055 (Slot 2)":                                                               KH1LocationData("Levels",           265_8155, "Level Slot 2"),
    "Level 056 (Slot 2)":                                                               KH1LocationData("Levels",           265_8156, "Level Slot 2"),
    "Level 057 (Slot 2)":                                                               KH1LocationData("Levels",           265_8157, "Level Slot 2"),
    "Level 058 (Slot 2)":                                                               KH1LocationData("Levels",           265_8158, "Level Slot 2"),
    "Level 059 (Slot 2)":                                                               KH1LocationData("Levels",           265_8159, "Level Slot 2"),
    "Level 060 (Slot 2)":                                                               KH1LocationData("Levels",           265_8160, "Level Slot 2"),
    "Level 061 (Slot 2)":                                                               KH1LocationData("Levels",           265_8161, "Level Slot 2"),
    "Level 062 (Slot 2)":                                                               KH1LocationData("Levels",           265_8162, "Level Slot 2"),
    "Level 063 (Slot 2)":                                                               KH1LocationData("Levels",           265_8163, "Level Slot 2"),
    "Level 064 (Slot 2)":                                                               KH1LocationData("Levels",           265_8164, "Level Slot 2"),
    "Level 065 (Slot 2)":                                                               KH1LocationData("Levels",           265_8165, "Level Slot 2"),
    "Level 066 (Slot 2)":                                                               KH1LocationData("Levels",           265_8166, "Level Slot 2"),
    "Level 067 (Slot 2)":                                                               KH1LocationData("Levels",           265_8167, "Level Slot 2"),
    "Level 068 (Slot 2)":                                                               KH1LocationData("Levels",           265_8168, "Level Slot 2"),
    "Level 069 (Slot 2)":                                                               KH1LocationData("Levels",           265_8169, "Level Slot 2"),
    "Level 070 (Slot 2)":                                                               KH1LocationData("Levels",           265_8170, "Level Slot 2"),
    "Level 071 (Slot 2)":                                                               KH1LocationData("Levels",           265_8171, "Level Slot 2"),
    "Level 072 (Slot 2)":                                                               KH1LocationData("Levels",           265_8172, "Level Slot 2"),
    "Level 073 (Slot 2)":                                                               KH1LocationData("Levels",           265_8173, "Level Slot 2"),
    "Level 074 (Slot 2)":                                                               KH1LocationData("Levels",           265_8174, "Level Slot 2"),
    "Level 075 (Slot 2)":                                                               KH1LocationData("Levels",           265_8175, "Level Slot 2"),
    "Level 076 (Slot 2)":                                                               KH1LocationData("Levels",           265_8176, "Level Slot 2"),
    "Level 077 (Slot 2)":                                                               KH1LocationData("Levels",           265_8177, "Level Slot 2"),
    "Level 078 (Slot 2)":                                                               KH1LocationData("Levels",           265_8178, "Level Slot 2"),
    "Level 079 (Slot 2)":                                                               KH1LocationData("Levels",           265_8179, "Level Slot 2"),
    "Level 080 (Slot 2)":                                                               KH1LocationData("Levels",           265_8180, "Level Slot 2"),
    "Level 081 (Slot 2)":                                                               KH1LocationData("Levels",           265_8181, "Level Slot 2"),
    "Level 082 (Slot 2)":                                                               KH1LocationData("Levels",           265_8182, "Level Slot 2"),
    "Level 083 (Slot 2)":                                                               KH1LocationData("Levels",           265_8183, "Level Slot 2"),
    "Level 084 (Slot 2)":                                                               KH1LocationData("Levels",           265_8184, "Level Slot 2"),
    "Level 085 (Slot 2)":                                                               KH1LocationData("Levels",           265_8185, "Level Slot 2"),
    "Level 086 (Slot 2)":                                                               KH1LocationData("Levels",           265_8186, "Level Slot 2"),
    "Level 087 (Slot 2)":                                                               KH1LocationData("Levels",           265_8187, "Level Slot 2"),
    "Level 088 (Slot 2)":                                                               KH1LocationData("Levels",           265_8188, "Level Slot 2"),
    "Level 089 (Slot 2)":                                                               KH1LocationData("Levels",           265_8189, "Level Slot 2"),
    "Level 090 (Slot 2)":                                                               KH1LocationData("Levels",           265_8190, "Level Slot 2"),
    "Level 091 (Slot 2)":                                                               KH1LocationData("Levels",           265_8191, "Level Slot 2"),
    "Level 092 (Slot 2)":                                                               KH1LocationData("Levels",           265_8192, "Level Slot 2"),
    "Level 093 (Slot 2)":                                                               KH1LocationData("Levels",           265_8193, "Level Slot 2"),
    "Level 094 (Slot 2)":                                                               KH1LocationData("Levels",           265_8194, "Level Slot 2"),
    "Level 095 (Slot 2)":                                                               KH1LocationData("Levels",           265_8195, "Level Slot 2"),
    "Level 096 (Slot 2)":                                                               KH1LocationData("Levels",           265_8196, "Level Slot 2"),
    "Level 097 (Slot 2)":                                                               KH1LocationData("Levels",           265_8197, "Level Slot 2"),
    "Level 098 (Slot 2)":                                                               KH1LocationData("Levels",           265_8198, "Level Slot 2"),
    "Level 099 (Slot 2)":                                                               KH1LocationData("Levels",           265_8199, "Level Slot 2"),
    "Level 100 (Slot 2)":                                                               KH1LocationData("Levels",           265_8200, "Level Slot 2"),
    "Complete Phil Cup":                                                                KH1LocationData("Olympus Coliseum", 265_9001, "Static", True),
    "Complete Phil Cup Solo":                                                           KH1LocationData("Olympus Coliseum", 265_9002, "Reward", True),
    "Complete Phil Cup Time Trial":                                                     KH1LocationData("Olympus Coliseum", 265_9003, "Reward", True),
    "Complete Pegasus Cup":                                                             KH1LocationData("Olympus Coliseum", 265_9004, "Reward", True),
    "Complete Pegasus Cup Solo":                                                        KH1LocationData("Olympus Coliseum", 265_9005, "Reward", True),
    "Complete Pegasus Cup Time Trial":                                                  KH1LocationData("Olympus Coliseum", 265_9006, "Reward", True),
    "Complete Hercules Cup":                                                            KH1LocationData("Olympus Coliseum", 265_9007, "Reward", True),
    "Complete Hercules Cup Solo":                                                       KH1LocationData("Olympus Coliseum", 265_9008, "Reward", True),
    "Complete Hercules Cup Time Trial":                                                 KH1LocationData("Olympus Coliseum", 265_9009, "Reward", True),
    "Complete Hades Cup":                                                               KH1LocationData("Olympus Coliseum", 265_9010, "Reward", True),
    "Complete Hades Cup Solo":                                                          KH1LocationData("Olympus Coliseum", 265_9011, "Reward", True),
    "Complete Hades Cup Time Trial":                                                    KH1LocationData("Olympus Coliseum", 265_9012, "Reward", True),
    "Hades Cup Defeat Cloud and Leon Event":                                            KH1LocationData("Olympus Coliseum", 265_9013, "Reward", True),
    "Hades Cup Defeat Yuffie Event":                                                    KH1LocationData("Olympus Coliseum", 265_9014, "Reward", True),
    "Hades Cup Defeat Cerberus Event":                                                  KH1LocationData("Olympus Coliseum", 265_9015, "Static", True),
    "Hades Cup Defeat Behemoth Event":                                                  KH1LocationData("Olympus Coliseum", 265_9016, "Static", True),
    "Hades Cup Defeat Hades Event":                                                     KH1LocationData("Olympus Coliseum", 265_9017, "Static", True),
    "Hercules Cup Defeat Cloud Event":                                                  KH1LocationData("Olympus Coliseum", 265_9018, "Reward", True),
    "Hercules Cup Yellow Trinity Event":                                                KH1LocationData("Olympus Coliseum", 265_9019, "Static", True)
}

event_location_table: Dict[str, KH1LocationData] = {
        "Final Ansem": KH1LocationData("Homecoming", 265_9999, "None", True)
}

lookup_id_to_name: typing.Dict[int, str] = {data.code: item_name for item_name, data in location_table.items() if data.code}


#Make location categories
location_name_groups: Dict[str, Set[str]] = {}
for location in location_table.keys():
    category = location_table[location].category
    if category not in location_name_groups.keys():
        location_name_groups[category] = set()
    location_name_groups[category].add(location)
