"""Stores the data for the locations of colored bananas and balloons in Jungle Japes."""

from randomizer.Enums.Events import Events
from randomizer.Enums.Kongs import Kongs
from randomizer.Enums.Levels import Levels
from randomizer.Enums.Regions import Regions
from randomizer.Enums.Maps import Maps
from randomizer.Enums.Switches import Switches
from randomizer.LogicClasses import Balloon, ColoredBananaGroup

ColoredBananaGroupList = [
    ColoredBananaGroup(
        group=1,
        map_id=Maps.JungleJapes,
        name="Starting area against outside wall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [1, 1.0, 758, 286, 894],
            [1, 1.0, 758, 286, 778],
            [1, 1.0, 773, 280, 662],
            [1, 1.0, 798, 285, 557],
            [1, 1.0, 865, 285, 447],
            [1, 1.0, 946, 280, 358],
            [1, 1.0, 1022, 280, 296],
            [1, 1.0, 1121, 280, 234],
            [1, 1.0, 1229, 284, 197],
            [1, 1.0, 1352, 285, 188],
        ],
    ),
    ColoredBananaGroup(
        group=2,
        map_id=Maps.JungleJapes,
        name="Starting area treetops",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 1073, 461, 612], [5, 1.0, 1103, 488, 266], [5, 1.0, 1307, 461, 404]],
    ),
    ColoredBananaGroup(
        group=3,
        map_id=Maps.JungleJapes,
        name="Pentagon around Diddy's Cave GB",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondPeanutGate,
        locations=[
            [1, 1.0, 2448, 280, 455],
            [1, 1.0, 2531, 280, 447],
            [1, 1.0, 2562, 280, 544],
            [1, 1.0, 2494, 280, 607],
            [1, 1.0, 2423, 280, 548],
        ],
    ),
    ColoredBananaGroup(
        group=4,
        map_id=Maps.JungleJapes,
        name="Bunch in front of Cave T&S",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondPeanutGate,
        locations=[[5, 1.0, 2486, 285, 695]],
    ),
    ColoredBananaGroup(
        group=5,
        map_id=Maps.JungleJapes,
        name="Line in front of cave peanut gate",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [1, 1.0, 2245, 280, 514],
            [1, 1.0, 2185, 280, 514],
            [1, 1.0, 2125, 280, 514],
            [1, 1.0, 2065, 280, 514],
            [1, 1.0, 2005, 280, 514],
        ],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.JungleJapes,
        name="Bunch on torch in cave tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[[5, 1.0, 1502, 336, 887]],
    ),
    ColoredBananaGroup(
        group=7,
        map_id=Maps.JungleJapes,
        name="W1 bunches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[[5, 1.0, 915, 295, 796], [5, 1.0, 1516, 295, 1201]],
    ),
    ColoredBananaGroup(
        group=8,
        map_id=Maps.JungleJapes,
        name="W2 bunches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        locations=[[5, 1.0, 1492, 295, 1425], [5, 1.0, 1520, 805, 2302]],
    ),
    ColoredBananaGroup(
        group=9,
        map_id=Maps.JungleJapes,
        name="Along the shoreline on Tag Barrel side of river",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [1, 1.0, 1189, 281, 1407],
            [1, 1.0, 1240, 286, 1488],
            [1, 1.0, 1288, 287, 1546],
            [1, 1.0, 1338, 287, 1593],
            [1, 1.0, 1433, 289, 1590],
            [1, 1.0, 1548, 287, 1604],
            [1, 1.0, 1645, 287, 1592],
            [1, 1.0, 1743, 288, 1580],
            [1, 1.0, 1878, 288, 1604],
            [1, 1.0, 1957, 288, 1607],
            [1, 1.0, 2046, 287, 1591],
            [1, 1.0, 2129, 286, 1571],
            [1, 1.0, 2220, 280, 1593],
            [1, 1.0, 2264, 280, 1652],
            [1, 1.0, 2340, 280, 1744],
        ],
    ),
    ColoredBananaGroup(
        group=10,
        map_id=Maps.JungleJapes,
        name="Cannon to Diddy cage (2 bunches)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCannonPlatform,
        locations=[[5, 1.0, 1233, 703, 2165], [5, 1.0, 1217, 880, 2229]],
    ),
    ColoredBananaGroup(
        group=11,
        map_id=Maps.JungleJapes,
        name="Tops of solid bushes (TB side)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[[5, 1.0, 1960, 325, 1340], [5, 1.0, 1576, 325, 1343]],
    ),
    ColoredBananaGroup(
        group=12,
        map_id=Maps.JungleJapes,
        name="Tops of bushes (Painting Room side)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        locations=[[5, 1.0, 826, 320, 1720], [5, 1.0, 751, 320, 2133]],
    ),
    ColoredBananaGroup(
        group=13,
        map_id=Maps.JungleJapes,
        name="From Diddy BP to river side (7 custom, 3 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[
            [1, 1.0, 859.3239135742188, 280.50958251953125, 2552.880126953125],
            [1, 1.0, 980.2548828125, 280.0, 2600.518798828125],
            [1, 1.0, 766.6155395507812, 287.0641784667969, 2414.478271484375],
        ],
    ),
    ColoredBananaGroup(
        group=13,
        map_id=Maps.JungleJapes,
        name="From Diddy BP to river side (7 custom, 3 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        locations=[
            [1, 1.0, 785, 288, 2311],
            [1, 1.0, 843, 288, 2210],
            [1, 1.0, 875, 288, 2115],
            [1, 1.0, 921, 288, 1997],
            [1, 1.0, 992, 288, 1889],
            [1, 1.0, 1064, 288, 1792],
            [1, 1.0, 1139, 288, 1700],
        ],
    ),
    ColoredBananaGroup(
        group=14,
        map_id=Maps.JungleJapes,
        name="Bunch in Minecart exit",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        locations=[[5, 1.0, 1105, 298, 1965]],
    ),
    ColoredBananaGroup(
        group=15,
        map_id=Maps.JungleJapes,
        name="Up the slope to painting room",
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.JungleJapesMain,
        logic=lambda l: (l.handstand and l.islanky) or (l.twirl and l.istiny) or l.slope_resets,
        locations=[[5, 1.0, 545, 375, 1943], [5, 1.0, 553, 375, 1806]],
    ),
    ColoredBananaGroup(
        group=16,
        map_id=Maps.JapesLankyCave,
        name="Each side of the painting",
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.JapesLankyCave,
        locations=[[5, 1.0, 310, 85, 360], [5, 1.0, 97, 85, 356]],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.JungleJapes,
        name="Leading up to and on BBlast pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.JapesBlastPadPlatform,
        logic=lambda l: l.can_use_vines or l.CanMoonkick(),
        locations=[
            [1, 1.0, 2308, 535, 1453],
            [1, 1.0, 2367, 550, 1330],
            [1, 1.0, 2422, 552, 1212],
            [1, 1.0, 2415, 530, 1123],
            [1, 1.0, 2511, 530, 1179],
        ],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.JungleJapes,
        name="Leading up to and on BBlast pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.JapesBlastPadPlatform,
        locations=[
            [5, 1.0, 2454, 544, 1152],
        ],
    ),
    ColoredBananaGroup(
        group=18,
        map_id=Maps.JungleJapes,
        name="Up the vine to Funky's and lining the edge of Funky's area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHill,
        locations=[
            [1, 1.0, 2191, 520, 2064],
            [1, 1.0, 2141, 520, 2034],
            [1, 1.0, 2092, 520, 1983],
            [1, 1.0, 2014, 520, 1950],
            [1, 1.0, 1965, 520, 1934],
            [1, 1.0, 1914, 520, 1948],
            [1, 1.0, 1842, 520, 1995],
            [1, 1.0, 1783, 520, 2055],
            [1, 1.0, 1783, 520, 2155],
            [1, 1.0, 1845, 520, 2207],
            [1, 1.0, 1993, 510, 1909],
            [1, 1.0, 1994, 450, 1883],
            [1, 1.0, 1995, 397, 1860],
            [1, 1.0, 1996, 340, 1835],
            [1, 1.0, 1997, 288, 1815],
        ],
    ),
    ColoredBananaGroup(
        group=19,
        map_id=Maps.JungleJapes,
        name="On the edge of cannon platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCannonPlatform,
        locations=[
            [1, 1.0, 1088, 520, 2234],
            [1, 1.0, 1079, 520, 2166],
            [1, 1.0, 1094, 520, 2088],
            [1, 1.0, 1139, 520, 2030],
            [1, 1.0, 1192, 520, 1963],
            [1, 1.0, 1254, 520, 1934],
            [1, 1.0, 1314, 520, 1974],
            [1, 1.0, 1375, 520, 2012],
            [1, 1.0, 1404, 520, 2067],
            [1, 1.0, 1404, 520, 2152],
        ],
    ),
    ColoredBananaGroup(
        group=20,
        map_id=Maps.JungleJapes,
        name="Bunches on torches by DK and Tiny BPs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate1,
        locations=[[5, 1.0, 2754, 378, 2172], [5, 1.0, 3262, 497, 2401]],
    ),
    ColoredBananaGroup(
        group=21,
        map_id=Maps.JungleJapes,
        name="Singles in DK/Tiny BP tunnel (10 custom, 10 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate1,
        locations=[
            [1, 1.0, 2542, 301, 1755],
            [1, 1.0, 2652, 335, 1915],
            [1, 1.0, 2812, 335, 2011],
            [1, 1.0, 2972, 361, 2058],
            [1, 1.0, 3061, 404, 2178],
            [1, 1.0, 3112, 432, 2328],
            [1, 1.0, 3133, 439, 2481],
            [1, 1.0, 3100, 455, 2622],
            [1, 1.0, 3002, 463, 2744],
            [1, 1.0, 2859, 479, 2829],
            [1, 1.0, 2908.599609375, 342.7155456542969, 2035.3897705078125],
            [1, 1.0, 3088.2353515625, 422.75390625, 2255.6025390625],
            [1, 1.0, 3024.669677734375, 381.5446472167969, 2101.298828125],
            [1, 1.0, 2723.279541015625, 334.6666564941406, 1982.9111328125],
            [1, 1.0, 2797.958984375, 499.7945556640625, 2858.415771484375],
            [1, 1.0, 3062.7216796875, 459.0200500488281, 2686.699951171875],
            [1, 1.0, 2931.587158203125, 468.8185119628906, 2787.672119140625],
            [1, 1.0, 3125.909423828125, 443.2445373535156, 2538.503662109375],
            [1, 1.0, 3130.205810546875, 436.6583557128906, 2425.482177734375],
            [1, 1.0, 2605.50927734375, 326.4835510253906, 1833.25830078125],
        ],
    ),
    ColoredBananaGroup(
        group=22,
        map_id=Maps.JungleJapes,
        name="W5 bunches and 5 singles around on mountain",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesTopOfMountain,
        locations=[
            [5, 1.0, 1615, 1003, 2441],
            [1, 1.0, 1652, 990, 2435],
            [1, 1.0, 1632, 990, 2475],
            [1, 1.0, 1591, 990, 2467],
            [1, 1.0, 1582, 990, 2416],
            [1, 1.0, 1626, 990, 2403],
        ],
    ),
    ColoredBananaGroup(
        group=22,
        map_id=Maps.JungleJapes,
        name="W5 bunches and 5 singles around on mountain",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        locations=[[5, 1.0, 2582, 553, 2948]],
    ),
    ColoredBananaGroup(
        group=23,
        map_id=Maps.JungleJapes,
        name="Ring of singles around beehive area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        locations=[
            [1, 1.0, 2525, 540, 2990],
            [1, 1.0, 2548, 540, 3101],
            [1, 1.0, 2565, 540, 3185],
            [1, 1.0, 2523, 540, 3316],
            [1, 1.0, 2449, 540, 3384],
            [1, 1.0, 2333, 540, 3438],
            [1, 1.0, 2175, 540, 3424],
            [1, 1.0, 2065, 540, 3334],
            [1, 1.0, 2035, 540, 3221],
            [1, 1.0, 2052, 540, 3110],
            [1, 1.0, 2089, 540, 3021],
            [1, 1.0, 2147, 540, 2955],
            [1, 1.0, 2236, 540, 2917],
            [1, 1.0, 2341, 540, 2914],
            [1, 1.0, 2448, 540, 2935],
        ],
    ),
    ColoredBananaGroup(
        group=24,
        map_id=Maps.JungleJapes,
        name="Beehive area inner platform ring (between trees)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        locations=[
            [1, 1.0, 2432, 552, 3100],
            [1, 1.0, 2455, 552, 3162],
            [1, 1.0, 2408, 552, 3242],
            [1, 1.0, 2354, 552, 3268],
            [1, 1.0, 2284, 552, 3282],
            [1, 1.0, 2212, 552, 3205],
            [1, 1.0, 2218, 552, 3134],
            [1, 1.0, 2242, 552, 3096],
            [1, 1.0, 2304, 552, 3034],
            [1, 1.0, 2356, 552, 3037],
        ],
    ),
    ColoredBananaGroup(
        group=25,
        map_id=Maps.JungleJapes,
        name="Bunch on stump (beehive area)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        locations=[[5, 1.0, 2024, 585, 3513]],
    ),
    ColoredBananaGroup(
        group=26,
        map_id=Maps.JungleJapes,
        name="Singles on steps leading to beehive",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        locations=[
            [1, 1.0, 2036, 557, 2792],
            [1, 1.0, 2058, 540, 2835],
            [1, 1.0, 2034, 557, 2866],
            [1, 1.0, 2042, 540, 2902],
            [1, 1.0, 2014, 557, 2935],
            [1, 1.0, 2001, 540, 2979],
            [1, 1.0, 1966, 557, 2997],
            [1, 1.0, 1927, 540, 3039],
            [1, 1.0, 1875, 557, 3046],
            [1, 1.0, 1853, 540, 3074],
        ],
    ),
    ColoredBananaGroup(
        group=27,
        map_id=Maps.JungleJapes,
        name="From W4 to Cranky (1 custom, 9 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[
            [1, 1.0, 1625, 211, 3003],
            [1, 1.0, 1531.234375, 280.0, 2431.762939453125],
            [1, 1.0, 1462.0770263671875, 280.0, 2621.267578125],
            [1, 1.0, 1570.7384033203125, 226.70310974121094, 2879.103515625],
            [1, 1.0, 1516.8656005859375, 252.53196716308594, 2758.515625],
            [1, 1.0, 1701.2020263671875, 263.4380187988281, 3513.92578125],
            [1, 1.0, 1706.4664306640625, 224.70494079589844, 3395.131591796875],
            [1, 1.0, 1701.599609375, 211.77734375, 3280.7509765625],
            [1, 1.0, 1601.4698486328125, 280.0, 2273.060791015625],
            [1, 1.0, 1663.626953125, 210.6666717529297, 3110.659912109375],
        ],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.JungleJapes,
        name="Bottom of pit near Diddy BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[
            [1, 1.0, 1264, 230, 2680],
            [1, 1.0, 1214, 230, 2682],
            [1, 1.0, 1164, 230, 2684],
            [1, 1.0, 1114, 230, 2686],
            [1, 1.0, 1064, 230, 2688],
        ],
    ),
    ColoredBananaGroup(
        group=29,
        map_id=Maps.JungleJapes,
        name="Bunches above water in fairy room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        locations=[[5, 1.0, 500, 220, 2745], [5, 1.0, 354, 220, 2850]],
    ),
    ColoredBananaGroup(
        group=30,
        map_id=Maps.JungleJapes,
        name="Bunches on torches in boulder room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        locations=[[5, 1.0, 779, 340, 3479], [5, 1.0, 829, 340, 3807]],
    ),
    ColoredBananaGroup(
        group=31,
        map_id=Maps.JungleJapes,
        name="W4 bunches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[5, 1.0, 1598, 295, 2216], [5, 1.0, 1696, 295, 3887]],
    ),
    ColoredBananaGroup(
        group=32,
        map_id=Maps.JungleJapes,
        name="Cranky trees (1 custom, 1 Lanky, 1 Tiny bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        logic=lambda l: l.climbing,
        locations=[
            [5, 1.0, 1844, 484, 3950],
            [5, 1.0, 1833.0638427734375, 480.0, 4210.4951171875],
            [5, 1.0, 1431.26953125, 480.0, 4010.7890625],
        ],
    ),
    ColoredBananaGroup(
        group=33,
        map_id=Maps.JungleJapes,
        name="Outside ring around Cranky area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[
            [1, 1.0, 1704, 280, 3644],
            [1, 1.0, 1815, 280, 3694],
            [1, 1.0, 1912, 280, 3773],
            [1, 1.0, 1981, 280, 3874],
            [1, 1.0, 2043, 280, 3982],
            [1, 1.0, 2032, 280, 4081],
            [1, 1.0, 1983, 280, 4181],
            [1, 1.0, 1900, 280, 4245],
            [1, 1.0, 1790, 280, 4285],
            [1, 1.0, 1693, 280, 4291],
            [1, 1.0, 1601, 280, 4274],
            [1, 1.0, 1523, 280, 4236],
            [1, 1.0, 1455, 280, 4204],
            [1, 1.0, 1405, 280, 4157],
            [1, 1.0, 1366, 280, 4080],
            [1, 1.0, 1350, 280, 3971],
            [1, 1.0, 1386, 280, 3870],
            [1, 1.0, 1444, 280, 3781],
            [1, 1.0, 1515, 280, 3722],
            [1, 1.0, 1601, 280, 3669],
        ],
    ),
    ColoredBananaGroup(
        group=34,
        map_id=Maps.JungleJapes,
        name="Inside ring around Cranky's Lab",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[
            [1, 1.0, 1653, 280, 3894],
            [1, 1.0, 1610, 280, 3945],
            [1, 1.0, 1593, 280, 3995],
            [1, 1.0, 1607, 280, 4047],
            [1, 1.0, 1656, 280, 4087],
            [1, 1.0, 1722, 280, 4095],
            [1, 1.0, 1776, 280, 4072],
            [1, 1.0, 1797, 280, 4010],
            [1, 1.0, 1780, 280, 3946],
            [1, 1.0, 1745, 280, 3902],
        ],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.JungleJapes,
        name="Lanky's blueprint room (8 custom, 7 Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[
            [1, 1.0, 1727, 214, 2979],
            [1, 1.0, 1856, 246, 2913],
            [1, 1.0, 1959, 251, 2858],
            [1, 1.0, 2016, 251, 2832],
            [1, 1.0, 1982, 251, 2759],
            [1, 1.0, 1950, 251, 2691],
            [1, 1.0, 2053, 251, 2895],
            [1, 1.0, 2092, 251, 2972],
            [1, 1.0, 1788.26025390625, 228.1462860107422, 2948.677978515625],
            [1, 1.0, 2124.122314453125, 259.5167541503906, 3043.486328125],
            [1, 1.0, 1918.3233642578125, 256.97412109375, 2622.306884765625],
        ],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.JungleJapes,
        name="Lanky's blueprint room (8 custom, 7 Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.JapesBeyondCoconutGate2,
        logic=lambda l: l.handstand or l.slope_resets,
        locations=[
            [1, 1.0, 1902.0511474609375, 291.0079650878906, 2582.19384765625],
            [1, 1.0, 1883.33154296875, 330.1593933105469, 2536.048583984375],
        ],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.JungleJapes,
        name="Lanky's blueprint room (8 custom, 7 Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.JapesUselessSlope,
        locations=[
            [1, 1.0, 2167.22607421875, 337.8395690917969, 3129.978271484375],
            [1, 1.0, 2144.438232421875, 297.8414001464844, 3084.663818359375],
        ],
    ),
    ColoredBananaGroup(
        group=36,
        map_id=Maps.JungleJapes,
        name="4 corners of Lanky BP room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[
            [5, 1.0, 1987, 251, 2990],
            [5, 1.0, 2172, 251, 2894],
            [5, 1.0, 2045, 251, 2685],
            [5, 1.0, 1879, 251, 2777],
        ],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.JungleJapes,
        name="Slope to Painting room (2 custom, 3 Lanky)",
        region=Regions.JapesPaintingRoomHill,
        konglist=[Kongs.lanky],
        locations=[
            [1, 1.0, 555, 376, 1872],
            [1, 1.0, 487, 371, 1883],
            [1, 1.0, 625.1854858398438, 361.2266540527344, 1871.6522216796875],
            [1, 1.0, 665.0092163085938, 328.6192626953125, 1877.62353515625],
        ],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.JungleJapes,
        name="Slope to Painting room (2 custom, 3 Lanky)",
        region=Regions.JungleJapesMain,
        konglist=[Kongs.lanky],
        locations=[[1, 1.0, 706.603759765625, 295.4219055175781, 1883.2244873046875]],
    ),
    ColoredBananaGroup(
        group=38,
        map_id=Maps.JungleJapes,
        name="Riverbed (5 custom, 5 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        logic=lambda l: l.swim,
        locations=[
            [1, 1.2, 2173, 160, 1810],
            [1, 1.2, 1998, 160, 1738],
            [1, 1.2, 1783, 160, 1757],
            [1, 1.2, 1681, 160, 1744],
            [1, 1.2, 1286, 160, 1659],
            [1, 1.0, 2142.3037109375, 160.0, 1762.4700927734375],
            [1, 1.0, 1861.0958251953125, 160.0, 1724.80419921875],
            [1, 1.0, 1571.9000244140625, 160.0, 1772.1827392578125],
            [1, 1.0, 1363.4798583984375, 160.0, 1717.8392333984375],
            [1, 1.0, 1183.5438232421875, 160.0, 1582.2294921875],
        ],
    ),
    ColoredBananaGroup(
        group=39,
        map_id=Maps.JungleJapes,
        name="Riverbed bunches (on each end)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        logic=lambda l: l.swim,
        locations=[[5, 1.2, 1099, 165, 1496], [5, 1.2, 2307, 165, 1895]],
    ),
    ColoredBananaGroup(
        group=40,
        map_id=Maps.JapesMountain,
        name="Bunch on Diddy's switch",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        logic=lambda l: l.peanut or l.monkey_maneuvers,
        locations=[[5, 1.0, 485, 144, 122]],
    ),
    ColoredBananaGroup(
        group=41,
        map_id=Maps.JapesMountain,
        name="Singles on path to switch",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        locations=[
            [1, 1.0, 398, 60, 476],
            [1, 1.0, 429, 120, 482],
            [1, 1.0, 498, 143, 418],
            [1, 1.0, 500, 138, 314],
            [1, 1.0, 500, 143, 229],
        ],
    ),
    ColoredBananaGroup(
        group=42,
        map_id=Maps.JapesMountain,
        name="Big upside down minecart",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        locations=[[5, 1.0, 493, 145, 513]],
    ),
    ColoredBananaGroup(
        group=43,
        map_id=Maps.JapesMountain,
        name="2 bunches on big barrel (with ammo)",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        locations=[[5, 1.0, 681, 140, 729], [5, 1.0, 703, 140, 779]],
    ),
    ColoredBananaGroup(
        group=44,
        map_id=Maps.JapesMountain,
        name="Bunches on piles of coal",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        locations=[[5, 1.0, 915, 105, 919], [5, 1.0, 705, 107, 821]],
    ),
    ColoredBananaGroup(
        group=45,
        map_id=Maps.JapesMountain,
        name="2 bunches on steel kegs (2nd room)",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        locations=[[5, 1.0, 800, 132, 1087], [5, 1.0, 345, 142, 1303]],
    ),
    ColoredBananaGroup(
        group=46,
        map_id=Maps.JapesMountain,
        name="Dynamite box in chimpy charge switch room",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        logic=lambda l: l.charge or l.CanPhase(),
        locations=[[5, 1.0, 325, 138, 1511]],
    ),
    ColoredBananaGroup(
        group=47,
        map_id=Maps.JapesMountain,
        name="Bunches on staircase-shaped boxes",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        logic=lambda l: l.CanSlamSwitch(Levels.JungleJapes, 1) or l.CanPhase(),
        locations=[[5, 1.0, 93, 145, 962], [5, 1.0, 40, 225, 1057]],
    ),
    ColoredBananaGroup(
        group=48,
        map_id=Maps.JapesMountain,
        name="Conveyors",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        logic=lambda l: l.CanSlamSwitch(Levels.JungleJapes, 1) or l.CanPhase(),
        locations=[
            [1, 1.0, 157, 208, 840],
            [1, 1.0, 125, 246, 898],
            [1, 1.0, 97, 289, 955],
            [1, 1.0, 68, 317, 999],
            [1, 1.0, 37, 344, 1040],
            [1, 1.0, 37, 346, 1091],
            [1, 1.0, 110, 346, 1138],
            [1, 1.0, 178, 346, 1180],
            [1, 1.0, 233, 346, 1211],
            [1, 1.0, 279, 346, 1237],
        ],
    ),
    ColoredBananaGroup(
        group=49,
        map_id=Maps.JungleJapes,
        name="Ring around mountain (3 custom, 7 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        locations=[
            [1, 1.0, 1575, 790, 2592],
            [1, 1.0, 1463, 790, 2485],
            [1, 1.0, 1494, 790, 2334],
            [1, 1.0, 1694.3258056640625, 790.0, 2314.914794921875],
            [1, 1.0, 1577.62255859375, 791.0, 2282.85791015625],
            [1, 1.0, 1673.84912109375, 790.0, 2588.686279296875],
            [1, 1.0, 1760.2186279296875, 790.0, 2401.955322265625],
            [1, 1.0, 1510.65771484375, 790.0, 2540.358642578125],
            [1, 1.0, 1752.9637451171875, 790.0, 2501.241943359375],
            [1, 1.0, 1471.1875, 790.0, 2419.264892578125],
        ],
    ),
    ColoredBananaGroup(
        group=50,
        map_id=Maps.JapesUnderGround,
        name="On path (15 custom, 5 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCatacomb,
        locations=[
            [1, 1.0, 802, 20, 509],
            [1, 1.0, 799, 20, 573],
            [1, 1.0, 791, 20, 655],
            [1, 1.0, 818, 20, 730],
            [1, 1.0, 875, 20, 747],
            [1, 1.0, 958, 20, 766],
            [1, 1.0, 979, 20, 841],
            [1, 1.0, 934, 20, 896],
            [1, 1.0, 878, 20, 966],
            [1, 1.0, 800, 20, 948],
            [1, 1.0, 756, 20, 878],
            [1, 1.0, 666, 20, 857],
            [1, 1.0, 590, 20, 878],
            [1, 1.0, 514, 20, 845],
            [1, 1.0, 450, 20, 815],
            [1, 1.0, 543.4080200195312, 20.5, 98.04984283447266],
            [1, 1.0, 660.4284057617188, 20.5, 106.18470001220703],
            [1, 1.0, 760.330322265625, 20.5, 183.69252014160156],
            [1, 1.0, 801.6238403320312, 20.5, 294.23358154296875],
            [1, 1.0, 811.5715942382812, 20.5, 420.1582946777344],
        ],
    ),
    ColoredBananaGroup(
        group=51,
        map_id=Maps.JapesUnderGround,
        name="On blueprint platform",
        konglist=[Kongs.chunky],
        region=Regions.JapesCatacomb,
        logic=lambda l: l.pineapple and l.can_use_vines and l.ischunky,
        locations=[[5, 1.0, 203, 5, 686]],
    ),
    ColoredBananaGroup(
        group=52,
        map_id=Maps.JapesTinyHive,
        name="Paths to 1st & 2nd Switch",
        konglist=[Kongs.tiny],
        region=Regions.TinyHive,
        logic=lambda l: l.CanSlamSwitch(Levels.JungleJapes, 1) and l.istiny,
        locations=[
            [1, 2.0, 1203, 213, 1424],
            [1, 2.0, 1118, 178, 1423],
            [1, 2.0, 1023, 163, 1423],
            [1, 2.0, 942, 154, 1422],
            [1, 2.0, 852, 147, 1422],
            [1, 2.0, 1376, 213, 1143],
            [1, 2.0, 1374, 213, 1036],
            [1, 2.0, 1374, 213, 925],
            [1, 2.0, 1374, 213, 830],
            [1, 2.0, 1374, 212, 709],
        ],
    ),
    ColoredBananaGroup(
        group=53,
        map_id=Maps.JapesTinyHive,
        name="Around first switch room",
        konglist=[Kongs.tiny],
        region=Regions.TinyHive,
        locations=[
            [1, 2.0, 778, 142, 1525],
            [1, 2.0, 681, 136, 1605],
            [1, 2.0, 557, 127, 1631],
            [1, 2.0, 446, 120, 1569],
            [1, 2.0, 392, 116, 1434],
            [1, 2.0, 411, 118, 1304],
            [1, 2.0, 536, 126, 1223],
            [1, 2.0, 634, 133, 1226],
            [1, 2.0, 733, 139, 1279],
            [1, 2.0, 793, 143, 1343],
        ],
    ),
    ColoredBananaGroup(
        group=54,
        map_id=Maps.JapesTinyHive,
        name="Behind 2nd hallway arch",
        konglist=[Kongs.tiny],
        region=Regions.TinyHive,
        logic=lambda l: (l.CanSlamSwitch(Levels.JungleJapes, 1) and (l.saxophone or l.oranges)) and l.istiny,
        locations=[[5, 2.0, 1331, 228, 1143], [5, 2.0, 1425, 228, 1143]],
    ),
    ColoredBananaGroup(
        group=55,
        map_id=Maps.JapesTinyHive,
        name="Rings on steps (12 custom, 8 Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.TinyHive,
        logic=lambda l: (l.CanSlamSwitch(Levels.JungleJapes, 1) and (l.saxophone or l.oranges)) and l.istiny,
        locations=[
            [1, 2.0, 2138, 295, 1349],
            [1, 2.0, 2180, 295, 1285],
            [1, 2.0, 2248, 295, 1240],
            [1, 2.0, 2322, 295, 1234],
            [1, 2.0, 2410, 295, 1281],
            [1, 2.0, 2440, 295, 1347],
            [1, 2.0, 2435, 295, 1436],
            [1, 2.0, 2409, 295, 1492],
            [1, 2.0, 2329, 295, 1536],
            [1, 2.0, 2260, 295, 1533],
            [1, 2.0, 2188, 295, 1498],
            [1, 2.0, 2152, 295, 1442],
            [1, 2.0199990272521973, 2209.72705078125, 334.1666564941406, 1324.132080078125],
            [1, 2.0, 2369.22607421875, 334.1666564941406, 1444.6005859375],
            [1, 2.0, 2198.421630859375, 334.1666564941406, 1402.662109375],
            [1, 2.0, 2229.62939453125, 334.1666564941406, 1462.15673828125],
            [1, 2.0199997425079346, 2296.900634765625, 334.1666564941406, 1479.4356689453125],
            [1, 2.0, 2389.229248046875, 334.1666564941406, 1378.9671630859375],
            [1, 2.0, 2353.2763671875, 334.1666564941406, 1318.087646484375],
            [1, 2.0, 2273.12255859375, 334.1666564941406, 1293.6973876953125],
        ],
    ),
    ColoredBananaGroup(
        group=56,
        map_id=Maps.JapesTinyHive,
        name="Around 2nd switch room",
        konglist=[Kongs.tiny],
        region=Regions.TinyHive,
        logic=lambda l: (l.CanSlamSwitch(Levels.JungleJapes, 1) and (l.saxophone or l.oranges)) and l.istiny,
        locations=[
            [1, 2.0, 1263, 212, 677],
            [1, 2.0, 1185, 206, 579],
            [1, 2.0, 1167, 198, 478],
            [1, 2.0, 1253, 188, 362],
            [1, 2.0, 1387, 185, 323],
            [1, 2.0, 1467, 187, 343],
            [1, 2.0, 1552, 196, 450],
            [1, 2.0, 1578, 203, 546],
            [1, 2.0, 1542, 211, 641],
            [1, 2.0, 1453, 212, 698],
        ],
    ),
    ColoredBananaGroup(
        group=57,
        map_id=Maps.JapesBaboonBlast,
        name="Baboon blast singles between barrels",
        konglist=[Kongs.donkey],
        region=Regions.JapesBaboonBlast,
        locations=[
            [1, 1.3, 1929, 878, 1191],
            [1, 1.3, 1888, 878, 1135],
            [1, 1.3, 1837, 878, 1067],
            [1, 1.3, 1767, 874, 971],
            [1, 1.3, 1237, 866, 771],
            [1, 1.3, 1155, 866, 798],
            [1, 1.3, 1041, 866, 836],
            [1, 1.3, 1426, 780, 1600],
            [1, 1.3, 1494, 780, 1589],
            [1, 1.3, 1596, 780, 1574],
        ],
    ),
    ColoredBananaGroup(
        group=58,
        map_id=Maps.JungleJapes,
        name="First tunnel (10 custom, 5 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [1, 1.0, 1720, 280, 304],
            [1, 1.0, 1892, 280, 350],
            [1, 1.0, 1935, 280, 429],
            [1, 1.0, 1942, 280, 587],
            [1, 1.0, 1938, 280, 679],
            [1, 1.0, 1825, 280, 798],
            [1, 1.0, 1747, 280, 833],
            [1, 1.0, 1612, 280, 899],
            [1, 1.0, 1562, 280, 975],
            [1, 1.0, 1540, 280, 1048],
            [1, 1.0, 1813.7471923828125, 280.0, 312.2469177246094],
            [1, 1.0, 1945.7630615234375, 280.0, 505.89013671875],
            [1, 1.0, 1905.5291748046875, 280.0, 730.7302856445312],
            [1, 1.0, 1681.521484375, 280.0, 854.2600708007812],
            [1, 1.0, 1527.8702392578125, 280.0, 1110.448486328125],
        ],
    ),
    ColoredBananaGroup(
        group=59,
        map_id=Maps.JungleJapes,
        name="Slopes to Diddy's cage (4 custom, 6 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        locations=[
            [1, 1.0, 1208, 853, 2470],
            [1, 1.0, 1135, 853, 2459],
            [1, 1.0, 2036, 680, 2452],
            [1, 1.0, 2110, 680, 2429],
            [1, 1.0, 1954.5941162109375, 693.497802734375, 2460.092041015625],
            [1, 1.0, 1893.33935546875, 735.526611328125, 2458.203857421875],
            [1, 1.0, 1838.3018798828125, 773.3711547851562, 2455.015380859375],
            [1, 1.0, 1268.203125, 842.512451171875, 2476.04638671875],
            [1, 1.0, 1319.424072265625, 823.2108764648438, 2484.031005859375],
            [1, 1.0, 1368.2606201171875, 804.18359375, 2489.451904296875],
        ],
    ),
    ColoredBananaGroup(
        group=60,
        map_id=Maps.JungleJapes,
        name="Rambi door to Fairy room (3 custom, 7 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        locations=[
            [1, 1.0, 1021.1161499023438, 276.7814025878906, 3326.481689453125],
            [1, 1.0, 802.2224731445312, 247.24327087402344, 3127.686279296875],
            [1, 1.0, 690.5912475585938, 240.0, 3026.909912109375],
            [1, 1.0, 1126.7506103515625, 280.0, 3390.576904296875],
            [1, 1.0, 908.964599609375, 262.55987548828125, 3231.682373046875],
        ],
    ),
    ColoredBananaGroup(
        group=60,
        map_id=Maps.JungleJapes,
        name="Rambi door to Fairy room (3 custom, 7 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[
            [1, 1.0, 1433, 274, 3204],
            [1, 1.0, 1500, 240, 3130],
            [1, 1.0, 1540, 219, 3083],
            [1, 1.0, 1248.1484375, 280.0, 3334.955078125],
            [1, 1.0, 1366.25244140625, 280.0, 3270.0556640625],
        ],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.JungleJapes,
        name="3 bunches on riverbed",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        logic=lambda l: l.swim,
        locations=[[5, 1.0, 1755, 170, 1856], [5, 1.0, 1620, 170, 1922], [5, 1.0, 1450, 170, 1866]],
    ),
    ColoredBananaGroup(
        group=62,
        map_id=Maps.JungleJapes,
        name="Next to Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        locations=[[5, 1.0, 2054, 690, 2566], [5, 1.0, 2274, 690, 2513]],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.JungleJapes,
        name="Diddy cave around exterior",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondPeanutGate,
        locations=[
            [1, 1.0, 2328, 280, 603],
            [1, 1.0, 2380, 280, 680],
            [1, 1.0, 2439, 280, 711],
            [1, 1.0, 2589, 280, 683],
            [1, 1.0, 2656, 280, 593],
            [1, 1.0, 2672, 280, 418],
            [1, 1.0, 2613, 280, 360],
            [1, 1.0, 2557, 280, 318],
            [1, 1.0, 2390, 280, 331],
            [1, 1.0, 2330, 280, 404],
        ],
    ),
    ColoredBananaGroup(
        group=64,
        map_id=Maps.JungleJapes,
        name="On the edge of Diddy's cage platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        locations=[
            [1, 1.0, 1204, 853, 2350],
            [1, 1.0, 1134, 853, 2300],
            [1, 1.0, 1041, 853, 2297],
            [1, 1.0, 929, 853, 2328],
            [1, 1.0, 907, 853, 2454],
        ],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.JungleJapes,
        name="Tiny's caged GB",
        konglist=[Kongs.tiny],
        region=Regions.JungleJapesMain,
        logic=lambda l: ((Events.JapesTinySwitch in l.Events or l.CanPhase() or l.CanPhaseswim() or l.CanSkew(False)) and l.tiny)
        or ((l.CanPhase() or l.CanPhaseswim() or l.CanSkew(False)) and l.settings.free_trade_items),
        locations=[[5, 1.0, 1335, 285, 1974], [5, 1.0, 1300, 285, 1946]],
    ),
    ColoredBananaGroup(
        group=66,
        map_id=Maps.JungleJapes,
        name="Lanky's caged GB",
        konglist=[Kongs.lanky],
        region=Regions.JapesCannonPlatform,
        logic=lambda l: ((Events.JapesLankySwitch in l.Events or l.CanSkew(False)) and l.lanky) or (l.CanSkew(False) and l.settings.free_trade_items),
        locations=[[5, 1.0, 1140, 525, 2346], [5, 1.0, 1186, 525, 2326]],
    ),
    ColoredBananaGroup(
        group=67,
        map_id=Maps.JungleJapes,
        name="T&S above diddy BP (2 custom, 1 Donkey bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesTnSAlcove,
        locations=[
            [5, 1.0, 801, 543, 2356],
            [5, 1.0, 729, 543, 2295],
            [5, 1.0, 774.623291015625, 543.0, 2313.9326171875],
        ],
    ),
    ColoredBananaGroup(
        group=68,
        map_id=Maps.JungleJapes,
        name="Diddy's Caged GB",
        konglist=[Kongs.diddy],
        region=Regions.JapesHill,
        logic=lambda l: ((Events.JapesDiddySwitch1 in l.Events or l.CanPhase() or l.generalclips or l.CanSkew(False)) and l.diddy)
        or ((l.CanPhase() or l.generalclips or l.CanSkew(False)) and l.settings.free_trade_items),
        locations=[[5, 1.0, 2305, 525, 2101], [5, 1.0, 2310, 525, 2142]],
    ),
    ColoredBananaGroup(
        group=69,
        map_id=Maps.JungleJapes,
        name="Chunky's Caged GB",
        konglist=[Kongs.chunky],
        region=Regions.JapesHillTop,
        logic=lambda l: ((Events.JapesChunkySwitch in l.Events or l.CanPhase() or l.CanSkew(False)) and l.chunky) or ((l.CanPhase() or l.CanSkew(False)) and l.settings.free_trade_items),
        locations=[[5, 1.0, 2335, 685, 2207], [5, 1.0, 2362, 685, 2253]],
    ),
    ColoredBananaGroup(
        group=70,
        map_id=Maps.JungleJapes,
        name="between vines from funky to cannon",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHill,
        logic=lambda l: l.can_use_vines,
        locations=[[5, 1.2, 1611, 565, 2099], [5, 1.2, 1524, 565, 2099]],
    ),
    ColoredBananaGroup(
        group=71,
        map_id=Maps.JungleJapes,
        name="Behind stump in beehive area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        locations=[[5, 1.0, 2014, 545, 3603], [5, 1.0, 1964, 545, 3527]],
    ),
    ColoredBananaGroup(
        group=72,
        map_id=Maps.JungleJapes,
        name="Above Melon Crate behind mountain",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        locations=[[5, 1.0, 1586, 844, 2619]],
    ),
    ColoredBananaGroup(
        group=73,
        map_id=Maps.JungleJapes,
        name="Above melon crate behind boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        locations=[[5, 1.0, 720, 335, 3755]],
    ),
    ColoredBananaGroup(
        group=74,
        map_id=Maps.JungleJapes,
        name="Inside Free Diddy cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        logic=lambda l: Events.JapesFreeKongOpenGates in l.Events,
        locations=[[5, 1.0, 1065, 858, 2608]],
    ),
    ColoredBananaGroup(
        group=75,
        map_id=Maps.JapesMountain,
        name="On box in corner of conveyor room (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        vanilla=True,
        logic=lambda l: l.CanSlamSwitch(Levels.JungleJapes, 1) or l.CanPhase(),
        locations=[[5, 1.0, 508.2171936035156, 223.6666717529297, 1352.9554443359375]],
    ),
    ColoredBananaGroup(
        group=76,
        map_id=Maps.JapesMountain,
        name="In river (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        vanilla=True,
        locations=[
            [1, 1.0, 688.837646484375, 30.5, 354.5293884277344],
            [1, 1.0, 703.2645874023438, 30.5, 471.5425720214844],
            [1, 1.0, 779.27734375, 30.5, 573.0369262695312],
            [1, 1.0, 702.5950317382812, 30.5, 257.4371643066406],
            [1, 1.0, 814.0119018554688, 30.5, 693.642333984375],
        ],
    ),
    ColoredBananaGroup(
        group=77,
        map_id=Maps.JapesMountain,
        name="On box by conveyors (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        vanilla=True,
        logic=lambda l: l.CanSlamSwitch(Levels.JungleJapes, 1),
        locations=[[5, 1.0, 190.0592041015625, 177.6666717529297, 794.992431640625]],
    ),
    ColoredBananaGroup(
        group=78,
        map_id=Maps.JapesMountain,
        name="In front of peanut switch (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        vanilla=True,
        locations=[[5, 1.0, 844.907958984375, 144.0, 440.0474548339844]],
    ),
    ColoredBananaGroup(
        group=79,
        map_id=Maps.JungleJapes,
        name="Between starting vines (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        vanilla=True,
        logic=lambda l: l.climbing and (l.can_use_vines or (l.monkey_maneuvers and l.isdonkey and (not l.isKrushaAdjacent(Kongs.donkey)))),
        locations=[
            [1, 1.0, 955.9228515625, 502.0, 701.2963256835938],
            [1, 1.0, 998.90185546875, 499.64178466796875, 587.4546508789062],
            [1, 1.0, 1074.3048095703125, 499.5419006347656, 474.2774353027344],
            [1, 1.0, 1179.1151123046875, 493.0, 377.6539001464844],
            [1, 1.0, 1287.278076171875, 491.0, 319.2526550292969],
        ],
    ),
    ColoredBananaGroup(
        group=80,
        map_id=Maps.JungleJapes,
        name="On top of slippery slope in BP cave (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.JapesUselessSlope,
        vanilla=True,
        locations=[[5, 1.0, 2211.646240234375, 338.8333435058594, 3205.997314453125]],
    ),
    ColoredBananaGroup(
        group=81,
        map_id=Maps.JungleJapes,
        name="W3 bunches (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        vanilla=True,
        locations=[
            [5, 1.0199999809265137, 2450.2275390625, 295.0, 1494.4775390625],
            [5, 1.0199999809265137, 1007.004638671875, 303.0, 2212.427490234375],
        ],
    ),
    ColoredBananaGroup(
        group=82,
        map_id=Maps.JungleJapes,
        name="Starting area (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        vanilla=True,
        locations=[
            [1, 1.0, 949.3571166992188, 280.0, 678.7673950195312],
            [1, 1.0, 981.5689086914062, 280.0, 546.8848266601562],
            [1, 1.0, 1055.2969970703125, 280.0, 424.2533264160156],
            [1, 1.0, 1216.241943359375, 280.0, 333.4804992675781],
            [1, 1.0, 1372.5592041015625, 280.0, 311.0032043457031],
        ],
    ),
    ColoredBananaGroup(
        group=83,
        map_id=Maps.JungleJapes,
        name="On Funky's shop (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        vanilla=True,
        locations=[
            [5, 1.0, 2025.6510009765625, 610.0, 2223.663818359375],
            [5, 1.0, 2083.292236328125, 610.0, 2194.638916015625],
        ],
    ),
    ColoredBananaGroup(
        group=84,
        map_id=Maps.JungleJapes,
        name="Under Lanky's bonus barrel in first cave (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.JapesBeyondPeanutGate,
        vanilla=True,
        logic=lambda l: l.grape or l.CanPhase() or l.generalclips,
        locations=[[5, 1.0, 2781.1533203125, 279.5493469238281, 505.9464416503906]],
    ),
    ColoredBananaGroup(
        group=85,
        map_id=Maps.JungleJapes,
        name="In Rambi hut (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        logic=lambda l: Events.Rambi in l.Events,
        locations=[[5, 1.0, 2007.12548828125, 315.0, 4295.62548828125]],
    ),
    ColoredBananaGroup(
        group=86,
        map_id=Maps.JungleJapes,
        name="In Rambi hut (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        logic=lambda l: Events.Rambi in l.Events,
        locations=[[5, 1.0, 1372.8516845703125, 315.0, 4290.01708984375]],
    ),
    ColoredBananaGroup(
        group=87,
        map_id=Maps.JungleJapes,
        name="In Rambi hut (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        logic=lambda l: Events.Rambi in l.Events,
        locations=[[5, 1.0, 1213.37646484375, 315.0, 3887.611083984375]],
    ),
    ColoredBananaGroup(
        group=88,
        map_id=Maps.JungleJapes,
        name="In Rambi hut (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        logic=lambda l: Events.Rambi in l.Events,
        locations=[[5, 1.0, 2173.53125, 315.0, 3889.4189453125]],
    ),
    ColoredBananaGroup(
        group=89,
        map_id=Maps.JungleJapes,
        name="On treetops (Tag barrel side) (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[
            [5, 1.0, 1476.8092041015625, 491.60882568359375, 1467.7108154296875],
            [5, 1.0, 1910.9310302734375, 493.4305419921875, 1433.4444580078125],
        ],
    ),
    ColoredBananaGroup(
        group=90,
        map_id=Maps.JungleJapes,
        name="Inside cage with Rambi Box (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.JapesRambi, False) or l.CanPhase(),
        locations=[[5, 1.0, 1703.5697021484375, 280.0, 4392.17626953125]],
    ),
    ColoredBananaGroup(
        group=91,
        map_id=Maps.JungleJapes,
        name="On 4 trees in Beehive area (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        vanilla=True,
        logic=lambda l: l.climbing and l.hunkyChunky,
        locations=[
            [5, 2.5199995040893555, 2255.0244140625, 721.3333129882812, 3265.194091796875],
            [5, 2.5199995040893555, 2441.914794921875, 721.3333129882812, 3198.7529296875],
            [5, 2.479999542236328, 2289.7763671875, 721.3333129882812, 3036.453125],
            [5, 2.4599990844726562, 2435.496337890625, 701.3333129882812, 3048.865966796875],
        ],
    ),
    ColoredBananaGroup(
        group=92,
        map_id=Maps.JungleJapes,
        name="On treetop by Funky (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHill,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 1261.9549560546875, 735.0, 1963.5047607421875]],
    ),
    ColoredBananaGroup(
        group=93,
        map_id=Maps.JungleJapes,
        name="On treetop by cannon (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCannonPlatform,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 1917.8856201171875, 735.0, 2069.986572265625]],
    ),
    ColoredBananaGroup(
        group=94,
        map_id=Maps.JungleJapes,
        name="Underwater bunches (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        logic=lambda l: l.swim,
        vanilla=True,
        locations=[
            [5, 1.1599998474121094, 1745.26123046875, 160.0, 2139.310791015625],
            [5, 1.1599998474121094, 1493.4852294921875, 169.0, 2128.995361328125],
        ],
    ),
    ColoredBananaGroup(
        group=95,
        map_id=Maps.JungleJapes,
        name="On treetops (Painting room side) (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[
            [5, 1.0, 923.9661254882812, 498.0, 1890.0908203125],
            [5, 1.0, 1047.989990234375, 498.0, 1698.77587890625],
        ],
    ),
    ColoredBananaGroup(
        group=96,
        map_id=Maps.JungleJapes,
        name="Beehive area, left stump (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.JapesBeyondFeatherGate,
        vanilla=True,
        logic=lambda l: l.mini or l.CanPhase(),
        locations=[
            [5, 0.820000171661377, 2627.54931640625, 539.3333129882812, 3379.966064453125],
            [5, 0.8400001525878906, 2613.385009765625, 539.3333129882812, 3436.143798828125],
            [5, 0.8000001907348633, 2571.215576171875, 539.3333129882812, 3459.748291015625],
        ],
    ),
    ColoredBananaGroup(
        group=97,
        map_id=Maps.JungleJapes,
        name="Beehive area, right stump (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.JapesBeyondFeatherGate,
        vanilla=True,
        logic=lambda l: l.mini or l.CanPhase(),
        locations=[
            [5, 0.940000057220459, 2449.49365234375, 539.3333129882812, 2743.213134765625],
            [5, 0.8000001907348633, 2400.892822265625, 539.6721801757812, 2742.846435546875],
            [5, 0.940000057220459, 2349.8798828125, 539.3333129882812, 2752.66015625],
        ],
    ),
    ColoredBananaGroup(
        group=98,
        map_id=Maps.JungleJapes,
        name="Diddy's cage treetop (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 1013.440673828125, 1067.333251953125, 2338.938720703125]],
    ),
    ColoredBananaGroup(
        group=99,
        map_id=Maps.JungleJapes,
        name="In front of beehive entrance (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        vanilla=True,
        locations=[[5, 1.0, 1982.4366455078125, 573.8333129882812, 2949.3994140625]],
    ),
    ColoredBananaGroup(
        group=100,
        map_id=Maps.JungleJapes,
        name="Under Tiny's bonus barrel in first cave (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.JapesBeyondPeanutGate,
        vanilla=True,
        logic=lambda l: l.feather or l.CanPhase(),
        locations=[[5, 1.0, 2491.140380859375, 282.0, 234.42022705078125]],
    ),
    ColoredBananaGroup(
        group=101,
        map_id=Maps.JungleJapes,
        name="Around boulder past rambi gate (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        vanilla=True,
        locations=[
            [1, 1.0, 744.34716796875, 280.0, 3697.9873046875],
            [1, 1.0, 763.0122680664062, 280.0, 3579.042236328125],
            [1, 1.0, 907.8800659179688, 280.0, 3628.865234375],
            [1, 1.0, 858.6558227539062, 280.0, 3709.218505859375],
            [1, 1.0, 850.2446899414062, 280.0, 3555.906005859375],
        ],
    ),
    ColoredBananaGroup(
        group=102,
        map_id=Maps.JungleJapes,
        name="Treetop by Snide's (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 2093.632080078125, 895.0, 2318.272705078125]],
    ),
    ColoredBananaGroup(
        group=103,
        map_id=Maps.JungleJapes,
        name="Around underground entrance (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        vanilla=True,
        locations=[
            [1, 1.0, 2213.2177734375, 280.0, 1301.9508056640625],
            [1, 1.0, 2307.995849609375, 280.0, 1126.1673583984375],
            [1, 1.0, 2483.420654296875, 280.0, 1124.5089111328125],
            [1, 1.0, 2537.809326171875, 280.0, 1248.4154052734375],
            [1, 1.0, 2478.657958984375, 280.0, 1389.1351318359375],
        ],
    ),
    ColoredBananaGroup(
        group=104,
        map_id=Maps.JungleJapes,
        name="On Cranky's Lab (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 1692.72265625, 400.0, 3996.624267578125]],
    ),
    ColoredBananaGroup(
        group=105,
        map_id=Maps.JungleJapes,
        name="Bunch by Snide's (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        vanilla=True,
        locations=[[5, 1.0, 2281.537841796875, 685.0, 2405.91015625]],
    ),
    ColoredBananaGroup(
        group=106,
        map_id=Maps.JapesLankyCave,
        name="On pillars (Lanky)",
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.JapesLankyCave,
        vanilla=True,
        locations=[
            [5, 1.0000004768371582, 59.64943313598633, 155.66665649414062, 305.0480041503906],
            [5, 1.0, 367.6960144042969, 155.66665649414062, 300.1766357421875],
        ],
    ),
    ColoredBananaGroup(
        group=107,
        map_id=Maps.JapesLankyCave,
        name="On steps (Lanky)",
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.JapesLankyCave,
        vanilla=True,
        locations=[
            [5, 1.0, 216.2335205078125, 80.66666412353516, 247.31024169921875],
            [5, 1.0, 220.2469482421875, 53.0, 166.40231323242188],
        ],
    ),
    ColoredBananaGroup(
        group=108,
        map_id=Maps.JapesUnderGround,
        name="Bunches on path (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCatacomb,
        vanilla=True,
        locations=[
            [5, 1.0, 978.025146484375, 20.0, 796.33984375],
            [5, 1.0, 700.1057739257812, 20.0, 854.5366821289062],
        ],
    ),
    ColoredBananaGroup(
        group=109,
        map_id=Maps.JapesBaboonBlast,
        name="Japes Baboon Blast (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.JapesBaboonBlast,
        vanilla=True,
        locations=[
            [5, 1.0999999046325684, 942.642578125, 792.0, 1061.586181640625],
            [5, 1.0, 2027.5482177734375, 773.0, 1545.3414306640625],
        ],
    ),
    ColoredBananaGroup(
        group=110,
        map_id=Maps.JungleJapes,
        name="Japes Rock bunch (Chunky)",  # Location inside the rock, or it can be spawned instead if we can
        konglist=[Kongs.chunky],
        region=Regions.BeyondRambiGate,
        vanilla=True,
        logic=lambda l: l.barrels,
        locations=[[5, 1.0, 823, 290, 3637]],
    ),
    # Wave 2 by Snap
    ColoredBananaGroup(
        group=111,
        map_id=Maps.JungleJapes,
        name="Above the bush push bush",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[[1, 1.0, 1071, 306, 672], [1, 1.0, 1071, 315, 672], [1, 1.0, 1071, 323, 672], [1, 1.0, 1071, 332, 672], [1, 1.0, 1071, 340, 672]],
    ),
    ColoredBananaGroup(
        group=112,
        map_id=Maps.JungleJapes,
        name="Start gate switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.JungleJapesStart,
        logic=lambda l: l.climbing and l.can_use_vines,
        locations=[[5, 1.0, 1486, 460, 299]],
    ),
    ColoredBananaGroup(
        group=113,
        map_id=Maps.JungleJapes,
        name="Peanut gate switches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [5, 1.0, 2237, 309, 430],
            [5, 1.0, 2224, 309, 590],
        ],
    ),
    ColoredBananaGroup(
        group=114,
        map_id=Maps.JungleJapes,
        name="Hive area gate switches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate1,
        locations=[
            [5, 1.0, 2698, 577, 2971],
            [5, 1.0, 2645, 577, 2854],
        ],
    ),
    ColoredBananaGroup(
        group=115,
        map_id=Maps.JungleJapes,
        name="Peanut cave T&S door frame",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondPeanutGate,
        locations=[[1, 1.0, 2451, 280, 730], [1, 1.0, 2466, 315, 730], [1, 1.0, 2489, 330, 730], [1, 1.0, 2512, 315, 730], [1, 1.0, 2525, 280, 730]],
    ),
    ColoredBananaGroup(
        group=116,
        map_id=Maps.JungleJapes,
        name="On the peanut cave torches",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.JapesBeyondPeanutGate,
        locations=[
            [5, 1.0, 2630, 360, 349],
            [5, 1.0, 2630, 360, 665],
        ],
    ),
    ColoredBananaGroup(
        group=117,
        map_id=Maps.JungleJapes,
        name="On the DK caged GB",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[[1, 1.0, 1515, 280, 1335], [1, 1.0, 1515, 280, 1384], [1, 1.0, 1470, 280, 1384], [1, 1.0, 1470, 280, 1335], [1, 1.0, 1493, 280, 1358]],
    ),
    ColoredBananaGroup(
        group=118,
        map_id=Maps.JungleJapes,
        name="Bumps near the river",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [1, 1.0, 1750, 294, 1512],
            [1, 1.0, 1750, 307, 1512],
            [1, 1.0, 1750, 321, 1512],
            [1, 1.0, 1750, 334, 1512],
            [1, 1.0, 1750, 347, 1512],
            [1, 1.0, 2206, 295, 1505],
            [1, 1.0, 2206, 308, 1505],
            [1, 1.0, 2206, 322, 1505],
            [1, 1.0, 2206, 335, 1505],
            [1, 1.0, 2206, 348, 1505],
        ],
    ),
    ColoredBananaGroup(
        group=119,
        map_id=Maps.JungleJapes,
        name="Other bumps near the river",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [1, 1.0, 1399, 295, 1400],
            [1, 1.0, 1399, 308, 1400],
            [1, 1.0, 1399, 322, 1400],
            [1, 1.0, 1399, 335, 1400],
            [1, 1.0, 1399, 348, 1400],
            [1, 1.0, 1963, 294, 1505],
            [1, 1.0, 1963, 307, 1505],
            [1, 1.0, 1963, 321, 1505],
            [1, 1.0, 1963, 334, 1505],
            [1, 1.0, 1963, 347, 1505],
        ],
    ),
    ColoredBananaGroup(
        group=120,
        map_id=Maps.JungleJapes,
        name="River surface",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [1, 1.0, 1691, 242, 1887],
            [1, 1.0, 1727, 242, 1837],
            [1, 1.0, 1727, 242, 1775],
            [1, 1.0, 1691, 242, 1725],
            [1, 1.0, 1632, 242, 1706],
            [1, 1.0, 1573, 242, 1725],
            [1, 1.0, 1537, 242, 1775],
            [1, 1.0, 1537, 242, 1837],
            [1, 1.0, 1573, 242, 1887],
            [1, 1.0, 1632, 242, 1906],
        ],
    ),
    ColoredBananaGroup(
        group=121,
        map_id=Maps.JungleJapes,
        name="Around first tree near minecart exit",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [1, 1.0, 1068, 288, 1803],
            [1, 1.0, 1092, 288, 1770],
            [1, 1.0, 1092, 288, 1730],
            [1, 1.0, 1068, 288, 1697],
            [1, 1.0, 1030, 288, 1685],
            [1, 1.0, 992, 288, 1697],
            [1, 1.0, 968, 288, 1730],
            [1, 1.0, 968, 288, 1770],
            [1, 1.0, 992, 288, 1803],
            [1, 1.0, 1030, 288, 1815],
        ],
    ),
    ColoredBananaGroup(
        group=122,
        map_id=Maps.JungleJapes,
        name="Around second tree near minecart exit",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[
            [1, 1.0, 944, 288, 1999],
            [1, 1.0, 968, 288, 1966],
            [1, 1.0, 968, 288, 1926],
            [1, 1.0, 944, 288, 1893],
            [1, 1.0, 906, 288, 1881],
            [1, 1.0, 868, 288, 1893],
            [1, 1.0, 844, 288, 1926],
            [1, 1.0, 844, 288, 1966],
            [1, 1.0, 868, 288, 1999],
            [1, 1.0, 906, 288, 2011],
        ],
    ),
    ColoredBananaGroup(
        group=123,
        map_id=Maps.JungleJapes,
        name="On minecart exit",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        locations=[[1, 1.0, 1080, 344, 1915], [1, 1.0, 1073, 345, 1927], [1, 1.0, 1067, 346, 1939], [1, 1.0, 1060, 345, 1951], [1, 1.0, 1054, 344, 1963]],
    ),
    ColoredBananaGroup(
        group=124, map_id=Maps.JungleJapes, name="Baboon blasting off !!", konglist=[Kongs.donkey], region=Regions.JapesBlastPadPlatform, logic=lambda l: l.blast, locations=[[5, 1.0, 2460, 700, 1148]]
    ),
    ColoredBananaGroup(
        group=125,
        map_id=Maps.JungleJapes,
        name="Around the cannon",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCannonPlatform,
        locations=[
            [1, 1.0, 1295, 520, 2135],
            [1, 1.0, 1276, 520, 2080],
            [1, 1.0, 1218, 520, 2080],
            [1, 1.0, 1199, 520, 2135],
            [1, 1.0, 1247, 520, 2170],
        ],
    ),
    ColoredBananaGroup(
        group=126,
        map_id=Maps.JungleJapes,
        name="Hive area next to left hollow stump",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        locations=[
            [1, 1.0, 2540, 539, 3374],
            [1, 1.0, 2531, 539, 3346],
            [1, 1.0, 2501, 539, 3346],
            [1, 1.0, 2492, 539, 3374],
            [1, 1.0, 2516, 539, 3391],
        ],
    ),
    ColoredBananaGroup(
        group=127,
        map_id=Maps.JungleJapes,
        name="Hive area next to right hollow stump",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        locations=[
            [1, 1.0, 2422, 539, 2865],
            [1, 1.0, 2413, 539, 2837],
            [1, 1.0, 2383, 539, 2837],
            [1, 1.0, 2374, 539, 2865],
            [1, 1.0, 2398, 539, 2882],
        ],
    ),
    ColoredBananaGroup(
        group=128,
        map_id=Maps.JungleJapes,
        name="On the bouncy mushroom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        locations=[[5, 1.0, 2061, 565, 3546]],
    ),
    ColoredBananaGroup(
        group=129,
        map_id=Maps.JungleJapes,
        name="Twirl from Funky",
        konglist=[Kongs.tiny],
        region=Regions.JapesHill,
        logic=lambda l: l.twirl,
        locations=[[1, 1.1, 1762, 549, 1966], [1, 1.1, 1715, 545, 1935], [1, 1.1, 1668, 537, 1905], [1, 1.1, 1618, 513, 1872], [1, 1.1, 1575, 469, 1844]],
    ),
    ColoredBananaGroup(
        group=130,
        map_id=Maps.JungleJapes,
        name="Across the river",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        locations=[[1, 1.0, 1297, 286, 1541], [1, 1.0, 1257, 293, 1576], [1, 1.0, 1217, 300, 1611], [1, 1.0, 1178, 294, 1645], [1, 1.0, 1138, 288, 1680]],
    ),
    ColoredBananaGroup(
        group=131,
        map_id=Maps.JungleJapes,
        name="Orangstand-able slope to cannon",
        konglist=[Kongs.lanky],
        region=Regions.JungleJapesMain,
        logic=lambda l: l.handstand,
        locations=[[1, 1.0, 1196, 316, 1834], [1, 1.0, 1202, 359, 1856], [1, 1.0, 1208, 402, 1878], [1, 1.0, 1213, 445, 1899], [1, 1.0, 1219, 488, 1921]],
    ),
    ColoredBananaGroup(
        group=132,
        map_id=Maps.JungleJapes,
        name="Torch near Diddy kasplat",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[5, 1.0, 881, 328, 2733]],
    ),
    ColoredBananaGroup(
        group=133,
        map_id=Maps.JungleJapes,
        name="Above upper big torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[5, 1.0, 1520, 315, 2591]],
    ),
    ColoredBananaGroup(
        group=134,
        map_id=Maps.JungleJapes,
        name="Above lower big torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[5, 1.0, 1739, 240, 3064]],
    ),
    ColoredBananaGroup(
        group=135,
        map_id=Maps.JungleJapes,
        name="Behind the Lanky slope bonus barrel",
        konglist=[Kongs.lanky],
        region=Regions.JapesBeyondCoconutGate2,
        logic=lambda l: l.handstand,
        locations=[[1, 1.0, 1751, 338, 2505], [1, 1.0, 1747, 338, 2441], [1, 1.0, 1815, 338, 2381], [1, 1.0, 1897, 338, 2375], [1, 1.0, 1934, 338, 2411]],
    ),
    ColoredBananaGroup(
        group=136,
        map_id=Maps.JungleJapes,
        name="Cranky area entrance sides",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[5, 1.0, 1825, 260, 3491], [5, 1.0, 1568, 256, 3479]],
    ),
    ColoredBananaGroup(
        group=137,
        map_id=Maps.JungleJapes,
        name="Flower near Rambi cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[1, 1.0, 1581, 290, 4326], [1, 1.0, 1581, 300, 4326], [1, 1.0, 1581, 310, 4326], [1, 1.0, 1581, 320, 4326], [1, 1.0, 1581, 330, 4326]],
    ),
    ColoredBananaGroup(
        group=138,
        map_id=Maps.JungleJapes,
        name="Flower near Lanky hut",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[1, 1.0, 1914, 290, 4380], [1, 1.0, 1914, 300, 4380], [1, 1.0, 1914, 310, 4380], [1, 1.0, 1914, 320, 4380], [1, 1.0, 1914, 330, 4380]],
    ),
    ColoredBananaGroup(
        group=139,
        map_id=Maps.JungleJapes,
        name="Flower near DK hut",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[1, 1.0, 1366, 290, 4218], [1, 1.0, 1366, 300, 4218], [1, 1.0, 1366, 310, 4218], [1, 1.0, 1366, 320, 4218], [1, 1.0, 1366, 330, 4218]],
    ),
    ColoredBananaGroup(
        group=140,
        map_id=Maps.JungleJapes,
        name="Flower near Diddy hut",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[1, 1.0, 1260, 290, 4008], [1, 1.0, 1260, 300, 4008], [1, 1.0, 1260, 310, 4008], [1, 1.0, 1260, 320, 4008], [1, 1.0, 1260, 330, 4008]],
    ),
    ColoredBananaGroup(
        group=141,
        map_id=Maps.JungleJapes,
        name="Flower near Tiny hut",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[1, 1.0, 2095, 290, 3783], [1, 1.0, 2095, 300, 3783], [1, 1.0, 2095, 310, 3783], [1, 1.0, 2095, 320, 3783], [1, 1.0, 2095, 330, 3783]],
    ),
    ColoredBananaGroup(
        group=142,
        map_id=Maps.JungleJapes,
        name="High against the Rambi door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        locations=[[5, 1.0, 1232, 330, 3340]],
    ),
    ColoredBananaGroup(
        group=143,
        map_id=Maps.JungleJapes,
        name="Rambi lake Bouldertech",  # Hard
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        logic=lambda l: l.chunky and l.barrels,
        locations=[[5, 1.2, 660, 340, 3003]],
    ),
    ColoredBananaGroup(
        group=144,
        map_id=Maps.JungleJapes,
        name="Rambi lake shore",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        locations=[
            [1, 1.0, 738, 240, 3045],
            [1, 1.0, 727, 240, 3012],
            [1, 1.0, 691, 240, 3012],
            [1, 1.0, 680, 240, 3045],
            [1, 1.0, 709, 240, 3066],
        ],
    ),
    ColoredBananaGroup(
        group=145,
        map_id=Maps.JapesMountain,
        name="Around the first post",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        locations=[
            [1, 1.0, 533, 40, 331],
            [1, 1.0, 521, 40, 292],
            [1, 1.0, 479, 40, 292],
            [1, 1.0, 467, 40, 331],
            [1, 1.0, 500, 40, 355],
        ],
    ),
    ColoredBananaGroup(
        group=146,
        map_id=Maps.JapesMountain,
        name="On the glitchy backflip spot",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        locations=[[1, 1.0, 485, 49, 195], [1, 1.0, 485, 60, 195], [1, 1.0, 485, 71, 195], [1, 1.0, 485, 82, 195], [1, 1.0, 485, 93, 195]],
    ),
    ColoredBananaGroup(group=147, map_id=Maps.JapesMountain, name="On the curved rail", konglist=[Kongs.diddy], region=Regions.Mine, locations=[[5, 1.0, 667, 145, 553]]),
    ColoredBananaGroup(group=148, map_id=Maps.JapesMountain, name="Jumping on the rails", konglist=[Kongs.diddy], region=Regions.Mine, locations=[[5, 1.0, 573, 170, 531], [5, 1.0, 689, 168, 625]]),
    ColoredBananaGroup(group=149, map_id=Maps.JapesMountain, name="Next to post near minecart entrance", konglist=[Kongs.diddy], region=Regions.Mine, locations=[[5, 1.0, 622, 105, 1388]]),
    ColoredBananaGroup(
        group=150,
        map_id=Maps.JapesMountain,
        name="Around the conveyor gate switch",
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        locations=[
            [1, 1.0, 522, 100, 1155],
            [1, 1.0, 508, 100, 1111],
            [1, 1.0, 460, 100, 1111],
            [1, 1.0, 446, 100, 1155],
            [1, 1.0, 484, 100, 1183],
        ],
    ),
    ColoredBananaGroup(
        group=151,
        map_id=Maps.JapesLankyCave,
        name="Entrance",
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.JapesLankyCave,
        locations=[
            [5, 1.0, 263, 30, 30],
            [5, 1.0, 156, 30, 30],
        ],
    ),
    ColoredBananaGroup(group=152, map_id=Maps.JapesTinyHive, name="Above the entrance", konglist=[Kongs.tiny], region=Regions.TinyHive, locations=[[5, 2.0, 1389, 270, 1647]]),
    ColoredBananaGroup(group=153, map_id=Maps.JapesTinyHive, name="White flower between doors 2 and 3", konglist=[Kongs.tiny], region=Regions.TinyHive, locations=[[5, 1.0, 1498, 252, 1260]]),
    ColoredBananaGroup(
        group=154,
        map_id=Maps.JapesUnderGround,
        name="Entrance stalagmite",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCatacomb,
        locations=[[5, 1.0, 519, 60, 155]],
    ),
    ColoredBananaGroup(
        group=155,
        map_id=Maps.JapesUnderGround,
        name="Entrance flames",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCatacomb,
        locations=[[5, 1.0, 710, 62, 196], [5, 1.0, 864, 62, 198]],
    ),
    ColoredBananaGroup(
        group=156,
        map_id=Maps.JapesUnderGround,
        name="Perilous jump above the void",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCatacomb,
        locations=[[1, 1.0, 812, 20, 729], [1, 1.0, 793, 32, 763], [1, 1.0, 775, 40, 798], [1, 1.0, 756, 32, 832], [1, 1.0, 738, 20, 866]],
    ),
]


BalloonList = [
    Balloon(
        id=1,
        map_id=Maps.JungleJapes,
        name="Starting area lower (DK portal side)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[800, 330, 720], [973, 325, 580], [861, 340, 471]],
    ),
    Balloon(
        id=2,
        map_id=Maps.JungleJapes,
        name="Starting area lower (gate side)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[1289, 360, 265], [1227, 350, 174], [1420, 360, 180]],
    ),
    Balloon(
        id=3,
        map_id=Maps.JungleJapes,
        name="Starting area upper (DK portal side)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[1057, 510, 769], [1049, 540, 972], [893, 520, 985]],
    ),
    Balloon(
        id=4,
        map_id=Maps.JungleJapes,
        name="Starting area upper (gate side)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[1422, 550, 179], [1198, 520, 169]],
    ),
    Balloon(
        id=5,
        map_id=Maps.JungleJapes,
        name="First tunnel 1 (gate side)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[1640, 345, 300], [1916, 340, 310], [1940, 350, 590], [1840, 320, 354]],
    ),
    Balloon(
        id=6,
        map_id=Maps.JungleJapes,
        name="First tunnel 2 (main area side)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[1910, 345, 758], [1613, 340, 900], [1531, 350, 1158], [1613, 340, 900]],
    ),
    Balloon(
        id=7,
        map_id=Maps.JungleJapes,
        name="Minecart exit",
        speed=2,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        points=[[1120, 305, 1956], [1109, 302, 1987]],
    ),
    Balloon(
        id=8,
        map_id=Maps.JungleJapes,
        name="Painting room peanut switch",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        points=[[575, 540, 1958], [560, 540, 1800]],
    ),
    Balloon(
        id=9,
        map_id=Maps.JungleJapes,
        name="Over river by middle switch",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[1460, 470, 2120], [1475, 340, 2105]],
    ),
    Balloon(
        id=10,
        map_id=Maps.JungleJapes,
        name="T&S portal above Diddy BP",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesTnSAlcove,
        points=[[781, 600, 2364], [725, 604, 2316]],
    ),
    Balloon(
        id=11,
        map_id=Maps.JungleJapes,
        name="Around mountain",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        points=[
            [1500, 900, 2555],
            [1652, 905, 2614],
            [1760, 895, 2516],
            [1780, 895, 2392],
            [1700, 890, 2293],
            [1557, 880, 2245],
            [1425, 890, 2407],
        ],
    ),
    Balloon(
        id=12,
        map_id=Maps.JungleJapes,
        name="In front of Diddy's cage",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        points=[[1187, 960, 2524], [989, 960, 2504]],
    ),
    Balloon(
        id=13,
        map_id=Maps.JungleJapes,
        name="Funky's Armory",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        points=[[2105, 595, 2091], [1920, 600, 2168]],
    ),
    Balloon(
        id=14,
        map_id=Maps.JungleJapes,
        name="Cannon to Diddy's cage",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCannonPlatform,
        points=[[1368, 625, 2076], [1289, 630, 2250], [1138, 630, 2207], [1150, 625, 2060]],
    ),
    Balloon(
        id=15,
        map_id=Maps.JungleJapes,
        name="Tunnel near DK BP",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate1,
        points=[[2918, 414, 2032], [2729, 399, 1989], [2571, 380, 1810], [2729, 399, 1989]],
    ),
    Balloon(
        id=16,
        map_id=Maps.JungleJapes,
        name="Tunnel near Tiny BP",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate1,
        points=[
            [2882, 555, 2843],
            [3097, 530, 2683],
            [3144, 490, 2404],
            [3081, 460, 2182],
            [3144, 490, 2404],
            [3097, 530, 2683],
        ],
    ),
    Balloon(
        id=17,
        map_id=Maps.JungleJapes,
        name="Near high W2 above river",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        points=[[1350, 900, 1950], [1650, 900, 1900]],
    ),
    Balloon(
        id=18,
        map_id=Maps.JungleJapes,
        name="Above river by tag barrel",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[1190, 375, 1592], [1350, 385, 1745], [1505, 380, 1705]],
    ),
    Balloon(
        id=19,
        map_id=Maps.JungleJapes,
        name="Over river by big vine",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        points=[[2235, 355, 1825], [2089, 350, 1675], [1900, 360, 1720]],
    ),
    Balloon(
        id=20,
        map_id=Maps.JungleJapes,
        name="Beehive area between trees",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        points=[[2410, 620, 3275], [2200, 624, 3160], [2446, 630, 3134], [2295, 620, 3284], [2325, 624, 3040]],
    ),
    Balloon(
        id=21,
        map_id=Maps.JungleJapes,
        name="Above beehive",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        points=[[1800, 730, 2936], [1947, 730, 2828], [1780, 750, 2815]],
    ),
    Balloon(
        id=22,
        map_id=Maps.JungleJapes,
        name="Above stump",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        points=[[2040, 650, 3576], [1977, 640, 3510]],
    ),
    Balloon(
        id=23,
        map_id=Maps.JungleJapes,
        name="Above vines next to BBlast",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBlastPadPlatform,
        points=[[2284, 660, 1197], [2224, 610, 1430]],
    ),
    Balloon(
        id=24,
        map_id=Maps.JungleJapes,
        name="Between trees in front of painting room",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        points=[
            [1085, 375, 1672],
            [1071, 370, 1810],
            [834, 380, 1901],
            [909, 375, 2048],
            [990, 370, 1955],
            [954, 380, 1730],
        ],
    ),
    Balloon(
        id=25,
        map_id=Maps.JungleJapes,
        name="Near main Tag Barrel",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[2100, 360, 1505], [1909, 370, 1376], [1675, 375, 1440], [1909, 370, 1376]],
    ),
    Balloon(
        id=26,
        map_id=Maps.JungleJapes,
        name="Above hole by Diddy BP (BP side)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        points=[[1344, 340, 2653], [1022, 340, 2664]],
    ),
    Balloon(
        id=27,
        map_id=Maps.JungleJapes,
        name="Above hole by Diddy BP (wall side)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        points=[[1284, 340, 2544], [908, 340, 2550]],
    ),
    Balloon(
        id=28,
        map_id=Maps.JungleJapes,
        name="Between beaver and rambi door",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        points=[[1543, 270, 3066], [1430, 325, 3266], [1239, 330, 3298], [1430, 325, 3266]],
    ),
    Balloon(
        id=29,
        map_id=Maps.JungleJapes,
        name="Above slope to Cranky",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        points=[[1610, 350, 3458], [1750, 355, 3470]],
    ),
    Balloon(
        id=30,
        map_id=Maps.JapesTinyHive,
        name="Around final room",
        speed=4,
        konglist=[Kongs.tiny],
        region=Regions.TinyHive,
        logic=lambda l: (l.CanSlamSwitch(Levels.JungleJapes, 1) and (l.saxophone or l.oranges)) and l.istiny,
        points=[
            [2037, 450, 1415],
            [2205, 455, 1200],
            [2394, 460, 1200],
            [2515, 460, 1378],
            [2402, 455, 1571],
            [2191, 450, 1583],
        ],
    ),
    Balloon(
        id=31,
        map_id=Maps.JapesMountain,
        name="First room above river",
        speed=3,
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        points=[[688, 140, 331], [776, 150, 565], [884, 155, 782]],
    ),
    Balloon(
        id=32,
        map_id=Maps.JapesUnderGround,
        name="Left side",
        speed=2,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCatacomb,
        points=[[970, 85, 545], [1078, 80, 981], [809, 80, 722]],
    ),
    Balloon(
        id=33,
        map_id=Maps.JapesUnderGround,
        name="Right (inner) side",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCatacomb,
        points=[[737, 80, 549], [735, 80, 690], [857, 60, 888]],
    ),
    Balloon(
        id=34,
        map_id=Maps.JapesMountain,
        name="In conveyor room (Diddy)",
        speed=3,
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        vanilla=True,
        logic=lambda l: l.CanSlamSwitch(Levels.JungleJapes, 1) or l.CanPhase(),
        points=[[174, 226, 1124], [193, 224, 991], [298, 228, 875]],
    ),
    Balloon(
        id=35,
        map_id=Maps.JungleJapes,
        name="In first cave (Diddy)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondPeanutGate,
        vanilla=True,
        points=[[2548, 342, 431], [2550, 340, 624]],
    ),
    Balloon(
        id=36,
        map_id=Maps.JungleJapes,
        name="In front of Snide's (Donkey)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        vanilla=True,
        points=[[2192, 740, 2428], [2075, 738, 2471]],
    ),
    Balloon(
        id=37,
        map_id=Maps.JungleJapes,
        name="In boulder cave 1 (Chunky)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        vanilla=True,
        points=[[844, 346, 3742], [715, 346, 3669]],
    ),
    Balloon(
        id=38,
        map_id=Maps.JungleJapes,
        name="Behind Rambi hut (Lanky)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        points=[[2102, 354, 4298], [2067, 350, 4360], [1981, 352, 4388]],
    ),
    Balloon(
        id=39,
        map_id=Maps.JungleJapes,
        name="Above mountain (Diddy)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesTopOfMountain,
        vanilla=True,
        points=[[1656, 1071, 2474], [1576, 1077, 2474]],
    ),
    Balloon(
        id=40,
        map_id=Maps.JungleJapes,
        name="Under baboon blast pad (Donkey)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        vanilla=True,
        points=[[2329, 346, 1215], [2427, 342, 1156], [2475, 342, 1284]],
    ),
    Balloon(
        id=41,
        map_id=Maps.JungleJapes,
        name="In front of Cranky (Donkey)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        points=[[1743, 342, 3868], [1610, 342, 3879]],
    ),
    Balloon(
        id=42,
        map_id=Maps.JungleJapes,
        name="Behind Rambi hut (Tiny)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        points=[[2236, 350, 3841], [2241, 342, 3947]],
    ),
    Balloon(
        id=43,
        map_id=Maps.JungleJapes,
        name="In fairy room (Tiny)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        vanilla=True,
        points=[[339, 278, 2869], [400, 274, 2784], [506, 270, 2712]],
    ),
    Balloon(
        id=44,
        map_id=Maps.JungleJapes,
        name="In boulder cave 2 (Chunky)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        vanilla=True,
        points=[[918, 336, 3672], [819, 334, 3748]],
    ),
    Balloon(
        id=45,
        map_id=Maps.JungleJapes,
        name="In boulder cave 3 (Chunky)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        vanilla=True,
        points=[[720, 348, 3638], [777, 348, 3556]],
    ),
    Balloon(
        id=46,
        map_id=Maps.JungleJapes,
        name="In Lanky blueprint room (Lanky)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        vanilla=True,
        points=[[1997, 316, 2754], [2053, 331, 2920]],
    ),
    Balloon(
        id=47,
        map_id=Maps.JapesTinyHive,
        name="In first room (Tiny)",
        speed=2,
        konglist=[Kongs.tiny],
        region=Regions.TinyHive,
        vanilla=True,
        points=[[512, 205, 1510], [506, 207, 1361]],
    ),
    Balloon(
        id=48,
        map_id=Maps.JapesLankyCave,
        name="In painting room (Lanky)",
        speed=3,
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.JapesLankyCave,
        vanilla=True,
        points=[[162, 179, 75], [252, 181, 71]],
    ),
    # Wave 2 by Snap
    Balloon(
        id=49,
        map_id=Maps.JungleJapes,
        name="Peanut cage",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[2198, 325, 499], [2203, 420, 507], [2160, 360, 565], [2195, 434, 454]],
    ),
    Balloon(
        id=50,
        map_id=Maps.JungleJapes,
        name="DK's caged GB",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[1492, 340, 1360], [1492, 190, 1360]],
    ),
    Balloon(
        id=51,
        map_id=Maps.JungleJapes,
        name="Hive tunnel coconut switch",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesStart,
        points=[[2500, 407, 1626], [2436, 407, 1691]],
    ),
    Balloon(
        id=52,
        map_id=Maps.JungleJapes,
        name="Above the river near Funky",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHill,
        points=[[2221, 609, 1880], [2113, 565, 1826], [2157, 777, 1898]],
    ),
    Balloon(
        id=53,
        map_id=Maps.JungleJapes,
        name="Hillside coconut switch",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesMain,
        points=[[865, 400, 2259], [785, 400, 2198]],
    ),
    Balloon(
        id=54,
        map_id=Maps.JungleJapes,
        name="Between cannon and alcove",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesCannonPlatform,
        points=[[988, 536, 2252], [962, 680, 2194], [917, 515, 2061], [885, 530, 2190]],
    ),
    Balloon(
        id=55,
        map_id=Maps.JungleJapes,
        name="Above Diddy's cage",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        points=[[1161, 900, 2562], [1079, 969, 2551], [987, 900, 2531], [1079, 969, 2551], [1161, 900, 2562]],
    ),
    Balloon(
        id=56,
        map_id=Maps.JungleJapes,
        name="Up high near Snide",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesHillTop,
        points=[[2314, 730, 2421], [2289, 810, 2474], [2282, 910, 2393], [2272, 1078, 2432]],
    ),
    Balloon(
        id=57,
        map_id=Maps.JungleJapes,
        name="Hive area entrance",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondFeatherGate,
        points=[[2560, 638, 2891], [2634, 635, 3018], [2558, 550, 2957]],
    ),
    Balloon(
        id=58,
        map_id=Maps.JungleJapes,
        name="Stormy tunnel towards Cranky",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        points=[[1424, 290, 2730], [1590, 260, 2770], [1500, 240, 2904], [1664, 220, 2928], [1500, 240, 2904], [1590, 260, 2770], [1424, 290, 2730]],
    ),
    Balloon(
        id=59,
        map_id=Maps.JungleJapes,
        name="Tree between DK and Diddy's huts",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        points=[[1469, 280, 3979], [1402, 333, 3946], [1374, 385, 4076], [1504, 434, 4012], [1389, 400, 3951], [1384, 351, 4076]],
    ),
    Balloon(
        id=60,
        map_id=Maps.JungleJapes,
        name="Above the Rambi cage",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JapesBeyondCoconutGate2,
        points=[[1700, 363, 4319], [1726, 406, 4331], [1671, 420, 4335]],
    ),
    Balloon(
        id=61,
        map_id=Maps.JungleJapes,
        name="In the Rambi lake",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondRambiGate,
        points=[[420, 148, 2866], [426, 143, 2763], [525, 143, 2774]],
    ),
    Balloon(
        id=62,
        map_id=Maps.JapesMountain,
        name="Little tunnel",
        speed=5,
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        points=[[786, 74, 899], [715, 131, 1025]],
    ),
    Balloon(
        id=63,
        map_id=Maps.JapesMountain,
        name="Around post under the minecart track",
        speed=10,
        konglist=[Kongs.diddy],
        region=Regions.Mine,
        points=[[535, 177, 1317], [488, 127, 1334], [486, 188, 1389], [549, 120, 1376]],
    ),
    Balloon(
        id=64,
        map_id=Maps.JapesLankyCave,
        name="Around the painting",
        speed=7,
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.JapesLankyCave,
        points=[[272, 80, 400], [140, 80, 399], [132, 180, 375], [264, 180, 381]],
    ),
    Balloon(
        id=65,
        map_id=Maps.JapesTinyHive,
        name="Second room",
        speed=7,
        konglist=[Kongs.tiny],
        region=Regions.TinyHive,
        points=[[1275, 230, 679], [1380, 265, 681], [1477, 230, 674], [1380, 265, 681], [1275, 230, 679]],
    ),
]
