"""
Generated file, do not edit manually.

See https://github.com/Satisha10/APworld_wotw_extractors for the code.
Generated with `extract_rules.py`.
"""


from .RulesFunctions import *
from worlds.generic.Rules import add_rule

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from . import WotWWorld


def set_moki_rules(w: "WotWWorld"):
    """Moki (or easy, default) rules."""
    p = w.player
    o = w.options
    add_rule(w.get_entrance("HeaderStates -> SkipKwolok"), lambda s: s.has("Impossible", p), "or")
    add_rule(w.get_entrance("HeaderStates -> SkipMora1"), lambda s: s.has("Impossible", p), "or")
    add_rule(w.get_entrance("HeaderStates -> SkipMora2"), lambda s: s.has("Impossible", p), "or")
    add_rule(w.get_entrance("Teleporters -> MidnightBurrows.Teleporter"), lambda s: s.has_all(("Midnight Burrows TP", "Bash"), p) and can_enter_area("MidnightBurrows", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> MarshSpawn.Main"), lambda s: s.has("Inkwater Marsh TP", p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> HowlsDen.Teleporter"), lambda s: s.has("Howl's Den TP", p) and can_enter_area("HowlsDen", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> EastHollow.Teleporter"), lambda s: s.has("Kwolok's Hollow TP", p) and can_enter_area("EastHollow", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> GladesTown.Teleporter"), lambda s: s.has("Glades TP", p) and can_enter_area("GladesTown", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> InnerWellspring.Teleporter"), lambda s: s.has("Wellspring TP", p) and can_enter_area("InnerWellspring", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> WoodsEntry.Teleporter"), lambda s: s.has("Woods Entrance TP", p) and can_enter_area("WoodsEntry", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> WoodsMain.Teleporter"), lambda s: s.has("Woods Exit TP", p) and can_enter_area("WoodsMain", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> LowerReach.Teleporter"), lambda s: s.has_all(("Baur's Reach TP", "Flap"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> UpperDepths.Teleporter"), lambda s: s.has_all(("Mouldwood Depths TP", "Glide"), p) and can_enter_area("UpperDepths", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> EastPools.Teleporter"), lambda s: s.has_all(("Central Luma TP", "Clean Water"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> WestPools.Teleporter"), lambda s: s.has_all(("Luma Boss TP", "Clean Water"), p) and can_enter_area("WestPools", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> LowerWastes.WestTP"), lambda s: s.has("Feeding Grounds TP", p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> LowerWastes.EastTP"), lambda s: s.has_all(("Central Wastes TP", "Burrow"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> UpperWastes.NorthTP"), lambda s: s.has_all(("Outer Ruins TP", "Burrow"), p) and can_enter_area("UpperWastes", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> WindtornRuins.RuinsTP"), lambda s: s.has_all(("Inner Ruins TP", "Burrow", "EastHollow.ForestsVoice", "LowerReach.ForestsMemory", "UpperDepths.ForestsEyes", "WestPools.ForestsStrength"), p) and can_enter_area("WindtornRuins", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> WillowsEnd.InnerTP"), lambda s: s.has_all(("Willow's End TP", "Burrow"), p) and can_enter_area("WillowsEnd", s, p, o), "or")
    add_rule(w.get_entrance("Teleporters -> WillowsEnd.ShriekArena"), lambda s: s.has_all(("Shriek TP", "Burrow"), p) and can_enter_area("WillowsEnd", s, p, o), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> F.MarshSpawn.Main"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.FirstPickupEX"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.GrappleHC"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.BridgeEX"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.BridgeEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.Main", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.LeftSpawnSignpost"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.OpherBarrier"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> C.MarshSpawn.OpherBarrier"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.ToOpherBarrier"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "MarshSpawn.OpherBarrier", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.LogBroken"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.BridgeEX"), lambda s: s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshPastOpher.MillView"), lambda s: s.has("MarshSpawn.ToOpherBarrier", p) and can_enter_area("MarshPastOpher", s, p, o), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.BrokenBridge"), lambda s: s.has("MarshSpawn.LogBroken", p), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.Main"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.Main"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.OpherBarrier", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> C.MarshSpawn.BrokenBridge"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.ResilienceShard"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "MarshSpawn.BrokenBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.ResilienceOre"), lambda s: s.has("Clean Water", p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "MarshSpawn.BrokenBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.BashEC"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.PreLupoEX"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.LupoMap"), lambda s: can_buy_map(s, p), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.CaveEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.OpherBarrier"), lambda s: s.has("MarshSpawn.LogBroken", p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.OpherBarrier"), lambda s: s.has_all(("MarshSpawn.LogBroken", "Bash"), p) and s.has("HowlsDen.RainLifted", p), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.OpherBarrier"), lambda s: s.has_all(("MarshSpawn.LogBroken", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "MarshSpawn.BrokenBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> C.MarshSpawn.CaveEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.KeystoneDoor"), lambda s: can_open_door("MarshSpawn.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.TokkBarrier"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "MarshSpawn.CaveEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.LeverEC"), lambda s: s.has_all(("Grapple", "Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.LeverEC"), lambda s: s.has_all(("Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.LeverEC"), lambda s: s.has_all(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.LeverEC"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.CaveEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.RegenDoor"), lambda s: s.has("MarshSpawn.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.BrokenBridge"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.BrokenBridge"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.CaveEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.Cave"), lambda s: s.has("MarshSpawn.TokkBarrier", p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> C.MarshSpawn.Cave"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> H.MarshSpawn.Cave"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.CaveFight"), lambda s: has_enough_resources([('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'Lizard')], [], "MarshSpawn.Cave", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.CaveKS"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.CaveKS"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Grapple"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.CaveKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.CaveKS"), lambda s: s.has("MarshSpawn.CaveFight", p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.TokkKeystoneQuest"), lambda s: s.has("MarshSpawn.CaveKS", p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.LeftTokkEX"), lambda s: has_enough_resources([('wall', ('BreakWall', 10))], [], "MarshSpawn.Cave", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.FightRoomEX"), lambda s: has_enough_resources([('wall', ('BreakWall', 10))], [], "MarshSpawn.Cave", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> Tokk"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.CaveEntrance"), lambda s: s.has("MarshSpawn.TokkBarrier", p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.Cave", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("MarshSpawn.CaveFight", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has_all(("MarshSpawn.CaveFight", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.Cave", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> H.MarshSpawn.BurrowFightArena"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.BurrowArena"), lambda s: s.has("Regenerate", p) and has_enough_resources([('db', 40), ('combat', 'Hornbug'), ('combat', 'Bat'), ('combat', 'Sandworm'), ('combat', 'Sandworm'), ('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'SneezeSlug')], [], "MarshSpawn.BurrowFightArena", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.BurrowOre"), lambda s: s.has_all(("Burrow", "Double Jump", "Bash"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.BurrowOre"), lambda s: s.has_all(("Burrow", "Double Jump", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "MarshSpawn.BurrowFightArena", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.BurrowOre"), lambda s: s.has_all(("Burrow", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.LifepactLedge"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.LeftSpawnSignpost"), lambda s: s.has_all(("Clean Water", "Burrow", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.LeftSpawnSignpost"), lambda s: s.has_all(("Clean Water", "Burrow", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.LifepactShard"), lambda s: s.has("MarshSpawn.BurrowArena", p), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.BurrowFightArena"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.BurrowFightArena"), lambda s: s.has_all(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.BurrowFightArena"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.BurrowFightArena"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.LifepactLedge", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> C.MarshSpawn.PoolsBurrowsSignpost"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.CaveKS"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.CaveOre"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.CaveOre"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.PoolsBurrowsSignpost", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.BurrowsApproachLedgeEX"), lambda s: s.has_all(("Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.BeforeBurrows"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.Cave"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.LifepactLedge"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> C.MarshSpawn.BeforeBurrows"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.CrusherSwimEX"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsApproachLedgeEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("Clean Water", "Water Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.BeforeBurrows", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsEntry"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has_all(("Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> C.MarshSpawn.BurrowsEntry"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BurrowsOpen"), lambda s: s.has_all(("Bash", "Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BurrowsOpen"), lambda s: s.has_all(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.DamageTreeOpen"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.TokkTabletQuest"), lambda s: s.has("MidnightBurrows.TabletQI", p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.DamageTree"), lambda s: s.has("MarshSpawn.DamageTreeOpen", p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> Tokk"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MidnightBurrows.Teleporter"), lambda s: s.has("MarshSpawn.BurrowsOpen", p) and can_enter_area("MidnightBurrows", s, p, o), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BeforeBurrows"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BeforeBurrows"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BeforeBurrows"), lambda s: s.has("Clean Water", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BeforeBurrows"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> C.MarshSpawn.LeftSpawnSignpost"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.RockHC"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.LongSwimEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.BurrowOre"), lambda s: s.has_all(("Clean Water", "Burrow", "Bash"), p) and s.has_any(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.BurrowOre"), lambda s: s.has_all(("Clean Water", "Burrow", "Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.LeftSpawnSignpost", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.Main"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.PoolsPath"), lambda s: s.has_all(("Double Jump", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.PoolsPath"), lambda s: s.has_all(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.BurrowFightArena"), lambda s: s.has_all(("Clean Water", "Burrow"), p) and s.has_any(("Double Jump", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.BurrowFightArena"), lambda s: s.has_all(("Clean Water", "Burrow", "Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.LeftSpawnSignpost", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> C.MarshSpawn.PoolsPath"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.WheelWall"), lambda s: s.has_all(("Clean Water", "Water Breath", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.WheelFreed"), lambda s: s.has_all(("PoolsApproach.WheelWall", "Clean Water", "Water Breath", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.PoolsPathEX"), lambda s: s.has_all(("Double Jump", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.PoolsPathEX"), lambda s: s.has_all(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and s.has_any(("PoolsApproach.WheelFreed", "Double Jump", "Launch"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Water Breath"), p) and s.has_any(("PoolsApproach.WheelFreed", "Double Jump", "Launch"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Bash"), p) and s.has_any(("Water Breath", "Water Dash"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.PoolsPath", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.LeftSpawnSignpost"), lambda s: s.has("Clean Water", p) and s.has_any(("Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.LeftSpawnSignpost"), lambda s: s.has("Glide", p) and s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.RegenDoor -> MarshSpawn.KeystoneDoor"), lambda s: can_open_door("MarshSpawn.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("MarshSpawn.RegenDoor -> MarshSpawn.RegenTree"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.RegenDoor -> MarshSpawn.CaveEntrance"), lambda s: s.has("MarshSpawn.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("MarshSpawn.RegenDoor -> MarshSpawn.HowlApproach"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.RegenDoor -> MarshSpawn.HowlApproach"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.RegenDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.RegenDoor -> MarshSpawn.HowlApproach"), lambda s: s.has("Water Dash", p), "or")
    add_rule(w.get_entrance("MarshSpawn.HowlApproach -> C.MarshSpawn.HowlApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.HowlApproach -> MarshSpawn.HowlBurnt"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.HowlApproach -> MarshSpawn.RegenTree"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.HowlApproach -> MarshSpawn.RecklessShard"), lambda s: has_enough_resources([('wall', ('BreakWall', 10))], [], "MarshSpawn.HowlApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.HowlApproach -> MarshSpawn.RegenDoor"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.HowlApproach -> MarshSpawn.RegenDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.HowlApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.HowlApproach -> MarshSpawn.MokkTheBrave"), lambda s: s.has("MarshSpawn.HowlBurnt", p), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.HowlBurnt"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.MokkFangQuest"), lambda s: s.has_all(("MarshSpawn.HowlBurnt", "MarshSpawn.FangQI"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.RecklessShard"), lambda s: s.has_all(("MarshSpawn.HowlBurnt", "Bash"), p) and has_enough_resources([('wall', ('BreakWall', 10)), ('energy', ('Grenade', 1))], [], "MarshSpawn.MokkTheBrave", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.HowlsDenEntrance"), lambda s: s.has("MarshSpawn.HowlBurnt", p), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.HowlApproach"), lambda s: s.has("MarshSpawn.HowlBurnt", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.HowlApproach"), lambda s: s.has_all(("MarshSpawn.HowlBurnt", "HowlsDen.RainLifted", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.MokkTheBrave", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.HowlApproach"), lambda s: s.has_all(("MarshSpawn.HowlBurnt", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "MarshSpawn.MokkTheBrave", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.AboveHowlArena"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.AboveHowlArena"), lambda s: s.has("HowlsDen.RainLifted", p) and s.has_any(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> C.MarshSpawn.AboveHowlArena"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> H.MarshSpawn.AboveHowlArena"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> MarshSpawn.FangEC"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> MarshSpawn.FangEC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> MarshSpawn.MokkTheBrave"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> MarshSpawn.FangPlatform"), lambda s: s.has_any(("Launch", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> MarshSpawn.FangPlatform"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.AboveHowlArena", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshSpawn.FangPlatform -> H.MarshSpawn.FangPlatform"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.FangPlatform -> MarshSpawn.FangQI"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.FangPlatform -> MarshSpawn.AboveHowlArena"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.HowlsDenEntrance -> MarshSpawn.MokkEX"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshSpawn.HowlsDenEntrance -> HowlsDen.AboveBoneBridge"), lambda s: can_enter_area("HowlsDen", s, p, o), "or")
    add_rule(w.get_entrance("MarshSpawn.HowlsDenEntrance -> MarshSpawn.MokkTheBrave"), lambda s: s.has("MarshSpawn.HowlBurnt", p) and s.has_any(("Double Jump", "Dash", "Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> C.HowlsDen.UpperLoopExit"), lambda s: s.has("HowlsDen.UpperLoopExitBarrier", p), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> H.HowlsDen.UpperLoopExit"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> HowlsDen.UpperLoopExitBarrier"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "HowlsDen.UpperLoopExit", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> HowlsDen.RightHC"), lambda s: s.has_any(("Bash", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "HowlsDen.UpperLoopExit", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> HowlsDen.RightHC"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [('combat', 'Slug')], "HowlsDen.UpperLoopExit", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> MarshSpawn.HowlsDenEntrance"), lambda s: s.has("HowlsDen.UpperLoopExitBarrier", p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> HowlsDen.AboveBoneBridge"), lambda s: s.has("HowlsDen.UpperLoopExitBarrier", p) and s.has_any(("Launch", "Glide", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("HowlsDen.AboveBoneBridge -> C.HowlsDen.AboveBoneBridge"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.AboveBoneBridge -> HowlsDen.UpperLoopEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.AboveBoneBridge -> MarshSpawn.HowlsDenEntrance"), lambda s: s.has("Launch", p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> C.HowlsDen.UpperLoopEntrance"), lambda s: s.has("HowlsDen.UpperLoopEntranceBarrier", p), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.UpperLoopEntranceBarrier"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "HowlsDen.UpperLoopEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.RightHC"), lambda s: s.has("HowlsDen.UpperLoopEntranceBarrier", p) and s.has_any(("Bash", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "HowlsDen.UpperLoopEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.RightHC"), lambda s: s.has("HowlsDen.UpperLoopEntranceBarrier", p) and has_enough_resources([('wall', ('BreakWall', 20))], [('combat', 'Slug')], "HowlsDen.UpperLoopEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.BoneBridge"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.AboveBoneBridge"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.AboveBoneBridge"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.UpperLoopEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.UpperLoopExit"), lambda s: s.has("HowlsDen.UpperLoopEntranceBarrier", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Slug')], [], "HowlsDen.UpperLoopEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.UpperLoopExit"), lambda s: s.has_all(("HowlsDen.UpperLoopEntranceBarrier", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> C.HowlsDen.BoneBridge"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.KeystoneDoor"), lambda s: can_open_door("HowlsDen.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.RainLifted"), lambda s: s.has("HowlsDen.SwordTree", p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.BoneBarrier"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "HowlsDen.BoneBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.SwordTree"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.BoneOre"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.BoneOre"), lambda s: has_enough_resources([('combat', 'Mantis'), ('combat', 'Slug'), ('energy', ('Spear', 1))], [], "HowlsDen.BoneBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.AboveDoorKS"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.MagnetShard"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "HowlsDen.BoneBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.MagnetShard"), lambda s: has_enough_resources([('wall', ('BreakWall', 10))], [('wall', ('BreakWall', 16))], "HowlsDen.BoneBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.AboveTPEX"), lambda s: s.has("HowlsDen.BoneBarrier", p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "HowlsDen.BoneBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.BoneBridgeDoor"), lambda s: s.has("HowlsDen.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.AboveTeleporter"), lambda s: s.has("HowlsDen.BoneBarrier", p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridgeDoor -> C.HowlsDen.BoneBridgeDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridgeDoor -> HowlsDen.KeystoneDoor"), lambda s: can_open_door("HowlsDen.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridgeDoor -> HowlsDen.BoneBridge"), lambda s: s.has("HowlsDen.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridgeDoor -> HowlsDen.OutsideSecretRoom"), lambda s: s.has_any(("Clean Water", "Launch", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.SecretRoomWall"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "HowlsDen.OutsideSecretRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has("HowlsDen.SecretRoomWall", p), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.BoneBridgeDoor"), lambda s: s.has_any(("Clean Water", "Launch", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has("Double Jump", p) and has_enough_resources([('combat', 'Slug')], [], "HowlsDen.OutsideSecretRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.OutsideSecretRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [('energy', ('Grenade', 1))], "HowlsDen.OutsideSecretRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> H.HowlsDen.MidwayBottomLoop"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.OutsideSecretRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "HowlsDen.MidwayBottomLoop", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: s.has("Double Jump", p) and s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "HowlsDen.MidwayBottomLoop", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: s.has("Double Jump", p) and has_enough_resources([('wall', ('BreakWall', 16))], [('combat', 'Slug')], "HowlsDen.MidwayBottomLoop", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: s.has("Dash", p) and s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "HowlsDen.MidwayBottomLoop", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: s.has("Dash", p) and has_enough_resources([('wall', ('BreakWall', 16))], [('combat', 'Slug')], "HowlsDen.MidwayBottomLoop", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('energy', ('Grenade', 1))], [], "HowlsDen.MidwayBottomLoop", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.SecretRoom -> C.HowlsDen.SecretRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.SecretRoom -> HowlsDen.LeftSecretRoom"), lambda s: s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("HowlsDen.SecretRoom -> HowlsDen.LeftSecretRoom"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("HowlsDen.SecretRoom -> HowlsDen.OutsideSecretRoom"), lambda s: s.has("HowlsDen.SecretRoomWall", p), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.LeftHC"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'SneezeSlug')], [], "HowlsDen.LeftSecretRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.LeftHC"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.LeftHC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has("Double Jump", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has("Double Jump", p) and has_enough_resources([], [('combat', 'SneezeSlug')], "HowlsDen.LeftSecretRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.LeftSecretRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.AboveTeleporter -> HowlsDen.AboveTPEX"), lambda s: has_enough_resources([('wall', ('BreakWall', 10))], [], "HowlsDen.AboveTeleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.AboveTeleporter -> HowlsDen.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.AboveTeleporter -> HowlsDen.BoneBridge"), lambda s: s.has("HowlsDen.BoneBarrier", p) and s.has_any(("Double Jump", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("HowlsDen.AboveTeleporter -> HowlsDen.BoneBridge"), lambda s: s.has("HowlsDen.BoneBarrier", p) and has_enough_resources([], [('combat', 'Slug')], "HowlsDen.AboveTeleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> F.HowlsDen.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.LaserKS"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.LaserKS"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> DenShrine"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> DenShrine"), lambda s: has_enough_resources([], [('energy', ('Spear', 1))], "HowlsDen.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.DoubleJumpApproach"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.DoubleJumpApproach"), lambda s: s.has_all(("Glide", "Dash"), p), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.DoubleJumpApproach"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.AboveTeleporter"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.AboveTeleporter"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpApproach -> C.HowlsDen.DoubleJumpApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpApproach -> HowlsDen.DoubleJumpTreeCombat"), lambda s: has_enough_resources([('combat', 'Mantis'), ('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'SmallSkeeto')], [], "HowlsDen.DoubleJumpApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpApproach -> HowlsDen.DoubleJumpEX"), lambda s: s.has("HowlsDen.DoubleJumpTreeCombat", p), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpApproach -> HowlsDen.DoubleJumpTreeLedge"), lambda s: s.has_any(("HowlsDen.DoubleJumpTreeCombat", "Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpApproach -> HowlsDen.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeLedge -> C.HowlsDen.DoubleJumpTreeLedge"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeLedge -> HowlsDen.DoubleJumpEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeLedge -> HowlsDen.DoubleJumpTreeArea"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeLedge -> HowlsDen.DoubleJumpApproach"), lambda s: s.has_any(("Double Jump", "Launch", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeArea -> HowlsDen.DoubleJumpTree"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeArea -> HowlsDen.StickyShard"), lambda s: True, "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeArea -> HowlsDen.DoubleJumpTreeLedge"), lambda s: s.has_any(("Double Jump", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeArea -> HowlsDen.DoubleJumpTreeLedge"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.DoubleJumpTreeArea", s, p, o, True), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeArea -> MidnightBurrows.DenConnection"), lambda s: s.has("MidnightBurrows.HowlsDenShortcut", p) and can_enter_area("MidnightBurrows", s, p, o), "or")
    add_rule(w.get_entrance("DenShrine -> F.DenShrine"), lambda s: True, "or")
    add_rule(w.get_entrance("DenShrine -> HowlsDen.CombatShrineCompleted"), lambda s: s.has("Regenerate", p) and has_enough_resources([('combat', 'Mantis'), ('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'SneezeSlug'), ('combat', 'SneezeSlug'), ('combat', 'Mantis'), ('combat', 'Skeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('db', 60)], [], "DenShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("DenShrine -> HowlsDen.CombatShrineCompleted"), lambda s: s.has("Regenerate", p) and s.has_any(("Dash", "Bash", "Launch"), p) and has_enough_resources([('combat', 'Mantis'), ('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'SneezeSlug'), ('combat', 'SneezeSlug'), ('combat', 'Mantis'), ('combat', 'Skeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('db', 40)], [], "DenShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("DenShrine -> HowlsDen.CombatShrine"), lambda s: s.has("HowlsDen.CombatShrineCompleted", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.MillView -> C.MarshPastOpher.MillView"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.MillView -> E.MarshPastOpher.MillView"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.MillView -> OpherShop"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.MillView -> MarshPastOpher.TrialStart"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.MillView -> MarshSpawn.OpherBarrier"), lambda s: s.has("MarshSpawn.ToOpherBarrier", p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("MarshPastOpher.OpherSkipBranch -> MarshPastOpher.MillView"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialStart -> C.MarshPastOpher.TrialStart"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialStart -> MarshPastOpher.TrunkWall"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "MarshPastOpher.TrialStart", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialStart -> MarshPastOpher.SpiritTrial"), lambda s: s.has_all(("MarshPastOpher.TrialActivation", "Double Jump", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialStart -> MarshPastOpher.UnderTrunk"), lambda s: s.has("MarshPastOpher.TrunkWall", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialStart -> MarshPastOpher.BowPath"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.UnderTrunk -> C.MarshPastOpher.UnderTrunk"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.UnderTrunk -> MarshPastOpher.TrialLeftEX"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.UnderTrunk -> MarshPastOpher.TrialArea"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.UnderTrunk -> MarshPastOpher.TrialStart"), lambda s: s.has("MarshPastOpher.TrunkWall", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> C.MarshPastOpher.TrialArea"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> H.MarshPastOpher.TrialArea"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialActivation"), lambda s: s.has("Grapple", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('combat', 'SneezeSlug'), ('combat', 'Mantis')], [], "MarshPastOpher.TrialArea", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialActivation"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialOre"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialEC"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialHC"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialHC"), lambda s: has_enough_resources([], [('energy', ('Spear', 1))], "MarshPastOpher.TrialArea", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialRightEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialRightEX"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialRightEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshPastOpher.TrialArea", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshShrine"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.UnderTrunk"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.UnderTrunk"), lambda s: s.has_all(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.UnderTrunk"), lambda s: s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.BowPath"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Grapple", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "MarshPastOpher.TrialArea", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.BowPath"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Grapple", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('combat', 'Mantis'), ('combat', 'SneezeSlug')], [], "MarshPastOpher.TrialArea", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshShrine -> F.MarshShrine"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshShrine -> MarshPastOpher.CombatShrineCompleted"), lambda s: s.has("Regenerate", p) and has_enough_resources([('db', 20), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Mantis'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('combat', 'Mantis'), ('combat', 'Skeeto')], [], "MarshShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshShrine -> MarshPastOpher.CombatShrine"), lambda s: s.has("MarshPastOpher.CombatShrineCompleted", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> C.MarshPastOpher.BowPath"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> H.MarshPastOpher.BowPath"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> E.MarshPastOpher.BowPath"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.SwingPoleEX"), lambda s: s.has_any(("Dash", "Glide"), p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.BowPath", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.SwingPoleEX"), lambda s: s.has("Bash", p) and has_enough_resources([('db', 10), ('energy', ('Grenade', 2))], [], "MarshPastOpher.BowPath", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.BowApproach"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.MillView"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.MillView"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "MarshPastOpher.BowPath", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.TrialStart"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshPastOpher.BowPath", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> C.MarshPastOpher.BowApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> H.MarshPastOpher.BowApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.SwingPoleEX"), lambda s: has_enough_resources([('db', 10)], [], "MarshPastOpher.BowApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.BowPath"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.BowArea"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.BowArea"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshPastOpher.BowApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.MillView"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshPastOpher.BowApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("Double Jump", "Dash", "Bash", "Glide"), p) and has_enough_resources([('energy', ('Bow', 4))], [], "MarshPastOpher.BowApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Bow', 4))], [], "MarshPastOpher.BowApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> E.MarshPastOpher.BowArea"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.EyestoneDoor"), lambda s: can_open_door("MarshPastOpher.EyestoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.BowEC"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.BowTree"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.UpperBowArea"), lambda s: s.has("Double Jump", p) and has_enough_resources([('combat', 'Skeeto'), ('energy', ('Bow', 2))], [], "MarshPastOpher.BowArea", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.UpperBowArea"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> WestHollow.Entrance"), lambda s: s.has("MarshPastOpher.EyestoneDoor", p) and can_enter_area("WestHollow", s, p, o), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.BowApproach"), lambda s: s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.BowApproach"), lambda s: has_enough_resources([('combat', 'Skeeto'), ('energy', ('Bow', 1))], [], "MarshPastOpher.BowArea", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.UpperBowArea -> C.MarshPastOpher.UpperBowArea"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.UpperBowArea -> E.MarshPastOpher.UpperBowArea"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.UpperBowArea -> MarshPastOpher.LeftEyestone"), lambda s: has_enough_resources([('combat', 'Skeeto'), ('energy', ('Bow', 1))], [], "MarshPastOpher.UpperBowArea", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.UpperBowArea -> MarshPastOpher.RightEyestone"), lambda s: has_enough_resources([('combat', 'Skeeto'), ('energy', ('Bow', 1))], [], "MarshPastOpher.UpperBowArea", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.UpperBowArea -> MarshPastOpher.BowArea"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.UpperBowArea -> MarshPastOpher.BowApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> C.MarshPastOpher.PoolsPathEast"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> H.MarshPastOpher.PoolsPathEast"), lambda s: has_enough_resources([('combat', 'Mantis'), ('combat', 'Bat')], [], "MarshPastOpher.PoolsPathEast", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> E.MarshPastOpher.PoolsPathEast"), lambda s: s.has("BreakCrystal", p) and has_enough_resources([('combat', 'Mantis'), ('combat', 'Bat')], [], "MarshPastOpher.PoolsPathEast", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.CeilingEX"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.CeilingEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.PoolsPathMiddle"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.OpherSkipBranch"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> C.MarshPastOpher.PoolsPathMiddle"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has_any(("Bash", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathFloor"), lambda s: has_enough_resources([], [('energy', ('Spear', 1))], "MarshPastOpher.PoolsPathMiddle", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEC"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEC"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEC"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "MarshPastOpher.PoolsPathMiddle", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Bash"), p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Launch", "Clean Water"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEast"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> C.MarshPastOpher.PoolsPathOneWayWall"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "MarshPastOpher.PoolsPathOneWayWall", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> MarshPastOpher.PoolsPathMiddle"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "MarshPastOpher.PoolsPathOneWayWall", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> MarshPastOpher.PoolsPathWest"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathOneWayWall"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Clean Water"), p) and s.has_any(("Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> C.MarshPastOpher.PoolsPathWest"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathEX"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshPastOpher.PoolsPathWest", s, p, o, True), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> F.MidnightBurrows.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> MidnightBurrows.BelowLupo"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> MidnightBurrows.BelowLupo"), lambda s: has_enough_resources([], [('combat', 'SneezeSlug'), ('combat', 'Bat')], "MidnightBurrows.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("MarshSpawn.BurrowsOpen", "Launch"), p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("MarshSpawn.BurrowsOpen", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.LeftKS"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.Teleporter"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.Teleporter"), lambda s: has_enough_resources([], [('combat', 'SneezeSlug'), ('combat', 'Bat')], "MidnightBurrows.BelowLupo", s, p, o, True), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.Central"), lambda s: s.has_all(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.Central"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> C.MidnightBurrows.Central"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.LupoMap"), lambda s: can_buy_map(s, p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.DeflectorShard"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.DeflectorShard"), lambda s: s.has_all(("MidnightBurrows.Lever", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.BelowLupo"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.TabletRoom"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.TabletRoom"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.PortalRoom"), lambda s: s.has_any(("Launch", "Glide", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.TabletRoom -> C.MidnightBurrows.TabletRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.TabletRoom -> H.MidnightBurrows.TabletRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.TabletRoom -> MidnightBurrows.KeystoneDoor"), lambda s: can_open_door("MidnightBurrows.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("MidnightBurrows.TabletRoom -> MidnightBurrows.TabletQI"), lambda s: s.has("MidnightBurrows.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.TabletRoom -> MidnightBurrows.Central"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> C.MidnightBurrows.PortalRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.LeverRoom"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.LeverRoom"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.LeverRoom"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.LeverRoom"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.BelowUpperKS"), lambda s: s.has_all(("MidnightBurrows.Lever", "Launch"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.East"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.East"), lambda s: s.has("MidnightBurrows.Lever", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.Central"), lambda s: s.has("MidnightBurrows.Lever", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> C.MidnightBurrows.LeverRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.Lever"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.LowerKS"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.LowerKS"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MidnightBurrows.LeverRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.PortalRoom"), lambda s: s.has_all(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.PortalRoom"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.PortalRoom"), lambda s: s.has_all(("Bash", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.East -> C.MidnightBurrows.East"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.East -> MidnightBurrows.DenConnection"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.East -> MidnightBurrows.DenConnection"), lambda s: has_enough_resources([], [('combat', 'SneezeSlug'), ('combat', 'Tentacle')], "MidnightBurrows.East", s, p, o, True), "or")
    add_rule(w.get_entrance("MidnightBurrows.DenConnection -> C.MidnightBurrows.DenConnection"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.DenConnection -> MidnightBurrows.HowlsDenShortcut"), lambda s: has_enough_resources([('wall', ('BreakWall', 10))], [], "MidnightBurrows.DenConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("MidnightBurrows.DenConnection -> MidnightBurrows.RightKS"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.DenConnection -> MidnightBurrows.PortalCorridor"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.DenConnection -> MidnightBurrows.PortalCorridor"), lambda s: has_enough_resources([], [('combat', 'WeakSlug')], "MidnightBurrows.DenConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("MidnightBurrows.DenConnection -> HowlsDen.DoubleJumpTreeArea"), lambda s: s.has("MidnightBurrows.HowlsDenShortcut", p) and can_enter_area("HowlsDen", s, p, o), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalCorridor -> C.MidnightBurrows.PortalCorridor"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalCorridor -> MidnightBurrows.DenConnection"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalCorridor -> MidnightBurrows.BelowUpperKS"), lambda s: s.has_all(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalCorridor -> MidnightBurrows.BelowUpperKS"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([('db', 15)], [], "MidnightBurrows.PortalCorridor", s, p, o, True), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalCorridor -> MidnightBurrows.BelowUpperKS"), lambda s: s.has_all(("Launch", "Glide"), p) and has_enough_resources([('db', 15)], [], "MidnightBurrows.PortalCorridor", s, p, o, True), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowUpperKS -> MidnightBurrows.UpperKS"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowUpperKS -> MidnightBurrows.UpperKS"), lambda s: has_enough_resources([], [('combat', 'Bat')], "MidnightBurrows.BelowUpperKS", s, p, o, True), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowUpperKS -> MidnightBurrows.PortalRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> C.WestHollow.Entrance"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> E.WestHollow.Entrance"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> MarshPastOpher.EyestoneDoor"), lambda s: can_open_door("MarshPastOpher.EyestoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.PurpleDoorOpen"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.Entrance", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.PurpleDoorOpen"), lambda s: s.has("Launch", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.Entrance", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.PurpleDoorOpen"), lambda s: s.has("Bash", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('energy', ('Bow', 1)), ('energy', ('Grenade', 1))], [], "WestHollow.Entrance", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.CrusherHC"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> TwillenShop"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> MarshPastOpher.BowArea"), lambda s: s.has("MarshPastOpher.EyestoneDoor", p) and s.has_any(("Double Jump", "Launch"), p) and can_enter_area("MarshPastOpher", s, p, o), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> MarshPastOpher.BowArea"), lambda s: s.has_all(("MarshPastOpher.EyestoneDoor", "Bash"), p) and can_enter_area("MarshPastOpher", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestHollow.Entrance", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.MokiByTwillen"), lambda s: s.has_any(("Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.InFrontPurpleDoorEnemyPaths"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Slug'), ('combat', 'Slug'), ('energy', ('Bow', 1))], [], "WestHollow.Entrance", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.InFrontPurpleDoorEnemyPaths"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.HollowDrainMiddle"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> H.WestHollow.MokiByTwillen"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.UpperDrainLeverPulled"), lambda s: has_enough_resources([('combat', 'BombSlug'), ('energy', ('Bow', 1))], [], "WestHollow.MokiByTwillen", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.UpperDrainLeverPulled"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('combat', 'BombSlug')], [], "WestHollow.MokiByTwillen", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.UpperDrainLeverPulled"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.Entrance"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.InFrontPurpleDoorEnemyPaths"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.InFrontPurpleDoorEnemyPaths"), lambda s: has_enough_resources([], [('combat', 'BombSlug')], "WestHollow.MokiByTwillen", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.MokiByTwillen"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.InFrontPurpleDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.MokiByTwillen"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [('combat', 'Slug')], "WestHollow.InFrontPurpleDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.MokiByTwillen"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestHollow.InFrontPurpleDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.MokiByTwillen"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.Entrance"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained", "Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Slug'), ('combat', 'Slug')], [], "WestHollow.InFrontPurpleDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.Entrance"), lambda s: s.has("Bash", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.HollowDrainMiddle"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> EastHollow.Teleporter"), lambda s: s.has("WestHollow.PurpleDoorOpen", p) and can_enter_area("EastHollow", s, p, o), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoorEnemyPaths -> WestHollow.InFrontPurpleDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.HollowDrainMiddle"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> C.WestHollow.HollowDrainMiddle"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> E.WestHollow.HollowDrainMiddle"), lambda s: s.has("BreakCrystal", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.UpperTongueExtended"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.HollowDrainMiddle", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_all(("WestHollow.UpperTongueExtended", "WestHollow.FullyDrained"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.HollowDrainMiddle", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_all(("WestHollow.UpperTongueExtended", "WestHollow.UpperDrainLeverPulled"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.HollowDrainMiddle", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.SubmergedPlatform"), lambda s: s.has("WestHollow.FullyDrained", p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.Entrance"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.Entrance"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.Entrance"), lambda s: s.has("Bash", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestHollow.HollowDrainMiddle", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.Entrance"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> C.WestHollow.RockPuzzle"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> H.WestHollow.RockPuzzle"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> E.WestHollow.RockPuzzle"), lambda s: s.has("BreakCrystal", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleSolved"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Skeeto'), ('energy', ('Bow', 4))], [], "WestHollow.RockPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleSolved"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Skeeto'), ('energy', ('Bow', 4))], [], "WestHollow.RockPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleSolved"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Bow', 4))], [], "WestHollow.RockPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleSolved"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has_any(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Bow', 4))], [], "WestHollow.RockPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleEX"), lambda s: s.has("WestHollow.FullyDrained", p), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.PastRockPuzzleDoorEnemyPaths"), lambda s: s.has("WestHollow.RockPuzzleSolved", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.SubmergedPlatform"), lambda s: s.has("WestHollow.FullyDrained", p), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.Entrance"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> C.WestHollow.PastRockPuzzleDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.FarLeftRoom"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Skeeto'), ('combat', 'Slug'), ('energy', ('Bow', 1))], [], "WestHollow.PastRockPuzzleDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.FarLeftRoom"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Skeeto'), ('combat', 'Slug'), ('energy', ('Bow', 1))], [], "WestHollow.PastRockPuzzleDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.FarLeftRoom"), lambda s: s.has("Launch", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoorEnemyPaths -> C.WestHollow.PastRockPuzzleDoorEnemyPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoorEnemyPaths -> WestHollow.PastRockPuzzleDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoorEnemyPaths -> WestHollow.FarLeftRoom"), lambda s: s.has("Bash", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FarLeftRoom"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> E.WestHollow.FarLeftRoom"), lambda s: s.has("BreakCrystal", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FullyDrained"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Bow', 2))], [], "WestHollow.FarLeftRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FullyDrained"), lambda s: s.has_all(("WestHollow.UpperDrainLeverPulled", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FarLeftEX"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FarLeftEX"), lambda s: s.has_all(("WestHollow.FullyDrained", "Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.FarLeftRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.FarLeftEX"), lambda s: s.has("WestHollow.FullyDrained", p), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> E.WestHollow.SubmergedPlatform"), lambda s: s.has_all(("WestHollow.FullyDrained", "BreakCrystal"), p), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.UpperTongueExtended"), lambda s: s.has("WestHollow.FullyDrained", p) and has_enough_resources([('combat', 'BombSlug'), ('energy', ('Bow', 1))], [], "WestHollow.SubmergedPlatform", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.UpperTongueRetracted"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.LowerTongueExtended"), p) and has_enough_resources([('combat', 'BombSlug'), ('energy', ('Bow', 1))], [], "WestHollow.SubmergedPlatform", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.LowerTongueExtended"), lambda s: s.has("WestHollow.FullyDrained", p) and has_enough_resources([('combat', 'BombSlug'), ('energy', ('Bow', 1))], [], "WestHollow.SubmergedPlatform", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.HollowDrainMiddle"), lambda s: s.has_all(("WestHollow.FullyDrained", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.HollowDrainMiddle"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.UpperTongueExtended", "WestHollow.LowerTongueExtended", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.HollowDrainMiddle"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.UpperTongueRetracted", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestHollow.SubmergedPlatform", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.RockPuzzle"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.AboveJumppad"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("WestHollow.LowerTongueExtended", "Launch", "Glide", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.AboveJumppad"), lambda s: s.has("WestHollow.FullyDrained", p), "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.LowerTongueExtended"), lambda s: s.has("WestHollow.FullyDrained", p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.AboveJumppad", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.HiddenEC"), lambda s: s.has("WestHollow.FullyDrained", p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "WestHollow.AboveJumppad", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.HollowDrainLower"), lambda s: s.has("WestHollow.FullyDrained", p), "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.SubmergedPlatform"), lambda s: s.has_all(("WestHollow.FullyDrained", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.SubmergedPlatform"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.LowerTongueExtended", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> C.WestHollow.HollowDrainLower"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.QuickshotShard"), lambda s: s.has_all(("WestHollow.FullyDrained", "Double Jump", "Dash"), p) and s.has("Bash", p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.QuickshotShard"), lambda s: s.has_all(("WestHollow.FullyDrained", "Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Bow', 1))], [('combat', 'Skeeto'), ('combat', 'Skeeto')], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.QuickshotShard"), lambda s: s.has_all(("WestHollow.FullyDrained", "Double Jump", "Launch"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.SwimEC"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.LupoMap"), lambda s: s.has_all(("Double Jump", "Dash"), p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.LupoMap"), lambda s: s.has("Bash", p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.LupoMap"), lambda s: s.has("Launch", p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has_all(("WestHollow.FullyDrained", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('combat', 'Slug'), ('combat', 'Skeeto'), ('combat', 'Skeeto')], [], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has_all(("WestHollow.FullyDrained", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Slug'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Hornbug')], [], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has_all(("WestHollow.FullyDrained", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 10)], [], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has_all(("WestHollow.FullyDrained", "Clean Water", "Water Dash"), p) and s.has("Double Jump", p) and has_enough_resources([('combat', 'Slug')], [], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has_all(("WestHollow.FullyDrained", "Clean Water", "Water Dash"), p) and has_enough_resources([('combat', 'Slug')], [('combat', 'Hornbug')], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has_all(("WestHollow.FullyDrained", "Clean Water", "Water Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has_all(("WestHollow.FullyDrained", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.PolesPond"), lambda s: s.has_any(("Double Jump", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.PolesPond"), lambda s: has_enough_resources([], [('combat', 'SneezeSlug')], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.AboveJumppad"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.AboveJumppad"), lambda s: has_enough_resources([], [('combat', 'Slug')], "WestHollow.HollowDrainLower", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> C.WestHollow.TrialApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> WestHollow.TrialStart"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('combat', 'Slug')], [], "WestHollow.TrialApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> WestHollow.TrialStart"), lambda s: s.has_all(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> WestHollow.TrialStart"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> WestHollow.HollowDrainLower"), lambda s: s.has("WestHollow.FullyDrained", p), "or")
    add_rule(w.get_entrance("WestHollow.TrialStart -> C.WestHollow.TrialStart"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.TrialStart -> WestHollow.TrialHC"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.TrialStart -> WestHollow.SpiritTrial"), lambda s: s.has_all(("WestHollow.TrialActivation", "WestHollow.FullyDrained", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.TrialStart -> WestHollow.TrialApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> C.WestHollow.PolesPond"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.FallingSlugEX"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.FallingSlugEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.DashApproach"), lambda s: s.has_any(("Double Jump", "Bash", "Launch", "Glide", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.HollowDrainLower"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Slug')], [], "WestHollow.PolesPond", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.HollowDrainLower"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.HollowDrainLower"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> C.WestHollow.DashApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> E.WestHollow.DashApproach"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.TrialActivation"), lambda s: s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.DoorLever"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Skeeto'), ('combat', 'Mantis'), ('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'Hornbug')], [], "WestHollow.DashApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.DoorLever"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.DoorLever"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "WestHollow.DashApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.DoorLever"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.PolesPond"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.PolesPond"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WestHollow.DashApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.PolesPond"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.DashArea"), lambda s: s.has("WestHollow.DoorLever", p), "or")
    add_rule(w.get_entrance("WestHollow.DashArea -> C.WestHollow.DashArea"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.DashArea -> WestHollow.DashTree"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.DashArea -> WestHollow.DashApproach"), lambda s: s.has("WestHollow.DoorLever", p), "or")
    add_rule(w.get_entrance("WestHollow.DashArea -> WestHollow.DashCrushers"), lambda s: s.has_any(("Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> C.WestHollow.DashCrushers"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.CrusherEX"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashTree"), lambda s: s.has_any(("Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashArea"), lambda s: s.has_all(("Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestHollow.DashCrushers", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> C.WestHollow.DashRoomTopRight"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.DashRightEX"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.DashRightEX"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([], [('combat', 'WeakSlug')], "WestHollow.DashRoomTopRight", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.DashRightEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.DashCrushers"), lambda s: s.has_any(("Bash", "Glide", "Launch", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.AboveDashSemisolid"), lambda s: s.has("Glide", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.AboveDashSemisolid"), lambda s: s.has("Glide", p) and has_enough_resources([], [('combat', 'Hornbug'), ('combat', 'Skeeto')], "WestHollow.DashRoomTopRight", s, p, o, True), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.AboveDashSemisolid"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.AboveDashSemisolid"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestHollow.AboveDashSemisolid -> WestHollow.AboveDashEX"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.AboveDashSemisolid -> WestHollow.DashArea"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> F.EastHollow.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> EastHollow.VoiceDoorOpen"), lambda s: s.has("EastHollow.ForestsVoice", p), "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> BeetleFight"), lambda s: has_enough_resources([('combat', 'Skeeto'), ('combat', 'Mantis')], [], "EastHollow.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> EastHollow.AfterBeetleFight"), lambda s: s.has("EastHollow.BeetleDefeated", p) and s.has_any(("Double Jump", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> WestHollow.InFrontPurpleDoorEnemyPaths"), lambda s: s.has("WestHollow.PurpleDoorOpen", p) and can_enter_area("WestHollow", s, p, o), "or")
    add_rule(w.get_entrance("BeetleFight -> F.BeetleFight"), lambda s: True, "or")
    add_rule(w.get_entrance("BeetleFight -> EastHollow.BeetleDefeated"), lambda s: s.has_all(("Regenerate", "Dash"), p) and has_enough_resources([('wall', ('Boss', 250)), ('db', 45)], [], "BeetleFight", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.VoiceDoorOpen"), lambda s: s.has("EastHollow.ForestsVoice", p), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.HornBeetleFightEX"), lambda s: s.has_all(("Double Jump", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.HornBeetleFightEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastHollow.VoiceDoorPlatform", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.HornBeetleFightEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.MapMoki"), lambda s: s.has("EastHollow.VoiceDoorOpen", p), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.Teleporter"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.AfterBeetleFight"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> C.EastHollow.MapMoki"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> EastHollow.HandToHandMap"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> EastHollow.GladesApproachOre"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> EastHollow.VoiceDoorPlatform"), lambda s: s.has("EastHollow.VoiceDoorOpen", p), "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> EastHollow.OutsideGlades"), lambda s: s.has_all(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> EastHollow.OutsideGlades"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastHollow.OutsideGlades -> GladesTown.GromsWall"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("EastHollow.OutsideGlades -> GladesTown.Teleporter"), lambda s: s.has("GladesTown.GromsWall", p) and can_enter_area("GladesTown", s, p, o), "or")
    add_rule(w.get_entrance("EastHollow.OutsideGlades -> EastHollow.MapMoki"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> C.EastHollow.AfterBeetleFight"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.VoiceDoorOpen"), lambda s: s.has("EastHollow.ForestsVoice", p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SpikeLanternEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SecretRoofEX"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SecretRoofEX"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.MortarEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.MortarEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> BeetleFight"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.AboveBash"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastHollow.AfterBeetleFight", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.VoiceDoorPlatform"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.VoiceDoorPlatform"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Kwolok"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Kwolok"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Kwolok"), lambda s: s.has_all(("Launch", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.DepthsLever"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashEC"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashEC"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastHollow.AboveBash", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashEC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashTreeCheckpoint"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'SneezeSlug'), ('combat', 'SneezeSlug')], [], "EastHollow.AboveBash", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashTreeCheckpoint"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashTreeCheckpoint"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.AboveDepths"), lambda s: s.has("EastHollow.DepthsLever", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'SneezeSlug'), ('combat', 'SneezeSlug')], [], "EastHollow.AboveBash", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.AboveDepths"), lambda s: s.has_all(("EastHollow.DepthsLever", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.AboveDepths"), lambda s: s.has("EastHollow.DepthsLever", p) and s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.AfterBeetleFight"), lambda s: s.has_any(("Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> C.EastHollow.BashTreeCheckpoint"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.BashTree"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.BashEX"), lambda s: s.has_all(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.BashEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.AboveBash"), lambda s: s.has("Launch", p) and s.has_any(("Bash", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.AboveBash"), lambda s: s.has("Launch", p) and has_enough_resources([], [('energy', ('Spear', 1))], "EastHollow.BashTreeCheckpoint", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.AboveBash"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> C.EastHollow.Kwolok"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.ForestsVoice"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.WellspringDoneTalk"), lambda s: s.has("InnerWellspring.WaterEscape", p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.KwolokAmuletQuest"), lambda s: s.has_all(("EastPools.KwolokAmuletQI", "WestPools.ForestsStrength"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> GladesTown.TuleySpawned"), lambda s: s.has("InnerWellspring.WaterEscape", p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.SilentSwimWall"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.RightKwolokEX"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.SilentSwimEC"), lambda s: s.has("Clean Water", p) and s.has_any(("Water Dash", "Launch"), p) and has_enough_resources([('combat', 'Balloon')], [], "EastHollow.Kwolok", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.KwolokSwimOre"), lambda s: s.has("Clean Water", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.KwolokSwimOre"), lambda s: s.has("Clean Water", p) and has_enough_resources([], [('db', 10)], "EastHollow.Kwolok", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.KwolokSwimLeftEX"), lambda s: s.has("Clean Water", p) and s.has_any(("Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.KwolokSwimRightEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.AfterBeetleFight"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.AfterBeetleFight"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.AfterBeetleFight"), lambda s: s.has_all(("Dash", "Glide"), p) and has_enough_resources([('db', 10)], [], "EastHollow.Kwolok", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.AfterBeetleFight"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> WoodsEntry.ShriekMeet"), lambda s: s.has_all(("EastHollow.SilentSwimWall", "Clean Water", "Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and can_enter_area("WoodsEntry", s, p, o) and has_enough_resources([('combat', 'Balloon')], [], "EastHollow.Kwolok", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> WoodsEntry.ShriekMeet"), lambda s: s.has_all(("EastHollow.SilentSwimWall", "Clean Water", "Grapple", "Dash", "Glide"), p) and can_enter_area("WoodsEntry", s, p, o) and has_enough_resources([('combat', 'Balloon')], [], "EastHollow.Kwolok", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> WoodsEntry.ShriekMeet"), lambda s: s.has_all(("EastHollow.SilentSwimWall", "Clean Water", "Launch"), p) and can_enter_area("WoodsEntry", s, p, o) and has_enough_resources([('combat', 'Balloon')], [], "EastHollow.Kwolok", s, p, o, True), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> C.EastHollow.AboveDepths"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> E.EastHollow.AboveDepths"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.DepthsOpen"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.BashHC"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.SplinterShard"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.DepthsExteriorEX"), lambda s: s.has_all(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> UpperDepths.Entry"), lambda s: s.has("EastHollow.DepthsOpen", p) and can_enter_area("UpperDepths", s, p, o), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.BashTreeCheckpoint"), lambda s: s.has("EastHollow.DepthsLever", p) and s.has_any(("Double Jump", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.BashTreeCheckpoint"), lambda s: s.has("EastHollow.DepthsLever", p) and has_enough_resources([], [('combat', 'SneezeSlug')], "EastHollow.AboveDepths", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> F.GladesTown.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.BuildHuts"), lambda s: s.count("Gorlek Ore", p) >= 15, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.RoofsOverHeads"), lambda s: s.has("GladesTown.BuildHuts", p) and s.count("Gorlek Ore", p) >= 21, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.OnwardsAndUpwards"), lambda s: s.has("GladesTown.RoofsOverHeads", p) and s.count("Gorlek Ore", p) >= 29, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.ClearThorns"), lambda s: s.count("Gorlek Ore", p) >= 23, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.CaveEntrance"), lambda s: s.has("GladesTown.ClearThorns", p) and s.count("Gorlek Ore", p) >= 29, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.RebuildTheGlades"), lambda s: s.count("Gorlek Ore", p) >= 40, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.ArcingShard"), lambda s: s.has_all(("GladesTown.ClearThorns", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.ArcingShard"), lambda s: s.has_all(("GladesTown.ClearThorns", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.ArcingShard"), lambda s: s.has_all(("GladesTown.ClearThorns", "TuleyShop.Lightcatchers", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.LupoSwimMiddleEX"), lambda s: s.has("Clean Water", p) and s.has_any(("Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.LupoSwimLeftEX"), lambda s: s.has_all(("GladesTown.ClearThorns", "Clean Water"), p) and s.has_any(("Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.TwillenHome"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.UpperWest"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple", "TuleyShop.Lightcatchers", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.BelowBountyShard"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.BelowBountyShard"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.BelowBountyShard"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "TuleyShop.StickyGrass", "Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.AboveOpher"), lambda s: s.has_any(("Launch", "TuleyShop.SpringPlants"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.AboveOpher"), lambda s: s.has_all(("Flap", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.AboveOpher"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.LeftAboveCoals"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.LeftAboveCoals"), lambda s: s.has_all(("TuleyShop.BlueMoon", "TuleyShop.Lightcatchers", "Grapple", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.LupoHouse"), lambda s: s.has_any(("Burrow", "Clean Water"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> OpherShop"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> Tokk"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> TuleyShop"), lambda s: s.has("GladesTown.TuleySpawned", p) and s.has_any(("Double Jump", "Launch", "TuleyShop.SpringPlants"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> TuleyShop"), lambda s: s.has_all(("GladesTown.TuleySpawned", "Flap", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> TuleyShop"), lambda s: s.has_all(("GladesTown.TuleySpawned", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> EastHollow.OutsideGlades"), lambda s: s.has("GladesTown.GromsWall", p) and can_enter_area("EastHollow", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome (Door) -> GladesTown.TwillenHome"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.TwillenHome (Door)"), lambda s: s.has_all(("GladesTown.BuildHuts", "WoodsEntry.DollQI"), p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> C.GladesTown.TwillenHome"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.HandToHandLantern"), lambda s: s.has("LowerReach.HandToHandHat", p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.FamilyReunionKey"), lambda s: s.has("GladesTown.BuildHuts", p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.LowerOre"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and has_enough_resources([('energy', ('Spear', 1))], [], "GladesTown.TwillenHome", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.LowerOre"), lambda s: s.has("Hammer", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.LowerOre"), lambda s: s.has("Bash", p) and s.has("Hammer", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.TwillenHome", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.LowerOre"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [('energy', ('Spear', 1))], "GladesTown.TwillenHome", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.AboveCaveEX"), lambda s: s.has("GladesTown.ClearThorns", p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.DamageTree"), lambda s: s.has("TuleyShop.LastTree", p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> TwillenShop"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.AcornMoki"), lambda s: s.has("GladesTown.ClearThorns", p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.West"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.West"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.TwillenHome", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.West"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.Teleporter"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.TwillenHome", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.Teleporter"), lambda s: s.has_any(("GladesTown.ClearThorns", "Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.KeyMokiHutInside (Door) -> GladesTown.KeyMokiHutInside"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.KeyMokiHutInside -> GladesTown.KeyMokiHutInside (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.KeyMokiHutInside -> GladesTown.KeyMokiHutEX"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.West -> C.GladesTown.West"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.HandToHandCanteen"), lambda s: s.has("EastPools.HandToHandSpyglass", p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.West", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has("TuleyShop.StickyGrass", p) and s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.West", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Bash", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.West", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "TuleyShop.Lightcatchers", "Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "TuleyShop.Lightcatchers", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "GladesTown.West", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.StickyGrass", "Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.West", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.StickyGrass", "TuleyShop.Lightcatchers", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.Lightcatchers", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.West", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.MotayHut"), lambda s: s.has_all(("GladesTown.BuildHuts", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.MotayHut"), lambda s: s.has_all(("GladesTown.BuildHuts", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.West", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.MotayHut"), lambda s: s.has_all(("GladesTown.BuildHuts", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.MotayHut"), lambda s: s.has_all(("GladesTown.BuildHuts", "Grapple"), p) and s.has_any(("TuleyShop.StickyGrass", "TuleyShop.BlueMoon"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.MotayHut"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> WestGlades.PastTown"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.West -> WestGlades.PastTown"), lambda s: s.has("Launch", p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.TwillenHome"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.Teleporter"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.Teleporter"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.Teleporter"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "TuleyShop.StickyGrass", "Grapple", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut (Door) -> GladesTown.MotayHut"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.MotayHut (Door)"), lambda s: s.has("GladesTown.BuildHuts", p), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "GladesTown.MotayHut", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.West"), lambda s: s.has_any(("GladesTown.BuildHuts", "TuleyShop.Lightcatchers"), p), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperWest"), lambda s: s.has_all(("GladesTown.BuildHuts", "Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "GladesTown.MotayHut", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperWest"), lambda s: s.has_all(("GladesTown.BuildHuts", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperWest"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.Lightcatchers", "Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.MotayHutInside (Door) -> GladesTown.MotayHutInside"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.MotayHutInside -> GladesTown.MotayHutInside (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.MotayHutInside -> GladesTown.MotayHutEX"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.UpperWest (Door) -> GladesTown.UpperWest"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.UpperWest (Door)"), lambda s: s.has("GladesTown.OnwardsAndUpwards", p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.ArcingShard"), lambda s: s.has("GladesTown.ClearThorns", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.ArcingShard"), lambda s: s.has_all(("GladesTown.ClearThorns", "TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.ArcingShard"), lambda s: s.has_all(("GladesTown.ClearThorns", "TuleyShop.BlueMoon", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.UpperLeftEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.UpperWest", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.UpperLeftEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.UpperLeftEX"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and s.has_any(("TuleyShop.StickyGrass", "TuleyShop.BlueMoon"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.AboveGromHC"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.UpperWest", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.AboveGromHC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.AboveGromHC"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.AboveGromHC"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p) and s.has_any(("Dash", "Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.MotayHut"), lambda s: s.has("GladesTown.BuildHuts", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.MotayHut"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.BlueMoon", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.West"), lambda s: s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.West"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.TwillenHome"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.Teleporter"), lambda s: s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.Teleporter"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.Teleporter"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.InsideThirdHut (Door) -> GladesTown.InsideThirdHut"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.InsideThirdHut -> GladesTown.InsideThirdHut (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.InsideThirdHut -> GladesTown.BraveMokiHutEX"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki (Door) -> GladesTown.AcornMoki"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.AcornMoki (Door)"), lambda s: s.has("GladesTown.CaveEntrance", p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.MokiAcornQuest"), lambda s: s.has("GladesTown.AcornQI", p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.AboveCaveEX"), lambda s: s.has_any(("Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.AboveCaveEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.AcornMoki", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.AboveCaveEX"), lambda s: s.has("TuleyShop.SpringPlants", p) and has_enough_resources([('db', 10)], [], "GladesTown.AcornMoki", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.CaveBurrowEX"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.Teleporter"), lambda s: s.has("GladesTown.ClearThorns", p) and s.has_any(("Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.Teleporter"), lambda s: s.has_all(("GladesTown.ClearThorns", "Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.AcornMoki", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.Teleporter"), lambda s: s.has_all(("GladesTown.ClearThorns", "TuleyShop.SpringPlants"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave (Door) -> GladesTown.AcornCave"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornCave (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> E.GladesTown.AcornCave"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornQI"), lambda s: s.has_all(("Flash", "Clean Water", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornQI"), lambda s: s.has_all(("Flash", "Clean Water", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornQI"), lambda s: s.has_all(("Flash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.AcornCave", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornQI"), lambda s: s.has_all(("Flash", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.AboveTpEX"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.BountyShard"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.BountyShard"), lambda s: s.has("Bash", p) and s.has("TuleyShop.Lightcatchers", p), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.BountyShard"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "GladesTown.BelowBountyShard", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.BountyShard"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.LeftAboveCoals"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.LeftAboveCoals"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.LeftAboveCoals"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.UpdraftCeilingEX"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.UpdraftCeilingEX"), lambda s: s.has_all(("Flap", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.UpdraftCeilingEX"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p) and s.has_any(("Glide", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.UpdraftCeilingEX"), lambda s: s.has("TuleyShop.SpringPlants", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.BelowBountyShard"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.AboveOpher"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher (Door) -> GladesTown.AboveOpher"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.AboveOpher (Door)"), lambda s: s.has("GladesTown.RoofsOverHeads", p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.LeftAboveCoals"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.PlayfulMoki"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.PlayfulMoki"), lambda s: s.has_all(("Flap", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.PlayfulMoki"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.PlayfulMoki"), lambda s: s.has_all(("TuleyShop.SpringPlants", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.PlayfulMoki"), lambda s: s.has_all(("GladesTown.RoofsOverHeads", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.AboveOpher", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> TuleyShop"), lambda s: s.has_all(("GladesTown.TuleySpawned", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> TuleyShop"), lambda s: s.has_all(("GladesTown.TuleySpawned", "GladesTown.RoofsOverHeads", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.StorageHut (Door) -> GladesTown.StorageHut"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.StorageHut -> GladesTown.StorageHut (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.PlayfulMoki -> GladesTown.HoleHut"), lambda s: s.has_any(("TuleyShop.SpringPlants", "Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.PlayfulMoki -> GladesTown.HoleHut"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.PlayfulMoki", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.PlayfulMoki -> GladesTown.HoleHut"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.PlayfulMoki -> GladesTown.AboveOpher"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.PlayfulMoki -> TuleyShop"), lambda s: s.has_all(("GladesTown.TuleySpawned", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.LupoHouse (Door) -> GladesTown.LupoHouse"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.LupoHouse -> GladesTown.LupoHouse (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.LupoHouse -> GladesTown.LupoSwimHC"), lambda s: s.has_all(("Clean Water", "Burrow"), p), "or")
    add_rule(w.get_entrance("GladesTown.LupoHouse -> GladesTown.Teleporter"), lambda s: s.has_any(("Clean Water", "Burrow"), p), "or")
    add_rule(w.get_entrance("GladesTown.InsideLupoHouse (Door) -> GladesTown.InsideLupoHouse"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.InsideLupoHouse -> GladesTown.InsideLupoHouse (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.InsideLupoHouse -> GladesTown.LupoSoupEX"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.InsideLupoHouse -> LupoShop.HCMapIcon"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("GladesTown.InsideLupoHouse -> LupoShop.ECMapIcon"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("GladesTown.InsideLupoHouse -> LupoShop.ShardMapIcon"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> GladesTown.BelowHoleHutEX"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> GladesTown.HoleHutEntrance"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.HoleHut", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> GladesTown.HoleHutEntrance"), lambda s: s.has_any(("TuleyShop.SpringPlants", "Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has_all(("Launch", "Grapple"), p) and s.has_any(("TuleyShop.BlueMoon", "TuleyShop.StickyGrass"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has_all(("TuleyShop.SpringPlants", "Launch"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "TuleyShop.BlueMoon", "Bash", "Grapple"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "TuleyShop.StickyGrass", "Bash", "Grapple", "Glide"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> GladesTown.PlayfulMoki"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.HoleHutEntrance (Door) -> GladesTown.HoleHutEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.HoleHutEntrance -> GladesTown.HoleHutEntrance (Door)"), lambda s: s.has("GladesTown.RoofsOverHeads", p), "or")
    add_rule(w.get_entrance("GladesTown.HoleHutEntrance -> GladesTown.HoleHut"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.InsideHoleHut (Door) -> GladesTown.InsideHoleHut"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.InsideHoleHut -> GladesTown.InsideHoleHut (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.InsideHoleHut -> GladesTown.HoleHutEX"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesTown.InsideHoleHut -> GladesTown.HoleHutEC"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> C.WestGlades.PastTown"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> E.WestGlades.PastTown"), lambda s: s.has_all(("BreakCrystal", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> E.WestGlades.PastTown"), lambda s: s.has_all(("BreakCrystal", "Launch"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.GrappleEX"), lambda s: s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.GrappleEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestGlades.PastTown", s, p, o, True), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has_all(("Bash", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPoolEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has_any(("Clean Water", "Launch"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('combat', 'Tentacle')], [], "WestGlades.PastTown", s, p, o, True), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> GladesTown.West"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and can_enter_area("GladesTown", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> GladesTown.West"), lambda s: s.has("Launch", p) and can_enter_area("GladesTown", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.LeftOre"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.SwimEC"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.Center"), lambda s: s.has_all(("Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.Center"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.PastTown"), lambda s: s.has_any(("Clean Water", "Launch"), p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.PastTown"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Tentacle')], [], "WestGlades.LowerPool", s, p, o, True), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.PastTown"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.Center -> C.WestGlades.Center"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.RightOre"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.RightOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.Upper"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.Upper"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "WestGlades.Center", s, p, o, True), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.Upper"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.LowerPool"), lambda s: s.has_any(("Clean Water", "Launch", "Double Jump", "Dash", "Glide", "Bash"), p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> C.WestGlades.Upper"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.Upper -> H.WestGlades.Upper"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.Upper -> LowerReach.BearSneezed"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.UpperPoolEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.RightOre"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.RightOre"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.Center"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.Upper -> LowerReach.Entry"), lambda s: s.has("LowerReach.BearSneezed", p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.MillApproach"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.MillApproach"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> C.WestGlades.MillApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> H.WestGlades.MillApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.SwimOre"), lambda s: s.has("Clean Water", p) and s.has_any(("Grapple", "Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.ShrineArea"), lambda s: s.has_all(("Grapple", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.ShrineArea"), lambda s: s.has_all(("Grapple", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.ShrineArea"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestGlades.MillApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.ShrineArea"), lambda s: s.has_all(("Launch", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestGlades.MillApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.ShrineArea"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.Upper"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.Upper"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "WestGlades.MillApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.Upper"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.Upper"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.Upper"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.Upper"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has_any(("Launch", "Clean Water"), p) and can_enter_area("OuterWellspring", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and can_enter_area("OuterWellspring", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p) and can_enter_area("OuterWellspring", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("Dash", "Glide"), p) and can_enter_area("OuterWellspring", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('db', 15)], [], "WestGlades.MillApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Grapple"), p) and s.has_any(("Water Dash", "Launch"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Launch", "Double Jump", "Dash"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Launch", "Glide"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.ShrineArea -> C.WestGlades.ShrineArea"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.ShrineArea -> WestGlades.ShrineHC"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WestGlades.ShrineArea -> WestGlades.ShrineHC"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestGlades.ShrineArea", s, p, o, True), "or")
    add_rule(w.get_entrance("WestGlades.ShrineArea -> WestGlades.ShrineHC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestGlades.ShrineArea -> GladesShrine"), lambda s: True, "or")
    add_rule(w.get_entrance("WestGlades.ShrineArea -> WestGlades.MillApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesShrine -> F.GladesShrine"), lambda s: True, "or")
    add_rule(w.get_entrance("GladesShrine -> WestGlades.CombatShrineCompleted"), lambda s: s.has("Regenerate", p) and has_enough_resources([('combat', 'Crab'), ('combat', 'Crab'), ('combat', 'Bee'), ('combat', 'Hornbug'), ('combat', 'Tentacle'), ('combat', 'Tentacle'), ('combat', 'SpinCrab'), ('combat', 'SpinCrab'), ('combat', 'Bee'), ('combat', 'Bee'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Tentacle'), ('combat', 'SpinCrab'), ('db', 65)], [], "GladesShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesShrine -> WestGlades.CombatShrineCompleted"), lambda s: s.has("Regenerate", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Crab'), ('combat', 'Crab'), ('combat', 'Bee'), ('combat', 'Hornbug'), ('combat', 'Tentacle'), ('combat', 'Tentacle'), ('combat', 'SpinCrab'), ('combat', 'SpinCrab'), ('combat', 'Bee'), ('combat', 'Bee'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Tentacle'), ('combat', 'SpinCrab'), ('db', 55)], [], "GladesShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesShrine -> WestGlades.CombatShrineCompleted"), lambda s: s.has_all(("Regenerate", "Launch"), p) and has_enough_resources([('combat', 'Crab'), ('combat', 'Crab'), ('combat', 'Bee'), ('combat', 'Hornbug'), ('combat', 'Tentacle'), ('combat', 'Tentacle'), ('combat', 'SpinCrab'), ('combat', 'SpinCrab'), ('combat', 'Bee'), ('combat', 'Bee'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Tentacle'), ('combat', 'SpinCrab'), ('db', 30)], [], "GladesShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("GladesShrine -> WestGlades.CombatShrine"), lambda s: s.has("WestGlades.CombatShrineCompleted", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor (Door) -> OuterWellspring.EntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.EntranceDoor (Door)"), lambda s: s.has("OuterWellspring.EntranceDoorOpen", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> C.OuterWellspring.EntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestWallBroken"), lambda s: s.has("Double Jump", p) and s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestWallBroken"), lambda s: s.has("Double Jump", p) and has_enough_resources([('wall', ('BreakWall', 20))], [('combat', 'Slug'), ('combat', 'Mantis')], "OuterWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestWallBroken"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.EntranceRoofEX"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.EntranceRoofEX"), lambda s: s.has_all(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.WheelEX"), lambda s: s.has("OuterWellspring.EntranceDoorOpen", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.BasementEC"), lambda s: s.has("OuterWellspring.EntranceDoorOpen", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.SwimEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestEntry"), lambda s: s.has_all(("OuterWellspring.LifeHarvestWallBroken", "Double Jump"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestEntry"), lambda s: s.has_all(("OuterWellspring.LifeHarvestWallBroken", "Double Jump"), p) and has_enough_resources([], [('combat', 'Slug'), ('combat', 'Mantis')], "OuterWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestEntry"), lambda s: s.has_all(("OuterWellspring.LifeHarvestWallBroken", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has_all(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has_all(("Grapple", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has_all(("Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has_all(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has_all(("Bash", "Dash", "Glide"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('Grenade', 2))], [], "OuterWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has_any(("Clean Water", "Launch"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestLeverPulled"), lambda s: s.has_all(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestLeverPulled"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestShard"), lambda s: s.has_all(("OuterWellspring.LifeHarvestLeverPulled", "Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestShard"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.EntranceDoor"), lambda s: s.has("OuterWellspring.LifeHarvestWallBroken", p) and s.has_any(("Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.EntranceDoor"), lambda s: s.has("OuterWellspring.LifeHarvestWallBroken", p) and has_enough_resources([], [('combat', 'Mantis'), ('combat', 'Slug')], "OuterWellspring.LifeHarvestEntry", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoorOpen"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "OuterWellspring.Basement", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.BasementEC"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has("Launch", p) and s.has_any(("OuterWellspring.EntranceDoorOpen", "Double Jump", "Dash", "Glide", "Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Bash", "Double Jump"), p) and s.has_any(("Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Clean Water", "Grapple"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Clean Water", "Grapple"), p) and has_enough_resources([], [('combat', 'WeakSlug')], "OuterWellspring.Basement", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Clean Water", "Water Dash"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Clean Water", "Water Dash"), p) and has_enough_resources([], [('combat', 'WeakSlug')], "OuterWellspring.Basement", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> E.OuterWellspring.AboveEntranceDoor"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.EntranceRoofEX"), lambda s: s.has_all(("Double Jump", "Launch"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.EastDoor"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.EastDoor"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has_all(("Grapple", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has_all(("Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.EntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor (Door) -> OuterWellspring.WestDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.WestDoor (Door)"), lambda s: s.has("InnerWellspring.MiddleDoorsOpen", p), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> C.OuterWellspring.WestDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.WestDoorBlueMoonFree"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "OuterWellspring.WestDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("OuterWellspring.WestDoorBlueMoonFree", "Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("OuterWellspring.WestDoorBlueMoonFree", "Grapple", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("OuterWellspring.WestDoorBlueMoonFree", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.EastDoor"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.WestDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.WestDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.EntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor (Door) -> OuterWellspring.EastDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.EastDoor (Door)"), lambda s: s.has("InnerWellspring.MiddleDoorsOpen", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> C.OuterWellspring.EastDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.WestDoorBlueMoonFree"), lambda s: s.has("Grenade", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.WestDoorBlueMoonFree"), lambda s: s.has("Spear", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.WestDoorBlueMoonFree"), lambda s: s.has("Bow", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.WestDoorBlueMoonFree"), lambda s: s.has("Bash", p) and s.has_any(("Bow", "Spear", "Grenade"), p) and has_enough_resources([('wall', ('BreakWall', 3)), ('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.WestDoorBlueMoonFree"), lambda s: s.has_all(("InnerWellspring.TopDoorOpen", "Grapple"), p) and s.has_any(("Bow", "Spear", "Grenade"), p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TheLostCompass"), lambda s: s.has("InnerWellspring.NeedleQI", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallEC"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallEC"), lambda s: s.has_any(("Glide", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallEC"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallEC"), lambda s: s.has_all(("Grapple", "Bash"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has("InnerWellspring.TopDoorOpen", p) and s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has_all(("InnerWellspring.TopDoorOpen", "Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.WestDoor"), lambda s: s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> E.OuterWellspring.AboveWestDoor"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.TopDoor"), lambda s: s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.TopDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.AboveWestDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.WestDoor"), lambda s: s.has_any(("Double Jump", "Dash", "Grapple", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.WestDoor"), lambda s: has_enough_resources([], [('combat', 'Miner')], "OuterWellspring.AboveWestDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.EastDoor"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.EastDoor"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor (Door) -> OuterWellspring.TopDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.TopDoor (Door)"), lambda s: s.has("InnerWellspring.TopDoorOpen", p), "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.TrialActivation"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.UltraGrappleShard"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.UltraGrappleShard"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.TopDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.UltraGrappleShard"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.EastDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.AboveWestDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.RightWallOre"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> WestGlades.MillApproach"), lambda s: s.has_any(("Grapple", "Glide"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.EntranceDoor"), lambda s: s.has_any(("Clean Water", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> C.OuterWellspring.TrialApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEX"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEX"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.TrialApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEC"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.TrialApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEC"), lambda s: s.has_any(("Glide", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.TrialApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEC"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.TrialApproach", s, p, o, True), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.TrialRoom"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.TrialRoom"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.EastDoor"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.EastDoor"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallMidpoint"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialRoom -> C.OuterWellspring.TrialRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TrialRoom -> H.OuterWellspring.TrialRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TrialRoom -> E.OuterWellspring.TrialRoom"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialRoom -> OuterWellspring.TrialStart"), lambda s: s.has_all(("Grapple", "Double Jump"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialRoom -> OuterWellspring.TrialStart"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialRoom -> OuterWellspring.TrialApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> C.OuterWellspring.TrialStart"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.TrialOre"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.SpiritTrial"), lambda s: s.has_all(("OuterWellspring.TrialActivation", "Double Jump", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.TrialRoom"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.TrialRoom"), lambda s: s.has_all(("Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.TrialRoom"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor (Door) -> InnerWellspring.EntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.EntranceDoor (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> C.InnerWellspring.EntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> E.InnerWellspring.EntranceDoor"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThreeWheels"), lambda s: has_enough_resources([('wall', ('BreakWall', 3))], [], "InnerWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.WaterDashSwitch"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThreeWheelsEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThreeWheelsEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThreeWheelsEX"), lambda s: s.has("InnerWellspring.ThreeWheels", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.WaterSwitchEX"), lambda s: s.has_all(("InnerWellspring.WaterDashSwitch", "Clean Water"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThornShardArea"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThornShardArea"), lambda s: s.has("InnerWellspring.ThreeWheels", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThornShardArea"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThornShardArea"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.DrainRoom"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.DrainRoom"), lambda s: s.has_all(("InnerWellspring.ThreeWheels", "Grapple"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.DrainRoom"), lambda s: s.has_all(("InnerWellspring.ThreeWheels", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.EntranceDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ShortcutLever"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ShortcutLever"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> C.InnerWellspring.ThornShardArea"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornShard"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornEX"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.EntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.ShortcutLever -> InnerWellspring.ShortCutWheel"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.ShortcutLever -> InnerWellspring.EntranceDoor"), lambda s: s.has_any(("Grapple", "Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.ShortcutLever -> InnerWellspring.WestDoor"), lambda s: s.has_all(("InnerWellspring.ShortCutWheel", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.ShortcutLever -> InnerWellspring.WestDoor"), lambda s: s.has_all(("InnerWellspring.ShortCutWheel", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.ShortcutLever -> InnerWellspring.WestDoor"), lambda s: s.has_all(("InnerWellspring.ShortCutWheel", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> C.InnerWellspring.DrainRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> E.InnerWellspring.DrainRoom"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomBottomWheel"), lambda s: s.has("InnerWellspring.ThreeWheels", p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "InnerWellspring.DrainRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.EntranceDoor"), lambda s: s.has_any(("Double Jump", "Dash", "Grapple", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.EntranceDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("Glide", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "InnerWellspring.DrainRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("InnerWellspring.DrainRoomBottomWheel", "Double Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("InnerWellspring.DrainRoomBottomWheel", "Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("Clean Water", "Double Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("Clean Water", "Water Dash", "Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaEntrance"), lambda s: s.has("InnerWellspring.DrainLever", p) and s.has_any(("Double Jump", "Dash", "Grapple", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainHC"), lambda s: s.has_any(("Clean Water", "Double Jump", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainHC"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainAreaEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has_all(("Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainAreaEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has_all(("Clean Water", "Bash"), p) and s.has_any(("Grapple", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainAreaEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEX -> InnerWellspring.DrainEX"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEX -> InnerWellspring.DrainHC"), lambda s: s.has_any(("Clean Water", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEX -> InnerWellspring.DrainAreaExit"), lambda s: s.has_any(("Double Jump", "Dash", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "InnerWellspring.DrainAreaEX", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEX -> InnerWellspring.DrainAreaExit"), lambda s: s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 10)), ('energy', ('Grenade', 1))], [], "InnerWellspring.DrainAreaEX", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> C.InnerWellspring.DrainAreaExit"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainAreaEX"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainAreaExit", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "InnerWellspring.DrainAreaExit", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoom"), lambda s: s.has_all(("Dash", "Glide"), p) and s.has_any(("Clean Water", "InnerWellspring.DrainRoomBottomWheel"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoomTopWheel"), lambda s: s.has_any(("Bow", "Grenade", "Spear"), p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "InnerWellspring.DrainRoomCenter", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoomTopWheel"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "InnerWellspring.DrainRoomCenter", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoom"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoom"), lambda s: s.has_any(("Grapple", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainAreaEntrance"), lambda s: s.has("InnerWellspring.DrainLever", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoomTop"), lambda s: s.has_any(("InnerWellspring.DrainRoomTopWheel", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> C.InnerWellspring.DrainRoomTop"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> H.InnerWellspring.DrainRoomTop"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.LaserOre"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.LaserOre"), lambda s: s.has_all(("Dash", "Glide"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.LaserOre"), lambda s: s.has_all(("Dash", "Glide"), p) and has_enough_resources([], [('combat', 'Miner')], "InnerWellspring.DrainRoomTop", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.LaserOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.DrainRoomCenter"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has_all(("InnerWellspring.DrainRoomTopWheel", "Grapple"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> C.InnerWellspring.BelowDrainLever"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.DrainLever"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.DrainLever"), lambda s: s.has_all(("InnerWellspring.UpperCorruption", "Double Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.DrainLever"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "InnerWellspring.BelowDrainLever", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has_all(("InnerWellspring.UpperCorruption", "Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has_all(("InnerWellspring.UpperCorruption", "Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.AbovePole"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.AbovePole"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.WestDoor"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.WestDoor"), lambda s: s.has_any(("InnerWellspring.UpperCorruption", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.DrainRoomTop"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.DrainRoomCenter"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.AbovePole -> InnerWellspring.UpperCorruption"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "InnerWellspring.AbovePole", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.AbovePole -> InnerWellspring.LupoEX"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.AbovePole -> InnerWellspring.BelowDrainLever"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor (Door) -> InnerWellspring.WestDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.WestDoor (Door)"), lambda s: s.has("InnerWellspring.MiddleDoorsOpen", p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> C.InnerWellspring.WestDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> H.InnerWellspring.WestDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> E.InnerWellspring.WestDoor"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.MiddleDoorsOpen"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.MiddleDoorsOpen"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.WestDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.ShortcutWheelEX"), lambda s: s.has("InnerWellspring.ShortCutWheel", p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.LupoMap"), lambda s: s.has("Grapple", p) and can_buy_map(s, p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.LupoMap"), lambda s: s.has("Bash", p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.LupoMap"), lambda s: s.has("InnerWellspring.UpperCorruption", p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTreeEX"), lambda s: s.has_all(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTreeEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "InnerWellspring.WestDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTreeEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.WestDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTreeEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTree"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTree"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.WestDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.BelowDrainLever"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor (Door) -> InnerWellspring.EastDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.EastDoor (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> C.InnerWellspring.EastDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> H.InnerWellspring.EastDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> E.InnerWellspring.EastDoor"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.SpinArena"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and has_enough_resources([('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Miner')], [], "InnerWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.SpinningRoomOpen"), lambda s: s.has("InnerWellspring.SpinArena", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "InnerWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.HandToHandHerbs"), lambda s: s.has("GladesTown.HandToHandPouch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.AboveSpinArenaEX"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.AboveSpinArenaEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.SpinPuzzle"), lambda s: s.has("InnerWellspring.SpinningRoomOpen", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("InnerWellspring.TopDoorOpen", "Grapple"), p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("InnerWellspring.TopDoorOpen", "Bash"), p) and s.has_any(("Double Jump", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.EastDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("InnerWellspring.TopDoorOpen", "Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> C.InnerWellspring.SpinPuzzle"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.SpinPuzzleSolved"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.SpinPuzzleSolved"), lambda s: s.has_all(("Grapple", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.SpinPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.SpinPuzzleSolved"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.RotateRoomEX"), lambda s: s.has("InnerWellspring.SpinPuzzleSolved", p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.RotateRoomOre"), lambda s: s.has("InnerWellspring.SpinPuzzleSolved", p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.PastSpinPuzzle"), lambda s: s.has("InnerWellspring.SpinPuzzleSolved", p) and s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.EastDoor"), lambda s: s.has("InnerWellspring.SpinningRoomOpen", p) and s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.EastDoor"), lambda s: s.has_all(("InnerWellspring.SpinningRoomOpen", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.SpinPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> C.InnerWellspring.PastSpinPuzzle"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Miner')], [], "InnerWellspring.PastSpinPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.SpinPuzzle"), lambda s: s.has("InnerWellspring.SpinPuzzleSolved", p) and s.has_any(("Double Jump", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.SpinPuzzle"), lambda s: s.has_all(("InnerWellspring.SpinPuzzleSolved", "Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> C.InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("Grapple", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.PastSpinPuzzle"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Launch"), p) and has_enough_resources([('combat', 'Slug'), ('combat', 'Slug')], [], "InnerWellspring.GrappleThroughZigZagSpikes", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.PastSpinPuzzle"), lambda s: s.has_all(("Glide", "Bash"), p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.TopDoorOpen"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "InnerWellspring.TopSecondRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.NeedleQI"), lambda s: s.has("InnerWellspring.TopDoorOpen", p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.EastDoor"), lambda s: s.has("InnerWellspring.TopDoorOpen", p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Glide", "Bash"), p) and s.has_any(("Clean Water", "Double Jump", "Dash", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Glide", p) and s.has_any(("Clean Water", "Double Jump", "Dash", "Grapple", "Launch"), p) and has_enough_resources([('combat', 'Miner')], [], "InnerWellspring.TopSecondRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Double Jump", "Dash"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Double Jump", "Dash"), p) and has_enough_resources([], [('combat', 'Miner')], "InnerWellspring.TopSecondRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Launch", "Clean Water"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter (Door) -> InnerWellspring.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.Teleporter (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> F.InnerWellspring.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.BlueMoonSeed"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.BlueMoonSeed"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.BlueMoonSeed"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.LibraryEX"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.AboveTpEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.AboveTpEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.AboveTpEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.SwimOre"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> OpherShop"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.EscapeSequence"), lambda s: s.has_all(("Double Jump", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.EscapeSequence"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.EscapeSequence"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.EscapeSequence"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "InnerWellspring.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.EscapeSequence"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EscapeSequence -> F.InnerWellspring.EscapeSequence"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.EscapeSequence -> InnerWellspring.WaterEscape"), lambda s: s.has_all(("Bash", "Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EscapeSequence -> InnerWellspring.WaterEscape"), lambda s: s.has_all(("Bash", "Grapple", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EscapeSequence -> InnerWellspring.WaterEscape"), lambda s: s.has_all(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EscapeSequence -> InnerWellspring.EscapeRevisitEX"), lambda s: s.has("InnerWellspring.WaterEscape", p), "or")
    add_rule(w.get_entrance("WoodsEntry.ShriekMeet -> C.WoodsEntry.ShriekMeet"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.ShriekMeet -> WoodsEntry.FirstMud"), lambda s: s.has_any(("Bash", "Launch"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsEntry.ShriekMeet", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.ShriekMeet -> WoodsEntry.FirstMud"), lambda s: has_enough_resources([('combat', 'Balloon')], [('combat', 'Tentacle')], "WoodsEntry.ShriekMeet", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.ShriekMeet -> EastHollow.Kwolok"), lambda s: s.has_all(("EastHollow.SilentSwimWall", "Clean Water"), p) and can_enter_area("EastHollow", s, p, o), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> C.WoodsEntry.FirstMud"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.MudPitEX"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.MudPitEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WoodsEntry.FirstMud", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.BelowTeleporter"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsEntry.FirstMud", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.BelowTeleporter"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsEntry.FirstMud", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.ShriekMeet"), lambda s: s.has_any(("Bash", "Launch"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsEntry.FirstMud", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.ShriekMeet"), lambda s: has_enough_resources([('combat', 'Balloon')], [('combat', 'Tentacle')], "WoodsEntry.FirstMud", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut (Door) -> WoodsEntry.FamilyHut"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut -> WoodsEntry.FamilyHut (Door)"), lambda s: s.has("GladesTown.FamilyReunionKey", p), "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut -> WoodsEntry.FirstMud"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut -> WoodsEntry.ShriekMeet"), lambda s: has_enough_resources([('combat', 'Balloon')], [], "WoodsEntry.FamilyHut", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut -> WoodsEntry.Teleporter"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut -> WoodsEntry.Teleporter"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut -> WoodsEntry.Teleporter"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsEntry.FamilyHut", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHutInside (Door) -> WoodsEntry.FamilyHutInside"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHutInside -> WoodsEntry.FamilyHutInside (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHutInside -> WoodsEntry.DollQI"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> C.WoodsEntry.BelowTeleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.FirstMud"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsEntry.BelowTeleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.Teleporter"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.Teleporter"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsEntry.BelowTeleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.Teleporter"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.TwoKeystoneRoom"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon')], [], "WoodsEntry.BelowTeleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> F.WoodsEntry.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LastTreeBranch"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.TreeSeed"), lambda s: s.has("TuleyShop.LastTreeBranchRejected", p), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.TpEX"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LeafPileEX"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LedgeOre"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LedgeOre"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsEntry.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LedgeOre"), lambda s: s.has_all(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.FirstMud"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.BelowTeleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.FamilyHut"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> C.WoodsEntry.TwoKeystoneRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> E.WoodsEntry.TwoKeystoneRoom"), lambda s: s.has_all(("WoodsEntry.KeystoneDoor", "BreakCrystal"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsEntry.KeystoneDoor"), lambda s: can_open_door("WoodsEntry.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsEntry.LowerKS"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsEntry.UpperKS"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has("WoodsEntry.KeystoneDoor", p) and s.has_any(("Bash", "Launch"), p) and can_enter_area("WoodsMain", s, p, o), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has("WoodsEntry.KeystoneDoor", p) and can_enter_area("WoodsMain", s, p, o) and has_enough_resources([], [('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Tentacle')], "WoodsEntry.TwoKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsEntry.BelowTeleporter"), lambda s: s.has_any(("Double Jump", "Glide", "Launch"), p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon')], [], "WoodsEntry.TwoKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> C.WoodsMain.AfterKuMeet"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsEntry.KeystoneDoor"), lambda s: can_open_door("WoodsEntry.KeystoneDoor", s, p, o.spawn.value) and s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsEntry.KeystoneDoor"), lambda s: can_open_door("WoodsEntry.KeystoneDoor", s, p, o.spawn.value) and has_enough_resources([], [('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Tentacle')], "WoodsMain.AfterKuMeet", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsMain.BelowFourKeystoneRoom"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsMain.BelowFourKeystoneRoom"), lambda s: s.has_any(("Bash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsEntry.TwoKeystoneRoom"), lambda s: s.has("WoodsEntry.KeystoneDoor", p) and s.has_any(("Bash", "Launch"), p) and can_enter_area("WoodsEntry", s, p, o), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsEntry.TwoKeystoneRoom"), lambda s: s.has("WoodsEntry.KeystoneDoor", p) and can_enter_area("WoodsEntry", s, p, o) and has_enough_resources([], [('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Tentacle')], "WoodsMain.AfterKuMeet", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.LowerLeafPileEX"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.FourKeystoneRoom"), lambda s: s.has_all(("Flap", "Glide"), p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon')], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon'), ('energy', ('Grenade', 3))], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has_all(("Bash", "Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon'), ('energy', ('Grenade', 1))], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has("Launch", p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon')], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2)), ('db', 10)], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 10)], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.BehindWallOre"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "WoodsMain.WallOreLedge", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.BelowKeystonesEX"), lambda s: s.has_all(("Glide", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.BelowKeystonesEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.BelowFourKeystoneRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.FourKeystoneRoom"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.FourKeystoneRoom"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> C.WoodsMain.FourKeystoneRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.KeystoneDoor"), lambda s: can_open_door("WoodsMain.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.KSRoomYellowBarrierBroken"), lambda s: s.has("Flap", p) and s.has_any(("Double Jump", "Glide"), p) and has_enough_resources([('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto')], [], "WoodsMain.FourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.KSRoomYellowBarrierBroken"), lambda s: s.has_all(("Bash", "Flap"), p) and s.has_any(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.MiddleLeafPileEX"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.RightKS"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.RightKS"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.FourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.UpperKS"), lambda s: s.has_any(("Glide", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "WoodsMain.FourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.UpperKS"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 3)), ('energy', ('Grenade', 1))], [], "WoodsMain.FourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.LeftKS"), lambda s: s.has("Glide", p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsMain.FourKeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.LowerKS"), lambda s: s.has("WoodsMain.KSRoomYellowBarrierBroken", p) and s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.LowerKS"), lambda s: s.has_all(("WoodsMain.KSRoomYellowBarrierBroken", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.LowerKS"), lambda s: s.has_all(("WoodsMain.KSRoomYellowBarrierBroken", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.GiantSkull"), lambda s: s.has("WoodsMain.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.BelowFourKeystoneRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> C.WoodsMain.GiantSkull"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.KeystoneDoor"), lambda s: can_open_door("WoodsMain.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.UpperLeafPileEX"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.BehindDoorRoofEX"), lambda s: s.has_any(("Bash", "Launch"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsMain.GiantSkull", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.BehindDoorRoofEX"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsMain.GiantSkull", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.BalloonLure"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsMain.GiantSkull", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.FourKeystoneRoom"), lambda s: s.has("WoodsMain.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> C.WoodsMain.BalloonLure"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.BalloonLureBlobDestroyed"), lambda s: s.has("Glide", p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "WoodsMain.BalloonLure", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.BalloonLureYellowBarrierBroken"), lambda s: s.has_all(("WoodsMain.BalloonLureBlobDestroyed", "Flap", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.BelowHiddenOre"), lambda s: s.has_all(("WoodsMain.BalloonLureBlobDestroyed", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.GiantSkull"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.GiantSkull"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowHiddenOre -> WoodsMain.BalloonLureBlobDestroyed"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowHiddenOre -> WoodsMain.BalloonLureBlobDestroyed"), lambda s: s.has_any(("Grenade", "Blaze"), p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "WoodsMain.BelowHiddenOre", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BelowHiddenOre -> WoodsMain.HiddenOre"), lambda s: s.has_all(("Flap", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowHiddenOre -> WoodsMain.YellowWallEX"), lambda s: s.has("WoodsMain.BalloonLureYellowBarrierBroken", p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowHiddenOre -> WoodsMain.PetrifiedHowl"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowHiddenOre -> WoodsMain.BalloonLure"), lambda s: s.has("WoodsMain.BalloonLureBlobDestroyed", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowHiddenOre -> WoodsMain.BalloonLure"), lambda s: s.has("WoodsMain.BalloonLureBlobDestroyed", p) and has_enough_resources([], [('combat', 'Tentacle')], "WoodsMain.BelowHiddenOre", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> C.WoodsMain.PetrifiedHowl"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> H.WoodsMain.PetrifiedHowl"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.PetrifiedHowlEX"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.AboveHowl"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.BrokenOwl"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "WoodsMain.PetrifiedHowl", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.BelowHiddenOre"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.BelowHiddenOre"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> C.WoodsMain.BrokenOwl"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> WoodsMain.AboveHowl"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> WoodsMain.AboveHowl"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WoodsMain.BrokenOwl", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> WoodsMain.TrialStart"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> WoodsMain.TrialStart"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.BrokenOwl", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.TrialStart -> WoodsMain.SpiritTrial"), lambda s: s.has_all(("WoodsMain.TrialActivation", "Double Jump", "Dash", "Bash", "Grapple", "Burrow"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialStart -> WoodsMain.BrokenOwl"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.TrialStart -> WoodsMain.MidwayTrial"), lambda s: s.has_all(("Double Jump", "Bash", "Grapple"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialStart -> WoodsMain.MidwayTrial"), lambda s: s.has_all(("Launch", "Grapple", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> C.WoodsMain.MidwayTrial"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.TrialEnd"), lambda s: s.has_all(("Double Jump", "Bash", "Burrow"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.TrialEnd"), lambda s: s.has_all(("Launch", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> C.WoodsMain.TrialEnd"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.TrialActivation"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.OverflowShard"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.OverflowShard"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.BeforeLog"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.HiddenEX"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.PetrifiedHowl"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BrokenOwl"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BeforeLog"), lambda s: s.has("Double Jump", p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsMain.AboveHowl", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BeforeLog"), lambda s: s.has("Bash", p) and has_enough_resources([('combat', 'Balloon'), ('energy', ('Grenade', 1))], [], "WoodsMain.AboveHowl", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BeforeLog"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> C.WoodsMain.BeforeLog"), lambda s: has_enough_resources([('combat', 'Balloon')], [], "WoodsMain.BeforeLog", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> WoodsMain.LogBlobDestroyed"), lambda s: has_enough_resources([('combat', 'Balloon'), ('wall', ('BreakWall', 3))], [], "WoodsMain.BeforeLog", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> WoodsMain.Teleporter"), lambda s: s.has("WoodsMain.LogBlobDestroyed", p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon')], [], "WoodsMain.BeforeLog", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> WoodsMain.AboveHowl"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> F.WoodsMain.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.AbovePit"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.AbovePit"), lambda s: s.has_all(("Double Jump", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.OrangeTree -> WoodsMain.AbovePit"), lambda s: s.has_any(("Bash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.OrangeTree -> WoodsMain.BeforeLog"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.OrangeTree"), lambda s: s.has_any(("Bash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.FeedingGrounds"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.FeedingGrounds"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.FeedingGrounds"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.AbovePit", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> C.WoodsMain.FeedingGrounds"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> WoodsShrine"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> WoodsShrine"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("Grapple", "Glide"), p) and s.has_any(("Double Jump", "Dash", "Launch"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Double Jump", "Bash", "Grapple"), p) and can_enter_area("LowerWastes", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.FeedingGrounds", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Grapple", "Glide"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Burrow"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Launch"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> WoodsMain.AbovePit"), lambda s: s.has_all(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> WoodsMain.AbovePit"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsShrine -> F.WoodsShrine"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsShrine -> WoodsMain.CombatShrineCompleted"), lambda s: s.has("Regenerate", p) and has_enough_resources([('combat', 'Hornbug'), ('combat', 'Lizard'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'CrystalMiner'), ('combat', 'CrystalMiner'), ('combat', 'Bat'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Bat'), ('db', 80)], [], "WoodsShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsShrine -> WoodsMain.CombatShrineCompleted"), lambda s: s.has("Regenerate", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Hornbug'), ('combat', 'Lizard'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'CrystalMiner'), ('combat', 'CrystalMiner'), ('combat', 'Bat'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Bat'), ('db', 65)], [], "WoodsShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsShrine -> WoodsMain.CombatShrineCompleted"), lambda s: s.has_all(("Regenerate", "Launch"), p) and has_enough_resources([('combat', 'Hornbug'), ('combat', 'Lizard'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'CrystalMiner'), ('combat', 'CrystalMiner'), ('combat', 'Bat'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Balloon'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Bat'), ('db', 50)], [], "WoodsShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("WoodsShrine -> WoodsMain.ShrineEX"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsShrine -> WoodsMain.CombatShrine"), lambda s: s.has("WoodsMain.CombatShrineCompleted", p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> C.LowerReach.Entry"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Entry -> H.LowerReach.Entry"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.BearSneezed"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.ThawBaurFurnace"), lambda s: s.has_all(("LowerReach.BearSneezed", "LowerReach.BearBridgeBroken", "Bash", "Flap"), p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.ThawBaurFurnace"), lambda s: s.has_all(("LowerReach.BearSneezed", "LowerReach.BearBridgeBroken"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Entry", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.FreezeBaurFurnace"), lambda s: s.has_all(("LowerReach.BearSneezed", "LowerReach.BearBridgeBroken", "Flap"), p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.BelowBaurEX"), lambda s: s.has_all(("LowerReach.BearSneezed", "LowerReach.BearBridgeBroken", "Double Jump", "Dash", "Bash", "Flap"), p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.BelowBaurEX"), lambda s: s.has_all(("LowerReach.BearSneezed", "LowerReach.BearBridgeBroken", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Entry", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.BelowBaurEX"), lambda s: s.has_all(("LowerReach.BearSneezed", "LowerReach.BearBridgeBroken", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.AboveEntry"), lambda s: s.has_all(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.AboveEntry"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.AboveEntry"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerReach.Entry", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> WestGlades.Upper"), lambda s: s.has("LowerReach.BearSneezed", p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> C.LowerReach.AboveEntry"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.Lever"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.Lever"), lambda s: s.has_all(("LowerReach.ThawBaurFurnace", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurLowerEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurLowerEX"), lambda s: s.has_all(("LowerReach.FreezeBaurFurnace", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.AboveEntry", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurLowerEX"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has("LowerReach.ThawBaurFurnace", p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurLowerEX"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerReach.AboveEntry", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurUpperEX"), lambda s: s.has_all(("LowerReach.ThawBaurFurnace", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurUpperEX"), lambda s: s.has_all(("LowerReach.ThawBaurFurnace", "Double Jump", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.Icefall"), lambda s: s.has_any(("LowerReach.ThawBaurFurnace", "Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("LowerReach.Lever", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("LowerReach.Lever", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.Entry"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> C.LowerReach.Icefall"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> E.LowerReach.Icefall"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.BearBridgeBroken"), lambda s: s.has("LowerReach.BearSneezed", p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Icefall", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('combat', 'Nest')], [], "LowerReach.Icefall", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: s.has("Launch", p) and s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Icefall", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Grenade', 1))], [('combat', 'Nest')], "LowerReach.Icefall", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallOre"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallOre"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallOre"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Nest')], [], "LowerReach.Icefall", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Double Jump", "Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Double Jump", "Grapple"), p) and has_enough_resources([('combat', 'Nest')], [], "LowerReach.Icefall", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Launch"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Launch"), p) and has_enough_resources([], [('combat', 'Nest')], "LowerReach.Icefall", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Launch", "Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.AboveEntry"), lambda s: s.has_any(("LowerReach.ThawBaurFurnace", "Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.Entry"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.CentralEnemyPaths -> C.LowerReach.CentralEnemyPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.CentralEnemyPaths -> LowerReach.Central"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.AboveDoorEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.AboveDoorEX"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Double Jump", "Dash"), p) and s.has("Hammer", p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.AboveDoorEX"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Double Jump", "Dash"), p) and has_enough_resources([], [('energy', ('Spear', 1))], "LowerReach.Central", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.LupoMap"), lambda s: s.has("Launch", p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.LupoMap"), lambda s: s.has_all(("Double Jump", "Dash"), p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.LupoMap"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Bash"), p) and can_buy_map(s, p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Central", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.TPLeftEX"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.SecondSoup"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Double Jump", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Central", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.Entry"), lambda s: s.has_all(("LowerReach.Lever", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.Entry"), lambda s: s.has_all(("LowerReach.Lever", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> C.LowerReach.OutsideTPRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> F.LowerReach.OutsideTPRoom"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> H.LowerReach.OutsideTPRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> E.LowerReach.OutsideTPRoom"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.AboveDoorEX"), lambda s: s.has_any(("Bash", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.AboveDoorEX"), lambda s: has_enough_resources([], [('energy', ('Spear', 1))], "LowerReach.OutsideTPRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.LupoMap"), lambda s: can_buy_map(s, p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.TPLeftEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.TPLeftEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.HiddenOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.HiddenOre"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Double Jump", "Bash"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.HiddenOre"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Double Jump", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerReach.OutsideTPRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.SecondSoup"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.CentralEnemyPaths"), lambda s: s.has_any(("Double Jump", "Dash", "Bash", "Glide", "Launch", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.CentralEnemyPaths"), lambda s: has_enough_resources([], [('energy', ('Spear', 1))], "LowerReach.OutsideTPRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.Teleporter"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.BelowTokk"), lambda s: s.has_all(("Double Jump", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.BelowTokk"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> C.LowerReach.BelowTokk"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> LowerReach.OutsideTPRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.KeystoneRoom"), lambda s: s.has_all(("Double Jump", "Dash", "Bash"), p) and can_enter_area("UpperReach", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.KeystoneRoom"), lambda s: s.has_all(("Double Jump", "Bash"), p) and can_enter_area("UpperReach", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.BelowTokk", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.KeystoneRoom"), lambda s: s.has("Launch", p) and can_enter_area("UpperReach", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.BurrowArea"), lambda s: s.has_all(("Burrow", "Double Jump", "Dash", "Bash"), p) and can_enter_area("UpperReach", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.BurrowArea"), lambda s: s.has_all(("Burrow", "Double Jump", "Bash"), p) and can_enter_area("UpperReach", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.BelowTokk", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.BurrowArea"), lambda s: s.has_all(("Burrow", "Launch"), p) and can_enter_area("UpperReach", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.Teleporter -> F.LowerReach.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Teleporter -> LowerReach.OutsideTPRoom"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Teleporter -> LowerReach.EastEnemyPaths"), lambda s: s.has("LowerReach.TPLantern", p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.ThawCentralFurnace"), lambda s: s.has_all(("Flap", "Bash", "Double Jump", "Dash"), p) and has_enough_resources([('combat', 'ShieldMiner')], [], "LowerReach.SecondSoup", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.MeltIceEX"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.SecondSoup", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.BurrowEX"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has("Flap", p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerReach.SecondSoup", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("Double Jump", "Burrow"), p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.CentralEnemyPaths"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.BelowLupo"), lambda s: s.has_any(("Bash", "Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.BelowLupo"), lambda s: has_enough_resources([], [('combat', 'ShieldMiner')], "LowerReach.SecondSoup", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.ThawCentralFurnace"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.BelowLupo", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.FreezeCentralFurnace"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.BelowLupoEX"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.BelowLupo", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.BelowLupoEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.BelowLupoEX"), lambda s: s.has("LowerReach.ThawCentralFurnace", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.SecondSoup"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.SecondSoup"), lambda s: has_enough_resources([], [('combat', 'ShieldMiner')], "LowerReach.BelowLupo", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.CentralFurnacePedestal"), lambda s: s.has_any(("LowerReach.ThawCentralFurnace", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> C.LowerReach.CentralFurnacePedestal"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> E.LowerReach.CentralFurnacePedestal"), lambda s: s.has("BreakCrystal", p) and s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> E.LowerReach.CentralFurnacePedestal"), lambda s: s.has("Hammer", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> E.LowerReach.CentralFurnacePedestal"), lambda s: s.has("Sword", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'ShieldMiner')], [], "LowerReach.CentralFurnacePedestal", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> E.LowerReach.CentralFurnacePedestal"), lambda s: has_enough_resources([('combat', 'ShieldMiner'), ('energy', ('Bow', 1))], [], "LowerReach.CentralFurnacePedestal", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.ThawCentralFurnace"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.CentralFurnacePedestal", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.FreezeCentralFurnace"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.BelowLupo"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.BelowLupo"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.CentralFurnacePedestal", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.WindChannel"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.WindChannel"), lambda s: has_enough_resources([], [('combat', 'ShieldMiner')], "LowerReach.CentralFurnacePedestal", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> C.LowerReach.WindChannel"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindLantern"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.WindChannel", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.BreakWallEX"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerReach.WindChannel", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindBottomEX"), lambda s: s.has_all(("LowerReach.WindLantern", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindHiddenEX"), lambda s: s.has_all(("LowerReach.WindLantern", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.CentralFurnacePedestal"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.CentralFurnacePedestal"), lambda s: has_enough_resources([], [('combat', 'ShieldMiner')], "LowerReach.WindChannel", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.SoupMoki"), lambda s: s.has_all(("LowerReach.WindLantern", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> E.LowerReach.SoupMoki"), lambda s: s.has("BreakCrystal", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.HandToHandHat"), lambda s: s.has("LowerReach.HandToHandSoup", p), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.WindChannel"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.EastEnemyPaths"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.SoupMoki", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.EastEnemyPaths"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.EastEnemyPaths -> F.LowerReach.EastEnemyPaths"), lambda s: s.has("LowerReach.TPLantern", p), "or")
    add_rule(w.get_entrance("LowerReach.EastEnemyPaths -> LowerReach.East"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.East -> LowerReach.Teleporter"), lambda s: s.has("LowerReach.TPLantern", p), "or")
    add_rule(w.get_entrance("LowerReach.East -> LowerReach.SnowballEnemyPaths"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerReach.East", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.East -> LowerReach.SnowballEnemyPaths"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.East -> LowerReach.SoupMoki"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.SnowballEnemyPaths -> C.LowerReach.SnowballEnemyPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.SnowballEnemyPaths -> LowerReach.Snowball"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.TPLantern"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Snowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.TPLantern"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [('combat', 'WeakSlug')], "LowerReach.Snowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.RolledSnowball"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Snowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.RolledSnowball"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [('combat', 'Mantis')], "LowerReach.Snowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.SnowballHC"), lambda s: s.has_all(("LowerReach.RolledSnowball", "Burrow"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.SnowballHC"), lambda s: s.has_all(("LowerReach.RolledSnowball", "Burrow"), p) and has_enough_resources([], [('db', 20)], "LowerReach.Snowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.EastEnemyPaths"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'WeakSlug')], [], "LowerReach.Snowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.EastEnemyPaths"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.EastEnemyPaths"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.SoupMoki"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.PastSnowball"), lambda s: s.has("LowerReach.RolledSnowball", p) and s.has_any(("Double Jump", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.PastSnowball"), lambda s: s.has_all(("LowerReach.RolledSnowball", "Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Snowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.PastSnowball"), lambda s: s.has_all(("LowerReach.RolledSnowball", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerReach.Snowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> C.LowerReach.PastSnowball"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> E.LowerReach.PastSnowball"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.RoofLeftEX"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.RoofLeftEX"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.PastSnowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.IceCavern"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.PastSnowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.IceCavern"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.SnowballEnemyPaths"), lambda s: s.has_all(("LowerReach.RolledSnowball", "LowerReach.ThawCentralFurnace"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.SnowballEnemyPaths"), lambda s: s.has_all(("LowerReach.RolledSnowball", "LowerReach.ThawCentralFurnace"), p) and has_enough_resources([], [('combat', 'Lizard')], "LowerReach.PastSnowball", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.SnowballEnemyPaths"), lambda s: s.has_all(("LowerReach.RolledSnowball", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.RoofRightEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.PastSnowball"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.EastDoorLantern"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.HalfwayIceCavern", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.EastDoorLantern"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.HalfwayIceCavern", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.SwimmingPool"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.SwimmingPool"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.IceCavern"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.IceCavern"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> E.LowerReach.SwimmingPool"), lambda s: s.has("BreakCrystal", p) and s.has_any(("LowerReach.FreezeEastFurnace", "Clean Water"), p), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.FractureShard"), lambda s: s.has_all(("LowerReach.ThawEastFurnace", "Clean Water"), p), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.ArenaArea"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "LowerReach.FreezeEastFurnace", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.SwimmingPool", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.ArenaArea"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "Launch"), p) and s.has_any(("LowerReach.FreezeEastFurnace", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.EastFurnace"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.SwimmingPool", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.EastFurnace"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.EastFurnace -> C.LowerReach.EastFurnace"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.EastFurnace -> LowerReach.ThawEastFurnace"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.EastFurnace", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.EastFurnace -> LowerReach.FreezeEastFurnace"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("LowerReach.EastFurnace -> LowerReach.PastSnowball"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerReach.EastFurnace", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.EastFurnace -> LowerReach.SwimmingPool"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> C.LowerReach.ArenaArea"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> H.LowerReach.ArenaArea"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> E.LowerReach.ArenaArea"), lambda s: s.has_all(("BreakCrystal", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> E.LowerReach.ArenaArea"), lambda s: s.has_all(("BreakCrystal", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.ArenaBeaten"), lambda s: s.has("Regenerate", p) and has_enough_resources([('db', 40), ('combat', 'ShieldMiner'), ('combat', 'ShieldMiner'), ('combat', 'ShieldMiner'), ('combat', 'Hornbug'), ('combat', 'Bee'), ('combat', 'Bee')], [], "LowerReach.ArenaArea", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.TrialStart"), lambda s: s.has("LowerReach.ArenaBeaten", p), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.WindSpinners"), lambda s: s.has_all(("LowerReach.ArenaBeaten", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.SwimmingPool"), lambda s: s.has("LowerReach.EastDoorLantern", p) and s.has_any(("LowerReach.FreezeEastFurnace", "Clean Water"), p), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.SwimmingPool"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "Launch", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindSpinners -> LowerReach.WispPathCheckpoint"), lambda s: s.has("Glide", p) and s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindSpinners -> LowerReach.WispPathCheckpoint"), lambda s: s.has_all(("Glide", "Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.WindSpinners", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.WindSpinners -> LowerReach.ArenaArea"), lambda s: s.has_all(("Glide", "LowerReach.ArenaBeaten"), p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> C.LowerReach.WispPathCheckpoint"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> H.LowerReach.WispPathCheckpoint"), lambda s: s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> E.LowerReach.WispPathCheckpoint"), lambda s: s.has_all(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> E.LowerReach.WispPathCheckpoint"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> LowerReach.BridgeWispPath"), lambda s: s.has("Bash", p) and s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> LowerReach.BridgeWispPath"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 3))], "LowerReach.WispPathCheckpoint", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> LowerReach.WindSpinners"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> C.LowerReach.BridgeWispPath"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.SnowEscape"), lambda s: s.has_all(("Bash", "Glide"), p) and s.has_any(("Double Jump", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.BridgeWispPath", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.SnowEscape"), lambda s: s.has_all(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.WispPathCheckpoint"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.WispPathCheckpoint"), lambda s: has_enough_resources([('combat', 'WeakSlug'), ('combat', 'Miner')], [], "LowerReach.BridgeWispPath", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> F.LowerReach.SnowEscape"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.ForestsMemory"), lambda s: s.has_all(("Dash", "Bash", "Grapple", "Glide"), p) and s.has_any(("Clean Water", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.ForestsMemory"), lambda s: s.has_all(("Bash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.BearSneezed"), lambda s: s.has_all(("Dash", "Bash", "Grapple", "Glide"), p) and s.has_any(("Clean Water", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.BearSneezed"), lambda s: s.has_all(("Bash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.EscapeRevisitEX"), lambda s: s.has("LowerReach.ForestsMemory", p), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> C.LowerReach.VeralHome"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> LowerReach.HandToHandSoup"), lambda s: s.has("InnerWellspring.HandToHandHerbs", p), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> GladesTown.LeafPileEX"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> LowerReach.CatalystShard"), lambda s: s.has_all(("Clean Water", "Bash", "Flap"), p), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> LowerReach.CatalystShard"), lambda s: s.has("Clean Water", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.VeralHome", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> GladesTown.HoleHut"), lambda s: s.has_any(("Dash", "Glide"), p) and can_enter_area("GladesTown", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> GladesTown.PlayfulMoki"), lambda s: can_enter_area("GladesTown", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> TuleyShop"), lambda s: s.has("GladesTown.TuleySpawned", p), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> LowerReach.TownEntry"), lambda s: s.has("Bash", p) and s.has("Flap", p), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> LowerReach.TownEntry"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerReach.VeralHome", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> LowerReach.TownEntry"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.TownEntry -> LowerReach.VeralHome"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.TownEntry -> LowerReach.TrialStart"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> C.LowerReach.TrialStart"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.KeystoneDoor"), lambda s: can_open_door("LowerReach.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.TrialActivation"), lambda s: s.has("LowerReach.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.SpiritTrial"), lambda s: s.has_all(("LowerReach.TrialActivation", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.RightKS"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.RightKS"), lambda s: s.has_all(("Double Jump", "Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.TrialStart", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.RightKS"), lambda s: s.has("Launch", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.RightKS"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 20)], "LowerReach.TrialStart", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.UpperLeftKS"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.MiddleLeftKS"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.BottomLeftKS"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.TrialEX"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.TownEntry"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.ArenaArea"), lambda s: s.has_all(("LowerReach.ArenaBeaten", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.BurrowArea -> UpperReach.LifeForceEX"), lambda s: s.has_all(("Burrow", "Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperReach.BurrowArea -> UpperReach.LifeForceShard"), lambda s: s.has_all(("Burrow", "Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperReach.BurrowArea -> LowerReach.BelowTokk"), lambda s: s.has("Burrow", p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> C.UpperReach.KeystoneRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.ThawFurnace"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.ThawFurnace"), lambda s: s.has_all(("Flap", "Bash"), p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.FreezeFurnace"), lambda s: s.has("Flap", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.LowerKS"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.LowerKS"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.LowerKS"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.LowerKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> Tokk"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('combat', 'ShieldMiner'), ('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Clean Water", "Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Clean Water", "Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Double Jump", "Dash", "Glide", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Double Jump", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Double Jump", "Bash", "Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoupFrozen"), lambda s: s.has_all(("UpperReach.FreezeFurnace", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoupFrozen"), lambda s: s.has_all(("UpperReach.FreezeFurnace", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Clean Water"), p) and s.has_any(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Clean Water"), p) and has_enough_resources([], [('combat', 'ShieldMiner')], "UpperReach.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Double Jump"), p) and s.has_any(("Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Clean Water", "Water Dash", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> LowerReach.BelowTokk"), lambda s: can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlant -> UpperReach.KeystoneSnapPlantPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlant -> UpperReach.KeystoneSnapPlantThawedPaths"), lambda s: s.has("UpperReach.ThawFurnace", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlant -> UpperReach.UpperSoup"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlant -> UpperReach.UpperSoup"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawed -> UpperReach.KeystoneSnapPlantPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawed -> UpperReach.KeystoneSnapPlantThawedPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawed -> UpperReach.UpperSoupThawed"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawed -> UpperReach.UpperSoupThawed"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantPaths -> UpperReach.MiddleLeftKS"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantPaths -> UpperReach.KeystoneRoom"), lambda s: s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawedPaths -> UpperReach.LowerKS"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoup -> UpperReach.UpperSoupPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoup -> UpperReach.UpperSoupFrozenPaths"), lambda s: s.has("UpperReach.FreezeFurnace", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoup -> UpperReach.UpperSoupThawedPaths"), lambda s: s.has("UpperReach.ThawFurnace", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupFrozen -> UpperReach.UpperSoupPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupFrozen -> UpperReach.UpperSoupFrozenPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawed -> UpperReach.UpperSoupPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawed -> UpperReach.UpperSoupThawedPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> C.UpperReach.UpperSoupPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> H.UpperReach.UpperSoupPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.SoupOre"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.UpperKS"), lambda s: s.has_all(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.UpperKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.SwingPoleEX"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.SwingPoleEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.UpperSoupPaths", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.SwingPoleEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.KeystoneRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.KeystoneSnapPlant"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupFrozenPaths -> C.UpperReach.UpperSoupFrozenPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> C.UpperReach.UpperSoupThawedPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> UpperReach.LowerKS"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> UpperReach.MiddleRightKS"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> UpperReach.MiddleRightKS"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.UpperSoupThawedPaths", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> UpperReach.MiddleRightKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> UpperReach.OutsideTreeRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> C.UpperReach.OutsideTreeRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> E.UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "BreakCrystal", "Clean Water", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> E.UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "BreakCrystal", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> UpperReach.KeystoneDoor"), lambda s: can_open_door("UpperReach.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> UpperReach.SwimEX"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Clean Water"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> UpperReach.UpperSoupThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Grapple", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> UpperReach.UpperSoupThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.OutsideTreeRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> UpperReach.TreeRoomLedge"), lambda s: s.has("UpperReach.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.KeystoneDoor"), lambda s: can_open_door("UpperReach.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeOre"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.TreeRoomLedge", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeOre"), lambda s: s.has_all(("Bash", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.TreeRoomLedge", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeOre"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom (Door) -> UpperReach.TreeRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.TreeRoom (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> E.UpperReach.TreeRoom"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.LightBurstTree"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.WellEX"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.HiddenEX"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.TreeRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.TreeRoomLedge"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 3))], [], "UpperReach.TreeRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.TreeRoomLedge"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperReach.SeedHut (Door) -> UpperReach.SeedHut"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.SeedHut -> UpperReach.SeedHut (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperReach.SeedHut -> UpperReach.SpringSeed"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.SeedHut", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> UpperDepths.EntrySpikesEX"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> UpperDepths.FirstFirefly"), lambda s: s.has("Glide", p) and has_enough_resources([('combat', 'BombSlug'), ('combat', 'BombSlug'), ('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'SneezeSlug')], [], "UpperDepths.Entry", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> UpperDepths.FirstFirefly"), lambda s: s.has_all(("Glide", "Bash"), p) and has_enough_resources([('combat', 'BombSlug'), ('combat', 'BombSlug')], [], "UpperDepths.Entry", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> EastHollow.AboveDepths"), lambda s: s.has_all(("EastHollow.DepthsOpen", "Glide"), p) and can_enter_area("EastHollow", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> C.UpperDepths.FirstFirefly"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryRoofEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryRoofEX"), lambda s: s.has_all(("Grapple", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryRoofEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryOre"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and has_enough_resources([('combat', 'Bat')], [], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryOre"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1)), ('combat', 'Spiderling')], [], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: s.has_any(("Double Jump", "Bash", "Launch"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [('combat', 'Spiderling')], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: s.has_any(("Double Jump", "Bash", "Launch"), p) and has_enough_resources([('energy', ('Spear', 1))], [], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: has_enough_resources([('energy', ('Spear', 1))], [('combat', 'Spiderling')], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.Entry"), lambda s: s.has("Glide", p) and has_enough_resources([('combat', 'BombSlug'), ('combat', 'BombSlug'), ('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'SneezeSlug')], [], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.Entry"), lambda s: s.has_all(("Glide", "Bash"), p) and has_enough_resources([('combat', 'BombSlug'), ('combat', 'BombSlug')], [], "UpperDepths.FirstFirefly", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.FirstKSRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.LeftEntryKS"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.LeftEntryKS"), lambda s: s.has("DepthsLight", p) and has_enough_resources([], [('combat', 'Spiderling')], "UpperDepths.FirstKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.SwimEC"), lambda s: s.has("Clean Water", p) and s.has_any(("Double Jump", "Bash", "Launch"), p) and has_enough_resources([('energy', ('Flash', 1))], [], "UpperDepths.FirstKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.SwimEC"), lambda s: s.has("Clean Water", p) and has_enough_resources([('energy', ('Flash', 1))], [('combat', 'Spiderling')], "UpperDepths.FirstKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.SwimEC"), lambda s: s.has_all(("UpperDepths.ForestsEyes", "Clean Water"), p) and s.has_any(("Double Jump", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.SwimEC"), lambda s: s.has_all(("UpperDepths.ForestsEyes", "Clean Water"), p) and has_enough_resources([], [('combat', 'Spiderling')], "UpperDepths.FirstKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and has_enough_resources([], [('combat', 'Spiderling'), ('combat', 'WeakSlug')], "UpperDepths.FirstKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.KeydoorLedge"), lambda s: s.has_all(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.KeydoorLedge"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.FirstKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.KeydoorLedge"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> C.UpperDepths.KeydoorLedge"), lambda s: s.has("UpperDepths.EntryKeystoneDoor", p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.LightPuzzle"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Double Jump", "Bash", "Grapple"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('wall', ('BreakWall', 16))], [], "UpperDepths.KeydoorLedge", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.LightPuzzle"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Bash", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('wall', ('BreakWall', 16))], [], "UpperDepths.KeydoorLedge", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.EntryKeystoneDoor"), lambda s: can_open_door("UpperDepths.EntryKeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.FirstKSRoom"), lambda s: s.has_any(("Double Jump", "Dash", "Grapple", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.RightKeystonePath"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.RightKeystonePath"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "UpperDepths.LightPuzzle", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Launch"), p) and s.has_any(("UpperDepths.LightPuzzle", "DepthsLight"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Bash", "DepthsLight"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Bash", "UpperDepths.LightPuzzle"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "DepthsLight"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Bat'), ('combat', 'Bat')], [], "UpperDepths.KeydoorLedge", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "UpperDepths.LightPuzzle"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Bat'), ('combat', 'Bat')], [], "UpperDepths.KeydoorLedge", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> C.UpperDepths.RightKeystonePath"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.RightEntryKS"), lambda s: s.has_all(("Grapple", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.RightEntryKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.FirstKSRoom"), lambda s: s.has_all(("Grapple", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.FirstKSRoom"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> C.UpperDepths.BelowHive"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has("Grapple", p) and s.has_any(("Bow", "Spear"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.BelowHive", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.BelowHive", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has("DepthsLight", p) and s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.BelowHive", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> E.UpperDepths.BelowHive"), lambda s: s.has("BreakCrystal", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.EntryKeystoneDoor"), lambda s: s.has("DepthsLight", p) and can_open_door("UpperDepths.EntryKeystoneDoor", s, p, o.spawn.value) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.HiveEX"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.KeydoorLedge"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "DepthsLight"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.Teleporter"), lambda s: s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.Teleporter"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.BelowHive", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.Central"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.LowerConnection"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> F.UpperDepths.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.TeleporterEX"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.BelowHive"), lambda s: s.has_any(("Bow", "Spear"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.BelowHive"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.BelowHive"), lambda s: s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.Central"), lambda s: s.has("Bow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.Central"), lambda s: s.has("Spear", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.Central"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.Teleporter", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Central -> C.UpperDepths.Central"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.CentralKeystoneDoor"), lambda s: can_open_door("UpperDepths.CentralKeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.SecondKSRoom"), lambda s: has_enough_resources([('combat', 'Spiderling'), ('combat', 'Spiderling'), ('wall', ('BreakWall', 1))], [], "UpperDepths.Central", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.SecondKSRoom"), lambda s: s.has("Bash", p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.SecondKSRoom"), lambda s: s.has("Bash", p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.Central", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.LowerConnection"), lambda s: s.has("UpperDepths.CentralKeystoneDoor", p), "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> C.UpperDepths.SecondKSRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> E.UpperDepths.SecondKSRoom"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.RightHealthKS"), lambda s: s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.RightHealthKS"), lambda s: has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has_all(("DepthsLight", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has("Launch", p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has("Launch", p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.KeystoneHC"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.KeystoneHC"), lambda s: s.has_all(("DepthsLight", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.KeystoneHC"), lambda s: s.has("Launch", p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.KeystoneHC"), lambda s: s.has("Launch", p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.BossPathEX"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.BossPathEX"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.BossPathEX"), lambda s: s.has_all(("DepthsLight", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.Central"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('combat', 'Spiderling')], [], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.Central"), lambda s: has_enough_resources([('combat', 'Spiderling')], [('wall', ('BreakWall', 1))], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.Central"), lambda s: s.has("Bash", p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.Central"), lambda s: s.has("Bash", p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.SecondKSRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.MoraPath"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Grapple"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.MoraPath"), lambda s: s.has_all(("DepthsLight", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> C.UpperDepths.MoraPath"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> E.UpperDepths.MoraPath"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has_all(("DepthsLight", "Grapple", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Dash", "Bash"), p) and has_enough_resources([('combat', 'Spiderling'), ('combat', 'Spiderling'), ('energy', ('Grenade', 1))], [], "UpperDepths.MoraPath", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has_all(("DepthsLight", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Grapple", "Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.MoraPath", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.SecondKSRoom"), lambda s: s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.OutsideMoraFight -> C.UpperDepths.OutsideMoraFight"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.OutsideMoraFight -> MoraFirstPhase"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.OutsideMoraFight -> UpperDepths.Teleporter"), lambda s: s.has_any(("Double Jump", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "UpperDepths.OutsideMoraFight", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.OutsideMoraFight -> UpperDepths.Teleporter"), lambda s: s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1))], [], "UpperDepths.OutsideMoraFight", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.OutsideMoraFight -> UpperDepths.MoraPath"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MoraFirstPhase -> F.MoraFirstPhase"), lambda s: True, "or")
    add_rule(w.get_entrance("MoraFirstPhase -> MoraEscape"), lambda s: s.has("SkipMora1", p), "or")
    add_rule(w.get_entrance("MoraFirstPhase -> MoraEscape"), lambda s: s.has_all(("Regenerate", "Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Launch"), p) and has_enough_resources([('wall', ('Boss', 165)), ('db', 50)], [], "MoraFirstPhase", s, p, o, True), "or")
    add_rule(w.get_entrance("MoraEscape -> C.MoraEscape"), lambda s: True, "or")
    add_rule(w.get_entrance("MoraEscape -> MoraSecondPhase"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("MoraSecondPhase -> C.MoraSecondPhase"), lambda s: True, "or")
    add_rule(w.get_entrance("MoraSecondPhase -> E.MoraSecondPhase"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("MoraSecondPhase -> UpperDepths.ForestsEyes"), lambda s: s.has("SkipMora2", p), "or")
    add_rule(w.get_entrance("MoraSecondPhase -> UpperDepths.ForestsEyes"), lambda s: s.has_all(("Regenerate", "Bash", "Flash"), p) and s.has_any(("Double Jump", "Dash", "Launch"), p) and has_enough_resources([('wall', ('Boss', 165)), ('db', 60)], [], "MoraSecondPhase", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> C.UpperDepths.LowerConnection"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.CentralKeystoneDoor"), lambda s: can_open_door("UpperDepths.CentralKeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.BelowDoorOre"), lambda s: s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Glide", p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Glide", p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Launch", p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Launch", p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has("Launch", p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has("Launch", p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.Central"), lambda s: s.has("UpperDepths.CentralKeystoneDoor", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has("Dash", p) and s.has_any(("Double Jump", "Glide"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Dash"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has_all(("DepthsLight", "Glide"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has("Launch", p) and s.has("DepthsLight", p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has("Launch", p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("Double Jump", "Dash", "Bash"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Glide"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Dash"), p) and s.has_any(("Bash", "Glide"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Bash", "Glide"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.LowerConnection", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("LowerDepths.West -> C.LowerDepths.West"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.HandToHandSilk"), lambda s: s.has("GladesTown.HandToHandLantern", p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.SwimEC"), lambda s: s.has_all(("Clean Water", "Bash"), p) and s.has_any(("UpperDepths.ForestsEyes", "Flash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.LeftEX"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.LeftEX"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.West", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has_all(("Clean Water", "Double Jump", "Bash"), p) and s.has_any(("UpperDepths.ForestsEyes", "Flash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has_all(("Clean Water", "Bash", "Dash"), p) and s.has_any(("UpperDepths.ForestsEyes", "Flash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerDepths.West", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has_all(("Clean Water", "Bash", "Glide"), p) and s.has_any(("UpperDepths.ForestsEyes", "Flash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerDepths.West", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has_all(("Clean Water", "Launch"), p) and s.has_any(("UpperDepths.ForestsEyes", "Flash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> UpperDepths.LowerConnection"), lambda s: s.has_all(("DepthsLight", "Launch"), p) and can_enter_area("UpperDepths", s, p, o), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("Double Jump", "Bash", "Dash"), p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("Double Jump", "Bash", "Dash"), p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "LowerDepths.West", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("Launch", "DepthsLight"), p) and s.has_any(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.West", s, p, o, True), "or")
    add_rule(w.get_entrance("DepthsShrine -> F.DepthsShrine"), lambda s: True, "or")
    add_rule(w.get_entrance("DepthsShrine -> LowerDepths.CombatShrineCompleted"), lambda s: s.has("Regenerate", p) and has_enough_resources([('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'SneezeSlug'), ('combat', 'SneezeSlug'), ('combat', 'Tentacle'), ('combat', 'Tentacle'), ('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'Tentacle'), ('combat', 'Tentacle'), ('combat', 'Bat'), ('combat', 'SneezeSlug'), ('db', 65)], [], "DepthsShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("DepthsShrine -> LowerDepths.CombatShrineCompleted"), lambda s: s.has("Regenerate", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'SneezeSlug'), ('combat', 'SneezeSlug'), ('combat', 'Tentacle'), ('combat', 'Tentacle'), ('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'Tentacle'), ('combat', 'Tentacle'), ('combat', 'Bat'), ('combat', 'SneezeSlug'), ('db', 60)], [], "DepthsShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("DepthsShrine -> LowerDepths.CombatShrineCompleted"), lambda s: s.has_all(("Regenerate", "Launch"), p) and has_enough_resources([('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'SneezeSlug'), ('combat', 'SneezeSlug'), ('combat', 'Tentacle'), ('combat', 'Tentacle'), ('combat', 'Bat'), ('combat', 'Bat'), ('combat', 'Tentacle'), ('combat', 'Tentacle'), ('combat', 'Bat'), ('combat', 'SneezeSlug'), ('db', 50)], [], "DepthsShrine", s, p, o, True), "or")
    add_rule(w.get_entrance("DepthsShrine -> LowerDepths.CombatShrine"), lambda s: s.has("LowerDepths.CombatShrineCompleted", p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> C.LowerDepths.Central"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.RaceStartHC"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and s.has_any(("Dash", "DepthsLight"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.RaceStartHC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.SpiritTrial"), lambda s: s.has_all(("LowerDepths.TrialActivation", "Double Jump", "Dash", "Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.East"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.East"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> UpperDepths.LowerConnection"), lambda s: s.has_all(("DepthsLight", "Launch", "Bash"), p) and can_enter_area("UpperDepths", s, p, o), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> UpperDepths.LowerConnection"), lambda s: s.has_all(("DepthsLight", "Bash", "Double Jump"), p) and can_enter_area("UpperDepths", s, p, o), "or")
    add_rule(w.get_entrance("LowerDepths.East -> C.LowerDepths.East"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerDepths.East -> E.LowerDepths.East"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> E.LowerDepths.East"), lambda s: s.has_all(("BreakCrystal", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> E.LowerDepths.East"), lambda s: s.has_all(("BreakCrystal", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has("Grapple", p) and can_buy_map(s, p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has_all(("Launch", "Double Jump", "Dash"), p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has_all(("Launch", "Glide"), p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has_all(("DepthsLight", "Glide"), p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has_all(("DepthsLight", "Launch"), p) and can_buy_map(s, p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Bash", "Grapple"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerDepths.East", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Launch"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerDepths.East", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has("Launch", p) and s.has_any(("Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.Central"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Launch", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> C.LowerDepths.BeforeTree"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TrialActivation"), lambda s: s.has_all(("Double Jump", "Bash", "Grapple"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("Double Jump", p) and s.has_any(("Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("Dash", p) and s.has_any(("Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TreeArea"), lambda s: s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TreeArea"), lambda s: s.has_all(("Double Jump", "Bash", "Grapple"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.BeforeTree", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Bash", "Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.BeforeTree", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Bash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.BeforeTree", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.BeforeTree", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerDepths.TreeArea -> C.LowerDepths.TreeArea"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerDepths.TreeArea -> E.LowerDepths.TreeArea"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("LowerDepths.TreeArea -> LowerDepths.FlashTree"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerDepths.TreeArea -> LowerDepths.RightEX"), lambda s: s.has_any(("DepthsLight", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerDepths.TreeArea -> LowerDepths.BeforeTree"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> C.PoolsApproach.MillPathCheckpoint"), lambda s: True, "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Grapple", "Bash", "Dash", "Glide"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "PoolsApproach.MillPathCheckpoint", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Grapple", "Glide"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> PoolsApproach.MillPath"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 20), ('combat', 'Crab'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto')], [], "PoolsApproach.MillPathCheckpoint", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> PoolsApproach.MillPath"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MillPathCheckpoint", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> PoolsApproach.MillPath"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Grapple", "Bash"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MillPathCheckpoint", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> C.PoolsApproach.MillPath"), lambda s: True, "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.UnderwaterWallBroken"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathECWall"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathEX"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'SpinCrab'), ('combat', 'CorruptSlug')], [], "PoolsApproach.MillPath", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathEX"), lambda s: s.has_all(("Double Jump", "Grapple", "Glide"), p) and has_enough_resources([('combat', 'SpinCrab'), ('combat', 'CorruptSlug')], [], "PoolsApproach.MillPath", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathEC"), lambda s: s.has_all(("PoolsApproach.MillPathECWall", "Clean Water"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MillPath", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 20), ('combat', 'Crab'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('energy', ('Grenade', 3))], [], "PoolsApproach.MillPath", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 20), ('combat', 'Crab'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('energy', ('Grenade', 2))], [], "PoolsApproach.MillPath", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('db', 20), ('combat', 'Crab'), ('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto')], [], "PoolsApproach.MillPath", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MillPath", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Launch"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Grapple"), p) and s.has_any(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Grapple"), p) and has_enough_resources([], [('combat', 'SpinCrab')], "PoolsApproach.MillPath", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "PoolsApproach.WheelFreed"), p) and s.has_any(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "PoolsApproach.WheelFreed"), p) and has_enough_resources([], [('combat', 'SpinCrab')], "PoolsApproach.MillPath", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Double Jump", "Dash", "Water Dash"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MarshBreakableWall", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> MarshPastOpher.PoolsPathWest"), lambda s: can_enter_area("MarshPastOpher", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20))], [], "PoolsApproach.MarshBreakableWall", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Launch", "Glide"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> C.PoolsApproach.OnTopOfWheel"), lambda s: s.has("Clean Water", p) and s.has_any(("Launch", "Grapple", "PoolsApproach.WheelFreed"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> C.PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.WheelWall"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.WheelFreed"), lambda s: s.has_all(("PoolsApproach.WheelWall", "Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.UnderwaterWallBroken"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathECWall"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Bash"), p) and has_enough_resources([('db', 10)], [], "PoolsApproach.OnTopOfWheel", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.AboveWheelEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.AboveWheelEX"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "PoolsApproach.OnTopOfWheel", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.AboveWheelEX"), lambda s: s.has_all(("PoolsApproach.WheelFreed", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshPathCurrentEX"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathEC"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "PoolsApproach.MillPathECWall", "Clean Water", "Bash"), p) and has_enough_resources([('db', 10)], [], "PoolsApproach.OnTopOfWheel", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Double Jump", "Dash", "Water Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Double Jump", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has("Launch", p) and s.has_any(("Glide", "Clean Water"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Bash", "Launch"), p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "PoolsApproach.OnTopOfWheel", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Double Jump", "Dash", "Launch"), p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("PoolsApproach.WheelFreed", "Double Jump", "Glide"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPath"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Bash", "Grapple", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('db', 10)], [], "PoolsApproach.OnTopOfWheel", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPath"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Bash", "Water Dash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPath"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Bash", "Launch"), p) and has_enough_resources([('db', 10)], [], "PoolsApproach.OnTopOfWheel", s, p, o, True), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> MarshSpawn.PoolsPath"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> C.EastPools.LeverRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> H.EastPools.LeverRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has_all(("Bash", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.BelowEntryLeverBubble"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.BelowEntryLeverBubble"), lambda s: has_enough_resources([], [('energy', ('Spear', 1))], "EastPools.LeverRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.WheelWall"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.WheelFreed"), lambda s: s.has_all(("PoolsApproach.WheelWall", "Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.KwolokAmuletQI"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.TwoCrushersEX"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.RightOre"), lambda s: s.has_all(("Double Jump", "Grapple", "Flap"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('combat', 'CorruptSlug')], [], "EastPools.LeverRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.RightOre"), lambda s: s.has_all(("Launch", "Grapple"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.BubbleCurrentEX"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.BelowLeverEX"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.LeverRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.BelowLeverEX"), lambda s: s.has("EastPools.BelowEntryLeverBubble", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.BelowLeverEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.MarshPathCurrentEX"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.BehindEntryDoor"), lambda s: s.has("EastPools.EntryLever", p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has("Clean Water", p) and s.has_any(("PoolsApproach.WheelFreed", "Double Jump", "Launch"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Bash"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.LeverRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Bash", "Glide"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('Grenade', 2))], [], "EastPools.LeverRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Bash", "Glide", "Double Jump"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.LeverRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Glide", "Launch"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Double Jump", "Dash", "Launch"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Bash", "Launch"), p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.LeverRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> MarshSpawn.PoolsPath"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> C.EastPools.BehindEntryDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.BelowEntryLeverBubble"), lambda s: s.has("EastPools.EntryLever", p) and s.has("Hammer", p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.BelowEntryLeverBubble"), lambda s: s.has("EastPools.EntryLever", p) and has_enough_resources([], [('energy', ('Spear', 1))], "EastPools.BehindEntryDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.AboveDoorOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.AboveDoorOre"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "EastPools.BehindEntryDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.AboveDoorOre"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.BehindEntryDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.AboveDoorOre"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Grapple", "Flap"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TokkBubble"), lambda s: s.has_any(("Launch", "Clean Water", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TokkBubble"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.BehindEntryDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TokkBubble"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TokkBubble"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall"), p) and has_enough_resources([], [('combat', 'Crab')], "EastPools.BehindEntryDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.BehindEntryDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.BehindEntryDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "EastPools.BehindEntryDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.LeverRoom"), lambda s: s.has("EastPools.EntryLever", p) and s.has_any(("Bash", "Launch", "EastPools.BelowEntryLeverBubble"), p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.LeverRoom"), lambda s: s.has("EastPools.EntryLever", p) and has_enough_resources([], [('combat', 'Crab')], "EastPools.BehindEntryDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> C.EastPools.TokkBubble"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TokkBubbleFree"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TokkBubbleFree"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and s.has("EastPools.TokkBubblePurpleWall", p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TokkBubbleFree"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and has_enough_resources([], [('combat', 'Crab')], "EastPools.TokkBubble", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TokkBubblePurpleWall"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.AboveDoorOre"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Grapple", "Flap"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TPArea"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Flap", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'Crab')], [], "EastPools.TokkBubble", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TPArea"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Flap", "Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.BehindEntryDoor"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.BehindEntryDoor"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.BehindEntryDoor"), lambda s: s.has("Grapple", p) and has_enough_resources([], [('combat', 'CorruptSlug'), ('combat', 'Crab')], "EastPools.TokkBubble", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.BehindEntryDoor"), lambda s: s.has("Bash", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.BehindEntryDoor"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "EastPools.TokkBubble", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> C.EastPools.TPArea"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.TPArea -> F.EastPools.TPArea"), lambda s: s.has("EastPools.LowerWaterDrained", p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.LowerWaterDrained"), lambda s: s.has_all(("Clean Water", "Water Breath"), p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.AboveDoorOre"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.TPArea", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.Teleporter"), lambda s: s.has("EastPools.LowerWaterDrained", p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.FishingPool"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.FishingPool"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.TPArea", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.FishingPool"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.WaterdashArena"), lambda s: s.has_all(("EastPools.ArenaWall", "Clean Water"), p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.NextToLupoOre"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.BehindEntryDoor"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.BehindEntryDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.TPArea", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.TokkBubble"), lambda s: s.has_any(("Launch", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> F.EastPools.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> EastPools.LowerWaterDrained"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> EastPools.ArenaWall"), lambda s: s.has_all(("EastPools.LowerWaterDrained", "Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> EastPools.UltraBashWall"), lambda s: s.has_all(("EastPools.LowerWaterDrained", "Clean Water", "Water Breath", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> EastPools.UltraBashShard"), lambda s: s.has_all(("EastPools.LowerWaterDrained", "EastPools.UltraBashWall", "Clean Water"), p), "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> Teleporters"), lambda s: s.has("EastPools.LowerWaterDrained", p), "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> EastPools.TPArea"), lambda s: s.has_any(("EastPools.LowerWaterDrained", "Clean Water"), p), "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> EastPools.WaterdashArena"), lambda s: s.has_all(("EastPools.ArenaWall", "EastPools.LowerWaterDrained"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.HandToHandSpyglass"), lambda s: s.has("LowerDepths.HandToHandSilk", p), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump", "Dash"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump", "Dash"), p) and has_enough_resources([], [('combat', 'CorruptSlug')], "EastPools.FishingPool", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump", "Glide"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump", "Glide"), p) and has_enough_resources([], [('combat', 'CorruptSlug')], "EastPools.FishingPool", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.FishingPool", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.TPArea"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.AboveFishingPool -> EastPools.AboveTpEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastPools.AboveFishingPool -> EastPools.FishingPool"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.AboveFishingPool -> UpperPools.DrainPuzzleExit"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Launch"), p) and can_enter_area("UpperPools", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.AboveFishingPool -> UpperPools.DrainPuzzleExit"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Bash", "Double Jump"), p) and can_enter_area("UpperPools", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.AboveFishingPool", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.NextToLupoOre -> C.EastPools.NextToLupoOre"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.NextToLupoOre -> EastPools.LupoOre"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.NextToLupoOre -> EastPools.Teleporter"), lambda s: s.has_all(("EastPools.LowerWaterDrained", "Clean Water"), p), "or")
    add_rule(w.get_entrance("EastPools.NextToLupoOre -> EastPools.TPArea"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastPools.LupoArea -> C.EastPools.LupoArea"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.LupoArea -> EastPools.LupoEX"), lambda s: s.has_any(("Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("EastPools.LupoArea -> EastPools.LupoEX"), lambda s: s.has_all(("EastPools.LupoPurpleFloor", "Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.LupoArea -> EastPools.LupoMap"), lambda s: can_buy_map(s, p), "or")
    add_rule(w.get_entrance("EastPools.LupoArea -> EastPools.NextToLupoOre"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "EastPools.LupoArea", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.LupoArea -> EastPools.MissilePuzzle"), lambda s: s.has_all(("EastPools.LupoPurpleFloor", "Clean Water"), p), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> C.EastPools.WaterdashArena"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.FightArenas"), lambda s: s.has_all(("Regenerate", "Clean Water", "Water Breath", "Bash"), p) and has_enough_resources([('db', 20), ('combat', 'Crab'), ('combat', 'Crab'), ('combat', 'Crab'), ('combat', 'Crab'), ('combat', 'Tentacle'), ('combat', 'Skeeto'), ('combat', 'Skeeto')], [], "EastPools.WaterdashArena", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.FightRoomHC"), lambda s: s.has_all(("EastPools.FightArenas", "Water Dash", "Double Jump"), p) and s.has_any(("Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.FightRoomHC"), lambda s: s.has_all(("EastPools.FightArenas", "Water Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.WaterdashArena", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.FightRoomHC"), lambda s: s.has_all(("EastPools.FightArenas", "Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.TPArea"), lambda s: s.has_all(("EastPools.ArenaWall", "Clean Water"), p), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.Teleporter"), lambda s: s.has_all(("EastPools.ArenaWall", "EastPools.LowerWaterDrained"), p) and s.has_any(("Double Jump", "Dash", "Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.MissilePuzzle"), lambda s: s.has("EastPools.FightArenas", p) and s.has_any(("Clean Water", "Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> C.EastPools.MissilePuzzle"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.CentralRoomPurpleWall"), lambda s: s.has_all(("Clean Water", "Water Breath", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.LupoPurpleFloor"), lambda s: s.has_all(("Clean Water", "Water Breath", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.EnergyHarvestShard"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.EnergyHarvestShard"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.MissilePuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.EnergyHarvestShard"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.BehindCrusherEX"), lambda s: s.has_all(("Clean Water", "Water Breath"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.SpiritTrial"), lambda s: s.has_all(("UpperPools.TrialActivation", "EastPools.CentralRoomPurpleWall", "Clean Water", "Double Jump", "Dash", "Glide", "Grapple", "Water Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.CentralRoom"), lambda s: s.has_all(("EastPools.CentralRoomPurpleWall", "Clean Water"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.WaterdashArena"), lambda s: s.has("EastPools.FightArenas", p) and s.has_any(("Clean Water", "Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.LupoArea"), lambda s: s.has_all(("EastPools.LupoPurpleFloor", "Clean Water"), p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> C.EastPools.CentralRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.CentralRoomBubbleFree"), lambda s: s.has("Clean Water", p) and s.has_any(("Bash", "Water Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has("EastPools.CentralRoomBubbleFree", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.CentralRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_all(("EastPools.CentralRoomBubbleFree", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and can_enter_area("UpperPools", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_all(("EastPools.CentralRoomBubbleFree", "Bash", "Launch"), p) and can_enter_area("UpperPools", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> WestPools.Teleporter"), lambda s: s.has_all(("Clean Water", "Water Breath", "Water Dash"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and can_enter_area("WestPools", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.MissilePuzzle"), lambda s: s.has_all(("EastPools.CentralRoomPurpleWall", "Clean Water"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> C.UpperPools.KeystoneRoomEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.GrassSeed"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.GrassSeed"), lambda s: has_enough_resources([], [('combat', 'SpinCrab')], "UpperPools.KeystoneRoomEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.GrassSeed"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> UpperPools.LowerKS"), lambda s: s.has_all(("Clean Water", "Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> UpperPools.LowerKS"), lambda s: s.has("Clean Water", p) and s.has_any(("Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.CentralRoom"), lambda s: s.has_any(("Bash", "Launch"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.CentralRoom"), lambda s: can_enter_area("EastPools", s, p, o) and has_enough_resources([], [('combat', 'SpinCrab')], "UpperPools.KeystoneRoomEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.CentralRoom"), lambda s: s.has_all(("Double Jump", "Dash"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> UpperPools.KeystoneRoomBubbleSpawner"), lambda s: s.has_any(("Clean Water", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> UpperPools.KeystoneRoomBubbleSpawner"), lambda s: s.has_all(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> C.UpperPools.KeystoneRoomBubbleSpawner"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.KeystoneRoomBubbleFree"), lambda s: s.has("Clean Water", p) and s.has_any(("Water Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.UpperLeftKS"), lambda s: s.has_all(("UpperPools.KeystoneRoomBubbleFree", "Flap", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.KeystoneRoom"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.KeystoneRoom"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.KeystoneRoomBubbleSpawner", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("UpperPools.KeystoneRoomBubbleFree", "Flap", "Double Jump", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_all(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> C.UpperPools.KeystoneRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> E.UpperPools.KeystoneRoom"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperLeftKS"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperLeftKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has("Bash", p) and s.has_any(("Clean Water", "Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.KeystoneRoomEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.KeystoneRoomBubbleSpawner"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has_all(("Clean Water", "Grapple", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has_all(("Bash", "Clean Water", "Water Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Bash", p) and s.has_any(("Clean Water", "Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "UpperPools.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 3))], [], "UpperPools.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> C.UpperPools.BeforeKeystoneDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> H.UpperPools.BeforeKeystoneDoor"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.KeystoneDoor"), lambda s: can_open_door("UpperPools.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.TrialActivation"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.UpperMidKS"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.TreeRoomEntrance"), lambda s: s.has("UpperPools.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.KeystoneRoom"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.BeforeKeystoneDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> C.UpperPools.TreeRoomEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> UpperPools.KeystoneDoor"), lambda s: can_open_door("UpperPools.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("UpperPools.KeystoneDoor", p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> UpperPools.TreeRoom"), lambda s: s.has_any(("Clean Water", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> UpperPools.AboveTree"), lambda s: s.has_all(("UpperPools.TreeRoomLeftBubbleFree", "Flap", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> UpperPools.AboveTree"), lambda s: s.has_all(("UpperPools.TreeRoomLeftBubbleFree", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.TreeRoomLeftBubbleFree"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.TreeRoomRightBubbleFree"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.ButtonDoorAboveTree"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.SwimDashTree"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.SwimDashCurrentEX"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.TreeRoomEntrance"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.TreeRoomEntrance"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.TreeRoomEntrance"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.TreeRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.ButtonDoorAboveTree", "UpperPools.TreeRoomRightBubbleFree", "Clean Water", "Water Dash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.ButtonDoorAboveTree", "UpperPools.TreeRoomRightBubbleFree", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.AboveTree -> UpperPools.RoofEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.AboveTree -> UpperPools.RoofEX"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.AboveTree -> UpperPools.RoofEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.AboveTree", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.AboveTree -> UpperPools.TreeRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.AboveTree -> UpperPools.TreeRoomEntrance"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> C.UpperPools.DrainPuzzleEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.UpperWaterDrained"), lambda s: s.has_all(("Clean Water", "Water Dash", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.UpperWaterDrained"), lambda s: s.has_all(("Clean Water", "Water Dash", "Launch", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.UpperWaterDrained"), lambda s: s.has_all(("Clean Water", "Launch", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.WaterfallEC"), lambda s: s.has_all(("Double Jump", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.WaterfallEC"), lambda s: s.has_all(("Bash", "Grapple", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.WaterfallEC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.TreeRoom"), lambda s: s.has("UpperPools.ButtonDoorAboveTree", p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Double Jump", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide", "Grapple", "UpperPools.DrainRoomPurpleWall"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleExit"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "UpperPools.DrainRoomPurpleWall", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleExit"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "UpperPools.DrainRoomPurpleWall", "Clean Water", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> E.UpperPools.DrainPuzzleRight"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> H.UpperPools.DrainPuzzleRight"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainRoomPurpleWall"), lambda s: s.has_all(("Bash", "Clean Water"), p) and s.has_any(("Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleExit"), lambda s: s.has("UpperPools.UpperWaterDrained", p) and s.has_any(("Clean Water", "Glide", "Double Jump", "Launch", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has("Launch", p) and s.has_any(("Grapple", "UpperPools.DrainRoomPurpleWall"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Launch", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Launch", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleRight", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Dash", "Glide", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleRight", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Bash", "Double Jump", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleRight", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> C.UpperPools.DrainPuzzleExit"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> UpperPools.DrainRoomPurpleWall"), lambda s: s.has_all(("Bash", "Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> EastPools.PurpleWallHC"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Clean Water", "Bash"), p) and s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> EastPools.PurpleWallHC"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Clean Water", "Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> EastPools.AboveFishingPool"), lambda s: can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Clean Water", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> C.UpperPools.RightBubbleSpamRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BubbleSpamLever"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('combat', 'Bee'), ('combat', 'Skeeto')], [], "UpperPools.RightBubbleSpamRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BubbleSpamLever"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BubbleSpamLever"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BubbleSpamWall"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.FishPoolEX"), lambda s: s.has("Clean Water", p) and s.has_any(("Bash", "Water Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.FishPoolEX"), lambda s: s.has("Clean Water", p) and has_enough_resources([], [('db', 10)], "UpperPools.RightBubbleSpamRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.FishPoolOre"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.FishPoolOre"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.RightBubbleSpamRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.FishPoolOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.RightBubblesEX"), lambda s: s.has_all(("UpperPools.BubbleSpamWall", "Clean Water"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BubblesEC"), lambda s: s.has("UpperPools.BubbleSpamLever", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.LeftBubbleSpamRoom"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> C.UpperPools.LeftBubbleSpamRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.BubbleSpamWall"), lambda s: s.has_all(("Clean Water", "Bash", "Water Breath"), p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.LeftBubblesEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("Clean Water", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("Clean Water", "Bash", "Water Breath", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("Clean Water", "Bash", "Water Dash"), p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> F.WestPools.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.TpEX"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.TpEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.BurrowEX"), lambda s: s.has_all(("Clean Water", "Burrow"), p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.LeftKwolokPlatform"), lambda s: s.has_all(("Clean Water", "Water Breath", "Water Dash"), p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.LeftKwolokPlatform"), lambda s: s.has_all(("Clean Water", "Water Breath", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> EastPools.CentralRoom"), lambda s: s.has_all(("Clean Water", "Water Breath", "Water Dash"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("WestPools.LeftKwolokPlatform -> C.WestPools.LeftKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p), "or")
    add_rule(w.get_entrance("WestPools.LeftKwolokPlatform -> KwolokEscape"), lambda s: True, "or")
    add_rule(w.get_entrance("WestPools.LeftKwolokPlatform -> WestPools.Teleporter"), lambda s: s.has_all(("Clean Water", "Water Breath"), p) and s.has_any(("Bash", "Water Dash"), p), "or")
    add_rule(w.get_entrance("WestPools.LeftKwolokPlatform -> WestPools.RightKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p) and s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestPools.LeftKwolokPlatform -> WestPools.RightKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p) and has_enough_resources([], [('combat', 'Crab'), ('combat', 'SpinCrab')], "WestPools.LeftKwolokPlatform", s, p, o, True), "or")
    add_rule(w.get_entrance("WestPools.RightKwolokPlatform -> C.WestPools.RightKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p), "or")
    add_rule(w.get_entrance("WestPools.RightKwolokPlatform -> WestPools.EscapeRevisitEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("WestPools.RightKwolokPlatform -> KwolokEscape"), lambda s: True, "or")
    add_rule(w.get_entrance("WestPools.RightKwolokPlatform -> WestPools.LeftKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p) and s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestPools.RightKwolokPlatform -> WestPools.LeftKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p) and has_enough_resources([], [('combat', 'Crab'), ('combat', 'SpinCrab')], "WestPools.RightKwolokPlatform", s, p, o, True), "or")
    add_rule(w.get_entrance("WestPools.RightKwolokPlatform -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_all(("Clean Water", "Water Breath", "Water Dash"), p) and can_enter_area("UpperPools", s, p, o), "or")
    add_rule(w.get_entrance("KwolokEscape -> F.KwolokEscape"), lambda s: True, "or")
    add_rule(w.get_entrance("KwolokEscape -> KwolokFight"), lambda s: s.has_all(("Clean Water", "Water Dash", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("KwolokEscape -> KwolokFight"), lambda s: s.has_all(("Clean Water", "Water Dash", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("KwolokFight -> C.KwolokFight"), lambda s: True, "or")
    add_rule(w.get_entrance("KwolokFight -> E.KwolokFight"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("KwolokFight -> WestPools.ForestsStrength"), lambda s: s.has("SkipKwolok", p), "or")
    add_rule(w.get_entrance("KwolokFight -> WestPools.ForestsStrength"), lambda s: s.has_all(("Regenerate", "Clean Water", "Water Dash", "Bash", "Double Jump"), p) and s.has_any(("Launch", "Dash"), p) and has_enough_resources([('wall', ('Boss', 250)), ('db', 85)], [], "KwolokFight", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> F.LowerWastes.WestTP"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> LowerWastes.WestTPOre"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WoodsMain.FeedingGroundsEX"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> LowerWastes.SunsetView"), lambda s: s.has_all(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> LowerWastes.SunsetView"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WestTP", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> LowerWastes.SunsetView"), lambda s: s.has_all(("Double Jump", "Burrow"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> LowerWastes.SunsetView"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WoodsMain.FeedingGrounds"), lambda s: s.has_all(("WindtornRuins.Seir", "Burrow"), p) and can_enter_area("WoodsMain", s, p, o), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "WindtornRuins.Seir", "Double Jump", "Glide", "Grapple"), p) and can_enter_area("WeepingRidge", s, p, o), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "WindtornRuins.Seir", "Double Jump", "Bash", "Grapple"), p) and can_enter_area("WeepingRidge", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WestTP", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "WindtornRuins.Seir", "Launch"), p) and can_enter_area("WeepingRidge", s, p, o), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> C.LowerWastes.SunsetView"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.SunsetViewEX"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.PurpleWallEX"), lambda s: s.has_all(("Burrow", "Bash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.SpiritTrial"), lambda s: s.has_all(("LowerWastes.TrialActivation", "Burrow", "Double Jump", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.WestTP"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.Shovel"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.Shovel"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.SunsetView", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.Shovel"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.Shovel -> E.LowerWastes.Shovel"), lambda s: s.has("BreakCrystal", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.Shovel -> E.LowerWastes.Shovel"), lambda s: s.has_all(("BreakCrystal", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.Shovel", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.Shovel -> LowerWastes.EerieGemQI"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.Shovel -> LowerWastes.SandBridgeOre"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.Shovel -> LowerWastes.SunsetView"), lambda s: s.has_any(("Bash", "Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.Shovel -> LowerWastes.SunsetView"), lambda s: has_enough_resources([], [('combat', 'MaceMiner')], "LowerWastes.Shovel", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.Shovel -> LowerWastes.SkeetoHive"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.Shovel -> LowerWastes.MuncherTunnel"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> C.LowerWastes.MuncherTunnel"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> E.LowerWastes.MuncherTunnel"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.MuncherTunnelEC"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.Shovel"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.Shovel"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.MuncherTunnel", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.SandPot"), lambda s: has_enough_resources([('combat', 'Mantis'), ('combat', 'ShieldSlug')], [], "LowerWastes.MuncherTunnel", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.SandPot"), lambda s: s.has_any(("Double Jump", "Burrow", "Hammer"), p) and has_enough_resources([('combat', 'Mantis')], [], "LowerWastes.MuncherTunnel", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.SandPot"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Burrow"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.SandPot"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerWastes.MuncherTunnel", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.SandPot"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> C.LowerWastes.SandPot"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotHC"), lambda s: s.has_all(("Burrow", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotHC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Dash", "Grapple"), p) and s.has_any(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.SandPot", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.MuncherTunnel"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.MuncherTunnel"), lambda s: has_enough_resources([], [('combat', 'Mantis')], "LowerWastes.SandPot", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has("Dash", p) and s.has_any(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has_all(("Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.SandPot", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerWastes.SandPot", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Double Jump", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.SandPot", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has_all(("Bash", "Double Jump", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.SandPot", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> C.LowerWastes.WoodenBridge"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Grapple"), p) and s.has_any(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Grapple", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WoodenBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WoodenBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.MuncherPitEX"), lambda s: s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.MuncherPitEX"), lambda s: s.has_all(("Burrow", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPot"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Glide", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPot"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPot"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WoodenBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPot"), lambda s: s.has_all(("Bash", "Double Jump", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WoodenBridge", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPot"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.LeverArea"), lambda s: s.has_any(("Double Jump", "Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.BottomRightHC"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.MinesEntranceEnemyPaths"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Grapple"), p) and has_enough_resources([('combat', 'MaceMiner'), ('combat', 'Mantis')], [], "LowerWastes.BeforeMinesEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.MinesEntranceEnemyPaths"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.MinesEntranceEnemyPaths"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.WoodenBridge"), lambda s: s.has_any(("Bash", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerWastes.BeforeMinesEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.WoodenBridge"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [('combat', 'MaceMiner')], "LowerWastes.BeforeMinesEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntranceEnemyPaths -> LowerWastes.MinesEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightEX"), lambda s: s.has("Grapple", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightEX"), lambda s: s.has("Grapple", p) and has_enough_resources([], [('combat', 'MaceMiner'), ('combat', 'Mantis')], "LowerWastes.MinesEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.MinesEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightHC"), lambda s: s.has("Grapple", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightHC"), lambda s: s.has("Grapple", p) and has_enough_resources([], [('combat', 'MaceMiner'), ('combat', 'Mantis')], "LowerWastes.MinesEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightHC"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.MinesEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightHC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BeforeMinesEntrance"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and has_enough_resources([('combat', 'MaceMiner'), ('combat', 'Mantis')], [], "LowerWastes.MinesEntrance", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BeforeMinesEntrance"), lambda s: s.has_all(("Bash", "Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BeforeMinesEntrance"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> C.LowerWastes.LeverArea"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> E.LowerWastes.LeverArea"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.SandPlatformLever"), lambda s: s.has_any(("Double Jump", "Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.SandPlatformLever"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerWastes.LeverArea", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.SandPlatformLever"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.LeverArea", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.WoodenBridge"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.BeforeMinesEntrance"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.EastTP"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.MuncherClimb"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.LeverArea", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.MuncherClimb"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.MuncherClimb"), lambda s: s.has_all(("LowerWastes.SandPlatformLever", "Double Jump"), p) and s.has_any(("Dash", "Glide", "Burrow"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.MuncherClimb"), lambda s: s.has_all(("LowerWastes.SandPlatformLever", "Dash", "Burrow"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.LastStandArea"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.LeverArea", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> C.LowerWastes.MuncherClimb"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.MuncherClimbEX"), lambda s: s.has("Grapple", p) and s.has_any(("Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.LeverArea"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.LastStandArea"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.LastStandArea"), lambda s: s.has_all(("LowerWastes.SandPlatformLever", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.SkeetoHive"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.SkeetoHive"), lambda s: s.has_all(("Grapple", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LastStandArea -> LowerWastes.LastStandShard"), lambda s: s.has_any(("Double Jump", "Dash", "Burrow"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LastStandArea -> LowerWastes.LastStandEX"), lambda s: s.has("Burrow", p) and s.has_any(("Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LastStandArea -> LowerWastes.LeverArea"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.LastStandArea -> LowerWastes.MuncherClimb"), lambda s: s.has_any(("Glide", "Double Jump", "Dash", "LowerWastes.SandPlatformLever"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> C.LowerWastes.SkeetoHive"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.SkeetoHiveEX"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.ThirstyGorlek"), lambda s: s.has_any(("Double Jump", "Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.ThirstyGorlek"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerWastes.SkeetoHive", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.Shovel"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.UpperPath"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.UpperPath"), lambda s: s.has_all(("Burrow", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.SkeetoHive", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.MuncherClimb"), lambda s: s.has_all(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.MuncherClimb"), lambda s: s.has_all(("Grapple", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.ThirstyGorlek -> C.LowerWastes.ThirstyGorlek"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.ThirstyGorlek -> LowerWastes.TrialActivation"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.ThirstyGorlek -> LowerWastes.HandToHandMapstone"), lambda s: s.has("GladesTown.HandToHandCanteen", p), "or")
    add_rule(w.get_entrance("LowerWastes.ThirstyGorlek -> LowerWastes.BurrowTree"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.ThirstyGorlek -> LowerWastes.BurrowTreeEX"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.ThirstyGorlek -> LowerWastes.LupoMap"), lambda s: can_buy_map(s, p) and s.has_any(("Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.ThirstyGorlek -> LowerWastes.LupoMap"), lambda s: s.has("Bash", p) and can_buy_map(s, p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerWastes.ThirstyGorlek", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.ThirstyGorlek -> LowerWastes.SkeetoHive"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.UpperPath -> C.LowerWastes.UpperPath"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.UpperPath -> E.LowerWastes.UpperPath"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("LowerWastes.UpperPath -> LowerWastes.UpperPathEC"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.UpperPath -> LowerWastes.UpperPathEX"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.UpperPath -> LowerWastes.UpperPathHiddenEX"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.UpperPath -> LowerWastes.SkeetoHive"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.UpperPath -> LowerWastes.EastTP"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> F.LowerWastes.EastTP"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.EastTPOre"), lambda s: s.has_any(("Burrow", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerWastes.EastTP", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.EastTPOre"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1))], [], "LowerWastes.EastTP", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.EastTPOre"), lambda s: s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 3))], [], "LowerWastes.EastTP", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.UpperPathHC"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> Tokk"), lambda s: s.has_any(("Double Jump", "Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> Tokk"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.EastTP", s, p, o, True), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.LeverArea"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.UpperPath"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> UpperWastes.KeystoneRoom"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Launch"), p) and can_enter_area("UpperWastes", s, p, o), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> C.UpperWastes.KeystoneRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KeystoneDoor"), lambda s: s.has_all(("Burrow", "Bash"), p) and can_open_door("UpperWastes.KeystoneDoor", s, p, o.spawn.value) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KeystoneDoor"), lambda s: s.has("Burrow", p) and can_open_door("UpperWastes.KeystoneDoor", s, p, o.spawn.value) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'ShieldSlug')], [], "UpperWastes.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KeystoneDoor"), lambda s: s.has("Launch", p) and can_open_door("UpperWastes.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.LowerKS"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.LowerKS"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.UpperKS"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.TurmoilShard"), lambda s: s.has_all(("Burrow", "Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KSDoorEX"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KSDoorEX"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperWastes.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KSDoorEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> LowerWastes.EastTP"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.MissilePuzzleLeft"), lambda s: s.has_all(("UpperWastes.KeystoneDoor", "Burrow", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.MissilePuzzleLeft"), lambda s: s.has_all(("UpperWastes.KeystoneDoor", "Burrow"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'ShieldSlug')], [], "UpperWastes.KeystoneRoom", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.MissilePuzzleLeft"), lambda s: s.has_all(("UpperWastes.KeystoneDoor", "Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> C.UpperWastes.MissilePuzzleLeft"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> UpperWastes.KeystoneDoor"), lambda s: s.has("Burrow", p) and can_open_door("UpperWastes.KeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> UpperWastes.LedgeEC"), lambda s: s.has_all(("Burrow", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> UpperWastes.LedgeEC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> UpperWastes.MissileSpawnEX"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> UpperWastes.KSDoorEX"), lambda s: s.has_all(("UpperWastes.KeystoneDoor", "Burrow"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> UpperWastes.KeystoneRoom"), lambda s: s.has_all(("UpperWastes.KeystoneDoor", "Burrow"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> UpperWastes.MissilePuzzleMiddle"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleMiddle -> UpperWastes.LeverDoor"), lambda s: s.has_all(("Burrow", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleMiddle -> UpperWastes.PurpleWallEX"), lambda s: s.has_all(("Burrow", "Bash"), p) and has_enough_resources([('combat', 'MaceMiner')], [], "UpperWastes.MissilePuzzleMiddle", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleMiddle -> UpperWastes.MissilePuzzleRight"), lambda s: s.has_all(("UpperWastes.LeverDoor", "Burrow"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.PurpleWallHC"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.SpinLasers"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.SpinLasers"), lambda s: s.has_all(("Burrow", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.SpinLasers"), lambda s: s.has_all(("Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.MissilePuzzleMiddle"), lambda s: s.has_all(("UpperWastes.LeverDoor", "Burrow"), p), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> C.UpperWastes.SpinLasers"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.RoofEX"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperWastes.SpinLasers", s, p, o, True), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.RoofEX"), lambda s: s.has_all(("Double Jump", "Burrow"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.RoofEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.MissilePuzzleRight"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.RuinsApproach"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperWastes.RuinsApproach -> C.UpperWastes.RuinsApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperWastes.RuinsApproach -> UpperWastes.SpinLasersRightEX"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.RuinsApproach -> UpperWastes.SpinLasersMiddleEX"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.RuinsApproach -> UpperWastes.SpinLasersLowerEX"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.RuinsApproach -> UpperWastes.NorthTP"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.RuinsApproach -> UpperWastes.SpinLasers"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> F.UpperWastes.NorthTP"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Burrow", "Bash", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Burrow", "Launch"), p) and s.has_any(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.RuinsApproach"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins (Door) -> UpperWastes.OutsideRuins"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.OutsideRuins (Door)"), lambda s: s.has_all(("EastHollow.ForestsVoice", "LowerReach.ForestsMemory", "UpperDepths.ForestsEyes", "WestPools.ForestsStrength"), p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> C.UpperWastes.OutsideRuins"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.FlowersSeed"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has_all(("Burrow", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has_all(("Burrow", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Glide", "Burrow"), p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.NorthTP"), lambda s: s.has_any(("Burrow", "Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.UpperRuinsDoor (Door) -> WindtornRuins.UpperRuinsDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("WindtornRuins.UpperRuinsDoor -> WindtornRuins.UpperRuinsDoor (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("WindtornRuins.UpperRuinsDoor -> C.WindtornRuins.UpperRuinsDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("WindtornRuins.UpperRuinsDoor -> E.WindtornRuins.UpperRuinsDoor"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("WindtornRuins.UpperRuinsDoor -> WindtornRuins.RuinsLever"), lambda s: s.has("Burrow", p) and has_enough_resources([('wall', ('BreakWall', 6)), ('wall', ('BreakWall', 6))], [], "WindtornRuins.UpperRuinsDoor", s, p, o, True), "or")
    add_rule(w.get_entrance("WindtornRuins.UpperRuinsDoor -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("WindtornRuins.RuinsLever", "Burrow"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.BrokenMural -> C.WindtornRuins.BrokenMural"), lambda s: True, "or")
    add_rule(w.get_entrance("WindtornRuins.BrokenMural -> WindtornRuins.UpperRuinsDoor"), lambda s: s.has_all(("WindtornRuins.RuinsLever", "Burrow"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.BrokenMural -> WindtornRuins.FallenPillar"), lambda s: True, "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.HeartBarrier"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "WindtornRuins.FallenPillar", s, p, o, True), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.HeartBarrier"), lambda s: s.has_all(("Burrow", "Bash"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('energy', ('Grenade', 1))], [], "WindtornRuins.FallenPillar", s, p, o, True), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.RuinsTP"), lambda s: s.has_all(("Burrow", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.RuinsTP"), lambda s: s.has_all(("Burrow", "Bash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WindtornRuins.FallenPillar", s, p, o, True), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.RuinsTP"), lambda s: s.has("Launch", p) and s.has_any(("Burrow", "WindtornRuins.HeartBarrier"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.Escape"), lambda s: s.has("WindtornRuins.HeartBarrier", p), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.LowerRuins"), lambda s: s.has("WindtornRuins.Seir", p) and s.has_any(("Double Jump", "Dash", "Glide", "Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.LowerRuins"), lambda s: s.has_all(("WindtornRuins.Seir", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WindtornRuins.FallenPillar", s, p, o, True), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("Bash", "WindtornRuins.HeartBarrier"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WindtornRuins.FallenPillar", s, p, o, True), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("Bash", "Burrow"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WindtornRuins.FallenPillar", s, p, o, True), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("Glide", "WindtornRuins.HeartBarrier"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("Glide", "Burrow"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.BrokenMural"), lambda s: s.has("Launch", p) and s.has_any(("Burrow", "WindtornRuins.HeartBarrier"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> F.WindtornRuins.RuinsTP"), lambda s: True, "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> WindtornRuins.HeartBarrier"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "WindtornRuins.RuinsTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> WindtornRuins.FallenPillar"), lambda s: s.has_any(("WindtornRuins.HeartBarrier", "Burrow"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("Glide", "WindtornRuins.HeartBarrier"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("Glide", "Burrow"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.Escape -> F.WindtornRuins.Escape"), lambda s: True, "or")
    add_rule(w.get_entrance("WindtornRuins.Escape -> WindtornRuins.Seir"), lambda s: s.has_all(("WindtornRuins.HeartBarrier", "Burrow", "Dash", "Grapple"), p) and s.has_any(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.Escape -> WindtornRuins.Seir"), lambda s: s.has_all(("WindtornRuins.HeartBarrier", "Burrow", "Double Jump", "Glide", "Grapple"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.Escape -> WindtornRuins.Seir"), lambda s: s.has_all(("WindtornRuins.HeartBarrier", "Burrow", "Double Jump", "Launch"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.Escape -> WindtornRuins.Seir"), lambda s: s.has_all(("WindtornRuins.HeartBarrier", "Burrow", "Grapple", "Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.LowerRuins -> WindtornRuins.HandToHandComplete"), lambda s: s.has("LowerWastes.HandToHandMapstone", p), "or")
    add_rule(w.get_entrance("WindtornRuins.LowerRuins -> WindtornRuins.EscapeRevisitEC"), lambda s: s.has_all(("WindtornRuins.Seir", "Burrow"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.LowerRuins -> WindtornRuins.Escape"), lambda s: True, "or")
    add_rule(w.get_entrance("WindtornRuins.LowerRuins -> WindtornRuins.FallenPillar"), lambda s: s.has_all(("WindtornRuins.Seir", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.LowerRuins -> WindtornRuins.FallenPillar"), lambda s: s.has_all(("WindtornRuins.Seir", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WindtornRuins.LowerRuins", s, p, o, True), "or")
    add_rule(w.get_entrance("WindtornRuins.LowerRuins -> WindtornRuins.FallenPillar"), lambda s: s.has_all(("WindtornRuins.Seir", "Launch"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.LowerRuins -> LowerWastes.MinesEntranceEnemyPaths"), lambda s: s.has("Burrow", p) and can_enter_area("LowerWastes", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20))], [], "WindtornRuins.LowerRuins", s, p, o, True), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> C.WeepingRidge.Bottom"), lambda s: True, "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> H.WeepingRidge.Bottom"), lambda s: True, "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> E.WeepingRidge.Bottom"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> WeepingRidge.ElevatorFightCompleted"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('combat', 'CrystalMiner'), ('combat', 'CrystalMiner'), ('combat', 'ShieldCrystalMiner'), ('combat', 'ShieldCrystalMiner')], [], "WeepingRidge.Bottom", s, p, o, True), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> WeepingRidge.ElevatorFightCompleted"), lambda s: s.has("Bash", p) and has_enough_resources([('combat', 'CrystalMiner'), ('combat', 'CrystalMiner'), ('combat', 'ShieldCrystalMiner'), ('combat', 'ShieldCrystalMiner'), ('energy', ('Grenade', 1))], [], "WeepingRidge.Bottom", s, p, o, True), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> WeepingRidge.ElevatorFightCompleted"), lambda s: s.has("Launch", p) and has_enough_resources([('combat', 'CrystalMiner'), ('combat', 'CrystalMiner'), ('combat', 'ShieldCrystalMiner'), ('combat', 'ShieldCrystalMiner')], [], "WeepingRidge.Bottom", s, p, o, True), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> WeepingRidge.LaunchArea"), lambda s: s.has_all(("WeepingRidge.ElevatorFightCompleted", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> WeepingRidge.LaunchArea"), lambda s: s.has_all(("WeepingRidge.ElevatorFightCompleted", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WeepingRidge.Bottom", s, p, o, True), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> WeepingRidge.LaunchArea"), lambda s: s.has_all(("WeepingRidge.ElevatorFightCompleted", "Launch"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Burrow"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> C.WeepingRidge.LaunchArea"), lambda s: True, "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> H.WeepingRidge.LaunchArea"), lambda s: True, "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.Ore"), lambda s: s.has_all(("Launch", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.AboveTree"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.AboveTree"), lambda s: s.has("Launch", p) and s.has_any(("Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.WillowEntranceLedge"), lambda s: s.has_all(("WeepingRidge.ElevatorFightCompleted", "Launch", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.Bottom"), lambda s: s.has_all(("WeepingRidge.ElevatorFightCompleted", "Launch"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.Bottom"), lambda s: s.has_all(("WeepingRidge.ElevatorFightCompleted", "Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WeepingRidge.LaunchArea", s, p, o, True), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.Bottom"), lambda s: s.has_all(("WeepingRidge.ElevatorFightCompleted", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> C.WeepingRidge.AboveTree"), lambda s: True, "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.LaunchTree"), lambda s: True, "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.PortalEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.SpikeClimbEX"), lambda s: s.has_all(("Launch", "Double Jump"), p) and has_enough_resources([('energy', ('Bow', 2))], [], "WeepingRidge.AboveTree", s, p, o, True), "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.Ore"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.LaunchArea"), lambda s: s.has_all(("Launch", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.WillowEntranceLedge (Door) -> WeepingRidge.WillowEntranceLedge"), lambda s: True, "or")
    add_rule(w.get_entrance("WeepingRidge.WillowEntranceLedge -> WeepingRidge.WillowEntranceLedge (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("WeepingRidge.WillowEntranceLedge -> C.WeepingRidge.WillowEntranceLedge"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.Entry (Door) -> WillowsEnd.Entry"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.Entry (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> C.WillowsEnd.Entry"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> E.WillowsEnd.Entry"), lambda s: s.has_all(("BreakCrystal", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> E.WillowsEnd.Entry"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [], "WillowsEnd.Entry", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.EntryEX"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WillowsEnd.Entry", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.EntryEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.InnerTP"), lambda s: s.has_all(("Launch", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.InnerTP"), lambda s: s.has_all(("Launch", "WillowsEnd.PortalShortcut"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.BoulderHeartPath"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.BoulderHeartPath"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.Entry", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.GrappleHeartMidPoint"), lambda s: s.has_all(("Grapple", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Bash", "Double Jump", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WillowsEnd.Entry", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeartMidPoint -> C.WillowsEnd.GrappleHeartMidPoint"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeartMidPoint -> H.WillowsEnd.GrappleHeartMidPoint"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeartMidPoint -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("Grapple", "Launch", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeartMidPoint -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("Grapple", "Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> C.WillowsEnd.GrappleHeart"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> E.WillowsEnd.GrappleHeart"), lambda s: s.has_all(("BreakCrystal", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> E.WillowsEnd.GrappleHeart"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [], "WillowsEnd.GrappleHeart", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> H.WillowsEnd.GrappleHeart"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.GrappleWheelsHeart"), lambda s: has_enough_resources([('wall', ('BreakWall', 30))], [], "WillowsEnd.GrappleHeart", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.PoisonfallHC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.PoisonfallHC"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.Entry"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Glide"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.Entry"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> C.WillowsEnd.BoulderHeartPath"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> E.WillowsEnd.BoulderHeartPath"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.BoulderHeart"), lambda s: s.has_all(("Launch", "Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 30))], [], "WillowsEnd.BoulderHeartPath", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.SpikesOre"), lambda s: s.has("Launch", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.Entry"), lambda s: s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> F.WillowsEnd.InnerTP"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.PortalShortcut"), lambda s: s.has_any(("Double Jump", "Dash", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "WillowsEnd.InnerTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.PortalShortcut"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [('energy', ('Bow', 1))], "WillowsEnd.InnerTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.LupoMap"), lambda s: can_buy_map(s, p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.LupoMap"), lambda s: can_buy_map(s, p) and has_enough_resources([], [('energy', ('Bow', 1))], "WillowsEnd.InnerTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.Entry"), lambda s: s.has("WillowsEnd.PortalShortcut", p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.Entry"), lambda s: s.has("WillowsEnd.PortalShortcut", p) and has_enough_resources([], [('energy', ('Bow', 1))], "WillowsEnd.InnerTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.Entry"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.Entry"), lambda s: s.has_any(("Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.AboveInnerTP"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.InnerTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.AboveInnerTP"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> C.WillowsEnd.AboveInnerTP"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> E.WillowsEnd.AboveInnerTP"), lambda s: s.has_all(("BreakCrystal", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> E.WillowsEnd.AboveInnerTP"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Bow', 1))], [], "WillowsEnd.AboveInnerTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> E.WillowsEnd.AboveInnerTP"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [('combat', 'CrystalMiner')], "WillowsEnd.AboveInnerTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.InnerTP"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.InnerTP"), lambda s: has_enough_resources([], [('combat', 'CrystalMiner')], "WillowsEnd.AboveInnerTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.East"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.AboveInnerTP", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.East"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.AboveInnerTP"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.AboveInnerTP"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.AboveInnerTP"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.RedirectHeartPath"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.RedirectHeartPath"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.Upper"), lambda s: s.has_all(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPath -> H.WillowsEnd.RedirectHeartPath"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPath -> E.WillowsEnd.RedirectHeartPath"), lambda s: s.has("BreakCrystal", p) and s.has_any(("Launch", "Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPath -> E.WillowsEnd.RedirectHeartPath"), lambda s: s.has("Dash", p) and has_enough_resources([('energy', ('Bow', 1))], [], "WillowsEnd.RedirectHeartPath", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPath -> WillowsEnd.East"), lambda s: s.has_any(("Launch", "Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPath -> WillowsEnd.RedirectHeartPuzzle"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPuzzle -> C.WillowsEnd.RedirectHeartPuzzle"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPuzzle -> WillowsEnd.RedirectHeart"), lambda s: s.has_all(("Double Jump", "Bash", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 10)), ('wall', ('BreakWall', 30))], [], "WillowsEnd.RedirectHeartPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPuzzle -> WillowsEnd.RedirectEX"), lambda s: s.has_all(("Bash", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "WillowsEnd.RedirectHeartPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPuzzle -> WillowsEnd.RedirectEX"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.RedirectHeartPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPuzzle -> WillowsEnd.RedirectHeartPath"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.RedirectHeartPuzzle", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPuzzle -> WillowsEnd.RedirectHeartPath"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper (Door) -> WillowsEnd.Upper"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.Upper (Door)"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "WillowsEnd.BoulderHeart", "WillowsEnd.RedirectHeart", "WillowsEnd.BurrowHeart", "WillowsEnd.MinibossHeart", "WillowsEnd.SpinLasersHeart", "WillowsEnd.GlideHeart", "WillowsEnd.SpinPortalsHeart"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> C.WillowsEnd.Upper"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.BurrowHeart"), lambda s: s.has_all(("Burrow", "Launch", "Double Jump", "Dash", "Bash", "Grapple", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 30))], [], "WillowsEnd.Upper", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.MiniBossFight"), lambda s: s.has_all(("Launch", "Dash", "Glide", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.East"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'CrystalMiner')], [], "WillowsEnd.Upper", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.East"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.West"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.UpperHeartPath"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('energy', ('Bow', 1))], [], "WillowsEnd.Upper", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.UpperHeartPath"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WillowsEnd.Upper", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.UpperHeartPath"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.ShriekArena (Door) -> WillowsEnd.ShriekArena"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.ShriekArena -> WillowsEnd.ShriekArena (Door)"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.ShriekArena -> Teleporters"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.MiniBossFight -> C.WillowsEnd.MiniBossFight"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.MiniBossFight -> H.WillowsEnd.MiniBossFight"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.MiniBossFight -> WillowsEnd.MinibossHeart"), lambda s: s.has_all(("Regenerate", "Bash", "Dash", "Double Jump", "Launch"), p) and has_enough_resources([('wall', ('Boss', 300)), ('db', 60)], [], "WillowsEnd.MiniBossFight", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.MiniBossFight -> WillowsEnd.Upper"), lambda s: s.has_all(("Launch", "Dash", "Glide", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> C.WillowsEnd.West"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.West -> E.WillowsEnd.West"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.SpinLasersHeart"), lambda s: s.has_all(("Launch", "Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 30))], [], "WillowsEnd.West", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.InnerTP"), lambda s: s.has_any(("Bash", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "WillowsEnd.West", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.InnerTP"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [('combat', 'MaceMiner')], "WillowsEnd.West", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.Upper"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 10)), ('energy', ('Grenade', 1))], [], "WillowsEnd.West", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.Upper"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "WillowsEnd.West", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.GlideHeartPath"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.GlideHeartPath -> C.WillowsEnd.GlideHeartPath"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.GlideHeartPath -> H.WillowsEnd.GlideHeartPath"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.GlideHeartPath -> WillowsEnd.GlideRooms"), lambda s: s.has_all(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GlideHeartPath -> WillowsEnd.West"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.GlideRooms -> C.WillowsEnd.GlideRooms"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.GlideRooms -> E.WillowsEnd.GlideRooms"), lambda s: s.has("BreakCrystal", p) and s.has_any(("Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GlideRooms -> E.WillowsEnd.GlideRooms"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [], "WillowsEnd.GlideRooms", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.GlideRooms -> WillowsEnd.GlideHeart"), lambda s: s.has("Glide", p) and has_enough_resources([('wall', ('BreakWall', 30))], [], "WillowsEnd.GlideRooms", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.GlideRooms -> WillowsEnd.WindSpinOre"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WillowsEnd.GlideRooms -> WillowsEnd.GlideHeartPath"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> C.WillowsEnd.UpperHeartPath"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> E.WillowsEnd.UpperHeartPath"), lambda s: s.has_all(("BreakCrystal", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> E.WillowsEnd.UpperHeartPath"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [], "WillowsEnd.UpperHeartPath", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperLeftEX"), lambda s: s.has_all(("Grapple", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.Upper"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperHeartCheckpoint"), lambda s: s.has_all(("Bash", "Grapple", "Launch", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperHeartCheckpoint"), lambda s: s.has_all(("Bash", "Grapple", "Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartCheckpoint -> C.WillowsEnd.UpperHeartCheckpoint"), lambda s: True, "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartCheckpoint -> WillowsEnd.SpinPortalsHeart"), lambda s: has_enough_resources([('wall', ('BreakWall', 30))], [], "WillowsEnd.UpperHeartCheckpoint", s, p, o, True), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartCheckpoint -> WillowsEnd.UpperRightEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartCheckpoint -> WillowsEnd.UpperHeartPath"), lambda s: s.has("WillowsEnd.SpinPortalsHeart", p), "or")
    add_rule(w.get_entrance("Tokk -> GladesTown.HandToHandPouch"), lambda s: s.has("EastHollow.HandToHandMap", p), "or")
    add_rule(w.get_entrance("TwillenShop -> GladesTown.TwillenGemQuest"), lambda s: s.has("LowerWastes.EerieGemQI", p), "or")
    add_rule(w.get_entrance("TwillenShop -> TwillenShop.Overcharge"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("TwillenShop -> TwillenShop.Wingclip"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("TwillenShop -> TwillenShop.Swap"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("TwillenShop -> TwillenShop.Vitality"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("TwillenShop -> TwillenShop.Energy"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("TwillenShop -> TwillenShop.Finesse"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("TwillenShop -> TwillenShop.TripleJump"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("TwillenShop -> TwillenShop.LightHarvest"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.Spike"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.SpiritSmash"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.SpiritStar"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.Blaze"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.Sentry"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.Teleport"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.ShockSmash"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.StaticStar"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.ExplodingSpike"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.RapidSentry"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.ChargeBlaze"), lambda s: can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("OpherShop -> OpherShop.WaterBreath"), lambda s: s.has("InnerWellspring.WaterEscape", p) and can_buy_shop(s, p), "or")
    add_rule(w.get_entrance("TuleyShop -> GladesTown.RegrowTheGlades"), lambda s: s.has_all(("TuleyShop.SelaFlowers", "TuleyShop.StickyGrass", "TuleyShop.Lightcatchers", "TuleyShop.BlueMoon", "TuleyShop.SpringPlants", "TuleyShop.LastTree"), p), "or")
    add_rule(w.get_entrance("TuleyShop -> TuleyShop.LastTreeBranchRejected"), lambda s: s.has("WoodsEntry.LastTreeBranch", p), "or")
    add_rule(w.get_entrance("TuleyShop -> TuleyShop.SelaFlowers"), lambda s: s.has("UpperWastes.FlowersSeed", p), "or")
    add_rule(w.get_entrance("TuleyShop -> TuleyShop.StickyGrass"), lambda s: s.has("EastPools.GrassSeed", p), "or")
    add_rule(w.get_entrance("TuleyShop -> TuleyShop.Lightcatchers"), lambda s: s.has("UpperDepths.LightcatcherSeed", p), "or")
    add_rule(w.get_entrance("TuleyShop -> TuleyShop.BlueMoon"), lambda s: s.has("InnerWellspring.BlueMoonSeed", p), "or")
    add_rule(w.get_entrance("TuleyShop -> TuleyShop.SpringPlants"), lambda s: s.has("UpperReach.SpringSeed", p), "or")
    add_rule(w.get_entrance("TuleyShop -> TuleyShop.LastTree"), lambda s: s.has("WoodsEntry.TreeSeed", p), "or")


def set_gorlek_rules(w: "WotWWorld"):
    """Gorlek (or medium) rules."""
    p = w.player
    o = w.options
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.GrappleHC"), lambda s: s.has("Grapple", p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.GrappleHC"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has("HowlsDen.RainLifted", p), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.GrappleHC"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "MarshSpawn.Main", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.GrappleHC"), lambda s: s.has_all(("Bash", "Launch"), p) and s.has("HowlsDen.RainLifted", p) and has_enough_resources([('db', 10)], [], "MarshSpawn.Main", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.GrappleHC"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('db', 10)], [('energy', ('Grenade', 1))], "MarshSpawn.Main", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.GrappleHC"), lambda s: s.has_all(("Bash", "Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.Main", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.GrappleHC"), lambda s: s.has_all(("Bash", "HowlsDen.RainLifted", "Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.BridgeEX"), lambda s: s.has_all(("HowlsDen.RainLifted", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.BridgeEX"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.BridgeEX"), lambda s: s.has_all(("HowlsDen.RainLifted", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.BridgeEX"), lambda s: s.has("Sword", p), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.Main"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.Main"), lambda s: s.has_all(("Sword", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.OpherBarrier"), lambda s: s.has_all(("MarshSpawn.LogBroken", "Hammer", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.LeverEC"), lambda s: s.has_all(("Grapple", "Bash"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.LeverEC"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.CaveEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.LeverEC"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.BrokenBridge"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.BrokenBridge"), lambda s: s.has_all(("HowlsDen.RainLifted", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.CaveKS"), lambda s: s.has_any(("Double Jump", "Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.Cave", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.BurrowOre"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.LifepactLedge"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.LifepactLedge"), lambda s: has_enough_resources([], [('db', 10)], "MarshSpawn.BurrowFightArena", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshSpawn.BurrowFightArena", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowFightArena -> MarshSpawn.LeftSpawnSignpost"), lambda s: s.has_all(("Clean Water", "Burrow"), p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.BurrowFightArena"), lambda s: s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.BurrowFightArena"), lambda s: has_enough_resources([], [('db', 10)], "MarshSpawn.LifepactLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshSpawn.LifepactLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.BurrowsApproachLedgeEX"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.BeforeBurrows"), lambda s: s.has_all(("Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.BeforeBurrows"), lambda s: s.has_all(("Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.BeforeBurrows"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshSpawn.PoolsBurrowsSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.BeforeBurrows"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.BeforeBurrows"), lambda s: s.has_all(("Launch", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.LifepactLedge"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('db', 10)], [], "MarshSpawn.PoolsBurrowsSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.LifepactLedge"), lambda s: s.has("Launch", p) and has_enough_resources([('db', 10)], [], "MarshSpawn.PoolsBurrowsSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BurrowsOpen"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BurrowsOpen"), lambda s: s.has_all(("Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BurrowsOpen"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "MarshSpawn.BurrowsEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.DamageTreeOpen"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BeforeBurrows"), lambda s: s.has("Sword", p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BeforeBurrows"), lambda s: s.has("Hammer", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BeforeBurrows"), lambda s: s.has_any(("Double Jump", "Dash", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshSpawn.BurrowsEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BeforeBurrows"), lambda s: s.has("Clean Water", p) and s.has_any(("Double Jump", "Dash", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BeforeBurrows"), lambda s: s.has("Clean Water", p) and has_enough_resources([], [('db', 10)], "MarshSpawn.BurrowsEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.BurrowOre"), lambda s: s.has_all(("Clean Water", "Burrow"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.BurrowOre"), lambda s: s.has_all(("Clean Water", "Burrow"), p) and has_enough_resources([], [('db', 10)], "MarshSpawn.LeftSpawnSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.PoolsPath"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.PoolsPath"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([], [('db', 10)], "MarshSpawn.LeftSpawnSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.PoolsPath"), lambda s: s.has_all(("Bash", "Glide"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshSpawn.LeftSpawnSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.PoolsPath"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 10)], [], "MarshSpawn.LeftSpawnSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.PoolsPath"), lambda s: s.has_all(("Launch", "Glide"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshSpawn.LeftSpawnSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.BurrowFightArena"), lambda s: s.has_all(("Clean Water", "Burrow"), p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.LeftSpawnSignpost -> MarshSpawn.BurrowFightArena"), lambda s: s.has_all(("Clean Water", "Burrow"), p) and has_enough_resources([], [('db', 10)], "MarshSpawn.LeftSpawnSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.WheelWall"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.WheelFreed"), lambda s: s.has_all(("PoolsApproach.WheelWall", "Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.PoolsPathEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.PoolsPathEX"), lambda s: s.has("Glide", p) and s.has_any(("Sword", "Hammer", "Double Jump", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.PoolsPathEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.PoolsPathEX"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.PoolsPathEX"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([], [('db', 10)], "MarshSpawn.PoolsPath", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has("Clean Water", p) and s.has_any(("PoolsApproach.WheelFreed", "Double Jump", "Launch"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Bash"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.PoolsPath", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has("Clean Water", p) and s.has("Hammer", p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.LeftSpawnSignpost"), lambda s: s.has("Launch", p) and has_enough_resources([('db', 10)], [], "MarshSpawn.PoolsPath", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.LeftSpawnSignpost"), lambda s: s.has("Clean Water", p) and s.has_any(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.LeftSpawnSignpost"), lambda s: s.has("Glide", p) and s.has_any(("Dash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> MarshSpawn.LeftSpawnSignpost"), lambda s: s.has("Double Jump", p) and s.has_any(("Sword", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.RegenDoor -> MarshSpawn.HowlApproach"), lambda s: s.has_all(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.RecklessShard"), lambda s: s.has("MarshSpawn.HowlBurnt", p) and s.has("Dash", p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "MarshSpawn.MokkTheBrave", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.RecklessShard"), lambda s: s.has_all(("MarshSpawn.HowlBurnt", "Glide"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "MarshSpawn.MokkTheBrave", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.HowlApproach"), lambda s: s.has_all(("MarshSpawn.HowlBurnt", "Dash", "Bash"), p) and s.has("HowlsDen.RainLifted", p), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.HowlApproach"), lambda s: s.has_all(("MarshSpawn.HowlBurnt", "Dash", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "MarshSpawn.MokkTheBrave", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.AboveHowlArena"), lambda s: s.has_all(("HowlsDen.RainLifted", "Hammer", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.AboveHowlArena"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> MarshSpawn.FangEC"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> MarshSpawn.FangPlatform"), lambda s: s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.AboveHowlArena -> MarshSpawn.FangPlatform"), lambda s: has_enough_resources([], [('db', 10)], "MarshSpawn.AboveHowlArena", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.FangPlatform -> MarshSpawn.FangEC"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshSpawn.FangPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.FangPlatform -> MarshSpawn.AboveHowlArena"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("MarshSpawn.FangPlatform -> MarshSpawn.AboveHowlArena"), lambda s: s.has("Glide", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshSpawn.FangPlatform -> MarshSpawn.AboveHowlArena"), lambda s: s.has("Glide", p) and has_enough_resources([], [('db', 10)], "MarshSpawn.FangPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.HowlsDenEntrance -> MarshSpawn.MokkTheBrave"), lambda s: s.has("MarshSpawn.HowlBurnt", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> HowlsDen.RightHC"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "HowlsDen.UpperLoopExit", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> MarshSpawn.HowlsDenEntrance"), lambda s: s.has("HowlsDen.UpperLoopExitBarrier", p) and s.has_any(("Glide", "Sword"), p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopExit -> HowlsDen.AboveBoneBridge"), lambda s: s.has("HowlsDen.UpperLoopExitBarrier", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("HowlsDen.AboveBoneBridge -> MarshSpawn.HowlsDenEntrance"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("HowlsDen.AboveBoneBridge -> MarshSpawn.HowlsDenEntrance"), lambda s: s.has("Bash", p) and can_enter_area("MarshSpawn", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.AboveBoneBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.RightHC"), lambda s: s.has("HowlsDen.UpperLoopEntranceBarrier", p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "HowlsDen.UpperLoopEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.AboveBoneBridge"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.UpperLoopExit"), lambda s: s.has("HowlsDen.UpperLoopEntranceBarrier", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.UpperLoopExit"), lambda s: s.has_all(("HowlsDen.UpperLoopEntranceBarrier", "Glide"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.UpperLoopExit"), lambda s: s.has_all(("HowlsDen.UpperLoopEntranceBarrier", "Glide"), p) and has_enough_resources([], [('combat', 'Slug')], "HowlsDen.UpperLoopEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.UpperLoopExit"), lambda s: s.has("HowlsDen.UpperLoopEntranceBarrier", p) and s.has("Sword", p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.AboveDoorKS"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.AboveDoorKS"), lambda s: s.has("Bash", p) and has_enough_resources([('db', 10)], [], "HowlsDen.BoneBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.UpperLoopEntrance"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.UpperLoopEntrance"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.BoneBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridgeDoor -> HowlsDen.OutsideSecretRoom"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridgeDoor -> HowlsDen.OutsideSecretRoom"), lambda s: has_enough_resources([], [('db', 10)], "HowlsDen.BoneBridgeDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.BoneBridgeDoor"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.BoneBridgeDoor"), lambda s: has_enough_resources([], [('db', 10)], "HowlsDen.OutsideSecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has("Hammer", p) and has_enough_resources([], [('db', 10)], "HowlsDen.OutsideSecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 10)], [], "HowlsDen.OutsideSecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has_all(("Clean Water", "Water Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.OutsideSecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and has_enough_resources([('db', 10)], [], "HowlsDen.OutsideSecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "HowlsDen.MidwayBottomLoop", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('energy', ('Grenade', 1))], [], "HowlsDen.MidwayBottomLoop", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 16)), ('energy', ('Grenade', 1))], [('db', 10)], "HowlsDen.MidwayBottomLoop", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.SecretRoom -> HowlsDen.LeftSecretRoom"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("HowlsDen.SecretRoom -> HowlsDen.LeftSecretRoom"), lambda s: s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "HowlsDen.SecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.LeftHC"), lambda s: s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "HowlsDen.LeftSecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 10)], "HowlsDen.LeftSecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has_all(("Dash", "Hammer"), p), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.DoubleJumpApproach"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.AboveTeleporter"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpApproach -> HowlsDen.DoubleJumpTreeLedge"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeLedge -> HowlsDen.DoubleJumpApproach"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.MillView -> MarshPastOpher.OpherSkipBranch"), lambda s: s.has_all(("Launch", "Bash"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.MillView -> MarshPastOpher.OpherSkipBranch"), lambda s: s.has_all(("Launch", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "MarshPastOpher.MillView", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.MillView -> MarshPastOpher.OpherSkipBranch"), lambda s: s.has_all(("Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.OpherSkipBranch -> MarshPastOpher.PoolsPathEast"), lambda s: s.has("Launch", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.OpherSkipBranch -> MarshPastOpher.PoolsPathEast"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 10)], "MarshPastOpher.OpherSkipBranch", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.OpherSkipBranch -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("Launch", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshPastOpher.OpherSkipBranch", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialStart -> MarshPastOpher.SpiritTrial"), lambda s: s.has_all(("MarshPastOpher.TrialActivation", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialStart -> MarshPastOpher.BowPath"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.UnderTrunk -> MarshPastOpher.TrialLeftEX"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.UnderTrunk -> MarshPastOpher.TrialLeftEX"), lambda s: has_enough_resources([], [('db', 10)], "MarshPastOpher.UnderTrunk", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> H.MarshPastOpher.TrialArea"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialActivation"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialActivation"), lambda s: s.has("Grapple", p) and has_enough_resources([], [('db', 10)], "MarshPastOpher.TrialArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialEC"), lambda s: s.has("Sword", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialEC"), lambda s: s.has("Hammer", p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.TrialArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialRightEX"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.UnderTrunk"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.TrialArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.BowPath"), lambda s: s.has_any(("Sword", "Hammer", "Launch"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "MarshPastOpher.TrialArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.BowPath"), lambda s: s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1))], [], "MarshPastOpher.TrialArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.SwingPoleEX"), lambda s: s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.BowPath", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.SwingPoleEX"), lambda s: s.has("Bash", p) and has_enough_resources([('db', 10), ('energy', ('Grenade', 1))], [], "MarshPastOpher.BowPath", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.BowApproach"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.BowApproach"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "MarshPastOpher.BowPath", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.BowApproach"), lambda s: s.has("Glide", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.MillView"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.MillView"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshPastOpher.BowPath", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowPath -> MarshPastOpher.TrialStart"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.BowArea"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.BowArea"), lambda s: has_enough_resources([], [('db', 10)], "MarshPastOpher.BowApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Bow', 2))], [], "MarshPastOpher.BowApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has_any(("Triple Jump", "Glide"), p) and has_enough_resources([('energy', ('Bow', 2))], [], "MarshPastOpher.BowApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowApproach -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.UpperBowArea"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.UpperBowArea"), lambda s: s.has_any(("Dash", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'Skeeto'), ('energy', ('Bow', 2))], [], "MarshPastOpher.BowArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.UpperBowArea"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Bow', 2))], [], "MarshPastOpher.BowArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.UpperBowArea"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "MarshPastOpher.BowArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.BowApproach"), lambda s: s.has_any(("Bash", "Sword"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.BowApproach"), lambda s: has_enough_resources([], [('db', 10)], "MarshPastOpher.BowArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.UpperBowArea -> MarshPastOpher.LeftEyestone"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [], "MarshPastOpher.UpperBowArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.UpperBowArea -> MarshPastOpher.RightEyestone"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [], "MarshPastOpher.UpperBowArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> H.MarshPastOpher.PoolsPathEast"), lambda s: True, "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> E.MarshPastOpher.PoolsPathEast"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.CeilingEX"), lambda s: s.has_all(("Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.CeilingEX"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshPastOpher.PoolsPathEast", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.PoolsPathMiddle"), lambda s: s.has_all(("Bash", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.PoolsPathMiddle"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Bat')], [], "MarshPastOpher.PoolsPathEast", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEC"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEC"), lambda s: s.has("Dash", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEC"), lambda s: s.has("Glide", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEC"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Bash", "Dash"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Bash"), p) and s.has_any(("Sword", "Glide"), p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Launch"), p) and has_enough_resources([], [('db', 10)], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Clean Water"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Double Jump", "Triple Jump"), p) and has_enough_resources([], [('db', 10)], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Double Jump", "Dash", "Water Dash"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Double Jump", "Dash", "Water Dash"), p) and has_enough_resources([], [('db', 10)], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Double Jump", "Hammer", "Water Dash"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Double Jump", "Hammer", "Water Dash"), p) and has_enough_resources([], [('db', 10)], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEast"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEast"), lambda s: has_enough_resources([('db', 10)], [], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> MarshPastOpher.PoolsPathWest"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> MarshPastOpher.PoolsPathWest"), lambda s: s.has_all(("Bash", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.PoolsPathOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> MarshPastOpher.PoolsPathWest"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.PoolsPathOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> MarshPastOpher.PoolsPathWest"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> MarshPastOpher.PoolsPathWest"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathOneWayWall -> MarshPastOpher.PoolsPathWest"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 10)], "MarshPastOpher.PoolsPathOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Spear', 1))], [], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has_all(("Glide", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Spear', 1))], [], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has("Hammer", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([], [('energy', ('Spear', 1))], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has_all(("Double Jump", "Sword"), p) and s.has("Hammer", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has_all(("Double Jump", "Sword"), p) and has_enough_resources([], [('energy', ('Spear', 1))], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and s.has("Hammer", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathFloor"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and has_enough_resources([], [('energy', ('Spear', 1))], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Launch"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Glide"), p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("MarshPastOpher.PoolsPathFloor", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathEast"), lambda s: s.has("Water Dash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 10), ('energy', ('Spear', 1))], [], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("Water Dash", "Hammer"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathEast"), lambda s: s.has_all(("Water Dash", "Hammer"), p) and has_enough_resources([('db', 10)], [('db', 10)], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathEast"), lambda s: s.has("Water Dash", p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('db', 10), ('db', 10), ('energy', ('Spear', 1))], [], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has("Double Jump", p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.PoolsPathWest", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has("Dash", p) and s.has("Glide", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has("Dash", p) and has_enough_resources([], [('db', 10)], "MarshPastOpher.PoolsPathWest", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MarshPastOpher.PoolsPathWest", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 10)], "MarshPastOpher.PoolsPathWest", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathOneWayWall"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Glide", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathOneWayWall"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.PoolsPathWest", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathOneWayWall"), lambda s: s.has("Dash", p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "MarshPastOpher.PoolsPathWest", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> MidnightBurrows.BelowLupo"), lambda s: s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> MidnightBurrows.BelowLupo"), lambda s: has_enough_resources([], [('db', 16)], "MidnightBurrows.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("MarshSpawn.BurrowsOpen", "Bash", "Double Jump"), p) and can_enter_area("MarshSpawn", s, p, o), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.LeftKS"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.LeftKS"), lambda s: has_enough_resources([], [('db', 15)], "MidnightBurrows.BelowLupo", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.Central"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.Central"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Sword", "Hammer", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowLupo -> MidnightBurrows.Central"), lambda s: s.has("Bash", p) and has_enough_resources([], [('db', 15)], "MidnightBurrows.BelowLupo", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.LupoMap"), lambda s: can_buy_map(s, p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.DeflectorShard"), lambda s: s.has_all(("MidnightBurrows.Lever", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.DeflectorShard"), lambda s: s.has("MidnightBurrows.Lever", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.TabletRoom"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.PortalRoom"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.PortalRoom"), lambda s: has_enough_resources([], [('db', 15)], "MidnightBurrows.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.LeverRoom"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.LeverRoom"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.LeverRoom"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.LeverRoom"), lambda s: s.has_any(("Double Jump", "Dash", "Bash", "Sword", "Hammer"), p) and has_enough_resources([('db', 15)], [], "MidnightBurrows.PortalRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.LeverRoom"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.East"), lambda s: s.has_all(("MidnightBurrows.Lever", "Sword"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.East"), lambda s: s.has_all(("MidnightBurrows.Lever", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "MidnightBurrows.PortalRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.East"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 3))], [], "MidnightBurrows.PortalRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.Central"), lambda s: has_enough_resources([('db', 15)], [], "MidnightBurrows.PortalRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.LowerKS"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.LowerKS"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.LowerKS"), lambda s: s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('db', 15)], [], "MidnightBurrows.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.PortalRoom"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.PortalRoom"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 15)], "MidnightBurrows.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.PortalRoom"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.PortalRoom"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.East -> MidnightBurrows.DenConnection"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.East -> MidnightBurrows.DenConnection"), lambda s: has_enough_resources([], [('db', 10)], "MidnightBurrows.East", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalCorridor -> MidnightBurrows.BelowUpperKS"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalCorridor -> MidnightBurrows.BelowUpperKS"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalCorridor -> MidnightBurrows.BelowUpperKS"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalCorridor -> MidnightBurrows.BelowUpperKS"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('db', 15)], [], "MidnightBurrows.PortalCorridor", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.BelowUpperKS -> MidnightBurrows.UpperKS"), lambda s: s.has_any(("Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.PurpleDoorOpen"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.Entrance", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.PurpleDoorOpen"), lambda s: s.has_all(("Glide", "WestHollow.FullyDrained"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.Entrance", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.PurpleDoorOpen"), lambda s: s.has_all(("Glide", "WestHollow.UpperDrainLeverPulled"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.Entrance", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> MarshPastOpher.BowArea"), lambda s: s.has("MarshPastOpher.EyestoneDoor", p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and can_enter_area("MarshPastOpher", s, p, o), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> MarshPastOpher.BowArea"), lambda s: s.has("MarshPastOpher.EyestoneDoor", p) and can_enter_area("MarshPastOpher", s, p, o) and has_enough_resources([], [('db', 10)], "WestHollow.Entrance", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.MokiByTwillen"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.InFrontPurpleDoorEnemyPaths"), lambda s: s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.Entrance", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.InFrontPurpleDoorEnemyPaths"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [('db', 10)], "WestHollow.Entrance", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.InFrontPurpleDoorEnemyPaths"), lambda s: s.has("Double Jump", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.UpperDrainLeverPulled"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('combat', 'BombSlug')], [], "WestHollow.MokiByTwillen", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.UpperDrainLeverPulled"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('db', 10)], [], "WestHollow.MokiByTwillen", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.UpperDrainLeverPulled"), lambda s: has_enough_resources([('db', 10)], [('energy', ('Bow', 1))], "WestHollow.MokiByTwillen", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.MokiByTwillen -> WestHollow.InFrontPurpleDoorEnemyPaths"), lambda s: has_enough_resources([('db', 10)], [], "WestHollow.MokiByTwillen", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.MokiByTwillen"), lambda s: has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.InFrontPurpleDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.MokiByTwillen"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.Entrance"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained", "Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.Entrance"), lambda s: has_enough_resources([], [('db', 20)], "WestHollow.InFrontPurpleDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.HollowDrainMiddle"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_all(("WestHollow.UpperTongueExtended", "WestHollow.FullyDrained"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.HollowDrainMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_all(("WestHollow.UpperTongueExtended", "WestHollow.UpperDrainLeverPulled"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.HollowDrainMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_all(("Double Jump", "WestHollow.FullyDrained"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_all(("Double Jump", "WestHollow.UpperDrainLeverPulled"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_all(("Dash", "WestHollow.FullyDrained"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_all(("Dash", "WestHollow.UpperDrainLeverPulled"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.RockPuzzle"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('db', 20)], [], "WestHollow.HollowDrainMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.Entrance"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainMiddle -> WestHollow.Entrance"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.Entrance"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> E.WestHollow.RockPuzzle"), lambda s: s.has("BreakCrystal", p), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleSolved"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has("Launch", p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.RockPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleSolved"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has("Launch", p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.RockPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleSolved"), lambda s: s.has("Bash", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('energy', ('Bow', 1)), ('energy', ('Grenade', 1))], [], "WestHollow.RockPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.HollowDrainMiddle"), lambda s: s.has_all(("WestHollow.UpperDrainLeverPulled", "Launch"), p) and has_enough_resources([('db', 20)], [], "WestHollow.RockPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.HollowDrainMiddle"), lambda s: s.has_all(("WestHollow.UpperDrainLeverPulled", "Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 20)], [], "WestHollow.RockPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.Entrance"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.FarLeftRoom"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('combat', 'Skeeto'), ('combat', 'Slug'), ('energy', ('Bow', 1))], [], "WestHollow.PastRockPuzzleDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.FarLeftRoom"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('combat', 'Skeeto'), ('combat', 'Slug'), ('energy', ('Bow', 1))], [], "WestHollow.PastRockPuzzleDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.FarLeftRoom"), lambda s: s.has_all(("Double Jump", "WestHollow.FullyDrained"), p) and has_enough_resources([], [('combat', 'Slug'), ('db', 10)], "WestHollow.PastRockPuzzleDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.FarLeftRoom"), lambda s: s.has_all(("Double Jump", "WestHollow.UpperDrainLeverPulled"), p) and has_enough_resources([], [('combat', 'Slug'), ('db', 10)], "WestHollow.PastRockPuzzleDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FarLeftRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FullyDrained"), lambda s: s.has_all(("WestHollow.UpperDrainLeverPulled", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FullyDrained"), lambda s: s.has_all(("WestHollow.UpperDrainLeverPulled", "Bash"), p) and has_enough_resources([('energy', ('Bow', 1)), ('energy', ('Grenade', 1))], [], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FullyDrained"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Bow', 2))], [], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FullyDrained"), lambda s: s.has_all(("WestHollow.UpperDrainLeverPulled", "Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 10)], [], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FullyDrained"), lambda s: s.has_all(("WestHollow.UpperDrainLeverPulled", "Double Jump", "Dash"), p) and has_enough_resources([('db', 10)], [], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FullyDrained"), lambda s: s.has_all(("WestHollow.UpperDrainLeverPulled", "Water Dash"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FarLeftEX"), lambda s: s.has_all(("WestHollow.FullyDrained", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FarLeftEX"), lambda s: s.has_all(("WestHollow.FullyDrained", "Double Jump"), p) and has_enough_resources([], [('db', 10)], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FarLeftEX"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Dash", "Double Jump"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.FarLeftEX"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.UpperTongueRetracted"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.LowerTongueExtended"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.SubmergedPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.HollowDrainMiddle"), lambda s: s.has_all(("WestHollow.FullyDrained", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.HollowDrainMiddle"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.UpperTongueRetracted", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestHollow.SubmergedPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.HollowDrainMiddle"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.UpperTongueExtended", "WestHollow.LowerTongueExtended", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.RockPuzzle"), lambda s: s.has("WestHollow.FullyDrained", p) and has_enough_resources([('db', 10)], [], "WestHollow.SubmergedPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.AboveJumppad"), lambda s: s.has("WestHollow.FullyDrained", p), "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.AboveJumppad"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.LowerTongueRetracted"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has("Bash", p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.AboveJumppad", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.LowerTongueRetracted"), lambda s: s.has("WestHollow.FullyDrained", p) and has_enough_resources([('energy', ('Bow', 1))], [('combat', 'Slug'), ('db', 10)], "WestHollow.AboveJumppad", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.AboveJumppad -> WestHollow.SubmergedPlatform"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.LowerTongueExtended", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.QuickshotShard"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Dash", "Launch"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WestHollow.HollowDrainLower", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.LupoMap"), lambda s: s.has("Double Jump", p) and can_buy_map(s, p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('combat', 'Slug'), ('combat', 'Skeeto'), ('combat', 'Skeeto')], [], "WestHollow.HollowDrainLower", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has_all(("WestHollow.FullyDrained", "Bash"), p), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.PolesPond"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> WestHollow.TrialStart"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'Slug')], [], "WestHollow.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> WestHollow.TrialStart"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> WestHollow.TrialStart"), lambda s: s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "WestHollow.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> WestHollow.TrialStart"), lambda s: s.has("Glide", p) and s.has("Bash", p) and has_enough_resources([('db', 10)], [], "WestHollow.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.TrialApproach -> WestHollow.TrialStart"), lambda s: s.has("Glide", p) and has_enough_resources([('db', 10)], [('combat', 'Slug')], "WestHollow.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.TrialStart -> WestHollow.SpiritTrial"), lambda s: s.has_all(("WestHollow.TrialActivation", "WestHollow.FullyDrained", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.FallingSlugEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.DashApproach"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.HollowDrainLower"), lambda s: s.has("Sword", p), "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.HollowDrainLower"), lambda s: s.has("Water Dash", p) and s.has_any(("Hammer", "Glide"), p) and has_enough_resources([('db', 30), ('combat', 'Slug')], [], "WestHollow.PolesPond", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.PolesPond -> WestHollow.HollowDrainLower"), lambda s: s.has_all(("Water Dash", "Clean Water"), p) and s.has_any(("Hammer", "Glide"), p) and has_enough_resources([('db', 10), ('combat', 'Slug')], [], "WestHollow.PolesPond", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.TrialActivation"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.DoorLever"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.PolesPond"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.PolesPond"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WestHollow.DashApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.CrusherEX"), lambda s: True, "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestHollow.DashCrushers", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.DashRightEX"), lambda s: s.has_all(("Double Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.DashRightEX"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has_any(("Triple Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.DashRightEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Glide"), p) and has_enough_resources([('combat', 'WeakSlug')], [], "WestHollow.DashRoomTopRight", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.DashCrushers"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.AboveDashSemisolid"), lambda s: s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.AboveDashSemisolid"), lambda s: s.has("Bash", p) and s.has("Sword", p), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.AboveDashSemisolid"), lambda s: s.has("Bash", p) and has_enough_resources([], [('db', 10)], "WestHollow.DashRoomTopRight", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashRoomTopRight -> WestHollow.AboveDashSemisolid"), lambda s: s.has_any(("Glide", "Sword"), p) and has_enough_resources([('combat', 'Hornbug')], [], "WestHollow.DashRoomTopRight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> BeetleFight"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> EastHollow.AfterBeetleFight"), lambda s: s.has_any(("EastHollow.BeetleDefeated", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> EastHollow.VoiceDoorPlatform"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("BeetleFight -> EastHollow.BeetleDefeated"), lambda s: s.has("Regenerate", p) and s.has_any(("Dash", "Double Jump", "Launch"), p) and has_enough_resources([('wall', ('Boss', 250)), ('db', 35)], [], "BeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.HornBeetleFightEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.Teleporter"), lambda s: True, "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.AfterBeetleFight"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.AfterBeetleFight"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("EastHollow.VoiceDoorPlatform -> EastHollow.AfterBeetleFight"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> EastHollow.GladesApproachOre"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> EastHollow.OutsideGlades"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastHollow.MapMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> EastHollow.OutsideGlades"), lambda s: s.has("Bash", p) and has_enough_resources([('db', 10)], [], "EastHollow.MapMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SpikeLanternEX"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SpikeLanternEX"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Bash"), p) and s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SpikeLanternEX"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SpikeLanternEX"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 10)], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SecretRoofEX"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SecretRoofEX"), lambda s: s.has_all(("Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.MortarEX"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has_all(("Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash"), p) and s.has_any(("Bash", "Sword"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has("EastHollow.BeetleDefeated", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.VoiceDoorPlatform"), lambda s: s.has_all(("EastHollow.BeetleDefeated", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Kwolok"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Kwolok"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has("Grapple", p) and has_enough_resources([('db', 10)], [], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.DepthsLever"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashEC"), lambda s: s.has_all(("Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashEC"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashTreeCheckpoint"), lambda s: s.has_any(("Double Jump", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashTreeCheckpoint"), lambda s: has_enough_resources([], [('db', 10)], "EastHollow.AboveBash", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.AboveDepths"), lambda s: s.has("EastHollow.DepthsLever", p) and s.has_any(("Double Jump", "Dash", "Bash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.AboveDepths"), lambda s: s.has("EastHollow.DepthsLever", p) and has_enough_resources([], [('db', 10)], "EastHollow.AboveBash", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.AfterBeetleFight"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.BashEX"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastHollow.BashTreeCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.AboveBash"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.AboveBash"), lambda s: s.has_all(("Bash", "Sword"), p), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.AboveBash"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 10)], [], "EastHollow.BashTreeCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.SilentSwimEC"), lambda s: s.has("Clean Water", p) and s.has_any(("Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.SilentSwimEC"), lambda s: s.has_all(("Clean Water", "Double Jump", "Triple Jump"), p) and has_enough_resources([('combat', 'Balloon'), ('db', 10)], [], "EastHollow.Kwolok", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.SilentSwimEC"), lambda s: s.has_all(("Clean Water", "Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 20)], [], "EastHollow.Kwolok", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.KwolokSwimOre"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.KwolokSwimLeftEX"), lambda s: s.has_all(("Clean Water", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.SecretRoofEX"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.AfterBeetleFight"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.AfterBeetleFight"), lambda s: s.has("Bash", p) and has_enough_resources([], [('db', 10)], "EastHollow.Kwolok", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.AfterBeetleFight"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.AfterBeetleFight"), lambda s: s.has("Hammer", p) and has_enough_resources([('db', 10)], [], "EastHollow.Kwolok", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> WoodsEntry.ShriekMeet"), lambda s: s.has_all(("EastHollow.SilentSwimWall", "Clean Water", "Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p) and can_enter_area("WoodsEntry", s, p, o) and has_enough_resources([('combat', 'Balloon')], [], "EastHollow.Kwolok", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> WoodsEntry.ShriekMeet"), lambda s: s.has_all(("EastHollow.SilentSwimWall", "Clean Water", "Grapple", "Dash"), p) and can_enter_area("WoodsEntry", s, p, o) and has_enough_resources([('combat', 'Balloon')], [], "EastHollow.Kwolok", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> WoodsEntry.ShriekMeet"), lambda s: s.has_all(("EastHollow.SilentSwimWall", "Clean Water", "Water Dash", "Double Jump", "Triple Jump"), p) and can_enter_area("WoodsEntry", s, p, o) and has_enough_resources([('combat', 'Balloon')], [], "EastHollow.Kwolok", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> WoodsEntry.ShriekMeet"), lambda s: s.has_all(("EastHollow.SilentSwimWall", "Clean Water", "Water Dash", "Double Jump"), p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and can_enter_area("WoodsEntry", s, p, o) and has_enough_resources([('combat', 'Balloon'), ('db', 10)], [], "EastHollow.Kwolok", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.DepthsExteriorEX"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastHollow.AboveDepths", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.DepthsExteriorEX"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.DepthsExteriorEX"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastHollow.AboveDepths", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.BashTreeCheckpoint"), lambda s: s.has("EastHollow.DepthsLever", p) and has_enough_resources([('db', 5)], [], "EastHollow.AboveDepths", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.ArcingShard"), lambda s: s.has_all(("GladesTown.ClearThorns", "TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.LupoSwimMiddleEX"), lambda s: s.has_all(("Clean Water", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.LupoSwimLeftEX"), lambda s: s.has_all(("GladesTown.ClearThorns", "Clean Water", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.UpperWest"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple", "TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.BelowBountyShard"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.AboveOpher"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.LeftAboveCoals"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> TuleyShop"), lambda s: s.has("GladesTown.TuleySpawned", p) and s.has_any(("Burrow", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.LowerOre"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.LowerOre"), lambda s: s.has("Sword", p) and has_enough_resources([('energy', ('Spear', 1))], [], "GladesTown.TwillenHome", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.LowerOre"), lambda s: has_enough_resources([('energy', ('Spear', 1))], [('db', 10)], "GladesTown.TwillenHome", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.West"), lambda s: s.has("TuleyShop.SpringPlants", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.West"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Bash"), p) and s.has_any(("Double Jump", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Double Jump", "Triple Jump", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "TuleyShop.Lightcatchers", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "TuleyShop.Lightcatchers", "Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.StickyGrass", "Bash"), p) and s.has_any(("Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.StickyGrass", "TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.MotayHut"), lambda s: s.has_all(("GladesTown.BuildHuts", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> WestGlades.PastTown"), lambda s: s.has_all(("Bash", "Glide"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.West -> WestGlades.PastTown"), lambda s: s.has_all(("Bash", "Sword"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('db', 10)], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> WestGlades.PastTown"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('combat', 'WeakSlug'), ('combat', 'WeakSlug')], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> WestGlades.PastTown"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('combat', 'WeakSlug'), ('combat', 'WeakSlug')], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> WestGlades.PastTown"), lambda s: s.has_all(("Sword", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.Teleporter"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Dash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "TuleyShop.StickyGrass", "Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Double Jump", "Triple Jump", "Hammer"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Grapple", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.StickyGrass", "TuleyShop.Lightcatchers", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperWest"), lambda s: s.has_all(("GladesTown.BuildHuts", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.MotayHut", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperWest"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.Lightcatchers", "Bash", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.ArcingShard"), lambda s: s.has("GladesTown.ClearThorns", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.UpperLeftEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.UpperLeftEX"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Grapple", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.AboveGromHC"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.AboveGromHC"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.MotayHut"), lambda s: s.has("GladesTown.BuildHuts", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.West"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.Teleporter"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.AboveCaveEX"), lambda s: s.has_all(("Hammer", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.AboveCaveEX"), lambda s: s.has("TuleyShop.SpringPlants", p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.CaveBurrowEX"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.Teleporter"), lambda s: s.has_all(("GladesTown.ClearThorns", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "GladesTown.AcornMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.Teleporter"), lambda s: s.has_all(("GladesTown.ClearThorns", "Hammer", "Dash"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornQI"), lambda s: s.has_all(("Flash", "Clean Water"), p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornQI"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Bow', 4))], [], "GladesTown.AcornCave", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornQI"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Bow', 4)), ('energy', ('Grenade', 1))], [], "GladesTown.AcornCave", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.BountyShard"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.BountyShard"), lambda s: s.has("TuleyShop.StickyGrass", p) and s.has_any(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.LeftAboveCoals"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.LeftAboveCoals"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.UpdraftCeilingEX"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.UpdraftCeilingEX"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.UpdraftCeilingEX"), lambda s: s.has_all(("TuleyShop.SpringPlants", "Sword"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.BelowBountyShard"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.BelowBountyShard"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.AboveOpher"), lambda s: s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.PlayfulMoki"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.PlayfulMoki"), lambda s: s.has("TuleyShop.SpringPlants", p) and s.has_any(("Hammer", "Sword"), p), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> TuleyShop"), lambda s: s.has_all(("GladesTown.TuleySpawned", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.PlayfulMoki -> GladesTown.HoleHut"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("GladesTown.PlayfulMoki -> GladesTown.HoleHut"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p), "or")
    add_rule(w.get_entrance("GladesTown.PlayfulMoki -> TuleyShop"), lambda s: s.has("GladesTown.TuleySpawned", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> GladesTown.UpdraftCeilingEX"), lambda s: s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> GladesTown.HoleHutEntrance"), lambda s: s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has("Launch", p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p) and s.has_any(("Glide", "Sword", "Hammer"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Grapple"), p) and s.has_any(("Glide", "Sword"), p) and can_enter_area("LowerReach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> E.WestGlades.PastTown"), lambda s: s.has("Clean Water", p) and has_enough_resources([], [('energy', ('Bow', 1)), ('energy', ('Grenade', 1))], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> E.WestGlades.PastTown"), lambda s: s.has("Glide", p) and has_enough_resources([], [('energy', ('Bow', 1)), ('energy', ('Grenade', 1))], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> E.WestGlades.PastTown"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([], [('energy', ('Bow', 1)), ('energy', ('Grenade', 1))], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.GrappleEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.GrappleEX"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has_all(("Bash", "Water Dash"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has_all(("Bash", "Water Dash"), p) and has_enough_resources([], [('db', 20)], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has("Double Jump", p) and has_enough_resources([], [('db', 10), ('combat', 'Tentacle')], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has("Dash", p) and has_enough_resources([], [('db', 10), ('combat', 'Tentacle')], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has_all(("Water Dash", "Bash"), p) and has_enough_resources([('db', 20)], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> GladesTown.West"), lambda s: s.has("Bash", p) and can_enter_area("GladesTown", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> GladesTown.West"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p) and can_enter_area("GladesTown", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> GladesTown.West"), lambda s: s.has_all(("Double Jump", "Glide"), p) and can_enter_area("GladesTown", s, p, o) and has_enough_resources([('db', 10)], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.LeftOre"), lambda s: s.has("Grapple", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.LeftOre"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 10)], [], "WestGlades.LowerPool", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.LeftOre"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestGlades.LowerPool", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.LeftOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.Center"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.Center"), lambda s: s.has_all(("Grapple", "Double Jump", "Triple Jump", "Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.PastTown"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.PastTown"), lambda s: s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('combat', 'Tentacle')], [], "WestGlades.LowerPool", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.PastTown"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "WestGlades.LowerPool", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.RightOre"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.RightOre"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "WestGlades.Center", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.Upper"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.LowerPool"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.RightOre"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.RightOre"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.MillApproach"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.MillApproach"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.MillApproach"), lambda s: s.has("Water Dash", p) and has_enough_resources([('db', 20)], [], "WestGlades.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.SwimOre"), lambda s: s.has_all(("Clean Water", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.SwimOre"), lambda s: s.has_all(("Clean Water", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.SwimOre"), lambda s: s.has_all(("Clean Water", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.ShrineArea"), lambda s: s.has("Grapple", p) and s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.ShrineArea"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.Upper"), lambda s: s.has_any(("Clean Water", "Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.Upper"), lambda s: has_enough_resources([], [('db', 20)], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.Upper"), lambda s: s.has("Hammer", p) and s.has_any(("Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has_any(("Double Jump", "Dash"), p) and can_enter_area("OuterWellspring", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has_any(("Glide", "Sword"), p) and can_enter_area("OuterWellspring", s, p, o) and has_enough_resources([('db', 20)], [], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Sword"), p) and can_enter_area("OuterWellspring", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has("Bash", p) and can_enter_area("OuterWellspring", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has("Bash", p) and can_enter_area("OuterWellspring", s, p, o) and has_enough_resources([('energy', ('Grenade', 2))], [], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Bash"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Grapple"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([], [('db', 15)], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Double Jump", "Triple Jump"), p) and s.has_any(("Water Dash", "Bash"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Bash"), p) and s.has_any(("Dash", "Glide", "Sword"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Bash"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([], [('db', 15)], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and s.has_any(("Dash", "Glide", "Sword"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([], [('db', 15)], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Bash", "Water Dash", "Sword", "Hammer"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Clean Water", "Launch"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([], [('db', 15)], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.ShrineArea -> WestGlades.ShrineHC"), lambda s: s.has_all(("Grapple", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> H.OuterWellspring.EntranceDoor"), lambda s: has_enough_resources([('combat', 'Slug')], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestWallBroken"), lambda s: s.has_any(("Double Jump", "Bash", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestWallBroken"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [('combat', 'Slug'), ('combat', 'Mantis')], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.EntranceRoofEX"), lambda s: s.has_all(("Grapple", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.EntranceRoofEX"), lambda s: s.has_all(("Grapple", "Dash", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.EntranceRoofEX"), lambda s: s.has_all(("Launch", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.BasementEC"), lambda s: s.has_any(("Double Jump", "Dash", "Grapple", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestEntry"), lambda s: s.has("OuterWellspring.LifeHarvestWallBroken", p) and s.has_any(("Double Jump", "Bash", "Dash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.LifeHarvestEntry"), lambda s: s.has("OuterWellspring.LifeHarvestWallBroken", p) and has_enough_resources([], [('combat', 'Slug'), ('combat', 'Mantis')], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has("Dash", p) and has_enough_resources([], [('db', 15)], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has_all(("Grapple", "Sword"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Hammer"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 15)], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Bash", p) and s.has("Glide", p) and has_enough_resources([('energy', ('Grenade', 3))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 3))], [('db', 15)], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 3))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has_all(("Double Jump", "Hammer"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('db', 20)], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has("Glide", p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('db', 20)], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has_all(("Bash", "Glide"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has("Bash", p) and s.has("Sword", p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('Grenade', 2))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has("Bash", p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('Grenade', 2))], [('db', 20)], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestLeverPulled"), lambda s: s.has_all(("Bash", "Dash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestLeverPulled"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestShard"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.LifeHarvestEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestShard"), lambda s: s.has_all(("OuterWellspring.LifeHarvestLeverPulled", "Bash", "Dash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.EntranceDoor"), lambda s: s.has("OuterWellspring.LifeHarvestWallBroken", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.BasementEC"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has("Launch", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 15)], "OuterWellspring.Basement", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Bash", "Double Jump", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Bash", "Double Jump"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.Basement", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("OuterWellspring.EntranceDoorOpen", "Bash", "Dash", "Glide"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.Basement", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.EntranceRoofEX"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallEC"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('db', 15)], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.EastDoor"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has("Grapple", p) and has_enough_resources([], [('db', 15)], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has_all(("Grapple", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has_all(("Bash", "Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 3))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has("Double Jump", p) and s.has_any(("Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has_all(("Double Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> WestGlades.MillApproach"), lambda s: s.has("Glide", p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.WestDoorBlueMoonFree"), lambda s: s.has("Bash", p) and s.has_any(("Bow", "Spear", "Shuriken", "Grenade", "Blaze", "Grapple"), p) and has_enough_resources([('wall', ('BreakWall', 3)), ('energy', ('Grenade', 1))], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("OuterWellspring.WestDoorBlueMoonFree", "Grapple", "Double Jump"), p) and s.has("Triple Jump", p), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("OuterWellspring.WestDoorBlueMoonFree", "Grapple", "Double Jump"), p) and has_enough_resources([], [('db', 15)], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("OuterWellspring.WestDoorBlueMoonFree", "Grapple"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 15)], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Bash"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 15)], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Bash", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.EastDoor"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.WestDoorBlueMoonFree"), lambda s: has_enough_resources([('wall', ('BreakWall', 3))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallEC"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallEC"), lambda s: s.has("Grapple", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallEC"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallEC"), lambda s: s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 2))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has_all(("InnerWellspring.TopDoorOpen", "Bash"), p) and s.has_any(("Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has_all(("InnerWellspring.TopDoorOpen", "Bash", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 10)], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.WestDoor"), lambda s: s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: s.has_all(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([], [('db', 15)], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([], [('db', 15)], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: s.has_all(("Double Jump", "Dash", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> WestGlades.MillApproach"), lambda s: can_enter_area("WestGlades", s, p, o) and has_enough_resources([('db', 20)], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has("Triple Jump", p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and has_enough_resources([], [('db', 15)], "OuterWellspring.AboveWestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has("Grapple", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.AboveWestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Glide"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.AboveWestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has("Launch", p) and s.has("Sword", p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 15)], "OuterWellspring.AboveWestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.TopDoor"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.TopDoor"), lambda s: s.has_all(("InnerWellspring.TopDoorOpen", "Double Jump"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.WestDoor"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.WestDoor"), lambda s: has_enough_resources([], [('db', 15)], "OuterWellspring.AboveWestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.EastDoor"), lambda s: s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.AboveWestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.EastDoor"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.EastDoor"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.TrialActivation"), lambda s: s.has_all(("Grapple", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.UltraGrappleShard"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.UltraGrappleShard"), lambda s: s.has_all(("Grapple", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> WestGlades.MillApproach"), lambda s: s.has("Sword", p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> WestGlades.MillApproach"), lambda s: can_enter_area("WestGlades", s, p, o) and has_enough_resources([], [('db', 20)], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> WestGlades.MillApproach"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Sword"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.EntranceDoor"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.EntranceDoor"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.EntranceDoor"), lambda s: has_enough_resources([], [('db', 20)], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.EntranceDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.TrialApproach"), lambda s: s.has("Grapple", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.TrialApproach"), lambda s: s.has("Grapple", p) and has_enough_resources([], [('combat', 'Bee')], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEX"), lambda s: s.has_all(("Grapple", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEX"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEC"), lambda s: s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.TrialRoom"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.TrialRoom"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.EastDoor"), lambda s: s.has_any(("Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.EastDoor"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.EastDoor"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.EastDoor"), lambda s: s.has_all(("Double Jump", "Hammer"), p) and has_enough_resources([('db', 15)], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.AboveEntranceDoor"), lambda s: has_enough_resources([('db', 15)], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallMidpoint"), lambda s: True, "or")
    add_rule(w.get_entrance("OuterWellspring.TrialRoom -> OuterWellspring.TrialStart"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.SpiritTrial"), lambda s: s.has_all(("OuterWellspring.TrialActivation", "Dash", "Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.TrialRoom"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.TrialRoom"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.TrialRoom"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialStart -> OuterWellspring.TrialRoom"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThornShardArea"), lambda s: s.has("Grapple", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThornShardArea"), lambda s: s.has("InnerWellspring.ThreeWheels", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThornShardArea"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.DrainRoom"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.DrainRoom"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 15)], [], "InnerWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.DrainRoom"), lambda s: s.has("InnerWellspring.ThreeWheels", p) and has_enough_resources([('db', 15)], [], "InnerWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ShortcutLever"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ShortcutLever"), lambda s: s.has("Grapple", p) and has_enough_resources([('db', 15)], [], "InnerWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ShortcutLever"), lambda s: s.has("Grapple", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.ThornShardArea", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornEX"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.ThornShardArea", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornEX"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornEX"), lambda s: s.has_all(("Grapple", "Dash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.ShortcutLever -> InnerWellspring.EntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.ShortcutLever -> InnerWellspring.WestDoor"), lambda s: s.has("InnerWellspring.ShortCutWheel", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.ShortcutLever -> InnerWellspring.WestDoor"), lambda s: s.has("InnerWellspring.ShortCutWheel", p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.ShortcutLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.ShortcutLever -> InnerWellspring.ThornShardArea"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.EntranceDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Glide", p) and has_enough_resources([('db', 15)], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("InnerWellspring.DrainRoomBottomWheel", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("InnerWellspring.DrainRoomBottomWheel", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("InnerWellspring.DrainRoomBottomWheel", "Bash"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("InnerWellspring.DrainLever", "Double Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("InnerWellspring.DrainLever", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("Clean Water", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has_all(("Clean Water", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 4))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaEntrance"), lambda s: s.has("InnerWellspring.DrainLever", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaEntrance"), lambda s: s.has("InnerWellspring.DrainLever", p) and has_enough_resources([], [('db', 15)], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaEntrance"), lambda s: s.has_all(("InnerWellspring.DrainLever", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainHC"), lambda s: s.has_any(("Dash", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainHC"), lambda s: has_enough_resources([], [('db', 20)], "InnerWellspring.DrainAreaEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has("Double Jump", p) and has_enough_resources([], [('db', 20)], "InnerWellspring.DrainAreaEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has("Bash", p) and s.has("Clean Water", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainAreaEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "InnerWellspring.DrainAreaEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEX -> InnerWellspring.DrainHC"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEX -> InnerWellspring.DrainHC"), lambda s: s.has_all(("Double Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEX -> InnerWellspring.DrainHC"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEX -> InnerWellspring.DrainAreaExit"), lambda s: s.has_any(("Glide", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "InnerWellspring.DrainAreaEX", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Glide", p) and s.has("Grapple", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Glide", p) and has_enough_resources([], [('db', 15)], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Sword", p) and s.has("Grapple", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Sword", p) and has_enough_resources([], [('db', 15)], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Bash", p) and s.has_any(("Grapple", "Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 15)], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoom"), lambda s: s.has_all(("InnerWellspring.DrainRoomBottomWheel", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoom"), lambda s: s.has("Glide", p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoom"), lambda s: s.has("Glide", p) and has_enough_resources([], [('db', 20)], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoom"), lambda s: s.has_all(("Clean Water", "Sword"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoom"), lambda s: s.has_all(("Clean Water", "Dash"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoom"), lambda s: s.has_all(("Clean Water", "Grapple", "Hammer"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoomTopWheel"), lambda s: has_enough_resources([('wall', ('BreakWall', 16))], [], "InnerWellspring.DrainRoomCenter", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoom"), lambda s: s.has_any(("Double Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoom"), lambda s: s.has("Hammer", p) and has_enough_resources([('db', 20)], [], "InnerWellspring.DrainRoomCenter", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoom"), lambda s: s.has_all(("Hammer", "Clean Water"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.DrainRoomCenter", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoomTop"), lambda s: s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainRoomTop"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoomCenter", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.LaserOre"), lambda s: s.has_any(("Double Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.LaserOre"), lambda s: s.has("Glide", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.LaserOre"), lambda s: s.has("Glide", p) and has_enough_resources([], [('combat', 'Miner')], "InnerWellspring.DrainRoomTop", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("Double Jump", p) and has_enough_resources([], [('db', 15)], "InnerWellspring.DrainRoomTop", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("Dash", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("Dash", p) and has_enough_resources([], [('db', 15)], "InnerWellspring.DrainRoomTop", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoomTop", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has_all(("InnerWellspring.DrainRoomTopWheel", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoomTop", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.DrainLever"), lambda s: s.has("InnerWellspring.UpperCorruption", p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has("InnerWellspring.UpperCorruption", p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has_all(("InnerWellspring.UpperCorruption", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has("InnerWellspring.UpperCorruption", p) and s.has("Grapple", p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.AbovePole"), lambda s: has_enough_resources([('db', 15)], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.AbovePole"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.WestDoor"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.WestDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.DrainRoomTop"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.AbovePole -> InnerWellspring.BelowDrainLever"), lambda s: True, "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.MiddleDoorsOpen"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.MiddleDoorsOpen"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.LupoMap"), lambda s: s.has("Grapple", p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTreeEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTreeEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTreeEX"), lambda s: s.has_all(("Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTree"), lambda s: s.has_any(("Bash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.SpinArena"), lambda s: has_enough_resources([('combat', 'Lizard'), ('combat', 'Lizard'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Mantis'), ('combat', 'Miner')], [], "InnerWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.SpinningRoomOpen"), lambda s: s.has("InnerWellspring.SpinArena", p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "InnerWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.AboveSpinArenaEX"), lambda s: s.has("Grapple", p) and s.has("Sword", p), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.AboveSpinArenaEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([], [('db', 15)], "InnerWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("InnerWellspring.TopDoorOpen", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.TopSecondRoom"), lambda s: s.has("InnerWellspring.TopDoorOpen", p) and s.has_any(("Grapple", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.SpinPuzzleSolved"), lambda s: s.has("Grapple", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.PastSpinPuzzle"), lambda s: s.has_all(("InnerWellspring.SpinPuzzleSolved", "Clean Water"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.EastDoor"), lambda s: s.has_all(("InnerWellspring.SpinningRoomOpen", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Grapple", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Grapple", p) and has_enough_resources([], [('combat', 'Miner')], "InnerWellspring.PastSpinPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.SpinPuzzle"), lambda s: s.has("InnerWellspring.SpinPuzzleSolved", p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.SpinPuzzle"), lambda s: s.has("InnerWellspring.SpinPuzzleSolved", p) and has_enough_resources([], [('db', 15)], "InnerWellspring.PastSpinPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.TopSecondRoom"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("Clean Water", "Grapple"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.GrappleThroughZigZagSpikes", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("Launch", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.TopSecondRoom"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 15)], [], "InnerWellspring.GrappleThroughZigZagSpikes", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.TopSecondRoom"), lambda s: s.has_all(("Clean Water", "Water Dash", "Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.GrappleThroughZigZagSpikes -> InnerWellspring.PastSpinPuzzle"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Launch"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Glide", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Glide", p) and has_enough_resources([], [('combat', 'Miner')], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Double Jump", "Bash"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Double Jump", "Bash"), p) and has_enough_resources([], [('db', 20)], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'Miner')], [], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and has_enough_resources([('combat', 'Miner')], [('db', 20)], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Dash", "Bash"), p) and s.has("Sword", p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Dash", "Bash"), p) and has_enough_resources([], [('db', 20)], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Dash"), p) and s.has("Sword", p) and has_enough_resources([('combat', 'Miner')], [], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Grapple", "Dash"), p) and has_enough_resources([('combat', 'Miner')], [('db', 20)], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Clean Water", "Double Jump", "Bash"), p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Clean Water", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'Miner')], [], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Clean Water", "Dash", "Bash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Clean Water", "Dash"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('combat', 'Miner')], [], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Bash"), p) and s.has_any(("Dash", "Sword"), p) and has_enough_resources([('db', 20)], [], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword"), p) and has_enough_resources([('db', 20), ('combat', 'Miner')], [], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Launch", p) and s.has("Grapple", p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 20)], "InnerWellspring.TopSecondRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.TopSecondRoom -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Launch", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.BlueMoonSeed"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.AboveTpEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.EscapeSequence"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.EscapeSequence"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "InnerWellspring.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EscapeSequence -> InnerWellspring.WaterEscape"), lambda s: s.has_all(("Grapple", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EscapeSequence -> InnerWellspring.WaterEscape"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EscapeSequence -> InnerWellspring.WaterEscape"), lambda s: s.has("Launch", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("InnerWellspring.EscapeSequence -> InnerWellspring.WaterEscape"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 15)], "InnerWellspring.EscapeSequence", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.ShriekMeet -> EastHollow.SilentSwimWall"), lambda s: s.has_all(("Clean Water", "Bash"), p) and has_enough_resources([('db', 10)], [], "WoodsEntry.ShriekMeet", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.ShriekMeet -> WoodsEntry.LedgeOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsEntry.ShriekMeet -> WoodsEntry.FirstMud"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.ShriekMeet -> WoodsEntry.FirstMud"), lambda s: has_enough_resources([], [('combat', 'Tentacle'), ('db', 10)], "WoodsEntry.ShriekMeet", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.MudPitEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsEntry.FirstMud", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.BelowTeleporter"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.ShriekMeet"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.ShriekMeet"), lambda s: has_enough_resources([], [('combat', 'Tentacle'), ('db', 10)], "WoodsEntry.FirstMud", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut -> WoodsEntry.ShriekMeet"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut -> WoodsEntry.Teleporter"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.FirstMud"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.Teleporter"), lambda s: s.has_all(("Grapple", "Sword"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.Teleporter"), lambda s: s.has_all(("Grapple", "Hammer", "Bash"), p) and has_enough_resources([('db', 15)], [], "WoodsEntry.BelowTeleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.Teleporter"), lambda s: s.has("Bash", p) and s.has("Sword", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsEntry.BelowTeleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.Teleporter"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 15)], "WoodsEntry.BelowTeleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.TwoKeystoneRoom"), lambda s: s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon')], [], "WoodsEntry.BelowTeleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LedgeOre"), lambda s: s.has_all(("Glide", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LedgeOre"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LedgeOre"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsEntry.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LedgeOre"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsEntry.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsEntry.LowerKS"), lambda s: s.has_any(("Launch", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsEntry.UpperKS"), lambda s: s.has_all(("Hammer", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsEntry.UpperKS"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsEntry.TwoKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has("WoodsEntry.KeystoneDoor", p) and can_enter_area("WoodsMain", s, p, o) and has_enough_resources([('db', 10)], [], "WoodsEntry.TwoKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.TwoKeystoneRoom -> WoodsEntry.BelowTeleporter"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsEntry.KeystoneDoor"), lambda s: can_open_door("WoodsEntry.KeystoneDoor", s, p, o.spawn.value) and has_enough_resources([('db', 10)], [], "WoodsMain.AfterKuMeet", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsMain.BelowFourKeystoneRoom"), lambda s: s.has_all(("Double Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsMain.BelowFourKeystoneRoom"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsMain.BelowFourKeystoneRoom"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('combat', 'Tentacle')], [], "WoodsMain.AfterKuMeet", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsEntry.TwoKeystoneRoom"), lambda s: s.has("WoodsEntry.KeystoneDoor", p) and can_enter_area("WoodsEntry", s, p, o) and has_enough_resources([('db', 10)], [], "WoodsMain.AfterKuMeet", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.FourKeystoneRoom"), lambda s: s.has_all(("Flap", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Bash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon')], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon')], [('db', 15)], "WoodsMain.BelowFourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 20), ('energy', ('Grenade', 2))], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has("Launch", p) and has_enough_resources([('db', 20)], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "WoodsMain.BelowFourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has("Launch", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.BelowKeystonesEX"), lambda s: s.has("Glide", p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.LowerKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.LowerKS"), lambda s: s.has_all(("Glide", "Bash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.LowerKS"), lambda s: s.has_all(("Glide", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.LowerKS"), lambda s: s.has_all(("Glide", "Dash", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.FourKeystoneRoom"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.FourKeystoneRoom"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.WallOreLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.AfterKuMeet"), lambda s: s.has_all(("Glide", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.KSRoomYellowBarrierBroken"), lambda s: s.has("Flap", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.KSRoomYellowBarrierBroken"), lambda s: s.has("Flap", p) and has_enough_resources([], [('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto')], "WoodsMain.FourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.RightKS"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.RightKS"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.UpperKS"), lambda s: s.has_all(("Flap", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.UpperKS"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "WoodsMain.FourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.UpperKS"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "WoodsMain.FourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.UpperKS"), lambda s: s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 3))], [('energy', ('Grenade', 1))], "WoodsMain.FourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.LeftKS"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p) and has_enough_resources([('combat', 'Balloon'), ('db', 15)], [], "WoodsMain.FourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.LeftKS"), lambda s: s.has("Launch", p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsMain.FourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.LowerKS"), lambda s: s.has("WoodsMain.KSRoomYellowBarrierBroken", p) and s.has_any(("Double Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.LowerKS"), lambda s: s.has_all(("WoodsMain.KSRoomYellowBarrierBroken", "Hammer", "Bash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.BelowKeystonesEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.BelowKeystonesEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.BehindDoorRoofEX"), lambda s: s.has_all(("Double Jump", "Glide"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsMain.GiantSkull", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.BalloonLure"), lambda s: s.has_all(("Bash", "Sword"), p) and has_enough_resources([('combat', 'Balloon')], [], "WoodsMain.GiantSkull", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.BalloonLureBlobDestroyed"), lambda s: s.has("Launch", p) and has_enough_resources([('wall', ('BreakWall', 3))], [], "WoodsMain.BalloonLure", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.BalloonLureYellowBarrierBroken"), lambda s: s.has_all(("WoodsMain.BalloonLureBlobDestroyed", "Flap", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.BelowHiddenOre"), lambda s: s.has_all(("WoodsMain.BalloonLureBlobDestroyed", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.GiantSkull"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BalloonLure -> WoodsMain.GiantSkull"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BelowHiddenOre -> WoodsMain.HiddenOre"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Bash"), p) and has_enough_resources([('db', 15)], [], "WoodsMain.BelowHiddenOre", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowHiddenOre -> WoodsMain.PetrifiedHowl"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.AboveHowl"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.AboveHowl"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.PetrifiedHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.BrokenOwl"), lambda s: s.has("Glide", p) and has_enough_resources([('wall', ('BreakWall', 3)), ('db', 10)], [], "WoodsMain.PetrifiedHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.BrokenOwl"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('wall', ('BreakWall', 3)), ('db', 15)], [], "WoodsMain.PetrifiedHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.BrokenOwl"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.BrokenOwl"), lambda s: s.has_all(("Dash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 10)], [], "WoodsMain.PetrifiedHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.BelowHiddenOre"), lambda s: s.has_any(("Double Jump", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> WoodsMain.AboveHowl"), lambda s: s.has("Dash", p) and has_enough_resources([('db', 15)], [], "WoodsMain.BrokenOwl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> WoodsMain.AboveHowl"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> WoodsMain.TrialStart"), lambda s: s.has_any(("Bash", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialStart -> WoodsMain.MidwayTrial"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialStart -> WoodsMain.MidwayTrial"), lambda s: s.has_all(("Double Jump", "Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialStart -> WoodsMain.AboveHowl"), lambda s: s.has_all(("Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.TrialEnd"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.TrialEnd"), lambda s: s.has("Launch", p) and s.has_any(("Sword", "Hammer", "Burrow"), p) and has_enough_resources([('db', 15)], [], "WoodsMain.MidwayTrial", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.TrialEnd"), lambda s: s.has_all(("Double Jump", "Bash", "Burrow"), p) and s.has_any(("Triple Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.TrialEnd"), lambda s: s.has_all(("Double Jump", "Bash", "Burrow", "Hammer"), p) and has_enough_resources([('db', 15)], [], "WoodsMain.MidwayTrial", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.TrialEnd"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 2)), ('db', 15)], [], "WoodsMain.MidwayTrial", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.BeforeLog"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.OrangeTree"), lambda s: s.has_all(("Burrow", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.OrangeTree"), lambda s: s.has_all(("Burrow", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.AboveHowl"), lambda s: True, "or")
    add_rule(w.get_entrance("WoodsMain.MidwayTrial -> WoodsMain.TrialStart"), lambda s: s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.OverflowShard"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.MidwayTrial"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.AboveHowl"), lambda s: s.has_any(("Double Jump", "Bash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.BeforeLog"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.OrangeTree"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("WoodsMain.TrialEnd -> WoodsMain.OrangeTree"), lambda s: s.has_all(("Burrow", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BeforeLog"), lambda s: s.has("Double Jump", p) and s.has("Dash", p), "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BeforeLog"), lambda s: s.has("Double Jump", p) and has_enough_resources([], [('db', 20)], "WoodsMain.AboveHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BeforeLog"), lambda s: s.has("Bash", p) and s.has("Dash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.AboveHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BeforeLog"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "WoodsMain.AboveHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> C.WoodsMain.BeforeLog"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> C.WoodsMain.BeforeLog"), lambda s: has_enough_resources([], [('db', 20)], "WoodsMain.BeforeLog", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> WoodsMain.LogBlobDestroyed"), lambda s: has_enough_resources([('wall', ('BreakWall', 3))], [], "WoodsMain.BeforeLog", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> WoodsMain.Teleporter"), lambda s: s.has("WoodsMain.LogBlobDestroyed", p) and has_enough_resources([], [('combat', 'Balloon'), ('db', 20)], "WoodsMain.BeforeLog", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> WoodsMain.OrangeTree"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> WoodsMain.OrangeTree"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.BeforeLog", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.LogBlobDestroyed"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.LogBlobDestroyed"), lambda s: has_enough_resources([], [('energy', ('Grenade', 1)), ('energy', ('Blaze', 1)), ('energy', ('Sentry', 1))], "WoodsMain.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.AbovePit"), lambda s: s.has("Launch", p) and has_enough_resources([('db', 15)], [], "WoodsMain.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.BeforeLog"), lambda s: s.has_all(("WoodsMain.LogBlobDestroyed", "Double Jump"), p) and s.has_any(("Hammer", "Sword", "Triple Jump"), p) and has_enough_resources([('combat', 'Balloon'), ('combat', 'Balloon')], [], "WoodsMain.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.BeforeLog"), lambda s: s.has_all(("WoodsMain.LogBlobDestroyed", "Bash"), p) and s.has("Dash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.BeforeLog"), lambda s: s.has_all(("WoodsMain.LogBlobDestroyed", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('combat', 'Balloon'), ('combat', 'Balloon')], "WoodsMain.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.BeforeLog"), lambda s: s.has_all(("WoodsMain.LogBlobDestroyed", "Launch"), p), "or")
    add_rule(w.get_entrance("WoodsMain.OrangeTree -> WoodsMain.AbovePit"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("WoodsMain.OrangeTree -> WoodsMain.AbovePit"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("WoodsMain.OrangeTree -> WoodsMain.BeforeLog"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.OrangeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.Teleporter"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Launch", "Sword"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.Teleporter"), lambda s: has_enough_resources([], [('db', 15)], "WoodsMain.AbovePit", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.OrangeTree"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.OrangeTree"), lambda s: s.has("Double Jump", p) and has_enough_resources([], [('db', 15)], "WoodsMain.AbovePit", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.OrangeTree"), lambda s: s.has("Dash", p) and has_enough_resources([('db', 15)], [], "WoodsMain.AbovePit", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.FeedingGrounds"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.FeedingGrounds"), lambda s: s.has("Dash", p) and s.has_any(("Bash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsMain.FeedingGrounds"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WoodsMain.AbovePit -> WoodsShrine"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 15)], [], "WoodsMain.AbovePit", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> WoodsShrine"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 15)], [], "WoodsMain.FeedingGrounds", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has("Launch", p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has("Burrow", p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("Glide", "Double Jump", "Triple Jump"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("Glide", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Bash", "Grapple"), p) and can_enter_area("LowerWastes", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.FeedingGrounds", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Bash", "Dash"), p) and can_enter_area("LowerWastes", s, p, o) and has_enough_resources([('energy', ('Grenade', 2))], [], "WoodsMain.FeedingGrounds", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Glide", "Bash", "Dash"), p) and can_enter_area("LowerWastes", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.FeedingGrounds", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p) and can_enter_area("LowerWastes", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.FeedingGrounds", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> WoodsMain.AbovePit"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WoodsMain.FeedingGrounds", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.BelowBaurEX"), lambda s: s.has_all(("LowerReach.BearSneezed", "LowerReach.BearBridgeBroken", "Double Jump", "Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.AboveEntry"), lambda s: s.has_all(("Bash", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.AboveEntry"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.AboveEntry"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('db', 20)], [], "LowerReach.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.Lever"), lambda s: s.has_all(("LowerReach.ThawBaurFurnace", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurLowerEX"), lambda s: s.has_all(("LowerReach.ThawBaurFurnace", "Bash"), p) and s.has_any(("Dash", "Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurLowerEX"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerReach.AboveEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurUpperEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurUpperEX"), lambda s: s.has_all(("LowerReach.ThawBaurFurnace", "Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.Icefall"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("LowerReach.Lever", "Bash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("LowerReach.Lever", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("LowerReach.Lever", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: s.has("Grapple", p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('combat', 'Nest')], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 10)], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallOre"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallOre"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Grapple"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('combat', 'Nest')], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallOre"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('db', 10)], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallOre"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Clean Water", "Water Dash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallOre"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Clean Water", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Double Jump", "Triple Jump"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Double Jump", "Triple Jump"), p) and has_enough_resources([], [('db', 20)], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Double Jump", "Triple Jump", "Dash"), p) and has_enough_resources([('combat', 'Nest')], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Double Jump", "Water Dash"), p) and has_enough_resources([('db', 20)], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Double Jump", "Grapple"), p) and has_enough_resources([('db', 10)], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.IcefallEX"), lambda s: s.has_all(("LowerReach.LeftFurnace", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.AboveEntry"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.AboveDoorEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.AboveDoorEX"), lambda s: s.has_all(("LowerReach.Lever", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.LupoMap"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.LupoMap"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Bash"), p) and can_buy_map(s, p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.TPLeftEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2)), ('energy', ('Spear', 1))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.TPLeftEX"), lambda s: s.has_all(("LowerReach.Lever", "Double Jump", "Triple Jump"), p) and s.has("Hammer", p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.TPLeftEX"), lambda s: s.has_all(("LowerReach.Lever", "Double Jump", "Triple Jump"), p) and has_enough_resources([], [('energy', ('Spear', 1))], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('energy', ('Spear', 1))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1)), ('energy', ('Spear', 1))], [('db', 20)], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has_all(("Bash", "Hammer"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has_all(("Bash", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has("Bash", p) and s.has("Hammer", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [('energy', ('Spear', 1))], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has_all(("LowerReach.Lever", "Double Jump", "Triple Jump", "Bash"), p) and s.has("Hammer", p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has_all(("LowerReach.Lever", "Double Jump", "Triple Jump", "Bash"), p) and has_enough_resources([], [('energy', ('Spear', 1))], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.Entry"), lambda s: s.has("LowerReach.Lever", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.Entry"), lambda s: s.has("LowerReach.Lever", p) and has_enough_resources([], [('db', 20)], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.AboveEntry"), lambda s: s.has_all(("LowerReach.Lever", "Double Jump", "Triple Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.LupoMap"), lambda s: can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.TPLeftEX"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.TPLeftEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.TPLeftEX"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.TPLeftEX"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.HiddenOre"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Double Jump"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.CentralEnemyPaths"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.BelowTokk"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.BelowTokk"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.BelowTokk"), lambda s: s.has_all(("LowerReach.FreezeCentralFurnace", "Bash", "Double Jump"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.KeystoneRoom"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p) and can_enter_area("UpperReach", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.KeystoneRoom"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and can_enter_area("UpperReach", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.BurrowArea"), lambda s: s.has_all(("Burrow", "Double Jump", "Triple Jump"), p) and can_enter_area("UpperReach", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.BurrowArea"), lambda s: s.has_all(("Burrow", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and can_enter_area("UpperReach", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.ThawCentralFurnace"), lambda s: s.has_all(("Flap", "Bash"), p) and has_enough_resources([('combat', 'ShieldMiner')], [], "LowerReach.SecondSoup", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.MeltIceEX"), lambda s: s.has_all(("Bash", "Flap"), p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.BurrowEX"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("Dash", "Bash"), p) and s.has("Flap", p), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.CentralEnemyPaths"), lambda s: s.has_all(("Dash", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerReach.SecondSoup", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.BelowLupo"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.BelowLupoEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "LowerReach.BelowLupo", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.BelowLupoEX"), lambda s: s.has("LowerReach.ThawCentralFurnace", p) and s.has("Sword", p), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.BelowLupoEX"), lambda s: s.has("LowerReach.ThawCentralFurnace", p) and has_enough_resources([], [('db', 20)], "LowerReach.BelowLupo", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.SecondSoup"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.CentralFurnacePedestal"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> E.LowerReach.CentralFurnacePedestal"), lambda s: has_enough_resources([('combat', 'ShieldMiner')], [('energy', ('Grenade', 1)), ('energy', ('Shuriken', 1))], "LowerReach.CentralFurnacePedestal", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.BelowLupo"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.BelowLupo"), lambda s: has_enough_resources([], [('db', 20)], "LowerReach.CentralFurnacePedestal", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.WindChannel"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.WindChannel"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindBottomEX"), lambda s: s.has("LowerReach.WindLantern", p) and s.has_any(("Double Jump", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindBottomEX"), lambda s: s.has("LowerReach.WindLantern", p) and has_enough_resources([], [('db', 20)], "LowerReach.WindChannel", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindHiddenEX"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindHiddenEX"), lambda s: s.has_all(("Launch", "Double Jump"), p) and has_enough_resources([], [('db', 20)], "LowerReach.WindChannel", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindHiddenEX"), lambda s: s.has_all(("Launch", "Dash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "LowerReach.WindChannel", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.CentralFurnacePedestal"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.SoupMoki"), lambda s: s.has("Launch", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.SoupMoki"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 20)], "LowerReach.WindChannel", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> E.LowerReach.SoupMoki"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> E.LowerReach.SoupMoki"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.SoupMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.WindHiddenEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.WindHiddenEX"), lambda s: s.has("Double Jump", p) and has_enough_resources([], [('db', 20)], "LowerReach.SoupMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.WindHiddenEX"), lambda s: s.has("Glide", p) and s.has_any(("Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.WindHiddenEX"), lambda s: s.has("Glide", p) and has_enough_resources([], [('db', 20)], "LowerReach.SoupMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.WindHiddenEX"), lambda s: s.has_any(("Dash", "Sword", "Hammer", "Launch"), p) and has_enough_resources([('db', 20)], [], "LowerReach.SoupMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.WindHiddenEX"), lambda s: s.has_all(("Launch", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.WindChannel"), lambda s: s.has_any(("Double Jump", "Dash", "Launch", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.WindChannel"), lambda s: has_enough_resources([], [('db', 20)], "LowerReach.SoupMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.EastEnemyPaths"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.SoupMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.EastEnemyPaths"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "LowerReach.SoupMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.East -> LowerReach.SnowballEnemyPaths"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.TPLantern"), lambda s: has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Snowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.SnowballHC"), lambda s: s.has_all(("LowerReach.RolledSnowball", "Burrow"), p), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.EastEnemyPaths"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.Snowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.EastEnemyPaths"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.PastSnowball"), lambda s: s.has("LowerReach.RolledSnowball", p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.PastSnowball"), lambda s: s.has("LowerReach.RolledSnowball", p) and has_enough_resources([], [('db', 20)], "LowerReach.Snowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.RoofLeftEX"), lambda s: s.has_all(("LowerReach.FreezeEastFurnace", "Bash", "Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerReach.PastSnowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.RoofLeftEX"), lambda s: s.has_all(("Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.SnowballEnemyPaths"), lambda s: s.has_all(("LowerReach.RolledSnowball", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.RoofRightEX"), lambda s: s.has_all(("LowerReach.FreezeEastFurnace", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: s.has_all(("Double Jump", "Hammer"), p) and has_enough_resources([('db', 20)], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: s.has_all(("LowerReach.FreezeEastFurnace", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: s.has_all(("LowerReach.FreezeEastFurnace", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.EastDoorLantern"), lambda s: s.has("Double Jump", p) and s.has_any(("Sword", "Hammer", "Glide", "Dash", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.HalfwayIceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.SwimmingPool"), lambda s: s.has_any(("Glide", "Double Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.SwimmingPool"), lambda s: has_enough_resources([], [('db', 20)], "LowerReach.HalfwayIceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.IceCavern"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.IceCavern"), lambda s: s.has_all(("LowerReach.FreezeEastFurnace", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.HalfwayIceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.IceCavern"), lambda s: s.has_all(("LowerReach.FreezeEastFurnace", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "LowerReach.HalfwayIceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.ArenaArea"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.ArenaArea"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "LowerReach.ThawEastFurnace", "Water Dash", "Clean Water", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.EastFurnace"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.EastFurnace"), lambda s: s.has_all(("LowerReach.ThawEastFurnace", "Water Dash", "Double Jump", "Clean Water"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.EastFurnace"), lambda s: s.has_all(("LowerReach.ThawEastFurnace", "Water Dash", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "LowerReach.SwimmingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.WindSpinners"), lambda s: s.has_all(("LowerReach.ArenaBeaten", "Launch"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.WindSpinners"), lambda s: s.has_all(("LowerReach.ArenaBeaten", "Launch"), p) and has_enough_resources([], [('db', 20)], "LowerReach.ArenaArea", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.SwimmingPool"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "Double Jump", "Triple Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.SwimmingPool"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.SwimmingPool"), lambda s: s.has("LowerReach.EastDoorLantern", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('db', 20)], [], "LowerReach.ArenaArea", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.SwimmingPool"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "Water Dash", "Hammer"), p) and has_enough_resources([('db', 20)], [], "LowerReach.ArenaArea", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.ArenaArea -> LowerReach.SwimmingPool"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindSpinners -> LowerReach.WispPathCheckpoint"), lambda s: s.has_all(("Glide", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.WindSpinners", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WindSpinners -> LowerReach.WispPathCheckpoint"), lambda s: s.has_all(("Glide", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindSpinners -> LowerReach.WispPathCheckpoint"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.WindSpinners -> LowerReach.WispPathCheckpoint"), lambda s: s.has_all(("Launch", "Double Jump"), p) and has_enough_resources([], [('db', 20)], "LowerReach.WindSpinners", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WindSpinners -> LowerReach.ArenaArea"), lambda s: s.has("LowerReach.ArenaBeaten", p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> H.LowerReach.WispPathCheckpoint"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> E.LowerReach.WispPathCheckpoint"), lambda s: s.has("Grapple", p) and s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> E.LowerReach.WispPathCheckpoint"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> LowerReach.BridgeWispPath"), lambda s: s.has("Launch", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> LowerReach.BridgeWispPath"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 20)], "LowerReach.WispPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> LowerReach.WindSpinners"), lambda s: s.has("Launch", p) and has_enough_resources([('db', 20)], [], "LowerReach.WispPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.SnowEscape"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.SnowEscape"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.SnowEscape"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.BridgeWispPath", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.WispPathCheckpoint"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.ForestsMemory"), lambda s: s.has("Launch", p) and s.has_any(("Clean Water", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.ForestsMemory"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 20)], "LowerReach.SnowEscape", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.ForestsMemory"), lambda s: s.has_all(("Dash", "Glide", "Double Jump"), p) and s.has("Triple Jump", p), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.ForestsMemory"), lambda s: s.has_all(("Dash", "Glide", "Double Jump"), p) and has_enough_resources([], [('db', 20)], "LowerReach.SnowEscape", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.ForestsMemory"), lambda s: s.has_all(("Dash", "Glide", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.BearSneezed"), lambda s: s.has("Launch", p) and s.has_any(("Clean Water", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.BearSneezed"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 20)], "LowerReach.SnowEscape", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.BearSneezed"), lambda s: s.has_all(("Dash", "Glide", "Double Jump"), p) and s.has("Triple Jump", p), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.BearSneezed"), lambda s: s.has_all(("Dash", "Glide", "Double Jump"), p) and has_enough_resources([], [('db', 20)], "LowerReach.SnowEscape", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SnowEscape -> LowerReach.BearSneezed"), lambda s: s.has_all(("Dash", "Glide", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> GladesTown.HoleHut"), lambda s: can_enter_area("GladesTown", s, p, o), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> LowerReach.TownEntry"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Glide", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerReach.TownEntry -> LowerReach.TrialStart"), lambda s: s.has_all(("Launch", "Double Jump"), p) and has_enough_resources([('db', 20)], [], "LowerReach.TownEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.TownEntry -> LowerReach.TrialStart"), lambda s: s.has_all(("Launch", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.TownEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.RightKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.RightKS"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.TrialStart", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.TownEntry"), lambda s: s.has_any(("Sword", "Dash", "Double Jump", "Launch"), p) and has_enough_resources([('db', 20)], [], "LowerReach.TrialStart", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.TownEntry"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Dash", "Double Jump", "Launch"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerReach.TrialStart", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.TownEntry"), lambda s: s.has("Launch", p) and s.has_any(("Sword", "Hammer", "Dash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.TownEntry"), lambda s: s.has("Double Jump", p) and s.has_any(("Sword", "Hammer", "Dash", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.TownEntry"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.BurrowArea -> UpperReach.LifeForceEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperReach.BurrowArea -> UpperReach.LifeForceEX"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.BurrowArea -> UpperReach.LifeForceEX"), lambda s: s.has_all(("Burrow", "Double Jump", "Triple Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.BurrowArea -> UpperReach.LifeForceShard"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperReach.BurrowArea -> UpperReach.LifeForceShard"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.BurrowArea -> UpperReach.LifeForceShard"), lambda s: s.has_all(("Burrow", "Double Jump", "Triple Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.ThawFurnace"), lambda s: s.has_all(("Flap", "Bash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.LowerKS"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Water Dash"), p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has_any(("Clean Water", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([], [('db', 20)], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Dash", "Grapple", "Glide"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('combat', 'ShieldMiner')], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Dash", "Grapple", "Glide", "Bash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Dash", "Grapple", "Glide", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Clean Water", "Dash", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('combat', 'ShieldMiner')], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Clean Water", "Dash", "Grapple", "Bash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Clean Water", "Water Dash", "Dash", "Grapple", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Clean Water", "Water Dash", "Dash", "Grapple", "Glide", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Dash", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 20), ('combat', 'ShieldMiner')], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Dash", "Grapple", "Bash"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has("Clean Water", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Clean Water", "Bash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([], [('db', 20)], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Clean Water", "Water Dash", "Glide"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Clean Water", "Water Dash", "Grapple", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Water Dash", "Glide"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Water Dash", "Grapple", "Sword"), p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoupFrozen"), lambda s: s.has("UpperReach.FreezeFurnace", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Clean Water", "Water Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Water Dash"), p) and s.has_any(("Double Jump", "Bash"), p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Water Dash"), p) and has_enough_resources([('db', 20)], [('combat', 'ShieldMiner')], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Double Jump"), p) and s.has("Triple Jump", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Double Jump"), p) and has_enough_resources([], [('db', 20)], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Double Jump", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has("UpperReach.ThawFurnace", p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'ShieldMiner'), ('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash"), p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Grapple", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Grapple", "Dash", "Glide"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Grapple", "Dash", "Glide"), p) and has_enough_resources([], [('combat', 'ShieldMiner')], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Grapple"), p) and s.has("Bash", p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Grapple"), p) and has_enough_resources([('db', 20)], [('combat', 'ShieldMiner')], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlant"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Water Dash", "Glide"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Water Dash", "Glide"), p) and has_enough_resources([], [('db', 20)], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Clean Water", "Water Dash", "Grapple"), p) and s.has_any(("Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Clean Water", "Water Dash", "Grapple"), p) and has_enough_resources([], [('db', 20)], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Water Dash", "Grapple"), p) and s.has_any(("Dash", "Sword"), p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Grapple"), p) and s.has_any(("Dash", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlant -> UpperReach.UpperSoup"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlant -> UpperReach.UpperSoup"), lambda s: s.has("Double Jump", p) and has_enough_resources([], [('db', 20)], "UpperReach.KeystoneSnapPlant", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlant -> UpperReach.UpperSoup"), lambda s: s.has("Dash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlant -> UpperReach.UpperSoup"), lambda s: s.has("Dash", p) and has_enough_resources([], [('db', 20)], "UpperReach.KeystoneSnapPlant", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlant -> UpperReach.UpperSoup"), lambda s: s.has("Sword", p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneSnapPlant", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawed -> UpperReach.UpperSoupThawed"), lambda s: s.has("Sword", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawed -> UpperReach.UpperSoupThawed"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawed -> UpperReach.UpperSoupThawed"), lambda s: s.has("Double Jump", p) and has_enough_resources([], [('db', 20)], "UpperReach.KeystoneSnapPlantThawed", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawed -> UpperReach.UpperSoupThawed"), lambda s: s.has("Dash", p) and s.has("Hammer", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawed -> UpperReach.UpperSoupThawed"), lambda s: s.has("Dash", p) and has_enough_resources([], [('db', 20)], "UpperReach.KeystoneSnapPlantThawed", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantPaths -> UpperReach.LowerKS"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantPaths -> UpperReach.KeystoneRoom"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantPaths -> UpperReach.KeystoneRoom"), lambda s: has_enough_resources([], [('db', 20)], "UpperReach.KeystoneSnapPlantPaths", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawedPaths -> UpperReach.LowerKS"), lambda s: s.has("Sword", p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawedPaths -> UpperReach.LowerKS"), lambda s: s.has("Dash", p) and s.has_any(("Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawedPaths -> UpperReach.LowerKS"), lambda s: s.has("Dash", p) and has_enough_resources([], [('db', 10)], "UpperReach.KeystoneSnapPlantThawedPaths", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawedPaths -> UpperReach.LowerKS"), lambda s: s.has("Hammer", p) and s.has_any(("Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawedPaths -> UpperReach.LowerKS"), lambda s: s.has("Hammer", p) and has_enough_resources([], [('db', 10)], "UpperReach.KeystoneSnapPlantThawedPaths", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawedPaths -> UpperReach.LowerKS"), lambda s: s.has_all(("Dash", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneSnapPlantThawedPaths -> UpperReach.LowerKS"), lambda s: s.has("Grapple", p) and has_enough_resources([('db', 20)], [], "UpperReach.KeystoneSnapPlantThawedPaths", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.LowerKS"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.UpperKS"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.SwingPoleEX"), lambda s: s.has_any(("Bash", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.KeystoneSnapPlant"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 20)], [], "UpperReach.UpperSoupPaths", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> UpperReach.LowerKS"), lambda s: s.has("Sword", p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> UpperReach.LowerKS"), lambda s: s.has_all(("Dash", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> UpperReach.MiddleRightKS"), lambda s: s.has_any(("Bash", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> E.UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "BreakCrystal", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> E.UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "BreakCrystal", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> E.UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Clean Water", "BreakCrystal"), p) and s.has_any(("Bow", "Spear"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> E.UpperReach.OutsideTreeRoom"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Clean Water", "Grapple", "BreakCrystal"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> UpperReach.UpperSoupThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> UpperReach.UpperSoupThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> UpperReach.UpperSoupThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.OutsideTreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.OutsideTreeRoom -> UpperReach.UpperSoupThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "UpperReach.OutsideTreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeOre"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.TreeRoomLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeOre"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.TreeRoomLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeOre"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.TreeRoomLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeOre"), lambda s: s.has("Launch", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeOre"), lambda s: s.has_all(("Launch", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.TreeRoomLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.TreeOre"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.TreeRoomLedge"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperReach.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> UpperDepths.EntrySpikesEX"), lambda s: has_enough_resources([('db', 10)], [], "UpperDepths.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> UpperDepths.FirstFirefly"), lambda s: s.has("Glide", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> UpperDepths.FirstFirefly"), lambda s: s.has("Glide", p) and has_enough_resources([], [('combat', 'Bat')], "UpperDepths.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> UpperDepths.FirstFirefly"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('combat', 'BombSlug'), ('combat', 'BombSlug'), ('db', 30)], [], "UpperDepths.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> EastHollow.AboveDepths"), lambda s: s.has_all(("EastHollow.DepthsOpen", "Launch"), p) and s.has("Double Jump", p) and can_enter_area("EastHollow", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> EastHollow.AboveDepths"), lambda s: s.has_all(("EastHollow.DepthsOpen", "Launch"), p) and can_enter_area("EastHollow", s, p, o) and has_enough_resources([], [('db', 10)], "UpperDepths.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryRoofEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryRoofEX"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryOre"), lambda s: s.has_all(("Grapple", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryOre"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: s.has("Grapple", p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: has_enough_resources([], [('energy', ('Bow', 1)), ('energy', ('Spear', 1))], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.Entry"), lambda s: s.has_all(("Glide", "Bash"), p) and has_enough_resources([], [('combat', 'BombSlug'), ('db', 10)], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.Entry"), lambda s: s.has("Glide", p) and has_enough_resources([('combat', 'BombSlug'), ('combat', 'Bat')], [], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.Entry"), lambda s: s.has("Glide", p) and has_enough_resources([('combat', 'Bat'), ('db', 10)], [], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.Entry"), lambda s: s.has_all(("Launch", "Double Jump", "Triple Jump", "Dash", "Bash"), p) and has_enough_resources([('db', 30)], [], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.LeftEntryKS"), lambda s: s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.SwimEC"), lambda s: s.has("Clean Water", p) and s.has("UpperDepths.ForestsEyes", p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.SwimEC"), lambda s: s.has("Clean Water", p) and has_enough_resources([], [('energy', ('Flash', 1))], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has("Grapple", p) and s.has("Double Jump", p) and has_enough_resources([('combat', 'WeakSlug')], [], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has("Grapple", p) and has_enough_resources([('combat', 'WeakSlug')], [('db', 30)], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has_all(("Grapple", "Bash"), p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has_all(("Grapple", "Bash"), p) and has_enough_resources([], [('db', 30)], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 30)], [], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.KeydoorLedge"), lambda s: s.has("Grapple", p) and s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.KeydoorLedge"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.KeydoorLedge"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.RightKeystonePath"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.LightPuzzle"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Double Jump", "Grapple"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('wall', ('BreakWall', 16)), ('combat', 'Spiderling'), ('combat', 'SneezeSlug')], [], "UpperDepths.KeydoorLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.LightPuzzle"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('wall', ('BreakWall', 16))], [], "UpperDepths.KeydoorLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.LightPuzzle"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Glide", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('wall', ('BreakWall', 16)), ('db', 30)], [], "UpperDepths.KeydoorLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.LightPuzzle"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('wall', ('BreakWall', 16)), ('energy', ('Grenade', 2)), ('combat', 'Spiderling'), ('combat', 'SneezeSlug')], [], "UpperDepths.KeydoorLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.LightPuzzle"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 16)), ('wall', ('BreakWall', 16))], [], "UpperDepths.KeydoorLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.FirstKSRoom"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.FirstKSRoom"), lambda s: has_enough_resources([], [('db', 30)], "UpperDepths.KeydoorLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.RightKeystonePath"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.RightKeystonePath"), lambda s: s.has_all(("Grapple", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "UpperDepths.LightPuzzle", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has("UpperDepths.EntryKeystoneDoor", p) and s.has_any(("UpperDepths.LightPuzzle", "DepthsLight"), p) and has_enough_resources([('db', 30)], [], "UpperDepths.KeydoorLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "DepthsLight"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('combat', 'Bat')], [], "UpperDepths.KeydoorLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.KeydoorLedge -> UpperDepths.BelowHive"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "UpperDepths.LightPuzzle"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('combat', 'Bat')], [], "UpperDepths.KeydoorLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.RightEntryKS"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.RightEntryKS"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.RightEntryKS"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.RightEntryKS"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.RightKeystonePath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.FirstKSRoom"), lambda s: s.has("Grapple", p) and s.has("Dash", p), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.FirstKSRoom"), lambda s: s.has("Grapple", p) and has_enough_resources([], [('db', 30)], "UpperDepths.RightKeystonePath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.FirstKSRoom"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has("Grapple", p) and s.has_any(("Bow", "Spear", "Shuriken", "Grenade"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Bow", "Spear", "Shuriken", "Grenade"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 30)], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.EntryKeystoneDoor"), lambda s: s.has("DepthsLight", p) and can_open_door("UpperDepths.EntryKeystoneDoor", s, p, o.spawn.value) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.EntryKeystoneDoor"), lambda s: s.has("DepthsLight", p) and can_open_door("UpperDepths.EntryKeystoneDoor", s, p, o.spawn.value) and has_enough_resources([], [('db', 30)], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.EntryKeystoneDoor"), lambda s: s.has_all(("Dash", "Launch"), p) and can_open_door("UpperDepths.EntryKeystoneDoor", s, p, o.spawn.value), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.HiveEX"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and has_enough_resources([('combat', 'Nest')], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.KeydoorLedge"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "DepthsLight"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.KeydoorLedge"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "DepthsLight"), p) and has_enough_resources([], [('db', 30)], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.KeydoorLedge"), lambda s: s.has_all(("UpperDepths.EntryKeystoneDoor", "Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.Teleporter"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.Teleporter"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 30)], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.Central"), lambda s: s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.LowerConnection"), lambda s: s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.BelowHive"), lambda s: s.has_any(("Shuriken", "Grenade"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.BelowHive"), lambda s: s.has("Dash", p) and s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.BelowHive"), lambda s: s.has("Dash", p) and has_enough_resources([], [('db', 30)], "UpperDepths.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.Central"), lambda s: s.has_any(("Bow", "Spear", "Shuriken", "Grenade"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.SecondKSRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash", "Double Jump"), p) and s.has("Triple Jump", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 10)], "UpperDepths.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.RightHealthKS"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has_all(("Dash", "Glide"), p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has_all(("Dash", "Glide"), p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has("Sword", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.KeystoneHC"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.KeystoneHC"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.KeystoneHC"), lambda s: s.has_all(("Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.BossPathEX"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.Central"), lambda s: s.has_any(("DepthsLight", "Dash", "Bash", "Glide", "Launch", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.Central"), lambda s: has_enough_resources([], [('wall', ('BreakWall', 1)), ('db', 10)], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.MoraPath"), lambda s: s.has_all(("DepthsLight", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.MoraPath"), lambda s: s.has_all(("DepthsLight", "Dash"), p) and has_enough_resources([('db', 30)], [], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.MoraPath"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 30)], [], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.MoraPath"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([], [('db', 30)], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('combat', 'Spiderling'), ('combat', 'Spiderling'), ('combat', 'Spiderling')], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and has_enough_resources([('combat', 'Spiderling'), ('combat', 'Spiderling'), ('combat', 'Spiderling')], [('db', 30)], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has_all(("Double Jump", "Dash", "Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Grapple", "Dash"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('db', 30)], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Grapple", "Bash"), p) and s.has_any(("Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 3))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash", "Grapple"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [('db', 30)], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1))], [('db', 30)], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('combat', 'Spiderling'), ('combat', 'Spiderling'), ('combat', 'Spiderling')], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('combat', 'Spiderling'), ('combat', 'Spiderling'), ('combat', 'Spiderling')], [('db', 30)], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.OutsideMoraFight -> UpperDepths.Teleporter"), lambda s: s.has_any(("Dash", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "UpperDepths.OutsideMoraFight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.OutsideMoraFight -> UpperDepths.MoraPath"), lambda s: True, "or")
    add_rule(w.get_entrance("MoraEscape -> MoraSecondPhase"), lambda s: s.has_all(("Bash", "Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("MoraEscape -> MoraSecondPhase"), lambda s: s.has_all(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("MoraEscape -> MoraSecondPhase"), lambda s: s.has_all(("Launch", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.BelowDoorOre"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Sword", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Hammer", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Hammer", p) and has_enough_resources([], [('db', 30)], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Dash", p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Dash", p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("Double Jump", p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: has_enough_resources([('wall', ('BreakWall', 1))], [('db', 30)], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("DepthsLight", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.LeftEX"), lambda s: s.has("DepthsLight", p) and has_enough_resources([], [('db', 30)], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Grapple", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 10)], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 2)), ('db', 10)], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 3)), ('db', 10)], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has("Sword", p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has("Dash", p) and s.has("DepthsLight", p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has("Dash", p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has("Double Jump", p) and s.has("DepthsLight", p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has("Double Jump", p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: s.has("DepthsLight", p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('db', 30)], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.West"), lambda s: can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('db', 30)], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("Dash", "Glide"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has_any(("Triple Jump", "Glide", "Sword"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("Double Jump", "Dash"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 1))], [('db', 30)], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has("Launch", p) and s.has_any(("Dash", "Bash", "Sword", "Hammer"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 1))], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has("Launch", p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 1))], [('db', 30)], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Glide"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Sword"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('db', 30)], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Dash", "Hammer"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Dash", "Sword"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Launch"), p) and s.has_any(("Sword", "Hammer"), p) and can_enter_area("LowerDepths", s, p, o), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Launch"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([], [('db', 30)], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> H.LowerDepths.West"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> H.LowerDepths.West"), lambda s: s.has("Dash", p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> H.LowerDepths.West"), lambda s: s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> H.LowerDepths.West"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> E.LowerDepths.West"), lambda s: s.has_all(("BreakCrystal", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> E.LowerDepths.West"), lambda s: s.has_all(("BreakCrystal", "Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> E.LowerDepths.West"), lambda s: s.has("BreakCrystal", p) and s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> E.LowerDepths.West"), lambda s: s.has_all(("BreakCrystal", "Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.SwimEC"), lambda s: s.has("Clean Water", p) and s.has_any(("UpperDepths.ForestsEyes", "Flash"), p) and has_enough_resources([('db', 10)], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.LeftEX"), lambda s: s.has("DepthsLight", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.LeftEX"), lambda s: s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has_all(("Clean Water", "Double Jump", "Triple Jump"), p) and s.has_any(("UpperDepths.ForestsEyes", "Flash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has_all(("Clean Water", "Bash", "Dash"), p) and s.has_any(("UpperDepths.ForestsEyes", "Flash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has_all(("Clean Water", "Bash", "Flash"), p) and s.has_any(("Double Jump", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has_all(("Clean Water", "Bash", "UpperDepths.ForestsEyes"), p) and s.has_any(("Double Jump", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> UpperDepths.LowerConnection"), lambda s: s.has_all(("DepthsLight", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('db', 10)], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> UpperDepths.LowerConnection"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword"), p) and can_enter_area("UpperDepths", s, p, o), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has_any(("Triple Jump", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1)), ('combat', 'Bat')], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Bash"), p) and s.has_any(("Triple Jump", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Glide"), p) and has_enough_resources([('combat', 'Bat')], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Dash"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('combat', 'Bat'), ('db', 30)], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Glide", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 10)], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.RaceStartHC"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerDepths.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.RaceStartHC"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.East"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.East"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.East"), lambda s: s.has("Launch", p) and has_enough_resources([('db', 30)], [], "LowerDepths.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.East"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.East"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> UpperDepths.LowerConnection"), lambda s: s.has_all(("DepthsLight", "Launch"), p) and can_enter_area("UpperDepths", s, p, o), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> UpperDepths.LowerConnection"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Bash", "Glide", "Sword", "Hammer"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('combat', 'WeakSlug')], [], "LowerDepths.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> UpperDepths.LowerConnection"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('combat', 'WeakSlug')], [('db', 30)], "LowerDepths.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> E.LowerDepths.East"), lambda s: s.has("BreakCrystal", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> E.LowerDepths.East"), lambda s: s.has_all(("BreakCrystal", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has_all(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has_all(("Launch", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and s.has_any(("Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump", "Dash"), p) and s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump", "Dash"), p) and has_enough_resources([], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has_all(("DepthsLight", "Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has_all(("DepthsLight", "Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.SpiritSurgeShard"), lambda s: s.has_all(("DepthsLight", "Bash", "Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 30)], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has_all(("Grapple", "Sword"), p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has("Launch", p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and can_buy_map(s, p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Dash"), p) and can_buy_map(s, p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.LupoMap"), lambda s: s.has("DepthsLight", p) and can_buy_map(s, p) and s.has_any(("Double Jump", "Dash", "Grapple", "Sword", "Hammer"), p) and has_enough_resources([('db', 30)], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Bash", "Grapple", "Dash"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Bash", "Grapple"), p) and s.has_any(("Glide", "Sword"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20)), ('db', 30)], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Glide", "Sword"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1)), ('db', 30)], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Bash", "Double Jump", "Triple Jump"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Grapple"), p) and s.has("DepthsLight", p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Grapple"), p) and has_enough_resources([], [('wall', ('BreakWall', 1))], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Double Jump", "DepthsLight"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Bash", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Double Jump", "DepthsLight"), p) and has_enough_resources([], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Bash", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Double Jump"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Dash", "DepthsLight"), p) and s.has_any(("Glide", "Bash", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Dash", "DepthsLight"), p) and has_enough_resources([], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Dash"), p) and s.has_any(("Glide", "Bash", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Glide", "DepthsLight"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Glide", "DepthsLight"), p) and has_enough_resources([], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Glide"), p) and s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Launch", "DepthsLight"), p) and s.has_any(("Bash", "Sword"), p) and has_enough_resources([('db', 30)], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has("Launch", p) and s.has_any(("Bash", "Sword"), p) and has_enough_resources([('db', 30), ('wall', ('BreakWall', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.BeforeTree"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Grapple"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Bash", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Double Jump"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Dash"), p) and s.has_any(("Glide", "Bash", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Glide"), p) and s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.TreeArea"), lambda s: s.has_all(("Launch", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [('db', 30)], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.TreeArea"), lambda s: s.has("Launch", p) and s.has_any(("Bash", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 1)), ('db', 30)], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.Central"), lambda s: s.has_all(("Bash", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.Central"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerDepths.East -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 30)], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TrialActivation"), lambda s: s.has_all(("Double Jump", "Bash", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([], [('db', 30)], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has_all(("Double Jump", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([], [('db', 30)], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("Sword", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 30)], [], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("Bash", p) and s.has("Sword", p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("Bash", p) and has_enough_resources([], [('db', 30)], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has_all(("Bash", "Grapple", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has_all(("Sword", "Grapple"), p) and s.has("UpperDepths.ForestsEyes", p), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has_all(("Sword", "Grapple"), p) and has_enough_resources([], [('energy', ('Flash', 1))], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("Hammer", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 30), ('energy', ('Flash', 1))], [], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has_all(("Hammer", "UpperDepths.ForestsEyes"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 30)], [], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has_any(("Double Jump", "Dash", "Sword"), p) and has_enough_resources([('db', 30), ('energy', ('Flash', 1))], [], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.East"), lambda s: s.has("UpperDepths.ForestsEyes", p) and s.has_any(("Double Jump", "Dash", "Sword"), p) and has_enough_resources([('db', 30)], [], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TreeArea"), lambda s: s.has_all(("Bash", "Grapple", "Double Jump"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TreeArea"), lambda s: s.has_all(("Bash", "Grapple", "Dash"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TreeArea"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump", "Dash"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 1))], [], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.BeforeTree -> LowerDepths.TreeArea"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('wall', ('BreakWall', 1)), ('db', 30)], [], "LowerDepths.BeforeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.TreeArea -> LowerDepths.RightEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerDepths.TreeArea", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.TreeArea -> LowerDepths.BeforeTree"), lambda s: s.has("DepthsLight", p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Grapple", "Double Jump"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([], [('db', 15)], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Grapple", "Dash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Grapple", "Dash"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([], [('db', 15)], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Grapple", "Glide"), p) and s.has("Sword", p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Grapple", "Glide"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([], [('db', 15)], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Grapple", "Sword"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('db', 15)], [], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Bash", "Launch"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Launch"), p) and s.has("Sword", p) and can_enter_area("WestGlades", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> WestGlades.MillApproach"), lambda s: s.has_all(("Clean Water", "Launch"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([], [('db', 15)], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> PoolsApproach.MillPath"), lambda s: s.has("Grapple", p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto')], [], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> PoolsApproach.MillPath"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> PoolsApproach.MillPath"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> PoolsApproach.MillPath"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathEX"), lambda s: s.has("Bash", p) and s.has_any(("Clean Water", "Glide"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Grapple", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'SpinCrab'), ('combat', 'CorruptSlug')], [], "PoolsApproach.MillPath", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "PoolsApproach.MillPath", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [('db', 20)], "PoolsApproach.MillPath", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has("Grapple", p) and s.has("Double Jump", p) and has_enough_resources([('combat', 'Crab'), ('combat', 'SmallSkeeto')], [], "PoolsApproach.MillPath", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto')], [('combat', 'CorruptSlug')], "PoolsApproach.MillPath", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water"), p) and s.has_any(("PoolsApproach.WheelFreed", "Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Bash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MarshBreakableWall", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Bash", "Double Jump"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MarshBreakableWall", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Launch"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Grapple"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MarshBreakableWall", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MarshBreakableWall", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Launch"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MarshBreakableWall", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Launch", "Double Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Launch", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.MarshBreakableWall -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Clean Water", "Grapple", "Water Dash", "Hammer"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.MarshBreakableWall", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> C.PoolsApproach.OnTopOfWheel"), lambda s: s.has("Clean Water", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathECWall"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathECWall"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water"), p) and has_enough_resources([], [('db', 10)], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.AboveWheelEX"), lambda s: s.has_all(("Double Jump", "Hammer", "Dash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.AboveWheelEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "PoolsApproach.WheelFreed"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.AboveWheelEX"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.AboveWheelEX"), lambda s: s.has_all(("PoolsApproach.WheelFreed", "Double Jump"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathEC"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "PoolsApproach.MillPathECWall", "Clean Water"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathEC"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "PoolsApproach.MillPathECWall", "Clean Water"), p) and has_enough_resources([], [('db', 10)], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Water Dash", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Bash", "Double Jump", "Triple Jump"), p) and s.has("Grapple", p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([], [('db', 20)], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Bash", "Double Jump", "Triple Jump", "Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Bash", "Double Jump", "Triple Jump", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Launch"), p) and s.has_any(("Double Jump", "Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Launch", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Launch", "Dash"), p) and has_enough_resources([], [('db', 20)], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPathHC"), lambda s: s.has_all(("Clean Water", "Launch"), p) and s.has_any(("Water Dash", "Bash"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Water Dash", "Grapple"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Bash", "Grapple", "Dash", "Sword"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Bash", "Grapple", "Glide"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Bash", "Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Bash", "Grapple", "Double Jump", "Hammer"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Bash", "Double Jump", "Dash"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Launch"), p) and s.has_any(("Double Jump", "Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Launch", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Launch", "Dash"), p) and has_enough_resources([], [('db', 20)], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MarshBreakableWall"), lambda s: s.has_all(("Clean Water", "Launch"), p) and s.has_any(("Water Dash", "Bash"), p) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Glide", "Double Jump", "Hammer", "Dash"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Glide", "Double Jump", "Triple Jump"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Dash", "Sword"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Launch", "Hammer"), p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Launch", "Dash", "Sword"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("PoolsApproach.WheelFreed", "Glide", "Dash"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("PoolsApproach.WheelFreed", "Glide"), p) and s.has_any(("Sword", "Hammer"), p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump"), p) and s.has("Triple Jump", p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump"), p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([], [('db', 20)], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has_all(("Water Dash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer", "Water Dash"), p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([('db', 20)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPath"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPath"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Launch"), p) and has_enough_resources([('db', 10)], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPath"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Water Dash"), p) and s.has_any(("Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.MillPath"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water", "Water Dash"), p) and has_enough_resources([], [('combat', 'SpinCrab')], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'CorruptSlug')], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has("Double Jump", p) and has_enough_resources([('combat', 'CorruptSlug')], [('db', 20)], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([], [('db', 20)], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has("Double Jump", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 10)], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has("Dash", p) and s.has("Bash", p) and has_enough_resources([('db', 20)], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.EntryLever"), lambda s: s.has("Dash", p) and has_enough_resources([('db', 20)], [('combat', 'CorruptSlug')], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.RightOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.RightOre"), lambda s: s.has_all(("Double Jump", "Grapple", "Flap"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'CorruptSlug')], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.RightOre"), lambda s: s.has_all(("Double Jump", "Grapple", "Flap"), p) and has_enough_resources([('combat', 'CorruptSlug')], [('db', 20)], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.RightOre"), lambda s: s.has_all(("Double Jump", "Grapple", "Flap", "Bash"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.RightOre"), lambda s: s.has_all(("Double Jump", "Grapple", "Flap", "Bash"), p) and has_enough_resources([], [('db', 20)], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.BelowLeverEX"), lambda s: s.has("EastPools.BelowEntryLeverBubble", p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> EastPools.BelowLeverEX"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has("Clean Water", p) and s.has("Hammer", p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('db', 20)], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Bash", "Launch"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Bash", "Double Jump"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Glide", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Glide", "Double Jump"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([], [('db', 20)], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Water Dash", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('db', 20)], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Launch", "Dash"), p) and s.has_any(("Sword", "Hammer"), p) and can_enter_area("PoolsApproach", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.AboveDoorOre"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Grapple", "Flap"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TokkBubble"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TokkBubble"), lambda s: has_enough_resources([], [('db', 20)], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [('db', 20)], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 3))], [], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.LeverRoom"), lambda s: s.has_all(("EastPools.EntryLever", "Clean Water"), p) and has_enough_resources([('db', 10)], [], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.AboveDoorOre"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Grapple", "Flap"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.AboveDoorOre"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2)), ('db', 20)], [], "EastPools.TokkBubble", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TPArea"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "EastPools.TokkBubble", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TPArea"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Flap", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('combat', 'Crab')], [], "EastPools.TokkBubble", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TPArea"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Flap", "Grapple"), p) and has_enough_resources([('combat', 'Crab')], [('db', 20)], "EastPools.TokkBubble", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TPArea"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Flap", "Bash", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.TPArea"), lambda s: s.has_all(("EastPools.TokkBubbleFree", "EastPools.TokkBubblePurpleWall", "Flap", "Bash", "Grapple"), p) and has_enough_resources([], [('db', 20)], "EastPools.TokkBubble", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.BehindEntryDoor"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.BehindEntryDoor"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'CorruptSlug'), ('combat', 'Crab')], [], "EastPools.TokkBubble", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.LowerWaterDrained"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.AboveDoorOre"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "EastPools.TPArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.AboveDoorOre"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "EastPools.TPArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.FishingPool"), lambda s: s.has("Grapple", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.FishingPool"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.TPArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.FishingPool"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.BehindEntryDoor"), lambda s: has_enough_resources([('db', 20)], [], "EastPools.TPArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.BehindEntryDoor"), lambda s: s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Spear', 1))], [], "EastPools.TPArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.BehindEntryDoor"), lambda s: s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.TPArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.TokkBubble"), lambda s: True, "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> EastPools.UltraBashWall"), lambda s: s.has_all(("EastPools.LowerWaterDrained", "Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> EastPools.WaterdashArena"), lambda s: s.has_all(("EastPools.ArenaWall", "EastPools.LowerWaterDrained"), p) and s.has("Sword", p), "or")
    add_rule(w.get_entrance("EastPools.Teleporter -> EastPools.WaterdashArena"), lambda s: s.has_all(("EastPools.ArenaWall", "EastPools.LowerWaterDrained"), p) and has_enough_resources([], [('db', 20)], "EastPools.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Water Dash", "Double Jump"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Water Dash", "Double Jump"), p) and has_enough_resources([], [('db', 20)], "EastPools.FishingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Water Dash", "Dash", "Sword"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Water Dash", "Dash", "Sword"), p) and has_enough_resources([], [('db', 20)], "EastPools.FishingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.FishingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.AboveFishingPool -> UpperPools.DrainPuzzleExit"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Bash"), p) and can_enter_area("UpperPools", s, p, o) and has_enough_resources([('energy', ('Grenade', 2))], [], "EastPools.AboveFishingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LupoArea -> EastPools.LupoEX"), lambda s: s.has("Hammer", p), "or")
    add_rule(w.get_entrance("EastPools.LupoArea -> EastPools.LupoEX"), lambda s: s.has_all(("EastPools.LupoPurpleFloor", "Water Dash"), p) and has_enough_resources([('db', 20)], [], "EastPools.LupoArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.FightArenas"), lambda s: s.has_all(("Regenerate", "Clean Water", "Bash"), p) and has_enough_resources([('db', 20), ('combat', 'Crab'), ('combat', 'Crab'), ('combat', 'Crab'), ('combat', 'Crab'), ('combat', 'Tentacle'), ('combat', 'Skeeto'), ('combat', 'Skeeto')], [], "EastPools.WaterdashArena", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.FightRoomHC"), lambda s: s.has_all(("EastPools.FightArenas", "Water Dash"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.FightRoomHC"), lambda s: s.has_all(("EastPools.FightArenas", "Water Dash"), p) and has_enough_resources([], [('db', 20)], "EastPools.WaterdashArena", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.FightRoomHC"), lambda s: s.has_all(("EastPools.FightArenas", "Water Dash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.Teleporter"), lambda s: s.has_all(("EastPools.ArenaWall", "EastPools.LowerWaterDrained"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.Teleporter"), lambda s: s.has_all(("EastPools.ArenaWall", "EastPools.LowerWaterDrained"), p) and has_enough_resources([], [('db', 20)], "EastPools.WaterdashArena", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.MissilePuzzle"), lambda s: s.has("EastPools.FightArenas", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("EastPools.WaterdashArena -> EastPools.MissilePuzzle"), lambda s: s.has("EastPools.FightArenas", p) and has_enough_resources([], [('db', 20)], "EastPools.WaterdashArena", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.CentralRoomPurpleWall"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.LupoPurpleFloor"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.EnergyHarvestShard"), lambda s: s.has_all(("Water Dash", "Double Jump"), p) and has_enough_resources([('db', 20)], [], "EastPools.MissilePuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.EnergyHarvestShard"), lambda s: s.has_all(("Clean Water", "Bash"), p) and s.has_any(("Double Jump", "Water Dash"), p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.BehindCrusherEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.WaterdashArena"), lambda s: s.has("EastPools.FightArenas", p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has("Water Dash", p) and has_enough_resources([('db', 20)], [], "EastPools.CentralRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.CentralRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has_all(("Bash", "Dash"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> EastPools.GrassSeed"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_all(("EastPools.CentralRoomBubbleFree", "Double Jump", "Triple Jump", "Dash", "Glide"), p) and can_enter_area("UpperPools", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_all(("EastPools.CentralRoomBubbleFree", "Double Jump", "Triple Jump", "Bash"), p) and can_enter_area("UpperPools", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_all(("EastPools.CentralRoomBubbleFree", "Bash", "Double Jump"), p) and can_enter_area("UpperPools", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "EastPools.CentralRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide", "EastPools.CentralRoomBubbleFree"), p) and can_enter_area("UpperPools", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> WestPools.Teleporter"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Launch", "Sword", "Hammer"), p) and can_enter_area("WestPools", s, p, o), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> WestPools.Teleporter"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and can_enter_area("WestPools", s, p, o) and has_enough_resources([], [('db', 20)], "EastPools.CentralRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.GrassSeed"), lambda s: s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.GrassSeed"), lambda s: has_enough_resources([], [('db', 10)], "UpperPools.KeystoneRoomEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> UpperPools.LowerKS"), lambda s: s.has_all(("Clean Water", "Bash", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.CentralRoom"), lambda s: s.has_any(("Dash", "Glide"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> EastPools.CentralRoom"), lambda s: can_enter_area("EastPools", s, p, o) and has_enough_resources([], [('db', 10)], "UpperPools.KeystoneRoomEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> UpperPools.KeystoneRoomBubbleSpawner"), lambda s: has_enough_resources([('db', 20)], [], "UpperPools.KeystoneRoomEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> UpperPools.KeystoneRoomBubbleSpawner"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Sword", "UpperPools.KeystoneRoomBubbleFree"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> UpperPools.KeystoneRoomBubbleSpawner"), lambda s: s.has("Dash", p) and s.has_any(("Glide", "Sword", "UpperPools.KeystoneRoomBubbleFree"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomEntrance -> UpperPools.KeystoneRoomBubbleSpawner"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.UpperLeftKS"), lambda s: s.has_all(("UpperPools.KeystoneRoomBubbleFree", "Flap"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.KeystoneRoom"), lambda s: s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.KeystoneRoom"), lambda s: s.has_all(("Clean Water", "Water Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has_all(("UpperPools.KeystoneRoomBubbleFree", "Flap", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("UpperPools.KeystoneRoomBubbleFree", "Flap", "Grapple"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoomBubbleSpawner -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_any(("Bash", "Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "UpperPools.KeystoneRoomBubbleSpawner", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperLeftKS"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperLeftKS"), lambda s: s.has_all(("Water Dash", "Double Jump", "Triple Jump"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperLeftKS"), lambda s: s.has_all(("Water Dash", "Double Jump", "Triple Jump"), p) and has_enough_resources([], [('db', 20)], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperMidKS"), lambda s: s.has_all(("Double Jump", "Water Dash"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperMidKS"), lambda s: s.has_all(("Double Jump", "Water Dash"), p) and has_enough_resources([], [('db', 20)], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperMidKS"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperMidKS"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has("Bash", p) and s.has("Sword", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has("Water Dash", p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has("Water Dash", p) and has_enough_resources([], [('db', 20)], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has_all(("Grapple", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has_all(("Grapple", "Hammer"), p) and s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has_all(("Grapple", "Hammer"), p) and has_enough_resources([], [('db', 20)], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Grapple", p) and s.has_any(("Sword", "Clean Water"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Grapple", p) and has_enough_resources([], [('db', 20)], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has_all(("Grapple", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has_all(("Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has_all(("Bash", "Water Dash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Bash", p) and s.has("Sword", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [('db', 20)], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> H.UpperPools.BeforeKeystoneDoor"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.TrialActivation"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.UpperMidKS"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.UpperMidKS"), lambda s: has_enough_resources([], [('db', 20)], "UpperPools.BeforeKeystoneDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.UpperLeftKS"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.KeystoneRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.BeforeKeystoneDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("Bash", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "UpperPools.BeforeKeystoneDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.BeforeKeystoneDoor -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> UpperPools.TreeRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> UpperPools.AboveTree"), lambda s: s.has_all(("UpperPools.TreeRoomLeftBubbleFree", "Flap", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> UpperPools.AboveTree"), lambda s: s.has_all(("UpperPools.TreeRoomLeftBubbleFree", "Flap", "Glide"), p) and has_enough_resources([('db', 20)], [], "UpperPools.TreeRoomEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoomEntrance -> UpperPools.AboveTree"), lambda s: s.has_all(("UpperPools.TreeRoomLeftBubbleFree", "Double Jump", "Triple Jump", "Dash"), p) and has_enough_resources([('db', 20)], [], "UpperPools.TreeRoomEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.AboveTree"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "UpperPools.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.AboveTree"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.TreeRoomEntrance"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.TreeRoomEntrance"), lambda s: s.has("Water Dash", p) and has_enough_resources([('db', 20)], [], "UpperPools.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.TreeRoomEntrance"), lambda s: s.has("UpperPools.TreeRoomLeftBubbleFree", p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.ButtonDoorAboveTree", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.ButtonDoorAboveTree", "UpperPools.TreeRoomRightBubbleFree", "Clean Water", "Water Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.ButtonDoorAboveTree", "UpperPools.TreeRoomRightBubbleFree", "Water Dash"), p) and s.has_any(("Double Jump", "Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "UpperPools.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.TreeRoom -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.ButtonDoorAboveTree", "UpperPools.TreeRoomRightBubbleFree", "Bash"), p) and s.has_any(("Double Jump", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.AboveTree -> UpperPools.RoofEX"), lambda s: s.has("Water Dash", p) and has_enough_resources([('db', 20)], [], "UpperPools.AboveTree", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.AboveTree -> UpperPools.TreeRoomEntrance"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.UpperWaterDrained"), lambda s: s.has_all(("Clean Water", "Water Dash", "Grapple"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.UpperWaterDrained"), lambda s: s.has_all(("Clean Water", "Grapple", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.UpperWaterDrained"), lambda s: s.has_all(("Clean Water", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 20)], [], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.UpperWaterDrained"), lambda s: s.has_all(("Clean Water", "Water Dash", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.UpperWaterDrained"), lambda s: s.has_all(("Clean Water", "Water Dash", "Launch"), p) and has_enough_resources([], [('db', 20)], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.WaterfallEC"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and s.has_any(("Triple Jump", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.WaterfallEC"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.WaterfallEC"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Dash", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Double Jump", "Grapple"), p) and s.has_any(("Triple Jump", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleExit"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Bash", "Grapple"), p) and s.has("Clean Water", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleExit"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Bash", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 20)], "UpperPools.DrainPuzzleEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleEntrance -> UpperPools.DrainPuzzleExit"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "UpperPools.DrainRoomPurpleWall"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainRoomPurpleWall"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainRoomPurpleWall"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Bash", "Launch"), p) and has_enough_resources([('db', 20)], [], "UpperPools.DrainPuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.UpperWaterDrained"), lambda s: s.has_all(("Clean Water", "Launch", "UpperPools.DrainRoomPurpleWall"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleExit"), lambda s: s.has("UpperPools.UpperWaterDrained", p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has("Launch", p) and s.has("Glide", p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 20)], "UpperPools.DrainPuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Launch", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "UpperPools.DrainPuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Double Jump"), p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "UpperPools.DrainPuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Double Jump", "UpperPools.UpperWaterDrained"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Double Jump", "Clean Water"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Dash", "Sword"), p) and s.has_any(("Clean Water", "UpperPools.UpperWaterDrained"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Dash", "Sword"), p) and has_enough_resources([], [('db', 20)], "UpperPools.DrainPuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Dash", "Glide"), p) and s.has_any(("Clean Water", "UpperPools.UpperWaterDrained"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleRight -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Dash", "Glide"), p) and has_enough_resources([], [('db', 20)], "UpperPools.DrainPuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> UpperPools.DrainRoomPurpleWall"), lambda s: s.has_all(("Clean Water", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> EastPools.PurpleWallHC"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Clean Water", "Bash"), p) and s.has_any(("Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> EastPools.PurpleWallHC"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Clean Water", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "UpperPools.DrainPuzzleExit", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> EastPools.PurpleWallHC"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Clean Water", "Bash", "Double Jump", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> UpperPools.DrainPuzzleRight"), lambda s: s.has("Launch", p) and s.has_any(("UpperPools.UpperWaterDrained", "Clean Water"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("UpperPools.UpperWaterDrained", "Clean Water"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleExit", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> UpperPools.DrainPuzzleRight"), lambda s: s.has_all(("Clean Water", "Bash", "Double Jump"), p) and s.has_any(("Water Dash", "Triple Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Bash", "Dash", "UpperPools.UpperWaterDrained"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleExit", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.DrainPuzzleExit -> UpperPools.DrainPuzzleEntrance"), lambda s: s.has_all(("UpperPools.DrainRoomPurpleWall", "Bash", "Dash", "Clean Water"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperPools.DrainPuzzleExit", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BubbleSpamLever"), lambda s: s.has_any(("Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BubbleSpamLever"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p) and has_enough_resources([('combat', 'Bee'), ('combat', 'Skeeto')], [], "UpperPools.RightBubbleSpamRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BubbleSpamLever"), lambda s: s.has("Double Jump", p) and has_enough_resources([('combat', 'Bee'), ('combat', 'Skeeto')], [('db', 20)], "UpperPools.RightBubbleSpamRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.FishPoolEX"), lambda s: s.has("Clean Water", p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.FishPoolOre"), lambda s: s.has_all(("Double Jump", "Bash"), p) and s.has_any(("Triple Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.BubblesEC"), lambda s: s.has("UpperPools.BubbleSpamLever", p), "or")
    add_rule(w.get_entrance("UpperPools.RightBubbleSpamRoom -> UpperPools.LeftBubbleSpamRoom"), lambda s: True, "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.BubbleSpamWall"), lambda s: s.has_all(("Clean Water", "Bash"), p) and s.has_any(("Double Jump", "Glide", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.BubbleSpamWall"), lambda s: s.has_all(("Clean Water", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "UpperPools.LeftBubbleSpamRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("Clean Water", "Bash"), p) and s.has_any(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("Clean Water", "Bash"), p) and has_enough_resources([], [('energy', ('Grenade', 1))], "UpperPools.LeftBubbleSpamRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.LeftBubbleSpamRoom -> UpperPools.RightBubbleSpamRoom"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump"), p) and s.has_any(("Triple Jump", "Hammer"), p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.TpEX"), lambda s: s.has_all(("Clean Water", "Water Dash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.TpEX"), lambda s: s.has_all(("Water Dash", "Double Jump"), p) and s.has_any(("Dash", "Triple Jump"), p) and has_enough_resources([('db', 20)], [], "WestPools.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.BurrowOre"), lambda s: s.has_all(("WestPools.ForestsStrength", "Clean Water", "Water Dash", "Burrow"), p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.LeftKwolokPlatform"), lambda s: s.has_all(("Clean Water", "Water Dash"), p), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.LeftKwolokPlatform"), lambda s: s.has("Clean Water", p) and s.has("Bash", p) and has_enough_resources([('combat', 'SpinCrab')], [], "WestPools.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> WestPools.LeftKwolokPlatform"), lambda s: s.has("Clean Water", p) and has_enough_resources([('combat', 'SpinCrab')], [('db', 3)], "WestPools.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WestPools.Teleporter -> EastPools.CentralRoom"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and can_enter_area("EastPools", s, p, o), "or")
    add_rule(w.get_entrance("WestPools.LeftKwolokPlatform -> WestPools.Teleporter"), lambda s: s.has("Clean Water", p) and s.has_any(("Bash", "Water Dash"), p), "or")
    add_rule(w.get_entrance("WestPools.LeftKwolokPlatform -> WestPools.Teleporter"), lambda s: s.has("Clean Water", p) and has_enough_resources([], [('db', 3)], "WestPools.LeftKwolokPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("WestPools.LeftKwolokPlatform -> WestPools.RightKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("WestPools.LeftKwolokPlatform -> WestPools.RightKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p) and has_enough_resources([], [('db', 10)], "WestPools.LeftKwolokPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("WestPools.RightKwolokPlatform -> WestPools.LeftKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("WestPools.RightKwolokPlatform -> WestPools.LeftKwolokPlatform"), lambda s: s.has("WestPools.ForestsStrength", p) and has_enough_resources([], [('db', 10)], "WestPools.RightKwolokPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("WestPools.RightKwolokPlatform -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and can_enter_area("UpperPools", s, p, o), "or")
    add_rule(w.get_entrance("KwolokEscape -> KwolokFight"), lambda s: s.has_all(("Clean Water", "Water Dash", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("KwolokEscape -> KwolokFight"), lambda s: s.has_all(("Clean Water", "Water Dash", "Launch"), p), "or")
    add_rule(w.get_entrance("KwolokEscape -> KwolokFight"), lambda s: s.has_all(("Clean Water", "Launch", "Dash", "Bash"), p), "or")
    add_rule(w.get_entrance("KwolokFight -> WestPools.ForestsStrength"), lambda s: s.has_all(("Regenerate", "Clean Water", "Water Dash", "Bash"), p) and s.has_any(("Double Jump", "Launch", "Dash"), p) and has_enough_resources([('wall', ('Boss', 250)), ('db', 85)], [], "KwolokFight", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WoodsMain.FeedingGroundsEX"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> LowerWastes.SunsetView"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 30)], [], "LowerWastes.WestTP", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> LowerWastes.SunsetView"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> LowerWastes.SunsetView"), lambda s: s.has_all(("Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> LowerWastes.SunsetView"), lambda s: s.has_all(("Grapple", "Sword"), p) and has_enough_resources([('db', 30)], [], "LowerWastes.WestTP", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WoodsMain.FeedingGrounds"), lambda s: s.has("Burrow", p) and can_enter_area("WoodsMain", s, p, o), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "WindtornRuins.Seir", "Grapple", "Glide"), p) and can_enter_area("WeepingRidge", s, p, o), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "WindtornRuins.Seir", "Double Jump", "Triple Jump", "Glide"), p) and can_enter_area("WeepingRidge", s, p, o), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "WindtornRuins.Seir", "Bash", "Dash", "Glide"), p) and can_enter_area("WeepingRidge", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WestTP", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "Launch"), p) and s.has("WindtornRuins.Seir", p) and can_enter_area("WeepingRidge", s, p, o), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "Bash", "Grapple"), p) and s.has("WindtornRuins.Seir", p) and can_enter_area("WeepingRidge", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WestTP", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump", "Triple Jump"), p) and s.has("WindtornRuins.Seir", p) and can_enter_area("WeepingRidge", s, p, o) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WestTP", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.WestTP -> WeepingRidge.Bottom"), lambda s: s.has_all(("Burrow", "Bash", "Dash"), p) and s.has("WindtornRuins.Seir", p) and can_enter_area("WeepingRidge", s, p, o) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerWastes.WestTP", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.SpiritTrial"), lambda s: s.has_all(("LowerWastes.TrialActivation", "Burrow", "Dash", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.WestTP"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.WestTP"), lambda s: has_enough_resources([], [('db', 30)], "LowerWastes.SunsetView", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.Shovel"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("LowerWastes.SunsetView -> LowerWastes.Shovel"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.SunsetView", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.Shovel -> LowerWastes.SunsetView"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.Shovel"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.Shovel"), lambda s: has_enough_resources([], [('db', 30)], "LowerWastes.MuncherTunnel", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.Shovel"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherTunnel -> LowerWastes.SandPot"), lambda s: s.has_any(("Double Jump", "Dash", "Burrow", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotHC"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotHC"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Dash"), p) and s.has_any(("Double Jump", "Grapple"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Double Jump"), p) and has_enough_resources([('db', 30)], [], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Grapple"), p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('db', 30)], [], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.MuncherTunnel"), lambda s: True, "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has_all(("Burrow", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 30)], [], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 30)], [], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Sword", "Hammer"), p) and has_enough_resources([('db', 30), ('energy', ('Grenade', 1))], [], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has_all(("Bash", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 30)], [], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has_all(("Bash", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 30)], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SandPot -> LowerWastes.WoodenBridge"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [('db', 30)], "LowerWastes.SandPot", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Double Jump"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Double Jump"), p) and has_enough_resources([], [('db', 30)], "LowerWastes.WoodenBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPotEX"), lambda s: s.has_all(("Burrow", "Grapple"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.MuncherPitEX"), lambda s: s.has_any(("Burrow", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPot"), lambda s: s.has("Grapple", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPot"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.SandPot"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 30)], [], "LowerWastes.WoodenBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.LeverArea"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("LowerWastes.WoodenBridge -> LowerWastes.LeverArea"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.WoodenBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.MinesEntranceEnemyPaths"), lambda s: s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('combat', 'MaceMiner'), ('combat', 'Mantis')], [], "LowerWastes.BeforeMinesEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.MinesEntranceEnemyPaths"), lambda s: has_enough_resources([('combat', 'MaceMiner'), ('combat', 'Mantis')], [('db', 30)], "LowerWastes.BeforeMinesEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.MinesEntranceEnemyPaths"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.MinesEntranceEnemyPaths"), lambda s: s.has("Bash", p) and has_enough_resources([], [('db', 30)], "LowerWastes.BeforeMinesEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.WoodenBridge"), lambda s: s.has("Double Jump", p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerWastes.BeforeMinesEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.LeverArea"), lambda s: s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("LowerWastes.BeforeMinesEntrance -> LowerWastes.LeverArea"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightEX"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightEX"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerWastes.MinesEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightEX"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightHC"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 30)], [], "LowerWastes.MinesEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightHC"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 30), ('combat', 'MaceMiner'), ('combat', 'Mantis')], [], "LowerWastes.MinesEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightHC"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightHC"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BottomRightHC"), lambda s: s.has("Grapple", p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BeforeMinesEntrance"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BeforeMinesEntrance"), lambda s: s.has_all(("Grapple", "Dash"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BeforeMinesEntrance"), lambda s: s.has_all(("Grapple", "Dash"), p) and has_enough_resources([], [('combat', 'MaceMiner'), ('combat', 'Mantis')], "LowerWastes.MinesEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.MinesEntrance -> LowerWastes.BeforeMinesEntrance"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.SandPlatformLever"), lambda s: s.has("Dash", p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.SandPlatformLever"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.LeverArea", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.MuncherClimb"), lambda s: s.has_all(("LowerWastes.SandPlatformLever", "Double Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.MuncherClimb"), lambda s: s.has_all(("LowerWastes.SandPlatformLever", "Burrow"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.LastStandArea"), lambda s: s.has_all(("LowerWastes.SandPlatformLever", "Burrow"), p) and s.has_any(("Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LeverArea -> LowerWastes.LastStandArea"), lambda s: s.has_all(("LowerWastes.SandPlatformLever", "Bash"), p) and s.has_any(("Glide", "Burrow", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "LowerWastes.LeverArea", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.MuncherClimbEX"), lambda s: s.has_all(("Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.MuncherClimbEX"), lambda s: s.has_all(("Launch", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.MuncherClimbEX"), lambda s: s.has("Launch", p) and has_enough_resources([('db', 30)], [], "LowerWastes.MuncherClimb", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.LastStandArea"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.LastStandArea"), lambda s: s.has_all(("LowerWastes.SandPlatformLever", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.SkeetoHive"), lambda s: s.has("Grapple", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.MuncherClimb -> LowerWastes.SkeetoHive"), lambda s: s.has_all(("Launch", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LastStandArea -> LowerWastes.LastStandShard"), lambda s: s.has_any(("Launch", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LastStandArea -> LowerWastes.LastStandEX"), lambda s: s.has_all(("Burrow", "Glide"), p), "or")
    add_rule(w.get_entrance("LowerWastes.LastStandArea -> LowerWastes.LastStandEX"), lambda s: s.has("Burrow", p) and s.has_any(("Dash", "Sword"), p) and has_enough_resources([('db', 30)], [], "LowerWastes.LastStandArea", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.LastStandArea -> LowerWastes.MuncherClimb"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.SkeetoHiveEX"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.ThirstyGorlek"), lambda s: s.has("Bash", p) and s.has("Grapple", p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.ThirstyGorlek"), lambda s: s.has("Bash", p) and has_enough_resources([], [('energy', ('Grenade', 1))], "LowerWastes.SkeetoHive", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.UpperPath"), lambda s: s.has_all(("Burrow", "Bash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.UpperPath"), lambda s: s.has_all(("Burrow", "Grapple", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.MuncherClimb"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.MuncherClimb"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("LowerWastes.SkeetoHive -> LowerWastes.MuncherClimb"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 30)], "LowerWastes.SkeetoHive", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.ThirstyGorlek -> LowerWastes.LupoMap"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Hammer"), p) and can_buy_map(s, p), "or")
    add_rule(w.get_entrance("LowerWastes.UpperPath -> LowerWastes.UpperPathEX"), lambda s: s.has("Burrow", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.UpperPath -> LowerWastes.UpperPathEX"), lambda s: s.has("Burrow", p) and has_enough_resources([], [('db', 30)], "LowerWastes.UpperPath", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.EastTPOre"), lambda s: s.has("Double Jump", p) and has_enough_resources([('wall', ('BreakWall', 20))], [], "LowerWastes.EastTP", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.EastTPOre"), lambda s: s.has("Bash", p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('Grenade', 1))], [], "LowerWastes.EastTP", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> Tokk"), lambda s: s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.UpperPath"), lambda s: s.has("Burrow", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> LowerWastes.UpperPath"), lambda s: s.has("Burrow", p) and has_enough_resources([], [('db', 30)], "LowerWastes.EastTP", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> UpperWastes.KeystoneRoom"), lambda s: s.has("Burrow", p) and s.has_any(("Glide", "Sword"), p) and can_enter_area("UpperWastes", s, p, o), "or")
    add_rule(w.get_entrance("LowerWastes.EastTP -> UpperWastes.KeystoneRoom"), lambda s: s.has("Burrow", p) and can_enter_area("UpperWastes", s, p, o) and has_enough_resources([], [('db', 30)], "LowerWastes.EastTP", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KeystoneDoor"), lambda s: s.has("Burrow", p) and can_open_door("UpperWastes.KeystoneDoor", s, p, o.spawn.value) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KeystoneDoor"), lambda s: s.has_all(("Bash", "Burrow"), p) and can_open_door("UpperWastes.KeystoneDoor", s, p, o.spawn.value) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperWastes.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.LowerKS"), lambda s: s.has_any(("Burrow", "Launch"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.LowerKS"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.UpperKS"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.TurmoilShard"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump"), p) and s.has_any(("Dash", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.TurmoilShard"), lambda s: s.has_all(("Burrow", "Launch", "Double Jump"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.TurmoilShard"), lambda s: s.has_all(("Burrow", "Launch"), p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 30)], [], "UpperWastes.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KSDoorEX"), lambda s: s.has("Burrow", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.KSDoorEX"), lambda s: s.has("Bash", p) and has_enough_resources([('combat', 'ShieldSlug'), ('energy', ('Grenade', 1))], [], "UpperWastes.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> LowerWastes.EastTP"), lambda s: s.has("Burrow", p) and s.has_any(("Sword", "Hammer"), p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> LowerWastes.EastTP"), lambda s: s.has("Burrow", p) and can_enter_area("LowerWastes", s, p, o) and has_enough_resources([], [('db', 30)], "UpperWastes.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.MissilePuzzleLeft"), lambda s: s.has_all(("UpperWastes.KeystoneDoor", "Burrow"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperWastes.KeystoneRoom -> UpperWastes.MissilePuzzleLeft"), lambda s: s.has_all(("UpperWastes.KeystoneDoor", "Burrow", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperWastes.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> UpperWastes.LedgeEC"), lambda s: s.has_all(("Burrow", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleLeft -> UpperWastes.LedgeEC"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperWastes.MissilePuzzleLeft", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleMiddle -> C.UpperWastes.MissilePuzzleMiddle"), lambda s: s.has("Burrow", p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleMiddle -> C.UpperWastes.MissilePuzzleMiddle"), lambda s: s.has("Burrow", p) and has_enough_resources([], [('db', 14)], "UpperWastes.MissilePuzzleMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleMiddle -> UpperWastes.LeverDoor"), lambda s: s.has("Burrow", p) and has_enough_resources([('db', 14)], [], "UpperWastes.MissilePuzzleMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleMiddle -> UpperWastes.PurpleWallEX"), lambda s: s.has("Burrow", p) and s.has("Dash", p) and has_enough_resources([('combat', 'MaceMiner')], [], "UpperWastes.MissilePuzzleMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleMiddle -> UpperWastes.PurpleWallEX"), lambda s: s.has("Burrow", p) and has_enough_resources([('combat', 'MaceMiner')], [('db', 14)], "UpperWastes.MissilePuzzleMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleMiddle -> UpperWastes.MissilePuzzleLeft"), lambda s: s.has_all(("Burrow", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.SpinLasers"), lambda s: s.has_all(("Burrow", "Dash"), p) and s.has("Bash", p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.SpinLasers"), lambda s: s.has_all(("Burrow", "Dash"), p) and has_enough_resources([], [('db', 30)], "UpperWastes.MissilePuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.SpinLasers"), lambda s: s.has_all(("Burrow", "Glide"), p) and s.has_any(("Double Jump", "Bash"), p), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.SpinLasers"), lambda s: s.has_all(("Burrow", "Glide"), p) and has_enough_resources([], [('db', 30)], "UpperWastes.MissilePuzzleRight", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.MissilePuzzleRight -> UpperWastes.SpinLasers"), lambda s: s.has_all(("Burrow", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.RoofEX"), lambda s: s.has_all(("Double Jump", "Burrow"), p) and s.has_any(("Triple Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.RoofEX"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.RoofEX"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Sword", "Hammer"), p) and has_enough_resources([('db', 30)], [], "UpperWastes.SpinLasers", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.MissilePuzzleRight"), lambda s: s.has_all(("Burrow", "Dash"), p) and has_enough_resources([('db', 30)], [], "UpperWastes.SpinLasers", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.SpinLasers -> UpperWastes.RuinsApproach"), lambda s: s.has("Burrow", p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.FlowersSeed"), lambda s: s.has_all(("Burrow", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.FlowersSeed"), lambda s: s.has_all(("Burrow", "Bash", "Dash"), p) and has_enough_resources([], [('energy', ('Grenade', 1)), ('db', 30)], "UpperWastes.NorthTP", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.FlowersSeed"), lambda s: s.has_all(("Burrow", "Double Jump", "Triple Jump"), p) and s.has("Dash", p) and has_enough_resources([('db', 30)], [], "UpperWastes.NorthTP", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump", "Dash", "Sword"), p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Burrow", "Bash", "Double Jump"), p) and has_enough_resources([], [('energy', ('Grenade', 1)), ('db', 30)], "UpperWastes.NorthTP", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Burrow", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperWastes.NorthTP", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 30)], "UpperWastes.NorthTP", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "UpperWastes.NorthTP", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Launch", "Double Jump"), p) and has_enough_resources([('combat', 'MaceMiner')], [], "UpperWastes.NorthTP", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("UpperWastes.NorthTP -> UpperWastes.OutsideRuins"), lambda s: s.has("Launch", p) and s.has_any(("Bash", "Burrow"), p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has_all(("Burrow", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has_all(("Burrow", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has_all(("Double Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has_any(("Dash", "Glide", "Sword"), p) and has_enough_resources([('db', 30)], [], "UpperWastes.OutsideRuins", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "UpperWastes.OutsideRuins", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.WallOre"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.NorthTP"), lambda s: s.has("Glide", p), "or")
    add_rule(w.get_entrance("UpperWastes.OutsideRuins -> UpperWastes.NorthTP"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('combat', 'Mantis'), ('combat', 'MaceMiner')], [], "UpperWastes.OutsideRuins", s, p, o, False), "or")
    add_rule(w.get_entrance("WindtornRuins.BrokenMural -> WindtornRuins.RuinsTP"), lambda s: s.has("Burrow", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.BrokenMural -> WindtornRuins.RuinsTP"), lambda s: s.has("WindtornRuins.HeartBarrier", p) and s.has_any(("Glide", "Dash"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.BrokenMural -> WindtornRuins.RuinsTP"), lambda s: s.has_all(("WindtornRuins.HeartBarrier", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.HeartBarrier"), lambda s: s.has("Burrow", p) and has_enough_resources([('wall', ('BreakWall', 16))], [], "WindtornRuins.FallenPillar", s, p, o, False), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.RuinsTP"), lambda s: s.has_all(("Burrow", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WindtornRuins.FallenPillar", s, p, o, False), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.RuinsTP"), lambda s: s.has_all(("Burrow", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [('db', 40)], "WindtornRuins.FallenPillar", s, p, o, False), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.LowerRuins"), lambda s: s.has("WindtornRuins.Seir", p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.FallenPillar -> WindtornRuins.BrokenMural"), lambda s: s.has("Bash", p) and s.has_any(("Burrow", "WindtornRuins.HeartBarrier"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WindtornRuins.FallenPillar", s, p, o, False), "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> WindtornRuins.BrokenMural"), lambda s: s.has("Glide", p) and s.has_any(("Burrow", "WindtornRuins.HeartBarrier"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("Sword", "WindtornRuins.HeartBarrier"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("Sword", "Burrow"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.RuinsTP -> WindtornRuins.BrokenMural"), lambda s: s.has_all(("Double Jump", "Dash", "Hammer"), p) and s.has_any(("Burrow", "WindtornRuins.HeartBarrier"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.Escape -> WindtornRuins.Seir"), lambda s: s.has_all(("WindtornRuins.HeartBarrier", "Burrow", "Grapple", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 40)], [], "WindtornRuins.Escape", s, p, o, False), "or")
    add_rule(w.get_entrance("WindtornRuins.Escape -> WindtornRuins.Seir"), lambda s: s.has_all(("WindtornRuins.HeartBarrier", "Burrow", "Grapple", "Dash"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 40)], [], "WindtornRuins.Escape", s, p, o, False), "or")
    add_rule(w.get_entrance("WindtornRuins.Escape -> WindtornRuins.Seir"), lambda s: s.has_all(("WindtornRuins.HeartBarrier", "Burrow", "Launch"), p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WindtornRuins.Escape -> WindtornRuins.Seir"), lambda s: s.has_all(("WindtornRuins.HeartBarrier", "Burrow", "Launch"), p) and has_enough_resources([], [('db', 40)], "WindtornRuins.Escape", s, p, o, False), "or")
    add_rule(w.get_entrance("WindtornRuins.LowerRuins -> WindtornRuins.FallenPillar"), lambda s: s.has_all(("WindtornRuins.Seir", "Double Jump"), p) and s.has_any(("Triple Jump", "Sword"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> WeepingRidge.ElevatorFightCompleted"), lambda s: s.has("Double Jump", p) and has_enough_resources([('combat', 'CrystalMiner'), ('combat', 'CrystalMiner'), ('combat', 'ShieldCrystalMiner'), ('combat', 'ShieldCrystalMiner')], [], "WeepingRidge.Bottom", s, p, o, False), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> WeepingRidge.LaunchArea"), lambda s: s.has("WeepingRidge.ElevatorFightCompleted", p) and s.has("Double Jump", p), "or")
    add_rule(w.get_entrance("WeepingRidge.Bottom -> LowerWastes.WestTP"), lambda s: s.has("Burrow", p) and can_enter_area("LowerWastes", s, p, o), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.Ore"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.Ore"), lambda s: s.has_all(("Launch", "Sword"), p) and has_enough_resources([('db', 20)], [], "WeepingRidge.LaunchArea", s, p, o, False), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.AboveTree"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Bow', 1))], [], "WeepingRidge.LaunchArea", s, p, o, False), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.AboveTree"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WeepingRidge.LaunchArea", s, p, o, False), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.AboveTree"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('Bow', 1)), ('db', 40)], [], "WeepingRidge.LaunchArea", s, p, o, False), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.AboveTree"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.AboveTree"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('energy', ('Bow', 1))], [], "WeepingRidge.LaunchArea", s, p, o, False), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.AboveTree"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Sword", "Hammer", "Dash"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.WillowEntranceLedge"), lambda s: s.has_all(("WeepingRidge.ElevatorFightCompleted", "Launch"), p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.LaunchArea -> WeepingRidge.Bottom"), lambda s: s.has_all(("WeepingRidge.ElevatorFightCompleted", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.SpikeClimbEX"), lambda s: s.has("Launch", p) and has_enough_resources([], [('energy', ('Bow', 1)), ('energy', ('Spear', 1)), ('energy', ('Grenade', 1)), ('db', 20)], "WeepingRidge.AboveTree", s, p, o, False), "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.SpikeClimbEX"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 2)), ('db', 40)], [], "WeepingRidge.AboveTree", s, p, o, False), "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.Ore"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.LaunchArea"), lambda s: s.has_all(("Launch", "Bash"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.AboveTree -> WeepingRidge.LaunchArea"), lambda s: s.has_all(("Launch", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WeepingRidge.WillowEntranceLedge -> WeepingRidge.LaunchArea"), lambda s: s.has("WeepingRidge.ElevatorFightCompleted", p) and s.has("Glide", p), "or")
    add_rule(w.get_entrance("WeepingRidge.WillowEntranceLedge -> WeepingRidge.LaunchArea"), lambda s: s.has("WeepingRidge.ElevatorFightCompleted", p) and has_enough_resources([], [('db', 20)], "WeepingRidge.WillowEntranceLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.EntryEX"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.EntryEX"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.InnerTP"), lambda s: s.has_all(("Launch", "Bash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.InnerTP"), lambda s: s.has_all(("Launch", "Bash"), p) and has_enough_resources([], [('db', 40)], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.InnerTP"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and s.has("WillowsEnd.PortalShortcut", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.InnerTP"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 2))], [('db', 40)], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.InnerTP"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 3))], [], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.BoulderHeartPath"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.BoulderHeartPath"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.BoulderHeartPath"), lambda s: s.has("Bash", p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 40)], [], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.GrappleHeartMidPoint"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Bash", "Sword"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Bash", "Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Entry -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 3))], [], "WillowsEnd.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeartMidPoint -> WillowsEnd.GrappleHeart"), lambda s: s.has("Launch", p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeartMidPoint -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("Launch", "Double Jump"), p) and s.has("Sword", p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeartMidPoint -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("Launch", "Double Jump"), p) and has_enough_resources([], [('db', 40)], "WillowsEnd.GrappleHeartMidPoint", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeartMidPoint -> WillowsEnd.GrappleHeart"), lambda s: s.has_all(("Launch", "Sword"), p) and has_enough_resources([('db', 40)], [], "WillowsEnd.GrappleHeartMidPoint", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> E.WillowsEnd.GrappleHeart"), lambda s: has_enough_resources([], [('energy', ('Grenade', 1))], "WillowsEnd.GrappleHeart", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.PoisonfallHC"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.PoisonfallHC"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([('db', 4)], [], "WillowsEnd.GrappleHeart", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.PoisonfallHC"), lambda s: s.has("WillowsEnd.GrappleWheelsHeart", p) and s.has_any(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.PoisonfallHC"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Bash"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.GrappleHeart", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.Entry"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.Entry"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.GrappleHeart", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.GrappleHeart -> WillowsEnd.Entry"), lambda s: s.has_all(("WillowsEnd.GrappleWheelsHeart", "Launch"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.SpikesOre"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.SpikesOre"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 40)], "WillowsEnd.BoulderHeartPath", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.SpikesOre"), lambda s: s.has_all(("Grapple", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.SpikesOre"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 40)], [], "WillowsEnd.BoulderHeartPath", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.EntryEX"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Grapple", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.EntryEX"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Grapple", "Dash"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.Entry"), lambda s: s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.BoulderHeartPath -> WillowsEnd.Entry"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 2))], [], "WillowsEnd.BoulderHeartPath", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.PortalShortcut"), lambda s: has_enough_resources([('wall', ('BreakWall', 20))], [], "WillowsEnd.InnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.LupoMap"), lambda s: can_buy_map(s, p), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.Entry"), lambda s: s.has("WillowsEnd.PortalShortcut", p), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.Entry"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('db', 40)], [], "WillowsEnd.InnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.Entry"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 40)], [], "WillowsEnd.InnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.AboveInnerTP"), lambda s: s.has("Launch", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.AboveInnerTP"), lambda s: s.has("Launch", p) and has_enough_resources([], [('db', 40)], "WillowsEnd.InnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.AboveInnerTP"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.InnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.AboveInnerTP"), lambda s: s.has("Bash", p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('wall', ('BreakWall', 20))], [], "WillowsEnd.InnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.AboveInnerTP"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('Grenade', 1)), ('wall', ('BreakWall', 20))], [('db', 40)], "WillowsEnd.InnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.InnerTP -> WillowsEnd.AboveInnerTP"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 40)], [], "WillowsEnd.InnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.InnerTP"), lambda s: has_enough_resources([('db', 10)], [], "WillowsEnd.AboveInnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.East"), lambda s: s.has("Launch", p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.East"), lambda s: s.has("Bash", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.AboveInnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.East"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.East"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p) and s.has_any(("Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.AboveInnerTP -> WillowsEnd.East"), lambda s: s.has_all(("Bash", "Double Jump", "Glide"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "WillowsEnd.AboveInnerTP", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.AboveInnerTP"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.AboveInnerTP"), lambda s: s.has_all(("Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.AboveInnerTP"), lambda s: s.has_all(("Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.AboveInnerTP"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.RedirectHeartPath"), lambda s: s.has("Bash", p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.RedirectHeartPath"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.Upper"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.East -> WillowsEnd.Upper"), lambda s: s.has_all(("Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPath -> WillowsEnd.East"), lambda s: s.has_any(("Bash", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPuzzle -> WillowsEnd.RedirectEX"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword", "Hammer"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPuzzle -> WillowsEnd.RedirectEX"), lambda s: s.has_all(("Glide", "Double Jump", "Triple Jump", "Bash"), p) and s.has_any(("Sword", "Hammer"), p) and has_enough_resources([('db', 20)], [], "WillowsEnd.RedirectHeartPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.RedirectHeartPuzzle -> WillowsEnd.RedirectHeartPath"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('db', 40)], [], "WillowsEnd.RedirectHeartPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> E.WillowsEnd.Upper"), lambda s: s.has("BreakCrystal", p) and s.has_any(("Bash", "Launch"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> E.WillowsEnd.Upper"), lambda s: s.has_all(("BreakCrystal", "Double Jump", "Triple Jump"), p) and has_enough_resources([('combat', 'CrystalMiner')], [], "WillowsEnd.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.BurrowHeart"), lambda s: s.has_all(("Burrow", "Double Jump", "Dash", "Bash", "Grapple", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 30))], [], "WillowsEnd.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.BurrowHeart"), lambda s: s.has_all(("Burrow", "Bash", "Grapple", "Launch"), p) and s.has_any(("Double Jump", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 30))], [], "WillowsEnd.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.MiniBossFight"), lambda s: s.has("Launch", p) and s.has_any(("Dash", "Glide", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.East"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('db', 10)], [], "WillowsEnd.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.West"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Grenade', 1)), ('db', 20)], [], "WillowsEnd.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.West"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 2)), ('db', 20)], [], "WillowsEnd.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.Upper -> WillowsEnd.UpperHeartPath"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.MiniBossFight -> WillowsEnd.MinibossHeart"), lambda s: s.has_all(("Regenerate", "Launch", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('Boss', 300)), ('db', 60)], [], "WillowsEnd.MiniBossFight", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.MiniBossFight -> WillowsEnd.Upper"), lambda s: s.has("Launch", p) and s.has_any(("Glide", "Double Jump", "Dash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.SpinLasersHeart"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 30))], [], "WillowsEnd.West", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.Upper"), lambda s: s.has_all(("Bash", "Double Jump", "Triple Jump"), p) and has_enough_resources([('wall', ('BreakWall', 10))], [], "WillowsEnd.West", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.Upper"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('wall', ('BreakWall', 10)), ('energy', ('Grenade', 1))], [], "WillowsEnd.West", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.Upper"), lambda s: s.has("Bash", p) and has_enough_resources([('wall', ('BreakWall', 10)), ('energy', ('Grenade', 2))], [], "WillowsEnd.West", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.GlideHeartPath"), lambda s: s.has_all(("Double Jump", "Dash", "Glide"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.West -> WillowsEnd.GlideHeartPath"), lambda s: has_enough_resources([('db', 20)], [], "WillowsEnd.West", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.GlideHeartPath -> WillowsEnd.GlideRooms"), lambda s: s.has("Launch", p), "or")
    add_rule(w.get_entrance("WillowsEnd.GlideHeartPath -> WillowsEnd.GlideRooms"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperLeftEX"), lambda s: s.has_all(("Launch", "Grapple"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperLeftEX"), lambda s: s.has_all(("Launch", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperLeftEX"), lambda s: s.has_all(("WillowsEnd.SpinPortalsHeart", "Launch", "Double Jump", "Glide", "Bash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperHeartCheckpoint"), lambda s: s.has_all(("Launch", "Grapple", "Bash"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperHeartCheckpoint"), lambda s: s.has_all(("Launch", "Double Jump", "Triple Jump"), p) and s.has_any(("Grapple", "Bash", "Glide"), p) and has_enough_resources([('db', 40)], [], "WillowsEnd.UpperHeartPath", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperHeartCheckpoint"), lambda s: s.has_all(("WillowsEnd.SpinPortalsHeart", "Launch", "Bash", "Double Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperHeartCheckpoint"), lambda s: s.has_all(("WillowsEnd.SpinPortalsHeart", "Launch", "Bash"), p) and s.has_any(("Dash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('energy', ('Grenade', 1))], [], "WillowsEnd.UpperHeartPath", s, p, o, False), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartPath -> WillowsEnd.UpperHeartCheckpoint"), lambda s: s.has_all(("WillowsEnd.SpinPortalsHeart", "Launch", "Double Jump", "Triple Jump"), p), "or")
    add_rule(w.get_entrance("WillowsEnd.UpperHeartCheckpoint -> WillowsEnd.UpperLeftEX"), lambda s: s.has_all(("Launch", "Double Jump", "Glide", "Bash"), p), "or")


def set_gorlek_glitched_rules(w: "WotWWorld"):
    """Gorlek (or medium) rules with glitches"""
    p = w.player
    o = w.options
    add_rule(w.get_entrance("MarshSpawn.Main -> MarshSpawn.GrappleHC"), lambda s: s.has_all(("Launch", "Double Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.Main", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.OpherBarrier -> MarshSpawn.Main"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.OpherBarrier", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.BashEC"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.BrokenBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BrokenBridge -> MarshSpawn.OpherBarrier"), lambda s: s.has("MarshSpawn.LogBroken", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.BrokenBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.LeverEC"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.CaveEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.LeverEC"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.CaveEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.CaveEntrance -> MarshSpawn.BrokenBridge"), lambda s: s.has("Dash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.CaveEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.TokkBarrier"), lambda s: has_enough_resources([('wall', ('shuriken', 16))], [], "MarshSpawn.Cave", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.Cave -> MarshSpawn.PoolsBurrowsSignpost"), lambda s: s.has("MarshSpawn.CaveFight", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.Cave", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.LifepactLedge -> MarshSpawn.BurrowFightArena"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.LifepactLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.CaveOre"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.PoolsBurrowsSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsBurrowsSignpost -> MarshSpawn.BurrowFightArena"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.PoolsBurrowsSignpost", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsApproachLedgeEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 10)], [], "MarshSpawn.BeforeBurrows", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("Clean Water", "Water Dash"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.BeforeBurrows", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BeforeBurrows -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.BeforeBurrows", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.BurrowsEntry -> MarshSpawn.BurrowsOpen"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.BurrowsEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.PoolsPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has("Clean Water", p) and s.has("Hammer", p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "MarshSpawn.PoolsPath", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.RegenDoor -> MarshSpawn.HowlApproach"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.RegenDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.HowlApproach -> MarshSpawn.RegenDoor"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.HowlApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.RecklessShard"), lambda s: s.has("MarshSpawn.HowlBurnt", p) and s.has("Dash", p) and has_enough_resources([('wall', ('BreakWall', 10)), ('energy', ('SentryJump', 1))], [], "MarshSpawn.MokkTheBrave", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.HowlApproach"), lambda s: s.has("MarshSpawn.HowlBurnt", p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "MarshSpawn.MokkTheBrave", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.MokkTheBrave -> MarshSpawn.AboveHowlArena"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.MokkTheBrave", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.FangPlatform -> MarshSpawn.FangEC"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshSpawn.FangPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshSpawn.FangPlatform -> MarshSpawn.AboveHowlArena"), lambda s: has_enough_resources([('energy', ('SentryJump', 1)), ('db', 10)], [], "MarshSpawn.FangPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.AboveBoneBridge -> HowlsDen.MidwayBottomLoop"), lambda s: has_enough_resources([('wall', ('shuriken', 16))], [], "HowlsDen.AboveBoneBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.UpperLoopEntrance -> HowlsDen.UpperLoopExit"), lambda s: s.has("HowlsDen.UpperLoopEntranceBarrier", p) and s.has("Sword", p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "HowlsDen.UpperLoopEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.BoneBridge -> HowlsDen.AboveDoorKS"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "HowlsDen.BoneBridge", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.OutsideSecretRoom -> HowlsDen.MidwayBottomLoop"), lambda s: s.has("Hammer", p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "HowlsDen.OutsideSecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.MidwayBottomLoop -> HowlsDen.AboveBoneBridge"), lambda s: has_enough_resources([('wall', ('BreakWall', 16)), ('energy', ('SentryJump', 1))], [], "HowlsDen.MidwayBottomLoop", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.LeftSecretRoom -> HowlsDen.SecretRoom"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "HowlsDen.LeftSecretRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.AboveTeleporter -> HowlsDen.BoneBarrier"), lambda s: has_enough_resources([('wall', ('shuriken', 16))], [], "HowlsDen.AboveTeleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.LaserKS"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "HowlsDen.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.DoubleJumpApproach"), lambda s: s.has("Hammer", p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "HowlsDen.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.Teleporter -> HowlsDen.AboveTeleporter"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "HowlsDen.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeLedge -> HowlsDen.DoubleJumpEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "HowlsDen.DoubleJumpTreeLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("HowlsDen.DoubleJumpTreeArea -> HowlsDen.DoubleJumpTreeLedge"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "HowlsDen.DoubleJumpTreeArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.MillView -> MarshSpawn.ToOpherBarrier"), lambda s: has_enough_resources([('wall', ('shuriken', 16))], [], "MarshPastOpher.MillView", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.TrialArea -> MarshPastOpher.TrialRightEX"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshPastOpher.TrialArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.BowArea -> MarshPastOpher.UpperBowArea"), lambda s: has_enough_resources([('energy', ('SentryJump', 2))], [], "MarshPastOpher.BowArea", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.CeilingEX"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1))], [], "MarshPastOpher.PoolsPathEast", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathEast -> MarshPastOpher.CeilingEX"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "MarshPastOpher.PoolsPathEast", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathEC"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathOneWayWall"), lambda s: s.has_any(("Bash", "Launch"), p) and has_enough_resources([('wall', ('shuriken', 20)), ('energy', ('SentryJump', 1))], [], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathOneWayWall"), lambda s: s.has_any(("Bash", "Launch"), p) and has_enough_resources([('wall', ('shuriken', 20))], [], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathMiddle -> MarshPastOpher.PoolsPathOneWayWall"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('wall', ('shuriken', 20))], [], "MarshPastOpher.PoolsPathMiddle", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathBellowOneWayWall -> MarshPastOpher.PoolsPathOneWayWall"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MarshPastOpher.PoolsPathBellowOneWayWall", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('HammerSJump', 1)), ('db', 10)], [], "MarshPastOpher.PoolsPathWest", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> MarshPastOpher.PoolsPathBellowOneWayWall"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1)), ('db', 10)], [], "MarshPastOpher.PoolsPathWest", s, p, o, False), "or")
    add_rule(w.get_entrance("MarshPastOpher.PoolsPathWest -> PoolsApproach.MarshBreakableWall"), lambda s: can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('wall', ('shuriken', 20))], [], "MarshPastOpher.PoolsPathWest", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.Teleporter -> MarshSpawn.BurrowsEntry"), lambda s: s.has_all(("MarshSpawn.BurrowsOpen", "Double Jump"), p) and can_enter_area("MarshSpawn", s, p, o) and has_enough_resources([('energy', ('SentryJump', 3)), ('db', 15)], [], "MidnightBurrows.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.Central -> MidnightBurrows.TabletRoom"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "MidnightBurrows.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.East"), lambda s: s.has("MidnightBurrows.Lever", p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "MidnightBurrows.PortalRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.PortalRoom -> MidnightBurrows.East"), lambda s: has_enough_resources([('energy', ('SentryJump', 3))], [], "MidnightBurrows.PortalRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("MidnightBurrows.LeverRoom -> MidnightBurrows.LowerKS"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "MidnightBurrows.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.PurpleDoorOpen"), lambda s: s.has("Double Jump", p) and s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('energy', ('Bow', 1)), ('energy', ('SentryJump', 1))], [], "WestHollow.Entrance", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.Entrance -> WestHollow.MokiByTwillen"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.Entrance", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.InFrontPurpleDoor -> WestHollow.MokiByTwillen"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.InFrontPurpleDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleSolved"), lambda s: s.has("WestHollow.FullyDrained", p) and s.has("Launch", p) and has_enough_resources([('energy', ('Bow', 1)), ('energy', ('SentryJump', 1))], [], "WestHollow.RockPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.RockPuzzle -> WestHollow.RockPuzzleSolved"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and s.has("Launch", p) and has_enough_resources([('energy', ('Bow', 1)), ('energy', ('SentryJump', 1))], [], "WestHollow.RockPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.PastRockPuzzleDoor -> WestHollow.FarLeftRoom"), lambda s: s.has_any(("WestHollow.UpperDrainLeverPulled", "WestHollow.FullyDrained"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.PastRockPuzzleDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FullyDrained"), lambda s: s.has("WestHollow.UpperDrainLeverPulled", p) and has_enough_resources([('energy', ('Bow', 1)), ('energy', ('SentryJump', 1))], [], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.FarLeftRoom -> WestHollow.FarLeftEX"), lambda s: s.has("WestHollow.FullyDrained", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.FarLeftRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.HollowDrainMiddle"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.UpperTongueRetracted"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.SubmergedPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.RockPuzzle"), lambda s: s.has("WestHollow.FullyDrained", p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "WestHollow.SubmergedPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.SubmergedPlatform -> WestHollow.RockPuzzle"), lambda s: s.has_all(("WestHollow.FullyDrained", "WestHollow.UpperTongueRetracted"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "WestHollow.SubmergedPlatform", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.LupoMap"), lambda s: can_buy_map(s, p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.HollowDrainLower", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.HollowDrainLower -> WestHollow.TrialApproach"), lambda s: s.has("WestHollow.FullyDrained", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.HollowDrainLower", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.DoorLever"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "WestHollow.DashApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashApproach -> WestHollow.PolesPond"), lambda s: has_enough_resources([('energy', ('SentryJump', 3))], [], "WestHollow.DashApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashArea -> WestHollow.AboveDashSemisolid"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.DashArea", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashArea"), lambda s: s.has("Dash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.DashCrushers", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestHollow.DashCrushers", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SwordSJump', 1)), ('db', 10)], [], "WestHollow.DashCrushers", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: s.has_all(("Bash", "Double Jump"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "WestHollow.DashCrushers", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: s.has("Dash", p) and has_enough_resources([('energy', ('SentryJump', 1)), ('energy', ('SentryJump', 1))], [], "WestHollow.DashCrushers", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: has_enough_resources([('energy', ('SentryJump', 1)), ('energy', ('SwordSJump', 1)), ('db', 10)], [], "WestHollow.DashCrushers", s, p, o, False), "or")
    add_rule(w.get_entrance("WestHollow.DashCrushers -> WestHollow.DashRoomTopRight"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1)), ('energy', ('HammerSJump', 1))], [], "WestHollow.DashCrushers", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> EastHollow.AfterBeetleFight"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Teleporter -> EastHollow.VoiceDoorPlatform"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.MapMoki -> EastHollow.OutsideGlades"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.MapMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SpikeLanternEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SpikeLanternEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 10)], [], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SecretRoofEX"), lambda s: s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SecretRoofEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.SecretRoofEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 2))], [], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Teleporter"), lambda s: s.has("EastHollow.BeetleDefeated", p) and s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AfterBeetleFight -> EastHollow.Kwolok"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has("Grapple", p) and has_enough_resources([('db', 10), ('energy', ('SentryJump', 1))], [], "EastHollow.AfterBeetleFight", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashEC"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1))], [], "EastHollow.AboveBash", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.BashEC"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Bash"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "EastHollow.AboveBash", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveBash -> EastHollow.AfterBeetleFight"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.AboveBash", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.BashTreeCheckpoint -> EastHollow.BashEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.BashTreeCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.Kwolok -> EastHollow.RightKwolokEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.Kwolok", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.BashHC"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "EastHollow.AboveDepths", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.BashHC"), lambda s: has_enough_resources([('energy', ('SentryJump', 3))], [], "EastHollow.AboveDepths", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.DepthsExteriorEX"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastHollow.AboveDepths", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.AboveBash"), lambda s: s.has("EastHollow.DepthsLever", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('SwordSJump', 5))], [], "EastHollow.AboveDepths", s, p, o, False), "or")
    add_rule(w.get_entrance("EastHollow.AboveDepths -> EastHollow.AboveBash"), lambda s: s.has_all(("EastHollow.DepthsLever", "Double Jump"), p) and has_enough_resources([('energy', ('SwordSJump', 4))], [], "EastHollow.AboveDepths", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.ArcingShard"), lambda s: s.has_all(("GladesTown.ClearThorns", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.BlueMoon", "Grapple"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.BelowBountyShard"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> GladesTown.AboveOpher"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.Teleporter -> TuleyShop"), lambda s: s.has("GladesTown.TuleySpawned", p) and s.has_any(("Burrow", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.West"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.TwillenHome", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.TwillenHome -> GladesTown.Teleporter"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.TwillenHome", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has("TuleyShop.StickyGrass", p) and s.has_any(("Double Jump", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("TuleyShop.StickyGrass", "TuleyShop.Lightcatchers", "Bash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "Double Jump"), p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.Lightcatchers", "Bash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.StickyGrass"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.MotayHut"), lambda s: s.has("GladesTown.BuildHuts", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.West -> GladesTown.UpperWest"), lambda s: s.has_all(("TuleyShop.Lightcatchers", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.West", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperOre"), lambda s: s.has("GladesTown.BuildHuts", p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "GladesTown.MotayHut", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperOre"), lambda s: s.has_all(("GladesTown.BuildHuts", "TuleyShop.StickyGrass"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.MotayHut", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.MotayHut -> GladesTown.UpperWest"), lambda s: s.has_all(("GladesTown.BuildHuts", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.MotayHut", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.UpperLeftEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.UpperWest", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.UpperWest -> GladesTown.AboveGromHC"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.UpperWest", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.InsideThirdHut -> GladesTown.BraveMokiHutEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.InsideThirdHut", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.AboveCaveEX"), lambda s: s.has("GladesTown.ClearThorns", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.AcornMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.AboveCaveEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [('db', 10)], "GladesTown.AcornMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.AcornMoki -> GladesTown.Teleporter"), lambda s: s.has("GladesTown.ClearThorns", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.AcornMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornQI"), lambda s: s.has("Flash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.AcornCave", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.AcornCave -> GladesTown.AcornQI"), lambda s: has_enough_resources([('energy', ('Bow', 4)), ('energy', ('SentryJump', 1))], [], "GladesTown.AcornCave", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.BelowBountyShard -> GladesTown.BountyShard"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.BelowBountyShard", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.LeftAboveCoals -> GladesTown.UpdraftCeilingEX"), lambda s: s.has("Hammer", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.LeftAboveCoals", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.AboveOpher -> GladesTown.PlayfulMoki"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.AboveOpher", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.PlayfulMoki -> GladesTown.HoleHut"), lambda s: s.has("Hammer", p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "GladesTown.PlayfulMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> GladesTown.HoleHutEntrance"), lambda s: s.has_any(("Glide", "Sword"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "GladesTown.HoleHut", s, p, o, False), "or")
    add_rule(w.get_entrance("GladesTown.HoleHut -> LowerReach.VeralHome"), lambda s: can_enter_area("LowerReach", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "GladesTown.HoleHut", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.GrappleEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has_any(("Double Jump", "Dash", "Clean Water"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('combat', 'Tentacle')], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has("Water Dash", p) and has_enough_resources([('energy', ('SentryJump', 1)), ('combat', 'Tentacle'), ('db', 20)], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.AbovePlantEX"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SentryJump', 2)), ('combat', 'Tentacle')], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has("Glide", p) and s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> WestGlades.LowerPool"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SentryJump', 1))], [('db', 10), ('combat', 'Tentacle')], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> GladesTown.West"), lambda s: can_enter_area("GladesTown", s, p, o) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> GladesTown.West"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and can_enter_area("GladesTown", s, p, o) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.PastTown -> GladesTown.West"), lambda s: can_enter_area("GladesTown", s, p, o) and has_enough_resources([('energy', ('HammerSJump', 1))], [('db', 10)], "WestGlades.PastTown", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.LowerPool -> WestGlades.Center"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.LowerPool", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.RightOre"), lambda s: s.has("Dash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.Center", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.Center -> WestGlades.Upper"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.Center", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.RightOre"), lambda s: s.has("Glide", p) and has_enough_resources([('combat', 'Tentacle'), ('energy', ('SentryJump', 1))], [], "WestGlades.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.Upper -> WestGlades.MillApproach"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.Upper", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.SwimOre"), lambda s: s.has("Clean Water", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> WestGlades.ShrineArea"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: can_enter_area("OuterWellspring", s, p, o) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: can_enter_area("OuterWellspring", s, p, o) and has_enough_resources([('energy', ('SentryJump', 2))], [], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: s.has("Glide", p) and can_enter_area("OuterWellspring", s, p, o) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.MillApproach -> OuterWellspring.EntranceDoor"), lambda s: can_enter_area("OuterWellspring", s, p, o) and has_enough_resources([('energy', ('HammerSJump', 1))], [('db', 20)], "WestGlades.MillApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("WestGlades.ShrineArea -> WestGlades.ShrineHC"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "WestGlades.ShrineArea", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.Basement"), lambda s: has_enough_resources([('energy', ('HammerSJump', 1)), ('db', 15)], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('SwordSJump', 2))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has("Glide", p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('HammerSJump', 2))], [], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EntranceDoor -> WestGlades.MillApproach"), lambda s: can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('HammerSJump', 2))], [('db', 20)], "OuterWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestWallBroken"), lambda s: has_enough_resources([('wall', ('shuriken', 20))], [], "OuterWellspring.LifeHarvestEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestShard"), lambda s: s.has("OuterWellspring.LifeHarvestLeverPulled", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.LifeHarvestEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.LifeHarvestEntry -> OuterWellspring.LifeHarvestShard"), lambda s: s.has("OuterWellspring.LifeHarvestLeverPulled", p) and has_enough_resources([('energy', ('SentryJump', 1))], [('db', 15)], "OuterWellspring.LifeHarvestEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Grapple", "Bash"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "OuterWellspring.Basement", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has("Double Jump", p) and s.has_any(("Grapple", "Bash"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "OuterWellspring.Basement", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('HammerSJump', 1)), ('db', 15)], [], "OuterWellspring.Basement", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("Double Jump", "Glide", "Sword"), p) and has_enough_resources([('energy', ('HammerSJump', 1)), ('db', 15)], [], "OuterWellspring.Basement", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.Basement", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.Basement -> OuterWellspring.EntranceDoor"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 15)], [], "OuterWellspring.Basement", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.WestDoor"), lambda s: s.has("Grapple", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SwordSJump', 2))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveEntranceDoor -> OuterWellspring.RightWallMidpoint"), lambda s: s.has_all(("Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.AboveEntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.WestDoorBlueMoonFree"), lambda s: s.has_any(("Bow", "Spear", "Shuriken", "Grenade", "Blaze", "Grapple"), p) and has_enough_resources([('wall', ('BreakWall', 3)), ('energy', ('SentryJump', 1))], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and s.has_any(("Triple Jump", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [('db', 15)], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has("Grapple", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 15)], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.HiddenHC"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.WestDoor -> OuterWellspring.EastDoor"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has("InnerWellspring.TopDoorOpen", p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has("InnerWellspring.TopDoorOpen", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.AboveWestDoor"), lambda s: s.has("InnerWellspring.TopDoorOpen", p) and has_enough_resources([('energy', ('HammerSJump', 1))], [('db', 10)], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.EastDoor -> OuterWellspring.TrialApproach"), lambda s: has_enough_resources([('energy', ('SentryJump', 2))], [], "OuterWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.AboveWestDoor -> OuterWellspring.TopDoor"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.AboveWestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TopDoor -> OuterWellspring.UltraGrappleShard"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.TopDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> WestGlades.MillApproach"), lambda s: s.has_any(("Double Jump", "Dash"), p) and can_enter_area("WestGlades", s, p, o) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.EntranceDoor"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.RightWallMidpoint -> OuterWellspring.AboveEntranceDoor"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Dash"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "OuterWellspring.RightWallMidpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.RightWallEX"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.TrialRoom"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.EastDoor"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("OuterWellspring.TrialApproach -> OuterWellspring.AboveEntranceDoor"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "OuterWellspring.TrialApproach", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThreeWheelsEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EntranceDoor -> InnerWellspring.ThornShardArea"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.EntranceDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.ThornShardArea", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 15)], [], "InnerWellspring.ThornShardArea", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.ThornShardArea -> InnerWellspring.ThornEX"), lambda s: s.has_all(("Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 15)], [], "InnerWellspring.ThornShardArea", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("InnerWellspring.DrainRoomBottomWheel", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaExit"), lambda s: s.has_any(("Grapple", "Glide", "Launch"), p) and has_enough_resources([('wall', ('shuriken', 10))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaExit"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('wall', ('shuriken', 10))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaExit"), lambda s: s.has_all(("Bash", "Double Jump", "Dash"), p) and has_enough_resources([('wall', ('shuriken', 10)), ('energy', ('Grenade', 1))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaExit"), lambda s: s.has("InnerWellspring.DrainLever", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('shuriken', 10))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaExit"), lambda s: s.has_all(("InnerWellspring.DrainLever", "Bash"), p) and has_enough_resources([('wall', ('shuriken', 10)), ('energy', ('Grenade', 2))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaExit"), lambda s: s.has("InnerWellspring.DrainRoomBottomWheel", p) and s.has_any(("Double Jump", "Dash", "Sword", "Hammer"), p) and has_enough_resources([('wall', ('shuriken', 10))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaExit"), lambda s: s.has("Clean Water", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('shuriken', 10))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaExit"), lambda s: s.has_all(("Clean Water", "Bash"), p) and has_enough_resources([('wall', ('shuriken', 10)), ('energy', ('Grenade', 1)), ('db', 15)], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoom -> InnerWellspring.DrainAreaExit"), lambda s: s.has_all(("Clean Water", "Bash"), p) and has_enough_resources([('wall', ('shuriken', 10)), ('energy', ('Grenade', 2))], [], "InnerWellspring.DrainRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has("Bash", p) and s.has("Clean Water", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.DrainAreaEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaEntrance -> InnerWellspring.DrainAreaEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [('db', 20)], "InnerWellspring.DrainAreaEntrance", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Glide", p) and s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Sword", p) and s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [('db', 15)], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainAreaExit -> InnerWellspring.DrainRoomCenter"), lambda s: has_enough_resources([('energy', ('SentryJump', 2))], [], "InnerWellspring.DrainAreaExit", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomCenter -> InnerWellspring.DrainAreaExit"), lambda s: has_enough_resources([('wall', ('shuriken', 10))], [], "InnerWellspring.DrainRoomCenter", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.DrainRoomTop", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "InnerWellspring.DrainRoomTop", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.DrainRoomTop -> InnerWellspring.BelowDrainLever"), lambda s: s.has("InnerWellspring.DrainRoomTopWheel", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.DrainRoomTop", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.DrainLever"), lambda s: s.has("InnerWellspring.UpperCorruption", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has("InnerWellspring.UpperCorruption", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: has_enough_resources([('energy', ('SentryJump', 2))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.LeverEC"), lambda s: s.has("InnerWellspring.UpperCorruption", p) and s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.WestDoor"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.WestDoor"), lambda s: s.has_all(("Double Jump", "Glide"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.BelowDrainLever -> InnerWellspring.WestDoor"), lambda s: has_enough_resources([('energy', ('SentryJump', 2))], [], "InnerWellspring.BelowDrainLever", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.MiddleDoorsOpen"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.LupoMap"), lambda s: can_buy_map(s, p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "InnerWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.WestDoor -> InnerWellspring.GrappleTreeEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.WestDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.AboveSpinArenaEX"), lambda s: s.has("Grapple", p) and s.has("Sword", p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "InnerWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.AboveSpinArenaEX"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.AboveSpinArenaEX"), lambda s: s.has("Bash", p) and has_enough_resources([('wall', ('shuriken', 10))], [], "InnerWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.EastDoor -> InnerWellspring.AboveSpinArenaEX"), lambda s: has_enough_resources([('wall', ('shuriken', 10))], [('combat', 'Tentacle')], "InnerWellspring.EastDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.SpinPuzzle -> InnerWellspring.EastDoor"), lambda s: s.has("InnerWellspring.SpinningRoomOpen", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.SpinPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Bash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.PastSpinPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "InnerWellspring.PastSpinPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.PastSpinPuzzle -> InnerWellspring.GrappleThroughZigZagSpikes"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 3))], [], "InnerWellspring.PastSpinPuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.BlueMoonSeed"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.AboveTpEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.EscapeSequence"), lambda s: s.has_any(("Double Jump", "Grapple"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "InnerWellspring.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("InnerWellspring.Teleporter -> InnerWellspring.EscapeSequence"), lambda s: has_enough_resources([('energy', ('SentryJump', 2))], [], "InnerWellspring.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.FirstMud -> WoodsEntry.MudPitEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsEntry.FirstMud", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.FamilyHut -> WoodsEntry.Teleporter"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsEntry.FamilyHut", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.Teleporter"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1))], [], "WoodsEntry.BelowTeleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.BelowTeleporter -> WoodsEntry.Teleporter"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('HammerSJump', 1)), ('db', 15)], [], "WoodsEntry.BelowTeleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsEntry.Teleporter -> WoodsEntry.LedgeOre"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsEntry.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AfterKuMeet -> WoodsMain.BelowFourKeystoneRoom"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1))], [], "WoodsMain.AfterKuMeet", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('combat', 'Balloon'), ('energy', ('SentryJump', 1))], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.WallOreLedge"), lambda s: s.has_all(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BelowFourKeystoneRoom -> WoodsMain.AfterKuMeet"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.BelowFourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.WallOreLedge -> WoodsMain.AfterKuMeet"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.WallOreLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.RightKS"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.FourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.UpperKS"), lambda s: has_enough_resources([('wall', ('BreakWall', 3)), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('energy', ('SwordSJump', 1))], [], "WoodsMain.FourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FourKeystoneRoom -> WoodsMain.UpperKS"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 3)), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('combat', 'Skeeto'), ('energy', ('HammerSJump', 1))], [], "WoodsMain.FourKeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.BehindDoorRoofEX"), lambda s: has_enough_resources([('combat', 'Balloon'), ('energy', ('SentryJump', 1))], [], "WoodsMain.GiantSkull", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.GiantSkull -> WoodsMain.BalloonLure"), lambda s: s.has("Bash", p) and has_enough_resources([('combat', 'Balloon'), ('energy', ('HammerSJump', 1))], [], "WoodsMain.GiantSkull", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.AboveHowl"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.PetrifiedHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.PetrifiedHowl -> WoodsMain.AboveHowl"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.PetrifiedHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> WoodsMain.AboveHowl"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.BrokenOwl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BrokenOwl -> WoodsMain.TrialStart"), lambda s: s.has_any(("Bash", "Hammer"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "WoodsMain.BrokenOwl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BeforeLog"), lambda s: s.has("Dash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.AboveHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.AboveHowl -> WoodsMain.BeforeLog"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [('combat', 'Balloon'), ('db', 20)], "WoodsMain.AboveHowl", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.BeforeLog -> WoodsMain.OrangeTree"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "WoodsMain.BeforeLog", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.BeforeLog"), lambda s: s.has("WoodsMain.LogBlobDestroyed", p) and s.has("Dash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.Teleporter -> WoodsMain.BeforeLog"), lambda s: s.has("WoodsMain.LogBlobDestroyed", p) and has_enough_resources([('energy', ('SentryJump', 1))], [('combat', 'Balloon'), ('combat', 'Balloon')], "WoodsMain.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.OrangeTree -> WoodsMain.BeforeLog"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.OrangeTree", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("Grapple", "Double Jump"), p) and can_enter_area("LowerWastes", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.FeedingGrounds", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> LowerWastes.WestTP"), lambda s: s.has_all(("WindtornRuins.Seir", "Double Jump", "Triple Jump"), p) and can_enter_area("LowerWastes", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.FeedingGrounds", s, p, o, False), "or")
    add_rule(w.get_entrance("WoodsMain.FeedingGrounds -> WoodsMain.AbovePit"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "WoodsMain.FeedingGrounds", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.BelowBaurEX"), lambda s: s.has_all(("LowerReach.BearSneezed", "LowerReach.BearBridgeBroken"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Entry -> LowerReach.AboveEntry"), lambda s: s.has_any(("Double Jump", "Bash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurLowerEX"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.AboveEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.AboveEntry -> LowerReach.AboveBaurLowerEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 2))], [], "LowerReach.AboveEntry", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Icefall -> LowerReach.LeftFurnace"), lambda s: has_enough_resources([('energy', ('Grenade', 1)), ('combat', 'Nest'), ('energy', ('SentryJump', 1))], [], "LowerReach.Icefall", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.AboveDoorEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.LupoMap"), lambda s: can_buy_map(s, p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.TPLeftEX"), lambda s: has_enough_resources([('energy', ('SwordSJump', 2)), ('energy', ('Spear', 1))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.TPLeftEX"), lambda s: has_enough_resources([('energy', ('HammerSJump', 3))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: has_enough_resources([('energy', ('SwordSJump', 3)), ('energy', ('Spear', 1))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: s.has("Hammer", p) and has_enough_resources([('energy', ('SwordSJump', 4))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Central -> LowerReach.OutsideTPRoom"), lambda s: has_enough_resources([('energy', ('HammerSJump', 3))], [], "LowerReach.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> F.LowerReach.OutsideTPRoom"), lambda s: has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.TPLeftEX"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.HiddenOre"), lambda s: s.has_all(("LowerReach.ThawCentralFurnace", "Double Jump"), p) and s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.Teleporter"), lambda s: has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.BelowTokk"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.BelowTokk"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.OutsideTPRoom -> LowerReach.BelowTokk"), lambda s: s.has_all(("LowerReach.FreezeCentralFurnace", "Double Jump"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "LowerReach.OutsideTPRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.KeystoneRoom"), lambda s: s.has("Double Jump", p) and can_enter_area("UpperReach", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.BelowTokk", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.KeystoneRoom"), lambda s: can_enter_area("UpperReach", s, p, o) and has_enough_resources([('energy', ('SentryJump', 2))], [], "LowerReach.BelowTokk", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.BurrowArea"), lambda s: s.has_all(("Burrow", "Double Jump"), p) and can_enter_area("UpperReach", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.BelowTokk", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BelowTokk -> UpperReach.BurrowArea"), lambda s: s.has("Burrow", p) and can_enter_area("UpperReach", s, p, o) and has_enough_resources([('energy', ('SentryJump', 2))], [], "LowerReach.BelowTokk", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Teleporter -> LowerReach.OutsideTPRoom"), lambda s: has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.MeltIceEX"), lambda s: has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.SecondSoup", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.CentralEnemyPaths"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.SecondSoup", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SecondSoup -> LowerReach.BelowLupo"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.SecondSoup", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.BelowLupoEX"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.BelowLupo", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.BelowLupoEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [('db', 20)], "LowerReach.BelowLupo", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BelowLupo -> LowerReach.SecondSoup"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.BelowLupo", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.CentralFurnacePedestal -> LowerReach.WindChannel"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.CentralFurnacePedestal", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindLantern"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Sentry', 1)), ('energy', ('SentryJump', 1))], [], "LowerReach.WindChannel", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WindChannel -> LowerReach.WindLantern"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.WindChannel", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.EastEnemyPaths"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.SoupMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SoupMoki -> LowerReach.EastEnemyPaths"), lambda s: s.has("Double Jump", p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 20)], [], "LowerReach.SoupMoki", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.East -> LowerReach.SnowballEnemyPaths"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [('energy', ('Grenade', 1)), ('energy', ('Spear', 1))], "LowerReach.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.East -> LowerReach.SnowballEnemyPaths"), lambda s: s.has_all(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [('energy', ('Grenade', 1)), ('energy', ('Spear', 1))], "LowerReach.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.TPLantern"), lambda s: has_enough_resources([('energy', ('Sentry', 1)), ('energy', ('SentryJump', 1))], [], "LowerReach.Snowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.TPLantern"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.Snowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.TPLantern"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.Snowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.RolledSnowball"), lambda s: s.has("Launch", p) and has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.Snowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.Snowball -> LowerReach.RolledSnowball"), lambda s: s.has_all(("Double Jump", "Triple Jump", "Glide"), p) and has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.Snowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.IceCavern"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.PastSnowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.PastSnowball -> LowerReach.EastFurnace"), lambda s: has_enough_resources([('wall', ('shuriken', 20))], [], "LowerReach.PastSnowball", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.RoofRightEX"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.RoofRightEX"), lambda s: s.has("LowerReach.FreezeEastFurnace", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: has_enough_resources([('energy', ('SwordSJump', 2))], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: s.has("LowerReach.FreezeEastFurnace", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.IceCavern -> LowerReach.HalfwayIceCavern"), lambda s: s.has("LowerReach.FreezeEastFurnace", p) and has_enough_resources([('energy', ('HammerSJump', 2))], [], "LowerReach.IceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.EastDoorLantern"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1)), ('energy', ('Grenade', 1))], [], "LowerReach.HalfwayIceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.EastDoorLantern"), lambda s: s.has_any(("Launch", "Double Jump"), p) and has_enough_resources([('energy', ('Sentry', 1))], [], "LowerReach.HalfwayIceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.IceCavern"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1))], [], "LowerReach.HalfwayIceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.HalfwayIceCavern -> LowerReach.IceCavern"), lambda s: s.has("LowerReach.FreezeEastFurnace", p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "LowerReach.HalfwayIceCavern", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.ArenaArea"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "LowerReach.FreezeEastFurnace"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.SwimmingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.ArenaArea"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "Clean Water"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "LowerReach.SwimmingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.ArenaArea"), lambda s: s.has_all(("LowerReach.EastDoorLantern", "Double Jump", "Glide"), p) and has_enough_resources([('energy', ('SwordSJump', 2))], [], "LowerReach.SwimmingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.EastFurnace"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1))], [], "LowerReach.SwimmingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.SwimmingPool -> LowerReach.EastFurnace"), lambda s: s.has_any(("Dash", "Double Jump", "LowerReach.FreezeEastFurnace"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "LowerReach.SwimmingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WindSpinners -> LowerReach.WispPathCheckpoint"), lambda s: s.has("Glide", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.WindSpinners", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.WispPathCheckpoint -> LowerReach.BridgeWispPath"), lambda s: s.has("Launch", p) and s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.WispPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.SnowEscape"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.BridgeWispPath", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.SnowEscape"), lambda s: s.has_all(("Bash", "Double Jump"), p) and s.has_any(("Dash", "Triple Jump"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "LowerReach.BridgeWispPath", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.BridgeWispPath -> LowerReach.SnowEscape"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([('energy', ('SwordSJump', 2))], [], "LowerReach.BridgeWispPath", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.VeralHome -> LowerReach.TownEntry"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.VeralHome", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.RightKS"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerReach.TrialStart", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerReach.TrialStart -> LowerReach.TownEntry"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1))], [], "LowerReach.TrialStart", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.LowerKS"), lambda s: s.has("UpperReach.ThawFurnace", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.LowerKS"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Grapple"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Grapple", "Dash"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.UpperSoup"), lambda s: s.has_all(("Bash", "Grapple", "Sword"), p) and has_enough_resources([('energy', ('HammerSJump', 1)), ('db', 20)], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Grapple"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Grapple"), p) and s.has("Dash", p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.KeystoneRoom -> UpperReach.KeystoneSnapPlantThawed"), lambda s: s.has_all(("UpperReach.ThawFurnace", "Bash", "Grapple"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [('db', 20)], "UpperReach.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupPaths -> UpperReach.SwingPoleEX"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperReach.UpperSoupPaths", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.UpperSoupThawedPaths -> UpperReach.MiddleRightKS"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperReach.UpperSoupThawedPaths", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoomLedge -> UpperReach.TreeOre"), lambda s: s.has("Double Jump", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperReach.TreeRoomLedge", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.HiddenEX"), lambda s: has_enough_resources([('energy', ('Sentry', 1))], [], "UpperReach.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.TreeRoomLedge"), lambda s: has_enough_resources([('energy', ('SentryJump', 1)), ('energy', ('Grenade', 2))], [], "UpperReach.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.TreeRoom -> UpperReach.TreeRoomLedge"), lambda s: has_enough_resources([('energy', ('SentryJump', 2)), ('energy', ('Sentry', 2))], [], "UpperReach.TreeRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperReach.SeedHut -> UpperReach.SpringSeed"), lambda s: has_enough_resources([('energy', ('Sentry', 1))], [], "UpperReach.SeedHut", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Entry -> EastHollow.AboveDepths"), lambda s: s.has_all(("EastHollow.DepthsOpen", "Launch"), p) and can_enter_area("EastHollow", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.Entry", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryRoofEX"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('combat', 'Bat')], [], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.EntryOre"), lambda s: s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstFirefly -> UpperDepths.LeftEntryKS"), lambda s: s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "UpperDepths.FirstFirefly", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.SwimEC"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Bash", "Glide", "Sword", "Hammer"), p) and has_enough_resources([('wall', ('shuriken', 20))], [], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.SwimEC"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('wall', ('shuriken', 20))], [('db', 30)], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has("Double Jump", p) and s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 30)], [], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.FirstFirefly"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 30)], [('combat', 'Spiderling'), ('combat', 'Spiderling')], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.KeydoorLedge"), lambda s: has_enough_resources([('energy', ('SwordSJump', 1))], [], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.FirstKSRoom -> UpperDepths.KeydoorLedge"), lambda s: s.has_any(("Double Jump", "Dash", "Glide", "Grapple"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "UpperDepths.FirstKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.RightEntryKS"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.RightKeystonePath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.RightKeystonePath -> UpperDepths.FirstKSRoom"), lambda s: s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.RightKeystonePath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> F.UpperDepths.BelowHive"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.LightcatcherSeed"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('wall', ('shuriken', 20))], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.HiveEX"), lambda s: has_enough_resources([('combat', 'Nest'), ('energy', ('SentryJump', 1))], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.BelowHive -> UpperDepths.Teleporter"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.BelowHive", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.BelowHive"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.Central"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Teleporter -> UpperDepths.OutsideMoraFight"), lambda s: has_enough_resources([('wall', ('shuriken', 20))], [], "UpperDepths.Teleporter", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.Central -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 10)], [], "UpperDepths.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.LeftHealthKS"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> UpperDepths.BossPathEX"), lambda s: s.has_all(("DepthsLight", "Double Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.SecondKSRoom -> LowerDepths.East"), lambda s: s.has("DepthsLight", p) and s.has_any(("Launch", "Double Jump", "Dash", "Glide", "Bash", "Sword", "Hammer"), p) and can_enter_area("LowerDepths", s, p, o) and has_enough_resources([('wall', ('shuriken', 20)), ('combat', 'Spiderling')], [], "UpperDepths.SecondKSRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.LightcatcherSeed"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('energy', ('HammerSJump', 1))], [('db', 30)], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and has_enough_resources([('energy', ('SwordSJump', 1))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('HammerSJump', 1))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('energy', ('SwordSJump', 2))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('energy', ('HammerSJump', 2))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.OutsideMoraFight"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('energy', ('SentryJump', 3))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('SwordSJump', 1))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Double Jump", "Dash", "Glide"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('HammerSJump', 1))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('HammerSJump', 1))], [('db', 30)], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and s.has("Glide", p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('SentryJump', 1))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('SentryJump', 1))], [('db', 30)], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has("DepthsLight", p) and s.has("Glide", p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('SentryJump', 2))], [], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.MoraPath -> UpperDepths.BelowHive"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('SentryJump', 2))], [('db', 30)], "UpperDepths.MoraPath", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.OutsideMoraFight -> UpperDepths.Teleporter"), lambda s: s.has_any(("Dash", "Sword"), p) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('HammerSJump', 1))], [], "UpperDepths.OutsideMoraFight", s, p, o, False), "or")
    add_rule(w.get_entrance("MoraEscape -> MoraSecondPhase"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Grapple"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "MoraEscape", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Grapple"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 10)], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has_all(("DepthsLight", "Double Jump"), p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has("DepthsLight", p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 2)), ('db', 10)], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has("DepthsLight", p) and has_enough_resources([('energy', ('SentryJump', 3)), ('db', 10)], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: has_enough_resources([('wall', ('BreakWall', 1)), ('energy', ('SentryJump', 4))], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has("Double Jump", p) and s.has("DepthsLight", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperDepths.LowerConnection -> UpperDepths.BelowHive"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [('wall', ('BreakWall', 1))], "UpperDepths.LowerConnection", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "Dash", "Glide", "Sword"), p) and has_enough_resources([('wall', ('shuriken', 20))], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has("Dash", p) and s.has_any(("Glide", "Sword"), p) and has_enough_resources([('wall', ('shuriken', 20))], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has_any(("Bash", "Launch"), p) and has_enough_resources([('wall', ('shuriken', 20))], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has("Water Dash", p) and s.has("Clean Water", p) and has_enough_resources([('wall', ('shuriken', 20))], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has("Water Dash", p) and has_enough_resources([('wall', ('shuriken', 20))], [('db', 20)], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> DepthsShrine"), lambda s: s.has("Clean Water", p) and s.has_any(("UpperDepths.ForestsEyes", "Flash"), p) and has_enough_resources([('energy', ('SentryJump', 2))], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("Bash", "Dash"), p) and has_enough_resources([('wall', ('BreakWall', 1)), ('energy', ('SentryJump', 1)), ('db', 10)], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.West -> LowerDepths.Central"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Dash", "Glide"), p) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 10)], [], "LowerDepths.West", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.Central -> LowerDepths.RaceStartHC"), lambda s: s.has("DepthsLight", p) and s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerDepths.Central", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> E.LowerDepths.East"), lambda s: s.has("BreakCrystal", p) and s.has("Bash", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('SentryJump', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Bash"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('SwordSJump', 1)), ('db', 30)], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Bash", "Glide"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('SentryJump', 1)), ('db', 30)], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('SwordSJump', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("LowerDepths.East -> UpperDepths.SecondKSRoom"), lambda s: s.has_all(("DepthsLight", "Double Jump", "Triple Jump"), p) and s.has_any(("Dash", "Glide"), p) and can_enter_area("UpperDepths", s, p, o) and has_enough_resources([('wall', ('BreakWall', 20)), ('energy', ('HammerSJump', 1))], [], "LowerDepths.East", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPathCheckpoint -> PoolsApproach.MillPath"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('energy', ('SentryJump', 1))], [], "PoolsApproach.MillPathCheckpoint", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has("Grapple", p) and s.has("Double Jump", p) and has_enough_resources([('combat', 'Crab'), ('combat', 'SmallSkeeto'), ('energy', ('SentryJump', 1))], [], "PoolsApproach.MillPath", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.MillPathCheckpoint"), lambda s: s.has_all(("Double Jump", "Triple Jump"), p) and has_enough_resources([('combat', 'SmallSkeeto'), ('combat', 'SmallSkeeto'), ('energy', ('SentryJump', 1))], [], "PoolsApproach.MillPath", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.MillPath -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("PoolsApproach.UnderwaterWallBroken", "Clean Water"), p) and s.has_any(("PoolsApproach.WheelFreed", "Double Jump", "Grapple"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "PoolsApproach.MillPath", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> C.PoolsApproach.OnTopOfWheel"), lambda s: s.has("Clean Water", p) and s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> PoolsApproach.AboveWheelEX"), lambda s: s.has("Double Jump", p) and s.has_any(("Triple Jump", "PoolsApproach.WheelFreed"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has("Glide", p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has("Glide", p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [('db', 20)], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("PoolsApproach.OnTopOfWheel -> EastPools.LeverRoom"), lambda s: s.has("Launch", p) and s.has_any(("Double Jump", "Dash"), p) and can_enter_area("EastPools", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "PoolsApproach.OnTopOfWheel", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has("Clean Water", p) and s.has("Hammer", p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has_all(("Dash", "Double Jump"), p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1)), ('db', 20)], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LeverRoom -> PoolsApproach.OnTopOfWheel"), lambda s: s.has("Launch", p) and can_enter_area("PoolsApproach", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.LeverRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.AboveDoorOre"), lambda s: has_enough_resources([('energy', ('SentryJump', 2)), ('db', 20)], [], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.AboveDoorOre"), lambda s: s.has_any(("Double Jump", "Grapple"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: s.has_any(("Grapple", "Double Jump"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.BehindEntryDoor -> EastPools.TPArea"), lambda s: has_enough_resources([('energy', ('SentryJump', 2)), ('db', 20)], [], "EastPools.BehindEntryDoor", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TokkBubble -> EastPools.BehindEntryDoor"), lambda s: s.has("Grapple", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.TokkBubble", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.AboveDoorOre"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [('energy', ('Spear', 1)), ('energy', ('Grenade', 1)), ('db', 20)], "EastPools.TPArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.TPArea -> EastPools.FishingPool"), lambda s: s.has("Double Jump", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.TPArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.FishingPool -> EastPools.AboveFishingPool"), lambda s: s.has_any(("Double Jump", "Dash"), p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.FishingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.AboveFishingPool -> UpperPools.DrainPuzzleExit"), lambda s: s.has_all(("UpperPools.UpperWaterDrained", "Double Jump"), p) and can_enter_area("UpperPools", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.AboveFishingPool", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.NextToLupoOre -> EastPools.LupoArea"), lambda s: has_enough_resources([('wall', ('shuriken', 20))], [], "EastPools.NextToLupoOre", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.LupoArea -> EastPools.LupoEX"), lambda s: s.has("Hammer", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.LupoArea", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.MissilePuzzle -> EastPools.EnergyHarvestShard"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.MissilePuzzle", s, p, o, False), "or")
    add_rule(w.get_entrance("EastPools.CentralRoom -> UpperPools.KeystoneRoomEntrance"), lambda s: s.has_all(("EastPools.CentralRoomBubbleFree", "Double Jump"), p) and s.has_any(("Triple Jump", "Dash", "Glide"), p) and can_enter_area("UpperPools", s, p, o) and has_enough_resources([('energy', ('SentryJump', 1))], [], "EastPools.CentralRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperLeftKS"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.UpperRightKS"), lambda s: has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Water Dash", p) and s.has("Clean Water", p) and has_enough_resources([('energy', ('SentryJump', 1)), ('combat', 'Crab'), ('combat', 'SpinCrab')], [], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has("Water Dash", p) and has_enough_resources([('energy', ('SentryJump', 1)), ('combat', 'Crab'), ('combat', 'SpinCrab')], [('db', 20)], "UpperPools.KeystoneRoom", s, p, o, False), "or")
    add_rule(w.get_entrance("UpperPools.KeystoneRoom -> UpperPools.BeforeKeystoneDoor"), lambda s: s.has_all(("Bash", "Water Dash"), p) and s.has("Clean Water", p) and has_enough_resources([('energy', ('SentryJump', 1))], [], "UpperPools.Keysto