from __future__ import annotations
"""
CONSOLE SCREEN
ConsoleSliverAppbar - Left side has the players, with expansion for hints
ConsoleLayout - Right contains the console
"""
__all__ = ("ConsoleScreen", "ConsoleSliverAppbar", "ConsoleLayout")
from kivy.properties import ObjectProperty
from kivy.core.window import Window
from kivymd.app import MDApp
from kivymd.uix.boxlayout import MDBoxLayout
from kivymd.uix.card.card import MDRelativeLayout
from .textconsole import ConsoleView

from kivy.clock import Clock
from kivy.lang import Builder
from kivymd.uix.screen import MDScreen
from kivymd.uix.sliverappbar import MDSliverAppbar, MDSliverAppbarContent
from kivymd.uix.list import MDList
from kivymd.theming import ThemableBehavior
from mwgg_gui.overrides.expansionlist import *
from mwgg_gui.components.bottomappbar import BottomAppBar
import asynckivy

Builder.load_string('''
<ConsoleLayout>:
    id: console_layout
    size_hint: None,None
    pos: 0,82

<ConsoleSliverAppbar>:
    pos_hint: {"x": 0, "top": 1}
    width: dp(260)
    size_hint_x: None
    adaptive_height: True
    hide_appbar: True
    background_color: app.theme_cls.secondaryContainerColor
    MDSliverAppbarHeader:
        AsyncImage:
            source: app.logo_png
            pos_hint: {"center_y": 0.5}
            fit_mode: "scale-down"
    MDTopAppBar:
        type: "small"
        pos_hint: {"center_x": 0.5, "top": 1}
        padding: dp(4),0,dp(4),dp(4)
        MDTopAppBarLeadingButtonContainer:
            MDActionTopAppBarButton:
                icon: "refresh"
                on_release: app.ctx.ui.update_hints()
        MDTopAppBarTitle:
            text: "Flags"
            halign: "center"
            font_style: "Body"
            role: "medium"
        MDTopAppBarTrailingButtonContainer:
            MDActionTopAppBarButton:
                icon: "food"
                on_release: root.set_bk()
            MDActionTopAppBarButton:
                icon: "headphones"
                on_release: root.set_deafen()
''')

class ConsoleLayout(MDRelativeLayout):
    pass

class ConsoleSliverAppbar(MDSliverAppbar):
    content: MDSliverAppbarContent
    app: MDApp

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.app = MDApp.get_running_app()
        self.content = MDSliverAppbarContent(orientation="vertical")
        self.content.id = "content"
        self.add_widget(self.content)

    def set_bk(self):
        self.app.ctx.ui.set_bk()
    
    def set_deafen(self):
        self.app.ctx.ui.set_deafen()


class ConsoleScreen(MDScreen, ThemableBehavior):
    '''
    This is the main screen for the console.
    Left side has the players, with expansion for hints
    Right contains the console
    '''
    name = "console"
    app: MDApp
    consolegrid: MDBoxLayout
    important_appbar: MDSliverAppbar
    ui_console: ConsoleView
    bottom_appbar: BottomAppBar


    def __init__(self, **kwargs):
        self.app = MDApp.get_running_app()
        self.size_hint = (1,1)
        self.pos_hint = {"center_x": 0.5, "center_y": 0.5}
        super().__init__(**kwargs)
        self.slots_mdlist = MDList(width=260)

        self.bottom_appbar = BottomAppBar(screen_name="console")

        self.important_appbar = ConsoleSliverAppbar()

        Clock.schedule_once(lambda x: self.init_important())

    def update_slots_list(self):
        """Update the slots list when hints data becomes available"""
        asynckivy.start(self.set_slots_list())


    def init_important(self):
        self.consolegrid = ConsoleLayout(width=Window.width, height=Window.height-185)
        self.add_widget(self.consolegrid)
        self.add_widget(self.bottom_appbar)


        self.important_appbar.size_hint_x = 260/Window.width
        self.important_appbar.size_hint_y=1-(8/Window.height)

        self.ui_console = ConsoleView(pos_hint={"y": 0, "center_x": .5+(130/Window.width)},
                                      size_hint_x=1-(264/Window.width), 
                                      size_hint_y=1-(8/Window.height))
        self.important_appbar.ids.scroll.scroll_wheel_distance = 40

        self.important_appbar.content.add_widget(self.slots_mdlist)

        self.consolegrid.add_widget(self.important_appbar)
        self.consolegrid.add_widget(self.ui_console)

    async def set_slots_list(self):
        self.slots_mdlist.clear_widgets()
        for slot_id, slot_data in self.app.ctx.ui.ui_player_data.items():
            if not slot_data.slot_name == "Archipelago":
                await asynckivy.sleep(0)
                slot = GameListPanel(item_name=slot_id, item_data=slot_data)
                self.slots_mdlist.add_widget(slot)
