# This file is auto generated. More info: https://github.com/Daivuk/apdoom

from typing import Dict, TypedDict, List, Set 


class LocationDict(TypedDict, total=False): 
    name: str 
    episode: int 
    check_sanity: bool 
    map: int 
    index: int # Thing index as it is stored in the wad file. 
    doom_type: int # In case index end up unreliable, we can use doom type. Maps have often only one of each important things. 
    region: str 


location_table: Dict[int, LocationDict] = {
    371000: {'name': 'The Docks (E1M1) - Yellow key',
             'episode': 1,
             'check_sanity': False,
             'map': 1,
             'index': 5,
             'doom_type': 80,
             'region': "The Docks (E1M1) Main"},
    371001: {'name': 'The Docks (E1M1) - Silver Shield',
             'episode': 1,
             'check_sanity': False,
             'map': 1,
             'index': 47,
             'doom_type': 85,
             'region': "The Docks (E1M1) Main"},
    371002: {'name': 'The Docks (E1M1) - Gauntlets of the Necromancer',
             'episode': 1,
             'check_sanity': False,
             'map': 1,
             'index': 52,
             'doom_type': 2005,
             'region': "The Docks (E1M1) Yellow"},
    371003: {'name': 'The Docks (E1M1) - Ethereal Crossbow',
             'episode': 1,
             'check_sanity': False,
             'map': 1,
             'index': 55,
             'doom_type': 2001,
             'region': "The Docks (E1M1) Yellow"},
    371004: {'name': 'The Docks (E1M1) - Bag of Holding',
             'episode': 1,
             'check_sanity': False,
             'map': 1,
             'index': 91,
             'doom_type': 8,
             'region': "The Docks (E1M1) Sea"},
    371005: {'name': 'The Docks (E1M1) - Tome of Power',
             'episode': 1,
             'check_sanity': False,
             'map': 1,
             'index': 174,
             'doom_type': 86,
             'region': "The Docks (E1M1) Yellow"},
    371006: {'name': 'The Docks (E1M1) - Exit',
             'episode': 1,
             'check_sanity': False,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "The Docks (E1M1) Yellow"},
    371007: {'name': 'The Dungeons (E1M2) - Dragon Claw',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 1,
             'doom_type': 53,
             'region': "The Dungeons (E1M2) Yellow"},
    371008: {'name': 'The Dungeons (E1M2) - Yellow key',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 5,
             'doom_type': 80,
             'region': "The Dungeons (E1M2) Main"},
    371009: {'name': 'The Dungeons (E1M2) - Green key',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 17,
             'doom_type': 73,
             'region': "The Dungeons (E1M2) Yellow"},
    371010: {'name': 'The Dungeons (E1M2) - Silver Shield',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 18,
             'doom_type': 85,
             'region': "The Dungeons (E1M2) Main"},
    371011: {'name': 'The Dungeons (E1M2) - Torch',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 19,
             'doom_type': 33,
             'region': "The Dungeons (E1M2) Main"},
    371012: {'name': 'The Dungeons (E1M2) - Map Scroll',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 29,
             'doom_type': 35,
             'region': "The Dungeons (E1M2) Yellow"},
    371013: {'name': 'The Dungeons (E1M2) - Shadowsphere',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 41,
             'doom_type': 75,
             'region': "The Dungeons (E1M2) Yellow"},
    371014: {'name': 'The Dungeons (E1M2) - Bag of Holding',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 44,
             'doom_type': 8,
             'region': "The Dungeons (E1M2) Green"},
    371015: {'name': 'The Dungeons (E1M2) - Blue key',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 45,
             'doom_type': 79,
             'region': "The Dungeons (E1M2) Green"},
    371016: {'name': 'The Dungeons (E1M2) - Ring of Invincibility',
             'episode': 1,
             'check_sanity': True,
             'map': 2,
             'index': 46,
             'doom_type': 84,
             'region': "The Dungeons (E1M2) Yellow"},
    371017: {'name': 'The Dungeons (E1M2) - Tome of Power',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 77,
             'doom_type': 86,
             'region': "The Dungeons (E1M2) Main"},
    371018: {'name': 'The Dungeons (E1M2) - Ethereal Crossbow',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 80,
             'doom_type': 2001,
             'region': "The Dungeons (E1M2) Main"},
    371019: {'name': 'The Dungeons (E1M2) - Tome of Power 2',
             'episode': 1,
             'check_sanity': True,
             'map': 2,
             'index': 81,
             'doom_type': 86,
             'region': "The Dungeons (E1M2) Yellow"},
    371020: {'name': 'The Dungeons (E1M2) - Gauntlets of the Necromancer',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 253,
             'doom_type': 2005,
             'region': "The Dungeons (E1M2) Yellow"},
    371021: {'name': 'The Dungeons (E1M2) - Silver Shield 2',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': 303,
             'doom_type': 85,
             'region': "The Dungeons (E1M2) Yellow"},
    371022: {'name': 'The Dungeons (E1M2) - Exit',
             'episode': 1,
             'check_sanity': False,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "The Dungeons (E1M2) Blue"},
    371023: {'name': 'The Gatehouse (E1M3) - Yellow key',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 8,
             'doom_type': 80,
             'region': "The Gatehouse (E1M3) Main"},
    371024: {'name': 'The Gatehouse (E1M3) - Green key',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 9,
             'doom_type': 73,
             'region': "The Gatehouse (E1M3) Yellow"},
    371025: {'name': 'The Gatehouse (E1M3) - Dragon Claw',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 10,
             'doom_type': 53,
             'region': "The Gatehouse (E1M3) Main"},
    371026: {'name': 'The Gatehouse (E1M3) - Silver Shield',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 22,
             'doom_type': 85,
             'region': "The Gatehouse (E1M3) Main"},
    371027: {'name': 'The Gatehouse (E1M3) - Ethereal Crossbow',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 24,
             'doom_type': 2001,
             'region': "The Gatehouse (E1M3) Main"},
    371028: {'name': 'The Gatehouse (E1M3) - Tome of Power',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 81,
             'doom_type': 86,
             'region': "The Gatehouse (E1M3) Sea"},
    371029: {'name': 'The Gatehouse (E1M3) - Bag of Holding',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 134,
             'doom_type': 8,
             'region': "The Gatehouse (E1M3) Yellow"},
    371030: {'name': 'The Gatehouse (E1M3) - Gauntlets of the Necromancer',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 145,
             'doom_type': 2005,
             'region': "The Gatehouse (E1M3) Yellow"},
    371031: {'name': 'The Gatehouse (E1M3) - Torch',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 203,
             'doom_type': 33,
             'region': "The Gatehouse (E1M3) Main"},
    371032: {'name': 'The Gatehouse (E1M3) - Ring of Invincibility',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 220,
             'doom_type': 84,
             'region': "The Gatehouse (E1M3) Yellow"},
    371033: {'name': 'The Gatehouse (E1M3) - Shadowsphere',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 221,
             'doom_type': 75,
             'region': "The Gatehouse (E1M3) Main"},
    371034: {'name': 'The Gatehouse (E1M3) - Morph Ovum',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 222,
             'doom_type': 30,
             'region': "The Gatehouse (E1M3) Yellow"},
    371035: {'name': 'The Gatehouse (E1M3) - Tome of Power 2',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 286,
             'doom_type': 86,
             'region': "The Gatehouse (E1M3) Main"},
    371036: {'name': 'The Gatehouse (E1M3) - Tome of Power 3',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': 287,
             'doom_type': 86,
             'region': "The Gatehouse (E1M3) Main"},
    371037: {'name': 'The Gatehouse (E1M3) - Exit',
             'episode': 1,
             'check_sanity': False,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "The Gatehouse (E1M3) Green"},
    371038: {'name': 'The Guard Tower (E1M4) - Gauntlets of the Necromancer',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 0,
             'doom_type': 2005,
             'region': "The Guard Tower (E1M4) Main"},
    371039: {'name': 'The Guard Tower (E1M4) - Dragon Claw',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 2,
             'doom_type': 53,
             'region': "The Guard Tower (E1M4) Main"},
    371040: {'name': 'The Guard Tower (E1M4) - Ethereal Crossbow',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 3,
             'doom_type': 2001,
             'region': "The Guard Tower (E1M4) Main"},
    371041: {'name': 'The Guard Tower (E1M4) - Yellow key',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 4,
             'doom_type': 80,
             'region': "The Guard Tower (E1M4) Main"},
    371042: {'name': 'The Guard Tower (E1M4) - Morph Ovum',
             'episode': 1,
             'check_sanity': True,
             'map': 4,
             'index': 5,
             'doom_type': 30,
             'region': "The Guard Tower (E1M4) Main"},
    371043: {'name': 'The Guard Tower (E1M4) - Shadowsphere',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 57,
             'doom_type': 75,
             'region': "The Guard Tower (E1M4) Yellow"},
    371044: {'name': 'The Guard Tower (E1M4) - Green key',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 60,
             'doom_type': 73,
             'region': "The Guard Tower (E1M4) Yellow"},
    371045: {'name': 'The Guard Tower (E1M4) - Bag of Holding',
             'episode': 1,
             'check_sanity': True,
             'map': 4,
             'index': 61,
             'doom_type': 8,
             'region': "The Guard Tower (E1M4) Main"},
    371046: {'name': 'The Guard Tower (E1M4) - Map Scroll',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 64,
             'doom_type': 35,
             'region': "The Guard Tower (E1M4) Main"},
    371047: {'name': 'The Guard Tower (E1M4) - Tome of Power',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 77,
             'doom_type': 86,
             'region': "The Guard Tower (E1M4) Main"},
    371048: {'name': 'The Guard Tower (E1M4) - Silver Shield',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 78,
             'doom_type': 85,
             'region': "The Guard Tower (E1M4) Main"},
    371049: {'name': 'The Guard Tower (E1M4) - Torch',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 143,
             'doom_type': 33,
             'region': "The Guard Tower (E1M4) Main"},
    371050: {'name': 'The Guard Tower (E1M4) - Tome of Power 2',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 220,
             'doom_type': 86,
             'region': "The Guard Tower (E1M4) Yellow"},
    371051: {'name': 'The Guard Tower (E1M4) - Tome of Power 3',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': 221,
             'doom_type': 86,
             'region': "The Guard Tower (E1M4) Main"},
    371052: {'name': 'The Guard Tower (E1M4) - Exit',
             'episode': 1,
             'check_sanity': False,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "The Guard Tower (E1M4) Green"},
    371053: {'name': 'The Citadel (E1M5) - Green key',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 1,
             'doom_type': 73,
             'region': "The Citadel (E1M5) Yellow"},
    371054: {'name': 'The Citadel (E1M5) - Yellow key',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 5,
             'doom_type': 80,
             'region': "The Citadel (E1M5) Main"},
    371055: {'name': 'The Citadel (E1M5) - Blue key',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 19,
             'doom_type': 79,
             'region': "The Citadel (E1M5) Green"},
    371056: {'name': 'The Citadel (E1M5) - Tome of Power',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 23,
             'doom_type': 86,
             'region': "The Citadel (E1M5) Well"},
    371057: {'name': 'The Citadel (E1M5) - Ethereal Crossbow',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 28,
             'doom_type': 2001,
             'region': "The Citadel (E1M5) Yellow"},
    371058: {'name': 'The Citadel (E1M5) - Gauntlets of the Necromancer',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 29,
             'doom_type': 2005,
             'region': "The Citadel (E1M5) Main"},
    371059: {'name': 'The Citadel (E1M5) - Dragon Claw',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 30,
             'doom_type': 53,
             'region': "The Citadel (E1M5) Green"},
    371060: {'name': 'The Citadel (E1M5) - Ring of Invincibility',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 31,
             'doom_type': 84,
             'region': "The Citadel (E1M5) Green"},
    371061: {'name': 'The Citadel (E1M5) - Tome of Power 2',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 78,
             'doom_type': 86,
             'region': "The Citadel (E1M5) Blue"},
    371062: {'name': 'The Citadel (E1M5) - Shadowsphere',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 79,
             'doom_type': 75,
             'region': "The Citadel (E1M5) Main"},
    371063: {'name': 'The Citadel (E1M5) - Bag of Holding',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 80,
             'doom_type': 8,
             'region': "The Citadel (E1M5) Green"},
    371064: {'name': 'The Citadel (E1M5) - Torch',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 103,
             'doom_type': 33,
             'region': "The Citadel (E1M5) Main"},
    371065: {'name': 'The Citadel (E1M5) - Tome of Power 3',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 105,
             'doom_type': 86,
             'region': "The Citadel (E1M5) Green"},
    371066: {'name': 'The Citadel (E1M5) - Silver Shield',
             'episode': 1,
             'check_sanity': True,
             'map': 5,
             'index': 129,
             'doom_type': 85,
             'region': "The Citadel (E1M5) Main"},
    371067: {'name': 'The Citadel (E1M5) - Morph Ovum',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 192,
             'doom_type': 30,
             'region': "The Citadel (E1M5) Green"},
    371068: {'name': 'The Citadel (E1M5) - Map Scroll',
             'episode': 1,
             'check_sanity': True,
             'map': 5,
             'index': 203,
             'doom_type': 35,
             'region': "The Citadel (E1M5) Blue"},
    371069: {'name': 'The Citadel (E1M5) - Silver Shield 2',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 204,
             'doom_type': 85,
             'region': "The Citadel (E1M5) Blue"},
    371070: {'name': 'The Citadel (E1M5) - Torch 2',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 205,
             'doom_type': 33,
             'region': "The Citadel (E1M5) Green"},
    371071: {'name': 'The Citadel (E1M5) - Tome of Power 4',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 319,
             'doom_type': 86,
             'region': "The Citadel (E1M5) Green"},
    371072: {'name': 'The Citadel (E1M5) - Tome of Power 5',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': 320,
             'doom_type': 86,
             'region': "The Citadel (E1M5) Green"},
    371073: {'name': 'The Citadel (E1M5) - Exit',
             'episode': 1,
             'check_sanity': False,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "The Citadel (E1M5) Blue"},
    371074: {'name': 'The Cathedral (E1M6) - Yellow key',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 8,
             'doom_type': 80,
             'region': "The Cathedral (E1M6) Main"},
    371075: {'name': 'The Cathedral (E1M6) - Gauntlets of the Necromancer',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 9,
             'doom_type': 2005,
             'region': "The Cathedral (E1M6) Main"},
    371076: {'name': 'The Cathedral (E1M6) - Ethereal Crossbow',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 39,
             'doom_type': 2001,
             'region': "The Cathedral (E1M6) Yellow"},
    371077: {'name': 'The Cathedral (E1M6) - Dragon Claw',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 45,
             'doom_type': 53,
             'region': "The Cathedral (E1M6) Yellow"},
    371078: {'name': 'The Cathedral (E1M6) - Tome of Power',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 56,
             'doom_type': 86,
             'region': "The Cathedral (E1M6) Yellow"},
    371079: {'name': 'The Cathedral (E1M6) - Shadowsphere',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 61,
             'doom_type': 75,
             'region': "The Cathedral (E1M6) Yellow"},
    371080: {'name': 'The Cathedral (E1M6) - Green key',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 98,
             'doom_type': 73,
             'region': "The Cathedral (E1M6) Yellow"},
    371081: {'name': 'The Cathedral (E1M6) - Silver Shield',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 138,
             'doom_type': 85,
             'region': "The Cathedral (E1M6) Yellow"},
    371082: {'name': 'The Cathedral (E1M6) - Bag of Holding',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 139,
             'doom_type': 8,
             'region': "The Cathedral (E1M6) Yellow"},
    371083: {'name': 'The Cathedral (E1M6) - Ring of Invincibility',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 142,
             'doom_type': 84,
             'region': "The Cathedral (E1M6) Yellow"},
    371084: {'name': 'The Cathedral (E1M6) - Torch',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 217,
             'doom_type': 33,
             'region': "The Cathedral (E1M6) Yellow"},
    371085: {'name': 'The Cathedral (E1M6) - Tome of Power 2',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 273,
             'doom_type': 86,
             'region': "The Cathedral (E1M6) Yellow"},
    371086: {'name': 'The Cathedral (E1M6) - Tome of Power 3',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 274,
             'doom_type': 86,
             'region': "The Cathedral (E1M6) Main"},
    371087: {'name': 'The Cathedral (E1M6) - Morph Ovum',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 277,
             'doom_type': 30,
             'region': "The Cathedral (E1M6) Yellow"},
    371088: {'name': 'The Cathedral (E1M6) - Map Scroll',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 279,
             'doom_type': 35,
             'region': "The Cathedral (E1M6) Yellow"},
    371089: {'name': 'The Cathedral (E1M6) - Ring of Invincibility 2',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 280,
             'doom_type': 84,
             'region': "The Cathedral (E1M6) Yellow"},
    371090: {'name': 'The Cathedral (E1M6) - Silver Shield 2',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 281,
             'doom_type': 85,
             'region': "The Cathedral (E1M6) Green"},
    371091: {'name': 'The Cathedral (E1M6) - Tome of Power 4',
             'episode': 1,
             'check_sanity': True,
             'map': 6,
             'index': 371,
             'doom_type': 86,
             'region': "The Cathedral (E1M6) Green"},
    371092: {'name': 'The Cathedral (E1M6) - Bag of Holding 2',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 449,
             'doom_type': 8,
             'region': "The Cathedral (E1M6) Green"},
    371093: {'name': 'The Cathedral (E1M6) - Silver Shield 3',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 457,
             'doom_type': 85,
             'region': "The Cathedral (E1M6) Main Fly"},
    371094: {'name': 'The Cathedral (E1M6) - Bag of Holding 3',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': 458,
             'doom_type': 8,
             'region': "The Cathedral (E1M6) Main Fly"},
    371095: {'name': 'The Cathedral (E1M6) - Exit',
             'episode': 1,
             'check_sanity': False,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "The Cathedral (E1M6) Green"},
    371096: {'name': 'The Crypts (E1M7) - Yellow key',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 11,
             'doom_type': 80,
             'region': "The Crypts (E1M7) Main"},
    371097: {'name': 'The Crypts (E1M7) - Ethereal Crossbow',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 17,
             'doom_type': 2001,
             'region': "The Crypts (E1M7) Yellow"},
    371098: {'name': 'The Crypts (E1M7) - Green key',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 21,
             'doom_type': 73,
             'region': "The Crypts (E1M7) Yellow"},
    371099: {'name': 'The Crypts (E1M7) - Blue key',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 25,
             'doom_type': 79,
             'region': "The Crypts (E1M7) Green"},
    371100: {'name': 'The Crypts (E1M7) - Morph Ovum',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 26,
             'doom_type': 30,
             'region': "The Crypts (E1M7) Yellow"},
    371101: {'name': 'The Crypts (E1M7) - Dragon Claw',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 45,
             'doom_type': 53,
             'region': "The Crypts (E1M7) Yellow"},
    371102: {'name': 'The Crypts (E1M7) - Gauntlets of the Necromancer',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 46,
             'doom_type': 2005,
             'region': "The Crypts (E1M7) Main"},
    371103: {'name': 'The Crypts (E1M7) - Tome of Power',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 53,
             'doom_type': 86,
             'region': "The Crypts (E1M7) Yellow"},
    371104: {'name': 'The Crypts (E1M7) - Ring of Invincibility',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 90,
             'doom_type': 84,
             'region': "The Crypts (E1M7) Yellow"},
    371105: {'name': 'The Crypts (E1M7) - Silver Shield',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 98,
             'doom_type': 85,
             'region': "The Crypts (E1M7) Green"},
    371106: {'name': 'The Crypts (E1M7) - Bag of Holding',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 130,
             'doom_type': 8,
             'region': "The Crypts (E1M7) Blue"},
    371107: {'name': 'The Crypts (E1M7) - Torch',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 213,
             'doom_type': 33,
             'region': "The Crypts (E1M7) Green"},
    371108: {'name': 'The Crypts (E1M7) - Torch 2',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 214,
             'doom_type': 33,
             'region': "The Crypts (E1M7) Blue"},
    371109: {'name': 'The Crypts (E1M7) - Tome of Power 2',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 215,
             'doom_type': 86,
             'region': "The Crypts (E1M7) Yellow"},
    371110: {'name': 'The Crypts (E1M7) - Shadowsphere',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 224,
             'doom_type': 75,
             'region': "The Crypts (E1M7) Yellow"},
    371111: {'name': 'The Crypts (E1M7) - Map Scroll',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 231,
             'doom_type': 35,
             'region': "The Crypts (E1M7) Blue"},
    371112: {'name': 'The Crypts (E1M7) - Silver Shield 2',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': 232,
             'doom_type': 85,
             'region': "The Crypts (E1M7) Green"},
    371113: {'name': 'The Crypts (E1M7) - Exit',
             'episode': 1,
             'check_sanity': False,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "The Crypts (E1M7) Blue"},
    371114: {'name': "Hell's Maw (E1M8) - Ethereal Crossbow",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 10,
             'doom_type': 2001,
             'region': "Hell's Maw (E1M8) Main"},
    371115: {'name': "Hell's Maw (E1M8) - Dragon Claw",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 11,
             'doom_type': 53,
             'region': "Hell's Maw (E1M8) Main"},
    371116: {'name': "Hell's Maw (E1M8) - Tome of Power",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 63,
             'doom_type': 86,
             'region': "Hell's Maw (E1M8) Main"},
    371117: {'name': "Hell's Maw (E1M8) - Gauntlets of the Necromancer",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 64,
             'doom_type': 2005,
             'region': "Hell's Maw (E1M8) Main"},
    371118: {'name': "Hell's Maw (E1M8) - Tome of Power 2",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 65,
             'doom_type': 86,
             'region': "Hell's Maw (E1M8) Main"},
    371119: {'name': "Hell's Maw (E1M8) - Silver Shield",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 101,
             'doom_type': 85,
             'region': "Hell's Maw (E1M8) Main"},
    371120: {'name': "Hell's Maw (E1M8) - Shadowsphere",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 102,
             'doom_type': 75,
             'region': "Hell's Maw (E1M8) Main"},
    371121: {'name': "Hell's Maw (E1M8) - Ring of Invincibility",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 103,
             'doom_type': 84,
             'region': "Hell's Maw (E1M8) Main"},
    371122: {'name': "Hell's Maw (E1M8) - Bag of Holding",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 104,
             'doom_type': 8,
             'region': "Hell's Maw (E1M8) Main"},
    371123: {'name': "Hell's Maw (E1M8) - Ring of Invincibility 2",
             'episode': 1,
             'check_sanity': True,
             'map': 8,
             'index': 237,
             'doom_type': 84,
             'region': "Hell's Maw (E1M8) Main"},
    371124: {'name': "Hell's Maw (E1M8) - Bag of Holding 2",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 238,
             'doom_type': 8,
             'region': "Hell's Maw (E1M8) Main"},
    371125: {'name': "Hell's Maw (E1M8) - Ring of Invincibility 3",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 247,
             'doom_type': 84,
             'region': "Hell's Maw (E1M8) Main"},
    371126: {'name': "Hell's Maw (E1M8) - Morph Ovum",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': 290,
             'doom_type': 30,
             'region': "Hell's Maw (E1M8) Main"},
    371127: {'name': "Hell's Maw (E1M8) - Exit",
             'episode': 1,
             'check_sanity': False,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "Hell's Maw (E1M8) Main"},
    371128: {'name': 'The Graveyard (E1M9) - Yellow key',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 2,
             'doom_type': 80,
             'region': "The Graveyard (E1M9) Main"},
    371129: {'name': 'The Graveyard (E1M9) - Green key',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 21,
             'doom_type': 73,
             'region': "The Graveyard (E1M9) Yellow"},
    371130: {'name': 'The Graveyard (E1M9) - Blue key',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 22,
             'doom_type': 79,
             'region': "The Graveyard (E1M9) Green"},
    371131: {'name': 'The Graveyard (E1M9) - Bag of Holding',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 23,
             'doom_type': 8,
             'region': "The Graveyard (E1M9) Main"},
    371132: {'name': 'The Graveyard (E1M9) - Dragon Claw',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 109,
             'doom_type': 53,
             'region': "The Graveyard (E1M9) Yellow"},
    371133: {'name': 'The Graveyard (E1M9) - Ethereal Crossbow',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 110,
             'doom_type': 2001,
             'region': "The Graveyard (E1M9) Green"},
    371134: {'name': 'The Graveyard (E1M9) - Shadowsphere',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 128,
             'doom_type': 75,
             'region': "The Graveyard (E1M9) Green"},
    371135: {'name': 'The Graveyard (E1M9) - Silver Shield',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 129,
             'doom_type': 85,
             'region': "The Graveyard (E1M9) Main"},
    371136: {'name': 'The Graveyard (E1M9) - Ring of Invincibility',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 217,
             'doom_type': 84,
             'region': "The Graveyard (E1M9) Green"},
    371137: {'name': 'The Graveyard (E1M9) - Torch',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 253,
             'doom_type': 33,
             'region': "The Graveyard (E1M9) Green"},
    371138: {'name': 'The Graveyard (E1M9) - Tome of Power',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 254,
             'doom_type': 86,
             'region': "The Graveyard (E1M9) Main"},
    371139: {'name': 'The Graveyard (E1M9) - Morph Ovum',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 279,
             'doom_type': 30,
             'region': "The Graveyard (E1M9) Main"},
    371140: {'name': 'The Graveyard (E1M9) - Map Scroll',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 280,
             'doom_type': 35,
             'region': "The Graveyard (E1M9) Blue"},
    371141: {'name': 'The Graveyard (E1M9) - Dragon Claw 2',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 292,
             'doom_type': 53,
             'region': "The Graveyard (E1M9) Main"},
    371142: {'name': 'The Graveyard (E1M9) - Tome of Power 2',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': 339,
             'doom_type': 86,
             'region': "The Graveyard (E1M9) Green"},
    371143: {'name': 'The Graveyard (E1M9) - Exit',
             'episode': 1,
             'check_sanity': False,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "The Graveyard (E1M9) Blue"},
    371144: {'name': 'The Crater (E2M1) - Yellow key',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 8,
             'doom_type': 80,
             'region': "The Crater (E2M1) Main"},
    371145: {'name': 'The Crater (E2M1) - Green key',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 10,
             'doom_type': 73,
             'region': "The Crater (E2M1) Yellow"},
    371146: {'name': 'The Crater (E2M1) - Ethereal Crossbow',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 39,
             'doom_type': 2001,
             'region': "The Crater (E2M1) Main"},
    371147: {'name': 'The Crater (E2M1) - Tome of Power',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 49,
             'doom_type': 86,
             'region': "The Crater (E2M1) Main"},
    371148: {'name': 'The Crater (E2M1) - Dragon Claw',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 90,
             'doom_type': 53,
             'region': "The Crater (E2M1) Yellow"},
    371149: {'name': 'The Crater (E2M1) - Bag of Holding',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 98,
             'doom_type': 8,
             'region': "The Crater (E2M1) Yellow"},
    371150: {'name': 'The Crater (E2M1) - Hellstaff',
             'episode': 2,
             'check_sanity': True,
             'map': 1,
             'index': 103,
             'doom_type': 2004,
             'region': "The Crater (E2M1) Yellow"},
    371151: {'name': 'The Crater (E2M1) - Shadowsphere',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 141,
             'doom_type': 75,
             'region': "The Crater (E2M1) Yellow"},
    371152: {'name': 'The Crater (E2M1) - Silver Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 145,
             'doom_type': 85,
             'region': "The Crater (E2M1) Main"},
    371153: {'name': 'The Crater (E2M1) - Torch',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 146,
             'doom_type': 33,
             'region': "The Crater (E2M1) Main"},
    371154: {'name': 'The Crater (E2M1) - Mystic Urn',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': 236,
             'doom_type': 32,
             'region': "The Crater (E2M1) Yellow"},
    371155: {'name': 'The Crater (E2M1) - Exit',
             'episode': 2,
             'check_sanity': False,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "The Crater (E2M1) Green"},
    371156: {'name': 'The Lava Pits (E2M2) - Green key',
             'episode': 2,
             'check_sanity': True,
             'map': 2,
             'index': 8,
             'doom_type': 73,
             'region': "The Lava Pits (E2M2) Yellow"},
    371157: {'name': 'The Lava Pits (E2M2) - Yellow key',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 9,
             'doom_type': 80,
             'region': "The Lava Pits (E2M2) Main"},
    371158: {'name': 'The Lava Pits (E2M2) - Ethereal Crossbow',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 25,
             'doom_type': 2001,
             'region': "The Lava Pits (E2M2) Main"},
    371159: {'name': 'The Lava Pits (E2M2) - Shadowsphere',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 67,
             'doom_type': 75,
             'region': "The Lava Pits (E2M2) Main"},
    371160: {'name': 'The Lava Pits (E2M2) - Ring of Invincibility',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 98,
             'doom_type': 84,
             'region': "The Lava Pits (E2M2) Yellow"},
    371161: {'name': 'The Lava Pits (E2M2) - Dragon Claw',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 109,
             'doom_type': 53,
             'region': "The Lava Pits (E2M2) Yellow"},
    371162: {'name': 'The Lava Pits (E2M2) - Hellstaff',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 117,
             'doom_type': 2004,
             'region': "The Lava Pits (E2M2) Yellow"},
    371163: {'name': 'The Lava Pits (E2M2) - Bag of Holding',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 122,
             'doom_type': 8,
             'region': "The Lava Pits (E2M2) Green"},
    371164: {'name': 'The Lava Pits (E2M2) - Tome of Power',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 123,
             'doom_type': 86,
             'region': "The Lava Pits (E2M2) Yellow"},
    371165: {'name': 'The Lava Pits (E2M2) - Silver Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 124,
             'doom_type': 85,
             'region': "The Lava Pits (E2M2) Yellow"},
    371166: {'name': 'The Lava Pits (E2M2) - Gauntlets of the Necromancer',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 127,
             'doom_type': 2005,
             'region': "The Lava Pits (E2M2) Yellow"},
    371167: {'name': 'The Lava Pits (E2M2) - Enchanted Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 133,
             'doom_type': 31,
             'region': "The Lava Pits (E2M2) Green"},
    371168: {'name': 'The Lava Pits (E2M2) - Mystic Urn',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 230,
             'doom_type': 32,
             'region': "The Lava Pits (E2M2) Green"},
    371169: {'name': 'The Lava Pits (E2M2) - Map Scroll',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 232,
             'doom_type': 35,
             'region': "The Lava Pits (E2M2) Yellow"},
    371170: {'name': 'The Lava Pits (E2M2) - Tome of Power 2',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 233,
             'doom_type': 86,
             'region': "The Lava Pits (E2M2) Main"},
    371171: {'name': 'The Lava Pits (E2M2) - Chaos Device',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 234,
             'doom_type': 36,
             'region': "The Lava Pits (E2M2) Yellow"},
    371172: {'name': 'The Lava Pits (E2M2) - Tome of Power 3',
             'episode': 2,
             'check_sanity': True,
             'map': 2,
             'index': 323,
             'doom_type': 86,
             'region': "The Lava Pits (E2M2) Main"},
    371173: {'name': 'The Lava Pits (E2M2) - Silver Shield 2',
             'episode': 2,
             'check_sanity': True,
             'map': 2,
             'index': 324,
             'doom_type': 85,
             'region': "The Lava Pits (E2M2) Main"},
    371174: {'name': 'The Lava Pits (E2M2) - Bag of Holding 2',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 329,
             'doom_type': 8,
             'region': "The Lava Pits (E2M2) Main"},
    371175: {'name': 'The Lava Pits (E2M2) - Morph Ovum',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': 341,
             'doom_type': 30,
             'region': "The Lava Pits (E2M2) Yellow"},
    371176: {'name': 'The Lava Pits (E2M2) - Exit',
             'episode': 2,
             'check_sanity': False,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "The Lava Pits (E2M2) Green"},
    371177: {'name': 'The River of Fire (E2M3) - Yellow key',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 9,
             'doom_type': 80,
             'region': "The River of Fire (E2M3) Main"},
    371178: {'name': 'The River of Fire (E2M3) - Blue key',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 10,
             'doom_type': 79,
             'region': "The River of Fire (E2M3) Green"},
    371179: {'name': 'The River of Fire (E2M3) - Green key',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 17,
             'doom_type': 73,
             'region': "The River of Fire (E2M3) Yellow"},
    371180: {'name': 'The River of Fire (E2M3) - Gauntlets of the Necromancer',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 26,
             'doom_type': 2005,
             'region': "The River of Fire (E2M3) Main"},
    371181: {'name': 'The River of Fire (E2M3) - Ethereal Crossbow',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 57,
             'doom_type': 2001,
             'region': "The River of Fire (E2M3) Main"},
    371182: {'name': 'The River of Fire (E2M3) - Dragon Claw',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 92,
             'doom_type': 53,
             'region': "The River of Fire (E2M3) Main"},
    371183: {'name': 'The River of Fire (E2M3) - Phoenix Rod',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 122,
             'doom_type': 2003,
             'region': "The River of Fire (E2M3) Green"},
    371184: {'name': 'The River of Fire (E2M3) - Hellstaff',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 128,
             'doom_type': 2004,
             'region': "The River of Fire (E2M3) Blue"},
    371185: {'name': 'The River of Fire (E2M3) - Bag of Holding',
             'episode': 2,
             'check_sanity': True,
             'map': 3,
             'index': 136,
             'doom_type': 8,
             'region': "The River of Fire (E2M3) Blue"},
    371186: {'name': 'The River of Fire (E2M3) - Shadowsphere',
             'episode': 2,
             'check_sanity': True,
             'map': 3,
             'index': 145,
             'doom_type': 75,
             'region': "The River of Fire (E2M3) Green"},
    371187: {'name': 'The River of Fire (E2M3) - Tome of Power',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 146,
             'doom_type': 86,
             'region': "The River of Fire (E2M3) Main"},
    371188: {'name': 'The River of Fire (E2M3) - Ring of Invincibility',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 147,
             'doom_type': 84,
             'region': "The River of Fire (E2M3) Main"},
    371189: {'name': 'The River of Fire (E2M3) - Silver Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 148,
             'doom_type': 85,
             'region': "The River of Fire (E2M3) Main"},
    371190: {'name': 'The River of Fire (E2M3) - Enchanted Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 297,
             'doom_type': 31,
             'region': "The River of Fire (E2M3) Blue"},
    371191: {'name': 'The River of Fire (E2M3) - Chaos Device',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 298,
             'doom_type': 36,
             'region': "The River of Fire (E2M3) Blue"},
    371192: {'name': 'The River of Fire (E2M3) - Mystic Urn',
             'episode': 2,
             'check_sanity': True,
             'map': 3,
             'index': 299,
             'doom_type': 32,
             'region': "The River of Fire (E2M3) Green"},
    371193: {'name': 'The River of Fire (E2M3) - Morph Ovum',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 300,
             'doom_type': 30,
             'region': "The River of Fire (E2M3) Yellow"},
    371194: {'name': 'The River of Fire (E2M3) - Tome of Power 2',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 313,
             'doom_type': 86,
             'region': "The River of Fire (E2M3) Green"},
    371195: {'name': 'The River of Fire (E2M3) - Firemace',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': 413,
             'doom_type': 2002,
             'region': "The River of Fire (E2M3) Green"},
    371196: {'name': 'The River of Fire (E2M3) - Firemace 2',
             'episode': 2,
             'check_sanity': True,
             'map': 3,
             'index': 441,
             'doom_type': 2002,
             'region': "The River of Fire (E2M3) Yellow"},
    371197: {'name': 'The River of Fire (E2M3) - Firemace 3',
             'episode': 2,
             'check_sanity': True,
             'map': 3,
             'index': 448,
             'doom_type': 2002,
             'region': "The River of Fire (E2M3) Blue"},
    371198: {'name': 'The River of Fire (E2M3) - Exit',
             'episode': 2,
             'check_sanity': False,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "The River of Fire (E2M3) Blue"},
    371199: {'name': 'The Ice Grotto (E2M4) - Yellow key',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 18,
             'doom_type': 80,
             'region': "The Ice Grotto (E2M4) Main"},
    371200: {'name': 'The Ice Grotto (E2M4) - Blue key',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 19,
             'doom_type': 79,
             'region': "The Ice Grotto (E2M4) Green"},
    371201: {'name': 'The Ice Grotto (E2M4) - Green key',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 28,
             'doom_type': 73,
             'region': "The Ice Grotto (E2M4) Yellow"},
    371202: {'name': 'The Ice Grotto (E2M4) - Phoenix Rod',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 29,
             'doom_type': 2003,
             'region': "The Ice Grotto (E2M4) Yellow"},
    371203: {'name': 'The Ice Grotto (E2M4) - Gauntlets of the Necromancer',
             'episode': 2,
             'check_sanity': True,
             'map': 4,
             'index': 30,
             'doom_type': 2005,
             'region': "The Ice Grotto (E2M4) Main"},
    371204: {'name': 'The Ice Grotto (E2M4) - Ethereal Crossbow',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 31,
             'doom_type': 2001,
             'region': "The Ice Grotto (E2M4) Main"},
    371205: {'name': 'The Ice Grotto (E2M4) - Hellstaff',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 32,
             'doom_type': 2004,
             'region': "The Ice Grotto (E2M4) Blue"},
    371206: {'name': 'The Ice Grotto (E2M4) - Dragon Claw',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 33,
             'doom_type': 53,
             'region': "The Ice Grotto (E2M4) Green"},
    371207: {'name': 'The Ice Grotto (E2M4) - Torch',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 34,
             'doom_type': 33,
             'region': "The Ice Grotto (E2M4) Green"},
    371208: {'name': 'The Ice Grotto (E2M4) - Bag of Holding',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 35,
             'doom_type': 8,
             'region': "The Ice Grotto (E2M4) Main"},
    371209: {'name': 'The Ice Grotto (E2M4) - Shadowsphere',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 36,
             'doom_type': 75,
             'region': "The Ice Grotto (E2M4) Green"},
    371210: {'name': 'The Ice Grotto (E2M4) - Chaos Device',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 37,
             'doom_type': 36,
             'region': "The Ice Grotto (E2M4) Green"},
    371211: {'name': 'The Ice Grotto (E2M4) - Silver Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 38,
             'doom_type': 85,
             'region': "The Ice Grotto (E2M4) Main"},
    371212: {'name': 'The Ice Grotto (E2M4) - Tome of Power',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 39,
             'doom_type': 86,
             'region': "The Ice Grotto (E2M4) Green"},
    371213: {'name': 'The Ice Grotto (E2M4) - Tome of Power 2',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 40,
             'doom_type': 86,
             'region': "The Ice Grotto (E2M4) Main"},
    371214: {'name': 'The Ice Grotto (E2M4) - Bag of Holding 2',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 41,
             'doom_type': 8,
             'region': "The Ice Grotto (E2M4) Green"},
    371215: {'name': 'The Ice Grotto (E2M4) - Tome of Power 3',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 128,
             'doom_type': 86,
             'region': "The Ice Grotto (E2M4) Yellow"},
    371216: {'name': 'The Ice Grotto (E2M4) - Map Scroll',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 283,
             'doom_type': 35,
             'region': "The Ice Grotto (E2M4) Green"},
    371217: {'name': 'The Ice Grotto (E2M4) - Mystic Urn',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 289,
             'doom_type': 32,
             'region': "The Ice Grotto (E2M4) Magenta"},
    371218: {'name': 'The Ice Grotto (E2M4) - Enchanted Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 291,
             'doom_type': 31,
             'region': "The Ice Grotto (E2M4) Green"},
    371219: {'name': 'The Ice Grotto (E2M4) - Morph Ovum',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 299,
             'doom_type': 30,
             'region': "The Ice Grotto (E2M4) Main"},
    371220: {'name': 'The Ice Grotto (E2M4) - Shadowsphere 2',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': 300,
             'doom_type': 75,
             'region': "The Ice Grotto (E2M4) Main"},
    371221: {'name': 'The Ice Grotto (E2M4) - Exit',
             'episode': 2,
             'check_sanity': False,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "The Ice Grotto (E2M4) Blue"},
    371222: {'name': 'The Catacombs (E2M5) - Yellow key',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 14,
             'doom_type': 80,
             'region': "The Catacombs (E2M5) Main"},
    371223: {'name': 'The Catacombs (E2M5) - Blue key',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 25,
             'doom_type': 79,
             'region': "The Catacombs (E2M5) Green"},
    371224: {'name': 'The Catacombs (E2M5) - Hellstaff',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 27,
             'doom_type': 2004,
             'region': "The Catacombs (E2M5) Yellow"},
    371225: {'name': 'The Catacombs (E2M5) - Phoenix Rod',
             'episode': 2,
             'check_sanity': True,
             'map': 5,
             'index': 44,
             'doom_type': 2003,
             'region': "The Catacombs (E2M5) Green"},
    371226: {'name': 'The Catacombs (E2M5) - Ethereal Crossbow',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 107,
             'doom_type': 2001,
             'region': "The Catacombs (E2M5) Yellow"},
    371227: {'name': 'The Catacombs (E2M5) - Gauntlets of the Necromancer',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 108,
             'doom_type': 2005,
             'region': "The Catacombs (E2M5) Main"},
    371228: {'name': 'The Catacombs (E2M5) - Dragon Claw',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 109,
             'doom_type': 53,
             'region': "The Catacombs (E2M5) Main"},
    371229: {'name': 'The Catacombs (E2M5) - Bag of Holding',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 110,
             'doom_type': 8,
             'region': "The Catacombs (E2M5) Main"},
    371230: {'name': 'The Catacombs (E2M5) - Silver Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 112,
             'doom_type': 85,
             'region': "The Catacombs (E2M5) Yellow"},
    371231: {'name': 'The Catacombs (E2M5) - Shadowsphere',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 113,
             'doom_type': 75,
             'region': "The Catacombs (E2M5) Yellow"},
    371232: {'name': 'The Catacombs (E2M5) - Ring of Invincibility',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 114,
             'doom_type': 84,
             'region': "The Catacombs (E2M5) Yellow"},
    371233: {'name': 'The Catacombs (E2M5) - Tome of Power',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 115,
             'doom_type': 86,
             'region': "The Catacombs (E2M5) Yellow"},
    371234: {'name': 'The Catacombs (E2M5) - Green key',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 116,
             'doom_type': 73,
             'region': "The Catacombs (E2M5) Yellow"},
    371235: {'name': 'The Catacombs (E2M5) - Chaos Device',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 263,
             'doom_type': 36,
             'region': "The Catacombs (E2M5) Yellow"},
    371236: {'name': 'The Catacombs (E2M5) - Tome of Power 2',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 322,
             'doom_type': 86,
             'region': "The Catacombs (E2M5) Yellow"},
    371237: {'name': 'The Catacombs (E2M5) - Map Scroll',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 323,
             'doom_type': 35,
             'region': "The Catacombs (E2M5) Green"},
    371238: {'name': 'The Catacombs (E2M5) - Mystic Urn',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 324,
             'doom_type': 32,
             'region': "The Catacombs (E2M5) Yellow"},
    371239: {'name': 'The Catacombs (E2M5) - Morph Ovum',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 325,
             'doom_type': 30,
             'region': "The Catacombs (E2M5) Green"},
    371240: {'name': 'The Catacombs (E2M5) - Enchanted Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 326,
             'doom_type': 31,
             'region': "The Catacombs (E2M5) Green"},
    371241: {'name': 'The Catacombs (E2M5) - Torch',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 327,
             'doom_type': 33,
             'region': "The Catacombs (E2M5) Main"},
    371242: {'name': 'The Catacombs (E2M5) - Tome of Power 3',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': 328,
             'doom_type': 86,
             'region': "The Catacombs (E2M5) Yellow"},
    371243: {'name': 'The Catacombs (E2M5) - Exit',
             'episode': 2,
             'check_sanity': False,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "The Catacombs (E2M5) Blue"},
    371244: {'name': 'The Labyrinth (E2M6) - Yellow key',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 7,
             'doom_type': 80,
             'region': "The Labyrinth (E2M6) Main"},
    371245: {'name': 'The Labyrinth (E2M6) - Blue key',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 14,
             'doom_type': 79,
             'region': "The Labyrinth (E2M6) Green"},
    371246: {'name': 'The Labyrinth (E2M6) - Green key',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 15,
             'doom_type': 73,
             'region': "The Labyrinth (E2M6) Yellow"},
    371247: {'name': 'The Labyrinth (E2M6) - Hellstaff',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 22,
             'doom_type': 2004,
             'region': "The Labyrinth (E2M6) Green"},
    371248: {'name': 'The Labyrinth (E2M6) - Gauntlets of the Necromancer',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 23,
             'doom_type': 2005,
             'region': "The Labyrinth (E2M6) Main"},
    371249: {'name': 'The Labyrinth (E2M6) - Ethereal Crossbow',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 24,
             'doom_type': 2001,
             'region': "The Labyrinth (E2M6) Main"},
    371250: {'name': 'The Labyrinth (E2M6) - Dragon Claw',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 25,
             'doom_type': 53,
             'region': "The Labyrinth (E2M6) Yellow"},
    371251: {'name': 'The Labyrinth (E2M6) - Phoenix Rod',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 26,
             'doom_type': 2003,
             'region': "The Labyrinth (E2M6) Green"},
    371252: {'name': 'The Labyrinth (E2M6) - Bag of Holding',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 27,
             'doom_type': 8,
             'region': "The Labyrinth (E2M6) Yellow"},
    371253: {'name': 'The Labyrinth (E2M6) - Shadowsphere',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 31,
             'doom_type': 75,
             'region': "The Labyrinth (E2M6) Yellow"},
    371254: {'name': 'The Labyrinth (E2M6) - Ring of Invincibility',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 32,
             'doom_type': 84,
             'region': "The Labyrinth (E2M6) Blue"},
    371255: {'name': 'The Labyrinth (E2M6) - Tome of Power',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 33,
             'doom_type': 86,
             'region': "The Labyrinth (E2M6) Green"},
    371256: {'name': 'The Labyrinth (E2M6) - Silver Shield',
             'episode': 2,
             'check_sanity': True,
             'map': 6,
             'index': 34,
             'doom_type': 85,
             'region': "The Labyrinth (E2M6) Main"},
    371257: {'name': 'The Labyrinth (E2M6) - Morph Ovum',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 35,
             'doom_type': 30,
             'region': "The Labyrinth (E2M6) Main"},
    371258: {'name': 'The Labyrinth (E2M6) - Map Scroll',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 282,
             'doom_type': 35,
             'region': "The Labyrinth (E2M6) Green"},
    371259: {'name': 'The Labyrinth (E2M6) - Enchanted Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 283,
             'doom_type': 31,
             'region': "The Labyrinth (E2M6) Green"},
    371260: {'name': 'The Labyrinth (E2M6) - Tome of Power 2',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 284,
             'doom_type': 86,
             'region': "The Labyrinth (E2M6) Green"},
    371261: {'name': 'The Labyrinth (E2M6) - Chaos Device',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 285,
             'doom_type': 36,
             'region': "The Labyrinth (E2M6) Yellow"},
    371262: {'name': 'The Labyrinth (E2M6) - Mystic Urn',
             'episode': 2,
             'check_sanity': True,
             'map': 6,
             'index': 336,
             'doom_type': 32,
             'region': "The Labyrinth (E2M6) Blue"},
    371263: {'name': 'The Labyrinth (E2M6) - Phoenix Rod 2',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 422,
             'doom_type': 2003,
             'region': "The Labyrinth (E2M6) Blue"},
    371264: {'name': 'The Labyrinth (E2M6) - Firemace',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 432,
             'doom_type': 2002,
             'region': "The Labyrinth (E2M6) Main"},
    371265: {'name': 'The Labyrinth (E2M6) - Firemace 2',
             'episode': 2,
             'check_sanity': True,
             'map': 6,
             'index': 456,
             'doom_type': 2002,
             'region': "The Labyrinth (E2M6) Yellow"},
    371266: {'name': 'The Labyrinth (E2M6) - Firemace 3',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 457,
             'doom_type': 2002,
             'region': "The Labyrinth (E2M6) Yellow"},
    371267: {'name': 'The Labyrinth (E2M6) - Firemace 4',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': 458,
             'doom_type': 2002,
             'region': "The Labyrinth (E2M6) Blue"},
    371268: {'name': 'The Labyrinth (E2M6) - Exit',
             'episode': 2,
             'check_sanity': False,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "The Labyrinth (E2M6) Blue"},
    371269: {'name': 'The Great Hall (E2M7) - Green key',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 8,
             'doom_type': 73,
             'region': "The Great Hall (E2M7) Yellow"},
    371270: {'name': 'The Great Hall (E2M7) - Yellow key',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 9,
             'doom_type': 80,
             'region': "The Great Hall (E2M7) Main"},
    371271: {'name': 'The Great Hall (E2M7) - Blue key',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 11,
             'doom_type': 79,
             'region': "The Great Hall (E2M7) Green"},
    371272: {'name': 'The Great Hall (E2M7) - Morph Ovum',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 64,
             'doom_type': 30,
             'region': "The Great Hall (E2M7) Main"},
    371273: {'name': 'The Great Hall (E2M7) - Shadowsphere',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 76,
             'doom_type': 75,
             'region': "The Great Hall (E2M7) Main"},
    371274: {'name': 'The Great Hall (E2M7) - Ring of Invincibility',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 77,
             'doom_type': 84,
             'region': "The Great Hall (E2M7) Yellow"},
    371275: {'name': 'The Great Hall (E2M7) - Mystic Urn',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 78,
             'doom_type': 32,
             'region': "The Great Hall (E2M7) Blue"},
    371276: {'name': 'The Great Hall (E2M7) - Tome of Power',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 80,
             'doom_type': 86,
             'region': "The Great Hall (E2M7) Yellow"},
    371277: {'name': 'The Great Hall (E2M7) - Chaos Device',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 81,
             'doom_type': 36,
             'region': "The Great Hall (E2M7) Yellow"},
    371278: {'name': 'The Great Hall (E2M7) - Torch',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 82,
             'doom_type': 33,
             'region': "The Great Hall (E2M7) Main"},
    371279: {'name': 'The Great Hall (E2M7) - Bag of Holding',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 83,
             'doom_type': 8,
             'region': "The Great Hall (E2M7) Main"},
    371280: {'name': 'The Great Hall (E2M7) - Silver Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 84,
             'doom_type': 85,
             'region': "The Great Hall (E2M7) Main"},
    371281: {'name': 'The Great Hall (E2M7) - Enchanted Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 85,
             'doom_type': 31,
             'region': "The Great Hall (E2M7) Main"},
    371282: {'name': 'The Great Hall (E2M7) - Map Scroll',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 86,
             'doom_type': 35,
             'region': "The Great Hall (E2M7) Yellow"},
    371283: {'name': 'The Great Hall (E2M7) - Ethereal Crossbow',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 91,
             'doom_type': 2001,
             'region': "The Great Hall (E2M7) Main"},
    371284: {'name': 'The Great Hall (E2M7) - Gauntlets of the Necromancer',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 92,
             'doom_type': 2005,
             'region': "The Great Hall (E2M7) Main"},
    371285: {'name': 'The Great Hall (E2M7) - Dragon Claw',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 93,
             'doom_type': 53,
             'region': "The Great Hall (E2M7) Yellow"},
    371286: {'name': 'The Great Hall (E2M7) - Hellstaff',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 94,
             'doom_type': 2004,
             'region': "The Great Hall (E2M7) Yellow"},
    371287: {'name': 'The Great Hall (E2M7) - Phoenix Rod',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 95,
             'doom_type': 2003,
             'region': "The Great Hall (E2M7) Main"},
    371288: {'name': 'The Great Hall (E2M7) - Tome of Power 2',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': 477,
             'doom_type': 86,
             'region': "The Great Hall (E2M7) Main"},
    371289: {'name': 'The Great Hall (E2M7) - Exit',
             'episode': 2,
             'check_sanity': False,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "The Great Hall (E2M7) Blue"},
    371290: {'name': 'The Portals of Chaos (E2M8) - Ethereal Crossbow',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 9,
             'doom_type': 2001,
             'region': "The Portals of Chaos (E2M8) Main"},
    371291: {'name': 'The Portals of Chaos (E2M8) - Dragon Claw',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 10,
             'doom_type': 53,
             'region': "The Portals of Chaos (E2M8) Main"},
    371292: {'name': 'The Portals of Chaos (E2M8) - Gauntlets of the Necromancer',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 11,
             'doom_type': 2005,
             'region': "The Portals of Chaos (E2M8) Main"},
    371293: {'name': 'The Portals of Chaos (E2M8) - Hellstaff',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 12,
             'doom_type': 2004,
             'region': "The Portals of Chaos (E2M8) Main"},
    371294: {'name': 'The Portals of Chaos (E2M8) - Phoenix Rod',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 13,
             'doom_type': 2003,
             'region': "The Portals of Chaos (E2M8) Main"},
    371295: {'name': 'The Portals of Chaos (E2M8) - Tome of Power',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 14,
             'doom_type': 86,
             'region': "The Portals of Chaos (E2M8) Main"},
    371296: {'name': 'The Portals of Chaos (E2M8) - Bag of Holding',
             'episode': 2,
             'check_sanity': True,
             'map': 8,
             'index': 18,
             'doom_type': 8,
             'region': "The Portals of Chaos (E2M8) Main"},
    371297: {'name': 'The Portals of Chaos (E2M8) - Mystic Urn',
             'episode': 2,
             'check_sanity': True,
             'map': 8,
             'index': 40,
             'doom_type': 32,
             'region': "The Portals of Chaos (E2M8) Main"},
    371298: {'name': 'The Portals of Chaos (E2M8) - Shadowsphere',
             'episode': 2,
             'check_sanity': True,
             'map': 8,
             'index': 41,
             'doom_type': 75,
             'region': "The Portals of Chaos (E2M8) Main"},
    371299: {'name': 'The Portals of Chaos (E2M8) - Silver Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 42,
             'doom_type': 85,
             'region': "The Portals of Chaos (E2M8) Main"},
    371300: {'name': 'The Portals of Chaos (E2M8) - Enchanted Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 43,
             'doom_type': 31,
             'region': "The Portals of Chaos (E2M8) Main"},
    371301: {'name': 'The Portals of Chaos (E2M8) - Chaos Device',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 44,
             'doom_type': 36,
             'region': "The Portals of Chaos (E2M8) Main"},
    371302: {'name': 'The Portals of Chaos (E2M8) - Ring of Invincibility',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 272,
             'doom_type': 84,
             'region': "The Portals of Chaos (E2M8) Main"},
    371303: {'name': 'The Portals of Chaos (E2M8) - Morph Ovum',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': 274,
             'doom_type': 30,
             'region': "The Portals of Chaos (E2M8) Main"},
    371304: {'name': 'The Portals of Chaos (E2M8) - Mystic Urn 2',
             'episode': 2,
             'check_sanity': True,
             'map': 8,
             'index': 275,
             'doom_type': 32,
             'region': "The Portals of Chaos (E2M8) Main"},
    371305: {'name': 'The Portals of Chaos (E2M8) - Exit',
             'episode': 2,
             'check_sanity': False,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "The Portals of Chaos (E2M8) Main"},
    371306: {'name': 'The Glacier (E2M9) - Yellow key',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 6,
             'doom_type': 80,
             'region': "The Glacier (E2M9) Main"},
    371307: {'name': 'The Glacier (E2M9) - Blue key',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 16,
             'doom_type': 79,
             'region': "The Glacier (E2M9) Green"},
    371308: {'name': 'The Glacier (E2M9) - Green key',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 17,
             'doom_type': 73,
             'region': "The Glacier (E2M9) Yellow"},
    371309: {'name': 'The Glacier (E2M9) - Phoenix Rod',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 34,
             'doom_type': 2003,
             'region': "The Glacier (E2M9) Green"},
    371310: {'name': 'The Glacier (E2M9) - Gauntlets of the Necromancer',
             'episode': 2,
             'check_sanity': True,
             'map': 9,
             'index': 39,
             'doom_type': 2005,
             'region': "The Glacier (E2M9) Main"},
    371311: {'name': 'The Glacier (E2M9) - Ethereal Crossbow',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 40,
             'doom_type': 2001,
             'region': "The Glacier (E2M9) Main"},
    371312: {'name': 'The Glacier (E2M9) - Dragon Claw',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 41,
             'doom_type': 53,
             'region': "The Glacier (E2M9) Yellow"},
    371313: {'name': 'The Glacier (E2M9) - Hellstaff',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 42,
             'doom_type': 2004,
             'region': "The Glacier (E2M9) Green"},
    371314: {'name': 'The Glacier (E2M9) - Bag of Holding',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 43,
             'doom_type': 8,
             'region': "The Glacier (E2M9) Main"},
    371315: {'name': 'The Glacier (E2M9) - Tome of Power',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 45,
             'doom_type': 86,
             'region': "The Glacier (E2M9) Main"},
    371316: {'name': 'The Glacier (E2M9) - Shadowsphere',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 46,
             'doom_type': 75,
             'region': "The Glacier (E2M9) Main"},
    371317: {'name': 'The Glacier (E2M9) - Ring of Invincibility',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 47,
             'doom_type': 84,
             'region': "The Glacier (E2M9) Green"},
    371318: {'name': 'The Glacier (E2M9) - Silver Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 48,
             'doom_type': 85,
             'region': "The Glacier (E2M9) Main"},
    371319: {'name': 'The Glacier (E2M9) - Enchanted Shield',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 49,
             'doom_type': 31,
             'region': "The Glacier (E2M9) Green"},
    371320: {'name': 'The Glacier (E2M9) - Mystic Urn',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 50,
             'doom_type': 32,
             'region': "The Glacier (E2M9) Blue"},
    371321: {'name': 'The Glacier (E2M9) - Map Scroll',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 51,
             'doom_type': 35,
             'region': "The Glacier (E2M9) Blue"},
    371322: {'name': 'The Glacier (E2M9) - Mystic Urn 2',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 52,
             'doom_type': 32,
             'region': "The Glacier (E2M9) Green"},
    371323: {'name': 'The Glacier (E2M9) - Torch',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 53,
             'doom_type': 33,
             'region': "The Glacier (E2M9) Green"},
    371324: {'name': 'The Glacier (E2M9) - Chaos Device',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 424,
             'doom_type': 36,
             'region': "The Glacier (E2M9) Yellow"},
    371325: {'name': 'The Glacier (E2M9) - Dragon Claw 2',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 456,
             'doom_type': 53,
             'region': "The Glacier (E2M9) Main"},
    371326: {'name': 'The Glacier (E2M9) - Tome of Power 2',
             'episode': 2,
             'check_sanity': True,
             'map': 9,
             'index': 457,
             'doom_type': 86,
             'region': "The Glacier (E2M9) Main"},
    371327: {'name': 'The Glacier (E2M9) - Torch 2',
             'episode': 2,
             'check_sanity': True,
             'map': 9,
             'index': 458,
             'doom_type': 33,
             'region': "The Glacier (E2M9) Main"},
    371328: {'name': 'The Glacier (E2M9) - Morph Ovum',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 474,
             'doom_type': 30,
             'region': "The Glacier (E2M9) Main"},
    371329: {'name': 'The Glacier (E2M9) - Firemace',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 479,
             'doom_type': 2002,
             'region': "The Glacier (E2M9) Main"},
    371330: {'name': 'The Glacier (E2M9) - Firemace 2',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 501,
             'doom_type': 2002,
             'region': "The Glacier (E2M9) Yellow"},
    371331: {'name': 'The Glacier (E2M9) - Firemace 3',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 502,
             'doom_type': 2002,
             'region': "The Glacier (E2M9) Blue"},
    371332: {'name': 'The Glacier (E2M9) - Firemace 4',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': 503,
             'doom_type': 2002,
             'region': "The Glacier (E2M9) Main"},
    371333: {'name': 'The Glacier (E2M9) - Exit',
             'episode': 2,
             'check_sanity': False,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "The Glacier (E2M9) Blue"},
    371334: {'name': 'The Storehouse (E3M1) - Yellow key',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 9,
             'doom_type': 80,
             'region': "The Storehouse (E3M1) Main"},
    371335: {'name': 'The Storehouse (E3M1) - Green key',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 10,
             'doom_type': 73,
             'region': "The Storehouse (E3M1) Yellow"},
    371336: {'name': 'The Storehouse (E3M1) - Bag of Holding',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 29,
             'doom_type': 8,
             'region': "The Storehouse (E3M1) Main"},
    371337: {'name': 'The Storehouse (E3M1) - Shadowsphere',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 38,
             'doom_type': 75,
             'region': "The Storehouse (E3M1) Main"},
    371338: {'name': 'The Storehouse (E3M1) - Ring of Invincibility',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 39,
             'doom_type': 84,
             'region': "The Storehouse (E3M1) Green"},
    371339: {'name': 'The Storehouse (E3M1) - Silver Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 40,
             'doom_type': 85,
             'region': "The Storehouse (E3M1) Main"},
    371340: {'name': 'The Storehouse (E3M1) - Map Scroll',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 41,
             'doom_type': 35,
             'region': "The Storehouse (E3M1) Green"},
    371341: {'name': 'The Storehouse (E3M1) - Chaos Device',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 42,
             'doom_type': 36,
             'region': "The Storehouse (E3M1) Main"},
    371342: {'name': 'The Storehouse (E3M1) - Tome of Power',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 43,
             'doom_type': 86,
             'region': "The Storehouse (E3M1) Green"},
    371343: {'name': 'The Storehouse (E3M1) - Torch',
             'episode': 3,
             'check_sanity': True,
             'map': 1,
             'index': 44,
             'doom_type': 33,
             'region': "The Storehouse (E3M1) Main"},
    371344: {'name': 'The Storehouse (E3M1) - Dragon Claw',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 45,
             'doom_type': 53,
             'region': "The Storehouse (E3M1) Main"},
    371345: {'name': 'The Storehouse (E3M1) - Hellstaff',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 46,
             'doom_type': 2004,
             'region': "The Storehouse (E3M1) Green"},
    371346: {'name': 'The Storehouse (E3M1) - Gauntlets of the Necromancer',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': 47,
             'doom_type': 2005,
             'region': "The Storehouse (E3M1) Main"},
    371347: {'name': 'The Storehouse (E3M1) - Exit',
             'episode': 3,
             'check_sanity': False,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "The Storehouse (E3M1) Green"},
    371348: {'name': 'The Cesspool (E3M2) - Yellow key',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 4,
             'doom_type': 80,
             'region': "The Cesspool (E3M2) Main"},
    371349: {'name': 'The Cesspool (E3M2) - Green key',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 19,
             'doom_type': 73,
             'region': "The Cesspool (E3M2) Yellow"},
    371350: {'name': 'The Cesspool (E3M2) - Blue key',
             'episode': 3,
             'check_sanity': True,
             'map': 2,
             'index': 20,
             'doom_type': 79,
             'region': "The Cesspool (E3M2) Green"},
    371351: {'name': 'The Cesspool (E3M2) - Ethereal Crossbow',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 144,
             'doom_type': 2001,
             'region': "The Cesspool (E3M2) Main"},
    371352: {'name': 'The Cesspool (E3M2) - Ring of Invincibility',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 145,
             'doom_type': 84,
             'region': "The Cesspool (E3M2) Green"},
    371353: {'name': 'The Cesspool (E3M2) - Gauntlets of the Necromancer',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 146,
             'doom_type': 2005,
             'region': "The Cesspool (E3M2) Green"},
    371354: {'name': 'The Cesspool (E3M2) - Dragon Claw',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 147,
             'doom_type': 53,
             'region': "The Cesspool (E3M2) Yellow"},
    371355: {'name': 'The Cesspool (E3M2) - Phoenix Rod',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 148,
             'doom_type': 2003,
             'region': "The Cesspool (E3M2) Green"},
    371356: {'name': 'The Cesspool (E3M2) - Hellstaff',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 149,
             'doom_type': 2004,
             'region': "The Cesspool (E3M2) Yellow"},
    371357: {'name': 'The Cesspool (E3M2) - Bag of Holding',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 150,
             'doom_type': 8,
             'region': "The Cesspool (E3M2) Yellow"},
    371358: {'name': 'The Cesspool (E3M2) - Silver Shield',
             'episode': 3,
             'check_sanity': True,
             'map': 2,
             'index': 151,
             'doom_type': 85,
             'region': "The Cesspool (E3M2) Yellow"},
    371359: {'name': 'The Cesspool (E3M2) - Silver Shield 2',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 152,
             'doom_type': 85,
             'region': "The Cesspool (E3M2) Main"},
    371360: {'name': 'The Cesspool (E3M2) - Morph Ovum',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 153,
             'doom_type': 30,
             'region': "The Cesspool (E3M2) Main"},
    371361: {'name': 'The Cesspool (E3M2) - Morph Ovum 2',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 154,
             'doom_type': 30,
             'region': "The Cesspool (E3M2) Green"},
    371362: {'name': 'The Cesspool (E3M2) - Mystic Urn',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 164,
             'doom_type': 32,
             'region': "The Cesspool (E3M2) Main"},
    371363: {'name': 'The Cesspool (E3M2) - Shadowsphere',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 165,
             'doom_type': 75,
             'region': "The Cesspool (E3M2) Yellow"},
    371364: {'name': 'The Cesspool (E3M2) - Enchanted Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 166,
             'doom_type': 31,
             'region': "The Cesspool (E3M2) Green"},
    371365: {'name': 'The Cesspool (E3M2) - Map Scroll',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 167,
             'doom_type': 35,
             'region': "The Cesspool (E3M2) Green"},
    371366: {'name': 'The Cesspool (E3M2) - Chaos Device',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 168,
             'doom_type': 36,
             'region': "The Cesspool (E3M2) Green"},
    371367: {'name': 'The Cesspool (E3M2) - Tome of Power',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 169,
             'doom_type': 86,
             'region': "The Cesspool (E3M2) Main"},
    371368: {'name': 'The Cesspool (E3M2) - Tome of Power 2',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 170,
             'doom_type': 86,
             'region': "The Cesspool (E3M2) Green"},
    371369: {'name': 'The Cesspool (E3M2) - Tome of Power 3',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 171,
             'doom_type': 86,
             'region': "The Cesspool (E3M2) Yellow"},
    371370: {'name': 'The Cesspool (E3M2) - Torch',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 172,
             'doom_type': 33,
             'region': "The Cesspool (E3M2) Yellow"},
    371371: {'name': 'The Cesspool (E3M2) - Bag of Holding 2',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 233,
             'doom_type': 8,
             'region': "The Cesspool (E3M2) Green"},
    371372: {'name': 'The Cesspool (E3M2) - Firemace',
             'episode': 3,
             'check_sanity': True,
             'map': 2,
             'index': 555,
             'doom_type': 2002,
             'region': "The Cesspool (E3M2) Green"},
    371373: {'name': 'The Cesspool (E3M2) - Firemace 2',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 556,
             'doom_type': 2002,
             'region': "The Cesspool (E3M2) Yellow"},
    371374: {'name': 'The Cesspool (E3M2) - Firemace 3',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 557,
             'doom_type': 2002,
             'region': "The Cesspool (E3M2) Blue"},
    371375: {'name': 'The Cesspool (E3M2) - Firemace 4',
             'episode': 3,
             'check_sanity': True,
             'map': 2,
             'index': 558,
             'doom_type': 2002,
             'region': "The Cesspool (E3M2) Main"},
    371376: {'name': 'The Cesspool (E3M2) - Firemace 5',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': 559,
             'doom_type': 2002,
             'region': "The Cesspool (E3M2) Yellow"},
    371377: {'name': 'The Cesspool (E3M2) - Exit',
             'episode': 3,
             'check_sanity': False,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "The Cesspool (E3M2) Blue"},
    371378: {'name': 'The Confluence (E3M3) - Yellow key',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 4,
             'doom_type': 80,
             'region': "The Confluence (E3M3) Main"},
    371379: {'name': 'The Confluence (E3M3) - Green key',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 7,
             'doom_type': 73,
             'region': "The Confluence (E3M3) Yellow"},
    371380: {'name': 'The Confluence (E3M3) - Blue key',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 8,
             'doom_type': 79,
             'region': "The Confluence (E3M3) Green"},
    371381: {'name': 'The Confluence (E3M3) - Hellstaff',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 43,
             'doom_type': 2004,
             'region': "The Confluence (E3M3) Blue"},
    371382: {'name': 'The Confluence (E3M3) - Tome of Power',
             'episode': 3,
             'check_sanity': True,
             'map': 3,
             'index': 44,
             'doom_type': 86,
             'region': "The Confluence (E3M3) Blue"},
    371383: {'name': 'The Confluence (E3M3) - Dragon Claw',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 47,
             'doom_type': 53,
             'region': "The Confluence (E3M3) Green"},
    371384: {'name': 'The Confluence (E3M3) - Ethereal Crossbow',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 48,
             'doom_type': 2001,
             'region': "The Confluence (E3M3) Yellow"},
    371385: {'name': 'The Confluence (E3M3) - Hellstaff 2',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 49,
             'doom_type': 2004,
             'region': "The Confluence (E3M3) Blue"},
    371386: {'name': 'The Confluence (E3M3) - Gauntlets of the Necromancer',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 50,
             'doom_type': 2005,
             'region': "The Confluence (E3M3) Blue"},
    371387: {'name': 'The Confluence (E3M3) - Mystic Urn',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 51,
             'doom_type': 32,
             'region': "The Confluence (E3M3) Green"},
    371388: {'name': 'The Confluence (E3M3) - Tome of Power 2',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 52,
             'doom_type': 86,
             'region': "The Confluence (E3M3) Green"},
    371389: {'name': 'The Confluence (E3M3) - Tome of Power 3',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 53,
             'doom_type': 86,
             'region': "The Confluence (E3M3) Blue"},
    371390: {'name': 'The Confluence (E3M3) - Tome of Power 4',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 54,
             'doom_type': 86,
             'region': "The Confluence (E3M3) Blue"},
    371391: {'name': 'The Confluence (E3M3) - Tome of Power 5',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 55,
             'doom_type': 86,
             'region': "The Confluence (E3M3) Green"},
    371392: {'name': 'The Confluence (E3M3) - Bag of Holding',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 58,
             'doom_type': 8,
             'region': "The Confluence (E3M3) Green"},
    371393: {'name': 'The Confluence (E3M3) - Morph Ovum',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 60,
             'doom_type': 30,
             'region': "The Confluence (E3M3) Green"},
    371394: {'name': 'The Confluence (E3M3) - Mystic Urn 2',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 72,
             'doom_type': 32,
             'region': "The Confluence (E3M3) Blue"},
    371395: {'name': 'The Confluence (E3M3) - Shadowsphere',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 73,
             'doom_type': 75,
             'region': "The Confluence (E3M3) Main"},
    371396: {'name': 'The Confluence (E3M3) - Ring of Invincibility',
             'episode': 3,
             'check_sanity': True,
             'map': 3,
             'index': 74,
             'doom_type': 84,
             'region': "The Confluence (E3M3) Yellow"},
    371397: {'name': 'The Confluence (E3M3) - Map Scroll',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 75,
             'doom_type': 35,
             'region': "The Confluence (E3M3) Blue"},
    371398: {'name': 'The Confluence (E3M3) - Silver Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 76,
             'doom_type': 85,
             'region': "The Confluence (E3M3) Main"},
    371399: {'name': 'The Confluence (E3M3) - Phoenix Rod',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 77,
             'doom_type': 2003,
             'region': "The Confluence (E3M3) Blue"},
    371400: {'name': 'The Confluence (E3M3) - Enchanted Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 78,
             'doom_type': 31,
             'region': "The Confluence (E3M3) Blue"},
    371401: {'name': 'The Confluence (E3M3) - Silver Shield 2',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 79,
             'doom_type': 85,
             'region': "The Confluence (E3M3) Green"},
    371402: {'name': 'The Confluence (E3M3) - Chaos Device',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 80,
             'doom_type': 36,
             'region': "The Confluence (E3M3) Green"},
    371403: {'name': 'The Confluence (E3M3) - Torch',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 81,
             'doom_type': 33,
             'region': "The Confluence (E3M3) Green"},
    371404: {'name': 'The Confluence (E3M3) - Firemace',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 622,
             'doom_type': 2002,
             'region': "The Confluence (E3M3) Green"},
    371405: {'name': 'The Confluence (E3M3) - Firemace 2',
             'episode': 3,
             'check_sanity': True,
             'map': 3,
             'index': 623,
             'doom_type': 2002,
             'region': "The Confluence (E3M3) Green"},
    371406: {'name': 'The Confluence (E3M3) - Firemace 3',
             'episode': 3,
             'check_sanity': True,
             'map': 3,
             'index': 624,
             'doom_type': 2002,
             'region': "The Confluence (E3M3) Yellow"},
    371407: {'name': 'The Confluence (E3M3) - Firemace 4',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 625,
             'doom_type': 2002,
             'region': "The Confluence (E3M3) Blue"},
    371408: {'name': 'The Confluence (E3M3) - Firemace 5',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': 626,
             'doom_type': 2002,
             'region': "The Confluence (E3M3) Blue"},
    371409: {'name': 'The Confluence (E3M3) - Firemace 6',
             'episode': 3,
             'check_sanity': True,
             'map': 3,
             'index': 627,
             'doom_type': 2002,
             'region': "The Confluence (E3M3) Blue"},
    371410: {'name': 'The Confluence (E3M3) - Exit',
             'episode': 3,
             'check_sanity': False,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "The Confluence (E3M3) Blue"},
    371411: {'name': 'The Azure Fortress (E3M4) - Yellow key',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 6,
             'doom_type': 80,
             'region': "The Azure Fortress (E3M4) Main"},
    371412: {'name': 'The Azure Fortress (E3M4) - Green key',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 21,
             'doom_type': 73,
             'region': "The Azure Fortress (E3M4) Yellow"},
    371413: {'name': 'The Azure Fortress (E3M4) - Dragon Claw',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 51,
             'doom_type': 53,
             'region': "The Azure Fortress (E3M4) Main"},
    371414: {'name': 'The Azure Fortress (E3M4) - Ring of Invincibility',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 52,
             'doom_type': 84,
             'region': "The Azure Fortress (E3M4) Main"},
    371415: {'name': 'The Azure Fortress (E3M4) - Ethereal Crossbow',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 53,
             'doom_type': 2001,
             'region': "The Azure Fortress (E3M4) Main"},
    371416: {'name': 'The Azure Fortress (E3M4) - Gauntlets of the Necromancer',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 54,
             'doom_type': 2005,
             'region': "The Azure Fortress (E3M4) Main"},
    371417: {'name': 'The Azure Fortress (E3M4) - Hellstaff',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 55,
             'doom_type': 2004,
             'region': "The Azure Fortress (E3M4) Yellow"},
    371418: {'name': 'The Azure Fortress (E3M4) - Phoenix Rod',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 56,
             'doom_type': 2003,
             'region': "The Azure Fortress (E3M4) Green"},
    371419: {'name': 'The Azure Fortress (E3M4) - Bag of Holding',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 58,
             'doom_type': 8,
             'region': "The Azure Fortress (E3M4) Main"},
    371420: {'name': 'The Azure Fortress (E3M4) - Bag of Holding 2',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 59,
             'doom_type': 8,
             'region': "The Azure Fortress (E3M4) Green"},
    371421: {'name': 'The Azure Fortress (E3M4) - Morph Ovum',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 60,
             'doom_type': 30,
             'region': "The Azure Fortress (E3M4) Main"},
    371422: {'name': 'The Azure Fortress (E3M4) - Mystic Urn',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 61,
             'doom_type': 32,
             'region': "The Azure Fortress (E3M4) Main"},
    371423: {'name': 'The Azure Fortress (E3M4) - Shadowsphere',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 62,
             'doom_type': 75,
             'region': "The Azure Fortress (E3M4) Main"},
    371424: {'name': 'The Azure Fortress (E3M4) - Silver Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 63,
             'doom_type': 85,
             'region': "The Azure Fortress (E3M4) Main"},
    371425: {'name': 'The Azure Fortress (E3M4) - Silver Shield 2',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 64,
             'doom_type': 85,
             'region': "The Azure Fortress (E3M4) Green"},
    371426: {'name': 'The Azure Fortress (E3M4) - Enchanted Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 65,
             'doom_type': 31,
             'region': "The Azure Fortress (E3M4) Green"},
    371427: {'name': 'The Azure Fortress (E3M4) - Map Scroll',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 66,
             'doom_type': 35,
             'region': "The Azure Fortress (E3M4) Green"},
    371428: {'name': 'The Azure Fortress (E3M4) - Chaos Device',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 67,
             'doom_type': 36,
             'region': "The Azure Fortress (E3M4) Yellow"},
    371429: {'name': 'The Azure Fortress (E3M4) - Tome of Power',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 68,
             'doom_type': 86,
             'region': "The Azure Fortress (E3M4) Green"},
    371430: {'name': 'The Azure Fortress (E3M4) - Torch',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 69,
             'doom_type': 33,
             'region': "The Azure Fortress (E3M4) Main"},
    371431: {'name': 'The Azure Fortress (E3M4) - Torch 2',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 70,
             'doom_type': 33,
             'region': "The Azure Fortress (E3M4) Green"},
    371432: {'name': 'The Azure Fortress (E3M4) - Torch 3',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 71,
             'doom_type': 33,
             'region': "The Azure Fortress (E3M4) Yellow"},
    371433: {'name': 'The Azure Fortress (E3M4) - Tome of Power 2',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 72,
             'doom_type': 86,
             'region': "The Azure Fortress (E3M4) Main"},
    371434: {'name': 'The Azure Fortress (E3M4) - Tome of Power 3',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 73,
             'doom_type': 86,
             'region': "The Azure Fortress (E3M4) Main"},
    371435: {'name': 'The Azure Fortress (E3M4) - Enchanted Shield 2',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 75,
             'doom_type': 31,
             'region': "The Azure Fortress (E3M4) Yellow"},
    371436: {'name': 'The Azure Fortress (E3M4) - Morph Ovum 2',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 76,
             'doom_type': 30,
             'region': "The Azure Fortress (E3M4) Yellow"},
    371437: {'name': 'The Azure Fortress (E3M4) - Mystic Urn 2',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': 577,
             'doom_type': 32,
             'region': "The Azure Fortress (E3M4) Green"},
    371438: {'name': 'The Azure Fortress (E3M4) - Exit',
             'episode': 3,
             'check_sanity': False,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "The Azure Fortress (E3M4) Green"},
    371439: {'name': 'The Ophidian Lair (E3M5) - Yellow key',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 16,
             'doom_type': 80,
             'region': "The Ophidian Lair (E3M5) Main"},
    371440: {'name': 'The Ophidian Lair (E3M5) - Green key',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 30,
             'doom_type': 73,
             'region': "The Ophidian Lair (E3M5) Yellow"},
    371441: {'name': 'The Ophidian Lair (E3M5) - Hellstaff',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 48,
             'doom_type': 2004,
             'region': "The Ophidian Lair (E3M5) Main"},
    371442: {'name': 'The Ophidian Lair (E3M5) - Phoenix Rod',
             'episode': 3,
             'check_sanity': True,
             'map': 5,
             'index': 49,
             'doom_type': 2003,
             'region': "The Ophidian Lair (E3M5) Main"},
    371443: {'name': 'The Ophidian Lair (E3M5) - Dragon Claw',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 50,
             'doom_type': 53,
             'region': "The Ophidian Lair (E3M5) Yellow"},
    371444: {'name': 'The Ophidian Lair (E3M5) - Gauntlets of the Necromancer',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 51,
             'doom_type': 2005,
             'region': "The Ophidian Lair (E3M5) Yellow"},
    371445: {'name': 'The Ophidian Lair (E3M5) - Bag of Holding',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 52,
             'doom_type': 8,
             'region': "The Ophidian Lair (E3M5) Yellow"},
    371446: {'name': 'The Ophidian Lair (E3M5) - Morph Ovum',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 53,
             'doom_type': 30,
             'region': "The Ophidian Lair (E3M5) Yellow"},
    371447: {'name': 'The Ophidian Lair (E3M5) - Ethereal Crossbow',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 62,
             'doom_type': 2001,
             'region': "The Ophidian Lair (E3M5) Main"},
    371448: {'name': 'The Ophidian Lair (E3M5) - Mystic Urn',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 63,
             'doom_type': 32,
             'region': "The Ophidian Lair (E3M5) Green"},
    371449: {'name': 'The Ophidian Lair (E3M5) - Shadowsphere',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 64,
             'doom_type': 75,
             'region': "The Ophidian Lair (E3M5) Yellow"},
    371450: {'name': 'The Ophidian Lair (E3M5) - Ring of Invincibility',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 65,
             'doom_type': 84,
             'region': "The Ophidian Lair (E3M5) Main"},
    371451: {'name': 'The Ophidian Lair (E3M5) - Silver Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 66,
             'doom_type': 85,
             'region': "The Ophidian Lair (E3M5) Main"},
    371452: {'name': 'The Ophidian Lair (E3M5) - Enchanted Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 67,
             'doom_type': 31,
             'region': "The Ophidian Lair (E3M5) Main"},
    371453: {'name': 'The Ophidian Lair (E3M5) - Silver Shield 2',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 68,
             'doom_type': 85,
             'region': "The Ophidian Lair (E3M5) Green"},
    371454: {'name': 'The Ophidian Lair (E3M5) - Map Scroll',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 69,
             'doom_type': 35,
             'region': "The Ophidian Lair (E3M5) Green"},
    371455: {'name': 'The Ophidian Lair (E3M5) - Chaos Device',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 70,
             'doom_type': 36,
             'region': "The Ophidian Lair (E3M5) Yellow"},
    371456: {'name': 'The Ophidian Lair (E3M5) - Torch',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 71,
             'doom_type': 33,
             'region': "The Ophidian Lair (E3M5) Main"},
    371457: {'name': 'The Ophidian Lair (E3M5) - Tome of Power',
             'episode': 3,
             'check_sanity': True,
             'map': 5,
             'index': 72,
             'doom_type': 86,
             'region': "The Ophidian Lair (E3M5) Main"},
    371458: {'name': 'The Ophidian Lair (E3M5) - Mystic Urn 2',
             'episode': 3,
             'check_sanity': True,
             'map': 5,
             'index': 73,
             'doom_type': 32,
             'region': "The Ophidian Lair (E3M5) Main"},
    371459: {'name': 'The Ophidian Lair (E3M5) - Tome of Power 2',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': 74,
             'doom_type': 86,
             'region': "The Ophidian Lair (E3M5) Main"},
    371460: {'name': 'The Ophidian Lair (E3M5) - Exit',
             'episode': 3,
             'check_sanity': False,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "The Ophidian Lair (E3M5) Green"},
    371461: {'name': 'The Halls of Fear (E3M6) - Yellow key',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 10,
             'doom_type': 80,
             'region': "The Halls of Fear (E3M6) Main"},
    371462: {'name': 'The Halls of Fear (E3M6) - Green key',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 12,
             'doom_type': 73,
             'region': "The Halls of Fear (E3M6) Yellow"},
    371463: {'name': 'The Halls of Fear (E3M6) - Blue key',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 15,
             'doom_type': 79,
             'region': "The Halls of Fear (E3M6) Green"},
    371464: {'name': 'The Halls of Fear (E3M6) - Hellstaff',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 31,
             'doom_type': 2004,
             'region': "The Halls of Fear (E3M6) Green"},
    371465: {'name': 'The Halls of Fear (E3M6) - Phoenix Rod',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 32,
             'doom_type': 2003,
             'region': "The Halls of Fear (E3M6) Cyan"},
    371466: {'name': 'The Halls of Fear (E3M6) - Ethereal Crossbow',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 33,
             'doom_type': 2001,
             'region': "The Halls of Fear (E3M6) Main"},
    371467: {'name': 'The Halls of Fear (E3M6) - Dragon Claw',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 34,
             'doom_type': 53,
             'region': "The Halls of Fear (E3M6) Main"},
    371468: {'name': 'The Halls of Fear (E3M6) - Gauntlets of the Necromancer',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 35,
             'doom_type': 2005,
             'region': "The Halls of Fear (E3M6) Yellow"},
    371469: {'name': 'The Halls of Fear (E3M6) - Chaos Device',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 38,
             'doom_type': 36,
             'region': "The Halls of Fear (E3M6) Green"},
    371470: {'name': 'The Halls of Fear (E3M6) - Bag of Holding',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 40,
             'doom_type': 8,
             'region': "The Halls of Fear (E3M6) Blue"},
    371471: {'name': 'The Halls of Fear (E3M6) - Bag of Holding 2',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 41,
             'doom_type': 8,
             'region': "The Halls of Fear (E3M6) Blue"},
    371472: {'name': 'The Halls of Fear (E3M6) - Morph Ovum',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 42,
             'doom_type': 30,
             'region': "The Halls of Fear (E3M6) Yellow"},
    371473: {'name': 'The Halls of Fear (E3M6) - Mystic Urn',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 51,
             'doom_type': 32,
             'region': "The Halls of Fear (E3M6) Yellow"},
    371474: {'name': 'The Halls of Fear (E3M6) - Shadowsphere',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 52,
             'doom_type': 75,
             'region': "The Halls of Fear (E3M6) Green"},
    371475: {'name': 'The Halls of Fear (E3M6) - Ring of Invincibility',
             'episode': 3,
             'check_sanity': True,
             'map': 6,
             'index': 53,
             'doom_type': 84,
             'region': "The Halls of Fear (E3M6) Main"},
    371476: {'name': 'The Halls of Fear (E3M6) - Silver Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 54,
             'doom_type': 85,
             'region': "The Halls of Fear (E3M6) Yellow"},
    371477: {'name': 'The Halls of Fear (E3M6) - Enchanted Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 55,
             'doom_type': 31,
             'region': "The Halls of Fear (E3M6) Cyan"},
    371478: {'name': 'The Halls of Fear (E3M6) - Map Scroll',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 56,
             'doom_type': 35,
             'region': "The Halls of Fear (E3M6) Blue"},
    371479: {'name': 'The Halls of Fear (E3M6) - Tome of Power',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 57,
             'doom_type': 86,
             'region': "The Halls of Fear (E3M6) Cyan"},
    371480: {'name': 'The Halls of Fear (E3M6) - Tome of Power 2',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 58,
             'doom_type': 86,
             'region': "The Halls of Fear (E3M6) Green"},
    371481: {'name': 'The Halls of Fear (E3M6) - Mystic Urn 2',
             'episode': 3,
             'check_sanity': True,
             'map': 6,
             'index': 59,
             'doom_type': 32,
             'region': "The Halls of Fear (E3M6) Blue"},
    371482: {'name': 'The Halls of Fear (E3M6) - Bag of Holding 3',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 363,
             'doom_type': 8,
             'region': "The Halls of Fear (E3M6) Blue"},
    371483: {'name': 'The Halls of Fear (E3M6) - Tome of Power 3',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 364,
             'doom_type': 86,
             'region': "The Halls of Fear (E3M6) Main"},
    371484: {'name': 'The Halls of Fear (E3M6) - Firemace',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 468,
             'doom_type': 2002,
             'region': "The Halls of Fear (E3M6) Blue"},
    371485: {'name': 'The Halls of Fear (E3M6) - Hellstaff 2',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 472,
             'doom_type': 2004,
             'region': "The Halls of Fear (E3M6) Main"},
    371486: {'name': 'The Halls of Fear (E3M6) - Firemace 2',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 506,
             'doom_type': 2002,
             'region': "The Halls of Fear (E3M6) Green"},
    371487: {'name': 'The Halls of Fear (E3M6) - Firemace 3',
             'episode': 3,
             'check_sanity': True,
             'map': 6,
             'index': 507,
             'doom_type': 2002,
             'region': "The Halls of Fear (E3M6) Blue"},
    371488: {'name': 'The Halls of Fear (E3M6) - Firemace 4',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': 508,
             'doom_type': 2002,
             'region': "The Halls of Fear (E3M6) Main"},
    371489: {'name': 'The Halls of Fear (E3M6) - Firemace 5',
             'episode': 3,
             'check_sanity': True,
             'map': 6,
             'index': 509,
             'doom_type': 2002,
             'region': "The Halls of Fear (E3M6) Green"},
    371490: {'name': 'The Halls of Fear (E3M6) - Firemace 6',
             'episode': 3,
             'check_sanity': True,
             'map': 6,
             'index': 510,
             'doom_type': 2002,
             'region': "The Halls of Fear (E3M6) Green"},
    371491: {'name': 'The Halls of Fear (E3M6) - Exit',
             'episode': 3,
             'check_sanity': False,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "The Halls of Fear (E3M6) Blue"},
    371492: {'name': 'The Chasm (E3M7) - Blue key',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 5,
             'doom_type': 79,
             'region': "The Chasm (E3M7) Green"},
    371493: {'name': 'The Chasm (E3M7) - Green key',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 12,
             'doom_type': 73,
             'region': "The Chasm (E3M7) Yellow"},
    371494: {'name': 'The Chasm (E3M7) - Yellow key',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 26,
             'doom_type': 80,
             'region': "The Chasm (E3M7) Main"},
    371495: {'name': 'The Chasm (E3M7) - Ethereal Crossbow',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 254,
             'doom_type': 2001,
             'region': "The Chasm (E3M7) Main"},
    371496: {'name': 'The Chasm (E3M7) - Hellstaff',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 255,
             'doom_type': 2004,
             'region': "The Chasm (E3M7) Yellow"},
    371497: {'name': 'The Chasm (E3M7) - Gauntlets of the Necromancer',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 256,
             'doom_type': 2005,
             'region': "The Chasm (E3M7) Green"},
    371498: {'name': 'The Chasm (E3M7) - Dragon Claw',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 257,
             'doom_type': 53,
             'region': "The Chasm (E3M7) Main"},
    371499: {'name': 'The Chasm (E3M7) - Phoenix Rod',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 259,
             'doom_type': 2003,
             'region': "The Chasm (E3M7) Green"},
    371500: {'name': 'The Chasm (E3M7) - Shadowsphere',
             'episode': 3,
             'check_sanity': True,
             'map': 7,
             'index': 260,
             'doom_type': 75,
             'region': "The Chasm (E3M7) Green"},
    371501: {'name': 'The Chasm (E3M7) - Bag of Holding',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 262,
             'doom_type': 8,
             'region': "The Chasm (E3M7) Main"},
    371502: {'name': 'The Chasm (E3M7) - Silver Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 268,
             'doom_type': 85,
             'region': "The Chasm (E3M7) Main"},
    371503: {'name': 'The Chasm (E3M7) - Tome of Power',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 269,
             'doom_type': 86,
             'region': "The Chasm (E3M7) Main"},
    371504: {'name': 'The Chasm (E3M7) - Torch',
             'episode': 3,
             'check_sanity': True,
             'map': 7,
             'index': 270,
             'doom_type': 33,
             'region': "The Chasm (E3M7) Yellow"},
    371505: {'name': 'The Chasm (E3M7) - Morph Ovum',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 278,
             'doom_type': 30,
             'region': "The Chasm (E3M7) Yellow"},
    371506: {'name': 'The Chasm (E3M7) - Ring of Invincibility',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 282,
             'doom_type': 84,
             'region': "The Chasm (E3M7) Green"},
    371507: {'name': 'The Chasm (E3M7) - Mystic Urn',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 283,
             'doom_type': 32,
             'region': "The Chasm (E3M7) Green"},
    371508: {'name': 'The Chasm (E3M7) - Enchanted Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 284,
             'doom_type': 31,
             'region': "The Chasm (E3M7) Green"},
    371509: {'name': 'The Chasm (E3M7) - Map Scroll',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 285,
             'doom_type': 35,
             'region': "The Chasm (E3M7) Green"},
    371510: {'name': 'The Chasm (E3M7) - Chaos Device',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 286,
             'doom_type': 36,
             'region': "The Chasm (E3M7) Green"},
    371511: {'name': 'The Chasm (E3M7) - Tome of Power 2',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 287,
             'doom_type': 86,
             'region': "The Chasm (E3M7) Green"},
    371512: {'name': 'The Chasm (E3M7) - Tome of Power 3',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 288,
             'doom_type': 86,
             'region': "The Chasm (E3M7) Green"},
    371513: {'name': 'The Chasm (E3M7) - Torch 2',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 289,
             'doom_type': 33,
             'region': "The Chasm (E3M7) Green"},
    371514: {'name': 'The Chasm (E3M7) - Shadowsphere 2',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 337,
             'doom_type': 75,
             'region': "The Chasm (E3M7) Main"},
    371515: {'name': 'The Chasm (E3M7) - Bag of Holding 2',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': 660,
             'doom_type': 8,
             'region': "The Chasm (E3M7) Main"},
    371516: {'name': 'The Chasm (E3M7) - Exit',
             'episode': 3,
             'check_sanity': False,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "The Chasm (E3M7) Blue"},
    371517: {'name': "D'Sparil's Keep (E3M8) - Phoenix Rod",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 55,
             'doom_type': 2003,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371518: {'name': "D'Sparil's Keep (E3M8) - Ethereal Crossbow",
             'episode': 3,
             'check_sanity': True,
             'map': 8,
             'index': 56,
             'doom_type': 2001,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371519: {'name': "D'Sparil's Keep (E3M8) - Dragon Claw",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 57,
             'doom_type': 53,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371520: {'name': "D'Sparil's Keep (E3M8) - Gauntlets of the Necromancer",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 58,
             'doom_type': 2005,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371521: {'name': "D'Sparil's Keep (E3M8) - Hellstaff",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 59,
             'doom_type': 2004,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371522: {'name': "D'Sparil's Keep (E3M8) - Bag of Holding",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 63,
             'doom_type': 8,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371523: {'name': "D'Sparil's Keep (E3M8) - Mystic Urn",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 64,
             'doom_type': 32,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371524: {'name': "D'Sparil's Keep (E3M8) - Ring of Invincibility",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 65,
             'doom_type': 84,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371525: {'name': "D'Sparil's Keep (E3M8) - Shadowsphere",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 66,
             'doom_type': 75,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371526: {'name': "D'Sparil's Keep (E3M8) - Silver Shield",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 67,
             'doom_type': 85,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371527: {'name': "D'Sparil's Keep (E3M8) - Enchanted Shield",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 68,
             'doom_type': 31,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371528: {'name': "D'Sparil's Keep (E3M8) - Tome of Power",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': 69,
             'doom_type': 86,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371529: {'name': "D'Sparil's Keep (E3M8) - Tome of Power 2",
             'episode': 3,
             'check_sanity': True,
             'map': 8,
             'index': 70,
             'doom_type': 86,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371530: {'name': "D'Sparil's Keep (E3M8) - Chaos Device",
             'episode': 3,
             'check_sanity': True,
             'map': 8,
             'index': 71,
             'doom_type': 36,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371531: {'name': "D'Sparil's Keep (E3M8) - Tome of Power 3",
             'episode': 3,
             'check_sanity': True,
             'map': 8,
             'index': 245,
             'doom_type': 86,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371532: {'name': "D'Sparil's Keep (E3M8) - Exit",
             'episode': 3,
             'check_sanity': False,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "D'Sparil's Keep (E3M8) Main"},
    371533: {'name': 'The Aquifer (E3M9) - Blue key',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 12,
             'doom_type': 79,
             'region': "The Aquifer (E3M9) Green"},
    371534: {'name': 'The Aquifer (E3M9) - Green key',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 13,
             'doom_type': 73,
             'region': "The Aquifer (E3M9) Yellow"},
    371535: {'name': 'The Aquifer (E3M9) - Yellow key',
             'episode': 3,
             'check_sanity': True,
             'map': 9,
             'index': 14,
             'doom_type': 80,
             'region': "The Aquifer (E3M9) Main"},
    371536: {'name': 'The Aquifer (E3M9) - Ethereal Crossbow',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 141,
             'doom_type': 2001,
             'region': "The Aquifer (E3M9) Main"},
    371537: {'name': 'The Aquifer (E3M9) - Phoenix Rod',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 142,
             'doom_type': 2003,
             'region': "The Aquifer (E3M9) Yellow"},
    371538: {'name': 'The Aquifer (E3M9) - Dragon Claw',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 143,
             'doom_type': 53,
             'region': "The Aquifer (E3M9) Green"},
    371539: {'name': 'The Aquifer (E3M9) - Hellstaff',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 144,
             'doom_type': 2004,
             'region': "The Aquifer (E3M9) Green"},
    371540: {'name': 'The Aquifer (E3M9) - Gauntlets of the Necromancer',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 145,
             'doom_type': 2005,
             'region': "The Aquifer (E3M9) Green"},
    371541: {'name': 'The Aquifer (E3M9) - Ring of Invincibility',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 148,
             'doom_type': 84,
             'region': "The Aquifer (E3M9) Yellow"},
    371542: {'name': 'The Aquifer (E3M9) - Mystic Urn',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 149,
             'doom_type': 32,
             'region': "The Aquifer (E3M9) Green"},
    371543: {'name': 'The Aquifer (E3M9) - Silver Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 151,
             'doom_type': 85,
             'region': "The Aquifer (E3M9) Main"},
    371544: {'name': 'The Aquifer (E3M9) - Tome of Power',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 152,
             'doom_type': 86,
             'region': "The Aquifer (E3M9) Main"},
    371545: {'name': 'The Aquifer (E3M9) - Bag of Holding',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 153,
             'doom_type': 8,
             'region': "The Aquifer (E3M9) Yellow"},
    371546: {'name': 'The Aquifer (E3M9) - Morph Ovum',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 154,
             'doom_type': 30,
             'region': "The Aquifer (E3M9) Green"},
    371547: {'name': 'The Aquifer (E3M9) - Map Scroll',
             'episode': 3,
             'check_sanity': True,
             'map': 9,
             'index': 155,
             'doom_type': 35,
             'region': "The Aquifer (E3M9) Green"},
    371548: {'name': 'The Aquifer (E3M9) - Chaos Device',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 156,
             'doom_type': 36,
             'region': "The Aquifer (E3M9) Yellow"},
    371549: {'name': 'The Aquifer (E3M9) - Enchanted Shield',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 157,
             'doom_type': 31,
             'region': "The Aquifer (E3M9) Green"},
    371550: {'name': 'The Aquifer (E3M9) - Tome of Power 2',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 158,
             'doom_type': 86,
             'region': "The Aquifer (E3M9) Green"},
    371551: {'name': 'The Aquifer (E3M9) - Torch',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 159,
             'doom_type': 33,
             'region': "The Aquifer (E3M9) Main"},
    371552: {'name': 'The Aquifer (E3M9) - Shadowsphere',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 160,
             'doom_type': 75,
             'region': "The Aquifer (E3M9) Green"},
    371553: {'name': 'The Aquifer (E3M9) - Silver Shield 2',
             'episode': 3,
             'check_sanity': True,
             'map': 9,
             'index': 374,
             'doom_type': 85,
             'region': "The Aquifer (E3M9) Green"},
    371554: {'name': 'The Aquifer (E3M9) - Firemace',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 478,
             'doom_type': 2002,
             'region': "The Aquifer (E3M9) Green"},
    371555: {'name': 'The Aquifer (E3M9) - Firemace 2',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 526,
             'doom_type': 2002,
             'region': "The Aquifer (E3M9) Green"},
    371556: {'name': 'The Aquifer (E3M9) - Firemace 3',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': 527,
             'doom_type': 2002,
             'region': "The Aquifer (E3M9) Green"},
    371557: {'name': 'The Aquifer (E3M9) - Firemace 4',
             'episode': 3,
             'check_sanity': True,
             'map': 9,
             'index': 528,
             'doom_type': 2002,
             'region': "The Aquifer (E3M9) Yellow"},
    371558: {'name': 'The Aquifer (E3M9) - Exit',
             'episode': 3,
             'check_sanity': False,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "The Aquifer (E3M9) Blue"},
    371559: {'name': 'Catafalque (E4M1) - Yellow key',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 4,
             'doom_type': 80,
             'region': "Catafalque (E4M1) Main"},
    371560: {'name': 'Catafalque (E4M1) - Green key',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 10,
             'doom_type': 73,
             'region': "Catafalque (E4M1) Yellow"},
    371561: {'name': 'Catafalque (E4M1) - Ethereal Crossbow',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 100,
             'doom_type': 2001,
             'region': "Catafalque (E4M1) Main"},
    371562: {'name': 'Catafalque (E4M1) - Gauntlets of the Necromancer',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 101,
             'doom_type': 2005,
             'region': "Catafalque (E4M1) Yellow"},
    371563: {'name': 'Catafalque (E4M1) - Dragon Claw',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 102,
             'doom_type': 53,
             'region': "Catafalque (E4M1) Yellow"},
    371564: {'name': 'Catafalque (E4M1) - Hellstaff',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 103,
             'doom_type': 2004,
             'region': "Catafalque (E4M1) Green"},
    371565: {'name': 'Catafalque (E4M1) - Shadowsphere',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 114,
             'doom_type': 75,
             'region': "Catafalque (E4M1) Yellow"},
    371566: {'name': 'Catafalque (E4M1) - Ring of Invincibility',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 115,
             'doom_type': 84,
             'region': "Catafalque (E4M1) Green"},
    371567: {'name': 'Catafalque (E4M1) - Silver Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 116,
             'doom_type': 85,
             'region': "Catafalque (E4M1) Main"},
    371568: {'name': 'Catafalque (E4M1) - Map Scroll',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 117,
             'doom_type': 35,
             'region': "Catafalque (E4M1) Green"},
    371569: {'name': 'Catafalque (E4M1) - Chaos Device',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 118,
             'doom_type': 36,
             'region': "Catafalque (E4M1) Yellow"},
    371570: {'name': 'Catafalque (E4M1) - Tome of Power',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 119,
             'doom_type': 86,
             'region': "Catafalque (E4M1) Yellow"},
    371571: {'name': 'Catafalque (E4M1) - Tome of Power 2',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 120,
             'doom_type': 86,
             'region': "Catafalque (E4M1) Main"},
    371572: {'name': 'Catafalque (E4M1) - Torch',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 121,
             'doom_type': 33,
             'region': "Catafalque (E4M1) Yellow"},
    371573: {'name': 'Catafalque (E4M1) - Bag of Holding',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 122,
             'doom_type': 8,
             'region': "Catafalque (E4M1) Main"},
    371574: {'name': 'Catafalque (E4M1) - Morph Ovum',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': 123,
             'doom_type': 30,
             'region': "Catafalque (E4M1) Main"},
    371575: {'name': 'Catafalque (E4M1) - Exit',
             'episode': 4,
             'check_sanity': False,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "Catafalque (E4M1) Green"},
    371576: {'name': 'Blockhouse (E4M2) - Green key',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 18,
             'doom_type': 73,
             'region': "Blockhouse (E4M2) Yellow"},
    371577: {'name': 'Blockhouse (E4M2) - Yellow key',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 19,
             'doom_type': 80,
             'region': "Blockhouse (E4M2) Main"},
    371578: {'name': 'Blockhouse (E4M2) - Blue key',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 25,
             'doom_type': 79,
             'region': "Blockhouse (E4M2) Green"},
    371579: {'name': 'Blockhouse (E4M2) - Gauntlets of the Necromancer',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 46,
             'doom_type': 2005,
             'region': "Blockhouse (E4M2) Main"},
    371580: {'name': 'Blockhouse (E4M2) - Ethereal Crossbow',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 47,
             'doom_type': 2001,
             'region': "Blockhouse (E4M2) Main"},
    371581: {'name': 'Blockhouse (E4M2) - Dragon Claw',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 48,
             'doom_type': 53,
             'region': "Blockhouse (E4M2) Main"},
    371582: {'name': 'Blockhouse (E4M2) - Hellstaff',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 49,
             'doom_type': 2004,
             'region': "Blockhouse (E4M2) Main"},
    371583: {'name': 'Blockhouse (E4M2) - Phoenix Rod',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 50,
             'doom_type': 2003,
             'region': "Blockhouse (E4M2) Main"},
    371584: {'name': 'Blockhouse (E4M2) - Bag of Holding',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 58,
             'doom_type': 8,
             'region': "Blockhouse (E4M2) Main"},
    371585: {'name': 'Blockhouse (E4M2) - Mystic Urn',
             'episode': 4,
             'check_sanity': True,
             'map': 2,
             'index': 67,
             'doom_type': 32,
             'region': "Blockhouse (E4M2) Main"},
    371586: {'name': 'Blockhouse (E4M2) - Silver Shield',
             'episode': 4,
             'check_sanity': True,
             'map': 2,
             'index': 68,
             'doom_type': 85,
             'region': "Blockhouse (E4M2) Main"},
    371587: {'name': 'Blockhouse (E4M2) - Morph Ovum',
             'episode': 4,
             'check_sanity': True,
             'map': 2,
             'index': 69,
             'doom_type': 30,
             'region': "Blockhouse (E4M2) Main"},
    371588: {'name': 'Blockhouse (E4M2) - Tome of Power',
             'episode': 4,
             'check_sanity': True,
             'map': 2,
             'index': 70,
             'doom_type': 86,
             'region': "Blockhouse (E4M2) Main"},
    371589: {'name': 'Blockhouse (E4M2) - Chaos Device',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 71,
             'doom_type': 36,
             'region': "Blockhouse (E4M2) Green"},
    371590: {'name': 'Blockhouse (E4M2) - Ring of Invincibility',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 72,
             'doom_type': 84,
             'region': "Blockhouse (E4M2) Green"},
    371591: {'name': 'Blockhouse (E4M2) - Bag of Holding 2',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 73,
             'doom_type': 8,
             'region': "Blockhouse (E4M2) Green"},
    371592: {'name': 'Blockhouse (E4M2) - Enchanted Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 74,
             'doom_type': 31,
             'region': "Blockhouse (E4M2) Yellow"},
    371593: {'name': 'Blockhouse (E4M2) - Shadowsphere',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 75,
             'doom_type': 75,
             'region': "Blockhouse (E4M2) Main"},
    371594: {'name': 'Blockhouse (E4M2) - Ring of Invincibility 2',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 226,
             'doom_type': 84,
             'region': "Blockhouse (E4M2) Lake"},
    371595: {'name': 'Blockhouse (E4M2) - Shadowsphere 2',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': 227,
             'doom_type': 75,
             'region': "Blockhouse (E4M2) Lake"},
    371596: {'name': 'Blockhouse (E4M2) - Exit',
             'episode': 4,
             'check_sanity': False,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "Blockhouse (E4M2) Blue"},
    371597: {'name': 'Ambulatory (E4M3) - Yellow key',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 10,
             'doom_type': 80,
             'region': "Ambulatory (E4M3) Main"},
    371598: {'name': 'Ambulatory (E4M3) - Green key',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 11,
             'doom_type': 73,
             'region': "Ambulatory (E4M3) Yellow"},
    371599: {'name': 'Ambulatory (E4M3) - Blue key',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 12,
             'doom_type': 79,
             'region': "Ambulatory (E4M3) Green"},
    371600: {'name': 'Ambulatory (E4M3) - Ethereal Crossbow',
             'episode': 4,
             'check_sanity': True,
             'map': 3,
             'index': 265,
             'doom_type': 2001,
             'region': "Ambulatory (E4M3) Main"},
    371601: {'name': 'Ambulatory (E4M3) - Gauntlets of the Necromancer',
             'episode': 4,
             'check_sanity': True,
             'map': 3,
             'index': 266,
             'doom_type': 2005,
             'region': "Ambulatory (E4M3) Main"},
    371602: {'name': 'Ambulatory (E4M3) - Dragon Claw',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 267,
             'doom_type': 53,
             'region': "Ambulatory (E4M3) Yellow"},
    371603: {'name': 'Ambulatory (E4M3) - Hellstaff',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 268,
             'doom_type': 2004,
             'region': "Ambulatory (E4M3) Green"},
    371604: {'name': 'Ambulatory (E4M3) - Phoenix Rod',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 269,
             'doom_type': 2003,
             'region': "Ambulatory (E4M3) Blue"},
    371605: {'name': 'Ambulatory (E4M3) - Tome of Power',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 270,
             'doom_type': 86,
             'region': "Ambulatory (E4M3) Main"},
    371606: {'name': 'Ambulatory (E4M3) - Silver Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 271,
             'doom_type': 85,
             'region': "Ambulatory (E4M3) Yellow"},
    371607: {'name': 'Ambulatory (E4M3) - Map Scroll',
             'episode': 4,
             'check_sanity': True,
             'map': 3,
             'index': 272,
             'doom_type': 35,
             'region': "Ambulatory (E4M3) Yellow"},
    371608: {'name': 'Ambulatory (E4M3) - Bag of Holding',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 273,
             'doom_type': 8,
             'region': "Ambulatory (E4M3) Yellow"},
    371609: {'name': 'Ambulatory (E4M3) - Shadowsphere',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 274,
             'doom_type': 75,
             'region': "Ambulatory (E4M3) Yellow"},
    371610: {'name': 'Ambulatory (E4M3) - Morph Ovum',
             'episode': 4,
             'check_sanity': True,
             'map': 3,
             'index': 275,
             'doom_type': 30,
             'region': "Ambulatory (E4M3) Yellow"},
    371611: {'name': 'Ambulatory (E4M3) - Torch',
             'episode': 4,
             'check_sanity': True,
             'map': 3,
             'index': 276,
             'doom_type': 33,
             'region': "Ambulatory (E4M3) Green"},
    371612: {'name': 'Ambulatory (E4M3) - Tome of Power 2',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 277,
             'doom_type': 86,
             'region': "Ambulatory (E4M3) Green"},
    371613: {'name': 'Ambulatory (E4M3) - Enchanted Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 278,
             'doom_type': 31,
             'region': "Ambulatory (E4M3) Blue"},
    371614: {'name': 'Ambulatory (E4M3) - Mystic Urn',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 279,
             'doom_type': 32,
             'region': "Ambulatory (E4M3) Blue"},
    371615: {'name': 'Ambulatory (E4M3) - Ring of Invincibility',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 281,
             'doom_type': 84,
             'region': "Ambulatory (E4M3) Blue"},
    371616: {'name': 'Ambulatory (E4M3) - Chaos Device',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 282,
             'doom_type': 36,
             'region': "Ambulatory (E4M3) Green"},
    371617: {'name': 'Ambulatory (E4M3) - Ring of Invincibility 2',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 283,
             'doom_type': 84,
             'region': "Ambulatory (E4M3) Green"},
    371618: {'name': 'Ambulatory (E4M3) - Morph Ovum 2',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 284,
             'doom_type': 30,
             'region': "Ambulatory (E4M3) Blue"},
    371619: {'name': 'Ambulatory (E4M3) - Bag of Holding 2',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 285,
             'doom_type': 8,
             'region': "Ambulatory (E4M3) Yellow"},
    371620: {'name': 'Ambulatory (E4M3) - Firemace',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 297,
             'doom_type': 2002,
             'region': "Ambulatory (E4M3) Green Lock"},
    371621: {'name': 'Ambulatory (E4M3) - Firemace 2',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 298,
             'doom_type': 2002,
             'region': "Ambulatory (E4M3) Yellow"},
    371622: {'name': 'Ambulatory (E4M3) - Firemace 3',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 299,
             'doom_type': 2002,
             'region': "Ambulatory (E4M3) Yellow"},
    371623: {'name': 'Ambulatory (E4M3) - Firemace 4',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': 300,
             'doom_type': 2002,
             'region': "Ambulatory (E4M3) Blue"},
    371624: {'name': 'Ambulatory (E4M3) - Firemace 5',
             'episode': 4,
             'check_sanity': True,
             'map': 3,
             'index': 301,
             'doom_type': 2002,
             'region': "Ambulatory (E4M3) Green"},
    371625: {'name': 'Ambulatory (E4M3) - Exit',
             'episode': 4,
             'check_sanity': False,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "Ambulatory (E4M3) Blue"},
    371626: {'name': 'Sepulcher (E4M4) - Silver Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 27,
             'doom_type': 85,
             'region': "Sepulcher (E4M4) Main"},
    371627: {'name': 'Sepulcher (E4M4) - Hellstaff',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 28,
             'doom_type': 2004,
             'region': "Sepulcher (E4M4) Main"},
    371628: {'name': 'Sepulcher (E4M4) - Dragon Claw',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 29,
             'doom_type': 53,
             'region': "Sepulcher (E4M4) Main"},
    371629: {'name': 'Sepulcher (E4M4) - Ethereal Crossbow',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 30,
             'doom_type': 2001,
             'region': "Sepulcher (E4M4) Main"},
    371630: {'name': 'Sepulcher (E4M4) - Tome of Power',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 31,
             'doom_type': 86,
             'region': "Sepulcher (E4M4) Main"},
    371631: {'name': 'Sepulcher (E4M4) - Shadowsphere',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 40,
             'doom_type': 75,
             'region': "Sepulcher (E4M4) Main"},
    371632: {'name': 'Sepulcher (E4M4) - Mystic Urn',
             'episode': 4,
             'check_sanity': True,
             'map': 4,
             'index': 41,
             'doom_type': 32,
             'region': "Sepulcher (E4M4) Main"},
    371633: {'name': 'Sepulcher (E4M4) - Chaos Device',
             'episode': 4,
             'check_sanity': True,
             'map': 4,
             'index': 50,
             'doom_type': 36,
             'region': "Sepulcher (E4M4) Main"},
    371634: {'name': 'Sepulcher (E4M4) - Enchanted Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 51,
             'doom_type': 31,
             'region': "Sepulcher (E4M4) Main"},
    371635: {'name': 'Sepulcher (E4M4) - Morph Ovum',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 65,
             'doom_type': 30,
             'region': "Sepulcher (E4M4) Main"},
    371636: {'name': 'Sepulcher (E4M4) - Torch',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 66,
             'doom_type': 33,
             'region': "Sepulcher (E4M4) Main"},
    371637: {'name': 'Sepulcher (E4M4) - Firemace',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 67,
             'doom_type': 2002,
             'region': "Sepulcher (E4M4) Main"},
    371638: {'name': 'Sepulcher (E4M4) - Phoenix Rod',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 74,
             'doom_type': 2003,
             'region': "Sepulcher (E4M4) Main"},
    371639: {'name': 'Sepulcher (E4M4) - Ring of Invincibility',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 137,
             'doom_type': 84,
             'region': "Sepulcher (E4M4) Main"},
    371640: {'name': 'Sepulcher (E4M4) - Bag of Holding',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 138,
             'doom_type': 8,
             'region': "Sepulcher (E4M4) Main"},
    371641: {'name': 'Sepulcher (E4M4) - Ethereal Crossbow 2',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 199,
             'doom_type': 2001,
             'region': "Sepulcher (E4M4) Main"},
    371642: {'name': 'Sepulcher (E4M4) - Bag of Holding 2',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 235,
             'doom_type': 8,
             'region': "Sepulcher (E4M4) Main"},
    371643: {'name': 'Sepulcher (E4M4) - Tome of Power 2',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 239,
             'doom_type': 86,
             'region': "Sepulcher (E4M4) Main"},
    371644: {'name': 'Sepulcher (E4M4) - Torch 2',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 243,
             'doom_type': 33,
             'region': "Sepulcher (E4M4) Main"},
    371645: {'name': 'Sepulcher (E4M4) - Silver Shield 2',
             'episode': 4,
             'check_sanity': True,
             'map': 4,
             'index': 244,
             'doom_type': 85,
             'region': "Sepulcher (E4M4) Main"},
    371646: {'name': 'Sepulcher (E4M4) - Firemace 2',
             'episode': 4,
             'check_sanity': True,
             'map': 4,
             'index': 307,
             'doom_type': 2002,
             'region': "Sepulcher (E4M4) Main"},
    371647: {'name': 'Sepulcher (E4M4) - Firemace 3',
             'episode': 4,
             'check_sanity': True,
             'map': 4,
             'index': 308,
             'doom_type': 2002,
             'region': "Sepulcher (E4M4) Main"},
    371648: {'name': 'Sepulcher (E4M4) - Firemace 4',
             'episode': 4,
             'check_sanity': True,
             'map': 4,
             'index': 309,
             'doom_type': 2002,
             'region': "Sepulcher (E4M4) Main"},
    371649: {'name': 'Sepulcher (E4M4) - Firemace 5',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 310,
             'doom_type': 2002,
             'region': "Sepulcher (E4M4) Main"},
    371650: {'name': 'Sepulcher (E4M4) - Dragon Claw 2',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 325,
             'doom_type': 53,
             'region': "Sepulcher (E4M4) Main"},
    371651: {'name': 'Sepulcher (E4M4) - Phoenix Rod 2',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': 339,
             'doom_type': 2003,
             'region': "Sepulcher (E4M4) Main"},
    371652: {'name': 'Sepulcher (E4M4) - Exit',
             'episode': 4,
             'check_sanity': False,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "Sepulcher (E4M4) Main"},
    371653: {'name': 'Great Stair (E4M5) - Ethereal Crossbow',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 3,
             'doom_type': 2001,
             'region': "Great Stair (E4M5) Main"},
    371654: {'name': 'Great Stair (E4M5) - Yellow key',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 27,
             'doom_type': 80,
             'region': "Great Stair (E4M5) Main"},
    371655: {'name': 'Great Stair (E4M5) - Dragon Claw',
             'episode': 4,
             'check_sanity': True,
             'map': 5,
             'index': 58,
             'doom_type': 53,
             'region': "Great Stair (E4M5) Yellow"},
    371656: {'name': 'Great Stair (E4M5) - Green key',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 64,
             'doom_type': 73,
             'region': "Great Stair (E4M5) Yellow"},
    371657: {'name': 'Great Stair (E4M5) - Blue key',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 71,
             'doom_type': 79,
             'region': "Great Stair (E4M5) Green"},
    371658: {'name': 'Great Stair (E4M5) - Silver Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 78,
             'doom_type': 85,
             'region': "Great Stair (E4M5) Main"},
    371659: {'name': 'Great Stair (E4M5) - Gauntlets of the Necromancer',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 90,
             'doom_type': 2005,
             'region': "Great Stair (E4M5) Main"},
    371660: {'name': 'Great Stair (E4M5) - Hellstaff',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 91,
             'doom_type': 2004,
             'region': "Great Stair (E4M5) Yellow"},
    371661: {'name': 'Great Stair (E4M5) - Phoenix Rod',
             'episode': 4,
             'check_sanity': True,
             'map': 5,
             'index': 92,
             'doom_type': 2003,
             'region': "Great Stair (E4M5) Green"},
    371662: {'name': 'Great Stair (E4M5) - Bag of Holding',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 93,
             'doom_type': 8,
             'region': "Great Stair (E4M5) Main"},
    371663: {'name': 'Great Stair (E4M5) - Bag of Holding 2',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 94,
             'doom_type': 8,
             'region': "Great Stair (E4M5) Green"},
    371664: {'name': 'Great Stair (E4M5) - Morph Ovum',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 95,
             'doom_type': 30,
             'region': "Great Stair (E4M5) Main"},
    371665: {'name': 'Great Stair (E4M5) - Mystic Urn',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 110,
             'doom_type': 32,
             'region': "Great Stair (E4M5) Yellow"},
    371666: {'name': 'Great Stair (E4M5) - Shadowsphere',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 111,
             'doom_type': 75,
             'region': "Great Stair (E4M5) Yellow"},
    371667: {'name': 'Great Stair (E4M5) - Ring of Invincibility',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 112,
             'doom_type': 84,
             'region': "Great Stair (E4M5) Main"},
    371668: {'name': 'Great Stair (E4M5) - Enchanted Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 113,
             'doom_type': 31,
             'region': "Great Stair (E4M5) Green"},
    371669: {'name': 'Great Stair (E4M5) - Map Scroll',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 114,
             'doom_type': 35,
             'region': "Great Stair (E4M5) Green"},
    371670: {'name': 'Great Stair (E4M5) - Chaos Device',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 115,
             'doom_type': 36,
             'region': "Great Stair (E4M5) Main"},
    371671: {'name': 'Great Stair (E4M5) - Tome of Power',
             'episode': 4,
             'check_sanity': True,
             'map': 5,
             'index': 116,
             'doom_type': 86,
             'region': "Great Stair (E4M5) Main"},
    371672: {'name': 'Great Stair (E4M5) - Tome of Power 2',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 117,
             'doom_type': 86,
             'region': "Great Stair (E4M5) Yellow"},
    371673: {'name': 'Great Stair (E4M5) - Torch',
             'episode': 4,
             'check_sanity': True,
             'map': 5,
             'index': 118,
             'doom_type': 33,
             'region': "Great Stair (E4M5) Main"},
    371674: {'name': 'Great Stair (E4M5) - Firemace',
             'episode': 4,
             'check_sanity': True,
             'map': 5,
             'index': 123,
             'doom_type': 2002,
             'region': "Great Stair (E4M5) Main"},
    371675: {'name': 'Great Stair (E4M5) - Firemace 2',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 124,
             'doom_type': 2002,
             'region': "Great Stair (E4M5) Main"},
    371676: {'name': 'Great Stair (E4M5) - Firemace 3',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 125,
             'doom_type': 2002,
             'region': "Great Stair (E4M5) Yellow"},
    371677: {'name': 'Great Stair (E4M5) - Firemace 4',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 126,
             'doom_type': 2002,
             'region': "Great Stair (E4M5) Blue"},
    371678: {'name': 'Great Stair (E4M5) - Firemace 5',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 127,
             'doom_type': 2002,
             'region': "Great Stair (E4M5) Yellow"},
    371679: {'name': 'Great Stair (E4M5) - Mystic Urn 2',
             'episode': 4,
             'check_sanity': True,
             'map': 5,
             'index': 507,
             'doom_type': 32,
             'region': "Great Stair (E4M5) Green"},
    371680: {'name': 'Great Stair (E4M5) - Tome of Power 3',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': 508,
             'doom_type': 86,
             'region': "Great Stair (E4M5) Green"},
    371681: {'name': 'Great Stair (E4M5) - Exit',
             'episode': 4,
             'check_sanity': False,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "Great Stair (E4M5) Blue"},
    371682: {'name': 'Halls of the Apostate (E4M6) - Green key',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 17,
             'doom_type': 73,
             'region': "Halls of the Apostate (E4M6) Yellow"},
    371683: {'name': 'Halls of the Apostate (E4M6) - Blue key',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 18,
             'doom_type': 79,
             'region': "Halls of the Apostate (E4M6) Green"},
    371684: {'name': 'Halls of the Apostate (E4M6) - Gauntlets of the Necromancer',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 59,
             'doom_type': 2005,
             'region': "Halls of the Apostate (E4M6) Main"},
    371685: {'name': 'Halls of the Apostate (E4M6) - Ethereal Crossbow',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 60,
             'doom_type': 2001,
             'region': "Halls of the Apostate (E4M6) Main"},
    371686: {'name': 'Halls of the Apostate (E4M6) - Dragon Claw',
             'episode': 4,
             'check_sanity': True,
             'map': 6,
             'index': 61,
             'doom_type': 53,
             'region': "Halls of the Apostate (E4M6) Yellow"},
    371687: {'name': 'Halls of the Apostate (E4M6) - Hellstaff',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 62,
             'doom_type': 2004,
             'region': "Halls of the Apostate (E4M6) Green"},
    371688: {'name': 'Halls of the Apostate (E4M6) - Phoenix Rod',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 63,
             'doom_type': 2003,
             'region': "Halls of the Apostate (E4M6) Blue"},
    371689: {'name': 'Halls of the Apostate (E4M6) - Bag of Holding',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 68,
             'doom_type': 8,
             'region': "Halls of the Apostate (E4M6) Main"},
    371690: {'name': 'Halls of the Apostate (E4M6) - Morph Ovum',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 79,
             'doom_type': 30,
             'region': "Halls of the Apostate (E4M6) Yellow"},
    371691: {'name': 'Halls of the Apostate (E4M6) - Mystic Urn',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 80,
             'doom_type': 32,
             'region': "Halls of the Apostate (E4M6) Main"},
    371692: {'name': 'Halls of the Apostate (E4M6) - Shadowsphere',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 81,
             'doom_type': 75,
             'region': "Halls of the Apostate (E4M6) Main"},
    371693: {'name': 'Halls of the Apostate (E4M6) - Silver Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 82,
             'doom_type': 85,
             'region': "Halls of the Apostate (E4M6) Main"},
    371694: {'name': 'Halls of the Apostate (E4M6) - Silver Shield 2',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 83,
             'doom_type': 85,
             'region': "Halls of the Apostate (E4M6) Blue"},
    371695: {'name': 'Halls of the Apostate (E4M6) - Enchanted Shield',
             'episode': 4,
             'check_sanity': True,
             'map': 6,
             'index': 84,
             'doom_type': 31,
             'region': "Halls of the Apostate (E4M6) Green"},
    371696: {'name': 'Halls of the Apostate (E4M6) - Map Scroll',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 85,
             'doom_type': 35,
             'region': "Halls of the Apostate (E4M6) Green"},
    371697: {'name': 'Halls of the Apostate (E4M6) - Chaos Device',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 86,
             'doom_type': 36,
             'region': "Halls of the Apostate (E4M6) Yellow"},
    371698: {'name': 'Halls of the Apostate (E4M6) - Tome of Power',
             'episode': 4,
             'check_sanity': True,
             'map': 6,
             'index': 87,
             'doom_type': 86,
             'region': "Halls of the Apostate (E4M6) Main"},
    371699: {'name': 'Halls of the Apostate (E4M6) - Tome of Power 2',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 88,
             'doom_type': 86,
             'region': "Halls of the Apostate (E4M6) Blue"},
    371700: {'name': 'Halls of the Apostate (E4M6) - Bag of Holding 2',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 89,
             'doom_type': 8,
             'region': "Halls of the Apostate (E4M6) Green"},
    371701: {'name': 'Halls of the Apostate (E4M6) - Ring of Invincibility',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 108,
             'doom_type': 84,
             'region': "Halls of the Apostate (E4M6) Yellow"},
    371702: {'name': 'Halls of the Apostate (E4M6) - Yellow key',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': 420,
             'doom_type': 80,
             'region': "Halls of the Apostate (E4M6) Main"},
    371703: {'name': 'Halls of the Apostate (E4M6) - Exit',
             'episode': 4,
             'check_sanity': False,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "Halls of the Apostate (E4M6) Blue"},
    371704: {'name': 'Ramparts of Perdition (E4M7) - Yellow key',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 28,
             'doom_type': 80,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371705: {'name': 'Ramparts of Perdition (E4M7) - Green key',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 33,
             'doom_type': 73,
             'region': "Ramparts of Perdition (E4M7) Yellow"},
    371706: {'name': 'Ramparts of Perdition (E4M7) - Blue key',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 36,
             'doom_type': 79,
             'region': "Ramparts of Perdition (E4M7) Green"},
    371707: {'name': 'Ramparts of Perdition (E4M7) - Ring of Invincibility',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 39,
             'doom_type': 84,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371708: {'name': 'Ramparts of Perdition (E4M7) - Mystic Urn',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 40,
             'doom_type': 32,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371709: {'name': 'Ramparts of Perdition (E4M7) - Gauntlets of the Necromancer',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 124,
             'doom_type': 2005,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371710: {'name': 'Ramparts of Perdition (E4M7) - Ethereal Crossbow',
             'episode': 4,
             'check_sanity': True,
             'map': 7,
             'index': 125,
             'doom_type': 2001,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371711: {'name': 'Ramparts of Perdition (E4M7) - Dragon Claw',
             'episode': 4,
             'check_sanity': True,
             'map': 7,
             'index': 126,
             'doom_type': 53,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371712: {'name': 'Ramparts of Perdition (E4M7) - Phoenix Rod',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 127,
             'doom_type': 2003,
             'region': "Ramparts of Perdition (E4M7) Green"},
    371713: {'name': 'Ramparts of Perdition (E4M7) - Hellstaff',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 128,
             'doom_type': 2004,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371714: {'name': 'Ramparts of Perdition (E4M7) - Ethereal Crossbow 2',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 129,
             'doom_type': 2001,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371715: {'name': 'Ramparts of Perdition (E4M7) - Dragon Claw 2',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 130,
             'doom_type': 53,
             'region': "Ramparts of Perdition (E4M7) Blue"},
    371716: {'name': 'Ramparts of Perdition (E4M7) - Phoenix Rod 2',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 131,
             'doom_type': 2003,
             'region': "Ramparts of Perdition (E4M7) Blue"},
    371717: {'name': 'Ramparts of Perdition (E4M7) - Hellstaff 2',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 132,
             'doom_type': 2004,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371718: {'name': 'Ramparts of Perdition (E4M7) - Firemace',
             'episode': 4,
             'check_sanity': True,
             'map': 7,
             'index': 133,
             'doom_type': 2002,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371719: {'name': 'Ramparts of Perdition (E4M7) - Firemace 2',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 134,
             'doom_type': 2002,
             'region': "Ramparts of Perdition (E4M7) Yellow"},
    371720: {'name': 'Ramparts of Perdition (E4M7) - Firemace 3',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 135,
             'doom_type': 2002,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371721: {'name': 'Ramparts of Perdition (E4M7) - Firemace 4',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 136,
             'doom_type': 2002,
             'region': "Ramparts of Perdition (E4M7) Yellow"},
    371722: {'name': 'Ramparts of Perdition (E4M7) - Firemace 5',
             'episode': 4,
             'check_sanity': True,
             'map': 7,
             'index': 137,
             'doom_type': 2002,
             'region': "Ramparts of Perdition (E4M7) Yellow"},
    371723: {'name': 'Ramparts of Perdition (E4M7) - Firemace 6',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 138,
             'doom_type': 2002,
             'region': "Ramparts of Perdition (E4M7) Blue"},
    371724: {'name': 'Ramparts of Perdition (E4M7) - Bag of Holding',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 140,
             'doom_type': 8,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371725: {'name': 'Ramparts of Perdition (E4M7) - Tome of Power',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 141,
             'doom_type': 86,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371726: {'name': 'Ramparts of Perdition (E4M7) - Bag of Holding 2',
             'episode': 4,
             'check_sanity': True,
             'map': 7,
             'index': 142,
             'doom_type': 8,
             'region': "Ramparts of Perdition (E4M7) Green"},
    371727: {'name': 'Ramparts of Perdition (E4M7) - Morph Ovum',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 143,
             'doom_type': 30,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371728: {'name': 'Ramparts of Perdition (E4M7) - Shadowsphere',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 153,
             'doom_type': 75,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371729: {'name': 'Ramparts of Perdition (E4M7) - Silver Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 154,
             'doom_type': 85,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371730: {'name': 'Ramparts of Perdition (E4M7) - Silver Shield 2',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 155,
             'doom_type': 85,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371731: {'name': 'Ramparts of Perdition (E4M7) - Enchanted Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 156,
             'doom_type': 31,
             'region': "Ramparts of Perdition (E4M7) Yellow"},
    371732: {'name': 'Ramparts of Perdition (E4M7) - Tome of Power 2',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 157,
             'doom_type': 86,
             'region': "Ramparts of Perdition (E4M7) Yellow"},
    371733: {'name': 'Ramparts of Perdition (E4M7) - Tome of Power 3',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 158,
             'doom_type': 86,
             'region': "Ramparts of Perdition (E4M7) Blue"},
    371734: {'name': 'Ramparts of Perdition (E4M7) - Torch',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 159,
             'doom_type': 33,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371735: {'name': 'Ramparts of Perdition (E4M7) - Torch 2',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 160,
             'doom_type': 33,
             'region': "Ramparts of Perdition (E4M7) Yellow"},
    371736: {'name': 'Ramparts of Perdition (E4M7) - Mystic Urn 2',
             'episode': 4,
             'check_sanity': True,
             'map': 7,
             'index': 161,
             'doom_type': 32,
             'region': "Ramparts of Perdition (E4M7) Yellow"},
    371737: {'name': 'Ramparts of Perdition (E4M7) - Chaos Device',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': 162,
             'doom_type': 36,
             'region': "Ramparts of Perdition (E4M7) Yellow"},
    371738: {'name': 'Ramparts of Perdition (E4M7) - Map Scroll',
             'episode': 4,
             'check_sanity': True,
             'map': 7,
             'index': 163,
             'doom_type': 35,
             'region': "Ramparts of Perdition (E4M7) Main"},
    371739: {'name': 'Ramparts of Perdition (E4M7) - Exit',
             'episode': 4,
             'check_sanity': False,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "Ramparts of Perdition (E4M7) Blue"},
    371740: {'name': 'Shattered Bridge (E4M8) - Yellow key',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 5,
             'doom_type': 80,
             'region': "Shattered Bridge (E4M8) Main"},
    371741: {'name': 'Shattered Bridge (E4M8) - Dragon Claw',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 58,
             'doom_type': 53,
             'region': "Shattered Bridge (E4M8) Main"},
    371742: {'name': 'Shattered Bridge (E4M8) - Phoenix Rod',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 79,
             'doom_type': 2003,
             'region': "Shattered Bridge (E4M8) Boss"},
    371743: {'name': 'Shattered Bridge (E4M8) - Ethereal Crossbow',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 80,
             'doom_type': 2001,
             'region': "Shattered Bridge (E4M8) Main"},
    371744: {'name': 'Shattered Bridge (E4M8) - Gauntlets of the Necromancer',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 81,
             'doom_type': 2005,
             'region': "Shattered Bridge (E4M8) Main"},
    371745: {'name': 'Shattered Bridge (E4M8) - Hellstaff',
             'episode': 4,
             'check_sanity': True,
             'map': 8,
             'index': 82,
             'doom_type': 2004,
             'region': "Shattered Bridge (E4M8) Main"},
    371746: {'name': 'Shattered Bridge (E4M8) - Bag of Holding',
             'episode': 4,
             'check_sanity': True,
             'map': 8,
             'index': 96,
             'doom_type': 8,
             'region': "Shattered Bridge (E4M8) Main"},
    371747: {'name': 'Shattered Bridge (E4M8) - Morph Ovum',
             'episode': 4,
             'check_sanity': True,
             'map': 8,
             'index': 97,
             'doom_type': 30,
             'region': "Shattered Bridge (E4M8) Main"},
    371748: {'name': 'Shattered Bridge (E4M8) - Silver Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 98,
             'doom_type': 85,
             'region': "Shattered Bridge (E4M8) Main"},
    371749: {'name': 'Shattered Bridge (E4M8) - Bag of Holding 2',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 108,
             'doom_type': 8,
             'region': "Shattered Bridge (E4M8) Main"},
    371750: {'name': 'Shattered Bridge (E4M8) - Mystic Urn',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 109,
             'doom_type': 32,
             'region': "Shattered Bridge (E4M8) Main"},
    371751: {'name': 'Shattered Bridge (E4M8) - Shadowsphere',
             'episode': 4,
             'check_sanity': True,
             'map': 8,
             'index': 110,
             'doom_type': 75,
             'region': "Shattered Bridge (E4M8) Main"},
    371752: {'name': 'Shattered Bridge (E4M8) - Ring of Invincibility',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 111,
             'doom_type': 84,
             'region': "Shattered Bridge (E4M8) Main"},
    371753: {'name': 'Shattered Bridge (E4M8) - Chaos Device',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 112,
             'doom_type': 36,
             'region': "Shattered Bridge (E4M8) Main"},
    371754: {'name': 'Shattered Bridge (E4M8) - Tome of Power',
             'episode': 4,
             'check_sanity': True,
             'map': 8,
             'index': 113,
             'doom_type': 86,
             'region': "Shattered Bridge (E4M8) Main"},
    371755: {'name': 'Shattered Bridge (E4M8) - Torch',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 114,
             'doom_type': 33,
             'region': "Shattered Bridge (E4M8) Main"},
    371756: {'name': 'Shattered Bridge (E4M8) - Tome of Power 2',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 115,
             'doom_type': 86,
             'region': "Shattered Bridge (E4M8) Main"},
    371757: {'name': 'Shattered Bridge (E4M8) - Enchanted Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': 118,
             'doom_type': 31,
             'region': "Shattered Bridge (E4M8) Main"},
    371758: {'name': 'Shattered Bridge (E4M8) - Exit',
             'episode': 4,
             'check_sanity': False,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "Shattered Bridge (E4M8) Boss"},
    371759: {'name': 'Mausoleum (E4M9) - Yellow key',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 50,
             'doom_type': 80,
             'region': "Mausoleum (E4M9) Main"},
    371760: {'name': 'Mausoleum (E4M9) - Gauntlets of the Necromancer',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 59,
             'doom_type': 2005,
             'region': "Mausoleum (E4M9) Main"},
    371761: {'name': 'Mausoleum (E4M9) - Ethereal Crossbow',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 60,
             'doom_type': 2001,
             'region': "Mausoleum (E4M9) Main"},
    371762: {'name': 'Mausoleum (E4M9) - Dragon Claw',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 61,
             'doom_type': 53,
             'region': "Mausoleum (E4M9) Main"},
    371763: {'name': 'Mausoleum (E4M9) - Hellstaff',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 62,
             'doom_type': 2004,
             'region': "Mausoleum (E4M9) Main"},
    371764: {'name': 'Mausoleum (E4M9) - Phoenix Rod',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 63,
             'doom_type': 2003,
             'region': "Mausoleum (E4M9) Main"},
    371765: {'name': 'Mausoleum (E4M9) - Firemace',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 64,
             'doom_type': 2002,
             'region': "Mausoleum (E4M9) Main"},
    371766: {'name': 'Mausoleum (E4M9) - Firemace 2',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 65,
             'doom_type': 2002,
             'region': "Mausoleum (E4M9) Main"},
    371767: {'name': 'Mausoleum (E4M9) - Firemace 3',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 66,
             'doom_type': 2002,
             'region': "Mausoleum (E4M9) Main"},
    371768: {'name': 'Mausoleum (E4M9) - Firemace 4',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 67,
             'doom_type': 2002,
             'region': "Mausoleum (E4M9) Main"},
    371769: {'name': 'Mausoleum (E4M9) - Bag of Holding',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 68,
             'doom_type': 8,
             'region': "Mausoleum (E4M9) Main"},
    371770: {'name': 'Mausoleum (E4M9) - Bag of Holding 2',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 69,
             'doom_type': 8,
             'region': "Mausoleum (E4M9) Main"},
    371771: {'name': 'Mausoleum (E4M9) - Bag of Holding 3',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 70,
             'doom_type': 8,
             'region': "Mausoleum (E4M9) Main"},
    371772: {'name': 'Mausoleum (E4M9) - Bag of Holding 4',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 71,
             'doom_type': 8,
             'region': "Mausoleum (E4M9) Yellow"},
    371773: {'name': 'Mausoleum (E4M9) - Morph Ovum',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 79,
             'doom_type': 30,
             'region': "Mausoleum (E4M9) Main"},
    371774: {'name': 'Mausoleum (E4M9) - Mystic Urn',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 81,
             'doom_type': 32,
             'region': "Mausoleum (E4M9) Main"},
    371775: {'name': 'Mausoleum (E4M9) - Shadowsphere',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 82,
             'doom_type': 75,
             'region': "Mausoleum (E4M9) Main"},
    371776: {'name': 'Mausoleum (E4M9) - Ring of Invincibility',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 83,
             'doom_type': 84,
             'region': "Mausoleum (E4M9) Main"},
    371777: {'name': 'Mausoleum (E4M9) - Silver Shield',
             'episode': 4,
             'check_sanity': True,
             'map': 9,
             'index': 84,
             'doom_type': 85,
             'region': "Mausoleum (E4M9) Main"},
    371778: {'name': 'Mausoleum (E4M9) - Silver Shield 2',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 85,
             'doom_type': 85,
             'region': "Mausoleum (E4M9) Main"},
    371779: {'name': 'Mausoleum (E4M9) - Enchanted Shield',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 86,
             'doom_type': 31,
             'region': "Mausoleum (E4M9) Yellow"},
    371780: {'name': 'Mausoleum (E4M9) - Map Scroll',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 87,
             'doom_type': 35,
             'region': "Mausoleum (E4M9) Yellow"},
    371781: {'name': 'Mausoleum (E4M9) - Chaos Device',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 88,
             'doom_type': 36,
             'region': "Mausoleum (E4M9) Main"},
    371782: {'name': 'Mausoleum (E4M9) - Torch',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 89,
             'doom_type': 33,
             'region': "Mausoleum (E4M9) Main"},
    371783: {'name': 'Mausoleum (E4M9) - Torch 2',
             'episode': 4,
             'check_sanity': True,
             'map': 9,
             'index': 90,
             'doom_type': 33,
             'region': "Mausoleum (E4M9) Main"},
    371784: {'name': 'Mausoleum (E4M9) - Tome of Power',
             'episode': 4,
             'check_sanity': True,
             'map': 9,
             'index': 91,
             'doom_type': 86,
             'region': "Mausoleum (E4M9) Main"},
    371785: {'name': 'Mausoleum (E4M9) - Tome of Power 2',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 93,
             'doom_type': 86,
             'region': "Mausoleum (E4M9) Main"},
    371786: {'name': 'Mausoleum (E4M9) - Tome of Power 3',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': 94,
             'doom_type': 86,
             'region': "Mausoleum (E4M9) Main"},
    371787: {'name': 'Mausoleum (E4M9) - Exit',
             'episode': 4,
             'check_sanity': False,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "Mausoleum (E4M9) Yellow"},
    371788: {'name': 'Ochre Cliffs (E5M1) - Yellow key',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 4,
             'doom_type': 80,
             'region': "Ochre Cliffs (E5M1) Main"},
    371789: {'name': 'Ochre Cliffs (E5M1) - Blue key',
             'episode': 5,
             'check_sanity': True,
             'map': 1,
             'index': 7,
             'doom_type': 79,
             'region': "Ochre Cliffs (E5M1) Green"},
    371790: {'name': 'Ochre Cliffs (E5M1) - Green key',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 9,
             'doom_type': 73,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371791: {'name': 'Ochre Cliffs (E5M1) - Gauntlets of the Necromancer',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 92,
             'doom_type': 2005,
             'region': "Ochre Cliffs (E5M1) Main"},
    371792: {'name': 'Ochre Cliffs (E5M1) - Ethereal Crossbow',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 93,
             'doom_type': 2001,
             'region': "Ochre Cliffs (E5M1) Main"},
    371793: {'name': 'Ochre Cliffs (E5M1) - Dragon Claw',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 94,
             'doom_type': 53,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371794: {'name': 'Ochre Cliffs (E5M1) - Hellstaff',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 95,
             'doom_type': 2004,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371795: {'name': 'Ochre Cliffs (E5M1) - Phoenix Rod',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 96,
             'doom_type': 2003,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371796: {'name': 'Ochre Cliffs (E5M1) - Firemace',
             'episode': 5,
             'check_sanity': True,
             'map': 1,
             'index': 97,
             'doom_type': 2002,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371797: {'name': 'Ochre Cliffs (E5M1) - Firemace 2',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 98,
             'doom_type': 2002,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371798: {'name': 'Ochre Cliffs (E5M1) - Firemace 3',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 99,
             'doom_type': 2002,
             'region': "Ochre Cliffs (E5M1) Green"},
    371799: {'name': 'Ochre Cliffs (E5M1) - Firemace 4',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 100,
             'doom_type': 2002,
             'region': "Ochre Cliffs (E5M1) Main"},
    371800: {'name': 'Ochre Cliffs (E5M1) - Bag of Holding',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 101,
             'doom_type': 8,
             'region': "Ochre Cliffs (E5M1) Main"},
    371801: {'name': 'Ochre Cliffs (E5M1) - Morph Ovum',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 102,
             'doom_type': 30,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371802: {'name': 'Ochre Cliffs (E5M1) - Mystic Urn',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 112,
             'doom_type': 32,
             'region': "Ochre Cliffs (E5M1) Green"},
    371803: {'name': 'Ochre Cliffs (E5M1) - Shadowsphere',
             'episode': 5,
             'check_sanity': True,
             'map': 1,
             'index': 113,
             'doom_type': 75,
             'region': "Ochre Cliffs (E5M1) Main"},
    371804: {'name': 'Ochre Cliffs (E5M1) - Ring of Invincibility',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 114,
             'doom_type': 84,
             'region': "Ochre Cliffs (E5M1) Blue"},
    371805: {'name': 'Ochre Cliffs (E5M1) - Silver Shield',
             'episode': 5,
             'check_sanity': True,
             'map': 1,
             'index': 115,
             'doom_type': 85,
             'region': "Ochre Cliffs (E5M1) Main"},
    371806: {'name': 'Ochre Cliffs (E5M1) - Enchanted Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 116,
             'doom_type': 31,
             'region': "Ochre Cliffs (E5M1) Blue"},
    371807: {'name': 'Ochre Cliffs (E5M1) - Map Scroll',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 117,
             'doom_type': 35,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371808: {'name': 'Ochre Cliffs (E5M1) - Chaos Device',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 118,
             'doom_type': 36,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371809: {'name': 'Ochre Cliffs (E5M1) - Torch',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 119,
             'doom_type': 33,
             'region': "Ochre Cliffs (E5M1) Main"},
    371810: {'name': 'Ochre Cliffs (E5M1) - Tome of Power',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 120,
             'doom_type': 86,
             'region': "Ochre Cliffs (E5M1) Main"},
    371811: {'name': 'Ochre Cliffs (E5M1) - Tome of Power 2',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 121,
             'doom_type': 86,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371812: {'name': 'Ochre Cliffs (E5M1) - Tome of Power 3',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 122,
             'doom_type': 86,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371813: {'name': 'Ochre Cliffs (E5M1) - Bag of Holding 2',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': 129,
             'doom_type': 8,
             'region': "Ochre Cliffs (E5M1) Yellow"},
    371814: {'name': 'Ochre Cliffs (E5M1) - Exit',
             'episode': 5,
             'check_sanity': False,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "Ochre Cliffs (E5M1) Blue"},
    371815: {'name': 'Rapids (E5M2) - Green key',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 2,
             'doom_type': 73,
             'region': "Rapids (E5M2) Yellow"},
    371816: {'name': 'Rapids (E5M2) - Yellow key',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 3,
             'doom_type': 80,
             'region': "Rapids (E5M2) Main"},
    371817: {'name': 'Rapids (E5M2) - Ethereal Crossbow',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 34,
             'doom_type': 2001,
             'region': "Rapids (E5M2) Main"},
    371818: {'name': 'Rapids (E5M2) - Gauntlets of the Necromancer',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 35,
             'doom_type': 2005,
             'region': "Rapids (E5M2) Main"},
    371819: {'name': 'Rapids (E5M2) - Dragon Claw',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 36,
             'doom_type': 53,
             'region': "Rapids (E5M2) Yellow"},
    371820: {'name': 'Rapids (E5M2) - Hellstaff',
             'episode': 5,
             'check_sanity': True,
             'map': 2,
             'index': 37,
             'doom_type': 2004,
             'region': "Rapids (E5M2) Yellow"},
    371821: {'name': 'Rapids (E5M2) - Phoenix Rod',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 38,
             'doom_type': 2003,
             'region': "Rapids (E5M2) Green"},
    371822: {'name': 'Rapids (E5M2) - Bag of Holding',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 39,
             'doom_type': 8,
             'region': "Rapids (E5M2) Yellow"},
    371823: {'name': 'Rapids (E5M2) - Bag of Holding 2',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 40,
             'doom_type': 8,
             'region': "Rapids (E5M2) Yellow"},
    371824: {'name': 'Rapids (E5M2) - Bag of Holding 3',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 41,
             'doom_type': 8,
             'region': "Rapids (E5M2) Yellow"},
    371825: {'name': 'Rapids (E5M2) - Morph Ovum',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 42,
             'doom_type': 30,
             'region': "Rapids (E5M2) Yellow"},
    371826: {'name': 'Rapids (E5M2) - Mystic Urn',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 50,
             'doom_type': 32,
             'region': "Rapids (E5M2) Green"},
    371827: {'name': 'Rapids (E5M2) - Shadowsphere',
             'episode': 5,
             'check_sanity': True,
             'map': 2,
             'index': 51,
             'doom_type': 75,
             'region': "Rapids (E5M2) Yellow"},
    371828: {'name': 'Rapids (E5M2) - Ring of Invincibility',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 52,
             'doom_type': 84,
             'region': "Rapids (E5M2) Green"},
    371829: {'name': 'Rapids (E5M2) - Silver Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 53,
             'doom_type': 85,
             'region': "Rapids (E5M2) Main"},
    371830: {'name': 'Rapids (E5M2) - Enchanted Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 54,
             'doom_type': 31,
             'region': "Rapids (E5M2) Yellow"},
    371831: {'name': 'Rapids (E5M2) - Map Scroll',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 55,
             'doom_type': 35,
             'region': "Rapids (E5M2) Yellow"},
    371832: {'name': 'Rapids (E5M2) - Tome of Power',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 56,
             'doom_type': 86,
             'region': "Rapids (E5M2) Yellow"},
    371833: {'name': 'Rapids (E5M2) - Chaos Device',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 57,
             'doom_type': 36,
             'region': "Rapids (E5M2) Green"},
    371834: {'name': 'Rapids (E5M2) - Tome of Power 2',
             'episode': 5,
             'check_sanity': True,
             'map': 2,
             'index': 58,
             'doom_type': 86,
             'region': "Rapids (E5M2) Yellow"},
    371835: {'name': 'Rapids (E5M2) - Torch',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 59,
             'doom_type': 33,
             'region': "Rapids (E5M2) Main"},
    371836: {'name': 'Rapids (E5M2) - Enchanted Shield 2',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 66,
             'doom_type': 31,
             'region': "Rapids (E5M2) Main"},
    371837: {'name': 'Rapids (E5M2) - Hellstaff 2',
             'episode': 5,
             'check_sanity': True,
             'map': 2,
             'index': 67,
             'doom_type': 2004,
             'region': "Rapids (E5M2) Main"},
    371838: {'name': 'Rapids (E5M2) - Phoenix Rod 2',
             'episode': 5,
             'check_sanity': True,
             'map': 2,
             'index': 68,
             'doom_type': 2003,
             'region': "Rapids (E5M2) Main"},
    371839: {'name': 'Rapids (E5M2) - Firemace',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 71,
             'doom_type': 2002,
             'region': "Rapids (E5M2) Main"},
    371840: {'name': 'Rapids (E5M2) - Firemace 2',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 72,
             'doom_type': 2002,
             'region': "Rapids (E5M2) Green"},
    371841: {'name': 'Rapids (E5M2) - Firemace 3',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 73,
             'doom_type': 2002,
             'region': "Rapids (E5M2) Green"},
    371842: {'name': 'Rapids (E5M2) - Firemace 4',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 74,
             'doom_type': 2002,
             'region': "Rapids (E5M2) Yellow"},
    371843: {'name': 'Rapids (E5M2) - Firemace 5',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': 75,
             'doom_type': 2002,
             'region': "Rapids (E5M2) Green"},
    371844: {'name': 'Rapids (E5M2) - Exit',
             'episode': 5,
             'check_sanity': False,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "Rapids (E5M2) Green"},
    371845: {'name': 'Quay (E5M3) - Green key',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 12,
             'doom_type': 73,
             'region': "Quay (E5M3) Yellow"},
    371846: {'name': 'Quay (E5M3) - Blue key',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 13,
             'doom_type': 79,
             'region': "Quay (E5M3) Green"},
    371847: {'name': 'Quay (E5M3) - Yellow key',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 15,
             'doom_type': 80,
             'region': "Quay (E5M3) Main"},
    371848: {'name': 'Quay (E5M3) - Ethereal Crossbow',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 212,
             'doom_type': 2001,
             'region': "Quay (E5M3) Main"},
    371849: {'name': 'Quay (E5M3) - Gauntlets of the Necromancer',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 213,
             'doom_type': 2005,
             'region': "Quay (E5M3) Blue"},
    371850: {'name': 'Quay (E5M3) - Dragon Claw',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 214,
             'doom_type': 53,
             'region': "Quay (E5M3) Yellow"},
    371851: {'name': 'Quay (E5M3) - Hellstaff',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 215,
             'doom_type': 2004,
             'region': "Quay (E5M3) Green"},
    371852: {'name': 'Quay (E5M3) - Phoenix Rod',
             'episode': 5,
             'check_sanity': True,
             'map': 3,
             'index': 216,
             'doom_type': 2003,
             'region': "Quay (E5M3) Blue"},
    371853: {'name': 'Quay (E5M3) - Bag of Holding',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 217,
             'doom_type': 8,
             'region': "Quay (E5M3) Main"},
    371854: {'name': 'Quay (E5M3) - Morph Ovum',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 218,
             'doom_type': 30,
             'region': "Quay (E5M3) Blue"},
    371855: {'name': 'Quay (E5M3) - Mystic Urn',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 229,
             'doom_type': 32,
             'region': "Quay (E5M3) Green"},
    371856: {'name': 'Quay (E5M3) - Enchanted Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 230,
             'doom_type': 31,
             'region': "Quay (E5M3) Green"},
    371857: {'name': 'Quay (E5M3) - Ring of Invincibility',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 231,
             'doom_type': 84,
             'region': "Quay (E5M3) Main"},
    371858: {'name': 'Quay (E5M3) - Shadowsphere',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 232,
             'doom_type': 75,
             'region': "Quay (E5M3) Main"},
    371859: {'name': 'Quay (E5M3) - Silver Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 233,
             'doom_type': 85,
             'region': "Quay (E5M3) Main"},
    371860: {'name': 'Quay (E5M3) - Silver Shield 2',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 234,
             'doom_type': 85,
             'region': "Quay (E5M3) Cyan"},
    371861: {'name': 'Quay (E5M3) - Map Scroll',
             'episode': 5,
             'check_sanity': True,
             'map': 3,
             'index': 235,
             'doom_type': 35,
             'region': "Quay (E5M3) Blue"},
    371862: {'name': 'Quay (E5M3) - Chaos Device',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 236,
             'doom_type': 36,
             'region': "Quay (E5M3) Blue"},
    371863: {'name': 'Quay (E5M3) - Tome of Power',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 237,
             'doom_type': 86,
             'region': "Quay (E5M3) Main"},
    371864: {'name': 'Quay (E5M3) - Tome of Power 2',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 238,
             'doom_type': 86,
             'region': "Quay (E5M3) Green"},
    371865: {'name': 'Quay (E5M3) - Tome of Power 3',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 239,
             'doom_type': 86,
             'region': "Quay (E5M3) Cyan"},
    371866: {'name': 'Quay (E5M3) - Torch',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 240,
             'doom_type': 33,
             'region': "Quay (E5M3) Green"},
    371867: {'name': 'Quay (E5M3) - Firemace',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 242,
             'doom_type': 2002,
             'region': "Quay (E5M3) Cyan"},
    371868: {'name': 'Quay (E5M3) - Firemace 2',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 243,
             'doom_type': 2002,
             'region': "Quay (E5M3) Main"},
    371869: {'name': 'Quay (E5M3) - Firemace 3',
             'episode': 5,
             'check_sanity': True,
             'map': 3,
             'index': 244,
             'doom_type': 2002,
             'region': "Quay (E5M3) Yellow"},
    371870: {'name': 'Quay (E5M3) - Firemace 4',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 245,
             'doom_type': 2002,
             'region': "Quay (E5M3) Yellow"},
    371871: {'name': 'Quay (E5M3) - Firemace 5',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 246,
             'doom_type': 2002,
             'region': "Quay (E5M3) Green"},
    371872: {'name': 'Quay (E5M3) - Firemace 6',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': 247,
             'doom_type': 2002,
             'region': "Quay (E5M3) Cyan"},
    371873: {'name': 'Quay (E5M3) - Bag of Holding 2',
             'episode': 5,
             'check_sanity': True,
             'map': 3,
             'index': 252,
             'doom_type': 8,
             'region': "Quay (E5M3) Yellow"},
    371874: {'name': 'Quay (E5M3) - Exit',
             'episode': 5,
             'check_sanity': False,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "Quay (E5M3) Cyan"},
    371875: {'name': 'Courtyard (E5M4) - Blue key',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 3,
             'doom_type': 79,
             'region': "Courtyard (E5M4) Green"},
    371876: {'name': 'Courtyard (E5M4) - Yellow key',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 16,
             'doom_type': 80,
             'region': "Courtyard (E5M4) Main"},
    371877: {'name': 'Courtyard (E5M4) - Green key',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 21,
             'doom_type': 73,
             'region': "Courtyard (E5M4) Yellow"},
    371878: {'name': 'Courtyard (E5M4) - Gauntlets of the Necromancer',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 84,
             'doom_type': 2005,
             'region': "Courtyard (E5M4) Main"},
    371879: {'name': 'Courtyard (E5M4) - Ethereal Crossbow',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 85,
             'doom_type': 2001,
             'region': "Courtyard (E5M4) Main"},
    371880: {'name': 'Courtyard (E5M4) - Dragon Claw',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 86,
             'doom_type': 53,
             'region': "Courtyard (E5M4) Main"},
    371881: {'name': 'Courtyard (E5M4) - Hellstaff',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 87,
             'doom_type': 2004,
             'region': "Courtyard (E5M4) Yellow"},
    371882: {'name': 'Courtyard (E5M4) - Phoenix Rod',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 88,
             'doom_type': 2003,
             'region': "Courtyard (E5M4) Green"},
    371883: {'name': 'Courtyard (E5M4) - Morph Ovum',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 89,
             'doom_type': 30,
             'region': "Courtyard (E5M4) Main"},
    371884: {'name': 'Courtyard (E5M4) - Bag of Holding',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 90,
             'doom_type': 8,
             'region': "Courtyard (E5M4) Main"},
    371885: {'name': 'Courtyard (E5M4) - Silver Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 91,
             'doom_type': 85,
             'region': "Courtyard (E5M4) Main"},
    371886: {'name': 'Courtyard (E5M4) - Mystic Urn',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 103,
             'doom_type': 32,
             'region': "Courtyard (E5M4) Main"},
    371887: {'name': 'Courtyard (E5M4) - Ring of Invincibility',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 104,
             'doom_type': 84,
             'region': "Courtyard (E5M4) Yellow"},
    371888: {'name': 'Courtyard (E5M4) - Shadowsphere',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 105,
             'doom_type': 75,
             'region': "Courtyard (E5M4) Main"},
    371889: {'name': 'Courtyard (E5M4) - Enchanted Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 106,
             'doom_type': 31,
             'region': "Courtyard (E5M4) Blue"},
    371890: {'name': 'Courtyard (E5M4) - Map Scroll',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 107,
             'doom_type': 35,
             'region': "Courtyard (E5M4) Yellow"},
    371891: {'name': 'Courtyard (E5M4) - Chaos Device',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 108,
             'doom_type': 36,
             'region': "Courtyard (E5M4) Green"},
    371892: {'name': 'Courtyard (E5M4) - Tome of Power',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 109,
             'doom_type': 86,
             'region': "Courtyard (E5M4) Main"},
    371893: {'name': 'Courtyard (E5M4) - Tome of Power 2',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 110,
             'doom_type': 86,
             'region': "Courtyard (E5M4) Blue"},
    371894: {'name': 'Courtyard (E5M4) - Tome of Power 3',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 111,
             'doom_type': 86,
             'region': "Courtyard (E5M4) Yellow"},
    371895: {'name': 'Courtyard (E5M4) - Torch',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 112,
             'doom_type': 33,
             'region': "Courtyard (E5M4) Main"},
    371896: {'name': 'Courtyard (E5M4) - Bag of Holding 2',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 213,
             'doom_type': 8,
             'region': "Courtyard (E5M4) Blue"},
    371897: {'name': 'Courtyard (E5M4) - Silver Shield 2',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 219,
             'doom_type': 85,
             'region': "Courtyard (E5M4) Yellow"},
    371898: {'name': 'Courtyard (E5M4) - Bag of Holding 3',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': 272,
             'doom_type': 8,
             'region': "Courtyard (E5M4) Main"},
    371899: {'name': 'Courtyard (E5M4) - Exit',
             'episode': 5,
             'check_sanity': False,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "Courtyard (E5M4) Blue"},
    371900: {'name': 'Hydratyr (E5M5) - Yellow key',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 3,
             'doom_type': 80,
             'region': "Hydratyr (E5M5) Main"},
    371901: {'name': 'Hydratyr (E5M5) - Green key',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 5,
             'doom_type': 73,
             'region': "Hydratyr (E5M5) Yellow"},
    371902: {'name': 'Hydratyr (E5M5) - Blue key',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 11,
             'doom_type': 79,
             'region': "Hydratyr (E5M5) Green"},
    371903: {'name': 'Hydratyr (E5M5) - Ethereal Crossbow',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 238,
             'doom_type': 2001,
             'region': "Hydratyr (E5M5) Main"},
    371904: {'name': 'Hydratyr (E5M5) - Gauntlets of the Necromancer',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 239,
             'doom_type': 2005,
             'region': "Hydratyr (E5M5) Yellow"},
    371905: {'name': 'Hydratyr (E5M5) - Hellstaff',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 240,
             'doom_type': 2004,
             'region': "Hydratyr (E5M5) Yellow"},
    371906: {'name': 'Hydratyr (E5M5) - Dragon Claw',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 241,
             'doom_type': 53,
             'region': "Hydratyr (E5M5) Yellow"},
    371907: {'name': 'Hydratyr (E5M5) - Phoenix Rod',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 242,
             'doom_type': 2003,
             'region': "Hydratyr (E5M5) Green"},
    371908: {'name': 'Hydratyr (E5M5) - Firemace',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 243,
             'doom_type': 2002,
             'region': "Hydratyr (E5M5) Green"},
    371909: {'name': 'Hydratyr (E5M5) - Firemace 2',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 244,
             'doom_type': 2002,
             'region': "Hydratyr (E5M5) Green"},
    371910: {'name': 'Hydratyr (E5M5) - Firemace 3',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 245,
             'doom_type': 2002,
             'region': "Hydratyr (E5M5) Green"},
    371911: {'name': 'Hydratyr (E5M5) - Firemace 4',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 246,
             'doom_type': 2002,
             'region': "Hydratyr (E5M5) Green"},
    371912: {'name': 'Hydratyr (E5M5) - Bag of Holding',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 248,
             'doom_type': 8,
             'region': "Hydratyr (E5M5) Main"},
    371913: {'name': 'Hydratyr (E5M5) - Morph Ovum',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 259,
             'doom_type': 30,
             'region': "Hydratyr (E5M5) Green"},
    371914: {'name': 'Hydratyr (E5M5) - Bag of Holding 2',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 260,
             'doom_type': 8,
             'region': "Hydratyr (E5M5) Green"},
    371915: {'name': 'Hydratyr (E5M5) - Mystic Urn',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 261,
             'doom_type': 32,
             'region': "Hydratyr (E5M5) Blue"},
    371916: {'name': 'Hydratyr (E5M5) - Tome of Power',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 262,
             'doom_type': 86,
             'region': "Hydratyr (E5M5) Main"},
    371917: {'name': 'Hydratyr (E5M5) - Shadowsphere',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 263,
             'doom_type': 75,
             'region': "Hydratyr (E5M5) Main"},
    371918: {'name': 'Hydratyr (E5M5) - Ring of Invincibility',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 264,
             'doom_type': 84,
             'region': "Hydratyr (E5M5) Yellow"},
    371919: {'name': 'Hydratyr (E5M5) - Chaos Device',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 265,
             'doom_type': 36,
             'region': "Hydratyr (E5M5) Yellow"},
    371920: {'name': 'Hydratyr (E5M5) - Map Scroll',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 266,
             'doom_type': 35,
             'region': "Hydratyr (E5M5) Yellow"},
    371921: {'name': 'Hydratyr (E5M5) - Enchanted Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 267,
             'doom_type': 31,
             'region': "Hydratyr (E5M5) Green"},
    371922: {'name': 'Hydratyr (E5M5) - Torch',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 268,
             'doom_type': 33,
             'region': "Hydratyr (E5M5) Main"},
    371923: {'name': 'Hydratyr (E5M5) - Tome of Power 2',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 269,
             'doom_type': 86,
             'region': "Hydratyr (E5M5) Blue"},
    371924: {'name': 'Hydratyr (E5M5) - Silver Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 270,
             'doom_type': 85,
             'region': "Hydratyr (E5M5) Blue"},
    371925: {'name': 'Hydratyr (E5M5) - Silver Shield 2',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 271,
             'doom_type': 85,
             'region': "Hydratyr (E5M5) Main"},
    371926: {'name': 'Hydratyr (E5M5) - Tome of Power 3',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': 272,
             'doom_type': 86,
             'region': "Hydratyr (E5M5) Yellow"},
    371927: {'name': 'Hydratyr (E5M5) - Exit',
             'episode': 5,
             'check_sanity': False,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "Hydratyr (E5M5) Blue"},
    371928: {'name': 'Colonnade (E5M6) - Yellow key',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 8,
             'doom_type': 80,
             'region': "Colonnade (E5M6) Main"},
    371929: {'name': 'Colonnade (E5M6) - Green key',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 9,
             'doom_type': 73,
             'region': "Colonnade (E5M6) Yellow"},
    371930: {'name': 'Colonnade (E5M6) - Blue key',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 10,
             'doom_type': 79,
             'region': "Colonnade (E5M6) Green"},
    371931: {'name': 'Colonnade (E5M6) - Dragon Claw',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 91,
             'doom_type': 53,
             'region': "Colonnade (E5M6) Main"},
    371932: {'name': 'Colonnade (E5M6) - Hellstaff',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 92,
             'doom_type': 2004,
             'region': "Colonnade (E5M6) Yellow"},
    371933: {'name': 'Colonnade (E5M6) - Phoenix Rod',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 93,
             'doom_type': 2003,
             'region': "Colonnade (E5M6) Green"},
    371934: {'name': 'Colonnade (E5M6) - Gauntlets of the Necromancer',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 94,
             'doom_type': 2005,
             'region': "Colonnade (E5M6) Yellow"},
    371935: {'name': 'Colonnade (E5M6) - Firemace',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 95,
             'doom_type': 2002,
             'region': "Colonnade (E5M6) Yellow"},
    371936: {'name': 'Colonnade (E5M6) - Firemace 2',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 96,
             'doom_type': 2002,
             'region': "Colonnade (E5M6) Yellow"},
    371937: {'name': 'Colonnade (E5M6) - Firemace 3',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 97,
             'doom_type': 2002,
             'region': "Colonnade (E5M6) Yellow"},
    371938: {'name': 'Colonnade (E5M6) - Firemace 4',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 98,
             'doom_type': 2002,
             'region': "Colonnade (E5M6) Main"},
    371939: {'name': 'Colonnade (E5M6) - Firemace 5',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 99,
             'doom_type': 2002,
             'region': "Colonnade (E5M6) Main"},
    371940: {'name': 'Colonnade (E5M6) - Enchanted Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 100,
             'doom_type': 31,
             'region': "Colonnade (E5M6) Yellow"},
    371941: {'name': 'Colonnade (E5M6) - Tome of Power',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 101,
             'doom_type': 86,
             'region': "Colonnade (E5M6) Yellow"},
    371942: {'name': 'Colonnade (E5M6) - Silver Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 102,
             'doom_type': 85,
             'region': "Colonnade (E5M6) Main"},
    371943: {'name': 'Colonnade (E5M6) - Morph Ovum',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 103,
             'doom_type': 30,
             'region': "Colonnade (E5M6) Main"},
    371944: {'name': 'Colonnade (E5M6) - Chaos Device',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 104,
             'doom_type': 36,
             'region': "Colonnade (E5M6) Main"},
    371945: {'name': 'Colonnade (E5M6) - Bag of Holding',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 105,
             'doom_type': 8,
             'region': "Colonnade (E5M6) Main"},
    371946: {'name': 'Colonnade (E5M6) - Bag of Holding 2',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 106,
             'doom_type': 8,
             'region': "Colonnade (E5M6) Green"},
    371947: {'name': 'Colonnade (E5M6) - Mystic Urn',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 121,
             'doom_type': 32,
             'region': "Colonnade (E5M6) Yellow"},
    371948: {'name': 'Colonnade (E5M6) - Shadowsphere',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 122,
             'doom_type': 75,
             'region': "Colonnade (E5M6) Yellow"},
    371949: {'name': 'Colonnade (E5M6) - Ring of Invincibility',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 123,
             'doom_type': 84,
             'region': "Colonnade (E5M6) Main"},
    371950: {'name': 'Colonnade (E5M6) - Torch',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 124,
             'doom_type': 33,
             'region': "Colonnade (E5M6) Yellow"},
    371951: {'name': 'Colonnade (E5M6) - Map Scroll',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 125,
             'doom_type': 35,
             'region': "Colonnade (E5M6) Yellow"},
    371952: {'name': 'Colonnade (E5M6) - Tome of Power 2',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 126,
             'doom_type': 86,
             'region': "Colonnade (E5M6) Yellow"},
    371953: {'name': 'Colonnade (E5M6) - Mystic Urn 2',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 127,
             'doom_type': 32,
             'region': "Colonnade (E5M6) Blue"},
    371954: {'name': 'Colonnade (E5M6) - Ring of Invincibility 2',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 128,
             'doom_type': 84,
             'region': "Colonnade (E5M6) Blue"},
    371955: {'name': 'Colonnade (E5M6) - Ethereal Crossbow',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': 348,
             'doom_type': 2001,
             'region': "Colonnade (E5M6) Main"},
    371956: {'name': 'Colonnade (E5M6) - Exit',
             'episode': 5,
             'check_sanity': False,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "Colonnade (E5M6) Blue"},
    371957: {'name': 'Foetid Manse (E5M7) - Enchanted Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 7,
             'doom_type': 31,
             'region': "Foetid Manse (E5M7) Blue"},
    371958: {'name': 'Foetid Manse (E5M7) - Mystic Urn',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 8,
             'doom_type': 32,
             'region': "Foetid Manse (E5M7) Yellow"},
    371959: {'name': 'Foetid Manse (E5M7) - Morph Ovum',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 9,
             'doom_type': 30,
             'region': "Foetid Manse (E5M7) Green"},
    371960: {'name': 'Foetid Manse (E5M7) - Green key',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 12,
             'doom_type': 73,
             'region': "Foetid Manse (E5M7) Yellow"},
    371961: {'name': 'Foetid Manse (E5M7) - Yellow key',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 15,
             'doom_type': 80,
             'region': "Foetid Manse (E5M7) Main"},
    371962: {'name': 'Foetid Manse (E5M7) - Ethereal Crossbow',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 218,
             'doom_type': 2001,
             'region': "Foetid Manse (E5M7) Main"},
    371963: {'name': 'Foetid Manse (E5M7) - Gauntlets of the Necromancer',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 219,
             'doom_type': 2005,
             'region': "Foetid Manse (E5M7) Main"},
    371964: {'name': 'Foetid Manse (E5M7) - Dragon Claw',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 220,
             'doom_type': 53,
             'region': "Foetid Manse (E5M7) Yellow"},
    371965: {'name': 'Foetid Manse (E5M7) - Hellstaff',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 221,
             'doom_type': 2004,
             'region': "Foetid Manse (E5M7) Green"},
    371966: {'name': 'Foetid Manse (E5M7) - Phoenix Rod',
             'episode': 5,
             'check_sanity': True,
             'map': 7,
             'index': 222,
             'doom_type': 2003,
             'region': "Foetid Manse (E5M7) Green"},
    371967: {'name': 'Foetid Manse (E5M7) - Shadowsphere',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 223,
             'doom_type': 75,
             'region': "Foetid Manse (E5M7) Yellow"},
    371968: {'name': 'Foetid Manse (E5M7) - Ring of Invincibility',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 224,
             'doom_type': 84,
             'region': "Foetid Manse (E5M7) Yellow"},
    371969: {'name': 'Foetid Manse (E5M7) - Silver Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 225,
             'doom_type': 85,
             'region': "Foetid Manse (E5M7) Green"},
    371970: {'name': 'Foetid Manse (E5M7) - Map Scroll',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 234,
             'doom_type': 35,
             'region': "Foetid Manse (E5M7) Green"},
    371971: {'name': 'Foetid Manse (E5M7) - Tome of Power',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 235,
             'doom_type': 86,
             'region': "Foetid Manse (E5M7) Yellow"},
    371972: {'name': 'Foetid Manse (E5M7) - Tome of Power 2',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 236,
             'doom_type': 86,
             'region': "Foetid Manse (E5M7) Green"},
    371973: {'name': 'Foetid Manse (E5M7) - Tome of Power 3',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 237,
             'doom_type': 86,
             'region': "Foetid Manse (E5M7) Green"},
    371974: {'name': 'Foetid Manse (E5M7) - Torch',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 238,
             'doom_type': 33,
             'region': "Foetid Manse (E5M7) Yellow"},
    371975: {'name': 'Foetid Manse (E5M7) - Chaos Device',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 239,
             'doom_type': 36,
             'region': "Foetid Manse (E5M7) Green"},
    371976: {'name': 'Foetid Manse (E5M7) - Bag of Holding',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': 240,
             'doom_type': 8,
             'region': "Foetid Manse (E5M7) Green"},
    371977: {'name': 'Foetid Manse (E5M7) - Exit',
             'episode': 5,
             'check_sanity': False,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "Foetid Manse (E5M7) Blue"},
    371978: {'name': 'Field of Judgement (E5M8) - Hellstaff',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 18,
             'doom_type': 2004,
             'region': "Field of Judgement (E5M8) Main"},
    371979: {'name': 'Field of Judgement (E5M8) - Phoenix Rod',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 19,
             'doom_type': 2003,
             'region': "Field of Judgement (E5M8) Main"},
    371980: {'name': 'Field of Judgement (E5M8) - Ethereal Crossbow',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 20,
             'doom_type': 2001,
             'region': "Field of Judgement (E5M8) Main"},
    371981: {'name': 'Field of Judgement (E5M8) - Dragon Claw',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 21,
             'doom_type': 53,
             'region': "Field of Judgement (E5M8) Main"},
    371982: {'name': 'Field of Judgement (E5M8) - Gauntlets of the Necromancer',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 22,
             'doom_type': 2005,
             'region': "Field of Judgement (E5M8) Main"},
    371983: {'name': 'Field of Judgement (E5M8) - Mystic Urn',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 23,
             'doom_type': 32,
             'region': "Field of Judgement (E5M8) Main"},
    371984: {'name': 'Field of Judgement (E5M8) - Shadowsphere',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 24,
             'doom_type': 75,
             'region': "Field of Judgement (E5M8) Main"},
    371985: {'name': 'Field of Judgement (E5M8) - Enchanted Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 25,
             'doom_type': 31,
             'region': "Field of Judgement (E5M8) Main"},
    371986: {'name': 'Field of Judgement (E5M8) - Ring of Invincibility',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 26,
             'doom_type': 84,
             'region': "Field of Judgement (E5M8) Main"},
    371987: {'name': 'Field of Judgement (E5M8) - Tome of Power',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 27,
             'doom_type': 86,
             'region': "Field of Judgement (E5M8) Main"},
    371988: {'name': 'Field of Judgement (E5M8) - Chaos Device',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 28,
             'doom_type': 36,
             'region': "Field of Judgement (E5M8) Main"},
    371989: {'name': 'Field of Judgement (E5M8) - Silver Shield',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 29,
             'doom_type': 85,
             'region': "Field of Judgement (E5M8) Main"},
    371990: {'name': 'Field of Judgement (E5M8) - Bag of Holding',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': 62,
             'doom_type': 8,
             'region': "Field of Judgement (E5M8) Main"},
    371991: {'name': 'Field of Judgement (E5M8) - Exit',
             'episode': 5,
             'check_sanity': False,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "Field of Judgement (E5M8) Main"},
    371992: {'name': "Skein of D'Sparil (E5M9) - Blue key",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 0,
             'doom_type': 79,
             'region': "Skein of D'Sparil (E5M9) Green"},
    371993: {'name': "Skein of D'Sparil (E5M9) - Green key",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 1,
             'doom_type': 73,
             'region': "Skein of D'Sparil (E5M9) Yellow"},
    371994: {'name': "Skein of D'Sparil (E5M9) - Yellow key",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 13,
             'doom_type': 80,
             'region': "Skein of D'Sparil (E5M9) Main"},
    371995: {'name': "Skein of D'Sparil (E5M9) - Ethereal Crossbow",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 21,
             'doom_type': 2001,
             'region': "Skein of D'Sparil (E5M9) Main"},
    371996: {'name': "Skein of D'Sparil (E5M9) - Dragon Claw",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 44,
             'doom_type': 53,
             'region': "Skein of D'Sparil (E5M9) Main"},
    371997: {'name': "Skein of D'Sparil (E5M9) - Gauntlets of the Necromancer",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 45,
             'doom_type': 2005,
             'region': "Skein of D'Sparil (E5M9) Main"},
    371998: {'name': "Skein of D'Sparil (E5M9) - Hellstaff",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 46,
             'doom_type': 2004,
             'region': "Skein of D'Sparil (E5M9) Yellow"},
    371999: {'name': "Skein of D'Sparil (E5M9) - Phoenix Rod",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 47,
             'doom_type': 2003,
             'region': "Skein of D'Sparil (E5M9) Blue"},
    372000: {'name': "Skein of D'Sparil (E5M9) - Bag of Holding",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 48,
             'doom_type': 8,
             'region': "Skein of D'Sparil (E5M9) Main"},
    372001: {'name': "Skein of D'Sparil (E5M9) - Silver Shield",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 51,
             'doom_type': 85,
             'region': "Skein of D'Sparil (E5M9) Main"},
    372002: {'name': "Skein of D'Sparil (E5M9) - Tome of Power",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 52,
             'doom_type': 86,
             'region': "Skein of D'Sparil (E5M9) Green"},
    372003: {'name': "Skein of D'Sparil (E5M9) - Torch",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 53,
             'doom_type': 33,
             'region': "Skein of D'Sparil (E5M9) Main"},
    372004: {'name': "Skein of D'Sparil (E5M9) - Morph Ovum",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 54,
             'doom_type': 30,
             'region': "Skein of D'Sparil (E5M9) Main"},
    372005: {'name': "Skein of D'Sparil (E5M9) - Shadowsphere",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 64,
             'doom_type': 75,
             'region': "Skein of D'Sparil (E5M9) Yellow"},
    372006: {'name': "Skein of D'Sparil (E5M9) - Chaos Device",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 65,
             'doom_type': 36,
             'region': "Skein of D'Sparil (E5M9) Main"},
    372007: {'name': "Skein of D'Sparil (E5M9) - Ring of Invincibility",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 66,
             'doom_type': 84,
             'region': "Skein of D'Sparil (E5M9) Main"},
    372008: {'name': "Skein of D'Sparil (E5M9) - Enchanted Shield",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 67,
             'doom_type': 31,
             'region': "Skein of D'Sparil (E5M9) Blue"},
    372009: {'name': "Skein of D'Sparil (E5M9) - Mystic Urn",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 68,
             'doom_type': 32,
             'region': "Skein of D'Sparil (E5M9) Blue"},
    372010: {'name': "Skein of D'Sparil (E5M9) - Tome of Power 2",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 69,
             'doom_type': 86,
             'region': "Skein of D'Sparil (E5M9) Green"},
    372011: {'name': "Skein of D'Sparil (E5M9) - Map Scroll",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 70,
             'doom_type': 35,
             'region': "Skein of D'Sparil (E5M9) Green"},
    372012: {'name': "Skein of D'Sparil (E5M9) - Bag of Holding 2",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': 243,
             'doom_type': 8,
             'region': "Skein of D'Sparil (E5M9) Blue"},
    372013: {'name': "Skein of D'Sparil (E5M9) - Exit",
             'episode': 5,
             'check_sanity': False,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "Skein of D'Sparil (E5M9) Blue"},
}


location_name_groups: Dict[str, Set[str]] = {
    'Ambulatory (E4M3)': {
        'Ambulatory (E4M3) - Bag of Holding',
        'Ambulatory (E4M3) - Bag of Holding 2',
        'Ambulatory (E4M3) - Blue key',
        'Ambulatory (E4M3) - Chaos Device',
        'Ambulatory (E4M3) - Dragon Claw',
        'Ambulatory (E4M3) - Enchanted Shield',
        'Ambulatory (E4M3) - Ethereal Crossbow',
        'Ambulatory (E4M3) - Exit',
        'Ambulatory (E4M3) - Firemace',
        'Ambulatory (E4M3) - Firemace 2',
        'Ambulatory (E4M3) - Firemace 3',
        'Ambulatory (E4M3) - Firemace 4',
        'Ambulatory (E4M3) - Firemace 5',
        'Ambulatory (E4M3) - Gauntlets of the Necromancer',
        'Ambulatory (E4M3) - Green key',
        'Ambulatory (E4M3) - Hellstaff',
        'Ambulatory (E4M3) - Map Scroll',
        'Ambulatory (E4M3) - Morph Ovum',
        'Ambulatory (E4M3) - Morph Ovum 2',
        'Ambulatory (E4M3) - Mystic Urn',
        'Ambulatory (E4M3) - Phoenix Rod',
        'Ambulatory (E4M3) - Ring of Invincibility',
        'Ambulatory (E4M3) - Ring of Invincibility 2',
        'Ambulatory (E4M3) - Shadowsphere',
        'Ambulatory (E4M3) - Silver Shield',
        'Ambulatory (E4M3) - Tome of Power',
        'Ambulatory (E4M3) - Tome of Power 2',
        'Ambulatory (E4M3) - Torch',
        'Ambulatory (E4M3) - Yellow key',
    },
    'Blockhouse (E4M2)': {
        'Blockhouse (E4M2) - Bag of Holding',
        'Blockhouse (E4M2) - Bag of Holding 2',
        'Blockhouse (E4M2) - Blue key',
        'Blockhouse (E4M2) - Chaos Device',
        'Blockhouse (E4M2) - Dragon Claw',
        'Blockhouse (E4M2) - Enchanted Shield',
        'Blockhouse (E4M2) - Ethereal Crossbow',
        'Blockhouse (E4M2) - Exit',
        'Blockhouse (E4M2) - Gauntlets of the Necromancer',
        'Blockhouse (E4M2) - Green key',
        'Blockhouse (E4M2) - Hellstaff',
        'Blockhouse (E4M2) - Morph Ovum',
        'Blockhouse (E4M2) - Mystic Urn',
        'Blockhouse (E4M2) - Phoenix Rod',
        'Blockhouse (E4M2) - Ring of Invincibility',
        'Blockhouse (E4M2) - Ring of Invincibility 2',
        'Blockhouse (E4M2) - Shadowsphere',
        'Blockhouse (E4M2) - Shadowsphere 2',
        'Blockhouse (E4M2) - Silver Shield',
        'Blockhouse (E4M2) - Tome of Power',
        'Blockhouse (E4M2) - Yellow key',
    },
    'Catafalque (E4M1)': {
        'Catafalque (E4M1) - Bag of Holding',
        'Catafalque (E4M1) - Chaos Device',
        'Catafalque (E4M1) - Dragon Claw',
        'Catafalque (E4M1) - Ethereal Crossbow',
        'Catafalque (E4M1) - Exit',
        'Catafalque (E4M1) - Gauntlets of the Necromancer',
        'Catafalque (E4M1) - Green key',
        'Catafalque (E4M1) - Hellstaff',
        'Catafalque (E4M1) - Map Scroll',
        'Catafalque (E4M1) - Morph Ovum',
        'Catafalque (E4M1) - Ring of Invincibility',
        'Catafalque (E4M1) - Shadowsphere',
        'Catafalque (E4M1) - Silver Shield',
        'Catafalque (E4M1) - Tome of Power',
        'Catafalque (E4M1) - Tome of Power 2',
        'Catafalque (E4M1) - Torch',
        'Catafalque (E4M1) - Yellow key',
    },
    'Colonnade (E5M6)': {
        'Colonnade (E5M6) - Bag of Holding',
        'Colonnade (E5M6) - Bag of Holding 2',
        'Colonnade (E5M6) - Blue key',
        'Colonnade (E5M6) - Chaos Device',
        'Colonnade (E5M6) - Dragon Claw',
        'Colonnade (E5M6) - Enchanted Shield',
        'Colonnade (E5M6) - Ethereal Crossbow',
        'Colonnade (E5M6) - Exit',
        'Colonnade (E5M6) - Firemace',
        'Colonnade (E5M6) - Firemace 2',
        'Colonnade (E5M6) - Firemace 3',
        'Colonnade (E5M6) - Firemace 4',
        'Colonnade (E5M6) - Firemace 5',
        'Colonnade (E5M6) - Gauntlets of the Necromancer',
        'Colonnade (E5M6) - Green key',
        'Colonnade (E5M6) - Hellstaff',
        'Colonnade (E5M6) - Map Scroll',
        'Colonnade (E5M6) - Morph Ovum',
        'Colonnade (E5M6) - Mystic Urn',
        'Colonnade (E5M6) - Mystic Urn 2',
        'Colonnade (E5M6) - Phoenix Rod',
        'Colonnade (E5M6) - Ring of Invincibility',
        'Colonnade (E5M6) - Ring of Invincibility 2',
        'Colonnade (E5M6) - Shadowsphere',
        'Colonnade (E5M6) - Silver Shield',
        'Colonnade (E5M6) - Tome of Power',
        'Colonnade (E5M6) - Tome of Power 2',
        'Colonnade (E5M6) - Torch',
        'Colonnade (E5M6) - Yellow key',
    },
    'Courtyard (E5M4)': {
        'Courtyard (E5M4) - Bag of Holding',
        'Courtyard (E5M4) - Bag of Holding 2',
        'Courtyard (E5M4) - Bag of Holding 3',
        'Courtyard (E5M4) - Blue key',
        'Courtyard (E5M4) - Chaos Device',
        'Courtyard (E5M4) - Dragon Claw',
        'Courtyard (E5M4) - Enchanted Shield',
        'Courtyard (E5M4) - Ethereal Crossbow',
        'Courtyard (E5M4) - Exit',
        'Courtyard (E5M4) - Gauntlets of the Necromancer',
        'Courtyard (E5M4) - Green key',
        'Courtyard (E5M4) - Hellstaff',
        'Courtyard (E5M4) - Map Scroll',
        'Courtyard (E5M4) - Morph Ovum',
        'Courtyard (E5M4) - Mystic Urn',
        'Courtyard (E5M4) - Phoenix Rod',
        'Courtyard (E5M4) - Ring of Invincibility',
        'Courtyard (E5M4) - Shadowsphere',
        'Courtyard (E5M4) - Silver Shield',
        'Courtyard (E5M4) - Silver Shield 2',
        'Courtyard (E5M4) - Tome of Power',
        'Courtyard (E5M4) - Tome of Power 2',
        'Courtyard (E5M4) - Tome of Power 3',
        'Courtyard (E5M4) - Torch',
        'Courtyard (E5M4) - Yellow key',
    },
    "D'Sparil's Keep (E3M8)": {
        "D'Sparil's Keep (E3M8) - Bag of Holding",
        "D'Sparil's Keep (E3M8) - Chaos Device",
        "D'Sparil's Keep (E3M8) - Dragon Claw",
        "D'Sparil's Keep (E3M8) - Enchanted Shield",
        "D'Sparil's Keep (E3M8) - Ethereal Crossbow",
        "D'Sparil's Keep (E3M8) - Exit",
        "D'Sparil's Keep (E3M8) - Gauntlets of the Necromancer",
        "D'Sparil's Keep (E3M8) - Hellstaff",
        "D'Sparil's Keep (E3M8) - Mystic Urn",
        "D'Sparil's Keep (E3M8) - Phoenix Rod",
        "D'Sparil's Keep (E3M8) - Ring of Invincibility",
        "D'Sparil's Keep (E3M8) - Shadowsphere",
        "D'Sparil's Keep (E3M8) - Silver Shield",
        "D'Sparil's Keep (E3M8) - Tome of Power",
        "D'Sparil's Keep (E3M8) - Tome of Power 2",
        "D'Sparil's Keep (E3M8) - Tome of Power 3",
    },
    'Field of Judgement (E5M8)': {
        'Field of Judgement (E5M8) - Bag of Holding',
        'Field of Judgement (E5M8) - Chaos Device',
        'Field of Judgement (E5M8) - Dragon Claw',
        'Field of Judgement (E5M8) - Enchanted Shield',
        'Field of Judgement (E5M8) - Ethereal Crossbow',
        'Field of Judgement (E5M8) - Exit',
        'Field of Judgement (E5M8) - Gauntlets of the Necromancer',
        'Field of Judgement (E5M8) - Hellstaff',
        'Field of Judgement (E5M8) - Mystic Urn',
        'Field of Judgement (E5M8) - Phoenix Rod',
        'Field of Judgement (E5M8) - Ring of Invincibility',
        'Field of Judgement (E5M8) - Shadowsphere',
        'Field of Judgement (E5M8) - Silver Shield',
        'Field of Judgement (E5M8) - Tome of Power',
    },
    'Foetid Manse (E5M7)': {
        'Foetid Manse (E5M7) - Bag of Holding',
        'Foetid Manse (E5M7) - Chaos Device',
        'Foetid Manse (E5M7) - Dragon Claw',
        'Foetid Manse (E5M7) - Enchanted Shield',
        'Foetid Manse (E5M7) - Ethereal Crossbow',
        'Foetid Manse (E5M7) - Exit',
        'Foetid Manse (E5M7) - Gauntlets of the Necromancer',
        'Foetid Manse (E5M7) - Green key',
        'Foetid Manse (E5M7) - Hellstaff',
        'Foetid Manse (E5M7) - Map Scroll',
        'Foetid Manse (E5M7) - Morph Ovum',
        'Foetid Manse (E5M7) - Mystic Urn',
        'Foetid Manse (E5M7) - Phoenix Rod',
        'Foetid Manse (E5M7) - Ring of Invincibility',
        'Foetid Manse (E5M7) - Shadowsphere',
        'Foetid Manse (E5M7) - Silver Shield',
        'Foetid Manse (E5M7) - Tome of Power',
        'Foetid Manse (E5M7) - Tome of Power 2',
        'Foetid Manse (E5M7) - Tome of Power 3',
        'Foetid Manse (E5M7) - Torch',
        'Foetid Manse (E5M7) - Yellow key',
    },
    'Great Stair (E4M5)': {
        'Great Stair (E4M5) - Bag of Holding',
        'Great Stair (E4M5) - Bag of Holding 2',
        'Great Stair (E4M5) - Blue key',
        'Great Stair (E4M5) - Chaos Device',
        'Great Stair (E4M5) - Dragon Claw',
        'Great Stair (E4M5) - Enchanted Shield',
        'Great Stair (E4M5) - Ethereal Crossbow',
        'Great Stair (E4M5) - Exit',
        'Great Stair (E4M5) - Firemace',
        'Great Stair (E4M5) - Firemace 2',
        'Great Stair (E4M5) - Firemace 3',
        'Great Stair (E4M5) - Firemace 4',
        'Great Stair (E4M5) - Firemace 5',
        'Great Stair (E4M5) - Gauntlets of the Necromancer',
        'Great Stair (E4M5) - Green key',
        'Great Stair (E4M5) - Hellstaff',
        'Great Stair (E4M5) - Map Scroll',
        'Great Stair (E4M5) - Morph Ovum',
        'Great Stair (E4M5) - Mystic Urn',
        'Great Stair (E4M5) - Mystic Urn 2',
        'Great Stair (E4M5) - Phoenix Rod',
        'Great Stair (E4M5) - Ring of Invincibility',
        'Great Stair (E4M5) - Shadowsphere',
        'Great Stair (E4M5) - Silver Shield',
        'Great Stair (E4M5) - Tome of Power',
        'Great Stair (E4M5) - Tome of Power 2',
        'Great Stair (E4M5) - Tome of Power 3',
        'Great Stair (E4M5) - Torch',
        'Great Stair (E4M5) - Yellow key',
    },
    'Halls of the Apostate (E4M6)': {
        'Halls of the Apostate (E4M6) - Bag of Holding',
        'Halls of the Apostate (E4M6) - Bag of Holding 2',
        'Halls of the Apostate (E4M6) - Blue key',
        'Halls of the Apostate (E4M6) - Chaos Device',
        'Halls of the Apostate (E4M6) - Dragon Claw',
        'Halls of the Apostate (E4M6) - Enchanted Shield',
        'Halls of the Apostate (E4M6) - Ethereal Crossbow',
        'Halls of the Apostate (E4M6) - Exit',
        'Halls of the Apostate (E4M6) - Gauntlets of the Necromancer',
        'Halls of the Apostate (E4M6) - Green key',
        'Halls of the Apostate (E4M6) - Hellstaff',
        'Halls of the Apostate (E4M6) - Map Scroll',
        'Halls of the Apostate (E4M6) - Morph Ovum',
        'Halls of the Apostate (E4M6) - Mystic Urn',
        'Halls of the Apostate (E4M6) - Phoenix Rod',
        'Halls of the Apostate (E4M6) - Ring of Invincibility',
        'Halls of the Apostate (E4M6) - Shadowsphere',
        'Halls of the Apostate (E4M6) - Silver Shield',
        'Halls of the Apostate (E4M6) - Silver Shield 2',
        'Halls of the Apostate (E4M6) - Tome of Power',
        'Halls of the Apostate (E4M6) - Tome of Power 2',
        'Halls of the Apostate (E4M6) - Yellow key',
    },
    "Hell's Maw (E1M8)": {
        "Hell's Maw (E1M8) - Bag of Holding",
        "Hell's Maw (E1M8) - Bag of Holding 2",
        "Hell's Maw (E1M8) - Dragon Claw",
        "Hell's Maw (E1M8) - Ethereal Crossbow",
        "Hell's Maw (E1M8) - Exit",
        "Hell's Maw (E1M8) - Gauntlets of the Necromancer",
        "Hell's Maw (E1M8) - Morph Ovum",
        "Hell's Maw (E1M8) - Ring of Invincibility",
        "Hell's Maw (E1M8) - Ring of Invincibility 2",
        "Hell's Maw (E1M8) - Ring of Invincibility 3",
        "Hell's Maw (E1M8) - Shadowsphere",
        "Hell's Maw (E1M8) - Silver Shield",
        "Hell's Maw (E1M8) - Tome of Power",
        "Hell's Maw (E1M8) - Tome of Power 2",
    },
    'Hydratyr (E5M5)': {
        'Hydratyr (E5M5) - Bag of Holding',
        'Hydratyr (E5M5) - Bag of Holding 2',
        'Hydratyr (E5M5) - Blue key',
        'Hydratyr (E5M5) - Chaos Device',
        'Hydratyr (E5M5) - Dragon Claw',
        'Hydratyr (E5M5) - Enchanted Shield',
        'Hydratyr (E5M5) - Ethereal Crossbow',
        'Hydratyr (E5M5) - Exit',
        'Hydratyr (E5M5) - Firemace',
        'Hydratyr (E5M5) - Firemace 2',
        'Hydratyr (E5M5) - Firemace 3',
        'Hydratyr (E5M5) - Firemace 4',
        'Hydratyr (E5M5) - Gauntlets of the Necromancer',
        'Hydratyr (E5M5) - Green key',
        'Hydratyr (E5M5) - Hellstaff',
        'Hydratyr (E5M5) - Map Scroll',
        'Hydratyr (E5M5) - Morph Ovum',
        'Hydratyr (E5M5) - Mystic Urn',
        'Hydratyr (E5M5) - Phoenix Rod',
        'Hydratyr (E5M5) - Ring of Invincibility',
        'Hydratyr (E5M5) - Shadowsphere',
        'Hydratyr (E5M5) - Silver Shield',
        'Hydratyr (E5M5) - Silver Shield 2',
        'Hydratyr (E5M5) - Tome of Power',
        'Hydratyr (E5M5) - Tome of Power 2',
        'Hydratyr (E5M5) - Tome of Power 3',
        'Hydratyr (E5M5) - Torch',
        'Hydratyr (E5M5) - Yellow key',
    },
    'Mausoleum (E4M9)': {
        'Mausoleum (E4M9) - Bag of Holding',
        'Mausoleum (E4M9) - Bag of Holding 2',
        'Mausoleum (E4M9) - Bag of Holding 3',
        'Mausoleum (E4M9) - Bag of Holding 4',
        'Mausoleum (E4M9) - Chaos Device',
        'Mausoleum (E4M9) - Dragon Claw',
        'Mausoleum (E4M9) - Enchanted Shield',
        'Mausoleum (E4M9) - Ethereal Crossbow',
        'Mausoleum (E4M9) - Exit',
        'Mausoleum (E4M9) - Firemace',
        'Mausoleum (E4M9) - Firemace 2',
        'Mausoleum (E4M9) - Firemace 3',
        'Mausoleum (E4M9) - Firemace 4',
        'Mausoleum (E4M9) - Gauntlets of the Necromancer',
        'Mausoleum (E4M9) - Hellstaff',
        'Mausoleum (E4M9) - Map Scroll',
        'Mausoleum (E4M9) - Morph Ovum',
        'Mausoleum (E4M9) - Mystic Urn',
        'Mausoleum (E4M9) - Phoenix Rod',
        'Mausoleum (E4M9) - Ring of Invincibility',
        'Mausoleum (E4M9) - Shadowsphere',
        'Mausoleum (E4M9) - Silver Shield',
        'Mausoleum (E4M9) - Silver Shield 2',
        'Mausoleum (E4M9) - Tome of Power',
        'Mausoleum (E4M9) - Tome of Power 2',
        'Mausoleum (E4M9) - Tome of Power 3',
        'Mausoleum (E4M9) - Torch',
        'Mausoleum (E4M9) - Torch 2',
        'Mausoleum (E4M9) - Yellow key',
    },
    'Ochre Cliffs (E5M1)': {
        'Ochre Cliffs (E5M1) - Bag of Holding',
        'Ochre Cliffs (E5M1) - Bag of Holding 2',
        'Ochre Cliffs (E5M1) - Blue key',
        'Ochre Cliffs (E5M1) - Chaos Device',
        'Ochre Cliffs (E5M1) - Dragon Claw',
        'Ochre Cliffs (E5M1) - Enchanted Shield',
        'Ochre Cliffs (E5M1) - Ethereal Crossbow',
        'Ochre Cliffs (E5M1) - Exit',
        'Ochre Cliffs (E5M1) - Firemace',
        'Ochre Cliffs (E5M1) - Firemace 2',
        'Ochre Cliffs (E5M1) - Firemace 3',
        'Ochre Cliffs (E5M1) - Firemace 4',
        'Ochre Cliffs (E5M1) - Gauntlets of the Necromancer',
        'Ochre Cliffs (E5M1) - Green key',
        'Ochre Cliffs (E5M1) - Hellstaff',
        'Ochre Cliffs (E5M1) - Map Scroll',
        'Ochre Cliffs (E5M1) - Morph Ovum',
        'Ochre Cliffs (E5M1) - Mystic Urn',
        'Ochre Cliffs (E5M1) - Phoenix Rod',
        'Ochre Cliffs (E5M1) - Ring of Invincibility',
        'Ochre Cliffs (E5M1) - Shadowsphere',
        'Ochre Cliffs (E5M1) - Silver Shield',
        'Ochre Cliffs (E5M1) - Tome of Power',
        'Ochre Cliffs (E5M1) - Tome of Power 2',
        'Ochre Cliffs (E5M1) - Tome of Power 3',
        'Ochre Cliffs (E5M1) - Torch',
        'Ochre Cliffs (E5M1) - Yellow key',
    },
    'Quay (E5M3)': {
        'Quay (E5M3) - Bag of Holding',
        'Quay (E5M3) - Bag of Holding 2',
        'Quay (E5M3) - Blue key',
        'Quay (E5M3) - Chaos Device',
        'Quay (E5M3) - Dragon Claw',
        'Quay (E5M3) - Enchanted Shield',
        'Quay (E5M3) - Ethereal Crossbow',
        'Quay (E5M3) - Exit',
        'Quay (E5M3) - Firemace',
        'Quay (E5M3) - Firemace 2',
        'Quay (E5M3) - Firemace 3',
        'Quay (E5M3) - Firemace 4',
        'Quay (E5M3) - Firemace 5',
        'Quay (E5M3) - Firemace 6',
        'Quay (E5M3) - Gauntlets of the Necromancer',
        'Quay (E5M3) - Green key',
        'Quay (E5M3) - Hellstaff',
        'Quay (E5M3) - Map Scroll',
        'Quay (E5M3) - Morph Ovum',
        'Quay (E5M3) - Mystic Urn',
        'Quay (E5M3) - Phoenix Rod',
        'Quay (E5M3) - Ring of Invincibility',
        'Quay (E5M3) - Shadowsphere',
        'Quay (E5M3) - Silver Shield',
        'Quay (E5M3) - Silver Shield 2',
        'Quay (E5M3) - Tome of Power',
        'Quay (E5M3) - Tome of Power 2',
        'Quay (E5M3) - Tome of Power 3',
        'Quay (E5M3) - Torch',
        'Quay (E5M3) - Yellow key',
    },
    'Ramparts of Perdition (E4M7)': {
        'Ramparts of Perdition (E4M7) - Bag of Holding',
        'Ramparts of Perdition (E4M7) - Bag of Holding 2',
        'Ramparts of Perdition (E4M7) - Blue key',
        'Ramparts of Perdition (E4M7) - Chaos Device',
        'Ramparts of Perdition (E4M7) - Dragon Claw',
        'Ramparts of Perdition (E4M7) - Dragon Claw 2',
        'Ramparts of Perdition (E4M7) - Enchanted Shield',
        'Ramparts of Perdition (E4M7) - Ethereal Crossbow',
        'Ramparts of Perdition (E4M7) - Ethereal Crossbow 2',
        'Ramparts of Perdition (E4M7) - Exit',
        'Ramparts of Perdition (E4M7) - Firemace',
        'Ramparts of Perdition (E4M7) - Firemace 2',
        'Ramparts of Perdition (E4M7) - Firemace 3',
        'Ramparts of Perdition (E4M7) - Firemace 4',
        'Ramparts of Perdition (E4M7) - Firemace 5',
        'Ramparts of Perdition (E4M7) - Firemace 6',
        'Ramparts of Perdition (E4M7) - Gauntlets of the Necromancer',
        'Ramparts of Perdition (E4M7) - Green key',
        'Ramparts of Perdition (E4M7) - Hellstaff',
        'Ramparts of Perdition (E4M7) - Hellstaff 2',
        'Ramparts of Perdition (E4M7) - Map Scroll',
        'Ramparts of Perdition (E4M7) - Morph Ovum',
        'Ramparts of Perdition (E4M7) - Mystic Urn',
        'Ramparts of Perdition (E4M7) - Mystic Urn 2',
        'Ramparts of Perdition (E4M7) - Phoenix Rod',
        'Ramparts of Perdition (E4M7) - Phoenix Rod 2',
        'Ramparts of Perdition (E4M7) - Ring of Invincibility',
        'Ramparts of Perdition (E4M7) - Shadowsphere',
        'Ramparts of Perdition (E4M7) - Silver Shield',
        'Ramparts of Perdition (E4M7) - Silver Shield 2',
        'Ramparts of Perdition (E4M7) - Tome of Power',
        'Ramparts of Perdition (E4M7) - Tome of Power 2',
        'Ramparts of Perdition (E4M7) - Tome of Power 3',
        'Ramparts of Perdition (E4M7) - Torch',
        'Ramparts of Perdition (E4M7) - Torch 2',
        'Ramparts of Perdition (E4M7) - Yellow key',
    },
    'Rapids (E5M2)': {
        'Rapids (E5M2) - Bag of Holding',
        'Rapids (E5M2) - Bag of Holding 2',
        'Rapids (E5M2) - Bag of Holding 3',
        'Rapids (E5M2) - Chaos Device',
        'Rapids (E5M2) - Dragon Claw',
        'Rapids (E5M2) - Enchanted Shield',
        'Rapids (E5M2) - Enchanted Shield 2',
        'Rapids (E5M2) - Ethereal Crossbow',
        'Rapids (E5M2) - Exit',
        'Rapids (E5M2) - Firemace',
        'Rapids (E5M2) - Firemace 2',
        'Rapids (E5M2) - Firemace 3',
        'Rapids (E5M2) - Firemace 4',
        'Rapids (E5M2) - Firemace 5',
        'Rapids (E5M2) - Gauntlets of the Necromancer',
        'Rapids (E5M2) - Green key',
        'Rapids (E5M2) - Hellstaff',
        'Rapids (E5M2) - Hellstaff 2',
        'Rapids (E5M2) - Map Scroll',
        'Rapids (E5M2) - Morph Ovum',
        'Rapids (E5M2) - Mystic Urn',
        'Rapids (E5M2) - Phoenix Rod',
        'Rapids (E5M2) - Phoenix Rod 2',
        'Rapids (E5M2) - Ring of Invincibility',
        'Rapids (E5M2) - Shadowsphere',
        'Rapids (E5M2) - Silver Shield',
        'Rapids (E5M2) - Tome of Power',
        'Rapids (E5M2) - Tome of Power 2',
        'Rapids (E5M2) - Torch',
        'Rapids (E5M2) - Yellow key',
    },
    'Sepulcher (E4M4)': {
        'Sepulcher (E4M4) - Bag of Holding',
        'Sepulcher (E4M4) - Bag of Holding 2',
        'Sepulcher (E4M4) - Chaos Device',
        'Sepulcher (E4M4) - Dragon Claw',
        'Sepulcher (E4M4) - Dragon Claw 2',
        'Sepulcher (E4M4) - Enchanted Shield',
        'Sepulcher (E4M4) - Ethereal Crossbow',
        'Sepulcher (E4M4) - Ethereal Crossbow 2',
        'Sepulcher (E4M4) - Exit',
        'Sepulcher (E4M4) - Firemace',
        'Sepulcher (E4M4) - Firemace 2',
        'Sepulcher (E4M4) - Firemace 3',
        'Sepulcher (E4M4) - Firemace 4',
        'Sepulcher (E4M4) - Firemace 5',
        'Sepulcher (E4M4) - Hellstaff',
        'Sepulcher (E4M4) - Morph Ovum',
        'Sepulcher (E4M4) - Mystic Urn',
        'Sepulcher (E4M4) - Phoenix Rod',
        'Sepulcher (E4M4) - Phoenix Rod 2',
        'Sepulcher (E4M4) - Ring of Invincibility',
        'Sepulcher (E4M4) - Shadowsphere',
        'Sepulcher (E4M4) - Silver Shield',
        'Sepulcher (E4M4) - Silver Shield 2',
        'Sepulcher (E4M4) - Tome of Power',
        'Sepulcher (E4M4) - Tome of Power 2',
        'Sepulcher (E4M4) - Torch',
        'Sepulcher (E4M4) - Torch 2',
    },
    'Shattered Bridge (E4M8)': {
        'Shattered Bridge (E4M8) - Bag of Holding',
        'Shattered Bridge (E4M8) - Bag of Holding 2',
        'Shattered Bridge (E4M8) - Chaos Device',
        'Shattered Bridge (E4M8) - Dragon Claw',
        'Shattered Bridge (E4M8) - Enchanted Shield',
        'Shattered Bridge (E4M8) - Ethereal Crossbow',
        'Shattered Bridge (E4M8) - Exit',
        'Shattered Bridge (E4M8) - Gauntlets of the Necromancer',
        'Shattered Bridge (E4M8) - Hellstaff',
        'Shattered Bridge (E4M8) - Morph Ovum',
        'Shattered Bridge (E4M8) - Mystic Urn',
        'Shattered Bridge (E4M8) - Phoenix Rod',
        'Shattered Bridge (E4M8) - Ring of Invincibility',
        'Shattered Bridge (E4M8) - Shadowsphere',
        'Shattered Bridge (E4M8) - Silver Shield',
        'Shattered Bridge (E4M8) - Tome of Power',
        'Shattered Bridge (E4M8) - Tome of Power 2',
        'Shattered Bridge (E4M8) - Torch',
        'Shattered Bridge (E4M8) - Yellow key',
    },
    "Skein of D'Sparil (E5M9)": {
        "Skein of D'Sparil (E5M9) - Bag of Holding",
        "Skein of D'Sparil (E5M9) - Bag of Holding 2",
        "Skein of D'Sparil (E5M9) - Blue key",
        "Skein of D'Sparil (E5M9) - Chaos Device",
        "Skein of D'Sparil (E5M9) - Dragon Claw",
        "Skein of D'Sparil (E5M9) - Enchanted Shield",
        "Skein of D'Sparil (E5M9) - Ethereal Crossbow",
        "Skein of D'Sparil (E5M9) - Exit",
        "Skein of D'Sparil (E5M9) - Gauntlets of the Necromancer",
        "Skein of D'Sparil (E5M9) - Green key",
        "Skein of D'Sparil (E5M9) - Hellstaff",
        "Skein of D'Sparil (E5M9) - Map Scroll",
        "Skein of D'Sparil (E5M9) - Morph Ovum",
        "Skein of D'Sparil (E5M9) - Mystic Urn",
        "Skein of D'Sparil (E5M9) - Phoenix Rod",
        "Skein of D'Sparil (E5M9) - Ring of Invincibility",
        "Skein of D'Sparil (E5M9) - Shadowsphere",
        "Skein of D'Sparil (E5M9) - Silver Shield",
        "Skein of D'Sparil (E5M9) - Tome of Power",
        "Skein of D'Sparil (E5M9) - Tome of Power 2",
        "Skein of D'Sparil (E5M9) - Torch",
        "Skein of D'Sparil (E5M9) - Yellow key",
    },
    'The Aquifer (E3M9)': {
        'The Aquifer (E3M9) - Bag of Holding',
        'The Aquifer (E3M9) - Blue key',
        'The Aquifer (E3M9) - Chaos Device',
        'The Aquifer (E3M9) - Dragon Claw',
        'The Aquifer (E3M9) - Enchanted Shield',
        'The Aquifer (E3M9) - Ethereal Crossbow',
        'The Aquifer (E3M9) - Exit',
        'The Aquifer (E3M9) - Firemace',
        'The Aquifer (E3M9) - Firemace 2',
        'The Aquifer (E3M9) - Firemace 3',
        'The Aquifer (E3M9) - Firemace 4',
        'The Aquifer (E3M9) - Gauntlets of the Necromancer',
        'The Aquifer (E3M9) - Green key',
        'The Aquifer (E3M9) - Hellstaff',
        'The Aquifer (E3M9) - Map Scroll',
        'The Aquifer (E3M9) - Morph Ovum',
        'The Aquifer (E3M9) - Mystic Urn',
        'The Aquifer (E3M9) - Phoenix Rod',
        'The Aquifer (E3M9) - Ring of Invincibility',
        'The Aquifer (E3M9) - Shadowsphere',
        'The Aquifer (E3M9) - Silver Shield',
        'The Aquifer (E3M9) - Silver Shield 2',
        'The Aquifer (E3M9) - Tome of Power',
        'The Aquifer (E3M9) - Tome of Power 2',
        'The Aquifer (E3M9) - Torch',
        'The Aquifer (E3M9) - Yellow key',
    },
    'The Azure Fortress (E3M4)': {
        'The Azure Fortress (E3M4) - Bag of Holding',
        'The Azure Fortress (E3M4) - Bag of Holding 2',
        'The Azure Fortress (E3M4) - Chaos Device',
        'The Azure Fortress (E3M4) - Dragon Claw',
        'The Azure Fortress (E3M4) - Enchanted Shield',
        'The Azure Fortress (E3M4) - Enchanted Shield 2',
        'The Azure Fortress (E3M4) - Ethereal Crossbow',
        'The Azure Fortress (E3M4) - Exit',
        'The Azure Fortress (E3M4) - Gauntlets of the Necromancer',
        'The Azure Fortress (E3M4) - Green key',
        'The Azure Fortress (E3M4) - Hellstaff',
        'The Azure Fortress (E3M4) - Map Scroll',
        'The Azure Fortress (E3M4) - Morph Ovum',
        'The Azure Fortress (E3M4) - Morph Ovum 2',
        'The Azure Fortress (E3M4) - Mystic Urn',
        'The Azure Fortress (E3M4) - Mystic Urn 2',
        'The Azure Fortress (E3M4) - Phoenix Rod',
        'The Azure Fortress (E3M4) - Ring of Invincibility',
        'The Azure Fortress (E3M4) - Shadowsphere',
        'The Azure Fortress (E3M4) - Silver Shield',
        'The Azure Fortress (E3M4) - Silver Shield 2',
        'The Azure Fortress (E3M4) - Tome of Power',
        'The Azure Fortress (E3M4) - Tome of Power 2',
        'The Azure Fortress (E3M4) - Tome of Power 3',
        'The Azure Fortress (E3M4) - Torch',
        'The Azure Fortress (E3M4) - Torch 2',
        'The Azure Fortress (E3M4) - Torch 3',
        'The Azure Fortress (E3M4) - Yellow key',
    },
    'The Catacombs (E2M5)': {
        'The Catacombs (E2M5) - Bag of Holding',
        'The Catacombs (E2M5) - Blue key',
        'The Catacombs (E2M5) - Chaos Device',
        'The Catacombs (E2M5) - Dragon Claw',
        'The Catacombs (E2M5) - Enchanted Shield',
        'The Catacombs (E2M5) - Ethereal Crossbow',
        'The Catacombs (E2M5) - Exit',
        'The Catacombs (E2M5) - Gauntlets of the Necromancer',
        'The Catacombs (E2M5) - Green key',
        'The Catacombs (E2M5) - Hellstaff',
        'The Catacombs (E2M5) - Map Scroll',
        'The Catacombs (E2M5) - Morph Ovum',
        'The Catacombs (E2M5) - Mystic Urn',
        'The Catacombs (E2M5) - Phoenix Rod',
        'The Catacombs (E2M5) - Ring of Invincibility',
        'The Catacombs (E2M5) - Shadowsphere',
        'The Catacombs (E2M5) - Silver Shield',
        'The Catacombs (E2M5) - Tome of Power',
        'The Catacombs (E2M5) - Tome of Power 2',
        'The Catacombs (E2M5) - Tome of Power 3',
        'The Catacombs (E2M5) - Torch',
        'The Catacombs (E2M5) - Yellow key',
    },
    'The Cathedral (E1M6)': {
        'The Cathedral (E1M6) - Bag of Holding',
        'The Cathedral (E1M6) - Bag of Holding 2',
        'The Cathedral (E1M6) - Bag of Holding 3',
        'The Cathedral (E1M6) - Dragon Claw',
        'The Cathedral (E1M6) - Ethereal Crossbow',
        'The Cathedral (E1M6) - Exit',
        'The Cathedral (E1M6) - Gauntlets of the Necromancer',
        'The Cathedral (E1M6) - Green key',
        'The Cathedral (E1M6) - Map Scroll',
        'The Cathedral (E1M6) - Morph Ovum',
        'The Cathedral (E1M6) - Ring of Invincibility',
        'The Cathedral (E1M6) - Ring of Invincibility 2',
        'The Cathedral (E1M6) - Shadowsphere',
        'The Cathedral (E1M6) - Silver Shield',
        'The Cathedral (E1M6) - Silver Shield 2',
        'The Cathedral (E1M6) - Silver Shield 3',
        'The Cathedral (E1M6) - Tome of Power',
        'The Cathedral (E1M6) - Tome of Power 2',
        'The Cathedral (E1M6) - Tome of Power 3',
        'The Cathedral (E1M6) - Tome of Power 4',
        'The Cathedral (E1M6) - Torch',
        'The Cathedral (E1M6) - Yellow key',
    },
    'The Cesspool (E3M2)': {
        'The Cesspool (E3M2) - Bag of Holding',
        'The Cesspool (E3M2) - Bag of Holding 2',
        'The Cesspool (E3M2) - Blue key',
        'The Cesspool (E3M2) - Chaos Device',
        'The Cesspool (E3M2) - Dragon Claw',
        'The Cesspool (E3M2) - Enchanted Shield',
        'The Cesspool (E3M2) - Ethereal Crossbow',
        'The Cesspool (E3M2) - Exit',
        'The Cesspool (E3M2) - Firemace',
        'The Cesspool (E3M2) - Firemace 2',
        'The Cesspool (E3M2) - Firemace 3',
        'The Cesspool (E3M2) - Firemace 4',
        'The Cesspool (E3M2) - Firemace 5',
        'The Cesspool (E3M2) - Gauntlets of the Necromancer',
        'The Cesspool (E3M2) - Green key',
        'The Cesspool (E3M2) - Hellstaff',
        'The Cesspool (E3M2) - Map Scroll',
        'The Cesspool (E3M2) - Morph Ovum',
        'The Cesspool (E3M2) - Morph Ovum 2',
        'The Cesspool (E3M2) - Mystic Urn',
        'The Cesspool (E3M2) - Phoenix Rod',
        'The Cesspool (E3M2) - Ring of Invincibility',
        'The Cesspool (E3M2) - Shadowsphere',
        'The Cesspool (E3M2) - Silver Shield',
        'The Cesspool (E3M2) - Silver Shield 2',
        'The Cesspool (E3M2) - Tome of Power',
        'The Cesspool (E3M2) - Tome of Power 2',
        'The Cesspool (E3M2) - Tome of Power 3',
        'The Cesspool (E3M2) - Torch',
        'The Cesspool (E3M2) - Yellow key',
    },
    'The Chasm (E3M7)': {
        'The Chasm (E3M7) - Bag of Holding',
        'The Chasm (E3M7) - Bag of Holding 2',
        'The Chasm (E3M7) - Blue key',
        'The Chasm (E3M7) - Chaos Device',
        'The Chasm (E3M7) - Dragon Claw',
        'The Chasm (E3M7) - Enchanted Shield',
        'The Chasm (E3M7) - Ethereal Crossbow',
        'The Chasm (E3M7) - Exit',
        'The Chasm (E3M7) - Gauntlets of the Necromancer',
        'The Chasm (E3M7) - Green key',
        'The Chasm (E3M7) - Hellstaff',
        'The Chasm (E3M7) - Map Scroll',
        'The Chasm (E3M7) - Morph Ovum',
        'The Chasm (E3M7) - Mystic Urn',
        'The Chasm (E3M7) - Phoenix Rod',
        'The Chasm (E3M7) - Ring of Invincibility',
        'The Chasm (E3M7) - Shadowsphere',
        'The Chasm (E3M7) - Shadowsphere 2',
        'The Chasm (E3M7) - Silver Shield',
        'The Chasm (E3M7) - Tome of Power',
        'The Chasm (E3M7) - Tome of Power 2',
        'The Chasm (E3M7) - Tome of Power 3',
        'The Chasm (E3M7) - Torch',
        'The Chasm (E3M7) - Torch 2',
        'The Chasm (E3M7) - Yellow key',
    },
    'The Citadel (E1M5)': {
        'The Citadel (E1M5) - Bag of Holding',
        'The Citadel (E1M5) - Blue key',
        'The Citadel (E1M5) - Dragon Claw',
        'The Citadel (E1M5) - Ethereal Crossbow',
        'The Citadel (E1M5) - Exit',
        'The Citadel (E1M5) - Gauntlets of the Necromancer',
        'The Citadel (E1M5) - Green key',
        'The Citadel (E1M5) - Map Scroll',
        'The Citadel (E1M5) - Morph Ovum',
        'The Citadel (E1M5) - Ring of Invincibility',
        'The Citadel (E1M5) - Shadowsphere',
        'The Citadel (E1M5) - Silver Shield',
        'The Citadel (E1M5) - Silver Shield 2',
        'The Citadel (E1M5) - Tome of Power',
        'The Citadel (E1M5) - Tome of Power 2',
        'The Citadel (E1M5) - Tome of Power 3',
        'The Citadel (E1M5) - Tome of Power 4',
        'The Citadel (E1M5) - Tome of Power 5',
        'The Citadel (E1M5) - Torch',
        'The Citadel (E1M5) - Torch 2',
        'The Citadel (E1M5) - Yellow key',
    },
    'The Confluence (E3M3)': {
        'The Confluence (E3M3) - Bag of Holding',
        'The Confluence (E3M3) - Blue key',
        'The Confluence (E3M3) - Chaos Device',
        'The Confluence (E3M3) - Dragon Claw',
        'The Confluence (E3M3) - Enchanted Shield',
        'The Confluence (E3M3) - Ethereal Crossbow',
        'The Confluence (E3M3) - Exit',
        'The Confluence (E3M3) - Firemace',
        'The Confluence (E3M3) - Firemace 2',
        'The Confluence (E3M3) - Firemace 3',
        'The Confluence (E3M3) - Firemace 4',
        'The Confluence (E3M3) - Firemace 5',
        'The Confluence (E3M3) - Firemace 6',
        'The Confluence (E3M3) - Gauntlets of the Necromancer',
        'The Confluence (E3M3) - Green key',
        'The Confluence (E3M3) - Hellstaff',
        'The Confluence (E3M3) - Hellstaff 2',
        'The Confluence (E3M3) - Map Scroll',
        'The Confluence (E3M3) - Morph Ovum',
        'The Confluence (E3M3) - Mystic Urn',
        'The Confluence (E3M3) - Mystic Urn 2',
        'The Confluence (E3M3) - Phoenix Rod',
        'The Confluence (E3M3) - Ring of Invincibility',
        'The Confluence (E3M3) - Shadowsphere',
        'The Confluence (E3M3) - Silver Shield',
        'The Confluence (E3M3) - Silver Shield 2',
        'The Confluence (E3M3) - Tome of Power',
        'The Confluence (E3M3) - Tome of Power 2',
        'The Confluence (E3M3) - Tome of Power 3',
        'The Confluence (E3M3) - Tome of Power 4',
        'The Confluence (E3M3) - Tome of Power 5',
        'The Confluence (E3M3) - Torch',
        'The Confluence (E3M3) - Yellow key',
    },
    'The Crater (E2M1)': {
        'The Crater (E2M1) - Bag of Holding',
        'The Crater (E2M1) - Dragon Claw',
        'The Crater (E2M1) - Ethereal Crossbow',
        'The Crater (E2M1) - Exit',
        'The Crater (E2M1) - Green key',
        'The Crater (E2M1) - Hellstaff',
        'The Crater (E2M1) - Mystic Urn',
        'The Crater (E2M1) - Shadowsphere',
        'The Crater (E2M1) - Silver Shield',
        'The Crater (E2M1) - Tome of Power',
        'The Crater (E2M1) - Torch',
        'The Crater (E2M1) - Yellow key',
    },
    'The Crypts (E1M7)': {
        'The Crypts (E1M7) - Bag of Holding',
        'The Crypts (E1M7) - Blue key',
        'The Crypts (E1M7) - Dragon Claw',
        'The Crypts (E1M7) - Ethereal Crossbow',
        'The Crypts (E1M7) - Exit',
        'The Crypts (E1M7) - Gauntlets of the Necromancer',
        'The Crypts (E1M7) - Green key',
        'The Crypts (E1M7) - Map Scroll',
        'The Crypts (E1M7) - Morph Ovum',
        'The Crypts (E1M7) - Ring of Invincibility',
        'The Crypts (E1M7) - Shadowsphere',
        'The Crypts (E1M7) - Silver Shield',
        'The Crypts (E1M7) - Silver Shield 2',
        'The Crypts (E1M7) - Tome of Power',
        'The Crypts (E1M7) - Tome of Power 2',
        'The Crypts (E1M7) - Torch',
        'The Crypts (E1M7) - Torch 2',
        'The Crypts (E1M7) - Yellow key',
    },
    'The Docks (E1M1)': {
        'The Docks (E1M1) - Bag of Holding',
        'The Docks (E1M1) - Ethereal Crossbow',
        'The Docks (E1M1) - Exit',
        'The Docks (E1M1) - Gauntlets of the Necromancer',
        'The Docks (E1M1) - Silver Shield',
        'The Docks (E1M1) - Tome of Power',
        'The Docks (E1M1) - Yellow key',
    },
    'The Dungeons (E1M2)': {
        'The Dungeons (E1M2) - Bag of Holding',
        'The Dungeons (E1M2) - Blue key',
        'The Dungeons (E1M2) - Dragon Claw',
        'The Dungeons (E1M2) - Ethereal Crossbow',
        'The Dungeons (E1M2) - Exit',
        'The Dungeons (E1M2) - Gauntlets of the Necromancer',
        'The Dungeons (E1M2) - Green key',
        'The Dungeons (E1M2) - Map Scroll',
        'The Dungeons (E1M2) - Ring of Invincibility',
        'The Dungeons (E1M2) - Shadowsphere',
        'The Dungeons (E1M2) - Silver Shield',
        'The Dungeons (E1M2) - Silver Shield 2',
        'The Dungeons (E1M2) - Tome of Power',
        'The Dungeons (E1M2) - Tome of Power 2',
        'The Dungeons (E1M2) - Torch',
        'The Dungeons (E1M2) - Yellow key',
    },
    'The Gatehouse (E1M3)': {
        'The Gatehouse (E1M3) - Bag of Holding',
        'The Gatehouse (E1M3) - Dragon Claw',
        'The Gatehouse (E1M3) - Ethereal Crossbow',
        'The Gatehouse (E1M3) - Exit',
        'The Gatehouse (E1M3) - Gauntlets of the Necromancer',
        'The Gatehouse (E1M3) - Green key',
        'The Gatehouse (E1M3) - Morph Ovum',
        'The Gatehouse (E1M3) - Ring of Invincibility',
        'The Gatehouse (E1M3) - Shadowsphere',
        'The Gatehouse (E1M3) - Silver Shield',
        'The Gatehouse (E1M3) - Tome of Power',
        'The Gatehouse (E1M3) - Tome of Power 2',
        'The Gatehouse (E1M3) - Tome of Power 3',
        'The Gatehouse (E1M3) - Torch',
        'The Gatehouse (E1M3) - Yellow key',
    },
    'The Glacier (E2M9)': {
        'The Glacier (E2M9) - Bag of Holding',
        'The Glacier (E2M9) - Blue key',
        'The Glacier (E2M9) - Chaos Device',
        'The Glacier (E2M9) - Dragon Claw',
        'The Glacier (E2M9) - Dragon Claw 2',
        'The Glacier (E2M9) - Enchanted Shield',
        'The Glacier (E2M9) - Ethereal Crossbow',
        'The Glacier (E2M9) - Exit',
        'The Glacier (E2M9) - Firemace',
        'The Glacier (E2M9) - Firemace 2',
        'The Glacier (E2M9) - Firemace 3',
        'The Glacier (E2M9) - Firemace 4',
        'The Glacier (E2M9) - Gauntlets of the Necromancer',
        'The Glacier (E2M9) - Green key',
        'The Glacier (E2M9) - Hellstaff',
        'The Glacier (E2M9) - Map Scroll',
        'The Glacier (E2M9) - Morph Ovum',
        'The Glacier (E2M9) - Mystic Urn',
        'The Glacier (E2M9) - Mystic Urn 2',
        'The Glacier (E2M9) - Phoenix Rod',
        'The Glacier (E2M9) - Ring of Invincibility',
        'The Glacier (E2M9) - Shadowsphere',
        'The Glacier (E2M9) - Silver Shield',
        'The Glacier (E2M9) - Tome of Power',
        'The Glacier (E2M9) - Tome of Power 2',
        'The Glacier (E2M9) - Torch',
        'The Glacier (E2M9) - Torch 2',
        'The Glacier (E2M9) - Yellow key',
    },
    'The Graveyard (E1M9)': {
        'The Graveyard (E1M9) - Bag of Holding',
        'The Graveyard (E1M9) - Blue key',
        'The Graveyard (E1M9) - Dragon Claw',
        'The Graveyard (E1M9) - Dragon Claw 2',
        'The Graveyard (E1M9) - Ethereal Crossbow',
        'The Graveyard (E1M9) - Exit',
        'The Graveyard (E1M9) - Green key',
        'The Graveyard (E1M9) - Map Scroll',
        'The Graveyard (E1M9) - Morph Ovum',
        'The Graveyard (E1M9) - Ring of Invincibility',
        'The Graveyard (E1M9) - Shadowsphere',
        'The Graveyard (E1M9) - Silver Shield',
        'The Graveyard (E1M9) - Tome of Power',
        'The Graveyard (E1M9) - Tome of Power 2',
        'The Graveyard (E1M9) - Torch',
        'The Graveyard (E1M9) - Yellow key',
    },
    'The Great Hall (E2M7)': {
        'The Great Hall (E2M7) - Bag of Holding',
        'The Great Hall (E2M7) - Blue key',
        'The Great Hall (E2M7) - Chaos Device',
        'The Great Hall (E2M7) - Dragon Claw',
        'The Great Hall (E2M7) - Enchanted Shield',
        'The Great Hall (E2M7) - Ethereal Crossbow',
        'The Great Hall (E2M7) - Exit',
        'The Great Hall (E2M7) - Gauntlets of the Necromancer',
        'The Great Hall (E2M7) - Green key',
        'The Great Hall (E2M7) - Hellstaff',
        'The Great Hall (E2M7) - Map Scroll',
        'The Great Hall (E2M7) - Morph Ovum',
        'The Great Hall (E2M7) - Mystic Urn',
        'The Great Hall (E2M7) - Phoenix Rod',
        'The Great Hall (E2M7) - Ring of Invincibility',
        'The Great Hall (E2M7) - Shadowsphere',
        'The Great Hall (E2M7) - Silver Shield',
        'The Great Hall (E2M7) - Tome of Power',
        'The Great Hall (E2M7) - Tome of Power 2',
        'The Great Hall (E2M7) - Torch',
        'The Great Hall (E2M7) - Yellow key',
    },
    'The Guard Tower (E1M4)': {
        'The Guard Tower (E1M4) - Bag of Holding',
        'The Guard Tower (E1M4) - Dragon Claw',
        'The Guard Tower (E1M4) - Ethereal Crossbow',
        'The Guard Tower (E1M4) - Exit',
        'The Guard Tower (E1M4) - Gauntlets of the Necromancer',
        'The Guard Tower (E1M4) - Green key',
        'The Guard Tower (E1M4) - Map Scroll',
        'The Guard Tower (E1M4) - Morph Ovum',
        'The Guard Tower (E1M4) - Shadowsphere',
        'The Guard Tower (E1M4) - Silver Shield',
        'The Guard Tower (E1M4) - Tome of Power',
        'The Guard Tower (E1M4) - Tome of Power 2',
        'The Guard Tower (E1M4) - Tome of Power 3',
        'The Guard Tower (E1M4) - Torch',
        'The Guard Tower (E1M4) - Yellow key',
    },
    'The Halls of Fear (E3M6)': {
        'The Halls of Fear (E3M6) - Bag of Holding',
        'The Halls of Fear (E3M6) - Bag of Holding 2',
        'The Halls of Fear (E3M6) - Bag of Holding 3',
        'The Halls of Fear (E3M6) - Blue key',
        'The Halls of Fear (E3M6) - Chaos Device',
        'The Halls of Fear (E3M6) - Dragon Claw',
        'The Halls of Fear (E3M6) - Enchanted Shield',
        'The Halls of Fear (E3M6) - Ethereal Crossbow',
        'The Halls of Fear (E3M6) - Exit',
        'The Halls of Fear (E3M6) - Firemace',
        'The Halls of Fear (E3M6) - Firemace 2',
        'The Halls of Fear (E3M6) - Firemace 3',
        'The Halls of Fear (E3M6) - Firemace 4',
        'The Halls of Fear (E3M6) - Firemace 5',
        'The Halls of Fear (E3M6) - Firemace 6',
        'The Halls of Fear (E3M6) - Gauntlets of the Necromancer',
        'The Halls of Fear (E3M6) - Green key',
        'The Halls of Fear (E3M6) - Hellstaff',
        'The Halls of Fear (E3M6) - Hellstaff 2',
        'The Halls of Fear (E3M6) - Map Scroll',
        'The Halls of Fear (E3M6) - Morph Ovum',
        'The Halls of Fear (E3M6) - Mystic Urn',
        'The Halls of Fear (E3M6) - Mystic Urn 2',
        'The Halls of Fear (E3M6) - Phoenix Rod',
        'The Halls of Fear (E3M6) - Ring of Invincibility',
        'The Halls of Fear (E3M6) - Shadowsphere',
        'The Halls of Fear (E3M6) - Silver Shield',
        'The Halls of Fear (E3M6) - Tome of Power',
        'The Halls of Fear (E3M6) - Tome of Power 2',
        'The Halls of Fear (E3M6) - Tome of Power 3',
        'The Halls of Fear (E3M6) - Yellow key',
    },
    'The Ice Grotto (E2M4)': {
        'The Ice Grotto (E2M4) - Bag of Holding',
        'The Ice Grotto (E2M4) - Bag of Holding 2',
        'The Ice Grotto (E2M4) - Blue key',
        'The Ice Grotto (E2M4) - Chaos Device',
        'The Ice Grotto (E2M4) - Dragon Claw',
        'The Ice Grotto (E2M4) - Enchanted Shield',
        'The Ice Grotto (E2M4) - Ethereal Crossbow',
        'The Ice Grotto (E2M4) - Exit',
        'The Ice Grotto (E2M4) - Gauntlets of the Necromancer',
        'The Ice Grotto (E2M4) - Green key',
        'The Ice Grotto (E2M4) - Hellstaff',
        'The Ice Grotto (E2M4) - Map Scroll',
        'The Ice Grotto (E2M4) - Morph Ovum',
        'The Ice Grotto (E2M4) - Mystic Urn',
        'The Ice Grotto (E2M4) - Phoenix Rod',
        'The Ice Grotto (E2M4) - Shadowsphere',
        'The Ice Grotto (E2M4) - Shadowsphere 2',
        'The Ice Grotto (E2M4) - Silver Shield',
        'The Ice Grotto (E2M4) - Tome of Power',
        'The Ice Grotto (E2M4) - Tome of Power 2',
        'The Ice Grotto (E2M4) - Tome of Power 3',
        'The Ice Grotto (E2M4) - Torch',
        'The Ice Grotto (E2M4) - Yellow key',
    },
    'The Labyrinth (E2M6)': {
        'The Labyrinth (E2M6) - Bag of Holding',
        'The Labyrinth (E2M6) - Blue key',
        'The Labyrinth (E2M6) - Chaos Device',
        'The Labyrinth (E2M6) - Dragon Claw',
        'The Labyrinth (E2M6) - Enchanted Shield',
        'The Labyrinth (E2M6) - Ethereal Crossbow',
        'The Labyrinth (E2M6) - Exit',
        'The Labyrinth (E2M6) - Firemace',
        'The Labyrinth (E2M6) - Firemace 2',
        'The Labyrinth (E2M6) - Firemace 3',
        'The Labyrinth (E2M6) - Firemace 4',
        'The Labyrinth (E2M6) - Gauntlets of the Necromancer',
        'The Labyrinth (E2M6) - Green key',
        'The Labyrinth (E2M6) - Hellstaff',
        'The Labyrinth (E2M6) - Map Scroll',
        'The Labyrinth (E2M6) - Morph Ovum',
        'The Labyrinth (E2M6) - Mystic Urn',
        'The Labyrinth (E2M6) - Phoenix Rod',
        'The Labyrinth (E2M6) - Phoenix Rod 2',
        'The Labyrinth (E2M6) - Ring of Invincibility',
        'The Labyrinth (E2M6) - Shadowsphere',
        'The Labyrinth (E2M6) - Silver Shield',
        'The Labyrinth (E2M6) - Tome of Power',
        'The Labyrinth (E2M6) - Tome of Power 2',
        'The Labyrinth (E2M6) - Yellow key',
    },
    'The Lava Pits (E2M2)': {
        'The Lava Pits (E2M2) - Bag of Holding',
        'The Lava Pits (E2M2) - Bag of Holding 2',
        'The Lava Pits (E2M2) - Chaos Device',
        'The Lava Pits (E2M2) - Dragon Claw',
        'The Lava Pits (E2M2) - Enchanted Shield',
        'The Lava Pits (E2M2) - Ethereal Crossbow',
        'The Lava Pits (E2M2) - Exit',
        'The Lava Pits (E2M2) - Gauntlets of the Necromancer',
        'The Lava Pits (E2M2) - Green key',
        'The Lava Pits (E2M2) - Hellstaff',
        'The Lava Pits (E2M2) - Map Scroll',
        'The Lava Pits (E2M2) - Morph Ovum',
        'The Lava Pits (E2M2) - Mystic Urn',
        'The Lava Pits (E2M2) - Ring of Invincibility',
        'The Lava Pits (E2M2) - Shadowsphere',
        'The Lava Pits (E2M2) - Silver Shield',
        'The Lava Pits (E2M2) - Silver Shield 2',
        'The Lava Pits (E2M2) - Tome of Power',
        'The Lava Pits (E2M2) - Tome of Power 2',
        'The Lava Pits (E2M2) - Tome of Power 3',
        'The Lava Pits (E2M2) - Yellow key',
    },
    'The Ophidian Lair (E3M5)': {
        'The Ophidian Lair (E3M5) - Bag of Holding',
        'The Ophidian Lair (E3M5) - Chaos Device',
        'The Ophidian Lair (E3M5) - Dragon Claw',
        'The Ophidian Lair (E3M5) - Enchanted Shield',
        'The Ophidian Lair (E3M5) - Ethereal Crossbow',
        'The Ophidian Lair (E3M5) - Exit',
        'The Ophidian Lair (E3M5) - Gauntlets of the Necromancer',
        'The Ophidian Lair (E3M5) - Green key',
        'The Ophidian Lair (E3M5) - Hellstaff',
        'The Ophidian Lair (E3M5) - Map Scroll',
        'The Ophidian Lair (E3M5) - Morph Ovum',
        'The Ophidian Lair (E3M5) - Mystic Urn',
        'The Ophidian Lair (E3M5) - Mystic Urn 2',
        'The Ophidian Lair (E3M5) - Phoenix Rod',
        'The Ophidian Lair (E3M5) - Ring of Invincibility',
        'The Ophidian Lair (E3M5) - Shadowsphere',
        'The Ophidian Lair (E3M5) - Silver Shield',
        'The Ophidian Lair (E3M5) - Silver Shield 2',
        'The Ophidian Lair (E3M5) - Tome of Power',
        'The Ophidian Lair (E3M5) - Tome of Power 2',
        'The Ophidian Lair (E3M5) - Torch',
        'The Ophidian Lair (E3M5) - Yellow key',
    },
    'The Portals of Chaos (E2M8)': {
        'The Portals of Chaos (E2M8) - Bag of Holding',
        'The Portals of Chaos (E2M8) - Chaos Device',
        'The Portals of Chaos (E2M8) - Dragon Claw',
        'The Portals of Chaos (E2M8) - Enchanted Shield',
        'The Portals of Chaos (E2M8) - Ethereal Crossbow',
        'The Portals of Chaos (E2M8) - Exit',
        'The Portals of Chaos (E2M8) - Gauntlets of the Necromancer',
        'The Portals of Chaos (E2M8) - Hellstaff',
        'The Portals of Chaos (E2M8) - Morph Ovum',
        'The Portals of Chaos (E2M8) - Mystic Urn',
        'The Portals of Chaos (E2M8) - Mystic Urn 2',
        'The Portals of Chaos (E2M8) - Phoenix Rod',
        'The Portals of Chaos (E2M8) - Ring of Invincibility',
        'The Portals of Chaos (E2M8) - Shadowsphere',
        'The Portals of Chaos (E2M8) - Silver Shield',
        'The Portals of Chaos (E2M8) - Tome of Power',
    },
    'The River of Fire (E2M3)': {
        'The River of Fire (E2M3) - Bag of Holding',
        'The River of Fire (E2M3) - Blue key',
        'The River of Fire (E2M3) - Chaos Device',
        'The River of Fire (E2M3) - Dragon Claw',
        'The River of Fire (E2M3) - Enchanted Shield',
        'The River of Fire (E2M3) - Ethereal Crossbow',
        'The River of Fire (E2M3) - Exit',
        'The River of Fire (E2M3) - Firemace',
        'The River of Fire (E2M3) - Firemace 2',
        'The River of Fire (E2M3) - Firemace 3',
        'The River of Fire (E2M3) - Gauntlets of the Necromancer',
        'The River of Fire (E2M3) - Green key',
        'The River of Fire (E2M3) - Hellstaff',
        'The River of Fire (E2M3) - Morph Ovum',
        'The River of Fire (E2M3) - Mystic Urn',
        'The River of Fire (E2M3) - Phoenix Rod',
        'The River of Fire (E2M3) - Ring of Invincibility',
        'The River of Fire (E2M3) - Shadowsphere',
        'The River of Fire (E2M3) - Silver Shield',
        'The River of Fire (E2M3) - Tome of Power',
        'The River of Fire (E2M3) - Tome of Power 2',
        'The River of Fire (E2M3) - Yellow key',
    },
    'The Storehouse (E3M1)': {
        'The Storehouse (E3M1) - Bag of Holding',
        'The Storehouse (E3M1) - Chaos Device',
        'The Storehouse (E3M1) - Dragon Claw',
        'The Storehouse (E3M1) - Exit',
        'The Storehouse (E3M1) - Gauntlets of the Necromancer',
        'The Storehouse (E3M1) - Green key',
        'The Storehouse (E3M1) - Hellstaff',
        'The Storehouse (E3M1) - Map Scroll',
        'The Storehouse (E3M1) - Ring of Invincibility',
        'The Storehouse (E3M1) - Shadowsphere',
        'The Storehouse (E3M1) - Silver Shield',
        'The Storehouse (E3M1) - Tome of Power',
        'The Storehouse (E3M1) - Torch',
        'The Storehouse (E3M1) - Yellow key',
    },
}


death_logic_locations = [
    "Ramparts of Perdition (E4M7) - Ring of Invincibility",
    "Ramparts of Perdition (E4M7) - Ethereal Crossbow 2",
]
