from typing import TypedDict, List
from .Regions import Stages


class LocationDict(TypedDict):
    name: str
    stage: Stages
    game_id: str


class EventDict(TypedDict):
    name: str
    stage: str
    item: str


location_table: List[LocationDict] = [
    {'name': "Hideout: Half pipe CD",
        'stage': Stages.H,
        'game_id': "MusicTrack_CondensedMilk"},
    {'name': "Hideout: Garage tower CD",
        'stage': Stages.H,
        'game_id': "MusicTrack_MorningGlow"},
    {'name': "Hideout: Rooftop CD",
        'stage': Stages.H,
        'game_id': "MusicTrack_LightSwitch"},
    {'name': "Hideout: Under staircase graffiti",
        'stage': Stages.H,
        'game_id': "UnlockGraffiti_grafTex_M1"},
    {'name': "Hideout: Secret area graffiti",
        'stage': Stages.H,
        'game_id': "UnlockGraffiti_grafTex_L1"},
    {'name': "Hideout: Rear studio graffiti",
        'stage': Stages.H,
        'game_id': "UnlockGraffiti_grafTex_XL1"},
    {'name': "Hideout: Corner ledge graffiti",
        'stage': Stages.H,
        'game_id': "UnlockGraffiti_grafTex_M2"},
    {'name': "Hideout: Upper platform skateboard",
        'stage': Stages.H,
        'game_id': "SkateboardDeck3"},
    {'name': "Hideout: BMX garage skateboard",
        'stage': Stages.H,
        'game_id': "SkateboardDeck2"},
    {'name': "Hideout: Unlock phone app",
        'stage': Stages.H,
        'game_id': "camera"},
    {'name': "Hideout: Vinyl joins the crew",
        'stage': Stages.H,
        'game_id': "girl1"},
    {'name': "Hideout: Solace joins the crew",
        'stage': Stages.H,
        'game_id': "dummy"},
    
    {'name': "Versum Hill: Main street Robo Post graffiti",
        'stage': Stages.VH1,
        'game_id': "UnlockGraffiti_grafTex_L4"},
    {'name': "Versum Hill: Behind glass graffiti",
        'stage': Stages.VH1,
        'game_id': "UnlockGraffiti_grafTex_L3"},
    {'name': "Versum Hill: Office room graffiti",
        'stage': Stages.VH1,
        'game_id': "UnlockGraffiti_grafTex_M4"},
    {'name': "Versum Hill: Under bridge graffiti",
        'stage': Stages.VH2,
        'game_id': "UnlockGraffiti_grafTex_XL4"},
    {'name': "Versum Hill: Train rail ledge skateboard",
        'stage': Stages.VH2,
        'game_id': "SkateboardDeck6"},
    {'name': "Versum Hill: Train station CD",
        'stage': Stages.VH2,
        'game_id': "MusicTrack_PreciousThing"},
    {'name': "Versum Hill: Billboard platform outfit",
        'stage': Stages.VH2,
        'game_id': "MetalheadOutfit3"},
    {'name': "Versum Hill: Hilltop Robo Post CD",
        'stage': Stages.VH2,
        'game_id': "MusicTrack_BounceUponATime"},
    {'name': "Versum Hill: Hill secret skateboard",
        'stage': Stages.VH2,
        'game_id': "SkateboardDeck7"},
    {'name': "Versum Hill: Rooftop CD",
        'stage': Stages.VH2,
        'game_id': "MusicTrack_NextToMe"},
    {'name': "Versum Hill: Wallrunning challenge reward",
        'stage': Stages.VH2,
        'game_id': "UnlockGraffiti_grafTex_M3"},
    {'name': "Versum Hill: Manual challenge reward",
        'stage': Stages.VH2,
        'game_id': "UnlockGraffiti_grafTex_L2"},
    {'name': "Versum Hill: Corner challenge reward",
        'stage': Stages.VH2,
        'game_id': "UnlockGraffiti_grafTex_M13"},
    {'name': "Versum Hill: Side street alley outfit",
        'stage': Stages.VH3,
        'game_id': "MetalheadOutfit4"},
    {'name': "Versum Hill: Side street secret skateboard",
        'stage': Stages.VH3,
        'game_id': "SkateboardDeck9"},
    {'name': "Versum Hill: Basketball court alley skateboard",
        'stage': Stages.VH4,
        'game_id': "SkateboardDeck5"},
    {'name': "Versum Hill: Basketball court Robo Post CD",
        'stage': Stages.VH4,
        'game_id': "MusicTrack_Operator"},
    {'name': "Versum Hill: Underground mall billboard graffiti",
        'stage': Stages.VHO,
        'game_id': "UnlockGraffiti_grafTex_XL3"},
    {'name': "Versum Hill: Underground mall vending machine skateboard",
        'stage': Stages.VHO,
        'game_id': "SkateboardDeck8"},
    {'name': "Versum Hill: BMX gate outfit",
        'stage': Stages.VH1,
        'game_id': "AngelOutfit3"},
    {'name': "Versum Hill: Glass floor skates",
        'stage': Stages.VH2,
        'game_id': "InlineSkates4"},
    {'name': "Versum Hill: Basketball court shortcut CD",
        'stage': Stages.VH4,
        'game_id': "MusicTrack_GetEnuf"},
    {'name': "Versum Hill: Rave joins the crew",
        'stage': Stages.VHO,
        'game_id': "angel"},
    {'name': "Versum Hill: Frank joins the crew",
        'stage': Stages.VH2,
        'game_id': "frank"},
    {'name': "Versum Hill: Rietveld joins the crew",
        'stage': Stages.VH4,
        'game_id': "jetpackBossPlayer"},
    {'name': "Versum Hill: Big Polo",
        'stage': Stages.VH1,
        'game_id': "PoloBuilding/Mascot_Polo_sit_big"},
    {'name': "Versum Hill: Trash Polo",
        'stage': Stages.VH1,
        'game_id': "TrashCluster (1)/Mascot_Polo_street"},
    {'name': "Versum Hill: Fruit stand Polo",
        'stage': Stages.VHO,
        'game_id': "SecretRoom/Mascot_Polo_street"},

    {'name': "Millennium Square: Center ramp graffiti",
        'stage': Stages.MS,
        'game_id': "UnlockGraffiti_grafTex_L6"},
    {'name': "Millennium Square: Rooftop staircase graffiti",
        'stage': Stages.MS,
        'game_id': "UnlockGraffiti_grafTex_M8"},
    {'name': "Millennium Square: Toilet graffiti",
        'stage': Stages.MS,
        'game_id': "UnlockGraffiti_grafTex_XL6"},
    {'name': "Millennium Square: Trash graffiti",
        'stage': Stages.MS,
        'game_id': "UnlockGraffiti_grafTex_M5"},
    {'name': "Millennium Square: Center tower graffiti",
        'stage': Stages.MS,
        'game_id': "UnlockGraffiti_grafTex_M6"},
    {'name': "Millennium Square: Rooftop billboard graffiti",
        'stage': Stages.MS,
        'game_id': "UnlockGraffiti_grafTex_XL7"},
    {'name': "Millennium Square: Center Robo Post CD",
        'stage': Stages.MS,
        'game_id': "MusicTrack_FeelTheFunk"},
    {'name': "Millennium Square: Parking garage Robo Post CD",
        'stage': Stages.MS,
        'game_id': "MusicTrack_Plume"},
    {'name': "Millennium Square: Mall ledge outfit",
        'stage': Stages.MS,
        'game_id': "BlockGuyOutfit3"},
    {'name': "Millennium Square: Alley rooftop outfit",
        'stage': Stages.MS,
        'game_id': "BlockGuyOutfit4"},
    {'name': "Millennium Square: Alley staircase skateboard",
        'stage': Stages.MS,
        'game_id': "SkateboardDeck4"},
    {'name': "Millennium Square: Secret painting skates",
        'stage': Stages.MS,
        'game_id': "InlineSkates2"},
    {'name': "Millennium Square: Vending machine skates",
        'stage': Stages.MS,
        'game_id': "InlineSkates3"},
    {'name': "Millennium Square: Walkway roof skates",
        'stage': Stages.MS,
        'game_id': "InlineSkates5"},
    {'name': "Millennium Square: Alley ledge skates",
        'stage': Stages.MS,
        'game_id': "InlineSkates6"},
    {'name': "Millennium Square: DJ Cyber joins the crew",
        'stage': Stages.MS,
        'game_id': "dj"},
    {'name': "Millennium Square: Half pipe Polo",
        'stage': Stages.MS,
        'game_id': "propsSecretArea/Mascot_Polo_street"},

    {'name': "Brink Terminal: Upside grind challenge reward",
        'stage': Stages.BT1,
        'game_id': "UnlockGraffiti_grafTex_M10"},
    {'name': "Brink Terminal: Manual challenge reward",
        'stage': Stages.BT1,
        'game_id': "UnlockGraffiti_grafTex_L8"},
    {'name': "Brink Terminal: Score challenge reward",
        'stage': Stages.BT1,
        'game_id': "UnlockGraffiti_grafTex_M12"},
    {'name': "Brink Terminal: Under square ledge graffiti",
        'stage': Stages.BT1,
        'game_id': "UnlockGraffiti_grafTex_L9"},
    {'name': "Brink Terminal: Bus graffiti",
        'stage': Stages.BT1,
        'game_id': "UnlockGraffiti_grafTex_XL9"},
    {'name': "Brink Terminal: Under square Robo Post graffiti",
        'stage': Stages.BT1,
        'game_id': "UnlockGraffiti_grafTex_M9"},
    {'name': "Brink Terminal: BMX gate graffiti",
        'stage': Stages.BT1,
        'game_id': "UnlockGraffiti_grafTex_L7"},
    {'name': "Brink Terminal: Square tower CD",
        'stage': Stages.BT1,
        'game_id': "MusicTrack_Chapter1Mixtape"},
    {'name': "Brink Terminal: Trash CD",
        'stage': Stages.BT1,
        'game_id': "MusicTrack_HairDunNailsDun"},
    {'name': "Brink Terminal: Shop roof outfit",
        'stage': Stages.BT1,
        'game_id': "AngelOutfit4"},
    {'name': "Brink Terminal: Underground glass skates",
        'stage': Stages.BTO1,
        'game_id': "InlineSkates8"},
    {'name': "Brink Terminal: Glass roof skates",
        'stage': Stages.BT1,
        'game_id': "InlineSkates10"},
    {'name': "Brink Terminal: Mesh's skateboard",
        'stage': Stages.BTO2,
        'game_id': "SkateboardDeck10"}, # double check this one
    {'name': "Brink Terminal: Underground ramp skates",
        'stage': Stages.BTO1,
        'game_id': "InlineSkates7"},
    {'name': "Brink Terminal: Rooftop halfpipe graffiti",
        'stage': Stages.BT3,
        'game_id': "UnlockGraffiti_grafTex_M11"},
    {'name': "Brink Terminal: Wire grind CD",
        'stage': Stages.BT2,
        'game_id': "MusicTrack_Watchyaback"},
    {'name': "Brink Terminal: Rooftop glass CD",
        'stage': Stages.BT3,
        'game_id': "MusicTrack_Refuse"},
    {'name': "Brink Terminal: Tower core outfit",
        'stage': Stages.BT3,
        'game_id': "SpacegirlOutfit4"},
    {'name': "Brink Terminal: High rooftop outfit",
        'stage': Stages.BT3,
        'game_id': "WideKidOutfit3"},
    {'name': "Brink Terminal: Ocean platform CD",
        'stage': Stages.BTO2,
        'game_id': "MusicTrack_ScrapedOnTheWayOut"},
    {'name': "Brink Terminal: End of dock CD",
        'stage': Stages.BTO2,
        'game_id': "MusicTrack_Hwbouths"},
    {'name': "Brink Terminal: Dock Robo Post outfit",
        'stage': Stages.BTO2,
        'game_id': "WideKidOutfit4"},
    {'name': "Brink Terminal: Control room skates",
        'stage': Stages.BTO2,
        'game_id': "InlineSkates9"},
    {'name': "Brink Terminal: Mesh joins the crew",
        'stage': Stages.BTO2,
        'game_id': "wideKid"},
    {'name': "Brink Terminal: Eclipse joins the crew",
        'stage': Stages.BT1,
        'game_id': "medusa"},
    {'name': "Brink Terminal: Behind glass Polo",
        'stage': Stages.BT1,
        'game_id': "KingFood (Bear)/Mascot_Polo_street"},

    {'name': "Millennium Mall: Warehouse pallet graffiti",
        'stage': Stages.MM1,
        'game_id': "UnlockGraffiti_grafTex_L5"},
    {'name': "Millennium Mall: Wall alcove graffiti",
        'stage': Stages.MM1,
        'game_id': "UnlockGraffiti_grafTex_XL10"},
    {'name': "Millennium Mall: Maintenance shaft CD",
        'stage': Stages.MM1,
        'game_id': "MusicTrack_MissingBreak"},
    {'name': "Millennium Mall: Glass cylinder CD",
        'stage': Stages.MM1,
        'game_id': "MusicTrack_DAPEOPLE"},
    {'name': "Millennium Mall: Lower Robo Post outfit",
        'stage': Stages.MM1,
        'game_id': "SpacegirlOutfit3"},
    {'name': "Millennium Mall: Atrium vending machine graffiti",
        'stage': Stages.MM2,
        'game_id': "UnlockGraffiti_grafTex_M15"},
    {'name': "Millennium Mall: Trick challenge reward",
        'stage': Stages.MM2,
        'game_id': "UnlockGraffiti_grafTex_XL8"},
    {'name': "Millennium Mall: Slide challenge reward",
        'stage': Stages.MM2,
        'game_id': "UnlockGraffiti_grafTex_L10"},
    {'name': "Millennium Mall: Fish challenge reward",
        'stage': Stages.MM2,
        'game_id': "UnlockGraffiti_grafTex_L12"},
    {'name': "Millennium Mall: Score challenge reward",
        'stage': Stages.MM2,
        'game_id': "UnlockGraffiti_grafTex_XL11"},
    {'name': "Millennium Mall: Atrium top floor Robo Post CD",
        'stage': Stages.MM2,
        'game_id': "MusicTrack_TwoDaysOff"},
    {'name': "Millennium Mall: Atrium top floor floating CD",
        'stage': Stages.MM2,
        'game_id': "MusicTrack_Spectres"},
    {'name': "Millennium Mall: Atrium top floor BMX",
        'stage': Stages.MM2,
        'game_id': "BMXBike2"},
    {'name': "Millennium Mall: Theater entrance BMX",
        'stage': Stages.MM2,
        'game_id': "BMXBike3"},
    {'name': "Millennium Mall: Atrium BMX gate BMX",
        'stage': Stages.MM2,
        'game_id': "BMXBike5"},
    {'name': "Millennium Mall: Upside down rail outfit",
        'stage': Stages.MM2,
        'game_id': "BunGirlOutfit3"},
    {'name': "Millennium Mall: Theater stage corner graffiti",
        'stage': Stages.MM3,
        'game_id': "UnlockGraffiti_grafTex_L15"},
    {'name': "Millennium Mall: Theater hanging billboards graffiti",
        'stage': Stages.MM3,
        'game_id': "UnlockGraffiti_grafTex_XL15"},
    {'name': "Millennium Mall: Theater garage graffiti",
        'stage': Stages.MM3,
        'game_id': "UnlockGraffiti_grafTex_M16"},
    {'name': "Millennium Mall: Theater maintenance CD",
        'stage': Stages.MM3,
        'game_id': "MusicTrack_WannaKno"},
    {'name': "Millennium Mall: Race track Robo Post CD",
        'stage': Stages.MMO2,
        'game_id': "MusicTrack_StateOfMind"},
    {'name': "Millennium Mall: Hanging lights CD",
        'stage': Stages.MMO1,
        'game_id': "MusicTrack_Chapter2Mixtape"},
    {'name': "Millennium Mall: Shine joins the crew",
        'stage': Stages.MM3,
        'game_id': "bunGirl"},
    {'name': "Millennium Mall: DOT.EXE joins the crew",
        'stage': Stages.MM2,
        'game_id': "eightBall"},

    {'name': "Pyramid Island: Lower rooftop graffiti",
        'stage': Stages.PI1,
        'game_id': "UnlockGraffiti_grafTex_L18"},
    {'name': "Pyramid Island: Polo graffiti",
        'stage': Stages.PI1,
        'game_id': "UnlockGraffiti_grafTex_L16"},
    {'name': "Pyramid Island: Above entrance graffiti",
        'stage': Stages.PI1,
        'game_id': "UnlockGraffiti_grafTex_XL16"},
    {'name': "Pyramid Island: BMX gate BMX",
        'stage': Stages.PI1,
        'game_id': "BMXBike6"},
    {'name': "Pyramid Island: Quarter pipe rooftop graffiti",
        'stage': Stages.PI2,
        'game_id': "UnlockGraffiti_grafTex_M17"},
    {'name': "Pyramid Island: Supply port Robo Post CD",
        'stage': Stages.PI2,
        'game_id': "MusicTrack_Trinitron"},
    {'name': "Pyramid Island: Above gate ledge CD",
        'stage': Stages.PI2,
        'game_id': "MusicTrack_Agua"},
    {'name': "Pyramid Island: Smoke hole BMX",
        'stage': Stages.PI2,
        'game_id': "BMXBike8"},
    {'name': "Pyramid Island: Above gate rail outfit",
        'stage': Stages.PI2,
        'game_id': "VinylOutfit3"},
    {'name': "Pyramid Island: Rail loop outfit",
        'stage': Stages.PI2,
        'game_id': "BunGirlOutfit4"},
    {'name': "Pyramid Island: Score challenge reward",
        'stage': Stages.PI2,
        'game_id': "UnlockGraffiti_grafTex_XL2"},
    {'name': "Pyramid Island: Score challenge 2 reward",
        'stage': Stages.PI2,
        'game_id': "UnlockGraffiti_grafTex_L13"},
    {'name': "Pyramid Island: Quarter pipe challenge reward",
        'stage': Stages.PI2,
        'game_id': "UnlockGraffiti_grafTex_XL12"},
    {'name': "Pyramid Island: Wind turbines CD",
        'stage': Stages.PI3,
        'game_id': "MusicTrack_YouCanSayHi"},
    {'name': "Pyramid Island: Shortcut glass CD",
        'stage': Stages.PI3,
        'game_id': "MusicTrack_Chromebies"},
    {'name': "Pyramid Island: Turret jump CD",
        'stage': Stages.PI3,
        'game_id': "MusicTrack_ChuckinUp"},
    {'name': "Pyramid Island: Helipad BMX",
        'stage': Stages.PI3,
        'game_id': "BMXBike7"},
    {'name': "Pyramid Island: Pipe outfit",
        'stage': Stages.PI3,
        'game_id': "PufferGirlOutfit3"},
    {'name': "Pyramid Island: Trash outfit",
        'stage': Stages.PI3,
        'game_id': "PufferGirlOutfit4"},
    {'name': "Pyramid Island: Pyramid top CD",
        'stage': Stages.PI4,
        'game_id': "MusicTrack_BigCityLife"},
    {'name': "Pyramid Island: Pyramid top Robo Post CD",
        'stage': Stages.PI4,
        'game_id': "MusicTrack_Chapter3Mixtape"},
    {'name': "Pyramid Island: Maze outfit",
        'stage': Stages.PIO,
        'game_id': "VinylOutfit4"},
    {'name': "Pyramid Island: Rise joins the crew",
        'stage': Stages.PI4,
        'game_id': "pufferGirl"},
    {'name': "Pyramid Island: Devil Theory joins the crew",
        'stage': Stages.PI3,
        'game_id': "boarder"},
    {'name': "Pyramid Island: Polo pile 1",
        'stage': Stages.PI1,
        'game_id': "Secret01Trash/Mascot_Polo_sit_big_wave"},
    {'name': "Pyramid Island: Polo pile 2",
        'stage': Stages.PI1,
        'game_id': "Secret01Trash/Mascot_Polo_sit_big_wave (1)"},
    {'name': "Pyramid Island: Polo pile 3",
        'stage': Stages.PI1,
        'game_id': "Secret01Trash/Mascot_Polo_sit_big_wave (2)"},
    {'name': "Pyramid Island: Polo pile 4",
        'stage': Stages.PI1,
        'game_id': "Secret01Trash/Mascot_Polo_sit_big_wave (3)"},
    {'name': "Pyramid Island: Maze glass Polo",
        'stage': Stages.PIO,
        'game_id': "Start/Mascot_Polo_sit_big (1)"},
    {'name': "Pyramid Island: Maze classroom Polo",
        'stage': Stages.PIO,
        'game_id': "PeteRoom/Mascot_Polo_sit_big_wave (1)"},
    {'name': "Pyramid Island: Maze vent Polo",
        'stage': Stages.PIO,
        'game_id': "CheckerRoom/Mascot_Polo_street"},
    {'name': "Pyramid Island: Big maze Polo",
        'stage': Stages.PIO,
        'game_id': "YellowPoloRoom/Mascot_Polo_sit_big"},
    {'name': "Pyramid Island: Maze desk Polo",
        'stage': Stages.PIO,
        'game_id': "PoloRoom/Mascot_Polo_sit_big"},
    {'name': "Pyramid Island: Maze forklift Polo",
        'stage': Stages.PIO,
        'game_id': "ForkliftRoom/Mascot_Polo_sit_big_wave"},

    {'name': "Mataan: Robo Post graffiti",
        'stage': Stages.MA1,
        'game_id': "UnlockGraffiti_grafTex_XL17"},
    {'name': "Mataan: Secret ledge BMX",
        'stage': Stages.MA1,
        'game_id': "BMXBike9"},
    {'name': "Mataan: Highway rooftop BMX",
        'stage': Stages.MA1,
        'game_id': "BMXBike10"},
    {'name': "Mataan: Trash CD",
        'stage': Stages.MA2,
        'game_id': "MusicTrack_JackDaFunk"},
    {'name': "Mataan: Half pipe CD",
        'stage': Stages.MA2,
        'game_id': "MusicTrack_FunkExpress"},
    {'name': "Mataan: Across bull horns graffiti",
        'stage': Stages.MA2,
        'game_id': "UnlockGraffiti_grafTex_L17"},
    {'name': "Mataan: Small rooftop graffiti",
        'stage': Stages.MA2,
        'game_id': "UnlockGraffiti_grafTex_M18"},
    {'name': "Mataan: Trash graffiti",
        'stage': Stages.MA2,
        'game_id': "UnlockGraffiti_grafTex_XL5"},
    {'name': "Mataan: Deep city Robo Post CD",
        'stage': Stages.MA3,
        'game_id': "MusicTrack_LastHoorah"},
    {'name': "Mataan: Deep city tower CD",
        'stage': Stages.MA3,
        'game_id': "MusicTrack_Chapter4Mixtape"},
    {'name': "Mataan: Race challenge reward",
        'stage': Stages.MA3,
        'game_id': "UnlockGraffiti_grafTex_M14"},
    {'name': "Mataan: Wallrunning challenge reward",
        'stage': Stages.MA3,
        'game_id': "UnlockGraffiti_grafTex_L14"},
    {'name': "Mataan: Score challenge reward",
        'stage': Stages.MA3,
        'game_id': "UnlockGraffiti_grafTex_XL13"},
    {'name': "Mataan: Deep city vent jump BMX",
        'stage': Stages.MA3,
        'game_id': "BMXBike4"},
    {'name': "Mataan: Deep city side wires outfit",
        'stage': Stages.MA3,
        'game_id': "DummyOutfit3"},
    {'name': "Mataan: Deep city center island outfit",
        'stage': Stages.MA3,
        'game_id': "DummyOutfit4"},
    {'name': "Mataan: Red light rail graffiti",
        'stage': Stages.MAO,
        'game_id': "UnlockGraffiti_grafTex_XL18"},
    {'name': "Mataan: Red light side alley outfit",
        'stage': Stages.MAO,
        'game_id': "RingDudeOutfit3"},
    {'name': "Mataan: Statue hand outfit",
        'stage': Stages.MA4,
        'game_id': "RingDudeOutfit4"},
    {'name': "Mataan: Crane CD",
        'stage': Stages.MA5,
        'game_id': "MusicTrack_InThePocket"},
    {'name': "Mataan: Elephant tower glass outfit",
        'stage': Stages.MA5,
        'game_id': "LegendFaceOutfit3"},
    {'name': "Mataan: Helipad outfit",
        'stage': Stages.MA5,
        'game_id': "LegendFaceOutfit4"},
    {'name': "Mataan: Vending machine CD",
        'stage': Stages.MA5,
        'game_id': "MusicTrack_Iridium"},
    {'name': "Mataan: Coil joins the crew",
        'stage': Stages.MA5,
        'game_id': "ringdude"},
    {'name': "Mataan: Flesh Prince joins the crew",
        'stage': Stages.MA5,
        'game_id': "prince"},
    {'name': "Mataan: Futurism joins the crew",
        'stage': Stages.MA5,
        'game_id': "futureGirl"},
    {'name': "Mataan: Trash Polo",
        'stage': Stages.MA2,
        'game_id': "PropsMallArea/Mascot_Polo_street"},
    {'name': "Mataan: Shopping Polo",
        'stage': Stages.MA5,
        'game_id': "propsMarket/Mascot_Polo_street"},

    {'name': "Tagged 5 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf5"},
    {'name': "Tagged 10 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf10"},
    {'name': "Tagged 15 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf15"},
    {'name': "Tagged 20 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf20"},
    {'name': "Tagged 25 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf25"},
    {'name': "Tagged 30 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf30"},
    {'name': "Tagged 35 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf35"},
    {'name': "Tagged 40 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf40"},
    {'name': "Tagged 45 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf45"},
    {'name': "Tagged 50 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf50"},
    {'name': "Tagged 55 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf55"},
    {'name': "Tagged 60 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf60"},
    {'name': "Tagged 65 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf65"},
    {'name': "Tagged 70 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf70"},
    {'name': "Tagged 75 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf75"},
    {'name': "Tagged 80 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf80"},
    {'name': "Tagged 85 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf85"},
    {'name': "Tagged 90 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf90"},
    {'name': "Tagged 95 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf95"},
    {'name': "Tagged 100 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf100"},
    {'name': "Tagged 105 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf105"},
    {'name': "Tagged 110 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf110"},
    {'name': "Tagged 115 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf115"},
    {'name': "Tagged 120 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf120"},
    {'name': "Tagged 125 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf125"},
    {'name': "Tagged 130 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf130"},
    {'name': "Tagged 135 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf135"},
    {'name': "Tagged 140 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf140"},
    {'name': "Tagged 145 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf145"},
    {'name': "Tagged 150 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf150"},
    {'name': "Tagged 155 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf155"},
    {'name': "Tagged 160 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf160"},
    {'name': "Tagged 165 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf165"},
    {'name': "Tagged 170 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf170"},
    {'name': "Tagged 175 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf175"},
    {'name': "Tagged 180 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf180"},
    {'name': "Tagged 185 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf185"},
    {'name': "Tagged 190 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf190"},
    {'name': "Tagged 195 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf195"},
    {'name': "Tagged 200 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf200"},
    {'name': "Tagged 205 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf205"},
    {'name': "Tagged 210 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf210"},
    {'name': "Tagged 215 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf215"},
    {'name': "Tagged 220 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf220"},
    {'name': "Tagged 225 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf225"},
    {'name': "Tagged 230 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf230"},
    {'name': "Tagged 235 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf235"},
    {'name': "Tagged 240 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf240"},
    {'name': "Tagged 245 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf245"},
    {'name': "Tagged 250 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf250"},
    {'name': "Tagged 255 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf255"},
    {'name': "Tagged 260 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf260"},
    {'name': "Tagged 265 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf265"},
    {'name': "Tagged 270 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf270"},
    {'name': "Tagged 275 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf275"},
    {'name': "Tagged 280 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf280"},
    {'name': "Tagged 285 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf285"},
    {'name': "Tagged 290 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf290"},
    {'name': "Tagged 295 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf295"},
    {'name': "Tagged 300 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf300"},
    {'name': "Tagged 305 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf305"},
    {'name': "Tagged 310 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf310"},
    {'name': "Tagged 315 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf315"},
    {'name': "Tagged 320 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf320"},
    {'name': "Tagged 325 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf325"},
    {'name': "Tagged 330 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf330"},
    {'name': "Tagged 335 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf335"},
    {'name': "Tagged 340 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf340"},
    {'name': "Tagged 345 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf345"},
    {'name': "Tagged 350 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf350"},
    {'name': "Tagged 355 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf355"},
    {'name': "Tagged 360 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf360"},
    {'name': "Tagged 365 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf365"},
    {'name': "Tagged 370 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf370"},
    {'name': "Tagged 375 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf375"},
    {'name': "Tagged 380 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf380"},
    {'name': "Tagged 385 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf385"},
    {'name': "Tagged 389 Graffiti Spots",
        'stage': Stages.Misc,
        'game_id': "graf389"},
]


event_table: List[EventDict] = [
    {'name': "Versum Hill: Complete Chapter 1",
        'stage': Stages.VH4,
        'item': "Chapter Completed"},
    {'name': "Brink Terminal: Complete Chapter 2",
        'stage': Stages.BT3,
        'item': "Chapter Completed"},
    {'name': "Millennium Mall: Complete Chapter 3",
        'stage': Stages.MM3,
        'item': "Chapter Completed"},
    {'name': "Pyramid Island: Complete Chapter 4",
        'stage': Stages.PI3,
        'item': "Chapter Completed"},
    {'name': "Defeat Faux",
        'stage': Stages.MA5,
        'item': "Victory"},
]